// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__24383){
var map__24384 = p__24383;
var map__24384__$1 = cljs.core.__destructure_map.call(null,map__24384);
var parsed_query = map__24384__$1;
var select = cljs.core.get.call(null,map__24384__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.call(null,map__24384__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db.call(null,db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__24385){
var map__24386 = p__24385;
var map__24386__$1 = cljs.core.__destructure_map.call(null,map__24386);
var opts = map__24386__$1;
var rdf_type_QMARK_ = cljs.core.get.call(null,map__24386__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.call(null,map__24386__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24430){
var state_val_24431 = (state_24430[(1)]);
if((state_val_24431 === (7))){
var inst_24409 = (state_24430[(7)]);
var inst_24411 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,inst_24409);
var state_24430__$1 = state_24430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24430__$1,(10),inst_24411);
} else {
if((state_val_24431 === (1))){
var inst_24394 = vars;
var inst_24395 = cljs.core.seq.call(null,inst_24394);
var inst_24396 = cljs.core.first.call(null,inst_24395);
var inst_24397 = cljs.core.next.call(null,inst_24395);
var inst_24398 = cljs.core.PersistentVector.EMPTY;
var inst_24399 = inst_24394;
var inst_24400 = inst_24398;
var state_24430__$1 = (function (){var statearr_24432 = state_24430;
(statearr_24432[(8)] = inst_24396);

(statearr_24432[(9)] = inst_24397);

(statearr_24432[(10)] = inst_24400);

(statearr_24432[(11)] = inst_24399);

return statearr_24432;
})();
var statearr_24433_24451 = state_24430__$1;
(statearr_24433_24451[(2)] = null);

(statearr_24433_24451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (4))){
var inst_24406 = (state_24430[(12)]);
var inst_24409 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24406);
var state_24430__$1 = (function (){var statearr_24434 = state_24430;
(statearr_24434[(7)] = inst_24409);

return statearr_24434;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_24435_24452 = state_24430__$1;
(statearr_24435_24452[(1)] = (7));

} else {
var statearr_24436_24453 = state_24430__$1;
(statearr_24436_24453[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (6))){
var inst_24426 = (state_24430[(2)]);
var state_24430__$1 = state_24430;
var statearr_24437_24454 = state_24430__$1;
(statearr_24437_24454[(2)] = inst_24426);

(statearr_24437_24454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (3))){
var inst_24428 = (state_24430[(2)]);
var state_24430__$1 = state_24430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24430__$1,inst_24428);
} else {
if((state_val_24431 === (2))){
var inst_24406 = (state_24430[(12)]);
var inst_24399 = (state_24430[(11)]);
var inst_24405 = cljs.core.seq.call(null,inst_24399);
var inst_24406__$1 = cljs.core.first.call(null,inst_24405);
var inst_24407 = cljs.core.next.call(null,inst_24405);
var state_24430__$1 = (function (){var statearr_24438 = state_24430;
(statearr_24438[(13)] = inst_24407);

(statearr_24438[(12)] = inst_24406__$1);

return statearr_24438;
})();
if(cljs.core.truth_(inst_24406__$1)){
var statearr_24439_24455 = state_24430__$1;
(statearr_24439_24455[(1)] = (4));

} else {
var statearr_24440_24456 = state_24430__$1;
(statearr_24440_24456[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (11))){
var inst_24418 = (state_24430[(2)]);
var inst_24419 = fluree.db.util.async.throw_err.call(null,inst_24418);
var state_24430__$1 = state_24430;
var statearr_24441_24457 = state_24430__$1;
(statearr_24441_24457[(2)] = inst_24419);

(statearr_24441_24457[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (9))){
var inst_24407 = (state_24430[(13)]);
var inst_24400 = (state_24430[(10)]);
var inst_24421 = (state_24430[(2)]);
var inst_24422 = cljs.core.into.call(null,inst_24400,inst_24421);
var inst_24399 = inst_24407;
var inst_24400__$1 = inst_24422;
var state_24430__$1 = (function (){var statearr_24442 = state_24430;
(statearr_24442[(10)] = inst_24400__$1);

(statearr_24442[(11)] = inst_24399);

return statearr_24442;
})();
var statearr_24443_24458 = state_24430__$1;
(statearr_24443_24458[(2)] = null);

(statearr_24443_24458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (5))){
var inst_24400 = (state_24430[(10)]);
var state_24430__$1 = state_24430;
var statearr_24444_24459 = state_24430__$1;
(statearr_24444_24459[(2)] = inst_24400);

(statearr_24444_24459[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (10))){
var inst_24413 = (state_24430[(2)]);
var inst_24414 = fluree.db.util.async.throw_err.call(null,inst_24413);
var state_24430__$1 = state_24430;
var statearr_24445_24460 = state_24430__$1;
(statearr_24445_24460[(2)] = inst_24414);

(statearr_24445_24460[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24431 === (8))){
var inst_24409 = (state_24430[(7)]);
var inst_24416 = fluree.db.query.subject_crawl.subject.subj_crawl.call(null,inst_24409);
var state_24430__$1 = state_24430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24430__$1,(11),inst_24416);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0 = (function (){
var statearr_24446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24446[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__);

(statearr_24446[(1)] = (1));

return statearr_24446;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1 = (function (state_24430){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24447){var ex__2749__auto__ = e24447;
var statearr_24448_24461 = state_24430;
(statearr_24448_24461[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24430[(4)]))){
var statearr_24449_24462 = state_24430;
(statearr_24449_24462[(1)] = cljs.core.first.call(null,(state_24430[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24463 = state_24430;
state_24430 = G__24463;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__ = function(state_24430){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1.call(this,state_24430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24450 = f__2769__auto__.call(null);
(statearr_24450[(6)] = c__2768__auto__);

return statearr_24450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__24465){
var map__24466 = p__24465;
var map__24466__$1 = cljs.core.__destructure_map.call(null,map__24466);
var parsed_query = map__24466__$1;
var selectOne_QMARK_ = cljs.core.get.call(null,map__24466__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.call(null,map__24466__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.call(null,map__24466__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var limit = cljs.core.get.call(null,map__24466__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var fns = (function (){var G__24467 = cljs.core.PersistentVector.EMPTY;
var G__24467__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.call(null,G__24467,(function (result){
return cljs.core.first.call(null,result);
})):G__24467);
var G__24467__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.call(null,G__24467__$1,(function (){var select_var = cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.call(null,(function (p1__24464_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__24464_SHARP_]);
}),result);
});
})()):G__24467__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.call(null,G__24467__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results.call(null,result,order_by,limit);
}));
} else {
return G__24467__$2;
}
})();
if(cljs.core.empty_QMARK_.call(null,fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.call(null,cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__24468){
var map__24469 = p__24468;
var map__24469__$1 = cljs.core.__destructure_map.call(null,map__24469);
var parsed_query = map__24469__$1;
var vars = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var order_by = cljs.core.get.call(null,map__24469__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var error_ch = cljs.core.async.chan.call(null);
var f_where = cljs.core.first.call(null,where);
var rdf_type_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,where));
var cache = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_.call(null,(0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec.call(null,db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn.call(null,parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,(cljs.core.truth_(order_by)?(9007199254740991):limit),offset,db,error_ch,cljs.core.not.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding.call(null,opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl.call(null,opts);
}
}
});
