// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14968 = match;
var p1 = cljs.core.nth.call(null,vec__14968,(0),null);
var p2 = cljs.core.nth.call(null,vec__14968,(1),null);
var p3 = cljs.core.nth.call(null,vec__14968,(2),null);
var p4 = cljs.core.nth.call(null,vec__14968,(3),null);
var op = cljs.core.nth.call(null,vec__14968,(4),null);
var m = cljs.core.nth.call(null,vec__14968,(5),null);
var G__14971 = idx;
var G__14971__$1 = (((G__14971 instanceof cljs.core.Keyword))?G__14971.fqn:null);
switch (G__14971__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate.call(null,db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14971__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14973 = idx;
var G__14973__$1 = (((G__14973 instanceof cljs.core.Keyword))?G__14973.fqn:null);
switch (G__14973__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14973__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14975 = idx;
var G__14975__$1 = (((G__14975 instanceof cljs.core.Keyword))?G__14975.fqn:null);
switch (G__14975__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14975__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.call(null);
if(cljs.core.not.call(null,id)){
cljs.core.async.close_BANG_.call(null,out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_.call(null,id)){
cljs.core.async.pipe.call(null,fluree.db.dbproto._subid.call(null,db,id),out);
} else {
cljs.core.async.put_BANG_.call(null,out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15015){
var state_val_15016 = (state_15015[(1)]);
if((state_val_15016 === (7))){
var inst_14992 = (state_15015[(7)]);
var inst_14999 = (state_15015[(2)]);
var inst_15000 = fluree.db.util.async.throw_err.call(null,inst_14999);
var state_15015__$1 = (function (){var statearr_15017 = state_15015;
(statearr_15017[(8)] = inst_15000);

return statearr_15017;
})();
if(cljs.core.truth_(inst_14992)){
var statearr_15018_15042 = state_15015__$1;
(statearr_15018_15042[(1)] = (8));

} else {
var statearr_15019_15043 = state_15015__$1;
(statearr_15019_15043[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (1))){
var state_15015__$1 = state_15015;
var statearr_15020_15044 = state_15015__$1;
(statearr_15020_15044[(2)] = null);

(statearr_15020_15044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (4))){
var inst_14977 = (state_15015[(2)]);
var state_15015__$1 = state_15015;
var statearr_15021_15045 = state_15015__$1;
(statearr_15021_15045[(2)] = inst_14977);

(statearr_15021_15045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (13))){
var inst_15007 = (state_15015[(2)]);
var state_15015__$1 = state_15015;
var statearr_15022_15046 = state_15015__$1;
(statearr_15022_15046[(2)] = inst_15007);

(statearr_15022_15046[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (6))){
var inst_14989 = (state_15015[(9)]);
var inst_14995 = (state_15015[(2)]);
var inst_14996 = fluree.db.util.async.throw_err.call(null,inst_14995);
var inst_14997 = fluree.db.query.range.resolve_subid.call(null,db,inst_14989);
var state_15015__$1 = (function (){var statearr_15023 = state_15015;
(statearr_15023[(10)] = inst_14996);

return statearr_15023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15015__$1,(7),inst_14997);
} else {
if((state_val_15016 === (3))){
var inst_15013 = (state_15015[(2)]);
var state_15015__$1 = state_15015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15015__$1,inst_15013);
} else {
if((state_val_15016 === (12))){
var state_15015__$1 = state_15015;
var statearr_15024_15047 = state_15015__$1;
(statearr_15024_15047[(2)] = (2147483647));

(statearr_15024_15047[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (2))){
var _ = (function (){var statearr_15025 = state_15015;
(statearr_15025[(4)] = cljs.core.cons.call(null,(5),(state_15015[(4)])));

return statearr_15025;
})();
var inst_14986 = parts;
var inst_14987 = cljs.core.nth.call(null,inst_14986,(0),null);
var inst_14988 = cljs.core.nth.call(null,inst_14986,(1),null);
var inst_14989 = cljs.core.nth.call(null,inst_14986,(2),null);
var inst_14990 = cljs.core.nth.call(null,inst_14986,(3),null);
var inst_14991 = cljs.core.nth.call(null,inst_14986,(4),null);
var inst_14992 = cljs.core.nth.call(null,inst_14986,(5),null);
var inst_14993 = fluree.db.query.range.resolve_subid.call(null,db,inst_14987);
var state_15015__$1 = (function (){var statearr_15026 = state_15015;
(statearr_15026[(11)] = inst_14990);

(statearr_15026[(12)] = inst_14991);

(statearr_15026[(9)] = inst_14989);

(statearr_15026[(13)] = inst_14988);

(statearr_15026[(7)] = inst_14992);

return statearr_15026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15015__$1,(6),inst_14993);
} else {
if((state_val_15016 === (11))){
var state_15015__$1 = state_15015;
var statearr_15028_15048 = state_15015__$1;
(statearr_15028_15048[(2)] = (-2147483647));

(statearr_15028_15048[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (9))){
var inst_15003 = (cljs.core._GT__EQ_ === test);
var state_15015__$1 = state_15015;
if(cljs.core.truth_(inst_15003)){
var statearr_15029_15049 = state_15015__$1;
(statearr_15029_15049[(1)] = (11));

} else {
var statearr_15030_15050 = state_15015__$1;
(statearr_15030_15050[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (5))){
var _ = (function (){var statearr_15031 = state_15015;
(statearr_15031[(4)] = cljs.core.rest.call(null,(state_15015[(4)])));

return statearr_15031;
})();
var state_15015__$1 = state_15015;
var ex15027 = (state_15015__$1[(2)]);
var statearr_15032_15051 = state_15015__$1;
(statearr_15032_15051[(5)] = ex15027);


if((ex15027 instanceof Error)){
var statearr_15033_15052 = state_15015__$1;
(statearr_15033_15052[(1)] = (4));

(statearr_15033_15052[(5)] = null);

} else {
throw ex15027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (10))){
var inst_14990 = (state_15015[(11)]);
var inst_14991 = (state_15015[(12)]);
var inst_14988 = (state_15015[(13)]);
var inst_15000 = (state_15015[(8)]);
var inst_14996 = (state_15015[(10)]);
var inst_15009 = (state_15015[(2)]);
var inst_15010 = fluree.db.flake.__GT_Flake.call(null,inst_14996,inst_14988,inst_15000,inst_14990,inst_14991,inst_15009);
var _ = (function (){var statearr_15034 = state_15015;
(statearr_15034[(4)] = cljs.core.rest.call(null,(state_15015[(4)])));

return statearr_15034;
})();
var state_15015__$1 = state_15015;
var statearr_15035_15053 = state_15015__$1;
(statearr_15035_15053[(2)] = inst_15010);

(statearr_15035_15053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15016 === (8))){
var inst_14992 = (state_15015[(7)]);
var state_15015__$1 = state_15015;
var statearr_15036_15054 = state_15015__$1;
(statearr_15036_15054[(2)] = inst_14992);

(statearr_15036_15054[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0 = (function (){
var statearr_15037 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15037[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__);

(statearr_15037[(1)] = (1));

return statearr_15037;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1 = (function (state_15015){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15038){var ex__2749__auto__ = e15038;
var statearr_15039_15055 = state_15015;
(statearr_15039_15055[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15015[(4)]))){
var statearr_15040_15056 = state_15015;
(statearr_15040_15056[(1)] = cljs.core.first.call(null,(state_15015[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15057 = state_15015;
state_15015 = G__15057;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__ = function(state_15015){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1.call(this,state_15015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15041 = f__2769__auto__.call(null);
(statearr_15041[(6)] = c__2768__auto__);

return statearr_15041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_.call(null,node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_.call(null,node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not.call(null,(function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__15058){
var map__15059 = p__15058;
var map__15059__$1 = cljs.core.__destructure_map.call(null,map__15059);
var subject_fn = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__15060 = cljs.core.PersistentVector.EMPTY;
var G__15060__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.call(null,G__15060,cljs.core.filter.call(null,(function (f){
return subject_fn.call(null,fluree.db.flake.s.call(null,f));
}))):G__15060);
var G__15060__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.call(null,G__15060__$1,cljs.core.filter.call(null,(function (f){
return predicate_fn.call(null,fluree.db.flake.p.call(null,f));
}))):G__15060__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.call(null,G__15060__$2,cljs.core.filter.call(null,(function (f){
return object_fn.call(null,fluree.db.flake.o.call(null,f));
})));
} else {
return G__15060__$2;
}
})();
return cljs.core.apply.call(null,cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__15061){
var map__15062 = p__15061;
var map__15062__$1 = cljs.core.__destructure_map.call(null,map__15062);
var opts = map__15062__$1;
var start_flake = cljs.core.get.call(null,map__15062__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.call(null,map__15062__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.call(null,map__15062__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.call(null,map__15062__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.call(null,(function (flakes){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter.call(null,opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__15063,root,novelty,error_ch,p__15064){
var map__15065 = p__15063;
var map__15065__$1 = cljs.core.__destructure_map.call(null,map__15065);
var conn = map__15065__$1;
var async_cache = cljs.core.get.call(null,map__15065__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__15066 = p__15064;
var map__15066__$1 = cljs.core.__destructure_map.call(null,map__15066);
var opts = map__15066__$1;
var from_t = cljs.core.get.call(null,map__15066__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.call(null,map__15066__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.call(null,map__15066__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__15066__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,start_flake,end_flake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes.call(null,opts);
return fluree.db.index.tree_chan.call(null,resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.call(null,f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15097){
var state_val_15098 = (state_15097[(1)]);
if((state_val_15098 === (7))){
var inst_15080 = (state_15097[(7)]);
var state_15097__$1 = state_15097;
var statearr_15099_15123 = state_15097__$1;
(statearr_15099_15123[(2)] = inst_15080);

(statearr_15099_15123[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (1))){
var state_15097__$1 = state_15097;
var statearr_15100_15124 = state_15097__$1;
(statearr_15100_15124[(2)] = null);

(statearr_15100_15124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (4))){
var inst_15067 = (state_15097[(2)]);
var inst_15068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15069 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_15070 = (new cljs.core.PersistentVector(null,3,(5),inst_15068,inst_15069,null));
var inst_15071 = cljs.core.select_keys.call(null,db,inst_15070);
var inst_15072 = fluree.db.util.log.error.call(null,inst_15067,"Error authorizing flake in ledger",inst_15071);
var state_15097__$1 = (function (){var statearr_15102 = state_15097;
(statearr_15102[(8)] = inst_15072);

return statearr_15102;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15097__$1,(5),error_ch,inst_15067);
} else {
if((state_val_15098 === (13))){
var inst_15092 = (state_15097[(2)]);
var _ = (function (){var statearr_15103 = state_15097;
(statearr_15103[(4)] = cljs.core.rest.call(null,(state_15097[(4)])));

return statearr_15103;
})();
var state_15097__$1 = state_15097;
var statearr_15104_15125 = state_15097__$1;
(statearr_15104_15125[(2)] = inst_15092);

(statearr_15104_15125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (6))){
var _ = (function (){var statearr_15105 = state_15097;
(statearr_15105[(4)] = cljs.core.rest.call(null,(state_15097[(4)])));

return statearr_15105;
})();
var state_15097__$1 = state_15097;
var ex15101 = (state_15097__$1[(2)]);
var statearr_15106_15126 = state_15097__$1;
(statearr_15106_15126[(5)] = ex15101);


var statearr_15107_15127 = state_15097__$1;
(statearr_15107_15127[(1)] = (4));

(statearr_15107_15127[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (3))){
var inst_15095 = (state_15097[(2)]);
var state_15097__$1 = state_15097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15097__$1,inst_15095);
} else {
if((state_val_15098 === (12))){
var state_15097__$1 = state_15097;
var statearr_15108_15128 = state_15097__$1;
(statearr_15108_15128[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15108_15128[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (2))){
var inst_15080 = (state_15097[(7)]);
var _ = (function (){var statearr_15109 = state_15097;
(statearr_15109[(4)] = cljs.core.cons.call(null,(6),(state_15097[(4)])));

return statearr_15109;
})();
var inst_15080__$1 = fluree.db.util.schema.is_schema_flake_QMARK_.call(null,flake);
var state_15097__$1 = (function (){var statearr_15110 = state_15097;
(statearr_15110[(7)] = inst_15080__$1);

return statearr_15110;
})();
if(inst_15080__$1){
var statearr_15111_15129 = state_15097__$1;
(statearr_15111_15129[(1)] = (7));

} else {
var statearr_15112_15130 = state_15097__$1;
(statearr_15112_15130[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (11))){
var state_15097__$1 = state_15097;
var statearr_15113_15131 = state_15097__$1;
(statearr_15113_15131[(2)] = flake);

(statearr_15113_15131[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (9))){
var inst_15088 = (state_15097[(2)]);
var state_15097__$1 = state_15097;
if(cljs.core.truth_(inst_15088)){
var statearr_15114_15132 = state_15097__$1;
(statearr_15114_15132[(1)] = (11));

} else {
var statearr_15115_15133 = state_15097__$1;
(statearr_15115_15133[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (5))){
var inst_15074 = (state_15097[(2)]);
var state_15097__$1 = state_15097;
var statearr_15116_15134 = state_15097__$1;
(statearr_15116_15134[(2)] = inst_15074);

(statearr_15116_15134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (10))){
var inst_15085 = (state_15097[(2)]);
var inst_15086 = fluree.db.util.async.throw_err.call(null,inst_15085);
var state_15097__$1 = state_15097;
var statearr_15117_15135 = state_15097__$1;
(statearr_15117_15135[(2)] = inst_15086);

(statearr_15117_15135[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15098 === (8))){
var inst_15083 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,flake);
var state_15097__$1 = state_15097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15097__$1,(10),inst_15083);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0 = (function (){
var statearr_15118 = [null,null,null,null,null,null,null,null,null];
(statearr_15118[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__);

(statearr_15118[(1)] = (1));

return statearr_15118;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1 = (function (state_15097){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15119){var ex__2749__auto__ = e15119;
var statearr_15120_15136 = state_15097;
(statearr_15120_15136[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15097[(4)]))){
var statearr_15121_15137 = state_15097;
(statearr_15121_15137[(1)] = cljs.core.first.call(null,(state_15097[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15138 = state_15097;
state_15097 = G__15138;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__ = function(state_15097){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1.call(this,state_15097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15122 = f__2769__auto__.call(null);
(statearr_15122[(6)] = c__2768__auto__);

return statearr_15122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.call(null,(function() { 
var G__15139__delegate = function (fs){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15139 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15140__i = 0, G__15140__a = new Array(arguments.length -  0);
while (G__15140__i < G__15140__a.length) {G__15140__a[G__15140__i] = arguments[G__15140__i + 0]; ++G__15140__i;}
  fs = new cljs.core.IndexedSeq(G__15140__a,0,null);
} 
return G__15139__delegate.call(this,fs);};
G__15139.cljs$lang$maxFixedArity = 0;
G__15139.cljs$lang$applyTo = (function (arglist__15141){
var fs = cljs.core.seq(arglist__15141);
return G__15139__delegate(fs);
});
G__15139.cljs$core$IFn$_invoke$arity$variadic = G__15139__delegate;
return G__15139;
})()
,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15142,start,end,error_ch,flake_slices){
var map__15143 = p__15142;
var map__15143__$1 = cljs.core.__destructure_map.call(null,map__15143);
var db = map__15143__$1;
var permissions = cljs.core.get.call(null,map__15143__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15144 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.call(null,fluree.db.flake.s)], null);
var G__15144__$1 = (cljs.core.truth_(offset)?cljs.core.conj.call(null,G__15144,cljs.core.drop.call(null,offset)):G__15144);
var G__15144__$2 = (cljs.core.truth_(limit)?cljs.core.conj.call(null,G__15144__$1,cljs.core.take.call(null,limit)):G__15144__$1);
return cljs.core.conj.call(null,G__15144__$2,cljs.core.cat);

})();
return cljs.core.apply.call(null,cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15145 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15145__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.call(null,G__15145,fluree.db.query.range.filter_subject_page.call(null,limit,offset)):G__15145);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.call(null,G__15145__$1,cljs.core.take.call(null,flake_limit));
} else {
return G__15145__$1;
}
})();
var page_xf = cljs.core.apply.call(null,cljs.core.comp,page_xfs);
return cljs.core.async.transduce.call(null,page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15146,error_ch,p__15147){
var map__15148 = p__15146;
var map__15148__$1 = cljs.core.__destructure_map.call(null,map__15148);
var db = map__15148__$1;
var conn = cljs.core.get.call(null,map__15148__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15149 = p__15147;
var map__15149__$1 = cljs.core.__destructure_map.call(null,map__15149);
var opts = map__15149__$1;
var idx = cljs.core.get.call(null,map__15149__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.call(null,map__15149__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__15149__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.call(null,map__15149__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__15149__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.call(null,map__15149__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.call(null,db,idx);
var idx_cmp = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page.call(null,limit,offset,flake_limit,fluree.db.query.range.filter_authorized.call(null,db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices.call(null,conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15150 = cljs.core.identical_QMARK_;
var expr__15151 = test;
if(cljs.core.truth_(pred__15150.call(null,cljs.core._EQ_,expr__15151))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15150.call(null,cljs.core._LT_,expr__15151))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__15150.call(null,cljs.core._LT__EQ_,expr__15151))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15150.call(null,cljs.core._GT_,expr__15151))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__15150.call(null,cljs.core._GT__EQ_,expr__15151))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15151)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15154 = arguments.length;
switch (G__15154) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15155 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__15155,(0),null);
var start_match = cljs.core.nth.call(null,vec__15155,(1),null);
var end_test = cljs.core.nth.call(null,vec__15155,(2),null);
var end_match = cljs.core.nth.call(null,vec__15155,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15158,idx,start_test,start_match,end_test,end_match,opts){
var map__15159 = p__15158;
var map__15159__$1 = cljs.core.__destructure_map.call(null,map__15159);
var db = map__15159__$1;
var t = cljs.core.get.call(null,map__15159__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15160 = opts;
var map__15160__$1 = cljs.core.__destructure_map.call(null,map__15160);
var limit = cljs.core.get.call(null,map__15160__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.call(null,map__15160__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.call(null,map__15160__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15222){
var state_val_15223 = (state_15222[(1)]);
if((state_val_15223 === (7))){
var inst_15175 = (state_15222[(7)]);
var inst_15179 = (state_15222[(8)]);
var inst_15170 = (state_15222[(9)]);
var inst_15173 = (state_15222[(2)]);
var inst_15174 = fluree.db.util.async.throw_err.call(null,inst_15173);
var inst_15175__$1 = cljs.core.async.chan.call(null);
var inst_15176 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15177 = [idx,from_t,to_t,start_test,inst_15170,end_test,inst_15174,limit];
var inst_15178 = cljs.core.PersistentHashMap.fromArrays(inst_15176,inst_15177);
var inst_15179__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_15175__$1,inst_15178);
var inst_15187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15188 = [inst_15175__$1,inst_15179__$1];
var inst_15189 = (new cljs.core.PersistentVector(null,2,(5),inst_15187,inst_15188,null));
var state_15222__$1 = (function (){var statearr_15224 = state_15222;
(statearr_15224[(7)] = inst_15175__$1);

(statearr_15224[(8)] = inst_15179__$1);

return statearr_15224;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15222__$1,(8),inst_15189);
} else {
if((state_val_15223 === (1))){
var state_15222__$1 = state_15222;
var statearr_15225_15254 = state_15222__$1;
(statearr_15225_15254[(2)] = null);

(statearr_15225_15254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (4))){
var inst_15161 = (state_15222[(2)]);
var state_15222__$1 = state_15222;
var statearr_15226_15255 = state_15222__$1;
(statearr_15226_15255[(2)] = inst_15161);

(statearr_15226_15255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (15))){
var inst_15192 = (state_15222[(10)]);
var state_15222__$1 = state_15222;
var statearr_15227_15256 = state_15222__$1;
(statearr_15227_15256[(2)] = inst_15192);

(statearr_15227_15256[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (13))){
var inst_15193 = (state_15222[(11)]);
var inst_15209 = cljs.core._EQ_.call(null,inst_15193,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15222__$1 = state_15222;
if(inst_15209){
var statearr_15228_15257 = state_15222__$1;
(statearr_15228_15257[(1)] = (15));

} else {
var statearr_15229_15258 = state_15222__$1;
(statearr_15229_15258[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (6))){
var inst_15169 = (state_15222[(2)]);
var inst_15170 = fluree.db.util.async.throw_err.call(null,inst_15169);
var inst_15171 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,end_parts);
var state_15222__$1 = (function (){var statearr_15230 = state_15222;
(statearr_15230[(9)] = inst_15170);

return statearr_15230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15222__$1,(7),inst_15171);
} else {
if((state_val_15223 === (17))){
var inst_15213 = (state_15222[(2)]);
var state_15222__$1 = state_15222;
var statearr_15231_15259 = state_15222__$1;
(statearr_15231_15259[(2)] = inst_15213);

(statearr_15231_15259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (3))){
var inst_15220 = (state_15222[(2)]);
var state_15222__$1 = state_15222;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15222__$1,inst_15220);
} else {
if((state_val_15223 === (12))){
var inst_15191 = (state_15222[(12)]);
var inst_15207 = cljs.core.nth.call(null,inst_15191,(0),null);
var state_15222__$1 = state_15222;
var statearr_15232_15260 = state_15222__$1;
(statearr_15232_15260[(2)] = inst_15207);

(statearr_15232_15260[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (2))){
var _ = (function (){var statearr_15233 = state_15222;
(statearr_15233[(4)] = cljs.core.cons.call(null,(5),(state_15222[(4)])));

return statearr_15233;
})();
var inst_15167 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,start_parts);
var state_15222__$1 = state_15222;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15222__$1,(6),inst_15167);
} else {
if((state_val_15223 === (11))){
var inst_15217 = (state_15222[(2)]);
var _ = (function (){var statearr_15235 = state_15222;
(statearr_15235[(4)] = cljs.core.rest.call(null,(state_15222[(4)])));

return statearr_15235;
})();
var state_15222__$1 = state_15222;
var statearr_15236_15261 = state_15222__$1;
(statearr_15236_15261[(2)] = inst_15217);

(statearr_15236_15261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (9))){
var inst_15191 = (state_15222[(12)]);
var inst_15199 = cljs.core.nth.call(null,inst_15191,(0),null);
var inst_15200 = (function(){throw inst_15199})();
var state_15222__$1 = state_15222;
var statearr_15237_15262 = state_15222__$1;
(statearr_15237_15262[(2)] = inst_15200);

(statearr_15237_15262[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (5))){
var _ = (function (){var statearr_15238 = state_15222;
(statearr_15238[(4)] = cljs.core.rest.call(null,(state_15222[(4)])));

return statearr_15238;
})();
var state_15222__$1 = state_15222;
var ex15234 = (state_15222__$1[(2)]);
var statearr_15239_15263 = state_15222__$1;
(statearr_15239_15263[(5)] = ex15234);


if((ex15234 instanceof Error)){
var statearr_15240_15264 = state_15222__$1;
(statearr_15240_15264[(1)] = (4));

(statearr_15240_15264[(5)] = null);

} else {
throw ex15234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (14))){
var inst_15215 = (state_15222[(2)]);
var state_15222__$1 = state_15222;
var statearr_15241_15265 = state_15222__$1;
(statearr_15241_15265[(2)] = inst_15215);

(statearr_15241_15265[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (16))){
var state_15222__$1 = state_15222;
var statearr_15242_15266 = state_15222__$1;
(statearr_15242_15266[(2)] = null);

(statearr_15242_15266[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (10))){
var inst_15179 = (state_15222[(8)]);
var inst_15193 = (state_15222[(11)]);
var inst_15202 = cljs.core._EQ_.call(null,inst_15193,inst_15179);
var state_15222__$1 = state_15222;
if(inst_15202){
var statearr_15243_15267 = state_15222__$1;
(statearr_15243_15267[(1)] = (12));

} else {
var statearr_15244_15268 = state_15222__$1;
(statearr_15244_15268[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15223 === (8))){
var inst_15175 = (state_15222[(7)]);
var inst_15191 = (state_15222[(12)]);
var inst_15193 = (state_15222[(11)]);
var inst_15191__$1 = (state_15222[(2)]);
var inst_15192 = cljs.core.nth.call(null,inst_15191__$1,(0),null);
var inst_15193__$1 = cljs.core.nth.call(null,inst_15191__$1,(1),null);
var inst_15194 = cljs.core._EQ_.call(null,inst_15193__$1,inst_15175);
var state_15222__$1 = (function (){var statearr_15245 = state_15222;
(statearr_15245[(10)] = inst_15192);

(statearr_15245[(12)] = inst_15191__$1);

(statearr_15245[(11)] = inst_15193__$1);

return statearr_15245;
})();
if(inst_15194){
var statearr_15246_15269 = state_15222__$1;
(statearr_15246_15269[(1)] = (9));

} else {
var statearr_15247_15270 = state_15222__$1;
(statearr_15247_15270[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15248 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15248[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15248[(1)] = (1));

return statearr_15248;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15222){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15222);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15249){var ex__2749__auto__ = e15249;
var statearr_15250_15271 = state_15222;
(statearr_15250_15271[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15222[(4)]))){
var statearr_15251_15272 = state_15222;
(statearr_15251_15272[(1)] = cljs.core.first.call(null,(state_15222[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15273 = state_15222;
state_15222 = G__15273;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15222){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15252 = f__2769__auto__.call(null);
(statearr_15252[(6)] = c__2768__auto__);

return statearr_15252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15275 = arguments.length;
switch (G__15275) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15276 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__15276,(0),null);
var start_match = cljs.core.nth.call(null,vec__15276,(1),null);
var end_test = cljs.core.nth.call(null,vec__15276,(2),null);
var end_match = cljs.core.nth.call(null,vec__15276,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15279,idx,start_test,start_match,end_test,end_match,p__15280){
var map__15281 = p__15279;
var map__15281__$1 = cljs.core.__destructure_map.call(null,map__15281);
var db = map__15281__$1;
var permissions = cljs.core.get.call(null,map__15281__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.call(null,map__15281__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15282 = p__15280;
var map__15282__$1 = cljs.core.__destructure_map.call(null,map__15282);
var opts = map__15282__$1;
var object_fn = cljs.core.get.call(null,map__15282__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15283 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var s1 = cljs.core.nth.call(null,vec__15283,(0),null);
var p1 = cljs.core.nth.call(null,vec__15283,(1),null);
var o1 = cljs.core.nth.call(null,vec__15283,(2),null);
var t1 = cljs.core.nth.call(null,vec__15283,(3),null);
var op1 = cljs.core.nth.call(null,vec__15283,(4),null);
var m1 = cljs.core.nth.call(null,vec__15283,(5),null);
var vec__15286 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var s2 = cljs.core.nth.call(null,vec__15286,(0),null);
var p2 = cljs.core.nth.call(null,vec__15286,(1),null);
var o2 = cljs.core.nth.call(null,vec__15286,(2),null);
var t2 = cljs.core.nth.call(null,vec__15286,(3),null);
var op2 = cljs.core.nth.call(null,vec__15286,(4),null);
var m2 = cljs.core.nth.call(null,vec__15286,(5),null);
var vec__15289 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_.call(null,o1))?o1:((cljs.core.boolean_QMARK_.call(null,o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.call(null,o,bool);
})], null);
}
})();
var vec__15292 = cljs.core.nth.call(null,vec__15289,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__15292,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__15292,(1),null);
var object_fn__$1 = cljs.core.nth.call(null,vec__15289,(1),null);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15360){
var state_val_15361 = (state_15360[(1)]);
if((state_val_15361 === (7))){
var inst_15307 = (state_15360[(7)]);
var inst_15315 = (state_15360[(8)]);
var inst_15317 = (state_15360[(9)]);
var inst_15313 = (state_15360[(2)]);
var inst_15314 = fluree.db.util.async.throw_err.call(null,inst_15313);
var inst_15315__$1 = cljs.core.async.chan.call(null);
var inst_15316 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15307,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15314,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1);
var inst_15317__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_15315__$1,inst_15316);
var inst_15325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15326 = [inst_15315__$1,inst_15317__$1];
var inst_15327 = (new cljs.core.PersistentVector(null,2,(5),inst_15325,inst_15326,null));
var state_15360__$1 = (function (){var statearr_15362 = state_15360;
(statearr_15362[(8)] = inst_15315__$1);

(statearr_15362[(9)] = inst_15317__$1);

return statearr_15362;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15360__$1,(8),inst_15327);
} else {
if((state_val_15361 === (1))){
var state_15360__$1 = state_15360;
var statearr_15363_15392 = state_15360__$1;
(statearr_15363_15392[(2)] = null);

(statearr_15363_15392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (4))){
var inst_15295 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15364_15393 = state_15360__$1;
(statearr_15364_15393[(2)] = inst_15295);

(statearr_15364_15393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (15))){
var inst_15330 = (state_15360[(10)]);
var state_15360__$1 = state_15360;
var statearr_15365_15394 = state_15360__$1;
(statearr_15365_15394[(2)] = inst_15330);

(statearr_15365_15394[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (13))){
var inst_15331 = (state_15360[(11)]);
var inst_15347 = cljs.core._EQ_.call(null,inst_15331,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15360__$1 = state_15360;
if(inst_15347){
var statearr_15366_15395 = state_15360__$1;
(statearr_15366_15395[(1)] = (15));

} else {
var statearr_15367_15396 = state_15360__$1;
(statearr_15367_15396[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (6))){
var inst_15306 = (state_15360[(2)]);
var inst_15307 = fluree.db.util.async.throw_err.call(null,inst_15306);
var inst_15308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15309 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15310 = (new cljs.core.PersistentVector(null,6,(5),inst_15308,inst_15309,null));
var inst_15311 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,inst_15310);
var state_15360__$1 = (function (){var statearr_15368 = state_15360;
(statearr_15368[(7)] = inst_15307);

return statearr_15368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15360__$1,(7),inst_15311);
} else {
if((state_val_15361 === (17))){
var inst_15351 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15369_15397 = state_15360__$1;
(statearr_15369_15397[(2)] = inst_15351);

(statearr_15369_15397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (3))){
var inst_15358 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15360__$1,inst_15358);
} else {
if((state_val_15361 === (12))){
var inst_15329 = (state_15360[(12)]);
var inst_15345 = cljs.core.nth.call(null,inst_15329,(0),null);
var state_15360__$1 = state_15360;
var statearr_15370_15398 = state_15360__$1;
(statearr_15370_15398[(2)] = inst_15345);

(statearr_15370_15398[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (2))){
var _ = (function (){var statearr_15371 = state_15360;
(statearr_15371[(4)] = cljs.core.cons.call(null,(5),(state_15360[(4)])));

return statearr_15371;
})();
var inst_15301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15302 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15303 = (new cljs.core.PersistentVector(null,6,(5),inst_15301,inst_15302,null));
var inst_15304 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,inst_15303);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15360__$1,(6),inst_15304);
} else {
if((state_val_15361 === (11))){
var inst_15355 = (state_15360[(2)]);
var _ = (function (){var statearr_15373 = state_15360;
(statearr_15373[(4)] = cljs.core.rest.call(null,(state_15360[(4)])));

return statearr_15373;
})();
var state_15360__$1 = state_15360;
var statearr_15374_15399 = state_15360__$1;
(statearr_15374_15399[(2)] = inst_15355);

(statearr_15374_15399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (9))){
var inst_15329 = (state_15360[(12)]);
var inst_15337 = cljs.core.nth.call(null,inst_15329,(0),null);
var inst_15338 = (function(){throw inst_15337})();
var state_15360__$1 = state_15360;
var statearr_15375_15400 = state_15360__$1;
(statearr_15375_15400[(2)] = inst_15338);

(statearr_15375_15400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (5))){
var _ = (function (){var statearr_15376 = state_15360;
(statearr_15376[(4)] = cljs.core.rest.call(null,(state_15360[(4)])));

return statearr_15376;
})();
var state_15360__$1 = state_15360;
var ex15372 = (state_15360__$1[(2)]);
var statearr_15377_15401 = state_15360__$1;
(statearr_15377_15401[(5)] = ex15372);


if((ex15372 instanceof Error)){
var statearr_15378_15402 = state_15360__$1;
(statearr_15378_15402[(1)] = (4));

(statearr_15378_15402[(5)] = null);

} else {
throw ex15372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (14))){
var inst_15353 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15379_15403 = state_15360__$1;
(statearr_15379_15403[(2)] = inst_15353);

(statearr_15379_15403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (16))){
var state_15360__$1 = state_15360;
var statearr_15380_15404 = state_15360__$1;
(statearr_15380_15404[(2)] = null);

(statearr_15380_15404[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (10))){
var inst_15317 = (state_15360[(9)]);
var inst_15331 = (state_15360[(11)]);
var inst_15340 = cljs.core._EQ_.call(null,inst_15331,inst_15317);
var state_15360__$1 = state_15360;
if(inst_15340){
var statearr_15381_15405 = state_15360__$1;
(statearr_15381_15405[(1)] = (12));

} else {
var statearr_15382_15406 = state_15360__$1;
(statearr_15382_15406[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (8))){
var inst_15315 = (state_15360[(8)]);
var inst_15331 = (state_15360[(11)]);
var inst_15329 = (state_15360[(12)]);
var inst_15329__$1 = (state_15360[(2)]);
var inst_15330 = cljs.core.nth.call(null,inst_15329__$1,(0),null);
var inst_15331__$1 = cljs.core.nth.call(null,inst_15329__$1,(1),null);
var inst_15332 = cljs.core._EQ_.call(null,inst_15331__$1,inst_15315);
var state_15360__$1 = (function (){var statearr_15383 = state_15360;
(statearr_15383[(10)] = inst_15330);

(statearr_15383[(11)] = inst_15331__$1);

(statearr_15383[(12)] = inst_15329__$1);

return statearr_15383;
})();
if(inst_15332){
var statearr_15384_15407 = state_15360__$1;
(statearr_15384_15407[(1)] = (9));

} else {
var statearr_15385_15408 = state_15360__$1;
(statearr_15385_15408[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15386 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15386[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15386[(1)] = (1));

return statearr_15386;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15360){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15387){var ex__2749__auto__ = e15387;
var statearr_15388_15409 = state_15360;
(statearr_15388_15409[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15360[(4)]))){
var statearr_15389_15410 = state_15360;
(statearr_15389_15410[(1)] = cljs.core.first.call(null,(state_15360[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15411 = state_15360;
state_15360 = G__15411;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15360){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15390 = f__2769__auto__.call(null);
(statearr_15390[(6)] = c__2768__auto__);

return statearr_15390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o.call(null,f))) && ((fluree.db.flake.o.call(null,f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15467){
var state_val_15468 = (state_15467[(1)]);
if((state_val_15468 === (7))){
var inst_15431 = (state_15467[(7)]);
var inst_15441 = (state_15467[(8)]);
var inst_15439 = fluree.db.flake.Flake__GT_parts.call(null,inst_15431);
var inst_15440 = cljs.core.nth.call(null,inst_15439,(0),null);
var inst_15441__$1 = cljs.core.nth.call(null,inst_15439,(1),null);
var inst_15442 = cljs.core.nth.call(null,inst_15439,(2),null);
var inst_15443 = cljs.core.nth.call(null,inst_15439,(3),null);
var inst_15444 = cljs.core.nth.call(null,inst_15439,(4),null);
var inst_15445 = cljs.core.nth.call(null,inst_15439,(5),null);
var inst_15446 = fluree.db.dbproto._tag.call(null,db,inst_15442,inst_15441__$1);
var state_15467__$1 = (function (){var statearr_15469 = state_15467;
(statearr_15469[(9)] = inst_15444);

(statearr_15469[(10)] = inst_15445);

(statearr_15469[(8)] = inst_15441__$1);

(statearr_15469[(11)] = inst_15440);

(statearr_15469[(12)] = inst_15443);

return statearr_15469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15467__$1,(10),inst_15446);
} else {
if((state_val_15468 === (1))){
var inst_15419 = flakes;
var inst_15420 = cljs.core.seq.call(null,inst_15419);
var inst_15421 = cljs.core.first.call(null,inst_15420);
var inst_15422 = cljs.core.next.call(null,inst_15420);
var inst_15423 = cljs.core.PersistentVector.EMPTY;
var inst_15424 = inst_15419;
var inst_15425 = inst_15423;
var state_15467__$1 = (function (){var statearr_15470 = state_15467;
(statearr_15470[(13)] = inst_15421);

(statearr_15470[(14)] = inst_15422);

(statearr_15470[(15)] = inst_15425);

(statearr_15470[(16)] = inst_15424);

return statearr_15470;
})();
var statearr_15471_15489 = state_15467__$1;
(statearr_15471_15489[(2)] = null);

(statearr_15471_15489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (4))){
var inst_15431 = (state_15467[(7)]);
var inst_15434 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15431);
var state_15467__$1 = state_15467;
if(inst_15434){
var statearr_15472_15490 = state_15467__$1;
(statearr_15472_15490[(1)] = (7));

} else {
var statearr_15473_15491 = state_15467__$1;
(statearr_15473_15491[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (6))){
var inst_15463 = (state_15467[(2)]);
var state_15467__$1 = state_15467;
var statearr_15474_15492 = state_15467__$1;
(statearr_15474_15492[(2)] = inst_15463);

(statearr_15474_15492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (3))){
var inst_15465 = (state_15467[(2)]);
var state_15467__$1 = state_15467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15467__$1,inst_15465);
} else {
if((state_val_15468 === (2))){
var inst_15431 = (state_15467[(7)]);
var inst_15424 = (state_15467[(16)]);
var inst_15430 = cljs.core.seq.call(null,inst_15424);
var inst_15431__$1 = cljs.core.first.call(null,inst_15430);
var inst_15432 = cljs.core.next.call(null,inst_15430);
var state_15467__$1 = (function (){var statearr_15475 = state_15467;
(statearr_15475[(7)] = inst_15431__$1);

(statearr_15475[(17)] = inst_15432);

return statearr_15475;
})();
if(cljs.core.truth_(inst_15431__$1)){
var statearr_15476_15493 = state_15467__$1;
(statearr_15476_15493[(1)] = (4));

} else {
var statearr_15477_15494 = state_15467__$1;
(statearr_15477_15494[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (9))){
var inst_15460 = (state_15467[(2)]);
var state_15467__$1 = state_15467;
var statearr_15478_15495 = state_15467__$1;
(statearr_15478_15495[(2)] = inst_15460);

(statearr_15478_15495[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (5))){
var inst_15425 = (state_15467[(15)]);
var state_15467__$1 = state_15467;
var statearr_15479_15496 = state_15467__$1;
(statearr_15479_15496[(2)] = inst_15425);

(statearr_15479_15496[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (10))){
var inst_15444 = (state_15467[(9)]);
var inst_15445 = (state_15467[(10)]);
var inst_15432 = (state_15467[(17)]);
var inst_15441 = (state_15467[(8)]);
var inst_15440 = (state_15467[(11)]);
var inst_15425 = (state_15467[(15)]);
var inst_15443 = (state_15467[(12)]);
var inst_15448 = (state_15467[(2)]);
var inst_15449 = fluree.db.util.async.throw_err.call(null,inst_15448);
var inst_15450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15451 = [inst_15440,inst_15441,inst_15449,inst_15443,inst_15444,inst_15445];
var inst_15452 = (new cljs.core.PersistentVector(null,6,(5),inst_15450,inst_15451,null));
var inst_15453 = fluree.db.flake.parts__GT_Flake.call(null,inst_15452);
var inst_15454 = cljs.core.conj.call(null,inst_15425,inst_15453);
var inst_15424 = inst_15432;
var inst_15425__$1 = inst_15454;
var state_15467__$1 = (function (){var statearr_15480 = state_15467;
(statearr_15480[(15)] = inst_15425__$1);

(statearr_15480[(16)] = inst_15424);

return statearr_15480;
})();
var statearr_15481_15497 = state_15467__$1;
(statearr_15481_15497[(2)] = null);

(statearr_15481_15497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15468 === (8))){
var inst_15431 = (state_15467[(7)]);
var inst_15432 = (state_15467[(17)]);
var inst_15425 = (state_15467[(15)]);
var inst_15457 = cljs.core.conj.call(null,inst_15425,inst_15431);
var inst_15424 = inst_15432;
var inst_15425__$1 = inst_15457;
var state_15467__$1 = (function (){var statearr_15482 = state_15467;
(statearr_15482[(15)] = inst_15425__$1);

(statearr_15482[(16)] = inst_15424);

return statearr_15482;
})();
var statearr_15483_15498 = state_15467__$1;
(statearr_15483_15498[(2)] = null);

(statearr_15483_15498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_15484 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15484[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__);

(statearr_15484[(1)] = (1));

return statearr_15484;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1 = (function (state_15467){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15485){var ex__2749__auto__ = e15485;
var statearr_15486_15499 = state_15467;
(statearr_15486_15499[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15467[(4)]))){
var statearr_15487_15500 = state_15467;
(statearr_15487_15500[(1)] = cljs.core.first.call(null,(state_15467[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15501 = state_15467;
state_15467 = G__15501;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = function(state_15467){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1.call(this,state_15467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15488 = f__2769__auto__.call(null);
(statearr_15488[(6)] = c__2768__auto__);

return statearr_15488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15503 = arguments.length;
switch (G__15503) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15685){
var state_val_15686 = (state_15685[(1)]);
if((state_val_15686 === (65))){
var inst_15554 = (state_15685[(7)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15554)){
var statearr_15687_15791 = state_15685__$1;
(statearr_15687_15791[(1)] = (68));

} else {
var statearr_15688_15792 = state_15685__$1;
(statearr_15688_15792[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (70))){
var inst_15664 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15689_15793 = state_15685__$1;
(statearr_15689_15793[(2)] = inst_15664);

(statearr_15689_15793[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (62))){
var inst_15630 = (state_15685[(2)]);
var inst_15631 = fluree.db.util.async.throw_err.call(null,inst_15630);
var inst_15632 = cljs.core.take.call(null,(1),inst_15631);
var state_15685__$1 = state_15685;
var statearr_15690_15794 = state_15685__$1;
(statearr_15690_15794[(2)] = inst_15632);

(statearr_15690_15794[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (74))){
var inst_15680 = (state_15685[(2)]);
var _ = (function (){var statearr_15691 = state_15685;
(statearr_15691[(4)] = cljs.core.rest.call(null,(state_15685[(4)])));

return statearr_15691;
})();
var state_15685__$1 = state_15685;
var statearr_15692_15795 = state_15685__$1;
(statearr_15692_15795[(2)] = inst_15680);

(statearr_15692_15795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (7))){
var state_15685__$1 = state_15685;
var statearr_15693_15796 = state_15685__$1;
(statearr_15693_15796[(2)] = false);

(statearr_15693_15796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (59))){
var inst_15554 = (state_15685[(7)]);
var inst_15624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15625 = [inst_15554];
var inst_15626 = (new cljs.core.PersistentVector(null,1,(5),inst_15624,inst_15625,null));
var inst_15627 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15628 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15626,inst_15627);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(62),inst_15628);
} else {
if((state_val_15686 === (20))){
var state_15685__$1 = state_15685;
var statearr_15694_15797 = state_15685__$1;
(statearr_15694_15797[(2)] = null);

(statearr_15694_15797[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (72))){
var inst_15672 = (state_15685[(8)]);
var inst_15674 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15672);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(75),inst_15674);
} else {
if((state_val_15686 === (58))){
var inst_15622 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15622)){
var statearr_15695_15798 = state_15685__$1;
(statearr_15695_15798[(1)] = (59));

} else {
var statearr_15696_15799 = state_15685__$1;
(statearr_15696_15799[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (60))){
var inst_15517 = (state_15685[(9)]);
var inst_15616 = (state_15685[(10)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15635 = [inst_15515,inst_15514,null,inst_15517];
var inst_15636 = (new cljs.core.PersistentVector(null,4,(5),inst_15634,inst_15635,null));
var inst_15637 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15616);
var inst_15638 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15636,inst_15637);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(63),inst_15638);
} else {
if((state_val_15686 === (27))){
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15554 = (state_15685[(7)]);
var inst_15566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15567 = [inst_15514,inst_15515,inst_15554,inst_15517];
var inst_15568 = (new cljs.core.PersistentVector(null,4,(5),inst_15566,inst_15567,null));
var inst_15569 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15568,opts);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(30),inst_15569);
} else {
if((state_val_15686 === (1))){
var state_15685__$1 = state_15685;
var statearr_15697_15800 = state_15685__$1;
(statearr_15697_15800[(2)] = null);

(statearr_15697_15800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (69))){
var state_15685__$1 = state_15685;
var statearr_15698_15801 = state_15685__$1;
(statearr_15698_15801[(2)] = null);

(statearr_15698_15801[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (24))){
var inst_15515 = (state_15685[(12)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15515)){
var statearr_15699_15802 = state_15685__$1;
(statearr_15699_15802[(1)] = (31));

} else {
var statearr_15700_15803 = state_15685__$1;
(statearr_15700_15803[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (55))){
var inst_15617 = (state_15685[(13)]);
var inst_15515 = (state_15685[(12)]);
var inst_15616 = (state_15685[(2)]);
var inst_15617__$1 = cljs.core._EQ_.call(null,"_id",inst_15515);
var state_15685__$1 = (function (){var statearr_15701 = state_15685;
(statearr_15701[(10)] = inst_15616);

(statearr_15701[(13)] = inst_15617__$1);

return statearr_15701;
})();
if(inst_15617__$1){
var statearr_15702_15804 = state_15685__$1;
(statearr_15702_15804[(1)] = (56));

} else {
var statearr_15703_15805 = state_15685__$1;
(statearr_15703_15805[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (39))){
var inst_15584 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15704_15806 = state_15685__$1;
(statearr_15704_15806[(2)] = inst_15584);

(statearr_15704_15806[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (46))){
var inst_15608 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15608)){
var statearr_15705_15807 = state_15685__$1;
(statearr_15705_15807[(1)] = (50));

} else {
var statearr_15706_15808 = state_15685__$1;
(statearr_15706_15808[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (4))){
var inst_15504 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15707_15809 = state_15685__$1;
(statearr_15707_15809[(2)] = inst_15504);

(statearr_15707_15809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (54))){
var inst_15610 = (state_15685[(14)]);
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15554 = (state_15685[(7)]);
var inst_15524 = (state_15685[(15)]);
var inst_15513 = (state_15685[(16)]);
var inst_15529 = (state_15685[(17)]);
var inst_15518 = (state_15685[(18)]);
var inst_15614 = (function (){var t = inst_15517;
var temp__5802__auto__ = inst_15610;
var p = inst_15515;
var idx_predicate_QMARK_ = inst_15518;
var vec__15510 = inst_15513;
var o = inst_15554;
var tag_predicate_QMARK_ = inst_15524;
var s = inst_15514;
var o_coerce_QMARK_ = inst_15529;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15685__$1 = state_15685;
var statearr_15708_15810 = state_15685__$1;
(statearr_15708_15810[(2)] = inst_15614);

(statearr_15708_15810[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (15))){
var inst_15516 = (state_15685[(19)]);
var inst_15535 = fluree.db.dbproto._tag_id.call(null,db,inst_15516);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(18),inst_15535);
} else {
if((state_val_15686 === (48))){
var inst_15601 = (state_15685[(20)]);
var state_15685__$1 = state_15685;
var statearr_15709_15811 = state_15685__$1;
(statearr_15709_15811[(2)] = inst_15601);

(statearr_15709_15811[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (50))){
var inst_15610 = (state_15685[(14)]);
var inst_15610__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15685__$1 = (function (){var statearr_15710 = state_15685;
(statearr_15710[(14)] = inst_15610__$1);

return statearr_15710;
})();
if(cljs.core.truth_(inst_15610__$1)){
var statearr_15711_15812 = state_15685__$1;
(statearr_15711_15812[(1)] = (53));

} else {
var statearr_15712_15813 = state_15685__$1;
(statearr_15712_15813[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (75))){
var inst_15676 = (state_15685[(2)]);
var inst_15677 = fluree.db.util.async.throw_err.call(null,inst_15676);
var state_15685__$1 = state_15685;
var statearr_15713_15814 = state_15685__$1;
(statearr_15713_15814[(2)] = inst_15677);

(statearr_15713_15814[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (21))){
var inst_15550 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15714_15815 = state_15685__$1;
(statearr_15714_15815[(2)] = inst_15550);

(statearr_15714_15815[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (31))){
var inst_15577 = (state_15685[(21)]);
var inst_15554 = (state_15685[(7)]);
var inst_15577__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15554);
var state_15685__$1 = (function (){var statearr_15715 = state_15685;
(statearr_15715[(21)] = inst_15577__$1);

return statearr_15715;
})();
if(inst_15577__$1){
var statearr_15716_15816 = state_15685__$1;
(statearr_15716_15816[(1)] = (34));

} else {
var statearr_15717_15817 = state_15685__$1;
(statearr_15717_15817[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (32))){
var inst_15515 = (state_15685[(12)]);
var state_15685__$1 = state_15685;
var statearr_15718_15818 = state_15685__$1;
(statearr_15718_15818[(2)] = inst_15515);

(statearr_15718_15818[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (40))){
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15554 = (state_15685[(7)]);
var inst_15592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15593 = [inst_15515,inst_15554,inst_15514,inst_15517];
var inst_15594 = (new cljs.core.PersistentVector(null,4,(5),inst_15592,inst_15593,null));
var inst_15595 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15594,opts);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(43),inst_15595);
} else {
if((state_val_15686 === (56))){
var inst_15554 = (state_15685[(7)]);
var inst_15619 = cljs.core.int_QMARK_.call(null,inst_15554);
var state_15685__$1 = state_15685;
var statearr_15719_15819 = state_15685__$1;
(statearr_15719_15819[(2)] = inst_15619);

(statearr_15719_15819[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (33))){
var inst_15590 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15590)){
var statearr_15720_15820 = state_15685__$1;
(statearr_15720_15820[(1)] = (40));

} else {
var statearr_15721_15821 = state_15685__$1;
(statearr_15721_15821[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (13))){
var inst_15516 = (state_15685[(19)]);
var inst_15533 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15516);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15533)){
var statearr_15722_15822 = state_15685__$1;
(statearr_15722_15822[(1)] = (15));

} else {
var statearr_15723_15823 = state_15685__$1;
(statearr_15723_15823[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (22))){
var inst_15546 = (state_15685[(2)]);
var inst_15547 = fluree.db.util.async.throw_err.call(null,inst_15546);
var state_15685__$1 = state_15685;
var statearr_15724_15824 = state_15685__$1;
(statearr_15724_15824[(2)] = inst_15547);

(statearr_15724_15824[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (36))){
var inst_15587 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15725_15825 = state_15685__$1;
(statearr_15725_15825[(2)] = inst_15587);

(statearr_15725_15825[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (41))){
var inst_15515 = (state_15685[(12)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15515)){
var statearr_15726_15826 = state_15685__$1;
(statearr_15726_15826[(1)] = (44));

} else {
var statearr_15727_15827 = state_15685__$1;
(statearr_15727_15827[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (43))){
var inst_15597 = (state_15685[(2)]);
var inst_15598 = fluree.db.util.async.throw_err.call(null,inst_15597);
var state_15685__$1 = state_15685;
var statearr_15728_15828 = state_15685__$1;
(statearr_15728_15828[(2)] = inst_15598);

(statearr_15728_15828[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (61))){
var inst_15643 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15729_15829 = state_15685__$1;
(statearr_15729_15829[(2)] = inst_15643);

(statearr_15729_15829[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (29))){
var inst_15563 = (state_15685[(2)]);
var inst_15564 = fluree.db.util.async.throw_err.call(null,inst_15563);
var state_15685__$1 = state_15685;
var statearr_15730_15830 = state_15685__$1;
(statearr_15730_15830[(2)] = inst_15564);

(statearr_15730_15830[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (44))){
var inst_15518 = (state_15685[(18)]);
var inst_15601 = (state_15685[(20)]);
var inst_15601__$1 = cljs.core.not.call(null,inst_15518);
var state_15685__$1 = (function (){var statearr_15731 = state_15685;
(statearr_15731[(20)] = inst_15601__$1);

return statearr_15731;
})();
if(inst_15601__$1){
var statearr_15732_15831 = state_15685__$1;
(statearr_15732_15831[(1)] = (47));

} else {
var statearr_15733_15832 = state_15685__$1;
(statearr_15733_15832[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (6))){
var inst_15515 = (state_15685[(12)]);
var inst_15520 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15515);
var inst_15521 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15520);
var state_15685__$1 = state_15685;
var statearr_15734_15833 = state_15685__$1;
(statearr_15734_15833[(2)] = inst_15521);

(statearr_15734_15833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (28))){
var inst_15574 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15735_15834 = state_15685__$1;
(statearr_15735_15834[(2)] = inst_15574);

(statearr_15735_15834[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (64))){
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15554 = (state_15685[(7)]);
var inst_15646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15647 = [inst_15515,inst_15514,inst_15554,inst_15517];
var inst_15648 = (new cljs.core.PersistentVector(null,4,(5),inst_15646,inst_15647,null));
var inst_15649 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15648,opts);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(67),inst_15649);
} else {
if((state_val_15686 === (51))){
var inst_15515 = (state_15685[(12)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15515)){
var statearr_15736_15835 = state_15685__$1;
(statearr_15736_15835[(1)] = (64));

} else {
var statearr_15737_15836 = state_15685__$1;
(statearr_15737_15836[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (25))){
var inst_15524 = (state_15685[(15)]);
var inst_15672 = (state_15685[(2)]);
var state_15685__$1 = (function (){var statearr_15738 = state_15685;
(statearr_15738[(8)] = inst_15672);

return statearr_15738;
})();
if(cljs.core.truth_(inst_15524)){
var statearr_15739_15837 = state_15685__$1;
(statearr_15739_15837[(1)] = (72));

} else {
var statearr_15740_15838 = state_15685__$1;
(statearr_15740_15838[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (34))){
var inst_15518 = (state_15685[(18)]);
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15518)){
var statearr_15741_15839 = state_15685__$1;
(statearr_15741_15839[(1)] = (37));

} else {
var statearr_15742_15840 = state_15685__$1;
(statearr_15742_15840[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (17))){
var inst_15552 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15743_15841 = state_15685__$1;
(statearr_15743_15841[(2)] = inst_15552);

(statearr_15743_15841[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (3))){
var inst_15683 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15685__$1,inst_15683);
} else {
if((state_val_15686 === (12))){
var inst_15516 = (state_15685[(19)]);
var state_15685__$1 = state_15685;
var statearr_15744_15842 = state_15685__$1;
(statearr_15744_15842[(2)] = inst_15516);

(statearr_15744_15842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (2))){
var inst_15515 = (state_15685[(12)]);
var inst_15513 = (state_15685[(16)]);
var _ = (function (){var statearr_15745 = state_15685;
(statearr_15745[(4)] = cljs.core.cons.call(null,(5),(state_15685[(4)])));

return statearr_15745;
})();
var inst_15513__$1 = fparts;
var inst_15514 = cljs.core.nth.call(null,inst_15513__$1,(0),null);
var inst_15515__$1 = cljs.core.nth.call(null,inst_15513__$1,(1),null);
var inst_15516 = cljs.core.nth.call(null,inst_15513__$1,(2),null);
var inst_15517 = cljs.core.nth.call(null,inst_15513__$1,(3),null);
var inst_15518 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15515__$1);
var state_15685__$1 = (function (){var statearr_15746 = state_15685;
(statearr_15746[(9)] = inst_15517);

(statearr_15746[(11)] = inst_15514);

(statearr_15746[(12)] = inst_15515__$1);

(statearr_15746[(16)] = inst_15513__$1);

(statearr_15746[(19)] = inst_15516);

(statearr_15746[(18)] = inst_15518);

return statearr_15746;
})();
if(cljs.core.truth_(inst_15515__$1)){
var statearr_15747_15843 = state_15685__$1;
(statearr_15747_15843[(1)] = (6));

} else {
var statearr_15748_15844 = state_15685__$1;
(statearr_15748_15844[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (66))){
var inst_15666 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15749_15845 = state_15685__$1;
(statearr_15749_15845[(2)] = inst_15666);

(statearr_15749_15845[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (23))){
var inst_15515 = (state_15685[(12)]);
var inst_15556 = cljs.core._EQ_.call(null,"_id",inst_15515);
var state_15685__$1 = state_15685;
if(inst_15556){
var statearr_15750_15846 = state_15685__$1;
(statearr_15750_15846[(1)] = (26));

} else {
var statearr_15751_15847 = state_15685__$1;
(statearr_15751_15847[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (47))){
var inst_15554 = (state_15685[(7)]);
var state_15685__$1 = state_15685;
var statearr_15752_15848 = state_15685__$1;
(statearr_15752_15848[(2)] = inst_15554);

(statearr_15752_15848[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (35))){
var inst_15577 = (state_15685[(21)]);
var state_15685__$1 = state_15685;
var statearr_15753_15849 = state_15685__$1;
(statearr_15753_15849[(2)] = inst_15577);

(statearr_15753_15849[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (19))){
var inst_15515 = (state_15685[(12)]);
var inst_15516 = (state_15685[(19)]);
var inst_15542 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15515);
var inst_15543 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15542),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15516)].join('');
var inst_15544 = fluree.db.dbproto._tag_id.call(null,db,inst_15543);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(22),inst_15544);
} else {
if((state_val_15686 === (57))){
var inst_15617 = (state_15685[(13)]);
var state_15685__$1 = state_15685;
var statearr_15754_15850 = state_15685__$1;
(statearr_15754_15850[(2)] = inst_15617);

(statearr_15754_15850[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (68))){
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15554 = (state_15685[(7)]);
var inst_15655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15656 = [inst_15554,inst_15515,inst_15514,inst_15517];
var inst_15657 = (new cljs.core.PersistentVector(null,4,(5),inst_15655,inst_15656,null));
var inst_15658 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15657,opts);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(71),inst_15658);
} else {
if((state_val_15686 === (11))){
var inst_15529 = (state_15685[(17)]);
var inst_15529__$1 = (state_15685[(2)]);
var inst_15530 = cljs.core.not.call(null,inst_15529__$1);
var state_15685__$1 = (function (){var statearr_15756 = state_15685;
(statearr_15756[(17)] = inst_15529__$1);

return statearr_15756;
})();
if(inst_15530){
var statearr_15757_15851 = state_15685__$1;
(statearr_15757_15851[(1)] = (12));

} else {
var statearr_15758_15852 = state_15685__$1;
(statearr_15758_15852[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (9))){
var inst_15516 = (state_15685[(19)]);
var inst_15526 = typeof inst_15516 === 'string';
var state_15685__$1 = state_15685;
var statearr_15759_15853 = state_15685__$1;
(statearr_15759_15853[(2)] = inst_15526);

(statearr_15759_15853[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (5))){
var _ = (function (){var statearr_15760 = state_15685;
(statearr_15760[(4)] = cljs.core.rest.call(null,(state_15685[(4)])));

return statearr_15760;
})();
var state_15685__$1 = state_15685;
var ex15755 = (state_15685__$1[(2)]);
var statearr_15761_15854 = state_15685__$1;
(statearr_15761_15854[(5)] = ex15755);


if((ex15755 instanceof Error)){
var statearr_15762_15855 = state_15685__$1;
(statearr_15762_15855[(1)] = (4));

(statearr_15762_15855[(5)] = null);

} else {
throw ex15755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (14))){
var inst_15514 = (state_15685[(11)]);
var inst_15554 = (state_15685[(2)]);
var state_15685__$1 = (function (){var statearr_15763 = state_15685;
(statearr_15763[(7)] = inst_15554);

return statearr_15763;
})();
if(cljs.core.truth_(inst_15514)){
var statearr_15764_15856 = state_15685__$1;
(statearr_15764_15856[(1)] = (23));

} else {
var statearr_15765_15857 = state_15685__$1;
(statearr_15765_15857[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (45))){
var inst_15515 = (state_15685[(12)]);
var state_15685__$1 = state_15685;
var statearr_15766_15858 = state_15685__$1;
(statearr_15766_15858[(2)] = inst_15515);

(statearr_15766_15858[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (53))){
var inst_15610 = (state_15685[(14)]);
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15515 = (state_15685[(12)]);
var inst_15554 = (state_15685[(7)]);
var inst_15524 = (state_15685[(15)]);
var inst_15513 = (state_15685[(16)]);
var inst_15529 = (state_15685[(17)]);
var inst_15518 = (state_15685[(18)]);
var inst_15612 = (function (){var obj_fn = inst_15610;
var t = inst_15517;
var temp__5802__auto__ = inst_15610;
var p = inst_15515;
var idx_predicate_QMARK_ = inst_15518;
var vec__15510 = inst_15513;
var o = inst_15554;
var tag_predicate_QMARK_ = inst_15524;
var s = inst_15514;
var o_coerce_QMARK_ = inst_15529;
return (function (x){
var and__5043__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15685__$1 = state_15685;
var statearr_15767_15859 = state_15685__$1;
(statearr_15767_15859[(2)] = inst_15612);

(statearr_15767_15859[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (26))){
var inst_15517 = (state_15685[(9)]);
var inst_15514 = (state_15685[(11)]);
var inst_15558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15559 = [inst_15514,null,null,inst_15517];
var inst_15560 = (new cljs.core.PersistentVector(null,4,(5),inst_15558,inst_15559,null));
var inst_15561 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15560,opts);
var state_15685__$1 = state_15685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15685__$1,(29),inst_15561);
} else {
if((state_val_15686 === (16))){
var inst_15516 = (state_15685[(19)]);
var inst_15540 = typeof inst_15516 === 'string';
var state_15685__$1 = state_15685;
if(cljs.core.truth_(inst_15540)){
var statearr_15768_15860 = state_15685__$1;
(statearr_15768_15860[(1)] = (19));

} else {
var statearr_15769_15861 = state_15685__$1;
(statearr_15769_15861[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (38))){
var inst_15518 = (state_15685[(18)]);
var state_15685__$1 = state_15685;
var statearr_15770_15862 = state_15685__$1;
(statearr_15770_15862[(2)] = inst_15518);

(statearr_15770_15862[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (30))){
var inst_15571 = (state_15685[(2)]);
var inst_15572 = fluree.db.util.async.throw_err.call(null,inst_15571);
var state_15685__$1 = state_15685;
var statearr_15771_15863 = state_15685__$1;
(statearr_15771_15863[(2)] = inst_15572);

(statearr_15771_15863[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (73))){
var inst_15672 = (state_15685[(8)]);
var state_15685__$1 = state_15685;
var statearr_15772_15864 = state_15685__$1;
(statearr_15772_15864[(2)] = inst_15672);

(statearr_15772_15864[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (10))){
var inst_15524 = (state_15685[(15)]);
var state_15685__$1 = state_15685;
var statearr_15773_15865 = state_15685__$1;
(statearr_15773_15865[(2)] = inst_15524);

(statearr_15773_15865[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (18))){
var inst_15537 = (state_15685[(2)]);
var inst_15538 = fluree.db.util.async.throw_err.call(null,inst_15537);
var state_15685__$1 = state_15685;
var statearr_15774_15866 = state_15685__$1;
(statearr_15774_15866[(2)] = inst_15538);

(statearr_15774_15866[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (52))){
var inst_15668 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15775_15867 = state_15685__$1;
(statearr_15775_15867[(2)] = inst_15668);

(statearr_15775_15867[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (67))){
var inst_15651 = (state_15685[(2)]);
var inst_15652 = fluree.db.util.async.throw_err.call(null,inst_15651);
var state_15685__$1 = state_15685;
var statearr_15776_15868 = state_15685__$1;
(statearr_15776_15868[(2)] = inst_15652);

(statearr_15776_15868[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (71))){
var inst_15660 = (state_15685[(2)]);
var inst_15661 = fluree.db.util.async.throw_err.call(null,inst_15660);
var state_15685__$1 = state_15685;
var statearr_15777_15869 = state_15685__$1;
(statearr_15777_15869[(2)] = inst_15661);

(statearr_15777_15869[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (42))){
var inst_15670 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15778_15870 = state_15685__$1;
(statearr_15778_15870[(2)] = inst_15670);

(statearr_15778_15870[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (37))){
var inst_15554 = (state_15685[(7)]);
var inst_15580 = cljs.core.fn_QMARK_.call(null,inst_15554);
var inst_15581 = (!(inst_15580));
var state_15685__$1 = state_15685;
var statearr_15779_15871 = state_15685__$1;
(statearr_15779_15871[(2)] = inst_15581);

(statearr_15779_15871[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (63))){
var inst_15640 = (state_15685[(2)]);
var inst_15641 = fluree.db.util.async.throw_err.call(null,inst_15640);
var state_15685__$1 = state_15685;
var statearr_15780_15872 = state_15685__$1;
(statearr_15780_15872[(2)] = inst_15641);

(statearr_15780_15872[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (8))){
var inst_15524 = (state_15685[(15)]);
var inst_15524__$1 = (state_15685[(2)]);
var state_15685__$1 = (function (){var statearr_15781 = state_15685;
(statearr_15781[(15)] = inst_15524__$1);

return statearr_15781;
})();
if(cljs.core.truth_(inst_15524__$1)){
var statearr_15782_15873 = state_15685__$1;
(statearr_15782_15873[(1)] = (9));

} else {
var statearr_15783_15874 = state_15685__$1;
(statearr_15783_15874[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15686 === (49))){
var inst_15605 = (state_15685[(2)]);
var state_15685__$1 = state_15685;
var statearr_15784_15875 = state_15685__$1;
(statearr_15784_15875[(2)] = inst_15605);

(statearr_15784_15875[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15785 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15785[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15785[(1)] = (1));

return statearr_15785;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15685){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15786){var ex__2749__auto__ = e15786;
var statearr_15787_15876 = state_15685;
(statearr_15787_15876[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15685[(4)]))){
var statearr_15788_15877 = state_15685;
(statearr_15788_15877[(1)] = cljs.core.first.call(null,(state_15685[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15878 = state_15685;
state_15685 = G__15878;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15685){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15789 = f__2769__auto__.call(null);
(statearr_15789[(6)] = c__2768__auto__);

return statearr_15789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15880 = arguments.length;
switch (G__15880) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15915){
var state_val_15916 = (state_15915[(1)]);
if((state_val_15916 === (7))){
var inst_15902 = cljs.core.pr_str.call(null,name);
var inst_15903 = ["Invalid collection name: ",inst_15902].join('');
var inst_15904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15905 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15906 = cljs.core.PersistentHashMap.fromArrays(inst_15904,inst_15905);
var inst_15907 = cljs.core.ex_info.call(null,inst_15903,inst_15906);
var inst_15908 = (function(){throw inst_15907})();
var state_15915__$1 = state_15915;
var statearr_15917_15937 = state_15915__$1;
(statearr_15917_15937[(2)] = inst_15908);

(statearr_15917_15937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15916 === (1))){
var state_15915__$1 = state_15915;
var statearr_15918_15938 = state_15915__$1;
(statearr_15918_15938[(2)] = null);

(statearr_15918_15938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15916 === (4))){
var inst_15881 = (state_15915[(2)]);
var state_15915__$1 = state_15915;
var statearr_15919_15939 = state_15915__$1;
(statearr_15919_15939[(2)] = inst_15881);

(statearr_15919_15939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15916 === (6))){
var inst_15887 = (state_15915[(7)]);
var inst_15889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15890 = fluree.db.flake.max_subject_id.call(null,inst_15887);
var inst_15891 = [inst_15890];
var inst_15892 = (new cljs.core.PersistentVector(null,1,(5),inst_15889,inst_15891,null));
var inst_15893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15894 = fluree.db.flake.min_subject_id.call(null,inst_15887);
var inst_15895 = [inst_15894];
var inst_15896 = (new cljs.core.PersistentVector(null,1,(5),inst_15893,inst_15895,null));
var inst_15897 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15892,cljs.core._LT__EQ_,inst_15896,opts);
var state_15915__$1 = state_15915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15915__$1,(9),inst_15897);
} else {
if((state_val_15916 === (3))){
var inst_15913 = (state_15915[(2)]);
var state_15915__$1 = state_15915;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15915__$1,inst_15913);
} else {
if((state_val_15916 === (2))){
var inst_15887 = (state_15915[(7)]);
var _ = (function (){var statearr_15921 = state_15915;
(statearr_15921[(4)] = cljs.core.cons.call(null,(5),(state_15915[(4)])));

return statearr_15921;
})();
var inst_15887__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15915__$1 = (function (){var statearr_15922 = state_15915;
(statearr_15922[(7)] = inst_15887__$1);

return statearr_15922;
})();
if(cljs.core.truth_(inst_15887__$1)){
var statearr_15923_15940 = state_15915__$1;
(statearr_15923_15940[(1)] = (6));

} else {
var statearr_15924_15941 = state_15915__$1;
(statearr_15924_15941[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15916 === (9))){
var inst_15899 = (state_15915[(2)]);
var inst_15900 = fluree.db.util.async.throw_err.call(null,inst_15899);
var state_15915__$1 = state_15915;
var statearr_15925_15942 = state_15915__$1;
(statearr_15925_15942[(2)] = inst_15900);

(statearr_15925_15942[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15916 === (5))){
var _ = (function (){var statearr_15926 = state_15915;
(statearr_15926[(4)] = cljs.core.rest.call(null,(state_15915[(4)])));

return statearr_15926;
})();
var state_15915__$1 = state_15915;
var ex15920 = (state_15915__$1[(2)]);
var statearr_15927_15943 = state_15915__$1;
(statearr_15927_15943[(5)] = ex15920);


var statearr_15928_15944 = state_15915__$1;
(statearr_15928_15944[(1)] = (4));

(statearr_15928_15944[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15916 === (8))){
var inst_15910 = (state_15915[(2)]);
var _ = (function (){var statearr_15929 = state_15915;
(statearr_15929[(4)] = cljs.core.rest.call(null,(state_15915[(4)])));

return statearr_15929;
})();
var state_15915__$1 = state_15915;
var statearr_15930_15945 = state_15915__$1;
(statearr_15930_15945[(2)] = inst_15910);

(statearr_15930_15945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15931 = [null,null,null,null,null,null,null,null];
(statearr_15931[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15931[(1)] = (1));

return statearr_15931;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15915){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15915);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15932){var ex__2749__auto__ = e15932;
var statearr_15933_15946 = state_15915;
(statearr_15933_15946[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15915[(4)]))){
var statearr_15934_15947 = state_15915;
(statearr_15934_15947[(1)] = cljs.core.first.call(null,(state_15915[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15948 = state_15915;
state_15915 = G__15948;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15915){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15935 = f__2769__auto__.call(null);
(statearr_15935[(6)] = c__2768__auto__);

return statearr_15935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15952 = flakes;
var vec__15953 = G__15952;
var seq__15954 = cljs.core.seq.call(null,vec__15953);
var first__15955 = cljs.core.first.call(null,seq__15954);
var seq__15954__$1 = cljs.core.next.call(null,seq__15954);
var flake_SINGLEQUOTE_ = first__15955;
var r = seq__15954__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15952__$1 = G__15952;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15961 = G__15952__$1;
var seq__15962 = cljs.core.seq.call(null,vec__15961);
var first__15963 = cljs.core.first.call(null,seq__15962);
var seq__15962__$1 = cljs.core.next.call(null,seq__15962);
var flake_SINGLEQUOTE___$1 = first__15963;
var r__$1 = seq__15962__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o.call(null,flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15965){var e = e15965;
return null;
}})();
var map__15964 = cmd_map;
var map__15964__$1 = cljs.core.__destructure_map.call(null,map__15964);
var type = cljs.core.get.call(null,map__15964__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15964__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15964__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15964__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15964__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15964__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15966 = r__$1;
var G__15967 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15952__$1 = G__15966;
result_STAR___$1 = G__15967;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15976 = blocks;
var vec__15977 = G__15976;
var seq__15978 = cljs.core.seq.call(null,vec__15977);
var first__15979 = cljs.core.first.call(null,seq__15978);
var seq__15978__$1 = cljs.core.next.call(null,seq__15978);
var block_SINGLEQUOTE_ = first__15979;
var r = seq__15978__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15976__$1 = G__15976;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15984 = G__15976__$1;
var seq__15985 = cljs.core.seq.call(null,vec__15984);
var first__15986 = cljs.core.first.call(null,seq__15985);
var seq__15985__$1 = cljs.core.next.call(null,seq__15985);
var block_SINGLEQUOTE___$1 = first__15986;
var r__$1 = seq__15985__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15987 = block_SINGLEQUOTE___$1;
var map__15987__$1 = cljs.core.__destructure_map.call(null,map__15987);
var block = cljs.core.get.call(null,map__15987__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15987__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15987__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15968_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15968_SHARP_),(2))){
return fluree.db.flake.o.call(null,p1__15968_SHARP_);
} else {
return null;
}
});})(G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15969_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15969_SHARP_),(1))){
return fluree.db.flake.o.call(null,p1__15969_SHARP_);
} else {
return null;
}
});})(G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,hash,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15970_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15970_SHARP_),(5))){
return fluree.db.flake.o.call(null,p1__15970_SHARP_);
} else {
return null;
}
});})(G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,hash,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,hash,instant,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15971_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15971_SHARP_),(7))){
return fluree.db.flake.o.call(null,p1__15971_SHARP_);
} else {
return null;
}
});})(G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,hash,instant,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15972_SHARP_){
return cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15972_SHARP_),(106));
});})(G__15976__$1,result_STAR___$1,map__15987,map__15987__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15984,seq__15985,first__15986,seq__15985__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15976,vec__15977,seq__15978,first__15979,seq__15978__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15988 = r__$1;
var G__15989 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15976__$1 = G__15988;
result_STAR___$1 = G__15989;
continue;
}
break;
}
});
