// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24473 = arguments.length;
switch (G__24473) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24476 = arguments.length;
switch (G__24476) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24478 = null;
var G__24478__0 = (function (){
return xf.call(null);
});
var G__24478__1 = (function (result){
return xf.call(null,result);
});
var G__24478__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__24478 = function(result,flake){
switch(arguments.length){
case 0:
return G__24478__0.call(this);
case 1:
return G__24478__1.call(this,result);
case 2:
return G__24478__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24478.cljs$core$IFn$_invoke$arity$0 = G__24478__0;
G__24478.cljs$core$IFn$_invoke$arity$1 = G__24478__1;
G__24478.cljs$core$IFn$_invoke$arity$2 = G__24478__2;
return G__24478;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24479_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24479_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24483 = vars;
var vec__24484 = G__24483;
var seq__24485 = cljs.core.seq.call(null,vec__24484);
var first__24486 = cljs.core.first.call(null,seq__24485);
var seq__24485__$1 = cljs.core.next.call(null,seq__24485);
var var$ = first__24486;
var r = seq__24485__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24483__$1 = G__24483;
var all_vars__$1 = all_vars;
while(true){
var vec__24490 = G__24483__$1;
var seq__24491 = cljs.core.seq.call(null,vec__24490);
var first__24492 = cljs.core.first.call(null,seq__24491);
var seq__24491__$1 = cljs.core.next.call(null,seq__24491);
var var$__$1 = first__24492;
var r__$1 = seq__24491__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24493 = r__$1;
var G__24494 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24483__$1 = G__24493;
all_vars__$1 = G__24494;
continue;
} else {
var G__24495 = r__$1;
var G__24496 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24483__$1 = G__24495;
all_vars__$1 = G__24496;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24497){
var vec__24498 = p__24497;
var tuple_index = cljs.core.nth.call(null,vec__24498,(0),null);
var query_map = cljs.core.nth.call(null,vec__24498,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24512){
var state_val_24513 = (state_24512[(1)]);
if((state_val_24513 === (1))){
var inst_24501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24502 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24503 = [query_map,_id,query_opts];
var inst_24504 = cljs.core.PersistentHashMap.fromArrays(inst_24502,inst_24503);
var inst_24505 = fluree.db.query.fql.query.call(null,db,inst_24504);
var state_24512__$1 = (function (){var statearr_24514 = state_24512;
(statearr_24514[(7)] = inst_24501);

return statearr_24514;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24512__$1,(2),inst_24505);
} else {
if((state_val_24513 === (2))){
var inst_24501 = (state_24512[(7)]);
var inst_24507 = (state_24512[(2)]);
var inst_24508 = fluree.db.util.async.throw_err.call(null,inst_24507);
var inst_24509 = [tuple_index,inst_24508];
var inst_24510 = (new cljs.core.PersistentVector(null,2,(5),inst_24501,inst_24509,null));
var state_24512__$1 = state_24512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24512__$1,inst_24510);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_24515 = [null,null,null,null,null,null,null,null];
(statearr_24515[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_24515[(1)] = (1));

return statearr_24515;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_24512){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24516){var ex__2749__auto__ = e24516;
var statearr_24517_24520 = state_24512;
(statearr_24517_24520[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24512[(4)]))){
var statearr_24518_24521 = state_24512;
(statearr_24518_24521[(1)] = cljs.core.first.call(null,(state_24512[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24522 = state_24512;
state_24512 = G__24522;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_24512){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_24512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24519 = f__2769__auto__.call(null);
(statearr_24519[(6)] = c__2768__auto__);

return statearr_24519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24523 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24523,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24523,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24586){
var state_val_24587 = (state_24586[(1)]);
if((state_val_24587 === (7))){
var inst_24581 = (state_24586[(2)]);
var _ = (function (){var statearr_24588 = state_24586;
(statearr_24588[(4)] = cljs.core.rest.call(null,(state_24586[(4)])));

return statearr_24588;
})();
var state_24586__$1 = state_24586;
var statearr_24589_24680 = state_24586__$1;
(statearr_24589_24680[(2)] = inst_24581);

(statearr_24589_24680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (20))){
var inst_24572 = (state_24586[(2)]);
var state_24586__$1 = state_24586;
var statearr_24590_24681 = state_24586__$1;
(statearr_24590_24681[(2)] = inst_24572);

(statearr_24590_24681[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (1))){
var state_24586__$1 = state_24586;
var statearr_24591_24682 = state_24586__$1;
(statearr_24591_24682[(2)] = null);

(statearr_24591_24682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (4))){
var inst_24528 = (state_24586[(2)]);
var state_24586__$1 = state_24586;
var statearr_24592_24683 = state_24586__$1;
(statearr_24592_24683[(2)] = inst_24528);

(statearr_24592_24683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (15))){
var inst_24548 = (state_24586[(7)]);
var inst_24557 = cljs.core.second.call(null,inst_24548);
var inst_24558 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24557);
var inst_24559 = (inst_24558 > max_fuel);
var state_24586__$1 = state_24586;
if(cljs.core.truth_(inst_24559)){
var statearr_24593_24684 = state_24586__$1;
(statearr_24593_24684[(1)] = (18));

} else {
var statearr_24594_24685 = state_24586__$1;
(statearr_24594_24685[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (13))){
var state_24586__$1 = state_24586;
var statearr_24595_24686 = state_24586__$1;
(statearr_24595_24686[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (6))){
var inst_24536 = (state_24586[(8)]);
var state_24586__$1 = state_24586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24586__$1,(8),inst_24536);
} else {
if((state_val_24587 === (17))){
var inst_24575 = (state_24586[(2)]);
var state_24586__$1 = state_24586;
var statearr_24597_24687 = state_24586__$1;
(statearr_24597_24687[(2)] = inst_24575);

(statearr_24597_24687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (3))){
var inst_24584 = (state_24586[(2)]);
var state_24586__$1 = state_24586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24586__$1,inst_24584);
} else {
if((state_val_24587 === (12))){
var inst_24537 = (state_24586[(9)]);
var inst_24548 = (state_24586[(7)]);
var inst_24554 = inst_24537.call(null);
var state_24586__$1 = (function (){var statearr_24598 = state_24586;
(statearr_24598[(10)] = inst_24554);

return statearr_24598;
})();
var statearr_24599_24688 = state_24586__$1;
(statearr_24599_24688[(2)] = inst_24548);

(statearr_24599_24688[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (2))){
var inst_24536 = (state_24586[(8)]);
var inst_24537 = (state_24586[(9)]);
var _ = (function (){var statearr_24600 = state_24586;
(statearr_24600[(4)] = cljs.core.cons.call(null,(5),(state_24586[(4)])));

return statearr_24600;
})();
var inst_24534 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24535 = cljs.core.async.chan.call(null);
var inst_24536__$1 = cljs.core.async.chan.call(null);
var inst_24537__$1 = (function (){var expandMaps = inst_24534;
var queue_ch = inst_24535;
var res_ch = inst_24536__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24538 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24539 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24540 = cljs.core.assoc.call(null,inst_24538,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24539);
var inst_24541 = (function (){var expandMaps = inst_24534;
var queue_ch = inst_24535;
var res_ch = inst_24536__$1;
var stop_BANG_ = inst_24537__$1;
var opts_STAR_ = inst_24540;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24633){
var state_val_24634 = (state_24633[(1)]);
if((state_val_24634 === (7))){
var state_24633__$1 = state_24633;
var statearr_24635_24689 = state_24633__$1;
(statearr_24635_24689[(2)] = tuple_res);

(statearr_24635_24689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (1))){
var state_24633__$1 = state_24633;
var statearr_24636_24690 = state_24633__$1;
(statearr_24636_24690[(2)] = null);

(statearr_24636_24690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (4))){
var inst_24601 = (state_24633[(2)]);
var inst_24602 = cljs.core.async.put_BANG_.call(null,port,inst_24601);
var inst_24603 = cljs.core.async.close_BANG_.call(null,port);
var state_24633__$1 = (function (){var statearr_24637 = state_24633;
(statearr_24637[(7)] = inst_24602);

return statearr_24637;
})();
var statearr_24638_24691 = state_24633__$1;
(statearr_24638_24691[(2)] = inst_24603);

(statearr_24638_24691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (6))){
var inst_24610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24611 = [tuple_res];
var inst_24612 = (new cljs.core.PersistentVector(null,1,(5),inst_24610,inst_24611,null));
var state_24633__$1 = state_24633;
var statearr_24639_24692 = state_24633__$1;
(statearr_24639_24692[(2)] = inst_24612);

(statearr_24639_24692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (3))){
var inst_24631 = (state_24633[(2)]);
var state_24633__$1 = state_24633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24633__$1,inst_24631);
} else {
if((state_val_24634 === (2))){
var ___$1 = (function (){var statearr_24641 = state_24633;
(statearr_24641[(4)] = cljs.core.cons.call(null,(5),(state_24633[(4)])));

return statearr_24641;
})();
var state_24633__$1 = state_24633;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24642_24693 = state_24633__$1;
(statearr_24642_24693[(1)] = (6));

} else {
var statearr_24643_24694 = state_24633__$1;
(statearr_24643_24694[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (9))){
var inst_24615 = (state_24633[(8)]);
var inst_24617 = (state_24633[(9)]);
var inst_24624 = (state_24633[(2)]);
var inst_24625 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24615,inst_24624);
var inst_24626 = inst_24617.call(null,inst_24625);
var inst_24627 = cljs.core.async.put_BANG_.call(null,port,inst_24626);
var inst_24628 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24644 = state_24633;
(statearr_24644[(4)] = cljs.core.rest.call(null,(state_24633[(4)])));

return statearr_24644;
})();
var state_24633__$1 = (function (){var statearr_24645 = state_24633;
(statearr_24645[(10)] = inst_24627);

return statearr_24645;
})();
var statearr_24646_24695 = state_24633__$1;
(statearr_24646_24695[(2)] = inst_24628);

(statearr_24646_24695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (5))){
var ___$1 = (function (){var statearr_24647 = state_24633;
(statearr_24647[(4)] = cljs.core.rest.call(null,(state_24633[(4)])));

return statearr_24647;
})();
var state_24633__$1 = state_24633;
var ex24640 = (state_24633__$1[(2)]);
var statearr_24648_24696 = state_24633__$1;
(statearr_24648_24696[(5)] = ex24640);


var statearr_24649_24697 = state_24633__$1;
(statearr_24649_24697[(1)] = (4));

(statearr_24649_24697[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24634 === (8))){
var inst_24615 = (state_24633[(8)]);
var inst_24615__$1 = (state_24633[(2)]);
var inst_24616 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24617 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24615__$1;
var query_fuel = inst_24616;
return (function (p1__24527_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24527_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24527_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24618 = cljs.core.PersistentVector.EMPTY;
var inst_24619 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24615__$1;
var query_fuel = inst_24616;
return (function (p1__24526_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24526_SHARP_);
});
})();
var inst_24620 = cljs.core.keep.call(null,inst_24619,expandMaps);
var inst_24621 = cljs.core.async.merge.call(null,inst_24620);
var inst_24622 = cljs.core.async.into.call(null,inst_24618,inst_24621);
var state_24633__$1 = (function (){var statearr_24650 = state_24633;
(statearr_24650[(8)] = inst_24615__$1);

(statearr_24650[(9)] = inst_24617);

return statearr_24650;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24633__$1,(9),inst_24622);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24651 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24651[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24651[(1)] = (1));

return statearr_24651;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24633){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24652){var ex__2749__auto__ = e24652;
var statearr_24653_24698 = state_24633;
(statearr_24653_24698[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24633[(4)]))){
var statearr_24654_24699 = state_24633;
(statearr_24654_24699[(1)] = cljs.core.first.call(null,(state_24633[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24700 = state_24633;
state_24633 = G__24700;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24633){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24655 = f__2769__auto__.call(null);
(statearr_24655[(6)] = c__2768__auto____$1);

return statearr_24655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_24542 = cljs.core.async.onto_chan_BANG_.call(null,inst_24535,tuples_res);
var inst_24543 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24536__$1,inst_24541,inst_24535);
var inst_24544 = cljs.core.PersistentVector.EMPTY;
var inst_24545 = inst_24544;
var state_24586__$1 = (function (){var statearr_24656 = state_24586;
(statearr_24656[(8)] = inst_24536__$1);

(statearr_24656[(9)] = inst_24537__$1);

(statearr_24656[(11)] = inst_24543);

(statearr_24656[(12)] = inst_24545);

(statearr_24656[(13)] = inst_24542);

return statearr_24656;
})();
var statearr_24657_24701 = state_24586__$1;
(statearr_24657_24701[(2)] = null);

(statearr_24657_24701[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (19))){
var inst_24545 = (state_24586[(12)]);
var inst_24548 = (state_24586[(7)]);
var inst_24568 = cljs.core.first.call(null,inst_24548);
var inst_24569 = cljs.core.conj.call(null,inst_24545,inst_24568);
var inst_24545__$1 = inst_24569;
var state_24586__$1 = (function (){var statearr_24658 = state_24586;
(statearr_24658[(12)] = inst_24545__$1);

return statearr_24658;
})();
var statearr_24659_24702 = state_24586__$1;
(statearr_24659_24702[(2)] = null);

(statearr_24659_24702[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (11))){
var inst_24579 = (state_24586[(2)]);
var state_24586__$1 = state_24586;
var statearr_24661_24703 = state_24586__$1;
(statearr_24661_24703[(2)] = inst_24579);

(statearr_24661_24703[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (9))){
var inst_24545 = (state_24586[(12)]);
var state_24586__$1 = state_24586;
var statearr_24662_24704 = state_24586__$1;
(statearr_24662_24704[(2)] = inst_24545);

(statearr_24662_24704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (5))){
var _ = (function (){var statearr_24663 = state_24586;
(statearr_24663[(4)] = cljs.core.rest.call(null,(state_24586[(4)])));

return statearr_24663;
})();
var state_24586__$1 = state_24586;
var ex24660 = (state_24586__$1[(2)]);
var statearr_24664_24705 = state_24586__$1;
(statearr_24664_24705[(5)] = ex24660);


if((ex24660 instanceof Error)){
var statearr_24665_24706 = state_24586__$1;
(statearr_24665_24706[(1)] = (4));

(statearr_24665_24706[(5)] = null);

} else {
throw ex24660;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (14))){
var inst_24577 = (state_24586[(2)]);
var state_24586__$1 = state_24586;
var statearr_24666_24707 = state_24586__$1;
(statearr_24666_24707[(2)] = inst_24577);

(statearr_24666_24707[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (16))){
var state_24586__$1 = state_24586;
var statearr_24667_24708 = state_24586__$1;
(statearr_24667_24708[(2)] = null);

(statearr_24667_24708[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (10))){
var inst_24548 = (state_24586[(7)]);
var inst_24552 = fluree.db.util.core.exception_QMARK_.call(null,inst_24548);
var state_24586__$1 = state_24586;
if(inst_24552){
var statearr_24668_24709 = state_24586__$1;
(statearr_24668_24709[(1)] = (12));

} else {
var statearr_24669_24710 = state_24586__$1;
(statearr_24669_24710[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (18))){
var inst_24537 = (state_24586[(9)]);
var inst_24561 = inst_24537.call(null);
var inst_24562 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24563 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24564 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24565 = cljs.core.PersistentHashMap.fromArrays(inst_24563,inst_24564);
var inst_24566 = cljs.core.ex_info.call(null,inst_24562,inst_24565);
var state_24586__$1 = (function (){var statearr_24670 = state_24586;
(statearr_24670[(14)] = inst_24561);

return statearr_24670;
})();
var statearr_24671_24711 = state_24586__$1;
(statearr_24671_24711[(2)] = inst_24566);

(statearr_24671_24711[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24587 === (8))){
var inst_24548 = (state_24586[(7)]);
var inst_24548__$1 = (state_24586[(2)]);
var inst_24549 = (inst_24548__$1 == null);
var state_24586__$1 = (function (){var statearr_24672 = state_24586;
(statearr_24672[(7)] = inst_24548__$1);

return statearr_24672;
})();
if(cljs.core.truth_(inst_24549)){
var statearr_24673_24712 = state_24586__$1;
(statearr_24673_24712[(1)] = (9));

} else {
var statearr_24674_24713 = state_24586__$1;
(statearr_24674_24713[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24675 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24675[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24675[(1)] = (1));

return statearr_24675;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24586){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24676){var ex__2749__auto__ = e24676;
var statearr_24677_24714 = state_24586;
(statearr_24677_24714[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24586[(4)]))){
var statearr_24678_24715 = state_24586;
(statearr_24678_24715[(1)] = cljs.core.first.call(null,(state_24586[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24716 = state_24586;
state_24586 = G__24716;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24586){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24679 = f__2769__auto__.call(null);
(statearr_24679[(6)] = c__2768__auto__);

return statearr_24679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24717 = select;
var map__24717__$1 = cljs.core.__destructure_map.call(null,map__24717);
var as = cljs.core.get.call(null,map__24717__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__24717__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__24717__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24720 = orderBy;
var order = cljs.core.nth.call(null,vec__24720,(0),null);
var var$ = cljs.core.nth.call(null,vec__24720,(1),null);
var option = cljs.core.nth.call(null,vec__24720,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24718_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__24718_SHARP_,compare_idx));
}):(function (p1__24719_SHARP_){
return cljs.core.nth.call(null,p1__24719_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24725 = arguments.length;
switch (G__24725) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24726,p__24727,group_limit,opts){
var map__24728 = p__24726;
var map__24728__$1 = cljs.core.__destructure_map.call(null,map__24728);
var res = map__24728__$1;
var vars = cljs.core.get.call(null,map__24728__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24729 = p__24727;
var map__24729__$1 = cljs.core.__destructure_map.call(null,map__24729);
var select_spec = map__24729__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24729__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24866){
var state_val_24867 = (state_24866[(1)]);
if((state_val_24867 === (7))){
var inst_24736 = (state_24866[(7)]);
var state_24866__$1 = state_24866;
var statearr_24868_24970 = state_24866__$1;
(statearr_24868_24970[(2)] = inst_24736);

(statearr_24868_24970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (59))){
var inst_24859 = (state_24866[(2)]);
var state_24866__$1 = state_24866;
var statearr_24869_24971 = state_24866__$1;
(statearr_24869_24971[(2)] = inst_24859);

(statearr_24869_24971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (20))){
var inst_24775 = (state_24866[(8)]);
var inst_24772 = (state_24866[(9)]);
var inst_24771 = (state_24866[(2)]);
var inst_24772__$1 = cljs.core.__destructure_map.call(null,inst_24771);
var inst_24773 = cljs.core.get.call(null,inst_24772__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24774 = cljs.core.get.call(null,inst_24772__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24775__$1 = offset;
var state_24866__$1 = (function (){var statearr_24870 = state_24866;
(statearr_24870[(8)] = inst_24775__$1);

(statearr_24870[(10)] = inst_24774);

(statearr_24870[(11)] = inst_24773);

(statearr_24870[(9)] = inst_24772__$1);

return statearr_24870;
})();
if(cljs.core.truth_(inst_24775__$1)){
var statearr_24871_24972 = state_24866__$1;
(statearr_24871_24972[(1)] = (21));

} else {
var statearr_24872_24973 = state_24866__$1;
(statearr_24872_24973[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (58))){
var inst_24851 = (state_24866[(12)]);
var state_24866__$1 = state_24866;
var statearr_24873_24974 = state_24866__$1;
(statearr_24873_24974[(2)] = inst_24851);

(statearr_24873_24974[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (60))){
var inst_24855 = (state_24866[(2)]);
var inst_24856 = fluree.db.util.async.throw_err.call(null,inst_24855);
var state_24866__$1 = state_24866;
var statearr_24874_24975 = state_24866__$1;
(statearr_24874_24975[(2)] = inst_24856);

(statearr_24874_24975[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (27))){
var inst_24787 = cljs.core.not.call(null,inVector_QMARK_);
var state_24866__$1 = state_24866;
var statearr_24875_24976 = state_24866__$1;
(statearr_24875_24976[(2)] = inst_24787);

(statearr_24875_24976[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (1))){
var state_24866__$1 = state_24866;
var statearr_24876_24977 = state_24866__$1;
(statearr_24876_24977[(2)] = null);

(statearr_24876_24977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (24))){
var state_24866__$1 = state_24866;
var statearr_24877_24978 = state_24866__$1;
(statearr_24877_24978[(2)] = offset);

(statearr_24877_24978[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (55))){
var inst_24845 = (state_24866[(13)]);
var state_24866__$1 = state_24866;
var statearr_24878_24979 = state_24866__$1;
(statearr_24878_24979[(2)] = inst_24845);

(statearr_24878_24979[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (39))){
var inst_24813 = (state_24866[(14)]);
var inst_24815 = cljs.core.distinct.call(null);
var inst_24816 = cljs.core.conj.call(null,inst_24813,inst_24815);
var state_24866__$1 = state_24866;
var statearr_24879_24980 = state_24866__$1;
(statearr_24879_24980[(2)] = inst_24816);

(statearr_24879_24980[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (46))){
var inst_24825 = (state_24866[(15)]);
var state_24866__$1 = state_24866;
var statearr_24880_24981 = state_24866__$1;
(statearr_24880_24981[(2)] = inst_24825);

(statearr_24880_24981[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (4))){
var inst_24730 = (state_24866[(2)]);
var state_24866__$1 = state_24866;
var statearr_24881_24982 = state_24866__$1;
(statearr_24881_24982[(2)] = inst_24730);

(statearr_24881_24982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (54))){
var inst_24839 = (state_24866[(16)]);
var inst_24845 = (state_24866[(13)]);
var inst_24847 = cljs.core.PersistentVector.EMPTY;
var inst_24848 = cljs.core.into.call(null,inst_24847,inst_24839,inst_24845);
var state_24866__$1 = state_24866;
var statearr_24882_24983 = state_24866__$1;
(statearr_24882_24983[(2)] = inst_24848);

(statearr_24882_24983[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (15))){
var inst_24757 = (state_24866[(17)]);
var inst_24759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24760 = [inst_24757];
var inst_24761 = (new cljs.core.PersistentVector(null,1,(5),inst_24759,inst_24760,null));
var state_24866__$1 = state_24866;
var statearr_24883_24984 = state_24866__$1;
(statearr_24883_24984[(2)] = inst_24761);

(statearr_24883_24984[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (48))){
var inst_24784 = (state_24866[(18)]);
var inst_24795 = (state_24866[(19)]);
var inst_24831 = (state_24866[(20)]);
var inst_24790 = (state_24866[(21)]);
var inst_24774 = (state_24866[(10)]);
var inst_24773 = (state_24866[(11)]);
var inst_24772 = (state_24866[(9)]);
var inst_24833 = (function (){var map__24766 = inst_24772;
var headers = inst_24773;
var tuples = inst_24774;
var offset_SINGLEQUOTE_ = inst_24784;
var single_result_QMARK_ = inst_24790;
var pp_keys = inst_24795;
var G__24796 = inst_24831;
return (function (p1__24723_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__24723_SHARP_);
});
})();
var inst_24834 = cljs.core.map.call(null,inst_24833);
var inst_24835 = cljs.core.conj.call(null,inst_24831,inst_24834);
var state_24866__$1 = state_24866;
var statearr_24884_24985 = state_24866__$1;
(statearr_24884_24985[(2)] = inst_24835);

(statearr_24884_24985[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (50))){
var inst_24838 = (state_24866[(2)]);
var inst_24839 = cljs.core.apply.call(null,cljs.core.comp,inst_24838);
var state_24866__$1 = (function (){var statearr_24885 = state_24866;
(statearr_24885[(16)] = inst_24839);

return statearr_24885;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24886_24986 = state_24866__$1;
(statearr_24886_24986[(1)] = (51));

} else {
var statearr_24887_24987 = state_24866__$1;
(statearr_24887_24987[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (21))){
var inst_24777 = cljs.core.not.call(null,groupBy);
var state_24866__$1 = state_24866;
var statearr_24888_24988 = state_24866__$1;
(statearr_24888_24988[(2)] = inst_24777);

(statearr_24888_24988[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (31))){
var state_24866__$1 = state_24866;
var statearr_24889_24989 = state_24866__$1;
(statearr_24889_24989[(2)] = null);

(statearr_24889_24989[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (32))){
var inst_24790 = (state_24866[(21)]);
var inst_24773 = (state_24866[(11)]);
var inst_24795 = (state_24866[(2)]);
var inst_24797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24798 = fluree.db.query.fql.select_tuples_fn.call(null,inst_24773,vars,select);
var inst_24799 = cljs.core.map.call(null,inst_24798);
var inst_24800 = [inst_24799];
var inst_24801 = (new cljs.core.PersistentVector(null,1,(5),inst_24797,inst_24800,null));
var state_24866__$1 = (function (){var statearr_24890 = state_24866;
(statearr_24890[(19)] = inst_24795);

(statearr_24890[(22)] = inst_24801);

return statearr_24890;
})();
if(cljs.core.truth_(inst_24790)){
var statearr_24891_24990 = state_24866__$1;
(statearr_24891_24990[(1)] = (33));

} else {
var statearr_24892_24991 = state_24866__$1;
(statearr_24892_24991[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (40))){
var inst_24813 = (state_24866[(14)]);
var state_24866__$1 = state_24866;
var statearr_24893_24992 = state_24866__$1;
(statearr_24893_24992[(2)] = inst_24813);

(statearr_24893_24992[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (56))){
var inst_24851 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24894 = state_24866;
(statearr_24894[(12)] = inst_24851);

return statearr_24894;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24895_24993 = state_24866__$1;
(statearr_24895_24993[(1)] = (57));

} else {
var statearr_24896_24994 = state_24866__$1;
(statearr_24896_24994[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (33))){
var inst_24801 = (state_24866[(22)]);
var inst_24803 = cljs.core.map.call(null,cljs.core.first);
var inst_24804 = cljs.core.conj.call(null,inst_24801,inst_24803);
var state_24866__$1 = state_24866;
var statearr_24897_24995 = state_24866__$1;
(statearr_24897_24995[(2)] = inst_24804);

(statearr_24897_24995[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (13))){
var inst_24746 = (state_24866[(23)]);
var state_24866__$1 = state_24866;
var statearr_24898_24996 = state_24866__$1;
(statearr_24898_24996[(2)] = inst_24746);

(statearr_24898_24996[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (22))){
var inst_24775 = (state_24866[(8)]);
var state_24866__$1 = state_24866;
var statearr_24899_24997 = state_24866__$1;
(statearr_24899_24997[(2)] = inst_24775);

(statearr_24899_24997[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (36))){
var inst_24807 = (state_24866[(24)]);
var inst_24809 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_24810 = cljs.core.conj.call(null,inst_24807,inst_24809);
var state_24866__$1 = state_24866;
var statearr_24900_24998 = state_24866__$1;
(statearr_24900_24998[(2)] = inst_24810);

(statearr_24900_24998[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (41))){
var inst_24784 = (state_24866[(18)]);
var inst_24819 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24901 = state_24866;
(statearr_24901[(25)] = inst_24819);

return statearr_24901;
})();
if(cljs.core.truth_(inst_24784)){
var statearr_24902_24999 = state_24866__$1;
(statearr_24902_24999[(1)] = (42));

} else {
var statearr_24903_25000 = state_24866__$1;
(statearr_24903_25000[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (43))){
var inst_24819 = (state_24866[(25)]);
var state_24866__$1 = state_24866;
var statearr_24904_25001 = state_24866__$1;
(statearr_24904_25001[(2)] = inst_24819);

(statearr_24904_25001[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (29))){
var inst_24790 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24905 = state_24866;
(statearr_24905[(21)] = inst_24790);

return statearr_24905;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24906_25002 = state_24866__$1;
(statearr_24906_25002[(1)] = (30));

} else {
var statearr_24907_25003 = state_24866__$1;
(statearr_24907_25003[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (44))){
var inst_24825 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24908 = state_24866;
(statearr_24908[(15)] = inst_24825);

return statearr_24908;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24909_25004 = state_24866__$1;
(statearr_24909_25004[(1)] = (45));

} else {
var statearr_24910_25005 = state_24866__$1;
(statearr_24910_25005[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (6))){
var inst_24738 = cljs.core.count.call(null,select);
var inst_24739 = cljs.core._EQ_.call(null,(1),inst_24738);
var state_24866__$1 = state_24866;
var statearr_24911_25006 = state_24866__$1;
(statearr_24911_25006[(2)] = inst_24739);

(statearr_24911_25006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (28))){
var inst_24785 = (state_24866[(26)]);
var state_24866__$1 = state_24866;
var statearr_24912_25007 = state_24866__$1;
(statearr_24912_25007[(2)] = inst_24785);

(statearr_24912_25007[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (51))){
var inst_24774 = (state_24866[(10)]);
var inst_24773 = (state_24866[(11)]);
var inst_24842 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_24773,orderBy,inst_24774);
var state_24866__$1 = state_24866;
var statearr_24913_25008 = state_24866__$1;
(statearr_24913_25008[(2)] = inst_24842);

(statearr_24913_25008[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (25))){
var state_24866__$1 = state_24866;
var statearr_24914_25009 = state_24866__$1;
(statearr_24914_25009[(2)] = null);

(statearr_24914_25009[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (34))){
var inst_24801 = (state_24866[(22)]);
var state_24866__$1 = state_24866;
var statearr_24915_25010 = state_24866__$1;
(statearr_24915_25010[(2)] = inst_24801);

(statearr_24915_25010[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (17))){
var inst_24764 = (state_24866[(2)]);
var state_24866__$1 = state_24866;
var statearr_24916_25011 = state_24866__$1;
(statearr_24916_25011[(2)] = inst_24764);

(statearr_24916_25011[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (3))){
var inst_24864 = (state_24866[(2)]);
var state_24866__$1 = state_24866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24866__$1,inst_24864);
} else {
if((state_val_24867 === (12))){
var inst_24746 = (state_24866[(23)]);
var inst_24748 = cljs.core.first.call(null,select);
var inst_24749 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24748);
var inst_24750 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24749);
var inst_24751 = cljs.core.subs.call(null,inst_24750,(1));
var inst_24752 = [inst_24751];
var inst_24753 = [inst_24746];
var inst_24754 = cljs.core.PersistentHashMap.fromArrays(inst_24752,inst_24753);
var state_24866__$1 = state_24866;
var statearr_24917_25012 = state_24866__$1;
(statearr_24917_25012[(2)] = inst_24754);

(statearr_24917_25012[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (2))){
var inst_24736 = (state_24866[(7)]);
var _ = (function (){var statearr_24918 = state_24866;
(statearr_24918[(4)] = cljs.core.cons.call(null,(5),(state_24866[(4)])));

return statearr_24918;
})();
var inst_24736__$1 = aggregates;
var state_24866__$1 = (function (){var statearr_24919 = state_24866;
(statearr_24919[(7)] = inst_24736__$1);

return statearr_24919;
})();
if(cljs.core.truth_(inst_24736__$1)){
var statearr_24920_25013 = state_24866__$1;
(statearr_24920_25013[(1)] = (6));

} else {
var statearr_24921_25014 = state_24866__$1;
(statearr_24921_25014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (23))){
var inst_24780 = (state_24866[(2)]);
var state_24866__$1 = state_24866;
if(cljs.core.truth_(inst_24780)){
var statearr_24922_25015 = state_24866__$1;
(statearr_24922_25015[(1)] = (24));

} else {
var statearr_24923_25016 = state_24866__$1;
(statearr_24923_25016[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (47))){
var inst_24831 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24924 = state_24866;
(statearr_24924[(20)] = inst_24831);

return statearr_24924;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24925_25017 = state_24866__$1;
(statearr_24925_25017[(1)] = (48));

} else {
var statearr_24926_25018 = state_24866__$1;
(statearr_24926_25018[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (35))){
var inst_24807 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24927 = state_24866;
(statearr_24927[(24)] = inst_24807);

return statearr_24927;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24928_25019 = state_24866__$1;
(statearr_24928_25019[(1)] = (36));

} else {
var statearr_24929_25020 = state_24866__$1;
(statearr_24929_25020[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (19))){
var state_24866__$1 = state_24866;
var statearr_24930_25021 = state_24866__$1;
(statearr_24930_25021[(2)] = res);

(statearr_24930_25021[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (57))){
var inst_24851 = (state_24866[(12)]);
var inst_24795 = (state_24866[(19)]);
var inst_24790 = (state_24866[(21)]);
var inst_24853 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_24795,inst_24790,db,fuel,max_fuel,opts,(8),inst_24851);
var state_24866__$1 = state_24866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24866__$1,(60),inst_24853);
} else {
if((state_val_24867 === (11))){
var inst_24861 = (state_24866[(2)]);
var _ = (function (){var statearr_24932 = state_24866;
(statearr_24932[(4)] = cljs.core.rest.call(null,(state_24866[(4)])));

return statearr_24932;
})();
var state_24866__$1 = state_24866;
var statearr_24933_25022 = state_24866__$1;
(statearr_24933_25022[(2)] = inst_24861);

(statearr_24933_25022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (9))){
var inst_24744 = cljs.core.first.call(null,aggregates);
var inst_24745 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24744);
var inst_24746 = cljs.core.second.call(null,inst_24745);
var state_24866__$1 = (function (){var statearr_24934 = state_24866;
(statearr_24934[(23)] = inst_24746);

return statearr_24934;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24935_25023 = state_24866__$1;
(statearr_24935_25023[(1)] = (12));

} else {
var statearr_24936_25024 = state_24866__$1;
(statearr_24936_25024[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (5))){
var _ = (function (){var statearr_24937 = state_24866;
(statearr_24937[(4)] = cljs.core.rest.call(null,(state_24866[(4)])));

return statearr_24937;
})();
var state_24866__$1 = state_24866;
var ex24931 = (state_24866__$1[(2)]);
var statearr_24938_25025 = state_24866__$1;
(statearr_24938_25025[(5)] = ex24931);


if((ex24931 instanceof Error)){
var statearr_24939_25026 = state_24866__$1;
(statearr_24939_25026[(1)] = (4));

(statearr_24939_25026[(5)] = null);

} else {
throw ex24931;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (14))){
var inst_24757 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24940 = state_24866;
(statearr_24940[(17)] = inst_24757);

return statearr_24940;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24941_25027 = state_24866__$1;
(statearr_24941_25027[(1)] = (15));

} else {
var statearr_24942_25028 = state_24866__$1;
(statearr_24942_25028[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (45))){
var inst_24825 = (state_24866[(15)]);
var inst_24827 = cljs.core.take.call(null,group_limit);
var inst_24828 = cljs.core.conj.call(null,inst_24825,inst_24827);
var state_24866__$1 = state_24866;
var statearr_24943_25029 = state_24866__$1;
(statearr_24943_25029[(2)] = inst_24828);

(statearr_24943_25029[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (53))){
var inst_24845 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24944 = state_24866;
(statearr_24944[(13)] = inst_24845);

return statearr_24944;
})();
var statearr_24945_25030 = state_24866__$1;
(statearr_24945_25030[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (26))){
var inst_24785 = (state_24866[(26)]);
var inst_24784 = (state_24866[(2)]);
var inst_24785__$1 = cljs.core.not.call(null,prettyPrint);
var state_24866__$1 = (function (){var statearr_24947 = state_24866;
(statearr_24947[(18)] = inst_24784);

(statearr_24947[(26)] = inst_24785__$1);

return statearr_24947;
})();
if(inst_24785__$1){
var statearr_24948_25031 = state_24866__$1;
(statearr_24948_25031[(1)] = (27));

} else {
var statearr_24949_25032 = state_24866__$1;
(statearr_24949_25032[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (16))){
var inst_24757 = (state_24866[(17)]);
var state_24866__$1 = state_24866;
var statearr_24950_25033 = state_24866__$1;
(statearr_24950_25033[(2)] = inst_24757);

(statearr_24950_25033[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (38))){
var inst_24813 = (state_24866[(2)]);
var state_24866__$1 = (function (){var statearr_24951 = state_24866;
(statearr_24951[(14)] = inst_24813);

return statearr_24951;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24952_25034 = state_24866__$1;
(statearr_24952_25034[(1)] = (39));

} else {
var statearr_24953_25035 = state_24866__$1;
(statearr_24953_25035[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (30))){
var inst_24792 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24866__$1 = state_24866;
var statearr_24954_25036 = state_24866__$1;
(statearr_24954_25036[(2)] = inst_24792);

(statearr_24954_25036[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (10))){
var state_24866__$1 = state_24866;
if(cljs.core.truth_(aggregates)){
var statearr_24955_25037 = state_24866__$1;
(statearr_24955_25037[(1)] = (18));

} else {
var statearr_24956_25038 = state_24866__$1;
(statearr_24956_25038[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (18))){
var inst_24768 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24866__$1 = state_24866;
var statearr_24957_25039 = state_24866__$1;
(statearr_24957_25039[(2)] = inst_24768);

(statearr_24957_25039[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (52))){
var inst_24774 = (state_24866[(10)]);
var state_24866__$1 = state_24866;
var statearr_24958_25040 = state_24866__$1;
(statearr_24958_25040[(2)] = inst_24774);

(statearr_24958_25040[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (42))){
var inst_24819 = (state_24866[(25)]);
var inst_24784 = (state_24866[(18)]);
var inst_24821 = cljs.core.drop.call(null,inst_24784);
var inst_24822 = cljs.core.conj.call(null,inst_24819,inst_24821);
var state_24866__$1 = state_24866;
var statearr_24959_25041 = state_24866__$1;
(statearr_24959_25041[(2)] = inst_24822);

(statearr_24959_25041[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (37))){
var inst_24807 = (state_24866[(24)]);
var state_24866__$1 = state_24866;
var statearr_24960_25042 = state_24866__$1;
(statearr_24960_25042[(2)] = inst_24807);

(statearr_24960_25042[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (8))){
var inst_24742 = (state_24866[(2)]);
var state_24866__$1 = state_24866;
if(cljs.core.truth_(inst_24742)){
var statearr_24961_25043 = state_24866__$1;
(statearr_24961_25043[(1)] = (9));

} else {
var statearr_24962_25044 = state_24866__$1;
(statearr_24962_25044[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24867 === (49))){
var inst_24831 = (state_24866[(20)]);
var state_24866__$1 = state_24866;
var statearr_24963_25045 = state_24866__$1;
(statearr_24963_25045[(2)] = inst_24831);

(statearr_24963_25045[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_24964 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24964[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_24964[(1)] = (1));

return statearr_24964;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24866){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24965){var ex__2749__auto__ = e24965;
var statearr_24966_25046 = state_24866;
(statearr_24966_25046[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24866[(4)]))){
var statearr_24967_25047 = state_24866;
(statearr_24967_25047[(1)] = cljs.core.first.call(null,(state_24866[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25048 = state_24866;
state_24866 = G__25048;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24866){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24968 = f__2769__auto__.call(null);
(statearr_24968[(6)] = c__2768__auto__);

return statearr_24968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25051,groupBy){
var map__25052 = p__25051;
var map__25052__$1 = cljs.core.__destructure_map.call(null,map__25052);
var res = map__25052__$1;
var headers = cljs.core.get.call(null,map__25052__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25052__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25053 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25053,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25053,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25049_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25049_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25050_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25050_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25056 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25056,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25056,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25059,headers,group_map){
var map__25060 = p__25059;
var map__25060__$1 = cljs.core.__destructure_map.call(null,map__25060);
var having = map__25060__$1;
var params = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,params,headers);
var filtered = (function (){var G__25067 = group_map;
var vec__25068 = G__25067;
var seq__25069 = cljs.core.seq.call(null,vec__25068);
var first__25070 = cljs.core.first.call(null,seq__25069);
var seq__25069__$1 = cljs.core.next.call(null,seq__25069);
var vec__25071 = first__25070;
var k = cljs.core.nth.call(null,vec__25071,(0),null);
var tuples = cljs.core.nth.call(null,vec__25071,(1),null);
var r = seq__25069__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25067__$1 = G__25067;
var acc__$1 = acc;
while(true){
var vec__25081 = G__25067__$1;
var seq__25082 = cljs.core.seq.call(null,vec__25081);
var first__25083 = cljs.core.first.call(null,seq__25082);
var seq__25082__$1 = cljs.core.next.call(null,seq__25082);
var vec__25084 = first__25083;
var k__$1 = cljs.core.nth.call(null,vec__25084,(0),null);
var tuples__$1 = cljs.core.nth.call(null,vec__25084,(1),null);
var r__$1 = seq__25082__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten.call(null,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,tuples__$1));
var res = (function (){try{return function$.call(null,argument);
}catch (e25087){var e = e25087;
fluree.db.util.log.error.call(null,e,["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join(''));

throw cljs.core.ex_info.call(null,["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message.call(null,e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25088 = r__$1;
var G__25089 = cljs.core.assoc.call(null,acc__$2,k__$1,tuples__$1);
G__25067__$1 = G__25088;
acc__$1 = G__25089;
continue;
} else {
var G__25090 = r__$1;
var G__25091 = acc__$2;
G__25067__$1 = G__25090;
acc__$1 = G__25091;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25092,p__25093,opts){
var map__25094 = p__25092;
var map__25094__$1 = cljs.core.__destructure_map.call(null,map__25094);
var res = map__25094__$1;
var headers = cljs.core.get.call(null,map__25094__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25094__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25095 = p__25093;
var map__25095__$1 = cljs.core.__destructure_map.call(null,map__25095);
var select_spec = map__25095__$1;
var groupBy = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.call(null,map__25095__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25219){
var state_val_25220 = (state_25219[(1)]);
if((state_val_25220 === (7))){
var state_25219__$1 = state_25219;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25221_25294 = state_25219__$1;
(statearr_25221_25294[(1)] = (30));

} else {
var statearr_25222_25295 = state_25219__$1;
(statearr_25222_25295[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (20))){
var inst_25126 = (state_25219[(2)]);
var state_25219__$1 = (function (){var statearr_25223 = state_25219;
(statearr_25223[(7)] = inst_25126);

return statearr_25223;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25224_25296 = state_25219__$1;
(statearr_25224_25296[(1)] = (21));

} else {
var statearr_25225_25297 = state_25219__$1;
(statearr_25225_25297[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (27))){
var inst_25152 = (state_25219[(8)]);
var state_25219__$1 = state_25219;
var statearr_25226_25298 = state_25219__$1;
(statearr_25226_25298[(2)] = inst_25152);

(statearr_25226_25298[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (1))){
var state_25219__$1 = state_25219;
var statearr_25227_25299 = state_25219__$1;
(statearr_25227_25299[(2)] = null);

(statearr_25227_25299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (24))){
var inst_25163 = (state_25219[(9)]);
var inst_25151 = (state_25219[(10)]);
var inst_25160 = cljs.core.seq.call(null,inst_25151);
var inst_25161 = cljs.core.first.call(null,inst_25160);
var inst_25162 = cljs.core.next.call(null,inst_25160);
var inst_25163__$1 = cljs.core.nth.call(null,inst_25161,(0),null);
var inst_25164 = cljs.core.nth.call(null,inst_25161,(1),null);
var state_25219__$1 = (function (){var statearr_25228 = state_25219;
(statearr_25228[(11)] = inst_25162);

(statearr_25228[(12)] = inst_25164);

(statearr_25228[(9)] = inst_25163__$1);

return statearr_25228;
})();
if(cljs.core.truth_(inst_25163__$1)){
var statearr_25229_25300 = state_25219__$1;
(statearr_25229_25300[(1)] = (26));

} else {
var statearr_25230_25301 = state_25219__$1;
(statearr_25230_25301[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (39))){
var inst_25200 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25231_25302 = state_25219__$1;
(statearr_25231_25302[(2)] = inst_25200);

(statearr_25231_25302[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (4))){
var inst_25096 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25232_25303 = state_25219__$1;
(statearr_25232_25303[(2)] = inst_25096);

(statearr_25232_25303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (15))){
var inst_25116 = (state_25219[(13)]);
var inst_25118 = cljs.core.drop.call(null,offset,inst_25116);
var state_25219__$1 = state_25219;
var statearr_25233_25304 = state_25219__$1;
(statearr_25233_25304[(2)] = inst_25118);

(statearr_25233_25304[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (21))){
var inst_25126 = (state_25219[(7)]);
var inst_25128 = cljs.core.take.call(null,(1),inst_25126);
var state_25219__$1 = state_25219;
var statearr_25234_25305 = state_25219__$1;
(statearr_25234_25305[(2)] = inst_25128);

(statearr_25234_25305[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (31))){
var state_25219__$1 = state_25219;
var statearr_25235_25306 = state_25219__$1;
(statearr_25235_25306[(2)] = limit);

(statearr_25235_25306[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (32))){
var inst_25186 = (state_25219[(2)]);
var inst_25187 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25186,opts);
var state_25219__$1 = state_25219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25219__$1,(33),inst_25187);
} else {
if((state_val_25220 === (40))){
var inst_25190 = (state_25219[(14)]);
var inst_25203 = cljs.core.first.call(null,inst_25190);
var state_25219__$1 = state_25219;
var statearr_25236_25307 = state_25219__$1;
(statearr_25236_25307[(2)] = inst_25203);

(statearr_25236_25307[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (33))){
var inst_25190 = (state_25219[(14)]);
var inst_25189 = (state_25219[(2)]);
var inst_25190__$1 = fluree.db.util.async.throw_err.call(null,inst_25189);
var inst_25191 = cljs.core.coll_QMARK_.call(null,inst_25190__$1);
var inst_25192 = (!(inst_25191));
var state_25219__$1 = (function (){var statearr_25237 = state_25219;
(statearr_25237[(14)] = inst_25190__$1);

return statearr_25237;
})();
if(inst_25192){
var statearr_25238_25308 = state_25219__$1;
(statearr_25238_25308[(1)] = (34));

} else {
var statearr_25239_25309 = state_25219__$1;
(statearr_25239_25309[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (13))){
var inst_25111 = (state_25219[(15)]);
var state_25219__$1 = state_25219;
var statearr_25240_25310 = state_25219__$1;
(statearr_25240_25310[(2)] = inst_25111);

(statearr_25240_25310[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (22))){
var inst_25126 = (state_25219[(7)]);
var state_25219__$1 = state_25219;
var statearr_25241_25311 = state_25219__$1;
(statearr_25241_25311[(2)] = inst_25126);

(statearr_25241_25311[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (36))){
var inst_25212 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25242_25312 = state_25219__$1;
(statearr_25242_25312[(2)] = inst_25212);

(statearr_25242_25312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (41))){
var state_25219__$1 = state_25219;
var statearr_25243_25313 = state_25219__$1;
(statearr_25243_25313[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (43))){
var inst_25190 = (state_25219[(14)]);
var state_25219__$1 = state_25219;
var statearr_25245_25314 = state_25219__$1;
(statearr_25245_25314[(2)] = inst_25190);

(statearr_25245_25314[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (29))){
var inst_25162 = (state_25219[(11)]);
var inst_25152 = (state_25219[(8)]);
var inst_25163 = (state_25219[(9)]);
var inst_25173 = (state_25219[(2)]);
var inst_25174 = fluree.db.util.async.throw_err.call(null,inst_25173);
var inst_25175 = cljs.core.assoc.call(null,inst_25152,inst_25163,inst_25174);
var inst_25151 = inst_25162;
var inst_25152__$1 = inst_25175;
var state_25219__$1 = (function (){var statearr_25246 = state_25219;
(statearr_25246[(8)] = inst_25152__$1);

(statearr_25246[(10)] = inst_25151);

return statearr_25246;
})();
var statearr_25247_25315 = state_25219__$1;
(statearr_25247_25315[(2)] = null);

(statearr_25247_25315[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (44))){
var state_25219__$1 = state_25219;
var statearr_25248_25316 = state_25219__$1;
(statearr_25248_25316[(2)] = null);

(statearr_25248_25316[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (6))){
var inst_25103 = (state_25219[(16)]);
var inst_25103__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25105 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25219__$1 = (function (){var statearr_25249 = state_25219;
(statearr_25249[(16)] = inst_25103__$1);

(statearr_25249[(17)] = inst_25105);

return statearr_25249;
})();
if(cljs.core.truth_(inst_25103__$1)){
var statearr_25250_25317 = state_25219__$1;
(statearr_25250_25317[(1)] = (9));

} else {
var statearr_25251_25318 = state_25219__$1;
(statearr_25251_25318[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (28))){
var inst_25179 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25252_25319 = state_25219__$1;
(statearr_25252_25319[(2)] = inst_25179);

(statearr_25252_25319[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (25))){
var inst_25181 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25253_25320 = state_25219__$1;
(statearr_25253_25320[(2)] = inst_25181);

(statearr_25253_25320[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (34))){
var state_25219__$1 = state_25219;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25254_25321 = state_25219__$1;
(statearr_25254_25321[(1)] = (37));

} else {
var statearr_25255_25322 = state_25219__$1;
(statearr_25255_25322[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (17))){
var inst_25121 = (state_25219[(2)]);
var state_25219__$1 = (function (){var statearr_25256 = state_25219;
(statearr_25256[(18)] = inst_25121);

return statearr_25256;
})();
if(cljs.core.truth_(limit)){
var statearr_25257_25323 = state_25219__$1;
(statearr_25257_25323[(1)] = (18));

} else {
var statearr_25258_25324 = state_25219__$1;
(statearr_25258_25324[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (3))){
var inst_25217 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25219__$1,inst_25217);
} else {
if((state_val_25220 === (12))){
var inst_25111 = (state_25219[(15)]);
var inst_25113 = fluree.db.query.fql.filter_having.call(null,having,headers,inst_25111);
var state_25219__$1 = state_25219;
var statearr_25259_25325 = state_25219__$1;
(statearr_25259_25325[(2)] = inst_25113);

(statearr_25259_25325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (2))){
var _ = (function (){var statearr_25260 = state_25219;
(statearr_25260[(4)] = cljs.core.cons.call(null,(5),(state_25219[(4)])));

return statearr_25260;
})();
var state_25219__$1 = state_25219;
if(cljs.core.truth_(groupBy)){
var statearr_25261_25326 = state_25219__$1;
(statearr_25261_25326[(1)] = (6));

} else {
var statearr_25262_25327 = state_25219__$1;
(statearr_25262_25327[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (23))){
var inst_25131 = (state_25219[(2)]);
var inst_25145 = cljs.core.seq.call(null,inst_25131);
var inst_25146 = cljs.core.first.call(null,inst_25145);
var inst_25147 = cljs.core.next.call(null,inst_25145);
var inst_25148 = cljs.core.nth.call(null,inst_25146,(0),null);
var inst_25149 = cljs.core.nth.call(null,inst_25146,(1),null);
var inst_25150 = cljs.core.PersistentHashMap.EMPTY;
var inst_25151 = inst_25131;
var inst_25152 = inst_25150;
var state_25219__$1 = (function (){var statearr_25263 = state_25219;
(statearr_25263[(8)] = inst_25152);

(statearr_25263[(19)] = inst_25147);

(statearr_25263[(20)] = inst_25148);

(statearr_25263[(21)] = inst_25149);

(statearr_25263[(10)] = inst_25151);

return statearr_25263;
})();
var statearr_25264_25328 = state_25219__$1;
(statearr_25264_25328[(2)] = null);

(statearr_25264_25328[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (35))){
var state_25219__$1 = state_25219;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25265_25329 = state_25219__$1;
(statearr_25265_25329[(1)] = (40));

} else {
var statearr_25266_25330 = state_25219__$1;
(statearr_25266_25330[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (19))){
var inst_25121 = (state_25219[(18)]);
var state_25219__$1 = state_25219;
var statearr_25267_25331 = state_25219__$1;
(statearr_25267_25331[(2)] = inst_25121);

(statearr_25267_25331[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (11))){
var inst_25111 = (state_25219[(2)]);
var state_25219__$1 = (function (){var statearr_25269 = state_25219;
(statearr_25269[(15)] = inst_25111);

return statearr_25269;
})();
if(cljs.core.truth_(having)){
var statearr_25270_25332 = state_25219__$1;
(statearr_25270_25332[(1)] = (12));

} else {
var statearr_25271_25333 = state_25219__$1;
(statearr_25271_25333[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (9))){
var inst_25103 = (state_25219[(16)]);
var inst_25105 = (state_25219[(17)]);
var inst_25107 = cljs.core.sorted_map_by.call(null,inst_25103);
var inst_25108 = cljs.core.into.call(null,inst_25107,inst_25105);
var state_25219__$1 = state_25219;
var statearr_25272_25334 = state_25219__$1;
(statearr_25272_25334[(2)] = inst_25108);

(statearr_25272_25334[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (5))){
var _ = (function (){var statearr_25273 = state_25219;
(statearr_25273[(4)] = cljs.core.rest.call(null,(state_25219[(4)])));

return statearr_25273;
})();
var state_25219__$1 = state_25219;
var ex25268 = (state_25219__$1[(2)]);
var statearr_25274_25335 = state_25219__$1;
(statearr_25274_25335[(5)] = ex25268);


if((ex25268 instanceof Error)){
var statearr_25275_25336 = state_25219__$1;
(statearr_25275_25336[(1)] = (4));

(statearr_25275_25336[(5)] = null);

} else {
throw ex25268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (14))){
var inst_25116 = (state_25219[(2)]);
var state_25219__$1 = (function (){var statearr_25276 = state_25219;
(statearr_25276[(13)] = inst_25116);

return statearr_25276;
})();
if(cljs.core.truth_(offset)){
var statearr_25277_25337 = state_25219__$1;
(statearr_25277_25337[(1)] = (15));

} else {
var statearr_25278_25338 = state_25219__$1;
(statearr_25278_25338[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (45))){
var inst_25208 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25279_25339 = state_25219__$1;
(statearr_25279_25339[(2)] = inst_25208);

(statearr_25279_25339[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (26))){
var inst_25164 = (state_25219[(12)]);
var inst_25166 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25167 = [headers,vars,inst_25164];
var inst_25168 = cljs.core.PersistentHashMap.fromArrays(inst_25166,inst_25167);
var inst_25169 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25170 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25171 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25168,inst_25169,inst_25170);
var state_25219__$1 = state_25219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25219__$1,(29),inst_25171);
} else {
if((state_val_25220 === (16))){
var inst_25116 = (state_25219[(13)]);
var state_25219__$1 = state_25219;
var statearr_25280_25340 = state_25219__$1;
(statearr_25280_25340[(2)] = inst_25116);

(statearr_25280_25340[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (38))){
var inst_25190 = (state_25219[(14)]);
var state_25219__$1 = state_25219;
var statearr_25281_25341 = state_25219__$1;
(statearr_25281_25341[(2)] = inst_25190);

(statearr_25281_25341[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (30))){
var state_25219__$1 = state_25219;
var statearr_25282_25342 = state_25219__$1;
(statearr_25282_25342[(2)] = (1));

(statearr_25282_25342[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (10))){
var inst_25105 = (state_25219[(17)]);
var state_25219__$1 = state_25219;
var statearr_25283_25343 = state_25219__$1;
(statearr_25283_25343[(2)] = inst_25105);

(statearr_25283_25343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (18))){
var inst_25121 = (state_25219[(18)]);
var inst_25123 = cljs.core.take.call(null,limit,inst_25121);
var state_25219__$1 = state_25219;
var statearr_25284_25344 = state_25219__$1;
(statearr_25284_25344[(2)] = inst_25123);

(statearr_25284_25344[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (42))){
var inst_25210 = (state_25219[(2)]);
var state_25219__$1 = state_25219;
var statearr_25285_25345 = state_25219__$1;
(statearr_25285_25345[(2)] = inst_25210);

(statearr_25285_25345[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (37))){
var inst_25190 = (state_25219[(14)]);
var inst_25195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25196 = [inst_25190];
var inst_25197 = (new cljs.core.PersistentVector(null,1,(5),inst_25195,inst_25196,null));
var state_25219__$1 = state_25219;
var statearr_25286_25346 = state_25219__$1;
(statearr_25286_25346[(2)] = inst_25197);

(statearr_25286_25346[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25220 === (8))){
var inst_25214 = (state_25219[(2)]);
var _ = (function (){var statearr_25287 = state_25219;
(statearr_25287[(4)] = cljs.core.rest.call(null,(state_25219[(4)])));

return statearr_25287;
})();
var state_25219__$1 = state_25219;
var statearr_25288_25347 = state_25219__$1;
(statearr_25288_25347[(2)] = inst_25214);

(statearr_25288_25347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_25289 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25289[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_25289[(1)] = (1));

return statearr_25289;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_25219){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25290){var ex__2749__auto__ = e25290;
var statearr_25291_25348 = state_25219;
(statearr_25291_25348[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25219[(4)]))){
var statearr_25292_25349 = state_25219;
(statearr_25292_25349[(1)] = cljs.core.first.call(null,(state_25219[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25350 = state_25219;
state_25219 = G__25350;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_25219){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_25219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25293 = f__2769__auto__.call(null);
(statearr_25293[(6)] = c__2768__auto__);

return statearr_25293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25411){
var state_val_25412 = (state_25411[(1)]);
if((state_val_25412 === (7))){
var state_25411__$1 = state_25411;
var statearr_25413_25451 = state_25411__$1;
(statearr_25413_25451[(2)] = (0));

(statearr_25413_25451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (20))){
var inst_25395 = (state_25411[(2)]);
var state_25411__$1 = state_25411;
var statearr_25414_25452 = state_25411__$1;
(statearr_25414_25452[(2)] = inst_25395);

(statearr_25414_25452[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (1))){
var state_25411__$1 = state_25411;
var statearr_25415_25453 = state_25411__$1;
(statearr_25415_25453[(2)] = null);

(statearr_25415_25453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (4))){
var inst_25351 = (state_25411[(2)]);
var state_25411__$1 = state_25411;
var statearr_25416_25454 = state_25411__$1;
(statearr_25416_25454[(2)] = inst_25351);

(statearr_25416_25454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (15))){
var inst_25382 = (state_25411[(7)]);
var state_25411__$1 = state_25411;
var statearr_25417_25455 = state_25411__$1;
(statearr_25417_25455[(2)] = inst_25382);

(statearr_25417_25455[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (21))){
var inst_25397 = (state_25411[(8)]);
var inst_25382 = (state_25411[(7)]);
var inst_25367 = (state_25411[(9)]);
var inst_25400 = (state_25411[(2)]);
var inst_25401 = fluree.db.util.async.throw_err.call(null,inst_25400);
var inst_25402 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25403 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_25397,inst_25382,inst_25401,inst_25402,inst_25367);
var state_25411__$1 = state_25411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25411__$1,(22),inst_25403);
} else {
if((state_val_25412 === (13))){
var inst_25382 = (state_25411[(7)]);
var state_25411__$1 = state_25411;
if(cljs.core.truth_(inst_25382)){
var statearr_25418_25456 = state_25411__$1;
(statearr_25418_25456[(1)] = (15));

} else {
var statearr_25419_25457 = state_25411__$1;
(statearr_25419_25457[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (22))){
var inst_25405 = (state_25411[(2)]);
var inst_25406 = fluree.db.util.async.throw_err.call(null,inst_25405);
var _ = (function (){var statearr_25420 = state_25411;
(statearr_25420[(4)] = cljs.core.rest.call(null,(state_25411[(4)])));

return statearr_25420;
})();
var state_25411__$1 = state_25411;
var statearr_25421_25458 = state_25411__$1;
(statearr_25421_25458[(2)] = inst_25406);

(statearr_25421_25458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (6))){
var inst_25362 = (state_25411[(10)]);
var state_25411__$1 = state_25411;
var statearr_25422_25459 = state_25411__$1;
(statearr_25422_25459[(2)] = inst_25362);

(statearr_25422_25459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (17))){
var inst_25390 = (state_25411[(2)]);
var state_25411__$1 = state_25411;
if(cljs.core.truth_(inst_25390)){
var statearr_25423_25460 = state_25411__$1;
(statearr_25423_25460[(1)] = (18));

} else {
var statearr_25424_25461 = state_25411__$1;
(statearr_25424_25461[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (3))){
var inst_25409 = (state_25411[(2)]);
var state_25411__$1 = state_25411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25411__$1,inst_25409);
} else {
if((state_val_25412 === (12))){
var inst_25383 = (state_25411[(11)]);
var state_25411__$1 = state_25411;
var statearr_25425_25462 = state_25411__$1;
(statearr_25425_25462[(2)] = inst_25383);

(statearr_25425_25462[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (2))){
var inst_25362 = (state_25411[(10)]);
var _ = (function (){var statearr_25426 = state_25411;
(statearr_25426[(4)] = cljs.core.cons.call(null,(5),(state_25411[(4)])));

return statearr_25426;
})();
var inst_25358 = query_map;
var inst_25359 = cljs.core.__destructure_map.call(null,inst_25358);
var inst_25360 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_25361 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25362__$1 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25363 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25364 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25365 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_25366 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_25367 = cljs.core.get.call(null,inst_25359,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_25369 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_25411__$1 = (function (){var statearr_25427 = state_25411;
(statearr_25427[(12)] = inst_25364);

(statearr_25427[(10)] = inst_25362__$1);

(statearr_25427[(13)] = inst_25363);

(statearr_25427[(14)] = inst_25360);

(statearr_25427[(15)] = inst_25361);

(statearr_25427[(16)] = inst_25366);

(statearr_25427[(17)] = inst_25369);

(statearr_25427[(9)] = inst_25367);

(statearr_25427[(18)] = inst_25365);

return statearr_25427;
})();
if(cljs.core.truth_(inst_25362__$1)){
var statearr_25428_25463 = state_25411__$1;
(statearr_25428_25463[(1)] = (6));

} else {
var statearr_25429_25464 = state_25411__$1;
(statearr_25429_25464[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (19))){
var state_25411__$1 = state_25411;
var statearr_25430_25465 = state_25411__$1;
(statearr_25430_25465[(2)] = null);

(statearr_25430_25465[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (11))){
var inst_25383 = (state_25411[(11)]);
var inst_25381 = (state_25411[(19)]);
var inst_25367 = (state_25411[(9)]);
var inst_25381__$1 = (state_25411[(2)]);
var inst_25382 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_25381__$1);
var inst_25383__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_25367);
var state_25411__$1 = (function (){var statearr_25432 = state_25411;
(statearr_25432[(11)] = inst_25383__$1);

(statearr_25432[(7)] = inst_25382);

(statearr_25432[(19)] = inst_25381__$1);

return statearr_25432;
})();
if(cljs.core.truth_(inst_25383__$1)){
var statearr_25433_25466 = state_25411__$1;
(statearr_25433_25466[(1)] = (12));

} else {
var statearr_25434_25467 = state_25411__$1;
(statearr_25434_25467[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (9))){
var inst_25376 = (state_25411[(20)]);
var inst_25378 = cljs.core.assoc.call(null,inst_25376,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_25411__$1 = state_25411;
var statearr_25435_25468 = state_25411__$1;
(statearr_25435_25468[(2)] = inst_25378);

(statearr_25435_25468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (5))){
var _ = (function (){var statearr_25436 = state_25411;
(statearr_25436[(4)] = cljs.core.rest.call(null,(state_25411[(4)])));

return statearr_25436;
})();
var state_25411__$1 = state_25411;
var ex25431 = (state_25411__$1[(2)]);
var statearr_25437_25469 = state_25411__$1;
(statearr_25437_25469[(5)] = ex25431);


if((ex25431 instanceof Error)){
var statearr_25438_25470 = state_25411__$1;
(statearr_25438_25470[(1)] = (4));

(statearr_25438_25470[(5)] = null);

} else {
throw ex25431;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (14))){
var inst_25397 = (state_25411[(8)]);
var inst_25382 = (state_25411[(7)]);
var inst_25381 = (state_25411[(19)]);
var inst_25397__$1 = (state_25411[(2)]);
var inst_25398 = fluree.db.query.analytical.q.call(null,query_map,inst_25397__$1,inst_25382,db,inst_25381);
var state_25411__$1 = (function (){var statearr_25439 = state_25411;
(statearr_25439[(8)] = inst_25397__$1);

return statearr_25439;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25411__$1,(21),inst_25398);
} else {
if((state_val_25412 === (16))){
var inst_25367 = (state_25411[(9)]);
var inst_25388 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_25367);
var state_25411__$1 = state_25411;
var statearr_25440_25471 = state_25411__$1;
(statearr_25440_25471[(2)] = inst_25388);

(statearr_25440_25471[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (10))){
var inst_25376 = (state_25411[(20)]);
var state_25411__$1 = state_25411;
var statearr_25441_25472 = state_25411__$1;
(statearr_25441_25472[(2)] = inst_25376);

(statearr_25441_25472[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (18))){
var inst_25392 = cljs.core.volatile_BANG_.call(null,(0));
var state_25411__$1 = state_25411;
var statearr_25442_25473 = state_25411__$1;
(statearr_25442_25473[(2)] = inst_25392);

(statearr_25442_25473[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25412 === (8))){
var inst_25364 = (state_25411[(12)]);
var inst_25363 = (state_25411[(13)]);
var inst_25360 = (state_25411[(14)]);
var inst_25361 = (state_25411[(15)]);
var inst_25366 = (state_25411[(16)]);
var inst_25369 = (state_25411[(17)]);
var inst_25367 = (state_25411[(9)]);
var inst_25365 = (state_25411[(18)]);
var inst_25373 = (state_25411[(2)]);
var inst_25374 = [inst_25361,inst_25373,inst_25363,inst_25364,inst_25365,inst_25366];
var inst_25375 = cljs.core.PersistentHashMap.fromArrays(inst_25369,inst_25374);
var inst_25376 = cljs.core.merge.call(null,inst_25375,inst_25367);
var state_25411__$1 = (function (){var statearr_25443 = state_25411;
(statearr_25443[(20)] = inst_25376);

return statearr_25443;
})();
if(cljs.core.truth_(inst_25360)){
var statearr_25444_25474 = state_25411__$1;
(statearr_25444_25474[(1)] = (9));

} else {
var statearr_25445_25475 = state_25411__$1;
(statearr_25445_25475[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25446[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__);

(statearr_25446[(1)] = (1));

return statearr_25446;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_25411){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25447){var ex__2749__auto__ = e25447;
var statearr_25448_25476 = state_25411;
(statearr_25448_25476[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25411[(4)]))){
var statearr_25449_25477 = state_25411;
(statearr_25449_25477[(1)] = cljs.core.first.call(null,(state_25411[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25478 = state_25411;
state_25411 = G__25478;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = function(state_25411){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_25411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25450 = f__2769__auto__.call(null);
(statearr_25450[(6)] = c__2768__auto__);

return statearr_25450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25479,p__25480){
var map__25481 = p__25479;
var map__25481__$1 = cljs.core.__destructure_map.call(null,map__25481);
var db = map__25481__$1;
var network = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25482 = p__25480;
var map__25482__$1 = cljs.core.__destructure_map.call(null,map__25482);
var query_map = map__25482__$1;
var opts = cljs.core.get.call(null,map__25482__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___25499 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25492){
var state_val_25493 = (state_25492[(1)]);
if((state_val_25493 === (1))){
var inst_25483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25484 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25485 = (new cljs.core.PersistentVector(null,2,(5),inst_25483,inst_25484,null));
var inst_25486 = cljs.core.assoc_in.call(null,query_map,inst_25485,false);
var inst_25487 = fluree.db.query.fql.query.call(null,db,inst_25486);
var state_25492__$1 = state_25492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25492__$1,(2),inst_25487);
} else {
if((state_val_25493 === (2))){
var inst_25489 = (state_25492[(2)]);
var inst_25490 = cljs.core.async.put_BANG_.call(null,pc,inst_25489);
var state_25492__$1 = state_25492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25492__$1,inst_25490);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25494 = [null,null,null,null,null,null,null];
(statearr_25494[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2746__auto__);

(statearr_25494[(1)] = (1));

return statearr_25494;
});
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1 = (function (state_25492){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25495){var ex__2749__auto__ = e25495;
var statearr_25496_25500 = state_25492;
(statearr_25496_25500[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25492[(4)]))){
var statearr_25497_25501 = state_25492;
(statearr_25497_25501[(1)] = cljs.core.first.call(null,(state_25492[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25502 = state_25492;
state_25492 = G__25502;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = function(state_25492){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1.call(this,state_25492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25498 = f__2769__auto__.call(null);
(statearr_25498[(6)] = c__2768__auto___25499);

return statearr_25498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25503){
var map__25504 = p__25503;
var map__25504__$1 = cljs.core.__destructure_map.call(null,map__25504);
var _query_map = map__25504__$1;
var opts = cljs.core.get.call(null,map__25504__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
