// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19811_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19811_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19815 = coll;
var vec__19816 = G__19815;
var seq__19817 = cljs.core.seq.call(null,vec__19816);
var first__19818 = cljs.core.first.call(null,seq__19817);
var seq__19817__$1 = cljs.core.next.call(null,seq__19817);
var clause = first__19818;
var r = seq__19817__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19815__$1 = G__19815;
var res__$1 = res;
while(true){
var vec__19822 = G__19815__$1;
var seq__19823 = cljs.core.seq.call(null,vec__19822);
var first__19824 = cljs.core.first.call(null,seq__19823);
var seq__19823__$1 = cljs.core.next.call(null,seq__19823);
var clause__$1 = first__19824;
var r__$1 = seq__19823__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19825 = r__$1;
var G__19826 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19815__$1 = G__19825;
res__$1 = G__19826;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__19827){
var map__19828 = p__19827;
var map__19828__$1 = cljs.core.__destructure_map.call(null,map__19828);
var optional = cljs.core.get.call(null,map__19828__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19832 = coll;
var vec__19833 = G__19832;
var seq__19834 = cljs.core.seq.call(null,vec__19833);
var first__19835 = cljs.core.first.call(null,seq__19834);
var seq__19834__$1 = cljs.core.next.call(null,seq__19834);
var clause = first__19835;
var r = seq__19834__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19832__$1 = G__19832;
var res__$1 = res;
while(true){
var vec__19839 = G__19832__$1;
var seq__19840 = cljs.core.seq.call(null,vec__19839);
var first__19841 = cljs.core.first.call(null,seq__19840);
var seq__19840__$1 = cljs.core.next.call(null,seq__19840);
var clause__$1 = first__19841;
var r__$1 = seq__19840__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19842 = r__$1;
var G__19843 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19832__$1 = G__19842;
res__$1 = G__19843;
continue;
} else {
var G__19844 = r__$1;
var G__19845 = res__$2;
G__19832__$1 = G__19844;
res__$1 = G__19845;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19849 = coll;
var vec__19850 = G__19849;
var seq__19851 = cljs.core.seq.call(null,vec__19850);
var first__19852 = cljs.core.first.call(null,seq__19851);
var seq__19851__$1 = cljs.core.next.call(null,seq__19851);
var clause = first__19852;
var r = seq__19851__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19849__$1 = G__19849;
var res__$1 = res;
while(true){
var vec__19856 = G__19849__$1;
var seq__19857 = cljs.core.seq.call(null,vec__19856);
var first__19858 = cljs.core.first.call(null,seq__19857);
var seq__19857__$1 = cljs.core.next.call(null,seq__19857);
var clause__$1 = first__19858;
var r__$1 = seq__19857__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19859 = r__$1;
var G__19860 = res__$2;
G__19849__$1 = G__19859;
res__$1 = G__19860;
continue;
} else {
var G__19861 = r__$1;
var G__19862 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19849__$1 = G__19861;
res__$1 = G__19862;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19865 = clause;
var G__19865__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__19865):G__19865);
var G__19865__$2 = clojure.string.join.call(null," ",G__19865__$1)
;
var G__19865__$3 = (function (p1__19863_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19863_SHARP_)," ."].join('');
}).call(null,G__19865__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__19864_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19864_SHARP_),"}"].join('');
}).call(null,G__19865__$3);
} else {
return G__19865__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19869 = opts;
var map__19869__$1 = cljs.core.__destructure_map.call(null,map__19869);
var limit = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19866_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19866_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19867_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19867_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19868_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19868_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19883){
var state_val_19884 = (state_19883[(1)]);
if((state_val_19884 === (1))){
var inst_19870 = fluree.db.util.core.url_encode.call(null,query);
var inst_19871 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19870)].join('');
var inst_19872 = ["User-Agent","Accept"];
var inst_19873 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19874 = cljs.core.PersistentHashMap.fromArrays(inst_19872,inst_19873);
var inst_19875 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19876 = [inst_19874,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19877 = cljs.core.PersistentHashMap.fromArrays(inst_19875,inst_19876);
var inst_19878 = fluree.db.util.xhttp.get.call(null,inst_19871,inst_19877);
var state_19883__$1 = state_19883;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19883__$1,(2),inst_19878);
} else {
if((state_val_19884 === (2))){
var inst_19880 = (state_19883[(2)]);
var inst_19881 = fluree.db.util.async.throw_err.call(null,inst_19880);
var state_19883__$1 = state_19883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19883__$1,inst_19881);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19885 = [null,null,null,null,null,null,null];
(statearr_19885[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_19885[(1)] = (1));

return statearr_19885;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19883){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19886){var ex__2749__auto__ = e19886;
var statearr_19887_19890 = state_19883;
(statearr_19887_19890[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19883[(4)]))){
var statearr_19888_19891 = state_19883;
(statearr_19888_19891[(1)] = cljs.core.first.call(null,(state_19883[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19892 = state_19883;
state_19883 = G__19892;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_19883){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19889 = f__2769__auto__.call(null);
(statearr_19889[(6)] = c__2768__auto__);

return statearr_19889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19910){
var state_val_19911 = (state_19910[(1)]);
if((state_val_19911 === (1))){
var inst_19893 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19910__$1 = state_19910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19910__$1,(2),inst_19893);
} else {
if((state_val_19911 === (2))){
var inst_19896 = (state_19910[(7)]);
var inst_19895 = (state_19910[(2)]);
var inst_19896__$1 = fluree.db.util.async.throw_err.call(null,inst_19895);
var inst_19897 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19896__$1);
var inst_19898 = cljs.core.not_EQ_.call(null,(200),inst_19897);
var state_19910__$1 = (function (){var statearr_19912 = state_19910;
(statearr_19912[(7)] = inst_19896__$1);

return statearr_19912;
})();
if(inst_19898){
var statearr_19913_19922 = state_19910__$1;
(statearr_19913_19922[(1)] = (3));

} else {
var statearr_19914_19923 = state_19910__$1;
(statearr_19914_19923[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19911 === (3))){
var inst_19896 = (state_19910[(7)]);
var state_19910__$1 = state_19910;
var statearr_19915_19924 = state_19910__$1;
(statearr_19915_19924[(2)] = inst_19896);

(statearr_19915_19924[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19911 === (4))){
var inst_19896 = (state_19910[(7)]);
var inst_19901 = (function (){var body = inst_19896;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19902 = cljs.core.second.call(null,inst_19896);
var inst_19903 = cljs.core.second.call(null,inst_19902);
var inst_19904 = cljs.core.first.call(null,inst_19903);
var inst_19905 = cljs.core.second.call(null,inst_19904);
var inst_19906 = cljs.core.mapv.call(null,inst_19901,inst_19905);
var state_19910__$1 = state_19910;
var statearr_19916_19925 = state_19910__$1;
(statearr_19916_19925[(2)] = inst_19906);

(statearr_19916_19925[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19911 === (5))){
var inst_19908 = (state_19910[(2)]);
var state_19910__$1 = state_19910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19910__$1,inst_19908);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19917 = [null,null,null,null,null,null,null,null];
(statearr_19917[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_19917[(1)] = (1));

return statearr_19917;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19910){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19918){var ex__2749__auto__ = e19918;
var statearr_19919_19926 = state_19910;
(statearr_19919_19926[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19910[(4)]))){
var statearr_19920_19927 = state_19910;
(statearr_19920_19927[(1)] = cljs.core.first.call(null,(state_19910[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19928 = state_19910;
state_19910 = G__19928;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_19910){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19921 = f__2769__auto__.call(null);
(statearr_19921[(6)] = c__2768__auto__);

return statearr_19921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__19929_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19929_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__19930_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19930_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__19931_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__19931_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19977){
var state_val_19978 = (state_19977[(1)]);
if((state_val_19978 === (7))){
var inst_19942 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_19977__$1 = state_19977;
var statearr_19979_20007 = state_19977__$1;
(statearr_19979_20007[(2)] = inst_19942);

(statearr_19979_20007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (1))){
var state_19977__$1 = state_19977;
var statearr_19980_20008 = state_19977__$1;
(statearr_19980_20008[(2)] = null);

(statearr_19980_20008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (4))){
var inst_19932 = (state_19977[(2)]);
var state_19977__$1 = state_19977;
var statearr_19981_20009 = state_19977__$1;
(statearr_19981_20009[(2)] = inst_19932);

(statearr_19981_20009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (15))){
var inst_19956 = (state_19977[(7)]);
var inst_19951 = (state_19977[(8)]);
var inst_19950 = (state_19977[(9)]);
var inst_19961 = (state_19977[(2)]);
var inst_19962 = cljs.core.subs.call(null,inst_19956,(0),inst_19961);
var inst_19963 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19964 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19950);
var inst_19965 = [inst_19951,inst_19964];
var inst_19966 = cljs.core.PersistentHashMap.fromArrays(inst_19963,inst_19965);
var inst_19967 = cljs.core.ex_info.call(null,inst_19962,inst_19966);
var inst_19968 = (function(){throw inst_19967})();
var state_19977__$1 = state_19977;
var statearr_19982_20010 = state_19977__$1;
(statearr_19982_20010[(2)] = inst_19968);

(statearr_19982_20010[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (13))){
var inst_19955 = (state_19977[(10)]);
var state_19977__$1 = state_19977;
var statearr_19983_20011 = state_19977__$1;
(statearr_19983_20011[(2)] = inst_19955);

(statearr_19983_20011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (6))){
var state_19977__$1 = state_19977;
var statearr_19984_20012 = state_19977__$1;
(statearr_19984_20012[(2)] = null);

(statearr_19984_20012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (3))){
var inst_19975 = (state_19977[(2)]);
var state_19977__$1 = state_19977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19977__$1,inst_19975);
} else {
if((state_val_19978 === (12))){
var inst_19972 = (state_19977[(2)]);
var _ = (function (){var statearr_19985 = state_19977;
(statearr_19985[(4)] = cljs.core.rest.call(null,(state_19977[(4)])));

return statearr_19985;
})();
var state_19977__$1 = state_19977;
var statearr_19986_20013 = state_19977__$1;
(statearr_19986_20013[(2)] = inst_19972);

(statearr_19986_20013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (2))){
var _ = (function (){var statearr_19987 = state_19977;
(statearr_19987[(4)] = cljs.core.cons.call(null,(5),(state_19977[(4)])));

return statearr_19987;
})();
var inst_19939 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_19977__$1 = state_19977;
if(inst_19939){
var statearr_19988_20014 = state_19977__$1;
(statearr_19988_20014[(1)] = (6));

} else {
var statearr_19989_20015 = state_19977__$1;
(statearr_19989_20015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (11))){
var inst_19950 = (state_19977[(9)]);
var inst_19970 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_19950,all_vars);
var state_19977__$1 = state_19977;
var statearr_19991_20016 = state_19977__$1;
(statearr_19991_20016[(2)] = inst_19970);

(statearr_19991_20016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (9))){
var inst_19951 = (state_19977[(8)]);
var inst_19950 = (state_19977[(9)]);
var inst_19948 = (state_19977[(2)]);
var inst_19949 = fluree.db.util.async.throw_err.call(null,inst_19948);
var inst_19950__$1 = cljs.core.__destructure_map.call(null,inst_19949);
var inst_19951__$1 = cljs.core.get.call(null,inst_19950__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_19952 = cljs.core.get.call(null,inst_19950__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_19953 = cljs.core._EQ_.call(null,(400),inst_19951__$1);
var state_19977__$1 = (function (){var statearr_19992 = state_19977;
(statearr_19992[(11)] = inst_19952);

(statearr_19992[(8)] = inst_19951__$1);

(statearr_19992[(9)] = inst_19950__$1);

return statearr_19992;
})();
if(inst_19953){
var statearr_19993_20017 = state_19977__$1;
(statearr_19993_20017[(1)] = (10));

} else {
var statearr_19994_20018 = state_19977__$1;
(statearr_19994_20018[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (5))){
var _ = (function (){var statearr_19995 = state_19977;
(statearr_19995[(4)] = cljs.core.rest.call(null,(state_19977[(4)])));

return statearr_19995;
})();
var state_19977__$1 = state_19977;
var ex19990 = (state_19977__$1[(2)]);
var statearr_19996_20019 = state_19977__$1;
(statearr_19996_20019[(5)] = ex19990);


if((ex19990 instanceof Error)){
var statearr_19997_20020 = state_19977__$1;
(statearr_19997_20020[(1)] = (4));

(statearr_19997_20020[(5)] = null);

} else {
throw ex19990;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (14))){
var state_19977__$1 = state_19977;
var statearr_19998_20021 = state_19977__$1;
(statearr_19998_20021[(2)] = (1000));

(statearr_19998_20021[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (10))){
var inst_19952 = (state_19977[(11)]);
var inst_19955 = (state_19977[(10)]);
var inst_19950 = (state_19977[(9)]);
var inst_19955__$1 = cljs.core.count.call(null,inst_19952);
var inst_19956 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19950);
var inst_19957 = (inst_19955__$1 < (1000));
var state_19977__$1 = (function (){var statearr_19999 = state_19977;
(statearr_19999[(7)] = inst_19956);

(statearr_19999[(10)] = inst_19955__$1);

return statearr_19999;
})();
if(cljs.core.truth_(inst_19957)){
var statearr_20000_20022 = state_19977__$1;
(statearr_20000_20022[(1)] = (13));

} else {
var statearr_20001_20023 = state_19977__$1;
(statearr_20001_20023[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19978 === (8))){
var inst_19944 = (state_19977[(2)]);
var inst_19945 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_19944,optional_clauses);
var inst_19946 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_19945);
var state_19977__$1 = state_19977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19977__$1,(9),inst_19946);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20002 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20002[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_20002[(1)] = (1));

return statearr_20002;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_19977){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20003){var ex__2749__auto__ = e20003;
var statearr_20004_20024 = state_19977;
(statearr_20004_20024[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19977[(4)]))){
var statearr_20005_20025 = state_19977;
(statearr_20005_20025[(1)] = cljs.core.first.call(null,(state_19977[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20026 = state_19977;
state_19977 = G__20026;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_19977){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_19977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20006 = f__2769__auto__.call(null);
(statearr_20006[(6)] = c__2768__auto__);

return statearr_20006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
