// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20029){var e = e20029;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20030_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20030_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20030_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20030_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20031_SHARP_){
return cljs.core.conj.call(null,p1__20031_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20032_SHARP_){
return cljs.core.conj.call(null,p1__20032_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20037 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20037,(0),null);
var _ = cljs.core.nth.call(null,vec__20037,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20033_SHARP_){
return cljs.core.conj.call(null,p1__20033_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20040 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20040,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20040,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20034_SHARP_){
return cljs.core.conj.call(null,p1__20034_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20035_SHARP_){
return cljs.core.conj.call(null,p1__20035_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20036_SHARP_){
return cljs.core.conj.call(null,p1__20036_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.call(null,(function (tuple){
return cljs.core.map.call(null,(function (p1__20043_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20043_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,headers,var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20046,optional_QMARK_,fuel,max_fuel){
var map__20047 = p__20046;
var map__20047__$1 = cljs.core.__destructure_map.call(null,map__20047);
var res = map__20047__$1;
var vars = cljs.core.get.call(null,map__20047__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20113){
var state_val_20114 = (state_20113[(1)]);
if((state_val_20114 === (7))){
var inst_20102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20103 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20104 = cljs.core.conj.call(null,inst_20103,clause);
var inst_20105 = [null,inst_20104];
var inst_20106 = (new cljs.core.PersistentVector(null,2,(5),inst_20102,inst_20105,null));
var state_20113__$1 = state_20113;
var statearr_20115_20143 = state_20113__$1;
(statearr_20115_20143[(2)] = inst_20106);

(statearr_20115_20143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (1))){
var state_20113__$1 = state_20113;
var statearr_20116_20144 = state_20113__$1;
(statearr_20116_20144[(2)] = null);

(statearr_20116_20144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (4))){
var inst_20048 = (state_20113[(2)]);
var state_20113__$1 = state_20113;
var statearr_20117_20145 = state_20113__$1;
(statearr_20117_20145[(2)] = inst_20048);

(statearr_20117_20145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (15))){
var inst_20091 = (state_20113[(2)]);
var inst_20092 = fluree.db.util.async.throw_err.call(null,inst_20091);
var inst_20093 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20092);
var inst_20094 = cljs.core.count.call(null,inst_20093);
var inst_20095 = fluree.db.query.analytical.add_fuel.call(null,inst_20094,fuel,max_fuel);
var inst_20096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20097 = [inst_20092,r];
var inst_20098 = (new cljs.core.PersistentVector(null,2,(5),inst_20096,inst_20097,null));
var state_20113__$1 = (function (){var statearr_20118 = state_20113;
(statearr_20118[(7)] = inst_20095);

return statearr_20118;
})();
var statearr_20119_20146 = state_20113__$1;
(statearr_20119_20146[(2)] = inst_20098);

(statearr_20119_20146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (13))){
var inst_20057 = (state_20113[(8)]);
var inst_20070 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20071 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20070);
var inst_20072 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20057);
var inst_20073 = cljs.core.apply.call(null,cljs.core.concat,inst_20072);
var inst_20074 = cljs.core.set.call(null,inst_20073);
var inst_20075 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20071);
var inst_20076 = cljs.core.apply.call(null,cljs.core.concat,inst_20075);
var inst_20077 = cljs.core.into.call(null,inst_20074,inst_20076);
var inst_20078 = (function (){var all_wd = inst_20057;
var optional = inst_20071;
var all_wd_vars = inst_20074;
var all_vars = inst_20077;
return (function (p1__20044_SHARP_){
return all_vars.call(null,p1__20044_SHARP_);
});
})();
var inst_20079 = cljs.core.keys.call(null,vars);
var inst_20080 = cljs.core.map.call(null,inst_20078,inst_20079);
var inst_20081 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20080);
var inst_20082 = cljs.core.set.call(null,inst_20081);
var inst_20083 = (function (){var all_wd = inst_20057;
var optional = inst_20071;
var all_wd_vars = inst_20074;
var all_vars = inst_20077;
var intersecting_vars = inst_20082;
return (function (p1__20045_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20045_SHARP_);
});
})();
var inst_20084 = cljs.core.map.call(null,inst_20083,inst_20057);
var inst_20085 = cljs.core.apply.call(null,cljs.core.concat,inst_20084);
var inst_20086 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20085,res);
var inst_20087 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20057,inst_20082,vars);
var inst_20088 = cljs.core.remove.call(null,inst_20082,inst_20077);
var inst_20089 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20087,inst_20085,inst_20086,inst_20088,inst_20071);
var state_20113__$1 = state_20113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20113__$1,(15),inst_20089);
} else {
if((state_val_20114 === (6))){
var inst_20058 = (state_20113[(9)]);
var inst_20056 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20057 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20056);
var inst_20058__$1 = optional_QMARK_;
var state_20113__$1 = (function (){var statearr_20120 = state_20113;
(statearr_20120[(9)] = inst_20058__$1);

(statearr_20120[(8)] = inst_20057);

return statearr_20120;
})();
if(cljs.core.truth_(inst_20058__$1)){
var statearr_20121_20147 = state_20113__$1;
(statearr_20121_20147[(1)] = (9));

} else {
var statearr_20122_20148 = state_20113__$1;
(statearr_20122_20148[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (3))){
var inst_20111 = (state_20113[(2)]);
var state_20113__$1 = state_20113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20113__$1,inst_20111);
} else {
if((state_val_20114 === (12))){
var inst_20066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20067 = [null,r];
var inst_20068 = (new cljs.core.PersistentVector(null,2,(5),inst_20066,inst_20067,null));
var state_20113__$1 = state_20113;
var statearr_20123_20149 = state_20113__$1;
(statearr_20123_20149[(2)] = inst_20068);

(statearr_20123_20149[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (2))){
var _ = (function (){var statearr_20124 = state_20113;
(statearr_20124[(4)] = cljs.core.cons.call(null,(5),(state_20113[(4)])));

return statearr_20124;
})();
var inst_20054 = (r == null);
var state_20113__$1 = state_20113;
if(cljs.core.truth_(inst_20054)){
var statearr_20125_20150 = state_20113__$1;
(statearr_20125_20150[(1)] = (6));

} else {
var statearr_20126_20151 = state_20113__$1;
(statearr_20126_20151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (11))){
var inst_20064 = (state_20113[(2)]);
var state_20113__$1 = state_20113;
if(cljs.core.truth_(inst_20064)){
var statearr_20128_20152 = state_20113__$1;
(statearr_20128_20152[(1)] = (12));

} else {
var statearr_20129_20153 = state_20113__$1;
(statearr_20129_20153[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (9))){
var inst_20057 = (state_20113[(8)]);
var inst_20060 = cljs.core.empty_QMARK_.call(null,inst_20057);
var inst_20061 = (!(inst_20060));
var state_20113__$1 = state_20113;
var statearr_20130_20154 = state_20113__$1;
(statearr_20130_20154[(2)] = inst_20061);

(statearr_20130_20154[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (5))){
var _ = (function (){var statearr_20131 = state_20113;
(statearr_20131[(4)] = cljs.core.rest.call(null,(state_20113[(4)])));

return statearr_20131;
})();
var state_20113__$1 = state_20113;
var ex20127 = (state_20113__$1[(2)]);
var statearr_20132_20155 = state_20113__$1;
(statearr_20132_20155[(5)] = ex20127);


if((ex20127 instanceof Error)){
var statearr_20133_20156 = state_20113__$1;
(statearr_20133_20156[(1)] = (4));

(statearr_20133_20156[(5)] = null);

} else {
throw ex20127;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (14))){
var inst_20100 = (state_20113[(2)]);
var state_20113__$1 = state_20113;
var statearr_20134_20157 = state_20113__$1;
(statearr_20134_20157[(2)] = inst_20100);

(statearr_20134_20157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (10))){
var inst_20058 = (state_20113[(9)]);
var state_20113__$1 = state_20113;
var statearr_20135_20158 = state_20113__$1;
(statearr_20135_20158[(2)] = inst_20058);

(statearr_20135_20158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20114 === (8))){
var inst_20108 = (state_20113[(2)]);
var _ = (function (){var statearr_20136 = state_20113;
(statearr_20136[(4)] = cljs.core.rest.call(null,(state_20113[(4)])));

return statearr_20136;
})();
var state_20113__$1 = state_20113;
var statearr_20137_20159 = state_20113__$1;
(statearr_20137_20159[(2)] = inst_20108);

(statearr_20137_20159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20138 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20138[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_20138[(1)] = (1));

return statearr_20138;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20113){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20139){var ex__2749__auto__ = e20139;
var statearr_20140_20160 = state_20113;
(statearr_20140_20160[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20113[(4)]))){
var statearr_20141_20161 = state_20113;
(statearr_20141_20161[(1)] = cljs.core.first.call(null,(state_20113[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20162 = state_20113;
state_20113 = G__20162;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_20113){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20142 = f__2769__auto__.call(null);
(statearr_20142[(6)] = c__2768__auto__);

return statearr_20142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20164 = arguments.length;
switch (G__20164) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20258){
var state_val_20259 = (state_20258[(1)]);
if((state_val_20259 === (7))){
var inst_20171 = (state_20258[(7)]);
var inst_20181 = clojure.string.starts_with_QMARK_.call(null,inst_20171,"$fdb");
var state_20258__$1 = state_20258;
if(inst_20181){
var statearr_20260_20309 = state_20258__$1;
(statearr_20260_20309[(1)] = (9));

} else {
var statearr_20261_20310 = state_20258__$1;
(statearr_20261_20310[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (20))){
var state_20258__$1 = state_20258;
var statearr_20262_20311 = state_20258__$1;
(statearr_20262_20311[(2)] = null);

(statearr_20262_20311[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (27))){
var inst_20221 = (state_20258[(8)]);
var state_20258__$1 = state_20258;
var statearr_20263_20312 = state_20258__$1;
(statearr_20263_20312[(2)] = inst_20221);

(statearr_20263_20312[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (1))){
var state_20258__$1 = state_20258;
var statearr_20264_20313 = state_20258__$1;
(statearr_20264_20313[(2)] = null);

(statearr_20264_20313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (24))){
var inst_20244 = (state_20258[(2)]);
var state_20258__$1 = state_20258;
var statearr_20265_20314 = state_20258__$1;
(statearr_20265_20314[(2)] = inst_20244);

(statearr_20265_20314[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (4))){
var inst_20165 = (state_20258[(2)]);
var state_20258__$1 = state_20258;
var statearr_20266_20315 = state_20258__$1;
(statearr_20266_20315[(2)] = inst_20165);

(statearr_20266_20315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (15))){
var inst_20188 = (state_20258[(9)]);
var inst_20194 = (state_20258[(2)]);
var inst_20195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20196 = cljs.core.PersistentVector.EMPTY;
var inst_20197 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20198 = cljs.core.into.call(null,inst_20196,inst_20197);
var inst_20199 = [inst_20188,inst_20198];
var inst_20200 = (new cljs.core.PersistentVector(null,2,(5),inst_20195,inst_20199,null));
var state_20258__$1 = (function (){var statearr_20267 = state_20258;
(statearr_20267[(10)] = inst_20194);

return statearr_20267;
})();
var statearr_20268_20316 = state_20258__$1;
(statearr_20268_20316[(2)] = inst_20200);

(statearr_20268_20316[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (21))){
var inst_20247 = (state_20258[(2)]);
var state_20258__$1 = state_20258;
var statearr_20269_20317 = state_20258__$1;
(statearr_20269_20317[(2)] = inst_20247);

(statearr_20269_20317[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (13))){
var inst_20188 = (state_20258[(9)]);
var inst_20191 = (function(){throw inst_20188})();
var state_20258__$1 = state_20258;
var statearr_20270_20318 = state_20258__$1;
(statearr_20270_20318[(2)] = inst_20191);

(statearr_20270_20318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (22))){
var inst_20212 = (state_20258[(11)]);
var inst_20210 = (state_20258[(12)]);
var inst_20214 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20210);
var inst_20215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20216 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20212];
var inst_20217 = (new cljs.core.PersistentVector(null,2,(5),inst_20215,inst_20216,null));
var inst_20218 = cljs.core.get_in.call(null,opts,inst_20217);
var state_20258__$1 = (function (){var statearr_20271 = state_20258;
(statearr_20271[(13)] = inst_20214);

return statearr_20271;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20258__$1,(25),inst_20218);
} else {
if((state_val_20259 === (29))){
var inst_20225 = (state_20258[(2)]);
var inst_20226 = fluree.db.util.async.throw_err.call(null,inst_20225);
var state_20258__$1 = state_20258;
var statearr_20272_20319 = state_20258__$1;
(statearr_20272_20319[(2)] = inst_20226);

(statearr_20272_20319[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (6))){
var inst_20174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20175 = cljs.core.PersistentVector.EMPTY;
var inst_20176 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20177 = cljs.core.into.call(null,inst_20175,inst_20176);
var inst_20178 = [db,inst_20177];
var inst_20179 = (new cljs.core.PersistentVector(null,2,(5),inst_20174,inst_20178,null));
var state_20258__$1 = state_20258;
var statearr_20273_20320 = state_20258__$1;
(statearr_20273_20320[(2)] = inst_20179);

(statearr_20273_20320[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (28))){
var inst_20229 = (state_20258[(2)]);
var inst_20230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20231 = cljs.core.PersistentVector.EMPTY;
var inst_20232 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20233 = cljs.core.into.call(null,inst_20231,inst_20232);
var inst_20234 = [inst_20229,inst_20233];
var inst_20235 = (new cljs.core.PersistentVector(null,2,(5),inst_20230,inst_20234,null));
var state_20258__$1 = state_20258;
var statearr_20274_20321 = state_20258__$1;
(statearr_20274_20321[(2)] = inst_20235);

(statearr_20274_20321[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (25))){
var inst_20214 = (state_20258[(13)]);
var inst_20220 = (state_20258[(2)]);
var inst_20221 = fluree.db.util.async.throw_err.call(null,inst_20220);
var state_20258__$1 = (function (){var statearr_20275 = state_20258;
(statearr_20275[(8)] = inst_20221);

return statearr_20275;
})();
if(cljs.core.truth_(inst_20214)){
var statearr_20276_20322 = state_20258__$1;
(statearr_20276_20322[(1)] = (26));

} else {
var statearr_20277_20323 = state_20258__$1;
(statearr_20277_20323[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (17))){
var state_20258__$1 = state_20258;
var statearr_20278_20324 = state_20258__$1;
(statearr_20278_20324[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (3))){
var inst_20256 = (state_20258[(2)]);
var state_20258__$1 = state_20258;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20258__$1,inst_20256);
} else {
if((state_val_20259 === (12))){
var inst_20188 = (state_20258[(9)]);
var inst_20187 = (state_20258[(2)]);
var inst_20188__$1 = fluree.db.util.async.throw_err.call(null,inst_20187);
var inst_20189 = fluree.db.util.core.exception_QMARK_.call(null,inst_20188__$1);
var state_20258__$1 = (function (){var statearr_20280 = state_20258;
(statearr_20280[(9)] = inst_20188__$1);

return statearr_20280;
})();
if(inst_20189){
var statearr_20281_20325 = state_20258__$1;
(statearr_20281_20325[(1)] = (13));

} else {
var statearr_20282_20326 = state_20258__$1;
(statearr_20282_20326[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (2))){
var inst_20171 = (state_20258[(7)]);
var _ = (function (){var statearr_20283 = state_20258;
(statearr_20283[(4)] = cljs.core.cons.call(null,(5),(state_20258[(4)])));

return statearr_20283;
})();
var inst_20171__$1 = cljs.core.first.call(null,clause);
var inst_20172 = cljs.core._EQ_.call(null,"$fdb",inst_20171__$1);
var state_20258__$1 = (function (){var statearr_20284 = state_20258;
(statearr_20284[(7)] = inst_20171__$1);

return statearr_20284;
})();
if(inst_20172){
var statearr_20285_20327 = state_20258__$1;
(statearr_20285_20327[(1)] = (6));

} else {
var statearr_20286_20328 = state_20258__$1;
(statearr_20286_20328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (23))){
var inst_20171 = (state_20258[(7)]);
var inst_20237 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20171)," is not supported in Fluree"].join('');
var inst_20238 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20239 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20240 = cljs.core.PersistentHashMap.fromArrays(inst_20238,inst_20239);
var inst_20241 = cljs.core.ex_info.call(null,inst_20237,inst_20240);
var inst_20242 = (function(){throw inst_20241})();
var state_20258__$1 = state_20258;
var statearr_20287_20329 = state_20258__$1;
(statearr_20287_20329[(2)] = inst_20242);

(statearr_20287_20329[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (19))){
var inst_20171 = (state_20258[(7)]);
var inst_20212 = (state_20258[(11)]);
var inst_20209 = fluree.db.query.analytical.isolate_source_name.call(null,inst_20171);
var inst_20210 = fluree.db.query.analytical.isolate_source_block.call(null,inst_20171);
var inst_20211 = cljs.core.keyword.call(null,inst_20209);
var inst_20212__$1 = cljs.core.get.call(null,prefixes,inst_20211);
var state_20258__$1 = (function (){var statearr_20288 = state_20258;
(statearr_20288[(11)] = inst_20212__$1);

(statearr_20288[(12)] = inst_20210);

return statearr_20288;
})();
if(cljs.core.truth_(inst_20212__$1)){
var statearr_20289_20330 = state_20258__$1;
(statearr_20289_20330[(1)] = (22));

} else {
var statearr_20290_20331 = state_20258__$1;
(statearr_20290_20331[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (11))){
var inst_20251 = (state_20258[(2)]);
var state_20258__$1 = state_20258;
var statearr_20292_20332 = state_20258__$1;
(statearr_20292_20332[(2)] = inst_20251);

(statearr_20292_20332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (9))){
var inst_20171 = (state_20258[(7)]);
var inst_20183 = cljs.core.subs.call(null,inst_20171,(4));
var inst_20184 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20183);
var inst_20185 = fluree.db.time_travel.as_of_block.call(null,db,inst_20184);
var state_20258__$1 = state_20258;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20258__$1,(12),inst_20185);
} else {
if((state_val_20259 === (5))){
var _ = (function (){var statearr_20293 = state_20258;
(statearr_20293[(4)] = cljs.core.rest.call(null,(state_20258[(4)])));

return statearr_20293;
})();
var state_20258__$1 = state_20258;
var ex20291 = (state_20258__$1[(2)]);
var statearr_20294_20333 = state_20258__$1;
(statearr_20294_20333[(5)] = ex20291);


if((ex20291 instanceof Error)){
var statearr_20295_20334 = state_20258__$1;
(statearr_20295_20334[(1)] = (4));

(statearr_20295_20334[(5)] = null);

} else {
throw ex20291;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (14))){
var state_20258__$1 = state_20258;
var statearr_20296_20335 = state_20258__$1;
(statearr_20296_20335[(2)] = null);

(statearr_20296_20335[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (26))){
var inst_20221 = (state_20258[(8)]);
var inst_20214 = (state_20258[(13)]);
var inst_20223 = fluree.db.time_travel.as_of_block.call(null,inst_20221,inst_20214);
var state_20258__$1 = state_20258;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20258__$1,(29),inst_20223);
} else {
if((state_val_20259 === (16))){
var inst_20204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20205 = ["$wd",clause];
var inst_20206 = (new cljs.core.PersistentVector(null,2,(5),inst_20204,inst_20205,null));
var state_20258__$1 = state_20258;
var statearr_20297_20336 = state_20258__$1;
(statearr_20297_20336[(2)] = inst_20206);

(statearr_20297_20336[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (10))){
var inst_20171 = (state_20258[(7)]);
var inst_20202 = cljs.core._EQ_.call(null,"$wd",inst_20171);
var state_20258__$1 = state_20258;
if(inst_20202){
var statearr_20298_20337 = state_20258__$1;
(statearr_20298_20337[(1)] = (16));

} else {
var statearr_20299_20338 = state_20258__$1;
(statearr_20299_20338[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (18))){
var inst_20249 = (state_20258[(2)]);
var state_20258__$1 = state_20258;
var statearr_20300_20339 = state_20258__$1;
(statearr_20300_20339[(2)] = inst_20249);

(statearr_20300_20339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20259 === (8))){
var inst_20253 = (state_20258[(2)]);
var _ = (function (){var statearr_20301 = state_20258;
(statearr_20301[(4)] = cljs.core.rest.call(null,(state_20258[(4)])));

return statearr_20301;
})();
var state_20258__$1 = state_20258;
var statearr_20302_20340 = state_20258__$1;
(statearr_20302_20340[(2)] = inst_20253);

(statearr_20302_20340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_20303 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20303[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_20303[(1)] = (1));

return statearr_20303;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_20258){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20258);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20304){var ex__2749__auto__ = e20304;
var statearr_20305_20341 = state_20258;
(statearr_20305_20341[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20258[(4)]))){
var statearr_20306_20342 = state_20258;
(statearr_20306_20342[(1)] = cljs.core.first.call(null,(state_20258[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20343 = state_20258;
state_20258 = G__20343;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_20258){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_20258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20307 = f__2769__auto__.call(null);
(statearr_20307[(6)] = c__2768__auto__);

return statearr_20307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__20344){
var vec__20345 = p__20344;
var sub = cljs.core.nth.call(null,vec__20345,(0),null);
var obj = cljs.core.nth.call(null,vec__20345,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__20348_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__20348_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__20352 = subjects;
var vec__20353 = G__20352;
var seq__20354 = cljs.core.seq.call(null,vec__20353);
var first__20355 = cljs.core.first.call(null,seq__20354);
var seq__20354__$1 = cljs.core.next.call(null,seq__20354);
var subject = first__20355;
var r = seq__20354__$1;
var acc = expanded_map;
var G__20352__$1 = G__20352;
var acc__$1 = acc;
while(true){
var vec__20359 = G__20352__$1;
var seq__20360 = cljs.core.seq.call(null,vec__20359);
var first__20361 = cljs.core.first.call(null,seq__20360);
var seq__20360__$1 = cljs.core.next.call(null,seq__20360);
var subject__$1 = first__20361;
var r__$1 = seq__20360__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20362 = r__$1;
var G__20363 = acc__$2;
G__20352__$1 = G__20362;
acc__$1 = G__20363;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__20352__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20359,seq__20360,first__20361,seq__20360__$1,subject__$1,r__$1,acc__$2,G__20352,vec__20353,seq__20354,first__20355,seq__20354__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20352__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20359,seq__20360,first__20361,seq__20360__$1,subject__$1,r__$1,acc__$2,G__20352,vec__20353,seq__20354,first__20355,seq__20354__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20352__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20359,seq__20360,first__20361,seq__20360__$1,subject__$1,r__$1,acc__$2,G__20352,vec__20353,seq__20354,first__20355,seq__20354__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20352__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20359,seq__20360,first__20361,seq__20360__$1,subject__$1,r__$1,acc__$2,G__20352,vec__20353,seq__20354,first__20355,seq__20354__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20352__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20359,seq__20360,first__20361,seq__20360__$1,subject__$1,r__$1,acc__$2,G__20352,vec__20353,seq__20354,first__20355,seq__20354__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20352__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20359,seq__20360,first__20361,seq__20360__$1,subject__$1,r__$1,acc__$2,G__20352,vec__20353,seq__20354,first__20355,seq__20354__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20364 = r__$1;
var G__20365 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20352__$1 = G__20364;
acc__$1 = G__20365;
continue;
} else {
var G__20366 = subjects;
var G__20367 = acc_STAR_;
G__20352__$1 = G__20366;
acc__$1 = G__20367;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__20368_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20368_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20459){
var state_val_20460 = (state_20459[(1)]);
if((state_val_20460 === (7))){
var state_20459__$1 = state_20459;
var statearr_20461_20507 = state_20459__$1;
(statearr_20461_20507[(2)] = (100));

(statearr_20461_20507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (20))){
var inst_20408 = (state_20459[(7)]);
var state_20459__$1 = state_20459;
var statearr_20462_20508 = state_20459__$1;
(statearr_20462_20508[(2)] = inst_20408);

(statearr_20462_20508[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (1))){
var state_20459__$1 = state_20459;
var statearr_20463_20509 = state_20459__$1;
(statearr_20463_20509[(2)] = null);

(statearr_20463_20509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (24))){
var inst_20447 = (state_20459[(8)]);
var inst_20446 = (state_20459[(9)]);
var inst_20445 = (state_20459[(10)]);
var inst_20380 = (state_20459[(11)]);
var inst_20450 = (function (){var max_depth = inst_20380;
var recur_map__$1 = inst_20446;
var subjects = inst_20445;
var tuples = inst_20447;
return (function (p1__20369_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__20369_SHARP_)],null));
});
})();
var inst_20451 = cljs.core.map.call(null,inst_20450,inst_20447);
var inst_20452 = cljs.core.distinct.call(null,inst_20451);
var state_20459__$1 = state_20459;
var statearr_20464_20510 = state_20459__$1;
(statearr_20464_20510[(2)] = inst_20452);

(statearr_20464_20510[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (4))){
var inst_20370 = (state_20459[(2)]);
var state_20459__$1 = state_20459;
var statearr_20465_20511 = state_20459__$1;
(statearr_20465_20511[(2)] = inst_20370);

(statearr_20465_20511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (15))){
var inst_20393 = (state_20459[(12)]);
var inst_20404 = cljs.core.PersistentVector.EMPTY;
var inst_20405 = cljs.core.seq.call(null,inst_20393);
var inst_20406 = cljs.core.first.call(null,inst_20405);
var inst_20407 = cljs.core.next.call(null,inst_20405);
var inst_20408 = inst_20404;
var inst_20409 = inst_20393;
var state_20459__$1 = (function (){var statearr_20466 = state_20459;
(statearr_20466[(7)] = inst_20408);

(statearr_20466[(13)] = inst_20409);

(statearr_20466[(14)] = inst_20407);

(statearr_20466[(15)] = inst_20406);

return statearr_20466;
})();
var statearr_20467_20512 = state_20459__$1;
(statearr_20467_20512[(2)] = null);

(statearr_20467_20512[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (21))){
var inst_20429 = (state_20459[(2)]);
var state_20459__$1 = state_20459;
var statearr_20468_20513 = state_20459__$1;
(statearr_20468_20513[(2)] = inst_20429);

(statearr_20468_20513[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (13))){
var inst_20442 = (state_20459[(2)]);
var state_20459__$1 = state_20459;
var statearr_20469_20514 = state_20459__$1;
(statearr_20469_20514[(2)] = inst_20442);

(statearr_20469_20514[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (22))){
var inst_20408 = (state_20459[(7)]);
var inst_20416 = (state_20459[(16)]);
var inst_20423 = (state_20459[(2)]);
var inst_20424 = fluree.db.util.async.throw_err.call(null,inst_20423);
var inst_20425 = cljs.core.concat.call(null,inst_20408,inst_20424);
var inst_20408__$1 = inst_20425;
var inst_20409 = inst_20416;
var state_20459__$1 = (function (){var statearr_20470 = state_20459;
(statearr_20470[(7)] = inst_20408__$1);

(statearr_20470[(13)] = inst_20409);

return statearr_20470;
})();
var statearr_20471_20515 = state_20459__$1;
(statearr_20471_20515[(2)] = null);

(statearr_20471_20515[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (6))){
var inst_20376 = (state_20459[(17)]);
var state_20459__$1 = state_20459;
var statearr_20472_20516 = state_20459__$1;
(statearr_20472_20516[(2)] = inst_20376);

(statearr_20472_20516[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (25))){
var inst_20454 = (state_20459[(2)]);
var _ = (function (){var statearr_20473 = state_20459;
(statearr_20473[(4)] = cljs.core.rest.call(null,(state_20459[(4)])));

return statearr_20473;
})();
var state_20459__$1 = state_20459;
var statearr_20474_20517 = state_20459__$1;
(statearr_20474_20517[(2)] = inst_20454);

(statearr_20474_20517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (17))){
var inst_20409 = (state_20459[(13)]);
var inst_20415 = (state_20459[(18)]);
var inst_20414 = cljs.core.seq.call(null,inst_20409);
var inst_20415__$1 = cljs.core.first.call(null,inst_20414);
var inst_20416 = cljs.core.next.call(null,inst_20414);
var state_20459__$1 = (function (){var statearr_20475 = state_20459;
(statearr_20475[(16)] = inst_20416);

(statearr_20475[(18)] = inst_20415__$1);

return statearr_20475;
})();
if(cljs.core.truth_(inst_20415__$1)){
var statearr_20476_20518 = state_20459__$1;
(statearr_20476_20518[(1)] = (19));

} else {
var statearr_20477_20519 = state_20459__$1;
(statearr_20477_20519[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (3))){
var inst_20457 = (state_20459[(2)]);
var state_20459__$1 = state_20459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20459__$1,inst_20457);
} else {
if((state_val_20460 === (12))){
var inst_20393 = (state_20459[(12)]);
var inst_20382 = (state_20459[(19)]);
var inst_20388 = cljs.core.vals.call(null,inst_20382);
var inst_20389 = cljs.core.flatten.call(null,inst_20388);
var inst_20390 = cljs.core.set.call(null,inst_20389);
var inst_20391 = cljs.core.keys.call(null,inst_20382);
var inst_20392 = cljs.core.set.call(null,inst_20391);
var inst_20393__$1 = clojure.set.difference.call(null,inst_20390,inst_20392);
var inst_20394 = cljs.core.empty_QMARK_.call(null,inst_20393__$1);
var state_20459__$1 = (function (){var statearr_20478 = state_20459;
(statearr_20478[(12)] = inst_20393__$1);

return statearr_20478;
})();
if(inst_20394){
var statearr_20479_20520 = state_20459__$1;
(statearr_20479_20520[(1)] = (14));

} else {
var statearr_20480_20521 = state_20459__$1;
(statearr_20480_20521[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (2))){
var inst_20376 = (state_20459[(17)]);
var _ = (function (){var statearr_20481 = state_20459;
(statearr_20481[(4)] = cljs.core.cons.call(null,(5),(state_20459[(4)])));

return statearr_20481;
})();
var inst_20376__$1 = depth;
var state_20459__$1 = (function (){var statearr_20482 = state_20459;
(statearr_20482[(17)] = inst_20376__$1);

return statearr_20482;
})();
if(cljs.core.truth_(inst_20376__$1)){
var statearr_20483_20522 = state_20459__$1;
(statearr_20483_20522[(1)] = (6));

} else {
var statearr_20484_20523 = state_20459__$1;
(statearr_20484_20523[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (23))){
var inst_20447 = (state_20459[(8)]);
var state_20459__$1 = state_20459;
var statearr_20485_20524 = state_20459__$1;
(statearr_20485_20524[(2)] = inst_20447);

(statearr_20485_20524[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (19))){
var inst_20415 = (state_20459[(18)]);
var inst_20418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20419 = [inst_20415,predicate];
var inst_20420 = (new cljs.core.PersistentVector(null,2,(5),inst_20418,inst_20419,null));
var inst_20421 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20420);
var state_20459__$1 = state_20459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20459__$1,(22),inst_20421);
} else {
if((state_val_20460 === (11))){
var inst_20382 = (state_20459[(19)]);
var state_20459__$1 = state_20459;
var statearr_20487_20525 = state_20459__$1;
(statearr_20487_20525[(2)] = inst_20382);

(statearr_20487_20525[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (9))){
var inst_20380 = (state_20459[(11)]);
var inst_20383 = (state_20459[(20)]);
var inst_20385 = (inst_20383 >= inst_20380);
var state_20459__$1 = state_20459;
if(cljs.core.truth_(inst_20385)){
var statearr_20488_20526 = state_20459__$1;
(statearr_20488_20526[(1)] = (11));

} else {
var statearr_20489_20527 = state_20459__$1;
(statearr_20489_20527[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (5))){
var _ = (function (){var statearr_20490 = state_20459;
(statearr_20490[(4)] = cljs.core.rest.call(null,(state_20459[(4)])));

return statearr_20490;
})();
var state_20459__$1 = state_20459;
var ex20486 = (state_20459__$1[(2)]);
var statearr_20491_20528 = state_20459__$1;
(statearr_20491_20528[(5)] = ex20486);


if((ex20486 instanceof Error)){
var statearr_20492_20529 = state_20459__$1;
(statearr_20492_20529[(1)] = (4));

(statearr_20492_20529[(5)] = null);

} else {
throw ex20486;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (14))){
var inst_20382 = (state_20459[(19)]);
var state_20459__$1 = state_20459;
var statearr_20493_20530 = state_20459__$1;
(statearr_20493_20530[(2)] = inst_20382);

(statearr_20493_20530[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (16))){
var inst_20440 = (state_20459[(2)]);
var state_20459__$1 = state_20459;
var statearr_20494_20531 = state_20459__$1;
(statearr_20494_20531[(2)] = inst_20440);

(statearr_20494_20531[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (10))){
var inst_20446 = (state_20459[(9)]);
var inst_20445 = (state_20459[(10)]);
var inst_20444 = (state_20459[(2)]);
var inst_20445__$1 = cljs.core.keys.call(null,inst_20444);
var inst_20446__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_20445__$1,inst_20444);
var inst_20447 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_20445__$1,inst_20446__$1);
var state_20459__$1 = (function (){var statearr_20495 = state_20459;
(statearr_20495[(8)] = inst_20447);

(statearr_20495[(9)] = inst_20446__$1);

(statearr_20495[(10)] = inst_20445__$1);

return statearr_20495;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20496_20532 = state_20459__$1;
(statearr_20496_20532[(1)] = (23));

} else {
var statearr_20497_20533 = state_20459__$1;
(statearr_20497_20533[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (18))){
var inst_20382 = (state_20459[(19)]);
var inst_20383 = (state_20459[(20)]);
var inst_20431 = (state_20459[(2)]);
var inst_20432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20433 = [(0),(2)];
var inst_20434 = (new cljs.core.PersistentVector(null,2,(5),inst_20432,inst_20433,null));
var inst_20435 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20434,inst_20431);
var inst_20436 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20382,inst_20435);
var inst_20437 = (inst_20383 + (1));
var inst_20382__$1 = inst_20436;
var inst_20383__$1 = inst_20437;
var state_20459__$1 = (function (){var statearr_20498 = state_20459;
(statearr_20498[(19)] = inst_20382__$1);

(statearr_20498[(20)] = inst_20383__$1);

return statearr_20498;
})();
var statearr_20499_20534 = state_20459__$1;
(statearr_20499_20534[(2)] = null);

(statearr_20499_20534[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20460 === (8))){
var inst_20380 = (state_20459[(2)]);
var inst_20381 = recur_map;
var inst_20382 = inst_20381;
var inst_20383 = (1);
var state_20459__$1 = (function (){var statearr_20500 = state_20459;
(statearr_20500[(19)] = inst_20382);

(statearr_20500[(11)] = inst_20380);

(statearr_20500[(20)] = inst_20383);

return statearr_20500;
})();
var statearr_20501_20535 = state_20459__$1;
(statearr_20501_20535[(2)] = null);

(statearr_20501_20535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_20502 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20502[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_20502[(1)] = (1));

return statearr_20502;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_20459){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20503){var ex__2749__auto__ = e20503;
var statearr_20504_20536 = state_20459;
(statearr_20504_20536[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20459[(4)]))){
var statearr_20505_20537 = state_20459;
(statearr_20505_20537[(1)] = cljs.core.first.call(null,(state_20459[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20538 = state_20459;
state_20459 = G__20538;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_20459){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_20459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20506 = f__2769__auto__.call(null);
(statearr_20506[(6)] = c__2768__auto__);

return statearr_20506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20539,clause,fuel,max_fuel){
var map__20540 = p__20539;
var map__20540__$1 = cljs.core.__destructure_map.call(null,map__20540);
var res = map__20540__$1;
var headers = cljs.core.get.call(null,map__20540__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20540__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__20540__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20651){
var state_val_20652 = (state_20651[(1)]);
if((state_val_20652 === (7))){
var inst_20557 = (state_20651[(7)]);
var state_20651__$1 = state_20651;
var statearr_20653_20706 = state_20651__$1;
(statearr_20653_20706[(2)] = inst_20557);

(statearr_20653_20706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (20))){
var inst_20585 = (state_20651[(8)]);
var inst_20616 = typeof inst_20585 === 'number';
var state_20651__$1 = state_20651;
if(cljs.core.truth_(inst_20616)){
var statearr_20654_20707 = state_20651__$1;
(statearr_20654_20707[(1)] = (22));

} else {
var statearr_20655_20708 = state_20651__$1;
(statearr_20655_20708[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (27))){
var inst_20631 = (state_20651[(2)]);
var state_20651__$1 = state_20651;
var statearr_20656_20709 = state_20651__$1;
(statearr_20656_20709[(2)] = inst_20631);

(statearr_20656_20709[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (1))){
var state_20651__$1 = state_20651;
var statearr_20657_20710 = state_20651__$1;
(statearr_20657_20710[(2)] = null);

(statearr_20657_20710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (24))){
var inst_20633 = (state_20651[(2)]);
var state_20651__$1 = state_20651;
var statearr_20658_20711 = state_20651__$1;
(statearr_20658_20711[(2)] = inst_20633);

(statearr_20658_20711[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (4))){
var inst_20541 = (state_20651[(2)]);
var state_20651__$1 = state_20651;
var statearr_20659_20712 = state_20651__$1;
(statearr_20659_20712[(2)] = inst_20541);

(statearr_20659_20712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (15))){
var inst_20599 = (state_20651[(2)]);
var inst_20600 = cljs.core.nth.call(null,clause,(2));
var inst_20601 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20600);
var state_20651__$1 = (function (){var statearr_20660 = state_20651;
(statearr_20660[(9)] = inst_20599);

return statearr_20660;
})();
if(cljs.core.truth_(inst_20601)){
var statearr_20661_20713 = state_20651__$1;
(statearr_20661_20713[(1)] = (16));

} else {
var statearr_20662_20714 = state_20651__$1;
(statearr_20662_20714[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (21))){
var inst_20588 = (state_20651[(10)]);
var inst_20587 = (state_20651[(11)]);
var inst_20558 = (state_20651[(12)]);
var inst_20635 = (state_20651[(2)]);
var inst_20636 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_20588,inst_20635,inst_20558,inst_20587);
var state_20651__$1 = state_20651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20651__$1,(28),inst_20636);
} else {
if((state_val_20652 === (13))){
var inst_20567 = (state_20651[(13)]);
var inst_20591 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20567)].join('');
var inst_20592 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20593 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20594 = cljs.core.PersistentHashMap.fromArrays(inst_20592,inst_20593);
var inst_20595 = cljs.core.ex_info.call(null,inst_20591,inst_20594);
var inst_20596 = (function(){throw inst_20595})();
var state_20651__$1 = state_20651;
var statearr_20663_20715 = state_20651__$1;
(statearr_20663_20715[(2)] = inst_20596);

(statearr_20663_20715[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (22))){
var inst_20583 = (state_20651[(14)]);
var inst_20585 = (state_20651[(8)]);
var inst_20618 = cljs.core.PersistentHashMap.EMPTY;
var inst_20619 = cljs.core.flatten.call(null,inst_20583);
var inst_20620 = cljs.core.assoc.call(null,inst_20618,inst_20585,inst_20619);
var state_20651__$1 = state_20651;
var statearr_20664_20716 = state_20651__$1;
(statearr_20664_20716[(2)] = inst_20620);

(statearr_20664_20716[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (6))){
var inst_20569 = (state_20651[(15)]);
var state_20651__$1 = state_20651;
var statearr_20665_20717 = state_20651__$1;
(statearr_20665_20717[(2)] = inst_20569);

(statearr_20665_20717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (28))){
var inst_20638 = (state_20651[(2)]);
var inst_20639 = fluree.db.util.async.throw_err.call(null,inst_20638);
var state_20651__$1 = state_20651;
var statearr_20666_20718 = state_20651__$1;
(statearr_20666_20718[(2)] = inst_20639);

(statearr_20666_20718[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (25))){
var inst_20583 = (state_20651[(14)]);
var inst_20579 = (state_20651[(16)]);
var inst_20624 = cljs.core.PersistentHashMap.EMPTY;
var inst_20625 = cljs.core.first.call(null,inst_20579);
var inst_20626 = cljs.core.first.call(null,inst_20625);
var inst_20627 = cljs.core.flatten.call(null,inst_20583);
var inst_20628 = cljs.core.assoc.call(null,inst_20624,inst_20626,inst_20627);
var state_20651__$1 = state_20651;
var statearr_20667_20719 = state_20651__$1;
(statearr_20667_20719[(2)] = inst_20628);

(statearr_20667_20719[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (17))){
var inst_20567 = (state_20651[(13)]);
var inst_20604 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20567)].join('');
var inst_20605 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20606 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20607 = cljs.core.PersistentHashMap.fromArrays(inst_20605,inst_20606);
var inst_20608 = cljs.core.ex_info.call(null,inst_20604,inst_20607);
var inst_20609 = (function(){throw inst_20608})();
var state_20651__$1 = state_20651;
var statearr_20668_20720 = state_20651__$1;
(statearr_20668_20720[(2)] = inst_20609);

(statearr_20668_20720[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (3))){
var inst_20649 = (state_20651[(2)]);
var state_20651__$1 = state_20651;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20651__$1,inst_20649);
} else {
if((state_val_20652 === (12))){
var inst_20554 = (state_20651[(17)]);
var inst_20642 = (state_20651[(2)]);
var inst_20643 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20644 = cljs.core.keys.call(null,inst_20554);
var inst_20645 = [inst_20644,vars,inst_20642];
var inst_20646 = cljs.core.PersistentHashMap.fromArrays(inst_20643,inst_20645);
var _ = (function (){var statearr_20669 = state_20651;
(statearr_20669[(4)] = cljs.core.rest.call(null,(state_20651[(4)])));

return statearr_20669;
})();
var state_20651__$1 = state_20651;
var statearr_20670_20721 = state_20651__$1;
(statearr_20670_20721[(2)] = inst_20646);

(statearr_20670_20721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (2))){
var inst_20569 = (state_20651[(15)]);
var inst_20554 = (state_20651[(17)]);
var inst_20558 = (state_20651[(12)]);
var inst_20557 = (state_20651[(7)]);
var _ = (function (){var statearr_20671 = state_20651;
(statearr_20671[(4)] = cljs.core.cons.call(null,(5),(state_20651[(4)])));

return statearr_20671;
})();
var inst_20551 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_20552 = cljs.core.__destructure_map.call(null,inst_20551);
var inst_20553 = cljs.core.get.call(null,inst_20552,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20554__$1 = cljs.core.get.call(null,inst_20552,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20555 = cljs.core.get.call(null,inst_20552,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20556 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_20557__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20555);
var inst_20558__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20555);
var inst_20560 = (function (){var map__20547 = inst_20552;
var search = inst_20553;
var rel = inst_20554__$1;
var opts = inst_20555;
var common_keys = inst_20556;
var object_fn = inst_20557__$1;
var recur_depth = inst_20558__$1;
return (function (p__20559,common_key){
var vec__20672 = p__20559;
var acc = cljs.core.nth.call(null,vec__20672,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__20672,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20675 = cljs.core._EQ_;
var expr__20676 = idx_of;
if(cljs.core.truth_(pred__20675.call(null,(0),expr__20676))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__20675.call(null,(1),expr__20676))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__20675.call(null,(2),expr__20676))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20676)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20562 = cljs.core.PersistentHashMap.EMPTY;
var inst_20563 = [inst_20562,inst_20553];
var inst_20564 = (new cljs.core.PersistentVector(null,2,(5),inst_20561,inst_20563,null));
var inst_20565 = cljs.core.reduce.call(null,inst_20560,inst_20564,inst_20556);
var inst_20566 = cljs.core.nth.call(null,inst_20565,(0),null);
var inst_20567 = cljs.core.nth.call(null,inst_20565,(1),null);
var inst_20568 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20569__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20566);
var state_20651__$1 = (function (){var statearr_20678 = state_20651;
(statearr_20678[(13)] = inst_20567);

(statearr_20678[(15)] = inst_20569__$1);

(statearr_20678[(18)] = inst_20568);

(statearr_20678[(17)] = inst_20554__$1);

(statearr_20678[(12)] = inst_20558__$1);

(statearr_20678[(7)] = inst_20557__$1);

return statearr_20678;
})();
if(cljs.core.truth_(inst_20569__$1)){
var statearr_20679_20722 = state_20651__$1;
(statearr_20679_20722[(1)] = (6));

} else {
var statearr_20680_20723 = state_20651__$1;
(statearr_20680_20723[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (23))){
var inst_20585 = (state_20651[(8)]);
var inst_20622 = cljs.core.coll_QMARK_.call(null,inst_20585);
var state_20651__$1 = state_20651;
if(inst_20622){
var statearr_20681_20724 = state_20651__$1;
(statearr_20681_20724[(1)] = (25));

} else {
var statearr_20682_20725 = state_20651__$1;
(statearr_20682_20725[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (19))){
var inst_20583 = (state_20651[(14)]);
var inst_20613 = cljs.core.PersistentHashMap.EMPTY;
var inst_20614 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20613,inst_20583);
var state_20651__$1 = state_20651;
var statearr_20683_20726 = state_20651__$1;
(statearr_20683_20726[(2)] = inst_20614);

(statearr_20683_20726[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (11))){
var inst_20583 = (state_20651[(14)]);
var state_20651__$1 = state_20651;
var statearr_20685_20727 = state_20651__$1;
(statearr_20685_20727[(2)] = inst_20583);

(statearr_20685_20727[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (9))){
var inst_20554 = (state_20651[(17)]);
var inst_20558 = (state_20651[(12)]);
var inst_20579 = (state_20651[(16)]);
var inst_20578 = (state_20651[(2)]);
var inst_20579__$1 = fluree.db.util.async.throw_err.call(null,inst_20578);
var inst_20580 = cljs.core.count.call(null,inst_20579__$1);
var inst_20581 = fluree.db.query.analytical.add_fuel.call(null,inst_20580,fuel,max_fuel);
var inst_20582 = cljs.core.vals.call(null,inst_20554);
var inst_20583 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20582,inst_20579__$1);
var state_20651__$1 = (function (){var statearr_20686 = state_20651;
(statearr_20686[(14)] = inst_20583);

(statearr_20686[(16)] = inst_20579__$1);

(statearr_20686[(19)] = inst_20581);

return statearr_20686;
})();
if(cljs.core.truth_(inst_20558)){
var statearr_20687_20728 = state_20651__$1;
(statearr_20687_20728[(1)] = (10));

} else {
var statearr_20688_20729 = state_20651__$1;
(statearr_20688_20729[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (5))){
var _ = (function (){var statearr_20689 = state_20651;
(statearr_20689[(4)] = cljs.core.rest.call(null,(state_20651[(4)])));

return statearr_20689;
})();
var state_20651__$1 = state_20651;
var ex20684 = (state_20651__$1[(2)]);
var statearr_20690_20730 = state_20651__$1;
(statearr_20690_20730[(5)] = ex20684);


if((ex20684 instanceof Error)){
var statearr_20691_20731 = state_20651__$1;
(statearr_20691_20731[(1)] = (4));

(statearr_20691_20731[(5)] = null);

} else {
throw ex20684;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (14))){
var state_20651__$1 = state_20651;
var statearr_20692_20732 = state_20651__$1;
(statearr_20692_20732[(2)] = null);

(statearr_20692_20732[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (26))){
var state_20651__$1 = state_20651;
var statearr_20693_20733 = state_20651__$1;
(statearr_20693_20733[(2)] = null);

(statearr_20693_20733[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (16))){
var state_20651__$1 = state_20651;
var statearr_20694_20734 = state_20651__$1;
(statearr_20694_20734[(2)] = null);

(statearr_20694_20734[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (10))){
var inst_20567 = (state_20651[(13)]);
var inst_20588 = (state_20651[(10)]);
var inst_20585 = cljs.core.first.call(null,inst_20567);
var inst_20586 = cljs.core.first.call(null,clause);
var inst_20587 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20586);
var inst_20588__$1 = cljs.core.nth.call(null,inst_20567,(1));
var inst_20589 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20588__$1);
var state_20651__$1 = (function (){var statearr_20695 = state_20651;
(statearr_20695[(10)] = inst_20588__$1);

(statearr_20695[(11)] = inst_20587);

(statearr_20695[(8)] = inst_20585);

return statearr_20695;
})();
if(cljs.core.truth_(inst_20589)){
var statearr_20696_20735 = state_20651__$1;
(statearr_20696_20735[(1)] = (13));

} else {
var statearr_20697_20736 = state_20651__$1;
(statearr_20697_20736[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (18))){
var inst_20587 = (state_20651[(11)]);
var inst_20611 = (state_20651[(2)]);
var state_20651__$1 = (function (){var statearr_20698 = state_20651;
(statearr_20698[(20)] = inst_20611);

return statearr_20698;
})();
if(cljs.core.truth_(inst_20587)){
var statearr_20699_20737 = state_20651__$1;
(statearr_20699_20737[(1)] = (19));

} else {
var statearr_20700_20738 = state_20651__$1;
(statearr_20700_20738[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20652 === (8))){
var inst_20567 = (state_20651[(13)]);
var inst_20568 = (state_20651[(18)]);
var inst_20573 = (state_20651[(2)]);
var inst_20574 = [inst_20573];
var inst_20575 = cljs.core.PersistentHashMap.fromArrays(inst_20568,inst_20574);
var inst_20576 = fluree.db.query.range.search.call(null,db,inst_20567,inst_20575);
var state_20651__$1 = state_20651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20651__$1,(9),inst_20576);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20701 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20701[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_20701[(1)] = (1));

return statearr_20701;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20651){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20702){var ex__2749__auto__ = e20702;
var statearr_20703_20739 = state_20651;
(statearr_20703_20739[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20651[(4)]))){
var statearr_20704_20740 = state_20651;
(statearr_20704_20740[(1)] = cljs.core.first.call(null,(state_20651[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20741 = state_20651;
state_20651 = G__20741;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_20651){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20705 = f__2769__auto__.call(null);
(statearr_20705[(6)] = c__2768__auto__);

return statearr_20705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20742,res,clause){
var map__20743 = p__20742;
var map__20743__$1 = cljs.core.__destructure_map.call(null,map__20743);
var db = map__20743__$1;
var conn = cljs.core.get.call(null,map__20743__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__20743__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__20743__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20852){
var state_val_20853 = (state_20852[(1)]);
if((state_val_20853 === (7))){
var inst_20752 = (state_20852[(7)]);
var state_20852__$1 = state_20852;
var statearr_20854_20895 = state_20852__$1;
(statearr_20854_20895[(2)] = inst_20752);

(statearr_20854_20895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (20))){
var state_20852__$1 = state_20852;
var statearr_20855_20896 = state_20852__$1;
(statearr_20855_20896[(2)] = null);

(statearr_20855_20896[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (1))){
var state_20852__$1 = state_20852;
var statearr_20856_20897 = state_20852__$1;
(statearr_20856_20897[(2)] = null);

(statearr_20856_20897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (24))){
var inst_20754 = (state_20852[(8)]);
var inst_20825 = (state_20852[(2)]);
var inst_20826 = fluree.db.flake.sid__GT_cid.call(null,inst_20825);
var inst_20827 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20826);
var inst_20828 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20830 = [inst_20754];
var inst_20831 = (new cljs.core.PersistentVector(null,1,(5),inst_20829,inst_20830,null));
var inst_20832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20834 = [inst_20827];
var inst_20835 = (new cljs.core.PersistentVector(null,1,(5),inst_20833,inst_20834,null));
var inst_20836 = [inst_20835];
var inst_20837 = (new cljs.core.PersistentVector(null,1,(5),inst_20832,inst_20836,null));
var inst_20838 = cljs.core.PersistentHashMap.EMPTY;
var inst_20839 = [inst_20831,inst_20837,inst_20838];
var inst_20840 = cljs.core.PersistentHashMap.fromArrays(inst_20828,inst_20839);
var state_20852__$1 = state_20852;
var statearr_20857_20898 = state_20852__$1;
(statearr_20857_20898[(2)] = inst_20840);

(statearr_20857_20898[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (4))){
var inst_20745 = (state_20852[(2)]);
var state_20852__$1 = state_20852;
var statearr_20858_20899 = state_20852__$1;
(statearr_20858_20899[(2)] = inst_20745);

(statearr_20858_20899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (15))){
var inst_20754 = (state_20852[(8)]);
var inst_20752 = (state_20852[(7)]);
var inst_20773 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20774 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20776 = [inst_20752];
var inst_20777 = (new cljs.core.PersistentVector(null,1,(5),inst_20775,inst_20776,null));
var inst_20778 = (function (){var subject_var = inst_20752;
var object_var = inst_20754;
var min_sid = inst_20773;
var max_sid = (0);
return (function (p1__20744_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20744_SHARP_);
});
})();
var inst_20779 = cljs.core.range.call(null,inst_20773,(0));
var inst_20780 = cljs.core.map.call(null,inst_20778,inst_20779);
var inst_20781 = cljs.core.PersistentHashMap.EMPTY;
var inst_20782 = [inst_20777,inst_20780,inst_20781];
var inst_20783 = cljs.core.PersistentHashMap.fromArrays(inst_20774,inst_20782);
var state_20852__$1 = state_20852;
var statearr_20859_20900 = state_20852__$1;
(statearr_20859_20900[(2)] = inst_20783);

(statearr_20859_20900[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (21))){
var inst_20843 = (state_20852[(2)]);
var state_20852__$1 = state_20852;
var statearr_20860_20901 = state_20852__$1;
(statearr_20860_20901[(2)] = inst_20843);

(statearr_20860_20901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (13))){
var inst_20754 = (state_20852[(8)]);
var state_20852__$1 = state_20852;
if(cljs.core.truth_(inst_20754)){
var statearr_20861_20902 = state_20852__$1;
(statearr_20861_20902[(1)] = (19));

} else {
var statearr_20862_20903 = state_20852__$1;
(statearr_20862_20903[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (22))){
var inst_20816 = (state_20852[(9)]);
var state_20852__$1 = state_20852;
var statearr_20863_20904 = state_20852__$1;
(statearr_20863_20904[(2)] = inst_20816);

(statearr_20863_20904[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (6))){
var inst_20754 = (state_20852[(8)]);
var state_20852__$1 = state_20852;
var statearr_20864_20905 = state_20852__$1;
(statearr_20864_20905[(2)] = inst_20754);

(statearr_20864_20905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (25))){
var inst_20822 = (state_20852[(2)]);
var inst_20823 = fluree.db.util.async.throw_err.call(null,inst_20822);
var state_20852__$1 = state_20852;
var statearr_20865_20906 = state_20852__$1;
(statearr_20865_20906[(2)] = inst_20823);

(statearr_20865_20906[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (17))){
var inst_20813 = (state_20852[(2)]);
var state_20852__$1 = state_20852;
var statearr_20866_20907 = state_20852__$1;
(statearr_20866_20907[(2)] = inst_20813);

(statearr_20866_20907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (3))){
var inst_20850 = (state_20852[(2)]);
var state_20852__$1 = state_20852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20852__$1,inst_20850);
} else {
if((state_val_20853 === (12))){
var inst_20767 = ["_tx",null,"_block",null];
var inst_20768 = (new cljs.core.PersistentArrayMap(null,2,inst_20767,null));
var inst_20769 = (new cljs.core.PersistentHashSet(null,inst_20768,null));
var inst_20770 = cljs.core.last.call(null,clause);
var inst_20771 = inst_20769.call(null,inst_20770);
var state_20852__$1 = state_20852;
if(cljs.core.truth_(inst_20771)){
var statearr_20867_20908 = state_20852__$1;
(statearr_20867_20908[(1)] = (15));

} else {
var statearr_20868_20909 = state_20852__$1;
(statearr_20868_20909[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (2))){
var inst_20752 = (state_20852[(7)]);
var _ = (function (){var statearr_20869 = state_20852;
(statearr_20869[(4)] = cljs.core.cons.call(null,(5),(state_20852[(4)])));

return statearr_20869;
})();
var inst_20751 = cljs.core.first.call(null,clause);
var inst_20752__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20751);
var inst_20753 = cljs.core.last.call(null,clause);
var inst_20754 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20753);
var state_20852__$1 = (function (){var statearr_20870 = state_20852;
(statearr_20870[(8)] = inst_20754);

(statearr_20870[(7)] = inst_20752__$1);

return statearr_20870;
})();
if(cljs.core.truth_(inst_20752__$1)){
var statearr_20871_20910 = state_20852__$1;
(statearr_20871_20910[(1)] = (6));

} else {
var statearr_20872_20911 = state_20852__$1;
(statearr_20872_20911[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (23))){
var inst_20816 = (state_20852[(9)]);
var inst_20820 = fluree.db.dbproto._subid.call(null,db,inst_20816);
var state_20852__$1 = state_20852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20852__$1,(25),inst_20820);
} else {
if((state_val_20853 === (19))){
var inst_20816 = (state_20852[(9)]);
var inst_20816__$1 = cljs.core.first.call(null,clause);
var inst_20817 = typeof inst_20816__$1 === 'number';
var state_20852__$1 = (function (){var statearr_20873 = state_20852;
(statearr_20873[(9)] = inst_20816__$1);

return statearr_20873;
})();
if(cljs.core.truth_(inst_20817)){
var statearr_20874_20912 = state_20852__$1;
(statearr_20874_20912[(1)] = (22));

} else {
var statearr_20875_20913 = state_20852__$1;
(statearr_20875_20913[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (11))){
var inst_20847 = (state_20852[(2)]);
var _ = (function (){var statearr_20877 = state_20852;
(statearr_20877[(4)] = cljs.core.rest.call(null,(state_20852[(4)])));

return statearr_20877;
})();
var state_20852__$1 = state_20852;
var statearr_20878_20914 = state_20852__$1;
(statearr_20878_20914[(2)] = inst_20847);

(statearr_20878_20914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (9))){
var inst_20760 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20761 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20762 = cljs.core.PersistentHashMap.fromArrays(inst_20760,inst_20761);
var inst_20763 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_20762);
var inst_20764 = (function(){throw inst_20763})();
var state_20852__$1 = state_20852;
var statearr_20879_20915 = state_20852__$1;
(statearr_20879_20915[(2)] = inst_20764);

(statearr_20879_20915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (5))){
var _ = (function (){var statearr_20880 = state_20852;
(statearr_20880[(4)] = cljs.core.rest.call(null,(state_20852[(4)])));

return statearr_20880;
})();
var state_20852__$1 = state_20852;
var ex20876 = (state_20852__$1[(2)]);
var statearr_20881_20916 = state_20852__$1;
(statearr_20881_20916[(5)] = ex20876);


if((ex20876 instanceof Error)){
var statearr_20882_20917 = state_20852__$1;
(statearr_20882_20917[(1)] = (4));

(statearr_20882_20917[(5)] = null);

} else {
throw ex20876;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (14))){
var inst_20845 = (state_20852[(2)]);
var state_20852__$1 = state_20852;
var statearr_20883_20918 = state_20852__$1;
(statearr_20883_20918[(2)] = inst_20845);

(statearr_20883_20918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (16))){
var inst_20789 = (state_20852[(10)]);
var inst_20788 = (state_20852[(11)]);
var inst_20786 = (state_20852[(12)]);
var inst_20785 = cljs.core.last.call(null,clause);
var inst_20786__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20785);
var inst_20787 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20788__$1 = cljs.core.get.call(null,inst_20787,inst_20786__$1);
var inst_20789__$1 = fluree.db.flake.min_subject_id.call(null,inst_20786__$1);
var inst_20790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20791 = [inst_20788__$1];
var inst_20792 = (new cljs.core.PersistentVector(null,1,(5),inst_20790,inst_20791,null));
var inst_20793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20794 = [inst_20789__$1];
var inst_20795 = (new cljs.core.PersistentVector(null,1,(5),inst_20793,inst_20794,null));
var inst_20796 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20792,cljs.core._LT__EQ_,inst_20795);
var state_20852__$1 = (function (){var statearr_20884 = state_20852;
(statearr_20884[(10)] = inst_20789__$1);

(statearr_20884[(11)] = inst_20788__$1);

(statearr_20884[(12)] = inst_20786__$1);

return statearr_20884;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20852__$1,(18),inst_20796);
} else {
if((state_val_20853 === (10))){
var inst_20752 = (state_20852[(7)]);
var state_20852__$1 = state_20852;
if(cljs.core.truth_(inst_20752)){
var statearr_20885_20919 = state_20852__$1;
(statearr_20885_20919[(1)] = (12));

} else {
var statearr_20886_20920 = state_20852__$1;
(statearr_20886_20920[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (18))){
var inst_20754 = (state_20852[(8)]);
var inst_20789 = (state_20852[(10)]);
var inst_20752 = (state_20852[(7)]);
var inst_20788 = (state_20852[(11)]);
var inst_20786 = (state_20852[(12)]);
var inst_20798 = (state_20852[(2)]);
var inst_20799 = fluree.db.util.async.throw_err.call(null,inst_20798);
var inst_20800 = (function (){var subject_var = inst_20752;
var object_var = inst_20754;
var partition = inst_20786;
var max_sid = inst_20788;
var min_sid = inst_20789;
var flakes = inst_20799;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20801 = cljs.core.map.call(null,inst_20800);
var inst_20802 = cljs.core.distinct.call(null);
var inst_20803 = cljs.core.comp.call(null,inst_20801,inst_20802);
var inst_20804 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20806 = [inst_20752];
var inst_20807 = (new cljs.core.PersistentVector(null,1,(5),inst_20805,inst_20806,null));
var inst_20808 = cljs.core.sequence.call(null,inst_20803,inst_20799);
var inst_20809 = cljs.core.PersistentHashMap.EMPTY;
var inst_20810 = [inst_20807,inst_20808,inst_20809];
var inst_20811 = cljs.core.PersistentHashMap.fromArrays(inst_20804,inst_20810);
var state_20852__$1 = state_20852;
var statearr_20887_20921 = state_20852__$1;
(statearr_20887_20921[(2)] = inst_20811);

(statearr_20887_20921[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20853 === (8))){
var inst_20758 = (state_20852[(2)]);
var state_20852__$1 = state_20852;
if(cljs.core.truth_(inst_20758)){
var statearr_20888_20922 = state_20852__$1;
(statearr_20888_20922[(1)] = (9));

} else {
var statearr_20889_20923 = state_20852__$1;
(statearr_20889_20923[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20890 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20890[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_20890[(1)] = (1));

return statearr_20890;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20852){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20891){var ex__2749__auto__ = e20891;
var statearr_20892_20924 = state_20852;
(statearr_20892_20924[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20852[(4)]))){
var statearr_20893_20925 = state_20852;
(statearr_20893_20925[(1)] = cljs.core.first.call(null,(state_20852[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20926 = state_20852;
state_20852 = G__20926;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_20852){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20894 = f__2769__auto__.call(null);
(statearr_20894[(6)] = c__2768__auto__);

return statearr_20894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__20932 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__20932 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__20932;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__20933(s__20934){
return (new cljs.core.LazySeq(null,(function (){
var s__20934__$1 = s__20934;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__20934__$1);
if(temp__5804__auto__){
var s__20934__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20934__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__20934__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__20936 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__20935 = (0);
while(true){
if((i__20935 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__20935);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__20936,(delta * delta));

var G__20937 = (i__20935 + (1));
i__20935 = G__20937;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20936),fluree$db$query$analytical$variance_$_iter__20933.call(null,cljs.core.chunk_rest.call(null,s__20934__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20936),null);
}
} else {
var x = cljs.core.first.call(null,s__20934__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__20933.call(null,cljs.core.rest.call(null,s__20934__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__20938 = null;
var G__20938__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20938__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20938 = function(n,coll){
switch(arguments.length){
case 1:
return G__20938__1.call(this,n);
case 2:
return G__20938__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20938.cljs$core$IFn$_invoke$arity$1 = G__20938__1;
G__20938.cljs$core$IFn$_invoke$arity$2 = G__20938__2;
return G__20938;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20939 = null;
var G__20939__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20939__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20939 = function(n,coll){
switch(arguments.length){
case 1:
return G__20939__1.call(this,n);
case 2:
return G__20939__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20939.cljs$core$IFn$_invoke$arity$1 = G__20939__1;
G__20939.cljs$core$IFn$_invoke$arity$2 = G__20939__2;
return G__20939;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20940 = null;
var G__20940__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__20940__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__20940 = function(n,coll){
switch(arguments.length){
case 1:
return G__20940__1.call(this,n);
case 2:
return G__20940__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20940.cljs$core$IFn$_invoke$arity$1 = G__20940__1;
G__20940.cljs$core$IFn$_invoke$arity$2 = G__20940__2;
return G__20940;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count.call(null,parsed_code);
var vec__20941 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),cljs.core.second.call(null,parsed_code),cljs.core.last.call(null,parsed_code)], null):((cljs.core._EQ_.call(null,(2),list_count))?((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,parsed_code)))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),null,cljs.core.last.call(null,parsed_code)], null)):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.call(null,vec__20941,(0),null);
var arg = cljs.core.nth.call(null,vec__20941,(1),null);
var var$ = cljs.core.nth.call(null,vec__20941,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20944 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__20944,(0),null);
var variable = cljs.core.nth.call(null,vec__20944,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.call(null,parsed_code),")"].join('');
if(cljs.core.truth_(valid_var.call(null,variable))){
} else {
throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.call(null,code_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_.call(null,code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__20947 = aggregate_fn_map;
var map__20947__$1 = cljs.core.__destructure_map.call(null,map__20947);
var variable = cljs.core.get.call(null,map__20947__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__20947__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__20947__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__20949 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__20949,(0),null);
var agg_result = cljs.core.nth.call(null,vec__20949,(1),null);
var map__20952 = res__$1;
var map__20952__$1 = cljs.core.__destructure_map.call(null,map__20952);
var headers = cljs.core.get.call(null,map__20952__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20952__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20948_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__20948_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__20953_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20953_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__20954_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20954_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__20955_SHARP_,p2__20956_SHARP_){
return cljs.core.conj.call(null,p1__20955_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__20956_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__20957_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20957_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__20960,row,b_tuple){
var vec__20961 = p__20960;
var acc = cljs.core.nth.call(null,vec__20961,(0),null);
var b_rows = cljs.core.nth.call(null,vec__20961,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__20958_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20958_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__20959_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20959_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__20964_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20964_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20965_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20965_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20967_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20967_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20966_SHARP_){
return cljs.core.range.call(null,(0),p1__20966_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__20968_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20968_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__20969_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20969_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20970_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20970_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20972_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20972_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20971_SHARP_){
return cljs.core.range.call(null,(0),p1__20971_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__20973_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20973_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__20975 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__20975,(0),null);
var _ = cljs.core.nth.call(null,vec__20975,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__20974_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__20974_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__20980 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__20980,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__20980,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__20978_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__20978_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__20979_SHARP_){
return cljs.core.nth.call(null,clause,p1__20979_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20983,filters,optional_QMARK_){
var map__20984 = p__20983;
var map__20984__$1 = cljs.core.__destructure_map.call(null,map__20984);
var tuple_map = map__20984__$1;
var headers = cljs.core.get.call(null,map__20984__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20984__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__20984__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20985 = clause;
var k = cljs.core.nth.call(null,vec__20985,(0),null);
var v = cljs.core.nth.call(null,vec__20985,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20988 = res;
var map__20988__$1 = cljs.core.__destructure_map.call(null,map__20988);
var headers = cljs.core.get.call(null,map__20988__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20988__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21044){
var state_val_21045 = (state_21044[(1)]);
if((state_val_21045 === (7))){
var inst_21018 = (state_21044[(7)]);
var inst_21016 = (state_21044[(2)]);
var inst_21017 = fluree.db.util.async.throw_err.call(null,inst_21016);
var inst_21018__$1 = cljs.core.nth.call(null,inst_21017,(0),null);
var inst_21019 = cljs.core.nth.call(null,inst_21017,(1),null);
var inst_21020 = (inst_21018__$1 == null);
var state_21044__$1 = (function (){var statearr_21046 = state_21044;
(statearr_21046[(7)] = inst_21018__$1);

(statearr_21046[(8)] = inst_21019);

return statearr_21046;
})();
if(cljs.core.truth_(inst_21020)){
var statearr_21047_21076 = state_21044__$1;
(statearr_21047_21076[(1)] = (8));

} else {
var statearr_21048_21077 = state_21044__$1;
(statearr_21048_21077[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (1))){
var inst_20996 = optional_clauses;
var inst_20997 = cljs.core.seq.call(null,inst_20996);
var inst_20998 = cljs.core.first.call(null,inst_20997);
var inst_20999 = cljs.core.next.call(null,inst_20997);
var inst_21000 = where_tuples;
var inst_21001 = inst_20996;
var inst_21002 = inst_21000;
var state_21044__$1 = (function (){var statearr_21049 = state_21044;
(statearr_21049[(9)] = inst_21002);

(statearr_21049[(10)] = inst_21001);

(statearr_21049[(11)] = inst_20999);

(statearr_21049[(12)] = inst_20998);

return statearr_21049;
})();
var statearr_21050_21078 = state_21044__$1;
(statearr_21050_21078[(2)] = null);

(statearr_21050_21078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (4))){
var inst_21002 = (state_21044[(9)]);
var inst_21009 = (state_21044[(13)]);
var inst_21008 = (state_21044[(14)]);
var inst_21014 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21002,inst_21008,inst_21009,true,fuel,max_fuel,opts);
var state_21044__$1 = state_21044;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21044__$1,(7),inst_21014);
} else {
if((state_val_21045 === (15))){
var state_21044__$1 = state_21044;
var statearr_21051_21079 = state_21044__$1;
(statearr_21051_21079[(2)] = null);

(statearr_21051_21079[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (13))){
var inst_21035 = (state_21044[(2)]);
var state_21044__$1 = state_21044;
var statearr_21052_21080 = state_21044__$1;
(statearr_21052_21080[(2)] = inst_21035);

(statearr_21052_21080[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (6))){
var inst_21040 = (state_21044[(2)]);
var state_21044__$1 = state_21044;
var statearr_21053_21081 = state_21044__$1;
(statearr_21053_21081[(2)] = inst_21040);

(statearr_21053_21081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (3))){
var inst_21042 = (state_21044[(2)]);
var state_21044__$1 = state_21044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21044__$1,inst_21042);
} else {
if((state_val_21045 === (12))){
var state_21044__$1 = state_21044;
var statearr_21054_21082 = state_21044__$1;
(statearr_21054_21082[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (2))){
var inst_21001 = (state_21044[(10)]);
var inst_21008 = (state_21044[(14)]);
var inst_21007 = cljs.core.seq.call(null,inst_21001);
var inst_21008__$1 = cljs.core.first.call(null,inst_21007);
var inst_21009 = cljs.core.next.call(null,inst_21007);
var state_21044__$1 = (function (){var statearr_21056 = state_21044;
(statearr_21056[(13)] = inst_21009);

(statearr_21056[(14)] = inst_21008__$1);

return statearr_21056;
})();
if(cljs.core.truth_(inst_21008__$1)){
var statearr_21057_21083 = state_21044__$1;
(statearr_21057_21083[(1)] = (4));

} else {
var statearr_21058_21084 = state_21044__$1;
(statearr_21058_21084[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (11))){
var inst_21018 = (state_21044[(7)]);
var inst_21019 = (state_21044[(8)]);
var inst_21001 = inst_21019;
var inst_21002 = inst_21018;
var state_21044__$1 = (function (){var statearr_21059 = state_21044;
(statearr_21059[(9)] = inst_21002);

(statearr_21059[(10)] = inst_21001);

return statearr_21059;
})();
var statearr_21060_21085 = state_21044__$1;
(statearr_21060_21085[(2)] = null);

(statearr_21060_21085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (9))){
var inst_21008 = (state_21044[(14)]);
var inst_21024 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21008);
var state_21044__$1 = state_21044;
if(cljs.core.truth_(inst_21024)){
var statearr_21061_21086 = state_21044__$1;
(statearr_21061_21086[(1)] = (11));

} else {
var statearr_21062_21087 = state_21044__$1;
(statearr_21062_21087[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (5))){
var inst_21002 = (state_21044[(9)]);
var state_21044__$1 = state_21044;
var statearr_21063_21088 = state_21044__$1;
(statearr_21063_21088[(2)] = inst_21002);

(statearr_21063_21088[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (14))){
var inst_21002 = (state_21044[(9)]);
var inst_21018 = (state_21044[(7)]);
var inst_21019 = (state_21044[(8)]);
var inst_21029 = fluree.db.query.analytical.left_outer_join.call(null,inst_21002,inst_21018);
var inst_21001 = inst_21019;
var inst_21002__$1 = inst_21029;
var state_21044__$1 = (function (){var statearr_21064 = state_21044;
(statearr_21064[(9)] = inst_21002__$1);

(statearr_21064[(10)] = inst_21001);

return statearr_21064;
})();
var statearr_21065_21089 = state_21044__$1;
(statearr_21065_21089[(2)] = null);

(statearr_21065_21089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (16))){
var inst_21033 = (state_21044[(2)]);
var state_21044__$1 = state_21044;
var statearr_21067_21090 = state_21044__$1;
(statearr_21067_21090[(2)] = inst_21033);

(statearr_21067_21090[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (10))){
var inst_21037 = (state_21044[(2)]);
var state_21044__$1 = state_21044;
var statearr_21068_21091 = state_21044__$1;
(statearr_21068_21091[(2)] = inst_21037);

(statearr_21068_21091[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21045 === (8))){
var inst_21002 = (state_21044[(9)]);
var inst_21019 = (state_21044[(8)]);
var tmp21066 = inst_21002;
var inst_21001 = inst_21019;
var inst_21002__$1 = tmp21066;
var state_21044__$1 = (function (){var statearr_21069 = state_21044;
(statearr_21069[(9)] = inst_21002__$1);

(statearr_21069[(10)] = inst_21001);

return statearr_21069;
})();
var statearr_21070_21092 = state_21044__$1;
(statearr_21070_21092[(2)] = null);

(statearr_21070_21092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_21071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21071[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_21071[(1)] = (1));

return statearr_21071;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_21044){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21072){var ex__2749__auto__ = e21072;
var statearr_21073_21093 = state_21044;
(statearr_21073_21093[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21044[(4)]))){
var statearr_21074_21094 = state_21044;
(statearr_21074_21094[(1)] = cljs.core.first.call(null,(state_21044[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21095 = state_21044;
state_21044 = G__21095;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_21044){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_21044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21075 = f__2769__auto__.call(null);
(statearr_21075[(6)] = c__2768__auto__);

return statearr_21075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21097){
var vec__21098 = p__21097;
var var_name = cljs.core.nth.call(null,vec__21098,(0),null);
var var_val = cljs.core.nth.call(null,vec__21098,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21096_SHARP_){
return cljs.core.conj.call(null,p1__21096_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21102,p__21103,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21104 = p__21102;
var map__21104__$1 = cljs.core.__destructure_map.call(null,map__21104);
var q_map = map__21104__$1;
var prefixes = cljs.core.get.call(null,map__21104__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21105 = p__21103;
var map__21105__$1 = cljs.core.__destructure_map.call(null,map__21105);
var res = map__21105__$1;
var vars = cljs.core.get.call(null,map__21105__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21342){
var state_val_21343 = (state_21342[(1)]);
if((state_val_21343 === (65))){
var inst_21291 = (state_21342[(7)]);
var inst_21292 = (state_21342[(8)]);
var inst_21303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21304 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_21291,res,inst_21292);
var inst_21305 = [inst_21304,r];
var inst_21306 = (new cljs.core.PersistentVector(null,2,(5),inst_21303,inst_21305,null));
var state_21342__$1 = state_21342;
var statearr_21344_21449 = state_21342__$1;
(statearr_21344_21449[(2)] = inst_21306);

(statearr_21344_21449[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (70))){
var inst_21318 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21345_21450 = state_21342__$1;
(statearr_21345_21450[(2)] = inst_21318);

(statearr_21345_21450[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (62))){
var inst_21292 = (state_21342[(8)]);
var inst_21300 = cljs.core.second.call(null,inst_21292);
var inst_21301 = clojure.string.starts_with_QMARK_.call(null,inst_21300,"fullText:");
var state_21342__$1 = state_21342;
if(inst_21301){
var statearr_21346_21451 = state_21342__$1;
(statearr_21346_21451[(1)] = (65));

} else {
var statearr_21347_21452 = state_21342__$1;
(statearr_21347_21452[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (7))){
var inst_21211 = (state_21342[(9)]);
var inst_21210 = cljs.core.count.call(null,clause);
var inst_21211__$1 = cljs.core._EQ_.call(null,(3),inst_21210);
var state_21342__$1 = (function (){var statearr_21348 = state_21342;
(statearr_21348[(9)] = inst_21211__$1);

return statearr_21348;
})();
if(inst_21211__$1){
var statearr_21349_21453 = state_21342__$1;
(statearr_21349_21453[(1)] = (31));

} else {
var statearr_21350_21454 = state_21342__$1;
(statearr_21350_21454[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (59))){
var inst_21325 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21351_21455 = state_21342__$1;
(statearr_21351_21455[(2)] = inst_21325);

(statearr_21351_21455[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (20))){
var inst_21174 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21352_21456 = state_21342__$1;
(statearr_21352_21456[(2)] = inst_21174);

(statearr_21352_21456[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (58))){
var state_21342__$1 = state_21342;
var statearr_21353_21457 = state_21342__$1;
(statearr_21353_21457[(2)] = null);

(statearr_21353_21457[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (60))){
var inst_21291 = (state_21342[(7)]);
var inst_21289 = (state_21342[(2)]);
var inst_21290 = fluree.db.util.async.throw_err.call(null,inst_21289);
var inst_21291__$1 = cljs.core.nth.call(null,inst_21290,(0),null);
var inst_21292 = cljs.core.nth.call(null,inst_21290,(1),null);
var inst_21293 = cljs.core._EQ_.call(null,"$wd",inst_21291__$1);
var state_21342__$1 = (function (){var statearr_21354 = state_21342;
(statearr_21354[(7)] = inst_21291__$1);

(statearr_21354[(8)] = inst_21292);

return statearr_21354;
})();
if(inst_21293){
var statearr_21355_21458 = state_21342__$1;
(statearr_21355_21458[(1)] = (61));

} else {
var statearr_21356_21459 = state_21342__$1;
(statearr_21356_21459[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (27))){
var inst_21204 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21357_21460 = state_21342__$1;
(statearr_21357_21460[(2)] = inst_21204);

(statearr_21357_21460[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (1))){
var state_21342__$1 = state_21342;
var statearr_21358_21461 = state_21342__$1;
(statearr_21358_21461[(2)] = null);

(statearr_21358_21461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (69))){
var state_21342__$1 = state_21342;
var statearr_21359_21462 = state_21342__$1;
(statearr_21359_21462[(2)] = null);

(statearr_21359_21462[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (24))){
var inst_21168 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21360_21463 = state_21342__$1;
(statearr_21360_21463[(2)] = inst_21168);

(statearr_21360_21463[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (55))){
var inst_21274 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21275 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21276 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21277 = cljs.core.PersistentHashMap.fromArrays(inst_21275,inst_21276);
var inst_21278 = cljs.core.ex_info.call(null,inst_21274,inst_21277);
var inst_21279 = (function(){throw inst_21278})();
var state_21342__$1 = state_21342;
var statearr_21361_21464 = state_21342__$1;
(statearr_21361_21464[(2)] = inst_21279);

(statearr_21361_21464[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (39))){
var inst_21231 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
if(cljs.core.truth_(inst_21231)){
var statearr_21362_21465 = state_21342__$1;
(statearr_21362_21465[(1)] = (40));

} else {
var statearr_21363_21466 = state_21342__$1;
(statearr_21363_21466[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (46))){
var inst_21331 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21364_21467 = state_21342__$1;
(statearr_21364_21467[(2)] = inst_21331);

(statearr_21364_21467[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (4))){
var inst_21106 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21365_21468 = state_21342__$1;
(statearr_21365_21468[(2)] = inst_21106);

(statearr_21365_21468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (54))){
var inst_21267 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21268 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21269 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21270 = cljs.core.PersistentHashMap.fromArrays(inst_21268,inst_21269);
var inst_21271 = cljs.core.ex_info.call(null,inst_21267,inst_21270);
var inst_21272 = (function(){throw inst_21271})();
var state_21342__$1 = state_21342;
var statearr_21366_21469 = state_21342__$1;
(statearr_21366_21469[(2)] = inst_21272);

(statearr_21366_21469[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (15))){
var inst_21206 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21367_21470 = state_21342__$1;
(statearr_21367_21470[(2)] = inst_21206);

(statearr_21367_21470[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (48))){
var inst_21255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21256 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_21257 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21256);
var inst_21258 = [inst_21257,r];
var inst_21259 = (new cljs.core.PersistentVector(null,2,(5),inst_21255,inst_21258,null));
var state_21342__$1 = state_21342;
var statearr_21368_21471 = state_21342__$1;
(statearr_21368_21471[(2)] = inst_21259);

(statearr_21368_21471[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (50))){
var inst_21329 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21369_21472 = state_21342__$1;
(statearr_21369_21472[(2)] = inst_21329);

(statearr_21369_21472[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (21))){
var inst_21145 = (state_21342[(10)]);
var inst_21142 = (state_21342[(11)]);
var inst_21143 = (state_21342[(12)]);
var inst_21115 = (state_21342[(13)]);
var inst_21119 = (state_21342[(14)]);
var inst_21151 = (state_21342[(15)]);
var inst_21140 = (state_21342[(16)]);
var inst_21144 = (state_21342[(17)]);
var inst_21152 = (state_21342[(18)]);
var inst_21156 = (state_21342[(2)]);
var inst_21157 = fluree.db.util.async.throw_err.call(null,inst_21156);
var inst_21158 = (function (){var expr__21117 = inst_21115;
var vec__21137 = inst_21140;
var new_res = inst_21157;
var G__21136 = inst_21144;
var rest = inst_21152;
var seq__21148 = inst_21152;
var first__21139 = inst_21142;
var tuples = inst_21145;
var vec__21147 = inst_21144;
var first__21149 = inst_21151;
var pred__21116 = inst_21119;
var seq__21138 = inst_21143;
var segment_type = inst_21115;
var clause_group = inst_21151;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21159 = cljs.core.keys.call(null,vars);
var inst_21160 = cljs.core.reduce.call(null,inst_21158,inst_21157,inst_21159);
var inst_21161 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_21160);
var state_21342__$1 = (function (){var statearr_21370 = state_21342;
(statearr_21370[(19)] = inst_21161);

return statearr_21370;
})();
if(cljs.core.truth_(inst_21145)){
var statearr_21371_21473 = state_21342__$1;
(statearr_21371_21473[(1)] = (22));

} else {
var statearr_21372_21474 = state_21342__$1;
(statearr_21372_21474[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (31))){
var inst_21213 = cljs.core.second.call(null,clause);
var inst_21214 = clojure.string.starts_with_QMARK_.call(null,inst_21213,"fullText:");
var state_21342__$1 = state_21342;
var statearr_21373_21475 = state_21342__$1;
(statearr_21373_21475[(2)] = inst_21214);

(statearr_21373_21475[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (32))){
var inst_21211 = (state_21342[(9)]);
var state_21342__$1 = state_21342;
var statearr_21374_21476 = state_21342__$1;
(statearr_21374_21476[(2)] = inst_21211);

(statearr_21374_21476[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (40))){
var inst_21233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21234 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_21342__$1 = (function (){var statearr_21375 = state_21342;
(statearr_21375[(20)] = inst_21233);

return statearr_21375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(43),inst_21234);
} else {
if((state_val_21343 === (56))){
var inst_21281 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21376_21477 = state_21342__$1;
(statearr_21376_21477[(2)] = inst_21281);

(statearr_21376_21477[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (33))){
var inst_21217 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
if(cljs.core.truth_(inst_21217)){
var statearr_21377_21478 = state_21342__$1;
(statearr_21377_21478[(1)] = (34));

} else {
var statearr_21378_21479 = state_21342__$1;
(statearr_21378_21479[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (13))){
var inst_21140 = (state_21342[(16)]);
var inst_21140__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21141 = cljs.core.seq.call(null,inst_21140__$1);
var inst_21142 = cljs.core.first.call(null,inst_21141);
var inst_21143 = cljs.core.next.call(null,inst_21141);
var inst_21144 = inst_21140__$1;
var inst_21145 = null;
var state_21342__$1 = (function (){var statearr_21379 = state_21342;
(statearr_21379[(10)] = inst_21145);

(statearr_21379[(11)] = inst_21142);

(statearr_21379[(12)] = inst_21143);

(statearr_21379[(16)] = inst_21140__$1);

(statearr_21379[(17)] = inst_21144);

return statearr_21379;
})();
var statearr_21380_21480 = state_21342__$1;
(statearr_21380_21480[(2)] = null);

(statearr_21380_21480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (22))){
var inst_21145 = (state_21342[(10)]);
var inst_21152 = (state_21342[(18)]);
var inst_21161 = (state_21342[(19)]);
var inst_21163 = fluree.db.query.union.results.call(null,inst_21145,inst_21161);
var inst_21144 = inst_21152;
var inst_21145__$1 = inst_21163;
var state_21342__$1 = (function (){var statearr_21381 = state_21342;
(statearr_21381[(10)] = inst_21145__$1);

(statearr_21381[(17)] = inst_21144);

return statearr_21381;
})();
var statearr_21382_21481 = state_21342__$1;
(statearr_21382_21481[(2)] = null);

(statearr_21382_21481[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (36))){
var inst_21335 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21383_21482 = state_21342__$1;
(statearr_21383_21482[(2)] = inst_21335);

(statearr_21383_21482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (41))){
var inst_21241 = cljs.core.count.call(null,clause);
var inst_21242 = cljs.core._EQ_.call(null,(3),inst_21241);
var state_21342__$1 = state_21342;
if(inst_21242){
var statearr_21384_21483 = state_21342__$1;
(statearr_21384_21483[(1)] = (44));

} else {
var statearr_21385_21484 = state_21342__$1;
(statearr_21385_21484[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (43))){
var inst_21233 = (state_21342[(20)]);
var inst_21236 = (state_21342[(2)]);
var inst_21237 = fluree.db.util.async.throw_err.call(null,inst_21236);
var inst_21238 = [inst_21237,r];
var inst_21239 = (new cljs.core.PersistentVector(null,2,(5),inst_21233,inst_21238,null));
var state_21342__$1 = state_21342;
var statearr_21386_21485 = state_21342__$1;
(statearr_21386_21485[(2)] = inst_21239);

(statearr_21386_21485[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (61))){
var inst_21292 = (state_21342[(8)]);
var inst_21295 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_21292,r,res,optional_QMARK_,fuel,max_fuel);
var state_21342__$1 = state_21342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(64),inst_21295);
} else {
if((state_val_21343 === (29))){
var inst_21115 = (state_21342[(13)]);
var inst_21198 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21115)].join('');
var inst_21199 = (new Error(inst_21198));
var inst_21200 = (function(){throw inst_21199})();
var state_21342__$1 = state_21342;
var statearr_21387_21486 = state_21342__$1;
(statearr_21387_21486[(2)] = inst_21200);

(statearr_21387_21486[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (44))){
var inst_21244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21245 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_21342__$1 = (function (){var statearr_21388 = state_21342;
(statearr_21388[(21)] = inst_21244);

return statearr_21388;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(47),inst_21245);
} else {
if((state_val_21343 === (6))){
var inst_21115 = (state_21342[(13)]);
var inst_21119 = (state_21342[(14)]);
var inst_21114 = cljs.core.keys.call(null,clause);
var inst_21115__$1 = cljs.core.first.call(null,inst_21114);
var inst_21119__$1 = cljs.core._EQ_;
var inst_21120 = inst_21119__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21115__$1);
var state_21342__$1 = (function (){var statearr_21389 = state_21342;
(statearr_21389[(13)] = inst_21115__$1);

(statearr_21389[(14)] = inst_21119__$1);

return statearr_21389;
})();
if(cljs.core.truth_(inst_21120)){
var statearr_21390_21487 = state_21342__$1;
(statearr_21390_21487[(1)] = (9));

} else {
var statearr_21391_21488 = state_21342__$1;
(statearr_21391_21488[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (28))){
var inst_21192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21193 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21194 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_21193,optional_QMARK_);
var inst_21195 = [inst_21194,r];
var inst_21196 = (new cljs.core.PersistentVector(null,2,(5),inst_21192,inst_21195,null));
var state_21342__$1 = state_21342;
var statearr_21392_21489 = state_21342__$1;
(statearr_21392_21489[(2)] = inst_21196);

(statearr_21392_21489[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (64))){
var inst_21297 = (state_21342[(2)]);
var inst_21298 = fluree.db.util.async.throw_err.call(null,inst_21297);
var state_21342__$1 = state_21342;
var statearr_21393_21490 = state_21342__$1;
(statearr_21393_21490[(2)] = inst_21298);

(statearr_21393_21490[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (51))){
var inst_21264 = cljs.core.first.call(null,clause);
var inst_21265 = cljs.core.sequential_QMARK_.call(null,inst_21264);
var state_21342__$1 = state_21342;
if(inst_21265){
var statearr_21394_21491 = state_21342__$1;
(statearr_21394_21491[(1)] = (54));

} else {
var statearr_21395_21492 = state_21342__$1;
(statearr_21395_21492[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (25))){
var inst_21115 = (state_21342[(13)]);
var inst_21119 = (state_21342[(14)]);
var inst_21180 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21181 = (function (){var segment_type = inst_21115;
var pred__21116 = inst_21119;
var expr__21117 = inst_21115;
var bindings = inst_21180;
return (function (p1__21101_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21101_SHARP_);
});
})();
var inst_21182 = cljs.core.map.call(null,inst_21181,inst_21180);
var inst_21183 = cljs.core.PersistentHashMap.EMPTY;
var inst_21184 = cljs.core.into.call(null,inst_21183,inst_21182);
var inst_21185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21186 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21184);
var inst_21187 = [inst_21186,r];
var inst_21188 = (new cljs.core.PersistentVector(null,2,(5),inst_21185,inst_21187,null));
var state_21342__$1 = state_21342;
var statearr_21396_21493 = state_21342__$1;
(statearr_21396_21493[(2)] = inst_21188);

(statearr_21396_21493[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (34))){
var inst_21219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21220 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_21221 = [inst_21220,r];
var inst_21222 = (new cljs.core.PersistentVector(null,2,(5),inst_21219,inst_21221,null));
var state_21342__$1 = state_21342;
var statearr_21397_21494 = state_21342__$1;
(statearr_21397_21494[(2)] = inst_21222);

(statearr_21397_21494[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (17))){
var inst_21176 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21398_21495 = state_21342__$1;
(statearr_21398_21495[(2)] = inst_21176);

(statearr_21398_21495[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (3))){
var inst_21340 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21342__$1,inst_21340);
} else {
if((state_val_21343 === (12))){
var inst_21122 = (state_21342[(22)]);
var inst_21126 = (state_21342[(2)]);
var inst_21127 = fluree.db.util.async.throw_err.call(null,inst_21126);
var inst_21128 = [inst_21127,r];
var inst_21129 = (new cljs.core.PersistentVector(null,2,(5),inst_21122,inst_21128,null));
var state_21342__$1 = state_21342;
var statearr_21399_21496 = state_21342__$1;
(statearr_21399_21496[(2)] = inst_21129);

(statearr_21399_21496[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (2))){
var _ = (function (){var statearr_21400 = state_21342;
(statearr_21400[(4)] = cljs.core.cons.call(null,(5),(state_21342[(4)])));

return statearr_21400;
})();
var inst_21112 = cljs.core.map_QMARK_.call(null,clause);
var state_21342__$1 = state_21342;
if(inst_21112){
var statearr_21401_21497 = state_21342__$1;
(statearr_21401_21497[(1)] = (6));

} else {
var statearr_21402_21498 = state_21342__$1;
(statearr_21402_21498[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (66))){
var state_21342__$1 = state_21342;
var statearr_21403_21499 = state_21342__$1;
(statearr_21403_21499[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (23))){
var inst_21152 = (state_21342[(18)]);
var inst_21161 = (state_21342[(19)]);
var inst_21144 = inst_21152;
var inst_21145 = inst_21161;
var state_21342__$1 = (function (){var statearr_21405 = state_21342;
(statearr_21405[(10)] = inst_21145);

(statearr_21405[(17)] = inst_21144);

return statearr_21405;
})();
var statearr_21406_21500 = state_21342__$1;
(statearr_21406_21500[(2)] = null);

(statearr_21406_21500[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (47))){
var inst_21244 = (state_21342[(21)]);
var inst_21247 = (state_21342[(2)]);
var inst_21248 = fluree.db.util.async.throw_err.call(null,inst_21247);
var inst_21249 = [inst_21248,r];
var inst_21250 = (new cljs.core.PersistentVector(null,2,(5),inst_21244,inst_21249,null));
var state_21342__$1 = state_21342;
var statearr_21407_21501 = state_21342__$1;
(statearr_21407_21501[(2)] = inst_21250);

(statearr_21407_21501[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (35))){
var inst_21225 = (state_21342[(23)]);
var inst_21224 = cljs.core.count.call(null,clause);
var inst_21225__$1 = cljs.core._EQ_.call(null,(3),inst_21224);
var state_21342__$1 = (function (){var statearr_21408 = state_21342;
(statearr_21408[(23)] = inst_21225__$1);

return statearr_21408;
})();
if(inst_21225__$1){
var statearr_21409_21502 = state_21342__$1;
(statearr_21409_21502[(1)] = (37));

} else {
var statearr_21410_21503 = state_21342__$1;
(statearr_21410_21503[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (19))){
var inst_21145 = (state_21342[(10)]);
var inst_21170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21171 = [inst_21145,r];
var inst_21172 = (new cljs.core.PersistentVector(null,2,(5),inst_21170,inst_21171,null));
var state_21342__$1 = state_21342;
var statearr_21411_21504 = state_21342__$1;
(statearr_21411_21504[(2)] = inst_21172);

(statearr_21411_21504[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (57))){
var inst_21287 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_21342__$1 = state_21342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(60),inst_21287);
} else {
if((state_val_21343 === (68))){
var inst_21291 = (state_21342[(7)]);
var inst_21292 = (state_21342[(8)]);
var inst_21309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21310 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_21291,res,inst_21292,fuel,max_fuel);
var state_21342__$1 = (function (){var statearr_21412 = state_21342;
(statearr_21412[(24)] = inst_21309);

return statearr_21412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(71),inst_21310);
} else {
if((state_val_21343 === (11))){
var inst_21208 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21414_21505 = state_21342__$1;
(statearr_21414_21505[(2)] = inst_21208);

(statearr_21414_21505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (9))){
var inst_21122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21123 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21124 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21123,res,fuel,max_fuel,opts);
var state_21342__$1 = (function (){var statearr_21415 = state_21342;
(statearr_21415[(22)] = inst_21122);

return statearr_21415;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(12),inst_21124);
} else {
if((state_val_21343 === (5))){
var _ = (function (){var statearr_21416 = state_21342;
(statearr_21416[(4)] = cljs.core.rest.call(null,(state_21342[(4)])));

return statearr_21416;
})();
var state_21342__$1 = state_21342;
var ex21413 = (state_21342__$1[(2)]);
var statearr_21417_21506 = state_21342__$1;
(statearr_21417_21506[(5)] = ex21413);


if((ex21413 instanceof Error)){
var statearr_21418_21507 = state_21342__$1;
(statearr_21418_21507[(1)] = (4));

(statearr_21418_21507[(5)] = null);

} else {
throw ex21413;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (14))){
var inst_21115 = (state_21342[(13)]);
var inst_21119 = (state_21342[(14)]);
var inst_21178 = inst_21119.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21115);
var state_21342__$1 = state_21342;
if(cljs.core.truth_(inst_21178)){
var statearr_21419_21508 = state_21342__$1;
(statearr_21419_21508[(1)] = (25));

} else {
var statearr_21420_21509 = state_21342__$1;
(statearr_21420_21509[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (45))){
var inst_21252 = cljs.core.count.call(null,clause);
var inst_21253 = cljs.core._EQ_.call(null,(2),inst_21252);
var state_21342__$1 = state_21342;
if(inst_21253){
var statearr_21421_21510 = state_21342__$1;
(statearr_21421_21510[(1)] = (48));

} else {
var statearr_21422_21511 = state_21342__$1;
(statearr_21422_21511[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (53))){
var inst_21327 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21423_21512 = state_21342__$1;
(statearr_21423_21512[(2)] = inst_21327);

(statearr_21423_21512[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (26))){
var inst_21115 = (state_21342[(13)]);
var inst_21119 = (state_21342[(14)]);
var inst_21190 = inst_21119.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21115);
var state_21342__$1 = state_21342;
if(cljs.core.truth_(inst_21190)){
var statearr_21424_21513 = state_21342__$1;
(statearr_21424_21513[(1)] = (28));

} else {
var statearr_21425_21514 = state_21342__$1;
(statearr_21425_21514[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (16))){
var inst_21151 = (state_21342[(15)]);
var inst_21144 = (state_21342[(17)]);
var inst_21150 = cljs.core.seq.call(null,inst_21144);
var inst_21151__$1 = cljs.core.first.call(null,inst_21150);
var inst_21152 = cljs.core.next.call(null,inst_21150);
var state_21342__$1 = (function (){var statearr_21426 = state_21342;
(statearr_21426[(15)] = inst_21151__$1);

(statearr_21426[(18)] = inst_21152);

return statearr_21426;
})();
if(cljs.core.truth_(inst_21151__$1)){
var statearr_21427_21515 = state_21342__$1;
(statearr_21427_21515[(1)] = (18));

} else {
var statearr_21428_21516 = state_21342__$1;
(statearr_21428_21516[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (38))){
var inst_21225 = (state_21342[(23)]);
var state_21342__$1 = state_21342;
var statearr_21429_21517 = state_21342__$1;
(statearr_21429_21517[(2)] = inst_21225);

(statearr_21429_21517[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (30))){
var inst_21202 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21430_21518 = state_21342__$1;
(statearr_21430_21518[(2)] = inst_21202);

(statearr_21430_21518[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (10))){
var inst_21115 = (state_21342[(13)]);
var inst_21119 = (state_21342[(14)]);
var inst_21131 = inst_21119.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21115);
var state_21342__$1 = state_21342;
if(cljs.core.truth_(inst_21131)){
var statearr_21431_21519 = state_21342__$1;
(statearr_21431_21519[(1)] = (13));

} else {
var statearr_21432_21520 = state_21342__$1;
(statearr_21432_21520[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (18))){
var inst_21151 = (state_21342[(15)]);
var inst_21154 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21151,q_map,vars,fuel,max_fuel,opts);
var state_21342__$1 = state_21342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21342__$1,(21),inst_21154);
} else {
if((state_val_21343 === (52))){
var state_21342__$1 = state_21342;
var statearr_21433_21521 = state_21342__$1;
(statearr_21433_21521[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (67))){
var inst_21320 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21435_21522 = state_21342__$1;
(statearr_21435_21522[(2)] = inst_21320);

(statearr_21435_21522[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (71))){
var inst_21309 = (state_21342[(24)]);
var inst_21312 = (state_21342[(2)]);
var inst_21313 = fluree.db.util.async.throw_err.call(null,inst_21312);
var inst_21314 = [inst_21313,r];
var inst_21315 = (new cljs.core.PersistentVector(null,2,(5),inst_21309,inst_21314,null));
var state_21342__$1 = state_21342;
var statearr_21436_21523 = state_21342__$1;
(statearr_21436_21523[(2)] = inst_21315);

(statearr_21436_21523[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (42))){
var inst_21333 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21437_21524 = state_21342__$1;
(statearr_21437_21524[(2)] = inst_21333);

(statearr_21437_21524[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (37))){
var inst_21227 = cljs.core.second.call(null,clause);
var inst_21228 = cljs.core._EQ_.call(null,inst_21227,"rdf:type");
var state_21342__$1 = state_21342;
var statearr_21438_21525 = state_21342__$1;
(statearr_21438_21525[(2)] = inst_21228);

(statearr_21438_21525[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (63))){
var inst_21322 = (state_21342[(2)]);
var state_21342__$1 = state_21342;
var statearr_21439_21526 = state_21342__$1;
(statearr_21439_21526[(2)] = inst_21322);

(statearr_21439_21526[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (8))){
var inst_21337 = (state_21342[(2)]);
var _ = (function (){var statearr_21440 = state_21342;
(statearr_21440[(4)] = cljs.core.rest.call(null,(state_21342[(4)])));

return statearr_21440;
})();
var state_21342__$1 = state_21342;
var statearr_21441_21527 = state_21342__$1;
(statearr_21441_21527[(2)] = inst_21337);

(statearr_21441_21527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21343 === (49))){
var inst_21261 = cljs.core.count.call(null,clause);
var inst_21262 = cljs.core._EQ_.call(null,(1),inst_21261);
var state_21342__$1 = state_21342;
if(inst_21262){
var statearr_21442_21528 = state_21342__$1;
(statearr_21442_21528[(1)] = (51));

} else {
var statearr_21443_21529 = state_21342__$1;
(statearr_21443_21529[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21444[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_21444[(1)] = (1));

return statearr_21444;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21342){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21342);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21445){var ex__2749__auto__ = e21445;
var statearr_21446_21530 = state_21342;
(statearr_21446_21530[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21342[(4)]))){
var statearr_21447_21531 = state_21342;
(statearr_21447_21531[(1)] = cljs.core.first.call(null,(state_21342[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21532 = state_21342;
state_21342 = G__21532;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_21342){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21448 = f__2769__auto__.call(null);
(statearr_21448[(6)] = c__2768__auto__);

return statearr_21448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21534 = arguments.length;
switch (G__21534) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21614){
var state_val_21615 = (state_21614[(1)]);
if((state_val_21615 === (7))){
var inst_21609 = (state_21614[(2)]);
var _ = (function (){var statearr_21616 = state_21614;
(statearr_21616[(4)] = cljs.core.rest.call(null,(state_21614[(4)])));

return statearr_21616;
})();
var state_21614__$1 = state_21614;
var statearr_21617_21665 = state_21614__$1;
(statearr_21617_21665[(2)] = inst_21609);

(statearr_21617_21665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (20))){
var inst_21574 = (state_21614[(7)]);
var inst_21586 = (state_21614[(2)]);
var inst_21556 = inst_21574;
var inst_21557 = inst_21586;
var state_21614__$1 = (function (){var statearr_21618 = state_21614;
(statearr_21618[(8)] = inst_21556);

(statearr_21618[(9)] = inst_21557);

return statearr_21618;
})();
var statearr_21619_21666 = state_21614__$1;
(statearr_21619_21666[(2)] = null);

(statearr_21619_21666[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (1))){
var state_21614__$1 = state_21614;
var statearr_21620_21667 = state_21614__$1;
(statearr_21620_21667[(2)] = null);

(statearr_21620_21667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (24))){
var inst_21574 = (state_21614[(7)]);
var inst_21573 = (state_21614[(10)]);
var inst_21557 = (state_21614[(9)]);
var inst_21594 = fluree.db.query.analytical.inner_join.call(null,inst_21557,inst_21573);
var inst_21556 = inst_21574;
var inst_21557__$1 = inst_21594;
var state_21614__$1 = (function (){var statearr_21621 = state_21614;
(statearr_21621[(8)] = inst_21556);

(statearr_21621[(9)] = inst_21557__$1);

return statearr_21621;
})();
var statearr_21622_21668 = state_21614__$1;
(statearr_21622_21668[(2)] = null);

(statearr_21622_21668[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (4))){
var inst_21535 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
var statearr_21624_21669 = state_21614__$1;
(statearr_21624_21669[(2)] = inst_21535);

(statearr_21624_21669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (15))){
var inst_21573 = (state_21614[(10)]);
var state_21614__$1 = state_21614;
if(cljs.core.truth_(inst_21573)){
var statearr_21625_21670 = state_21614__$1;
(statearr_21625_21670[(1)] = (18));

} else {
var statearr_21626_21671 = state_21614__$1;
(statearr_21626_21671[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (21))){
var inst_21574 = (state_21614[(7)]);
var inst_21557 = (state_21614[(9)]);
var tmp21623 = inst_21557;
var inst_21556 = inst_21574;
var inst_21557__$1 = tmp21623;
var state_21614__$1 = (function (){var statearr_21627 = state_21614;
(statearr_21627[(8)] = inst_21556);

(statearr_21627[(9)] = inst_21557__$1);

return statearr_21627;
})();
var statearr_21628_21672 = state_21614__$1;
(statearr_21628_21672[(2)] = null);

(statearr_21628_21672[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (13))){
var inst_21557 = (state_21614[(9)]);
var inst_21580 = cljs.core.dissoc.call(null,inst_21557,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21581 = cljs.core.empty_QMARK_.call(null,inst_21580);
var state_21614__$1 = state_21614;
if(inst_21581){
var statearr_21629_21673 = state_21614__$1;
(statearr_21629_21673[(1)] = (15));

} else {
var statearr_21630_21674 = state_21614__$1;
(statearr_21630_21674[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (22))){
var state_21614__$1 = state_21614;
var statearr_21631_21675 = state_21614__$1;
(statearr_21631_21675[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (6))){
var inst_21556 = (state_21614[(8)]);
var inst_21563 = (state_21614[(11)]);
var inst_21562 = cljs.core.seq.call(null,inst_21556);
var inst_21563__$1 = cljs.core.first.call(null,inst_21562);
var inst_21564 = cljs.core.next.call(null,inst_21562);
var state_21614__$1 = (function (){var statearr_21633 = state_21614;
(statearr_21633[(12)] = inst_21564);

(statearr_21633[(11)] = inst_21563__$1);

return statearr_21633;
})();
if(cljs.core.truth_(inst_21563__$1)){
var statearr_21634_21676 = state_21614__$1;
(statearr_21634_21676[(1)] = (8));

} else {
var statearr_21635_21677 = state_21614__$1;
(statearr_21635_21677[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (25))){
var state_21614__$1 = state_21614;
var statearr_21636_21678 = state_21614__$1;
(statearr_21636_21678[(2)] = null);

(statearr_21636_21678[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (17))){
var inst_21602 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
var statearr_21637_21679 = state_21614__$1;
(statearr_21637_21679[(2)] = inst_21602);

(statearr_21637_21679[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (3))){
var inst_21612 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21614__$1,inst_21612);
} else {
if((state_val_21615 === (12))){
var inst_21574 = (state_21614[(7)]);
var inst_21573 = (state_21614[(10)]);
var inst_21556 = inst_21574;
var inst_21557 = inst_21573;
var state_21614__$1 = (function (){var statearr_21638 = state_21614;
(statearr_21638[(8)] = inst_21556);

(statearr_21638[(9)] = inst_21557);

return statearr_21638;
})();
var statearr_21639_21680 = state_21614__$1;
(statearr_21639_21680[(2)] = null);

(statearr_21639_21680[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (2))){
var _ = (function (){var statearr_21640 = state_21614;
(statearr_21640[(4)] = cljs.core.cons.call(null,(5),(state_21614[(4)])));

return statearr_21640;
})();
var inst_21548 = where;
var inst_21549 = cljs.core.seq.call(null,inst_21548);
var inst_21550 = cljs.core.first.call(null,inst_21549);
var inst_21551 = cljs.core.next.call(null,inst_21549);
var inst_21552 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21553 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_21554 = [inst_21553];
var inst_21555 = cljs.core.PersistentHashMap.fromArrays(inst_21552,inst_21554);
var inst_21556 = inst_21548;
var inst_21557 = inst_21555;
var state_21614__$1 = (function (){var statearr_21641 = state_21614;
(statearr_21641[(13)] = inst_21550);

(statearr_21641[(8)] = inst_21556);

(statearr_21641[(14)] = inst_21551);

(statearr_21641[(9)] = inst_21557);

return statearr_21641;
})();
var statearr_21642_21681 = state_21614__$1;
(statearr_21642_21681[(2)] = null);

(statearr_21642_21681[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (23))){
var inst_21600 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
var statearr_21643_21682 = state_21614__$1;
(statearr_21643_21682[(2)] = inst_21600);

(statearr_21643_21682[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (19))){
var inst_21557 = (state_21614[(9)]);
var state_21614__$1 = state_21614;
var statearr_21644_21683 = state_21614__$1;
(statearr_21644_21683[(2)] = inst_21557);

(statearr_21644_21683[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (11))){
var inst_21563 = (state_21614[(11)]);
var inst_21571 = (state_21614[(2)]);
var inst_21572 = fluree.db.util.async.throw_err.call(null,inst_21571);
var inst_21573 = cljs.core.nth.call(null,inst_21572,(0),null);
var inst_21574 = cljs.core.nth.call(null,inst_21572,(1),null);
var inst_21575 = cljs.core.count.call(null,inst_21563);
var inst_21576 = cljs.core._EQ_.call(null,(2),inst_21575);
var state_21614__$1 = (function (){var statearr_21646 = state_21614;
(statearr_21646[(7)] = inst_21574);

(statearr_21646[(10)] = inst_21573);

return statearr_21646;
})();
if(inst_21576){
var statearr_21647_21684 = state_21614__$1;
(statearr_21647_21684[(1)] = (12));

} else {
var statearr_21648_21685 = state_21614__$1;
(statearr_21648_21685[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (9))){
var inst_21557 = (state_21614[(9)]);
var state_21614__$1 = state_21614;
var statearr_21649_21686 = state_21614__$1;
(statearr_21649_21686[(2)] = inst_21557);

(statearr_21649_21686[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (5))){
var _ = (function (){var statearr_21650 = state_21614;
(statearr_21650[(4)] = cljs.core.rest.call(null,(state_21614[(4)])));

return statearr_21650;
})();
var state_21614__$1 = state_21614;
var ex21645 = (state_21614__$1[(2)]);
var statearr_21651_21687 = state_21614__$1;
(statearr_21651_21687[(5)] = ex21645);


if((ex21645 instanceof Error)){
var statearr_21652_21688 = state_21614__$1;
(statearr_21652_21688[(1)] = (4));

(statearr_21652_21688[(5)] = null);

} else {
throw ex21645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (14))){
var inst_21604 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
var statearr_21653_21689 = state_21614__$1;
(statearr_21653_21689[(2)] = inst_21604);

(statearr_21653_21689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (26))){
var inst_21598 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
var statearr_21654_21690 = state_21614__$1;
(statearr_21654_21690[(2)] = inst_21598);

(statearr_21654_21690[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (16))){
var inst_21573 = (state_21614[(10)]);
var inst_21589 = (inst_21573 == null);
var state_21614__$1 = state_21614;
if(cljs.core.truth_(inst_21589)){
var statearr_21655_21691 = state_21614__$1;
(statearr_21655_21691[(1)] = (21));

} else {
var statearr_21656_21692 = state_21614__$1;
(statearr_21656_21692[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (10))){
var inst_21607 = (state_21614[(2)]);
var state_21614__$1 = state_21614;
var statearr_21657_21693 = state_21614__$1;
(statearr_21657_21693[(2)] = inst_21607);

(statearr_21657_21693[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (18))){
var inst_21573 = (state_21614[(10)]);
var state_21614__$1 = state_21614;
var statearr_21658_21694 = state_21614__$1;
(statearr_21658_21694[(2)] = inst_21573);

(statearr_21658_21694[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21615 === (8))){
var inst_21564 = (state_21614[(12)]);
var inst_21557 = (state_21614[(9)]);
var inst_21563 = (state_21614[(11)]);
var inst_21569 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21557,inst_21563,inst_21564,false,fuel,max_fuel,opts);
var state_21614__$1 = state_21614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21614__$1,(11),inst_21569);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_21659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21659[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_21659[(1)] = (1));

return statearr_21659;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_21614){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21660){var ex__2749__auto__ = e21660;
var statearr_21661_21695 = state_21614;
(statearr_21661_21695[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21614[(4)]))){
var statearr_21662_21696 = state_21614;
(statearr_21662_21696[(1)] = cljs.core.first.call(null,(state_21614[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21697 = state_21614;
state_21614 = G__21697;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_21614){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_21614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21663 = f__2769__auto__.call(null);
(statearr_21663[(6)] = c__2768__auto__);

return statearr_21663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21732){
var state_val_21733 = (state_21732[(1)]);
if((state_val_21733 === (7))){
var inst_21714 = (state_21732[(7)]);
var inst_21709 = (state_21732[(8)]);
var inst_21716 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21709,inst_21714,fuel,max_fuel,opts);
var state_21732__$1 = state_21732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21732__$1,(10),inst_21716);
} else {
if((state_val_21733 === (1))){
var state_21732__$1 = state_21732;
var statearr_21734_21759 = state_21732__$1;
(statearr_21734_21759[(2)] = null);

(statearr_21734_21759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (4))){
var inst_21698 = (state_21732[(2)]);
var state_21732__$1 = state_21732;
var statearr_21735_21760 = state_21732__$1;
(statearr_21735_21760[(2)] = inst_21698);

(statearr_21735_21760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (13))){
var inst_21727 = (state_21732[(2)]);
var _ = (function (){var statearr_21736 = state_21732;
(statearr_21736[(4)] = cljs.core.rest.call(null,(state_21732[(4)])));

return statearr_21736;
})();
var state_21732__$1 = state_21732;
var statearr_21737_21761 = state_21732__$1;
(statearr_21737_21761[(2)] = inst_21727);

(statearr_21737_21761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (6))){
var inst_21709 = (state_21732[(8)]);
var inst_21713 = (state_21732[(2)]);
var inst_21714 = fluree.db.util.async.throw_err.call(null,inst_21713);
var state_21732__$1 = (function (){var statearr_21738 = state_21732;
(statearr_21738[(7)] = inst_21714);

return statearr_21738;
})();
if(cljs.core.truth_(inst_21709)){
var statearr_21739_21762 = state_21732__$1;
(statearr_21739_21762[(1)] = (7));

} else {
var statearr_21740_21763 = state_21732__$1;
(statearr_21740_21763[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (3))){
var inst_21730 = (state_21732[(2)]);
var state_21732__$1 = state_21732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21732__$1,inst_21730);
} else {
if((state_val_21733 === (12))){
var inst_21722 = (state_21732[(9)]);
var state_21732__$1 = state_21732;
var statearr_21741_21764 = state_21732__$1;
(statearr_21741_21764[(2)] = inst_21722);

(statearr_21741_21764[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (2))){
var _ = (function (){var statearr_21742 = state_21732;
(statearr_21742[(4)] = cljs.core.cons.call(null,(5),(state_21732[(4)])));

return statearr_21742;
})();
var inst_21705 = q_map;
var inst_21706 = cljs.core.__destructure_map.call(null,inst_21705);
var inst_21707 = cljs.core.get.call(null,inst_21706,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21708 = cljs.core.get.call(null,inst_21706,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21709 = cljs.core.get.call(null,inst_21706,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21710 = cljs.core.get.call(null,inst_21706,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21711 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21708,q_map,inst_21707,fuel,max_fuel,opts);
var state_21732__$1 = (function (){var statearr_21743 = state_21732;
(statearr_21743[(10)] = inst_21710);

(statearr_21743[(8)] = inst_21709);

return statearr_21743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21732__$1,(6),inst_21711);
} else {
if((state_val_21733 === (11))){
var inst_21722 = (state_21732[(9)]);
var inst_21710 = (state_21732[(10)]);
var inst_21724 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_21722,inst_21710,null);
var state_21732__$1 = state_21732;
var statearr_21745_21765 = state_21732__$1;
(statearr_21745_21765[(2)] = inst_21724);

(statearr_21745_21765[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (9))){
var inst_21710 = (state_21732[(10)]);
var inst_21722 = (state_21732[(2)]);
var state_21732__$1 = (function (){var statearr_21746 = state_21732;
(statearr_21746[(9)] = inst_21722);

return statearr_21746;
})();
if(cljs.core.truth_(inst_21710)){
var statearr_21747_21766 = state_21732__$1;
(statearr_21747_21766[(1)] = (11));

} else {
var statearr_21748_21767 = state_21732__$1;
(statearr_21748_21767[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (5))){
var _ = (function (){var statearr_21749 = state_21732;
(statearr_21749[(4)] = cljs.core.rest.call(null,(state_21732[(4)])));

return statearr_21749;
})();
var state_21732__$1 = state_21732;
var ex21744 = (state_21732__$1[(2)]);
var statearr_21750_21768 = state_21732__$1;
(statearr_21750_21768[(5)] = ex21744);


if((ex21744 instanceof Error)){
var statearr_21751_21769 = state_21732__$1;
(statearr_21751_21769[(1)] = (4));

(statearr_21751_21769[(5)] = null);

} else {
throw ex21744;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (10))){
var inst_21718 = (state_21732[(2)]);
var inst_21719 = fluree.db.util.async.throw_err.call(null,inst_21718);
var state_21732__$1 = state_21732;
var statearr_21752_21770 = state_21732__$1;
(statearr_21752_21770[(2)] = inst_21719);

(statearr_21752_21770[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21733 === (8))){
var inst_21714 = (state_21732[(7)]);
var state_21732__$1 = state_21732;
var statearr_21753_21771 = state_21732__$1;
(statearr_21753_21771[(2)] = inst_21714);

(statearr_21753_21771[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_21754 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21754[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_21754[(1)] = (1));

return statearr_21754;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_21732){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21755){var ex__2749__auto__ = e21755;
var statearr_21756_21772 = state_21732;
(statearr_21756_21772[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21732[(4)]))){
var statearr_21757_21773 = state_21732;
(statearr_21757_21773[(1)] = cljs.core.first.call(null,(state_21732[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21774 = state_21732;
state_21732 = G__21774;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_21732){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_21732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21758 = f__2769__auto__.call(null);
(statearr_21758[(6)] = c__2768__auto__);

return statearr_21758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
