// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25507 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__25507,(0),null);
var network = cljs.core.nth.call(null,vec__25507,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__25507,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25510){
var map__25511 = p__25510;
var map__25511__$1 = cljs.core.__destructure_map.call(null,map__25511);
var opts = map__25511__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__25511__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25571){
var state_val_25572 = (state_25571[(1)]);
if((state_val_25572 === (7))){
var inst_25542 = cljs.core.not.call(null,reindex_QMARK_);
var state_25571__$1 = state_25571;
var statearr_25573_25597 = state_25571__$1;
(statearr_25573_25597[(2)] = inst_25542);

(statearr_25573_25597[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (1))){
var state_25571__$1 = state_25571;
var statearr_25574_25598 = state_25571__$1;
(statearr_25574_25598[(2)] = null);

(statearr_25574_25598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (4))){
var inst_25512 = (state_25571[(2)]);
var state_25571__$1 = state_25571;
var statearr_25575_25599 = state_25571__$1;
(statearr_25575_25599[(2)] = inst_25512);

(statearr_25575_25599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (6))){
var inst_25532 = (state_25571[(7)]);
var inst_25540 = (state_25571[(8)]);
var inst_25526 = (state_25571[(9)]);
var inst_25525 = (state_25571[(2)]);
var inst_25526__$1 = fluree.db.util.async.throw_err.call(null,inst_25525);
var inst_25527 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25528 = cljs.core.__destructure_map.call(null,inst_25527);
var inst_25529 = cljs.core.get.call(null,inst_25528,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25530 = cljs.core.get.call(null,inst_25528,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25531 = fluree.db.flake.size_bytes.call(null,inst_25526__$1);
var inst_25532__$1 = (inst_25530 + inst_25531);
var inst_25533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25534 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25535 = (new cljs.core.PersistentVector(null,2,(5),inst_25533,inst_25534,null));
var inst_25536 = cljs.core.get_in.call(null,db,inst_25535);
var inst_25537 = cljs.core.__destructure_map.call(null,inst_25536);
var inst_25538 = cljs.core.get.call(null,inst_25537,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25539 = cljs.core.get.call(null,inst_25537,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25540__$1 = (inst_25532__$1 > inst_25539);
var state_25571__$1 = (function (){var statearr_25576 = state_25571;
(statearr_25576[(7)] = inst_25532__$1);

(statearr_25576[(10)] = inst_25538);

(statearr_25576[(8)] = inst_25540__$1);

(statearr_25576[(9)] = inst_25526__$1);

(statearr_25576[(11)] = inst_25529);

return statearr_25576;
})();
if(cljs.core.truth_(inst_25540__$1)){
var statearr_25577_25600 = state_25571__$1;
(statearr_25577_25600[(1)] = (7));

} else {
var statearr_25578_25601 = state_25571__$1;
(statearr_25578_25601[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (3))){
var inst_25569 = (state_25571[(2)]);
var state_25571__$1 = state_25571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25571__$1,inst_25569);
} else {
if((state_val_25572 === (12))){
var inst_25532 = (state_25571[(7)]);
var inst_25526 = (state_25571[(9)]);
var inst_25529 = (state_25571[(11)]);
var inst_25555 = (state_25571[(2)]);
var inst_25556 = cljs.core.into.call(null,inst_25529,inst_25526);
var inst_25557 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25558 = cljs.core.swap_BANG_.call(null,inst_25557,cljs.core.empty);
var inst_25559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25560 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25561 = (new cljs.core.PersistentVector(null,2,(5),inst_25559,inst_25560,null));
var inst_25562 = cljs.core.assoc_in.call(null,db,inst_25561,inst_25556);
var inst_25563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25564 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25565 = (new cljs.core.PersistentVector(null,2,(5),inst_25563,inst_25564,null));
var inst_25566 = cljs.core.assoc_in.call(null,inst_25562,inst_25565,inst_25532);
var _ = (function (){var statearr_25579 = state_25571;
(statearr_25579[(4)] = cljs.core.rest.call(null,(state_25571[(4)])));

return statearr_25579;
})();
var state_25571__$1 = (function (){var statearr_25580 = state_25571;
(statearr_25580[(12)] = inst_25555);

(statearr_25580[(13)] = inst_25558);

return statearr_25580;
})();
var statearr_25581_25602 = state_25571__$1;
(statearr_25581_25602[(2)] = inst_25566);

(statearr_25581_25602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (2))){
var _ = (function (){var statearr_25582 = state_25571;
(statearr_25582[(4)] = cljs.core.cons.call(null,(5),(state_25571[(4)])));

return statearr_25582;
})();
var inst_25520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25521 = [pred_id];
var inst_25522 = (new cljs.core.PersistentVector(null,1,(5),inst_25520,inst_25521,null));
var inst_25523 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25522);
var state_25571__$1 = state_25571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25571__$1,(6),inst_25523);
} else {
if((state_val_25572 === (11))){
var state_25571__$1 = state_25571;
var statearr_25584_25603 = state_25571__$1;
(statearr_25584_25603[(2)] = null);

(statearr_25584_25603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (9))){
var inst_25545 = (state_25571[(2)]);
var state_25571__$1 = state_25571;
if(cljs.core.truth_(inst_25545)){
var statearr_25585_25604 = state_25571__$1;
(statearr_25585_25604[(1)] = (10));

} else {
var statearr_25586_25605 = state_25571__$1;
(statearr_25586_25605[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (5))){
var _ = (function (){var statearr_25587 = state_25571;
(statearr_25587[(4)] = cljs.core.rest.call(null,(state_25571[(4)])));

return statearr_25587;
})();
var state_25571__$1 = state_25571;
var ex25583 = (state_25571__$1[(2)]);
var statearr_25588_25606 = state_25571__$1;
(statearr_25588_25606[(5)] = ex25583);


if((ex25583 instanceof Error)){
var statearr_25589_25607 = state_25571__$1;
(statearr_25589_25607[(1)] = (4));

(statearr_25589_25607[(5)] = null);

} else {
throw ex25583;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (10))){
var inst_25547 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25548 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25549 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25550 = cljs.core.PersistentHashMap.fromArrays(inst_25548,inst_25549);
var inst_25551 = cljs.core.ex_info.call(null,inst_25547,inst_25550);
var inst_25552 = (function(){throw inst_25551})();
var state_25571__$1 = state_25571;
var statearr_25590_25608 = state_25571__$1;
(statearr_25590_25608[(2)] = inst_25552);

(statearr_25590_25608[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25572 === (8))){
var inst_25540 = (state_25571[(8)]);
var state_25571__$1 = state_25571;
var statearr_25591_25609 = state_25571__$1;
(statearr_25591_25609[(2)] = inst_25540);

(statearr_25591_25609[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_25592 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25592[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_25592[(1)] = (1));

return statearr_25592;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_25571){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25593){var ex__2749__auto__ = e25593;
var statearr_25594_25610 = state_25571;
(statearr_25594_25610[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25571[(4)]))){
var statearr_25595_25611 = state_25571;
(statearr_25595_25611[(1)] = cljs.core.first.call(null,(state_25571[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25612 = state_25571;
state_25571 = G__25612;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_25571){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_25571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25596 = f__2769__auto__.call(null);
(statearr_25596[(6)] = c__2768__auto__);

return statearr_25596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25615 = arguments.length;
switch (G__25615) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25815){
var state_val_25816 = (state_25815[(1)]);
if((state_val_25816 === (7))){
var state_25815__$1 = state_25815;
var statearr_25817_25884 = state_25815__$1;
(statearr_25817_25884[(2)] = null);

(statearr_25817_25884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (20))){
var inst_25736 = (state_25815[(7)]);
var inst_25740 = (state_25815[(8)]);
var inst_25735 = (state_25815[(9)]);
var inst_25651 = (state_25815[(10)]);
var inst_25652 = (state_25815[(11)]);
var inst_25702 = (state_25815[(12)]);
var inst_25737 = (state_25815[(13)]);
var inst_25738 = (state_25815[(14)]);
var inst_25739 = (state_25815[(15)]);
var inst_25750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25751 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25752 = (new cljs.core.PersistentVector(null,2,(5),inst_25750,inst_25751,null));
var inst_25753 = cljs.core.get_in.call(null,inst_25702,inst_25752);
var inst_25754 = (inst_25753 + inst_25651);
var inst_25755 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25756 = [inst_25735,inst_25736,inst_25737,inst_25738,inst_25739,inst_25754];
var inst_25757 = cljs.core.PersistentHashMap.fromArrays(inst_25755,inst_25756);
var inst_25758 = cljs.core.assoc.call(null,inst_25702,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25740,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25757);
var state_25815__$1 = (function (){var statearr_25818 = state_25815;
(statearr_25818[(16)] = inst_25758);

return statearr_25818;
})();
if(cljs.core.truth_(inst_25652)){
var statearr_25819_25885 = state_25815__$1;
(statearr_25819_25885[(1)] = (23));

} else {
var statearr_25820_25886 = state_25815__$1;
(statearr_25820_25886[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (27))){
var inst_25758 = (state_25815[(16)]);
var state_25815__$1 = state_25815;
var statearr_25821_25887 = state_25815__$1;
(statearr_25821_25887[(2)] = inst_25758);

(statearr_25821_25887[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (1))){
var state_25815__$1 = state_25815;
var statearr_25822_25888 = state_25815__$1;
(statearr_25822_25888[(2)] = null);

(statearr_25822_25888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (24))){
var inst_25758 = (state_25815[(16)]);
var inst_25762 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25758);
var inst_25763 = (inst_25762 == null);
var state_25815__$1 = state_25815;
var statearr_25823_25889 = state_25815__$1;
(statearr_25823_25889[(2)] = inst_25763);

(statearr_25823_25889[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (39))){
var inst_25797 = (state_25815[(17)]);
var inst_25747 = (state_25815[(18)]);
var inst_25788 = (state_25815[(19)]);
var inst_25789 = (state_25815[(20)]);
var inst_25790 = (state_25815[(21)]);
var inst_25739 = (state_25815[(15)]);
var inst_25746 = (state_25815[(22)]);
var inst_25804 = (state_25815[(2)]);
var inst_25805 = cljs.core.conj.call(null,inst_25739,inst_25746);
var inst_25734 = inst_25747;
var inst_25735 = inst_25789;
var inst_25736 = inst_25790;
var inst_25737 = inst_25797;
var inst_25738 = inst_25804;
var inst_25739__$1 = inst_25805;
var inst_25740 = inst_25788;
var state_25815__$1 = (function (){var statearr_25824 = state_25815;
(statearr_25824[(7)] = inst_25736);

(statearr_25824[(8)] = inst_25740);

(statearr_25824[(9)] = inst_25735);

(statearr_25824[(23)] = inst_25734);

(statearr_25824[(13)] = inst_25737);

(statearr_25824[(14)] = inst_25738);

(statearr_25824[(15)] = inst_25739__$1);

return statearr_25824;
})();
var statearr_25825_25890 = state_25815__$1;
(statearr_25825_25890[(2)] = null);

(statearr_25825_25890[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (4))){
var inst_25616 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
var statearr_25826_25891 = state_25815__$1;
(statearr_25826_25891[(2)] = inst_25616);

(statearr_25826_25891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (15))){
var inst_25674 = (state_25815[(24)]);
var state_25815__$1 = state_25815;
var statearr_25827_25892 = state_25815__$1;
(statearr_25827_25892[(2)] = inst_25674);

(statearr_25827_25892[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (21))){
var inst_25650 = (state_25815[(25)]);
var inst_25736 = (state_25815[(7)]);
var inst_25740 = (state_25815[(8)]);
var inst_25653 = (state_25815[(26)]);
var inst_25747 = (state_25815[(18)]);
var inst_25711 = (state_25815[(27)]);
var inst_25735 = (state_25815[(9)]);
var inst_25712 = (state_25815[(28)]);
var inst_25651 = (state_25815[(10)]);
var inst_25734 = (state_25815[(23)]);
var inst_25639 = (state_25815[(29)]);
var inst_25652 = (state_25815[(11)]);
var inst_25661 = (state_25815[(30)]);
var inst_25642 = (state_25815[(31)]);
var inst_25655 = (state_25815[(32)]);
var inst_25646 = (state_25815[(33)]);
var inst_25702 = (state_25815[(12)]);
var inst_25623 = (state_25815[(34)]);
var inst_25737 = (state_25815[(13)]);
var inst_25738 = (state_25815[(14)]);
var inst_25739 = (state_25815[(15)]);
var inst_25746 = (state_25815[(22)]);
var inst_25638 = (state_25815[(35)]);
var inst_25785 = fluree.db.flake.s.call(null,inst_25746);
var inst_25786 = fluree.db.flake.sid__GT_cid.call(null,inst_25785);
var inst_25787 = (function (){var flakes_bytes = inst_25651;
var t = inst_25623;
var seq__25743 = inst_25747;
var spot = inst_25735;
var add_flakes = inst_25639;
var seq__25708 = inst_25712;
var first__25709 = inst_25711;
var root_setting_change_QMARK_ = inst_25653;
var ref_QMARK__map = inst_25650;
var r = inst_25747;
var psot = inst_25736;
var first__25744 = inst_25746;
var add_pred_to_idx_QMARK_ = inst_25661;
var _ = inst_25638;
var tspo = inst_25739;
var cid = inst_25786;
var ecount = inst_25740;
var pred_ecount = inst_25655;
var vec__25707 = inst_25639;
var db_STAR_ = inst_25702;
var system_change_QMARK_ = inst_25652;
var add_preds = inst_25642;
var G__25706 = inst_25734;
var opst = inst_25738;
var vec__25742 = inst_25734;
var idx_QMARK__map = inst_25646;
var post = inst_25737;
var f = inst_25746;
return (function (p1__25613_SHARP_){
if(cljs.core.truth_(p1__25613_SHARP_)){
var x__5130__auto__ = p1__25613_SHARP_;
var y__5131__auto__ = fluree.db.flake.s.call(null,f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_25788 = cljs.core.update.call(null,inst_25740,inst_25786,inst_25787);
var inst_25789 = cljs.core.conj.call(null,inst_25735,inst_25746);
var inst_25790 = cljs.core.conj.call(null,inst_25736,inst_25746);
var inst_25791 = fluree.db.flake.p.call(null,inst_25746);
var inst_25792 = cljs.core.get.call(null,inst_25646,inst_25791);
var state_25815__$1 = (function (){var statearr_25828 = state_25815;
(statearr_25828[(19)] = inst_25788);

(statearr_25828[(20)] = inst_25789);

(statearr_25828[(21)] = inst_25790);

return statearr_25828;
})();
if(cljs.core.truth_(inst_25792)){
var statearr_25829_25893 = state_25815__$1;
(statearr_25829_25893[(1)] = (34));

} else {
var statearr_25830_25894 = state_25815__$1;
(statearr_25830_25894[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (31))){
var inst_25774 = (state_25815[(36)]);
var state_25815__$1 = state_25815;
var statearr_25831_25895 = state_25815__$1;
(statearr_25831_25895[(2)] = inst_25774);

(statearr_25831_25895[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (32))){
var inst_25783 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
var statearr_25832_25896 = state_25815__$1;
(statearr_25832_25896[(2)] = inst_25783);

(statearr_25832_25896[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (33))){
var inst_25774 = (state_25815[(36)]);
var inst_25778 = (state_25815[(2)]);
var inst_25779 = fluree.db.util.async.throw_err.call(null,inst_25778);
var inst_25780 = cljs.core.assoc.call(null,inst_25774,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25779);
var state_25815__$1 = state_25815;
var statearr_25833_25897 = state_25815__$1;
(statearr_25833_25897[(2)] = inst_25780);

(statearr_25833_25897[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (13))){
var inst_25651 = (state_25815[(10)]);
var inst_25639 = (state_25815[(29)]);
var inst_25702 = (state_25815[(12)]);
var inst_25623 = (state_25815[(34)]);
var inst_25692 = (state_25815[(2)]);
var inst_25693 = cljs.core.assoc.call(null,inst_25692,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25623);
var inst_25694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25695 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25696 = (new cljs.core.PersistentVector(null,2,(5),inst_25694,inst_25695,null));
var inst_25697 = cljs.core.update_in.call(null,inst_25693,inst_25696,cljs.core._PLUS_,inst_25651);
var inst_25698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25699 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25700 = (new cljs.core.PersistentVector(null,2,(5),inst_25698,inst_25699,null));
var inst_25701 = cljs.core.count.call(null,inst_25639);
var inst_25702__$1 = cljs.core.update_in.call(null,inst_25697,inst_25700,cljs.core._PLUS_,inst_25701);
var inst_25710 = cljs.core.seq.call(null,inst_25639);
var inst_25711 = cljs.core.first.call(null,inst_25710);
var inst_25712 = cljs.core.next.call(null,inst_25710);
var inst_25713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25714 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25715 = (new cljs.core.PersistentVector(null,2,(5),inst_25713,inst_25714,null));
var inst_25716 = cljs.core.get_in.call(null,inst_25702__$1,inst_25715);
var inst_25717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25718 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25719 = (new cljs.core.PersistentVector(null,2,(5),inst_25717,inst_25718,null));
var inst_25720 = cljs.core.get_in.call(null,inst_25702__$1,inst_25719);
var inst_25721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25722 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25723 = (new cljs.core.PersistentVector(null,2,(5),inst_25721,inst_25722,null));
var inst_25724 = cljs.core.get_in.call(null,inst_25702__$1,inst_25723);
var inst_25725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25726 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25727 = (new cljs.core.PersistentVector(null,2,(5),inst_25725,inst_25726,null));
var inst_25728 = cljs.core.get_in.call(null,inst_25702__$1,inst_25727);
var inst_25729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25730 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25731 = (new cljs.core.PersistentVector(null,2,(5),inst_25729,inst_25730,null));
var inst_25732 = cljs.core.get_in.call(null,inst_25702__$1,inst_25731);
var inst_25733 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25734 = inst_25639;
var inst_25735 = inst_25716;
var inst_25736 = inst_25720;
var inst_25737 = inst_25724;
var inst_25738 = inst_25728;
var inst_25739 = inst_25732;
var inst_25740 = inst_25733;
var state_25815__$1 = (function (){var statearr_25834 = state_25815;
(statearr_25834[(7)] = inst_25736);

(statearr_25834[(8)] = inst_25740);

(statearr_25834[(27)] = inst_25711);

(statearr_25834[(9)] = inst_25735);

(statearr_25834[(28)] = inst_25712);

(statearr_25834[(23)] = inst_25734);

(statearr_25834[(12)] = inst_25702__$1);

(statearr_25834[(13)] = inst_25737);

(statearr_25834[(14)] = inst_25738);

(statearr_25834[(15)] = inst_25739);

return statearr_25834;
})();
var statearr_25835_25898 = state_25815__$1;
(statearr_25835_25898[(2)] = null);

(statearr_25835_25898[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (22))){
var inst_25808 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
var statearr_25836_25899 = state_25815__$1;
(statearr_25836_25899[(2)] = inst_25808);

(statearr_25836_25899[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (36))){
var inst_25650 = (state_25815[(25)]);
var inst_25746 = (state_25815[(22)]);
var inst_25797 = (state_25815[(2)]);
var inst_25798 = fluree.db.flake.p.call(null,inst_25746);
var inst_25799 = cljs.core.get.call(null,inst_25650,inst_25798);
var state_25815__$1 = (function (){var statearr_25837 = state_25815;
(statearr_25837[(17)] = inst_25797);

return statearr_25837;
})();
if(cljs.core.truth_(inst_25799)){
var statearr_25838_25900 = state_25815__$1;
(statearr_25838_25900[(1)] = (37));

} else {
var statearr_25839_25901 = state_25815__$1;
(statearr_25839_25901[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (29))){
var inst_25758 = (state_25815[(16)]);
var inst_25769 = (state_25815[(2)]);
var inst_25770 = fluree.db.util.async.throw_err.call(null,inst_25769);
var inst_25771 = cljs.core.assoc.call(null,inst_25758,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25770);
var state_25815__$1 = state_25815;
var statearr_25840_25902 = state_25815__$1;
(statearr_25840_25902[(2)] = inst_25771);

(statearr_25840_25902[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (6))){
var inst_25623 = (state_25815[(34)]);
var inst_25628 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25629 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25630 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25628)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25629)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25623),"."].join('');
var inst_25631 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25632 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25633 = cljs.core.PersistentHashMap.fromArrays(inst_25631,inst_25632);
var inst_25634 = cljs.core.ex_info.call(null,inst_25630,inst_25633);
var inst_25635 = (function(){throw inst_25634})();
var state_25815__$1 = state_25815;
var statearr_25841_25903 = state_25815__$1;
(statearr_25841_25903[(2)] = inst_25635);

(statearr_25841_25903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (28))){
var inst_25653 = (state_25815[(26)]);
var inst_25774 = (state_25815[(2)]);
var state_25815__$1 = (function (){var statearr_25842 = state_25815;
(statearr_25842[(36)] = inst_25774);

return statearr_25842;
})();
if(cljs.core.truth_(inst_25653)){
var statearr_25843_25904 = state_25815__$1;
(statearr_25843_25904[(1)] = (30));

} else {
var statearr_25844_25905 = state_25815__$1;
(statearr_25844_25905[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (25))){
var inst_25765 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
if(cljs.core.truth_(inst_25765)){
var statearr_25845_25906 = state_25815__$1;
(statearr_25845_25906[(1)] = (26));

} else {
var statearr_25846_25907 = state_25815__$1;
(statearr_25846_25907[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (34))){
var inst_25737 = (state_25815[(13)]);
var inst_25746 = (state_25815[(22)]);
var inst_25794 = cljs.core.conj.call(null,inst_25737,inst_25746);
var state_25815__$1 = state_25815;
var statearr_25847_25908 = state_25815__$1;
(statearr_25847_25908[(2)] = inst_25794);

(statearr_25847_25908[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (17))){
var inst_25681 = (state_25815[(37)]);
var inst_25685 = (state_25815[(2)]);
var inst_25686 = fluree.db.util.async.throw_err.call(null,inst_25685);
var inst_25673 = inst_25681;
var inst_25674 = inst_25686;
var state_25815__$1 = (function (){var statearr_25848 = state_25815;
(statearr_25848[(38)] = inst_25673);

(statearr_25848[(24)] = inst_25674);

return statearr_25848;
})();
var statearr_25849_25909 = state_25815__$1;
(statearr_25849_25909[(2)] = null);

(statearr_25849_25909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (3))){
var inst_25813 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25815__$1,inst_25813);
} else {
if((state_val_25816 === (12))){
var inst_25680 = (state_25815[(39)]);
var inst_25673 = (state_25815[(38)]);
var inst_25679 = cljs.core.seq.call(null,inst_25673);
var inst_25680__$1 = cljs.core.first.call(null,inst_25679);
var inst_25681 = cljs.core.next.call(null,inst_25679);
var state_25815__$1 = (function (){var statearr_25850 = state_25815;
(statearr_25850[(39)] = inst_25680__$1);

(statearr_25850[(37)] = inst_25681);

return statearr_25850;
})();
if(cljs.core.truth_(inst_25680__$1)){
var statearr_25851_25910 = state_25815__$1;
(statearr_25851_25910[(1)] = (14));

} else {
var statearr_25852_25911 = state_25815__$1;
(statearr_25852_25911[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (2))){
var inst_25623 = (state_25815[(34)]);
var _ = (function (){var statearr_25853 = state_25815;
(statearr_25853[(4)] = cljs.core.cons.call(null,(5),(state_25815[(4)])));

return statearr_25853;
})();
var inst_25622 = cljs.core.first.call(null,flakes);
var inst_25623__$1 = fluree.db.flake.t.call(null,inst_25622);
var inst_25624 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25625 = (inst_25624 - (1));
var inst_25626 = cljs.core.not_EQ_.call(null,inst_25623__$1,inst_25625);
var state_25815__$1 = (function (){var statearr_25854 = state_25815;
(statearr_25854[(34)] = inst_25623__$1);

return statearr_25854;
})();
if(inst_25626){
var statearr_25855_25912 = state_25815__$1;
(statearr_25855_25912[(1)] = (6));

} else {
var statearr_25856_25913 = state_25815__$1;
(statearr_25856_25913[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (23))){
var inst_25652 = (state_25815[(11)]);
var state_25815__$1 = state_25815;
var statearr_25857_25914 = state_25815__$1;
(statearr_25857_25914[(2)] = inst_25652);

(statearr_25857_25914[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (35))){
var inst_25737 = (state_25815[(13)]);
var state_25815__$1 = state_25815;
var statearr_25858_25915 = state_25815__$1;
(statearr_25858_25915[(2)] = inst_25737);

(statearr_25858_25915[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (19))){
var inst_25810 = (state_25815[(2)]);
var _ = (function (){var statearr_25859 = state_25815;
(statearr_25859[(4)] = cljs.core.rest.call(null,(state_25815[(4)])));

return statearr_25859;
})();
var state_25815__$1 = state_25815;
var statearr_25860_25916 = state_25815__$1;
(statearr_25860_25916[(2)] = inst_25810);

(statearr_25860_25916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (11))){
var inst_25661 = (state_25815[(30)]);
var inst_25661__$1 = (state_25815[(2)]);
var inst_25669 = cljs.core.seq.call(null,inst_25661__$1);
var inst_25670 = cljs.core.first.call(null,inst_25669);
var inst_25671 = cljs.core.next.call(null,inst_25669);
var inst_25672 = db;
var inst_25673 = inst_25661__$1;
var inst_25674 = inst_25672;
var state_25815__$1 = (function (){var statearr_25862 = state_25815;
(statearr_25862[(38)] = inst_25673);

(statearr_25862[(24)] = inst_25674);

(statearr_25862[(30)] = inst_25661__$1);

(statearr_25862[(40)] = inst_25671);

(statearr_25862[(41)] = inst_25670);

return statearr_25862;
})();
var statearr_25863_25917 = state_25815__$1;
(statearr_25863_25917[(2)] = null);

(statearr_25863_25917[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (9))){
var inst_25639 = (state_25815[(29)]);
var inst_25655 = (state_25815[(32)]);
var inst_25657 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_25639,inst_25655);
var state_25815__$1 = state_25815;
var statearr_25864_25918 = state_25815__$1;
(statearr_25864_25918[(2)] = inst_25657);

(statearr_25864_25918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (5))){
var _ = (function (){var statearr_25865 = state_25815;
(statearr_25865[(4)] = cljs.core.rest.call(null,(state_25815[(4)])));

return statearr_25865;
})();
var state_25815__$1 = state_25815;
var ex25861 = (state_25815__$1[(2)]);
var statearr_25866_25919 = state_25815__$1;
(statearr_25866_25919[(5)] = ex25861);


if((ex25861 instanceof Error)){
var statearr_25867_25920 = state_25815__$1;
(statearr_25867_25920[(1)] = (4));

(statearr_25867_25920[(5)] = null);

} else {
throw ex25861;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (14))){
var inst_25680 = (state_25815[(39)]);
var inst_25674 = (state_25815[(24)]);
var inst_25683 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_25674,inst_25680,opts);
var state_25815__$1 = state_25815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25815__$1,(17),inst_25683);
} else {
if((state_val_25816 === (26))){
var inst_25758 = (state_25815[(16)]);
var inst_25767 = fluree.db.query.schema.schema_map.call(null,inst_25758);
var state_25815__$1 = state_25815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25815__$1,(29),inst_25767);
} else {
if((state_val_25816 === (16))){
var inst_25690 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
var statearr_25868_25921 = state_25815__$1;
(statearr_25868_25921[(2)] = inst_25690);

(statearr_25868_25921[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (38))){
var inst_25738 = (state_25815[(14)]);
var state_25815__$1 = state_25815;
var statearr_25869_25922 = state_25815__$1;
(statearr_25869_25922[(2)] = inst_25738);

(statearr_25869_25922[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (30))){
var inst_25758 = (state_25815[(16)]);
var inst_25776 = fluree.db.query.schema.setting_map.call(null,inst_25758);
var state_25815__$1 = state_25815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25815__$1,(33),inst_25776);
} else {
if((state_val_25816 === (10))){
var inst_25659 = cljs.core.PersistentVector.EMPTY;
var state_25815__$1 = state_25815;
var statearr_25870_25923 = state_25815__$1;
(statearr_25870_25923[(2)] = inst_25659);

(statearr_25870_25923[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (18))){
var inst_25734 = (state_25815[(23)]);
var inst_25746 = (state_25815[(22)]);
var inst_25745 = cljs.core.seq.call(null,inst_25734);
var inst_25746__$1 = cljs.core.first.call(null,inst_25745);
var inst_25747 = cljs.core.next.call(null,inst_25745);
var inst_25748 = cljs.core.not.call(null,inst_25746__$1);
var state_25815__$1 = (function (){var statearr_25871 = state_25815;
(statearr_25871[(18)] = inst_25747);

(statearr_25871[(22)] = inst_25746__$1);

return statearr_25871;
})();
if(inst_25748){
var statearr_25872_25924 = state_25815__$1;
(statearr_25872_25924[(1)] = (20));

} else {
var statearr_25873_25925 = state_25815__$1;
(statearr_25873_25925[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (37))){
var inst_25738 = (state_25815[(14)]);
var inst_25746 = (state_25815[(22)]);
var inst_25801 = cljs.core.conj.call(null,inst_25738,inst_25746);
var state_25815__$1 = state_25815;
var statearr_25874_25926 = state_25815__$1;
(statearr_25874_25926[(2)] = inst_25801);

(statearr_25874_25926[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (8))){
var inst_25639 = (state_25815[(29)]);
var inst_25652 = (state_25815[(11)]);
var inst_25642 = (state_25815[(31)]);
var inst_25646 = (state_25815[(33)]);
var inst_25623 = (state_25815[(34)]);
var inst_25638 = (state_25815[(35)]);
var inst_25638__$1 = (state_25815[(2)]);
var inst_25639__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25640 = cljs.core.PersistentHashSet.EMPTY;
var inst_25641 = cljs.core.map.call(null,fluree.db.flake.p,inst_25639__$1);
var inst_25642__$1 = cljs.core.into.call(null,inst_25640,inst_25641);
var inst_25643 = cljs.core.PersistentHashMap.EMPTY;
var inst_25644 = (function (){var t = inst_25623;
var _ = inst_25638__$1;
var add_flakes = inst_25639__$1;
var add_preds = inst_25642__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25645 = cljs.core.map.call(null,inst_25644,inst_25642__$1);
var inst_25646__$1 = cljs.core.into.call(null,inst_25643,inst_25645);
var inst_25647 = cljs.core.PersistentHashMap.EMPTY;
var inst_25648 = (function (){var t = inst_25623;
var _ = inst_25638__$1;
var add_flakes = inst_25639__$1;
var add_preds = inst_25642__$1;
var idx_QMARK__map = inst_25646__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25649 = cljs.core.map.call(null,inst_25648,inst_25642__$1);
var inst_25650 = cljs.core.into.call(null,inst_25647,inst_25649);
var inst_25651 = fluree.db.flake.size_bytes.call(null,inst_25639__$1);
var inst_25652__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_25639__$1);
var inst_25653 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_25639__$1);
var inst_25654 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25655 = cljs.core.get.call(null,inst_25654,(0));
var state_25815__$1 = (function (){var statearr_25875 = state_25815;
(statearr_25875[(25)] = inst_25650);

(statearr_25875[(26)] = inst_25653);

(statearr_25875[(10)] = inst_25651);

(statearr_25875[(29)] = inst_25639__$1);

(statearr_25875[(11)] = inst_25652__$1);

(statearr_25875[(31)] = inst_25642__$1);

(statearr_25875[(32)] = inst_25655);

(statearr_25875[(33)] = inst_25646__$1);

(statearr_25875[(35)] = inst_25638__$1);

return statearr_25875;
})();
if(cljs.core.truth_(inst_25652__$1)){
var statearr_25876_25927 = state_25815__$1;
(statearr_25876_25927[(1)] = (9));

} else {
var statearr_25877_25928 = state_25815__$1;
(statearr_25877_25928[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_25878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25878[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_25878[(1)] = (1));

return statearr_25878;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_25815){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25879){var ex__2749__auto__ = e25879;
var statearr_25880_25929 = state_25815;
(statearr_25880_25929[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25815[(4)]))){
var statearr_25881_25930 = state_25815;
(statearr_25881_25930[(1)] = cljs.core.first.call(null,(state_25815[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25931 = state_25815;
state_25815 = G__25931;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_25815){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_25815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25882 = f__2769__auto__.call(null);
(statearr_25882[(6)] = c__2768__auto__);

return statearr_25882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__25933 = arguments.length;
switch (G__25933) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26080 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26029){
var state_val_26030 = (state_26029[(1)]);
if((state_val_26030 === (7))){
var state_26029__$1 = state_26029;
var statearr_26031_26081 = state_26029__$1;
(statearr_26031_26081[(2)] = null);

(statearr_26031_26081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (20))){
var inst_25978 = (state_26029[(7)]);
var inst_25979 = (state_26029[(8)]);
var inst_25977 = (state_26029[(9)]);
var inst_25998 = (inst_25977 + (1));
var inst_25999 = cljs.core.assoc.call(null,inst_25979,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25998);
var inst_26000 = fluree.db.graphdb.with_t.call(null,inst_25999,inst_25978,opts);
var state_26029__$1 = state_26029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26029__$1,(23),inst_26000);
} else {
if((state_val_26030 === (1))){
var state_26029__$1 = state_26029;
var statearr_26032_26082 = state_26029__$1;
(statearr_26032_26082[(2)] = null);

(statearr_26032_26082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (24))){
var inst_26003 = (state_26029[(10)]);
var inst_26006 = cljs.core.assoc.call(null,inst_26003,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26029__$1 = state_26029;
var statearr_26033_26083 = state_26029__$1;
(statearr_26033_26083[(2)] = inst_26006);

(statearr_26033_26083[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (4))){
var inst_25934 = (state_26029[(2)]);
var inst_25935 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25934);
var state_26029__$1 = state_26029;
var statearr_26034_26084 = state_26029__$1;
(statearr_26034_26084[(2)] = inst_25935);

(statearr_26034_26084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (15))){
var inst_25985 = (state_26029[(11)]);
var state_26029__$1 = state_26029;
var statearr_26035_26085 = state_26029__$1;
(statearr_26035_26085[(2)] = inst_25985);

(statearr_26035_26085[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (21))){
var state_26029__$1 = state_26029;
var statearr_26036_26086 = state_26029__$1;
(statearr_26036_26086[(2)] = null);

(statearr_26036_26086[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (13))){
var inst_26021 = (state_26029[(2)]);
var inst_26022 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26021);
var state_26029__$1 = state_26029;
var statearr_26037_26087 = state_26029__$1;
(statearr_26037_26087[(2)] = inst_26022);

(statearr_26037_26087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (22))){
var inst_26017 = (state_26029[(2)]);
var state_26029__$1 = state_26029;
var statearr_26038_26088 = state_26029__$1;
(statearr_26038_26088[(2)] = inst_26017);

(statearr_26038_26088[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (6))){
var inst_25945 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25946 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25947 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25945)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25946)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_25948 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25949 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25950 = cljs.core.PersistentHashMap.fromArrays(inst_25948,inst_25949);
var inst_25951 = cljs.core.ex_info.call(null,inst_25947,inst_25950);
var inst_25952 = (function(){throw inst_25951})();
var state_26029__$1 = state_26029;
var statearr_26041_26089 = state_26029__$1;
(statearr_26041_26089[(2)] = inst_25952);

(statearr_26041_26089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (25))){
var inst_25985 = (state_26029[(11)]);
var inst_25986 = (state_26029[(12)]);
var inst_26003 = (state_26029[(10)]);
var inst_26008 = fluree.db.flake.t.call(null,inst_25985);
var inst_26009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26010 = [inst_25985];
var inst_26011 = (new cljs.core.PersistentVector(null,1,(5),inst_26009,inst_26010,null));
var inst_25976 = inst_25986;
var inst_25977 = inst_26008;
var inst_25978 = inst_26011;
var inst_25979 = inst_26003;
var state_26029__$1 = (function (){var statearr_26042 = state_26029;
(statearr_26042[(13)] = inst_25976);

(statearr_26042[(7)] = inst_25978);

(statearr_26042[(8)] = inst_25979);

(statearr_26042[(9)] = inst_25977);

return statearr_26042;
})();
var statearr_26043_26090 = state_26029__$1;
(statearr_26043_26090[(2)] = null);

(statearr_26043_26090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (17))){
var inst_25985 = (state_26029[(11)]);
var inst_25978 = (state_26029[(7)]);
var inst_25986 = (state_26029[(12)]);
var inst_25979 = (state_26029[(8)]);
var inst_25977 = (state_26029[(9)]);
var inst_25994 = cljs.core.conj.call(null,inst_25978,inst_25985);
var tmp26039 = inst_25979;
var tmp26040 = inst_25977;
var inst_25976 = inst_25986;
var inst_25977__$1 = tmp26040;
var inst_25978__$1 = inst_25994;
var inst_25979__$1 = tmp26039;
var state_26029__$1 = (function (){var statearr_26044 = state_26029;
(statearr_26044[(13)] = inst_25976);

(statearr_26044[(7)] = inst_25978__$1);

(statearr_26044[(8)] = inst_25979__$1);

(statearr_26044[(9)] = inst_25977__$1);

return statearr_26044;
})();
var statearr_26045_26091 = state_26029__$1;
(statearr_26045_26091[(2)] = null);

(statearr_26045_26091[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (3))){
var inst_26027 = (state_26029[(2)]);
var state_26029__$1 = state_26029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26029__$1,inst_26027);
} else {
if((state_val_26030 === (12))){
var inst_25976 = (state_26029[(13)]);
var inst_25985 = (state_26029[(11)]);
var inst_25984 = cljs.core.seq.call(null,inst_25976);
var inst_25985__$1 = cljs.core.first.call(null,inst_25984);
var inst_25986 = cljs.core.next.call(null,inst_25984);
var state_26029__$1 = (function (){var statearr_26046 = state_26029;
(statearr_26046[(11)] = inst_25985__$1);

(statearr_26046[(12)] = inst_25986);

return statearr_26046;
})();
if(cljs.core.truth_(inst_25985__$1)){
var statearr_26047_26092 = state_26029__$1;
(statearr_26047_26092[(1)] = (14));

} else {
var statearr_26048_26093 = state_26029__$1;
(statearr_26048_26093[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (2))){
var _ = (function (){var statearr_26049 = state_26029;
(statearr_26049[(4)] = cljs.core.cons.call(null,(5),(state_26029[(4)])));

return statearr_26049;
})();
var inst_25941 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25942 = (inst_25941 + (1));
var inst_25943 = cljs.core.not_EQ_.call(null,block,inst_25942);
var state_26029__$1 = state_26029;
if(inst_25943){
var statearr_26050_26094 = state_26029__$1;
(statearr_26050_26094[(1)] = (6));

} else {
var statearr_26051_26095 = state_26029__$1;
(statearr_26051_26095[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (23))){
var inst_25985 = (state_26029[(11)]);
var inst_26002 = (state_26029[(2)]);
var inst_26003 = fluree.db.util.async.throw_err.call(null,inst_26002);
var inst_26004 = (inst_25985 == null);
var state_26029__$1 = (function (){var statearr_26052 = state_26029;
(statearr_26052[(10)] = inst_26003);

return statearr_26052;
})();
if(cljs.core.truth_(inst_26004)){
var statearr_26053_26096 = state_26029__$1;
(statearr_26053_26096[(1)] = (24));

} else {
var statearr_26054_26097 = state_26029__$1;
(statearr_26054_26097[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (19))){
var inst_26019 = (state_26029[(2)]);
var state_26029__$1 = state_26029;
var statearr_26055_26098 = state_26029__$1;
(statearr_26055_26098[(2)] = inst_26019);

(statearr_26055_26098[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (11))){
var inst_26024 = (state_26029[(2)]);
var _ = (function (){var statearr_26057 = state_26029;
(statearr_26057[(4)] = cljs.core.rest.call(null,(state_26029[(4)])));

return statearr_26057;
})();
var state_26029__$1 = state_26029;
var statearr_26058_26099 = state_26029__$1;
(statearr_26058_26099[(2)] = inst_26024);

(statearr_26058_26099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (9))){
var inst_25958 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_25959 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25958);
var state_26029__$1 = state_26029;
var statearr_26059_26100 = state_26029__$1;
(statearr_26059_26100[(2)] = inst_25959);

(statearr_26059_26100[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (5))){
var _ = (function (){var statearr_26060 = state_26029;
(statearr_26060[(4)] = cljs.core.rest.call(null,(state_26029[(4)])));

return statearr_26060;
})();
var state_26029__$1 = state_26029;
var ex26056 = (state_26029__$1[(2)]);
var statearr_26061_26101 = state_26029__$1;
(statearr_26061_26101[(5)] = ex26056);


var statearr_26062_26102 = state_26029__$1;
(statearr_26062_26102[(1)] = (4));

(statearr_26062_26102[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (14))){
var inst_25985 = (state_26029[(11)]);
var inst_25977 = (state_26029[(9)]);
var inst_25988 = fluree.db.flake.t.call(null,inst_25985);
var inst_25989 = cljs.core._EQ_.call(null,inst_25977,inst_25988);
var state_26029__$1 = state_26029;
var statearr_26063_26103 = state_26029__$1;
(statearr_26063_26103[(2)] = inst_25989);

(statearr_26063_26103[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (26))){
var inst_26014 = (state_26029[(2)]);
var state_26029__$1 = state_26029;
var statearr_26064_26104 = state_26029__$1;
(statearr_26064_26104[(2)] = inst_26014);

(statearr_26064_26104[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (16))){
var inst_25992 = (state_26029[(2)]);
var state_26029__$1 = state_26029;
if(cljs.core.truth_(inst_25992)){
var statearr_26065_26105 = state_26029__$1;
(statearr_26065_26105[(1)] = (17));

} else {
var statearr_26066_26106 = state_26029__$1;
(statearr_26066_26106[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (10))){
var inst_25961 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_25969 = cljs.core.seq.call(null,inst_25961);
var inst_25970 = cljs.core.first.call(null,inst_25969);
var inst_25971 = cljs.core.next.call(null,inst_25969);
var inst_25972 = cljs.core.first.call(null,inst_25961);
var inst_25973 = fluree.db.flake.t.call(null,inst_25972);
var inst_25974 = cljs.core.PersistentVector.EMPTY;
var inst_25975 = db;
var inst_25976 = inst_25961;
var inst_25977 = inst_25973;
var inst_25978 = inst_25974;
var inst_25979 = inst_25975;
var state_26029__$1 = (function (){var statearr_26067 = state_26029;
(statearr_26067[(13)] = inst_25976);

(statearr_26067[(14)] = inst_25970);

(statearr_26067[(7)] = inst_25978);

(statearr_26067[(8)] = inst_25979);

(statearr_26067[(15)] = inst_25971);

(statearr_26067[(9)] = inst_25977);

return statearr_26067;
})();
var statearr_26068_26107 = state_26029__$1;
(statearr_26068_26107[(2)] = null);

(statearr_26068_26107[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (18))){
var state_26029__$1 = state_26029;
var statearr_26069_26108 = state_26029__$1;
(statearr_26069_26108[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26030 === (8))){
var inst_25955 = (state_26029[(2)]);
var inst_25956 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26029__$1 = (function (){var statearr_26071 = state_26029;
(statearr_26071[(16)] = inst_25955);

return statearr_26071;
})();
if(inst_25956){
var statearr_26072_26109 = state_26029__$1;
(statearr_26072_26109[(1)] = (9));

} else {
var statearr_26073_26110 = state_26029__$1;
(statearr_26073_26110[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26074[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26074[(1)] = (1));

return statearr_26074;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26029){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26075){var ex__2749__auto__ = e26075;
var statearr_26076_26111 = state_26029;
(statearr_26076_26111[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26029[(4)]))){
var statearr_26077_26112 = state_26029;
(statearr_26077_26112[(1)] = cljs.core.first.call(null,(state_26029[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26113 = state_26029;
state_26029 = G__26113;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26029){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26078 = f__2769__auto__.call(null);
(statearr_26078[(6)] = c__2768__auto___26080);

return statearr_26078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26165){
var state_val_26166 = (state_26165[(1)]);
if((state_val_26166 === (7))){
var state_26165__$1 = state_26165;
var statearr_26167_26194 = state_26165__$1;
(statearr_26167_26194[(2)] = tt_id);

(statearr_26167_26194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (1))){
var state_26165__$1 = state_26165;
var statearr_26168_26195 = state_26165__$1;
(statearr_26168_26195[(2)] = null);

(statearr_26168_26195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (4))){
var inst_26114 = (state_26165[(2)]);
var state_26165__$1 = state_26165;
var statearr_26169_26196 = state_26165__$1;
(statearr_26169_26196[(2)] = inst_26114);

(statearr_26169_26196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (13))){
var inst_26158 = (state_26165[(2)]);
var state_26165__$1 = state_26165;
var statearr_26170_26197 = state_26165__$1;
(statearr_26170_26197[(2)] = inst_26158);

(statearr_26170_26197[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (6))){
var inst_26122 = cljs.core.random_uuid.call(null);
var state_26165__$1 = state_26165;
var statearr_26171_26198 = state_26165__$1;
(statearr_26171_26198[(2)] = inst_26122);

(statearr_26171_26198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (3))){
var inst_26163 = (state_26165[(2)]);
var state_26165__$1 = state_26165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26165__$1,inst_26163);
} else {
if((state_val_26166 === (12))){
var inst_26141 = (state_26165[(7)]);
var state_26165__$1 = state_26165;
var statearr_26172_26199 = state_26165__$1;
(statearr_26172_26199[(2)] = inst_26141);

(statearr_26172_26199[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (2))){
var _ = (function (){var statearr_26173 = state_26165;
(statearr_26173[(4)] = cljs.core.cons.call(null,(5),(state_26165[(4)])));

return statearr_26173;
})();
var inst_26120 = (tt_id == null);
var state_26165__$1 = state_26165;
if(cljs.core.truth_(inst_26120)){
var statearr_26174_26200 = state_26165__$1;
(statearr_26174_26200[(1)] = (6));

} else {
var statearr_26175_26201 = state_26165__$1;
(statearr_26175_26201[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (11))){
var inst_26141 = (state_26165[(7)]);
var inst_26148 = (state_26165[(8)]);
var inst_26151 = fluree.db.graphdb.with_t.call(null,inst_26141,inst_26148);
var state_26165__$1 = state_26165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26165__$1,(14),inst_26151);
} else {
if((state_val_26166 === (9))){
var inst_26142 = (state_26165[(9)]);
var inst_26148 = (state_26165[(8)]);
var inst_26147 = cljs.core.seq.call(null,inst_26142);
var inst_26148__$1 = cljs.core.first.call(null,inst_26147);
var inst_26149 = cljs.core.next.call(null,inst_26147);
var state_26165__$1 = (function (){var statearr_26177 = state_26165;
(statearr_26177[(10)] = inst_26149);

(statearr_26177[(8)] = inst_26148__$1);

return statearr_26177;
})();
if(cljs.core.truth_(inst_26148__$1)){
var statearr_26178_26202 = state_26165__$1;
(statearr_26178_26202[(1)] = (11));

} else {
var statearr_26179_26203 = state_26165__$1;
(statearr_26179_26203[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (5))){
var _ = (function (){var statearr_26180 = state_26165;
(statearr_26180[(4)] = cljs.core.rest.call(null,(state_26165[(4)])));

return statearr_26180;
})();
var state_26165__$1 = state_26165;
var ex26176 = (state_26165__$1[(2)]);
var statearr_26181_26204 = state_26165__$1;
(statearr_26181_26204[(5)] = ex26176);


if((ex26176 instanceof Error)){
var statearr_26182_26205 = state_26165__$1;
(statearr_26182_26205[(1)] = (4));

(statearr_26182_26205[(5)] = null);

} else {
throw ex26176;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (14))){
var inst_26149 = (state_26165[(10)]);
var inst_26153 = (state_26165[(2)]);
var inst_26154 = fluree.db.util.async.throw_err.call(null,inst_26153);
var inst_26141 = inst_26154;
var inst_26142 = inst_26149;
var state_26165__$1 = (function (){var statearr_26183 = state_26165;
(statearr_26183[(9)] = inst_26142);

(statearr_26183[(7)] = inst_26141);

return statearr_26183;
})();
var statearr_26184_26206 = state_26165__$1;
(statearr_26184_26206[(2)] = null);

(statearr_26184_26206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (10))){
var inst_26160 = (state_26165[(2)]);
var _ = (function (){var statearr_26185 = state_26165;
(statearr_26185[(4)] = cljs.core.rest.call(null,(state_26165[(4)])));

return statearr_26185;
})();
var state_26165__$1 = state_26165;
var statearr_26186_26207 = state_26165__$1;
(statearr_26186_26207[(2)] = inst_26160);

(statearr_26186_26207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26166 === (8))){
var inst_26125 = (state_26165[(2)]);
var inst_26126 = (function (){var tt_id__$1 = inst_26125;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26127 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26125);
var inst_26128 = cljs.core.reduce.call(null,inst_26126,inst_26127,fluree.db.index.types);
var inst_26129 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26130 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26129);
var inst_26138 = cljs.core.seq.call(null,inst_26130);
var inst_26139 = cljs.core.first.call(null,inst_26138);
var inst_26140 = cljs.core.next.call(null,inst_26138);
var inst_26141 = inst_26128;
var inst_26142 = inst_26130;
var state_26165__$1 = (function (){var statearr_26187 = state_26165;
(statearr_26187[(9)] = inst_26142);

(statearr_26187[(11)] = inst_26140);

(statearr_26187[(12)] = inst_26139);

(statearr_26187[(7)] = inst_26141);

return statearr_26187;
})();
var statearr_26188_26208 = state_26165__$1;
(statearr_26188_26208[(2)] = null);

(statearr_26188_26208[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_26189 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26189[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_26189[(1)] = (1));

return statearr_26189;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_26165){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26190){var ex__2749__auto__ = e26190;
var statearr_26191_26209 = state_26165;
(statearr_26191_26209[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26165[(4)]))){
var statearr_26192_26210 = state_26165;
(statearr_26192_26210[(1)] = cljs.core.first.call(null,(state_26165[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26211 = state_26165;
state_26165 = G__26211;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_26165){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_26165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26193 = f__2769__auto__.call(null);
(statearr_26193[(6)] = c__2768__auto__);

return statearr_26193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26398 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26329){
var state_val_26330 = (state_26329[(1)]);
if((state_val_26330 === (7))){
var inst_26239 = (state_26329[(7)]);
var inst_26239__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26329__$1 = (function (){var statearr_26331 = state_26329;
(statearr_26331[(7)] = inst_26239__$1);

return statearr_26331;
})();
if(inst_26239__$1){
var statearr_26332_26399 = state_26329__$1;
(statearr_26332_26399[(1)] = (13));

} else {
var statearr_26333_26400 = state_26329__$1;
(statearr_26333_26400[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (20))){
var state_26329__$1 = state_26329;
var statearr_26334_26401 = state_26329__$1;
(statearr_26334_26401[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (27))){
var inst_26275 = (state_26329[(8)]);
var inst_26279 = fluree.db.flake.s.call(null,inst_26275);
var state_26329__$1 = state_26329;
var statearr_26336_26402 = state_26329__$1;
(statearr_26336_26402[(2)] = inst_26279);

(statearr_26336_26402[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (1))){
var state_26329__$1 = state_26329;
var statearr_26337_26403 = state_26329__$1;
(statearr_26337_26403[(2)] = null);

(statearr_26337_26403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (24))){
var inst_26269 = (state_26329[(9)]);
var inst_26273 = cljs.core.first.call(null,inst_26269);
var state_26329__$1 = state_26329;
var statearr_26338_26404 = state_26329__$1;
(statearr_26338_26404[(2)] = inst_26273);

(statearr_26338_26404[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (39))){
var state_26329__$1 = state_26329;
var statearr_26339_26405 = state_26329__$1;
(statearr_26339_26405[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (4))){
var inst_26212 = (state_26329[(2)]);
var inst_26213 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26214 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26215 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26216 = cljs.core.PersistentHashMap.fromArrays(inst_26214,inst_26215);
var inst_26217 = cljs.core.ex_info.call(null,inst_26213,inst_26216,inst_26212);
var inst_26218 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26217);
var state_26329__$1 = state_26329;
var statearr_26341_26406 = state_26329__$1;
(statearr_26341_26406[(2)] = inst_26218);

(statearr_26341_26406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (15))){
var inst_26246 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
if(cljs.core.truth_(inst_26246)){
var statearr_26342_26407 = state_26329__$1;
(statearr_26342_26407[(1)] = (16));

} else {
var statearr_26343_26408 = state_26329__$1;
(statearr_26343_26408[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (21))){
var inst_26295 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26344_26409 = state_26329__$1;
(statearr_26344_26409[(2)] = inst_26295);

(statearr_26344_26409[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (31))){
var inst_26293 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26345_26410 = state_26329__$1;
(statearr_26345_26410[(2)] = inst_26293);

(statearr_26345_26410[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (32))){
var inst_26299 = (state_26329[(10)]);
var inst_26301 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26299);
var state_26329__$1 = state_26329;
var statearr_26346_26411 = state_26329__$1;
(statearr_26346_26411[(2)] = inst_26301);

(statearr_26346_26411[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (40))){
var inst_26322 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26347_26412 = state_26329__$1;
(statearr_26347_26412[(2)] = inst_26322);

(statearr_26347_26412[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (33))){
var inst_26303 = (state_26329[(11)]);
var inst_26299 = (state_26329[(10)]);
var inst_26303__$1 = (inst_26299 == null);
var state_26329__$1 = (function (){var statearr_26348 = state_26329;
(statearr_26348[(11)] = inst_26303__$1);

return statearr_26348;
})();
if(cljs.core.truth_(inst_26303__$1)){
var statearr_26349_26413 = state_26329__$1;
(statearr_26349_26413[(1)] = (35));

} else {
var statearr_26350_26414 = state_26329__$1;
(statearr_26350_26414[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (13))){
var inst_26241 = cljs.core.first.call(null,ident);
var inst_26242 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26241);
var inst_26243 = (inst_26242 == null);
var state_26329__$1 = state_26329;
var statearr_26351_26415 = state_26329__$1;
(statearr_26351_26415[(2)] = inst_26243);

(statearr_26351_26415[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (22))){
var inst_26269 = (state_26329[(9)]);
var inst_26268 = (state_26329[(2)]);
var inst_26269__$1 = fluree.db.util.async.throw_err.call(null,inst_26268);
var inst_26270 = (inst_26269__$1 == null);
var state_26329__$1 = (function (){var statearr_26352 = state_26329;
(statearr_26352[(9)] = inst_26269__$1);

return statearr_26352;
})();
if(cljs.core.truth_(inst_26270)){
var statearr_26353_26416 = state_26329__$1;
(statearr_26353_26416[(1)] = (23));

} else {
var statearr_26354_26417 = state_26329__$1;
(statearr_26354_26417[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (36))){
var inst_26303 = (state_26329[(11)]);
var state_26329__$1 = state_26329;
var statearr_26355_26418 = state_26329__$1;
(statearr_26355_26418[(2)] = inst_26303);

(statearr_26355_26418[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (41))){
var inst_26317 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26329__$1 = state_26329;
var statearr_26356_26419 = state_26329__$1;
(statearr_26356_26419[(2)] = inst_26317);

(statearr_26356_26419[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (43))){
var inst_26320 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26357_26420 = state_26329__$1;
(statearr_26357_26420[(2)] = inst_26320);

(statearr_26357_26420[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (29))){
var inst_26284 = cljs.core.pr_str.call(null,ident);
var inst_26285 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26284].join('');
var inst_26286 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26287 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26288 = cljs.core.PersistentHashMap.fromArrays(inst_26286,inst_26287);
var inst_26289 = cljs.core.ex_info.call(null,inst_26285,inst_26288);
var inst_26290 = (function(){throw inst_26289})();
var state_26329__$1 = state_26329;
var statearr_26358_26421 = state_26329__$1;
(statearr_26358_26421[(2)] = inst_26290);

(statearr_26358_26421[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (6))){
var inst_26226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26227 = [ident];
var inst_26228 = (new cljs.core.PersistentVector(null,1,(5),inst_26226,inst_26227,null));
var inst_26229 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26228);
var state_26329__$1 = state_26329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26329__$1,(9),inst_26229);
} else {
if((state_val_26330 === (28))){
var inst_26281 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26359_26422 = state_26329__$1;
(statearr_26359_26422[(2)] = inst_26281);

(statearr_26359_26422[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (25))){
var inst_26275 = (state_26329[(8)]);
var inst_26275__$1 = (state_26329[(2)]);
var inst_26276 = (inst_26275__$1 == null);
var state_26329__$1 = (function (){var statearr_26360 = state_26329;
(statearr_26360[(8)] = inst_26275__$1);

return statearr_26360;
})();
if(cljs.core.truth_(inst_26276)){
var statearr_26361_26423 = state_26329__$1;
(statearr_26361_26423[(1)] = (26));

} else {
var statearr_26362_26424 = state_26329__$1;
(statearr_26362_26424[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (34))){
var inst_26324 = (state_26329[(2)]);
var _ = (function (){var statearr_26363 = state_26329;
(statearr_26363[(4)] = cljs.core.rest.call(null,(state_26329[(4)])));

return statearr_26363;
})();
var state_26329__$1 = state_26329;
var statearr_26364_26425 = state_26329__$1;
(statearr_26364_26425[(2)] = inst_26324);

(statearr_26364_26425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (17))){
var inst_26257 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26329__$1 = state_26329;
if(inst_26257){
var statearr_26365_26426 = state_26329__$1;
(statearr_26365_26426[(1)] = (19));

} else {
var statearr_26366_26427 = state_26329__$1;
(statearr_26366_26427[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (3))){
var inst_26327 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26329__$1,inst_26327);
} else {
if((state_val_26330 === (12))){
var inst_26237 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26367_26428 = state_26329__$1;
(statearr_26367_26428[(2)] = inst_26237);

(statearr_26367_26428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (2))){
var _ = (function (){var statearr_26368 = state_26329;
(statearr_26368[(4)] = cljs.core.cons.call(null,(5),(state_26329[(4)])));

return statearr_26368;
})();
var inst_26224 = typeof ident === 'number';
var state_26329__$1 = state_26329;
if(cljs.core.truth_(inst_26224)){
var statearr_26369_26429 = state_26329__$1;
(statearr_26369_26429[(1)] = (6));

} else {
var statearr_26370_26430 = state_26329__$1;
(statearr_26370_26430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (23))){
var state_26329__$1 = state_26329;
var statearr_26371_26431 = state_26329__$1;
(statearr_26371_26431[(2)] = null);

(statearr_26371_26431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (35))){
var state_26329__$1 = state_26329;
var statearr_26372_26432 = state_26329__$1;
(statearr_26372_26432[(2)] = strict_QMARK_);

(statearr_26372_26432[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (19))){
var inst_26260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26261 = cljs.core.first.call(null,ident);
var inst_26262 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26261);
var inst_26263 = cljs.core.second.call(null,ident);
var inst_26264 = [inst_26262,inst_26263];
var inst_26265 = (new cljs.core.PersistentVector(null,2,(5),inst_26260,inst_26264,null));
var inst_26266 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26265);
var state_26329__$1 = state_26329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26329__$1,(22),inst_26266);
} else {
if((state_val_26330 === (11))){
var state_26329__$1 = state_26329;
var statearr_26374_26433 = state_26329__$1;
(statearr_26374_26433[(2)] = null);

(statearr_26374_26433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (9))){
var inst_26231 = (state_26329[(2)]);
var inst_26232 = fluree.db.util.async.throw_err.call(null,inst_26231);
var inst_26233 = cljs.core.not_empty.call(null,inst_26232);
var state_26329__$1 = state_26329;
if(cljs.core.truth_(inst_26233)){
var statearr_26375_26434 = state_26329__$1;
(statearr_26375_26434[(1)] = (10));

} else {
var statearr_26376_26435 = state_26329__$1;
(statearr_26376_26435[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (5))){
var _ = (function (){var statearr_26377 = state_26329;
(statearr_26377[(4)] = cljs.core.rest.call(null,(state_26329[(4)])));

return statearr_26377;
})();
var state_26329__$1 = state_26329;
var ex26373 = (state_26329__$1[(2)]);
var statearr_26378_26436 = state_26329__$1;
(statearr_26378_26436[(5)] = ex26373);


var statearr_26379_26437 = state_26329__$1;
(statearr_26379_26437[(1)] = (4));

(statearr_26379_26437[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (14))){
var inst_26239 = (state_26329[(7)]);
var state_26329__$1 = state_26329;
var statearr_26380_26438 = state_26329__$1;
(statearr_26380_26438[(2)] = inst_26239);

(statearr_26380_26438[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (26))){
var state_26329__$1 = state_26329;
var statearr_26381_26439 = state_26329__$1;
(statearr_26381_26439[(2)] = null);

(statearr_26381_26439[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (16))){
var inst_26248 = cljs.core.first.call(null,ident);
var inst_26249 = cljs.core.pr_str.call(null,inst_26248);
var inst_26250 = ["Subject ID lookup failed. The predicate ",inst_26249," does not exist."].join('');
var inst_26251 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26252 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26253 = cljs.core.PersistentHashMap.fromArrays(inst_26251,inst_26252);
var inst_26254 = cljs.core.ex_info.call(null,inst_26250,inst_26253);
var inst_26255 = (function(){throw inst_26254})();
var state_26329__$1 = state_26329;
var statearr_26382_26440 = state_26329__$1;
(statearr_26382_26440[(2)] = inst_26255);

(statearr_26382_26440[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (38))){
var inst_26309 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26310 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26311 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26312 = cljs.core.PersistentHashMap.fromArrays(inst_26310,inst_26311);
var inst_26313 = cljs.core.ex_info.call(null,inst_26309,inst_26312);
var inst_26314 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26313);
var state_26329__$1 = state_26329;
var statearr_26383_26441 = state_26329__$1;
(statearr_26383_26441[(2)] = inst_26314);

(statearr_26383_26441[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (30))){
var state_26329__$1 = state_26329;
var statearr_26384_26442 = state_26329__$1;
(statearr_26384_26442[(2)] = null);

(statearr_26384_26442[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (10))){
var state_26329__$1 = state_26329;
var statearr_26385_26443 = state_26329__$1;
(statearr_26385_26443[(2)] = ident);

(statearr_26385_26443[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (18))){
var inst_26297 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
var statearr_26386_26444 = state_26329__$1;
(statearr_26386_26444[(2)] = inst_26297);

(statearr_26386_26444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (42))){
var state_26329__$1 = state_26329;
var statearr_26387_26445 = state_26329__$1;
(statearr_26387_26445[(2)] = null);

(statearr_26387_26445[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (37))){
var inst_26307 = (state_26329[(2)]);
var state_26329__$1 = state_26329;
if(cljs.core.truth_(inst_26307)){
var statearr_26388_26446 = state_26329__$1;
(statearr_26388_26446[(1)] = (38));

} else {
var statearr_26389_26447 = state_26329__$1;
(statearr_26389_26447[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26330 === (8))){
var inst_26299 = (state_26329[(10)]);
var inst_26299__$1 = (state_26329[(2)]);
var state_26329__$1 = (function (){var statearr_26390 = state_26329;
(statearr_26390[(10)] = inst_26299__$1);

return statearr_26390;
})();
if(cljs.core.truth_(inst_26299__$1)){
var statearr_26391_26448 = state_26329__$1;
(statearr_26391_26448[(1)] = (32));

} else {
var statearr_26392_26449 = state_26329__$1;
(statearr_26392_26449[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_26393 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26393[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_26393[(1)] = (1));

return statearr_26393;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_26329){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26394){var ex__2749__auto__ = e26394;
var statearr_26395_26450 = state_26329;
(statearr_26395_26450[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26329[(4)]))){
var statearr_26396_26451 = state_26329;
(statearr_26396_26451[(1)] = cljs.core.first.call(null,(state_26329[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26452 = state_26329;
state_26329 = G__26452;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_26329){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_26329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26397 = f__2769__auto__.call(null);
(statearr_26397[(6)] = c__2768__auto___26398);

return statearr_26397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26453){
var map__26454 = p__26453;
var map__26454__$1 = cljs.core.__destructure_map.call(null,map__26454);
var db = map__26454__$1;
var current_db_fn = cljs.core.get.call(null,map__26454__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__26454__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26470){
var state_val_26471 = (state_26470[(1)]);
if((state_val_26471 === (1))){
var state_26470__$1 = state_26470;
var statearr_26472_26486 = state_26470__$1;
(statearr_26472_26486[(2)] = null);

(statearr_26472_26486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26471 === (2))){
var _ = (function (){var statearr_26473 = state_26470;
(statearr_26473[(4)] = cljs.core.cons.call(null,(5),(state_26470[(4)])));

return statearr_26473;
})();
var inst_26461 = current_db_fn.call(null,db);
var state_26470__$1 = state_26470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26470__$1,(6),inst_26461);
} else {
if((state_val_26471 === (3))){
var inst_26468 = (state_26470[(2)]);
var state_26470__$1 = state_26470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26470__$1,inst_26468);
} else {
if((state_val_26471 === (4))){
var inst_26455 = (state_26470[(2)]);
var state_26470__$1 = state_26470;
var statearr_26475_26487 = state_26470__$1;
(statearr_26475_26487[(2)] = inst_26455);

(statearr_26475_26487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26471 === (5))){
var _ = (function (){var statearr_26476 = state_26470;
(statearr_26476[(4)] = cljs.core.rest.call(null,(state_26470[(4)])));

return statearr_26476;
})();
var state_26470__$1 = state_26470;
var ex26474 = (state_26470__$1[(2)]);
var statearr_26477_26488 = state_26470__$1;
(statearr_26477_26488[(5)] = ex26474);


if((ex26474 instanceof Error)){
var statearr_26478_26489 = state_26470__$1;
(statearr_26478_26489[(1)] = (4));

(statearr_26478_26489[(5)] = null);

} else {
throw ex26474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26471 === (6))){
var inst_26463 = (state_26470[(2)]);
var inst_26464 = fluree.db.util.async.throw_err.call(null,inst_26463);
var inst_26465 = cljs.core.assoc.call(null,inst_26464,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26479 = state_26470;
(statearr_26479[(4)] = cljs.core.rest.call(null,(state_26470[(4)])));

return statearr_26479;
})();
var state_26470__$1 = state_26470;
var statearr_26480_26490 = state_26470__$1;
(statearr_26480_26490[(2)] = inst_26465);

(statearr_26480_26490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_26481 = [null,null,null,null,null,null,null];
(statearr_26481[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_26481[(1)] = (1));

return statearr_26481;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_26470){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26482){var ex__2749__auto__ = e26482;
var statearr_26483_26491 = state_26470;
(statearr_26483_26491[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26470[(4)]))){
var statearr_26484_26492 = state_26470;
(statearr_26484_26492[(1)] = cljs.core.first.call(null,(state_26470[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26493 = state_26470;
state_26470 = G__26493;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_26470){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_26470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26485 = f__2769__auto__.call(null);
(statearr_26485[(6)] = c__2768__auto__);

return statearr_26485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26494,property,collection){
var map__26495 = p__26494;
var map__26495__$1 = cljs.core.__destructure_map.call(null,map__26495);
var schema = cljs.core.get.call(null,map__26495__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26496,property,predicate){
var map__26497 = p__26496;
var map__26497__$1 = cljs.core.__destructure_map.call(null,map__26497);
var this$ = map__26497__$1;
var schema = cljs.core.get.call(null,map__26497__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26498 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26498);
} else {
return G__26498;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26500 = arguments.length;
switch (G__26500) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26532){
var state_val_26533 = (state_26532[(1)]);
if((state_val_26533 === (7))){
var state_26532__$1 = state_26532;
var statearr_26534_26628 = state_26532__$1;
(statearr_26534_26628[(2)] = null);

(statearr_26534_26628[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (1))){
var state_26532__$1 = state_26532;
var statearr_26535_26629 = state_26532__$1;
(statearr_26535_26629[(2)] = null);

(statearr_26535_26629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (4))){
var inst_26501 = (state_26532[(2)]);
var state_26532__$1 = state_26532;
var statearr_26536_26630 = state_26532__$1;
(statearr_26536_26630[(2)] = inst_26501);

(statearr_26536_26630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (6))){
var inst_26515 = (state_26532[(7)]);
var inst_26514 = (state_26532[(2)]);
var inst_26515__$1 = fluree.db.util.async.throw_err.call(null,inst_26514);
var inst_26516 = (inst_26515__$1 == null);
var state_26532__$1 = (function (){var statearr_26537 = state_26532;
(statearr_26537[(7)] = inst_26515__$1);

return statearr_26537;
})();
if(cljs.core.truth_(inst_26516)){
var statearr_26538_26631 = state_26532__$1;
(statearr_26538_26631[(1)] = (7));

} else {
var statearr_26539_26632 = state_26532__$1;
(statearr_26539_26632[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (3))){
var inst_26530 = (state_26532[(2)]);
var state_26532__$1 = state_26532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26532__$1,inst_26530);
} else {
if((state_val_26533 === (12))){
var inst_26527 = (state_26532[(2)]);
var _ = (function (){var statearr_26540 = state_26532;
(statearr_26540[(4)] = cljs.core.rest.call(null,(state_26532[(4)])));

return statearr_26540;
})();
var state_26532__$1 = state_26532;
var statearr_26541_26633 = state_26532__$1;
(statearr_26541_26633[(2)] = inst_26527);

(statearr_26541_26633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (2))){
var _ = (function (){var statearr_26542 = state_26532;
(statearr_26542[(4)] = cljs.core.cons.call(null,(5),(state_26532[(4)])));

return statearr_26542;
})();
var inst_26508 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26510 = [tag_id,(30)];
var inst_26511 = (new cljs.core.PersistentVector(null,2,(5),inst_26509,inst_26510,null));
var inst_26512 = fluree.db.query.range.index_range.call(null,inst_26508,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26511);
var state_26532__$1 = state_26532;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26532__$1,(6),inst_26512);
} else {
if((state_val_26533 === (11))){
var inst_26521 = (state_26532[(8)]);
var inst_26525 = fluree.db.flake.o.call(null,inst_26521);
var state_26532__$1 = state_26532;
var statearr_26544_26634 = state_26532__$1;
(statearr_26544_26634[(2)] = inst_26525);

(statearr_26544_26634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (9))){
var inst_26521 = (state_26532[(8)]);
var inst_26521__$1 = (state_26532[(2)]);
var inst_26522 = (inst_26521__$1 == null);
var state_26532__$1 = (function (){var statearr_26545 = state_26532;
(statearr_26545[(8)] = inst_26521__$1);

return statearr_26545;
})();
if(cljs.core.truth_(inst_26522)){
var statearr_26546_26635 = state_26532__$1;
(statearr_26546_26635[(1)] = (10));

} else {
var statearr_26547_26636 = state_26532__$1;
(statearr_26547_26636[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (5))){
var _ = (function (){var statearr_26548 = state_26532;
(statearr_26548[(4)] = cljs.core.rest.call(null,(state_26532[(4)])));

return statearr_26548;
})();
var state_26532__$1 = state_26532;
var ex26543 = (state_26532__$1[(2)]);
var statearr_26549_26637 = state_26532__$1;
(statearr_26549_26637[(5)] = ex26543);


if((ex26543 instanceof Error)){
var statearr_26550_26638 = state_26532__$1;
(statearr_26550_26638[(1)] = (4));

(statearr_26550_26638[(5)] = null);

} else {
throw ex26543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (10))){
var state_26532__$1 = state_26532;
var statearr_26551_26639 = state_26532__$1;
(statearr_26551_26639[(2)] = null);

(statearr_26551_26639[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26533 === (8))){
var inst_26515 = (state_26532[(7)]);
var inst_26519 = cljs.core.first.call(null,inst_26515);
var state_26532__$1 = state_26532;
var statearr_26552_26640 = state_26532__$1;
(statearr_26552_26640[(2)] = inst_26519);

(statearr_26552_26640[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26553 = [null,null,null,null,null,null,null,null,null];
(statearr_26553[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26553[(1)] = (1));

return statearr_26553;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26532){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26554){var ex__2749__auto__ = e26554;
var statearr_26555_26641 = state_26532;
(statearr_26555_26641[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26532[(4)]))){
var statearr_26556_26642 = state_26532;
(statearr_26556_26642[(1)] = cljs.core.first.call(null,(state_26532[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26643 = state_26532;
state_26532 = G__26643;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26532){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26557 = f__2769__auto__.call(null);
(statearr_26557[(6)] = c__2768__auto__);

return statearr_26557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26593){
var state_val_26594 = (state_26593[(1)]);
if((state_val_26594 === (7))){
var inst_26567 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26593__$1 = state_26593;
var statearr_26595_26644 = state_26593__$1;
(statearr_26595_26644[(2)] = inst_26567);

(statearr_26595_26644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (1))){
var state_26593__$1 = state_26593;
var statearr_26596_26645 = state_26593__$1;
(statearr_26596_26645[(2)] = null);

(statearr_26596_26645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (4))){
var inst_26558 = (state_26593[(2)]);
var state_26593__$1 = state_26593;
var statearr_26597_26646 = state_26593__$1;
(statearr_26597_26646[(2)] = inst_26558);

(statearr_26597_26646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (15))){
var inst_26588 = (state_26593[(2)]);
var _ = (function (){var statearr_26598 = state_26593;
(statearr_26598[(4)] = cljs.core.rest.call(null,(state_26593[(4)])));

return statearr_26598;
})();
var state_26593__$1 = state_26593;
var statearr_26599_26647 = state_26593__$1;
(statearr_26599_26647[(2)] = inst_26588);

(statearr_26599_26647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (13))){
var inst_26573 = (state_26593[(7)]);
var inst_26579 = clojure.string.includes_QMARK_.call(null,inst_26573,":");
var state_26593__$1 = state_26593;
if(inst_26579){
var statearr_26600_26648 = state_26593__$1;
(statearr_26600_26648[(1)] = (16));

} else {
var statearr_26601_26649 = state_26593__$1;
(statearr_26601_26649[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (6))){
var state_26593__$1 = state_26593;
var statearr_26602_26650 = state_26593__$1;
(statearr_26602_26650[(2)] = pred);

(statearr_26602_26650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (17))){
var inst_26573 = (state_26593[(7)]);
var state_26593__$1 = state_26593;
var statearr_26603_26651 = state_26593__$1;
(statearr_26603_26651[(2)] = inst_26573);

(statearr_26603_26651[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (3))){
var inst_26591 = (state_26593[(2)]);
var state_26593__$1 = state_26593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26593__$1,inst_26591);
} else {
if((state_val_26594 === (12))){
var inst_26577 = (state_26593[(2)]);
var state_26593__$1 = state_26593;
if(cljs.core.truth_(inst_26577)){
var statearr_26604_26652 = state_26593__$1;
(statearr_26604_26652[(1)] = (13));

} else {
var statearr_26605_26653 = state_26593__$1;
(statearr_26605_26653[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (2))){
var _ = (function (){var statearr_26606 = state_26593;
(statearr_26606[(4)] = cljs.core.cons.call(null,(5),(state_26593[(4)])));

return statearr_26606;
})();
var inst_26564 = typeof pred === 'string';
var state_26593__$1 = state_26593;
if(cljs.core.truth_(inst_26564)){
var statearr_26607_26654 = state_26593__$1;
(statearr_26607_26654[(1)] = (6));

} else {
var statearr_26608_26655 = state_26593__$1;
(statearr_26608_26655[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (11))){
var inst_26569 = (state_26593[(8)]);
var state_26593__$1 = state_26593;
var statearr_26610_26656 = state_26593__$1;
(statearr_26610_26656[(2)] = inst_26569);

(statearr_26610_26656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (9))){
var inst_26569 = (state_26593[(8)]);
var inst_26572 = (state_26593[(2)]);
var inst_26573 = fluree.db.util.async.throw_err.call(null,inst_26572);
var state_26593__$1 = (function (){var statearr_26611 = state_26593;
(statearr_26611[(7)] = inst_26573);

return statearr_26611;
})();
if(cljs.core.truth_(inst_26569)){
var statearr_26612_26657 = state_26593__$1;
(statearr_26612_26657[(1)] = (10));

} else {
var statearr_26613_26658 = state_26593__$1;
(statearr_26613_26658[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (5))){
var _ = (function (){var statearr_26614 = state_26593;
(statearr_26614[(4)] = cljs.core.rest.call(null,(state_26593[(4)])));

return statearr_26614;
})();
var state_26593__$1 = state_26593;
var ex26609 = (state_26593__$1[(2)]);
var statearr_26615_26659 = state_26593__$1;
(statearr_26615_26659[(5)] = ex26609);


if((ex26609 instanceof Error)){
var statearr_26616_26660 = state_26593__$1;
(statearr_26616_26660[(1)] = (4));

(statearr_26616_26660[(5)] = null);

} else {
throw ex26609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (14))){
var state_26593__$1 = state_26593;
var statearr_26617_26661 = state_26593__$1;
(statearr_26617_26661[(2)] = null);

(statearr_26617_26661[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (16))){
var inst_26573 = (state_26593[(7)]);
var inst_26581 = clojure.string.split.call(null,inst_26573,/:/);
var inst_26582 = cljs.core.second.call(null,inst_26581);
var state_26593__$1 = state_26593;
var statearr_26618_26662 = state_26593__$1;
(statearr_26618_26662[(2)] = inst_26582);

(statearr_26618_26662[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (10))){
var inst_26573 = (state_26593[(7)]);
var state_26593__$1 = state_26593;
var statearr_26619_26663 = state_26593__$1;
(statearr_26619_26663[(2)] = inst_26573);

(statearr_26619_26663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (18))){
var inst_26585 = (state_26593[(2)]);
var state_26593__$1 = state_26593;
var statearr_26620_26664 = state_26593__$1;
(statearr_26620_26664[(2)] = inst_26585);

(statearr_26620_26664[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26594 === (8))){
var inst_26569 = (state_26593[(2)]);
var inst_26570 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_26593__$1 = (function (){var statearr_26621 = state_26593;
(statearr_26621[(8)] = inst_26569);

return statearr_26621;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26593__$1,(9),inst_26570);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26622 = [null,null,null,null,null,null,null,null,null];
(statearr_26622[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26622[(1)] = (1));

return statearr_26622;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26593){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26623){var ex__2749__auto__ = e26623;
var statearr_26624_26665 = state_26593;
(statearr_26624_26665[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26593[(4)]))){
var statearr_26625_26666 = state_26593;
(statearr_26625_26666[(1)] = cljs.core.first.call(null,(state_26593[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26667 = state_26593;
state_26593 = G__26667;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26593){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26626 = f__2769__auto__.call(null);
(statearr_26626[(6)] = c__2768__auto__);

return statearr_26626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26669 = arguments.length;
switch (G__26669) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26702){
var state_val_26703 = (state_26702[(1)]);
if((state_val_26703 === (7))){
var state_26702__$1 = state_26702;
var statearr_26704_26792 = state_26702__$1;
(statearr_26704_26792[(2)] = null);

(statearr_26704_26792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (1))){
var state_26702__$1 = state_26702;
var statearr_26705_26793 = state_26702__$1;
(statearr_26705_26793[(2)] = null);

(statearr_26705_26793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (4))){
var inst_26670 = (state_26702[(2)]);
var state_26702__$1 = state_26702;
var statearr_26706_26794 = state_26702__$1;
(statearr_26706_26794[(2)] = inst_26670);

(statearr_26706_26794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (6))){
var inst_26685 = (state_26702[(7)]);
var inst_26684 = (state_26702[(2)]);
var inst_26685__$1 = fluree.db.util.async.throw_err.call(null,inst_26684);
var inst_26686 = (inst_26685__$1 == null);
var state_26702__$1 = (function (){var statearr_26707 = state_26702;
(statearr_26707[(7)] = inst_26685__$1);

return statearr_26707;
})();
if(cljs.core.truth_(inst_26686)){
var statearr_26708_26795 = state_26702__$1;
(statearr_26708_26795[(1)] = (7));

} else {
var statearr_26709_26796 = state_26702__$1;
(statearr_26709_26796[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (3))){
var inst_26700 = (state_26702[(2)]);
var state_26702__$1 = state_26702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26702__$1,inst_26700);
} else {
if((state_val_26703 === (12))){
var inst_26697 = (state_26702[(2)]);
var _ = (function (){var statearr_26710 = state_26702;
(statearr_26710[(4)] = cljs.core.rest.call(null,(state_26702[(4)])));

return statearr_26710;
})();
var state_26702__$1 = state_26702;
var statearr_26711_26797 = state_26702__$1;
(statearr_26711_26797[(2)] = inst_26697);

(statearr_26711_26797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (2))){
var _ = (function (){var statearr_26712 = state_26702;
(statearr_26712[(4)] = cljs.core.cons.call(null,(5),(state_26702[(4)])));

return statearr_26712;
})();
var inst_26676 = (30);
var inst_26678 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26680 = [inst_26676,tag_name];
var inst_26681 = (new cljs.core.PersistentVector(null,2,(5),inst_26679,inst_26680,null));
var inst_26682 = fluree.db.query.range.index_range.call(null,inst_26678,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26681);
var state_26702__$1 = state_26702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26702__$1,(6),inst_26682);
} else {
if((state_val_26703 === (11))){
var inst_26691 = (state_26702[(8)]);
var inst_26695 = fluree.db.flake.s.call(null,inst_26691);
var state_26702__$1 = state_26702;
var statearr_26714_26798 = state_26702__$1;
(statearr_26714_26798[(2)] = inst_26695);

(statearr_26714_26798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (9))){
var inst_26691 = (state_26702[(8)]);
var inst_26691__$1 = (state_26702[(2)]);
var inst_26692 = (inst_26691__$1 == null);
var state_26702__$1 = (function (){var statearr_26715 = state_26702;
(statearr_26715[(8)] = inst_26691__$1);

return statearr_26715;
})();
if(cljs.core.truth_(inst_26692)){
var statearr_26716_26799 = state_26702__$1;
(statearr_26716_26799[(1)] = (10));

} else {
var statearr_26717_26800 = state_26702__$1;
(statearr_26717_26800[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (5))){
var _ = (function (){var statearr_26718 = state_26702;
(statearr_26718[(4)] = cljs.core.rest.call(null,(state_26702[(4)])));

return statearr_26718;
})();
var state_26702__$1 = state_26702;
var ex26713 = (state_26702__$1[(2)]);
var statearr_26719_26801 = state_26702__$1;
(statearr_26719_26801[(5)] = ex26713);


if((ex26713 instanceof Error)){
var statearr_26720_26802 = state_26702__$1;
(statearr_26720_26802[(1)] = (4));

(statearr_26720_26802[(5)] = null);

} else {
throw ex26713;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (10))){
var state_26702__$1 = state_26702;
var statearr_26721_26803 = state_26702__$1;
(statearr_26721_26803[(2)] = null);

(statearr_26721_26803[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26703 === (8))){
var inst_26685 = (state_26702[(7)]);
var inst_26689 = cljs.core.first.call(null,inst_26685);
var state_26702__$1 = state_26702;
var statearr_26722_26804 = state_26702__$1;
(statearr_26722_26804[(2)] = inst_26689);

(statearr_26722_26804[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26723 = [null,null,null,null,null,null,null,null,null];
(statearr_26723[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26723[(1)] = (1));

return statearr_26723;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26702){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26724){var ex__2749__auto__ = e26724;
var statearr_26725_26805 = state_26702;
(statearr_26725_26805[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26702[(4)]))){
var statearr_26726_26806 = state_26702;
(statearr_26726_26806[(1)] = cljs.core.first.call(null,(state_26702[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26807 = state_26702;
state_26702 = G__26807;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26702){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26727 = f__2769__auto__.call(null);
(statearr_26727[(6)] = c__2768__auto__);

return statearr_26727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26762){
var state_val_26763 = (state_26762[(1)]);
if((state_val_26763 === (7))){
var inst_26741 = typeof pred === 'string';
var state_26762__$1 = state_26762;
if(cljs.core.truth_(inst_26741)){
var statearr_26764_26808 = state_26762__$1;
(statearr_26764_26808[(1)] = (10));

} else {
var statearr_26765_26809 = state_26762__$1;
(statearr_26765_26809[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (1))){
var state_26762__$1 = state_26762;
var statearr_26766_26810 = state_26762__$1;
(statearr_26766_26810[(2)] = null);

(statearr_26766_26810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (4))){
var inst_26728 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
var statearr_26767_26811 = state_26762__$1;
(statearr_26767_26811[(2)] = inst_26728);

(statearr_26767_26811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (15))){
var inst_26755 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
var statearr_26768_26812 = state_26762__$1;
(statearr_26768_26812[(2)] = inst_26755);

(statearr_26768_26812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (13))){
var inst_26746 = (state_26762[(7)]);
var inst_26748 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26746),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26749 = fluree.db.dbproto._tag_id.call(null,this$,inst_26748);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26762__$1,(16),inst_26749);
} else {
if((state_val_26763 === (6))){
var inst_26736 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26762__$1,(9),inst_26736);
} else {
if((state_val_26763 === (3))){
var inst_26760 = (state_26762[(2)]);
var state_26762__$1 = state_26762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26762__$1,inst_26760);
} else {
if((state_val_26763 === (12))){
var inst_26746 = (state_26762[(7)]);
var inst_26746__$1 = (state_26762[(2)]);
var state_26762__$1 = (function (){var statearr_26769 = state_26762;
(statearr_26769[(7)] = inst_26746__$1);

return statearr_26769;
})();
if(cljs.core.truth_(inst_26746__$1)){
var statearr_26770_26813 = state_26762__$1;
(statearr_26770_26813[(1)] = (13));

} else {
var statearr_26771_26814 = state_26762__$1;
(statearr_26771_26814[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (2))){
var _ = (function (){var statearr_26772 = state_26762;
(statearr_26772[(4)] = cljs.core.cons.call(null,(5),(state_26762[(4)])));

return statearr_26772;
})();
var inst_26734 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_26762__$1 = state_26762;
if(inst_26734){
var statearr_26773_26815 = state_26762__$1;
(statearr_26773_26815[(1)] = (6));

} else {
var statearr_26774_26816 = state_26762__$1;
(statearr_26774_26816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (11))){
var inst_26744 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26762__$1 = state_26762;
var statearr_26776_26817 = state_26762__$1;
(statearr_26776_26817[(2)] = inst_26744);

(statearr_26776_26817[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (9))){
var inst_26738 = (state_26762[(2)]);
var inst_26739 = fluree.db.util.async.throw_err.call(null,inst_26738);
var state_26762__$1 = state_26762;
var statearr_26777_26818 = state_26762__$1;
(statearr_26777_26818[(2)] = inst_26739);

(statearr_26777_26818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (5))){
var _ = (function (){var statearr_26778 = state_26762;
(statearr_26778[(4)] = cljs.core.rest.call(null,(state_26762[(4)])));

return statearr_26778;
})();
var state_26762__$1 = state_26762;
var ex26775 = (state_26762__$1[(2)]);
var statearr_26779_26819 = state_26762__$1;
(statearr_26779_26819[(5)] = ex26775);


if((ex26775 instanceof Error)){
var statearr_26780_26820 = state_26762__$1;
(statearr_26780_26820[(1)] = (4));

(statearr_26780_26820[(5)] = null);

} else {
throw ex26775;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (14))){
var state_26762__$1 = state_26762;
var statearr_26781_26821 = state_26762__$1;
(statearr_26781_26821[(2)] = null);

(statearr_26781_26821[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (16))){
var inst_26751 = (state_26762[(2)]);
var inst_26752 = fluree.db.util.async.throw_err.call(null,inst_26751);
var state_26762__$1 = state_26762;
var statearr_26782_26822 = state_26762__$1;
(statearr_26782_26822[(2)] = inst_26752);

(statearr_26782_26822[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (10))){
var state_26762__$1 = state_26762;
var statearr_26783_26823 = state_26762__$1;
(statearr_26783_26823[(2)] = pred);

(statearr_26783_26823[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26763 === (8))){
var inst_26757 = (state_26762[(2)]);
var _ = (function (){var statearr_26784 = state_26762;
(statearr_26784[(4)] = cljs.core.rest.call(null,(state_26762[(4)])));

return statearr_26784;
})();
var state_26762__$1 = state_26762;
var statearr_26785_26824 = state_26762__$1;
(statearr_26785_26824[(2)] = inst_26757);

(statearr_26785_26824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26786 = [null,null,null,null,null,null,null,null];
(statearr_26786[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26786[(1)] = (1));

return statearr_26786;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26762){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26787){var ex__2749__auto__ = e26787;
var statearr_26788_26825 = state_26762;
(statearr_26788_26825[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26762[(4)]))){
var statearr_26789_26826 = state_26762;
(statearr_26789_26826[(1)] = cljs.core.first.call(null,(state_26762[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26827 = state_26762;
state_26762 = G__26827;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26762){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26790 = f__2769__auto__.call(null);
(statearr_26790[(6)] = c__2768__auto__);

return statearr_26790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k26829,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__26833 = k26829;
var G__26833__$1 = (((G__26833 instanceof cljs.core.Keyword))?G__26833.fqn:null);
switch (G__26833__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26829,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__26834){
var vec__26835 = p__26834;
var k__5367__auto__ = cljs.core.nth.call(null,vec__26835,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__26835,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26828){
var self__ = this;
var G__26828__$1 = this;
return (new cljs.core.RecordIter((0),G__26828__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26830,other26831){
var self__ = this;
var this26830__$1 = this;
return (((!((other26831 == null)))) && ((((this26830__$1.constructor === other26831.constructor)) && (((cljs.core._EQ_.call(null,this26830__$1.conn,other26831.conn)) && (((cljs.core._EQ_.call(null,this26830__$1.network,other26831.network)) && (((cljs.core._EQ_.call(null,this26830__$1.ledger_id,other26831.ledger_id)) && (((cljs.core._EQ_.call(null,this26830__$1.block,other26831.block)) && (((cljs.core._EQ_.call(null,this26830__$1.t,other26831.t)) && (((cljs.core._EQ_.call(null,this26830__$1.tt_id,other26831.tt_id)) && (((cljs.core._EQ_.call(null,this26830__$1.stats,other26831.stats)) && (((cljs.core._EQ_.call(null,this26830__$1.spot,other26831.spot)) && (((cljs.core._EQ_.call(null,this26830__$1.psot,other26831.psot)) && (((cljs.core._EQ_.call(null,this26830__$1.post,other26831.post)) && (((cljs.core._EQ_.call(null,this26830__$1.opst,other26831.opst)) && (((cljs.core._EQ_.call(null,this26830__$1.tspo,other26831.tspo)) && (((cljs.core._EQ_.call(null,this26830__$1.schema,other26831.schema)) && (((cljs.core._EQ_.call(null,this26830__$1.settings,other26831.settings)) && (((cljs.core._EQ_.call(null,this26830__$1.comparators,other26831.comparators)) && (((cljs.core._EQ_.call(null,this26830__$1.schema_cache,other26831.schema_cache)) && (((cljs.core._EQ_.call(null,this26830__$1.novelty,other26831.novelty)) && (((cljs.core._EQ_.call(null,this26830__$1.permissions,other26831.permissions)) && (((cljs.core._EQ_.call(null,this26830__$1.fork,other26831.fork)) && (((cljs.core._EQ_.call(null,this26830__$1.fork_block,other26831.fork_block)) && (((cljs.core._EQ_.call(null,this26830__$1.current_db_fn,other26831.current_db_fn)) && (cljs.core._EQ_.call(null,this26830__$1.__extmap,other26831.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k26829){
var self__ = this;
var this__5350__auto____$1 = this;
var G__26838 = k26829;
var G__26838__$1 = (((G__26838 instanceof cljs.core.Keyword))?G__26838.fqn:null);
switch (G__26838__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26829);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__26828){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__26839 = cljs.core.keyword_identical_QMARK_;
var expr__26840 = k__5352__auto__;
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26840))){
return (new fluree.db.graphdb.GraphDb(G__26828,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26828,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26828,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26828,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26828,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26828,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26828,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26828,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26828,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26828,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26828,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26828,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26828,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26828,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26828,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26828,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26828,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26828,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26828,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26828,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26839.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__26840))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26828,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__26828),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__26828){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26828,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26832){
var extmap__5385__auto__ = (function (){var G__26842 = cljs.core.dissoc.call(null,G__26832,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__26832)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26842);
} else {
return G__26842;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26832),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26832),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__26845 = fluree.db.index.default_comparators;
var map__26845__$1 = cljs.core.__destructure_map.call(null,map__26845);
var spot_cmp = cljs.core.get.call(null,map__26845__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__26845__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__26845__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__26845__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__26845__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
