// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___61829 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61880){
var state_val_61881 = (state_61880[(1)]);
if((state_val_61881 === (7))){
var inst_61875 = (state_61880[(2)]);
var _ = (function (){var statearr_61882 = state_61880;
(statearr_61882[(4)] = cljs.core.rest.call(null,(state_61880[(4)])));

return statearr_61882;
})();
var state_61880__$1 = state_61880;
var statearr_61883_61910 = state_61880__$1;
(statearr_61883_61910[(2)] = inst_61875);

(statearr_61883_61910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (1))){
var state_61880__$1 = state_61880;
var statearr_61884_61911 = state_61880__$1;
(statearr_61884_61911[(2)] = null);

(statearr_61884_61911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (4))){
var inst_61830 = (state_61880[(2)]);
var state_61880__$1 = state_61880;
var statearr_61885_61912 = state_61880__$1;
(statearr_61885_61912[(2)] = inst_61830);

(statearr_61885_61912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (13))){
var inst_61871 = (state_61880[(2)]);
var state_61880__$1 = state_61880;
var statearr_61886_61913 = state_61880__$1;
(statearr_61886_61913[(2)] = inst_61871);

(statearr_61886_61913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (6))){
var inst_61855 = (state_61880[(7)]);
var inst_61848 = (state_61880[(8)]);
var inst_61854 = cljs.core.seq.call(null,inst_61848);
var inst_61855__$1 = cljs.core.first.call(null,inst_61854);
var inst_61856 = cljs.core.next.call(null,inst_61854);
var inst_61857 = cljs.core.not.call(null,inst_61855__$1);
var state_61880__$1 = (function (){var statearr_61887 = state_61880;
(statearr_61887[(7)] = inst_61855__$1);

(statearr_61887[(9)] = inst_61856);

return statearr_61887;
})();
if(inst_61857){
var statearr_61888_61914 = state_61880__$1;
(statearr_61888_61914[(1)] = (8));

} else {
var statearr_61889_61915 = state_61880__$1;
(statearr_61889_61915[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (3))){
var inst_61878 = (state_61880[(2)]);
var state_61880__$1 = state_61880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61880__$1,inst_61878);
} else {
if((state_val_61881 === (12))){
var inst_61855 = (state_61880[(7)]);
var inst_61849 = (state_61880[(10)]);
var inst_61856 = (state_61880[(9)]);
var inst_61868 = cljs.core.conj.call(null,inst_61849,inst_61855);
var inst_61848 = inst_61856;
var inst_61849__$1 = inst_61868;
var state_61880__$1 = (function (){var statearr_61890 = state_61880;
(statearr_61890[(10)] = inst_61849__$1);

(statearr_61890[(8)] = inst_61848);

return statearr_61890;
})();
var statearr_61891_61916 = state_61880__$1;
(statearr_61891_61916[(2)] = null);

(statearr_61891_61916[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (2))){
var _ = (function (){var statearr_61892 = state_61880;
(statearr_61892[(4)] = cljs.core.cons.call(null,(5),(state_61880[(4)])));

return statearr_61892;
})();
var inst_61843 = args;
var inst_61844 = cljs.core.seq.call(null,inst_61843);
var inst_61845 = cljs.core.first.call(null,inst_61844);
var inst_61846 = cljs.core.next.call(null,inst_61844);
var inst_61847 = cljs.core.PersistentVector.EMPTY;
var inst_61848 = inst_61843;
var inst_61849 = inst_61847;
var state_61880__$1 = (function (){var statearr_61893 = state_61880;
(statearr_61893[(11)] = inst_61845);

(statearr_61893[(12)] = inst_61846);

(statearr_61893[(10)] = inst_61849);

(statearr_61893[(8)] = inst_61848);

return statearr_61893;
})();
var statearr_61894_61917 = state_61880__$1;
(statearr_61894_61917[(2)] = null);

(statearr_61894_61917[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (11))){
var inst_61855 = (state_61880[(7)]);
var state_61880__$1 = state_61880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61880__$1,(14),inst_61855);
} else {
if((state_val_61881 === (9))){
var inst_61855 = (state_61880[(7)]);
var inst_61860 = fluree.db.util.async.channel_QMARK_.call(null,inst_61855);
var state_61880__$1 = state_61880;
if(inst_61860){
var statearr_61896_61918 = state_61880__$1;
(statearr_61896_61918[(1)] = (11));

} else {
var statearr_61897_61919 = state_61880__$1;
(statearr_61897_61919[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (5))){
var _ = (function (){var statearr_61898 = state_61880;
(statearr_61898[(4)] = cljs.core.rest.call(null,(state_61880[(4)])));

return statearr_61898;
})();
var state_61880__$1 = state_61880;
var ex61895 = (state_61880__$1[(2)]);
var statearr_61899_61920 = state_61880__$1;
(statearr_61899_61920[(5)] = ex61895);


if((ex61895 instanceof Error)){
var statearr_61900_61921 = state_61880__$1;
(statearr_61900_61921[(1)] = (4));

(statearr_61900_61921[(5)] = null);

} else {
throw ex61895;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (14))){
var inst_61849 = (state_61880[(10)]);
var inst_61856 = (state_61880[(9)]);
var inst_61863 = (state_61880[(2)]);
var inst_61864 = fluree.db.util.async.throw_err.call(null,inst_61863);
var inst_61865 = cljs.core.conj.call(null,inst_61849,inst_61864);
var inst_61848 = inst_61856;
var inst_61849__$1 = inst_61865;
var state_61880__$1 = (function (){var statearr_61901 = state_61880;
(statearr_61901[(10)] = inst_61849__$1);

(statearr_61901[(8)] = inst_61848);

return statearr_61901;
})();
var statearr_61902_61922 = state_61880__$1;
(statearr_61902_61922[(2)] = null);

(statearr_61902_61922[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (10))){
var inst_61873 = (state_61880[(2)]);
var state_61880__$1 = state_61880;
var statearr_61903_61923 = state_61880__$1;
(statearr_61903_61923[(2)] = inst_61873);

(statearr_61903_61923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61881 === (8))){
var inst_61849 = (state_61880[(10)]);
var state_61880__$1 = state_61880;
var statearr_61904_61924 = state_61880__$1;
(statearr_61904_61924[(2)] = inst_61849);

(statearr_61904_61924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_61905 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61905[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_61905[(1)] = (1));

return statearr_61905;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_61880){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61906){var ex__2749__auto__ = e61906;
var statearr_61907_61925 = state_61880;
(statearr_61907_61925[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61880[(4)]))){
var statearr_61908_61926 = state_61880;
(statearr_61908_61926[(1)] = cljs.core.first.call(null,(state_61880[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61927 = state_61880;
state_61880 = G__61927;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_61880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_61880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61909 = f__2769__auto__.call(null);
(statearr_61909[(6)] = c__2768__auto__);

return statearr_61909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__61929 = entry;
var res = cljs.core.nth.call(null,vec__61929,(0),null);
var cost = cljs.core.nth.call(null,vec__61929,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__61928_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__61928_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61977){
var state_val_61978 = (state_61977[(1)]);
if((state_val_61978 === (7))){
var state_61977__$1 = state_61977;
var statearr_61979_62008 = state_61977__$1;
(statearr_61979_62008[(2)] = coll);

(statearr_61979_62008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (1))){
var state_61977__$1 = state_61977;
var statearr_61980_62009 = state_61977__$1;
(statearr_61980_62009[(2)] = null);

(statearr_61980_62009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (4))){
var inst_61932 = (state_61977[(2)]);
var state_61977__$1 = state_61977;
var statearr_61981_62010 = state_61977__$1;
(statearr_61981_62010[(2)] = inst_61932);

(statearr_61981_62010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (15))){
var inst_61951 = (state_61977[(7)]);
var inst_61959 = (state_61977[(2)]);
var inst_61960 = fluree.db.dbfunctions.internal.nth.call(null,inst_61951,inst_61959);
var inst_61961 = cljs.core.count.call(null,inst_61951);
var inst_61962 = ((9) + inst_61961);
var inst_61963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61964 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61966 = [inst_61951,inst_61959];
var inst_61967 = (new cljs.core.PersistentVector(null,2,(5),inst_61965,inst_61966,null));
var inst_61968 = ["nth",inst_61967,inst_61960];
var inst_61969 = cljs.core.PersistentHashMap.fromArrays(inst_61964,inst_61968);
var inst_61970 = [inst_61969,inst_61962];
var inst_61971 = (new cljs.core.PersistentVector(null,2,(5),inst_61963,inst_61970,null));
var inst_61972 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61971);
var _ = (function (){var statearr_61982 = state_61977;
(statearr_61982[(4)] = cljs.core.rest.call(null,(state_61977[(4)])));

return statearr_61982;
})();
var state_61977__$1 = (function (){var statearr_61983 = state_61977;
(statearr_61983[(8)] = inst_61972);

return statearr_61983;
})();
var statearr_61984_62011 = state_61977__$1;
(statearr_61984_62011[(2)] = inst_61960);

(statearr_61984_62011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (13))){
var state_61977__$1 = state_61977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61977__$1,(16),key);
} else {
if((state_val_61978 === (6))){
var state_61977__$1 = state_61977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61977__$1,(9),coll);
} else {
if((state_val_61978 === (3))){
var inst_61975 = (state_61977[(2)]);
var state_61977__$1 = state_61977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61977__$1,inst_61975);
} else {
if((state_val_61978 === (12))){
var inst_61951 = (state_61977[(2)]);
var inst_61952 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_61977__$1 = (function (){var statearr_61985 = state_61977;
(statearr_61985[(7)] = inst_61951);

return statearr_61985;
})();
if(inst_61952){
var statearr_61986_62012 = state_61977__$1;
(statearr_61986_62012[(1)] = (13));

} else {
var statearr_61987_62013 = state_61977__$1;
(statearr_61987_62013[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (2))){
var _ = (function (){var statearr_61988 = state_61977;
(statearr_61988[(4)] = cljs.core.cons.call(null,(5),(state_61977[(4)])));

return statearr_61988;
})();
var inst_61938 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_61977__$1 = state_61977;
if(inst_61938){
var statearr_61989_62014 = state_61977__$1;
(statearr_61989_62014[(1)] = (6));

} else {
var statearr_61990_62015 = state_61977__$1;
(statearr_61990_62015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (11))){
var inst_61945 = (state_61977[(9)]);
var state_61977__$1 = state_61977;
var statearr_61992_62016 = state_61977__$1;
(statearr_61992_62016[(2)] = inst_61945);

(statearr_61992_62016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (9))){
var inst_61941 = (state_61977[(2)]);
var inst_61942 = fluree.db.util.async.throw_err.call(null,inst_61941);
var state_61977__$1 = state_61977;
var statearr_61993_62017 = state_61977__$1;
(statearr_61993_62017[(2)] = inst_61942);

(statearr_61993_62017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (5))){
var _ = (function (){var statearr_61994 = state_61977;
(statearr_61994[(4)] = cljs.core.rest.call(null,(state_61977[(4)])));

return statearr_61994;
})();
var state_61977__$1 = state_61977;
var ex61991 = (state_61977__$1[(2)]);
var statearr_61995_62018 = state_61977__$1;
(statearr_61995_62018[(5)] = ex61991);


if((ex61991 instanceof Error)){
var statearr_61996_62019 = state_61977__$1;
(statearr_61996_62019[(1)] = (4));

(statearr_61996_62019[(5)] = null);

} else {
throw ex61991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (14))){
var state_61977__$1 = state_61977;
var statearr_61997_62020 = state_61977__$1;
(statearr_61997_62020[(2)] = key);

(statearr_61997_62020[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (16))){
var inst_61955 = (state_61977[(2)]);
var inst_61956 = fluree.db.util.async.throw_err.call(null,inst_61955);
var state_61977__$1 = state_61977;
var statearr_61998_62021 = state_61977__$1;
(statearr_61998_62021[(2)] = inst_61956);

(statearr_61998_62021[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (10))){
var inst_61945 = (state_61977[(9)]);
var inst_61948 = cljs.core.vec.call(null,inst_61945);
var state_61977__$1 = state_61977;
var statearr_61999_62022 = state_61977__$1;
(statearr_61999_62022[(2)] = inst_61948);

(statearr_61999_62022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61978 === (8))){
var inst_61945 = (state_61977[(9)]);
var inst_61945__$1 = (state_61977[(2)]);
var inst_61946 = cljs.core.set_QMARK_.call(null,inst_61945__$1);
var state_61977__$1 = (function (){var statearr_62000 = state_61977;
(statearr_62000[(9)] = inst_61945__$1);

return statearr_62000;
})();
if(inst_61946){
var statearr_62001_62023 = state_61977__$1;
(statearr_62001_62023[(1)] = (10));

} else {
var statearr_62002_62024 = state_61977__$1;
(statearr_62002_62024[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_62003 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62003[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_62003[(1)] = (1));

return statearr_62003;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_61977){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62004){var ex__2749__auto__ = e62004;
var statearr_62005_62025 = state_61977;
(statearr_62005_62025[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61977[(4)]))){
var statearr_62006_62026 = state_61977;
(statearr_62006_62026[(1)] = cljs.core.first.call(null,(state_61977[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62027 = state_61977;
state_61977 = G__62027;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_61977){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_61977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62007 = f__2769__auto__.call(null);
(statearr_62007[(6)] = c__2768__auto__);

return statearr_62007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62088){
var state_val_62089 = (state_62088[(1)]);
if((state_val_62089 === (7))){
var state_62088__$1 = state_62088;
var statearr_62090_62124 = state_62088__$1;
(statearr_62090_62124[(2)] = test);

(statearr_62090_62124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (20))){
var inst_62062 = (state_62088[(2)]);
var inst_62063 = fluree.db.util.async.throw_err.call(null,inst_62062);
var state_62088__$1 = state_62088;
var statearr_62091_62125 = state_62088__$1;
(statearr_62091_62125[(2)] = inst_62063);

(statearr_62091_62125[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (1))){
var state_62088__$1 = state_62088;
var statearr_62092_62126 = state_62088__$1;
(statearr_62092_62126[(2)] = null);

(statearr_62092_62126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (4))){
var inst_62028 = (state_62088[(2)]);
var state_62088__$1 = state_62088;
var statearr_62093_62127 = state_62088__$1;
(statearr_62093_62127[(2)] = inst_62028);

(statearr_62093_62127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (15))){
var inst_62046 = (state_62088[(7)]);
var inst_62054 = (state_62088[(2)]);
var inst_62055 = [inst_62054,f];
var inst_62056 = (new cljs.core.PersistentVector(null,2,(5),inst_62046,inst_62055,null));
var state_62088__$1 = state_62088;
var statearr_62094_62128 = state_62088__$1;
(statearr_62094_62128[(2)] = inst_62056);

(statearr_62094_62128[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (13))){
var state_62088__$1 = state_62088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62088__$1,(16),t);
} else {
if((state_val_62089 === (6))){
var state_62088__$1 = state_62088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62088__$1,(9),test);
} else {
if((state_val_62089 === (17))){
var state_62088__$1 = state_62088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62088__$1,(20),f);
} else {
if((state_val_62089 === (3))){
var inst_62086 = (state_62088[(2)]);
var state_62088__$1 = state_62088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62088__$1,inst_62086);
} else {
if((state_val_62089 === (12))){
var inst_62044 = (state_62088[(8)]);
var inst_62070 = (state_62088[(2)]);
var inst_62071 = cljs.core.nth.call(null,inst_62070,(0),null);
var inst_62072 = cljs.core.nth.call(null,inst_62070,(1),null);
var inst_62073 = fluree.db.dbfunctions.internal.if_else.call(null,inst_62044,inst_62071,inst_62072);
var inst_62074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62075 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62077 = [inst_62044,inst_62071,inst_62072];
var inst_62078 = (new cljs.core.PersistentVector(null,3,(5),inst_62076,inst_62077,null));
var inst_62079 = ["if-else",inst_62078,inst_62073];
var inst_62080 = cljs.core.PersistentHashMap.fromArrays(inst_62075,inst_62079);
var inst_62081 = [inst_62080,(10)];
var inst_62082 = (new cljs.core.PersistentVector(null,2,(5),inst_62074,inst_62081,null));
var inst_62083 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62082);
var _ = (function (){var statearr_62095 = state_62088;
(statearr_62095[(4)] = cljs.core.rest.call(null,(state_62088[(4)])));

return statearr_62095;
})();
var state_62088__$1 = (function (){var statearr_62096 = state_62088;
(statearr_62096[(9)] = inst_62083);

return statearr_62096;
})();
var statearr_62097_62129 = state_62088__$1;
(statearr_62097_62129[(2)] = inst_62073);

(statearr_62097_62129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (2))){
var _ = (function (){var statearr_62098 = state_62088;
(statearr_62098[(4)] = cljs.core.cons.call(null,(5),(state_62088[(4)])));

return statearr_62098;
})();
var inst_62037 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_62088__$1 = state_62088;
if(inst_62037){
var statearr_62099_62130 = state_62088__$1;
(statearr_62099_62130[(1)] = (6));

} else {
var statearr_62100_62131 = state_62088__$1;
(statearr_62100_62131[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (19))){
var inst_62058 = (state_62088[(10)]);
var inst_62066 = (state_62088[(2)]);
var inst_62067 = [f,inst_62066];
var inst_62068 = (new cljs.core.PersistentVector(null,2,(5),inst_62058,inst_62067,null));
var state_62088__$1 = state_62088;
var statearr_62101_62132 = state_62088__$1;
(statearr_62101_62132[(2)] = inst_62068);

(statearr_62101_62132[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (11))){
var inst_62058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62059 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_62088__$1 = (function (){var statearr_62103 = state_62088;
(statearr_62103[(10)] = inst_62058);

return statearr_62103;
})();
if(inst_62059){
var statearr_62104_62133 = state_62088__$1;
(statearr_62104_62133[(1)] = (17));

} else {
var statearr_62105_62134 = state_62088__$1;
(statearr_62105_62134[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (9))){
var inst_62040 = (state_62088[(2)]);
var inst_62041 = fluree.db.util.async.throw_err.call(null,inst_62040);
var state_62088__$1 = state_62088;
var statearr_62106_62135 = state_62088__$1;
(statearr_62106_62135[(2)] = inst_62041);

(statearr_62106_62135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (5))){
var _ = (function (){var statearr_62107 = state_62088;
(statearr_62107[(4)] = cljs.core.rest.call(null,(state_62088[(4)])));

return statearr_62107;
})();
var state_62088__$1 = state_62088;
var ex62102 = (state_62088__$1[(2)]);
var statearr_62108_62136 = state_62088__$1;
(statearr_62108_62136[(5)] = ex62102);


if((ex62102 instanceof Error)){
var statearr_62109_62137 = state_62088__$1;
(statearr_62109_62137[(1)] = (4));

(statearr_62109_62137[(5)] = null);

} else {
throw ex62102;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (14))){
var state_62088__$1 = state_62088;
var statearr_62110_62138 = state_62088__$1;
(statearr_62110_62138[(2)] = t);

(statearr_62110_62138[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (16))){
var inst_62050 = (state_62088[(2)]);
var inst_62051 = fluree.db.util.async.throw_err.call(null,inst_62050);
var state_62088__$1 = state_62088;
var statearr_62111_62139 = state_62088__$1;
(statearr_62111_62139[(2)] = inst_62051);

(statearr_62111_62139[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (10))){
var inst_62046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62047 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_62088__$1 = (function (){var statearr_62112 = state_62088;
(statearr_62112[(7)] = inst_62046);

return statearr_62112;
})();
if(inst_62047){
var statearr_62113_62140 = state_62088__$1;
(statearr_62113_62140[(1)] = (13));

} else {
var statearr_62114_62141 = state_62088__$1;
(statearr_62114_62141[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (18))){
var state_62088__$1 = state_62088;
var statearr_62115_62142 = state_62088__$1;
(statearr_62115_62142[(2)] = f);

(statearr_62115_62142[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62089 === (8))){
var inst_62044 = (state_62088[(8)]);
var inst_62044__$1 = (state_62088[(2)]);
var state_62088__$1 = (function (){var statearr_62116 = state_62088;
(statearr_62116[(8)] = inst_62044__$1);

return statearr_62116;
})();
if(cljs.core.truth_(inst_62044__$1)){
var statearr_62117_62143 = state_62088__$1;
(statearr_62117_62143[(1)] = (10));

} else {
var statearr_62118_62144 = state_62088__$1;
(statearr_62118_62144[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_62119 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62119[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_62119[(1)] = (1));

return statearr_62119;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_62088){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62120){var ex__2749__auto__ = e62120;
var statearr_62121_62145 = state_62088;
(statearr_62121_62145[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62088[(4)]))){
var statearr_62122_62146 = state_62088;
(statearr_62122_62146[(1)] = cljs.core.first.call(null,(state_62088[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62147 = state_62088;
state_62088 = G__62147;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_62088){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_62088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62123 = f__2769__auto__.call(null);
(statearr_62123[(6)] = c__2768__auto__);

return statearr_62123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62177){
var state_val_62178 = (state_62177[(1)]);
if((state_val_62178 === (7))){
var state_62177__$1 = state_62177;
var statearr_62179_62198 = state_62177__$1;
(statearr_62179_62198[(2)] = arg);

(statearr_62179_62198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62178 === (1))){
var state_62177__$1 = state_62177;
var statearr_62180_62199 = state_62177__$1;
(statearr_62180_62199[(2)] = null);

(statearr_62180_62199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62178 === (4))){
var inst_62148 = (state_62177[(2)]);
var state_62177__$1 = state_62177;
var statearr_62181_62200 = state_62177__$1;
(statearr_62181_62200[(2)] = inst_62148);

(statearr_62181_62200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62178 === (6))){
var state_62177__$1 = state_62177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62177__$1,(9),arg);
} else {
if((state_val_62178 === (3))){
var inst_62175 = (state_62177[(2)]);
var state_62177__$1 = state_62177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62177__$1,inst_62175);
} else {
if((state_val_62178 === (2))){
var _ = (function (){var statearr_62183 = state_62177;
(statearr_62183[(4)] = cljs.core.cons.call(null,(5),(state_62177[(4)])));

return statearr_62183;
})();
var inst_62154 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_62177__$1 = state_62177;
if(inst_62154){
var statearr_62184_62201 = state_62177__$1;
(statearr_62184_62201[(1)] = (6));

} else {
var statearr_62185_62202 = state_62177__$1;
(statearr_62185_62202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62178 === (9))){
var inst_62157 = (state_62177[(2)]);
var inst_62158 = fluree.db.util.async.throw_err.call(null,inst_62157);
var state_62177__$1 = state_62177;
var statearr_62186_62203 = state_62177__$1;
(statearr_62186_62203[(2)] = inst_62158);

(statearr_62186_62203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62178 === (5))){
var _ = (function (){var statearr_62187 = state_62177;
(statearr_62187[(4)] = cljs.core.rest.call(null,(state_62177[(4)])));

return statearr_62187;
})();
var state_62177__$1 = state_62177;
var ex62182 = (state_62177__$1[(2)]);
var statearr_62188_62204 = state_62177__$1;
(statearr_62188_62204[(5)] = ex62182);


if((ex62182 instanceof Error)){
var statearr_62189_62205 = state_62177__$1;
(statearr_62189_62205[(1)] = (4));

(statearr_62189_62205[(5)] = null);

} else {
throw ex62182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62178 === (8))){
var inst_62161 = (state_62177[(2)]);
var inst_62162 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_62161);
var inst_62163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62164 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62166 = [inst_62161];
var inst_62167 = (new cljs.core.PersistentVector(null,1,(5),inst_62165,inst_62166,null));
var inst_62168 = ["nil?",inst_62167,inst_62162];
var inst_62169 = cljs.core.PersistentHashMap.fromArrays(inst_62164,inst_62168);
var inst_62170 = [inst_62169,(10)];
var inst_62171 = (new cljs.core.PersistentVector(null,2,(5),inst_62163,inst_62170,null));
var inst_62172 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62171);
var _ = (function (){var statearr_62190 = state_62177;
(statearr_62190[(4)] = cljs.core.rest.call(null,(state_62177[(4)])));

return statearr_62190;
})();
var state_62177__$1 = (function (){var statearr_62191 = state_62177;
(statearr_62191[(7)] = inst_62172);

return statearr_62191;
})();
var statearr_62192_62206 = state_62177__$1;
(statearr_62192_62206[(2)] = inst_62162);

(statearr_62192_62206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_62193 = [null,null,null,null,null,null,null,null];
(statearr_62193[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_62193[(1)] = (1));

return statearr_62193;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_62177){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62194){var ex__2749__auto__ = e62194;
var statearr_62195_62207 = state_62177;
(statearr_62195_62207[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62177[(4)]))){
var statearr_62196_62208 = state_62177;
(statearr_62196_62208[(1)] = cljs.core.first.call(null,(state_62177[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62209 = state_62177;
state_62177 = G__62209;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_62177){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_62177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62197 = f__2769__auto__.call(null);
(statearr_62197[(6)] = c__2768__auto__);

return statearr_62197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62239){
var state_val_62240 = (state_62239[(1)]);
if((state_val_62240 === (7))){
var state_62239__$1 = state_62239;
var statearr_62241_62260 = state_62239__$1;
(statearr_62241_62260[(2)] = arg);

(statearr_62241_62260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62240 === (1))){
var state_62239__$1 = state_62239;
var statearr_62242_62261 = state_62239__$1;
(statearr_62242_62261[(2)] = null);

(statearr_62242_62261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62240 === (4))){
var inst_62210 = (state_62239[(2)]);
var state_62239__$1 = state_62239;
var statearr_62243_62262 = state_62239__$1;
(statearr_62243_62262[(2)] = inst_62210);

(statearr_62243_62262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62240 === (6))){
var state_62239__$1 = state_62239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62239__$1,(9),arg);
} else {
if((state_val_62240 === (3))){
var inst_62237 = (state_62239[(2)]);
var state_62239__$1 = state_62239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62239__$1,inst_62237);
} else {
if((state_val_62240 === (2))){
var _ = (function (){var statearr_62245 = state_62239;
(statearr_62245[(4)] = cljs.core.cons.call(null,(5),(state_62239[(4)])));

return statearr_62245;
})();
var inst_62216 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_62239__$1 = state_62239;
if(inst_62216){
var statearr_62246_62263 = state_62239__$1;
(statearr_62246_62263[(1)] = (6));

} else {
var statearr_62247_62264 = state_62239__$1;
(statearr_62247_62264[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62240 === (9))){
var inst_62219 = (state_62239[(2)]);
var inst_62220 = fluree.db.util.async.throw_err.call(null,inst_62219);
var state_62239__$1 = state_62239;
var statearr_62248_62265 = state_62239__$1;
(statearr_62248_62265[(2)] = inst_62220);

(statearr_62248_62265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62240 === (5))){
var _ = (function (){var statearr_62249 = state_62239;
(statearr_62249[(4)] = cljs.core.rest.call(null,(state_62239[(4)])));

return statearr_62249;
})();
var state_62239__$1 = state_62239;
var ex62244 = (state_62239__$1[(2)]);
var statearr_62250_62266 = state_62239__$1;
(statearr_62250_62266[(5)] = ex62244);


if((ex62244 instanceof Error)){
var statearr_62251_62267 = state_62239__$1;
(statearr_62251_62267[(1)] = (4));

(statearr_62251_62267[(5)] = null);

} else {
throw ex62244;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62240 === (8))){
var inst_62223 = (state_62239[(2)]);
var inst_62224 = fluree.db.dbfunctions.internal.not.call(null,inst_62223);
var inst_62225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62226 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62228 = [inst_62223];
var inst_62229 = (new cljs.core.PersistentVector(null,1,(5),inst_62227,inst_62228,null));
var inst_62230 = ["not",inst_62229,inst_62224];
var inst_62231 = cljs.core.PersistentHashMap.fromArrays(inst_62226,inst_62230);
var inst_62232 = [inst_62231,(10)];
var inst_62233 = (new cljs.core.PersistentVector(null,2,(5),inst_62225,inst_62232,null));
var inst_62234 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62233);
var _ = (function (){var statearr_62252 = state_62239;
(statearr_62252[(4)] = cljs.core.rest.call(null,(state_62239[(4)])));

return statearr_62252;
})();
var state_62239__$1 = (function (){var statearr_62253 = state_62239;
(statearr_62253[(7)] = inst_62234);

return statearr_62253;
})();
var statearr_62254_62268 = state_62239__$1;
(statearr_62254_62268[(2)] = inst_62224);

(statearr_62254_62268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_62255 = [null,null,null,null,null,null,null,null];
(statearr_62255[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_62255[(1)] = (1));

return statearr_62255;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_62239){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62256){var ex__2749__auto__ = e62256;
var statearr_62257_62269 = state_62239;
(statearr_62257_62269[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62239[(4)]))){
var statearr_62258_62270 = state_62239;
(statearr_62258_62270[(1)] = cljs.core.first.call(null,(state_62239[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62271 = state_62239;
state_62239 = G__62271;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_62239){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_62239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62259 = f__2769__auto__.call(null);
(statearr_62259[(6)] = c__2768__auto__);

return statearr_62259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62301){
var state_val_62302 = (state_62301[(1)]);
if((state_val_62302 === (7))){
var state_62301__$1 = state_62301;
var statearr_62303_62322 = state_62301__$1;
(statearr_62303_62322[(2)] = arg);

(statearr_62303_62322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62302 === (1))){
var state_62301__$1 = state_62301;
var statearr_62304_62323 = state_62301__$1;
(statearr_62304_62323[(2)] = null);

(statearr_62304_62323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62302 === (4))){
var inst_62272 = (state_62301[(2)]);
var state_62301__$1 = state_62301;
var statearr_62305_62324 = state_62301__$1;
(statearr_62305_62324[(2)] = inst_62272);

(statearr_62305_62324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62302 === (6))){
var state_62301__$1 = state_62301;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62301__$1,(9),arg);
} else {
if((state_val_62302 === (3))){
var inst_62299 = (state_62301[(2)]);
var state_62301__$1 = state_62301;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62301__$1,inst_62299);
} else {
if((state_val_62302 === (2))){
var _ = (function (){var statearr_62307 = state_62301;
(statearr_62307[(4)] = cljs.core.cons.call(null,(5),(state_62301[(4)])));

return statearr_62307;
})();
var inst_62278 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_62301__$1 = state_62301;
if(inst_62278){
var statearr_62308_62325 = state_62301__$1;
(statearr_62308_62325[(1)] = (6));

} else {
var statearr_62309_62326 = state_62301__$1;
(statearr_62309_62326[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62302 === (9))){
var inst_62281 = (state_62301[(2)]);
var inst_62282 = fluree.db.util.async.throw_err.call(null,inst_62281);
var state_62301__$1 = state_62301;
var statearr_62310_62327 = state_62301__$1;
(statearr_62310_62327[(2)] = inst_62282);

(statearr_62310_62327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62302 === (5))){
var _ = (function (){var statearr_62311 = state_62301;
(statearr_62311[(4)] = cljs.core.rest.call(null,(state_62301[(4)])));

return statearr_62311;
})();
var state_62301__$1 = state_62301;
var ex62306 = (state_62301__$1[(2)]);
var statearr_62312_62328 = state_62301__$1;
(statearr_62312_62328[(5)] = ex62306);


if((ex62306 instanceof Error)){
var statearr_62313_62329 = state_62301__$1;
(statearr_62313_62329[(1)] = (4));

(statearr_62313_62329[(5)] = null);

} else {
throw ex62306;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62302 === (8))){
var inst_62285 = (state_62301[(2)]);
var inst_62286 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_62285);
var inst_62287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62288 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62290 = [inst_62285];
var inst_62291 = (new cljs.core.PersistentVector(null,1,(5),inst_62289,inst_62290,null));
var inst_62292 = ["empty?",inst_62291,inst_62286];
var inst_62293 = cljs.core.PersistentHashMap.fromArrays(inst_62288,inst_62292);
var inst_62294 = [inst_62293,(10)];
var inst_62295 = (new cljs.core.PersistentVector(null,2,(5),inst_62287,inst_62294,null));
var inst_62296 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62295);
var _ = (function (){var statearr_62314 = state_62301;
(statearr_62314[(4)] = cljs.core.rest.call(null,(state_62301[(4)])));

return statearr_62314;
})();
var state_62301__$1 = (function (){var statearr_62315 = state_62301;
(statearr_62315[(7)] = inst_62296);

return statearr_62315;
})();
var statearr_62316_62330 = state_62301__$1;
(statearr_62316_62330[(2)] = inst_62286);

(statearr_62316_62330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_62317 = [null,null,null,null,null,null,null,null];
(statearr_62317[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_62317[(1)] = (1));

return statearr_62317;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_62301){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62301);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62318){var ex__2749__auto__ = e62318;
var statearr_62319_62331 = state_62301;
(statearr_62319_62331[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62301[(4)]))){
var statearr_62320_62332 = state_62301;
(statearr_62320_62332[(1)] = cljs.core.first.call(null,(state_62301[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62333 = state_62301;
state_62301 = G__62333;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_62301){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_62301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62321 = f__2769__auto__.call(null);
(statearr_62321[(6)] = c__2768__auto__);

return statearr_62321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___62378 = arguments.length;
var i__5770__auto___62379 = (0);
while(true){
if((i__5770__auto___62379 < len__5769__auto___62378)){
args__5775__auto__.push((arguments[i__5770__auto___62379]));

var G__62380 = (i__5770__auto___62379 + (1));
i__5770__auto___62379 = G__62380;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62361){
var state_val_62362 = (state_62361[(1)]);
if((state_val_62362 === (1))){
var state_62361__$1 = state_62361;
var statearr_62363_62381 = state_62361__$1;
(statearr_62363_62381[(2)] = null);

(statearr_62363_62381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62362 === (2))){
var _ = (function (){var statearr_62364 = state_62361;
(statearr_62364[(4)] = cljs.core.cons.call(null,(5),(state_62361[(4)])));

return statearr_62364;
})();
var inst_62342 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_62361__$1 = state_62361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62361__$1,(6),inst_62342);
} else {
if((state_val_62362 === (3))){
var inst_62359 = (state_62361[(2)]);
var state_62361__$1 = state_62361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62361__$1,inst_62359);
} else {
if((state_val_62362 === (4))){
var inst_62336 = (state_62361[(2)]);
var state_62361__$1 = state_62361;
var statearr_62366_62382 = state_62361__$1;
(statearr_62366_62382[(2)] = inst_62336);

(statearr_62366_62382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62362 === (5))){
var _ = (function (){var statearr_62367 = state_62361;
(statearr_62367[(4)] = cljs.core.rest.call(null,(state_62361[(4)])));

return statearr_62367;
})();
var state_62361__$1 = state_62361;
var ex62365 = (state_62361__$1[(2)]);
var statearr_62368_62383 = state_62361__$1;
(statearr_62368_62383[(5)] = ex62365);


if((ex62365 instanceof Error)){
var statearr_62369_62384 = state_62361__$1;
(statearr_62369_62384[(1)] = (4));

(statearr_62369_62384[(5)] = null);

} else {
throw ex62365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62362 === (6))){
var inst_62344 = (state_62361[(2)]);
var inst_62345 = fluree.db.util.async.throw_err.call(null,inst_62344);
var inst_62346 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_62345);
var inst_62347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62348 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62350 = [inst_62345];
var inst_62351 = (new cljs.core.PersistentVector(null,1,(5),inst_62349,inst_62350,null));
var inst_62352 = ["str",inst_62351,inst_62346];
var inst_62353 = cljs.core.PersistentHashMap.fromArrays(inst_62348,inst_62352);
var inst_62354 = [inst_62353,(10)];
var inst_62355 = (new cljs.core.PersistentVector(null,2,(5),inst_62347,inst_62354,null));
var inst_62356 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62355);
var _ = (function (){var statearr_62370 = state_62361;
(statearr_62370[(4)] = cljs.core.rest.call(null,(state_62361[(4)])));

return statearr_62370;
})();
var state_62361__$1 = (function (){var statearr_62371 = state_62361;
(statearr_62371[(7)] = inst_62356);

return statearr_62371;
})();
var statearr_62372_62385 = state_62361__$1;
(statearr_62372_62385[(2)] = inst_62346);

(statearr_62372_62385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_62373 = [null,null,null,null,null,null,null,null];
(statearr_62373[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_62373[(1)] = (1));

return statearr_62373;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_62361){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62374){var ex__2749__auto__ = e62374;
var statearr_62375_62386 = state_62361;
(statearr_62375_62386[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62361[(4)]))){
var statearr_62376_62387 = state_62361;
(statearr_62376_62387[(1)] = cljs.core.first.call(null,(state_62361[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62388 = state_62361;
state_62361 = G__62388;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_62361){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_62361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62377 = f__2769__auto__.call(null);
(statearr_62377[(6)] = c__2768__auto__);

return statearr_62377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq62334){
var G__62335 = cljs.core.first.call(null,seq62334);
var seq62334__$1 = cljs.core.next.call(null,seq62334);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62335,seq62334__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62414){
var state_val_62415 = (state_62414[(1)]);
if((state_val_62415 === (1))){
var state_62414__$1 = state_62414;
var statearr_62416_62431 = state_62414__$1;
(statearr_62416_62431[(2)] = null);

(statearr_62416_62431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62415 === (2))){
var _ = (function (){var statearr_62417 = state_62414;
(statearr_62417[(4)] = cljs.core.cons.call(null,(5),(state_62414[(4)])));

return statearr_62417;
})();
var inst_62395 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_62414__$1 = state_62414;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62414__$1,(6),inst_62395);
} else {
if((state_val_62415 === (3))){
var inst_62412 = (state_62414[(2)]);
var state_62414__$1 = state_62414;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62414__$1,inst_62412);
} else {
if((state_val_62415 === (4))){
var inst_62389 = (state_62414[(2)]);
var state_62414__$1 = state_62414;
var statearr_62419_62432 = state_62414__$1;
(statearr_62419_62432[(2)] = inst_62389);

(statearr_62419_62432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62415 === (5))){
var _ = (function (){var statearr_62420 = state_62414;
(statearr_62420[(4)] = cljs.core.rest.call(null,(state_62414[(4)])));

return statearr_62420;
})();
var state_62414__$1 = state_62414;
var ex62418 = (state_62414__$1[(2)]);
var statearr_62421_62433 = state_62414__$1;
(statearr_62421_62433[(5)] = ex62418);


if((ex62418 instanceof Error)){
var statearr_62422_62434 = state_62414__$1;
(statearr_62422_62434[(1)] = (4));

(statearr_62422_62434[(5)] = null);

} else {
throw ex62418;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62415 === (6))){
var inst_62397 = (state_62414[(2)]);
var inst_62398 = fluree.db.util.async.throw_err.call(null,inst_62397);
var inst_62399 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_62398);
var inst_62400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62401 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62403 = [inst_62398];
var inst_62404 = (new cljs.core.PersistentVector(null,1,(5),inst_62402,inst_62403,null));
var inst_62405 = ["subs",inst_62404,inst_62399];
var inst_62406 = cljs.core.PersistentHashMap.fromArrays(inst_62401,inst_62405);
var inst_62407 = [inst_62406,(30)];
var inst_62408 = (new cljs.core.PersistentVector(null,2,(5),inst_62400,inst_62407,null));
var inst_62409 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62408);
var _ = (function (){var statearr_62423 = state_62414;
(statearr_62423[(4)] = cljs.core.rest.call(null,(state_62414[(4)])));

return statearr_62423;
})();
var state_62414__$1 = (function (){var statearr_62424 = state_62414;
(statearr_62424[(7)] = inst_62409);

return statearr_62424;
})();
var statearr_62425_62435 = state_62414__$1;
(statearr_62425_62435[(2)] = inst_62399);

(statearr_62425_62435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_62426 = [null,null,null,null,null,null,null,null];
(statearr_62426[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_62426[(1)] = (1));

return statearr_62426;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_62414){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62414);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62427){var ex__2749__auto__ = e62427;
var statearr_62428_62436 = state_62414;
(statearr_62428_62436[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62414[(4)]))){
var statearr_62429_62437 = state_62414;
(statearr_62429_62437[(1)] = cljs.core.first.call(null,(state_62414[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62438 = state_62414;
state_62414 = G__62438;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_62414){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_62414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62430 = f__2769__auto__.call(null);
(statearr_62430[(6)] = c__2768__auto__);

return statearr_62430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62468){
var state_val_62469 = (state_62468[(1)]);
if((state_val_62469 === (7))){
var state_62468__$1 = state_62468;
var statearr_62470_62489 = state_62468__$1;
(statearr_62470_62489[(2)] = str);

(statearr_62470_62489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (1))){
var state_62468__$1 = state_62468;
var statearr_62471_62490 = state_62468__$1;
(statearr_62471_62490[(2)] = null);

(statearr_62471_62490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (4))){
var inst_62439 = (state_62468[(2)]);
var state_62468__$1 = state_62468;
var statearr_62472_62491 = state_62468__$1;
(statearr_62472_62491[(2)] = inst_62439);

(statearr_62472_62491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (6))){
var state_62468__$1 = state_62468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62468__$1,(9),str);
} else {
if((state_val_62469 === (3))){
var inst_62466 = (state_62468[(2)]);
var state_62468__$1 = state_62468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62468__$1,inst_62466);
} else {
if((state_val_62469 === (2))){
var _ = (function (){var statearr_62474 = state_62468;
(statearr_62474[(4)] = cljs.core.cons.call(null,(5),(state_62468[(4)])));

return statearr_62474;
})();
var inst_62445 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_62468__$1 = state_62468;
if(inst_62445){
var statearr_62475_62492 = state_62468__$1;
(statearr_62475_62492[(1)] = (6));

} else {
var statearr_62476_62493 = state_62468__$1;
(statearr_62476_62493[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (9))){
var inst_62448 = (state_62468[(2)]);
var inst_62449 = fluree.db.util.async.throw_err.call(null,inst_62448);
var state_62468__$1 = state_62468;
var statearr_62477_62494 = state_62468__$1;
(statearr_62477_62494[(2)] = inst_62449);

(statearr_62477_62494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (5))){
var _ = (function (){var statearr_62478 = state_62468;
(statearr_62478[(4)] = cljs.core.rest.call(null,(state_62468[(4)])));

return statearr_62478;
})();
var state_62468__$1 = state_62468;
var ex62473 = (state_62468__$1[(2)]);
var statearr_62479_62495 = state_62468__$1;
(statearr_62479_62495[(5)] = ex62473);


if((ex62473 instanceof Error)){
var statearr_62480_62496 = state_62468__$1;
(statearr_62480_62496[(1)] = (4));

(statearr_62480_62496[(5)] = null);

} else {
throw ex62473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (8))){
var inst_62452 = (state_62468[(2)]);
var inst_62453 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_62452);
var inst_62454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62455 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62457 = [inst_62452];
var inst_62458 = (new cljs.core.PersistentVector(null,1,(5),inst_62456,inst_62457,null));
var inst_62459 = ["lower-case",inst_62458,inst_62453];
var inst_62460 = cljs.core.PersistentHashMap.fromArrays(inst_62455,inst_62459);
var inst_62461 = [inst_62460,(10)];
var inst_62462 = (new cljs.core.PersistentVector(null,2,(5),inst_62454,inst_62461,null));
var inst_62463 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62462);
var _ = (function (){var statearr_62481 = state_62468;
(statearr_62481[(4)] = cljs.core.rest.call(null,(state_62468[(4)])));

return statearr_62481;
})();
var state_62468__$1 = (function (){var statearr_62482 = state_62468;
(statearr_62482[(7)] = inst_62463);

return statearr_62482;
})();
var statearr_62483_62497 = state_62468__$1;
(statearr_62483_62497[(2)] = inst_62453);

(statearr_62483_62497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_62484 = [null,null,null,null,null,null,null,null];
(statearr_62484[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_62484[(1)] = (1));

return statearr_62484;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_62468){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62485){var ex__2749__auto__ = e62485;
var statearr_62486_62498 = state_62468;
(statearr_62486_62498[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62468[(4)]))){
var statearr_62487_62499 = state_62468;
(statearr_62487_62499[(1)] = cljs.core.first.call(null,(state_62468[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62500 = state_62468;
state_62468 = G__62500;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_62468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_62468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62488 = f__2769__auto__.call(null);
(statearr_62488[(6)] = c__2768__auto__);

return statearr_62488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62530){
var state_val_62531 = (state_62530[(1)]);
if((state_val_62531 === (7))){
var state_62530__$1 = state_62530;
var statearr_62532_62551 = state_62530__$1;
(statearr_62532_62551[(2)] = str);

(statearr_62532_62551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (1))){
var state_62530__$1 = state_62530;
var statearr_62533_62552 = state_62530__$1;
(statearr_62533_62552[(2)] = null);

(statearr_62533_62552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (4))){
var inst_62501 = (state_62530[(2)]);
var state_62530__$1 = state_62530;
var statearr_62534_62553 = state_62530__$1;
(statearr_62534_62553[(2)] = inst_62501);

(statearr_62534_62553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (6))){
var state_62530__$1 = state_62530;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62530__$1,(9),str);
} else {
if((state_val_62531 === (3))){
var inst_62528 = (state_62530[(2)]);
var state_62530__$1 = state_62530;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62530__$1,inst_62528);
} else {
if((state_val_62531 === (2))){
var _ = (function (){var statearr_62536 = state_62530;
(statearr_62536[(4)] = cljs.core.cons.call(null,(5),(state_62530[(4)])));

return statearr_62536;
})();
var inst_62507 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_62530__$1 = state_62530;
if(inst_62507){
var statearr_62537_62554 = state_62530__$1;
(statearr_62537_62554[(1)] = (6));

} else {
var statearr_62538_62555 = state_62530__$1;
(statearr_62538_62555[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (9))){
var inst_62510 = (state_62530[(2)]);
var inst_62511 = fluree.db.util.async.throw_err.call(null,inst_62510);
var state_62530__$1 = state_62530;
var statearr_62539_62556 = state_62530__$1;
(statearr_62539_62556[(2)] = inst_62511);

(statearr_62539_62556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (5))){
var _ = (function (){var statearr_62540 = state_62530;
(statearr_62540[(4)] = cljs.core.rest.call(null,(state_62530[(4)])));

return statearr_62540;
})();
var state_62530__$1 = state_62530;
var ex62535 = (state_62530__$1[(2)]);
var statearr_62541_62557 = state_62530__$1;
(statearr_62541_62557[(5)] = ex62535);


if((ex62535 instanceof Error)){
var statearr_62542_62558 = state_62530__$1;
(statearr_62542_62558[(1)] = (4));

(statearr_62542_62558[(5)] = null);

} else {
throw ex62535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62531 === (8))){
var inst_62514 = (state_62530[(2)]);
var inst_62515 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_62514);
var inst_62516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62517 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62519 = [inst_62514];
var inst_62520 = (new cljs.core.PersistentVector(null,1,(5),inst_62518,inst_62519,null));
var inst_62521 = ["upper-case",inst_62520,inst_62515];
var inst_62522 = cljs.core.PersistentHashMap.fromArrays(inst_62517,inst_62521);
var inst_62523 = [inst_62522,(10)];
var inst_62524 = (new cljs.core.PersistentVector(null,2,(5),inst_62516,inst_62523,null));
var inst_62525 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62524);
var _ = (function (){var statearr_62543 = state_62530;
(statearr_62543[(4)] = cljs.core.rest.call(null,(state_62530[(4)])));

return statearr_62543;
})();
var state_62530__$1 = (function (){var statearr_62544 = state_62530;
(statearr_62544[(7)] = inst_62525);

return statearr_62544;
})();
var statearr_62545_62559 = state_62530__$1;
(statearr_62545_62559[(2)] = inst_62515);

(statearr_62545_62559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_62546 = [null,null,null,null,null,null,null,null];
(statearr_62546[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_62546[(1)] = (1));

return statearr_62546;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_62530){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62530);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62547){var ex__2749__auto__ = e62547;
var statearr_62548_62560 = state_62530;
(statearr_62548_62560[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62530[(4)]))){
var statearr_62549_62561 = state_62530;
(statearr_62549_62561[(1)] = cljs.core.first.call(null,(state_62530[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62562 = state_62530;
state_62530 = G__62562;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_62530){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_62530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62550 = f__2769__auto__.call(null);
(statearr_62550[(6)] = c__2768__auto__);

return statearr_62550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__62564 = arguments.length;
switch (G__62564) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62592){
var state_val_62593 = (state_62592[(1)]);
if((state_val_62593 === (1))){
var state_62592__$1 = state_62592;
var statearr_62594_62610 = state_62592__$1;
(statearr_62594_62610[(2)] = null);

(statearr_62594_62610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62593 === (2))){
var _ = (function (){var statearr_62595 = state_62592;
(statearr_62595[(4)] = cljs.core.cons.call(null,(5),(state_62592[(4)])));

return statearr_62595;
})();
var inst_62574 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_62592__$1 = state_62592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62592__$1,(6),inst_62574);
} else {
if((state_val_62593 === (3))){
var inst_62590 = (state_62592[(2)]);
var state_62592__$1 = state_62592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62592__$1,inst_62590);
} else {
if((state_val_62593 === (4))){
var inst_62565 = (state_62592[(2)]);
var state_62592__$1 = state_62592;
var statearr_62597_62611 = state_62592__$1;
(statearr_62597_62611[(2)] = inst_62565);

(statearr_62597_62611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62593 === (5))){
var _ = (function (){var statearr_62598 = state_62592;
(statearr_62598[(4)] = cljs.core.rest.call(null,(state_62592[(4)])));

return statearr_62598;
})();
var state_62592__$1 = state_62592;
var ex62596 = (state_62592__$1[(2)]);
var statearr_62599_62612 = state_62592__$1;
(statearr_62599_62612[(5)] = ex62596);


if((ex62596 instanceof Error)){
var statearr_62600_62613 = state_62592__$1;
(statearr_62600_62613[(1)] = (4));

(statearr_62600_62613[(5)] = null);

} else {
throw ex62596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62593 === (6))){
var inst_62576 = (state_62592[(2)]);
var inst_62577 = fluree.db.util.async.throw_err.call(null,inst_62576);
var inst_62578 = cljs.core.nth.call(null,inst_62577,(0),null);
var inst_62579 = cljs.core.nth.call(null,inst_62577,(1),null);
var inst_62580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62581 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62582 = ["?s","?ctx",inst_62578];
var inst_62583 = cljs.core.PersistentHashMap.fromArrays(inst_62581,inst_62582);
var inst_62584 = ((10) + inst_62579);
var inst_62585 = [inst_62583,inst_62584];
var inst_62586 = (new cljs.core.PersistentVector(null,2,(5),inst_62580,inst_62585,null));
var inst_62587 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62586);
var _ = (function (){var statearr_62601 = state_62592;
(statearr_62601[(4)] = cljs.core.rest.call(null,(state_62592[(4)])));

return statearr_62601;
})();
var state_62592__$1 = (function (){var statearr_62602 = state_62592;
(statearr_62602[(7)] = inst_62587);

return statearr_62602;
})();
var statearr_62603_62614 = state_62592__$1;
(statearr_62603_62614[(2)] = inst_62578);

(statearr_62603_62614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_62604 = [null,null,null,null,null,null,null,null];
(statearr_62604[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_62604[(1)] = (1));

return statearr_62604;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_62592){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62605){var ex__2749__auto__ = e62605;
var statearr_62606_62615 = state_62592;
(statearr_62606_62615[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62592[(4)]))){
var statearr_62607_62616 = state_62592;
(statearr_62607_62616[(1)] = cljs.core.first.call(null,(state_62592[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62617 = state_62592;
state_62592 = G__62617;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_62592){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_62592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62608 = f__2769__auto__.call(null);
(statearr_62608[(6)] = c__2768__auto__);

return statearr_62608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__62619 = arguments.length;
switch (G__62619) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62657){
var state_val_62658 = (state_62657[(1)]);
if((state_val_62658 === (7))){
var inst_62650 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_62657__$1 = state_62657;
var statearr_62659_62679 = state_62657__$1;
(statearr_62659_62679[(2)] = inst_62650);

(statearr_62659_62679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62658 === (1))){
var state_62657__$1 = state_62657;
var statearr_62660_62680 = state_62657__$1;
(statearr_62660_62680[(2)] = null);

(statearr_62660_62680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62658 === (4))){
var inst_62620 = (state_62657[(2)]);
var state_62657__$1 = state_62657;
var statearr_62661_62681 = state_62657__$1;
(statearr_62661_62681[(2)] = inst_62620);

(statearr_62661_62681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62658 === (6))){
var inst_62631 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_62657__$1 = state_62657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62657__$1,(10),inst_62631);
} else {
if((state_val_62658 === (3))){
var inst_62655 = (state_62657[(2)]);
var state_62657__$1 = state_62657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62657__$1,inst_62655);
} else {
if((state_val_62658 === (2))){
var _ = (function (){var statearr_62663 = state_62657;
(statearr_62663[(4)] = cljs.core.cons.call(null,(5),(state_62657[(4)])));

return statearr_62663;
})();
var inst_62626 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_62657__$1 = state_62657;
if(cljs.core.truth_(inst_62626)){
var statearr_62664_62682 = state_62657__$1;
(statearr_62664_62682[(1)] = (6));

} else {
var statearr_62665_62683 = state_62657__$1;
(statearr_62665_62683[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62658 === (9))){
var inst_62637 = (state_62657[(2)]);
var inst_62638 = fluree.db.util.async.throw_err.call(null,inst_62637);
var inst_62639 = cljs.core.nth.call(null,inst_62638,(0),null);
var inst_62640 = cljs.core.nth.call(null,inst_62638,(1),null);
var inst_62641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62642 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62643 = ["?p","?ctx",inst_62639];
var inst_62644 = cljs.core.PersistentHashMap.fromArrays(inst_62642,inst_62643);
var inst_62645 = ((10) + inst_62640);
var inst_62646 = [inst_62644,inst_62645];
var inst_62647 = (new cljs.core.PersistentVector(null,2,(5),inst_62641,inst_62646,null));
var inst_62648 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62647);
var state_62657__$1 = (function (){var statearr_62666 = state_62657;
(statearr_62666[(7)] = inst_62648);

return statearr_62666;
})();
var statearr_62667_62684 = state_62657__$1;
(statearr_62667_62684[(2)] = inst_62639);

(statearr_62667_62684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62658 === (5))){
var _ = (function (){var statearr_62668 = state_62657;
(statearr_62668[(4)] = cljs.core.rest.call(null,(state_62657[(4)])));

return statearr_62668;
})();
var state_62657__$1 = state_62657;
var ex62662 = (state_62657__$1[(2)]);
var statearr_62669_62685 = state_62657__$1;
(statearr_62669_62685[(5)] = ex62662);


if((ex62662 instanceof Error)){
var statearr_62670_62686 = state_62657__$1;
(statearr_62670_62686[(1)] = (4));

(statearr_62670_62686[(5)] = null);

} else {
throw ex62662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62658 === (10))){
var inst_62633 = (state_62657[(2)]);
var inst_62634 = fluree.db.util.async.throw_err.call(null,inst_62633);
var inst_62635 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_62634);
var state_62657__$1 = state_62657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62657__$1,(9),inst_62635);
} else {
if((state_val_62658 === (8))){
var inst_62652 = (state_62657[(2)]);
var _ = (function (){var statearr_62671 = state_62657;
(statearr_62671[(4)] = cljs.core.rest.call(null,(state_62657[(4)])));

return statearr_62671;
})();
var state_62657__$1 = state_62657;
var statearr_62672_62687 = state_62657__$1;
(statearr_62672_62687[(2)] = inst_62652);

(statearr_62672_62687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_62673 = [null,null,null,null,null,null,null,null];
(statearr_62673[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_62673[(1)] = (1));

return statearr_62673;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_62657){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62674){var ex__2749__auto__ = e62674;
var statearr_62675_62688 = state_62657;
(statearr_62675_62688[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62657[(4)]))){
var statearr_62676_62689 = state_62657;
(statearr_62676_62689[(1)] = cljs.core.first.call(null,(state_62657[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62690 = state_62657;
state_62657 = G__62690;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_62657){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_62657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62677 = f__2769__auto__.call(null);
(statearr_62677[(6)] = c__2768__auto__);

return statearr_62677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___62739 = arguments.length;
var i__5770__auto___62740 = (0);
while(true){
if((i__5770__auto___62740 < len__5769__auto___62739)){
args__5775__auto__.push((arguments[i__5770__auto___62740]));

var G__62741 = (i__5770__auto___62740 + (1));
i__5770__auto___62740 = G__62741;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62722){
var state_val_62723 = (state_62722[(1)]);
if((state_val_62723 === (1))){
var state_62722__$1 = state_62722;
var statearr_62724_62742 = state_62722__$1;
(statearr_62724_62742[(2)] = null);

(statearr_62724_62742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (2))){
var _ = (function (){var statearr_62725 = state_62722;
(statearr_62725[(4)] = cljs.core.cons.call(null,(5),(state_62722[(4)])));

return statearr_62725;
})();
var inst_62699 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_62722__$1 = state_62722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62722__$1,(6),inst_62699);
} else {
if((state_val_62723 === (3))){
var inst_62720 = (state_62722[(2)]);
var state_62722__$1 = state_62722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62722__$1,inst_62720);
} else {
if((state_val_62723 === (4))){
var inst_62693 = (state_62722[(2)]);
var state_62722__$1 = state_62722;
var statearr_62727_62743 = state_62722__$1;
(statearr_62727_62743[(2)] = inst_62693);

(statearr_62727_62743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (5))){
var _ = (function (){var statearr_62728 = state_62722;
(statearr_62728[(4)] = cljs.core.rest.call(null,(state_62722[(4)])));

return statearr_62728;
})();
var state_62722__$1 = state_62722;
var ex62726 = (state_62722__$1[(2)]);
var statearr_62729_62744 = state_62722__$1;
(statearr_62729_62744[(5)] = ex62726);


if((ex62726 instanceof Error)){
var statearr_62730_62745 = state_62722__$1;
(statearr_62730_62745[(1)] = (4));

(statearr_62730_62745[(5)] = null);

} else {
throw ex62726;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (6))){
var inst_62701 = (state_62722[(2)]);
var inst_62702 = fluree.db.util.async.throw_err.call(null,inst_62701);
var inst_62703 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_62702);
var inst_62704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62705 = [inst_62702];
var inst_62706 = (new cljs.core.PersistentVector(null,1,(5),inst_62704,inst_62705,null));
var inst_62707 = cljs.core.count.call(null,inst_62706);
var inst_62708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62709 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62711 = [inst_62702];
var inst_62712 = (new cljs.core.PersistentVector(null,1,(5),inst_62710,inst_62711,null));
var inst_62713 = ["and",inst_62712,inst_62703];
var inst_62714 = cljs.core.PersistentHashMap.fromArrays(inst_62709,inst_62713);
var inst_62715 = [inst_62714,inst_62707];
var inst_62716 = (new cljs.core.PersistentVector(null,2,(5),inst_62708,inst_62715,null));
var inst_62717 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62716);
var _ = (function (){var statearr_62731 = state_62722;
(statearr_62731[(4)] = cljs.core.rest.call(null,(state_62722[(4)])));

return statearr_62731;
})();
var state_62722__$1 = (function (){var statearr_62732 = state_62722;
(statearr_62732[(7)] = inst_62717);

return statearr_62732;
})();
var statearr_62733_62746 = state_62722__$1;
(statearr_62733_62746[(2)] = inst_62703);

(statearr_62733_62746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_62734 = [null,null,null,null,null,null,null,null];
(statearr_62734[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_62734[(1)] = (1));

return statearr_62734;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_62722){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62735){var ex__2749__auto__ = e62735;
var statearr_62736_62747 = state_62722;
(statearr_62736_62747[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62722[(4)]))){
var statearr_62737_62748 = state_62722;
(statearr_62737_62748[(1)] = cljs.core.first.call(null,(state_62722[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62749 = state_62722;
state_62722 = G__62749;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_62722){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_62722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62738 = f__2769__auto__.call(null);
(statearr_62738[(6)] = c__2768__auto__);

return statearr_62738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq62691){
var G__62692 = cljs.core.first.call(null,seq62691);
var seq62691__$1 = cljs.core.next.call(null,seq62691);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62692,seq62691__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___62798 = arguments.length;
var i__5770__auto___62799 = (0);
while(true){
if((i__5770__auto___62799 < len__5769__auto___62798)){
args__5775__auto__.push((arguments[i__5770__auto___62799]));

var G__62800 = (i__5770__auto___62799 + (1));
i__5770__auto___62799 = G__62800;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62781){
var state_val_62782 = (state_62781[(1)]);
if((state_val_62782 === (1))){
var state_62781__$1 = state_62781;
var statearr_62783_62801 = state_62781__$1;
(statearr_62783_62801[(2)] = null);

(statearr_62783_62801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62782 === (2))){
var _ = (function (){var statearr_62784 = state_62781;
(statearr_62784[(4)] = cljs.core.cons.call(null,(5),(state_62781[(4)])));

return statearr_62784;
})();
var inst_62758 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_62781__$1 = state_62781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62781__$1,(6),inst_62758);
} else {
if((state_val_62782 === (3))){
var inst_62779 = (state_62781[(2)]);
var state_62781__$1 = state_62781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62781__$1,inst_62779);
} else {
if((state_val_62782 === (4))){
var inst_62752 = (state_62781[(2)]);
var state_62781__$1 = state_62781;
var statearr_62786_62802 = state_62781__$1;
(statearr_62786_62802[(2)] = inst_62752);

(statearr_62786_62802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62782 === (5))){
var _ = (function (){var statearr_62787 = state_62781;
(statearr_62787[(4)] = cljs.core.rest.call(null,(state_62781[(4)])));

return statearr_62787;
})();
var state_62781__$1 = state_62781;
var ex62785 = (state_62781__$1[(2)]);
var statearr_62788_62803 = state_62781__$1;
(statearr_62788_62803[(5)] = ex62785);


if((ex62785 instanceof Error)){
var statearr_62789_62804 = state_62781__$1;
(statearr_62789_62804[(1)] = (4));

(statearr_62789_62804[(5)] = null);

} else {
throw ex62785;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62782 === (6))){
var inst_62760 = (state_62781[(2)]);
var inst_62761 = fluree.db.util.async.throw_err.call(null,inst_62760);
var inst_62762 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_62761);
var inst_62763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62764 = [inst_62761];
var inst_62765 = (new cljs.core.PersistentVector(null,1,(5),inst_62763,inst_62764,null));
var inst_62766 = cljs.core.count.call(null,inst_62765);
var inst_62767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62768 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62770 = [inst_62761];
var inst_62771 = (new cljs.core.PersistentVector(null,1,(5),inst_62769,inst_62770,null));
var inst_62772 = ["or",inst_62771,inst_62762];
var inst_62773 = cljs.core.PersistentHashMap.fromArrays(inst_62768,inst_62772);
var inst_62774 = [inst_62773,inst_62766];
var inst_62775 = (new cljs.core.PersistentVector(null,2,(5),inst_62767,inst_62774,null));
var inst_62776 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62775);
var _ = (function (){var statearr_62790 = state_62781;
(statearr_62790[(4)] = cljs.core.rest.call(null,(state_62781[(4)])));

return statearr_62790;
})();
var state_62781__$1 = (function (){var statearr_62791 = state_62781;
(statearr_62791[(7)] = inst_62776);

return statearr_62791;
})();
var statearr_62792_62805 = state_62781__$1;
(statearr_62792_62805[(2)] = inst_62762);

(statearr_62792_62805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_62793 = [null,null,null,null,null,null,null,null];
(statearr_62793[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_62793[(1)] = (1));

return statearr_62793;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_62781){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62794){var ex__2749__auto__ = e62794;
var statearr_62795_62806 = state_62781;
(statearr_62795_62806[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62781[(4)]))){
var statearr_62796_62807 = state_62781;
(statearr_62796_62807[(1)] = cljs.core.first.call(null,(state_62781[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62808 = state_62781;
state_62781 = G__62808;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_62781){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_62781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62797 = f__2769__auto__.call(null);
(statearr_62797[(6)] = c__2768__auto__);

return statearr_62797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq62750){
var G__62751 = cljs.core.first.call(null,seq62750);
var seq62750__$1 = cljs.core.next.call(null,seq62750);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62751,seq62750__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62846){
var state_val_62847 = (state_62846[(1)]);
if((state_val_62847 === (7))){
var inst_62822 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_62846__$1 = state_62846;
if(inst_62822){
var statearr_62848_62871 = state_62846__$1;
(statearr_62848_62871[(1)] = (10));

} else {
var statearr_62849_62872 = state_62846__$1;
(statearr_62849_62872[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (1))){
var state_62846__$1 = state_62846;
var statearr_62850_62873 = state_62846__$1;
(statearr_62850_62873[(2)] = null);

(statearr_62850_62873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (4))){
var inst_62809 = (state_62846[(2)]);
var state_62846__$1 = state_62846;
var statearr_62851_62874 = state_62846__$1;
(statearr_62851_62874[(2)] = inst_62809);

(statearr_62851_62874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (13))){
var inst_62825 = (state_62846[(2)]);
var inst_62826 = fluree.db.util.async.throw_err.call(null,inst_62825);
var state_62846__$1 = state_62846;
var statearr_62852_62875 = state_62846__$1;
(statearr_62852_62875[(2)] = inst_62826);

(statearr_62852_62875[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (6))){
var inst_62817 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_62846__$1 = state_62846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62846__$1,(9),inst_62817);
} else {
if((state_val_62847 === (3))){
var inst_62844 = (state_62846[(2)]);
var state_62846__$1 = state_62846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62846__$1,inst_62844);
} else {
if((state_val_62847 === (12))){
var inst_62829 = (state_62846[(2)]);
var state_62846__$1 = state_62846;
var statearr_62853_62876 = state_62846__$1;
(statearr_62853_62876[(2)] = inst_62829);

(statearr_62853_62876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (2))){
var _ = (function (){var statearr_62854 = state_62846;
(statearr_62854[(4)] = cljs.core.cons.call(null,(5),(state_62846[(4)])));

return statearr_62854;
})();
var inst_62815 = cljs.core.vector_QMARK_.call(null,coll);
var state_62846__$1 = state_62846;
if(inst_62815){
var statearr_62855_62877 = state_62846__$1;
(statearr_62855_62877[(1)] = (6));

} else {
var statearr_62856_62878 = state_62846__$1;
(statearr_62856_62878[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (11))){
var state_62846__$1 = state_62846;
var statearr_62858_62879 = state_62846__$1;
(statearr_62858_62879[(2)] = coll);

(statearr_62858_62879[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (9))){
var inst_62819 = (state_62846[(2)]);
var inst_62820 = fluree.db.util.async.throw_err.call(null,inst_62819);
var state_62846__$1 = state_62846;
var statearr_62859_62880 = state_62846__$1;
(statearr_62859_62880[(2)] = inst_62820);

(statearr_62859_62880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (5))){
var _ = (function (){var statearr_62860 = state_62846;
(statearr_62860[(4)] = cljs.core.rest.call(null,(state_62846[(4)])));

return statearr_62860;
})();
var state_62846__$1 = state_62846;
var ex62857 = (state_62846__$1[(2)]);
var statearr_62861_62881 = state_62846__$1;
(statearr_62861_62881[(5)] = ex62857);


if((ex62857 instanceof Error)){
var statearr_62862_62882 = state_62846__$1;
(statearr_62862_62882[(1)] = (4));

(statearr_62862_62882[(5)] = null);

} else {
throw ex62857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62847 === (10))){
var state_62846__$1 = state_62846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62846__$1,(13),coll);
} else {
if((state_val_62847 === (8))){
var inst_62831 = (state_62846[(2)]);
var inst_62832 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_62831);
var inst_62833 = cljs.core.count.call(null,inst_62832);
var inst_62834 = ((9) + inst_62833);
var inst_62835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62836 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62837 = ["count",inst_62831,inst_62833];
var inst_62838 = cljs.core.PersistentHashMap.fromArrays(inst_62836,inst_62837);
var inst_62839 = [inst_62838,inst_62834];
var inst_62840 = (new cljs.core.PersistentVector(null,2,(5),inst_62835,inst_62839,null));
var inst_62841 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62840);
var _ = (function (){var statearr_62863 = state_62846;
(statearr_62863[(4)] = cljs.core.rest.call(null,(state_62846[(4)])));

return statearr_62863;
})();
var state_62846__$1 = (function (){var statearr_62864 = state_62846;
(statearr_62864[(7)] = inst_62841);

return statearr_62864;
})();
var statearr_62865_62883 = state_62846__$1;
(statearr_62865_62883[(2)] = inst_62833);

(statearr_62865_62883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_62866 = [null,null,null,null,null,null,null,null];
(statearr_62866[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_62866[(1)] = (1));

return statearr_62866;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_62846){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62867){var ex__2749__auto__ = e62867;
var statearr_62868_62884 = state_62846;
(statearr_62868_62884[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62846[(4)]))){
var statearr_62869_62885 = state_62846;
(statearr_62869_62885[(1)] = cljs.core.first.call(null,(state_62846[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62886 = state_62846;
state_62846 = G__62886;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_62846){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_62846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62870 = f__2769__auto__.call(null);
(statearr_62870[(6)] = c__2768__auto__);

return statearr_62870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__62887,subject,pred){
var map__62888 = p__62887;
var map__62888__$1 = cljs.core.__destructure_map.call(null,map__62888);
var _QMARK_ctx = map__62888__$1;
var cache = cljs.core.get.call(null,map__62888__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__62888__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62979){
var state_val_62980 = (state_62979[(1)]);
if((state_val_62980 === (7))){
var state_62979__$1 = state_62979;
var statearr_62981_63037 = state_62979__$1;
(statearr_62981_63037[(2)] = subject);

(statearr_62981_63037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (20))){
var state_62979__$1 = state_62979;
var statearr_62982_63038 = state_62979__$1;
(statearr_62982_63038[(2)] = cache);

(statearr_62982_63038[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (27))){
var inst_62922 = (state_62979[(7)]);
var inst_62910 = (state_62979[(8)]);
var inst_62936 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_62922,inst_62910);
var state_62979__$1 = state_62979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62979__$1,(29),inst_62936);
} else {
if((state_val_62980 === (1))){
var state_62979__$1 = state_62979;
var statearr_62983_63039 = state_62979__$1;
(statearr_62983_63039[(2)] = null);

(statearr_62983_63039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (24))){
var inst_62922 = (state_62979[(7)]);
var inst_62949 = cljs.core.int_QMARK_.call(null,inst_62922);
var state_62979__$1 = state_62979;
if(inst_62949){
var statearr_62984_63040 = state_62979__$1;
(statearr_62984_63040[(1)] = (30));

} else {
var statearr_62985_63041 = state_62979__$1;
(statearr_62985_63041[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (4))){
var inst_62889 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
var statearr_62986_63042 = state_62979__$1;
(statearr_62986_63042[(2)] = inst_62889);

(statearr_62986_63042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (15))){
var inst_62902 = (state_62979[(9)]);
var state_62979__$1 = state_62979;
var statearr_62987_63043 = state_62979__$1;
(statearr_62987_63043[(2)] = inst_62902);

(statearr_62987_63043[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (21))){
var inst_62923 = (state_62979[(10)]);
var state_62979__$1 = state_62979;
var statearr_62988_63044 = state_62979__$1;
(statearr_62988_63044[(2)] = inst_62923);

(statearr_62988_63044[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (31))){
var state_62979__$1 = state_62979;
var statearr_62989_63045 = state_62979__$1;
(statearr_62989_63045[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (32))){
var inst_62962 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
var statearr_62991_63046 = state_62979__$1;
(statearr_62991_63046[(2)] = inst_62962);

(statearr_62991_63046[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (33))){
var inst_62953 = (state_62979[(2)]);
var inst_62954 = fluree.db.util.async.throw_err.call(null,inst_62953);
var state_62979__$1 = state_62979;
var statearr_62992_63047 = state_62979__$1;
(statearr_62992_63047[(2)] = inst_62954);

(statearr_62992_63047[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (13))){
var inst_62906 = (state_62979[(2)]);
var inst_62907 = fluree.db.util.async.throw_err.call(null,inst_62906);
var state_62979__$1 = state_62979;
var statearr_62993_63048 = state_62979__$1;
(statearr_62993_63048[(2)] = inst_62907);

(statearr_62993_63048[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (22))){
var inst_62927 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
if(cljs.core.truth_(inst_62927)){
var statearr_62994_63049 = state_62979__$1;
(statearr_62994_63049[(1)] = (23));

} else {
var statearr_62995_63050 = state_62979__$1;
(statearr_62995_63050[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (36))){
var inst_62960 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
var statearr_62996_63051 = state_62979__$1;
(statearr_62996_63051[(2)] = inst_62960);

(statearr_62996_63051[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (29))){
var inst_62922 = (state_62979[(7)]);
var inst_62910 = (state_62979[(8)]);
var inst_62938 = (state_62979[(2)]);
var inst_62939 = fluree.db.util.async.throw_err.call(null,inst_62938);
var inst_62940 = cljs.core._deref.call(null,cache);
var inst_62941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62942 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_62922,inst_62910];
var inst_62943 = (new cljs.core.PersistentVector(null,3,(5),inst_62941,inst_62942,null));
var inst_62944 = cljs.core.assoc_in.call(null,inst_62940,inst_62943,inst_62939);
var inst_62945 = cljs.core._vreset_BANG_.call(null,cache,inst_62944);
var state_62979__$1 = (function (){var statearr_62997 = state_62979;
(statearr_62997[(11)] = inst_62945);

return statearr_62997;
})();
var statearr_62998_63052 = state_62979__$1;
(statearr_62998_63052[(2)] = inst_62939);

(statearr_62998_63052[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (6))){
var state_62979__$1 = state_62979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62979__$1,(9),subject);
} else {
if((state_val_62980 === (28))){
var inst_62947 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
var statearr_62999_63053 = state_62979__$1;
(statearr_62999_63053[(2)] = inst_62947);

(statearr_62999_63053[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (25))){
var inst_62902 = (state_62979[(9)]);
var inst_62910 = (state_62979[(8)]);
var inst_62964 = (state_62979[(2)]);
var inst_62965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62966 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62968 = [inst_62902,inst_62910];
var inst_62969 = (new cljs.core.PersistentVector(null,2,(5),inst_62967,inst_62968,null));
var inst_62970 = ["get",inst_62969,inst_62964];
var inst_62971 = cljs.core.PersistentHashMap.fromArrays(inst_62966,inst_62970);
var inst_62972 = [inst_62971,(10)];
var inst_62973 = (new cljs.core.PersistentVector(null,2,(5),inst_62965,inst_62972,null));
var inst_62974 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62973);
var _ = (function (){var statearr_63000 = state_62979;
(statearr_63000[(4)] = cljs.core.rest.call(null,(state_62979[(4)])));

return statearr_63000;
})();
var state_62979__$1 = (function (){var statearr_63001 = state_62979;
(statearr_63001[(12)] = inst_62974);

return statearr_63001;
})();
var statearr_63002_63054 = state_62979__$1;
(statearr_63002_63054[(2)] = inst_62964);

(statearr_63002_63054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (34))){
var inst_62922 = (state_62979[(7)]);
var inst_62910 = (state_62979[(8)]);
var inst_62957 = fluree.db.dbfunctions.internal.get.call(null,inst_62922,inst_62910);
var state_62979__$1 = state_62979;
var statearr_63003_63055 = state_62979__$1;
(statearr_63003_63055[(2)] = inst_62957);

(statearr_63003_63055[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (17))){
var inst_62902 = (state_62979[(9)]);
var inst_62916 = cljs.core.first.call(null,inst_62902);
var state_62979__$1 = state_62979;
var statearr_63004_63056 = state_62979__$1;
(statearr_63004_63056[(2)] = inst_62916);

(statearr_63004_63056[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (3))){
var inst_62977 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62979__$1,inst_62977);
} else {
if((state_val_62980 === (12))){
var inst_62902 = (state_62979[(9)]);
var inst_62910 = (state_62979[(2)]);
var inst_62911 = cljs.core.vector_QMARK_.call(null,inst_62902);
var state_62979__$1 = (function (){var statearr_63005 = state_62979;
(statearr_63005[(8)] = inst_62910);

return statearr_63005;
})();
if(inst_62911){
var statearr_63006_63057 = state_62979__$1;
(statearr_63006_63057[(1)] = (14));

} else {
var statearr_63007_63058 = state_62979__$1;
(statearr_63007_63058[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (2))){
var _ = (function (){var statearr_63008 = state_62979;
(statearr_63008[(4)] = cljs.core.cons.call(null,(5),(state_62979[(4)])));

return statearr_63008;
})();
var inst_62895 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_62979__$1 = state_62979;
if(inst_62895){
var statearr_63009_63059 = state_62979__$1;
(statearr_63009_63059[(1)] = (6));

} else {
var statearr_63010_63060 = state_62979__$1;
(statearr_63010_63060[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (23))){
var inst_62922 = (state_62979[(7)]);
var inst_62933 = (state_62979[(13)]);
var inst_62910 = (state_62979[(8)]);
var inst_62929 = cljs.core.deref.call(null,cache);
var inst_62930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62931 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_62922,inst_62910];
var inst_62932 = (new cljs.core.PersistentVector(null,3,(5),inst_62930,inst_62931,null));
var inst_62933__$1 = cljs.core.get_in.call(null,inst_62929,inst_62932);
var state_62979__$1 = (function (){var statearr_63011 = state_62979;
(statearr_63011[(13)] = inst_62933__$1);

return statearr_63011;
})();
if(cljs.core.truth_(inst_62933__$1)){
var statearr_63012_63061 = state_62979__$1;
(statearr_63012_63061[(1)] = (26));

} else {
var statearr_63013_63062 = state_62979__$1;
(statearr_63013_63062[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (35))){
var state_62979__$1 = state_62979;
var statearr_63014_63063 = state_62979__$1;
(statearr_63014_63063[(2)] = null);

(statearr_63014_63063[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (19))){
var inst_62919 = (state_62979[(2)]);
var state_62979__$1 = state_62979;
var statearr_63015_63064 = state_62979__$1;
(statearr_63015_63064[(2)] = inst_62919);

(statearr_63015_63064[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (11))){
var state_62979__$1 = state_62979;
var statearr_63017_63065 = state_62979__$1;
(statearr_63017_63065[(2)] = pred);

(statearr_63017_63065[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (9))){
var inst_62898 = (state_62979[(2)]);
var inst_62899 = fluree.db.util.async.throw_err.call(null,inst_62898);
var state_62979__$1 = state_62979;
var statearr_63018_63066 = state_62979__$1;
(statearr_63018_63066[(2)] = inst_62899);

(statearr_63018_63066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (5))){
var _ = (function (){var statearr_63019 = state_62979;
(statearr_63019[(4)] = cljs.core.rest.call(null,(state_62979[(4)])));

return statearr_63019;
})();
var state_62979__$1 = state_62979;
var ex63016 = (state_62979__$1[(2)]);
var statearr_63020_63067 = state_62979__$1;
(statearr_63020_63067[(5)] = ex63016);


if((ex63016 instanceof Error)){
var statearr_63021_63068 = state_62979__$1;
(statearr_63021_63068[(1)] = (4));

(statearr_63021_63068[(5)] = null);

} else {
throw ex63016;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (14))){
var inst_62902 = (state_62979[(9)]);
var inst_62913 = cljs.core.count.call(null,inst_62902);
var inst_62914 = cljs.core._EQ_.call(null,(1),inst_62913);
var state_62979__$1 = state_62979;
if(inst_62914){
var statearr_63022_63069 = state_62979__$1;
(statearr_63022_63069[(1)] = (17));

} else {
var statearr_63023_63070 = state_62979__$1;
(statearr_63023_63070[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (26))){
var inst_62933 = (state_62979[(13)]);
var state_62979__$1 = state_62979;
var statearr_63024_63071 = state_62979__$1;
(statearr_63024_63071[(2)] = inst_62933);

(statearr_63024_63071[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (16))){
var inst_62922 = (state_62979[(7)]);
var inst_62923 = (state_62979[(10)]);
var inst_62922__$1 = (state_62979[(2)]);
var inst_62923__$1 = cljs.core.int_QMARK_.call(null,inst_62922__$1);
var state_62979__$1 = (function (){var statearr_63025 = state_62979;
(statearr_63025[(7)] = inst_62922__$1);

(statearr_63025[(10)] = inst_62923__$1);

return statearr_63025;
})();
if(inst_62923__$1){
var statearr_63026_63072 = state_62979__$1;
(statearr_63026_63072[(1)] = (20));

} else {
var statearr_63027_63073 = state_62979__$1;
(statearr_63027_63073[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (30))){
var inst_62922 = (state_62979[(7)]);
var inst_62910 = (state_62979[(8)]);
var inst_62951 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_62922,inst_62910);
var state_62979__$1 = state_62979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62979__$1,(33),inst_62951);
} else {
if((state_val_62980 === (10))){
var state_62979__$1 = state_62979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62979__$1,(13),pred);
} else {
if((state_val_62980 === (18))){
var inst_62902 = (state_62979[(9)]);
var state_62979__$1 = state_62979;
var statearr_63028_63074 = state_62979__$1;
(statearr_63028_63074[(2)] = inst_62902);

(statearr_63028_63074[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62980 === (8))){
var inst_62902 = (state_62979[(2)]);
var inst_62903 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_62979__$1 = (function (){var statearr_63029 = state_62979;
(statearr_63029[(9)] = inst_62902);

return statearr_63029;
})();
if(inst_62903){
var statearr_63030_63075 = state_62979__$1;
(statearr_63030_63075[(1)] = (10));

} else {
var statearr_63031_63076 = state_62979__$1;
(statearr_63031_63076[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_63032 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63032[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_63032[(1)] = (1));

return statearr_63032;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_62979){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63033){var ex__2749__auto__ = e63033;
var statearr_63034_63077 = state_62979;
(statearr_63034_63077[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62979[(4)]))){
var statearr_63035_63078 = state_62979;
(statearr_63035_63078[(1)] = cljs.core.first.call(null,(state_62979[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63079 = state_62979;
state_62979 = G__63079;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_62979){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_62979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63036 = f__2769__auto__.call(null);
(statearr_63036[(6)] = c__2768__auto__);

return statearr_63036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63118){
var state_val_63119 = (state_63118[(1)]);
if((state_val_63119 === (7))){
var inst_63086 = (state_63118[(7)]);
var state_63118__$1 = state_63118;
var statearr_63120_63144 = state_63118__$1;
(statearr_63120_63144[(2)] = inst_63086);

(statearr_63120_63144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (1))){
var state_63118__$1 = state_63118;
var statearr_63121_63145 = state_63118__$1;
(statearr_63121_63145[(2)] = null);

(statearr_63121_63145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (4))){
var inst_63080 = (state_63118[(2)]);
var state_63118__$1 = state_63118;
var statearr_63122_63146 = state_63118__$1;
(statearr_63122_63146[(2)] = inst_63080);

(statearr_63122_63146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (6))){
var inst_63088 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_63118__$1 = state_63118;
var statearr_63123_63147 = state_63118__$1;
(statearr_63123_63147[(2)] = inst_63088);

(statearr_63123_63147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (3))){
var inst_63116 = (state_63118[(2)]);
var state_63118__$1 = state_63118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63118__$1,inst_63116);
} else {
if((state_val_63119 === (12))){
var inst_63098 = (state_63118[(2)]);
var inst_63099 = fluree.db.util.async.throw_err.call(null,inst_63098);
var inst_63100 = cljs.core.nth.call(null,inst_63099,(0),null);
var inst_63101 = cljs.core.nth.call(null,inst_63099,(1),null);
var inst_63102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63103 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63104 = ["?pO","?ctx",inst_63100];
var inst_63105 = cljs.core.PersistentHashMap.fromArrays(inst_63103,inst_63104);
var inst_63106 = ((10) + inst_63101);
var inst_63107 = [inst_63105,inst_63106];
var inst_63108 = (new cljs.core.PersistentVector(null,2,(5),inst_63102,inst_63107,null));
var inst_63109 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63108);
var state_63118__$1 = (function (){var statearr_63124 = state_63118;
(statearr_63124[(8)] = inst_63109);

return statearr_63124;
})();
var statearr_63125_63148 = state_63118__$1;
(statearr_63125_63148[(2)] = inst_63100);

(statearr_63125_63148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (2))){
var inst_63086 = (state_63118[(7)]);
var _ = (function (){var statearr_63126 = state_63118;
(statearr_63126[(4)] = cljs.core.cons.call(null,(5),(state_63118[(4)])));

return statearr_63126;
})();
var inst_63086__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_63118__$1 = (function (){var statearr_63127 = state_63118;
(statearr_63127[(7)] = inst_63086__$1);

return statearr_63127;
})();
if(cljs.core.truth_(inst_63086__$1)){
var statearr_63128_63149 = state_63118__$1;
(statearr_63128_63149[(1)] = (6));

} else {
var statearr_63129_63150 = state_63118__$1;
(statearr_63129_63150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (11))){
var inst_63113 = (state_63118[(2)]);
var _ = (function (){var statearr_63131 = state_63118;
(statearr_63131[(4)] = cljs.core.rest.call(null,(state_63118[(4)])));

return statearr_63131;
})();
var state_63118__$1 = state_63118;
var statearr_63132_63151 = state_63118__$1;
(statearr_63132_63151[(2)] = inst_63113);

(statearr_63132_63151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (9))){
var inst_63096 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_63118__$1 = state_63118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63118__$1,(12),inst_63096);
} else {
if((state_val_63119 === (5))){
var _ = (function (){var statearr_63133 = state_63118;
(statearr_63133[(4)] = cljs.core.rest.call(null,(state_63118[(4)])));

return statearr_63133;
})();
var state_63118__$1 = state_63118;
var ex63130 = (state_63118__$1[(2)]);
var statearr_63134_63152 = state_63118__$1;
(statearr_63134_63152[(5)] = ex63130);


if((ex63130 instanceof Error)){
var statearr_63135_63153 = state_63118__$1;
(statearr_63135_63153[(1)] = (4));

(statearr_63135_63153[(5)] = null);

} else {
throw ex63130;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (10))){
var inst_63111 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_63118__$1 = state_63118;
var statearr_63136_63154 = state_63118__$1;
(statearr_63136_63154[(2)] = inst_63111);

(statearr_63136_63154[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63119 === (8))){
var inst_63091 = (state_63118[(2)]);
var state_63118__$1 = state_63118;
if(cljs.core.truth_(inst_63091)){
var statearr_63137_63155 = state_63118__$1;
(statearr_63137_63155[(1)] = (9));

} else {
var statearr_63138_63156 = state_63118__$1;
(statearr_63138_63156[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_63139 = [null,null,null,null,null,null,null,null,null];
(statearr_63139[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_63139[(1)] = (1));

return statearr_63139;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_63118){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63140){var ex__2749__auto__ = e63140;
var statearr_63141_63157 = state_63118;
(statearr_63141_63157[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63118[(4)]))){
var statearr_63142_63158 = state_63118;
(statearr_63142_63158[(1)] = cljs.core.first.call(null,(state_63118[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63159 = state_63118;
state_63118 = G__63159;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_63118){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_63118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63143 = f__2769__auto__.call(null);
(statearr_63143[(6)] = c__2768__auto__);

return statearr_63143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63228){
var state_val_63229 = (state_63228[(1)]);
if((state_val_63229 === (7))){
var state_63228__$1 = state_63228;
var statearr_63230_63268 = state_63228__$1;
(statearr_63230_63268[(2)] = subject);

(statearr_63230_63268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (20))){
var inst_63184 = (state_63228[(7)]);
var inst_63196 = (state_63228[(8)]);
var inst_63199 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_63196,inst_63184);
var state_63228__$1 = state_63228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63228__$1,(23),inst_63199);
} else {
if((state_val_63229 === (1))){
var state_63228__$1 = state_63228;
var statearr_63231_63269 = state_63228__$1;
(statearr_63231_63269[(2)] = null);

(statearr_63231_63269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (4))){
var inst_63160 = (state_63228[(2)]);
var state_63228__$1 = state_63228;
var statearr_63232_63270 = state_63228__$1;
(statearr_63232_63270[(2)] = inst_63160);

(statearr_63232_63270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (15))){
var inst_63176 = (state_63228[(9)]);
var state_63228__$1 = state_63228;
var statearr_63233_63271 = state_63228__$1;
(statearr_63233_63271[(2)] = inst_63176);

(statearr_63233_63271[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (21))){
var inst_63184 = (state_63228[(7)]);
var inst_63196 = (state_63228[(8)]);
var inst_63204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63205 = fluree.db.dbfunctions.internal.get_all.call(null,inst_63196,inst_63184);
var inst_63206 = cljs.core.count.call(null,inst_63184);
var inst_63207 = ((9) + inst_63206);
var inst_63208 = [inst_63205,inst_63207];
var inst_63209 = (new cljs.core.PersistentVector(null,2,(5),inst_63204,inst_63208,null));
var state_63228__$1 = state_63228;
var statearr_63234_63272 = state_63228__$1;
(statearr_63234_63272[(2)] = inst_63209);

(statearr_63234_63272[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (13))){
var inst_63180 = (state_63228[(2)]);
var inst_63181 = fluree.db.util.async.throw_err.call(null,inst_63180);
var state_63228__$1 = state_63228;
var statearr_63235_63273 = state_63228__$1;
(statearr_63235_63273[(2)] = inst_63181);

(statearr_63235_63273[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (22))){
var inst_63184 = (state_63228[(7)]);
var inst_63176 = (state_63228[(9)]);
var inst_63211 = (state_63228[(2)]);
var inst_63212 = cljs.core.nth.call(null,inst_63211,(0),null);
var inst_63213 = cljs.core.nth.call(null,inst_63211,(1),null);
var inst_63214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63215 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63217 = [inst_63176,inst_63184];
var inst_63218 = (new cljs.core.PersistentVector(null,2,(5),inst_63216,inst_63217,null));
var inst_63219 = ["get-all",inst_63218,inst_63212];
var inst_63220 = cljs.core.PersistentHashMap.fromArrays(inst_63215,inst_63219);
var inst_63221 = [inst_63220,inst_63213];
var inst_63222 = (new cljs.core.PersistentVector(null,2,(5),inst_63214,inst_63221,null));
var inst_63223 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63222);
var _ = (function (){var statearr_63236 = state_63228;
(statearr_63236[(4)] = cljs.core.rest.call(null,(state_63228[(4)])));

return statearr_63236;
})();
var state_63228__$1 = (function (){var statearr_63237 = state_63228;
(statearr_63237[(10)] = inst_63223);

return statearr_63237;
})();
var statearr_63238_63274 = state_63228__$1;
(statearr_63238_63274[(2)] = inst_63212);

(statearr_63238_63274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (6))){
var state_63228__$1 = state_63228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63228__$1,(9),subject);
} else {
if((state_val_63229 === (17))){
var inst_63176 = (state_63228[(9)]);
var inst_63190 = cljs.core.first.call(null,inst_63176);
var state_63228__$1 = state_63228;
var statearr_63239_63275 = state_63228__$1;
(statearr_63239_63275[(2)] = inst_63190);

(statearr_63239_63275[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (3))){
var inst_63226 = (state_63228[(2)]);
var state_63228__$1 = state_63228;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63228__$1,inst_63226);
} else {
if((state_val_63229 === (12))){
var inst_63176 = (state_63228[(9)]);
var inst_63184 = (state_63228[(2)]);
var inst_63185 = cljs.core.vector_QMARK_.call(null,inst_63176);
var state_63228__$1 = (function (){var statearr_63240 = state_63228;
(statearr_63240[(7)] = inst_63184);

return statearr_63240;
})();
if(inst_63185){
var statearr_63241_63276 = state_63228__$1;
(statearr_63241_63276[(1)] = (14));

} else {
var statearr_63242_63277 = state_63228__$1;
(statearr_63242_63277[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (2))){
var _ = (function (){var statearr_63243 = state_63228;
(statearr_63243[(4)] = cljs.core.cons.call(null,(5),(state_63228[(4)])));

return statearr_63243;
})();
var inst_63169 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_63228__$1 = state_63228;
if(inst_63169){
var statearr_63244_63278 = state_63228__$1;
(statearr_63244_63278[(1)] = (6));

} else {
var statearr_63245_63279 = state_63228__$1;
(statearr_63245_63279[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (23))){
var inst_63201 = (state_63228[(2)]);
var inst_63202 = fluree.db.util.async.throw_err.call(null,inst_63201);
var state_63228__$1 = state_63228;
var statearr_63246_63280 = state_63228__$1;
(statearr_63246_63280[(2)] = inst_63202);

(statearr_63246_63280[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (19))){
var inst_63193 = (state_63228[(2)]);
var state_63228__$1 = state_63228;
var statearr_63247_63281 = state_63228__$1;
(statearr_63247_63281[(2)] = inst_63193);

(statearr_63247_63281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (11))){
var state_63228__$1 = state_63228;
var statearr_63249_63282 = state_63228__$1;
(statearr_63249_63282[(2)] = path);

(statearr_63249_63282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (9))){
var inst_63172 = (state_63228[(2)]);
var inst_63173 = fluree.db.util.async.throw_err.call(null,inst_63172);
var state_63228__$1 = state_63228;
var statearr_63250_63283 = state_63228__$1;
(statearr_63250_63283[(2)] = inst_63173);

(statearr_63250_63283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (5))){
var _ = (function (){var statearr_63251 = state_63228;
(statearr_63251[(4)] = cljs.core.rest.call(null,(state_63228[(4)])));

return statearr_63251;
})();
var state_63228__$1 = state_63228;
var ex63248 = (state_63228__$1[(2)]);
var statearr_63252_63284 = state_63228__$1;
(statearr_63252_63284[(5)] = ex63248);


if((ex63248 instanceof Error)){
var statearr_63253_63285 = state_63228__$1;
(statearr_63253_63285[(1)] = (4));

(statearr_63253_63285[(5)] = null);

} else {
throw ex63248;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (14))){
var inst_63176 = (state_63228[(9)]);
var inst_63187 = cljs.core.count.call(null,inst_63176);
var inst_63188 = cljs.core._EQ_.call(null,(1),inst_63187);
var state_63228__$1 = state_63228;
if(inst_63188){
var statearr_63254_63286 = state_63228__$1;
(statearr_63254_63286[(1)] = (17));

} else {
var statearr_63255_63287 = state_63228__$1;
(statearr_63255_63287[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (16))){
var inst_63196 = (state_63228[(8)]);
var inst_63196__$1 = (state_63228[(2)]);
var inst_63197 = cljs.core.int_QMARK_.call(null,inst_63196__$1);
var state_63228__$1 = (function (){var statearr_63256 = state_63228;
(statearr_63256[(8)] = inst_63196__$1);

return statearr_63256;
})();
if(inst_63197){
var statearr_63257_63288 = state_63228__$1;
(statearr_63257_63288[(1)] = (20));

} else {
var statearr_63258_63289 = state_63228__$1;
(statearr_63258_63289[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (10))){
var state_63228__$1 = state_63228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63228__$1,(13),path);
} else {
if((state_val_63229 === (18))){
var inst_63176 = (state_63228[(9)]);
var state_63228__$1 = state_63228;
var statearr_63259_63290 = state_63228__$1;
(statearr_63259_63290[(2)] = inst_63176);

(statearr_63259_63290[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63229 === (8))){
var inst_63176 = (state_63228[(2)]);
var inst_63177 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_63228__$1 = (function (){var statearr_63260 = state_63228;
(statearr_63260[(9)] = inst_63176);

return statearr_63260;
})();
if(inst_63177){
var statearr_63261_63291 = state_63228__$1;
(statearr_63261_63291[(1)] = (10));

} else {
var statearr_63262_63292 = state_63228__$1;
(statearr_63262_63292[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_63263 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63263[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_63263[(1)] = (1));

return statearr_63263;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_63228){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63228);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63264){var ex__2749__auto__ = e63264;
var statearr_63265_63293 = state_63228;
(statearr_63265_63293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63228[(4)]))){
var statearr_63266_63294 = state_63228;
(statearr_63266_63294[(1)] = cljs.core.first.call(null,(state_63228[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63295 = state_63228;
state_63228 = G__63295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_63228){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_63228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63267 = f__2769__auto__.call(null);
(statearr_63267[(6)] = c__2768__auto__);

return statearr_63267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63334){
var state_val_63335 = (state_63334[(1)]);
if((state_val_63335 === (7))){
var state_63334__$1 = state_63334;
var statearr_63336_63360 = state_63334__$1;
(statearr_63336_63360[(2)] = subject);

(statearr_63336_63360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (1))){
var state_63334__$1 = state_63334;
var statearr_63337_63361 = state_63334__$1;
(statearr_63337_63361[(2)] = null);

(statearr_63337_63361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (4))){
var inst_63296 = (state_63334[(2)]);
var state_63334__$1 = state_63334;
var statearr_63338_63362 = state_63334__$1;
(statearr_63338_63362[(2)] = inst_63296);

(statearr_63338_63362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (13))){
var inst_63313 = (state_63334[(2)]);
var inst_63314 = fluree.db.util.async.throw_err.call(null,inst_63313);
var state_63334__$1 = state_63334;
var statearr_63339_63363 = state_63334__$1;
(statearr_63339_63363[(2)] = inst_63314);

(statearr_63339_63363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (6))){
var state_63334__$1 = state_63334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63334__$1,(9),subject);
} else {
if((state_val_63335 === (3))){
var inst_63332 = (state_63334[(2)]);
var state_63334__$1 = state_63334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63334__$1,inst_63332);
} else {
if((state_val_63335 === (12))){
var inst_63309 = (state_63334[(7)]);
var inst_63317 = (state_63334[(2)]);
var inst_63318 = fluree.db.dbfunctions.internal.get_in.call(null,inst_63309,inst_63317);
var inst_63319 = cljs.core.count.call(null,inst_63317);
var inst_63320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63321 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63323 = [inst_63309,inst_63317];
var inst_63324 = (new cljs.core.PersistentVector(null,2,(5),inst_63322,inst_63323,null));
var inst_63325 = ["get-in",inst_63324,inst_63318];
var inst_63326 = cljs.core.PersistentHashMap.fromArrays(inst_63321,inst_63325);
var inst_63327 = [inst_63326,inst_63319];
var inst_63328 = (new cljs.core.PersistentVector(null,2,(5),inst_63320,inst_63327,null));
var inst_63329 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63328);
var _ = (function (){var statearr_63340 = state_63334;
(statearr_63340[(4)] = cljs.core.rest.call(null,(state_63334[(4)])));

return statearr_63340;
})();
var state_63334__$1 = (function (){var statearr_63341 = state_63334;
(statearr_63341[(8)] = inst_63329);

return statearr_63341;
})();
var statearr_63342_63364 = state_63334__$1;
(statearr_63342_63364[(2)] = inst_63318);

(statearr_63342_63364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (2))){
var _ = (function (){var statearr_63343 = state_63334;
(statearr_63343[(4)] = cljs.core.cons.call(null,(5),(state_63334[(4)])));

return statearr_63343;
})();
var inst_63302 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_63334__$1 = state_63334;
if(inst_63302){
var statearr_63344_63365 = state_63334__$1;
(statearr_63344_63365[(1)] = (6));

} else {
var statearr_63345_63366 = state_63334__$1;
(statearr_63345_63366[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (11))){
var state_63334__$1 = state_63334;
var statearr_63347_63367 = state_63334__$1;
(statearr_63347_63367[(2)] = path);

(statearr_63347_63367[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (9))){
var inst_63305 = (state_63334[(2)]);
var inst_63306 = fluree.db.util.async.throw_err.call(null,inst_63305);
var state_63334__$1 = state_63334;
var statearr_63348_63368 = state_63334__$1;
(statearr_63348_63368[(2)] = inst_63306);

(statearr_63348_63368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (5))){
var _ = (function (){var statearr_63349 = state_63334;
(statearr_63349[(4)] = cljs.core.rest.call(null,(state_63334[(4)])));

return statearr_63349;
})();
var state_63334__$1 = state_63334;
var ex63346 = (state_63334__$1[(2)]);
var statearr_63350_63369 = state_63334__$1;
(statearr_63350_63369[(5)] = ex63346);


if((ex63346 instanceof Error)){
var statearr_63351_63370 = state_63334__$1;
(statearr_63351_63370[(1)] = (4));

(statearr_63351_63370[(5)] = null);

} else {
throw ex63346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63335 === (10))){
var state_63334__$1 = state_63334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63334__$1,(13),path);
} else {
if((state_val_63335 === (8))){
var inst_63309 = (state_63334[(2)]);
var inst_63310 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_63334__$1 = (function (){var statearr_63352 = state_63334;
(statearr_63352[(7)] = inst_63309);

return statearr_63352;
})();
if(inst_63310){
var statearr_63353_63371 = state_63334__$1;
(statearr_63353_63371[(1)] = (10));

} else {
var statearr_63354_63372 = state_63334__$1;
(statearr_63354_63372[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_63355 = [null,null,null,null,null,null,null,null,null];
(statearr_63355[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_63355[(1)] = (1));

return statearr_63355;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_63334){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63356){var ex__2749__auto__ = e63356;
var statearr_63357_63373 = state_63334;
(statearr_63357_63373[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63334[(4)]))){
var statearr_63358_63374 = state_63334;
(statearr_63358_63374[(1)] = cljs.core.first.call(null,(state_63334[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63375 = state_63334;
state_63334 = G__63375;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_63334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_63334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63359 = f__2769__auto__.call(null);
(statearr_63359[(6)] = c__2768__auto__);

return statearr_63359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__63376,key_or_ks){
var map__63377 = p__63376;
var map__63377__$1 = cljs.core.__destructure_map.call(null,map__63377);
var _QMARK_ctx = map__63377__$1;
var db = cljs.core.get.call(null,map__63377__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63422){
var state_val_63423 = (state_63422[(1)]);
if((state_val_63423 === (7))){
var state_63422__$1 = state_63422;
var statearr_63424_63453 = state_63422__$1;
(statearr_63424_63453[(2)] = coll);

(statearr_63424_63453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (1))){
var state_63422__$1 = state_63422;
var statearr_63425_63454 = state_63422__$1;
(statearr_63425_63454[(2)] = null);

(statearr_63425_63454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (4))){
var inst_63378 = (state_63422[(2)]);
var state_63422__$1 = state_63422;
var statearr_63426_63455 = state_63422__$1;
(statearr_63426_63455[(2)] = inst_63378);

(statearr_63426_63455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (15))){
var inst_63398 = (state_63422[(7)]);
var inst_63406 = (state_63422[(2)]);
var inst_63407 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_63398,inst_63406);
var inst_63408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63409 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63411 = [inst_63398,inst_63406];
var inst_63412 = (new cljs.core.PersistentVector(null,2,(5),inst_63410,inst_63411,null));
var inst_63413 = ["contains?",inst_63412,inst_63407];
var inst_63414 = cljs.core.PersistentHashMap.fromArrays(inst_63409,inst_63413);
var inst_63415 = [inst_63414,(10)];
var inst_63416 = (new cljs.core.PersistentVector(null,2,(5),inst_63408,inst_63415,null));
var inst_63417 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63416);
var _ = (function (){var statearr_63427 = state_63422;
(statearr_63427[(4)] = cljs.core.rest.call(null,(state_63422[(4)])));

return statearr_63427;
})();
var state_63422__$1 = (function (){var statearr_63428 = state_63422;
(statearr_63428[(8)] = inst_63417);

return statearr_63428;
})();
var statearr_63429_63456 = state_63422__$1;
(statearr_63429_63456[(2)] = inst_63407);

(statearr_63429_63456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (13))){
var state_63422__$1 = state_63422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63422__$1,(16),key);
} else {
if((state_val_63423 === (6))){
var state_63422__$1 = state_63422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63422__$1,(9),coll);
} else {
if((state_val_63423 === (3))){
var inst_63420 = (state_63422[(2)]);
var state_63422__$1 = state_63422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63422__$1,inst_63420);
} else {
if((state_val_63423 === (12))){
var inst_63398 = (state_63422[(2)]);
var inst_63399 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_63422__$1 = (function (){var statearr_63430 = state_63422;
(statearr_63430[(7)] = inst_63398);

return statearr_63430;
})();
if(inst_63399){
var statearr_63431_63457 = state_63422__$1;
(statearr_63431_63457[(1)] = (13));

} else {
var statearr_63432_63458 = state_63422__$1;
(statearr_63432_63458[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (2))){
var _ = (function (){var statearr_63433 = state_63422;
(statearr_63433[(4)] = cljs.core.cons.call(null,(5),(state_63422[(4)])));

return statearr_63433;
})();
var inst_63384 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_63422__$1 = state_63422;
if(inst_63384){
var statearr_63434_63459 = state_63422__$1;
(statearr_63434_63459[(1)] = (6));

} else {
var statearr_63435_63460 = state_63422__$1;
(statearr_63435_63460[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (11))){
var inst_63391 = (state_63422[(9)]);
var inst_63395 = cljs.core.flatten.call(null,inst_63391);
var inst_63396 = cljs.core.set.call(null,inst_63395);
var state_63422__$1 = state_63422;
var statearr_63437_63461 = state_63422__$1;
(statearr_63437_63461[(2)] = inst_63396);

(statearr_63437_63461[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (9))){
var inst_63387 = (state_63422[(2)]);
var inst_63388 = fluree.db.util.async.throw_err.call(null,inst_63387);
var state_63422__$1 = state_63422;
var statearr_63438_63462 = state_63422__$1;
(statearr_63438_63462[(2)] = inst_63388);

(statearr_63438_63462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (5))){
var _ = (function (){var statearr_63439 = state_63422;
(statearr_63439[(4)] = cljs.core.rest.call(null,(state_63422[(4)])));

return statearr_63439;
})();
var state_63422__$1 = state_63422;
var ex63436 = (state_63422__$1[(2)]);
var statearr_63440_63463 = state_63422__$1;
(statearr_63440_63463[(5)] = ex63436);


if((ex63436 instanceof Error)){
var statearr_63441_63464 = state_63422__$1;
(statearr_63441_63464[(1)] = (4));

(statearr_63441_63464[(5)] = null);

} else {
throw ex63436;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (14))){
var state_63422__$1 = state_63422;
var statearr_63442_63465 = state_63422__$1;
(statearr_63442_63465[(2)] = key);

(statearr_63442_63465[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (16))){
var inst_63402 = (state_63422[(2)]);
var inst_63403 = fluree.db.util.async.throw_err.call(null,inst_63402);
var state_63422__$1 = state_63422;
var statearr_63443_63466 = state_63422__$1;
(statearr_63443_63466[(2)] = inst_63403);

(statearr_63443_63466[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (10))){
var inst_63391 = (state_63422[(9)]);
var state_63422__$1 = state_63422;
var statearr_63444_63467 = state_63422__$1;
(statearr_63444_63467[(2)] = inst_63391);

(statearr_63444_63467[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (8))){
var inst_63391 = (state_63422[(9)]);
var inst_63391__$1 = (state_63422[(2)]);
var inst_63392 = cljs.core.set_QMARK_.call(null,inst_63391__$1);
var state_63422__$1 = (function (){var statearr_63445 = state_63422;
(statearr_63445[(9)] = inst_63391__$1);

return statearr_63445;
})();
if(inst_63392){
var statearr_63446_63468 = state_63422__$1;
(statearr_63446_63468[(1)] = (10));

} else {
var statearr_63447_63469 = state_63422__$1;
(statearr_63447_63469[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_63448 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63448[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_63448[(1)] = (1));

return statearr_63448;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_63422){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63449){var ex__2749__auto__ = e63449;
var statearr_63450_63470 = state_63422;
(statearr_63450_63470[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63422[(4)]))){
var statearr_63451_63471 = state_63422;
(statearr_63451_63471[(1)] = cljs.core.first.call(null,(state_63422[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63472 = state_63422;
state_63422 = G__63472;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_63422){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_63422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63452 = f__2769__auto__.call(null);
(statearr_63452[(6)] = c__2768__auto__);

return statearr_63452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63544 = arguments.length;
var i__5770__auto___63545 = (0);
while(true){
if((i__5770__auto___63545 < len__5769__auto___63544)){
args__5775__auto__.push((arguments[i__5770__auto___63545]));

var G__63546 = (i__5770__auto___63545 + (1));
i__5770__auto___63545 = G__63546;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63518){
var state_val_63519 = (state_63518[(1)]);
if((state_val_63519 === (7))){
var inst_63484 = (state_63518[(7)]);
var inst_63488 = cljs.core.first.call(null,inst_63484);
var inst_63489 = cljs.core.coll_QMARK_.call(null,inst_63488);
var state_63518__$1 = state_63518;
var statearr_63520_63547 = state_63518__$1;
(statearr_63520_63547[(2)] = inst_63489);

(statearr_63520_63547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (1))){
var state_63518__$1 = state_63518;
var statearr_63521_63548 = state_63518__$1;
(statearr_63521_63548[(2)] = null);

(statearr_63521_63548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (4))){
var inst_63475 = (state_63518[(2)]);
var state_63518__$1 = state_63518;
var statearr_63522_63549 = state_63518__$1;
(statearr_63522_63549[(2)] = inst_63475);

(statearr_63522_63549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (6))){
var inst_63484 = (state_63518[(7)]);
var inst_63486 = (state_63518[(8)]);
var inst_63483 = (state_63518[(2)]);
var inst_63484__$1 = fluree.db.util.async.throw_err.call(null,inst_63483);
var inst_63485 = cljs.core.count.call(null,inst_63484__$1);
var inst_63486__$1 = cljs.core._EQ_.call(null,(1),inst_63485);
var state_63518__$1 = (function (){var statearr_63523 = state_63518;
(statearr_63523[(7)] = inst_63484__$1);

(statearr_63523[(8)] = inst_63486__$1);

return statearr_63523;
})();
if(inst_63486__$1){
var statearr_63524_63550 = state_63518__$1;
(statearr_63524_63550[(1)] = (7));

} else {
var statearr_63525_63551 = state_63518__$1;
(statearr_63525_63551[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (3))){
var inst_63516 = (state_63518[(2)]);
var state_63518__$1 = state_63518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63518__$1,inst_63516);
} else {
if((state_val_63519 === (12))){
var inst_63497 = (state_63518[(2)]);
var inst_63498 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_63497);
var inst_63499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63500 = [inst_63497];
var inst_63501 = (new cljs.core.PersistentVector(null,1,(5),inst_63499,inst_63500,null));
var inst_63502 = cljs.core.count.call(null,inst_63501);
var inst_63503 = ((9) + inst_63502);
var inst_63504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63505 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63507 = [inst_63497];
var inst_63508 = (new cljs.core.PersistentVector(null,1,(5),inst_63506,inst_63507,null));
var inst_63509 = ["hash-set",inst_63508,inst_63498];
var inst_63510 = cljs.core.PersistentHashMap.fromArrays(inst_63505,inst_63509);
var inst_63511 = [inst_63510,inst_63503];
var inst_63512 = (new cljs.core.PersistentVector(null,2,(5),inst_63504,inst_63511,null));
var inst_63513 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63512);
var _ = (function (){var statearr_63526 = state_63518;
(statearr_63526[(4)] = cljs.core.rest.call(null,(state_63518[(4)])));

return statearr_63526;
})();
var state_63518__$1 = (function (){var statearr_63527 = state_63518;
(statearr_63527[(9)] = inst_63513);

return statearr_63527;
})();
var statearr_63528_63552 = state_63518__$1;
(statearr_63528_63552[(2)] = inst_63498);

(statearr_63528_63552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (2))){
var _ = (function (){var statearr_63529 = state_63518;
(statearr_63529[(4)] = cljs.core.cons.call(null,(5),(state_63518[(4)])));

return statearr_63529;
})();
var inst_63481 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63518__$1 = state_63518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63518__$1,(6),inst_63481);
} else {
if((state_val_63519 === (11))){
var inst_63484 = (state_63518[(7)]);
var state_63518__$1 = state_63518;
var statearr_63531_63553 = state_63518__$1;
(statearr_63531_63553[(2)] = inst_63484);

(statearr_63531_63553[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (9))){
var inst_63492 = (state_63518[(2)]);
var state_63518__$1 = state_63518;
if(cljs.core.truth_(inst_63492)){
var statearr_63532_63554 = state_63518__$1;
(statearr_63532_63554[(1)] = (10));

} else {
var statearr_63533_63555 = state_63518__$1;
(statearr_63533_63555[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (5))){
var _ = (function (){var statearr_63534 = state_63518;
(statearr_63534[(4)] = cljs.core.rest.call(null,(state_63518[(4)])));

return statearr_63534;
})();
var state_63518__$1 = state_63518;
var ex63530 = (state_63518__$1[(2)]);
var statearr_63535_63556 = state_63518__$1;
(statearr_63535_63556[(5)] = ex63530);


if((ex63530 instanceof Error)){
var statearr_63536_63557 = state_63518__$1;
(statearr_63536_63557[(1)] = (4));

(statearr_63536_63557[(5)] = null);

} else {
throw ex63530;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (10))){
var inst_63484 = (state_63518[(7)]);
var inst_63494 = cljs.core.first.call(null,inst_63484);
var state_63518__$1 = state_63518;
var statearr_63537_63558 = state_63518__$1;
(statearr_63537_63558[(2)] = inst_63494);

(statearr_63537_63558[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63519 === (8))){
var inst_63486 = (state_63518[(8)]);
var state_63518__$1 = state_63518;
var statearr_63538_63559 = state_63518__$1;
(statearr_63538_63559[(2)] = inst_63486);

(statearr_63538_63559[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63539 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63539[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63539[(1)] = (1));

return statearr_63539;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63518){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63540){var ex__2749__auto__ = e63540;
var statearr_63541_63560 = state_63518;
(statearr_63541_63560[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63518[(4)]))){
var statearr_63542_63561 = state_63518;
(statearr_63542_63561[(1)] = cljs.core.first.call(null,(state_63518[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63562 = state_63518;
state_63518 = G__63562;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63518){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63543 = f__2769__auto__.call(null);
(statearr_63543[(6)] = c__2768__auto__);

return statearr_63543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq63473){
var G__63474 = cljs.core.first.call(null,seq63473);
var seq63473__$1 = cljs.core.next.call(null,seq63473);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63474,seq63473__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63612 = arguments.length;
var i__5770__auto___63613 = (0);
while(true){
if((i__5770__auto___63613 < len__5769__auto___63612)){
args__5775__auto__.push((arguments[i__5770__auto___63613]));

var G__63614 = (i__5770__auto___63613 + (1));
i__5770__auto___63613 = G__63614;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63595){
var state_val_63596 = (state_63595[(1)]);
if((state_val_63596 === (1))){
var state_63595__$1 = state_63595;
var statearr_63597_63615 = state_63595__$1;
(statearr_63597_63615[(2)] = null);

(statearr_63597_63615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63596 === (2))){
var _ = (function (){var statearr_63598 = state_63595;
(statearr_63598[(4)] = cljs.core.cons.call(null,(5),(state_63595[(4)])));

return statearr_63598;
})();
var inst_63571 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63595__$1 = state_63595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63595__$1,(6),inst_63571);
} else {
if((state_val_63596 === (3))){
var inst_63593 = (state_63595[(2)]);
var state_63595__$1 = state_63595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63595__$1,inst_63593);
} else {
if((state_val_63596 === (4))){
var inst_63565 = (state_63595[(2)]);
var state_63595__$1 = state_63595;
var statearr_63600_63616 = state_63595__$1;
(statearr_63600_63616[(2)] = inst_63565);

(statearr_63600_63616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63596 === (5))){
var _ = (function (){var statearr_63601 = state_63595;
(statearr_63601[(4)] = cljs.core.rest.call(null,(state_63595[(4)])));

return statearr_63601;
})();
var state_63595__$1 = state_63595;
var ex63599 = (state_63595__$1[(2)]);
var statearr_63602_63617 = state_63595__$1;
(statearr_63602_63617[(5)] = ex63599);


if((ex63599 instanceof Error)){
var statearr_63603_63618 = state_63595__$1;
(statearr_63603_63618[(1)] = (4));

(statearr_63603_63618[(5)] = null);

} else {
throw ex63599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63596 === (6))){
var inst_63573 = (state_63595[(2)]);
var inst_63574 = fluree.db.util.async.throw_err.call(null,inst_63573);
var inst_63575 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_63574);
var inst_63576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63577 = [inst_63574];
var inst_63578 = (new cljs.core.PersistentVector(null,1,(5),inst_63576,inst_63577,null));
var inst_63579 = cljs.core.count.call(null,inst_63578);
var inst_63580 = ((9) + inst_63579);
var inst_63581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63582 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63584 = [inst_63574];
var inst_63585 = (new cljs.core.PersistentVector(null,1,(5),inst_63583,inst_63584,null));
var inst_63586 = ["==",inst_63585,inst_63575];
var inst_63587 = cljs.core.PersistentHashMap.fromArrays(inst_63582,inst_63586);
var inst_63588 = [inst_63587,inst_63580];
var inst_63589 = (new cljs.core.PersistentVector(null,2,(5),inst_63581,inst_63588,null));
var inst_63590 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63589);
var _ = (function (){var statearr_63604 = state_63595;
(statearr_63604[(4)] = cljs.core.rest.call(null,(state_63595[(4)])));

return statearr_63604;
})();
var state_63595__$1 = (function (){var statearr_63605 = state_63595;
(statearr_63605[(7)] = inst_63590);

return statearr_63605;
})();
var statearr_63606_63619 = state_63595__$1;
(statearr_63606_63619[(2)] = inst_63575);

(statearr_63606_63619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63607 = [null,null,null,null,null,null,null,null];
(statearr_63607[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63607[(1)] = (1));

return statearr_63607;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63595){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63608){var ex__2749__auto__ = e63608;
var statearr_63609_63620 = state_63595;
(statearr_63609_63620[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63595[(4)]))){
var statearr_63610_63621 = state_63595;
(statearr_63610_63621[(1)] = cljs.core.first.call(null,(state_63595[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63622 = state_63595;
state_63595 = G__63622;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63595){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63611 = f__2769__auto__.call(null);
(statearr_63611[(6)] = c__2768__auto__);

return statearr_63611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq63563){
var G__63564 = cljs.core.first.call(null,seq63563);
var seq63563__$1 = cljs.core.next.call(null,seq63563);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63564,seq63563__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63672 = arguments.length;
var i__5770__auto___63673 = (0);
while(true){
if((i__5770__auto___63673 < len__5769__auto___63672)){
args__5775__auto__.push((arguments[i__5770__auto___63673]));

var G__63674 = (i__5770__auto___63673 + (1));
i__5770__auto___63673 = G__63674;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63655){
var state_val_63656 = (state_63655[(1)]);
if((state_val_63656 === (1))){
var state_63655__$1 = state_63655;
var statearr_63657_63675 = state_63655__$1;
(statearr_63657_63675[(2)] = null);

(statearr_63657_63675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (2))){
var _ = (function (){var statearr_63658 = state_63655;
(statearr_63658[(4)] = cljs.core.cons.call(null,(5),(state_63655[(4)])));

return statearr_63658;
})();
var inst_63631 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63655__$1 = state_63655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63655__$1,(6),inst_63631);
} else {
if((state_val_63656 === (3))){
var inst_63653 = (state_63655[(2)]);
var state_63655__$1 = state_63655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63655__$1,inst_63653);
} else {
if((state_val_63656 === (4))){
var inst_63625 = (state_63655[(2)]);
var state_63655__$1 = state_63655;
var statearr_63660_63676 = state_63655__$1;
(statearr_63660_63676[(2)] = inst_63625);

(statearr_63660_63676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (5))){
var _ = (function (){var statearr_63661 = state_63655;
(statearr_63661[(4)] = cljs.core.rest.call(null,(state_63655[(4)])));

return statearr_63661;
})();
var state_63655__$1 = state_63655;
var ex63659 = (state_63655__$1[(2)]);
var statearr_63662_63677 = state_63655__$1;
(statearr_63662_63677[(5)] = ex63659);


if((ex63659 instanceof Error)){
var statearr_63663_63678 = state_63655__$1;
(statearr_63663_63678[(1)] = (4));

(statearr_63663_63678[(5)] = null);

} else {
throw ex63659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (6))){
var inst_63633 = (state_63655[(2)]);
var inst_63634 = fluree.db.util.async.throw_err.call(null,inst_63633);
var inst_63635 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_63634);
var inst_63636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63637 = [inst_63634];
var inst_63638 = (new cljs.core.PersistentVector(null,1,(5),inst_63636,inst_63637,null));
var inst_63639 = cljs.core.count.call(null,inst_63638);
var inst_63640 = ((9) + inst_63639);
var inst_63641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63642 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63644 = [inst_63634];
var inst_63645 = (new cljs.core.PersistentVector(null,1,(5),inst_63643,inst_63644,null));
var inst_63646 = [">",inst_63645,inst_63635];
var inst_63647 = cljs.core.PersistentHashMap.fromArrays(inst_63642,inst_63646);
var inst_63648 = [inst_63647,inst_63640];
var inst_63649 = (new cljs.core.PersistentVector(null,2,(5),inst_63641,inst_63648,null));
var inst_63650 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63649);
var _ = (function (){var statearr_63664 = state_63655;
(statearr_63664[(4)] = cljs.core.rest.call(null,(state_63655[(4)])));

return statearr_63664;
})();
var state_63655__$1 = (function (){var statearr_63665 = state_63655;
(statearr_63665[(7)] = inst_63650);

return statearr_63665;
})();
var statearr_63666_63679 = state_63655__$1;
(statearr_63666_63679[(2)] = inst_63635);

(statearr_63666_63679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63667 = [null,null,null,null,null,null,null,null];
(statearr_63667[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63667[(1)] = (1));

return statearr_63667;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63655){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63668){var ex__2749__auto__ = e63668;
var statearr_63669_63680 = state_63655;
(statearr_63669_63680[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63655[(4)]))){
var statearr_63670_63681 = state_63655;
(statearr_63670_63681[(1)] = cljs.core.first.call(null,(state_63655[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63682 = state_63655;
state_63655 = G__63682;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63655){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63671 = f__2769__auto__.call(null);
(statearr_63671[(6)] = c__2768__auto__);

return statearr_63671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq63623){
var G__63624 = cljs.core.first.call(null,seq63623);
var seq63623__$1 = cljs.core.next.call(null,seq63623);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63624,seq63623__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63732 = arguments.length;
var i__5770__auto___63733 = (0);
while(true){
if((i__5770__auto___63733 < len__5769__auto___63732)){
args__5775__auto__.push((arguments[i__5770__auto___63733]));

var G__63734 = (i__5770__auto___63733 + (1));
i__5770__auto___63733 = G__63734;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63715){
var state_val_63716 = (state_63715[(1)]);
if((state_val_63716 === (1))){
var state_63715__$1 = state_63715;
var statearr_63717_63735 = state_63715__$1;
(statearr_63717_63735[(2)] = null);

(statearr_63717_63735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63716 === (2))){
var _ = (function (){var statearr_63718 = state_63715;
(statearr_63718[(4)] = cljs.core.cons.call(null,(5),(state_63715[(4)])));

return statearr_63718;
})();
var inst_63691 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63715__$1 = state_63715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63715__$1,(6),inst_63691);
} else {
if((state_val_63716 === (3))){
var inst_63713 = (state_63715[(2)]);
var state_63715__$1 = state_63715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63715__$1,inst_63713);
} else {
if((state_val_63716 === (4))){
var inst_63685 = (state_63715[(2)]);
var state_63715__$1 = state_63715;
var statearr_63720_63736 = state_63715__$1;
(statearr_63720_63736[(2)] = inst_63685);

(statearr_63720_63736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63716 === (5))){
var _ = (function (){var statearr_63721 = state_63715;
(statearr_63721[(4)] = cljs.core.rest.call(null,(state_63715[(4)])));

return statearr_63721;
})();
var state_63715__$1 = state_63715;
var ex63719 = (state_63715__$1[(2)]);
var statearr_63722_63737 = state_63715__$1;
(statearr_63722_63737[(5)] = ex63719);


if((ex63719 instanceof Error)){
var statearr_63723_63738 = state_63715__$1;
(statearr_63723_63738[(1)] = (4));

(statearr_63723_63738[(5)] = null);

} else {
throw ex63719;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63716 === (6))){
var inst_63693 = (state_63715[(2)]);
var inst_63694 = fluree.db.util.async.throw_err.call(null,inst_63693);
var inst_63695 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_63694);
var inst_63696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63697 = [inst_63694];
var inst_63698 = (new cljs.core.PersistentVector(null,1,(5),inst_63696,inst_63697,null));
var inst_63699 = cljs.core.count.call(null,inst_63698);
var inst_63700 = ((9) + inst_63699);
var inst_63701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63702 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63704 = [inst_63694];
var inst_63705 = (new cljs.core.PersistentVector(null,1,(5),inst_63703,inst_63704,null));
var inst_63706 = ["<",inst_63705,inst_63695];
var inst_63707 = cljs.core.PersistentHashMap.fromArrays(inst_63702,inst_63706);
var inst_63708 = [inst_63707,inst_63700];
var inst_63709 = (new cljs.core.PersistentVector(null,2,(5),inst_63701,inst_63708,null));
var inst_63710 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63709);
var _ = (function (){var statearr_63724 = state_63715;
(statearr_63724[(4)] = cljs.core.rest.call(null,(state_63715[(4)])));

return statearr_63724;
})();
var state_63715__$1 = (function (){var statearr_63725 = state_63715;
(statearr_63725[(7)] = inst_63710);

return statearr_63725;
})();
var statearr_63726_63739 = state_63715__$1;
(statearr_63726_63739[(2)] = inst_63695);

(statearr_63726_63739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63727 = [null,null,null,null,null,null,null,null];
(statearr_63727[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63727[(1)] = (1));

return statearr_63727;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63715){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63728){var ex__2749__auto__ = e63728;
var statearr_63729_63740 = state_63715;
(statearr_63729_63740[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63715[(4)]))){
var statearr_63730_63741 = state_63715;
(statearr_63730_63741[(1)] = cljs.core.first.call(null,(state_63715[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63742 = state_63715;
state_63715 = G__63742;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63715){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63731 = f__2769__auto__.call(null);
(statearr_63731[(6)] = c__2768__auto__);

return statearr_63731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq63683){
var G__63684 = cljs.core.first.call(null,seq63683);
var seq63683__$1 = cljs.core.next.call(null,seq63683);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63684,seq63683__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63792 = arguments.length;
var i__5770__auto___63793 = (0);
while(true){
if((i__5770__auto___63793 < len__5769__auto___63792)){
args__5775__auto__.push((arguments[i__5770__auto___63793]));

var G__63794 = (i__5770__auto___63793 + (1));
i__5770__auto___63793 = G__63794;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63775){
var state_val_63776 = (state_63775[(1)]);
if((state_val_63776 === (1))){
var state_63775__$1 = state_63775;
var statearr_63777_63795 = state_63775__$1;
(statearr_63777_63795[(2)] = null);

(statearr_63777_63795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63776 === (2))){
var _ = (function (){var statearr_63778 = state_63775;
(statearr_63778[(4)] = cljs.core.cons.call(null,(5),(state_63775[(4)])));

return statearr_63778;
})();
var inst_63751 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63775__$1 = state_63775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63775__$1,(6),inst_63751);
} else {
if((state_val_63776 === (3))){
var inst_63773 = (state_63775[(2)]);
var state_63775__$1 = state_63775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63775__$1,inst_63773);
} else {
if((state_val_63776 === (4))){
var inst_63745 = (state_63775[(2)]);
var state_63775__$1 = state_63775;
var statearr_63780_63796 = state_63775__$1;
(statearr_63780_63796[(2)] = inst_63745);

(statearr_63780_63796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63776 === (5))){
var _ = (function (){var statearr_63781 = state_63775;
(statearr_63781[(4)] = cljs.core.rest.call(null,(state_63775[(4)])));

return statearr_63781;
})();
var state_63775__$1 = state_63775;
var ex63779 = (state_63775__$1[(2)]);
var statearr_63782_63797 = state_63775__$1;
(statearr_63782_63797[(5)] = ex63779);


if((ex63779 instanceof Error)){
var statearr_63783_63798 = state_63775__$1;
(statearr_63783_63798[(1)] = (4));

(statearr_63783_63798[(5)] = null);

} else {
throw ex63779;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63776 === (6))){
var inst_63753 = (state_63775[(2)]);
var inst_63754 = fluree.db.util.async.throw_err.call(null,inst_63753);
var inst_63755 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_63754);
var inst_63756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63757 = [inst_63754];
var inst_63758 = (new cljs.core.PersistentVector(null,1,(5),inst_63756,inst_63757,null));
var inst_63759 = cljs.core.count.call(null,inst_63758);
var inst_63760 = ((9) + inst_63759);
var inst_63761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63762 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63764 = [inst_63754];
var inst_63765 = (new cljs.core.PersistentVector(null,1,(5),inst_63763,inst_63764,null));
var inst_63766 = ["<=",inst_63765,inst_63755];
var inst_63767 = cljs.core.PersistentHashMap.fromArrays(inst_63762,inst_63766);
var inst_63768 = [inst_63767,inst_63760];
var inst_63769 = (new cljs.core.PersistentVector(null,2,(5),inst_63761,inst_63768,null));
var inst_63770 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63769);
var _ = (function (){var statearr_63784 = state_63775;
(statearr_63784[(4)] = cljs.core.rest.call(null,(state_63775[(4)])));

return statearr_63784;
})();
var state_63775__$1 = (function (){var statearr_63785 = state_63775;
(statearr_63785[(7)] = inst_63770);

return statearr_63785;
})();
var statearr_63786_63799 = state_63775__$1;
(statearr_63786_63799[(2)] = inst_63755);

(statearr_63786_63799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63787 = [null,null,null,null,null,null,null,null];
(statearr_63787[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63787[(1)] = (1));

return statearr_63787;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63775){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63788){var ex__2749__auto__ = e63788;
var statearr_63789_63800 = state_63775;
(statearr_63789_63800[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63775[(4)]))){
var statearr_63790_63801 = state_63775;
(statearr_63790_63801[(1)] = cljs.core.first.call(null,(state_63775[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63802 = state_63775;
state_63775 = G__63802;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63775){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63791 = f__2769__auto__.call(null);
(statearr_63791[(6)] = c__2768__auto__);

return statearr_63791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq63743){
var G__63744 = cljs.core.first.call(null,seq63743);
var seq63743__$1 = cljs.core.next.call(null,seq63743);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63744,seq63743__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63852 = arguments.length;
var i__5770__auto___63853 = (0);
while(true){
if((i__5770__auto___63853 < len__5769__auto___63852)){
args__5775__auto__.push((arguments[i__5770__auto___63853]));

var G__63854 = (i__5770__auto___63853 + (1));
i__5770__auto___63853 = G__63854;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63835){
var state_val_63836 = (state_63835[(1)]);
if((state_val_63836 === (1))){
var state_63835__$1 = state_63835;
var statearr_63837_63855 = state_63835__$1;
(statearr_63837_63855[(2)] = null);

(statearr_63837_63855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63836 === (2))){
var _ = (function (){var statearr_63838 = state_63835;
(statearr_63838[(4)] = cljs.core.cons.call(null,(5),(state_63835[(4)])));

return statearr_63838;
})();
var inst_63811 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63835__$1 = state_63835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63835__$1,(6),inst_63811);
} else {
if((state_val_63836 === (3))){
var inst_63833 = (state_63835[(2)]);
var state_63835__$1 = state_63835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63835__$1,inst_63833);
} else {
if((state_val_63836 === (4))){
var inst_63805 = (state_63835[(2)]);
var state_63835__$1 = state_63835;
var statearr_63840_63856 = state_63835__$1;
(statearr_63840_63856[(2)] = inst_63805);

(statearr_63840_63856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63836 === (5))){
var _ = (function (){var statearr_63841 = state_63835;
(statearr_63841[(4)] = cljs.core.rest.call(null,(state_63835[(4)])));

return statearr_63841;
})();
var state_63835__$1 = state_63835;
var ex63839 = (state_63835__$1[(2)]);
var statearr_63842_63857 = state_63835__$1;
(statearr_63842_63857[(5)] = ex63839);


if((ex63839 instanceof Error)){
var statearr_63843_63858 = state_63835__$1;
(statearr_63843_63858[(1)] = (4));

(statearr_63843_63858[(5)] = null);

} else {
throw ex63839;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63836 === (6))){
var inst_63813 = (state_63835[(2)]);
var inst_63814 = fluree.db.util.async.throw_err.call(null,inst_63813);
var inst_63815 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_63814);
var inst_63816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63817 = [inst_63814];
var inst_63818 = (new cljs.core.PersistentVector(null,1,(5),inst_63816,inst_63817,null));
var inst_63819 = cljs.core.count.call(null,inst_63818);
var inst_63820 = ((9) + inst_63819);
var inst_63821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63822 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63824 = [inst_63814];
var inst_63825 = (new cljs.core.PersistentVector(null,1,(5),inst_63823,inst_63824,null));
var inst_63826 = [">=",inst_63825,inst_63815];
var inst_63827 = cljs.core.PersistentHashMap.fromArrays(inst_63822,inst_63826);
var inst_63828 = [inst_63827,inst_63820];
var inst_63829 = (new cljs.core.PersistentVector(null,2,(5),inst_63821,inst_63828,null));
var inst_63830 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63829);
var _ = (function (){var statearr_63844 = state_63835;
(statearr_63844[(4)] = cljs.core.rest.call(null,(state_63835[(4)])));

return statearr_63844;
})();
var state_63835__$1 = (function (){var statearr_63845 = state_63835;
(statearr_63845[(7)] = inst_63830);

return statearr_63845;
})();
var statearr_63846_63859 = state_63835__$1;
(statearr_63846_63859[(2)] = inst_63815);

(statearr_63846_63859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63847 = [null,null,null,null,null,null,null,null];
(statearr_63847[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63847[(1)] = (1));

return statearr_63847;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63835){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63848){var ex__2749__auto__ = e63848;
var statearr_63849_63860 = state_63835;
(statearr_63849_63860[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63835[(4)]))){
var statearr_63850_63861 = state_63835;
(statearr_63850_63861[(1)] = cljs.core.first.call(null,(state_63835[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63862 = state_63835;
state_63835 = G__63862;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63835){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63851 = f__2769__auto__.call(null);
(statearr_63851[(6)] = c__2768__auto__);

return statearr_63851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq63803){
var G__63804 = cljs.core.first.call(null,seq63803);
var seq63803__$1 = cljs.core.next.call(null,seq63803);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63804,seq63803__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63912 = arguments.length;
var i__5770__auto___63913 = (0);
while(true){
if((i__5770__auto___63913 < len__5769__auto___63912)){
args__5775__auto__.push((arguments[i__5770__auto___63913]));

var G__63914 = (i__5770__auto___63913 + (1));
i__5770__auto___63913 = G__63914;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63895){
var state_val_63896 = (state_63895[(1)]);
if((state_val_63896 === (1))){
var state_63895__$1 = state_63895;
var statearr_63897_63915 = state_63895__$1;
(statearr_63897_63915[(2)] = null);

(statearr_63897_63915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63896 === (2))){
var _ = (function (){var statearr_63898 = state_63895;
(statearr_63898[(4)] = cljs.core.cons.call(null,(5),(state_63895[(4)])));

return statearr_63898;
})();
var inst_63871 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63895__$1 = state_63895;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63895__$1,(6),inst_63871);
} else {
if((state_val_63896 === (3))){
var inst_63893 = (state_63895[(2)]);
var state_63895__$1 = state_63895;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63895__$1,inst_63893);
} else {
if((state_val_63896 === (4))){
var inst_63865 = (state_63895[(2)]);
var state_63895__$1 = state_63895;
var statearr_63900_63916 = state_63895__$1;
(statearr_63900_63916[(2)] = inst_63865);

(statearr_63900_63916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63896 === (5))){
var _ = (function (){var statearr_63901 = state_63895;
(statearr_63901[(4)] = cljs.core.rest.call(null,(state_63895[(4)])));

return statearr_63901;
})();
var state_63895__$1 = state_63895;
var ex63899 = (state_63895__$1[(2)]);
var statearr_63902_63917 = state_63895__$1;
(statearr_63902_63917[(5)] = ex63899);


if((ex63899 instanceof Error)){
var statearr_63903_63918 = state_63895__$1;
(statearr_63903_63918[(1)] = (4));

(statearr_63903_63918[(5)] = null);

} else {
throw ex63899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63896 === (6))){
var inst_63873 = (state_63895[(2)]);
var inst_63874 = fluree.db.util.async.throw_err.call(null,inst_63873);
var inst_63875 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_63874);
var inst_63876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63877 = [inst_63874];
var inst_63878 = (new cljs.core.PersistentVector(null,1,(5),inst_63876,inst_63877,null));
var inst_63879 = cljs.core.count.call(null,inst_63878);
var inst_63880 = ((9) + inst_63879);
var inst_63881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63882 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63884 = [inst_63874];
var inst_63885 = (new cljs.core.PersistentVector(null,1,(5),inst_63883,inst_63884,null));
var inst_63886 = ["not=",inst_63885,inst_63875];
var inst_63887 = cljs.core.PersistentHashMap.fromArrays(inst_63882,inst_63886);
var inst_63888 = [inst_63887,inst_63880];
var inst_63889 = (new cljs.core.PersistentVector(null,2,(5),inst_63881,inst_63888,null));
var inst_63890 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63889);
var _ = (function (){var statearr_63904 = state_63895;
(statearr_63904[(4)] = cljs.core.rest.call(null,(state_63895[(4)])));

return statearr_63904;
})();
var state_63895__$1 = (function (){var statearr_63905 = state_63895;
(statearr_63905[(7)] = inst_63890);

return statearr_63905;
})();
var statearr_63906_63919 = state_63895__$1;
(statearr_63906_63919[(2)] = inst_63875);

(statearr_63906_63919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63907 = [null,null,null,null,null,null,null,null];
(statearr_63907[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63907[(1)] = (1));

return statearr_63907;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63895){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63908){var ex__2749__auto__ = e63908;
var statearr_63909_63920 = state_63895;
(statearr_63909_63920[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63895[(4)]))){
var statearr_63910_63921 = state_63895;
(statearr_63910_63921[(1)] = cljs.core.first.call(null,(state_63895[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63922 = state_63895;
state_63895 = G__63922;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63895){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63911 = f__2769__auto__.call(null);
(statearr_63911[(6)] = c__2768__auto__);

return statearr_63911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq63863){
var G__63864 = cljs.core.first.call(null,seq63863);
var seq63863__$1 = cljs.core.next.call(null,seq63863);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63864,seq63863__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63972 = arguments.length;
var i__5770__auto___63973 = (0);
while(true){
if((i__5770__auto___63973 < len__5769__auto___63972)){
args__5775__auto__.push((arguments[i__5770__auto___63973]));

var G__63974 = (i__5770__auto___63973 + (1));
i__5770__auto___63973 = G__63974;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63955){
var state_val_63956 = (state_63955[(1)]);
if((state_val_63956 === (1))){
var state_63955__$1 = state_63955;
var statearr_63957_63975 = state_63955__$1;
(statearr_63957_63975[(2)] = null);

(statearr_63957_63975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63956 === (2))){
var _ = (function (){var statearr_63958 = state_63955;
(statearr_63958[(4)] = cljs.core.cons.call(null,(5),(state_63955[(4)])));

return statearr_63958;
})();
var inst_63931 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63955__$1 = state_63955;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63955__$1,(6),inst_63931);
} else {
if((state_val_63956 === (3))){
var inst_63953 = (state_63955[(2)]);
var state_63955__$1 = state_63955;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63955__$1,inst_63953);
} else {
if((state_val_63956 === (4))){
var inst_63925 = (state_63955[(2)]);
var state_63955__$1 = state_63955;
var statearr_63960_63976 = state_63955__$1;
(statearr_63960_63976[(2)] = inst_63925);

(statearr_63960_63976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63956 === (5))){
var _ = (function (){var statearr_63961 = state_63955;
(statearr_63961[(4)] = cljs.core.rest.call(null,(state_63955[(4)])));

return statearr_63961;
})();
var state_63955__$1 = state_63955;
var ex63959 = (state_63955__$1[(2)]);
var statearr_63962_63977 = state_63955__$1;
(statearr_63962_63977[(5)] = ex63959);


if((ex63959 instanceof Error)){
var statearr_63963_63978 = state_63955__$1;
(statearr_63963_63978[(1)] = (4));

(statearr_63963_63978[(5)] = null);

} else {
throw ex63959;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63956 === (6))){
var inst_63933 = (state_63955[(2)]);
var inst_63934 = fluree.db.util.async.throw_err.call(null,inst_63933);
var inst_63935 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_63934);
var inst_63936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63937 = [inst_63934];
var inst_63938 = (new cljs.core.PersistentVector(null,1,(5),inst_63936,inst_63937,null));
var inst_63939 = cljs.core.count.call(null,inst_63938);
var inst_63940 = ((9) + inst_63939);
var inst_63941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63942 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63944 = [inst_63934];
var inst_63945 = (new cljs.core.PersistentVector(null,1,(5),inst_63943,inst_63944,null));
var inst_63946 = ["max",inst_63945,inst_63935];
var inst_63947 = cljs.core.PersistentHashMap.fromArrays(inst_63942,inst_63946);
var inst_63948 = [inst_63947,inst_63940];
var inst_63949 = (new cljs.core.PersistentVector(null,2,(5),inst_63941,inst_63948,null));
var inst_63950 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63949);
var _ = (function (){var statearr_63964 = state_63955;
(statearr_63964[(4)] = cljs.core.rest.call(null,(state_63955[(4)])));

return statearr_63964;
})();
var state_63955__$1 = (function (){var statearr_63965 = state_63955;
(statearr_63965[(7)] = inst_63950);

return statearr_63965;
})();
var statearr_63966_63979 = state_63955__$1;
(statearr_63966_63979[(2)] = inst_63935);

(statearr_63966_63979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_63967 = [null,null,null,null,null,null,null,null];
(statearr_63967[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_63967[(1)] = (1));

return statearr_63967;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_63955){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63955);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63968){var ex__2749__auto__ = e63968;
var statearr_63969_63980 = state_63955;
(statearr_63969_63980[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63955[(4)]))){
var statearr_63970_63981 = state_63955;
(statearr_63970_63981[(1)] = cljs.core.first.call(null,(state_63955[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63982 = state_63955;
state_63955 = G__63982;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_63955){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_63955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63971 = f__2769__auto__.call(null);
(statearr_63971[(6)] = c__2768__auto__);

return statearr_63971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq63923){
var G__63924 = cljs.core.first.call(null,seq63923);
var seq63923__$1 = cljs.core.next.call(null,seq63923);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63924,seq63923__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64032 = arguments.length;
var i__5770__auto___64033 = (0);
while(true){
if((i__5770__auto___64033 < len__5769__auto___64032)){
args__5775__auto__.push((arguments[i__5770__auto___64033]));

var G__64034 = (i__5770__auto___64033 + (1));
i__5770__auto___64033 = G__64034;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64015){
var state_val_64016 = (state_64015[(1)]);
if((state_val_64016 === (1))){
var state_64015__$1 = state_64015;
var statearr_64017_64035 = state_64015__$1;
(statearr_64017_64035[(2)] = null);

(statearr_64017_64035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64016 === (2))){
var _ = (function (){var statearr_64018 = state_64015;
(statearr_64018[(4)] = cljs.core.cons.call(null,(5),(state_64015[(4)])));

return statearr_64018;
})();
var inst_63991 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64015__$1 = state_64015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64015__$1,(6),inst_63991);
} else {
if((state_val_64016 === (3))){
var inst_64013 = (state_64015[(2)]);
var state_64015__$1 = state_64015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64015__$1,inst_64013);
} else {
if((state_val_64016 === (4))){
var inst_63985 = (state_64015[(2)]);
var state_64015__$1 = state_64015;
var statearr_64020_64036 = state_64015__$1;
(statearr_64020_64036[(2)] = inst_63985);

(statearr_64020_64036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64016 === (5))){
var _ = (function (){var statearr_64021 = state_64015;
(statearr_64021[(4)] = cljs.core.rest.call(null,(state_64015[(4)])));

return statearr_64021;
})();
var state_64015__$1 = state_64015;
var ex64019 = (state_64015__$1[(2)]);
var statearr_64022_64037 = state_64015__$1;
(statearr_64022_64037[(5)] = ex64019);


if((ex64019 instanceof Error)){
var statearr_64023_64038 = state_64015__$1;
(statearr_64023_64038[(1)] = (4));

(statearr_64023_64038[(5)] = null);

} else {
throw ex64019;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64016 === (6))){
var inst_63993 = (state_64015[(2)]);
var inst_63994 = fluree.db.util.async.throw_err.call(null,inst_63993);
var inst_63995 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_63994);
var inst_63996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63997 = [inst_63994];
var inst_63998 = (new cljs.core.PersistentVector(null,1,(5),inst_63996,inst_63997,null));
var inst_63999 = cljs.core.count.call(null,inst_63998);
var inst_64000 = ((9) + inst_63999);
var inst_64001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64002 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64004 = [inst_63994];
var inst_64005 = (new cljs.core.PersistentVector(null,1,(5),inst_64003,inst_64004,null));
var inst_64006 = ["min",inst_64005,inst_63995];
var inst_64007 = cljs.core.PersistentHashMap.fromArrays(inst_64002,inst_64006);
var inst_64008 = [inst_64007,inst_64000];
var inst_64009 = (new cljs.core.PersistentVector(null,2,(5),inst_64001,inst_64008,null));
var inst_64010 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64009);
var _ = (function (){var statearr_64024 = state_64015;
(statearr_64024[(4)] = cljs.core.rest.call(null,(state_64015[(4)])));

return statearr_64024;
})();
var state_64015__$1 = (function (){var statearr_64025 = state_64015;
(statearr_64025[(7)] = inst_64010);

return statearr_64025;
})();
var statearr_64026_64039 = state_64015__$1;
(statearr_64026_64039[(2)] = inst_63995);

(statearr_64026_64039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64027 = [null,null,null,null,null,null,null,null];
(statearr_64027[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64027[(1)] = (1));

return statearr_64027;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64015){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64028){var ex__2749__auto__ = e64028;
var statearr_64029_64040 = state_64015;
(statearr_64029_64040[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64015[(4)]))){
var statearr_64030_64041 = state_64015;
(statearr_64030_64041[(1)] = cljs.core.first.call(null,(state_64015[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64042 = state_64015;
state_64015 = G__64042;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64015){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64031 = f__2769__auto__.call(null);
(statearr_64031[(6)] = c__2768__auto__);

return statearr_64031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq63983){
var G__63984 = cljs.core.first.call(null,seq63983);
var seq63983__$1 = cljs.core.next.call(null,seq63983);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63984,seq63983__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__64044 = arguments.length;
switch (G__64044) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64089){
var state_val_64090 = (state_64089[(1)]);
if((state_val_64090 === (7))){
var state_64089__$1 = state_64089;
var statearr_64091_64228 = state_64089__$1;
(statearr_64091_64228[(2)] = query_map);

(statearr_64091_64228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (1))){
var state_64089__$1 = state_64089;
var statearr_64092_64229 = state_64089__$1;
(statearr_64092_64229[(2)] = null);

(statearr_64092_64229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (4))){
var inst_64045 = (state_64089[(2)]);
var state_64089__$1 = state_64089;
var statearr_64093_64230 = state_64089__$1;
(statearr_64093_64230[(2)] = inst_64045);

(statearr_64093_64230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (13))){
var inst_64067 = (state_64089[(7)]);
var inst_64071 = (state_64089[(2)]);
var inst_64072 = fluree.db.util.async.throw_err.call(null,inst_64071);
var inst_64073 = cljs.core.nth.call(null,inst_64072,(0),null);
var inst_64074 = cljs.core.nth.call(null,inst_64072,(1),null);
var inst_64075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64076 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64078 = [inst_64067];
var inst_64079 = (new cljs.core.PersistentVector(null,1,(5),inst_64077,inst_64078,null));
var inst_64080 = ["query",inst_64079,inst_64073];
var inst_64081 = cljs.core.PersistentHashMap.fromArrays(inst_64076,inst_64080);
var inst_64082 = [inst_64081,inst_64074];
var inst_64083 = (new cljs.core.PersistentVector(null,2,(5),inst_64075,inst_64082,null));
var inst_64084 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64083);
var _ = (function (){var statearr_64094 = state_64089;
(statearr_64094[(4)] = cljs.core.rest.call(null,(state_64089[(4)])));

return statearr_64094;
})();
var state_64089__$1 = (function (){var statearr_64095 = state_64089;
(statearr_64095[(8)] = inst_64084);

return statearr_64095;
})();
var statearr_64096_64231 = state_64089__$1;
(statearr_64096_64231[(2)] = inst_64073);

(statearr_64096_64231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (6))){
var state_64089__$1 = state_64089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64089__$1,(9),query_map);
} else {
if((state_val_64090 === (3))){
var inst_64087 = (state_64089[(2)]);
var state_64089__$1 = state_64089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64089__$1,inst_64087);
} else {
if((state_val_64090 === (12))){
var inst_64067 = (state_64089[(7)]);
var inst_64067__$1 = (state_64089[(2)]);
var inst_64068 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_64069 = fluree.db.dbfunctions.internal.query.call(null,inst_64068,inst_64067__$1);
var state_64089__$1 = (function (){var statearr_64097 = state_64089;
(statearr_64097[(7)] = inst_64067__$1);

return statearr_64097;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64089__$1,(13),inst_64069);
} else {
if((state_val_64090 === (2))){
var _ = (function (){var statearr_64098 = state_64089;
(statearr_64098[(4)] = cljs.core.cons.call(null,(5),(state_64089[(4)])));

return statearr_64098;
})();
var inst_64054 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_64089__$1 = state_64089;
if(inst_64054){
var statearr_64099_64232 = state_64089__$1;
(statearr_64099_64232[(1)] = (6));

} else {
var statearr_64100_64233 = state_64089__$1;
(statearr_64100_64233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (11))){
var inst_64061 = (state_64089[(9)]);
var state_64089__$1 = state_64089;
var statearr_64102_64234 = state_64089__$1;
(statearr_64102_64234[(2)] = inst_64061);

(statearr_64102_64234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (9))){
var inst_64057 = (state_64089[(2)]);
var inst_64058 = fluree.db.util.async.throw_err.call(null,inst_64057);
var state_64089__$1 = state_64089;
var statearr_64103_64235 = state_64089__$1;
(statearr_64103_64235[(2)] = inst_64058);

(statearr_64103_64235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (5))){
var _ = (function (){var statearr_64104 = state_64089;
(statearr_64104[(4)] = cljs.core.rest.call(null,(state_64089[(4)])));

return statearr_64104;
})();
var state_64089__$1 = state_64089;
var ex64101 = (state_64089__$1[(2)]);
var statearr_64105_64236 = state_64089__$1;
(statearr_64105_64236[(5)] = ex64101);


if((ex64101 instanceof Error)){
var statearr_64106_64237 = state_64089__$1;
(statearr_64106_64237[(1)] = (4));

(statearr_64106_64237[(5)] = null);

} else {
throw ex64101;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (10))){
var inst_64061 = (state_64089[(9)]);
var inst_64064 = fluree.db.util.json.parse.call(null,inst_64061);
var state_64089__$1 = state_64089;
var statearr_64107_64238 = state_64089__$1;
(statearr_64107_64238[(2)] = inst_64064);

(statearr_64107_64238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64090 === (8))){
var inst_64061 = (state_64089[(9)]);
var inst_64061__$1 = (state_64089[(2)]);
var inst_64062 = typeof inst_64061__$1 === 'string';
var state_64089__$1 = (function (){var statearr_64108 = state_64089;
(statearr_64108[(9)] = inst_64061__$1);

return statearr_64108;
})();
if(cljs.core.truth_(inst_64062)){
var statearr_64109_64239 = state_64089__$1;
(statearr_64109_64239[(1)] = (10));

} else {
var statearr_64110_64240 = state_64089__$1;
(statearr_64110_64240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64111 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64111[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64111[(1)] = (1));

return statearr_64111;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64089){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64112){var ex__2749__auto__ = e64112;
var statearr_64113_64241 = state_64089;
(statearr_64113_64241[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64089[(4)]))){
var statearr_64114_64242 = state_64089;
(statearr_64114_64242[(1)] = cljs.core.first.call(null,(state_64089[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64243 = state_64089;
state_64089 = G__64243;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64089){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64115 = f__2769__auto__.call(null);
(statearr_64115[(6)] = c__2768__auto__);

return statearr_64115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64186){
var state_val_64187 = (state_64186[(1)]);
if((state_val_64187 === (7))){
var state_64186__$1 = state_64186;
var statearr_64188_64244 = state_64186__$1;
(statearr_64188_64244[(2)] = select);

(statearr_64188_64244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (20))){
var inst_64156 = (state_64186[(2)]);
var inst_64157 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_64186__$1 = (function (){var statearr_64189 = state_64186;
(statearr_64189[(7)] = inst_64156);

return statearr_64189;
})();
if(inst_64157){
var statearr_64190_64245 = state_64186__$1;
(statearr_64190_64245[(1)] = (22));

} else {
var statearr_64191_64246 = state_64186__$1;
(statearr_64191_64246[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (1))){
var state_64186__$1 = state_64186;
var statearr_64192_64247 = state_64186__$1;
(statearr_64192_64247[(2)] = null);

(statearr_64192_64247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (24))){
var inst_64148 = (state_64186[(8)]);
var inst_64140 = (state_64186[(9)]);
var inst_64156 = (state_64186[(7)]);
var inst_64132 = (state_64186[(10)]);
var inst_64164 = (state_64186[(2)]);
var inst_64165 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_64166 = fluree.db.dbfunctions.internal.query.call(null,inst_64165,inst_64132,inst_64140,inst_64148,inst_64156,inst_64164);
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(26),inst_64166);
} else {
if((state_val_64187 === (4))){
var inst_64116 = (state_64186[(2)]);
var state_64186__$1 = state_64186;
var statearr_64193_64248 = state_64186__$1;
(statearr_64193_64248[(2)] = inst_64116);

(statearr_64193_64248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (15))){
var state_64186__$1 = state_64186;
var statearr_64194_64249 = state_64186__$1;
(statearr_64194_64249[(2)] = where);

(statearr_64194_64249[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (21))){
var inst_64152 = (state_64186[(2)]);
var inst_64153 = fluree.db.util.async.throw_err.call(null,inst_64152);
var state_64186__$1 = state_64186;
var statearr_64195_64250 = state_64186__$1;
(statearr_64195_64250[(2)] = inst_64153);

(statearr_64195_64250[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (13))){
var inst_64136 = (state_64186[(2)]);
var inst_64137 = fluree.db.util.async.throw_err.call(null,inst_64136);
var state_64186__$1 = state_64186;
var statearr_64196_64251 = state_64186__$1;
(statearr_64196_64251[(2)] = inst_64137);

(statearr_64196_64251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (22))){
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(25),limit);
} else {
if((state_val_64187 === (6))){
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(9),select);
} else {
if((state_val_64187 === (25))){
var inst_64160 = (state_64186[(2)]);
var inst_64161 = fluree.db.util.async.throw_err.call(null,inst_64160);
var state_64186__$1 = state_64186;
var statearr_64197_64252 = state_64186__$1;
(statearr_64197_64252[(2)] = inst_64161);

(statearr_64197_64252[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (17))){
var inst_64144 = (state_64186[(2)]);
var inst_64145 = fluree.db.util.async.throw_err.call(null,inst_64144);
var state_64186__$1 = state_64186;
var statearr_64198_64253 = state_64186__$1;
(statearr_64198_64253[(2)] = inst_64145);

(statearr_64198_64253[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (3))){
var inst_64184 = (state_64186[(2)]);
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64186__$1,inst_64184);
} else {
if((state_val_64187 === (12))){
var inst_64140 = (state_64186[(2)]);
var inst_64141 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_64186__$1 = (function (){var statearr_64199 = state_64186;
(statearr_64199[(9)] = inst_64140);

return statearr_64199;
})();
if(inst_64141){
var statearr_64200_64254 = state_64186__$1;
(statearr_64200_64254[(1)] = (14));

} else {
var statearr_64201_64255 = state_64186__$1;
(statearr_64201_64255[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (2))){
var _ = (function (){var statearr_64202 = state_64186;
(statearr_64202[(4)] = cljs.core.cons.call(null,(5),(state_64186[(4)])));

return statearr_64202;
})();
var inst_64125 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_64186__$1 = state_64186;
if(inst_64125){
var statearr_64203_64256 = state_64186__$1;
(statearr_64203_64256[(1)] = (6));

} else {
var statearr_64204_64257 = state_64186__$1;
(statearr_64204_64257[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (23))){
var state_64186__$1 = state_64186;
var statearr_64205_64258 = state_64186__$1;
(statearr_64205_64258[(2)] = limit);

(statearr_64205_64258[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (19))){
var state_64186__$1 = state_64186;
var statearr_64206_64259 = state_64186__$1;
(statearr_64206_64259[(2)] = block);

(statearr_64206_64259[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (11))){
var state_64186__$1 = state_64186;
var statearr_64208_64260 = state_64186__$1;
(statearr_64208_64260[(2)] = from);

(statearr_64208_64260[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (9))){
var inst_64128 = (state_64186[(2)]);
var inst_64129 = fluree.db.util.async.throw_err.call(null,inst_64128);
var state_64186__$1 = state_64186;
var statearr_64209_64261 = state_64186__$1;
(statearr_64209_64261[(2)] = inst_64129);

(statearr_64209_64261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (5))){
var _ = (function (){var statearr_64210 = state_64186;
(statearr_64210[(4)] = cljs.core.rest.call(null,(state_64186[(4)])));

return statearr_64210;
})();
var state_64186__$1 = state_64186;
var ex64207 = (state_64186__$1[(2)]);
var statearr_64211_64262 = state_64186__$1;
(statearr_64211_64262[(5)] = ex64207);


if((ex64207 instanceof Error)){
var statearr_64212_64263 = state_64186__$1;
(statearr_64212_64263[(1)] = (4));

(statearr_64212_64263[(5)] = null);

} else {
throw ex64207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (14))){
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(17),where);
} else {
if((state_val_64187 === (26))){
var inst_64148 = (state_64186[(8)]);
var inst_64140 = (state_64186[(9)]);
var inst_64156 = (state_64186[(7)]);
var inst_64132 = (state_64186[(10)]);
var inst_64168 = (state_64186[(2)]);
var inst_64169 = fluree.db.util.async.throw_err.call(null,inst_64168);
var inst_64170 = cljs.core.nth.call(null,inst_64169,(0),null);
var inst_64171 = cljs.core.nth.call(null,inst_64169,(1),null);
var inst_64172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64173 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64175 = [inst_64132,inst_64140,inst_64148,inst_64156];
var inst_64176 = (new cljs.core.PersistentVector(null,4,(5),inst_64174,inst_64175,null));
var inst_64177 = ["query",inst_64176,inst_64170];
var inst_64178 = cljs.core.PersistentHashMap.fromArrays(inst_64173,inst_64177);
var inst_64179 = [inst_64178,inst_64171];
var inst_64180 = (new cljs.core.PersistentVector(null,2,(5),inst_64172,inst_64179,null));
var inst_64181 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64180);
var _ = (function (){var statearr_64213 = state_64186;
(statearr_64213[(4)] = cljs.core.rest.call(null,(state_64186[(4)])));

return statearr_64213;
})();
var state_64186__$1 = (function (){var statearr_64214 = state_64186;
(statearr_64214[(11)] = inst_64181);

return statearr_64214;
})();
var statearr_64215_64264 = state_64186__$1;
(statearr_64215_64264[(2)] = inst_64170);

(statearr_64215_64264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (16))){
var inst_64148 = (state_64186[(2)]);
var inst_64149 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_64186__$1 = (function (){var statearr_64216 = state_64186;
(statearr_64216[(8)] = inst_64148);

return statearr_64216;
})();
if(inst_64149){
var statearr_64217_64265 = state_64186__$1;
(statearr_64217_64265[(1)] = (18));

} else {
var statearr_64218_64266 = state_64186__$1;
(statearr_64218_64266[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (10))){
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(13),from);
} else {
if((state_val_64187 === (18))){
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(21),block);
} else {
if((state_val_64187 === (8))){
var inst_64132 = (state_64186[(2)]);
var inst_64133 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_64186__$1 = (function (){var statearr_64219 = state_64186;
(statearr_64219[(10)] = inst_64132);

return statearr_64219;
})();
if(inst_64133){
var statearr_64220_64267 = state_64186__$1;
(statearr_64220_64267[(1)] = (10));

} else {
var statearr_64221_64268 = state_64186__$1;
(statearr_64221_64268[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64222 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64222[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64222[(1)] = (1));

return statearr_64222;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64186){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64223){var ex__2749__auto__ = e64223;
var statearr_64224_64269 = state_64186;
(statearr_64224_64269[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64186[(4)]))){
var statearr_64225_64270 = state_64186;
(statearr_64225_64270[(1)] = cljs.core.first.call(null,(state_64186[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64271 = state_64186;
state_64186 = G__64271;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64186){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64226 = f__2769__auto__.call(null);
(statearr_64226[(6)] = c__2768__auto__);

return statearr_64226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64327){
var state_val_64328 = (state_64327[(1)]);
if((state_val_64328 === (7))){
var state_64327__$1 = state_64327;
var statearr_64329_64360 = state_64327__$1;
(statearr_64329_64360[(2)] = startSubject);

(statearr_64329_64360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (1))){
var state_64327__$1 = state_64327;
var statearr_64330_64361 = state_64327__$1;
(statearr_64330_64361[(2)] = null);

(statearr_64330_64361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (4))){
var inst_64272 = (state_64327[(2)]);
var state_64327__$1 = state_64327;
var statearr_64331_64362 = state_64327__$1;
(statearr_64331_64362[(2)] = inst_64272);

(statearr_64331_64362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (15))){
var inst_64304 = (state_64327[(2)]);
var inst_64305 = fluree.db.util.async.throw_err.call(null,inst_64304);
var inst_64306 = cljs.core.nth.call(null,inst_64305,(0),null);
var inst_64307 = cljs.core.nth.call(null,inst_64305,(1),null);
var inst_64308 = cljs.core.empty_QMARK_.call(null,inst_64306);
var state_64327__$1 = (function (){var statearr_64332 = state_64327;
(statearr_64332[(7)] = inst_64307);

return statearr_64332;
})();
if(inst_64308){
var statearr_64333_64363 = state_64327__$1;
(statearr_64333_64363[(1)] = (16));

} else {
var statearr_64334_64364 = state_64327__$1;
(statearr_64334_64364[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (13))){
var inst_64292 = (state_64327[(8)]);
var inst_64300 = (state_64327[(9)]);
var inst_64288 = (state_64327[(10)]);
var inst_64300__$1 = (state_64327[(2)]);
var inst_64301 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_64302 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_64301,inst_64288,inst_64292,inst_64300__$1);
var state_64327__$1 = (function (){var statearr_64335 = state_64327;
(statearr_64335[(9)] = inst_64300__$1);

return statearr_64335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64327__$1,(15),inst_64302);
} else {
if((state_val_64328 === (6))){
var state_64327__$1 = state_64327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64327__$1,(9),startSubject);
} else {
if((state_val_64328 === (17))){
var state_64327__$1 = state_64327;
var statearr_64336_64365 = state_64327__$1;
(statearr_64336_64365[(2)] = true);

(statearr_64336_64365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (3))){
var inst_64325 = (state_64327[(2)]);
var state_64327__$1 = state_64327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64327__$1,inst_64325);
} else {
if((state_val_64328 === (12))){
var state_64327__$1 = state_64327;
var statearr_64337_64366 = state_64327__$1;
(statearr_64337_64366[(2)] = endSubject);

(statearr_64337_64366[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (2))){
var _ = (function (){var statearr_64338 = state_64327;
(statearr_64338[(4)] = cljs.core.cons.call(null,(5),(state_64327[(4)])));

return statearr_64338;
})();
var inst_64281 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_64327__$1 = state_64327;
if(inst_64281){
var statearr_64339_64367 = state_64327__$1;
(statearr_64339_64367[(1)] = (6));

} else {
var statearr_64340_64368 = state_64327__$1;
(statearr_64340_64368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (11))){
var state_64327__$1 = state_64327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64327__$1,(14),endSubject);
} else {
if((state_val_64328 === (9))){
var inst_64284 = (state_64327[(2)]);
var inst_64285 = fluree.db.util.async.throw_err.call(null,inst_64284);
var state_64327__$1 = state_64327;
var statearr_64342_64369 = state_64327__$1;
(statearr_64342_64369[(2)] = inst_64285);

(statearr_64342_64369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (5))){
var _ = (function (){var statearr_64343 = state_64327;
(statearr_64343[(4)] = cljs.core.rest.call(null,(state_64327[(4)])));

return statearr_64343;
})();
var state_64327__$1 = state_64327;
var ex64341 = (state_64327__$1[(2)]);
var statearr_64344_64370 = state_64327__$1;
(statearr_64344_64370[(5)] = ex64341);


if((ex64341 instanceof Error)){
var statearr_64345_64371 = state_64327__$1;
(statearr_64345_64371[(1)] = (4));

(statearr_64345_64371[(5)] = null);

} else {
throw ex64341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (14))){
var inst_64296 = (state_64327[(2)]);
var inst_64297 = fluree.db.util.async.throw_err.call(null,inst_64296);
var state_64327__$1 = state_64327;
var statearr_64346_64372 = state_64327__$1;
(statearr_64346_64372[(2)] = inst_64297);

(statearr_64346_64372[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (16))){
var state_64327__$1 = state_64327;
var statearr_64347_64373 = state_64327__$1;
(statearr_64347_64373[(2)] = false);

(statearr_64347_64373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (10))){
var inst_64291 = (state_64327[(2)]);
var inst_64292 = fluree.db.util.async.throw_err.call(null,inst_64291);
var inst_64293 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_64327__$1 = (function (){var statearr_64348 = state_64327;
(statearr_64348[(8)] = inst_64292);

return statearr_64348;
})();
if(inst_64293){
var statearr_64349_64374 = state_64327__$1;
(statearr_64349_64374[(1)] = (11));

} else {
var statearr_64350_64375 = state_64327__$1;
(statearr_64350_64375[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (18))){
var inst_64292 = (state_64327[(8)]);
var inst_64300 = (state_64327[(9)]);
var inst_64307 = (state_64327[(7)]);
var inst_64288 = (state_64327[(10)]);
var inst_64312 = (state_64327[(2)]);
var inst_64313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64314 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64316 = [inst_64288,inst_64292,inst_64300];
var inst_64317 = (new cljs.core.PersistentVector(null,3,(5),inst_64315,inst_64316,null));
var inst_64318 = ["relationship?",inst_64317,inst_64312];
var inst_64319 = cljs.core.PersistentHashMap.fromArrays(inst_64314,inst_64318);
var inst_64320 = [inst_64319,inst_64307];
var inst_64321 = (new cljs.core.PersistentVector(null,2,(5),inst_64313,inst_64320,null));
var inst_64322 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64321);
var _ = (function (){var statearr_64351 = state_64327;
(statearr_64351[(4)] = cljs.core.rest.call(null,(state_64327[(4)])));

return statearr_64351;
})();
var state_64327__$1 = (function (){var statearr_64352 = state_64327;
(statearr_64352[(11)] = inst_64322);

return statearr_64352;
})();
var statearr_64353_64376 = state_64327__$1;
(statearr_64353_64376[(2)] = inst_64312);

(statearr_64353_64376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (8))){
var inst_64288 = (state_64327[(2)]);
var inst_64289 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_64327__$1 = (function (){var statearr_64354 = state_64327;
(statearr_64354[(10)] = inst_64288);

return statearr_64354;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64327__$1,(10),inst_64289);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_64355 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64355[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_64355[(1)] = (1));

return statearr_64355;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_64327){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64356){var ex__2749__auto__ = e64356;
var statearr_64357_64377 = state_64327;
(statearr_64357_64377[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64327[(4)]))){
var statearr_64358_64378 = state_64327;
(statearr_64358_64378[(1)] = cljs.core.first.call(null,(state_64327[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64379 = state_64327;
state_64327 = G__64379;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_64327){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_64327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64359 = f__2769__auto__.call(null);
(statearr_64359[(6)] = c__2768__auto__);

return statearr_64359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64416){
var state_val_64417 = (state_64416[(1)]);
if((state_val_64417 === (7))){
var state_64416__$1 = state_64416;
var statearr_64418_64438 = state_64416__$1;
(statearr_64418_64438[(2)] = pred_name);

(statearr_64418_64438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (1))){
var state_64416__$1 = state_64416;
var statearr_64419_64439 = state_64416__$1;
(statearr_64419_64439[(2)] = null);

(statearr_64419_64439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (4))){
var inst_64380 = (state_64416[(2)]);
var state_64416__$1 = state_64416;
var statearr_64420_64440 = state_64416__$1;
(statearr_64420_64440[(2)] = inst_64380);

(statearr_64420_64440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (6))){
var state_64416__$1 = state_64416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64416__$1,(9),pred_name);
} else {
if((state_val_64417 === (3))){
var inst_64414 = (state_64416[(2)]);
var state_64416__$1 = state_64416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64416__$1,inst_64414);
} else {
if((state_val_64417 === (2))){
var _ = (function (){var statearr_64422 = state_64416;
(statearr_64422[(4)] = cljs.core.cons.call(null,(5),(state_64416[(4)])));

return statearr_64422;
})();
var inst_64389 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_64416__$1 = state_64416;
if(inst_64389){
var statearr_64423_64441 = state_64416__$1;
(statearr_64423_64441[(1)] = (6));

} else {
var statearr_64424_64442 = state_64416__$1;
(statearr_64424_64442[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (9))){
var inst_64392 = (state_64416[(2)]);
var inst_64393 = fluree.db.util.async.throw_err.call(null,inst_64392);
var state_64416__$1 = state_64416;
var statearr_64425_64443 = state_64416__$1;
(statearr_64425_64443[(2)] = inst_64393);

(statearr_64425_64443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (5))){
var _ = (function (){var statearr_64426 = state_64416;
(statearr_64426[(4)] = cljs.core.rest.call(null,(state_64416[(4)])));

return statearr_64426;
})();
var state_64416__$1 = state_64416;
var ex64421 = (state_64416__$1[(2)]);
var statearr_64427_64444 = state_64416__$1;
(statearr_64427_64444[(5)] = ex64421);


if((ex64421 instanceof Error)){
var statearr_64428_64445 = state_64416__$1;
(statearr_64428_64445[(1)] = (4));

(statearr_64428_64445[(5)] = null);

} else {
throw ex64421;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (10))){
var inst_64396 = (state_64416[(7)]);
var inst_64400 = (state_64416[(2)]);
var inst_64401 = fluree.db.util.async.throw_err.call(null,inst_64400);
var inst_64402 = cljs.core.nth.call(null,inst_64401,(0),null);
var inst_64403 = cljs.core.nth.call(null,inst_64401,(1),null);
var inst_64404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64405 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64406 = ["max-pred-val",inst_64396,inst_64402];
var inst_64407 = cljs.core.PersistentHashMap.fromArrays(inst_64405,inst_64406);
var inst_64408 = (inst_64403 + (10));
var inst_64409 = [inst_64407,inst_64408];
var inst_64410 = (new cljs.core.PersistentVector(null,2,(5),inst_64404,inst_64409,null));
var inst_64411 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64410);
var _ = (function (){var statearr_64429 = state_64416;
(statearr_64429[(4)] = cljs.core.rest.call(null,(state_64416[(4)])));

return statearr_64429;
})();
var state_64416__$1 = (function (){var statearr_64430 = state_64416;
(statearr_64430[(8)] = inst_64411);

return statearr_64430;
})();
var statearr_64431_64446 = state_64416__$1;
(statearr_64431_64446[(2)] = inst_64402);

(statearr_64431_64446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (8))){
var inst_64396 = (state_64416[(7)]);
var inst_64396__$1 = (state_64416[(2)]);
var inst_64397 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_64398 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_64397,inst_64396__$1,null);
var state_64416__$1 = (function (){var statearr_64432 = state_64416;
(statearr_64432[(7)] = inst_64396__$1);

return statearr_64432;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64416__$1,(10),inst_64398);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_64433 = [null,null,null,null,null,null,null,null,null];
(statearr_64433[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_64433[(1)] = (1));

return statearr_64433;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_64416){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64434){var ex__2749__auto__ = e64434;
var statearr_64435_64447 = state_64416;
(statearr_64435_64447[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64416[(4)]))){
var statearr_64436_64448 = state_64416;
(statearr_64436_64448[(1)] = cljs.core.first.call(null,(state_64416[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64449 = state_64416;
state_64416 = G__64449;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_64416){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_64416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64437 = f__2769__auto__.call(null);
(statearr_64437[(6)] = c__2768__auto__);

return statearr_64437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64476){
var state_val_64477 = (state_64476[(1)]);
if((state_val_64477 === (7))){
var state_64476__$1 = state_64476;
var statearr_64478_64497 = state_64476__$1;
(statearr_64478_64497[(2)] = n);

(statearr_64478_64497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (1))){
var state_64476__$1 = state_64476;
var statearr_64479_64498 = state_64476__$1;
(statearr_64479_64498[(2)] = null);

(statearr_64479_64498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (4))){
var inst_64450 = (state_64476[(2)]);
var state_64476__$1 = state_64476;
var statearr_64480_64499 = state_64476__$1;
(statearr_64480_64499[(2)] = inst_64450);

(statearr_64480_64499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (6))){
var state_64476__$1 = state_64476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64476__$1,(9),n);
} else {
if((state_val_64477 === (3))){
var inst_64474 = (state_64476[(2)]);
var state_64476__$1 = state_64476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64476__$1,inst_64474);
} else {
if((state_val_64477 === (2))){
var _ = (function (){var statearr_64482 = state_64476;
(statearr_64482[(4)] = cljs.core.cons.call(null,(5),(state_64476[(4)])));

return statearr_64482;
})();
var inst_64456 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_64476__$1 = state_64476;
if(inst_64456){
var statearr_64483_64500 = state_64476__$1;
(statearr_64483_64500[(1)] = (6));

} else {
var statearr_64484_64501 = state_64476__$1;
(statearr_64484_64501[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (9))){
var inst_64459 = (state_64476[(2)]);
var inst_64460 = fluree.db.util.async.throw_err.call(null,inst_64459);
var state_64476__$1 = state_64476;
var statearr_64485_64502 = state_64476__$1;
(statearr_64485_64502[(2)] = inst_64460);

(statearr_64485_64502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (5))){
var _ = (function (){var statearr_64486 = state_64476;
(statearr_64486[(4)] = cljs.core.rest.call(null,(state_64476[(4)])));

return statearr_64486;
})();
var state_64476__$1 = state_64476;
var ex64481 = (state_64476__$1[(2)]);
var statearr_64487_64503 = state_64476__$1;
(statearr_64487_64503[(5)] = ex64481);


if((ex64481 instanceof Error)){
var statearr_64488_64504 = state_64476__$1;
(statearr_64488_64504[(1)] = (4));

(statearr_64488_64504[(5)] = null);

} else {
throw ex64481;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (8))){
var inst_64463 = (state_64476[(2)]);
var inst_64464 = fluree.db.dbfunctions.internal.inc.call(null,inst_64463);
var inst_64465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64466 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64467 = ["inc",inst_64463,inst_64464];
var inst_64468 = cljs.core.PersistentHashMap.fromArrays(inst_64466,inst_64467);
var inst_64469 = [inst_64468,(10)];
var inst_64470 = (new cljs.core.PersistentVector(null,2,(5),inst_64465,inst_64469,null));
var inst_64471 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64470);
var _ = (function (){var statearr_64489 = state_64476;
(statearr_64489[(4)] = cljs.core.rest.call(null,(state_64476[(4)])));

return statearr_64489;
})();
var state_64476__$1 = (function (){var statearr_64490 = state_64476;
(statearr_64490[(7)] = inst_64471);

return statearr_64490;
})();
var statearr_64491_64505 = state_64476__$1;
(statearr_64491_64505[(2)] = inst_64464);

(statearr_64491_64505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_64492 = [null,null,null,null,null,null,null,null];
(statearr_64492[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_64492[(1)] = (1));

return statearr_64492;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_64476){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64493){var ex__2749__auto__ = e64493;
var statearr_64494_64506 = state_64476;
(statearr_64494_64506[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64476[(4)]))){
var statearr_64495_64507 = state_64476;
(statearr_64495_64507[(1)] = cljs.core.first.call(null,(state_64476[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64508 = state_64476;
state_64476 = G__64508;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_64476){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_64476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64496 = f__2769__auto__.call(null);
(statearr_64496[(6)] = c__2768__auto__);

return statearr_64496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64535){
var state_val_64536 = (state_64535[(1)]);
if((state_val_64536 === (7))){
var state_64535__$1 = state_64535;
var statearr_64537_64556 = state_64535__$1;
(statearr_64537_64556[(2)] = n);

(statearr_64537_64556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64536 === (1))){
var state_64535__$1 = state_64535;
var statearr_64538_64557 = state_64535__$1;
(statearr_64538_64557[(2)] = null);

(statearr_64538_64557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64536 === (4))){
var inst_64509 = (state_64535[(2)]);
var state_64535__$1 = state_64535;
var statearr_64539_64558 = state_64535__$1;
(statearr_64539_64558[(2)] = inst_64509);

(statearr_64539_64558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64536 === (6))){
var state_64535__$1 = state_64535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64535__$1,(9),n);
} else {
if((state_val_64536 === (3))){
var inst_64533 = (state_64535[(2)]);
var state_64535__$1 = state_64535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64535__$1,inst_64533);
} else {
if((state_val_64536 === (2))){
var _ = (function (){var statearr_64541 = state_64535;
(statearr_64541[(4)] = cljs.core.cons.call(null,(5),(state_64535[(4)])));

return statearr_64541;
})();
var inst_64515 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_64535__$1 = state_64535;
if(inst_64515){
var statearr_64542_64559 = state_64535__$1;
(statearr_64542_64559[(1)] = (6));

} else {
var statearr_64543_64560 = state_64535__$1;
(statearr_64543_64560[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64536 === (9))){
var inst_64518 = (state_64535[(2)]);
var inst_64519 = fluree.db.util.async.throw_err.call(null,inst_64518);
var state_64535__$1 = state_64535;
var statearr_64544_64561 = state_64535__$1;
(statearr_64544_64561[(2)] = inst_64519);

(statearr_64544_64561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64536 === (5))){
var _ = (function (){var statearr_64545 = state_64535;
(statearr_64545[(4)] = cljs.core.rest.call(null,(state_64535[(4)])));

return statearr_64545;
})();
var state_64535__$1 = state_64535;
var ex64540 = (state_64535__$1[(2)]);
var statearr_64546_64562 = state_64535__$1;
(statearr_64546_64562[(5)] = ex64540);


if((ex64540 instanceof Error)){
var statearr_64547_64563 = state_64535__$1;
(statearr_64547_64563[(1)] = (4));

(statearr_64547_64563[(5)] = null);

} else {
throw ex64540;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64536 === (8))){
var inst_64522 = (state_64535[(2)]);
var inst_64523 = fluree.db.dbfunctions.internal.dec.call(null,inst_64522);
var inst_64524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64525 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64526 = ["dec",inst_64522,inst_64523];
var inst_64527 = cljs.core.PersistentHashMap.fromArrays(inst_64525,inst_64526);
var inst_64528 = [inst_64527,(10)];
var inst_64529 = (new cljs.core.PersistentVector(null,2,(5),inst_64524,inst_64528,null));
var inst_64530 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64529);
var _ = (function (){var statearr_64548 = state_64535;
(statearr_64548[(4)] = cljs.core.rest.call(null,(state_64535[(4)])));

return statearr_64548;
})();
var state_64535__$1 = (function (){var statearr_64549 = state_64535;
(statearr_64549[(7)] = inst_64530);

return statearr_64549;
})();
var statearr_64550_64564 = state_64535__$1;
(statearr_64550_64564[(2)] = inst_64523);

(statearr_64550_64564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_64551 = [null,null,null,null,null,null,null,null];
(statearr_64551[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_64551[(1)] = (1));

return statearr_64551;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_64535){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64552){var ex__2749__auto__ = e64552;
var statearr_64553_64565 = state_64535;
(statearr_64553_64565[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64535[(4)]))){
var statearr_64554_64566 = state_64535;
(statearr_64554_64566[(1)] = cljs.core.first.call(null,(state_64535[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64567 = state_64535;
state_64535 = G__64567;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_64535){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_64535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64555 = f__2769__auto__.call(null);
(statearr_64555[(6)] = c__2768__auto__);

return statearr_64555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64617 = arguments.length;
var i__5770__auto___64618 = (0);
while(true){
if((i__5770__auto___64618 < len__5769__auto___64617)){
args__5775__auto__.push((arguments[i__5770__auto___64618]));

var G__64619 = (i__5770__auto___64618 + (1));
i__5770__auto___64618 = G__64619;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64600){
var state_val_64601 = (state_64600[(1)]);
if((state_val_64601 === (1))){
var state_64600__$1 = state_64600;
var statearr_64602_64620 = state_64600__$1;
(statearr_64602_64620[(2)] = null);

(statearr_64602_64620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64601 === (2))){
var _ = (function (){var statearr_64603 = state_64600;
(statearr_64603[(4)] = cljs.core.cons.call(null,(5),(state_64600[(4)])));

return statearr_64603;
})();
var inst_64576 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64600__$1 = state_64600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64600__$1,(6),inst_64576);
} else {
if((state_val_64601 === (3))){
var inst_64598 = (state_64600[(2)]);
var state_64600__$1 = state_64600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64600__$1,inst_64598);
} else {
if((state_val_64601 === (4))){
var inst_64570 = (state_64600[(2)]);
var state_64600__$1 = state_64600;
var statearr_64605_64621 = state_64600__$1;
(statearr_64605_64621[(2)] = inst_64570);

(statearr_64605_64621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64601 === (5))){
var _ = (function (){var statearr_64606 = state_64600;
(statearr_64606[(4)] = cljs.core.rest.call(null,(state_64600[(4)])));

return statearr_64606;
})();
var state_64600__$1 = state_64600;
var ex64604 = (state_64600__$1[(2)]);
var statearr_64607_64622 = state_64600__$1;
(statearr_64607_64622[(5)] = ex64604);


if((ex64604 instanceof Error)){
var statearr_64608_64623 = state_64600__$1;
(statearr_64608_64623[(1)] = (4));

(statearr_64608_64623[(5)] = null);

} else {
throw ex64604;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64601 === (6))){
var inst_64578 = (state_64600[(2)]);
var inst_64579 = fluree.db.util.async.throw_err.call(null,inst_64578);
var inst_64580 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_64579);
var inst_64581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64582 = [inst_64579];
var inst_64583 = (new cljs.core.PersistentVector(null,1,(5),inst_64581,inst_64582,null));
var inst_64584 = cljs.core.count.call(null,inst_64583);
var inst_64585 = ((9) + inst_64584);
var inst_64586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64587 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64589 = [inst_64579];
var inst_64590 = (new cljs.core.PersistentVector(null,1,(5),inst_64588,inst_64589,null));
var inst_64591 = ["+",inst_64590,inst_64580];
var inst_64592 = cljs.core.PersistentHashMap.fromArrays(inst_64587,inst_64591);
var inst_64593 = [inst_64592,inst_64585];
var inst_64594 = (new cljs.core.PersistentVector(null,2,(5),inst_64586,inst_64593,null));
var inst_64595 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64594);
var _ = (function (){var statearr_64609 = state_64600;
(statearr_64609[(4)] = cljs.core.rest.call(null,(state_64600[(4)])));

return statearr_64609;
})();
var state_64600__$1 = (function (){var statearr_64610 = state_64600;
(statearr_64610[(7)] = inst_64595);

return statearr_64610;
})();
var statearr_64611_64624 = state_64600__$1;
(statearr_64611_64624[(2)] = inst_64580);

(statearr_64611_64624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64612 = [null,null,null,null,null,null,null,null];
(statearr_64612[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64612[(1)] = (1));

return statearr_64612;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64600){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64613){var ex__2749__auto__ = e64613;
var statearr_64614_64625 = state_64600;
(statearr_64614_64625[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64600[(4)]))){
var statearr_64615_64626 = state_64600;
(statearr_64615_64626[(1)] = cljs.core.first.call(null,(state_64600[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64627 = state_64600;
state_64600 = G__64627;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64600){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64616 = f__2769__auto__.call(null);
(statearr_64616[(6)] = c__2768__auto__);

return statearr_64616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq64568){
var G__64569 = cljs.core.first.call(null,seq64568);
var seq64568__$1 = cljs.core.next.call(null,seq64568);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64569,seq64568__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64677 = arguments.length;
var i__5770__auto___64678 = (0);
while(true){
if((i__5770__auto___64678 < len__5769__auto___64677)){
args__5775__auto__.push((arguments[i__5770__auto___64678]));

var G__64679 = (i__5770__auto___64678 + (1));
i__5770__auto___64678 = G__64679;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64660){
var state_val_64661 = (state_64660[(1)]);
if((state_val_64661 === (1))){
var state_64660__$1 = state_64660;
var statearr_64662_64680 = state_64660__$1;
(statearr_64662_64680[(2)] = null);

(statearr_64662_64680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (2))){
var _ = (function (){var statearr_64663 = state_64660;
(statearr_64663[(4)] = cljs.core.cons.call(null,(5),(state_64660[(4)])));

return statearr_64663;
})();
var inst_64636 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64660__$1 = state_64660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64660__$1,(6),inst_64636);
} else {
if((state_val_64661 === (3))){
var inst_64658 = (state_64660[(2)]);
var state_64660__$1 = state_64660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64660__$1,inst_64658);
} else {
if((state_val_64661 === (4))){
var inst_64630 = (state_64660[(2)]);
var state_64660__$1 = state_64660;
var statearr_64665_64681 = state_64660__$1;
(statearr_64665_64681[(2)] = inst_64630);

(statearr_64665_64681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (5))){
var _ = (function (){var statearr_64666 = state_64660;
(statearr_64666[(4)] = cljs.core.rest.call(null,(state_64660[(4)])));

return statearr_64666;
})();
var state_64660__$1 = state_64660;
var ex64664 = (state_64660__$1[(2)]);
var statearr_64667_64682 = state_64660__$1;
(statearr_64667_64682[(5)] = ex64664);


if((ex64664 instanceof Error)){
var statearr_64668_64683 = state_64660__$1;
(statearr_64668_64683[(1)] = (4));

(statearr_64668_64683[(5)] = null);

} else {
throw ex64664;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (6))){
var inst_64638 = (state_64660[(2)]);
var inst_64639 = fluree.db.util.async.throw_err.call(null,inst_64638);
var inst_64640 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_64639);
var inst_64641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64642 = [inst_64639];
var inst_64643 = (new cljs.core.PersistentVector(null,1,(5),inst_64641,inst_64642,null));
var inst_64644 = cljs.core.count.call(null,inst_64643);
var inst_64645 = ((9) + inst_64644);
var inst_64646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64647 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64649 = [inst_64639];
var inst_64650 = (new cljs.core.PersistentVector(null,1,(5),inst_64648,inst_64649,null));
var inst_64651 = ["-",inst_64650,inst_64640];
var inst_64652 = cljs.core.PersistentHashMap.fromArrays(inst_64647,inst_64651);
var inst_64653 = [inst_64652,inst_64645];
var inst_64654 = (new cljs.core.PersistentVector(null,2,(5),inst_64646,inst_64653,null));
var inst_64655 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64654);
var _ = (function (){var statearr_64669 = state_64660;
(statearr_64669[(4)] = cljs.core.rest.call(null,(state_64660[(4)])));

return statearr_64669;
})();
var state_64660__$1 = (function (){var statearr_64670 = state_64660;
(statearr_64670[(7)] = inst_64655);

return statearr_64670;
})();
var statearr_64671_64684 = state_64660__$1;
(statearr_64671_64684[(2)] = inst_64640);

(statearr_64671_64684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64672 = [null,null,null,null,null,null,null,null];
(statearr_64672[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64672[(1)] = (1));

return statearr_64672;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64660){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64673){var ex__2749__auto__ = e64673;
var statearr_64674_64685 = state_64660;
(statearr_64674_64685[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64660[(4)]))){
var statearr_64675_64686 = state_64660;
(statearr_64675_64686[(1)] = cljs.core.first.call(null,(state_64660[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64687 = state_64660;
state_64660 = G__64687;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64660){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64676 = f__2769__auto__.call(null);
(statearr_64676[(6)] = c__2768__auto__);

return statearr_64676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq64628){
var G__64629 = cljs.core.first.call(null,seq64628);
var seq64628__$1 = cljs.core.next.call(null,seq64628);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64629,seq64628__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64737 = arguments.length;
var i__5770__auto___64738 = (0);
while(true){
if((i__5770__auto___64738 < len__5769__auto___64737)){
args__5775__auto__.push((arguments[i__5770__auto___64738]));

var G__64739 = (i__5770__auto___64738 + (1));
i__5770__auto___64738 = G__64739;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64720){
var state_val_64721 = (state_64720[(1)]);
if((state_val_64721 === (1))){
var state_64720__$1 = state_64720;
var statearr_64722_64740 = state_64720__$1;
(statearr_64722_64740[(2)] = null);

(statearr_64722_64740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64721 === (2))){
var _ = (function (){var statearr_64723 = state_64720;
(statearr_64723[(4)] = cljs.core.cons.call(null,(5),(state_64720[(4)])));

return statearr_64723;
})();
var inst_64696 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64720__$1 = state_64720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64720__$1,(6),inst_64696);
} else {
if((state_val_64721 === (3))){
var inst_64718 = (state_64720[(2)]);
var state_64720__$1 = state_64720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64720__$1,inst_64718);
} else {
if((state_val_64721 === (4))){
var inst_64690 = (state_64720[(2)]);
var state_64720__$1 = state_64720;
var statearr_64725_64741 = state_64720__$1;
(statearr_64725_64741[(2)] = inst_64690);

(statearr_64725_64741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64721 === (5))){
var _ = (function (){var statearr_64726 = state_64720;
(statearr_64726[(4)] = cljs.core.rest.call(null,(state_64720[(4)])));

return statearr_64726;
})();
var state_64720__$1 = state_64720;
var ex64724 = (state_64720__$1[(2)]);
var statearr_64727_64742 = state_64720__$1;
(statearr_64727_64742[(5)] = ex64724);


if((ex64724 instanceof Error)){
var statearr_64728_64743 = state_64720__$1;
(statearr_64728_64743[(1)] = (4));

(statearr_64728_64743[(5)] = null);

} else {
throw ex64724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64721 === (6))){
var inst_64698 = (state_64720[(2)]);
var inst_64699 = fluree.db.util.async.throw_err.call(null,inst_64698);
var inst_64700 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_64699);
var inst_64701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64702 = [inst_64699];
var inst_64703 = (new cljs.core.PersistentVector(null,1,(5),inst_64701,inst_64702,null));
var inst_64704 = cljs.core.count.call(null,inst_64703);
var inst_64705 = ((9) + inst_64704);
var inst_64706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64707 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64709 = [inst_64699];
var inst_64710 = (new cljs.core.PersistentVector(null,1,(5),inst_64708,inst_64709,null));
var inst_64711 = ["*",inst_64710,inst_64700];
var inst_64712 = cljs.core.PersistentHashMap.fromArrays(inst_64707,inst_64711);
var inst_64713 = [inst_64712,inst_64705];
var inst_64714 = (new cljs.core.PersistentVector(null,2,(5),inst_64706,inst_64713,null));
var inst_64715 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64714);
var _ = (function (){var statearr_64729 = state_64720;
(statearr_64729[(4)] = cljs.core.rest.call(null,(state_64720[(4)])));

return statearr_64729;
})();
var state_64720__$1 = (function (){var statearr_64730 = state_64720;
(statearr_64730[(7)] = inst_64715);

return statearr_64730;
})();
var statearr_64731_64744 = state_64720__$1;
(statearr_64731_64744[(2)] = inst_64700);

(statearr_64731_64744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64732 = [null,null,null,null,null,null,null,null];
(statearr_64732[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64732[(1)] = (1));

return statearr_64732;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64720){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64733){var ex__2749__auto__ = e64733;
var statearr_64734_64745 = state_64720;
(statearr_64734_64745[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64720[(4)]))){
var statearr_64735_64746 = state_64720;
(statearr_64735_64746[(1)] = cljs.core.first.call(null,(state_64720[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64747 = state_64720;
state_64720 = G__64747;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64720){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64736 = f__2769__auto__.call(null);
(statearr_64736[(6)] = c__2768__auto__);

return statearr_64736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq64688){
var G__64689 = cljs.core.first.call(null,seq64688);
var seq64688__$1 = cljs.core.next.call(null,seq64688);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64689,seq64688__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64797 = arguments.length;
var i__5770__auto___64798 = (0);
while(true){
if((i__5770__auto___64798 < len__5769__auto___64797)){
args__5775__auto__.push((arguments[i__5770__auto___64798]));

var G__64799 = (i__5770__auto___64798 + (1));
i__5770__auto___64798 = G__64799;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64780){
var state_val_64781 = (state_64780[(1)]);
if((state_val_64781 === (1))){
var state_64780__$1 = state_64780;
var statearr_64782_64800 = state_64780__$1;
(statearr_64782_64800[(2)] = null);

(statearr_64782_64800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (2))){
var _ = (function (){var statearr_64783 = state_64780;
(statearr_64783[(4)] = cljs.core.cons.call(null,(5),(state_64780[(4)])));

return statearr_64783;
})();
var inst_64756 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64780__$1 = state_64780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64780__$1,(6),inst_64756);
} else {
if((state_val_64781 === (3))){
var inst_64778 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64780__$1,inst_64778);
} else {
if((state_val_64781 === (4))){
var inst_64750 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
var statearr_64785_64801 = state_64780__$1;
(statearr_64785_64801[(2)] = inst_64750);

(statearr_64785_64801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (5))){
var _ = (function (){var statearr_64786 = state_64780;
(statearr_64786[(4)] = cljs.core.rest.call(null,(state_64780[(4)])));

return statearr_64786;
})();
var state_64780__$1 = state_64780;
var ex64784 = (state_64780__$1[(2)]);
var statearr_64787_64802 = state_64780__$1;
(statearr_64787_64802[(5)] = ex64784);


if((ex64784 instanceof Error)){
var statearr_64788_64803 = state_64780__$1;
(statearr_64788_64803[(1)] = (4));

(statearr_64788_64803[(5)] = null);

} else {
throw ex64784;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (6))){
var inst_64758 = (state_64780[(2)]);
var inst_64759 = fluree.db.util.async.throw_err.call(null,inst_64758);
var inst_64760 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_64759);
var inst_64761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64762 = [inst_64759];
var inst_64763 = (new cljs.core.PersistentVector(null,1,(5),inst_64761,inst_64762,null));
var inst_64764 = cljs.core.count.call(null,inst_64763);
var inst_64765 = ((9) + inst_64764);
var inst_64766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64767 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64769 = [inst_64759];
var inst_64770 = (new cljs.core.PersistentVector(null,1,(5),inst_64768,inst_64769,null));
var inst_64771 = ["/",inst_64770,inst_64760];
var inst_64772 = cljs.core.PersistentHashMap.fromArrays(inst_64767,inst_64771);
var inst_64773 = [inst_64772,inst_64765];
var inst_64774 = (new cljs.core.PersistentVector(null,2,(5),inst_64766,inst_64773,null));
var inst_64775 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64774);
var _ = (function (){var statearr_64789 = state_64780;
(statearr_64789[(4)] = cljs.core.rest.call(null,(state_64780[(4)])));

return statearr_64789;
})();
var state_64780__$1 = (function (){var statearr_64790 = state_64780;
(statearr_64790[(7)] = inst_64775);

return statearr_64790;
})();
var statearr_64791_64804 = state_64780__$1;
(statearr_64791_64804[(2)] = inst_64760);

(statearr_64791_64804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_64792 = [null,null,null,null,null,null,null,null];
(statearr_64792[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_64792[(1)] = (1));

return statearr_64792;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_64780){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64793){var ex__2749__auto__ = e64793;
var statearr_64794_64805 = state_64780;
(statearr_64794_64805[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64780[(4)]))){
var statearr_64795_64806 = state_64780;
(statearr_64795_64806[(1)] = cljs.core.first.call(null,(state_64780[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64807 = state_64780;
state_64780 = G__64807;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_64780){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_64780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64796 = f__2769__auto__.call(null);
(statearr_64796[(6)] = c__2768__auto__);

return statearr_64796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq64748){
var G__64749 = cljs.core.first.call(null,seq64748);
var seq64748__$1 = cljs.core.next.call(null,seq64748);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64749,seq64748__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64845){
var state_val_64846 = (state_64845[(1)]);
if((state_val_64846 === (7))){
var state_64845__$1 = state_64845;
var statearr_64847_64871 = state_64845__$1;
(statearr_64847_64871[(2)] = n);

(statearr_64847_64871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (1))){
var state_64845__$1 = state_64845;
var statearr_64848_64872 = state_64845__$1;
(statearr_64848_64872[(2)] = null);

(statearr_64848_64872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (4))){
var inst_64808 = (state_64845[(2)]);
var state_64845__$1 = state_64845;
var statearr_64849_64873 = state_64845__$1;
(statearr_64849_64873[(2)] = inst_64808);

(statearr_64849_64873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (13))){
var inst_64825 = (state_64845[(2)]);
var inst_64826 = fluree.db.util.async.throw_err.call(null,inst_64825);
var state_64845__$1 = state_64845;
var statearr_64850_64874 = state_64845__$1;
(statearr_64850_64874[(2)] = inst_64826);

(statearr_64850_64874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (6))){
var state_64845__$1 = state_64845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64845__$1,(9),n);
} else {
if((state_val_64846 === (3))){
var inst_64843 = (state_64845[(2)]);
var state_64845__$1 = state_64845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64845__$1,inst_64843);
} else {
if((state_val_64846 === (12))){
var inst_64821 = (state_64845[(7)]);
var inst_64829 = (state_64845[(2)]);
var inst_64830 = fluree.db.dbfunctions.internal.quot.call(null,inst_64821,inst_64829);
var inst_64831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64832 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64834 = [inst_64821,inst_64829];
var inst_64835 = (new cljs.core.PersistentVector(null,2,(5),inst_64833,inst_64834,null));
var inst_64836 = ["quot",inst_64835,inst_64830];
var inst_64837 = cljs.core.PersistentHashMap.fromArrays(inst_64832,inst_64836);
var inst_64838 = [inst_64837,(2)];
var inst_64839 = (new cljs.core.PersistentVector(null,2,(5),inst_64831,inst_64838,null));
var inst_64840 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64839);
var _ = (function (){var statearr_64851 = state_64845;
(statearr_64851[(4)] = cljs.core.rest.call(null,(state_64845[(4)])));

return statearr_64851;
})();
var state_64845__$1 = (function (){var statearr_64852 = state_64845;
(statearr_64852[(8)] = inst_64840);

return statearr_64852;
})();
var statearr_64853_64875 = state_64845__$1;
(statearr_64853_64875[(2)] = inst_64830);

(statearr_64853_64875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (2))){
var _ = (function (){var statearr_64854 = state_64845;
(statearr_64854[(4)] = cljs.core.cons.call(null,(5),(state_64845[(4)])));

return statearr_64854;
})();
var inst_64814 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_64845__$1 = state_64845;
if(inst_64814){
var statearr_64855_64876 = state_64845__$1;
(statearr_64855_64876[(1)] = (6));

} else {
var statearr_64856_64877 = state_64845__$1;
(statearr_64856_64877[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (11))){
var state_64845__$1 = state_64845;
var statearr_64858_64878 = state_64845__$1;
(statearr_64858_64878[(2)] = d);

(statearr_64858_64878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (9))){
var inst_64817 = (state_64845[(2)]);
var inst_64818 = fluree.db.util.async.throw_err.call(null,inst_64817);
var state_64845__$1 = state_64845;
var statearr_64859_64879 = state_64845__$1;
(statearr_64859_64879[(2)] = inst_64818);

(statearr_64859_64879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (5))){
var _ = (function (){var statearr_64860 = state_64845;
(statearr_64860[(4)] = cljs.core.rest.call(null,(state_64845[(4)])));

return statearr_64860;
})();
var state_64845__$1 = state_64845;
var ex64857 = (state_64845__$1[(2)]);
var statearr_64861_64880 = state_64845__$1;
(statearr_64861_64880[(5)] = ex64857);


if((ex64857 instanceof Error)){
var statearr_64862_64881 = state_64845__$1;
(statearr_64862_64881[(1)] = (4));

(statearr_64862_64881[(5)] = null);

} else {
throw ex64857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64846 === (10))){
var state_64845__$1 = state_64845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64845__$1,(13),d);
} else {
if((state_val_64846 === (8))){
var inst_64821 = (state_64845[(2)]);
var inst_64822 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_64845__$1 = (function (){var statearr_64863 = state_64845;
(statearr_64863[(7)] = inst_64821);

return statearr_64863;
})();
if(inst_64822){
var statearr_64864_64882 = state_64845__$1;
(statearr_64864_64882[(1)] = (10));

} else {
var statearr_64865_64883 = state_64845__$1;
(statearr_64865_64883[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_64866 = [null,null,null,null,null,null,null,null,null];
(statearr_64866[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_64866[(1)] = (1));

return statearr_64866;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_64845){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64867){var ex__2749__auto__ = e64867;
var statearr_64868_64884 = state_64845;
(statearr_64868_64884[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64845[(4)]))){
var statearr_64869_64885 = state_64845;
(statearr_64869_64885[(1)] = cljs.core.first.call(null,(state_64845[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64886 = state_64845;
state_64845 = G__64886;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_64845){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_64845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64870 = f__2769__auto__.call(null);
(statearr_64870[(6)] = c__2768__auto__);

return statearr_64870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64924){
var state_val_64925 = (state_64924[(1)]);
if((state_val_64925 === (7))){
var state_64924__$1 = state_64924;
var statearr_64926_64950 = state_64924__$1;
(statearr_64926_64950[(2)] = n);

(statearr_64926_64950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (1))){
var state_64924__$1 = state_64924;
var statearr_64927_64951 = state_64924__$1;
(statearr_64927_64951[(2)] = null);

(statearr_64927_64951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (4))){
var inst_64887 = (state_64924[(2)]);
var state_64924__$1 = state_64924;
var statearr_64928_64952 = state_64924__$1;
(statearr_64928_64952[(2)] = inst_64887);

(statearr_64928_64952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (13))){
var inst_64904 = (state_64924[(2)]);
var inst_64905 = fluree.db.util.async.throw_err.call(null,inst_64904);
var state_64924__$1 = state_64924;
var statearr_64929_64953 = state_64924__$1;
(statearr_64929_64953[(2)] = inst_64905);

(statearr_64929_64953[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (6))){
var state_64924__$1 = state_64924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64924__$1,(9),n);
} else {
if((state_val_64925 === (3))){
var inst_64922 = (state_64924[(2)]);
var state_64924__$1 = state_64924;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64924__$1,inst_64922);
} else {
if((state_val_64925 === (12))){
var inst_64900 = (state_64924[(7)]);
var inst_64908 = (state_64924[(2)]);
var inst_64909 = fluree.db.dbfunctions.internal.mod.call(null,inst_64900,inst_64908);
var inst_64910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64911 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64913 = [inst_64900,inst_64908];
var inst_64914 = (new cljs.core.PersistentVector(null,2,(5),inst_64912,inst_64913,null));
var inst_64915 = ["mod",inst_64914,inst_64909];
var inst_64916 = cljs.core.PersistentHashMap.fromArrays(inst_64911,inst_64915);
var inst_64917 = [inst_64916,(2)];
var inst_64918 = (new cljs.core.PersistentVector(null,2,(5),inst_64910,inst_64917,null));
var inst_64919 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64918);
var _ = (function (){var statearr_64930 = state_64924;
(statearr_64930[(4)] = cljs.core.rest.call(null,(state_64924[(4)])));

return statearr_64930;
})();
var state_64924__$1 = (function (){var statearr_64931 = state_64924;
(statearr_64931[(8)] = inst_64919);

return statearr_64931;
})();
var statearr_64932_64954 = state_64924__$1;
(statearr_64932_64954[(2)] = inst_64909);

(statearr_64932_64954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (2))){
var _ = (function (){var statearr_64933 = state_64924;
(statearr_64933[(4)] = cljs.core.cons.call(null,(5),(state_64924[(4)])));

return statearr_64933;
})();
var inst_64893 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_64924__$1 = state_64924;
if(inst_64893){
var statearr_64934_64955 = state_64924__$1;
(statearr_64934_64955[(1)] = (6));

} else {
var statearr_64935_64956 = state_64924__$1;
(statearr_64935_64956[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (11))){
var state_64924__$1 = state_64924;
var statearr_64937_64957 = state_64924__$1;
(statearr_64937_64957[(2)] = d);

(statearr_64937_64957[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (9))){
var inst_64896 = (state_64924[(2)]);
var inst_64897 = fluree.db.util.async.throw_err.call(null,inst_64896);
var state_64924__$1 = state_64924;
var statearr_64938_64958 = state_64924__$1;
(statearr_64938_64958[(2)] = inst_64897);

(statearr_64938_64958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (5))){
var _ = (function (){var statearr_64939 = state_64924;
(statearr_64939[(4)] = cljs.core.rest.call(null,(state_64924[(4)])));

return statearr_64939;
})();
var state_64924__$1 = state_64924;
var ex64936 = (state_64924__$1[(2)]);
var statearr_64940_64959 = state_64924__$1;
(statearr_64940_64959[(5)] = ex64936);


if((ex64936 instanceof Error)){
var statearr_64941_64960 = state_64924__$1;
(statearr_64941_64960[(1)] = (4));

(statearr_64941_64960[(5)] = null);

} else {
throw ex64936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64925 === (10))){
var state_64924__$1 = state_64924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64924__$1,(13),d);
} else {
if((state_val_64925 === (8))){
var inst_64900 = (state_64924[(2)]);
var inst_64901 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_64924__$1 = (function (){var statearr_64942 = state_64924;
(statearr_64942[(7)] = inst_64900);

return statearr_64942;
})();
if(inst_64901){
var statearr_64943_64961 = state_64924__$1;
(statearr_64943_64961[(1)] = (10));

} else {
var statearr_64944_64962 = state_64924__$1;
(statearr_64944_64962[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_64945 = [null,null,null,null,null,null,null,null,null];
(statearr_64945[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_64945[(1)] = (1));

return statearr_64945;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_64924){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64924);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64946){var ex__2749__auto__ = e64946;
var statearr_64947_64963 = state_64924;
(statearr_64947_64963[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64924[(4)]))){
var statearr_64948_64964 = state_64924;
(statearr_64948_64964[(1)] = cljs.core.first.call(null,(state_64924[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64965 = state_64924;
state_64924 = G__64965;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_64924){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_64924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64949 = f__2769__auto__.call(null);
(statearr_64949[(6)] = c__2768__auto__);

return statearr_64949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65003){
var state_val_65004 = (state_65003[(1)]);
if((state_val_65004 === (7))){
var state_65003__$1 = state_65003;
var statearr_65005_65029 = state_65003__$1;
(statearr_65005_65029[(2)] = n);

(statearr_65005_65029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (1))){
var state_65003__$1 = state_65003;
var statearr_65006_65030 = state_65003__$1;
(statearr_65006_65030[(2)] = null);

(statearr_65006_65030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (4))){
var inst_64966 = (state_65003[(2)]);
var state_65003__$1 = state_65003;
var statearr_65007_65031 = state_65003__$1;
(statearr_65007_65031[(2)] = inst_64966);

(statearr_65007_65031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (13))){
var inst_64983 = (state_65003[(2)]);
var inst_64984 = fluree.db.util.async.throw_err.call(null,inst_64983);
var state_65003__$1 = state_65003;
var statearr_65008_65032 = state_65003__$1;
(statearr_65008_65032[(2)] = inst_64984);

(statearr_65008_65032[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (6))){
var state_65003__$1 = state_65003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65003__$1,(9),n);
} else {
if((state_val_65004 === (3))){
var inst_65001 = (state_65003[(2)]);
var state_65003__$1 = state_65003;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65003__$1,inst_65001);
} else {
if((state_val_65004 === (12))){
var inst_64979 = (state_65003[(7)]);
var inst_64987 = (state_65003[(2)]);
var inst_64988 = fluree.db.dbfunctions.internal.rem.call(null,inst_64979,inst_64987);
var inst_64989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64990 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64992 = [inst_64979,inst_64987];
var inst_64993 = (new cljs.core.PersistentVector(null,2,(5),inst_64991,inst_64992,null));
var inst_64994 = ["rem",inst_64993,inst_64988];
var inst_64995 = cljs.core.PersistentHashMap.fromArrays(inst_64990,inst_64994);
var inst_64996 = [inst_64995,(2)];
var inst_64997 = (new cljs.core.PersistentVector(null,2,(5),inst_64989,inst_64996,null));
var inst_64998 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64997);
var _ = (function (){var statearr_65009 = state_65003;
(statearr_65009[(4)] = cljs.core.rest.call(null,(state_65003[(4)])));

return statearr_65009;
})();
var state_65003__$1 = (function (){var statearr_65010 = state_65003;
(statearr_65010[(8)] = inst_64998);

return statearr_65010;
})();
var statearr_65011_65033 = state_65003__$1;
(statearr_65011_65033[(2)] = inst_64988);

(statearr_65011_65033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (2))){
var _ = (function (){var statearr_65012 = state_65003;
(statearr_65012[(4)] = cljs.core.cons.call(null,(5),(state_65003[(4)])));

return statearr_65012;
})();
var inst_64972 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_65003__$1 = state_65003;
if(inst_64972){
var statearr_65013_65034 = state_65003__$1;
(statearr_65013_65034[(1)] = (6));

} else {
var statearr_65014_65035 = state_65003__$1;
(statearr_65014_65035[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (11))){
var state_65003__$1 = state_65003;
var statearr_65016_65036 = state_65003__$1;
(statearr_65016_65036[(2)] = d);

(statearr_65016_65036[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (9))){
var inst_64975 = (state_65003[(2)]);
var inst_64976 = fluree.db.util.async.throw_err.call(null,inst_64975);
var state_65003__$1 = state_65003;
var statearr_65017_65037 = state_65003__$1;
(statearr_65017_65037[(2)] = inst_64976);

(statearr_65017_65037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (5))){
var _ = (function (){var statearr_65018 = state_65003;
(statearr_65018[(4)] = cljs.core.rest.call(null,(state_65003[(4)])));

return statearr_65018;
})();
var state_65003__$1 = state_65003;
var ex65015 = (state_65003__$1[(2)]);
var statearr_65019_65038 = state_65003__$1;
(statearr_65019_65038[(5)] = ex65015);


if((ex65015 instanceof Error)){
var statearr_65020_65039 = state_65003__$1;
(statearr_65020_65039[(1)] = (4));

(statearr_65020_65039[(5)] = null);

} else {
throw ex65015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65004 === (10))){
var state_65003__$1 = state_65003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65003__$1,(13),d);
} else {
if((state_val_65004 === (8))){
var inst_64979 = (state_65003[(2)]);
var inst_64980 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_65003__$1 = (function (){var statearr_65021 = state_65003;
(statearr_65021[(7)] = inst_64979);

return statearr_65021;
})();
if(inst_64980){
var statearr_65022_65040 = state_65003__$1;
(statearr_65022_65040[(1)] = (10));

} else {
var statearr_65023_65041 = state_65003__$1;
(statearr_65023_65041[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_65024 = [null,null,null,null,null,null,null,null,null];
(statearr_65024[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_65024[(1)] = (1));

return statearr_65024;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_65003){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65003);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65025){var ex__2749__auto__ = e65025;
var statearr_65026_65042 = state_65003;
(statearr_65026_65042[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65003[(4)]))){
var statearr_65027_65043 = state_65003;
(statearr_65027_65043[(1)] = cljs.core.first.call(null,(state_65003[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65044 = state_65003;
state_65003 = G__65044;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_65003){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_65003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65028 = f__2769__auto__.call(null);
(statearr_65028[(6)] = c__2768__auto__);

return statearr_65028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65071){
var state_val_65072 = (state_65071[(1)]);
if((state_val_65072 === (7))){
var state_65071__$1 = state_65071;
var statearr_65073_65092 = state_65071__$1;
(statearr_65073_65092[(2)] = x);

(statearr_65073_65092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65072 === (1))){
var state_65071__$1 = state_65071;
var statearr_65074_65093 = state_65071__$1;
(statearr_65074_65093[(2)] = null);

(statearr_65074_65093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65072 === (4))){
var inst_65045 = (state_65071[(2)]);
var state_65071__$1 = state_65071;
var statearr_65075_65094 = state_65071__$1;
(statearr_65075_65094[(2)] = inst_65045);

(statearr_65075_65094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65072 === (6))){
var state_65071__$1 = state_65071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65071__$1,(9),x);
} else {
if((state_val_65072 === (3))){
var inst_65069 = (state_65071[(2)]);
var state_65071__$1 = state_65071;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65071__$1,inst_65069);
} else {
if((state_val_65072 === (2))){
var _ = (function (){var statearr_65077 = state_65071;
(statearr_65077[(4)] = cljs.core.cons.call(null,(5),(state_65071[(4)])));

return statearr_65077;
})();
var inst_65051 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_65071__$1 = state_65071;
if(inst_65051){
var statearr_65078_65095 = state_65071__$1;
(statearr_65078_65095[(1)] = (6));

} else {
var statearr_65079_65096 = state_65071__$1;
(statearr_65079_65096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65072 === (9))){
var inst_65054 = (state_65071[(2)]);
var inst_65055 = fluree.db.util.async.throw_err.call(null,inst_65054);
var state_65071__$1 = state_65071;
var statearr_65080_65097 = state_65071__$1;
(statearr_65080_65097[(2)] = inst_65055);

(statearr_65080_65097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65072 === (5))){
var _ = (function (){var statearr_65081 = state_65071;
(statearr_65081[(4)] = cljs.core.rest.call(null,(state_65071[(4)])));

return statearr_65081;
})();
var state_65071__$1 = state_65071;
var ex65076 = (state_65071__$1[(2)]);
var statearr_65082_65098 = state_65071__$1;
(statearr_65082_65098[(5)] = ex65076);


if((ex65076 instanceof Error)){
var statearr_65083_65099 = state_65071__$1;
(statearr_65083_65099[(1)] = (4));

(statearr_65083_65099[(5)] = null);

} else {
throw ex65076;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65072 === (8))){
var inst_65058 = (state_65071[(2)]);
var inst_65059 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_65058);
var inst_65060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65061 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65062 = ["boolean",inst_65058,inst_65059];
var inst_65063 = cljs.core.PersistentHashMap.fromArrays(inst_65061,inst_65062);
var inst_65064 = [inst_65063,(10)];
var inst_65065 = (new cljs.core.PersistentVector(null,2,(5),inst_65060,inst_65064,null));
var inst_65066 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65065);
var _ = (function (){var statearr_65084 = state_65071;
(statearr_65084[(4)] = cljs.core.rest.call(null,(state_65071[(4)])));

return statearr_65084;
})();
var state_65071__$1 = (function (){var statearr_65085 = state_65071;
(statearr_65085[(7)] = inst_65066);

return statearr_65085;
})();
var statearr_65086_65100 = state_65071__$1;
(statearr_65086_65100[(2)] = inst_65059);

(statearr_65086_65100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_65087 = [null,null,null,null,null,null,null,null];
(statearr_65087[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_65087[(1)] = (1));

return statearr_65087;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_65071){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65088){var ex__2749__auto__ = e65088;
var statearr_65089_65101 = state_65071;
(statearr_65089_65101[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65071[(4)]))){
var statearr_65090_65102 = state_65071;
(statearr_65090_65102[(1)] = cljs.core.first.call(null,(state_65071[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65103 = state_65071;
state_65071 = G__65103;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_65071){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_65071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65091 = f__2769__auto__.call(null);
(statearr_65091[(6)] = c__2768__auto__);

return statearr_65091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65141){
var state_val_65142 = (state_65141[(1)]);
if((state_val_65142 === (7))){
var state_65141__$1 = state_65141;
var statearr_65143_65167 = state_65141__$1;
(statearr_65143_65167[(2)] = pattern);

(statearr_65143_65167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (1))){
var state_65141__$1 = state_65141;
var statearr_65144_65168 = state_65141__$1;
(statearr_65144_65168[(2)] = null);

(statearr_65144_65168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (4))){
var inst_65104 = (state_65141[(2)]);
var state_65141__$1 = state_65141;
var statearr_65145_65169 = state_65141__$1;
(statearr_65145_65169[(2)] = inst_65104);

(statearr_65145_65169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (13))){
var inst_65121 = (state_65141[(2)]);
var inst_65122 = fluree.db.util.async.throw_err.call(null,inst_65121);
var state_65141__$1 = state_65141;
var statearr_65146_65170 = state_65141__$1;
(statearr_65146_65170[(2)] = inst_65122);

(statearr_65146_65170[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (6))){
var state_65141__$1 = state_65141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65141__$1,(9),pattern);
} else {
if((state_val_65142 === (3))){
var inst_65139 = (state_65141[(2)]);
var state_65141__$1 = state_65141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65141__$1,inst_65139);
} else {
if((state_val_65142 === (12))){
var inst_65117 = (state_65141[(7)]);
var inst_65125 = (state_65141[(2)]);
var inst_65126 = fluree.db.dbfunctions.internal.re_find.call(null,inst_65117,inst_65125);
var inst_65127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65128 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65130 = [inst_65117,inst_65125];
var inst_65131 = (new cljs.core.PersistentVector(null,2,(5),inst_65129,inst_65130,null));
var inst_65132 = ["re-find",inst_65131,inst_65126];
var inst_65133 = cljs.core.PersistentHashMap.fromArrays(inst_65128,inst_65132);
var inst_65134 = [inst_65133,(10)];
var inst_65135 = (new cljs.core.PersistentVector(null,2,(5),inst_65127,inst_65134,null));
var inst_65136 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65135);
var _ = (function (){var statearr_65147 = state_65141;
(statearr_65147[(4)] = cljs.core.rest.call(null,(state_65141[(4)])));

return statearr_65147;
})();
var state_65141__$1 = (function (){var statearr_65148 = state_65141;
(statearr_65148[(8)] = inst_65136);

return statearr_65148;
})();
var statearr_65149_65171 = state_65141__$1;
(statearr_65149_65171[(2)] = inst_65126);

(statearr_65149_65171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (2))){
var _ = (function (){var statearr_65150 = state_65141;
(statearr_65150[(4)] = cljs.core.cons.call(null,(5),(state_65141[(4)])));

return statearr_65150;
})();
var inst_65110 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_65141__$1 = state_65141;
if(inst_65110){
var statearr_65151_65172 = state_65141__$1;
(statearr_65151_65172[(1)] = (6));

} else {
var statearr_65152_65173 = state_65141__$1;
(statearr_65152_65173[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (11))){
var state_65141__$1 = state_65141;
var statearr_65154_65174 = state_65141__$1;
(statearr_65154_65174[(2)] = string);

(statearr_65154_65174[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (9))){
var inst_65113 = (state_65141[(2)]);
var inst_65114 = fluree.db.util.async.throw_err.call(null,inst_65113);
var state_65141__$1 = state_65141;
var statearr_65155_65175 = state_65141__$1;
(statearr_65155_65175[(2)] = inst_65114);

(statearr_65155_65175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (5))){
var _ = (function (){var statearr_65156 = state_65141;
(statearr_65156[(4)] = cljs.core.rest.call(null,(state_65141[(4)])));

return statearr_65156;
})();
var state_65141__$1 = state_65141;
var ex65153 = (state_65141__$1[(2)]);
var statearr_65157_65176 = state_65141__$1;
(statearr_65157_65176[(5)] = ex65153);


if((ex65153 instanceof Error)){
var statearr_65158_65177 = state_65141__$1;
(statearr_65158_65177[(1)] = (4));

(statearr_65158_65177[(5)] = null);

} else {
throw ex65153;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65142 === (10))){
var state_65141__$1 = state_65141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65141__$1,(13),string);
} else {
if((state_val_65142 === (8))){
var inst_65117 = (state_65141[(2)]);
var inst_65118 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_65141__$1 = (function (){var statearr_65159 = state_65141;
(statearr_65159[(7)] = inst_65117);

return statearr_65159;
})();
if(inst_65118){
var statearr_65160_65178 = state_65141__$1;
(statearr_65160_65178[(1)] = (10));

} else {
var statearr_65161_65179 = state_65141__$1;
(statearr_65161_65179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_65162 = [null,null,null,null,null,null,null,null,null];
(statearr_65162[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_65162[(1)] = (1));

return statearr_65162;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_65141){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65163){var ex__2749__auto__ = e65163;
var statearr_65164_65180 = state_65141;
(statearr_65164_65180[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65141[(4)]))){
var statearr_65165_65181 = state_65141;
(statearr_65165_65181[(1)] = cljs.core.first.call(null,(state_65141[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65182 = state_65141;
state_65141 = G__65182;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_65141){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_65141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65166 = f__2769__auto__.call(null);
(statearr_65166[(6)] = c__2768__auto__);

return statearr_65166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65209){
var state_val_65210 = (state_65209[(1)]);
if((state_val_65210 === (7))){
var state_65209__$1 = state_65209;
var statearr_65211_65230 = state_65209__$1;
(statearr_65211_65230[(2)] = email);

(statearr_65211_65230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65210 === (1))){
var state_65209__$1 = state_65209;
var statearr_65212_65231 = state_65209__$1;
(statearr_65212_65231[(2)] = null);

(statearr_65212_65231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65210 === (4))){
var inst_65183 = (state_65209[(2)]);
var state_65209__$1 = state_65209;
var statearr_65213_65232 = state_65209__$1;
(statearr_65213_65232[(2)] = inst_65183);

(statearr_65213_65232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65210 === (6))){
var state_65209__$1 = state_65209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65209__$1,(9),email);
} else {
if((state_val_65210 === (3))){
var inst_65207 = (state_65209[(2)]);
var state_65209__$1 = state_65209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65209__$1,inst_65207);
} else {
if((state_val_65210 === (2))){
var _ = (function (){var statearr_65215 = state_65209;
(statearr_65215[(4)] = cljs.core.cons.call(null,(5),(state_65209[(4)])));

return statearr_65215;
})();
var inst_65189 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_65209__$1 = state_65209;
if(inst_65189){
var statearr_65216_65233 = state_65209__$1;
(statearr_65216_65233[(1)] = (6));

} else {
var statearr_65217_65234 = state_65209__$1;
(statearr_65217_65234[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65210 === (9))){
var inst_65192 = (state_65209[(2)]);
var inst_65193 = fluree.db.util.async.throw_err.call(null,inst_65192);
var state_65209__$1 = state_65209;
var statearr_65218_65235 = state_65209__$1;
(statearr_65218_65235[(2)] = inst_65193);

(statearr_65218_65235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65210 === (5))){
var _ = (function (){var statearr_65219 = state_65209;
(statearr_65219[(4)] = cljs.core.rest.call(null,(state_65209[(4)])));

return statearr_65219;
})();
var state_65209__$1 = state_65209;
var ex65214 = (state_65209__$1[(2)]);
var statearr_65220_65236 = state_65209__$1;
(statearr_65220_65236[(5)] = ex65214);


if((ex65214 instanceof Error)){
var statearr_65221_65237 = state_65209__$1;
(statearr_65221_65237[(1)] = (4));

(statearr_65221_65237[(5)] = null);

} else {
throw ex65214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65210 === (8))){
var inst_65196 = (state_65209[(2)]);
var inst_65197 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_65196);
var inst_65198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65199 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65200 = ["re-find",inst_65196,inst_65197];
var inst_65201 = cljs.core.PersistentHashMap.fromArrays(inst_65199,inst_65200);
var inst_65202 = [inst_65201,(10)];
var inst_65203 = (new cljs.core.PersistentVector(null,2,(5),inst_65198,inst_65202,null));
var inst_65204 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65203);
var _ = (function (){var statearr_65222 = state_65209;
(statearr_65222[(4)] = cljs.core.rest.call(null,(state_65209[(4)])));

return statearr_65222;
})();
var state_65209__$1 = (function (){var statearr_65223 = state_65209;
(statearr_65223[(7)] = inst_65204);

return statearr_65223;
})();
var statearr_65224_65238 = state_65209__$1;
(statearr_65224_65238[(2)] = inst_65197);

(statearr_65224_65238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_65225 = [null,null,null,null,null,null,null,null];
(statearr_65225[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_65225[(1)] = (1));

return statearr_65225;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_65209){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65226){var ex__2749__auto__ = e65226;
var statearr_65227_65239 = state_65209;
(statearr_65227_65239[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65209[(4)]))){
var statearr_65228_65240 = state_65209;
(statearr_65228_65240[(1)] = cljs.core.first.call(null,(state_65209[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65241 = state_65209;
state_65209 = G__65241;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_65209){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_65209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65229 = f__2769__auto__.call(null);
(statearr_65229[(6)] = c__2768__auto__);

return statearr_65229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65288){
var state_val_65289 = (state_65288[(1)]);
if((state_val_65289 === (7))){
var inst_65258 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65288__$1 = state_65288;
if(cljs.core.truth_(inst_65258)){
var statearr_65290_65317 = state_65288__$1;
(statearr_65290_65317[(1)] = (9));

} else {
var statearr_65291_65318 = state_65288__$1;
(statearr_65291_65318[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (1))){
var state_65288__$1 = state_65288;
var statearr_65292_65319 = state_65288__$1;
(statearr_65292_65319[(2)] = null);

(statearr_65292_65319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (4))){
var inst_65242 = (state_65288[(2)]);
var state_65288__$1 = state_65288;
var statearr_65293_65320 = state_65288__$1;
(statearr_65293_65320[(2)] = inst_65242);

(statearr_65293_65320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (15))){
var inst_65269 = (state_65288[(2)]);
var state_65288__$1 = state_65288;
var statearr_65294_65321 = state_65288__$1;
(statearr_65294_65321[(2)] = inst_65269);

(statearr_65294_65321[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (13))){
var inst_65266 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_65288__$1 = state_65288;
var statearr_65295_65322 = state_65288__$1;
(statearr_65295_65322[(2)] = inst_65266);

(statearr_65295_65322[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (6))){
var inst_65253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65254 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65255 = [inst_65254,(0)];
var inst_65256 = (new cljs.core.PersistentVector(null,2,(5),inst_65253,inst_65255,null));
var state_65288__$1 = state_65288;
var statearr_65296_65323 = state_65288__$1;
(statearr_65296_65323[(2)] = inst_65256);

(statearr_65296_65323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (3))){
var inst_65286 = (state_65288[(2)]);
var state_65288__$1 = state_65288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65288__$1,inst_65286);
} else {
if((state_val_65289 === (12))){
var inst_65262 = (state_65288[(2)]);
var inst_65263 = fluree.db.util.async.throw_err.call(null,inst_65262);
var state_65288__$1 = state_65288;
var statearr_65297_65324 = state_65288__$1;
(statearr_65297_65324[(2)] = inst_65263);

(statearr_65297_65324[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (2))){
var _ = (function (){var statearr_65298 = state_65288;
(statearr_65298[(4)] = cljs.core.cons.call(null,(5),(state_65288[(4)])));

return statearr_65298;
})();
var inst_65251 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65288__$1 = state_65288;
if(cljs.core.truth_(inst_65251)){
var statearr_65299_65325 = state_65288__$1;
(statearr_65299_65325[(1)] = (6));

} else {
var statearr_65300_65326 = state_65288__$1;
(statearr_65300_65326[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (11))){
var inst_65271 = (state_65288[(2)]);
var state_65288__$1 = state_65288;
var statearr_65302_65327 = state_65288__$1;
(statearr_65302_65327[(2)] = inst_65271);

(statearr_65302_65327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (9))){
var inst_65260 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_65288__$1 = state_65288;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65288__$1,(12),inst_65260);
} else {
if((state_val_65289 === (5))){
var _ = (function (){var statearr_65303 = state_65288;
(statearr_65303[(4)] = cljs.core.rest.call(null,(state_65288[(4)])));

return statearr_65303;
})();
var state_65288__$1 = state_65288;
var ex65301 = (state_65288__$1[(2)]);
var statearr_65304_65328 = state_65288__$1;
(statearr_65304_65328[(5)] = ex65301);


if((ex65301 instanceof Error)){
var statearr_65305_65329 = state_65288__$1;
(statearr_65305_65329[(1)] = (4));

(statearr_65305_65329[(5)] = null);

} else {
throw ex65301;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (14))){
var state_65288__$1 = state_65288;
var statearr_65306_65330 = state_65288__$1;
(statearr_65306_65330[(2)] = null);

(statearr_65306_65330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (10))){
var state_65288__$1 = state_65288;
var statearr_65307_65331 = state_65288__$1;
(statearr_65307_65331[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65289 === (8))){
var inst_65273 = (state_65288[(2)]);
var inst_65274 = cljs.core.nth.call(null,inst_65273,(0),null);
var inst_65275 = cljs.core.nth.call(null,inst_65273,(1),null);
var inst_65276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65277 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65278 = ["?user_id","?ctx",inst_65274];
var inst_65279 = cljs.core.PersistentHashMap.fromArrays(inst_65277,inst_65278);
var inst_65280 = ((10) + inst_65275);
var inst_65281 = [inst_65279,inst_65280];
var inst_65282 = (new cljs.core.PersistentVector(null,2,(5),inst_65276,inst_65281,null));
var inst_65283 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65282);
var _ = (function (){var statearr_65309 = state_65288;
(statearr_65309[(4)] = cljs.core.rest.call(null,(state_65288[(4)])));

return statearr_65309;
})();
var state_65288__$1 = (function (){var statearr_65310 = state_65288;
(statearr_65310[(7)] = inst_65283);

return statearr_65310;
})();
var statearr_65311_65332 = state_65288__$1;
(statearr_65311_65332[(2)] = inst_65274);

(statearr_65311_65332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_65312 = [null,null,null,null,null,null,null,null];
(statearr_65312[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_65312[(1)] = (1));

return statearr_65312;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_65288){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65313){var ex__2749__auto__ = e65313;
var statearr_65314_65333 = state_65288;
(statearr_65314_65333[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65288[(4)]))){
var statearr_65315_65334 = state_65288;
(statearr_65315_65334[(1)] = cljs.core.first.call(null,(state_65288[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65335 = state_65288;
state_65288 = G__65335;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_65288){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_65288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65316 = f__2769__auto__.call(null);
(statearr_65316[(6)] = c__2768__auto__);

return statearr_65316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65363){
var state_val_65364 = (state_65363[(1)]);
if((state_val_65364 === (7))){
var inst_65356 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_65363__$1 = state_65363;
var statearr_65365_65384 = state_65363__$1;
(statearr_65365_65384[(2)] = inst_65356);

(statearr_65365_65384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65364 === (1))){
var state_65363__$1 = state_65363;
var statearr_65366_65385 = state_65363__$1;
(statearr_65366_65385[(2)] = null);

(statearr_65366_65385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65364 === (4))){
var inst_65336 = (state_65363[(2)]);
var state_65363__$1 = state_65363;
var statearr_65367_65386 = state_65363__$1;
(statearr_65367_65386[(2)] = inst_65336);

(statearr_65367_65386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65364 === (6))){
var inst_65344 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_65363__$1 = state_65363;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65363__$1,(9),inst_65344);
} else {
if((state_val_65364 === (3))){
var inst_65361 = (state_65363[(2)]);
var state_65363__$1 = state_65363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65363__$1,inst_65361);
} else {
if((state_val_65364 === (2))){
var _ = (function (){var statearr_65369 = state_65363;
(statearr_65369[(4)] = cljs.core.cons.call(null,(5),(state_65363[(4)])));

return statearr_65369;
})();
var inst_65342 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65363__$1 = state_65363;
if(cljs.core.truth_(inst_65342)){
var statearr_65370_65387 = state_65363__$1;
(statearr_65370_65387[(1)] = (6));

} else {
var statearr_65371_65388 = state_65363__$1;
(statearr_65371_65388[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65364 === (9))){
var inst_65346 = (state_65363[(2)]);
var inst_65347 = fluree.db.util.async.throw_err.call(null,inst_65346);
var inst_65348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65349 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65350 = ["?auth_id","?ctx",inst_65347];
var inst_65351 = cljs.core.PersistentHashMap.fromArrays(inst_65349,inst_65350);
var inst_65352 = [inst_65351,(10)];
var inst_65353 = (new cljs.core.PersistentVector(null,2,(5),inst_65348,inst_65352,null));
var inst_65354 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65353);
var state_65363__$1 = (function (){var statearr_65372 = state_65363;
(statearr_65372[(7)] = inst_65354);

return statearr_65372;
})();
var statearr_65373_65389 = state_65363__$1;
(statearr_65373_65389[(2)] = inst_65347);

(statearr_65373_65389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65364 === (5))){
var _ = (function (){var statearr_65374 = state_65363;
(statearr_65374[(4)] = cljs.core.rest.call(null,(state_65363[(4)])));

return statearr_65374;
})();
var state_65363__$1 = state_65363;
var ex65368 = (state_65363__$1[(2)]);
var statearr_65375_65390 = state_65363__$1;
(statearr_65375_65390[(5)] = ex65368);


if((ex65368 instanceof Error)){
var statearr_65376_65391 = state_65363__$1;
(statearr_65376_65391[(1)] = (4));

(statearr_65376_65391[(5)] = null);

} else {
throw ex65368;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65364 === (8))){
var inst_65358 = (state_65363[(2)]);
var _ = (function (){var statearr_65377 = state_65363;
(statearr_65377[(4)] = cljs.core.rest.call(null,(state_65363[(4)])));

return statearr_65377;
})();
var state_65363__$1 = state_65363;
var statearr_65378_65392 = state_65363__$1;
(statearr_65378_65392[(2)] = inst_65358);

(statearr_65378_65392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_65379 = [null,null,null,null,null,null,null,null];
(statearr_65379[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_65379[(1)] = (1));

return statearr_65379;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_65363){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65380){var ex__2749__auto__ = e65380;
var statearr_65381_65393 = state_65363;
(statearr_65381_65393[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65363[(4)]))){
var statearr_65382_65394 = state_65363;
(statearr_65382_65394[(1)] = cljs.core.first.call(null,(state_65363[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65395 = state_65363;
state_65363 = G__65395;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_65363){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_65363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65383 = f__2769__auto__.call(null);
(statearr_65383[(6)] = c__2768__auto__);

return statearr_65383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__65397 = arguments.length;
switch (G__65397) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65439){
var state_val_65440 = (state_65439[(1)]);
if((state_val_65440 === (7))){
var state_65439__$1 = state_65439;
var statearr_65441_65471 = state_65439__$1;
(statearr_65441_65471[(2)] = seed);

(statearr_65441_65471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (1))){
var state_65439__$1 = state_65439;
var statearr_65442_65472 = state_65439__$1;
(statearr_65442_65472[(2)] = null);

(statearr_65442_65472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (4))){
var inst_65398 = (state_65439[(2)]);
var state_65439__$1 = state_65439;
var statearr_65443_65473 = state_65439__$1;
(statearr_65443_65473[(2)] = inst_65398);

(statearr_65443_65473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (15))){
var state_65439__$1 = state_65439;
var statearr_65444_65474 = state_65439__$1;
(statearr_65444_65474[(2)] = (10));

(statearr_65444_65474[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (13))){
var inst_65415 = (state_65439[(2)]);
var inst_65416 = fluree.db.util.async.throw_err.call(null,inst_65415);
var state_65439__$1 = state_65439;
var statearr_65445_65475 = state_65439__$1;
(statearr_65445_65475[(2)] = inst_65416);

(statearr_65445_65475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (6))){
var state_65439__$1 = state_65439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65439__$1,(9),seed);
} else {
if((state_val_65440 === (3))){
var inst_65437 = (state_65439[(2)]);
var state_65439__$1 = state_65439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65439__$1,inst_65437);
} else {
if((state_val_65440 === (12))){
var inst_65419 = (state_65439[(7)]);
var inst_65419__$1 = (state_65439[(2)]);
var state_65439__$1 = (function (){var statearr_65446 = state_65439;
(statearr_65446[(7)] = inst_65419__$1);

return statearr_65446;
})();
if(cljs.core.truth_(inst_65419__$1)){
var statearr_65447_65476 = state_65439__$1;
(statearr_65447_65476[(1)] = (14));

} else {
var statearr_65448_65477 = state_65439__$1;
(statearr_65448_65477[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (2))){
var _ = (function (){var statearr_65449 = state_65439;
(statearr_65449[(4)] = cljs.core.cons.call(null,(5),(state_65439[(4)])));

return statearr_65449;
})();
var inst_65404 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_65439__$1 = state_65439;
if(inst_65404){
var statearr_65450_65478 = state_65439__$1;
(statearr_65450_65478[(1)] = (6));

} else {
var statearr_65451_65479 = state_65439__$1;
(statearr_65451_65479[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (11))){
var state_65439__$1 = state_65439;
var statearr_65453_65480 = state_65439__$1;
(statearr_65453_65480[(2)] = max);

(statearr_65453_65480[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (9))){
var inst_65407 = (state_65439[(2)]);
var inst_65408 = fluree.db.util.async.throw_err.call(null,inst_65407);
var state_65439__$1 = state_65439;
var statearr_65454_65481 = state_65439__$1;
(statearr_65454_65481[(2)] = inst_65408);

(statearr_65454_65481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (5))){
var _ = (function (){var statearr_65455 = state_65439;
(statearr_65455[(4)] = cljs.core.rest.call(null,(state_65439[(4)])));

return statearr_65455;
})();
var state_65439__$1 = state_65439;
var ex65452 = (state_65439__$1[(2)]);
var statearr_65456_65482 = state_65439__$1;
(statearr_65456_65482[(5)] = ex65452);


if((ex65452 instanceof Error)){
var statearr_65457_65483 = state_65439__$1;
(statearr_65457_65483[(1)] = (4));

(statearr_65457_65483[(5)] = null);

} else {
throw ex65452;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (14))){
var inst_65419 = (state_65439[(7)]);
var state_65439__$1 = state_65439;
var statearr_65458_65484 = state_65439__$1;
(statearr_65458_65484[(2)] = inst_65419);

(statearr_65458_65484[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (16))){
var inst_65411 = (state_65439[(8)]);
var inst_65423 = (state_65439[(2)]);
var inst_65424 = fluree.db.dbfunctions.internal.rand.call(null,inst_65411,inst_65423);
var inst_65425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65426 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65428 = [max,seed];
var inst_65429 = (new cljs.core.PersistentVector(null,2,(5),inst_65427,inst_65428,null));
var inst_65430 = ["rand",inst_65429,inst_65424];
var inst_65431 = cljs.core.PersistentHashMap.fromArrays(inst_65426,inst_65430);
var inst_65432 = [inst_65431,(10)];
var inst_65433 = (new cljs.core.PersistentVector(null,2,(5),inst_65425,inst_65432,null));
var inst_65434 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65433);
var _ = (function (){var statearr_65459 = state_65439;
(statearr_65459[(4)] = cljs.core.rest.call(null,(state_65439[(4)])));

return statearr_65459;
})();
var state_65439__$1 = (function (){var statearr_65460 = state_65439;
(statearr_65460[(9)] = inst_65434);

return statearr_65460;
})();
var statearr_65461_65485 = state_65439__$1;
(statearr_65461_65485[(2)] = inst_65424);

(statearr_65461_65485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (10))){
var state_65439__$1 = state_65439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65439__$1,(13),max);
} else {
if((state_val_65440 === (8))){
var inst_65411 = (state_65439[(2)]);
var inst_65412 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_65439__$1 = (function (){var statearr_65462 = state_65439;
(statearr_65462[(8)] = inst_65411);

return statearr_65462;
})();
if(inst_65412){
var statearr_65463_65486 = state_65439__$1;
(statearr_65463_65486[(1)] = (10));

} else {
var statearr_65464_65487 = state_65439__$1;
(statearr_65464_65487[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_65465 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65465[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_65465[(1)] = (1));

return statearr_65465;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_65439){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65466){var ex__2749__auto__ = e65466;
var statearr_65467_65488 = state_65439;
(statearr_65467_65488[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65439[(4)]))){
var statearr_65468_65489 = state_65439;
(statearr_65468_65489[(1)] = cljs.core.first.call(null,(state_65439[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65490 = state_65439;
state_65439 = G__65490;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_65439){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_65439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65469 = f__2769__auto__.call(null);
(statearr_65469[(6)] = c__2768__auto__);

return statearr_65469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65511){
var state_val_65512 = (state_65511[(1)]);
if((state_val_65512 === (1))){
var state_65511__$1 = state_65511;
var statearr_65513_65528 = state_65511__$1;
(statearr_65513_65528[(2)] = null);

(statearr_65513_65528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65512 === (2))){
var _ = (function (){var statearr_65514 = state_65511;
(statearr_65514[(4)] = cljs.core.cons.call(null,(5),(state_65511[(4)])));

return statearr_65514;
})();
var inst_65497 = cljs.core.random_uuid.call(null);
var inst_65498 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65497);
var inst_65499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65500 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65501 = cljs.core.PersistentVector.EMPTY;
var inst_65502 = ["uuid",inst_65501,inst_65498];
var inst_65503 = cljs.core.PersistentHashMap.fromArrays(inst_65500,inst_65502);
var inst_65504 = [inst_65503,(10)];
var inst_65505 = (new cljs.core.PersistentVector(null,2,(5),inst_65499,inst_65504,null));
var inst_65506 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65505);
var ___$1 = (function (){var statearr_65515 = state_65511;
(statearr_65515[(4)] = cljs.core.rest.call(null,(state_65511[(4)])));

return statearr_65515;
})();
var state_65511__$1 = (function (){var statearr_65516 = state_65511;
(statearr_65516[(7)] = inst_65506);

return statearr_65516;
})();
var statearr_65517_65529 = state_65511__$1;
(statearr_65517_65529[(2)] = inst_65498);

(statearr_65517_65529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65512 === (3))){
var inst_65509 = (state_65511[(2)]);
var state_65511__$1 = state_65511;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65511__$1,inst_65509);
} else {
if((state_val_65512 === (4))){
var inst_65491 = (state_65511[(2)]);
var state_65511__$1 = state_65511;
var statearr_65519_65530 = state_65511__$1;
(statearr_65519_65530[(2)] = inst_65491);

(statearr_65519_65530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65512 === (5))){
var _ = (function (){var statearr_65520 = state_65511;
(statearr_65520[(4)] = cljs.core.rest.call(null,(state_65511[(4)])));

return statearr_65520;
})();
var state_65511__$1 = state_65511;
var ex65518 = (state_65511__$1[(2)]);
var statearr_65521_65531 = state_65511__$1;
(statearr_65521_65531[(5)] = ex65518);


if((ex65518 instanceof Error)){
var statearr_65522_65532 = state_65511__$1;
(statearr_65522_65532[(1)] = (4));

(statearr_65522_65532[(5)] = null);

} else {
throw ex65518;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_65523 = [null,null,null,null,null,null,null,null];
(statearr_65523[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_65523[(1)] = (1));

return statearr_65523;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_65511){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65511);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65524){var ex__2749__auto__ = e65524;
var statearr_65525_65533 = state_65511;
(statearr_65525_65533[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65511[(4)]))){
var statearr_65526_65534 = state_65511;
(statearr_65526_65534[(1)] = cljs.core.first.call(null,(state_65511[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65535 = state_65511;
state_65511 = G__65535;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_65511){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_65511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65527 = f__2769__auto__.call(null);
(statearr_65527[(6)] = c__2768__auto__);

return statearr_65527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65565){
var state_val_65566 = (state_65565[(1)]);
if((state_val_65566 === (7))){
var state_65565__$1 = state_65565;
var statearr_65567_65586 = state_65565__$1;
(statearr_65567_65586[(2)] = num);

(statearr_65567_65586[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65566 === (1))){
var state_65565__$1 = state_65565;
var statearr_65568_65587 = state_65565__$1;
(statearr_65568_65587[(2)] = null);

(statearr_65568_65587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65566 === (4))){
var inst_65536 = (state_65565[(2)]);
var state_65565__$1 = state_65565;
var statearr_65569_65588 = state_65565__$1;
(statearr_65569_65588[(2)] = inst_65536);

(statearr_65569_65588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65566 === (6))){
var state_65565__$1 = state_65565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65565__$1,(9),num);
} else {
if((state_val_65566 === (3))){
var inst_65563 = (state_65565[(2)]);
var state_65565__$1 = state_65565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65565__$1,inst_65563);
} else {
if((state_val_65566 === (2))){
var _ = (function (){var statearr_65571 = state_65565;
(statearr_65571[(4)] = cljs.core.cons.call(null,(5),(state_65565[(4)])));

return statearr_65571;
})();
var inst_65542 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_65565__$1 = state_65565;
if(inst_65542){
var statearr_65572_65589 = state_65565__$1;
(statearr_65572_65589[(1)] = (6));

} else {
var statearr_65573_65590 = state_65565__$1;
(statearr_65573_65590[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65566 === (9))){
var inst_65545 = (state_65565[(2)]);
var inst_65546 = fluree.db.util.async.throw_err.call(null,inst_65545);
var state_65565__$1 = state_65565;
var statearr_65574_65591 = state_65565__$1;
(statearr_65574_65591[(2)] = inst_65546);

(statearr_65574_65591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65566 === (5))){
var _ = (function (){var statearr_65575 = state_65565;
(statearr_65575[(4)] = cljs.core.rest.call(null,(state_65565[(4)])));

return statearr_65575;
})();
var state_65565__$1 = state_65565;
var ex65570 = (state_65565__$1[(2)]);
var statearr_65576_65592 = state_65565__$1;
(statearr_65576_65592[(5)] = ex65570);


if((ex65570 instanceof Error)){
var statearr_65577_65593 = state_65565__$1;
(statearr_65577_65593[(1)] = (4));

(statearr_65577_65593[(5)] = null);

} else {
throw ex65570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65566 === (8))){
var inst_65549 = (state_65565[(2)]);
var inst_65550 = fluree.db.dbfunctions.internal.ceil.call(null,inst_65549);
var inst_65551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65552 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65554 = [fluree.db.dbfunctions.fns.ceil];
var inst_65555 = (new cljs.core.PersistentVector(null,1,(5),inst_65553,inst_65554,null));
var inst_65556 = ["",inst_65555,inst_65550];
var inst_65557 = cljs.core.PersistentHashMap.fromArrays(inst_65552,inst_65556);
var inst_65558 = [inst_65557,(10)];
var inst_65559 = (new cljs.core.PersistentVector(null,2,(5),inst_65551,inst_65558,null));
var inst_65560 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65559);
var _ = (function (){var statearr_65578 = state_65565;
(statearr_65578[(4)] = cljs.core.rest.call(null,(state_65565[(4)])));

return statearr_65578;
})();
var state_65565__$1 = (function (){var statearr_65579 = state_65565;
(statearr_65579[(7)] = inst_65560);

return statearr_65579;
})();
var statearr_65580_65594 = state_65565__$1;
(statearr_65580_65594[(2)] = inst_65550);

(statearr_65580_65594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_65581 = [null,null,null,null,null,null,null,null];
(statearr_65581[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_65581[(1)] = (1));

return statearr_65581;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_65565){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65582){var ex__2749__auto__ = e65582;
var statearr_65583_65595 = state_65565;
(statearr_65583_65595[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65565[(4)]))){
var statearr_65584_65596 = state_65565;
(statearr_65584_65596[(1)] = cljs.core.first.call(null,(state_65565[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65597 = state_65565;
state_65565 = G__65597;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_65565){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_65565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65585 = f__2769__auto__.call(null);
(statearr_65585[(6)] = c__2768__auto__);

return statearr_65585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65627){
var state_val_65628 = (state_65627[(1)]);
if((state_val_65628 === (7))){
var state_65627__$1 = state_65627;
var statearr_65629_65648 = state_65627__$1;
(statearr_65629_65648[(2)] = num);

(statearr_65629_65648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65628 === (1))){
var state_65627__$1 = state_65627;
var statearr_65630_65649 = state_65627__$1;
(statearr_65630_65649[(2)] = null);

(statearr_65630_65649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65628 === (4))){
var inst_65598 = (state_65627[(2)]);
var state_65627__$1 = state_65627;
var statearr_65631_65650 = state_65627__$1;
(statearr_65631_65650[(2)] = inst_65598);

(statearr_65631_65650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65628 === (6))){
var state_65627__$1 = state_65627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65627__$1,(9),num);
} else {
if((state_val_65628 === (3))){
var inst_65625 = (state_65627[(2)]);
var state_65627__$1 = state_65627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65627__$1,inst_65625);
} else {
if((state_val_65628 === (2))){
var _ = (function (){var statearr_65633 = state_65627;
(statearr_65633[(4)] = cljs.core.cons.call(null,(5),(state_65627[(4)])));

return statearr_65633;
})();
var inst_65604 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_65627__$1 = state_65627;
if(inst_65604){
var statearr_65634_65651 = state_65627__$1;
(statearr_65634_65651[(1)] = (6));

} else {
var statearr_65635_65652 = state_65627__$1;
(statearr_65635_65652[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65628 === (9))){
var inst_65607 = (state_65627[(2)]);
var inst_65608 = fluree.db.util.async.throw_err.call(null,inst_65607);
var state_65627__$1 = state_65627;
var statearr_65636_65653 = state_65627__$1;
(statearr_65636_65653[(2)] = inst_65608);

(statearr_65636_65653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65628 === (5))){
var _ = (function (){var statearr_65637 = state_65627;
(statearr_65637[(4)] = cljs.core.rest.call(null,(state_65627[(4)])));

return statearr_65637;
})();
var state_65627__$1 = state_65627;
var ex65632 = (state_65627__$1[(2)]);
var statearr_65638_65654 = state_65627__$1;
(statearr_65638_65654[(5)] = ex65632);


if((ex65632 instanceof Error)){
var statearr_65639_65655 = state_65627__$1;
(statearr_65639_65655[(1)] = (4));

(statearr_65639_65655[(5)] = null);

} else {
throw ex65632;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65628 === (8))){
var inst_65611 = (state_65627[(2)]);
var inst_65612 = fluree.db.dbfunctions.internal.floor.call(null,inst_65611);
var inst_65613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65614 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65616 = [fluree.db.dbfunctions.fns.floor];
var inst_65617 = (new cljs.core.PersistentVector(null,1,(5),inst_65615,inst_65616,null));
var inst_65618 = ["",inst_65617,inst_65612];
var inst_65619 = cljs.core.PersistentHashMap.fromArrays(inst_65614,inst_65618);
var inst_65620 = [inst_65619,(10)];
var inst_65621 = (new cljs.core.PersistentVector(null,2,(5),inst_65613,inst_65620,null));
var inst_65622 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65621);
var _ = (function (){var statearr_65640 = state_65627;
(statearr_65640[(4)] = cljs.core.rest.call(null,(state_65627[(4)])));

return statearr_65640;
})();
var state_65627__$1 = (function (){var statearr_65641 = state_65627;
(statearr_65641[(7)] = inst_65622);

return statearr_65641;
})();
var statearr_65642_65656 = state_65627__$1;
(statearr_65642_65656[(2)] = inst_65612);

(statearr_65642_65656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_65643 = [null,null,null,null,null,null,null,null];
(statearr_65643[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_65643[(1)] = (1));

return statearr_65643;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_65627){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65644){var ex__2749__auto__ = e65644;
var statearr_65645_65657 = state_65627;
(statearr_65645_65657[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65627[(4)]))){
var statearr_65646_65658 = state_65627;
(statearr_65646_65658[(1)] = cljs.core.first.call(null,(state_65627[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65659 = state_65627;
state_65627 = G__65659;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_65627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_65627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65647 = f__2769__auto__.call(null);
(statearr_65647[(6)] = c__2768__auto__);

return statearr_65647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65684){
var state_val_65685 = (state_65684[(1)]);
if((state_val_65685 === (1))){
var state_65684__$1 = state_65684;
var statearr_65686_65701 = state_65684__$1;
(statearr_65686_65701[(2)] = null);

(statearr_65686_65701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65685 === (2))){
var _ = (function (){var statearr_65687 = state_65684;
(statearr_65687[(4)] = cljs.core.cons.call(null,(5),(state_65684[(4)])));

return statearr_65687;
})();
var inst_65666 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_65684__$1 = state_65684;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65684__$1,(6),inst_65666);
} else {
if((state_val_65685 === (3))){
var inst_65682 = (state_65684[(2)]);
var state_65684__$1 = state_65684;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65684__$1,inst_65682);
} else {
if((state_val_65685 === (4))){
var inst_65660 = (state_65684[(2)]);
var state_65684__$1 = state_65684;
var statearr_65689_65702 = state_65684__$1;
(statearr_65689_65702[(2)] = inst_65660);

(statearr_65689_65702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65685 === (5))){
var _ = (function (){var statearr_65690 = state_65684;
(statearr_65690[(4)] = cljs.core.rest.call(null,(state_65684[(4)])));

return statearr_65690;
})();
var state_65684__$1 = state_65684;
var ex65688 = (state_65684__$1[(2)]);
var statearr_65691_65703 = state_65684__$1;
(statearr_65691_65703[(5)] = ex65688);


if((ex65688 instanceof Error)){
var statearr_65692_65704 = state_65684__$1;
(statearr_65692_65704[(1)] = (4));

(statearr_65692_65704[(5)] = null);

} else {
throw ex65688;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65685 === (6))){
var inst_65668 = (state_65684[(2)]);
var inst_65669 = fluree.db.util.async.throw_err.call(null,inst_65668);
var inst_65670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65671 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65673 = [compare_val,new_val];
var inst_65674 = (new cljs.core.PersistentVector(null,2,(5),inst_65672,inst_65673,null));
var inst_65675 = ["",inst_65674,inst_65669];
var inst_65676 = cljs.core.PersistentHashMap.fromArrays(inst_65671,inst_65675);
var inst_65677 = [inst_65676,(10)];
var inst_65678 = (new cljs.core.PersistentVector(null,2,(5),inst_65670,inst_65677,null));
var inst_65679 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65678);
var _ = (function (){var statearr_65693 = state_65684;
(statearr_65693[(4)] = cljs.core.rest.call(null,(state_65684[(4)])));

return statearr_65693;
})();
var state_65684__$1 = (function (){var statearr_65694 = state_65684;
(statearr_65694[(7)] = inst_65679);

return statearr_65694;
})();
var statearr_65695_65705 = state_65684__$1;
(statearr_65695_65705[(2)] = inst_65669);

(statearr_65695_65705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_65696 = [null,null,null,null,null,null,null,null];
(statearr_65696[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_65696[(1)] = (1));

return statearr_65696;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_65684){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65684);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65697){var ex__2749__auto__ = e65697;
var statearr_65698_65706 = state_65684;
(statearr_65698_65706[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65684[(4)]))){
var statearr_65699_65707 = state_65684;
(statearr_65699_65707[(1)] = cljs.core.first.call(null,(state_65684[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65708 = state_65684;
state_65684 = G__65708;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_65684){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_65684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65700 = f__2769__auto__.call(null);
(statearr_65700[(6)] = c__2768__auto__);

return statearr_65700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
