// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__71160 = arguments.length;
switch (G__71160) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71205){
var state_val_71206 = (state_71205[(1)]);
if((state_val_71206 === (7))){
var inst_71175 = typeof user === 'string';
var state_71205__$1 = state_71205;
if(cljs.core.truth_(inst_71175)){
var statearr_71207_71236 = state_71205__$1;
(statearr_71207_71236[(1)] = (9));

} else {
var statearr_71208_71237 = state_71205__$1;
(statearr_71208_71237[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (1))){
var state_71205__$1 = state_71205;
var statearr_71209_71238 = state_71205__$1;
(statearr_71209_71238[(2)] = null);

(statearr_71209_71238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (4))){
var inst_71161 = (state_71205[(2)]);
var inst_71162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71163 = [inst_71161];
var inst_71164 = (new cljs.core.PersistentVector(null,1,(5),inst_71162,inst_71163,null));
var inst_71165 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71164);
var inst_71166 = reject.call(null,inst_71161);
var state_71205__$1 = (function (){var statearr_71210 = state_71205;
(statearr_71210[(7)] = inst_71165);

return statearr_71210;
})();
var statearr_71211_71239 = state_71205__$1;
(statearr_71211_71239[(2)] = inst_71166);

(statearr_71211_71239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (15))){
var inst_71194 = (state_71205[(2)]);
var inst_71195 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_71194);
var inst_71196 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71197 = cljs.core.constantly.call(null,inst_71195);
var inst_71198 = cljs.core.swap_BANG_.call(null,inst_71196,inst_71197);
var inst_71199 = fluree.db.connection.add_token.call(null,conn,inst_71195);
var inst_71200 = resolve.call(null,inst_71194);
var _ = (function (){var statearr_71212 = state_71205;
(statearr_71212[(4)] = cljs.core.rest.call(null,(state_71205[(4)])));

return statearr_71212;
})();
var state_71205__$1 = (function (){var statearr_71213 = state_71205;
(statearr_71213[(8)] = inst_71199);

(statearr_71213[(9)] = inst_71198);

return statearr_71213;
})();
var statearr_71214_71240 = state_71205__$1;
(statearr_71214_71240[(2)] = inst_71200);

(statearr_71214_71240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (13))){
var state_71205__$1 = state_71205;
var statearr_71215_71241 = state_71205__$1;
(statearr_71215_71241[(2)] = null);

(statearr_71215_71241[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (6))){
var state_71205__$1 = state_71205;
var statearr_71216_71242 = state_71205__$1;
(statearr_71216_71242[(2)] = user);

(statearr_71216_71242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (3))){
var inst_71203 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71205__$1,inst_71203);
} else {
if((state_val_71206 === (12))){
var state_71205__$1 = state_71205;
var statearr_71217_71243 = state_71205__$1;
(statearr_71217_71243[(2)] = user);

(statearr_71217_71243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (2))){
var _ = (function (){var statearr_71218 = state_71205;
(statearr_71218[(4)] = cljs.core.cons.call(null,(5),(state_71205[(4)])));

return statearr_71218;
})();
var inst_71172 = typeof user === 'number';
var state_71205__$1 = state_71205;
if(cljs.core.truth_(inst_71172)){
var statearr_71219_71244 = state_71205__$1;
(statearr_71219_71244[(1)] = (6));

} else {
var statearr_71220_71245 = state_71205__$1;
(statearr_71220_71245[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (11))){
var inst_71186 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71222_71246 = state_71205__$1;
(statearr_71222_71246[(2)] = inst_71186);

(statearr_71222_71246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (9))){
var inst_71177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71178 = ["_user/username",user];
var inst_71179 = (new cljs.core.PersistentVector(null,2,(5),inst_71177,inst_71178,null));
var state_71205__$1 = state_71205;
var statearr_71223_71247 = state_71205__$1;
(statearr_71223_71247[(2)] = inst_71179);

(statearr_71223_71247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (5))){
var _ = (function (){var statearr_71224 = state_71205;
(statearr_71224[(4)] = cljs.core.rest.call(null,(state_71205[(4)])));

return statearr_71224;
})();
var state_71205__$1 = state_71205;
var ex71221 = (state_71205__$1[(2)]);
var statearr_71225_71248 = state_71205__$1;
(statearr_71225_71248[(5)] = ex71221);


var statearr_71226_71249 = state_71205__$1;
(statearr_71226_71249[(1)] = (4));

(statearr_71226_71249[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (14))){
var inst_71184 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71227_71250 = state_71205__$1;
(statearr_71227_71250[(2)] = inst_71184);

(statearr_71227_71250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (10))){
var state_71205__$1 = state_71205;
var statearr_71228_71251 = state_71205__$1;
(statearr_71228_71251[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (8))){
var inst_71188 = (state_71205[(2)]);
var inst_71189 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_71190 = [account,inst_71188,password,expireSeconds,syncTo];
var inst_71191 = cljs.core.PersistentHashMap.fromArrays(inst_71189,inst_71190);
var inst_71192 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_71191);
var state_71205__$1 = state_71205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71205__$1,(15),inst_71192);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71230 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71230[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71230[(1)] = (1));

return statearr_71230;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71205){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71231){var ex__2749__auto__ = e71231;
var statearr_71232_71252 = state_71205;
(statearr_71232_71252[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71205[(4)]))){
var statearr_71233_71253 = state_71205;
(statearr_71233_71253[(1)] = cljs.core.first.call(null,(state_71205[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71254 = state_71205;
state_71205 = G__71254;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71205){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71234 = f__2769__auto__.call(null);
(statearr_71234[(6)] = c__2768__auto__);

return statearr_71234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__71256 = arguments.length;
switch (G__71256) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71265){
var state_val_71266 = (state_71265[(1)]);
if((state_val_71266 === (1))){
var inst_71257 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71259 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_71260 = (new cljs.core.PersistentVector(null,4,(5),inst_71258,inst_71259,null));
var inst_71261 = cljs.core.async.put_BANG_.call(null,inst_71257,inst_71260);
var inst_71262 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__71267 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__71268 = null;
var count__71269 = (0);
var i__71270 = (0);
while(true){
if((i__71270 < count__71269)){
var k = cljs.core._nth.call(null,chunk__71268,i__71270);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__71278 = seq__71267;
var G__71279 = chunk__71268;
var G__71280 = count__71269;
var G__71281 = (i__71270 + (1));
seq__71267 = G__71278;
chunk__71268 = G__71279;
count__71269 = G__71280;
i__71270 = G__71281;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__71267);
if(temp__5804__auto__){
var seq__71267__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71267__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__71267__$1);
var G__71282 = cljs.core.chunk_rest.call(null,seq__71267__$1);
var G__71283 = c__5568__auto__;
var G__71284 = cljs.core.count.call(null,c__5568__auto__);
var G__71285 = (0);
seq__71267 = G__71282;
chunk__71268 = G__71283;
count__71269 = G__71284;
i__71270 = G__71285;
continue;
} else {
var k = cljs.core.first.call(null,seq__71267__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__71286 = cljs.core.next.call(null,seq__71267__$1);
var G__71287 = null;
var G__71288 = (0);
var G__71289 = (0);
seq__71267 = G__71286;
chunk__71268 = G__71287;
count__71269 = G__71288;
i__71270 = G__71289;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_71263 = cljs.core.async.take_BANG_.call(null,pc,inst_71262);
var state_71265__$1 = (function (){var statearr_71271 = state_71265;
(statearr_71271[(7)] = inst_71261);

return statearr_71271;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71265__$1,inst_71263);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71272 = [null,null,null,null,null,null,null,null];
(statearr_71272[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71272[(1)] = (1));

return statearr_71272;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71265){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71273){var ex__2749__auto__ = e71273;
var statearr_71274_71290 = state_71265;
(statearr_71274_71290[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71265[(4)]))){
var statearr_71275_71291 = state_71265;
(statearr_71275_71291[(1)] = cljs.core.first.call(null,(state_71265[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71292 = state_71265;
state_71265 = G__71292;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71265){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71276 = f__2769__auto__.call(null);
(statearr_71276[(6)] = c__2768__auto__);

return statearr_71276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__71294 = arguments.length;
switch (G__71294) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71331){
var state_val_71332 = (state_71331[(1)]);
if((state_val_71332 === (1))){
var state_71331__$1 = state_71331;
var statearr_71333_71354 = state_71331__$1;
(statearr_71333_71354[(2)] = null);

(statearr_71333_71354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71332 === (2))){
var _ = (function (){var statearr_71334 = state_71331;
(statearr_71334[(4)] = cljs.core.cons.call(null,(5),(state_71331[(4)])));

return statearr_71334;
})();
var inst_71306 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_71307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71308 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_71309 = (new cljs.core.PersistentVector(null,1,(5),inst_71307,inst_71308,null));
var inst_71310 = cljs.core.PersistentHashMap.EMPTY;
var inst_71311 = cljs.core.atom.call(null,inst_71310);
var inst_71312 = cljs.core.assoc_in.call(null,inst_71306,inst_71309,inst_71311);
var inst_71313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71314 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_71315 = (new cljs.core.PersistentVector(null,1,(5),inst_71313,inst_71314,null));
var inst_71316 = cljs.core.PersistentHashMap.EMPTY;
var inst_71317 = cljs.core.atom.call(null,inst_71316);
var inst_71318 = cljs.core.assoc_in.call(null,inst_71312,inst_71315,inst_71317);
var inst_71319 = cljs.core.async.promise_chan.call(null);
var inst_71320 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_71318);
var inst_71321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71322 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_71319,null];
var inst_71323 = (new cljs.core.PersistentVector(null,4,(5),inst_71321,inst_71322,null));
var inst_71324 = cljs.core.async.put_BANG_.call(null,inst_71320,inst_71323);
var inst_71325 = (function (){var conn = inst_71318;
var pc = inst_71319;
return (function (x){
if((x == null)){
} else {
var seq__71335_71355 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__71336_71356 = null;
var count__71337_71357 = (0);
var i__71338_71358 = (0);
while(true){
if((i__71338_71358 < count__71337_71357)){
var k_71359 = cljs.core._nth.call(null,chunk__71336_71356,i__71338_71358);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_71359], null),cljs.core.get.call(null,x,k_71359,null));


var G__71360 = seq__71335_71355;
var G__71361 = chunk__71336_71356;
var G__71362 = count__71337_71357;
var G__71363 = (i__71338_71358 + (1));
seq__71335_71355 = G__71360;
chunk__71336_71356 = G__71361;
count__71337_71357 = G__71362;
i__71338_71358 = G__71363;
continue;
} else {
var temp__5804__auto___71364 = cljs.core.seq.call(null,seq__71335_71355);
if(temp__5804__auto___71364){
var seq__71335_71365__$1 = temp__5804__auto___71364;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71335_71365__$1)){
var c__5568__auto___71366 = cljs.core.chunk_first.call(null,seq__71335_71365__$1);
var G__71367 = cljs.core.chunk_rest.call(null,seq__71335_71365__$1);
var G__71368 = c__5568__auto___71366;
var G__71369 = cljs.core.count.call(null,c__5568__auto___71366);
var G__71370 = (0);
seq__71335_71355 = G__71367;
chunk__71336_71356 = G__71368;
count__71337_71357 = G__71369;
i__71338_71358 = G__71370;
continue;
} else {
var k_71371 = cljs.core.first.call(null,seq__71335_71365__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_71371], null),cljs.core.get.call(null,x,k_71371,null));


var G__71372 = cljs.core.next.call(null,seq__71335_71365__$1);
var G__71373 = null;
var G__71374 = (0);
var G__71375 = (0);
seq__71335_71355 = G__71372;
chunk__71336_71356 = G__71373;
count__71337_71357 = G__71374;
i__71338_71358 = G__71375;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_71326 = cljs.core.async.take_BANG_.call(null,inst_71319,inst_71325);
var ___$1 = (function (){var statearr_71339 = state_71331;
(statearr_71339[(4)] = cljs.core.rest.call(null,(state_71331[(4)])));

return statearr_71339;
})();
var state_71331__$1 = (function (){var statearr_71340 = state_71331;
(statearr_71340[(7)] = inst_71324);

return statearr_71340;
})();
var statearr_71341_71376 = state_71331__$1;
(statearr_71341_71376[(2)] = inst_71326);

(statearr_71341_71376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71332 === (3))){
var inst_71329 = (state_71331[(2)]);
var state_71331__$1 = state_71331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71331__$1,inst_71329);
} else {
if((state_val_71332 === (4))){
var inst_71295 = (state_71331[(2)]);
var inst_71296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71297 = [inst_71295];
var inst_71298 = (new cljs.core.PersistentVector(null,1,(5),inst_71296,inst_71297,null));
var inst_71299 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71298);
var inst_71300 = reject.call(null,inst_71295);
var state_71331__$1 = (function (){var statearr_71343 = state_71331;
(statearr_71343[(8)] = inst_71299);

return statearr_71343;
})();
var statearr_71344_71377 = state_71331__$1;
(statearr_71344_71377[(2)] = inst_71300);

(statearr_71344_71377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71332 === (5))){
var _ = (function (){var statearr_71345 = state_71331;
(statearr_71345[(4)] = cljs.core.rest.call(null,(state_71331[(4)])));

return statearr_71345;
})();
var state_71331__$1 = state_71331;
var ex71342 = (state_71331__$1[(2)]);
var statearr_71346_71378 = state_71331__$1;
(statearr_71346_71378[(5)] = ex71342);


var statearr_71347_71379 = state_71331__$1;
(statearr_71347_71379[(1)] = (4));

(statearr_71347_71379[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71348 = [null,null,null,null,null,null,null,null,null];
(statearr_71348[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71348[(1)] = (1));

return statearr_71348;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71331){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71349){var ex__2749__auto__ = e71349;
var statearr_71350_71380 = state_71331;
(statearr_71350_71380[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71331[(4)]))){
var statearr_71351_71381 = state_71331;
(statearr_71351_71381[(1)] = cljs.core.first.call(null,(state_71331[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71382 = state_71331;
state_71331 = G__71382;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71331){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71352 = f__2769__auto__.call(null);
(statearr_71352[(6)] = c__2768__auto__);

return statearr_71352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__71384 = arguments.length;
switch (G__71384) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__71386 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__71386,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__71386,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__71389 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__71389,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__71389,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71442){
var state_val_71443 = (state_71442[(1)]);
if((state_val_71443 === (7))){
var inst_71403 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71404 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_71405 = cljs.core.PersistentHashMap.fromArrays(inst_71403,inst_71404);
var inst_71406 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_71405);
var inst_71407 = (function(){throw inst_71406})();
var state_71442__$1 = state_71442;
var statearr_71444_71473 = state_71442__$1;
(statearr_71444_71473[(2)] = inst_71407);

(statearr_71444_71473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (1))){
var state_71442__$1 = state_71442;
var statearr_71445_71474 = state_71442__$1;
(statearr_71445_71474[(2)] = null);

(statearr_71445_71474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (4))){
var inst_71392 = (state_71442[(2)]);
var inst_71393 = cljs.core.clj__GT_js.call(null,inst_71392);
var inst_71394 = reject.call(null,inst_71393);
var state_71442__$1 = state_71442;
var statearr_71446_71475 = state_71442__$1;
(statearr_71446_71475[(2)] = inst_71394);

(statearr_71446_71475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (13))){
var inst_71421 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71422 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_71423 = cljs.core.PersistentHashMap.fromArrays(inst_71421,inst_71422);
var inst_71424 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_71423);
var inst_71425 = (function(){throw inst_71424})();
var state_71442__$1 = state_71442;
var statearr_71447_71476 = state_71442__$1;
(statearr_71447_71476[(2)] = inst_71425);

(statearr_71447_71476[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (6))){
var state_71442__$1 = state_71442;
var statearr_71448_71477 = state_71442__$1;
(statearr_71448_71477[(2)] = null);

(statearr_71448_71477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (3))){
var inst_71440 = (state_71442[(2)]);
var state_71442__$1 = state_71442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71442__$1,inst_71440);
} else {
if((state_val_71443 === (12))){
var state_71442__$1 = state_71442;
var statearr_71449_71478 = state_71442__$1;
(statearr_71449_71478[(2)] = null);

(statearr_71449_71478[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (2))){
var _ = (function (){var statearr_71450 = state_71442;
(statearr_71450[(4)] = cljs.core.cons.call(null,(5),(state_71442[(4)])));

return statearr_71450;
})();
var inst_71400 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_71442__$1 = state_71442;
if(cljs.core.truth_(inst_71400)){
var statearr_71451_71479 = state_71442__$1;
(statearr_71451_71479[(1)] = (6));

} else {
var statearr_71452_71480 = state_71442__$1;
(statearr_71452_71480[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (11))){
var inst_71418 = (state_71442[(2)]);
var state_71442__$1 = (function (){var statearr_71454 = state_71442;
(statearr_71454[(7)] = inst_71418);

return statearr_71454;
})();
if(cljs.core.truth_(password)){
var statearr_71455_71481 = state_71442__$1;
(statearr_71455_71481[(1)] = (12));

} else {
var statearr_71456_71482 = state_71442__$1;
(statearr_71456_71482[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (9))){
var state_71442__$1 = state_71442;
var statearr_71457_71483 = state_71442__$1;
(statearr_71457_71483[(2)] = null);

(statearr_71457_71483[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (5))){
var _ = (function (){var statearr_71458 = state_71442;
(statearr_71458[(4)] = cljs.core.rest.call(null,(state_71442[(4)])));

return statearr_71458;
})();
var state_71442__$1 = state_71442;
var ex71453 = (state_71442__$1[(2)]);
var statearr_71459_71484 = state_71442__$1;
(statearr_71459_71484[(5)] = ex71453);


var statearr_71460_71485 = state_71442__$1;
(statearr_71460_71485[(1)] = (4));

(statearr_71460_71485[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (14))){
var inst_71427 = (state_71442[(2)]);
var inst_71428 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_71429 = fluree.db.util.core.without_nils.call(null,inst_71428);
var inst_71430 = cljs.core.async.promise_chan.call(null);
var inst_71431 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71433 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_71429,inst_71430,null];
var inst_71434 = (new cljs.core.PersistentVector(null,4,(5),inst_71432,inst_71433,null));
var inst_71435 = cljs.core.async.put_BANG_.call(null,inst_71431,inst_71434);
var inst_71436 = (function (){var _ = inst_71427;
var data = inst_71429;
var pc = inst_71430;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_71437 = cljs.core.async.take_BANG_.call(null,inst_71430,inst_71436);
var _ = (function (){var statearr_71461 = state_71442;
(statearr_71461[(4)] = cljs.core.rest.call(null,(state_71442[(4)])));

return statearr_71461;
})();
var state_71442__$1 = (function (){var statearr_71462 = state_71442;
(statearr_71462[(8)] = inst_71435);

return statearr_71462;
})();
var statearr_71463_71486 = state_71442__$1;
(statearr_71463_71486[(2)] = inst_71437);

(statearr_71463_71486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (10))){
var inst_71412 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71413 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_71414 = cljs.core.PersistentHashMap.fromArrays(inst_71412,inst_71413);
var inst_71415 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_71414);
var inst_71416 = (function(){throw inst_71415})();
var state_71442__$1 = state_71442;
var statearr_71464_71487 = state_71442__$1;
(statearr_71464_71487[(2)] = inst_71416);

(statearr_71464_71487[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71443 === (8))){
var inst_71409 = (state_71442[(2)]);
var state_71442__$1 = (function (){var statearr_71465 = state_71442;
(statearr_71465[(9)] = inst_71409);

return statearr_71465;
})();
if(cljs.core.truth_(ledger)){
var statearr_71466_71488 = state_71442__$1;
(statearr_71466_71488[(1)] = (9));

} else {
var statearr_71467_71489 = state_71442__$1;
(statearr_71467_71489[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_71468 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71468[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_71468[(1)] = (1));

return statearr_71468;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_71442){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71469){var ex__2749__auto__ = e71469;
var statearr_71470_71490 = state_71442;
(statearr_71470_71490[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71442[(4)]))){
var statearr_71471_71491 = state_71442;
(statearr_71471_71491[(1)] = cljs.core.first.call(null,(state_71442[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71492 = state_71442;
state_71442 = G__71492;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_71442){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_71442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71472 = f__2769__auto__.call(null);
(statearr_71472[(6)] = c__2768__auto__);

return statearr_71472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__71494 = arguments.length;
switch (G__71494) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71561){
var state_val_71562 = (state_71561[(1)]);
if((state_val_71562 === (7))){
var inst_71506 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71507 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_71508 = cljs.core.PersistentHashMap.fromArrays(inst_71506,inst_71507);
var inst_71509 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_71508);
var inst_71510 = (function(){throw inst_71509})();
var state_71561__$1 = state_71561;
var statearr_71563_71602 = state_71561__$1;
(statearr_71563_71602[(2)] = inst_71510);

(statearr_71563_71602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (20))){
var inst_71544 = (state_71561[(2)]);
var inst_71545 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_71546 = [ledger,password,user,auth,expire];
var inst_71547 = cljs.core.PersistentHashMap.fromArrays(inst_71545,inst_71546);
var inst_71548 = fluree.db.util.core.without_nils.call(null,inst_71547);
var inst_71549 = cljs.core.async.promise_chan.call(null);
var inst_71550 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71552 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_71548,inst_71549,null];
var inst_71553 = (new cljs.core.PersistentVector(null,4,(5),inst_71551,inst_71552,null));
var inst_71554 = cljs.core.async.put_BANG_.call(null,inst_71550,inst_71553);
var inst_71555 = (function (){var _ = inst_71544;
var data = inst_71548;
var pc = inst_71549;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_71556 = cljs.core.async.take_BANG_.call(null,inst_71549,inst_71555);
var _ = (function (){var statearr_71564 = state_71561;
(statearr_71564[(4)] = cljs.core.rest.call(null,(state_71561[(4)])));

return statearr_71564;
})();
var state_71561__$1 = (function (){var statearr_71565 = state_71561;
(statearr_71565[(7)] = inst_71554);

return statearr_71565;
})();
var statearr_71566_71603 = state_71561__$1;
(statearr_71566_71603[(2)] = inst_71556);

(statearr_71566_71603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (1))){
var state_71561__$1 = state_71561;
var statearr_71567_71604 = state_71561__$1;
(statearr_71567_71604[(2)] = null);

(statearr_71567_71604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (4))){
var inst_71495 = (state_71561[(2)]);
var inst_71496 = cljs.core.clj__GT_js.call(null,inst_71495);
var inst_71497 = reject.call(null,inst_71496);
var state_71561__$1 = state_71561;
var statearr_71568_71605 = state_71561__$1;
(statearr_71568_71605[(2)] = inst_71497);

(statearr_71568_71605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (15))){
var inst_71531 = (state_71561[(8)]);
var state_71561__$1 = state_71561;
var statearr_71569_71606 = state_71561__$1;
(statearr_71569_71606[(2)] = inst_71531);

(statearr_71569_71606[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (13))){
var inst_71524 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71525 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_71526 = cljs.core.PersistentHashMap.fromArrays(inst_71524,inst_71525);
var inst_71527 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_71526);
var inst_71528 = (function(){throw inst_71527})();
var state_71561__$1 = state_71561;
var statearr_71570_71607 = state_71561__$1;
(statearr_71570_71607[(2)] = inst_71528);

(statearr_71570_71607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (6))){
var state_71561__$1 = state_71561;
var statearr_71571_71608 = state_71561__$1;
(statearr_71571_71608[(2)] = null);

(statearr_71571_71608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (17))){
var inst_71535 = (state_71561[(2)]);
var state_71561__$1 = state_71561;
if(cljs.core.truth_(inst_71535)){
var statearr_71572_71609 = state_71561__$1;
(statearr_71572_71609[(1)] = (18));

} else {
var statearr_71573_71610 = state_71561__$1;
(statearr_71573_71610[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (3))){
var inst_71559 = (state_71561[(2)]);
var state_71561__$1 = state_71561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71561__$1,inst_71559);
} else {
if((state_val_71562 === (12))){
var state_71561__$1 = state_71561;
var statearr_71574_71611 = state_71561__$1;
(statearr_71574_71611[(2)] = null);

(statearr_71574_71611[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (2))){
var _ = (function (){var statearr_71575 = state_71561;
(statearr_71575[(4)] = cljs.core.cons.call(null,(5),(state_71561[(4)])));

return statearr_71575;
})();
var inst_71503 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_71561__$1 = state_71561;
if(cljs.core.truth_(inst_71503)){
var statearr_71576_71612 = state_71561__$1;
(statearr_71576_71612[(1)] = (6));

} else {
var statearr_71577_71613 = state_71561__$1;
(statearr_71577_71613[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (19))){
var inst_71538 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71539 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_71540 = cljs.core.PersistentHashMap.fromArrays(inst_71538,inst_71539);
var inst_71541 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_71540);
var inst_71542 = (function(){throw inst_71541})();
var state_71561__$1 = state_71561;
var statearr_71578_71614 = state_71561__$1;
(statearr_71578_71614[(2)] = inst_71542);

(statearr_71578_71614[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (11))){
var inst_71521 = (state_71561[(2)]);
var state_71561__$1 = (function (){var statearr_71580 = state_71561;
(statearr_71580[(9)] = inst_71521);

return statearr_71580;
})();
if(cljs.core.truth_(password)){
var statearr_71581_71615 = state_71561__$1;
(statearr_71581_71615[(1)] = (12));

} else {
var statearr_71582_71616 = state_71561__$1;
(statearr_71582_71616[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (9))){
var state_71561__$1 = state_71561;
var statearr_71583_71617 = state_71561__$1;
(statearr_71583_71617[(2)] = null);

(statearr_71583_71617[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (5))){
var _ = (function (){var statearr_71584 = state_71561;
(statearr_71584[(4)] = cljs.core.rest.call(null,(state_71561[(4)])));

return statearr_71584;
})();
var state_71561__$1 = state_71561;
var ex71579 = (state_71561__$1[(2)]);
var statearr_71585_71618 = state_71561__$1;
(statearr_71585_71618[(5)] = ex71579);


var statearr_71586_71619 = state_71561__$1;
(statearr_71586_71619[(1)] = (4));

(statearr_71586_71619[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (14))){
var inst_71531 = (state_71561[(8)]);
var inst_71530 = (state_71561[(2)]);
var inst_71531__$1 = user;
var state_71561__$1 = (function (){var statearr_71587 = state_71561;
(statearr_71587[(10)] = inst_71530);

(statearr_71587[(8)] = inst_71531__$1);

return statearr_71587;
})();
if(cljs.core.truth_(inst_71531__$1)){
var statearr_71588_71620 = state_71561__$1;
(statearr_71588_71620[(1)] = (15));

} else {
var statearr_71589_71621 = state_71561__$1;
(statearr_71589_71621[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (16))){
var state_71561__$1 = state_71561;
var statearr_71590_71622 = state_71561__$1;
(statearr_71590_71622[(2)] = auth);

(statearr_71590_71622[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (10))){
var inst_71515 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71516 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_71517 = cljs.core.PersistentHashMap.fromArrays(inst_71515,inst_71516);
var inst_71518 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_71517);
var inst_71519 = (function(){throw inst_71518})();
var state_71561__$1 = state_71561;
var statearr_71591_71623 = state_71561__$1;
(statearr_71591_71623[(2)] = inst_71519);

(statearr_71591_71623[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (18))){
var state_71561__$1 = state_71561;
var statearr_71592_71624 = state_71561__$1;
(statearr_71592_71624[(2)] = null);

(statearr_71592_71624[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71562 === (8))){
var inst_71512 = (state_71561[(2)]);
var state_71561__$1 = (function (){var statearr_71593 = state_71561;
(statearr_71593[(11)] = inst_71512);

return statearr_71593;
})();
if(cljs.core.truth_(ledger)){
var statearr_71594_71625 = state_71561__$1;
(statearr_71594_71625[(1)] = (9));

} else {
var statearr_71595_71626 = state_71561__$1;
(statearr_71595_71626[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71596 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71596[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71596[(1)] = (1));

return statearr_71596;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71561){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71597){var ex__2749__auto__ = e71597;
var statearr_71598_71627 = state_71561;
(statearr_71598_71627[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71561[(4)]))){
var statearr_71599_71628 = state_71561;
(statearr_71599_71628[(1)] = cljs.core.first.call(null,(state_71561[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71629 = state_71561;
state_71561 = G__71629;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71561){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71600 = f__2769__auto__.call(null);
(statearr_71600[(6)] = c__2768__auto__);

return statearr_71600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__71631 = arguments.length;
switch (G__71631) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71666){
var state_val_71667 = (state_71666[(1)]);
if((state_val_71667 === (1))){
var state_71666__$1 = state_71666;
var statearr_71668_71688 = state_71666__$1;
(statearr_71668_71688[(2)] = null);

(statearr_71668_71688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71667 === (2))){
var _ = (function (){var statearr_71669 = state_71666;
(statearr_71669[(4)] = cljs.core.cons.call(null,(5),(state_71666[(4)])));

return statearr_71669;
})();
var inst_71640 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_71666__$1 = state_71666;
if(cljs.core.truth_(inst_71640)){
var statearr_71670_71689 = state_71666__$1;
(statearr_71670_71689[(1)] = (6));

} else {
var statearr_71671_71690 = state_71666__$1;
(statearr_71671_71690[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71667 === (3))){
var inst_71664 = (state_71666[(2)]);
var state_71666__$1 = state_71666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71666__$1,inst_71664);
} else {
if((state_val_71667 === (4))){
var inst_71632 = (state_71666[(2)]);
var inst_71633 = cljs.core.clj__GT_js.call(null,inst_71632);
var inst_71634 = reject.call(null,inst_71633);
var state_71666__$1 = state_71666;
var statearr_71673_71691 = state_71666__$1;
(statearr_71673_71691[(2)] = inst_71634);

(statearr_71673_71691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71667 === (5))){
var _ = (function (){var statearr_71674 = state_71666;
(statearr_71674[(4)] = cljs.core.rest.call(null,(state_71666[(4)])));

return statearr_71674;
})();
var state_71666__$1 = state_71666;
var ex71672 = (state_71666__$1[(2)]);
var statearr_71675_71692 = state_71666__$1;
(statearr_71675_71692[(5)] = ex71672);


var statearr_71676_71693 = state_71666__$1;
(statearr_71676_71693[(1)] = (4));

(statearr_71676_71693[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71667 === (6))){
var state_71666__$1 = state_71666;
var statearr_71677_71694 = state_71666__$1;
(statearr_71677_71694[(2)] = null);

(statearr_71677_71694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71667 === (7))){
var inst_71643 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71644 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_71645 = cljs.core.PersistentHashMap.fromArrays(inst_71643,inst_71644);
var inst_71646 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_71645);
var inst_71647 = (function(){throw inst_71646})();
var state_71666__$1 = state_71666;
var statearr_71678_71695 = state_71666__$1;
(statearr_71678_71695[(2)] = inst_71647);

(statearr_71678_71695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71667 === (8))){
var inst_71649 = (state_71666[(2)]);
var inst_71650 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_71651 = [jwt,expire];
var inst_71652 = cljs.core.PersistentHashMap.fromArrays(inst_71650,inst_71651);
var inst_71653 = fluree.db.util.core.without_nils.call(null,inst_71652);
var inst_71654 = cljs.core.async.promise_chan.call(null);
var inst_71655 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71657 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_71653,inst_71654,null];
var inst_71658 = (new cljs.core.PersistentVector(null,4,(5),inst_71656,inst_71657,null));
var inst_71659 = cljs.core.async.put_BANG_.call(null,inst_71655,inst_71658);
var inst_71660 = (function (){var _ = inst_71649;
var data = inst_71653;
var pc = inst_71654;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_71661 = cljs.core.async.take_BANG_.call(null,inst_71654,inst_71660);
var _ = (function (){var statearr_71679 = state_71666;
(statearr_71679[(4)] = cljs.core.rest.call(null,(state_71666[(4)])));

return statearr_71679;
})();
var state_71666__$1 = (function (){var statearr_71680 = state_71666;
(statearr_71680[(7)] = inst_71659);

return statearr_71680;
})();
var statearr_71681_71696 = state_71666__$1;
(statearr_71681_71696[(2)] = inst_71661);

(statearr_71681_71696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71682 = [null,null,null,null,null,null,null,null];
(statearr_71682[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71682[(1)] = (1));

return statearr_71682;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71666){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71683){var ex__2749__auto__ = e71683;
var statearr_71684_71697 = state_71666;
(statearr_71684_71697[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71666[(4)]))){
var statearr_71685_71698 = state_71666;
(statearr_71685_71698[(1)] = cljs.core.first.call(null,(state_71666[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71699 = state_71666;
state_71666 = G__71699;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71666){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71686 = f__2769__auto__.call(null);
(statearr_71686[(6)] = c__2768__auto__);

return statearr_71686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

