// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__67814 = arguments.length;
switch (G__67814) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___67962 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67901){
var state_val_67902 = (state_67901[(1)]);
if((state_val_67902 === (7))){
var inst_67832 = (state_67901[(7)]);
var inst_67835 = cljs.core.not_EQ_.call(null,(0),inst_67832);
var state_67901__$1 = state_67901;
var statearr_67903_67963 = state_67901__$1;
(statearr_67903_67963[(2)] = inst_67835);

(statearr_67903_67963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (20))){
var inst_67856 = (state_67901[(8)]);
var inst_67827 = (state_67901[(9)]);
var inst_67860 = fluree.db.auth.roles.call(null,inst_67827,inst_67856);
var state_67901__$1 = state_67901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67901__$1,(23),inst_67860);
} else {
if((state_val_67902 === (27))){
var inst_67827 = (state_67901[(9)]);
var inst_67875 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_67876 = fluree.db.time_travel.as_of_block.call(null,inst_67827,inst_67875);
var state_67901__$1 = state_67901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67901__$1,(30),inst_67876);
} else {
if((state_val_67902 === (1))){
var state_67901__$1 = state_67901;
var statearr_67904_67964 = state_67901__$1;
(statearr_67904_67964[(2)] = null);

(statearr_67904_67964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (24))){
var inst_67827 = (state_67901[(9)]);
var inst_67868 = (state_67901[(10)]);
var inst_67870 = fluree.db.permissions.permission_map.call(null,inst_67827,inst_67868,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_67901__$1 = state_67901;
var statearr_67905_67965 = state_67901__$1;
(statearr_67905_67965[(2)] = inst_67870);

(statearr_67905_67965[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (4))){
var inst_67815 = (state_67901[(2)]);
var inst_67816 = cljs.core.async.put_BANG_.call(null,pc,inst_67815);
var inst_67817 = cljs.core.async.close_BANG_.call(null,pc);
var state_67901__$1 = (function (){var statearr_67906 = state_67901;
(statearr_67906[(11)] = inst_67816);

return statearr_67906;
})();
var statearr_67907_67966 = state_67901__$1;
(statearr_67907_67966[(2)] = inst_67817);

(statearr_67907_67966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (15))){
var inst_67832 = (state_67901[(7)]);
var inst_67846 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67832)," unknown."].join('');
var inst_67847 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67848 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67849 = cljs.core.PersistentHashMap.fromArrays(inst_67847,inst_67848);
var inst_67850 = cljs.core.ex_info.call(null,inst_67846,inst_67849);
var inst_67851 = (function(){throw inst_67850})();
var state_67901__$1 = state_67901;
var statearr_67908_67967 = state_67901__$1;
(statearr_67908_67967[(2)] = inst_67851);

(statearr_67908_67967[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (21))){
var state_67901__$1 = state_67901;
var statearr_67909_67968 = state_67901__$1;
(statearr_67909_67968[(2)] = null);

(statearr_67909_67968[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (31))){
var inst_67882 = (state_67901[(12)]);
var inst_67832 = (state_67901[(7)]);
var inst_67884 = cljs.core.assoc.call(null,inst_67882,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67832);
var state_67901__$1 = state_67901;
var statearr_67910_67969 = state_67901__$1;
(statearr_67910_67969[(2)] = inst_67884);

(statearr_67910_67969[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (32))){
var inst_67882 = (state_67901[(12)]);
var state_67901__$1 = state_67901;
var statearr_67911_67970 = state_67901__$1;
(statearr_67911_67970[(2)] = inst_67882);

(statearr_67911_67970[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (33))){
var inst_67868 = (state_67901[(10)]);
var inst_67887 = (state_67901[(2)]);
var state_67901__$1 = (function (){var statearr_67912 = state_67901;
(statearr_67912[(13)] = inst_67887);

return statearr_67912;
})();
if(cljs.core.truth_(inst_67868)){
var statearr_67913_67971 = state_67901__$1;
(statearr_67913_67971[(1)] = (34));

} else {
var statearr_67914_67972 = state_67901__$1;
(statearr_67914_67972[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (13))){
var inst_67843 = (state_67901[(14)]);
var inst_67842 = (state_67901[(2)]);
var inst_67843__$1 = fluree.db.util.async.throw_err.call(null,inst_67842);
var state_67901__$1 = (function (){var statearr_67915 = state_67901;
(statearr_67915[(14)] = inst_67843__$1);

return statearr_67915;
})();
if(cljs.core.truth_(inst_67843__$1)){
var statearr_67916_67973 = state_67901__$1;
(statearr_67916_67973[(1)] = (14));

} else {
var statearr_67917_67974 = state_67901__$1;
(statearr_67917_67974[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (22))){
var inst_67866 = (state_67901[(2)]);
var state_67901__$1 = state_67901;
var statearr_67918_67975 = state_67901__$1;
(statearr_67918_67975[(2)] = inst_67866);

(statearr_67918_67975[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (36))){
var inst_67895 = (state_67901[(2)]);
var inst_67896 = cljs.core.async.put_BANG_.call(null,pc,inst_67895);
var _ = (function (){var statearr_67919 = state_67901;
(statearr_67919[(4)] = cljs.core.rest.call(null,(state_67901[(4)])));

return statearr_67919;
})();
var state_67901__$1 = state_67901;
var statearr_67920_67976 = state_67901__$1;
(statearr_67920_67976[(2)] = inst_67896);

(statearr_67920_67976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (29))){
var inst_67832 = (state_67901[(7)]);
var inst_67882 = (state_67901[(2)]);
var state_67901__$1 = (function (){var statearr_67921 = state_67901;
(statearr_67921[(12)] = inst_67882);

return statearr_67921;
})();
if(cljs.core.truth_(inst_67832)){
var statearr_67922_67977 = state_67901__$1;
(statearr_67922_67977[(1)] = (31));

} else {
var statearr_67923_67978 = state_67901__$1;
(statearr_67923_67978[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (6))){
var inst_67832 = (state_67901[(7)]);
var inst_67826 = (state_67901[(2)]);
var inst_67827 = fluree.db.util.async.throw_err.call(null,inst_67826);
var inst_67828 = opts;
var inst_67829 = cljs.core.__destructure_map.call(null,inst_67828);
var inst_67830 = cljs.core.get.call(null,inst_67829,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_67831 = cljs.core.get.call(null,inst_67829,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_67832__$1 = cljs.core.get.call(null,inst_67829,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_67833 = cljs.core.get.call(null,inst_67829,new cljs.core.Keyword(null,"block","block",664686210));
var state_67901__$1 = (function (){var statearr_67924 = state_67901;
(statearr_67924[(15)] = inst_67833);

(statearr_67924[(16)] = inst_67831);

(statearr_67924[(9)] = inst_67827);

(statearr_67924[(17)] = inst_67830);

(statearr_67924[(7)] = inst_67832__$1);

return statearr_67924;
})();
if(cljs.core.truth_(inst_67832__$1)){
var statearr_67925_67979 = state_67901__$1;
(statearr_67925_67979[(1)] = (7));

} else {
var statearr_67926_67980 = state_67901__$1;
(statearr_67926_67980[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (28))){
var inst_67827 = (state_67901[(9)]);
var state_67901__$1 = state_67901;
var statearr_67927_67981 = state_67901__$1;
(statearr_67927_67981[(2)] = inst_67827);

(statearr_67927_67981[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (25))){
var state_67901__$1 = state_67901;
var statearr_67928_67982 = state_67901__$1;
(statearr_67928_67982[(2)] = null);

(statearr_67928_67982[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (34))){
var inst_67873 = (state_67901[(18)]);
var state_67901__$1 = state_67901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67901__$1,(37),inst_67873);
} else {
if((state_val_67902 === (17))){
var inst_67830 = (state_67901[(17)]);
var state_67901__$1 = state_67901;
var statearr_67929_67983 = state_67901__$1;
(statearr_67929_67983[(2)] = inst_67830);

(statearr_67929_67983[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (3))){
var inst_67899 = (state_67901[(2)]);
var state_67901__$1 = state_67901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67901__$1,inst_67899);
} else {
if((state_val_67902 === (12))){
var inst_67830 = (state_67901[(17)]);
var inst_67856 = (state_67901[(2)]);
var state_67901__$1 = (function (){var statearr_67930 = state_67901;
(statearr_67930[(8)] = inst_67856);

return statearr_67930;
})();
if(cljs.core.truth_(inst_67830)){
var statearr_67931_67984 = state_67901__$1;
(statearr_67931_67984[(1)] = (17));

} else {
var statearr_67932_67985 = state_67901__$1;
(statearr_67932_67985[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (2))){
var _ = (function (){var statearr_67933 = state_67901;
(statearr_67933[(4)] = cljs.core.cons.call(null,(5),(state_67901[(4)])));

return statearr_67933;
})();
var inst_67824 = fluree.db.session.db.call(null,conn,ledger,null);
var state_67901__$1 = state_67901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67901__$1,(6),inst_67824);
} else {
if((state_val_67902 === (23))){
var inst_67862 = (state_67901[(2)]);
var inst_67863 = fluree.db.util.async.throw_err.call(null,inst_67862);
var state_67901__$1 = state_67901;
var statearr_67934_67986 = state_67901__$1;
(statearr_67934_67986[(2)] = inst_67863);

(statearr_67934_67986[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (35))){
var inst_67887 = (state_67901[(13)]);
var state_67901__$1 = state_67901;
var statearr_67935_67987 = state_67901__$1;
(statearr_67935_67987[(2)] = inst_67887);

(statearr_67935_67987[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (19))){
var inst_67868 = (state_67901[(10)]);
var inst_67868__$1 = (state_67901[(2)]);
var state_67901__$1 = (function (){var statearr_67936 = state_67901;
(statearr_67936[(10)] = inst_67868__$1);

return statearr_67936;
})();
if(cljs.core.truth_(inst_67868__$1)){
var statearr_67937_67988 = state_67901__$1;
(statearr_67937_67988[(1)] = (24));

} else {
var statearr_67938_67989 = state_67901__$1;
(statearr_67938_67989[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (11))){
var state_67901__$1 = state_67901;
var statearr_67940_67990 = state_67901__$1;
(statearr_67940_67990[(2)] = null);

(statearr_67940_67990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (9))){
var inst_67838 = (state_67901[(2)]);
var state_67901__$1 = state_67901;
if(cljs.core.truth_(inst_67838)){
var statearr_67941_67991 = state_67901__$1;
(statearr_67941_67991[(1)] = (10));

} else {
var statearr_67942_67992 = state_67901__$1;
(statearr_67942_67992[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (5))){
var _ = (function (){var statearr_67943 = state_67901;
(statearr_67943[(4)] = cljs.core.rest.call(null,(state_67901[(4)])));

return statearr_67943;
})();
var state_67901__$1 = state_67901;
var ex67939 = (state_67901__$1[(2)]);
var statearr_67944_67993 = state_67901__$1;
(statearr_67944_67993[(5)] = ex67939);


var statearr_67945_67994 = state_67901__$1;
(statearr_67945_67994[(1)] = (4));

(statearr_67945_67994[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (14))){
var inst_67843 = (state_67901[(14)]);
var state_67901__$1 = state_67901;
var statearr_67946_67995 = state_67901__$1;
(statearr_67946_67995[(2)] = inst_67843);

(statearr_67946_67995[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (26))){
var inst_67833 = (state_67901[(15)]);
var inst_67873 = (state_67901[(2)]);
var state_67901__$1 = (function (){var statearr_67947 = state_67901;
(statearr_67947[(18)] = inst_67873);

return statearr_67947;
})();
if(cljs.core.truth_(inst_67833)){
var statearr_67948_67996 = state_67901__$1;
(statearr_67948_67996[(1)] = (27));

} else {
var statearr_67949_67997 = state_67901__$1;
(statearr_67949_67997[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (16))){
var inst_67853 = (state_67901[(2)]);
var state_67901__$1 = state_67901;
var statearr_67950_67998 = state_67901__$1;
(statearr_67950_67998[(2)] = inst_67853);

(statearr_67950_67998[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (30))){
var inst_67878 = (state_67901[(2)]);
var inst_67879 = fluree.db.util.async.throw_err.call(null,inst_67878);
var state_67901__$1 = state_67901;
var statearr_67951_67999 = state_67901__$1;
(statearr_67951_67999[(2)] = inst_67879);

(statearr_67951_67999[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (10))){
var inst_67827 = (state_67901[(9)]);
var inst_67832 = (state_67901[(7)]);
var inst_67840 = fluree.db.dbproto._subid.call(null,inst_67827,inst_67832);
var state_67901__$1 = state_67901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67901__$1,(13),inst_67840);
} else {
if((state_val_67902 === (18))){
var inst_67856 = (state_67901[(8)]);
var state_67901__$1 = state_67901;
if(cljs.core.truth_(inst_67856)){
var statearr_67952_68000 = state_67901__$1;
(statearr_67952_68000[(1)] = (20));

} else {
var statearr_67953_68001 = state_67901__$1;
(statearr_67953_68001[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (37))){
var inst_67887 = (state_67901[(13)]);
var inst_67890 = (state_67901[(2)]);
var inst_67891 = fluree.db.util.async.throw_err.call(null,inst_67890);
var inst_67892 = cljs.core.assoc.call(null,inst_67887,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_67891);
var state_67901__$1 = state_67901;
var statearr_67954_68002 = state_67901__$1;
(statearr_67954_68002[(2)] = inst_67892);

(statearr_67954_68002[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67902 === (8))){
var inst_67832 = (state_67901[(7)]);
var state_67901__$1 = state_67901;
var statearr_67955_68003 = state_67901__$1;
(statearr_67955_68003[(2)] = inst_67832);

(statearr_67955_68003[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_67956 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67956[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_67956[(1)] = (1));

return statearr_67956;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_67901){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67957){var ex__2749__auto__ = e67957;
var statearr_67958_68004 = state_67901;
(statearr_67958_68004[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67901[(4)]))){
var statearr_67959_68005 = state_67901;
(statearr_67959_68005[(1)] = cljs.core.first.call(null,(state_67901[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68006 = state_67901;
state_67901 = G__68006;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_67901){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_67901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67960 = f__2769__auto__.call(null);
(statearr_67960[(6)] = c__2768__auto___67962);

return statearr_67960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68147){
var state_val_68148 = (state_68147[(1)]);
if((state_val_68148 === (7))){
var inst_68027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68028 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68029 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68030 = [inst_68028,inst_68029];
var inst_68031 = (new cljs.core.PersistentVector(null,2,(5),inst_68027,inst_68030,null));
var state_68147__$1 = state_68147;
var statearr_68149_68219 = state_68147__$1;
(statearr_68149_68219[(2)] = inst_68031);

(statearr_68149_68219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (20))){
var inst_68057 = (state_68147[(7)]);
var state_68147__$1 = state_68147;
var statearr_68150_68220 = state_68147__$1;
(statearr_68150_68220[(2)] = inst_68057);

(statearr_68150_68220[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (27))){
var state_68147__$1 = state_68147;
var statearr_68151_68221 = state_68147__$1;
(statearr_68151_68221[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (1))){
var state_68147__$1 = state_68147;
var statearr_68153_68222 = state_68147__$1;
(statearr_68153_68222[(2)] = null);

(statearr_68153_68222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (24))){
var inst_68056 = (state_68147[(8)]);
var state_68147__$1 = state_68147;
if(cljs.core.truth_(inst_68056)){
var statearr_68154_68223 = state_68147__$1;
(statearr_68154_68223[(1)] = (26));

} else {
var statearr_68155_68224 = state_68147__$1;
(statearr_68155_68224[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (39))){
var inst_68102 = (state_68147[(9)]);
var inst_68103 = (state_68147[(10)]);
var inst_68128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68129 = [inst_68102,inst_68103];
var inst_68130 = (new cljs.core.PersistentVector(null,2,(5),inst_68128,inst_68129,null));
var state_68147__$1 = state_68147;
var statearr_68156_68225 = state_68147__$1;
(statearr_68156_68225[(2)] = inst_68130);

(statearr_68156_68225[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (4))){
var inst_68007 = (state_68147[(2)]);
var state_68147__$1 = state_68147;
var statearr_68157_68226 = state_68147__$1;
(statearr_68157_68226[(2)] = inst_68007);

(statearr_68157_68226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (15))){
var inst_68041 = (state_68147[(11)]);
var inst_68036 = (state_68147[(12)]);
var inst_68050 = (state_68147[(2)]);
var inst_68051 = [inst_68041,inst_68050];
var inst_68052 = (new cljs.core.PersistentVector(null,2,(5),inst_68036,inst_68051,null));
var state_68147__$1 = state_68147;
var statearr_68158_68227 = state_68147__$1;
(statearr_68158_68227[(2)] = inst_68052);

(statearr_68158_68227[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (21))){
var inst_68056 = (state_68147[(8)]);
var state_68147__$1 = state_68147;
var statearr_68159_68228 = state_68147__$1;
(statearr_68159_68228[(2)] = inst_68056);

(statearr_68159_68228[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (31))){
var inst_68097 = (state_68147[(2)]);
var state_68147__$1 = state_68147;
var statearr_68160_68229 = state_68147__$1;
(statearr_68160_68229[(2)] = inst_68097);

(statearr_68160_68229[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (32))){
var inst_68103 = (state_68147[(10)]);
var inst_68106 = cljs.core.pos_int_QMARK_.call(null,inst_68103);
var state_68147__$1 = state_68147;
var statearr_68161_68230 = state_68147__$1;
(statearr_68161_68230[(2)] = inst_68106);

(statearr_68161_68230[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (40))){
var inst_68058 = (state_68147[(13)]);
var inst_68134 = (state_68147[(14)]);
var inst_68132 = (state_68147[(2)]);
var inst_68133 = cljs.core.nth.call(null,inst_68132,(0),null);
var inst_68134__$1 = cljs.core.nth.call(null,inst_68132,(1),null);
var inst_68135 = (inst_68134__$1 > inst_68058);
var state_68147__$1 = (function (){var statearr_68162 = state_68147;
(statearr_68162[(14)] = inst_68134__$1);

(statearr_68162[(15)] = inst_68133);

return statearr_68162;
})();
if(cljs.core.truth_(inst_68135)){
var statearr_68163_68231 = state_68147__$1;
(statearr_68163_68231[(1)] = (41));

} else {
var statearr_68164_68232 = state_68147__$1;
(statearr_68164_68232[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (33))){
var inst_68104 = (state_68147[(16)]);
var state_68147__$1 = state_68147;
var statearr_68165_68233 = state_68147__$1;
(statearr_68165_68233[(2)] = inst_68104);

(statearr_68165_68233[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (13))){
var inst_68042 = (state_68147[(17)]);
var inst_68044 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_68042);
var state_68147__$1 = state_68147;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68147__$1,(16),inst_68044);
} else {
if((state_val_68148 === (22))){
var inst_68075 = (state_68147[(2)]);
var state_68147__$1 = state_68147;
if(cljs.core.truth_(inst_68075)){
var statearr_68166_68234 = state_68147__$1;
(statearr_68166_68234[(1)] = (23));

} else {
var statearr_68167_68235 = state_68147__$1;
(statearr_68167_68235[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (36))){
var state_68147__$1 = state_68147;
var statearr_68168_68236 = state_68147__$1;
(statearr_68168_68236[(2)] = null);

(statearr_68168_68236[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (41))){
var inst_68058 = (state_68147[(13)]);
var state_68147__$1 = state_68147;
var statearr_68169_68237 = state_68147__$1;
(statearr_68169_68237[(2)] = inst_68058);

(statearr_68169_68237[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (43))){
var inst_68133 = (state_68147[(15)]);
var inst_68139 = (state_68147[(2)]);
var inst_68140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68141 = [inst_68133,inst_68139];
var inst_68142 = (new cljs.core.PersistentVector(null,2,(5),inst_68140,inst_68141,null));
var _ = (function (){var statearr_68170 = state_68147;
(statearr_68170[(4)] = cljs.core.rest.call(null,(state_68147[(4)])));

return statearr_68170;
})();
var state_68147__$1 = state_68147;
var statearr_68171_68238 = state_68147__$1;
(statearr_68171_68238[(2)] = inst_68142);

(statearr_68171_68238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (29))){
var inst_68033 = (state_68147[(18)]);
var inst_68088 = cljs.core.pr_str.call(null,inst_68033);
var inst_68089 = ["Invalid block range provided: ",inst_68088].join('');
var inst_68090 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68091 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68092 = cljs.core.PersistentHashMap.fromArrays(inst_68090,inst_68091);
var inst_68093 = cljs.core.ex_info.call(null,inst_68089,inst_68092);
var inst_68094 = (function(){throw inst_68093})();
var state_68147__$1 = state_68147;
var statearr_68172_68239 = state_68147__$1;
(statearr_68172_68239[(2)] = inst_68094);

(statearr_68172_68239[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (6))){
var inst_68025 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_68147__$1 = state_68147;
var statearr_68173_68240 = state_68147__$1;
(statearr_68173_68240[(2)] = inst_68025);

(statearr_68173_68240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (28))){
var inst_68099 = (state_68147[(2)]);
var state_68147__$1 = state_68147;
var statearr_68174_68241 = state_68147__$1;
(statearr_68174_68241[(2)] = inst_68099);

(statearr_68174_68241[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (25))){
var inst_68102 = (state_68147[(9)]);
var inst_68104 = (state_68147[(16)]);
var inst_68101 = (state_68147[(2)]);
var inst_68102__$1 = cljs.core.nth.call(null,inst_68101,(0),null);
var inst_68103 = cljs.core.nth.call(null,inst_68101,(1),null);
var inst_68104__$1 = cljs.core.pos_int_QMARK_.call(null,inst_68102__$1);
var state_68147__$1 = (function (){var statearr_68175 = state_68147;
(statearr_68175[(9)] = inst_68102__$1);

(statearr_68175[(10)] = inst_68103);

(statearr_68175[(16)] = inst_68104__$1);

return statearr_68175;
})();
if(inst_68104__$1){
var statearr_68176_68242 = state_68147__$1;
(statearr_68176_68242[(1)] = (32));

} else {
var statearr_68177_68243 = state_68147__$1;
(statearr_68177_68243[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (34))){
var inst_68109 = (state_68147[(2)]);
var inst_68110 = cljs.core.not.call(null,inst_68109);
var state_68147__$1 = state_68147;
if(inst_68110){
var statearr_68178_68244 = state_68147__$1;
(statearr_68178_68244[(1)] = (35));

} else {
var statearr_68179_68245 = state_68147__$1;
(statearr_68179_68245[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (17))){
var inst_68058 = (state_68147[(13)]);
var inst_68056 = (state_68147[(8)]);
var inst_68061 = cljs.core.pr_str.call(null,inst_68056);
var inst_68062 = cljs.core.pr_str.call(null,inst_68058);
var inst_68063 = ["Start block is out of range for this ledger. Start block provided: ",inst_68061,". Database block: ",inst_68062].join('');
var inst_68064 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68065 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68066 = cljs.core.PersistentHashMap.fromArrays(inst_68064,inst_68065);
var inst_68067 = cljs.core.ex_info.call(null,inst_68063,inst_68066);
var inst_68068 = (function(){throw inst_68067})();
var state_68147__$1 = state_68147;
var statearr_68180_68246 = state_68147__$1;
(statearr_68180_68246[(2)] = inst_68068);

(statearr_68180_68246[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (3))){
var inst_68145 = (state_68147[(2)]);
var state_68147__$1 = state_68147;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68147__$1,inst_68145);
} else {
if((state_val_68148 === (12))){
var inst_68033 = (state_68147[(18)]);
var inst_68042 = (state_68147[(17)]);
var inst_68040 = (state_68147[(2)]);
var inst_68041 = fluree.db.util.async.throw_err.call(null,inst_68040);
var inst_68042__$1 = cljs.core.second.call(null,inst_68033);
var state_68147__$1 = (function (){var statearr_68181 = state_68147;
(statearr_68181[(17)] = inst_68042__$1);

(statearr_68181[(11)] = inst_68041);

return statearr_68181;
})();
if(cljs.core.truth_(inst_68042__$1)){
var statearr_68182_68247 = state_68147__$1;
(statearr_68182_68247[(1)] = (13));

} else {
var statearr_68183_68248 = state_68147__$1;
(statearr_68183_68248[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (2))){
var _ = (function (){var statearr_68184 = state_68147;
(statearr_68184[(4)] = cljs.core.cons.call(null,(5),(state_68147[(4)])));

return statearr_68184;
})();
var inst_68022 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68023 = cljs.core.sequential_QMARK_.call(null,inst_68022);
var state_68147__$1 = state_68147;
if(inst_68023){
var statearr_68185_68249 = state_68147__$1;
(statearr_68185_68249[(1)] = (6));

} else {
var statearr_68186_68250 = state_68147__$1;
(statearr_68186_68250[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (23))){
var inst_68057 = (state_68147[(7)]);
var inst_68056 = (state_68147[(8)]);
var inst_68077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68078 = [inst_68056,inst_68057];
var inst_68079 = (new cljs.core.PersistentVector(null,2,(5),inst_68077,inst_68078,null));
var state_68147__$1 = state_68147;
var statearr_68187_68251 = state_68147__$1;
(statearr_68187_68251[(2)] = inst_68079);

(statearr_68187_68251[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (35))){
var inst_68033 = (state_68147[(18)]);
var inst_68112 = cljs.core.pr_str.call(null,inst_68033);
var inst_68113 = ["Invalid block range provided: ",inst_68112].join('');
var inst_68114 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68115 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68116 = cljs.core.PersistentHashMap.fromArrays(inst_68114,inst_68115);
var inst_68117 = cljs.core.ex_info.call(null,inst_68113,inst_68116);
var inst_68118 = (function(){throw inst_68117})();
var state_68147__$1 = state_68147;
var statearr_68188_68252 = state_68147__$1;
(statearr_68188_68252[(2)] = inst_68118);

(statearr_68188_68252[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (19))){
var inst_68056 = (state_68147[(8)]);
var inst_68071 = (state_68147[(2)]);
var state_68147__$1 = (function (){var statearr_68189 = state_68147;
(statearr_68189[(19)] = inst_68071);

return statearr_68189;
})();
if(cljs.core.truth_(inst_68056)){
var statearr_68190_68253 = state_68147__$1;
(statearr_68190_68253[(1)] = (20));

} else {
var statearr_68191_68254 = state_68147__$1;
(statearr_68191_68254[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (11))){
var inst_68058 = (state_68147[(13)]);
var inst_68056 = (state_68147[(8)]);
var inst_68055 = (state_68147[(2)]);
var inst_68056__$1 = cljs.core.nth.call(null,inst_68055,(0),null);
var inst_68057 = cljs.core.nth.call(null,inst_68055,(1),null);
var inst_68058__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_68059 = (inst_68056__$1 > inst_68058__$1);
var state_68147__$1 = (function (){var statearr_68193 = state_68147;
(statearr_68193[(13)] = inst_68058__$1);

(statearr_68193[(7)] = inst_68057);

(statearr_68193[(8)] = inst_68056__$1);

return statearr_68193;
})();
if(cljs.core.truth_(inst_68059)){
var statearr_68194_68255 = state_68147__$1;
(statearr_68194_68255[(1)] = (17));

} else {
var statearr_68195_68256 = state_68147__$1;
(statearr_68195_68256[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (9))){
var inst_68033 = (state_68147[(18)]);
var inst_68036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68037 = cljs.core.first.call(null,inst_68033);
var inst_68038 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_68037);
var state_68147__$1 = (function (){var statearr_68196 = state_68147;
(statearr_68196[(12)] = inst_68036);

return statearr_68196;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68147__$1,(12),inst_68038);
} else {
if((state_val_68148 === (5))){
var _ = (function (){var statearr_68197 = state_68147;
(statearr_68197[(4)] = cljs.core.rest.call(null,(state_68147[(4)])));

return statearr_68197;
})();
var state_68147__$1 = state_68147;
var ex68192 = (state_68147__$1[(2)]);
var statearr_68198_68257 = state_68147__$1;
(statearr_68198_68257[(5)] = ex68192);


if((ex68192 instanceof Error)){
var statearr_68199_68258 = state_68147__$1;
(statearr_68199_68258[(1)] = (4));

(statearr_68199_68258[(5)] = null);

} else {
throw ex68192;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (14))){
var state_68147__$1 = state_68147;
var statearr_68200_68259 = state_68147__$1;
(statearr_68200_68259[(2)] = null);

(statearr_68200_68259[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (26))){
var inst_68056 = (state_68147[(8)]);
var inst_68082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68083 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_68084 = [inst_68056,inst_68083];
var inst_68085 = (new cljs.core.PersistentVector(null,2,(5),inst_68082,inst_68084,null));
var state_68147__$1 = state_68147;
var statearr_68201_68260 = state_68147__$1;
(statearr_68201_68260[(2)] = inst_68085);

(statearr_68201_68260[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (16))){
var inst_68046 = (state_68147[(2)]);
var inst_68047 = fluree.db.util.async.throw_err.call(null,inst_68046);
var state_68147__$1 = state_68147;
var statearr_68202_68261 = state_68147__$1;
(statearr_68202_68261[(2)] = inst_68047);

(statearr_68202_68261[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (38))){
var inst_68102 = (state_68147[(9)]);
var inst_68103 = (state_68147[(10)]);
var inst_68124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68125 = [inst_68103,inst_68102];
var inst_68126 = (new cljs.core.PersistentVector(null,2,(5),inst_68124,inst_68125,null));
var state_68147__$1 = state_68147;
var statearr_68203_68262 = state_68147__$1;
(statearr_68203_68262[(2)] = inst_68126);

(statearr_68203_68262[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (30))){
var state_68147__$1 = state_68147;
var statearr_68204_68263 = state_68147__$1;
(statearr_68204_68263[(2)] = null);

(statearr_68204_68263[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (10))){
var inst_68033 = (state_68147[(18)]);
var state_68147__$1 = state_68147;
var statearr_68205_68264 = state_68147__$1;
(statearr_68205_68264[(2)] = inst_68033);

(statearr_68205_68264[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (18))){
var state_68147__$1 = state_68147;
var statearr_68206_68265 = state_68147__$1;
(statearr_68206_68265[(2)] = null);

(statearr_68206_68265[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (42))){
var inst_68134 = (state_68147[(14)]);
var state_68147__$1 = state_68147;
var statearr_68207_68266 = state_68147__$1;
(statearr_68207_68266[(2)] = inst_68134);

(statearr_68207_68266[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (37))){
var inst_68102 = (state_68147[(9)]);
var inst_68103 = (state_68147[(10)]);
var inst_68121 = (state_68147[(2)]);
var inst_68122 = (inst_68103 < inst_68102);
var state_68147__$1 = (function (){var statearr_68208 = state_68147;
(statearr_68208[(20)] = inst_68121);

return statearr_68208;
})();
if(cljs.core.truth_(inst_68122)){
var statearr_68209_68267 = state_68147__$1;
(statearr_68209_68267[(1)] = (38));

} else {
var statearr_68210_68268 = state_68147__$1;
(statearr_68210_68268[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68148 === (8))){
var inst_68033 = (state_68147[(18)]);
var inst_68033__$1 = (state_68147[(2)]);
var inst_68034 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_68033__$1);
var state_68147__$1 = (function (){var statearr_68211 = state_68147;
(statearr_68211[(18)] = inst_68033__$1);

return statearr_68211;
})();
if(cljs.core.truth_(inst_68034)){
var statearr_68212_68269 = state_68147__$1;
(statearr_68212_68269[(1)] = (9));

} else {
var statearr_68213_68270 = state_68147__$1;
(statearr_68213_68270[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_68214 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68214[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_68214[(1)] = (1));

return statearr_68214;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_68147){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68147);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68215){var ex__2749__auto__ = e68215;
var statearr_68216_68271 = state_68147;
(statearr_68216_68271[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68147[(4)]))){
var statearr_68217_68272 = state_68147;
(statearr_68217_68272[(1)] = cljs.core.first.call(null,(state_68147[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68273 = state_68147;
state_68147 = G__68273;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_68147){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_68147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68218 = f__2769__auto__.call(null);
(statearr_68218[(6)] = c__2768__auto__);

return statearr_68218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68423){
var state_val_68424 = (state_68423[(1)]);
if((state_val_68424 === (7))){
var inst_68335 = (state_68423[(2)]);
var inst_68336 = cljs.core.nth.call(null,inst_68335,(0),null);
var inst_68337 = cljs.core.nth.call(null,inst_68335,(1),null);
var inst_68345 = cljs.core.vals.call(null,inst_68337);
var inst_68346 = cljs.core.seq.call(null,inst_68345);
var inst_68347 = cljs.core.first.call(null,inst_68346);
var inst_68348 = cljs.core.next.call(null,inst_68346);
var inst_68349 = cljs.core.PersistentVector.EMPTY;
var inst_68350 = inst_68345;
var inst_68351 = inst_68349;
var state_68423__$1 = (function (){var statearr_68425 = state_68423;
(statearr_68425[(7)] = inst_68347);

(statearr_68425[(8)] = inst_68336);

(statearr_68425[(9)] = inst_68348);

(statearr_68425[(10)] = inst_68351);

(statearr_68425[(11)] = inst_68350);

return statearr_68425;
})();
var statearr_68426_68479 = state_68423__$1;
(statearr_68426_68479[(2)] = null);

(statearr_68426_68479[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (20))){
var inst_68357 = (state_68423[(12)]);
var inst_68362 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_68363 = cljs.core.PersistentHashMap.EMPTY;
var inst_68364 = [true,inst_68363];
var inst_68365 = cljs.core.PersistentHashMap.fromArrays(inst_68362,inst_68364);
var inst_68366 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_68365,inst_68357);
var state_68423__$1 = state_68423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68423__$1,(22),inst_68366);
} else {
if((state_val_68424 === (27))){
var inst_68411 = (state_68423[(2)]);
var state_68423__$1 = state_68423;
var statearr_68427_68480 = state_68423__$1;
(statearr_68427_68480[(2)] = inst_68411);

(statearr_68427_68480[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (1))){
var state_68423__$1 = state_68423;
var statearr_68428_68481 = state_68423__$1;
(statearr_68428_68481[(2)] = null);

(statearr_68428_68481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (24))){
var inst_68375 = (state_68423[(13)]);
var inst_68413 = (state_68423[(2)]);
var inst_68414 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_68415 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_68416 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_68417 = [inst_68415,inst_68416,inst_68375,inst_68413];
var inst_68418 = cljs.core.PersistentHashMap.fromArrays(inst_68414,inst_68417);
var _ = (function (){var statearr_68430 = state_68423;
(statearr_68430[(4)] = cljs.core.rest.call(null,(state_68423[(4)])));

return statearr_68430;
})();
var state_68423__$1 = state_68423;
var statearr_68431_68482 = state_68423__$1;
(statearr_68431_68482[(2)] = inst_68418);

(statearr_68431_68482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (4))){
var inst_68276 = (state_68423[(2)]);
var state_68423__$1 = state_68423;
var statearr_68432_68483 = state_68423__$1;
(statearr_68432_68483[(2)] = inst_68276);

(statearr_68432_68483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (15))){
var inst_68321 = (state_68423[(14)]);
var inst_68314 = (state_68423[(15)]);
var inst_68316 = (state_68423[(16)]);
var inst_68306 = (state_68423[(17)]);
var inst_68299 = (state_68423[(18)]);
var inst_68307 = (state_68423[(19)]);
var inst_68294 = (state_68423[(20)]);
var inst_68298 = (state_68423[(21)]);
var inst_68300 = (state_68423[(22)]);
var inst_68292 = (state_68423[(23)]);
var inst_68295 = (state_68423[(24)]);
var inst_68327 = (function (){var vec__68302 = inst_68298;
var subject = inst_68314;
var flake = inst_68306;
var G__68288 = inst_68298;
var r = inst_68307;
var asserted_subjects = inst_68299;
var flake_SINGLEQUOTE_ = inst_68321;
var retracted_subjects = inst_68300;
var first__68291 = inst_68294;
var seq__68303 = inst_68307;
var first__68304 = inst_68306;
var seq__68290 = inst_68295;
var asserted_QMARK_ = inst_68316;
var vec__68289 = inst_68292;
return (function (p1__68275_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__68275_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_68328 = cljs.core.update.call(null,inst_68300,inst_68314,inst_68327);
var tmp68429 = inst_68299;
var inst_68298__$1 = inst_68307;
var inst_68299__$1 = tmp68429;
var inst_68300__$1 = inst_68328;
var state_68423__$1 = (function (){var statearr_68433 = state_68423;
(statearr_68433[(18)] = inst_68299__$1);

(statearr_68433[(21)] = inst_68298__$1);

(statearr_68433[(22)] = inst_68300__$1);

return statearr_68433;
})();
var statearr_68434_68484 = state_68423__$1;
(statearr_68434_68484[(2)] = null);

(statearr_68434_68484[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (21))){
var inst_68373 = (state_68423[(2)]);
var state_68423__$1 = state_68423;
var statearr_68435_68485 = state_68423__$1;
(statearr_68435_68485[(2)] = inst_68373);

(statearr_68435_68485[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (13))){
var inst_68316 = (state_68423[(16)]);
var inst_68321 = (state_68423[(2)]);
var state_68423__$1 = (function (){var statearr_68436 = state_68423;
(statearr_68436[(14)] = inst_68321);

return statearr_68436;
})();
if(cljs.core.truth_(inst_68316)){
var statearr_68437_68486 = state_68423__$1;
(statearr_68437_68486[(1)] = (14));

} else {
var statearr_68438_68487 = state_68423__$1;
(statearr_68438_68487[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (22))){
var inst_68358 = (state_68423[(25)]);
var inst_68351 = (state_68423[(10)]);
var inst_68368 = (state_68423[(2)]);
var inst_68369 = fluree.db.util.async.throw_err.call(null,inst_68368);
var inst_68370 = cljs.core.conj.call(null,inst_68351,inst_68369);
var inst_68350 = inst_68358;
var inst_68351__$1 = inst_68370;
var state_68423__$1 = (function (){var statearr_68439 = state_68423;
(statearr_68439[(10)] = inst_68351__$1);

(statearr_68439[(11)] = inst_68350);

return statearr_68439;
})();
var statearr_68440_68488 = state_68423__$1;
(statearr_68440_68488[(2)] = null);

(statearr_68440_68488[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (6))){
var inst_68306 = (state_68423[(17)]);
var inst_68298 = (state_68423[(21)]);
var inst_68305 = cljs.core.seq.call(null,inst_68298);
var inst_68306__$1 = cljs.core.first.call(null,inst_68305);
var inst_68307 = cljs.core.next.call(null,inst_68305);
var inst_68308 = cljs.core.not.call(null,inst_68306__$1);
var state_68423__$1 = (function (){var statearr_68441 = state_68423;
(statearr_68441[(17)] = inst_68306__$1);

(statearr_68441[(19)] = inst_68307);

return statearr_68441;
})();
if(inst_68308){
var statearr_68442_68489 = state_68423__$1;
(statearr_68442_68489[(1)] = (8));

} else {
var statearr_68443_68490 = state_68423__$1;
(statearr_68443_68490[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (28))){
var inst_68396 = (state_68423[(26)]);
var inst_68389 = (state_68423[(27)]);
var inst_68406 = (state_68423[(2)]);
var inst_68407 = fluree.db.util.async.throw_err.call(null,inst_68406);
var inst_68408 = cljs.core.conj.call(null,inst_68389,inst_68407);
var inst_68388 = inst_68396;
var inst_68389__$1 = inst_68408;
var state_68423__$1 = (function (){var statearr_68444 = state_68423;
(statearr_68444[(28)] = inst_68388);

(statearr_68444[(27)] = inst_68389__$1);

return statearr_68444;
})();
var statearr_68445_68491 = state_68423__$1;
(statearr_68445_68491[(2)] = null);

(statearr_68445_68491[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (25))){
var inst_68389 = (state_68423[(27)]);
var state_68423__$1 = state_68423;
var statearr_68446_68492 = state_68423__$1;
(statearr_68446_68492[(2)] = inst_68389);

(statearr_68446_68492[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (17))){
var inst_68350 = (state_68423[(11)]);
var inst_68357 = (state_68423[(12)]);
var inst_68356 = cljs.core.seq.call(null,inst_68350);
var inst_68357__$1 = cljs.core.first.call(null,inst_68356);
var inst_68358 = cljs.core.next.call(null,inst_68356);
var inst_68359 = cljs.core.not.call(null,inst_68357__$1);
var state_68423__$1 = (function (){var statearr_68447 = state_68423;
(statearr_68447[(25)] = inst_68358);

(statearr_68447[(12)] = inst_68357__$1);

return statearr_68447;
})();
if(inst_68359){
var statearr_68448_68493 = state_68423__$1;
(statearr_68448_68493[(1)] = (19));

} else {
var statearr_68449_68494 = state_68423__$1;
(statearr_68449_68494[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (3))){
var inst_68421 = (state_68423[(2)]);
var state_68423__$1 = state_68423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68423__$1,inst_68421);
} else {
if((state_val_68424 === (12))){
var inst_68306 = (state_68423[(17)]);
var inst_68319 = fluree.db.flake.flip_flake.call(null,inst_68306);
var state_68423__$1 = state_68423;
var statearr_68450_68495 = state_68423__$1;
(statearr_68450_68495[(2)] = inst_68319);

(statearr_68450_68495[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (2))){
var inst_68292 = (state_68423[(23)]);
var _ = (function (){var statearr_68451 = state_68423;
(statearr_68451[(4)] = cljs.core.cons.call(null,(5),(state_68423[(4)])));

return statearr_68451;
})();
var inst_68292__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_68293 = cljs.core.seq.call(null,inst_68292__$1);
var inst_68294 = cljs.core.first.call(null,inst_68293);
var inst_68295 = cljs.core.next.call(null,inst_68293);
var inst_68296 = cljs.core.PersistentHashMap.EMPTY;
var inst_68297 = cljs.core.PersistentHashMap.EMPTY;
var inst_68298 = inst_68292__$1;
var inst_68299 = inst_68296;
var inst_68300 = inst_68297;
var state_68423__$1 = (function (){var statearr_68452 = state_68423;
(statearr_68452[(18)] = inst_68299);

(statearr_68452[(20)] = inst_68294);

(statearr_68452[(21)] = inst_68298);

(statearr_68452[(22)] = inst_68300);

(statearr_68452[(23)] = inst_68292__$1);

(statearr_68452[(24)] = inst_68295);

return statearr_68452;
})();
var statearr_68453_68496 = state_68423__$1;
(statearr_68453_68496[(2)] = null);

(statearr_68453_68496[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (23))){
var inst_68395 = (state_68423[(29)]);
var inst_68388 = (state_68423[(28)]);
var inst_68394 = cljs.core.seq.call(null,inst_68388);
var inst_68395__$1 = cljs.core.first.call(null,inst_68394);
var inst_68396 = cljs.core.next.call(null,inst_68394);
var inst_68397 = cljs.core.not.call(null,inst_68395__$1);
var state_68423__$1 = (function (){var statearr_68454 = state_68423;
(statearr_68454[(29)] = inst_68395__$1);

(statearr_68454[(26)] = inst_68396);

return statearr_68454;
})();
if(inst_68397){
var statearr_68455_68497 = state_68423__$1;
(statearr_68455_68497[(1)] = (25));

} else {
var statearr_68456_68498 = state_68423__$1;
(statearr_68456_68498[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (19))){
var inst_68351 = (state_68423[(10)]);
var state_68423__$1 = state_68423;
var statearr_68457_68499 = state_68423__$1;
(statearr_68457_68499[(2)] = inst_68351);

(statearr_68457_68499[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (11))){
var inst_68306 = (state_68423[(17)]);
var state_68423__$1 = state_68423;
var statearr_68459_68500 = state_68423__$1;
(statearr_68459_68500[(2)] = inst_68306);

(statearr_68459_68500[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (9))){
var inst_68316 = (state_68423[(16)]);
var inst_68306 = (state_68423[(17)]);
var inst_68314 = fluree.db.flake.s.call(null,inst_68306);
var inst_68315 = fluree.db.flake.op.call(null,inst_68306);
var inst_68316__$1 = inst_68315 === true;
var state_68423__$1 = (function (){var statearr_68461 = state_68423;
(statearr_68461[(15)] = inst_68314);

(statearr_68461[(16)] = inst_68316__$1);

return statearr_68461;
})();
if(cljs.core.truth_(inst_68316__$1)){
var statearr_68462_68501 = state_68423__$1;
(statearr_68462_68501[(1)] = (11));

} else {
var statearr_68463_68502 = state_68423__$1;
(statearr_68463_68502[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (5))){
var _ = (function (){var statearr_68464 = state_68423;
(statearr_68464[(4)] = cljs.core.rest.call(null,(state_68423[(4)])));

return statearr_68464;
})();
var state_68423__$1 = state_68423;
var ex68458 = (state_68423__$1[(2)]);
var statearr_68465_68503 = state_68423__$1;
(statearr_68465_68503[(5)] = ex68458);


if((ex68458 instanceof Error)){
var statearr_68466_68504 = state_68423__$1;
(statearr_68466_68504[(1)] = (4));

(statearr_68466_68504[(5)] = null);

} else {
throw ex68458;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (14))){
var inst_68321 = (state_68423[(14)]);
var inst_68314 = (state_68423[(15)]);
var inst_68316 = (state_68423[(16)]);
var inst_68306 = (state_68423[(17)]);
var inst_68299 = (state_68423[(18)]);
var inst_68307 = (state_68423[(19)]);
var inst_68294 = (state_68423[(20)]);
var inst_68298 = (state_68423[(21)]);
var inst_68300 = (state_68423[(22)]);
var inst_68292 = (state_68423[(23)]);
var inst_68295 = (state_68423[(24)]);
var inst_68323 = (function (){var vec__68302 = inst_68298;
var subject = inst_68314;
var flake = inst_68306;
var G__68288 = inst_68298;
var r = inst_68307;
var asserted_subjects = inst_68299;
var flake_SINGLEQUOTE_ = inst_68321;
var retracted_subjects = inst_68300;
var first__68291 = inst_68294;
var seq__68303 = inst_68307;
var first__68304 = inst_68306;
var seq__68290 = inst_68295;
var asserted_QMARK_ = inst_68316;
var vec__68289 = inst_68292;
return (function (p1__68274_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__68274_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_68324 = cljs.core.update.call(null,inst_68299,inst_68314,inst_68323);
var tmp68460 = inst_68300;
var inst_68298__$1 = inst_68307;
var inst_68299__$1 = inst_68324;
var inst_68300__$1 = tmp68460;
var state_68423__$1 = (function (){var statearr_68467 = state_68423;
(statearr_68467[(18)] = inst_68299__$1);

(statearr_68467[(21)] = inst_68298__$1);

(statearr_68467[(22)] = inst_68300__$1);

return statearr_68467;
})();
var statearr_68468_68505 = state_68423__$1;
(statearr_68468_68505[(2)] = null);

(statearr_68468_68505[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (26))){
var inst_68395 = (state_68423[(29)]);
var inst_68400 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_68401 = cljs.core.PersistentHashMap.EMPTY;
var inst_68402 = [true,inst_68401];
var inst_68403 = cljs.core.PersistentHashMap.fromArrays(inst_68400,inst_68402);
var inst_68404 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_68403,inst_68395);
var state_68423__$1 = state_68423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68423__$1,(28),inst_68404);
} else {
if((state_val_68424 === (16))){
var inst_68331 = (state_68423[(2)]);
var state_68423__$1 = state_68423;
var statearr_68469_68506 = state_68423__$1;
(statearr_68469_68506[(2)] = inst_68331);

(statearr_68469_68506[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (10))){
var inst_68333 = (state_68423[(2)]);
var state_68423__$1 = state_68423;
var statearr_68470_68507 = state_68423__$1;
(statearr_68470_68507[(2)] = inst_68333);

(statearr_68470_68507[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (18))){
var inst_68336 = (state_68423[(8)]);
var inst_68375 = (state_68423[(2)]);
var inst_68383 = cljs.core.vals.call(null,inst_68336);
var inst_68384 = cljs.core.seq.call(null,inst_68383);
var inst_68385 = cljs.core.first.call(null,inst_68384);
var inst_68386 = cljs.core.next.call(null,inst_68384);
var inst_68387 = cljs.core.PersistentVector.EMPTY;
var inst_68388 = inst_68383;
var inst_68389 = inst_68387;
var state_68423__$1 = (function (){var statearr_68471 = state_68423;
(statearr_68471[(28)] = inst_68388);

(statearr_68471[(13)] = inst_68375);

(statearr_68471[(27)] = inst_68389);

(statearr_68471[(30)] = inst_68385);

(statearr_68471[(31)] = inst_68386);

return statearr_68471;
})();
var statearr_68472_68508 = state_68423__$1;
(statearr_68472_68508[(2)] = null);

(statearr_68472_68508[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (8))){
var inst_68299 = (state_68423[(18)]);
var inst_68300 = (state_68423[(22)]);
var inst_68310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68311 = [inst_68299,inst_68300];
var inst_68312 = (new cljs.core.PersistentVector(null,2,(5),inst_68310,inst_68311,null));
var state_68423__$1 = state_68423;
var statearr_68473_68509 = state_68423__$1;
(statearr_68473_68509[(2)] = inst_68312);

(statearr_68473_68509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_68474 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68474[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_68474[(1)] = (1));

return statearr_68474;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_68423){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68475){var ex__2749__auto__ = e68475;
var statearr_68476_68510 = state_68423;
(statearr_68476_68510[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68423[(4)]))){
var statearr_68477_68511 = state_68423;
(statearr_68477_68511[(1)] = cljs.core.first.call(null,(state_68423[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68512 = state_68423;
state_68423 = G__68512;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_68423){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_68423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68478 = f__2769__auto__.call(null);
(statearr_68478[(6)] = c__2768__auto__);

return statearr_68478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68544){
var state_val_68545 = (state_68544[(1)]);
if((state_val_68545 === (1))){
var inst_68513 = cljs.core.volatile_BANG_.call(null,(0));
var inst_68514 = cljs.core.PersistentHashMap.EMPTY;
var inst_68515 = cljs.core.volatile_BANG_.call(null,inst_68514);
var inst_68516 = cljs.core.first.call(null,resp);
var inst_68517 = cljs.core.rest.call(null,resp);
var inst_68518 = cljs.core.PersistentVector.EMPTY;
var inst_68519 = inst_68513;
var inst_68520 = inst_68515;
var inst_68521 = inst_68516;
var inst_68522 = inst_68517;
var inst_68523 = inst_68518;
var state_68544__$1 = (function (){var statearr_68546 = state_68544;
(statearr_68546[(7)] = inst_68523);

(statearr_68546[(8)] = inst_68520);

(statearr_68546[(9)] = inst_68519);

(statearr_68546[(10)] = inst_68521);

(statearr_68546[(11)] = inst_68522);

return statearr_68546;
})();
var statearr_68547_68562 = state_68544__$1;
(statearr_68547_68562[(2)] = null);

(statearr_68547_68562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68545 === (2))){
var inst_68520 = (state_68544[(8)]);
var inst_68519 = (state_68544[(9)]);
var inst_68521 = (state_68544[(10)]);
var inst_68525 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_68521,inst_68520,inst_68519);
var state_68544__$1 = state_68544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68544__$1,(4),inst_68525);
} else {
if((state_val_68545 === (3))){
var inst_68542 = (state_68544[(2)]);
var state_68544__$1 = state_68544;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68544__$1,inst_68542);
} else {
if((state_val_68545 === (4))){
var inst_68523 = (state_68544[(7)]);
var inst_68522 = (state_68544[(11)]);
var inst_68527 = (state_68544[(2)]);
var inst_68528 = fluree.db.util.async.throw_err.call(null,inst_68527);
var inst_68529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68530 = [inst_68528];
var inst_68531 = (new cljs.core.PersistentVector(null,1,(5),inst_68529,inst_68530,null));
var inst_68532 = cljs.core.concat.call(null,inst_68523,inst_68531);
var inst_68533 = cljs.core.first.call(null,inst_68522);
var state_68544__$1 = (function (){var statearr_68550 = state_68544;
(statearr_68550[(12)] = inst_68532);

return statearr_68550;
})();
if(cljs.core.truth_(inst_68533)){
var statearr_68551_68563 = state_68544__$1;
(statearr_68551_68563[(1)] = (5));

} else {
var statearr_68552_68564 = state_68544__$1;
(statearr_68552_68564[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68545 === (5))){
var inst_68520 = (state_68544[(8)]);
var inst_68519 = (state_68544[(9)]);
var inst_68532 = (state_68544[(12)]);
var inst_68522 = (state_68544[(11)]);
var inst_68535 = cljs.core.first.call(null,inst_68522);
var inst_68536 = cljs.core.rest.call(null,inst_68522);
var tmp68548 = inst_68520;
var tmp68549 = inst_68519;
var inst_68519__$1 = tmp68549;
var inst_68520__$1 = tmp68548;
var inst_68521 = inst_68535;
var inst_68522__$1 = inst_68536;
var inst_68523 = inst_68532;
var state_68544__$1 = (function (){var statearr_68553 = state_68544;
(statearr_68553[(7)] = inst_68523);

(statearr_68553[(8)] = inst_68520__$1);

(statearr_68553[(9)] = inst_68519__$1);

(statearr_68553[(10)] = inst_68521);

(statearr_68553[(11)] = inst_68522__$1);

return statearr_68553;
})();
var statearr_68554_68565 = state_68544__$1;
(statearr_68554_68565[(2)] = null);

(statearr_68554_68565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68545 === (6))){
var inst_68532 = (state_68544[(12)]);
var state_68544__$1 = state_68544;
var statearr_68555_68566 = state_68544__$1;
(statearr_68555_68566[(2)] = inst_68532);

(statearr_68555_68566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68545 === (7))){
var inst_68540 = (state_68544[(2)]);
var state_68544__$1 = state_68544;
var statearr_68556_68567 = state_68544__$1;
(statearr_68556_68567[(2)] = inst_68540);

(statearr_68556_68567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_68557 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68557[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_68557[(1)] = (1));

return statearr_68557;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_68544){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68544);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68558){var ex__2749__auto__ = e68558;
var statearr_68559_68568 = state_68544;
(statearr_68559_68568[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68544[(4)]))){
var statearr_68560_68569 = state_68544;
(statearr_68560_68569[(1)] = cljs.core.first.call(null,(state_68544[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68570 = state_68544;
state_68544 = G__68570;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_68544){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_68544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68561 = f__2769__auto__.call(null);
(statearr_68561[(6)] = c__2768__auto__);

return statearr_68561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__68572 = arguments.length;
switch (G__68572) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__68574){
var map__68575 = p__68574;
var map__68575__$1 = cljs.core.__destructure_map.call(null,map__68575);
var query = map__68575__$1;
var opts = cljs.core.get.call(null,map__68575__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68660){
var state_val_68661 = (state_68660[(1)]);
if((state_val_68661 === (7))){
var inst_68586 = (state_68660[(7)]);
var inst_68590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68591 = ["_auth/id",inst_68586];
var inst_68592 = (new cljs.core.PersistentVector(null,2,(5),inst_68590,inst_68591,null));
var state_68660__$1 = state_68660;
var statearr_68662_68706 = state_68660__$1;
(statearr_68662_68706[(2)] = inst_68592);

(statearr_68662_68706[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (20))){
var inst_68640 = (state_68660[(2)]);
var inst_68641 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_68660__$1 = (function (){var statearr_68663 = state_68660;
(statearr_68663[(8)] = inst_68640);

return statearr_68663;
})();
if(cljs.core.truth_(inst_68641)){
var statearr_68664_68707 = state_68660__$1;
(statearr_68664_68707[(1)] = (22));

} else {
var statearr_68665_68708 = state_68660__$1;
(statearr_68665_68708[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (27))){
var inst_68587 = (state_68660[(9)]);
var inst_68643 = (state_68660[(10)]);
var inst_68649 = (state_68660[(2)]);
var inst_68650 = fluree.db.util.core.response_time_formatted.call(null,inst_68587);
var inst_68651 = [(200),inst_68649,(100),inst_68650];
var inst_68652 = cljs.core.PersistentHashMap.fromArrays(inst_68643,inst_68651);
var state_68660__$1 = state_68660;
var statearr_68666_68709 = state_68660__$1;
(statearr_68666_68709[(2)] = inst_68652);

(statearr_68666_68709[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (1))){
var state_68660__$1 = state_68660;
var statearr_68667_68710 = state_68660__$1;
(statearr_68667_68710[(2)] = null);

(statearr_68667_68710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (24))){
var inst_68655 = (state_68660[(2)]);
var _ = (function (){var statearr_68668 = state_68660;
(statearr_68668[(4)] = cljs.core.rest.call(null,(state_68660[(4)])));

return statearr_68668;
})();
var state_68660__$1 = state_68660;
var statearr_68669_68711 = state_68660__$1;
(statearr_68669_68711[(2)] = inst_68655);

(statearr_68669_68711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (4))){
var inst_68576 = (state_68660[(2)]);
var state_68660__$1 = state_68660;
var statearr_68670_68712 = state_68660__$1;
(statearr_68670_68712[(2)] = inst_68576);

(statearr_68670_68712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (15))){
var inst_68627 = (state_68660[(11)]);
var state_68660__$1 = state_68660;
var statearr_68671_68713 = state_68660__$1;
(statearr_68671_68713[(2)] = inst_68627);

(statearr_68671_68713[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (21))){
var inst_68636 = (state_68660[(2)]);
var inst_68637 = fluree.db.util.async.throw_err.call(null,inst_68636);
var state_68660__$1 = state_68660;
var statearr_68672_68714 = state_68660__$1;
(statearr_68672_68714[(2)] = inst_68637);

(statearr_68672_68714[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (13))){
var inst_68585 = (state_68660[(12)]);
var inst_68627 = (state_68660[(11)]);
var inst_68626 = (state_68660[(2)]);
var inst_68627__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_68585);
var state_68660__$1 = (function (){var statearr_68673 = state_68660;
(statearr_68673[(13)] = inst_68626);

(statearr_68673[(11)] = inst_68627__$1);

return statearr_68673;
})();
if(cljs.core.truth_(inst_68627__$1)){
var statearr_68674_68715 = state_68660__$1;
(statearr_68674_68715[(1)] = (15));

} else {
var statearr_68675_68716 = state_68660__$1;
(statearr_68675_68716[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (22))){
var inst_68640 = (state_68660[(8)]);
var inst_68643 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_68644 = cljs.core.sequential_QMARK_.call(null,inst_68640);
var state_68660__$1 = (function (){var statearr_68676 = state_68660;
(statearr_68676[(10)] = inst_68643);

return statearr_68676;
})();
if(inst_68644){
var statearr_68677_68717 = state_68660__$1;
(statearr_68677_68717[(1)] = (25));

} else {
var statearr_68678_68718 = state_68660__$1;
(statearr_68678_68718[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (6))){
var inst_68601 = (state_68660[(14)]);
var inst_68585 = (state_68660[(12)]);
var inst_68600 = (state_68660[(2)]);
var inst_68601__$1 = fluree.db.util.async.throw_err.call(null,inst_68600);
var inst_68602 = fluree.db.api.query.resolve_block_range.call(null,inst_68601__$1,inst_68585);
var state_68660__$1 = (function (){var statearr_68679 = state_68660;
(statearr_68679[(14)] = inst_68601__$1);

return statearr_68679;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68660__$1,(10),inst_68602);
} else {
if((state_val_68661 === (25))){
var inst_68640 = (state_68660[(8)]);
var inst_68646 = cljs.core.doall.call(null,inst_68640);
var state_68660__$1 = state_68660;
var statearr_68680_68719 = state_68660__$1;
(statearr_68680_68719[(2)] = inst_68646);

(statearr_68680_68719[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (17))){
var inst_68632 = (state_68660[(2)]);
var state_68660__$1 = state_68660;
if(cljs.core.truth_(inst_68632)){
var statearr_68681_68720 = state_68660__$1;
(statearr_68681_68720[(1)] = (18));

} else {
var statearr_68682_68721 = state_68660__$1;
(statearr_68682_68721[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (3))){
var inst_68658 = (state_68660[(2)]);
var state_68660__$1 = state_68660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68660__$1,inst_68658);
} else {
if((state_val_68661 === (12))){
var inst_68585 = (state_68660[(12)]);
var inst_68618 = cljs.core.pr_str.call(null,inst_68585);
var inst_68619 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_68618].join('');
var inst_68620 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68621 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68622 = cljs.core.PersistentHashMap.fromArrays(inst_68620,inst_68621);
var inst_68623 = cljs.core.ex_info.call(null,inst_68619,inst_68622);
var inst_68624 = (function(){throw inst_68623})();
var state_68660__$1 = state_68660;
var statearr_68683_68722 = state_68660__$1;
(statearr_68683_68722[(2)] = inst_68624);

(statearr_68683_68722[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (2))){
var inst_68586 = (state_68660[(7)]);
var _ = (function (){var statearr_68684 = state_68660;
(statearr_68684[(4)] = cljs.core.cons.call(null,(5),(state_68660[(4)])));

return statearr_68684;
})();
var inst_68585 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_68586__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_68587 = fluree.db.util.core.current_time_millis.call(null);
var inst_68588 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_68660__$1 = (function (){var statearr_68685 = state_68660;
(statearr_68685[(7)] = inst_68586__$1);

(statearr_68685[(12)] = inst_68585);

(statearr_68685[(9)] = inst_68587);

(statearr_68685[(15)] = inst_68588);

return statearr_68685;
})();
if(cljs.core.truth_(inst_68586__$1)){
var statearr_68686_68723 = state_68660__$1;
(statearr_68686_68723[(1)] = (7));

} else {
var statearr_68687_68724 = state_68660__$1;
(statearr_68687_68724[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (23))){
var inst_68640 = (state_68660[(8)]);
var state_68660__$1 = state_68660;
var statearr_68688_68725 = state_68660__$1;
(statearr_68688_68725[(2)] = inst_68640);

(statearr_68688_68725[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (19))){
var inst_68626 = (state_68660[(13)]);
var state_68660__$1 = state_68660;
var statearr_68689_68726 = state_68660__$1;
(statearr_68689_68726[(2)] = inst_68626);

(statearr_68689_68726[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (11))){
var inst_68606 = (state_68660[(16)]);
var inst_68601 = (state_68660[(14)]);
var inst_68607 = (state_68660[(17)]);
var inst_68613 = fluree.db.api.query.block_range.call(null,inst_68601,inst_68606,inst_68607,opts);
var state_68660__$1 = state_68660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68660__$1,(14),inst_68613);
} else {
if((state_val_68661 === (9))){
var inst_68588 = (state_68660[(15)]);
var inst_68595 = (state_68660[(2)]);
var inst_68596 = [inst_68595];
var inst_68597 = cljs.core.PersistentHashMap.fromArrays(inst_68588,inst_68596);
var inst_68598 = fluree.db.api.query.db.call(null,conn,ledger,inst_68597);
var state_68660__$1 = state_68660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68660__$1,(6),inst_68598);
} else {
if((state_val_68661 === (5))){
var _ = (function (){var statearr_68691 = state_68660;
(statearr_68691[(4)] = cljs.core.rest.call(null,(state_68660[(4)])));

return statearr_68691;
})();
var state_68660__$1 = state_68660;
var ex68690 = (state_68660__$1[(2)]);
var statearr_68692_68727 = state_68660__$1;
(statearr_68692_68727[(5)] = ex68690);


if((ex68690 instanceof Error)){
var statearr_68693_68728 = state_68660__$1;
(statearr_68693_68728[(1)] = (4));

(statearr_68693_68728[(5)] = null);

} else {
throw ex68690;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (14))){
var inst_68615 = (state_68660[(2)]);
var inst_68616 = fluree.db.util.async.throw_err.call(null,inst_68615);
var state_68660__$1 = state_68660;
var statearr_68694_68729 = state_68660__$1;
(statearr_68694_68729[(2)] = inst_68616);

(statearr_68694_68729[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (26))){
var inst_68640 = (state_68660[(8)]);
var state_68660__$1 = state_68660;
var statearr_68695_68730 = state_68660__$1;
(statearr_68695_68730[(2)] = inst_68640);

(statearr_68695_68730[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (16))){
var inst_68585 = (state_68660[(12)]);
var inst_68630 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_68585);
var state_68660__$1 = state_68660;
var statearr_68696_68731 = state_68660__$1;
(statearr_68696_68731[(2)] = inst_68630);

(statearr_68696_68731[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (10))){
var inst_68585 = (state_68660[(12)]);
var inst_68604 = (state_68660[(2)]);
var inst_68605 = fluree.db.util.async.throw_err.call(null,inst_68604);
var inst_68606 = cljs.core.nth.call(null,inst_68605,(0),null);
var inst_68607 = cljs.core.nth.call(null,inst_68605,(1),null);
var inst_68608 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_68609 = cljs.core.dissoc.call(null,inst_68585,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_68610 = cljs.core.keys.call(null,inst_68609);
var inst_68611 = cljs.core._EQ_.call(null,inst_68608,inst_68610);
var state_68660__$1 = (function (){var statearr_68697 = state_68660;
(statearr_68697[(16)] = inst_68606);

(statearr_68697[(17)] = inst_68607);

return statearr_68697;
})();
if(inst_68611){
var statearr_68698_68732 = state_68660__$1;
(statearr_68698_68732[(1)] = (11));

} else {
var statearr_68699_68733 = state_68660__$1;
(statearr_68699_68733[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68661 === (18))){
var inst_68601 = (state_68660[(14)]);
var inst_68626 = (state_68660[(13)]);
var inst_68634 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_68601,inst_68626);
var state_68660__$1 = state_68660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68660__$1,(21),inst_68634);
} else {
if((state_val_68661 === (8))){
var state_68660__$1 = state_68660;
var statearr_68700_68734 = state_68660__$1;
(statearr_68700_68734[(2)] = null);

(statearr_68700_68734[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_68701 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68701[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_68701[(1)] = (1));

return statearr_68701;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_68660){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68702){var ex__2749__auto__ = e68702;
var statearr_68703_68735 = state_68660;
(statearr_68703_68735[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68660[(4)]))){
var statearr_68704_68736 = state_68660;
(statearr_68704_68736[(1)] = cljs.core.first.call(null,(state_68660[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68737 = state_68660;
state_68660 = G__68737;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_68660){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_68660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68705 = f__2769__auto__.call(null);
(statearr_68705[(6)] = c__2768__auto__);

return statearr_68705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__68738 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__68738,(0),null);
var p = cljs.core.nth.call(null,vec__68738,(1),null);
var o = cljs.core.nth.call(null,vec__68738,(2),null);
var t = cljs.core.nth.call(null,vec__68738,(3),null);
var vec__68741 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__68741,(0),null);
var idx = cljs.core.nth.call(null,vec__68741,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__68744 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__68744,(0),null);
var id = cljs.core.nth.call(null,vec__68744,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68748 = arguments.length;
var i__5770__auto___68749 = (0);
while(true){
if((i__5770__auto___68749 < len__5769__auto___68748)){
args__5775__auto__.push((arguments[i__5770__auto___68749]));

var G__68750 = (i__5770__auto___68749 + (1));
i__5770__auto___68749 = G__68750;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq68747){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq68747));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68946){
var state_val_68947 = (state_68946[(1)]);
if((state_val_68947 === (7))){
var inst_68866 = (state_68946[(7)]);
var inst_68873 = (state_68946[(8)]);
var inst_68872 = cljs.core.seq.call(null,inst_68866);
var inst_68873__$1 = cljs.core.first.call(null,inst_68872);
var inst_68874 = cljs.core.next.call(null,inst_68872);
var state_68946__$1 = (function (){var statearr_68948 = state_68946;
(statearr_68948[(9)] = inst_68874);

(statearr_68948[(8)] = inst_68873__$1);

return statearr_68948;
})();
if(cljs.core.truth_(inst_68873__$1)){
var statearr_68949_69049 = state_68946__$1;
(statearr_68949_69049[(1)] = (9));

} else {
var statearr_68950_69050 = state_68946__$1;
(statearr_68950_69050[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (20))){
var inst_68936 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
var statearr_68951_69051 = state_68946__$1;
(statearr_68951_69051[(2)] = inst_68936);

(statearr_68951_69051[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (27))){
var inst_68894 = (state_68946[(10)]);
var inst_68912 = (state_68946[(11)]);
var inst_68891 = (state_68946[(12)]);
var inst_68914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68915 = [inst_68894,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_68916 = (new cljs.core.PersistentVector(null,2,(5),inst_68914,inst_68915,null));
var inst_68917 = cljs.core.update_in.call(null,inst_68912,inst_68916,fluree.db.api.query.min_safe,inst_68891);
var state_68946__$1 = state_68946;
var statearr_68952_69052 = state_68946__$1;
(statearr_68952_69052[(2)] = inst_68917);

(statearr_68952_69052[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (1))){
var state_68946__$1 = state_68946;
var statearr_68953_69053 = state_68946__$1;
(statearr_68953_69053[(2)] = null);

(statearr_68953_69053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (24))){
var inst_68894 = (state_68946[(10)]);
var inst_68904 = (state_68946[(13)]);
var inst_68873 = (state_68946[(8)]);
var inst_68906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68907 = [inst_68894,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_68908 = (new cljs.core.PersistentVector(null,2,(5),inst_68906,inst_68907,null));
var inst_68909 = cljs.core.update_in.call(null,inst_68904,inst_68908,cljs.core.conj,inst_68873);
var state_68946__$1 = state_68946;
var statearr_68955_69054 = state_68946__$1;
(statearr_68955_69054[(2)] = inst_68909);

(statearr_68955_69054[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (4))){
var inst_68752 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
var statearr_68956_69055 = state_68946__$1;
(statearr_68956_69055[(2)] = inst_68752);

(statearr_68956_69055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (15))){
var inst_68874 = (state_68946[(9)]);
var inst_68867 = (state_68946[(14)]);
var tmp68954 = inst_68867;
var inst_68866 = inst_68874;
var inst_68867__$1 = tmp68954;
var state_68946__$1 = (function (){var statearr_68957 = state_68946;
(statearr_68957[(7)] = inst_68866);

(statearr_68957[(14)] = inst_68867__$1);

return statearr_68957;
})();
var statearr_68958_69056 = state_68946__$1;
(statearr_68958_69056[(2)] = null);

(statearr_68958_69056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (21))){
var inst_68894 = (state_68946[(10)]);
var inst_68867 = (state_68946[(14)]);
var inst_68898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68899 = [inst_68894,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_68900 = (new cljs.core.PersistentVector(null,2,(5),inst_68898,inst_68899,null));
var inst_68901 = cljs.core.assoc_in.call(null,inst_68867,inst_68900,inst_68894);
var state_68946__$1 = state_68946;
var statearr_68959_69057 = state_68946__$1;
(statearr_68959_69057[(2)] = inst_68901);

(statearr_68959_69057[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (31))){
var inst_68920 = (state_68946[(15)]);
var state_68946__$1 = state_68946;
var statearr_68960_69058 = state_68946__$1;
(statearr_68960_69058[(2)] = inst_68920);

(statearr_68960_69058[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (32))){
var inst_68874 = (state_68946[(9)]);
var inst_68928 = (state_68946[(2)]);
var inst_68866 = inst_68874;
var inst_68867 = inst_68928;
var state_68946__$1 = (function (){var statearr_68961 = state_68946;
(statearr_68961[(7)] = inst_68866);

(statearr_68961[(14)] = inst_68867);

return statearr_68961;
})();
var statearr_68962_69059 = state_68946__$1;
(statearr_68962_69059[(2)] = null);

(statearr_68962_69059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (33))){
var inst_68867 = (state_68946[(14)]);
var state_68946__$1 = state_68946;
var statearr_68963_69060 = state_68946__$1;
(statearr_68963_69060[(2)] = inst_68867);

(statearr_68963_69060[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (13))){
var inst_68876 = (state_68946[(16)]);
var state_68946__$1 = state_68946;
var statearr_68964_69061 = state_68946__$1;
(statearr_68964_69061[(2)] = inst_68876);

(statearr_68964_69061[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (22))){
var inst_68867 = (state_68946[(14)]);
var state_68946__$1 = state_68946;
var statearr_68965_69062 = state_68946__$1;
(statearr_68965_69062[(2)] = inst_68867);

(statearr_68965_69062[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (29))){
var inst_68920 = (state_68946[(2)]);
var state_68946__$1 = (function (){var statearr_68966 = state_68946;
(statearr_68966[(15)] = inst_68920);

return statearr_68966;
})();
if(cljs.core.truth_(show_auth)){
var statearr_68967_69063 = state_68946__$1;
(statearr_68967_69063[(1)] = (30));

} else {
var statearr_68968_69064 = state_68946__$1;
(statearr_68968_69064[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (6))){
var inst_68852 = (state_68946[(2)]);
var inst_68853 = fluree.db.util.async.throw_err.call(null,inst_68852);
var inst_68861 = resp;
var inst_68862 = cljs.core.seq.call(null,inst_68861);
var inst_68863 = cljs.core.first.call(null,inst_68862);
var inst_68864 = cljs.core.next.call(null,inst_68862);
var inst_68865 = cljs.core.PersistentHashMap.EMPTY;
var inst_68866 = inst_68861;
var inst_68867 = inst_68865;
var state_68946__$1 = (function (){var statearr_68969 = state_68946;
(statearr_68969[(7)] = inst_68866);

(statearr_68969[(17)] = inst_68853);

(statearr_68969[(18)] = inst_68863);

(statearr_68969[(14)] = inst_68867);

(statearr_68969[(19)] = inst_68864);

return statearr_68969;
})();
var statearr_68970_69065 = state_68946__$1;
(statearr_68970_69065[(2)] = null);

(statearr_68970_69065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (28))){
var inst_68912 = (state_68946[(11)]);
var state_68946__$1 = state_68946;
var statearr_68971_69066 = state_68946__$1;
(statearr_68971_69066[(2)] = inst_68912);

(statearr_68971_69066[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (25))){
var inst_68904 = (state_68946[(13)]);
var state_68946__$1 = state_68946;
var statearr_68972_69067 = state_68946__$1;
(statearr_68972_69067[(2)] = inst_68904);

(statearr_68972_69067[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (34))){
var state_68946__$1 = state_68946;
var statearr_68973_69068 = state_68946__$1;
(statearr_68973_69068[(2)] = null);

(statearr_68973_69068[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (17))){
var inst_68938 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
var statearr_68974_69069 = state_68946__$1;
(statearr_68974_69069[(2)] = inst_68938);

(statearr_68974_69069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (3))){
var inst_68944 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68946__$1,inst_68944);
} else {
if((state_val_68947 === (12))){
var inst_68853 = (state_68946[(17)]);
var inst_68873 = (state_68946[(8)]);
var inst_68878 = fluree.db.api.query.auth_match.call(null,auth,inst_68853,inst_68873);
var inst_68879 = cljs.core.not.call(null,inst_68878);
var state_68946__$1 = state_68946;
var statearr_68975_69070 = state_68946__$1;
(statearr_68975_69070[(2)] = inst_68879);

(statearr_68975_69070[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (2))){
var _ = (function (){var statearr_68976 = state_68946;
(statearr_68976[(4)] = cljs.core.cons.call(null,(5),(state_68946[(4)])));

return statearr_68976;
})();
var inst_68758 = (function (){return (function (p1__68751_SHARP_){
return fluree.db.flake.t.call(null,p1__68751_SHARP_);
});
})();
var inst_68759 = cljs.core.map.call(null,inst_68758,resp);
var inst_68760 = cljs.core.set.call(null,inst_68759);
var inst_68848 = cljs.core.async.chan.call(null,(1));
var inst_68849 = (function (){var ts = inst_68760;
var c__2768__auto____$1 = inst_68848;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68846){
var state_val_68847 = (state_68846[(1)]);
if((state_val_68847 === (7))){
var inst_68774 = (state_68846[(7)]);
var inst_68786 = (state_68846[(8)]);
var inst_68780 = (state_68846[(9)]);
var inst_68792 = (state_68846[(10)]);
var inst_68785 = (state_68846[(2)]);
var inst_68786__$1 = fluree.db.util.async.throw_err.call(null,inst_68785);
var inst_68788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68789 = [inst_68780,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_68790 = (new cljs.core.PersistentVector(null,2,(5),inst_68788,inst_68789,null));
var inst_68791 = cljs.core.assoc_in.call(null,inst_68774,inst_68790,inst_68786__$1);
var inst_68792__$1 = auth;
var state_68846__$1 = (function (){var statearr_68977 = state_68846;
(statearr_68977[(11)] = inst_68791);

(statearr_68977[(8)] = inst_68786__$1);

(statearr_68977[(10)] = inst_68792__$1);

return statearr_68977;
})();
if(cljs.core.truth_(inst_68792__$1)){
var statearr_68978_69071 = state_68846__$1;
(statearr_68978_69071[(1)] = (8));

} else {
var statearr_68979_69072 = state_68846__$1;
(statearr_68979_69072[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (1))){
var inst_68768 = (state_68846[(12)]);
var inst_68768__$1 = ts;
var inst_68769 = cljs.core.seq.call(null,inst_68768__$1);
var inst_68770 = cljs.core.first.call(null,inst_68769);
var inst_68771 = cljs.core.next.call(null,inst_68769);
var inst_68772 = cljs.core.PersistentHashMap.EMPTY;
var inst_68773 = inst_68768__$1;
var inst_68774 = inst_68772;
var state_68846__$1 = (function (){var statearr_68980 = state_68846;
(statearr_68980[(7)] = inst_68774);

(statearr_68980[(12)] = inst_68768__$1);

(statearr_68980[(13)] = inst_68770);

(statearr_68980[(14)] = inst_68773);

(statearr_68980[(15)] = inst_68771);

return statearr_68980;
})();
var statearr_68981_69073 = state_68846__$1;
(statearr_68981_69073[(2)] = null);

(statearr_68981_69073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (4))){
var inst_68780 = (state_68846[(9)]);
var inst_68783 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_68780);
var state_68846__$1 = state_68846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68846__$1,(7),inst_68783);
} else {
if((state_val_68847 === (13))){
var inst_68781 = (state_68846[(16)]);
var inst_68838 = (state_68846[(2)]);
var inst_68773 = inst_68781;
var inst_68774 = inst_68838;
var state_68846__$1 = (function (){var statearr_68982 = state_68846;
(statearr_68982[(7)] = inst_68774);

(statearr_68982[(14)] = inst_68773);

return statearr_68982;
})();
var statearr_68983_69074 = state_68846__$1;
(statearr_68983_69074[(2)] = null);

(statearr_68983_69074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (6))){
var inst_68842 = (state_68846[(2)]);
var state_68846__$1 = state_68846;
var statearr_68984_69075 = state_68846__$1;
(statearr_68984_69075[(2)] = inst_68842);

(statearr_68984_69075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (3))){
var inst_68844 = (state_68846[(2)]);
var state_68846__$1 = state_68846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68846__$1,inst_68844);
} else {
if((state_val_68847 === (12))){
var inst_68791 = (state_68846[(11)]);
var state_68846__$1 = state_68846;
var statearr_68985_69076 = state_68846__$1;
(statearr_68985_69076[(2)] = inst_68791);

(statearr_68985_69076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (2))){
var inst_68780 = (state_68846[(9)]);
var inst_68773 = (state_68846[(14)]);
var inst_68779 = cljs.core.seq.call(null,inst_68773);
var inst_68780__$1 = cljs.core.first.call(null,inst_68779);
var inst_68781 = cljs.core.next.call(null,inst_68779);
var state_68846__$1 = (function (){var statearr_68986 = state_68846;
(statearr_68986[(16)] = inst_68781);

(statearr_68986[(9)] = inst_68780__$1);

return statearr_68986;
})();
if(cljs.core.truth_(inst_68780__$1)){
var statearr_68987_69077 = state_68846__$1;
(statearr_68987_69077[(1)] = (4));

} else {
var statearr_68988_69078 = state_68846__$1;
(statearr_68988_69078[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (11))){
var inst_68781 = (state_68846[(16)]);
var inst_68791 = (state_68846[(11)]);
var inst_68774 = (state_68846[(7)]);
var inst_68786 = (state_68846[(8)]);
var inst_68768 = (state_68846[(12)]);
var inst_68780 = (state_68846[(9)]);
var inst_68770 = (state_68846[(13)]);
var inst_68773 = (state_68846[(14)]);
var inst_68771 = (state_68846[(15)]);
var inst_68798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68799 = [inst_68780,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_68800 = (new cljs.core.PersistentVector(null,2,(5),inst_68798,inst_68799,null));
var inst_68813 = cljs.core.async.chan.call(null,(1));
var inst_68814 = (function (){var t = inst_68780;
var first__68767 = inst_68770;
var vec__68765 = inst_68768;
var block = inst_68786;
var r = inst_68781;
var vec__68776 = inst_68773;
var seq__68777 = inst_68781;
var acc = inst_68774;
var seq__68766 = inst_68771;
var G__68787 = inst_68791;
var G__68764 = inst_68773;
var c__2768__auto____$2 = inst_68813;
var first__68778 = inst_68780;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68811){
var state_val_68812 = (state_68811[(1)]);
if((state_val_68812 === (1))){
var state_68811__$1 = state_68811;
var statearr_68989_69079 = state_68811__$1;
(statearr_68989_69079[(2)] = null);

(statearr_68989_69079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68812 === (2))){
var ___$1 = (function (){var statearr_68990 = state_68811;
(statearr_68990[(4)] = cljs.core.cons.call(null,(5),(state_68811[(4)])));

return statearr_68990;
})();
var ___$2 = (function (){var statearr_68991 = state_68811;
(statearr_68991[(4)] = cljs.core.rest.call(null,(state_68811[(4)])));

return statearr_68991;
})();
var state_68811__$1 = state_68811;
var statearr_68992_69080 = state_68811__$1;
(statearr_68992_69080[(2)] = db);

(statearr_68992_69080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68812 === (3))){
var inst_68809 = (state_68811[(2)]);
var state_68811__$1 = state_68811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68811__$1,inst_68809);
} else {
if((state_val_68812 === (4))){
var inst_68801 = (state_68811[(2)]);
var state_68811__$1 = state_68811;
var statearr_68994_69081 = state_68811__$1;
(statearr_68994_69081[(2)] = inst_68801);

(statearr_68994_69081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68812 === (5))){
var ___$1 = (function (){var statearr_68995 = state_68811;
(statearr_68995[(4)] = cljs.core.rest.call(null,(state_68811[(4)])));

return statearr_68995;
})();
var state_68811__$1 = state_68811;
var ex68993 = (state_68811__$1[(2)]);
var statearr_68996_69082 = state_68811__$1;
(statearr_68996_69082[(5)] = ex68993);


if((ex68993 instanceof Error)){
var statearr_68997_69083 = state_68811__$1;
(statearr_68997_69083[(1)] = (4));

(statearr_68997_69083[(5)] = null);

} else {
throw ex68993;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_68998 = [null,null,null,null,null,null,null];
(statearr_68998[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_68998[(1)] = (1));

return statearr_68998;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_68811){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68999){var ex__2749__auto__ = e68999;
var statearr_69000_69084 = state_68811;
(statearr_69000_69084[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68811[(4)]))){
var statearr_69001_69085 = state_68811;
(statearr_69001_69085[(1)] = cljs.core.first.call(null,(state_68811[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69086 = state_68811;
state_68811 = G__69086;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_68811){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_68811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69002 = f__2769__auto__.call(null);
(statearr_69002[(6)] = c__2768__auto____$2);

return statearr_69002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_68815 = cljs.core.async.impl.dispatch.run.call(null,inst_68814);
var inst_68816 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_68817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68818 = ["?auth","?id"];
var inst_68819 = (new cljs.core.PersistentVector(null,2,(5),inst_68817,inst_68818,null));
var inst_68820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68822 = [inst_68780,"_tx/auth","?auth"];
var inst_68823 = (new cljs.core.PersistentVector(null,3,(5),inst_68821,inst_68822,null));
var inst_68824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68825 = ["?auth","_auth/id","?id"];
var inst_68826 = (new cljs.core.PersistentVector(null,3,(5),inst_68824,inst_68825,null));
var inst_68827 = [inst_68823,inst_68826];
var inst_68828 = (new cljs.core.PersistentVector(null,2,(5),inst_68820,inst_68827,null));
var inst_68829 = [inst_68819,inst_68828];
var inst_68830 = cljs.core.PersistentHashMap.fromArrays(inst_68816,inst_68829);
var inst_68831 = fluree.db.api.query.query_async.call(null,inst_68813,inst_68830);
var state_68846__$1 = (function (){var statearr_69003 = state_68846;
(statearr_69003[(17)] = inst_68800);

(statearr_69003[(18)] = inst_68815);

return statearr_69003;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68846__$1,(14),inst_68831);
} else {
if((state_val_68847 === (9))){
var state_68846__$1 = state_68846;
var statearr_69004_69087 = state_68846__$1;
(statearr_69004_69087[(2)] = show_auth);

(statearr_69004_69087[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (5))){
var inst_68774 = (state_68846[(7)]);
var state_68846__$1 = state_68846;
var statearr_69005_69088 = state_68846__$1;
(statearr_69005_69088[(2)] = inst_68774);

(statearr_69005_69088[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (14))){
var inst_68800 = (state_68846[(17)]);
var inst_68791 = (state_68846[(11)]);
var inst_68833 = (state_68846[(2)]);
var inst_68834 = fluree.db.util.async.throw_err.call(null,inst_68833);
var inst_68835 = cljs.core.assoc_in.call(null,inst_68791,inst_68800,inst_68834);
var state_68846__$1 = state_68846;
var statearr_69006_69089 = state_68846__$1;
(statearr_69006_69089[(2)] = inst_68835);

(statearr_69006_69089[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (10))){
var inst_68796 = (state_68846[(2)]);
var state_68846__$1 = state_68846;
if(cljs.core.truth_(inst_68796)){
var statearr_69007_69090 = state_68846__$1;
(statearr_69007_69090[(1)] = (11));

} else {
var statearr_69008_69091 = state_68846__$1;
(statearr_69008_69091[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68847 === (8))){
var inst_68792 = (state_68846[(10)]);
var state_68846__$1 = state_68846;
var statearr_69009_69092 = state_68846__$1;
(statearr_69009_69092[(2)] = inst_68792);

(statearr_69009_69092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_69010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69010[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_69010[(1)] = (1));

return statearr_69010;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_68846){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69011){var ex__2749__auto__ = e69011;
var statearr_69012_69093 = state_68846;
(statearr_69012_69093[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68846[(4)]))){
var statearr_69013_69094 = state_68846;
(statearr_69013_69094[(1)] = cljs.core.first.call(null,(state_68846[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69095 = state_68846;
state_68846 = G__69095;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_68846){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_68846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69014 = f__2769__auto__.call(null);
(statearr_69014[(6)] = c__2768__auto____$1);

return statearr_69014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_68850 = cljs.core.async.impl.dispatch.run.call(null,inst_68849);
var state_68946__$1 = (function (){var statearr_69015 = state_68946;
(statearr_69015[(20)] = inst_68850);

return statearr_69015;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68946__$1,(6),inst_68848);
} else {
if((state_val_68947 === (23))){
var inst_68904 = (state_68946[(2)]);
var state_68946__$1 = (function (){var statearr_69016 = state_68946;
(statearr_69016[(13)] = inst_68904);

return statearr_69016;
})();
var statearr_69017_69096 = state_68946__$1;
(statearr_69017_69096[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (35))){
var inst_68934 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
var statearr_69019_69097 = state_68946__$1;
(statearr_69019_69097[(2)] = inst_68934);

(statearr_69019_69097[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (19))){
var state_68946__$1 = state_68946;
var statearr_69020_69098 = state_68946__$1;
(statearr_69020_69098[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (11))){
var inst_68885 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
if(cljs.core.truth_(inst_68885)){
var statearr_69023_69099 = state_68946__$1;
(statearr_69023_69099[(1)] = (15));

} else {
var statearr_69024_69100 = state_68946__$1;
(statearr_69024_69100[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (9))){
var inst_68876 = (state_68946[(16)]);
var inst_68876__$1 = auth;
var state_68946__$1 = (function (){var statearr_69025 = state_68946;
(statearr_69025[(16)] = inst_68876__$1);

return statearr_69025;
})();
if(cljs.core.truth_(inst_68876__$1)){
var statearr_69026_69101 = state_68946__$1;
(statearr_69026_69101[(1)] = (12));

} else {
var statearr_69027_69102 = state_68946__$1;
(statearr_69027_69102[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (5))){
var _ = (function (){var statearr_69028 = state_68946;
(statearr_69028[(4)] = cljs.core.rest.call(null,(state_68946[(4)])));

return statearr_69028;
})();
var state_68946__$1 = state_68946;
var ex69022 = (state_68946__$1[(2)]);
var statearr_69029_69103 = state_68946__$1;
(statearr_69029_69103[(5)] = ex69022);


if((ex69022 instanceof Error)){
var statearr_69030_69104 = state_68946__$1;
(statearr_69030_69104[(1)] = (4));

(statearr_69030_69104[(5)] = null);

} else {
throw ex69022;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (14))){
var inst_68882 = (state_68946[(2)]);
var state_68946__$1 = state_68946;
var statearr_69031_69105 = state_68946__$1;
(statearr_69031_69105[(2)] = inst_68882);

(statearr_69031_69105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (26))){
var inst_68912 = (state_68946[(2)]);
var state_68946__$1 = (function (){var statearr_69032 = state_68946;
(statearr_69032[(11)] = inst_68912);

return statearr_69032;
})();
var statearr_69033_69106 = state_68946__$1;
(statearr_69033_69106[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (16))){
var inst_68873 = (state_68946[(8)]);
var state_68946__$1 = state_68946;
if(cljs.core.truth_(inst_68873)){
var statearr_69035_69107 = state_68946__$1;
(statearr_69035_69107[(1)] = (18));

} else {
var statearr_69036_69108 = state_68946__$1;
(statearr_69036_69108[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (30))){
var inst_68895 = (state_68946[(21)]);
var inst_68894 = (state_68946[(10)]);
var inst_68920 = (state_68946[(15)]);
var inst_68922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68923 = [inst_68894,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_68924 = (new cljs.core.PersistentVector(null,2,(5),inst_68922,inst_68923,null));
var inst_68925 = cljs.core.assoc_in.call(null,inst_68920,inst_68924,inst_68895);
var state_68946__$1 = state_68946;
var statearr_69037_69109 = state_68946__$1;
(statearr_69037_69109[(2)] = inst_68925);

(statearr_69037_69109[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (10))){
var inst_68873 = (state_68946[(8)]);
var state_68946__$1 = state_68946;
var statearr_69038_69110 = state_68946__$1;
(statearr_69038_69110[(2)] = inst_68873);

(statearr_69038_69110[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (18))){
var inst_68853 = (state_68946[(17)]);
var inst_68873 = (state_68946[(8)]);
var inst_68891 = (state_68946[(12)]);
var inst_68891__$1 = fluree.db.flake.t.call(null,inst_68873);
var inst_68892 = cljs.core.get.call(null,inst_68853,inst_68891__$1);
var inst_68893 = cljs.core.__destructure_map.call(null,inst_68892);
var inst_68894 = cljs.core.get.call(null,inst_68893,new cljs.core.Keyword(null,"block","block",664686210));
var inst_68895 = cljs.core.get.call(null,inst_68893,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_68946__$1 = (function (){var statearr_69039 = state_68946;
(statearr_69039[(21)] = inst_68895);

(statearr_69039[(10)] = inst_68894);

(statearr_69039[(12)] = inst_68891__$1);

return statearr_69039;
})();
var statearr_69040_69111 = state_68946__$1;
(statearr_69040_69111[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68947 === (8))){
var inst_68940 = (state_68946[(2)]);
var inst_68941 = cljs.core.vals.call(null,inst_68940);
var _ = (function (){var statearr_69042 = state_68946;
(statearr_69042[(4)] = cljs.core.rest.call(null,(state_68946[(4)])));

return statearr_69042;
})();
var state_68946__$1 = state_68946;
var statearr_69043_69112 = state_68946__$1;
(statearr_69043_69112[(2)] = inst_68941);

(statearr_69043_69112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_69044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69044[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_69044[(1)] = (1));

return statearr_69044;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_68946){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69045){var ex__2749__auto__ = e69045;
var statearr_69046_69113 = state_68946;
(statearr_69046_69113[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68946[(4)]))){
var statearr_69047_69114 = state_68946;
(statearr_69047_69114[(1)] = cljs.core.first.call(null,(state_68946[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69115 = state_68946;
state_68946 = G__69115;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_68946){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_68946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69048 = f__2769__auto__.call(null);
(statearr_69048[(6)] = c__2768__auto__);

return statearr_69048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69239){
var state_val_69240 = (state_69239[(1)]);
if((state_val_69240 === (7))){
var inst_69138 = (state_69239[(7)]);
var inst_69140 = fluree.db.api.query.resolve_block_range.call(null,inst_69138,query_map);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(10),inst_69140);
} else {
if((state_val_69240 === (20))){
var inst_69164 = (state_69239[(2)]);
var inst_69165 = fluree.db.util.async.throw_err.call(null,inst_69164);
var inst_69166 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69165);
var inst_69167 = (inst_69166 - (1));
var state_69239__$1 = state_69239;
var statearr_69241_69304 = state_69239__$1;
(statearr_69241_69304[(2)] = inst_69167);

(statearr_69241_69304[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (27))){
var state_69239__$1 = state_69239;
var statearr_69242_69305 = state_69239__$1;
(statearr_69242_69305[(2)] = null);

(statearr_69242_69305[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (1))){
var state_69239__$1 = state_69239;
var statearr_69243_69306 = state_69239__$1;
(statearr_69243_69306[(2)] = null);

(statearr_69243_69306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (24))){
var inst_69174 = (state_69239[(2)]);
var inst_69175 = fluree.db.util.async.throw_err.call(null,inst_69174);
var inst_69176 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69175);
var state_69239__$1 = state_69239;
var statearr_69244_69307 = state_69239__$1;
(statearr_69244_69307[(2)] = inst_69176);

(statearr_69244_69307[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (39))){
var inst_69211 = (state_69239[(2)]);
var inst_69212 = fluree.db.util.async.throw_err.call(null,inst_69211);
var state_69239__$1 = state_69239;
var statearr_69245_69308 = state_69239__$1;
(statearr_69245_69308[(2)] = inst_69212);

(statearr_69245_69308[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (4))){
var inst_69116 = (state_69239[(2)]);
var state_69239__$1 = state_69239;
var statearr_69246_69309 = state_69239__$1;
(statearr_69246_69309[(2)] = inst_69116);

(statearr_69246_69309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (15))){
var inst_69147 = (state_69239[(8)]);
var state_69239__$1 = state_69239;
var statearr_69247_69310 = state_69239__$1;
(statearr_69247_69310[(2)] = inst_69147);

(statearr_69247_69310[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (21))){
var inst_69138 = (state_69239[(7)]);
var inst_69148 = (state_69239[(9)]);
var inst_69172 = fluree.db.time_travel.as_of_block.call(null,inst_69138,inst_69148);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(24),inst_69172);
} else {
if((state_val_69240 === (31))){
var inst_69132 = (state_69239[(10)]);
var state_69239__$1 = state_69239;
var statearr_69248_69311 = state_69239__$1;
(statearr_69248_69311[(2)] = inst_69132);

(statearr_69248_69311[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (32))){
var inst_69138 = (state_69239[(7)]);
var inst_69190 = (state_69239[(11)]);
var inst_69195 = (state_69239[(12)]);
var inst_69199 = (state_69239[(2)]);
var inst_69200 = fluree.db.api.query.format_history_resp.call(null,inst_69138,inst_69190,inst_69195,inst_69199);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(29),inst_69200);
} else {
if((state_val_69240 === (40))){
var inst_69216 = (state_69239[(13)]);
var inst_69190 = (state_69239[(11)]);
var inst_69218 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_69219 = cljs.core.count.call(null,inst_69190);
var inst_69220 = [inst_69216,inst_69219,(200)];
var inst_69221 = cljs.core.PersistentHashMap.fromArrays(inst_69218,inst_69220);
var state_69239__$1 = state_69239;
var statearr_69249_69312 = state_69239__$1;
(statearr_69249_69312[(2)] = inst_69221);

(statearr_69249_69312[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (33))){
var inst_69131 = (state_69239[(14)]);
var state_69239__$1 = state_69239;
var statearr_69250_69313 = state_69239__$1;
(statearr_69250_69313[(2)] = inst_69131);

(statearr_69250_69313[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (13))){
var inst_69234 = (state_69239[(2)]);
var _ = (function (){var statearr_69251 = state_69239;
(statearr_69251[(4)] = cljs.core.rest.call(null,(state_69239[(4)])));

return statearr_69251;
})();
var state_69239__$1 = state_69239;
var statearr_69252_69314 = state_69239__$1;
(statearr_69252_69314[(2)] = inst_69234);

(statearr_69252_69314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (22))){
var inst_69138 = (state_69239[(7)]);
var inst_69178 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69138);
var state_69239__$1 = state_69239;
var statearr_69253_69315 = state_69239__$1;
(statearr_69253_69315[(2)] = inst_69178);

(statearr_69253_69315[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (36))){
var inst_69138 = (state_69239[(7)]);
var inst_69203 = (state_69239[(15)]);
var inst_69209 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_69138,inst_69203);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(39),inst_69209);
} else {
if((state_val_69240 === (41))){
var inst_69216 = (state_69239[(13)]);
var state_69239__$1 = state_69239;
var statearr_69254_69316 = state_69239__$1;
(statearr_69254_69316[(2)] = inst_69216);

(statearr_69254_69316[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (29))){
var inst_69131 = (state_69239[(14)]);
var inst_69202 = (state_69239[(2)]);
var inst_69203 = fluree.db.util.async.throw_err.call(null,inst_69202);
var state_69239__$1 = (function (){var statearr_69255 = state_69239;
(statearr_69255[(15)] = inst_69203);

return statearr_69255;
})();
if(cljs.core.truth_(inst_69131)){
var statearr_69256_69317 = state_69239__$1;
(statearr_69256_69317[(1)] = (33));

} else {
var statearr_69257_69318 = state_69239__$1;
(statearr_69257_69318[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (6))){
var inst_69128 = (state_69239[(16)]);
var inst_69137 = (state_69239[(2)]);
var inst_69138 = fluree.db.util.async.throw_err.call(null,inst_69137);
var state_69239__$1 = (function (){var statearr_69258 = state_69239;
(statearr_69258[(7)] = inst_69138);

return statearr_69258;
})();
if(cljs.core.truth_(inst_69128)){
var statearr_69259_69319 = state_69239__$1;
(statearr_69259_69319[(1)] = (7));

} else {
var statearr_69260_69320 = state_69239__$1;
(statearr_69260_69320[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (28))){
var inst_69133 = (state_69239[(17)]);
var inst_69195 = (state_69239[(2)]);
var state_69239__$1 = (function (){var statearr_69261 = state_69239;
(statearr_69261[(12)] = inst_69195);

return statearr_69261;
})();
if(cljs.core.truth_(inst_69133)){
var statearr_69262_69321 = state_69239__$1;
(statearr_69262_69321[(1)] = (30));

} else {
var statearr_69263_69322 = state_69239__$1;
(statearr_69263_69322[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (25))){
var inst_69134 = (state_69239[(18)]);
var inst_69189 = (state_69239[(2)]);
var inst_69190 = fluree.db.util.async.throw_err.call(null,inst_69189);
var state_69239__$1 = (function (){var statearr_69264 = state_69239;
(statearr_69264[(11)] = inst_69190);

return statearr_69264;
})();
if(cljs.core.truth_(inst_69134)){
var statearr_69265_69323 = state_69239__$1;
(statearr_69265_69323[(1)] = (26));

} else {
var statearr_69266_69324 = state_69239__$1;
(statearr_69266_69324[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (34))){
var inst_69130 = (state_69239[(19)]);
var state_69239__$1 = state_69239;
var statearr_69267_69325 = state_69239__$1;
(statearr_69267_69325[(2)] = inst_69130);

(statearr_69267_69325[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (17))){
var inst_69138 = (state_69239[(7)]);
var inst_69147 = (state_69239[(8)]);
var inst_69161 = (inst_69147 - (1));
var inst_69162 = fluree.db.time_travel.as_of_block.call(null,inst_69138,inst_69161);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(20),inst_69162);
} else {
if((state_val_69240 === (3))){
var inst_69237 = (state_69239[(2)]);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69239__$1,inst_69237);
} else {
if((state_val_69240 === (12))){
var inst_69226 = cljs.core.pr_str.call(null,query_map);
var inst_69227 = ["History query not properly formatted. Provided ",inst_69226].join('');
var inst_69228 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69229 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69230 = cljs.core.PersistentHashMap.fromArrays(inst_69228,inst_69229);
var inst_69231 = cljs.core.ex_info.call(null,inst_69227,inst_69230);
var inst_69232 = (function(){throw inst_69231})();
var state_69239__$1 = state_69239;
var statearr_69268_69326 = state_69239__$1;
(statearr_69268_69326[(2)] = inst_69232);

(statearr_69268_69326[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (2))){
var _ = (function (){var statearr_69269 = state_69239;
(statearr_69269[(4)] = cljs.core.cons.call(null,(5),(state_69239[(4)])));

return statearr_69269;
})();
var inst_69126 = query_map;
var inst_69127 = cljs.core.__destructure_map.call(null,inst_69126);
var inst_69128 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69129 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_69130 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_69131 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_69132 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_69133 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_69134 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69135 = cljs.core.get.call(null,inst_69127,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_69239__$1 = (function (){var statearr_69270 = state_69239;
(statearr_69270[(19)] = inst_69130);

(statearr_69270[(20)] = inst_69129);

(statearr_69270[(10)] = inst_69132);

(statearr_69270[(14)] = inst_69131);

(statearr_69270[(16)] = inst_69128);

(statearr_69270[(17)] = inst_69133);

(statearr_69270[(21)] = inst_69135);

(statearr_69270[(18)] = inst_69134);

return statearr_69270;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(6),sources);
} else {
if((state_val_69240 === (23))){
var inst_69129 = (state_69239[(20)]);
var inst_69138 = (state_69239[(7)]);
var inst_69170 = (state_69239[(22)]);
var inst_69180 = (state_69239[(2)]);
var inst_69181 = fluree.db.api.query.get_history_pattern.call(null,inst_69129);
var inst_69182 = cljs.core.nth.call(null,inst_69181,(0),null);
var inst_69183 = cljs.core.nth.call(null,inst_69181,(1),null);
var inst_69184 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_69185 = [inst_69170,inst_69180];
var inst_69186 = cljs.core.PersistentHashMap.fromArrays(inst_69184,inst_69185);
var inst_69187 = fluree.db.query.range.time_range.call(null,inst_69138,inst_69183,cljs.core._EQ_,inst_69182,inst_69186);
var state_69239__$1 = state_69239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69239__$1,(25),inst_69187);
} else {
if((state_val_69240 === (35))){
var inst_69207 = (state_69239[(2)]);
var state_69239__$1 = state_69239;
if(cljs.core.truth_(inst_69207)){
var statearr_69271_69327 = state_69239__$1;
(statearr_69271_69327[(1)] = (36));

} else {
var statearr_69272_69328 = state_69239__$1;
(statearr_69272_69328[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (19))){
var inst_69148 = (state_69239[(9)]);
var inst_69170 = (state_69239[(2)]);
var state_69239__$1 = (function (){var statearr_69273 = state_69239;
(statearr_69273[(22)] = inst_69170);

return statearr_69273;
})();
if(cljs.core.truth_(inst_69148)){
var statearr_69274_69329 = state_69239__$1;
(statearr_69274_69329[(1)] = (21));

} else {
var statearr_69275_69330 = state_69239__$1;
(statearr_69275_69330[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (11))){
var inst_69135 = (state_69239[(21)]);
var inst_69147 = (state_69239[(8)]);
var inst_69154 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69135);
var state_69239__$1 = (function (){var statearr_69277 = state_69239;
(statearr_69277[(23)] = inst_69154);

return statearr_69277;
})();
if(cljs.core.truth_(inst_69147)){
var statearr_69278_69331 = state_69239__$1;
(statearr_69278_69331[(1)] = (14));

} else {
var statearr_69279_69332 = state_69239__$1;
(statearr_69279_69332[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (9))){
var inst_69146 = (state_69239[(2)]);
var inst_69147 = cljs.core.nth.call(null,inst_69146,(0),null);
var inst_69148 = cljs.core.nth.call(null,inst_69146,(1),null);
var inst_69149 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_69239__$1 = (function (){var statearr_69280 = state_69239;
(statearr_69280[(9)] = inst_69148);

(statearr_69280[(8)] = inst_69147);

return statearr_69280;
})();
if(inst_69149){
var statearr_69281_69333 = state_69239__$1;
(statearr_69281_69333[(1)] = (11));

} else {
var statearr_69282_69334 = state_69239__$1;
(statearr_69282_69334[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (5))){
var _ = (function (){var statearr_69283 = state_69239;
(statearr_69283[(4)] = cljs.core.rest.call(null,(state_69239[(4)])));

return statearr_69283;
})();
var state_69239__$1 = state_69239;
var ex69276 = (state_69239__$1[(2)]);
var statearr_69284_69335 = state_69239__$1;
(statearr_69284_69335[(5)] = ex69276);


if((ex69276 instanceof Error)){
var statearr_69285_69336 = state_69239__$1;
(statearr_69285_69336[(1)] = (4));

(statearr_69285_69336[(5)] = null);

} else {
throw ex69276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (14))){
var inst_69147 = (state_69239[(8)]);
var inst_69156 = cljs.core.not_EQ_.call(null,(1),inst_69147);
var state_69239__$1 = state_69239;
var statearr_69286_69337 = state_69239__$1;
(statearr_69286_69337[(2)] = inst_69156);

(statearr_69286_69337[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (26))){
var inst_69134 = (state_69239[(18)]);
var inst_69192 = cljs.core.set.call(null,inst_69134);
var state_69239__$1 = state_69239;
var statearr_69287_69338 = state_69239__$1;
(statearr_69287_69338[(2)] = inst_69192);

(statearr_69287_69338[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (16))){
var inst_69159 = (state_69239[(2)]);
var state_69239__$1 = state_69239;
if(cljs.core.truth_(inst_69159)){
var statearr_69288_69339 = state_69239__$1;
(statearr_69288_69339[(1)] = (17));

} else {
var statearr_69289_69340 = state_69239__$1;
(statearr_69289_69340[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (38))){
var inst_69154 = (state_69239[(23)]);
var inst_69216 = (state_69239[(2)]);
var state_69239__$1 = (function (){var statearr_69290 = state_69239;
(statearr_69290[(13)] = inst_69216);

return statearr_69290;
})();
if(cljs.core.truth_(inst_69154)){
var statearr_69291_69341 = state_69239__$1;
(statearr_69291_69341[(1)] = (40));

} else {
var statearr_69292_69342 = state_69239__$1;
(statearr_69292_69342[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (30))){
var inst_69133 = (state_69239[(17)]);
var state_69239__$1 = state_69239;
var statearr_69293_69343 = state_69239__$1;
(statearr_69293_69343[(2)] = inst_69133);

(statearr_69293_69343[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (10))){
var inst_69142 = (state_69239[(2)]);
var inst_69143 = fluree.db.util.async.throw_err.call(null,inst_69142);
var state_69239__$1 = state_69239;
var statearr_69294_69344 = state_69239__$1;
(statearr_69294_69344[(2)] = inst_69143);

(statearr_69294_69344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (18))){
var state_69239__$1 = state_69239;
var statearr_69295_69345 = state_69239__$1;
(statearr_69295_69345[(2)] = (-1));

(statearr_69295_69345[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (42))){
var inst_69224 = (state_69239[(2)]);
var state_69239__$1 = state_69239;
var statearr_69296_69346 = state_69239__$1;
(statearr_69296_69346[(2)] = inst_69224);

(statearr_69296_69346[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (37))){
var inst_69203 = (state_69239[(15)]);
var inst_69214 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_69203);
var state_69239__$1 = state_69239;
var statearr_69297_69347 = state_69239__$1;
(statearr_69297_69347[(2)] = inst_69214);

(statearr_69297_69347[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69240 === (8))){
var state_69239__$1 = state_69239;
var statearr_69298_69348 = state_69239__$1;
(statearr_69298_69348[(2)] = null);

(statearr_69298_69348[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_69299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69299[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_69299[(1)] = (1));

return statearr_69299;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_69239){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69300){var ex__2749__auto__ = e69300;
var statearr_69301_69349 = state_69239;
(statearr_69301_69349[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69239[(4)]))){
var statearr_69302_69350 = state_69239;
(statearr_69302_69350[(1)] = cljs.core.first.call(null,(state_69239[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69351 = state_69239;
state_69239 = G__69351;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_69239){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_69239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69303 = f__2769__auto__.call(null);
(statearr_69303[(6)] = c__2768__auto__);

return statearr_69303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69484){
var state_val_69485 = (state_69484[(1)]);
if((state_val_69485 === (7))){
var inst_69381 = cljs.core.pr_str.call(null,flureeQL);
var inst_69382 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_69381].join('');
var inst_69383 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69384 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69385 = cljs.core.PersistentHashMap.fromArrays(inst_69383,inst_69384);
var inst_69386 = cljs.core.ex_info.call(null,inst_69382,inst_69385);
var inst_69387 = (function(){throw inst_69386})();
var state_69484__$1 = state_69484;
var statearr_69486_69565 = state_69484__$1;
(statearr_69486_69565[(2)] = inst_69387);

(statearr_69486_69565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (20))){
var inst_69419 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69419)){
var statearr_69487_69566 = state_69484__$1;
(statearr_69487_69566[(1)] = (21));

} else {
var statearr_69488_69567 = state_69484__$1;
(statearr_69488_69567[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (27))){
var inst_69363 = (state_69484[(7)]);
var state_69484__$1 = state_69484;
var statearr_69489_69568 = state_69484__$1;
(statearr_69489_69568[(2)] = inst_69363);

(statearr_69489_69568[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (1))){
var state_69484__$1 = state_69484;
var statearr_69490_69569 = state_69484__$1;
(statearr_69490_69569[(2)] = null);

(statearr_69490_69569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (24))){
var inst_69425 = (state_69484[(8)]);
var state_69484__$1 = state_69484;
var statearr_69491_69570 = state_69484__$1;
(statearr_69491_69570[(2)] = inst_69425);

(statearr_69491_69570[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (39))){
var inst_69369 = (state_69484[(9)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69369)){
var statearr_69492_69571 = state_69484__$1;
(statearr_69492_69571[(1)] = (42));

} else {
var statearr_69493_69572 = state_69484__$1;
(statearr_69493_69572[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (46))){
var inst_69457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69458 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69459 = cljs.core.PersistentHashMap.fromArrays(inst_69457,inst_69458);
var inst_69460 = cljs.core.ex_info.call(null,"Invalid query.",inst_69459);
var inst_69461 = (function(){throw inst_69460})();
var state_69484__$1 = state_69484;
var statearr_69494_69573 = state_69484__$1;
(statearr_69494_69573[(2)] = inst_69461);

(statearr_69494_69573[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (4))){
var inst_69353 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
var statearr_69495_69574 = state_69484__$1;
(statearr_69495_69574[(2)] = inst_69353);

(statearr_69495_69574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (15))){
var inst_69404 = (state_69484[(10)]);
var inst_69366 = (state_69484[(11)]);
var inst_69406 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_69404);
var inst_69407 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_69404);
var inst_69408 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_69404);
var inst_69409 = fluree.db.api.query.get_sources.call(null,inst_69406,inst_69407,inst_69408,inst_69366);
var state_69484__$1 = state_69484;
var statearr_69496_69575 = state_69484__$1;
(statearr_69496_69575[(2)] = inst_69409);

(statearr_69496_69575[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (48))){
var inst_69414 = (state_69484[(12)]);
var inst_69468 = (state_69484[(2)]);
var inst_69469 = fluree.db.util.async.throw_err.call(null,inst_69468);
var state_69484__$1 = (function (){var statearr_69497 = state_69484;
(statearr_69497[(13)] = inst_69469);

return statearr_69497;
})();
if(cljs.core.truth_(inst_69414)){
var statearr_69498_69576 = state_69484__$1;
(statearr_69498_69576[(1)] = (49));

} else {
var statearr_69499_69577 = state_69484__$1;
(statearr_69499_69577[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (50))){
var inst_69469 = (state_69484[(13)]);
var state_69484__$1 = state_69484;
var statearr_69500_69578 = state_69484__$1;
(statearr_69500_69578[(2)] = inst_69469);

(statearr_69500_69578[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (21))){
var inst_69421 = cljs.core.volatile_BANG_.call(null,(0));
var state_69484__$1 = state_69484;
var statearr_69501_69579 = state_69484__$1;
(statearr_69501_69579[(2)] = inst_69421);

(statearr_69501_69579[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (31))){
var inst_69367 = (state_69484[(14)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69367)){
var statearr_69502_69580 = state_69484__$1;
(statearr_69502_69580[(1)] = (33));

} else {
var statearr_69503_69581 = state_69484__$1;
(statearr_69503_69581[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (32))){
var inst_69444 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
var statearr_69504_69582 = state_69484__$1;
(statearr_69504_69582[(2)] = inst_69444);

(statearr_69504_69582[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (40))){
var inst_69446 = (state_69484[(15)]);
var state_69484__$1 = state_69484;
var statearr_69505_69583 = state_69484__$1;
(statearr_69505_69583[(2)] = inst_69446);

(statearr_69505_69583[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (33))){
var inst_69367 = (state_69484[(14)]);
var state_69484__$1 = state_69484;
var statearr_69506_69584 = state_69484__$1;
(statearr_69506_69584[(2)] = inst_69367);

(statearr_69506_69584[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (13))){
var inst_69364 = (state_69484[(16)]);
var inst_69393 = (state_69484[(2)]);
var inst_69394 = fluree.db.util.async.throw_err.call(null,inst_69393);
var inst_69395 = fluree.db.time_travel.as_of_block.call(null,inst_69394,inst_69364);
var state_69484__$1 = state_69484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69484__$1,(12),inst_69395);
} else {
if((state_val_69485 === (22))){
var state_69484__$1 = state_69484;
var statearr_69507_69585 = state_69484__$1;
(statearr_69507_69585[(2)] = null);

(statearr_69507_69585[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (36))){
var inst_69371 = (state_69484[(17)]);
var state_69484__$1 = state_69484;
var statearr_69508_69586 = state_69484__$1;
(statearr_69508_69586[(2)] = inst_69371);

(statearr_69508_69586[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (41))){
var inst_69454 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69454)){
var statearr_69509_69587 = state_69484__$1;
(statearr_69509_69587[(1)] = (45));

} else {
var statearr_69510_69588 = state_69484__$1;
(statearr_69510_69588[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (43))){
var inst_69365 = (state_69484[(18)]);
var state_69484__$1 = state_69484;
var statearr_69511_69589 = state_69484__$1;
(statearr_69511_69589[(2)] = inst_69365);

(statearr_69511_69589[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (29))){
var inst_69446 = (state_69484[(15)]);
var inst_69446__$1 = (state_69484[(2)]);
var state_69484__$1 = (function (){var statearr_69512 = state_69484;
(statearr_69512[(15)] = inst_69446__$1);

return statearr_69512;
})();
if(cljs.core.truth_(inst_69446__$1)){
var statearr_69513_69590 = state_69484__$1;
(statearr_69513_69590[(1)] = (39));

} else {
var statearr_69514_69591 = state_69484__$1;
(statearr_69514_69591[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (44))){
var inst_69451 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
var statearr_69515_69592 = state_69484__$1;
(statearr_69515_69592[(2)] = inst_69451);

(statearr_69515_69592[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (6))){
var state_69484__$1 = state_69484;
var statearr_69516_69593 = state_69484__$1;
(statearr_69516_69593[(2)] = null);

(statearr_69516_69593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (28))){
var inst_69368 = (state_69484[(19)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69368)){
var statearr_69517_69594 = state_69484__$1;
(statearr_69517_69594[(1)] = (30));

} else {
var statearr_69518_69595 = state_69484__$1;
(statearr_69518_69595[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (51))){
var inst_69479 = (state_69484[(2)]);
var _ = (function (){var statearr_69519 = state_69484;
(statearr_69519[(4)] = cljs.core.rest.call(null,(state_69484[(4)])));

return statearr_69519;
})();
var state_69484__$1 = state_69484;
var statearr_69520_69596 = state_69484__$1;
(statearr_69520_69596[(2)] = inst_69479);

(statearr_69520_69596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (25))){
var state_69484__$1 = state_69484;
var statearr_69521_69597 = state_69484__$1;
(statearr_69521_69597[(2)] = (1000000));

(statearr_69521_69597[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (34))){
var inst_69371 = (state_69484[(17)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69371)){
var statearr_69522_69598 = state_69484__$1;
(statearr_69522_69598[(1)] = (36));

} else {
var statearr_69523_69599 = state_69484__$1;
(statearr_69523_69599[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (17))){
var inst_69415 = (state_69484[(20)]);
var inst_69370 = (state_69484[(21)]);
var inst_69413 = (state_69484[(2)]);
var inst_69414 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69370);
var inst_69415__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_69370);
var state_69484__$1 = (function (){var statearr_69524 = state_69484;
(statearr_69524[(12)] = inst_69414);

(statearr_69524[(20)] = inst_69415__$1);

(statearr_69524[(22)] = inst_69413);

return statearr_69524;
})();
if(cljs.core.truth_(inst_69415__$1)){
var statearr_69525_69600 = state_69484__$1;
(statearr_69525_69600[(1)] = (18));

} else {
var statearr_69526_69601 = state_69484__$1;
(statearr_69526_69601[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (3))){
var inst_69482 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69484__$1,inst_69482);
} else {
if((state_val_69485 === (12))){
var inst_69397 = (state_69484[(2)]);
var inst_69398 = fluree.db.util.async.throw_err.call(null,inst_69397);
var state_69484__$1 = state_69484;
var statearr_69527_69602 = state_69484__$1;
(statearr_69527_69602[(2)] = inst_69398);

(statearr_69527_69602[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (2))){
var inst_69371 = (state_69484[(17)]);
var inst_69365 = (state_69484[(18)]);
var inst_69368 = (state_69484[(19)]);
var inst_69364 = (state_69484[(16)]);
var inst_69369 = (state_69484[(9)]);
var inst_69370 = (state_69484[(21)]);
var inst_69362 = (state_69484[(23)]);
var inst_69366 = (state_69484[(11)]);
var inst_69363 = (state_69484[(7)]);
var inst_69367 = (state_69484[(14)]);
var _ = (function (){var statearr_69528 = state_69484;
(statearr_69528[(4)] = cljs.core.cons.call(null,(5),(state_69484[(4)])));

return statearr_69528;
})();
var inst_69360 = flureeQL;
var inst_69361 = cljs.core.__destructure_map.call(null,inst_69360);
var inst_69362__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_69363__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_69364__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69365__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_69366__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_69367__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_69368__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_69369__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_69370__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69371__$1 = cljs.core.get.call(null,inst_69361,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_69372 = (function (){var construct = inst_69362__$1;
var select = inst_69363__$1;
var block = inst_69364__$1;
var where = inst_69365__$1;
var prefixes = inst_69366__$1;
var selectDistinct = inst_69367__$1;
var map__69359 = inst_69361;
var selectOne = inst_69368__$1;
var from = inst_69369__$1;
var opts = inst_69370__$1;
var selectReduced = inst_69371__$1;
return (function (p1__69352_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__69352_SHARP_);
});
})();
var inst_69373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69374 = [inst_69363__$1,inst_69368__$1,inst_69367__$1,inst_69371__$1];
var inst_69375 = (new cljs.core.PersistentVector(null,4,(5),inst_69373,inst_69374,null));
var inst_69376 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_69375);
var inst_69377 = cljs.core.count.call(null,inst_69376);
var inst_69378 = inst_69372.call(null,inst_69377);
var state_69484__$1 = (function (){var statearr_69529 = state_69484;
(statearr_69529[(17)] = inst_69371__$1);

(statearr_69529[(18)] = inst_69365__$1);

(statearr_69529[(19)] = inst_69368__$1);

(statearr_69529[(16)] = inst_69364__$1);

(statearr_69529[(9)] = inst_69369__$1);

(statearr_69529[(21)] = inst_69370__$1);

(statearr_69529[(23)] = inst_69362__$1);

(statearr_69529[(11)] = inst_69366__$1);

(statearr_69529[(7)] = inst_69363__$1);

(statearr_69529[(14)] = inst_69367__$1);

return statearr_69529;
})();
if(cljs.core.truth_(inst_69378)){
var statearr_69530_69603 = state_69484__$1;
(statearr_69530_69603[(1)] = (6));

} else {
var statearr_69531_69604 = state_69484__$1;
(statearr_69531_69604[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (23))){
var inst_69425 = (state_69484[(8)]);
var inst_69370 = (state_69484[(21)]);
var inst_69424 = (state_69484[(2)]);
var inst_69425__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_69370);
var state_69484__$1 = (function (){var statearr_69532 = state_69484;
(statearr_69532[(24)] = inst_69424);

(statearr_69532[(8)] = inst_69425__$1);

return statearr_69532;
})();
if(cljs.core.truth_(inst_69425__$1)){
var statearr_69533_69605 = state_69484__$1;
(statearr_69533_69605[(1)] = (24));

} else {
var statearr_69534_69606 = state_69484__$1;
(statearr_69534_69606[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (47))){
var inst_69404 = (state_69484[(10)]);
var inst_69430 = (state_69484[(25)]);
var inst_69463 = (state_69484[(2)]);
var inst_69464 = fluree.db.util.core.current_time_millis.call(null);
var inst_69465 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69430);
var inst_69466 = fluree.db.query.fql.query.call(null,inst_69404,inst_69465);
var state_69484__$1 = (function (){var statearr_69535 = state_69484;
(statearr_69535[(26)] = inst_69464);

(statearr_69535[(27)] = inst_69463);

return statearr_69535;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69484__$1,(48),inst_69466);
} else {
if((state_val_69485 === (35))){
var inst_69442 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
var statearr_69536_69607 = state_69484__$1;
(statearr_69536_69607[(2)] = inst_69442);

(statearr_69536_69607[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (19))){
var inst_69414 = (state_69484[(12)]);
var state_69484__$1 = state_69484;
var statearr_69537_69608 = state_69484__$1;
(statearr_69537_69608[(2)] = inst_69414);

(statearr_69537_69608[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (11))){
var inst_69366 = (state_69484[(11)]);
var inst_69404 = (state_69484[(2)]);
var state_69484__$1 = (function (){var statearr_69539 = state_69484;
(statearr_69539[(10)] = inst_69404);

return statearr_69539;
})();
if(cljs.core.truth_(inst_69366)){
var statearr_69540_69609 = state_69484__$1;
(statearr_69540_69609[(1)] = (15));

} else {
var statearr_69541_69610 = state_69484__$1;
(statearr_69541_69610[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (9))){
var inst_69390 = (state_69484[(28)]);
var state_69484__$1 = state_69484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69484__$1,(13),inst_69390);
} else {
if((state_val_69485 === (5))){
var _ = (function (){var statearr_69542 = state_69484;
(statearr_69542[(4)] = cljs.core.rest.call(null,(state_69484[(4)])));

return statearr_69542;
})();
var state_69484__$1 = state_69484;
var ex69538 = (state_69484__$1[(2)]);
var statearr_69543_69611 = state_69484__$1;
(statearr_69543_69611[(5)] = ex69538);


if((ex69538 instanceof Error)){
var statearr_69544_69612 = state_69484__$1;
(statearr_69544_69612[(1)] = (4));

(statearr_69544_69612[(5)] = null);

} else {
throw ex69538;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (14))){
var inst_69401 = (state_69484[(2)]);
var inst_69402 = fluree.db.util.async.throw_err.call(null,inst_69401);
var state_69484__$1 = state_69484;
var statearr_69545_69613 = state_69484__$1;
(statearr_69545_69613[(2)] = inst_69402);

(statearr_69545_69613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (45))){
var state_69484__$1 = state_69484;
var statearr_69546_69614 = state_69484__$1;
(statearr_69546_69614[(2)] = null);

(statearr_69546_69614[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (26))){
var inst_69424 = (state_69484[(24)]);
var inst_69413 = (state_69484[(22)]);
var inst_69370 = (state_69484[(21)]);
var inst_69363 = (state_69484[(7)]);
var inst_69429 = (state_69484[(2)]);
var inst_69430 = cljs.core.assoc.call(null,inst_69370,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_69413,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_69429,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_69424);
var state_69484__$1 = (function (){var statearr_69547 = state_69484;
(statearr_69547[(25)] = inst_69430);

return statearr_69547;
})();
if(cljs.core.truth_(inst_69363)){
var statearr_69548_69615 = state_69484__$1;
(statearr_69548_69615[(1)] = (27));

} else {
var statearr_69549_69616 = state_69484__$1;
(statearr_69549_69616[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (16))){
var inst_69411 = cljs.core.PersistentHashMap.EMPTY;
var state_69484__$1 = state_69484;
var statearr_69550_69617 = state_69484__$1;
(statearr_69550_69617[(2)] = inst_69411);

(statearr_69550_69617[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (38))){
var inst_69440 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
var statearr_69551_69618 = state_69484__$1;
(statearr_69551_69618[(2)] = inst_69440);

(statearr_69551_69618[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (30))){
var inst_69368 = (state_69484[(19)]);
var state_69484__$1 = state_69484;
var statearr_69552_69619 = state_69484__$1;
(statearr_69552_69619[(2)] = inst_69368);

(statearr_69552_69619[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (10))){
var inst_69390 = (state_69484[(28)]);
var state_69484__$1 = state_69484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69484__$1,(14),inst_69390);
} else {
if((state_val_69485 === (18))){
var inst_69415 = (state_69484[(20)]);
var state_69484__$1 = state_69484;
var statearr_69553_69620 = state_69484__$1;
(statearr_69553_69620[(2)] = inst_69415);

(statearr_69553_69620[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (42))){
var inst_69369 = (state_69484[(9)]);
var state_69484__$1 = state_69484;
var statearr_69554_69621 = state_69484__$1;
(statearr_69554_69621[(2)] = inst_69369);

(statearr_69554_69621[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (37))){
var inst_69362 = (state_69484[(23)]);
var state_69484__$1 = state_69484;
var statearr_69555_69622 = state_69484__$1;
(statearr_69555_69622[(2)] = inst_69362);

(statearr_69555_69622[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (8))){
var inst_69364 = (state_69484[(16)]);
var inst_69389 = (state_69484[(2)]);
var inst_69390 = sources;
var state_69484__$1 = (function (){var statearr_69556 = state_69484;
(statearr_69556[(28)] = inst_69390);

(statearr_69556[(29)] = inst_69389);

return statearr_69556;
})();
if(cljs.core.truth_(inst_69364)){
var statearr_69557_69623 = state_69484__$1;
(statearr_69557_69623[(1)] = (9));

} else {
var statearr_69558_69624 = state_69484__$1;
(statearr_69558_69624[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (49))){
var inst_69464 = (state_69484[(26)]);
var inst_69424 = (state_69484[(24)]);
var inst_69404 = (state_69484[(10)]);
var inst_69469 = (state_69484[(13)]);
var inst_69471 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69472 = cljs.core.deref.call(null,inst_69424);
var inst_69473 = fluree.db.util.core.response_time_formatted.call(null,inst_69464);
var inst_69474 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_69404);
var inst_69475 = [(200),inst_69469,inst_69472,inst_69473,inst_69474];
var inst_69476 = cljs.core.PersistentHashMap.fromArrays(inst_69471,inst_69475);
var state_69484__$1 = state_69484;
var statearr_69559_69625 = state_69484__$1;
(statearr_69559_69625[(2)] = inst_69476);

(statearr_69559_69625[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_69560 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69560[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_69560[(1)] = (1));

return statearr_69560;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_69484){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69561){var ex__2749__auto__ = e69561;
var statearr_69562_69626 = state_69484;
(statearr_69562_69626[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69484[(4)]))){
var statearr_69563_69627 = state_69484;
(statearr_69563_69627[(1)] = cljs.core.first.call(null,(state_69484[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69628 = state_69484;
state_69484 = G__69628;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_69484){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_69484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69564 = f__2769__auto__.call(null);
(statearr_69564[(6)] = c__2768__auto__);

return statearr_69564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69769){
var state_val_69770 = (state_69769[(1)]);
if((state_val_69770 === (7))){
var inst_69764 = (state_69769[(2)]);
var _ = (function (){var statearr_69771 = state_69769;
(statearr_69771[(4)] = cljs.core.rest.call(null,(state_69769[(4)])));

return statearr_69771;
})();
var state_69769__$1 = state_69769;
var statearr_69772_69848 = state_69769__$1;
(statearr_69772_69848[(2)] = inst_69764);

(statearr_69772_69848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (20))){
var inst_69736 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69773_69849 = state_69769__$1;
(statearr_69773_69849[(2)] = inst_69736);

(statearr_69773_69849[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (27))){
var inst_69716 = (state_69769[(7)]);
var state_69769__$1 = state_69769;
var statearr_69774_69850 = state_69769__$1;
(statearr_69774_69850[(2)] = inst_69716);

(statearr_69774_69850[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (1))){
var state_69769__$1 = state_69769;
var statearr_69775_69851 = state_69769__$1;
(statearr_69775_69851[(2)] = null);

(statearr_69775_69851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (24))){
var inst_69713 = (state_69769[(8)]);
var state_69769__$1 = state_69769;
var statearr_69776_69852 = state_69769__$1;
(statearr_69776_69852[(2)] = inst_69713);

(statearr_69776_69852[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (39))){
var inst_69670 = (state_69769[(9)]);
var inst_69681 = (state_69769[(10)]);
var inst_69703 = (state_69769[(11)]);
var inst_69747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69748 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_69681];
var inst_69749 = (new cljs.core.PersistentVector(null,2,(5),inst_69747,inst_69748,null));
var inst_69750 = cljs.core.assoc_in.call(null,inst_69670,inst_69749,inst_69703);
var state_69769__$1 = state_69769;
var statearr_69777_69853 = state_69769__$1;
(statearr_69777_69853[(2)] = inst_69750);

(statearr_69777_69853[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (4))){
var inst_69629 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69778_69854 = state_69769__$1;
(statearr_69778_69854[(2)] = inst_69629);

(statearr_69778_69854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (15))){
var inst_69703 = (state_69769[(11)]);
var inst_69668 = (state_69769[(12)]);
var inst_69706 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_69703);
var inst_69707 = (inst_69668 == null);
var state_69769__$1 = (function (){var statearr_69779 = state_69769;
(statearr_69779[(13)] = inst_69706);

return statearr_69779;
})();
if(cljs.core.truth_(inst_69707)){
var statearr_69780_69855 = state_69769__$1;
(statearr_69780_69855[(1)] = (18));

} else {
var statearr_69781_69856 = state_69769__$1;
(statearr_69781_69856[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (21))){
var inst_69706 = (state_69769[(13)]);
var state_69769__$1 = state_69769;
var statearr_69782_69857 = state_69769__$1;
(statearr_69782_69857[(2)] = inst_69706);

(statearr_69782_69857[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (31))){
var state_69769__$1 = state_69769;
var statearr_69783_69858 = state_69769__$1;
(statearr_69783_69858[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (32))){
var inst_69732 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69785_69859 = state_69769__$1;
(statearr_69785_69859[(2)] = inst_69732);

(statearr_69785_69859[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (40))){
var inst_69701 = (state_69769[(14)]);
var state_69769__$1 = state_69769;
if(cljs.core.truth_(inst_69701)){
var statearr_69786_69860 = state_69769__$1;
(statearr_69786_69860[(1)] = (42));

} else {
var statearr_69787_69861 = state_69769__$1;
(statearr_69787_69861[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (33))){
var inst_69706 = (state_69769[(13)]);
var inst_69668 = (state_69769[(12)]);
var inst_69727 = ((inst_69706 > inst_69668) ? inst_69706 : inst_69668);
var state_69769__$1 = state_69769;
var statearr_69788_69862 = state_69769__$1;
(statearr_69788_69862[(2)] = inst_69727);

(statearr_69788_69862[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (13))){
var inst_69692 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69789_69863 = state_69769__$1;
(statearr_69789_69863[(2)] = inst_69692);

(statearr_69789_69863[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (22))){
var inst_69713 = (state_69769[(8)]);
var inst_69706 = (state_69769[(13)]);
var inst_69713__$1 = cljs.core._EQ_.call(null,(200),inst_69706);
var state_69769__$1 = (function (){var statearr_69790 = state_69769;
(statearr_69790[(8)] = inst_69713__$1);

return statearr_69790;
})();
if(inst_69713__$1){
var statearr_69791_69864 = state_69769__$1;
(statearr_69791_69864[(1)] = (24));

} else {
var statearr_69792_69865 = state_69769__$1;
(statearr_69792_69865[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (36))){
var inst_69669 = (state_69769[(15)]);
var inst_69703 = (state_69769[(11)]);
var inst_69741 = cljs.core.get.call(null,inst_69703,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_69742 = (inst_69669 + inst_69741);
var state_69769__$1 = state_69769;
var statearr_69793_69866 = state_69769__$1;
(statearr_69793_69866[(2)] = inst_69742);

(statearr_69793_69866[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (41))){
var inst_69739 = (state_69769[(16)]);
var inst_69745 = (state_69769[(17)]);
var inst_69680 = (state_69769[(18)]);
var inst_69759 = (state_69769[(2)]);
var inst_69667 = inst_69680;
var inst_69668 = inst_69739;
var inst_69669 = inst_69745;
var inst_69670 = inst_69759;
var state_69769__$1 = (function (){var statearr_69794 = state_69769;
(statearr_69794[(9)] = inst_69670);

(statearr_69794[(15)] = inst_69669);

(statearr_69794[(19)] = inst_69667);

(statearr_69794[(12)] = inst_69668);

return statearr_69794;
})();
var statearr_69795_69867 = state_69769__$1;
(statearr_69795_69867[(2)] = null);

(statearr_69795_69867[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (43))){
var inst_69703 = (state_69769[(11)]);
var state_69769__$1 = state_69769;
var statearr_69796_69868 = state_69769__$1;
(statearr_69796_69868[(2)] = inst_69703);

(statearr_69796_69868[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (29))){
var inst_69721 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69797_69869 = state_69769__$1;
(statearr_69797_69869[(2)] = inst_69721);

(statearr_69797_69869[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (44))){
var inst_69670 = (state_69769[(9)]);
var inst_69681 = (state_69769[(10)]);
var inst_69756 = (state_69769[(2)]);
var inst_69757 = cljs.core.assoc.call(null,inst_69670,inst_69681,inst_69756);
var state_69769__$1 = state_69769;
var statearr_69798_69870 = state_69769__$1;
(statearr_69798_69870[(2)] = inst_69757);

(statearr_69798_69870[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (6))){
var inst_69667 = (state_69769[(19)]);
var inst_69682 = (state_69769[(20)]);
var inst_69678 = cljs.core.seq.call(null,inst_69667);
var inst_69679 = cljs.core.first.call(null,inst_69678);
var inst_69680 = cljs.core.next.call(null,inst_69678);
var inst_69681 = cljs.core.nth.call(null,inst_69679,(0),null);
var inst_69682__$1 = cljs.core.nth.call(null,inst_69679,(1),null);
var inst_69683 = (inst_69682__$1 == null);
var state_69769__$1 = (function (){var statearr_69799 = state_69769;
(statearr_69799[(10)] = inst_69681);

(statearr_69799[(20)] = inst_69682__$1);

(statearr_69799[(18)] = inst_69680);

return statearr_69799;
})();
if(cljs.core.truth_(inst_69683)){
var statearr_69800_69871 = state_69769__$1;
(statearr_69800_69871[(1)] = (8));

} else {
var statearr_69801_69872 = state_69769__$1;
(statearr_69801_69872[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (28))){
var inst_69668 = (state_69769[(12)]);
var inst_69719 = cljs.core._EQ_.call(null,(207),inst_69668);
var state_69769__$1 = state_69769;
var statearr_69802_69873 = state_69769__$1;
(statearr_69802_69873[(2)] = inst_69719);

(statearr_69802_69873[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (25))){
var inst_69716 = (state_69769[(7)]);
var inst_69668 = (state_69769[(12)]);
var inst_69716__$1 = cljs.core._EQ_.call(null,(200),inst_69668);
var state_69769__$1 = (function (){var statearr_69803 = state_69769;
(statearr_69803[(7)] = inst_69716__$1);

return statearr_69803;
})();
if(inst_69716__$1){
var statearr_69804_69874 = state_69769__$1;
(statearr_69804_69874[(1)] = (27));

} else {
var statearr_69805_69875 = state_69769__$1;
(statearr_69805_69875[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (34))){
var state_69769__$1 = state_69769;
var statearr_69806_69876 = state_69769__$1;
(statearr_69806_69876[(2)] = null);

(statearr_69806_69876[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (17))){
var inst_69700 = (state_69769[(21)]);
var inst_69739 = (state_69769[(2)]);
var state_69769__$1 = (function (){var statearr_69807 = state_69769;
(statearr_69807[(16)] = inst_69739);

return statearr_69807;
})();
if(cljs.core.truth_(inst_69700)){
var statearr_69808_69877 = state_69769__$1;
(statearr_69808_69877[(1)] = (36));

} else {
var statearr_69809_69878 = state_69769__$1;
(statearr_69809_69878[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (3))){
var inst_69767 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69769__$1,inst_69767);
} else {
if((state_val_69770 === (12))){
var inst_69670 = (state_69769[(9)]);
var state_69769__$1 = state_69769;
var statearr_69810_69879 = state_69769__$1;
(statearr_69810_69879[(2)] = inst_69670);

(statearr_69810_69879[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (2))){
var inst_69644 = (state_69769[(22)]);
var inst_69643 = (state_69769[(23)]);
var inst_69639 = (state_69769[(24)]);
var _ = (function (){var statearr_69811 = state_69769;
(statearr_69811[(4)] = cljs.core.cons.call(null,(5),(state_69769[(4)])));

return statearr_69811;
})();
var inst_69635 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_69636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69637 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_69638 = (new cljs.core.PersistentVector(null,2,(5),inst_69636,inst_69637,null));
var inst_69639__$1 = cljs.core.get_in.call(null,flureeQL,inst_69638);
var inst_69640 = (function (){var global_block = inst_69635;
var global_meta_QMARK_ = inst_69639__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_69641 = cljs.core.PersistentHashMap.EMPTY;
var inst_69642 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_69643__$1 = cljs.core.reduce_kv.call(null,inst_69640,inst_69641,inst_69642);
var inst_69644__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_69646 = (function (){var global_block = inst_69635;
var global_meta_QMARK_ = inst_69639__$1;
var queries = inst_69643__$1;
var start_time = inst_69644__$1;
return (function (p__69645){
var vec__69812 = p__69645;
var alias = cljs.core.nth.call(null,vec__69812,(0),null);
var q = cljs.core.nth.call(null,vec__69812,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_69647 = cljs.core.map.call(null,inst_69646,inst_69643__$1);
var inst_69661 = cljs.core.seq.call(null,inst_69647);
var inst_69662 = cljs.core.first.call(null,inst_69661);
var inst_69663 = cljs.core.next.call(null,inst_69661);
var inst_69664 = cljs.core.nth.call(null,inst_69662,(0),null);
var inst_69665 = cljs.core.nth.call(null,inst_69662,(1),null);
var inst_69666 = cljs.core.PersistentHashMap.EMPTY;
var inst_69667 = inst_69647;
var inst_69668 = null;
var inst_69669 = (0);
var inst_69670 = inst_69666;
var state_69769__$1 = (function (){var statearr_69815 = state_69769;
(statearr_69815[(25)] = inst_69663);

(statearr_69815[(26)] = inst_69665);

(statearr_69815[(9)] = inst_69670);

(statearr_69815[(15)] = inst_69669);

(statearr_69815[(22)] = inst_69644__$1);

(statearr_69815[(23)] = inst_69643__$1);

(statearr_69815[(19)] = inst_69667);

(statearr_69815[(24)] = inst_69639__$1);

(statearr_69815[(12)] = inst_69668);

(statearr_69815[(27)] = inst_69664);

return statearr_69815;
})();
var statearr_69816_69880 = state_69769__$1;
(statearr_69816_69880[(2)] = null);

(statearr_69816_69880[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (23))){
var inst_69734 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69817_69881 = state_69769__$1;
(statearr_69817_69881[(2)] = inst_69734);

(statearr_69817_69881[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (35))){
var inst_69730 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69818_69882 = state_69769__$1;
(statearr_69818_69882[(2)] = inst_69730);

(statearr_69818_69882[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (19))){
var inst_69706 = (state_69769[(13)]);
var inst_69668 = (state_69769[(12)]);
var inst_69710 = cljs.core._EQ_.call(null,inst_69668,inst_69706);
var state_69769__$1 = state_69769;
if(inst_69710){
var statearr_69819_69883 = state_69769__$1;
(statearr_69819_69883[(1)] = (21));

} else {
var statearr_69820_69884 = state_69769__$1;
(statearr_69820_69884[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (11))){
var inst_69670 = (state_69769[(9)]);
var inst_69669 = (state_69769[(15)]);
var inst_69644 = (state_69769[(22)]);
var inst_69668 = (state_69769[(12)]);
var inst_69686 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_69687 = fluree.db.util.core.response_time_formatted.call(null,inst_69644);
var inst_69688 = [inst_69670,inst_69669,inst_69668,inst_69687];
var inst_69689 = cljs.core.PersistentHashMap.fromArrays(inst_69686,inst_69688);
var state_69769__$1 = state_69769;
var statearr_69822_69885 = state_69769__$1;
(statearr_69822_69885[(2)] = inst_69689);

(statearr_69822_69885[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (9))){
var inst_69681 = (state_69769[(10)]);
var inst_69643 = (state_69769[(23)]);
var inst_69682 = (state_69769[(20)]);
var inst_69695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69696 = [inst_69681,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_69697 = (new cljs.core.PersistentVector(null,2,(5),inst_69695,inst_69696,null));
var inst_69698 = cljs.core.get_in.call(null,inst_69643,inst_69697);
var inst_69699 = cljs.core.__destructure_map.call(null,inst_69698);
var inst_69700 = cljs.core.get.call(null,inst_69699,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_69701 = cljs.core.get.call(null,inst_69699,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_69769__$1 = (function (){var statearr_69823 = state_69769;
(statearr_69823[(21)] = inst_69700);

(statearr_69823[(14)] = inst_69701);

return statearr_69823;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69769__$1,(14),inst_69682);
} else {
if((state_val_69770 === (5))){
var _ = (function (){var statearr_69824 = state_69769;
(statearr_69824[(4)] = cljs.core.rest.call(null,(state_69769[(4)])));

return statearr_69824;
})();
var state_69769__$1 = state_69769;
var ex69821 = (state_69769__$1[(2)]);
var statearr_69825_69886 = state_69769__$1;
(statearr_69825_69886[(5)] = ex69821);


var statearr_69826_69887 = state_69769__$1;
(statearr_69826_69887[(1)] = (4));

(statearr_69826_69887[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (14))){
var inst_69700 = (state_69769[(21)]);
var inst_69703 = (state_69769[(11)]);
var inst_69703__$1 = (state_69769[(2)]);
var inst_69704 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_69703__$1);
var state_69769__$1 = (function (){var statearr_69827 = state_69769;
(statearr_69827[(11)] = inst_69703__$1);

(statearr_69827[(28)] = inst_69704);

return statearr_69827;
})();
if(cljs.core.truth_(inst_69700)){
var statearr_69828_69888 = state_69769__$1;
(statearr_69828_69888[(1)] = (15));

} else {
var statearr_69829_69889 = state_69769__$1;
(statearr_69829_69889[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (26))){
var inst_69723 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
if(cljs.core.truth_(inst_69723)){
var statearr_69830_69890 = state_69769__$1;
(statearr_69830_69890[(1)] = (30));

} else {
var statearr_69831_69891 = state_69769__$1;
(statearr_69831_69891[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (16))){
var state_69769__$1 = state_69769;
var statearr_69832_69892 = state_69769__$1;
(statearr_69832_69892[(2)] = null);

(statearr_69832_69892[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (38))){
var inst_69704 = (state_69769[(28)]);
var inst_69745 = (state_69769[(2)]);
var state_69769__$1 = (function (){var statearr_69833 = state_69769;
(statearr_69833[(17)] = inst_69745);

return statearr_69833;
})();
if(cljs.core.truth_(inst_69704)){
var statearr_69834_69893 = state_69769__$1;
(statearr_69834_69893[(1)] = (39));

} else {
var statearr_69835_69894 = state_69769__$1;
(statearr_69835_69894[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (30))){
var state_69769__$1 = state_69769;
var statearr_69836_69895 = state_69769__$1;
(statearr_69836_69895[(2)] = (207));

(statearr_69836_69895[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (10))){
var inst_69762 = (state_69769[(2)]);
var state_69769__$1 = state_69769;
var statearr_69837_69896 = state_69769__$1;
(statearr_69837_69896[(2)] = inst_69762);

(statearr_69837_69896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (18))){
var inst_69706 = (state_69769[(13)]);
var state_69769__$1 = state_69769;
var statearr_69838_69897 = state_69769__$1;
(statearr_69838_69897[(2)] = inst_69706);

(statearr_69838_69897[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (42))){
var inst_69703 = (state_69769[(11)]);
var inst_69753 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_69703);
var state_69769__$1 = state_69769;
var statearr_69839_69898 = state_69769__$1;
(statearr_69839_69898[(2)] = inst_69753);

(statearr_69839_69898[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (37))){
var state_69769__$1 = state_69769;
var statearr_69840_69899 = state_69769__$1;
(statearr_69840_69899[(2)] = null);

(statearr_69840_69899[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69770 === (8))){
var inst_69639 = (state_69769[(24)]);
var state_69769__$1 = state_69769;
if(cljs.core.truth_(inst_69639)){
var statearr_69841_69900 = state_69769__$1;
(statearr_69841_69900[(1)] = (11));

} else {
var statearr_69842_69901 = state_69769__$1;
(statearr_69842_69901[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_69843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69843[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_69843[(1)] = (1));

return statearr_69843;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_69769){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69769);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69844){var ex__2749__auto__ = e69844;
var statearr_69845_69902 = state_69769;
(statearr_69845_69902[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69769[(4)]))){
var statearr_69846_69903 = state_69769;
(statearr_69846_69903[(1)] = cljs.core.first.call(null,(state_69769[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69904 = state_69769;
state_69769 = G__69904;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_69769){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_69769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69847 = f__2769__auto__.call(null);
(statearr_69847[(6)] = c__2768__auto__);

return statearr_69847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__69905 = query_type;
var G__69905__$1 = (((G__69905 instanceof cljs.core.Keyword))?G__69905.fqn:null);
switch (G__69905__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69905__$1)].join('')));

}
});
