// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__5576){
var vec__5577 = p__5576;
var i = cljs.core.nth.call(null,vec__5577,(0),null);
var v = cljs.core.nth.call(null,vec__5577,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5580 = seg;
var gcol = cljs.core.nth.call(null,vec__5580,(0),null);
var source = cljs.core.nth.call(null,vec__5580,(1),null);
var line = cljs.core.nth.call(null,vec__5580,(2),null);
var col = cljs.core.nth.call(null,vec__5580,(3),null);
var name = cljs.core.nth.call(null,vec__5580,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5804__auto__)){
var name__$1 = temp__5804__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5583 = seg;
var gcol = cljs.core.nth.call(null,vec__5583,(0),null);
var source = cljs.core.nth.call(null,vec__5583,(1),null);
var line = cljs.core.nth.call(null,vec__5583,(2),null);
var col = cljs.core.nth.call(null,vec__5583,(3),null);
var name = cljs.core.nth.call(null,vec__5583,(4),null);
var vec__5586 = relseg;
var rgcol = cljs.core.nth.call(null,vec__5586,(0),null);
var rsource = cljs.core.nth.call(null,vec__5586,(1),null);
var rline = cljs.core.nth.call(null,vec__5586,(2),null);
var rcol = cljs.core.nth.call(null,vec__5586,(3),null);
var rname = cljs.core.nth.call(null,vec__5586,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__5045__auto__ = col;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5589 = segmap;
var map__5589__$1 = cljs.core.__destructure_map.call(null,map__5589);
var gcol = cljs.core.get.call(null,map__5589__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5589__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5589__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5589__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5589__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5591 = arguments.length;
switch (G__5591) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5595 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5599 = cljs.core.next.call(null,segs__$1);
var G__5600 = nrelseg;
var G__5601 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5599;
relseg__$1 = G__5600;
result__$1 = G__5601;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5595,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5595,(1),null);
var G__5602 = (gline + (1));
var G__5603 = cljs.core.next.call(null,lines__$1);
var G__5604 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5605 = result__$1;
gline = G__5602;
lines__$1 = G__5603;
relseg = G__5604;
result = G__5605;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5607 = segmap;
var map__5607__$1 = cljs.core.__destructure_map.call(null,map__5607);
var gcol = cljs.core.get.call(null,map__5607__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5607__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5607__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5607__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5607__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__5606_SHARP_){
return cljs.core.conj.call(null,p1__5606_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5609 = arguments.length;
switch (G__5609) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5613 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5617 = cljs.core.next.call(null,segs__$1);
var G__5618 = nrelseg;
var G__5619 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5617;
relseg__$1 = G__5618;
result__$1 = G__5619;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5613,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5613,(1),null);
var G__5620 = (gline + (1));
var G__5621 = cljs.core.next.call(null,lines__$1);
var G__5622 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5623 = result__$1;
gline = G__5620;
lines__$1 = G__5621;
relseg = G__5622;
result = G__5623;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__5624){
var vec__5625 = p__5624;
var _ = cljs.core.nth.call(null,vec__5625,(0),null);
var source = cljs.core.nth.call(null,vec__5625,(1),null);
var line = cljs.core.nth.call(null,vec__5625,(2),null);
var col = cljs.core.nth.call(null,vec__5625,(3),null);
var name = cljs.core.nth.call(null,vec__5625,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__5628){
var vec__5629 = p__5628;
var gcol = cljs.core.nth.call(null,vec__5629,(0),null);
var sidx = cljs.core.nth.call(null,vec__5629,(1),null);
var line = cljs.core.nth.call(null,vec__5629,(2),null);
var col = cljs.core.nth.call(null,vec__5629,(3),null);
var name = cljs.core.nth.call(null,vec__5629,(4),null);
var seg = vec__5629;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__5632){
var vec__5633 = p__5632;
var _ = cljs.core.nth.call(null,vec__5633,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__5633,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__5633,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__5633,(3),null);
var lname = cljs.core.nth.call(null,vec__5633,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5802__auto__)){
var name = temp__5802__auto__;
var idx = (function (){var temp__5802__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5639 = cljs.core.seq.call(null,infos);
var chunk__5640 = null;
var count__5641 = (0);
var i__5642 = (0);
while(true){
if((i__5642 < count__5641)){
var info = cljs.core._nth.call(null,chunk__5640,i__5642);
var segv_5993 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5994 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5995 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5994 > (lc_5995 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5639,chunk__5640,count__5641,i__5642,segv_5993,gline_5994,lc_5995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5994 - (lc_5995 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5993], null));
});})(seq__5639,chunk__5640,count__5641,i__5642,segv_5993,gline_5994,lc_5995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5639,chunk__5640,count__5641,i__5642,segv_5993,gline_5994,lc_5995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5994], null),cljs.core.conj,segv_5993);
});})(seq__5639,chunk__5640,count__5641,i__5642,segv_5993,gline_5994,lc_5995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5996 = seq__5639;
var G__5997 = chunk__5640;
var G__5998 = count__5641;
var G__5999 = (i__5642 + (1));
seq__5639 = G__5996;
chunk__5640 = G__5997;
count__5641 = G__5998;
i__5642 = G__5999;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__5639);
if(temp__5804__auto__){
var seq__5639__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5639__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__5639__$1);
var G__6000 = cljs.core.chunk_rest.call(null,seq__5639__$1);
var G__6001 = c__5568__auto__;
var G__6002 = cljs.core.count.call(null,c__5568__auto__);
var G__6003 = (0);
seq__5639 = G__6000;
chunk__5640 = G__6001;
count__5641 = G__6002;
i__5642 = G__6003;
continue;
} else {
var info = cljs.core.first.call(null,seq__5639__$1);
var segv_6004 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_6005 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6006 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_6005 > (lc_6006 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5639,chunk__5640,count__5641,i__5642,segv_6004,gline_6005,lc_6006,info,seq__5639__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_6005 - (lc_6006 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6004], null));
});})(seq__5639,chunk__5640,count__5641,i__5642,segv_6004,gline_6005,lc_6006,info,seq__5639__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5639,chunk__5640,count__5641,i__5642,segv_6004,gline_6005,lc_6006,info,seq__5639__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6005], null),cljs.core.conj,segv_6004);
});})(seq__5639,chunk__5640,count__5641,i__5642,segv_6004,gline_6005,lc_6006,info,seq__5639__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6007 = cljs.core.next.call(null,seq__5639__$1);
var G__6008 = null;
var G__6009 = (0);
var G__6010 = (0);
seq__5639 = G__6007;
chunk__5640 = G__6008;
count__5641 = G__6009;
i__5642 = G__6010;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5643_6011 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5644_6012 = null;
var count__5645_6013 = (0);
var i__5646_6014 = (0);
while(true){
if((i__5646_6014 < count__5645_6013)){
var vec__5819_6015 = cljs.core._nth.call(null,chunk__5644_6012,i__5646_6014);
var source_idx_6016 = cljs.core.nth.call(null,vec__5819_6015,(0),null);
var vec__5822_6017 = cljs.core.nth.call(null,vec__5819_6015,(1),null);
var __6018 = cljs.core.nth.call(null,vec__5822_6017,(0),null);
var lines_6019__$1 = cljs.core.nth.call(null,vec__5822_6017,(1),null);
var seq__5825_6020 = cljs.core.seq.call(null,lines_6019__$1);
var chunk__5826_6021 = null;
var count__5827_6022 = (0);
var i__5828_6023 = (0);
while(true){
if((i__5828_6023 < count__5827_6022)){
var vec__5867_6024 = cljs.core._nth.call(null,chunk__5826_6021,i__5828_6023);
var line_6025 = cljs.core.nth.call(null,vec__5867_6024,(0),null);
var cols_6026 = cljs.core.nth.call(null,vec__5867_6024,(1),null);
var seq__5870_6027 = cljs.core.seq.call(null,cols_6026);
var chunk__5871_6028 = null;
var count__5872_6029 = (0);
var i__5873_6030 = (0);
while(true){
if((i__5873_6030 < count__5872_6029)){
var vec__5880_6031 = cljs.core._nth.call(null,chunk__5871_6028,i__5873_6030);
var col_6032 = cljs.core.nth.call(null,vec__5880_6031,(0),null);
var infos_6033 = cljs.core.nth.call(null,vec__5880_6031,(1),null);
encode_cols.call(null,infos_6033,source_idx_6016,line_6025,col_6032);


var G__6034 = seq__5870_6027;
var G__6035 = chunk__5871_6028;
var G__6036 = count__5872_6029;
var G__6037 = (i__5873_6030 + (1));
seq__5870_6027 = G__6034;
chunk__5871_6028 = G__6035;
count__5872_6029 = G__6036;
i__5873_6030 = G__6037;
continue;
} else {
var temp__5804__auto___6038 = cljs.core.seq.call(null,seq__5870_6027);
if(temp__5804__auto___6038){
var seq__5870_6039__$1 = temp__5804__auto___6038;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5870_6039__$1)){
var c__5568__auto___6040 = cljs.core.chunk_first.call(null,seq__5870_6039__$1);
var G__6041 = cljs.core.chunk_rest.call(null,seq__5870_6039__$1);
var G__6042 = c__5568__auto___6040;
var G__6043 = cljs.core.count.call(null,c__5568__auto___6040);
var G__6044 = (0);
seq__5870_6027 = G__6041;
chunk__5871_6028 = G__6042;
count__5872_6029 = G__6043;
i__5873_6030 = G__6044;
continue;
} else {
var vec__5883_6045 = cljs.core.first.call(null,seq__5870_6039__$1);
var col_6046 = cljs.core.nth.call(null,vec__5883_6045,(0),null);
var infos_6047 = cljs.core.nth.call(null,vec__5883_6045,(1),null);
encode_cols.call(null,infos_6047,source_idx_6016,line_6025,col_6046);


var G__6048 = cljs.core.next.call(null,seq__5870_6039__$1);
var G__6049 = null;
var G__6050 = (0);
var G__6051 = (0);
seq__5870_6027 = G__6048;
chunk__5871_6028 = G__6049;
count__5872_6029 = G__6050;
i__5873_6030 = G__6051;
continue;
}
} else {
}
}
break;
}


var G__6052 = seq__5825_6020;
var G__6053 = chunk__5826_6021;
var G__6054 = count__5827_6022;
var G__6055 = (i__5828_6023 + (1));
seq__5825_6020 = G__6052;
chunk__5826_6021 = G__6053;
count__5827_6022 = G__6054;
i__5828_6023 = G__6055;
continue;
} else {
var temp__5804__auto___6056 = cljs.core.seq.call(null,seq__5825_6020);
if(temp__5804__auto___6056){
var seq__5825_6057__$1 = temp__5804__auto___6056;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5825_6057__$1)){
var c__5568__auto___6058 = cljs.core.chunk_first.call(null,seq__5825_6057__$1);
var G__6059 = cljs.core.chunk_rest.call(null,seq__5825_6057__$1);
var G__6060 = c__5568__auto___6058;
var G__6061 = cljs.core.count.call(null,c__5568__auto___6058);
var G__6062 = (0);
seq__5825_6020 = G__6059;
chunk__5826_6021 = G__6060;
count__5827_6022 = G__6061;
i__5828_6023 = G__6062;
continue;
} else {
var vec__5886_6063 = cljs.core.first.call(null,seq__5825_6057__$1);
var line_6064 = cljs.core.nth.call(null,vec__5886_6063,(0),null);
var cols_6065 = cljs.core.nth.call(null,vec__5886_6063,(1),null);
var seq__5889_6066 = cljs.core.seq.call(null,cols_6065);
var chunk__5890_6067 = null;
var count__5891_6068 = (0);
var i__5892_6069 = (0);
while(true){
if((i__5892_6069 < count__5891_6068)){
var vec__5899_6070 = cljs.core._nth.call(null,chunk__5890_6067,i__5892_6069);
var col_6071 = cljs.core.nth.call(null,vec__5899_6070,(0),null);
var infos_6072 = cljs.core.nth.call(null,vec__5899_6070,(1),null);
encode_cols.call(null,infos_6072,source_idx_6016,line_6064,col_6071);


var G__6073 = seq__5889_6066;
var G__6074 = chunk__5890_6067;
var G__6075 = count__5891_6068;
var G__6076 = (i__5892_6069 + (1));
seq__5889_6066 = G__6073;
chunk__5890_6067 = G__6074;
count__5891_6068 = G__6075;
i__5892_6069 = G__6076;
continue;
} else {
var temp__5804__auto___6077__$1 = cljs.core.seq.call(null,seq__5889_6066);
if(temp__5804__auto___6077__$1){
var seq__5889_6078__$1 = temp__5804__auto___6077__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5889_6078__$1)){
var c__5568__auto___6079 = cljs.core.chunk_first.call(null,seq__5889_6078__$1);
var G__6080 = cljs.core.chunk_rest.call(null,seq__5889_6078__$1);
var G__6081 = c__5568__auto___6079;
var G__6082 = cljs.core.count.call(null,c__5568__auto___6079);
var G__6083 = (0);
seq__5889_6066 = G__6080;
chunk__5890_6067 = G__6081;
count__5891_6068 = G__6082;
i__5892_6069 = G__6083;
continue;
} else {
var vec__5902_6084 = cljs.core.first.call(null,seq__5889_6078__$1);
var col_6085 = cljs.core.nth.call(null,vec__5902_6084,(0),null);
var infos_6086 = cljs.core.nth.call(null,vec__5902_6084,(1),null);
encode_cols.call(null,infos_6086,source_idx_6016,line_6064,col_6085);


var G__6087 = cljs.core.next.call(null,seq__5889_6078__$1);
var G__6088 = null;
var G__6089 = (0);
var G__6090 = (0);
seq__5889_6066 = G__6087;
chunk__5890_6067 = G__6088;
count__5891_6068 = G__6089;
i__5892_6069 = G__6090;
continue;
}
} else {
}
}
break;
}


var G__6091 = cljs.core.next.call(null,seq__5825_6057__$1);
var G__6092 = null;
var G__6093 = (0);
var G__6094 = (0);
seq__5825_6020 = G__6091;
chunk__5826_6021 = G__6092;
count__5827_6022 = G__6093;
i__5828_6023 = G__6094;
continue;
}
} else {
}
}
break;
}


var G__6095 = seq__5643_6011;
var G__6096 = chunk__5644_6012;
var G__6097 = count__5645_6013;
var G__6098 = (i__5646_6014 + (1));
seq__5643_6011 = G__6095;
chunk__5644_6012 = G__6096;
count__5645_6013 = G__6097;
i__5646_6014 = G__6098;
continue;
} else {
var temp__5804__auto___6099 = cljs.core.seq.call(null,seq__5643_6011);
if(temp__5804__auto___6099){
var seq__5643_6100__$1 = temp__5804__auto___6099;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5643_6100__$1)){
var c__5568__auto___6101 = cljs.core.chunk_first.call(null,seq__5643_6100__$1);
var G__6102 = cljs.core.chunk_rest.call(null,seq__5643_6100__$1);
var G__6103 = c__5568__auto___6101;
var G__6104 = cljs.core.count.call(null,c__5568__auto___6101);
var G__6105 = (0);
seq__5643_6011 = G__6102;
chunk__5644_6012 = G__6103;
count__5645_6013 = G__6104;
i__5646_6014 = G__6105;
continue;
} else {
var vec__5905_6106 = cljs.core.first.call(null,seq__5643_6100__$1);
var source_idx_6107 = cljs.core.nth.call(null,vec__5905_6106,(0),null);
var vec__5908_6108 = cljs.core.nth.call(null,vec__5905_6106,(1),null);
var __6109 = cljs.core.nth.call(null,vec__5908_6108,(0),null);
var lines_6110__$1 = cljs.core.nth.call(null,vec__5908_6108,(1),null);
var seq__5911_6111 = cljs.core.seq.call(null,lines_6110__$1);
var chunk__5912_6112 = null;
var count__5913_6113 = (0);
var i__5914_6114 = (0);
while(true){
if((i__5914_6114 < count__5913_6113)){
var vec__5953_6115 = cljs.core._nth.call(null,chunk__5912_6112,i__5914_6114);
var line_6116 = cljs.core.nth.call(null,vec__5953_6115,(0),null);
var cols_6117 = cljs.core.nth.call(null,vec__5953_6115,(1),null);
var seq__5956_6118 = cljs.core.seq.call(null,cols_6117);
var chunk__5957_6119 = null;
var count__5958_6120 = (0);
var i__5959_6121 = (0);
while(true){
if((i__5959_6121 < count__5958_6120)){
var vec__5966_6122 = cljs.core._nth.call(null,chunk__5957_6119,i__5959_6121);
var col_6123 = cljs.core.nth.call(null,vec__5966_6122,(0),null);
var infos_6124 = cljs.core.nth.call(null,vec__5966_6122,(1),null);
encode_cols.call(null,infos_6124,source_idx_6107,line_6116,col_6123);


var G__6125 = seq__5956_6118;
var G__6126 = chunk__5957_6119;
var G__6127 = count__5958_6120;
var G__6128 = (i__5959_6121 + (1));
seq__5956_6118 = G__6125;
chunk__5957_6119 = G__6126;
count__5958_6120 = G__6127;
i__5959_6121 = G__6128;
continue;
} else {
var temp__5804__auto___6129__$1 = cljs.core.seq.call(null,seq__5956_6118);
if(temp__5804__auto___6129__$1){
var seq__5956_6130__$1 = temp__5804__auto___6129__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5956_6130__$1)){
var c__5568__auto___6131 = cljs.core.chunk_first.call(null,seq__5956_6130__$1);
var G__6132 = cljs.core.chunk_rest.call(null,seq__5956_6130__$1);
var G__6133 = c__5568__auto___6131;
var G__6134 = cljs.core.count.call(null,c__5568__auto___6131);
var G__6135 = (0);
seq__5956_6118 = G__6132;
chunk__5957_6119 = G__6133;
count__5958_6120 = G__6134;
i__5959_6121 = G__6135;
continue;
} else {
var vec__5969_6136 = cljs.core.first.call(null,seq__5956_6130__$1);
var col_6137 = cljs.core.nth.call(null,vec__5969_6136,(0),null);
var infos_6138 = cljs.core.nth.call(null,vec__5969_6136,(1),null);
encode_cols.call(null,infos_6138,source_idx_6107,line_6116,col_6137);


var G__6139 = cljs.core.next.call(null,seq__5956_6130__$1);
var G__6140 = null;
var G__6141 = (0);
var G__6142 = (0);
seq__5956_6118 = G__6139;
chunk__5957_6119 = G__6140;
count__5958_6120 = G__6141;
i__5959_6121 = G__6142;
continue;
}
} else {
}
}
break;
}


var G__6143 = seq__5911_6111;
var G__6144 = chunk__5912_6112;
var G__6145 = count__5913_6113;
var G__6146 = (i__5914_6114 + (1));
seq__5911_6111 = G__6143;
chunk__5912_6112 = G__6144;
count__5913_6113 = G__6145;
i__5914_6114 = G__6146;
continue;
} else {
var temp__5804__auto___6147__$1 = cljs.core.seq.call(null,seq__5911_6111);
if(temp__5804__auto___6147__$1){
var seq__5911_6148__$1 = temp__5804__auto___6147__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5911_6148__$1)){
var c__5568__auto___6149 = cljs.core.chunk_first.call(null,seq__5911_6148__$1);
var G__6150 = cljs.core.chunk_rest.call(null,seq__5911_6148__$1);
var G__6151 = c__5568__auto___6149;
var G__6152 = cljs.core.count.call(null,c__5568__auto___6149);
var G__6153 = (0);
seq__5911_6111 = G__6150;
chunk__5912_6112 = G__6151;
count__5913_6113 = G__6152;
i__5914_6114 = G__6153;
continue;
} else {
var vec__5972_6154 = cljs.core.first.call(null,seq__5911_6148__$1);
var line_6155 = cljs.core.nth.call(null,vec__5972_6154,(0),null);
var cols_6156 = cljs.core.nth.call(null,vec__5972_6154,(1),null);
var seq__5975_6157 = cljs.core.seq.call(null,cols_6156);
var chunk__5976_6158 = null;
var count__5977_6159 = (0);
var i__5978_6160 = (0);
while(true){
if((i__5978_6160 < count__5977_6159)){
var vec__5985_6161 = cljs.core._nth.call(null,chunk__5976_6158,i__5978_6160);
var col_6162 = cljs.core.nth.call(null,vec__5985_6161,(0),null);
var infos_6163 = cljs.core.nth.call(null,vec__5985_6161,(1),null);
encode_cols.call(null,infos_6163,source_idx_6107,line_6155,col_6162);


var G__6164 = seq__5975_6157;
var G__6165 = chunk__5976_6158;
var G__6166 = count__5977_6159;
var G__6167 = (i__5978_6160 + (1));
seq__5975_6157 = G__6164;
chunk__5976_6158 = G__6165;
count__5977_6159 = G__6166;
i__5978_6160 = G__6167;
continue;
} else {
var temp__5804__auto___6168__$2 = cljs.core.seq.call(null,seq__5975_6157);
if(temp__5804__auto___6168__$2){
var seq__5975_6169__$1 = temp__5804__auto___6168__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5975_6169__$1)){
var c__5568__auto___6170 = cljs.core.chunk_first.call(null,seq__5975_6169__$1);
var G__6171 = cljs.core.chunk_rest.call(null,seq__5975_6169__$1);
var G__6172 = c__5568__auto___6170;
var G__6173 = cljs.core.count.call(null,c__5568__auto___6170);
var G__6174 = (0);
seq__5975_6157 = G__6171;
chunk__5976_6158 = G__6172;
count__5977_6159 = G__6173;
i__5978_6160 = G__6174;
continue;
} else {
var vec__5988_6175 = cljs.core.first.call(null,seq__5975_6169__$1);
var col_6176 = cljs.core.nth.call(null,vec__5988_6175,(0),null);
var infos_6177 = cljs.core.nth.call(null,vec__5988_6175,(1),null);
encode_cols.call(null,infos_6177,source_idx_6107,line_6155,col_6176);


var G__6178 = cljs.core.next.call(null,seq__5975_6169__$1);
var G__6179 = null;
var G__6180 = (0);
var G__6181 = (0);
seq__5975_6157 = G__6178;
chunk__5976_6158 = G__6179;
count__5977_6159 = G__6180;
i__5978_6160 = G__6181;
continue;
}
} else {
}
}
break;
}


var G__6182 = cljs.core.next.call(null,seq__5911_6148__$1);
var G__6183 = null;
var G__6184 = (0);
var G__6185 = (0);
seq__5911_6111 = G__6182;
chunk__5912_6112 = G__6183;
count__5913_6113 = G__6184;
i__5914_6114 = G__6185;
continue;
}
} else {
}
}
break;
}


var G__6186 = cljs.core.next.call(null,seq__5643_6100__$1);
var G__6187 = null;
var G__6188 = (0);
var G__6189 = (0);
seq__5643_6011 = G__6186;
chunk__5644_6012 = G__6187;
count__5645_6013 = G__6188;
i__5646_6014 = G__6189;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__5991 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5636_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5636_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5637_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__5637_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__5638_SHARP_){
return clojure.string.join.call(null,",",p1__5638_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__5992 = G__5991;
cljs.source_map.goog$module$goog$object.set.call(null,G__5992,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__5992;
} else {
return G__5991;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__6190 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__6190,(0),null);
var col_map = cljs.core.nth.call(null,vec__6190,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__6193 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__6193,(0),null);
var infos = cljs.core.nth.call(null,vec__6193,(1),null);
var G__6198 = cljs.core.next.call(null,col_map_seq);
var G__6199 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6193,col,infos,vec__6190,line,col_map){
return (function (v,p__6196){
var map__6197 = p__6196;
var map__6197__$1 = cljs.core.__destructure_map.call(null,map__6197);
var gline = cljs.core.get.call(null,map__6197__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__6197__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6193,col,infos,vec__6190,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6198;
new_cols = G__6199;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6200 = cljs.core.next.call(null,line_map_seq);
var G__6201 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__6200;
new_lines = G__6201;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__6202_6410 = cljs.core.seq.call(null,reverse_map);
var chunk__6203_6411 = null;
var count__6204_6412 = (0);
var i__6205_6413 = (0);
while(true){
if((i__6205_6413 < count__6204_6412)){
var vec__6308_6414 = cljs.core._nth.call(null,chunk__6203_6411,i__6205_6413);
var line_6415 = cljs.core.nth.call(null,vec__6308_6414,(0),null);
var columns_6416 = cljs.core.nth.call(null,vec__6308_6414,(1),null);
var seq__6311_6417 = cljs.core.seq.call(null,columns_6416);
var chunk__6312_6418 = null;
var count__6313_6419 = (0);
var i__6314_6420 = (0);
while(true){
if((i__6314_6420 < count__6313_6419)){
var vec__6337_6421 = cljs.core._nth.call(null,chunk__6312_6418,i__6314_6420);
var column_6422 = cljs.core.nth.call(null,vec__6337_6421,(0),null);
var column_info_6423 = cljs.core.nth.call(null,vec__6337_6421,(1),null);
var seq__6340_6424 = cljs.core.seq.call(null,column_info_6423);
var chunk__6341_6425 = null;
var count__6342_6426 = (0);
var i__6343_6427 = (0);
while(true){
if((i__6343_6427 < count__6342_6426)){
var map__6346_6428 = cljs.core._nth.call(null,chunk__6341_6425,i__6343_6427);
var map__6346_6429__$1 = cljs.core.__destructure_map.call(null,map__6346_6428);
var gline_6430 = cljs.core.get.call(null,map__6346_6429__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6431 = cljs.core.get.call(null,map__6346_6429__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6432 = cljs.core.get.call(null,map__6346_6429__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6430], null),cljs.core.fnil.call(null,((function (seq__6340_6424,chunk__6341_6425,count__6342_6426,i__6343_6427,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6346_6428,map__6346_6429__$1,gline_6430,gcol_6431,name_6432,vec__6337_6421,column_6422,column_info_6423,vec__6308_6414,line_6415,columns_6416,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6431], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6415,new cljs.core.Keyword(null,"col","col",-1959363084),column_6422,new cljs.core.Keyword(null,"name","name",1843675177),name_6432], null));
});})(seq__6340_6424,chunk__6341_6425,count__6342_6426,i__6343_6427,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6346_6428,map__6346_6429__$1,gline_6430,gcol_6431,name_6432,vec__6337_6421,column_6422,column_info_6423,vec__6308_6414,line_6415,columns_6416,inverted))
,cljs.core.sorted_map.call(null)));


var G__6433 = seq__6340_6424;
var G__6434 = chunk__6341_6425;
var G__6435 = count__6342_6426;
var G__6436 = (i__6343_6427 + (1));
seq__6340_6424 = G__6433;
chunk__6341_6425 = G__6434;
count__6342_6426 = G__6435;
i__6343_6427 = G__6436;
continue;
} else {
var temp__5804__auto___6437 = cljs.core.seq.call(null,seq__6340_6424);
if(temp__5804__auto___6437){
var seq__6340_6438__$1 = temp__5804__auto___6437;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6340_6438__$1)){
var c__5568__auto___6439 = cljs.core.chunk_first.call(null,seq__6340_6438__$1);
var G__6440 = cljs.core.chunk_rest.call(null,seq__6340_6438__$1);
var G__6441 = c__5568__auto___6439;
var G__6442 = cljs.core.count.call(null,c__5568__auto___6439);
var G__6443 = (0);
seq__6340_6424 = G__6440;
chunk__6341_6425 = G__6441;
count__6342_6426 = G__6442;
i__6343_6427 = G__6443;
continue;
} else {
var map__6347_6444 = cljs.core.first.call(null,seq__6340_6438__$1);
var map__6347_6445__$1 = cljs.core.__destructure_map.call(null,map__6347_6444);
var gline_6446 = cljs.core.get.call(null,map__6347_6445__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6447 = cljs.core.get.call(null,map__6347_6445__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6448 = cljs.core.get.call(null,map__6347_6445__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6446], null),cljs.core.fnil.call(null,((function (seq__6340_6424,chunk__6341_6425,count__6342_6426,i__6343_6427,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6347_6444,map__6347_6445__$1,gline_6446,gcol_6447,name_6448,seq__6340_6438__$1,temp__5804__auto___6437,vec__6337_6421,column_6422,column_info_6423,vec__6308_6414,line_6415,columns_6416,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6447], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6415,new cljs.core.Keyword(null,"col","col",-1959363084),column_6422,new cljs.core.Keyword(null,"name","name",1843675177),name_6448], null));
});})(seq__6340_6424,chunk__6341_6425,count__6342_6426,i__6343_6427,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6347_6444,map__6347_6445__$1,gline_6446,gcol_6447,name_6448,seq__6340_6438__$1,temp__5804__auto___6437,vec__6337_6421,column_6422,column_info_6423,vec__6308_6414,line_6415,columns_6416,inverted))
,cljs.core.sorted_map.call(null)));


var G__6449 = cljs.core.next.call(null,seq__6340_6438__$1);
var G__6450 = null;
var G__6451 = (0);
var G__6452 = (0);
seq__6340_6424 = G__6449;
chunk__6341_6425 = G__6450;
count__6342_6426 = G__6451;
i__6343_6427 = G__6452;
continue;
}
} else {
}
}
break;
}


var G__6453 = seq__6311_6417;
var G__6454 = chunk__6312_6418;
var G__6455 = count__6313_6419;
var G__6456 = (i__6314_6420 + (1));
seq__6311_6417 = G__6453;
chunk__6312_6418 = G__6454;
count__6313_6419 = G__6455;
i__6314_6420 = G__6456;
continue;
} else {
var temp__5804__auto___6457 = cljs.core.seq.call(null,seq__6311_6417);
if(temp__5804__auto___6457){
var seq__6311_6458__$1 = temp__5804__auto___6457;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6311_6458__$1)){
var c__5568__auto___6459 = cljs.core.chunk_first.call(null,seq__6311_6458__$1);
var G__6460 = cljs.core.chunk_rest.call(null,seq__6311_6458__$1);
var G__6461 = c__5568__auto___6459;
var G__6462 = cljs.core.count.call(null,c__5568__auto___6459);
var G__6463 = (0);
seq__6311_6417 = G__6460;
chunk__6312_6418 = G__6461;
count__6313_6419 = G__6462;
i__6314_6420 = G__6463;
continue;
} else {
var vec__6348_6464 = cljs.core.first.call(null,seq__6311_6458__$1);
var column_6465 = cljs.core.nth.call(null,vec__6348_6464,(0),null);
var column_info_6466 = cljs.core.nth.call(null,vec__6348_6464,(1),null);
var seq__6351_6467 = cljs.core.seq.call(null,column_info_6466);
var chunk__6352_6468 = null;
var count__6353_6469 = (0);
var i__6354_6470 = (0);
while(true){
if((i__6354_6470 < count__6353_6469)){
var map__6357_6471 = cljs.core._nth.call(null,chunk__6352_6468,i__6354_6470);
var map__6357_6472__$1 = cljs.core.__destructure_map.call(null,map__6357_6471);
var gline_6473 = cljs.core.get.call(null,map__6357_6472__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6474 = cljs.core.get.call(null,map__6357_6472__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6475 = cljs.core.get.call(null,map__6357_6472__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6473], null),cljs.core.fnil.call(null,((function (seq__6351_6467,chunk__6352_6468,count__6353_6469,i__6354_6470,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6357_6471,map__6357_6472__$1,gline_6473,gcol_6474,name_6475,vec__6348_6464,column_6465,column_info_6466,seq__6311_6458__$1,temp__5804__auto___6457,vec__6308_6414,line_6415,columns_6416,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6474], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6415,new cljs.core.Keyword(null,"col","col",-1959363084),column_6465,new cljs.core.Keyword(null,"name","name",1843675177),name_6475], null));
});})(seq__6351_6467,chunk__6352_6468,count__6353_6469,i__6354_6470,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6357_6471,map__6357_6472__$1,gline_6473,gcol_6474,name_6475,vec__6348_6464,column_6465,column_info_6466,seq__6311_6458__$1,temp__5804__auto___6457,vec__6308_6414,line_6415,columns_6416,inverted))
,cljs.core.sorted_map.call(null)));


var G__6476 = seq__6351_6467;
var G__6477 = chunk__6352_6468;
var G__6478 = count__6353_6469;
var G__6479 = (i__6354_6470 + (1));
seq__6351_6467 = G__6476;
chunk__6352_6468 = G__6477;
count__6353_6469 = G__6478;
i__6354_6470 = G__6479;
continue;
} else {
var temp__5804__auto___6480__$1 = cljs.core.seq.call(null,seq__6351_6467);
if(temp__5804__auto___6480__$1){
var seq__6351_6481__$1 = temp__5804__auto___6480__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6351_6481__$1)){
var c__5568__auto___6482 = cljs.core.chunk_first.call(null,seq__6351_6481__$1);
var G__6483 = cljs.core.chunk_rest.call(null,seq__6351_6481__$1);
var G__6484 = c__5568__auto___6482;
var G__6485 = cljs.core.count.call(null,c__5568__auto___6482);
var G__6486 = (0);
seq__6351_6467 = G__6483;
chunk__6352_6468 = G__6484;
count__6353_6469 = G__6485;
i__6354_6470 = G__6486;
continue;
} else {
var map__6358_6487 = cljs.core.first.call(null,seq__6351_6481__$1);
var map__6358_6488__$1 = cljs.core.__destructure_map.call(null,map__6358_6487);
var gline_6489 = cljs.core.get.call(null,map__6358_6488__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6490 = cljs.core.get.call(null,map__6358_6488__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6491 = cljs.core.get.call(null,map__6358_6488__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6489], null),cljs.core.fnil.call(null,((function (seq__6351_6467,chunk__6352_6468,count__6353_6469,i__6354_6470,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6358_6487,map__6358_6488__$1,gline_6489,gcol_6490,name_6491,seq__6351_6481__$1,temp__5804__auto___6480__$1,vec__6348_6464,column_6465,column_info_6466,seq__6311_6458__$1,temp__5804__auto___6457,vec__6308_6414,line_6415,columns_6416,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6490], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6415,new cljs.core.Keyword(null,"col","col",-1959363084),column_6465,new cljs.core.Keyword(null,"name","name",1843675177),name_6491], null));
});})(seq__6351_6467,chunk__6352_6468,count__6353_6469,i__6354_6470,seq__6311_6417,chunk__6312_6418,count__6313_6419,i__6314_6420,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6358_6487,map__6358_6488__$1,gline_6489,gcol_6490,name_6491,seq__6351_6481__$1,temp__5804__auto___6480__$1,vec__6348_6464,column_6465,column_info_6466,seq__6311_6458__$1,temp__5804__auto___6457,vec__6308_6414,line_6415,columns_6416,inverted))
,cljs.core.sorted_map.call(null)));


var G__6492 = cljs.core.next.call(null,seq__6351_6481__$1);
var G__6493 = null;
var G__6494 = (0);
var G__6495 = (0);
seq__6351_6467 = G__6492;
chunk__6352_6468 = G__6493;
count__6353_6469 = G__6494;
i__6354_6470 = G__6495;
continue;
}
} else {
}
}
break;
}


var G__6496 = cljs.core.next.call(null,seq__6311_6458__$1);
var G__6497 = null;
var G__6498 = (0);
var G__6499 = (0);
seq__6311_6417 = G__6496;
chunk__6312_6418 = G__6497;
count__6313_6419 = G__6498;
i__6314_6420 = G__6499;
continue;
}
} else {
}
}
break;
}


var G__6500 = seq__6202_6410;
var G__6501 = chunk__6203_6411;
var G__6502 = count__6204_6412;
var G__6503 = (i__6205_6413 + (1));
seq__6202_6410 = G__6500;
chunk__6203_6411 = G__6501;
count__6204_6412 = G__6502;
i__6205_6413 = G__6503;
continue;
} else {
var temp__5804__auto___6504 = cljs.core.seq.call(null,seq__6202_6410);
if(temp__5804__auto___6504){
var seq__6202_6505__$1 = temp__5804__auto___6504;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6202_6505__$1)){
var c__5568__auto___6506 = cljs.core.chunk_first.call(null,seq__6202_6505__$1);
var G__6507 = cljs.core.chunk_rest.call(null,seq__6202_6505__$1);
var G__6508 = c__5568__auto___6506;
var G__6509 = cljs.core.count.call(null,c__5568__auto___6506);
var G__6510 = (0);
seq__6202_6410 = G__6507;
chunk__6203_6411 = G__6508;
count__6204_6412 = G__6509;
i__6205_6413 = G__6510;
continue;
} else {
var vec__6359_6511 = cljs.core.first.call(null,seq__6202_6505__$1);
var line_6512 = cljs.core.nth.call(null,vec__6359_6511,(0),null);
var columns_6513 = cljs.core.nth.call(null,vec__6359_6511,(1),null);
var seq__6362_6514 = cljs.core.seq.call(null,columns_6513);
var chunk__6363_6515 = null;
var count__6364_6516 = (0);
var i__6365_6517 = (0);
while(true){
if((i__6365_6517 < count__6364_6516)){
var vec__6388_6518 = cljs.core._nth.call(null,chunk__6363_6515,i__6365_6517);
var column_6519 = cljs.core.nth.call(null,vec__6388_6518,(0),null);
var column_info_6520 = cljs.core.nth.call(null,vec__6388_6518,(1),null);
var seq__6391_6521 = cljs.core.seq.call(null,column_info_6520);
var chunk__6392_6522 = null;
var count__6393_6523 = (0);
var i__6394_6524 = (0);
while(true){
if((i__6394_6524 < count__6393_6523)){
var map__6397_6525 = cljs.core._nth.call(null,chunk__6392_6522,i__6394_6524);
var map__6397_6526__$1 = cljs.core.__destructure_map.call(null,map__6397_6525);
var gline_6527 = cljs.core.get.call(null,map__6397_6526__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6528 = cljs.core.get.call(null,map__6397_6526__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6529 = cljs.core.get.call(null,map__6397_6526__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6527], null),cljs.core.fnil.call(null,((function (seq__6391_6521,chunk__6392_6522,count__6393_6523,i__6394_6524,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6397_6525,map__6397_6526__$1,gline_6527,gcol_6528,name_6529,vec__6388_6518,column_6519,column_info_6520,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6528], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6512,new cljs.core.Keyword(null,"col","col",-1959363084),column_6519,new cljs.core.Keyword(null,"name","name",1843675177),name_6529], null));
});})(seq__6391_6521,chunk__6392_6522,count__6393_6523,i__6394_6524,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6397_6525,map__6397_6526__$1,gline_6527,gcol_6528,name_6529,vec__6388_6518,column_6519,column_info_6520,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted))
,cljs.core.sorted_map.call(null)));


var G__6530 = seq__6391_6521;
var G__6531 = chunk__6392_6522;
var G__6532 = count__6393_6523;
var G__6533 = (i__6394_6524 + (1));
seq__6391_6521 = G__6530;
chunk__6392_6522 = G__6531;
count__6393_6523 = G__6532;
i__6394_6524 = G__6533;
continue;
} else {
var temp__5804__auto___6534__$1 = cljs.core.seq.call(null,seq__6391_6521);
if(temp__5804__auto___6534__$1){
var seq__6391_6535__$1 = temp__5804__auto___6534__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6391_6535__$1)){
var c__5568__auto___6536 = cljs.core.chunk_first.call(null,seq__6391_6535__$1);
var G__6537 = cljs.core.chunk_rest.call(null,seq__6391_6535__$1);
var G__6538 = c__5568__auto___6536;
var G__6539 = cljs.core.count.call(null,c__5568__auto___6536);
var G__6540 = (0);
seq__6391_6521 = G__6537;
chunk__6392_6522 = G__6538;
count__6393_6523 = G__6539;
i__6394_6524 = G__6540;
continue;
} else {
var map__6398_6541 = cljs.core.first.call(null,seq__6391_6535__$1);
var map__6398_6542__$1 = cljs.core.__destructure_map.call(null,map__6398_6541);
var gline_6543 = cljs.core.get.call(null,map__6398_6542__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6544 = cljs.core.get.call(null,map__6398_6542__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6545 = cljs.core.get.call(null,map__6398_6542__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6543], null),cljs.core.fnil.call(null,((function (seq__6391_6521,chunk__6392_6522,count__6393_6523,i__6394_6524,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6398_6541,map__6398_6542__$1,gline_6543,gcol_6544,name_6545,seq__6391_6535__$1,temp__5804__auto___6534__$1,vec__6388_6518,column_6519,column_info_6520,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6544], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6512,new cljs.core.Keyword(null,"col","col",-1959363084),column_6519,new cljs.core.Keyword(null,"name","name",1843675177),name_6545], null));
});})(seq__6391_6521,chunk__6392_6522,count__6393_6523,i__6394_6524,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6398_6541,map__6398_6542__$1,gline_6543,gcol_6544,name_6545,seq__6391_6535__$1,temp__5804__auto___6534__$1,vec__6388_6518,column_6519,column_info_6520,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted))
,cljs.core.sorted_map.call(null)));


var G__6546 = cljs.core.next.call(null,seq__6391_6535__$1);
var G__6547 = null;
var G__6548 = (0);
var G__6549 = (0);
seq__6391_6521 = G__6546;
chunk__6392_6522 = G__6547;
count__6393_6523 = G__6548;
i__6394_6524 = G__6549;
continue;
}
} else {
}
}
break;
}


var G__6550 = seq__6362_6514;
var G__6551 = chunk__6363_6515;
var G__6552 = count__6364_6516;
var G__6553 = (i__6365_6517 + (1));
seq__6362_6514 = G__6550;
chunk__6363_6515 = G__6551;
count__6364_6516 = G__6552;
i__6365_6517 = G__6553;
continue;
} else {
var temp__5804__auto___6554__$1 = cljs.core.seq.call(null,seq__6362_6514);
if(temp__5804__auto___6554__$1){
var seq__6362_6555__$1 = temp__5804__auto___6554__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6362_6555__$1)){
var c__5568__auto___6556 = cljs.core.chunk_first.call(null,seq__6362_6555__$1);
var G__6557 = cljs.core.chunk_rest.call(null,seq__6362_6555__$1);
var G__6558 = c__5568__auto___6556;
var G__6559 = cljs.core.count.call(null,c__5568__auto___6556);
var G__6560 = (0);
seq__6362_6514 = G__6557;
chunk__6363_6515 = G__6558;
count__6364_6516 = G__6559;
i__6365_6517 = G__6560;
continue;
} else {
var vec__6399_6561 = cljs.core.first.call(null,seq__6362_6555__$1);
var column_6562 = cljs.core.nth.call(null,vec__6399_6561,(0),null);
var column_info_6563 = cljs.core.nth.call(null,vec__6399_6561,(1),null);
var seq__6402_6564 = cljs.core.seq.call(null,column_info_6563);
var chunk__6403_6565 = null;
var count__6404_6566 = (0);
var i__6405_6567 = (0);
while(true){
if((i__6405_6567 < count__6404_6566)){
var map__6408_6568 = cljs.core._nth.call(null,chunk__6403_6565,i__6405_6567);
var map__6408_6569__$1 = cljs.core.__destructure_map.call(null,map__6408_6568);
var gline_6570 = cljs.core.get.call(null,map__6408_6569__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6571 = cljs.core.get.call(null,map__6408_6569__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6572 = cljs.core.get.call(null,map__6408_6569__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6570], null),cljs.core.fnil.call(null,((function (seq__6402_6564,chunk__6403_6565,count__6404_6566,i__6405_6567,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6408_6568,map__6408_6569__$1,gline_6570,gcol_6571,name_6572,vec__6399_6561,column_6562,column_info_6563,seq__6362_6555__$1,temp__5804__auto___6554__$1,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6571], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6512,new cljs.core.Keyword(null,"col","col",-1959363084),column_6562,new cljs.core.Keyword(null,"name","name",1843675177),name_6572], null));
});})(seq__6402_6564,chunk__6403_6565,count__6404_6566,i__6405_6567,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6408_6568,map__6408_6569__$1,gline_6570,gcol_6571,name_6572,vec__6399_6561,column_6562,column_info_6563,seq__6362_6555__$1,temp__5804__auto___6554__$1,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted))
,cljs.core.sorted_map.call(null)));


var G__6573 = seq__6402_6564;
var G__6574 = chunk__6403_6565;
var G__6575 = count__6404_6566;
var G__6576 = (i__6405_6567 + (1));
seq__6402_6564 = G__6573;
chunk__6403_6565 = G__6574;
count__6404_6566 = G__6575;
i__6405_6567 = G__6576;
continue;
} else {
var temp__5804__auto___6577__$2 = cljs.core.seq.call(null,seq__6402_6564);
if(temp__5804__auto___6577__$2){
var seq__6402_6578__$1 = temp__5804__auto___6577__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6402_6578__$1)){
var c__5568__auto___6579 = cljs.core.chunk_first.call(null,seq__6402_6578__$1);
var G__6580 = cljs.core.chunk_rest.call(null,seq__6402_6578__$1);
var G__6581 = c__5568__auto___6579;
var G__6582 = cljs.core.count.call(null,c__5568__auto___6579);
var G__6583 = (0);
seq__6402_6564 = G__6580;
chunk__6403_6565 = G__6581;
count__6404_6566 = G__6582;
i__6405_6567 = G__6583;
continue;
} else {
var map__6409_6584 = cljs.core.first.call(null,seq__6402_6578__$1);
var map__6409_6585__$1 = cljs.core.__destructure_map.call(null,map__6409_6584);
var gline_6586 = cljs.core.get.call(null,map__6409_6585__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6587 = cljs.core.get.call(null,map__6409_6585__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6588 = cljs.core.get.call(null,map__6409_6585__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6586], null),cljs.core.fnil.call(null,((function (seq__6402_6564,chunk__6403_6565,count__6404_6566,i__6405_6567,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6409_6584,map__6409_6585__$1,gline_6586,gcol_6587,name_6588,seq__6402_6578__$1,temp__5804__auto___6577__$2,vec__6399_6561,column_6562,column_info_6563,seq__6362_6555__$1,temp__5804__auto___6554__$1,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6587], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6512,new cljs.core.Keyword(null,"col","col",-1959363084),column_6562,new cljs.core.Keyword(null,"name","name",1843675177),name_6588], null));
});})(seq__6402_6564,chunk__6403_6565,count__6404_6566,i__6405_6567,seq__6362_6514,chunk__6363_6515,count__6364_6516,i__6365_6517,seq__6202_6410,chunk__6203_6411,count__6204_6412,i__6205_6413,map__6409_6584,map__6409_6585__$1,gline_6586,gcol_6587,name_6588,seq__6402_6578__$1,temp__5804__auto___6577__$2,vec__6399_6561,column_6562,column_info_6563,seq__6362_6555__$1,temp__5804__auto___6554__$1,vec__6359_6511,line_6512,columns_6513,seq__6202_6505__$1,temp__5804__auto___6504,inverted))
,cljs.core.sorted_map.call(null)));


var G__6589 = cljs.core.next.call(null,seq__6402_6578__$1);
var G__6590 = null;
var G__6591 = (0);
var G__6592 = (0);
seq__6402_6564 = G__6589;
chunk__6403_6565 = G__6590;
count__6404_6566 = G__6591;
i__6405_6567 = G__6592;
continue;
}
} else {
}
}
break;
}


var G__6593 = cljs.core.next.call(null,seq__6362_6555__$1);
var G__6594 = null;
var G__6595 = (0);
var G__6596 = (0);
seq__6362_6514 = G__6593;
chunk__6363_6515 = G__6594;
count__6364_6516 = G__6595;
i__6365_6517 = G__6596;
continue;
}
} else {
}
}
break;
}


var G__6597 = cljs.core.next.call(null,seq__6202_6505__$1);
var G__6598 = null;
var G__6599 = (0);
var G__6600 = (0);
seq__6202_6410 = G__6597;
chunk__6203_6411 = G__6598;
count__6204_6412 = G__6599;
i__6205_6413 = G__6600;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
