// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23811,error_ch,vars,p__23812){
var map__23813 = p__23811;
var map__23813__$1 = cljs.core.__destructure_map(map__23813);
var db = map__23813__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23813__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23813__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23813__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23814 = p__23812;
var map__23814__$1 = cljs.core.__destructure_map(map__23814);
var _where_clause = map__23814__$1;
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23814__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23814__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23814__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23815 = (function (){var G__23818 = idx;
var G__23818__$1 = (((G__23818 instanceof cljs.core.Keyword))?G__23818.fqn:null);
switch (G__23818__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23818__$1)].join('')));

}
})();
var fflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23815,(0),null);
var lflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23815,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23809_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o_STAR_,fluree.db.flake.o(p1__23809_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23810_SHARP_){
var G__23819 = fluree.db.flake.o(p1__23810_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23819) : f.call(null,G__23819));
});
})():null));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fflake,lflake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,cljs.core.get.cljs$core$IFn$_invoke$arity$2(novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((10),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0()));
var c__2749__auto___23889 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23858){
var state_val_23859 = (state_23858[(1)]);
if((state_val_23859 === (7))){
var inst_23854 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
var statearr_23860_23890 = state_23858__$1;
(statearr_23860_23890[(2)] = inst_23854);

(statearr_23860_23890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (1))){
var state_23858__$1 = state_23858;
var statearr_23861_23891 = state_23858__$1;
(statearr_23861_23891[(2)] = null);

(statearr_23861_23891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (4))){
var inst_23822 = (state_23858[(7)]);
var inst_23822__$1 = (state_23858[(2)]);
var inst_23823 = (inst_23822__$1 == null);
var state_23858__$1 = (function (){var statearr_23862 = state_23858;
(statearr_23862[(7)] = inst_23822__$1);

return statearr_23862;
})();
if(cljs.core.truth_(inst_23823)){
var statearr_23863_23892 = state_23858__$1;
(statearr_23863_23892[(1)] = (5));

} else {
var statearr_23864_23893 = state_23858__$1;
(statearr_23864_23893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (15))){
var state_23858__$1 = state_23858;
var statearr_23865_23894 = state_23858__$1;
(statearr_23865_23894[(2)] = false);

(statearr_23865_23894[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (13))){
var inst_23834 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
if(cljs.core.truth_(inst_23834)){
var statearr_23866_23895 = state_23858__$1;
(statearr_23866_23895[(1)] = (14));

} else {
var statearr_23867_23896 = state_23858__$1;
(statearr_23867_23896[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (6))){
var inst_23822 = (state_23858[(7)]);
var inst_23827 = cljs.core.seq(inst_23822);
var inst_23828 = inst_23827;
var inst_23829 = (0);
var state_23858__$1 = (function (){var statearr_23868 = state_23858;
(statearr_23868[(8)] = inst_23829);

(statearr_23868[(9)] = inst_23828);

return statearr_23868;
})();
var statearr_23869_23897 = state_23858__$1;
(statearr_23869_23897[(2)] = null);

(statearr_23869_23897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (17))){
var state_23858__$1 = state_23858;
var statearr_23870_23898 = state_23858__$1;
(statearr_23870_23898[(2)] = null);

(statearr_23870_23898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (3))){
var inst_23856 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23858__$1,inst_23856);
} else {
if((state_val_23859 === (12))){
var inst_23844 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
var statearr_23871_23899 = state_23858__$1;
(statearr_23871_23899[(2)] = inst_23844);

(statearr_23871_23899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (2))){
var state_23858__$1 = state_23858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23858__$1,(4),tree_chan);
} else {
if((state_val_23859 === (19))){
var inst_23852 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
var statearr_23872_23900 = state_23858__$1;
(statearr_23872_23900[(2)] = inst_23852);

(statearr_23872_23900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (11))){
var state_23858__$1 = state_23858;
var statearr_23873_23901 = state_23858__$1;
(statearr_23873_23901[(2)] = true);

(statearr_23873_23901[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (9))){
var inst_23846 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
if(cljs.core.truth_(inst_23846)){
var statearr_23874_23902 = state_23858__$1;
(statearr_23874_23902[(1)] = (17));

} else {
var statearr_23875_23903 = state_23858__$1;
(statearr_23875_23903[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (5))){
var inst_23825 = cljs.core.async.close_BANG_(return_chan);
var state_23858__$1 = state_23858;
var statearr_23876_23904 = state_23858__$1;
(statearr_23876_23904[(2)] = inst_23825);

(statearr_23876_23904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (14))){
var inst_23829 = (state_23858[(8)]);
var inst_23828 = (state_23858[(9)]);
var inst_23836 = cljs.core.next(inst_23828);
var inst_23837 = (inst_23829 + (1));
var inst_23828__$1 = inst_23836;
var inst_23829__$1 = inst_23837;
var state_23858__$1 = (function (){var statearr_23877 = state_23858;
(statearr_23877[(8)] = inst_23829__$1);

(statearr_23877[(9)] = inst_23828__$1);

return statearr_23877;
})();
var statearr_23878_23905 = state_23858__$1;
(statearr_23878_23905[(2)] = null);

(statearr_23878_23905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (16))){
var inst_23841 = (state_23858[(2)]);
var state_23858__$1 = state_23858;
var statearr_23879_23906 = state_23858__$1;
(statearr_23879_23906[(2)] = inst_23841);

(statearr_23879_23906[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (10))){
var inst_23828 = (state_23858[(9)]);
var inst_23832 = cljs.core.first(inst_23828);
var state_23858__$1 = state_23858;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23858__$1,(13),return_chan,inst_23832);
} else {
if((state_val_23859 === (18))){
var inst_23850 = cljs.core.async.close_BANG_(return_chan);
var state_23858__$1 = state_23858;
var statearr_23880_23907 = state_23858__$1;
(statearr_23880_23907[(2)] = inst_23850);

(statearr_23880_23907[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23859 === (8))){
var inst_23828 = (state_23858[(9)]);
var state_23858__$1 = state_23858;
if(cljs.core.truth_(inst_23828)){
var statearr_23881_23908 = state_23858__$1;
(statearr_23881_23908[(1)] = (10));

} else {
var statearr_23882_23909 = state_23858__$1;
(statearr_23882_23909[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_23883 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23883[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__);

(statearr_23883[(1)] = (1));

return statearr_23883;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1 = (function (state_23858){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23858);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23884){var ex__2730__auto__ = e23884;
var statearr_23885_23910 = state_23858;
(statearr_23885_23910[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23858[(4)]))){
var statearr_23886_23911 = state_23858;
(statearr_23886_23911[(1)] = cljs.core.first((state_23858[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23912 = state_23858;
state_23858 = G__23912;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = function(state_23858){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1.call(this,state_23858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23887 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23887[(6)] = c__2749__auto___23889);

return statearr_23887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23913){
var map__23914 = p__23913;
var map__23914__$1 = cljs.core.__destructure_map(map__23914);
var _opts = map__23914__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23914__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn(db):null);
return (function (sid,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23959){
var state_val_23960 = (state_23959[(1)]);
if((state_val_23960 === (7))){
var inst_23930 = (state_23959[(7)]);
var inst_23932 = fluree.db.query.subject_crawl.common.filter_subject(vars,filter_map,inst_23930);
var state_23959__$1 = state_23959;
var statearr_23961_23997 = state_23959__$1;
(statearr_23961_23997[(2)] = inst_23932);

(statearr_23961_23997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (1))){
var state_23959__$1 = state_23959;
var statearr_23962_23998 = state_23959__$1;
(statearr_23962_23998[(2)] = null);

(statearr_23962_23998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (4))){
var inst_23915 = (state_23959[(2)]);
var inst_23916 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23915);
var inst_23917 = cljs.core.async.close_BANG_(port);
var state_23959__$1 = (function (){var statearr_23963 = state_23959;
(statearr_23963[(8)] = inst_23917);

(statearr_23963[(9)] = inst_23916);

return statearr_23963;
})();
var statearr_23964_23999 = state_23959__$1;
(statearr_23964_23999[(2)] = null);

(statearr_23964_23999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (15))){
var inst_23947 = (state_23959[(10)]);
var inst_23947__$1 = (state_23959[(2)]);
var inst_23948 = cljs.core.seq(inst_23947__$1);
var state_23959__$1 = (function (){var statearr_23965 = state_23959;
(statearr_23965[(10)] = inst_23947__$1);

return statearr_23965;
})();
if(inst_23948){
var statearr_23966_24000 = state_23959__$1;
(statearr_23966_24000[(1)] = (17));

} else {
var statearr_23967_24001 = state_23959__$1;
(statearr_23967_24001[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (13))){
var inst_23940 = (state_23959[(11)]);
var state_23959__$1 = state_23959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23959__$1,(16),inst_23940);
} else {
if((state_val_23960 === (6))){
var inst_23929 = (state_23959[(2)]);
var inst_23930 = fluree.db.util.async.throw_err(inst_23929);
var state_23959__$1 = (function (){var statearr_23968 = state_23959;
(statearr_23968[(7)] = inst_23930);

return statearr_23968;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23969_24002 = state_23959__$1;
(statearr_23969_24002[(1)] = (7));

} else {
var statearr_23970_24003 = state_23959__$1;
(statearr_23970_24003[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (17))){
var inst_23947 = (state_23959[(10)]);
var inst_23950 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23947);
var state_23959__$1 = state_23959;
var statearr_23971_24004 = state_23959__$1;
(statearr_23971_24004[(2)] = inst_23950);

(statearr_23971_24004[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (3))){
var inst_23957 = (state_23959[(2)]);
var state_23959__$1 = state_23959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23959__$1,inst_23957);
} else {
if((state_val_23960 === (12))){
var inst_23940 = (state_23959[(2)]);
var state_23959__$1 = (function (){var statearr_23972 = state_23959;
(statearr_23972[(11)] = inst_23940);

return statearr_23972;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23973_24005 = state_23959__$1;
(statearr_23973_24005[(1)] = (13));

} else {
var statearr_23974_24006 = state_23959__$1;
(statearr_23974_24006[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (2))){
var _ = (function (){var statearr_23975 = state_23959;
(statearr_23975[(4)] = cljs.core.cons((5),(state_23959[(4)])));

return statearr_23975;
})();
var inst_23924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23925 = [sid];
var inst_23926 = (new cljs.core.PersistentVector(null,1,(5),inst_23924,inst_23925,null));
var inst_23927 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23926);
var state_23959__$1 = state_23959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23959__$1,(6),inst_23927);
} else {
if((state_val_23960 === (19))){
var inst_23953 = (state_23959[(2)]);
var inst_23954 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_23976 = state_23959;
(statearr_23976[(4)] = cljs.core.rest((state_23959[(4)])));

return statearr_23976;
})();
var state_23959__$1 = (function (){var statearr_23977 = state_23959;
(statearr_23977[(12)] = inst_23953);

return statearr_23977;
})();
var statearr_23978_24007 = state_23959__$1;
(statearr_23978_24007[(2)] = inst_23954);

(statearr_23978_24007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (11))){
var inst_23935 = (state_23959[(13)]);
var state_23959__$1 = state_23959;
var statearr_23980_24008 = state_23959__$1;
(statearr_23980_24008[(2)] = inst_23935);

(statearr_23980_24008[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (9))){
var inst_23935 = (state_23959[(2)]);
var state_23959__$1 = (function (){var statearr_23981 = state_23959;
(statearr_23981[(13)] = inst_23935);

return statearr_23981;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23982_24009 = state_23959__$1;
(statearr_23982_24009[(1)] = (10));

} else {
var statearr_23983_24010 = state_23959__$1;
(statearr_23983_24010[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (5))){
var _ = (function (){var statearr_23984 = state_23959;
(statearr_23984[(4)] = cljs.core.rest((state_23959[(4)])));

return statearr_23984;
})();
var state_23959__$1 = state_23959;
var ex23979 = (state_23959__$1[(2)]);
var statearr_23985_24011 = state_23959__$1;
(statearr_23985_24011[(5)] = ex23979);


var statearr_23986_24012 = state_23959__$1;
(statearr_23986_24012[(1)] = (4));

(statearr_23986_24012[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (14))){
var inst_23940 = (state_23959[(11)]);
var state_23959__$1 = state_23959;
var statearr_23987_24013 = state_23959__$1;
(statearr_23987_24013[(2)] = inst_23940);

(statearr_23987_24013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (16))){
var inst_23943 = (state_23959[(2)]);
var inst_23944 = fluree.db.util.async.throw_err(inst_23943);
var state_23959__$1 = state_23959;
var statearr_23988_24014 = state_23959__$1;
(statearr_23988_24014[(2)] = inst_23944);

(statearr_23988_24014[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (10))){
var inst_23935 = (state_23959[(13)]);
var inst_23937 = (permissions.cljs$core$IFn$_invoke$arity$1 ? permissions.cljs$core$IFn$_invoke$arity$1(inst_23935) : permissions.call(null,inst_23935));
var state_23959__$1 = state_23959;
var statearr_23989_24015 = state_23959__$1;
(statearr_23989_24015[(2)] = inst_23937);

(statearr_23989_24015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (18))){
var state_23959__$1 = state_23959;
var statearr_23990_24016 = state_23959__$1;
(statearr_23990_24016[(2)] = null);

(statearr_23990_24016[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23960 === (8))){
var inst_23930 = (state_23959[(7)]);
var state_23959__$1 = state_23959;
var statearr_23991_24017 = state_23959__$1;
(statearr_23991_24017[(2)] = inst_23930);

(statearr_23991_24017[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0 = (function (){
var statearr_23992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23992[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__);

(statearr_23992[(1)] = (1));

return statearr_23992;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1 = (function (state_23959){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23959);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23993){var ex__2730__auto__ = e23993;
var statearr_23994_24018 = state_23959;
(statearr_23994_24018[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23959[(4)]))){
var statearr_23995_24019 = state_23959;
(statearr_23995_24019[(1)] = cljs.core.first((state_23959[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24020 = state_23959;
state_23959 = G__24020;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = function(state_23959){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1.call(this,state_23959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23996 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23996[(6)] = c__2749__auto__);

return statearr_23996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__24021){
var map__24022 = p__24021;
var map__24022__$1 = cljs.core.__destructure_map(map__24022);
var f_where = map__24022__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2749__auto___24059 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24042){
var state_val_24043 = (state_24042[(1)]);
if((state_val_24043 === (7))){
var inst_24030 = (state_24042[(7)]);
var inst_24033 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_24030);
var state_24042__$1 = state_24042;
var statearr_24044_24060 = state_24042__$1;
(statearr_24044_24060[(2)] = inst_24033);

(statearr_24044_24060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24043 === (1))){
var inst_24023 = typeof _id_val === 'number';
var state_24042__$1 = state_24042;
if(cljs.core.truth_(inst_24023)){
var statearr_24045_24061 = state_24042__$1;
(statearr_24045_24061[(1)] = (2));

} else {
var statearr_24046_24062 = state_24042__$1;
(statearr_24046_24062[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24043 === (4))){
var inst_24039 = (state_24042[(2)]);
var inst_24040 = cljs.core.async.close_BANG_(return_ch);
var state_24042__$1 = (function (){var statearr_24047 = state_24042;
(statearr_24047[(8)] = inst_24039);

return statearr_24047;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24042__$1,inst_24040);
} else {
if((state_val_24043 === (6))){
var inst_24030 = (state_24042[(7)]);
var inst_24030__$1 = (state_24042[(2)]);
var inst_24031 = fluree.db.util.core.exception_QMARK_(inst_24030__$1);
var state_24042__$1 = (function (){var statearr_24048 = state_24042;
(statearr_24048[(7)] = inst_24030__$1);

return statearr_24048;
})();
if(inst_24031){
var statearr_24049_24063 = state_24042__$1;
(statearr_24049_24063[(1)] = (7));

} else {
var statearr_24050_24064 = state_24042__$1;
(statearr_24050_24064[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24043 === (3))){
var inst_24028 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,_id_val);
var state_24042__$1 = state_24042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24042__$1,(6),inst_24028);
} else {
if((state_val_24043 === (2))){
var state_24042__$1 = state_24042;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24042__$1,(5),return_ch,_id_val);
} else {
if((state_val_24043 === (9))){
var inst_24037 = (state_24042[(2)]);
var state_24042__$1 = state_24042;
var statearr_24051_24065 = state_24042__$1;
(statearr_24051_24065[(2)] = inst_24037);

(statearr_24051_24065[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24043 === (5))){
var inst_24026 = (state_24042[(2)]);
var state_24042__$1 = state_24042;
var statearr_24052_24066 = state_24042__$1;
(statearr_24052_24066[(2)] = inst_24026);

(statearr_24052_24066[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24043 === (8))){
var inst_24030 = (state_24042[(7)]);
var inst_24035 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_24030);
var state_24042__$1 = state_24042;
var statearr_24053_24067 = state_24042__$1;
(statearr_24053_24067[(2)] = inst_24035);

(statearr_24053_24067[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_24054 = [null,null,null,null,null,null,null,null,null];
(statearr_24054[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__);

(statearr_24054[(1)] = (1));

return statearr_24054;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1 = (function (state_24042){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24042);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24055){var ex__2730__auto__ = e24055;
var statearr_24056_24068 = state_24042;
(statearr_24056_24068[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24042[(4)]))){
var statearr_24057_24069 = state_24042;
(statearr_24057_24069[(1)] = cljs.core.first((state_24042[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24070 = state_24042;
state_24042 = G__24070;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = function(state_24042){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1.call(this,state_24042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24058 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24058[(6)] = c__2749__auto___24059);

return statearr_24058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__24071){
var map__24072 = p__24071;
var map__24072__$1 = cljs.core.__destructure_map(map__24072);
var opts = map__24072__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24072__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24139){
var state_val_24140 = (state_24139[(1)]);
if((state_val_24140 === (7))){
var inst_24084 = fluree.db.query.subject_crawl.subject.subjects_chan(db,error_ch,vars,f_where);
var state_24139__$1 = state_24139;
var statearr_24141_24178 = state_24139__$1;
(statearr_24141_24178[(2)] = inst_24084);

(statearr_24141_24178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (20))){
var inst_24128 = (state_24139[(2)]);
var state_24139__$1 = state_24139;
var statearr_24142_24179 = state_24139__$1;
(statearr_24142_24179[(2)] = inst_24128);

(statearr_24142_24179[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (1))){
var state_24139__$1 = state_24139;
var statearr_24143_24180 = state_24139__$1;
(statearr_24143_24180[(2)] = null);

(statearr_24143_24180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (4))){
var inst_24073 = (state_24139[(2)]);
var state_24139__$1 = state_24139;
var statearr_24144_24181 = state_24139__$1;
(statearr_24144_24181[(2)] = inst_24073);

(statearr_24144_24181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (15))){
var inst_24086 = (state_24139[(7)]);
var inst_24097 = (state_24139[(8)]);
var inst_24091 = (state_24139[(9)]);
var inst_24092 = (state_24139[(10)]);
var inst_24118 = cljs.core.async.close_BANG_(inst_24086);
var inst_24119 = cljs.core.async.close_BANG_(inst_24091);
var inst_24120 = cljs.core.async.close_BANG_(inst_24092);
var inst_24121 = (finish_fn.cljs$core$IFn$_invoke$arity$1 ? finish_fn.cljs$core$IFn$_invoke$arity$1(inst_24097) : finish_fn.call(null,inst_24097));
var state_24139__$1 = (function (){var statearr_24145 = state_24139;
(statearr_24145[(11)] = inst_24120);

(statearr_24145[(12)] = inst_24119);

(statearr_24145[(13)] = inst_24118);

return statearr_24145;
})();
var statearr_24146_24182 = state_24139__$1;
(statearr_24146_24182[(2)] = inst_24121);

(statearr_24146_24182[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (13))){
var inst_24107 = (state_24139[(14)]);
var inst_24116 = (inst_24107 == null);
var state_24139__$1 = state_24139;
if(cljs.core.truth_(inst_24116)){
var statearr_24147_24183 = state_24139__$1;
(statearr_24147_24183[(1)] = (15));

} else {
var statearr_24148_24184 = state_24139__$1;
(statearr_24148_24184[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (6))){
var inst_24082 = fluree.db.query.subject_crawl.subject.subjects_id_chan(db,error_ch,vars,f_where);
var state_24139__$1 = state_24139;
var statearr_24149_24185 = state_24139__$1;
(statearr_24149_24185[(2)] = inst_24082);

(statearr_24149_24185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (17))){
var inst_24130 = (state_24139[(2)]);
var state_24139__$1 = state_24139;
var statearr_24150_24186 = state_24139__$1;
(statearr_24150_24186[(2)] = inst_24130);

(statearr_24150_24186[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (3))){
var inst_24137 = (state_24139[(2)]);
var state_24139__$1 = state_24139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24139__$1,inst_24137);
} else {
if((state_val_24140 === (12))){
var inst_24086 = (state_24139[(7)]);
var inst_24107 = (state_24139[(14)]);
var inst_24091 = (state_24139[(9)]);
var inst_24092 = (state_24139[(10)]);
var inst_24111 = cljs.core.async.close_BANG_(inst_24086);
var inst_24112 = cljs.core.async.close_BANG_(inst_24091);
var inst_24113 = cljs.core.async.close_BANG_(inst_24092);
var inst_24114 = (function(){throw inst_24107})();
var state_24139__$1 = (function (){var statearr_24151 = state_24139;
(statearr_24151[(15)] = inst_24111);

(statearr_24151[(16)] = inst_24113);

(statearr_24151[(17)] = inst_24112);

return statearr_24151;
})();
var statearr_24152_24187 = state_24139__$1;
(statearr_24152_24187[(2)] = inst_24114);

(statearr_24152_24187[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (2))){
var _ = (function (){var statearr_24153 = state_24139;
(statearr_24153[(4)] = cljs.core.cons((5),(state_24139[(4)])));

return statearr_24153;
})();
var inst_24079 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_24080 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24079);
var state_24139__$1 = state_24139;
if(inst_24080){
var statearr_24154_24188 = state_24139__$1;
(statearr_24154_24188[(1)] = (6));

} else {
var statearr_24155_24189 = state_24139__$1;
(statearr_24155_24189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (19))){
var state_24139__$1 = state_24139;
var statearr_24156_24190 = state_24139__$1;
(statearr_24156_24190[(2)] = null);

(statearr_24156_24190[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (11))){
var inst_24106 = (state_24139[(2)]);
var inst_24107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24106,(0),null);
var inst_24108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24106,(1),null);
var inst_24109 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24108,error_ch);
var state_24139__$1 = (function (){var statearr_24158 = state_24139;
(statearr_24158[(14)] = inst_24107);

return statearr_24158;
})();
if(inst_24109){
var statearr_24159_24191 = state_24139__$1;
(statearr_24159_24191[(1)] = (12));

} else {
var statearr_24160_24192 = state_24139__$1;
(statearr_24160_24192[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (9))){
var inst_24092 = (state_24139[(10)]);
var inst_24102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24103 = [error_ch,inst_24092];
var inst_24104 = (new cljs.core.PersistentVector(null,2,(5),inst_24102,inst_24103,null));
var state_24139__$1 = state_24139;
return cljs.core.async.ioc_alts_BANG_(state_24139__$1,(11),inst_24104);
} else {
if((state_val_24140 === (5))){
var _ = (function (){var statearr_24161 = state_24139;
(statearr_24161[(4)] = cljs.core.rest((state_24139[(4)])));

return statearr_24161;
})();
var state_24139__$1 = state_24139;
var ex24157 = (state_24139__$1[(2)]);
var statearr_24162_24193 = state_24139__$1;
(statearr_24162_24193[(5)] = ex24157);


if((ex24157 instanceof Error)){
var statearr_24163_24194 = state_24139__$1;
(statearr_24163_24194[(1)] = (4));

(statearr_24163_24194[(5)] = null);

} else {
throw ex24157;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (14))){
var inst_24132 = (state_24139[(2)]);
var state_24139__$1 = state_24139;
var statearr_24164_24195 = state_24139__$1;
(statearr_24164_24195[(2)] = inst_24132);

(statearr_24164_24195[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (16))){
var state_24139__$1 = state_24139;
var statearr_24165_24196 = state_24139__$1;
(statearr_24165_24196[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (10))){
var inst_24134 = (state_24139[(2)]);
var _ = (function (){var statearr_24167 = state_24139;
(statearr_24167[(4)] = cljs.core.rest((state_24139[(4)])));

return statearr_24167;
})();
var state_24139__$1 = state_24139;
var statearr_24168_24197 = state_24139__$1;
(statearr_24168_24197[(2)] = inst_24134);

(statearr_24168_24197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (18))){
var inst_24097 = (state_24139[(8)]);
var inst_24107 = (state_24139[(14)]);
var inst_24124 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24097,inst_24107);
var inst_24097__$1 = inst_24124;
var state_24139__$1 = (function (){var statearr_24169 = state_24139;
(statearr_24169[(8)] = inst_24097__$1);

return statearr_24169;
})();
var statearr_24170_24198 = state_24139__$1;
(statearr_24170_24198[(2)] = null);

(statearr_24170_24198[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24140 === (8))){
var inst_24086 = (state_24139[(7)]);
var inst_24091 = (state_24139[(9)]);
var inst_24092 = (state_24139[(10)]);
var inst_24086__$1 = (state_24139[(2)]);
var inst_24087 = fluree.db.query.subject_crawl.subject.flakes_xf(opts);
var inst_24088 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_24089 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_24090 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24088,inst_24089);
var inst_24091__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((32),inst_24090);
var inst_24092__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24093 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24091__$1,inst_24087,inst_24086__$1);
var inst_24094 = fluree.db.query.subject_crawl.common.result_af(opts);
var inst_24095 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24092__$1,inst_24094,inst_24091__$1);
var inst_24096 = cljs.core.PersistentVector.EMPTY;
var inst_24097 = inst_24096;
var state_24139__$1 = (function (){var statearr_24171 = state_24139;
(statearr_24171[(18)] = inst_24093);

(statearr_24171[(19)] = inst_24095);

(statearr_24171[(7)] = inst_24086__$1);

(statearr_24171[(8)] = inst_24097);

(statearr_24171[(9)] = inst_24091__$1);

(statearr_24171[(10)] = inst_24092__$1);

return statearr_24171;
})();
var statearr_24172_24199 = state_24139__$1;
(statearr_24172_24199[(2)] = null);

(statearr_24172_24199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0 = (function (){
var statearr_24173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24173[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__);

(statearr_24173[(1)] = (1));

return statearr_24173;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1 = (function (state_24139){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24139);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24174){var ex__2730__auto__ = e24174;
var statearr_24175_24200 = state_24139;
(statearr_24175_24200[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24139[(4)]))){
var statearr_24176_24201 = state_24139;
(statearr_24176_24201[(1)] = cljs.core.first((state_24139[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24202 = state_24139;
state_24139 = G__24202;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = function(state_24139){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1.call(this,state_24139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24177 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24177[(6)] = c__2749__auto__);

return statearr_24177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
