// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23623){
var map__23624 = p__23623;
var map__23624__$1 = cljs.core.__destructure_map(map__23624);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,(function (){var G__23625 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__23625,xf);
} else {
return G__23625;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23626){
var map__23627 = p__23626;
var map__23627__$1 = cljs.core.__destructure_map(map__23627);
var _opts = map__23627__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23627__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23627__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23627__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23627__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23627__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23627__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23658){
var state_val_23659 = (state_23658[(1)]);
if((state_val_23659 === (7))){
var state_23658__$1 = state_23658;
var statearr_23660_23686 = state_23658__$1;
(statearr_23660_23686[(2)] = null);

(statearr_23660_23686[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (1))){
var state_23658__$1 = state_23658;
var statearr_23661_23687 = state_23658__$1;
(statearr_23661_23687[(2)] = null);

(statearr_23661_23687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (4))){
var inst_23628 = (state_23658[(2)]);
var inst_23629 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23628);
var inst_23630 = cljs.core.async.close_BANG_(port);
var state_23658__$1 = (function (){var statearr_23662 = state_23658;
(statearr_23662[(7)] = inst_23630);

(statearr_23662[(8)] = inst_23629);

return statearr_23662;
})();
var statearr_23663_23688 = state_23658__$1;
(statearr_23663_23688[(2)] = null);

(statearr_23663_23688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (6))){
var inst_23640 = (state_23658[(9)]);
var inst_23639 = (state_23658[(2)]);
var inst_23640__$1 = fluree.db.util.async.throw_err(inst_23639);
var inst_23641 = (inst_23640__$1 == null);
var state_23658__$1 = (function (){var statearr_23664 = state_23658;
(statearr_23664[(9)] = inst_23640__$1);

return statearr_23664;
})();
if(cljs.core.truth_(inst_23641)){
var statearr_23665_23689 = state_23658__$1;
(statearr_23665_23689[(1)] = (7));

} else {
var statearr_23666_23690 = state_23658__$1;
(statearr_23666_23690[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (3))){
var inst_23656 = (state_23658[(2)]);
var state_23658__$1 = state_23658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23658__$1,inst_23656);
} else {
if((state_val_23659 === (12))){
var inst_23652 = (state_23658[(2)]);
var inst_23653 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_23667 = state_23658;
(statearr_23667[(4)] = cljs.core.rest((state_23658[(4)])));

return statearr_23667;
})();
var state_23658__$1 = (function (){var statearr_23668 = state_23658;
(statearr_23668[(10)] = inst_23652);

return statearr_23668;
})();
var statearr_23669_23691 = state_23658__$1;
(statearr_23669_23691[(2)] = inst_23653);

(statearr_23669_23691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (2))){
var _ = (function (){var statearr_23670 = state_23658;
(statearr_23670[(4)] = cljs.core.cons((5),(state_23658[(4)])));

return statearr_23670;
})();
var inst_23637 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23658__$1 = state_23658;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23658__$1,(6),inst_23637);
} else {
if((state_val_23659 === (11))){
var inst_23646 = (state_23658[(11)]);
var inst_23650 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23646);
var state_23658__$1 = state_23658;
var statearr_23672_23692 = state_23658__$1;
(statearr_23672_23692[(2)] = inst_23650);

(statearr_23672_23692[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (9))){
var inst_23646 = (state_23658[(11)]);
var inst_23646__$1 = (state_23658[(2)]);
var inst_23647 = (inst_23646__$1 == null);
var state_23658__$1 = (function (){var statearr_23673 = state_23658;
(statearr_23673[(11)] = inst_23646__$1);

return statearr_23673;
})();
if(cljs.core.truth_(inst_23647)){
var statearr_23674_23693 = state_23658__$1;
(statearr_23674_23693[(1)] = (10));

} else {
var statearr_23675_23694 = state_23658__$1;
(statearr_23675_23694[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (5))){
var _ = (function (){var statearr_23676 = state_23658;
(statearr_23676[(4)] = cljs.core.rest((state_23658[(4)])));

return statearr_23676;
})();
var state_23658__$1 = state_23658;
var ex23671 = (state_23658__$1[(2)]);
var statearr_23677_23695 = state_23658__$1;
(statearr_23677_23695[(5)] = ex23671);


var statearr_23678_23696 = state_23658__$1;
(statearr_23678_23696[(1)] = (4));

(statearr_23678_23696[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (10))){
var state_23658__$1 = state_23658;
var statearr_23679_23697 = state_23658__$1;
(statearr_23679_23697[(2)] = null);

(statearr_23679_23697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23659 === (8))){
var inst_23640 = (state_23658[(9)]);
var inst_23644 = cljs.core.not_empty(inst_23640);
var state_23658__$1 = state_23658;
var statearr_23680_23698 = state_23658__$1;
(statearr_23680_23698[(2)] = inst_23644);

(statearr_23680_23698[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0 = (function (){
var statearr_23681 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23681[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__);

(statearr_23681[(1)] = (1));

return statearr_23681;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1 = (function (state_23658){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23658);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23682){var ex__2730__auto__ = e23682;
var statearr_23683_23699 = state_23658;
(statearr_23683_23699[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23658[(4)]))){
var statearr_23684_23700 = state_23658;
(statearr_23684_23700[(1)] = cljs.core.first((state_23658[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23701 = state_23658;
state_23658 = G__23701;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = function(state_23658){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1.call(this,state_23658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23685 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23685[(6)] = c__2749__auto__);

return statearr_23685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23702){
var map__23703 = p__23702;
var map__23703__$1 = cljs.core.__destructure_map(map__23703);
var db = map__23703__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23703__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_(permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_(cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_(coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23734){
var state_val_23735 = (state_23734[(1)]);
if((state_val_23735 === (7))){
var inst_23710 = (state_23734[(7)]);
var inst_23720 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_23710);
var state_23734__$1 = state_23734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23734__$1,(10),inst_23720);
} else {
if((state_val_23735 === (1))){
var state_23734__$1 = state_23734;
var statearr_23736_23759 = state_23734__$1;
(statearr_23736_23759[(2)] = null);

(statearr_23736_23759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (4))){
var inst_23704 = (state_23734[(2)]);
var state_23734__$1 = state_23734;
var statearr_23737_23760 = state_23734__$1;
(statearr_23737_23760[(2)] = inst_23704);

(statearr_23737_23760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (13))){
var inst_23727 = (state_23734[(2)]);
var state_23734__$1 = state_23734;
var statearr_23738_23761 = state_23734__$1;
(statearr_23738_23761[(2)] = inst_23727);

(statearr_23738_23761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (6))){
var inst_23715 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,flakes);
var state_23734__$1 = state_23734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23734__$1,(9),inst_23715);
} else {
if((state_val_23735 === (3))){
var inst_23732 = (state_23734[(2)]);
var state_23734__$1 = state_23734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23734__$1,inst_23732);
} else {
if((state_val_23735 === (12))){
var state_23734__$1 = state_23734;
var statearr_23739_23762 = state_23734__$1;
(statearr_23739_23762[(2)] = null);

(statearr_23739_23762[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (2))){
var inst_23710 = (state_23734[(7)]);
var _ = (function (){var statearr_23740 = state_23734;
(statearr_23740[(4)] = cljs.core.cons((5),(state_23734[(4)])));

return statearr_23740;
})();
var inst_23710__$1 = cljs.core.first(flakes);
var inst_23711 = fluree.db.flake.s(inst_23710__$1);
var inst_23712 = fluree.db.flake.sid__GT_cid(inst_23711);
var inst_23713 = filter_predicates_QMARK_(inst_23712);
var state_23734__$1 = (function (){var statearr_23741 = state_23734;
(statearr_23741[(7)] = inst_23710__$1);

return statearr_23741;
})();
if(cljs.core.truth_(inst_23713)){
var statearr_23742_23763 = state_23734__$1;
(statearr_23742_23763[(1)] = (6));

} else {
var statearr_23743_23764 = state_23734__$1;
(statearr_23743_23764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (11))){
var state_23734__$1 = state_23734;
var statearr_23745_23765 = state_23734__$1;
(statearr_23745_23765[(2)] = flakes);

(statearr_23745_23765[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (9))){
var inst_23717 = (state_23734[(2)]);
var inst_23718 = fluree.db.util.async.throw_err(inst_23717);
var state_23734__$1 = state_23734;
var statearr_23746_23766 = state_23734__$1;
(statearr_23746_23766[(2)] = inst_23718);

(statearr_23746_23766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (5))){
var _ = (function (){var statearr_23747 = state_23734;
(statearr_23747[(4)] = cljs.core.rest((state_23734[(4)])));

return statearr_23747;
})();
var state_23734__$1 = state_23734;
var ex23744 = (state_23734__$1[(2)]);
var statearr_23748_23767 = state_23734__$1;
(statearr_23748_23767[(5)] = ex23744);


if((ex23744 instanceof Error)){
var statearr_23749_23768 = state_23734__$1;
(statearr_23749_23768[(1)] = (4));

(statearr_23749_23768[(5)] = null);

} else {
throw ex23744;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (10))){
var inst_23722 = (state_23734[(2)]);
var inst_23723 = fluree.db.util.async.throw_err(inst_23722);
var state_23734__$1 = state_23734;
if(cljs.core.truth_(inst_23723)){
var statearr_23750_23769 = state_23734__$1;
(statearr_23750_23769[(1)] = (11));

} else {
var statearr_23751_23770 = state_23734__$1;
(statearr_23751_23770[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23735 === (8))){
var inst_23729 = (state_23734[(2)]);
var _ = (function (){var statearr_23752 = state_23734;
(statearr_23752[(4)] = cljs.core.rest((state_23734[(4)])));

return statearr_23752;
})();
var state_23734__$1 = state_23734;
var statearr_23753_23771 = state_23734__$1;
(statearr_23753_23771[(2)] = inst_23729);

(statearr_23753_23771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_23754 = [null,null,null,null,null,null,null,null];
(statearr_23754[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__);

(statearr_23754[(1)] = (1));

return statearr_23754;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1 = (function (state_23734){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23734);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23755){var ex__2730__auto__ = e23755;
var statearr_23756_23772 = state_23734;
(statearr_23756_23772[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23734[(4)]))){
var statearr_23757_23773 = state_23734;
(statearr_23757_23773[(1)] = cljs.core.first((state_23734[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23774 = state_23734;
state_23734 = G__23774;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = function(state_23734){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1.call(this,state_23734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23758 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23758[(6)] = c__2749__auto__);

return statearr_23758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some((function (p1__23775_SHARP_){
return (filter_fn.cljs$core$IFn$_invoke$arity$2 ? filter_fn.cljs$core$IFn$_invoke$arity$2(p1__23775_SHARP_,vars) : filter_fn.call(null,p1__23775_SHARP_,vars));
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23779 = filter_fns;
var vec__23780 = G__23779;
var seq__23781 = cljs.core.seq(vec__23780);
var first__23782 = cljs.core.first(seq__23781);
var seq__23781__$1 = cljs.core.next(seq__23781);
var filter_fn = first__23782;
var r_fns = seq__23781__$1;
var G__23779__$1 = G__23779;
while(true){
var vec__23783 = G__23779__$1;
var seq__23784 = cljs.core.seq(vec__23783);
var first__23785 = cljs.core.first(seq__23784);
var seq__23784__$1 = cljs.core.next(seq__23784);
var filter_fn__$1 = first__23785;
var r_fns__$1 = seq__23784__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_(filter_fn__$1,vars,pred_flakes))){
var G__23786 = r_fns__$1;
G__23779__$1 = G__23786;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23790 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,flakes);
var vec__23791 = G__23790;
var seq__23792 = cljs.core.seq(vec__23791);
var first__23793 = cljs.core.first(seq__23792);
var seq__23792__$1 = cljs.core.next(seq__23792);
var p_flakes = first__23793;
var r = seq__23792__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23790__$1 = G__23790;
var required_p__$1 = required_p;
while(true){
var vec__23797 = G__23790__$1;
var seq__23798 = cljs.core.seq(vec__23797);
var first__23799 = cljs.core.first(seq__23798);
var seq__23798__$1 = cljs.core.next(seq__23798);
var p_flakes__$1 = first__23799;
var r__$1 = seq__23798__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p(cljs.core.first(p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_(filter_fns,vars,p_flakes__$1)){
var G__23800 = r__$1;
var G__23801 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23790__$1 = G__23800;
required_p__$1 = G__23801;
continue;
} else {
return null;
}
} else {
var G__23802 = r__$1;
var G__23803 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23790__$1 = G__23802;
required_p__$1 = G__23803;
continue;
}
} else {
if(cljs.core.empty_QMARK_(required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23804,limit){
var map__23805 = p__23804;
var map__23805__$1 = cljs.core.__destructure_map(map__23805);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23805__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23805__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23805__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__23806 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(result,predicate);
}),results);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse(G__23806);
} else {
return G__23806;
}
})();
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,sorted));
}
});
