// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__15010 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15010,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15010,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15010,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15010,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15010,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15010,(5),null);
var G__15013 = idx;
var G__15013__$1 = (((G__15013 instanceof cljs.core.Keyword))?G__15013.fqn:null);
switch (G__15013__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate(db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15013__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__15015 = idx;
var G__15015__$1 = (((G__15015 instanceof cljs.core.Keyword))?G__15015.fqn:null);
switch (G__15015__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15015__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__15017 = idx;
var G__15017__$1 = (((G__15017 instanceof cljs.core.Keyword))?G__15017.fqn:null);
switch (G__15017__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15017__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15057){
var state_val_15058 = (state_15057[(1)]);
if((state_val_15058 === (7))){
var inst_15034 = (state_15057[(7)]);
var inst_15041 = (state_15057[(2)]);
var inst_15042 = fluree.db.util.async.throw_err(inst_15041);
var state_15057__$1 = (function (){var statearr_15059 = state_15057;
(statearr_15059[(8)] = inst_15042);

return statearr_15059;
})();
if(cljs.core.truth_(inst_15034)){
var statearr_15060_15084 = state_15057__$1;
(statearr_15060_15084[(1)] = (8));

} else {
var statearr_15061_15085 = state_15057__$1;
(statearr_15061_15085[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (1))){
var state_15057__$1 = state_15057;
var statearr_15062_15086 = state_15057__$1;
(statearr_15062_15086[(2)] = null);

(statearr_15062_15086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (4))){
var inst_15019 = (state_15057[(2)]);
var state_15057__$1 = state_15057;
var statearr_15063_15087 = state_15057__$1;
(statearr_15063_15087[(2)] = inst_15019);

(statearr_15063_15087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (13))){
var inst_15049 = (state_15057[(2)]);
var state_15057__$1 = state_15057;
var statearr_15064_15088 = state_15057__$1;
(statearr_15064_15088[(2)] = inst_15049);

(statearr_15064_15088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (6))){
var inst_15031 = (state_15057[(9)]);
var inst_15037 = (state_15057[(2)]);
var inst_15038 = fluree.db.util.async.throw_err(inst_15037);
var inst_15039 = fluree.db.query.range.resolve_subid(db,inst_15031);
var state_15057__$1 = (function (){var statearr_15065 = state_15057;
(statearr_15065[(10)] = inst_15038);

return statearr_15065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15057__$1,(7),inst_15039);
} else {
if((state_val_15058 === (3))){
var inst_15055 = (state_15057[(2)]);
var state_15057__$1 = state_15057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15057__$1,inst_15055);
} else {
if((state_val_15058 === (12))){
var state_15057__$1 = state_15057;
var statearr_15066_15089 = state_15057__$1;
(statearr_15066_15089[(2)] = (2147483647));

(statearr_15066_15089[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (2))){
var _ = (function (){var statearr_15067 = state_15057;
(statearr_15067[(4)] = cljs.core.cons((5),(state_15057[(4)])));

return statearr_15067;
})();
var inst_15028 = parts;
var inst_15029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15028,(0),null);
var inst_15030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15028,(1),null);
var inst_15031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15028,(2),null);
var inst_15032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15028,(3),null);
var inst_15033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15028,(4),null);
var inst_15034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15028,(5),null);
var inst_15035 = fluree.db.query.range.resolve_subid(db,inst_15029);
var state_15057__$1 = (function (){var statearr_15068 = state_15057;
(statearr_15068[(11)] = inst_15033);

(statearr_15068[(12)] = inst_15030);

(statearr_15068[(13)] = inst_15032);

(statearr_15068[(7)] = inst_15034);

(statearr_15068[(9)] = inst_15031);

return statearr_15068;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15057__$1,(6),inst_15035);
} else {
if((state_val_15058 === (11))){
var state_15057__$1 = state_15057;
var statearr_15070_15090 = state_15057__$1;
(statearr_15070_15090[(2)] = (-2147483647));

(statearr_15070_15090[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (9))){
var inst_15045 = (cljs.core._GT__EQ_ === test);
var state_15057__$1 = state_15057;
if(cljs.core.truth_(inst_15045)){
var statearr_15071_15091 = state_15057__$1;
(statearr_15071_15091[(1)] = (11));

} else {
var statearr_15072_15092 = state_15057__$1;
(statearr_15072_15092[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (5))){
var _ = (function (){var statearr_15073 = state_15057;
(statearr_15073[(4)] = cljs.core.rest((state_15057[(4)])));

return statearr_15073;
})();
var state_15057__$1 = state_15057;
var ex15069 = (state_15057__$1[(2)]);
var statearr_15074_15093 = state_15057__$1;
(statearr_15074_15093[(5)] = ex15069);


if((ex15069 instanceof Error)){
var statearr_15075_15094 = state_15057__$1;
(statearr_15075_15094[(1)] = (4));

(statearr_15075_15094[(5)] = null);

} else {
throw ex15069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (10))){
var inst_15042 = (state_15057[(8)]);
var inst_15033 = (state_15057[(11)]);
var inst_15030 = (state_15057[(12)]);
var inst_15032 = (state_15057[(13)]);
var inst_15038 = (state_15057[(10)]);
var inst_15051 = (state_15057[(2)]);
var inst_15052 = fluree.db.flake.__GT_Flake(inst_15038,inst_15030,inst_15042,inst_15032,inst_15033,inst_15051);
var _ = (function (){var statearr_15076 = state_15057;
(statearr_15076[(4)] = cljs.core.rest((state_15057[(4)])));

return statearr_15076;
})();
var state_15057__$1 = state_15057;
var statearr_15077_15095 = state_15057__$1;
(statearr_15077_15095[(2)] = inst_15052);

(statearr_15077_15095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15058 === (8))){
var inst_15034 = (state_15057[(7)]);
var state_15057__$1 = state_15057;
var statearr_15078_15096 = state_15057__$1;
(statearr_15078_15096[(2)] = inst_15034);

(statearr_15078_15096[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_15079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15079[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__);

(statearr_15079[(1)] = (1));

return statearr_15079;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1 = (function (state_15057){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15057);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15080){var ex__2730__auto__ = e15080;
var statearr_15081_15097 = state_15057;
(statearr_15081_15097[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15057[(4)]))){
var statearr_15082_15098 = state_15057;
(statearr_15082_15098[(1)] = cljs.core.first((state_15057[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15099 = state_15057;
state_15057 = G__15099;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = function(state_15057){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1.call(this,state_15057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15083 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15083[(6)] = c__2749__auto__);

return statearr_15083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_(node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__15100){
var map__15101 = p__15100;
var map__15101__$1 = cljs.core.__destructure_map(map__15101);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15101__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15101__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15101__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__15102 = cljs.core.PersistentVector.EMPTY;
var G__15102__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15102,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15103 = fluree.db.flake.s(f);
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15103) : subject_fn.call(null,G__15103));
}))):G__15102);
var G__15102__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15102__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15104 = fluree.db.flake.p(f);
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15104) : predicate_fn.call(null,G__15104));
}))):G__15102__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15102__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15105 = fluree.db.flake.o(f);
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15105) : object_fn.call(null,G__15105));
})));
} else {
return G__15102__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__15106){
var map__15107 = p__15106;
var map__15107__$1 = cljs.core.__destructure_map(map__15107);
var opts = map__15107__$1;
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15107__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15107__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15107__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15107__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter(opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__15108,root,novelty,error_ch,p__15109){
var map__15110 = p__15108;
var map__15110__$1 = cljs.core.__destructure_map(map__15110);
var conn = map__15110__$1;
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15110__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__15111 = p__15109;
var map__15111__$1 = cljs.core.__destructure_map(map__15111);
var opts = map__15111__$1;
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15111__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15111__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15111__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15111__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_flake,end_flake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes(opts);
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15142){
var state_val_15143 = (state_15142[(1)]);
if((state_val_15143 === (7))){
var inst_15125 = (state_15142[(7)]);
var state_15142__$1 = state_15142;
var statearr_15144_15168 = state_15142__$1;
(statearr_15144_15168[(2)] = inst_15125);

(statearr_15144_15168[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (1))){
var state_15142__$1 = state_15142;
var statearr_15145_15169 = state_15142__$1;
(statearr_15145_15169[(2)] = null);

(statearr_15145_15169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (4))){
var inst_15112 = (state_15142[(2)]);
var inst_15113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15114 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_15115 = (new cljs.core.PersistentVector(null,3,(5),inst_15113,inst_15114,null));
var inst_15116 = cljs.core.select_keys(db,inst_15115);
var inst_15117 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_15112,"Error authorizing flake in ledger",inst_15116) : fluree.db.util.log.error.call(null,inst_15112,"Error authorizing flake in ledger",inst_15116));
var state_15142__$1 = (function (){var statearr_15147 = state_15142;
(statearr_15147[(8)] = inst_15117);

return statearr_15147;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15142__$1,(5),error_ch,inst_15112);
} else {
if((state_val_15143 === (13))){
var inst_15137 = (state_15142[(2)]);
var _ = (function (){var statearr_15148 = state_15142;
(statearr_15148[(4)] = cljs.core.rest((state_15142[(4)])));

return statearr_15148;
})();
var state_15142__$1 = state_15142;
var statearr_15149_15170 = state_15142__$1;
(statearr_15149_15170[(2)] = inst_15137);

(statearr_15149_15170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (6))){
var _ = (function (){var statearr_15150 = state_15142;
(statearr_15150[(4)] = cljs.core.rest((state_15142[(4)])));

return statearr_15150;
})();
var state_15142__$1 = state_15142;
var ex15146 = (state_15142__$1[(2)]);
var statearr_15151_15171 = state_15142__$1;
(statearr_15151_15171[(5)] = ex15146);


var statearr_15152_15172 = state_15142__$1;
(statearr_15152_15172[(1)] = (4));

(statearr_15152_15172[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (3))){
var inst_15140 = (state_15142[(2)]);
var state_15142__$1 = state_15142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15142__$1,inst_15140);
} else {
if((state_val_15143 === (12))){
var state_15142__$1 = state_15142;
var statearr_15153_15173 = state_15142__$1;
(statearr_15153_15173[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15153_15173[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (2))){
var inst_15125 = (state_15142[(7)]);
var _ = (function (){var statearr_15154 = state_15142;
(statearr_15154[(4)] = cljs.core.cons((6),(state_15142[(4)])));

return statearr_15154;
})();
var inst_15125__$1 = fluree.db.util.schema.is_schema_flake_QMARK_(flake);
var state_15142__$1 = (function (){var statearr_15155 = state_15142;
(statearr_15155[(7)] = inst_15125__$1);

return statearr_15155;
})();
if(inst_15125__$1){
var statearr_15156_15174 = state_15142__$1;
(statearr_15156_15174[(1)] = (7));

} else {
var statearr_15157_15175 = state_15142__$1;
(statearr_15157_15175[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (11))){
var state_15142__$1 = state_15142;
var statearr_15158_15176 = state_15142__$1;
(statearr_15158_15176[(2)] = flake);

(statearr_15158_15176[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (9))){
var inst_15133 = (state_15142[(2)]);
var state_15142__$1 = state_15142;
if(cljs.core.truth_(inst_15133)){
var statearr_15159_15177 = state_15142__$1;
(statearr_15159_15177[(1)] = (11));

} else {
var statearr_15160_15178 = state_15142__$1;
(statearr_15160_15178[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (5))){
var inst_15119 = (state_15142[(2)]);
var state_15142__$1 = state_15142;
var statearr_15161_15179 = state_15142__$1;
(statearr_15161_15179[(2)] = inst_15119);

(statearr_15161_15179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (10))){
var inst_15130 = (state_15142[(2)]);
var inst_15131 = fluree.db.util.async.throw_err(inst_15130);
var state_15142__$1 = state_15142;
var statearr_15162_15180 = state_15142__$1;
(statearr_15162_15180[(2)] = inst_15131);

(statearr_15162_15180[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15143 === (8))){
var inst_15128 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,flake);
var state_15142__$1 = state_15142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15142__$1,(10),inst_15128);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_15163 = [null,null,null,null,null,null,null,null,null];
(statearr_15163[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__);

(statearr_15163[(1)] = (1));

return statearr_15163;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1 = (function (state_15142){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15142);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15164){var ex__2730__auto__ = e15164;
var statearr_15165_15181 = state_15142;
(statearr_15165_15181[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15142[(4)]))){
var statearr_15166_15182 = state_15142;
(statearr_15166_15182[(1)] = cljs.core.first((state_15142[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15183 = state_15142;
state_15142 = G__15183;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = function(state_15142){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1.call(this,state_15142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15167 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15167[(6)] = c__2749__auto__);

return statearr_15167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function() { 
var G__15184__delegate = function (fs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15184 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15185__i = 0, G__15185__a = new Array(arguments.length -  0);
while (G__15185__i < G__15185__a.length) {G__15185__a[G__15185__i] = arguments[G__15185__i + 0]; ++G__15185__i;}
  fs = new cljs.core.IndexedSeq(G__15185__a,0,null);
} 
return G__15184__delegate.call(this,fs);};
G__15184.cljs$lang$maxFixedArity = 0;
G__15184.cljs$lang$applyTo = (function (arglist__15186){
var fs = cljs.core.seq(arglist__15186);
return G__15184__delegate(fs);
});
G__15184.cljs$core$IFn$_invoke$arity$variadic = G__15184__delegate;
return G__15184;
})()
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15187,start,end,error_ch,flake_slices){
var map__15188 = p__15187;
var map__15188__$1 = cljs.core.__destructure_map(map__15188);
var db = map__15188__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15188__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15189 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s)], null);
var G__15189__$1 = (cljs.core.truth_(offset)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15189,cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset)):G__15189);
var G__15189__$2 = (cljs.core.truth_(limit)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15189__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit)):G__15189__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15189__$2,cljs.core.cat);

})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15190 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15190__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15190,fluree.db.query.range.filter_subject_page(limit,offset)):G__15190);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15190__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(flake_limit));
} else {
return G__15190__$1;
}
})();
var page_xf = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,page_xfs);
return cljs.core.async.transduce(page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15191,error_ch,p__15192){
var map__15193 = p__15191;
var map__15193__$1 = cljs.core.__destructure_map(map__15193);
var db = map__15193__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15193__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15194 = p__15192;
var map__15194__$1 = cljs.core.__destructure_map(map__15194);
var opts = map__15194__$1;
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15194__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15194__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15194__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15194__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15194__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15194__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var idx_cmp = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page(limit,offset,flake_limit,fluree.db.query.range.filter_authorized(db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices(conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15195 = cljs.core.identical_QMARK_;
var expr__15196 = test;
if(cljs.core.truth_((pred__15195.cljs$core$IFn$_invoke$arity$2 ? pred__15195.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__15196) : pred__15195.call(null,cljs.core._EQ_,expr__15196)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15195.cljs$core$IFn$_invoke$arity$2 ? pred__15195.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__15196) : pred__15195.call(null,cljs.core._LT_,expr__15196)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__15195.cljs$core$IFn$_invoke$arity$2 ? pred__15195.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__15196) : pred__15195.call(null,cljs.core._LT__EQ_,expr__15196)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15195.cljs$core$IFn$_invoke$arity$2 ? pred__15195.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__15196) : pred__15195.call(null,cljs.core._GT_,expr__15196)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__15195.cljs$core$IFn$_invoke$arity$2 ? pred__15195.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__15196) : pred__15195.call(null,cljs.core._GT__EQ_,expr__15196)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15196)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15199 = arguments.length;
switch (G__15199) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15200 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15200,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15200,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15200,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15200,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15203,idx,start_test,start_match,end_test,end_match,opts){
var map__15204 = p__15203;
var map__15204__$1 = cljs.core.__destructure_map(map__15204);
var db = map__15204__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15204__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15205 = opts;
var map__15205__$1 = cljs.core.__destructure_map(map__15205);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15205__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15205__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15205__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15267){
var state_val_15268 = (state_15267[(1)]);
if((state_val_15268 === (7))){
var inst_15224 = (state_15267[(7)]);
var inst_15220 = (state_15267[(8)]);
var inst_15215 = (state_15267[(9)]);
var inst_15218 = (state_15267[(2)]);
var inst_15219 = fluree.db.util.async.throw_err(inst_15218);
var inst_15220__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15221 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15222 = [idx,from_t,to_t,start_test,inst_15215,end_test,inst_15219,limit];
var inst_15223 = cljs.core.PersistentHashMap.fromArrays(inst_15221,inst_15222);
var inst_15224__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15220__$1,inst_15223);
var inst_15232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15233 = [inst_15220__$1,inst_15224__$1];
var inst_15234 = (new cljs.core.PersistentVector(null,2,(5),inst_15232,inst_15233,null));
var state_15267__$1 = (function (){var statearr_15269 = state_15267;
(statearr_15269[(7)] = inst_15224__$1);

(statearr_15269[(8)] = inst_15220__$1);

return statearr_15269;
})();
return cljs.core.async.ioc_alts_BANG_(state_15267__$1,(8),inst_15234);
} else {
if((state_val_15268 === (1))){
var state_15267__$1 = state_15267;
var statearr_15270_15299 = state_15267__$1;
(statearr_15270_15299[(2)] = null);

(statearr_15270_15299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (4))){
var inst_15206 = (state_15267[(2)]);
var state_15267__$1 = state_15267;
var statearr_15271_15300 = state_15267__$1;
(statearr_15271_15300[(2)] = inst_15206);

(statearr_15271_15300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (15))){
var inst_15237 = (state_15267[(10)]);
var state_15267__$1 = state_15267;
var statearr_15272_15301 = state_15267__$1;
(statearr_15272_15301[(2)] = inst_15237);

(statearr_15272_15301[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (13))){
var inst_15238 = (state_15267[(11)]);
var inst_15254 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15238,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15267__$1 = state_15267;
if(inst_15254){
var statearr_15273_15302 = state_15267__$1;
(statearr_15273_15302[(1)] = (15));

} else {
var statearr_15274_15303 = state_15267__$1;
(statearr_15274_15303[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (6))){
var inst_15214 = (state_15267[(2)]);
var inst_15215 = fluree.db.util.async.throw_err(inst_15214);
var inst_15216 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_15267__$1 = (function (){var statearr_15275 = state_15267;
(statearr_15275[(9)] = inst_15215);

return statearr_15275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15267__$1,(7),inst_15216);
} else {
if((state_val_15268 === (17))){
var inst_15258 = (state_15267[(2)]);
var state_15267__$1 = state_15267;
var statearr_15276_15304 = state_15267__$1;
(statearr_15276_15304[(2)] = inst_15258);

(statearr_15276_15304[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (3))){
var inst_15265 = (state_15267[(2)]);
var state_15267__$1 = state_15267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15267__$1,inst_15265);
} else {
if((state_val_15268 === (12))){
var inst_15236 = (state_15267[(12)]);
var inst_15252 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15236,(0),null);
var state_15267__$1 = state_15267;
var statearr_15277_15305 = state_15267__$1;
(statearr_15277_15305[(2)] = inst_15252);

(statearr_15277_15305[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (2))){
var _ = (function (){var statearr_15278 = state_15267;
(statearr_15278[(4)] = cljs.core.cons((5),(state_15267[(4)])));

return statearr_15278;
})();
var inst_15212 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_15267__$1 = state_15267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15267__$1,(6),inst_15212);
} else {
if((state_val_15268 === (11))){
var inst_15262 = (state_15267[(2)]);
var _ = (function (){var statearr_15280 = state_15267;
(statearr_15280[(4)] = cljs.core.rest((state_15267[(4)])));

return statearr_15280;
})();
var state_15267__$1 = state_15267;
var statearr_15281_15306 = state_15267__$1;
(statearr_15281_15306[(2)] = inst_15262);

(statearr_15281_15306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (9))){
var inst_15236 = (state_15267[(12)]);
var inst_15244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15236,(0),null);
var inst_15245 = (function(){throw inst_15244})();
var state_15267__$1 = state_15267;
var statearr_15282_15307 = state_15267__$1;
(statearr_15282_15307[(2)] = inst_15245);

(statearr_15282_15307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (5))){
var _ = (function (){var statearr_15283 = state_15267;
(statearr_15283[(4)] = cljs.core.rest((state_15267[(4)])));

return statearr_15283;
})();
var state_15267__$1 = state_15267;
var ex15279 = (state_15267__$1[(2)]);
var statearr_15284_15308 = state_15267__$1;
(statearr_15284_15308[(5)] = ex15279);


if((ex15279 instanceof Error)){
var statearr_15285_15309 = state_15267__$1;
(statearr_15285_15309[(1)] = (4));

(statearr_15285_15309[(5)] = null);

} else {
throw ex15279;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (14))){
var inst_15260 = (state_15267[(2)]);
var state_15267__$1 = state_15267;
var statearr_15286_15310 = state_15267__$1;
(statearr_15286_15310[(2)] = inst_15260);

(statearr_15286_15310[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (16))){
var state_15267__$1 = state_15267;
var statearr_15287_15311 = state_15267__$1;
(statearr_15287_15311[(2)] = null);

(statearr_15287_15311[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (10))){
var inst_15238 = (state_15267[(11)]);
var inst_15224 = (state_15267[(7)]);
var inst_15247 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15238,inst_15224);
var state_15267__$1 = state_15267;
if(inst_15247){
var statearr_15288_15312 = state_15267__$1;
(statearr_15288_15312[(1)] = (12));

} else {
var statearr_15289_15313 = state_15267__$1;
(statearr_15289_15313[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15268 === (8))){
var inst_15238 = (state_15267[(11)]);
var inst_15220 = (state_15267[(8)]);
var inst_15236 = (state_15267[(12)]);
var inst_15236__$1 = (state_15267[(2)]);
var inst_15237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15236__$1,(0),null);
var inst_15238__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15236__$1,(1),null);
var inst_15239 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15238__$1,inst_15220);
var state_15267__$1 = (function (){var statearr_15290 = state_15267;
(statearr_15290[(11)] = inst_15238__$1);

(statearr_15290[(10)] = inst_15237);

(statearr_15290[(12)] = inst_15236__$1);

return statearr_15290;
})();
if(inst_15239){
var statearr_15291_15314 = state_15267__$1;
(statearr_15291_15314[(1)] = (9));

} else {
var statearr_15292_15315 = state_15267__$1;
(statearr_15292_15315[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15293 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15293[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15293[(1)] = (1));

return statearr_15293;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15267){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15267);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15294){var ex__2730__auto__ = e15294;
var statearr_15295_15316 = state_15267;
(statearr_15295_15316[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15267[(4)]))){
var statearr_15296_15317 = state_15267;
(statearr_15296_15317[(1)] = cljs.core.first((state_15267[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15318 = state_15267;
state_15267 = G__15318;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15267){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15297 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15297[(6)] = c__2749__auto__);

return statearr_15297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15320 = arguments.length;
switch (G__15320) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15321 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15321,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15321,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15321,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15321,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15324,idx,start_test,start_match,end_test,end_match,p__15325){
var map__15326 = p__15324;
var map__15326__$1 = cljs.core.__destructure_map(map__15326);
var db = map__15326__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15326__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15326__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15327 = p__15325;
var map__15327__$1 = cljs.core.__destructure_map(map__15327);
var opts = map__15327__$1;
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15327__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15328 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(5),null);
var vec__15331 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(5),null);
var vec__15334 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__15337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15334,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15337,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15337,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15334,(1),null);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15405){
var state_val_15406 = (state_15405[(1)]);
if((state_val_15406 === (7))){
var inst_15362 = (state_15405[(7)]);
var inst_15360 = (state_15405[(8)]);
var inst_15352 = (state_15405[(9)]);
var inst_15358 = (state_15405[(2)]);
var inst_15359 = fluree.db.util.async.throw_err(inst_15358);
var inst_15360__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15361 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15352,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15359,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1], 0));
var inst_15362__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15360__$1,inst_15361);
var inst_15370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15371 = [inst_15360__$1,inst_15362__$1];
var inst_15372 = (new cljs.core.PersistentVector(null,2,(5),inst_15370,inst_15371,null));
var state_15405__$1 = (function (){var statearr_15407 = state_15405;
(statearr_15407[(7)] = inst_15362__$1);

(statearr_15407[(8)] = inst_15360__$1);

return statearr_15407;
})();
return cljs.core.async.ioc_alts_BANG_(state_15405__$1,(8),inst_15372);
} else {
if((state_val_15406 === (1))){
var state_15405__$1 = state_15405;
var statearr_15408_15437 = state_15405__$1;
(statearr_15408_15437[(2)] = null);

(statearr_15408_15437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (4))){
var inst_15340 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15409_15438 = state_15405__$1;
(statearr_15409_15438[(2)] = inst_15340);

(statearr_15409_15438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (15))){
var inst_15375 = (state_15405[(10)]);
var state_15405__$1 = state_15405;
var statearr_15410_15439 = state_15405__$1;
(statearr_15410_15439[(2)] = inst_15375);

(statearr_15410_15439[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (13))){
var inst_15376 = (state_15405[(11)]);
var inst_15392 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15376,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15405__$1 = state_15405;
if(inst_15392){
var statearr_15411_15440 = state_15405__$1;
(statearr_15411_15440[(1)] = (15));

} else {
var statearr_15412_15441 = state_15405__$1;
(statearr_15412_15441[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (6))){
var inst_15351 = (state_15405[(2)]);
var inst_15352 = fluree.db.util.async.throw_err(inst_15351);
var inst_15353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15354 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15355 = (new cljs.core.PersistentVector(null,6,(5),inst_15353,inst_15354,null));
var inst_15356 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_15355);
var state_15405__$1 = (function (){var statearr_15413 = state_15405;
(statearr_15413[(9)] = inst_15352);

return statearr_15413;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15405__$1,(7),inst_15356);
} else {
if((state_val_15406 === (17))){
var inst_15396 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15414_15442 = state_15405__$1;
(statearr_15414_15442[(2)] = inst_15396);

(statearr_15414_15442[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (3))){
var inst_15403 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15405__$1,inst_15403);
} else {
if((state_val_15406 === (12))){
var inst_15374 = (state_15405[(12)]);
var inst_15390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15374,(0),null);
var state_15405__$1 = state_15405;
var statearr_15415_15443 = state_15405__$1;
(statearr_15415_15443[(2)] = inst_15390);

(statearr_15415_15443[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (2))){
var _ = (function (){var statearr_15416 = state_15405;
(statearr_15416[(4)] = cljs.core.cons((5),(state_15405[(4)])));

return statearr_15416;
})();
var inst_15346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15347 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15348 = (new cljs.core.PersistentVector(null,6,(5),inst_15346,inst_15347,null));
var inst_15349 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_15348);
var state_15405__$1 = state_15405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15405__$1,(6),inst_15349);
} else {
if((state_val_15406 === (11))){
var inst_15400 = (state_15405[(2)]);
var _ = (function (){var statearr_15418 = state_15405;
(statearr_15418[(4)] = cljs.core.rest((state_15405[(4)])));

return statearr_15418;
})();
var state_15405__$1 = state_15405;
var statearr_15419_15444 = state_15405__$1;
(statearr_15419_15444[(2)] = inst_15400);

(statearr_15419_15444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (9))){
var inst_15374 = (state_15405[(12)]);
var inst_15382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15374,(0),null);
var inst_15383 = (function(){throw inst_15382})();
var state_15405__$1 = state_15405;
var statearr_15420_15445 = state_15405__$1;
(statearr_15420_15445[(2)] = inst_15383);

(statearr_15420_15445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (5))){
var _ = (function (){var statearr_15421 = state_15405;
(statearr_15421[(4)] = cljs.core.rest((state_15405[(4)])));

return statearr_15421;
})();
var state_15405__$1 = state_15405;
var ex15417 = (state_15405__$1[(2)]);
var statearr_15422_15446 = state_15405__$1;
(statearr_15422_15446[(5)] = ex15417);


if((ex15417 instanceof Error)){
var statearr_15423_15447 = state_15405__$1;
(statearr_15423_15447[(1)] = (4));

(statearr_15423_15447[(5)] = null);

} else {
throw ex15417;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (14))){
var inst_15398 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15424_15448 = state_15405__$1;
(statearr_15424_15448[(2)] = inst_15398);

(statearr_15424_15448[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (16))){
var state_15405__$1 = state_15405;
var statearr_15425_15449 = state_15405__$1;
(statearr_15425_15449[(2)] = null);

(statearr_15425_15449[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (10))){
var inst_15362 = (state_15405[(7)]);
var inst_15376 = (state_15405[(11)]);
var inst_15385 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15376,inst_15362);
var state_15405__$1 = state_15405;
if(inst_15385){
var statearr_15426_15450 = state_15405__$1;
(statearr_15426_15450[(1)] = (12));

} else {
var statearr_15427_15451 = state_15405__$1;
(statearr_15427_15451[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (8))){
var inst_15360 = (state_15405[(8)]);
var inst_15374 = (state_15405[(12)]);
var inst_15376 = (state_15405[(11)]);
var inst_15374__$1 = (state_15405[(2)]);
var inst_15375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15374__$1,(0),null);
var inst_15376__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15374__$1,(1),null);
var inst_15377 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15376__$1,inst_15360);
var state_15405__$1 = (function (){var statearr_15428 = state_15405;
(statearr_15428[(10)] = inst_15375);

(statearr_15428[(12)] = inst_15374__$1);

(statearr_15428[(11)] = inst_15376__$1);

return statearr_15428;
})();
if(inst_15377){
var statearr_15429_15452 = state_15405__$1;
(statearr_15429_15452[(1)] = (9));

} else {
var statearr_15430_15453 = state_15405__$1;
(statearr_15430_15453[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15431 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15431[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15431[(1)] = (1));

return statearr_15431;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15405){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15405);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15432){var ex__2730__auto__ = e15432;
var statearr_15433_15454 = state_15405;
(statearr_15433_15454[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15405[(4)]))){
var statearr_15434_15455 = state_15405;
(statearr_15434_15455[(1)] = cljs.core.first((state_15405[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15456 = state_15405;
state_15405 = G__15456;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15405){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15435 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15435[(6)] = c__2749__auto__);

return statearr_15435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o(f))) && ((fluree.db.flake.o(f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15512){
var state_val_15513 = (state_15512[(1)]);
if((state_val_15513 === (7))){
var inst_15486 = (state_15512[(7)]);
var inst_15476 = (state_15512[(8)]);
var inst_15484 = fluree.db.flake.Flake__GT_parts(inst_15476);
var inst_15485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15484,(0),null);
var inst_15486__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15484,(1),null);
var inst_15487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15484,(2),null);
var inst_15488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15484,(3),null);
var inst_15489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15484,(4),null);
var inst_15490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15484,(5),null);
var inst_15491 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15487,inst_15486__$1);
var state_15512__$1 = (function (){var statearr_15514 = state_15512;
(statearr_15514[(7)] = inst_15486__$1);

(statearr_15514[(9)] = inst_15488);

(statearr_15514[(10)] = inst_15485);

(statearr_15514[(11)] = inst_15489);

(statearr_15514[(12)] = inst_15490);

return statearr_15514;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15512__$1,(10),inst_15491);
} else {
if((state_val_15513 === (1))){
var inst_15464 = flakes;
var inst_15465 = cljs.core.seq(inst_15464);
var inst_15466 = cljs.core.first(inst_15465);
var inst_15467 = cljs.core.next(inst_15465);
var inst_15468 = cljs.core.PersistentVector.EMPTY;
var inst_15469 = inst_15464;
var inst_15470 = inst_15468;
var state_15512__$1 = (function (){var statearr_15515 = state_15512;
(statearr_15515[(13)] = inst_15470);

(statearr_15515[(14)] = inst_15466);

(statearr_15515[(15)] = inst_15467);

(statearr_15515[(16)] = inst_15469);

return statearr_15515;
})();
var statearr_15516_15534 = state_15512__$1;
(statearr_15516_15534[(2)] = null);

(statearr_15516_15534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (4))){
var inst_15476 = (state_15512[(8)]);
var inst_15479 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15476);
var state_15512__$1 = state_15512;
if(inst_15479){
var statearr_15517_15535 = state_15512__$1;
(statearr_15517_15535[(1)] = (7));

} else {
var statearr_15518_15536 = state_15512__$1;
(statearr_15518_15536[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (6))){
var inst_15508 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
var statearr_15519_15537 = state_15512__$1;
(statearr_15519_15537[(2)] = inst_15508);

(statearr_15519_15537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (3))){
var inst_15510 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15512__$1,inst_15510);
} else {
if((state_val_15513 === (2))){
var inst_15476 = (state_15512[(8)]);
var inst_15469 = (state_15512[(16)]);
var inst_15475 = cljs.core.seq(inst_15469);
var inst_15476__$1 = cljs.core.first(inst_15475);
var inst_15477 = cljs.core.next(inst_15475);
var state_15512__$1 = (function (){var statearr_15520 = state_15512;
(statearr_15520[(8)] = inst_15476__$1);

(statearr_15520[(17)] = inst_15477);

return statearr_15520;
})();
if(cljs.core.truth_(inst_15476__$1)){
var statearr_15521_15538 = state_15512__$1;
(statearr_15521_15538[(1)] = (4));

} else {
var statearr_15522_15539 = state_15512__$1;
(statearr_15522_15539[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (9))){
var inst_15505 = (state_15512[(2)]);
var state_15512__$1 = state_15512;
var statearr_15523_15540 = state_15512__$1;
(statearr_15523_15540[(2)] = inst_15505);

(statearr_15523_15540[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (5))){
var inst_15470 = (state_15512[(13)]);
var state_15512__$1 = state_15512;
var statearr_15524_15541 = state_15512__$1;
(statearr_15524_15541[(2)] = inst_15470);

(statearr_15524_15541[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (10))){
var inst_15470 = (state_15512[(13)]);
var inst_15486 = (state_15512[(7)]);
var inst_15488 = (state_15512[(9)]);
var inst_15485 = (state_15512[(10)]);
var inst_15489 = (state_15512[(11)]);
var inst_15477 = (state_15512[(17)]);
var inst_15490 = (state_15512[(12)]);
var inst_15493 = (state_15512[(2)]);
var inst_15494 = fluree.db.util.async.throw_err(inst_15493);
var inst_15495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15496 = [inst_15485,inst_15486,inst_15494,inst_15488,inst_15489,inst_15490];
var inst_15497 = (new cljs.core.PersistentVector(null,6,(5),inst_15495,inst_15496,null));
var inst_15498 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15497);
var inst_15499 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15470,inst_15498);
var inst_15469 = inst_15477;
var inst_15470__$1 = inst_15499;
var state_15512__$1 = (function (){var statearr_15525 = state_15512;
(statearr_15525[(13)] = inst_15470__$1);

(statearr_15525[(16)] = inst_15469);

return statearr_15525;
})();
var statearr_15526_15542 = state_15512__$1;
(statearr_15526_15542[(2)] = null);

(statearr_15526_15542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15513 === (8))){
var inst_15470 = (state_15512[(13)]);
var inst_15476 = (state_15512[(8)]);
var inst_15477 = (state_15512[(17)]);
var inst_15502 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15470,inst_15476);
var inst_15469 = inst_15477;
var inst_15470__$1 = inst_15502;
var state_15512__$1 = (function (){var statearr_15527 = state_15512;
(statearr_15527[(13)] = inst_15470__$1);

(statearr_15527[(16)] = inst_15469);

return statearr_15527;
})();
var statearr_15528_15543 = state_15512__$1;
(statearr_15528_15543[(2)] = null);

(statearr_15528_15543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_15529 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15529[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__);

(statearr_15529[(1)] = (1));

return statearr_15529;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1 = (function (state_15512){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15512);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15530){var ex__2730__auto__ = e15530;
var statearr_15531_15544 = state_15512;
(statearr_15531_15544[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15512[(4)]))){
var statearr_15532_15545 = state_15512;
(statearr_15532_15545[(1)] = cljs.core.first((state_15512[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15546 = state_15512;
state_15512 = G__15546;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = function(state_15512){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1.call(this,state_15512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15533 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15533[(6)] = c__2749__auto__);

return statearr_15533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15548 = arguments.length;
switch (G__15548) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15730){
var state_val_15731 = (state_15730[(1)]);
if((state_val_15731 === (65))){
var inst_15599 = (state_15730[(7)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15599)){
var statearr_15732_15836 = state_15730__$1;
(statearr_15732_15836[(1)] = (68));

} else {
var statearr_15733_15837 = state_15730__$1;
(statearr_15733_15837[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (70))){
var inst_15709 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15734_15838 = state_15730__$1;
(statearr_15734_15838[(2)] = inst_15709);

(statearr_15734_15838[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (62))){
var inst_15675 = (state_15730[(2)]);
var inst_15676 = fluree.db.util.async.throw_err(inst_15675);
var inst_15677 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15676);
var state_15730__$1 = state_15730;
var statearr_15735_15839 = state_15730__$1;
(statearr_15735_15839[(2)] = inst_15677);

(statearr_15735_15839[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (74))){
var inst_15725 = (state_15730[(2)]);
var _ = (function (){var statearr_15736 = state_15730;
(statearr_15736[(4)] = cljs.core.rest((state_15730[(4)])));

return statearr_15736;
})();
var state_15730__$1 = state_15730;
var statearr_15737_15840 = state_15730__$1;
(statearr_15737_15840[(2)] = inst_15725);

(statearr_15737_15840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (7))){
var state_15730__$1 = state_15730;
var statearr_15738_15841 = state_15730__$1;
(statearr_15738_15841[(2)] = false);

(statearr_15738_15841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (59))){
var inst_15599 = (state_15730[(7)]);
var inst_15669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15670 = [inst_15599];
var inst_15671 = (new cljs.core.PersistentVector(null,1,(5),inst_15669,inst_15670,null));
var inst_15672 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15673 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15671,inst_15672);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(62),inst_15673);
} else {
if((state_val_15731 === (20))){
var state_15730__$1 = state_15730;
var statearr_15739_15842 = state_15730__$1;
(statearr_15739_15842[(2)] = null);

(statearr_15739_15842[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (72))){
var inst_15717 = (state_15730[(8)]);
var inst_15719 = fluree.db.query.range.coerce_tag_flakes(db,inst_15717);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(75),inst_15719);
} else {
if((state_val_15731 === (58))){
var inst_15667 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15667)){
var statearr_15740_15843 = state_15730__$1;
(statearr_15740_15843[(1)] = (59));

} else {
var statearr_15741_15844 = state_15730__$1;
(statearr_15741_15844[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (60))){
var inst_15560 = (state_15730[(9)]);
var inst_15661 = (state_15730[(10)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15680 = [inst_15560,inst_15559,null,inst_15562];
var inst_15681 = (new cljs.core.PersistentVector(null,4,(5),inst_15679,inst_15680,null));
var inst_15682 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15661);
var inst_15683 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15681,inst_15682);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(63),inst_15683);
} else {
if((state_val_15731 === (27))){
var inst_15560 = (state_15730[(9)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15599 = (state_15730[(7)]);
var inst_15611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15612 = [inst_15559,inst_15560,inst_15599,inst_15562];
var inst_15613 = (new cljs.core.PersistentVector(null,4,(5),inst_15611,inst_15612,null));
var inst_15614 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15613,opts);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(30),inst_15614);
} else {
if((state_val_15731 === (1))){
var state_15730__$1 = state_15730;
var statearr_15742_15845 = state_15730__$1;
(statearr_15742_15845[(2)] = null);

(statearr_15742_15845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (69))){
var state_15730__$1 = state_15730;
var statearr_15743_15846 = state_15730__$1;
(statearr_15743_15846[(2)] = null);

(statearr_15743_15846[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (24))){
var inst_15560 = (state_15730[(9)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15560)){
var statearr_15744_15847 = state_15730__$1;
(statearr_15744_15847[(1)] = (31));

} else {
var statearr_15745_15848 = state_15730__$1;
(statearr_15745_15848[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (55))){
var inst_15662 = (state_15730[(13)]);
var inst_15560 = (state_15730[(9)]);
var inst_15661 = (state_15730[(2)]);
var inst_15662__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15560);
var state_15730__$1 = (function (){var statearr_15746 = state_15730;
(statearr_15746[(13)] = inst_15662__$1);

(statearr_15746[(10)] = inst_15661);

return statearr_15746;
})();
if(inst_15662__$1){
var statearr_15747_15849 = state_15730__$1;
(statearr_15747_15849[(1)] = (56));

} else {
var statearr_15748_15850 = state_15730__$1;
(statearr_15748_15850[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (39))){
var inst_15629 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15749_15851 = state_15730__$1;
(statearr_15749_15851[(2)] = inst_15629);

(statearr_15749_15851[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (46))){
var inst_15653 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15653)){
var statearr_15750_15852 = state_15730__$1;
(statearr_15750_15852[(1)] = (50));

} else {
var statearr_15751_15853 = state_15730__$1;
(statearr_15751_15853[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (4))){
var inst_15549 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15752_15854 = state_15730__$1;
(statearr_15752_15854[(2)] = inst_15549);

(statearr_15752_15854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (54))){
var inst_15569 = (state_15730[(14)]);
var inst_15560 = (state_15730[(9)]);
var inst_15558 = (state_15730[(15)]);
var inst_15655 = (state_15730[(16)]);
var inst_15574 = (state_15730[(17)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15599 = (state_15730[(7)]);
var inst_15563 = (state_15730[(18)]);
var inst_15659 = (function (){var t = inst_15562;
var temp__5802__auto__ = inst_15655;
var p = inst_15560;
var idx_predicate_QMARK_ = inst_15563;
var vec__15555 = inst_15558;
var o = inst_15599;
var tag_predicate_QMARK_ = inst_15569;
var s = inst_15559;
var o_coerce_QMARK_ = inst_15574;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15730__$1 = state_15730;
var statearr_15753_15855 = state_15730__$1;
(statearr_15753_15855[(2)] = inst_15659);

(statearr_15753_15855[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (15))){
var inst_15561 = (state_15730[(19)]);
var inst_15580 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15561);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(18),inst_15580);
} else {
if((state_val_15731 === (48))){
var inst_15646 = (state_15730[(20)]);
var state_15730__$1 = state_15730;
var statearr_15754_15856 = state_15730__$1;
(statearr_15754_15856[(2)] = inst_15646);

(statearr_15754_15856[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (50))){
var inst_15655 = (state_15730[(16)]);
var inst_15655__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15730__$1 = (function (){var statearr_15755 = state_15730;
(statearr_15755[(16)] = inst_15655__$1);

return statearr_15755;
})();
if(cljs.core.truth_(inst_15655__$1)){
var statearr_15756_15857 = state_15730__$1;
(statearr_15756_15857[(1)] = (53));

} else {
var statearr_15757_15858 = state_15730__$1;
(statearr_15757_15858[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (75))){
var inst_15721 = (state_15730[(2)]);
var inst_15722 = fluree.db.util.async.throw_err(inst_15721);
var state_15730__$1 = state_15730;
var statearr_15758_15859 = state_15730__$1;
(statearr_15758_15859[(2)] = inst_15722);

(statearr_15758_15859[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (21))){
var inst_15595 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15759_15860 = state_15730__$1;
(statearr_15759_15860[(2)] = inst_15595);

(statearr_15759_15860[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (31))){
var inst_15622 = (state_15730[(21)]);
var inst_15599 = (state_15730[(7)]);
var inst_15622__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15599);
var state_15730__$1 = (function (){var statearr_15760 = state_15730;
(statearr_15760[(21)] = inst_15622__$1);

return statearr_15760;
})();
if(inst_15622__$1){
var statearr_15761_15861 = state_15730__$1;
(statearr_15761_15861[(1)] = (34));

} else {
var statearr_15762_15862 = state_15730__$1;
(statearr_15762_15862[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (32))){
var inst_15560 = (state_15730[(9)]);
var state_15730__$1 = state_15730;
var statearr_15763_15863 = state_15730__$1;
(statearr_15763_15863[(2)] = inst_15560);

(statearr_15763_15863[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (40))){
var inst_15560 = (state_15730[(9)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15599 = (state_15730[(7)]);
var inst_15637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15638 = [inst_15560,inst_15599,inst_15559,inst_15562];
var inst_15639 = (new cljs.core.PersistentVector(null,4,(5),inst_15637,inst_15638,null));
var inst_15640 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15639,opts);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(43),inst_15640);
} else {
if((state_val_15731 === (56))){
var inst_15599 = (state_15730[(7)]);
var inst_15664 = cljs.core.int_QMARK_(inst_15599);
var state_15730__$1 = state_15730;
var statearr_15764_15864 = state_15730__$1;
(statearr_15764_15864[(2)] = inst_15664);

(statearr_15764_15864[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (33))){
var inst_15635 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15635)){
var statearr_15765_15865 = state_15730__$1;
(statearr_15765_15865[(1)] = (40));

} else {
var statearr_15766_15866 = state_15730__$1;
(statearr_15766_15866[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (13))){
var inst_15561 = (state_15730[(19)]);
var inst_15578 = fluree.db.query.range.tag_string_QMARK_(inst_15561);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15578)){
var statearr_15767_15867 = state_15730__$1;
(statearr_15767_15867[(1)] = (15));

} else {
var statearr_15768_15868 = state_15730__$1;
(statearr_15768_15868[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (22))){
var inst_15591 = (state_15730[(2)]);
var inst_15592 = fluree.db.util.async.throw_err(inst_15591);
var state_15730__$1 = state_15730;
var statearr_15769_15869 = state_15730__$1;
(statearr_15769_15869[(2)] = inst_15592);

(statearr_15769_15869[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (36))){
var inst_15632 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15770_15870 = state_15730__$1;
(statearr_15770_15870[(2)] = inst_15632);

(statearr_15770_15870[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (41))){
var inst_15560 = (state_15730[(9)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15560)){
var statearr_15771_15871 = state_15730__$1;
(statearr_15771_15871[(1)] = (44));

} else {
var statearr_15772_15872 = state_15730__$1;
(statearr_15772_15872[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (43))){
var inst_15642 = (state_15730[(2)]);
var inst_15643 = fluree.db.util.async.throw_err(inst_15642);
var state_15730__$1 = state_15730;
var statearr_15773_15873 = state_15730__$1;
(statearr_15773_15873[(2)] = inst_15643);

(statearr_15773_15873[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (61))){
var inst_15688 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15774_15874 = state_15730__$1;
(statearr_15774_15874[(2)] = inst_15688);

(statearr_15774_15874[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (29))){
var inst_15608 = (state_15730[(2)]);
var inst_15609 = fluree.db.util.async.throw_err(inst_15608);
var state_15730__$1 = state_15730;
var statearr_15775_15875 = state_15730__$1;
(statearr_15775_15875[(2)] = inst_15609);

(statearr_15775_15875[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (44))){
var inst_15646 = (state_15730[(20)]);
var inst_15563 = (state_15730[(18)]);
var inst_15646__$1 = cljs.core.not(inst_15563);
var state_15730__$1 = (function (){var statearr_15776 = state_15730;
(statearr_15776[(20)] = inst_15646__$1);

return statearr_15776;
})();
if(inst_15646__$1){
var statearr_15777_15876 = state_15730__$1;
(statearr_15777_15876[(1)] = (47));

} else {
var statearr_15778_15877 = state_15730__$1;
(statearr_15778_15877[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (6))){
var inst_15560 = (state_15730[(9)]);
var inst_15565 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15560);
var inst_15566 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15565);
var state_15730__$1 = state_15730;
var statearr_15779_15878 = state_15730__$1;
(statearr_15779_15878[(2)] = inst_15566);

(statearr_15779_15878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (28))){
var inst_15619 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15780_15879 = state_15730__$1;
(statearr_15780_15879[(2)] = inst_15619);

(statearr_15780_15879[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (64))){
var inst_15560 = (state_15730[(9)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15599 = (state_15730[(7)]);
var inst_15691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15692 = [inst_15560,inst_15559,inst_15599,inst_15562];
var inst_15693 = (new cljs.core.PersistentVector(null,4,(5),inst_15691,inst_15692,null));
var inst_15694 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15693,opts);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(67),inst_15694);
} else {
if((state_val_15731 === (51))){
var inst_15560 = (state_15730[(9)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15560)){
var statearr_15781_15880 = state_15730__$1;
(statearr_15781_15880[(1)] = (64));

} else {
var statearr_15782_15881 = state_15730__$1;
(statearr_15782_15881[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (25))){
var inst_15569 = (state_15730[(14)]);
var inst_15717 = (state_15730[(2)]);
var state_15730__$1 = (function (){var statearr_15783 = state_15730;
(statearr_15783[(8)] = inst_15717);

return statearr_15783;
})();
if(cljs.core.truth_(inst_15569)){
var statearr_15784_15882 = state_15730__$1;
(statearr_15784_15882[(1)] = (72));

} else {
var statearr_15785_15883 = state_15730__$1;
(statearr_15785_15883[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (34))){
var inst_15563 = (state_15730[(18)]);
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15563)){
var statearr_15786_15884 = state_15730__$1;
(statearr_15786_15884[(1)] = (37));

} else {
var statearr_15787_15885 = state_15730__$1;
(statearr_15787_15885[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (17))){
var inst_15597 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15788_15886 = state_15730__$1;
(statearr_15788_15886[(2)] = inst_15597);

(statearr_15788_15886[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (3))){
var inst_15728 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15730__$1,inst_15728);
} else {
if((state_val_15731 === (12))){
var inst_15561 = (state_15730[(19)]);
var state_15730__$1 = state_15730;
var statearr_15789_15887 = state_15730__$1;
(statearr_15789_15887[(2)] = inst_15561);

(statearr_15789_15887[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (2))){
var inst_15560 = (state_15730[(9)]);
var inst_15558 = (state_15730[(15)]);
var _ = (function (){var statearr_15790 = state_15730;
(statearr_15790[(4)] = cljs.core.cons((5),(state_15730[(4)])));

return statearr_15790;
})();
var inst_15558__$1 = fparts;
var inst_15559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15558__$1,(0),null);
var inst_15560__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15558__$1,(1),null);
var inst_15561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15558__$1,(2),null);
var inst_15562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15558__$1,(3),null);
var inst_15563 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15560__$1);
var state_15730__$1 = (function (){var statearr_15791 = state_15730;
(statearr_15791[(9)] = inst_15560__$1);

(statearr_15791[(15)] = inst_15558__$1);

(statearr_15791[(19)] = inst_15561);

(statearr_15791[(11)] = inst_15559);

(statearr_15791[(12)] = inst_15562);

(statearr_15791[(18)] = inst_15563);

return statearr_15791;
})();
if(cljs.core.truth_(inst_15560__$1)){
var statearr_15792_15888 = state_15730__$1;
(statearr_15792_15888[(1)] = (6));

} else {
var statearr_15793_15889 = state_15730__$1;
(statearr_15793_15889[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (66))){
var inst_15711 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15794_15890 = state_15730__$1;
(statearr_15794_15890[(2)] = inst_15711);

(statearr_15794_15890[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (23))){
var inst_15560 = (state_15730[(9)]);
var inst_15601 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15560);
var state_15730__$1 = state_15730;
if(inst_15601){
var statearr_15795_15891 = state_15730__$1;
(statearr_15795_15891[(1)] = (26));

} else {
var statearr_15796_15892 = state_15730__$1;
(statearr_15796_15892[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (47))){
var inst_15599 = (state_15730[(7)]);
var state_15730__$1 = state_15730;
var statearr_15797_15893 = state_15730__$1;
(statearr_15797_15893[(2)] = inst_15599);

(statearr_15797_15893[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (35))){
var inst_15622 = (state_15730[(21)]);
var state_15730__$1 = state_15730;
var statearr_15798_15894 = state_15730__$1;
(statearr_15798_15894[(2)] = inst_15622);

(statearr_15798_15894[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (19))){
var inst_15560 = (state_15730[(9)]);
var inst_15561 = (state_15730[(19)]);
var inst_15587 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15560);
var inst_15588 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15587),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15561)].join('');
var inst_15589 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15588);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(22),inst_15589);
} else {
if((state_val_15731 === (57))){
var inst_15662 = (state_15730[(13)]);
var state_15730__$1 = state_15730;
var statearr_15799_15895 = state_15730__$1;
(statearr_15799_15895[(2)] = inst_15662);

(statearr_15799_15895[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (68))){
var inst_15560 = (state_15730[(9)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15599 = (state_15730[(7)]);
var inst_15700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15701 = [inst_15599,inst_15560,inst_15559,inst_15562];
var inst_15702 = (new cljs.core.PersistentVector(null,4,(5),inst_15700,inst_15701,null));
var inst_15703 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15702,opts);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(71),inst_15703);
} else {
if((state_val_15731 === (11))){
var inst_15574 = (state_15730[(17)]);
var inst_15574__$1 = (state_15730[(2)]);
var inst_15575 = cljs.core.not(inst_15574__$1);
var state_15730__$1 = (function (){var statearr_15801 = state_15730;
(statearr_15801[(17)] = inst_15574__$1);

return statearr_15801;
})();
if(inst_15575){
var statearr_15802_15896 = state_15730__$1;
(statearr_15802_15896[(1)] = (12));

} else {
var statearr_15803_15897 = state_15730__$1;
(statearr_15803_15897[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (9))){
var inst_15561 = (state_15730[(19)]);
var inst_15571 = typeof inst_15561 === 'string';
var state_15730__$1 = state_15730;
var statearr_15804_15898 = state_15730__$1;
(statearr_15804_15898[(2)] = inst_15571);

(statearr_15804_15898[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (5))){
var _ = (function (){var statearr_15805 = state_15730;
(statearr_15805[(4)] = cljs.core.rest((state_15730[(4)])));

return statearr_15805;
})();
var state_15730__$1 = state_15730;
var ex15800 = (state_15730__$1[(2)]);
var statearr_15806_15899 = state_15730__$1;
(statearr_15806_15899[(5)] = ex15800);


if((ex15800 instanceof Error)){
var statearr_15807_15900 = state_15730__$1;
(statearr_15807_15900[(1)] = (4));

(statearr_15807_15900[(5)] = null);

} else {
throw ex15800;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (14))){
var inst_15559 = (state_15730[(11)]);
var inst_15599 = (state_15730[(2)]);
var state_15730__$1 = (function (){var statearr_15808 = state_15730;
(statearr_15808[(7)] = inst_15599);

return statearr_15808;
})();
if(cljs.core.truth_(inst_15559)){
var statearr_15809_15901 = state_15730__$1;
(statearr_15809_15901[(1)] = (23));

} else {
var statearr_15810_15902 = state_15730__$1;
(statearr_15810_15902[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (45))){
var inst_15560 = (state_15730[(9)]);
var state_15730__$1 = state_15730;
var statearr_15811_15903 = state_15730__$1;
(statearr_15811_15903[(2)] = inst_15560);

(statearr_15811_15903[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (53))){
var inst_15569 = (state_15730[(14)]);
var inst_15560 = (state_15730[(9)]);
var inst_15558 = (state_15730[(15)]);
var inst_15655 = (state_15730[(16)]);
var inst_15574 = (state_15730[(17)]);
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15599 = (state_15730[(7)]);
var inst_15563 = (state_15730[(18)]);
var inst_15657 = (function (){var obj_fn = inst_15655;
var t = inst_15562;
var temp__5802__auto__ = inst_15655;
var p = inst_15560;
var idx_predicate_QMARK_ = inst_15563;
var vec__15555 = inst_15558;
var o = inst_15599;
var tag_predicate_QMARK_ = inst_15569;
var s = inst_15559;
var o_coerce_QMARK_ = inst_15574;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15730__$1 = state_15730;
var statearr_15812_15904 = state_15730__$1;
(statearr_15812_15904[(2)] = inst_15657);

(statearr_15812_15904[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (26))){
var inst_15559 = (state_15730[(11)]);
var inst_15562 = (state_15730[(12)]);
var inst_15603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15604 = [inst_15559,null,null,inst_15562];
var inst_15605 = (new cljs.core.PersistentVector(null,4,(5),inst_15603,inst_15604,null));
var inst_15606 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15605,opts);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(29),inst_15606);
} else {
if((state_val_15731 === (16))){
var inst_15561 = (state_15730[(19)]);
var inst_15585 = typeof inst_15561 === 'string';
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15585)){
var statearr_15813_15905 = state_15730__$1;
(statearr_15813_15905[(1)] = (19));

} else {
var statearr_15814_15906 = state_15730__$1;
(statearr_15814_15906[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (38))){
var inst_15563 = (state_15730[(18)]);
var state_15730__$1 = state_15730;
var statearr_15815_15907 = state_15730__$1;
(statearr_15815_15907[(2)] = inst_15563);

(statearr_15815_15907[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (30))){
var inst_15616 = (state_15730[(2)]);
var inst_15617 = fluree.db.util.async.throw_err(inst_15616);
var state_15730__$1 = state_15730;
var statearr_15816_15908 = state_15730__$1;
(statearr_15816_15908[(2)] = inst_15617);

(statearr_15816_15908[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (73))){
var inst_15717 = (state_15730[(8)]);
var state_15730__$1 = state_15730;
var statearr_15817_15909 = state_15730__$1;
(statearr_15817_15909[(2)] = inst_15717);

(statearr_15817_15909[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (10))){
var inst_15569 = (state_15730[(14)]);
var state_15730__$1 = state_15730;
var statearr_15818_15910 = state_15730__$1;
(statearr_15818_15910[(2)] = inst_15569);

(statearr_15818_15910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (18))){
var inst_15582 = (state_15730[(2)]);
var inst_15583 = fluree.db.util.async.throw_err(inst_15582);
var state_15730__$1 = state_15730;
var statearr_15819_15911 = state_15730__$1;
(statearr_15819_15911[(2)] = inst_15583);

(statearr_15819_15911[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (52))){
var inst_15713 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15820_15912 = state_15730__$1;
(statearr_15820_15912[(2)] = inst_15713);

(statearr_15820_15912[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (67))){
var inst_15696 = (state_15730[(2)]);
var inst_15697 = fluree.db.util.async.throw_err(inst_15696);
var state_15730__$1 = state_15730;
var statearr_15821_15913 = state_15730__$1;
(statearr_15821_15913[(2)] = inst_15697);

(statearr_15821_15913[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (71))){
var inst_15705 = (state_15730[(2)]);
var inst_15706 = fluree.db.util.async.throw_err(inst_15705);
var state_15730__$1 = state_15730;
var statearr_15822_15914 = state_15730__$1;
(statearr_15822_15914[(2)] = inst_15706);

(statearr_15822_15914[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (42))){
var inst_15715 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15823_15915 = state_15730__$1;
(statearr_15823_15915[(2)] = inst_15715);

(statearr_15823_15915[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (37))){
var inst_15599 = (state_15730[(7)]);
var inst_15625 = cljs.core.fn_QMARK_(inst_15599);
var inst_15626 = (!(inst_15625));
var state_15730__$1 = state_15730;
var statearr_15824_15916 = state_15730__$1;
(statearr_15824_15916[(2)] = inst_15626);

(statearr_15824_15916[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (63))){
var inst_15685 = (state_15730[(2)]);
var inst_15686 = fluree.db.util.async.throw_err(inst_15685);
var state_15730__$1 = state_15730;
var statearr_15825_15917 = state_15730__$1;
(statearr_15825_15917[(2)] = inst_15686);

(statearr_15825_15917[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (8))){
var inst_15569 = (state_15730[(14)]);
var inst_15569__$1 = (state_15730[(2)]);
var state_15730__$1 = (function (){var statearr_15826 = state_15730;
(statearr_15826[(14)] = inst_15569__$1);

return statearr_15826;
})();
if(cljs.core.truth_(inst_15569__$1)){
var statearr_15827_15918 = state_15730__$1;
(statearr_15827_15918[(1)] = (9));

} else {
var statearr_15828_15919 = state_15730__$1;
(statearr_15828_15919[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (49))){
var inst_15650 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15829_15920 = state_15730__$1;
(statearr_15829_15920[(2)] = inst_15650);

(statearr_15829_15920[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15830[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15830[(1)] = (1));

return statearr_15830;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15730){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15730);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15831){var ex__2730__auto__ = e15831;
var statearr_15832_15921 = state_15730;
(statearr_15832_15921[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15730[(4)]))){
var statearr_15833_15922 = state_15730;
(statearr_15833_15922[(1)] = cljs.core.first((state_15730[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15923 = state_15730;
state_15730 = G__15923;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15730){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15834 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15834[(6)] = c__2749__auto__);

return statearr_15834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15925 = arguments.length;
switch (G__15925) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15960){
var state_val_15961 = (state_15960[(1)]);
if((state_val_15961 === (7))){
var inst_15947 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15948 = ["Invalid collection name: ",inst_15947].join('');
var inst_15949 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15950 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15951 = cljs.core.PersistentHashMap.fromArrays(inst_15949,inst_15950);
var inst_15952 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15948,inst_15951);
var inst_15953 = (function(){throw inst_15952})();
var state_15960__$1 = state_15960;
var statearr_15962_15982 = state_15960__$1;
(statearr_15962_15982[(2)] = inst_15953);

(statearr_15962_15982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15961 === (1))){
var state_15960__$1 = state_15960;
var statearr_15963_15983 = state_15960__$1;
(statearr_15963_15983[(2)] = null);

(statearr_15963_15983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15961 === (4))){
var inst_15926 = (state_15960[(2)]);
var state_15960__$1 = state_15960;
var statearr_15964_15984 = state_15960__$1;
(statearr_15964_15984[(2)] = inst_15926);

(statearr_15964_15984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15961 === (6))){
var inst_15932 = (state_15960[(7)]);
var inst_15934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15935 = fluree.db.flake.max_subject_id(inst_15932);
var inst_15936 = [inst_15935];
var inst_15937 = (new cljs.core.PersistentVector(null,1,(5),inst_15934,inst_15936,null));
var inst_15938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15939 = fluree.db.flake.min_subject_id(inst_15932);
var inst_15940 = [inst_15939];
var inst_15941 = (new cljs.core.PersistentVector(null,1,(5),inst_15938,inst_15940,null));
var inst_15942 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15937,cljs.core._LT__EQ_,inst_15941,opts);
var state_15960__$1 = state_15960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15960__$1,(9),inst_15942);
} else {
if((state_val_15961 === (3))){
var inst_15958 = (state_15960[(2)]);
var state_15960__$1 = state_15960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15960__$1,inst_15958);
} else {
if((state_val_15961 === (2))){
var inst_15932 = (state_15960[(7)]);
var _ = (function (){var statearr_15966 = state_15960;
(statearr_15966[(4)] = cljs.core.cons((5),(state_15960[(4)])));

return statearr_15966;
})();
var inst_15932__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15960__$1 = (function (){var statearr_15967 = state_15960;
(statearr_15967[(7)] = inst_15932__$1);

return statearr_15967;
})();
if(cljs.core.truth_(inst_15932__$1)){
var statearr_15968_15985 = state_15960__$1;
(statearr_15968_15985[(1)] = (6));

} else {
var statearr_15969_15986 = state_15960__$1;
(statearr_15969_15986[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15961 === (9))){
var inst_15944 = (state_15960[(2)]);
var inst_15945 = fluree.db.util.async.throw_err(inst_15944);
var state_15960__$1 = state_15960;
var statearr_15970_15987 = state_15960__$1;
(statearr_15970_15987[(2)] = inst_15945);

(statearr_15970_15987[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15961 === (5))){
var _ = (function (){var statearr_15971 = state_15960;
(statearr_15971[(4)] = cljs.core.rest((state_15960[(4)])));

return statearr_15971;
})();
var state_15960__$1 = state_15960;
var ex15965 = (state_15960__$1[(2)]);
var statearr_15972_15988 = state_15960__$1;
(statearr_15972_15988[(5)] = ex15965);


var statearr_15973_15989 = state_15960__$1;
(statearr_15973_15989[(1)] = (4));

(statearr_15973_15989[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15961 === (8))){
var inst_15955 = (state_15960[(2)]);
var _ = (function (){var statearr_15974 = state_15960;
(statearr_15974[(4)] = cljs.core.rest((state_15960[(4)])));

return statearr_15974;
})();
var state_15960__$1 = state_15960;
var statearr_15975_15990 = state_15960__$1;
(statearr_15975_15990[(2)] = inst_15955);

(statearr_15975_15990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15976 = [null,null,null,null,null,null,null,null];
(statearr_15976[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15976[(1)] = (1));

return statearr_15976;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15960){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15960);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15977){var ex__2730__auto__ = e15977;
var statearr_15978_15991 = state_15960;
(statearr_15978_15991[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15960[(4)]))){
var statearr_15979_15992 = state_15960;
(statearr_15979_15992[(1)] = cljs.core.first((state_15960[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15993 = state_15960;
state_15960 = G__15993;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15960){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15980 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15980[(6)] = c__2749__auto__);

return statearr_15980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15997 = flakes;
var vec__15998 = G__15997;
var seq__15999 = cljs.core.seq(vec__15998);
var first__16000 = cljs.core.first(seq__15999);
var seq__15999__$1 = cljs.core.next(seq__15999);
var flake_SINGLEQUOTE_ = first__16000;
var r = seq__15999__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15997__$1 = G__15997;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16006 = G__15997__$1;
var seq__16007 = cljs.core.seq(vec__16006);
var first__16008 = cljs.core.first(seq__16007);
var seq__16007__$1 = cljs.core.next(seq__16007);
var flake_SINGLEQUOTE___$1 = first__16008;
var r__$1 = seq__16007__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o(flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e16010){var e = e16010;
return null;
}})();
var map__16009 = cmd_map;
var map__16009__$1 = cljs.core.__destructure_map(map__16009);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16009__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16009__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16009__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16009__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16009__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16009__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16011 = r__$1;
var G__16012 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15997__$1 = G__16011;
result_STAR___$1 = G__16012;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16021 = blocks;
var vec__16022 = G__16021;
var seq__16023 = cljs.core.seq(vec__16022);
var first__16024 = cljs.core.first(seq__16023);
var seq__16023__$1 = cljs.core.next(seq__16023);
var block_SINGLEQUOTE_ = first__16024;
var r = seq__16023__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16021__$1 = G__16021;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16029 = G__16021__$1;
var seq__16030 = cljs.core.seq(vec__16029);
var first__16031 = cljs.core.first(seq__16030);
var seq__16030__$1 = cljs.core.next(seq__16030);
var block_SINGLEQUOTE___$1 = first__16031;
var r__$1 = seq__16030__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16032 = block_SINGLEQUOTE___$1;
var map__16032__$1 = cljs.core.__destructure_map(map__16032);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16032__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16032__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16032__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16013_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16013_SHARP_),(2))){
return fluree.db.flake.o(p1__16013_SHARP_);
} else {
return null;
}
});})(G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16014_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16014_SHARP_),(1))){
return fluree.db.flake.o(p1__16014_SHARP_);
} else {
return null;
}
});})(G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,hash,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16015_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16015_SHARP_),(5))){
return fluree.db.flake.o(p1__16015_SHARP_);
} else {
return null;
}
});})(G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,hash,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,hash,instant,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16016_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16016_SHARP_),(7))){
return fluree.db.flake.o(p1__16016_SHARP_);
} else {
return null;
}
});})(G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,hash,instant,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16017_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16017_SHARP_),(106));
});})(G__16021__$1,result_STAR___$1,map__16032,map__16032__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16029,seq__16030,first__16031,seq__16030__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16021,vec__16022,seq__16023,first__16024,seq__16023__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__16033 = r__$1;
var G__16034 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16021__$1 = G__16033;
result_STAR___$1 = G__16034;
continue;
}
break;
}
});
