// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_filter');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
fluree.db.query.analytical_filter.filter_fns_with_ns = cljs.core.PersistentHashMap.fromArrays(["re-pattern","&&","=","coalesce","!","*","<=","not","/","-","strEnds","re-find","nil?","if","not=","or",">=","and","strStarts","<","bound","now","||","+",">"],[new cljs.core.Symbol(null,"re-pattern","re-pattern",1047705161,null),new cljs.core.Symbol(null,"&&","&&",-1330982734,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","coalesce","fluree.db.query.analytical-filter/coalesce",-342154698,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","!","fluree.db.query.analytical-filter/!",317544900,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","strEnds","fluree.db.query.analytical-filter/strEnds",459780392,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","strStarts","fluree.db.query.analytical-filter/strStarts",255731441,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","bound","fluree.db.query.analytical-filter/bound",-1543996761,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","now","fluree.db.query.analytical-filter/now",296501066,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","||","fluree.db.query.analytical-filter/||",1985077720,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,">",">",1085014381,null)]);
fluree.db.query.analytical_filter._BANG_ = (function fluree$db$query$analytical_filter$_BANG_(x){
return cljs.core.not(x);
});
var ret__5824__auto___18612 = (function (){
/**
 * Equivalent to and
 */
fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_ = (function fluree$db$query$analytical_filter$_AMPERSAND__AMPERSAND_(var_args){
var G__18611 = arguments.length;
switch (G__18611) {
case 2:
return fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___18614 = arguments.length;
var i__5770__auto___18615 = (0);
while(true){
if((i__5770__auto___18615 < len__5769__auto___18614)){
args_arr__5794__auto__.push((arguments[i__5770__auto___18615]));

var G__18616 = (i__5770__auto___18615 + (1));
i__5770__auto___18615 = G__18616;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return true;
}));

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"and__18605__auto__","and__18605__auto__",-757519780,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"and__18605__auto__","and__18605__auto__",-757519780,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),null,(1),null)),next))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"and__18605__auto__","and__18605__auto__",-757519780,null),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

/** @this {Function} */
(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$lang$applyTo = (function (seq18607){
var G__18608 = cljs.core.first(seq18607);
var seq18607__$1 = cljs.core.next(seq18607);
var G__18609 = cljs.core.first(seq18607__$1);
var seq18607__$2 = cljs.core.next(seq18607__$1);
var G__18610 = cljs.core.first(seq18607__$2);
var seq18607__$3 = cljs.core.next(seq18607__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18608,G__18609,G__18610,seq18607__$3);
}));

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$lang$macro = true);

var ret__5824__auto___18624 = (function (){
/**
 * Equivalent to or
 */
fluree.db.query.analytical_filter._BAR__BAR_ = (function fluree$db$query$analytical_filter$_BAR__BAR_(var_args){
var G__18623 = arguments.length;
switch (G__18623) {
case 2:
return fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___18626 = arguments.length;
var i__5770__auto___18627 = (0);
while(true){
if((i__5770__auto___18627 < len__5769__auto___18626)){
args_arr__5794__auto__.push((arguments[i__5770__auto___18627]));

var G__18628 = (i__5770__auto___18627 + (1));
i__5770__auto___18627 = G__18628;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"or__18617__auto__","or__18617__auto__",-520996649,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"or__18617__auto__","or__18617__auto__",-520996649,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,new cljs.core.Symbol(null,"or__18617__auto__","or__18617__auto__",-520996649,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),null,(1),null)),next))),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

/** @this {Function} */
(fluree.db.query.analytical_filter._BAR__BAR_.cljs$lang$applyTo = (function (seq18619){
var G__18620 = cljs.core.first(seq18619);
var seq18619__$1 = cljs.core.next(seq18619);
var G__18621 = cljs.core.first(seq18619__$1);
var seq18619__$2 = cljs.core.next(seq18619__$1);
var G__18622 = cljs.core.first(seq18619__$2);
var seq18619__$3 = cljs.core.next(seq18619__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18620,G__18621,G__18622,seq18619__$3);
}));

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.query.analytical_filter._BAR__BAR_.cljs$lang$macro = true);

fluree.db.query.analytical_filter.bound = (function fluree$db$query$analytical_filter$bound(x){
return (!((x == null)));
});
fluree.db.query.analytical_filter.now = (function fluree$db$query$analytical_filter$now(){
return null;
});
fluree.db.query.analytical_filter.strStarts = (function fluree$db$query$analytical_filter$strStarts(s,substr){
return clojure.string.starts_with_QMARK_(s,substr);
});
fluree.db.query.analytical_filter.strEnds = (function fluree$db$query$analytical_filter$strEnds(s,substr){
return clojure.string.ends_with_QMARK_(s,substr);
});
/**
 * Takes a filter fn as a string and a set/fn of allowed symbols that can be used within the fn.
 * 
 *   Returns two-tuple of parsed function and variables (symbols) used within the function as a set.
 */
fluree.db.query.analytical_filter.extract_filter_fn = (function fluree$db$query$analytical_filter$extract_filter_fn(func,symbols_allowed){
var func_SINGLEQUOTE_ = ((typeof func === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(func):func);
var symbols_allowed_STAR_ = (function (){var or__5045__auto__ = symbols_allowed;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (function (sym){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("?",cljs.core.first(cljs.core.name(sym)));
});
}
})();
var fn_name = cljs.core.first(func_SINGLEQUOTE_);
var fn_w_ns = (function (){var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core.set_QMARK_(fn_name);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core.every_QMARK_((function (p1__18629_SHARP_){
return ((typeof p1__18629_SHARP_ === 'number') || (typeof p1__18629_SHARP_ === 'string'));
}),fn_name);
if(and__5043__auto____$1){
return fn_name;
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var G__18633 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name);
return (fluree.db.query.analytical_filter.filter_fns_with_ns.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical_filter.filter_fns_with_ns.cljs$core$IFn$_invoke$arity$1(G__18633) : fluree.db.query.analytical_filter.filter_fns_with_ns.call(null,G__18633));
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name)," used in function argument: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([func], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}
}
})();
var args = cljs.core.rest(func_SINGLEQUOTE_);
var vec__18630 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__18634,arg){
var vec__18635 = p__18634;
var args_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18635,(0),null);
var vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18635,(1),null);
if(cljs.core.list_QMARK_(arg)){
var vec__18638 = (fluree.db.query.analytical_filter.extract_filter_fn.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.analytical_filter.extract_filter_fn.cljs$core$IFn$_invoke$arity$2(arg,symbols_allowed_STAR_) : fluree.db.query.analytical_filter.extract_filter_fn.call(null,arg,symbols_allowed_STAR_));
var args_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18638,(0),null);
var vars_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18638,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(args_STAR_,args_SINGLEQUOTE_),cljs.core.into.cljs$core$IFn$_invoke$arity$2(vars,vars_SINGLEQUOTE_)], null);
} else {
if((arg instanceof cljs.core.Symbol)){
if(cljs.core.not((symbols_allowed_STAR_.cljs$core$IFn$_invoke$arity$1 ? symbols_allowed_STAR_.cljs$core$IFn$_invoke$arity$1(arg) : symbols_allowed_STAR_.call(null,arg)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg)," used in function argument: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([func], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(args_STAR_,arg),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vars,arg)], null);
}
} else {
if(((typeof arg === 'string') || (((typeof arg === 'number') || (((cljs.core.boolean_QMARK_(arg)) || ((((arg == null)) || (cljs.core.regexp_QMARK_(arg)))))))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(args_STAR_,arg),vars], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Illegal element ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0))," of type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(arg))," in function argument: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([func], 0)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),args);
var args_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18630,(0),null);
var vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18630,(1),null);
var fn_STAR_ = cljs.core.cons(fn_w_ns,args_STAR_);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn_STAR_,vars], null);
});
/**
 * Takes a SPARQL-formatted filer, and returns 
 */
fluree.db.query.analytical_filter.SPARQL_filter_parser = (function fluree$db$query$analytical_filter$SPARQL_filter_parser(code){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Filter functions written in standard SPARQL format are not yet accepted.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
/**
 * optional? indicates we are looking for optional filters. 
 */
fluree.db.query.analytical_filter.get_filters = (function fluree$db$query$analytical_filter$get_filters(filters,optional_QMARK_){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,fil){
if(typeof fil === 'string'){
if(cljs.core.truth_(optional_QMARK_)){
return acc;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fil);
}
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.vector_QMARK_(fil);
if(and__5043__auto__){
var and__5043__auto____$1 = optional_QMARK_;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("optional",clojure.string.lower_case(cljs.core.first(fil)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.second(fil));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.map_QMARK_(fil);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("clojure",clojure.string.lower_case(new cljs.core.Keyword(null,"language","language",-1591107564).cljs$core$IFn$_invoke$arity$1(fil)));
if(and__5043__auto____$1){
var and__5043__auto____$2 = (cljs.core.truth_(optional_QMARK_)?new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil):(!(new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil) === true)));
if(cljs.core.truth_(and__5043__auto____$2)){
return cljs.core.contains_QMARK_(fil,new cljs.core.Keyword(null,"code","code",1586293142));
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(fil));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.map_QMARK_(fil);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("sparql",clojure.string.lower_case(new cljs.core.Keyword(null,"language","language",-1591107564).cljs$core$IFn$_invoke$arity$1(fil)));
if(and__5043__auto____$1){
var and__5043__auto____$2 = (cljs.core.truth_(optional_QMARK_)?new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil):(!(new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil) === true)));
if(cljs.core.truth_(and__5043__auto____$2)){
return cljs.core.contains_QMARK_(fil,new cljs.core.Keyword(null,"code","code",1586293142));
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.query.analytical_filter.SPARQL_filter_parser(fil));
} else {
return acc;

}
}
}
}
}),cljs.core.PersistentVector.EMPTY,filters);
});
var ret__5824__auto___18651 = (function (){
/**
 * Evaluates args in order. The result of the first arg not to return error gets returned.
 */
fluree.db.query.analytical_filter.coalesce = (function fluree$db$query$analytical_filter$coalesce(var_args){
var G__18650 = arguments.length;
switch (G__18650) {
case 2:
return fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___18653 = arguments.length;
var i__5770__auto___18654 = (0);
while(true){
if((i__5770__auto___18654 < len__5769__auto___18653)){
args_arr__5794__auto__.push((arguments[i__5770__auto___18654]));

var G__18655 = (i__5770__auto___18654 + (1));
i__5770__auto___18654 = G__18655;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("COALESCE evaluation failed on all forms.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}));

(fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,arg){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"res__18641__auto__","res__18641__auto__",-898787836,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),(new cljs.core.List(null,arg,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.query.analytical-filter","Exception","fluree.db.query.analytical-filter/Exception",1403766076,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,new cljs.core.Symbol(null,"e__18642__auto__","e__18642__auto__",-1596234031,null),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))], 0)))),null,(1),null))], 0)))),null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18641__auto__","res__18641__auto__",-898787836,null),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"throw","throw",595905694,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","ex-info","cljs.core/ex-info",-409744395,null),null,(1),null)),(new cljs.core.List(null,"Coalesce evaluation failed on all forms.",null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Keyword(null,"status","status",-1997798413),null,(1),null)),(new cljs.core.List(null,(400),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,new cljs.core.Keyword(null,"error","error",-978969032),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917),null,(1),null))], 0))))),null,(1),null))], 0)))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18641__auto__","res__18641__auto__",-898787836,null),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

(fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,arg,args){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"res__18643__auto__","res__18643__auto__",-661277200,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),(new cljs.core.List(null,arg,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.query.analytical-filter","Exception","fluree.db.query.analytical-filter/Exception",1403766076,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,new cljs.core.Symbol(null,"e__18644__auto__","e__18644__auto__",85724051,null),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))], 0)))),null,(1),null))], 0)))),null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18643__auto__","res__18643__auto__",-661277200,null),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.query.analytical-filter","coalesce","fluree.db.query.analytical-filter/coalesce",-342154698,null),null,(1),null)),args))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18643__auto__","res__18643__auto__",-661277200,null),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

/** @this {Function} */
(fluree.db.query.analytical_filter.coalesce.cljs$lang$applyTo = (function (seq18646){
var G__18647 = cljs.core.first(seq18646);
var seq18646__$1 = cljs.core.next(seq18646);
var G__18648 = cljs.core.first(seq18646__$1);
var seq18646__$2 = cljs.core.next(seq18646__$1);
var G__18649 = cljs.core.first(seq18646__$2);
var seq18646__$3 = cljs.core.next(seq18646__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18647,G__18648,G__18649,seq18646__$3);
}));

(fluree.db.query.analytical_filter.coalesce.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.query.analytical_filter.coalesce.cljs$lang$macro = true);

fluree.db.query.analytical_filter.filter_row = (function fluree$db$query$analytical_filter$filter_row(headers,clause,fil){
var fexpr__18656 = cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,headers,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fil),null,(1),null))], 0)))));
return (fexpr__18656.cljs$core$IFn$_invoke$arity$1 ? fexpr__18656.cljs$core$IFn$_invoke$arity$1(clause) : fexpr__18656.call(null,clause));
});
fluree.db.query.analytical_filter.get_internal_filter_fn = (function fluree$db$query$analytical_filter$get_internal_filter_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
/**
 * Like the legacy get-internal-filter-fn, but allows for multiple vars.
 */
fluree.db.query.analytical_filter.make_executable = (function fluree$db$query$analytical_filter$make_executable(params,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,params,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
