// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25670 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25670,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25670,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25670,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_(fluree.db.graphdb.exclude_predicates,fluree.db.flake.p(f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement(fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25673){
var map__25674 = p__25673;
var map__25674__$1 = cljs.core.__destructure_map(map__25674);
var opts = map__25674__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25674__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25734){
var state_val_25735 = (state_25734[(1)]);
if((state_val_25735 === (7))){
var inst_25705 = cljs.core.not(reindex_QMARK_);
var state_25734__$1 = state_25734;
var statearr_25736_25760 = state_25734__$1;
(statearr_25736_25760[(2)] = inst_25705);

(statearr_25736_25760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (1))){
var state_25734__$1 = state_25734;
var statearr_25737_25761 = state_25734__$1;
(statearr_25737_25761[(2)] = null);

(statearr_25737_25761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (4))){
var inst_25675 = (state_25734[(2)]);
var state_25734__$1 = state_25734;
var statearr_25738_25762 = state_25734__$1;
(statearr_25738_25762[(2)] = inst_25675);

(statearr_25738_25762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (6))){
var inst_25689 = (state_25734[(7)]);
var inst_25703 = (state_25734[(8)]);
var inst_25695 = (state_25734[(9)]);
var inst_25688 = (state_25734[(2)]);
var inst_25689__$1 = fluree.db.util.async.throw_err(inst_25688);
var inst_25690 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25691 = cljs.core.__destructure_map(inst_25690);
var inst_25692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25691,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25691,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25694 = fluree.db.flake.size_bytes(inst_25689__$1);
var inst_25695__$1 = (inst_25693 + inst_25694);
var inst_25696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25697 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25698 = (new cljs.core.PersistentVector(null,2,(5),inst_25696,inst_25697,null));
var inst_25699 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25698);
var inst_25700 = cljs.core.__destructure_map(inst_25699);
var inst_25701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25700,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25700,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25703__$1 = (inst_25695__$1 > inst_25702);
var state_25734__$1 = (function (){var statearr_25739 = state_25734;
(statearr_25739[(10)] = inst_25692);

(statearr_25739[(11)] = inst_25701);

(statearr_25739[(7)] = inst_25689__$1);

(statearr_25739[(8)] = inst_25703__$1);

(statearr_25739[(9)] = inst_25695__$1);

return statearr_25739;
})();
if(cljs.core.truth_(inst_25703__$1)){
var statearr_25740_25763 = state_25734__$1;
(statearr_25740_25763[(1)] = (7));

} else {
var statearr_25741_25764 = state_25734__$1;
(statearr_25741_25764[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (3))){
var inst_25732 = (state_25734[(2)]);
var state_25734__$1 = state_25734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25734__$1,inst_25732);
} else {
if((state_val_25735 === (12))){
var inst_25692 = (state_25734[(10)]);
var inst_25689 = (state_25734[(7)]);
var inst_25695 = (state_25734[(9)]);
var inst_25718 = (state_25734[(2)]);
var inst_25719 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25692,inst_25689);
var inst_25720 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25721 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25720,cljs.core.empty);
var inst_25722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25723 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25724 = (new cljs.core.PersistentVector(null,2,(5),inst_25722,inst_25723,null));
var inst_25725 = cljs.core.assoc_in(db,inst_25724,inst_25719);
var inst_25726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25727 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25728 = (new cljs.core.PersistentVector(null,2,(5),inst_25726,inst_25727,null));
var inst_25729 = cljs.core.assoc_in(inst_25725,inst_25728,inst_25695);
var _ = (function (){var statearr_25742 = state_25734;
(statearr_25742[(4)] = cljs.core.rest((state_25734[(4)])));

return statearr_25742;
})();
var state_25734__$1 = (function (){var statearr_25743 = state_25734;
(statearr_25743[(12)] = inst_25718);

(statearr_25743[(13)] = inst_25721);

return statearr_25743;
})();
var statearr_25744_25765 = state_25734__$1;
(statearr_25744_25765[(2)] = inst_25729);

(statearr_25744_25765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (2))){
var _ = (function (){var statearr_25745 = state_25734;
(statearr_25745[(4)] = cljs.core.cons((5),(state_25734[(4)])));

return statearr_25745;
})();
var inst_25683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25684 = [pred_id];
var inst_25685 = (new cljs.core.PersistentVector(null,1,(5),inst_25683,inst_25684,null));
var inst_25686 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25685);
var state_25734__$1 = state_25734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25734__$1,(6),inst_25686);
} else {
if((state_val_25735 === (11))){
var state_25734__$1 = state_25734;
var statearr_25747_25766 = state_25734__$1;
(statearr_25747_25766[(2)] = null);

(statearr_25747_25766[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (9))){
var inst_25708 = (state_25734[(2)]);
var state_25734__$1 = state_25734;
if(cljs.core.truth_(inst_25708)){
var statearr_25748_25767 = state_25734__$1;
(statearr_25748_25767[(1)] = (10));

} else {
var statearr_25749_25768 = state_25734__$1;
(statearr_25749_25768[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (5))){
var _ = (function (){var statearr_25750 = state_25734;
(statearr_25750[(4)] = cljs.core.rest((state_25734[(4)])));

return statearr_25750;
})();
var state_25734__$1 = state_25734;
var ex25746 = (state_25734__$1[(2)]);
var statearr_25751_25769 = state_25734__$1;
(statearr_25751_25769[(5)] = ex25746);


if((ex25746 instanceof Error)){
var statearr_25752_25770 = state_25734__$1;
(statearr_25752_25770[(1)] = (4));

(statearr_25752_25770[(5)] = null);

} else {
throw ex25746;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (10))){
var inst_25710 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25711 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25712 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25713 = cljs.core.PersistentHashMap.fromArrays(inst_25711,inst_25712);
var inst_25714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25710,inst_25713);
var inst_25715 = (function(){throw inst_25714})();
var state_25734__$1 = state_25734;
var statearr_25753_25771 = state_25734__$1;
(statearr_25753_25771[(2)] = inst_25715);

(statearr_25753_25771[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25735 === (8))){
var inst_25703 = (state_25734[(8)]);
var state_25734__$1 = state_25734;
var statearr_25754_25772 = state_25734__$1;
(statearr_25754_25772[(2)] = inst_25703);

(statearr_25754_25772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0 = (function (){
var statearr_25755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25755[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__);

(statearr_25755[(1)] = (1));

return statearr_25755;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1 = (function (state_25734){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25734);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25756){var ex__2730__auto__ = e25756;
var statearr_25757_25773 = state_25734;
(statearr_25757_25773[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25734[(4)]))){
var statearr_25758_25774 = state_25734;
(statearr_25758_25774[(1)] = cljs.core.first((state_25734[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25775 = state_25734;
state_25734 = G__25775;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = function(state_25734){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1.call(this,state_25734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25759 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25759[(6)] = c__2749__auto__);

return statearr_25759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25778 = arguments.length;
switch (G__25778) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25978){
var state_val_25979 = (state_25978[(1)]);
if((state_val_25979 === (7))){
var state_25978__$1 = state_25978;
var statearr_25980_26047 = state_25978__$1;
(statearr_25980_26047[(2)] = null);

(statearr_25980_26047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (20))){
var inst_25898 = (state_25978[(7)]);
var inst_25902 = (state_25978[(8)]);
var inst_25899 = (state_25978[(9)]);
var inst_25865 = (state_25978[(10)]);
var inst_25901 = (state_25978[(11)]);
var inst_25814 = (state_25978[(12)]);
var inst_25903 = (state_25978[(13)]);
var inst_25815 = (state_25978[(14)]);
var inst_25900 = (state_25978[(15)]);
var inst_25913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25914 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25915 = (new cljs.core.PersistentVector(null,2,(5),inst_25913,inst_25914,null));
var inst_25916 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25865,inst_25915);
var inst_25917 = (inst_25916 + inst_25814);
var inst_25918 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25919 = [inst_25898,inst_25899,inst_25900,inst_25901,inst_25902,inst_25917];
var inst_25920 = cljs.core.PersistentHashMap.fromArrays(inst_25918,inst_25919);
var inst_25921 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_25865,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25903,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25920], 0));
var state_25978__$1 = (function (){var statearr_25981 = state_25978;
(statearr_25981[(16)] = inst_25921);

return statearr_25981;
})();
if(cljs.core.truth_(inst_25815)){
var statearr_25982_26048 = state_25978__$1;
(statearr_25982_26048[(1)] = (23));

} else {
var statearr_25983_26049 = state_25978__$1;
(statearr_25983_26049[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (27))){
var inst_25921 = (state_25978[(16)]);
var state_25978__$1 = state_25978;
var statearr_25984_26050 = state_25978__$1;
(statearr_25984_26050[(2)] = inst_25921);

(statearr_25984_26050[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (1))){
var state_25978__$1 = state_25978;
var statearr_25985_26051 = state_25978__$1;
(statearr_25985_26051[(2)] = null);

(statearr_25985_26051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (24))){
var inst_25921 = (state_25978[(16)]);
var inst_25925 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25921);
var inst_25926 = (inst_25925 == null);
var state_25978__$1 = state_25978;
var statearr_25986_26052 = state_25978__$1;
(statearr_25986_26052[(2)] = inst_25926);

(statearr_25986_26052[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (39))){
var inst_25902 = (state_25978[(8)]);
var inst_25960 = (state_25978[(17)]);
var inst_25910 = (state_25978[(18)]);
var inst_25909 = (state_25978[(19)]);
var inst_25951 = (state_25978[(20)]);
var inst_25952 = (state_25978[(21)]);
var inst_25953 = (state_25978[(22)]);
var inst_25967 = (state_25978[(2)]);
var inst_25968 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25902,inst_25909);
var inst_25897 = inst_25910;
var inst_25898 = inst_25952;
var inst_25899 = inst_25953;
var inst_25900 = inst_25960;
var inst_25901 = inst_25967;
var inst_25902__$1 = inst_25968;
var inst_25903 = inst_25951;
var state_25978__$1 = (function (){var statearr_25987 = state_25978;
(statearr_25987[(7)] = inst_25898);

(statearr_25987[(8)] = inst_25902__$1);

(statearr_25987[(9)] = inst_25899);

(statearr_25987[(23)] = inst_25897);

(statearr_25987[(11)] = inst_25901);

(statearr_25987[(13)] = inst_25903);

(statearr_25987[(15)] = inst_25900);

return statearr_25987;
})();
var statearr_25988_26053 = state_25978__$1;
(statearr_25988_26053[(2)] = null);

(statearr_25988_26053[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (4))){
var inst_25779 = (state_25978[(2)]);
var state_25978__$1 = state_25978;
var statearr_25989_26054 = state_25978__$1;
(statearr_25989_26054[(2)] = inst_25779);

(statearr_25989_26054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (15))){
var inst_25837 = (state_25978[(24)]);
var state_25978__$1 = state_25978;
var statearr_25990_26055 = state_25978__$1;
(statearr_25990_26055[(2)] = inst_25837);

(statearr_25990_26055[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (21))){
var inst_25874 = (state_25978[(25)]);
var inst_25875 = (state_25978[(26)]);
var inst_25802 = (state_25978[(27)]);
var inst_25898 = (state_25978[(7)]);
var inst_25801 = (state_25978[(28)]);
var inst_25902 = (state_25978[(8)]);
var inst_25899 = (state_25978[(9)]);
var inst_25897 = (state_25978[(23)]);
var inst_25865 = (state_25978[(10)]);
var inst_25824 = (state_25978[(29)]);
var inst_25786 = (state_25978[(30)]);
var inst_25805 = (state_25978[(31)]);
var inst_25901 = (state_25978[(11)]);
var inst_25910 = (state_25978[(18)]);
var inst_25909 = (state_25978[(19)]);
var inst_25814 = (state_25978[(12)]);
var inst_25813 = (state_25978[(32)]);
var inst_25809 = (state_25978[(33)]);
var inst_25818 = (state_25978[(34)]);
var inst_25903 = (state_25978[(13)]);
var inst_25815 = (state_25978[(14)]);
var inst_25816 = (state_25978[(35)]);
var inst_25900 = (state_25978[(15)]);
var inst_25948 = fluree.db.flake.s(inst_25909);
var inst_25949 = fluree.db.flake.sid__GT_cid(inst_25948);
var inst_25950 = (function (){var flakes_bytes = inst_25814;
var t = inst_25786;
var seq__25871 = inst_25875;
var vec__25905 = inst_25897;
var first__25872 = inst_25874;
var spot = inst_25898;
var add_flakes = inst_25802;
var root_setting_change_QMARK_ = inst_25816;
var ref_QMARK__map = inst_25813;
var r = inst_25910;
var psot = inst_25899;
var add_pred_to_idx_QMARK_ = inst_25824;
var _ = inst_25801;
var tspo = inst_25902;
var cid = inst_25949;
var ecount = inst_25903;
var pred_ecount = inst_25818;
var G__25869 = inst_25897;
var seq__25906 = inst_25910;
var db_STAR_ = inst_25865;
var system_change_QMARK_ = inst_25815;
var vec__25870 = inst_25802;
var add_preds = inst_25805;
var opst = inst_25901;
var first__25907 = inst_25909;
var idx_QMARK__map = inst_25809;
var post = inst_25900;
var f = inst_25909;
return (function (p1__25776_SHARP_){
if(cljs.core.truth_(p1__25776_SHARP_)){
var x__5130__auto__ = p1__25776_SHARP_;
var y__5131__auto__ = fluree.db.flake.s(f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s(f);
}
});
})();
var inst_25951 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_25903,inst_25949,inst_25950);
var inst_25952 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25898,inst_25909);
var inst_25953 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25899,inst_25909);
var inst_25954 = fluree.db.flake.p(inst_25909);
var inst_25955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25809,inst_25954);
var state_25978__$1 = (function (){var statearr_25991 = state_25978;
(statearr_25991[(20)] = inst_25951);

(statearr_25991[(21)] = inst_25952);

(statearr_25991[(22)] = inst_25953);

return statearr_25991;
})();
if(cljs.core.truth_(inst_25955)){
var statearr_25992_26056 = state_25978__$1;
(statearr_25992_26056[(1)] = (34));

} else {
var statearr_25993_26057 = state_25978__$1;
(statearr_25993_26057[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (31))){
var inst_25937 = (state_25978[(36)]);
var state_25978__$1 = state_25978;
var statearr_25994_26058 = state_25978__$1;
(statearr_25994_26058[(2)] = inst_25937);

(statearr_25994_26058[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (32))){
var inst_25946 = (state_25978[(2)]);
var state_25978__$1 = state_25978;
var statearr_25995_26059 = state_25978__$1;
(statearr_25995_26059[(2)] = inst_25946);

(statearr_25995_26059[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (33))){
var inst_25937 = (state_25978[(36)]);
var inst_25941 = (state_25978[(2)]);
var inst_25942 = fluree.db.util.async.throw_err(inst_25941);
var inst_25943 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25937,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25942);
var state_25978__$1 = state_25978;
var statearr_25996_26060 = state_25978__$1;
(statearr_25996_26060[(2)] = inst_25943);

(statearr_25996_26060[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (13))){
var inst_25802 = (state_25978[(27)]);
var inst_25865 = (state_25978[(10)]);
var inst_25786 = (state_25978[(30)]);
var inst_25814 = (state_25978[(12)]);
var inst_25855 = (state_25978[(2)]);
var inst_25856 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25855,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25786);
var inst_25857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25858 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25859 = (new cljs.core.PersistentVector(null,2,(5),inst_25857,inst_25858,null));
var inst_25860 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25856,inst_25859,cljs.core._PLUS_,inst_25814);
var inst_25861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25862 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25863 = (new cljs.core.PersistentVector(null,2,(5),inst_25861,inst_25862,null));
var inst_25864 = cljs.core.count(inst_25802);
var inst_25865__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25860,inst_25863,cljs.core._PLUS_,inst_25864);
var inst_25873 = cljs.core.seq(inst_25802);
var inst_25874 = cljs.core.first(inst_25873);
var inst_25875 = cljs.core.next(inst_25873);
var inst_25876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25877 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25878 = (new cljs.core.PersistentVector(null,2,(5),inst_25876,inst_25877,null));
var inst_25879 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25865__$1,inst_25878);
var inst_25880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25881 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25882 = (new cljs.core.PersistentVector(null,2,(5),inst_25880,inst_25881,null));
var inst_25883 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25865__$1,inst_25882);
var inst_25884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25885 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25886 = (new cljs.core.PersistentVector(null,2,(5),inst_25884,inst_25885,null));
var inst_25887 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25865__$1,inst_25886);
var inst_25888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25889 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25890 = (new cljs.core.PersistentVector(null,2,(5),inst_25888,inst_25889,null));
var inst_25891 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25865__$1,inst_25890);
var inst_25892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25893 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25894 = (new cljs.core.PersistentVector(null,2,(5),inst_25892,inst_25893,null));
var inst_25895 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25865__$1,inst_25894);
var inst_25896 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25897 = inst_25802;
var inst_25898 = inst_25879;
var inst_25899 = inst_25883;
var inst_25900 = inst_25887;
var inst_25901 = inst_25891;
var inst_25902 = inst_25895;
var inst_25903 = inst_25896;
var state_25978__$1 = (function (){var statearr_25997 = state_25978;
(statearr_25997[(25)] = inst_25874);

(statearr_25997[(26)] = inst_25875);

(statearr_25997[(7)] = inst_25898);

(statearr_25997[(8)] = inst_25902);

(statearr_25997[(9)] = inst_25899);

(statearr_25997[(23)] = inst_25897);

(statearr_25997[(10)] = inst_25865__$1);

(statearr_25997[(11)] = inst_25901);

(statearr_25997[(13)] = inst_25903);

(statearr_25997[(15)] = inst_25900);

return statearr_25997;
})();
var statearr_25998_26061 = state_25978__$1;
(statearr_25998_26061[(2)] = null);

(statearr_25998_26061[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (22))){
var inst_25971 = (state_25978[(2)]);
var state_25978__$1 = state_25978;
var statearr_25999_26062 = state_25978__$1;
(statearr_25999_26062[(2)] = inst_25971);

(statearr_25999_26062[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (36))){
var inst_25909 = (state_25978[(19)]);
var inst_25813 = (state_25978[(32)]);
var inst_25960 = (state_25978[(2)]);
var inst_25961 = fluree.db.flake.p(inst_25909);
var inst_25962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25813,inst_25961);
var state_25978__$1 = (function (){var statearr_26000 = state_25978;
(statearr_26000[(17)] = inst_25960);

return statearr_26000;
})();
if(cljs.core.truth_(inst_25962)){
var statearr_26001_26063 = state_25978__$1;
(statearr_26001_26063[(1)] = (37));

} else {
var statearr_26002_26064 = state_25978__$1;
(statearr_26002_26064[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (29))){
var inst_25921 = (state_25978[(16)]);
var inst_25932 = (state_25978[(2)]);
var inst_25933 = fluree.db.util.async.throw_err(inst_25932);
var inst_25934 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25921,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25933);
var state_25978__$1 = state_25978;
var statearr_26003_26065 = state_25978__$1;
(statearr_26003_26065[(2)] = inst_25934);

(statearr_26003_26065[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (6))){
var inst_25786 = (state_25978[(30)]);
var inst_25791 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25792 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25793 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25791)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25792)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25786),"."].join('');
var inst_25794 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25795 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25796 = cljs.core.PersistentHashMap.fromArrays(inst_25794,inst_25795);
var inst_25797 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25793,inst_25796);
var inst_25798 = (function(){throw inst_25797})();
var state_25978__$1 = state_25978;
var statearr_26004_26066 = state_25978__$1;
(statearr_26004_26066[(2)] = inst_25798);

(statearr_26004_26066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (28))){
var inst_25816 = (state_25978[(35)]);
var inst_25937 = (state_25978[(2)]);
var state_25978__$1 = (function (){var statearr_26005 = state_25978;
(statearr_26005[(36)] = inst_25937);

return statearr_26005;
})();
if(cljs.core.truth_(inst_25816)){
var statearr_26006_26067 = state_25978__$1;
(statearr_26006_26067[(1)] = (30));

} else {
var statearr_26007_26068 = state_25978__$1;
(statearr_26007_26068[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (25))){
var inst_25928 = (state_25978[(2)]);
var state_25978__$1 = state_25978;
if(cljs.core.truth_(inst_25928)){
var statearr_26008_26069 = state_25978__$1;
(statearr_26008_26069[(1)] = (26));

} else {
var statearr_26009_26070 = state_25978__$1;
(statearr_26009_26070[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (34))){
var inst_25909 = (state_25978[(19)]);
var inst_25900 = (state_25978[(15)]);
var inst_25957 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25900,inst_25909);
var state_25978__$1 = state_25978;
var statearr_26010_26071 = state_25978__$1;
(statearr_26010_26071[(2)] = inst_25957);

(statearr_26010_26071[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (17))){
var inst_25844 = (state_25978[(37)]);
var inst_25848 = (state_25978[(2)]);
var inst_25849 = fluree.db.util.async.throw_err(inst_25848);
var inst_25836 = inst_25844;
var inst_25837 = inst_25849;
var state_25978__$1 = (function (){var statearr_26011 = state_25978;
(statearr_26011[(38)] = inst_25836);

(statearr_26011[(24)] = inst_25837);

return statearr_26011;
})();
var statearr_26012_26072 = state_25978__$1;
(statearr_26012_26072[(2)] = null);

(statearr_26012_26072[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (3))){
var inst_25976 = (state_25978[(2)]);
var state_25978__$1 = state_25978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25978__$1,inst_25976);
} else {
if((state_val_25979 === (12))){
var inst_25843 = (state_25978[(39)]);
var inst_25836 = (state_25978[(38)]);
var inst_25842 = cljs.core.seq(inst_25836);
var inst_25843__$1 = cljs.core.first(inst_25842);
var inst_25844 = cljs.core.next(inst_25842);
var state_25978__$1 = (function (){var statearr_26013 = state_25978;
(statearr_26013[(39)] = inst_25843__$1);

(statearr_26013[(37)] = inst_25844);

return statearr_26013;
})();
if(cljs.core.truth_(inst_25843__$1)){
var statearr_26014_26073 = state_25978__$1;
(statearr_26014_26073[(1)] = (14));

} else {
var statearr_26015_26074 = state_25978__$1;
(statearr_26015_26074[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (2))){
var inst_25786 = (state_25978[(30)]);
var _ = (function (){var statearr_26016 = state_25978;
(statearr_26016[(4)] = cljs.core.cons((5),(state_25978[(4)])));

return statearr_26016;
})();
var inst_25785 = cljs.core.first(flakes);
var inst_25786__$1 = fluree.db.flake.t(inst_25785);
var inst_25787 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25788 = (inst_25787 - (1));
var inst_25789 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_25786__$1,inst_25788);
var state_25978__$1 = (function (){var statearr_26017 = state_25978;
(statearr_26017[(30)] = inst_25786__$1);

return statearr_26017;
})();
if(inst_25789){
var statearr_26018_26075 = state_25978__$1;
(statearr_26018_26075[(1)] = (6));

} else {
var statearr_26019_26076 = state_25978__$1;
(statearr_26019_26076[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (23))){
var inst_25815 = (state_25978[(14)]);
var state_25978__$1 = state_25978;
var statearr_26020_26077 = state_25978__$1;
(statearr_26020_26077[(2)] = inst_25815);

(statearr_26020_26077[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (35))){
var inst_25900 = (state_25978[(15)]);
var state_25978__$1 = state_25978;
var statearr_26021_26078 = state_25978__$1;
(statearr_26021_26078[(2)] = inst_25900);

(statearr_26021_26078[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (19))){
var inst_25973 = (state_25978[(2)]);
var _ = (function (){var statearr_26022 = state_25978;
(statearr_26022[(4)] = cljs.core.rest((state_25978[(4)])));

return statearr_26022;
})();
var state_25978__$1 = state_25978;
var statearr_26023_26079 = state_25978__$1;
(statearr_26023_26079[(2)] = inst_25973);

(statearr_26023_26079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (11))){
var inst_25824 = (state_25978[(29)]);
var inst_25824__$1 = (state_25978[(2)]);
var inst_25832 = cljs.core.seq(inst_25824__$1);
var inst_25833 = cljs.core.first(inst_25832);
var inst_25834 = cljs.core.next(inst_25832);
var inst_25835 = db;
var inst_25836 = inst_25824__$1;
var inst_25837 = inst_25835;
var state_25978__$1 = (function (){var statearr_26025 = state_25978;
(statearr_26025[(29)] = inst_25824__$1);

(statearr_26025[(40)] = inst_25833);

(statearr_26025[(38)] = inst_25836);

(statearr_26025[(41)] = inst_25834);

(statearr_26025[(24)] = inst_25837);

return statearr_26025;
})();
var statearr_26026_26080 = state_25978__$1;
(statearr_26026_26080[(2)] = null);

(statearr_26026_26080[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (9))){
var inst_25802 = (state_25978[(27)]);
var inst_25818 = (state_25978[(34)]);
var inst_25820 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_25802,inst_25818);
var state_25978__$1 = state_25978;
var statearr_26027_26081 = state_25978__$1;
(statearr_26027_26081[(2)] = inst_25820);

(statearr_26027_26081[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (5))){
var _ = (function (){var statearr_26028 = state_25978;
(statearr_26028[(4)] = cljs.core.rest((state_25978[(4)])));

return statearr_26028;
})();
var state_25978__$1 = state_25978;
var ex26024 = (state_25978__$1[(2)]);
var statearr_26029_26082 = state_25978__$1;
(statearr_26029_26082[(5)] = ex26024);


if((ex26024 instanceof Error)){
var statearr_26030_26083 = state_25978__$1;
(statearr_26030_26083[(1)] = (4));

(statearr_26030_26083[(5)] = null);

} else {
throw ex26024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (14))){
var inst_25843 = (state_25978[(39)]);
var inst_25837 = (state_25978[(24)]);
var inst_25846 = fluree.db.graphdb.add_predicate_to_idx(inst_25837,inst_25843,opts);
var state_25978__$1 = state_25978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25978__$1,(17),inst_25846);
} else {
if((state_val_25979 === (26))){
var inst_25921 = (state_25978[(16)]);
var inst_25930 = fluree.db.query.schema.schema_map(inst_25921);
var state_25978__$1 = state_25978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25978__$1,(29),inst_25930);
} else {
if((state_val_25979 === (16))){
var inst_25853 = (state_25978[(2)]);
var state_25978__$1 = state_25978;
var statearr_26031_26084 = state_25978__$1;
(statearr_26031_26084[(2)] = inst_25853);

(statearr_26031_26084[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (38))){
var inst_25901 = (state_25978[(11)]);
var state_25978__$1 = state_25978;
var statearr_26032_26085 = state_25978__$1;
(statearr_26032_26085[(2)] = inst_25901);

(statearr_26032_26085[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (30))){
var inst_25921 = (state_25978[(16)]);
var inst_25939 = fluree.db.query.schema.setting_map(inst_25921);
var state_25978__$1 = state_25978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25978__$1,(33),inst_25939);
} else {
if((state_val_25979 === (10))){
var inst_25822 = cljs.core.PersistentVector.EMPTY;
var state_25978__$1 = state_25978;
var statearr_26033_26086 = state_25978__$1;
(statearr_26033_26086[(2)] = inst_25822);

(statearr_26033_26086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (18))){
var inst_25897 = (state_25978[(23)]);
var inst_25909 = (state_25978[(19)]);
var inst_25908 = cljs.core.seq(inst_25897);
var inst_25909__$1 = cljs.core.first(inst_25908);
var inst_25910 = cljs.core.next(inst_25908);
var inst_25911 = cljs.core.not(inst_25909__$1);
var state_25978__$1 = (function (){var statearr_26034 = state_25978;
(statearr_26034[(18)] = inst_25910);

(statearr_26034[(19)] = inst_25909__$1);

return statearr_26034;
})();
if(inst_25911){
var statearr_26035_26087 = state_25978__$1;
(statearr_26035_26087[(1)] = (20));

} else {
var statearr_26036_26088 = state_25978__$1;
(statearr_26036_26088[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (37))){
var inst_25901 = (state_25978[(11)]);
var inst_25909 = (state_25978[(19)]);
var inst_25964 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25901,inst_25909);
var state_25978__$1 = state_25978;
var statearr_26037_26089 = state_25978__$1;
(statearr_26037_26089[(2)] = inst_25964);

(statearr_26037_26089[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25979 === (8))){
var inst_25802 = (state_25978[(27)]);
var inst_25801 = (state_25978[(28)]);
var inst_25786 = (state_25978[(30)]);
var inst_25805 = (state_25978[(31)]);
var inst_25809 = (state_25978[(33)]);
var inst_25815 = (state_25978[(14)]);
var inst_25801__$1 = (state_25978[(2)]);
var inst_25802__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25803 = cljs.core.PersistentHashSet.EMPTY;
var inst_25804 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,inst_25802__$1);
var inst_25805__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25803,inst_25804);
var inst_25806 = cljs.core.PersistentHashMap.EMPTY;
var inst_25807 = (function (){var t = inst_25786;
var _ = inst_25801__$1;
var add_flakes = inst_25802__$1;
var add_preds = inst_25805__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25808 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25807,inst_25805__$1);
var inst_25809__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25806,inst_25808);
var inst_25810 = cljs.core.PersistentHashMap.EMPTY;
var inst_25811 = (function (){var t = inst_25786;
var _ = inst_25801__$1;
var add_flakes = inst_25802__$1;
var add_preds = inst_25805__$1;
var idx_QMARK__map = inst_25809__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25812 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25811,inst_25805__$1);
var inst_25813 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25810,inst_25812);
var inst_25814 = fluree.db.flake.size_bytes(inst_25802__$1);
var inst_25815__$1 = fluree.db.util.schema.system_change_QMARK_(inst_25802__$1);
var inst_25816 = fluree.db.util.schema.setting_change_QMARK_(inst_25802__$1);
var inst_25817 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25817,(0));
var state_25978__$1 = (function (){var statearr_26038 = state_25978;
(statearr_26038[(27)] = inst_25802__$1);

(statearr_26038[(28)] = inst_25801__$1);

(statearr_26038[(31)] = inst_25805__$1);

(statearr_26038[(12)] = inst_25814);

(statearr_26038[(32)] = inst_25813);

(statearr_26038[(33)] = inst_25809__$1);

(statearr_26038[(34)] = inst_25818);

(statearr_26038[(14)] = inst_25815__$1);

(statearr_26038[(35)] = inst_25816);

return statearr_26038;
})();
if(cljs.core.truth_(inst_25815__$1)){
var statearr_26039_26090 = state_25978__$1;
(statearr_26039_26090[(1)] = (9));

} else {
var statearr_26040_26091 = state_25978__$1;
(statearr_26040_26091[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26041[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26041[(1)] = (1));

return statearr_26041;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25978){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25978);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26042){var ex__2730__auto__ = e26042;
var statearr_26043_26092 = state_25978;
(statearr_26043_26092[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25978[(4)]))){
var statearr_26044_26093 = state_25978;
(statearr_26044_26093[(1)] = cljs.core.first((state_25978[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26094 = state_25978;
state_25978 = G__26094;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25978){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26045 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26045[(6)] = c__2749__auto__);

return statearr_26045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26096 = arguments.length;
switch (G__26096) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___26243 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26192){
var state_val_26193 = (state_26192[(1)]);
if((state_val_26193 === (7))){
var state_26192__$1 = state_26192;
var statearr_26194_26244 = state_26192__$1;
(statearr_26194_26244[(2)] = null);

(statearr_26194_26244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (20))){
var inst_26142 = (state_26192[(7)]);
var inst_26140 = (state_26192[(8)]);
var inst_26141 = (state_26192[(9)]);
var inst_26161 = (inst_26140 + (1));
var inst_26162 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26142,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26161);
var inst_26163 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_26162,inst_26141,opts);
var state_26192__$1 = state_26192;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26192__$1,(23),inst_26163);
} else {
if((state_val_26193 === (1))){
var state_26192__$1 = state_26192;
var statearr_26195_26245 = state_26192__$1;
(statearr_26195_26245[(2)] = null);

(statearr_26195_26245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (24))){
var inst_26166 = (state_26192[(10)]);
var inst_26169 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26166,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26192__$1 = state_26192;
var statearr_26196_26246 = state_26192__$1;
(statearr_26196_26246[(2)] = inst_26169);

(statearr_26196_26246[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (4))){
var inst_26097 = (state_26192[(2)]);
var inst_26098 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26097);
var state_26192__$1 = state_26192;
var statearr_26197_26247 = state_26192__$1;
(statearr_26197_26247[(2)] = inst_26098);

(statearr_26197_26247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (15))){
var inst_26148 = (state_26192[(11)]);
var state_26192__$1 = state_26192;
var statearr_26198_26248 = state_26192__$1;
(statearr_26198_26248[(2)] = inst_26148);

(statearr_26198_26248[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (21))){
var state_26192__$1 = state_26192;
var statearr_26199_26249 = state_26192__$1;
(statearr_26199_26249[(2)] = null);

(statearr_26199_26249[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (13))){
var inst_26184 = (state_26192[(2)]);
var inst_26185 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26184);
var state_26192__$1 = state_26192;
var statearr_26200_26250 = state_26192__$1;
(statearr_26200_26250[(2)] = inst_26185);

(statearr_26200_26250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (22))){
var inst_26180 = (state_26192[(2)]);
var state_26192__$1 = state_26192;
var statearr_26201_26251 = state_26192__$1;
(statearr_26201_26251[(2)] = inst_26180);

(statearr_26201_26251[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (6))){
var inst_26108 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26109 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26110 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26108)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26109)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26111 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26112 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26113 = cljs.core.PersistentHashMap.fromArrays(inst_26111,inst_26112);
var inst_26114 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26110,inst_26113);
var inst_26115 = (function(){throw inst_26114})();
var state_26192__$1 = state_26192;
var statearr_26204_26252 = state_26192__$1;
(statearr_26204_26252[(2)] = inst_26115);

(statearr_26204_26252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (25))){
var inst_26166 = (state_26192[(10)]);
var inst_26149 = (state_26192[(12)]);
var inst_26148 = (state_26192[(11)]);
var inst_26171 = fluree.db.flake.t(inst_26148);
var inst_26172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26173 = [inst_26148];
var inst_26174 = (new cljs.core.PersistentVector(null,1,(5),inst_26172,inst_26173,null));
var inst_26139 = inst_26149;
var inst_26140 = inst_26171;
var inst_26141 = inst_26174;
var inst_26142 = inst_26166;
var state_26192__$1 = (function (){var statearr_26205 = state_26192;
(statearr_26205[(7)] = inst_26142);

(statearr_26205[(8)] = inst_26140);

(statearr_26205[(13)] = inst_26139);

(statearr_26205[(9)] = inst_26141);

return statearr_26205;
})();
var statearr_26206_26253 = state_26192__$1;
(statearr_26206_26253[(2)] = null);

(statearr_26206_26253[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (17))){
var inst_26142 = (state_26192[(7)]);
var inst_26149 = (state_26192[(12)]);
var inst_26140 = (state_26192[(8)]);
var inst_26141 = (state_26192[(9)]);
var inst_26148 = (state_26192[(11)]);
var inst_26157 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26141,inst_26148);
var tmp26202 = inst_26142;
var tmp26203 = inst_26140;
var inst_26139 = inst_26149;
var inst_26140__$1 = tmp26203;
var inst_26141__$1 = inst_26157;
var inst_26142__$1 = tmp26202;
var state_26192__$1 = (function (){var statearr_26207 = state_26192;
(statearr_26207[(7)] = inst_26142__$1);

(statearr_26207[(8)] = inst_26140__$1);

(statearr_26207[(13)] = inst_26139);

(statearr_26207[(9)] = inst_26141__$1);

return statearr_26207;
})();
var statearr_26208_26254 = state_26192__$1;
(statearr_26208_26254[(2)] = null);

(statearr_26208_26254[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (3))){
var inst_26190 = (state_26192[(2)]);
var state_26192__$1 = state_26192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26192__$1,inst_26190);
} else {
if((state_val_26193 === (12))){
var inst_26139 = (state_26192[(13)]);
var inst_26148 = (state_26192[(11)]);
var inst_26147 = cljs.core.seq(inst_26139);
var inst_26148__$1 = cljs.core.first(inst_26147);
var inst_26149 = cljs.core.next(inst_26147);
var state_26192__$1 = (function (){var statearr_26209 = state_26192;
(statearr_26209[(12)] = inst_26149);

(statearr_26209[(11)] = inst_26148__$1);

return statearr_26209;
})();
if(cljs.core.truth_(inst_26148__$1)){
var statearr_26210_26255 = state_26192__$1;
(statearr_26210_26255[(1)] = (14));

} else {
var statearr_26211_26256 = state_26192__$1;
(statearr_26211_26256[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (2))){
var _ = (function (){var statearr_26212 = state_26192;
(statearr_26212[(4)] = cljs.core.cons((5),(state_26192[(4)])));

return statearr_26212;
})();
var inst_26104 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26105 = (inst_26104 + (1));
var inst_26106 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26105);
var state_26192__$1 = state_26192;
if(inst_26106){
var statearr_26213_26257 = state_26192__$1;
(statearr_26213_26257[(1)] = (6));

} else {
var statearr_26214_26258 = state_26192__$1;
(statearr_26214_26258[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (23))){
var inst_26148 = (state_26192[(11)]);
var inst_26165 = (state_26192[(2)]);
var inst_26166 = fluree.db.util.async.throw_err(inst_26165);
var inst_26167 = (inst_26148 == null);
var state_26192__$1 = (function (){var statearr_26215 = state_26192;
(statearr_26215[(10)] = inst_26166);

return statearr_26215;
})();
if(cljs.core.truth_(inst_26167)){
var statearr_26216_26259 = state_26192__$1;
(statearr_26216_26259[(1)] = (24));

} else {
var statearr_26217_26260 = state_26192__$1;
(statearr_26217_26260[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (19))){
var inst_26182 = (state_26192[(2)]);
var state_26192__$1 = state_26192;
var statearr_26218_26261 = state_26192__$1;
(statearr_26218_26261[(2)] = inst_26182);

(statearr_26218_26261[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (11))){
var inst_26187 = (state_26192[(2)]);
var _ = (function (){var statearr_26220 = state_26192;
(statearr_26220[(4)] = cljs.core.rest((state_26192[(4)])));

return statearr_26220;
})();
var state_26192__$1 = state_26192;
var statearr_26221_26262 = state_26192__$1;
(statearr_26221_26262[(2)] = inst_26187);

(statearr_26221_26262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (9))){
var inst_26121 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26122 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26121);
var state_26192__$1 = state_26192;
var statearr_26222_26263 = state_26192__$1;
(statearr_26222_26263[(2)] = inst_26122);

(statearr_26222_26263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (5))){
var _ = (function (){var statearr_26223 = state_26192;
(statearr_26223[(4)] = cljs.core.rest((state_26192[(4)])));

return statearr_26223;
})();
var state_26192__$1 = state_26192;
var ex26219 = (state_26192__$1[(2)]);
var statearr_26224_26264 = state_26192__$1;
(statearr_26224_26264[(5)] = ex26219);


var statearr_26225_26265 = state_26192__$1;
(statearr_26225_26265[(1)] = (4));

(statearr_26225_26265[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (14))){
var inst_26140 = (state_26192[(8)]);
var inst_26148 = (state_26192[(11)]);
var inst_26151 = fluree.db.flake.t(inst_26148);
var inst_26152 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26140,inst_26151);
var state_26192__$1 = state_26192;
var statearr_26226_26266 = state_26192__$1;
(statearr_26226_26266[(2)] = inst_26152);

(statearr_26226_26266[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (26))){
var inst_26177 = (state_26192[(2)]);
var state_26192__$1 = state_26192;
var statearr_26227_26267 = state_26192__$1;
(statearr_26227_26267[(2)] = inst_26177);

(statearr_26227_26267[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (16))){
var inst_26155 = (state_26192[(2)]);
var state_26192__$1 = state_26192;
if(cljs.core.truth_(inst_26155)){
var statearr_26228_26268 = state_26192__$1;
(statearr_26228_26268[(1)] = (17));

} else {
var statearr_26229_26269 = state_26192__$1;
(statearr_26229_26269[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (10))){
var inst_26124 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26132 = cljs.core.seq(inst_26124);
var inst_26133 = cljs.core.first(inst_26132);
var inst_26134 = cljs.core.next(inst_26132);
var inst_26135 = cljs.core.first(inst_26124);
var inst_26136 = fluree.db.flake.t(inst_26135);
var inst_26137 = cljs.core.PersistentVector.EMPTY;
var inst_26138 = db;
var inst_26139 = inst_26124;
var inst_26140 = inst_26136;
var inst_26141 = inst_26137;
var inst_26142 = inst_26138;
var state_26192__$1 = (function (){var statearr_26230 = state_26192;
(statearr_26230[(7)] = inst_26142);

(statearr_26230[(8)] = inst_26140);

(statearr_26230[(14)] = inst_26133);

(statearr_26230[(13)] = inst_26139);

(statearr_26230[(9)] = inst_26141);

(statearr_26230[(15)] = inst_26134);

return statearr_26230;
})();
var statearr_26231_26270 = state_26192__$1;
(statearr_26231_26270[(2)] = null);

(statearr_26231_26270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (18))){
var state_26192__$1 = state_26192;
var statearr_26232_26271 = state_26192__$1;
(statearr_26232_26271[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26193 === (8))){
var inst_26118 = (state_26192[(2)]);
var inst_26119 = cljs.core.empty_QMARK_(flakes);
var state_26192__$1 = (function (){var statearr_26234 = state_26192;
(statearr_26234[(16)] = inst_26118);

return statearr_26234;
})();
if(inst_26119){
var statearr_26235_26272 = state_26192__$1;
(statearr_26235_26272[(1)] = (9));

} else {
var statearr_26236_26273 = state_26192__$1;
(statearr_26236_26273[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26237 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26237[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26237[(1)] = (1));

return statearr_26237;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26192){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26192);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26238){var ex__2730__auto__ = e26238;
var statearr_26239_26274 = state_26192;
(statearr_26239_26274[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26192[(4)]))){
var statearr_26240_26275 = state_26192;
(statearr_26240_26275[(1)] = cljs.core.first((state_26192[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26276 = state_26192;
state_26192 = G__26276;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26192){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26241 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26241[(6)] = c__2749__auto___26243);

return statearr_26241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26328){
var state_val_26329 = (state_26328[(1)]);
if((state_val_26329 === (7))){
var state_26328__$1 = state_26328;
var statearr_26330_26357 = state_26328__$1;
(statearr_26330_26357[(2)] = tt_id);

(statearr_26330_26357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (1))){
var state_26328__$1 = state_26328;
var statearr_26331_26358 = state_26328__$1;
(statearr_26331_26358[(2)] = null);

(statearr_26331_26358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (4))){
var inst_26277 = (state_26328[(2)]);
var state_26328__$1 = state_26328;
var statearr_26332_26359 = state_26328__$1;
(statearr_26332_26359[(2)] = inst_26277);

(statearr_26332_26359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (13))){
var inst_26321 = (state_26328[(2)]);
var state_26328__$1 = state_26328;
var statearr_26333_26360 = state_26328__$1;
(statearr_26333_26360[(2)] = inst_26321);

(statearr_26333_26360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (6))){
var inst_26285 = cljs.core.random_uuid();
var state_26328__$1 = state_26328;
var statearr_26334_26361 = state_26328__$1;
(statearr_26334_26361[(2)] = inst_26285);

(statearr_26334_26361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (3))){
var inst_26326 = (state_26328[(2)]);
var state_26328__$1 = state_26328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26328__$1,inst_26326);
} else {
if((state_val_26329 === (12))){
var inst_26304 = (state_26328[(7)]);
var state_26328__$1 = state_26328;
var statearr_26335_26362 = state_26328__$1;
(statearr_26335_26362[(2)] = inst_26304);

(statearr_26335_26362[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (2))){
var _ = (function (){var statearr_26336 = state_26328;
(statearr_26336[(4)] = cljs.core.cons((5),(state_26328[(4)])));

return statearr_26336;
})();
var inst_26283 = (tt_id == null);
var state_26328__$1 = state_26328;
if(cljs.core.truth_(inst_26283)){
var statearr_26337_26363 = state_26328__$1;
(statearr_26337_26363[(1)] = (6));

} else {
var statearr_26338_26364 = state_26328__$1;
(statearr_26338_26364[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (11))){
var inst_26304 = (state_26328[(7)]);
var inst_26311 = (state_26328[(8)]);
var inst_26314 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_26304,inst_26311);
var state_26328__$1 = state_26328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26328__$1,(14),inst_26314);
} else {
if((state_val_26329 === (9))){
var inst_26311 = (state_26328[(8)]);
var inst_26305 = (state_26328[(9)]);
var inst_26310 = cljs.core.seq(inst_26305);
var inst_26311__$1 = cljs.core.first(inst_26310);
var inst_26312 = cljs.core.next(inst_26310);
var state_26328__$1 = (function (){var statearr_26340 = state_26328;
(statearr_26340[(8)] = inst_26311__$1);

(statearr_26340[(10)] = inst_26312);

return statearr_26340;
})();
if(cljs.core.truth_(inst_26311__$1)){
var statearr_26341_26365 = state_26328__$1;
(statearr_26341_26365[(1)] = (11));

} else {
var statearr_26342_26366 = state_26328__$1;
(statearr_26342_26366[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (5))){
var _ = (function (){var statearr_26343 = state_26328;
(statearr_26343[(4)] = cljs.core.rest((state_26328[(4)])));

return statearr_26343;
})();
var state_26328__$1 = state_26328;
var ex26339 = (state_26328__$1[(2)]);
var statearr_26344_26367 = state_26328__$1;
(statearr_26344_26367[(5)] = ex26339);


if((ex26339 instanceof Error)){
var statearr_26345_26368 = state_26328__$1;
(statearr_26345_26368[(1)] = (4));

(statearr_26345_26368[(5)] = null);

} else {
throw ex26339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (14))){
var inst_26312 = (state_26328[(10)]);
var inst_26316 = (state_26328[(2)]);
var inst_26317 = fluree.db.util.async.throw_err(inst_26316);
var inst_26304 = inst_26317;
var inst_26305 = inst_26312;
var state_26328__$1 = (function (){var statearr_26346 = state_26328;
(statearr_26346[(7)] = inst_26304);

(statearr_26346[(9)] = inst_26305);

return statearr_26346;
})();
var statearr_26347_26369 = state_26328__$1;
(statearr_26347_26369[(2)] = null);

(statearr_26347_26369[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (10))){
var inst_26323 = (state_26328[(2)]);
var _ = (function (){var statearr_26348 = state_26328;
(statearr_26348[(4)] = cljs.core.rest((state_26328[(4)])));

return statearr_26348;
})();
var state_26328__$1 = state_26328;
var statearr_26349_26370 = state_26328__$1;
(statearr_26349_26370[(2)] = inst_26323);

(statearr_26349_26370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26329 === (8))){
var inst_26288 = (state_26328[(2)]);
var inst_26289 = (function (){var tt_id__$1 = inst_26288;
return (function (db_STAR_,idx){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26290 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26288);
var inst_26291 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26289,inst_26290,fluree.db.index.types);
var inst_26292 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26293 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26292);
var inst_26301 = cljs.core.seq(inst_26293);
var inst_26302 = cljs.core.first(inst_26301);
var inst_26303 = cljs.core.next(inst_26301);
var inst_26304 = inst_26291;
var inst_26305 = inst_26293;
var state_26328__$1 = (function (){var statearr_26350 = state_26328;
(statearr_26350[(7)] = inst_26304);

(statearr_26350[(11)] = inst_26303);

(statearr_26350[(12)] = inst_26302);

(statearr_26350[(9)] = inst_26305);

return statearr_26350;
})();
var statearr_26351_26371 = state_26328__$1;
(statearr_26351_26371[(2)] = null);

(statearr_26351_26371[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0 = (function (){
var statearr_26352 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26352[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__);

(statearr_26352[(1)] = (1));

return statearr_26352;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1 = (function (state_26328){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26328);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26353){var ex__2730__auto__ = e26353;
var statearr_26354_26372 = state_26328;
(statearr_26354_26372[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26328[(4)]))){
var statearr_26355_26373 = state_26328;
(statearr_26355_26373[(1)] = cljs.core.first((state_26328[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26374 = state_26328;
state_26328 = G__26374;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = function(state_26328){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1.call(this,state_26328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26356 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26356[(6)] = c__2749__auto__);

return statearr_26356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___26561 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26492){
var state_val_26493 = (state_26492[(1)]);
if((state_val_26493 === (7))){
var inst_26402 = (state_26492[(7)]);
var inst_26402__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26492__$1 = (function (){var statearr_26494 = state_26492;
(statearr_26494[(7)] = inst_26402__$1);

return statearr_26494;
})();
if(inst_26402__$1){
var statearr_26495_26562 = state_26492__$1;
(statearr_26495_26562[(1)] = (13));

} else {
var statearr_26496_26563 = state_26492__$1;
(statearr_26496_26563[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (20))){
var state_26492__$1 = state_26492;
var statearr_26497_26564 = state_26492__$1;
(statearr_26497_26564[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (27))){
var inst_26438 = (state_26492[(8)]);
var inst_26442 = fluree.db.flake.s(inst_26438);
var state_26492__$1 = state_26492;
var statearr_26499_26565 = state_26492__$1;
(statearr_26499_26565[(2)] = inst_26442);

(statearr_26499_26565[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (1))){
var state_26492__$1 = state_26492;
var statearr_26500_26566 = state_26492__$1;
(statearr_26500_26566[(2)] = null);

(statearr_26500_26566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (24))){
var inst_26432 = (state_26492[(9)]);
var inst_26436 = cljs.core.first(inst_26432);
var state_26492__$1 = state_26492;
var statearr_26501_26567 = state_26492__$1;
(statearr_26501_26567[(2)] = inst_26436);

(statearr_26501_26567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (39))){
var state_26492__$1 = state_26492;
var statearr_26502_26568 = state_26492__$1;
(statearr_26502_26568[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (4))){
var inst_26375 = (state_26492[(2)]);
var inst_26376 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26377 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26378 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26379 = cljs.core.PersistentHashMap.fromArrays(inst_26377,inst_26378);
var inst_26380 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_26376,inst_26379,inst_26375);
var inst_26381 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26380);
var state_26492__$1 = state_26492;
var statearr_26504_26569 = state_26492__$1;
(statearr_26504_26569[(2)] = inst_26381);

(statearr_26504_26569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (15))){
var inst_26409 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
if(cljs.core.truth_(inst_26409)){
var statearr_26505_26570 = state_26492__$1;
(statearr_26505_26570[(1)] = (16));

} else {
var statearr_26506_26571 = state_26492__$1;
(statearr_26506_26571[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (21))){
var inst_26458 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26507_26572 = state_26492__$1;
(statearr_26507_26572[(2)] = inst_26458);

(statearr_26507_26572[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (31))){
var inst_26456 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26508_26573 = state_26492__$1;
(statearr_26508_26573[(2)] = inst_26456);

(statearr_26508_26573[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (32))){
var inst_26462 = (state_26492[(10)]);
var inst_26464 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26462);
var state_26492__$1 = state_26492;
var statearr_26509_26574 = state_26492__$1;
(statearr_26509_26574[(2)] = inst_26464);

(statearr_26509_26574[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (40))){
var inst_26485 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26510_26575 = state_26492__$1;
(statearr_26510_26575[(2)] = inst_26485);

(statearr_26510_26575[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (33))){
var inst_26466 = (state_26492[(11)]);
var inst_26462 = (state_26492[(10)]);
var inst_26466__$1 = (inst_26462 == null);
var state_26492__$1 = (function (){var statearr_26511 = state_26492;
(statearr_26511[(11)] = inst_26466__$1);

return statearr_26511;
})();
if(cljs.core.truth_(inst_26466__$1)){
var statearr_26512_26576 = state_26492__$1;
(statearr_26512_26576[(1)] = (35));

} else {
var statearr_26513_26577 = state_26492__$1;
(statearr_26513_26577[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (13))){
var inst_26404 = cljs.core.first(ident);
var inst_26405 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26404);
var inst_26406 = (inst_26405 == null);
var state_26492__$1 = state_26492;
var statearr_26514_26578 = state_26492__$1;
(statearr_26514_26578[(2)] = inst_26406);

(statearr_26514_26578[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (22))){
var inst_26432 = (state_26492[(9)]);
var inst_26431 = (state_26492[(2)]);
var inst_26432__$1 = fluree.db.util.async.throw_err(inst_26431);
var inst_26433 = (inst_26432__$1 == null);
var state_26492__$1 = (function (){var statearr_26515 = state_26492;
(statearr_26515[(9)] = inst_26432__$1);

return statearr_26515;
})();
if(cljs.core.truth_(inst_26433)){
var statearr_26516_26579 = state_26492__$1;
(statearr_26516_26579[(1)] = (23));

} else {
var statearr_26517_26580 = state_26492__$1;
(statearr_26517_26580[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (36))){
var inst_26466 = (state_26492[(11)]);
var state_26492__$1 = state_26492;
var statearr_26518_26581 = state_26492__$1;
(statearr_26518_26581[(2)] = inst_26466);

(statearr_26518_26581[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (41))){
var inst_26480 = cljs.core.async.close_BANG_(return_chan);
var state_26492__$1 = state_26492;
var statearr_26519_26582 = state_26492__$1;
(statearr_26519_26582[(2)] = inst_26480);

(statearr_26519_26582[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (43))){
var inst_26483 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26520_26583 = state_26492__$1;
(statearr_26520_26583[(2)] = inst_26483);

(statearr_26520_26583[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (29))){
var inst_26447 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_26448 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26447].join('');
var inst_26449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26450 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26451 = cljs.core.PersistentHashMap.fromArrays(inst_26449,inst_26450);
var inst_26452 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26448,inst_26451);
var inst_26453 = (function(){throw inst_26452})();
var state_26492__$1 = state_26492;
var statearr_26521_26584 = state_26492__$1;
(statearr_26521_26584[(2)] = inst_26453);

(statearr_26521_26584[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (6))){
var inst_26389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26390 = [ident];
var inst_26391 = (new cljs.core.PersistentVector(null,1,(5),inst_26389,inst_26390,null));
var inst_26392 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26391);
var state_26492__$1 = state_26492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26492__$1,(9),inst_26392);
} else {
if((state_val_26493 === (28))){
var inst_26444 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26522_26585 = state_26492__$1;
(statearr_26522_26585[(2)] = inst_26444);

(statearr_26522_26585[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (25))){
var inst_26438 = (state_26492[(8)]);
var inst_26438__$1 = (state_26492[(2)]);
var inst_26439 = (inst_26438__$1 == null);
var state_26492__$1 = (function (){var statearr_26523 = state_26492;
(statearr_26523[(8)] = inst_26438__$1);

return statearr_26523;
})();
if(cljs.core.truth_(inst_26439)){
var statearr_26524_26586 = state_26492__$1;
(statearr_26524_26586[(1)] = (26));

} else {
var statearr_26525_26587 = state_26492__$1;
(statearr_26525_26587[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (34))){
var inst_26487 = (state_26492[(2)]);
var _ = (function (){var statearr_26526 = state_26492;
(statearr_26526[(4)] = cljs.core.rest((state_26492[(4)])));

return statearr_26526;
})();
var state_26492__$1 = state_26492;
var statearr_26527_26588 = state_26492__$1;
(statearr_26527_26588[(2)] = inst_26487);

(statearr_26527_26588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (17))){
var inst_26420 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26492__$1 = state_26492;
if(inst_26420){
var statearr_26528_26589 = state_26492__$1;
(statearr_26528_26589[(1)] = (19));

} else {
var statearr_26529_26590 = state_26492__$1;
(statearr_26529_26590[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (3))){
var inst_26490 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26492__$1,inst_26490);
} else {
if((state_val_26493 === (12))){
var inst_26400 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26530_26591 = state_26492__$1;
(statearr_26530_26591[(2)] = inst_26400);

(statearr_26530_26591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (2))){
var _ = (function (){var statearr_26531 = state_26492;
(statearr_26531[(4)] = cljs.core.cons((5),(state_26492[(4)])));

return statearr_26531;
})();
var inst_26387 = typeof ident === 'number';
var state_26492__$1 = state_26492;
if(cljs.core.truth_(inst_26387)){
var statearr_26532_26592 = state_26492__$1;
(statearr_26532_26592[(1)] = (6));

} else {
var statearr_26533_26593 = state_26492__$1;
(statearr_26533_26593[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (23))){
var state_26492__$1 = state_26492;
var statearr_26534_26594 = state_26492__$1;
(statearr_26534_26594[(2)] = null);

(statearr_26534_26594[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (35))){
var state_26492__$1 = state_26492;
var statearr_26535_26595 = state_26492__$1;
(statearr_26535_26595[(2)] = strict_QMARK_);

(statearr_26535_26595[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (19))){
var inst_26423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26424 = cljs.core.first(ident);
var inst_26425 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26424);
var inst_26426 = cljs.core.second(ident);
var inst_26427 = [inst_26425,inst_26426];
var inst_26428 = (new cljs.core.PersistentVector(null,2,(5),inst_26423,inst_26427,null));
var inst_26429 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26428);
var state_26492__$1 = state_26492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26492__$1,(22),inst_26429);
} else {
if((state_val_26493 === (11))){
var state_26492__$1 = state_26492;
var statearr_26537_26596 = state_26492__$1;
(statearr_26537_26596[(2)] = null);

(statearr_26537_26596[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (9))){
var inst_26394 = (state_26492[(2)]);
var inst_26395 = fluree.db.util.async.throw_err(inst_26394);
var inst_26396 = cljs.core.not_empty(inst_26395);
var state_26492__$1 = state_26492;
if(cljs.core.truth_(inst_26396)){
var statearr_26538_26597 = state_26492__$1;
(statearr_26538_26597[(1)] = (10));

} else {
var statearr_26539_26598 = state_26492__$1;
(statearr_26539_26598[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (5))){
var _ = (function (){var statearr_26540 = state_26492;
(statearr_26540[(4)] = cljs.core.rest((state_26492[(4)])));

return statearr_26540;
})();
var state_26492__$1 = state_26492;
var ex26536 = (state_26492__$1[(2)]);
var statearr_26541_26599 = state_26492__$1;
(statearr_26541_26599[(5)] = ex26536);


var statearr_26542_26600 = state_26492__$1;
(statearr_26542_26600[(1)] = (4));

(statearr_26542_26600[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (14))){
var inst_26402 = (state_26492[(7)]);
var state_26492__$1 = state_26492;
var statearr_26543_26601 = state_26492__$1;
(statearr_26543_26601[(2)] = inst_26402);

(statearr_26543_26601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (26))){
var state_26492__$1 = state_26492;
var statearr_26544_26602 = state_26492__$1;
(statearr_26544_26602[(2)] = null);

(statearr_26544_26602[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (16))){
var inst_26411 = cljs.core.first(ident);
var inst_26412 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26411], 0));
var inst_26413 = ["Subject ID lookup failed. The predicate ",inst_26412," does not exist."].join('');
var inst_26414 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26415 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26416 = cljs.core.PersistentHashMap.fromArrays(inst_26414,inst_26415);
var inst_26417 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26413,inst_26416);
var inst_26418 = (function(){throw inst_26417})();
var state_26492__$1 = state_26492;
var statearr_26545_26603 = state_26492__$1;
(statearr_26545_26603[(2)] = inst_26418);

(statearr_26545_26603[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (38))){
var inst_26472 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26473 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26474 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26475 = cljs.core.PersistentHashMap.fromArrays(inst_26473,inst_26474);
var inst_26476 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26472,inst_26475);
var inst_26477 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26476);
var state_26492__$1 = state_26492;
var statearr_26546_26604 = state_26492__$1;
(statearr_26546_26604[(2)] = inst_26477);

(statearr_26546_26604[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (30))){
var state_26492__$1 = state_26492;
var statearr_26547_26605 = state_26492__$1;
(statearr_26547_26605[(2)] = null);

(statearr_26547_26605[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (10))){
var state_26492__$1 = state_26492;
var statearr_26548_26606 = state_26492__$1;
(statearr_26548_26606[(2)] = ident);

(statearr_26548_26606[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (18))){
var inst_26460 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
var statearr_26549_26607 = state_26492__$1;
(statearr_26549_26607[(2)] = inst_26460);

(statearr_26549_26607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (42))){
var state_26492__$1 = state_26492;
var statearr_26550_26608 = state_26492__$1;
(statearr_26550_26608[(2)] = null);

(statearr_26550_26608[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (37))){
var inst_26470 = (state_26492[(2)]);
var state_26492__$1 = state_26492;
if(cljs.core.truth_(inst_26470)){
var statearr_26551_26609 = state_26492__$1;
(statearr_26551_26609[(1)] = (38));

} else {
var statearr_26552_26610 = state_26492__$1;
(statearr_26552_26610[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26493 === (8))){
var inst_26462 = (state_26492[(10)]);
var inst_26462__$1 = (state_26492[(2)]);
var state_26492__$1 = (function (){var statearr_26553 = state_26492;
(statearr_26553[(10)] = inst_26462__$1);

return statearr_26553;
})();
if(cljs.core.truth_(inst_26462__$1)){
var statearr_26554_26611 = state_26492__$1;
(statearr_26554_26611[(1)] = (32));

} else {
var statearr_26555_26612 = state_26492__$1;
(statearr_26555_26612[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2727__auto____0 = (function (){
var statearr_26556 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26556[(0)] = fluree$db$graphdb$subid_$_state_machine__2727__auto__);

(statearr_26556[(1)] = (1));

return statearr_26556;
});
var fluree$db$graphdb$subid_$_state_machine__2727__auto____1 = (function (state_26492){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26492);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26557){var ex__2730__auto__ = e26557;
var statearr_26558_26613 = state_26492;
(statearr_26558_26613[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26492[(4)]))){
var statearr_26559_26614 = state_26492;
(statearr_26559_26614[(1)] = cljs.core.first((state_26492[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26615 = state_26492;
state_26492 = G__26615;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2727__auto__ = function(state_26492){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____1.call(this,state_26492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2727__auto____0;
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2727__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26560 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26560[(6)] = c__2749__auto___26561);

return statearr_26560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26616){
var map__26617 = p__26616;
var map__26617__$1 = cljs.core.__destructure_map(map__26617);
var db = map__26617__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26617__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26617__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26633){
var state_val_26634 = (state_26633[(1)]);
if((state_val_26634 === (1))){
var state_26633__$1 = state_26633;
var statearr_26635_26649 = state_26633__$1;
(statearr_26635_26649[(2)] = null);

(statearr_26635_26649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (2))){
var _ = (function (){var statearr_26636 = state_26633;
(statearr_26636[(4)] = cljs.core.cons((5),(state_26633[(4)])));

return statearr_26636;
})();
var inst_26624 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_26633__$1 = state_26633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26633__$1,(6),inst_26624);
} else {
if((state_val_26634 === (3))){
var inst_26631 = (state_26633[(2)]);
var state_26633__$1 = state_26633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26633__$1,inst_26631);
} else {
if((state_val_26634 === (4))){
var inst_26618 = (state_26633[(2)]);
var state_26633__$1 = state_26633;
var statearr_26638_26650 = state_26633__$1;
(statearr_26638_26650[(2)] = inst_26618);

(statearr_26638_26650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (5))){
var _ = (function (){var statearr_26639 = state_26633;
(statearr_26639[(4)] = cljs.core.rest((state_26633[(4)])));

return statearr_26639;
})();
var state_26633__$1 = state_26633;
var ex26637 = (state_26633__$1[(2)]);
var statearr_26640_26651 = state_26633__$1;
(statearr_26640_26651[(5)] = ex26637);


if((ex26637 instanceof Error)){
var statearr_26641_26652 = state_26633__$1;
(statearr_26641_26652[(1)] = (4));

(statearr_26641_26652[(5)] = null);

} else {
throw ex26637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (6))){
var inst_26626 = (state_26633[(2)]);
var inst_26627 = fluree.db.util.async.throw_err(inst_26626);
var inst_26628 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26627,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26642 = state_26633;
(statearr_26642[(4)] = cljs.core.rest((state_26633[(4)])));

return statearr_26642;
})();
var state_26633__$1 = state_26633;
var statearr_26643_26653 = state_26633__$1;
(statearr_26643_26653[(2)] = inst_26628);

(statearr_26643_26653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0 = (function (){
var statearr_26644 = [null,null,null,null,null,null,null];
(statearr_26644[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__);

(statearr_26644[(1)] = (1));

return statearr_26644;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1 = (function (state_26633){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26633);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26645){var ex__2730__auto__ = e26645;
var statearr_26646_26654 = state_26633;
(statearr_26646_26654[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26633[(4)]))){
var statearr_26647_26655 = state_26633;
(statearr_26647_26655[(1)] = cljs.core.first((state_26633[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26656 = state_26633;
state_26633 = G__26656;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = function(state_26633){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1.call(this,state_26633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26648 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26648[(6)] = c__2749__auto__);

return statearr_26648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26657,property,collection){
var map__26658 = p__26657;
var map__26658__$1 = cljs.core.__destructure_map(map__26658);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26658__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26659 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__26659.cljs$core$IFn$_invoke$arity$1 ? fexpr__26659.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26659.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26660,property,predicate){
var map__26661 = p__26660;
var map__26661__$1 = cljs.core.__destructure_map(map__26661);
var this$ = map__26661__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26661__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26662 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__26662.cljs$core$IFn$_invoke$arity$1 ? fexpr__26662.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26662.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26663 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26663);
} else {
return G__26663;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26665 = arguments.length;
switch (G__26665) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26697){
var state_val_26698 = (state_26697[(1)]);
if((state_val_26698 === (7))){
var state_26697__$1 = state_26697;
var statearr_26699_26793 = state_26697__$1;
(statearr_26699_26793[(2)] = null);

(statearr_26699_26793[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (1))){
var state_26697__$1 = state_26697;
var statearr_26700_26794 = state_26697__$1;
(statearr_26700_26794[(2)] = null);

(statearr_26700_26794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (4))){
var inst_26666 = (state_26697[(2)]);
var state_26697__$1 = state_26697;
var statearr_26701_26795 = state_26697__$1;
(statearr_26701_26795[(2)] = inst_26666);

(statearr_26701_26795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (6))){
var inst_26680 = (state_26697[(7)]);
var inst_26679 = (state_26697[(2)]);
var inst_26680__$1 = fluree.db.util.async.throw_err(inst_26679);
var inst_26681 = (inst_26680__$1 == null);
var state_26697__$1 = (function (){var statearr_26702 = state_26697;
(statearr_26702[(7)] = inst_26680__$1);

return statearr_26702;
})();
if(cljs.core.truth_(inst_26681)){
var statearr_26703_26796 = state_26697__$1;
(statearr_26703_26796[(1)] = (7));

} else {
var statearr_26704_26797 = state_26697__$1;
(statearr_26704_26797[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (3))){
var inst_26695 = (state_26697[(2)]);
var state_26697__$1 = state_26697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26697__$1,inst_26695);
} else {
if((state_val_26698 === (12))){
var inst_26692 = (state_26697[(2)]);
var _ = (function (){var statearr_26705 = state_26697;
(statearr_26705[(4)] = cljs.core.rest((state_26697[(4)])));

return statearr_26705;
})();
var state_26697__$1 = state_26697;
var statearr_26706_26798 = state_26697__$1;
(statearr_26706_26798[(2)] = inst_26692);

(statearr_26706_26798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (2))){
var _ = (function (){var statearr_26707 = state_26697;
(statearr_26707[(4)] = cljs.core.cons((5),(state_26697[(4)])));

return statearr_26707;
})();
var inst_26673 = fluree.db.dbproto._rootdb(this$);
var inst_26674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26675 = [tag_id,(30)];
var inst_26676 = (new cljs.core.PersistentVector(null,2,(5),inst_26674,inst_26675,null));
var inst_26677 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26673,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26676);
var state_26697__$1 = state_26697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26697__$1,(6),inst_26677);
} else {
if((state_val_26698 === (11))){
var inst_26686 = (state_26697[(8)]);
var inst_26690 = fluree.db.flake.o(inst_26686);
var state_26697__$1 = state_26697;
var statearr_26709_26799 = state_26697__$1;
(statearr_26709_26799[(2)] = inst_26690);

(statearr_26709_26799[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (9))){
var inst_26686 = (state_26697[(8)]);
var inst_26686__$1 = (state_26697[(2)]);
var inst_26687 = (inst_26686__$1 == null);
var state_26697__$1 = (function (){var statearr_26710 = state_26697;
(statearr_26710[(8)] = inst_26686__$1);

return statearr_26710;
})();
if(cljs.core.truth_(inst_26687)){
var statearr_26711_26800 = state_26697__$1;
(statearr_26711_26800[(1)] = (10));

} else {
var statearr_26712_26801 = state_26697__$1;
(statearr_26712_26801[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (5))){
var _ = (function (){var statearr_26713 = state_26697;
(statearr_26713[(4)] = cljs.core.rest((state_26697[(4)])));

return statearr_26713;
})();
var state_26697__$1 = state_26697;
var ex26708 = (state_26697__$1[(2)]);
var statearr_26714_26802 = state_26697__$1;
(statearr_26714_26802[(5)] = ex26708);


if((ex26708 instanceof Error)){
var statearr_26715_26803 = state_26697__$1;
(statearr_26715_26803[(1)] = (4));

(statearr_26715_26803[(5)] = null);

} else {
throw ex26708;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (10))){
var state_26697__$1 = state_26697;
var statearr_26716_26804 = state_26697__$1;
(statearr_26716_26804[(2)] = null);

(statearr_26716_26804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26698 === (8))){
var inst_26680 = (state_26697[(7)]);
var inst_26684 = cljs.core.first(inst_26680);
var state_26697__$1 = state_26697;
var statearr_26717_26805 = state_26697__$1;
(statearr_26717_26805[(2)] = inst_26684);

(statearr_26717_26805[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26718 = [null,null,null,null,null,null,null,null,null];
(statearr_26718[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26718[(1)] = (1));

return statearr_26718;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26697){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26697);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26719){var ex__2730__auto__ = e26719;
var statearr_26720_26806 = state_26697;
(statearr_26720_26806[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26697[(4)]))){
var statearr_26721_26807 = state_26697;
(statearr_26721_26807[(1)] = cljs.core.first((state_26697[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26808 = state_26697;
state_26697 = G__26808;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26697){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26722 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26722[(6)] = c__2749__auto__);

return statearr_26722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26758){
var state_val_26759 = (state_26758[(1)]);
if((state_val_26759 === (7))){
var inst_26732 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26758__$1 = state_26758;
var statearr_26760_26809 = state_26758__$1;
(statearr_26760_26809[(2)] = inst_26732);

(statearr_26760_26809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (1))){
var state_26758__$1 = state_26758;
var statearr_26761_26810 = state_26758__$1;
(statearr_26761_26810[(2)] = null);

(statearr_26761_26810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (4))){
var inst_26723 = (state_26758[(2)]);
var state_26758__$1 = state_26758;
var statearr_26762_26811 = state_26758__$1;
(statearr_26762_26811[(2)] = inst_26723);

(statearr_26762_26811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (15))){
var inst_26753 = (state_26758[(2)]);
var _ = (function (){var statearr_26763 = state_26758;
(statearr_26763[(4)] = cljs.core.rest((state_26758[(4)])));

return statearr_26763;
})();
var state_26758__$1 = state_26758;
var statearr_26764_26812 = state_26758__$1;
(statearr_26764_26812[(2)] = inst_26753);

(statearr_26764_26812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (13))){
var inst_26738 = (state_26758[(7)]);
var inst_26744 = clojure.string.includes_QMARK_(inst_26738,":");
var state_26758__$1 = state_26758;
if(inst_26744){
var statearr_26765_26813 = state_26758__$1;
(statearr_26765_26813[(1)] = (16));

} else {
var statearr_26766_26814 = state_26758__$1;
(statearr_26766_26814[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (6))){
var state_26758__$1 = state_26758;
var statearr_26767_26815 = state_26758__$1;
(statearr_26767_26815[(2)] = pred);

(statearr_26767_26815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (17))){
var inst_26738 = (state_26758[(7)]);
var state_26758__$1 = state_26758;
var statearr_26768_26816 = state_26758__$1;
(statearr_26768_26816[(2)] = inst_26738);

(statearr_26768_26816[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (3))){
var inst_26756 = (state_26758[(2)]);
var state_26758__$1 = state_26758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26758__$1,inst_26756);
} else {
if((state_val_26759 === (12))){
var inst_26742 = (state_26758[(2)]);
var state_26758__$1 = state_26758;
if(cljs.core.truth_(inst_26742)){
var statearr_26769_26817 = state_26758__$1;
(statearr_26769_26817[(1)] = (13));

} else {
var statearr_26770_26818 = state_26758__$1;
(statearr_26770_26818[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (2))){
var _ = (function (){var statearr_26771 = state_26758;
(statearr_26771[(4)] = cljs.core.cons((5),(state_26758[(4)])));

return statearr_26771;
})();
var inst_26729 = typeof pred === 'string';
var state_26758__$1 = state_26758;
if(cljs.core.truth_(inst_26729)){
var statearr_26772_26819 = state_26758__$1;
(statearr_26772_26819[(1)] = (6));

} else {
var statearr_26773_26820 = state_26758__$1;
(statearr_26773_26820[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (11))){
var inst_26734 = (state_26758[(8)]);
var state_26758__$1 = state_26758;
var statearr_26775_26821 = state_26758__$1;
(statearr_26775_26821[(2)] = inst_26734);

(statearr_26775_26821[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (9))){
var inst_26734 = (state_26758[(8)]);
var inst_26737 = (state_26758[(2)]);
var inst_26738 = fluree.db.util.async.throw_err(inst_26737);
var state_26758__$1 = (function (){var statearr_26776 = state_26758;
(statearr_26776[(7)] = inst_26738);

return statearr_26776;
})();
if(cljs.core.truth_(inst_26734)){
var statearr_26777_26822 = state_26758__$1;
(statearr_26777_26822[(1)] = (10));

} else {
var statearr_26778_26823 = state_26758__$1;
(statearr_26778_26823[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (5))){
var _ = (function (){var statearr_26779 = state_26758;
(statearr_26779[(4)] = cljs.core.rest((state_26758[(4)])));

return statearr_26779;
})();
var state_26758__$1 = state_26758;
var ex26774 = (state_26758__$1[(2)]);
var statearr_26780_26824 = state_26758__$1;
(statearr_26780_26824[(5)] = ex26774);


if((ex26774 instanceof Error)){
var statearr_26781_26825 = state_26758__$1;
(statearr_26781_26825[(1)] = (4));

(statearr_26781_26825[(5)] = null);

} else {
throw ex26774;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (14))){
var state_26758__$1 = state_26758;
var statearr_26782_26826 = state_26758__$1;
(statearr_26782_26826[(2)] = null);

(statearr_26782_26826[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (16))){
var inst_26738 = (state_26758[(7)]);
var inst_26746 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_26738,/:/);
var inst_26747 = cljs.core.second(inst_26746);
var state_26758__$1 = state_26758;
var statearr_26783_26827 = state_26758__$1;
(statearr_26783_26827[(2)] = inst_26747);

(statearr_26783_26827[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (10))){
var inst_26738 = (state_26758[(7)]);
var state_26758__$1 = state_26758;
var statearr_26784_26828 = state_26758__$1;
(statearr_26784_26828[(2)] = inst_26738);

(statearr_26784_26828[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (18))){
var inst_26750 = (state_26758[(2)]);
var state_26758__$1 = state_26758;
var statearr_26785_26829 = state_26758__$1;
(statearr_26785_26829[(2)] = inst_26750);

(statearr_26785_26829[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26759 === (8))){
var inst_26734 = (state_26758[(2)]);
var inst_26735 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_26758__$1 = (function (){var statearr_26786 = state_26758;
(statearr_26786[(8)] = inst_26734);

return statearr_26786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26758__$1,(9),inst_26735);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26787 = [null,null,null,null,null,null,null,null,null];
(statearr_26787[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26787[(1)] = (1));

return statearr_26787;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26758){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26758);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26788){var ex__2730__auto__ = e26788;
var statearr_26789_26830 = state_26758;
(statearr_26789_26830[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26758[(4)]))){
var statearr_26790_26831 = state_26758;
(statearr_26790_26831[(1)] = cljs.core.first((state_26758[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26832 = state_26758;
state_26758 = G__26832;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26758){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26791 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26791[(6)] = c__2749__auto__);

return statearr_26791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26834 = arguments.length;
switch (G__26834) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26867){
var state_val_26868 = (state_26867[(1)]);
if((state_val_26868 === (7))){
var state_26867__$1 = state_26867;
var statearr_26869_26957 = state_26867__$1;
(statearr_26869_26957[(2)] = null);

(statearr_26869_26957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (1))){
var state_26867__$1 = state_26867;
var statearr_26870_26958 = state_26867__$1;
(statearr_26870_26958[(2)] = null);

(statearr_26870_26958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (4))){
var inst_26835 = (state_26867[(2)]);
var state_26867__$1 = state_26867;
var statearr_26871_26959 = state_26867__$1;
(statearr_26871_26959[(2)] = inst_26835);

(statearr_26871_26959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (6))){
var inst_26850 = (state_26867[(7)]);
var inst_26849 = (state_26867[(2)]);
var inst_26850__$1 = fluree.db.util.async.throw_err(inst_26849);
var inst_26851 = (inst_26850__$1 == null);
var state_26867__$1 = (function (){var statearr_26872 = state_26867;
(statearr_26872[(7)] = inst_26850__$1);

return statearr_26872;
})();
if(cljs.core.truth_(inst_26851)){
var statearr_26873_26960 = state_26867__$1;
(statearr_26873_26960[(1)] = (7));

} else {
var statearr_26874_26961 = state_26867__$1;
(statearr_26874_26961[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (3))){
var inst_26865 = (state_26867[(2)]);
var state_26867__$1 = state_26867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26867__$1,inst_26865);
} else {
if((state_val_26868 === (12))){
var inst_26862 = (state_26867[(2)]);
var _ = (function (){var statearr_26875 = state_26867;
(statearr_26875[(4)] = cljs.core.rest((state_26867[(4)])));

return statearr_26875;
})();
var state_26867__$1 = state_26867;
var statearr_26876_26962 = state_26867__$1;
(statearr_26876_26962[(2)] = inst_26862);

(statearr_26876_26962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (2))){
var _ = (function (){var statearr_26877 = state_26867;
(statearr_26877[(4)] = cljs.core.cons((5),(state_26867[(4)])));

return statearr_26877;
})();
var inst_26841 = (30);
var inst_26843 = fluree.db.dbproto._rootdb(this$);
var inst_26844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26845 = [inst_26841,tag_name];
var inst_26846 = (new cljs.core.PersistentVector(null,2,(5),inst_26844,inst_26845,null));
var inst_26847 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26843,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26846);
var state_26867__$1 = state_26867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26867__$1,(6),inst_26847);
} else {
if((state_val_26868 === (11))){
var inst_26856 = (state_26867[(8)]);
var inst_26860 = fluree.db.flake.s(inst_26856);
var state_26867__$1 = state_26867;
var statearr_26879_26963 = state_26867__$1;
(statearr_26879_26963[(2)] = inst_26860);

(statearr_26879_26963[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (9))){
var inst_26856 = (state_26867[(8)]);
var inst_26856__$1 = (state_26867[(2)]);
var inst_26857 = (inst_26856__$1 == null);
var state_26867__$1 = (function (){var statearr_26880 = state_26867;
(statearr_26880[(8)] = inst_26856__$1);

return statearr_26880;
})();
if(cljs.core.truth_(inst_26857)){
var statearr_26881_26964 = state_26867__$1;
(statearr_26881_26964[(1)] = (10));

} else {
var statearr_26882_26965 = state_26867__$1;
(statearr_26882_26965[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (5))){
var _ = (function (){var statearr_26883 = state_26867;
(statearr_26883[(4)] = cljs.core.rest((state_26867[(4)])));

return statearr_26883;
})();
var state_26867__$1 = state_26867;
var ex26878 = (state_26867__$1[(2)]);
var statearr_26884_26966 = state_26867__$1;
(statearr_26884_26966[(5)] = ex26878);


if((ex26878 instanceof Error)){
var statearr_26885_26967 = state_26867__$1;
(statearr_26885_26967[(1)] = (4));

(statearr_26885_26967[(5)] = null);

} else {
throw ex26878;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (10))){
var state_26867__$1 = state_26867;
var statearr_26886_26968 = state_26867__$1;
(statearr_26886_26968[(2)] = null);

(statearr_26886_26968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (8))){
var inst_26850 = (state_26867[(7)]);
var inst_26854 = cljs.core.first(inst_26850);
var state_26867__$1 = state_26867;
var statearr_26887_26969 = state_26867__$1;
(statearr_26887_26969[(2)] = inst_26854);

(statearr_26887_26969[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26888 = [null,null,null,null,null,null,null,null,null];
(statearr_26888[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26888[(1)] = (1));

return statearr_26888;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26867){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26867);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26889){var ex__2730__auto__ = e26889;
var statearr_26890_26970 = state_26867;
(statearr_26890_26970[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26867[(4)]))){
var statearr_26891_26971 = state_26867;
(statearr_26891_26971[(1)] = cljs.core.first((state_26867[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26972 = state_26867;
state_26867 = G__26972;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26867){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26892 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26892[(6)] = c__2749__auto__);

return statearr_26892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26927){
var state_val_26928 = (state_26927[(1)]);
if((state_val_26928 === (7))){
var inst_26906 = typeof pred === 'string';
var state_26927__$1 = state_26927;
if(cljs.core.truth_(inst_26906)){
var statearr_26929_26973 = state_26927__$1;
(statearr_26929_26973[(1)] = (10));

} else {
var statearr_26930_26974 = state_26927__$1;
(statearr_26930_26974[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (1))){
var state_26927__$1 = state_26927;
var statearr_26931_26975 = state_26927__$1;
(statearr_26931_26975[(2)] = null);

(statearr_26931_26975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (4))){
var inst_26893 = (state_26927[(2)]);
var state_26927__$1 = state_26927;
var statearr_26932_26976 = state_26927__$1;
(statearr_26932_26976[(2)] = inst_26893);

(statearr_26932_26976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (15))){
var inst_26920 = (state_26927[(2)]);
var state_26927__$1 = state_26927;
var statearr_26933_26977 = state_26927__$1;
(statearr_26933_26977[(2)] = inst_26920);

(statearr_26933_26977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (13))){
var inst_26911 = (state_26927[(7)]);
var inst_26913 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26911),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26914 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_26913);
var state_26927__$1 = state_26927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26927__$1,(16),inst_26914);
} else {
if((state_val_26928 === (6))){
var inst_26901 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_26927__$1 = state_26927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26927__$1,(9),inst_26901);
} else {
if((state_val_26928 === (3))){
var inst_26925 = (state_26927[(2)]);
var state_26927__$1 = state_26927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26927__$1,inst_26925);
} else {
if((state_val_26928 === (12))){
var inst_26911 = (state_26927[(7)]);
var inst_26911__$1 = (state_26927[(2)]);
var state_26927__$1 = (function (){var statearr_26934 = state_26927;
(statearr_26934[(7)] = inst_26911__$1);

return statearr_26934;
})();
if(cljs.core.truth_(inst_26911__$1)){
var statearr_26935_26978 = state_26927__$1;
(statearr_26935_26978[(1)] = (13));

} else {
var statearr_26936_26979 = state_26927__$1;
(statearr_26936_26979[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (2))){
var _ = (function (){var statearr_26937 = state_26927;
(statearr_26937[(4)] = cljs.core.cons((5),(state_26927[(4)])));

return statearr_26937;
})();
var inst_26899 = clojure.string.includes_QMARK_(tag_name,"/");
var state_26927__$1 = state_26927;
if(inst_26899){
var statearr_26938_26980 = state_26927__$1;
(statearr_26938_26980[(1)] = (6));

} else {
var statearr_26939_26981 = state_26927__$1;
(statearr_26939_26981[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (11))){
var inst_26909 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26927__$1 = state_26927;
var statearr_26941_26982 = state_26927__$1;
(statearr_26941_26982[(2)] = inst_26909);

(statearr_26941_26982[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (9))){
var inst_26903 = (state_26927[(2)]);
var inst_26904 = fluree.db.util.async.throw_err(inst_26903);
var state_26927__$1 = state_26927;
var statearr_26942_26983 = state_26927__$1;
(statearr_26942_26983[(2)] = inst_26904);

(statearr_26942_26983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (5))){
var _ = (function (){var statearr_26943 = state_26927;
(statearr_26943[(4)] = cljs.core.rest((state_26927[(4)])));

return statearr_26943;
})();
var state_26927__$1 = state_26927;
var ex26940 = (state_26927__$1[(2)]);
var statearr_26944_26984 = state_26927__$1;
(statearr_26944_26984[(5)] = ex26940);


if((ex26940 instanceof Error)){
var statearr_26945_26985 = state_26927__$1;
(statearr_26945_26985[(1)] = (4));

(statearr_26945_26985[(5)] = null);

} else {
throw ex26940;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (14))){
var state_26927__$1 = state_26927;
var statearr_26946_26986 = state_26927__$1;
(statearr_26946_26986[(2)] = null);

(statearr_26946_26986[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (16))){
var inst_26916 = (state_26927[(2)]);
var inst_26917 = fluree.db.util.async.throw_err(inst_26916);
var state_26927__$1 = state_26927;
var statearr_26947_26987 = state_26927__$1;
(statearr_26947_26987[(2)] = inst_26917);

(statearr_26947_26987[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (10))){
var state_26927__$1 = state_26927;
var statearr_26948_26988 = state_26927__$1;
(statearr_26948_26988[(2)] = pred);

(statearr_26948_26988[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26928 === (8))){
var inst_26922 = (state_26927[(2)]);
var _ = (function (){var statearr_26949 = state_26927;
(statearr_26949[(4)] = cljs.core.rest((state_26927[(4)])));

return statearr_26949;
})();
var state_26927__$1 = state_26927;
var statearr_26950_26989 = state_26927__$1;
(statearr_26950_26989[(2)] = inst_26922);

(statearr_26950_26989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26951 = [null,null,null,null,null,null,null,null];
(statearr_26951[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26951[(1)] = (1));

return statearr_26951;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26927){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26927);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26952){var ex__2730__auto__ = e26952;
var statearr_26953_26990 = state_26927;
(statearr_26953_26990[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26927[(4)]))){
var statearr_26954_26991 = state_26927;
(statearr_26954_26991[(1)] = cljs.core.first((state_26927[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26992 = state_26927;
state_26927 = G__26992;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26927){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26955 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26955[(6)] = c__2749__auto__);

return statearr_26955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k26994,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__26998 = k26994;
var G__26998__$1 = (((G__26998 instanceof cljs.core.Keyword))?G__26998.fqn:null);
switch (G__26998__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26994,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__26999){
var vec__27000 = p__26999;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27000,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27000,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26993){
var self__ = this;
var G__26993__$1 = this;
return (new cljs.core.RecordIter((0),G__26993__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27003 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27003(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26995,other26996){
var self__ = this;
var this26995__$1 = this;
return (((!((other26996 == null)))) && ((((this26995__$1.constructor === other26996.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.conn,other26996.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.network,other26996.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.ledger_id,other26996.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.block,other26996.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.t,other26996.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.tt_id,other26996.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.stats,other26996.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.spot,other26996.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.psot,other26996.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.post,other26996.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.opst,other26996.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.tspo,other26996.tspo)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.schema,other26996.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.settings,other26996.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.comparators,other26996.comparators)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.schema_cache,other26996.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.novelty,other26996.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.permissions,other26996.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.fork,other26996.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.fork_block,other26996.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.current_db_fn,other26996.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26995__$1.__extmap,other26996.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k26994){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27004 = k26994;
var G__27004__$1 = (((G__27004 instanceof cljs.core.Keyword))?G__27004.fqn:null);
switch (G__27004__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26994);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__26993){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27005 = cljs.core.keyword_identical_QMARK_;
var expr__27006 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27008 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27009 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27008,G__27009) : pred__27005.call(null,G__27008,G__27009));
})())){
return (new fluree.db.graphdb.GraphDb(G__26993,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27010 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27011 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27010,G__27011) : pred__27005.call(null,G__27010,G__27011));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26993,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27012 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27013 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27012,G__27013) : pred__27005.call(null,G__27012,G__27013));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26993,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27014 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27015 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27014,G__27015) : pred__27005.call(null,G__27014,G__27015));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26993,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27016 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27017 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27016,G__27017) : pred__27005.call(null,G__27016,G__27017));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26993,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27018 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27019 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27018,G__27019) : pred__27005.call(null,G__27018,G__27019));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26993,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27020 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27021 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27020,G__27021) : pred__27005.call(null,G__27020,G__27021));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26993,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27022 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27023 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27022,G__27023) : pred__27005.call(null,G__27022,G__27023));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26993,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27024 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27025 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27024,G__27025) : pred__27005.call(null,G__27024,G__27025));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26993,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27026 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27027 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27026,G__27027) : pred__27005.call(null,G__27026,G__27027));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26993,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27028 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27029 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27028,G__27029) : pred__27005.call(null,G__27028,G__27029));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26993,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27030 = new cljs.core.Keyword(null,"tspo","tspo",-440144953);
var G__27031 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27030,G__27031) : pred__27005.call(null,G__27030,G__27031));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26993,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27032 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27033 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27032,G__27033) : pred__27005.call(null,G__27032,G__27033));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26993,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27034 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27035 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27034,G__27035) : pred__27005.call(null,G__27034,G__27035));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26993,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27036 = new cljs.core.Keyword(null,"comparators","comparators",-1325611955);
var G__27037 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27036,G__27037) : pred__27005.call(null,G__27036,G__27037));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26993,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27038 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27039 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27038,G__27039) : pred__27005.call(null,G__27038,G__27039));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26993,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27040 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27041 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27040,G__27041) : pred__27005.call(null,G__27040,G__27041));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26993,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27042 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27043 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27042,G__27043) : pred__27005.call(null,G__27042,G__27043));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26993,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27044 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27045 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27044,G__27045) : pred__27005.call(null,G__27044,G__27045));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26993,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27046 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27047 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27046,G__27047) : pred__27005.call(null,G__27046,G__27047));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26993,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27048 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27049 = expr__27006;
return (pred__27005.cljs$core$IFn$_invoke$arity$2 ? pred__27005.cljs$core$IFn$_invoke$arity$2(G__27048,G__27049) : pred__27005.call(null,G__27048,G__27049));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26993,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__26993),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__26993){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26993,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26997){
var extmap__5385__auto__ = (function (){var G__27050 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26997,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__26997)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27050);
} else {
return G__27050;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26997),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26997),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,clojure.data.avl.sorted_set_by(cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27053 = fluree.db.index.default_comparators;
var map__27053__$1 = cljs.core.__destructure_map(map__27053);
var spot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27053__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27053__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27053__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27053__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27053__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch(network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch(network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch(network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch(network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch(network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
