// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___63532 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63583){
var state_val_63584 = (state_63583[(1)]);
if((state_val_63584 === (7))){
var inst_63578 = (state_63583[(2)]);
var _ = (function (){var statearr_63585 = state_63583;
(statearr_63585[(4)] = cljs.core.rest((state_63583[(4)])));

return statearr_63585;
})();
var state_63583__$1 = state_63583;
var statearr_63586_63613 = state_63583__$1;
(statearr_63586_63613[(2)] = inst_63578);

(statearr_63586_63613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (1))){
var state_63583__$1 = state_63583;
var statearr_63587_63614 = state_63583__$1;
(statearr_63587_63614[(2)] = null);

(statearr_63587_63614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (4))){
var inst_63533 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63588_63615 = state_63583__$1;
(statearr_63588_63615[(2)] = inst_63533);

(statearr_63588_63615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (13))){
var inst_63574 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63589_63616 = state_63583__$1;
(statearr_63589_63616[(2)] = inst_63574);

(statearr_63589_63616[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (6))){
var inst_63558 = (state_63583[(7)]);
var inst_63551 = (state_63583[(8)]);
var inst_63557 = cljs.core.seq(inst_63551);
var inst_63558__$1 = cljs.core.first(inst_63557);
var inst_63559 = cljs.core.next(inst_63557);
var inst_63560 = cljs.core.not(inst_63558__$1);
var state_63583__$1 = (function (){var statearr_63590 = state_63583;
(statearr_63590[(9)] = inst_63559);

(statearr_63590[(7)] = inst_63558__$1);

return statearr_63590;
})();
if(inst_63560){
var statearr_63591_63617 = state_63583__$1;
(statearr_63591_63617[(1)] = (8));

} else {
var statearr_63592_63618 = state_63583__$1;
(statearr_63592_63618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (3))){
var inst_63581 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63583__$1,inst_63581);
} else {
if((state_val_63584 === (12))){
var inst_63559 = (state_63583[(9)]);
var inst_63558 = (state_63583[(7)]);
var inst_63552 = (state_63583[(10)]);
var inst_63571 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_63552,inst_63558);
var inst_63551 = inst_63559;
var inst_63552__$1 = inst_63571;
var state_63583__$1 = (function (){var statearr_63593 = state_63583;
(statearr_63593[(10)] = inst_63552__$1);

(statearr_63593[(8)] = inst_63551);

return statearr_63593;
})();
var statearr_63594_63619 = state_63583__$1;
(statearr_63594_63619[(2)] = null);

(statearr_63594_63619[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (2))){
var _ = (function (){var statearr_63595 = state_63583;
(statearr_63595[(4)] = cljs.core.cons((5),(state_63583[(4)])));

return statearr_63595;
})();
var inst_63546 = args;
var inst_63547 = cljs.core.seq(inst_63546);
var inst_63548 = cljs.core.first(inst_63547);
var inst_63549 = cljs.core.next(inst_63547);
var inst_63550 = cljs.core.PersistentVector.EMPTY;
var inst_63551 = inst_63546;
var inst_63552 = inst_63550;
var state_63583__$1 = (function (){var statearr_63596 = state_63583;
(statearr_63596[(11)] = inst_63549);

(statearr_63596[(12)] = inst_63548);

(statearr_63596[(10)] = inst_63552);

(statearr_63596[(8)] = inst_63551);

return statearr_63596;
})();
var statearr_63597_63620 = state_63583__$1;
(statearr_63597_63620[(2)] = null);

(statearr_63597_63620[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (11))){
var inst_63558 = (state_63583[(7)]);
var state_63583__$1 = state_63583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63583__$1,(14),inst_63558);
} else {
if((state_val_63584 === (9))){
var inst_63558 = (state_63583[(7)]);
var inst_63563 = fluree.db.util.async.channel_QMARK_(inst_63558);
var state_63583__$1 = state_63583;
if(inst_63563){
var statearr_63599_63621 = state_63583__$1;
(statearr_63599_63621[(1)] = (11));

} else {
var statearr_63600_63622 = state_63583__$1;
(statearr_63600_63622[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (5))){
var _ = (function (){var statearr_63601 = state_63583;
(statearr_63601[(4)] = cljs.core.rest((state_63583[(4)])));

return statearr_63601;
})();
var state_63583__$1 = state_63583;
var ex63598 = (state_63583__$1[(2)]);
var statearr_63602_63623 = state_63583__$1;
(statearr_63602_63623[(5)] = ex63598);


if((ex63598 instanceof Error)){
var statearr_63603_63624 = state_63583__$1;
(statearr_63603_63624[(1)] = (4));

(statearr_63603_63624[(5)] = null);

} else {
throw ex63598;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (14))){
var inst_63559 = (state_63583[(9)]);
var inst_63552 = (state_63583[(10)]);
var inst_63566 = (state_63583[(2)]);
var inst_63567 = fluree.db.util.async.throw_err(inst_63566);
var inst_63568 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_63552,inst_63567);
var inst_63551 = inst_63559;
var inst_63552__$1 = inst_63568;
var state_63583__$1 = (function (){var statearr_63604 = state_63583;
(statearr_63604[(10)] = inst_63552__$1);

(statearr_63604[(8)] = inst_63551);

return statearr_63604;
})();
var statearr_63605_63625 = state_63583__$1;
(statearr_63605_63625[(2)] = null);

(statearr_63605_63625[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (10))){
var inst_63576 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63606_63626 = state_63583__$1;
(statearr_63606_63626[(2)] = inst_63576);

(statearr_63606_63626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (8))){
var inst_63552 = (state_63583[(10)]);
var state_63583__$1 = state_63583;
var statearr_63607_63627 = state_63583__$1;
(statearr_63607_63627[(2)] = inst_63552);

(statearr_63607_63627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_63608 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63608[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_63608[(1)] = (1));

return statearr_63608;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_63583){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63583);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63609){var ex__2730__auto__ = e63609;
var statearr_63610_63628 = state_63583;
(statearr_63610_63628[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63583[(4)]))){
var statearr_63611_63629 = state_63583;
(statearr_63611_63629[(1)] = cljs.core.first((state_63583[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63630 = state_63583;
state_63583 = G__63630;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_63583){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_63583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63612 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63612[(6)] = c__2749__auto__);

return statearr_63612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__63632 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63632,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63632,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__63631_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__63631_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63680){
var state_val_63681 = (state_63680[(1)]);
if((state_val_63681 === (7))){
var state_63680__$1 = state_63680;
var statearr_63682_63711 = state_63680__$1;
(statearr_63682_63711[(2)] = coll);

(statearr_63682_63711[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (1))){
var state_63680__$1 = state_63680;
var statearr_63683_63712 = state_63680__$1;
(statearr_63683_63712[(2)] = null);

(statearr_63683_63712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (4))){
var inst_63635 = (state_63680[(2)]);
var state_63680__$1 = state_63680;
var statearr_63684_63713 = state_63680__$1;
(statearr_63684_63713[(2)] = inst_63635);

(statearr_63684_63713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (15))){
var inst_63654 = (state_63680[(7)]);
var inst_63662 = (state_63680[(2)]);
var inst_63663 = fluree.db.dbfunctions.internal.nth(inst_63654,inst_63662);
var inst_63664 = cljs.core.count(inst_63654);
var inst_63665 = ((9) + inst_63664);
var inst_63666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63667 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63669 = [inst_63654,inst_63662];
var inst_63670 = (new cljs.core.PersistentVector(null,2,(5),inst_63668,inst_63669,null));
var inst_63671 = ["nth",inst_63670,inst_63663];
var inst_63672 = cljs.core.PersistentHashMap.fromArrays(inst_63667,inst_63671);
var inst_63673 = [inst_63672,inst_63665];
var inst_63674 = (new cljs.core.PersistentVector(null,2,(5),inst_63666,inst_63673,null));
var inst_63675 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63674);
var _ = (function (){var statearr_63685 = state_63680;
(statearr_63685[(4)] = cljs.core.rest((state_63680[(4)])));

return statearr_63685;
})();
var state_63680__$1 = (function (){var statearr_63686 = state_63680;
(statearr_63686[(8)] = inst_63675);

return statearr_63686;
})();
var statearr_63687_63714 = state_63680__$1;
(statearr_63687_63714[(2)] = inst_63663);

(statearr_63687_63714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (13))){
var state_63680__$1 = state_63680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63680__$1,(16),key);
} else {
if((state_val_63681 === (6))){
var state_63680__$1 = state_63680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63680__$1,(9),coll);
} else {
if((state_val_63681 === (3))){
var inst_63678 = (state_63680[(2)]);
var state_63680__$1 = state_63680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63680__$1,inst_63678);
} else {
if((state_val_63681 === (12))){
var inst_63654 = (state_63680[(2)]);
var inst_63655 = fluree.db.util.async.channel_QMARK_(key);
var state_63680__$1 = (function (){var statearr_63688 = state_63680;
(statearr_63688[(7)] = inst_63654);

return statearr_63688;
})();
if(inst_63655){
var statearr_63689_63715 = state_63680__$1;
(statearr_63689_63715[(1)] = (13));

} else {
var statearr_63690_63716 = state_63680__$1;
(statearr_63690_63716[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (2))){
var _ = (function (){var statearr_63691 = state_63680;
(statearr_63691[(4)] = cljs.core.cons((5),(state_63680[(4)])));

return statearr_63691;
})();
var inst_63641 = fluree.db.util.async.channel_QMARK_(coll);
var state_63680__$1 = state_63680;
if(inst_63641){
var statearr_63692_63717 = state_63680__$1;
(statearr_63692_63717[(1)] = (6));

} else {
var statearr_63693_63718 = state_63680__$1;
(statearr_63693_63718[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (11))){
var inst_63648 = (state_63680[(9)]);
var state_63680__$1 = state_63680;
var statearr_63695_63719 = state_63680__$1;
(statearr_63695_63719[(2)] = inst_63648);

(statearr_63695_63719[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (9))){
var inst_63644 = (state_63680[(2)]);
var inst_63645 = fluree.db.util.async.throw_err(inst_63644);
var state_63680__$1 = state_63680;
var statearr_63696_63720 = state_63680__$1;
(statearr_63696_63720[(2)] = inst_63645);

(statearr_63696_63720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (5))){
var _ = (function (){var statearr_63697 = state_63680;
(statearr_63697[(4)] = cljs.core.rest((state_63680[(4)])));

return statearr_63697;
})();
var state_63680__$1 = state_63680;
var ex63694 = (state_63680__$1[(2)]);
var statearr_63698_63721 = state_63680__$1;
(statearr_63698_63721[(5)] = ex63694);


if((ex63694 instanceof Error)){
var statearr_63699_63722 = state_63680__$1;
(statearr_63699_63722[(1)] = (4));

(statearr_63699_63722[(5)] = null);

} else {
throw ex63694;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (14))){
var state_63680__$1 = state_63680;
var statearr_63700_63723 = state_63680__$1;
(statearr_63700_63723[(2)] = key);

(statearr_63700_63723[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (16))){
var inst_63658 = (state_63680[(2)]);
var inst_63659 = fluree.db.util.async.throw_err(inst_63658);
var state_63680__$1 = state_63680;
var statearr_63701_63724 = state_63680__$1;
(statearr_63701_63724[(2)] = inst_63659);

(statearr_63701_63724[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (10))){
var inst_63648 = (state_63680[(9)]);
var inst_63651 = cljs.core.vec(inst_63648);
var state_63680__$1 = state_63680;
var statearr_63702_63725 = state_63680__$1;
(statearr_63702_63725[(2)] = inst_63651);

(statearr_63702_63725[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63681 === (8))){
var inst_63648 = (state_63680[(9)]);
var inst_63648__$1 = (state_63680[(2)]);
var inst_63649 = cljs.core.set_QMARK_(inst_63648__$1);
var state_63680__$1 = (function (){var statearr_63703 = state_63680;
(statearr_63703[(9)] = inst_63648__$1);

return statearr_63703;
})();
if(inst_63649){
var statearr_63704_63726 = state_63680__$1;
(statearr_63704_63726[(1)] = (10));

} else {
var statearr_63705_63727 = state_63680__$1;
(statearr_63705_63727[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_63706 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63706[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_63706[(1)] = (1));

return statearr_63706;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_63680){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63680);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63707){var ex__2730__auto__ = e63707;
var statearr_63708_63728 = state_63680;
(statearr_63708_63728[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63680[(4)]))){
var statearr_63709_63729 = state_63680;
(statearr_63709_63729[(1)] = cljs.core.first((state_63680[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63730 = state_63680;
state_63680 = G__63730;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_63680){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_63680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63710 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63710[(6)] = c__2749__auto__);

return statearr_63710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63791){
var state_val_63792 = (state_63791[(1)]);
if((state_val_63792 === (7))){
var state_63791__$1 = state_63791;
var statearr_63793_63827 = state_63791__$1;
(statearr_63793_63827[(2)] = test);

(statearr_63793_63827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (20))){
var inst_63765 = (state_63791[(2)]);
var inst_63766 = fluree.db.util.async.throw_err(inst_63765);
var state_63791__$1 = state_63791;
var statearr_63794_63828 = state_63791__$1;
(statearr_63794_63828[(2)] = inst_63766);

(statearr_63794_63828[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (1))){
var state_63791__$1 = state_63791;
var statearr_63795_63829 = state_63791__$1;
(statearr_63795_63829[(2)] = null);

(statearr_63795_63829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (4))){
var inst_63731 = (state_63791[(2)]);
var state_63791__$1 = state_63791;
var statearr_63796_63830 = state_63791__$1;
(statearr_63796_63830[(2)] = inst_63731);

(statearr_63796_63830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (15))){
var inst_63749 = (state_63791[(7)]);
var inst_63757 = (state_63791[(2)]);
var inst_63758 = [inst_63757,f];
var inst_63759 = (new cljs.core.PersistentVector(null,2,(5),inst_63749,inst_63758,null));
var state_63791__$1 = state_63791;
var statearr_63797_63831 = state_63791__$1;
(statearr_63797_63831[(2)] = inst_63759);

(statearr_63797_63831[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (13))){
var state_63791__$1 = state_63791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63791__$1,(16),t);
} else {
if((state_val_63792 === (6))){
var state_63791__$1 = state_63791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63791__$1,(9),test);
} else {
if((state_val_63792 === (17))){
var state_63791__$1 = state_63791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63791__$1,(20),f);
} else {
if((state_val_63792 === (3))){
var inst_63789 = (state_63791[(2)]);
var state_63791__$1 = state_63791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63791__$1,inst_63789);
} else {
if((state_val_63792 === (12))){
var inst_63747 = (state_63791[(8)]);
var inst_63773 = (state_63791[(2)]);
var inst_63774 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63773,(0),null);
var inst_63775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63773,(1),null);
var inst_63776 = fluree.db.dbfunctions.internal.if_else(inst_63747,inst_63774,inst_63775);
var inst_63777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63778 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63780 = [inst_63747,inst_63774,inst_63775];
var inst_63781 = (new cljs.core.PersistentVector(null,3,(5),inst_63779,inst_63780,null));
var inst_63782 = ["if-else",inst_63781,inst_63776];
var inst_63783 = cljs.core.PersistentHashMap.fromArrays(inst_63778,inst_63782);
var inst_63784 = [inst_63783,(10)];
var inst_63785 = (new cljs.core.PersistentVector(null,2,(5),inst_63777,inst_63784,null));
var inst_63786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63785);
var _ = (function (){var statearr_63798 = state_63791;
(statearr_63798[(4)] = cljs.core.rest((state_63791[(4)])));

return statearr_63798;
})();
var state_63791__$1 = (function (){var statearr_63799 = state_63791;
(statearr_63799[(9)] = inst_63786);

return statearr_63799;
})();
var statearr_63800_63832 = state_63791__$1;
(statearr_63800_63832[(2)] = inst_63776);

(statearr_63800_63832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (2))){
var _ = (function (){var statearr_63801 = state_63791;
(statearr_63801[(4)] = cljs.core.cons((5),(state_63791[(4)])));

return statearr_63801;
})();
var inst_63740 = fluree.db.util.async.channel_QMARK_(test);
var state_63791__$1 = state_63791;
if(inst_63740){
var statearr_63802_63833 = state_63791__$1;
(statearr_63802_63833[(1)] = (6));

} else {
var statearr_63803_63834 = state_63791__$1;
(statearr_63803_63834[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (19))){
var inst_63761 = (state_63791[(10)]);
var inst_63769 = (state_63791[(2)]);
var inst_63770 = [f,inst_63769];
var inst_63771 = (new cljs.core.PersistentVector(null,2,(5),inst_63761,inst_63770,null));
var state_63791__$1 = state_63791;
var statearr_63804_63835 = state_63791__$1;
(statearr_63804_63835[(2)] = inst_63771);

(statearr_63804_63835[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (11))){
var inst_63761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63762 = fluree.db.util.async.channel_QMARK_(f);
var state_63791__$1 = (function (){var statearr_63806 = state_63791;
(statearr_63806[(10)] = inst_63761);

return statearr_63806;
})();
if(inst_63762){
var statearr_63807_63836 = state_63791__$1;
(statearr_63807_63836[(1)] = (17));

} else {
var statearr_63808_63837 = state_63791__$1;
(statearr_63808_63837[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (9))){
var inst_63743 = (state_63791[(2)]);
var inst_63744 = fluree.db.util.async.throw_err(inst_63743);
var state_63791__$1 = state_63791;
var statearr_63809_63838 = state_63791__$1;
(statearr_63809_63838[(2)] = inst_63744);

(statearr_63809_63838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (5))){
var _ = (function (){var statearr_63810 = state_63791;
(statearr_63810[(4)] = cljs.core.rest((state_63791[(4)])));

return statearr_63810;
})();
var state_63791__$1 = state_63791;
var ex63805 = (state_63791__$1[(2)]);
var statearr_63811_63839 = state_63791__$1;
(statearr_63811_63839[(5)] = ex63805);


if((ex63805 instanceof Error)){
var statearr_63812_63840 = state_63791__$1;
(statearr_63812_63840[(1)] = (4));

(statearr_63812_63840[(5)] = null);

} else {
throw ex63805;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (14))){
var state_63791__$1 = state_63791;
var statearr_63813_63841 = state_63791__$1;
(statearr_63813_63841[(2)] = t);

(statearr_63813_63841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (16))){
var inst_63753 = (state_63791[(2)]);
var inst_63754 = fluree.db.util.async.throw_err(inst_63753);
var state_63791__$1 = state_63791;
var statearr_63814_63842 = state_63791__$1;
(statearr_63814_63842[(2)] = inst_63754);

(statearr_63814_63842[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (10))){
var inst_63749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63750 = fluree.db.util.async.channel_QMARK_(t);
var state_63791__$1 = (function (){var statearr_63815 = state_63791;
(statearr_63815[(7)] = inst_63749);

return statearr_63815;
})();
if(inst_63750){
var statearr_63816_63843 = state_63791__$1;
(statearr_63816_63843[(1)] = (13));

} else {
var statearr_63817_63844 = state_63791__$1;
(statearr_63817_63844[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (18))){
var state_63791__$1 = state_63791;
var statearr_63818_63845 = state_63791__$1;
(statearr_63818_63845[(2)] = f);

(statearr_63818_63845[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63792 === (8))){
var inst_63747 = (state_63791[(8)]);
var inst_63747__$1 = (state_63791[(2)]);
var state_63791__$1 = (function (){var statearr_63819 = state_63791;
(statearr_63819[(8)] = inst_63747__$1);

return statearr_63819;
})();
if(cljs.core.truth_(inst_63747__$1)){
var statearr_63820_63846 = state_63791__$1;
(statearr_63820_63846[(1)] = (10));

} else {
var statearr_63821_63847 = state_63791__$1;
(statearr_63821_63847[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_63822 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63822[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_63822[(1)] = (1));

return statearr_63822;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_63791){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63791);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63823){var ex__2730__auto__ = e63823;
var statearr_63824_63848 = state_63791;
(statearr_63824_63848[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63791[(4)]))){
var statearr_63825_63849 = state_63791;
(statearr_63825_63849[(1)] = cljs.core.first((state_63791[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63850 = state_63791;
state_63791 = G__63850;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_63791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_63791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63826 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63826[(6)] = c__2749__auto__);

return statearr_63826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63880){
var state_val_63881 = (state_63880[(1)]);
if((state_val_63881 === (7))){
var state_63880__$1 = state_63880;
var statearr_63882_63901 = state_63880__$1;
(statearr_63882_63901[(2)] = arg);

(statearr_63882_63901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63881 === (1))){
var state_63880__$1 = state_63880;
var statearr_63883_63902 = state_63880__$1;
(statearr_63883_63902[(2)] = null);

(statearr_63883_63902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63881 === (4))){
var inst_63851 = (state_63880[(2)]);
var state_63880__$1 = state_63880;
var statearr_63884_63903 = state_63880__$1;
(statearr_63884_63903[(2)] = inst_63851);

(statearr_63884_63903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63881 === (6))){
var state_63880__$1 = state_63880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63880__$1,(9),arg);
} else {
if((state_val_63881 === (3))){
var inst_63878 = (state_63880[(2)]);
var state_63880__$1 = state_63880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63880__$1,inst_63878);
} else {
if((state_val_63881 === (2))){
var _ = (function (){var statearr_63886 = state_63880;
(statearr_63886[(4)] = cljs.core.cons((5),(state_63880[(4)])));

return statearr_63886;
})();
var inst_63857 = fluree.db.util.async.channel_QMARK_(arg);
var state_63880__$1 = state_63880;
if(inst_63857){
var statearr_63887_63904 = state_63880__$1;
(statearr_63887_63904[(1)] = (6));

} else {
var statearr_63888_63905 = state_63880__$1;
(statearr_63888_63905[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63881 === (9))){
var inst_63860 = (state_63880[(2)]);
var inst_63861 = fluree.db.util.async.throw_err(inst_63860);
var state_63880__$1 = state_63880;
var statearr_63889_63906 = state_63880__$1;
(statearr_63889_63906[(2)] = inst_63861);

(statearr_63889_63906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63881 === (5))){
var _ = (function (){var statearr_63890 = state_63880;
(statearr_63890[(4)] = cljs.core.rest((state_63880[(4)])));

return statearr_63890;
})();
var state_63880__$1 = state_63880;
var ex63885 = (state_63880__$1[(2)]);
var statearr_63891_63907 = state_63880__$1;
(statearr_63891_63907[(5)] = ex63885);


if((ex63885 instanceof Error)){
var statearr_63892_63908 = state_63880__$1;
(statearr_63892_63908[(1)] = (4));

(statearr_63892_63908[(5)] = null);

} else {
throw ex63885;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63881 === (8))){
var inst_63864 = (state_63880[(2)]);
var inst_63865 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_63864);
var inst_63866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63867 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63869 = [inst_63864];
var inst_63870 = (new cljs.core.PersistentVector(null,1,(5),inst_63868,inst_63869,null));
var inst_63871 = ["nil?",inst_63870,inst_63865];
var inst_63872 = cljs.core.PersistentHashMap.fromArrays(inst_63867,inst_63871);
var inst_63873 = [inst_63872,(10)];
var inst_63874 = (new cljs.core.PersistentVector(null,2,(5),inst_63866,inst_63873,null));
var inst_63875 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63874);
var _ = (function (){var statearr_63893 = state_63880;
(statearr_63893[(4)] = cljs.core.rest((state_63880[(4)])));

return statearr_63893;
})();
var state_63880__$1 = (function (){var statearr_63894 = state_63880;
(statearr_63894[(7)] = inst_63875);

return statearr_63894;
})();
var statearr_63895_63909 = state_63880__$1;
(statearr_63895_63909[(2)] = inst_63865);

(statearr_63895_63909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_63896 = [null,null,null,null,null,null,null,null];
(statearr_63896[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_63896[(1)] = (1));

return statearr_63896;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_63880){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63880);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63897){var ex__2730__auto__ = e63897;
var statearr_63898_63910 = state_63880;
(statearr_63898_63910[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63880[(4)]))){
var statearr_63899_63911 = state_63880;
(statearr_63899_63911[(1)] = cljs.core.first((state_63880[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63912 = state_63880;
state_63880 = G__63912;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_63880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_63880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63900 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63900[(6)] = c__2749__auto__);

return statearr_63900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63942){
var state_val_63943 = (state_63942[(1)]);
if((state_val_63943 === (7))){
var state_63942__$1 = state_63942;
var statearr_63944_63963 = state_63942__$1;
(statearr_63944_63963[(2)] = arg);

(statearr_63944_63963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63943 === (1))){
var state_63942__$1 = state_63942;
var statearr_63945_63964 = state_63942__$1;
(statearr_63945_63964[(2)] = null);

(statearr_63945_63964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63943 === (4))){
var inst_63913 = (state_63942[(2)]);
var state_63942__$1 = state_63942;
var statearr_63946_63965 = state_63942__$1;
(statearr_63946_63965[(2)] = inst_63913);

(statearr_63946_63965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63943 === (6))){
var state_63942__$1 = state_63942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63942__$1,(9),arg);
} else {
if((state_val_63943 === (3))){
var inst_63940 = (state_63942[(2)]);
var state_63942__$1 = state_63942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63942__$1,inst_63940);
} else {
if((state_val_63943 === (2))){
var _ = (function (){var statearr_63948 = state_63942;
(statearr_63948[(4)] = cljs.core.cons((5),(state_63942[(4)])));

return statearr_63948;
})();
var inst_63919 = fluree.db.util.async.channel_QMARK_(arg);
var state_63942__$1 = state_63942;
if(inst_63919){
var statearr_63949_63966 = state_63942__$1;
(statearr_63949_63966[(1)] = (6));

} else {
var statearr_63950_63967 = state_63942__$1;
(statearr_63950_63967[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63943 === (9))){
var inst_63922 = (state_63942[(2)]);
var inst_63923 = fluree.db.util.async.throw_err(inst_63922);
var state_63942__$1 = state_63942;
var statearr_63951_63968 = state_63942__$1;
(statearr_63951_63968[(2)] = inst_63923);

(statearr_63951_63968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63943 === (5))){
var _ = (function (){var statearr_63952 = state_63942;
(statearr_63952[(4)] = cljs.core.rest((state_63942[(4)])));

return statearr_63952;
})();
var state_63942__$1 = state_63942;
var ex63947 = (state_63942__$1[(2)]);
var statearr_63953_63969 = state_63942__$1;
(statearr_63953_63969[(5)] = ex63947);


if((ex63947 instanceof Error)){
var statearr_63954_63970 = state_63942__$1;
(statearr_63954_63970[(1)] = (4));

(statearr_63954_63970[(5)] = null);

} else {
throw ex63947;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63943 === (8))){
var inst_63926 = (state_63942[(2)]);
var inst_63927 = fluree.db.dbfunctions.internal.not(inst_63926);
var inst_63928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63929 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63931 = [inst_63926];
var inst_63932 = (new cljs.core.PersistentVector(null,1,(5),inst_63930,inst_63931,null));
var inst_63933 = ["not",inst_63932,inst_63927];
var inst_63934 = cljs.core.PersistentHashMap.fromArrays(inst_63929,inst_63933);
var inst_63935 = [inst_63934,(10)];
var inst_63936 = (new cljs.core.PersistentVector(null,2,(5),inst_63928,inst_63935,null));
var inst_63937 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63936);
var _ = (function (){var statearr_63955 = state_63942;
(statearr_63955[(4)] = cljs.core.rest((state_63942[(4)])));

return statearr_63955;
})();
var state_63942__$1 = (function (){var statearr_63956 = state_63942;
(statearr_63956[(7)] = inst_63937);

return statearr_63956;
})();
var statearr_63957_63971 = state_63942__$1;
(statearr_63957_63971[(2)] = inst_63927);

(statearr_63957_63971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_63958 = [null,null,null,null,null,null,null,null];
(statearr_63958[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_63958[(1)] = (1));

return statearr_63958;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_63942){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63942);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63959){var ex__2730__auto__ = e63959;
var statearr_63960_63972 = state_63942;
(statearr_63960_63972[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63942[(4)]))){
var statearr_63961_63973 = state_63942;
(statearr_63961_63973[(1)] = cljs.core.first((state_63942[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63974 = state_63942;
state_63942 = G__63974;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_63942){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_63942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63962 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63962[(6)] = c__2749__auto__);

return statearr_63962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64004){
var state_val_64005 = (state_64004[(1)]);
if((state_val_64005 === (7))){
var state_64004__$1 = state_64004;
var statearr_64006_64025 = state_64004__$1;
(statearr_64006_64025[(2)] = arg);

(statearr_64006_64025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64005 === (1))){
var state_64004__$1 = state_64004;
var statearr_64007_64026 = state_64004__$1;
(statearr_64007_64026[(2)] = null);

(statearr_64007_64026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64005 === (4))){
var inst_63975 = (state_64004[(2)]);
var state_64004__$1 = state_64004;
var statearr_64008_64027 = state_64004__$1;
(statearr_64008_64027[(2)] = inst_63975);

(statearr_64008_64027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64005 === (6))){
var state_64004__$1 = state_64004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64004__$1,(9),arg);
} else {
if((state_val_64005 === (3))){
var inst_64002 = (state_64004[(2)]);
var state_64004__$1 = state_64004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64004__$1,inst_64002);
} else {
if((state_val_64005 === (2))){
var _ = (function (){var statearr_64010 = state_64004;
(statearr_64010[(4)] = cljs.core.cons((5),(state_64004[(4)])));

return statearr_64010;
})();
var inst_63981 = fluree.db.util.async.channel_QMARK_(arg);
var state_64004__$1 = state_64004;
if(inst_63981){
var statearr_64011_64028 = state_64004__$1;
(statearr_64011_64028[(1)] = (6));

} else {
var statearr_64012_64029 = state_64004__$1;
(statearr_64012_64029[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64005 === (9))){
var inst_63984 = (state_64004[(2)]);
var inst_63985 = fluree.db.util.async.throw_err(inst_63984);
var state_64004__$1 = state_64004;
var statearr_64013_64030 = state_64004__$1;
(statearr_64013_64030[(2)] = inst_63985);

(statearr_64013_64030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64005 === (5))){
var _ = (function (){var statearr_64014 = state_64004;
(statearr_64014[(4)] = cljs.core.rest((state_64004[(4)])));

return statearr_64014;
})();
var state_64004__$1 = state_64004;
var ex64009 = (state_64004__$1[(2)]);
var statearr_64015_64031 = state_64004__$1;
(statearr_64015_64031[(5)] = ex64009);


if((ex64009 instanceof Error)){
var statearr_64016_64032 = state_64004__$1;
(statearr_64016_64032[(1)] = (4));

(statearr_64016_64032[(5)] = null);

} else {
throw ex64009;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64005 === (8))){
var inst_63988 = (state_64004[(2)]);
var inst_63989 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_63988);
var inst_63990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63991 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63993 = [inst_63988];
var inst_63994 = (new cljs.core.PersistentVector(null,1,(5),inst_63992,inst_63993,null));
var inst_63995 = ["empty?",inst_63994,inst_63989];
var inst_63996 = cljs.core.PersistentHashMap.fromArrays(inst_63991,inst_63995);
var inst_63997 = [inst_63996,(10)];
var inst_63998 = (new cljs.core.PersistentVector(null,2,(5),inst_63990,inst_63997,null));
var inst_63999 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63998);
var _ = (function (){var statearr_64017 = state_64004;
(statearr_64017[(4)] = cljs.core.rest((state_64004[(4)])));

return statearr_64017;
})();
var state_64004__$1 = (function (){var statearr_64018 = state_64004;
(statearr_64018[(7)] = inst_63999);

return statearr_64018;
})();
var statearr_64019_64033 = state_64004__$1;
(statearr_64019_64033[(2)] = inst_63989);

(statearr_64019_64033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_64020 = [null,null,null,null,null,null,null,null];
(statearr_64020[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_64020[(1)] = (1));

return statearr_64020;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_64004){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64004);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64021){var ex__2730__auto__ = e64021;
var statearr_64022_64034 = state_64004;
(statearr_64022_64034[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64004[(4)]))){
var statearr_64023_64035 = state_64004;
(statearr_64023_64035[(1)] = cljs.core.first((state_64004[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64036 = state_64004;
state_64004 = G__64036;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_64004){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_64004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64024 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64024[(6)] = c__2749__auto__);

return statearr_64024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64081 = arguments.length;
var i__5770__auto___64082 = (0);
while(true){
if((i__5770__auto___64082 < len__5769__auto___64081)){
args__5775__auto__.push((arguments[i__5770__auto___64082]));

var G__64083 = (i__5770__auto___64082 + (1));
i__5770__auto___64082 = G__64083;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64064){
var state_val_64065 = (state_64064[(1)]);
if((state_val_64065 === (1))){
var state_64064__$1 = state_64064;
var statearr_64066_64084 = state_64064__$1;
(statearr_64066_64084[(2)] = null);

(statearr_64066_64084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64065 === (2))){
var _ = (function (){var statearr_64067 = state_64064;
(statearr_64067[(4)] = cljs.core.cons((5),(state_64064[(4)])));

return statearr_64067;
})();
var inst_64045 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64064__$1 = state_64064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64064__$1,(6),inst_64045);
} else {
if((state_val_64065 === (3))){
var inst_64062 = (state_64064[(2)]);
var state_64064__$1 = state_64064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64064__$1,inst_64062);
} else {
if((state_val_64065 === (4))){
var inst_64039 = (state_64064[(2)]);
var state_64064__$1 = state_64064;
var statearr_64069_64085 = state_64064__$1;
(statearr_64069_64085[(2)] = inst_64039);

(statearr_64069_64085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64065 === (5))){
var _ = (function (){var statearr_64070 = state_64064;
(statearr_64070[(4)] = cljs.core.rest((state_64064[(4)])));

return statearr_64070;
})();
var state_64064__$1 = state_64064;
var ex64068 = (state_64064__$1[(2)]);
var statearr_64071_64086 = state_64064__$1;
(statearr_64071_64086[(5)] = ex64068);


if((ex64068 instanceof Error)){
var statearr_64072_64087 = state_64064__$1;
(statearr_64072_64087[(1)] = (4));

(statearr_64072_64087[(5)] = null);

} else {
throw ex64068;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64065 === (6))){
var inst_64047 = (state_64064[(2)]);
var inst_64048 = fluree.db.util.async.throw_err(inst_64047);
var inst_64049 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_64048);
var inst_64050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64051 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64053 = [inst_64048];
var inst_64054 = (new cljs.core.PersistentVector(null,1,(5),inst_64052,inst_64053,null));
var inst_64055 = ["str",inst_64054,inst_64049];
var inst_64056 = cljs.core.PersistentHashMap.fromArrays(inst_64051,inst_64055);
var inst_64057 = [inst_64056,(10)];
var inst_64058 = (new cljs.core.PersistentVector(null,2,(5),inst_64050,inst_64057,null));
var inst_64059 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64058);
var _ = (function (){var statearr_64073 = state_64064;
(statearr_64073[(4)] = cljs.core.rest((state_64064[(4)])));

return statearr_64073;
})();
var state_64064__$1 = (function (){var statearr_64074 = state_64064;
(statearr_64074[(7)] = inst_64059);

return statearr_64074;
})();
var statearr_64075_64088 = state_64064__$1;
(statearr_64075_64088[(2)] = inst_64049);

(statearr_64075_64088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_64076 = [null,null,null,null,null,null,null,null];
(statearr_64076[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_64076[(1)] = (1));

return statearr_64076;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_64064){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64064);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64077){var ex__2730__auto__ = e64077;
var statearr_64078_64089 = state_64064;
(statearr_64078_64089[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64064[(4)]))){
var statearr_64079_64090 = state_64064;
(statearr_64079_64090[(1)] = cljs.core.first((state_64064[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64091 = state_64064;
state_64064 = G__64091;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_64064){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_64064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64080 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64080[(6)] = c__2749__auto__);

return statearr_64080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq64037){
var G__64038 = cljs.core.first(seq64037);
var seq64037__$1 = cljs.core.next(seq64037);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64038,seq64037__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64117){
var state_val_64118 = (state_64117[(1)]);
if((state_val_64118 === (1))){
var state_64117__$1 = state_64117;
var statearr_64119_64134 = state_64117__$1;
(statearr_64119_64134[(2)] = null);

(statearr_64119_64134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64118 === (2))){
var _ = (function (){var statearr_64120 = state_64117;
(statearr_64120[(4)] = cljs.core.cons((5),(state_64117[(4)])));

return statearr_64120;
})();
var inst_64098 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64117__$1 = state_64117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64117__$1,(6),inst_64098);
} else {
if((state_val_64118 === (3))){
var inst_64115 = (state_64117[(2)]);
var state_64117__$1 = state_64117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64117__$1,inst_64115);
} else {
if((state_val_64118 === (4))){
var inst_64092 = (state_64117[(2)]);
var state_64117__$1 = state_64117;
var statearr_64122_64135 = state_64117__$1;
(statearr_64122_64135[(2)] = inst_64092);

(statearr_64122_64135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64118 === (5))){
var _ = (function (){var statearr_64123 = state_64117;
(statearr_64123[(4)] = cljs.core.rest((state_64117[(4)])));

return statearr_64123;
})();
var state_64117__$1 = state_64117;
var ex64121 = (state_64117__$1[(2)]);
var statearr_64124_64136 = state_64117__$1;
(statearr_64124_64136[(5)] = ex64121);


if((ex64121 instanceof Error)){
var statearr_64125_64137 = state_64117__$1;
(statearr_64125_64137[(1)] = (4));

(statearr_64125_64137[(5)] = null);

} else {
throw ex64121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64118 === (6))){
var inst_64100 = (state_64117[(2)]);
var inst_64101 = fluree.db.util.async.throw_err(inst_64100);
var inst_64102 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_64101);
var inst_64103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64104 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64106 = [inst_64101];
var inst_64107 = (new cljs.core.PersistentVector(null,1,(5),inst_64105,inst_64106,null));
var inst_64108 = ["subs",inst_64107,inst_64102];
var inst_64109 = cljs.core.PersistentHashMap.fromArrays(inst_64104,inst_64108);
var inst_64110 = [inst_64109,(30)];
var inst_64111 = (new cljs.core.PersistentVector(null,2,(5),inst_64103,inst_64110,null));
var inst_64112 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64111);
var _ = (function (){var statearr_64126 = state_64117;
(statearr_64126[(4)] = cljs.core.rest((state_64117[(4)])));

return statearr_64126;
})();
var state_64117__$1 = (function (){var statearr_64127 = state_64117;
(statearr_64127[(7)] = inst_64112);

return statearr_64127;
})();
var statearr_64128_64138 = state_64117__$1;
(statearr_64128_64138[(2)] = inst_64102);

(statearr_64128_64138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_64129 = [null,null,null,null,null,null,null,null];
(statearr_64129[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_64129[(1)] = (1));

return statearr_64129;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_64117){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64117);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64130){var ex__2730__auto__ = e64130;
var statearr_64131_64139 = state_64117;
(statearr_64131_64139[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64117[(4)]))){
var statearr_64132_64140 = state_64117;
(statearr_64132_64140[(1)] = cljs.core.first((state_64117[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64141 = state_64117;
state_64117 = G__64141;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_64117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_64117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64133 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64133[(6)] = c__2749__auto__);

return statearr_64133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64171){
var state_val_64172 = (state_64171[(1)]);
if((state_val_64172 === (7))){
var state_64171__$1 = state_64171;
var statearr_64173_64192 = state_64171__$1;
(statearr_64173_64192[(2)] = str);

(statearr_64173_64192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64172 === (1))){
var state_64171__$1 = state_64171;
var statearr_64174_64193 = state_64171__$1;
(statearr_64174_64193[(2)] = null);

(statearr_64174_64193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64172 === (4))){
var inst_64142 = (state_64171[(2)]);
var state_64171__$1 = state_64171;
var statearr_64175_64194 = state_64171__$1;
(statearr_64175_64194[(2)] = inst_64142);

(statearr_64175_64194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64172 === (6))){
var state_64171__$1 = state_64171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64171__$1,(9),str);
} else {
if((state_val_64172 === (3))){
var inst_64169 = (state_64171[(2)]);
var state_64171__$1 = state_64171;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64171__$1,inst_64169);
} else {
if((state_val_64172 === (2))){
var _ = (function (){var statearr_64177 = state_64171;
(statearr_64177[(4)] = cljs.core.cons((5),(state_64171[(4)])));

return statearr_64177;
})();
var inst_64148 = fluree.db.util.async.channel_QMARK_(str);
var state_64171__$1 = state_64171;
if(inst_64148){
var statearr_64178_64195 = state_64171__$1;
(statearr_64178_64195[(1)] = (6));

} else {
var statearr_64179_64196 = state_64171__$1;
(statearr_64179_64196[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64172 === (9))){
var inst_64151 = (state_64171[(2)]);
var inst_64152 = fluree.db.util.async.throw_err(inst_64151);
var state_64171__$1 = state_64171;
var statearr_64180_64197 = state_64171__$1;
(statearr_64180_64197[(2)] = inst_64152);

(statearr_64180_64197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64172 === (5))){
var _ = (function (){var statearr_64181 = state_64171;
(statearr_64181[(4)] = cljs.core.rest((state_64171[(4)])));

return statearr_64181;
})();
var state_64171__$1 = state_64171;
var ex64176 = (state_64171__$1[(2)]);
var statearr_64182_64198 = state_64171__$1;
(statearr_64182_64198[(5)] = ex64176);


if((ex64176 instanceof Error)){
var statearr_64183_64199 = state_64171__$1;
(statearr_64183_64199[(1)] = (4));

(statearr_64183_64199[(5)] = null);

} else {
throw ex64176;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64172 === (8))){
var inst_64155 = (state_64171[(2)]);
var inst_64156 = fluree.db.dbfunctions.internal.lower_case(inst_64155);
var inst_64157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64158 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64160 = [inst_64155];
var inst_64161 = (new cljs.core.PersistentVector(null,1,(5),inst_64159,inst_64160,null));
var inst_64162 = ["lower-case",inst_64161,inst_64156];
var inst_64163 = cljs.core.PersistentHashMap.fromArrays(inst_64158,inst_64162);
var inst_64164 = [inst_64163,(10)];
var inst_64165 = (new cljs.core.PersistentVector(null,2,(5),inst_64157,inst_64164,null));
var inst_64166 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64165);
var _ = (function (){var statearr_64184 = state_64171;
(statearr_64184[(4)] = cljs.core.rest((state_64171[(4)])));

return statearr_64184;
})();
var state_64171__$1 = (function (){var statearr_64185 = state_64171;
(statearr_64185[(7)] = inst_64166);

return statearr_64185;
})();
var statearr_64186_64200 = state_64171__$1;
(statearr_64186_64200[(2)] = inst_64156);

(statearr_64186_64200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_64187 = [null,null,null,null,null,null,null,null];
(statearr_64187[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_64187[(1)] = (1));

return statearr_64187;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_64171){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64171);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64188){var ex__2730__auto__ = e64188;
var statearr_64189_64201 = state_64171;
(statearr_64189_64201[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64171[(4)]))){
var statearr_64190_64202 = state_64171;
(statearr_64190_64202[(1)] = cljs.core.first((state_64171[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64203 = state_64171;
state_64171 = G__64203;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_64171){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_64171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64191 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64191[(6)] = c__2749__auto__);

return statearr_64191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64233){
var state_val_64234 = (state_64233[(1)]);
if((state_val_64234 === (7))){
var state_64233__$1 = state_64233;
var statearr_64235_64254 = state_64233__$1;
(statearr_64235_64254[(2)] = str);

(statearr_64235_64254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64234 === (1))){
var state_64233__$1 = state_64233;
var statearr_64236_64255 = state_64233__$1;
(statearr_64236_64255[(2)] = null);

(statearr_64236_64255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64234 === (4))){
var inst_64204 = (state_64233[(2)]);
var state_64233__$1 = state_64233;
var statearr_64237_64256 = state_64233__$1;
(statearr_64237_64256[(2)] = inst_64204);

(statearr_64237_64256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64234 === (6))){
var state_64233__$1 = state_64233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64233__$1,(9),str);
} else {
if((state_val_64234 === (3))){
var inst_64231 = (state_64233[(2)]);
var state_64233__$1 = state_64233;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64233__$1,inst_64231);
} else {
if((state_val_64234 === (2))){
var _ = (function (){var statearr_64239 = state_64233;
(statearr_64239[(4)] = cljs.core.cons((5),(state_64233[(4)])));

return statearr_64239;
})();
var inst_64210 = fluree.db.util.async.channel_QMARK_(str);
var state_64233__$1 = state_64233;
if(inst_64210){
var statearr_64240_64257 = state_64233__$1;
(statearr_64240_64257[(1)] = (6));

} else {
var statearr_64241_64258 = state_64233__$1;
(statearr_64241_64258[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64234 === (9))){
var inst_64213 = (state_64233[(2)]);
var inst_64214 = fluree.db.util.async.throw_err(inst_64213);
var state_64233__$1 = state_64233;
var statearr_64242_64259 = state_64233__$1;
(statearr_64242_64259[(2)] = inst_64214);

(statearr_64242_64259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64234 === (5))){
var _ = (function (){var statearr_64243 = state_64233;
(statearr_64243[(4)] = cljs.core.rest((state_64233[(4)])));

return statearr_64243;
})();
var state_64233__$1 = state_64233;
var ex64238 = (state_64233__$1[(2)]);
var statearr_64244_64260 = state_64233__$1;
(statearr_64244_64260[(5)] = ex64238);


if((ex64238 instanceof Error)){
var statearr_64245_64261 = state_64233__$1;
(statearr_64245_64261[(1)] = (4));

(statearr_64245_64261[(5)] = null);

} else {
throw ex64238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64234 === (8))){
var inst_64217 = (state_64233[(2)]);
var inst_64218 = fluree.db.dbfunctions.internal.upper_case(inst_64217);
var inst_64219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64220 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64222 = [inst_64217];
var inst_64223 = (new cljs.core.PersistentVector(null,1,(5),inst_64221,inst_64222,null));
var inst_64224 = ["upper-case",inst_64223,inst_64218];
var inst_64225 = cljs.core.PersistentHashMap.fromArrays(inst_64220,inst_64224);
var inst_64226 = [inst_64225,(10)];
var inst_64227 = (new cljs.core.PersistentVector(null,2,(5),inst_64219,inst_64226,null));
var inst_64228 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64227);
var _ = (function (){var statearr_64246 = state_64233;
(statearr_64246[(4)] = cljs.core.rest((state_64233[(4)])));

return statearr_64246;
})();
var state_64233__$1 = (function (){var statearr_64247 = state_64233;
(statearr_64247[(7)] = inst_64228);

return statearr_64247;
})();
var statearr_64248_64262 = state_64233__$1;
(statearr_64248_64262[(2)] = inst_64218);

(statearr_64248_64262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_64249 = [null,null,null,null,null,null,null,null];
(statearr_64249[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_64249[(1)] = (1));

return statearr_64249;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_64233){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64233);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64250){var ex__2730__auto__ = e64250;
var statearr_64251_64263 = state_64233;
(statearr_64251_64263[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64233[(4)]))){
var statearr_64252_64264 = state_64233;
(statearr_64252_64264[(1)] = cljs.core.first((state_64233[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64265 = state_64233;
state_64233 = G__64265;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_64233){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_64233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64253 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64253[(6)] = c__2749__auto__);

return statearr_64253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__64267 = arguments.length;
switch (G__64267) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64295){
var state_val_64296 = (state_64295[(1)]);
if((state_val_64296 === (1))){
var state_64295__$1 = state_64295;
var statearr_64297_64313 = state_64295__$1;
(statearr_64297_64313[(2)] = null);

(statearr_64297_64313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64296 === (2))){
var _ = (function (){var statearr_64298 = state_64295;
(statearr_64298[(4)] = cljs.core.cons((5),(state_64295[(4)])));

return statearr_64298;
})();
var inst_64277 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_64295__$1 = state_64295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64295__$1,(6),inst_64277);
} else {
if((state_val_64296 === (3))){
var inst_64293 = (state_64295[(2)]);
var state_64295__$1 = state_64295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64295__$1,inst_64293);
} else {
if((state_val_64296 === (4))){
var inst_64268 = (state_64295[(2)]);
var state_64295__$1 = state_64295;
var statearr_64300_64314 = state_64295__$1;
(statearr_64300_64314[(2)] = inst_64268);

(statearr_64300_64314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64296 === (5))){
var _ = (function (){var statearr_64301 = state_64295;
(statearr_64301[(4)] = cljs.core.rest((state_64295[(4)])));

return statearr_64301;
})();
var state_64295__$1 = state_64295;
var ex64299 = (state_64295__$1[(2)]);
var statearr_64302_64315 = state_64295__$1;
(statearr_64302_64315[(5)] = ex64299);


if((ex64299 instanceof Error)){
var statearr_64303_64316 = state_64295__$1;
(statearr_64303_64316[(1)] = (4));

(statearr_64303_64316[(5)] = null);

} else {
throw ex64299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64296 === (6))){
var inst_64279 = (state_64295[(2)]);
var inst_64280 = fluree.db.util.async.throw_err(inst_64279);
var inst_64281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64280,(0),null);
var inst_64282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64280,(1),null);
var inst_64283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64284 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64285 = ["?s","?ctx",inst_64281];
var inst_64286 = cljs.core.PersistentHashMap.fromArrays(inst_64284,inst_64285);
var inst_64287 = ((10) + inst_64282);
var inst_64288 = [inst_64286,inst_64287];
var inst_64289 = (new cljs.core.PersistentVector(null,2,(5),inst_64283,inst_64288,null));
var inst_64290 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64289);
var _ = (function (){var statearr_64304 = state_64295;
(statearr_64304[(4)] = cljs.core.rest((state_64295[(4)])));

return statearr_64304;
})();
var state_64295__$1 = (function (){var statearr_64305 = state_64295;
(statearr_64305[(7)] = inst_64290);

return statearr_64305;
})();
var statearr_64306_64317 = state_64295__$1;
(statearr_64306_64317[(2)] = inst_64281);

(statearr_64306_64317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_64307 = [null,null,null,null,null,null,null,null];
(statearr_64307[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_64307[(1)] = (1));

return statearr_64307;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_64295){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64295);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64308){var ex__2730__auto__ = e64308;
var statearr_64309_64318 = state_64295;
(statearr_64309_64318[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64295[(4)]))){
var statearr_64310_64319 = state_64295;
(statearr_64310_64319[(1)] = cljs.core.first((state_64295[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64320 = state_64295;
state_64295 = G__64320;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_64295){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_64295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64311 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64311[(6)] = c__2749__auto__);

return statearr_64311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__64322 = arguments.length;
switch (G__64322) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64360){
var state_val_64361 = (state_64360[(1)]);
if((state_val_64361 === (7))){
var inst_64353 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_64360__$1 = state_64360;
var statearr_64362_64382 = state_64360__$1;
(statearr_64362_64382[(2)] = inst_64353);

(statearr_64362_64382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64361 === (1))){
var state_64360__$1 = state_64360;
var statearr_64363_64383 = state_64360__$1;
(statearr_64363_64383[(2)] = null);

(statearr_64363_64383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64361 === (4))){
var inst_64323 = (state_64360[(2)]);
var state_64360__$1 = state_64360;
var statearr_64364_64384 = state_64360__$1;
(statearr_64364_64384[(2)] = inst_64323);

(statearr_64364_64384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64361 === (6))){
var inst_64334 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_64360__$1 = state_64360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64360__$1,(10),inst_64334);
} else {
if((state_val_64361 === (3))){
var inst_64358 = (state_64360[(2)]);
var state_64360__$1 = state_64360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64360__$1,inst_64358);
} else {
if((state_val_64361 === (2))){
var _ = (function (){var statearr_64366 = state_64360;
(statearr_64366[(4)] = cljs.core.cons((5),(state_64360[(4)])));

return statearr_64366;
})();
var inst_64329 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64360__$1 = state_64360;
if(cljs.core.truth_(inst_64329)){
var statearr_64367_64385 = state_64360__$1;
(statearr_64367_64385[(1)] = (6));

} else {
var statearr_64368_64386 = state_64360__$1;
(statearr_64368_64386[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64361 === (9))){
var inst_64340 = (state_64360[(2)]);
var inst_64341 = fluree.db.util.async.throw_err(inst_64340);
var inst_64342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64341,(0),null);
var inst_64343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64341,(1),null);
var inst_64344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64345 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64346 = ["?p","?ctx",inst_64342];
var inst_64347 = cljs.core.PersistentHashMap.fromArrays(inst_64345,inst_64346);
var inst_64348 = ((10) + inst_64343);
var inst_64349 = [inst_64347,inst_64348];
var inst_64350 = (new cljs.core.PersistentVector(null,2,(5),inst_64344,inst_64349,null));
var inst_64351 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64350);
var state_64360__$1 = (function (){var statearr_64369 = state_64360;
(statearr_64369[(7)] = inst_64351);

return statearr_64369;
})();
var statearr_64370_64387 = state_64360__$1;
(statearr_64370_64387[(2)] = inst_64342);

(statearr_64370_64387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64361 === (5))){
var _ = (function (){var statearr_64371 = state_64360;
(statearr_64371[(4)] = cljs.core.rest((state_64360[(4)])));

return statearr_64371;
})();
var state_64360__$1 = state_64360;
var ex64365 = (state_64360__$1[(2)]);
var statearr_64372_64388 = state_64360__$1;
(statearr_64372_64388[(5)] = ex64365);


if((ex64365 instanceof Error)){
var statearr_64373_64389 = state_64360__$1;
(statearr_64373_64389[(1)] = (4));

(statearr_64373_64389[(5)] = null);

} else {
throw ex64365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64361 === (10))){
var inst_64336 = (state_64360[(2)]);
var inst_64337 = fluree.db.util.async.throw_err(inst_64336);
var inst_64338 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_64337);
var state_64360__$1 = state_64360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64360__$1,(9),inst_64338);
} else {
if((state_val_64361 === (8))){
var inst_64355 = (state_64360[(2)]);
var _ = (function (){var statearr_64374 = state_64360;
(statearr_64374[(4)] = cljs.core.rest((state_64360[(4)])));

return statearr_64374;
})();
var state_64360__$1 = state_64360;
var statearr_64375_64390 = state_64360__$1;
(statearr_64375_64390[(2)] = inst_64355);

(statearr_64375_64390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_64376 = [null,null,null,null,null,null,null,null];
(statearr_64376[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_64376[(1)] = (1));

return statearr_64376;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_64360){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64360);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64377){var ex__2730__auto__ = e64377;
var statearr_64378_64391 = state_64360;
(statearr_64378_64391[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64360[(4)]))){
var statearr_64379_64392 = state_64360;
(statearr_64379_64392[(1)] = cljs.core.first((state_64360[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64393 = state_64360;
state_64360 = G__64393;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_64360){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_64360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64380 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64380[(6)] = c__2749__auto__);

return statearr_64380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64442 = arguments.length;
var i__5770__auto___64443 = (0);
while(true){
if((i__5770__auto___64443 < len__5769__auto___64442)){
args__5775__auto__.push((arguments[i__5770__auto___64443]));

var G__64444 = (i__5770__auto___64443 + (1));
i__5770__auto___64443 = G__64444;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64425){
var state_val_64426 = (state_64425[(1)]);
if((state_val_64426 === (1))){
var state_64425__$1 = state_64425;
var statearr_64427_64445 = state_64425__$1;
(statearr_64427_64445[(2)] = null);

(statearr_64427_64445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64426 === (2))){
var _ = (function (){var statearr_64428 = state_64425;
(statearr_64428[(4)] = cljs.core.cons((5),(state_64425[(4)])));

return statearr_64428;
})();
var inst_64402 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64425__$1 = state_64425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64425__$1,(6),inst_64402);
} else {
if((state_val_64426 === (3))){
var inst_64423 = (state_64425[(2)]);
var state_64425__$1 = state_64425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64425__$1,inst_64423);
} else {
if((state_val_64426 === (4))){
var inst_64396 = (state_64425[(2)]);
var state_64425__$1 = state_64425;
var statearr_64430_64446 = state_64425__$1;
(statearr_64430_64446[(2)] = inst_64396);

(statearr_64430_64446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64426 === (5))){
var _ = (function (){var statearr_64431 = state_64425;
(statearr_64431[(4)] = cljs.core.rest((state_64425[(4)])));

return statearr_64431;
})();
var state_64425__$1 = state_64425;
var ex64429 = (state_64425__$1[(2)]);
var statearr_64432_64447 = state_64425__$1;
(statearr_64432_64447[(5)] = ex64429);


if((ex64429 instanceof Error)){
var statearr_64433_64448 = state_64425__$1;
(statearr_64433_64448[(1)] = (4));

(statearr_64433_64448[(5)] = null);

} else {
throw ex64429;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64426 === (6))){
var inst_64404 = (state_64425[(2)]);
var inst_64405 = fluree.db.util.async.throw_err(inst_64404);
var inst_64406 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_64405);
var inst_64407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64408 = [inst_64405];
var inst_64409 = (new cljs.core.PersistentVector(null,1,(5),inst_64407,inst_64408,null));
var inst_64410 = cljs.core.count(inst_64409);
var inst_64411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64412 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64414 = [inst_64405];
var inst_64415 = (new cljs.core.PersistentVector(null,1,(5),inst_64413,inst_64414,null));
var inst_64416 = ["and",inst_64415,inst_64406];
var inst_64417 = cljs.core.PersistentHashMap.fromArrays(inst_64412,inst_64416);
var inst_64418 = [inst_64417,inst_64410];
var inst_64419 = (new cljs.core.PersistentVector(null,2,(5),inst_64411,inst_64418,null));
var inst_64420 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64419);
var _ = (function (){var statearr_64434 = state_64425;
(statearr_64434[(4)] = cljs.core.rest((state_64425[(4)])));

return statearr_64434;
})();
var state_64425__$1 = (function (){var statearr_64435 = state_64425;
(statearr_64435[(7)] = inst_64420);

return statearr_64435;
})();
var statearr_64436_64449 = state_64425__$1;
(statearr_64436_64449[(2)] = inst_64406);

(statearr_64436_64449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_64437 = [null,null,null,null,null,null,null,null];
(statearr_64437[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_64437[(1)] = (1));

return statearr_64437;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_64425){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64425);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64438){var ex__2730__auto__ = e64438;
var statearr_64439_64450 = state_64425;
(statearr_64439_64450[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64425[(4)]))){
var statearr_64440_64451 = state_64425;
(statearr_64440_64451[(1)] = cljs.core.first((state_64425[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64452 = state_64425;
state_64425 = G__64452;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_64425){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_64425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64441 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64441[(6)] = c__2749__auto__);

return statearr_64441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq64394){
var G__64395 = cljs.core.first(seq64394);
var seq64394__$1 = cljs.core.next(seq64394);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64395,seq64394__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64501 = arguments.length;
var i__5770__auto___64502 = (0);
while(true){
if((i__5770__auto___64502 < len__5769__auto___64501)){
args__5775__auto__.push((arguments[i__5770__auto___64502]));

var G__64503 = (i__5770__auto___64502 + (1));
i__5770__auto___64502 = G__64503;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64484){
var state_val_64485 = (state_64484[(1)]);
if((state_val_64485 === (1))){
var state_64484__$1 = state_64484;
var statearr_64486_64504 = state_64484__$1;
(statearr_64486_64504[(2)] = null);

(statearr_64486_64504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (2))){
var _ = (function (){var statearr_64487 = state_64484;
(statearr_64487[(4)] = cljs.core.cons((5),(state_64484[(4)])));

return statearr_64487;
})();
var inst_64461 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64484__$1 = state_64484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64484__$1,(6),inst_64461);
} else {
if((state_val_64485 === (3))){
var inst_64482 = (state_64484[(2)]);
var state_64484__$1 = state_64484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64484__$1,inst_64482);
} else {
if((state_val_64485 === (4))){
var inst_64455 = (state_64484[(2)]);
var state_64484__$1 = state_64484;
var statearr_64489_64505 = state_64484__$1;
(statearr_64489_64505[(2)] = inst_64455);

(statearr_64489_64505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (5))){
var _ = (function (){var statearr_64490 = state_64484;
(statearr_64490[(4)] = cljs.core.rest((state_64484[(4)])));

return statearr_64490;
})();
var state_64484__$1 = state_64484;
var ex64488 = (state_64484__$1[(2)]);
var statearr_64491_64506 = state_64484__$1;
(statearr_64491_64506[(5)] = ex64488);


if((ex64488 instanceof Error)){
var statearr_64492_64507 = state_64484__$1;
(statearr_64492_64507[(1)] = (4));

(statearr_64492_64507[(5)] = null);

} else {
throw ex64488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (6))){
var inst_64463 = (state_64484[(2)]);
var inst_64464 = fluree.db.util.async.throw_err(inst_64463);
var inst_64465 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_64464);
var inst_64466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64467 = [inst_64464];
var inst_64468 = (new cljs.core.PersistentVector(null,1,(5),inst_64466,inst_64467,null));
var inst_64469 = cljs.core.count(inst_64468);
var inst_64470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64473 = [inst_64464];
var inst_64474 = (new cljs.core.PersistentVector(null,1,(5),inst_64472,inst_64473,null));
var inst_64475 = ["or",inst_64474,inst_64465];
var inst_64476 = cljs.core.PersistentHashMap.fromArrays(inst_64471,inst_64475);
var inst_64477 = [inst_64476,inst_64469];
var inst_64478 = (new cljs.core.PersistentVector(null,2,(5),inst_64470,inst_64477,null));
var inst_64479 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64478);
var _ = (function (){var statearr_64493 = state_64484;
(statearr_64493[(4)] = cljs.core.rest((state_64484[(4)])));

return statearr_64493;
})();
var state_64484__$1 = (function (){var statearr_64494 = state_64484;
(statearr_64494[(7)] = inst_64479);

return statearr_64494;
})();
var statearr_64495_64508 = state_64484__$1;
(statearr_64495_64508[(2)] = inst_64465);

(statearr_64495_64508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_64496 = [null,null,null,null,null,null,null,null];
(statearr_64496[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_64496[(1)] = (1));

return statearr_64496;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_64484){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64484);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64497){var ex__2730__auto__ = e64497;
var statearr_64498_64509 = state_64484;
(statearr_64498_64509[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64484[(4)]))){
var statearr_64499_64510 = state_64484;
(statearr_64499_64510[(1)] = cljs.core.first((state_64484[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64511 = state_64484;
state_64484 = G__64511;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_64484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_64484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64500 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64500[(6)] = c__2749__auto__);

return statearr_64500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq64453){
var G__64454 = cljs.core.first(seq64453);
var seq64453__$1 = cljs.core.next(seq64453);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64454,seq64453__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64549){
var state_val_64550 = (state_64549[(1)]);
if((state_val_64550 === (7))){
var inst_64525 = fluree.db.util.async.channel_QMARK_(coll);
var state_64549__$1 = state_64549;
if(inst_64525){
var statearr_64551_64574 = state_64549__$1;
(statearr_64551_64574[(1)] = (10));

} else {
var statearr_64552_64575 = state_64549__$1;
(statearr_64552_64575[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (1))){
var state_64549__$1 = state_64549;
var statearr_64553_64576 = state_64549__$1;
(statearr_64553_64576[(2)] = null);

(statearr_64553_64576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (4))){
var inst_64512 = (state_64549[(2)]);
var state_64549__$1 = state_64549;
var statearr_64554_64577 = state_64549__$1;
(statearr_64554_64577[(2)] = inst_64512);

(statearr_64554_64577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (13))){
var inst_64528 = (state_64549[(2)]);
var inst_64529 = fluree.db.util.async.throw_err(inst_64528);
var state_64549__$1 = state_64549;
var statearr_64555_64578 = state_64549__$1;
(statearr_64555_64578[(2)] = inst_64529);

(statearr_64555_64578[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (6))){
var inst_64520 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_64549__$1 = state_64549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64549__$1,(9),inst_64520);
} else {
if((state_val_64550 === (3))){
var inst_64547 = (state_64549[(2)]);
var state_64549__$1 = state_64549;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64549__$1,inst_64547);
} else {
if((state_val_64550 === (12))){
var inst_64532 = (state_64549[(2)]);
var state_64549__$1 = state_64549;
var statearr_64556_64579 = state_64549__$1;
(statearr_64556_64579[(2)] = inst_64532);

(statearr_64556_64579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (2))){
var _ = (function (){var statearr_64557 = state_64549;
(statearr_64557[(4)] = cljs.core.cons((5),(state_64549[(4)])));

return statearr_64557;
})();
var inst_64518 = cljs.core.vector_QMARK_(coll);
var state_64549__$1 = state_64549;
if(inst_64518){
var statearr_64558_64580 = state_64549__$1;
(statearr_64558_64580[(1)] = (6));

} else {
var statearr_64559_64581 = state_64549__$1;
(statearr_64559_64581[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (11))){
var state_64549__$1 = state_64549;
var statearr_64561_64582 = state_64549__$1;
(statearr_64561_64582[(2)] = coll);

(statearr_64561_64582[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (9))){
var inst_64522 = (state_64549[(2)]);
var inst_64523 = fluree.db.util.async.throw_err(inst_64522);
var state_64549__$1 = state_64549;
var statearr_64562_64583 = state_64549__$1;
(statearr_64562_64583[(2)] = inst_64523);

(statearr_64562_64583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (5))){
var _ = (function (){var statearr_64563 = state_64549;
(statearr_64563[(4)] = cljs.core.rest((state_64549[(4)])));

return statearr_64563;
})();
var state_64549__$1 = state_64549;
var ex64560 = (state_64549__$1[(2)]);
var statearr_64564_64584 = state_64549__$1;
(statearr_64564_64584[(5)] = ex64560);


if((ex64560 instanceof Error)){
var statearr_64565_64585 = state_64549__$1;
(statearr_64565_64585[(1)] = (4));

(statearr_64565_64585[(5)] = null);

} else {
throw ex64560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64550 === (10))){
var state_64549__$1 = state_64549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64549__$1,(13),coll);
} else {
if((state_val_64550 === (8))){
var inst_64534 = (state_64549[(2)]);
var inst_64535 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_64534);
var inst_64536 = cljs.core.count(inst_64535);
var inst_64537 = ((9) + inst_64536);
var inst_64538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64539 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64540 = ["count",inst_64534,inst_64536];
var inst_64541 = cljs.core.PersistentHashMap.fromArrays(inst_64539,inst_64540);
var inst_64542 = [inst_64541,inst_64537];
var inst_64543 = (new cljs.core.PersistentVector(null,2,(5),inst_64538,inst_64542,null));
var inst_64544 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64543);
var _ = (function (){var statearr_64566 = state_64549;
(statearr_64566[(4)] = cljs.core.rest((state_64549[(4)])));

return statearr_64566;
})();
var state_64549__$1 = (function (){var statearr_64567 = state_64549;
(statearr_64567[(7)] = inst_64544);

return statearr_64567;
})();
var statearr_64568_64586 = state_64549__$1;
(statearr_64568_64586[(2)] = inst_64536);

(statearr_64568_64586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_64569 = [null,null,null,null,null,null,null,null];
(statearr_64569[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_64569[(1)] = (1));

return statearr_64569;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_64549){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64549);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64570){var ex__2730__auto__ = e64570;
var statearr_64571_64587 = state_64549;
(statearr_64571_64587[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64549[(4)]))){
var statearr_64572_64588 = state_64549;
(statearr_64572_64588[(1)] = cljs.core.first((state_64549[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64589 = state_64549;
state_64549 = G__64589;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_64549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_64549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64573 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64573[(6)] = c__2749__auto__);

return statearr_64573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__64590,subject,pred){
var map__64591 = p__64590;
var map__64591__$1 = cljs.core.__destructure_map(map__64591);
var _QMARK_ctx = map__64591__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64591__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64591__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64682){
var state_val_64683 = (state_64682[(1)]);
if((state_val_64683 === (7))){
var state_64682__$1 = state_64682;
var statearr_64684_64740 = state_64682__$1;
(statearr_64684_64740[(2)] = subject);

(statearr_64684_64740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (20))){
var state_64682__$1 = state_64682;
var statearr_64685_64741 = state_64682__$1;
(statearr_64685_64741[(2)] = cache);

(statearr_64685_64741[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (27))){
var inst_64613 = (state_64682[(7)]);
var inst_64625 = (state_64682[(8)]);
var inst_64639 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_64625,inst_64613);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(29),inst_64639);
} else {
if((state_val_64683 === (1))){
var state_64682__$1 = state_64682;
var statearr_64686_64742 = state_64682__$1;
(statearr_64686_64742[(2)] = null);

(statearr_64686_64742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (24))){
var inst_64625 = (state_64682[(8)]);
var inst_64652 = cljs.core.int_QMARK_(inst_64625);
var state_64682__$1 = state_64682;
if(inst_64652){
var statearr_64687_64743 = state_64682__$1;
(statearr_64687_64743[(1)] = (30));

} else {
var statearr_64688_64744 = state_64682__$1;
(statearr_64688_64744[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (4))){
var inst_64592 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64689_64745 = state_64682__$1;
(statearr_64689_64745[(2)] = inst_64592);

(statearr_64689_64745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (15))){
var inst_64605 = (state_64682[(9)]);
var state_64682__$1 = state_64682;
var statearr_64690_64746 = state_64682__$1;
(statearr_64690_64746[(2)] = inst_64605);

(statearr_64690_64746[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (21))){
var inst_64626 = (state_64682[(10)]);
var state_64682__$1 = state_64682;
var statearr_64691_64747 = state_64682__$1;
(statearr_64691_64747[(2)] = inst_64626);

(statearr_64691_64747[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (31))){
var state_64682__$1 = state_64682;
var statearr_64692_64748 = state_64682__$1;
(statearr_64692_64748[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (32))){
var inst_64665 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64694_64749 = state_64682__$1;
(statearr_64694_64749[(2)] = inst_64665);

(statearr_64694_64749[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (33))){
var inst_64656 = (state_64682[(2)]);
var inst_64657 = fluree.db.util.async.throw_err(inst_64656);
var state_64682__$1 = state_64682;
var statearr_64695_64750 = state_64682__$1;
(statearr_64695_64750[(2)] = inst_64657);

(statearr_64695_64750[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (13))){
var inst_64609 = (state_64682[(2)]);
var inst_64610 = fluree.db.util.async.throw_err(inst_64609);
var state_64682__$1 = state_64682;
var statearr_64696_64751 = state_64682__$1;
(statearr_64696_64751[(2)] = inst_64610);

(statearr_64696_64751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (22))){
var inst_64630 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
if(cljs.core.truth_(inst_64630)){
var statearr_64697_64752 = state_64682__$1;
(statearr_64697_64752[(1)] = (23));

} else {
var statearr_64698_64753 = state_64682__$1;
(statearr_64698_64753[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (36))){
var inst_64663 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64699_64754 = state_64682__$1;
(statearr_64699_64754[(2)] = inst_64663);

(statearr_64699_64754[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (29))){
var inst_64613 = (state_64682[(7)]);
var inst_64625 = (state_64682[(8)]);
var inst_64641 = (state_64682[(2)]);
var inst_64642 = fluree.db.util.async.throw_err(inst_64641);
var inst_64643 = cljs.core._deref(cache);
var inst_64644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64645 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_64625,inst_64613];
var inst_64646 = (new cljs.core.PersistentVector(null,3,(5),inst_64644,inst_64645,null));
var inst_64647 = cljs.core.assoc_in(inst_64643,inst_64646,inst_64642);
var inst_64648 = cljs.core._vreset_BANG_(cache,inst_64647);
var state_64682__$1 = (function (){var statearr_64700 = state_64682;
(statearr_64700[(11)] = inst_64648);

return statearr_64700;
})();
var statearr_64701_64755 = state_64682__$1;
(statearr_64701_64755[(2)] = inst_64642);

(statearr_64701_64755[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (6))){
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(9),subject);
} else {
if((state_val_64683 === (28))){
var inst_64650 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64702_64756 = state_64682__$1;
(statearr_64702_64756[(2)] = inst_64650);

(statearr_64702_64756[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (25))){
var inst_64613 = (state_64682[(7)]);
var inst_64605 = (state_64682[(9)]);
var inst_64667 = (state_64682[(2)]);
var inst_64668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64669 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64671 = [inst_64605,inst_64613];
var inst_64672 = (new cljs.core.PersistentVector(null,2,(5),inst_64670,inst_64671,null));
var inst_64673 = ["get",inst_64672,inst_64667];
var inst_64674 = cljs.core.PersistentHashMap.fromArrays(inst_64669,inst_64673);
var inst_64675 = [inst_64674,(10)];
var inst_64676 = (new cljs.core.PersistentVector(null,2,(5),inst_64668,inst_64675,null));
var inst_64677 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64676);
var _ = (function (){var statearr_64703 = state_64682;
(statearr_64703[(4)] = cljs.core.rest((state_64682[(4)])));

return statearr_64703;
})();
var state_64682__$1 = (function (){var statearr_64704 = state_64682;
(statearr_64704[(12)] = inst_64677);

return statearr_64704;
})();
var statearr_64705_64757 = state_64682__$1;
(statearr_64705_64757[(2)] = inst_64667);

(statearr_64705_64757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (34))){
var inst_64613 = (state_64682[(7)]);
var inst_64625 = (state_64682[(8)]);
var inst_64660 = fluree.db.dbfunctions.internal.get(inst_64625,inst_64613);
var state_64682__$1 = state_64682;
var statearr_64706_64758 = state_64682__$1;
(statearr_64706_64758[(2)] = inst_64660);

(statearr_64706_64758[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (17))){
var inst_64605 = (state_64682[(9)]);
var inst_64619 = cljs.core.first(inst_64605);
var state_64682__$1 = state_64682;
var statearr_64707_64759 = state_64682__$1;
(statearr_64707_64759[(2)] = inst_64619);

(statearr_64707_64759[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (3))){
var inst_64680 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64682__$1,inst_64680);
} else {
if((state_val_64683 === (12))){
var inst_64605 = (state_64682[(9)]);
var inst_64613 = (state_64682[(2)]);
var inst_64614 = cljs.core.vector_QMARK_(inst_64605);
var state_64682__$1 = (function (){var statearr_64708 = state_64682;
(statearr_64708[(7)] = inst_64613);

return statearr_64708;
})();
if(inst_64614){
var statearr_64709_64760 = state_64682__$1;
(statearr_64709_64760[(1)] = (14));

} else {
var statearr_64710_64761 = state_64682__$1;
(statearr_64710_64761[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (2))){
var _ = (function (){var statearr_64711 = state_64682;
(statearr_64711[(4)] = cljs.core.cons((5),(state_64682[(4)])));

return statearr_64711;
})();
var inst_64598 = fluree.db.util.async.channel_QMARK_(subject);
var state_64682__$1 = state_64682;
if(inst_64598){
var statearr_64712_64762 = state_64682__$1;
(statearr_64712_64762[(1)] = (6));

} else {
var statearr_64713_64763 = state_64682__$1;
(statearr_64713_64763[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (23))){
var inst_64613 = (state_64682[(7)]);
var inst_64625 = (state_64682[(8)]);
var inst_64636 = (state_64682[(13)]);
var inst_64632 = cljs.core.deref(cache);
var inst_64633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64634 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_64625,inst_64613];
var inst_64635 = (new cljs.core.PersistentVector(null,3,(5),inst_64633,inst_64634,null));
var inst_64636__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_64632,inst_64635);
var state_64682__$1 = (function (){var statearr_64714 = state_64682;
(statearr_64714[(13)] = inst_64636__$1);

return statearr_64714;
})();
if(cljs.core.truth_(inst_64636__$1)){
var statearr_64715_64764 = state_64682__$1;
(statearr_64715_64764[(1)] = (26));

} else {
var statearr_64716_64765 = state_64682__$1;
(statearr_64716_64765[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (35))){
var state_64682__$1 = state_64682;
var statearr_64717_64766 = state_64682__$1;
(statearr_64717_64766[(2)] = null);

(statearr_64717_64766[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (19))){
var inst_64622 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64718_64767 = state_64682__$1;
(statearr_64718_64767[(2)] = inst_64622);

(statearr_64718_64767[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (11))){
var state_64682__$1 = state_64682;
var statearr_64720_64768 = state_64682__$1;
(statearr_64720_64768[(2)] = pred);

(statearr_64720_64768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (9))){
var inst_64601 = (state_64682[(2)]);
var inst_64602 = fluree.db.util.async.throw_err(inst_64601);
var state_64682__$1 = state_64682;
var statearr_64721_64769 = state_64682__$1;
(statearr_64721_64769[(2)] = inst_64602);

(statearr_64721_64769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (5))){
var _ = (function (){var statearr_64722 = state_64682;
(statearr_64722[(4)] = cljs.core.rest((state_64682[(4)])));

return statearr_64722;
})();
var state_64682__$1 = state_64682;
var ex64719 = (state_64682__$1[(2)]);
var statearr_64723_64770 = state_64682__$1;
(statearr_64723_64770[(5)] = ex64719);


if((ex64719 instanceof Error)){
var statearr_64724_64771 = state_64682__$1;
(statearr_64724_64771[(1)] = (4));

(statearr_64724_64771[(5)] = null);

} else {
throw ex64719;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (14))){
var inst_64605 = (state_64682[(9)]);
var inst_64616 = cljs.core.count(inst_64605);
var inst_64617 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64616);
var state_64682__$1 = state_64682;
if(inst_64617){
var statearr_64725_64772 = state_64682__$1;
(statearr_64725_64772[(1)] = (17));

} else {
var statearr_64726_64773 = state_64682__$1;
(statearr_64726_64773[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (26))){
var inst_64636 = (state_64682[(13)]);
var state_64682__$1 = state_64682;
var statearr_64727_64774 = state_64682__$1;
(statearr_64727_64774[(2)] = inst_64636);

(statearr_64727_64774[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (16))){
var inst_64625 = (state_64682[(8)]);
var inst_64626 = (state_64682[(10)]);
var inst_64625__$1 = (state_64682[(2)]);
var inst_64626__$1 = cljs.core.int_QMARK_(inst_64625__$1);
var state_64682__$1 = (function (){var statearr_64728 = state_64682;
(statearr_64728[(8)] = inst_64625__$1);

(statearr_64728[(10)] = inst_64626__$1);

return statearr_64728;
})();
if(inst_64626__$1){
var statearr_64729_64775 = state_64682__$1;
(statearr_64729_64775[(1)] = (20));

} else {
var statearr_64730_64776 = state_64682__$1;
(statearr_64730_64776[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (30))){
var inst_64613 = (state_64682[(7)]);
var inst_64625 = (state_64682[(8)]);
var inst_64654 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_64625,inst_64613);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(33),inst_64654);
} else {
if((state_val_64683 === (10))){
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(13),pred);
} else {
if((state_val_64683 === (18))){
var inst_64605 = (state_64682[(9)]);
var state_64682__$1 = state_64682;
var statearr_64731_64777 = state_64682__$1;
(statearr_64731_64777[(2)] = inst_64605);

(statearr_64731_64777[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (8))){
var inst_64605 = (state_64682[(2)]);
var inst_64606 = fluree.db.util.async.channel_QMARK_(pred);
var state_64682__$1 = (function (){var statearr_64732 = state_64682;
(statearr_64732[(9)] = inst_64605);

return statearr_64732;
})();
if(inst_64606){
var statearr_64733_64778 = state_64682__$1;
(statearr_64733_64778[(1)] = (10));

} else {
var statearr_64734_64779 = state_64682__$1;
(statearr_64734_64779[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_64735 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64735[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_64735[(1)] = (1));

return statearr_64735;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_64682){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64682);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64736){var ex__2730__auto__ = e64736;
var statearr_64737_64780 = state_64682;
(statearr_64737_64780[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64682[(4)]))){
var statearr_64738_64781 = state_64682;
(statearr_64738_64781[(1)] = cljs.core.first((state_64682[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64782 = state_64682;
state_64682 = G__64782;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_64682){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_64682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64739 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64739[(6)] = c__2749__auto__);

return statearr_64739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64821){
var state_val_64822 = (state_64821[(1)]);
if((state_val_64822 === (7))){
var inst_64789 = (state_64821[(7)]);
var state_64821__$1 = state_64821;
var statearr_64823_64847 = state_64821__$1;
(statearr_64823_64847[(2)] = inst_64789);

(statearr_64823_64847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (1))){
var state_64821__$1 = state_64821;
var statearr_64824_64848 = state_64821__$1;
(statearr_64824_64848[(2)] = null);

(statearr_64824_64848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (4))){
var inst_64783 = (state_64821[(2)]);
var state_64821__$1 = state_64821;
var statearr_64825_64849 = state_64821__$1;
(statearr_64825_64849[(2)] = inst_64783);

(statearr_64825_64849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (6))){
var inst_64791 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64821__$1 = state_64821;
var statearr_64826_64850 = state_64821__$1;
(statearr_64826_64850[(2)] = inst_64791);

(statearr_64826_64850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (3))){
var inst_64819 = (state_64821[(2)]);
var state_64821__$1 = state_64821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64821__$1,inst_64819);
} else {
if((state_val_64822 === (12))){
var inst_64801 = (state_64821[(2)]);
var inst_64802 = fluree.db.util.async.throw_err(inst_64801);
var inst_64803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64802,(0),null);
var inst_64804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64802,(1),null);
var inst_64805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64806 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64807 = ["?pO","?ctx",inst_64803];
var inst_64808 = cljs.core.PersistentHashMap.fromArrays(inst_64806,inst_64807);
var inst_64809 = ((10) + inst_64804);
var inst_64810 = [inst_64808,inst_64809];
var inst_64811 = (new cljs.core.PersistentVector(null,2,(5),inst_64805,inst_64810,null));
var inst_64812 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64811);
var state_64821__$1 = (function (){var statearr_64827 = state_64821;
(statearr_64827[(8)] = inst_64812);

return statearr_64827;
})();
var statearr_64828_64851 = state_64821__$1;
(statearr_64828_64851[(2)] = inst_64803);

(statearr_64828_64851[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (2))){
var inst_64789 = (state_64821[(7)]);
var _ = (function (){var statearr_64829 = state_64821;
(statearr_64829[(4)] = cljs.core.cons((5),(state_64821[(4)])));

return statearr_64829;
})();
var inst_64789__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64821__$1 = (function (){var statearr_64830 = state_64821;
(statearr_64830[(7)] = inst_64789__$1);

return statearr_64830;
})();
if(cljs.core.truth_(inst_64789__$1)){
var statearr_64831_64852 = state_64821__$1;
(statearr_64831_64852[(1)] = (6));

} else {
var statearr_64832_64853 = state_64821__$1;
(statearr_64832_64853[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (11))){
var inst_64816 = (state_64821[(2)]);
var _ = (function (){var statearr_64834 = state_64821;
(statearr_64834[(4)] = cljs.core.rest((state_64821[(4)])));

return statearr_64834;
})();
var state_64821__$1 = state_64821;
var statearr_64835_64854 = state_64821__$1;
(statearr_64835_64854[(2)] = inst_64816);

(statearr_64835_64854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (9))){
var inst_64799 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_64821__$1 = state_64821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64821__$1,(12),inst_64799);
} else {
if((state_val_64822 === (5))){
var _ = (function (){var statearr_64836 = state_64821;
(statearr_64836[(4)] = cljs.core.rest((state_64821[(4)])));

return statearr_64836;
})();
var state_64821__$1 = state_64821;
var ex64833 = (state_64821__$1[(2)]);
var statearr_64837_64855 = state_64821__$1;
(statearr_64837_64855[(5)] = ex64833);


if((ex64833 instanceof Error)){
var statearr_64838_64856 = state_64821__$1;
(statearr_64838_64856[(1)] = (4));

(statearr_64838_64856[(5)] = null);

} else {
throw ex64833;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (10))){
var inst_64814 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_64821__$1 = state_64821;
var statearr_64839_64857 = state_64821__$1;
(statearr_64839_64857[(2)] = inst_64814);

(statearr_64839_64857[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64822 === (8))){
var inst_64794 = (state_64821[(2)]);
var state_64821__$1 = state_64821;
if(cljs.core.truth_(inst_64794)){
var statearr_64840_64858 = state_64821__$1;
(statearr_64840_64858[(1)] = (9));

} else {
var statearr_64841_64859 = state_64821__$1;
(statearr_64841_64859[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_64842 = [null,null,null,null,null,null,null,null,null];
(statearr_64842[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_64842[(1)] = (1));

return statearr_64842;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_64821){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64821);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64843){var ex__2730__auto__ = e64843;
var statearr_64844_64860 = state_64821;
(statearr_64844_64860[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64821[(4)]))){
var statearr_64845_64861 = state_64821;
(statearr_64845_64861[(1)] = cljs.core.first((state_64821[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64862 = state_64821;
state_64821 = G__64862;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_64821){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_64821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64846 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64846[(6)] = c__2749__auto__);

return statearr_64846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64931){
var state_val_64932 = (state_64931[(1)]);
if((state_val_64932 === (7))){
var state_64931__$1 = state_64931;
var statearr_64933_64971 = state_64931__$1;
(statearr_64933_64971[(2)] = subject);

(statearr_64933_64971[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (20))){
var inst_64899 = (state_64931[(7)]);
var inst_64887 = (state_64931[(8)]);
var inst_64902 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_64899,inst_64887);
var state_64931__$1 = state_64931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64931__$1,(23),inst_64902);
} else {
if((state_val_64932 === (1))){
var state_64931__$1 = state_64931;
var statearr_64934_64972 = state_64931__$1;
(statearr_64934_64972[(2)] = null);

(statearr_64934_64972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (4))){
var inst_64863 = (state_64931[(2)]);
var state_64931__$1 = state_64931;
var statearr_64935_64973 = state_64931__$1;
(statearr_64935_64973[(2)] = inst_64863);

(statearr_64935_64973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (15))){
var inst_64879 = (state_64931[(9)]);
var state_64931__$1 = state_64931;
var statearr_64936_64974 = state_64931__$1;
(statearr_64936_64974[(2)] = inst_64879);

(statearr_64936_64974[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (21))){
var inst_64899 = (state_64931[(7)]);
var inst_64887 = (state_64931[(8)]);
var inst_64907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64908 = fluree.db.dbfunctions.internal.get_all(inst_64899,inst_64887);
var inst_64909 = cljs.core.count(inst_64887);
var inst_64910 = ((9) + inst_64909);
var inst_64911 = [inst_64908,inst_64910];
var inst_64912 = (new cljs.core.PersistentVector(null,2,(5),inst_64907,inst_64911,null));
var state_64931__$1 = state_64931;
var statearr_64937_64975 = state_64931__$1;
(statearr_64937_64975[(2)] = inst_64912);

(statearr_64937_64975[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (13))){
var inst_64883 = (state_64931[(2)]);
var inst_64884 = fluree.db.util.async.throw_err(inst_64883);
var state_64931__$1 = state_64931;
var statearr_64938_64976 = state_64931__$1;
(statearr_64938_64976[(2)] = inst_64884);

(statearr_64938_64976[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (22))){
var inst_64879 = (state_64931[(9)]);
var inst_64887 = (state_64931[(8)]);
var inst_64914 = (state_64931[(2)]);
var inst_64915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64914,(0),null);
var inst_64916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64914,(1),null);
var inst_64917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64918 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64920 = [inst_64879,inst_64887];
var inst_64921 = (new cljs.core.PersistentVector(null,2,(5),inst_64919,inst_64920,null));
var inst_64922 = ["get-all",inst_64921,inst_64915];
var inst_64923 = cljs.core.PersistentHashMap.fromArrays(inst_64918,inst_64922);
var inst_64924 = [inst_64923,inst_64916];
var inst_64925 = (new cljs.core.PersistentVector(null,2,(5),inst_64917,inst_64924,null));
var inst_64926 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64925);
var _ = (function (){var statearr_64939 = state_64931;
(statearr_64939[(4)] = cljs.core.rest((state_64931[(4)])));

return statearr_64939;
})();
var state_64931__$1 = (function (){var statearr_64940 = state_64931;
(statearr_64940[(10)] = inst_64926);

return statearr_64940;
})();
var statearr_64941_64977 = state_64931__$1;
(statearr_64941_64977[(2)] = inst_64915);

(statearr_64941_64977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (6))){
var state_64931__$1 = state_64931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64931__$1,(9),subject);
} else {
if((state_val_64932 === (17))){
var inst_64879 = (state_64931[(9)]);
var inst_64893 = cljs.core.first(inst_64879);
var state_64931__$1 = state_64931;
var statearr_64942_64978 = state_64931__$1;
(statearr_64942_64978[(2)] = inst_64893);

(statearr_64942_64978[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (3))){
var inst_64929 = (state_64931[(2)]);
var state_64931__$1 = state_64931;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64931__$1,inst_64929);
} else {
if((state_val_64932 === (12))){
var inst_64879 = (state_64931[(9)]);
var inst_64887 = (state_64931[(2)]);
var inst_64888 = cljs.core.vector_QMARK_(inst_64879);
var state_64931__$1 = (function (){var statearr_64943 = state_64931;
(statearr_64943[(8)] = inst_64887);

return statearr_64943;
})();
if(inst_64888){
var statearr_64944_64979 = state_64931__$1;
(statearr_64944_64979[(1)] = (14));

} else {
var statearr_64945_64980 = state_64931__$1;
(statearr_64945_64980[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (2))){
var _ = (function (){var statearr_64946 = state_64931;
(statearr_64946[(4)] = cljs.core.cons((5),(state_64931[(4)])));

return statearr_64946;
})();
var inst_64872 = fluree.db.util.async.channel_QMARK_(subject);
var state_64931__$1 = state_64931;
if(inst_64872){
var statearr_64947_64981 = state_64931__$1;
(statearr_64947_64981[(1)] = (6));

} else {
var statearr_64948_64982 = state_64931__$1;
(statearr_64948_64982[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (23))){
var inst_64904 = (state_64931[(2)]);
var inst_64905 = fluree.db.util.async.throw_err(inst_64904);
var state_64931__$1 = state_64931;
var statearr_64949_64983 = state_64931__$1;
(statearr_64949_64983[(2)] = inst_64905);

(statearr_64949_64983[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (19))){
var inst_64896 = (state_64931[(2)]);
var state_64931__$1 = state_64931;
var statearr_64950_64984 = state_64931__$1;
(statearr_64950_64984[(2)] = inst_64896);

(statearr_64950_64984[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (11))){
var state_64931__$1 = state_64931;
var statearr_64952_64985 = state_64931__$1;
(statearr_64952_64985[(2)] = path);

(statearr_64952_64985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (9))){
var inst_64875 = (state_64931[(2)]);
var inst_64876 = fluree.db.util.async.throw_err(inst_64875);
var state_64931__$1 = state_64931;
var statearr_64953_64986 = state_64931__$1;
(statearr_64953_64986[(2)] = inst_64876);

(statearr_64953_64986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (5))){
var _ = (function (){var statearr_64954 = state_64931;
(statearr_64954[(4)] = cljs.core.rest((state_64931[(4)])));

return statearr_64954;
})();
var state_64931__$1 = state_64931;
var ex64951 = (state_64931__$1[(2)]);
var statearr_64955_64987 = state_64931__$1;
(statearr_64955_64987[(5)] = ex64951);


if((ex64951 instanceof Error)){
var statearr_64956_64988 = state_64931__$1;
(statearr_64956_64988[(1)] = (4));

(statearr_64956_64988[(5)] = null);

} else {
throw ex64951;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (14))){
var inst_64879 = (state_64931[(9)]);
var inst_64890 = cljs.core.count(inst_64879);
var inst_64891 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64890);
var state_64931__$1 = state_64931;
if(inst_64891){
var statearr_64957_64989 = state_64931__$1;
(statearr_64957_64989[(1)] = (17));

} else {
var statearr_64958_64990 = state_64931__$1;
(statearr_64958_64990[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (16))){
var inst_64899 = (state_64931[(7)]);
var inst_64899__$1 = (state_64931[(2)]);
var inst_64900 = cljs.core.int_QMARK_(inst_64899__$1);
var state_64931__$1 = (function (){var statearr_64959 = state_64931;
(statearr_64959[(7)] = inst_64899__$1);

return statearr_64959;
})();
if(inst_64900){
var statearr_64960_64991 = state_64931__$1;
(statearr_64960_64991[(1)] = (20));

} else {
var statearr_64961_64992 = state_64931__$1;
(statearr_64961_64992[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (10))){
var state_64931__$1 = state_64931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64931__$1,(13),path);
} else {
if((state_val_64932 === (18))){
var inst_64879 = (state_64931[(9)]);
var state_64931__$1 = state_64931;
var statearr_64962_64993 = state_64931__$1;
(statearr_64962_64993[(2)] = inst_64879);

(statearr_64962_64993[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64932 === (8))){
var inst_64879 = (state_64931[(2)]);
var inst_64880 = fluree.db.util.async.channel_QMARK_(path);
var state_64931__$1 = (function (){var statearr_64963 = state_64931;
(statearr_64963[(9)] = inst_64879);

return statearr_64963;
})();
if(inst_64880){
var statearr_64964_64994 = state_64931__$1;
(statearr_64964_64994[(1)] = (10));

} else {
var statearr_64965_64995 = state_64931__$1;
(statearr_64965_64995[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_64966 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64966[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_64966[(1)] = (1));

return statearr_64966;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_64931){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64931);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64967){var ex__2730__auto__ = e64967;
var statearr_64968_64996 = state_64931;
(statearr_64968_64996[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64931[(4)]))){
var statearr_64969_64997 = state_64931;
(statearr_64969_64997[(1)] = cljs.core.first((state_64931[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64998 = state_64931;
state_64931 = G__64998;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_64931){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_64931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64970 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64970[(6)] = c__2749__auto__);

return statearr_64970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65037){
var state_val_65038 = (state_65037[(1)]);
if((state_val_65038 === (7))){
var state_65037__$1 = state_65037;
var statearr_65039_65063 = state_65037__$1;
(statearr_65039_65063[(2)] = subject);

(statearr_65039_65063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (1))){
var state_65037__$1 = state_65037;
var statearr_65040_65064 = state_65037__$1;
(statearr_65040_65064[(2)] = null);

(statearr_65040_65064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (4))){
var inst_64999 = (state_65037[(2)]);
var state_65037__$1 = state_65037;
var statearr_65041_65065 = state_65037__$1;
(statearr_65041_65065[(2)] = inst_64999);

(statearr_65041_65065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (13))){
var inst_65016 = (state_65037[(2)]);
var inst_65017 = fluree.db.util.async.throw_err(inst_65016);
var state_65037__$1 = state_65037;
var statearr_65042_65066 = state_65037__$1;
(statearr_65042_65066[(2)] = inst_65017);

(statearr_65042_65066[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (6))){
var state_65037__$1 = state_65037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65037__$1,(9),subject);
} else {
if((state_val_65038 === (3))){
var inst_65035 = (state_65037[(2)]);
var state_65037__$1 = state_65037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65037__$1,inst_65035);
} else {
if((state_val_65038 === (12))){
var inst_65012 = (state_65037[(7)]);
var inst_65020 = (state_65037[(2)]);
var inst_65021 = fluree.db.dbfunctions.internal.get_in(inst_65012,inst_65020);
var inst_65022 = cljs.core.count(inst_65020);
var inst_65023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65024 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65026 = [inst_65012,inst_65020];
var inst_65027 = (new cljs.core.PersistentVector(null,2,(5),inst_65025,inst_65026,null));
var inst_65028 = ["get-in",inst_65027,inst_65021];
var inst_65029 = cljs.core.PersistentHashMap.fromArrays(inst_65024,inst_65028);
var inst_65030 = [inst_65029,inst_65022];
var inst_65031 = (new cljs.core.PersistentVector(null,2,(5),inst_65023,inst_65030,null));
var inst_65032 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65031);
var _ = (function (){var statearr_65043 = state_65037;
(statearr_65043[(4)] = cljs.core.rest((state_65037[(4)])));

return statearr_65043;
})();
var state_65037__$1 = (function (){var statearr_65044 = state_65037;
(statearr_65044[(8)] = inst_65032);

return statearr_65044;
})();
var statearr_65045_65067 = state_65037__$1;
(statearr_65045_65067[(2)] = inst_65021);

(statearr_65045_65067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (2))){
var _ = (function (){var statearr_65046 = state_65037;
(statearr_65046[(4)] = cljs.core.cons((5),(state_65037[(4)])));

return statearr_65046;
})();
var inst_65005 = fluree.db.util.async.channel_QMARK_(subject);
var state_65037__$1 = state_65037;
if(inst_65005){
var statearr_65047_65068 = state_65037__$1;
(statearr_65047_65068[(1)] = (6));

} else {
var statearr_65048_65069 = state_65037__$1;
(statearr_65048_65069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (11))){
var state_65037__$1 = state_65037;
var statearr_65050_65070 = state_65037__$1;
(statearr_65050_65070[(2)] = path);

(statearr_65050_65070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (9))){
var inst_65008 = (state_65037[(2)]);
var inst_65009 = fluree.db.util.async.throw_err(inst_65008);
var state_65037__$1 = state_65037;
var statearr_65051_65071 = state_65037__$1;
(statearr_65051_65071[(2)] = inst_65009);

(statearr_65051_65071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (5))){
var _ = (function (){var statearr_65052 = state_65037;
(statearr_65052[(4)] = cljs.core.rest((state_65037[(4)])));

return statearr_65052;
})();
var state_65037__$1 = state_65037;
var ex65049 = (state_65037__$1[(2)]);
var statearr_65053_65072 = state_65037__$1;
(statearr_65053_65072[(5)] = ex65049);


if((ex65049 instanceof Error)){
var statearr_65054_65073 = state_65037__$1;
(statearr_65054_65073[(1)] = (4));

(statearr_65054_65073[(5)] = null);

} else {
throw ex65049;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65038 === (10))){
var state_65037__$1 = state_65037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65037__$1,(13),path);
} else {
if((state_val_65038 === (8))){
var inst_65012 = (state_65037[(2)]);
var inst_65013 = fluree.db.util.async.channel_QMARK_(path);
var state_65037__$1 = (function (){var statearr_65055 = state_65037;
(statearr_65055[(7)] = inst_65012);

return statearr_65055;
})();
if(inst_65013){
var statearr_65056_65074 = state_65037__$1;
(statearr_65056_65074[(1)] = (10));

} else {
var statearr_65057_65075 = state_65037__$1;
(statearr_65057_65075[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_65058 = [null,null,null,null,null,null,null,null,null];
(statearr_65058[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_65058[(1)] = (1));

return statearr_65058;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_65037){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65037);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65059){var ex__2730__auto__ = e65059;
var statearr_65060_65076 = state_65037;
(statearr_65060_65076[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65037[(4)]))){
var statearr_65061_65077 = state_65037;
(statearr_65061_65077[(1)] = cljs.core.first((state_65037[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65078 = state_65037;
state_65037 = G__65078;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_65037){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_65037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65062 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65062[(6)] = c__2749__auto__);

return statearr_65062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__65079,key_or_ks){
var map__65080 = p__65079;
var map__65080__$1 = cljs.core.__destructure_map(map__65080);
var _QMARK_ctx = map__65080__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65080__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65125){
var state_val_65126 = (state_65125[(1)]);
if((state_val_65126 === (7))){
var state_65125__$1 = state_65125;
var statearr_65127_65156 = state_65125__$1;
(statearr_65127_65156[(2)] = coll);

(statearr_65127_65156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (1))){
var state_65125__$1 = state_65125;
var statearr_65128_65157 = state_65125__$1;
(statearr_65128_65157[(2)] = null);

(statearr_65128_65157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (4))){
var inst_65081 = (state_65125[(2)]);
var state_65125__$1 = state_65125;
var statearr_65129_65158 = state_65125__$1;
(statearr_65129_65158[(2)] = inst_65081);

(statearr_65129_65158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (15))){
var inst_65101 = (state_65125[(7)]);
var inst_65109 = (state_65125[(2)]);
var inst_65110 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_65101,inst_65109);
var inst_65111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65112 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65114 = [inst_65101,inst_65109];
var inst_65115 = (new cljs.core.PersistentVector(null,2,(5),inst_65113,inst_65114,null));
var inst_65116 = ["contains?",inst_65115,inst_65110];
var inst_65117 = cljs.core.PersistentHashMap.fromArrays(inst_65112,inst_65116);
var inst_65118 = [inst_65117,(10)];
var inst_65119 = (new cljs.core.PersistentVector(null,2,(5),inst_65111,inst_65118,null));
var inst_65120 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65119);
var _ = (function (){var statearr_65130 = state_65125;
(statearr_65130[(4)] = cljs.core.rest((state_65125[(4)])));

return statearr_65130;
})();
var state_65125__$1 = (function (){var statearr_65131 = state_65125;
(statearr_65131[(8)] = inst_65120);

return statearr_65131;
})();
var statearr_65132_65159 = state_65125__$1;
(statearr_65132_65159[(2)] = inst_65110);

(statearr_65132_65159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (13))){
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(16),key);
} else {
if((state_val_65126 === (6))){
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(9),coll);
} else {
if((state_val_65126 === (3))){
var inst_65123 = (state_65125[(2)]);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65125__$1,inst_65123);
} else {
if((state_val_65126 === (12))){
var inst_65101 = (state_65125[(2)]);
var inst_65102 = fluree.db.util.async.channel_QMARK_(key);
var state_65125__$1 = (function (){var statearr_65133 = state_65125;
(statearr_65133[(7)] = inst_65101);

return statearr_65133;
})();
if(inst_65102){
var statearr_65134_65160 = state_65125__$1;
(statearr_65134_65160[(1)] = (13));

} else {
var statearr_65135_65161 = state_65125__$1;
(statearr_65135_65161[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (2))){
var _ = (function (){var statearr_65136 = state_65125;
(statearr_65136[(4)] = cljs.core.cons((5),(state_65125[(4)])));

return statearr_65136;
})();
var inst_65087 = fluree.db.util.async.channel_QMARK_(coll);
var state_65125__$1 = state_65125;
if(inst_65087){
var statearr_65137_65162 = state_65125__$1;
(statearr_65137_65162[(1)] = (6));

} else {
var statearr_65138_65163 = state_65125__$1;
(statearr_65138_65163[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (11))){
var inst_65094 = (state_65125[(9)]);
var inst_65098 = cljs.core.flatten(inst_65094);
var inst_65099 = cljs.core.set(inst_65098);
var state_65125__$1 = state_65125;
var statearr_65140_65164 = state_65125__$1;
(statearr_65140_65164[(2)] = inst_65099);

(statearr_65140_65164[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (9))){
var inst_65090 = (state_65125[(2)]);
var inst_65091 = fluree.db.util.async.throw_err(inst_65090);
var state_65125__$1 = state_65125;
var statearr_65141_65165 = state_65125__$1;
(statearr_65141_65165[(2)] = inst_65091);

(statearr_65141_65165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (5))){
var _ = (function (){var statearr_65142 = state_65125;
(statearr_65142[(4)] = cljs.core.rest((state_65125[(4)])));

return statearr_65142;
})();
var state_65125__$1 = state_65125;
var ex65139 = (state_65125__$1[(2)]);
var statearr_65143_65166 = state_65125__$1;
(statearr_65143_65166[(5)] = ex65139);


if((ex65139 instanceof Error)){
var statearr_65144_65167 = state_65125__$1;
(statearr_65144_65167[(1)] = (4));

(statearr_65144_65167[(5)] = null);

} else {
throw ex65139;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (14))){
var state_65125__$1 = state_65125;
var statearr_65145_65168 = state_65125__$1;
(statearr_65145_65168[(2)] = key);

(statearr_65145_65168[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (16))){
var inst_65105 = (state_65125[(2)]);
var inst_65106 = fluree.db.util.async.throw_err(inst_65105);
var state_65125__$1 = state_65125;
var statearr_65146_65169 = state_65125__$1;
(statearr_65146_65169[(2)] = inst_65106);

(statearr_65146_65169[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (10))){
var inst_65094 = (state_65125[(9)]);
var state_65125__$1 = state_65125;
var statearr_65147_65170 = state_65125__$1;
(statearr_65147_65170[(2)] = inst_65094);

(statearr_65147_65170[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (8))){
var inst_65094 = (state_65125[(9)]);
var inst_65094__$1 = (state_65125[(2)]);
var inst_65095 = cljs.core.set_QMARK_(inst_65094__$1);
var state_65125__$1 = (function (){var statearr_65148 = state_65125;
(statearr_65148[(9)] = inst_65094__$1);

return statearr_65148;
})();
if(inst_65095){
var statearr_65149_65171 = state_65125__$1;
(statearr_65149_65171[(1)] = (10));

} else {
var statearr_65150_65172 = state_65125__$1;
(statearr_65150_65172[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_65151 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65151[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_65151[(1)] = (1));

return statearr_65151;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_65125){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65125);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65152){var ex__2730__auto__ = e65152;
var statearr_65153_65173 = state_65125;
(statearr_65153_65173[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65125[(4)]))){
var statearr_65154_65174 = state_65125;
(statearr_65154_65174[(1)] = cljs.core.first((state_65125[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65175 = state_65125;
state_65125 = G__65175;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_65125){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_65125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65155 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65155[(6)] = c__2749__auto__);

return statearr_65155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65247 = arguments.length;
var i__5770__auto___65248 = (0);
while(true){
if((i__5770__auto___65248 < len__5769__auto___65247)){
args__5775__auto__.push((arguments[i__5770__auto___65248]));

var G__65249 = (i__5770__auto___65248 + (1));
i__5770__auto___65248 = G__65249;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65221){
var state_val_65222 = (state_65221[(1)]);
if((state_val_65222 === (7))){
var inst_65187 = (state_65221[(7)]);
var inst_65191 = cljs.core.first(inst_65187);
var inst_65192 = cljs.core.coll_QMARK_(inst_65191);
var state_65221__$1 = state_65221;
var statearr_65223_65250 = state_65221__$1;
(statearr_65223_65250[(2)] = inst_65192);

(statearr_65223_65250[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (1))){
var state_65221__$1 = state_65221;
var statearr_65224_65251 = state_65221__$1;
(statearr_65224_65251[(2)] = null);

(statearr_65224_65251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (4))){
var inst_65178 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
var statearr_65225_65252 = state_65221__$1;
(statearr_65225_65252[(2)] = inst_65178);

(statearr_65225_65252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (6))){
var inst_65187 = (state_65221[(7)]);
var inst_65189 = (state_65221[(8)]);
var inst_65186 = (state_65221[(2)]);
var inst_65187__$1 = fluree.db.util.async.throw_err(inst_65186);
var inst_65188 = cljs.core.count(inst_65187__$1);
var inst_65189__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65188);
var state_65221__$1 = (function (){var statearr_65226 = state_65221;
(statearr_65226[(7)] = inst_65187__$1);

(statearr_65226[(8)] = inst_65189__$1);

return statearr_65226;
})();
if(inst_65189__$1){
var statearr_65227_65253 = state_65221__$1;
(statearr_65227_65253[(1)] = (7));

} else {
var statearr_65228_65254 = state_65221__$1;
(statearr_65228_65254[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (3))){
var inst_65219 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65221__$1,inst_65219);
} else {
if((state_val_65222 === (12))){
var inst_65200 = (state_65221[(2)]);
var inst_65201 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_65200);
var inst_65202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65203 = [inst_65200];
var inst_65204 = (new cljs.core.PersistentVector(null,1,(5),inst_65202,inst_65203,null));
var inst_65205 = cljs.core.count(inst_65204);
var inst_65206 = ((9) + inst_65205);
var inst_65207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65208 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65210 = [inst_65200];
var inst_65211 = (new cljs.core.PersistentVector(null,1,(5),inst_65209,inst_65210,null));
var inst_65212 = ["hash-set",inst_65211,inst_65201];
var inst_65213 = cljs.core.PersistentHashMap.fromArrays(inst_65208,inst_65212);
var inst_65214 = [inst_65213,inst_65206];
var inst_65215 = (new cljs.core.PersistentVector(null,2,(5),inst_65207,inst_65214,null));
var inst_65216 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65215);
var _ = (function (){var statearr_65229 = state_65221;
(statearr_65229[(4)] = cljs.core.rest((state_65221[(4)])));

return statearr_65229;
})();
var state_65221__$1 = (function (){var statearr_65230 = state_65221;
(statearr_65230[(9)] = inst_65216);

return statearr_65230;
})();
var statearr_65231_65255 = state_65221__$1;
(statearr_65231_65255[(2)] = inst_65201);

(statearr_65231_65255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (2))){
var _ = (function (){var statearr_65232 = state_65221;
(statearr_65232[(4)] = cljs.core.cons((5),(state_65221[(4)])));

return statearr_65232;
})();
var inst_65184 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65221__$1 = state_65221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65221__$1,(6),inst_65184);
} else {
if((state_val_65222 === (11))){
var inst_65187 = (state_65221[(7)]);
var state_65221__$1 = state_65221;
var statearr_65234_65256 = state_65221__$1;
(statearr_65234_65256[(2)] = inst_65187);

(statearr_65234_65256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (9))){
var inst_65195 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
if(cljs.core.truth_(inst_65195)){
var statearr_65235_65257 = state_65221__$1;
(statearr_65235_65257[(1)] = (10));

} else {
var statearr_65236_65258 = state_65221__$1;
(statearr_65236_65258[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (5))){
var _ = (function (){var statearr_65237 = state_65221;
(statearr_65237[(4)] = cljs.core.rest((state_65221[(4)])));

return statearr_65237;
})();
var state_65221__$1 = state_65221;
var ex65233 = (state_65221__$1[(2)]);
var statearr_65238_65259 = state_65221__$1;
(statearr_65238_65259[(5)] = ex65233);


if((ex65233 instanceof Error)){
var statearr_65239_65260 = state_65221__$1;
(statearr_65239_65260[(1)] = (4));

(statearr_65239_65260[(5)] = null);

} else {
throw ex65233;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (10))){
var inst_65187 = (state_65221[(7)]);
var inst_65197 = cljs.core.first(inst_65187);
var state_65221__$1 = state_65221;
var statearr_65240_65261 = state_65221__$1;
(statearr_65240_65261[(2)] = inst_65197);

(statearr_65240_65261[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (8))){
var inst_65189 = (state_65221[(8)]);
var state_65221__$1 = state_65221;
var statearr_65241_65262 = state_65221__$1;
(statearr_65241_65262[(2)] = inst_65189);

(statearr_65241_65262[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65242 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65242[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65242[(1)] = (1));

return statearr_65242;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65221){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65221);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65243){var ex__2730__auto__ = e65243;
var statearr_65244_65263 = state_65221;
(statearr_65244_65263[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65221[(4)]))){
var statearr_65245_65264 = state_65221;
(statearr_65245_65264[(1)] = cljs.core.first((state_65221[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65265 = state_65221;
state_65221 = G__65265;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65221){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65246 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65246[(6)] = c__2749__auto__);

return statearr_65246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq65176){
var G__65177 = cljs.core.first(seq65176);
var seq65176__$1 = cljs.core.next(seq65176);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65177,seq65176__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65315 = arguments.length;
var i__5770__auto___65316 = (0);
while(true){
if((i__5770__auto___65316 < len__5769__auto___65315)){
args__5775__auto__.push((arguments[i__5770__auto___65316]));

var G__65317 = (i__5770__auto___65316 + (1));
i__5770__auto___65316 = G__65317;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65298){
var state_val_65299 = (state_65298[(1)]);
if((state_val_65299 === (1))){
var state_65298__$1 = state_65298;
var statearr_65300_65318 = state_65298__$1;
(statearr_65300_65318[(2)] = null);

(statearr_65300_65318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65299 === (2))){
var _ = (function (){var statearr_65301 = state_65298;
(statearr_65301[(4)] = cljs.core.cons((5),(state_65298[(4)])));

return statearr_65301;
})();
var inst_65274 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65298__$1 = state_65298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65298__$1,(6),inst_65274);
} else {
if((state_val_65299 === (3))){
var inst_65296 = (state_65298[(2)]);
var state_65298__$1 = state_65298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65298__$1,inst_65296);
} else {
if((state_val_65299 === (4))){
var inst_65268 = (state_65298[(2)]);
var state_65298__$1 = state_65298;
var statearr_65303_65319 = state_65298__$1;
(statearr_65303_65319[(2)] = inst_65268);

(statearr_65303_65319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65299 === (5))){
var _ = (function (){var statearr_65304 = state_65298;
(statearr_65304[(4)] = cljs.core.rest((state_65298[(4)])));

return statearr_65304;
})();
var state_65298__$1 = state_65298;
var ex65302 = (state_65298__$1[(2)]);
var statearr_65305_65320 = state_65298__$1;
(statearr_65305_65320[(5)] = ex65302);


if((ex65302 instanceof Error)){
var statearr_65306_65321 = state_65298__$1;
(statearr_65306_65321[(1)] = (4));

(statearr_65306_65321[(5)] = null);

} else {
throw ex65302;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65299 === (6))){
var inst_65276 = (state_65298[(2)]);
var inst_65277 = fluree.db.util.async.throw_err(inst_65276);
var inst_65278 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_65277);
var inst_65279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65280 = [inst_65277];
var inst_65281 = (new cljs.core.PersistentVector(null,1,(5),inst_65279,inst_65280,null));
var inst_65282 = cljs.core.count(inst_65281);
var inst_65283 = ((9) + inst_65282);
var inst_65284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65285 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65287 = [inst_65277];
var inst_65288 = (new cljs.core.PersistentVector(null,1,(5),inst_65286,inst_65287,null));
var inst_65289 = ["==",inst_65288,inst_65278];
var inst_65290 = cljs.core.PersistentHashMap.fromArrays(inst_65285,inst_65289);
var inst_65291 = [inst_65290,inst_65283];
var inst_65292 = (new cljs.core.PersistentVector(null,2,(5),inst_65284,inst_65291,null));
var inst_65293 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65292);
var _ = (function (){var statearr_65307 = state_65298;
(statearr_65307[(4)] = cljs.core.rest((state_65298[(4)])));

return statearr_65307;
})();
var state_65298__$1 = (function (){var statearr_65308 = state_65298;
(statearr_65308[(7)] = inst_65293);

return statearr_65308;
})();
var statearr_65309_65322 = state_65298__$1;
(statearr_65309_65322[(2)] = inst_65278);

(statearr_65309_65322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65310 = [null,null,null,null,null,null,null,null];
(statearr_65310[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65310[(1)] = (1));

return statearr_65310;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65298){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65298);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65311){var ex__2730__auto__ = e65311;
var statearr_65312_65323 = state_65298;
(statearr_65312_65323[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65298[(4)]))){
var statearr_65313_65324 = state_65298;
(statearr_65313_65324[(1)] = cljs.core.first((state_65298[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65325 = state_65298;
state_65298 = G__65325;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65298){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65314 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65314[(6)] = c__2749__auto__);

return statearr_65314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq65266){
var G__65267 = cljs.core.first(seq65266);
var seq65266__$1 = cljs.core.next(seq65266);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65267,seq65266__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65375 = arguments.length;
var i__5770__auto___65376 = (0);
while(true){
if((i__5770__auto___65376 < len__5769__auto___65375)){
args__5775__auto__.push((arguments[i__5770__auto___65376]));

var G__65377 = (i__5770__auto___65376 + (1));
i__5770__auto___65376 = G__65377;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65358){
var state_val_65359 = (state_65358[(1)]);
if((state_val_65359 === (1))){
var state_65358__$1 = state_65358;
var statearr_65360_65378 = state_65358__$1;
(statearr_65360_65378[(2)] = null);

(statearr_65360_65378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65359 === (2))){
var _ = (function (){var statearr_65361 = state_65358;
(statearr_65361[(4)] = cljs.core.cons((5),(state_65358[(4)])));

return statearr_65361;
})();
var inst_65334 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65358__$1 = state_65358;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65358__$1,(6),inst_65334);
} else {
if((state_val_65359 === (3))){
var inst_65356 = (state_65358[(2)]);
var state_65358__$1 = state_65358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65358__$1,inst_65356);
} else {
if((state_val_65359 === (4))){
var inst_65328 = (state_65358[(2)]);
var state_65358__$1 = state_65358;
var statearr_65363_65379 = state_65358__$1;
(statearr_65363_65379[(2)] = inst_65328);

(statearr_65363_65379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65359 === (5))){
var _ = (function (){var statearr_65364 = state_65358;
(statearr_65364[(4)] = cljs.core.rest((state_65358[(4)])));

return statearr_65364;
})();
var state_65358__$1 = state_65358;
var ex65362 = (state_65358__$1[(2)]);
var statearr_65365_65380 = state_65358__$1;
(statearr_65365_65380[(5)] = ex65362);


if((ex65362 instanceof Error)){
var statearr_65366_65381 = state_65358__$1;
(statearr_65366_65381[(1)] = (4));

(statearr_65366_65381[(5)] = null);

} else {
throw ex65362;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65359 === (6))){
var inst_65336 = (state_65358[(2)]);
var inst_65337 = fluree.db.util.async.throw_err(inst_65336);
var inst_65338 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_65337);
var inst_65339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65340 = [inst_65337];
var inst_65341 = (new cljs.core.PersistentVector(null,1,(5),inst_65339,inst_65340,null));
var inst_65342 = cljs.core.count(inst_65341);
var inst_65343 = ((9) + inst_65342);
var inst_65344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65345 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65347 = [inst_65337];
var inst_65348 = (new cljs.core.PersistentVector(null,1,(5),inst_65346,inst_65347,null));
var inst_65349 = [">",inst_65348,inst_65338];
var inst_65350 = cljs.core.PersistentHashMap.fromArrays(inst_65345,inst_65349);
var inst_65351 = [inst_65350,inst_65343];
var inst_65352 = (new cljs.core.PersistentVector(null,2,(5),inst_65344,inst_65351,null));
var inst_65353 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65352);
var _ = (function (){var statearr_65367 = state_65358;
(statearr_65367[(4)] = cljs.core.rest((state_65358[(4)])));

return statearr_65367;
})();
var state_65358__$1 = (function (){var statearr_65368 = state_65358;
(statearr_65368[(7)] = inst_65353);

return statearr_65368;
})();
var statearr_65369_65382 = state_65358__$1;
(statearr_65369_65382[(2)] = inst_65338);

(statearr_65369_65382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65370 = [null,null,null,null,null,null,null,null];
(statearr_65370[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65370[(1)] = (1));

return statearr_65370;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65358){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65358);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65371){var ex__2730__auto__ = e65371;
var statearr_65372_65383 = state_65358;
(statearr_65372_65383[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65358[(4)]))){
var statearr_65373_65384 = state_65358;
(statearr_65373_65384[(1)] = cljs.core.first((state_65358[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65385 = state_65358;
state_65358 = G__65385;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65358){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65374 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65374[(6)] = c__2749__auto__);

return statearr_65374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq65326){
var G__65327 = cljs.core.first(seq65326);
var seq65326__$1 = cljs.core.next(seq65326);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65327,seq65326__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65435 = arguments.length;
var i__5770__auto___65436 = (0);
while(true){
if((i__5770__auto___65436 < len__5769__auto___65435)){
args__5775__auto__.push((arguments[i__5770__auto___65436]));

var G__65437 = (i__5770__auto___65436 + (1));
i__5770__auto___65436 = G__65437;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65418){
var state_val_65419 = (state_65418[(1)]);
if((state_val_65419 === (1))){
var state_65418__$1 = state_65418;
var statearr_65420_65438 = state_65418__$1;
(statearr_65420_65438[(2)] = null);

(statearr_65420_65438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65419 === (2))){
var _ = (function (){var statearr_65421 = state_65418;
(statearr_65421[(4)] = cljs.core.cons((5),(state_65418[(4)])));

return statearr_65421;
})();
var inst_65394 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65418__$1 = state_65418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65418__$1,(6),inst_65394);
} else {
if((state_val_65419 === (3))){
var inst_65416 = (state_65418[(2)]);
var state_65418__$1 = state_65418;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65418__$1,inst_65416);
} else {
if((state_val_65419 === (4))){
var inst_65388 = (state_65418[(2)]);
var state_65418__$1 = state_65418;
var statearr_65423_65439 = state_65418__$1;
(statearr_65423_65439[(2)] = inst_65388);

(statearr_65423_65439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65419 === (5))){
var _ = (function (){var statearr_65424 = state_65418;
(statearr_65424[(4)] = cljs.core.rest((state_65418[(4)])));

return statearr_65424;
})();
var state_65418__$1 = state_65418;
var ex65422 = (state_65418__$1[(2)]);
var statearr_65425_65440 = state_65418__$1;
(statearr_65425_65440[(5)] = ex65422);


if((ex65422 instanceof Error)){
var statearr_65426_65441 = state_65418__$1;
(statearr_65426_65441[(1)] = (4));

(statearr_65426_65441[(5)] = null);

} else {
throw ex65422;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65419 === (6))){
var inst_65396 = (state_65418[(2)]);
var inst_65397 = fluree.db.util.async.throw_err(inst_65396);
var inst_65398 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_65397);
var inst_65399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65400 = [inst_65397];
var inst_65401 = (new cljs.core.PersistentVector(null,1,(5),inst_65399,inst_65400,null));
var inst_65402 = cljs.core.count(inst_65401);
var inst_65403 = ((9) + inst_65402);
var inst_65404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65405 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65407 = [inst_65397];
var inst_65408 = (new cljs.core.PersistentVector(null,1,(5),inst_65406,inst_65407,null));
var inst_65409 = ["<",inst_65408,inst_65398];
var inst_65410 = cljs.core.PersistentHashMap.fromArrays(inst_65405,inst_65409);
var inst_65411 = [inst_65410,inst_65403];
var inst_65412 = (new cljs.core.PersistentVector(null,2,(5),inst_65404,inst_65411,null));
var inst_65413 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65412);
var _ = (function (){var statearr_65427 = state_65418;
(statearr_65427[(4)] = cljs.core.rest((state_65418[(4)])));

return statearr_65427;
})();
var state_65418__$1 = (function (){var statearr_65428 = state_65418;
(statearr_65428[(7)] = inst_65413);

return statearr_65428;
})();
var statearr_65429_65442 = state_65418__$1;
(statearr_65429_65442[(2)] = inst_65398);

(statearr_65429_65442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65430 = [null,null,null,null,null,null,null,null];
(statearr_65430[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65430[(1)] = (1));

return statearr_65430;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65418){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65418);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65431){var ex__2730__auto__ = e65431;
var statearr_65432_65443 = state_65418;
(statearr_65432_65443[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65418[(4)]))){
var statearr_65433_65444 = state_65418;
(statearr_65433_65444[(1)] = cljs.core.first((state_65418[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65445 = state_65418;
state_65418 = G__65445;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65418){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65434 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65434[(6)] = c__2749__auto__);

return statearr_65434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq65386){
var G__65387 = cljs.core.first(seq65386);
var seq65386__$1 = cljs.core.next(seq65386);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65387,seq65386__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65495 = arguments.length;
var i__5770__auto___65496 = (0);
while(true){
if((i__5770__auto___65496 < len__5769__auto___65495)){
args__5775__auto__.push((arguments[i__5770__auto___65496]));

var G__65497 = (i__5770__auto___65496 + (1));
i__5770__auto___65496 = G__65497;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65478){
var state_val_65479 = (state_65478[(1)]);
if((state_val_65479 === (1))){
var state_65478__$1 = state_65478;
var statearr_65480_65498 = state_65478__$1;
(statearr_65480_65498[(2)] = null);

(statearr_65480_65498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65479 === (2))){
var _ = (function (){var statearr_65481 = state_65478;
(statearr_65481[(4)] = cljs.core.cons((5),(state_65478[(4)])));

return statearr_65481;
})();
var inst_65454 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65478__$1 = state_65478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65478__$1,(6),inst_65454);
} else {
if((state_val_65479 === (3))){
var inst_65476 = (state_65478[(2)]);
var state_65478__$1 = state_65478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65478__$1,inst_65476);
} else {
if((state_val_65479 === (4))){
var inst_65448 = (state_65478[(2)]);
var state_65478__$1 = state_65478;
var statearr_65483_65499 = state_65478__$1;
(statearr_65483_65499[(2)] = inst_65448);

(statearr_65483_65499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65479 === (5))){
var _ = (function (){var statearr_65484 = state_65478;
(statearr_65484[(4)] = cljs.core.rest((state_65478[(4)])));

return statearr_65484;
})();
var state_65478__$1 = state_65478;
var ex65482 = (state_65478__$1[(2)]);
var statearr_65485_65500 = state_65478__$1;
(statearr_65485_65500[(5)] = ex65482);


if((ex65482 instanceof Error)){
var statearr_65486_65501 = state_65478__$1;
(statearr_65486_65501[(1)] = (4));

(statearr_65486_65501[(5)] = null);

} else {
throw ex65482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65479 === (6))){
var inst_65456 = (state_65478[(2)]);
var inst_65457 = fluree.db.util.async.throw_err(inst_65456);
var inst_65458 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_65457);
var inst_65459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65460 = [inst_65457];
var inst_65461 = (new cljs.core.PersistentVector(null,1,(5),inst_65459,inst_65460,null));
var inst_65462 = cljs.core.count(inst_65461);
var inst_65463 = ((9) + inst_65462);
var inst_65464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65465 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65467 = [inst_65457];
var inst_65468 = (new cljs.core.PersistentVector(null,1,(5),inst_65466,inst_65467,null));
var inst_65469 = ["<=",inst_65468,inst_65458];
var inst_65470 = cljs.core.PersistentHashMap.fromArrays(inst_65465,inst_65469);
var inst_65471 = [inst_65470,inst_65463];
var inst_65472 = (new cljs.core.PersistentVector(null,2,(5),inst_65464,inst_65471,null));
var inst_65473 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65472);
var _ = (function (){var statearr_65487 = state_65478;
(statearr_65487[(4)] = cljs.core.rest((state_65478[(4)])));

return statearr_65487;
})();
var state_65478__$1 = (function (){var statearr_65488 = state_65478;
(statearr_65488[(7)] = inst_65473);

return statearr_65488;
})();
var statearr_65489_65502 = state_65478__$1;
(statearr_65489_65502[(2)] = inst_65458);

(statearr_65489_65502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65490 = [null,null,null,null,null,null,null,null];
(statearr_65490[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65490[(1)] = (1));

return statearr_65490;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65478){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65478);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65491){var ex__2730__auto__ = e65491;
var statearr_65492_65503 = state_65478;
(statearr_65492_65503[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65478[(4)]))){
var statearr_65493_65504 = state_65478;
(statearr_65493_65504[(1)] = cljs.core.first((state_65478[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65505 = state_65478;
state_65478 = G__65505;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65478){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65494 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65494[(6)] = c__2749__auto__);

return statearr_65494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq65446){
var G__65447 = cljs.core.first(seq65446);
var seq65446__$1 = cljs.core.next(seq65446);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65447,seq65446__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65555 = arguments.length;
var i__5770__auto___65556 = (0);
while(true){
if((i__5770__auto___65556 < len__5769__auto___65555)){
args__5775__auto__.push((arguments[i__5770__auto___65556]));

var G__65557 = (i__5770__auto___65556 + (1));
i__5770__auto___65556 = G__65557;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65538){
var state_val_65539 = (state_65538[(1)]);
if((state_val_65539 === (1))){
var state_65538__$1 = state_65538;
var statearr_65540_65558 = state_65538__$1;
(statearr_65540_65558[(2)] = null);

(statearr_65540_65558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (2))){
var _ = (function (){var statearr_65541 = state_65538;
(statearr_65541[(4)] = cljs.core.cons((5),(state_65538[(4)])));

return statearr_65541;
})();
var inst_65514 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65538__$1,(6),inst_65514);
} else {
if((state_val_65539 === (3))){
var inst_65536 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65538__$1,inst_65536);
} else {
if((state_val_65539 === (4))){
var inst_65508 = (state_65538[(2)]);
var state_65538__$1 = state_65538;
var statearr_65543_65559 = state_65538__$1;
(statearr_65543_65559[(2)] = inst_65508);

(statearr_65543_65559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (5))){
var _ = (function (){var statearr_65544 = state_65538;
(statearr_65544[(4)] = cljs.core.rest((state_65538[(4)])));

return statearr_65544;
})();
var state_65538__$1 = state_65538;
var ex65542 = (state_65538__$1[(2)]);
var statearr_65545_65560 = state_65538__$1;
(statearr_65545_65560[(5)] = ex65542);


if((ex65542 instanceof Error)){
var statearr_65546_65561 = state_65538__$1;
(statearr_65546_65561[(1)] = (4));

(statearr_65546_65561[(5)] = null);

} else {
throw ex65542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65539 === (6))){
var inst_65516 = (state_65538[(2)]);
var inst_65517 = fluree.db.util.async.throw_err(inst_65516);
var inst_65518 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_65517);
var inst_65519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65520 = [inst_65517];
var inst_65521 = (new cljs.core.PersistentVector(null,1,(5),inst_65519,inst_65520,null));
var inst_65522 = cljs.core.count(inst_65521);
var inst_65523 = ((9) + inst_65522);
var inst_65524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65525 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65527 = [inst_65517];
var inst_65528 = (new cljs.core.PersistentVector(null,1,(5),inst_65526,inst_65527,null));
var inst_65529 = [">=",inst_65528,inst_65518];
var inst_65530 = cljs.core.PersistentHashMap.fromArrays(inst_65525,inst_65529);
var inst_65531 = [inst_65530,inst_65523];
var inst_65532 = (new cljs.core.PersistentVector(null,2,(5),inst_65524,inst_65531,null));
var inst_65533 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65532);
var _ = (function (){var statearr_65547 = state_65538;
(statearr_65547[(4)] = cljs.core.rest((state_65538[(4)])));

return statearr_65547;
})();
var state_65538__$1 = (function (){var statearr_65548 = state_65538;
(statearr_65548[(7)] = inst_65533);

return statearr_65548;
})();
var statearr_65549_65562 = state_65538__$1;
(statearr_65549_65562[(2)] = inst_65518);

(statearr_65549_65562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65550 = [null,null,null,null,null,null,null,null];
(statearr_65550[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65550[(1)] = (1));

return statearr_65550;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65538){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65538);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65551){var ex__2730__auto__ = e65551;
var statearr_65552_65563 = state_65538;
(statearr_65552_65563[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65538[(4)]))){
var statearr_65553_65564 = state_65538;
(statearr_65553_65564[(1)] = cljs.core.first((state_65538[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65565 = state_65538;
state_65538 = G__65565;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65538){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65554 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65554[(6)] = c__2749__auto__);

return statearr_65554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq65506){
var G__65507 = cljs.core.first(seq65506);
var seq65506__$1 = cljs.core.next(seq65506);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65507,seq65506__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65615 = arguments.length;
var i__5770__auto___65616 = (0);
while(true){
if((i__5770__auto___65616 < len__5769__auto___65615)){
args__5775__auto__.push((arguments[i__5770__auto___65616]));

var G__65617 = (i__5770__auto___65616 + (1));
i__5770__auto___65616 = G__65617;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65598){
var state_val_65599 = (state_65598[(1)]);
if((state_val_65599 === (1))){
var state_65598__$1 = state_65598;
var statearr_65600_65618 = state_65598__$1;
(statearr_65600_65618[(2)] = null);

(statearr_65600_65618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65599 === (2))){
var _ = (function (){var statearr_65601 = state_65598;
(statearr_65601[(4)] = cljs.core.cons((5),(state_65598[(4)])));

return statearr_65601;
})();
var inst_65574 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65598__$1 = state_65598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65598__$1,(6),inst_65574);
} else {
if((state_val_65599 === (3))){
var inst_65596 = (state_65598[(2)]);
var state_65598__$1 = state_65598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65598__$1,inst_65596);
} else {
if((state_val_65599 === (4))){
var inst_65568 = (state_65598[(2)]);
var state_65598__$1 = state_65598;
var statearr_65603_65619 = state_65598__$1;
(statearr_65603_65619[(2)] = inst_65568);

(statearr_65603_65619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65599 === (5))){
var _ = (function (){var statearr_65604 = state_65598;
(statearr_65604[(4)] = cljs.core.rest((state_65598[(4)])));

return statearr_65604;
})();
var state_65598__$1 = state_65598;
var ex65602 = (state_65598__$1[(2)]);
var statearr_65605_65620 = state_65598__$1;
(statearr_65605_65620[(5)] = ex65602);


if((ex65602 instanceof Error)){
var statearr_65606_65621 = state_65598__$1;
(statearr_65606_65621[(1)] = (4));

(statearr_65606_65621[(5)] = null);

} else {
throw ex65602;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65599 === (6))){
var inst_65576 = (state_65598[(2)]);
var inst_65577 = fluree.db.util.async.throw_err(inst_65576);
var inst_65578 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_65577);
var inst_65579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65580 = [inst_65577];
var inst_65581 = (new cljs.core.PersistentVector(null,1,(5),inst_65579,inst_65580,null));
var inst_65582 = cljs.core.count(inst_65581);
var inst_65583 = ((9) + inst_65582);
var inst_65584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65585 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65587 = [inst_65577];
var inst_65588 = (new cljs.core.PersistentVector(null,1,(5),inst_65586,inst_65587,null));
var inst_65589 = ["not=",inst_65588,inst_65578];
var inst_65590 = cljs.core.PersistentHashMap.fromArrays(inst_65585,inst_65589);
var inst_65591 = [inst_65590,inst_65583];
var inst_65592 = (new cljs.core.PersistentVector(null,2,(5),inst_65584,inst_65591,null));
var inst_65593 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65592);
var _ = (function (){var statearr_65607 = state_65598;
(statearr_65607[(4)] = cljs.core.rest((state_65598[(4)])));

return statearr_65607;
})();
var state_65598__$1 = (function (){var statearr_65608 = state_65598;
(statearr_65608[(7)] = inst_65593);

return statearr_65608;
})();
var statearr_65609_65622 = state_65598__$1;
(statearr_65609_65622[(2)] = inst_65578);

(statearr_65609_65622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65610 = [null,null,null,null,null,null,null,null];
(statearr_65610[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65610[(1)] = (1));

return statearr_65610;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65598){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65598);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65611){var ex__2730__auto__ = e65611;
var statearr_65612_65623 = state_65598;
(statearr_65612_65623[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65598[(4)]))){
var statearr_65613_65624 = state_65598;
(statearr_65613_65624[(1)] = cljs.core.first((state_65598[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65625 = state_65598;
state_65598 = G__65625;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65598){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65614 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65614[(6)] = c__2749__auto__);

return statearr_65614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq65566){
var G__65567 = cljs.core.first(seq65566);
var seq65566__$1 = cljs.core.next(seq65566);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65567,seq65566__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65675 = arguments.length;
var i__5770__auto___65676 = (0);
while(true){
if((i__5770__auto___65676 < len__5769__auto___65675)){
args__5775__auto__.push((arguments[i__5770__auto___65676]));

var G__65677 = (i__5770__auto___65676 + (1));
i__5770__auto___65676 = G__65677;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65658){
var state_val_65659 = (state_65658[(1)]);
if((state_val_65659 === (1))){
var state_65658__$1 = state_65658;
var statearr_65660_65678 = state_65658__$1;
(statearr_65660_65678[(2)] = null);

(statearr_65660_65678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65659 === (2))){
var _ = (function (){var statearr_65661 = state_65658;
(statearr_65661[(4)] = cljs.core.cons((5),(state_65658[(4)])));

return statearr_65661;
})();
var inst_65634 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65658__$1 = state_65658;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65658__$1,(6),inst_65634);
} else {
if((state_val_65659 === (3))){
var inst_65656 = (state_65658[(2)]);
var state_65658__$1 = state_65658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65658__$1,inst_65656);
} else {
if((state_val_65659 === (4))){
var inst_65628 = (state_65658[(2)]);
var state_65658__$1 = state_65658;
var statearr_65663_65679 = state_65658__$1;
(statearr_65663_65679[(2)] = inst_65628);

(statearr_65663_65679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65659 === (5))){
var _ = (function (){var statearr_65664 = state_65658;
(statearr_65664[(4)] = cljs.core.rest((state_65658[(4)])));

return statearr_65664;
})();
var state_65658__$1 = state_65658;
var ex65662 = (state_65658__$1[(2)]);
var statearr_65665_65680 = state_65658__$1;
(statearr_65665_65680[(5)] = ex65662);


if((ex65662 instanceof Error)){
var statearr_65666_65681 = state_65658__$1;
(statearr_65666_65681[(1)] = (4));

(statearr_65666_65681[(5)] = null);

} else {
throw ex65662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65659 === (6))){
var inst_65636 = (state_65658[(2)]);
var inst_65637 = fluree.db.util.async.throw_err(inst_65636);
var inst_65638 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_65637);
var inst_65639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65640 = [inst_65637];
var inst_65641 = (new cljs.core.PersistentVector(null,1,(5),inst_65639,inst_65640,null));
var inst_65642 = cljs.core.count(inst_65641);
var inst_65643 = ((9) + inst_65642);
var inst_65644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65645 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65647 = [inst_65637];
var inst_65648 = (new cljs.core.PersistentVector(null,1,(5),inst_65646,inst_65647,null));
var inst_65649 = ["max",inst_65648,inst_65638];
var inst_65650 = cljs.core.PersistentHashMap.fromArrays(inst_65645,inst_65649);
var inst_65651 = [inst_65650,inst_65643];
var inst_65652 = (new cljs.core.PersistentVector(null,2,(5),inst_65644,inst_65651,null));
var inst_65653 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65652);
var _ = (function (){var statearr_65667 = state_65658;
(statearr_65667[(4)] = cljs.core.rest((state_65658[(4)])));

return statearr_65667;
})();
var state_65658__$1 = (function (){var statearr_65668 = state_65658;
(statearr_65668[(7)] = inst_65653);

return statearr_65668;
})();
var statearr_65669_65682 = state_65658__$1;
(statearr_65669_65682[(2)] = inst_65638);

(statearr_65669_65682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65670 = [null,null,null,null,null,null,null,null];
(statearr_65670[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65670[(1)] = (1));

return statearr_65670;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65658){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65658);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65671){var ex__2730__auto__ = e65671;
var statearr_65672_65683 = state_65658;
(statearr_65672_65683[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65658[(4)]))){
var statearr_65673_65684 = state_65658;
(statearr_65673_65684[(1)] = cljs.core.first((state_65658[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65685 = state_65658;
state_65658 = G__65685;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65658){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65674 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65674[(6)] = c__2749__auto__);

return statearr_65674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq65626){
var G__65627 = cljs.core.first(seq65626);
var seq65626__$1 = cljs.core.next(seq65626);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65627,seq65626__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65735 = arguments.length;
var i__5770__auto___65736 = (0);
while(true){
if((i__5770__auto___65736 < len__5769__auto___65735)){
args__5775__auto__.push((arguments[i__5770__auto___65736]));

var G__65737 = (i__5770__auto___65736 + (1));
i__5770__auto___65736 = G__65737;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65718){
var state_val_65719 = (state_65718[(1)]);
if((state_val_65719 === (1))){
var state_65718__$1 = state_65718;
var statearr_65720_65738 = state_65718__$1;
(statearr_65720_65738[(2)] = null);

(statearr_65720_65738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65719 === (2))){
var _ = (function (){var statearr_65721 = state_65718;
(statearr_65721[(4)] = cljs.core.cons((5),(state_65718[(4)])));

return statearr_65721;
})();
var inst_65694 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65718__$1 = state_65718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65718__$1,(6),inst_65694);
} else {
if((state_val_65719 === (3))){
var inst_65716 = (state_65718[(2)]);
var state_65718__$1 = state_65718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65718__$1,inst_65716);
} else {
if((state_val_65719 === (4))){
var inst_65688 = (state_65718[(2)]);
var state_65718__$1 = state_65718;
var statearr_65723_65739 = state_65718__$1;
(statearr_65723_65739[(2)] = inst_65688);

(statearr_65723_65739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65719 === (5))){
var _ = (function (){var statearr_65724 = state_65718;
(statearr_65724[(4)] = cljs.core.rest((state_65718[(4)])));

return statearr_65724;
})();
var state_65718__$1 = state_65718;
var ex65722 = (state_65718__$1[(2)]);
var statearr_65725_65740 = state_65718__$1;
(statearr_65725_65740[(5)] = ex65722);


if((ex65722 instanceof Error)){
var statearr_65726_65741 = state_65718__$1;
(statearr_65726_65741[(1)] = (4));

(statearr_65726_65741[(5)] = null);

} else {
throw ex65722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65719 === (6))){
var inst_65696 = (state_65718[(2)]);
var inst_65697 = fluree.db.util.async.throw_err(inst_65696);
var inst_65698 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_65697);
var inst_65699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65700 = [inst_65697];
var inst_65701 = (new cljs.core.PersistentVector(null,1,(5),inst_65699,inst_65700,null));
var inst_65702 = cljs.core.count(inst_65701);
var inst_65703 = ((9) + inst_65702);
var inst_65704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65705 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65707 = [inst_65697];
var inst_65708 = (new cljs.core.PersistentVector(null,1,(5),inst_65706,inst_65707,null));
var inst_65709 = ["min",inst_65708,inst_65698];
var inst_65710 = cljs.core.PersistentHashMap.fromArrays(inst_65705,inst_65709);
var inst_65711 = [inst_65710,inst_65703];
var inst_65712 = (new cljs.core.PersistentVector(null,2,(5),inst_65704,inst_65711,null));
var inst_65713 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65712);
var _ = (function (){var statearr_65727 = state_65718;
(statearr_65727[(4)] = cljs.core.rest((state_65718[(4)])));

return statearr_65727;
})();
var state_65718__$1 = (function (){var statearr_65728 = state_65718;
(statearr_65728[(7)] = inst_65713);

return statearr_65728;
})();
var statearr_65729_65742 = state_65718__$1;
(statearr_65729_65742[(2)] = inst_65698);

(statearr_65729_65742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65730 = [null,null,null,null,null,null,null,null];
(statearr_65730[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65730[(1)] = (1));

return statearr_65730;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65718){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65718);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65731){var ex__2730__auto__ = e65731;
var statearr_65732_65743 = state_65718;
(statearr_65732_65743[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65718[(4)]))){
var statearr_65733_65744 = state_65718;
(statearr_65733_65744[(1)] = cljs.core.first((state_65718[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65745 = state_65718;
state_65718 = G__65745;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65718){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65734 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65734[(6)] = c__2749__auto__);

return statearr_65734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq65686){
var G__65687 = cljs.core.first(seq65686);
var seq65686__$1 = cljs.core.next(seq65686);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65687,seq65686__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__65747 = arguments.length;
switch (G__65747) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65792){
var state_val_65793 = (state_65792[(1)]);
if((state_val_65793 === (7))){
var state_65792__$1 = state_65792;
var statearr_65794_65931 = state_65792__$1;
(statearr_65794_65931[(2)] = query_map);

(statearr_65794_65931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (1))){
var state_65792__$1 = state_65792;
var statearr_65795_65932 = state_65792__$1;
(statearr_65795_65932[(2)] = null);

(statearr_65795_65932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (4))){
var inst_65748 = (state_65792[(2)]);
var state_65792__$1 = state_65792;
var statearr_65796_65933 = state_65792__$1;
(statearr_65796_65933[(2)] = inst_65748);

(statearr_65796_65933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (13))){
var inst_65770 = (state_65792[(7)]);
var inst_65774 = (state_65792[(2)]);
var inst_65775 = fluree.db.util.async.throw_err(inst_65774);
var inst_65776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65775,(0),null);
var inst_65777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65775,(1),null);
var inst_65778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65779 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65781 = [inst_65770];
var inst_65782 = (new cljs.core.PersistentVector(null,1,(5),inst_65780,inst_65781,null));
var inst_65783 = ["query",inst_65782,inst_65776];
var inst_65784 = cljs.core.PersistentHashMap.fromArrays(inst_65779,inst_65783);
var inst_65785 = [inst_65784,inst_65777];
var inst_65786 = (new cljs.core.PersistentVector(null,2,(5),inst_65778,inst_65785,null));
var inst_65787 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65786);
var _ = (function (){var statearr_65797 = state_65792;
(statearr_65797[(4)] = cljs.core.rest((state_65792[(4)])));

return statearr_65797;
})();
var state_65792__$1 = (function (){var statearr_65798 = state_65792;
(statearr_65798[(8)] = inst_65787);

return statearr_65798;
})();
var statearr_65799_65934 = state_65792__$1;
(statearr_65799_65934[(2)] = inst_65776);

(statearr_65799_65934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (6))){
var state_65792__$1 = state_65792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65792__$1,(9),query_map);
} else {
if((state_val_65793 === (3))){
var inst_65790 = (state_65792[(2)]);
var state_65792__$1 = state_65792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65792__$1,inst_65790);
} else {
if((state_val_65793 === (12))){
var inst_65770 = (state_65792[(7)]);
var inst_65770__$1 = (state_65792[(2)]);
var inst_65771 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65772 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_65771,inst_65770__$1);
var state_65792__$1 = (function (){var statearr_65800 = state_65792;
(statearr_65800[(7)] = inst_65770__$1);

return statearr_65800;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65792__$1,(13),inst_65772);
} else {
if((state_val_65793 === (2))){
var _ = (function (){var statearr_65801 = state_65792;
(statearr_65801[(4)] = cljs.core.cons((5),(state_65792[(4)])));

return statearr_65801;
})();
var inst_65757 = fluree.db.util.async.channel_QMARK_(query_map);
var state_65792__$1 = state_65792;
if(inst_65757){
var statearr_65802_65935 = state_65792__$1;
(statearr_65802_65935[(1)] = (6));

} else {
var statearr_65803_65936 = state_65792__$1;
(statearr_65803_65936[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (11))){
var inst_65764 = (state_65792[(9)]);
var state_65792__$1 = state_65792;
var statearr_65805_65937 = state_65792__$1;
(statearr_65805_65937[(2)] = inst_65764);

(statearr_65805_65937[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (9))){
var inst_65760 = (state_65792[(2)]);
var inst_65761 = fluree.db.util.async.throw_err(inst_65760);
var state_65792__$1 = state_65792;
var statearr_65806_65938 = state_65792__$1;
(statearr_65806_65938[(2)] = inst_65761);

(statearr_65806_65938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (5))){
var _ = (function (){var statearr_65807 = state_65792;
(statearr_65807[(4)] = cljs.core.rest((state_65792[(4)])));

return statearr_65807;
})();
var state_65792__$1 = state_65792;
var ex65804 = (state_65792__$1[(2)]);
var statearr_65808_65939 = state_65792__$1;
(statearr_65808_65939[(5)] = ex65804);


if((ex65804 instanceof Error)){
var statearr_65809_65940 = state_65792__$1;
(statearr_65809_65940[(1)] = (4));

(statearr_65809_65940[(5)] = null);

} else {
throw ex65804;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (10))){
var inst_65764 = (state_65792[(9)]);
var inst_65767 = fluree.db.util.json.parse(inst_65764);
var state_65792__$1 = state_65792;
var statearr_65810_65941 = state_65792__$1;
(statearr_65810_65941[(2)] = inst_65767);

(statearr_65810_65941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65793 === (8))){
var inst_65764 = (state_65792[(9)]);
var inst_65764__$1 = (state_65792[(2)]);
var inst_65765 = typeof inst_65764__$1 === 'string';
var state_65792__$1 = (function (){var statearr_65811 = state_65792;
(statearr_65811[(9)] = inst_65764__$1);

return statearr_65811;
})();
if(cljs.core.truth_(inst_65765)){
var statearr_65812_65942 = state_65792__$1;
(statearr_65812_65942[(1)] = (10));

} else {
var statearr_65813_65943 = state_65792__$1;
(statearr_65813_65943[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65814 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65814[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65814[(1)] = (1));

return statearr_65814;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65792){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65792);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65815){var ex__2730__auto__ = e65815;
var statearr_65816_65944 = state_65792;
(statearr_65816_65944[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65792[(4)]))){
var statearr_65817_65945 = state_65792;
(statearr_65817_65945[(1)] = cljs.core.first((state_65792[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65946 = state_65792;
state_65792 = G__65946;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65818 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65818[(6)] = c__2749__auto__);

return statearr_65818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65889){
var state_val_65890 = (state_65889[(1)]);
if((state_val_65890 === (7))){
var state_65889__$1 = state_65889;
var statearr_65891_65947 = state_65889__$1;
(statearr_65891_65947[(2)] = select);

(statearr_65891_65947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (20))){
var inst_65859 = (state_65889[(2)]);
var inst_65860 = fluree.db.util.async.channel_QMARK_(limit);
var state_65889__$1 = (function (){var statearr_65892 = state_65889;
(statearr_65892[(7)] = inst_65859);

return statearr_65892;
})();
if(inst_65860){
var statearr_65893_65948 = state_65889__$1;
(statearr_65893_65948[(1)] = (22));

} else {
var statearr_65894_65949 = state_65889__$1;
(statearr_65894_65949[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (1))){
var state_65889__$1 = state_65889;
var statearr_65895_65950 = state_65889__$1;
(statearr_65895_65950[(2)] = null);

(statearr_65895_65950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (24))){
var inst_65843 = (state_65889[(8)]);
var inst_65835 = (state_65889[(9)]);
var inst_65851 = (state_65889[(10)]);
var inst_65859 = (state_65889[(7)]);
var inst_65867 = (state_65889[(2)]);
var inst_65868 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65869 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_65868,inst_65835,inst_65843,inst_65851,inst_65859,inst_65867);
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65889__$1,(26),inst_65869);
} else {
if((state_val_65890 === (4))){
var inst_65819 = (state_65889[(2)]);
var state_65889__$1 = state_65889;
var statearr_65896_65951 = state_65889__$1;
(statearr_65896_65951[(2)] = inst_65819);

(statearr_65896_65951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (15))){
var state_65889__$1 = state_65889;
var statearr_65897_65952 = state_65889__$1;
(statearr_65897_65952[(2)] = where);

(statearr_65897_65952[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (21))){
var inst_65855 = (state_65889[(2)]);
var inst_65856 = fluree.db.util.async.throw_err(inst_65855);
var state_65889__$1 = state_65889;
var statearr_65898_65953 = state_65889__$1;
(statearr_65898_65953[(2)] = inst_65856);

(statearr_65898_65953[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (13))){
var inst_65839 = (state_65889[(2)]);
var inst_65840 = fluree.db.util.async.throw_err(inst_65839);
var state_65889__$1 = state_65889;
var statearr_65899_65954 = state_65889__$1;
(statearr_65899_65954[(2)] = inst_65840);

(statearr_65899_65954[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (22))){
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65889__$1,(25),limit);
} else {
if((state_val_65890 === (6))){
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65889__$1,(9),select);
} else {
if((state_val_65890 === (25))){
var inst_65863 = (state_65889[(2)]);
var inst_65864 = fluree.db.util.async.throw_err(inst_65863);
var state_65889__$1 = state_65889;
var statearr_65900_65955 = state_65889__$1;
(statearr_65900_65955[(2)] = inst_65864);

(statearr_65900_65955[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (17))){
var inst_65847 = (state_65889[(2)]);
var inst_65848 = fluree.db.util.async.throw_err(inst_65847);
var state_65889__$1 = state_65889;
var statearr_65901_65956 = state_65889__$1;
(statearr_65901_65956[(2)] = inst_65848);

(statearr_65901_65956[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (3))){
var inst_65887 = (state_65889[(2)]);
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65889__$1,inst_65887);
} else {
if((state_val_65890 === (12))){
var inst_65843 = (state_65889[(2)]);
var inst_65844 = fluree.db.util.async.channel_QMARK_(where);
var state_65889__$1 = (function (){var statearr_65902 = state_65889;
(statearr_65902[(8)] = inst_65843);

return statearr_65902;
})();
if(inst_65844){
var statearr_65903_65957 = state_65889__$1;
(statearr_65903_65957[(1)] = (14));

} else {
var statearr_65904_65958 = state_65889__$1;
(statearr_65904_65958[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (2))){
var _ = (function (){var statearr_65905 = state_65889;
(statearr_65905[(4)] = cljs.core.cons((5),(state_65889[(4)])));

return statearr_65905;
})();
var inst_65828 = fluree.db.util.async.channel_QMARK_(select);
var state_65889__$1 = state_65889;
if(inst_65828){
var statearr_65906_65959 = state_65889__$1;
(statearr_65906_65959[(1)] = (6));

} else {
var statearr_65907_65960 = state_65889__$1;
(statearr_65907_65960[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (23))){
var state_65889__$1 = state_65889;
var statearr_65908_65961 = state_65889__$1;
(statearr_65908_65961[(2)] = limit);

(statearr_65908_65961[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (19))){
var state_65889__$1 = state_65889;
var statearr_65909_65962 = state_65889__$1;
(statearr_65909_65962[(2)] = block);

(statearr_65909_65962[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (11))){
var state_65889__$1 = state_65889;
var statearr_65911_65963 = state_65889__$1;
(statearr_65911_65963[(2)] = from);

(statearr_65911_65963[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (9))){
var inst_65831 = (state_65889[(2)]);
var inst_65832 = fluree.db.util.async.throw_err(inst_65831);
var state_65889__$1 = state_65889;
var statearr_65912_65964 = state_65889__$1;
(statearr_65912_65964[(2)] = inst_65832);

(statearr_65912_65964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (5))){
var _ = (function (){var statearr_65913 = state_65889;
(statearr_65913[(4)] = cljs.core.rest((state_65889[(4)])));

return statearr_65913;
})();
var state_65889__$1 = state_65889;
var ex65910 = (state_65889__$1[(2)]);
var statearr_65914_65965 = state_65889__$1;
(statearr_65914_65965[(5)] = ex65910);


if((ex65910 instanceof Error)){
var statearr_65915_65966 = state_65889__$1;
(statearr_65915_65966[(1)] = (4));

(statearr_65915_65966[(5)] = null);

} else {
throw ex65910;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (14))){
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65889__$1,(17),where);
} else {
if((state_val_65890 === (26))){
var inst_65843 = (state_65889[(8)]);
var inst_65835 = (state_65889[(9)]);
var inst_65851 = (state_65889[(10)]);
var inst_65859 = (state_65889[(7)]);
var inst_65871 = (state_65889[(2)]);
var inst_65872 = fluree.db.util.async.throw_err(inst_65871);
var inst_65873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65872,(0),null);
var inst_65874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65872,(1),null);
var inst_65875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65876 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65878 = [inst_65835,inst_65843,inst_65851,inst_65859];
var inst_65879 = (new cljs.core.PersistentVector(null,4,(5),inst_65877,inst_65878,null));
var inst_65880 = ["query",inst_65879,inst_65873];
var inst_65881 = cljs.core.PersistentHashMap.fromArrays(inst_65876,inst_65880);
var inst_65882 = [inst_65881,inst_65874];
var inst_65883 = (new cljs.core.PersistentVector(null,2,(5),inst_65875,inst_65882,null));
var inst_65884 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65883);
var _ = (function (){var statearr_65916 = state_65889;
(statearr_65916[(4)] = cljs.core.rest((state_65889[(4)])));

return statearr_65916;
})();
var state_65889__$1 = (function (){var statearr_65917 = state_65889;
(statearr_65917[(11)] = inst_65884);

return statearr_65917;
})();
var statearr_65918_65967 = state_65889__$1;
(statearr_65918_65967[(2)] = inst_65873);

(statearr_65918_65967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (16))){
var inst_65851 = (state_65889[(2)]);
var inst_65852 = fluree.db.util.async.channel_QMARK_(block);
var state_65889__$1 = (function (){var statearr_65919 = state_65889;
(statearr_65919[(10)] = inst_65851);

return statearr_65919;
})();
if(inst_65852){
var statearr_65920_65968 = state_65889__$1;
(statearr_65920_65968[(1)] = (18));

} else {
var statearr_65921_65969 = state_65889__$1;
(statearr_65921_65969[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (10))){
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65889__$1,(13),from);
} else {
if((state_val_65890 === (18))){
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65889__$1,(21),block);
} else {
if((state_val_65890 === (8))){
var inst_65835 = (state_65889[(2)]);
var inst_65836 = fluree.db.util.async.channel_QMARK_(from);
var state_65889__$1 = (function (){var statearr_65922 = state_65889;
(statearr_65922[(9)] = inst_65835);

return statearr_65922;
})();
if(inst_65836){
var statearr_65923_65970 = state_65889__$1;
(statearr_65923_65970[(1)] = (10));

} else {
var statearr_65924_65971 = state_65889__$1;
(statearr_65924_65971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_65925 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65925[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_65925[(1)] = (1));

return statearr_65925;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_65889){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65889);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65926){var ex__2730__auto__ = e65926;
var statearr_65927_65972 = state_65889;
(statearr_65927_65972[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65889[(4)]))){
var statearr_65928_65973 = state_65889;
(statearr_65928_65973[(1)] = cljs.core.first((state_65889[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65974 = state_65889;
state_65889 = G__65974;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_65889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_65889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65929 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65929[(6)] = c__2749__auto__);

return statearr_65929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66030){
var state_val_66031 = (state_66030[(1)]);
if((state_val_66031 === (7))){
var state_66030__$1 = state_66030;
var statearr_66032_66063 = state_66030__$1;
(statearr_66032_66063[(2)] = startSubject);

(statearr_66032_66063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (1))){
var state_66030__$1 = state_66030;
var statearr_66033_66064 = state_66030__$1;
(statearr_66033_66064[(2)] = null);

(statearr_66033_66064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (4))){
var inst_65975 = (state_66030[(2)]);
var state_66030__$1 = state_66030;
var statearr_66034_66065 = state_66030__$1;
(statearr_66034_66065[(2)] = inst_65975);

(statearr_66034_66065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (15))){
var inst_66007 = (state_66030[(2)]);
var inst_66008 = fluree.db.util.async.throw_err(inst_66007);
var inst_66009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66008,(0),null);
var inst_66010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66008,(1),null);
var inst_66011 = cljs.core.empty_QMARK_(inst_66009);
var state_66030__$1 = (function (){var statearr_66035 = state_66030;
(statearr_66035[(7)] = inst_66010);

return statearr_66035;
})();
if(inst_66011){
var statearr_66036_66066 = state_66030__$1;
(statearr_66036_66066[(1)] = (16));

} else {
var statearr_66037_66067 = state_66030__$1;
(statearr_66037_66067[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (13))){
var inst_65991 = (state_66030[(8)]);
var inst_66003 = (state_66030[(9)]);
var inst_65995 = (state_66030[(10)]);
var inst_66003__$1 = (state_66030[(2)]);
var inst_66004 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66005 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_66004,inst_65991,inst_65995,inst_66003__$1);
var state_66030__$1 = (function (){var statearr_66038 = state_66030;
(statearr_66038[(9)] = inst_66003__$1);

return statearr_66038;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66030__$1,(15),inst_66005);
} else {
if((state_val_66031 === (6))){
var state_66030__$1 = state_66030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66030__$1,(9),startSubject);
} else {
if((state_val_66031 === (17))){
var state_66030__$1 = state_66030;
var statearr_66039_66068 = state_66030__$1;
(statearr_66039_66068[(2)] = true);

(statearr_66039_66068[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (3))){
var inst_66028 = (state_66030[(2)]);
var state_66030__$1 = state_66030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66030__$1,inst_66028);
} else {
if((state_val_66031 === (12))){
var state_66030__$1 = state_66030;
var statearr_66040_66069 = state_66030__$1;
(statearr_66040_66069[(2)] = endSubject);

(statearr_66040_66069[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (2))){
var _ = (function (){var statearr_66041 = state_66030;
(statearr_66041[(4)] = cljs.core.cons((5),(state_66030[(4)])));

return statearr_66041;
})();
var inst_65984 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_66030__$1 = state_66030;
if(inst_65984){
var statearr_66042_66070 = state_66030__$1;
(statearr_66042_66070[(1)] = (6));

} else {
var statearr_66043_66071 = state_66030__$1;
(statearr_66043_66071[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (11))){
var state_66030__$1 = state_66030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66030__$1,(14),endSubject);
} else {
if((state_val_66031 === (9))){
var inst_65987 = (state_66030[(2)]);
var inst_65988 = fluree.db.util.async.throw_err(inst_65987);
var state_66030__$1 = state_66030;
var statearr_66045_66072 = state_66030__$1;
(statearr_66045_66072[(2)] = inst_65988);

(statearr_66045_66072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (5))){
var _ = (function (){var statearr_66046 = state_66030;
(statearr_66046[(4)] = cljs.core.rest((state_66030[(4)])));

return statearr_66046;
})();
var state_66030__$1 = state_66030;
var ex66044 = (state_66030__$1[(2)]);
var statearr_66047_66073 = state_66030__$1;
(statearr_66047_66073[(5)] = ex66044);


if((ex66044 instanceof Error)){
var statearr_66048_66074 = state_66030__$1;
(statearr_66048_66074[(1)] = (4));

(statearr_66048_66074[(5)] = null);

} else {
throw ex66044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (14))){
var inst_65999 = (state_66030[(2)]);
var inst_66000 = fluree.db.util.async.throw_err(inst_65999);
var state_66030__$1 = state_66030;
var statearr_66049_66075 = state_66030__$1;
(statearr_66049_66075[(2)] = inst_66000);

(statearr_66049_66075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (16))){
var state_66030__$1 = state_66030;
var statearr_66050_66076 = state_66030__$1;
(statearr_66050_66076[(2)] = false);

(statearr_66050_66076[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (10))){
var inst_65994 = (state_66030[(2)]);
var inst_65995 = fluree.db.util.async.throw_err(inst_65994);
var inst_65996 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_66030__$1 = (function (){var statearr_66051 = state_66030;
(statearr_66051[(10)] = inst_65995);

return statearr_66051;
})();
if(inst_65996){
var statearr_66052_66077 = state_66030__$1;
(statearr_66052_66077[(1)] = (11));

} else {
var statearr_66053_66078 = state_66030__$1;
(statearr_66053_66078[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (18))){
var inst_65991 = (state_66030[(8)]);
var inst_66003 = (state_66030[(9)]);
var inst_66010 = (state_66030[(7)]);
var inst_65995 = (state_66030[(10)]);
var inst_66015 = (state_66030[(2)]);
var inst_66016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66017 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66019 = [inst_65991,inst_65995,inst_66003];
var inst_66020 = (new cljs.core.PersistentVector(null,3,(5),inst_66018,inst_66019,null));
var inst_66021 = ["relationship?",inst_66020,inst_66015];
var inst_66022 = cljs.core.PersistentHashMap.fromArrays(inst_66017,inst_66021);
var inst_66023 = [inst_66022,inst_66010];
var inst_66024 = (new cljs.core.PersistentVector(null,2,(5),inst_66016,inst_66023,null));
var inst_66025 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66024);
var _ = (function (){var statearr_66054 = state_66030;
(statearr_66054[(4)] = cljs.core.rest((state_66030[(4)])));

return statearr_66054;
})();
var state_66030__$1 = (function (){var statearr_66055 = state_66030;
(statearr_66055[(11)] = inst_66025);

return statearr_66055;
})();
var statearr_66056_66079 = state_66030__$1;
(statearr_66056_66079[(2)] = inst_66015);

(statearr_66056_66079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66031 === (8))){
var inst_65991 = (state_66030[(2)]);
var inst_65992 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_66030__$1 = (function (){var statearr_66057 = state_66030;
(statearr_66057[(8)] = inst_65991);

return statearr_66057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66030__$1,(10),inst_65992);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_66058 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66058[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_66058[(1)] = (1));

return statearr_66058;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_66030){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66030);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66059){var ex__2730__auto__ = e66059;
var statearr_66060_66080 = state_66030;
(statearr_66060_66080[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66030[(4)]))){
var statearr_66061_66081 = state_66030;
(statearr_66061_66081[(1)] = cljs.core.first((state_66030[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66082 = state_66030;
state_66030 = G__66082;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_66030){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_66030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66062 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66062[(6)] = c__2749__auto__);

return statearr_66062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66119){
var state_val_66120 = (state_66119[(1)]);
if((state_val_66120 === (7))){
var state_66119__$1 = state_66119;
var statearr_66121_66141 = state_66119__$1;
(statearr_66121_66141[(2)] = pred_name);

(statearr_66121_66141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (1))){
var state_66119__$1 = state_66119;
var statearr_66122_66142 = state_66119__$1;
(statearr_66122_66142[(2)] = null);

(statearr_66122_66142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (4))){
var inst_66083 = (state_66119[(2)]);
var state_66119__$1 = state_66119;
var statearr_66123_66143 = state_66119__$1;
(statearr_66123_66143[(2)] = inst_66083);

(statearr_66123_66143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (6))){
var state_66119__$1 = state_66119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66119__$1,(9),pred_name);
} else {
if((state_val_66120 === (3))){
var inst_66117 = (state_66119[(2)]);
var state_66119__$1 = state_66119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66119__$1,inst_66117);
} else {
if((state_val_66120 === (2))){
var _ = (function (){var statearr_66125 = state_66119;
(statearr_66125[(4)] = cljs.core.cons((5),(state_66119[(4)])));

return statearr_66125;
})();
var inst_66092 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_66119__$1 = state_66119;
if(inst_66092){
var statearr_66126_66144 = state_66119__$1;
(statearr_66126_66144[(1)] = (6));

} else {
var statearr_66127_66145 = state_66119__$1;
(statearr_66127_66145[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (9))){
var inst_66095 = (state_66119[(2)]);
var inst_66096 = fluree.db.util.async.throw_err(inst_66095);
var state_66119__$1 = state_66119;
var statearr_66128_66146 = state_66119__$1;
(statearr_66128_66146[(2)] = inst_66096);

(statearr_66128_66146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (5))){
var _ = (function (){var statearr_66129 = state_66119;
(statearr_66129[(4)] = cljs.core.rest((state_66119[(4)])));

return statearr_66129;
})();
var state_66119__$1 = state_66119;
var ex66124 = (state_66119__$1[(2)]);
var statearr_66130_66147 = state_66119__$1;
(statearr_66130_66147[(5)] = ex66124);


if((ex66124 instanceof Error)){
var statearr_66131_66148 = state_66119__$1;
(statearr_66131_66148[(1)] = (4));

(statearr_66131_66148[(5)] = null);

} else {
throw ex66124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (10))){
var inst_66099 = (state_66119[(7)]);
var inst_66103 = (state_66119[(2)]);
var inst_66104 = fluree.db.util.async.throw_err(inst_66103);
var inst_66105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66104,(0),null);
var inst_66106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66104,(1),null);
var inst_66107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66108 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66109 = ["max-pred-val",inst_66099,inst_66105];
var inst_66110 = cljs.core.PersistentHashMap.fromArrays(inst_66108,inst_66109);
var inst_66111 = (inst_66106 + (10));
var inst_66112 = [inst_66110,inst_66111];
var inst_66113 = (new cljs.core.PersistentVector(null,2,(5),inst_66107,inst_66112,null));
var inst_66114 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66113);
var _ = (function (){var statearr_66132 = state_66119;
(statearr_66132[(4)] = cljs.core.rest((state_66119[(4)])));

return statearr_66132;
})();
var state_66119__$1 = (function (){var statearr_66133 = state_66119;
(statearr_66133[(8)] = inst_66114);

return statearr_66133;
})();
var statearr_66134_66149 = state_66119__$1;
(statearr_66134_66149[(2)] = inst_66105);

(statearr_66134_66149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66120 === (8))){
var inst_66099 = (state_66119[(7)]);
var inst_66099__$1 = (state_66119[(2)]);
var inst_66100 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66101 = fluree.db.dbfunctions.internal.max_pred_val(inst_66100,inst_66099__$1,null);
var state_66119__$1 = (function (){var statearr_66135 = state_66119;
(statearr_66135[(7)] = inst_66099__$1);

return statearr_66135;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66119__$1,(10),inst_66101);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_66136 = [null,null,null,null,null,null,null,null,null];
(statearr_66136[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_66136[(1)] = (1));

return statearr_66136;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_66119){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66119);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66137){var ex__2730__auto__ = e66137;
var statearr_66138_66150 = state_66119;
(statearr_66138_66150[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66119[(4)]))){
var statearr_66139_66151 = state_66119;
(statearr_66139_66151[(1)] = cljs.core.first((state_66119[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66152 = state_66119;
state_66119 = G__66152;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_66119){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_66119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66140 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66140[(6)] = c__2749__auto__);

return statearr_66140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66179){
var state_val_66180 = (state_66179[(1)]);
if((state_val_66180 === (7))){
var state_66179__$1 = state_66179;
var statearr_66181_66200 = state_66179__$1;
(statearr_66181_66200[(2)] = n);

(statearr_66181_66200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66180 === (1))){
var state_66179__$1 = state_66179;
var statearr_66182_66201 = state_66179__$1;
(statearr_66182_66201[(2)] = null);

(statearr_66182_66201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66180 === (4))){
var inst_66153 = (state_66179[(2)]);
var state_66179__$1 = state_66179;
var statearr_66183_66202 = state_66179__$1;
(statearr_66183_66202[(2)] = inst_66153);

(statearr_66183_66202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66180 === (6))){
var state_66179__$1 = state_66179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66179__$1,(9),n);
} else {
if((state_val_66180 === (3))){
var inst_66177 = (state_66179[(2)]);
var state_66179__$1 = state_66179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66179__$1,inst_66177);
} else {
if((state_val_66180 === (2))){
var _ = (function (){var statearr_66185 = state_66179;
(statearr_66185[(4)] = cljs.core.cons((5),(state_66179[(4)])));

return statearr_66185;
})();
var inst_66159 = fluree.db.util.async.channel_QMARK_(n);
var state_66179__$1 = state_66179;
if(inst_66159){
var statearr_66186_66203 = state_66179__$1;
(statearr_66186_66203[(1)] = (6));

} else {
var statearr_66187_66204 = state_66179__$1;
(statearr_66187_66204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66180 === (9))){
var inst_66162 = (state_66179[(2)]);
var inst_66163 = fluree.db.util.async.throw_err(inst_66162);
var state_66179__$1 = state_66179;
var statearr_66188_66205 = state_66179__$1;
(statearr_66188_66205[(2)] = inst_66163);

(statearr_66188_66205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66180 === (5))){
var _ = (function (){var statearr_66189 = state_66179;
(statearr_66189[(4)] = cljs.core.rest((state_66179[(4)])));

return statearr_66189;
})();
var state_66179__$1 = state_66179;
var ex66184 = (state_66179__$1[(2)]);
var statearr_66190_66206 = state_66179__$1;
(statearr_66190_66206[(5)] = ex66184);


if((ex66184 instanceof Error)){
var statearr_66191_66207 = state_66179__$1;
(statearr_66191_66207[(1)] = (4));

(statearr_66191_66207[(5)] = null);

} else {
throw ex66184;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66180 === (8))){
var inst_66166 = (state_66179[(2)]);
var inst_66167 = fluree.db.dbfunctions.internal.inc(inst_66166);
var inst_66168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66169 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66170 = ["inc",inst_66166,inst_66167];
var inst_66171 = cljs.core.PersistentHashMap.fromArrays(inst_66169,inst_66170);
var inst_66172 = [inst_66171,(10)];
var inst_66173 = (new cljs.core.PersistentVector(null,2,(5),inst_66168,inst_66172,null));
var inst_66174 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66173);
var _ = (function (){var statearr_66192 = state_66179;
(statearr_66192[(4)] = cljs.core.rest((state_66179[(4)])));

return statearr_66192;
})();
var state_66179__$1 = (function (){var statearr_66193 = state_66179;
(statearr_66193[(7)] = inst_66174);

return statearr_66193;
})();
var statearr_66194_66208 = state_66179__$1;
(statearr_66194_66208[(2)] = inst_66167);

(statearr_66194_66208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_66195 = [null,null,null,null,null,null,null,null];
(statearr_66195[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_66195[(1)] = (1));

return statearr_66195;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_66179){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66179);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66196){var ex__2730__auto__ = e66196;
var statearr_66197_66209 = state_66179;
(statearr_66197_66209[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66179[(4)]))){
var statearr_66198_66210 = state_66179;
(statearr_66198_66210[(1)] = cljs.core.first((state_66179[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66211 = state_66179;
state_66179 = G__66211;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_66179){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_66179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66199 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66199[(6)] = c__2749__auto__);

return statearr_66199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66238){
var state_val_66239 = (state_66238[(1)]);
if((state_val_66239 === (7))){
var state_66238__$1 = state_66238;
var statearr_66240_66259 = state_66238__$1;
(statearr_66240_66259[(2)] = n);

(statearr_66240_66259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66239 === (1))){
var state_66238__$1 = state_66238;
var statearr_66241_66260 = state_66238__$1;
(statearr_66241_66260[(2)] = null);

(statearr_66241_66260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66239 === (4))){
var inst_66212 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
var statearr_66242_66261 = state_66238__$1;
(statearr_66242_66261[(2)] = inst_66212);

(statearr_66242_66261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66239 === (6))){
var state_66238__$1 = state_66238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66238__$1,(9),n);
} else {
if((state_val_66239 === (3))){
var inst_66236 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66238__$1,inst_66236);
} else {
if((state_val_66239 === (2))){
var _ = (function (){var statearr_66244 = state_66238;
(statearr_66244[(4)] = cljs.core.cons((5),(state_66238[(4)])));

return statearr_66244;
})();
var inst_66218 = fluree.db.util.async.channel_QMARK_(n);
var state_66238__$1 = state_66238;
if(inst_66218){
var statearr_66245_66262 = state_66238__$1;
(statearr_66245_66262[(1)] = (6));

} else {
var statearr_66246_66263 = state_66238__$1;
(statearr_66246_66263[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66239 === (9))){
var inst_66221 = (state_66238[(2)]);
var inst_66222 = fluree.db.util.async.throw_err(inst_66221);
var state_66238__$1 = state_66238;
var statearr_66247_66264 = state_66238__$1;
(statearr_66247_66264[(2)] = inst_66222);

(statearr_66247_66264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66239 === (5))){
var _ = (function (){var statearr_66248 = state_66238;
(statearr_66248[(4)] = cljs.core.rest((state_66238[(4)])));

return statearr_66248;
})();
var state_66238__$1 = state_66238;
var ex66243 = (state_66238__$1[(2)]);
var statearr_66249_66265 = state_66238__$1;
(statearr_66249_66265[(5)] = ex66243);


if((ex66243 instanceof Error)){
var statearr_66250_66266 = state_66238__$1;
(statearr_66250_66266[(1)] = (4));

(statearr_66250_66266[(5)] = null);

} else {
throw ex66243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66239 === (8))){
var inst_66225 = (state_66238[(2)]);
var inst_66226 = fluree.db.dbfunctions.internal.dec(inst_66225);
var inst_66227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66228 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66229 = ["dec",inst_66225,inst_66226];
var inst_66230 = cljs.core.PersistentHashMap.fromArrays(inst_66228,inst_66229);
var inst_66231 = [inst_66230,(10)];
var inst_66232 = (new cljs.core.PersistentVector(null,2,(5),inst_66227,inst_66231,null));
var inst_66233 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66232);
var _ = (function (){var statearr_66251 = state_66238;
(statearr_66251[(4)] = cljs.core.rest((state_66238[(4)])));

return statearr_66251;
})();
var state_66238__$1 = (function (){var statearr_66252 = state_66238;
(statearr_66252[(7)] = inst_66233);

return statearr_66252;
})();
var statearr_66253_66267 = state_66238__$1;
(statearr_66253_66267[(2)] = inst_66226);

(statearr_66253_66267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_66254 = [null,null,null,null,null,null,null,null];
(statearr_66254[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_66254[(1)] = (1));

return statearr_66254;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_66238){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66238);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66255){var ex__2730__auto__ = e66255;
var statearr_66256_66268 = state_66238;
(statearr_66256_66268[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66238[(4)]))){
var statearr_66257_66269 = state_66238;
(statearr_66257_66269[(1)] = cljs.core.first((state_66238[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66270 = state_66238;
state_66238 = G__66270;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_66238){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_66238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66258 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66258[(6)] = c__2749__auto__);

return statearr_66258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66320 = arguments.length;
var i__5770__auto___66321 = (0);
while(true){
if((i__5770__auto___66321 < len__5769__auto___66320)){
args__5775__auto__.push((arguments[i__5770__auto___66321]));

var G__66322 = (i__5770__auto___66321 + (1));
i__5770__auto___66321 = G__66322;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66303){
var state_val_66304 = (state_66303[(1)]);
if((state_val_66304 === (1))){
var state_66303__$1 = state_66303;
var statearr_66305_66323 = state_66303__$1;
(statearr_66305_66323[(2)] = null);

(statearr_66305_66323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66304 === (2))){
var _ = (function (){var statearr_66306 = state_66303;
(statearr_66306[(4)] = cljs.core.cons((5),(state_66303[(4)])));

return statearr_66306;
})();
var inst_66279 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66303__$1 = state_66303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66303__$1,(6),inst_66279);
} else {
if((state_val_66304 === (3))){
var inst_66301 = (state_66303[(2)]);
var state_66303__$1 = state_66303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66303__$1,inst_66301);
} else {
if((state_val_66304 === (4))){
var inst_66273 = (state_66303[(2)]);
var state_66303__$1 = state_66303;
var statearr_66308_66324 = state_66303__$1;
(statearr_66308_66324[(2)] = inst_66273);

(statearr_66308_66324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66304 === (5))){
var _ = (function (){var statearr_66309 = state_66303;
(statearr_66309[(4)] = cljs.core.rest((state_66303[(4)])));

return statearr_66309;
})();
var state_66303__$1 = state_66303;
var ex66307 = (state_66303__$1[(2)]);
var statearr_66310_66325 = state_66303__$1;
(statearr_66310_66325[(5)] = ex66307);


if((ex66307 instanceof Error)){
var statearr_66311_66326 = state_66303__$1;
(statearr_66311_66326[(1)] = (4));

(statearr_66311_66326[(5)] = null);

} else {
throw ex66307;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66304 === (6))){
var inst_66281 = (state_66303[(2)]);
var inst_66282 = fluree.db.util.async.throw_err(inst_66281);
var inst_66283 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_66282);
var inst_66284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66285 = [inst_66282];
var inst_66286 = (new cljs.core.PersistentVector(null,1,(5),inst_66284,inst_66285,null));
var inst_66287 = cljs.core.count(inst_66286);
var inst_66288 = ((9) + inst_66287);
var inst_66289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66290 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66292 = [inst_66282];
var inst_66293 = (new cljs.core.PersistentVector(null,1,(5),inst_66291,inst_66292,null));
var inst_66294 = ["+",inst_66293,inst_66283];
var inst_66295 = cljs.core.PersistentHashMap.fromArrays(inst_66290,inst_66294);
var inst_66296 = [inst_66295,inst_66288];
var inst_66297 = (new cljs.core.PersistentVector(null,2,(5),inst_66289,inst_66296,null));
var inst_66298 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66297);
var _ = (function (){var statearr_66312 = state_66303;
(statearr_66312[(4)] = cljs.core.rest((state_66303[(4)])));

return statearr_66312;
})();
var state_66303__$1 = (function (){var statearr_66313 = state_66303;
(statearr_66313[(7)] = inst_66298);

return statearr_66313;
})();
var statearr_66314_66327 = state_66303__$1;
(statearr_66314_66327[(2)] = inst_66283);

(statearr_66314_66327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_66315 = [null,null,null,null,null,null,null,null];
(statearr_66315[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_66315[(1)] = (1));

return statearr_66315;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_66303){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66303);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66316){var ex__2730__auto__ = e66316;
var statearr_66317_66328 = state_66303;
(statearr_66317_66328[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66303[(4)]))){
var statearr_66318_66329 = state_66303;
(statearr_66318_66329[(1)] = cljs.core.first((state_66303[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66330 = state_66303;
state_66303 = G__66330;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_66303){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_66303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66319 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66319[(6)] = c__2749__auto__);

return statearr_66319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq66271){
var G__66272 = cljs.core.first(seq66271);
var seq66271__$1 = cljs.core.next(seq66271);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66272,seq66271__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66380 = arguments.length;
var i__5770__auto___66381 = (0);
while(true){
if((i__5770__auto___66381 < len__5769__auto___66380)){
args__5775__auto__.push((arguments[i__5770__auto___66381]));

var G__66382 = (i__5770__auto___66381 + (1));
i__5770__auto___66381 = G__66382;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66363){
var state_val_66364 = (state_66363[(1)]);
if((state_val_66364 === (1))){
var state_66363__$1 = state_66363;
var statearr_66365_66383 = state_66363__$1;
(statearr_66365_66383[(2)] = null);

(statearr_66365_66383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66364 === (2))){
var _ = (function (){var statearr_66366 = state_66363;
(statearr_66366[(4)] = cljs.core.cons((5),(state_66363[(4)])));

return statearr_66366;
})();
var inst_66339 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66363__$1 = state_66363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66363__$1,(6),inst_66339);
} else {
if((state_val_66364 === (3))){
var inst_66361 = (state_66363[(2)]);
var state_66363__$1 = state_66363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66363__$1,inst_66361);
} else {
if((state_val_66364 === (4))){
var inst_66333 = (state_66363[(2)]);
var state_66363__$1 = state_66363;
var statearr_66368_66384 = state_66363__$1;
(statearr_66368_66384[(2)] = inst_66333);

(statearr_66368_66384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66364 === (5))){
var _ = (function (){var statearr_66369 = state_66363;
(statearr_66369[(4)] = cljs.core.rest((state_66363[(4)])));

return statearr_66369;
})();
var state_66363__$1 = state_66363;
var ex66367 = (state_66363__$1[(2)]);
var statearr_66370_66385 = state_66363__$1;
(statearr_66370_66385[(5)] = ex66367);


if((ex66367 instanceof Error)){
var statearr_66371_66386 = state_66363__$1;
(statearr_66371_66386[(1)] = (4));

(statearr_66371_66386[(5)] = null);

} else {
throw ex66367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66364 === (6))){
var inst_66341 = (state_66363[(2)]);
var inst_66342 = fluree.db.util.async.throw_err(inst_66341);
var inst_66343 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_66342);
var inst_66344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66345 = [inst_66342];
var inst_66346 = (new cljs.core.PersistentVector(null,1,(5),inst_66344,inst_66345,null));
var inst_66347 = cljs.core.count(inst_66346);
var inst_66348 = ((9) + inst_66347);
var inst_66349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66350 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66352 = [inst_66342];
var inst_66353 = (new cljs.core.PersistentVector(null,1,(5),inst_66351,inst_66352,null));
var inst_66354 = ["-",inst_66353,inst_66343];
var inst_66355 = cljs.core.PersistentHashMap.fromArrays(inst_66350,inst_66354);
var inst_66356 = [inst_66355,inst_66348];
var inst_66357 = (new cljs.core.PersistentVector(null,2,(5),inst_66349,inst_66356,null));
var inst_66358 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66357);
var _ = (function (){var statearr_66372 = state_66363;
(statearr_66372[(4)] = cljs.core.rest((state_66363[(4)])));

return statearr_66372;
})();
var state_66363__$1 = (function (){var statearr_66373 = state_66363;
(statearr_66373[(7)] = inst_66358);

return statearr_66373;
})();
var statearr_66374_66387 = state_66363__$1;
(statearr_66374_66387[(2)] = inst_66343);

(statearr_66374_66387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_66375 = [null,null,null,null,null,null,null,null];
(statearr_66375[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_66375[(1)] = (1));

return statearr_66375;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_66363){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66363);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66376){var ex__2730__auto__ = e66376;
var statearr_66377_66388 = state_66363;
(statearr_66377_66388[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66363[(4)]))){
var statearr_66378_66389 = state_66363;
(statearr_66378_66389[(1)] = cljs.core.first((state_66363[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66390 = state_66363;
state_66363 = G__66390;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_66363){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_66363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66379 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66379[(6)] = c__2749__auto__);

return statearr_66379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq66331){
var G__66332 = cljs.core.first(seq66331);
var seq66331__$1 = cljs.core.next(seq66331);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66332,seq66331__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66440 = arguments.length;
var i__5770__auto___66441 = (0);
while(true){
if((i__5770__auto___66441 < len__5769__auto___66440)){
args__5775__auto__.push((arguments[i__5770__auto___66441]));

var G__66442 = (i__5770__auto___66441 + (1));
i__5770__auto___66441 = G__66442;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66423){
var state_val_66424 = (state_66423[(1)]);
if((state_val_66424 === (1))){
var state_66423__$1 = state_66423;
var statearr_66425_66443 = state_66423__$1;
(statearr_66425_66443[(2)] = null);

(statearr_66425_66443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66424 === (2))){
var _ = (function (){var statearr_66426 = state_66423;
(statearr_66426[(4)] = cljs.core.cons((5),(state_66423[(4)])));

return statearr_66426;
})();
var inst_66399 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66423__$1 = state_66423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66423__$1,(6),inst_66399);
} else {
if((state_val_66424 === (3))){
var inst_66421 = (state_66423[(2)]);
var state_66423__$1 = state_66423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66423__$1,inst_66421);
} else {
if((state_val_66424 === (4))){
var inst_66393 = (state_66423[(2)]);
var state_66423__$1 = state_66423;
var statearr_66428_66444 = state_66423__$1;
(statearr_66428_66444[(2)] = inst_66393);

(statearr_66428_66444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66424 === (5))){
var _ = (function (){var statearr_66429 = state_66423;
(statearr_66429[(4)] = cljs.core.rest((state_66423[(4)])));

return statearr_66429;
})();
var state_66423__$1 = state_66423;
var ex66427 = (state_66423__$1[(2)]);
var statearr_66430_66445 = state_66423__$1;
(statearr_66430_66445[(5)] = ex66427);


if((ex66427 instanceof Error)){
var statearr_66431_66446 = state_66423__$1;
(statearr_66431_66446[(1)] = (4));

(statearr_66431_66446[(5)] = null);

} else {
throw ex66427;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66424 === (6))){
var inst_66401 = (state_66423[(2)]);
var inst_66402 = fluree.db.util.async.throw_err(inst_66401);
var inst_66403 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_66402);
var inst_66404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66405 = [inst_66402];
var inst_66406 = (new cljs.core.PersistentVector(null,1,(5),inst_66404,inst_66405,null));
var inst_66407 = cljs.core.count(inst_66406);
var inst_66408 = ((9) + inst_66407);
var inst_66409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66410 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66412 = [inst_66402];
var inst_66413 = (new cljs.core.PersistentVector(null,1,(5),inst_66411,inst_66412,null));
var inst_66414 = ["*",inst_66413,inst_66403];
var inst_66415 = cljs.core.PersistentHashMap.fromArrays(inst_66410,inst_66414);
var inst_66416 = [inst_66415,inst_66408];
var inst_66417 = (new cljs.core.PersistentVector(null,2,(5),inst_66409,inst_66416,null));
var inst_66418 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66417);
var _ = (function (){var statearr_66432 = state_66423;
(statearr_66432[(4)] = cljs.core.rest((state_66423[(4)])));

return statearr_66432;
})();
var state_66423__$1 = (function (){var statearr_66433 = state_66423;
(statearr_66433[(7)] = inst_66418);

return statearr_66433;
})();
var statearr_66434_66447 = state_66423__$1;
(statearr_66434_66447[(2)] = inst_66403);

(statearr_66434_66447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_66435 = [null,null,null,null,null,null,null,null];
(statearr_66435[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_66435[(1)] = (1));

return statearr_66435;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_66423){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66423);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66436){var ex__2730__auto__ = e66436;
var statearr_66437_66448 = state_66423;
(statearr_66437_66448[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66423[(4)]))){
var statearr_66438_66449 = state_66423;
(statearr_66438_66449[(1)] = cljs.core.first((state_66423[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66450 = state_66423;
state_66423 = G__66450;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_66423){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_66423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66439 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66439[(6)] = c__2749__auto__);

return statearr_66439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq66391){
var G__66392 = cljs.core.first(seq66391);
var seq66391__$1 = cljs.core.next(seq66391);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66392,seq66391__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66500 = arguments.length;
var i__5770__auto___66501 = (0);
while(true){
if((i__5770__auto___66501 < len__5769__auto___66500)){
args__5775__auto__.push((arguments[i__5770__auto___66501]));

var G__66502 = (i__5770__auto___66501 + (1));
i__5770__auto___66501 = G__66502;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66483){
var state_val_66484 = (state_66483[(1)]);
if((state_val_66484 === (1))){
var state_66483__$1 = state_66483;
var statearr_66485_66503 = state_66483__$1;
(statearr_66485_66503[(2)] = null);

(statearr_66485_66503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66484 === (2))){
var _ = (function (){var statearr_66486 = state_66483;
(statearr_66486[(4)] = cljs.core.cons((5),(state_66483[(4)])));

return statearr_66486;
})();
var inst_66459 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66483__$1 = state_66483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66483__$1,(6),inst_66459);
} else {
if((state_val_66484 === (3))){
var inst_66481 = (state_66483[(2)]);
var state_66483__$1 = state_66483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66483__$1,inst_66481);
} else {
if((state_val_66484 === (4))){
var inst_66453 = (state_66483[(2)]);
var state_66483__$1 = state_66483;
var statearr_66488_66504 = state_66483__$1;
(statearr_66488_66504[(2)] = inst_66453);

(statearr_66488_66504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66484 === (5))){
var _ = (function (){var statearr_66489 = state_66483;
(statearr_66489[(4)] = cljs.core.rest((state_66483[(4)])));

return statearr_66489;
})();
var state_66483__$1 = state_66483;
var ex66487 = (state_66483__$1[(2)]);
var statearr_66490_66505 = state_66483__$1;
(statearr_66490_66505[(5)] = ex66487);


if((ex66487 instanceof Error)){
var statearr_66491_66506 = state_66483__$1;
(statearr_66491_66506[(1)] = (4));

(statearr_66491_66506[(5)] = null);

} else {
throw ex66487;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66484 === (6))){
var inst_66461 = (state_66483[(2)]);
var inst_66462 = fluree.db.util.async.throw_err(inst_66461);
var inst_66463 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_66462);
var inst_66464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66465 = [inst_66462];
var inst_66466 = (new cljs.core.PersistentVector(null,1,(5),inst_66464,inst_66465,null));
var inst_66467 = cljs.core.count(inst_66466);
var inst_66468 = ((9) + inst_66467);
var inst_66469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66470 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66472 = [inst_66462];
var inst_66473 = (new cljs.core.PersistentVector(null,1,(5),inst_66471,inst_66472,null));
var inst_66474 = ["/",inst_66473,inst_66463];
var inst_66475 = cljs.core.PersistentHashMap.fromArrays(inst_66470,inst_66474);
var inst_66476 = [inst_66475,inst_66468];
var inst_66477 = (new cljs.core.PersistentVector(null,2,(5),inst_66469,inst_66476,null));
var inst_66478 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66477);
var _ = (function (){var statearr_66492 = state_66483;
(statearr_66492[(4)] = cljs.core.rest((state_66483[(4)])));

return statearr_66492;
})();
var state_66483__$1 = (function (){var statearr_66493 = state_66483;
(statearr_66493[(7)] = inst_66478);

return statearr_66493;
})();
var statearr_66494_66507 = state_66483__$1;
(statearr_66494_66507[(2)] = inst_66463);

(statearr_66494_66507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_66495 = [null,null,null,null,null,null,null,null];
(statearr_66495[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_66495[(1)] = (1));

return statearr_66495;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_66483){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66483);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66496){var ex__2730__auto__ = e66496;
var statearr_66497_66508 = state_66483;
(statearr_66497_66508[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66483[(4)]))){
var statearr_66498_66509 = state_66483;
(statearr_66498_66509[(1)] = cljs.core.first((state_66483[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66510 = state_66483;
state_66483 = G__66510;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_66483){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_66483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66499 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66499[(6)] = c__2749__auto__);

return statearr_66499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq66451){
var G__66452 = cljs.core.first(seq66451);
var seq66451__$1 = cljs.core.next(seq66451);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66452,seq66451__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66548){
var state_val_66549 = (state_66548[(1)]);
if((state_val_66549 === (7))){
var state_66548__$1 = state_66548;
var statearr_66550_66574 = state_66548__$1;
(statearr_66550_66574[(2)] = n);

(statearr_66550_66574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (1))){
var state_66548__$1 = state_66548;
var statearr_66551_66575 = state_66548__$1;
(statearr_66551_66575[(2)] = null);

(statearr_66551_66575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (4))){
var inst_66511 = (state_66548[(2)]);
var state_66548__$1 = state_66548;
var statearr_66552_66576 = state_66548__$1;
(statearr_66552_66576[(2)] = inst_66511);

(statearr_66552_66576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (13))){
var inst_66528 = (state_66548[(2)]);
var inst_66529 = fluree.db.util.async.throw_err(inst_66528);
var state_66548__$1 = state_66548;
var statearr_66553_66577 = state_66548__$1;
(statearr_66553_66577[(2)] = inst_66529);

(statearr_66553_66577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (6))){
var state_66548__$1 = state_66548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66548__$1,(9),n);
} else {
if((state_val_66549 === (3))){
var inst_66546 = (state_66548[(2)]);
var state_66548__$1 = state_66548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66548__$1,inst_66546);
} else {
if((state_val_66549 === (12))){
var inst_66524 = (state_66548[(7)]);
var inst_66532 = (state_66548[(2)]);
var inst_66533 = fluree.db.dbfunctions.internal.quot(inst_66524,inst_66532);
var inst_66534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66535 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66537 = [inst_66524,inst_66532];
var inst_66538 = (new cljs.core.PersistentVector(null,2,(5),inst_66536,inst_66537,null));
var inst_66539 = ["quot",inst_66538,inst_66533];
var inst_66540 = cljs.core.PersistentHashMap.fromArrays(inst_66535,inst_66539);
var inst_66541 = [inst_66540,(2)];
var inst_66542 = (new cljs.core.PersistentVector(null,2,(5),inst_66534,inst_66541,null));
var inst_66543 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66542);
var _ = (function (){var statearr_66554 = state_66548;
(statearr_66554[(4)] = cljs.core.rest((state_66548[(4)])));

return statearr_66554;
})();
var state_66548__$1 = (function (){var statearr_66555 = state_66548;
(statearr_66555[(8)] = inst_66543);

return statearr_66555;
})();
var statearr_66556_66578 = state_66548__$1;
(statearr_66556_66578[(2)] = inst_66533);

(statearr_66556_66578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (2))){
var _ = (function (){var statearr_66557 = state_66548;
(statearr_66557[(4)] = cljs.core.cons((5),(state_66548[(4)])));

return statearr_66557;
})();
var inst_66517 = fluree.db.util.async.channel_QMARK_(n);
var state_66548__$1 = state_66548;
if(inst_66517){
var statearr_66558_66579 = state_66548__$1;
(statearr_66558_66579[(1)] = (6));

} else {
var statearr_66559_66580 = state_66548__$1;
(statearr_66559_66580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (11))){
var state_66548__$1 = state_66548;
var statearr_66561_66581 = state_66548__$1;
(statearr_66561_66581[(2)] = d);

(statearr_66561_66581[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (9))){
var inst_66520 = (state_66548[(2)]);
var inst_66521 = fluree.db.util.async.throw_err(inst_66520);
var state_66548__$1 = state_66548;
var statearr_66562_66582 = state_66548__$1;
(statearr_66562_66582[(2)] = inst_66521);

(statearr_66562_66582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (5))){
var _ = (function (){var statearr_66563 = state_66548;
(statearr_66563[(4)] = cljs.core.rest((state_66548[(4)])));

return statearr_66563;
})();
var state_66548__$1 = state_66548;
var ex66560 = (state_66548__$1[(2)]);
var statearr_66564_66583 = state_66548__$1;
(statearr_66564_66583[(5)] = ex66560);


if((ex66560 instanceof Error)){
var statearr_66565_66584 = state_66548__$1;
(statearr_66565_66584[(1)] = (4));

(statearr_66565_66584[(5)] = null);

} else {
throw ex66560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66549 === (10))){
var state_66548__$1 = state_66548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66548__$1,(13),d);
} else {
if((state_val_66549 === (8))){
var inst_66524 = (state_66548[(2)]);
var inst_66525 = fluree.db.util.async.channel_QMARK_(d);
var state_66548__$1 = (function (){var statearr_66566 = state_66548;
(statearr_66566[(7)] = inst_66524);

return statearr_66566;
})();
if(inst_66525){
var statearr_66567_66585 = state_66548__$1;
(statearr_66567_66585[(1)] = (10));

} else {
var statearr_66568_66586 = state_66548__$1;
(statearr_66568_66586[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_66569 = [null,null,null,null,null,null,null,null,null];
(statearr_66569[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_66569[(1)] = (1));

return statearr_66569;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_66548){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66548);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66570){var ex__2730__auto__ = e66570;
var statearr_66571_66587 = state_66548;
(statearr_66571_66587[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66548[(4)]))){
var statearr_66572_66588 = state_66548;
(statearr_66572_66588[(1)] = cljs.core.first((state_66548[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66589 = state_66548;
state_66548 = G__66589;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_66548){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_66548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66573 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66573[(6)] = c__2749__auto__);

return statearr_66573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66627){
var state_val_66628 = (state_66627[(1)]);
if((state_val_66628 === (7))){
var state_66627__$1 = state_66627;
var statearr_66629_66653 = state_66627__$1;
(statearr_66629_66653[(2)] = n);

(statearr_66629_66653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (1))){
var state_66627__$1 = state_66627;
var statearr_66630_66654 = state_66627__$1;
(statearr_66630_66654[(2)] = null);

(statearr_66630_66654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (4))){
var inst_66590 = (state_66627[(2)]);
var state_66627__$1 = state_66627;
var statearr_66631_66655 = state_66627__$1;
(statearr_66631_66655[(2)] = inst_66590);

(statearr_66631_66655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (13))){
var inst_66607 = (state_66627[(2)]);
var inst_66608 = fluree.db.util.async.throw_err(inst_66607);
var state_66627__$1 = state_66627;
var statearr_66632_66656 = state_66627__$1;
(statearr_66632_66656[(2)] = inst_66608);

(statearr_66632_66656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (6))){
var state_66627__$1 = state_66627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66627__$1,(9),n);
} else {
if((state_val_66628 === (3))){
var inst_66625 = (state_66627[(2)]);
var state_66627__$1 = state_66627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66627__$1,inst_66625);
} else {
if((state_val_66628 === (12))){
var inst_66603 = (state_66627[(7)]);
var inst_66611 = (state_66627[(2)]);
var inst_66612 = fluree.db.dbfunctions.internal.mod(inst_66603,inst_66611);
var inst_66613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66614 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66616 = [inst_66603,inst_66611];
var inst_66617 = (new cljs.core.PersistentVector(null,2,(5),inst_66615,inst_66616,null));
var inst_66618 = ["mod",inst_66617,inst_66612];
var inst_66619 = cljs.core.PersistentHashMap.fromArrays(inst_66614,inst_66618);
var inst_66620 = [inst_66619,(2)];
var inst_66621 = (new cljs.core.PersistentVector(null,2,(5),inst_66613,inst_66620,null));
var inst_66622 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66621);
var _ = (function (){var statearr_66633 = state_66627;
(statearr_66633[(4)] = cljs.core.rest((state_66627[(4)])));

return statearr_66633;
})();
var state_66627__$1 = (function (){var statearr_66634 = state_66627;
(statearr_66634[(8)] = inst_66622);

return statearr_66634;
})();
var statearr_66635_66657 = state_66627__$1;
(statearr_66635_66657[(2)] = inst_66612);

(statearr_66635_66657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (2))){
var _ = (function (){var statearr_66636 = state_66627;
(statearr_66636[(4)] = cljs.core.cons((5),(state_66627[(4)])));

return statearr_66636;
})();
var inst_66596 = fluree.db.util.async.channel_QMARK_(n);
var state_66627__$1 = state_66627;
if(inst_66596){
var statearr_66637_66658 = state_66627__$1;
(statearr_66637_66658[(1)] = (6));

} else {
var statearr_66638_66659 = state_66627__$1;
(statearr_66638_66659[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (11))){
var state_66627__$1 = state_66627;
var statearr_66640_66660 = state_66627__$1;
(statearr_66640_66660[(2)] = d);

(statearr_66640_66660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (9))){
var inst_66599 = (state_66627[(2)]);
var inst_66600 = fluree.db.util.async.throw_err(inst_66599);
var state_66627__$1 = state_66627;
var statearr_66641_66661 = state_66627__$1;
(statearr_66641_66661[(2)] = inst_66600);

(statearr_66641_66661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (5))){
var _ = (function (){var statearr_66642 = state_66627;
(statearr_66642[(4)] = cljs.core.rest((state_66627[(4)])));

return statearr_66642;
})();
var state_66627__$1 = state_66627;
var ex66639 = (state_66627__$1[(2)]);
var statearr_66643_66662 = state_66627__$1;
(statearr_66643_66662[(5)] = ex66639);


if((ex66639 instanceof Error)){
var statearr_66644_66663 = state_66627__$1;
(statearr_66644_66663[(1)] = (4));

(statearr_66644_66663[(5)] = null);

} else {
throw ex66639;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66628 === (10))){
var state_66627__$1 = state_66627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66627__$1,(13),d);
} else {
if((state_val_66628 === (8))){
var inst_66603 = (state_66627[(2)]);
var inst_66604 = fluree.db.util.async.channel_QMARK_(d);
var state_66627__$1 = (function (){var statearr_66645 = state_66627;
(statearr_66645[(7)] = inst_66603);

return statearr_66645;
})();
if(inst_66604){
var statearr_66646_66664 = state_66627__$1;
(statearr_66646_66664[(1)] = (10));

} else {
var statearr_66647_66665 = state_66627__$1;
(statearr_66647_66665[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_66648 = [null,null,null,null,null,null,null,null,null];
(statearr_66648[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_66648[(1)] = (1));

return statearr_66648;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_66627){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66627);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66649){var ex__2730__auto__ = e66649;
var statearr_66650_66666 = state_66627;
(statearr_66650_66666[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66627[(4)]))){
var statearr_66651_66667 = state_66627;
(statearr_66651_66667[(1)] = cljs.core.first((state_66627[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66668 = state_66627;
state_66627 = G__66668;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_66627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_66627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66652 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66652[(6)] = c__2749__auto__);

return statearr_66652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66706){
var state_val_66707 = (state_66706[(1)]);
if((state_val_66707 === (7))){
var state_66706__$1 = state_66706;
var statearr_66708_66732 = state_66706__$1;
(statearr_66708_66732[(2)] = n);

(statearr_66708_66732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (1))){
var state_66706__$1 = state_66706;
var statearr_66709_66733 = state_66706__$1;
(statearr_66709_66733[(2)] = null);

(statearr_66709_66733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (4))){
var inst_66669 = (state_66706[(2)]);
var state_66706__$1 = state_66706;
var statearr_66710_66734 = state_66706__$1;
(statearr_66710_66734[(2)] = inst_66669);

(statearr_66710_66734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (13))){
var inst_66686 = (state_66706[(2)]);
var inst_66687 = fluree.db.util.async.throw_err(inst_66686);
var state_66706__$1 = state_66706;
var statearr_66711_66735 = state_66706__$1;
(statearr_66711_66735[(2)] = inst_66687);

(statearr_66711_66735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (6))){
var state_66706__$1 = state_66706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66706__$1,(9),n);
} else {
if((state_val_66707 === (3))){
var inst_66704 = (state_66706[(2)]);
var state_66706__$1 = state_66706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66706__$1,inst_66704);
} else {
if((state_val_66707 === (12))){
var inst_66682 = (state_66706[(7)]);
var inst_66690 = (state_66706[(2)]);
var inst_66691 = fluree.db.dbfunctions.internal.rem(inst_66682,inst_66690);
var inst_66692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66693 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66695 = [inst_66682,inst_66690];
var inst_66696 = (new cljs.core.PersistentVector(null,2,(5),inst_66694,inst_66695,null));
var inst_66697 = ["rem",inst_66696,inst_66691];
var inst_66698 = cljs.core.PersistentHashMap.fromArrays(inst_66693,inst_66697);
var inst_66699 = [inst_66698,(2)];
var inst_66700 = (new cljs.core.PersistentVector(null,2,(5),inst_66692,inst_66699,null));
var inst_66701 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66700);
var _ = (function (){var statearr_66712 = state_66706;
(statearr_66712[(4)] = cljs.core.rest((state_66706[(4)])));

return statearr_66712;
})();
var state_66706__$1 = (function (){var statearr_66713 = state_66706;
(statearr_66713[(8)] = inst_66701);

return statearr_66713;
})();
var statearr_66714_66736 = state_66706__$1;
(statearr_66714_66736[(2)] = inst_66691);

(statearr_66714_66736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (2))){
var _ = (function (){var statearr_66715 = state_66706;
(statearr_66715[(4)] = cljs.core.cons((5),(state_66706[(4)])));

return statearr_66715;
})();
var inst_66675 = fluree.db.util.async.channel_QMARK_(n);
var state_66706__$1 = state_66706;
if(inst_66675){
var statearr_66716_66737 = state_66706__$1;
(statearr_66716_66737[(1)] = (6));

} else {
var statearr_66717_66738 = state_66706__$1;
(statearr_66717_66738[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (11))){
var state_66706__$1 = state_66706;
var statearr_66719_66739 = state_66706__$1;
(statearr_66719_66739[(2)] = d);

(statearr_66719_66739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (9))){
var inst_66678 = (state_66706[(2)]);
var inst_66679 = fluree.db.util.async.throw_err(inst_66678);
var state_66706__$1 = state_66706;
var statearr_66720_66740 = state_66706__$1;
(statearr_66720_66740[(2)] = inst_66679);

(statearr_66720_66740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (5))){
var _ = (function (){var statearr_66721 = state_66706;
(statearr_66721[(4)] = cljs.core.rest((state_66706[(4)])));

return statearr_66721;
})();
var state_66706__$1 = state_66706;
var ex66718 = (state_66706__$1[(2)]);
var statearr_66722_66741 = state_66706__$1;
(statearr_66722_66741[(5)] = ex66718);


if((ex66718 instanceof Error)){
var statearr_66723_66742 = state_66706__$1;
(statearr_66723_66742[(1)] = (4));

(statearr_66723_66742[(5)] = null);

} else {
throw ex66718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66707 === (10))){
var state_66706__$1 = state_66706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66706__$1,(13),d);
} else {
if((state_val_66707 === (8))){
var inst_66682 = (state_66706[(2)]);
var inst_66683 = fluree.db.util.async.channel_QMARK_(d);
var state_66706__$1 = (function (){var statearr_66724 = state_66706;
(statearr_66724[(7)] = inst_66682);

return statearr_66724;
})();
if(inst_66683){
var statearr_66725_66743 = state_66706__$1;
(statearr_66725_66743[(1)] = (10));

} else {
var statearr_66726_66744 = state_66706__$1;
(statearr_66726_66744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_66727 = [null,null,null,null,null,null,null,null,null];
(statearr_66727[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_66727[(1)] = (1));

return statearr_66727;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_66706){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66706);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66728){var ex__2730__auto__ = e66728;
var statearr_66729_66745 = state_66706;
(statearr_66729_66745[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66706[(4)]))){
var statearr_66730_66746 = state_66706;
(statearr_66730_66746[(1)] = cljs.core.first((state_66706[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66747 = state_66706;
state_66706 = G__66747;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_66706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_66706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66731 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66731[(6)] = c__2749__auto__);

return statearr_66731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66774){
var state_val_66775 = (state_66774[(1)]);
if((state_val_66775 === (7))){
var state_66774__$1 = state_66774;
var statearr_66776_66795 = state_66774__$1;
(statearr_66776_66795[(2)] = x);

(statearr_66776_66795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66775 === (1))){
var state_66774__$1 = state_66774;
var statearr_66777_66796 = state_66774__$1;
(statearr_66777_66796[(2)] = null);

(statearr_66777_66796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66775 === (4))){
var inst_66748 = (state_66774[(2)]);
var state_66774__$1 = state_66774;
var statearr_66778_66797 = state_66774__$1;
(statearr_66778_66797[(2)] = inst_66748);

(statearr_66778_66797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66775 === (6))){
var state_66774__$1 = state_66774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66774__$1,(9),x);
} else {
if((state_val_66775 === (3))){
var inst_66772 = (state_66774[(2)]);
var state_66774__$1 = state_66774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66774__$1,inst_66772);
} else {
if((state_val_66775 === (2))){
var _ = (function (){var statearr_66780 = state_66774;
(statearr_66780[(4)] = cljs.core.cons((5),(state_66774[(4)])));

return statearr_66780;
})();
var inst_66754 = fluree.db.util.async.channel_QMARK_(x);
var state_66774__$1 = state_66774;
if(inst_66754){
var statearr_66781_66798 = state_66774__$1;
(statearr_66781_66798[(1)] = (6));

} else {
var statearr_66782_66799 = state_66774__$1;
(statearr_66782_66799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66775 === (9))){
var inst_66757 = (state_66774[(2)]);
var inst_66758 = fluree.db.util.async.throw_err(inst_66757);
var state_66774__$1 = state_66774;
var statearr_66783_66800 = state_66774__$1;
(statearr_66783_66800[(2)] = inst_66758);

(statearr_66783_66800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66775 === (5))){
var _ = (function (){var statearr_66784 = state_66774;
(statearr_66784[(4)] = cljs.core.rest((state_66774[(4)])));

return statearr_66784;
})();
var state_66774__$1 = state_66774;
var ex66779 = (state_66774__$1[(2)]);
var statearr_66785_66801 = state_66774__$1;
(statearr_66785_66801[(5)] = ex66779);


if((ex66779 instanceof Error)){
var statearr_66786_66802 = state_66774__$1;
(statearr_66786_66802[(1)] = (4));

(statearr_66786_66802[(5)] = null);

} else {
throw ex66779;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66775 === (8))){
var inst_66761 = (state_66774[(2)]);
var inst_66762 = fluree.db.dbfunctions.internal.boolean$(inst_66761);
var inst_66763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66764 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66765 = ["boolean",inst_66761,inst_66762];
var inst_66766 = cljs.core.PersistentHashMap.fromArrays(inst_66764,inst_66765);
var inst_66767 = [inst_66766,(10)];
var inst_66768 = (new cljs.core.PersistentVector(null,2,(5),inst_66763,inst_66767,null));
var inst_66769 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66768);
var _ = (function (){var statearr_66787 = state_66774;
(statearr_66787[(4)] = cljs.core.rest((state_66774[(4)])));

return statearr_66787;
})();
var state_66774__$1 = (function (){var statearr_66788 = state_66774;
(statearr_66788[(7)] = inst_66769);

return statearr_66788;
})();
var statearr_66789_66803 = state_66774__$1;
(statearr_66789_66803[(2)] = inst_66762);

(statearr_66789_66803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_66790 = [null,null,null,null,null,null,null,null];
(statearr_66790[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_66790[(1)] = (1));

return statearr_66790;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_66774){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66774);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66791){var ex__2730__auto__ = e66791;
var statearr_66792_66804 = state_66774;
(statearr_66792_66804[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66774[(4)]))){
var statearr_66793_66805 = state_66774;
(statearr_66793_66805[(1)] = cljs.core.first((state_66774[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66806 = state_66774;
state_66774 = G__66806;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_66774){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_66774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66794 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66794[(6)] = c__2749__auto__);

return statearr_66794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66844){
var state_val_66845 = (state_66844[(1)]);
if((state_val_66845 === (7))){
var state_66844__$1 = state_66844;
var statearr_66846_66870 = state_66844__$1;
(statearr_66846_66870[(2)] = pattern);

(statearr_66846_66870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (1))){
var state_66844__$1 = state_66844;
var statearr_66847_66871 = state_66844__$1;
(statearr_66847_66871[(2)] = null);

(statearr_66847_66871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (4))){
var inst_66807 = (state_66844[(2)]);
var state_66844__$1 = state_66844;
var statearr_66848_66872 = state_66844__$1;
(statearr_66848_66872[(2)] = inst_66807);

(statearr_66848_66872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (13))){
var inst_66824 = (state_66844[(2)]);
var inst_66825 = fluree.db.util.async.throw_err(inst_66824);
var state_66844__$1 = state_66844;
var statearr_66849_66873 = state_66844__$1;
(statearr_66849_66873[(2)] = inst_66825);

(statearr_66849_66873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (6))){
var state_66844__$1 = state_66844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66844__$1,(9),pattern);
} else {
if((state_val_66845 === (3))){
var inst_66842 = (state_66844[(2)]);
var state_66844__$1 = state_66844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66844__$1,inst_66842);
} else {
if((state_val_66845 === (12))){
var inst_66820 = (state_66844[(7)]);
var inst_66828 = (state_66844[(2)]);
var inst_66829 = fluree.db.dbfunctions.internal.re_find(inst_66820,inst_66828);
var inst_66830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66831 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66833 = [inst_66820,inst_66828];
var inst_66834 = (new cljs.core.PersistentVector(null,2,(5),inst_66832,inst_66833,null));
var inst_66835 = ["re-find",inst_66834,inst_66829];
var inst_66836 = cljs.core.PersistentHashMap.fromArrays(inst_66831,inst_66835);
var inst_66837 = [inst_66836,(10)];
var inst_66838 = (new cljs.core.PersistentVector(null,2,(5),inst_66830,inst_66837,null));
var inst_66839 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66838);
var _ = (function (){var statearr_66850 = state_66844;
(statearr_66850[(4)] = cljs.core.rest((state_66844[(4)])));

return statearr_66850;
})();
var state_66844__$1 = (function (){var statearr_66851 = state_66844;
(statearr_66851[(8)] = inst_66839);

return statearr_66851;
})();
var statearr_66852_66874 = state_66844__$1;
(statearr_66852_66874[(2)] = inst_66829);

(statearr_66852_66874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (2))){
var _ = (function (){var statearr_66853 = state_66844;
(statearr_66853[(4)] = cljs.core.cons((5),(state_66844[(4)])));

return statearr_66853;
})();
var inst_66813 = fluree.db.util.async.channel_QMARK_(pattern);
var state_66844__$1 = state_66844;
if(inst_66813){
var statearr_66854_66875 = state_66844__$1;
(statearr_66854_66875[(1)] = (6));

} else {
var statearr_66855_66876 = state_66844__$1;
(statearr_66855_66876[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (11))){
var state_66844__$1 = state_66844;
var statearr_66857_66877 = state_66844__$1;
(statearr_66857_66877[(2)] = string);

(statearr_66857_66877[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (9))){
var inst_66816 = (state_66844[(2)]);
var inst_66817 = fluree.db.util.async.throw_err(inst_66816);
var state_66844__$1 = state_66844;
var statearr_66858_66878 = state_66844__$1;
(statearr_66858_66878[(2)] = inst_66817);

(statearr_66858_66878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (5))){
var _ = (function (){var statearr_66859 = state_66844;
(statearr_66859[(4)] = cljs.core.rest((state_66844[(4)])));

return statearr_66859;
})();
var state_66844__$1 = state_66844;
var ex66856 = (state_66844__$1[(2)]);
var statearr_66860_66879 = state_66844__$1;
(statearr_66860_66879[(5)] = ex66856);


if((ex66856 instanceof Error)){
var statearr_66861_66880 = state_66844__$1;
(statearr_66861_66880[(1)] = (4));

(statearr_66861_66880[(5)] = null);

} else {
throw ex66856;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66845 === (10))){
var state_66844__$1 = state_66844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66844__$1,(13),string);
} else {
if((state_val_66845 === (8))){
var inst_66820 = (state_66844[(2)]);
var inst_66821 = fluree.db.util.async.channel_QMARK_(string);
var state_66844__$1 = (function (){var statearr_66862 = state_66844;
(statearr_66862[(7)] = inst_66820);

return statearr_66862;
})();
if(inst_66821){
var statearr_66863_66881 = state_66844__$1;
(statearr_66863_66881[(1)] = (10));

} else {
var statearr_66864_66882 = state_66844__$1;
(statearr_66864_66882[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_66865 = [null,null,null,null,null,null,null,null,null];
(statearr_66865[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_66865[(1)] = (1));

return statearr_66865;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_66844){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66844);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66866){var ex__2730__auto__ = e66866;
var statearr_66867_66883 = state_66844;
(statearr_66867_66883[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66844[(4)]))){
var statearr_66868_66884 = state_66844;
(statearr_66868_66884[(1)] = cljs.core.first((state_66844[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66885 = state_66844;
state_66844 = G__66885;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_66844){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_66844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66869 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66869[(6)] = c__2749__auto__);

return statearr_66869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66912){
var state_val_66913 = (state_66912[(1)]);
if((state_val_66913 === (7))){
var state_66912__$1 = state_66912;
var statearr_66914_66933 = state_66912__$1;
(statearr_66914_66933[(2)] = email);

(statearr_66914_66933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66913 === (1))){
var state_66912__$1 = state_66912;
var statearr_66915_66934 = state_66912__$1;
(statearr_66915_66934[(2)] = null);

(statearr_66915_66934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66913 === (4))){
var inst_66886 = (state_66912[(2)]);
var state_66912__$1 = state_66912;
var statearr_66916_66935 = state_66912__$1;
(statearr_66916_66935[(2)] = inst_66886);

(statearr_66916_66935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66913 === (6))){
var state_66912__$1 = state_66912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66912__$1,(9),email);
} else {
if((state_val_66913 === (3))){
var inst_66910 = (state_66912[(2)]);
var state_66912__$1 = state_66912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66912__$1,inst_66910);
} else {
if((state_val_66913 === (2))){
var _ = (function (){var statearr_66918 = state_66912;
(statearr_66918[(4)] = cljs.core.cons((5),(state_66912[(4)])));

return statearr_66918;
})();
var inst_66892 = fluree.db.util.async.channel_QMARK_(email);
var state_66912__$1 = state_66912;
if(inst_66892){
var statearr_66919_66936 = state_66912__$1;
(statearr_66919_66936[(1)] = (6));

} else {
var statearr_66920_66937 = state_66912__$1;
(statearr_66920_66937[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66913 === (9))){
var inst_66895 = (state_66912[(2)]);
var inst_66896 = fluree.db.util.async.throw_err(inst_66895);
var state_66912__$1 = state_66912;
var statearr_66921_66938 = state_66912__$1;
(statearr_66921_66938[(2)] = inst_66896);

(statearr_66921_66938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66913 === (5))){
var _ = (function (){var statearr_66922 = state_66912;
(statearr_66922[(4)] = cljs.core.rest((state_66912[(4)])));

return statearr_66922;
})();
var state_66912__$1 = state_66912;
var ex66917 = (state_66912__$1[(2)]);
var statearr_66923_66939 = state_66912__$1;
(statearr_66923_66939[(5)] = ex66917);


if((ex66917 instanceof Error)){
var statearr_66924_66940 = state_66912__$1;
(statearr_66924_66940[(1)] = (4));

(statearr_66924_66940[(5)] = null);

} else {
throw ex66917;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66913 === (8))){
var inst_66899 = (state_66912[(2)]);
var inst_66900 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_66899);
var inst_66901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66902 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66903 = ["re-find",inst_66899,inst_66900];
var inst_66904 = cljs.core.PersistentHashMap.fromArrays(inst_66902,inst_66903);
var inst_66905 = [inst_66904,(10)];
var inst_66906 = (new cljs.core.PersistentVector(null,2,(5),inst_66901,inst_66905,null));
var inst_66907 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66906);
var _ = (function (){var statearr_66925 = state_66912;
(statearr_66925[(4)] = cljs.core.rest((state_66912[(4)])));

return statearr_66925;
})();
var state_66912__$1 = (function (){var statearr_66926 = state_66912;
(statearr_66926[(7)] = inst_66907);

return statearr_66926;
})();
var statearr_66927_66941 = state_66912__$1;
(statearr_66927_66941[(2)] = inst_66900);

(statearr_66927_66941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_66928 = [null,null,null,null,null,null,null,null];
(statearr_66928[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_66928[(1)] = (1));

return statearr_66928;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_66912){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66912);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66929){var ex__2730__auto__ = e66929;
var statearr_66930_66942 = state_66912;
(statearr_66930_66942[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66912[(4)]))){
var statearr_66931_66943 = state_66912;
(statearr_66931_66943[(1)] = cljs.core.first((state_66912[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66944 = state_66912;
state_66912 = G__66944;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_66912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_66912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66932 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66932[(6)] = c__2749__auto__);

return statearr_66932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66991){
var state_val_66992 = (state_66991[(1)]);
if((state_val_66992 === (7))){
var inst_66961 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66991__$1 = state_66991;
if(cljs.core.truth_(inst_66961)){
var statearr_66993_67020 = state_66991__$1;
(statearr_66993_67020[(1)] = (9));

} else {
var statearr_66994_67021 = state_66991__$1;
(statearr_66994_67021[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (1))){
var state_66991__$1 = state_66991;
var statearr_66995_67022 = state_66991__$1;
(statearr_66995_67022[(2)] = null);

(statearr_66995_67022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (4))){
var inst_66945 = (state_66991[(2)]);
var state_66991__$1 = state_66991;
var statearr_66996_67023 = state_66991__$1;
(statearr_66996_67023[(2)] = inst_66945);

(statearr_66996_67023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (15))){
var inst_66972 = (state_66991[(2)]);
var state_66991__$1 = state_66991;
var statearr_66997_67024 = state_66991__$1;
(statearr_66997_67024[(2)] = inst_66972);

(statearr_66997_67024[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (13))){
var inst_66969 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_66991__$1 = state_66991;
var statearr_66998_67025 = state_66991__$1;
(statearr_66998_67025[(2)] = inst_66969);

(statearr_66998_67025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (6))){
var inst_66956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66957 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66958 = [inst_66957,(0)];
var inst_66959 = (new cljs.core.PersistentVector(null,2,(5),inst_66956,inst_66958,null));
var state_66991__$1 = state_66991;
var statearr_66999_67026 = state_66991__$1;
(statearr_66999_67026[(2)] = inst_66959);

(statearr_66999_67026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (3))){
var inst_66989 = (state_66991[(2)]);
var state_66991__$1 = state_66991;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66991__$1,inst_66989);
} else {
if((state_val_66992 === (12))){
var inst_66965 = (state_66991[(2)]);
var inst_66966 = fluree.db.util.async.throw_err(inst_66965);
var state_66991__$1 = state_66991;
var statearr_67000_67027 = state_66991__$1;
(statearr_67000_67027[(2)] = inst_66966);

(statearr_67000_67027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (2))){
var _ = (function (){var statearr_67001 = state_66991;
(statearr_67001[(4)] = cljs.core.cons((5),(state_66991[(4)])));

return statearr_67001;
})();
var inst_66954 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66991__$1 = state_66991;
if(cljs.core.truth_(inst_66954)){
var statearr_67002_67028 = state_66991__$1;
(statearr_67002_67028[(1)] = (6));

} else {
var statearr_67003_67029 = state_66991__$1;
(statearr_67003_67029[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (11))){
var inst_66974 = (state_66991[(2)]);
var state_66991__$1 = state_66991;
var statearr_67005_67030 = state_66991__$1;
(statearr_67005_67030[(2)] = inst_66974);

(statearr_67005_67030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (9))){
var inst_66963 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_66991__$1 = state_66991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66991__$1,(12),inst_66963);
} else {
if((state_val_66992 === (5))){
var _ = (function (){var statearr_67006 = state_66991;
(statearr_67006[(4)] = cljs.core.rest((state_66991[(4)])));

return statearr_67006;
})();
var state_66991__$1 = state_66991;
var ex67004 = (state_66991__$1[(2)]);
var statearr_67007_67031 = state_66991__$1;
(statearr_67007_67031[(5)] = ex67004);


if((ex67004 instanceof Error)){
var statearr_67008_67032 = state_66991__$1;
(statearr_67008_67032[(1)] = (4));

(statearr_67008_67032[(5)] = null);

} else {
throw ex67004;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (14))){
var state_66991__$1 = state_66991;
var statearr_67009_67033 = state_66991__$1;
(statearr_67009_67033[(2)] = null);

(statearr_67009_67033[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (10))){
var state_66991__$1 = state_66991;
var statearr_67010_67034 = state_66991__$1;
(statearr_67010_67034[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66992 === (8))){
var inst_66976 = (state_66991[(2)]);
var inst_66977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66976,(0),null);
var inst_66978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66976,(1),null);
var inst_66979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66980 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66981 = ["?user_id","?ctx",inst_66977];
var inst_66982 = cljs.core.PersistentHashMap.fromArrays(inst_66980,inst_66981);
var inst_66983 = ((10) + inst_66978);
var inst_66984 = [inst_66982,inst_66983];
var inst_66985 = (new cljs.core.PersistentVector(null,2,(5),inst_66979,inst_66984,null));
var inst_66986 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66985);
var _ = (function (){var statearr_67012 = state_66991;
(statearr_67012[(4)] = cljs.core.rest((state_66991[(4)])));

return statearr_67012;
})();
var state_66991__$1 = (function (){var statearr_67013 = state_66991;
(statearr_67013[(7)] = inst_66986);

return statearr_67013;
})();
var statearr_67014_67035 = state_66991__$1;
(statearr_67014_67035[(2)] = inst_66977);

(statearr_67014_67035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_67015 = [null,null,null,null,null,null,null,null];
(statearr_67015[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_67015[(1)] = (1));

return statearr_67015;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_66991){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66991);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67016){var ex__2730__auto__ = e67016;
var statearr_67017_67036 = state_66991;
(statearr_67017_67036[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66991[(4)]))){
var statearr_67018_67037 = state_66991;
(statearr_67018_67037[(1)] = cljs.core.first((state_66991[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67038 = state_66991;
state_66991 = G__67038;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_66991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_66991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67019 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67019[(6)] = c__2749__auto__);

return statearr_67019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67066){
var state_val_67067 = (state_67066[(1)]);
if((state_val_67067 === (7))){
var inst_67059 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_67066__$1 = state_67066;
var statearr_67068_67087 = state_67066__$1;
(statearr_67068_67087[(2)] = inst_67059);

(statearr_67068_67087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67067 === (1))){
var state_67066__$1 = state_67066;
var statearr_67069_67088 = state_67066__$1;
(statearr_67069_67088[(2)] = null);

(statearr_67069_67088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67067 === (4))){
var inst_67039 = (state_67066[(2)]);
var state_67066__$1 = state_67066;
var statearr_67070_67089 = state_67066__$1;
(statearr_67070_67089[(2)] = inst_67039);

(statearr_67070_67089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67067 === (6))){
var inst_67047 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_67066__$1 = state_67066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67066__$1,(9),inst_67047);
} else {
if((state_val_67067 === (3))){
var inst_67064 = (state_67066[(2)]);
var state_67066__$1 = state_67066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67066__$1,inst_67064);
} else {
if((state_val_67067 === (2))){
var _ = (function (){var statearr_67072 = state_67066;
(statearr_67072[(4)] = cljs.core.cons((5),(state_67066[(4)])));

return statearr_67072;
})();
var inst_67045 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67066__$1 = state_67066;
if(cljs.core.truth_(inst_67045)){
var statearr_67073_67090 = state_67066__$1;
(statearr_67073_67090[(1)] = (6));

} else {
var statearr_67074_67091 = state_67066__$1;
(statearr_67074_67091[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67067 === (9))){
var inst_67049 = (state_67066[(2)]);
var inst_67050 = fluree.db.util.async.throw_err(inst_67049);
var inst_67051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67052 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67053 = ["?auth_id","?ctx",inst_67050];
var inst_67054 = cljs.core.PersistentHashMap.fromArrays(inst_67052,inst_67053);
var inst_67055 = [inst_67054,(10)];
var inst_67056 = (new cljs.core.PersistentVector(null,2,(5),inst_67051,inst_67055,null));
var inst_67057 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67056);
var state_67066__$1 = (function (){var statearr_67075 = state_67066;
(statearr_67075[(7)] = inst_67057);

return statearr_67075;
})();
var statearr_67076_67092 = state_67066__$1;
(statearr_67076_67092[(2)] = inst_67050);

(statearr_67076_67092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67067 === (5))){
var _ = (function (){var statearr_67077 = state_67066;
(statearr_67077[(4)] = cljs.core.rest((state_67066[(4)])));

return statearr_67077;
})();
var state_67066__$1 = state_67066;
var ex67071 = (state_67066__$1[(2)]);
var statearr_67078_67093 = state_67066__$1;
(statearr_67078_67093[(5)] = ex67071);


if((ex67071 instanceof Error)){
var statearr_67079_67094 = state_67066__$1;
(statearr_67079_67094[(1)] = (4));

(statearr_67079_67094[(5)] = null);

} else {
throw ex67071;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67067 === (8))){
var inst_67061 = (state_67066[(2)]);
var _ = (function (){var statearr_67080 = state_67066;
(statearr_67080[(4)] = cljs.core.rest((state_67066[(4)])));

return statearr_67080;
})();
var state_67066__$1 = state_67066;
var statearr_67081_67095 = state_67066__$1;
(statearr_67081_67095[(2)] = inst_67061);

(statearr_67081_67095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_67082 = [null,null,null,null,null,null,null,null];
(statearr_67082[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_67082[(1)] = (1));

return statearr_67082;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_67066){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67066);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67083){var ex__2730__auto__ = e67083;
var statearr_67084_67096 = state_67066;
(statearr_67084_67096[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67066[(4)]))){
var statearr_67085_67097 = state_67066;
(statearr_67085_67097[(1)] = cljs.core.first((state_67066[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67098 = state_67066;
state_67066 = G__67098;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_67066){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_67066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67086 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67086[(6)] = c__2749__auto__);

return statearr_67086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__67100 = arguments.length;
switch (G__67100) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67142){
var state_val_67143 = (state_67142[(1)]);
if((state_val_67143 === (7))){
var state_67142__$1 = state_67142;
var statearr_67144_67174 = state_67142__$1;
(statearr_67144_67174[(2)] = seed);

(statearr_67144_67174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (1))){
var state_67142__$1 = state_67142;
var statearr_67145_67175 = state_67142__$1;
(statearr_67145_67175[(2)] = null);

(statearr_67145_67175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (4))){
var inst_67101 = (state_67142[(2)]);
var state_67142__$1 = state_67142;
var statearr_67146_67176 = state_67142__$1;
(statearr_67146_67176[(2)] = inst_67101);

(statearr_67146_67176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (15))){
var state_67142__$1 = state_67142;
var statearr_67147_67177 = state_67142__$1;
(statearr_67147_67177[(2)] = (10));

(statearr_67147_67177[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (13))){
var inst_67118 = (state_67142[(2)]);
var inst_67119 = fluree.db.util.async.throw_err(inst_67118);
var state_67142__$1 = state_67142;
var statearr_67148_67178 = state_67142__$1;
(statearr_67148_67178[(2)] = inst_67119);

(statearr_67148_67178[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (6))){
var state_67142__$1 = state_67142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67142__$1,(9),seed);
} else {
if((state_val_67143 === (3))){
var inst_67140 = (state_67142[(2)]);
var state_67142__$1 = state_67142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67142__$1,inst_67140);
} else {
if((state_val_67143 === (12))){
var inst_67122 = (state_67142[(7)]);
var inst_67122__$1 = (state_67142[(2)]);
var state_67142__$1 = (function (){var statearr_67149 = state_67142;
(statearr_67149[(7)] = inst_67122__$1);

return statearr_67149;
})();
if(cljs.core.truth_(inst_67122__$1)){
var statearr_67150_67179 = state_67142__$1;
(statearr_67150_67179[(1)] = (14));

} else {
var statearr_67151_67180 = state_67142__$1;
(statearr_67151_67180[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (2))){
var _ = (function (){var statearr_67152 = state_67142;
(statearr_67152[(4)] = cljs.core.cons((5),(state_67142[(4)])));

return statearr_67152;
})();
var inst_67107 = fluree.db.util.async.channel_QMARK_(seed);
var state_67142__$1 = state_67142;
if(inst_67107){
var statearr_67153_67181 = state_67142__$1;
(statearr_67153_67181[(1)] = (6));

} else {
var statearr_67154_67182 = state_67142__$1;
(statearr_67154_67182[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (11))){
var state_67142__$1 = state_67142;
var statearr_67156_67183 = state_67142__$1;
(statearr_67156_67183[(2)] = max);

(statearr_67156_67183[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (9))){
var inst_67110 = (state_67142[(2)]);
var inst_67111 = fluree.db.util.async.throw_err(inst_67110);
var state_67142__$1 = state_67142;
var statearr_67157_67184 = state_67142__$1;
(statearr_67157_67184[(2)] = inst_67111);

(statearr_67157_67184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (5))){
var _ = (function (){var statearr_67158 = state_67142;
(statearr_67158[(4)] = cljs.core.rest((state_67142[(4)])));

return statearr_67158;
})();
var state_67142__$1 = state_67142;
var ex67155 = (state_67142__$1[(2)]);
var statearr_67159_67185 = state_67142__$1;
(statearr_67159_67185[(5)] = ex67155);


if((ex67155 instanceof Error)){
var statearr_67160_67186 = state_67142__$1;
(statearr_67160_67186[(1)] = (4));

(statearr_67160_67186[(5)] = null);

} else {
throw ex67155;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (14))){
var inst_67122 = (state_67142[(7)]);
var state_67142__$1 = state_67142;
var statearr_67161_67187 = state_67142__$1;
(statearr_67161_67187[(2)] = inst_67122);

(statearr_67161_67187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (16))){
var inst_67114 = (state_67142[(8)]);
var inst_67126 = (state_67142[(2)]);
var inst_67127 = fluree.db.dbfunctions.internal.rand(inst_67114,inst_67126);
var inst_67128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67129 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67131 = [max,seed];
var inst_67132 = (new cljs.core.PersistentVector(null,2,(5),inst_67130,inst_67131,null));
var inst_67133 = ["rand",inst_67132,inst_67127];
var inst_67134 = cljs.core.PersistentHashMap.fromArrays(inst_67129,inst_67133);
var inst_67135 = [inst_67134,(10)];
var inst_67136 = (new cljs.core.PersistentVector(null,2,(5),inst_67128,inst_67135,null));
var inst_67137 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67136);
var _ = (function (){var statearr_67162 = state_67142;
(statearr_67162[(4)] = cljs.core.rest((state_67142[(4)])));

return statearr_67162;
})();
var state_67142__$1 = (function (){var statearr_67163 = state_67142;
(statearr_67163[(9)] = inst_67137);

return statearr_67163;
})();
var statearr_67164_67188 = state_67142__$1;
(statearr_67164_67188[(2)] = inst_67127);

(statearr_67164_67188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67143 === (10))){
var state_67142__$1 = state_67142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67142__$1,(13),max);
} else {
if((state_val_67143 === (8))){
var inst_67114 = (state_67142[(2)]);
var inst_67115 = fluree.db.util.async.channel_QMARK_(max);
var state_67142__$1 = (function (){var statearr_67165 = state_67142;
(statearr_67165[(8)] = inst_67114);

return statearr_67165;
})();
if(inst_67115){
var statearr_67166_67189 = state_67142__$1;
(statearr_67166_67189[(1)] = (10));

} else {
var statearr_67167_67190 = state_67142__$1;
(statearr_67167_67190[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_67168 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67168[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_67168[(1)] = (1));

return statearr_67168;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_67142){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67142);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67169){var ex__2730__auto__ = e67169;
var statearr_67170_67191 = state_67142;
(statearr_67170_67191[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67142[(4)]))){
var statearr_67171_67192 = state_67142;
(statearr_67171_67192[(1)] = cljs.core.first((state_67142[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67193 = state_67142;
state_67142 = G__67193;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_67142){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_67142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67172 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67172[(6)] = c__2749__auto__);

return statearr_67172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67214){
var state_val_67215 = (state_67214[(1)]);
if((state_val_67215 === (1))){
var state_67214__$1 = state_67214;
var statearr_67216_67231 = state_67214__$1;
(statearr_67216_67231[(2)] = null);

(statearr_67216_67231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67215 === (2))){
var _ = (function (){var statearr_67217 = state_67214;
(statearr_67217[(4)] = cljs.core.cons((5),(state_67214[(4)])));

return statearr_67217;
})();
var inst_67200 = cljs.core.random_uuid();
var inst_67201 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67200);
var inst_67202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67203 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67204 = cljs.core.PersistentVector.EMPTY;
var inst_67205 = ["uuid",inst_67204,inst_67201];
var inst_67206 = cljs.core.PersistentHashMap.fromArrays(inst_67203,inst_67205);
var inst_67207 = [inst_67206,(10)];
var inst_67208 = (new cljs.core.PersistentVector(null,2,(5),inst_67202,inst_67207,null));
var inst_67209 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67208);
var ___$1 = (function (){var statearr_67218 = state_67214;
(statearr_67218[(4)] = cljs.core.rest((state_67214[(4)])));

return statearr_67218;
})();
var state_67214__$1 = (function (){var statearr_67219 = state_67214;
(statearr_67219[(7)] = inst_67209);

return statearr_67219;
})();
var statearr_67220_67232 = state_67214__$1;
(statearr_67220_67232[(2)] = inst_67201);

(statearr_67220_67232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67215 === (3))){
var inst_67212 = (state_67214[(2)]);
var state_67214__$1 = state_67214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67214__$1,inst_67212);
} else {
if((state_val_67215 === (4))){
var inst_67194 = (state_67214[(2)]);
var state_67214__$1 = state_67214;
var statearr_67222_67233 = state_67214__$1;
(statearr_67222_67233[(2)] = inst_67194);

(statearr_67222_67233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67215 === (5))){
var _ = (function (){var statearr_67223 = state_67214;
(statearr_67223[(4)] = cljs.core.rest((state_67214[(4)])));

return statearr_67223;
})();
var state_67214__$1 = state_67214;
var ex67221 = (state_67214__$1[(2)]);
var statearr_67224_67234 = state_67214__$1;
(statearr_67224_67234[(5)] = ex67221);


if((ex67221 instanceof Error)){
var statearr_67225_67235 = state_67214__$1;
(statearr_67225_67235[(1)] = (4));

(statearr_67225_67235[(5)] = null);

} else {
throw ex67221;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_67226 = [null,null,null,null,null,null,null,null];
(statearr_67226[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_67226[(1)] = (1));

return statearr_67226;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_67214){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67214);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67227){var ex__2730__auto__ = e67227;
var statearr_67228_67236 = state_67214;
(statearr_67228_67236[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67214[(4)]))){
var statearr_67229_67237 = state_67214;
(statearr_67229_67237[(1)] = cljs.core.first((state_67214[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67238 = state_67214;
state_67214 = G__67238;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_67214){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_67214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67230 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67230[(6)] = c__2749__auto__);

return statearr_67230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67268){
var state_val_67269 = (state_67268[(1)]);
if((state_val_67269 === (7))){
var state_67268__$1 = state_67268;
var statearr_67270_67289 = state_67268__$1;
(statearr_67270_67289[(2)] = num);

(statearr_67270_67289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67269 === (1))){
var state_67268__$1 = state_67268;
var statearr_67271_67290 = state_67268__$1;
(statearr_67271_67290[(2)] = null);

(statearr_67271_67290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67269 === (4))){
var inst_67239 = (state_67268[(2)]);
var state_67268__$1 = state_67268;
var statearr_67272_67291 = state_67268__$1;
(statearr_67272_67291[(2)] = inst_67239);

(statearr_67272_67291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67269 === (6))){
var state_67268__$1 = state_67268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67268__$1,(9),num);
} else {
if((state_val_67269 === (3))){
var inst_67266 = (state_67268[(2)]);
var state_67268__$1 = state_67268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67268__$1,inst_67266);
} else {
if((state_val_67269 === (2))){
var _ = (function (){var statearr_67274 = state_67268;
(statearr_67274[(4)] = cljs.core.cons((5),(state_67268[(4)])));

return statearr_67274;
})();
var inst_67245 = fluree.db.util.async.channel_QMARK_(num);
var state_67268__$1 = state_67268;
if(inst_67245){
var statearr_67275_67292 = state_67268__$1;
(statearr_67275_67292[(1)] = (6));

} else {
var statearr_67276_67293 = state_67268__$1;
(statearr_67276_67293[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67269 === (9))){
var inst_67248 = (state_67268[(2)]);
var inst_67249 = fluree.db.util.async.throw_err(inst_67248);
var state_67268__$1 = state_67268;
var statearr_67277_67294 = state_67268__$1;
(statearr_67277_67294[(2)] = inst_67249);

(statearr_67277_67294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67269 === (5))){
var _ = (function (){var statearr_67278 = state_67268;
(statearr_67278[(4)] = cljs.core.rest((state_67268[(4)])));

return statearr_67278;
})();
var state_67268__$1 = state_67268;
var ex67273 = (state_67268__$1[(2)]);
var statearr_67279_67295 = state_67268__$1;
(statearr_67279_67295[(5)] = ex67273);


if((ex67273 instanceof Error)){
var statearr_67280_67296 = state_67268__$1;
(statearr_67280_67296[(1)] = (4));

(statearr_67280_67296[(5)] = null);

} else {
throw ex67273;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67269 === (8))){
var inst_67252 = (state_67268[(2)]);
var inst_67253 = fluree.db.dbfunctions.internal.ceil(inst_67252);
var inst_67254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67255 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67257 = [fluree.db.dbfunctions.fns.ceil];
var inst_67258 = (new cljs.core.PersistentVector(null,1,(5),inst_67256,inst_67257,null));
var inst_67259 = ["",inst_67258,inst_67253];
var inst_67260 = cljs.core.PersistentHashMap.fromArrays(inst_67255,inst_67259);
var inst_67261 = [inst_67260,(10)];
var inst_67262 = (new cljs.core.PersistentVector(null,2,(5),inst_67254,inst_67261,null));
var inst_67263 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67262);
var _ = (function (){var statearr_67281 = state_67268;
(statearr_67281[(4)] = cljs.core.rest((state_67268[(4)])));

return statearr_67281;
})();
var state_67268__$1 = (function (){var statearr_67282 = state_67268;
(statearr_67282[(7)] = inst_67263);

return statearr_67282;
})();
var statearr_67283_67297 = state_67268__$1;
(statearr_67283_67297[(2)] = inst_67253);

(statearr_67283_67297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_67284 = [null,null,null,null,null,null,null,null];
(statearr_67284[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_67284[(1)] = (1));

return statearr_67284;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_67268){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67268);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67285){var ex__2730__auto__ = e67285;
var statearr_67286_67298 = state_67268;
(statearr_67286_67298[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67268[(4)]))){
var statearr_67287_67299 = state_67268;
(statearr_67287_67299[(1)] = cljs.core.first((state_67268[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67300 = state_67268;
state_67268 = G__67300;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_67268){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_67268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67288 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67288[(6)] = c__2749__auto__);

return statearr_67288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67330){
var state_val_67331 = (state_67330[(1)]);
if((state_val_67331 === (7))){
var state_67330__$1 = state_67330;
var statearr_67332_67351 = state_67330__$1;
(statearr_67332_67351[(2)] = num);

(statearr_67332_67351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67331 === (1))){
var state_67330__$1 = state_67330;
var statearr_67333_67352 = state_67330__$1;
(statearr_67333_67352[(2)] = null);

(statearr_67333_67352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67331 === (4))){
var inst_67301 = (state_67330[(2)]);
var state_67330__$1 = state_67330;
var statearr_67334_67353 = state_67330__$1;
(statearr_67334_67353[(2)] = inst_67301);

(statearr_67334_67353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67331 === (6))){
var state_67330__$1 = state_67330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67330__$1,(9),num);
} else {
if((state_val_67331 === (3))){
var inst_67328 = (state_67330[(2)]);
var state_67330__$1 = state_67330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67330__$1,inst_67328);
} else {
if((state_val_67331 === (2))){
var _ = (function (){var statearr_67336 = state_67330;
(statearr_67336[(4)] = cljs.core.cons((5),(state_67330[(4)])));

return statearr_67336;
})();
var inst_67307 = fluree.db.util.async.channel_QMARK_(num);
var state_67330__$1 = state_67330;
if(inst_67307){
var statearr_67337_67354 = state_67330__$1;
(statearr_67337_67354[(1)] = (6));

} else {
var statearr_67338_67355 = state_67330__$1;
(statearr_67338_67355[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67331 === (9))){
var inst_67310 = (state_67330[(2)]);
var inst_67311 = fluree.db.util.async.throw_err(inst_67310);
var state_67330__$1 = state_67330;
var statearr_67339_67356 = state_67330__$1;
(statearr_67339_67356[(2)] = inst_67311);

(statearr_67339_67356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67331 === (5))){
var _ = (function (){var statearr_67340 = state_67330;
(statearr_67340[(4)] = cljs.core.rest((state_67330[(4)])));

return statearr_67340;
})();
var state_67330__$1 = state_67330;
var ex67335 = (state_67330__$1[(2)]);
var statearr_67341_67357 = state_67330__$1;
(statearr_67341_67357[(5)] = ex67335);


if((ex67335 instanceof Error)){
var statearr_67342_67358 = state_67330__$1;
(statearr_67342_67358[(1)] = (4));

(statearr_67342_67358[(5)] = null);

} else {
throw ex67335;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67331 === (8))){
var inst_67314 = (state_67330[(2)]);
var inst_67315 = fluree.db.dbfunctions.internal.floor(inst_67314);
var inst_67316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67317 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67319 = [fluree.db.dbfunctions.fns.floor];
var inst_67320 = (new cljs.core.PersistentVector(null,1,(5),inst_67318,inst_67319,null));
var inst_67321 = ["",inst_67320,inst_67315];
var inst_67322 = cljs.core.PersistentHashMap.fromArrays(inst_67317,inst_67321);
var inst_67323 = [inst_67322,(10)];
var inst_67324 = (new cljs.core.PersistentVector(null,2,(5),inst_67316,inst_67323,null));
var inst_67325 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67324);
var _ = (function (){var statearr_67343 = state_67330;
(statearr_67343[(4)] = cljs.core.rest((state_67330[(4)])));

return statearr_67343;
})();
var state_67330__$1 = (function (){var statearr_67344 = state_67330;
(statearr_67344[(7)] = inst_67325);

return statearr_67344;
})();
var statearr_67345_67359 = state_67330__$1;
(statearr_67345_67359[(2)] = inst_67315);

(statearr_67345_67359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_67346 = [null,null,null,null,null,null,null,null];
(statearr_67346[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_67346[(1)] = (1));

return statearr_67346;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_67330){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67330);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67347){var ex__2730__auto__ = e67347;
var statearr_67348_67360 = state_67330;
(statearr_67348_67360[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67330[(4)]))){
var statearr_67349_67361 = state_67330;
(statearr_67349_67361[(1)] = cljs.core.first((state_67330[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67362 = state_67330;
state_67330 = G__67362;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_67330){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_67330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67350 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67350[(6)] = c__2749__auto__);

return statearr_67350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67387){
var state_val_67388 = (state_67387[(1)]);
if((state_val_67388 === (1))){
var state_67387__$1 = state_67387;
var statearr_67389_67404 = state_67387__$1;
(statearr_67389_67404[(2)] = null);

(statearr_67389_67404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67388 === (2))){
var _ = (function (){var statearr_67390 = state_67387;
(statearr_67390[(4)] = cljs.core.cons((5),(state_67387[(4)])));

return statearr_67390;
})();
var inst_67369 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_67387__$1 = state_67387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67387__$1,(6),inst_67369);
} else {
if((state_val_67388 === (3))){
var inst_67385 = (state_67387[(2)]);
var state_67387__$1 = state_67387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67387__$1,inst_67385);
} else {
if((state_val_67388 === (4))){
var inst_67363 = (state_67387[(2)]);
var state_67387__$1 = state_67387;
var statearr_67392_67405 = state_67387__$1;
(statearr_67392_67405[(2)] = inst_67363);

(statearr_67392_67405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67388 === (5))){
var _ = (function (){var statearr_67393 = state_67387;
(statearr_67393[(4)] = cljs.core.rest((state_67387[(4)])));

return statearr_67393;
})();
var state_67387__$1 = state_67387;
var ex67391 = (state_67387__$1[(2)]);
var statearr_67394_67406 = state_67387__$1;
(statearr_67394_67406[(5)] = ex67391);


if((ex67391 instanceof Error)){
var statearr_67395_67407 = state_67387__$1;
(statearr_67395_67407[(1)] = (4));

(statearr_67395_67407[(5)] = null);

} else {
throw ex67391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67388 === (6))){
var inst_67371 = (state_67387[(2)]);
var inst_67372 = fluree.db.util.async.throw_err(inst_67371);
var inst_67373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67374 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67376 = [compare_val,new_val];
var inst_67377 = (new cljs.core.PersistentVector(null,2,(5),inst_67375,inst_67376,null));
var inst_67378 = ["",inst_67377,inst_67372];
var inst_67379 = cljs.core.PersistentHashMap.fromArrays(inst_67374,inst_67378);
var inst_67380 = [inst_67379,(10)];
var inst_67381 = (new cljs.core.PersistentVector(null,2,(5),inst_67373,inst_67380,null));
var inst_67382 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67381);
var _ = (function (){var statearr_67396 = state_67387;
(statearr_67396[(4)] = cljs.core.rest((state_67387[(4)])));

return statearr_67396;
})();
var state_67387__$1 = (function (){var statearr_67397 = state_67387;
(statearr_67397[(7)] = inst_67382);

return statearr_67397;
})();
var statearr_67398_67408 = state_67387__$1;
(statearr_67398_67408[(2)] = inst_67372);

(statearr_67398_67408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_67399 = [null,null,null,null,null,null,null,null];
(statearr_67399[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_67399[(1)] = (1));

return statearr_67399;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_67387){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67387);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67400){var ex__2730__auto__ = e67400;
var statearr_67401_67409 = state_67387;
(statearr_67401_67409[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67387[(4)]))){
var statearr_67402_67410 = state_67387;
(statearr_67402_67410[(1)] = cljs.core.first((state_67387[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67411 = state_67387;
state_67387 = G__67411;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_67387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_67387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67403 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67403[(6)] = c__2749__auto__);

return statearr_67403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
