// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___73556 = arguments.length;
var i__5770__auto___73557 = (0);
while(true){
if((i__5770__auto___73557 < len__5769__auto___73556)){
args__5775__auto__.push((arguments[i__5770__auto___73557]));

var G__73558 = (i__5770__auto___73557 + (1));
i__5770__auto___73557 = G__73558;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__73485){
var vec__73486 = p__73485;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73486,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___73559 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73533){
var state_val_73534 = (state_73533[(1)]);
if((state_val_73534 === (7))){
var inst_73519 = (state_73533[(7)]);
var inst_73510 = (state_73533[(8)]);
var inst_73521 = fluree.db.time_travel.as_of_block(inst_73519,inst_73510);
var state_73533__$1 = state_73533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73533__$1,(10),inst_73521);
} else {
if((state_val_73534 === (1))){
var state_73533__$1 = state_73533;
var statearr_73535_73560 = state_73533__$1;
(statearr_73535_73560[(2)] = null);

(statearr_73535_73560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73534 === (4))){
var inst_73489 = (state_73533[(2)]);
var inst_73490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73491 = [inst_73489];
var inst_73492 = (new cljs.core.PersistentVector(null,1,(5),inst_73490,inst_73491,null));
var inst_73493 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73492);
var inst_73494 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73489);
var inst_73495 = cljs.core.async.close_BANG_(pc);
var state_73533__$1 = (function (){var statearr_73536 = state_73533;
(statearr_73536[(9)] = inst_73494);

(statearr_73536[(10)] = inst_73493);

return statearr_73536;
})();
var statearr_73537_73561 = state_73533__$1;
(statearr_73537_73561[(2)] = inst_73495);

(statearr_73537_73561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73534 === (6))){
var inst_73513 = (state_73533[(11)]);
var inst_73514 = (state_73533[(12)]);
var inst_73510 = (state_73533[(8)]);
var inst_73517 = (state_73533[(2)]);
var inst_73518 = fluree.db.util.async.throw_err(inst_73517);
var inst_73519 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_73518,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_73513,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_73514], 0));
var state_73533__$1 = (function (){var statearr_73538 = state_73533;
(statearr_73538[(7)] = inst_73519);

return statearr_73538;
})();
if(cljs.core.truth_(inst_73510)){
var statearr_73539_73562 = state_73533__$1;
(statearr_73539_73562[(1)] = (7));

} else {
var statearr_73540_73563 = state_73533__$1;
(statearr_73540_73563[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73534 === (3))){
var inst_73531 = (state_73533[(2)]);
var state_73533__$1 = state_73533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73533__$1,inst_73531);
} else {
if((state_val_73534 === (2))){
var _ = (function (){var statearr_73542 = state_73533;
(statearr_73542[(4)] = cljs.core.cons((5),(state_73533[(4)])));

return statearr_73542;
})();
var inst_73505 = opts;
var inst_73506 = cljs.core.__destructure_map(inst_73505);
var inst_73507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73506,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_73508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73506,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_73509 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73506,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73510 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73506,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73511 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_73512 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_73513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73512,(0),null);
var inst_73514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73512,(1),null);
var inst_73515 = fluree.db.session.db(conn,ledger,opts);
var state_73533__$1 = (function (){var statearr_73543 = state_73533;
(statearr_73543[(11)] = inst_73513);

(statearr_73543[(13)] = inst_73509);

(statearr_73543[(14)] = inst_73507);

(statearr_73543[(12)] = inst_73514);

(statearr_73543[(8)] = inst_73510);

(statearr_73543[(15)] = inst_73511);

(statearr_73543[(16)] = inst_73508);

return statearr_73543;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73533__$1,(6),inst_73515);
} else {
if((state_val_73534 === (9))){
var inst_73527 = (state_73533[(2)]);
var inst_73528 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73527);
var _ = (function (){var statearr_73544 = state_73533;
(statearr_73544[(4)] = cljs.core.rest((state_73533[(4)])));

return statearr_73544;
})();
var state_73533__$1 = state_73533;
var statearr_73545_73564 = state_73533__$1;
(statearr_73545_73564[(2)] = inst_73528);

(statearr_73545_73564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73534 === (5))){
var _ = (function (){var statearr_73546 = state_73533;
(statearr_73546[(4)] = cljs.core.rest((state_73533[(4)])));

return statearr_73546;
})();
var state_73533__$1 = state_73533;
var ex73541 = (state_73533__$1[(2)]);
var statearr_73547_73565 = state_73533__$1;
(statearr_73547_73565[(5)] = ex73541);


var statearr_73548_73566 = state_73533__$1;
(statearr_73548_73566[(1)] = (4));

(statearr_73548_73566[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73534 === (10))){
var inst_73523 = (state_73533[(2)]);
var inst_73524 = fluree.db.util.async.throw_err(inst_73523);
var state_73533__$1 = state_73533;
var statearr_73549_73567 = state_73533__$1;
(statearr_73549_73567[(2)] = inst_73524);

(statearr_73549_73567[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73534 === (8))){
var inst_73519 = (state_73533[(7)]);
var state_73533__$1 = state_73533;
var statearr_73550_73568 = state_73533__$1;
(statearr_73550_73568[(2)] = inst_73519);

(statearr_73550_73568[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73551[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73551[(1)] = (1));

return statearr_73551;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73533){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73533);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73552){var ex__2730__auto__ = e73552;
var statearr_73553_73569 = state_73533;
(statearr_73553_73569[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73533[(4)]))){
var statearr_73554_73570 = state_73533;
(statearr_73554_73570[(1)] = cljs.core.first((state_73533[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73571 = state_73533;
state_73533 = G__73571;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73533){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73555 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73555[(6)] = c__2749__auto___73559);

return statearr_73555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq73482){
var G__73483 = cljs.core.first(seq73482);
var seq73482__$1 = cljs.core.next(seq73482);
var G__73484 = cljs.core.first(seq73482__$1);
var seq73482__$2 = cljs.core.next(seq73482__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73483,G__73484,seq73482__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,ledger_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__73573 = arguments.length;
switch (G__73573) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73702){
var state_val_73703 = (state_73702[(1)]);
if((state_val_73703 === (7))){
var inst_73602 = (state_73702[(7)]);
var inst_73592 = (state_73702[(8)]);
var inst_73604 = fluree.db.time_travel.as_of_block(inst_73602,inst_73592);
var state_73702__$1 = state_73702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73702__$1,(10),inst_73604);
} else {
if((state_val_73703 === (20))){
var inst_73596 = (state_73702[(9)]);
var state_73702__$1 = state_73702;
var statearr_73704_73784 = state_73702__$1;
(statearr_73704_73784[(2)] = inst_73596);

(statearr_73704_73784[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (27))){
var inst_73590 = (state_73702[(10)]);
var state_73702__$1 = state_73702;
var statearr_73705_73785 = state_73702__$1;
(statearr_73705_73785[(2)] = inst_73590);

(statearr_73705_73785[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (1))){
var state_73702__$1 = state_73702;
var statearr_73706_73786 = state_73702__$1;
(statearr_73706_73786[(2)] = null);

(statearr_73706_73786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (24))){
var inst_73599 = (state_73702[(11)]);
var state_73702__$1 = state_73702;
if(cljs.core.truth_(inst_73599)){
var statearr_73707_73787 = state_73702__$1;
(statearr_73707_73787[(1)] = (26));

} else {
var statearr_73708_73788 = state_73702__$1;
(statearr_73708_73788[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (39))){
var inst_73664 = (state_73702[(12)]);
var inst_73667 = cljs.core.ex_data(inst_73664);
var inst_73668 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73669 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73667);
var inst_73670 = cljs.core.ex_message(inst_73664);
var inst_73671 = [inst_73669,inst_73670,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73672 = cljs.core.PersistentHashMap.fromArrays(inst_73668,inst_73671);
var state_73702__$1 = state_73702;
var statearr_73709_73789 = state_73702__$1;
(statearr_73709_73789[(2)] = inst_73672);

(statearr_73709_73789[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (46))){
var inst_73664 = (state_73702[(12)]);
var state_73702__$1 = state_73702;
var statearr_73710_73790 = state_73702__$1;
(statearr_73710_73790[(2)] = inst_73664);

(statearr_73710_73790[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (4))){
var inst_73574 = (state_73702[(2)]);
var inst_73575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73576 = [inst_73574];
var inst_73577 = (new cljs.core.PersistentVector(null,1,(5),inst_73575,inst_73576,null));
var inst_73578 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73577);
var inst_73579 = cljs.core.ex_data(inst_73574);
var inst_73580 = cljs.core.ex_message(inst_73574);
var inst_73581 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73579,new cljs.core.Keyword(null,"message","message",-406056002),inst_73580);
var state_73702__$1 = (function (){var statearr_73711 = state_73702;
(statearr_73711[(13)] = inst_73578);

return statearr_73711;
})();
var statearr_73712_73791 = state_73702__$1;
(statearr_73712_73791[(2)] = inst_73581);

(statearr_73712_73791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (15))){
var state_73702__$1 = state_73702;
var statearr_73713_73792 = state_73702__$1;
(statearr_73713_73792[(2)] = (1000000));

(statearr_73713_73792[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (48))){
var inst_73664 = (state_73702[(12)]);
var state_73702__$1 = state_73702;
var statearr_73714_73793 = state_73702__$1;
(statearr_73714_73793[(2)] = inst_73664);

(statearr_73714_73793[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (50))){
var inst_73691 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73715_73794 = state_73702__$1;
(statearr_73715_73794[(2)] = inst_73691);

(statearr_73715_73794[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (21))){
var inst_73595 = (state_73702[(14)]);
var state_73702__$1 = state_73702;
if(cljs.core.truth_(inst_73595)){
var statearr_73716_73795 = state_73702__$1;
(statearr_73716_73795[(1)] = (23));

} else {
var statearr_73717_73796 = state_73702__$1;
(statearr_73717_73796[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (31))){
var inst_73653 = (state_73702[(2)]);
var inst_73654 = cljs.core.not(inst_73653);
var state_73702__$1 = state_73702;
if(inst_73654){
var statearr_73718_73797 = state_73702__$1;
(statearr_73718_73797[(1)] = (35));

} else {
var statearr_73719_73798 = state_73702__$1;
(statearr_73719_73798[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (32))){
var inst_73597 = (state_73702[(15)]);
var state_73702__$1 = state_73702;
var statearr_73720_73799 = state_73702__$1;
(statearr_73720_73799[(2)] = inst_73597);

(statearr_73720_73799[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (40))){
var inst_73627 = (state_73702[(16)]);
var state_73702__$1 = state_73702;
if(cljs.core.truth_(inst_73627)){
var statearr_73721_73800 = state_73702__$1;
(statearr_73721_73800[(1)] = (42));

} else {
var statearr_73722_73801 = state_73702__$1;
(statearr_73722_73801[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (33))){
var inst_73593 = (state_73702[(17)]);
var state_73702__$1 = state_73702;
var statearr_73723_73802 = state_73702__$1;
(statearr_73723_73802[(2)] = inst_73593);

(statearr_73723_73802[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (13))){
var inst_73622 = (state_73702[(18)]);
var inst_73598 = (state_73702[(19)]);
var inst_73620 = (state_73702[(2)]);
var inst_73621 = cljs.core.volatile_BANG_((0));
var inst_73622__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_73598);
var state_73702__$1 = (function (){var statearr_73724 = state_73702;
(statearr_73724[(20)] = inst_73620);

(statearr_73724[(18)] = inst_73622__$1);

(statearr_73724[(21)] = inst_73621);

return statearr_73724;
})();
if(cljs.core.truth_(inst_73622__$1)){
var statearr_73725_73803 = state_73702__$1;
(statearr_73725_73803[(1)] = (14));

} else {
var statearr_73726_73804 = state_73702__$1;
(statearr_73726_73804[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (22))){
var inst_73643 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73727_73805 = state_73702__$1;
(statearr_73727_73805[(2)] = inst_73643);

(statearr_73727_73805[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (36))){
var inst_73629 = (state_73702[(22)]);
var inst_73610 = (state_73702[(23)]);
var inst_73660 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_73629);
var inst_73661 = fluree.db.query.fql.query(inst_73610,inst_73660);
var state_73702__$1 = state_73702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73702__$1,(38),inst_73661);
} else {
if((state_val_73703 === (41))){
var inst_73695 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73728_73806 = state_73702__$1;
(statearr_73728_73806[(2)] = inst_73695);

(statearr_73728_73806[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (43))){
var state_73702__$1 = state_73702;
var statearr_73729_73807 = state_73702__$1;
(statearr_73729_73807[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (29))){
var inst_73597 = (state_73702[(15)]);
var state_73702__$1 = state_73702;
if(cljs.core.truth_(inst_73597)){
var statearr_73731_73808 = state_73702__$1;
(statearr_73731_73808[(1)] = (32));

} else {
var statearr_73732_73809 = state_73702__$1;
(statearr_73732_73809[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (44))){
var inst_73693 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73733_73810 = state_73702__$1;
(statearr_73733_73810[(2)] = inst_73693);

(statearr_73733_73810[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (6))){
var inst_73592 = (state_73702[(8)]);
var inst_73601 = (state_73702[(2)]);
var inst_73602 = fluree.db.util.async.throw_err(inst_73601);
var state_73702__$1 = (function (){var statearr_73734 = state_73702;
(statearr_73734[(7)] = inst_73602);

return statearr_73734;
})();
if(cljs.core.truth_(inst_73592)){
var statearr_73735_73811 = state_73702__$1;
(statearr_73735_73811[(1)] = (7));

} else {
var statearr_73736_73812 = state_73702__$1;
(statearr_73736_73812[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (28))){
var inst_73639 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73737_73813 = state_73702__$1;
(statearr_73737_73813[(2)] = inst_73639);

(statearr_73737_73813[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (25))){
var inst_73641 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73738_73814 = state_73702__$1;
(statearr_73738_73814[(2)] = inst_73641);

(statearr_73738_73814[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (34))){
var inst_73650 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
var statearr_73739_73815 = state_73702__$1;
(statearr_73739_73815[(2)] = inst_73650);

(statearr_73739_73815[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (17))){
var inst_73591 = (state_73702[(24)]);
var state_73702__$1 = state_73702;
var statearr_73740_73816 = state_73702__$1;
(statearr_73740_73816[(2)] = inst_73591);

(statearr_73740_73816[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (3))){
var inst_73700 = (state_73702[(2)]);
var state_73702__$1 = state_73702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73702__$1,inst_73700);
} else {
if((state_val_73703 === (12))){
var inst_73618 = cljs.core.PersistentHashMap.EMPTY;
var state_73702__$1 = state_73702;
var statearr_73741_73817 = state_73702__$1;
(statearr_73741_73817[(2)] = inst_73618);

(statearr_73741_73817[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (2))){
var _ = (function (){var statearr_73742 = state_73702;
(statearr_73742[(4)] = cljs.core.cons((5),(state_73702[(4)])));

return statearr_73742;
})();
var inst_73588 = query_map;
var inst_73589 = cljs.core.__destructure_map(inst_73588);
var inst_73590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_73591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_73592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73593 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_73594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_73595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_73596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_73597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_73598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_73599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73589,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_73702__$1 = (function (){var statearr_73743 = state_73702;
(statearr_73743[(14)] = inst_73595);

(statearr_73743[(15)] = inst_73597);

(statearr_73743[(10)] = inst_73590);

(statearr_73743[(25)] = inst_73594);

(statearr_73743[(24)] = inst_73591);

(statearr_73743[(9)] = inst_73596);

(statearr_73743[(8)] = inst_73592);

(statearr_73743[(19)] = inst_73598);

(statearr_73743[(17)] = inst_73593);

(statearr_73743[(11)] = inst_73599);

return statearr_73743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73702__$1,(6),sources);
} else {
if((state_val_73703 === (23))){
var inst_73595 = (state_73702[(14)]);
var state_73702__$1 = state_73702;
var statearr_73744_73818 = state_73702__$1;
(statearr_73744_73818[(2)] = inst_73595);

(statearr_73744_73818[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (47))){
var inst_73675 = (state_73702[(26)]);
var inst_73628 = (state_73702[(27)]);
var inst_73621 = (state_73702[(21)]);
var inst_73610 = (state_73702[(23)]);
var inst_73681 = (state_73702[(2)]);
var inst_73682 = cljs.core.deref(inst_73621);
var inst_73683 = fluree.db.util.core.response_time_formatted(inst_73628);
var inst_73684 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73610);
var inst_73685 = [(200),inst_73681,inst_73682,inst_73683,inst_73684];
var inst_73686 = cljs.core.PersistentHashMap.fromArrays(inst_73675,inst_73685);
var state_73702__$1 = state_73702;
var statearr_73745_73819 = state_73702__$1;
(statearr_73745_73819[(2)] = inst_73686);

(statearr_73745_73819[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (35))){
var inst_73656 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73657 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73658 = cljs.core.PersistentHashMap.fromArrays(inst_73656,inst_73657);
var state_73702__$1 = state_73702;
var statearr_73746_73820 = state_73702__$1;
(statearr_73746_73820[(2)] = inst_73658);

(statearr_73746_73820[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (19))){
var inst_73645 = (state_73702[(28)]);
var inst_73645__$1 = (state_73702[(2)]);
var state_73702__$1 = (function (){var statearr_73747 = state_73702;
(statearr_73747[(28)] = inst_73645__$1);

return statearr_73747;
})();
if(cljs.core.truth_(inst_73645__$1)){
var statearr_73748_73821 = state_73702__$1;
(statearr_73748_73821[(1)] = (29));

} else {
var statearr_73749_73822 = state_73702__$1;
(statearr_73749_73822[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (11))){
var inst_73594 = (state_73702[(25)]);
var inst_73611 = (state_73702[(29)]);
var inst_73610 = (state_73702[(23)]);
var inst_73613 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_73610);
var inst_73614 = fluree.db.connection_js.open_api_QMARK_(inst_73611);
var inst_73615 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_73610);
var inst_73616 = fluree.db.api_js.get_sources(inst_73611,inst_73613,inst_73614,inst_73615,inst_73594,db_fn);
var state_73702__$1 = state_73702;
var statearr_73751_73823 = state_73702__$1;
(statearr_73751_73823[(2)] = inst_73616);

(statearr_73751_73823[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (9))){
var inst_73594 = (state_73702[(25)]);
var inst_73610 = (state_73702[(23)]);
var inst_73610__$1 = (state_73702[(2)]);
var inst_73611 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_73610__$1);
var state_73702__$1 = (function (){var statearr_73752 = state_73702;
(statearr_73752[(29)] = inst_73611);

(statearr_73752[(23)] = inst_73610__$1);

return statearr_73752;
})();
if(cljs.core.truth_(inst_73594)){
var statearr_73753_73824 = state_73702__$1;
(statearr_73753_73824[(1)] = (11));

} else {
var statearr_73754_73825 = state_73702__$1;
(statearr_73754_73825[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (5))){
var _ = (function (){var statearr_73755 = state_73702;
(statearr_73755[(4)] = cljs.core.rest((state_73702[(4)])));

return statearr_73755;
})();
var state_73702__$1 = state_73702;
var ex73750 = (state_73702__$1[(2)]);
var statearr_73756_73826 = state_73702__$1;
(statearr_73756_73826[(5)] = ex73750);


var statearr_73757_73827 = state_73702__$1;
(statearr_73757_73827[(1)] = (4));

(statearr_73757_73827[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (14))){
var inst_73622 = (state_73702[(18)]);
var state_73702__$1 = state_73702;
var statearr_73758_73828 = state_73702__$1;
(statearr_73758_73828[(2)] = inst_73622);

(statearr_73758_73828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (45))){
var inst_73664 = (state_73702[(12)]);
var inst_73678 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_73664);
var state_73702__$1 = state_73702;
var statearr_73759_73829 = state_73702__$1;
(statearr_73759_73829[(2)] = inst_73678);

(statearr_73759_73829[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (26))){
var inst_73599 = (state_73702[(11)]);
var state_73702__$1 = state_73702;
var statearr_73760_73830 = state_73702__$1;
(statearr_73760_73830[(2)] = inst_73599);

(statearr_73760_73830[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (16))){
var inst_73620 = (state_73702[(20)]);
var inst_73591 = (state_73702[(24)]);
var inst_73598 = (state_73702[(19)]);
var inst_73621 = (state_73702[(21)]);
var inst_73626 = (state_73702[(2)]);
var inst_73627 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_73598);
var inst_73628 = fluree.db.util.core.current_time_millis();
var inst_73629 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_73598,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_73620,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_73626,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_73621], 0));
var state_73702__$1 = (function (){var statearr_73761 = state_73702;
(statearr_73761[(16)] = inst_73627);

(statearr_73761[(27)] = inst_73628);

(statearr_73761[(22)] = inst_73629);

return statearr_73761;
})();
if(cljs.core.truth_(inst_73591)){
var statearr_73762_73831 = state_73702__$1;
(statearr_73762_73831[(1)] = (17));

} else {
var statearr_73763_73832 = state_73702__$1;
(statearr_73763_73832[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (38))){
var inst_73664 = (state_73702[(12)]);
var inst_73663 = (state_73702[(2)]);
var inst_73664__$1 = fluree.db.util.async.throw_err(inst_73663);
var inst_73665 = (inst_73664__$1 instanceof cljs.core.ExceptionInfo);
var state_73702__$1 = (function (){var statearr_73764 = state_73702;
(statearr_73764[(12)] = inst_73664__$1);

return statearr_73764;
})();
if(cljs.core.truth_(inst_73665)){
var statearr_73765_73833 = state_73702__$1;
(statearr_73765_73833[(1)] = (39));

} else {
var statearr_73766_73834 = state_73702__$1;
(statearr_73766_73834[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (30))){
var inst_73645 = (state_73702[(28)]);
var state_73702__$1 = state_73702;
var statearr_73767_73835 = state_73702__$1;
(statearr_73767_73835[(2)] = inst_73645);

(statearr_73767_73835[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (10))){
var inst_73606 = (state_73702[(2)]);
var inst_73607 = fluree.db.util.async.throw_err(inst_73606);
var state_73702__$1 = state_73702;
var statearr_73768_73836 = state_73702__$1;
(statearr_73768_73836[(2)] = inst_73607);

(statearr_73768_73836[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (18))){
var inst_73596 = (state_73702[(9)]);
var state_73702__$1 = state_73702;
if(cljs.core.truth_(inst_73596)){
var statearr_73769_73837 = state_73702__$1;
(statearr_73769_73837[(1)] = (20));

} else {
var statearr_73770_73838 = state_73702__$1;
(statearr_73770_73838[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (42))){
var inst_73664 = (state_73702[(12)]);
var inst_73675 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73676 = cljs.core.sequential_QMARK_(inst_73664);
var state_73702__$1 = (function (){var statearr_73771 = state_73702;
(statearr_73771[(26)] = inst_73675);

return statearr_73771;
})();
if(inst_73676){
var statearr_73772_73839 = state_73702__$1;
(statearr_73772_73839[(1)] = (45));

} else {
var statearr_73773_73840 = state_73702__$1;
(statearr_73773_73840[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (37))){
var inst_73697 = (state_73702[(2)]);
var _ = (function (){var statearr_73774 = state_73702;
(statearr_73774[(4)] = cljs.core.rest((state_73702[(4)])));

return statearr_73774;
})();
var state_73702__$1 = state_73702;
var statearr_73775_73841 = state_73702__$1;
(statearr_73775_73841[(2)] = inst_73697);

(statearr_73775_73841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (8))){
var inst_73602 = (state_73702[(7)]);
var state_73702__$1 = state_73702;
var statearr_73776_73842 = state_73702__$1;
(statearr_73776_73842[(2)] = inst_73602);

(statearr_73776_73842[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73703 === (49))){
var state_73702__$1 = state_73702;
var statearr_73777_73843 = state_73702__$1;
(statearr_73777_73843[(2)] = null);

(statearr_73777_73843[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73778 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73778[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73778[(1)] = (1));

return statearr_73778;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73702){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73702);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73779){var ex__2730__auto__ = e73779;
var statearr_73780_73844 = state_73702;
(statearr_73780_73844[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73702[(4)]))){
var statearr_73781_73845 = state_73702;
(statearr_73781_73845[(1)] = cljs.core.first((state_73702[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73846 = state_73702;
state_73702 = G__73846;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73702){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73782 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73782[(6)] = c__2749__auto__);

return statearr_73782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__73847_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__73847_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73869){
var state_val_73870 = (state_73869[(1)]);
if((state_val_73870 === (1))){
var inst_73851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73852 = [resp_chan,timeout_chan];
var inst_73853 = (new cljs.core.PersistentVector(null,2,(5),inst_73851,inst_73852,null));
var state_73869__$1 = state_73869;
return cljs.core.async.ioc_alts_BANG_(state_73869__$1,(2),inst_73853);
} else {
if((state_val_73870 === (2))){
var inst_73855 = (state_73869[(2)]);
var inst_73856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73855,(0),null);
var inst_73857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73855,(1),null);
var inst_73858 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_73857);
var state_73869__$1 = (function (){var statearr_73871 = state_73869;
(statearr_73871[(7)] = inst_73856);

return statearr_73871;
})();
if(inst_73858){
var statearr_73872_73882 = state_73869__$1;
(statearr_73872_73882[(1)] = (3));

} else {
var statearr_73873_73883 = state_73869__$1;
(statearr_73873_73883[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73870 === (3))){
var inst_73860 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_73861 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_73862 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_73863 = [tid,(408),inst_73862];
var inst_73864 = cljs.core.PersistentHashMap.fromArrays(inst_73861,inst_73863);
var state_73869__$1 = (function (){var statearr_73874 = state_73869;
(statearr_73874[(8)] = inst_73860);

return statearr_73874;
})();
var statearr_73875_73884 = state_73869__$1;
(statearr_73875_73884[(2)] = inst_73864);

(statearr_73875_73884[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73870 === (4))){
var inst_73856 = (state_73869[(7)]);
var state_73869__$1 = state_73869;
var statearr_73876_73885 = state_73869__$1;
(statearr_73876_73885[(2)] = inst_73856);

(statearr_73876_73885[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73870 === (5))){
var inst_73867 = (state_73869[(2)]);
var state_73869__$1 = state_73869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73869__$1,inst_73867);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_73877 = [null,null,null,null,null,null,null,null,null];
(statearr_73877[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_73877[(1)] = (1));

return statearr_73877;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_73869){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73869);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73878){var ex__2730__auto__ = e73878;
var statearr_73879_73886 = state_73869;
(statearr_73879_73886[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73869[(4)]))){
var statearr_73880_73887 = state_73869;
(statearr_73880_73887[(1)] = cljs.core.first((state_73869[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73888 = state_73869;
state_73869 = G__73888;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_73869){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_73869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73881 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73881[(6)] = c__2749__auto__);

return statearr_73881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__73890 = arguments.length;
switch (G__73890) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__73891 = opts;
var map__73891__$1 = cljs.core.__destructure_map(map__73891);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73891__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73891__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73891__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73891__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__73892 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73892,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73892,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e73895){var e = e73895;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__73898 = arguments.length;
switch (G__73898) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73967){
var state_val_73968 = (state_73967[(1)]);
if((state_val_73968 === (7))){
var inst_73921 = (state_73967[(7)]);
var inst_73920 = (state_73967[(8)]);
var inst_73922 = (state_73967[(9)]);
var inst_73923 = (state_73967[(10)]);
var inst_73918 = (state_73967[(11)]);
var inst_73936 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_73937 = [ledger,txn,inst_73918,inst_73920,inst_73921,inst_73922,inst_73923];
var inst_73938 = cljs.core.PersistentHashMap.fromArrays(inst_73936,inst_73937);
var inst_73939 = fluree.db.util.core.without_nils(inst_73938);
var inst_73940 = fluree.db.operations.transact_async(conn,inst_73939);
var state_73967__$1 = state_73967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73967__$1,(13),inst_73940);
} else {
if((state_val_73968 === (20))){
var inst_73958 = (state_73967[(2)]);
var state_73967__$1 = state_73967;
var statearr_73969_74005 = state_73967__$1;
(statearr_73969_74005[(2)] = inst_73958);

(statearr_73969_74005[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (1))){
var state_73967__$1 = state_73967;
var statearr_73970_74006 = state_73967__$1;
(statearr_73970_74006[(2)] = null);

(statearr_73970_74006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (4))){
var inst_73899 = (state_73967[(2)]);
var inst_73900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73901 = [inst_73899];
var inst_73902 = (new cljs.core.PersistentVector(null,1,(5),inst_73900,inst_73901,null));
var inst_73903 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73902);
var inst_73904 = cljs.core.ex_data(inst_73899);
var inst_73905 = cljs.core.ex_message(inst_73899);
var inst_73906 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73904,new cljs.core.Keyword(null,"message","message",-406056002),inst_73905);
var state_73967__$1 = (function (){var statearr_73971 = state_73967;
(statearr_73971[(12)] = inst_73903);

return statearr_73971;
})();
var statearr_73972_74007 = state_73967__$1;
(statearr_73972_74007[(2)] = inst_73906);

(statearr_73972_74007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (15))){
var inst_73942 = (state_73967[(13)]);
var inst_73917 = (state_73967[(14)]);
var inst_73945 = fluree.db.api_js.monitor_tx(conn,ledger,inst_73942,inst_73917);
var state_73967__$1 = state_73967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73967__$1,(17),inst_73945);
} else {
if((state_val_73968 === (13))){
var inst_73916 = (state_73967[(15)]);
var inst_73942 = (state_73967[(2)]);
var state_73967__$1 = (function (){var statearr_73973 = state_73967;
(statearr_73973[(13)] = inst_73942);

return statearr_73973;
})();
if(cljs.core.truth_(inst_73916)){
var statearr_73974_74008 = state_73967__$1;
(statearr_73974_74008[(1)] = (14));

} else {
var statearr_73975_74009 = state_73967__$1;
(statearr_73975_74009[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (6))){
var inst_73915 = (state_73967[(16)]);
var inst_73916 = (state_73967[(15)]);
var inst_73925 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_73915,opts);
var inst_73926 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_73925);
var inst_73927 = fluree.db.operations.command_async(conn,inst_73925);
var state_73967__$1 = (function (){var statearr_73976 = state_73967;
(statearr_73976[(17)] = inst_73927);

(statearr_73976[(18)] = inst_73926);

return statearr_73976;
})();
if(cljs.core.truth_(inst_73916)){
var statearr_73977_74010 = state_73967__$1;
(statearr_73977_74010[(1)] = (9));

} else {
var statearr_73978_74011 = state_73967__$1;
(statearr_73978_74011[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (17))){
var inst_73947 = (state_73967[(19)]);
var inst_73947__$1 = (state_73967[(2)]);
var inst_73948 = (inst_73947__$1 instanceof cljs.core.ExceptionInfo);
var state_73967__$1 = (function (){var statearr_73979 = state_73967;
(statearr_73979[(19)] = inst_73947__$1);

return statearr_73979;
})();
if(cljs.core.truth_(inst_73948)){
var statearr_73980_74012 = state_73967__$1;
(statearr_73980_74012[(1)] = (18));

} else {
var statearr_73981_74013 = state_73967__$1;
(statearr_73981_74013[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (3))){
var inst_73965 = (state_73967[(2)]);
var state_73967__$1 = state_73967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73967__$1,inst_73965);
} else {
if((state_val_73968 === (12))){
var inst_73932 = (state_73967[(2)]);
var state_73967__$1 = state_73967;
var statearr_73982_74014 = state_73967__$1;
(statearr_73982_74014[(2)] = inst_73932);

(statearr_73982_74014[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (2))){
var inst_73915 = (state_73967[(16)]);
var _ = (function (){var statearr_73983 = state_73967;
(statearr_73983[(4)] = cljs.core.cons((5),(state_73967[(4)])));

return statearr_73983;
})();
var inst_73913 = opts;
var inst_73914 = cljs.core.__destructure_map(inst_73913);
var inst_73915__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73914,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_73916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73914,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_73917 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73914,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_73918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73914,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73919 = fluree.db.util.core.current_time_millis();
var inst_73920 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73914,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_73919);
var inst_73921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73914,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_73922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73914,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_73923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73914,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_73967__$1 = (function (){var statearr_73984 = state_73967;
(statearr_73984[(16)] = inst_73915__$1);

(statearr_73984[(7)] = inst_73921);

(statearr_73984[(15)] = inst_73916);

(statearr_73984[(8)] = inst_73920);

(statearr_73984[(9)] = inst_73922);

(statearr_73984[(14)] = inst_73917);

(statearr_73984[(10)] = inst_73923);

(statearr_73984[(11)] = inst_73918);

return statearr_73984;
})();
if(cljs.core.truth_(inst_73915__$1)){
var statearr_73985_74015 = state_73967__$1;
(statearr_73985_74015[(1)] = (6));

} else {
var statearr_73986_74016 = state_73967__$1;
(statearr_73986_74016[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (19))){
var inst_73947 = (state_73967[(19)]);
var state_73967__$1 = state_73967;
var statearr_73987_74017 = state_73967__$1;
(statearr_73987_74017[(2)] = inst_73947);

(statearr_73987_74017[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (11))){
var inst_73934 = (state_73967[(2)]);
var state_73967__$1 = state_73967;
var statearr_73989_74018 = state_73967__$1;
(statearr_73989_74018[(2)] = inst_73934);

(statearr_73989_74018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (9))){
var inst_73927 = (state_73967[(17)]);
var state_73967__$1 = state_73967;
var statearr_73990_74019 = state_73967__$1;
(statearr_73990_74019[(2)] = inst_73927);

(statearr_73990_74019[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (5))){
var _ = (function (){var statearr_73991 = state_73967;
(statearr_73991[(4)] = cljs.core.rest((state_73967[(4)])));

return statearr_73991;
})();
var state_73967__$1 = state_73967;
var ex73988 = (state_73967__$1[(2)]);
var statearr_73992_74020 = state_73967__$1;
(statearr_73992_74020[(5)] = ex73988);


var statearr_73993_74021 = state_73967__$1;
(statearr_73993_74021[(1)] = (4));

(statearr_73993_74021[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (14))){
var inst_73942 = (state_73967[(13)]);
var state_73967__$1 = state_73967;
var statearr_73994_74022 = state_73967__$1;
(statearr_73994_74022[(2)] = inst_73942);

(statearr_73994_74022[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (16))){
var inst_73960 = (state_73967[(2)]);
var state_73967__$1 = state_73967;
var statearr_73995_74023 = state_73967__$1;
(statearr_73995_74023[(2)] = inst_73960);

(statearr_73995_74023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (10))){
var inst_73926 = (state_73967[(18)]);
var inst_73917 = (state_73967[(14)]);
var inst_73930 = fluree.db.api_js.monitor_tx(conn,ledger,inst_73926,inst_73917);
var state_73967__$1 = state_73967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73967__$1,(12),inst_73930);
} else {
if((state_val_73968 === (18))){
var inst_73947 = (state_73967[(19)]);
var inst_73950 = cljs.core.ex_data(inst_73947);
var inst_73951 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73952 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73950);
var inst_73953 = cljs.core.ex_message(inst_73947);
var inst_73954 = [inst_73952,inst_73953,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_73955 = cljs.core.PersistentHashMap.fromArrays(inst_73951,inst_73954);
var state_73967__$1 = state_73967;
var statearr_73996_74024 = state_73967__$1;
(statearr_73996_74024[(2)] = inst_73955);

(statearr_73996_74024[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73968 === (8))){
var inst_73962 = (state_73967[(2)]);
var _ = (function (){var statearr_73997 = state_73967;
(statearr_73997[(4)] = cljs.core.rest((state_73967[(4)])));

return statearr_73997;
})();
var state_73967__$1 = state_73967;
var statearr_73998_74025 = state_73967__$1;
(statearr_73998_74025[(2)] = inst_73962);

(statearr_73998_74025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73999 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73999[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73999[(1)] = (1));

return statearr_73999;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73967){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73967);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74000){var ex__2730__auto__ = e74000;
var statearr_74001_74026 = state_73967;
(statearr_74001_74026[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73967[(4)]))){
var statearr_74002_74027 = state_73967;
(statearr_74002_74027[(1)] = cljs.core.first((state_73967[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74028 = state_73967;
state_73967 = G__74028;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73967){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74003 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74003[(6)] = c__2749__auto__);

return statearr_74003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___74030 = arguments.length;
var i__5770__auto___74031 = (0);
while(true){
if((i__5770__auto___74031 < len__5769__auto___74030)){
args__5775__auto__.push((arguments[i__5770__auto___74031]));

var G__74032 = (i__5770__auto___74031 + (1));
i__5770__auto___74031 = G__74032;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq74029){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq74029));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74063){
var state_val_74064 = (state_74063[(1)]);
if((state_val_74064 === (1))){
var inst_74033 = cljs.core.first(flakes);
var inst_74034 = cljs.core.rest(flakes);
var inst_74035 = cljs.core.PersistentVector.EMPTY;
var inst_74036 = inst_74033;
var inst_74037 = inst_74034;
var inst_74038 = inst_74035;
var state_74063__$1 = (function (){var statearr_74065 = state_74063;
(statearr_74065[(7)] = inst_74037);

(statearr_74065[(8)] = inst_74038);

(statearr_74065[(9)] = inst_74036);

return statearr_74065;
})();
var statearr_74066_74079 = state_74063__$1;
(statearr_74066_74079[(2)] = null);

(statearr_74066_74079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74064 === (2))){
var inst_74036 = (state_74063[(9)]);
var inst_74040 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_74041 = cljs.core.PersistentHashMap.EMPTY;
var inst_74042 = [true,inst_74041];
var inst_74043 = cljs.core.PersistentHashMap.fromArrays(inst_74040,inst_74042);
var inst_74044 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_74043,inst_74036);
var state_74063__$1 = state_74063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74063__$1,(4),inst_74044);
} else {
if((state_val_74064 === (3))){
var inst_74061 = (state_74063[(2)]);
var state_74063__$1 = state_74063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74063__$1,inst_74061);
} else {
if((state_val_74064 === (4))){
var inst_74037 = (state_74063[(7)]);
var inst_74038 = (state_74063[(8)]);
var inst_74046 = (state_74063[(2)]);
var inst_74047 = fluree.db.util.async.throw_err(inst_74046);
var inst_74048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74049 = [inst_74047];
var inst_74050 = (new cljs.core.PersistentVector(null,1,(5),inst_74048,inst_74049,null));
var inst_74051 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_74038,inst_74050);
var inst_74052 = cljs.core.first(inst_74037);
var state_74063__$1 = (function (){var statearr_74067 = state_74063;
(statearr_74067[(10)] = inst_74051);

return statearr_74067;
})();
if(cljs.core.truth_(inst_74052)){
var statearr_74068_74080 = state_74063__$1;
(statearr_74068_74080[(1)] = (5));

} else {
var statearr_74069_74081 = state_74063__$1;
(statearr_74069_74081[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74064 === (5))){
var inst_74037 = (state_74063[(7)]);
var inst_74051 = (state_74063[(10)]);
var inst_74054 = cljs.core.first(inst_74037);
var inst_74055 = cljs.core.rest(inst_74037);
var inst_74036 = inst_74054;
var inst_74037__$1 = inst_74055;
var inst_74038 = inst_74051;
var state_74063__$1 = (function (){var statearr_74070 = state_74063;
(statearr_74070[(7)] = inst_74037__$1);

(statearr_74070[(8)] = inst_74038);

(statearr_74070[(9)] = inst_74036);

return statearr_74070;
})();
var statearr_74071_74082 = state_74063__$1;
(statearr_74071_74082[(2)] = null);

(statearr_74071_74082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74064 === (6))){
var inst_74051 = (state_74063[(10)]);
var state_74063__$1 = state_74063;
var statearr_74072_74083 = state_74063__$1;
(statearr_74072_74083[(2)] = inst_74051);

(statearr_74072_74083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74064 === (7))){
var inst_74059 = (state_74063[(2)]);
var state_74063__$1 = state_74063;
var statearr_74073_74084 = state_74063__$1;
(statearr_74073_74084[(2)] = inst_74059);

(statearr_74073_74084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_74074 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74074[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_74074[(1)] = (1));

return statearr_74074;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_74063){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74063);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74075){var ex__2730__auto__ = e74075;
var statearr_74076_74085 = state_74063;
(statearr_74076_74085[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74063[(4)]))){
var statearr_74077_74086 = state_74063;
(statearr_74077_74086[(1)] = cljs.core.first((state_74063[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74087 = state_74063;
state_74063 = G__74087;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_74063){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_74063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74078 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74078[(6)] = c__2749__auto__);

return statearr_74078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74155){
var state_val_74156 = (state_74155[(1)]);
if((state_val_74156 === (7))){
var inst_74115 = (state_74155[(2)]);
var inst_74116 = fluree.db.util.async.throw_err(inst_74115);
var state_74155__$1 = state_74155;
var statearr_74157_74183 = state_74155__$1;
(statearr_74157_74183[(2)] = inst_74116);

(statearr_74157_74183[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (1))){
var inst_74092 = cljs.core.volatile_BANG_((0));
var inst_74093 = cljs.core.PersistentHashMap.EMPTY;
var inst_74094 = cljs.core.volatile_BANG_(inst_74093);
var inst_74095 = cljs.core.first(resp);
var inst_74096 = cljs.core.rest(resp);
var inst_74097 = cljs.core.PersistentVector.EMPTY;
var inst_74098 = inst_74092;
var inst_74099 = inst_74094;
var inst_74100 = inst_74095;
var inst_74101 = inst_74096;
var inst_74102 = inst_74097;
var state_74155__$1 = (function (){var statearr_74158 = state_74155;
(statearr_74158[(7)] = inst_74099);

(statearr_74158[(8)] = inst_74101);

(statearr_74158[(9)] = inst_74098);

(statearr_74158[(10)] = inst_74102);

(statearr_74158[(11)] = inst_74100);

return statearr_74158;
})();
var statearr_74159_74184 = state_74155__$1;
(statearr_74159_74184[(2)] = null);

(statearr_74159_74184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (4))){
var inst_74099 = (state_74155[(7)]);
var inst_74101 = (state_74155[(8)]);
var inst_74098 = (state_74155[(9)]);
var inst_74102 = (state_74155[(10)]);
var inst_74100 = (state_74155[(11)]);
var inst_74104 = (state_74155[(12)]);
var inst_74106 = (state_74155[(13)]);
var inst_74110 = (function (){var fuel = inst_74098;
var cache = inst_74099;
var curr_block = inst_74100;
var rest_blocks = inst_74101;
var acc = inst_74102;
var flakes = inst_74104;
var asserted = inst_74106;
return (function (p1__74089_SHARP_){
return p1__74089_SHARP_.s;
});
})();
var inst_74111 = cljs.core.group_by(inst_74110,inst_74106);
var inst_74112 = cljs.core.vals(inst_74111);
var inst_74113 = fluree.db.api_js.format_flake_groups_pretty(db,inst_74099,inst_74098,inst_74112);
var state_74155__$1 = state_74155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74155__$1,(7),inst_74113);
} else {
if((state_val_74156 === (13))){
var inst_74143 = (state_74155[(14)]);
var state_74155__$1 = state_74155;
var statearr_74160_74185 = state_74155__$1;
(statearr_74160_74185[(2)] = inst_74143);

(statearr_74160_74185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (6))){
var inst_74099 = (state_74155[(7)]);
var inst_74101 = (state_74155[(8)]);
var inst_74098 = (state_74155[(9)]);
var inst_74102 = (state_74155[(10)]);
var inst_74100 = (state_74155[(11)]);
var inst_74121 = (state_74155[(15)]);
var inst_74104 = (state_74155[(12)]);
var inst_74119 = (state_74155[(16)]);
var inst_74106 = (state_74155[(13)]);
var inst_74119__$1 = (state_74155[(2)]);
var inst_74120 = (function (){var fuel = inst_74098;
var cache = inst_74099;
var curr_block = inst_74100;
var rest_blocks = inst_74101;
var acc = inst_74102;
var flakes = inst_74104;
var asserted = inst_74106;
var asserted_SINGLEQUOTE_ = inst_74119__$1;
return (function (p1__74090_SHARP_){
return p1__74090_SHARP_.op === false;
});
})();
var inst_74121__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_74120,inst_74104);
var inst_74122 = cljs.core.empty_QMARK_(inst_74121__$1);
var inst_74123 = (!(inst_74122));
var state_74155__$1 = (function (){var statearr_74163 = state_74155;
(statearr_74163[(15)] = inst_74121__$1);

(statearr_74163[(16)] = inst_74119__$1);

return statearr_74163;
})();
if(inst_74123){
var statearr_74164_74186 = state_74155__$1;
(statearr_74164_74186[(1)] = (8));

} else {
var statearr_74165_74187 = state_74155__$1;
(statearr_74165_74187[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (3))){
var inst_74153 = (state_74155[(2)]);
var state_74155__$1 = state_74155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74155__$1,inst_74153);
} else {
if((state_val_74156 === (12))){
var inst_74099 = (state_74155[(7)]);
var inst_74101 = (state_74155[(8)]);
var inst_74098 = (state_74155[(9)]);
var inst_74143 = (state_74155[(14)]);
var inst_74146 = cljs.core.first(inst_74101);
var inst_74147 = cljs.core.rest(inst_74101);
var tmp74161 = inst_74099;
var tmp74162 = inst_74098;
var inst_74098__$1 = tmp74162;
var inst_74099__$1 = tmp74161;
var inst_74100 = inst_74146;
var inst_74101__$1 = inst_74147;
var inst_74102 = inst_74143;
var state_74155__$1 = (function (){var statearr_74166 = state_74155;
(statearr_74166[(7)] = inst_74099__$1);

(statearr_74166[(8)] = inst_74101__$1);

(statearr_74166[(9)] = inst_74098__$1);

(statearr_74166[(10)] = inst_74102);

(statearr_74166[(11)] = inst_74100);

return statearr_74166;
})();
var statearr_74167_74188 = state_74155__$1;
(statearr_74167_74188[(2)] = null);

(statearr_74167_74188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (2))){
var inst_74099 = (state_74155[(7)]);
var inst_74101 = (state_74155[(8)]);
var inst_74098 = (state_74155[(9)]);
var inst_74102 = (state_74155[(10)]);
var inst_74100 = (state_74155[(11)]);
var inst_74104 = (state_74155[(12)]);
var inst_74106 = (state_74155[(13)]);
var inst_74104__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_74100);
var inst_74105 = (function (){var fuel = inst_74098;
var cache = inst_74099;
var curr_block = inst_74100;
var rest_blocks = inst_74101;
var acc = inst_74102;
var flakes = inst_74104__$1;
return (function (p1__74088_SHARP_){
return p1__74088_SHARP_.op;
});
})();
var inst_74106__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_74105,inst_74104__$1);
var inst_74107 = cljs.core.empty_QMARK_(inst_74106__$1);
var inst_74108 = (!(inst_74107));
var state_74155__$1 = (function (){var statearr_74168 = state_74155;
(statearr_74168[(12)] = inst_74104__$1);

(statearr_74168[(13)] = inst_74106__$1);

return statearr_74168;
})();
if(inst_74108){
var statearr_74169_74189 = state_74155__$1;
(statearr_74169_74189[(1)] = (4));

} else {
var statearr_74170_74190 = state_74155__$1;
(statearr_74170_74190[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (11))){
var inst_74131 = (state_74155[(2)]);
var inst_74132 = fluree.db.util.async.throw_err(inst_74131);
var state_74155__$1 = state_74155;
var statearr_74171_74191 = state_74155__$1;
(statearr_74171_74191[(2)] = inst_74132);

(statearr_74171_74191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (9))){
var state_74155__$1 = state_74155;
var statearr_74172_74192 = state_74155__$1;
(statearr_74172_74192[(2)] = null);

(statearr_74172_74192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (5))){
var state_74155__$1 = state_74155;
var statearr_74173_74193 = state_74155__$1;
(statearr_74173_74193[(2)] = null);

(statearr_74173_74193[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (14))){
var inst_74151 = (state_74155[(2)]);
var state_74155__$1 = state_74155;
var statearr_74174_74194 = state_74155__$1;
(statearr_74174_74194[(2)] = inst_74151);

(statearr_74174_74194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (10))){
var inst_74101 = (state_74155[(8)]);
var inst_74102 = (state_74155[(10)]);
var inst_74100 = (state_74155[(11)]);
var inst_74119 = (state_74155[(16)]);
var inst_74135 = (state_74155[(2)]);
var inst_74136 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_74137 = [inst_74119,inst_74135];
var inst_74138 = cljs.core.PersistentHashMap.fromArrays(inst_74136,inst_74137);
var inst_74139 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74100,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_74138);
var inst_74140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74141 = [inst_74139];
var inst_74142 = (new cljs.core.PersistentVector(null,1,(5),inst_74140,inst_74141,null));
var inst_74143 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_74102,inst_74142);
var inst_74144 = cljs.core.first(inst_74101);
var state_74155__$1 = (function (){var statearr_74175 = state_74155;
(statearr_74175[(14)] = inst_74143);

return statearr_74175;
})();
if(cljs.core.truth_(inst_74144)){
var statearr_74176_74195 = state_74155__$1;
(statearr_74176_74195[(1)] = (12));

} else {
var statearr_74177_74196 = state_74155__$1;
(statearr_74177_74196[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (8))){
var inst_74099 = (state_74155[(7)]);
var inst_74101 = (state_74155[(8)]);
var inst_74098 = (state_74155[(9)]);
var inst_74102 = (state_74155[(10)]);
var inst_74100 = (state_74155[(11)]);
var inst_74121 = (state_74155[(15)]);
var inst_74104 = (state_74155[(12)]);
var inst_74119 = (state_74155[(16)]);
var inst_74106 = (state_74155[(13)]);
var inst_74125 = (function (){var flakes = inst_74104;
var rest_blocks = inst_74101;
var curr_block = inst_74100;
var asserted_SINGLEQUOTE_ = inst_74119;
var acc = inst_74102;
var fuel = inst_74098;
var cache = inst_74099;
var retracted = inst_74121;
var asserted = inst_74106;
return (function (p1__74091_SHARP_){
return p1__74091_SHARP_.s;
});
})();
var inst_74126 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_74121);
var inst_74127 = cljs.core.group_by(inst_74125,inst_74126);
var inst_74128 = cljs.core.vals(inst_74127);
var inst_74129 = fluree.db.api_js.format_flake_groups_pretty(db,inst_74099,inst_74098,inst_74128);
var state_74155__$1 = state_74155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74155__$1,(11),inst_74129);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_74178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74178[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_74178[(1)] = (1));

return statearr_74178;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_74155){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74155);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74179){var ex__2730__auto__ = e74179;
var statearr_74180_74197 = state_74155;
(statearr_74180_74197[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74155[(4)]))){
var statearr_74181_74198 = state_74155;
(statearr_74181_74198[(1)] = cljs.core.first((state_74155[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74199 = state_74155;
state_74155 = G__74199;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_74155){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_74155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74182 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74182[(6)] = c__2749__auto__);

return statearr_74182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74299){
var state_val_74300 = (state_74299[(1)]);
if((state_val_74300 === (7))){
var inst_74271 = (state_74299[(7)]);
var inst_74264 = (state_74299[(8)]);
var inst_74270 = cljs.core.seq(inst_74264);
var inst_74271__$1 = cljs.core.first(inst_74270);
var inst_74272 = cljs.core.next(inst_74270);
var state_74299__$1 = (function (){var statearr_74301 = state_74299;
(statearr_74301[(9)] = inst_74272);

(statearr_74301[(7)] = inst_74271__$1);

return statearr_74301;
})();
if(cljs.core.truth_(inst_74271__$1)){
var statearr_74302_74339 = state_74299__$1;
(statearr_74302_74339[(1)] = (9));

} else {
var statearr_74303_74340 = state_74299__$1;
(statearr_74303_74340[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (1))){
var state_74299__$1 = state_74299;
var statearr_74304_74341 = state_74299__$1;
(statearr_74304_74341[(2)] = null);

(statearr_74304_74341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (4))){
var inst_74201 = (state_74299[(2)]);
var state_74299__$1 = state_74299;
var statearr_74305_74342 = state_74299__$1;
(statearr_74305_74342[(2)] = inst_74201);

(statearr_74305_74342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (6))){
var inst_74250 = (state_74299[(2)]);
var inst_74251 = fluree.db.util.async.throw_err(inst_74250);
var inst_74259 = resp;
var inst_74260 = cljs.core.seq(inst_74259);
var inst_74261 = cljs.core.first(inst_74260);
var inst_74262 = cljs.core.next(inst_74260);
var inst_74263 = cljs.core.PersistentHashMap.EMPTY;
var inst_74264 = inst_74259;
var inst_74265 = inst_74263;
var state_74299__$1 = (function (){var statearr_74306 = state_74299;
(statearr_74306[(10)] = inst_74265);

(statearr_74306[(11)] = inst_74262);

(statearr_74306[(8)] = inst_74264);

(statearr_74306[(12)] = inst_74261);

(statearr_74306[(13)] = inst_74251);

return statearr_74306;
})();
var statearr_74307_74343 = state_74299__$1;
(statearr_74307_74343[(2)] = null);

(statearr_74307_74343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (3))){
var inst_74297 = (state_74299[(2)]);
var state_74299__$1 = state_74299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74299__$1,inst_74297);
} else {
if((state_val_74300 === (2))){
var _ = (function (){var statearr_74308 = state_74299;
(statearr_74308[(4)] = cljs.core.cons((5),(state_74299[(4)])));

return statearr_74308;
})();
var inst_74207 = (function (){return (function (p1__74200_SHARP_){
return p1__74200_SHARP_.t;
});
})();
var inst_74208 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_74207,resp);
var inst_74209 = cljs.core.set(inst_74208);
var inst_74246 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74247 = (function (){var ts = inst_74209;
var c__2749__auto____$1 = inst_74246;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74244){
var state_val_74245 = (state_74244[(1)]);
if((state_val_74245 === (1))){
var inst_74217 = ts;
var inst_74218 = cljs.core.seq(inst_74217);
var inst_74219 = cljs.core.first(inst_74218);
var inst_74220 = cljs.core.next(inst_74218);
var inst_74221 = cljs.core.PersistentHashMap.EMPTY;
var inst_74222 = inst_74217;
var inst_74223 = inst_74221;
var state_74244__$1 = (function (){var statearr_74309 = state_74244;
(statearr_74309[(7)] = inst_74219);

(statearr_74309[(8)] = inst_74223);

(statearr_74309[(9)] = inst_74222);

(statearr_74309[(10)] = inst_74220);

return statearr_74309;
})();
var statearr_74310_74344 = state_74244__$1;
(statearr_74310_74344[(2)] = null);

(statearr_74310_74344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74245 === (2))){
var inst_74229 = (state_74244[(11)]);
var inst_74222 = (state_74244[(9)]);
var inst_74228 = cljs.core.seq(inst_74222);
var inst_74229__$1 = cljs.core.first(inst_74228);
var inst_74230 = cljs.core.next(inst_74228);
var state_74244__$1 = (function (){var statearr_74311 = state_74244;
(statearr_74311[(12)] = inst_74230);

(statearr_74311[(11)] = inst_74229__$1);

return statearr_74311;
})();
if(cljs.core.truth_(inst_74229__$1)){
var statearr_74312_74345 = state_74244__$1;
(statearr_74312_74345[(1)] = (4));

} else {
var statearr_74313_74346 = state_74244__$1;
(statearr_74313_74346[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74245 === (3))){
var inst_74242 = (state_74244[(2)]);
var state_74244__$1 = state_74244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74244__$1,inst_74242);
} else {
if((state_val_74245 === (4))){
var inst_74229 = (state_74244[(11)]);
var inst_74232 = fluree.db.time_travel.non_border_t_to_block(db,inst_74229);
var state_74244__$1 = state_74244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74244__$1,(7),inst_74232);
} else {
if((state_val_74245 === (5))){
var inst_74223 = (state_74244[(8)]);
var state_74244__$1 = state_74244;
var statearr_74314_74347 = state_74244__$1;
(statearr_74314_74347[(2)] = inst_74223);

(statearr_74314_74347[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74245 === (6))){
var inst_74240 = (state_74244[(2)]);
var state_74244__$1 = state_74244;
var statearr_74315_74348 = state_74244__$1;
(statearr_74315_74348[(2)] = inst_74240);

(statearr_74315_74348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74245 === (7))){
var inst_74230 = (state_74244[(12)]);
var inst_74229 = (state_74244[(11)]);
var inst_74223 = (state_74244[(8)]);
var inst_74234 = (state_74244[(2)]);
var inst_74235 = fluree.db.util.async.throw_err(inst_74234);
var inst_74236 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74223,inst_74229,inst_74235);
var inst_74222 = inst_74230;
var inst_74223__$1 = inst_74236;
var state_74244__$1 = (function (){var statearr_74316 = state_74244;
(statearr_74316[(8)] = inst_74223__$1);

(statearr_74316[(9)] = inst_74222);

return statearr_74316;
})();
var statearr_74317_74349 = state_74244__$1;
(statearr_74317_74349[(2)] = null);

(statearr_74317_74349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_74318 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74318[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_74318[(1)] = (1));

return statearr_74318;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_74244){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74244);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74319){var ex__2730__auto__ = e74319;
var statearr_74320_74350 = state_74244;
(statearr_74320_74350[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74244[(4)]))){
var statearr_74321_74351 = state_74244;
(statearr_74321_74351[(1)] = cljs.core.first((state_74244[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74352 = state_74244;
state_74244 = G__74352;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_74244){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_74244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74322 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74322[(6)] = c__2749__auto____$1);

return statearr_74322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_74248 = cljs.core.async.impl.dispatch.run(inst_74247);
var state_74299__$1 = (function (){var statearr_74323 = state_74299;
(statearr_74323[(14)] = inst_74248);

return statearr_74323;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74299__$1,(6),inst_74246);
} else {
if((state_val_74300 === (11))){
var inst_74291 = (state_74299[(2)]);
var state_74299__$1 = state_74299;
var statearr_74325_74353 = state_74299__$1;
(statearr_74325_74353[(2)] = inst_74291);

(statearr_74325_74353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (9))){
var inst_74272 = (state_74299[(9)]);
var inst_74271 = (state_74299[(7)]);
var inst_74265 = (state_74299[(10)]);
var inst_74251 = (state_74299[(13)]);
var inst_74274 = inst_74271.t;
var inst_74275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74251,inst_74274);
var inst_74276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74277 = [inst_74275,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74278 = (new cljs.core.PersistentVector(null,2,(5),inst_74276,inst_74277,null));
var inst_74279 = cljs.core.assoc_in(inst_74265,inst_74278,inst_74275);
var inst_74280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74281 = [inst_74275,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_74282 = (new cljs.core.PersistentVector(null,2,(5),inst_74280,inst_74281,null));
var inst_74283 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_74279,inst_74282,cljs.core.conj,inst_74271);
var inst_74284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74285 = [inst_74275,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_74286 = (new cljs.core.PersistentVector(null,2,(5),inst_74284,inst_74285,null));
var inst_74287 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_74283,inst_74286,fluree.db.api_js.min_safe,inst_74274);
var inst_74264 = inst_74272;
var inst_74265__$1 = inst_74287;
var state_74299__$1 = (function (){var statearr_74326 = state_74299;
(statearr_74326[(10)] = inst_74265__$1);

(statearr_74326[(8)] = inst_74264);

return statearr_74326;
})();
var statearr_74327_74354 = state_74299__$1;
(statearr_74327_74354[(2)] = null);

(statearr_74327_74354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (5))){
var _ = (function (){var statearr_74328 = state_74299;
(statearr_74328[(4)] = cljs.core.rest((state_74299[(4)])));

return statearr_74328;
})();
var state_74299__$1 = state_74299;
var ex74324 = (state_74299__$1[(2)]);
var statearr_74329_74355 = state_74299__$1;
(statearr_74329_74355[(5)] = ex74324);


if((ex74324 instanceof Error)){
var statearr_74330_74356 = state_74299__$1;
(statearr_74330_74356[(1)] = (4));

(statearr_74330_74356[(5)] = null);

} else {
throw ex74324;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (10))){
var inst_74265 = (state_74299[(10)]);
var state_74299__$1 = state_74299;
var statearr_74331_74357 = state_74299__$1;
(statearr_74331_74357[(2)] = inst_74265);

(statearr_74331_74357[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (8))){
var inst_74293 = (state_74299[(2)]);
var inst_74294 = cljs.core.vals(inst_74293);
var _ = (function (){var statearr_74332 = state_74299;
(statearr_74332[(4)] = cljs.core.rest((state_74299[(4)])));

return statearr_74332;
})();
var state_74299__$1 = state_74299;
var statearr_74333_74358 = state_74299__$1;
(statearr_74333_74358[(2)] = inst_74294);

(statearr_74333_74358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_74334 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74334[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_74334[(1)] = (1));

return statearr_74334;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_74299){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74299);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74335){var ex__2730__auto__ = e74335;
var statearr_74336_74359 = state_74299;
(statearr_74336_74359[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74299[(4)]))){
var statearr_74337_74360 = state_74299;
(statearr_74337_74360[(1)] = cljs.core.first((state_74299[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74361 = state_74299;
state_74299 = G__74361;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_74299){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_74299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74338 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74338[(6)] = c__2749__auto__);

return statearr_74338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74509){
var state_val_74510 = (state_74509[(1)]);
if((state_val_74510 === (7))){
var inst_74389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74390 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74391 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74392 = [inst_74390,inst_74391];
var inst_74393 = (new cljs.core.PersistentVector(null,2,(5),inst_74389,inst_74392,null));
var state_74509__$1 = state_74509;
var statearr_74511_74582 = state_74509__$1;
(statearr_74511_74582[(2)] = inst_74393);

(statearr_74511_74582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (20))){
var inst_74419 = (state_74509[(7)]);
var state_74509__$1 = state_74509;
var statearr_74512_74583 = state_74509__$1;
(statearr_74512_74583[(2)] = inst_74419);

(statearr_74512_74583[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (27))){
var state_74509__$1 = state_74509;
var statearr_74513_74584 = state_74509__$1;
(statearr_74513_74584[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (1))){
var state_74509__$1 = state_74509;
var statearr_74515_74585 = state_74509__$1;
(statearr_74515_74585[(2)] = null);

(statearr_74515_74585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (24))){
var inst_74418 = (state_74509[(8)]);
var state_74509__$1 = state_74509;
if(cljs.core.truth_(inst_74418)){
var statearr_74516_74586 = state_74509__$1;
(statearr_74516_74586[(1)] = (26));

} else {
var statearr_74517_74587 = state_74509__$1;
(statearr_74517_74587[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (39))){
var inst_74464 = (state_74509[(9)]);
var inst_74465 = (state_74509[(10)]);
var inst_74490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74491 = [inst_74464,inst_74465];
var inst_74492 = (new cljs.core.PersistentVector(null,2,(5),inst_74490,inst_74491,null));
var state_74509__$1 = state_74509;
var statearr_74518_74588 = state_74509__$1;
(statearr_74518_74588[(2)] = inst_74492);

(statearr_74518_74588[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (4))){
var inst_74362 = (state_74509[(2)]);
var inst_74363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74364 = [inst_74362];
var inst_74365 = (new cljs.core.PersistentVector(null,1,(5),inst_74363,inst_74364,null));
var inst_74366 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74365);
var inst_74367 = cljs.core.ex_data(inst_74362);
var inst_74368 = cljs.core.ex_message(inst_74362);
var inst_74369 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74367,new cljs.core.Keyword(null,"message","message",-406056002),inst_74368);
var state_74509__$1 = (function (){var statearr_74519 = state_74509;
(statearr_74519[(11)] = inst_74366);

return statearr_74519;
})();
var statearr_74520_74589 = state_74509__$1;
(statearr_74520_74589[(2)] = inst_74369);

(statearr_74520_74589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (15))){
var inst_74398 = (state_74509[(12)]);
var inst_74403 = (state_74509[(13)]);
var inst_74412 = (state_74509[(2)]);
var inst_74413 = [inst_74403,inst_74412];
var inst_74414 = (new cljs.core.PersistentVector(null,2,(5),inst_74398,inst_74413,null));
var state_74509__$1 = state_74509;
var statearr_74521_74590 = state_74509__$1;
(statearr_74521_74590[(2)] = inst_74414);

(statearr_74521_74590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (21))){
var inst_74418 = (state_74509[(8)]);
var state_74509__$1 = state_74509;
var statearr_74522_74591 = state_74509__$1;
(statearr_74522_74591[(2)] = inst_74418);

(statearr_74522_74591[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (31))){
var inst_74459 = (state_74509[(2)]);
var state_74509__$1 = state_74509;
var statearr_74523_74592 = state_74509__$1;
(statearr_74523_74592[(2)] = inst_74459);

(statearr_74523_74592[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (32))){
var inst_74465 = (state_74509[(10)]);
var inst_74468 = cljs.core.pos_int_QMARK_(inst_74465);
var state_74509__$1 = state_74509;
var statearr_74524_74593 = state_74509__$1;
(statearr_74524_74593[(2)] = inst_74468);

(statearr_74524_74593[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (40))){
var inst_74420 = (state_74509[(14)]);
var inst_74496 = (state_74509[(15)]);
var inst_74494 = (state_74509[(2)]);
var inst_74495 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74494,(0),null);
var inst_74496__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74494,(1),null);
var inst_74497 = (inst_74496__$1 > inst_74420);
var state_74509__$1 = (function (){var statearr_74525 = state_74509;
(statearr_74525[(16)] = inst_74495);

(statearr_74525[(15)] = inst_74496__$1);

return statearr_74525;
})();
if(cljs.core.truth_(inst_74497)){
var statearr_74526_74594 = state_74509__$1;
(statearr_74526_74594[(1)] = (41));

} else {
var statearr_74527_74595 = state_74509__$1;
(statearr_74527_74595[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (33))){
var inst_74466 = (state_74509[(17)]);
var state_74509__$1 = state_74509;
var statearr_74528_74596 = state_74509__$1;
(statearr_74528_74596[(2)] = inst_74466);

(statearr_74528_74596[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (13))){
var inst_74404 = (state_74509[(18)]);
var inst_74406 = fluree.db.time_travel.block_to_int_format(db,inst_74404);
var state_74509__$1 = state_74509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74509__$1,(16),inst_74406);
} else {
if((state_val_74510 === (22))){
var inst_74437 = (state_74509[(2)]);
var state_74509__$1 = state_74509;
if(cljs.core.truth_(inst_74437)){
var statearr_74529_74597 = state_74509__$1;
(statearr_74529_74597[(1)] = (23));

} else {
var statearr_74530_74598 = state_74509__$1;
(statearr_74530_74598[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (36))){
var state_74509__$1 = state_74509;
var statearr_74531_74599 = state_74509__$1;
(statearr_74531_74599[(2)] = null);

(statearr_74531_74599[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (41))){
var inst_74420 = (state_74509[(14)]);
var state_74509__$1 = state_74509;
var statearr_74532_74600 = state_74509__$1;
(statearr_74532_74600[(2)] = inst_74420);

(statearr_74532_74600[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (43))){
var inst_74495 = (state_74509[(16)]);
var inst_74501 = (state_74509[(2)]);
var inst_74502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74503 = [inst_74495,inst_74501];
var inst_74504 = (new cljs.core.PersistentVector(null,2,(5),inst_74502,inst_74503,null));
var _ = (function (){var statearr_74533 = state_74509;
(statearr_74533[(4)] = cljs.core.rest((state_74509[(4)])));

return statearr_74533;
})();
var state_74509__$1 = state_74509;
var statearr_74534_74601 = state_74509__$1;
(statearr_74534_74601[(2)] = inst_74504);

(statearr_74534_74601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (29))){
var inst_74395 = (state_74509[(19)]);
var inst_74450 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74395], 0));
var inst_74451 = ["Invalid block range provided: ",inst_74450].join('');
var inst_74452 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74453 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74454 = cljs.core.PersistentHashMap.fromArrays(inst_74452,inst_74453);
var inst_74455 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74451,inst_74454);
var inst_74456 = (function(){throw inst_74455})();
var state_74509__$1 = state_74509;
var statearr_74535_74602 = state_74509__$1;
(statearr_74535_74602[(2)] = inst_74456);

(statearr_74535_74602[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (6))){
var inst_74387 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74509__$1 = state_74509;
var statearr_74536_74603 = state_74509__$1;
(statearr_74536_74603[(2)] = inst_74387);

(statearr_74536_74603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (28))){
var inst_74461 = (state_74509[(2)]);
var state_74509__$1 = state_74509;
var statearr_74537_74604 = state_74509__$1;
(statearr_74537_74604[(2)] = inst_74461);

(statearr_74537_74604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (25))){
var inst_74466 = (state_74509[(17)]);
var inst_74464 = (state_74509[(9)]);
var inst_74463 = (state_74509[(2)]);
var inst_74464__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74463,(0),null);
var inst_74465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74463,(1),null);
var inst_74466__$1 = cljs.core.pos_int_QMARK_(inst_74464__$1);
var state_74509__$1 = (function (){var statearr_74538 = state_74509;
(statearr_74538[(17)] = inst_74466__$1);

(statearr_74538[(9)] = inst_74464__$1);

(statearr_74538[(10)] = inst_74465);

return statearr_74538;
})();
if(inst_74466__$1){
var statearr_74539_74605 = state_74509__$1;
(statearr_74539_74605[(1)] = (32));

} else {
var statearr_74540_74606 = state_74509__$1;
(statearr_74540_74606[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (34))){
var inst_74471 = (state_74509[(2)]);
var inst_74472 = cljs.core.not(inst_74471);
var state_74509__$1 = state_74509;
if(inst_74472){
var statearr_74541_74607 = state_74509__$1;
(statearr_74541_74607[(1)] = (35));

} else {
var statearr_74542_74608 = state_74509__$1;
(statearr_74542_74608[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (17))){
var inst_74418 = (state_74509[(8)]);
var inst_74420 = (state_74509[(14)]);
var inst_74423 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74418], 0));
var inst_74424 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74420], 0));
var inst_74425 = ["Start block is out of range for this ledger. Start block provided: ",inst_74423,". Database block: ",inst_74424].join('');
var inst_74426 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74427 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74428 = cljs.core.PersistentHashMap.fromArrays(inst_74426,inst_74427);
var inst_74429 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74425,inst_74428);
var inst_74430 = (function(){throw inst_74429})();
var state_74509__$1 = state_74509;
var statearr_74543_74609 = state_74509__$1;
(statearr_74543_74609[(2)] = inst_74430);

(statearr_74543_74609[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (3))){
var inst_74507 = (state_74509[(2)]);
var state_74509__$1 = state_74509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74509__$1,inst_74507);
} else {
if((state_val_74510 === (12))){
var inst_74395 = (state_74509[(19)]);
var inst_74404 = (state_74509[(18)]);
var inst_74402 = (state_74509[(2)]);
var inst_74403 = fluree.db.util.async.throw_err(inst_74402);
var inst_74404__$1 = cljs.core.second(inst_74395);
var state_74509__$1 = (function (){var statearr_74544 = state_74509;
(statearr_74544[(13)] = inst_74403);

(statearr_74544[(18)] = inst_74404__$1);

return statearr_74544;
})();
if(cljs.core.truth_(inst_74404__$1)){
var statearr_74545_74610 = state_74509__$1;
(statearr_74545_74610[(1)] = (13));

} else {
var statearr_74546_74611 = state_74509__$1;
(statearr_74546_74611[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (2))){
var _ = (function (){var statearr_74547 = state_74509;
(statearr_74547[(4)] = cljs.core.cons((5),(state_74509[(4)])));

return statearr_74547;
})();
var inst_74384 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74385 = cljs.core.sequential_QMARK_(inst_74384);
var state_74509__$1 = state_74509;
if(inst_74385){
var statearr_74548_74612 = state_74509__$1;
(statearr_74548_74612[(1)] = (6));

} else {
var statearr_74549_74613 = state_74509__$1;
(statearr_74549_74613[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (23))){
var inst_74418 = (state_74509[(8)]);
var inst_74419 = (state_74509[(7)]);
var inst_74439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74440 = [inst_74418,inst_74419];
var inst_74441 = (new cljs.core.PersistentVector(null,2,(5),inst_74439,inst_74440,null));
var state_74509__$1 = state_74509;
var statearr_74550_74614 = state_74509__$1;
(statearr_74550_74614[(2)] = inst_74441);

(statearr_74550_74614[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (35))){
var inst_74395 = (state_74509[(19)]);
var inst_74474 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74395], 0));
var inst_74475 = ["Invalid block range provided: ",inst_74474].join('');
var inst_74476 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74477 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74478 = cljs.core.PersistentHashMap.fromArrays(inst_74476,inst_74477);
var inst_74479 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74475,inst_74478);
var inst_74480 = (function(){throw inst_74479})();
var state_74509__$1 = state_74509;
var statearr_74551_74615 = state_74509__$1;
(statearr_74551_74615[(2)] = inst_74480);

(statearr_74551_74615[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (19))){
var inst_74418 = (state_74509[(8)]);
var inst_74433 = (state_74509[(2)]);
var state_74509__$1 = (function (){var statearr_74552 = state_74509;
(statearr_74552[(20)] = inst_74433);

return statearr_74552;
})();
if(cljs.core.truth_(inst_74418)){
var statearr_74553_74616 = state_74509__$1;
(statearr_74553_74616[(1)] = (20));

} else {
var statearr_74554_74617 = state_74509__$1;
(statearr_74554_74617[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (11))){
var inst_74418 = (state_74509[(8)]);
var inst_74420 = (state_74509[(14)]);
var inst_74417 = (state_74509[(2)]);
var inst_74418__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74417,(0),null);
var inst_74419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74417,(1),null);
var inst_74420__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74421 = (inst_74418__$1 > inst_74420__$1);
var state_74509__$1 = (function (){var statearr_74556 = state_74509;
(statearr_74556[(8)] = inst_74418__$1);

(statearr_74556[(14)] = inst_74420__$1);

(statearr_74556[(7)] = inst_74419);

return statearr_74556;
})();
if(cljs.core.truth_(inst_74421)){
var statearr_74557_74618 = state_74509__$1;
(statearr_74557_74618[(1)] = (17));

} else {
var statearr_74558_74619 = state_74509__$1;
(statearr_74558_74619[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (9))){
var inst_74395 = (state_74509[(19)]);
var inst_74398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74399 = cljs.core.first(inst_74395);
var inst_74400 = fluree.db.time_travel.block_to_int_format(db,inst_74399);
var state_74509__$1 = (function (){var statearr_74559 = state_74509;
(statearr_74559[(12)] = inst_74398);

return statearr_74559;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74509__$1,(12),inst_74400);
} else {
if((state_val_74510 === (5))){
var _ = (function (){var statearr_74560 = state_74509;
(statearr_74560[(4)] = cljs.core.rest((state_74509[(4)])));

return statearr_74560;
})();
var state_74509__$1 = state_74509;
var ex74555 = (state_74509__$1[(2)]);
var statearr_74561_74620 = state_74509__$1;
(statearr_74561_74620[(5)] = ex74555);


var statearr_74562_74621 = state_74509__$1;
(statearr_74562_74621[(1)] = (4));

(statearr_74562_74621[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (14))){
var state_74509__$1 = state_74509;
var statearr_74563_74622 = state_74509__$1;
(statearr_74563_74622[(2)] = null);

(statearr_74563_74622[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (26))){
var inst_74418 = (state_74509[(8)]);
var inst_74444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74445 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74446 = [inst_74418,inst_74445];
var inst_74447 = (new cljs.core.PersistentVector(null,2,(5),inst_74444,inst_74446,null));
var state_74509__$1 = state_74509;
var statearr_74564_74623 = state_74509__$1;
(statearr_74564_74623[(2)] = inst_74447);

(statearr_74564_74623[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (16))){
var inst_74408 = (state_74509[(2)]);
var inst_74409 = fluree.db.util.async.throw_err(inst_74408);
var state_74509__$1 = state_74509;
var statearr_74565_74624 = state_74509__$1;
(statearr_74565_74624[(2)] = inst_74409);

(statearr_74565_74624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (38))){
var inst_74464 = (state_74509[(9)]);
var inst_74465 = (state_74509[(10)]);
var inst_74486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74487 = [inst_74465,inst_74464];
var inst_74488 = (new cljs.core.PersistentVector(null,2,(5),inst_74486,inst_74487,null));
var state_74509__$1 = state_74509;
var statearr_74566_74625 = state_74509__$1;
(statearr_74566_74625[(2)] = inst_74488);

(statearr_74566_74625[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (30))){
var state_74509__$1 = state_74509;
var statearr_74567_74626 = state_74509__$1;
(statearr_74567_74626[(2)] = null);

(statearr_74567_74626[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (10))){
var inst_74395 = (state_74509[(19)]);
var state_74509__$1 = state_74509;
var statearr_74568_74627 = state_74509__$1;
(statearr_74568_74627[(2)] = inst_74395);

(statearr_74568_74627[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (18))){
var state_74509__$1 = state_74509;
var statearr_74569_74628 = state_74509__$1;
(statearr_74569_74628[(2)] = null);

(statearr_74569_74628[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (42))){
var inst_74496 = (state_74509[(15)]);
var state_74509__$1 = state_74509;
var statearr_74570_74629 = state_74509__$1;
(statearr_74570_74629[(2)] = inst_74496);

(statearr_74570_74629[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (37))){
var inst_74464 = (state_74509[(9)]);
var inst_74465 = (state_74509[(10)]);
var inst_74483 = (state_74509[(2)]);
var inst_74484 = (inst_74465 < inst_74464);
var state_74509__$1 = (function (){var statearr_74571 = state_74509;
(statearr_74571[(21)] = inst_74483);

return statearr_74571;
})();
if(cljs.core.truth_(inst_74484)){
var statearr_74572_74630 = state_74509__$1;
(statearr_74572_74630[(1)] = (38));

} else {
var statearr_74573_74631 = state_74509__$1;
(statearr_74573_74631[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74510 === (8))){
var inst_74395 = (state_74509[(19)]);
var inst_74395__$1 = (state_74509[(2)]);
var inst_74396 = cljs.core.some(cljs.core.string_QMARK_,inst_74395__$1);
var state_74509__$1 = (function (){var statearr_74574 = state_74509;
(statearr_74574[(19)] = inst_74395__$1);

return statearr_74574;
})();
if(cljs.core.truth_(inst_74396)){
var statearr_74575_74632 = state_74509__$1;
(statearr_74575_74632[(1)] = (9));

} else {
var statearr_74576_74633 = state_74509__$1;
(statearr_74576_74633[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_74577 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74577[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_74577[(1)] = (1));

return statearr_74577;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_74509){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74509);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74578){var ex__2730__auto__ = e74578;
var statearr_74579_74634 = state_74509;
(statearr_74579_74634[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74509[(4)]))){
var statearr_74580_74635 = state_74509;
(statearr_74580_74635[(1)] = cljs.core.first((state_74509[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74636 = state_74509;
state_74509 = G__74636;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_74509){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_74509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74581 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74581[(6)] = c__2749__auto__);

return statearr_74581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__74638 = arguments.length;
switch (G__74638) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74732){
var state_val_74733 = (state_74732[(1)]);
if((state_val_74733 === (7))){
var inst_74664 = (state_74732[(7)]);
var inst_74667 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_74664);
var state_74732__$1 = state_74732;
var statearr_74734_74785 = state_74732__$1;
(statearr_74734_74785[(2)] = inst_74667);

(statearr_74734_74785[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (20))){
var inst_74703 = (state_74732[(8)]);
var inst_74706 = fluree.db.api_js.format_block_resp_pretty(db,inst_74703);
var state_74732__$1 = state_74732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74732__$1,(23),inst_74706);
} else {
if((state_val_74733 === (27))){
var inst_74712 = (state_74732[(9)]);
var inst_74718 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_74712);
var state_74732__$1 = state_74732;
var statearr_74735_74786 = state_74732__$1;
(statearr_74735_74786[(2)] = inst_74718);

(statearr_74735_74786[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (1))){
var state_74732__$1 = state_74732;
var statearr_74736_74787 = state_74732__$1;
(statearr_74736_74787[(2)] = null);

(statearr_74736_74787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (24))){
var inst_74712 = (state_74732[(9)]);
var inst_74715 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_74716 = cljs.core.sequential_QMARK_(inst_74712);
var state_74732__$1 = (function (){var statearr_74737 = state_74732;
(statearr_74737[(10)] = inst_74715);

return statearr_74737;
})();
if(inst_74716){
var statearr_74738_74788 = state_74732__$1;
(statearr_74738_74788[(1)] = (27));

} else {
var statearr_74739_74789 = state_74732__$1;
(statearr_74739_74789[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (4))){
var inst_74639 = (state_74732[(2)]);
var inst_74640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74641 = [inst_74639];
var inst_74642 = (new cljs.core.PersistentVector(null,1,(5),inst_74640,inst_74641,null));
var inst_74643 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74642);
var inst_74644 = cljs.core.ex_data(inst_74639);
var inst_74645 = cljs.core.ex_message(inst_74639);
var inst_74646 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74644,new cljs.core.Keyword(null,"message","message",-406056002),inst_74645);
var state_74732__$1 = (function (){var statearr_74740 = state_74732;
(statearr_74740[(11)] = inst_74643);

return statearr_74740;
})();
var statearr_74741_74790 = state_74732__$1;
(statearr_74741_74790[(2)] = inst_74646);

(statearr_74741_74790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (15))){
var inst_74664 = (state_74732[(7)]);
var inst_74677 = (state_74732[(2)]);
var inst_74678 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74677,inst_74664);
var inst_74679 = (function(){throw inst_74678})();
var state_74732__$1 = state_74732;
var statearr_74742_74791 = state_74732__$1;
(statearr_74742_74791[(2)] = inst_74679);

(statearr_74742_74791[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (21))){
var inst_74703 = (state_74732[(8)]);
var state_74732__$1 = state_74732;
var statearr_74743_74792 = state_74732__$1;
(statearr_74743_74792[(2)] = inst_74703);

(statearr_74743_74792[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (13))){
var inst_74672 = (state_74732[(12)]);
var state_74732__$1 = state_74732;
var statearr_74744_74793 = state_74732__$1;
(statearr_74744_74793[(2)] = inst_74672);

(statearr_74744_74793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (22))){
var inst_74712 = (state_74732[(2)]);
var inst_74713 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74732__$1 = (function (){var statearr_74745 = state_74732;
(statearr_74745[(9)] = inst_74712);

return statearr_74745;
})();
if(cljs.core.truth_(inst_74713)){
var statearr_74746_74794 = state_74732__$1;
(statearr_74746_74794[(1)] = (24));

} else {
var statearr_74747_74795 = state_74732__$1;
(statearr_74747_74795[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (29))){
var inst_74715 = (state_74732[(10)]);
var inst_74656 = (state_74732[(13)]);
var inst_74721 = (state_74732[(2)]);
var inst_74722 = fluree.db.util.core.response_time_formatted(inst_74656);
var inst_74723 = [(200),inst_74721,(100),inst_74722];
var inst_74724 = cljs.core.PersistentHashMap.fromArrays(inst_74715,inst_74723);
var state_74732__$1 = state_74732;
var statearr_74748_74796 = state_74732__$1;
(statearr_74748_74796[(2)] = inst_74724);

(statearr_74748_74796[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (6))){
var inst_74664 = (state_74732[(7)]);
var inst_74665 = (state_74732[(14)]);
var inst_74663 = (state_74732[(2)]);
var inst_74664__$1 = fluree.db.util.async.throw_err(inst_74663);
var inst_74665__$1 = cljs.core.map_QMARK_(inst_74664__$1);
var state_74732__$1 = (function (){var statearr_74749 = state_74732;
(statearr_74749[(7)] = inst_74664__$1);

(statearr_74749[(14)] = inst_74665__$1);

return statearr_74749;
})();
if(inst_74665__$1){
var statearr_74750_74797 = state_74732__$1;
(statearr_74750_74797[(1)] = (7));

} else {
var statearr_74751_74798 = state_74732__$1;
(statearr_74751_74798[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (28))){
var inst_74712 = (state_74732[(9)]);
var state_74732__$1 = state_74732;
var statearr_74752_74799 = state_74732__$1;
(statearr_74752_74799[(2)] = inst_74712);

(statearr_74752_74799[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (25))){
var inst_74712 = (state_74732[(9)]);
var state_74732__$1 = state_74732;
var statearr_74753_74800 = state_74732__$1;
(statearr_74753_74800[(2)] = inst_74712);

(statearr_74753_74800[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (17))){
var inst_74695 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_74696 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_74695].join('');
var inst_74697 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74698 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74699 = cljs.core.PersistentHashMap.fromArrays(inst_74697,inst_74698);
var inst_74700 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74696,inst_74699);
var inst_74701 = (function(){throw inst_74700})();
var state_74732__$1 = state_74732;
var statearr_74754_74801 = state_74732__$1;
(statearr_74754_74801[(2)] = inst_74701);

(statearr_74754_74801[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (3))){
var inst_74730 = (state_74732[(2)]);
var state_74732__$1 = state_74732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74732__$1,inst_74730);
} else {
if((state_val_74733 === (12))){
var inst_74664 = (state_74732[(7)]);
var inst_74682 = (state_74732[(2)]);
var inst_74683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74664,(0),null);
var inst_74684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74664,(1),null);
var inst_74685 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_74686 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_74687 = cljs.core.keys(inst_74686);
var inst_74688 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74685,inst_74687);
var state_74732__$1 = (function (){var statearr_74755 = state_74732;
(statearr_74755[(15)] = inst_74684);

(statearr_74755[(16)] = inst_74682);

(statearr_74755[(17)] = inst_74683);

return statearr_74755;
})();
if(inst_74688){
var statearr_74756_74802 = state_74732__$1;
(statearr_74756_74802[(1)] = (16));

} else {
var statearr_74757_74803 = state_74732__$1;
(statearr_74757_74803[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (2))){
var _ = (function (){var statearr_74758 = state_74732;
(statearr_74758[(4)] = cljs.core.cons((5),(state_74732[(4)])));

return statearr_74758;
})();
var inst_74656 = fluree.db.util.core.current_time_millis();
var inst_74657 = db;
var inst_74658 = cljs.core.__destructure_map(inst_74657);
var inst_74659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74658,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_74660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74658,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_74661 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_74732__$1 = (function (){var statearr_74759 = state_74732;
(statearr_74759[(18)] = inst_74659);

(statearr_74759[(19)] = inst_74660);

(statearr_74759[(13)] = inst_74656);

return statearr_74759;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74732__$1,(6),inst_74661);
} else {
if((state_val_74733 === (23))){
var inst_74708 = (state_74732[(2)]);
var inst_74709 = fluree.db.util.async.throw_err(inst_74708);
var state_74732__$1 = state_74732;
var statearr_74760_74804 = state_74732__$1;
(statearr_74760_74804[(2)] = inst_74709);

(statearr_74760_74804[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (19))){
var inst_74692 = (state_74732[(2)]);
var inst_74693 = fluree.db.util.async.throw_err(inst_74692);
var state_74732__$1 = state_74732;
var statearr_74761_74805 = state_74732__$1;
(statearr_74761_74805[(2)] = inst_74693);

(statearr_74761_74805[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (11))){
var state_74732__$1 = state_74732;
var statearr_74763_74806 = state_74732__$1;
(statearr_74763_74806[(2)] = null);

(statearr_74763_74806[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (9))){
var inst_74670 = (state_74732[(2)]);
var state_74732__$1 = state_74732;
if(cljs.core.truth_(inst_74670)){
var statearr_74764_74807 = state_74732__$1;
(statearr_74764_74807[(1)] = (10));

} else {
var statearr_74765_74808 = state_74732__$1;
(statearr_74765_74808[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (5))){
var _ = (function (){var statearr_74766 = state_74732;
(statearr_74766[(4)] = cljs.core.rest((state_74732[(4)])));

return statearr_74766;
})();
var state_74732__$1 = state_74732;
var ex74762 = (state_74732__$1[(2)]);
var statearr_74767_74809 = state_74732__$1;
(statearr_74767_74809[(5)] = ex74762);


var statearr_74768_74810 = state_74732__$1;
(statearr_74768_74810[(1)] = (4));

(statearr_74768_74810[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (14))){
var inst_74659 = (state_74732[(18)]);
var inst_74660 = (state_74732[(19)]);
var inst_74675 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74659),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74660)].join('');
var state_74732__$1 = state_74732;
var statearr_74769_74811 = state_74732__$1;
(statearr_74769_74811[(2)] = inst_74675);

(statearr_74769_74811[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (26))){
var inst_74727 = (state_74732[(2)]);
var _ = (function (){var statearr_74770 = state_74732;
(statearr_74770[(4)] = cljs.core.rest((state_74732[(4)])));

return statearr_74770;
})();
var state_74732__$1 = state_74732;
var statearr_74771_74812 = state_74732__$1;
(statearr_74771_74812[(2)] = inst_74727);

(statearr_74771_74812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (16))){
var inst_74684 = (state_74732[(15)]);
var inst_74683 = (state_74732[(17)]);
var inst_74690 = fluree.db.query.block.block_range(db,inst_74683,inst_74684,opts);
var state_74732__$1 = state_74732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74732__$1,(19),inst_74690);
} else {
if((state_val_74733 === (10))){
var inst_74664 = (state_74732[(7)]);
var inst_74672 = (state_74732[(12)]);
var inst_74672__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_74664);
var state_74732__$1 = (function (){var statearr_74772 = state_74732;
(statearr_74772[(12)] = inst_74672__$1);

return statearr_74772;
})();
if(cljs.core.truth_(inst_74672__$1)){
var statearr_74773_74813 = state_74732__$1;
(statearr_74773_74813[(1)] = (13));

} else {
var statearr_74774_74814 = state_74732__$1;
(statearr_74774_74814[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (18))){
var inst_74703 = (state_74732[(2)]);
var inst_74704 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74732__$1 = (function (){var statearr_74775 = state_74732;
(statearr_74775[(8)] = inst_74703);

return statearr_74775;
})();
if(cljs.core.truth_(inst_74704)){
var statearr_74776_74815 = state_74732__$1;
(statearr_74776_74815[(1)] = (20));

} else {
var statearr_74777_74816 = state_74732__$1;
(statearr_74777_74816[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74733 === (8))){
var inst_74665 = (state_74732[(14)]);
var state_74732__$1 = state_74732;
var statearr_74778_74817 = state_74732__$1;
(statearr_74778_74817[(2)] = inst_74665);

(statearr_74778_74817[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74779[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74779[(1)] = (1));

return statearr_74779;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74732){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74732);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74780){var ex__2730__auto__ = e74780;
var statearr_74781_74818 = state_74732;
(statearr_74781_74818[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74732[(4)]))){
var statearr_74782_74819 = state_74732;
(statearr_74782_74819[(1)] = cljs.core.first((state_74732[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74820 = state_74732;
state_74732 = G__74820;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74732){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74783 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74783[(6)] = c__2749__auto__);

return statearr_74783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__74822 = arguments.length;
switch (G__74822) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75017){
var state_val_75018 = (state_75017[(1)]);
if((state_val_75018 === (62))){
var inst_75015 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75017__$1,inst_75015);
} else {
if((state_val_75018 === (7))){
var inst_74843 = (state_75017[(7)]);
var inst_74853 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_74843);
var state_75017__$1 = state_75017;
var statearr_75019_75110 = state_75017__$1;
(statearr_75019_75110[(2)] = inst_74853);

(statearr_75019_75110[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (59))){
var inst_75003 = (state_75017[(2)]);
var inst_75004 = fluree.db.util.async.throw_err(inst_75003);
var state_75017__$1 = state_75017;
var statearr_75020_75111 = state_75017__$1;
(statearr_75020_75111[(2)] = inst_75004);

(statearr_75020_75111[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (20))){
var inst_74919 = (state_75017[(8)]);
var inst_74911 = (state_75017[(9)]);
var inst_74911__$1 = (state_75017[(2)]);
var inst_74912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74911__$1,(0));
var inst_74914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74911__$1,(1));
var inst_74915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74911__$1,(2));
var inst_74916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74911__$1,(3));
var inst_74917 = [inst_74913,inst_74914,inst_74915,inst_74916];
var inst_74918 = (new cljs.core.PersistentVector(null,4,(5),inst_74912,inst_74917,null));
var inst_74919__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74918,(0),null);
var inst_74920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74918,(1),null);
var inst_74921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74918,(2),null);
var inst_74922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74918,(3),null);
var inst_74923 = (inst_74919__$1 == null);
var inst_74924 = cljs.core.not(inst_74923);
var state_75017__$1 = (function (){var statearr_75021 = state_75017;
(statearr_75021[(10)] = inst_74921);

(statearr_75021[(11)] = inst_74922);

(statearr_75021[(8)] = inst_74919__$1);

(statearr_75021[(9)] = inst_74911__$1);

(statearr_75021[(12)] = inst_74920);

return statearr_75021;
})();
if(inst_74924){
var statearr_75022_75112 = state_75017__$1;
(statearr_75022_75112[(1)] = (30));

} else {
var statearr_75023_75113 = state_75017__$1;
(statearr_75023_75113[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (58))){
var inst_74851 = (state_75017[(13)]);
var inst_75007 = (state_75017[(2)]);
var state_75017__$1 = (function (){var statearr_75024 = state_75017;
(statearr_75024[(14)] = inst_75007);

return statearr_75024;
})();
if(cljs.core.truth_(inst_74851)){
var statearr_75025_75114 = state_75017__$1;
(statearr_75025_75114[(1)] = (60));

} else {
var statearr_75026_75115 = state_75017__$1;
(statearr_75026_75115[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (60))){
var inst_74995 = (state_75017[(15)]);
var inst_75007 = (state_75017[(14)]);
var inst_75009 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_75010 = cljs.core.count(inst_74995);
var inst_75011 = [inst_75007,inst_75010,(200)];
var inst_75012 = cljs.core.PersistentHashMap.fromArrays(inst_75009,inst_75011);
var state_75017__$1 = state_75017;
var statearr_75027_75116 = state_75017__$1;
(statearr_75027_75116[(2)] = inst_75012);

(statearr_75027_75116[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (27))){
var inst_74830 = (state_75017[(16)]);
var inst_74899 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74830)].join('');
var inst_74900 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74901 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74902 = cljs.core.PersistentHashMap.fromArrays(inst_74900,inst_74901);
var inst_74903 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74899,inst_74902);
var inst_74904 = (function(){throw inst_74903})();
var state_75017__$1 = state_75017;
var statearr_75028_75117 = state_75017__$1;
(statearr_75028_75117[(2)] = inst_74904);

(statearr_75028_75117[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (1))){
var inst_74827 = query_map;
var inst_74828 = cljs.core.__destructure_map(inst_74827);
var inst_74829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74828,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74828,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_74831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74828,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_75017__$1 = (function (){var statearr_75029 = state_75017;
(statearr_75029[(17)] = inst_74829);

(statearr_75029[(18)] = inst_74831);

(statearr_75029[(16)] = inst_74830);

return statearr_75029;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(2),sources);
} else {
if((state_val_75018 === (24))){
var inst_74830 = (state_75017[(16)]);
var inst_74888 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74830)].join('');
var inst_74889 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74890 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74891 = cljs.core.PersistentHashMap.fromArrays(inst_74889,inst_74890);
var inst_74892 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74888,inst_74891);
var inst_74893 = (function(){throw inst_74892})();
var state_75017__$1 = state_75017;
var statearr_75030_75118 = state_75017__$1;
(statearr_75030_75118[(2)] = inst_74893);

(statearr_75030_75118[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (55))){
var inst_74831 = (state_75017[(18)]);
var inst_74998 = (state_75017[(2)]);
var inst_74999 = fluree.db.util.async.throw_err(inst_74998);
var state_75017__$1 = (function (){var statearr_75031 = state_75017;
(statearr_75031[(19)] = inst_74999);

return statearr_75031;
})();
if(cljs.core.truth_(inst_74831)){
var statearr_75032_75119 = state_75017__$1;
(statearr_75032_75119[(1)] = (56));

} else {
var statearr_75033_75120 = state_75017__$1;
(statearr_75033_75120[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (39))){
var inst_74921 = (state_75017[(10)]);
var inst_74922 = (state_75017[(11)]);
var inst_74919 = (state_75017[(8)]);
var inst_74920 = (state_75017[(12)]);
var inst_74943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74945 = [inst_74920,inst_74919,inst_74921,inst_74922];
var inst_74946 = (new cljs.core.PersistentVector(null,4,(5),inst_74944,inst_74945,null));
var inst_74947 = [inst_74946,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_74948 = (new cljs.core.PersistentVector(null,2,(5),inst_74943,inst_74947,null));
var state_75017__$1 = state_75017;
var statearr_75034_75121 = state_75017__$1;
(statearr_75034_75121[(2)] = inst_74948);

(statearr_75034_75121[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (46))){
var inst_74953 = (state_75017[(20)]);
var state_75017__$1 = state_75017;
var statearr_75035_75122 = state_75017__$1;
(statearr_75035_75122[(2)] = inst_74953);

(statearr_75035_75122[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (4))){
var state_75017__$1 = state_75017;
var statearr_75036_75123 = state_75017__$1;
(statearr_75036_75123[(2)] = null);

(statearr_75036_75123[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (54))){
var inst_74995 = (state_75017[(15)]);
var inst_74834 = (state_75017[(21)]);
var inst_74994 = (state_75017[(2)]);
var inst_74995__$1 = fluree.db.util.async.throw_err(inst_74994);
var inst_74996 = fluree.db.api_js.format_history_resp(inst_74834,inst_74995__$1);
var state_75017__$1 = (function (){var statearr_75037 = state_75017;
(statearr_75037[(15)] = inst_74995__$1);

return statearr_75037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(55),inst_74996);
} else {
if((state_val_75018 === (15))){
var inst_74834 = (state_75017[(21)]);
var inst_74875 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74834);
var state_75017__$1 = state_75017;
var statearr_75038_75124 = state_75017__$1;
(statearr_75038_75124[(2)] = inst_74875);

(statearr_75038_75124[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (48))){
var inst_74921 = (state_75017[(10)]);
var inst_74922 = (state_75017[(11)]);
var inst_74919 = (state_75017[(8)]);
var inst_74920 = (state_75017[(12)]);
var inst_74964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74966 = [inst_74920,inst_74921,inst_74919,inst_74922];
var inst_74967 = (new cljs.core.PersistentVector(null,4,(5),inst_74965,inst_74966,null));
var inst_74968 = [inst_74967,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_74969 = (new cljs.core.PersistentVector(null,2,(5),inst_74964,inst_74968,null));
var state_75017__$1 = state_75017;
var statearr_75039_75125 = state_75017__$1;
(statearr_75039_75125[(2)] = inst_74969);

(statearr_75039_75125[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (50))){
var inst_74982 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75040_75126 = state_75017__$1;
(statearr_75040_75126[(2)] = inst_74982);

(statearr_75040_75126[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (21))){
var inst_74830 = (state_75017[(16)]);
var inst_74886 = cljs.core.empty_QMARK_(inst_74830);
var state_75017__$1 = state_75017;
if(inst_74886){
var statearr_75041_75127 = state_75017__$1;
(statearr_75041_75127[(1)] = (24));

} else {
var statearr_75042_75128 = state_75017__$1;
(statearr_75042_75128[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (31))){
var inst_74930 = (state_75017[(22)]);
var inst_74919 = (state_75017[(8)]);
var inst_74930__$1 = (inst_74919 == null);
var state_75017__$1 = (function (){var statearr_75043 = state_75017;
(statearr_75043[(22)] = inst_74930__$1);

return statearr_75043;
})();
if(cljs.core.truth_(inst_74930__$1)){
var statearr_75044_75129 = state_75017__$1;
(statearr_75044_75129[(1)] = (33));

} else {
var statearr_75045_75130 = state_75017__$1;
(statearr_75045_75130[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (32))){
var inst_74834 = (state_75017[(21)]);
var inst_74867 = (state_75017[(23)]);
var inst_74877 = (state_75017[(24)]);
var inst_74986 = (state_75017[(2)]);
var inst_74987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74986,(0),null);
var inst_74988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74986,(1),null);
var inst_74989 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74990 = [inst_74867,inst_74877];
var inst_74991 = cljs.core.PersistentHashMap.fromArrays(inst_74989,inst_74990);
var inst_74992 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_74834,inst_74988,cljs.core._EQ_,inst_74987,inst_74991);
var state_75017__$1 = state_75017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(54),inst_74992);
} else {
if((state_val_75018 === (40))){
var inst_74950 = (state_75017[(25)]);
var inst_74919 = (state_75017[(8)]);
var inst_74950__$1 = (inst_74919 == null);
var state_75017__$1 = (function (){var statearr_75046 = state_75017;
(statearr_75046[(25)] = inst_74950__$1);

return statearr_75046;
})();
if(cljs.core.truth_(inst_74950__$1)){
var statearr_75047_75131 = state_75017__$1;
(statearr_75047_75131[(1)] = (42));

} else {
var statearr_75048_75132 = state_75017__$1;
(statearr_75048_75132[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (56))){
var inst_74999 = (state_75017[(19)]);
var inst_74834 = (state_75017[(21)]);
var inst_75001 = fluree.db.api_js.format_block_resp_pretty(inst_74834,inst_74999);
var state_75017__$1 = state_75017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(59),inst_75001);
} else {
if((state_val_75018 === (33))){
var inst_74920 = (state_75017[(12)]);
var inst_74933 = (state_75017[(26)]);
var inst_74932 = (inst_74920 == null);
var inst_74933__$1 = cljs.core.not(inst_74932);
var state_75017__$1 = (function (){var statearr_75049 = state_75017;
(statearr_75049[(26)] = inst_74933__$1);

return statearr_75049;
})();
if(inst_74933__$1){
var statearr_75050_75133 = state_75017__$1;
(statearr_75050_75133[(1)] = (36));

} else {
var statearr_75051_75134 = state_75017__$1;
(statearr_75051_75134[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (13))){
var inst_74861 = (state_75017[(2)]);
var inst_74862 = fluree.db.util.async.throw_err(inst_74861);
var inst_74863 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74862);
var inst_74864 = (inst_74863 - (1));
var state_75017__$1 = state_75017;
var statearr_75052_75135 = state_75017__$1;
(statearr_75052_75135[(2)] = inst_74864);

(statearr_75052_75135[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (22))){
var state_75017__$1 = state_75017;
var statearr_75053_75136 = state_75017__$1;
(statearr_75053_75136[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (36))){
var inst_74921 = (state_75017[(10)]);
var inst_74935 = (inst_74921 == null);
var state_75017__$1 = state_75017;
var statearr_75055_75137 = state_75017__$1;
(statearr_75055_75137[(2)] = inst_74935);

(statearr_75055_75137[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (41))){
var inst_74984 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75056_75138 = state_75017__$1;
(statearr_75056_75138[(2)] = inst_74984);

(statearr_75056_75138[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (43))){
var inst_74950 = (state_75017[(25)]);
var state_75017__$1 = state_75017;
var statearr_75057_75139 = state_75017__$1;
(statearr_75057_75139[(2)] = inst_74950);

(statearr_75057_75139[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (61))){
var inst_75007 = (state_75017[(14)]);
var state_75017__$1 = state_75017;
var statearr_75058_75140 = state_75017__$1;
(statearr_75058_75140[(2)] = inst_75007);

(statearr_75058_75140[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (29))){
var inst_74907 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75059_75141 = state_75017__$1;
(statearr_75059_75141[(2)] = inst_74907);

(statearr_75059_75141[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (44))){
var inst_74962 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
if(cljs.core.truth_(inst_74962)){
var statearr_75060_75142 = state_75017__$1;
(statearr_75060_75142[(1)] = (48));

} else {
var statearr_75061_75143 = state_75017__$1;
(statearr_75061_75143[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (6))){
var inst_74838 = (state_75017[(2)]);
var inst_74839 = fluree.db.util.async.throw_err(inst_74838);
var state_75017__$1 = state_75017;
var statearr_75062_75144 = state_75017__$1;
(statearr_75062_75144[(2)] = inst_74839);

(statearr_75062_75144[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (28))){
var state_75017__$1 = state_75017;
var statearr_75063_75145 = state_75017__$1;
(statearr_75063_75145[(2)] = null);

(statearr_75063_75145[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (51))){
var inst_74830 = (state_75017[(16)]);
var inst_74972 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74830)].join('');
var inst_74973 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74974 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74975 = cljs.core.PersistentHashMap.fromArrays(inst_74973,inst_74974);
var inst_74976 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74972,inst_74975);
var inst_74977 = (function(){throw inst_74976})();
var state_75017__$1 = state_75017;
var statearr_75064_75146 = state_75017__$1;
(statearr_75064_75146[(2)] = inst_74977);

(statearr_75064_75146[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (25))){
var inst_74830 = (state_75017[(16)]);
var state_75017__$1 = state_75017;
var statearr_75065_75147 = state_75017__$1;
(statearr_75065_75147[(2)] = inst_74830);

(statearr_75065_75147[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (34))){
var inst_74930 = (state_75017[(22)]);
var state_75017__$1 = state_75017;
var statearr_75066_75148 = state_75017__$1;
(statearr_75066_75148[(2)] = inst_74930);

(statearr_75066_75148[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (17))){
var inst_74871 = (state_75017[(2)]);
var inst_74872 = fluree.db.util.async.throw_err(inst_74871);
var inst_74873 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74872);
var state_75017__$1 = state_75017;
var statearr_75067_75149 = state_75017__$1;
(statearr_75067_75149[(2)] = inst_74873);

(statearr_75067_75149[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (3))){
var inst_74834 = (state_75017[(21)]);
var inst_74836 = fluree.db.api_js.resolve_block_range(inst_74834,query_map);
var state_75017__$1 = state_75017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(6),inst_74836);
} else {
if((state_val_75018 === (12))){
var inst_74844 = (state_75017[(27)]);
var inst_74867 = (state_75017[(2)]);
var state_75017__$1 = (function (){var statearr_75068 = state_75017;
(statearr_75068[(23)] = inst_74867);

return statearr_75068;
})();
if(cljs.core.truth_(inst_74844)){
var statearr_75069_75150 = state_75017__$1;
(statearr_75069_75150[(1)] = (14));

} else {
var statearr_75070_75151 = state_75017__$1;
(statearr_75070_75151[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (2))){
var inst_74829 = (state_75017[(17)]);
var inst_74833 = (state_75017[(2)]);
var inst_74834 = fluree.db.util.async.throw_err(inst_74833);
var state_75017__$1 = (function (){var statearr_75071 = state_75017;
(statearr_75071[(21)] = inst_74834);

return statearr_75071;
})();
if(cljs.core.truth_(inst_74829)){
var statearr_75072_75152 = state_75017__$1;
(statearr_75072_75152[(1)] = (3));

} else {
var statearr_75073_75153 = state_75017__$1;
(statearr_75073_75153[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (23))){
var inst_74909 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75074_75154 = state_75017__$1;
(statearr_75074_75154[(2)] = inst_74909);

(statearr_75074_75154[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (47))){
var inst_74959 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75075_75155 = state_75017__$1;
(statearr_75075_75155[(2)] = inst_74959);

(statearr_75075_75155[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (35))){
var inst_74941 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
if(cljs.core.truth_(inst_74941)){
var statearr_75076_75156 = state_75017__$1;
(statearr_75076_75156[(1)] = (39));

} else {
var statearr_75077_75157 = state_75017__$1;
(statearr_75077_75157[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (19))){
var inst_74830 = (state_75017[(16)]);
var inst_74884 = cljs.core.sequential_QMARK_(inst_74830);
var state_75017__$1 = state_75017;
if(inst_74884){
var statearr_75078_75158 = state_75017__$1;
(statearr_75078_75158[(1)] = (21));

} else {
var statearr_75079_75159 = state_75017__$1;
(statearr_75079_75159[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (57))){
var inst_74999 = (state_75017[(19)]);
var state_75017__$1 = state_75017;
var statearr_75080_75160 = state_75017__$1;
(statearr_75080_75160[(2)] = inst_74999);

(statearr_75080_75160[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (11))){
var state_75017__$1 = state_75017;
var statearr_75081_75161 = state_75017__$1;
(statearr_75081_75161[(2)] = (-1));

(statearr_75081_75161[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (9))){
var inst_74856 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
if(cljs.core.truth_(inst_74856)){
var statearr_75082_75162 = state_75017__$1;
(statearr_75082_75162[(1)] = (10));

} else {
var statearr_75083_75163 = state_75017__$1;
(statearr_75083_75163[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (5))){
var inst_74843 = (state_75017[(7)]);
var inst_74842 = (state_75017[(2)]);
var inst_74843__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74842,(0),null);
var inst_74844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74842,(1),null);
var inst_74851 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75017__$1 = (function (){var statearr_75084 = state_75017;
(statearr_75084[(27)] = inst_74844);

(statearr_75084[(13)] = inst_74851);

(statearr_75084[(7)] = inst_74843__$1);

return statearr_75084;
})();
if(cljs.core.truth_(inst_74843__$1)){
var statearr_75085_75164 = state_75017__$1;
(statearr_75085_75164[(1)] = (7));

} else {
var statearr_75086_75165 = state_75017__$1;
(statearr_75086_75165[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (14))){
var inst_74844 = (state_75017[(27)]);
var inst_74834 = (state_75017[(21)]);
var inst_74869 = fluree.db.time_travel.as_of_block(inst_74834,inst_74844);
var state_75017__$1 = state_75017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(17),inst_74869);
} else {
if((state_val_75018 === (45))){
var inst_74921 = (state_75017[(10)]);
var inst_74955 = (inst_74921 == null);
var inst_74956 = cljs.core.not(inst_74955);
var state_75017__$1 = state_75017;
var statearr_75087_75166 = state_75017__$1;
(statearr_75087_75166[(2)] = inst_74956);

(statearr_75087_75166[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (53))){
var inst_74980 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75088_75167 = state_75017__$1;
(statearr_75088_75167[(2)] = inst_74980);

(statearr_75088_75167[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (26))){
var inst_74896 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75089_75168 = state_75017__$1;
(statearr_75089_75168[(2)] = inst_74896);

(statearr_75089_75168[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (16))){
var inst_74830 = (state_75017[(16)]);
var inst_74877 = (state_75017[(2)]);
var inst_74878 = fluree.db.util.core.subj_ident_QMARK_(inst_74830);
var state_75017__$1 = (function (){var statearr_75090 = state_75017;
(statearr_75090[(24)] = inst_74877);

return statearr_75090;
})();
if(inst_74878){
var statearr_75091_75169 = state_75017__$1;
(statearr_75091_75169[(1)] = (18));

} else {
var statearr_75092_75170 = state_75017__$1;
(statearr_75092_75170[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (38))){
var inst_74938 = (state_75017[(2)]);
var state_75017__$1 = state_75017;
var statearr_75093_75171 = state_75017__$1;
(statearr_75093_75171[(2)] = inst_74938);

(statearr_75093_75171[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (30))){
var inst_74911 = (state_75017[(9)]);
var inst_74926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74927 = [inst_74911,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_74928 = (new cljs.core.PersistentVector(null,2,(5),inst_74926,inst_74927,null));
var state_75017__$1 = state_75017;
var statearr_75094_75172 = state_75017__$1;
(statearr_75094_75172[(2)] = inst_74928);

(statearr_75094_75172[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (10))){
var inst_74834 = (state_75017[(21)]);
var inst_74843 = (state_75017[(7)]);
var inst_74858 = (inst_74843 - (1));
var inst_74859 = fluree.db.time_travel.as_of_block(inst_74834,inst_74858);
var state_75017__$1 = state_75017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75017__$1,(13),inst_74859);
} else {
if((state_val_75018 === (18))){
var inst_74830 = (state_75017[(16)]);
var inst_74880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74881 = [inst_74830];
var inst_74882 = (new cljs.core.PersistentVector(null,1,(5),inst_74880,inst_74881,null));
var state_75017__$1 = state_75017;
var statearr_75095_75173 = state_75017__$1;
(statearr_75095_75173[(2)] = inst_74882);

(statearr_75095_75173[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (52))){
var state_75017__$1 = state_75017;
var statearr_75096_75174 = state_75017__$1;
(statearr_75096_75174[(2)] = null);

(statearr_75096_75174[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (42))){
var inst_74953 = (state_75017[(20)]);
var inst_74920 = (state_75017[(12)]);
var inst_74952 = (inst_74920 == null);
var inst_74953__$1 = cljs.core.not(inst_74952);
var state_75017__$1 = (function (){var statearr_75097 = state_75017;
(statearr_75097[(20)] = inst_74953__$1);

return statearr_75097;
})();
if(inst_74953__$1){
var statearr_75098_75175 = state_75017__$1;
(statearr_75098_75175[(1)] = (45));

} else {
var statearr_75099_75176 = state_75017__$1;
(statearr_75099_75176[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (37))){
var inst_74933 = (state_75017[(26)]);
var state_75017__$1 = state_75017;
var statearr_75100_75177 = state_75017__$1;
(statearr_75100_75177[(2)] = inst_74933);

(statearr_75100_75177[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (8))){
var inst_74843 = (state_75017[(7)]);
var state_75017__$1 = state_75017;
var statearr_75101_75178 = state_75017__$1;
(statearr_75101_75178[(2)] = inst_74843);

(statearr_75101_75178[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75018 === (49))){
var state_75017__$1 = state_75017;
var statearr_75102_75179 = state_75017__$1;
(statearr_75102_75179[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_75104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75104[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_75104[(1)] = (1));

return statearr_75104;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_75017){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75017);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75105){var ex__2730__auto__ = e75105;
var statearr_75106_75180 = state_75017;
(statearr_75106_75180[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75017[(4)]))){
var statearr_75107_75181 = state_75017;
(statearr_75107_75181[(1)] = cljs.core.first((state_75017[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75182 = state_75017;
state_75017 = G__75182;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_75017){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_75017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75108 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75108[(6)] = c__2749__auto__);

return statearr_75108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__75190 = arguments.length;
switch (G__75190) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75183_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__75183_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75279){
var state_val_75280 = (state_75279[(1)]);
if((state_val_75280 === (7))){
var inst_75240 = (state_75279[(7)]);
var inst_75236 = (state_75279[(8)]);
var inst_75233 = (state_75279[(9)]);
var inst_75230 = (state_75279[(10)]);
var inst_75246 = (function (){var responses = inst_75230;
var responses_STAR_ = inst_75233;
var statuses = inst_75236;
var fuel = inst_75240;
return (function (p1__75186_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__75186_SHARP_);
});
})();
var inst_75247 = cljs.core.some(inst_75246,inst_75236);
var state_75279__$1 = state_75279;
if(cljs.core.truth_(inst_75247)){
var statearr_75281_75329 = state_75279__$1;
(statearr_75281_75329[(1)] = (9));

} else {
var statearr_75282_75330 = state_75279__$1;
(statearr_75282_75330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (20))){
var inst_75274 = (state_75279[(2)]);
var state_75279__$1 = state_75279;
var statearr_75283_75331 = state_75279__$1;
(statearr_75283_75331[(2)] = inst_75274);

(statearr_75283_75331[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (1))){
var inst_75225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75226 = (function (){var c__2749__auto____$1 = inst_75225;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75223){
var state_val_75224 = (state_75223[(1)]);
if((state_val_75224 === (1))){
var inst_75191 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_75192 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_75193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75192,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_75194 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_75195 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_75196 = cljs.core.PersistentHashMap.EMPTY;
var inst_75197 = inst_75191;
var inst_75198 = inst_75193;
var inst_75199 = inst_75194;
var inst_75200 = inst_75195;
var inst_75201 = inst_75196;
var state_75223__$1 = (function (){var statearr_75284 = state_75223;
(statearr_75284[(7)] = inst_75200);

(statearr_75284[(8)] = inst_75197);

(statearr_75284[(9)] = inst_75198);

(statearr_75284[(10)] = inst_75199);

(statearr_75284[(11)] = inst_75201);

return statearr_75284;
})();
var statearr_75285_75332 = state_75223__$1;
(statearr_75285_75332[(2)] = null);

(statearr_75285_75332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75224 === (2))){
var inst_75198 = (state_75223[(9)]);
var inst_75203 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_75198);
var inst_75204 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_75203], 0));
var inst_75205 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75198,new cljs.core.Keyword(null,"opts","opts",155075701),inst_75204);
var inst_75206 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_75205,db_fn);
var state_75223__$1 = state_75223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75223__$1,(4),inst_75206);
} else {
if((state_val_75224 === (3))){
var inst_75221 = (state_75223[(2)]);
var state_75223__$1 = state_75223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75223__$1,inst_75221);
} else {
if((state_val_75224 === (4))){
var inst_75197 = (state_75223[(8)]);
var inst_75199 = (state_75223[(10)]);
var inst_75201 = (state_75223[(11)]);
var inst_75208 = (state_75223[(2)]);
var inst_75209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75201,inst_75197,inst_75208);
var inst_75210 = cljs.core.first(inst_75199);
var state_75223__$1 = (function (){var statearr_75286 = state_75223;
(statearr_75286[(12)] = inst_75209);

return statearr_75286;
})();
if(cljs.core.truth_(inst_75210)){
var statearr_75287_75333 = state_75223__$1;
(statearr_75287_75333[(1)] = (5));

} else {
var statearr_75288_75334 = state_75223__$1;
(statearr_75288_75334[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75224 === (5))){
var inst_75209 = (state_75223[(12)]);
var inst_75200 = (state_75223[(7)]);
var inst_75199 = (state_75223[(10)]);
var inst_75212 = cljs.core.first(inst_75199);
var inst_75213 = cljs.core.first(inst_75200);
var inst_75214 = cljs.core.rest(inst_75199);
var inst_75215 = cljs.core.rest(inst_75200);
var inst_75197 = inst_75212;
var inst_75198 = inst_75213;
var inst_75199__$1 = inst_75214;
var inst_75200__$1 = inst_75215;
var inst_75201 = inst_75209;
var state_75223__$1 = (function (){var statearr_75289 = state_75223;
(statearr_75289[(7)] = inst_75200__$1);

(statearr_75289[(8)] = inst_75197);

(statearr_75289[(9)] = inst_75198);

(statearr_75289[(10)] = inst_75199__$1);

(statearr_75289[(11)] = inst_75201);

return statearr_75289;
})();
var statearr_75290_75335 = state_75223__$1;
(statearr_75290_75335[(2)] = null);

(statearr_75290_75335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75224 === (6))){
var inst_75209 = (state_75223[(12)]);
var state_75223__$1 = state_75223;
var statearr_75291_75336 = state_75223__$1;
(statearr_75291_75336[(2)] = inst_75209);

(statearr_75291_75336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75224 === (7))){
var inst_75219 = (state_75223[(2)]);
var state_75223__$1 = state_75223;
var statearr_75292_75337 = state_75223__$1;
(statearr_75292_75337[(2)] = inst_75219);

(statearr_75292_75337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_75293 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75293[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_75293[(1)] = (1));

return statearr_75293;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_75223){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75223);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75294){var ex__2730__auto__ = e75294;
var statearr_75295_75338 = state_75223;
(statearr_75295_75338[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75223[(4)]))){
var statearr_75296_75339 = state_75223;
(statearr_75296_75339[(1)] = cljs.core.first((state_75223[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75340 = state_75223;
state_75223 = G__75340;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_75223){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_75223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75297 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75297[(6)] = c__2749__auto____$1);

return statearr_75297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_75227 = cljs.core.async.impl.dispatch.run(inst_75226);
var state_75279__$1 = (function (){var statearr_75298 = state_75279;
(statearr_75298[(11)] = inst_75227);

return statearr_75298;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75279__$1,(2),inst_75225);
} else {
if((state_val_75280 === (4))){
var inst_75230 = (state_75279[(10)]);
var state_75279__$1 = state_75279;
var statearr_75299_75341 = state_75279__$1;
(statearr_75299_75341[(2)] = inst_75230);

(statearr_75299_75341[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (15))){
var state_75279__$1 = state_75279;
var statearr_75300_75342 = state_75279__$1;
(statearr_75300_75342[(2)] = (400));

(statearr_75300_75342[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (13))){
var state_75279__$1 = state_75279;
var statearr_75301_75343 = state_75279__$1;
(statearr_75301_75343[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (6))){
var inst_75236 = (state_75279[(8)]);
var inst_75244 = cljs.core.first(inst_75236);
var state_75279__$1 = state_75279;
var statearr_75303_75344 = state_75279__$1;
(statearr_75303_75344[(2)] = inst_75244);

(statearr_75303_75344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (17))){
var inst_75257 = (state_75279[(2)]);
var state_75279__$1 = state_75279;
var statearr_75304_75345 = state_75279__$1;
(statearr_75304_75345[(2)] = inst_75257);

(statearr_75304_75345[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (3))){
var inst_75240 = (state_75279[(7)]);
var inst_75236 = (state_75279[(8)]);
var inst_75233 = (state_75279[(9)]);
var inst_75230 = (state_75279[(10)]);
var inst_75235 = cljs.core.vals(inst_75230);
var inst_75236__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_75235);
var inst_75237 = (function (){var responses = inst_75230;
var responses_STAR_ = inst_75233;
var statuses = inst_75236__$1;
return (function (p1__75184_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__75184_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_75238 = cljs.core.vals(inst_75230);
var inst_75239 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_75237,inst_75238);
var inst_75240__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_75239);
var inst_75241 = (function (){var responses = inst_75230;
var responses_STAR_ = inst_75233;
var statuses = inst_75236__$1;
var fuel = inst_75240__$1;
return (function (p1__75185_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__75185_SHARP_);
});
})();
var inst_75242 = cljs.core.every_QMARK_(inst_75241,inst_75236__$1);
var state_75279__$1 = (function (){var statearr_75305 = state_75279;
(statearr_75305[(7)] = inst_75240__$1);

(statearr_75305[(8)] = inst_75236__$1);

return statearr_75305;
})();
if(inst_75242){
var statearr_75306_75346 = state_75279__$1;
(statearr_75306_75346[(1)] = (6));

} else {
var statearr_75307_75347 = state_75279__$1;
(statearr_75307_75347[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (12))){
var state_75279__$1 = state_75279;
var statearr_75308_75348 = state_75279__$1;
(statearr_75308_75348[(2)] = (500));

(statearr_75308_75348[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (2))){
var inst_75230 = (state_75279[(10)]);
var inst_75229 = (state_75279[(2)]);
var inst_75230__$1 = fluree.db.util.async.throw_err(inst_75229);
var inst_75231 = (function (){var responses = inst_75230__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_75232 = cljs.core.PersistentHashMap.EMPTY;
var inst_75233 = cljs.core.reduce_kv(inst_75231,inst_75232,inst_75230__$1);
var state_75279__$1 = (function (){var statearr_75309 = state_75279;
(statearr_75309[(9)] = inst_75233);

(statearr_75309[(10)] = inst_75230__$1);

return statearr_75309;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_75310_75349 = state_75279__$1;
(statearr_75310_75349[(1)] = (3));

} else {
var statearr_75311_75350 = state_75279__$1;
(statearr_75311_75350[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (19))){
var inst_75240 = (state_75279[(7)]);
var inst_75263 = (state_75279[(12)]);
var inst_75233 = (state_75279[(9)]);
var inst_75272 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75233,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75263,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75240], 0));
var state_75279__$1 = state_75279;
var statearr_75312_75351 = state_75279__$1;
(statearr_75312_75351[(2)] = inst_75272);

(statearr_75312_75351[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (11))){
var inst_75261 = (state_75279[(2)]);
var state_75279__$1 = state_75279;
var statearr_75313_75352 = state_75279__$1;
(statearr_75313_75352[(2)] = inst_75261);

(statearr_75313_75352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (9))){
var state_75279__$1 = state_75279;
var statearr_75314_75353 = state_75279__$1;
(statearr_75314_75353[(2)] = (207));

(statearr_75314_75353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (5))){
var inst_75277 = (state_75279[(2)]);
var state_75279__$1 = state_75279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75279__$1,inst_75277);
} else {
if((state_val_75280 === (14))){
var inst_75259 = (state_75279[(2)]);
var state_75279__$1 = state_75279;
var statearr_75315_75354 = state_75279__$1;
(statearr_75315_75354[(2)] = inst_75259);

(statearr_75315_75354[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (16))){
var state_75279__$1 = state_75279;
var statearr_75316_75355 = state_75279__$1;
(statearr_75316_75355[(2)] = null);

(statearr_75316_75355[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (10))){
var inst_75240 = (state_75279[(7)]);
var inst_75236 = (state_75279[(8)]);
var inst_75233 = (state_75279[(9)]);
var inst_75230 = (state_75279[(10)]);
var inst_75250 = (function (){var responses = inst_75230;
var responses_STAR_ = inst_75233;
var statuses = inst_75236;
var fuel = inst_75240;
return (function (p1__75187_SHARP_){
return ((499) < p1__75187_SHARP_);
});
})();
var inst_75251 = cljs.core.some(inst_75250,inst_75236);
var state_75279__$1 = state_75279;
if(cljs.core.truth_(inst_75251)){
var statearr_75317_75356 = state_75279__$1;
(statearr_75317_75356[(1)] = (12));

} else {
var statearr_75318_75357 = state_75279__$1;
(statearr_75318_75357[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (18))){
var inst_75240 = (state_75279[(7)]);
var inst_75263 = (state_75279[(12)]);
var inst_75268 = (state_75279[(13)]);
var inst_75233 = (state_75279[(9)]);
var inst_75270 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75233,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75263,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75240,new cljs.core.Keyword(null,"block","block",664686210),inst_75268], 0));
var state_75279__$1 = state_75279;
var statearr_75319_75358 = state_75279__$1;
(statearr_75319_75358[(2)] = inst_75270);

(statearr_75319_75358[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75280 === (8))){
var inst_75240 = (state_75279[(7)]);
var inst_75263 = (state_75279[(12)]);
var inst_75236 = (state_75279[(8)]);
var inst_75268 = (state_75279[(13)]);
var inst_75233 = (state_75279[(9)]);
var inst_75230 = (state_75279[(10)]);
var inst_75263__$1 = (state_75279[(2)]);
var inst_75264 = (function (){var responses = inst_75230;
var responses_STAR_ = inst_75233;
var statuses = inst_75236;
var fuel = inst_75240;
var status = inst_75263__$1;
return (function (p1__75188_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__75188_SHARP_));
});
})();
var inst_75265 = cljs.core.vals(inst_75230);
var inst_75266 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_75264,inst_75265);
var inst_75267 = cljs.core.first(inst_75266);
var inst_75268__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75267);
var state_75279__$1 = (function (){var statearr_75320 = state_75279;
(statearr_75320[(12)] = inst_75263__$1);

(statearr_75320[(13)] = inst_75268__$1);

return statearr_75320;
})();
if(cljs.core.truth_(inst_75268__$1)){
var statearr_75321_75359 = state_75279__$1;
(statearr_75321_75359[(1)] = (18));

} else {
var statearr_75322_75360 = state_75279__$1;
(statearr_75322_75360[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_75323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75323[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_75323[(1)] = (1));

return statearr_75323;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_75279){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75279);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75324){var ex__2730__auto__ = e75324;
var statearr_75325_75361 = state_75279;
(statearr_75325_75361[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75279[(4)]))){
var statearr_75326_75362 = state_75279;
(statearr_75326_75362[(1)] = cljs.core.first((state_75279[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75363 = state_75279;
state_75279 = G__75363;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_75279){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_75279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75327 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75327[(6)] = c__2749__auto__);

return statearr_75327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__75365 = arguments.length;
switch (G__75365) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__75366 = opts;
var map__75366__$1 = cljs.core.__destructure_map(map__75366);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75366__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75366__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75366__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75366__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__75367 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75367,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75367,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e75370){var e = e75370;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__75373 = arguments.length;
switch (G__75373) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75407){
var state_val_75408 = (state_75407[(1)]);
if((state_val_75408 === (7))){
var state_75407__$1 = state_75407;
var statearr_75409_75430 = state_75407__$1;
(statearr_75409_75430[(2)] = opts);

(statearr_75409_75430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (1))){
var state_75407__$1 = state_75407;
var statearr_75410_75431 = state_75407__$1;
(statearr_75410_75431[(2)] = null);

(statearr_75410_75431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (4))){
var inst_75374 = (state_75407[(2)]);
var inst_75375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75376 = [inst_75374];
var inst_75377 = (new cljs.core.PersistentVector(null,1,(5),inst_75375,inst_75376,null));
var inst_75378 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75377);
var inst_75379 = cljs.core.ex_data(inst_75374);
var inst_75380 = cljs.core.ex_message(inst_75374);
var inst_75381 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75379,new cljs.core.Keyword(null,"message","message",-406056002),inst_75380);
var state_75407__$1 = (function (){var statearr_75411 = state_75407;
(statearr_75411[(7)] = inst_75378);

return statearr_75411;
})();
var statearr_75412_75432 = state_75407__$1;
(statearr_75412_75432[(2)] = inst_75381);

(statearr_75412_75432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (6))){
var inst_75391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75392 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_75393 = (new cljs.core.PersistentVector(null,1,(5),inst_75391,inst_75392,null));
var inst_75394 = cljs.core.assoc_in(opts,inst_75393,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_75407__$1 = state_75407;
var statearr_75413_75433 = state_75407__$1;
(statearr_75413_75433[(2)] = inst_75394);

(statearr_75413_75433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (3))){
var inst_75405 = (state_75407[(2)]);
var state_75407__$1 = state_75407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75407__$1,inst_75405);
} else {
if((state_val_75408 === (2))){
var _ = (function (){var statearr_75415 = state_75407;
(statearr_75415[(4)] = cljs.core.cons((5),(state_75407[(4)])));

return statearr_75415;
})();
var inst_75387 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_75388 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_75389 = (inst_75388 == null);
var state_75407__$1 = (function (){var statearr_75416 = state_75407;
(statearr_75416[(8)] = inst_75387);

return statearr_75416;
})();
if(cljs.core.truth_(inst_75389)){
var statearr_75417_75434 = state_75407__$1;
(statearr_75417_75434[(1)] = (6));

} else {
var statearr_75418_75435 = state_75407__$1;
(statearr_75418_75435[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (9))){
var inst_75401 = (state_75407[(2)]);
var inst_75402 = fluree.db.util.async.throw_err(inst_75401);
var _ = (function (){var statearr_75419 = state_75407;
(statearr_75419[(4)] = cljs.core.rest((state_75407[(4)])));

return statearr_75419;
})();
var state_75407__$1 = state_75407;
var statearr_75420_75436 = state_75407__$1;
(statearr_75420_75436[(2)] = inst_75402);

(statearr_75420_75436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (5))){
var _ = (function (){var statearr_75421 = state_75407;
(statearr_75421[(4)] = cljs.core.rest((state_75407[(4)])));

return statearr_75421;
})();
var state_75407__$1 = state_75407;
var ex75414 = (state_75407__$1[(2)]);
var statearr_75422_75437 = state_75407__$1;
(statearr_75422_75437[(5)] = ex75414);


var statearr_75423_75438 = state_75407__$1;
(statearr_75423_75438[(1)] = (4));

(statearr_75423_75438[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75408 === (8))){
var inst_75387 = (state_75407[(8)]);
var inst_75397 = (state_75407[(2)]);
var inst_75398 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_75387,inst_75397);
var inst_75399 = fluree.db.operations.command_async(conn,inst_75398);
var state_75407__$1 = state_75407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75407__$1,(9),inst_75399);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_75424 = [null,null,null,null,null,null,null,null,null];
(statearr_75424[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_75424[(1)] = (1));

return statearr_75424;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_75407){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75407);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75425){var ex__2730__auto__ = e75425;
var statearr_75426_75439 = state_75407;
(statearr_75426_75439[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75407[(4)]))){
var statearr_75427_75440 = state_75407;
(statearr_75427_75440[(1)] = cljs.core.first((state_75407[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75441 = state_75407;
state_75407 = G__75441;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_75407){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_75407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75428 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75428[(6)] = c__2749__auto__);

return statearr_75428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

