// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__69521 = arguments.length;
switch (G__69521) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___69669 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69608){
var state_val_69609 = (state_69608[(1)]);
if((state_val_69609 === (7))){
var inst_69539 = (state_69608[(7)]);
var inst_69542 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_69539);
var state_69608__$1 = state_69608;
var statearr_69610_69670 = state_69608__$1;
(statearr_69610_69670[(2)] = inst_69542);

(statearr_69610_69670[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (20))){
var inst_69534 = (state_69608[(8)]);
var inst_69563 = (state_69608[(9)]);
var inst_69567 = fluree.db.auth.roles(inst_69534,inst_69563);
var state_69608__$1 = state_69608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69608__$1,(23),inst_69567);
} else {
if((state_val_69609 === (27))){
var inst_69534 = (state_69608[(8)]);
var inst_69582 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69583 = fluree.db.time_travel.as_of_block(inst_69534,inst_69582);
var state_69608__$1 = state_69608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69608__$1,(30),inst_69583);
} else {
if((state_val_69609 === (1))){
var state_69608__$1 = state_69608;
var statearr_69611_69671 = state_69608__$1;
(statearr_69611_69671[(2)] = null);

(statearr_69611_69671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (24))){
var inst_69575 = (state_69608[(10)]);
var inst_69534 = (state_69608[(8)]);
var inst_69577 = fluree.db.permissions.permission_map(inst_69534,inst_69575,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_69608__$1 = state_69608;
var statearr_69612_69672 = state_69608__$1;
(statearr_69612_69672[(2)] = inst_69577);

(statearr_69612_69672[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (4))){
var inst_69522 = (state_69608[(2)]);
var inst_69523 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69522);
var inst_69524 = cljs.core.async.close_BANG_(pc);
var state_69608__$1 = (function (){var statearr_69613 = state_69608;
(statearr_69613[(11)] = inst_69523);

return statearr_69613;
})();
var statearr_69614_69673 = state_69608__$1;
(statearr_69614_69673[(2)] = inst_69524);

(statearr_69614_69673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (15))){
var inst_69539 = (state_69608[(7)]);
var inst_69553 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69539)," unknown."].join('');
var inst_69554 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69555 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69556 = cljs.core.PersistentHashMap.fromArrays(inst_69554,inst_69555);
var inst_69557 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69553,inst_69556);
var inst_69558 = (function(){throw inst_69557})();
var state_69608__$1 = state_69608;
var statearr_69615_69674 = state_69608__$1;
(statearr_69615_69674[(2)] = inst_69558);

(statearr_69615_69674[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (21))){
var state_69608__$1 = state_69608;
var statearr_69616_69675 = state_69608__$1;
(statearr_69616_69675[(2)] = null);

(statearr_69616_69675[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (31))){
var inst_69589 = (state_69608[(12)]);
var inst_69539 = (state_69608[(7)]);
var inst_69591 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69589,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69539);
var state_69608__$1 = state_69608;
var statearr_69617_69676 = state_69608__$1;
(statearr_69617_69676[(2)] = inst_69591);

(statearr_69617_69676[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (32))){
var inst_69589 = (state_69608[(12)]);
var state_69608__$1 = state_69608;
var statearr_69618_69677 = state_69608__$1;
(statearr_69618_69677[(2)] = inst_69589);

(statearr_69618_69677[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (33))){
var inst_69575 = (state_69608[(10)]);
var inst_69594 = (state_69608[(2)]);
var state_69608__$1 = (function (){var statearr_69619 = state_69608;
(statearr_69619[(13)] = inst_69594);

return statearr_69619;
})();
if(cljs.core.truth_(inst_69575)){
var statearr_69620_69678 = state_69608__$1;
(statearr_69620_69678[(1)] = (34));

} else {
var statearr_69621_69679 = state_69608__$1;
(statearr_69621_69679[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (13))){
var inst_69550 = (state_69608[(14)]);
var inst_69549 = (state_69608[(2)]);
var inst_69550__$1 = fluree.db.util.async.throw_err(inst_69549);
var state_69608__$1 = (function (){var statearr_69622 = state_69608;
(statearr_69622[(14)] = inst_69550__$1);

return statearr_69622;
})();
if(cljs.core.truth_(inst_69550__$1)){
var statearr_69623_69680 = state_69608__$1;
(statearr_69623_69680[(1)] = (14));

} else {
var statearr_69624_69681 = state_69608__$1;
(statearr_69624_69681[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (22))){
var inst_69573 = (state_69608[(2)]);
var state_69608__$1 = state_69608;
var statearr_69625_69682 = state_69608__$1;
(statearr_69625_69682[(2)] = inst_69573);

(statearr_69625_69682[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (36))){
var inst_69602 = (state_69608[(2)]);
var inst_69603 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69602);
var _ = (function (){var statearr_69626 = state_69608;
(statearr_69626[(4)] = cljs.core.rest((state_69608[(4)])));

return statearr_69626;
})();
var state_69608__$1 = state_69608;
var statearr_69627_69683 = state_69608__$1;
(statearr_69627_69683[(2)] = inst_69603);

(statearr_69627_69683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (29))){
var inst_69539 = (state_69608[(7)]);
var inst_69589 = (state_69608[(2)]);
var state_69608__$1 = (function (){var statearr_69628 = state_69608;
(statearr_69628[(12)] = inst_69589);

return statearr_69628;
})();
if(cljs.core.truth_(inst_69539)){
var statearr_69629_69684 = state_69608__$1;
(statearr_69629_69684[(1)] = (31));

} else {
var statearr_69630_69685 = state_69608__$1;
(statearr_69630_69685[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (6))){
var inst_69539 = (state_69608[(7)]);
var inst_69533 = (state_69608[(2)]);
var inst_69534 = fluree.db.util.async.throw_err(inst_69533);
var inst_69535 = opts;
var inst_69536 = cljs.core.__destructure_map(inst_69535);
var inst_69537 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69536,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69536,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69539__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69536,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69540 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69536,new cljs.core.Keyword(null,"block","block",664686210));
var state_69608__$1 = (function (){var statearr_69631 = state_69608;
(statearr_69631[(15)] = inst_69538);

(statearr_69631[(8)] = inst_69534);

(statearr_69631[(16)] = inst_69537);

(statearr_69631[(17)] = inst_69540);

(statearr_69631[(7)] = inst_69539__$1);

return statearr_69631;
})();
if(cljs.core.truth_(inst_69539__$1)){
var statearr_69632_69686 = state_69608__$1;
(statearr_69632_69686[(1)] = (7));

} else {
var statearr_69633_69687 = state_69608__$1;
(statearr_69633_69687[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (28))){
var inst_69534 = (state_69608[(8)]);
var state_69608__$1 = state_69608;
var statearr_69634_69688 = state_69608__$1;
(statearr_69634_69688[(2)] = inst_69534);

(statearr_69634_69688[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (25))){
var state_69608__$1 = state_69608;
var statearr_69635_69689 = state_69608__$1;
(statearr_69635_69689[(2)] = null);

(statearr_69635_69689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (34))){
var inst_69580 = (state_69608[(18)]);
var state_69608__$1 = state_69608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69608__$1,(37),inst_69580);
} else {
if((state_val_69609 === (17))){
var inst_69537 = (state_69608[(16)]);
var state_69608__$1 = state_69608;
var statearr_69636_69690 = state_69608__$1;
(statearr_69636_69690[(2)] = inst_69537);

(statearr_69636_69690[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (3))){
var inst_69606 = (state_69608[(2)]);
var state_69608__$1 = state_69608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69608__$1,inst_69606);
} else {
if((state_val_69609 === (12))){
var inst_69537 = (state_69608[(16)]);
var inst_69563 = (state_69608[(2)]);
var state_69608__$1 = (function (){var statearr_69637 = state_69608;
(statearr_69637[(9)] = inst_69563);

return statearr_69637;
})();
if(cljs.core.truth_(inst_69537)){
var statearr_69638_69691 = state_69608__$1;
(statearr_69638_69691[(1)] = (17));

} else {
var statearr_69639_69692 = state_69608__$1;
(statearr_69639_69692[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (2))){
var _ = (function (){var statearr_69640 = state_69608;
(statearr_69640[(4)] = cljs.core.cons((5),(state_69608[(4)])));

return statearr_69640;
})();
var inst_69531 = fluree.db.session.db(conn,ledger,null);
var state_69608__$1 = state_69608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69608__$1,(6),inst_69531);
} else {
if((state_val_69609 === (23))){
var inst_69569 = (state_69608[(2)]);
var inst_69570 = fluree.db.util.async.throw_err(inst_69569);
var state_69608__$1 = state_69608;
var statearr_69641_69693 = state_69608__$1;
(statearr_69641_69693[(2)] = inst_69570);

(statearr_69641_69693[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (35))){
var inst_69594 = (state_69608[(13)]);
var state_69608__$1 = state_69608;
var statearr_69642_69694 = state_69608__$1;
(statearr_69642_69694[(2)] = inst_69594);

(statearr_69642_69694[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (19))){
var inst_69575 = (state_69608[(10)]);
var inst_69575__$1 = (state_69608[(2)]);
var state_69608__$1 = (function (){var statearr_69643 = state_69608;
(statearr_69643[(10)] = inst_69575__$1);

return statearr_69643;
})();
if(cljs.core.truth_(inst_69575__$1)){
var statearr_69644_69695 = state_69608__$1;
(statearr_69644_69695[(1)] = (24));

} else {
var statearr_69645_69696 = state_69608__$1;
(statearr_69645_69696[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (11))){
var state_69608__$1 = state_69608;
var statearr_69647_69697 = state_69608__$1;
(statearr_69647_69697[(2)] = null);

(statearr_69647_69697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (9))){
var inst_69545 = (state_69608[(2)]);
var state_69608__$1 = state_69608;
if(cljs.core.truth_(inst_69545)){
var statearr_69648_69698 = state_69608__$1;
(statearr_69648_69698[(1)] = (10));

} else {
var statearr_69649_69699 = state_69608__$1;
(statearr_69649_69699[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (5))){
var _ = (function (){var statearr_69650 = state_69608;
(statearr_69650[(4)] = cljs.core.rest((state_69608[(4)])));

return statearr_69650;
})();
var state_69608__$1 = state_69608;
var ex69646 = (state_69608__$1[(2)]);
var statearr_69651_69700 = state_69608__$1;
(statearr_69651_69700[(5)] = ex69646);


var statearr_69652_69701 = state_69608__$1;
(statearr_69652_69701[(1)] = (4));

(statearr_69652_69701[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (14))){
var inst_69550 = (state_69608[(14)]);
var state_69608__$1 = state_69608;
var statearr_69653_69702 = state_69608__$1;
(statearr_69653_69702[(2)] = inst_69550);

(statearr_69653_69702[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (26))){
var inst_69540 = (state_69608[(17)]);
var inst_69580 = (state_69608[(2)]);
var state_69608__$1 = (function (){var statearr_69654 = state_69608;
(statearr_69654[(18)] = inst_69580);

return statearr_69654;
})();
if(cljs.core.truth_(inst_69540)){
var statearr_69655_69703 = state_69608__$1;
(statearr_69655_69703[(1)] = (27));

} else {
var statearr_69656_69704 = state_69608__$1;
(statearr_69656_69704[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (16))){
var inst_69560 = (state_69608[(2)]);
var state_69608__$1 = state_69608;
var statearr_69657_69705 = state_69608__$1;
(statearr_69657_69705[(2)] = inst_69560);

(statearr_69657_69705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (30))){
var inst_69585 = (state_69608[(2)]);
var inst_69586 = fluree.db.util.async.throw_err(inst_69585);
var state_69608__$1 = state_69608;
var statearr_69658_69706 = state_69608__$1;
(statearr_69658_69706[(2)] = inst_69586);

(statearr_69658_69706[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (10))){
var inst_69534 = (state_69608[(8)]);
var inst_69539 = (state_69608[(7)]);
var inst_69547 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_69534,inst_69539);
var state_69608__$1 = state_69608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69608__$1,(13),inst_69547);
} else {
if((state_val_69609 === (18))){
var inst_69563 = (state_69608[(9)]);
var state_69608__$1 = state_69608;
if(cljs.core.truth_(inst_69563)){
var statearr_69659_69707 = state_69608__$1;
(statearr_69659_69707[(1)] = (20));

} else {
var statearr_69660_69708 = state_69608__$1;
(statearr_69660_69708[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (37))){
var inst_69594 = (state_69608[(13)]);
var inst_69597 = (state_69608[(2)]);
var inst_69598 = fluree.db.util.async.throw_err(inst_69597);
var inst_69599 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69594,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_69598);
var state_69608__$1 = state_69608;
var statearr_69661_69709 = state_69608__$1;
(statearr_69661_69709[(2)] = inst_69599);

(statearr_69661_69709[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69609 === (8))){
var inst_69539 = (state_69608[(7)]);
var state_69608__$1 = state_69608;
var statearr_69662_69710 = state_69608__$1;
(statearr_69662_69710[(2)] = inst_69539);

(statearr_69662_69710[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_69663 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69663[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_69663[(1)] = (1));

return statearr_69663;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_69608){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69608);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69664){var ex__2730__auto__ = e69664;
var statearr_69665_69711 = state_69608;
(statearr_69665_69711[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69608[(4)]))){
var statearr_69666_69712 = state_69608;
(statearr_69666_69712[(1)] = cljs.core.first((state_69608[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69713 = state_69608;
state_69608 = G__69713;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_69608){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_69608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69667 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69667[(6)] = c__2749__auto___69669);

return statearr_69667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69854){
var state_val_69855 = (state_69854[(1)]);
if((state_val_69855 === (7))){
var inst_69734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69735 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69736 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69737 = [inst_69735,inst_69736];
var inst_69738 = (new cljs.core.PersistentVector(null,2,(5),inst_69734,inst_69737,null));
var state_69854__$1 = state_69854;
var statearr_69856_69926 = state_69854__$1;
(statearr_69856_69926[(2)] = inst_69738);

(statearr_69856_69926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (20))){
var inst_69764 = (state_69854[(7)]);
var state_69854__$1 = state_69854;
var statearr_69857_69927 = state_69854__$1;
(statearr_69857_69927[(2)] = inst_69764);

(statearr_69857_69927[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (27))){
var state_69854__$1 = state_69854;
var statearr_69858_69928 = state_69854__$1;
(statearr_69858_69928[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (1))){
var state_69854__$1 = state_69854;
var statearr_69860_69929 = state_69854__$1;
(statearr_69860_69929[(2)] = null);

(statearr_69860_69929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (24))){
var inst_69763 = (state_69854[(8)]);
var state_69854__$1 = state_69854;
if(cljs.core.truth_(inst_69763)){
var statearr_69861_69930 = state_69854__$1;
(statearr_69861_69930[(1)] = (26));

} else {
var statearr_69862_69931 = state_69854__$1;
(statearr_69862_69931[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (39))){
var inst_69810 = (state_69854[(9)]);
var inst_69809 = (state_69854[(10)]);
var inst_69835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69836 = [inst_69809,inst_69810];
var inst_69837 = (new cljs.core.PersistentVector(null,2,(5),inst_69835,inst_69836,null));
var state_69854__$1 = state_69854;
var statearr_69863_69932 = state_69854__$1;
(statearr_69863_69932[(2)] = inst_69837);

(statearr_69863_69932[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (4))){
var inst_69714 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
var statearr_69864_69933 = state_69854__$1;
(statearr_69864_69933[(2)] = inst_69714);

(statearr_69864_69933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (15))){
var inst_69748 = (state_69854[(11)]);
var inst_69743 = (state_69854[(12)]);
var inst_69757 = (state_69854[(2)]);
var inst_69758 = [inst_69748,inst_69757];
var inst_69759 = (new cljs.core.PersistentVector(null,2,(5),inst_69743,inst_69758,null));
var state_69854__$1 = state_69854;
var statearr_69865_69934 = state_69854__$1;
(statearr_69865_69934[(2)] = inst_69759);

(statearr_69865_69934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (21))){
var inst_69763 = (state_69854[(8)]);
var state_69854__$1 = state_69854;
var statearr_69866_69935 = state_69854__$1;
(statearr_69866_69935[(2)] = inst_69763);

(statearr_69866_69935[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (31))){
var inst_69804 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
var statearr_69867_69936 = state_69854__$1;
(statearr_69867_69936[(2)] = inst_69804);

(statearr_69867_69936[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (32))){
var inst_69810 = (state_69854[(9)]);
var inst_69813 = cljs.core.pos_int_QMARK_(inst_69810);
var state_69854__$1 = state_69854;
var statearr_69868_69937 = state_69854__$1;
(statearr_69868_69937[(2)] = inst_69813);

(statearr_69868_69937[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (40))){
var inst_69841 = (state_69854[(13)]);
var inst_69765 = (state_69854[(14)]);
var inst_69839 = (state_69854[(2)]);
var inst_69840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69839,(0),null);
var inst_69841__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69839,(1),null);
var inst_69842 = (inst_69841__$1 > inst_69765);
var state_69854__$1 = (function (){var statearr_69869 = state_69854;
(statearr_69869[(13)] = inst_69841__$1);

(statearr_69869[(15)] = inst_69840);

return statearr_69869;
})();
if(cljs.core.truth_(inst_69842)){
var statearr_69870_69938 = state_69854__$1;
(statearr_69870_69938[(1)] = (41));

} else {
var statearr_69871_69939 = state_69854__$1;
(statearr_69871_69939[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (33))){
var inst_69811 = (state_69854[(16)]);
var state_69854__$1 = state_69854;
var statearr_69872_69940 = state_69854__$1;
(statearr_69872_69940[(2)] = inst_69811);

(statearr_69872_69940[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (13))){
var inst_69749 = (state_69854[(17)]);
var inst_69751 = fluree.db.time_travel.block_to_int_format(db,inst_69749);
var state_69854__$1 = state_69854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69854__$1,(16),inst_69751);
} else {
if((state_val_69855 === (22))){
var inst_69782 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
if(cljs.core.truth_(inst_69782)){
var statearr_69873_69941 = state_69854__$1;
(statearr_69873_69941[(1)] = (23));

} else {
var statearr_69874_69942 = state_69854__$1;
(statearr_69874_69942[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (36))){
var state_69854__$1 = state_69854;
var statearr_69875_69943 = state_69854__$1;
(statearr_69875_69943[(2)] = null);

(statearr_69875_69943[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (41))){
var inst_69765 = (state_69854[(14)]);
var state_69854__$1 = state_69854;
var statearr_69876_69944 = state_69854__$1;
(statearr_69876_69944[(2)] = inst_69765);

(statearr_69876_69944[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (43))){
var inst_69840 = (state_69854[(15)]);
var inst_69846 = (state_69854[(2)]);
var inst_69847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69848 = [inst_69840,inst_69846];
var inst_69849 = (new cljs.core.PersistentVector(null,2,(5),inst_69847,inst_69848,null));
var _ = (function (){var statearr_69877 = state_69854;
(statearr_69877[(4)] = cljs.core.rest((state_69854[(4)])));

return statearr_69877;
})();
var state_69854__$1 = state_69854;
var statearr_69878_69945 = state_69854__$1;
(statearr_69878_69945[(2)] = inst_69849);

(statearr_69878_69945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (29))){
var inst_69740 = (state_69854[(18)]);
var inst_69795 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69740], 0));
var inst_69796 = ["Invalid block range provided: ",inst_69795].join('');
var inst_69797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69798 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69799 = cljs.core.PersistentHashMap.fromArrays(inst_69797,inst_69798);
var inst_69800 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69796,inst_69799);
var inst_69801 = (function(){throw inst_69800})();
var state_69854__$1 = state_69854;
var statearr_69879_69946 = state_69854__$1;
(statearr_69879_69946[(2)] = inst_69801);

(statearr_69879_69946[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (6))){
var inst_69732 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_69854__$1 = state_69854;
var statearr_69880_69947 = state_69854__$1;
(statearr_69880_69947[(2)] = inst_69732);

(statearr_69880_69947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (28))){
var inst_69806 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
var statearr_69881_69948 = state_69854__$1;
(statearr_69881_69948[(2)] = inst_69806);

(statearr_69881_69948[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (25))){
var inst_69809 = (state_69854[(10)]);
var inst_69811 = (state_69854[(16)]);
var inst_69808 = (state_69854[(2)]);
var inst_69809__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69808,(0),null);
var inst_69810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69808,(1),null);
var inst_69811__$1 = cljs.core.pos_int_QMARK_(inst_69809__$1);
var state_69854__$1 = (function (){var statearr_69882 = state_69854;
(statearr_69882[(9)] = inst_69810);

(statearr_69882[(10)] = inst_69809__$1);

(statearr_69882[(16)] = inst_69811__$1);

return statearr_69882;
})();
if(inst_69811__$1){
var statearr_69883_69949 = state_69854__$1;
(statearr_69883_69949[(1)] = (32));

} else {
var statearr_69884_69950 = state_69854__$1;
(statearr_69884_69950[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (34))){
var inst_69816 = (state_69854[(2)]);
var inst_69817 = cljs.core.not(inst_69816);
var state_69854__$1 = state_69854;
if(inst_69817){
var statearr_69885_69951 = state_69854__$1;
(statearr_69885_69951[(1)] = (35));

} else {
var statearr_69886_69952 = state_69854__$1;
(statearr_69886_69952[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (17))){
var inst_69765 = (state_69854[(14)]);
var inst_69763 = (state_69854[(8)]);
var inst_69768 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69763], 0));
var inst_69769 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69765], 0));
var inst_69770 = ["Start block is out of range for this ledger. Start block provided: ",inst_69768,". Database block: ",inst_69769].join('');
var inst_69771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69772 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69773 = cljs.core.PersistentHashMap.fromArrays(inst_69771,inst_69772);
var inst_69774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69770,inst_69773);
var inst_69775 = (function(){throw inst_69774})();
var state_69854__$1 = state_69854;
var statearr_69887_69953 = state_69854__$1;
(statearr_69887_69953[(2)] = inst_69775);

(statearr_69887_69953[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (3))){
var inst_69852 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69854__$1,inst_69852);
} else {
if((state_val_69855 === (12))){
var inst_69740 = (state_69854[(18)]);
var inst_69749 = (state_69854[(17)]);
var inst_69747 = (state_69854[(2)]);
var inst_69748 = fluree.db.util.async.throw_err(inst_69747);
var inst_69749__$1 = cljs.core.second(inst_69740);
var state_69854__$1 = (function (){var statearr_69888 = state_69854;
(statearr_69888[(11)] = inst_69748);

(statearr_69888[(17)] = inst_69749__$1);

return statearr_69888;
})();
if(cljs.core.truth_(inst_69749__$1)){
var statearr_69889_69954 = state_69854__$1;
(statearr_69889_69954[(1)] = (13));

} else {
var statearr_69890_69955 = state_69854__$1;
(statearr_69890_69955[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (2))){
var _ = (function (){var statearr_69891 = state_69854;
(statearr_69891[(4)] = cljs.core.cons((5),(state_69854[(4)])));

return statearr_69891;
})();
var inst_69729 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69730 = cljs.core.sequential_QMARK_(inst_69729);
var state_69854__$1 = state_69854;
if(inst_69730){
var statearr_69892_69956 = state_69854__$1;
(statearr_69892_69956[(1)] = (6));

} else {
var statearr_69893_69957 = state_69854__$1;
(statearr_69893_69957[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (23))){
var inst_69763 = (state_69854[(8)]);
var inst_69764 = (state_69854[(7)]);
var inst_69784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69785 = [inst_69763,inst_69764];
var inst_69786 = (new cljs.core.PersistentVector(null,2,(5),inst_69784,inst_69785,null));
var state_69854__$1 = state_69854;
var statearr_69894_69958 = state_69854__$1;
(statearr_69894_69958[(2)] = inst_69786);

(statearr_69894_69958[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (35))){
var inst_69740 = (state_69854[(18)]);
var inst_69819 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69740], 0));
var inst_69820 = ["Invalid block range provided: ",inst_69819].join('');
var inst_69821 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69822 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69823 = cljs.core.PersistentHashMap.fromArrays(inst_69821,inst_69822);
var inst_69824 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69820,inst_69823);
var inst_69825 = (function(){throw inst_69824})();
var state_69854__$1 = state_69854;
var statearr_69895_69959 = state_69854__$1;
(statearr_69895_69959[(2)] = inst_69825);

(statearr_69895_69959[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (19))){
var inst_69763 = (state_69854[(8)]);
var inst_69778 = (state_69854[(2)]);
var state_69854__$1 = (function (){var statearr_69896 = state_69854;
(statearr_69896[(19)] = inst_69778);

return statearr_69896;
})();
if(cljs.core.truth_(inst_69763)){
var statearr_69897_69960 = state_69854__$1;
(statearr_69897_69960[(1)] = (20));

} else {
var statearr_69898_69961 = state_69854__$1;
(statearr_69898_69961[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (11))){
var inst_69765 = (state_69854[(14)]);
var inst_69763 = (state_69854[(8)]);
var inst_69762 = (state_69854[(2)]);
var inst_69763__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69762,(0),null);
var inst_69764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69762,(1),null);
var inst_69765__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69766 = (inst_69763__$1 > inst_69765__$1);
var state_69854__$1 = (function (){var statearr_69900 = state_69854;
(statearr_69900[(14)] = inst_69765__$1);

(statearr_69900[(8)] = inst_69763__$1);

(statearr_69900[(7)] = inst_69764);

return statearr_69900;
})();
if(cljs.core.truth_(inst_69766)){
var statearr_69901_69962 = state_69854__$1;
(statearr_69901_69962[(1)] = (17));

} else {
var statearr_69902_69963 = state_69854__$1;
(statearr_69902_69963[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (9))){
var inst_69740 = (state_69854[(18)]);
var inst_69743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69744 = cljs.core.first(inst_69740);
var inst_69745 = fluree.db.time_travel.block_to_int_format(db,inst_69744);
var state_69854__$1 = (function (){var statearr_69903 = state_69854;
(statearr_69903[(12)] = inst_69743);

return statearr_69903;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69854__$1,(12),inst_69745);
} else {
if((state_val_69855 === (5))){
var _ = (function (){var statearr_69904 = state_69854;
(statearr_69904[(4)] = cljs.core.rest((state_69854[(4)])));

return statearr_69904;
})();
var state_69854__$1 = state_69854;
var ex69899 = (state_69854__$1[(2)]);
var statearr_69905_69964 = state_69854__$1;
(statearr_69905_69964[(5)] = ex69899);


if((ex69899 instanceof Error)){
var statearr_69906_69965 = state_69854__$1;
(statearr_69906_69965[(1)] = (4));

(statearr_69906_69965[(5)] = null);

} else {
throw ex69899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (14))){
var state_69854__$1 = state_69854;
var statearr_69907_69966 = state_69854__$1;
(statearr_69907_69966[(2)] = null);

(statearr_69907_69966[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (26))){
var inst_69763 = (state_69854[(8)]);
var inst_69789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69790 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69791 = [inst_69763,inst_69790];
var inst_69792 = (new cljs.core.PersistentVector(null,2,(5),inst_69789,inst_69791,null));
var state_69854__$1 = state_69854;
var statearr_69908_69967 = state_69854__$1;
(statearr_69908_69967[(2)] = inst_69792);

(statearr_69908_69967[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (16))){
var inst_69753 = (state_69854[(2)]);
var inst_69754 = fluree.db.util.async.throw_err(inst_69753);
var state_69854__$1 = state_69854;
var statearr_69909_69968 = state_69854__$1;
(statearr_69909_69968[(2)] = inst_69754);

(statearr_69909_69968[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (38))){
var inst_69810 = (state_69854[(9)]);
var inst_69809 = (state_69854[(10)]);
var inst_69831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69832 = [inst_69810,inst_69809];
var inst_69833 = (new cljs.core.PersistentVector(null,2,(5),inst_69831,inst_69832,null));
var state_69854__$1 = state_69854;
var statearr_69910_69969 = state_69854__$1;
(statearr_69910_69969[(2)] = inst_69833);

(statearr_69910_69969[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (30))){
var state_69854__$1 = state_69854;
var statearr_69911_69970 = state_69854__$1;
(statearr_69911_69970[(2)] = null);

(statearr_69911_69970[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (10))){
var inst_69740 = (state_69854[(18)]);
var state_69854__$1 = state_69854;
var statearr_69912_69971 = state_69854__$1;
(statearr_69912_69971[(2)] = inst_69740);

(statearr_69912_69971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (18))){
var state_69854__$1 = state_69854;
var statearr_69913_69972 = state_69854__$1;
(statearr_69913_69972[(2)] = null);

(statearr_69913_69972[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (42))){
var inst_69841 = (state_69854[(13)]);
var state_69854__$1 = state_69854;
var statearr_69914_69973 = state_69854__$1;
(statearr_69914_69973[(2)] = inst_69841);

(statearr_69914_69973[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (37))){
var inst_69810 = (state_69854[(9)]);
var inst_69809 = (state_69854[(10)]);
var inst_69828 = (state_69854[(2)]);
var inst_69829 = (inst_69810 < inst_69809);
var state_69854__$1 = (function (){var statearr_69915 = state_69854;
(statearr_69915[(20)] = inst_69828);

return statearr_69915;
})();
if(cljs.core.truth_(inst_69829)){
var statearr_69916_69974 = state_69854__$1;
(statearr_69916_69974[(1)] = (38));

} else {
var statearr_69917_69975 = state_69854__$1;
(statearr_69917_69975[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (8))){
var inst_69740 = (state_69854[(18)]);
var inst_69740__$1 = (state_69854[(2)]);
var inst_69741 = cljs.core.some(cljs.core.string_QMARK_,inst_69740__$1);
var state_69854__$1 = (function (){var statearr_69918 = state_69854;
(statearr_69918[(18)] = inst_69740__$1);

return statearr_69918;
})();
if(cljs.core.truth_(inst_69741)){
var statearr_69919_69976 = state_69854__$1;
(statearr_69919_69976[(1)] = (9));

} else {
var statearr_69920_69977 = state_69854__$1;
(statearr_69920_69977[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_69921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69921[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_69921[(1)] = (1));

return statearr_69921;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_69854){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69854);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69922){var ex__2730__auto__ = e69922;
var statearr_69923_69978 = state_69854;
(statearr_69923_69978[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69854[(4)]))){
var statearr_69924_69979 = state_69854;
(statearr_69924_69979[(1)] = cljs.core.first((state_69854[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69980 = state_69854;
state_69854 = G__69980;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_69854){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_69854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69925 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69925[(6)] = c__2749__auto__);

return statearr_69925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70130){
var state_val_70131 = (state_70130[(1)]);
if((state_val_70131 === (7))){
var inst_70042 = (state_70130[(2)]);
var inst_70043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70042,(0),null);
var inst_70044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70042,(1),null);
var inst_70052 = cljs.core.vals(inst_70044);
var inst_70053 = cljs.core.seq(inst_70052);
var inst_70054 = cljs.core.first(inst_70053);
var inst_70055 = cljs.core.next(inst_70053);
var inst_70056 = cljs.core.PersistentVector.EMPTY;
var inst_70057 = inst_70052;
var inst_70058 = inst_70056;
var state_70130__$1 = (function (){var statearr_70132 = state_70130;
(statearr_70132[(7)] = inst_70054);

(statearr_70132[(8)] = inst_70043);

(statearr_70132[(9)] = inst_70058);

(statearr_70132[(10)] = inst_70057);

(statearr_70132[(11)] = inst_70055);

return statearr_70132;
})();
var statearr_70133_70186 = state_70130__$1;
(statearr_70133_70186[(2)] = null);

(statearr_70133_70186[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (20))){
var inst_70064 = (state_70130[(12)]);
var inst_70069 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70070 = cljs.core.PersistentHashMap.EMPTY;
var inst_70071 = [true,inst_70070];
var inst_70072 = cljs.core.PersistentHashMap.fromArrays(inst_70069,inst_70071);
var inst_70073 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_70072,inst_70064);
var state_70130__$1 = state_70130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70130__$1,(22),inst_70073);
} else {
if((state_val_70131 === (27))){
var inst_70118 = (state_70130[(2)]);
var state_70130__$1 = state_70130;
var statearr_70134_70187 = state_70130__$1;
(statearr_70134_70187[(2)] = inst_70118);

(statearr_70134_70187[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (1))){
var state_70130__$1 = state_70130;
var statearr_70135_70188 = state_70130__$1;
(statearr_70135_70188[(2)] = null);

(statearr_70135_70188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (24))){
var inst_70082 = (state_70130[(13)]);
var inst_70120 = (state_70130[(2)]);
var inst_70121 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_70122 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70123 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70124 = [inst_70122,inst_70123,inst_70082,inst_70120];
var inst_70125 = cljs.core.PersistentHashMap.fromArrays(inst_70121,inst_70124);
var _ = (function (){var statearr_70137 = state_70130;
(statearr_70137[(4)] = cljs.core.rest((state_70130[(4)])));

return statearr_70137;
})();
var state_70130__$1 = state_70130;
var statearr_70138_70189 = state_70130__$1;
(statearr_70138_70189[(2)] = inst_70125);

(statearr_70138_70189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (4))){
var inst_69983 = (state_70130[(2)]);
var state_70130__$1 = state_70130;
var statearr_70139_70190 = state_70130__$1;
(statearr_70139_70190[(2)] = inst_69983);

(statearr_70139_70190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (15))){
var inst_70013 = (state_70130[(14)]);
var inst_70007 = (state_70130[(15)]);
var inst_70001 = (state_70130[(16)]);
var inst_70006 = (state_70130[(17)]);
var inst_69999 = (state_70130[(18)]);
var inst_70005 = (state_70130[(19)]);
var inst_70002 = (state_70130[(20)]);
var inst_70028 = (state_70130[(21)]);
var inst_70023 = (state_70130[(22)]);
var inst_70021 = (state_70130[(23)]);
var inst_70014 = (state_70130[(24)]);
var inst_70034 = (function (){var subject = inst_70021;
var flake = inst_70013;
var vec__70009 = inst_70005;
var seq__69997 = inst_70002;
var r = inst_70014;
var first__69998 = inst_70001;
var asserted_subjects = inst_70006;
var flake_SINGLEQUOTE_ = inst_70028;
var first__70011 = inst_70013;
var retracted_subjects = inst_70007;
var G__69995 = inst_70005;
var asserted_QMARK_ = inst_70023;
var vec__69996 = inst_69999;
var seq__70010 = inst_70014;
return (function (p1__69982_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__69982_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_70035 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_70007,inst_70021,inst_70034);
var tmp70136 = inst_70006;
var inst_70005__$1 = inst_70014;
var inst_70006__$1 = tmp70136;
var inst_70007__$1 = inst_70035;
var state_70130__$1 = (function (){var statearr_70140 = state_70130;
(statearr_70140[(15)] = inst_70007__$1);

(statearr_70140[(17)] = inst_70006__$1);

(statearr_70140[(19)] = inst_70005__$1);

return statearr_70140;
})();
var statearr_70141_70191 = state_70130__$1;
(statearr_70141_70191[(2)] = null);

(statearr_70141_70191[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (21))){
var inst_70080 = (state_70130[(2)]);
var state_70130__$1 = state_70130;
var statearr_70142_70192 = state_70130__$1;
(statearr_70142_70192[(2)] = inst_70080);

(statearr_70142_70192[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (13))){
var inst_70023 = (state_70130[(22)]);
var inst_70028 = (state_70130[(2)]);
var state_70130__$1 = (function (){var statearr_70143 = state_70130;
(statearr_70143[(21)] = inst_70028);

return statearr_70143;
})();
if(cljs.core.truth_(inst_70023)){
var statearr_70144_70193 = state_70130__$1;
(statearr_70144_70193[(1)] = (14));

} else {
var statearr_70145_70194 = state_70130__$1;
(statearr_70145_70194[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (22))){
var inst_70058 = (state_70130[(9)]);
var inst_70065 = (state_70130[(25)]);
var inst_70075 = (state_70130[(2)]);
var inst_70076 = fluree.db.util.async.throw_err(inst_70075);
var inst_70077 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70058,inst_70076);
var inst_70057 = inst_70065;
var inst_70058__$1 = inst_70077;
var state_70130__$1 = (function (){var statearr_70146 = state_70130;
(statearr_70146[(9)] = inst_70058__$1);

(statearr_70146[(10)] = inst_70057);

return statearr_70146;
})();
var statearr_70147_70195 = state_70130__$1;
(statearr_70147_70195[(2)] = null);

(statearr_70147_70195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (6))){
var inst_70013 = (state_70130[(14)]);
var inst_70005 = (state_70130[(19)]);
var inst_70012 = cljs.core.seq(inst_70005);
var inst_70013__$1 = cljs.core.first(inst_70012);
var inst_70014 = cljs.core.next(inst_70012);
var inst_70015 = cljs.core.not(inst_70013__$1);
var state_70130__$1 = (function (){var statearr_70148 = state_70130;
(statearr_70148[(14)] = inst_70013__$1);

(statearr_70148[(24)] = inst_70014);

return statearr_70148;
})();
if(inst_70015){
var statearr_70149_70196 = state_70130__$1;
(statearr_70149_70196[(1)] = (8));

} else {
var statearr_70150_70197 = state_70130__$1;
(statearr_70150_70197[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (28))){
var inst_70096 = (state_70130[(26)]);
var inst_70103 = (state_70130[(27)]);
var inst_70113 = (state_70130[(2)]);
var inst_70114 = fluree.db.util.async.throw_err(inst_70113);
var inst_70115 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70096,inst_70114);
var inst_70095 = inst_70103;
var inst_70096__$1 = inst_70115;
var state_70130__$1 = (function (){var statearr_70151 = state_70130;
(statearr_70151[(28)] = inst_70095);

(statearr_70151[(26)] = inst_70096__$1);

return statearr_70151;
})();
var statearr_70152_70198 = state_70130__$1;
(statearr_70152_70198[(2)] = null);

(statearr_70152_70198[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (25))){
var inst_70096 = (state_70130[(26)]);
var state_70130__$1 = state_70130;
var statearr_70153_70199 = state_70130__$1;
(statearr_70153_70199[(2)] = inst_70096);

(statearr_70153_70199[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (17))){
var inst_70057 = (state_70130[(10)]);
var inst_70064 = (state_70130[(12)]);
var inst_70063 = cljs.core.seq(inst_70057);
var inst_70064__$1 = cljs.core.first(inst_70063);
var inst_70065 = cljs.core.next(inst_70063);
var inst_70066 = cljs.core.not(inst_70064__$1);
var state_70130__$1 = (function (){var statearr_70154 = state_70130;
(statearr_70154[(12)] = inst_70064__$1);

(statearr_70154[(25)] = inst_70065);

return statearr_70154;
})();
if(inst_70066){
var statearr_70155_70200 = state_70130__$1;
(statearr_70155_70200[(1)] = (19));

} else {
var statearr_70156_70201 = state_70130__$1;
(statearr_70156_70201[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (3))){
var inst_70128 = (state_70130[(2)]);
var state_70130__$1 = state_70130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70130__$1,inst_70128);
} else {
if((state_val_70131 === (12))){
var inst_70013 = (state_70130[(14)]);
var inst_70026 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_70013);
var state_70130__$1 = state_70130;
var statearr_70157_70202 = state_70130__$1;
(statearr_70157_70202[(2)] = inst_70026);

(statearr_70157_70202[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (2))){
var inst_69999 = (state_70130[(18)]);
var _ = (function (){var statearr_70158 = state_70130;
(statearr_70158[(4)] = cljs.core.cons((5),(state_70130[(4)])));

return statearr_70158;
})();
var inst_69999__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70000 = cljs.core.seq(inst_69999__$1);
var inst_70001 = cljs.core.first(inst_70000);
var inst_70002 = cljs.core.next(inst_70000);
var inst_70003 = cljs.core.PersistentHashMap.EMPTY;
var inst_70004 = cljs.core.PersistentHashMap.EMPTY;
var inst_70005 = inst_69999__$1;
var inst_70006 = inst_70003;
var inst_70007 = inst_70004;
var state_70130__$1 = (function (){var statearr_70159 = state_70130;
(statearr_70159[(15)] = inst_70007);

(statearr_70159[(16)] = inst_70001);

(statearr_70159[(17)] = inst_70006);

(statearr_70159[(18)] = inst_69999__$1);

(statearr_70159[(19)] = inst_70005);

(statearr_70159[(20)] = inst_70002);

return statearr_70159;
})();
var statearr_70160_70203 = state_70130__$1;
(statearr_70160_70203[(2)] = null);

(statearr_70160_70203[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (23))){
var inst_70102 = (state_70130[(29)]);
var inst_70095 = (state_70130[(28)]);
var inst_70101 = cljs.core.seq(inst_70095);
var inst_70102__$1 = cljs.core.first(inst_70101);
var inst_70103 = cljs.core.next(inst_70101);
var inst_70104 = cljs.core.not(inst_70102__$1);
var state_70130__$1 = (function (){var statearr_70161 = state_70130;
(statearr_70161[(29)] = inst_70102__$1);

(statearr_70161[(27)] = inst_70103);

return statearr_70161;
})();
if(inst_70104){
var statearr_70162_70204 = state_70130__$1;
(statearr_70162_70204[(1)] = (25));

} else {
var statearr_70163_70205 = state_70130__$1;
(statearr_70163_70205[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (19))){
var inst_70058 = (state_70130[(9)]);
var state_70130__$1 = state_70130;
var statearr_70164_70206 = state_70130__$1;
(statearr_70164_70206[(2)] = inst_70058);

(statearr_70164_70206[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (11))){
var inst_70013 = (state_70130[(14)]);
var state_70130__$1 = state_70130;
var statearr_70166_70207 = state_70130__$1;
(statearr_70166_70207[(2)] = inst_70013);

(statearr_70166_70207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (9))){
var inst_70013 = (state_70130[(14)]);
var inst_70023 = (state_70130[(22)]);
var inst_70021 = fluree.db.flake.s(inst_70013);
var inst_70022 = fluree.db.flake.op(inst_70013);
var inst_70023__$1 = inst_70022 === true;
var state_70130__$1 = (function (){var statearr_70168 = state_70130;
(statearr_70168[(22)] = inst_70023__$1);

(statearr_70168[(23)] = inst_70021);

return statearr_70168;
})();
if(cljs.core.truth_(inst_70023__$1)){
var statearr_70169_70208 = state_70130__$1;
(statearr_70169_70208[(1)] = (11));

} else {
var statearr_70170_70209 = state_70130__$1;
(statearr_70170_70209[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (5))){
var _ = (function (){var statearr_70171 = state_70130;
(statearr_70171[(4)] = cljs.core.rest((state_70130[(4)])));

return statearr_70171;
})();
var state_70130__$1 = state_70130;
var ex70165 = (state_70130__$1[(2)]);
var statearr_70172_70210 = state_70130__$1;
(statearr_70172_70210[(5)] = ex70165);


if((ex70165 instanceof Error)){
var statearr_70173_70211 = state_70130__$1;
(statearr_70173_70211[(1)] = (4));

(statearr_70173_70211[(5)] = null);

} else {
throw ex70165;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (14))){
var inst_70013 = (state_70130[(14)]);
var inst_70007 = (state_70130[(15)]);
var inst_70001 = (state_70130[(16)]);
var inst_70006 = (state_70130[(17)]);
var inst_69999 = (state_70130[(18)]);
var inst_70005 = (state_70130[(19)]);
var inst_70002 = (state_70130[(20)]);
var inst_70028 = (state_70130[(21)]);
var inst_70023 = (state_70130[(22)]);
var inst_70021 = (state_70130[(23)]);
var inst_70014 = (state_70130[(24)]);
var inst_70030 = (function (){var subject = inst_70021;
var flake = inst_70013;
var vec__70009 = inst_70005;
var seq__69997 = inst_70002;
var r = inst_70014;
var first__69998 = inst_70001;
var asserted_subjects = inst_70006;
var flake_SINGLEQUOTE_ = inst_70028;
var first__70011 = inst_70013;
var retracted_subjects = inst_70007;
var G__69995 = inst_70005;
var asserted_QMARK_ = inst_70023;
var vec__69996 = inst_69999;
var seq__70010 = inst_70014;
return (function (p1__69981_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__69981_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_70031 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_70006,inst_70021,inst_70030);
var tmp70167 = inst_70007;
var inst_70005__$1 = inst_70014;
var inst_70006__$1 = inst_70031;
var inst_70007__$1 = tmp70167;
var state_70130__$1 = (function (){var statearr_70174 = state_70130;
(statearr_70174[(15)] = inst_70007__$1);

(statearr_70174[(17)] = inst_70006__$1);

(statearr_70174[(19)] = inst_70005__$1);

return statearr_70174;
})();
var statearr_70175_70212 = state_70130__$1;
(statearr_70175_70212[(2)] = null);

(statearr_70175_70212[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (26))){
var inst_70102 = (state_70130[(29)]);
var inst_70107 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70108 = cljs.core.PersistentHashMap.EMPTY;
var inst_70109 = [true,inst_70108];
var inst_70110 = cljs.core.PersistentHashMap.fromArrays(inst_70107,inst_70109);
var inst_70111 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_70110,inst_70102);
var state_70130__$1 = state_70130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70130__$1,(28),inst_70111);
} else {
if((state_val_70131 === (16))){
var inst_70038 = (state_70130[(2)]);
var state_70130__$1 = state_70130;
var statearr_70176_70213 = state_70130__$1;
(statearr_70176_70213[(2)] = inst_70038);

(statearr_70176_70213[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (10))){
var inst_70040 = (state_70130[(2)]);
var state_70130__$1 = state_70130;
var statearr_70177_70214 = state_70130__$1;
(statearr_70177_70214[(2)] = inst_70040);

(statearr_70177_70214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (18))){
var inst_70043 = (state_70130[(8)]);
var inst_70082 = (state_70130[(2)]);
var inst_70090 = cljs.core.vals(inst_70043);
var inst_70091 = cljs.core.seq(inst_70090);
var inst_70092 = cljs.core.first(inst_70091);
var inst_70093 = cljs.core.next(inst_70091);
var inst_70094 = cljs.core.PersistentVector.EMPTY;
var inst_70095 = inst_70090;
var inst_70096 = inst_70094;
var state_70130__$1 = (function (){var statearr_70178 = state_70130;
(statearr_70178[(30)] = inst_70092);

(statearr_70178[(13)] = inst_70082);

(statearr_70178[(28)] = inst_70095);

(statearr_70178[(26)] = inst_70096);

(statearr_70178[(31)] = inst_70093);

return statearr_70178;
})();
var statearr_70179_70215 = state_70130__$1;
(statearr_70179_70215[(2)] = null);

(statearr_70179_70215[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70131 === (8))){
var inst_70007 = (state_70130[(15)]);
var inst_70006 = (state_70130[(17)]);
var inst_70017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70018 = [inst_70006,inst_70007];
var inst_70019 = (new cljs.core.PersistentVector(null,2,(5),inst_70017,inst_70018,null));
var state_70130__$1 = state_70130;
var statearr_70180_70216 = state_70130__$1;
(statearr_70180_70216[(2)] = inst_70019);

(statearr_70180_70216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_70181 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70181[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_70181[(1)] = (1));

return statearr_70181;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_70130){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70130);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70182){var ex__2730__auto__ = e70182;
var statearr_70183_70217 = state_70130;
(statearr_70183_70217[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70130[(4)]))){
var statearr_70184_70218 = state_70130;
(statearr_70184_70218[(1)] = cljs.core.first((state_70130[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70219 = state_70130;
state_70130 = G__70219;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_70130){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_70130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70185 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70185[(6)] = c__2749__auto__);

return statearr_70185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70251){
var state_val_70252 = (state_70251[(1)]);
if((state_val_70252 === (1))){
var inst_70220 = cljs.core.volatile_BANG_((0));
var inst_70221 = cljs.core.PersistentHashMap.EMPTY;
var inst_70222 = cljs.core.volatile_BANG_(inst_70221);
var inst_70223 = cljs.core.first(resp);
var inst_70224 = cljs.core.rest(resp);
var inst_70225 = cljs.core.PersistentVector.EMPTY;
var inst_70226 = inst_70220;
var inst_70227 = inst_70222;
var inst_70228 = inst_70223;
var inst_70229 = inst_70224;
var inst_70230 = inst_70225;
var state_70251__$1 = (function (){var statearr_70253 = state_70251;
(statearr_70253[(7)] = inst_70228);

(statearr_70253[(8)] = inst_70226);

(statearr_70253[(9)] = inst_70227);

(statearr_70253[(10)] = inst_70230);

(statearr_70253[(11)] = inst_70229);

return statearr_70253;
})();
var statearr_70254_70269 = state_70251__$1;
(statearr_70254_70269[(2)] = null);

(statearr_70254_70269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70252 === (2))){
var inst_70228 = (state_70251[(7)]);
var inst_70226 = (state_70251[(8)]);
var inst_70227 = (state_70251[(9)]);
var inst_70232 = fluree.db.api.query.format_block_resp_pretty(db,inst_70228,inst_70227,inst_70226);
var state_70251__$1 = state_70251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70251__$1,(4),inst_70232);
} else {
if((state_val_70252 === (3))){
var inst_70249 = (state_70251[(2)]);
var state_70251__$1 = state_70251;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70251__$1,inst_70249);
} else {
if((state_val_70252 === (4))){
var inst_70230 = (state_70251[(10)]);
var inst_70229 = (state_70251[(11)]);
var inst_70234 = (state_70251[(2)]);
var inst_70235 = fluree.db.util.async.throw_err(inst_70234);
var inst_70236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70237 = [inst_70235];
var inst_70238 = (new cljs.core.PersistentVector(null,1,(5),inst_70236,inst_70237,null));
var inst_70239 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_70230,inst_70238);
var inst_70240 = cljs.core.first(inst_70229);
var state_70251__$1 = (function (){var statearr_70257 = state_70251;
(statearr_70257[(12)] = inst_70239);

return statearr_70257;
})();
if(cljs.core.truth_(inst_70240)){
var statearr_70258_70270 = state_70251__$1;
(statearr_70258_70270[(1)] = (5));

} else {
var statearr_70259_70271 = state_70251__$1;
(statearr_70259_70271[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70252 === (5))){
var inst_70226 = (state_70251[(8)]);
var inst_70227 = (state_70251[(9)]);
var inst_70239 = (state_70251[(12)]);
var inst_70229 = (state_70251[(11)]);
var inst_70242 = cljs.core.first(inst_70229);
var inst_70243 = cljs.core.rest(inst_70229);
var tmp70255 = inst_70226;
var tmp70256 = inst_70227;
var inst_70226__$1 = tmp70255;
var inst_70227__$1 = tmp70256;
var inst_70228 = inst_70242;
var inst_70229__$1 = inst_70243;
var inst_70230 = inst_70239;
var state_70251__$1 = (function (){var statearr_70260 = state_70251;
(statearr_70260[(7)] = inst_70228);

(statearr_70260[(8)] = inst_70226__$1);

(statearr_70260[(9)] = inst_70227__$1);

(statearr_70260[(10)] = inst_70230);

(statearr_70260[(11)] = inst_70229__$1);

return statearr_70260;
})();
var statearr_70261_70272 = state_70251__$1;
(statearr_70261_70272[(2)] = null);

(statearr_70261_70272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70252 === (6))){
var inst_70239 = (state_70251[(12)]);
var state_70251__$1 = state_70251;
var statearr_70262_70273 = state_70251__$1;
(statearr_70262_70273[(2)] = inst_70239);

(statearr_70262_70273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70252 === (7))){
var inst_70247 = (state_70251[(2)]);
var state_70251__$1 = state_70251;
var statearr_70263_70274 = state_70251__$1;
(statearr_70263_70274[(2)] = inst_70247);

(statearr_70263_70274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_70264 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70264[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_70264[(1)] = (1));

return statearr_70264;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_70251){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70251);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70265){var ex__2730__auto__ = e70265;
var statearr_70266_70275 = state_70251;
(statearr_70266_70275[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70251[(4)]))){
var statearr_70267_70276 = state_70251;
(statearr_70267_70276[(1)] = cljs.core.first((state_70251[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70277 = state_70251;
state_70251 = G__70277;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_70251){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_70251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70268 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70268[(6)] = c__2749__auto__);

return statearr_70268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__70279 = arguments.length;
switch (G__70279) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__70281){
var map__70282 = p__70281;
var map__70282__$1 = cljs.core.__destructure_map(map__70282);
var query = map__70282__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70282__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70367){
var state_val_70368 = (state_70367[(1)]);
if((state_val_70368 === (7))){
var inst_70293 = (state_70367[(7)]);
var inst_70297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70298 = ["_auth/id",inst_70293];
var inst_70299 = (new cljs.core.PersistentVector(null,2,(5),inst_70297,inst_70298,null));
var state_70367__$1 = state_70367;
var statearr_70369_70413 = state_70367__$1;
(statearr_70369_70413[(2)] = inst_70299);

(statearr_70369_70413[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (20))){
var inst_70347 = (state_70367[(2)]);
var inst_70348 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_70367__$1 = (function (){var statearr_70370 = state_70367;
(statearr_70370[(8)] = inst_70347);

return statearr_70370;
})();
if(cljs.core.truth_(inst_70348)){
var statearr_70371_70414 = state_70367__$1;
(statearr_70371_70414[(1)] = (22));

} else {
var statearr_70372_70415 = state_70367__$1;
(statearr_70372_70415[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (27))){
var inst_70294 = (state_70367[(9)]);
var inst_70350 = (state_70367[(10)]);
var inst_70356 = (state_70367[(2)]);
var inst_70357 = fluree.db.util.core.response_time_formatted(inst_70294);
var inst_70358 = [(200),inst_70356,(100),inst_70357];
var inst_70359 = cljs.core.PersistentHashMap.fromArrays(inst_70350,inst_70358);
var state_70367__$1 = state_70367;
var statearr_70373_70416 = state_70367__$1;
(statearr_70373_70416[(2)] = inst_70359);

(statearr_70373_70416[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (1))){
var state_70367__$1 = state_70367;
var statearr_70374_70417 = state_70367__$1;
(statearr_70374_70417[(2)] = null);

(statearr_70374_70417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (24))){
var inst_70362 = (state_70367[(2)]);
var _ = (function (){var statearr_70375 = state_70367;
(statearr_70375[(4)] = cljs.core.rest((state_70367[(4)])));

return statearr_70375;
})();
var state_70367__$1 = state_70367;
var statearr_70376_70418 = state_70367__$1;
(statearr_70376_70418[(2)] = inst_70362);

(statearr_70376_70418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (4))){
var inst_70283 = (state_70367[(2)]);
var state_70367__$1 = state_70367;
var statearr_70377_70419 = state_70367__$1;
(statearr_70377_70419[(2)] = inst_70283);

(statearr_70377_70419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (15))){
var inst_70334 = (state_70367[(11)]);
var state_70367__$1 = state_70367;
var statearr_70378_70420 = state_70367__$1;
(statearr_70378_70420[(2)] = inst_70334);

(statearr_70378_70420[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (21))){
var inst_70343 = (state_70367[(2)]);
var inst_70344 = fluree.db.util.async.throw_err(inst_70343);
var state_70367__$1 = state_70367;
var statearr_70379_70421 = state_70367__$1;
(statearr_70379_70421[(2)] = inst_70344);

(statearr_70379_70421[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (13))){
var inst_70292 = (state_70367[(12)]);
var inst_70334 = (state_70367[(11)]);
var inst_70333 = (state_70367[(2)]);
var inst_70334__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_70292);
var state_70367__$1 = (function (){var statearr_70380 = state_70367;
(statearr_70380[(13)] = inst_70333);

(statearr_70380[(11)] = inst_70334__$1);

return statearr_70380;
})();
if(cljs.core.truth_(inst_70334__$1)){
var statearr_70381_70422 = state_70367__$1;
(statearr_70381_70422[(1)] = (15));

} else {
var statearr_70382_70423 = state_70367__$1;
(statearr_70382_70423[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (22))){
var inst_70347 = (state_70367[(8)]);
var inst_70350 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70351 = cljs.core.sequential_QMARK_(inst_70347);
var state_70367__$1 = (function (){var statearr_70383 = state_70367;
(statearr_70383[(10)] = inst_70350);

return statearr_70383;
})();
if(inst_70351){
var statearr_70384_70424 = state_70367__$1;
(statearr_70384_70424[(1)] = (25));

} else {
var statearr_70385_70425 = state_70367__$1;
(statearr_70385_70425[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (6))){
var inst_70292 = (state_70367[(12)]);
var inst_70308 = (state_70367[(14)]);
var inst_70307 = (state_70367[(2)]);
var inst_70308__$1 = fluree.db.util.async.throw_err(inst_70307);
var inst_70309 = fluree.db.api.query.resolve_block_range(inst_70308__$1,inst_70292);
var state_70367__$1 = (function (){var statearr_70386 = state_70367;
(statearr_70386[(14)] = inst_70308__$1);

return statearr_70386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70367__$1,(10),inst_70309);
} else {
if((state_val_70368 === (25))){
var inst_70347 = (state_70367[(8)]);
var inst_70353 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_70347);
var state_70367__$1 = state_70367;
var statearr_70387_70426 = state_70367__$1;
(statearr_70387_70426[(2)] = inst_70353);

(statearr_70387_70426[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (17))){
var inst_70339 = (state_70367[(2)]);
var state_70367__$1 = state_70367;
if(cljs.core.truth_(inst_70339)){
var statearr_70388_70427 = state_70367__$1;
(statearr_70388_70427[(1)] = (18));

} else {
var statearr_70389_70428 = state_70367__$1;
(statearr_70389_70428[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (3))){
var inst_70365 = (state_70367[(2)]);
var state_70367__$1 = state_70367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70367__$1,inst_70365);
} else {
if((state_val_70368 === (12))){
var inst_70292 = (state_70367[(12)]);
var inst_70325 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70292], 0));
var inst_70326 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_70325].join('');
var inst_70327 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70328 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70329 = cljs.core.PersistentHashMap.fromArrays(inst_70327,inst_70328);
var inst_70330 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70326,inst_70329);
var inst_70331 = (function(){throw inst_70330})();
var state_70367__$1 = state_70367;
var statearr_70390_70429 = state_70367__$1;
(statearr_70390_70429[(2)] = inst_70331);

(statearr_70390_70429[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (2))){
var inst_70293 = (state_70367[(7)]);
var _ = (function (){var statearr_70391 = state_70367;
(statearr_70391[(4)] = cljs.core.cons((5),(state_70367[(4)])));

return statearr_70391;
})();
var inst_70292 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70293__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70294 = fluree.db.util.core.current_time_millis();
var inst_70295 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_70367__$1 = (function (){var statearr_70392 = state_70367;
(statearr_70392[(9)] = inst_70294);

(statearr_70392[(15)] = inst_70295);

(statearr_70392[(12)] = inst_70292);

(statearr_70392[(7)] = inst_70293__$1);

return statearr_70392;
})();
if(cljs.core.truth_(inst_70293__$1)){
var statearr_70393_70430 = state_70367__$1;
(statearr_70393_70430[(1)] = (7));

} else {
var statearr_70394_70431 = state_70367__$1;
(statearr_70394_70431[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (23))){
var inst_70347 = (state_70367[(8)]);
var state_70367__$1 = state_70367;
var statearr_70395_70432 = state_70367__$1;
(statearr_70395_70432[(2)] = inst_70347);

(statearr_70395_70432[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (19))){
var inst_70333 = (state_70367[(13)]);
var state_70367__$1 = state_70367;
var statearr_70396_70433 = state_70367__$1;
(statearr_70396_70433[(2)] = inst_70333);

(statearr_70396_70433[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (11))){
var inst_70314 = (state_70367[(16)]);
var inst_70308 = (state_70367[(14)]);
var inst_70313 = (state_70367[(17)]);
var inst_70320 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_70308,inst_70313,inst_70314,opts);
var state_70367__$1 = state_70367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70367__$1,(14),inst_70320);
} else {
if((state_val_70368 === (9))){
var inst_70295 = (state_70367[(15)]);
var inst_70302 = (state_70367[(2)]);
var inst_70303 = [inst_70302];
var inst_70304 = cljs.core.PersistentHashMap.fromArrays(inst_70295,inst_70303);
var inst_70305 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_70304);
var state_70367__$1 = state_70367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70367__$1,(6),inst_70305);
} else {
if((state_val_70368 === (5))){
var _ = (function (){var statearr_70398 = state_70367;
(statearr_70398[(4)] = cljs.core.rest((state_70367[(4)])));

return statearr_70398;
})();
var state_70367__$1 = state_70367;
var ex70397 = (state_70367__$1[(2)]);
var statearr_70399_70434 = state_70367__$1;
(statearr_70399_70434[(5)] = ex70397);


if((ex70397 instanceof Error)){
var statearr_70400_70435 = state_70367__$1;
(statearr_70400_70435[(1)] = (4));

(statearr_70400_70435[(5)] = null);

} else {
throw ex70397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (14))){
var inst_70322 = (state_70367[(2)]);
var inst_70323 = fluree.db.util.async.throw_err(inst_70322);
var state_70367__$1 = state_70367;
var statearr_70401_70436 = state_70367__$1;
(statearr_70401_70436[(2)] = inst_70323);

(statearr_70401_70436[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (26))){
var inst_70347 = (state_70367[(8)]);
var state_70367__$1 = state_70367;
var statearr_70402_70437 = state_70367__$1;
(statearr_70402_70437[(2)] = inst_70347);

(statearr_70402_70437[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (16))){
var inst_70292 = (state_70367[(12)]);
var inst_70337 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_70292);
var state_70367__$1 = state_70367;
var statearr_70403_70438 = state_70367__$1;
(statearr_70403_70438[(2)] = inst_70337);

(statearr_70403_70438[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (10))){
var inst_70292 = (state_70367[(12)]);
var inst_70311 = (state_70367[(2)]);
var inst_70312 = fluree.db.util.async.throw_err(inst_70311);
var inst_70313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70312,(0),null);
var inst_70314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70312,(1),null);
var inst_70315 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_70316 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_70292,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_70317 = cljs.core.keys(inst_70316);
var inst_70318 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70315,inst_70317);
var state_70367__$1 = (function (){var statearr_70404 = state_70367;
(statearr_70404[(16)] = inst_70314);

(statearr_70404[(17)] = inst_70313);

return statearr_70404;
})();
if(inst_70318){
var statearr_70405_70439 = state_70367__$1;
(statearr_70405_70439[(1)] = (11));

} else {
var statearr_70406_70440 = state_70367__$1;
(statearr_70406_70440[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70368 === (18))){
var inst_70333 = (state_70367[(13)]);
var inst_70308 = (state_70367[(14)]);
var inst_70341 = fluree.db.api.query.format_blocks_resp_pretty(inst_70308,inst_70333);
var state_70367__$1 = state_70367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70367__$1,(21),inst_70341);
} else {
if((state_val_70368 === (8))){
var state_70367__$1 = state_70367;
var statearr_70407_70441 = state_70367__$1;
(statearr_70407_70441[(2)] = null);

(statearr_70407_70441[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70408 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70408[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_70408[(1)] = (1));

return statearr_70408;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_70367){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70367);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70409){var ex__2730__auto__ = e70409;
var statearr_70410_70442 = state_70367;
(statearr_70410_70442[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70367[(4)]))){
var statearr_70411_70443 = state_70367;
(statearr_70411_70443[(1)] = cljs.core.first((state_70367[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70444 = state_70367;
state_70367 = G__70444;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_70367){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_70367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70412 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70412[(6)] = c__2749__auto__);

return statearr_70412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__70445 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70445,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70445,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70445,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70445,(3),null);
var vec__70448 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70448,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70448,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__70451 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70451,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70451,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70455 = arguments.length;
var i__5770__auto___70456 = (0);
while(true){
if((i__5770__auto___70456 < len__5769__auto___70455)){
args__5775__auto__.push((arguments[i__5770__auto___70456]));

var G__70457 = (i__5770__auto___70456 + (1));
i__5770__auto___70456 = G__70457;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq70454){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq70454));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70653){
var state_val_70654 = (state_70653[(1)]);
if((state_val_70654 === (7))){
var inst_70580 = (state_70653[(7)]);
var inst_70573 = (state_70653[(8)]);
var inst_70579 = cljs.core.seq(inst_70573);
var inst_70580__$1 = cljs.core.first(inst_70579);
var inst_70581 = cljs.core.next(inst_70579);
var state_70653__$1 = (function (){var statearr_70655 = state_70653;
(statearr_70655[(7)] = inst_70580__$1);

(statearr_70655[(9)] = inst_70581);

return statearr_70655;
})();
if(cljs.core.truth_(inst_70580__$1)){
var statearr_70656_70756 = state_70653__$1;
(statearr_70656_70756[(1)] = (9));

} else {
var statearr_70657_70757 = state_70653__$1;
(statearr_70657_70757[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (20))){
var inst_70643 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
var statearr_70658_70758 = state_70653__$1;
(statearr_70658_70758[(2)] = inst_70643);

(statearr_70658_70758[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (27))){
var inst_70601 = (state_70653[(10)]);
var inst_70598 = (state_70653[(11)]);
var inst_70619 = (state_70653[(12)]);
var inst_70621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70622 = [inst_70601,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70623 = (new cljs.core.PersistentVector(null,2,(5),inst_70621,inst_70622,null));
var inst_70624 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70619,inst_70623,fluree.db.api.query.min_safe,inst_70598);
var state_70653__$1 = state_70653;
var statearr_70659_70759 = state_70653__$1;
(statearr_70659_70759[(2)] = inst_70624);

(statearr_70659_70759[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (1))){
var state_70653__$1 = state_70653;
var statearr_70660_70760 = state_70653__$1;
(statearr_70660_70760[(2)] = null);

(statearr_70660_70760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (24))){
var inst_70601 = (state_70653[(10)]);
var inst_70580 = (state_70653[(7)]);
var inst_70611 = (state_70653[(13)]);
var inst_70613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70614 = [inst_70601,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70615 = (new cljs.core.PersistentVector(null,2,(5),inst_70613,inst_70614,null));
var inst_70616 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70611,inst_70615,cljs.core.conj,inst_70580);
var state_70653__$1 = state_70653;
var statearr_70662_70761 = state_70653__$1;
(statearr_70662_70761[(2)] = inst_70616);

(statearr_70662_70761[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (4))){
var inst_70459 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
var statearr_70663_70762 = state_70653__$1;
(statearr_70663_70762[(2)] = inst_70459);

(statearr_70663_70762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (15))){
var inst_70574 = (state_70653[(14)]);
var inst_70581 = (state_70653[(9)]);
var tmp70661 = inst_70574;
var inst_70573 = inst_70581;
var inst_70574__$1 = tmp70661;
var state_70653__$1 = (function (){var statearr_70664 = state_70653;
(statearr_70664[(14)] = inst_70574__$1);

(statearr_70664[(8)] = inst_70573);

return statearr_70664;
})();
var statearr_70665_70763 = state_70653__$1;
(statearr_70665_70763[(2)] = null);

(statearr_70665_70763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (21))){
var inst_70601 = (state_70653[(10)]);
var inst_70574 = (state_70653[(14)]);
var inst_70605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70606 = [inst_70601,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70607 = (new cljs.core.PersistentVector(null,2,(5),inst_70605,inst_70606,null));
var inst_70608 = cljs.core.assoc_in(inst_70574,inst_70607,inst_70601);
var state_70653__$1 = state_70653;
var statearr_70666_70764 = state_70653__$1;
(statearr_70666_70764[(2)] = inst_70608);

(statearr_70666_70764[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (31))){
var inst_70627 = (state_70653[(15)]);
var state_70653__$1 = state_70653;
var statearr_70667_70765 = state_70653__$1;
(statearr_70667_70765[(2)] = inst_70627);

(statearr_70667_70765[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (32))){
var inst_70581 = (state_70653[(9)]);
var inst_70635 = (state_70653[(2)]);
var inst_70573 = inst_70581;
var inst_70574 = inst_70635;
var state_70653__$1 = (function (){var statearr_70668 = state_70653;
(statearr_70668[(14)] = inst_70574);

(statearr_70668[(8)] = inst_70573);

return statearr_70668;
})();
var statearr_70669_70766 = state_70653__$1;
(statearr_70669_70766[(2)] = null);

(statearr_70669_70766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (33))){
var inst_70574 = (state_70653[(14)]);
var state_70653__$1 = state_70653;
var statearr_70670_70767 = state_70653__$1;
(statearr_70670_70767[(2)] = inst_70574);

(statearr_70670_70767[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (13))){
var inst_70583 = (state_70653[(16)]);
var state_70653__$1 = state_70653;
var statearr_70671_70768 = state_70653__$1;
(statearr_70671_70768[(2)] = inst_70583);

(statearr_70671_70768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (22))){
var inst_70574 = (state_70653[(14)]);
var state_70653__$1 = state_70653;
var statearr_70672_70769 = state_70653__$1;
(statearr_70672_70769[(2)] = inst_70574);

(statearr_70672_70769[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (29))){
var inst_70627 = (state_70653[(2)]);
var state_70653__$1 = (function (){var statearr_70673 = state_70653;
(statearr_70673[(15)] = inst_70627);

return statearr_70673;
})();
if(cljs.core.truth_(show_auth)){
var statearr_70674_70770 = state_70653__$1;
(statearr_70674_70770[(1)] = (30));

} else {
var statearr_70675_70771 = state_70653__$1;
(statearr_70675_70771[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (6))){
var inst_70559 = (state_70653[(2)]);
var inst_70560 = fluree.db.util.async.throw_err(inst_70559);
var inst_70568 = resp;
var inst_70569 = cljs.core.seq(inst_70568);
var inst_70570 = cljs.core.first(inst_70569);
var inst_70571 = cljs.core.next(inst_70569);
var inst_70572 = cljs.core.PersistentHashMap.EMPTY;
var inst_70573 = inst_70568;
var inst_70574 = inst_70572;
var state_70653__$1 = (function (){var statearr_70676 = state_70653;
(statearr_70676[(17)] = inst_70560);

(statearr_70676[(14)] = inst_70574);

(statearr_70676[(18)] = inst_70571);

(statearr_70676[(8)] = inst_70573);

(statearr_70676[(19)] = inst_70570);

return statearr_70676;
})();
var statearr_70677_70772 = state_70653__$1;
(statearr_70677_70772[(2)] = null);

(statearr_70677_70772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (28))){
var inst_70619 = (state_70653[(12)]);
var state_70653__$1 = state_70653;
var statearr_70678_70773 = state_70653__$1;
(statearr_70678_70773[(2)] = inst_70619);

(statearr_70678_70773[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (25))){
var inst_70611 = (state_70653[(13)]);
var state_70653__$1 = state_70653;
var statearr_70679_70774 = state_70653__$1;
(statearr_70679_70774[(2)] = inst_70611);

(statearr_70679_70774[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (34))){
var state_70653__$1 = state_70653;
var statearr_70680_70775 = state_70653__$1;
(statearr_70680_70775[(2)] = null);

(statearr_70680_70775[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (17))){
var inst_70645 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
var statearr_70681_70776 = state_70653__$1;
(statearr_70681_70776[(2)] = inst_70645);

(statearr_70681_70776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (3))){
var inst_70651 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70653__$1,inst_70651);
} else {
if((state_val_70654 === (12))){
var inst_70560 = (state_70653[(17)]);
var inst_70580 = (state_70653[(7)]);
var inst_70585 = fluree.db.api.query.auth_match(auth,inst_70560,inst_70580);
var inst_70586 = cljs.core.not(inst_70585);
var state_70653__$1 = state_70653;
var statearr_70682_70777 = state_70653__$1;
(statearr_70682_70777[(2)] = inst_70586);

(statearr_70682_70777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (2))){
var _ = (function (){var statearr_70683 = state_70653;
(statearr_70683[(4)] = cljs.core.cons((5),(state_70653[(4)])));

return statearr_70683;
})();
var inst_70465 = (function (){return (function (p1__70458_SHARP_){
return fluree.db.flake.t(p1__70458_SHARP_);
});
})();
var inst_70466 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_70465,resp);
var inst_70467 = cljs.core.set(inst_70466);
var inst_70555 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70556 = (function (){var ts = inst_70467;
var c__2749__auto____$1 = inst_70555;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70553){
var state_val_70554 = (state_70553[(1)]);
if((state_val_70554 === (7))){
var inst_70493 = (state_70553[(7)]);
var inst_70499 = (state_70553[(8)]);
var inst_70487 = (state_70553[(9)]);
var inst_70481 = (state_70553[(10)]);
var inst_70492 = (state_70553[(2)]);
var inst_70493__$1 = fluree.db.util.async.throw_err(inst_70492);
var inst_70495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70496 = [inst_70487,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70497 = (new cljs.core.PersistentVector(null,2,(5),inst_70495,inst_70496,null));
var inst_70498 = cljs.core.assoc_in(inst_70481,inst_70497,inst_70493__$1);
var inst_70499__$1 = auth;
var state_70553__$1 = (function (){var statearr_70684 = state_70553;
(statearr_70684[(7)] = inst_70493__$1);

(statearr_70684[(8)] = inst_70499__$1);

(statearr_70684[(11)] = inst_70498);

return statearr_70684;
})();
if(cljs.core.truth_(inst_70499__$1)){
var statearr_70685_70778 = state_70553__$1;
(statearr_70685_70778[(1)] = (8));

} else {
var statearr_70686_70779 = state_70553__$1;
(statearr_70686_70779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (1))){
var inst_70475 = (state_70553[(12)]);
var inst_70475__$1 = ts;
var inst_70476 = cljs.core.seq(inst_70475__$1);
var inst_70477 = cljs.core.first(inst_70476);
var inst_70478 = cljs.core.next(inst_70476);
var inst_70479 = cljs.core.PersistentHashMap.EMPTY;
var inst_70480 = inst_70475__$1;
var inst_70481 = inst_70479;
var state_70553__$1 = (function (){var statearr_70687 = state_70553;
(statearr_70687[(12)] = inst_70475__$1);

(statearr_70687[(13)] = inst_70480);

(statearr_70687[(10)] = inst_70481);

(statearr_70687[(14)] = inst_70478);

(statearr_70687[(15)] = inst_70477);

return statearr_70687;
})();
var statearr_70688_70780 = state_70553__$1;
(statearr_70688_70780[(2)] = null);

(statearr_70688_70780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (4))){
var inst_70487 = (state_70553[(9)]);
var inst_70490 = fluree.db.time_travel.non_border_t_to_block(db,inst_70487);
var state_70553__$1 = state_70553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70553__$1,(7),inst_70490);
} else {
if((state_val_70554 === (13))){
var inst_70488 = (state_70553[(16)]);
var inst_70545 = (state_70553[(2)]);
var inst_70480 = inst_70488;
var inst_70481 = inst_70545;
var state_70553__$1 = (function (){var statearr_70689 = state_70553;
(statearr_70689[(13)] = inst_70480);

(statearr_70689[(10)] = inst_70481);

return statearr_70689;
})();
var statearr_70690_70781 = state_70553__$1;
(statearr_70690_70781[(2)] = null);

(statearr_70690_70781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (6))){
var inst_70549 = (state_70553[(2)]);
var state_70553__$1 = state_70553;
var statearr_70691_70782 = state_70553__$1;
(statearr_70691_70782[(2)] = inst_70549);

(statearr_70691_70782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (3))){
var inst_70551 = (state_70553[(2)]);
var state_70553__$1 = state_70553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70553__$1,inst_70551);
} else {
if((state_val_70554 === (12))){
var inst_70498 = (state_70553[(11)]);
var state_70553__$1 = state_70553;
var statearr_70692_70783 = state_70553__$1;
(statearr_70692_70783[(2)] = inst_70498);

(statearr_70692_70783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (2))){
var inst_70480 = (state_70553[(13)]);
var inst_70487 = (state_70553[(9)]);
var inst_70486 = cljs.core.seq(inst_70480);
var inst_70487__$1 = cljs.core.first(inst_70486);
var inst_70488 = cljs.core.next(inst_70486);
var state_70553__$1 = (function (){var statearr_70693 = state_70553;
(statearr_70693[(16)] = inst_70488);

(statearr_70693[(9)] = inst_70487__$1);

return statearr_70693;
})();
if(cljs.core.truth_(inst_70487__$1)){
var statearr_70694_70784 = state_70553__$1;
(statearr_70694_70784[(1)] = (4));

} else {
var statearr_70695_70785 = state_70553__$1;
(statearr_70695_70785[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (11))){
var inst_70488 = (state_70553[(16)]);
var inst_70493 = (state_70553[(7)]);
var inst_70475 = (state_70553[(12)]);
var inst_70480 = (state_70553[(13)]);
var inst_70487 = (state_70553[(9)]);
var inst_70481 = (state_70553[(10)]);
var inst_70478 = (state_70553[(14)]);
var inst_70498 = (state_70553[(11)]);
var inst_70477 = (state_70553[(15)]);
var inst_70505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70506 = [inst_70487,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70507 = (new cljs.core.PersistentVector(null,2,(5),inst_70505,inst_70506,null));
var inst_70520 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70521 = (function (){var t = inst_70487;
var c__2749__auto____$2 = inst_70520;
var seq__70473 = inst_70478;
var block = inst_70493;
var r = inst_70488;
var first__70474 = inst_70477;
var acc = inst_70481;
var vec__70472 = inst_70475;
var first__70485 = inst_70487;
var vec__70483 = inst_70480;
var G__70494 = inst_70498;
var seq__70484 = inst_70488;
var G__70471 = inst_70480;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70518){
var state_val_70519 = (state_70518[(1)]);
if((state_val_70519 === (1))){
var state_70518__$1 = state_70518;
var statearr_70696_70786 = state_70518__$1;
(statearr_70696_70786[(2)] = null);

(statearr_70696_70786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70519 === (2))){
var ___$1 = (function (){var statearr_70697 = state_70518;
(statearr_70697[(4)] = cljs.core.cons((5),(state_70518[(4)])));

return statearr_70697;
})();
var ___$2 = (function (){var statearr_70698 = state_70518;
(statearr_70698[(4)] = cljs.core.rest((state_70518[(4)])));

return statearr_70698;
})();
var state_70518__$1 = state_70518;
var statearr_70699_70787 = state_70518__$1;
(statearr_70699_70787[(2)] = db);

(statearr_70699_70787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70519 === (3))){
var inst_70516 = (state_70518[(2)]);
var state_70518__$1 = state_70518;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70518__$1,inst_70516);
} else {
if((state_val_70519 === (4))){
var inst_70508 = (state_70518[(2)]);
var state_70518__$1 = state_70518;
var statearr_70701_70788 = state_70518__$1;
(statearr_70701_70788[(2)] = inst_70508);

(statearr_70701_70788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70519 === (5))){
var ___$1 = (function (){var statearr_70702 = state_70518;
(statearr_70702[(4)] = cljs.core.rest((state_70518[(4)])));

return statearr_70702;
})();
var state_70518__$1 = state_70518;
var ex70700 = (state_70518__$1[(2)]);
var statearr_70703_70789 = state_70518__$1;
(statearr_70703_70789[(5)] = ex70700);


if((ex70700 instanceof Error)){
var statearr_70704_70790 = state_70518__$1;
(statearr_70704_70790[(1)] = (4));

(statearr_70704_70790[(5)] = null);

} else {
throw ex70700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70705 = [null,null,null,null,null,null,null];
(statearr_70705[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70705[(1)] = (1));

return statearr_70705;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70518){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70518);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70706){var ex__2730__auto__ = e70706;
var statearr_70707_70791 = state_70518;
(statearr_70707_70791[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70518[(4)]))){
var statearr_70708_70792 = state_70518;
(statearr_70708_70792[(1)] = cljs.core.first((state_70518[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70793 = state_70518;
state_70518 = G__70793;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70518){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70709 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70709[(6)] = c__2749__auto____$2);

return statearr_70709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_70522 = cljs.core.async.impl.dispatch.run(inst_70521);
var inst_70523 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_70524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70525 = ["?auth","?id"];
var inst_70526 = (new cljs.core.PersistentVector(null,2,(5),inst_70524,inst_70525,null));
var inst_70527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70529 = [inst_70487,"_tx/auth","?auth"];
var inst_70530 = (new cljs.core.PersistentVector(null,3,(5),inst_70528,inst_70529,null));
var inst_70531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70532 = ["?auth","_auth/id","?id"];
var inst_70533 = (new cljs.core.PersistentVector(null,3,(5),inst_70531,inst_70532,null));
var inst_70534 = [inst_70530,inst_70533];
var inst_70535 = (new cljs.core.PersistentVector(null,2,(5),inst_70527,inst_70534,null));
var inst_70536 = [inst_70526,inst_70535];
var inst_70537 = cljs.core.PersistentHashMap.fromArrays(inst_70523,inst_70536);
var inst_70538 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_70520,inst_70537) : fluree.db.api.query.query_async.call(null,inst_70520,inst_70537));
var state_70553__$1 = (function (){var statearr_70710 = state_70553;
(statearr_70710[(17)] = inst_70522);

(statearr_70710[(18)] = inst_70507);

return statearr_70710;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70553__$1,(14),inst_70538);
} else {
if((state_val_70554 === (9))){
var state_70553__$1 = state_70553;
var statearr_70711_70794 = state_70553__$1;
(statearr_70711_70794[(2)] = show_auth);

(statearr_70711_70794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (5))){
var inst_70481 = (state_70553[(10)]);
var state_70553__$1 = state_70553;
var statearr_70712_70795 = state_70553__$1;
(statearr_70712_70795[(2)] = inst_70481);

(statearr_70712_70795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (14))){
var inst_70507 = (state_70553[(18)]);
var inst_70498 = (state_70553[(11)]);
var inst_70540 = (state_70553[(2)]);
var inst_70541 = fluree.db.util.async.throw_err(inst_70540);
var inst_70542 = cljs.core.assoc_in(inst_70498,inst_70507,inst_70541);
var state_70553__$1 = state_70553;
var statearr_70713_70796 = state_70553__$1;
(statearr_70713_70796[(2)] = inst_70542);

(statearr_70713_70796[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (10))){
var inst_70503 = (state_70553[(2)]);
var state_70553__$1 = state_70553;
if(cljs.core.truth_(inst_70503)){
var statearr_70714_70797 = state_70553__$1;
(statearr_70714_70797[(1)] = (11));

} else {
var statearr_70715_70798 = state_70553__$1;
(statearr_70715_70798[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (8))){
var inst_70499 = (state_70553[(8)]);
var state_70553__$1 = state_70553;
var statearr_70716_70799 = state_70553__$1;
(statearr_70716_70799[(2)] = inst_70499);

(statearr_70716_70799[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70717[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70717[(1)] = (1));

return statearr_70717;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70553){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70553);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70718){var ex__2730__auto__ = e70718;
var statearr_70719_70800 = state_70553;
(statearr_70719_70800[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70553[(4)]))){
var statearr_70720_70801 = state_70553;
(statearr_70720_70801[(1)] = cljs.core.first((state_70553[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70802 = state_70553;
state_70553 = G__70802;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70553){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70721 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70721[(6)] = c__2749__auto____$1);

return statearr_70721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_70557 = cljs.core.async.impl.dispatch.run(inst_70556);
var state_70653__$1 = (function (){var statearr_70722 = state_70653;
(statearr_70722[(20)] = inst_70557);

return statearr_70722;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70653__$1,(6),inst_70555);
} else {
if((state_val_70654 === (23))){
var inst_70611 = (state_70653[(2)]);
var state_70653__$1 = (function (){var statearr_70723 = state_70653;
(statearr_70723[(13)] = inst_70611);

return statearr_70723;
})();
var statearr_70724_70803 = state_70653__$1;
(statearr_70724_70803[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (35))){
var inst_70641 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
var statearr_70726_70804 = state_70653__$1;
(statearr_70726_70804[(2)] = inst_70641);

(statearr_70726_70804[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (19))){
var state_70653__$1 = state_70653;
var statearr_70727_70805 = state_70653__$1;
(statearr_70727_70805[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (11))){
var inst_70592 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
if(cljs.core.truth_(inst_70592)){
var statearr_70730_70806 = state_70653__$1;
(statearr_70730_70806[(1)] = (15));

} else {
var statearr_70731_70807 = state_70653__$1;
(statearr_70731_70807[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (9))){
var inst_70583 = (state_70653[(16)]);
var inst_70583__$1 = auth;
var state_70653__$1 = (function (){var statearr_70732 = state_70653;
(statearr_70732[(16)] = inst_70583__$1);

return statearr_70732;
})();
if(cljs.core.truth_(inst_70583__$1)){
var statearr_70733_70808 = state_70653__$1;
(statearr_70733_70808[(1)] = (12));

} else {
var statearr_70734_70809 = state_70653__$1;
(statearr_70734_70809[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (5))){
var _ = (function (){var statearr_70735 = state_70653;
(statearr_70735[(4)] = cljs.core.rest((state_70653[(4)])));

return statearr_70735;
})();
var state_70653__$1 = state_70653;
var ex70729 = (state_70653__$1[(2)]);
var statearr_70736_70810 = state_70653__$1;
(statearr_70736_70810[(5)] = ex70729);


if((ex70729 instanceof Error)){
var statearr_70737_70811 = state_70653__$1;
(statearr_70737_70811[(1)] = (4));

(statearr_70737_70811[(5)] = null);

} else {
throw ex70729;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (14))){
var inst_70589 = (state_70653[(2)]);
var state_70653__$1 = state_70653;
var statearr_70738_70812 = state_70653__$1;
(statearr_70738_70812[(2)] = inst_70589);

(statearr_70738_70812[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (26))){
var inst_70619 = (state_70653[(2)]);
var state_70653__$1 = (function (){var statearr_70739 = state_70653;
(statearr_70739[(12)] = inst_70619);

return statearr_70739;
})();
var statearr_70740_70813 = state_70653__$1;
(statearr_70740_70813[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (16))){
var inst_70580 = (state_70653[(7)]);
var state_70653__$1 = state_70653;
if(cljs.core.truth_(inst_70580)){
var statearr_70742_70814 = state_70653__$1;
(statearr_70742_70814[(1)] = (18));

} else {
var statearr_70743_70815 = state_70653__$1;
(statearr_70743_70815[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (30))){
var inst_70601 = (state_70653[(10)]);
var inst_70602 = (state_70653[(21)]);
var inst_70627 = (state_70653[(15)]);
var inst_70629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70630 = [inst_70601,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70631 = (new cljs.core.PersistentVector(null,2,(5),inst_70629,inst_70630,null));
var inst_70632 = cljs.core.assoc_in(inst_70627,inst_70631,inst_70602);
var state_70653__$1 = state_70653;
var statearr_70744_70816 = state_70653__$1;
(statearr_70744_70816[(2)] = inst_70632);

(statearr_70744_70816[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (10))){
var inst_70580 = (state_70653[(7)]);
var state_70653__$1 = state_70653;
var statearr_70745_70817 = state_70653__$1;
(statearr_70745_70817[(2)] = inst_70580);

(statearr_70745_70817[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (18))){
var inst_70560 = (state_70653[(17)]);
var inst_70580 = (state_70653[(7)]);
var inst_70598 = (state_70653[(11)]);
var inst_70598__$1 = fluree.db.flake.t(inst_70580);
var inst_70599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70560,inst_70598__$1);
var inst_70600 = cljs.core.__destructure_map(inst_70599);
var inst_70601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70600,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70600,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_70653__$1 = (function (){var statearr_70746 = state_70653;
(statearr_70746[(10)] = inst_70601);

(statearr_70746[(21)] = inst_70602);

(statearr_70746[(11)] = inst_70598__$1);

return statearr_70746;
})();
var statearr_70747_70818 = state_70653__$1;
(statearr_70747_70818[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70654 === (8))){
var inst_70647 = (state_70653[(2)]);
var inst_70648 = cljs.core.vals(inst_70647);
var _ = (function (){var statearr_70749 = state_70653;
(statearr_70749[(4)] = cljs.core.rest((state_70653[(4)])));

return statearr_70749;
})();
var state_70653__$1 = state_70653;
var statearr_70750_70819 = state_70653__$1;
(statearr_70750_70819[(2)] = inst_70648);

(statearr_70750_70819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70751[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70751[(1)] = (1));

return statearr_70751;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70653){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70653);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70752){var ex__2730__auto__ = e70752;
var statearr_70753_70820 = state_70653;
(statearr_70753_70820[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70653[(4)]))){
var statearr_70754_70821 = state_70653;
(statearr_70754_70821[(1)] = cljs.core.first((state_70653[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70822 = state_70653;
state_70653 = G__70822;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70653){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70755 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70755[(6)] = c__2749__auto__);

return statearr_70755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70946){
var state_val_70947 = (state_70946[(1)]);
if((state_val_70947 === (7))){
var inst_70845 = (state_70946[(7)]);
var inst_70847 = fluree.db.api.query.resolve_block_range(inst_70845,query_map);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(10),inst_70847);
} else {
if((state_val_70947 === (20))){
var inst_70871 = (state_70946[(2)]);
var inst_70872 = fluree.db.util.async.throw_err(inst_70871);
var inst_70873 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70872);
var inst_70874 = (inst_70873 - (1));
var state_70946__$1 = state_70946;
var statearr_70948_71011 = state_70946__$1;
(statearr_70948_71011[(2)] = inst_70874);

(statearr_70948_71011[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (27))){
var state_70946__$1 = state_70946;
var statearr_70949_71012 = state_70946__$1;
(statearr_70949_71012[(2)] = null);

(statearr_70949_71012[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (1))){
var state_70946__$1 = state_70946;
var statearr_70950_71013 = state_70946__$1;
(statearr_70950_71013[(2)] = null);

(statearr_70950_71013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (24))){
var inst_70881 = (state_70946[(2)]);
var inst_70882 = fluree.db.util.async.throw_err(inst_70881);
var inst_70883 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70882);
var state_70946__$1 = state_70946;
var statearr_70951_71014 = state_70946__$1;
(statearr_70951_71014[(2)] = inst_70883);

(statearr_70951_71014[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (39))){
var inst_70918 = (state_70946[(2)]);
var inst_70919 = fluree.db.util.async.throw_err(inst_70918);
var state_70946__$1 = state_70946;
var statearr_70952_71015 = state_70946__$1;
(statearr_70952_71015[(2)] = inst_70919);

(statearr_70952_71015[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (4))){
var inst_70823 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
var statearr_70953_71016 = state_70946__$1;
(statearr_70953_71016[(2)] = inst_70823);

(statearr_70953_71016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (15))){
var inst_70854 = (state_70946[(8)]);
var state_70946__$1 = state_70946;
var statearr_70954_71017 = state_70946__$1;
(statearr_70954_71017[(2)] = inst_70854);

(statearr_70954_71017[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (21))){
var inst_70855 = (state_70946[(9)]);
var inst_70845 = (state_70946[(7)]);
var inst_70879 = fluree.db.time_travel.as_of_block(inst_70845,inst_70855);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(24),inst_70879);
} else {
if((state_val_70947 === (31))){
var inst_70839 = (state_70946[(10)]);
var state_70946__$1 = state_70946;
var statearr_70955_71018 = state_70946__$1;
(statearr_70955_71018[(2)] = inst_70839);

(statearr_70955_71018[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (32))){
var inst_70897 = (state_70946[(11)]);
var inst_70902 = (state_70946[(12)]);
var inst_70845 = (state_70946[(7)]);
var inst_70906 = (state_70946[(2)]);
var inst_70907 = fluree.db.api.query.format_history_resp(inst_70845,inst_70897,inst_70902,inst_70906);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(29),inst_70907);
} else {
if((state_val_70947 === (40))){
var inst_70897 = (state_70946[(11)]);
var inst_70923 = (state_70946[(13)]);
var inst_70925 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70926 = cljs.core.count(inst_70897);
var inst_70927 = [inst_70923,inst_70926,(200)];
var inst_70928 = cljs.core.PersistentHashMap.fromArrays(inst_70925,inst_70927);
var state_70946__$1 = state_70946;
var statearr_70956_71019 = state_70946__$1;
(statearr_70956_71019[(2)] = inst_70928);

(statearr_70956_71019[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (33))){
var inst_70838 = (state_70946[(14)]);
var state_70946__$1 = state_70946;
var statearr_70957_71020 = state_70946__$1;
(statearr_70957_71020[(2)] = inst_70838);

(statearr_70957_71020[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (13))){
var inst_70941 = (state_70946[(2)]);
var _ = (function (){var statearr_70958 = state_70946;
(statearr_70958[(4)] = cljs.core.rest((state_70946[(4)])));

return statearr_70958;
})();
var state_70946__$1 = state_70946;
var statearr_70959_71021 = state_70946__$1;
(statearr_70959_71021[(2)] = inst_70941);

(statearr_70959_71021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (22))){
var inst_70845 = (state_70946[(7)]);
var inst_70885 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70845);
var state_70946__$1 = state_70946;
var statearr_70960_71022 = state_70946__$1;
(statearr_70960_71022[(2)] = inst_70885);

(statearr_70960_71022[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (36))){
var inst_70910 = (state_70946[(15)]);
var inst_70845 = (state_70946[(7)]);
var inst_70916 = fluree.db.api.query.format_blocks_resp_pretty(inst_70845,inst_70910);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(39),inst_70916);
} else {
if((state_val_70947 === (41))){
var inst_70923 = (state_70946[(13)]);
var state_70946__$1 = state_70946;
var statearr_70961_71023 = state_70946__$1;
(statearr_70961_71023[(2)] = inst_70923);

(statearr_70961_71023[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (29))){
var inst_70838 = (state_70946[(14)]);
var inst_70909 = (state_70946[(2)]);
var inst_70910 = fluree.db.util.async.throw_err(inst_70909);
var state_70946__$1 = (function (){var statearr_70962 = state_70946;
(statearr_70962[(15)] = inst_70910);

return statearr_70962;
})();
if(cljs.core.truth_(inst_70838)){
var statearr_70963_71024 = state_70946__$1;
(statearr_70963_71024[(1)] = (33));

} else {
var statearr_70964_71025 = state_70946__$1;
(statearr_70964_71025[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (6))){
var inst_70835 = (state_70946[(16)]);
var inst_70844 = (state_70946[(2)]);
var inst_70845 = fluree.db.util.async.throw_err(inst_70844);
var state_70946__$1 = (function (){var statearr_70965 = state_70946;
(statearr_70965[(7)] = inst_70845);

return statearr_70965;
})();
if(cljs.core.truth_(inst_70835)){
var statearr_70966_71026 = state_70946__$1;
(statearr_70966_71026[(1)] = (7));

} else {
var statearr_70967_71027 = state_70946__$1;
(statearr_70967_71027[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (28))){
var inst_70840 = (state_70946[(17)]);
var inst_70902 = (state_70946[(2)]);
var state_70946__$1 = (function (){var statearr_70968 = state_70946;
(statearr_70968[(12)] = inst_70902);

return statearr_70968;
})();
if(cljs.core.truth_(inst_70840)){
var statearr_70969_71028 = state_70946__$1;
(statearr_70969_71028[(1)] = (30));

} else {
var statearr_70970_71029 = state_70946__$1;
(statearr_70970_71029[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (25))){
var inst_70841 = (state_70946[(18)]);
var inst_70896 = (state_70946[(2)]);
var inst_70897 = fluree.db.util.async.throw_err(inst_70896);
var state_70946__$1 = (function (){var statearr_70971 = state_70946;
(statearr_70971[(11)] = inst_70897);

return statearr_70971;
})();
if(cljs.core.truth_(inst_70841)){
var statearr_70972_71030 = state_70946__$1;
(statearr_70972_71030[(1)] = (26));

} else {
var statearr_70973_71031 = state_70946__$1;
(statearr_70973_71031[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (34))){
var inst_70837 = (state_70946[(19)]);
var state_70946__$1 = state_70946;
var statearr_70974_71032 = state_70946__$1;
(statearr_70974_71032[(2)] = inst_70837);

(statearr_70974_71032[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (17))){
var inst_70845 = (state_70946[(7)]);
var inst_70854 = (state_70946[(8)]);
var inst_70868 = (inst_70854 - (1));
var inst_70869 = fluree.db.time_travel.as_of_block(inst_70845,inst_70868);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(20),inst_70869);
} else {
if((state_val_70947 === (3))){
var inst_70944 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70946__$1,inst_70944);
} else {
if((state_val_70947 === (12))){
var inst_70933 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_70934 = ["History query not properly formatted. Provided ",inst_70933].join('');
var inst_70935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70936 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70937 = cljs.core.PersistentHashMap.fromArrays(inst_70935,inst_70936);
var inst_70938 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70934,inst_70937);
var inst_70939 = (function(){throw inst_70938})();
var state_70946__$1 = state_70946;
var statearr_70975_71033 = state_70946__$1;
(statearr_70975_71033[(2)] = inst_70939);

(statearr_70975_71033[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (2))){
var _ = (function (){var statearr_70976 = state_70946;
(statearr_70976[(4)] = cljs.core.cons((5),(state_70946[(4)])));

return statearr_70976;
})();
var inst_70833 = query_map;
var inst_70834 = cljs.core.__destructure_map(inst_70833);
var inst_70835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70836 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_70839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_70840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_70841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70842 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70834,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70946__$1 = (function (){var statearr_70977 = state_70946;
(statearr_70977[(20)] = inst_70836);

(statearr_70977[(19)] = inst_70837);

(statearr_70977[(21)] = inst_70842);

(statearr_70977[(14)] = inst_70838);

(statearr_70977[(17)] = inst_70840);

(statearr_70977[(10)] = inst_70839);

(statearr_70977[(18)] = inst_70841);

(statearr_70977[(16)] = inst_70835);

return statearr_70977;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(6),sources);
} else {
if((state_val_70947 === (23))){
var inst_70836 = (state_70946[(20)]);
var inst_70877 = (state_70946[(22)]);
var inst_70845 = (state_70946[(7)]);
var inst_70887 = (state_70946[(2)]);
var inst_70888 = fluree.db.api.query.get_history_pattern(inst_70836);
var inst_70889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70888,(0),null);
var inst_70890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70888,(1),null);
var inst_70891 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_70892 = [inst_70877,inst_70887];
var inst_70893 = cljs.core.PersistentHashMap.fromArrays(inst_70891,inst_70892);
var inst_70894 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_70845,inst_70890,cljs.core._EQ_,inst_70889,inst_70893);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(25),inst_70894);
} else {
if((state_val_70947 === (35))){
var inst_70914 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
if(cljs.core.truth_(inst_70914)){
var statearr_70978_71034 = state_70946__$1;
(statearr_70978_71034[(1)] = (36));

} else {
var statearr_70979_71035 = state_70946__$1;
(statearr_70979_71035[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (19))){
var inst_70855 = (state_70946[(9)]);
var inst_70877 = (state_70946[(2)]);
var state_70946__$1 = (function (){var statearr_70980 = state_70946;
(statearr_70980[(22)] = inst_70877);

return statearr_70980;
})();
if(cljs.core.truth_(inst_70855)){
var statearr_70981_71036 = state_70946__$1;
(statearr_70981_71036[(1)] = (21));

} else {
var statearr_70982_71037 = state_70946__$1;
(statearr_70982_71037[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (11))){
var inst_70842 = (state_70946[(21)]);
var inst_70854 = (state_70946[(8)]);
var inst_70861 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70842);
var state_70946__$1 = (function (){var statearr_70984 = state_70946;
(statearr_70984[(23)] = inst_70861);

return statearr_70984;
})();
if(cljs.core.truth_(inst_70854)){
var statearr_70985_71038 = state_70946__$1;
(statearr_70985_71038[(1)] = (14));

} else {
var statearr_70986_71039 = state_70946__$1;
(statearr_70986_71039[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (9))){
var inst_70853 = (state_70946[(2)]);
var inst_70854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70853,(0),null);
var inst_70855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70853,(1),null);
var inst_70856 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_70946__$1 = (function (){var statearr_70987 = state_70946;
(statearr_70987[(9)] = inst_70855);

(statearr_70987[(8)] = inst_70854);

return statearr_70987;
})();
if(inst_70856){
var statearr_70988_71040 = state_70946__$1;
(statearr_70988_71040[(1)] = (11));

} else {
var statearr_70989_71041 = state_70946__$1;
(statearr_70989_71041[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (5))){
var _ = (function (){var statearr_70990 = state_70946;
(statearr_70990[(4)] = cljs.core.rest((state_70946[(4)])));

return statearr_70990;
})();
var state_70946__$1 = state_70946;
var ex70983 = (state_70946__$1[(2)]);
var statearr_70991_71042 = state_70946__$1;
(statearr_70991_71042[(5)] = ex70983);


if((ex70983 instanceof Error)){
var statearr_70992_71043 = state_70946__$1;
(statearr_70992_71043[(1)] = (4));

(statearr_70992_71043[(5)] = null);

} else {
throw ex70983;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (14))){
var inst_70854 = (state_70946[(8)]);
var inst_70863 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70854);
var state_70946__$1 = state_70946;
var statearr_70993_71044 = state_70946__$1;
(statearr_70993_71044[(2)] = inst_70863);

(statearr_70993_71044[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (26))){
var inst_70841 = (state_70946[(18)]);
var inst_70899 = cljs.core.set(inst_70841);
var state_70946__$1 = state_70946;
var statearr_70994_71045 = state_70946__$1;
(statearr_70994_71045[(2)] = inst_70899);

(statearr_70994_71045[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (16))){
var inst_70866 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
if(cljs.core.truth_(inst_70866)){
var statearr_70995_71046 = state_70946__$1;
(statearr_70995_71046[(1)] = (17));

} else {
var statearr_70996_71047 = state_70946__$1;
(statearr_70996_71047[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (38))){
var inst_70861 = (state_70946[(23)]);
var inst_70923 = (state_70946[(2)]);
var state_70946__$1 = (function (){var statearr_70997 = state_70946;
(statearr_70997[(13)] = inst_70923);

return statearr_70997;
})();
if(cljs.core.truth_(inst_70861)){
var statearr_70998_71048 = state_70946__$1;
(statearr_70998_71048[(1)] = (40));

} else {
var statearr_70999_71049 = state_70946__$1;
(statearr_70999_71049[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (30))){
var inst_70840 = (state_70946[(17)]);
var state_70946__$1 = state_70946;
var statearr_71000_71050 = state_70946__$1;
(statearr_71000_71050[(2)] = inst_70840);

(statearr_71000_71050[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (10))){
var inst_70849 = (state_70946[(2)]);
var inst_70850 = fluree.db.util.async.throw_err(inst_70849);
var state_70946__$1 = state_70946;
var statearr_71001_71051 = state_70946__$1;
(statearr_71001_71051[(2)] = inst_70850);

(statearr_71001_71051[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (18))){
var state_70946__$1 = state_70946;
var statearr_71002_71052 = state_70946__$1;
(statearr_71002_71052[(2)] = (-1));

(statearr_71002_71052[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (42))){
var inst_70931 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
var statearr_71003_71053 = state_70946__$1;
(statearr_71003_71053[(2)] = inst_70931);

(statearr_71003_71053[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (37))){
var inst_70910 = (state_70946[(15)]);
var inst_70921 = fluree.db.api.query.block_Flakes__GT_vector(inst_70910);
var state_70946__$1 = state_70946;
var statearr_71004_71054 = state_70946__$1;
(statearr_71004_71054[(2)] = inst_70921);

(statearr_71004_71054[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (8))){
var state_70946__$1 = state_70946;
var statearr_71005_71055 = state_70946__$1;
(statearr_71005_71055[(2)] = null);

(statearr_71005_71055[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_71006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71006[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_71006[(1)] = (1));

return statearr_71006;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_70946){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70946);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71007){var ex__2730__auto__ = e71007;
var statearr_71008_71056 = state_70946;
(statearr_71008_71056[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70946[(4)]))){
var statearr_71009_71057 = state_70946;
(statearr_71009_71057[(1)] = cljs.core.first((state_70946[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71058 = state_70946;
state_70946 = G__71058;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_70946){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_70946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71010 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71010[(6)] = c__2749__auto__);

return statearr_71010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71191){
var state_val_71192 = (state_71191[(1)]);
if((state_val_71192 === (7))){
var inst_71088 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_71089 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_71088].join('');
var inst_71090 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71091 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71092 = cljs.core.PersistentHashMap.fromArrays(inst_71090,inst_71091);
var inst_71093 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71089,inst_71092);
var inst_71094 = (function(){throw inst_71093})();
var state_71191__$1 = state_71191;
var statearr_71193_71272 = state_71191__$1;
(statearr_71193_71272[(2)] = inst_71094);

(statearr_71193_71272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (20))){
var inst_71126 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71126)){
var statearr_71194_71273 = state_71191__$1;
(statearr_71194_71273[(1)] = (21));

} else {
var statearr_71195_71274 = state_71191__$1;
(statearr_71195_71274[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (27))){
var inst_71070 = (state_71191[(7)]);
var state_71191__$1 = state_71191;
var statearr_71196_71275 = state_71191__$1;
(statearr_71196_71275[(2)] = inst_71070);

(statearr_71196_71275[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (1))){
var state_71191__$1 = state_71191;
var statearr_71197_71276 = state_71191__$1;
(statearr_71197_71276[(2)] = null);

(statearr_71197_71276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (24))){
var inst_71132 = (state_71191[(8)]);
var state_71191__$1 = state_71191;
var statearr_71198_71277 = state_71191__$1;
(statearr_71198_71277[(2)] = inst_71132);

(statearr_71198_71277[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (39))){
var inst_71076 = (state_71191[(9)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71076)){
var statearr_71199_71278 = state_71191__$1;
(statearr_71199_71278[(1)] = (42));

} else {
var statearr_71200_71279 = state_71191__$1;
(statearr_71200_71279[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (46))){
var inst_71164 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71165 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71166 = cljs.core.PersistentHashMap.fromArrays(inst_71164,inst_71165);
var inst_71167 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_71166);
var inst_71168 = (function(){throw inst_71167})();
var state_71191__$1 = state_71191;
var statearr_71201_71280 = state_71191__$1;
(statearr_71201_71280[(2)] = inst_71168);

(statearr_71201_71280[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (4))){
var inst_71060 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
var statearr_71202_71281 = state_71191__$1;
(statearr_71202_71281[(2)] = inst_71060);

(statearr_71202_71281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (15))){
var inst_71073 = (state_71191[(10)]);
var inst_71111 = (state_71191[(11)]);
var inst_71113 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_71111);
var inst_71114 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_71111);
var inst_71115 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71111);
var inst_71116 = fluree.db.api.query.get_sources(inst_71113,inst_71114,inst_71115,inst_71073);
var state_71191__$1 = state_71191;
var statearr_71203_71282 = state_71191__$1;
(statearr_71203_71282[(2)] = inst_71116);

(statearr_71203_71282[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (48))){
var inst_71121 = (state_71191[(12)]);
var inst_71175 = (state_71191[(2)]);
var inst_71176 = fluree.db.util.async.throw_err(inst_71175);
var state_71191__$1 = (function (){var statearr_71204 = state_71191;
(statearr_71204[(13)] = inst_71176);

return statearr_71204;
})();
if(cljs.core.truth_(inst_71121)){
var statearr_71205_71283 = state_71191__$1;
(statearr_71205_71283[(1)] = (49));

} else {
var statearr_71206_71284 = state_71191__$1;
(statearr_71206_71284[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (50))){
var inst_71176 = (state_71191[(13)]);
var state_71191__$1 = state_71191;
var statearr_71207_71285 = state_71191__$1;
(statearr_71207_71285[(2)] = inst_71176);

(statearr_71207_71285[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (21))){
var inst_71128 = cljs.core.volatile_BANG_((0));
var state_71191__$1 = state_71191;
var statearr_71208_71286 = state_71191__$1;
(statearr_71208_71286[(2)] = inst_71128);

(statearr_71208_71286[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (31))){
var inst_71074 = (state_71191[(14)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71074)){
var statearr_71209_71287 = state_71191__$1;
(statearr_71209_71287[(1)] = (33));

} else {
var statearr_71210_71288 = state_71191__$1;
(statearr_71210_71288[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (32))){
var inst_71151 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
var statearr_71211_71289 = state_71191__$1;
(statearr_71211_71289[(2)] = inst_71151);

(statearr_71211_71289[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (40))){
var inst_71153 = (state_71191[(15)]);
var state_71191__$1 = state_71191;
var statearr_71212_71290 = state_71191__$1;
(statearr_71212_71290[(2)] = inst_71153);

(statearr_71212_71290[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (33))){
var inst_71074 = (state_71191[(14)]);
var state_71191__$1 = state_71191;
var statearr_71213_71291 = state_71191__$1;
(statearr_71213_71291[(2)] = inst_71074);

(statearr_71213_71291[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (13))){
var inst_71071 = (state_71191[(16)]);
var inst_71100 = (state_71191[(2)]);
var inst_71101 = fluree.db.util.async.throw_err(inst_71100);
var inst_71102 = fluree.db.time_travel.as_of_block(inst_71101,inst_71071);
var state_71191__$1 = state_71191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71191__$1,(12),inst_71102);
} else {
if((state_val_71192 === (22))){
var state_71191__$1 = state_71191;
var statearr_71214_71292 = state_71191__$1;
(statearr_71214_71292[(2)] = null);

(statearr_71214_71292[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (36))){
var inst_71078 = (state_71191[(17)]);
var state_71191__$1 = state_71191;
var statearr_71215_71293 = state_71191__$1;
(statearr_71215_71293[(2)] = inst_71078);

(statearr_71215_71293[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (41))){
var inst_71161 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71161)){
var statearr_71216_71294 = state_71191__$1;
(statearr_71216_71294[(1)] = (45));

} else {
var statearr_71217_71295 = state_71191__$1;
(statearr_71217_71295[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (43))){
var inst_71072 = (state_71191[(18)]);
var state_71191__$1 = state_71191;
var statearr_71218_71296 = state_71191__$1;
(statearr_71218_71296[(2)] = inst_71072);

(statearr_71218_71296[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (29))){
var inst_71153 = (state_71191[(15)]);
var inst_71153__$1 = (state_71191[(2)]);
var state_71191__$1 = (function (){var statearr_71219 = state_71191;
(statearr_71219[(15)] = inst_71153__$1);

return statearr_71219;
})();
if(cljs.core.truth_(inst_71153__$1)){
var statearr_71220_71297 = state_71191__$1;
(statearr_71220_71297[(1)] = (39));

} else {
var statearr_71221_71298 = state_71191__$1;
(statearr_71221_71298[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (44))){
var inst_71158 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
var statearr_71222_71299 = state_71191__$1;
(statearr_71222_71299[(2)] = inst_71158);

(statearr_71222_71299[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (6))){
var state_71191__$1 = state_71191;
var statearr_71223_71300 = state_71191__$1;
(statearr_71223_71300[(2)] = null);

(statearr_71223_71300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (28))){
var inst_71075 = (state_71191[(19)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71075)){
var statearr_71224_71301 = state_71191__$1;
(statearr_71224_71301[(1)] = (30));

} else {
var statearr_71225_71302 = state_71191__$1;
(statearr_71225_71302[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (51))){
var inst_71186 = (state_71191[(2)]);
var _ = (function (){var statearr_71226 = state_71191;
(statearr_71226[(4)] = cljs.core.rest((state_71191[(4)])));

return statearr_71226;
})();
var state_71191__$1 = state_71191;
var statearr_71227_71303 = state_71191__$1;
(statearr_71227_71303[(2)] = inst_71186);

(statearr_71227_71303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (25))){
var state_71191__$1 = state_71191;
var statearr_71228_71304 = state_71191__$1;
(statearr_71228_71304[(2)] = (1000000));

(statearr_71228_71304[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (34))){
var inst_71078 = (state_71191[(17)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71078)){
var statearr_71229_71305 = state_71191__$1;
(statearr_71229_71305[(1)] = (36));

} else {
var statearr_71230_71306 = state_71191__$1;
(statearr_71230_71306[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (17))){
var inst_71122 = (state_71191[(20)]);
var inst_71077 = (state_71191[(21)]);
var inst_71120 = (state_71191[(2)]);
var inst_71121 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71077);
var inst_71122__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71077);
var state_71191__$1 = (function (){var statearr_71231 = state_71191;
(statearr_71231[(22)] = inst_71120);

(statearr_71231[(12)] = inst_71121);

(statearr_71231[(20)] = inst_71122__$1);

return statearr_71231;
})();
if(cljs.core.truth_(inst_71122__$1)){
var statearr_71232_71307 = state_71191__$1;
(statearr_71232_71307[(1)] = (18));

} else {
var statearr_71233_71308 = state_71191__$1;
(statearr_71233_71308[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (3))){
var inst_71189 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71191__$1,inst_71189);
} else {
if((state_val_71192 === (12))){
var inst_71104 = (state_71191[(2)]);
var inst_71105 = fluree.db.util.async.throw_err(inst_71104);
var state_71191__$1 = state_71191;
var statearr_71234_71309 = state_71191__$1;
(statearr_71234_71309[(2)] = inst_71105);

(statearr_71234_71309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (2))){
var inst_71069 = (state_71191[(23)]);
var inst_71072 = (state_71191[(18)]);
var inst_71073 = (state_71191[(10)]);
var inst_71075 = (state_71191[(19)]);
var inst_71074 = (state_71191[(14)]);
var inst_71070 = (state_71191[(7)]);
var inst_71077 = (state_71191[(21)]);
var inst_71078 = (state_71191[(17)]);
var inst_71071 = (state_71191[(16)]);
var inst_71076 = (state_71191[(9)]);
var _ = (function (){var statearr_71235 = state_71191;
(statearr_71235[(4)] = cljs.core.cons((5),(state_71191[(4)])));

return statearr_71235;
})();
var inst_71067 = flureeQL;
var inst_71068 = cljs.core.__destructure_map(inst_71067);
var inst_71069__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_71070__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_71071__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71072__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_71073__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_71074__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_71075__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_71076__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_71077__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71078__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71068,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_71079 = (function (){var construct = inst_71069__$1;
var select = inst_71070__$1;
var map__71066 = inst_71068;
var block = inst_71071__$1;
var where = inst_71072__$1;
var prefixes = inst_71073__$1;
var selectDistinct = inst_71074__$1;
var selectOne = inst_71075__$1;
var from = inst_71076__$1;
var opts = inst_71077__$1;
var selectReduced = inst_71078__$1;
return (function (p1__71059_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__71059_SHARP_);
});
})();
var inst_71080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71081 = [inst_71070__$1,inst_71075__$1,inst_71074__$1,inst_71078__$1];
var inst_71082 = (new cljs.core.PersistentVector(null,4,(5),inst_71080,inst_71081,null));
var inst_71083 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_71082);
var inst_71084 = cljs.core.count(inst_71083);
var inst_71085 = (inst_71079.cljs$core$IFn$_invoke$arity$1 ? inst_71079.cljs$core$IFn$_invoke$arity$1(inst_71084) : inst_71079.call(null,inst_71084));
var state_71191__$1 = (function (){var statearr_71236 = state_71191;
(statearr_71236[(23)] = inst_71069__$1);

(statearr_71236[(18)] = inst_71072__$1);

(statearr_71236[(10)] = inst_71073__$1);

(statearr_71236[(19)] = inst_71075__$1);

(statearr_71236[(14)] = inst_71074__$1);

(statearr_71236[(7)] = inst_71070__$1);

(statearr_71236[(21)] = inst_71077__$1);

(statearr_71236[(17)] = inst_71078__$1);

(statearr_71236[(16)] = inst_71071__$1);

(statearr_71236[(9)] = inst_71076__$1);

return statearr_71236;
})();
if(cljs.core.truth_(inst_71085)){
var statearr_71237_71310 = state_71191__$1;
(statearr_71237_71310[(1)] = (6));

} else {
var statearr_71238_71311 = state_71191__$1;
(statearr_71238_71311[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (23))){
var inst_71132 = (state_71191[(8)]);
var inst_71077 = (state_71191[(21)]);
var inst_71131 = (state_71191[(2)]);
var inst_71132__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71077);
var state_71191__$1 = (function (){var statearr_71239 = state_71191;
(statearr_71239[(8)] = inst_71132__$1);

(statearr_71239[(24)] = inst_71131);

return statearr_71239;
})();
if(cljs.core.truth_(inst_71132__$1)){
var statearr_71240_71312 = state_71191__$1;
(statearr_71240_71312[(1)] = (24));

} else {
var statearr_71241_71313 = state_71191__$1;
(statearr_71241_71313[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (47))){
var inst_71137 = (state_71191[(25)]);
var inst_71111 = (state_71191[(11)]);
var inst_71170 = (state_71191[(2)]);
var inst_71171 = fluree.db.util.core.current_time_millis();
var inst_71172 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71137);
var inst_71173 = fluree.db.query.fql.query(inst_71111,inst_71172);
var state_71191__$1 = (function (){var statearr_71242 = state_71191;
(statearr_71242[(26)] = inst_71171);

(statearr_71242[(27)] = inst_71170);

return statearr_71242;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71191__$1,(48),inst_71173);
} else {
if((state_val_71192 === (35))){
var inst_71149 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
var statearr_71243_71314 = state_71191__$1;
(statearr_71243_71314[(2)] = inst_71149);

(statearr_71243_71314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (19))){
var inst_71121 = (state_71191[(12)]);
var state_71191__$1 = state_71191;
var statearr_71244_71315 = state_71191__$1;
(statearr_71244_71315[(2)] = inst_71121);

(statearr_71244_71315[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (11))){
var inst_71073 = (state_71191[(10)]);
var inst_71111 = (state_71191[(2)]);
var state_71191__$1 = (function (){var statearr_71246 = state_71191;
(statearr_71246[(11)] = inst_71111);

return statearr_71246;
})();
if(cljs.core.truth_(inst_71073)){
var statearr_71247_71316 = state_71191__$1;
(statearr_71247_71316[(1)] = (15));

} else {
var statearr_71248_71317 = state_71191__$1;
(statearr_71248_71317[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (9))){
var inst_71097 = (state_71191[(28)]);
var state_71191__$1 = state_71191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71191__$1,(13),inst_71097);
} else {
if((state_val_71192 === (5))){
var _ = (function (){var statearr_71249 = state_71191;
(statearr_71249[(4)] = cljs.core.rest((state_71191[(4)])));

return statearr_71249;
})();
var state_71191__$1 = state_71191;
var ex71245 = (state_71191__$1[(2)]);
var statearr_71250_71318 = state_71191__$1;
(statearr_71250_71318[(5)] = ex71245);


if((ex71245 instanceof Error)){
var statearr_71251_71319 = state_71191__$1;
(statearr_71251_71319[(1)] = (4));

(statearr_71251_71319[(5)] = null);

} else {
throw ex71245;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (14))){
var inst_71108 = (state_71191[(2)]);
var inst_71109 = fluree.db.util.async.throw_err(inst_71108);
var state_71191__$1 = state_71191;
var statearr_71252_71320 = state_71191__$1;
(statearr_71252_71320[(2)] = inst_71109);

(statearr_71252_71320[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (45))){
var state_71191__$1 = state_71191;
var statearr_71253_71321 = state_71191__$1;
(statearr_71253_71321[(2)] = null);

(statearr_71253_71321[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (26))){
var inst_71120 = (state_71191[(22)]);
var inst_71070 = (state_71191[(7)]);
var inst_71077 = (state_71191[(21)]);
var inst_71131 = (state_71191[(24)]);
var inst_71136 = (state_71191[(2)]);
var inst_71137 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_71077,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_71120,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_71136,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71131], 0));
var state_71191__$1 = (function (){var statearr_71254 = state_71191;
(statearr_71254[(25)] = inst_71137);

return statearr_71254;
})();
if(cljs.core.truth_(inst_71070)){
var statearr_71255_71322 = state_71191__$1;
(statearr_71255_71322[(1)] = (27));

} else {
var statearr_71256_71323 = state_71191__$1;
(statearr_71256_71323[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (16))){
var inst_71118 = cljs.core.PersistentHashMap.EMPTY;
var state_71191__$1 = state_71191;
var statearr_71257_71324 = state_71191__$1;
(statearr_71257_71324[(2)] = inst_71118);

(statearr_71257_71324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (38))){
var inst_71147 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
var statearr_71258_71325 = state_71191__$1;
(statearr_71258_71325[(2)] = inst_71147);

(statearr_71258_71325[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (30))){
var inst_71075 = (state_71191[(19)]);
var state_71191__$1 = state_71191;
var statearr_71259_71326 = state_71191__$1;
(statearr_71259_71326[(2)] = inst_71075);

(statearr_71259_71326[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (10))){
var inst_71097 = (state_71191[(28)]);
var state_71191__$1 = state_71191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71191__$1,(14),inst_71097);
} else {
if((state_val_71192 === (18))){
var inst_71122 = (state_71191[(20)]);
var state_71191__$1 = state_71191;
var statearr_71260_71327 = state_71191__$1;
(statearr_71260_71327[(2)] = inst_71122);

(statearr_71260_71327[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (42))){
var inst_71076 = (state_71191[(9)]);
var state_71191__$1 = state_71191;
var statearr_71261_71328 = state_71191__$1;
(statearr_71261_71328[(2)] = inst_71076);

(statearr_71261_71328[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (37))){
var inst_71069 = (state_71191[(23)]);
var state_71191__$1 = state_71191;
var statearr_71262_71329 = state_71191__$1;
(statearr_71262_71329[(2)] = inst_71069);

(statearr_71262_71329[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (8))){
var inst_71071 = (state_71191[(16)]);
var inst_71096 = (state_71191[(2)]);
var inst_71097 = sources;
var state_71191__$1 = (function (){var statearr_71263 = state_71191;
(statearr_71263[(28)] = inst_71097);

(statearr_71263[(29)] = inst_71096);

return statearr_71263;
})();
if(cljs.core.truth_(inst_71071)){
var statearr_71264_71330 = state_71191__$1;
(statearr_71264_71330[(1)] = (9));

} else {
var statearr_71265_71331 = state_71191__$1;
(statearr_71265_71331[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (49))){
var inst_71176 = (state_71191[(13)]);
var inst_71171 = (state_71191[(26)]);
var inst_71131 = (state_71191[(24)]);
var inst_71111 = (state_71191[(11)]);
var inst_71178 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71179 = cljs.core.deref(inst_71131);
var inst_71180 = fluree.db.util.core.response_time_formatted(inst_71171);
var inst_71181 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71111);
var inst_71182 = [(200),inst_71176,inst_71179,inst_71180,inst_71181];
var inst_71183 = cljs.core.PersistentHashMap.fromArrays(inst_71178,inst_71182);
var state_71191__$1 = state_71191;
var statearr_71266_71332 = state_71191__$1;
(statearr_71266_71332[(2)] = inst_71183);

(statearr_71266_71332[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_71267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71267[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_71267[(1)] = (1));

return statearr_71267;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_71191){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71191);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71268){var ex__2730__auto__ = e71268;
var statearr_71269_71333 = state_71191;
(statearr_71269_71333[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71191[(4)]))){
var statearr_71270_71334 = state_71191;
(statearr_71270_71334[(1)] = cljs.core.first((state_71191[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71335 = state_71191;
state_71191 = G__71335;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_71191){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_71191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71271 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71271[(6)] = c__2749__auto__);

return statearr_71271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71476){
var state_val_71477 = (state_71476[(1)]);
if((state_val_71477 === (7))){
var inst_71471 = (state_71476[(2)]);
var _ = (function (){var statearr_71478 = state_71476;
(statearr_71478[(4)] = cljs.core.rest((state_71476[(4)])));

return statearr_71478;
})();
var state_71476__$1 = state_71476;
var statearr_71479_71555 = state_71476__$1;
(statearr_71479_71555[(2)] = inst_71471);

(statearr_71479_71555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (20))){
var inst_71443 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71480_71556 = state_71476__$1;
(statearr_71480_71556[(2)] = inst_71443);

(statearr_71480_71556[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (27))){
var inst_71423 = (state_71476[(7)]);
var state_71476__$1 = state_71476;
var statearr_71481_71557 = state_71476__$1;
(statearr_71481_71557[(2)] = inst_71423);

(statearr_71481_71557[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (1))){
var state_71476__$1 = state_71476;
var statearr_71482_71558 = state_71476__$1;
(statearr_71482_71558[(2)] = null);

(statearr_71482_71558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (24))){
var inst_71420 = (state_71476[(8)]);
var state_71476__$1 = state_71476;
var statearr_71483_71559 = state_71476__$1;
(statearr_71483_71559[(2)] = inst_71420);

(statearr_71483_71559[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (39))){
var inst_71377 = (state_71476[(9)]);
var inst_71410 = (state_71476[(10)]);
var inst_71388 = (state_71476[(11)]);
var inst_71454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71455 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_71388];
var inst_71456 = (new cljs.core.PersistentVector(null,2,(5),inst_71454,inst_71455,null));
var inst_71457 = cljs.core.assoc_in(inst_71377,inst_71456,inst_71410);
var state_71476__$1 = state_71476;
var statearr_71484_71560 = state_71476__$1;
(statearr_71484_71560[(2)] = inst_71457);

(statearr_71484_71560[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (4))){
var inst_71336 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71485_71561 = state_71476__$1;
(statearr_71485_71561[(2)] = inst_71336);

(statearr_71485_71561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (15))){
var inst_71410 = (state_71476[(10)]);
var inst_71375 = (state_71476[(12)]);
var inst_71413 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_71410);
var inst_71414 = (inst_71375 == null);
var state_71476__$1 = (function (){var statearr_71486 = state_71476;
(statearr_71486[(13)] = inst_71413);

return statearr_71486;
})();
if(cljs.core.truth_(inst_71414)){
var statearr_71487_71562 = state_71476__$1;
(statearr_71487_71562[(1)] = (18));

} else {
var statearr_71488_71563 = state_71476__$1;
(statearr_71488_71563[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (21))){
var inst_71413 = (state_71476[(13)]);
var state_71476__$1 = state_71476;
var statearr_71489_71564 = state_71476__$1;
(statearr_71489_71564[(2)] = inst_71413);

(statearr_71489_71564[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (31))){
var state_71476__$1 = state_71476;
var statearr_71490_71565 = state_71476__$1;
(statearr_71490_71565[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (32))){
var inst_71439 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71492_71566 = state_71476__$1;
(statearr_71492_71566[(2)] = inst_71439);

(statearr_71492_71566[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (40))){
var inst_71408 = (state_71476[(14)]);
var state_71476__$1 = state_71476;
if(cljs.core.truth_(inst_71408)){
var statearr_71493_71567 = state_71476__$1;
(statearr_71493_71567[(1)] = (42));

} else {
var statearr_71494_71568 = state_71476__$1;
(statearr_71494_71568[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (33))){
var inst_71413 = (state_71476[(13)]);
var inst_71375 = (state_71476[(12)]);
var inst_71434 = ((inst_71413 > inst_71375) ? inst_71413 : inst_71375);
var state_71476__$1 = state_71476;
var statearr_71495_71569 = state_71476__$1;
(statearr_71495_71569[(2)] = inst_71434);

(statearr_71495_71569[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (13))){
var inst_71399 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71496_71570 = state_71476__$1;
(statearr_71496_71570[(2)] = inst_71399);

(statearr_71496_71570[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (22))){
var inst_71413 = (state_71476[(13)]);
var inst_71420 = (state_71476[(8)]);
var inst_71420__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_71413);
var state_71476__$1 = (function (){var statearr_71497 = state_71476;
(statearr_71497[(8)] = inst_71420__$1);

return statearr_71497;
})();
if(inst_71420__$1){
var statearr_71498_71571 = state_71476__$1;
(statearr_71498_71571[(1)] = (24));

} else {
var statearr_71499_71572 = state_71476__$1;
(statearr_71499_71572[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (36))){
var inst_71410 = (state_71476[(10)]);
var inst_71376 = (state_71476[(15)]);
var inst_71448 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_71410,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_71449 = (inst_71376 + inst_71448);
var state_71476__$1 = state_71476;
var statearr_71500_71573 = state_71476__$1;
(statearr_71500_71573[(2)] = inst_71449);

(statearr_71500_71573[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (41))){
var inst_71387 = (state_71476[(16)]);
var inst_71446 = (state_71476[(17)]);
var inst_71452 = (state_71476[(18)]);
var inst_71466 = (state_71476[(2)]);
var inst_71374 = inst_71387;
var inst_71375 = inst_71446;
var inst_71376 = inst_71452;
var inst_71377 = inst_71466;
var state_71476__$1 = (function (){var statearr_71501 = state_71476;
(statearr_71501[(9)] = inst_71377);

(statearr_71501[(15)] = inst_71376);

(statearr_71501[(19)] = inst_71374);

(statearr_71501[(12)] = inst_71375);

return statearr_71501;
})();
var statearr_71502_71574 = state_71476__$1;
(statearr_71502_71574[(2)] = null);

(statearr_71502_71574[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (43))){
var inst_71410 = (state_71476[(10)]);
var state_71476__$1 = state_71476;
var statearr_71503_71575 = state_71476__$1;
(statearr_71503_71575[(2)] = inst_71410);

(statearr_71503_71575[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (29))){
var inst_71428 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71504_71576 = state_71476__$1;
(statearr_71504_71576[(2)] = inst_71428);

(statearr_71504_71576[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (44))){
var inst_71377 = (state_71476[(9)]);
var inst_71388 = (state_71476[(11)]);
var inst_71463 = (state_71476[(2)]);
var inst_71464 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71377,inst_71388,inst_71463);
var state_71476__$1 = state_71476;
var statearr_71505_71577 = state_71476__$1;
(statearr_71505_71577[(2)] = inst_71464);

(statearr_71505_71577[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (6))){
var inst_71389 = (state_71476[(20)]);
var inst_71374 = (state_71476[(19)]);
var inst_71385 = cljs.core.seq(inst_71374);
var inst_71386 = cljs.core.first(inst_71385);
var inst_71387 = cljs.core.next(inst_71385);
var inst_71388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71386,(0),null);
var inst_71389__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71386,(1),null);
var inst_71390 = (inst_71389__$1 == null);
var state_71476__$1 = (function (){var statearr_71506 = state_71476;
(statearr_71506[(16)] = inst_71387);

(statearr_71506[(20)] = inst_71389__$1);

(statearr_71506[(11)] = inst_71388);

return statearr_71506;
})();
if(cljs.core.truth_(inst_71390)){
var statearr_71507_71578 = state_71476__$1;
(statearr_71507_71578[(1)] = (8));

} else {
var statearr_71508_71579 = state_71476__$1;
(statearr_71508_71579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (28))){
var inst_71375 = (state_71476[(12)]);
var inst_71426 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_71375);
var state_71476__$1 = state_71476;
var statearr_71509_71580 = state_71476__$1;
(statearr_71509_71580[(2)] = inst_71426);

(statearr_71509_71580[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (25))){
var inst_71423 = (state_71476[(7)]);
var inst_71375 = (state_71476[(12)]);
var inst_71423__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_71375);
var state_71476__$1 = (function (){var statearr_71510 = state_71476;
(statearr_71510[(7)] = inst_71423__$1);

return statearr_71510;
})();
if(inst_71423__$1){
var statearr_71511_71581 = state_71476__$1;
(statearr_71511_71581[(1)] = (27));

} else {
var statearr_71512_71582 = state_71476__$1;
(statearr_71512_71582[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (34))){
var state_71476__$1 = state_71476;
var statearr_71513_71583 = state_71476__$1;
(statearr_71513_71583[(2)] = null);

(statearr_71513_71583[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (17))){
var inst_71407 = (state_71476[(21)]);
var inst_71446 = (state_71476[(2)]);
var state_71476__$1 = (function (){var statearr_71514 = state_71476;
(statearr_71514[(17)] = inst_71446);

return statearr_71514;
})();
if(cljs.core.truth_(inst_71407)){
var statearr_71515_71584 = state_71476__$1;
(statearr_71515_71584[(1)] = (36));

} else {
var statearr_71516_71585 = state_71476__$1;
(statearr_71516_71585[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (3))){
var inst_71474 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71476__$1,inst_71474);
} else {
if((state_val_71477 === (12))){
var inst_71377 = (state_71476[(9)]);
var state_71476__$1 = state_71476;
var statearr_71517_71586 = state_71476__$1;
(statearr_71517_71586[(2)] = inst_71377);

(statearr_71517_71586[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (2))){
var inst_71346 = (state_71476[(22)]);
var inst_71351 = (state_71476[(23)]);
var inst_71350 = (state_71476[(24)]);
var _ = (function (){var statearr_71518 = state_71476;
(statearr_71518[(4)] = cljs.core.cons((5),(state_71476[(4)])));

return statearr_71518;
})();
var inst_71342 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_71343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71344 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_71345 = (new cljs.core.PersistentVector(null,2,(5),inst_71343,inst_71344,null));
var inst_71346__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_71345);
var inst_71347 = (function (){var global_block = inst_71342;
var global_meta_QMARK_ = inst_71346__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_71348 = cljs.core.PersistentHashMap.EMPTY;
var inst_71349 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_71350__$1 = cljs.core.reduce_kv(inst_71347,inst_71348,inst_71349);
var inst_71351__$1 = fluree.db.util.core.current_time_millis();
var inst_71353 = (function (){var global_block = inst_71342;
var global_meta_QMARK_ = inst_71346__$1;
var queries = inst_71350__$1;
var start_time = inst_71351__$1;
return (function (p__71352){
var vec__71519 = p__71352;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71519,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71519,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_71354 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_71353,inst_71350__$1);
var inst_71368 = cljs.core.seq(inst_71354);
var inst_71369 = cljs.core.first(inst_71368);
var inst_71370 = cljs.core.next(inst_71368);
var inst_71371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71369,(0),null);
var inst_71372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71369,(1),null);
var inst_71373 = cljs.core.PersistentHashMap.EMPTY;
var inst_71374 = inst_71354;
var inst_71375 = null;
var inst_71376 = (0);
var inst_71377 = inst_71373;
var state_71476__$1 = (function (){var statearr_71522 = state_71476;
(statearr_71522[(25)] = inst_71370);

(statearr_71522[(9)] = inst_71377);

(statearr_71522[(26)] = inst_71371);

(statearr_71522[(22)] = inst_71346__$1);

(statearr_71522[(23)] = inst_71351__$1);

(statearr_71522[(15)] = inst_71376);

(statearr_71522[(27)] = inst_71372);

(statearr_71522[(19)] = inst_71374);

(statearr_71522[(12)] = inst_71375);

(statearr_71522[(24)] = inst_71350__$1);

return statearr_71522;
})();
var statearr_71523_71587 = state_71476__$1;
(statearr_71523_71587[(2)] = null);

(statearr_71523_71587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (23))){
var inst_71441 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71524_71588 = state_71476__$1;
(statearr_71524_71588[(2)] = inst_71441);

(statearr_71524_71588[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (35))){
var inst_71437 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71525_71589 = state_71476__$1;
(statearr_71525_71589[(2)] = inst_71437);

(statearr_71525_71589[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (19))){
var inst_71413 = (state_71476[(13)]);
var inst_71375 = (state_71476[(12)]);
var inst_71417 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71375,inst_71413);
var state_71476__$1 = state_71476;
if(inst_71417){
var statearr_71526_71590 = state_71476__$1;
(statearr_71526_71590[(1)] = (21));

} else {
var statearr_71527_71591 = state_71476__$1;
(statearr_71527_71591[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (11))){
var inst_71377 = (state_71476[(9)]);
var inst_71351 = (state_71476[(23)]);
var inst_71376 = (state_71476[(15)]);
var inst_71375 = (state_71476[(12)]);
var inst_71393 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71394 = fluree.db.util.core.response_time_formatted(inst_71351);
var inst_71395 = [inst_71377,inst_71376,inst_71375,inst_71394];
var inst_71396 = cljs.core.PersistentHashMap.fromArrays(inst_71393,inst_71395);
var state_71476__$1 = state_71476;
var statearr_71529_71592 = state_71476__$1;
(statearr_71529_71592[(2)] = inst_71396);

(statearr_71529_71592[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (9))){
var inst_71389 = (state_71476[(20)]);
var inst_71388 = (state_71476[(11)]);
var inst_71350 = (state_71476[(24)]);
var inst_71402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71403 = [inst_71388,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_71404 = (new cljs.core.PersistentVector(null,2,(5),inst_71402,inst_71403,null));
var inst_71405 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71350,inst_71404);
var inst_71406 = cljs.core.__destructure_map(inst_71405);
var inst_71407 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71406,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_71408 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71406,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_71476__$1 = (function (){var statearr_71530 = state_71476;
(statearr_71530[(21)] = inst_71407);

(statearr_71530[(14)] = inst_71408);

return statearr_71530;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71476__$1,(14),inst_71389);
} else {
if((state_val_71477 === (5))){
var _ = (function (){var statearr_71531 = state_71476;
(statearr_71531[(4)] = cljs.core.rest((state_71476[(4)])));

return statearr_71531;
})();
var state_71476__$1 = state_71476;
var ex71528 = (state_71476__$1[(2)]);
var statearr_71532_71593 = state_71476__$1;
(statearr_71532_71593[(5)] = ex71528);


var statearr_71533_71594 = state_71476__$1;
(statearr_71533_71594[(1)] = (4));

(statearr_71533_71594[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (14))){
var inst_71410 = (state_71476[(10)]);
var inst_71407 = (state_71476[(21)]);
var inst_71410__$1 = (state_71476[(2)]);
var inst_71411 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_71410__$1);
var state_71476__$1 = (function (){var statearr_71534 = state_71476;
(statearr_71534[(10)] = inst_71410__$1);

(statearr_71534[(28)] = inst_71411);

return statearr_71534;
})();
if(cljs.core.truth_(inst_71407)){
var statearr_71535_71595 = state_71476__$1;
(statearr_71535_71595[(1)] = (15));

} else {
var statearr_71536_71596 = state_71476__$1;
(statearr_71536_71596[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (26))){
var inst_71430 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
if(cljs.core.truth_(inst_71430)){
var statearr_71537_71597 = state_71476__$1;
(statearr_71537_71597[(1)] = (30));

} else {
var statearr_71538_71598 = state_71476__$1;
(statearr_71538_71598[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (16))){
var state_71476__$1 = state_71476;
var statearr_71539_71599 = state_71476__$1;
(statearr_71539_71599[(2)] = null);

(statearr_71539_71599[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (38))){
var inst_71411 = (state_71476[(28)]);
var inst_71452 = (state_71476[(2)]);
var state_71476__$1 = (function (){var statearr_71540 = state_71476;
(statearr_71540[(18)] = inst_71452);

return statearr_71540;
})();
if(cljs.core.truth_(inst_71411)){
var statearr_71541_71600 = state_71476__$1;
(statearr_71541_71600[(1)] = (39));

} else {
var statearr_71542_71601 = state_71476__$1;
(statearr_71542_71601[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (30))){
var state_71476__$1 = state_71476;
var statearr_71543_71602 = state_71476__$1;
(statearr_71543_71602[(2)] = (207));

(statearr_71543_71602[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (10))){
var inst_71469 = (state_71476[(2)]);
var state_71476__$1 = state_71476;
var statearr_71544_71603 = state_71476__$1;
(statearr_71544_71603[(2)] = inst_71469);

(statearr_71544_71603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (18))){
var inst_71413 = (state_71476[(13)]);
var state_71476__$1 = state_71476;
var statearr_71545_71604 = state_71476__$1;
(statearr_71545_71604[(2)] = inst_71413);

(statearr_71545_71604[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (42))){
var inst_71410 = (state_71476[(10)]);
var inst_71460 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_71410);
var state_71476__$1 = state_71476;
var statearr_71546_71605 = state_71476__$1;
(statearr_71546_71605[(2)] = inst_71460);

(statearr_71546_71605[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (37))){
var state_71476__$1 = state_71476;
var statearr_71547_71606 = state_71476__$1;
(statearr_71547_71606[(2)] = null);

(statearr_71547_71606[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71477 === (8))){
var inst_71346 = (state_71476[(22)]);
var state_71476__$1 = state_71476;
if(cljs.core.truth_(inst_71346)){
var statearr_71548_71607 = state_71476__$1;
(statearr_71548_71607[(1)] = (11));

} else {
var statearr_71549_71608 = state_71476__$1;
(statearr_71549_71608[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_71550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71550[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_71550[(1)] = (1));

return statearr_71550;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_71476){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71476);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71551){var ex__2730__auto__ = e71551;
var statearr_71552_71609 = state_71476;
(statearr_71552_71609[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71476[(4)]))){
var statearr_71553_71610 = state_71476;
(statearr_71553_71610[(1)] = cljs.core.first((state_71476[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71611 = state_71476;
state_71476 = G__71611;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_71476){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_71476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71554 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71554[(6)] = c__2749__auto__);

return statearr_71554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__71612 = query_type;
var G__71612__$1 = (((G__71612 instanceof cljs.core.Keyword))?G__71612.fqn:null);
switch (G__71612__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71612__$1)].join('')));

}
});
