// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__75833 = arguments.length;
switch (G__75833) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___75872 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75854){
var state_val_75855 = (state_75854[(1)]);
if((state_val_75855 === (1))){
var state_75854__$1 = state_75854;
var statearr_75856_75873 = state_75854__$1;
(statearr_75856_75873[(2)] = null);

(statearr_75856_75873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75855 === (2))){
var _ = (function (){var statearr_75857 = state_75854;
(statearr_75857[(4)] = cljs.core.cons((5),(state_75854[(4)])));

return statearr_75857;
})();
var inst_75840 = fluree.db.session.db(conn,ledger,null);
var state_75854__$1 = state_75854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75854__$1,(7),inst_75840);
} else {
if((state_val_75855 === (3))){
var inst_75850 = (state_75854[(2)]);
var inst_75851 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75850);
var inst_75852 = cljs.core.async.close_BANG_(pc);
var state_75854__$1 = (function (){var statearr_75859 = state_75854;
(statearr_75859[(7)] = inst_75851);

return statearr_75859;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_75854__$1,inst_75852);
} else {
if((state_val_75855 === (4))){
var inst_75834 = (state_75854[(2)]);
var state_75854__$1 = state_75854;
var statearr_75860_75874 = state_75854__$1;
(statearr_75860_75874[(2)] = inst_75834);

(statearr_75860_75874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75855 === (5))){
var _ = (function (){var statearr_75861 = state_75854;
(statearr_75861[(4)] = cljs.core.rest((state_75854[(4)])));

return statearr_75861;
})();
var state_75854__$1 = state_75854;
var ex75858 = (state_75854__$1[(2)]);
var statearr_75862_75875 = state_75854__$1;
(statearr_75862_75875[(5)] = ex75858);


var statearr_75863_75876 = state_75854__$1;
(statearr_75863_75876[(1)] = (4));

(statearr_75863_75876[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75855 === (6))){
var inst_75846 = (state_75854[(2)]);
var inst_75847 = fluree.db.util.async.throw_err(inst_75846);
var _ = (function (){var statearr_75864 = state_75854;
(statearr_75864[(4)] = cljs.core.rest((state_75854[(4)])));

return statearr_75864;
})();
var state_75854__$1 = state_75854;
var statearr_75865_75877 = state_75854__$1;
(statearr_75865_75877[(2)] = inst_75847);

(statearr_75865_75877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75855 === (7))){
var inst_75842 = (state_75854[(2)]);
var inst_75843 = fluree.db.util.async.throw_err(inst_75842);
var inst_75844 = fluree.db.time_travel.as_of_block(inst_75843,block);
var state_75854__$1 = state_75854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75854__$1,(6),inst_75844);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_75866 = [null,null,null,null,null,null,null,null];
(statearr_75866[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_75866[(1)] = (1));

return statearr_75866;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_75854){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75854);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75867){var ex__2730__auto__ = e75867;
var statearr_75868_75878 = state_75854;
(statearr_75868_75878[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75854[(4)]))){
var statearr_75869_75879 = state_75854;
(statearr_75869_75879[(1)] = cljs.core.first((state_75854[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75880 = state_75854;
state_75854 = G__75880;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_75854){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_75854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75870 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75870[(6)] = c__2749__auto___75872);

return statearr_75870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75921){
var state_val_75922 = (state_75921[(1)]);
if((state_val_75922 === (7))){
var inst_75890 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_75921__$1 = state_75921;
if(inst_75890){
var statearr_75923_75954 = state_75921__$1;
(statearr_75923_75954[(1)] = (9));

} else {
var statearr_75924_75955 = state_75921__$1;
(statearr_75924_75955[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (1))){
var state_75921__$1 = state_75921;
var statearr_75925_75956 = state_75921__$1;
(statearr_75925_75956[(2)] = null);

(statearr_75925_75956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (4))){
var inst_75881 = (state_75921[(2)]);
var state_75921__$1 = state_75921;
var statearr_75926_75957 = state_75921__$1;
(statearr_75926_75957[(2)] = inst_75881);

(statearr_75926_75957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (15))){
var inst_75898 = (state_75921[(7)]);
var inst_75897 = (state_75921[(2)]);
var inst_75898__$1 = fluree.db.util.async.throw_err(inst_75897);
var state_75921__$1 = (function (){var statearr_75927 = state_75921;
(statearr_75927[(7)] = inst_75898__$1);

return statearr_75927;
})();
if(cljs.core.truth_(inst_75898__$1)){
var statearr_75928_75958 = state_75921__$1;
(statearr_75928_75958[(1)] = (16));

} else {
var statearr_75929_75959 = state_75921__$1;
(statearr_75929_75959[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (13))){
var state_75921__$1 = state_75921;
var statearr_75930_75960 = state_75921__$1;
(statearr_75930_75960[(2)] = null);

(statearr_75930_75960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (6))){
var state_75921__$1 = state_75921;
var statearr_75931_75961 = state_75921__$1;
(statearr_75931_75961[(2)] = db);

(statearr_75931_75961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (17))){
var inst_75902 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_75903 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75904 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_75905 = cljs.core.PersistentHashMap.fromArrays(inst_75903,inst_75904);
var inst_75906 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75902,inst_75905);
var inst_75907 = (function(){throw inst_75906})();
var state_75921__$1 = state_75921;
var statearr_75932_75962 = state_75921__$1;
(statearr_75932_75962[(2)] = inst_75907);

(statearr_75932_75962[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (3))){
var inst_75919 = (state_75921[(2)]);
var state_75921__$1 = state_75921;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75921__$1,inst_75919);
} else {
if((state_val_75922 === (12))){
var inst_75895 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_75921__$1 = state_75921;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75921__$1,(15),inst_75895);
} else {
if((state_val_75922 === (2))){
var _ = (function (){var statearr_75933 = state_75921;
(statearr_75933[(4)] = cljs.core.cons((5),(state_75921[(4)])));

return statearr_75933;
})();
var inst_75887 = cljs.core.not(auth);
var state_75921__$1 = state_75921;
if(inst_75887){
var statearr_75934_75963 = state_75921__$1;
(statearr_75934_75963[(1)] = (6));

} else {
var statearr_75935_75964 = state_75921__$1;
(statearr_75935_75964[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (11))){
var inst_75914 = (state_75921[(2)]);
var state_75921__$1 = state_75921;
var statearr_75937_75965 = state_75921__$1;
(statearr_75937_75965[(2)] = inst_75914);

(statearr_75937_75965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (9))){
var inst_75892 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_75921__$1 = state_75921;
var statearr_75938_75966 = state_75921__$1;
(statearr_75938_75966[(2)] = inst_75892);

(statearr_75938_75966[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (5))){
var _ = (function (){var statearr_75939 = state_75921;
(statearr_75939[(4)] = cljs.core.rest((state_75921[(4)])));

return statearr_75939;
})();
var state_75921__$1 = state_75921;
var ex75936 = (state_75921__$1[(2)]);
var statearr_75940_75967 = state_75921__$1;
(statearr_75940_75967[(5)] = ex75936);


if((ex75936 instanceof Error)){
var statearr_75941_75968 = state_75921__$1;
(statearr_75941_75968[(1)] = (4));

(statearr_75941_75968[(5)] = null);

} else {
throw ex75936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (14))){
var inst_75912 = (state_75921[(2)]);
var state_75921__$1 = state_75921;
var statearr_75942_75969 = state_75921__$1;
(statearr_75942_75969[(2)] = inst_75912);

(statearr_75942_75969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (16))){
var inst_75898 = (state_75921[(7)]);
var inst_75900 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_75898);
var state_75921__$1 = state_75921;
var statearr_75943_75970 = state_75921__$1;
(statearr_75943_75970[(2)] = inst_75900);

(statearr_75943_75970[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (10))){
var state_75921__$1 = state_75921;
var statearr_75944_75971 = state_75921__$1;
(statearr_75944_75971[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (18))){
var inst_75909 = (state_75921[(2)]);
var state_75921__$1 = state_75921;
var statearr_75946_75972 = state_75921__$1;
(statearr_75946_75972[(2)] = inst_75909);

(statearr_75946_75972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75922 === (8))){
var inst_75916 = (state_75921[(2)]);
var _ = (function (){var statearr_75947 = state_75921;
(statearr_75947[(4)] = cljs.core.rest((state_75921[(4)])));

return statearr_75947;
})();
var state_75921__$1 = state_75921;
var statearr_75948_75973 = state_75921__$1;
(statearr_75948_75973[(2)] = inst_75916);

(statearr_75948_75973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_75949 = [null,null,null,null,null,null,null,null];
(statearr_75949[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_75949[(1)] = (1));

return statearr_75949;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_75921){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75921);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75950){var ex__2730__auto__ = e75950;
var statearr_75951_75974 = state_75921;
(statearr_75951_75974[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75921[(4)]))){
var statearr_75952_75975 = state_75921;
(statearr_75952_75975[(1)] = cljs.core.first((state_75921[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75976 = state_75921;
state_75921 = G__75976;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_75921){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_75921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75953 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75953[(6)] = c__2749__auto__);

return statearr_75953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76048){
var state_val_76049 = (state_76048[(1)]);
if((state_val_76049 === (7))){
var inst_75986 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_76048__$1 = state_76048;
if(inst_75986){
var statearr_76050_76104 = state_76048__$1;
(statearr_76050_76104[(1)] = (9));

} else {
var statearr_76051_76105 = state_76048__$1;
(statearr_76051_76105[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (20))){
var inst_76010 = (state_76048[(7)]);
var state_76048__$1 = state_76048;
if(cljs.core.truth_(inst_76010)){
var statearr_76052_76106 = state_76048__$1;
(statearr_76052_76106[(1)] = (22));

} else {
var statearr_76053_76107 = state_76048__$1;
(statearr_76053_76107[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (27))){
var state_76048__$1 = state_76048;
var statearr_76054_76108 = state_76048__$1;
(statearr_76054_76108[(2)] = null);

(statearr_76054_76108[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (1))){
var state_76048__$1 = state_76048;
var statearr_76055_76109 = state_76048__$1;
(statearr_76055_76109[(2)] = null);

(statearr_76055_76109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (24))){
var inst_76024 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
var statearr_76056_76110 = state_76048__$1;
(statearr_76056_76110[(2)] = inst_76024);

(statearr_76056_76110[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (4))){
var inst_75977 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
var statearr_76057_76111 = state_76048__$1;
(statearr_76057_76111[(2)] = inst_75977);

(statearr_76057_76111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (15))){
var inst_75993 = (state_76048[(8)]);
var inst_75992 = (state_76048[(2)]);
var inst_75993__$1 = fluree.db.util.async.throw_err(inst_75992);
var state_76048__$1 = (function (){var statearr_76058 = state_76048;
(statearr_76058[(8)] = inst_75993__$1);

return statearr_76058;
})();
if(cljs.core.truth_(inst_75993__$1)){
var statearr_76059_76112 = state_76048__$1;
(statearr_76059_76112[(1)] = (16));

} else {
var statearr_76060_76113 = state_76048__$1;
(statearr_76060_76113[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (21))){
var inst_76026 = (state_76048[(9)]);
var inst_76026__$1 = (state_76048[(2)]);
var state_76048__$1 = (function (){var statearr_76061 = state_76048;
(statearr_76061[(9)] = inst_76026__$1);

return statearr_76061;
})();
if(cljs.core.truth_(inst_76026__$1)){
var statearr_76062_76114 = state_76048__$1;
(statearr_76062_76114[(1)] = (29));

} else {
var statearr_76063_76115 = state_76048__$1;
(statearr_76063_76115[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (31))){
var inst_76026 = (state_76048[(9)]);
var inst_76034 = (state_76048[(2)]);
var state_76048__$1 = (function (){var statearr_76064 = state_76048;
(statearr_76064[(10)] = inst_76034);

return statearr_76064;
})();
if(cljs.core.truth_(inst_76026)){
var statearr_76065_76116 = state_76048__$1;
(statearr_76065_76116[(1)] = (33));

} else {
var statearr_76066_76117 = state_76048__$1;
(statearr_76066_76117[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (32))){
var inst_76030 = (state_76048[(2)]);
var inst_76031 = fluree.db.util.async.throw_err(inst_76030);
var state_76048__$1 = state_76048;
var statearr_76067_76118 = state_76048__$1;
(statearr_76067_76118[(2)] = inst_76031);

(statearr_76067_76118[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (33))){
var inst_76026 = (state_76048[(9)]);
var inst_76036 = fluree.db.permissions.permission_map(db,inst_76026,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76048__$1 = state_76048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76048__$1,(36),inst_76036);
} else {
if((state_val_76049 === (13))){
var state_76048__$1 = state_76048;
var statearr_76068_76119 = state_76048__$1;
(statearr_76068_76119[(2)] = null);

(statearr_76068_76119[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (22))){
var inst_76010 = (state_76048[(7)]);
var inst_76014 = fluree.db.auth.roles(db,inst_76010);
var state_76048__$1 = state_76048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76048__$1,(25),inst_76014);
} else {
if((state_val_76049 === (36))){
var inst_76038 = (state_76048[(2)]);
var inst_76039 = fluree.db.util.async.throw_err(inst_76038);
var state_76048__$1 = state_76048;
var statearr_76069_76120 = state_76048__$1;
(statearr_76069_76120[(2)] = inst_76039);

(statearr_76069_76120[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (29))){
var inst_76010 = (state_76048[(7)]);
var inst_76026 = (state_76048[(9)]);
var inst_76028 = fluree.db.dbfunctions.ctx.build(db,inst_76010,inst_76026);
var state_76048__$1 = state_76048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76048__$1,(32),inst_76028);
} else {
if((state_val_76049 === (6))){
var state_76048__$1 = state_76048;
var statearr_76070_76121 = state_76048__$1;
(statearr_76070_76121[(2)] = null);

(statearr_76070_76121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (28))){
var inst_76022 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
var statearr_76071_76122 = state_76048__$1;
(statearr_76071_76122[(2)] = inst_76022);

(statearr_76071_76122[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (25))){
var inst_76016 = (state_76048[(2)]);
var inst_76017 = fluree.db.util.async.throw_err(inst_76016);
var state_76048__$1 = state_76048;
var statearr_76072_76123 = state_76048__$1;
(statearr_76072_76123[(2)] = inst_76017);

(statearr_76072_76123[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (34))){
var state_76048__$1 = state_76048;
var statearr_76073_76124 = state_76048__$1;
(statearr_76073_76124[(2)] = null);

(statearr_76073_76124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (17))){
var inst_75996 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_75997 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75998 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_75999 = cljs.core.PersistentHashMap.fromArrays(inst_75997,inst_75998);
var inst_76000 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75996,inst_75999);
var inst_76001 = (function(){throw inst_76000})();
var state_76048__$1 = state_76048;
var statearr_76074_76125 = state_76048__$1;
(statearr_76074_76125[(2)] = inst_76001);

(statearr_76074_76125[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (3))){
var inst_76046 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76048__$1,inst_76046);
} else {
if((state_val_76049 === (12))){
var inst_75990 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_76048__$1 = state_76048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76048__$1,(15),inst_75990);
} else {
if((state_val_76049 === (2))){
var _ = (function (){var statearr_76075 = state_76048;
(statearr_76075[(4)] = cljs.core.cons((5),(state_76048[(4)])));

return statearr_76075;
})();
var inst_75983 = (auth == null);
var state_76048__$1 = state_76048;
if(cljs.core.truth_(inst_75983)){
var statearr_76076_76126 = state_76048__$1;
(statearr_76076_76126[(1)] = (6));

} else {
var statearr_76077_76127 = state_76048__$1;
(statearr_76077_76127[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (23))){
var state_76048__$1 = state_76048;
var statearr_76078_76128 = state_76048__$1;
(statearr_76078_76128[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (35))){
var inst_76010 = (state_76048[(7)]);
var inst_76034 = (state_76048[(10)]);
var inst_76026 = (state_76048[(9)]);
var inst_76042 = (state_76048[(2)]);
var inst_76043 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_76010,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_76026,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_76042,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_76034], 0));
var _ = (function (){var statearr_76080 = state_76048;
(statearr_76080[(4)] = cljs.core.rest((state_76048[(4)])));

return statearr_76080;
})();
var state_76048__$1 = state_76048;
var statearr_76081_76129 = state_76048__$1;
(statearr_76081_76129[(2)] = inst_76043);

(statearr_76081_76129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (19))){
var state_76048__$1 = state_76048;
var statearr_76082_76130 = state_76048__$1;
(statearr_76082_76130[(2)] = roles);

(statearr_76082_76130[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (11))){
var inst_76008 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
var statearr_76084_76131 = state_76048__$1;
(statearr_76084_76131[(2)] = inst_76008);

(statearr_76084_76131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (9))){
var state_76048__$1 = state_76048;
var statearr_76085_76132 = state_76048__$1;
(statearr_76085_76132[(2)] = (0));

(statearr_76085_76132[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (5))){
var _ = (function (){var statearr_76086 = state_76048;
(statearr_76086[(4)] = cljs.core.rest((state_76048[(4)])));

return statearr_76086;
})();
var state_76048__$1 = state_76048;
var ex76083 = (state_76048__$1[(2)]);
var statearr_76087_76133 = state_76048__$1;
(statearr_76087_76133[(5)] = ex76083);


if((ex76083 instanceof Error)){
var statearr_76088_76134 = state_76048__$1;
(statearr_76088_76134[(1)] = (4));

(statearr_76088_76134[(5)] = null);

} else {
throw ex76083;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (14))){
var inst_76006 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
var statearr_76089_76135 = state_76048__$1;
(statearr_76089_76135[(2)] = inst_76006);

(statearr_76089_76135[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (26))){
var state_76048__$1 = state_76048;
var statearr_76090_76136 = state_76048__$1;
(statearr_76090_76136[(2)] = null);

(statearr_76090_76136[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (16))){
var inst_75993 = (state_76048[(8)]);
var state_76048__$1 = state_76048;
var statearr_76091_76137 = state_76048__$1;
(statearr_76091_76137[(2)] = inst_75993);

(statearr_76091_76137[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (30))){
var state_76048__$1 = state_76048;
var statearr_76092_76138 = state_76048__$1;
(statearr_76092_76138[(2)] = null);

(statearr_76092_76138[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (10))){
var state_76048__$1 = state_76048;
if(cljs.core.truth_(auth)){
var statearr_76093_76139 = state_76048__$1;
(statearr_76093_76139[(1)] = (12));

} else {
var statearr_76094_76140 = state_76048__$1;
(statearr_76094_76140[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (18))){
var inst_76003 = (state_76048[(2)]);
var state_76048__$1 = state_76048;
var statearr_76095_76141 = state_76048__$1;
(statearr_76095_76141[(2)] = inst_76003);

(statearr_76095_76141[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76049 === (8))){
var inst_76010 = (state_76048[(2)]);
var state_76048__$1 = (function (){var statearr_76096 = state_76048;
(statearr_76096[(7)] = inst_76010);

return statearr_76096;
})();
if(cljs.core.truth_(roles)){
var statearr_76097_76142 = state_76048__$1;
(statearr_76097_76142[(1)] = (19));

} else {
var statearr_76098_76143 = state_76048__$1;
(statearr_76098_76143[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_76099 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_76099[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_76099[(1)] = (1));

return statearr_76099;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_76048){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76048);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76100){var ex__2730__auto__ = e76100;
var statearr_76101_76144 = state_76048;
(statearr_76101_76144[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76048[(4)]))){
var statearr_76102_76145 = state_76048;
(statearr_76102_76145[(1)] = cljs.core.first((state_76048[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76146 = state_76048;
state_76048 = G__76146;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_76048){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_76048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76103 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76103[(6)] = c__2749__auto__);

return statearr_76103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__76147 = db;
var map__76147__$1 = cljs.core.__destructure_map(map__76147);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76147__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76147__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76147__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76154){
var state_val_76155 = (state_76154[(1)]);
if((state_val_76155 === (1))){
var inst_76148 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_76149 = fluree.db.session.db(conn,inst_76148,null);
var state_76154__$1 = state_76154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76154__$1,(2),inst_76149);
} else {
if((state_val_76155 === (2))){
var inst_76151 = (state_76154[(2)]);
var inst_76152 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_76151);
var state_76154__$1 = state_76154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76154__$1,inst_76152);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_76156 = [null,null,null,null,null,null,null];
(statearr_76156[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_76156[(1)] = (1));

return statearr_76156;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_76154){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76154);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76157){var ex__2730__auto__ = e76157;
var statearr_76158_76185 = state_76154;
(statearr_76158_76185[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76154[(4)]))){
var statearr_76159_76186 = state_76154;
(statearr_76159_76186[(1)] = cljs.core.first((state_76154[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76187 = state_76154;
state_76154 = G__76187;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_76154){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_76154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76160 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76160[(6)] = c__2749__auto__);

return statearr_76160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76173){
var state_val_76174 = (state_76173[(1)]);
if((state_val_76174 === (1))){
var inst_76161 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_76162 = fluree.db.session.db(conn,inst_76161,null);
var state_76173__$1 = state_76173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76173__$1,(2),inst_76162);
} else {
if((state_val_76174 === (2))){
var inst_76164 = (state_76173[(7)]);
var inst_76164__$1 = (state_76173[(2)]);
var inst_76165 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_76164__$1);
var inst_76166 = newer_block_QMARK_(inst_76165);
var state_76173__$1 = (function (){var statearr_76175 = state_76173;
(statearr_76175[(7)] = inst_76164__$1);

return statearr_76175;
})();
if(inst_76166){
var statearr_76176_76188 = state_76173__$1;
(statearr_76176_76188[(1)] = (3));

} else {
var statearr_76177_76189 = state_76173__$1;
(statearr_76177_76189[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76174 === (3))){
var inst_76164 = (state_76173[(7)]);
var inst_76168 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_76164);
var state_76173__$1 = state_76173;
var statearr_76178_76190 = state_76173__$1;
(statearr_76178_76190[(2)] = inst_76168);

(statearr_76178_76190[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76174 === (4))){
var state_76173__$1 = state_76173;
var statearr_76179_76191 = state_76173__$1;
(statearr_76179_76191[(2)] = null);

(statearr_76179_76191[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76174 === (5))){
var inst_76171 = (state_76173[(2)]);
var state_76173__$1 = state_76173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76173__$1,inst_76171);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_76180 = [null,null,null,null,null,null,null,null];
(statearr_76180[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_76180[(1)] = (1));

return statearr_76180;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_76173){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76173);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76181){var ex__2730__auto__ = e76181;
var statearr_76182_76192 = state_76173;
(statearr_76182_76192[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76173[(4)]))){
var statearr_76183_76193 = state_76173;
(statearr_76183_76193[(1)] = cljs.core.first((state_76173[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76194 = state_76173;
state_76173 = G__76194;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_76173){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_76173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76184 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76184[(6)] = c__2749__auto__);

return statearr_76184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__76195 = db;
var map__76195__$1 = cljs.core.__destructure_map(map__76195);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76195__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76195__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76195__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___76271 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76245){
var state_val_76246 = (state_76245[(1)]);
if((state_val_76246 === (7))){
var inst_76211 = (state_76245[(7)]);
var inst_76222 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76211,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_76245__$1 = state_76245;
if(inst_76222){
var statearr_76247_76272 = state_76245__$1;
(statearr_76247_76272[(1)] = (9));

} else {
var statearr_76248_76273 = state_76245__$1;
(statearr_76248_76273[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (1))){
var inst_76196 = (state_76245[(8)]);
var inst_76204 = (state_76245[(9)]);
var inst_76196__$1 = cljs.core.async.timeout(timeout);
var inst_76204__$1 = res_port;
var inst_76205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76206 = [inst_76196__$1,inst_76204__$1];
var inst_76207 = (new cljs.core.PersistentVector(null,2,(5),inst_76205,inst_76206,null));
var state_76245__$1 = (function (){var statearr_76249 = state_76245;
(statearr_76249[(8)] = inst_76196__$1);

(statearr_76249[(9)] = inst_76204__$1);

return statearr_76249;
})();
return cljs.core.async.ioc_alts_BANG_(state_76245__$1,(2),inst_76207);
} else {
if((state_val_76246 === (4))){
var inst_76211 = (state_76245[(7)]);
var inst_76204 = (state_76245[(9)]);
var inst_76215 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76211,inst_76204);
var state_76245__$1 = state_76245;
if(inst_76215){
var statearr_76250_76274 = state_76245__$1;
(statearr_76250_76274[(1)] = (6));

} else {
var statearr_76251_76275 = state_76245__$1;
(statearr_76251_76275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (13))){
var inst_76230 = (state_76245[(10)]);
var inst_76241 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_76230);
var state_76245__$1 = state_76245;
var statearr_76252_76276 = state_76245__$1;
(statearr_76252_76276[(2)] = inst_76241);

(statearr_76252_76276[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (6))){
var inst_76209 = (state_76245[(11)]);
var inst_76220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76209,(0),null);
var state_76245__$1 = state_76245;
var statearr_76253_76277 = state_76245__$1;
(statearr_76253_76277[(2)] = inst_76220);

(statearr_76253_76277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (3))){
var state_76245__$1 = state_76245;
var statearr_76254_76278 = state_76245__$1;
(statearr_76254_76278[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_76254_76278[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (12))){
var inst_76234 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_76235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76236 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_76237 = cljs.core.PersistentHashMap.fromArrays(inst_76235,inst_76236);
var inst_76238 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76234,inst_76237);
var inst_76239 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_76238);
var state_76245__$1 = state_76245;
var statearr_76255_76279 = state_76245__$1;
(statearr_76255_76279[(2)] = inst_76239);

(statearr_76255_76279[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (2))){
var inst_76196 = (state_76245[(8)]);
var inst_76211 = (state_76245[(7)]);
var inst_76209 = (state_76245[(11)]);
var inst_76209__$1 = (state_76245[(2)]);
var inst_76210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76209__$1,(0),null);
var inst_76211__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76209__$1,(1),null);
var inst_76212 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76211__$1,inst_76196);
var state_76245__$1 = (function (){var statearr_76256 = state_76245;
(statearr_76256[(7)] = inst_76211__$1);

(statearr_76256[(11)] = inst_76209__$1);

(statearr_76256[(12)] = inst_76210);

return statearr_76256;
})();
if(inst_76212){
var statearr_76257_76280 = state_76245__$1;
(statearr_76257_76280[(1)] = (3));

} else {
var statearr_76258_76281 = state_76245__$1;
(statearr_76258_76281[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (11))){
var inst_76226 = (state_76245[(2)]);
var state_76245__$1 = state_76245;
var statearr_76259_76282 = state_76245__$1;
(statearr_76259_76282[(2)] = inst_76226);

(statearr_76259_76282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (9))){
var inst_76210 = (state_76245[(12)]);
var state_76245__$1 = state_76245;
var statearr_76260_76283 = state_76245__$1;
(statearr_76260_76283[(2)] = inst_76210);

(statearr_76260_76283[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (5))){
var inst_76230 = (state_76245[(10)]);
var inst_76230__$1 = (state_76245[(2)]);
var inst_76231 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_76232 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_76230__$1);
var state_76245__$1 = (function (){var statearr_76261 = state_76245;
(statearr_76261[(13)] = inst_76231);

(statearr_76261[(10)] = inst_76230__$1);

return statearr_76261;
})();
if(inst_76232){
var statearr_76262_76284 = state_76245__$1;
(statearr_76262_76284[(1)] = (12));

} else {
var statearr_76263_76285 = state_76245__$1;
(statearr_76263_76285[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (14))){
var inst_76243 = (state_76245[(2)]);
var state_76245__$1 = state_76245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76245__$1,inst_76243);
} else {
if((state_val_76246 === (10))){
var state_76245__$1 = state_76245;
var statearr_76264_76286 = state_76245__$1;
(statearr_76264_76286[(2)] = null);

(statearr_76264_76286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76246 === (8))){
var inst_76228 = (state_76245[(2)]);
var state_76245__$1 = state_76245;
var statearr_76265_76287 = state_76245__$1;
(statearr_76265_76287[(2)] = inst_76228);

(statearr_76265_76287[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_76266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76266[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_76266[(1)] = (1));

return statearr_76266;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_76245){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76245);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76267){var ex__2730__auto__ = e76267;
var statearr_76268_76288 = state_76245;
(statearr_76268_76288[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76245[(4)]))){
var statearr_76269_76289 = state_76245;
(statearr_76269_76289[(1)] = cljs.core.first((state_76245[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76290 = state_76245;
state_76245 = G__76290;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_76245){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_76245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76270 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76270[(6)] = c__2749__auto___76271);

return statearr_76270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__76292 = arguments.length;
switch (G__76292) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__76293){
var map__76294 = p__76293;
var map__76294__$1 = cljs.core.__destructure_map(map__76294);
var opts = map__76294__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76294__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76294__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76294__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76294__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76294__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___76383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76345){
var state_val_76346 = (state_76345[(1)]);
if((state_val_76346 === (7))){
var inst_76307 = (state_76345[(7)]);
var inst_76309 = fluree.db.api.ledger.syncTo_db(inst_76307,syncTo,syncTimeout);
var state_76345__$1 = state_76345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76345__$1,(10),inst_76309);
} else {
if((state_val_76346 === (20))){
var inst_76331 = (state_76345[(8)]);
var state_76345__$1 = state_76345;
var statearr_76347_76384 = state_76345__$1;
(statearr_76347_76384[(2)] = inst_76331);

(statearr_76347_76384[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (1))){
var state_76345__$1 = state_76345;
var statearr_76348_76385 = state_76345__$1;
(statearr_76348_76385[(2)] = null);

(statearr_76348_76385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (4))){
var inst_76295 = (state_76345[(2)]);
var inst_76296 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_76295);
var inst_76297 = cljs.core.async.close_BANG_(pc);
var state_76345__$1 = (function (){var statearr_76349 = state_76345;
(statearr_76349[(9)] = inst_76296);

return statearr_76349;
})();
var statearr_76350_76386 = state_76345__$1;
(statearr_76350_76386[(2)] = inst_76297);

(statearr_76350_76386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (15))){
var inst_76323 = (state_76345[(10)]);
var inst_76325 = fluree.db.api.ledger.add_db_permissions(inst_76323,auth,roles);
var state_76345__$1 = state_76345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76345__$1,(18),inst_76325);
} else {
if((state_val_76346 === (21))){
var inst_76339 = (state_76345[(2)]);
var inst_76340 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_76339);
var _ = (function (){var statearr_76351 = state_76345;
(statearr_76351[(4)] = cljs.core.rest((state_76345[(4)])));

return statearr_76351;
})();
var state_76345__$1 = state_76345;
var statearr_76352_76387 = state_76345__$1;
(statearr_76352_76387[(2)] = inst_76340);

(statearr_76352_76387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (13))){
var inst_76323 = (state_76345[(2)]);
var state_76345__$1 = (function (){var statearr_76353 = state_76345;
(statearr_76353[(10)] = inst_76323);

return statearr_76353;
})();
if(cljs.core.truth_(roles)){
var statearr_76354_76388 = state_76345__$1;
(statearr_76354_76388[(1)] = (15));

} else {
var statearr_76355_76389 = state_76345__$1;
(statearr_76355_76389[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (22))){
var inst_76335 = (state_76345[(2)]);
var inst_76336 = fluree.db.util.async.throw_err(inst_76335);
var state_76345__$1 = state_76345;
var statearr_76356_76390 = state_76345__$1;
(statearr_76356_76390[(2)] = inst_76336);

(statearr_76356_76390[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (6))){
var inst_76306 = (state_76345[(2)]);
var inst_76307 = fluree.db.util.async.throw_err(inst_76306);
var state_76345__$1 = (function (){var statearr_76357 = state_76345;
(statearr_76357[(7)] = inst_76307);

return statearr_76357;
})();
if(cljs.core.truth_(syncTo)){
var statearr_76358_76391 = state_76345__$1;
(statearr_76358_76391[(1)] = (7));

} else {
var statearr_76359_76392 = state_76345__$1;
(statearr_76359_76392[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (17))){
var inst_76331 = (state_76345[(2)]);
var state_76345__$1 = (function (){var statearr_76360 = state_76345;
(statearr_76360[(8)] = inst_76331);

return statearr_76360;
})();
if(cljs.core.truth_(auth)){
var statearr_76361_76393 = state_76345__$1;
(statearr_76361_76393[(1)] = (19));

} else {
var statearr_76362_76394 = state_76345__$1;
(statearr_76362_76394[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (3))){
var inst_76343 = (state_76345[(2)]);
var state_76345__$1 = state_76345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76345__$1,inst_76343);
} else {
if((state_val_76346 === (12))){
var inst_76315 = (state_76345[(11)]);
var state_76345__$1 = state_76345;
var statearr_76363_76395 = state_76345__$1;
(statearr_76363_76395[(2)] = inst_76315);

(statearr_76363_76395[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (2))){
var _ = (function (){var statearr_76364 = state_76345;
(statearr_76364[(4)] = cljs.core.cons((5),(state_76345[(4)])));

return statearr_76364;
})();
var inst_76304 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_76345__$1 = state_76345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76345__$1,(6),inst_76304);
} else {
if((state_val_76346 === (19))){
var inst_76331 = (state_76345[(8)]);
var inst_76333 = fluree.db.api.ledger.add_db_permissions(inst_76331,auth,roles);
var state_76345__$1 = state_76345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76345__$1,(22),inst_76333);
} else {
if((state_val_76346 === (11))){
var inst_76315 = (state_76345[(11)]);
var inst_76317 = fluree.db.time_travel.as_of_block(inst_76315,block);
var state_76345__$1 = state_76345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76345__$1,(14),inst_76317);
} else {
if((state_val_76346 === (9))){
var inst_76315 = (state_76345[(2)]);
var state_76345__$1 = (function (){var statearr_76366 = state_76345;
(statearr_76366[(11)] = inst_76315);

return statearr_76366;
})();
if(cljs.core.truth_(block)){
var statearr_76367_76396 = state_76345__$1;
(statearr_76367_76396[(1)] = (11));

} else {
var statearr_76368_76397 = state_76345__$1;
(statearr_76368_76397[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (5))){
var _ = (function (){var statearr_76369 = state_76345;
(statearr_76369[(4)] = cljs.core.rest((state_76345[(4)])));

return statearr_76369;
})();
var state_76345__$1 = state_76345;
var ex76365 = (state_76345__$1[(2)]);
var statearr_76370_76398 = state_76345__$1;
(statearr_76370_76398[(5)] = ex76365);


var statearr_76371_76399 = state_76345__$1;
(statearr_76371_76399[(1)] = (4));

(statearr_76371_76399[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (14))){
var inst_76319 = (state_76345[(2)]);
var inst_76320 = fluree.db.util.async.throw_err(inst_76319);
var state_76345__$1 = state_76345;
var statearr_76372_76400 = state_76345__$1;
(statearr_76372_76400[(2)] = inst_76320);

(statearr_76372_76400[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (16))){
var inst_76323 = (state_76345[(10)]);
var state_76345__$1 = state_76345;
var statearr_76373_76401 = state_76345__$1;
(statearr_76373_76401[(2)] = inst_76323);

(statearr_76373_76401[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (10))){
var inst_76311 = (state_76345[(2)]);
var inst_76312 = fluree.db.util.async.throw_err(inst_76311);
var state_76345__$1 = state_76345;
var statearr_76374_76402 = state_76345__$1;
(statearr_76374_76402[(2)] = inst_76312);

(statearr_76374_76402[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (18))){
var inst_76327 = (state_76345[(2)]);
var inst_76328 = fluree.db.util.async.throw_err(inst_76327);
var state_76345__$1 = state_76345;
var statearr_76375_76403 = state_76345__$1;
(statearr_76375_76403[(2)] = inst_76328);

(statearr_76375_76403[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76346 === (8))){
var inst_76307 = (state_76345[(7)]);
var state_76345__$1 = state_76345;
var statearr_76376_76404 = state_76345__$1;
(statearr_76376_76404[(2)] = inst_76307);

(statearr_76376_76404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_76377 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76377[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_76377[(1)] = (1));

return statearr_76377;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_76345){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76345);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76378){var ex__2730__auto__ = e76378;
var statearr_76379_76405 = state_76345;
(statearr_76379_76405[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76345[(4)]))){
var statearr_76380_76406 = state_76345;
(statearr_76380_76406[(1)] = cljs.core.first((state_76345[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76407 = state_76345;
state_76345 = G__76407;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_76345){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_76345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76381 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76381[(6)] = c__2749__auto___76383);

return statearr_76381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

