// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.analyzer.impl.namespaces');
goog.require('cljs.core');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__4287 = libspec;
var seq__4288 = cljs.core.seq(vec__4287);
var first__4289 = cljs.core.first(seq__4288);
var seq__4288__$1 = cljs.core.next(seq__4288);
var lib = first__4289;
var spec = seq__4288__$1;
var libspec__$1 = vec__4287;
var vec__4290 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4290,(0),null);
var vec__4293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4290,(1),null);
var seq__4294 = cljs.core.seq(vec__4293);
var first__4295 = cljs.core.first(seq__4294);
var seq__4294__$1 = cljs.core.next(seq__4294);
var _ = first__4295;
var first__4295__$1 = cljs.core.first(seq__4294__$1);
var seq__4294__$2 = cljs.core.next(seq__4294__$1);
var alias = first__4295__$1;
var post_spec = seq__4294__$2;
var post = vec__4293;
if(cljs.core.seq(post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__4296 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count(libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__4296,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__4296;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__4297 = cljs.core.seq(new_as_aliases);
var chunk__4298 = null;
var count__4299 = (0);
var i__4300 = (0);
while(true){
if((i__4300 < count__4299)){
var vec__4307 = chunk__4298.cljs$core$IIndexed$_nth$arity$2(null,i__4300);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4307,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4307,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4313 = seq__4297;
var G__4314 = chunk__4298;
var G__4315 = count__4299;
var G__4316 = (i__4300 + (1));
seq__4297 = G__4313;
chunk__4298 = G__4314;
count__4299 = G__4315;
i__4300 = G__4316;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__4297);
if(temp__5804__auto__){
var seq__4297__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4297__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__4297__$1);
var G__4317 = cljs.core.chunk_rest(seq__4297__$1);
var G__4318 = c__5568__auto__;
var G__4319 = cljs.core.count(c__5568__auto__);
var G__4320 = (0);
seq__4297 = G__4317;
chunk__4298 = G__4318;
count__4299 = G__4319;
i__4300 = G__4320;
continue;
} else {
var vec__4310 = cljs.core.first(seq__4297__$1);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4310,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4310,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4321 = cljs.core.next(seq__4297__$1);
var G__4322 = null;
var G__4323 = (0);
var G__4324 = (0);
seq__4297 = G__4321;
chunk__4298 = G__4322;
count__4299 = G__4323;
i__4300 = G__4324;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__4326 = arguments.length;
switch (G__4326) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__$1,libspec){
var map__4327 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias(libspec);
var map__4327__$1 = cljs.core.__destructure_map(map__4327);
var as_alias = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4327__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4327__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates(new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__4328 = ret__$1;
var G__4328__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4328,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__4328);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4328__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__4328__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__4330,p__4331){
var map__4332 = p__4330;
var map__4332__$1 = cljs.core.__destructure_map(map__4332);
var ret__$1 = map__4332__$1;
var as_aliases = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4332__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__4333 = p__4331;
var seq__4334 = cljs.core.seq(vec__4333);
var first__4335 = cljs.core.first(seq__4334);
var seq__4334__$1 = cljs.core.next(seq__4334);
var spec_key = first__4335;
var libspecs = seq__4334__$1;
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__4336 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,as_aliases);
var map__4336__$1 = cljs.core.__destructure_map(map__4336);
var as_aliases__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4336__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4336__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__4337 = ret__$1;
var G__4337__$1 = (((!(cljs.core.empty_QMARK_(as_aliases__$1))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4337,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__4337);
if((!(cljs.core.empty_QMARK_(libspecs__$1)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4337__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs__$1));
} else {
return G__4337__$1;
}
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs));
}
}),ret,ns_specs);
});
