// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23808,error_ch,vars,p__23809){
var map__23810 = p__23808;
var map__23810__$1 = cljs.core.__destructure_map(map__23810);
var db = map__23810__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23810__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23810__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23810__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23811 = p__23809;
var map__23811__$1 = cljs.core.__destructure_map(map__23811);
var _where_clause = map__23811__$1;
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23811__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23811__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23811__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23812 = (function (){var G__23815 = idx;
var G__23815__$1 = (((G__23815 instanceof cljs.core.Keyword))?G__23815.fqn:null);
switch (G__23815__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23815__$1)].join('')));

}
})();
var fflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23812,(0),null);
var lflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23812,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23806_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o_STAR_,fluree.db.flake.o(p1__23806_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23807_SHARP_){
var G__23816 = fluree.db.flake.o(p1__23807_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23816) : f.call(null,G__23816));
});
})():null));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fflake,lflake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,cljs.core.get.cljs$core$IFn$_invoke$arity$2(novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((10),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0()));
var c__2749__auto___23886 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23855){
var state_val_23856 = (state_23855[(1)]);
if((state_val_23856 === (7))){
var inst_23851 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
var statearr_23857_23887 = state_23855__$1;
(statearr_23857_23887[(2)] = inst_23851);

(statearr_23857_23887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (1))){
var state_23855__$1 = state_23855;
var statearr_23858_23888 = state_23855__$1;
(statearr_23858_23888[(2)] = null);

(statearr_23858_23888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (4))){
var inst_23819 = (state_23855[(7)]);
var inst_23819__$1 = (state_23855[(2)]);
var inst_23820 = (inst_23819__$1 == null);
var state_23855__$1 = (function (){var statearr_23859 = state_23855;
(statearr_23859[(7)] = inst_23819__$1);

return statearr_23859;
})();
if(cljs.core.truth_(inst_23820)){
var statearr_23860_23889 = state_23855__$1;
(statearr_23860_23889[(1)] = (5));

} else {
var statearr_23861_23890 = state_23855__$1;
(statearr_23861_23890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (15))){
var state_23855__$1 = state_23855;
var statearr_23862_23891 = state_23855__$1;
(statearr_23862_23891[(2)] = false);

(statearr_23862_23891[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (13))){
var inst_23831 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
if(cljs.core.truth_(inst_23831)){
var statearr_23863_23892 = state_23855__$1;
(statearr_23863_23892[(1)] = (14));

} else {
var statearr_23864_23893 = state_23855__$1;
(statearr_23864_23893[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (6))){
var inst_23819 = (state_23855[(7)]);
var inst_23824 = cljs.core.seq(inst_23819);
var inst_23825 = inst_23824;
var inst_23826 = (0);
var state_23855__$1 = (function (){var statearr_23865 = state_23855;
(statearr_23865[(8)] = inst_23825);

(statearr_23865[(9)] = inst_23826);

return statearr_23865;
})();
var statearr_23866_23894 = state_23855__$1;
(statearr_23866_23894[(2)] = null);

(statearr_23866_23894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (17))){
var state_23855__$1 = state_23855;
var statearr_23867_23895 = state_23855__$1;
(statearr_23867_23895[(2)] = null);

(statearr_23867_23895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (3))){
var inst_23853 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23855__$1,inst_23853);
} else {
if((state_val_23856 === (12))){
var inst_23841 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
var statearr_23868_23896 = state_23855__$1;
(statearr_23868_23896[(2)] = inst_23841);

(statearr_23868_23896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (2))){
var state_23855__$1 = state_23855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23855__$1,(4),tree_chan);
} else {
if((state_val_23856 === (19))){
var inst_23849 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
var statearr_23869_23897 = state_23855__$1;
(statearr_23869_23897[(2)] = inst_23849);

(statearr_23869_23897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (11))){
var state_23855__$1 = state_23855;
var statearr_23870_23898 = state_23855__$1;
(statearr_23870_23898[(2)] = true);

(statearr_23870_23898[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (9))){
var inst_23843 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
if(cljs.core.truth_(inst_23843)){
var statearr_23871_23899 = state_23855__$1;
(statearr_23871_23899[(1)] = (17));

} else {
var statearr_23872_23900 = state_23855__$1;
(statearr_23872_23900[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (5))){
var inst_23822 = cljs.core.async.close_BANG_(return_chan);
var state_23855__$1 = state_23855;
var statearr_23873_23901 = state_23855__$1;
(statearr_23873_23901[(2)] = inst_23822);

(statearr_23873_23901[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (14))){
var inst_23825 = (state_23855[(8)]);
var inst_23826 = (state_23855[(9)]);
var inst_23833 = cljs.core.next(inst_23825);
var inst_23834 = (inst_23826 + (1));
var inst_23825__$1 = inst_23833;
var inst_23826__$1 = inst_23834;
var state_23855__$1 = (function (){var statearr_23874 = state_23855;
(statearr_23874[(8)] = inst_23825__$1);

(statearr_23874[(9)] = inst_23826__$1);

return statearr_23874;
})();
var statearr_23875_23902 = state_23855__$1;
(statearr_23875_23902[(2)] = null);

(statearr_23875_23902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (16))){
var inst_23838 = (state_23855[(2)]);
var state_23855__$1 = state_23855;
var statearr_23876_23903 = state_23855__$1;
(statearr_23876_23903[(2)] = inst_23838);

(statearr_23876_23903[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (10))){
var inst_23825 = (state_23855[(8)]);
var inst_23829 = cljs.core.first(inst_23825);
var state_23855__$1 = state_23855;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23855__$1,(13),return_chan,inst_23829);
} else {
if((state_val_23856 === (18))){
var inst_23847 = cljs.core.async.close_BANG_(return_chan);
var state_23855__$1 = state_23855;
var statearr_23877_23904 = state_23855__$1;
(statearr_23877_23904[(2)] = inst_23847);

(statearr_23877_23904[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23856 === (8))){
var inst_23825 = (state_23855[(8)]);
var state_23855__$1 = state_23855;
if(cljs.core.truth_(inst_23825)){
var statearr_23878_23905 = state_23855__$1;
(statearr_23878_23905[(1)] = (10));

} else {
var statearr_23879_23906 = state_23855__$1;
(statearr_23879_23906[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_23880 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23880[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__);

(statearr_23880[(1)] = (1));

return statearr_23880;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1 = (function (state_23855){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23855);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23881){var ex__2730__auto__ = e23881;
var statearr_23882_23907 = state_23855;
(statearr_23882_23907[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23855[(4)]))){
var statearr_23883_23908 = state_23855;
(statearr_23883_23908[(1)] = cljs.core.first((state_23855[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23909 = state_23855;
state_23855 = G__23909;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = function(state_23855){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1.call(this,state_23855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23884 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23884[(6)] = c__2749__auto___23886);

return statearr_23884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23910){
var map__23911 = p__23910;
var map__23911__$1 = cljs.core.__destructure_map(map__23911);
var _opts = map__23911__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23911__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn(db):null);
return (function (sid,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23956){
var state_val_23957 = (state_23956[(1)]);
if((state_val_23957 === (7))){
var inst_23927 = (state_23956[(7)]);
var inst_23929 = fluree.db.query.subject_crawl.common.filter_subject(vars,filter_map,inst_23927);
var state_23956__$1 = state_23956;
var statearr_23958_23994 = state_23956__$1;
(statearr_23958_23994[(2)] = inst_23929);

(statearr_23958_23994[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (1))){
var state_23956__$1 = state_23956;
var statearr_23959_23995 = state_23956__$1;
(statearr_23959_23995[(2)] = null);

(statearr_23959_23995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (4))){
var inst_23912 = (state_23956[(2)]);
var inst_23913 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23912);
var inst_23914 = cljs.core.async.close_BANG_(port);
var state_23956__$1 = (function (){var statearr_23960 = state_23956;
(statearr_23960[(8)] = inst_23914);

(statearr_23960[(9)] = inst_23913);

return statearr_23960;
})();
var statearr_23961_23996 = state_23956__$1;
(statearr_23961_23996[(2)] = null);

(statearr_23961_23996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (15))){
var inst_23944 = (state_23956[(10)]);
var inst_23944__$1 = (state_23956[(2)]);
var inst_23945 = cljs.core.seq(inst_23944__$1);
var state_23956__$1 = (function (){var statearr_23962 = state_23956;
(statearr_23962[(10)] = inst_23944__$1);

return statearr_23962;
})();
if(inst_23945){
var statearr_23963_23997 = state_23956__$1;
(statearr_23963_23997[(1)] = (17));

} else {
var statearr_23964_23998 = state_23956__$1;
(statearr_23964_23998[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (13))){
var inst_23937 = (state_23956[(11)]);
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23956__$1,(16),inst_23937);
} else {
if((state_val_23957 === (6))){
var inst_23926 = (state_23956[(2)]);
var inst_23927 = fluree.db.util.async.throw_err(inst_23926);
var state_23956__$1 = (function (){var statearr_23965 = state_23956;
(statearr_23965[(7)] = inst_23927);

return statearr_23965;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23966_23999 = state_23956__$1;
(statearr_23966_23999[(1)] = (7));

} else {
var statearr_23967_24000 = state_23956__$1;
(statearr_23967_24000[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (17))){
var inst_23944 = (state_23956[(10)]);
var inst_23947 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23944);
var state_23956__$1 = state_23956;
var statearr_23968_24001 = state_23956__$1;
(statearr_23968_24001[(2)] = inst_23947);

(statearr_23968_24001[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (3))){
var inst_23954 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23956__$1,inst_23954);
} else {
if((state_val_23957 === (12))){
var inst_23937 = (state_23956[(2)]);
var state_23956__$1 = (function (){var statearr_23969 = state_23956;
(statearr_23969[(11)] = inst_23937);

return statearr_23969;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23970_24002 = state_23956__$1;
(statearr_23970_24002[(1)] = (13));

} else {
var statearr_23971_24003 = state_23956__$1;
(statearr_23971_24003[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (2))){
var _ = (function (){var statearr_23972 = state_23956;
(statearr_23972[(4)] = cljs.core.cons((5),(state_23956[(4)])));

return statearr_23972;
})();
var inst_23921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23922 = [sid];
var inst_23923 = (new cljs.core.PersistentVector(null,1,(5),inst_23921,inst_23922,null));
var inst_23924 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23923);
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23956__$1,(6),inst_23924);
} else {
if((state_val_23957 === (19))){
var inst_23950 = (state_23956[(2)]);
var inst_23951 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_23973 = state_23956;
(statearr_23973[(4)] = cljs.core.rest((state_23956[(4)])));

return statearr_23973;
})();
var state_23956__$1 = (function (){var statearr_23974 = state_23956;
(statearr_23974[(12)] = inst_23950);

return statearr_23974;
})();
var statearr_23975_24004 = state_23956__$1;
(statearr_23975_24004[(2)] = inst_23951);

(statearr_23975_24004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (11))){
var inst_23932 = (state_23956[(13)]);
var state_23956__$1 = state_23956;
var statearr_23977_24005 = state_23956__$1;
(statearr_23977_24005[(2)] = inst_23932);

(statearr_23977_24005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (9))){
var inst_23932 = (state_23956[(2)]);
var state_23956__$1 = (function (){var statearr_23978 = state_23956;
(statearr_23978[(13)] = inst_23932);

return statearr_23978;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23979_24006 = state_23956__$1;
(statearr_23979_24006[(1)] = (10));

} else {
var statearr_23980_24007 = state_23956__$1;
(statearr_23980_24007[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (5))){
var _ = (function (){var statearr_23981 = state_23956;
(statearr_23981[(4)] = cljs.core.rest((state_23956[(4)])));

return statearr_23981;
})();
var state_23956__$1 = state_23956;
var ex23976 = (state_23956__$1[(2)]);
var statearr_23982_24008 = state_23956__$1;
(statearr_23982_24008[(5)] = ex23976);


var statearr_23983_24009 = state_23956__$1;
(statearr_23983_24009[(1)] = (4));

(statearr_23983_24009[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (14))){
var inst_23937 = (state_23956[(11)]);
var state_23956__$1 = state_23956;
var statearr_23984_24010 = state_23956__$1;
(statearr_23984_24010[(2)] = inst_23937);

(statearr_23984_24010[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (16))){
var inst_23940 = (state_23956[(2)]);
var inst_23941 = fluree.db.util.async.throw_err(inst_23940);
var state_23956__$1 = state_23956;
var statearr_23985_24011 = state_23956__$1;
(statearr_23985_24011[(2)] = inst_23941);

(statearr_23985_24011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (10))){
var inst_23932 = (state_23956[(13)]);
var inst_23934 = (permissions.cljs$core$IFn$_invoke$arity$1 ? permissions.cljs$core$IFn$_invoke$arity$1(inst_23932) : permissions.call(null,inst_23932));
var state_23956__$1 = state_23956;
var statearr_23986_24012 = state_23956__$1;
(statearr_23986_24012[(2)] = inst_23934);

(statearr_23986_24012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (18))){
var state_23956__$1 = state_23956;
var statearr_23987_24013 = state_23956__$1;
(statearr_23987_24013[(2)] = null);

(statearr_23987_24013[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23957 === (8))){
var inst_23927 = (state_23956[(7)]);
var state_23956__$1 = state_23956;
var statearr_23988_24014 = state_23956__$1;
(statearr_23988_24014[(2)] = inst_23927);

(statearr_23988_24014[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0 = (function (){
var statearr_23989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23989[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__);

(statearr_23989[(1)] = (1));

return statearr_23989;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1 = (function (state_23956){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23956);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23990){var ex__2730__auto__ = e23990;
var statearr_23991_24015 = state_23956;
(statearr_23991_24015[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23956[(4)]))){
var statearr_23992_24016 = state_23956;
(statearr_23992_24016[(1)] = cljs.core.first((state_23956[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24017 = state_23956;
state_23956 = G__24017;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = function(state_23956){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1.call(this,state_23956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23993 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23993[(6)] = c__2749__auto__);

return statearr_23993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__24018){
var map__24019 = p__24018;
var map__24019__$1 = cljs.core.__destructure_map(map__24019);
var f_where = map__24019__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24019__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2749__auto___24056 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24039){
var state_val_24040 = (state_24039[(1)]);
if((state_val_24040 === (7))){
var inst_24027 = (state_24039[(7)]);
var inst_24030 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_24027);
var state_24039__$1 = state_24039;
var statearr_24041_24057 = state_24039__$1;
(statearr_24041_24057[(2)] = inst_24030);

(statearr_24041_24057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (1))){
var inst_24020 = typeof _id_val === 'number';
var state_24039__$1 = state_24039;
if(cljs.core.truth_(inst_24020)){
var statearr_24042_24058 = state_24039__$1;
(statearr_24042_24058[(1)] = (2));

} else {
var statearr_24043_24059 = state_24039__$1;
(statearr_24043_24059[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (4))){
var inst_24036 = (state_24039[(2)]);
var inst_24037 = cljs.core.async.close_BANG_(return_ch);
var state_24039__$1 = (function (){var statearr_24044 = state_24039;
(statearr_24044[(8)] = inst_24036);

return statearr_24044;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24039__$1,inst_24037);
} else {
if((state_val_24040 === (6))){
var inst_24027 = (state_24039[(7)]);
var inst_24027__$1 = (state_24039[(2)]);
var inst_24028 = fluree.db.util.core.exception_QMARK_(inst_24027__$1);
var state_24039__$1 = (function (){var statearr_24045 = state_24039;
(statearr_24045[(7)] = inst_24027__$1);

return statearr_24045;
})();
if(inst_24028){
var statearr_24046_24060 = state_24039__$1;
(statearr_24046_24060[(1)] = (7));

} else {
var statearr_24047_24061 = state_24039__$1;
(statearr_24047_24061[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (3))){
var inst_24025 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,_id_val);
var state_24039__$1 = state_24039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24039__$1,(6),inst_24025);
} else {
if((state_val_24040 === (2))){
var state_24039__$1 = state_24039;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24039__$1,(5),return_ch,_id_val);
} else {
if((state_val_24040 === (9))){
var inst_24034 = (state_24039[(2)]);
var state_24039__$1 = state_24039;
var statearr_24048_24062 = state_24039__$1;
(statearr_24048_24062[(2)] = inst_24034);

(statearr_24048_24062[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (5))){
var inst_24023 = (state_24039[(2)]);
var state_24039__$1 = state_24039;
var statearr_24049_24063 = state_24039__$1;
(statearr_24049_24063[(2)] = inst_24023);

(statearr_24049_24063[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (8))){
var inst_24027 = (state_24039[(7)]);
var inst_24032 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_24027);
var state_24039__$1 = state_24039;
var statearr_24050_24064 = state_24039__$1;
(statearr_24050_24064[(2)] = inst_24032);

(statearr_24050_24064[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_24051 = [null,null,null,null,null,null,null,null,null];
(statearr_24051[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__);

(statearr_24051[(1)] = (1));

return statearr_24051;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1 = (function (state_24039){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24039);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24052){var ex__2730__auto__ = e24052;
var statearr_24053_24065 = state_24039;
(statearr_24053_24065[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24039[(4)]))){
var statearr_24054_24066 = state_24039;
(statearr_24054_24066[(1)] = cljs.core.first((state_24039[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24067 = state_24039;
state_24039 = G__24067;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = function(state_24039){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1.call(this,state_24039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24055 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24055[(6)] = c__2749__auto___24056);

return statearr_24055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__24068){
var map__24069 = p__24068;
var map__24069__$1 = cljs.core.__destructure_map(map__24069);
var opts = map__24069__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24069__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24136){
var state_val_24137 = (state_24136[(1)]);
if((state_val_24137 === (7))){
var inst_24081 = fluree.db.query.subject_crawl.subject.subjects_chan(db,error_ch,vars,f_where);
var state_24136__$1 = state_24136;
var statearr_24138_24175 = state_24136__$1;
(statearr_24138_24175[(2)] = inst_24081);

(statearr_24138_24175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (20))){
var inst_24125 = (state_24136[(2)]);
var state_24136__$1 = state_24136;
var statearr_24139_24176 = state_24136__$1;
(statearr_24139_24176[(2)] = inst_24125);

(statearr_24139_24176[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (1))){
var state_24136__$1 = state_24136;
var statearr_24140_24177 = state_24136__$1;
(statearr_24140_24177[(2)] = null);

(statearr_24140_24177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (4))){
var inst_24070 = (state_24136[(2)]);
var state_24136__$1 = state_24136;
var statearr_24141_24178 = state_24136__$1;
(statearr_24141_24178[(2)] = inst_24070);

(statearr_24141_24178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (15))){
var inst_24083 = (state_24136[(7)]);
var inst_24089 = (state_24136[(8)]);
var inst_24094 = (state_24136[(9)]);
var inst_24088 = (state_24136[(10)]);
var inst_24115 = cljs.core.async.close_BANG_(inst_24083);
var inst_24116 = cljs.core.async.close_BANG_(inst_24088);
var inst_24117 = cljs.core.async.close_BANG_(inst_24089);
var inst_24118 = (finish_fn.cljs$core$IFn$_invoke$arity$1 ? finish_fn.cljs$core$IFn$_invoke$arity$1(inst_24094) : finish_fn.call(null,inst_24094));
var state_24136__$1 = (function (){var statearr_24142 = state_24136;
(statearr_24142[(11)] = inst_24117);

(statearr_24142[(12)] = inst_24115);

(statearr_24142[(13)] = inst_24116);

return statearr_24142;
})();
var statearr_24143_24179 = state_24136__$1;
(statearr_24143_24179[(2)] = inst_24118);

(statearr_24143_24179[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (13))){
var inst_24104 = (state_24136[(14)]);
var inst_24113 = (inst_24104 == null);
var state_24136__$1 = state_24136;
if(cljs.core.truth_(inst_24113)){
var statearr_24144_24180 = state_24136__$1;
(statearr_24144_24180[(1)] = (15));

} else {
var statearr_24145_24181 = state_24136__$1;
(statearr_24145_24181[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (6))){
var inst_24079 = fluree.db.query.subject_crawl.subject.subjects_id_chan(db,error_ch,vars,f_where);
var state_24136__$1 = state_24136;
var statearr_24146_24182 = state_24136__$1;
(statearr_24146_24182[(2)] = inst_24079);

(statearr_24146_24182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (17))){
var inst_24127 = (state_24136[(2)]);
var state_24136__$1 = state_24136;
var statearr_24147_24183 = state_24136__$1;
(statearr_24147_24183[(2)] = inst_24127);

(statearr_24147_24183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (3))){
var inst_24134 = (state_24136[(2)]);
var state_24136__$1 = state_24136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24136__$1,inst_24134);
} else {
if((state_val_24137 === (12))){
var inst_24083 = (state_24136[(7)]);
var inst_24089 = (state_24136[(8)]);
var inst_24104 = (state_24136[(14)]);
var inst_24088 = (state_24136[(10)]);
var inst_24108 = cljs.core.async.close_BANG_(inst_24083);
var inst_24109 = cljs.core.async.close_BANG_(inst_24088);
var inst_24110 = cljs.core.async.close_BANG_(inst_24089);
var inst_24111 = (function(){throw inst_24104})();
var state_24136__$1 = (function (){var statearr_24148 = state_24136;
(statearr_24148[(15)] = inst_24110);

(statearr_24148[(16)] = inst_24108);

(statearr_24148[(17)] = inst_24109);

return statearr_24148;
})();
var statearr_24149_24184 = state_24136__$1;
(statearr_24149_24184[(2)] = inst_24111);

(statearr_24149_24184[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (2))){
var _ = (function (){var statearr_24150 = state_24136;
(statearr_24150[(4)] = cljs.core.cons((5),(state_24136[(4)])));

return statearr_24150;
})();
var inst_24076 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_24077 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24076);
var state_24136__$1 = state_24136;
if(inst_24077){
var statearr_24151_24185 = state_24136__$1;
(statearr_24151_24185[(1)] = (6));

} else {
var statearr_24152_24186 = state_24136__$1;
(statearr_24152_24186[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (19))){
var state_24136__$1 = state_24136;
var statearr_24153_24187 = state_24136__$1;
(statearr_24153_24187[(2)] = null);

(statearr_24153_24187[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (11))){
var inst_24103 = (state_24136[(2)]);
var inst_24104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24103,(0),null);
var inst_24105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24103,(1),null);
var inst_24106 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24105,error_ch);
var state_24136__$1 = (function (){var statearr_24155 = state_24136;
(statearr_24155[(14)] = inst_24104);

return statearr_24155;
})();
if(inst_24106){
var statearr_24156_24188 = state_24136__$1;
(statearr_24156_24188[(1)] = (12));

} else {
var statearr_24157_24189 = state_24136__$1;
(statearr_24157_24189[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (9))){
var inst_24089 = (state_24136[(8)]);
var inst_24099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24100 = [error_ch,inst_24089];
var inst_24101 = (new cljs.core.PersistentVector(null,2,(5),inst_24099,inst_24100,null));
var state_24136__$1 = state_24136;
return cljs.core.async.ioc_alts_BANG_(state_24136__$1,(11),inst_24101);
} else {
if((state_val_24137 === (5))){
var _ = (function (){var statearr_24158 = state_24136;
(statearr_24158[(4)] = cljs.core.rest((state_24136[(4)])));

return statearr_24158;
})();
var state_24136__$1 = state_24136;
var ex24154 = (state_24136__$1[(2)]);
var statearr_24159_24190 = state_24136__$1;
(statearr_24159_24190[(5)] = ex24154);


if((ex24154 instanceof Error)){
var statearr_24160_24191 = state_24136__$1;
(statearr_24160_24191[(1)] = (4));

(statearr_24160_24191[(5)] = null);

} else {
throw ex24154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (14))){
var inst_24129 = (state_24136[(2)]);
var state_24136__$1 = state_24136;
var statearr_24161_24192 = state_24136__$1;
(statearr_24161_24192[(2)] = inst_24129);

(statearr_24161_24192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (16))){
var state_24136__$1 = state_24136;
var statearr_24162_24193 = state_24136__$1;
(statearr_24162_24193[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (10))){
var inst_24131 = (state_24136[(2)]);
var _ = (function (){var statearr_24164 = state_24136;
(statearr_24164[(4)] = cljs.core.rest((state_24136[(4)])));

return statearr_24164;
})();
var state_24136__$1 = state_24136;
var statearr_24165_24194 = state_24136__$1;
(statearr_24165_24194[(2)] = inst_24131);

(statearr_24165_24194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (18))){
var inst_24094 = (state_24136[(9)]);
var inst_24104 = (state_24136[(14)]);
var inst_24121 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24094,inst_24104);
var inst_24094__$1 = inst_24121;
var state_24136__$1 = (function (){var statearr_24166 = state_24136;
(statearr_24166[(9)] = inst_24094__$1);

return statearr_24166;
})();
var statearr_24167_24195 = state_24136__$1;
(statearr_24167_24195[(2)] = null);

(statearr_24167_24195[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24137 === (8))){
var inst_24083 = (state_24136[(7)]);
var inst_24089 = (state_24136[(8)]);
var inst_24088 = (state_24136[(10)]);
var inst_24083__$1 = (state_24136[(2)]);
var inst_24084 = fluree.db.query.subject_crawl.subject.flakes_xf(opts);
var inst_24085 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_24086 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_24087 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24085,inst_24086);
var inst_24088__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((32),inst_24087);
var inst_24089__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24090 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24088__$1,inst_24084,inst_24083__$1);
var inst_24091 = fluree.db.query.subject_crawl.common.result_af(opts);
var inst_24092 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24089__$1,inst_24091,inst_24088__$1);
var inst_24093 = cljs.core.PersistentVector.EMPTY;
var inst_24094 = inst_24093;
var state_24136__$1 = (function (){var statearr_24168 = state_24136;
(statearr_24168[(7)] = inst_24083__$1);

(statearr_24168[(8)] = inst_24089__$1);

(statearr_24168[(9)] = inst_24094);

(statearr_24168[(18)] = inst_24092);

(statearr_24168[(19)] = inst_24090);

(statearr_24168[(10)] = inst_24088__$1);

return statearr_24168;
})();
var statearr_24169_24196 = state_24136__$1;
(statearr_24169_24196[(2)] = null);

(statearr_24169_24196[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0 = (function (){
var statearr_24170 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24170[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__);

(statearr_24170[(1)] = (1));

return statearr_24170;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1 = (function (state_24136){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24136);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24171){var ex__2730__auto__ = e24171;
var statearr_24172_24197 = state_24136;
(statearr_24172_24197[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24136[(4)]))){
var statearr_24173_24198 = state_24136;
(statearr_24173_24198[(1)] = cljs.core.first((state_24136[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24199 = state_24136;
state_24136 = G__24199;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = function(state_24136){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1.call(this,state_24136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24174 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24174[(6)] = c__2749__auto__);

return statearr_24174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
