// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23620){
var map__23621 = p__23620;
var map__23621__$1 = cljs.core.__destructure_map(map__23621);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23621__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23621__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23621__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23621__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23621__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,(function (){var G__23622 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__23622,xf);
} else {
return G__23622;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23623){
var map__23624 = p__23623;
var map__23624__$1 = cljs.core.__destructure_map(map__23624);
var _opts = map__23624__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23624__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23655){
var state_val_23656 = (state_23655[(1)]);
if((state_val_23656 === (7))){
var state_23655__$1 = state_23655;
var statearr_23657_23683 = state_23655__$1;
(statearr_23657_23683[(2)] = null);

(statearr_23657_23683[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (1))){
var state_23655__$1 = state_23655;
var statearr_23658_23684 = state_23655__$1;
(statearr_23658_23684[(2)] = null);

(statearr_23658_23684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (4))){
var inst_23625 = (state_23655[(2)]);
var inst_23626 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23625);
var inst_23627 = cljs.core.async.close_BANG_(port);
var state_23655__$1 = (function (){var statearr_23659 = state_23655;
(statearr_23659[(7)] = inst_23626);

(statearr_23659[(8)] = inst_23627);

return statearr_23659;
})();
var statearr_23660_23685 = state_23655__$1;
(statearr_23660_23685[(2)] = null);

(statearr_23660_23685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (6))){
var inst_23637 = (state_23655[(9)]);
var inst_23636 = (state_23655[(2)]);
var inst_23637__$1 = fluree.db.util.async.throw_err(inst_23636);
var inst_23638 = (inst_23637__$1 == null);
var state_23655__$1 = (function (){var statearr_23661 = state_23655;
(statearr_23661[(9)] = inst_23637__$1);

return statearr_23661;
})();
if(cljs.core.truth_(inst_23638)){
var statearr_23662_23686 = state_23655__$1;
(statearr_23662_23686[(1)] = (7));

} else {
var statearr_23663_23687 = state_23655__$1;
(statearr_23663_23687[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (3))){
var inst_23653 = (state_23655[(2)]);
var state_23655__$1 = state_23655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23655__$1,inst_23653);
} else {
if((state_val_23656 === (12))){
var inst_23649 = (state_23655[(2)]);
var inst_23650 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_23664 = state_23655;
(statearr_23664[(4)] = cljs.core.rest((state_23655[(4)])));

return statearr_23664;
})();
var state_23655__$1 = (function (){var statearr_23665 = state_23655;
(statearr_23665[(10)] = inst_23649);

return statearr_23665;
})();
var statearr_23666_23688 = state_23655__$1;
(statearr_23666_23688[(2)] = inst_23650);

(statearr_23666_23688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (2))){
var _ = (function (){var statearr_23667 = state_23655;
(statearr_23667[(4)] = cljs.core.cons((5),(state_23655[(4)])));

return statearr_23667;
})();
var inst_23634 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23655__$1 = state_23655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23655__$1,(6),inst_23634);
} else {
if((state_val_23656 === (11))){
var inst_23643 = (state_23655[(11)]);
var inst_23647 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23643);
var state_23655__$1 = state_23655;
var statearr_23669_23689 = state_23655__$1;
(statearr_23669_23689[(2)] = inst_23647);

(statearr_23669_23689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (9))){
var inst_23643 = (state_23655[(11)]);
var inst_23643__$1 = (state_23655[(2)]);
var inst_23644 = (inst_23643__$1 == null);
var state_23655__$1 = (function (){var statearr_23670 = state_23655;
(statearr_23670[(11)] = inst_23643__$1);

return statearr_23670;
})();
if(cljs.core.truth_(inst_23644)){
var statearr_23671_23690 = state_23655__$1;
(statearr_23671_23690[(1)] = (10));

} else {
var statearr_23672_23691 = state_23655__$1;
(statearr_23672_23691[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (5))){
var _ = (function (){var statearr_23673 = state_23655;
(statearr_23673[(4)] = cljs.core.rest((state_23655[(4)])));

return statearr_23673;
})();
var state_23655__$1 = state_23655;
var ex23668 = (state_23655__$1[(2)]);
var statearr_23674_23692 = state_23655__$1;
(statearr_23674_23692[(5)] = ex23668);


var statearr_23675_23693 = state_23655__$1;
(statearr_23675_23693[(1)] = (4));

(statearr_23675_23693[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (10))){
var state_23655__$1 = state_23655;
var statearr_23676_23694 = state_23655__$1;
(statearr_23676_23694[(2)] = null);

(statearr_23676_23694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23656 === (8))){
var inst_23637 = (state_23655[(9)]);
var inst_23641 = cljs.core.not_empty(inst_23637);
var state_23655__$1 = state_23655;
var statearr_23677_23695 = state_23655__$1;
(statearr_23677_23695[(2)] = inst_23641);

(statearr_23677_23695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0 = (function (){
var statearr_23678 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23678[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__);

(statearr_23678[(1)] = (1));

return statearr_23678;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1 = (function (state_23655){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23655);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23679){var ex__2730__auto__ = e23679;
var statearr_23680_23696 = state_23655;
(statearr_23680_23696[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23655[(4)]))){
var statearr_23681_23697 = state_23655;
(statearr_23681_23697[(1)] = cljs.core.first((state_23655[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23698 = state_23655;
state_23655 = G__23698;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = function(state_23655){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1.call(this,state_23655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23682 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23682[(6)] = c__2749__auto__);

return statearr_23682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23699){
var map__23700 = p__23699;
var map__23700__$1 = cljs.core.__destructure_map(map__23700);
var db = map__23700__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23700__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_(permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_(cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_(coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23731){
var state_val_23732 = (state_23731[(1)]);
if((state_val_23732 === (7))){
var inst_23707 = (state_23731[(7)]);
var inst_23717 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_23707);
var state_23731__$1 = state_23731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23731__$1,(10),inst_23717);
} else {
if((state_val_23732 === (1))){
var state_23731__$1 = state_23731;
var statearr_23733_23756 = state_23731__$1;
(statearr_23733_23756[(2)] = null);

(statearr_23733_23756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (4))){
var inst_23701 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
var statearr_23734_23757 = state_23731__$1;
(statearr_23734_23757[(2)] = inst_23701);

(statearr_23734_23757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (13))){
var inst_23724 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
var statearr_23735_23758 = state_23731__$1;
(statearr_23735_23758[(2)] = inst_23724);

(statearr_23735_23758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (6))){
var inst_23712 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,flakes);
var state_23731__$1 = state_23731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23731__$1,(9),inst_23712);
} else {
if((state_val_23732 === (3))){
var inst_23729 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23731__$1,inst_23729);
} else {
if((state_val_23732 === (12))){
var state_23731__$1 = state_23731;
var statearr_23736_23759 = state_23731__$1;
(statearr_23736_23759[(2)] = null);

(statearr_23736_23759[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (2))){
var inst_23707 = (state_23731[(7)]);
var _ = (function (){var statearr_23737 = state_23731;
(statearr_23737[(4)] = cljs.core.cons((5),(state_23731[(4)])));

return statearr_23737;
})();
var inst_23707__$1 = cljs.core.first(flakes);
var inst_23708 = fluree.db.flake.s(inst_23707__$1);
var inst_23709 = fluree.db.flake.sid__GT_cid(inst_23708);
var inst_23710 = filter_predicates_QMARK_(inst_23709);
var state_23731__$1 = (function (){var statearr_23738 = state_23731;
(statearr_23738[(7)] = inst_23707__$1);

return statearr_23738;
})();
if(cljs.core.truth_(inst_23710)){
var statearr_23739_23760 = state_23731__$1;
(statearr_23739_23760[(1)] = (6));

} else {
var statearr_23740_23761 = state_23731__$1;
(statearr_23740_23761[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (11))){
var state_23731__$1 = state_23731;
var statearr_23742_23762 = state_23731__$1;
(statearr_23742_23762[(2)] = flakes);

(statearr_23742_23762[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (9))){
var inst_23714 = (state_23731[(2)]);
var inst_23715 = fluree.db.util.async.throw_err(inst_23714);
var state_23731__$1 = state_23731;
var statearr_23743_23763 = state_23731__$1;
(statearr_23743_23763[(2)] = inst_23715);

(statearr_23743_23763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (5))){
var _ = (function (){var statearr_23744 = state_23731;
(statearr_23744[(4)] = cljs.core.rest((state_23731[(4)])));

return statearr_23744;
})();
var state_23731__$1 = state_23731;
var ex23741 = (state_23731__$1[(2)]);
var statearr_23745_23764 = state_23731__$1;
(statearr_23745_23764[(5)] = ex23741);


if((ex23741 instanceof Error)){
var statearr_23746_23765 = state_23731__$1;
(statearr_23746_23765[(1)] = (4));

(statearr_23746_23765[(5)] = null);

} else {
throw ex23741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (10))){
var inst_23719 = (state_23731[(2)]);
var inst_23720 = fluree.db.util.async.throw_err(inst_23719);
var state_23731__$1 = state_23731;
if(cljs.core.truth_(inst_23720)){
var statearr_23747_23766 = state_23731__$1;
(statearr_23747_23766[(1)] = (11));

} else {
var statearr_23748_23767 = state_23731__$1;
(statearr_23748_23767[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (8))){
var inst_23726 = (state_23731[(2)]);
var _ = (function (){var statearr_23749 = state_23731;
(statearr_23749[(4)] = cljs.core.rest((state_23731[(4)])));

return statearr_23749;
})();
var state_23731__$1 = state_23731;
var statearr_23750_23768 = state_23731__$1;
(statearr_23750_23768[(2)] = inst_23726);

(statearr_23750_23768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_23751 = [null,null,null,null,null,null,null,null];
(statearr_23751[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__);

(statearr_23751[(1)] = (1));

return statearr_23751;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1 = (function (state_23731){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23731);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23752){var ex__2730__auto__ = e23752;
var statearr_23753_23769 = state_23731;
(statearr_23753_23769[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23731[(4)]))){
var statearr_23754_23770 = state_23731;
(statearr_23754_23770[(1)] = cljs.core.first((state_23731[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23771 = state_23731;
state_23731 = G__23771;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = function(state_23731){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1.call(this,state_23731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23755 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23755[(6)] = c__2749__auto__);

return statearr_23755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some((function (p1__23772_SHARP_){
return (filter_fn.cljs$core$IFn$_invoke$arity$2 ? filter_fn.cljs$core$IFn$_invoke$arity$2(p1__23772_SHARP_,vars) : filter_fn.call(null,p1__23772_SHARP_,vars));
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23776 = filter_fns;
var vec__23777 = G__23776;
var seq__23778 = cljs.core.seq(vec__23777);
var first__23779 = cljs.core.first(seq__23778);
var seq__23778__$1 = cljs.core.next(seq__23778);
var filter_fn = first__23779;
var r_fns = seq__23778__$1;
var G__23776__$1 = G__23776;
while(true){
var vec__23780 = G__23776__$1;
var seq__23781 = cljs.core.seq(vec__23780);
var first__23782 = cljs.core.first(seq__23781);
var seq__23781__$1 = cljs.core.next(seq__23781);
var filter_fn__$1 = first__23782;
var r_fns__$1 = seq__23781__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_(filter_fn__$1,vars,pred_flakes))){
var G__23783 = r_fns__$1;
G__23776__$1 = G__23783;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23787 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,flakes);
var vec__23788 = G__23787;
var seq__23789 = cljs.core.seq(vec__23788);
var first__23790 = cljs.core.first(seq__23789);
var seq__23789__$1 = cljs.core.next(seq__23789);
var p_flakes = first__23790;
var r = seq__23789__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23787__$1 = G__23787;
var required_p__$1 = required_p;
while(true){
var vec__23794 = G__23787__$1;
var seq__23795 = cljs.core.seq(vec__23794);
var first__23796 = cljs.core.first(seq__23795);
var seq__23795__$1 = cljs.core.next(seq__23795);
var p_flakes__$1 = first__23796;
var r__$1 = seq__23795__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p(cljs.core.first(p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_(filter_fns,vars,p_flakes__$1)){
var G__23797 = r__$1;
var G__23798 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23787__$1 = G__23797;
required_p__$1 = G__23798;
continue;
} else {
return null;
}
} else {
var G__23799 = r__$1;
var G__23800 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23787__$1 = G__23799;
required_p__$1 = G__23800;
continue;
}
} else {
if(cljs.core.empty_QMARK_(required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23801){
var map__23802 = p__23801;
var map__23802__$1 = cljs.core.__destructure_map(map__23802);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23802__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23802__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23802__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__23803 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(result,predicate);
}),results);
var G__23803__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),order))?cljs.core.reverse(G__23803):G__23803);
return cljs.core.vec(G__23803__$1);

}
});
