// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25667 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25667,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25667,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25667,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_(fluree.db.graphdb.exclude_predicates,fluree.db.flake.p(f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement(fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25670){
var map__25671 = p__25670;
var map__25671__$1 = cljs.core.__destructure_map(map__25671);
var opts = map__25671__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25671__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25731){
var state_val_25732 = (state_25731[(1)]);
if((state_val_25732 === (7))){
var inst_25702 = cljs.core.not(reindex_QMARK_);
var state_25731__$1 = state_25731;
var statearr_25733_25757 = state_25731__$1;
(statearr_25733_25757[(2)] = inst_25702);

(statearr_25733_25757[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (1))){
var state_25731__$1 = state_25731;
var statearr_25734_25758 = state_25731__$1;
(statearr_25734_25758[(2)] = null);

(statearr_25734_25758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (4))){
var inst_25672 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
var statearr_25735_25759 = state_25731__$1;
(statearr_25735_25759[(2)] = inst_25672);

(statearr_25735_25759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (6))){
var inst_25692 = (state_25731[(7)]);
var inst_25686 = (state_25731[(8)]);
var inst_25700 = (state_25731[(9)]);
var inst_25685 = (state_25731[(2)]);
var inst_25686__$1 = fluree.db.util.async.throw_err(inst_25685);
var inst_25687 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25688 = cljs.core.__destructure_map(inst_25687);
var inst_25689 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25688,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25688,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25691 = fluree.db.flake.size_bytes(inst_25686__$1);
var inst_25692__$1 = (inst_25690 + inst_25691);
var inst_25693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25694 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25695 = (new cljs.core.PersistentVector(null,2,(5),inst_25693,inst_25694,null));
var inst_25696 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25695);
var inst_25697 = cljs.core.__destructure_map(inst_25696);
var inst_25698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25697,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25697,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25700__$1 = (inst_25692__$1 > inst_25699);
var state_25731__$1 = (function (){var statearr_25736 = state_25731;
(statearr_25736[(7)] = inst_25692__$1);

(statearr_25736[(8)] = inst_25686__$1);

(statearr_25736[(10)] = inst_25698);

(statearr_25736[(11)] = inst_25689);

(statearr_25736[(9)] = inst_25700__$1);

return statearr_25736;
})();
if(cljs.core.truth_(inst_25700__$1)){
var statearr_25737_25760 = state_25731__$1;
(statearr_25737_25760[(1)] = (7));

} else {
var statearr_25738_25761 = state_25731__$1;
(statearr_25738_25761[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (3))){
var inst_25729 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25731__$1,inst_25729);
} else {
if((state_val_25732 === (12))){
var inst_25692 = (state_25731[(7)]);
var inst_25686 = (state_25731[(8)]);
var inst_25689 = (state_25731[(11)]);
var inst_25715 = (state_25731[(2)]);
var inst_25716 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25689,inst_25686);
var inst_25717 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25718 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25717,cljs.core.empty);
var inst_25719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25720 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25721 = (new cljs.core.PersistentVector(null,2,(5),inst_25719,inst_25720,null));
var inst_25722 = cljs.core.assoc_in(db,inst_25721,inst_25716);
var inst_25723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25724 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25725 = (new cljs.core.PersistentVector(null,2,(5),inst_25723,inst_25724,null));
var inst_25726 = cljs.core.assoc_in(inst_25722,inst_25725,inst_25692);
var _ = (function (){var statearr_25739 = state_25731;
(statearr_25739[(4)] = cljs.core.rest((state_25731[(4)])));

return statearr_25739;
})();
var state_25731__$1 = (function (){var statearr_25740 = state_25731;
(statearr_25740[(12)] = inst_25718);

(statearr_25740[(13)] = inst_25715);

return statearr_25740;
})();
var statearr_25741_25762 = state_25731__$1;
(statearr_25741_25762[(2)] = inst_25726);

(statearr_25741_25762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (2))){
var _ = (function (){var statearr_25742 = state_25731;
(statearr_25742[(4)] = cljs.core.cons((5),(state_25731[(4)])));

return statearr_25742;
})();
var inst_25680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25681 = [pred_id];
var inst_25682 = (new cljs.core.PersistentVector(null,1,(5),inst_25680,inst_25681,null));
var inst_25683 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25682);
var state_25731__$1 = state_25731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25731__$1,(6),inst_25683);
} else {
if((state_val_25732 === (11))){
var state_25731__$1 = state_25731;
var statearr_25744_25763 = state_25731__$1;
(statearr_25744_25763[(2)] = null);

(statearr_25744_25763[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (9))){
var inst_25705 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
if(cljs.core.truth_(inst_25705)){
var statearr_25745_25764 = state_25731__$1;
(statearr_25745_25764[(1)] = (10));

} else {
var statearr_25746_25765 = state_25731__$1;
(statearr_25746_25765[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (5))){
var _ = (function (){var statearr_25747 = state_25731;
(statearr_25747[(4)] = cljs.core.rest((state_25731[(4)])));

return statearr_25747;
})();
var state_25731__$1 = state_25731;
var ex25743 = (state_25731__$1[(2)]);
var statearr_25748_25766 = state_25731__$1;
(statearr_25748_25766[(5)] = ex25743);


if((ex25743 instanceof Error)){
var statearr_25749_25767 = state_25731__$1;
(statearr_25749_25767[(1)] = (4));

(statearr_25749_25767[(5)] = null);

} else {
throw ex25743;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (10))){
var inst_25707 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25708 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25709 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25710 = cljs.core.PersistentHashMap.fromArrays(inst_25708,inst_25709);
var inst_25711 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25707,inst_25710);
var inst_25712 = (function(){throw inst_25711})();
var state_25731__$1 = state_25731;
var statearr_25750_25768 = state_25731__$1;
(statearr_25750_25768[(2)] = inst_25712);

(statearr_25750_25768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (8))){
var inst_25700 = (state_25731[(9)]);
var state_25731__$1 = state_25731;
var statearr_25751_25769 = state_25731__$1;
(statearr_25751_25769[(2)] = inst_25700);

(statearr_25751_25769[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0 = (function (){
var statearr_25752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25752[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__);

(statearr_25752[(1)] = (1));

return statearr_25752;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1 = (function (state_25731){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25731);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25753){var ex__2730__auto__ = e25753;
var statearr_25754_25770 = state_25731;
(statearr_25754_25770[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25731[(4)]))){
var statearr_25755_25771 = state_25731;
(statearr_25755_25771[(1)] = cljs.core.first((state_25731[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25772 = state_25731;
state_25731 = G__25772;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = function(state_25731){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1.call(this,state_25731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25756 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25756[(6)] = c__2749__auto__);

return statearr_25756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25775 = arguments.length;
switch (G__25775) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25975){
var state_val_25976 = (state_25975[(1)]);
if((state_val_25976 === (7))){
var state_25975__$1 = state_25975;
var statearr_25977_26044 = state_25975__$1;
(statearr_25977_26044[(2)] = null);

(statearr_25977_26044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (20))){
var inst_25898 = (state_25975[(7)]);
var inst_25811 = (state_25975[(8)]);
var inst_25812 = (state_25975[(9)]);
var inst_25899 = (state_25975[(10)]);
var inst_25897 = (state_25975[(11)]);
var inst_25896 = (state_25975[(12)]);
var inst_25895 = (state_25975[(13)]);
var inst_25862 = (state_25975[(14)]);
var inst_25900 = (state_25975[(15)]);
var inst_25910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25911 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25912 = (new cljs.core.PersistentVector(null,2,(5),inst_25910,inst_25911,null));
var inst_25913 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25862,inst_25912);
var inst_25914 = (inst_25913 + inst_25811);
var inst_25915 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25916 = [inst_25895,inst_25896,inst_25897,inst_25898,inst_25899,inst_25914];
var inst_25917 = cljs.core.PersistentHashMap.fromArrays(inst_25915,inst_25916);
var inst_25918 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_25862,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25900,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25917], 0));
var state_25975__$1 = (function (){var statearr_25978 = state_25975;
(statearr_25978[(16)] = inst_25918);

return statearr_25978;
})();
if(cljs.core.truth_(inst_25812)){
var statearr_25979_26045 = state_25975__$1;
(statearr_25979_26045[(1)] = (23));

} else {
var statearr_25980_26046 = state_25975__$1;
(statearr_25980_26046[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (27))){
var inst_25918 = (state_25975[(16)]);
var state_25975__$1 = state_25975;
var statearr_25981_26047 = state_25975__$1;
(statearr_25981_26047[(2)] = inst_25918);

(statearr_25981_26047[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (1))){
var state_25975__$1 = state_25975;
var statearr_25982_26048 = state_25975__$1;
(statearr_25982_26048[(2)] = null);

(statearr_25982_26048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (24))){
var inst_25918 = (state_25975[(16)]);
var inst_25922 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25918);
var inst_25923 = (inst_25922 == null);
var state_25975__$1 = state_25975;
var statearr_25983_26049 = state_25975__$1;
(statearr_25983_26049[(2)] = inst_25923);

(statearr_25983_26049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (39))){
var inst_25899 = (state_25975[(10)]);
var inst_25948 = (state_25975[(17)]);
var inst_25906 = (state_25975[(18)]);
var inst_25907 = (state_25975[(19)]);
var inst_25957 = (state_25975[(20)]);
var inst_25949 = (state_25975[(21)]);
var inst_25950 = (state_25975[(22)]);
var inst_25964 = (state_25975[(2)]);
var inst_25965 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25899,inst_25906);
var inst_25894 = inst_25907;
var inst_25895 = inst_25949;
var inst_25896 = inst_25950;
var inst_25897 = inst_25957;
var inst_25898 = inst_25964;
var inst_25899__$1 = inst_25965;
var inst_25900 = inst_25948;
var state_25975__$1 = (function (){var statearr_25984 = state_25975;
(statearr_25984[(7)] = inst_25898);

(statearr_25984[(10)] = inst_25899__$1);

(statearr_25984[(11)] = inst_25897);

(statearr_25984[(23)] = inst_25894);

(statearr_25984[(12)] = inst_25896);

(statearr_25984[(13)] = inst_25895);

(statearr_25984[(15)] = inst_25900);

return statearr_25984;
})();
var statearr_25985_26050 = state_25975__$1;
(statearr_25985_26050[(2)] = null);

(statearr_25985_26050[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (4))){
var inst_25776 = (state_25975[(2)]);
var state_25975__$1 = state_25975;
var statearr_25986_26051 = state_25975__$1;
(statearr_25986_26051[(2)] = inst_25776);

(statearr_25986_26051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (15))){
var inst_25834 = (state_25975[(24)]);
var state_25975__$1 = state_25975;
var statearr_25987_26052 = state_25975__$1;
(statearr_25987_26052[(2)] = inst_25834);

(statearr_25987_26052[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (21))){
var inst_25871 = (state_25975[(25)]);
var inst_25802 = (state_25975[(26)]);
var inst_25898 = (state_25975[(7)]);
var inst_25872 = (state_25975[(27)]);
var inst_25811 = (state_25975[(8)]);
var inst_25810 = (state_25975[(28)]);
var inst_25812 = (state_25975[(9)]);
var inst_25783 = (state_25975[(29)]);
var inst_25899 = (state_25975[(10)]);
var inst_25897 = (state_25975[(11)]);
var inst_25821 = (state_25975[(30)]);
var inst_25798 = (state_25975[(31)]);
var inst_25813 = (state_25975[(32)]);
var inst_25894 = (state_25975[(23)]);
var inst_25896 = (state_25975[(12)]);
var inst_25906 = (state_25975[(18)]);
var inst_25907 = (state_25975[(19)]);
var inst_25806 = (state_25975[(33)]);
var inst_25799 = (state_25975[(34)]);
var inst_25895 = (state_25975[(13)]);
var inst_25815 = (state_25975[(35)]);
var inst_25862 = (state_25975[(14)]);
var inst_25900 = (state_25975[(15)]);
var inst_25945 = fluree.db.flake.s(inst_25906);
var inst_25946 = fluree.db.flake.sid__GT_cid(inst_25945);
var inst_25947 = (function (){var flakes_bytes = inst_25811;
var t = inst_25783;
var first__25869 = inst_25871;
var spot = inst_25895;
var add_flakes = inst_25799;
var root_setting_change_QMARK_ = inst_25813;
var seq__25903 = inst_25907;
var ref_QMARK__map = inst_25810;
var r = inst_25907;
var vec__25867 = inst_25799;
var psot = inst_25896;
var add_pred_to_idx_QMARK_ = inst_25821;
var _ = inst_25798;
var tspo = inst_25899;
var cid = inst_25946;
var ecount = inst_25900;
var pred_ecount = inst_25815;
var vec__25902 = inst_25894;
var db_STAR_ = inst_25862;
var system_change_QMARK_ = inst_25812;
var add_preds = inst_25802;
var opst = inst_25898;
var G__25866 = inst_25894;
var first__25904 = inst_25906;
var seq__25868 = inst_25872;
var idx_QMARK__map = inst_25806;
var post = inst_25897;
var f = inst_25906;
return (function (p1__25773_SHARP_){
if(cljs.core.truth_(p1__25773_SHARP_)){
var x__5130__auto__ = p1__25773_SHARP_;
var y__5131__auto__ = fluree.db.flake.s(f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s(f);
}
});
})();
var inst_25948 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_25900,inst_25946,inst_25947);
var inst_25949 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25895,inst_25906);
var inst_25950 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25896,inst_25906);
var inst_25951 = fluree.db.flake.p(inst_25906);
var inst_25952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25806,inst_25951);
var state_25975__$1 = (function (){var statearr_25988 = state_25975;
(statearr_25988[(17)] = inst_25948);

(statearr_25988[(21)] = inst_25949);

(statearr_25988[(22)] = inst_25950);

return statearr_25988;
})();
if(cljs.core.truth_(inst_25952)){
var statearr_25989_26053 = state_25975__$1;
(statearr_25989_26053[(1)] = (34));

} else {
var statearr_25990_26054 = state_25975__$1;
(statearr_25990_26054[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (31))){
var inst_25934 = (state_25975[(36)]);
var state_25975__$1 = state_25975;
var statearr_25991_26055 = state_25975__$1;
(statearr_25991_26055[(2)] = inst_25934);

(statearr_25991_26055[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (32))){
var inst_25943 = (state_25975[(2)]);
var state_25975__$1 = state_25975;
var statearr_25992_26056 = state_25975__$1;
(statearr_25992_26056[(2)] = inst_25943);

(statearr_25992_26056[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (33))){
var inst_25934 = (state_25975[(36)]);
var inst_25938 = (state_25975[(2)]);
var inst_25939 = fluree.db.util.async.throw_err(inst_25938);
var inst_25940 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25934,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25939);
var state_25975__$1 = state_25975;
var statearr_25993_26057 = state_25975__$1;
(statearr_25993_26057[(2)] = inst_25940);

(statearr_25993_26057[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (13))){
var inst_25811 = (state_25975[(8)]);
var inst_25783 = (state_25975[(29)]);
var inst_25799 = (state_25975[(34)]);
var inst_25862 = (state_25975[(14)]);
var inst_25852 = (state_25975[(2)]);
var inst_25853 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25852,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25783);
var inst_25854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25855 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25856 = (new cljs.core.PersistentVector(null,2,(5),inst_25854,inst_25855,null));
var inst_25857 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25853,inst_25856,cljs.core._PLUS_,inst_25811);
var inst_25858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25859 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25860 = (new cljs.core.PersistentVector(null,2,(5),inst_25858,inst_25859,null));
var inst_25861 = cljs.core.count(inst_25799);
var inst_25862__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25857,inst_25860,cljs.core._PLUS_,inst_25861);
var inst_25870 = cljs.core.seq(inst_25799);
var inst_25871 = cljs.core.first(inst_25870);
var inst_25872 = cljs.core.next(inst_25870);
var inst_25873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25874 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25875 = (new cljs.core.PersistentVector(null,2,(5),inst_25873,inst_25874,null));
var inst_25876 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25862__$1,inst_25875);
var inst_25877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25878 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25879 = (new cljs.core.PersistentVector(null,2,(5),inst_25877,inst_25878,null));
var inst_25880 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25862__$1,inst_25879);
var inst_25881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25882 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25883 = (new cljs.core.PersistentVector(null,2,(5),inst_25881,inst_25882,null));
var inst_25884 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25862__$1,inst_25883);
var inst_25885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25886 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25887 = (new cljs.core.PersistentVector(null,2,(5),inst_25885,inst_25886,null));
var inst_25888 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25862__$1,inst_25887);
var inst_25889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25890 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25891 = (new cljs.core.PersistentVector(null,2,(5),inst_25889,inst_25890,null));
var inst_25892 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25862__$1,inst_25891);
var inst_25893 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25894 = inst_25799;
var inst_25895 = inst_25876;
var inst_25896 = inst_25880;
var inst_25897 = inst_25884;
var inst_25898 = inst_25888;
var inst_25899 = inst_25892;
var inst_25900 = inst_25893;
var state_25975__$1 = (function (){var statearr_25994 = state_25975;
(statearr_25994[(25)] = inst_25871);

(statearr_25994[(7)] = inst_25898);

(statearr_25994[(27)] = inst_25872);

(statearr_25994[(10)] = inst_25899);

(statearr_25994[(11)] = inst_25897);

(statearr_25994[(23)] = inst_25894);

(statearr_25994[(12)] = inst_25896);

(statearr_25994[(13)] = inst_25895);

(statearr_25994[(14)] = inst_25862__$1);

(statearr_25994[(15)] = inst_25900);

return statearr_25994;
})();
var statearr_25995_26058 = state_25975__$1;
(statearr_25995_26058[(2)] = null);

(statearr_25995_26058[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (22))){
var inst_25968 = (state_25975[(2)]);
var state_25975__$1 = state_25975;
var statearr_25996_26059 = state_25975__$1;
(statearr_25996_26059[(2)] = inst_25968);

(statearr_25996_26059[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (36))){
var inst_25810 = (state_25975[(28)]);
var inst_25906 = (state_25975[(18)]);
var inst_25957 = (state_25975[(2)]);
var inst_25958 = fluree.db.flake.p(inst_25906);
var inst_25959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25810,inst_25958);
var state_25975__$1 = (function (){var statearr_25997 = state_25975;
(statearr_25997[(20)] = inst_25957);

return statearr_25997;
})();
if(cljs.core.truth_(inst_25959)){
var statearr_25998_26060 = state_25975__$1;
(statearr_25998_26060[(1)] = (37));

} else {
var statearr_25999_26061 = state_25975__$1;
(statearr_25999_26061[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (29))){
var inst_25918 = (state_25975[(16)]);
var inst_25929 = (state_25975[(2)]);
var inst_25930 = fluree.db.util.async.throw_err(inst_25929);
var inst_25931 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25918,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25930);
var state_25975__$1 = state_25975;
var statearr_26000_26062 = state_25975__$1;
(statearr_26000_26062[(2)] = inst_25931);

(statearr_26000_26062[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (6))){
var inst_25783 = (state_25975[(29)]);
var inst_25788 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25789 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25790 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25788)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25789)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25783),"."].join('');
var inst_25791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25792 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25793 = cljs.core.PersistentHashMap.fromArrays(inst_25791,inst_25792);
var inst_25794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25790,inst_25793);
var inst_25795 = (function(){throw inst_25794})();
var state_25975__$1 = state_25975;
var statearr_26001_26063 = state_25975__$1;
(statearr_26001_26063[(2)] = inst_25795);

(statearr_26001_26063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (28))){
var inst_25813 = (state_25975[(32)]);
var inst_25934 = (state_25975[(2)]);
var state_25975__$1 = (function (){var statearr_26002 = state_25975;
(statearr_26002[(36)] = inst_25934);

return statearr_26002;
})();
if(cljs.core.truth_(inst_25813)){
var statearr_26003_26064 = state_25975__$1;
(statearr_26003_26064[(1)] = (30));

} else {
var statearr_26004_26065 = state_25975__$1;
(statearr_26004_26065[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (25))){
var inst_25925 = (state_25975[(2)]);
var state_25975__$1 = state_25975;
if(cljs.core.truth_(inst_25925)){
var statearr_26005_26066 = state_25975__$1;
(statearr_26005_26066[(1)] = (26));

} else {
var statearr_26006_26067 = state_25975__$1;
(statearr_26006_26067[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (34))){
var inst_25897 = (state_25975[(11)]);
var inst_25906 = (state_25975[(18)]);
var inst_25954 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25897,inst_25906);
var state_25975__$1 = state_25975;
var statearr_26007_26068 = state_25975__$1;
(statearr_26007_26068[(2)] = inst_25954);

(statearr_26007_26068[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (17))){
var inst_25841 = (state_25975[(37)]);
var inst_25845 = (state_25975[(2)]);
var inst_25846 = fluree.db.util.async.throw_err(inst_25845);
var inst_25833 = inst_25841;
var inst_25834 = inst_25846;
var state_25975__$1 = (function (){var statearr_26008 = state_25975;
(statearr_26008[(38)] = inst_25833);

(statearr_26008[(24)] = inst_25834);

return statearr_26008;
})();
var statearr_26009_26069 = state_25975__$1;
(statearr_26009_26069[(2)] = null);

(statearr_26009_26069[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (3))){
var inst_25973 = (state_25975[(2)]);
var state_25975__$1 = state_25975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25975__$1,inst_25973);
} else {
if((state_val_25976 === (12))){
var inst_25840 = (state_25975[(39)]);
var inst_25833 = (state_25975[(38)]);
var inst_25839 = cljs.core.seq(inst_25833);
var inst_25840__$1 = cljs.core.first(inst_25839);
var inst_25841 = cljs.core.next(inst_25839);
var state_25975__$1 = (function (){var statearr_26010 = state_25975;
(statearr_26010[(39)] = inst_25840__$1);

(statearr_26010[(37)] = inst_25841);

return statearr_26010;
})();
if(cljs.core.truth_(inst_25840__$1)){
var statearr_26011_26070 = state_25975__$1;
(statearr_26011_26070[(1)] = (14));

} else {
var statearr_26012_26071 = state_25975__$1;
(statearr_26012_26071[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (2))){
var inst_25783 = (state_25975[(29)]);
var _ = (function (){var statearr_26013 = state_25975;
(statearr_26013[(4)] = cljs.core.cons((5),(state_25975[(4)])));

return statearr_26013;
})();
var inst_25782 = cljs.core.first(flakes);
var inst_25783__$1 = fluree.db.flake.t(inst_25782);
var inst_25784 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25785 = (inst_25784 - (1));
var inst_25786 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_25783__$1,inst_25785);
var state_25975__$1 = (function (){var statearr_26014 = state_25975;
(statearr_26014[(29)] = inst_25783__$1);

return statearr_26014;
})();
if(inst_25786){
var statearr_26015_26072 = state_25975__$1;
(statearr_26015_26072[(1)] = (6));

} else {
var statearr_26016_26073 = state_25975__$1;
(statearr_26016_26073[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (23))){
var inst_25812 = (state_25975[(9)]);
var state_25975__$1 = state_25975;
var statearr_26017_26074 = state_25975__$1;
(statearr_26017_26074[(2)] = inst_25812);

(statearr_26017_26074[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (35))){
var inst_25897 = (state_25975[(11)]);
var state_25975__$1 = state_25975;
var statearr_26018_26075 = state_25975__$1;
(statearr_26018_26075[(2)] = inst_25897);

(statearr_26018_26075[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (19))){
var inst_25970 = (state_25975[(2)]);
var _ = (function (){var statearr_26019 = state_25975;
(statearr_26019[(4)] = cljs.core.rest((state_25975[(4)])));

return statearr_26019;
})();
var state_25975__$1 = state_25975;
var statearr_26020_26076 = state_25975__$1;
(statearr_26020_26076[(2)] = inst_25970);

(statearr_26020_26076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (11))){
var inst_25821 = (state_25975[(30)]);
var inst_25821__$1 = (state_25975[(2)]);
var inst_25829 = cljs.core.seq(inst_25821__$1);
var inst_25830 = cljs.core.first(inst_25829);
var inst_25831 = cljs.core.next(inst_25829);
var inst_25832 = db;
var inst_25833 = inst_25821__$1;
var inst_25834 = inst_25832;
var state_25975__$1 = (function (){var statearr_26022 = state_25975;
(statearr_26022[(30)] = inst_25821__$1);

(statearr_26022[(38)] = inst_25833);

(statearr_26022[(40)] = inst_25830);

(statearr_26022[(41)] = inst_25831);

(statearr_26022[(24)] = inst_25834);

return statearr_26022;
})();
var statearr_26023_26077 = state_25975__$1;
(statearr_26023_26077[(2)] = null);

(statearr_26023_26077[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (9))){
var inst_25799 = (state_25975[(34)]);
var inst_25815 = (state_25975[(35)]);
var inst_25817 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_25799,inst_25815);
var state_25975__$1 = state_25975;
var statearr_26024_26078 = state_25975__$1;
(statearr_26024_26078[(2)] = inst_25817);

(statearr_26024_26078[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (5))){
var _ = (function (){var statearr_26025 = state_25975;
(statearr_26025[(4)] = cljs.core.rest((state_25975[(4)])));

return statearr_26025;
})();
var state_25975__$1 = state_25975;
var ex26021 = (state_25975__$1[(2)]);
var statearr_26026_26079 = state_25975__$1;
(statearr_26026_26079[(5)] = ex26021);


if((ex26021 instanceof Error)){
var statearr_26027_26080 = state_25975__$1;
(statearr_26027_26080[(1)] = (4));

(statearr_26027_26080[(5)] = null);

} else {
throw ex26021;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (14))){
var inst_25840 = (state_25975[(39)]);
var inst_25834 = (state_25975[(24)]);
var inst_25843 = fluree.db.graphdb.add_predicate_to_idx(inst_25834,inst_25840,opts);
var state_25975__$1 = state_25975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25975__$1,(17),inst_25843);
} else {
if((state_val_25976 === (26))){
var inst_25918 = (state_25975[(16)]);
var inst_25927 = fluree.db.query.schema.schema_map(inst_25918);
var state_25975__$1 = state_25975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25975__$1,(29),inst_25927);
} else {
if((state_val_25976 === (16))){
var inst_25850 = (state_25975[(2)]);
var state_25975__$1 = state_25975;
var statearr_26028_26081 = state_25975__$1;
(statearr_26028_26081[(2)] = inst_25850);

(statearr_26028_26081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (38))){
var inst_25898 = (state_25975[(7)]);
var state_25975__$1 = state_25975;
var statearr_26029_26082 = state_25975__$1;
(statearr_26029_26082[(2)] = inst_25898);

(statearr_26029_26082[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (30))){
var inst_25918 = (state_25975[(16)]);
var inst_25936 = fluree.db.query.schema.setting_map(inst_25918);
var state_25975__$1 = state_25975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25975__$1,(33),inst_25936);
} else {
if((state_val_25976 === (10))){
var inst_25819 = cljs.core.PersistentVector.EMPTY;
var state_25975__$1 = state_25975;
var statearr_26030_26083 = state_25975__$1;
(statearr_26030_26083[(2)] = inst_25819);

(statearr_26030_26083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (18))){
var inst_25894 = (state_25975[(23)]);
var inst_25906 = (state_25975[(18)]);
var inst_25905 = cljs.core.seq(inst_25894);
var inst_25906__$1 = cljs.core.first(inst_25905);
var inst_25907 = cljs.core.next(inst_25905);
var inst_25908 = cljs.core.not(inst_25906__$1);
var state_25975__$1 = (function (){var statearr_26031 = state_25975;
(statearr_26031[(18)] = inst_25906__$1);

(statearr_26031[(19)] = inst_25907);

return statearr_26031;
})();
if(inst_25908){
var statearr_26032_26084 = state_25975__$1;
(statearr_26032_26084[(1)] = (20));

} else {
var statearr_26033_26085 = state_25975__$1;
(statearr_26033_26085[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (37))){
var inst_25898 = (state_25975[(7)]);
var inst_25906 = (state_25975[(18)]);
var inst_25961 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25898,inst_25906);
var state_25975__$1 = state_25975;
var statearr_26034_26086 = state_25975__$1;
(statearr_26034_26086[(2)] = inst_25961);

(statearr_26034_26086[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25976 === (8))){
var inst_25802 = (state_25975[(26)]);
var inst_25812 = (state_25975[(9)]);
var inst_25783 = (state_25975[(29)]);
var inst_25798 = (state_25975[(31)]);
var inst_25806 = (state_25975[(33)]);
var inst_25799 = (state_25975[(34)]);
var inst_25798__$1 = (state_25975[(2)]);
var inst_25799__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25800 = cljs.core.PersistentHashSet.EMPTY;
var inst_25801 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,inst_25799__$1);
var inst_25802__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25800,inst_25801);
var inst_25803 = cljs.core.PersistentHashMap.EMPTY;
var inst_25804 = (function (){var t = inst_25783;
var _ = inst_25798__$1;
var add_flakes = inst_25799__$1;
var add_preds = inst_25802__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25805 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25804,inst_25802__$1);
var inst_25806__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25803,inst_25805);
var inst_25807 = cljs.core.PersistentHashMap.EMPTY;
var inst_25808 = (function (){var t = inst_25783;
var _ = inst_25798__$1;
var add_flakes = inst_25799__$1;
var add_preds = inst_25802__$1;
var idx_QMARK__map = inst_25806__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25809 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25808,inst_25802__$1);
var inst_25810 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25807,inst_25809);
var inst_25811 = fluree.db.flake.size_bytes(inst_25799__$1);
var inst_25812__$1 = fluree.db.util.schema.system_change_QMARK_(inst_25799__$1);
var inst_25813 = fluree.db.util.schema.setting_change_QMARK_(inst_25799__$1);
var inst_25814 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25814,(0));
var state_25975__$1 = (function (){var statearr_26035 = state_25975;
(statearr_26035[(26)] = inst_25802__$1);

(statearr_26035[(8)] = inst_25811);

(statearr_26035[(28)] = inst_25810);

(statearr_26035[(9)] = inst_25812__$1);

(statearr_26035[(31)] = inst_25798__$1);

(statearr_26035[(32)] = inst_25813);

(statearr_26035[(33)] = inst_25806__$1);

(statearr_26035[(34)] = inst_25799__$1);

(statearr_26035[(35)] = inst_25815);

return statearr_26035;
})();
if(cljs.core.truth_(inst_25812__$1)){
var statearr_26036_26087 = state_25975__$1;
(statearr_26036_26087[(1)] = (9));

} else {
var statearr_26037_26088 = state_25975__$1;
(statearr_26037_26088[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26038[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26038[(1)] = (1));

return statearr_26038;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25975){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25975);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26039){var ex__2730__auto__ = e26039;
var statearr_26040_26089 = state_25975;
(statearr_26040_26089[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25975[(4)]))){
var statearr_26041_26090 = state_25975;
(statearr_26041_26090[(1)] = cljs.core.first((state_25975[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26091 = state_25975;
state_25975 = G__26091;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25975){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26042 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26042[(6)] = c__2749__auto__);

return statearr_26042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26093 = arguments.length;
switch (G__26093) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___26240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26189){
var state_val_26190 = (state_26189[(1)]);
if((state_val_26190 === (7))){
var state_26189__$1 = state_26189;
var statearr_26191_26241 = state_26189__$1;
(statearr_26191_26241[(2)] = null);

(statearr_26191_26241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (20))){
var inst_26138 = (state_26189[(7)]);
var inst_26139 = (state_26189[(8)]);
var inst_26137 = (state_26189[(9)]);
var inst_26158 = (inst_26137 + (1));
var inst_26159 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26139,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26158);
var inst_26160 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_26159,inst_26138,opts);
var state_26189__$1 = state_26189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26189__$1,(23),inst_26160);
} else {
if((state_val_26190 === (1))){
var state_26189__$1 = state_26189;
var statearr_26192_26242 = state_26189__$1;
(statearr_26192_26242[(2)] = null);

(statearr_26192_26242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (24))){
var inst_26163 = (state_26189[(10)]);
var inst_26166 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26163,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26189__$1 = state_26189;
var statearr_26193_26243 = state_26189__$1;
(statearr_26193_26243[(2)] = inst_26166);

(statearr_26193_26243[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (4))){
var inst_26094 = (state_26189[(2)]);
var inst_26095 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26094);
var state_26189__$1 = state_26189;
var statearr_26194_26244 = state_26189__$1;
(statearr_26194_26244[(2)] = inst_26095);

(statearr_26194_26244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (15))){
var inst_26145 = (state_26189[(11)]);
var state_26189__$1 = state_26189;
var statearr_26195_26245 = state_26189__$1;
(statearr_26195_26245[(2)] = inst_26145);

(statearr_26195_26245[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (21))){
var state_26189__$1 = state_26189;
var statearr_26196_26246 = state_26189__$1;
(statearr_26196_26246[(2)] = null);

(statearr_26196_26246[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (13))){
var inst_26181 = (state_26189[(2)]);
var inst_26182 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26181);
var state_26189__$1 = state_26189;
var statearr_26197_26247 = state_26189__$1;
(statearr_26197_26247[(2)] = inst_26182);

(statearr_26197_26247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (22))){
var inst_26177 = (state_26189[(2)]);
var state_26189__$1 = state_26189;
var statearr_26198_26248 = state_26189__$1;
(statearr_26198_26248[(2)] = inst_26177);

(statearr_26198_26248[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (6))){
var inst_26105 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26106 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26107 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26105)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26106)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26108 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26109 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26110 = cljs.core.PersistentHashMap.fromArrays(inst_26108,inst_26109);
var inst_26111 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26107,inst_26110);
var inst_26112 = (function(){throw inst_26111})();
var state_26189__$1 = state_26189;
var statearr_26201_26249 = state_26189__$1;
(statearr_26201_26249[(2)] = inst_26112);

(statearr_26201_26249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (25))){
var inst_26146 = (state_26189[(12)]);
var inst_26163 = (state_26189[(10)]);
var inst_26145 = (state_26189[(11)]);
var inst_26168 = fluree.db.flake.t(inst_26145);
var inst_26169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26170 = [inst_26145];
var inst_26171 = (new cljs.core.PersistentVector(null,1,(5),inst_26169,inst_26170,null));
var inst_26136 = inst_26146;
var inst_26137 = inst_26168;
var inst_26138 = inst_26171;
var inst_26139 = inst_26163;
var state_26189__$1 = (function (){var statearr_26202 = state_26189;
(statearr_26202[(7)] = inst_26138);

(statearr_26202[(8)] = inst_26139);

(statearr_26202[(9)] = inst_26137);

(statearr_26202[(13)] = inst_26136);

return statearr_26202;
})();
var statearr_26203_26250 = state_26189__$1;
(statearr_26203_26250[(2)] = null);

(statearr_26203_26250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (17))){
var inst_26138 = (state_26189[(7)]);
var inst_26139 = (state_26189[(8)]);
var inst_26146 = (state_26189[(12)]);
var inst_26137 = (state_26189[(9)]);
var inst_26145 = (state_26189[(11)]);
var inst_26154 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26138,inst_26145);
var tmp26199 = inst_26139;
var tmp26200 = inst_26137;
var inst_26136 = inst_26146;
var inst_26137__$1 = tmp26200;
var inst_26138__$1 = inst_26154;
var inst_26139__$1 = tmp26199;
var state_26189__$1 = (function (){var statearr_26204 = state_26189;
(statearr_26204[(7)] = inst_26138__$1);

(statearr_26204[(8)] = inst_26139__$1);

(statearr_26204[(9)] = inst_26137__$1);

(statearr_26204[(13)] = inst_26136);

return statearr_26204;
})();
var statearr_26205_26251 = state_26189__$1;
(statearr_26205_26251[(2)] = null);

(statearr_26205_26251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (3))){
var inst_26187 = (state_26189[(2)]);
var state_26189__$1 = state_26189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26189__$1,inst_26187);
} else {
if((state_val_26190 === (12))){
var inst_26136 = (state_26189[(13)]);
var inst_26145 = (state_26189[(11)]);
var inst_26144 = cljs.core.seq(inst_26136);
var inst_26145__$1 = cljs.core.first(inst_26144);
var inst_26146 = cljs.core.next(inst_26144);
var state_26189__$1 = (function (){var statearr_26206 = state_26189;
(statearr_26206[(12)] = inst_26146);

(statearr_26206[(11)] = inst_26145__$1);

return statearr_26206;
})();
if(cljs.core.truth_(inst_26145__$1)){
var statearr_26207_26252 = state_26189__$1;
(statearr_26207_26252[(1)] = (14));

} else {
var statearr_26208_26253 = state_26189__$1;
(statearr_26208_26253[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (2))){
var _ = (function (){var statearr_26209 = state_26189;
(statearr_26209[(4)] = cljs.core.cons((5),(state_26189[(4)])));

return statearr_26209;
})();
var inst_26101 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26102 = (inst_26101 + (1));
var inst_26103 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26102);
var state_26189__$1 = state_26189;
if(inst_26103){
var statearr_26210_26254 = state_26189__$1;
(statearr_26210_26254[(1)] = (6));

} else {
var statearr_26211_26255 = state_26189__$1;
(statearr_26211_26255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (23))){
var inst_26145 = (state_26189[(11)]);
var inst_26162 = (state_26189[(2)]);
var inst_26163 = fluree.db.util.async.throw_err(inst_26162);
var inst_26164 = (inst_26145 == null);
var state_26189__$1 = (function (){var statearr_26212 = state_26189;
(statearr_26212[(10)] = inst_26163);

return statearr_26212;
})();
if(cljs.core.truth_(inst_26164)){
var statearr_26213_26256 = state_26189__$1;
(statearr_26213_26256[(1)] = (24));

} else {
var statearr_26214_26257 = state_26189__$1;
(statearr_26214_26257[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (19))){
var inst_26179 = (state_26189[(2)]);
var state_26189__$1 = state_26189;
var statearr_26215_26258 = state_26189__$1;
(statearr_26215_26258[(2)] = inst_26179);

(statearr_26215_26258[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (11))){
var inst_26184 = (state_26189[(2)]);
var _ = (function (){var statearr_26217 = state_26189;
(statearr_26217[(4)] = cljs.core.rest((state_26189[(4)])));

return statearr_26217;
})();
var state_26189__$1 = state_26189;
var statearr_26218_26259 = state_26189__$1;
(statearr_26218_26259[(2)] = inst_26184);

(statearr_26218_26259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (9))){
var inst_26118 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26119 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26118);
var state_26189__$1 = state_26189;
var statearr_26219_26260 = state_26189__$1;
(statearr_26219_26260[(2)] = inst_26119);

(statearr_26219_26260[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (5))){
var _ = (function (){var statearr_26220 = state_26189;
(statearr_26220[(4)] = cljs.core.rest((state_26189[(4)])));

return statearr_26220;
})();
var state_26189__$1 = state_26189;
var ex26216 = (state_26189__$1[(2)]);
var statearr_26221_26261 = state_26189__$1;
(statearr_26221_26261[(5)] = ex26216);


var statearr_26222_26262 = state_26189__$1;
(statearr_26222_26262[(1)] = (4));

(statearr_26222_26262[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (14))){
var inst_26137 = (state_26189[(9)]);
var inst_26145 = (state_26189[(11)]);
var inst_26148 = fluree.db.flake.t(inst_26145);
var inst_26149 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26137,inst_26148);
var state_26189__$1 = state_26189;
var statearr_26223_26263 = state_26189__$1;
(statearr_26223_26263[(2)] = inst_26149);

(statearr_26223_26263[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (26))){
var inst_26174 = (state_26189[(2)]);
var state_26189__$1 = state_26189;
var statearr_26224_26264 = state_26189__$1;
(statearr_26224_26264[(2)] = inst_26174);

(statearr_26224_26264[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (16))){
var inst_26152 = (state_26189[(2)]);
var state_26189__$1 = state_26189;
if(cljs.core.truth_(inst_26152)){
var statearr_26225_26265 = state_26189__$1;
(statearr_26225_26265[(1)] = (17));

} else {
var statearr_26226_26266 = state_26189__$1;
(statearr_26226_26266[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (10))){
var inst_26121 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26129 = cljs.core.seq(inst_26121);
var inst_26130 = cljs.core.first(inst_26129);
var inst_26131 = cljs.core.next(inst_26129);
var inst_26132 = cljs.core.first(inst_26121);
var inst_26133 = fluree.db.flake.t(inst_26132);
var inst_26134 = cljs.core.PersistentVector.EMPTY;
var inst_26135 = db;
var inst_26136 = inst_26121;
var inst_26137 = inst_26133;
var inst_26138 = inst_26134;
var inst_26139 = inst_26135;
var state_26189__$1 = (function (){var statearr_26227 = state_26189;
(statearr_26227[(7)] = inst_26138);

(statearr_26227[(14)] = inst_26131);

(statearr_26227[(8)] = inst_26139);

(statearr_26227[(9)] = inst_26137);

(statearr_26227[(15)] = inst_26130);

(statearr_26227[(13)] = inst_26136);

return statearr_26227;
})();
var statearr_26228_26267 = state_26189__$1;
(statearr_26228_26267[(2)] = null);

(statearr_26228_26267[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (18))){
var state_26189__$1 = state_26189;
var statearr_26229_26268 = state_26189__$1;
(statearr_26229_26268[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26190 === (8))){
var inst_26115 = (state_26189[(2)]);
var inst_26116 = cljs.core.empty_QMARK_(flakes);
var state_26189__$1 = (function (){var statearr_26231 = state_26189;
(statearr_26231[(16)] = inst_26115);

return statearr_26231;
})();
if(inst_26116){
var statearr_26232_26269 = state_26189__$1;
(statearr_26232_26269[(1)] = (9));

} else {
var statearr_26233_26270 = state_26189__$1;
(statearr_26233_26270[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26234 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26234[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26234[(1)] = (1));

return statearr_26234;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26189){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26189);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26235){var ex__2730__auto__ = e26235;
var statearr_26236_26271 = state_26189;
(statearr_26236_26271[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26189[(4)]))){
var statearr_26237_26272 = state_26189;
(statearr_26237_26272[(1)] = cljs.core.first((state_26189[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26273 = state_26189;
state_26189 = G__26273;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26189){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26238 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26238[(6)] = c__2749__auto___26240);

return statearr_26238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26325){
var state_val_26326 = (state_26325[(1)]);
if((state_val_26326 === (7))){
var state_26325__$1 = state_26325;
var statearr_26327_26354 = state_26325__$1;
(statearr_26327_26354[(2)] = tt_id);

(statearr_26327_26354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (1))){
var state_26325__$1 = state_26325;
var statearr_26328_26355 = state_26325__$1;
(statearr_26328_26355[(2)] = null);

(statearr_26328_26355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (4))){
var inst_26274 = (state_26325[(2)]);
var state_26325__$1 = state_26325;
var statearr_26329_26356 = state_26325__$1;
(statearr_26329_26356[(2)] = inst_26274);

(statearr_26329_26356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (13))){
var inst_26318 = (state_26325[(2)]);
var state_26325__$1 = state_26325;
var statearr_26330_26357 = state_26325__$1;
(statearr_26330_26357[(2)] = inst_26318);

(statearr_26330_26357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (6))){
var inst_26282 = cljs.core.random_uuid();
var state_26325__$1 = state_26325;
var statearr_26331_26358 = state_26325__$1;
(statearr_26331_26358[(2)] = inst_26282);

(statearr_26331_26358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (3))){
var inst_26323 = (state_26325[(2)]);
var state_26325__$1 = state_26325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26325__$1,inst_26323);
} else {
if((state_val_26326 === (12))){
var inst_26301 = (state_26325[(7)]);
var state_26325__$1 = state_26325;
var statearr_26332_26359 = state_26325__$1;
(statearr_26332_26359[(2)] = inst_26301);

(statearr_26332_26359[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (2))){
var _ = (function (){var statearr_26333 = state_26325;
(statearr_26333[(4)] = cljs.core.cons((5),(state_26325[(4)])));

return statearr_26333;
})();
var inst_26280 = (tt_id == null);
var state_26325__$1 = state_26325;
if(cljs.core.truth_(inst_26280)){
var statearr_26334_26360 = state_26325__$1;
(statearr_26334_26360[(1)] = (6));

} else {
var statearr_26335_26361 = state_26325__$1;
(statearr_26335_26361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (11))){
var inst_26301 = (state_26325[(7)]);
var inst_26308 = (state_26325[(8)]);
var inst_26311 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_26301,inst_26308);
var state_26325__$1 = state_26325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26325__$1,(14),inst_26311);
} else {
if((state_val_26326 === (9))){
var inst_26308 = (state_26325[(8)]);
var inst_26302 = (state_26325[(9)]);
var inst_26307 = cljs.core.seq(inst_26302);
var inst_26308__$1 = cljs.core.first(inst_26307);
var inst_26309 = cljs.core.next(inst_26307);
var state_26325__$1 = (function (){var statearr_26337 = state_26325;
(statearr_26337[(8)] = inst_26308__$1);

(statearr_26337[(10)] = inst_26309);

return statearr_26337;
})();
if(cljs.core.truth_(inst_26308__$1)){
var statearr_26338_26362 = state_26325__$1;
(statearr_26338_26362[(1)] = (11));

} else {
var statearr_26339_26363 = state_26325__$1;
(statearr_26339_26363[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (5))){
var _ = (function (){var statearr_26340 = state_26325;
(statearr_26340[(4)] = cljs.core.rest((state_26325[(4)])));

return statearr_26340;
})();
var state_26325__$1 = state_26325;
var ex26336 = (state_26325__$1[(2)]);
var statearr_26341_26364 = state_26325__$1;
(statearr_26341_26364[(5)] = ex26336);


if((ex26336 instanceof Error)){
var statearr_26342_26365 = state_26325__$1;
(statearr_26342_26365[(1)] = (4));

(statearr_26342_26365[(5)] = null);

} else {
throw ex26336;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (14))){
var inst_26309 = (state_26325[(10)]);
var inst_26313 = (state_26325[(2)]);
var inst_26314 = fluree.db.util.async.throw_err(inst_26313);
var inst_26301 = inst_26314;
var inst_26302 = inst_26309;
var state_26325__$1 = (function (){var statearr_26343 = state_26325;
(statearr_26343[(7)] = inst_26301);

(statearr_26343[(9)] = inst_26302);

return statearr_26343;
})();
var statearr_26344_26366 = state_26325__$1;
(statearr_26344_26366[(2)] = null);

(statearr_26344_26366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (10))){
var inst_26320 = (state_26325[(2)]);
var _ = (function (){var statearr_26345 = state_26325;
(statearr_26345[(4)] = cljs.core.rest((state_26325[(4)])));

return statearr_26345;
})();
var state_26325__$1 = state_26325;
var statearr_26346_26367 = state_26325__$1;
(statearr_26346_26367[(2)] = inst_26320);

(statearr_26346_26367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26326 === (8))){
var inst_26285 = (state_26325[(2)]);
var inst_26286 = (function (){var tt_id__$1 = inst_26285;
return (function (db_STAR_,idx){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26287 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26285);
var inst_26288 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26286,inst_26287,fluree.db.index.types);
var inst_26289 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26290 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26289);
var inst_26298 = cljs.core.seq(inst_26290);
var inst_26299 = cljs.core.first(inst_26298);
var inst_26300 = cljs.core.next(inst_26298);
var inst_26301 = inst_26288;
var inst_26302 = inst_26290;
var state_26325__$1 = (function (){var statearr_26347 = state_26325;
(statearr_26347[(7)] = inst_26301);

(statearr_26347[(11)] = inst_26299);

(statearr_26347[(12)] = inst_26300);

(statearr_26347[(9)] = inst_26302);

return statearr_26347;
})();
var statearr_26348_26368 = state_26325__$1;
(statearr_26348_26368[(2)] = null);

(statearr_26348_26368[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0 = (function (){
var statearr_26349 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26349[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__);

(statearr_26349[(1)] = (1));

return statearr_26349;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1 = (function (state_26325){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26325);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26350){var ex__2730__auto__ = e26350;
var statearr_26351_26369 = state_26325;
(statearr_26351_26369[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26325[(4)]))){
var statearr_26352_26370 = state_26325;
(statearr_26352_26370[(1)] = cljs.core.first((state_26325[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26371 = state_26325;
state_26325 = G__26371;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = function(state_26325){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1.call(this,state_26325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26353 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26353[(6)] = c__2749__auto__);

return statearr_26353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___26558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26489){
var state_val_26490 = (state_26489[(1)]);
if((state_val_26490 === (7))){
var inst_26399 = (state_26489[(7)]);
var inst_26399__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26489__$1 = (function (){var statearr_26491 = state_26489;
(statearr_26491[(7)] = inst_26399__$1);

return statearr_26491;
})();
if(inst_26399__$1){
var statearr_26492_26559 = state_26489__$1;
(statearr_26492_26559[(1)] = (13));

} else {
var statearr_26493_26560 = state_26489__$1;
(statearr_26493_26560[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (20))){
var state_26489__$1 = state_26489;
var statearr_26494_26561 = state_26489__$1;
(statearr_26494_26561[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (27))){
var inst_26435 = (state_26489[(8)]);
var inst_26439 = fluree.db.flake.s(inst_26435);
var state_26489__$1 = state_26489;
var statearr_26496_26562 = state_26489__$1;
(statearr_26496_26562[(2)] = inst_26439);

(statearr_26496_26562[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (1))){
var state_26489__$1 = state_26489;
var statearr_26497_26563 = state_26489__$1;
(statearr_26497_26563[(2)] = null);

(statearr_26497_26563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (24))){
var inst_26429 = (state_26489[(9)]);
var inst_26433 = cljs.core.first(inst_26429);
var state_26489__$1 = state_26489;
var statearr_26498_26564 = state_26489__$1;
(statearr_26498_26564[(2)] = inst_26433);

(statearr_26498_26564[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (39))){
var state_26489__$1 = state_26489;
var statearr_26499_26565 = state_26489__$1;
(statearr_26499_26565[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (4))){
var inst_26372 = (state_26489[(2)]);
var inst_26373 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26374 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26375 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26376 = cljs.core.PersistentHashMap.fromArrays(inst_26374,inst_26375);
var inst_26377 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_26373,inst_26376,inst_26372);
var inst_26378 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26377);
var state_26489__$1 = state_26489;
var statearr_26501_26566 = state_26489__$1;
(statearr_26501_26566[(2)] = inst_26378);

(statearr_26501_26566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (15))){
var inst_26406 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
if(cljs.core.truth_(inst_26406)){
var statearr_26502_26567 = state_26489__$1;
(statearr_26502_26567[(1)] = (16));

} else {
var statearr_26503_26568 = state_26489__$1;
(statearr_26503_26568[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (21))){
var inst_26455 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26504_26569 = state_26489__$1;
(statearr_26504_26569[(2)] = inst_26455);

(statearr_26504_26569[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (31))){
var inst_26453 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26505_26570 = state_26489__$1;
(statearr_26505_26570[(2)] = inst_26453);

(statearr_26505_26570[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (32))){
var inst_26459 = (state_26489[(10)]);
var inst_26461 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26459);
var state_26489__$1 = state_26489;
var statearr_26506_26571 = state_26489__$1;
(statearr_26506_26571[(2)] = inst_26461);

(statearr_26506_26571[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (40))){
var inst_26482 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26507_26572 = state_26489__$1;
(statearr_26507_26572[(2)] = inst_26482);

(statearr_26507_26572[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (33))){
var inst_26463 = (state_26489[(11)]);
var inst_26459 = (state_26489[(10)]);
var inst_26463__$1 = (inst_26459 == null);
var state_26489__$1 = (function (){var statearr_26508 = state_26489;
(statearr_26508[(11)] = inst_26463__$1);

return statearr_26508;
})();
if(cljs.core.truth_(inst_26463__$1)){
var statearr_26509_26573 = state_26489__$1;
(statearr_26509_26573[(1)] = (35));

} else {
var statearr_26510_26574 = state_26489__$1;
(statearr_26510_26574[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (13))){
var inst_26401 = cljs.core.first(ident);
var inst_26402 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26401);
var inst_26403 = (inst_26402 == null);
var state_26489__$1 = state_26489;
var statearr_26511_26575 = state_26489__$1;
(statearr_26511_26575[(2)] = inst_26403);

(statearr_26511_26575[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (22))){
var inst_26429 = (state_26489[(9)]);
var inst_26428 = (state_26489[(2)]);
var inst_26429__$1 = fluree.db.util.async.throw_err(inst_26428);
var inst_26430 = (inst_26429__$1 == null);
var state_26489__$1 = (function (){var statearr_26512 = state_26489;
(statearr_26512[(9)] = inst_26429__$1);

return statearr_26512;
})();
if(cljs.core.truth_(inst_26430)){
var statearr_26513_26576 = state_26489__$1;
(statearr_26513_26576[(1)] = (23));

} else {
var statearr_26514_26577 = state_26489__$1;
(statearr_26514_26577[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (36))){
var inst_26463 = (state_26489[(11)]);
var state_26489__$1 = state_26489;
var statearr_26515_26578 = state_26489__$1;
(statearr_26515_26578[(2)] = inst_26463);

(statearr_26515_26578[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (41))){
var inst_26477 = cljs.core.async.close_BANG_(return_chan);
var state_26489__$1 = state_26489;
var statearr_26516_26579 = state_26489__$1;
(statearr_26516_26579[(2)] = inst_26477);

(statearr_26516_26579[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (43))){
var inst_26480 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26517_26580 = state_26489__$1;
(statearr_26517_26580[(2)] = inst_26480);

(statearr_26517_26580[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (29))){
var inst_26444 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_26445 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26444].join('');
var inst_26446 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26447 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26448 = cljs.core.PersistentHashMap.fromArrays(inst_26446,inst_26447);
var inst_26449 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26445,inst_26448);
var inst_26450 = (function(){throw inst_26449})();
var state_26489__$1 = state_26489;
var statearr_26518_26581 = state_26489__$1;
(statearr_26518_26581[(2)] = inst_26450);

(statearr_26518_26581[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (6))){
var inst_26386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26387 = [ident];
var inst_26388 = (new cljs.core.PersistentVector(null,1,(5),inst_26386,inst_26387,null));
var inst_26389 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26388);
var state_26489__$1 = state_26489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26489__$1,(9),inst_26389);
} else {
if((state_val_26490 === (28))){
var inst_26441 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26519_26582 = state_26489__$1;
(statearr_26519_26582[(2)] = inst_26441);

(statearr_26519_26582[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (25))){
var inst_26435 = (state_26489[(8)]);
var inst_26435__$1 = (state_26489[(2)]);
var inst_26436 = (inst_26435__$1 == null);
var state_26489__$1 = (function (){var statearr_26520 = state_26489;
(statearr_26520[(8)] = inst_26435__$1);

return statearr_26520;
})();
if(cljs.core.truth_(inst_26436)){
var statearr_26521_26583 = state_26489__$1;
(statearr_26521_26583[(1)] = (26));

} else {
var statearr_26522_26584 = state_26489__$1;
(statearr_26522_26584[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (34))){
var inst_26484 = (state_26489[(2)]);
var _ = (function (){var statearr_26523 = state_26489;
(statearr_26523[(4)] = cljs.core.rest((state_26489[(4)])));

return statearr_26523;
})();
var state_26489__$1 = state_26489;
var statearr_26524_26585 = state_26489__$1;
(statearr_26524_26585[(2)] = inst_26484);

(statearr_26524_26585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (17))){
var inst_26417 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26489__$1 = state_26489;
if(inst_26417){
var statearr_26525_26586 = state_26489__$1;
(statearr_26525_26586[(1)] = (19));

} else {
var statearr_26526_26587 = state_26489__$1;
(statearr_26526_26587[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (3))){
var inst_26487 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26489__$1,inst_26487);
} else {
if((state_val_26490 === (12))){
var inst_26397 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26527_26588 = state_26489__$1;
(statearr_26527_26588[(2)] = inst_26397);

(statearr_26527_26588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (2))){
var _ = (function (){var statearr_26528 = state_26489;
(statearr_26528[(4)] = cljs.core.cons((5),(state_26489[(4)])));

return statearr_26528;
})();
var inst_26384 = typeof ident === 'number';
var state_26489__$1 = state_26489;
if(cljs.core.truth_(inst_26384)){
var statearr_26529_26589 = state_26489__$1;
(statearr_26529_26589[(1)] = (6));

} else {
var statearr_26530_26590 = state_26489__$1;
(statearr_26530_26590[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (23))){
var state_26489__$1 = state_26489;
var statearr_26531_26591 = state_26489__$1;
(statearr_26531_26591[(2)] = null);

(statearr_26531_26591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (35))){
var state_26489__$1 = state_26489;
var statearr_26532_26592 = state_26489__$1;
(statearr_26532_26592[(2)] = strict_QMARK_);

(statearr_26532_26592[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (19))){
var inst_26420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26421 = cljs.core.first(ident);
var inst_26422 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26421);
var inst_26423 = cljs.core.second(ident);
var inst_26424 = [inst_26422,inst_26423];
var inst_26425 = (new cljs.core.PersistentVector(null,2,(5),inst_26420,inst_26424,null));
var inst_26426 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26425);
var state_26489__$1 = state_26489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26489__$1,(22),inst_26426);
} else {
if((state_val_26490 === (11))){
var state_26489__$1 = state_26489;
var statearr_26534_26593 = state_26489__$1;
(statearr_26534_26593[(2)] = null);

(statearr_26534_26593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (9))){
var inst_26391 = (state_26489[(2)]);
var inst_26392 = fluree.db.util.async.throw_err(inst_26391);
var inst_26393 = cljs.core.not_empty(inst_26392);
var state_26489__$1 = state_26489;
if(cljs.core.truth_(inst_26393)){
var statearr_26535_26594 = state_26489__$1;
(statearr_26535_26594[(1)] = (10));

} else {
var statearr_26536_26595 = state_26489__$1;
(statearr_26536_26595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (5))){
var _ = (function (){var statearr_26537 = state_26489;
(statearr_26537[(4)] = cljs.core.rest((state_26489[(4)])));

return statearr_26537;
})();
var state_26489__$1 = state_26489;
var ex26533 = (state_26489__$1[(2)]);
var statearr_26538_26596 = state_26489__$1;
(statearr_26538_26596[(5)] = ex26533);


var statearr_26539_26597 = state_26489__$1;
(statearr_26539_26597[(1)] = (4));

(statearr_26539_26597[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (14))){
var inst_26399 = (state_26489[(7)]);
var state_26489__$1 = state_26489;
var statearr_26540_26598 = state_26489__$1;
(statearr_26540_26598[(2)] = inst_26399);

(statearr_26540_26598[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (26))){
var state_26489__$1 = state_26489;
var statearr_26541_26599 = state_26489__$1;
(statearr_26541_26599[(2)] = null);

(statearr_26541_26599[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (16))){
var inst_26408 = cljs.core.first(ident);
var inst_26409 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26408], 0));
var inst_26410 = ["Subject ID lookup failed. The predicate ",inst_26409," does not exist."].join('');
var inst_26411 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26412 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26413 = cljs.core.PersistentHashMap.fromArrays(inst_26411,inst_26412);
var inst_26414 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26410,inst_26413);
var inst_26415 = (function(){throw inst_26414})();
var state_26489__$1 = state_26489;
var statearr_26542_26600 = state_26489__$1;
(statearr_26542_26600[(2)] = inst_26415);

(statearr_26542_26600[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (38))){
var inst_26469 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26470 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26471 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26472 = cljs.core.PersistentHashMap.fromArrays(inst_26470,inst_26471);
var inst_26473 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26469,inst_26472);
var inst_26474 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26473);
var state_26489__$1 = state_26489;
var statearr_26543_26601 = state_26489__$1;
(statearr_26543_26601[(2)] = inst_26474);

(statearr_26543_26601[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (30))){
var state_26489__$1 = state_26489;
var statearr_26544_26602 = state_26489__$1;
(statearr_26544_26602[(2)] = null);

(statearr_26544_26602[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (10))){
var state_26489__$1 = state_26489;
var statearr_26545_26603 = state_26489__$1;
(statearr_26545_26603[(2)] = ident);

(statearr_26545_26603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (18))){
var inst_26457 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
var statearr_26546_26604 = state_26489__$1;
(statearr_26546_26604[(2)] = inst_26457);

(statearr_26546_26604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (42))){
var state_26489__$1 = state_26489;
var statearr_26547_26605 = state_26489__$1;
(statearr_26547_26605[(2)] = null);

(statearr_26547_26605[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (37))){
var inst_26467 = (state_26489[(2)]);
var state_26489__$1 = state_26489;
if(cljs.core.truth_(inst_26467)){
var statearr_26548_26606 = state_26489__$1;
(statearr_26548_26606[(1)] = (38));

} else {
var statearr_26549_26607 = state_26489__$1;
(statearr_26549_26607[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26490 === (8))){
var inst_26459 = (state_26489[(10)]);
var inst_26459__$1 = (state_26489[(2)]);
var state_26489__$1 = (function (){var statearr_26550 = state_26489;
(statearr_26550[(10)] = inst_26459__$1);

return statearr_26550;
})();
if(cljs.core.truth_(inst_26459__$1)){
var statearr_26551_26608 = state_26489__$1;
(statearr_26551_26608[(1)] = (32));

} else {
var statearr_26552_26609 = state_26489__$1;
(statearr_26552_26609[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2727__auto____0 = (function (){
var statearr_26553 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26553[(0)] = fluree$db$graphdb$subid_$_state_machine__2727__auto__);

(statearr_26553[(1)] = (1));

return statearr_26553;
});
var fluree$db$graphdb$subid_$_state_machine__2727__auto____1 = (function (state_26489){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26489);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26554){var ex__2730__auto__ = e26554;
var statearr_26555_26610 = state_26489;
(statearr_26555_26610[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26489[(4)]))){
var statearr_26556_26611 = state_26489;
(statearr_26556_26611[(1)] = cljs.core.first((state_26489[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26612 = state_26489;
state_26489 = G__26612;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2727__auto__ = function(state_26489){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____1.call(this,state_26489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2727__auto____0;
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2727__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26557 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26557[(6)] = c__2749__auto___26558);

return statearr_26557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26613){
var map__26614 = p__26613;
var map__26614__$1 = cljs.core.__destructure_map(map__26614);
var db = map__26614__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26614__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26614__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26630){
var state_val_26631 = (state_26630[(1)]);
if((state_val_26631 === (1))){
var state_26630__$1 = state_26630;
var statearr_26632_26646 = state_26630__$1;
(statearr_26632_26646[(2)] = null);

(statearr_26632_26646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26631 === (2))){
var _ = (function (){var statearr_26633 = state_26630;
(statearr_26633[(4)] = cljs.core.cons((5),(state_26630[(4)])));

return statearr_26633;
})();
var inst_26621 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_26630__$1 = state_26630;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26630__$1,(6),inst_26621);
} else {
if((state_val_26631 === (3))){
var inst_26628 = (state_26630[(2)]);
var state_26630__$1 = state_26630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26630__$1,inst_26628);
} else {
if((state_val_26631 === (4))){
var inst_26615 = (state_26630[(2)]);
var state_26630__$1 = state_26630;
var statearr_26635_26647 = state_26630__$1;
(statearr_26635_26647[(2)] = inst_26615);

(statearr_26635_26647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26631 === (5))){
var _ = (function (){var statearr_26636 = state_26630;
(statearr_26636[(4)] = cljs.core.rest((state_26630[(4)])));

return statearr_26636;
})();
var state_26630__$1 = state_26630;
var ex26634 = (state_26630__$1[(2)]);
var statearr_26637_26648 = state_26630__$1;
(statearr_26637_26648[(5)] = ex26634);


if((ex26634 instanceof Error)){
var statearr_26638_26649 = state_26630__$1;
(statearr_26638_26649[(1)] = (4));

(statearr_26638_26649[(5)] = null);

} else {
throw ex26634;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26631 === (6))){
var inst_26623 = (state_26630[(2)]);
var inst_26624 = fluree.db.util.async.throw_err(inst_26623);
var inst_26625 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26624,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26639 = state_26630;
(statearr_26639[(4)] = cljs.core.rest((state_26630[(4)])));

return statearr_26639;
})();
var state_26630__$1 = state_26630;
var statearr_26640_26650 = state_26630__$1;
(statearr_26640_26650[(2)] = inst_26625);

(statearr_26640_26650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0 = (function (){
var statearr_26641 = [null,null,null,null,null,null,null];
(statearr_26641[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__);

(statearr_26641[(1)] = (1));

return statearr_26641;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1 = (function (state_26630){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26630);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26642){var ex__2730__auto__ = e26642;
var statearr_26643_26651 = state_26630;
(statearr_26643_26651[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26630[(4)]))){
var statearr_26644_26652 = state_26630;
(statearr_26644_26652[(1)] = cljs.core.first((state_26630[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26653 = state_26630;
state_26630 = G__26653;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = function(state_26630){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1.call(this,state_26630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26645 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26645[(6)] = c__2749__auto__);

return statearr_26645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26654,property,collection){
var map__26655 = p__26654;
var map__26655__$1 = cljs.core.__destructure_map(map__26655);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26655__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26656 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__26656.cljs$core$IFn$_invoke$arity$1 ? fexpr__26656.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26656.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26657,property,predicate){
var map__26658 = p__26657;
var map__26658__$1 = cljs.core.__destructure_map(map__26658);
var this$ = map__26658__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26658__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26659 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__26659.cljs$core$IFn$_invoke$arity$1 ? fexpr__26659.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26659.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26660 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26660);
} else {
return G__26660;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26662 = arguments.length;
switch (G__26662) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26694){
var state_val_26695 = (state_26694[(1)]);
if((state_val_26695 === (7))){
var state_26694__$1 = state_26694;
var statearr_26696_26790 = state_26694__$1;
(statearr_26696_26790[(2)] = null);

(statearr_26696_26790[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (1))){
var state_26694__$1 = state_26694;
var statearr_26697_26791 = state_26694__$1;
(statearr_26697_26791[(2)] = null);

(statearr_26697_26791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (4))){
var inst_26663 = (state_26694[(2)]);
var state_26694__$1 = state_26694;
var statearr_26698_26792 = state_26694__$1;
(statearr_26698_26792[(2)] = inst_26663);

(statearr_26698_26792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (6))){
var inst_26677 = (state_26694[(7)]);
var inst_26676 = (state_26694[(2)]);
var inst_26677__$1 = fluree.db.util.async.throw_err(inst_26676);
var inst_26678 = (inst_26677__$1 == null);
var state_26694__$1 = (function (){var statearr_26699 = state_26694;
(statearr_26699[(7)] = inst_26677__$1);

return statearr_26699;
})();
if(cljs.core.truth_(inst_26678)){
var statearr_26700_26793 = state_26694__$1;
(statearr_26700_26793[(1)] = (7));

} else {
var statearr_26701_26794 = state_26694__$1;
(statearr_26701_26794[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (3))){
var inst_26692 = (state_26694[(2)]);
var state_26694__$1 = state_26694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26694__$1,inst_26692);
} else {
if((state_val_26695 === (12))){
var inst_26689 = (state_26694[(2)]);
var _ = (function (){var statearr_26702 = state_26694;
(statearr_26702[(4)] = cljs.core.rest((state_26694[(4)])));

return statearr_26702;
})();
var state_26694__$1 = state_26694;
var statearr_26703_26795 = state_26694__$1;
(statearr_26703_26795[(2)] = inst_26689);

(statearr_26703_26795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (2))){
var _ = (function (){var statearr_26704 = state_26694;
(statearr_26704[(4)] = cljs.core.cons((5),(state_26694[(4)])));

return statearr_26704;
})();
var inst_26670 = fluree.db.dbproto._rootdb(this$);
var inst_26671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26672 = [tag_id,(30)];
var inst_26673 = (new cljs.core.PersistentVector(null,2,(5),inst_26671,inst_26672,null));
var inst_26674 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26670,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26673);
var state_26694__$1 = state_26694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26694__$1,(6),inst_26674);
} else {
if((state_val_26695 === (11))){
var inst_26683 = (state_26694[(8)]);
var inst_26687 = fluree.db.flake.o(inst_26683);
var state_26694__$1 = state_26694;
var statearr_26706_26796 = state_26694__$1;
(statearr_26706_26796[(2)] = inst_26687);

(statearr_26706_26796[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (9))){
var inst_26683 = (state_26694[(8)]);
var inst_26683__$1 = (state_26694[(2)]);
var inst_26684 = (inst_26683__$1 == null);
var state_26694__$1 = (function (){var statearr_26707 = state_26694;
(statearr_26707[(8)] = inst_26683__$1);

return statearr_26707;
})();
if(cljs.core.truth_(inst_26684)){
var statearr_26708_26797 = state_26694__$1;
(statearr_26708_26797[(1)] = (10));

} else {
var statearr_26709_26798 = state_26694__$1;
(statearr_26709_26798[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (5))){
var _ = (function (){var statearr_26710 = state_26694;
(statearr_26710[(4)] = cljs.core.rest((state_26694[(4)])));

return statearr_26710;
})();
var state_26694__$1 = state_26694;
var ex26705 = (state_26694__$1[(2)]);
var statearr_26711_26799 = state_26694__$1;
(statearr_26711_26799[(5)] = ex26705);


if((ex26705 instanceof Error)){
var statearr_26712_26800 = state_26694__$1;
(statearr_26712_26800[(1)] = (4));

(statearr_26712_26800[(5)] = null);

} else {
throw ex26705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (10))){
var state_26694__$1 = state_26694;
var statearr_26713_26801 = state_26694__$1;
(statearr_26713_26801[(2)] = null);

(statearr_26713_26801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26695 === (8))){
var inst_26677 = (state_26694[(7)]);
var inst_26681 = cljs.core.first(inst_26677);
var state_26694__$1 = state_26694;
var statearr_26714_26802 = state_26694__$1;
(statearr_26714_26802[(2)] = inst_26681);

(statearr_26714_26802[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26715 = [null,null,null,null,null,null,null,null,null];
(statearr_26715[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26715[(1)] = (1));

return statearr_26715;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26694){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26694);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26716){var ex__2730__auto__ = e26716;
var statearr_26717_26803 = state_26694;
(statearr_26717_26803[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26694[(4)]))){
var statearr_26718_26804 = state_26694;
(statearr_26718_26804[(1)] = cljs.core.first((state_26694[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26805 = state_26694;
state_26694 = G__26805;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26694){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26719 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26719[(6)] = c__2749__auto__);

return statearr_26719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26755){
var state_val_26756 = (state_26755[(1)]);
if((state_val_26756 === (7))){
var inst_26729 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26755__$1 = state_26755;
var statearr_26757_26806 = state_26755__$1;
(statearr_26757_26806[(2)] = inst_26729);

(statearr_26757_26806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (1))){
var state_26755__$1 = state_26755;
var statearr_26758_26807 = state_26755__$1;
(statearr_26758_26807[(2)] = null);

(statearr_26758_26807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (4))){
var inst_26720 = (state_26755[(2)]);
var state_26755__$1 = state_26755;
var statearr_26759_26808 = state_26755__$1;
(statearr_26759_26808[(2)] = inst_26720);

(statearr_26759_26808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (15))){
var inst_26750 = (state_26755[(2)]);
var _ = (function (){var statearr_26760 = state_26755;
(statearr_26760[(4)] = cljs.core.rest((state_26755[(4)])));

return statearr_26760;
})();
var state_26755__$1 = state_26755;
var statearr_26761_26809 = state_26755__$1;
(statearr_26761_26809[(2)] = inst_26750);

(statearr_26761_26809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (13))){
var inst_26735 = (state_26755[(7)]);
var inst_26741 = clojure.string.includes_QMARK_(inst_26735,":");
var state_26755__$1 = state_26755;
if(inst_26741){
var statearr_26762_26810 = state_26755__$1;
(statearr_26762_26810[(1)] = (16));

} else {
var statearr_26763_26811 = state_26755__$1;
(statearr_26763_26811[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (6))){
var state_26755__$1 = state_26755;
var statearr_26764_26812 = state_26755__$1;
(statearr_26764_26812[(2)] = pred);

(statearr_26764_26812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (17))){
var inst_26735 = (state_26755[(7)]);
var state_26755__$1 = state_26755;
var statearr_26765_26813 = state_26755__$1;
(statearr_26765_26813[(2)] = inst_26735);

(statearr_26765_26813[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (3))){
var inst_26753 = (state_26755[(2)]);
var state_26755__$1 = state_26755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26755__$1,inst_26753);
} else {
if((state_val_26756 === (12))){
var inst_26739 = (state_26755[(2)]);
var state_26755__$1 = state_26755;
if(cljs.core.truth_(inst_26739)){
var statearr_26766_26814 = state_26755__$1;
(statearr_26766_26814[(1)] = (13));

} else {
var statearr_26767_26815 = state_26755__$1;
(statearr_26767_26815[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (2))){
var _ = (function (){var statearr_26768 = state_26755;
(statearr_26768[(4)] = cljs.core.cons((5),(state_26755[(4)])));

return statearr_26768;
})();
var inst_26726 = typeof pred === 'string';
var state_26755__$1 = state_26755;
if(cljs.core.truth_(inst_26726)){
var statearr_26769_26816 = state_26755__$1;
(statearr_26769_26816[(1)] = (6));

} else {
var statearr_26770_26817 = state_26755__$1;
(statearr_26770_26817[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (11))){
var inst_26731 = (state_26755[(8)]);
var state_26755__$1 = state_26755;
var statearr_26772_26818 = state_26755__$1;
(statearr_26772_26818[(2)] = inst_26731);

(statearr_26772_26818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (9))){
var inst_26731 = (state_26755[(8)]);
var inst_26734 = (state_26755[(2)]);
var inst_26735 = fluree.db.util.async.throw_err(inst_26734);
var state_26755__$1 = (function (){var statearr_26773 = state_26755;
(statearr_26773[(7)] = inst_26735);

return statearr_26773;
})();
if(cljs.core.truth_(inst_26731)){
var statearr_26774_26819 = state_26755__$1;
(statearr_26774_26819[(1)] = (10));

} else {
var statearr_26775_26820 = state_26755__$1;
(statearr_26775_26820[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (5))){
var _ = (function (){var statearr_26776 = state_26755;
(statearr_26776[(4)] = cljs.core.rest((state_26755[(4)])));

return statearr_26776;
})();
var state_26755__$1 = state_26755;
var ex26771 = (state_26755__$1[(2)]);
var statearr_26777_26821 = state_26755__$1;
(statearr_26777_26821[(5)] = ex26771);


if((ex26771 instanceof Error)){
var statearr_26778_26822 = state_26755__$1;
(statearr_26778_26822[(1)] = (4));

(statearr_26778_26822[(5)] = null);

} else {
throw ex26771;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (14))){
var state_26755__$1 = state_26755;
var statearr_26779_26823 = state_26755__$1;
(statearr_26779_26823[(2)] = null);

(statearr_26779_26823[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (16))){
var inst_26735 = (state_26755[(7)]);
var inst_26743 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_26735,/:/);
var inst_26744 = cljs.core.second(inst_26743);
var state_26755__$1 = state_26755;
var statearr_26780_26824 = state_26755__$1;
(statearr_26780_26824[(2)] = inst_26744);

(statearr_26780_26824[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (10))){
var inst_26735 = (state_26755[(7)]);
var state_26755__$1 = state_26755;
var statearr_26781_26825 = state_26755__$1;
(statearr_26781_26825[(2)] = inst_26735);

(statearr_26781_26825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (18))){
var inst_26747 = (state_26755[(2)]);
var state_26755__$1 = state_26755;
var statearr_26782_26826 = state_26755__$1;
(statearr_26782_26826[(2)] = inst_26747);

(statearr_26782_26826[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26756 === (8))){
var inst_26731 = (state_26755[(2)]);
var inst_26732 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_26755__$1 = (function (){var statearr_26783 = state_26755;
(statearr_26783[(8)] = inst_26731);

return statearr_26783;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26755__$1,(9),inst_26732);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26784 = [null,null,null,null,null,null,null,null,null];
(statearr_26784[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26784[(1)] = (1));

return statearr_26784;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26755){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26755);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26785){var ex__2730__auto__ = e26785;
var statearr_26786_26827 = state_26755;
(statearr_26786_26827[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26755[(4)]))){
var statearr_26787_26828 = state_26755;
(statearr_26787_26828[(1)] = cljs.core.first((state_26755[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26829 = state_26755;
state_26755 = G__26829;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26755){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26788 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26788[(6)] = c__2749__auto__);

return statearr_26788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26831 = arguments.length;
switch (G__26831) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26864){
var state_val_26865 = (state_26864[(1)]);
if((state_val_26865 === (7))){
var state_26864__$1 = state_26864;
var statearr_26866_26954 = state_26864__$1;
(statearr_26866_26954[(2)] = null);

(statearr_26866_26954[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (1))){
var state_26864__$1 = state_26864;
var statearr_26867_26955 = state_26864__$1;
(statearr_26867_26955[(2)] = null);

(statearr_26867_26955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (4))){
var inst_26832 = (state_26864[(2)]);
var state_26864__$1 = state_26864;
var statearr_26868_26956 = state_26864__$1;
(statearr_26868_26956[(2)] = inst_26832);

(statearr_26868_26956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (6))){
var inst_26847 = (state_26864[(7)]);
var inst_26846 = (state_26864[(2)]);
var inst_26847__$1 = fluree.db.util.async.throw_err(inst_26846);
var inst_26848 = (inst_26847__$1 == null);
var state_26864__$1 = (function (){var statearr_26869 = state_26864;
(statearr_26869[(7)] = inst_26847__$1);

return statearr_26869;
})();
if(cljs.core.truth_(inst_26848)){
var statearr_26870_26957 = state_26864__$1;
(statearr_26870_26957[(1)] = (7));

} else {
var statearr_26871_26958 = state_26864__$1;
(statearr_26871_26958[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (3))){
var inst_26862 = (state_26864[(2)]);
var state_26864__$1 = state_26864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26864__$1,inst_26862);
} else {
if((state_val_26865 === (12))){
var inst_26859 = (state_26864[(2)]);
var _ = (function (){var statearr_26872 = state_26864;
(statearr_26872[(4)] = cljs.core.rest((state_26864[(4)])));

return statearr_26872;
})();
var state_26864__$1 = state_26864;
var statearr_26873_26959 = state_26864__$1;
(statearr_26873_26959[(2)] = inst_26859);

(statearr_26873_26959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (2))){
var _ = (function (){var statearr_26874 = state_26864;
(statearr_26874[(4)] = cljs.core.cons((5),(state_26864[(4)])));

return statearr_26874;
})();
var inst_26838 = (30);
var inst_26840 = fluree.db.dbproto._rootdb(this$);
var inst_26841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26842 = [inst_26838,tag_name];
var inst_26843 = (new cljs.core.PersistentVector(null,2,(5),inst_26841,inst_26842,null));
var inst_26844 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26840,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26843);
var state_26864__$1 = state_26864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26864__$1,(6),inst_26844);
} else {
if((state_val_26865 === (11))){
var inst_26853 = (state_26864[(8)]);
var inst_26857 = fluree.db.flake.s(inst_26853);
var state_26864__$1 = state_26864;
var statearr_26876_26960 = state_26864__$1;
(statearr_26876_26960[(2)] = inst_26857);

(statearr_26876_26960[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (9))){
var inst_26853 = (state_26864[(8)]);
var inst_26853__$1 = (state_26864[(2)]);
var inst_26854 = (inst_26853__$1 == null);
var state_26864__$1 = (function (){var statearr_26877 = state_26864;
(statearr_26877[(8)] = inst_26853__$1);

return statearr_26877;
})();
if(cljs.core.truth_(inst_26854)){
var statearr_26878_26961 = state_26864__$1;
(statearr_26878_26961[(1)] = (10));

} else {
var statearr_26879_26962 = state_26864__$1;
(statearr_26879_26962[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (5))){
var _ = (function (){var statearr_26880 = state_26864;
(statearr_26880[(4)] = cljs.core.rest((state_26864[(4)])));

return statearr_26880;
})();
var state_26864__$1 = state_26864;
var ex26875 = (state_26864__$1[(2)]);
var statearr_26881_26963 = state_26864__$1;
(statearr_26881_26963[(5)] = ex26875);


if((ex26875 instanceof Error)){
var statearr_26882_26964 = state_26864__$1;
(statearr_26882_26964[(1)] = (4));

(statearr_26882_26964[(5)] = null);

} else {
throw ex26875;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (10))){
var state_26864__$1 = state_26864;
var statearr_26883_26965 = state_26864__$1;
(statearr_26883_26965[(2)] = null);

(statearr_26883_26965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26865 === (8))){
var inst_26847 = (state_26864[(7)]);
var inst_26851 = cljs.core.first(inst_26847);
var state_26864__$1 = state_26864;
var statearr_26884_26966 = state_26864__$1;
(statearr_26884_26966[(2)] = inst_26851);

(statearr_26884_26966[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26885 = [null,null,null,null,null,null,null,null,null];
(statearr_26885[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26885[(1)] = (1));

return statearr_26885;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26864){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26864);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26886){var ex__2730__auto__ = e26886;
var statearr_26887_26967 = state_26864;
(statearr_26887_26967[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26864[(4)]))){
var statearr_26888_26968 = state_26864;
(statearr_26888_26968[(1)] = cljs.core.first((state_26864[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26969 = state_26864;
state_26864 = G__26969;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26864){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26889 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26889[(6)] = c__2749__auto__);

return statearr_26889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26924){
var state_val_26925 = (state_26924[(1)]);
if((state_val_26925 === (7))){
var inst_26903 = typeof pred === 'string';
var state_26924__$1 = state_26924;
if(cljs.core.truth_(inst_26903)){
var statearr_26926_26970 = state_26924__$1;
(statearr_26926_26970[(1)] = (10));

} else {
var statearr_26927_26971 = state_26924__$1;
(statearr_26927_26971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (1))){
var state_26924__$1 = state_26924;
var statearr_26928_26972 = state_26924__$1;
(statearr_26928_26972[(2)] = null);

(statearr_26928_26972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (4))){
var inst_26890 = (state_26924[(2)]);
var state_26924__$1 = state_26924;
var statearr_26929_26973 = state_26924__$1;
(statearr_26929_26973[(2)] = inst_26890);

(statearr_26929_26973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (15))){
var inst_26917 = (state_26924[(2)]);
var state_26924__$1 = state_26924;
var statearr_26930_26974 = state_26924__$1;
(statearr_26930_26974[(2)] = inst_26917);

(statearr_26930_26974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (13))){
var inst_26908 = (state_26924[(7)]);
var inst_26910 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26908),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26911 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_26910);
var state_26924__$1 = state_26924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26924__$1,(16),inst_26911);
} else {
if((state_val_26925 === (6))){
var inst_26898 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_26924__$1 = state_26924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26924__$1,(9),inst_26898);
} else {
if((state_val_26925 === (3))){
var inst_26922 = (state_26924[(2)]);
var state_26924__$1 = state_26924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26924__$1,inst_26922);
} else {
if((state_val_26925 === (12))){
var inst_26908 = (state_26924[(7)]);
var inst_26908__$1 = (state_26924[(2)]);
var state_26924__$1 = (function (){var statearr_26931 = state_26924;
(statearr_26931[(7)] = inst_26908__$1);

return statearr_26931;
})();
if(cljs.core.truth_(inst_26908__$1)){
var statearr_26932_26975 = state_26924__$1;
(statearr_26932_26975[(1)] = (13));

} else {
var statearr_26933_26976 = state_26924__$1;
(statearr_26933_26976[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (2))){
var _ = (function (){var statearr_26934 = state_26924;
(statearr_26934[(4)] = cljs.core.cons((5),(state_26924[(4)])));

return statearr_26934;
})();
var inst_26896 = clojure.string.includes_QMARK_(tag_name,"/");
var state_26924__$1 = state_26924;
if(inst_26896){
var statearr_26935_26977 = state_26924__$1;
(statearr_26935_26977[(1)] = (6));

} else {
var statearr_26936_26978 = state_26924__$1;
(statearr_26936_26978[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (11))){
var inst_26906 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26924__$1 = state_26924;
var statearr_26938_26979 = state_26924__$1;
(statearr_26938_26979[(2)] = inst_26906);

(statearr_26938_26979[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (9))){
var inst_26900 = (state_26924[(2)]);
var inst_26901 = fluree.db.util.async.throw_err(inst_26900);
var state_26924__$1 = state_26924;
var statearr_26939_26980 = state_26924__$1;
(statearr_26939_26980[(2)] = inst_26901);

(statearr_26939_26980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (5))){
var _ = (function (){var statearr_26940 = state_26924;
(statearr_26940[(4)] = cljs.core.rest((state_26924[(4)])));

return statearr_26940;
})();
var state_26924__$1 = state_26924;
var ex26937 = (state_26924__$1[(2)]);
var statearr_26941_26981 = state_26924__$1;
(statearr_26941_26981[(5)] = ex26937);


if((ex26937 instanceof Error)){
var statearr_26942_26982 = state_26924__$1;
(statearr_26942_26982[(1)] = (4));

(statearr_26942_26982[(5)] = null);

} else {
throw ex26937;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (14))){
var state_26924__$1 = state_26924;
var statearr_26943_26983 = state_26924__$1;
(statearr_26943_26983[(2)] = null);

(statearr_26943_26983[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (16))){
var inst_26913 = (state_26924[(2)]);
var inst_26914 = fluree.db.util.async.throw_err(inst_26913);
var state_26924__$1 = state_26924;
var statearr_26944_26984 = state_26924__$1;
(statearr_26944_26984[(2)] = inst_26914);

(statearr_26944_26984[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (10))){
var state_26924__$1 = state_26924;
var statearr_26945_26985 = state_26924__$1;
(statearr_26945_26985[(2)] = pred);

(statearr_26945_26985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (8))){
var inst_26919 = (state_26924[(2)]);
var _ = (function (){var statearr_26946 = state_26924;
(statearr_26946[(4)] = cljs.core.rest((state_26924[(4)])));

return statearr_26946;
})();
var state_26924__$1 = state_26924;
var statearr_26947_26986 = state_26924__$1;
(statearr_26947_26986[(2)] = inst_26919);

(statearr_26947_26986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26948 = [null,null,null,null,null,null,null,null];
(statearr_26948[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26948[(1)] = (1));

return statearr_26948;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26924){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26924);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26949){var ex__2730__auto__ = e26949;
var statearr_26950_26987 = state_26924;
(statearr_26950_26987[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26924[(4)]))){
var statearr_26951_26988 = state_26924;
(statearr_26951_26988[(1)] = cljs.core.first((state_26924[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26989 = state_26924;
state_26924 = G__26989;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26924){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26952 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26952[(6)] = c__2749__auto__);

return statearr_26952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k26991,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__26995 = k26991;
var G__26995__$1 = (((G__26995 instanceof cljs.core.Keyword))?G__26995.fqn:null);
switch (G__26995__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26991,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__26996){
var vec__26997 = p__26996;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26997,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26997,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26990){
var self__ = this;
var G__26990__$1 = this;
return (new cljs.core.RecordIter((0),G__26990__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27000 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27000(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26992,other26993){
var self__ = this;
var this26992__$1 = this;
return (((!((other26993 == null)))) && ((((this26992__$1.constructor === other26993.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.conn,other26993.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.network,other26993.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.ledger_id,other26993.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.block,other26993.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.t,other26993.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.tt_id,other26993.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.stats,other26993.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.spot,other26993.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.psot,other26993.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.post,other26993.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.opst,other26993.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.tspo,other26993.tspo)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.schema,other26993.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.settings,other26993.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.comparators,other26993.comparators)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.schema_cache,other26993.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.novelty,other26993.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.permissions,other26993.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.fork,other26993.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.fork_block,other26993.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.current_db_fn,other26993.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26992__$1.__extmap,other26993.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k26991){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27001 = k26991;
var G__27001__$1 = (((G__27001 instanceof cljs.core.Keyword))?G__27001.fqn:null);
switch (G__27001__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26991);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__26990){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27002 = cljs.core.keyword_identical_QMARK_;
var expr__27003 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27005 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27006 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27005,G__27006) : pred__27002.call(null,G__27005,G__27006));
})())){
return (new fluree.db.graphdb.GraphDb(G__26990,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27007 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27008 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27007,G__27008) : pred__27002.call(null,G__27007,G__27008));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26990,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27009 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27010 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27009,G__27010) : pred__27002.call(null,G__27009,G__27010));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26990,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27011 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27012 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27011,G__27012) : pred__27002.call(null,G__27011,G__27012));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26990,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27013 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27014 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27013,G__27014) : pred__27002.call(null,G__27013,G__27014));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26990,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27015 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27016 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27015,G__27016) : pred__27002.call(null,G__27015,G__27016));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26990,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27017 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27018 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27017,G__27018) : pred__27002.call(null,G__27017,G__27018));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26990,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27019 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27020 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27019,G__27020) : pred__27002.call(null,G__27019,G__27020));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26990,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27021 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27022 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27021,G__27022) : pred__27002.call(null,G__27021,G__27022));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26990,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27023 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27024 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27023,G__27024) : pred__27002.call(null,G__27023,G__27024));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26990,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27025 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27026 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27025,G__27026) : pred__27002.call(null,G__27025,G__27026));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26990,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27027 = new cljs.core.Keyword(null,"tspo","tspo",-440144953);
var G__27028 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27027,G__27028) : pred__27002.call(null,G__27027,G__27028));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26990,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27029 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27030 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27029,G__27030) : pred__27002.call(null,G__27029,G__27030));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26990,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27031 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27032 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27031,G__27032) : pred__27002.call(null,G__27031,G__27032));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26990,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27033 = new cljs.core.Keyword(null,"comparators","comparators",-1325611955);
var G__27034 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27033,G__27034) : pred__27002.call(null,G__27033,G__27034));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26990,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27035 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27036 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27035,G__27036) : pred__27002.call(null,G__27035,G__27036));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26990,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27037 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27038 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27037,G__27038) : pred__27002.call(null,G__27037,G__27038));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26990,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27039 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27040 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27039,G__27040) : pred__27002.call(null,G__27039,G__27040));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26990,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27041 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27042 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27041,G__27042) : pred__27002.call(null,G__27041,G__27042));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26990,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27043 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27044 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27043,G__27044) : pred__27002.call(null,G__27043,G__27044));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26990,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27045 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27046 = expr__27003;
return (pred__27002.cljs$core$IFn$_invoke$arity$2 ? pred__27002.cljs$core$IFn$_invoke$arity$2(G__27045,G__27046) : pred__27002.call(null,G__27045,G__27046));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26990,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__26990),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__26990){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26990,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26994){
var extmap__5385__auto__ = (function (){var G__27047 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26994,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__26994)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27047);
} else {
return G__27047;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26994),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26994),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,clojure.data.avl.sorted_set_by(cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27050 = fluree.db.index.default_comparators;
var map__27050__$1 = cljs.core.__destructure_map(map__27050);
var spot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27050__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27050__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27050__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27050__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27050__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch(network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch(network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch(network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch(network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch(network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
