// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___53702 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53753){
var state_val_53754 = (state_53753[(1)]);
if((state_val_53754 === (7))){
var inst_53748 = (state_53753[(2)]);
var _ = (function (){var statearr_53755 = state_53753;
(statearr_53755[(4)] = cljs.core.rest((state_53753[(4)])));

return statearr_53755;
})();
var state_53753__$1 = state_53753;
var statearr_53756_53783 = state_53753__$1;
(statearr_53756_53783[(2)] = inst_53748);

(statearr_53756_53783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (1))){
var state_53753__$1 = state_53753;
var statearr_53757_53784 = state_53753__$1;
(statearr_53757_53784[(2)] = null);

(statearr_53757_53784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (4))){
var inst_53703 = (state_53753[(2)]);
var state_53753__$1 = state_53753;
var statearr_53758_53785 = state_53753__$1;
(statearr_53758_53785[(2)] = inst_53703);

(statearr_53758_53785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (13))){
var inst_53744 = (state_53753[(2)]);
var state_53753__$1 = state_53753;
var statearr_53759_53786 = state_53753__$1;
(statearr_53759_53786[(2)] = inst_53744);

(statearr_53759_53786[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (6))){
var inst_53728 = (state_53753[(7)]);
var inst_53721 = (state_53753[(8)]);
var inst_53727 = cljs.core.seq(inst_53721);
var inst_53728__$1 = cljs.core.first(inst_53727);
var inst_53729 = cljs.core.next(inst_53727);
var inst_53730 = cljs.core.not(inst_53728__$1);
var state_53753__$1 = (function (){var statearr_53760 = state_53753;
(statearr_53760[(9)] = inst_53729);

(statearr_53760[(7)] = inst_53728__$1);

return statearr_53760;
})();
if(inst_53730){
var statearr_53761_53787 = state_53753__$1;
(statearr_53761_53787[(1)] = (8));

} else {
var statearr_53762_53788 = state_53753__$1;
(statearr_53762_53788[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (3))){
var inst_53751 = (state_53753[(2)]);
var state_53753__$1 = state_53753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53753__$1,inst_53751);
} else {
if((state_val_53754 === (12))){
var inst_53729 = (state_53753[(9)]);
var inst_53728 = (state_53753[(7)]);
var inst_53722 = (state_53753[(10)]);
var inst_53741 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53722,inst_53728);
var inst_53721 = inst_53729;
var inst_53722__$1 = inst_53741;
var state_53753__$1 = (function (){var statearr_53763 = state_53753;
(statearr_53763[(8)] = inst_53721);

(statearr_53763[(10)] = inst_53722__$1);

return statearr_53763;
})();
var statearr_53764_53789 = state_53753__$1;
(statearr_53764_53789[(2)] = null);

(statearr_53764_53789[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (2))){
var _ = (function (){var statearr_53765 = state_53753;
(statearr_53765[(4)] = cljs.core.cons((5),(state_53753[(4)])));

return statearr_53765;
})();
var inst_53716 = args;
var inst_53717 = cljs.core.seq(inst_53716);
var inst_53718 = cljs.core.first(inst_53717);
var inst_53719 = cljs.core.next(inst_53717);
var inst_53720 = cljs.core.PersistentVector.EMPTY;
var inst_53721 = inst_53716;
var inst_53722 = inst_53720;
var state_53753__$1 = (function (){var statearr_53766 = state_53753;
(statearr_53766[(11)] = inst_53719);

(statearr_53766[(12)] = inst_53718);

(statearr_53766[(8)] = inst_53721);

(statearr_53766[(10)] = inst_53722);

return statearr_53766;
})();
var statearr_53767_53790 = state_53753__$1;
(statearr_53767_53790[(2)] = null);

(statearr_53767_53790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (11))){
var inst_53728 = (state_53753[(7)]);
var state_53753__$1 = state_53753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53753__$1,(14),inst_53728);
} else {
if((state_val_53754 === (9))){
var inst_53728 = (state_53753[(7)]);
var inst_53733 = fluree.db.util.async.channel_QMARK_(inst_53728);
var state_53753__$1 = state_53753;
if(inst_53733){
var statearr_53769_53791 = state_53753__$1;
(statearr_53769_53791[(1)] = (11));

} else {
var statearr_53770_53792 = state_53753__$1;
(statearr_53770_53792[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (5))){
var _ = (function (){var statearr_53771 = state_53753;
(statearr_53771[(4)] = cljs.core.rest((state_53753[(4)])));

return statearr_53771;
})();
var state_53753__$1 = state_53753;
var ex53768 = (state_53753__$1[(2)]);
var statearr_53772_53793 = state_53753__$1;
(statearr_53772_53793[(5)] = ex53768);


if((ex53768 instanceof Error)){
var statearr_53773_53794 = state_53753__$1;
(statearr_53773_53794[(1)] = (4));

(statearr_53773_53794[(5)] = null);

} else {
throw ex53768;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (14))){
var inst_53729 = (state_53753[(9)]);
var inst_53722 = (state_53753[(10)]);
var inst_53736 = (state_53753[(2)]);
var inst_53737 = fluree.db.util.async.throw_err(inst_53736);
var inst_53738 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53722,inst_53737);
var inst_53721 = inst_53729;
var inst_53722__$1 = inst_53738;
var state_53753__$1 = (function (){var statearr_53774 = state_53753;
(statearr_53774[(8)] = inst_53721);

(statearr_53774[(10)] = inst_53722__$1);

return statearr_53774;
})();
var statearr_53775_53795 = state_53753__$1;
(statearr_53775_53795[(2)] = null);

(statearr_53775_53795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (10))){
var inst_53746 = (state_53753[(2)]);
var state_53753__$1 = state_53753;
var statearr_53776_53796 = state_53753__$1;
(statearr_53776_53796[(2)] = inst_53746);

(statearr_53776_53796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53754 === (8))){
var inst_53722 = (state_53753[(10)]);
var state_53753__$1 = state_53753;
var statearr_53777_53797 = state_53753__$1;
(statearr_53777_53797[(2)] = inst_53722);

(statearr_53777_53797[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_53778 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53778[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_53778[(1)] = (1));

return statearr_53778;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_53753){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53753);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53779){var ex__2730__auto__ = e53779;
var statearr_53780_53798 = state_53753;
(statearr_53780_53798[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53753[(4)]))){
var statearr_53781_53799 = state_53753;
(statearr_53781_53799[(1)] = cljs.core.first((state_53753[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53800 = state_53753;
state_53753 = G__53800;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_53753){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_53753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53782 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53782[(6)] = c__2749__auto__);

return statearr_53782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53802 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53802,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53802,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__53801_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__53801_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53850){
var state_val_53851 = (state_53850[(1)]);
if((state_val_53851 === (7))){
var state_53850__$1 = state_53850;
var statearr_53852_53881 = state_53850__$1;
(statearr_53852_53881[(2)] = coll);

(statearr_53852_53881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (1))){
var state_53850__$1 = state_53850;
var statearr_53853_53882 = state_53850__$1;
(statearr_53853_53882[(2)] = null);

(statearr_53853_53882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (4))){
var inst_53805 = (state_53850[(2)]);
var state_53850__$1 = state_53850;
var statearr_53854_53883 = state_53850__$1;
(statearr_53854_53883[(2)] = inst_53805);

(statearr_53854_53883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (15))){
var inst_53824 = (state_53850[(7)]);
var inst_53832 = (state_53850[(2)]);
var inst_53833 = fluree.db.dbfunctions.internal.nth(inst_53824,inst_53832);
var inst_53834 = cljs.core.count(inst_53824);
var inst_53835 = ((9) + inst_53834);
var inst_53836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53837 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53839 = [inst_53824,inst_53832];
var inst_53840 = (new cljs.core.PersistentVector(null,2,(5),inst_53838,inst_53839,null));
var inst_53841 = ["nth",inst_53840,inst_53833];
var inst_53842 = cljs.core.PersistentHashMap.fromArrays(inst_53837,inst_53841);
var inst_53843 = [inst_53842,inst_53835];
var inst_53844 = (new cljs.core.PersistentVector(null,2,(5),inst_53836,inst_53843,null));
var inst_53845 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53844);
var _ = (function (){var statearr_53855 = state_53850;
(statearr_53855[(4)] = cljs.core.rest((state_53850[(4)])));

return statearr_53855;
})();
var state_53850__$1 = (function (){var statearr_53856 = state_53850;
(statearr_53856[(8)] = inst_53845);

return statearr_53856;
})();
var statearr_53857_53884 = state_53850__$1;
(statearr_53857_53884[(2)] = inst_53833);

(statearr_53857_53884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (13))){
var state_53850__$1 = state_53850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53850__$1,(16),key);
} else {
if((state_val_53851 === (6))){
var state_53850__$1 = state_53850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53850__$1,(9),coll);
} else {
if((state_val_53851 === (3))){
var inst_53848 = (state_53850[(2)]);
var state_53850__$1 = state_53850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53850__$1,inst_53848);
} else {
if((state_val_53851 === (12))){
var inst_53824 = (state_53850[(2)]);
var inst_53825 = fluree.db.util.async.channel_QMARK_(key);
var state_53850__$1 = (function (){var statearr_53858 = state_53850;
(statearr_53858[(7)] = inst_53824);

return statearr_53858;
})();
if(inst_53825){
var statearr_53859_53885 = state_53850__$1;
(statearr_53859_53885[(1)] = (13));

} else {
var statearr_53860_53886 = state_53850__$1;
(statearr_53860_53886[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (2))){
var _ = (function (){var statearr_53861 = state_53850;
(statearr_53861[(4)] = cljs.core.cons((5),(state_53850[(4)])));

return statearr_53861;
})();
var inst_53811 = fluree.db.util.async.channel_QMARK_(coll);
var state_53850__$1 = state_53850;
if(inst_53811){
var statearr_53862_53887 = state_53850__$1;
(statearr_53862_53887[(1)] = (6));

} else {
var statearr_53863_53888 = state_53850__$1;
(statearr_53863_53888[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (11))){
var inst_53818 = (state_53850[(9)]);
var state_53850__$1 = state_53850;
var statearr_53865_53889 = state_53850__$1;
(statearr_53865_53889[(2)] = inst_53818);

(statearr_53865_53889[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (9))){
var inst_53814 = (state_53850[(2)]);
var inst_53815 = fluree.db.util.async.throw_err(inst_53814);
var state_53850__$1 = state_53850;
var statearr_53866_53890 = state_53850__$1;
(statearr_53866_53890[(2)] = inst_53815);

(statearr_53866_53890[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (5))){
var _ = (function (){var statearr_53867 = state_53850;
(statearr_53867[(4)] = cljs.core.rest((state_53850[(4)])));

return statearr_53867;
})();
var state_53850__$1 = state_53850;
var ex53864 = (state_53850__$1[(2)]);
var statearr_53868_53891 = state_53850__$1;
(statearr_53868_53891[(5)] = ex53864);


if((ex53864 instanceof Error)){
var statearr_53869_53892 = state_53850__$1;
(statearr_53869_53892[(1)] = (4));

(statearr_53869_53892[(5)] = null);

} else {
throw ex53864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (14))){
var state_53850__$1 = state_53850;
var statearr_53870_53893 = state_53850__$1;
(statearr_53870_53893[(2)] = key);

(statearr_53870_53893[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (16))){
var inst_53828 = (state_53850[(2)]);
var inst_53829 = fluree.db.util.async.throw_err(inst_53828);
var state_53850__$1 = state_53850;
var statearr_53871_53894 = state_53850__$1;
(statearr_53871_53894[(2)] = inst_53829);

(statearr_53871_53894[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (10))){
var inst_53818 = (state_53850[(9)]);
var inst_53821 = cljs.core.vec(inst_53818);
var state_53850__$1 = state_53850;
var statearr_53872_53895 = state_53850__$1;
(statearr_53872_53895[(2)] = inst_53821);

(statearr_53872_53895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53851 === (8))){
var inst_53818 = (state_53850[(9)]);
var inst_53818__$1 = (state_53850[(2)]);
var inst_53819 = cljs.core.set_QMARK_(inst_53818__$1);
var state_53850__$1 = (function (){var statearr_53873 = state_53850;
(statearr_53873[(9)] = inst_53818__$1);

return statearr_53873;
})();
if(inst_53819){
var statearr_53874_53896 = state_53850__$1;
(statearr_53874_53896[(1)] = (10));

} else {
var statearr_53875_53897 = state_53850__$1;
(statearr_53875_53897[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_53876 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53876[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_53876[(1)] = (1));

return statearr_53876;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_53850){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53850);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53877){var ex__2730__auto__ = e53877;
var statearr_53878_53898 = state_53850;
(statearr_53878_53898[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53850[(4)]))){
var statearr_53879_53899 = state_53850;
(statearr_53879_53899[(1)] = cljs.core.first((state_53850[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53900 = state_53850;
state_53850 = G__53900;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_53850){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_53850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53880 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53880[(6)] = c__2749__auto__);

return statearr_53880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53961){
var state_val_53962 = (state_53961[(1)]);
if((state_val_53962 === (7))){
var state_53961__$1 = state_53961;
var statearr_53963_53997 = state_53961__$1;
(statearr_53963_53997[(2)] = test);

(statearr_53963_53997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (20))){
var inst_53935 = (state_53961[(2)]);
var inst_53936 = fluree.db.util.async.throw_err(inst_53935);
var state_53961__$1 = state_53961;
var statearr_53964_53998 = state_53961__$1;
(statearr_53964_53998[(2)] = inst_53936);

(statearr_53964_53998[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (1))){
var state_53961__$1 = state_53961;
var statearr_53965_53999 = state_53961__$1;
(statearr_53965_53999[(2)] = null);

(statearr_53965_53999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (4))){
var inst_53901 = (state_53961[(2)]);
var state_53961__$1 = state_53961;
var statearr_53966_54000 = state_53961__$1;
(statearr_53966_54000[(2)] = inst_53901);

(statearr_53966_54000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (15))){
var inst_53919 = (state_53961[(7)]);
var inst_53927 = (state_53961[(2)]);
var inst_53928 = [inst_53927,f];
var inst_53929 = (new cljs.core.PersistentVector(null,2,(5),inst_53919,inst_53928,null));
var state_53961__$1 = state_53961;
var statearr_53967_54001 = state_53961__$1;
(statearr_53967_54001[(2)] = inst_53929);

(statearr_53967_54001[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (13))){
var state_53961__$1 = state_53961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53961__$1,(16),t);
} else {
if((state_val_53962 === (6))){
var state_53961__$1 = state_53961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53961__$1,(9),test);
} else {
if((state_val_53962 === (17))){
var state_53961__$1 = state_53961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53961__$1,(20),f);
} else {
if((state_val_53962 === (3))){
var inst_53959 = (state_53961[(2)]);
var state_53961__$1 = state_53961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53961__$1,inst_53959);
} else {
if((state_val_53962 === (12))){
var inst_53917 = (state_53961[(8)]);
var inst_53943 = (state_53961[(2)]);
var inst_53944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53943,(0),null);
var inst_53945 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53943,(1),null);
var inst_53946 = fluree.db.dbfunctions.internal.if_else(inst_53917,inst_53944,inst_53945);
var inst_53947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53948 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53950 = [inst_53917,inst_53944,inst_53945];
var inst_53951 = (new cljs.core.PersistentVector(null,3,(5),inst_53949,inst_53950,null));
var inst_53952 = ["if-else",inst_53951,inst_53946];
var inst_53953 = cljs.core.PersistentHashMap.fromArrays(inst_53948,inst_53952);
var inst_53954 = [inst_53953,(10)];
var inst_53955 = (new cljs.core.PersistentVector(null,2,(5),inst_53947,inst_53954,null));
var inst_53956 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53955);
var _ = (function (){var statearr_53968 = state_53961;
(statearr_53968[(4)] = cljs.core.rest((state_53961[(4)])));

return statearr_53968;
})();
var state_53961__$1 = (function (){var statearr_53969 = state_53961;
(statearr_53969[(9)] = inst_53956);

return statearr_53969;
})();
var statearr_53970_54002 = state_53961__$1;
(statearr_53970_54002[(2)] = inst_53946);

(statearr_53970_54002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (2))){
var _ = (function (){var statearr_53971 = state_53961;
(statearr_53971[(4)] = cljs.core.cons((5),(state_53961[(4)])));

return statearr_53971;
})();
var inst_53910 = fluree.db.util.async.channel_QMARK_(test);
var state_53961__$1 = state_53961;
if(inst_53910){
var statearr_53972_54003 = state_53961__$1;
(statearr_53972_54003[(1)] = (6));

} else {
var statearr_53973_54004 = state_53961__$1;
(statearr_53973_54004[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (19))){
var inst_53931 = (state_53961[(10)]);
var inst_53939 = (state_53961[(2)]);
var inst_53940 = [f,inst_53939];
var inst_53941 = (new cljs.core.PersistentVector(null,2,(5),inst_53931,inst_53940,null));
var state_53961__$1 = state_53961;
var statearr_53974_54005 = state_53961__$1;
(statearr_53974_54005[(2)] = inst_53941);

(statearr_53974_54005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (11))){
var inst_53931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53932 = fluree.db.util.async.channel_QMARK_(f);
var state_53961__$1 = (function (){var statearr_53976 = state_53961;
(statearr_53976[(10)] = inst_53931);

return statearr_53976;
})();
if(inst_53932){
var statearr_53977_54006 = state_53961__$1;
(statearr_53977_54006[(1)] = (17));

} else {
var statearr_53978_54007 = state_53961__$1;
(statearr_53978_54007[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (9))){
var inst_53913 = (state_53961[(2)]);
var inst_53914 = fluree.db.util.async.throw_err(inst_53913);
var state_53961__$1 = state_53961;
var statearr_53979_54008 = state_53961__$1;
(statearr_53979_54008[(2)] = inst_53914);

(statearr_53979_54008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (5))){
var _ = (function (){var statearr_53980 = state_53961;
(statearr_53980[(4)] = cljs.core.rest((state_53961[(4)])));

return statearr_53980;
})();
var state_53961__$1 = state_53961;
var ex53975 = (state_53961__$1[(2)]);
var statearr_53981_54009 = state_53961__$1;
(statearr_53981_54009[(5)] = ex53975);


if((ex53975 instanceof Error)){
var statearr_53982_54010 = state_53961__$1;
(statearr_53982_54010[(1)] = (4));

(statearr_53982_54010[(5)] = null);

} else {
throw ex53975;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (14))){
var state_53961__$1 = state_53961;
var statearr_53983_54011 = state_53961__$1;
(statearr_53983_54011[(2)] = t);

(statearr_53983_54011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (16))){
var inst_53923 = (state_53961[(2)]);
var inst_53924 = fluree.db.util.async.throw_err(inst_53923);
var state_53961__$1 = state_53961;
var statearr_53984_54012 = state_53961__$1;
(statearr_53984_54012[(2)] = inst_53924);

(statearr_53984_54012[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (10))){
var inst_53919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53920 = fluree.db.util.async.channel_QMARK_(t);
var state_53961__$1 = (function (){var statearr_53985 = state_53961;
(statearr_53985[(7)] = inst_53919);

return statearr_53985;
})();
if(inst_53920){
var statearr_53986_54013 = state_53961__$1;
(statearr_53986_54013[(1)] = (13));

} else {
var statearr_53987_54014 = state_53961__$1;
(statearr_53987_54014[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (18))){
var state_53961__$1 = state_53961;
var statearr_53988_54015 = state_53961__$1;
(statearr_53988_54015[(2)] = f);

(statearr_53988_54015[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53962 === (8))){
var inst_53917 = (state_53961[(8)]);
var inst_53917__$1 = (state_53961[(2)]);
var state_53961__$1 = (function (){var statearr_53989 = state_53961;
(statearr_53989[(8)] = inst_53917__$1);

return statearr_53989;
})();
if(cljs.core.truth_(inst_53917__$1)){
var statearr_53990_54016 = state_53961__$1;
(statearr_53990_54016[(1)] = (10));

} else {
var statearr_53991_54017 = state_53961__$1;
(statearr_53991_54017[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_53992 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53992[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_53992[(1)] = (1));

return statearr_53992;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_53961){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53961);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53993){var ex__2730__auto__ = e53993;
var statearr_53994_54018 = state_53961;
(statearr_53994_54018[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53961[(4)]))){
var statearr_53995_54019 = state_53961;
(statearr_53995_54019[(1)] = cljs.core.first((state_53961[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54020 = state_53961;
state_53961 = G__54020;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_53961){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_53961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53996 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53996[(6)] = c__2749__auto__);

return statearr_53996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54050){
var state_val_54051 = (state_54050[(1)]);
if((state_val_54051 === (7))){
var state_54050__$1 = state_54050;
var statearr_54052_54071 = state_54050__$1;
(statearr_54052_54071[(2)] = arg);

(statearr_54052_54071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54051 === (1))){
var state_54050__$1 = state_54050;
var statearr_54053_54072 = state_54050__$1;
(statearr_54053_54072[(2)] = null);

(statearr_54053_54072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54051 === (4))){
var inst_54021 = (state_54050[(2)]);
var state_54050__$1 = state_54050;
var statearr_54054_54073 = state_54050__$1;
(statearr_54054_54073[(2)] = inst_54021);

(statearr_54054_54073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54051 === (6))){
var state_54050__$1 = state_54050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54050__$1,(9),arg);
} else {
if((state_val_54051 === (3))){
var inst_54048 = (state_54050[(2)]);
var state_54050__$1 = state_54050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54050__$1,inst_54048);
} else {
if((state_val_54051 === (2))){
var _ = (function (){var statearr_54056 = state_54050;
(statearr_54056[(4)] = cljs.core.cons((5),(state_54050[(4)])));

return statearr_54056;
})();
var inst_54027 = fluree.db.util.async.channel_QMARK_(arg);
var state_54050__$1 = state_54050;
if(inst_54027){
var statearr_54057_54074 = state_54050__$1;
(statearr_54057_54074[(1)] = (6));

} else {
var statearr_54058_54075 = state_54050__$1;
(statearr_54058_54075[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54051 === (9))){
var inst_54030 = (state_54050[(2)]);
var inst_54031 = fluree.db.util.async.throw_err(inst_54030);
var state_54050__$1 = state_54050;
var statearr_54059_54076 = state_54050__$1;
(statearr_54059_54076[(2)] = inst_54031);

(statearr_54059_54076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54051 === (5))){
var _ = (function (){var statearr_54060 = state_54050;
(statearr_54060[(4)] = cljs.core.rest((state_54050[(4)])));

return statearr_54060;
})();
var state_54050__$1 = state_54050;
var ex54055 = (state_54050__$1[(2)]);
var statearr_54061_54077 = state_54050__$1;
(statearr_54061_54077[(5)] = ex54055);


if((ex54055 instanceof Error)){
var statearr_54062_54078 = state_54050__$1;
(statearr_54062_54078[(1)] = (4));

(statearr_54062_54078[(5)] = null);

} else {
throw ex54055;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54051 === (8))){
var inst_54034 = (state_54050[(2)]);
var inst_54035 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54034);
var inst_54036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54037 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54039 = [inst_54034];
var inst_54040 = (new cljs.core.PersistentVector(null,1,(5),inst_54038,inst_54039,null));
var inst_54041 = ["nil?",inst_54040,inst_54035];
var inst_54042 = cljs.core.PersistentHashMap.fromArrays(inst_54037,inst_54041);
var inst_54043 = [inst_54042,(10)];
var inst_54044 = (new cljs.core.PersistentVector(null,2,(5),inst_54036,inst_54043,null));
var inst_54045 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54044);
var _ = (function (){var statearr_54063 = state_54050;
(statearr_54063[(4)] = cljs.core.rest((state_54050[(4)])));

return statearr_54063;
})();
var state_54050__$1 = (function (){var statearr_54064 = state_54050;
(statearr_54064[(7)] = inst_54045);

return statearr_54064;
})();
var statearr_54065_54079 = state_54050__$1;
(statearr_54065_54079[(2)] = inst_54035);

(statearr_54065_54079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54066 = [null,null,null,null,null,null,null,null];
(statearr_54066[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_54066[(1)] = (1));

return statearr_54066;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_54050){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54050);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54067){var ex__2730__auto__ = e54067;
var statearr_54068_54080 = state_54050;
(statearr_54068_54080[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54050[(4)]))){
var statearr_54069_54081 = state_54050;
(statearr_54069_54081[(1)] = cljs.core.first((state_54050[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54082 = state_54050;
state_54050 = G__54082;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_54050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_54050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54070 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54070[(6)] = c__2749__auto__);

return statearr_54070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54112){
var state_val_54113 = (state_54112[(1)]);
if((state_val_54113 === (7))){
var state_54112__$1 = state_54112;
var statearr_54114_54133 = state_54112__$1;
(statearr_54114_54133[(2)] = arg);

(statearr_54114_54133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54113 === (1))){
var state_54112__$1 = state_54112;
var statearr_54115_54134 = state_54112__$1;
(statearr_54115_54134[(2)] = null);

(statearr_54115_54134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54113 === (4))){
var inst_54083 = (state_54112[(2)]);
var state_54112__$1 = state_54112;
var statearr_54116_54135 = state_54112__$1;
(statearr_54116_54135[(2)] = inst_54083);

(statearr_54116_54135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54113 === (6))){
var state_54112__$1 = state_54112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54112__$1,(9),arg);
} else {
if((state_val_54113 === (3))){
var inst_54110 = (state_54112[(2)]);
var state_54112__$1 = state_54112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54112__$1,inst_54110);
} else {
if((state_val_54113 === (2))){
var _ = (function (){var statearr_54118 = state_54112;
(statearr_54118[(4)] = cljs.core.cons((5),(state_54112[(4)])));

return statearr_54118;
})();
var inst_54089 = fluree.db.util.async.channel_QMARK_(arg);
var state_54112__$1 = state_54112;
if(inst_54089){
var statearr_54119_54136 = state_54112__$1;
(statearr_54119_54136[(1)] = (6));

} else {
var statearr_54120_54137 = state_54112__$1;
(statearr_54120_54137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54113 === (9))){
var inst_54092 = (state_54112[(2)]);
var inst_54093 = fluree.db.util.async.throw_err(inst_54092);
var state_54112__$1 = state_54112;
var statearr_54121_54138 = state_54112__$1;
(statearr_54121_54138[(2)] = inst_54093);

(statearr_54121_54138[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54113 === (5))){
var _ = (function (){var statearr_54122 = state_54112;
(statearr_54122[(4)] = cljs.core.rest((state_54112[(4)])));

return statearr_54122;
})();
var state_54112__$1 = state_54112;
var ex54117 = (state_54112__$1[(2)]);
var statearr_54123_54139 = state_54112__$1;
(statearr_54123_54139[(5)] = ex54117);


if((ex54117 instanceof Error)){
var statearr_54124_54140 = state_54112__$1;
(statearr_54124_54140[(1)] = (4));

(statearr_54124_54140[(5)] = null);

} else {
throw ex54117;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54113 === (8))){
var inst_54096 = (state_54112[(2)]);
var inst_54097 = fluree.db.dbfunctions.internal.not(inst_54096);
var inst_54098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54099 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54101 = [inst_54096];
var inst_54102 = (new cljs.core.PersistentVector(null,1,(5),inst_54100,inst_54101,null));
var inst_54103 = ["not",inst_54102,inst_54097];
var inst_54104 = cljs.core.PersistentHashMap.fromArrays(inst_54099,inst_54103);
var inst_54105 = [inst_54104,(10)];
var inst_54106 = (new cljs.core.PersistentVector(null,2,(5),inst_54098,inst_54105,null));
var inst_54107 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54106);
var _ = (function (){var statearr_54125 = state_54112;
(statearr_54125[(4)] = cljs.core.rest((state_54112[(4)])));

return statearr_54125;
})();
var state_54112__$1 = (function (){var statearr_54126 = state_54112;
(statearr_54126[(7)] = inst_54107);

return statearr_54126;
})();
var statearr_54127_54141 = state_54112__$1;
(statearr_54127_54141[(2)] = inst_54097);

(statearr_54127_54141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_54128 = [null,null,null,null,null,null,null,null];
(statearr_54128[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_54128[(1)] = (1));

return statearr_54128;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_54112){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54112);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54129){var ex__2730__auto__ = e54129;
var statearr_54130_54142 = state_54112;
(statearr_54130_54142[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54112[(4)]))){
var statearr_54131_54143 = state_54112;
(statearr_54131_54143[(1)] = cljs.core.first((state_54112[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54144 = state_54112;
state_54112 = G__54144;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_54112){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_54112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54132 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54132[(6)] = c__2749__auto__);

return statearr_54132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54174){
var state_val_54175 = (state_54174[(1)]);
if((state_val_54175 === (7))){
var state_54174__$1 = state_54174;
var statearr_54176_54195 = state_54174__$1;
(statearr_54176_54195[(2)] = arg);

(statearr_54176_54195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54175 === (1))){
var state_54174__$1 = state_54174;
var statearr_54177_54196 = state_54174__$1;
(statearr_54177_54196[(2)] = null);

(statearr_54177_54196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54175 === (4))){
var inst_54145 = (state_54174[(2)]);
var state_54174__$1 = state_54174;
var statearr_54178_54197 = state_54174__$1;
(statearr_54178_54197[(2)] = inst_54145);

(statearr_54178_54197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54175 === (6))){
var state_54174__$1 = state_54174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54174__$1,(9),arg);
} else {
if((state_val_54175 === (3))){
var inst_54172 = (state_54174[(2)]);
var state_54174__$1 = state_54174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54174__$1,inst_54172);
} else {
if((state_val_54175 === (2))){
var _ = (function (){var statearr_54180 = state_54174;
(statearr_54180[(4)] = cljs.core.cons((5),(state_54174[(4)])));

return statearr_54180;
})();
var inst_54151 = fluree.db.util.async.channel_QMARK_(arg);
var state_54174__$1 = state_54174;
if(inst_54151){
var statearr_54181_54198 = state_54174__$1;
(statearr_54181_54198[(1)] = (6));

} else {
var statearr_54182_54199 = state_54174__$1;
(statearr_54182_54199[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54175 === (9))){
var inst_54154 = (state_54174[(2)]);
var inst_54155 = fluree.db.util.async.throw_err(inst_54154);
var state_54174__$1 = state_54174;
var statearr_54183_54200 = state_54174__$1;
(statearr_54183_54200[(2)] = inst_54155);

(statearr_54183_54200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54175 === (5))){
var _ = (function (){var statearr_54184 = state_54174;
(statearr_54184[(4)] = cljs.core.rest((state_54174[(4)])));

return statearr_54184;
})();
var state_54174__$1 = state_54174;
var ex54179 = (state_54174__$1[(2)]);
var statearr_54185_54201 = state_54174__$1;
(statearr_54185_54201[(5)] = ex54179);


if((ex54179 instanceof Error)){
var statearr_54186_54202 = state_54174__$1;
(statearr_54186_54202[(1)] = (4));

(statearr_54186_54202[(5)] = null);

} else {
throw ex54179;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54175 === (8))){
var inst_54158 = (state_54174[(2)]);
var inst_54159 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54158);
var inst_54160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54161 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54163 = [inst_54158];
var inst_54164 = (new cljs.core.PersistentVector(null,1,(5),inst_54162,inst_54163,null));
var inst_54165 = ["empty?",inst_54164,inst_54159];
var inst_54166 = cljs.core.PersistentHashMap.fromArrays(inst_54161,inst_54165);
var inst_54167 = [inst_54166,(10)];
var inst_54168 = (new cljs.core.PersistentVector(null,2,(5),inst_54160,inst_54167,null));
var inst_54169 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54168);
var _ = (function (){var statearr_54187 = state_54174;
(statearr_54187[(4)] = cljs.core.rest((state_54174[(4)])));

return statearr_54187;
})();
var state_54174__$1 = (function (){var statearr_54188 = state_54174;
(statearr_54188[(7)] = inst_54169);

return statearr_54188;
})();
var statearr_54189_54203 = state_54174__$1;
(statearr_54189_54203[(2)] = inst_54159);

(statearr_54189_54203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54190 = [null,null,null,null,null,null,null,null];
(statearr_54190[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_54190[(1)] = (1));

return statearr_54190;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_54174){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54174);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54191){var ex__2730__auto__ = e54191;
var statearr_54192_54204 = state_54174;
(statearr_54192_54204[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54174[(4)]))){
var statearr_54193_54205 = state_54174;
(statearr_54193_54205[(1)] = cljs.core.first((state_54174[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54206 = state_54174;
state_54174 = G__54206;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_54174){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_54174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54194 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54194[(6)] = c__2749__auto__);

return statearr_54194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54251 = arguments.length;
var i__5770__auto___54252 = (0);
while(true){
if((i__5770__auto___54252 < len__5769__auto___54251)){
args__5775__auto__.push((arguments[i__5770__auto___54252]));

var G__54253 = (i__5770__auto___54252 + (1));
i__5770__auto___54252 = G__54253;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54234){
var state_val_54235 = (state_54234[(1)]);
if((state_val_54235 === (1))){
var state_54234__$1 = state_54234;
var statearr_54236_54254 = state_54234__$1;
(statearr_54236_54254[(2)] = null);

(statearr_54236_54254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54235 === (2))){
var _ = (function (){var statearr_54237 = state_54234;
(statearr_54237[(4)] = cljs.core.cons((5),(state_54234[(4)])));

return statearr_54237;
})();
var inst_54215 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54234__$1 = state_54234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54234__$1,(6),inst_54215);
} else {
if((state_val_54235 === (3))){
var inst_54232 = (state_54234[(2)]);
var state_54234__$1 = state_54234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54234__$1,inst_54232);
} else {
if((state_val_54235 === (4))){
var inst_54209 = (state_54234[(2)]);
var state_54234__$1 = state_54234;
var statearr_54239_54255 = state_54234__$1;
(statearr_54239_54255[(2)] = inst_54209);

(statearr_54239_54255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54235 === (5))){
var _ = (function (){var statearr_54240 = state_54234;
(statearr_54240[(4)] = cljs.core.rest((state_54234[(4)])));

return statearr_54240;
})();
var state_54234__$1 = state_54234;
var ex54238 = (state_54234__$1[(2)]);
var statearr_54241_54256 = state_54234__$1;
(statearr_54241_54256[(5)] = ex54238);


if((ex54238 instanceof Error)){
var statearr_54242_54257 = state_54234__$1;
(statearr_54242_54257[(1)] = (4));

(statearr_54242_54257[(5)] = null);

} else {
throw ex54238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54235 === (6))){
var inst_54217 = (state_54234[(2)]);
var inst_54218 = fluree.db.util.async.throw_err(inst_54217);
var inst_54219 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54218);
var inst_54220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54221 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54223 = [inst_54218];
var inst_54224 = (new cljs.core.PersistentVector(null,1,(5),inst_54222,inst_54223,null));
var inst_54225 = ["str",inst_54224,inst_54219];
var inst_54226 = cljs.core.PersistentHashMap.fromArrays(inst_54221,inst_54225);
var inst_54227 = [inst_54226,(10)];
var inst_54228 = (new cljs.core.PersistentVector(null,2,(5),inst_54220,inst_54227,null));
var inst_54229 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54228);
var _ = (function (){var statearr_54243 = state_54234;
(statearr_54243[(4)] = cljs.core.rest((state_54234[(4)])));

return statearr_54243;
})();
var state_54234__$1 = (function (){var statearr_54244 = state_54234;
(statearr_54244[(7)] = inst_54229);

return statearr_54244;
})();
var statearr_54245_54258 = state_54234__$1;
(statearr_54245_54258[(2)] = inst_54219);

(statearr_54245_54258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54246 = [null,null,null,null,null,null,null,null];
(statearr_54246[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54246[(1)] = (1));

return statearr_54246;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54234){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54234);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54247){var ex__2730__auto__ = e54247;
var statearr_54248_54259 = state_54234;
(statearr_54248_54259[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54234[(4)]))){
var statearr_54249_54260 = state_54234;
(statearr_54249_54260[(1)] = cljs.core.first((state_54234[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54261 = state_54234;
state_54234 = G__54261;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54234){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54250 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54250[(6)] = c__2749__auto__);

return statearr_54250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54207){
var G__54208 = cljs.core.first(seq54207);
var seq54207__$1 = cljs.core.next(seq54207);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54208,seq54207__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54287){
var state_val_54288 = (state_54287[(1)]);
if((state_val_54288 === (1))){
var state_54287__$1 = state_54287;
var statearr_54289_54304 = state_54287__$1;
(statearr_54289_54304[(2)] = null);

(statearr_54289_54304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54288 === (2))){
var _ = (function (){var statearr_54290 = state_54287;
(statearr_54290[(4)] = cljs.core.cons((5),(state_54287[(4)])));

return statearr_54290;
})();
var inst_54268 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54287__$1 = state_54287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54287__$1,(6),inst_54268);
} else {
if((state_val_54288 === (3))){
var inst_54285 = (state_54287[(2)]);
var state_54287__$1 = state_54287;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54287__$1,inst_54285);
} else {
if((state_val_54288 === (4))){
var inst_54262 = (state_54287[(2)]);
var state_54287__$1 = state_54287;
var statearr_54292_54305 = state_54287__$1;
(statearr_54292_54305[(2)] = inst_54262);

(statearr_54292_54305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54288 === (5))){
var _ = (function (){var statearr_54293 = state_54287;
(statearr_54293[(4)] = cljs.core.rest((state_54287[(4)])));

return statearr_54293;
})();
var state_54287__$1 = state_54287;
var ex54291 = (state_54287__$1[(2)]);
var statearr_54294_54306 = state_54287__$1;
(statearr_54294_54306[(5)] = ex54291);


if((ex54291 instanceof Error)){
var statearr_54295_54307 = state_54287__$1;
(statearr_54295_54307[(1)] = (4));

(statearr_54295_54307[(5)] = null);

} else {
throw ex54291;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54288 === (6))){
var inst_54270 = (state_54287[(2)]);
var inst_54271 = fluree.db.util.async.throw_err(inst_54270);
var inst_54272 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54271);
var inst_54273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54274 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54276 = [inst_54271];
var inst_54277 = (new cljs.core.PersistentVector(null,1,(5),inst_54275,inst_54276,null));
var inst_54278 = ["subs",inst_54277,inst_54272];
var inst_54279 = cljs.core.PersistentHashMap.fromArrays(inst_54274,inst_54278);
var inst_54280 = [inst_54279,(30)];
var inst_54281 = (new cljs.core.PersistentVector(null,2,(5),inst_54273,inst_54280,null));
var inst_54282 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54281);
var _ = (function (){var statearr_54296 = state_54287;
(statearr_54296[(4)] = cljs.core.rest((state_54287[(4)])));

return statearr_54296;
})();
var state_54287__$1 = (function (){var statearr_54297 = state_54287;
(statearr_54297[(7)] = inst_54282);

return statearr_54297;
})();
var statearr_54298_54308 = state_54287__$1;
(statearr_54298_54308[(2)] = inst_54272);

(statearr_54298_54308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_54299 = [null,null,null,null,null,null,null,null];
(statearr_54299[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_54299[(1)] = (1));

return statearr_54299;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_54287){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54287);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54300){var ex__2730__auto__ = e54300;
var statearr_54301_54309 = state_54287;
(statearr_54301_54309[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54287[(4)]))){
var statearr_54302_54310 = state_54287;
(statearr_54302_54310[(1)] = cljs.core.first((state_54287[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54311 = state_54287;
state_54287 = G__54311;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_54287){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_54287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54303 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54303[(6)] = c__2749__auto__);

return statearr_54303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54341){
var state_val_54342 = (state_54341[(1)]);
if((state_val_54342 === (7))){
var state_54341__$1 = state_54341;
var statearr_54343_54362 = state_54341__$1;
(statearr_54343_54362[(2)] = str);

(statearr_54343_54362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54342 === (1))){
var state_54341__$1 = state_54341;
var statearr_54344_54363 = state_54341__$1;
(statearr_54344_54363[(2)] = null);

(statearr_54344_54363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54342 === (4))){
var inst_54312 = (state_54341[(2)]);
var state_54341__$1 = state_54341;
var statearr_54345_54364 = state_54341__$1;
(statearr_54345_54364[(2)] = inst_54312);

(statearr_54345_54364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54342 === (6))){
var state_54341__$1 = state_54341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54341__$1,(9),str);
} else {
if((state_val_54342 === (3))){
var inst_54339 = (state_54341[(2)]);
var state_54341__$1 = state_54341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54341__$1,inst_54339);
} else {
if((state_val_54342 === (2))){
var _ = (function (){var statearr_54347 = state_54341;
(statearr_54347[(4)] = cljs.core.cons((5),(state_54341[(4)])));

return statearr_54347;
})();
var inst_54318 = fluree.db.util.async.channel_QMARK_(str);
var state_54341__$1 = state_54341;
if(inst_54318){
var statearr_54348_54365 = state_54341__$1;
(statearr_54348_54365[(1)] = (6));

} else {
var statearr_54349_54366 = state_54341__$1;
(statearr_54349_54366[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54342 === (9))){
var inst_54321 = (state_54341[(2)]);
var inst_54322 = fluree.db.util.async.throw_err(inst_54321);
var state_54341__$1 = state_54341;
var statearr_54350_54367 = state_54341__$1;
(statearr_54350_54367[(2)] = inst_54322);

(statearr_54350_54367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54342 === (5))){
var _ = (function (){var statearr_54351 = state_54341;
(statearr_54351[(4)] = cljs.core.rest((state_54341[(4)])));

return statearr_54351;
})();
var state_54341__$1 = state_54341;
var ex54346 = (state_54341__$1[(2)]);
var statearr_54352_54368 = state_54341__$1;
(statearr_54352_54368[(5)] = ex54346);


if((ex54346 instanceof Error)){
var statearr_54353_54369 = state_54341__$1;
(statearr_54353_54369[(1)] = (4));

(statearr_54353_54369[(5)] = null);

} else {
throw ex54346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54342 === (8))){
var inst_54325 = (state_54341[(2)]);
var inst_54326 = fluree.db.dbfunctions.internal.lower_case(inst_54325);
var inst_54327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54328 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54330 = [inst_54325];
var inst_54331 = (new cljs.core.PersistentVector(null,1,(5),inst_54329,inst_54330,null));
var inst_54332 = ["lower-case",inst_54331,inst_54326];
var inst_54333 = cljs.core.PersistentHashMap.fromArrays(inst_54328,inst_54332);
var inst_54334 = [inst_54333,(10)];
var inst_54335 = (new cljs.core.PersistentVector(null,2,(5),inst_54327,inst_54334,null));
var inst_54336 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54335);
var _ = (function (){var statearr_54354 = state_54341;
(statearr_54354[(4)] = cljs.core.rest((state_54341[(4)])));

return statearr_54354;
})();
var state_54341__$1 = (function (){var statearr_54355 = state_54341;
(statearr_54355[(7)] = inst_54336);

return statearr_54355;
})();
var statearr_54356_54370 = state_54341__$1;
(statearr_54356_54370[(2)] = inst_54326);

(statearr_54356_54370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_54357 = [null,null,null,null,null,null,null,null];
(statearr_54357[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_54357[(1)] = (1));

return statearr_54357;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_54341){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54341);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54358){var ex__2730__auto__ = e54358;
var statearr_54359_54371 = state_54341;
(statearr_54359_54371[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54341[(4)]))){
var statearr_54360_54372 = state_54341;
(statearr_54360_54372[(1)] = cljs.core.first((state_54341[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54373 = state_54341;
state_54341 = G__54373;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_54341){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_54341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54361 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54361[(6)] = c__2749__auto__);

return statearr_54361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54403){
var state_val_54404 = (state_54403[(1)]);
if((state_val_54404 === (7))){
var state_54403__$1 = state_54403;
var statearr_54405_54424 = state_54403__$1;
(statearr_54405_54424[(2)] = str);

(statearr_54405_54424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (1))){
var state_54403__$1 = state_54403;
var statearr_54406_54425 = state_54403__$1;
(statearr_54406_54425[(2)] = null);

(statearr_54406_54425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (4))){
var inst_54374 = (state_54403[(2)]);
var state_54403__$1 = state_54403;
var statearr_54407_54426 = state_54403__$1;
(statearr_54407_54426[(2)] = inst_54374);

(statearr_54407_54426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (6))){
var state_54403__$1 = state_54403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54403__$1,(9),str);
} else {
if((state_val_54404 === (3))){
var inst_54401 = (state_54403[(2)]);
var state_54403__$1 = state_54403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54403__$1,inst_54401);
} else {
if((state_val_54404 === (2))){
var _ = (function (){var statearr_54409 = state_54403;
(statearr_54409[(4)] = cljs.core.cons((5),(state_54403[(4)])));

return statearr_54409;
})();
var inst_54380 = fluree.db.util.async.channel_QMARK_(str);
var state_54403__$1 = state_54403;
if(inst_54380){
var statearr_54410_54427 = state_54403__$1;
(statearr_54410_54427[(1)] = (6));

} else {
var statearr_54411_54428 = state_54403__$1;
(statearr_54411_54428[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (9))){
var inst_54383 = (state_54403[(2)]);
var inst_54384 = fluree.db.util.async.throw_err(inst_54383);
var state_54403__$1 = state_54403;
var statearr_54412_54429 = state_54403__$1;
(statearr_54412_54429[(2)] = inst_54384);

(statearr_54412_54429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (5))){
var _ = (function (){var statearr_54413 = state_54403;
(statearr_54413[(4)] = cljs.core.rest((state_54403[(4)])));

return statearr_54413;
})();
var state_54403__$1 = state_54403;
var ex54408 = (state_54403__$1[(2)]);
var statearr_54414_54430 = state_54403__$1;
(statearr_54414_54430[(5)] = ex54408);


if((ex54408 instanceof Error)){
var statearr_54415_54431 = state_54403__$1;
(statearr_54415_54431[(1)] = (4));

(statearr_54415_54431[(5)] = null);

} else {
throw ex54408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (8))){
var inst_54387 = (state_54403[(2)]);
var inst_54388 = fluree.db.dbfunctions.internal.upper_case(inst_54387);
var inst_54389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54390 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54392 = [inst_54387];
var inst_54393 = (new cljs.core.PersistentVector(null,1,(5),inst_54391,inst_54392,null));
var inst_54394 = ["upper-case",inst_54393,inst_54388];
var inst_54395 = cljs.core.PersistentHashMap.fromArrays(inst_54390,inst_54394);
var inst_54396 = [inst_54395,(10)];
var inst_54397 = (new cljs.core.PersistentVector(null,2,(5),inst_54389,inst_54396,null));
var inst_54398 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54397);
var _ = (function (){var statearr_54416 = state_54403;
(statearr_54416[(4)] = cljs.core.rest((state_54403[(4)])));

return statearr_54416;
})();
var state_54403__$1 = (function (){var statearr_54417 = state_54403;
(statearr_54417[(7)] = inst_54398);

return statearr_54417;
})();
var statearr_54418_54432 = state_54403__$1;
(statearr_54418_54432[(2)] = inst_54388);

(statearr_54418_54432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_54419 = [null,null,null,null,null,null,null,null];
(statearr_54419[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_54419[(1)] = (1));

return statearr_54419;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_54403){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54403);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54420){var ex__2730__auto__ = e54420;
var statearr_54421_54433 = state_54403;
(statearr_54421_54433[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54403[(4)]))){
var statearr_54422_54434 = state_54403;
(statearr_54422_54434[(1)] = cljs.core.first((state_54403[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54435 = state_54403;
state_54403 = G__54435;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_54403){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_54403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54423 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54423[(6)] = c__2749__auto__);

return statearr_54423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54437 = arguments.length;
switch (G__54437) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54465){
var state_val_54466 = (state_54465[(1)]);
if((state_val_54466 === (1))){
var state_54465__$1 = state_54465;
var statearr_54467_54483 = state_54465__$1;
(statearr_54467_54483[(2)] = null);

(statearr_54467_54483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (2))){
var _ = (function (){var statearr_54468 = state_54465;
(statearr_54468[(4)] = cljs.core.cons((5),(state_54465[(4)])));

return statearr_54468;
})();
var inst_54447 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54465__$1 = state_54465;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54465__$1,(6),inst_54447);
} else {
if((state_val_54466 === (3))){
var inst_54463 = (state_54465[(2)]);
var state_54465__$1 = state_54465;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54465__$1,inst_54463);
} else {
if((state_val_54466 === (4))){
var inst_54438 = (state_54465[(2)]);
var state_54465__$1 = state_54465;
var statearr_54470_54484 = state_54465__$1;
(statearr_54470_54484[(2)] = inst_54438);

(statearr_54470_54484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (5))){
var _ = (function (){var statearr_54471 = state_54465;
(statearr_54471[(4)] = cljs.core.rest((state_54465[(4)])));

return statearr_54471;
})();
var state_54465__$1 = state_54465;
var ex54469 = (state_54465__$1[(2)]);
var statearr_54472_54485 = state_54465__$1;
(statearr_54472_54485[(5)] = ex54469);


if((ex54469 instanceof Error)){
var statearr_54473_54486 = state_54465__$1;
(statearr_54473_54486[(1)] = (4));

(statearr_54473_54486[(5)] = null);

} else {
throw ex54469;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (6))){
var inst_54449 = (state_54465[(2)]);
var inst_54450 = fluree.db.util.async.throw_err(inst_54449);
var inst_54451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54450,(0),null);
var inst_54452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54450,(1),null);
var inst_54453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54454 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54455 = ["?s","?ctx",inst_54451];
var inst_54456 = cljs.core.PersistentHashMap.fromArrays(inst_54454,inst_54455);
var inst_54457 = ((10) + inst_54452);
var inst_54458 = [inst_54456,inst_54457];
var inst_54459 = (new cljs.core.PersistentVector(null,2,(5),inst_54453,inst_54458,null));
var inst_54460 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54459);
var _ = (function (){var statearr_54474 = state_54465;
(statearr_54474[(4)] = cljs.core.rest((state_54465[(4)])));

return statearr_54474;
})();
var state_54465__$1 = (function (){var statearr_54475 = state_54465;
(statearr_54475[(7)] = inst_54460);

return statearr_54475;
})();
var statearr_54476_54487 = state_54465__$1;
(statearr_54476_54487[(2)] = inst_54451);

(statearr_54476_54487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54477 = [null,null,null,null,null,null,null,null];
(statearr_54477[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54477[(1)] = (1));

return statearr_54477;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54465){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54465);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54478){var ex__2730__auto__ = e54478;
var statearr_54479_54488 = state_54465;
(statearr_54479_54488[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54465[(4)]))){
var statearr_54480_54489 = state_54465;
(statearr_54480_54489[(1)] = cljs.core.first((state_54465[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54490 = state_54465;
state_54465 = G__54490;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54465){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54481 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54481[(6)] = c__2749__auto__);

return statearr_54481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54492 = arguments.length;
switch (G__54492) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54530){
var state_val_54531 = (state_54530[(1)]);
if((state_val_54531 === (7))){
var inst_54523 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54530__$1 = state_54530;
var statearr_54532_54552 = state_54530__$1;
(statearr_54532_54552[(2)] = inst_54523);

(statearr_54532_54552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54531 === (1))){
var state_54530__$1 = state_54530;
var statearr_54533_54553 = state_54530__$1;
(statearr_54533_54553[(2)] = null);

(statearr_54533_54553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54531 === (4))){
var inst_54493 = (state_54530[(2)]);
var state_54530__$1 = state_54530;
var statearr_54534_54554 = state_54530__$1;
(statearr_54534_54554[(2)] = inst_54493);

(statearr_54534_54554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54531 === (6))){
var inst_54504 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54530__$1 = state_54530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54530__$1,(10),inst_54504);
} else {
if((state_val_54531 === (3))){
var inst_54528 = (state_54530[(2)]);
var state_54530__$1 = state_54530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54530__$1,inst_54528);
} else {
if((state_val_54531 === (2))){
var _ = (function (){var statearr_54536 = state_54530;
(statearr_54536[(4)] = cljs.core.cons((5),(state_54530[(4)])));

return statearr_54536;
})();
var inst_54499 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54530__$1 = state_54530;
if(cljs.core.truth_(inst_54499)){
var statearr_54537_54555 = state_54530__$1;
(statearr_54537_54555[(1)] = (6));

} else {
var statearr_54538_54556 = state_54530__$1;
(statearr_54538_54556[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54531 === (9))){
var inst_54510 = (state_54530[(2)]);
var inst_54511 = fluree.db.util.async.throw_err(inst_54510);
var inst_54512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54511,(0),null);
var inst_54513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54511,(1),null);
var inst_54514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54515 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54516 = ["?p","?ctx",inst_54512];
var inst_54517 = cljs.core.PersistentHashMap.fromArrays(inst_54515,inst_54516);
var inst_54518 = ((10) + inst_54513);
var inst_54519 = [inst_54517,inst_54518];
var inst_54520 = (new cljs.core.PersistentVector(null,2,(5),inst_54514,inst_54519,null));
var inst_54521 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54520);
var state_54530__$1 = (function (){var statearr_54539 = state_54530;
(statearr_54539[(7)] = inst_54521);

return statearr_54539;
})();
var statearr_54540_54557 = state_54530__$1;
(statearr_54540_54557[(2)] = inst_54512);

(statearr_54540_54557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54531 === (5))){
var _ = (function (){var statearr_54541 = state_54530;
(statearr_54541[(4)] = cljs.core.rest((state_54530[(4)])));

return statearr_54541;
})();
var state_54530__$1 = state_54530;
var ex54535 = (state_54530__$1[(2)]);
var statearr_54542_54558 = state_54530__$1;
(statearr_54542_54558[(5)] = ex54535);


if((ex54535 instanceof Error)){
var statearr_54543_54559 = state_54530__$1;
(statearr_54543_54559[(1)] = (4));

(statearr_54543_54559[(5)] = null);

} else {
throw ex54535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54531 === (10))){
var inst_54506 = (state_54530[(2)]);
var inst_54507 = fluree.db.util.async.throw_err(inst_54506);
var inst_54508 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54507);
var state_54530__$1 = state_54530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54530__$1,(9),inst_54508);
} else {
if((state_val_54531 === (8))){
var inst_54525 = (state_54530[(2)]);
var _ = (function (){var statearr_54544 = state_54530;
(statearr_54544[(4)] = cljs.core.rest((state_54530[(4)])));

return statearr_54544;
})();
var state_54530__$1 = state_54530;
var statearr_54545_54560 = state_54530__$1;
(statearr_54545_54560[(2)] = inst_54525);

(statearr_54545_54560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54546 = [null,null,null,null,null,null,null,null];
(statearr_54546[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54546[(1)] = (1));

return statearr_54546;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54530){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54530);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54547){var ex__2730__auto__ = e54547;
var statearr_54548_54561 = state_54530;
(statearr_54548_54561[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54530[(4)]))){
var statearr_54549_54562 = state_54530;
(statearr_54549_54562[(1)] = cljs.core.first((state_54530[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54563 = state_54530;
state_54530 = G__54563;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54530){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54550 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54550[(6)] = c__2749__auto__);

return statearr_54550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54612 = arguments.length;
var i__5770__auto___54613 = (0);
while(true){
if((i__5770__auto___54613 < len__5769__auto___54612)){
args__5775__auto__.push((arguments[i__5770__auto___54613]));

var G__54614 = (i__5770__auto___54613 + (1));
i__5770__auto___54613 = G__54614;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54595){
var state_val_54596 = (state_54595[(1)]);
if((state_val_54596 === (1))){
var state_54595__$1 = state_54595;
var statearr_54597_54615 = state_54595__$1;
(statearr_54597_54615[(2)] = null);

(statearr_54597_54615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54596 === (2))){
var _ = (function (){var statearr_54598 = state_54595;
(statearr_54598[(4)] = cljs.core.cons((5),(state_54595[(4)])));

return statearr_54598;
})();
var inst_54572 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54595__$1 = state_54595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54595__$1,(6),inst_54572);
} else {
if((state_val_54596 === (3))){
var inst_54593 = (state_54595[(2)]);
var state_54595__$1 = state_54595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54595__$1,inst_54593);
} else {
if((state_val_54596 === (4))){
var inst_54566 = (state_54595[(2)]);
var state_54595__$1 = state_54595;
var statearr_54600_54616 = state_54595__$1;
(statearr_54600_54616[(2)] = inst_54566);

(statearr_54600_54616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54596 === (5))){
var _ = (function (){var statearr_54601 = state_54595;
(statearr_54601[(4)] = cljs.core.rest((state_54595[(4)])));

return statearr_54601;
})();
var state_54595__$1 = state_54595;
var ex54599 = (state_54595__$1[(2)]);
var statearr_54602_54617 = state_54595__$1;
(statearr_54602_54617[(5)] = ex54599);


if((ex54599 instanceof Error)){
var statearr_54603_54618 = state_54595__$1;
(statearr_54603_54618[(1)] = (4));

(statearr_54603_54618[(5)] = null);

} else {
throw ex54599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54596 === (6))){
var inst_54574 = (state_54595[(2)]);
var inst_54575 = fluree.db.util.async.throw_err(inst_54574);
var inst_54576 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54575);
var inst_54577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54578 = [inst_54575];
var inst_54579 = (new cljs.core.PersistentVector(null,1,(5),inst_54577,inst_54578,null));
var inst_54580 = cljs.core.count(inst_54579);
var inst_54581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54582 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54584 = [inst_54575];
var inst_54585 = (new cljs.core.PersistentVector(null,1,(5),inst_54583,inst_54584,null));
var inst_54586 = ["and",inst_54585,inst_54576];
var inst_54587 = cljs.core.PersistentHashMap.fromArrays(inst_54582,inst_54586);
var inst_54588 = [inst_54587,inst_54580];
var inst_54589 = (new cljs.core.PersistentVector(null,2,(5),inst_54581,inst_54588,null));
var inst_54590 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54589);
var _ = (function (){var statearr_54604 = state_54595;
(statearr_54604[(4)] = cljs.core.rest((state_54595[(4)])));

return statearr_54604;
})();
var state_54595__$1 = (function (){var statearr_54605 = state_54595;
(statearr_54605[(7)] = inst_54590);

return statearr_54605;
})();
var statearr_54606_54619 = state_54595__$1;
(statearr_54606_54619[(2)] = inst_54576);

(statearr_54606_54619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54607 = [null,null,null,null,null,null,null,null];
(statearr_54607[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54607[(1)] = (1));

return statearr_54607;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54595){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54595);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54608){var ex__2730__auto__ = e54608;
var statearr_54609_54620 = state_54595;
(statearr_54609_54620[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54595[(4)]))){
var statearr_54610_54621 = state_54595;
(statearr_54610_54621[(1)] = cljs.core.first((state_54595[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54622 = state_54595;
state_54595 = G__54622;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54595){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54611 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54611[(6)] = c__2749__auto__);

return statearr_54611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54564){
var G__54565 = cljs.core.first(seq54564);
var seq54564__$1 = cljs.core.next(seq54564);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54565,seq54564__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54671 = arguments.length;
var i__5770__auto___54672 = (0);
while(true){
if((i__5770__auto___54672 < len__5769__auto___54671)){
args__5775__auto__.push((arguments[i__5770__auto___54672]));

var G__54673 = (i__5770__auto___54672 + (1));
i__5770__auto___54672 = G__54673;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54654){
var state_val_54655 = (state_54654[(1)]);
if((state_val_54655 === (1))){
var state_54654__$1 = state_54654;
var statearr_54656_54674 = state_54654__$1;
(statearr_54656_54674[(2)] = null);

(statearr_54656_54674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54655 === (2))){
var _ = (function (){var statearr_54657 = state_54654;
(statearr_54657[(4)] = cljs.core.cons((5),(state_54654[(4)])));

return statearr_54657;
})();
var inst_54631 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54654__$1 = state_54654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54654__$1,(6),inst_54631);
} else {
if((state_val_54655 === (3))){
var inst_54652 = (state_54654[(2)]);
var state_54654__$1 = state_54654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54654__$1,inst_54652);
} else {
if((state_val_54655 === (4))){
var inst_54625 = (state_54654[(2)]);
var state_54654__$1 = state_54654;
var statearr_54659_54675 = state_54654__$1;
(statearr_54659_54675[(2)] = inst_54625);

(statearr_54659_54675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54655 === (5))){
var _ = (function (){var statearr_54660 = state_54654;
(statearr_54660[(4)] = cljs.core.rest((state_54654[(4)])));

return statearr_54660;
})();
var state_54654__$1 = state_54654;
var ex54658 = (state_54654__$1[(2)]);
var statearr_54661_54676 = state_54654__$1;
(statearr_54661_54676[(5)] = ex54658);


if((ex54658 instanceof Error)){
var statearr_54662_54677 = state_54654__$1;
(statearr_54662_54677[(1)] = (4));

(statearr_54662_54677[(5)] = null);

} else {
throw ex54658;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54655 === (6))){
var inst_54633 = (state_54654[(2)]);
var inst_54634 = fluree.db.util.async.throw_err(inst_54633);
var inst_54635 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54634);
var inst_54636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54637 = [inst_54634];
var inst_54638 = (new cljs.core.PersistentVector(null,1,(5),inst_54636,inst_54637,null));
var inst_54639 = cljs.core.count(inst_54638);
var inst_54640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54641 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54643 = [inst_54634];
var inst_54644 = (new cljs.core.PersistentVector(null,1,(5),inst_54642,inst_54643,null));
var inst_54645 = ["or",inst_54644,inst_54635];
var inst_54646 = cljs.core.PersistentHashMap.fromArrays(inst_54641,inst_54645);
var inst_54647 = [inst_54646,inst_54639];
var inst_54648 = (new cljs.core.PersistentVector(null,2,(5),inst_54640,inst_54647,null));
var inst_54649 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54648);
var _ = (function (){var statearr_54663 = state_54654;
(statearr_54663[(4)] = cljs.core.rest((state_54654[(4)])));

return statearr_54663;
})();
var state_54654__$1 = (function (){var statearr_54664 = state_54654;
(statearr_54664[(7)] = inst_54649);

return statearr_54664;
})();
var statearr_54665_54678 = state_54654__$1;
(statearr_54665_54678[(2)] = inst_54635);

(statearr_54665_54678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54666 = [null,null,null,null,null,null,null,null];
(statearr_54666[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54666[(1)] = (1));

return statearr_54666;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54654){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54654);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54667){var ex__2730__auto__ = e54667;
var statearr_54668_54679 = state_54654;
(statearr_54668_54679[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54654[(4)]))){
var statearr_54669_54680 = state_54654;
(statearr_54669_54680[(1)] = cljs.core.first((state_54654[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54681 = state_54654;
state_54654 = G__54681;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54654){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54670 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54670[(6)] = c__2749__auto__);

return statearr_54670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54623){
var G__54624 = cljs.core.first(seq54623);
var seq54623__$1 = cljs.core.next(seq54623);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54624,seq54623__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54719){
var state_val_54720 = (state_54719[(1)]);
if((state_val_54720 === (7))){
var inst_54695 = fluree.db.util.async.channel_QMARK_(coll);
var state_54719__$1 = state_54719;
if(inst_54695){
var statearr_54721_54744 = state_54719__$1;
(statearr_54721_54744[(1)] = (10));

} else {
var statearr_54722_54745 = state_54719__$1;
(statearr_54722_54745[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (1))){
var state_54719__$1 = state_54719;
var statearr_54723_54746 = state_54719__$1;
(statearr_54723_54746[(2)] = null);

(statearr_54723_54746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (4))){
var inst_54682 = (state_54719[(2)]);
var state_54719__$1 = state_54719;
var statearr_54724_54747 = state_54719__$1;
(statearr_54724_54747[(2)] = inst_54682);

(statearr_54724_54747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (13))){
var inst_54698 = (state_54719[(2)]);
var inst_54699 = fluree.db.util.async.throw_err(inst_54698);
var state_54719__$1 = state_54719;
var statearr_54725_54748 = state_54719__$1;
(statearr_54725_54748[(2)] = inst_54699);

(statearr_54725_54748[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (6))){
var inst_54690 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54719__$1 = state_54719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54719__$1,(9),inst_54690);
} else {
if((state_val_54720 === (3))){
var inst_54717 = (state_54719[(2)]);
var state_54719__$1 = state_54719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54719__$1,inst_54717);
} else {
if((state_val_54720 === (12))){
var inst_54702 = (state_54719[(2)]);
var state_54719__$1 = state_54719;
var statearr_54726_54749 = state_54719__$1;
(statearr_54726_54749[(2)] = inst_54702);

(statearr_54726_54749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (2))){
var _ = (function (){var statearr_54727 = state_54719;
(statearr_54727[(4)] = cljs.core.cons((5),(state_54719[(4)])));

return statearr_54727;
})();
var inst_54688 = cljs.core.vector_QMARK_(coll);
var state_54719__$1 = state_54719;
if(inst_54688){
var statearr_54728_54750 = state_54719__$1;
(statearr_54728_54750[(1)] = (6));

} else {
var statearr_54729_54751 = state_54719__$1;
(statearr_54729_54751[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (11))){
var state_54719__$1 = state_54719;
var statearr_54731_54752 = state_54719__$1;
(statearr_54731_54752[(2)] = coll);

(statearr_54731_54752[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (9))){
var inst_54692 = (state_54719[(2)]);
var inst_54693 = fluree.db.util.async.throw_err(inst_54692);
var state_54719__$1 = state_54719;
var statearr_54732_54753 = state_54719__$1;
(statearr_54732_54753[(2)] = inst_54693);

(statearr_54732_54753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (5))){
var _ = (function (){var statearr_54733 = state_54719;
(statearr_54733[(4)] = cljs.core.rest((state_54719[(4)])));

return statearr_54733;
})();
var state_54719__$1 = state_54719;
var ex54730 = (state_54719__$1[(2)]);
var statearr_54734_54754 = state_54719__$1;
(statearr_54734_54754[(5)] = ex54730);


if((ex54730 instanceof Error)){
var statearr_54735_54755 = state_54719__$1;
(statearr_54735_54755[(1)] = (4));

(statearr_54735_54755[(5)] = null);

} else {
throw ex54730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54720 === (10))){
var state_54719__$1 = state_54719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54719__$1,(13),coll);
} else {
if((state_val_54720 === (8))){
var inst_54704 = (state_54719[(2)]);
var inst_54705 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54704);
var inst_54706 = cljs.core.count(inst_54705);
var inst_54707 = ((9) + inst_54706);
var inst_54708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54709 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54710 = ["count",inst_54704,inst_54706];
var inst_54711 = cljs.core.PersistentHashMap.fromArrays(inst_54709,inst_54710);
var inst_54712 = [inst_54711,inst_54707];
var inst_54713 = (new cljs.core.PersistentVector(null,2,(5),inst_54708,inst_54712,null));
var inst_54714 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54713);
var _ = (function (){var statearr_54736 = state_54719;
(statearr_54736[(4)] = cljs.core.rest((state_54719[(4)])));

return statearr_54736;
})();
var state_54719__$1 = (function (){var statearr_54737 = state_54719;
(statearr_54737[(7)] = inst_54714);

return statearr_54737;
})();
var statearr_54738_54756 = state_54719__$1;
(statearr_54738_54756[(2)] = inst_54706);

(statearr_54738_54756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_54739 = [null,null,null,null,null,null,null,null];
(statearr_54739[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_54739[(1)] = (1));

return statearr_54739;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_54719){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54719);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54740){var ex__2730__auto__ = e54740;
var statearr_54741_54757 = state_54719;
(statearr_54741_54757[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54719[(4)]))){
var statearr_54742_54758 = state_54719;
(statearr_54742_54758[(1)] = cljs.core.first((state_54719[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54759 = state_54719;
state_54719 = G__54759;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_54719){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_54719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54743 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54743[(6)] = c__2749__auto__);

return statearr_54743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__54760,subject,pred){
var map__54761 = p__54760;
var map__54761__$1 = cljs.core.__destructure_map(map__54761);
var _QMARK_ctx = map__54761__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54761__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54761__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54852){
var state_val_54853 = (state_54852[(1)]);
if((state_val_54853 === (7))){
var state_54852__$1 = state_54852;
var statearr_54854_54910 = state_54852__$1;
(statearr_54854_54910[(2)] = subject);

(statearr_54854_54910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (20))){
var state_54852__$1 = state_54852;
var statearr_54855_54911 = state_54852__$1;
(statearr_54855_54911[(2)] = cache);

(statearr_54855_54911[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (27))){
var inst_54795 = (state_54852[(7)]);
var inst_54783 = (state_54852[(8)]);
var inst_54809 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_54795,inst_54783);
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54852__$1,(29),inst_54809);
} else {
if((state_val_54853 === (1))){
var state_54852__$1 = state_54852;
var statearr_54856_54912 = state_54852__$1;
(statearr_54856_54912[(2)] = null);

(statearr_54856_54912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (24))){
var inst_54795 = (state_54852[(7)]);
var inst_54822 = cljs.core.int_QMARK_(inst_54795);
var state_54852__$1 = state_54852;
if(inst_54822){
var statearr_54857_54913 = state_54852__$1;
(statearr_54857_54913[(1)] = (30));

} else {
var statearr_54858_54914 = state_54852__$1;
(statearr_54858_54914[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (4))){
var inst_54762 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
var statearr_54859_54915 = state_54852__$1;
(statearr_54859_54915[(2)] = inst_54762);

(statearr_54859_54915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (15))){
var inst_54775 = (state_54852[(9)]);
var state_54852__$1 = state_54852;
var statearr_54860_54916 = state_54852__$1;
(statearr_54860_54916[(2)] = inst_54775);

(statearr_54860_54916[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (21))){
var inst_54796 = (state_54852[(10)]);
var state_54852__$1 = state_54852;
var statearr_54861_54917 = state_54852__$1;
(statearr_54861_54917[(2)] = inst_54796);

(statearr_54861_54917[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (31))){
var state_54852__$1 = state_54852;
var statearr_54862_54918 = state_54852__$1;
(statearr_54862_54918[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (32))){
var inst_54835 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
var statearr_54864_54919 = state_54852__$1;
(statearr_54864_54919[(2)] = inst_54835);

(statearr_54864_54919[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (33))){
var inst_54826 = (state_54852[(2)]);
var inst_54827 = fluree.db.util.async.throw_err(inst_54826);
var state_54852__$1 = state_54852;
var statearr_54865_54920 = state_54852__$1;
(statearr_54865_54920[(2)] = inst_54827);

(statearr_54865_54920[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (13))){
var inst_54779 = (state_54852[(2)]);
var inst_54780 = fluree.db.util.async.throw_err(inst_54779);
var state_54852__$1 = state_54852;
var statearr_54866_54921 = state_54852__$1;
(statearr_54866_54921[(2)] = inst_54780);

(statearr_54866_54921[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (22))){
var inst_54800 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
if(cljs.core.truth_(inst_54800)){
var statearr_54867_54922 = state_54852__$1;
(statearr_54867_54922[(1)] = (23));

} else {
var statearr_54868_54923 = state_54852__$1;
(statearr_54868_54923[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (36))){
var inst_54833 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
var statearr_54869_54924 = state_54852__$1;
(statearr_54869_54924[(2)] = inst_54833);

(statearr_54869_54924[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (29))){
var inst_54795 = (state_54852[(7)]);
var inst_54783 = (state_54852[(8)]);
var inst_54811 = (state_54852[(2)]);
var inst_54812 = fluree.db.util.async.throw_err(inst_54811);
var inst_54813 = cljs.core._deref(cache);
var inst_54814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54815 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_54795,inst_54783];
var inst_54816 = (new cljs.core.PersistentVector(null,3,(5),inst_54814,inst_54815,null));
var inst_54817 = cljs.core.assoc_in(inst_54813,inst_54816,inst_54812);
var inst_54818 = cljs.core._vreset_BANG_(cache,inst_54817);
var state_54852__$1 = (function (){var statearr_54870 = state_54852;
(statearr_54870[(11)] = inst_54818);

return statearr_54870;
})();
var statearr_54871_54925 = state_54852__$1;
(statearr_54871_54925[(2)] = inst_54812);

(statearr_54871_54925[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (6))){
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54852__$1,(9),subject);
} else {
if((state_val_54853 === (28))){
var inst_54820 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
var statearr_54872_54926 = state_54852__$1;
(statearr_54872_54926[(2)] = inst_54820);

(statearr_54872_54926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (25))){
var inst_54783 = (state_54852[(8)]);
var inst_54775 = (state_54852[(9)]);
var inst_54837 = (state_54852[(2)]);
var inst_54838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54839 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54841 = [inst_54775,inst_54783];
var inst_54842 = (new cljs.core.PersistentVector(null,2,(5),inst_54840,inst_54841,null));
var inst_54843 = ["get",inst_54842,inst_54837];
var inst_54844 = cljs.core.PersistentHashMap.fromArrays(inst_54839,inst_54843);
var inst_54845 = [inst_54844,(10)];
var inst_54846 = (new cljs.core.PersistentVector(null,2,(5),inst_54838,inst_54845,null));
var inst_54847 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54846);
var _ = (function (){var statearr_54873 = state_54852;
(statearr_54873[(4)] = cljs.core.rest((state_54852[(4)])));

return statearr_54873;
})();
var state_54852__$1 = (function (){var statearr_54874 = state_54852;
(statearr_54874[(12)] = inst_54847);

return statearr_54874;
})();
var statearr_54875_54927 = state_54852__$1;
(statearr_54875_54927[(2)] = inst_54837);

(statearr_54875_54927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (34))){
var inst_54795 = (state_54852[(7)]);
var inst_54783 = (state_54852[(8)]);
var inst_54830 = fluree.db.dbfunctions.internal.get(inst_54795,inst_54783);
var state_54852__$1 = state_54852;
var statearr_54876_54928 = state_54852__$1;
(statearr_54876_54928[(2)] = inst_54830);

(statearr_54876_54928[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (17))){
var inst_54775 = (state_54852[(9)]);
var inst_54789 = cljs.core.first(inst_54775);
var state_54852__$1 = state_54852;
var statearr_54877_54929 = state_54852__$1;
(statearr_54877_54929[(2)] = inst_54789);

(statearr_54877_54929[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (3))){
var inst_54850 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54852__$1,inst_54850);
} else {
if((state_val_54853 === (12))){
var inst_54775 = (state_54852[(9)]);
var inst_54783 = (state_54852[(2)]);
var inst_54784 = cljs.core.vector_QMARK_(inst_54775);
var state_54852__$1 = (function (){var statearr_54878 = state_54852;
(statearr_54878[(8)] = inst_54783);

return statearr_54878;
})();
if(inst_54784){
var statearr_54879_54930 = state_54852__$1;
(statearr_54879_54930[(1)] = (14));

} else {
var statearr_54880_54931 = state_54852__$1;
(statearr_54880_54931[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (2))){
var _ = (function (){var statearr_54881 = state_54852;
(statearr_54881[(4)] = cljs.core.cons((5),(state_54852[(4)])));

return statearr_54881;
})();
var inst_54768 = fluree.db.util.async.channel_QMARK_(subject);
var state_54852__$1 = state_54852;
if(inst_54768){
var statearr_54882_54932 = state_54852__$1;
(statearr_54882_54932[(1)] = (6));

} else {
var statearr_54883_54933 = state_54852__$1;
(statearr_54883_54933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (23))){
var inst_54795 = (state_54852[(7)]);
var inst_54783 = (state_54852[(8)]);
var inst_54806 = (state_54852[(13)]);
var inst_54802 = cljs.core.deref(cache);
var inst_54803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54804 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_54795,inst_54783];
var inst_54805 = (new cljs.core.PersistentVector(null,3,(5),inst_54803,inst_54804,null));
var inst_54806__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_54802,inst_54805);
var state_54852__$1 = (function (){var statearr_54884 = state_54852;
(statearr_54884[(13)] = inst_54806__$1);

return statearr_54884;
})();
if(cljs.core.truth_(inst_54806__$1)){
var statearr_54885_54934 = state_54852__$1;
(statearr_54885_54934[(1)] = (26));

} else {
var statearr_54886_54935 = state_54852__$1;
(statearr_54886_54935[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (35))){
var state_54852__$1 = state_54852;
var statearr_54887_54936 = state_54852__$1;
(statearr_54887_54936[(2)] = null);

(statearr_54887_54936[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (19))){
var inst_54792 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
var statearr_54888_54937 = state_54852__$1;
(statearr_54888_54937[(2)] = inst_54792);

(statearr_54888_54937[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (11))){
var state_54852__$1 = state_54852;
var statearr_54890_54938 = state_54852__$1;
(statearr_54890_54938[(2)] = pred);

(statearr_54890_54938[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (9))){
var inst_54771 = (state_54852[(2)]);
var inst_54772 = fluree.db.util.async.throw_err(inst_54771);
var state_54852__$1 = state_54852;
var statearr_54891_54939 = state_54852__$1;
(statearr_54891_54939[(2)] = inst_54772);

(statearr_54891_54939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (5))){
var _ = (function (){var statearr_54892 = state_54852;
(statearr_54892[(4)] = cljs.core.rest((state_54852[(4)])));

return statearr_54892;
})();
var state_54852__$1 = state_54852;
var ex54889 = (state_54852__$1[(2)]);
var statearr_54893_54940 = state_54852__$1;
(statearr_54893_54940[(5)] = ex54889);


if((ex54889 instanceof Error)){
var statearr_54894_54941 = state_54852__$1;
(statearr_54894_54941[(1)] = (4));

(statearr_54894_54941[(5)] = null);

} else {
throw ex54889;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (14))){
var inst_54775 = (state_54852[(9)]);
var inst_54786 = cljs.core.count(inst_54775);
var inst_54787 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54786);
var state_54852__$1 = state_54852;
if(inst_54787){
var statearr_54895_54942 = state_54852__$1;
(statearr_54895_54942[(1)] = (17));

} else {
var statearr_54896_54943 = state_54852__$1;
(statearr_54896_54943[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (26))){
var inst_54806 = (state_54852[(13)]);
var state_54852__$1 = state_54852;
var statearr_54897_54944 = state_54852__$1;
(statearr_54897_54944[(2)] = inst_54806);

(statearr_54897_54944[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (16))){
var inst_54795 = (state_54852[(7)]);
var inst_54796 = (state_54852[(10)]);
var inst_54795__$1 = (state_54852[(2)]);
var inst_54796__$1 = cljs.core.int_QMARK_(inst_54795__$1);
var state_54852__$1 = (function (){var statearr_54898 = state_54852;
(statearr_54898[(7)] = inst_54795__$1);

(statearr_54898[(10)] = inst_54796__$1);

return statearr_54898;
})();
if(inst_54796__$1){
var statearr_54899_54945 = state_54852__$1;
(statearr_54899_54945[(1)] = (20));

} else {
var statearr_54900_54946 = state_54852__$1;
(statearr_54900_54946[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (30))){
var inst_54795 = (state_54852[(7)]);
var inst_54783 = (state_54852[(8)]);
var inst_54824 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_54795,inst_54783);
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54852__$1,(33),inst_54824);
} else {
if((state_val_54853 === (10))){
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54852__$1,(13),pred);
} else {
if((state_val_54853 === (18))){
var inst_54775 = (state_54852[(9)]);
var state_54852__$1 = state_54852;
var statearr_54901_54947 = state_54852__$1;
(statearr_54901_54947[(2)] = inst_54775);

(statearr_54901_54947[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (8))){
var inst_54775 = (state_54852[(2)]);
var inst_54776 = fluree.db.util.async.channel_QMARK_(pred);
var state_54852__$1 = (function (){var statearr_54902 = state_54852;
(statearr_54902[(9)] = inst_54775);

return statearr_54902;
})();
if(inst_54776){
var statearr_54903_54948 = state_54852__$1;
(statearr_54903_54948[(1)] = (10));

} else {
var statearr_54904_54949 = state_54852__$1;
(statearr_54904_54949[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_54905 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54905[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_54905[(1)] = (1));

return statearr_54905;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_54852){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54852);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54906){var ex__2730__auto__ = e54906;
var statearr_54907_54950 = state_54852;
(statearr_54907_54950[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54852[(4)]))){
var statearr_54908_54951 = state_54852;
(statearr_54908_54951[(1)] = cljs.core.first((state_54852[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54952 = state_54852;
state_54852 = G__54952;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_54852){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_54852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54909 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54909[(6)] = c__2749__auto__);

return statearr_54909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54991){
var state_val_54992 = (state_54991[(1)]);
if((state_val_54992 === (7))){
var inst_54959 = (state_54991[(7)]);
var state_54991__$1 = state_54991;
var statearr_54993_55017 = state_54991__$1;
(statearr_54993_55017[(2)] = inst_54959);

(statearr_54993_55017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (1))){
var state_54991__$1 = state_54991;
var statearr_54994_55018 = state_54991__$1;
(statearr_54994_55018[(2)] = null);

(statearr_54994_55018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (4))){
var inst_54953 = (state_54991[(2)]);
var state_54991__$1 = state_54991;
var statearr_54995_55019 = state_54991__$1;
(statearr_54995_55019[(2)] = inst_54953);

(statearr_54995_55019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (6))){
var inst_54961 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54991__$1 = state_54991;
var statearr_54996_55020 = state_54991__$1;
(statearr_54996_55020[(2)] = inst_54961);

(statearr_54996_55020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (3))){
var inst_54989 = (state_54991[(2)]);
var state_54991__$1 = state_54991;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54991__$1,inst_54989);
} else {
if((state_val_54992 === (12))){
var inst_54971 = (state_54991[(2)]);
var inst_54972 = fluree.db.util.async.throw_err(inst_54971);
var inst_54973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54972,(0),null);
var inst_54974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54972,(1),null);
var inst_54975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54976 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54977 = ["?pO","?ctx",inst_54973];
var inst_54978 = cljs.core.PersistentHashMap.fromArrays(inst_54976,inst_54977);
var inst_54979 = ((10) + inst_54974);
var inst_54980 = [inst_54978,inst_54979];
var inst_54981 = (new cljs.core.PersistentVector(null,2,(5),inst_54975,inst_54980,null));
var inst_54982 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54981);
var state_54991__$1 = (function (){var statearr_54997 = state_54991;
(statearr_54997[(8)] = inst_54982);

return statearr_54997;
})();
var statearr_54998_55021 = state_54991__$1;
(statearr_54998_55021[(2)] = inst_54973);

(statearr_54998_55021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (2))){
var inst_54959 = (state_54991[(7)]);
var _ = (function (){var statearr_54999 = state_54991;
(statearr_54999[(4)] = cljs.core.cons((5),(state_54991[(4)])));

return statearr_54999;
})();
var inst_54959__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54991__$1 = (function (){var statearr_55000 = state_54991;
(statearr_55000[(7)] = inst_54959__$1);

return statearr_55000;
})();
if(cljs.core.truth_(inst_54959__$1)){
var statearr_55001_55022 = state_54991__$1;
(statearr_55001_55022[(1)] = (6));

} else {
var statearr_55002_55023 = state_54991__$1;
(statearr_55002_55023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (11))){
var inst_54986 = (state_54991[(2)]);
var _ = (function (){var statearr_55004 = state_54991;
(statearr_55004[(4)] = cljs.core.rest((state_54991[(4)])));

return statearr_55004;
})();
var state_54991__$1 = state_54991;
var statearr_55005_55024 = state_54991__$1;
(statearr_55005_55024[(2)] = inst_54986);

(statearr_55005_55024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (9))){
var inst_54969 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_54991__$1 = state_54991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54991__$1,(12),inst_54969);
} else {
if((state_val_54992 === (5))){
var _ = (function (){var statearr_55006 = state_54991;
(statearr_55006[(4)] = cljs.core.rest((state_54991[(4)])));

return statearr_55006;
})();
var state_54991__$1 = state_54991;
var ex55003 = (state_54991__$1[(2)]);
var statearr_55007_55025 = state_54991__$1;
(statearr_55007_55025[(5)] = ex55003);


if((ex55003 instanceof Error)){
var statearr_55008_55026 = state_54991__$1;
(statearr_55008_55026[(1)] = (4));

(statearr_55008_55026[(5)] = null);

} else {
throw ex55003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (10))){
var inst_54984 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54991__$1 = state_54991;
var statearr_55009_55027 = state_54991__$1;
(statearr_55009_55027[(2)] = inst_54984);

(statearr_55009_55027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54992 === (8))){
var inst_54964 = (state_54991[(2)]);
var state_54991__$1 = state_54991;
if(cljs.core.truth_(inst_54964)){
var statearr_55010_55028 = state_54991__$1;
(statearr_55010_55028[(1)] = (9));

} else {
var statearr_55011_55029 = state_54991__$1;
(statearr_55011_55029[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_55012 = [null,null,null,null,null,null,null,null,null];
(statearr_55012[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_55012[(1)] = (1));

return statearr_55012;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_54991){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54991);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55013){var ex__2730__auto__ = e55013;
var statearr_55014_55030 = state_54991;
(statearr_55014_55030[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54991[(4)]))){
var statearr_55015_55031 = state_54991;
(statearr_55015_55031[(1)] = cljs.core.first((state_54991[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55032 = state_54991;
state_54991 = G__55032;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_54991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_54991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55016 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55016[(6)] = c__2749__auto__);

return statearr_55016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55101){
var state_val_55102 = (state_55101[(1)]);
if((state_val_55102 === (7))){
var state_55101__$1 = state_55101;
var statearr_55103_55141 = state_55101__$1;
(statearr_55103_55141[(2)] = subject);

(statearr_55103_55141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (20))){
var inst_55069 = (state_55101[(7)]);
var inst_55057 = (state_55101[(8)]);
var inst_55072 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_55069,inst_55057);
var state_55101__$1 = state_55101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55101__$1,(23),inst_55072);
} else {
if((state_val_55102 === (1))){
var state_55101__$1 = state_55101;
var statearr_55104_55142 = state_55101__$1;
(statearr_55104_55142[(2)] = null);

(statearr_55104_55142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (4))){
var inst_55033 = (state_55101[(2)]);
var state_55101__$1 = state_55101;
var statearr_55105_55143 = state_55101__$1;
(statearr_55105_55143[(2)] = inst_55033);

(statearr_55105_55143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (15))){
var inst_55049 = (state_55101[(9)]);
var state_55101__$1 = state_55101;
var statearr_55106_55144 = state_55101__$1;
(statearr_55106_55144[(2)] = inst_55049);

(statearr_55106_55144[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (21))){
var inst_55069 = (state_55101[(7)]);
var inst_55057 = (state_55101[(8)]);
var inst_55077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55078 = fluree.db.dbfunctions.internal.get_all(inst_55069,inst_55057);
var inst_55079 = cljs.core.count(inst_55057);
var inst_55080 = ((9) + inst_55079);
var inst_55081 = [inst_55078,inst_55080];
var inst_55082 = (new cljs.core.PersistentVector(null,2,(5),inst_55077,inst_55081,null));
var state_55101__$1 = state_55101;
var statearr_55107_55145 = state_55101__$1;
(statearr_55107_55145[(2)] = inst_55082);

(statearr_55107_55145[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (13))){
var inst_55053 = (state_55101[(2)]);
var inst_55054 = fluree.db.util.async.throw_err(inst_55053);
var state_55101__$1 = state_55101;
var statearr_55108_55146 = state_55101__$1;
(statearr_55108_55146[(2)] = inst_55054);

(statearr_55108_55146[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (22))){
var inst_55057 = (state_55101[(8)]);
var inst_55049 = (state_55101[(9)]);
var inst_55084 = (state_55101[(2)]);
var inst_55085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55084,(0),null);
var inst_55086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55084,(1),null);
var inst_55087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55088 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55090 = [inst_55049,inst_55057];
var inst_55091 = (new cljs.core.PersistentVector(null,2,(5),inst_55089,inst_55090,null));
var inst_55092 = ["get-all",inst_55091,inst_55085];
var inst_55093 = cljs.core.PersistentHashMap.fromArrays(inst_55088,inst_55092);
var inst_55094 = [inst_55093,inst_55086];
var inst_55095 = (new cljs.core.PersistentVector(null,2,(5),inst_55087,inst_55094,null));
var inst_55096 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55095);
var _ = (function (){var statearr_55109 = state_55101;
(statearr_55109[(4)] = cljs.core.rest((state_55101[(4)])));

return statearr_55109;
})();
var state_55101__$1 = (function (){var statearr_55110 = state_55101;
(statearr_55110[(10)] = inst_55096);

return statearr_55110;
})();
var statearr_55111_55147 = state_55101__$1;
(statearr_55111_55147[(2)] = inst_55085);

(statearr_55111_55147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (6))){
var state_55101__$1 = state_55101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55101__$1,(9),subject);
} else {
if((state_val_55102 === (17))){
var inst_55049 = (state_55101[(9)]);
var inst_55063 = cljs.core.first(inst_55049);
var state_55101__$1 = state_55101;
var statearr_55112_55148 = state_55101__$1;
(statearr_55112_55148[(2)] = inst_55063);

(statearr_55112_55148[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (3))){
var inst_55099 = (state_55101[(2)]);
var state_55101__$1 = state_55101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55101__$1,inst_55099);
} else {
if((state_val_55102 === (12))){
var inst_55049 = (state_55101[(9)]);
var inst_55057 = (state_55101[(2)]);
var inst_55058 = cljs.core.vector_QMARK_(inst_55049);
var state_55101__$1 = (function (){var statearr_55113 = state_55101;
(statearr_55113[(8)] = inst_55057);

return statearr_55113;
})();
if(inst_55058){
var statearr_55114_55149 = state_55101__$1;
(statearr_55114_55149[(1)] = (14));

} else {
var statearr_55115_55150 = state_55101__$1;
(statearr_55115_55150[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (2))){
var _ = (function (){var statearr_55116 = state_55101;
(statearr_55116[(4)] = cljs.core.cons((5),(state_55101[(4)])));

return statearr_55116;
})();
var inst_55042 = fluree.db.util.async.channel_QMARK_(subject);
var state_55101__$1 = state_55101;
if(inst_55042){
var statearr_55117_55151 = state_55101__$1;
(statearr_55117_55151[(1)] = (6));

} else {
var statearr_55118_55152 = state_55101__$1;
(statearr_55118_55152[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (23))){
var inst_55074 = (state_55101[(2)]);
var inst_55075 = fluree.db.util.async.throw_err(inst_55074);
var state_55101__$1 = state_55101;
var statearr_55119_55153 = state_55101__$1;
(statearr_55119_55153[(2)] = inst_55075);

(statearr_55119_55153[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (19))){
var inst_55066 = (state_55101[(2)]);
var state_55101__$1 = state_55101;
var statearr_55120_55154 = state_55101__$1;
(statearr_55120_55154[(2)] = inst_55066);

(statearr_55120_55154[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (11))){
var state_55101__$1 = state_55101;
var statearr_55122_55155 = state_55101__$1;
(statearr_55122_55155[(2)] = path);

(statearr_55122_55155[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (9))){
var inst_55045 = (state_55101[(2)]);
var inst_55046 = fluree.db.util.async.throw_err(inst_55045);
var state_55101__$1 = state_55101;
var statearr_55123_55156 = state_55101__$1;
(statearr_55123_55156[(2)] = inst_55046);

(statearr_55123_55156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (5))){
var _ = (function (){var statearr_55124 = state_55101;
(statearr_55124[(4)] = cljs.core.rest((state_55101[(4)])));

return statearr_55124;
})();
var state_55101__$1 = state_55101;
var ex55121 = (state_55101__$1[(2)]);
var statearr_55125_55157 = state_55101__$1;
(statearr_55125_55157[(5)] = ex55121);


if((ex55121 instanceof Error)){
var statearr_55126_55158 = state_55101__$1;
(statearr_55126_55158[(1)] = (4));

(statearr_55126_55158[(5)] = null);

} else {
throw ex55121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (14))){
var inst_55049 = (state_55101[(9)]);
var inst_55060 = cljs.core.count(inst_55049);
var inst_55061 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55060);
var state_55101__$1 = state_55101;
if(inst_55061){
var statearr_55127_55159 = state_55101__$1;
(statearr_55127_55159[(1)] = (17));

} else {
var statearr_55128_55160 = state_55101__$1;
(statearr_55128_55160[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (16))){
var inst_55069 = (state_55101[(7)]);
var inst_55069__$1 = (state_55101[(2)]);
var inst_55070 = cljs.core.int_QMARK_(inst_55069__$1);
var state_55101__$1 = (function (){var statearr_55129 = state_55101;
(statearr_55129[(7)] = inst_55069__$1);

return statearr_55129;
})();
if(inst_55070){
var statearr_55130_55161 = state_55101__$1;
(statearr_55130_55161[(1)] = (20));

} else {
var statearr_55131_55162 = state_55101__$1;
(statearr_55131_55162[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (10))){
var state_55101__$1 = state_55101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55101__$1,(13),path);
} else {
if((state_val_55102 === (18))){
var inst_55049 = (state_55101[(9)]);
var state_55101__$1 = state_55101;
var statearr_55132_55163 = state_55101__$1;
(statearr_55132_55163[(2)] = inst_55049);

(statearr_55132_55163[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55102 === (8))){
var inst_55049 = (state_55101[(2)]);
var inst_55050 = fluree.db.util.async.channel_QMARK_(path);
var state_55101__$1 = (function (){var statearr_55133 = state_55101;
(statearr_55133[(9)] = inst_55049);

return statearr_55133;
})();
if(inst_55050){
var statearr_55134_55164 = state_55101__$1;
(statearr_55134_55164[(1)] = (10));

} else {
var statearr_55135_55165 = state_55101__$1;
(statearr_55135_55165[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_55136 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55136[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_55136[(1)] = (1));

return statearr_55136;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_55101){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55101);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55137){var ex__2730__auto__ = e55137;
var statearr_55138_55166 = state_55101;
(statearr_55138_55166[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55101[(4)]))){
var statearr_55139_55167 = state_55101;
(statearr_55139_55167[(1)] = cljs.core.first((state_55101[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55168 = state_55101;
state_55101 = G__55168;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_55101){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_55101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55140 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55140[(6)] = c__2749__auto__);

return statearr_55140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55207){
var state_val_55208 = (state_55207[(1)]);
if((state_val_55208 === (7))){
var state_55207__$1 = state_55207;
var statearr_55209_55233 = state_55207__$1;
(statearr_55209_55233[(2)] = subject);

(statearr_55209_55233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (1))){
var state_55207__$1 = state_55207;
var statearr_55210_55234 = state_55207__$1;
(statearr_55210_55234[(2)] = null);

(statearr_55210_55234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (4))){
var inst_55169 = (state_55207[(2)]);
var state_55207__$1 = state_55207;
var statearr_55211_55235 = state_55207__$1;
(statearr_55211_55235[(2)] = inst_55169);

(statearr_55211_55235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (13))){
var inst_55186 = (state_55207[(2)]);
var inst_55187 = fluree.db.util.async.throw_err(inst_55186);
var state_55207__$1 = state_55207;
var statearr_55212_55236 = state_55207__$1;
(statearr_55212_55236[(2)] = inst_55187);

(statearr_55212_55236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (6))){
var state_55207__$1 = state_55207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55207__$1,(9),subject);
} else {
if((state_val_55208 === (3))){
var inst_55205 = (state_55207[(2)]);
var state_55207__$1 = state_55207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55207__$1,inst_55205);
} else {
if((state_val_55208 === (12))){
var inst_55182 = (state_55207[(7)]);
var inst_55190 = (state_55207[(2)]);
var inst_55191 = fluree.db.dbfunctions.internal.get_in(inst_55182,inst_55190);
var inst_55192 = cljs.core.count(inst_55190);
var inst_55193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55194 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55196 = [inst_55182,inst_55190];
var inst_55197 = (new cljs.core.PersistentVector(null,2,(5),inst_55195,inst_55196,null));
var inst_55198 = ["get-in",inst_55197,inst_55191];
var inst_55199 = cljs.core.PersistentHashMap.fromArrays(inst_55194,inst_55198);
var inst_55200 = [inst_55199,inst_55192];
var inst_55201 = (new cljs.core.PersistentVector(null,2,(5),inst_55193,inst_55200,null));
var inst_55202 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55201);
var _ = (function (){var statearr_55213 = state_55207;
(statearr_55213[(4)] = cljs.core.rest((state_55207[(4)])));

return statearr_55213;
})();
var state_55207__$1 = (function (){var statearr_55214 = state_55207;
(statearr_55214[(8)] = inst_55202);

return statearr_55214;
})();
var statearr_55215_55237 = state_55207__$1;
(statearr_55215_55237[(2)] = inst_55191);

(statearr_55215_55237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (2))){
var _ = (function (){var statearr_55216 = state_55207;
(statearr_55216[(4)] = cljs.core.cons((5),(state_55207[(4)])));

return statearr_55216;
})();
var inst_55175 = fluree.db.util.async.channel_QMARK_(subject);
var state_55207__$1 = state_55207;
if(inst_55175){
var statearr_55217_55238 = state_55207__$1;
(statearr_55217_55238[(1)] = (6));

} else {
var statearr_55218_55239 = state_55207__$1;
(statearr_55218_55239[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (11))){
var state_55207__$1 = state_55207;
var statearr_55220_55240 = state_55207__$1;
(statearr_55220_55240[(2)] = path);

(statearr_55220_55240[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (9))){
var inst_55178 = (state_55207[(2)]);
var inst_55179 = fluree.db.util.async.throw_err(inst_55178);
var state_55207__$1 = state_55207;
var statearr_55221_55241 = state_55207__$1;
(statearr_55221_55241[(2)] = inst_55179);

(statearr_55221_55241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (5))){
var _ = (function (){var statearr_55222 = state_55207;
(statearr_55222[(4)] = cljs.core.rest((state_55207[(4)])));

return statearr_55222;
})();
var state_55207__$1 = state_55207;
var ex55219 = (state_55207__$1[(2)]);
var statearr_55223_55242 = state_55207__$1;
(statearr_55223_55242[(5)] = ex55219);


if((ex55219 instanceof Error)){
var statearr_55224_55243 = state_55207__$1;
(statearr_55224_55243[(1)] = (4));

(statearr_55224_55243[(5)] = null);

} else {
throw ex55219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55208 === (10))){
var state_55207__$1 = state_55207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55207__$1,(13),path);
} else {
if((state_val_55208 === (8))){
var inst_55182 = (state_55207[(2)]);
var inst_55183 = fluree.db.util.async.channel_QMARK_(path);
var state_55207__$1 = (function (){var statearr_55225 = state_55207;
(statearr_55225[(7)] = inst_55182);

return statearr_55225;
})();
if(inst_55183){
var statearr_55226_55244 = state_55207__$1;
(statearr_55226_55244[(1)] = (10));

} else {
var statearr_55227_55245 = state_55207__$1;
(statearr_55227_55245[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_55228 = [null,null,null,null,null,null,null,null,null];
(statearr_55228[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_55228[(1)] = (1));

return statearr_55228;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_55207){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55207);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55229){var ex__2730__auto__ = e55229;
var statearr_55230_55246 = state_55207;
(statearr_55230_55246[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55207[(4)]))){
var statearr_55231_55247 = state_55207;
(statearr_55231_55247[(1)] = cljs.core.first((state_55207[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55248 = state_55207;
state_55207 = G__55248;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_55207){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_55207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55232 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55232[(6)] = c__2749__auto__);

return statearr_55232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__55249,key_or_ks){
var map__55250 = p__55249;
var map__55250__$1 = cljs.core.__destructure_map(map__55250);
var _QMARK_ctx = map__55250__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55250__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55295){
var state_val_55296 = (state_55295[(1)]);
if((state_val_55296 === (7))){
var state_55295__$1 = state_55295;
var statearr_55297_55326 = state_55295__$1;
(statearr_55297_55326[(2)] = coll);

(statearr_55297_55326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (1))){
var state_55295__$1 = state_55295;
var statearr_55298_55327 = state_55295__$1;
(statearr_55298_55327[(2)] = null);

(statearr_55298_55327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (4))){
var inst_55251 = (state_55295[(2)]);
var state_55295__$1 = state_55295;
var statearr_55299_55328 = state_55295__$1;
(statearr_55299_55328[(2)] = inst_55251);

(statearr_55299_55328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (15))){
var inst_55271 = (state_55295[(7)]);
var inst_55279 = (state_55295[(2)]);
var inst_55280 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55271,inst_55279);
var inst_55281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55282 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55284 = [inst_55271,inst_55279];
var inst_55285 = (new cljs.core.PersistentVector(null,2,(5),inst_55283,inst_55284,null));
var inst_55286 = ["contains?",inst_55285,inst_55280];
var inst_55287 = cljs.core.PersistentHashMap.fromArrays(inst_55282,inst_55286);
var inst_55288 = [inst_55287,(10)];
var inst_55289 = (new cljs.core.PersistentVector(null,2,(5),inst_55281,inst_55288,null));
var inst_55290 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55289);
var _ = (function (){var statearr_55300 = state_55295;
(statearr_55300[(4)] = cljs.core.rest((state_55295[(4)])));

return statearr_55300;
})();
var state_55295__$1 = (function (){var statearr_55301 = state_55295;
(statearr_55301[(8)] = inst_55290);

return statearr_55301;
})();
var statearr_55302_55329 = state_55295__$1;
(statearr_55302_55329[(2)] = inst_55280);

(statearr_55302_55329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (13))){
var state_55295__$1 = state_55295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55295__$1,(16),key);
} else {
if((state_val_55296 === (6))){
var state_55295__$1 = state_55295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55295__$1,(9),coll);
} else {
if((state_val_55296 === (3))){
var inst_55293 = (state_55295[(2)]);
var state_55295__$1 = state_55295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55295__$1,inst_55293);
} else {
if((state_val_55296 === (12))){
var inst_55271 = (state_55295[(2)]);
var inst_55272 = fluree.db.util.async.channel_QMARK_(key);
var state_55295__$1 = (function (){var statearr_55303 = state_55295;
(statearr_55303[(7)] = inst_55271);

return statearr_55303;
})();
if(inst_55272){
var statearr_55304_55330 = state_55295__$1;
(statearr_55304_55330[(1)] = (13));

} else {
var statearr_55305_55331 = state_55295__$1;
(statearr_55305_55331[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (2))){
var _ = (function (){var statearr_55306 = state_55295;
(statearr_55306[(4)] = cljs.core.cons((5),(state_55295[(4)])));

return statearr_55306;
})();
var inst_55257 = fluree.db.util.async.channel_QMARK_(coll);
var state_55295__$1 = state_55295;
if(inst_55257){
var statearr_55307_55332 = state_55295__$1;
(statearr_55307_55332[(1)] = (6));

} else {
var statearr_55308_55333 = state_55295__$1;
(statearr_55308_55333[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (11))){
var inst_55264 = (state_55295[(9)]);
var inst_55268 = cljs.core.flatten(inst_55264);
var inst_55269 = cljs.core.set(inst_55268);
var state_55295__$1 = state_55295;
var statearr_55310_55334 = state_55295__$1;
(statearr_55310_55334[(2)] = inst_55269);

(statearr_55310_55334[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (9))){
var inst_55260 = (state_55295[(2)]);
var inst_55261 = fluree.db.util.async.throw_err(inst_55260);
var state_55295__$1 = state_55295;
var statearr_55311_55335 = state_55295__$1;
(statearr_55311_55335[(2)] = inst_55261);

(statearr_55311_55335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (5))){
var _ = (function (){var statearr_55312 = state_55295;
(statearr_55312[(4)] = cljs.core.rest((state_55295[(4)])));

return statearr_55312;
})();
var state_55295__$1 = state_55295;
var ex55309 = (state_55295__$1[(2)]);
var statearr_55313_55336 = state_55295__$1;
(statearr_55313_55336[(5)] = ex55309);


if((ex55309 instanceof Error)){
var statearr_55314_55337 = state_55295__$1;
(statearr_55314_55337[(1)] = (4));

(statearr_55314_55337[(5)] = null);

} else {
throw ex55309;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (14))){
var state_55295__$1 = state_55295;
var statearr_55315_55338 = state_55295__$1;
(statearr_55315_55338[(2)] = key);

(statearr_55315_55338[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (16))){
var inst_55275 = (state_55295[(2)]);
var inst_55276 = fluree.db.util.async.throw_err(inst_55275);
var state_55295__$1 = state_55295;
var statearr_55316_55339 = state_55295__$1;
(statearr_55316_55339[(2)] = inst_55276);

(statearr_55316_55339[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (10))){
var inst_55264 = (state_55295[(9)]);
var state_55295__$1 = state_55295;
var statearr_55317_55340 = state_55295__$1;
(statearr_55317_55340[(2)] = inst_55264);

(statearr_55317_55340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55296 === (8))){
var inst_55264 = (state_55295[(9)]);
var inst_55264__$1 = (state_55295[(2)]);
var inst_55265 = cljs.core.set_QMARK_(inst_55264__$1);
var state_55295__$1 = (function (){var statearr_55318 = state_55295;
(statearr_55318[(9)] = inst_55264__$1);

return statearr_55318;
})();
if(inst_55265){
var statearr_55319_55341 = state_55295__$1;
(statearr_55319_55341[(1)] = (10));

} else {
var statearr_55320_55342 = state_55295__$1;
(statearr_55320_55342[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_55321 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55321[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_55321[(1)] = (1));

return statearr_55321;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_55295){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55295);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55322){var ex__2730__auto__ = e55322;
var statearr_55323_55343 = state_55295;
(statearr_55323_55343[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55295[(4)]))){
var statearr_55324_55344 = state_55295;
(statearr_55324_55344[(1)] = cljs.core.first((state_55295[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55345 = state_55295;
state_55295 = G__55345;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_55295){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_55295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55325 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55325[(6)] = c__2749__auto__);

return statearr_55325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55417 = arguments.length;
var i__5770__auto___55418 = (0);
while(true){
if((i__5770__auto___55418 < len__5769__auto___55417)){
args__5775__auto__.push((arguments[i__5770__auto___55418]));

var G__55419 = (i__5770__auto___55418 + (1));
i__5770__auto___55418 = G__55419;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55391){
var state_val_55392 = (state_55391[(1)]);
if((state_val_55392 === (7))){
var inst_55357 = (state_55391[(7)]);
var inst_55361 = cljs.core.first(inst_55357);
var inst_55362 = cljs.core.coll_QMARK_(inst_55361);
var state_55391__$1 = state_55391;
var statearr_55393_55420 = state_55391__$1;
(statearr_55393_55420[(2)] = inst_55362);

(statearr_55393_55420[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (1))){
var state_55391__$1 = state_55391;
var statearr_55394_55421 = state_55391__$1;
(statearr_55394_55421[(2)] = null);

(statearr_55394_55421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (4))){
var inst_55348 = (state_55391[(2)]);
var state_55391__$1 = state_55391;
var statearr_55395_55422 = state_55391__$1;
(statearr_55395_55422[(2)] = inst_55348);

(statearr_55395_55422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (6))){
var inst_55357 = (state_55391[(7)]);
var inst_55359 = (state_55391[(8)]);
var inst_55356 = (state_55391[(2)]);
var inst_55357__$1 = fluree.db.util.async.throw_err(inst_55356);
var inst_55358 = cljs.core.count(inst_55357__$1);
var inst_55359__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55358);
var state_55391__$1 = (function (){var statearr_55396 = state_55391;
(statearr_55396[(7)] = inst_55357__$1);

(statearr_55396[(8)] = inst_55359__$1);

return statearr_55396;
})();
if(inst_55359__$1){
var statearr_55397_55423 = state_55391__$1;
(statearr_55397_55423[(1)] = (7));

} else {
var statearr_55398_55424 = state_55391__$1;
(statearr_55398_55424[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (3))){
var inst_55389 = (state_55391[(2)]);
var state_55391__$1 = state_55391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55391__$1,inst_55389);
} else {
if((state_val_55392 === (12))){
var inst_55370 = (state_55391[(2)]);
var inst_55371 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55370);
var inst_55372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55373 = [inst_55370];
var inst_55374 = (new cljs.core.PersistentVector(null,1,(5),inst_55372,inst_55373,null));
var inst_55375 = cljs.core.count(inst_55374);
var inst_55376 = ((9) + inst_55375);
var inst_55377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55378 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55380 = [inst_55370];
var inst_55381 = (new cljs.core.PersistentVector(null,1,(5),inst_55379,inst_55380,null));
var inst_55382 = ["hash-set",inst_55381,inst_55371];
var inst_55383 = cljs.core.PersistentHashMap.fromArrays(inst_55378,inst_55382);
var inst_55384 = [inst_55383,inst_55376];
var inst_55385 = (new cljs.core.PersistentVector(null,2,(5),inst_55377,inst_55384,null));
var inst_55386 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55385);
var _ = (function (){var statearr_55399 = state_55391;
(statearr_55399[(4)] = cljs.core.rest((state_55391[(4)])));

return statearr_55399;
})();
var state_55391__$1 = (function (){var statearr_55400 = state_55391;
(statearr_55400[(9)] = inst_55386);

return statearr_55400;
})();
var statearr_55401_55425 = state_55391__$1;
(statearr_55401_55425[(2)] = inst_55371);

(statearr_55401_55425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (2))){
var _ = (function (){var statearr_55402 = state_55391;
(statearr_55402[(4)] = cljs.core.cons((5),(state_55391[(4)])));

return statearr_55402;
})();
var inst_55354 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55391__$1 = state_55391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55391__$1,(6),inst_55354);
} else {
if((state_val_55392 === (11))){
var inst_55357 = (state_55391[(7)]);
var state_55391__$1 = state_55391;
var statearr_55404_55426 = state_55391__$1;
(statearr_55404_55426[(2)] = inst_55357);

(statearr_55404_55426[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (9))){
var inst_55365 = (state_55391[(2)]);
var state_55391__$1 = state_55391;
if(cljs.core.truth_(inst_55365)){
var statearr_55405_55427 = state_55391__$1;
(statearr_55405_55427[(1)] = (10));

} else {
var statearr_55406_55428 = state_55391__$1;
(statearr_55406_55428[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (5))){
var _ = (function (){var statearr_55407 = state_55391;
(statearr_55407[(4)] = cljs.core.rest((state_55391[(4)])));

return statearr_55407;
})();
var state_55391__$1 = state_55391;
var ex55403 = (state_55391__$1[(2)]);
var statearr_55408_55429 = state_55391__$1;
(statearr_55408_55429[(5)] = ex55403);


if((ex55403 instanceof Error)){
var statearr_55409_55430 = state_55391__$1;
(statearr_55409_55430[(1)] = (4));

(statearr_55409_55430[(5)] = null);

} else {
throw ex55403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (10))){
var inst_55357 = (state_55391[(7)]);
var inst_55367 = cljs.core.first(inst_55357);
var state_55391__$1 = state_55391;
var statearr_55410_55431 = state_55391__$1;
(statearr_55410_55431[(2)] = inst_55367);

(statearr_55410_55431[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55392 === (8))){
var inst_55359 = (state_55391[(8)]);
var state_55391__$1 = state_55391;
var statearr_55411_55432 = state_55391__$1;
(statearr_55411_55432[(2)] = inst_55359);

(statearr_55411_55432[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55412 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55412[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55412[(1)] = (1));

return statearr_55412;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55391){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55391);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55413){var ex__2730__auto__ = e55413;
var statearr_55414_55433 = state_55391;
(statearr_55414_55433[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55391[(4)]))){
var statearr_55415_55434 = state_55391;
(statearr_55415_55434[(1)] = cljs.core.first((state_55391[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55435 = state_55391;
state_55391 = G__55435;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55391){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55416 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55416[(6)] = c__2749__auto__);

return statearr_55416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55346){
var G__55347 = cljs.core.first(seq55346);
var seq55346__$1 = cljs.core.next(seq55346);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55347,seq55346__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55485 = arguments.length;
var i__5770__auto___55486 = (0);
while(true){
if((i__5770__auto___55486 < len__5769__auto___55485)){
args__5775__auto__.push((arguments[i__5770__auto___55486]));

var G__55487 = (i__5770__auto___55486 + (1));
i__5770__auto___55486 = G__55487;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55468){
var state_val_55469 = (state_55468[(1)]);
if((state_val_55469 === (1))){
var state_55468__$1 = state_55468;
var statearr_55470_55488 = state_55468__$1;
(statearr_55470_55488[(2)] = null);

(statearr_55470_55488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (2))){
var _ = (function (){var statearr_55471 = state_55468;
(statearr_55471[(4)] = cljs.core.cons((5),(state_55468[(4)])));

return statearr_55471;
})();
var inst_55444 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55468__$1 = state_55468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55468__$1,(6),inst_55444);
} else {
if((state_val_55469 === (3))){
var inst_55466 = (state_55468[(2)]);
var state_55468__$1 = state_55468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55468__$1,inst_55466);
} else {
if((state_val_55469 === (4))){
var inst_55438 = (state_55468[(2)]);
var state_55468__$1 = state_55468;
var statearr_55473_55489 = state_55468__$1;
(statearr_55473_55489[(2)] = inst_55438);

(statearr_55473_55489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (5))){
var _ = (function (){var statearr_55474 = state_55468;
(statearr_55474[(4)] = cljs.core.rest((state_55468[(4)])));

return statearr_55474;
})();
var state_55468__$1 = state_55468;
var ex55472 = (state_55468__$1[(2)]);
var statearr_55475_55490 = state_55468__$1;
(statearr_55475_55490[(5)] = ex55472);


if((ex55472 instanceof Error)){
var statearr_55476_55491 = state_55468__$1;
(statearr_55476_55491[(1)] = (4));

(statearr_55476_55491[(5)] = null);

} else {
throw ex55472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (6))){
var inst_55446 = (state_55468[(2)]);
var inst_55447 = fluree.db.util.async.throw_err(inst_55446);
var inst_55448 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55447);
var inst_55449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55450 = [inst_55447];
var inst_55451 = (new cljs.core.PersistentVector(null,1,(5),inst_55449,inst_55450,null));
var inst_55452 = cljs.core.count(inst_55451);
var inst_55453 = ((9) + inst_55452);
var inst_55454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55455 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55457 = [inst_55447];
var inst_55458 = (new cljs.core.PersistentVector(null,1,(5),inst_55456,inst_55457,null));
var inst_55459 = ["==",inst_55458,inst_55448];
var inst_55460 = cljs.core.PersistentHashMap.fromArrays(inst_55455,inst_55459);
var inst_55461 = [inst_55460,inst_55453];
var inst_55462 = (new cljs.core.PersistentVector(null,2,(5),inst_55454,inst_55461,null));
var inst_55463 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55462);
var _ = (function (){var statearr_55477 = state_55468;
(statearr_55477[(4)] = cljs.core.rest((state_55468[(4)])));

return statearr_55477;
})();
var state_55468__$1 = (function (){var statearr_55478 = state_55468;
(statearr_55478[(7)] = inst_55463);

return statearr_55478;
})();
var statearr_55479_55492 = state_55468__$1;
(statearr_55479_55492[(2)] = inst_55448);

(statearr_55479_55492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55480 = [null,null,null,null,null,null,null,null];
(statearr_55480[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55480[(1)] = (1));

return statearr_55480;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55468){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55468);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55481){var ex__2730__auto__ = e55481;
var statearr_55482_55493 = state_55468;
(statearr_55482_55493[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55468[(4)]))){
var statearr_55483_55494 = state_55468;
(statearr_55483_55494[(1)] = cljs.core.first((state_55468[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55495 = state_55468;
state_55468 = G__55495;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55484 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55484[(6)] = c__2749__auto__);

return statearr_55484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55436){
var G__55437 = cljs.core.first(seq55436);
var seq55436__$1 = cljs.core.next(seq55436);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55437,seq55436__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55545 = arguments.length;
var i__5770__auto___55546 = (0);
while(true){
if((i__5770__auto___55546 < len__5769__auto___55545)){
args__5775__auto__.push((arguments[i__5770__auto___55546]));

var G__55547 = (i__5770__auto___55546 + (1));
i__5770__auto___55546 = G__55547;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55528){
var state_val_55529 = (state_55528[(1)]);
if((state_val_55529 === (1))){
var state_55528__$1 = state_55528;
var statearr_55530_55548 = state_55528__$1;
(statearr_55530_55548[(2)] = null);

(statearr_55530_55548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55529 === (2))){
var _ = (function (){var statearr_55531 = state_55528;
(statearr_55531[(4)] = cljs.core.cons((5),(state_55528[(4)])));

return statearr_55531;
})();
var inst_55504 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55528__$1 = state_55528;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55528__$1,(6),inst_55504);
} else {
if((state_val_55529 === (3))){
var inst_55526 = (state_55528[(2)]);
var state_55528__$1 = state_55528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55528__$1,inst_55526);
} else {
if((state_val_55529 === (4))){
var inst_55498 = (state_55528[(2)]);
var state_55528__$1 = state_55528;
var statearr_55533_55549 = state_55528__$1;
(statearr_55533_55549[(2)] = inst_55498);

(statearr_55533_55549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55529 === (5))){
var _ = (function (){var statearr_55534 = state_55528;
(statearr_55534[(4)] = cljs.core.rest((state_55528[(4)])));

return statearr_55534;
})();
var state_55528__$1 = state_55528;
var ex55532 = (state_55528__$1[(2)]);
var statearr_55535_55550 = state_55528__$1;
(statearr_55535_55550[(5)] = ex55532);


if((ex55532 instanceof Error)){
var statearr_55536_55551 = state_55528__$1;
(statearr_55536_55551[(1)] = (4));

(statearr_55536_55551[(5)] = null);

} else {
throw ex55532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55529 === (6))){
var inst_55506 = (state_55528[(2)]);
var inst_55507 = fluree.db.util.async.throw_err(inst_55506);
var inst_55508 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55507);
var inst_55509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55510 = [inst_55507];
var inst_55511 = (new cljs.core.PersistentVector(null,1,(5),inst_55509,inst_55510,null));
var inst_55512 = cljs.core.count(inst_55511);
var inst_55513 = ((9) + inst_55512);
var inst_55514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55515 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55517 = [inst_55507];
var inst_55518 = (new cljs.core.PersistentVector(null,1,(5),inst_55516,inst_55517,null));
var inst_55519 = [">",inst_55518,inst_55508];
var inst_55520 = cljs.core.PersistentHashMap.fromArrays(inst_55515,inst_55519);
var inst_55521 = [inst_55520,inst_55513];
var inst_55522 = (new cljs.core.PersistentVector(null,2,(5),inst_55514,inst_55521,null));
var inst_55523 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55522);
var _ = (function (){var statearr_55537 = state_55528;
(statearr_55537[(4)] = cljs.core.rest((state_55528[(4)])));

return statearr_55537;
})();
var state_55528__$1 = (function (){var statearr_55538 = state_55528;
(statearr_55538[(7)] = inst_55523);

return statearr_55538;
})();
var statearr_55539_55552 = state_55528__$1;
(statearr_55539_55552[(2)] = inst_55508);

(statearr_55539_55552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55540 = [null,null,null,null,null,null,null,null];
(statearr_55540[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55540[(1)] = (1));

return statearr_55540;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55528){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55528);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55541){var ex__2730__auto__ = e55541;
var statearr_55542_55553 = state_55528;
(statearr_55542_55553[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55528[(4)]))){
var statearr_55543_55554 = state_55528;
(statearr_55543_55554[(1)] = cljs.core.first((state_55528[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55555 = state_55528;
state_55528 = G__55555;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55528){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55544 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55544[(6)] = c__2749__auto__);

return statearr_55544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55496){
var G__55497 = cljs.core.first(seq55496);
var seq55496__$1 = cljs.core.next(seq55496);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55497,seq55496__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55605 = arguments.length;
var i__5770__auto___55606 = (0);
while(true){
if((i__5770__auto___55606 < len__5769__auto___55605)){
args__5775__auto__.push((arguments[i__5770__auto___55606]));

var G__55607 = (i__5770__auto___55606 + (1));
i__5770__auto___55606 = G__55607;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55588){
var state_val_55589 = (state_55588[(1)]);
if((state_val_55589 === (1))){
var state_55588__$1 = state_55588;
var statearr_55590_55608 = state_55588__$1;
(statearr_55590_55608[(2)] = null);

(statearr_55590_55608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55589 === (2))){
var _ = (function (){var statearr_55591 = state_55588;
(statearr_55591[(4)] = cljs.core.cons((5),(state_55588[(4)])));

return statearr_55591;
})();
var inst_55564 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55588__$1 = state_55588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55588__$1,(6),inst_55564);
} else {
if((state_val_55589 === (3))){
var inst_55586 = (state_55588[(2)]);
var state_55588__$1 = state_55588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55588__$1,inst_55586);
} else {
if((state_val_55589 === (4))){
var inst_55558 = (state_55588[(2)]);
var state_55588__$1 = state_55588;
var statearr_55593_55609 = state_55588__$1;
(statearr_55593_55609[(2)] = inst_55558);

(statearr_55593_55609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55589 === (5))){
var _ = (function (){var statearr_55594 = state_55588;
(statearr_55594[(4)] = cljs.core.rest((state_55588[(4)])));

return statearr_55594;
})();
var state_55588__$1 = state_55588;
var ex55592 = (state_55588__$1[(2)]);
var statearr_55595_55610 = state_55588__$1;
(statearr_55595_55610[(5)] = ex55592);


if((ex55592 instanceof Error)){
var statearr_55596_55611 = state_55588__$1;
(statearr_55596_55611[(1)] = (4));

(statearr_55596_55611[(5)] = null);

} else {
throw ex55592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55589 === (6))){
var inst_55566 = (state_55588[(2)]);
var inst_55567 = fluree.db.util.async.throw_err(inst_55566);
var inst_55568 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55567);
var inst_55569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55570 = [inst_55567];
var inst_55571 = (new cljs.core.PersistentVector(null,1,(5),inst_55569,inst_55570,null));
var inst_55572 = cljs.core.count(inst_55571);
var inst_55573 = ((9) + inst_55572);
var inst_55574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55575 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55577 = [inst_55567];
var inst_55578 = (new cljs.core.PersistentVector(null,1,(5),inst_55576,inst_55577,null));
var inst_55579 = ["<",inst_55578,inst_55568];
var inst_55580 = cljs.core.PersistentHashMap.fromArrays(inst_55575,inst_55579);
var inst_55581 = [inst_55580,inst_55573];
var inst_55582 = (new cljs.core.PersistentVector(null,2,(5),inst_55574,inst_55581,null));
var inst_55583 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55582);
var _ = (function (){var statearr_55597 = state_55588;
(statearr_55597[(4)] = cljs.core.rest((state_55588[(4)])));

return statearr_55597;
})();
var state_55588__$1 = (function (){var statearr_55598 = state_55588;
(statearr_55598[(7)] = inst_55583);

return statearr_55598;
})();
var statearr_55599_55612 = state_55588__$1;
(statearr_55599_55612[(2)] = inst_55568);

(statearr_55599_55612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55600 = [null,null,null,null,null,null,null,null];
(statearr_55600[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55600[(1)] = (1));

return statearr_55600;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55588){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55588);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55601){var ex__2730__auto__ = e55601;
var statearr_55602_55613 = state_55588;
(statearr_55602_55613[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55588[(4)]))){
var statearr_55603_55614 = state_55588;
(statearr_55603_55614[(1)] = cljs.core.first((state_55588[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55615 = state_55588;
state_55588 = G__55615;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55588){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55604 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55604[(6)] = c__2749__auto__);

return statearr_55604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55556){
var G__55557 = cljs.core.first(seq55556);
var seq55556__$1 = cljs.core.next(seq55556);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55557,seq55556__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55665 = arguments.length;
var i__5770__auto___55666 = (0);
while(true){
if((i__5770__auto___55666 < len__5769__auto___55665)){
args__5775__auto__.push((arguments[i__5770__auto___55666]));

var G__55667 = (i__5770__auto___55666 + (1));
i__5770__auto___55666 = G__55667;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55648){
var state_val_55649 = (state_55648[(1)]);
if((state_val_55649 === (1))){
var state_55648__$1 = state_55648;
var statearr_55650_55668 = state_55648__$1;
(statearr_55650_55668[(2)] = null);

(statearr_55650_55668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (2))){
var _ = (function (){var statearr_55651 = state_55648;
(statearr_55651[(4)] = cljs.core.cons((5),(state_55648[(4)])));

return statearr_55651;
})();
var inst_55624 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55648__$1 = state_55648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55648__$1,(6),inst_55624);
} else {
if((state_val_55649 === (3))){
var inst_55646 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55648__$1,inst_55646);
} else {
if((state_val_55649 === (4))){
var inst_55618 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
var statearr_55653_55669 = state_55648__$1;
(statearr_55653_55669[(2)] = inst_55618);

(statearr_55653_55669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (5))){
var _ = (function (){var statearr_55654 = state_55648;
(statearr_55654[(4)] = cljs.core.rest((state_55648[(4)])));

return statearr_55654;
})();
var state_55648__$1 = state_55648;
var ex55652 = (state_55648__$1[(2)]);
var statearr_55655_55670 = state_55648__$1;
(statearr_55655_55670[(5)] = ex55652);


if((ex55652 instanceof Error)){
var statearr_55656_55671 = state_55648__$1;
(statearr_55656_55671[(1)] = (4));

(statearr_55656_55671[(5)] = null);

} else {
throw ex55652;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (6))){
var inst_55626 = (state_55648[(2)]);
var inst_55627 = fluree.db.util.async.throw_err(inst_55626);
var inst_55628 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55627);
var inst_55629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55630 = [inst_55627];
var inst_55631 = (new cljs.core.PersistentVector(null,1,(5),inst_55629,inst_55630,null));
var inst_55632 = cljs.core.count(inst_55631);
var inst_55633 = ((9) + inst_55632);
var inst_55634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55635 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55637 = [inst_55627];
var inst_55638 = (new cljs.core.PersistentVector(null,1,(5),inst_55636,inst_55637,null));
var inst_55639 = ["<=",inst_55638,inst_55628];
var inst_55640 = cljs.core.PersistentHashMap.fromArrays(inst_55635,inst_55639);
var inst_55641 = [inst_55640,inst_55633];
var inst_55642 = (new cljs.core.PersistentVector(null,2,(5),inst_55634,inst_55641,null));
var inst_55643 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55642);
var _ = (function (){var statearr_55657 = state_55648;
(statearr_55657[(4)] = cljs.core.rest((state_55648[(4)])));

return statearr_55657;
})();
var state_55648__$1 = (function (){var statearr_55658 = state_55648;
(statearr_55658[(7)] = inst_55643);

return statearr_55658;
})();
var statearr_55659_55672 = state_55648__$1;
(statearr_55659_55672[(2)] = inst_55628);

(statearr_55659_55672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55660 = [null,null,null,null,null,null,null,null];
(statearr_55660[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55660[(1)] = (1));

return statearr_55660;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55648){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55648);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55661){var ex__2730__auto__ = e55661;
var statearr_55662_55673 = state_55648;
(statearr_55662_55673[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55648[(4)]))){
var statearr_55663_55674 = state_55648;
(statearr_55663_55674[(1)] = cljs.core.first((state_55648[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55675 = state_55648;
state_55648 = G__55675;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55648){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55664 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55664[(6)] = c__2749__auto__);

return statearr_55664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55616){
var G__55617 = cljs.core.first(seq55616);
var seq55616__$1 = cljs.core.next(seq55616);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55617,seq55616__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55725 = arguments.length;
var i__5770__auto___55726 = (0);
while(true){
if((i__5770__auto___55726 < len__5769__auto___55725)){
args__5775__auto__.push((arguments[i__5770__auto___55726]));

var G__55727 = (i__5770__auto___55726 + (1));
i__5770__auto___55726 = G__55727;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55708){
var state_val_55709 = (state_55708[(1)]);
if((state_val_55709 === (1))){
var state_55708__$1 = state_55708;
var statearr_55710_55728 = state_55708__$1;
(statearr_55710_55728[(2)] = null);

(statearr_55710_55728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55709 === (2))){
var _ = (function (){var statearr_55711 = state_55708;
(statearr_55711[(4)] = cljs.core.cons((5),(state_55708[(4)])));

return statearr_55711;
})();
var inst_55684 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55708__$1 = state_55708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55708__$1,(6),inst_55684);
} else {
if((state_val_55709 === (3))){
var inst_55706 = (state_55708[(2)]);
var state_55708__$1 = state_55708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55708__$1,inst_55706);
} else {
if((state_val_55709 === (4))){
var inst_55678 = (state_55708[(2)]);
var state_55708__$1 = state_55708;
var statearr_55713_55729 = state_55708__$1;
(statearr_55713_55729[(2)] = inst_55678);

(statearr_55713_55729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55709 === (5))){
var _ = (function (){var statearr_55714 = state_55708;
(statearr_55714[(4)] = cljs.core.rest((state_55708[(4)])));

return statearr_55714;
})();
var state_55708__$1 = state_55708;
var ex55712 = (state_55708__$1[(2)]);
var statearr_55715_55730 = state_55708__$1;
(statearr_55715_55730[(5)] = ex55712);


if((ex55712 instanceof Error)){
var statearr_55716_55731 = state_55708__$1;
(statearr_55716_55731[(1)] = (4));

(statearr_55716_55731[(5)] = null);

} else {
throw ex55712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55709 === (6))){
var inst_55686 = (state_55708[(2)]);
var inst_55687 = fluree.db.util.async.throw_err(inst_55686);
var inst_55688 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55687);
var inst_55689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55690 = [inst_55687];
var inst_55691 = (new cljs.core.PersistentVector(null,1,(5),inst_55689,inst_55690,null));
var inst_55692 = cljs.core.count(inst_55691);
var inst_55693 = ((9) + inst_55692);
var inst_55694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55695 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55697 = [inst_55687];
var inst_55698 = (new cljs.core.PersistentVector(null,1,(5),inst_55696,inst_55697,null));
var inst_55699 = [">=",inst_55698,inst_55688];
var inst_55700 = cljs.core.PersistentHashMap.fromArrays(inst_55695,inst_55699);
var inst_55701 = [inst_55700,inst_55693];
var inst_55702 = (new cljs.core.PersistentVector(null,2,(5),inst_55694,inst_55701,null));
var inst_55703 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55702);
var _ = (function (){var statearr_55717 = state_55708;
(statearr_55717[(4)] = cljs.core.rest((state_55708[(4)])));

return statearr_55717;
})();
var state_55708__$1 = (function (){var statearr_55718 = state_55708;
(statearr_55718[(7)] = inst_55703);

return statearr_55718;
})();
var statearr_55719_55732 = state_55708__$1;
(statearr_55719_55732[(2)] = inst_55688);

(statearr_55719_55732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55720 = [null,null,null,null,null,null,null,null];
(statearr_55720[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55720[(1)] = (1));

return statearr_55720;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55708){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55708);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55721){var ex__2730__auto__ = e55721;
var statearr_55722_55733 = state_55708;
(statearr_55722_55733[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55708[(4)]))){
var statearr_55723_55734 = state_55708;
(statearr_55723_55734[(1)] = cljs.core.first((state_55708[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55735 = state_55708;
state_55708 = G__55735;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55708){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55724 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55724[(6)] = c__2749__auto__);

return statearr_55724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55676){
var G__55677 = cljs.core.first(seq55676);
var seq55676__$1 = cljs.core.next(seq55676);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55677,seq55676__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55785 = arguments.length;
var i__5770__auto___55786 = (0);
while(true){
if((i__5770__auto___55786 < len__5769__auto___55785)){
args__5775__auto__.push((arguments[i__5770__auto___55786]));

var G__55787 = (i__5770__auto___55786 + (1));
i__5770__auto___55786 = G__55787;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55768){
var state_val_55769 = (state_55768[(1)]);
if((state_val_55769 === (1))){
var state_55768__$1 = state_55768;
var statearr_55770_55788 = state_55768__$1;
(statearr_55770_55788[(2)] = null);

(statearr_55770_55788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55769 === (2))){
var _ = (function (){var statearr_55771 = state_55768;
(statearr_55771[(4)] = cljs.core.cons((5),(state_55768[(4)])));

return statearr_55771;
})();
var inst_55744 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55768__$1 = state_55768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55768__$1,(6),inst_55744);
} else {
if((state_val_55769 === (3))){
var inst_55766 = (state_55768[(2)]);
var state_55768__$1 = state_55768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55768__$1,inst_55766);
} else {
if((state_val_55769 === (4))){
var inst_55738 = (state_55768[(2)]);
var state_55768__$1 = state_55768;
var statearr_55773_55789 = state_55768__$1;
(statearr_55773_55789[(2)] = inst_55738);

(statearr_55773_55789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55769 === (5))){
var _ = (function (){var statearr_55774 = state_55768;
(statearr_55774[(4)] = cljs.core.rest((state_55768[(4)])));

return statearr_55774;
})();
var state_55768__$1 = state_55768;
var ex55772 = (state_55768__$1[(2)]);
var statearr_55775_55790 = state_55768__$1;
(statearr_55775_55790[(5)] = ex55772);


if((ex55772 instanceof Error)){
var statearr_55776_55791 = state_55768__$1;
(statearr_55776_55791[(1)] = (4));

(statearr_55776_55791[(5)] = null);

} else {
throw ex55772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55769 === (6))){
var inst_55746 = (state_55768[(2)]);
var inst_55747 = fluree.db.util.async.throw_err(inst_55746);
var inst_55748 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55747);
var inst_55749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55750 = [inst_55747];
var inst_55751 = (new cljs.core.PersistentVector(null,1,(5),inst_55749,inst_55750,null));
var inst_55752 = cljs.core.count(inst_55751);
var inst_55753 = ((9) + inst_55752);
var inst_55754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55755 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55757 = [inst_55747];
var inst_55758 = (new cljs.core.PersistentVector(null,1,(5),inst_55756,inst_55757,null));
var inst_55759 = ["not=",inst_55758,inst_55748];
var inst_55760 = cljs.core.PersistentHashMap.fromArrays(inst_55755,inst_55759);
var inst_55761 = [inst_55760,inst_55753];
var inst_55762 = (new cljs.core.PersistentVector(null,2,(5),inst_55754,inst_55761,null));
var inst_55763 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55762);
var _ = (function (){var statearr_55777 = state_55768;
(statearr_55777[(4)] = cljs.core.rest((state_55768[(4)])));

return statearr_55777;
})();
var state_55768__$1 = (function (){var statearr_55778 = state_55768;
(statearr_55778[(7)] = inst_55763);

return statearr_55778;
})();
var statearr_55779_55792 = state_55768__$1;
(statearr_55779_55792[(2)] = inst_55748);

(statearr_55779_55792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55780 = [null,null,null,null,null,null,null,null];
(statearr_55780[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55780[(1)] = (1));

return statearr_55780;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55768){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55768);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55781){var ex__2730__auto__ = e55781;
var statearr_55782_55793 = state_55768;
(statearr_55782_55793[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55768[(4)]))){
var statearr_55783_55794 = state_55768;
(statearr_55783_55794[(1)] = cljs.core.first((state_55768[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55795 = state_55768;
state_55768 = G__55795;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55768){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55784 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55784[(6)] = c__2749__auto__);

return statearr_55784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55736){
var G__55737 = cljs.core.first(seq55736);
var seq55736__$1 = cljs.core.next(seq55736);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55737,seq55736__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55845 = arguments.length;
var i__5770__auto___55846 = (0);
while(true){
if((i__5770__auto___55846 < len__5769__auto___55845)){
args__5775__auto__.push((arguments[i__5770__auto___55846]));

var G__55847 = (i__5770__auto___55846 + (1));
i__5770__auto___55846 = G__55847;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55828){
var state_val_55829 = (state_55828[(1)]);
if((state_val_55829 === (1))){
var state_55828__$1 = state_55828;
var statearr_55830_55848 = state_55828__$1;
(statearr_55830_55848[(2)] = null);

(statearr_55830_55848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55829 === (2))){
var _ = (function (){var statearr_55831 = state_55828;
(statearr_55831[(4)] = cljs.core.cons((5),(state_55828[(4)])));

return statearr_55831;
})();
var inst_55804 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55828__$1 = state_55828;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55828__$1,(6),inst_55804);
} else {
if((state_val_55829 === (3))){
var inst_55826 = (state_55828[(2)]);
var state_55828__$1 = state_55828;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55828__$1,inst_55826);
} else {
if((state_val_55829 === (4))){
var inst_55798 = (state_55828[(2)]);
var state_55828__$1 = state_55828;
var statearr_55833_55849 = state_55828__$1;
(statearr_55833_55849[(2)] = inst_55798);

(statearr_55833_55849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55829 === (5))){
var _ = (function (){var statearr_55834 = state_55828;
(statearr_55834[(4)] = cljs.core.rest((state_55828[(4)])));

return statearr_55834;
})();
var state_55828__$1 = state_55828;
var ex55832 = (state_55828__$1[(2)]);
var statearr_55835_55850 = state_55828__$1;
(statearr_55835_55850[(5)] = ex55832);


if((ex55832 instanceof Error)){
var statearr_55836_55851 = state_55828__$1;
(statearr_55836_55851[(1)] = (4));

(statearr_55836_55851[(5)] = null);

} else {
throw ex55832;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55829 === (6))){
var inst_55806 = (state_55828[(2)]);
var inst_55807 = fluree.db.util.async.throw_err(inst_55806);
var inst_55808 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55807);
var inst_55809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55810 = [inst_55807];
var inst_55811 = (new cljs.core.PersistentVector(null,1,(5),inst_55809,inst_55810,null));
var inst_55812 = cljs.core.count(inst_55811);
var inst_55813 = ((9) + inst_55812);
var inst_55814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55815 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55817 = [inst_55807];
var inst_55818 = (new cljs.core.PersistentVector(null,1,(5),inst_55816,inst_55817,null));
var inst_55819 = ["max",inst_55818,inst_55808];
var inst_55820 = cljs.core.PersistentHashMap.fromArrays(inst_55815,inst_55819);
var inst_55821 = [inst_55820,inst_55813];
var inst_55822 = (new cljs.core.PersistentVector(null,2,(5),inst_55814,inst_55821,null));
var inst_55823 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55822);
var _ = (function (){var statearr_55837 = state_55828;
(statearr_55837[(4)] = cljs.core.rest((state_55828[(4)])));

return statearr_55837;
})();
var state_55828__$1 = (function (){var statearr_55838 = state_55828;
(statearr_55838[(7)] = inst_55823);

return statearr_55838;
})();
var statearr_55839_55852 = state_55828__$1;
(statearr_55839_55852[(2)] = inst_55808);

(statearr_55839_55852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55840 = [null,null,null,null,null,null,null,null];
(statearr_55840[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55840[(1)] = (1));

return statearr_55840;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55828){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55828);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55841){var ex__2730__auto__ = e55841;
var statearr_55842_55853 = state_55828;
(statearr_55842_55853[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55828[(4)]))){
var statearr_55843_55854 = state_55828;
(statearr_55843_55854[(1)] = cljs.core.first((state_55828[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55855 = state_55828;
state_55828 = G__55855;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55828){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55844 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55844[(6)] = c__2749__auto__);

return statearr_55844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55796){
var G__55797 = cljs.core.first(seq55796);
var seq55796__$1 = cljs.core.next(seq55796);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55797,seq55796__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55905 = arguments.length;
var i__5770__auto___55906 = (0);
while(true){
if((i__5770__auto___55906 < len__5769__auto___55905)){
args__5775__auto__.push((arguments[i__5770__auto___55906]));

var G__55907 = (i__5770__auto___55906 + (1));
i__5770__auto___55906 = G__55907;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55888){
var state_val_55889 = (state_55888[(1)]);
if((state_val_55889 === (1))){
var state_55888__$1 = state_55888;
var statearr_55890_55908 = state_55888__$1;
(statearr_55890_55908[(2)] = null);

(statearr_55890_55908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55889 === (2))){
var _ = (function (){var statearr_55891 = state_55888;
(statearr_55891[(4)] = cljs.core.cons((5),(state_55888[(4)])));

return statearr_55891;
})();
var inst_55864 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55888__$1 = state_55888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55888__$1,(6),inst_55864);
} else {
if((state_val_55889 === (3))){
var inst_55886 = (state_55888[(2)]);
var state_55888__$1 = state_55888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55888__$1,inst_55886);
} else {
if((state_val_55889 === (4))){
var inst_55858 = (state_55888[(2)]);
var state_55888__$1 = state_55888;
var statearr_55893_55909 = state_55888__$1;
(statearr_55893_55909[(2)] = inst_55858);

(statearr_55893_55909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55889 === (5))){
var _ = (function (){var statearr_55894 = state_55888;
(statearr_55894[(4)] = cljs.core.rest((state_55888[(4)])));

return statearr_55894;
})();
var state_55888__$1 = state_55888;
var ex55892 = (state_55888__$1[(2)]);
var statearr_55895_55910 = state_55888__$1;
(statearr_55895_55910[(5)] = ex55892);


if((ex55892 instanceof Error)){
var statearr_55896_55911 = state_55888__$1;
(statearr_55896_55911[(1)] = (4));

(statearr_55896_55911[(5)] = null);

} else {
throw ex55892;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55889 === (6))){
var inst_55866 = (state_55888[(2)]);
var inst_55867 = fluree.db.util.async.throw_err(inst_55866);
var inst_55868 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55867);
var inst_55869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55870 = [inst_55867];
var inst_55871 = (new cljs.core.PersistentVector(null,1,(5),inst_55869,inst_55870,null));
var inst_55872 = cljs.core.count(inst_55871);
var inst_55873 = ((9) + inst_55872);
var inst_55874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55875 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55877 = [inst_55867];
var inst_55878 = (new cljs.core.PersistentVector(null,1,(5),inst_55876,inst_55877,null));
var inst_55879 = ["min",inst_55878,inst_55868];
var inst_55880 = cljs.core.PersistentHashMap.fromArrays(inst_55875,inst_55879);
var inst_55881 = [inst_55880,inst_55873];
var inst_55882 = (new cljs.core.PersistentVector(null,2,(5),inst_55874,inst_55881,null));
var inst_55883 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55882);
var _ = (function (){var statearr_55897 = state_55888;
(statearr_55897[(4)] = cljs.core.rest((state_55888[(4)])));

return statearr_55897;
})();
var state_55888__$1 = (function (){var statearr_55898 = state_55888;
(statearr_55898[(7)] = inst_55883);

return statearr_55898;
})();
var statearr_55899_55912 = state_55888__$1;
(statearr_55899_55912[(2)] = inst_55868);

(statearr_55899_55912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55900 = [null,null,null,null,null,null,null,null];
(statearr_55900[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55900[(1)] = (1));

return statearr_55900;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55888){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55888);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55901){var ex__2730__auto__ = e55901;
var statearr_55902_55913 = state_55888;
(statearr_55902_55913[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55888[(4)]))){
var statearr_55903_55914 = state_55888;
(statearr_55903_55914[(1)] = cljs.core.first((state_55888[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55915 = state_55888;
state_55888 = G__55915;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55888){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55904 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55904[(6)] = c__2749__auto__);

return statearr_55904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55856){
var G__55857 = cljs.core.first(seq55856);
var seq55856__$1 = cljs.core.next(seq55856);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55857,seq55856__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55917 = arguments.length;
switch (G__55917) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55962){
var state_val_55963 = (state_55962[(1)]);
if((state_val_55963 === (7))){
var state_55962__$1 = state_55962;
var statearr_55964_56101 = state_55962__$1;
(statearr_55964_56101[(2)] = query_map);

(statearr_55964_56101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (1))){
var state_55962__$1 = state_55962;
var statearr_55965_56102 = state_55962__$1;
(statearr_55965_56102[(2)] = null);

(statearr_55965_56102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (4))){
var inst_55918 = (state_55962[(2)]);
var state_55962__$1 = state_55962;
var statearr_55966_56103 = state_55962__$1;
(statearr_55966_56103[(2)] = inst_55918);

(statearr_55966_56103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (13))){
var inst_55940 = (state_55962[(7)]);
var inst_55944 = (state_55962[(2)]);
var inst_55945 = fluree.db.util.async.throw_err(inst_55944);
var inst_55946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55945,(0),null);
var inst_55947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55945,(1),null);
var inst_55948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55949 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55951 = [inst_55940];
var inst_55952 = (new cljs.core.PersistentVector(null,1,(5),inst_55950,inst_55951,null));
var inst_55953 = ["query",inst_55952,inst_55946];
var inst_55954 = cljs.core.PersistentHashMap.fromArrays(inst_55949,inst_55953);
var inst_55955 = [inst_55954,inst_55947];
var inst_55956 = (new cljs.core.PersistentVector(null,2,(5),inst_55948,inst_55955,null));
var inst_55957 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55956);
var _ = (function (){var statearr_55967 = state_55962;
(statearr_55967[(4)] = cljs.core.rest((state_55962[(4)])));

return statearr_55967;
})();
var state_55962__$1 = (function (){var statearr_55968 = state_55962;
(statearr_55968[(8)] = inst_55957);

return statearr_55968;
})();
var statearr_55969_56104 = state_55962__$1;
(statearr_55969_56104[(2)] = inst_55946);

(statearr_55969_56104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (6))){
var state_55962__$1 = state_55962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55962__$1,(9),query_map);
} else {
if((state_val_55963 === (3))){
var inst_55960 = (state_55962[(2)]);
var state_55962__$1 = state_55962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55962__$1,inst_55960);
} else {
if((state_val_55963 === (12))){
var inst_55940 = (state_55962[(7)]);
var inst_55940__$1 = (state_55962[(2)]);
var inst_55941 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55942 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55941,inst_55940__$1);
var state_55962__$1 = (function (){var statearr_55970 = state_55962;
(statearr_55970[(7)] = inst_55940__$1);

return statearr_55970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55962__$1,(13),inst_55942);
} else {
if((state_val_55963 === (2))){
var _ = (function (){var statearr_55971 = state_55962;
(statearr_55971[(4)] = cljs.core.cons((5),(state_55962[(4)])));

return statearr_55971;
})();
var inst_55927 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55962__$1 = state_55962;
if(inst_55927){
var statearr_55972_56105 = state_55962__$1;
(statearr_55972_56105[(1)] = (6));

} else {
var statearr_55973_56106 = state_55962__$1;
(statearr_55973_56106[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (11))){
var inst_55934 = (state_55962[(9)]);
var state_55962__$1 = state_55962;
var statearr_55975_56107 = state_55962__$1;
(statearr_55975_56107[(2)] = inst_55934);

(statearr_55975_56107[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (9))){
var inst_55930 = (state_55962[(2)]);
var inst_55931 = fluree.db.util.async.throw_err(inst_55930);
var state_55962__$1 = state_55962;
var statearr_55976_56108 = state_55962__$1;
(statearr_55976_56108[(2)] = inst_55931);

(statearr_55976_56108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (5))){
var _ = (function (){var statearr_55977 = state_55962;
(statearr_55977[(4)] = cljs.core.rest((state_55962[(4)])));

return statearr_55977;
})();
var state_55962__$1 = state_55962;
var ex55974 = (state_55962__$1[(2)]);
var statearr_55978_56109 = state_55962__$1;
(statearr_55978_56109[(5)] = ex55974);


if((ex55974 instanceof Error)){
var statearr_55979_56110 = state_55962__$1;
(statearr_55979_56110[(1)] = (4));

(statearr_55979_56110[(5)] = null);

} else {
throw ex55974;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (10))){
var inst_55934 = (state_55962[(9)]);
var inst_55937 = fluree.db.util.json.parse(inst_55934);
var state_55962__$1 = state_55962;
var statearr_55980_56111 = state_55962__$1;
(statearr_55980_56111[(2)] = inst_55937);

(statearr_55980_56111[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (8))){
var inst_55934 = (state_55962[(9)]);
var inst_55934__$1 = (state_55962[(2)]);
var inst_55935 = typeof inst_55934__$1 === 'string';
var state_55962__$1 = (function (){var statearr_55981 = state_55962;
(statearr_55981[(9)] = inst_55934__$1);

return statearr_55981;
})();
if(cljs.core.truth_(inst_55935)){
var statearr_55982_56112 = state_55962__$1;
(statearr_55982_56112[(1)] = (10));

} else {
var statearr_55983_56113 = state_55962__$1;
(statearr_55983_56113[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55984 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55984[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55984[(1)] = (1));

return statearr_55984;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55962){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55962);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55985){var ex__2730__auto__ = e55985;
var statearr_55986_56114 = state_55962;
(statearr_55986_56114[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55962[(4)]))){
var statearr_55987_56115 = state_55962;
(statearr_55987_56115[(1)] = cljs.core.first((state_55962[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56116 = state_55962;
state_55962 = G__56116;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55962){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55988 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55988[(6)] = c__2749__auto__);

return statearr_55988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56059){
var state_val_56060 = (state_56059[(1)]);
if((state_val_56060 === (7))){
var state_56059__$1 = state_56059;
var statearr_56061_56117 = state_56059__$1;
(statearr_56061_56117[(2)] = select);

(statearr_56061_56117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (20))){
var inst_56029 = (state_56059[(2)]);
var inst_56030 = fluree.db.util.async.channel_QMARK_(limit);
var state_56059__$1 = (function (){var statearr_56062 = state_56059;
(statearr_56062[(7)] = inst_56029);

return statearr_56062;
})();
if(inst_56030){
var statearr_56063_56118 = state_56059__$1;
(statearr_56063_56118[(1)] = (22));

} else {
var statearr_56064_56119 = state_56059__$1;
(statearr_56064_56119[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (1))){
var state_56059__$1 = state_56059;
var statearr_56065_56120 = state_56059__$1;
(statearr_56065_56120[(2)] = null);

(statearr_56065_56120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (24))){
var inst_56021 = (state_56059[(8)]);
var inst_56013 = (state_56059[(9)]);
var inst_56005 = (state_56059[(10)]);
var inst_56029 = (state_56059[(7)]);
var inst_56037 = (state_56059[(2)]);
var inst_56038 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56039 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56038,inst_56005,inst_56013,inst_56021,inst_56029,inst_56037);
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56059__$1,(26),inst_56039);
} else {
if((state_val_56060 === (4))){
var inst_55989 = (state_56059[(2)]);
var state_56059__$1 = state_56059;
var statearr_56066_56121 = state_56059__$1;
(statearr_56066_56121[(2)] = inst_55989);

(statearr_56066_56121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (15))){
var state_56059__$1 = state_56059;
var statearr_56067_56122 = state_56059__$1;
(statearr_56067_56122[(2)] = where);

(statearr_56067_56122[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (21))){
var inst_56025 = (state_56059[(2)]);
var inst_56026 = fluree.db.util.async.throw_err(inst_56025);
var state_56059__$1 = state_56059;
var statearr_56068_56123 = state_56059__$1;
(statearr_56068_56123[(2)] = inst_56026);

(statearr_56068_56123[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (13))){
var inst_56009 = (state_56059[(2)]);
var inst_56010 = fluree.db.util.async.throw_err(inst_56009);
var state_56059__$1 = state_56059;
var statearr_56069_56124 = state_56059__$1;
(statearr_56069_56124[(2)] = inst_56010);

(statearr_56069_56124[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (22))){
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56059__$1,(25),limit);
} else {
if((state_val_56060 === (6))){
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56059__$1,(9),select);
} else {
if((state_val_56060 === (25))){
var inst_56033 = (state_56059[(2)]);
var inst_56034 = fluree.db.util.async.throw_err(inst_56033);
var state_56059__$1 = state_56059;
var statearr_56070_56125 = state_56059__$1;
(statearr_56070_56125[(2)] = inst_56034);

(statearr_56070_56125[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (17))){
var inst_56017 = (state_56059[(2)]);
var inst_56018 = fluree.db.util.async.throw_err(inst_56017);
var state_56059__$1 = state_56059;
var statearr_56071_56126 = state_56059__$1;
(statearr_56071_56126[(2)] = inst_56018);

(statearr_56071_56126[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (3))){
var inst_56057 = (state_56059[(2)]);
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56059__$1,inst_56057);
} else {
if((state_val_56060 === (12))){
var inst_56013 = (state_56059[(2)]);
var inst_56014 = fluree.db.util.async.channel_QMARK_(where);
var state_56059__$1 = (function (){var statearr_56072 = state_56059;
(statearr_56072[(9)] = inst_56013);

return statearr_56072;
})();
if(inst_56014){
var statearr_56073_56127 = state_56059__$1;
(statearr_56073_56127[(1)] = (14));

} else {
var statearr_56074_56128 = state_56059__$1;
(statearr_56074_56128[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (2))){
var _ = (function (){var statearr_56075 = state_56059;
(statearr_56075[(4)] = cljs.core.cons((5),(state_56059[(4)])));

return statearr_56075;
})();
var inst_55998 = fluree.db.util.async.channel_QMARK_(select);
var state_56059__$1 = state_56059;
if(inst_55998){
var statearr_56076_56129 = state_56059__$1;
(statearr_56076_56129[(1)] = (6));

} else {
var statearr_56077_56130 = state_56059__$1;
(statearr_56077_56130[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (23))){
var state_56059__$1 = state_56059;
var statearr_56078_56131 = state_56059__$1;
(statearr_56078_56131[(2)] = limit);

(statearr_56078_56131[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (19))){
var state_56059__$1 = state_56059;
var statearr_56079_56132 = state_56059__$1;
(statearr_56079_56132[(2)] = block);

(statearr_56079_56132[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (11))){
var state_56059__$1 = state_56059;
var statearr_56081_56133 = state_56059__$1;
(statearr_56081_56133[(2)] = from);

(statearr_56081_56133[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (9))){
var inst_56001 = (state_56059[(2)]);
var inst_56002 = fluree.db.util.async.throw_err(inst_56001);
var state_56059__$1 = state_56059;
var statearr_56082_56134 = state_56059__$1;
(statearr_56082_56134[(2)] = inst_56002);

(statearr_56082_56134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (5))){
var _ = (function (){var statearr_56083 = state_56059;
(statearr_56083[(4)] = cljs.core.rest((state_56059[(4)])));

return statearr_56083;
})();
var state_56059__$1 = state_56059;
var ex56080 = (state_56059__$1[(2)]);
var statearr_56084_56135 = state_56059__$1;
(statearr_56084_56135[(5)] = ex56080);


if((ex56080 instanceof Error)){
var statearr_56085_56136 = state_56059__$1;
(statearr_56085_56136[(1)] = (4));

(statearr_56085_56136[(5)] = null);

} else {
throw ex56080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (14))){
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56059__$1,(17),where);
} else {
if((state_val_56060 === (26))){
var inst_56021 = (state_56059[(8)]);
var inst_56013 = (state_56059[(9)]);
var inst_56005 = (state_56059[(10)]);
var inst_56029 = (state_56059[(7)]);
var inst_56041 = (state_56059[(2)]);
var inst_56042 = fluree.db.util.async.throw_err(inst_56041);
var inst_56043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56042,(0),null);
var inst_56044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56042,(1),null);
var inst_56045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56046 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56048 = [inst_56005,inst_56013,inst_56021,inst_56029];
var inst_56049 = (new cljs.core.PersistentVector(null,4,(5),inst_56047,inst_56048,null));
var inst_56050 = ["query",inst_56049,inst_56043];
var inst_56051 = cljs.core.PersistentHashMap.fromArrays(inst_56046,inst_56050);
var inst_56052 = [inst_56051,inst_56044];
var inst_56053 = (new cljs.core.PersistentVector(null,2,(5),inst_56045,inst_56052,null));
var inst_56054 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56053);
var _ = (function (){var statearr_56086 = state_56059;
(statearr_56086[(4)] = cljs.core.rest((state_56059[(4)])));

return statearr_56086;
})();
var state_56059__$1 = (function (){var statearr_56087 = state_56059;
(statearr_56087[(11)] = inst_56054);

return statearr_56087;
})();
var statearr_56088_56137 = state_56059__$1;
(statearr_56088_56137[(2)] = inst_56043);

(statearr_56088_56137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (16))){
var inst_56021 = (state_56059[(2)]);
var inst_56022 = fluree.db.util.async.channel_QMARK_(block);
var state_56059__$1 = (function (){var statearr_56089 = state_56059;
(statearr_56089[(8)] = inst_56021);

return statearr_56089;
})();
if(inst_56022){
var statearr_56090_56138 = state_56059__$1;
(statearr_56090_56138[(1)] = (18));

} else {
var statearr_56091_56139 = state_56059__$1;
(statearr_56091_56139[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56060 === (10))){
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56059__$1,(13),from);
} else {
if((state_val_56060 === (18))){
var state_56059__$1 = state_56059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56059__$1,(21),block);
} else {
if((state_val_56060 === (8))){
var inst_56005 = (state_56059[(2)]);
var inst_56006 = fluree.db.util.async.channel_QMARK_(from);
var state_56059__$1 = (function (){var statearr_56092 = state_56059;
(statearr_56092[(10)] = inst_56005);

return statearr_56092;
})();
if(inst_56006){
var statearr_56093_56140 = state_56059__$1;
(statearr_56093_56140[(1)] = (10));

} else {
var statearr_56094_56141 = state_56059__$1;
(statearr_56094_56141[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56095 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56095[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56095[(1)] = (1));

return statearr_56095;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56059){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56059);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56096){var ex__2730__auto__ = e56096;
var statearr_56097_56142 = state_56059;
(statearr_56097_56142[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56059[(4)]))){
var statearr_56098_56143 = state_56059;
(statearr_56098_56143[(1)] = cljs.core.first((state_56059[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56144 = state_56059;
state_56059 = G__56144;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56059){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56099 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56099[(6)] = c__2749__auto__);

return statearr_56099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56200){
var state_val_56201 = (state_56200[(1)]);
if((state_val_56201 === (7))){
var state_56200__$1 = state_56200;
var statearr_56202_56233 = state_56200__$1;
(statearr_56202_56233[(2)] = startSubject);

(statearr_56202_56233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (1))){
var state_56200__$1 = state_56200;
var statearr_56203_56234 = state_56200__$1;
(statearr_56203_56234[(2)] = null);

(statearr_56203_56234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (4))){
var inst_56145 = (state_56200[(2)]);
var state_56200__$1 = state_56200;
var statearr_56204_56235 = state_56200__$1;
(statearr_56204_56235[(2)] = inst_56145);

(statearr_56204_56235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (15))){
var inst_56177 = (state_56200[(2)]);
var inst_56178 = fluree.db.util.async.throw_err(inst_56177);
var inst_56179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56178,(0),null);
var inst_56180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56178,(1),null);
var inst_56181 = cljs.core.empty_QMARK_(inst_56179);
var state_56200__$1 = (function (){var statearr_56205 = state_56200;
(statearr_56205[(7)] = inst_56180);

return statearr_56205;
})();
if(inst_56181){
var statearr_56206_56236 = state_56200__$1;
(statearr_56206_56236[(1)] = (16));

} else {
var statearr_56207_56237 = state_56200__$1;
(statearr_56207_56237[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (13))){
var inst_56165 = (state_56200[(8)]);
var inst_56173 = (state_56200[(9)]);
var inst_56161 = (state_56200[(10)]);
var inst_56173__$1 = (state_56200[(2)]);
var inst_56174 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56175 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56174,inst_56161,inst_56165,inst_56173__$1);
var state_56200__$1 = (function (){var statearr_56208 = state_56200;
(statearr_56208[(9)] = inst_56173__$1);

return statearr_56208;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56200__$1,(15),inst_56175);
} else {
if((state_val_56201 === (6))){
var state_56200__$1 = state_56200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56200__$1,(9),startSubject);
} else {
if((state_val_56201 === (17))){
var state_56200__$1 = state_56200;
var statearr_56209_56238 = state_56200__$1;
(statearr_56209_56238[(2)] = true);

(statearr_56209_56238[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (3))){
var inst_56198 = (state_56200[(2)]);
var state_56200__$1 = state_56200;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56200__$1,inst_56198);
} else {
if((state_val_56201 === (12))){
var state_56200__$1 = state_56200;
var statearr_56210_56239 = state_56200__$1;
(statearr_56210_56239[(2)] = endSubject);

(statearr_56210_56239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (2))){
var _ = (function (){var statearr_56211 = state_56200;
(statearr_56211[(4)] = cljs.core.cons((5),(state_56200[(4)])));

return statearr_56211;
})();
var inst_56154 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56200__$1 = state_56200;
if(inst_56154){
var statearr_56212_56240 = state_56200__$1;
(statearr_56212_56240[(1)] = (6));

} else {
var statearr_56213_56241 = state_56200__$1;
(statearr_56213_56241[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (11))){
var state_56200__$1 = state_56200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56200__$1,(14),endSubject);
} else {
if((state_val_56201 === (9))){
var inst_56157 = (state_56200[(2)]);
var inst_56158 = fluree.db.util.async.throw_err(inst_56157);
var state_56200__$1 = state_56200;
var statearr_56215_56242 = state_56200__$1;
(statearr_56215_56242[(2)] = inst_56158);

(statearr_56215_56242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (5))){
var _ = (function (){var statearr_56216 = state_56200;
(statearr_56216[(4)] = cljs.core.rest((state_56200[(4)])));

return statearr_56216;
})();
var state_56200__$1 = state_56200;
var ex56214 = (state_56200__$1[(2)]);
var statearr_56217_56243 = state_56200__$1;
(statearr_56217_56243[(5)] = ex56214);


if((ex56214 instanceof Error)){
var statearr_56218_56244 = state_56200__$1;
(statearr_56218_56244[(1)] = (4));

(statearr_56218_56244[(5)] = null);

} else {
throw ex56214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (14))){
var inst_56169 = (state_56200[(2)]);
var inst_56170 = fluree.db.util.async.throw_err(inst_56169);
var state_56200__$1 = state_56200;
var statearr_56219_56245 = state_56200__$1;
(statearr_56219_56245[(2)] = inst_56170);

(statearr_56219_56245[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (16))){
var state_56200__$1 = state_56200;
var statearr_56220_56246 = state_56200__$1;
(statearr_56220_56246[(2)] = false);

(statearr_56220_56246[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (10))){
var inst_56164 = (state_56200[(2)]);
var inst_56165 = fluree.db.util.async.throw_err(inst_56164);
var inst_56166 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56200__$1 = (function (){var statearr_56221 = state_56200;
(statearr_56221[(8)] = inst_56165);

return statearr_56221;
})();
if(inst_56166){
var statearr_56222_56247 = state_56200__$1;
(statearr_56222_56247[(1)] = (11));

} else {
var statearr_56223_56248 = state_56200__$1;
(statearr_56223_56248[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (18))){
var inst_56165 = (state_56200[(8)]);
var inst_56180 = (state_56200[(7)]);
var inst_56173 = (state_56200[(9)]);
var inst_56161 = (state_56200[(10)]);
var inst_56185 = (state_56200[(2)]);
var inst_56186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56187 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56189 = [inst_56161,inst_56165,inst_56173];
var inst_56190 = (new cljs.core.PersistentVector(null,3,(5),inst_56188,inst_56189,null));
var inst_56191 = ["relationship?",inst_56190,inst_56185];
var inst_56192 = cljs.core.PersistentHashMap.fromArrays(inst_56187,inst_56191);
var inst_56193 = [inst_56192,inst_56180];
var inst_56194 = (new cljs.core.PersistentVector(null,2,(5),inst_56186,inst_56193,null));
var inst_56195 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56194);
var _ = (function (){var statearr_56224 = state_56200;
(statearr_56224[(4)] = cljs.core.rest((state_56200[(4)])));

return statearr_56224;
})();
var state_56200__$1 = (function (){var statearr_56225 = state_56200;
(statearr_56225[(11)] = inst_56195);

return statearr_56225;
})();
var statearr_56226_56249 = state_56200__$1;
(statearr_56226_56249[(2)] = inst_56185);

(statearr_56226_56249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56201 === (8))){
var inst_56161 = (state_56200[(2)]);
var inst_56162 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56200__$1 = (function (){var statearr_56227 = state_56200;
(statearr_56227[(10)] = inst_56161);

return statearr_56227;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56200__$1,(10),inst_56162);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_56228 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56228[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_56228[(1)] = (1));

return statearr_56228;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_56200){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56200);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56229){var ex__2730__auto__ = e56229;
var statearr_56230_56250 = state_56200;
(statearr_56230_56250[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56200[(4)]))){
var statearr_56231_56251 = state_56200;
(statearr_56231_56251[(1)] = cljs.core.first((state_56200[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56252 = state_56200;
state_56200 = G__56252;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_56200){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_56200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56232 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56232[(6)] = c__2749__auto__);

return statearr_56232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56289){
var state_val_56290 = (state_56289[(1)]);
if((state_val_56290 === (7))){
var state_56289__$1 = state_56289;
var statearr_56291_56311 = state_56289__$1;
(statearr_56291_56311[(2)] = pred_name);

(statearr_56291_56311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (1))){
var state_56289__$1 = state_56289;
var statearr_56292_56312 = state_56289__$1;
(statearr_56292_56312[(2)] = null);

(statearr_56292_56312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (4))){
var inst_56253 = (state_56289[(2)]);
var state_56289__$1 = state_56289;
var statearr_56293_56313 = state_56289__$1;
(statearr_56293_56313[(2)] = inst_56253);

(statearr_56293_56313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (6))){
var state_56289__$1 = state_56289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56289__$1,(9),pred_name);
} else {
if((state_val_56290 === (3))){
var inst_56287 = (state_56289[(2)]);
var state_56289__$1 = state_56289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56289__$1,inst_56287);
} else {
if((state_val_56290 === (2))){
var _ = (function (){var statearr_56295 = state_56289;
(statearr_56295[(4)] = cljs.core.cons((5),(state_56289[(4)])));

return statearr_56295;
})();
var inst_56262 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56289__$1 = state_56289;
if(inst_56262){
var statearr_56296_56314 = state_56289__$1;
(statearr_56296_56314[(1)] = (6));

} else {
var statearr_56297_56315 = state_56289__$1;
(statearr_56297_56315[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (9))){
var inst_56265 = (state_56289[(2)]);
var inst_56266 = fluree.db.util.async.throw_err(inst_56265);
var state_56289__$1 = state_56289;
var statearr_56298_56316 = state_56289__$1;
(statearr_56298_56316[(2)] = inst_56266);

(statearr_56298_56316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (5))){
var _ = (function (){var statearr_56299 = state_56289;
(statearr_56299[(4)] = cljs.core.rest((state_56289[(4)])));

return statearr_56299;
})();
var state_56289__$1 = state_56289;
var ex56294 = (state_56289__$1[(2)]);
var statearr_56300_56317 = state_56289__$1;
(statearr_56300_56317[(5)] = ex56294);


if((ex56294 instanceof Error)){
var statearr_56301_56318 = state_56289__$1;
(statearr_56301_56318[(1)] = (4));

(statearr_56301_56318[(5)] = null);

} else {
throw ex56294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (10))){
var inst_56269 = (state_56289[(7)]);
var inst_56273 = (state_56289[(2)]);
var inst_56274 = fluree.db.util.async.throw_err(inst_56273);
var inst_56275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56274,(0),null);
var inst_56276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56274,(1),null);
var inst_56277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56278 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56279 = ["max-pred-val",inst_56269,inst_56275];
var inst_56280 = cljs.core.PersistentHashMap.fromArrays(inst_56278,inst_56279);
var inst_56281 = (inst_56276 + (10));
var inst_56282 = [inst_56280,inst_56281];
var inst_56283 = (new cljs.core.PersistentVector(null,2,(5),inst_56277,inst_56282,null));
var inst_56284 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56283);
var _ = (function (){var statearr_56302 = state_56289;
(statearr_56302[(4)] = cljs.core.rest((state_56289[(4)])));

return statearr_56302;
})();
var state_56289__$1 = (function (){var statearr_56303 = state_56289;
(statearr_56303[(8)] = inst_56284);

return statearr_56303;
})();
var statearr_56304_56319 = state_56289__$1;
(statearr_56304_56319[(2)] = inst_56275);

(statearr_56304_56319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56290 === (8))){
var inst_56269 = (state_56289[(7)]);
var inst_56269__$1 = (state_56289[(2)]);
var inst_56270 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56271 = fluree.db.dbfunctions.internal.max_pred_val(inst_56270,inst_56269__$1,null);
var state_56289__$1 = (function (){var statearr_56305 = state_56289;
(statearr_56305[(7)] = inst_56269__$1);

return statearr_56305;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56289__$1,(10),inst_56271);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_56306 = [null,null,null,null,null,null,null,null,null];
(statearr_56306[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_56306[(1)] = (1));

return statearr_56306;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_56289){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56289);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56307){var ex__2730__auto__ = e56307;
var statearr_56308_56320 = state_56289;
(statearr_56308_56320[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56289[(4)]))){
var statearr_56309_56321 = state_56289;
(statearr_56309_56321[(1)] = cljs.core.first((state_56289[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56322 = state_56289;
state_56289 = G__56322;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_56289){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_56289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56310 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56310[(6)] = c__2749__auto__);

return statearr_56310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56349){
var state_val_56350 = (state_56349[(1)]);
if((state_val_56350 === (7))){
var state_56349__$1 = state_56349;
var statearr_56351_56370 = state_56349__$1;
(statearr_56351_56370[(2)] = n);

(statearr_56351_56370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56350 === (1))){
var state_56349__$1 = state_56349;
var statearr_56352_56371 = state_56349__$1;
(statearr_56352_56371[(2)] = null);

(statearr_56352_56371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56350 === (4))){
var inst_56323 = (state_56349[(2)]);
var state_56349__$1 = state_56349;
var statearr_56353_56372 = state_56349__$1;
(statearr_56353_56372[(2)] = inst_56323);

(statearr_56353_56372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56350 === (6))){
var state_56349__$1 = state_56349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56349__$1,(9),n);
} else {
if((state_val_56350 === (3))){
var inst_56347 = (state_56349[(2)]);
var state_56349__$1 = state_56349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56349__$1,inst_56347);
} else {
if((state_val_56350 === (2))){
var _ = (function (){var statearr_56355 = state_56349;
(statearr_56355[(4)] = cljs.core.cons((5),(state_56349[(4)])));

return statearr_56355;
})();
var inst_56329 = fluree.db.util.async.channel_QMARK_(n);
var state_56349__$1 = state_56349;
if(inst_56329){
var statearr_56356_56373 = state_56349__$1;
(statearr_56356_56373[(1)] = (6));

} else {
var statearr_56357_56374 = state_56349__$1;
(statearr_56357_56374[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56350 === (9))){
var inst_56332 = (state_56349[(2)]);
var inst_56333 = fluree.db.util.async.throw_err(inst_56332);
var state_56349__$1 = state_56349;
var statearr_56358_56375 = state_56349__$1;
(statearr_56358_56375[(2)] = inst_56333);

(statearr_56358_56375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56350 === (5))){
var _ = (function (){var statearr_56359 = state_56349;
(statearr_56359[(4)] = cljs.core.rest((state_56349[(4)])));

return statearr_56359;
})();
var state_56349__$1 = state_56349;
var ex56354 = (state_56349__$1[(2)]);
var statearr_56360_56376 = state_56349__$1;
(statearr_56360_56376[(5)] = ex56354);


if((ex56354 instanceof Error)){
var statearr_56361_56377 = state_56349__$1;
(statearr_56361_56377[(1)] = (4));

(statearr_56361_56377[(5)] = null);

} else {
throw ex56354;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56350 === (8))){
var inst_56336 = (state_56349[(2)]);
var inst_56337 = fluree.db.dbfunctions.internal.inc(inst_56336);
var inst_56338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56339 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56340 = ["inc",inst_56336,inst_56337];
var inst_56341 = cljs.core.PersistentHashMap.fromArrays(inst_56339,inst_56340);
var inst_56342 = [inst_56341,(10)];
var inst_56343 = (new cljs.core.PersistentVector(null,2,(5),inst_56338,inst_56342,null));
var inst_56344 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56343);
var _ = (function (){var statearr_56362 = state_56349;
(statearr_56362[(4)] = cljs.core.rest((state_56349[(4)])));

return statearr_56362;
})();
var state_56349__$1 = (function (){var statearr_56363 = state_56349;
(statearr_56363[(7)] = inst_56344);

return statearr_56363;
})();
var statearr_56364_56378 = state_56349__$1;
(statearr_56364_56378[(2)] = inst_56337);

(statearr_56364_56378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_56365 = [null,null,null,null,null,null,null,null];
(statearr_56365[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_56365[(1)] = (1));

return statearr_56365;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_56349){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56349);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56366){var ex__2730__auto__ = e56366;
var statearr_56367_56379 = state_56349;
(statearr_56367_56379[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56349[(4)]))){
var statearr_56368_56380 = state_56349;
(statearr_56368_56380[(1)] = cljs.core.first((state_56349[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56381 = state_56349;
state_56349 = G__56381;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_56349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_56349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56369 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56369[(6)] = c__2749__auto__);

return statearr_56369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56408){
var state_val_56409 = (state_56408[(1)]);
if((state_val_56409 === (7))){
var state_56408__$1 = state_56408;
var statearr_56410_56429 = state_56408__$1;
(statearr_56410_56429[(2)] = n);

(statearr_56410_56429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56409 === (1))){
var state_56408__$1 = state_56408;
var statearr_56411_56430 = state_56408__$1;
(statearr_56411_56430[(2)] = null);

(statearr_56411_56430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56409 === (4))){
var inst_56382 = (state_56408[(2)]);
var state_56408__$1 = state_56408;
var statearr_56412_56431 = state_56408__$1;
(statearr_56412_56431[(2)] = inst_56382);

(statearr_56412_56431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56409 === (6))){
var state_56408__$1 = state_56408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56408__$1,(9),n);
} else {
if((state_val_56409 === (3))){
var inst_56406 = (state_56408[(2)]);
var state_56408__$1 = state_56408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56408__$1,inst_56406);
} else {
if((state_val_56409 === (2))){
var _ = (function (){var statearr_56414 = state_56408;
(statearr_56414[(4)] = cljs.core.cons((5),(state_56408[(4)])));

return statearr_56414;
})();
var inst_56388 = fluree.db.util.async.channel_QMARK_(n);
var state_56408__$1 = state_56408;
if(inst_56388){
var statearr_56415_56432 = state_56408__$1;
(statearr_56415_56432[(1)] = (6));

} else {
var statearr_56416_56433 = state_56408__$1;
(statearr_56416_56433[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56409 === (9))){
var inst_56391 = (state_56408[(2)]);
var inst_56392 = fluree.db.util.async.throw_err(inst_56391);
var state_56408__$1 = state_56408;
var statearr_56417_56434 = state_56408__$1;
(statearr_56417_56434[(2)] = inst_56392);

(statearr_56417_56434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56409 === (5))){
var _ = (function (){var statearr_56418 = state_56408;
(statearr_56418[(4)] = cljs.core.rest((state_56408[(4)])));

return statearr_56418;
})();
var state_56408__$1 = state_56408;
var ex56413 = (state_56408__$1[(2)]);
var statearr_56419_56435 = state_56408__$1;
(statearr_56419_56435[(5)] = ex56413);


if((ex56413 instanceof Error)){
var statearr_56420_56436 = state_56408__$1;
(statearr_56420_56436[(1)] = (4));

(statearr_56420_56436[(5)] = null);

} else {
throw ex56413;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56409 === (8))){
var inst_56395 = (state_56408[(2)]);
var inst_56396 = fluree.db.dbfunctions.internal.dec(inst_56395);
var inst_56397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56398 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56399 = ["dec",inst_56395,inst_56396];
var inst_56400 = cljs.core.PersistentHashMap.fromArrays(inst_56398,inst_56399);
var inst_56401 = [inst_56400,(10)];
var inst_56402 = (new cljs.core.PersistentVector(null,2,(5),inst_56397,inst_56401,null));
var inst_56403 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56402);
var _ = (function (){var statearr_56421 = state_56408;
(statearr_56421[(4)] = cljs.core.rest((state_56408[(4)])));

return statearr_56421;
})();
var state_56408__$1 = (function (){var statearr_56422 = state_56408;
(statearr_56422[(7)] = inst_56403);

return statearr_56422;
})();
var statearr_56423_56437 = state_56408__$1;
(statearr_56423_56437[(2)] = inst_56396);

(statearr_56423_56437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_56424 = [null,null,null,null,null,null,null,null];
(statearr_56424[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_56424[(1)] = (1));

return statearr_56424;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_56408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56425){var ex__2730__auto__ = e56425;
var statearr_56426_56438 = state_56408;
(statearr_56426_56438[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56408[(4)]))){
var statearr_56427_56439 = state_56408;
(statearr_56427_56439[(1)] = cljs.core.first((state_56408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56440 = state_56408;
state_56408 = G__56440;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_56408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_56408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56428 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56428[(6)] = c__2749__auto__);

return statearr_56428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56490 = arguments.length;
var i__5770__auto___56491 = (0);
while(true){
if((i__5770__auto___56491 < len__5769__auto___56490)){
args__5775__auto__.push((arguments[i__5770__auto___56491]));

var G__56492 = (i__5770__auto___56491 + (1));
i__5770__auto___56491 = G__56492;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56473){
var state_val_56474 = (state_56473[(1)]);
if((state_val_56474 === (1))){
var state_56473__$1 = state_56473;
var statearr_56475_56493 = state_56473__$1;
(statearr_56475_56493[(2)] = null);

(statearr_56475_56493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56474 === (2))){
var _ = (function (){var statearr_56476 = state_56473;
(statearr_56476[(4)] = cljs.core.cons((5),(state_56473[(4)])));

return statearr_56476;
})();
var inst_56449 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56473__$1 = state_56473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56473__$1,(6),inst_56449);
} else {
if((state_val_56474 === (3))){
var inst_56471 = (state_56473[(2)]);
var state_56473__$1 = state_56473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56473__$1,inst_56471);
} else {
if((state_val_56474 === (4))){
var inst_56443 = (state_56473[(2)]);
var state_56473__$1 = state_56473;
var statearr_56478_56494 = state_56473__$1;
(statearr_56478_56494[(2)] = inst_56443);

(statearr_56478_56494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56474 === (5))){
var _ = (function (){var statearr_56479 = state_56473;
(statearr_56479[(4)] = cljs.core.rest((state_56473[(4)])));

return statearr_56479;
})();
var state_56473__$1 = state_56473;
var ex56477 = (state_56473__$1[(2)]);
var statearr_56480_56495 = state_56473__$1;
(statearr_56480_56495[(5)] = ex56477);


if((ex56477 instanceof Error)){
var statearr_56481_56496 = state_56473__$1;
(statearr_56481_56496[(1)] = (4));

(statearr_56481_56496[(5)] = null);

} else {
throw ex56477;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56474 === (6))){
var inst_56451 = (state_56473[(2)]);
var inst_56452 = fluree.db.util.async.throw_err(inst_56451);
var inst_56453 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56452);
var inst_56454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56455 = [inst_56452];
var inst_56456 = (new cljs.core.PersistentVector(null,1,(5),inst_56454,inst_56455,null));
var inst_56457 = cljs.core.count(inst_56456);
var inst_56458 = ((9) + inst_56457);
var inst_56459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56460 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56462 = [inst_56452];
var inst_56463 = (new cljs.core.PersistentVector(null,1,(5),inst_56461,inst_56462,null));
var inst_56464 = ["+",inst_56463,inst_56453];
var inst_56465 = cljs.core.PersistentHashMap.fromArrays(inst_56460,inst_56464);
var inst_56466 = [inst_56465,inst_56458];
var inst_56467 = (new cljs.core.PersistentVector(null,2,(5),inst_56459,inst_56466,null));
var inst_56468 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56467);
var _ = (function (){var statearr_56482 = state_56473;
(statearr_56482[(4)] = cljs.core.rest((state_56473[(4)])));

return statearr_56482;
})();
var state_56473__$1 = (function (){var statearr_56483 = state_56473;
(statearr_56483[(7)] = inst_56468);

return statearr_56483;
})();
var statearr_56484_56497 = state_56473__$1;
(statearr_56484_56497[(2)] = inst_56453);

(statearr_56484_56497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56485 = [null,null,null,null,null,null,null,null];
(statearr_56485[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56485[(1)] = (1));

return statearr_56485;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56473){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56473);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56486){var ex__2730__auto__ = e56486;
var statearr_56487_56498 = state_56473;
(statearr_56487_56498[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56473[(4)]))){
var statearr_56488_56499 = state_56473;
(statearr_56488_56499[(1)] = cljs.core.first((state_56473[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56500 = state_56473;
state_56473 = G__56500;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56473){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56489 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56489[(6)] = c__2749__auto__);

return statearr_56489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56441){
var G__56442 = cljs.core.first(seq56441);
var seq56441__$1 = cljs.core.next(seq56441);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56442,seq56441__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56550 = arguments.length;
var i__5770__auto___56551 = (0);
while(true){
if((i__5770__auto___56551 < len__5769__auto___56550)){
args__5775__auto__.push((arguments[i__5770__auto___56551]));

var G__56552 = (i__5770__auto___56551 + (1));
i__5770__auto___56551 = G__56552;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56533){
var state_val_56534 = (state_56533[(1)]);
if((state_val_56534 === (1))){
var state_56533__$1 = state_56533;
var statearr_56535_56553 = state_56533__$1;
(statearr_56535_56553[(2)] = null);

(statearr_56535_56553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (2))){
var _ = (function (){var statearr_56536 = state_56533;
(statearr_56536[(4)] = cljs.core.cons((5),(state_56533[(4)])));

return statearr_56536;
})();
var inst_56509 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56533__$1 = state_56533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56533__$1,(6),inst_56509);
} else {
if((state_val_56534 === (3))){
var inst_56531 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56533__$1,inst_56531);
} else {
if((state_val_56534 === (4))){
var inst_56503 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56538_56554 = state_56533__$1;
(statearr_56538_56554[(2)] = inst_56503);

(statearr_56538_56554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (5))){
var _ = (function (){var statearr_56539 = state_56533;
(statearr_56539[(4)] = cljs.core.rest((state_56533[(4)])));

return statearr_56539;
})();
var state_56533__$1 = state_56533;
var ex56537 = (state_56533__$1[(2)]);
var statearr_56540_56555 = state_56533__$1;
(statearr_56540_56555[(5)] = ex56537);


if((ex56537 instanceof Error)){
var statearr_56541_56556 = state_56533__$1;
(statearr_56541_56556[(1)] = (4));

(statearr_56541_56556[(5)] = null);

} else {
throw ex56537;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (6))){
var inst_56511 = (state_56533[(2)]);
var inst_56512 = fluree.db.util.async.throw_err(inst_56511);
var inst_56513 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56512);
var inst_56514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56515 = [inst_56512];
var inst_56516 = (new cljs.core.PersistentVector(null,1,(5),inst_56514,inst_56515,null));
var inst_56517 = cljs.core.count(inst_56516);
var inst_56518 = ((9) + inst_56517);
var inst_56519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56520 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56522 = [inst_56512];
var inst_56523 = (new cljs.core.PersistentVector(null,1,(5),inst_56521,inst_56522,null));
var inst_56524 = ["-",inst_56523,inst_56513];
var inst_56525 = cljs.core.PersistentHashMap.fromArrays(inst_56520,inst_56524);
var inst_56526 = [inst_56525,inst_56518];
var inst_56527 = (new cljs.core.PersistentVector(null,2,(5),inst_56519,inst_56526,null));
var inst_56528 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56527);
var _ = (function (){var statearr_56542 = state_56533;
(statearr_56542[(4)] = cljs.core.rest((state_56533[(4)])));

return statearr_56542;
})();
var state_56533__$1 = (function (){var statearr_56543 = state_56533;
(statearr_56543[(7)] = inst_56528);

return statearr_56543;
})();
var statearr_56544_56557 = state_56533__$1;
(statearr_56544_56557[(2)] = inst_56513);

(statearr_56544_56557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56545 = [null,null,null,null,null,null,null,null];
(statearr_56545[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56545[(1)] = (1));

return statearr_56545;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56533){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56533);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56546){var ex__2730__auto__ = e56546;
var statearr_56547_56558 = state_56533;
(statearr_56547_56558[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56533[(4)]))){
var statearr_56548_56559 = state_56533;
(statearr_56548_56559[(1)] = cljs.core.first((state_56533[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56560 = state_56533;
state_56533 = G__56560;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56533){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56549 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56549[(6)] = c__2749__auto__);

return statearr_56549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56501){
var G__56502 = cljs.core.first(seq56501);
var seq56501__$1 = cljs.core.next(seq56501);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56502,seq56501__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56610 = arguments.length;
var i__5770__auto___56611 = (0);
while(true){
if((i__5770__auto___56611 < len__5769__auto___56610)){
args__5775__auto__.push((arguments[i__5770__auto___56611]));

var G__56612 = (i__5770__auto___56611 + (1));
i__5770__auto___56611 = G__56612;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56593){
var state_val_56594 = (state_56593[(1)]);
if((state_val_56594 === (1))){
var state_56593__$1 = state_56593;
var statearr_56595_56613 = state_56593__$1;
(statearr_56595_56613[(2)] = null);

(statearr_56595_56613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56594 === (2))){
var _ = (function (){var statearr_56596 = state_56593;
(statearr_56596[(4)] = cljs.core.cons((5),(state_56593[(4)])));

return statearr_56596;
})();
var inst_56569 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56593__$1 = state_56593;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56593__$1,(6),inst_56569);
} else {
if((state_val_56594 === (3))){
var inst_56591 = (state_56593[(2)]);
var state_56593__$1 = state_56593;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56593__$1,inst_56591);
} else {
if((state_val_56594 === (4))){
var inst_56563 = (state_56593[(2)]);
var state_56593__$1 = state_56593;
var statearr_56598_56614 = state_56593__$1;
(statearr_56598_56614[(2)] = inst_56563);

(statearr_56598_56614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56594 === (5))){
var _ = (function (){var statearr_56599 = state_56593;
(statearr_56599[(4)] = cljs.core.rest((state_56593[(4)])));

return statearr_56599;
})();
var state_56593__$1 = state_56593;
var ex56597 = (state_56593__$1[(2)]);
var statearr_56600_56615 = state_56593__$1;
(statearr_56600_56615[(5)] = ex56597);


if((ex56597 instanceof Error)){
var statearr_56601_56616 = state_56593__$1;
(statearr_56601_56616[(1)] = (4));

(statearr_56601_56616[(5)] = null);

} else {
throw ex56597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56594 === (6))){
var inst_56571 = (state_56593[(2)]);
var inst_56572 = fluree.db.util.async.throw_err(inst_56571);
var inst_56573 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56572);
var inst_56574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56575 = [inst_56572];
var inst_56576 = (new cljs.core.PersistentVector(null,1,(5),inst_56574,inst_56575,null));
var inst_56577 = cljs.core.count(inst_56576);
var inst_56578 = ((9) + inst_56577);
var inst_56579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56580 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56582 = [inst_56572];
var inst_56583 = (new cljs.core.PersistentVector(null,1,(5),inst_56581,inst_56582,null));
var inst_56584 = ["*",inst_56583,inst_56573];
var inst_56585 = cljs.core.PersistentHashMap.fromArrays(inst_56580,inst_56584);
var inst_56586 = [inst_56585,inst_56578];
var inst_56587 = (new cljs.core.PersistentVector(null,2,(5),inst_56579,inst_56586,null));
var inst_56588 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56587);
var _ = (function (){var statearr_56602 = state_56593;
(statearr_56602[(4)] = cljs.core.rest((state_56593[(4)])));

return statearr_56602;
})();
var state_56593__$1 = (function (){var statearr_56603 = state_56593;
(statearr_56603[(7)] = inst_56588);

return statearr_56603;
})();
var statearr_56604_56617 = state_56593__$1;
(statearr_56604_56617[(2)] = inst_56573);

(statearr_56604_56617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56605 = [null,null,null,null,null,null,null,null];
(statearr_56605[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56605[(1)] = (1));

return statearr_56605;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56593){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56593);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56606){var ex__2730__auto__ = e56606;
var statearr_56607_56618 = state_56593;
(statearr_56607_56618[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56593[(4)]))){
var statearr_56608_56619 = state_56593;
(statearr_56608_56619[(1)] = cljs.core.first((state_56593[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56620 = state_56593;
state_56593 = G__56620;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56593){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56609 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56609[(6)] = c__2749__auto__);

return statearr_56609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56561){
var G__56562 = cljs.core.first(seq56561);
var seq56561__$1 = cljs.core.next(seq56561);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56562,seq56561__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56670 = arguments.length;
var i__5770__auto___56671 = (0);
while(true){
if((i__5770__auto___56671 < len__5769__auto___56670)){
args__5775__auto__.push((arguments[i__5770__auto___56671]));

var G__56672 = (i__5770__auto___56671 + (1));
i__5770__auto___56671 = G__56672;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56653){
var state_val_56654 = (state_56653[(1)]);
if((state_val_56654 === (1))){
var state_56653__$1 = state_56653;
var statearr_56655_56673 = state_56653__$1;
(statearr_56655_56673[(2)] = null);

(statearr_56655_56673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56654 === (2))){
var _ = (function (){var statearr_56656 = state_56653;
(statearr_56656[(4)] = cljs.core.cons((5),(state_56653[(4)])));

return statearr_56656;
})();
var inst_56629 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56653__$1 = state_56653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56653__$1,(6),inst_56629);
} else {
if((state_val_56654 === (3))){
var inst_56651 = (state_56653[(2)]);
var state_56653__$1 = state_56653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56653__$1,inst_56651);
} else {
if((state_val_56654 === (4))){
var inst_56623 = (state_56653[(2)]);
var state_56653__$1 = state_56653;
var statearr_56658_56674 = state_56653__$1;
(statearr_56658_56674[(2)] = inst_56623);

(statearr_56658_56674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56654 === (5))){
var _ = (function (){var statearr_56659 = state_56653;
(statearr_56659[(4)] = cljs.core.rest((state_56653[(4)])));

return statearr_56659;
})();
var state_56653__$1 = state_56653;
var ex56657 = (state_56653__$1[(2)]);
var statearr_56660_56675 = state_56653__$1;
(statearr_56660_56675[(5)] = ex56657);


if((ex56657 instanceof Error)){
var statearr_56661_56676 = state_56653__$1;
(statearr_56661_56676[(1)] = (4));

(statearr_56661_56676[(5)] = null);

} else {
throw ex56657;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56654 === (6))){
var inst_56631 = (state_56653[(2)]);
var inst_56632 = fluree.db.util.async.throw_err(inst_56631);
var inst_56633 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56632);
var inst_56634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56635 = [inst_56632];
var inst_56636 = (new cljs.core.PersistentVector(null,1,(5),inst_56634,inst_56635,null));
var inst_56637 = cljs.core.count(inst_56636);
var inst_56638 = ((9) + inst_56637);
var inst_56639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56640 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56642 = [inst_56632];
var inst_56643 = (new cljs.core.PersistentVector(null,1,(5),inst_56641,inst_56642,null));
var inst_56644 = ["/",inst_56643,inst_56633];
var inst_56645 = cljs.core.PersistentHashMap.fromArrays(inst_56640,inst_56644);
var inst_56646 = [inst_56645,inst_56638];
var inst_56647 = (new cljs.core.PersistentVector(null,2,(5),inst_56639,inst_56646,null));
var inst_56648 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56647);
var _ = (function (){var statearr_56662 = state_56653;
(statearr_56662[(4)] = cljs.core.rest((state_56653[(4)])));

return statearr_56662;
})();
var state_56653__$1 = (function (){var statearr_56663 = state_56653;
(statearr_56663[(7)] = inst_56648);

return statearr_56663;
})();
var statearr_56664_56677 = state_56653__$1;
(statearr_56664_56677[(2)] = inst_56633);

(statearr_56664_56677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56665 = [null,null,null,null,null,null,null,null];
(statearr_56665[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56665[(1)] = (1));

return statearr_56665;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56653){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56653);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56666){var ex__2730__auto__ = e56666;
var statearr_56667_56678 = state_56653;
(statearr_56667_56678[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56653[(4)]))){
var statearr_56668_56679 = state_56653;
(statearr_56668_56679[(1)] = cljs.core.first((state_56653[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56680 = state_56653;
state_56653 = G__56680;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56669 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56669[(6)] = c__2749__auto__);

return statearr_56669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56621){
var G__56622 = cljs.core.first(seq56621);
var seq56621__$1 = cljs.core.next(seq56621);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56622,seq56621__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56718){
var state_val_56719 = (state_56718[(1)]);
if((state_val_56719 === (7))){
var state_56718__$1 = state_56718;
var statearr_56720_56744 = state_56718__$1;
(statearr_56720_56744[(2)] = n);

(statearr_56720_56744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (1))){
var state_56718__$1 = state_56718;
var statearr_56721_56745 = state_56718__$1;
(statearr_56721_56745[(2)] = null);

(statearr_56721_56745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (4))){
var inst_56681 = (state_56718[(2)]);
var state_56718__$1 = state_56718;
var statearr_56722_56746 = state_56718__$1;
(statearr_56722_56746[(2)] = inst_56681);

(statearr_56722_56746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (13))){
var inst_56698 = (state_56718[(2)]);
var inst_56699 = fluree.db.util.async.throw_err(inst_56698);
var state_56718__$1 = state_56718;
var statearr_56723_56747 = state_56718__$1;
(statearr_56723_56747[(2)] = inst_56699);

(statearr_56723_56747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (6))){
var state_56718__$1 = state_56718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56718__$1,(9),n);
} else {
if((state_val_56719 === (3))){
var inst_56716 = (state_56718[(2)]);
var state_56718__$1 = state_56718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56718__$1,inst_56716);
} else {
if((state_val_56719 === (12))){
var inst_56694 = (state_56718[(7)]);
var inst_56702 = (state_56718[(2)]);
var inst_56703 = fluree.db.dbfunctions.internal.quot(inst_56694,inst_56702);
var inst_56704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56705 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56707 = [inst_56694,inst_56702];
var inst_56708 = (new cljs.core.PersistentVector(null,2,(5),inst_56706,inst_56707,null));
var inst_56709 = ["quot",inst_56708,inst_56703];
var inst_56710 = cljs.core.PersistentHashMap.fromArrays(inst_56705,inst_56709);
var inst_56711 = [inst_56710,(2)];
var inst_56712 = (new cljs.core.PersistentVector(null,2,(5),inst_56704,inst_56711,null));
var inst_56713 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56712);
var _ = (function (){var statearr_56724 = state_56718;
(statearr_56724[(4)] = cljs.core.rest((state_56718[(4)])));

return statearr_56724;
})();
var state_56718__$1 = (function (){var statearr_56725 = state_56718;
(statearr_56725[(8)] = inst_56713);

return statearr_56725;
})();
var statearr_56726_56748 = state_56718__$1;
(statearr_56726_56748[(2)] = inst_56703);

(statearr_56726_56748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (2))){
var _ = (function (){var statearr_56727 = state_56718;
(statearr_56727[(4)] = cljs.core.cons((5),(state_56718[(4)])));

return statearr_56727;
})();
var inst_56687 = fluree.db.util.async.channel_QMARK_(n);
var state_56718__$1 = state_56718;
if(inst_56687){
var statearr_56728_56749 = state_56718__$1;
(statearr_56728_56749[(1)] = (6));

} else {
var statearr_56729_56750 = state_56718__$1;
(statearr_56729_56750[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (11))){
var state_56718__$1 = state_56718;
var statearr_56731_56751 = state_56718__$1;
(statearr_56731_56751[(2)] = d);

(statearr_56731_56751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (9))){
var inst_56690 = (state_56718[(2)]);
var inst_56691 = fluree.db.util.async.throw_err(inst_56690);
var state_56718__$1 = state_56718;
var statearr_56732_56752 = state_56718__$1;
(statearr_56732_56752[(2)] = inst_56691);

(statearr_56732_56752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (5))){
var _ = (function (){var statearr_56733 = state_56718;
(statearr_56733[(4)] = cljs.core.rest((state_56718[(4)])));

return statearr_56733;
})();
var state_56718__$1 = state_56718;
var ex56730 = (state_56718__$1[(2)]);
var statearr_56734_56753 = state_56718__$1;
(statearr_56734_56753[(5)] = ex56730);


if((ex56730 instanceof Error)){
var statearr_56735_56754 = state_56718__$1;
(statearr_56735_56754[(1)] = (4));

(statearr_56735_56754[(5)] = null);

} else {
throw ex56730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56719 === (10))){
var state_56718__$1 = state_56718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56718__$1,(13),d);
} else {
if((state_val_56719 === (8))){
var inst_56694 = (state_56718[(2)]);
var inst_56695 = fluree.db.util.async.channel_QMARK_(d);
var state_56718__$1 = (function (){var statearr_56736 = state_56718;
(statearr_56736[(7)] = inst_56694);

return statearr_56736;
})();
if(inst_56695){
var statearr_56737_56755 = state_56718__$1;
(statearr_56737_56755[(1)] = (10));

} else {
var statearr_56738_56756 = state_56718__$1;
(statearr_56738_56756[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_56739 = [null,null,null,null,null,null,null,null,null];
(statearr_56739[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_56739[(1)] = (1));

return statearr_56739;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_56718){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56718);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56740){var ex__2730__auto__ = e56740;
var statearr_56741_56757 = state_56718;
(statearr_56741_56757[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56718[(4)]))){
var statearr_56742_56758 = state_56718;
(statearr_56742_56758[(1)] = cljs.core.first((state_56718[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56759 = state_56718;
state_56718 = G__56759;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_56718){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_56718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56743 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56743[(6)] = c__2749__auto__);

return statearr_56743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56797){
var state_val_56798 = (state_56797[(1)]);
if((state_val_56798 === (7))){
var state_56797__$1 = state_56797;
var statearr_56799_56823 = state_56797__$1;
(statearr_56799_56823[(2)] = n);

(statearr_56799_56823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (1))){
var state_56797__$1 = state_56797;
var statearr_56800_56824 = state_56797__$1;
(statearr_56800_56824[(2)] = null);

(statearr_56800_56824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (4))){
var inst_56760 = (state_56797[(2)]);
var state_56797__$1 = state_56797;
var statearr_56801_56825 = state_56797__$1;
(statearr_56801_56825[(2)] = inst_56760);

(statearr_56801_56825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (13))){
var inst_56777 = (state_56797[(2)]);
var inst_56778 = fluree.db.util.async.throw_err(inst_56777);
var state_56797__$1 = state_56797;
var statearr_56802_56826 = state_56797__$1;
(statearr_56802_56826[(2)] = inst_56778);

(statearr_56802_56826[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (6))){
var state_56797__$1 = state_56797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56797__$1,(9),n);
} else {
if((state_val_56798 === (3))){
var inst_56795 = (state_56797[(2)]);
var state_56797__$1 = state_56797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56797__$1,inst_56795);
} else {
if((state_val_56798 === (12))){
var inst_56773 = (state_56797[(7)]);
var inst_56781 = (state_56797[(2)]);
var inst_56782 = fluree.db.dbfunctions.internal.mod(inst_56773,inst_56781);
var inst_56783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56784 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56786 = [inst_56773,inst_56781];
var inst_56787 = (new cljs.core.PersistentVector(null,2,(5),inst_56785,inst_56786,null));
var inst_56788 = ["mod",inst_56787,inst_56782];
var inst_56789 = cljs.core.PersistentHashMap.fromArrays(inst_56784,inst_56788);
var inst_56790 = [inst_56789,(2)];
var inst_56791 = (new cljs.core.PersistentVector(null,2,(5),inst_56783,inst_56790,null));
var inst_56792 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56791);
var _ = (function (){var statearr_56803 = state_56797;
(statearr_56803[(4)] = cljs.core.rest((state_56797[(4)])));

return statearr_56803;
})();
var state_56797__$1 = (function (){var statearr_56804 = state_56797;
(statearr_56804[(8)] = inst_56792);

return statearr_56804;
})();
var statearr_56805_56827 = state_56797__$1;
(statearr_56805_56827[(2)] = inst_56782);

(statearr_56805_56827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (2))){
var _ = (function (){var statearr_56806 = state_56797;
(statearr_56806[(4)] = cljs.core.cons((5),(state_56797[(4)])));

return statearr_56806;
})();
var inst_56766 = fluree.db.util.async.channel_QMARK_(n);
var state_56797__$1 = state_56797;
if(inst_56766){
var statearr_56807_56828 = state_56797__$1;
(statearr_56807_56828[(1)] = (6));

} else {
var statearr_56808_56829 = state_56797__$1;
(statearr_56808_56829[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (11))){
var state_56797__$1 = state_56797;
var statearr_56810_56830 = state_56797__$1;
(statearr_56810_56830[(2)] = d);

(statearr_56810_56830[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (9))){
var inst_56769 = (state_56797[(2)]);
var inst_56770 = fluree.db.util.async.throw_err(inst_56769);
var state_56797__$1 = state_56797;
var statearr_56811_56831 = state_56797__$1;
(statearr_56811_56831[(2)] = inst_56770);

(statearr_56811_56831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (5))){
var _ = (function (){var statearr_56812 = state_56797;
(statearr_56812[(4)] = cljs.core.rest((state_56797[(4)])));

return statearr_56812;
})();
var state_56797__$1 = state_56797;
var ex56809 = (state_56797__$1[(2)]);
var statearr_56813_56832 = state_56797__$1;
(statearr_56813_56832[(5)] = ex56809);


if((ex56809 instanceof Error)){
var statearr_56814_56833 = state_56797__$1;
(statearr_56814_56833[(1)] = (4));

(statearr_56814_56833[(5)] = null);

} else {
throw ex56809;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56798 === (10))){
var state_56797__$1 = state_56797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56797__$1,(13),d);
} else {
if((state_val_56798 === (8))){
var inst_56773 = (state_56797[(2)]);
var inst_56774 = fluree.db.util.async.channel_QMARK_(d);
var state_56797__$1 = (function (){var statearr_56815 = state_56797;
(statearr_56815[(7)] = inst_56773);

return statearr_56815;
})();
if(inst_56774){
var statearr_56816_56834 = state_56797__$1;
(statearr_56816_56834[(1)] = (10));

} else {
var statearr_56817_56835 = state_56797__$1;
(statearr_56817_56835[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_56818 = [null,null,null,null,null,null,null,null,null];
(statearr_56818[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_56818[(1)] = (1));

return statearr_56818;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_56797){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56797);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56819){var ex__2730__auto__ = e56819;
var statearr_56820_56836 = state_56797;
(statearr_56820_56836[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56797[(4)]))){
var statearr_56821_56837 = state_56797;
(statearr_56821_56837[(1)] = cljs.core.first((state_56797[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56838 = state_56797;
state_56797 = G__56838;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_56797){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_56797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56822 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56822[(6)] = c__2749__auto__);

return statearr_56822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56876){
var state_val_56877 = (state_56876[(1)]);
if((state_val_56877 === (7))){
var state_56876__$1 = state_56876;
var statearr_56878_56902 = state_56876__$1;
(statearr_56878_56902[(2)] = n);

(statearr_56878_56902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (1))){
var state_56876__$1 = state_56876;
var statearr_56879_56903 = state_56876__$1;
(statearr_56879_56903[(2)] = null);

(statearr_56879_56903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (4))){
var inst_56839 = (state_56876[(2)]);
var state_56876__$1 = state_56876;
var statearr_56880_56904 = state_56876__$1;
(statearr_56880_56904[(2)] = inst_56839);

(statearr_56880_56904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (13))){
var inst_56856 = (state_56876[(2)]);
var inst_56857 = fluree.db.util.async.throw_err(inst_56856);
var state_56876__$1 = state_56876;
var statearr_56881_56905 = state_56876__$1;
(statearr_56881_56905[(2)] = inst_56857);

(statearr_56881_56905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (6))){
var state_56876__$1 = state_56876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56876__$1,(9),n);
} else {
if((state_val_56877 === (3))){
var inst_56874 = (state_56876[(2)]);
var state_56876__$1 = state_56876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56876__$1,inst_56874);
} else {
if((state_val_56877 === (12))){
var inst_56852 = (state_56876[(7)]);
var inst_56860 = (state_56876[(2)]);
var inst_56861 = fluree.db.dbfunctions.internal.rem(inst_56852,inst_56860);
var inst_56862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56863 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56865 = [inst_56852,inst_56860];
var inst_56866 = (new cljs.core.PersistentVector(null,2,(5),inst_56864,inst_56865,null));
var inst_56867 = ["rem",inst_56866,inst_56861];
var inst_56868 = cljs.core.PersistentHashMap.fromArrays(inst_56863,inst_56867);
var inst_56869 = [inst_56868,(2)];
var inst_56870 = (new cljs.core.PersistentVector(null,2,(5),inst_56862,inst_56869,null));
var inst_56871 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56870);
var _ = (function (){var statearr_56882 = state_56876;
(statearr_56882[(4)] = cljs.core.rest((state_56876[(4)])));

return statearr_56882;
})();
var state_56876__$1 = (function (){var statearr_56883 = state_56876;
(statearr_56883[(8)] = inst_56871);

return statearr_56883;
})();
var statearr_56884_56906 = state_56876__$1;
(statearr_56884_56906[(2)] = inst_56861);

(statearr_56884_56906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (2))){
var _ = (function (){var statearr_56885 = state_56876;
(statearr_56885[(4)] = cljs.core.cons((5),(state_56876[(4)])));

return statearr_56885;
})();
var inst_56845 = fluree.db.util.async.channel_QMARK_(n);
var state_56876__$1 = state_56876;
if(inst_56845){
var statearr_56886_56907 = state_56876__$1;
(statearr_56886_56907[(1)] = (6));

} else {
var statearr_56887_56908 = state_56876__$1;
(statearr_56887_56908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (11))){
var state_56876__$1 = state_56876;
var statearr_56889_56909 = state_56876__$1;
(statearr_56889_56909[(2)] = d);

(statearr_56889_56909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (9))){
var inst_56848 = (state_56876[(2)]);
var inst_56849 = fluree.db.util.async.throw_err(inst_56848);
var state_56876__$1 = state_56876;
var statearr_56890_56910 = state_56876__$1;
(statearr_56890_56910[(2)] = inst_56849);

(statearr_56890_56910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (5))){
var _ = (function (){var statearr_56891 = state_56876;
(statearr_56891[(4)] = cljs.core.rest((state_56876[(4)])));

return statearr_56891;
})();
var state_56876__$1 = state_56876;
var ex56888 = (state_56876__$1[(2)]);
var statearr_56892_56911 = state_56876__$1;
(statearr_56892_56911[(5)] = ex56888);


if((ex56888 instanceof Error)){
var statearr_56893_56912 = state_56876__$1;
(statearr_56893_56912[(1)] = (4));

(statearr_56893_56912[(5)] = null);

} else {
throw ex56888;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56877 === (10))){
var state_56876__$1 = state_56876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56876__$1,(13),d);
} else {
if((state_val_56877 === (8))){
var inst_56852 = (state_56876[(2)]);
var inst_56853 = fluree.db.util.async.channel_QMARK_(d);
var state_56876__$1 = (function (){var statearr_56894 = state_56876;
(statearr_56894[(7)] = inst_56852);

return statearr_56894;
})();
if(inst_56853){
var statearr_56895_56913 = state_56876__$1;
(statearr_56895_56913[(1)] = (10));

} else {
var statearr_56896_56914 = state_56876__$1;
(statearr_56896_56914[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_56897 = [null,null,null,null,null,null,null,null,null];
(statearr_56897[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_56897[(1)] = (1));

return statearr_56897;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_56876){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56876);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56898){var ex__2730__auto__ = e56898;
var statearr_56899_56915 = state_56876;
(statearr_56899_56915[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56876[(4)]))){
var statearr_56900_56916 = state_56876;
(statearr_56900_56916[(1)] = cljs.core.first((state_56876[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56917 = state_56876;
state_56876 = G__56917;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_56876){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_56876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56901 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56901[(6)] = c__2749__auto__);

return statearr_56901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56944){
var state_val_56945 = (state_56944[(1)]);
if((state_val_56945 === (7))){
var state_56944__$1 = state_56944;
var statearr_56946_56965 = state_56944__$1;
(statearr_56946_56965[(2)] = x);

(statearr_56946_56965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (1))){
var state_56944__$1 = state_56944;
var statearr_56947_56966 = state_56944__$1;
(statearr_56947_56966[(2)] = null);

(statearr_56947_56966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (4))){
var inst_56918 = (state_56944[(2)]);
var state_56944__$1 = state_56944;
var statearr_56948_56967 = state_56944__$1;
(statearr_56948_56967[(2)] = inst_56918);

(statearr_56948_56967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (6))){
var state_56944__$1 = state_56944;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56944__$1,(9),x);
} else {
if((state_val_56945 === (3))){
var inst_56942 = (state_56944[(2)]);
var state_56944__$1 = state_56944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56944__$1,inst_56942);
} else {
if((state_val_56945 === (2))){
var _ = (function (){var statearr_56950 = state_56944;
(statearr_56950[(4)] = cljs.core.cons((5),(state_56944[(4)])));

return statearr_56950;
})();
var inst_56924 = fluree.db.util.async.channel_QMARK_(x);
var state_56944__$1 = state_56944;
if(inst_56924){
var statearr_56951_56968 = state_56944__$1;
(statearr_56951_56968[(1)] = (6));

} else {
var statearr_56952_56969 = state_56944__$1;
(statearr_56952_56969[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (9))){
var inst_56927 = (state_56944[(2)]);
var inst_56928 = fluree.db.util.async.throw_err(inst_56927);
var state_56944__$1 = state_56944;
var statearr_56953_56970 = state_56944__$1;
(statearr_56953_56970[(2)] = inst_56928);

(statearr_56953_56970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (5))){
var _ = (function (){var statearr_56954 = state_56944;
(statearr_56954[(4)] = cljs.core.rest((state_56944[(4)])));

return statearr_56954;
})();
var state_56944__$1 = state_56944;
var ex56949 = (state_56944__$1[(2)]);
var statearr_56955_56971 = state_56944__$1;
(statearr_56955_56971[(5)] = ex56949);


if((ex56949 instanceof Error)){
var statearr_56956_56972 = state_56944__$1;
(statearr_56956_56972[(1)] = (4));

(statearr_56956_56972[(5)] = null);

} else {
throw ex56949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56945 === (8))){
var inst_56931 = (state_56944[(2)]);
var inst_56932 = fluree.db.dbfunctions.internal.boolean$(inst_56931);
var inst_56933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56934 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56935 = ["boolean",inst_56931,inst_56932];
var inst_56936 = cljs.core.PersistentHashMap.fromArrays(inst_56934,inst_56935);
var inst_56937 = [inst_56936,(10)];
var inst_56938 = (new cljs.core.PersistentVector(null,2,(5),inst_56933,inst_56937,null));
var inst_56939 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56938);
var _ = (function (){var statearr_56957 = state_56944;
(statearr_56957[(4)] = cljs.core.rest((state_56944[(4)])));

return statearr_56957;
})();
var state_56944__$1 = (function (){var statearr_56958 = state_56944;
(statearr_56958[(7)] = inst_56939);

return statearr_56958;
})();
var statearr_56959_56973 = state_56944__$1;
(statearr_56959_56973[(2)] = inst_56932);

(statearr_56959_56973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_56960 = [null,null,null,null,null,null,null,null];
(statearr_56960[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_56960[(1)] = (1));

return statearr_56960;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_56944){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56944);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56961){var ex__2730__auto__ = e56961;
var statearr_56962_56974 = state_56944;
(statearr_56962_56974[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56944[(4)]))){
var statearr_56963_56975 = state_56944;
(statearr_56963_56975[(1)] = cljs.core.first((state_56944[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56976 = state_56944;
state_56944 = G__56976;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_56944){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_56944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56964 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56964[(6)] = c__2749__auto__);

return statearr_56964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57014){
var state_val_57015 = (state_57014[(1)]);
if((state_val_57015 === (7))){
var state_57014__$1 = state_57014;
var statearr_57016_57040 = state_57014__$1;
(statearr_57016_57040[(2)] = pattern);

(statearr_57016_57040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (1))){
var state_57014__$1 = state_57014;
var statearr_57017_57041 = state_57014__$1;
(statearr_57017_57041[(2)] = null);

(statearr_57017_57041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (4))){
var inst_56977 = (state_57014[(2)]);
var state_57014__$1 = state_57014;
var statearr_57018_57042 = state_57014__$1;
(statearr_57018_57042[(2)] = inst_56977);

(statearr_57018_57042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (13))){
var inst_56994 = (state_57014[(2)]);
var inst_56995 = fluree.db.util.async.throw_err(inst_56994);
var state_57014__$1 = state_57014;
var statearr_57019_57043 = state_57014__$1;
(statearr_57019_57043[(2)] = inst_56995);

(statearr_57019_57043[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (6))){
var state_57014__$1 = state_57014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57014__$1,(9),pattern);
} else {
if((state_val_57015 === (3))){
var inst_57012 = (state_57014[(2)]);
var state_57014__$1 = state_57014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57014__$1,inst_57012);
} else {
if((state_val_57015 === (12))){
var inst_56990 = (state_57014[(7)]);
var inst_56998 = (state_57014[(2)]);
var inst_56999 = fluree.db.dbfunctions.internal.re_find(inst_56990,inst_56998);
var inst_57000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57001 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57003 = [inst_56990,inst_56998];
var inst_57004 = (new cljs.core.PersistentVector(null,2,(5),inst_57002,inst_57003,null));
var inst_57005 = ["re-find",inst_57004,inst_56999];
var inst_57006 = cljs.core.PersistentHashMap.fromArrays(inst_57001,inst_57005);
var inst_57007 = [inst_57006,(10)];
var inst_57008 = (new cljs.core.PersistentVector(null,2,(5),inst_57000,inst_57007,null));
var inst_57009 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57008);
var _ = (function (){var statearr_57020 = state_57014;
(statearr_57020[(4)] = cljs.core.rest((state_57014[(4)])));

return statearr_57020;
})();
var state_57014__$1 = (function (){var statearr_57021 = state_57014;
(statearr_57021[(8)] = inst_57009);

return statearr_57021;
})();
var statearr_57022_57044 = state_57014__$1;
(statearr_57022_57044[(2)] = inst_56999);

(statearr_57022_57044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (2))){
var _ = (function (){var statearr_57023 = state_57014;
(statearr_57023[(4)] = cljs.core.cons((5),(state_57014[(4)])));

return statearr_57023;
})();
var inst_56983 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57014__$1 = state_57014;
if(inst_56983){
var statearr_57024_57045 = state_57014__$1;
(statearr_57024_57045[(1)] = (6));

} else {
var statearr_57025_57046 = state_57014__$1;
(statearr_57025_57046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (11))){
var state_57014__$1 = state_57014;
var statearr_57027_57047 = state_57014__$1;
(statearr_57027_57047[(2)] = string);

(statearr_57027_57047[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (9))){
var inst_56986 = (state_57014[(2)]);
var inst_56987 = fluree.db.util.async.throw_err(inst_56986);
var state_57014__$1 = state_57014;
var statearr_57028_57048 = state_57014__$1;
(statearr_57028_57048[(2)] = inst_56987);

(statearr_57028_57048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (5))){
var _ = (function (){var statearr_57029 = state_57014;
(statearr_57029[(4)] = cljs.core.rest((state_57014[(4)])));

return statearr_57029;
})();
var state_57014__$1 = state_57014;
var ex57026 = (state_57014__$1[(2)]);
var statearr_57030_57049 = state_57014__$1;
(statearr_57030_57049[(5)] = ex57026);


if((ex57026 instanceof Error)){
var statearr_57031_57050 = state_57014__$1;
(statearr_57031_57050[(1)] = (4));

(statearr_57031_57050[(5)] = null);

} else {
throw ex57026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57015 === (10))){
var state_57014__$1 = state_57014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57014__$1,(13),string);
} else {
if((state_val_57015 === (8))){
var inst_56990 = (state_57014[(2)]);
var inst_56991 = fluree.db.util.async.channel_QMARK_(string);
var state_57014__$1 = (function (){var statearr_57032 = state_57014;
(statearr_57032[(7)] = inst_56990);

return statearr_57032;
})();
if(inst_56991){
var statearr_57033_57051 = state_57014__$1;
(statearr_57033_57051[(1)] = (10));

} else {
var statearr_57034_57052 = state_57014__$1;
(statearr_57034_57052[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_57035 = [null,null,null,null,null,null,null,null,null];
(statearr_57035[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_57035[(1)] = (1));

return statearr_57035;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_57014){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57014);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57036){var ex__2730__auto__ = e57036;
var statearr_57037_57053 = state_57014;
(statearr_57037_57053[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57014[(4)]))){
var statearr_57038_57054 = state_57014;
(statearr_57038_57054[(1)] = cljs.core.first((state_57014[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57055 = state_57014;
state_57014 = G__57055;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_57014){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_57014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57039 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57039[(6)] = c__2749__auto__);

return statearr_57039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57082){
var state_val_57083 = (state_57082[(1)]);
if((state_val_57083 === (7))){
var state_57082__$1 = state_57082;
var statearr_57084_57103 = state_57082__$1;
(statearr_57084_57103[(2)] = email);

(statearr_57084_57103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57083 === (1))){
var state_57082__$1 = state_57082;
var statearr_57085_57104 = state_57082__$1;
(statearr_57085_57104[(2)] = null);

(statearr_57085_57104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57083 === (4))){
var inst_57056 = (state_57082[(2)]);
var state_57082__$1 = state_57082;
var statearr_57086_57105 = state_57082__$1;
(statearr_57086_57105[(2)] = inst_57056);

(statearr_57086_57105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57083 === (6))){
var state_57082__$1 = state_57082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57082__$1,(9),email);
} else {
if((state_val_57083 === (3))){
var inst_57080 = (state_57082[(2)]);
var state_57082__$1 = state_57082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57082__$1,inst_57080);
} else {
if((state_val_57083 === (2))){
var _ = (function (){var statearr_57088 = state_57082;
(statearr_57088[(4)] = cljs.core.cons((5),(state_57082[(4)])));

return statearr_57088;
})();
var inst_57062 = fluree.db.util.async.channel_QMARK_(email);
var state_57082__$1 = state_57082;
if(inst_57062){
var statearr_57089_57106 = state_57082__$1;
(statearr_57089_57106[(1)] = (6));

} else {
var statearr_57090_57107 = state_57082__$1;
(statearr_57090_57107[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57083 === (9))){
var inst_57065 = (state_57082[(2)]);
var inst_57066 = fluree.db.util.async.throw_err(inst_57065);
var state_57082__$1 = state_57082;
var statearr_57091_57108 = state_57082__$1;
(statearr_57091_57108[(2)] = inst_57066);

(statearr_57091_57108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57083 === (5))){
var _ = (function (){var statearr_57092 = state_57082;
(statearr_57092[(4)] = cljs.core.rest((state_57082[(4)])));

return statearr_57092;
})();
var state_57082__$1 = state_57082;
var ex57087 = (state_57082__$1[(2)]);
var statearr_57093_57109 = state_57082__$1;
(statearr_57093_57109[(5)] = ex57087);


if((ex57087 instanceof Error)){
var statearr_57094_57110 = state_57082__$1;
(statearr_57094_57110[(1)] = (4));

(statearr_57094_57110[(5)] = null);

} else {
throw ex57087;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57083 === (8))){
var inst_57069 = (state_57082[(2)]);
var inst_57070 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57069);
var inst_57071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57072 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57073 = ["re-find",inst_57069,inst_57070];
var inst_57074 = cljs.core.PersistentHashMap.fromArrays(inst_57072,inst_57073);
var inst_57075 = [inst_57074,(10)];
var inst_57076 = (new cljs.core.PersistentVector(null,2,(5),inst_57071,inst_57075,null));
var inst_57077 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57076);
var _ = (function (){var statearr_57095 = state_57082;
(statearr_57095[(4)] = cljs.core.rest((state_57082[(4)])));

return statearr_57095;
})();
var state_57082__$1 = (function (){var statearr_57096 = state_57082;
(statearr_57096[(7)] = inst_57077);

return statearr_57096;
})();
var statearr_57097_57111 = state_57082__$1;
(statearr_57097_57111[(2)] = inst_57070);

(statearr_57097_57111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_57098 = [null,null,null,null,null,null,null,null];
(statearr_57098[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_57098[(1)] = (1));

return statearr_57098;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_57082){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57082);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57099){var ex__2730__auto__ = e57099;
var statearr_57100_57112 = state_57082;
(statearr_57100_57112[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57082[(4)]))){
var statearr_57101_57113 = state_57082;
(statearr_57101_57113[(1)] = cljs.core.first((state_57082[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57114 = state_57082;
state_57082 = G__57114;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_57082){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_57082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57102 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57102[(6)] = c__2749__auto__);

return statearr_57102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57161){
var state_val_57162 = (state_57161[(1)]);
if((state_val_57162 === (7))){
var inst_57131 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57161__$1 = state_57161;
if(cljs.core.truth_(inst_57131)){
var statearr_57163_57190 = state_57161__$1;
(statearr_57163_57190[(1)] = (9));

} else {
var statearr_57164_57191 = state_57161__$1;
(statearr_57164_57191[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (1))){
var state_57161__$1 = state_57161;
var statearr_57165_57192 = state_57161__$1;
(statearr_57165_57192[(2)] = null);

(statearr_57165_57192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (4))){
var inst_57115 = (state_57161[(2)]);
var state_57161__$1 = state_57161;
var statearr_57166_57193 = state_57161__$1;
(statearr_57166_57193[(2)] = inst_57115);

(statearr_57166_57193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (15))){
var inst_57142 = (state_57161[(2)]);
var state_57161__$1 = state_57161;
var statearr_57167_57194 = state_57161__$1;
(statearr_57167_57194[(2)] = inst_57142);

(statearr_57167_57194[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (13))){
var inst_57139 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57161__$1 = state_57161;
var statearr_57168_57195 = state_57161__$1;
(statearr_57168_57195[(2)] = inst_57139);

(statearr_57168_57195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (6))){
var inst_57126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57127 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57128 = [inst_57127,(0)];
var inst_57129 = (new cljs.core.PersistentVector(null,2,(5),inst_57126,inst_57128,null));
var state_57161__$1 = state_57161;
var statearr_57169_57196 = state_57161__$1;
(statearr_57169_57196[(2)] = inst_57129);

(statearr_57169_57196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (3))){
var inst_57159 = (state_57161[(2)]);
var state_57161__$1 = state_57161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57161__$1,inst_57159);
} else {
if((state_val_57162 === (12))){
var inst_57135 = (state_57161[(2)]);
var inst_57136 = fluree.db.util.async.throw_err(inst_57135);
var state_57161__$1 = state_57161;
var statearr_57170_57197 = state_57161__$1;
(statearr_57170_57197[(2)] = inst_57136);

(statearr_57170_57197[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (2))){
var _ = (function (){var statearr_57171 = state_57161;
(statearr_57171[(4)] = cljs.core.cons((5),(state_57161[(4)])));

return statearr_57171;
})();
var inst_57124 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57161__$1 = state_57161;
if(cljs.core.truth_(inst_57124)){
var statearr_57172_57198 = state_57161__$1;
(statearr_57172_57198[(1)] = (6));

} else {
var statearr_57173_57199 = state_57161__$1;
(statearr_57173_57199[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (11))){
var inst_57144 = (state_57161[(2)]);
var state_57161__$1 = state_57161;
var statearr_57175_57200 = state_57161__$1;
(statearr_57175_57200[(2)] = inst_57144);

(statearr_57175_57200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (9))){
var inst_57133 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57161__$1 = state_57161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57161__$1,(12),inst_57133);
} else {
if((state_val_57162 === (5))){
var _ = (function (){var statearr_57176 = state_57161;
(statearr_57176[(4)] = cljs.core.rest((state_57161[(4)])));

return statearr_57176;
})();
var state_57161__$1 = state_57161;
var ex57174 = (state_57161__$1[(2)]);
var statearr_57177_57201 = state_57161__$1;
(statearr_57177_57201[(5)] = ex57174);


if((ex57174 instanceof Error)){
var statearr_57178_57202 = state_57161__$1;
(statearr_57178_57202[(1)] = (4));

(statearr_57178_57202[(5)] = null);

} else {
throw ex57174;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (14))){
var state_57161__$1 = state_57161;
var statearr_57179_57203 = state_57161__$1;
(statearr_57179_57203[(2)] = null);

(statearr_57179_57203[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (10))){
var state_57161__$1 = state_57161;
var statearr_57180_57204 = state_57161__$1;
(statearr_57180_57204[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57162 === (8))){
var inst_57146 = (state_57161[(2)]);
var inst_57147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57146,(0),null);
var inst_57148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57146,(1),null);
var inst_57149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57150 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57151 = ["?user_id","?ctx",inst_57147];
var inst_57152 = cljs.core.PersistentHashMap.fromArrays(inst_57150,inst_57151);
var inst_57153 = ((10) + inst_57148);
var inst_57154 = [inst_57152,inst_57153];
var inst_57155 = (new cljs.core.PersistentVector(null,2,(5),inst_57149,inst_57154,null));
var inst_57156 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57155);
var _ = (function (){var statearr_57182 = state_57161;
(statearr_57182[(4)] = cljs.core.rest((state_57161[(4)])));

return statearr_57182;
})();
var state_57161__$1 = (function (){var statearr_57183 = state_57161;
(statearr_57183[(7)] = inst_57156);

return statearr_57183;
})();
var statearr_57184_57205 = state_57161__$1;
(statearr_57184_57205[(2)] = inst_57147);

(statearr_57184_57205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_57185 = [null,null,null,null,null,null,null,null];
(statearr_57185[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_57185[(1)] = (1));

return statearr_57185;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_57161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57186){var ex__2730__auto__ = e57186;
var statearr_57187_57206 = state_57161;
(statearr_57187_57206[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57161[(4)]))){
var statearr_57188_57207 = state_57161;
(statearr_57188_57207[(1)] = cljs.core.first((state_57161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57208 = state_57161;
state_57161 = G__57208;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_57161){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_57161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57189 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57189[(6)] = c__2749__auto__);

return statearr_57189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57236){
var state_val_57237 = (state_57236[(1)]);
if((state_val_57237 === (7))){
var inst_57229 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57236__$1 = state_57236;
var statearr_57238_57257 = state_57236__$1;
(statearr_57238_57257[(2)] = inst_57229);

(statearr_57238_57257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57237 === (1))){
var state_57236__$1 = state_57236;
var statearr_57239_57258 = state_57236__$1;
(statearr_57239_57258[(2)] = null);

(statearr_57239_57258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57237 === (4))){
var inst_57209 = (state_57236[(2)]);
var state_57236__$1 = state_57236;
var statearr_57240_57259 = state_57236__$1;
(statearr_57240_57259[(2)] = inst_57209);

(statearr_57240_57259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57237 === (6))){
var inst_57217 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57236__$1 = state_57236;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57236__$1,(9),inst_57217);
} else {
if((state_val_57237 === (3))){
var inst_57234 = (state_57236[(2)]);
var state_57236__$1 = state_57236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57236__$1,inst_57234);
} else {
if((state_val_57237 === (2))){
var _ = (function (){var statearr_57242 = state_57236;
(statearr_57242[(4)] = cljs.core.cons((5),(state_57236[(4)])));

return statearr_57242;
})();
var inst_57215 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57236__$1 = state_57236;
if(cljs.core.truth_(inst_57215)){
var statearr_57243_57260 = state_57236__$1;
(statearr_57243_57260[(1)] = (6));

} else {
var statearr_57244_57261 = state_57236__$1;
(statearr_57244_57261[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57237 === (9))){
var inst_57219 = (state_57236[(2)]);
var inst_57220 = fluree.db.util.async.throw_err(inst_57219);
var inst_57221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57222 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57223 = ["?auth_id","?ctx",inst_57220];
var inst_57224 = cljs.core.PersistentHashMap.fromArrays(inst_57222,inst_57223);
var inst_57225 = [inst_57224,(10)];
var inst_57226 = (new cljs.core.PersistentVector(null,2,(5),inst_57221,inst_57225,null));
var inst_57227 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57226);
var state_57236__$1 = (function (){var statearr_57245 = state_57236;
(statearr_57245[(7)] = inst_57227);

return statearr_57245;
})();
var statearr_57246_57262 = state_57236__$1;
(statearr_57246_57262[(2)] = inst_57220);

(statearr_57246_57262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57237 === (5))){
var _ = (function (){var statearr_57247 = state_57236;
(statearr_57247[(4)] = cljs.core.rest((state_57236[(4)])));

return statearr_57247;
})();
var state_57236__$1 = state_57236;
var ex57241 = (state_57236__$1[(2)]);
var statearr_57248_57263 = state_57236__$1;
(statearr_57248_57263[(5)] = ex57241);


if((ex57241 instanceof Error)){
var statearr_57249_57264 = state_57236__$1;
(statearr_57249_57264[(1)] = (4));

(statearr_57249_57264[(5)] = null);

} else {
throw ex57241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57237 === (8))){
var inst_57231 = (state_57236[(2)]);
var _ = (function (){var statearr_57250 = state_57236;
(statearr_57250[(4)] = cljs.core.rest((state_57236[(4)])));

return statearr_57250;
})();
var state_57236__$1 = state_57236;
var statearr_57251_57265 = state_57236__$1;
(statearr_57251_57265[(2)] = inst_57231);

(statearr_57251_57265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_57252 = [null,null,null,null,null,null,null,null];
(statearr_57252[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_57252[(1)] = (1));

return statearr_57252;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_57236){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57236);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57253){var ex__2730__auto__ = e57253;
var statearr_57254_57266 = state_57236;
(statearr_57254_57266[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57236[(4)]))){
var statearr_57255_57267 = state_57236;
(statearr_57255_57267[(1)] = cljs.core.first((state_57236[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57268 = state_57236;
state_57236 = G__57268;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_57236){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_57236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57256 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57256[(6)] = c__2749__auto__);

return statearr_57256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57270 = arguments.length;
switch (G__57270) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57312){
var state_val_57313 = (state_57312[(1)]);
if((state_val_57313 === (7))){
var state_57312__$1 = state_57312;
var statearr_57314_57344 = state_57312__$1;
(statearr_57314_57344[(2)] = seed);

(statearr_57314_57344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (1))){
var state_57312__$1 = state_57312;
var statearr_57315_57345 = state_57312__$1;
(statearr_57315_57345[(2)] = null);

(statearr_57315_57345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (4))){
var inst_57271 = (state_57312[(2)]);
var state_57312__$1 = state_57312;
var statearr_57316_57346 = state_57312__$1;
(statearr_57316_57346[(2)] = inst_57271);

(statearr_57316_57346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (15))){
var state_57312__$1 = state_57312;
var statearr_57317_57347 = state_57312__$1;
(statearr_57317_57347[(2)] = (10));

(statearr_57317_57347[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (13))){
var inst_57288 = (state_57312[(2)]);
var inst_57289 = fluree.db.util.async.throw_err(inst_57288);
var state_57312__$1 = state_57312;
var statearr_57318_57348 = state_57312__$1;
(statearr_57318_57348[(2)] = inst_57289);

(statearr_57318_57348[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (6))){
var state_57312__$1 = state_57312;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57312__$1,(9),seed);
} else {
if((state_val_57313 === (3))){
var inst_57310 = (state_57312[(2)]);
var state_57312__$1 = state_57312;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57312__$1,inst_57310);
} else {
if((state_val_57313 === (12))){
var inst_57292 = (state_57312[(7)]);
var inst_57292__$1 = (state_57312[(2)]);
var state_57312__$1 = (function (){var statearr_57319 = state_57312;
(statearr_57319[(7)] = inst_57292__$1);

return statearr_57319;
})();
if(cljs.core.truth_(inst_57292__$1)){
var statearr_57320_57349 = state_57312__$1;
(statearr_57320_57349[(1)] = (14));

} else {
var statearr_57321_57350 = state_57312__$1;
(statearr_57321_57350[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (2))){
var _ = (function (){var statearr_57322 = state_57312;
(statearr_57322[(4)] = cljs.core.cons((5),(state_57312[(4)])));

return statearr_57322;
})();
var inst_57277 = fluree.db.util.async.channel_QMARK_(seed);
var state_57312__$1 = state_57312;
if(inst_57277){
var statearr_57323_57351 = state_57312__$1;
(statearr_57323_57351[(1)] = (6));

} else {
var statearr_57324_57352 = state_57312__$1;
(statearr_57324_57352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (11))){
var state_57312__$1 = state_57312;
var statearr_57326_57353 = state_57312__$1;
(statearr_57326_57353[(2)] = max);

(statearr_57326_57353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (9))){
var inst_57280 = (state_57312[(2)]);
var inst_57281 = fluree.db.util.async.throw_err(inst_57280);
var state_57312__$1 = state_57312;
var statearr_57327_57354 = state_57312__$1;
(statearr_57327_57354[(2)] = inst_57281);

(statearr_57327_57354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (5))){
var _ = (function (){var statearr_57328 = state_57312;
(statearr_57328[(4)] = cljs.core.rest((state_57312[(4)])));

return statearr_57328;
})();
var state_57312__$1 = state_57312;
var ex57325 = (state_57312__$1[(2)]);
var statearr_57329_57355 = state_57312__$1;
(statearr_57329_57355[(5)] = ex57325);


if((ex57325 instanceof Error)){
var statearr_57330_57356 = state_57312__$1;
(statearr_57330_57356[(1)] = (4));

(statearr_57330_57356[(5)] = null);

} else {
throw ex57325;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (14))){
var inst_57292 = (state_57312[(7)]);
var state_57312__$1 = state_57312;
var statearr_57331_57357 = state_57312__$1;
(statearr_57331_57357[(2)] = inst_57292);

(statearr_57331_57357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (16))){
var inst_57284 = (state_57312[(8)]);
var inst_57296 = (state_57312[(2)]);
var inst_57297 = fluree.db.dbfunctions.internal.rand(inst_57284,inst_57296);
var inst_57298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57299 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57301 = [max,seed];
var inst_57302 = (new cljs.core.PersistentVector(null,2,(5),inst_57300,inst_57301,null));
var inst_57303 = ["rand",inst_57302,inst_57297];
var inst_57304 = cljs.core.PersistentHashMap.fromArrays(inst_57299,inst_57303);
var inst_57305 = [inst_57304,(10)];
var inst_57306 = (new cljs.core.PersistentVector(null,2,(5),inst_57298,inst_57305,null));
var inst_57307 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57306);
var _ = (function (){var statearr_57332 = state_57312;
(statearr_57332[(4)] = cljs.core.rest((state_57312[(4)])));

return statearr_57332;
})();
var state_57312__$1 = (function (){var statearr_57333 = state_57312;
(statearr_57333[(9)] = inst_57307);

return statearr_57333;
})();
var statearr_57334_57358 = state_57312__$1;
(statearr_57334_57358[(2)] = inst_57297);

(statearr_57334_57358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57313 === (10))){
var state_57312__$1 = state_57312;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57312__$1,(13),max);
} else {
if((state_val_57313 === (8))){
var inst_57284 = (state_57312[(2)]);
var inst_57285 = fluree.db.util.async.channel_QMARK_(max);
var state_57312__$1 = (function (){var statearr_57335 = state_57312;
(statearr_57335[(8)] = inst_57284);

return statearr_57335;
})();
if(inst_57285){
var statearr_57336_57359 = state_57312__$1;
(statearr_57336_57359[(1)] = (10));

} else {
var statearr_57337_57360 = state_57312__$1;
(statearr_57337_57360[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_57338 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57338[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_57338[(1)] = (1));

return statearr_57338;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_57312){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57312);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57339){var ex__2730__auto__ = e57339;
var statearr_57340_57361 = state_57312;
(statearr_57340_57361[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57312[(4)]))){
var statearr_57341_57362 = state_57312;
(statearr_57341_57362[(1)] = cljs.core.first((state_57312[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57363 = state_57312;
state_57312 = G__57363;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_57312){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_57312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57342 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57342[(6)] = c__2749__auto__);

return statearr_57342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57384){
var state_val_57385 = (state_57384[(1)]);
if((state_val_57385 === (1))){
var state_57384__$1 = state_57384;
var statearr_57386_57401 = state_57384__$1;
(statearr_57386_57401[(2)] = null);

(statearr_57386_57401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57385 === (2))){
var _ = (function (){var statearr_57387 = state_57384;
(statearr_57387[(4)] = cljs.core.cons((5),(state_57384[(4)])));

return statearr_57387;
})();
var inst_57370 = cljs.core.random_uuid();
var inst_57371 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57370);
var inst_57372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57373 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57374 = cljs.core.PersistentVector.EMPTY;
var inst_57375 = ["uuid",inst_57374,inst_57371];
var inst_57376 = cljs.core.PersistentHashMap.fromArrays(inst_57373,inst_57375);
var inst_57377 = [inst_57376,(10)];
var inst_57378 = (new cljs.core.PersistentVector(null,2,(5),inst_57372,inst_57377,null));
var inst_57379 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57378);
var ___$1 = (function (){var statearr_57388 = state_57384;
(statearr_57388[(4)] = cljs.core.rest((state_57384[(4)])));

return statearr_57388;
})();
var state_57384__$1 = (function (){var statearr_57389 = state_57384;
(statearr_57389[(7)] = inst_57379);

return statearr_57389;
})();
var statearr_57390_57402 = state_57384__$1;
(statearr_57390_57402[(2)] = inst_57371);

(statearr_57390_57402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57385 === (3))){
var inst_57382 = (state_57384[(2)]);
var state_57384__$1 = state_57384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57384__$1,inst_57382);
} else {
if((state_val_57385 === (4))){
var inst_57364 = (state_57384[(2)]);
var state_57384__$1 = state_57384;
var statearr_57392_57403 = state_57384__$1;
(statearr_57392_57403[(2)] = inst_57364);

(statearr_57392_57403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57385 === (5))){
var _ = (function (){var statearr_57393 = state_57384;
(statearr_57393[(4)] = cljs.core.rest((state_57384[(4)])));

return statearr_57393;
})();
var state_57384__$1 = state_57384;
var ex57391 = (state_57384__$1[(2)]);
var statearr_57394_57404 = state_57384__$1;
(statearr_57394_57404[(5)] = ex57391);


if((ex57391 instanceof Error)){
var statearr_57395_57405 = state_57384__$1;
(statearr_57395_57405[(1)] = (4));

(statearr_57395_57405[(5)] = null);

} else {
throw ex57391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_57396 = [null,null,null,null,null,null,null,null];
(statearr_57396[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_57396[(1)] = (1));

return statearr_57396;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_57384){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57384);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57397){var ex__2730__auto__ = e57397;
var statearr_57398_57406 = state_57384;
(statearr_57398_57406[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57384[(4)]))){
var statearr_57399_57407 = state_57384;
(statearr_57399_57407[(1)] = cljs.core.first((state_57384[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57408 = state_57384;
state_57384 = G__57408;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_57384){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_57384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57400 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57400[(6)] = c__2749__auto__);

return statearr_57400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57438){
var state_val_57439 = (state_57438[(1)]);
if((state_val_57439 === (7))){
var state_57438__$1 = state_57438;
var statearr_57440_57459 = state_57438__$1;
(statearr_57440_57459[(2)] = num);

(statearr_57440_57459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57439 === (1))){
var state_57438__$1 = state_57438;
var statearr_57441_57460 = state_57438__$1;
(statearr_57441_57460[(2)] = null);

(statearr_57441_57460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57439 === (4))){
var inst_57409 = (state_57438[(2)]);
var state_57438__$1 = state_57438;
var statearr_57442_57461 = state_57438__$1;
(statearr_57442_57461[(2)] = inst_57409);

(statearr_57442_57461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57439 === (6))){
var state_57438__$1 = state_57438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57438__$1,(9),num);
} else {
if((state_val_57439 === (3))){
var inst_57436 = (state_57438[(2)]);
var state_57438__$1 = state_57438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57438__$1,inst_57436);
} else {
if((state_val_57439 === (2))){
var _ = (function (){var statearr_57444 = state_57438;
(statearr_57444[(4)] = cljs.core.cons((5),(state_57438[(4)])));

return statearr_57444;
})();
var inst_57415 = fluree.db.util.async.channel_QMARK_(num);
var state_57438__$1 = state_57438;
if(inst_57415){
var statearr_57445_57462 = state_57438__$1;
(statearr_57445_57462[(1)] = (6));

} else {
var statearr_57446_57463 = state_57438__$1;
(statearr_57446_57463[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57439 === (9))){
var inst_57418 = (state_57438[(2)]);
var inst_57419 = fluree.db.util.async.throw_err(inst_57418);
var state_57438__$1 = state_57438;
var statearr_57447_57464 = state_57438__$1;
(statearr_57447_57464[(2)] = inst_57419);

(statearr_57447_57464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57439 === (5))){
var _ = (function (){var statearr_57448 = state_57438;
(statearr_57448[(4)] = cljs.core.rest((state_57438[(4)])));

return statearr_57448;
})();
var state_57438__$1 = state_57438;
var ex57443 = (state_57438__$1[(2)]);
var statearr_57449_57465 = state_57438__$1;
(statearr_57449_57465[(5)] = ex57443);


if((ex57443 instanceof Error)){
var statearr_57450_57466 = state_57438__$1;
(statearr_57450_57466[(1)] = (4));

(statearr_57450_57466[(5)] = null);

} else {
throw ex57443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57439 === (8))){
var inst_57422 = (state_57438[(2)]);
var inst_57423 = fluree.db.dbfunctions.internal.ceil(inst_57422);
var inst_57424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57425 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57427 = [fluree.db.dbfunctions.fns.ceil];
var inst_57428 = (new cljs.core.PersistentVector(null,1,(5),inst_57426,inst_57427,null));
var inst_57429 = ["",inst_57428,inst_57423];
var inst_57430 = cljs.core.PersistentHashMap.fromArrays(inst_57425,inst_57429);
var inst_57431 = [inst_57430,(10)];
var inst_57432 = (new cljs.core.PersistentVector(null,2,(5),inst_57424,inst_57431,null));
var inst_57433 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57432);
var _ = (function (){var statearr_57451 = state_57438;
(statearr_57451[(4)] = cljs.core.rest((state_57438[(4)])));

return statearr_57451;
})();
var state_57438__$1 = (function (){var statearr_57452 = state_57438;
(statearr_57452[(7)] = inst_57433);

return statearr_57452;
})();
var statearr_57453_57467 = state_57438__$1;
(statearr_57453_57467[(2)] = inst_57423);

(statearr_57453_57467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_57454 = [null,null,null,null,null,null,null,null];
(statearr_57454[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_57454[(1)] = (1));

return statearr_57454;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_57438){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57438);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57455){var ex__2730__auto__ = e57455;
var statearr_57456_57468 = state_57438;
(statearr_57456_57468[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57438[(4)]))){
var statearr_57457_57469 = state_57438;
(statearr_57457_57469[(1)] = cljs.core.first((state_57438[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57470 = state_57438;
state_57438 = G__57470;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_57438){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_57438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57458 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57458[(6)] = c__2749__auto__);

return statearr_57458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57500){
var state_val_57501 = (state_57500[(1)]);
if((state_val_57501 === (7))){
var state_57500__$1 = state_57500;
var statearr_57502_57521 = state_57500__$1;
(statearr_57502_57521[(2)] = num);

(statearr_57502_57521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57501 === (1))){
var state_57500__$1 = state_57500;
var statearr_57503_57522 = state_57500__$1;
(statearr_57503_57522[(2)] = null);

(statearr_57503_57522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57501 === (4))){
var inst_57471 = (state_57500[(2)]);
var state_57500__$1 = state_57500;
var statearr_57504_57523 = state_57500__$1;
(statearr_57504_57523[(2)] = inst_57471);

(statearr_57504_57523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57501 === (6))){
var state_57500__$1 = state_57500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57500__$1,(9),num);
} else {
if((state_val_57501 === (3))){
var inst_57498 = (state_57500[(2)]);
var state_57500__$1 = state_57500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57500__$1,inst_57498);
} else {
if((state_val_57501 === (2))){
var _ = (function (){var statearr_57506 = state_57500;
(statearr_57506[(4)] = cljs.core.cons((5),(state_57500[(4)])));

return statearr_57506;
})();
var inst_57477 = fluree.db.util.async.channel_QMARK_(num);
var state_57500__$1 = state_57500;
if(inst_57477){
var statearr_57507_57524 = state_57500__$1;
(statearr_57507_57524[(1)] = (6));

} else {
var statearr_57508_57525 = state_57500__$1;
(statearr_57508_57525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57501 === (9))){
var inst_57480 = (state_57500[(2)]);
var inst_57481 = fluree.db.util.async.throw_err(inst_57480);
var state_57500__$1 = state_57500;
var statearr_57509_57526 = state_57500__$1;
(statearr_57509_57526[(2)] = inst_57481);

(statearr_57509_57526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57501 === (5))){
var _ = (function (){var statearr_57510 = state_57500;
(statearr_57510[(4)] = cljs.core.rest((state_57500[(4)])));

return statearr_57510;
})();
var state_57500__$1 = state_57500;
var ex57505 = (state_57500__$1[(2)]);
var statearr_57511_57527 = state_57500__$1;
(statearr_57511_57527[(5)] = ex57505);


if((ex57505 instanceof Error)){
var statearr_57512_57528 = state_57500__$1;
(statearr_57512_57528[(1)] = (4));

(statearr_57512_57528[(5)] = null);

} else {
throw ex57505;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57501 === (8))){
var inst_57484 = (state_57500[(2)]);
var inst_57485 = fluree.db.dbfunctions.internal.floor(inst_57484);
var inst_57486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57487 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57489 = [fluree.db.dbfunctions.fns.floor];
var inst_57490 = (new cljs.core.PersistentVector(null,1,(5),inst_57488,inst_57489,null));
var inst_57491 = ["",inst_57490,inst_57485];
var inst_57492 = cljs.core.PersistentHashMap.fromArrays(inst_57487,inst_57491);
var inst_57493 = [inst_57492,(10)];
var inst_57494 = (new cljs.core.PersistentVector(null,2,(5),inst_57486,inst_57493,null));
var inst_57495 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57494);
var _ = (function (){var statearr_57513 = state_57500;
(statearr_57513[(4)] = cljs.core.rest((state_57500[(4)])));

return statearr_57513;
})();
var state_57500__$1 = (function (){var statearr_57514 = state_57500;
(statearr_57514[(7)] = inst_57495);

return statearr_57514;
})();
var statearr_57515_57529 = state_57500__$1;
(statearr_57515_57529[(2)] = inst_57485);

(statearr_57515_57529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_57516 = [null,null,null,null,null,null,null,null];
(statearr_57516[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_57516[(1)] = (1));

return statearr_57516;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_57500){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57500);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57517){var ex__2730__auto__ = e57517;
var statearr_57518_57530 = state_57500;
(statearr_57518_57530[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57500[(4)]))){
var statearr_57519_57531 = state_57500;
(statearr_57519_57531[(1)] = cljs.core.first((state_57500[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57532 = state_57500;
state_57500 = G__57532;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_57500){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_57500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57520 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57520[(6)] = c__2749__auto__);

return statearr_57520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57557){
var state_val_57558 = (state_57557[(1)]);
if((state_val_57558 === (1))){
var state_57557__$1 = state_57557;
var statearr_57559_57574 = state_57557__$1;
(statearr_57559_57574[(2)] = null);

(statearr_57559_57574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57558 === (2))){
var _ = (function (){var statearr_57560 = state_57557;
(statearr_57560[(4)] = cljs.core.cons((5),(state_57557[(4)])));

return statearr_57560;
})();
var inst_57539 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57557__$1 = state_57557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57557__$1,(6),inst_57539);
} else {
if((state_val_57558 === (3))){
var inst_57555 = (state_57557[(2)]);
var state_57557__$1 = state_57557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57557__$1,inst_57555);
} else {
if((state_val_57558 === (4))){
var inst_57533 = (state_57557[(2)]);
var state_57557__$1 = state_57557;
var statearr_57562_57575 = state_57557__$1;
(statearr_57562_57575[(2)] = inst_57533);

(statearr_57562_57575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57558 === (5))){
var _ = (function (){var statearr_57563 = state_57557;
(statearr_57563[(4)] = cljs.core.rest((state_57557[(4)])));

return statearr_57563;
})();
var state_57557__$1 = state_57557;
var ex57561 = (state_57557__$1[(2)]);
var statearr_57564_57576 = state_57557__$1;
(statearr_57564_57576[(5)] = ex57561);


if((ex57561 instanceof Error)){
var statearr_57565_57577 = state_57557__$1;
(statearr_57565_57577[(1)] = (4));

(statearr_57565_57577[(5)] = null);

} else {
throw ex57561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57558 === (6))){
var inst_57541 = (state_57557[(2)]);
var inst_57542 = fluree.db.util.async.throw_err(inst_57541);
var inst_57543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57544 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57546 = [compare_val,new_val];
var inst_57547 = (new cljs.core.PersistentVector(null,2,(5),inst_57545,inst_57546,null));
var inst_57548 = ["",inst_57547,inst_57542];
var inst_57549 = cljs.core.PersistentHashMap.fromArrays(inst_57544,inst_57548);
var inst_57550 = [inst_57549,(10)];
var inst_57551 = (new cljs.core.PersistentVector(null,2,(5),inst_57543,inst_57550,null));
var inst_57552 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57551);
var _ = (function (){var statearr_57566 = state_57557;
(statearr_57566[(4)] = cljs.core.rest((state_57557[(4)])));

return statearr_57566;
})();
var state_57557__$1 = (function (){var statearr_57567 = state_57557;
(statearr_57567[(7)] = inst_57552);

return statearr_57567;
})();
var statearr_57568_57578 = state_57557__$1;
(statearr_57568_57578[(2)] = inst_57542);

(statearr_57568_57578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_57569 = [null,null,null,null,null,null,null,null];
(statearr_57569[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_57569[(1)] = (1));

return statearr_57569;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_57557){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57557);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57570){var ex__2730__auto__ = e57570;
var statearr_57571_57579 = state_57557;
(statearr_57571_57579[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57557[(4)]))){
var statearr_57572_57580 = state_57557;
(statearr_57572_57580[(1)] = cljs.core.first((state_57557[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57581 = state_57557;
state_57557 = G__57581;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_57557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_57557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57573 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57573[(6)] = c__2749__auto__);

return statearr_57573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
