// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72879 = arguments.length;
switch (G__72879) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72924){
var state_val_72925 = (state_72924[(1)]);
if((state_val_72925 === (7))){
var inst_72894 = typeof user === 'string';
var state_72924__$1 = state_72924;
if(cljs.core.truth_(inst_72894)){
var statearr_72926_72955 = state_72924__$1;
(statearr_72926_72955[(1)] = (9));

} else {
var statearr_72927_72956 = state_72924__$1;
(statearr_72927_72956[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (1))){
var state_72924__$1 = state_72924;
var statearr_72928_72957 = state_72924__$1;
(statearr_72928_72957[(2)] = null);

(statearr_72928_72957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (4))){
var inst_72880 = (state_72924[(2)]);
var inst_72881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72882 = [inst_72880];
var inst_72883 = (new cljs.core.PersistentVector(null,1,(5),inst_72881,inst_72882,null));
var inst_72884 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72883);
var inst_72885 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72880) : reject.call(null,inst_72880));
var state_72924__$1 = (function (){var statearr_72929 = state_72924;
(statearr_72929[(7)] = inst_72884);

return statearr_72929;
})();
var statearr_72930_72958 = state_72924__$1;
(statearr_72930_72958[(2)] = inst_72885);

(statearr_72930_72958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (15))){
var inst_72913 = (state_72924[(2)]);
var inst_72914 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72913);
var inst_72915 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72916 = cljs.core.constantly(inst_72914);
var inst_72917 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72915,inst_72916);
var inst_72918 = fluree.db.connection.add_token(conn,inst_72914);
var inst_72919 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_72913) : resolve.call(null,inst_72913));
var _ = (function (){var statearr_72931 = state_72924;
(statearr_72931[(4)] = cljs.core.rest((state_72924[(4)])));

return statearr_72931;
})();
var state_72924__$1 = (function (){var statearr_72932 = state_72924;
(statearr_72932[(8)] = inst_72918);

(statearr_72932[(9)] = inst_72917);

return statearr_72932;
})();
var statearr_72933_72959 = state_72924__$1;
(statearr_72933_72959[(2)] = inst_72919);

(statearr_72933_72959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (13))){
var state_72924__$1 = state_72924;
var statearr_72934_72960 = state_72924__$1;
(statearr_72934_72960[(2)] = null);

(statearr_72934_72960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (6))){
var state_72924__$1 = state_72924;
var statearr_72935_72961 = state_72924__$1;
(statearr_72935_72961[(2)] = user);

(statearr_72935_72961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (3))){
var inst_72922 = (state_72924[(2)]);
var state_72924__$1 = state_72924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72924__$1,inst_72922);
} else {
if((state_val_72925 === (12))){
var state_72924__$1 = state_72924;
var statearr_72936_72962 = state_72924__$1;
(statearr_72936_72962[(2)] = user);

(statearr_72936_72962[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (2))){
var _ = (function (){var statearr_72937 = state_72924;
(statearr_72937[(4)] = cljs.core.cons((5),(state_72924[(4)])));

return statearr_72937;
})();
var inst_72891 = typeof user === 'number';
var state_72924__$1 = state_72924;
if(cljs.core.truth_(inst_72891)){
var statearr_72938_72963 = state_72924__$1;
(statearr_72938_72963[(1)] = (6));

} else {
var statearr_72939_72964 = state_72924__$1;
(statearr_72939_72964[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (11))){
var inst_72905 = (state_72924[(2)]);
var state_72924__$1 = state_72924;
var statearr_72941_72965 = state_72924__$1;
(statearr_72941_72965[(2)] = inst_72905);

(statearr_72941_72965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (9))){
var inst_72896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72897 = ["_user/username",user];
var inst_72898 = (new cljs.core.PersistentVector(null,2,(5),inst_72896,inst_72897,null));
var state_72924__$1 = state_72924;
var statearr_72942_72966 = state_72924__$1;
(statearr_72942_72966[(2)] = inst_72898);

(statearr_72942_72966[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (5))){
var _ = (function (){var statearr_72943 = state_72924;
(statearr_72943[(4)] = cljs.core.rest((state_72924[(4)])));

return statearr_72943;
})();
var state_72924__$1 = state_72924;
var ex72940 = (state_72924__$1[(2)]);
var statearr_72944_72967 = state_72924__$1;
(statearr_72944_72967[(5)] = ex72940);


var statearr_72945_72968 = state_72924__$1;
(statearr_72945_72968[(1)] = (4));

(statearr_72945_72968[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (14))){
var inst_72903 = (state_72924[(2)]);
var state_72924__$1 = state_72924;
var statearr_72946_72969 = state_72924__$1;
(statearr_72946_72969[(2)] = inst_72903);

(statearr_72946_72969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (10))){
var state_72924__$1 = state_72924;
var statearr_72947_72970 = state_72924__$1;
(statearr_72947_72970[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72925 === (8))){
var inst_72907 = (state_72924[(2)]);
var inst_72908 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72909 = [account,inst_72907,password,expireSeconds,syncTo];
var inst_72910 = cljs.core.PersistentHashMap.fromArrays(inst_72908,inst_72909);
var inst_72911 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72910);
var state_72924__$1 = state_72924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72924__$1,(15),inst_72911);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72949 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72949[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72949[(1)] = (1));

return statearr_72949;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72924){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72924);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72950){var ex__2730__auto__ = e72950;
var statearr_72951_72971 = state_72924;
(statearr_72951_72971[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72924[(4)]))){
var statearr_72952_72972 = state_72924;
(statearr_72952_72972[(1)] = cljs.core.first((state_72924[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72973 = state_72924;
state_72924 = G__72973;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72924){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72953 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72953[(6)] = c__2749__auto__);

return statearr_72953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__72975 = arguments.length;
switch (G__72975) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72984){
var state_val_72985 = (state_72984[(1)]);
if((state_val_72985 === (1))){
var inst_72976 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72978 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_72979 = (new cljs.core.PersistentVector(null,4,(5),inst_72977,inst_72978,null));
var inst_72980 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72976,inst_72979);
var inst_72981 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__72986 = cljs.core.seq(cljs.core.keys(x));
var chunk__72987 = null;
var count__72988 = (0);
var i__72989 = (0);
while(true){
if((i__72989 < count__72988)){
var k = chunk__72987.cljs$core$IIndexed$_nth$arity$2(null,i__72989);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__72997 = seq__72986;
var G__72998 = chunk__72987;
var G__72999 = count__72988;
var G__73000 = (i__72989 + (1));
seq__72986 = G__72997;
chunk__72987 = G__72998;
count__72988 = G__72999;
i__72989 = G__73000;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__72986);
if(temp__5804__auto__){
var seq__72986__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__72986__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__72986__$1);
var G__73001 = cljs.core.chunk_rest(seq__72986__$1);
var G__73002 = c__5568__auto__;
var G__73003 = cljs.core.count(c__5568__auto__);
var G__73004 = (0);
seq__72986 = G__73001;
chunk__72987 = G__73002;
count__72988 = G__73003;
i__72989 = G__73004;
continue;
} else {
var k = cljs.core.first(seq__72986__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__73005 = cljs.core.next(seq__72986__$1);
var G__73006 = null;
var G__73007 = (0);
var G__73008 = (0);
seq__72986 = G__73005;
chunk__72987 = G__73006;
count__72988 = G__73007;
i__72989 = G__73008;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_72982 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72981);
var state_72984__$1 = (function (){var statearr_72990 = state_72984;
(statearr_72990[(7)] = inst_72980);

return statearr_72990;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72984__$1,inst_72982);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72991 = [null,null,null,null,null,null,null,null];
(statearr_72991[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72991[(1)] = (1));

return statearr_72991;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72984){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72984);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72992){var ex__2730__auto__ = e72992;
var statearr_72993_73009 = state_72984;
(statearr_72993_73009[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72984[(4)]))){
var statearr_72994_73010 = state_72984;
(statearr_72994_73010[(1)] = cljs.core.first((state_72984[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73011 = state_72984;
state_72984 = G__73011;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72984){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72995 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72995[(6)] = c__2749__auto__);

return statearr_72995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__73013 = arguments.length;
switch (G__73013) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73050){
var state_val_73051 = (state_73050[(1)]);
if((state_val_73051 === (1))){
var state_73050__$1 = state_73050;
var statearr_73052_73073 = state_73050__$1;
(statearr_73052_73073[(2)] = null);

(statearr_73052_73073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73051 === (2))){
var _ = (function (){var statearr_73053 = state_73050;
(statearr_73053[(4)] = cljs.core.cons((5),(state_73050[(4)])));

return statearr_73053;
})();
var inst_73025 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_73026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73027 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_73028 = (new cljs.core.PersistentVector(null,1,(5),inst_73026,inst_73027,null));
var inst_73029 = cljs.core.PersistentHashMap.EMPTY;
var inst_73030 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_73029);
var inst_73031 = cljs.core.assoc_in(inst_73025,inst_73028,inst_73030);
var inst_73032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73033 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73034 = (new cljs.core.PersistentVector(null,1,(5),inst_73032,inst_73033,null));
var inst_73035 = cljs.core.PersistentHashMap.EMPTY;
var inst_73036 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_73035);
var inst_73037 = cljs.core.assoc_in(inst_73031,inst_73034,inst_73036);
var inst_73038 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73039 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_73037);
var inst_73040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73041 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_73038,null];
var inst_73042 = (new cljs.core.PersistentVector(null,4,(5),inst_73040,inst_73041,null));
var inst_73043 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73039,inst_73042);
var inst_73044 = (function (){var conn = inst_73037;
var pc = inst_73038;
return (function (x){
if((x == null)){
} else {
var seq__73054_73074 = cljs.core.seq(cljs.core.keys(x));
var chunk__73055_73075 = null;
var count__73056_73076 = (0);
var i__73057_73077 = (0);
while(true){
if((i__73057_73077 < count__73056_73076)){
var k_73078 = chunk__73055_73075.cljs$core$IIndexed$_nth$arity$2(null,i__73057_73077);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73078], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_73078,null));


var G__73079 = seq__73054_73074;
var G__73080 = chunk__73055_73075;
var G__73081 = count__73056_73076;
var G__73082 = (i__73057_73077 + (1));
seq__73054_73074 = G__73079;
chunk__73055_73075 = G__73080;
count__73056_73076 = G__73081;
i__73057_73077 = G__73082;
continue;
} else {
var temp__5804__auto___73083 = cljs.core.seq(seq__73054_73074);
if(temp__5804__auto___73083){
var seq__73054_73084__$1 = temp__5804__auto___73083;
if(cljs.core.chunked_seq_QMARK_(seq__73054_73084__$1)){
var c__5568__auto___73085 = cljs.core.chunk_first(seq__73054_73084__$1);
var G__73086 = cljs.core.chunk_rest(seq__73054_73084__$1);
var G__73087 = c__5568__auto___73085;
var G__73088 = cljs.core.count(c__5568__auto___73085);
var G__73089 = (0);
seq__73054_73074 = G__73086;
chunk__73055_73075 = G__73087;
count__73056_73076 = G__73088;
i__73057_73077 = G__73089;
continue;
} else {
var k_73090 = cljs.core.first(seq__73054_73084__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73090], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_73090,null));


var G__73091 = cljs.core.next(seq__73054_73084__$1);
var G__73092 = null;
var G__73093 = (0);
var G__73094 = (0);
seq__73054_73074 = G__73091;
chunk__73055_73075 = G__73092;
count__73056_73076 = G__73093;
i__73057_73077 = G__73094;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_73045 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73038,inst_73044);
var ___$1 = (function (){var statearr_73058 = state_73050;
(statearr_73058[(4)] = cljs.core.rest((state_73050[(4)])));

return statearr_73058;
})();
var state_73050__$1 = (function (){var statearr_73059 = state_73050;
(statearr_73059[(7)] = inst_73043);

return statearr_73059;
})();
var statearr_73060_73095 = state_73050__$1;
(statearr_73060_73095[(2)] = inst_73045);

(statearr_73060_73095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73051 === (3))){
var inst_73048 = (state_73050[(2)]);
var state_73050__$1 = state_73050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73050__$1,inst_73048);
} else {
if((state_val_73051 === (4))){
var inst_73014 = (state_73050[(2)]);
var inst_73015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73016 = [inst_73014];
var inst_73017 = (new cljs.core.PersistentVector(null,1,(5),inst_73015,inst_73016,null));
var inst_73018 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73017);
var inst_73019 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73014) : reject.call(null,inst_73014));
var state_73050__$1 = (function (){var statearr_73062 = state_73050;
(statearr_73062[(8)] = inst_73018);

return statearr_73062;
})();
var statearr_73063_73096 = state_73050__$1;
(statearr_73063_73096[(2)] = inst_73019);

(statearr_73063_73096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73051 === (5))){
var _ = (function (){var statearr_73064 = state_73050;
(statearr_73064[(4)] = cljs.core.rest((state_73050[(4)])));

return statearr_73064;
})();
var state_73050__$1 = state_73050;
var ex73061 = (state_73050__$1[(2)]);
var statearr_73065_73097 = state_73050__$1;
(statearr_73065_73097[(5)] = ex73061);


var statearr_73066_73098 = state_73050__$1;
(statearr_73066_73098[(1)] = (4));

(statearr_73066_73098[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73067 = [null,null,null,null,null,null,null,null,null];
(statearr_73067[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73067[(1)] = (1));

return statearr_73067;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73050){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73050);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73068){var ex__2730__auto__ = e73068;
var statearr_73069_73099 = state_73050;
(statearr_73069_73099[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73050[(4)]))){
var statearr_73070_73100 = state_73050;
(statearr_73070_73100[(1)] = cljs.core.first((state_73050[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73101 = state_73050;
state_73050 = G__73101;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73050){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73071 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73071[(6)] = c__2749__auto__);

return statearr_73071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__73103 = arguments.length;
switch (G__73103) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__73105 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73105,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73105,(1),null);
var cb_STAR_ = (function (header,data){
var G__73108 = cljs.core.clj__GT_js(header);
var G__73109 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__73108,G__73109) : callback.call(null,G__73108,G__73109));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__73110 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73110,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73110,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73163){
var state_val_73164 = (state_73163[(1)]);
if((state_val_73164 === (7))){
var inst_73124 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73125 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73126 = cljs.core.PersistentHashMap.fromArrays(inst_73124,inst_73125);
var inst_73127 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73126);
var inst_73128 = (function(){throw inst_73127})();
var state_73163__$1 = state_73163;
var statearr_73165_73197 = state_73163__$1;
(statearr_73165_73197[(2)] = inst_73128);

(statearr_73165_73197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (1))){
var state_73163__$1 = state_73163;
var statearr_73166_73198 = state_73163__$1;
(statearr_73166_73198[(2)] = null);

(statearr_73166_73198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (4))){
var inst_73113 = (state_73163[(2)]);
var inst_73114 = cljs.core.clj__GT_js(inst_73113);
var inst_73115 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73114) : reject.call(null,inst_73114));
var state_73163__$1 = state_73163;
var statearr_73167_73199 = state_73163__$1;
(statearr_73167_73199[(2)] = inst_73115);

(statearr_73167_73199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (13))){
var inst_73142 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73143 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73144 = cljs.core.PersistentHashMap.fromArrays(inst_73142,inst_73143);
var inst_73145 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_73144);
var inst_73146 = (function(){throw inst_73145})();
var state_73163__$1 = state_73163;
var statearr_73168_73200 = state_73163__$1;
(statearr_73168_73200[(2)] = inst_73146);

(statearr_73168_73200[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (6))){
var state_73163__$1 = state_73163;
var statearr_73169_73201 = state_73163__$1;
(statearr_73169_73201[(2)] = null);

(statearr_73169_73201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (3))){
var inst_73161 = (state_73163[(2)]);
var state_73163__$1 = state_73163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73163__$1,inst_73161);
} else {
if((state_val_73164 === (12))){
var state_73163__$1 = state_73163;
var statearr_73170_73202 = state_73163__$1;
(statearr_73170_73202[(2)] = null);

(statearr_73170_73202[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (2))){
var _ = (function (){var statearr_73171 = state_73163;
(statearr_73171[(4)] = cljs.core.cons((5),(state_73163[(4)])));

return statearr_73171;
})();
var inst_73121 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73163__$1 = state_73163;
if(cljs.core.truth_(inst_73121)){
var statearr_73172_73203 = state_73163__$1;
(statearr_73172_73203[(1)] = (6));

} else {
var statearr_73173_73204 = state_73163__$1;
(statearr_73173_73204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (11))){
var inst_73139 = (state_73163[(2)]);
var state_73163__$1 = (function (){var statearr_73175 = state_73163;
(statearr_73175[(7)] = inst_73139);

return statearr_73175;
})();
if(cljs.core.truth_(password)){
var statearr_73176_73205 = state_73163__$1;
(statearr_73176_73205[(1)] = (12));

} else {
var statearr_73177_73206 = state_73163__$1;
(statearr_73177_73206[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (9))){
var state_73163__$1 = state_73163;
var statearr_73178_73207 = state_73163__$1;
(statearr_73178_73207[(2)] = null);

(statearr_73178_73207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (5))){
var _ = (function (){var statearr_73179 = state_73163;
(statearr_73179[(4)] = cljs.core.rest((state_73163[(4)])));

return statearr_73179;
})();
var state_73163__$1 = state_73163;
var ex73174 = (state_73163__$1[(2)]);
var statearr_73180_73208 = state_73163__$1;
(statearr_73180_73208[(5)] = ex73174);


var statearr_73181_73209 = state_73163__$1;
(statearr_73181_73209[(1)] = (4));

(statearr_73181_73209[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (14))){
var inst_73148 = (state_73163[(2)]);
var inst_73149 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_73150 = fluree.db.util.core.without_nils(inst_73149);
var inst_73151 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73152 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73154 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_73150,inst_73151,null];
var inst_73155 = (new cljs.core.PersistentVector(null,4,(5),inst_73153,inst_73154,null));
var inst_73156 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73152,inst_73155);
var inst_73157 = (function (){var _ = inst_73148;
var data = inst_73150;
var pc = inst_73151;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73182 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73182) : reject.call(null,G__73182));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__73183 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73183) : reject.call(null,G__73183));
} else {
var G__73184 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73184) : resolve.call(null,G__73184));

}
}
});
})();
var inst_73158 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73151,inst_73157);
var _ = (function (){var statearr_73185 = state_73163;
(statearr_73185[(4)] = cljs.core.rest((state_73163[(4)])));

return statearr_73185;
})();
var state_73163__$1 = (function (){var statearr_73186 = state_73163;
(statearr_73186[(8)] = inst_73156);

return statearr_73186;
})();
var statearr_73187_73210 = state_73163__$1;
(statearr_73187_73210[(2)] = inst_73158);

(statearr_73187_73210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (10))){
var inst_73133 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73134 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73135 = cljs.core.PersistentHashMap.fromArrays(inst_73133,inst_73134);
var inst_73136 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_73135);
var inst_73137 = (function(){throw inst_73136})();
var state_73163__$1 = state_73163;
var statearr_73188_73211 = state_73163__$1;
(statearr_73188_73211[(2)] = inst_73137);

(statearr_73188_73211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73164 === (8))){
var inst_73130 = (state_73163[(2)]);
var state_73163__$1 = (function (){var statearr_73189 = state_73163;
(statearr_73189[(9)] = inst_73130);

return statearr_73189;
})();
if(cljs.core.truth_(ledger)){
var statearr_73190_73212 = state_73163__$1;
(statearr_73190_73212[(1)] = (9));

} else {
var statearr_73191_73213 = state_73163__$1;
(statearr_73191_73213[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_73192 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73192[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_73192[(1)] = (1));

return statearr_73192;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_73163){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73163);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73193){var ex__2730__auto__ = e73193;
var statearr_73194_73214 = state_73163;
(statearr_73194_73214[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73163[(4)]))){
var statearr_73195_73215 = state_73163;
(statearr_73195_73215[(1)] = cljs.core.first((state_73163[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73216 = state_73163;
state_73163 = G__73216;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_73163){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_73163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73196 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73196[(6)] = c__2749__auto__);

return statearr_73196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__73218 = arguments.length;
switch (G__73218) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73285){
var state_val_73286 = (state_73285[(1)]);
if((state_val_73286 === (7))){
var inst_73230 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73231 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73232 = cljs.core.PersistentHashMap.fromArrays(inst_73230,inst_73231);
var inst_73233 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73232);
var inst_73234 = (function(){throw inst_73233})();
var state_73285__$1 = state_73285;
var statearr_73287_73329 = state_73285__$1;
(statearr_73287_73329[(2)] = inst_73234);

(statearr_73287_73329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (20))){
var inst_73268 = (state_73285[(2)]);
var inst_73269 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73270 = [ledger,password,user,auth,expire];
var inst_73271 = cljs.core.PersistentHashMap.fromArrays(inst_73269,inst_73270);
var inst_73272 = fluree.db.util.core.without_nils(inst_73271);
var inst_73273 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73274 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73276 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_73272,inst_73273,null];
var inst_73277 = (new cljs.core.PersistentVector(null,4,(5),inst_73275,inst_73276,null));
var inst_73278 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73274,inst_73277);
var inst_73279 = (function (){var _ = inst_73268;
var data = inst_73272;
var pc = inst_73273;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73288 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73288) : reject.call(null,G__73288));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__73289 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73289) : reject.call(null,G__73289));
} else {
fluree.db.connection.add_token(conn,result);

var G__73290 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73290) : resolve.call(null,G__73290));

}
}
});
})();
var inst_73280 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73273,inst_73279);
var _ = (function (){var statearr_73291 = state_73285;
(statearr_73291[(4)] = cljs.core.rest((state_73285[(4)])));

return statearr_73291;
})();
var state_73285__$1 = (function (){var statearr_73292 = state_73285;
(statearr_73292[(7)] = inst_73278);

return statearr_73292;
})();
var statearr_73293_73330 = state_73285__$1;
(statearr_73293_73330[(2)] = inst_73280);

(statearr_73293_73330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (1))){
var state_73285__$1 = state_73285;
var statearr_73294_73331 = state_73285__$1;
(statearr_73294_73331[(2)] = null);

(statearr_73294_73331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (4))){
var inst_73219 = (state_73285[(2)]);
var inst_73220 = cljs.core.clj__GT_js(inst_73219);
var inst_73221 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73220) : reject.call(null,inst_73220));
var state_73285__$1 = state_73285;
var statearr_73295_73332 = state_73285__$1;
(statearr_73295_73332[(2)] = inst_73221);

(statearr_73295_73332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (15))){
var inst_73255 = (state_73285[(8)]);
var state_73285__$1 = state_73285;
var statearr_73296_73333 = state_73285__$1;
(statearr_73296_73333[(2)] = inst_73255);

(statearr_73296_73333[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (13))){
var inst_73248 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73249 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73250 = cljs.core.PersistentHashMap.fromArrays(inst_73248,inst_73249);
var inst_73251 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_73250);
var inst_73252 = (function(){throw inst_73251})();
var state_73285__$1 = state_73285;
var statearr_73297_73334 = state_73285__$1;
(statearr_73297_73334[(2)] = inst_73252);

(statearr_73297_73334[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (6))){
var state_73285__$1 = state_73285;
var statearr_73298_73335 = state_73285__$1;
(statearr_73298_73335[(2)] = null);

(statearr_73298_73335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (17))){
var inst_73259 = (state_73285[(2)]);
var state_73285__$1 = state_73285;
if(cljs.core.truth_(inst_73259)){
var statearr_73299_73336 = state_73285__$1;
(statearr_73299_73336[(1)] = (18));

} else {
var statearr_73300_73337 = state_73285__$1;
(statearr_73300_73337[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (3))){
var inst_73283 = (state_73285[(2)]);
var state_73285__$1 = state_73285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73285__$1,inst_73283);
} else {
if((state_val_73286 === (12))){
var state_73285__$1 = state_73285;
var statearr_73301_73338 = state_73285__$1;
(statearr_73301_73338[(2)] = null);

(statearr_73301_73338[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (2))){
var _ = (function (){var statearr_73302 = state_73285;
(statearr_73302[(4)] = cljs.core.cons((5),(state_73285[(4)])));

return statearr_73302;
})();
var inst_73227 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73285__$1 = state_73285;
if(cljs.core.truth_(inst_73227)){
var statearr_73303_73339 = state_73285__$1;
(statearr_73303_73339[(1)] = (6));

} else {
var statearr_73304_73340 = state_73285__$1;
(statearr_73304_73340[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (19))){
var inst_73262 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73263 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73264 = cljs.core.PersistentHashMap.fromArrays(inst_73262,inst_73263);
var inst_73265 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_73264);
var inst_73266 = (function(){throw inst_73265})();
var state_73285__$1 = state_73285;
var statearr_73305_73341 = state_73285__$1;
(statearr_73305_73341[(2)] = inst_73266);

(statearr_73305_73341[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (11))){
var inst_73245 = (state_73285[(2)]);
var state_73285__$1 = (function (){var statearr_73307 = state_73285;
(statearr_73307[(9)] = inst_73245);

return statearr_73307;
})();
if(cljs.core.truth_(password)){
var statearr_73308_73342 = state_73285__$1;
(statearr_73308_73342[(1)] = (12));

} else {
var statearr_73309_73343 = state_73285__$1;
(statearr_73309_73343[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (9))){
var state_73285__$1 = state_73285;
var statearr_73310_73344 = state_73285__$1;
(statearr_73310_73344[(2)] = null);

(statearr_73310_73344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (5))){
var _ = (function (){var statearr_73311 = state_73285;
(statearr_73311[(4)] = cljs.core.rest((state_73285[(4)])));

return statearr_73311;
})();
var state_73285__$1 = state_73285;
var ex73306 = (state_73285__$1[(2)]);
var statearr_73312_73345 = state_73285__$1;
(statearr_73312_73345[(5)] = ex73306);


var statearr_73313_73346 = state_73285__$1;
(statearr_73313_73346[(1)] = (4));

(statearr_73313_73346[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (14))){
var inst_73255 = (state_73285[(8)]);
var inst_73254 = (state_73285[(2)]);
var inst_73255__$1 = user;
var state_73285__$1 = (function (){var statearr_73314 = state_73285;
(statearr_73314[(10)] = inst_73254);

(statearr_73314[(8)] = inst_73255__$1);

return statearr_73314;
})();
if(cljs.core.truth_(inst_73255__$1)){
var statearr_73315_73347 = state_73285__$1;
(statearr_73315_73347[(1)] = (15));

} else {
var statearr_73316_73348 = state_73285__$1;
(statearr_73316_73348[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (16))){
var state_73285__$1 = state_73285;
var statearr_73317_73349 = state_73285__$1;
(statearr_73317_73349[(2)] = auth);

(statearr_73317_73349[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (10))){
var inst_73239 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73240 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73241 = cljs.core.PersistentHashMap.fromArrays(inst_73239,inst_73240);
var inst_73242 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_73241);
var inst_73243 = (function(){throw inst_73242})();
var state_73285__$1 = state_73285;
var statearr_73318_73350 = state_73285__$1;
(statearr_73318_73350[(2)] = inst_73243);

(statearr_73318_73350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (18))){
var state_73285__$1 = state_73285;
var statearr_73319_73351 = state_73285__$1;
(statearr_73319_73351[(2)] = null);

(statearr_73319_73351[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73286 === (8))){
var inst_73236 = (state_73285[(2)]);
var state_73285__$1 = (function (){var statearr_73320 = state_73285;
(statearr_73320[(11)] = inst_73236);

return statearr_73320;
})();
if(cljs.core.truth_(ledger)){
var statearr_73321_73352 = state_73285__$1;
(statearr_73321_73352[(1)] = (9));

} else {
var statearr_73322_73353 = state_73285__$1;
(statearr_73322_73353[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73323 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73323[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73323[(1)] = (1));

return statearr_73323;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73285){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73285);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73324){var ex__2730__auto__ = e73324;
var statearr_73325_73354 = state_73285;
(statearr_73325_73354[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73285[(4)]))){
var statearr_73326_73355 = state_73285;
(statearr_73326_73355[(1)] = cljs.core.first((state_73285[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73356 = state_73285;
state_73285 = G__73356;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73285){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73327 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73327[(6)] = c__2749__auto__);

return statearr_73327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__73358 = arguments.length;
switch (G__73358) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73393){
var state_val_73394 = (state_73393[(1)]);
if((state_val_73394 === (1))){
var state_73393__$1 = state_73393;
var statearr_73395_73417 = state_73393__$1;
(statearr_73395_73417[(2)] = null);

(statearr_73395_73417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73394 === (2))){
var _ = (function (){var statearr_73396 = state_73393;
(statearr_73396[(4)] = cljs.core.cons((5),(state_73393[(4)])));

return statearr_73396;
})();
var inst_73367 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73393__$1 = state_73393;
if(cljs.core.truth_(inst_73367)){
var statearr_73397_73418 = state_73393__$1;
(statearr_73397_73418[(1)] = (6));

} else {
var statearr_73398_73419 = state_73393__$1;
(statearr_73398_73419[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73394 === (3))){
var inst_73391 = (state_73393[(2)]);
var state_73393__$1 = state_73393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73393__$1,inst_73391);
} else {
if((state_val_73394 === (4))){
var inst_73359 = (state_73393[(2)]);
var inst_73360 = cljs.core.clj__GT_js(inst_73359);
var inst_73361 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73360) : reject.call(null,inst_73360));
var state_73393__$1 = state_73393;
var statearr_73400_73420 = state_73393__$1;
(statearr_73400_73420[(2)] = inst_73361);

(statearr_73400_73420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73394 === (5))){
var _ = (function (){var statearr_73401 = state_73393;
(statearr_73401[(4)] = cljs.core.rest((state_73393[(4)])));

return statearr_73401;
})();
var state_73393__$1 = state_73393;
var ex73399 = (state_73393__$1[(2)]);
var statearr_73402_73421 = state_73393__$1;
(statearr_73402_73421[(5)] = ex73399);


var statearr_73403_73422 = state_73393__$1;
(statearr_73403_73422[(1)] = (4));

(statearr_73403_73422[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73394 === (6))){
var state_73393__$1 = state_73393;
var statearr_73404_73423 = state_73393__$1;
(statearr_73404_73423[(2)] = null);

(statearr_73404_73423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73394 === (7))){
var inst_73370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73371 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73372 = cljs.core.PersistentHashMap.fromArrays(inst_73370,inst_73371);
var inst_73373 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73372);
var inst_73374 = (function(){throw inst_73373})();
var state_73393__$1 = state_73393;
var statearr_73405_73424 = state_73393__$1;
(statearr_73405_73424[(2)] = inst_73374);

(statearr_73405_73424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73394 === (8))){
var inst_73376 = (state_73393[(2)]);
var inst_73377 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73378 = [jwt,expire];
var inst_73379 = cljs.core.PersistentHashMap.fromArrays(inst_73377,inst_73378);
var inst_73380 = fluree.db.util.core.without_nils(inst_73379);
var inst_73381 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73382 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73384 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_73380,inst_73381,null];
var inst_73385 = (new cljs.core.PersistentVector(null,4,(5),inst_73383,inst_73384,null));
var inst_73386 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73382,inst_73385);
var inst_73387 = (function (){var _ = inst_73376;
var data = inst_73380;
var pc = inst_73381;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73406 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73406) : reject.call(null,G__73406));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__73407 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73407) : resolve.call(null,G__73407));

}
});
})();
var inst_73388 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73381,inst_73387);
var _ = (function (){var statearr_73408 = state_73393;
(statearr_73408[(4)] = cljs.core.rest((state_73393[(4)])));

return statearr_73408;
})();
var state_73393__$1 = (function (){var statearr_73409 = state_73393;
(statearr_73409[(7)] = inst_73386);

return statearr_73409;
})();
var statearr_73410_73425 = state_73393__$1;
(statearr_73410_73425[(2)] = inst_73388);

(statearr_73410_73425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73411 = [null,null,null,null,null,null,null,null];
(statearr_73411[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73411[(1)] = (1));

return statearr_73411;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73393){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73393);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73412){var ex__2730__auto__ = e73412;
var statearr_73413_73426 = state_73393;
(statearr_73413_73426[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73393[(4)]))){
var statearr_73414_73427 = state_73393;
(statearr_73414_73427[(1)] = cljs.core.first((state_73393[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73428 = state_73393;
state_73393 = G__73428;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73393){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73415 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73415[(6)] = c__2749__auto__);

return statearr_73415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

