// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__71605_71786 = cljs.core.seq(servers);
var chunk__71606_71787 = null;
var count__71607_71788 = (0);
var i__71608_71789 = (0);
while(true){
if((i__71608_71789 < count__71607_71788)){
var server_71790 = chunk__71606_71787.cljs$core$IIndexed$_nth$arity$2(null,i__71608_71789);
var healthcheck_uri_71791 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71790),"/fdb/health"].join('');
var resp_chan_71792 = fluree.db.util.xhttp.post_json(healthcheck_uri_71791,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71793 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71793,healthcheck_uri_71791,resp_chan_71792,server_71790){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71793,healthcheck_uri_71791,resp_chan_71792,server_71790){
return (function (state_71678){
var state_val_71679 = (state_71678[(1)]);
if((state_val_71679 === (1))){
var state_71678__$1 = state_71678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71678__$1,(2),resp_chan_71792);
} else {
if((state_val_71679 === (2))){
var inst_71664 = (state_71678[(7)]);
var inst_71664__$1 = (state_71678[(2)]);
var inst_71665 = fluree.db.util.core.exception_QMARK_(inst_71664__$1);
var state_71678__$1 = (function (){var statearr_71680 = state_71678;
(statearr_71680[(7)] = inst_71664__$1);

return statearr_71680;
})();
if(inst_71665){
var statearr_71681_71794 = state_71678__$1;
(statearr_71681_71794[(1)] = (3));

} else {
var statearr_71682_71795 = state_71678__$1;
(statearr_71682_71795[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71679 === (3))){
var inst_71664 = (state_71678[(7)]);
var inst_71667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71668 = cljs.core.ex_message(inst_71664);
var inst_71669 = cljs.core.ex_data(inst_71664);
var inst_71670 = ["Server contact error: ",inst_71668,inst_71669];
var inst_71671 = (new cljs.core.PersistentVector(null,3,(5),inst_71667,inst_71670,null));
var inst_71672 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71671);
var state_71678__$1 = state_71678;
var statearr_71683_71796 = state_71678__$1;
(statearr_71683_71796[(2)] = inst_71672);

(statearr_71683_71796[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71679 === (4))){
var inst_71674 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_71790);
var state_71678__$1 = state_71678;
var statearr_71684_71797 = state_71678__$1;
(statearr_71684_71797[(2)] = inst_71674);

(statearr_71684_71797[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71679 === (5))){
var inst_71676 = (state_71678[(2)]);
var state_71678__$1 = state_71678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71678__$1,inst_71676);
} else {
return null;
}
}
}
}
}
});})(seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71793,healthcheck_uri_71791,resp_chan_71792,server_71790))
;
return ((function (seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,switch__2726__auto__,c__2749__auto___71793,healthcheck_uri_71791,resp_chan_71792,server_71790){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71685 = [null,null,null,null,null,null,null,null];
(statearr_71685[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71685[(1)] = (1));

return statearr_71685;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71678){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71678);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71686){var ex__2730__auto__ = e71686;
var statearr_71687_71798 = state_71678;
(statearr_71687_71798[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71678[(4)]))){
var statearr_71688_71799 = state_71678;
(statearr_71688_71799[(1)] = cljs.core.first((state_71678[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71800 = state_71678;
state_71678 = G__71800;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71678){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,switch__2726__auto__,c__2749__auto___71793,healthcheck_uri_71791,resp_chan_71792,server_71790))
})();
var state__2751__auto__ = (function (){var statearr_71689 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71689[(6)] = c__2749__auto___71793);

return statearr_71689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71793,healthcheck_uri_71791,resp_chan_71792,server_71790))
);



var G__71801 = seq__71605_71786;
var G__71802 = chunk__71606_71787;
var G__71803 = count__71607_71788;
var G__71804 = (i__71608_71789 + (1));
seq__71605_71786 = G__71801;
chunk__71606_71787 = G__71802;
count__71607_71788 = G__71803;
i__71608_71789 = G__71804;
continue;
} else {
var temp__5804__auto___71805 = cljs.core.seq(seq__71605_71786);
if(temp__5804__auto___71805){
var seq__71605_71806__$1 = temp__5804__auto___71805;
if(cljs.core.chunked_seq_QMARK_(seq__71605_71806__$1)){
var c__5568__auto___71807 = cljs.core.chunk_first(seq__71605_71806__$1);
var G__71808 = cljs.core.chunk_rest(seq__71605_71806__$1);
var G__71809 = c__5568__auto___71807;
var G__71810 = cljs.core.count(c__5568__auto___71807);
var G__71811 = (0);
seq__71605_71786 = G__71808;
chunk__71606_71787 = G__71809;
count__71607_71788 = G__71810;
i__71608_71789 = G__71811;
continue;
} else {
var server_71812 = cljs.core.first(seq__71605_71806__$1);
var healthcheck_uri_71813 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71812),"/fdb/health"].join('');
var resp_chan_71814 = fluree.db.util.xhttp.post_json(healthcheck_uri_71813,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71815,healthcheck_uri_71813,resp_chan_71814,server_71812,seq__71605_71806__$1,temp__5804__auto___71805){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71815,healthcheck_uri_71813,resp_chan_71814,server_71812,seq__71605_71806__$1,temp__5804__auto___71805){
return (function (state_71705){
var state_val_71706 = (state_71705[(1)]);
if((state_val_71706 === (1))){
var state_71705__$1 = state_71705;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71705__$1,(2),resp_chan_71814);
} else {
if((state_val_71706 === (2))){
var inst_71691 = (state_71705[(7)]);
var inst_71691__$1 = (state_71705[(2)]);
var inst_71692 = fluree.db.util.core.exception_QMARK_(inst_71691__$1);
var state_71705__$1 = (function (){var statearr_71707 = state_71705;
(statearr_71707[(7)] = inst_71691__$1);

return statearr_71707;
})();
if(inst_71692){
var statearr_71708_71816 = state_71705__$1;
(statearr_71708_71816[(1)] = (3));

} else {
var statearr_71709_71817 = state_71705__$1;
(statearr_71709_71817[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71706 === (3))){
var inst_71691 = (state_71705[(7)]);
var inst_71694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71695 = cljs.core.ex_message(inst_71691);
var inst_71696 = cljs.core.ex_data(inst_71691);
var inst_71697 = ["Server contact error: ",inst_71695,inst_71696];
var inst_71698 = (new cljs.core.PersistentVector(null,3,(5),inst_71694,inst_71697,null));
var inst_71699 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71698);
var state_71705__$1 = state_71705;
var statearr_71710_71818 = state_71705__$1;
(statearr_71710_71818[(2)] = inst_71699);

(statearr_71710_71818[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71706 === (4))){
var inst_71701 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_71812);
var state_71705__$1 = state_71705;
var statearr_71711_71819 = state_71705__$1;
(statearr_71711_71819[(2)] = inst_71701);

(statearr_71711_71819[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71706 === (5))){
var inst_71703 = (state_71705[(2)]);
var state_71705__$1 = state_71705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71705__$1,inst_71703);
} else {
return null;
}
}
}
}
}
});})(seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71815,healthcheck_uri_71813,resp_chan_71814,server_71812,seq__71605_71806__$1,temp__5804__auto___71805))
;
return ((function (seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,switch__2726__auto__,c__2749__auto___71815,healthcheck_uri_71813,resp_chan_71814,server_71812,seq__71605_71806__$1,temp__5804__auto___71805){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71712 = [null,null,null,null,null,null,null,null];
(statearr_71712[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71712[(1)] = (1));

return statearr_71712;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71705){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71705);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71713){var ex__2730__auto__ = e71713;
var statearr_71714_71820 = state_71705;
(statearr_71714_71820[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71705[(4)]))){
var statearr_71715_71821 = state_71705;
(statearr_71715_71821[(1)] = cljs.core.first((state_71705[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71822 = state_71705;
state_71705 = G__71822;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71705){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,switch__2726__auto__,c__2749__auto___71815,healthcheck_uri_71813,resp_chan_71814,server_71812,seq__71605_71806__$1,temp__5804__auto___71805))
})();
var state__2751__auto__ = (function (){var statearr_71716 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71716[(6)] = c__2749__auto___71815);

return statearr_71716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__71605_71786,chunk__71606_71787,count__71607_71788,i__71608_71789,c__2749__auto___71815,healthcheck_uri_71813,resp_chan_71814,server_71812,seq__71605_71806__$1,temp__5804__auto___71805))
);



var G__71823 = cljs.core.next(seq__71605_71806__$1);
var G__71824 = null;
var G__71825 = (0);
var G__71826 = (0);
seq__71605_71786 = G__71823;
chunk__71606_71787 = G__71824;
count__71607_71788 = G__71825;
i__71608_71789 = G__71826;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71760){
var state_val_71761 = (state_71760[(1)]);
if((state_val_71761 === (7))){
var inst_71732 = (state_71760[(7)]);
var inst_71739 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71732,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_71760__$1 = state_71760;
if(inst_71739){
var statearr_71762_71827 = state_71760__$1;
(statearr_71762_71827[(1)] = (9));

} else {
var statearr_71763_71828 = state_71760__$1;
(statearr_71763_71828[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (1))){
var inst_71724 = (state_71760[(8)]);
var inst_71725 = (state_71760[(9)]);
var inst_71724__$1 = promise_chan;
var inst_71725__$1 = cljs.core.async.timeout((60000));
var inst_71726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71727 = [inst_71724__$1,inst_71725__$1];
var inst_71728 = (new cljs.core.PersistentVector(null,2,(5),inst_71726,inst_71727,null));
var state_71760__$1 = (function (){var statearr_71764 = state_71760;
(statearr_71764[(8)] = inst_71724__$1);

(statearr_71764[(9)] = inst_71725__$1);

return statearr_71764;
})();
return cljs.core.async.ioc_alts_BANG_(state_71760__$1,(2),inst_71728);
} else {
if((state_val_71761 === (4))){
var inst_71725 = (state_71760[(9)]);
var inst_71732 = (state_71760[(7)]);
var inst_71736 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71732,inst_71725);
var state_71760__$1 = state_71760;
if(inst_71736){
var statearr_71765_71829 = state_71760__$1;
(statearr_71765_71829[(1)] = (6));

} else {
var statearr_71766_71830 = state_71760__$1;
(statearr_71766_71830[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (13))){
var state_71760__$1 = state_71760;
var statearr_71767_71831 = state_71760__$1;
(statearr_71767_71831[(2)] = null);

(statearr_71767_71831[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (6))){
var state_71760__$1 = state_71760;
var statearr_71768_71832 = state_71760__$1;
(statearr_71768_71832[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_71768_71832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (3))){
var state_71760__$1 = state_71760;
var statearr_71769_71833 = state_71760__$1;
(statearr_71769_71833[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_71769_71833[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (12))){
var inst_71750 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_71751 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71752 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_71753 = cljs.core.PersistentHashMap.fromArrays(inst_71751,inst_71752);
var inst_71754 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_71753);
var inst_71755 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_71754);
var state_71760__$1 = (function (){var statearr_71770 = state_71760;
(statearr_71770[(10)] = inst_71750);

return statearr_71770;
})();
var statearr_71771_71834 = state_71760__$1;
(statearr_71771_71834[(2)] = inst_71755);

(statearr_71771_71834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (2))){
var inst_71724 = (state_71760[(8)]);
var inst_71732 = (state_71760[(7)]);
var inst_71730 = (state_71760[(2)]);
var inst_71731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71730,(0),null);
var inst_71732__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71730,(1),null);
var inst_71733 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71732__$1,inst_71724);
var state_71760__$1 = (function (){var statearr_71772 = state_71760;
(statearr_71772[(11)] = inst_71731);

(statearr_71772[(7)] = inst_71732__$1);

return statearr_71772;
})();
if(inst_71733){
var statearr_71773_71835 = state_71760__$1;
(statearr_71773_71835[(1)] = (3));

} else {
var statearr_71774_71836 = state_71760__$1;
(statearr_71774_71836[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (11))){
var inst_71743 = (state_71760[(2)]);
var state_71760__$1 = state_71760;
var statearr_71775_71837 = state_71760__$1;
(statearr_71775_71837[(2)] = inst_71743);

(statearr_71775_71837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (9))){
var inst_71731 = (state_71760[(11)]);
var state_71760__$1 = state_71760;
var statearr_71776_71838 = state_71760__$1;
(statearr_71776_71838[(2)] = inst_71731);

(statearr_71776_71838[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (5))){
var inst_71747 = (state_71760[(2)]);
var inst_71748 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_71747);
var state_71760__$1 = state_71760;
if(inst_71748){
var statearr_71777_71839 = state_71760__$1;
(statearr_71777_71839[(1)] = (12));

} else {
var statearr_71778_71840 = state_71760__$1;
(statearr_71778_71840[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (14))){
var inst_71758 = (state_71760[(2)]);
var state_71760__$1 = state_71760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71760__$1,inst_71758);
} else {
if((state_val_71761 === (10))){
var state_71760__$1 = state_71760;
var statearr_71779_71841 = state_71760__$1;
(statearr_71779_71841[(2)] = null);

(statearr_71779_71841[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71761 === (8))){
var inst_71745 = (state_71760[(2)]);
var state_71760__$1 = state_71760;
var statearr_71780_71842 = state_71760__$1;
(statearr_71780_71842[(2)] = inst_71745);

(statearr_71780_71842[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71781 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71781[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71781[(1)] = (1));

return statearr_71781;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71760){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71760);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71782){var ex__2730__auto__ = e71782;
var statearr_71783_71843 = state_71760;
(statearr_71783_71843[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71760[(4)]))){
var statearr_71784_71844 = state_71760;
(statearr_71784_71844[(1)] = cljs.core.first((state_71760[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71845 = state_71760;
state_71760 = G__71845;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71760){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71785 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71785[(6)] = c__2749__auto__);

return statearr_71785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71889){
var state_val_71890 = (state_71889[(1)]);
if((state_val_71890 === (7))){
var state_71889__$1 = state_71889;
var statearr_71891_71917 = state_71889__$1;
(statearr_71891_71917[(2)] = null);

(statearr_71891_71917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (1))){
var state_71889__$1 = state_71889;
var statearr_71892_71918 = state_71889__$1;
(statearr_71892_71918[(2)] = null);

(statearr_71892_71918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (4))){
var inst_71846 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71893_71919 = state_71889__$1;
(statearr_71893_71919[(2)] = inst_71846);

(statearr_71893_71919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (6))){
var inst_71868 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71889__$1,(9),inst_71868);
} else {
if((state_val_71890 === (3))){
var inst_71887 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71889__$1,inst_71887);
} else {
if((state_val_71890 === (12))){
var inst_71881 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71894_71920 = state_71889__$1;
(statearr_71894_71920[(2)] = inst_71881);

(statearr_71894_71920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (2))){
var inst_71857 = (state_71889[(7)]);
var inst_71862 = (state_71889[(8)]);
var inst_71852 = (state_71889[(9)]);
var _ = (function (){var statearr_71895 = state_71889;
(statearr_71895[(4)] = cljs.core.cons((5),(state_71889[(4)])));

return statearr_71895;
})();
var inst_71852__$1 = cljs.core.random_uuid();
var inst_71853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71854 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_71855 = (new cljs.core.PersistentVector(null,2,(5),inst_71853,inst_71854,null));
var inst_71856 = (function (){var lock_id = inst_71852__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_71857__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_71855,inst_71856);
var inst_71858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71859 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_71860 = (new cljs.core.PersistentVector(null,3,(5),inst_71858,inst_71859,null));
var inst_71861 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71857__$1,inst_71860);
var inst_71862__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71852__$1,inst_71861);
var inst_71863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71864 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71865 = (new cljs.core.PersistentVector(null,3,(5),inst_71863,inst_71864,null));
var inst_71866 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71857__$1,inst_71865);
var state_71889__$1 = (function (){var statearr_71896 = state_71889;
(statearr_71896[(7)] = inst_71857__$1);

(statearr_71896[(8)] = inst_71862__$1);

(statearr_71896[(10)] = inst_71866);

(statearr_71896[(9)] = inst_71852__$1);

return statearr_71896;
})();
if(inst_71862__$1){
var statearr_71897_71921 = state_71889__$1;
(statearr_71897_71921[(1)] = (6));

} else {
var statearr_71898_71922 = state_71889__$1;
(statearr_71898_71922[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (11))){
var inst_71872 = (state_71889[(11)]);
var inst_71866 = (state_71889[(10)]);
var inst_71873 = (state_71889[(12)]);
var inst_71879 = fluree.db.util.xhttp.try_socket(inst_71872,sub_chan,pub_chan,inst_71866,(60000),inst_71873);
var state_71889__$1 = state_71889;
var statearr_71900_71923 = state_71889__$1;
(statearr_71900_71923[(2)] = inst_71879);

(statearr_71900_71923[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (9))){
var inst_71870 = (state_71889[(13)]);
var inst_71857 = (state_71889[(7)]);
var inst_71862 = (state_71889[(8)]);
var inst_71872 = (state_71889[(11)]);
var inst_71866 = (state_71889[(10)]);
var inst_71852 = (state_71889[(9)]);
var inst_71870__$1 = (state_71889[(2)]);
var inst_71871 = clojure.string.replace(inst_71870__$1,"http","ws");
var inst_71872__$1 = [inst_71871,"/fdb/ws"].join('');
var inst_71873 = (function (){var lock_id = inst_71852;
var state = inst_71857;
var have_lock_QMARK_ = inst_71862;
var resp_chan = inst_71866;
var healthy_server = inst_71870__$1;
var ws_url = inst_71872__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_71874 = fluree.db.util.core.exception_QMARK_(inst_71870__$1);
var state_71889__$1 = (function (){var statearr_71901 = state_71889;
(statearr_71901[(13)] = inst_71870__$1);

(statearr_71901[(11)] = inst_71872__$1);

(statearr_71901[(12)] = inst_71873);

return statearr_71901;
})();
if(inst_71874){
var statearr_71902_71924 = state_71889__$1;
(statearr_71902_71924[(1)] = (10));

} else {
var statearr_71903_71925 = state_71889__$1;
(statearr_71903_71925[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (5))){
var _ = (function (){var statearr_71904 = state_71889;
(statearr_71904[(4)] = cljs.core.rest((state_71889[(4)])));

return statearr_71904;
})();
var state_71889__$1 = state_71889;
var ex71899 = (state_71889__$1[(2)]);
var statearr_71905_71926 = state_71889__$1;
(statearr_71905_71926[(5)] = ex71899);


if((ex71899 instanceof Error)){
var statearr_71906_71927 = state_71889__$1;
(statearr_71906_71927[(1)] = (4));

(statearr_71906_71927[(5)] = null);

} else {
throw ex71899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (10))){
var inst_71870 = (state_71889[(13)]);
var inst_71866 = (state_71889[(10)]);
var inst_71876 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_71877 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_71866,inst_71870);
var state_71889__$1 = (function (){var statearr_71907 = state_71889;
(statearr_71907[(14)] = inst_71876);

return statearr_71907;
})();
var statearr_71908_71928 = state_71889__$1;
(statearr_71908_71928[(2)] = inst_71877);

(statearr_71908_71928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (8))){
var inst_71866 = (state_71889[(10)]);
var inst_71884 = (state_71889[(2)]);
var _ = (function (){var statearr_71909 = state_71889;
(statearr_71909[(4)] = cljs.core.rest((state_71889[(4)])));

return statearr_71909;
})();
var state_71889__$1 = (function (){var statearr_71910 = state_71889;
(statearr_71910[(15)] = inst_71884);

return statearr_71910;
})();
var statearr_71911_71929 = state_71889__$1;
(statearr_71911_71929[(2)] = inst_71866);

(statearr_71911_71929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_71912 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71912[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_71912[(1)] = (1));

return statearr_71912;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_71889){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71889);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71913){var ex__2730__auto__ = e71913;
var statearr_71914_71930 = state_71889;
(statearr_71914_71930[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71889[(4)]))){
var statearr_71915_71931 = state_71889;
(statearr_71915_71931[(1)] = cljs.core.first((state_71889[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71932 = state_71889;
state_71889 = G__71932;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_71889){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_71889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71916 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71916[(6)] = c__2749__auto__);

return statearr_71916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k71934,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__71938 = k71934;
var G__71938__$1 = (((G__71938 instanceof cljs.core.Keyword))?G__71938.fqn:null);
switch (G__71938__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k71934,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__71939){
var vec__71940 = p__71939;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71940,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71940,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71933){
var self__ = this;
var G__71933__$1 = this;
return (new cljs.core.RecordIter((0),G__71933__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__71943 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__71943(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71935,other71936){
var self__ = this;
var this71935__$1 = this;
return (((!((other71936 == null)))) && ((((this71935__$1.constructor === other71936.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.id,other71936.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.servers,other71936.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.state,other71936.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.req_chan,other71936.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.sub_chan,other71936.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.pub_chan,other71936.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.group,other71936.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.storage_read,other71936.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.storage_list,other71936.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.storage_write,other71936.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.storage_exists,other71936.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.storage_rename,other71936.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.storage_delete,other71936.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.object_cache,other71936.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.async_cache,other71936.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.parallelism,other71936.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.serializer,other71936.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.default_network,other71936.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.transactor_QMARK_,other71936.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.publish,other71936.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.transact_handler,other71936.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.tx_private_key,other71936.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.tx_key_id,other71936.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.meta,other71936.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.add_listener,other71936.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.remove_listener,other71936.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.close,other71936.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71935__$1.__extmap,other71936.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__71944){
var self__ = this;
var map__71945 = p__71944;
var map__71945__$1 = cljs.core.__destructure_map(map__71945);
var node = map__71945__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71945__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71945__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71945__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__71946 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__71947 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__71948 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__71949 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__71948,G__71949) : self__.async_cache.call(null,G__71948,G__71949));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__71946,G__71947) : self__.async_cache.call(null,G__71946,G__71947));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k71934){
var self__ = this;
var this__5350__auto____$1 = this;
var G__71950 = k71934;
var G__71950__$1 = (((G__71950 instanceof cljs.core.Keyword))?G__71950.fqn:null);
switch (G__71950__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k71934);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__71933){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__71951 = cljs.core.keyword_identical_QMARK_;
var expr__71952 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__71954 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__71955 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71954,G__71955) : pred__71951.call(null,G__71954,G__71955));
})())){
return (new fluree.db.connection.Connection(G__71933,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71956 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__71957 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71956,G__71957) : pred__71951.call(null,G__71956,G__71957));
})())){
return (new fluree.db.connection.Connection(self__.id,G__71933,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71958 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__71959 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71958,G__71959) : pred__71951.call(null,G__71958,G__71959));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71933,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71960 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__71961 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71960,G__71961) : pred__71951.call(null,G__71960,G__71961));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71933,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71962 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__71963 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71962,G__71963) : pred__71951.call(null,G__71962,G__71963));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71933,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71964 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__71965 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71964,G__71965) : pred__71951.call(null,G__71964,G__71965));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71933,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71966 = new cljs.core.Keyword(null,"group","group",582596132);
var G__71967 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71966,G__71967) : pred__71951.call(null,G__71966,G__71967));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71933,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71968 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__71969 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71968,G__71969) : pred__71951.call(null,G__71968,G__71969));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71933,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71970 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__71971 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71970,G__71971) : pred__71951.call(null,G__71970,G__71971));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71933,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71972 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__71973 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71972,G__71973) : pred__71951.call(null,G__71972,G__71973));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__71933,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71974 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__71975 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71974,G__71975) : pred__71951.call(null,G__71974,G__71975));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__71933,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71976 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__71977 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71976,G__71977) : pred__71951.call(null,G__71976,G__71977));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__71933,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71978 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__71979 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71978,G__71979) : pred__71951.call(null,G__71978,G__71979));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__71933,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71980 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__71981 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71980,G__71981) : pred__71951.call(null,G__71980,G__71981));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__71933,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71982 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__71983 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71982,G__71983) : pred__71951.call(null,G__71982,G__71983));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__71933,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71984 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__71985 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71984,G__71985) : pred__71951.call(null,G__71984,G__71985));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__71933,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71986 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__71987 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71986,G__71987) : pred__71951.call(null,G__71986,G__71987));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__71933,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71988 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__71989 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71988,G__71989) : pred__71951.call(null,G__71988,G__71989));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__71933,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71990 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__71991 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71990,G__71991) : pred__71951.call(null,G__71990,G__71991));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__71933,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71992 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__71993 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71992,G__71993) : pred__71951.call(null,G__71992,G__71993));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71933,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71994 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__71995 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71994,G__71995) : pred__71951.call(null,G__71994,G__71995));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71933,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71996 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__71997 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71996,G__71997) : pred__71951.call(null,G__71996,G__71997));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71933,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__71998 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__71999 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__71998,G__71999) : pred__71951.call(null,G__71998,G__71999));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71933,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72000 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__72001 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__72000,G__72001) : pred__71951.call(null,G__72000,G__72001));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71933,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72002 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__72003 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__72002,G__72003) : pred__71951.call(null,G__72002,G__72003));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71933,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72004 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__72005 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__72004,G__72005) : pred__71951.call(null,G__72004,G__72005));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71933,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72006 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__72007 = expr__71952;
return (pred__71951.cljs$core$IFn$_invoke$arity$2 ? pred__71951.cljs$core$IFn$_invoke$arity$2(G__72006,G__72007) : pred__71951.call(null,G__72006,G__72007));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71933,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__71933),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__71933){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71933,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71937){
var extmap__5385__auto__ = (function (){var G__72008 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__71937,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__71937)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__72008);
} else {
return G__72008;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71937),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71937),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__72014 = servers_STAR_;
var vec__72015 = G__72014;
var seq__72016 = cljs.core.seq(vec__72015);
var first__72017 = cljs.core.first(seq__72016);
var seq__72016__$1 = cljs.core.next(seq__72016);
var server = first__72017;
var r = seq__72016__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__72014__$1 = G__72014;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__72021 = G__72014__$1;
var seq__72022 = cljs.core.seq(vec__72021);
var first__72023 = cljs.core.first(seq__72022);
var seq__72022__$1 = cljs.core.next(seq__72022);
var server__$1 = first__72023;
var r__$1 = seq__72022__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__72024 = r__$1;
var G__72025 = is_https_QMARK_;
var G__72026 = result_STAR_;
G__72014__$1 = G__72024;
https_QMARK___$1 = G__72025;
result__$1 = G__72026;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__72027 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__72027 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__72027);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72056){
var state_val_72057 = (state_72056[(1)]);
if((state_val_72057 === (7))){
var inst_72042 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72043 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72044 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72045 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72046 = fluree.db.connection.establish_socket(inst_72042,inst_72043,inst_72044,inst_72045);
var state_72056__$1 = state_72056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72056__$1,(9),inst_72046);
} else {
if((state_val_72057 === (1))){
var state_72056__$1 = state_72056;
var statearr_72058_72077 = state_72056__$1;
(statearr_72058_72077[(2)] = null);

(statearr_72058_72077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72057 === (4))){
var inst_72028 = (state_72056[(2)]);
var state_72056__$1 = state_72056;
var statearr_72059_72078 = state_72056__$1;
(statearr_72059_72078[(2)] = inst_72028);

(statearr_72059_72078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72057 === (6))){
var inst_72039 = (state_72056[(7)]);
var state_72056__$1 = state_72056;
var statearr_72060_72079 = state_72056__$1;
(statearr_72060_72079[(2)] = inst_72039);

(statearr_72060_72079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72057 === (3))){
var inst_72054 = (state_72056[(2)]);
var state_72056__$1 = state_72056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72056__$1,inst_72054);
} else {
if((state_val_72057 === (2))){
var inst_72039 = (state_72056[(7)]);
var _ = (function (){var statearr_72062 = state_72056;
(statearr_72062[(4)] = cljs.core.cons((5),(state_72056[(4)])));

return statearr_72062;
})();
var inst_72034 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_72035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72036 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72037 = [inst_72036,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_72038 = (new cljs.core.PersistentVector(null,3,(5),inst_72035,inst_72037,null));
var inst_72039__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72034,inst_72038);
var state_72056__$1 = (function (){var statearr_72063 = state_72056;
(statearr_72063[(7)] = inst_72039__$1);

return statearr_72063;
})();
if(cljs.core.truth_(inst_72039__$1)){
var statearr_72064_72080 = state_72056__$1;
(statearr_72064_72080[(1)] = (6));

} else {
var statearr_72065_72081 = state_72056__$1;
(statearr_72065_72081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72057 === (9))){
var inst_72048 = (state_72056[(2)]);
var inst_72049 = fluree.db.util.async.throw_err(inst_72048);
var state_72056__$1 = state_72056;
var statearr_72066_72082 = state_72056__$1;
(statearr_72066_72082[(2)] = inst_72049);

(statearr_72066_72082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72057 === (5))){
var _ = (function (){var statearr_72067 = state_72056;
(statearr_72067[(4)] = cljs.core.rest((state_72056[(4)])));

return statearr_72067;
})();
var state_72056__$1 = state_72056;
var ex72061 = (state_72056__$1[(2)]);
var statearr_72068_72083 = state_72056__$1;
(statearr_72068_72083[(5)] = ex72061);


if((ex72061 instanceof Error)){
var statearr_72069_72084 = state_72056__$1;
(statearr_72069_72084[(1)] = (4));

(statearr_72069_72084[(5)] = null);

} else {
throw ex72061;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72057 === (8))){
var inst_72051 = (state_72056[(2)]);
var _ = (function (){var statearr_72070 = state_72056;
(statearr_72070[(4)] = cljs.core.rest((state_72056[(4)])));

return statearr_72070;
})();
var state_72056__$1 = state_72056;
var statearr_72071_72085 = state_72056__$1;
(statearr_72071_72085[(2)] = inst_72051);

(statearr_72071_72085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_72072 = [null,null,null,null,null,null,null,null];
(statearr_72072[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_72072[(1)] = (1));

return statearr_72072;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_72056){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72056);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72073){var ex__2730__auto__ = e72073;
var statearr_72074_72086 = state_72056;
(statearr_72074_72086[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72056[(4)]))){
var statearr_72075_72087 = state_72056;
(statearr_72075_72087[(1)] = cljs.core.first((state_72056[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72088 = state_72056;
state_72056 = G__72088;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_72056){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_72056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72076 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72076[(6)] = c__2749__auto__);

return statearr_72076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e72089){var e = e72089;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__72091){
var map__72092 = p__72091;
var map__72092__$1 = cljs.core.__destructure_map(map__72092);
var conn = map__72092__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72092__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72092__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72092__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72238){
var state_val_72239 = (state_72238[(1)]);
if((state_val_72239 === (7))){
var inst_72234 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
var statearr_72241_72315 = state_72238__$1;
(statearr_72241_72315[(2)] = inst_72234);

(statearr_72241_72315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (20))){
var _ = (function (){var statearr_72242 = state_72238;
(statearr_72242[(4)] = cljs.core.rest((state_72238[(4)])));

return statearr_72242;
})();
var state_72238__$1 = state_72238;
var ex72240 = (state_72238__$1[(2)]);
var statearr_72243_72316 = state_72238__$1;
(statearr_72243_72316[(5)] = ex72240);


var statearr_72244_72317 = state_72238__$1;
(statearr_72244_72317[(1)] = (10));

(statearr_72244_72317[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (27))){
var inst_72195 = (state_72238[(7)]);
var inst_72195__$1 = (state_72238[(2)]);
var inst_72196 = inst_72195__$1 === true;
var state_72238__$1 = (function (){var statearr_72245 = state_72238;
(statearr_72245[(7)] = inst_72195__$1);

return statearr_72245;
})();
if(cljs.core.truth_(inst_72196)){
var statearr_72246_72318 = state_72238__$1;
(statearr_72246_72318[(1)] = (28));

} else {
var statearr_72247_72319 = state_72238__$1;
(statearr_72247_72319[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (1))){
var inst_72093 = (0);
var state_72238__$1 = (function (){var statearr_72248 = state_72238;
(statearr_72248[(8)] = inst_72093);

return statearr_72248;
})();
var statearr_72249_72320 = state_72238__$1;
(statearr_72249_72320[(2)] = null);

(statearr_72249_72320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (24))){
var inst_72185 = (state_72238[(9)]);
var state_72238__$1 = state_72238;
var statearr_72250_72321 = state_72238__$1;
(statearr_72250_72321[(2)] = inst_72185);

(statearr_72250_72321[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (39))){
var inst_72220 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
var statearr_72251_72322 = state_72238__$1;
(statearr_72251_72322[(2)] = inst_72220);

(statearr_72251_72322[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (4))){
var inst_72096 = (state_72238[(10)]);
var inst_72096__$1 = (state_72238[(2)]);
var state_72238__$1 = (function (){var statearr_72252 = state_72238;
(statearr_72252[(10)] = inst_72096__$1);

return statearr_72252;
})();
if(cljs.core.truth_(inst_72096__$1)){
var statearr_72253_72323 = state_72238__$1;
(statearr_72253_72323[(1)] = (5));

} else {
var statearr_72254_72324 = state_72238__$1;
(statearr_72254_72324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (15))){
var inst_72109 = (state_72238[(11)]);
var state_72238__$1 = state_72238;
var statearr_72255_72325 = state_72238__$1;
(statearr_72255_72325[(2)] = inst_72109);

(statearr_72255_72325[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (21))){
var inst_72142 = (state_72238[(12)]);
var inst_72146 = (state_72238[(13)]);
var inst_72147 = (state_72238[(14)]);
var inst_72141 = (state_72238[(15)]);
var inst_72140 = (state_72238[(16)]);
var inst_72096 = (state_72238[(10)]);
var inst_72093 = (state_72238[(8)]);
var inst_72138 = (state_72238[(17)]);
var inst_72143 = (state_72238[(18)]);
var inst_72139 = (state_72238[(19)]);
var inst_72149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72150 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_72146];
var inst_72151 = (new cljs.core.PersistentVector(null,2,(5),inst_72149,inst_72150,null));
var inst_72152 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_72151,inst_72141);
var inst_72179 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_72180 = (function (){var resp_chan = inst_72141;
var timeout = inst_72147;
var c__2749__auto____$1 = inst_72179;
var i = inst_72093;
var data = inst_72140;
var _ = inst_72138;
var req_id = inst_72146;
var vec__72131 = inst_72096;
var operation = inst_72139;
var msg = inst_72096;
var temp__5804__auto__ = inst_72096;
var map__72134 = inst_72143;
var opts = inst_72142;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72177){
var state_val_72178 = (state_72177[(1)]);
if((state_val_72178 === (1))){
var inst_72156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72157 = cljs.core.async.timeout(timeout);
var inst_72158 = [resp_chan,inst_72157];
var inst_72159 = (new cljs.core.PersistentVector(null,2,(5),inst_72156,inst_72158,null));
var state_72177__$1 = state_72177;
return cljs.core.async.ioc_alts_BANG_(state_72177__$1,(2),inst_72159);
} else {
if((state_val_72178 === (2))){
var inst_72162 = (state_72177[(7)]);
var inst_72161 = (state_72177[(2)]);
var inst_72162__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72161,(0),null);
var inst_72163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72161,(1),null);
var inst_72164 = (function (){var vec__72153 = inst_72161;
var resp = inst_72162__$1;
var c = inst_72163;
return (function (p1__72090_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__72090_SHARP_,req_id);
});
})();
var inst_72165 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_72164);
var inst_72166 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72163,resp_chan);
var state_72177__$1 = (function (){var statearr_72256 = state_72177;
(statearr_72256[(7)] = inst_72162__$1);

(statearr_72256[(8)] = inst_72165);

return statearr_72256;
})();
if(inst_72166){
var statearr_72257_72326 = state_72177__$1;
(statearr_72257_72326[(1)] = (3));

} else {
var statearr_72258_72327 = state_72177__$1;
(statearr_72258_72327[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72178 === (3))){
var inst_72162 = (state_72177[(7)]);
var state_72177__$1 = state_72177;
var statearr_72259_72328 = state_72177__$1;
(statearr_72259_72328[(2)] = inst_72162);

(statearr_72259_72328[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72178 === (4))){
var inst_72169 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_72170 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72171 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_72172 = cljs.core.PersistentHashMap.fromArrays(inst_72170,inst_72171);
var inst_72173 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72169,inst_72172);
var state_72177__$1 = state_72177;
var statearr_72260_72329 = state_72177__$1;
(statearr_72260_72329[(2)] = inst_72173);

(statearr_72260_72329[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72178 === (5))){
var inst_72175 = (state_72177[(2)]);
var state_72177__$1 = state_72177;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72177__$1,inst_72175);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_72261 = [null,null,null,null,null,null,null,null,null];
(statearr_72261[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_72261[(1)] = (1));

return statearr_72261;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_72177){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72177);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72262){var ex__2730__auto__ = e72262;
var statearr_72263_72330 = state_72177;
(statearr_72263_72330[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72177[(4)]))){
var statearr_72264_72331 = state_72177;
(statearr_72264_72331[(1)] = cljs.core.first((state_72177[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72332 = state_72177;
state_72177 = G__72332;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_72177){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_72177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72265 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72265[(6)] = c__2749__auto____$1);

return statearr_72265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_72181 = cljs.core.async.impl.dispatch.run(inst_72180);
var state_72238__$1 = (function (){var statearr_72266 = state_72238;
(statearr_72266[(20)] = inst_72152);

(statearr_72266[(21)] = inst_72181);

return statearr_72266;
})();
var statearr_72267_72333 = state_72238__$1;
(statearr_72267_72333[(2)] = inst_72179);

(statearr_72267_72333[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (31))){
var inst_72195 = (state_72238[(7)]);
var inst_72201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72202 = [inst_72195,"Error processing message in producer."];
var inst_72203 = (new cljs.core.PersistentVector(null,2,(5),inst_72201,inst_72202,null));
var inst_72204 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72203);
var state_72238__$1 = state_72238;
var statearr_72268_72334 = state_72238__$1;
(statearr_72268_72334[(2)] = inst_72204);

(statearr_72268_72334[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (32))){
var inst_72195 = (state_72238[(7)]);
var inst_72206 = (inst_72195 == null);
var state_72238__$1 = state_72238;
if(cljs.core.truth_(inst_72206)){
var statearr_72269_72335 = state_72238__$1;
(statearr_72269_72335[(1)] = (34));

} else {
var statearr_72270_72336 = state_72238__$1;
(statearr_72270_72336[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (33))){
var inst_72224 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
var statearr_72271_72337 = state_72238__$1;
(statearr_72271_72337[(2)] = inst_72224);

(statearr_72271_72337[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (13))){
var inst_72109 = (state_72238[(11)]);
var inst_72106 = (state_72238[(2)]);
var inst_72107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72106,(0),null);
var inst_72108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72106,(1),null);
var inst_72109__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72106,(2),null);
var state_72238__$1 = (function (){var statearr_72272 = state_72238;
(statearr_72272[(22)] = inst_72108);

(statearr_72272[(23)] = inst_72107);

(statearr_72272[(11)] = inst_72109__$1);

return statearr_72272;
})();
if(cljs.core.truth_(inst_72109__$1)){
var statearr_72273_72338 = state_72238__$1;
(statearr_72273_72338[(1)] = (14));

} else {
var statearr_72274_72339 = state_72238__$1;
(statearr_72274_72339[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (22))){
var state_72238__$1 = state_72238;
var statearr_72275_72340 = state_72238__$1;
(statearr_72275_72340[(2)] = null);

(statearr_72275_72340[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (36))){
var inst_72222 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
var statearr_72276_72341 = state_72238__$1;
(statearr_72276_72341[(2)] = inst_72222);

(statearr_72276_72341[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (29))){
var inst_72195 = (state_72238[(7)]);
var inst_72199 = fluree.db.util.core.exception_QMARK_(inst_72195);
var state_72238__$1 = state_72238;
if(inst_72199){
var statearr_72277_72342 = state_72238__$1;
(statearr_72277_72342[(1)] = (31));

} else {
var statearr_72278_72343 = state_72238__$1;
(statearr_72278_72343[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (6))){
var state_72238__$1 = state_72238;
var statearr_72279_72344 = state_72238__$1;
(statearr_72279_72344[(2)] = null);

(statearr_72279_72344[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (28))){
var state_72238__$1 = state_72238;
var statearr_72280_72345 = state_72238__$1;
(statearr_72280_72345[(2)] = null);

(statearr_72280_72345[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (25))){
var state_72238__$1 = state_72238;
var statearr_72281_72346 = state_72238__$1;
(statearr_72281_72346[(2)] = fluree.db.connection.default_publish_fn);

(statearr_72281_72346[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (34))){
var inst_72208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72209 = ["Error processing message in producer. Socket closed."];
var inst_72210 = (new cljs.core.PersistentVector(null,1,(5),inst_72208,inst_72209,null));
var inst_72211 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72210);
var state_72238__$1 = state_72238;
var statearr_72282_72347 = state_72238__$1;
(statearr_72282_72347[(2)] = inst_72211);

(statearr_72282_72347[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (17))){
var inst_72098 = (state_72238[(24)]);
var inst_72109 = (state_72238[(11)]);
var inst_72116 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72109,inst_72098);
var state_72238__$1 = state_72238;
var statearr_72283_72348 = state_72238__$1;
(statearr_72283_72348[(2)] = inst_72116);

(statearr_72283_72348[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (3))){
var inst_72236 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72238__$1,inst_72236);
} else {
if((state_val_72239 === (12))){
var state_72238__$1 = state_72238;
var statearr_72284_72349 = state_72238__$1;
(statearr_72284_72349[(2)] = null);

(statearr_72284_72349[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (2))){
var state_72238__$1 = state_72238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72238__$1,(4),req_chan);
} else {
if((state_val_72239 === (23))){
var inst_72185 = (state_72238[(9)]);
var inst_72184 = (state_72238[(2)]);
var inst_72185__$1 = publish;
var state_72238__$1 = (function (){var statearr_72285 = state_72238;
(statearr_72285[(9)] = inst_72185__$1);

(statearr_72285[(25)] = inst_72184);

return statearr_72285;
})();
if(cljs.core.truth_(inst_72185__$1)){
var statearr_72286_72350 = state_72238__$1;
(statearr_72286_72350[(1)] = (24));

} else {
var statearr_72287_72351 = state_72238__$1;
(statearr_72287_72351[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (35))){
var state_72238__$1 = state_72238;
var statearr_72288_72352 = state_72238__$1;
(statearr_72288_72352[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (19))){
var inst_72125 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
var statearr_72290_72353 = state_72238__$1;
(statearr_72290_72353[(2)] = inst_72125);

(statearr_72290_72353[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (11))){
var inst_72096 = (state_72238[(10)]);
var state_72238__$1 = state_72238;
var statearr_72291_72354 = state_72238__$1;
(statearr_72291_72354[(2)] = inst_72096);

(statearr_72291_72354[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (9))){
var inst_72093 = (state_72238[(8)]);
var inst_72229 = (state_72238[(2)]);
var inst_72230 = (inst_72093 + (1));
var inst_72093__$1 = inst_72230;
var state_72238__$1 = (function (){var statearr_72292 = state_72238;
(statearr_72292[(8)] = inst_72093__$1);

(statearr_72292[(26)] = inst_72229);

return statearr_72292;
})();
var statearr_72293_72355 = state_72238__$1;
(statearr_72293_72355[(2)] = null);

(statearr_72293_72355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (5))){
var state_72238__$1 = state_72238;
var statearr_72294_72356 = state_72238__$1;
(statearr_72294_72356[(2)] = null);

(statearr_72294_72356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (14))){
var inst_72109 = (state_72238[(11)]);
var inst_72111 = fluree.db.util.async.channel_QMARK_(inst_72109);
var state_72238__$1 = state_72238;
var statearr_72295_72357 = state_72238__$1;
(statearr_72295_72357[(2)] = inst_72111);

(statearr_72295_72357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (26))){
var inst_72146 = (state_72238[(13)]);
var inst_72140 = (state_72238[(16)]);
var inst_72139 = (state_72238[(19)]);
var inst_72189 = (state_72238[(2)]);
var inst_72190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72191 = [inst_72139,inst_72146,inst_72140];
var inst_72192 = (new cljs.core.PersistentVector(null,3,(5),inst_72190,inst_72191,null));
var inst_72193 = (inst_72189.cljs$core$IFn$_invoke$arity$2 ? inst_72189.cljs$core$IFn$_invoke$arity$2(conn,inst_72192) : inst_72189.call(null,conn,inst_72192));
var state_72238__$1 = state_72238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72238__$1,(27),inst_72193);
} else {
if((state_val_72239 === (16))){
var inst_72114 = (state_72238[(2)]);
var state_72238__$1 = state_72238;
if(cljs.core.truth_(inst_72114)){
var statearr_72296_72358 = state_72238__$1;
(statearr_72296_72358[(1)] = (17));

} else {
var statearr_72297_72359 = state_72238__$1;
(statearr_72297_72359[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (38))){
var state_72238__$1 = state_72238;
var statearr_72298_72360 = state_72238__$1;
(statearr_72298_72360[(2)] = null);

(statearr_72298_72360[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (30))){
var inst_72226 = (state_72238[(2)]);
var _ = (function (){var statearr_72299 = state_72238;
(statearr_72299[(4)] = cljs.core.rest((state_72238[(4)])));

return statearr_72299;
})();
var state_72238__$1 = state_72238;
var statearr_72300_72361 = state_72238__$1;
(statearr_72300_72361[(2)] = inst_72226);

(statearr_72300_72361[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (10))){
var inst_72096 = (state_72238[(10)]);
var inst_72098 = (state_72238[(2)]);
var inst_72102 = cljs.core.sequential_QMARK_(inst_72096);
var state_72238__$1 = (function (){var statearr_72301 = state_72238;
(statearr_72301[(24)] = inst_72098);

return statearr_72301;
})();
if(inst_72102){
var statearr_72302_72362 = state_72238__$1;
(statearr_72302_72362[(1)] = (11));

} else {
var statearr_72303_72363 = state_72238__$1;
(statearr_72303_72363[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (18))){
var inst_72098 = (state_72238[(24)]);
var inst_72096 = (state_72238[(10)]);
var inst_72118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72119 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_72096], 0));
var inst_72120 = ["Error processing ledger request, no valid return channel: ",inst_72119].join('');
var inst_72121 = [inst_72098,inst_72120];
var inst_72122 = (new cljs.core.PersistentVector(null,2,(5),inst_72118,inst_72121,null));
var inst_72123 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72122);
var state_72238__$1 = state_72238;
var statearr_72304_72364 = state_72238__$1;
(statearr_72304_72364[(2)] = inst_72123);

(statearr_72304_72364[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (37))){
var inst_72195 = (state_72238[(7)]);
var inst_72214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72215 = ["Error processing message in producer. Socket closed. Published result",inst_72195];
var inst_72216 = (new cljs.core.PersistentVector(null,2,(5),inst_72214,inst_72215,null));
var inst_72217 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72216);
var state_72238__$1 = state_72238;
var statearr_72305_72365 = state_72238__$1;
(statearr_72305_72365[(2)] = inst_72217);

(statearr_72305_72365[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72239 === (8))){
var inst_72142 = (state_72238[(12)]);
var inst_72141 = (state_72238[(15)]);
var inst_72096 = (state_72238[(10)]);
var inst_72143 = (state_72238[(18)]);
var _ = (function (){var statearr_72306 = state_72238;
(statearr_72306[(4)] = cljs.core.cons((20),(state_72238[(4)])));

return statearr_72306;
})();
var inst_72135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72136 = ["Outgoing message to websocket: ",inst_72096];
var inst_72137 = (new cljs.core.PersistentVector(null,2,(5),inst_72135,inst_72136,null));
var inst_72138 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72137);
var inst_72139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72096,(0),null);
var inst_72140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72096,(1),null);
var inst_72141__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72096,(2),null);
var inst_72142__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72096,(3),null);
var inst_72143__$1 = cljs.core.__destructure_map(inst_72142__$1);
var inst_72144 = cljs.core.random_uuid();
var inst_72145 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72144);
var inst_72146 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72143__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_72145);
var inst_72147 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72143__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_72238__$1 = (function (){var statearr_72307 = state_72238;
(statearr_72307[(12)] = inst_72142__$1);

(statearr_72307[(13)] = inst_72146);

(statearr_72307[(14)] = inst_72147);

(statearr_72307[(15)] = inst_72141__$1);

(statearr_72307[(16)] = inst_72140);

(statearr_72307[(17)] = inst_72138);

(statearr_72307[(18)] = inst_72143__$1);

(statearr_72307[(19)] = inst_72139);

return statearr_72307;
})();
if(cljs.core.truth_(inst_72141__$1)){
var statearr_72308_72366 = state_72238__$1;
(statearr_72308_72366[(1)] = (21));

} else {
var statearr_72309_72367 = state_72238__$1;
(statearr_72309_72367[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_72310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72310[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_72310[(1)] = (1));

return statearr_72310;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_72238){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72238);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72311){var ex__2730__auto__ = e72311;
var statearr_72312_72368 = state_72238;
(statearr_72312_72368[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72238[(4)]))){
var statearr_72313_72369 = state_72238;
(statearr_72313_72369[(1)] = cljs.core.first((state_72238[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72370 = state_72238;
state_72238 = G__72370;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_72238){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_72238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72314 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72314[(6)] = c__2749__auto__);

return statearr_72314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72408){
var state_val_72409 = (state_72408[(1)]);
if((state_val_72409 === (7))){
var inst_72379 = (state_72408[(7)]);
var state_72408__$1 = state_72408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72408__$1,(9),inst_72379);
} else {
if((state_val_72409 === (1))){
var inst_72371 = (1);
var state_72408__$1 = (function (){var statearr_72410 = state_72408;
(statearr_72410[(8)] = inst_72371);

return statearr_72410;
})();
var statearr_72411_72434 = state_72408__$1;
(statearr_72411_72434[(2)] = null);

(statearr_72411_72434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (4))){
var inst_72376 = (state_72408[(2)]);
var inst_72377 = fluree.db.connection.get_socket(conn);
var state_72408__$1 = (function (){var statearr_72412 = state_72408;
(statearr_72412[(9)] = inst_72376);

return statearr_72412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72408__$1,(5),inst_72377);
} else {
if((state_val_72409 === (15))){
var inst_72404 = (state_72408[(2)]);
var state_72408__$1 = state_72408;
var statearr_72413_72435 = state_72408__$1;
(statearr_72413_72435[(2)] = inst_72404);

(statearr_72413_72435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (13))){
var inst_72371 = (state_72408[(8)]);
var inst_72386 = (state_72408[(10)]);
var inst_72394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72395 = [inst_72386,"Cannot establish connection to a healthy server, backing off:",inst_72371,"s."];
var inst_72396 = (new cljs.core.PersistentVector(null,4,(5),inst_72394,inst_72395,null));
var inst_72397 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72396);
var inst_72398 = ((2) * inst_72371);
var inst_72399 = ((60) * (2));
var inst_72400 = ((inst_72398 < inst_72399) ? inst_72398 : inst_72399);
var inst_72371__$1 = inst_72400;
var state_72408__$1 = (function (){var statearr_72414 = state_72408;
(statearr_72414[(11)] = inst_72397);

(statearr_72414[(8)] = inst_72371__$1);

return statearr_72414;
})();
var statearr_72415_72436 = state_72408__$1;
(statearr_72415_72436[(2)] = null);

(statearr_72415_72436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (6))){
var inst_72379 = (state_72408[(7)]);
var state_72408__$1 = state_72408;
var statearr_72416_72437 = state_72408__$1;
(statearr_72416_72437[(2)] = inst_72379);

(statearr_72416_72437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (3))){
var inst_72406 = (state_72408[(2)]);
var state_72408__$1 = state_72408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72408__$1,inst_72406);
} else {
if((state_val_72409 === (12))){
var inst_72392 = (state_72408[(2)]);
var state_72408__$1 = state_72408;
if(cljs.core.truth_(inst_72392)){
var statearr_72417_72438 = state_72408__$1;
(statearr_72417_72438[(1)] = (13));

} else {
var statearr_72418_72439 = state_72408__$1;
(statearr_72418_72439[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (2))){
var inst_72371 = (state_72408[(8)]);
var inst_72373 = (inst_72371 * (1000));
var inst_72374 = cljs.core.async.timeout(inst_72373);
var state_72408__$1 = state_72408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72408__$1,(4),inst_72374);
} else {
if((state_val_72409 === (11))){
var inst_72386 = (state_72408[(10)]);
var inst_72390 = fluree.db.util.core.exception_QMARK_(inst_72386);
var state_72408__$1 = state_72408;
var statearr_72419_72440 = state_72408__$1;
(statearr_72419_72440[(2)] = inst_72390);

(statearr_72419_72440[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (9))){
var inst_72384 = (state_72408[(2)]);
var state_72408__$1 = state_72408;
var statearr_72420_72441 = state_72408__$1;
(statearr_72420_72441[(2)] = inst_72384);

(statearr_72420_72441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (5))){
var inst_72379 = (state_72408[(7)]);
var inst_72379__$1 = (state_72408[(2)]);
var inst_72380 = fluree.db.util.core.exception_QMARK_(inst_72379__$1);
var state_72408__$1 = (function (){var statearr_72421 = state_72408;
(statearr_72421[(7)] = inst_72379__$1);

return statearr_72421;
})();
if(inst_72380){
var statearr_72422_72442 = state_72408__$1;
(statearr_72422_72442[(1)] = (6));

} else {
var statearr_72423_72443 = state_72408__$1;
(statearr_72423_72443[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (14))){
var inst_72386 = (state_72408[(10)]);
var state_72408__$1 = state_72408;
var statearr_72424_72444 = state_72408__$1;
(statearr_72424_72444[(2)] = inst_72386);

(statearr_72424_72444[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (10))){
var inst_72387 = (state_72408[(12)]);
var state_72408__$1 = state_72408;
var statearr_72425_72445 = state_72408__$1;
(statearr_72425_72445[(2)] = inst_72387);

(statearr_72425_72445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72409 === (8))){
var inst_72387 = (state_72408[(12)]);
var inst_72386 = (state_72408[(10)]);
var inst_72386__$1 = (state_72408[(2)]);
var inst_72387__$1 = (inst_72386__$1 == null);
var state_72408__$1 = (function (){var statearr_72426 = state_72408;
(statearr_72426[(12)] = inst_72387__$1);

(statearr_72426[(10)] = inst_72386__$1);

return statearr_72426;
})();
if(cljs.core.truth_(inst_72387__$1)){
var statearr_72427_72446 = state_72408__$1;
(statearr_72427_72446[(1)] = (10));

} else {
var statearr_72428_72447 = state_72408__$1;
(statearr_72428_72447[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0 = (function (){
var statearr_72429 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72429[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__);

(statearr_72429[(1)] = (1));

return statearr_72429;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1 = (function (state_72408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72430){var ex__2730__auto__ = e72430;
var statearr_72431_72448 = state_72408;
(statearr_72431_72448[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72408[(4)]))){
var statearr_72432_72449 = state_72408;
(statearr_72432_72449[(1)] = cljs.core.first((state_72408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72450 = state_72408;
state_72408 = G__72450;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = function(state_72408){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1.call(this,state_72408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72433 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72433[(6)] = c__2749__auto__);

return statearr_72433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__72451){
var map__72452 = p__72451;
var map__72452__$1 = cljs.core.__destructure_map(map__72452);
var conn = map__72452__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72452__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72452__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72452__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72452__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72563){
var state_val_72564 = (state_72563[(1)]);
if((state_val_72564 === (7))){
var inst_72559 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72565_72621 = state_72563__$1;
(statearr_72565_72621[(2)] = inst_72559);

(statearr_72565_72621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (20))){
var inst_72510 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72566_72622 = state_72563__$1;
(statearr_72566_72622[(2)] = inst_72510);

(statearr_72566_72622[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (27))){
var inst_72528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72529 = ["Connection closed."];
var inst_72530 = (new cljs.core.PersistentVector(null,1,(5),inst_72528,inst_72529,null));
var inst_72531 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_72530);
var state_72563__$1 = state_72563;
var statearr_72567_72623 = state_72563__$1;
(statearr_72567_72623[(2)] = inst_72531);

(statearr_72567_72623[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (1))){
var inst_72453 = (0);
var state_72563__$1 = (function (){var statearr_72568 = state_72563;
(statearr_72568[(7)] = inst_72453);

return statearr_72568;
})();
var statearr_72569_72624 = state_72563__$1;
(statearr_72569_72624[(2)] = null);

(statearr_72569_72624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (24))){
var inst_72497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72498 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_72499 = [keep_alive_fn];
var inst_72500 = cljs.core.PersistentHashMap.fromArrays(inst_72498,inst_72499);
var inst_72501 = ["Unsupported callback registered",inst_72500];
var inst_72502 = (new cljs.core.PersistentVector(null,2,(5),inst_72497,inst_72501,null));
var inst_72503 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72502);
var state_72563__$1 = state_72563;
var statearr_72570_72625 = state_72563__$1;
(statearr_72570_72625[(2)] = inst_72503);

(statearr_72570_72625[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (4))){
var inst_72458 = (state_72563[(8)]);
var inst_72463 = (state_72563[(2)]);
var inst_72464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72463,(0),null);
var inst_72465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72463,(1),null);
var inst_72466 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72465,inst_72458);
var state_72563__$1 = (function (){var statearr_72571 = state_72563;
(statearr_72571[(9)] = inst_72464);

return statearr_72571;
})();
if(inst_72466){
var statearr_72572_72626 = state_72563__$1;
(statearr_72572_72626[(1)] = (5));

} else {
var statearr_72573_72627 = state_72563__$1;
(statearr_72573_72627[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (15))){
var inst_72483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72484 = ["No keep-alive callback is registered"];
var inst_72485 = (new cljs.core.PersistentVector(null,1,(5),inst_72483,inst_72484,null));
var inst_72486 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72485);
var state_72563__$1 = state_72563;
var statearr_72574_72628 = state_72563__$1;
(statearr_72574_72628[(2)] = inst_72486);

(statearr_72574_72628[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (21))){
var inst_72494 = cljs.core.eval(keep_alive_fn);
var state_72563__$1 = state_72563;
var statearr_72575_72629 = state_72563__$1;
(statearr_72575_72629[(2)] = inst_72494);

(statearr_72575_72629[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (31))){
var state_72563__$1 = state_72563;
var statearr_72576_72630 = state_72563__$1;
(statearr_72576_72630[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (32))){
var inst_72555 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72578_72631 = state_72563__$1;
(statearr_72578_72631[(2)] = inst_72555);

(statearr_72578_72631[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (33))){
var inst_72464 = (state_72563[(9)]);
var inst_72542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72543 = fluree.db.util.json.parse(inst_72464);
var inst_72544 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_72543], 0));
var inst_72545 = ["Received message:",inst_72544];
var inst_72546 = (new cljs.core.PersistentVector(null,2,(5),inst_72542,inst_72545,null));
var inst_72547 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72546);
var inst_72548 = fluree.db.util.json.parse(inst_72464);
var inst_72549 = fluree.db.conn_events.process_events(conn,inst_72548);
var inst_72453 = (0);
var state_72563__$1 = (function (){var statearr_72579 = state_72563;
(statearr_72579[(7)] = inst_72453);

(statearr_72579[(10)] = inst_72549);

(statearr_72579[(11)] = inst_72547);

return statearr_72579;
})();
var statearr_72580_72632 = state_72563__$1;
(statearr_72580_72632[(2)] = null);

(statearr_72580_72632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (13))){
var inst_72518 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72581_72633 = state_72563__$1;
(statearr_72581_72633[(2)] = inst_72518);

(statearr_72581_72633[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (22))){
var state_72563__$1 = state_72563;
var statearr_72582_72634 = state_72563__$1;
(statearr_72582_72634[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (29))){
var inst_72557 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72584_72635 = state_72563__$1;
(statearr_72584_72635[(2)] = inst_72557);

(statearr_72584_72635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (6))){
var inst_72464 = (state_72563[(9)]);
var inst_72526 = (inst_72464 == null);
var state_72563__$1 = state_72563;
if(cljs.core.truth_(inst_72526)){
var statearr_72585_72636 = state_72563__$1;
(statearr_72585_72636[(1)] = (27));

} else {
var statearr_72586_72637 = state_72563__$1;
(statearr_72586_72637[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (28))){
var inst_72464 = (state_72563[(9)]);
var inst_72533 = fluree.db.util.core.exception_QMARK_(inst_72464);
var state_72563__$1 = state_72563;
if(inst_72533){
var statearr_72587_72638 = state_72563__$1;
(statearr_72587_72638[(1)] = (30));

} else {
var statearr_72588_72639 = state_72563__$1;
(statearr_72588_72639[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (25))){
var state_72563__$1 = state_72563;
var statearr_72589_72640 = state_72563__$1;
(statearr_72589_72640[(2)] = null);

(statearr_72589_72640[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (34))){
var state_72563__$1 = state_72563;
var statearr_72590_72641 = state_72563__$1;
(statearr_72590_72641[(2)] = null);

(statearr_72590_72641[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (17))){
var inst_72512 = (state_72563[(2)]);
var inst_72513 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72514 = fluree.db.connection.close_websocket(inst_72513);
var inst_72515 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72516 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_72515);
var state_72563__$1 = (function (){var statearr_72591 = state_72563;
(statearr_72591[(12)] = inst_72514);

(statearr_72591[(13)] = inst_72512);

return statearr_72591;
})();
var statearr_72592_72642 = state_72563__$1;
(statearr_72592_72642[(2)] = inst_72516);

(statearr_72592_72642[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (3))){
var inst_72561 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72563__$1,inst_72561);
} else {
if((state_val_72564 === (12))){
var inst_72476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72477 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_72478 = (new cljs.core.PersistentVector(null,1,(5),inst_72476,inst_72477,null));
var inst_72479 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72478);
var inst_72480 = keep_alive_fn;
var inst_72481 = (keep_alive_fn == null);
var state_72563__$1 = (function (){var statearr_72593 = state_72563;
(statearr_72593[(14)] = inst_72479);

(statearr_72593[(15)] = inst_72480);

return statearr_72593;
})();
if(cljs.core.truth_(inst_72481)){
var statearr_72594_72643 = state_72563__$1;
(statearr_72594_72643[(1)] = (15));

} else {
var statearr_72595_72644 = state_72563__$1;
(statearr_72595_72644[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (2))){
var inst_72458 = (state_72563[(8)]);
var inst_72458__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_72459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72460 = [sub_chan,inst_72458__$1];
var inst_72461 = (new cljs.core.PersistentVector(null,2,(5),inst_72459,inst_72460,null));
var state_72563__$1 = (function (){var statearr_72596 = state_72563;
(statearr_72596[(8)] = inst_72458__$1);

return statearr_72596;
})();
return cljs.core.async.ioc_alts_BANG_(state_72563__$1,(4),inst_72461);
} else {
if((state_val_72564 === (23))){
var inst_72508 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72597_72645 = state_72563__$1;
(statearr_72597_72645[(2)] = inst_72508);

(statearr_72597_72645[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (35))){
var inst_72553 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72598_72646 = state_72563__$1;
(statearr_72598_72646[(2)] = inst_72553);

(statearr_72598_72646[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (19))){
var inst_72492 = typeof keep_alive_fn === 'string';
var state_72563__$1 = state_72563;
if(cljs.core.truth_(inst_72492)){
var statearr_72599_72647 = state_72563__$1;
(statearr_72599_72647[(1)] = (21));

} else {
var statearr_72600_72648 = state_72563__$1;
(statearr_72600_72648[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (11))){
var inst_72471 = fluree.db.connection.reconnect_conn(conn);
var state_72563__$1 = state_72563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72563__$1,(14),inst_72471);
} else {
if((state_val_72564 === (9))){
var inst_72453 = (state_72563[(7)]);
var inst_72520 = fluree.db.connection.ping_transactor(req_chan);
var inst_72521 = (inst_72453 + (1));
var inst_72453__$1 = inst_72521;
var state_72563__$1 = (function (){var statearr_72601 = state_72563;
(statearr_72601[(7)] = inst_72453__$1);

(statearr_72601[(16)] = inst_72520);

return statearr_72601;
})();
var statearr_72602_72649 = state_72563__$1;
(statearr_72602_72649[(2)] = null);

(statearr_72602_72649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (5))){
var inst_72453 = (state_72563[(7)]);
var inst_72468 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_72453);
var state_72563__$1 = state_72563;
if(inst_72468){
var statearr_72603_72650 = state_72563__$1;
(statearr_72603_72650[(1)] = (8));

} else {
var statearr_72604_72651 = state_72563__$1;
(statearr_72604_72651[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (14))){
var inst_72473 = (state_72563[(2)]);
var inst_72453 = (0);
var state_72563__$1 = (function (){var statearr_72605 = state_72563;
(statearr_72605[(7)] = inst_72453);

(statearr_72605[(17)] = inst_72473);

return statearr_72605;
})();
var statearr_72606_72652 = state_72563__$1;
(statearr_72606_72652[(2)] = null);

(statearr_72606_72652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (26))){
var inst_72506 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72607_72653 = state_72563__$1;
(statearr_72607_72653[(2)] = inst_72506);

(statearr_72607_72653[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (16))){
var inst_72488 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_72563__$1 = state_72563;
if(inst_72488){
var statearr_72608_72654 = state_72563__$1;
(statearr_72608_72654[(1)] = (18));

} else {
var statearr_72609_72655 = state_72563__$1;
(statearr_72609_72655[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (30))){
var inst_72464 = (state_72563[(9)]);
var inst_72535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72536 = [inst_72464];
var inst_72537 = (new cljs.core.PersistentVector(null,1,(5),inst_72535,inst_72536,null));
var inst_72538 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72537);
var inst_72453 = (0);
var state_72563__$1 = (function (){var statearr_72610 = state_72563;
(statearr_72610[(7)] = inst_72453);

(statearr_72610[(18)] = inst_72538);

return statearr_72610;
})();
var statearr_72611_72656 = state_72563__$1;
(statearr_72611_72656[(2)] = null);

(statearr_72611_72656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (10))){
var inst_72524 = (state_72563[(2)]);
var state_72563__$1 = state_72563;
var statearr_72612_72657 = state_72563__$1;
(statearr_72612_72657[(2)] = inst_72524);

(statearr_72612_72657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (18))){
var inst_72490 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_72563__$1 = state_72563;
var statearr_72613_72658 = state_72563__$1;
(statearr_72613_72658[(2)] = inst_72490);

(statearr_72613_72658[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72564 === (8))){
var state_72563__$1 = state_72563;
if(cljs.core.truth_(keep_alive)){
var statearr_72614_72659 = state_72563__$1;
(statearr_72614_72659[(1)] = (11));

} else {
var statearr_72615_72660 = state_72563__$1;
(statearr_72615_72660[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_72616 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72616[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_72616[(1)] = (1));

return statearr_72616;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_72563){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72563);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72617){var ex__2730__auto__ = e72617;
var statearr_72618_72661 = state_72563;
(statearr_72618_72661[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72563[(4)]))){
var statearr_72619_72662 = state_72563;
(statearr_72619_72662[(1)] = cljs.core.first((state_72563[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72663 = state_72563;
state_72563 = G__72663;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_72563){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_72563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72620 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72620[(6)] = c__2749__auto__);

return statearr_72620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__72665 = arguments.length;
switch (G__72665) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__72666 = opts;
var map__72666__$1 = cljs.core.__destructure_map(map__72666);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72666__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72666__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72718){
var state_val_72719 = (state_72718[(1)]);
if((state_val_72719 === (7))){
var inst_72676 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_72677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72678 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72679 = (new cljs.core.PersistentVector(null,2,(5),inst_72677,inst_72678,null));
var inst_72680 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72676,inst_72679);
var state_72718__$1 = state_72718;
var statearr_72720_72751 = state_72718__$1;
(statearr_72720_72751[(2)] = inst_72680);

(statearr_72720_72751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (1))){
var state_72718__$1 = state_72718;
var statearr_72721_72752 = state_72718__$1;
(statearr_72721_72752[(2)] = null);

(statearr_72721_72752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (4))){
var inst_72667 = (state_72718[(2)]);
var state_72718__$1 = state_72718;
var statearr_72722_72753 = state_72718__$1;
(statearr_72722_72753[(2)] = inst_72667);

(statearr_72722_72753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (15))){
var inst_72687 = (state_72718[(7)]);
var inst_72706 = (state_72718[(2)]);
var inst_72707 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_72708 = [(5000),inst_72706,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_72709 = cljs.core.PersistentHashMap.fromArrays(inst_72707,inst_72708);
var inst_72710 = fluree.db.util.xhttp.get(inst_72687,inst_72709);
var state_72718__$1 = state_72718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72718__$1,(16),inst_72710);
} else {
if((state_val_72719 === (13))){
var inst_72697 = (state_72718[(8)]);
var inst_72687 = (state_72718[(7)]);
var inst_72699 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_72700 = [inst_72697];
var inst_72701 = cljs.core.PersistentHashMap.fromArrays(inst_72699,inst_72700);
var inst_72702 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_72687,inst_72701,private$);
var inst_72703 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_72702);
var state_72718__$1 = state_72718;
var statearr_72723_72754 = state_72718__$1;
(statearr_72723_72754[(2)] = inst_72703);

(statearr_72723_72754[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (6))){
var inst_72673 = (state_72718[(9)]);
var state_72718__$1 = state_72718;
var statearr_72724_72755 = state_72718__$1;
(statearr_72724_72755[(2)] = inst_72673);

(statearr_72724_72755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (3))){
var inst_72716 = (state_72718[(2)]);
var state_72718__$1 = state_72718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72718__$1,inst_72716);
} else {
if((state_val_72719 === (12))){
var inst_72697 = (state_72718[(2)]);
var state_72718__$1 = (function (){var statearr_72725 = state_72718;
(statearr_72725[(8)] = inst_72697);

return statearr_72725;
})();
if(cljs.core.truth_(private$)){
var statearr_72726_72756 = state_72718__$1;
(statearr_72726_72756[(1)] = (13));

} else {
var statearr_72727_72757 = state_72718__$1;
(statearr_72727_72757[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (2))){
var inst_72673 = (state_72718[(9)]);
var _ = (function (){var statearr_72728 = state_72718;
(statearr_72728[(4)] = cljs.core.cons((5),(state_72718[(4)])));

return statearr_72728;
})();
var inst_72673__$1 = jwt;
var state_72718__$1 = (function (){var statearr_72729 = state_72718;
(statearr_72729[(9)] = inst_72673__$1);

return statearr_72729;
})();
if(cljs.core.truth_(inst_72673__$1)){
var statearr_72730_72758 = state_72718__$1;
(statearr_72730_72758[(1)] = (6));

} else {
var statearr_72731_72759 = state_72718__$1;
(statearr_72731_72759[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (11))){
var inst_72691 = (state_72718[(10)]);
var state_72718__$1 = state_72718;
var statearr_72733_72760 = state_72718__$1;
(statearr_72733_72760[(2)] = inst_72691);

(statearr_72733_72760[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (9))){
var inst_72682 = (state_72718[(11)]);
var inst_72683 = (state_72718[(12)]);
var inst_72686 = (state_72718[(2)]);
var inst_72687 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72686),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72683)].join('');
var inst_72689 = ["Accept"];
var inst_72690 = ["application/json"];
var inst_72691 = cljs.core.PersistentHashMap.fromArrays(inst_72689,inst_72690);
var state_72718__$1 = (function (){var statearr_72734 = state_72718;
(statearr_72734[(10)] = inst_72691);

(statearr_72734[(7)] = inst_72687);

return statearr_72734;
})();
if(cljs.core.truth_(inst_72682)){
var statearr_72735_72761 = state_72718__$1;
(statearr_72735_72761[(1)] = (10));

} else {
var statearr_72736_72762 = state_72718__$1;
(statearr_72736_72762[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (5))){
var _ = (function (){var statearr_72737 = state_72718;
(statearr_72737[(4)] = cljs.core.rest((state_72718[(4)])));

return statearr_72737;
})();
var state_72718__$1 = state_72718;
var ex72732 = (state_72718__$1[(2)]);
var statearr_72738_72763 = state_72718__$1;
(statearr_72738_72763[(5)] = ex72732);


if((ex72732 instanceof Error)){
var statearr_72739_72764 = state_72718__$1;
(statearr_72739_72764[(1)] = (4));

(statearr_72739_72764[(5)] = null);

} else {
throw ex72732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (14))){
var inst_72697 = (state_72718[(8)]);
var state_72718__$1 = state_72718;
var statearr_72740_72765 = state_72718__$1;
(statearr_72740_72765[(2)] = inst_72697);

(statearr_72740_72765[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (16))){
var inst_72712 = (state_72718[(2)]);
var inst_72713 = fluree.db.util.async.throw_err(inst_72712);
var _ = (function (){var statearr_72741 = state_72718;
(statearr_72741[(4)] = cljs.core.rest((state_72718[(4)])));

return statearr_72741;
})();
var state_72718__$1 = state_72718;
var statearr_72742_72766 = state_72718__$1;
(statearr_72742_72766[(2)] = inst_72713);

(statearr_72742_72766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (10))){
var inst_72682 = (state_72718[(11)]);
var inst_72691 = (state_72718[(10)]);
var inst_72693 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72682)].join('');
var inst_72694 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_72691,"Authorization",inst_72693);
var state_72718__$1 = state_72718;
var statearr_72743_72767 = state_72718__$1;
(statearr_72743_72767[(2)] = inst_72694);

(statearr_72743_72767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (8))){
var inst_72682 = (state_72718[(2)]);
var inst_72683 = clojure.string.replace(k,"_","/");
var inst_72684 = fluree.db.connection.get_server(conn_id,servers);
var state_72718__$1 = (function (){var statearr_72744 = state_72718;
(statearr_72744[(11)] = inst_72682);

(statearr_72744[(12)] = inst_72683);

return statearr_72744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72718__$1,(9),inst_72684);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_72745 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72745[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_72745[(1)] = (1));

return statearr_72745;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_72718){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72718);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72746){var ex__2730__auto__ = e72746;
var statearr_72747_72768 = state_72718;
(statearr_72747_72768[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72718[(4)]))){
var statearr_72748_72769 = state_72718;
(statearr_72748_72769[(1)] = cljs.core.first((state_72718[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72770 = state_72718;
state_72718 = G__72770;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_72718){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_72718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72749 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72749[(6)] = c__2749__auto__);

return statearr_72749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___72795 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___72795)){
var v_72796 = temp__5802__auto___72795;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_72796);
} else {
var c__2749__auto___72797 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72782){
var state_val_72783 = (state_72782[(1)]);
if((state_val_72783 === (1))){
var inst_72771 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_72782__$1 = state_72782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72782__$1,(2),inst_72771);
} else {
if((state_val_72783 === (2))){
var inst_72773 = (state_72782[(7)]);
var inst_72773__$1 = (state_72782[(2)]);
var inst_72774 = fluree.db.util.core.exception_QMARK_(inst_72773__$1);
var state_72782__$1 = (function (){var statearr_72784 = state_72782;
(statearr_72784[(7)] = inst_72773__$1);

return statearr_72784;
})();
if(inst_72774){
var statearr_72785_72798 = state_72782__$1;
(statearr_72785_72798[(1)] = (3));

} else {
var statearr_72786_72799 = state_72782__$1;
(statearr_72786_72799[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (3))){
var state_72782__$1 = state_72782;
var statearr_72787_72800 = state_72782__$1;
(statearr_72787_72800[(2)] = null);

(statearr_72787_72800[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (4))){
var inst_72773 = (state_72782[(7)]);
var inst_72777 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_72773);
var state_72782__$1 = state_72782;
var statearr_72788_72801 = state_72782__$1;
(statearr_72788_72801[(2)] = inst_72777);

(statearr_72788_72801[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (5))){
var inst_72773 = (state_72782[(7)]);
var inst_72779 = (state_72782[(2)]);
var inst_72780 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_72773);
var state_72782__$1 = (function (){var statearr_72789 = state_72782;
(statearr_72789[(8)] = inst_72779);

return statearr_72789;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72782__$1,inst_72780);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_72790 = [null,null,null,null,null,null,null,null,null];
(statearr_72790[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__);

(statearr_72790[(1)] = (1));

return statearr_72790;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1 = (function (state_72782){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72782);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72791){var ex__2730__auto__ = e72791;
var statearr_72792_72802 = state_72782;
(statearr_72792_72802[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72782[(4)]))){
var statearr_72793_72803 = state_72782;
(statearr_72793_72803[(1)] = cljs.core.first((state_72782[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72804 = state_72782;
state_72782 = G__72804;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = function(state_72782){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1.call(this,state_72782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72794 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72794[(6)] = c__2749__auto___72797);

return statearr_72794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__72805_SHARP_){
if(cljs.core.truth_(p1__72805_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__72806_SHARP_){
var or__5045__auto__ = p1__72806_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e72807){var e = e72807;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__72808 = opts;
var map__72808__$1 = cljs.core.__destructure_map(map__72808);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72808__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72808__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__72809_72810 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__72809_72810.cljs$core$IFn$_invoke$arity$0 ? fexpr__72809_72810.cljs$core$IFn$_invoke$arity$0() : fexpr__72809_72810.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___72854 = arguments.length;
var i__5770__auto___72855 = (0);
while(true){
if((i__5770__auto___72855 < len__5769__auto___72854)){
args__5775__auto__.push((arguments[i__5770__auto___72855]));

var G__72856 = (i__5770__auto___72855 + (1));
i__5770__auto___72855 = G__72856;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__72813){
var vec__72814 = p__72813;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72814,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___72857 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72837){
var state_val_72838 = (state_72837[(1)]);
if((state_val_72838 === (1))){
var inst_72817 = fluree.db.connection.get_socket(conn);
var state_72837__$1 = state_72837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72837__$1,(2),inst_72817);
} else {
if((state_val_72838 === (2))){
var inst_72819 = (state_72837[(7)]);
var inst_72820 = (state_72837[(8)]);
var inst_72819__$1 = (state_72837[(2)]);
var inst_72820__$1 = (inst_72819__$1 == null);
var state_72837__$1 = (function (){var statearr_72839 = state_72837;
(statearr_72839[(7)] = inst_72819__$1);

(statearr_72839[(8)] = inst_72820__$1);

return statearr_72839;
})();
if(cljs.core.truth_(inst_72820__$1)){
var statearr_72840_72858 = state_72837__$1;
(statearr_72840_72858[(1)] = (3));

} else {
var statearr_72841_72859 = state_72837__$1;
(statearr_72841_72859[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (3))){
var inst_72820 = (state_72837[(8)]);
var state_72837__$1 = state_72837;
var statearr_72842_72860 = state_72837__$1;
(statearr_72842_72860[(2)] = inst_72820);

(statearr_72842_72860[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (4))){
var inst_72819 = (state_72837[(7)]);
var inst_72823 = fluree.db.util.core.exception_QMARK_(inst_72819);
var state_72837__$1 = state_72837;
var statearr_72843_72861 = state_72837__$1;
(statearr_72843_72861[(2)] = inst_72823);

(statearr_72843_72861[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (5))){
var inst_72825 = (state_72837[(2)]);
var state_72837__$1 = state_72837;
if(cljs.core.truth_(inst_72825)){
var statearr_72844_72862 = state_72837__$1;
(statearr_72844_72862[(1)] = (6));

} else {
var statearr_72845_72863 = state_72837__$1;
(statearr_72845_72863[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (6))){
var inst_72819 = (state_72837[(7)]);
var inst_72827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72828 = [inst_72819,"Cannot establish connection to a healthy server, disconnecting."];
var inst_72829 = (new cljs.core.PersistentVector(null,2,(5),inst_72827,inst_72828,null));
var inst_72830 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72829);
var inst_72831 = cljs.core.async.close_BANG_(conn);
var state_72837__$1 = (function (){var statearr_72846 = state_72837;
(statearr_72846[(9)] = inst_72830);

return statearr_72846;
})();
var statearr_72847_72864 = state_72837__$1;
(statearr_72847_72864[(2)] = inst_72831);

(statearr_72847_72864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (7))){
var inst_72833 = fluree.db.connection.msg_consumer(conn);
var state_72837__$1 = state_72837;
var statearr_72848_72865 = state_72837__$1;
(statearr_72848_72865[(2)] = inst_72833);

(statearr_72848_72865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (8))){
var inst_72835 = (state_72837[(2)]);
var state_72837__$1 = state_72837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72837__$1,inst_72835);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_72849 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72849[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_72849[(1)] = (1));

return statearr_72849;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_72837){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72837);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72850){var ex__2730__auto__ = e72850;
var statearr_72851_72866 = state_72837;
(statearr_72851_72866[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72837[(4)]))){
var statearr_72852_72867 = state_72837;
(statearr_72852_72867[(1)] = cljs.core.first((state_72837[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72868 = state_72837;
state_72837 = G__72868;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_72837){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_72837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72853 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72853[(6)] = c__2749__auto___72857);

return statearr_72853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq72811){
var G__72812 = cljs.core.first(seq72811);
var seq72811__$1 = cljs.core.next(seq72811);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72812,seq72811__$1);
}));

