// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__69470 = arguments.length;
switch (G__69470) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___69618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69557){
var state_val_69558 = (state_69557[(1)]);
if((state_val_69558 === (7))){
var inst_69488 = (state_69557[(7)]);
var inst_69491 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_69488);
var state_69557__$1 = state_69557;
var statearr_69559_69619 = state_69557__$1;
(statearr_69559_69619[(2)] = inst_69491);

(statearr_69559_69619[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (20))){
var inst_69483 = (state_69557[(8)]);
var inst_69512 = (state_69557[(9)]);
var inst_69516 = fluree.db.auth.roles(inst_69483,inst_69512);
var state_69557__$1 = state_69557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69557__$1,(23),inst_69516);
} else {
if((state_val_69558 === (27))){
var inst_69483 = (state_69557[(8)]);
var inst_69531 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69532 = fluree.db.time_travel.as_of_block(inst_69483,inst_69531);
var state_69557__$1 = state_69557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69557__$1,(30),inst_69532);
} else {
if((state_val_69558 === (1))){
var state_69557__$1 = state_69557;
var statearr_69560_69620 = state_69557__$1;
(statearr_69560_69620[(2)] = null);

(statearr_69560_69620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (24))){
var inst_69524 = (state_69557[(10)]);
var inst_69483 = (state_69557[(8)]);
var inst_69526 = fluree.db.permissions.permission_map(inst_69483,inst_69524,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_69557__$1 = state_69557;
var statearr_69561_69621 = state_69557__$1;
(statearr_69561_69621[(2)] = inst_69526);

(statearr_69561_69621[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (4))){
var inst_69471 = (state_69557[(2)]);
var inst_69472 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69471);
var inst_69473 = cljs.core.async.close_BANG_(pc);
var state_69557__$1 = (function (){var statearr_69562 = state_69557;
(statearr_69562[(11)] = inst_69472);

return statearr_69562;
})();
var statearr_69563_69622 = state_69557__$1;
(statearr_69563_69622[(2)] = inst_69473);

(statearr_69563_69622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (15))){
var inst_69488 = (state_69557[(7)]);
var inst_69502 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69488)," unknown."].join('');
var inst_69503 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69504 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69505 = cljs.core.PersistentHashMap.fromArrays(inst_69503,inst_69504);
var inst_69506 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69502,inst_69505);
var inst_69507 = (function(){throw inst_69506})();
var state_69557__$1 = state_69557;
var statearr_69564_69623 = state_69557__$1;
(statearr_69564_69623[(2)] = inst_69507);

(statearr_69564_69623[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (21))){
var state_69557__$1 = state_69557;
var statearr_69565_69624 = state_69557__$1;
(statearr_69565_69624[(2)] = null);

(statearr_69565_69624[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (31))){
var inst_69538 = (state_69557[(12)]);
var inst_69488 = (state_69557[(7)]);
var inst_69540 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69538,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69488);
var state_69557__$1 = state_69557;
var statearr_69566_69625 = state_69557__$1;
(statearr_69566_69625[(2)] = inst_69540);

(statearr_69566_69625[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (32))){
var inst_69538 = (state_69557[(12)]);
var state_69557__$1 = state_69557;
var statearr_69567_69626 = state_69557__$1;
(statearr_69567_69626[(2)] = inst_69538);

(statearr_69567_69626[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (33))){
var inst_69524 = (state_69557[(10)]);
var inst_69543 = (state_69557[(2)]);
var state_69557__$1 = (function (){var statearr_69568 = state_69557;
(statearr_69568[(13)] = inst_69543);

return statearr_69568;
})();
if(cljs.core.truth_(inst_69524)){
var statearr_69569_69627 = state_69557__$1;
(statearr_69569_69627[(1)] = (34));

} else {
var statearr_69570_69628 = state_69557__$1;
(statearr_69570_69628[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (13))){
var inst_69499 = (state_69557[(14)]);
var inst_69498 = (state_69557[(2)]);
var inst_69499__$1 = fluree.db.util.async.throw_err(inst_69498);
var state_69557__$1 = (function (){var statearr_69571 = state_69557;
(statearr_69571[(14)] = inst_69499__$1);

return statearr_69571;
})();
if(cljs.core.truth_(inst_69499__$1)){
var statearr_69572_69629 = state_69557__$1;
(statearr_69572_69629[(1)] = (14));

} else {
var statearr_69573_69630 = state_69557__$1;
(statearr_69573_69630[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (22))){
var inst_69522 = (state_69557[(2)]);
var state_69557__$1 = state_69557;
var statearr_69574_69631 = state_69557__$1;
(statearr_69574_69631[(2)] = inst_69522);

(statearr_69574_69631[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (36))){
var inst_69551 = (state_69557[(2)]);
var inst_69552 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69551);
var _ = (function (){var statearr_69575 = state_69557;
(statearr_69575[(4)] = cljs.core.rest((state_69557[(4)])));

return statearr_69575;
})();
var state_69557__$1 = state_69557;
var statearr_69576_69632 = state_69557__$1;
(statearr_69576_69632[(2)] = inst_69552);

(statearr_69576_69632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (29))){
var inst_69488 = (state_69557[(7)]);
var inst_69538 = (state_69557[(2)]);
var state_69557__$1 = (function (){var statearr_69577 = state_69557;
(statearr_69577[(12)] = inst_69538);

return statearr_69577;
})();
if(cljs.core.truth_(inst_69488)){
var statearr_69578_69633 = state_69557__$1;
(statearr_69578_69633[(1)] = (31));

} else {
var statearr_69579_69634 = state_69557__$1;
(statearr_69579_69634[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (6))){
var inst_69488 = (state_69557[(7)]);
var inst_69482 = (state_69557[(2)]);
var inst_69483 = fluree.db.util.async.throw_err(inst_69482);
var inst_69484 = opts;
var inst_69485 = cljs.core.__destructure_map(inst_69484);
var inst_69486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69485,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69485,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69488__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69485,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69485,new cljs.core.Keyword(null,"block","block",664686210));
var state_69557__$1 = (function (){var statearr_69580 = state_69557;
(statearr_69580[(15)] = inst_69487);

(statearr_69580[(8)] = inst_69483);

(statearr_69580[(16)] = inst_69489);

(statearr_69580[(17)] = inst_69486);

(statearr_69580[(7)] = inst_69488__$1);

return statearr_69580;
})();
if(cljs.core.truth_(inst_69488__$1)){
var statearr_69581_69635 = state_69557__$1;
(statearr_69581_69635[(1)] = (7));

} else {
var statearr_69582_69636 = state_69557__$1;
(statearr_69582_69636[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (28))){
var inst_69483 = (state_69557[(8)]);
var state_69557__$1 = state_69557;
var statearr_69583_69637 = state_69557__$1;
(statearr_69583_69637[(2)] = inst_69483);

(statearr_69583_69637[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (25))){
var state_69557__$1 = state_69557;
var statearr_69584_69638 = state_69557__$1;
(statearr_69584_69638[(2)] = null);

(statearr_69584_69638[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (34))){
var inst_69529 = (state_69557[(18)]);
var state_69557__$1 = state_69557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69557__$1,(37),inst_69529);
} else {
if((state_val_69558 === (17))){
var inst_69486 = (state_69557[(17)]);
var state_69557__$1 = state_69557;
var statearr_69585_69639 = state_69557__$1;
(statearr_69585_69639[(2)] = inst_69486);

(statearr_69585_69639[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (3))){
var inst_69555 = (state_69557[(2)]);
var state_69557__$1 = state_69557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69557__$1,inst_69555);
} else {
if((state_val_69558 === (12))){
var inst_69486 = (state_69557[(17)]);
var inst_69512 = (state_69557[(2)]);
var state_69557__$1 = (function (){var statearr_69586 = state_69557;
(statearr_69586[(9)] = inst_69512);

return statearr_69586;
})();
if(cljs.core.truth_(inst_69486)){
var statearr_69587_69640 = state_69557__$1;
(statearr_69587_69640[(1)] = (17));

} else {
var statearr_69588_69641 = state_69557__$1;
(statearr_69588_69641[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (2))){
var _ = (function (){var statearr_69589 = state_69557;
(statearr_69589[(4)] = cljs.core.cons((5),(state_69557[(4)])));

return statearr_69589;
})();
var inst_69480 = fluree.db.session.db(conn,ledger,null);
var state_69557__$1 = state_69557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69557__$1,(6),inst_69480);
} else {
if((state_val_69558 === (23))){
var inst_69518 = (state_69557[(2)]);
var inst_69519 = fluree.db.util.async.throw_err(inst_69518);
var state_69557__$1 = state_69557;
var statearr_69590_69642 = state_69557__$1;
(statearr_69590_69642[(2)] = inst_69519);

(statearr_69590_69642[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (35))){
var inst_69543 = (state_69557[(13)]);
var state_69557__$1 = state_69557;
var statearr_69591_69643 = state_69557__$1;
(statearr_69591_69643[(2)] = inst_69543);

(statearr_69591_69643[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (19))){
var inst_69524 = (state_69557[(10)]);
var inst_69524__$1 = (state_69557[(2)]);
var state_69557__$1 = (function (){var statearr_69592 = state_69557;
(statearr_69592[(10)] = inst_69524__$1);

return statearr_69592;
})();
if(cljs.core.truth_(inst_69524__$1)){
var statearr_69593_69644 = state_69557__$1;
(statearr_69593_69644[(1)] = (24));

} else {
var statearr_69594_69645 = state_69557__$1;
(statearr_69594_69645[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (11))){
var state_69557__$1 = state_69557;
var statearr_69596_69646 = state_69557__$1;
(statearr_69596_69646[(2)] = null);

(statearr_69596_69646[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (9))){
var inst_69494 = (state_69557[(2)]);
var state_69557__$1 = state_69557;
if(cljs.core.truth_(inst_69494)){
var statearr_69597_69647 = state_69557__$1;
(statearr_69597_69647[(1)] = (10));

} else {
var statearr_69598_69648 = state_69557__$1;
(statearr_69598_69648[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (5))){
var _ = (function (){var statearr_69599 = state_69557;
(statearr_69599[(4)] = cljs.core.rest((state_69557[(4)])));

return statearr_69599;
})();
var state_69557__$1 = state_69557;
var ex69595 = (state_69557__$1[(2)]);
var statearr_69600_69649 = state_69557__$1;
(statearr_69600_69649[(5)] = ex69595);


var statearr_69601_69650 = state_69557__$1;
(statearr_69601_69650[(1)] = (4));

(statearr_69601_69650[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (14))){
var inst_69499 = (state_69557[(14)]);
var state_69557__$1 = state_69557;
var statearr_69602_69651 = state_69557__$1;
(statearr_69602_69651[(2)] = inst_69499);

(statearr_69602_69651[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (26))){
var inst_69489 = (state_69557[(16)]);
var inst_69529 = (state_69557[(2)]);
var state_69557__$1 = (function (){var statearr_69603 = state_69557;
(statearr_69603[(18)] = inst_69529);

return statearr_69603;
})();
if(cljs.core.truth_(inst_69489)){
var statearr_69604_69652 = state_69557__$1;
(statearr_69604_69652[(1)] = (27));

} else {
var statearr_69605_69653 = state_69557__$1;
(statearr_69605_69653[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (16))){
var inst_69509 = (state_69557[(2)]);
var state_69557__$1 = state_69557;
var statearr_69606_69654 = state_69557__$1;
(statearr_69606_69654[(2)] = inst_69509);

(statearr_69606_69654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (30))){
var inst_69534 = (state_69557[(2)]);
var inst_69535 = fluree.db.util.async.throw_err(inst_69534);
var state_69557__$1 = state_69557;
var statearr_69607_69655 = state_69557__$1;
(statearr_69607_69655[(2)] = inst_69535);

(statearr_69607_69655[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (10))){
var inst_69483 = (state_69557[(8)]);
var inst_69488 = (state_69557[(7)]);
var inst_69496 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_69483,inst_69488);
var state_69557__$1 = state_69557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69557__$1,(13),inst_69496);
} else {
if((state_val_69558 === (18))){
var inst_69512 = (state_69557[(9)]);
var state_69557__$1 = state_69557;
if(cljs.core.truth_(inst_69512)){
var statearr_69608_69656 = state_69557__$1;
(statearr_69608_69656[(1)] = (20));

} else {
var statearr_69609_69657 = state_69557__$1;
(statearr_69609_69657[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (37))){
var inst_69543 = (state_69557[(13)]);
var inst_69546 = (state_69557[(2)]);
var inst_69547 = fluree.db.util.async.throw_err(inst_69546);
var inst_69548 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69543,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_69547);
var state_69557__$1 = state_69557;
var statearr_69610_69658 = state_69557__$1;
(statearr_69610_69658[(2)] = inst_69548);

(statearr_69610_69658[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69558 === (8))){
var inst_69488 = (state_69557[(7)]);
var state_69557__$1 = state_69557;
var statearr_69611_69659 = state_69557__$1;
(statearr_69611_69659[(2)] = inst_69488);

(statearr_69611_69659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_69612 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69612[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_69612[(1)] = (1));

return statearr_69612;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_69557){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69557);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69613){var ex__2730__auto__ = e69613;
var statearr_69614_69660 = state_69557;
(statearr_69614_69660[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69557[(4)]))){
var statearr_69615_69661 = state_69557;
(statearr_69615_69661[(1)] = cljs.core.first((state_69557[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69662 = state_69557;
state_69557 = G__69662;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_69557){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_69557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69616 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69616[(6)] = c__2749__auto___69618);

return statearr_69616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69803){
var state_val_69804 = (state_69803[(1)]);
if((state_val_69804 === (7))){
var inst_69683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69684 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69685 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69686 = [inst_69684,inst_69685];
var inst_69687 = (new cljs.core.PersistentVector(null,2,(5),inst_69683,inst_69686,null));
var state_69803__$1 = state_69803;
var statearr_69805_69875 = state_69803__$1;
(statearr_69805_69875[(2)] = inst_69687);

(statearr_69805_69875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (20))){
var inst_69713 = (state_69803[(7)]);
var state_69803__$1 = state_69803;
var statearr_69806_69876 = state_69803__$1;
(statearr_69806_69876[(2)] = inst_69713);

(statearr_69806_69876[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (27))){
var state_69803__$1 = state_69803;
var statearr_69807_69877 = state_69803__$1;
(statearr_69807_69877[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (1))){
var state_69803__$1 = state_69803;
var statearr_69809_69878 = state_69803__$1;
(statearr_69809_69878[(2)] = null);

(statearr_69809_69878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (24))){
var inst_69712 = (state_69803[(8)]);
var state_69803__$1 = state_69803;
if(cljs.core.truth_(inst_69712)){
var statearr_69810_69879 = state_69803__$1;
(statearr_69810_69879[(1)] = (26));

} else {
var statearr_69811_69880 = state_69803__$1;
(statearr_69811_69880[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (39))){
var inst_69759 = (state_69803[(9)]);
var inst_69758 = (state_69803[(10)]);
var inst_69784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69785 = [inst_69758,inst_69759];
var inst_69786 = (new cljs.core.PersistentVector(null,2,(5),inst_69784,inst_69785,null));
var state_69803__$1 = state_69803;
var statearr_69812_69881 = state_69803__$1;
(statearr_69812_69881[(2)] = inst_69786);

(statearr_69812_69881[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (4))){
var inst_69663 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
var statearr_69813_69882 = state_69803__$1;
(statearr_69813_69882[(2)] = inst_69663);

(statearr_69813_69882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (15))){
var inst_69697 = (state_69803[(11)]);
var inst_69692 = (state_69803[(12)]);
var inst_69706 = (state_69803[(2)]);
var inst_69707 = [inst_69697,inst_69706];
var inst_69708 = (new cljs.core.PersistentVector(null,2,(5),inst_69692,inst_69707,null));
var state_69803__$1 = state_69803;
var statearr_69814_69883 = state_69803__$1;
(statearr_69814_69883[(2)] = inst_69708);

(statearr_69814_69883[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (21))){
var inst_69712 = (state_69803[(8)]);
var state_69803__$1 = state_69803;
var statearr_69815_69884 = state_69803__$1;
(statearr_69815_69884[(2)] = inst_69712);

(statearr_69815_69884[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (31))){
var inst_69753 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
var statearr_69816_69885 = state_69803__$1;
(statearr_69816_69885[(2)] = inst_69753);

(statearr_69816_69885[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (32))){
var inst_69759 = (state_69803[(9)]);
var inst_69762 = cljs.core.pos_int_QMARK_(inst_69759);
var state_69803__$1 = state_69803;
var statearr_69817_69886 = state_69803__$1;
(statearr_69817_69886[(2)] = inst_69762);

(statearr_69817_69886[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (40))){
var inst_69714 = (state_69803[(13)]);
var inst_69790 = (state_69803[(14)]);
var inst_69788 = (state_69803[(2)]);
var inst_69789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69788,(0),null);
var inst_69790__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69788,(1),null);
var inst_69791 = (inst_69790__$1 > inst_69714);
var state_69803__$1 = (function (){var statearr_69818 = state_69803;
(statearr_69818[(14)] = inst_69790__$1);

(statearr_69818[(15)] = inst_69789);

return statearr_69818;
})();
if(cljs.core.truth_(inst_69791)){
var statearr_69819_69887 = state_69803__$1;
(statearr_69819_69887[(1)] = (41));

} else {
var statearr_69820_69888 = state_69803__$1;
(statearr_69820_69888[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (33))){
var inst_69760 = (state_69803[(16)]);
var state_69803__$1 = state_69803;
var statearr_69821_69889 = state_69803__$1;
(statearr_69821_69889[(2)] = inst_69760);

(statearr_69821_69889[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (13))){
var inst_69698 = (state_69803[(17)]);
var inst_69700 = fluree.db.time_travel.block_to_int_format(db,inst_69698);
var state_69803__$1 = state_69803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69803__$1,(16),inst_69700);
} else {
if((state_val_69804 === (22))){
var inst_69731 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
if(cljs.core.truth_(inst_69731)){
var statearr_69822_69890 = state_69803__$1;
(statearr_69822_69890[(1)] = (23));

} else {
var statearr_69823_69891 = state_69803__$1;
(statearr_69823_69891[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (36))){
var state_69803__$1 = state_69803;
var statearr_69824_69892 = state_69803__$1;
(statearr_69824_69892[(2)] = null);

(statearr_69824_69892[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (41))){
var inst_69714 = (state_69803[(13)]);
var state_69803__$1 = state_69803;
var statearr_69825_69893 = state_69803__$1;
(statearr_69825_69893[(2)] = inst_69714);

(statearr_69825_69893[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (43))){
var inst_69789 = (state_69803[(15)]);
var inst_69795 = (state_69803[(2)]);
var inst_69796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69797 = [inst_69789,inst_69795];
var inst_69798 = (new cljs.core.PersistentVector(null,2,(5),inst_69796,inst_69797,null));
var _ = (function (){var statearr_69826 = state_69803;
(statearr_69826[(4)] = cljs.core.rest((state_69803[(4)])));

return statearr_69826;
})();
var state_69803__$1 = state_69803;
var statearr_69827_69894 = state_69803__$1;
(statearr_69827_69894[(2)] = inst_69798);

(statearr_69827_69894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (29))){
var inst_69689 = (state_69803[(18)]);
var inst_69744 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69689], 0));
var inst_69745 = ["Invalid block range provided: ",inst_69744].join('');
var inst_69746 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69747 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69748 = cljs.core.PersistentHashMap.fromArrays(inst_69746,inst_69747);
var inst_69749 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69745,inst_69748);
var inst_69750 = (function(){throw inst_69749})();
var state_69803__$1 = state_69803;
var statearr_69828_69895 = state_69803__$1;
(statearr_69828_69895[(2)] = inst_69750);

(statearr_69828_69895[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (6))){
var inst_69681 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_69803__$1 = state_69803;
var statearr_69829_69896 = state_69803__$1;
(statearr_69829_69896[(2)] = inst_69681);

(statearr_69829_69896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (28))){
var inst_69755 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
var statearr_69830_69897 = state_69803__$1;
(statearr_69830_69897[(2)] = inst_69755);

(statearr_69830_69897[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (25))){
var inst_69760 = (state_69803[(16)]);
var inst_69758 = (state_69803[(10)]);
var inst_69757 = (state_69803[(2)]);
var inst_69758__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69757,(0),null);
var inst_69759 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69757,(1),null);
var inst_69760__$1 = cljs.core.pos_int_QMARK_(inst_69758__$1);
var state_69803__$1 = (function (){var statearr_69831 = state_69803;
(statearr_69831[(16)] = inst_69760__$1);

(statearr_69831[(9)] = inst_69759);

(statearr_69831[(10)] = inst_69758__$1);

return statearr_69831;
})();
if(inst_69760__$1){
var statearr_69832_69898 = state_69803__$1;
(statearr_69832_69898[(1)] = (32));

} else {
var statearr_69833_69899 = state_69803__$1;
(statearr_69833_69899[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (34))){
var inst_69765 = (state_69803[(2)]);
var inst_69766 = cljs.core.not(inst_69765);
var state_69803__$1 = state_69803;
if(inst_69766){
var statearr_69834_69900 = state_69803__$1;
(statearr_69834_69900[(1)] = (35));

} else {
var statearr_69835_69901 = state_69803__$1;
(statearr_69835_69901[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (17))){
var inst_69714 = (state_69803[(13)]);
var inst_69712 = (state_69803[(8)]);
var inst_69717 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69712], 0));
var inst_69718 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69714], 0));
var inst_69719 = ["Start block is out of range for this ledger. Start block provided: ",inst_69717,". Database block: ",inst_69718].join('');
var inst_69720 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69721 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69722 = cljs.core.PersistentHashMap.fromArrays(inst_69720,inst_69721);
var inst_69723 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69719,inst_69722);
var inst_69724 = (function(){throw inst_69723})();
var state_69803__$1 = state_69803;
var statearr_69836_69902 = state_69803__$1;
(statearr_69836_69902[(2)] = inst_69724);

(statearr_69836_69902[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (3))){
var inst_69801 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69803__$1,inst_69801);
} else {
if((state_val_69804 === (12))){
var inst_69698 = (state_69803[(17)]);
var inst_69689 = (state_69803[(18)]);
var inst_69696 = (state_69803[(2)]);
var inst_69697 = fluree.db.util.async.throw_err(inst_69696);
var inst_69698__$1 = cljs.core.second(inst_69689);
var state_69803__$1 = (function (){var statearr_69837 = state_69803;
(statearr_69837[(17)] = inst_69698__$1);

(statearr_69837[(11)] = inst_69697);

return statearr_69837;
})();
if(cljs.core.truth_(inst_69698__$1)){
var statearr_69838_69903 = state_69803__$1;
(statearr_69838_69903[(1)] = (13));

} else {
var statearr_69839_69904 = state_69803__$1;
(statearr_69839_69904[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (2))){
var _ = (function (){var statearr_69840 = state_69803;
(statearr_69840[(4)] = cljs.core.cons((5),(state_69803[(4)])));

return statearr_69840;
})();
var inst_69678 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69679 = cljs.core.sequential_QMARK_(inst_69678);
var state_69803__$1 = state_69803;
if(inst_69679){
var statearr_69841_69905 = state_69803__$1;
(statearr_69841_69905[(1)] = (6));

} else {
var statearr_69842_69906 = state_69803__$1;
(statearr_69842_69906[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (23))){
var inst_69713 = (state_69803[(7)]);
var inst_69712 = (state_69803[(8)]);
var inst_69733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69734 = [inst_69712,inst_69713];
var inst_69735 = (new cljs.core.PersistentVector(null,2,(5),inst_69733,inst_69734,null));
var state_69803__$1 = state_69803;
var statearr_69843_69907 = state_69803__$1;
(statearr_69843_69907[(2)] = inst_69735);

(statearr_69843_69907[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (35))){
var inst_69689 = (state_69803[(18)]);
var inst_69768 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69689], 0));
var inst_69769 = ["Invalid block range provided: ",inst_69768].join('');
var inst_69770 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69771 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69772 = cljs.core.PersistentHashMap.fromArrays(inst_69770,inst_69771);
var inst_69773 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69769,inst_69772);
var inst_69774 = (function(){throw inst_69773})();
var state_69803__$1 = state_69803;
var statearr_69844_69908 = state_69803__$1;
(statearr_69844_69908[(2)] = inst_69774);

(statearr_69844_69908[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (19))){
var inst_69712 = (state_69803[(8)]);
var inst_69727 = (state_69803[(2)]);
var state_69803__$1 = (function (){var statearr_69845 = state_69803;
(statearr_69845[(19)] = inst_69727);

return statearr_69845;
})();
if(cljs.core.truth_(inst_69712)){
var statearr_69846_69909 = state_69803__$1;
(statearr_69846_69909[(1)] = (20));

} else {
var statearr_69847_69910 = state_69803__$1;
(statearr_69847_69910[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (11))){
var inst_69714 = (state_69803[(13)]);
var inst_69712 = (state_69803[(8)]);
var inst_69711 = (state_69803[(2)]);
var inst_69712__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69711,(0),null);
var inst_69713 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69711,(1),null);
var inst_69714__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69715 = (inst_69712__$1 > inst_69714__$1);
var state_69803__$1 = (function (){var statearr_69849 = state_69803;
(statearr_69849[(13)] = inst_69714__$1);

(statearr_69849[(7)] = inst_69713);

(statearr_69849[(8)] = inst_69712__$1);

return statearr_69849;
})();
if(cljs.core.truth_(inst_69715)){
var statearr_69850_69911 = state_69803__$1;
(statearr_69850_69911[(1)] = (17));

} else {
var statearr_69851_69912 = state_69803__$1;
(statearr_69851_69912[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (9))){
var inst_69689 = (state_69803[(18)]);
var inst_69692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69693 = cljs.core.first(inst_69689);
var inst_69694 = fluree.db.time_travel.block_to_int_format(db,inst_69693);
var state_69803__$1 = (function (){var statearr_69852 = state_69803;
(statearr_69852[(12)] = inst_69692);

return statearr_69852;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69803__$1,(12),inst_69694);
} else {
if((state_val_69804 === (5))){
var _ = (function (){var statearr_69853 = state_69803;
(statearr_69853[(4)] = cljs.core.rest((state_69803[(4)])));

return statearr_69853;
})();
var state_69803__$1 = state_69803;
var ex69848 = (state_69803__$1[(2)]);
var statearr_69854_69913 = state_69803__$1;
(statearr_69854_69913[(5)] = ex69848);


if((ex69848 instanceof Error)){
var statearr_69855_69914 = state_69803__$1;
(statearr_69855_69914[(1)] = (4));

(statearr_69855_69914[(5)] = null);

} else {
throw ex69848;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (14))){
var state_69803__$1 = state_69803;
var statearr_69856_69915 = state_69803__$1;
(statearr_69856_69915[(2)] = null);

(statearr_69856_69915[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (26))){
var inst_69712 = (state_69803[(8)]);
var inst_69738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69739 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69740 = [inst_69712,inst_69739];
var inst_69741 = (new cljs.core.PersistentVector(null,2,(5),inst_69738,inst_69740,null));
var state_69803__$1 = state_69803;
var statearr_69857_69916 = state_69803__$1;
(statearr_69857_69916[(2)] = inst_69741);

(statearr_69857_69916[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (16))){
var inst_69702 = (state_69803[(2)]);
var inst_69703 = fluree.db.util.async.throw_err(inst_69702);
var state_69803__$1 = state_69803;
var statearr_69858_69917 = state_69803__$1;
(statearr_69858_69917[(2)] = inst_69703);

(statearr_69858_69917[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (38))){
var inst_69759 = (state_69803[(9)]);
var inst_69758 = (state_69803[(10)]);
var inst_69780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69781 = [inst_69759,inst_69758];
var inst_69782 = (new cljs.core.PersistentVector(null,2,(5),inst_69780,inst_69781,null));
var state_69803__$1 = state_69803;
var statearr_69859_69918 = state_69803__$1;
(statearr_69859_69918[(2)] = inst_69782);

(statearr_69859_69918[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (30))){
var state_69803__$1 = state_69803;
var statearr_69860_69919 = state_69803__$1;
(statearr_69860_69919[(2)] = null);

(statearr_69860_69919[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (10))){
var inst_69689 = (state_69803[(18)]);
var state_69803__$1 = state_69803;
var statearr_69861_69920 = state_69803__$1;
(statearr_69861_69920[(2)] = inst_69689);

(statearr_69861_69920[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (18))){
var state_69803__$1 = state_69803;
var statearr_69862_69921 = state_69803__$1;
(statearr_69862_69921[(2)] = null);

(statearr_69862_69921[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (42))){
var inst_69790 = (state_69803[(14)]);
var state_69803__$1 = state_69803;
var statearr_69863_69922 = state_69803__$1;
(statearr_69863_69922[(2)] = inst_69790);

(statearr_69863_69922[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (37))){
var inst_69759 = (state_69803[(9)]);
var inst_69758 = (state_69803[(10)]);
var inst_69777 = (state_69803[(2)]);
var inst_69778 = (inst_69759 < inst_69758);
var state_69803__$1 = (function (){var statearr_69864 = state_69803;
(statearr_69864[(20)] = inst_69777);

return statearr_69864;
})();
if(cljs.core.truth_(inst_69778)){
var statearr_69865_69923 = state_69803__$1;
(statearr_69865_69923[(1)] = (38));

} else {
var statearr_69866_69924 = state_69803__$1;
(statearr_69866_69924[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69804 === (8))){
var inst_69689 = (state_69803[(18)]);
var inst_69689__$1 = (state_69803[(2)]);
var inst_69690 = cljs.core.some(cljs.core.string_QMARK_,inst_69689__$1);
var state_69803__$1 = (function (){var statearr_69867 = state_69803;
(statearr_69867[(18)] = inst_69689__$1);

return statearr_69867;
})();
if(cljs.core.truth_(inst_69690)){
var statearr_69868_69925 = state_69803__$1;
(statearr_69868_69925[(1)] = (9));

} else {
var statearr_69869_69926 = state_69803__$1;
(statearr_69869_69926[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_69870 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69870[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_69870[(1)] = (1));

return statearr_69870;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_69803){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69803);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69871){var ex__2730__auto__ = e69871;
var statearr_69872_69927 = state_69803;
(statearr_69872_69927[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69803[(4)]))){
var statearr_69873_69928 = state_69803;
(statearr_69873_69928[(1)] = cljs.core.first((state_69803[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69929 = state_69803;
state_69803 = G__69929;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_69803){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_69803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69874 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69874[(6)] = c__2749__auto__);

return statearr_69874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70079){
var state_val_70080 = (state_70079[(1)]);
if((state_val_70080 === (7))){
var inst_69991 = (state_70079[(2)]);
var inst_69992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69991,(0),null);
var inst_69993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69991,(1),null);
var inst_70001 = cljs.core.vals(inst_69993);
var inst_70002 = cljs.core.seq(inst_70001);
var inst_70003 = cljs.core.first(inst_70002);
var inst_70004 = cljs.core.next(inst_70002);
var inst_70005 = cljs.core.PersistentVector.EMPTY;
var inst_70006 = inst_70001;
var inst_70007 = inst_70005;
var state_70079__$1 = (function (){var statearr_70081 = state_70079;
(statearr_70081[(7)] = inst_70007);

(statearr_70081[(8)] = inst_70006);

(statearr_70081[(9)] = inst_70003);

(statearr_70081[(10)] = inst_69992);

(statearr_70081[(11)] = inst_70004);

return statearr_70081;
})();
var statearr_70082_70135 = state_70079__$1;
(statearr_70082_70135[(2)] = null);

(statearr_70082_70135[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (20))){
var inst_70013 = (state_70079[(12)]);
var inst_70018 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70019 = cljs.core.PersistentHashMap.EMPTY;
var inst_70020 = [true,inst_70019];
var inst_70021 = cljs.core.PersistentHashMap.fromArrays(inst_70018,inst_70020);
var inst_70022 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_70021,inst_70013);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70079__$1,(22),inst_70022);
} else {
if((state_val_70080 === (27))){
var inst_70067 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70083_70136 = state_70079__$1;
(statearr_70083_70136[(2)] = inst_70067);

(statearr_70083_70136[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (1))){
var state_70079__$1 = state_70079;
var statearr_70084_70137 = state_70079__$1;
(statearr_70084_70137[(2)] = null);

(statearr_70084_70137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (24))){
var inst_70031 = (state_70079[(13)]);
var inst_70069 = (state_70079[(2)]);
var inst_70070 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_70071 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70072 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70073 = [inst_70071,inst_70072,inst_70031,inst_70069];
var inst_70074 = cljs.core.PersistentHashMap.fromArrays(inst_70070,inst_70073);
var _ = (function (){var statearr_70086 = state_70079;
(statearr_70086[(4)] = cljs.core.rest((state_70079[(4)])));

return statearr_70086;
})();
var state_70079__$1 = state_70079;
var statearr_70087_70138 = state_70079__$1;
(statearr_70087_70138[(2)] = inst_70074);

(statearr_70087_70138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (4))){
var inst_69932 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70088_70139 = state_70079__$1;
(statearr_70088_70139[(2)] = inst_69932);

(statearr_70088_70139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (15))){
var inst_69954 = (state_70079[(14)]);
var inst_69956 = (state_70079[(15)]);
var inst_69963 = (state_70079[(16)]);
var inst_69970 = (state_70079[(17)]);
var inst_69972 = (state_70079[(18)]);
var inst_69948 = (state_70079[(19)]);
var inst_69955 = (state_70079[(20)]);
var inst_69951 = (state_70079[(21)]);
var inst_69950 = (state_70079[(22)]);
var inst_69962 = (state_70079[(23)]);
var inst_69977 = (state_70079[(24)]);
var inst_69983 = (function (){var vec__69958 = inst_69954;
var G__69944 = inst_69954;
var subject = inst_69970;
var flake = inst_69962;
var seq__69946 = inst_69951;
var first__69960 = inst_69962;
var r = inst_69963;
var asserted_subjects = inst_69955;
var flake_SINGLEQUOTE_ = inst_69977;
var retracted_subjects = inst_69956;
var first__69947 = inst_69950;
var asserted_QMARK_ = inst_69972;
var seq__69959 = inst_69963;
var vec__69945 = inst_69948;
return (function (p1__69931_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__69931_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69984 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_69956,inst_69970,inst_69983);
var tmp70085 = inst_69955;
var inst_69954__$1 = inst_69963;
var inst_69955__$1 = tmp70085;
var inst_69956__$1 = inst_69984;
var state_70079__$1 = (function (){var statearr_70089 = state_70079;
(statearr_70089[(14)] = inst_69954__$1);

(statearr_70089[(15)] = inst_69956__$1);

(statearr_70089[(20)] = inst_69955__$1);

return statearr_70089;
})();
var statearr_70090_70140 = state_70079__$1;
(statearr_70090_70140[(2)] = null);

(statearr_70090_70140[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (21))){
var inst_70029 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70091_70141 = state_70079__$1;
(statearr_70091_70141[(2)] = inst_70029);

(statearr_70091_70141[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (13))){
var inst_69972 = (state_70079[(18)]);
var inst_69977 = (state_70079[(2)]);
var state_70079__$1 = (function (){var statearr_70092 = state_70079;
(statearr_70092[(24)] = inst_69977);

return statearr_70092;
})();
if(cljs.core.truth_(inst_69972)){
var statearr_70093_70142 = state_70079__$1;
(statearr_70093_70142[(1)] = (14));

} else {
var statearr_70094_70143 = state_70079__$1;
(statearr_70094_70143[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (22))){
var inst_70007 = (state_70079[(7)]);
var inst_70014 = (state_70079[(25)]);
var inst_70024 = (state_70079[(2)]);
var inst_70025 = fluree.db.util.async.throw_err(inst_70024);
var inst_70026 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70007,inst_70025);
var inst_70006 = inst_70014;
var inst_70007__$1 = inst_70026;
var state_70079__$1 = (function (){var statearr_70095 = state_70079;
(statearr_70095[(7)] = inst_70007__$1);

(statearr_70095[(8)] = inst_70006);

return statearr_70095;
})();
var statearr_70096_70144 = state_70079__$1;
(statearr_70096_70144[(2)] = null);

(statearr_70096_70144[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (6))){
var inst_69954 = (state_70079[(14)]);
var inst_69962 = (state_70079[(23)]);
var inst_69961 = cljs.core.seq(inst_69954);
var inst_69962__$1 = cljs.core.first(inst_69961);
var inst_69963 = cljs.core.next(inst_69961);
var inst_69964 = cljs.core.not(inst_69962__$1);
var state_70079__$1 = (function (){var statearr_70097 = state_70079;
(statearr_70097[(16)] = inst_69963);

(statearr_70097[(23)] = inst_69962__$1);

return statearr_70097;
})();
if(inst_69964){
var statearr_70098_70145 = state_70079__$1;
(statearr_70098_70145[(1)] = (8));

} else {
var statearr_70099_70146 = state_70079__$1;
(statearr_70099_70146[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (28))){
var inst_70045 = (state_70079[(26)]);
var inst_70052 = (state_70079[(27)]);
var inst_70062 = (state_70079[(2)]);
var inst_70063 = fluree.db.util.async.throw_err(inst_70062);
var inst_70064 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70045,inst_70063);
var inst_70044 = inst_70052;
var inst_70045__$1 = inst_70064;
var state_70079__$1 = (function (){var statearr_70100 = state_70079;
(statearr_70100[(26)] = inst_70045__$1);

(statearr_70100[(28)] = inst_70044);

return statearr_70100;
})();
var statearr_70101_70147 = state_70079__$1;
(statearr_70101_70147[(2)] = null);

(statearr_70101_70147[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (25))){
var inst_70045 = (state_70079[(26)]);
var state_70079__$1 = state_70079;
var statearr_70102_70148 = state_70079__$1;
(statearr_70102_70148[(2)] = inst_70045);

(statearr_70102_70148[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (17))){
var inst_70013 = (state_70079[(12)]);
var inst_70006 = (state_70079[(8)]);
var inst_70012 = cljs.core.seq(inst_70006);
var inst_70013__$1 = cljs.core.first(inst_70012);
var inst_70014 = cljs.core.next(inst_70012);
var inst_70015 = cljs.core.not(inst_70013__$1);
var state_70079__$1 = (function (){var statearr_70103 = state_70079;
(statearr_70103[(12)] = inst_70013__$1);

(statearr_70103[(25)] = inst_70014);

return statearr_70103;
})();
if(inst_70015){
var statearr_70104_70149 = state_70079__$1;
(statearr_70104_70149[(1)] = (19));

} else {
var statearr_70105_70150 = state_70079__$1;
(statearr_70105_70150[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (3))){
var inst_70077 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70079__$1,inst_70077);
} else {
if((state_val_70080 === (12))){
var inst_69962 = (state_70079[(23)]);
var inst_69975 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_69962);
var state_70079__$1 = state_70079;
var statearr_70106_70151 = state_70079__$1;
(statearr_70106_70151[(2)] = inst_69975);

(statearr_70106_70151[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (2))){
var inst_69948 = (state_70079[(19)]);
var _ = (function (){var statearr_70107 = state_70079;
(statearr_70107[(4)] = cljs.core.cons((5),(state_70079[(4)])));

return statearr_70107;
})();
var inst_69948__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69949 = cljs.core.seq(inst_69948__$1);
var inst_69950 = cljs.core.first(inst_69949);
var inst_69951 = cljs.core.next(inst_69949);
var inst_69952 = cljs.core.PersistentHashMap.EMPTY;
var inst_69953 = cljs.core.PersistentHashMap.EMPTY;
var inst_69954 = inst_69948__$1;
var inst_69955 = inst_69952;
var inst_69956 = inst_69953;
var state_70079__$1 = (function (){var statearr_70108 = state_70079;
(statearr_70108[(14)] = inst_69954);

(statearr_70108[(15)] = inst_69956);

(statearr_70108[(19)] = inst_69948__$1);

(statearr_70108[(20)] = inst_69955);

(statearr_70108[(21)] = inst_69951);

(statearr_70108[(22)] = inst_69950);

return statearr_70108;
})();
var statearr_70109_70152 = state_70079__$1;
(statearr_70109_70152[(2)] = null);

(statearr_70109_70152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (23))){
var inst_70051 = (state_70079[(29)]);
var inst_70044 = (state_70079[(28)]);
var inst_70050 = cljs.core.seq(inst_70044);
var inst_70051__$1 = cljs.core.first(inst_70050);
var inst_70052 = cljs.core.next(inst_70050);
var inst_70053 = cljs.core.not(inst_70051__$1);
var state_70079__$1 = (function (){var statearr_70110 = state_70079;
(statearr_70110[(29)] = inst_70051__$1);

(statearr_70110[(27)] = inst_70052);

return statearr_70110;
})();
if(inst_70053){
var statearr_70111_70153 = state_70079__$1;
(statearr_70111_70153[(1)] = (25));

} else {
var statearr_70112_70154 = state_70079__$1;
(statearr_70112_70154[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (19))){
var inst_70007 = (state_70079[(7)]);
var state_70079__$1 = state_70079;
var statearr_70113_70155 = state_70079__$1;
(statearr_70113_70155[(2)] = inst_70007);

(statearr_70113_70155[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (11))){
var inst_69962 = (state_70079[(23)]);
var state_70079__$1 = state_70079;
var statearr_70115_70156 = state_70079__$1;
(statearr_70115_70156[(2)] = inst_69962);

(statearr_70115_70156[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (9))){
var inst_69972 = (state_70079[(18)]);
var inst_69962 = (state_70079[(23)]);
var inst_69970 = fluree.db.flake.s(inst_69962);
var inst_69971 = fluree.db.flake.op(inst_69962);
var inst_69972__$1 = inst_69971 === true;
var state_70079__$1 = (function (){var statearr_70117 = state_70079;
(statearr_70117[(17)] = inst_69970);

(statearr_70117[(18)] = inst_69972__$1);

return statearr_70117;
})();
if(cljs.core.truth_(inst_69972__$1)){
var statearr_70118_70157 = state_70079__$1;
(statearr_70118_70157[(1)] = (11));

} else {
var statearr_70119_70158 = state_70079__$1;
(statearr_70119_70158[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (5))){
var _ = (function (){var statearr_70120 = state_70079;
(statearr_70120[(4)] = cljs.core.rest((state_70079[(4)])));

return statearr_70120;
})();
var state_70079__$1 = state_70079;
var ex70114 = (state_70079__$1[(2)]);
var statearr_70121_70159 = state_70079__$1;
(statearr_70121_70159[(5)] = ex70114);


if((ex70114 instanceof Error)){
var statearr_70122_70160 = state_70079__$1;
(statearr_70122_70160[(1)] = (4));

(statearr_70122_70160[(5)] = null);

} else {
throw ex70114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (14))){
var inst_69954 = (state_70079[(14)]);
var inst_69956 = (state_70079[(15)]);
var inst_69963 = (state_70079[(16)]);
var inst_69970 = (state_70079[(17)]);
var inst_69972 = (state_70079[(18)]);
var inst_69948 = (state_70079[(19)]);
var inst_69955 = (state_70079[(20)]);
var inst_69951 = (state_70079[(21)]);
var inst_69950 = (state_70079[(22)]);
var inst_69962 = (state_70079[(23)]);
var inst_69977 = (state_70079[(24)]);
var inst_69979 = (function (){var vec__69958 = inst_69954;
var G__69944 = inst_69954;
var subject = inst_69970;
var flake = inst_69962;
var seq__69946 = inst_69951;
var first__69960 = inst_69962;
var r = inst_69963;
var asserted_subjects = inst_69955;
var flake_SINGLEQUOTE_ = inst_69977;
var retracted_subjects = inst_69956;
var first__69947 = inst_69950;
var asserted_QMARK_ = inst_69972;
var seq__69959 = inst_69963;
var vec__69945 = inst_69948;
return (function (p1__69930_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__69930_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69980 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_69955,inst_69970,inst_69979);
var tmp70116 = inst_69956;
var inst_69954__$1 = inst_69963;
var inst_69955__$1 = inst_69980;
var inst_69956__$1 = tmp70116;
var state_70079__$1 = (function (){var statearr_70123 = state_70079;
(statearr_70123[(14)] = inst_69954__$1);

(statearr_70123[(15)] = inst_69956__$1);

(statearr_70123[(20)] = inst_69955__$1);

return statearr_70123;
})();
var statearr_70124_70161 = state_70079__$1;
(statearr_70124_70161[(2)] = null);

(statearr_70124_70161[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (26))){
var inst_70051 = (state_70079[(29)]);
var inst_70056 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70057 = cljs.core.PersistentHashMap.EMPTY;
var inst_70058 = [true,inst_70057];
var inst_70059 = cljs.core.PersistentHashMap.fromArrays(inst_70056,inst_70058);
var inst_70060 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_70059,inst_70051);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70079__$1,(28),inst_70060);
} else {
if((state_val_70080 === (16))){
var inst_69987 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70125_70162 = state_70079__$1;
(statearr_70125_70162[(2)] = inst_69987);

(statearr_70125_70162[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (10))){
var inst_69989 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70126_70163 = state_70079__$1;
(statearr_70126_70163[(2)] = inst_69989);

(statearr_70126_70163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (18))){
var inst_69992 = (state_70079[(10)]);
var inst_70031 = (state_70079[(2)]);
var inst_70039 = cljs.core.vals(inst_69992);
var inst_70040 = cljs.core.seq(inst_70039);
var inst_70041 = cljs.core.first(inst_70040);
var inst_70042 = cljs.core.next(inst_70040);
var inst_70043 = cljs.core.PersistentVector.EMPTY;
var inst_70044 = inst_70039;
var inst_70045 = inst_70043;
var state_70079__$1 = (function (){var statearr_70127 = state_70079;
(statearr_70127[(26)] = inst_70045);

(statearr_70127[(28)] = inst_70044);

(statearr_70127[(13)] = inst_70031);

(statearr_70127[(30)] = inst_70041);

(statearr_70127[(31)] = inst_70042);

return statearr_70127;
})();
var statearr_70128_70164 = state_70079__$1;
(statearr_70128_70164[(2)] = null);

(statearr_70128_70164[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (8))){
var inst_69956 = (state_70079[(15)]);
var inst_69955 = (state_70079[(20)]);
var inst_69966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69967 = [inst_69955,inst_69956];
var inst_69968 = (new cljs.core.PersistentVector(null,2,(5),inst_69966,inst_69967,null));
var state_70079__$1 = state_70079;
var statearr_70129_70165 = state_70079__$1;
(statearr_70129_70165[(2)] = inst_69968);

(statearr_70129_70165[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_70130 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70130[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_70130[(1)] = (1));

return statearr_70130;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_70079){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70079);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70131){var ex__2730__auto__ = e70131;
var statearr_70132_70166 = state_70079;
(statearr_70132_70166[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70079[(4)]))){
var statearr_70133_70167 = state_70079;
(statearr_70133_70167[(1)] = cljs.core.first((state_70079[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70168 = state_70079;
state_70079 = G__70168;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_70079){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_70079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70134 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70134[(6)] = c__2749__auto__);

return statearr_70134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70200){
var state_val_70201 = (state_70200[(1)]);
if((state_val_70201 === (1))){
var inst_70169 = cljs.core.volatile_BANG_((0));
var inst_70170 = cljs.core.PersistentHashMap.EMPTY;
var inst_70171 = cljs.core.volatile_BANG_(inst_70170);
var inst_70172 = cljs.core.first(resp);
var inst_70173 = cljs.core.rest(resp);
var inst_70174 = cljs.core.PersistentVector.EMPTY;
var inst_70175 = inst_70169;
var inst_70176 = inst_70171;
var inst_70177 = inst_70172;
var inst_70178 = inst_70173;
var inst_70179 = inst_70174;
var state_70200__$1 = (function (){var statearr_70202 = state_70200;
(statearr_70202[(7)] = inst_70178);

(statearr_70202[(8)] = inst_70179);

(statearr_70202[(9)] = inst_70175);

(statearr_70202[(10)] = inst_70177);

(statearr_70202[(11)] = inst_70176);

return statearr_70202;
})();
var statearr_70203_70218 = state_70200__$1;
(statearr_70203_70218[(2)] = null);

(statearr_70203_70218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70201 === (2))){
var inst_70175 = (state_70200[(9)]);
var inst_70177 = (state_70200[(10)]);
var inst_70176 = (state_70200[(11)]);
var inst_70181 = fluree.db.api.query.format_block_resp_pretty(db,inst_70177,inst_70176,inst_70175);
var state_70200__$1 = state_70200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70200__$1,(4),inst_70181);
} else {
if((state_val_70201 === (3))){
var inst_70198 = (state_70200[(2)]);
var state_70200__$1 = state_70200;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70200__$1,inst_70198);
} else {
if((state_val_70201 === (4))){
var inst_70178 = (state_70200[(7)]);
var inst_70179 = (state_70200[(8)]);
var inst_70183 = (state_70200[(2)]);
var inst_70184 = fluree.db.util.async.throw_err(inst_70183);
var inst_70185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70186 = [inst_70184];
var inst_70187 = (new cljs.core.PersistentVector(null,1,(5),inst_70185,inst_70186,null));
var inst_70188 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_70179,inst_70187);
var inst_70189 = cljs.core.first(inst_70178);
var state_70200__$1 = (function (){var statearr_70206 = state_70200;
(statearr_70206[(12)] = inst_70188);

return statearr_70206;
})();
if(cljs.core.truth_(inst_70189)){
var statearr_70207_70219 = state_70200__$1;
(statearr_70207_70219[(1)] = (5));

} else {
var statearr_70208_70220 = state_70200__$1;
(statearr_70208_70220[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70201 === (5))){
var inst_70188 = (state_70200[(12)]);
var inst_70178 = (state_70200[(7)]);
var inst_70175 = (state_70200[(9)]);
var inst_70176 = (state_70200[(11)]);
var inst_70191 = cljs.core.first(inst_70178);
var inst_70192 = cljs.core.rest(inst_70178);
var tmp70204 = inst_70175;
var tmp70205 = inst_70176;
var inst_70175__$1 = tmp70204;
var inst_70176__$1 = tmp70205;
var inst_70177 = inst_70191;
var inst_70178__$1 = inst_70192;
var inst_70179 = inst_70188;
var state_70200__$1 = (function (){var statearr_70209 = state_70200;
(statearr_70209[(7)] = inst_70178__$1);

(statearr_70209[(8)] = inst_70179);

(statearr_70209[(9)] = inst_70175__$1);

(statearr_70209[(10)] = inst_70177);

(statearr_70209[(11)] = inst_70176__$1);

return statearr_70209;
})();
var statearr_70210_70221 = state_70200__$1;
(statearr_70210_70221[(2)] = null);

(statearr_70210_70221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70201 === (6))){
var inst_70188 = (state_70200[(12)]);
var state_70200__$1 = state_70200;
var statearr_70211_70222 = state_70200__$1;
(statearr_70211_70222[(2)] = inst_70188);

(statearr_70211_70222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70201 === (7))){
var inst_70196 = (state_70200[(2)]);
var state_70200__$1 = state_70200;
var statearr_70212_70223 = state_70200__$1;
(statearr_70212_70223[(2)] = inst_70196);

(statearr_70212_70223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_70213 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70213[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_70213[(1)] = (1));

return statearr_70213;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_70200){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70200);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70214){var ex__2730__auto__ = e70214;
var statearr_70215_70224 = state_70200;
(statearr_70215_70224[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70200[(4)]))){
var statearr_70216_70225 = state_70200;
(statearr_70216_70225[(1)] = cljs.core.first((state_70200[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70226 = state_70200;
state_70200 = G__70226;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_70200){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_70200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70217 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70217[(6)] = c__2749__auto__);

return statearr_70217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__70228 = arguments.length;
switch (G__70228) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__70230){
var map__70231 = p__70230;
var map__70231__$1 = cljs.core.__destructure_map(map__70231);
var query = map__70231__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70231__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70316){
var state_val_70317 = (state_70316[(1)]);
if((state_val_70317 === (7))){
var inst_70242 = (state_70316[(7)]);
var inst_70246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70247 = ["_auth/id",inst_70242];
var inst_70248 = (new cljs.core.PersistentVector(null,2,(5),inst_70246,inst_70247,null));
var state_70316__$1 = state_70316;
var statearr_70318_70362 = state_70316__$1;
(statearr_70318_70362[(2)] = inst_70248);

(statearr_70318_70362[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (20))){
var inst_70296 = (state_70316[(2)]);
var inst_70297 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_70316__$1 = (function (){var statearr_70319 = state_70316;
(statearr_70319[(8)] = inst_70296);

return statearr_70319;
})();
if(cljs.core.truth_(inst_70297)){
var statearr_70320_70363 = state_70316__$1;
(statearr_70320_70363[(1)] = (22));

} else {
var statearr_70321_70364 = state_70316__$1;
(statearr_70321_70364[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (27))){
var inst_70299 = (state_70316[(9)]);
var inst_70243 = (state_70316[(10)]);
var inst_70305 = (state_70316[(2)]);
var inst_70306 = fluree.db.util.core.response_time_formatted(inst_70243);
var inst_70307 = [(200),inst_70305,(100),inst_70306];
var inst_70308 = cljs.core.PersistentHashMap.fromArrays(inst_70299,inst_70307);
var state_70316__$1 = state_70316;
var statearr_70322_70365 = state_70316__$1;
(statearr_70322_70365[(2)] = inst_70308);

(statearr_70322_70365[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (1))){
var state_70316__$1 = state_70316;
var statearr_70323_70366 = state_70316__$1;
(statearr_70323_70366[(2)] = null);

(statearr_70323_70366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (24))){
var inst_70311 = (state_70316[(2)]);
var _ = (function (){var statearr_70324 = state_70316;
(statearr_70324[(4)] = cljs.core.rest((state_70316[(4)])));

return statearr_70324;
})();
var state_70316__$1 = state_70316;
var statearr_70325_70367 = state_70316__$1;
(statearr_70325_70367[(2)] = inst_70311);

(statearr_70325_70367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (4))){
var inst_70232 = (state_70316[(2)]);
var state_70316__$1 = state_70316;
var statearr_70326_70368 = state_70316__$1;
(statearr_70326_70368[(2)] = inst_70232);

(statearr_70326_70368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (15))){
var inst_70283 = (state_70316[(11)]);
var state_70316__$1 = state_70316;
var statearr_70327_70369 = state_70316__$1;
(statearr_70327_70369[(2)] = inst_70283);

(statearr_70327_70369[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (21))){
var inst_70292 = (state_70316[(2)]);
var inst_70293 = fluree.db.util.async.throw_err(inst_70292);
var state_70316__$1 = state_70316;
var statearr_70328_70370 = state_70316__$1;
(statearr_70328_70370[(2)] = inst_70293);

(statearr_70328_70370[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (13))){
var inst_70283 = (state_70316[(11)]);
var inst_70241 = (state_70316[(12)]);
var inst_70282 = (state_70316[(2)]);
var inst_70283__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_70241);
var state_70316__$1 = (function (){var statearr_70329 = state_70316;
(statearr_70329[(11)] = inst_70283__$1);

(statearr_70329[(13)] = inst_70282);

return statearr_70329;
})();
if(cljs.core.truth_(inst_70283__$1)){
var statearr_70330_70371 = state_70316__$1;
(statearr_70330_70371[(1)] = (15));

} else {
var statearr_70331_70372 = state_70316__$1;
(statearr_70331_70372[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (22))){
var inst_70296 = (state_70316[(8)]);
var inst_70299 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70300 = cljs.core.sequential_QMARK_(inst_70296);
var state_70316__$1 = (function (){var statearr_70332 = state_70316;
(statearr_70332[(9)] = inst_70299);

return statearr_70332;
})();
if(inst_70300){
var statearr_70333_70373 = state_70316__$1;
(statearr_70333_70373[(1)] = (25));

} else {
var statearr_70334_70374 = state_70316__$1;
(statearr_70334_70374[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (6))){
var inst_70257 = (state_70316[(14)]);
var inst_70241 = (state_70316[(12)]);
var inst_70256 = (state_70316[(2)]);
var inst_70257__$1 = fluree.db.util.async.throw_err(inst_70256);
var inst_70258 = fluree.db.api.query.resolve_block_range(inst_70257__$1,inst_70241);
var state_70316__$1 = (function (){var statearr_70335 = state_70316;
(statearr_70335[(14)] = inst_70257__$1);

return statearr_70335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70316__$1,(10),inst_70258);
} else {
if((state_val_70317 === (25))){
var inst_70296 = (state_70316[(8)]);
var inst_70302 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_70296);
var state_70316__$1 = state_70316;
var statearr_70336_70375 = state_70316__$1;
(statearr_70336_70375[(2)] = inst_70302);

(statearr_70336_70375[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (17))){
var inst_70288 = (state_70316[(2)]);
var state_70316__$1 = state_70316;
if(cljs.core.truth_(inst_70288)){
var statearr_70337_70376 = state_70316__$1;
(statearr_70337_70376[(1)] = (18));

} else {
var statearr_70338_70377 = state_70316__$1;
(statearr_70338_70377[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (3))){
var inst_70314 = (state_70316[(2)]);
var state_70316__$1 = state_70316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70316__$1,inst_70314);
} else {
if((state_val_70317 === (12))){
var inst_70241 = (state_70316[(12)]);
var inst_70274 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70241], 0));
var inst_70275 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_70274].join('');
var inst_70276 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70277 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70278 = cljs.core.PersistentHashMap.fromArrays(inst_70276,inst_70277);
var inst_70279 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70275,inst_70278);
var inst_70280 = (function(){throw inst_70279})();
var state_70316__$1 = state_70316;
var statearr_70339_70378 = state_70316__$1;
(statearr_70339_70378[(2)] = inst_70280);

(statearr_70339_70378[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (2))){
var inst_70242 = (state_70316[(7)]);
var _ = (function (){var statearr_70340 = state_70316;
(statearr_70340[(4)] = cljs.core.cons((5),(state_70316[(4)])));

return statearr_70340;
})();
var inst_70241 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70242__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70243 = fluree.db.util.core.current_time_millis();
var inst_70244 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_70316__$1 = (function (){var statearr_70341 = state_70316;
(statearr_70341[(12)] = inst_70241);

(statearr_70341[(15)] = inst_70244);

(statearr_70341[(7)] = inst_70242__$1);

(statearr_70341[(10)] = inst_70243);

return statearr_70341;
})();
if(cljs.core.truth_(inst_70242__$1)){
var statearr_70342_70379 = state_70316__$1;
(statearr_70342_70379[(1)] = (7));

} else {
var statearr_70343_70380 = state_70316__$1;
(statearr_70343_70380[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (23))){
var inst_70296 = (state_70316[(8)]);
var state_70316__$1 = state_70316;
var statearr_70344_70381 = state_70316__$1;
(statearr_70344_70381[(2)] = inst_70296);

(statearr_70344_70381[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (19))){
var inst_70282 = (state_70316[(13)]);
var state_70316__$1 = state_70316;
var statearr_70345_70382 = state_70316__$1;
(statearr_70345_70382[(2)] = inst_70282);

(statearr_70345_70382[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (11))){
var inst_70263 = (state_70316[(16)]);
var inst_70257 = (state_70316[(14)]);
var inst_70262 = (state_70316[(17)]);
var inst_70269 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_70257,inst_70262,inst_70263,opts);
var state_70316__$1 = state_70316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70316__$1,(14),inst_70269);
} else {
if((state_val_70317 === (9))){
var inst_70244 = (state_70316[(15)]);
var inst_70251 = (state_70316[(2)]);
var inst_70252 = [inst_70251];
var inst_70253 = cljs.core.PersistentHashMap.fromArrays(inst_70244,inst_70252);
var inst_70254 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_70253);
var state_70316__$1 = state_70316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70316__$1,(6),inst_70254);
} else {
if((state_val_70317 === (5))){
var _ = (function (){var statearr_70347 = state_70316;
(statearr_70347[(4)] = cljs.core.rest((state_70316[(4)])));

return statearr_70347;
})();
var state_70316__$1 = state_70316;
var ex70346 = (state_70316__$1[(2)]);
var statearr_70348_70383 = state_70316__$1;
(statearr_70348_70383[(5)] = ex70346);


if((ex70346 instanceof Error)){
var statearr_70349_70384 = state_70316__$1;
(statearr_70349_70384[(1)] = (4));

(statearr_70349_70384[(5)] = null);

} else {
throw ex70346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (14))){
var inst_70271 = (state_70316[(2)]);
var inst_70272 = fluree.db.util.async.throw_err(inst_70271);
var state_70316__$1 = state_70316;
var statearr_70350_70385 = state_70316__$1;
(statearr_70350_70385[(2)] = inst_70272);

(statearr_70350_70385[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (26))){
var inst_70296 = (state_70316[(8)]);
var state_70316__$1 = state_70316;
var statearr_70351_70386 = state_70316__$1;
(statearr_70351_70386[(2)] = inst_70296);

(statearr_70351_70386[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (16))){
var inst_70241 = (state_70316[(12)]);
var inst_70286 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_70241);
var state_70316__$1 = state_70316;
var statearr_70352_70387 = state_70316__$1;
(statearr_70352_70387[(2)] = inst_70286);

(statearr_70352_70387[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (10))){
var inst_70241 = (state_70316[(12)]);
var inst_70260 = (state_70316[(2)]);
var inst_70261 = fluree.db.util.async.throw_err(inst_70260);
var inst_70262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70261,(0),null);
var inst_70263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70261,(1),null);
var inst_70264 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_70265 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_70241,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_70266 = cljs.core.keys(inst_70265);
var inst_70267 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70264,inst_70266);
var state_70316__$1 = (function (){var statearr_70353 = state_70316;
(statearr_70353[(16)] = inst_70263);

(statearr_70353[(17)] = inst_70262);

return statearr_70353;
})();
if(inst_70267){
var statearr_70354_70388 = state_70316__$1;
(statearr_70354_70388[(1)] = (11));

} else {
var statearr_70355_70389 = state_70316__$1;
(statearr_70355_70389[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70317 === (18))){
var inst_70257 = (state_70316[(14)]);
var inst_70282 = (state_70316[(13)]);
var inst_70290 = fluree.db.api.query.format_blocks_resp_pretty(inst_70257,inst_70282);
var state_70316__$1 = state_70316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70316__$1,(21),inst_70290);
} else {
if((state_val_70317 === (8))){
var state_70316__$1 = state_70316;
var statearr_70356_70390 = state_70316__$1;
(statearr_70356_70390[(2)] = null);

(statearr_70356_70390[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70357[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_70357[(1)] = (1));

return statearr_70357;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_70316){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70316);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70358){var ex__2730__auto__ = e70358;
var statearr_70359_70391 = state_70316;
(statearr_70359_70391[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70316[(4)]))){
var statearr_70360_70392 = state_70316;
(statearr_70360_70392[(1)] = cljs.core.first((state_70316[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70393 = state_70316;
state_70316 = G__70393;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_70316){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_70316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70361 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70361[(6)] = c__2749__auto__);

return statearr_70361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__70394 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70394,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70394,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70394,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70394,(3),null);
var vec__70397 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70397,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70397,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__70400 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70400,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70400,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70404 = arguments.length;
var i__5770__auto___70405 = (0);
while(true){
if((i__5770__auto___70405 < len__5769__auto___70404)){
args__5775__auto__.push((arguments[i__5770__auto___70405]));

var G__70406 = (i__5770__auto___70405 + (1));
i__5770__auto___70405 = G__70406;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq70403){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq70403));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70602){
var state_val_70603 = (state_70602[(1)]);
if((state_val_70603 === (7))){
var inst_70522 = (state_70602[(7)]);
var inst_70529 = (state_70602[(8)]);
var inst_70528 = cljs.core.seq(inst_70522);
var inst_70529__$1 = cljs.core.first(inst_70528);
var inst_70530 = cljs.core.next(inst_70528);
var state_70602__$1 = (function (){var statearr_70604 = state_70602;
(statearr_70604[(8)] = inst_70529__$1);

(statearr_70604[(9)] = inst_70530);

return statearr_70604;
})();
if(cljs.core.truth_(inst_70529__$1)){
var statearr_70605_70705 = state_70602__$1;
(statearr_70605_70705[(1)] = (9));

} else {
var statearr_70606_70706 = state_70602__$1;
(statearr_70606_70706[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (20))){
var inst_70592 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
var statearr_70607_70707 = state_70602__$1;
(statearr_70607_70707[(2)] = inst_70592);

(statearr_70607_70707[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (27))){
var inst_70568 = (state_70602[(10)]);
var inst_70547 = (state_70602[(11)]);
var inst_70550 = (state_70602[(12)]);
var inst_70570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70571 = [inst_70550,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70572 = (new cljs.core.PersistentVector(null,2,(5),inst_70570,inst_70571,null));
var inst_70573 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70568,inst_70572,fluree.db.api.query.min_safe,inst_70547);
var state_70602__$1 = state_70602;
var statearr_70608_70708 = state_70602__$1;
(statearr_70608_70708[(2)] = inst_70573);

(statearr_70608_70708[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (1))){
var state_70602__$1 = state_70602;
var statearr_70609_70709 = state_70602__$1;
(statearr_70609_70709[(2)] = null);

(statearr_70609_70709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (24))){
var inst_70560 = (state_70602[(13)]);
var inst_70529 = (state_70602[(8)]);
var inst_70550 = (state_70602[(12)]);
var inst_70562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70563 = [inst_70550,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70564 = (new cljs.core.PersistentVector(null,2,(5),inst_70562,inst_70563,null));
var inst_70565 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70560,inst_70564,cljs.core.conj,inst_70529);
var state_70602__$1 = state_70602;
var statearr_70611_70710 = state_70602__$1;
(statearr_70611_70710[(2)] = inst_70565);

(statearr_70611_70710[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (4))){
var inst_70408 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
var statearr_70612_70711 = state_70602__$1;
(statearr_70612_70711[(2)] = inst_70408);

(statearr_70612_70711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (15))){
var inst_70523 = (state_70602[(14)]);
var inst_70530 = (state_70602[(9)]);
var tmp70610 = inst_70523;
var inst_70522 = inst_70530;
var inst_70523__$1 = tmp70610;
var state_70602__$1 = (function (){var statearr_70613 = state_70602;
(statearr_70613[(7)] = inst_70522);

(statearr_70613[(14)] = inst_70523__$1);

return statearr_70613;
})();
var statearr_70614_70712 = state_70602__$1;
(statearr_70614_70712[(2)] = null);

(statearr_70614_70712[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (21))){
var inst_70523 = (state_70602[(14)]);
var inst_70550 = (state_70602[(12)]);
var inst_70554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70555 = [inst_70550,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70556 = (new cljs.core.PersistentVector(null,2,(5),inst_70554,inst_70555,null));
var inst_70557 = cljs.core.assoc_in(inst_70523,inst_70556,inst_70550);
var state_70602__$1 = state_70602;
var statearr_70615_70713 = state_70602__$1;
(statearr_70615_70713[(2)] = inst_70557);

(statearr_70615_70713[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (31))){
var inst_70576 = (state_70602[(15)]);
var state_70602__$1 = state_70602;
var statearr_70616_70714 = state_70602__$1;
(statearr_70616_70714[(2)] = inst_70576);

(statearr_70616_70714[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (32))){
var inst_70530 = (state_70602[(9)]);
var inst_70584 = (state_70602[(2)]);
var inst_70522 = inst_70530;
var inst_70523 = inst_70584;
var state_70602__$1 = (function (){var statearr_70617 = state_70602;
(statearr_70617[(7)] = inst_70522);

(statearr_70617[(14)] = inst_70523);

return statearr_70617;
})();
var statearr_70618_70715 = state_70602__$1;
(statearr_70618_70715[(2)] = null);

(statearr_70618_70715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (33))){
var inst_70523 = (state_70602[(14)]);
var state_70602__$1 = state_70602;
var statearr_70619_70716 = state_70602__$1;
(statearr_70619_70716[(2)] = inst_70523);

(statearr_70619_70716[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (13))){
var inst_70532 = (state_70602[(16)]);
var state_70602__$1 = state_70602;
var statearr_70620_70717 = state_70602__$1;
(statearr_70620_70717[(2)] = inst_70532);

(statearr_70620_70717[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (22))){
var inst_70523 = (state_70602[(14)]);
var state_70602__$1 = state_70602;
var statearr_70621_70718 = state_70602__$1;
(statearr_70621_70718[(2)] = inst_70523);

(statearr_70621_70718[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (29))){
var inst_70576 = (state_70602[(2)]);
var state_70602__$1 = (function (){var statearr_70622 = state_70602;
(statearr_70622[(15)] = inst_70576);

return statearr_70622;
})();
if(cljs.core.truth_(show_auth)){
var statearr_70623_70719 = state_70602__$1;
(statearr_70623_70719[(1)] = (30));

} else {
var statearr_70624_70720 = state_70602__$1;
(statearr_70624_70720[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (6))){
var inst_70508 = (state_70602[(2)]);
var inst_70509 = fluree.db.util.async.throw_err(inst_70508);
var inst_70517 = resp;
var inst_70518 = cljs.core.seq(inst_70517);
var inst_70519 = cljs.core.first(inst_70518);
var inst_70520 = cljs.core.next(inst_70518);
var inst_70521 = cljs.core.PersistentHashMap.EMPTY;
var inst_70522 = inst_70517;
var inst_70523 = inst_70521;
var state_70602__$1 = (function (){var statearr_70625 = state_70602;
(statearr_70625[(7)] = inst_70522);

(statearr_70625[(14)] = inst_70523);

(statearr_70625[(17)] = inst_70509);

(statearr_70625[(18)] = inst_70520);

(statearr_70625[(19)] = inst_70519);

return statearr_70625;
})();
var statearr_70626_70721 = state_70602__$1;
(statearr_70626_70721[(2)] = null);

(statearr_70626_70721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (28))){
var inst_70568 = (state_70602[(10)]);
var state_70602__$1 = state_70602;
var statearr_70627_70722 = state_70602__$1;
(statearr_70627_70722[(2)] = inst_70568);

(statearr_70627_70722[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (25))){
var inst_70560 = (state_70602[(13)]);
var state_70602__$1 = state_70602;
var statearr_70628_70723 = state_70602__$1;
(statearr_70628_70723[(2)] = inst_70560);

(statearr_70628_70723[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (34))){
var state_70602__$1 = state_70602;
var statearr_70629_70724 = state_70602__$1;
(statearr_70629_70724[(2)] = null);

(statearr_70629_70724[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (17))){
var inst_70594 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
var statearr_70630_70725 = state_70602__$1;
(statearr_70630_70725[(2)] = inst_70594);

(statearr_70630_70725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (3))){
var inst_70600 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70602__$1,inst_70600);
} else {
if((state_val_70603 === (12))){
var inst_70509 = (state_70602[(17)]);
var inst_70529 = (state_70602[(8)]);
var inst_70534 = fluree.db.api.query.auth_match(auth,inst_70509,inst_70529);
var inst_70535 = cljs.core.not(inst_70534);
var state_70602__$1 = state_70602;
var statearr_70631_70726 = state_70602__$1;
(statearr_70631_70726[(2)] = inst_70535);

(statearr_70631_70726[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (2))){
var _ = (function (){var statearr_70632 = state_70602;
(statearr_70632[(4)] = cljs.core.cons((5),(state_70602[(4)])));

return statearr_70632;
})();
var inst_70414 = (function (){return (function (p1__70407_SHARP_){
return fluree.db.flake.t(p1__70407_SHARP_);
});
})();
var inst_70415 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_70414,resp);
var inst_70416 = cljs.core.set(inst_70415);
var inst_70504 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70505 = (function (){var ts = inst_70416;
var c__2749__auto____$1 = inst_70504;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70502){
var state_val_70503 = (state_70502[(1)]);
if((state_val_70503 === (7))){
var inst_70430 = (state_70502[(7)]);
var inst_70436 = (state_70502[(8)]);
var inst_70442 = (state_70502[(9)]);
var inst_70448 = (state_70502[(10)]);
var inst_70441 = (state_70502[(2)]);
var inst_70442__$1 = fluree.db.util.async.throw_err(inst_70441);
var inst_70444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70445 = [inst_70436,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70446 = (new cljs.core.PersistentVector(null,2,(5),inst_70444,inst_70445,null));
var inst_70447 = cljs.core.assoc_in(inst_70430,inst_70446,inst_70442__$1);
var inst_70448__$1 = auth;
var state_70502__$1 = (function (){var statearr_70633 = state_70502;
(statearr_70633[(9)] = inst_70442__$1);

(statearr_70633[(10)] = inst_70448__$1);

(statearr_70633[(11)] = inst_70447);

return statearr_70633;
})();
if(cljs.core.truth_(inst_70448__$1)){
var statearr_70634_70727 = state_70502__$1;
(statearr_70634_70727[(1)] = (8));

} else {
var statearr_70635_70728 = state_70502__$1;
(statearr_70635_70728[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (1))){
var inst_70424 = (state_70502[(12)]);
var inst_70424__$1 = ts;
var inst_70425 = cljs.core.seq(inst_70424__$1);
var inst_70426 = cljs.core.first(inst_70425);
var inst_70427 = cljs.core.next(inst_70425);
var inst_70428 = cljs.core.PersistentHashMap.EMPTY;
var inst_70429 = inst_70424__$1;
var inst_70430 = inst_70428;
var state_70502__$1 = (function (){var statearr_70636 = state_70502;
(statearr_70636[(12)] = inst_70424__$1);

(statearr_70636[(7)] = inst_70430);

(statearr_70636[(13)] = inst_70429);

(statearr_70636[(14)] = inst_70427);

(statearr_70636[(15)] = inst_70426);

return statearr_70636;
})();
var statearr_70637_70729 = state_70502__$1;
(statearr_70637_70729[(2)] = null);

(statearr_70637_70729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (4))){
var inst_70436 = (state_70502[(8)]);
var inst_70439 = fluree.db.time_travel.non_border_t_to_block(db,inst_70436);
var state_70502__$1 = state_70502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70502__$1,(7),inst_70439);
} else {
if((state_val_70503 === (13))){
var inst_70437 = (state_70502[(16)]);
var inst_70494 = (state_70502[(2)]);
var inst_70429 = inst_70437;
var inst_70430 = inst_70494;
var state_70502__$1 = (function (){var statearr_70638 = state_70502;
(statearr_70638[(7)] = inst_70430);

(statearr_70638[(13)] = inst_70429);

return statearr_70638;
})();
var statearr_70639_70730 = state_70502__$1;
(statearr_70639_70730[(2)] = null);

(statearr_70639_70730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (6))){
var inst_70498 = (state_70502[(2)]);
var state_70502__$1 = state_70502;
var statearr_70640_70731 = state_70502__$1;
(statearr_70640_70731[(2)] = inst_70498);

(statearr_70640_70731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (3))){
var inst_70500 = (state_70502[(2)]);
var state_70502__$1 = state_70502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70502__$1,inst_70500);
} else {
if((state_val_70503 === (12))){
var inst_70447 = (state_70502[(11)]);
var state_70502__$1 = state_70502;
var statearr_70641_70732 = state_70502__$1;
(statearr_70641_70732[(2)] = inst_70447);

(statearr_70641_70732[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (2))){
var inst_70429 = (state_70502[(13)]);
var inst_70436 = (state_70502[(8)]);
var inst_70435 = cljs.core.seq(inst_70429);
var inst_70436__$1 = cljs.core.first(inst_70435);
var inst_70437 = cljs.core.next(inst_70435);
var state_70502__$1 = (function (){var statearr_70642 = state_70502;
(statearr_70642[(16)] = inst_70437);

(statearr_70642[(8)] = inst_70436__$1);

return statearr_70642;
})();
if(cljs.core.truth_(inst_70436__$1)){
var statearr_70643_70733 = state_70502__$1;
(statearr_70643_70733[(1)] = (4));

} else {
var statearr_70644_70734 = state_70502__$1;
(statearr_70644_70734[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (11))){
var inst_70424 = (state_70502[(12)]);
var inst_70430 = (state_70502[(7)]);
var inst_70437 = (state_70502[(16)]);
var inst_70429 = (state_70502[(13)]);
var inst_70436 = (state_70502[(8)]);
var inst_70427 = (state_70502[(14)]);
var inst_70442 = (state_70502[(9)]);
var inst_70447 = (state_70502[(11)]);
var inst_70426 = (state_70502[(15)]);
var inst_70454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70455 = [inst_70436,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70456 = (new cljs.core.PersistentVector(null,2,(5),inst_70454,inst_70455,null));
var inst_70469 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70470 = (function (){var t = inst_70436;
var c__2749__auto____$2 = inst_70469;
var G__70420 = inst_70429;
var first__70423 = inst_70426;
var block = inst_70442;
var r = inst_70437;
var seq__70433 = inst_70437;
var vec__70432 = inst_70429;
var seq__70422 = inst_70427;
var acc = inst_70430;
var first__70434 = inst_70436;
var G__70443 = inst_70447;
var vec__70421 = inst_70424;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70467){
var state_val_70468 = (state_70467[(1)]);
if((state_val_70468 === (1))){
var state_70467__$1 = state_70467;
var statearr_70645_70735 = state_70467__$1;
(statearr_70645_70735[(2)] = null);

(statearr_70645_70735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70468 === (2))){
var ___$1 = (function (){var statearr_70646 = state_70467;
(statearr_70646[(4)] = cljs.core.cons((5),(state_70467[(4)])));

return statearr_70646;
})();
var ___$2 = (function (){var statearr_70647 = state_70467;
(statearr_70647[(4)] = cljs.core.rest((state_70467[(4)])));

return statearr_70647;
})();
var state_70467__$1 = state_70467;
var statearr_70648_70736 = state_70467__$1;
(statearr_70648_70736[(2)] = db);

(statearr_70648_70736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70468 === (3))){
var inst_70465 = (state_70467[(2)]);
var state_70467__$1 = state_70467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70467__$1,inst_70465);
} else {
if((state_val_70468 === (4))){
var inst_70457 = (state_70467[(2)]);
var state_70467__$1 = state_70467;
var statearr_70650_70737 = state_70467__$1;
(statearr_70650_70737[(2)] = inst_70457);

(statearr_70650_70737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70468 === (5))){
var ___$1 = (function (){var statearr_70651 = state_70467;
(statearr_70651[(4)] = cljs.core.rest((state_70467[(4)])));

return statearr_70651;
})();
var state_70467__$1 = state_70467;
var ex70649 = (state_70467__$1[(2)]);
var statearr_70652_70738 = state_70467__$1;
(statearr_70652_70738[(5)] = ex70649);


if((ex70649 instanceof Error)){
var statearr_70653_70739 = state_70467__$1;
(statearr_70653_70739[(1)] = (4));

(statearr_70653_70739[(5)] = null);

} else {
throw ex70649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70654 = [null,null,null,null,null,null,null];
(statearr_70654[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70654[(1)] = (1));

return statearr_70654;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70467){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70467);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70655){var ex__2730__auto__ = e70655;
var statearr_70656_70740 = state_70467;
(statearr_70656_70740[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70467[(4)]))){
var statearr_70657_70741 = state_70467;
(statearr_70657_70741[(1)] = cljs.core.first((state_70467[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70742 = state_70467;
state_70467 = G__70742;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70467){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70658 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70658[(6)] = c__2749__auto____$2);

return statearr_70658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_70471 = cljs.core.async.impl.dispatch.run(inst_70470);
var inst_70472 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_70473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70474 = ["?auth","?id"];
var inst_70475 = (new cljs.core.PersistentVector(null,2,(5),inst_70473,inst_70474,null));
var inst_70476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70478 = [inst_70436,"_tx/auth","?auth"];
var inst_70479 = (new cljs.core.PersistentVector(null,3,(5),inst_70477,inst_70478,null));
var inst_70480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70481 = ["?auth","_auth/id","?id"];
var inst_70482 = (new cljs.core.PersistentVector(null,3,(5),inst_70480,inst_70481,null));
var inst_70483 = [inst_70479,inst_70482];
var inst_70484 = (new cljs.core.PersistentVector(null,2,(5),inst_70476,inst_70483,null));
var inst_70485 = [inst_70475,inst_70484];
var inst_70486 = cljs.core.PersistentHashMap.fromArrays(inst_70472,inst_70485);
var inst_70487 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_70469,inst_70486) : fluree.db.api.query.query_async.call(null,inst_70469,inst_70486));
var state_70502__$1 = (function (){var statearr_70659 = state_70502;
(statearr_70659[(17)] = inst_70456);

(statearr_70659[(18)] = inst_70471);

return statearr_70659;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70502__$1,(14),inst_70487);
} else {
if((state_val_70503 === (9))){
var state_70502__$1 = state_70502;
var statearr_70660_70743 = state_70502__$1;
(statearr_70660_70743[(2)] = show_auth);

(statearr_70660_70743[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (5))){
var inst_70430 = (state_70502[(7)]);
var state_70502__$1 = state_70502;
var statearr_70661_70744 = state_70502__$1;
(statearr_70661_70744[(2)] = inst_70430);

(statearr_70661_70744[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (14))){
var inst_70456 = (state_70502[(17)]);
var inst_70447 = (state_70502[(11)]);
var inst_70489 = (state_70502[(2)]);
var inst_70490 = fluree.db.util.async.throw_err(inst_70489);
var inst_70491 = cljs.core.assoc_in(inst_70447,inst_70456,inst_70490);
var state_70502__$1 = state_70502;
var statearr_70662_70745 = state_70502__$1;
(statearr_70662_70745[(2)] = inst_70491);

(statearr_70662_70745[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (10))){
var inst_70452 = (state_70502[(2)]);
var state_70502__$1 = state_70502;
if(cljs.core.truth_(inst_70452)){
var statearr_70663_70746 = state_70502__$1;
(statearr_70663_70746[(1)] = (11));

} else {
var statearr_70664_70747 = state_70502__$1;
(statearr_70664_70747[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (8))){
var inst_70448 = (state_70502[(10)]);
var state_70502__$1 = state_70502;
var statearr_70665_70748 = state_70502__$1;
(statearr_70665_70748[(2)] = inst_70448);

(statearr_70665_70748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70666[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70666[(1)] = (1));

return statearr_70666;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70502){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70502);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70667){var ex__2730__auto__ = e70667;
var statearr_70668_70749 = state_70502;
(statearr_70668_70749[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70502[(4)]))){
var statearr_70669_70750 = state_70502;
(statearr_70669_70750[(1)] = cljs.core.first((state_70502[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70751 = state_70502;
state_70502 = G__70751;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70502){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70670 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70670[(6)] = c__2749__auto____$1);

return statearr_70670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_70506 = cljs.core.async.impl.dispatch.run(inst_70505);
var state_70602__$1 = (function (){var statearr_70671 = state_70602;
(statearr_70671[(20)] = inst_70506);

return statearr_70671;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70602__$1,(6),inst_70504);
} else {
if((state_val_70603 === (23))){
var inst_70560 = (state_70602[(2)]);
var state_70602__$1 = (function (){var statearr_70672 = state_70602;
(statearr_70672[(13)] = inst_70560);

return statearr_70672;
})();
var statearr_70673_70752 = state_70602__$1;
(statearr_70673_70752[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (35))){
var inst_70590 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
var statearr_70675_70753 = state_70602__$1;
(statearr_70675_70753[(2)] = inst_70590);

(statearr_70675_70753[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (19))){
var state_70602__$1 = state_70602;
var statearr_70676_70754 = state_70602__$1;
(statearr_70676_70754[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (11))){
var inst_70541 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
if(cljs.core.truth_(inst_70541)){
var statearr_70679_70755 = state_70602__$1;
(statearr_70679_70755[(1)] = (15));

} else {
var statearr_70680_70756 = state_70602__$1;
(statearr_70680_70756[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (9))){
var inst_70532 = (state_70602[(16)]);
var inst_70532__$1 = auth;
var state_70602__$1 = (function (){var statearr_70681 = state_70602;
(statearr_70681[(16)] = inst_70532__$1);

return statearr_70681;
})();
if(cljs.core.truth_(inst_70532__$1)){
var statearr_70682_70757 = state_70602__$1;
(statearr_70682_70757[(1)] = (12));

} else {
var statearr_70683_70758 = state_70602__$1;
(statearr_70683_70758[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (5))){
var _ = (function (){var statearr_70684 = state_70602;
(statearr_70684[(4)] = cljs.core.rest((state_70602[(4)])));

return statearr_70684;
})();
var state_70602__$1 = state_70602;
var ex70678 = (state_70602__$1[(2)]);
var statearr_70685_70759 = state_70602__$1;
(statearr_70685_70759[(5)] = ex70678);


if((ex70678 instanceof Error)){
var statearr_70686_70760 = state_70602__$1;
(statearr_70686_70760[(1)] = (4));

(statearr_70686_70760[(5)] = null);

} else {
throw ex70678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (14))){
var inst_70538 = (state_70602[(2)]);
var state_70602__$1 = state_70602;
var statearr_70687_70761 = state_70602__$1;
(statearr_70687_70761[(2)] = inst_70538);

(statearr_70687_70761[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (26))){
var inst_70568 = (state_70602[(2)]);
var state_70602__$1 = (function (){var statearr_70688 = state_70602;
(statearr_70688[(10)] = inst_70568);

return statearr_70688;
})();
var statearr_70689_70762 = state_70602__$1;
(statearr_70689_70762[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (16))){
var inst_70529 = (state_70602[(8)]);
var state_70602__$1 = state_70602;
if(cljs.core.truth_(inst_70529)){
var statearr_70691_70763 = state_70602__$1;
(statearr_70691_70763[(1)] = (18));

} else {
var statearr_70692_70764 = state_70602__$1;
(statearr_70692_70764[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (30))){
var inst_70551 = (state_70602[(21)]);
var inst_70550 = (state_70602[(12)]);
var inst_70576 = (state_70602[(15)]);
var inst_70578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70579 = [inst_70550,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70580 = (new cljs.core.PersistentVector(null,2,(5),inst_70578,inst_70579,null));
var inst_70581 = cljs.core.assoc_in(inst_70576,inst_70580,inst_70551);
var state_70602__$1 = state_70602;
var statearr_70693_70765 = state_70602__$1;
(statearr_70693_70765[(2)] = inst_70581);

(statearr_70693_70765[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (10))){
var inst_70529 = (state_70602[(8)]);
var state_70602__$1 = state_70602;
var statearr_70694_70766 = state_70602__$1;
(statearr_70694_70766[(2)] = inst_70529);

(statearr_70694_70766[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (18))){
var inst_70547 = (state_70602[(11)]);
var inst_70509 = (state_70602[(17)]);
var inst_70529 = (state_70602[(8)]);
var inst_70547__$1 = fluree.db.flake.t(inst_70529);
var inst_70548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70509,inst_70547__$1);
var inst_70549 = cljs.core.__destructure_map(inst_70548);
var inst_70550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70549,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70551 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70549,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_70602__$1 = (function (){var statearr_70695 = state_70602;
(statearr_70695[(21)] = inst_70551);

(statearr_70695[(11)] = inst_70547__$1);

(statearr_70695[(12)] = inst_70550);

return statearr_70695;
})();
var statearr_70696_70767 = state_70602__$1;
(statearr_70696_70767[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70603 === (8))){
var inst_70596 = (state_70602[(2)]);
var inst_70597 = cljs.core.vals(inst_70596);
var _ = (function (){var statearr_70698 = state_70602;
(statearr_70698[(4)] = cljs.core.rest((state_70602[(4)])));

return statearr_70698;
})();
var state_70602__$1 = state_70602;
var statearr_70699_70768 = state_70602__$1;
(statearr_70699_70768[(2)] = inst_70597);

(statearr_70699_70768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70700 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70700[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70700[(1)] = (1));

return statearr_70700;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70602){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70602);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70701){var ex__2730__auto__ = e70701;
var statearr_70702_70769 = state_70602;
(statearr_70702_70769[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70602[(4)]))){
var statearr_70703_70770 = state_70602;
(statearr_70703_70770[(1)] = cljs.core.first((state_70602[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70771 = state_70602;
state_70602 = G__70771;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70602){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70704 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70704[(6)] = c__2749__auto__);

return statearr_70704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70895){
var state_val_70896 = (state_70895[(1)]);
if((state_val_70896 === (7))){
var inst_70794 = (state_70895[(7)]);
var inst_70796 = fluree.db.api.query.resolve_block_range(inst_70794,query_map);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(10),inst_70796);
} else {
if((state_val_70896 === (20))){
var inst_70820 = (state_70895[(2)]);
var inst_70821 = fluree.db.util.async.throw_err(inst_70820);
var inst_70822 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70821);
var inst_70823 = (inst_70822 - (1));
var state_70895__$1 = state_70895;
var statearr_70897_70960 = state_70895__$1;
(statearr_70897_70960[(2)] = inst_70823);

(statearr_70897_70960[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (27))){
var state_70895__$1 = state_70895;
var statearr_70898_70961 = state_70895__$1;
(statearr_70898_70961[(2)] = null);

(statearr_70898_70961[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (1))){
var state_70895__$1 = state_70895;
var statearr_70899_70962 = state_70895__$1;
(statearr_70899_70962[(2)] = null);

(statearr_70899_70962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (24))){
var inst_70830 = (state_70895[(2)]);
var inst_70831 = fluree.db.util.async.throw_err(inst_70830);
var inst_70832 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70831);
var state_70895__$1 = state_70895;
var statearr_70900_70963 = state_70895__$1;
(statearr_70900_70963[(2)] = inst_70832);

(statearr_70900_70963[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (39))){
var inst_70867 = (state_70895[(2)]);
var inst_70868 = fluree.db.util.async.throw_err(inst_70867);
var state_70895__$1 = state_70895;
var statearr_70901_70964 = state_70895__$1;
(statearr_70901_70964[(2)] = inst_70868);

(statearr_70901_70964[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (4))){
var inst_70772 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
var statearr_70902_70965 = state_70895__$1;
(statearr_70902_70965[(2)] = inst_70772);

(statearr_70902_70965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (15))){
var inst_70803 = (state_70895[(8)]);
var state_70895__$1 = state_70895;
var statearr_70903_70966 = state_70895__$1;
(statearr_70903_70966[(2)] = inst_70803);

(statearr_70903_70966[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (21))){
var inst_70804 = (state_70895[(9)]);
var inst_70794 = (state_70895[(7)]);
var inst_70828 = fluree.db.time_travel.as_of_block(inst_70794,inst_70804);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(24),inst_70828);
} else {
if((state_val_70896 === (31))){
var inst_70788 = (state_70895[(10)]);
var state_70895__$1 = state_70895;
var statearr_70904_70967 = state_70895__$1;
(statearr_70904_70967[(2)] = inst_70788);

(statearr_70904_70967[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (32))){
var inst_70846 = (state_70895[(11)]);
var inst_70851 = (state_70895[(12)]);
var inst_70794 = (state_70895[(7)]);
var inst_70855 = (state_70895[(2)]);
var inst_70856 = fluree.db.api.query.format_history_resp(inst_70794,inst_70846,inst_70851,inst_70855);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(29),inst_70856);
} else {
if((state_val_70896 === (40))){
var inst_70872 = (state_70895[(13)]);
var inst_70846 = (state_70895[(11)]);
var inst_70874 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70875 = cljs.core.count(inst_70846);
var inst_70876 = [inst_70872,inst_70875,(200)];
var inst_70877 = cljs.core.PersistentHashMap.fromArrays(inst_70874,inst_70876);
var state_70895__$1 = state_70895;
var statearr_70905_70968 = state_70895__$1;
(statearr_70905_70968[(2)] = inst_70877);

(statearr_70905_70968[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (33))){
var inst_70787 = (state_70895[(14)]);
var state_70895__$1 = state_70895;
var statearr_70906_70969 = state_70895__$1;
(statearr_70906_70969[(2)] = inst_70787);

(statearr_70906_70969[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (13))){
var inst_70890 = (state_70895[(2)]);
var _ = (function (){var statearr_70907 = state_70895;
(statearr_70907[(4)] = cljs.core.rest((state_70895[(4)])));

return statearr_70907;
})();
var state_70895__$1 = state_70895;
var statearr_70908_70970 = state_70895__$1;
(statearr_70908_70970[(2)] = inst_70890);

(statearr_70908_70970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (22))){
var inst_70794 = (state_70895[(7)]);
var inst_70834 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70794);
var state_70895__$1 = state_70895;
var statearr_70909_70971 = state_70895__$1;
(statearr_70909_70971[(2)] = inst_70834);

(statearr_70909_70971[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (36))){
var inst_70794 = (state_70895[(7)]);
var inst_70859 = (state_70895[(15)]);
var inst_70865 = fluree.db.api.query.format_blocks_resp_pretty(inst_70794,inst_70859);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(39),inst_70865);
} else {
if((state_val_70896 === (41))){
var inst_70872 = (state_70895[(13)]);
var state_70895__$1 = state_70895;
var statearr_70910_70972 = state_70895__$1;
(statearr_70910_70972[(2)] = inst_70872);

(statearr_70910_70972[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (29))){
var inst_70787 = (state_70895[(14)]);
var inst_70858 = (state_70895[(2)]);
var inst_70859 = fluree.db.util.async.throw_err(inst_70858);
var state_70895__$1 = (function (){var statearr_70911 = state_70895;
(statearr_70911[(15)] = inst_70859);

return statearr_70911;
})();
if(cljs.core.truth_(inst_70787)){
var statearr_70912_70973 = state_70895__$1;
(statearr_70912_70973[(1)] = (33));

} else {
var statearr_70913_70974 = state_70895__$1;
(statearr_70913_70974[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (6))){
var inst_70784 = (state_70895[(16)]);
var inst_70793 = (state_70895[(2)]);
var inst_70794 = fluree.db.util.async.throw_err(inst_70793);
var state_70895__$1 = (function (){var statearr_70914 = state_70895;
(statearr_70914[(7)] = inst_70794);

return statearr_70914;
})();
if(cljs.core.truth_(inst_70784)){
var statearr_70915_70975 = state_70895__$1;
(statearr_70915_70975[(1)] = (7));

} else {
var statearr_70916_70976 = state_70895__$1;
(statearr_70916_70976[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (28))){
var inst_70789 = (state_70895[(17)]);
var inst_70851 = (state_70895[(2)]);
var state_70895__$1 = (function (){var statearr_70917 = state_70895;
(statearr_70917[(12)] = inst_70851);

return statearr_70917;
})();
if(cljs.core.truth_(inst_70789)){
var statearr_70918_70977 = state_70895__$1;
(statearr_70918_70977[(1)] = (30));

} else {
var statearr_70919_70978 = state_70895__$1;
(statearr_70919_70978[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (25))){
var inst_70790 = (state_70895[(18)]);
var inst_70845 = (state_70895[(2)]);
var inst_70846 = fluree.db.util.async.throw_err(inst_70845);
var state_70895__$1 = (function (){var statearr_70920 = state_70895;
(statearr_70920[(11)] = inst_70846);

return statearr_70920;
})();
if(cljs.core.truth_(inst_70790)){
var statearr_70921_70979 = state_70895__$1;
(statearr_70921_70979[(1)] = (26));

} else {
var statearr_70922_70980 = state_70895__$1;
(statearr_70922_70980[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (34))){
var inst_70786 = (state_70895[(19)]);
var state_70895__$1 = state_70895;
var statearr_70923_70981 = state_70895__$1;
(statearr_70923_70981[(2)] = inst_70786);

(statearr_70923_70981[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (17))){
var inst_70803 = (state_70895[(8)]);
var inst_70794 = (state_70895[(7)]);
var inst_70817 = (inst_70803 - (1));
var inst_70818 = fluree.db.time_travel.as_of_block(inst_70794,inst_70817);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(20),inst_70818);
} else {
if((state_val_70896 === (3))){
var inst_70893 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70895__$1,inst_70893);
} else {
if((state_val_70896 === (12))){
var inst_70882 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_70883 = ["History query not properly formatted. Provided ",inst_70882].join('');
var inst_70884 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70885 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70886 = cljs.core.PersistentHashMap.fromArrays(inst_70884,inst_70885);
var inst_70887 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70883,inst_70886);
var inst_70888 = (function(){throw inst_70887})();
var state_70895__$1 = state_70895;
var statearr_70924_70982 = state_70895__$1;
(statearr_70924_70982[(2)] = inst_70888);

(statearr_70924_70982[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (2))){
var _ = (function (){var statearr_70925 = state_70895;
(statearr_70925[(4)] = cljs.core.cons((5),(state_70895[(4)])));

return statearr_70925;
})();
var inst_70782 = query_map;
var inst_70783 = cljs.core.__destructure_map(inst_70782);
var inst_70784 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70785 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_70788 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_70789 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_70790 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70791 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70783,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70895__$1 = (function (){var statearr_70926 = state_70895;
(statearr_70926[(18)] = inst_70790);

(statearr_70926[(19)] = inst_70786);

(statearr_70926[(10)] = inst_70788);

(statearr_70926[(14)] = inst_70787);

(statearr_70926[(16)] = inst_70784);

(statearr_70926[(20)] = inst_70791);

(statearr_70926[(21)] = inst_70785);

(statearr_70926[(17)] = inst_70789);

return statearr_70926;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(6),sources);
} else {
if((state_val_70896 === (23))){
var inst_70794 = (state_70895[(7)]);
var inst_70826 = (state_70895[(22)]);
var inst_70785 = (state_70895[(21)]);
var inst_70836 = (state_70895[(2)]);
var inst_70837 = fluree.db.api.query.get_history_pattern(inst_70785);
var inst_70838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70837,(0),null);
var inst_70839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70837,(1),null);
var inst_70840 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_70841 = [inst_70826,inst_70836];
var inst_70842 = cljs.core.PersistentHashMap.fromArrays(inst_70840,inst_70841);
var inst_70843 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_70794,inst_70839,cljs.core._EQ_,inst_70838,inst_70842);
var state_70895__$1 = state_70895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70895__$1,(25),inst_70843);
} else {
if((state_val_70896 === (35))){
var inst_70863 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
if(cljs.core.truth_(inst_70863)){
var statearr_70927_70983 = state_70895__$1;
(statearr_70927_70983[(1)] = (36));

} else {
var statearr_70928_70984 = state_70895__$1;
(statearr_70928_70984[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (19))){
var inst_70804 = (state_70895[(9)]);
var inst_70826 = (state_70895[(2)]);
var state_70895__$1 = (function (){var statearr_70929 = state_70895;
(statearr_70929[(22)] = inst_70826);

return statearr_70929;
})();
if(cljs.core.truth_(inst_70804)){
var statearr_70930_70985 = state_70895__$1;
(statearr_70930_70985[(1)] = (21));

} else {
var statearr_70931_70986 = state_70895__$1;
(statearr_70931_70986[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (11))){
var inst_70803 = (state_70895[(8)]);
var inst_70791 = (state_70895[(20)]);
var inst_70810 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70791);
var state_70895__$1 = (function (){var statearr_70933 = state_70895;
(statearr_70933[(23)] = inst_70810);

return statearr_70933;
})();
if(cljs.core.truth_(inst_70803)){
var statearr_70934_70987 = state_70895__$1;
(statearr_70934_70987[(1)] = (14));

} else {
var statearr_70935_70988 = state_70895__$1;
(statearr_70935_70988[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (9))){
var inst_70802 = (state_70895[(2)]);
var inst_70803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70802,(0),null);
var inst_70804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70802,(1),null);
var inst_70805 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_70895__$1 = (function (){var statearr_70936 = state_70895;
(statearr_70936[(9)] = inst_70804);

(statearr_70936[(8)] = inst_70803);

return statearr_70936;
})();
if(inst_70805){
var statearr_70937_70989 = state_70895__$1;
(statearr_70937_70989[(1)] = (11));

} else {
var statearr_70938_70990 = state_70895__$1;
(statearr_70938_70990[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (5))){
var _ = (function (){var statearr_70939 = state_70895;
(statearr_70939[(4)] = cljs.core.rest((state_70895[(4)])));

return statearr_70939;
})();
var state_70895__$1 = state_70895;
var ex70932 = (state_70895__$1[(2)]);
var statearr_70940_70991 = state_70895__$1;
(statearr_70940_70991[(5)] = ex70932);


if((ex70932 instanceof Error)){
var statearr_70941_70992 = state_70895__$1;
(statearr_70941_70992[(1)] = (4));

(statearr_70941_70992[(5)] = null);

} else {
throw ex70932;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (14))){
var inst_70803 = (state_70895[(8)]);
var inst_70812 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70803);
var state_70895__$1 = state_70895;
var statearr_70942_70993 = state_70895__$1;
(statearr_70942_70993[(2)] = inst_70812);

(statearr_70942_70993[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (26))){
var inst_70790 = (state_70895[(18)]);
var inst_70848 = cljs.core.set(inst_70790);
var state_70895__$1 = state_70895;
var statearr_70943_70994 = state_70895__$1;
(statearr_70943_70994[(2)] = inst_70848);

(statearr_70943_70994[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (16))){
var inst_70815 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
if(cljs.core.truth_(inst_70815)){
var statearr_70944_70995 = state_70895__$1;
(statearr_70944_70995[(1)] = (17));

} else {
var statearr_70945_70996 = state_70895__$1;
(statearr_70945_70996[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (38))){
var inst_70810 = (state_70895[(23)]);
var inst_70872 = (state_70895[(2)]);
var state_70895__$1 = (function (){var statearr_70946 = state_70895;
(statearr_70946[(13)] = inst_70872);

return statearr_70946;
})();
if(cljs.core.truth_(inst_70810)){
var statearr_70947_70997 = state_70895__$1;
(statearr_70947_70997[(1)] = (40));

} else {
var statearr_70948_70998 = state_70895__$1;
(statearr_70948_70998[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (30))){
var inst_70789 = (state_70895[(17)]);
var state_70895__$1 = state_70895;
var statearr_70949_70999 = state_70895__$1;
(statearr_70949_70999[(2)] = inst_70789);

(statearr_70949_70999[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (10))){
var inst_70798 = (state_70895[(2)]);
var inst_70799 = fluree.db.util.async.throw_err(inst_70798);
var state_70895__$1 = state_70895;
var statearr_70950_71000 = state_70895__$1;
(statearr_70950_71000[(2)] = inst_70799);

(statearr_70950_71000[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (18))){
var state_70895__$1 = state_70895;
var statearr_70951_71001 = state_70895__$1;
(statearr_70951_71001[(2)] = (-1));

(statearr_70951_71001[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (42))){
var inst_70880 = (state_70895[(2)]);
var state_70895__$1 = state_70895;
var statearr_70952_71002 = state_70895__$1;
(statearr_70952_71002[(2)] = inst_70880);

(statearr_70952_71002[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (37))){
var inst_70859 = (state_70895[(15)]);
var inst_70870 = fluree.db.api.query.block_Flakes__GT_vector(inst_70859);
var state_70895__$1 = state_70895;
var statearr_70953_71003 = state_70895__$1;
(statearr_70953_71003[(2)] = inst_70870);

(statearr_70953_71003[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70896 === (8))){
var state_70895__$1 = state_70895;
var statearr_70954_71004 = state_70895__$1;
(statearr_70954_71004[(2)] = null);

(statearr_70954_71004[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70955 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70955[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_70955[(1)] = (1));

return statearr_70955;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_70895){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70895);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70956){var ex__2730__auto__ = e70956;
var statearr_70957_71005 = state_70895;
(statearr_70957_71005[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70895[(4)]))){
var statearr_70958_71006 = state_70895;
(statearr_70958_71006[(1)] = cljs.core.first((state_70895[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71007 = state_70895;
state_70895 = G__71007;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_70895){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_70895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70959 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70959[(6)] = c__2749__auto__);

return statearr_70959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71140){
var state_val_71141 = (state_71140[(1)]);
if((state_val_71141 === (7))){
var inst_71037 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_71038 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_71037].join('');
var inst_71039 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71040 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71041 = cljs.core.PersistentHashMap.fromArrays(inst_71039,inst_71040);
var inst_71042 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71038,inst_71041);
var inst_71043 = (function(){throw inst_71042})();
var state_71140__$1 = state_71140;
var statearr_71142_71221 = state_71140__$1;
(statearr_71142_71221[(2)] = inst_71043);

(statearr_71142_71221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (20))){
var inst_71075 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
if(cljs.core.truth_(inst_71075)){
var statearr_71143_71222 = state_71140__$1;
(statearr_71143_71222[(1)] = (21));

} else {
var statearr_71144_71223 = state_71140__$1;
(statearr_71144_71223[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (27))){
var inst_71019 = (state_71140[(7)]);
var state_71140__$1 = state_71140;
var statearr_71145_71224 = state_71140__$1;
(statearr_71145_71224[(2)] = inst_71019);

(statearr_71145_71224[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (1))){
var state_71140__$1 = state_71140;
var statearr_71146_71225 = state_71140__$1;
(statearr_71146_71225[(2)] = null);

(statearr_71146_71225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (24))){
var inst_71081 = (state_71140[(8)]);
var state_71140__$1 = state_71140;
var statearr_71147_71226 = state_71140__$1;
(statearr_71147_71226[(2)] = inst_71081);

(statearr_71147_71226[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (39))){
var inst_71025 = (state_71140[(9)]);
var state_71140__$1 = state_71140;
if(cljs.core.truth_(inst_71025)){
var statearr_71148_71227 = state_71140__$1;
(statearr_71148_71227[(1)] = (42));

} else {
var statearr_71149_71228 = state_71140__$1;
(statearr_71149_71228[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (46))){
var inst_71113 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71114 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71115 = cljs.core.PersistentHashMap.fromArrays(inst_71113,inst_71114);
var inst_71116 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_71115);
var inst_71117 = (function(){throw inst_71116})();
var state_71140__$1 = state_71140;
var statearr_71150_71229 = state_71140__$1;
(statearr_71150_71229[(2)] = inst_71117);

(statearr_71150_71229[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (4))){
var inst_71009 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
var statearr_71151_71230 = state_71140__$1;
(statearr_71151_71230[(2)] = inst_71009);

(statearr_71151_71230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (15))){
var inst_71022 = (state_71140[(10)]);
var inst_71060 = (state_71140[(11)]);
var inst_71062 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_71060);
var inst_71063 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_71060);
var inst_71064 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71060);
var inst_71065 = fluree.db.api.query.get_sources(inst_71062,inst_71063,inst_71064,inst_71022);
var state_71140__$1 = state_71140;
var statearr_71152_71231 = state_71140__$1;
(statearr_71152_71231[(2)] = inst_71065);

(statearr_71152_71231[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (48))){
var inst_71070 = (state_71140[(12)]);
var inst_71124 = (state_71140[(2)]);
var inst_71125 = fluree.db.util.async.throw_err(inst_71124);
var state_71140__$1 = (function (){var statearr_71153 = state_71140;
(statearr_71153[(13)] = inst_71125);

return statearr_71153;
})();
if(cljs.core.truth_(inst_71070)){
var statearr_71154_71232 = state_71140__$1;
(statearr_71154_71232[(1)] = (49));

} else {
var statearr_71155_71233 = state_71140__$1;
(statearr_71155_71233[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (50))){
var inst_71125 = (state_71140[(13)]);
var state_71140__$1 = state_71140;
var statearr_71156_71234 = state_71140__$1;
(statearr_71156_71234[(2)] = inst_71125);

(statearr_71156_71234[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (21))){
var inst_71077 = cljs.core.volatile_BANG_((0));
var state_71140__$1 = state_71140;
var statearr_71157_71235 = state_71140__$1;
(statearr_71157_71235[(2)] = inst_71077);

(statearr_71157_71235[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (31))){
var inst_71023 = (state_71140[(14)]);
var state_71140__$1 = state_71140;
if(cljs.core.truth_(inst_71023)){
var statearr_71158_71236 = state_71140__$1;
(statearr_71158_71236[(1)] = (33));

} else {
var statearr_71159_71237 = state_71140__$1;
(statearr_71159_71237[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (32))){
var inst_71100 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
var statearr_71160_71238 = state_71140__$1;
(statearr_71160_71238[(2)] = inst_71100);

(statearr_71160_71238[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (40))){
var inst_71102 = (state_71140[(15)]);
var state_71140__$1 = state_71140;
var statearr_71161_71239 = state_71140__$1;
(statearr_71161_71239[(2)] = inst_71102);

(statearr_71161_71239[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (33))){
var inst_71023 = (state_71140[(14)]);
var state_71140__$1 = state_71140;
var statearr_71162_71240 = state_71140__$1;
(statearr_71162_71240[(2)] = inst_71023);

(statearr_71162_71240[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (13))){
var inst_71020 = (state_71140[(16)]);
var inst_71049 = (state_71140[(2)]);
var inst_71050 = fluree.db.util.async.throw_err(inst_71049);
var inst_71051 = fluree.db.time_travel.as_of_block(inst_71050,inst_71020);
var state_71140__$1 = state_71140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71140__$1,(12),inst_71051);
} else {
if((state_val_71141 === (22))){
var state_71140__$1 = state_71140;
var statearr_71163_71241 = state_71140__$1;
(statearr_71163_71241[(2)] = null);

(statearr_71163_71241[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (36))){
var inst_71027 = (state_71140[(17)]);
var state_71140__$1 = state_71140;
var statearr_71164_71242 = state_71140__$1;
(statearr_71164_71242[(2)] = inst_71027);

(statearr_71164_71242[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (41))){
var inst_71110 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
if(cljs.core.truth_(inst_71110)){
var statearr_71165_71243 = state_71140__$1;
(statearr_71165_71243[(1)] = (45));

} else {
var statearr_71166_71244 = state_71140__$1;
(statearr_71166_71244[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (43))){
var inst_71021 = (state_71140[(18)]);
var state_71140__$1 = state_71140;
var statearr_71167_71245 = state_71140__$1;
(statearr_71167_71245[(2)] = inst_71021);

(statearr_71167_71245[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (29))){
var inst_71102 = (state_71140[(15)]);
var inst_71102__$1 = (state_71140[(2)]);
var state_71140__$1 = (function (){var statearr_71168 = state_71140;
(statearr_71168[(15)] = inst_71102__$1);

return statearr_71168;
})();
if(cljs.core.truth_(inst_71102__$1)){
var statearr_71169_71246 = state_71140__$1;
(statearr_71169_71246[(1)] = (39));

} else {
var statearr_71170_71247 = state_71140__$1;
(statearr_71170_71247[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (44))){
var inst_71107 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
var statearr_71171_71248 = state_71140__$1;
(statearr_71171_71248[(2)] = inst_71107);

(statearr_71171_71248[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (6))){
var state_71140__$1 = state_71140;
var statearr_71172_71249 = state_71140__$1;
(statearr_71172_71249[(2)] = null);

(statearr_71172_71249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (28))){
var inst_71024 = (state_71140[(19)]);
var state_71140__$1 = state_71140;
if(cljs.core.truth_(inst_71024)){
var statearr_71173_71250 = state_71140__$1;
(statearr_71173_71250[(1)] = (30));

} else {
var statearr_71174_71251 = state_71140__$1;
(statearr_71174_71251[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (51))){
var inst_71135 = (state_71140[(2)]);
var _ = (function (){var statearr_71175 = state_71140;
(statearr_71175[(4)] = cljs.core.rest((state_71140[(4)])));

return statearr_71175;
})();
var state_71140__$1 = state_71140;
var statearr_71176_71252 = state_71140__$1;
(statearr_71176_71252[(2)] = inst_71135);

(statearr_71176_71252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (25))){
var state_71140__$1 = state_71140;
var statearr_71177_71253 = state_71140__$1;
(statearr_71177_71253[(2)] = (1000000));

(statearr_71177_71253[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (34))){
var inst_71027 = (state_71140[(17)]);
var state_71140__$1 = state_71140;
if(cljs.core.truth_(inst_71027)){
var statearr_71178_71254 = state_71140__$1;
(statearr_71178_71254[(1)] = (36));

} else {
var statearr_71179_71255 = state_71140__$1;
(statearr_71179_71255[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (17))){
var inst_71026 = (state_71140[(20)]);
var inst_71071 = (state_71140[(21)]);
var inst_71069 = (state_71140[(2)]);
var inst_71070 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71026);
var inst_71071__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71026);
var state_71140__$1 = (function (){var statearr_71180 = state_71140;
(statearr_71180[(22)] = inst_71069);

(statearr_71180[(12)] = inst_71070);

(statearr_71180[(21)] = inst_71071__$1);

return statearr_71180;
})();
if(cljs.core.truth_(inst_71071__$1)){
var statearr_71181_71256 = state_71140__$1;
(statearr_71181_71256[(1)] = (18));

} else {
var statearr_71182_71257 = state_71140__$1;
(statearr_71182_71257[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (3))){
var inst_71138 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71140__$1,inst_71138);
} else {
if((state_val_71141 === (12))){
var inst_71053 = (state_71140[(2)]);
var inst_71054 = fluree.db.util.async.throw_err(inst_71053);
var state_71140__$1 = state_71140;
var statearr_71183_71258 = state_71140__$1;
(statearr_71183_71258[(2)] = inst_71054);

(statearr_71183_71258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (2))){
var inst_71027 = (state_71140[(17)]);
var inst_71022 = (state_71140[(10)]);
var inst_71024 = (state_71140[(19)]);
var inst_71019 = (state_71140[(7)]);
var inst_71020 = (state_71140[(16)]);
var inst_71025 = (state_71140[(9)]);
var inst_71021 = (state_71140[(18)]);
var inst_71018 = (state_71140[(23)]);
var inst_71023 = (state_71140[(14)]);
var inst_71026 = (state_71140[(20)]);
var _ = (function (){var statearr_71184 = state_71140;
(statearr_71184[(4)] = cljs.core.cons((5),(state_71140[(4)])));

return statearr_71184;
})();
var inst_71016 = flureeQL;
var inst_71017 = cljs.core.__destructure_map(inst_71016);
var inst_71018__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_71019__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_71020__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71021__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_71022__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_71023__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_71024__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_71025__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_71026__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71027__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71017,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_71028 = (function (){var construct = inst_71018__$1;
var select = inst_71019__$1;
var block = inst_71020__$1;
var where = inst_71021__$1;
var prefixes = inst_71022__$1;
var selectDistinct = inst_71023__$1;
var selectOne = inst_71024__$1;
var from = inst_71025__$1;
var opts = inst_71026__$1;
var map__71015 = inst_71017;
var selectReduced = inst_71027__$1;
return (function (p1__71008_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__71008_SHARP_);
});
})();
var inst_71029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71030 = [inst_71019__$1,inst_71024__$1,inst_71023__$1,inst_71027__$1];
var inst_71031 = (new cljs.core.PersistentVector(null,4,(5),inst_71029,inst_71030,null));
var inst_71032 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_71031);
var inst_71033 = cljs.core.count(inst_71032);
var inst_71034 = (inst_71028.cljs$core$IFn$_invoke$arity$1 ? inst_71028.cljs$core$IFn$_invoke$arity$1(inst_71033) : inst_71028.call(null,inst_71033));
var state_71140__$1 = (function (){var statearr_71185 = state_71140;
(statearr_71185[(17)] = inst_71027__$1);

(statearr_71185[(10)] = inst_71022__$1);

(statearr_71185[(19)] = inst_71024__$1);

(statearr_71185[(7)] = inst_71019__$1);

(statearr_71185[(16)] = inst_71020__$1);

(statearr_71185[(9)] = inst_71025__$1);

(statearr_71185[(18)] = inst_71021__$1);

(statearr_71185[(23)] = inst_71018__$1);

(statearr_71185[(14)] = inst_71023__$1);

(statearr_71185[(20)] = inst_71026__$1);

return statearr_71185;
})();
if(cljs.core.truth_(inst_71034)){
var statearr_71186_71259 = state_71140__$1;
(statearr_71186_71259[(1)] = (6));

} else {
var statearr_71187_71260 = state_71140__$1;
(statearr_71187_71260[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (23))){
var inst_71081 = (state_71140[(8)]);
var inst_71026 = (state_71140[(20)]);
var inst_71080 = (state_71140[(2)]);
var inst_71081__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71026);
var state_71140__$1 = (function (){var statearr_71188 = state_71140;
(statearr_71188[(24)] = inst_71080);

(statearr_71188[(8)] = inst_71081__$1);

return statearr_71188;
})();
if(cljs.core.truth_(inst_71081__$1)){
var statearr_71189_71261 = state_71140__$1;
(statearr_71189_71261[(1)] = (24));

} else {
var statearr_71190_71262 = state_71140__$1;
(statearr_71190_71262[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (47))){
var inst_71086 = (state_71140[(25)]);
var inst_71060 = (state_71140[(11)]);
var inst_71119 = (state_71140[(2)]);
var inst_71120 = fluree.db.util.core.current_time_millis();
var inst_71121 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71086);
var inst_71122 = fluree.db.query.fql.query(inst_71060,inst_71121);
var state_71140__$1 = (function (){var statearr_71191 = state_71140;
(statearr_71191[(26)] = inst_71120);

(statearr_71191[(27)] = inst_71119);

return statearr_71191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71140__$1,(48),inst_71122);
} else {
if((state_val_71141 === (35))){
var inst_71098 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
var statearr_71192_71263 = state_71140__$1;
(statearr_71192_71263[(2)] = inst_71098);

(statearr_71192_71263[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (19))){
var inst_71070 = (state_71140[(12)]);
var state_71140__$1 = state_71140;
var statearr_71193_71264 = state_71140__$1;
(statearr_71193_71264[(2)] = inst_71070);

(statearr_71193_71264[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (11))){
var inst_71022 = (state_71140[(10)]);
var inst_71060 = (state_71140[(2)]);
var state_71140__$1 = (function (){var statearr_71195 = state_71140;
(statearr_71195[(11)] = inst_71060);

return statearr_71195;
})();
if(cljs.core.truth_(inst_71022)){
var statearr_71196_71265 = state_71140__$1;
(statearr_71196_71265[(1)] = (15));

} else {
var statearr_71197_71266 = state_71140__$1;
(statearr_71197_71266[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (9))){
var inst_71046 = (state_71140[(28)]);
var state_71140__$1 = state_71140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71140__$1,(13),inst_71046);
} else {
if((state_val_71141 === (5))){
var _ = (function (){var statearr_71198 = state_71140;
(statearr_71198[(4)] = cljs.core.rest((state_71140[(4)])));

return statearr_71198;
})();
var state_71140__$1 = state_71140;
var ex71194 = (state_71140__$1[(2)]);
var statearr_71199_71267 = state_71140__$1;
(statearr_71199_71267[(5)] = ex71194);


if((ex71194 instanceof Error)){
var statearr_71200_71268 = state_71140__$1;
(statearr_71200_71268[(1)] = (4));

(statearr_71200_71268[(5)] = null);

} else {
throw ex71194;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (14))){
var inst_71057 = (state_71140[(2)]);
var inst_71058 = fluree.db.util.async.throw_err(inst_71057);
var state_71140__$1 = state_71140;
var statearr_71201_71269 = state_71140__$1;
(statearr_71201_71269[(2)] = inst_71058);

(statearr_71201_71269[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (45))){
var state_71140__$1 = state_71140;
var statearr_71202_71270 = state_71140__$1;
(statearr_71202_71270[(2)] = null);

(statearr_71202_71270[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (26))){
var inst_71069 = (state_71140[(22)]);
var inst_71080 = (state_71140[(24)]);
var inst_71019 = (state_71140[(7)]);
var inst_71026 = (state_71140[(20)]);
var inst_71085 = (state_71140[(2)]);
var inst_71086 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_71026,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_71069,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_71085,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71080], 0));
var state_71140__$1 = (function (){var statearr_71203 = state_71140;
(statearr_71203[(25)] = inst_71086);

return statearr_71203;
})();
if(cljs.core.truth_(inst_71019)){
var statearr_71204_71271 = state_71140__$1;
(statearr_71204_71271[(1)] = (27));

} else {
var statearr_71205_71272 = state_71140__$1;
(statearr_71205_71272[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (16))){
var inst_71067 = cljs.core.PersistentHashMap.EMPTY;
var state_71140__$1 = state_71140;
var statearr_71206_71273 = state_71140__$1;
(statearr_71206_71273[(2)] = inst_71067);

(statearr_71206_71273[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (38))){
var inst_71096 = (state_71140[(2)]);
var state_71140__$1 = state_71140;
var statearr_71207_71274 = state_71140__$1;
(statearr_71207_71274[(2)] = inst_71096);

(statearr_71207_71274[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (30))){
var inst_71024 = (state_71140[(19)]);
var state_71140__$1 = state_71140;
var statearr_71208_71275 = state_71140__$1;
(statearr_71208_71275[(2)] = inst_71024);

(statearr_71208_71275[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (10))){
var inst_71046 = (state_71140[(28)]);
var state_71140__$1 = state_71140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71140__$1,(14),inst_71046);
} else {
if((state_val_71141 === (18))){
var inst_71071 = (state_71140[(21)]);
var state_71140__$1 = state_71140;
var statearr_71209_71276 = state_71140__$1;
(statearr_71209_71276[(2)] = inst_71071);

(statearr_71209_71276[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (42))){
var inst_71025 = (state_71140[(9)]);
var state_71140__$1 = state_71140;
var statearr_71210_71277 = state_71140__$1;
(statearr_71210_71277[(2)] = inst_71025);

(statearr_71210_71277[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (37))){
var inst_71018 = (state_71140[(23)]);
var state_71140__$1 = state_71140;
var statearr_71211_71278 = state_71140__$1;
(statearr_71211_71278[(2)] = inst_71018);

(statearr_71211_71278[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (8))){
var inst_71020 = (state_71140[(16)]);
var inst_71045 = (state_71140[(2)]);
var inst_71046 = sources;
var state_71140__$1 = (function (){var statearr_71212 = state_71140;
(statearr_71212[(28)] = inst_71046);

(statearr_71212[(29)] = inst_71045);

return statearr_71212;
})();
if(cljs.core.truth_(inst_71020)){
var statearr_71213_71279 = state_71140__$1;
(statearr_71213_71279[(1)] = (9));

} else {
var statearr_71214_71280 = state_71140__$1;
(statearr_71214_71280[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71141 === (49))){
var inst_71120 = (state_71140[(26)]);
var inst_71080 = (state_71140[(24)]);
var inst_71125 = (state_71140[(13)]);
var inst_71060 = (state_71140[(11)]);
var inst_71127 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71128 = cljs.core.deref(inst_71080);
var inst_71129 = fluree.db.util.core.response_time_formatted(inst_71120);
var inst_71130 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71060);
var inst_71131 = [(200),inst_71125,inst_71128,inst_71129,inst_71130];
var inst_71132 = cljs.core.PersistentHashMap.fromArrays(inst_71127,inst_71131);
var state_71140__$1 = state_71140;
var statearr_71215_71281 = state_71140__$1;
(statearr_71215_71281[(2)] = inst_71132);

(statearr_71215_71281[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_71216 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71216[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_71216[(1)] = (1));

return statearr_71216;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_71140){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71140);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71217){var ex__2730__auto__ = e71217;
var statearr_71218_71282 = state_71140;
(statearr_71218_71282[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71140[(4)]))){
var statearr_71219_71283 = state_71140;
(statearr_71219_71283[(1)] = cljs.core.first((state_71140[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71284 = state_71140;
state_71140 = G__71284;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_71140){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_71140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71220 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71220[(6)] = c__2749__auto__);

return statearr_71220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71425){
var state_val_71426 = (state_71425[(1)]);
if((state_val_71426 === (7))){
var inst_71420 = (state_71425[(2)]);
var _ = (function (){var statearr_71427 = state_71425;
(statearr_71427[(4)] = cljs.core.rest((state_71425[(4)])));

return statearr_71427;
})();
var state_71425__$1 = state_71425;
var statearr_71428_71504 = state_71425__$1;
(statearr_71428_71504[(2)] = inst_71420);

(statearr_71428_71504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (20))){
var inst_71392 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71429_71505 = state_71425__$1;
(statearr_71429_71505[(2)] = inst_71392);

(statearr_71429_71505[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (27))){
var inst_71372 = (state_71425[(7)]);
var state_71425__$1 = state_71425;
var statearr_71430_71506 = state_71425__$1;
(statearr_71430_71506[(2)] = inst_71372);

(statearr_71430_71506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (1))){
var state_71425__$1 = state_71425;
var statearr_71431_71507 = state_71425__$1;
(statearr_71431_71507[(2)] = null);

(statearr_71431_71507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (24))){
var inst_71369 = (state_71425[(8)]);
var state_71425__$1 = state_71425;
var statearr_71432_71508 = state_71425__$1;
(statearr_71432_71508[(2)] = inst_71369);

(statearr_71432_71508[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (39))){
var inst_71359 = (state_71425[(9)]);
var inst_71337 = (state_71425[(10)]);
var inst_71326 = (state_71425[(11)]);
var inst_71403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71404 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_71337];
var inst_71405 = (new cljs.core.PersistentVector(null,2,(5),inst_71403,inst_71404,null));
var inst_71406 = cljs.core.assoc_in(inst_71326,inst_71405,inst_71359);
var state_71425__$1 = state_71425;
var statearr_71433_71509 = state_71425__$1;
(statearr_71433_71509[(2)] = inst_71406);

(statearr_71433_71509[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (4))){
var inst_71285 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71434_71510 = state_71425__$1;
(statearr_71434_71510[(2)] = inst_71285);

(statearr_71434_71510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (15))){
var inst_71359 = (state_71425[(9)]);
var inst_71324 = (state_71425[(12)]);
var inst_71362 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_71359);
var inst_71363 = (inst_71324 == null);
var state_71425__$1 = (function (){var statearr_71435 = state_71425;
(statearr_71435[(13)] = inst_71362);

return statearr_71435;
})();
if(cljs.core.truth_(inst_71363)){
var statearr_71436_71511 = state_71425__$1;
(statearr_71436_71511[(1)] = (18));

} else {
var statearr_71437_71512 = state_71425__$1;
(statearr_71437_71512[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (21))){
var inst_71362 = (state_71425[(13)]);
var state_71425__$1 = state_71425;
var statearr_71438_71513 = state_71425__$1;
(statearr_71438_71513[(2)] = inst_71362);

(statearr_71438_71513[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (31))){
var state_71425__$1 = state_71425;
var statearr_71439_71514 = state_71425__$1;
(statearr_71439_71514[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (32))){
var inst_71388 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71441_71515 = state_71425__$1;
(statearr_71441_71515[(2)] = inst_71388);

(statearr_71441_71515[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (40))){
var inst_71357 = (state_71425[(14)]);
var state_71425__$1 = state_71425;
if(cljs.core.truth_(inst_71357)){
var statearr_71442_71516 = state_71425__$1;
(statearr_71442_71516[(1)] = (42));

} else {
var statearr_71443_71517 = state_71425__$1;
(statearr_71443_71517[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (33))){
var inst_71362 = (state_71425[(13)]);
var inst_71324 = (state_71425[(12)]);
var inst_71383 = ((inst_71362 > inst_71324) ? inst_71362 : inst_71324);
var state_71425__$1 = state_71425;
var statearr_71444_71518 = state_71425__$1;
(statearr_71444_71518[(2)] = inst_71383);

(statearr_71444_71518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (13))){
var inst_71348 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71445_71519 = state_71425__$1;
(statearr_71445_71519[(2)] = inst_71348);

(statearr_71445_71519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (22))){
var inst_71369 = (state_71425[(8)]);
var inst_71362 = (state_71425[(13)]);
var inst_71369__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_71362);
var state_71425__$1 = (function (){var statearr_71446 = state_71425;
(statearr_71446[(8)] = inst_71369__$1);

return statearr_71446;
})();
if(inst_71369__$1){
var statearr_71447_71520 = state_71425__$1;
(statearr_71447_71520[(1)] = (24));

} else {
var statearr_71448_71521 = state_71425__$1;
(statearr_71448_71521[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (36))){
var inst_71325 = (state_71425[(15)]);
var inst_71359 = (state_71425[(9)]);
var inst_71397 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_71359,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_71398 = (inst_71325 + inst_71397);
var state_71425__$1 = state_71425;
var statearr_71449_71522 = state_71425__$1;
(statearr_71449_71522[(2)] = inst_71398);

(statearr_71449_71522[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (41))){
var inst_71395 = (state_71425[(16)]);
var inst_71336 = (state_71425[(17)]);
var inst_71401 = (state_71425[(18)]);
var inst_71415 = (state_71425[(2)]);
var inst_71323 = inst_71336;
var inst_71324 = inst_71395;
var inst_71325 = inst_71401;
var inst_71326 = inst_71415;
var state_71425__$1 = (function (){var statearr_71450 = state_71425;
(statearr_71450[(15)] = inst_71325);

(statearr_71450[(19)] = inst_71323);

(statearr_71450[(12)] = inst_71324);

(statearr_71450[(11)] = inst_71326);

return statearr_71450;
})();
var statearr_71451_71523 = state_71425__$1;
(statearr_71451_71523[(2)] = null);

(statearr_71451_71523[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (43))){
var inst_71359 = (state_71425[(9)]);
var state_71425__$1 = state_71425;
var statearr_71452_71524 = state_71425__$1;
(statearr_71452_71524[(2)] = inst_71359);

(statearr_71452_71524[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (29))){
var inst_71377 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71453_71525 = state_71425__$1;
(statearr_71453_71525[(2)] = inst_71377);

(statearr_71453_71525[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (44))){
var inst_71337 = (state_71425[(10)]);
var inst_71326 = (state_71425[(11)]);
var inst_71412 = (state_71425[(2)]);
var inst_71413 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71326,inst_71337,inst_71412);
var state_71425__$1 = state_71425;
var statearr_71454_71526 = state_71425__$1;
(statearr_71454_71526[(2)] = inst_71413);

(statearr_71454_71526[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (6))){
var inst_71323 = (state_71425[(19)]);
var inst_71338 = (state_71425[(20)]);
var inst_71334 = cljs.core.seq(inst_71323);
var inst_71335 = cljs.core.first(inst_71334);
var inst_71336 = cljs.core.next(inst_71334);
var inst_71337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71335,(0),null);
var inst_71338__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71335,(1),null);
var inst_71339 = (inst_71338__$1 == null);
var state_71425__$1 = (function (){var statearr_71455 = state_71425;
(statearr_71455[(10)] = inst_71337);

(statearr_71455[(17)] = inst_71336);

(statearr_71455[(20)] = inst_71338__$1);

return statearr_71455;
})();
if(cljs.core.truth_(inst_71339)){
var statearr_71456_71527 = state_71425__$1;
(statearr_71456_71527[(1)] = (8));

} else {
var statearr_71457_71528 = state_71425__$1;
(statearr_71457_71528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (28))){
var inst_71324 = (state_71425[(12)]);
var inst_71375 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_71324);
var state_71425__$1 = state_71425;
var statearr_71458_71529 = state_71425__$1;
(statearr_71458_71529[(2)] = inst_71375);

(statearr_71458_71529[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (25))){
var inst_71372 = (state_71425[(7)]);
var inst_71324 = (state_71425[(12)]);
var inst_71372__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_71324);
var state_71425__$1 = (function (){var statearr_71459 = state_71425;
(statearr_71459[(7)] = inst_71372__$1);

return statearr_71459;
})();
if(inst_71372__$1){
var statearr_71460_71530 = state_71425__$1;
(statearr_71460_71530[(1)] = (27));

} else {
var statearr_71461_71531 = state_71425__$1;
(statearr_71461_71531[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (34))){
var state_71425__$1 = state_71425;
var statearr_71462_71532 = state_71425__$1;
(statearr_71462_71532[(2)] = null);

(statearr_71462_71532[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (17))){
var inst_71356 = (state_71425[(21)]);
var inst_71395 = (state_71425[(2)]);
var state_71425__$1 = (function (){var statearr_71463 = state_71425;
(statearr_71463[(16)] = inst_71395);

return statearr_71463;
})();
if(cljs.core.truth_(inst_71356)){
var statearr_71464_71533 = state_71425__$1;
(statearr_71464_71533[(1)] = (36));

} else {
var statearr_71465_71534 = state_71425__$1;
(statearr_71465_71534[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (3))){
var inst_71423 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71425__$1,inst_71423);
} else {
if((state_val_71426 === (12))){
var inst_71326 = (state_71425[(11)]);
var state_71425__$1 = state_71425;
var statearr_71466_71535 = state_71425__$1;
(statearr_71466_71535[(2)] = inst_71326);

(statearr_71466_71535[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (2))){
var inst_71295 = (state_71425[(22)]);
var inst_71299 = (state_71425[(23)]);
var inst_71300 = (state_71425[(24)]);
var _ = (function (){var statearr_71467 = state_71425;
(statearr_71467[(4)] = cljs.core.cons((5),(state_71425[(4)])));

return statearr_71467;
})();
var inst_71291 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_71292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71293 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_71294 = (new cljs.core.PersistentVector(null,2,(5),inst_71292,inst_71293,null));
var inst_71295__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_71294);
var inst_71296 = (function (){var global_block = inst_71291;
var global_meta_QMARK_ = inst_71295__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_71297 = cljs.core.PersistentHashMap.EMPTY;
var inst_71298 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_71299__$1 = cljs.core.reduce_kv(inst_71296,inst_71297,inst_71298);
var inst_71300__$1 = fluree.db.util.core.current_time_millis();
var inst_71302 = (function (){var global_block = inst_71291;
var global_meta_QMARK_ = inst_71295__$1;
var queries = inst_71299__$1;
var start_time = inst_71300__$1;
return (function (p__71301){
var vec__71468 = p__71301;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71468,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71468,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_71303 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_71302,inst_71299__$1);
var inst_71317 = cljs.core.seq(inst_71303);
var inst_71318 = cljs.core.first(inst_71317);
var inst_71319 = cljs.core.next(inst_71317);
var inst_71320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71318,(0),null);
var inst_71321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71318,(1),null);
var inst_71322 = cljs.core.PersistentHashMap.EMPTY;
var inst_71323 = inst_71303;
var inst_71324 = null;
var inst_71325 = (0);
var inst_71326 = inst_71322;
var state_71425__$1 = (function (){var statearr_71471 = state_71425;
(statearr_71471[(22)] = inst_71295__$1);

(statearr_71471[(15)] = inst_71325);

(statearr_71471[(25)] = inst_71321);

(statearr_71471[(19)] = inst_71323);

(statearr_71471[(26)] = inst_71320);

(statearr_71471[(27)] = inst_71319);

(statearr_71471[(12)] = inst_71324);

(statearr_71471[(11)] = inst_71326);

(statearr_71471[(23)] = inst_71299__$1);

(statearr_71471[(24)] = inst_71300__$1);

return statearr_71471;
})();
var statearr_71472_71536 = state_71425__$1;
(statearr_71472_71536[(2)] = null);

(statearr_71472_71536[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (23))){
var inst_71390 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71473_71537 = state_71425__$1;
(statearr_71473_71537[(2)] = inst_71390);

(statearr_71473_71537[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (35))){
var inst_71386 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71474_71538 = state_71425__$1;
(statearr_71474_71538[(2)] = inst_71386);

(statearr_71474_71538[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (19))){
var inst_71362 = (state_71425[(13)]);
var inst_71324 = (state_71425[(12)]);
var inst_71366 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71324,inst_71362);
var state_71425__$1 = state_71425;
if(inst_71366){
var statearr_71475_71539 = state_71425__$1;
(statearr_71475_71539[(1)] = (21));

} else {
var statearr_71476_71540 = state_71425__$1;
(statearr_71476_71540[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (11))){
var inst_71325 = (state_71425[(15)]);
var inst_71324 = (state_71425[(12)]);
var inst_71326 = (state_71425[(11)]);
var inst_71300 = (state_71425[(24)]);
var inst_71342 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71343 = fluree.db.util.core.response_time_formatted(inst_71300);
var inst_71344 = [inst_71326,inst_71325,inst_71324,inst_71343];
var inst_71345 = cljs.core.PersistentHashMap.fromArrays(inst_71342,inst_71344);
var state_71425__$1 = state_71425;
var statearr_71478_71541 = state_71425__$1;
(statearr_71478_71541[(2)] = inst_71345);

(statearr_71478_71541[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (9))){
var inst_71337 = (state_71425[(10)]);
var inst_71299 = (state_71425[(23)]);
var inst_71338 = (state_71425[(20)]);
var inst_71351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71352 = [inst_71337,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_71353 = (new cljs.core.PersistentVector(null,2,(5),inst_71351,inst_71352,null));
var inst_71354 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71299,inst_71353);
var inst_71355 = cljs.core.__destructure_map(inst_71354);
var inst_71356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71355,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_71357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71355,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_71425__$1 = (function (){var statearr_71479 = state_71425;
(statearr_71479[(14)] = inst_71357);

(statearr_71479[(21)] = inst_71356);

return statearr_71479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71425__$1,(14),inst_71338);
} else {
if((state_val_71426 === (5))){
var _ = (function (){var statearr_71480 = state_71425;
(statearr_71480[(4)] = cljs.core.rest((state_71425[(4)])));

return statearr_71480;
})();
var state_71425__$1 = state_71425;
var ex71477 = (state_71425__$1[(2)]);
var statearr_71481_71542 = state_71425__$1;
(statearr_71481_71542[(5)] = ex71477);


var statearr_71482_71543 = state_71425__$1;
(statearr_71482_71543[(1)] = (4));

(statearr_71482_71543[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (14))){
var inst_71359 = (state_71425[(9)]);
var inst_71356 = (state_71425[(21)]);
var inst_71359__$1 = (state_71425[(2)]);
var inst_71360 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_71359__$1);
var state_71425__$1 = (function (){var statearr_71483 = state_71425;
(statearr_71483[(9)] = inst_71359__$1);

(statearr_71483[(28)] = inst_71360);

return statearr_71483;
})();
if(cljs.core.truth_(inst_71356)){
var statearr_71484_71544 = state_71425__$1;
(statearr_71484_71544[(1)] = (15));

} else {
var statearr_71485_71545 = state_71425__$1;
(statearr_71485_71545[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (26))){
var inst_71379 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
if(cljs.core.truth_(inst_71379)){
var statearr_71486_71546 = state_71425__$1;
(statearr_71486_71546[(1)] = (30));

} else {
var statearr_71487_71547 = state_71425__$1;
(statearr_71487_71547[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (16))){
var state_71425__$1 = state_71425;
var statearr_71488_71548 = state_71425__$1;
(statearr_71488_71548[(2)] = null);

(statearr_71488_71548[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (38))){
var inst_71360 = (state_71425[(28)]);
var inst_71401 = (state_71425[(2)]);
var state_71425__$1 = (function (){var statearr_71489 = state_71425;
(statearr_71489[(18)] = inst_71401);

return statearr_71489;
})();
if(cljs.core.truth_(inst_71360)){
var statearr_71490_71549 = state_71425__$1;
(statearr_71490_71549[(1)] = (39));

} else {
var statearr_71491_71550 = state_71425__$1;
(statearr_71491_71550[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (30))){
var state_71425__$1 = state_71425;
var statearr_71492_71551 = state_71425__$1;
(statearr_71492_71551[(2)] = (207));

(statearr_71492_71551[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (10))){
var inst_71418 = (state_71425[(2)]);
var state_71425__$1 = state_71425;
var statearr_71493_71552 = state_71425__$1;
(statearr_71493_71552[(2)] = inst_71418);

(statearr_71493_71552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (18))){
var inst_71362 = (state_71425[(13)]);
var state_71425__$1 = state_71425;
var statearr_71494_71553 = state_71425__$1;
(statearr_71494_71553[(2)] = inst_71362);

(statearr_71494_71553[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (42))){
var inst_71359 = (state_71425[(9)]);
var inst_71409 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_71359);
var state_71425__$1 = state_71425;
var statearr_71495_71554 = state_71425__$1;
(statearr_71495_71554[(2)] = inst_71409);

(statearr_71495_71554[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (37))){
var state_71425__$1 = state_71425;
var statearr_71496_71555 = state_71425__$1;
(statearr_71496_71555[(2)] = null);

(statearr_71496_71555[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71426 === (8))){
var inst_71295 = (state_71425[(22)]);
var state_71425__$1 = state_71425;
if(cljs.core.truth_(inst_71295)){
var statearr_71497_71556 = state_71425__$1;
(statearr_71497_71556[(1)] = (11));

} else {
var statearr_71498_71557 = state_71425__$1;
(statearr_71498_71557[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_71499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71499[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_71499[(1)] = (1));

return statearr_71499;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_71425){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71425);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71500){var ex__2730__auto__ = e71500;
var statearr_71501_71558 = state_71425;
(statearr_71501_71558[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71425[(4)]))){
var statearr_71502_71559 = state_71425;
(statearr_71502_71559[(1)] = cljs.core.first((state_71425[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71560 = state_71425;
state_71425 = G__71560;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_71425){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_71425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71503 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71503[(6)] = c__2749__auto__);

return statearr_71503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__71561 = query_type;
var G__71561__$1 = (((G__71561 instanceof cljs.core.Keyword))?G__71561.fqn:null);
switch (G__71561__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71561__$1)].join('')));

}
});
