// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.sha2');
goog.require('cljs.core');
goog.require('goog.crypt.Sha256');
goog.require('goog.crypt.Sha512');
fluree.crypto.sha2.hash = (function fluree$crypto$sha2$hash(ba,hash_size){
if(cljs.core.truth_((function (){var fexpr__73488 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(512),null,(256),null], null), null);
return (fexpr__73488.cljs$core$IFn$_invoke$arity$1 ? fexpr__73488.cljs$core$IFn$_invoke$arity$1(hash_size) : fexpr__73488.call(null,hash_size));
})())){
} else {
throw (new Error("Assert failed: (#{512 256} hash-size)"));
}

var digest = (function (){var G__73489 = hash_size;
switch (G__73489) {
case (256):
var G__73490 = (new goog.crypt.Sha256());
G__73490.update(ba);

return G__73490;

break;
case (512):
var G__73491 = (new goog.crypt.Sha512());
G__73491.update(ba);

return G__73491;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73489)].join('')));

}
})();
return digest.digest();
});
/**
 * Create a sha2 hash from byte-array.
 */
fluree.crypto.sha2.sha2_256 = (function fluree$crypto$sha2$sha2_256(ba){
return fluree.crypto.sha2.hash(ba,(256));
});
goog.exportSymbol('fluree.crypto.sha2.sha2_256', fluree.crypto.sha2.sha2_256);
/**
 * Create a sha2 hash from byte-array.
 */
fluree.crypto.sha2.sha2_512 = (function fluree$crypto$sha2$sha2_512(ba){
return fluree.crypto.sha2.hash(ba,(512));
});
goog.exportSymbol('fluree.crypto.sha2.sha2_512', fluree.crypto.sha2.sha2_512);
