// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.load');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.load.handle_refer_all = (function sci$impl$load$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var only__$1 = (cljs.core.truth_(only)?cljs.core.set.call(null,only):null);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,p__36760){
var vec__36761 = p__36760;
var k = cljs.core.nth.call(null,vec__36761,(0),null);
var v = cljs.core.nth.call(null,vec__36761,(1),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = (k instanceof cljs.core.Symbol);
if(and__5043__auto__){
var and__5043__auto____$1 = include_sym_QMARK_.call(null,k);
if(cljs.core.truth_(and__5043__auto____$1)){
return ((cljs.core.not.call(null,only__$1)) || (cljs.core.contains_QMARK_.call(null,only__$1,k)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,k),v);
} else {
return ns;
}
}),referred,the_loaded_ns);
return cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
});
sci.impl.load.handle_require_libspec_env = (function sci$impl$load$handle_require_libspec_env(_ctx,env,current_ns,the_loaded_ns,lib_name,p__36764){
var map__36765 = p__36764;
var map__36765__$1 = cljs.core.__destructure_map.call(null,map__36765);
var _parsed_libspec = map__36765__$1;
var as = cljs.core.get.call(null,map__36765__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.call(null,map__36765__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.call(null,map__36765__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.call(null,map__36765__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.call(null,map__36765__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var use = cljs.core.get.call(null,map__36765__$1,new cljs.core.Keyword(null,"use","use",-1846382424));
var the_current_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in.call(null,the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__5045__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set.call(null,exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_.call(null,excludes,sym)));
});
})():cljs.core.constantly.call(null,true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return use;
}
})())?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_.call(null,refer))?(function (){var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns__$1);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_.call(null,sym))){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,sym),(function (){var temp__5802__auto__ = cljs.core.find.call(null,the_loaded_ns,sym);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__36766 = temp__5802__auto__;
var _k = cljs.core.nth.call(null,vec__36766,(0),null);
var v = cljs.core.nth.call(null,vec__36766,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),referred,refer);
return cljs.core.assoc.call(null,the_current_ns__$1,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
})():(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use)?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
var temp__5804__auto___36770 = (function (){var G__36769 = the_loaded_ns;
var G__36769__$1 = (((G__36769 == null))?null:new cljs.core.Keyword(null,"obj","obj",981763962).cljs$core$IFn$_invoke$arity$1(G__36769));
var G__36769__$2 = (((G__36769__$1 == null))?null:cljs.core.meta.call(null,G__36769__$1));
if((G__36769__$2 == null)){
return null;
} else {
return new cljs.core.Keyword("sci.impl","required-fn","sci.impl/required-fn",2082701278).cljs$core$IFn$_invoke$arity$1(G__36769__$2);
}
})();
if(cljs.core.truth_(temp__5804__auto___36770)){
var on_loaded_36771 = temp__5804__auto___36770;
on_loaded_36771.call(null,cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return env__$1;
});
sci.impl.load.add_loaded_lib = (function sci$impl$load$add_loaded_lib(env,lib){
cljs.core.swap_BANG_.call(null,env,cljs.core.update,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652),(function (loaded_libs){
if((loaded_libs == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([lib]);
} else {
return cljs.core.conj.call(null,loaded_libs,lib);
}
}));

return null;
});
sci.impl.load.handle_require_libspec = (function sci$impl$load$handle_require_libspec(ctx,lib,opts){
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref.call(null,env_STAR_);
var cnn = sci.impl.vars.current_ns_name.call(null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"as-alias","as-alias",82482467).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var as_alias = temp__5802__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,null,lib,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),as_alias], null)));
} else {
var map__36772 = opts;
var map__36772__$1 = cljs.core.__destructure_map.call(null,map__36772);
var reload = cljs.core.get.call(null,map__36772__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var reload_all = cljs.core.get.call(null,map__36772__$1,new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
var namespaces = cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var reload_STAR_ = (function (){var or__5045__auto__ = reload;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = reload_all;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(ctx);
}
}
})();
var temp__5802__auto___36775__$1 = (cljs.core.truth_(reload_STAR_)?null:cljs.core.get.call(null,namespaces,lib));
if(cljs.core.truth_(temp__5802__auto___36775__$1)){
var the_loaded_ns_36776 = temp__5802__auto___36775__$1;
var loading_36777 = new cljs.core.Keyword(null,"loading","loading",-737050189).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_((function (){var and__5043__auto__ = loading_36777;
if(cljs.core.truth_(and__5043__auto__)){
return (((!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652).cljs$core$IFn$_invoke$arity$1(env),lib)))) && (cljs.core.nat_int_QMARK_.call(null,loading_36777.indexOf(lib))));
} else {
return and__5043__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,(function (){var lib_emphasized = ["[ ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib)," ]"].join('');
var loading__$1 = cljs.core.conj.call(null,loading_36777,lib);
var loading__$2 = cljs.core.replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([lib,lib_emphasized]),loading__$1);
return ["Cyclic load dependency: ",clojure.string.join.call(null,"->",loading__$2)].join('');
})(),lib);
} else {
cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns_36776,lib,opts));
}
} else {
var temp__5802__auto___36778__$2 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_(temp__5802__auto___36778__$2)){
var load_fn_36779 = temp__5802__auto___36778__$2;
var temp__5802__auto___36780__$3 = load_fn_36779.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib,new cljs.core.Keyword(null,"reload","reload",863702807),(function (){var or__5045__auto__ = reload;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return reload_all;
}
})()], null));
if(cljs.core.truth_(temp__5802__auto___36780__$3)){
var map__36773_36781 = temp__5802__auto___36780__$3;
var map__36773_36782__$1 = cljs.core.__destructure_map.call(null,map__36773_36781);
var file_36783 = cljs.core.get.call(null,map__36773_36782__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source_36784 = cljs.core.get.call(null,map__36773_36782__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var ctx_36785__$1 = cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"reload-all","reload-all",761570200),reload_all),new cljs.core.Keyword(null,"loading","loading",-737050189),(function (loading){
if((loading == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null);
} else {
return cljs.core.conj.call(null,loading,lib);
}
}));
try{sci.impl.vars.push_thread_bindings.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,cljs.core.deref.call(null,sci.impl.vars.current_ns),sci.impl.vars.current_file,file_36783]));

try{cljs.core.deref.call(null,sci.impl.utils.eval_string_STAR_).call(null,ctx_36785__$1,source_36784);
}finally {sci.impl.vars.pop_thread_bindings.call(null);
}}catch (e36774){if((e36774 instanceof Error)){
var e_36786 = e36774;
cljs.core.swap_BANG_.call(null,env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,lib);

throw e_36786;
} else {
throw e36774;

}
}
cljs.core.swap_BANG_.call(null,env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.call(null,env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.call(null,namespaces__$1,lib);
return sci.impl.load.handle_require_libspec_env.call(null,ctx,env__$1,cnn,the_loaded_ns,lib,opts);
}));
} else {
var or__5045__auto___36787 = (cljs.core.truth_(reload_STAR_)?(function (){var temp__5804__auto__ = cljs.core.get.call(null,namespaces,lib);
if(cljs.core.truth_(temp__5804__auto__)){
var the_loaded_ns = temp__5804__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns,lib,opts));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__5045__auto___36787)){
} else {
throw (new Error(["Could not find namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib),"."].join('')));
}
}
} else {
throw (new Error(["Could not find namespace ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib),"."].join('')));
}
}

sci.impl.load.add_loaded_lib.call(null,env_STAR_,lib);

return null;
}
});
sci.impl.load.load_lib = (function sci$impl$load$load_lib(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36792 = arguments.length;
var i__5770__auto___36793 = (0);
while(true){
if((i__5770__auto___36793 < len__5769__auto___36792)){
args__5775__auto__.push((arguments[i__5770__auto___36793]));

var G__36794 = (i__5770__auto___36793 + (1));
i__5770__auto___36793 = G__36794;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,prefix,lib,options){
if(cljs.core.truth_((function (){var and__5043__auto__ = prefix;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.name.call(null,lib).indexOf(".") > (0));
} else {
return and__5043__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,["Found lib name '",cljs.core.name.call(null,lib),"' containing period with prefix '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),"'.  lib names inside prefix lists must not contain periods"].join(''),lib);
} else {
}

var lib__$1 = (cljs.core.truth_(prefix)?cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib)].join('')):lib);
var opts = cljs.core.apply.call(null,cljs.core.hash_map,options);
return sci.impl.load.handle_require_libspec.call(null,ctx,lib__$1,opts);
}));

(sci.impl.load.load_lib.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(sci.impl.load.load_lib.cljs$lang$applyTo = (function (seq36788){
var G__36789 = cljs.core.first.call(null,seq36788);
var seq36788__$1 = cljs.core.next.call(null,seq36788);
var G__36790 = cljs.core.first.call(null,seq36788__$1);
var seq36788__$2 = cljs.core.next.call(null,seq36788__$1);
var G__36791 = cljs.core.first.call(null,seq36788__$2);
var seq36788__$3 = cljs.core.next.call(null,seq36788__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36789,G__36790,G__36791,seq36788__$3);
}));

/**
 * Prepends a symbol or a seq to coll
 */
sci.impl.load.prependss = (function sci$impl$load$prependss(x,coll){
if((x instanceof cljs.core.Symbol)){
return cljs.core.cons.call(null,x,coll);
} else {
return cljs.core.concat.call(null,x,coll);
}
});
/**
 * Returns true if x is a libspec
 */
sci.impl.load.libspec_QMARK_ = (function sci$impl$load$libspec_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) || (((cljs.core.vector_QMARK_.call(null,x)) && ((((cljs.core.second.call(null,x) == null)) || ((cljs.core.second.call(null,x) instanceof cljs.core.Keyword)))))));
});
/**
 * Loads libs, evaling libspecs, prefix lists, and flags for
 *   forwarding to load-lib
 */
sci.impl.load.load_libs = (function sci$impl$load$load_libs(ctx,kw,args){
var args_STAR_ = cljs.core.cons.call(null,kw,args);
var flags = cljs.core.filter.call(null,cljs.core.keyword_QMARK_,args_STAR_);
var opts = cljs.core.interleave.call(null,flags,cljs.core.repeat.call(null,true));
var args_STAR___$1 = cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),args_STAR_);
var supported_36827 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"use","use",-1846382424),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"require","require",-468001333),null,new cljs.core.Keyword(null,"verbose","verbose",1694226060),null,new cljs.core.Keyword(null,"reload","reload",863702807),null,new cljs.core.Keyword(null,"reload-all","reload-all",761570200),null,new cljs.core.Keyword(null,"refer","refer",-964295553),null], null), null);
var unsupported_36828 = cljs.core.seq.call(null,cljs.core.remove.call(null,supported_36827,flags));
if(unsupported_36828){
sci.impl.utils.throw_error_with_location.call(null,cljs.core.apply.call(null,cljs.core.str,"Unsupported option(s) supplied: ",cljs.core.interpose.call(null,",",unsupported_36828)),args);
} else {
}

if(cljs.core.seq.call(null,args_STAR___$1)){
} else {
sci.impl.utils.throw_error_with_location.call(null,"Nothing specified to load",args);
}

var seq__36795 = cljs.core.seq.call(null,args_STAR___$1);
var chunk__36796 = null;
var count__36797 = (0);
var i__36798 = (0);
while(true){
if((i__36798 < count__36797)){
var arg = cljs.core._nth.call(null,chunk__36796,i__36798);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__36813_36829 = arg;
var seq__36814_36830 = cljs.core.seq.call(null,vec__36813_36829);
var first__36815_36831 = cljs.core.first.call(null,seq__36814_36830);
var seq__36814_36832__$1 = cljs.core.next.call(null,seq__36814_36830);
var prefix_36833 = first__36815_36831;
var args_STAR__36834__$2 = seq__36814_36832__$1;
if((prefix_36833 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__36816_36835 = cljs.core.seq.call(null,args_STAR__36834__$2);
var chunk__36817_36836 = null;
var count__36818_36837 = (0);
var i__36819_36838 = (0);
while(true){
if((i__36819_36838 < count__36818_36837)){
var arg_36839__$1 = cljs.core._nth.call(null,chunk__36817_36836,i__36819_36838);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_36833,sci.impl.load.prependss.call(null,arg_36839__$1,opts));


var G__36840 = seq__36816_36835;
var G__36841 = chunk__36817_36836;
var G__36842 = count__36818_36837;
var G__36843 = (i__36819_36838 + (1));
seq__36816_36835 = G__36840;
chunk__36817_36836 = G__36841;
count__36818_36837 = G__36842;
i__36819_36838 = G__36843;
continue;
} else {
var temp__5804__auto___36844 = cljs.core.seq.call(null,seq__36816_36835);
if(temp__5804__auto___36844){
var seq__36816_36845__$1 = temp__5804__auto___36844;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36816_36845__$1)){
var c__5568__auto___36846 = cljs.core.chunk_first.call(null,seq__36816_36845__$1);
var G__36847 = cljs.core.chunk_rest.call(null,seq__36816_36845__$1);
var G__36848 = c__5568__auto___36846;
var G__36849 = cljs.core.count.call(null,c__5568__auto___36846);
var G__36850 = (0);
seq__36816_36835 = G__36847;
chunk__36817_36836 = G__36848;
count__36818_36837 = G__36849;
i__36819_36838 = G__36850;
continue;
} else {
var arg_36851__$1 = cljs.core.first.call(null,seq__36816_36845__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_36833,sci.impl.load.prependss.call(null,arg_36851__$1,opts));


var G__36852 = cljs.core.next.call(null,seq__36816_36845__$1);
var G__36853 = null;
var G__36854 = (0);
var G__36855 = (0);
seq__36816_36835 = G__36852;
chunk__36817_36836 = G__36853;
count__36818_36837 = G__36854;
i__36819_36838 = G__36855;
continue;
}
} else {
}
}
break;
}
}


var G__36856 = seq__36795;
var G__36857 = chunk__36796;
var G__36858 = count__36797;
var G__36859 = (i__36798 + (1));
seq__36795 = G__36856;
chunk__36796 = G__36857;
count__36797 = G__36858;
i__36798 = G__36859;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__36795);
if(temp__5804__auto__){
var seq__36795__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36795__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__36795__$1);
var G__36860 = cljs.core.chunk_rest.call(null,seq__36795__$1);
var G__36861 = c__5568__auto__;
var G__36862 = cljs.core.count.call(null,c__5568__auto__);
var G__36863 = (0);
seq__36795 = G__36860;
chunk__36796 = G__36861;
count__36797 = G__36862;
i__36798 = G__36863;
continue;
} else {
var arg = cljs.core.first.call(null,seq__36795__$1);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__36820_36864 = arg;
var seq__36821_36865 = cljs.core.seq.call(null,vec__36820_36864);
var first__36822_36866 = cljs.core.first.call(null,seq__36821_36865);
var seq__36821_36867__$1 = cljs.core.next.call(null,seq__36821_36865);
var prefix_36868 = first__36822_36866;
var args_STAR__36869__$2 = seq__36821_36867__$1;
if((prefix_36868 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__36823_36870 = cljs.core.seq.call(null,args_STAR__36869__$2);
var chunk__36824_36871 = null;
var count__36825_36872 = (0);
var i__36826_36873 = (0);
while(true){
if((i__36826_36873 < count__36825_36872)){
var arg_36874__$1 = cljs.core._nth.call(null,chunk__36824_36871,i__36826_36873);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_36868,sci.impl.load.prependss.call(null,arg_36874__$1,opts));


var G__36875 = seq__36823_36870;
var G__36876 = chunk__36824_36871;
var G__36877 = count__36825_36872;
var G__36878 = (i__36826_36873 + (1));
seq__36823_36870 = G__36875;
chunk__36824_36871 = G__36876;
count__36825_36872 = G__36877;
i__36826_36873 = G__36878;
continue;
} else {
var temp__5804__auto___36879__$1 = cljs.core.seq.call(null,seq__36823_36870);
if(temp__5804__auto___36879__$1){
var seq__36823_36880__$1 = temp__5804__auto___36879__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36823_36880__$1)){
var c__5568__auto___36881 = cljs.core.chunk_first.call(null,seq__36823_36880__$1);
var G__36882 = cljs.core.chunk_rest.call(null,seq__36823_36880__$1);
var G__36883 = c__5568__auto___36881;
var G__36884 = cljs.core.count.call(null,c__5568__auto___36881);
var G__36885 = (0);
seq__36823_36870 = G__36882;
chunk__36824_36871 = G__36883;
count__36825_36872 = G__36884;
i__36826_36873 = G__36885;
continue;
} else {
var arg_36886__$1 = cljs.core.first.call(null,seq__36823_36880__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_36868,sci.impl.load.prependss.call(null,arg_36886__$1,opts));


var G__36887 = cljs.core.next.call(null,seq__36823_36880__$1);
var G__36888 = null;
var G__36889 = (0);
var G__36890 = (0);
seq__36823_36870 = G__36887;
chunk__36824_36871 = G__36888;
count__36825_36872 = G__36889;
i__36826_36873 = G__36890;
continue;
}
} else {
}
}
break;
}
}


var G__36891 = cljs.core.next.call(null,seq__36795__$1);
var G__36892 = null;
var G__36893 = (0);
var G__36894 = (0);
seq__36795 = G__36891;
chunk__36796 = G__36892;
count__36797 = G__36893;
i__36798 = G__36894;
continue;
}
} else {
return null;
}
}
break;
}
});
sci.impl.load.eval_require = (function sci$impl$load$eval_require(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36897 = arguments.length;
var i__5770__auto___36898 = (0);
while(true){
if((i__5770__auto___36898 < len__5769__auto___36897)){
args__5775__auto__.push((arguments[i__5770__auto___36898]));

var G__36899 = (i__5770__auto___36898 + (1));
i__5770__auto___36898 = G__36899;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"require","require",-468001333),args);
}));

(sci.impl.load.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_require.cljs$lang$applyTo = (function (seq36895){
var G__36896 = cljs.core.first.call(null,seq36895);
var seq36895__$1 = cljs.core.next.call(null,seq36895);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36896,seq36895__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_require_state,sci.impl.load.eval_require);
sci.impl.load.eval_use = (function sci$impl$load$eval_use(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36902 = arguments.length;
var i__5770__auto___36903 = (0);
while(true){
if((i__5770__auto___36903 < len__5769__auto___36902)){
args__5775__auto__.push((arguments[i__5770__auto___36903]));

var G__36904 = (i__5770__auto___36903 + (1));
i__5770__auto___36903 = G__36904;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"use","use",-1846382424),args);
}));

(sci.impl.load.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_use.cljs$lang$applyTo = (function (seq36900){
var G__36901 = cljs.core.first.call(null,seq36900);
var seq36900__$1 = cljs.core.next.call(null,seq36900);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36901,seq36900__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_use_state,sci.impl.load.eval_use);
sci.impl.load.eval_refer_clojure = (function sci$impl$load$eval_refer_clojure(ctx,exprs){
var ns_sym = new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null);
var exprs__$1 = exprs;
while(true){
if(cljs.core.truth_(exprs__$1)){
var vec__36905 = exprs__$1;
var k = cljs.core.nth.call(null,vec__36905,(0),null);
var v = cljs.core.nth.call(null,vec__36905,(1),null);
var G__36908_36913 = k;
var G__36908_36914__$1 = (((G__36908_36913 instanceof cljs.core.Keyword))?G__36908_36913.fqn:null);
switch (G__36908_36914__$1) {
case "exclude":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.vars.current_ns_name.call(null);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym))
);

break;
case "only":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.vars.current_ns_name.call(null);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var other_vars = cljs.core.select_keys.call(null,other_ns,v);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),cljs.core.merge,other_vars);
});})(exprs__$1,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym))
);

break;
case "rename":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.vars.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var the_current_ns__$1 = cljs.core.reduce.call(null,((function (exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym){
return (function (acc,p__36909){
var vec__36910 = p__36909;
var original_name = cljs.core.nth.call(null,vec__36910,(0),null);
var new_name = cljs.core.nth.call(null,vec__36910,(1),null);
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refers","refers",158076809),new_name], null),cljs.core.get.call(null,other_ns,original_name)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),original_name);
});})(exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym))
,the_current_ns,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});})(exprs__$1,G__36908_36913,G__36908_36914__$1,vec__36905,k,v,ns_sym))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36908_36914__$1)].join('')));

}

var G__36916 = cljs.core.nnext.call(null,exprs__$1);
exprs__$1 = G__36916;
continue;
} else {
return null;
}
break;
}
});
sci.impl.load.eval_refer_STAR_ = (function sci$impl$load$eval_refer_STAR_(env,ns_sym,filters){

var cnn = sci.impl.vars.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var ns = (function (){var or__5045__auto__ = cljs.core.get.call(null,namespaces,ns_sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw (new Error(["No namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_sym)].join('')));
}
})();
var fs = cljs.core.apply.call(null,cljs.core.hash_map,filters);
var public_keys = cljs.core.filter.call(null,cljs.core.symbol_QMARK_,cljs.core.keys.call(null,ns));
var rename = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"rename","rename",1508157613).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var exclude = cljs.core.set.call(null,new cljs.core.Keyword(null,"exclude","exclude",-1230250334).cljs$core$IFn$_invoke$arity$1(fs));
var to_do = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs)))?public_keys:(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"only","only",1907811652).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return public_keys;
}
}
})());
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = to_do;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.sequential_QMARK_.call(null,to_do)));
} else {
return and__5043__auto__;
}
})())?(function(){throw (new Error(":only/:refer value must be a sequential collection of symbols"))})():null);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var referred__$1 = cljs.core.reduce.call(null,(function (referred__$1,sym){
if(cljs.core.not.call(null,exclude.call(null,sym))){
var v = cljs.core.get.call(null,ns,sym);
if(cljs.core.truth_(v)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')
));
}

return cljs.core.assoc.call(null,referred__$1,(function (){var or__5045__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return sym;
}
})(),v);
} else {
return referred__$1;
}
}),referred,to_do);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
var namespaces__$1 = cljs.core.assoc.call(null,namespaces,cnn,the_current_ns__$1);
var env__$1 = cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespaces__$1);
return env__$1;
});
/**
 * The function equivalent of :refer is handled differently than what we
 *   did before (this is more like what Clojure itself does.) For
 *   referring clojure.core we still use the old code.
 */
sci.impl.load.eval_refer = (function sci$impl$load$eval_refer(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36920 = arguments.length;
var i__5770__auto___36921 = (0);
while(true){
if((i__5770__auto___36921 < len__5769__auto___36920)){
args__5775__auto__.push((arguments[i__5770__auto___36921]));

var G__36922 = (i__5770__auto___36921 + (1));
i__5770__auto___36921 = G__36922;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,ns_sym,filters){
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null),ns_sym)){
sci.impl.load.eval_refer_clojure.call(null,ctx,filters);
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),sci.impl.load.eval_refer_STAR_,ns_sym,filters);
}

return null;
}));

(sci.impl.load.eval_refer.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.load.eval_refer.cljs$lang$applyTo = (function (seq36917){
var G__36918 = cljs.core.first.call(null,seq36917);
var seq36917__$1 = cljs.core.next.call(null,seq36917);
var G__36919 = cljs.core.first.call(null,seq36917__$1);
var seq36917__$2 = cljs.core.next.call(null,seq36917__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36918,G__36919,seq36917__$2);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_refer_state,sci.impl.load.eval_refer);
