// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.js');
fluree.db.util.core.max_long = (9007199254740991);
fluree.db.util.core.min_long = (-9007199254740991);
fluree.db.util.core.max_integer = (2147483647);
fluree.db.util.core.min_integer = (-2147483647);
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
fluree.db.util.core.cljs_env_QMARK_ = (function fluree$db$util$core$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});
var ret__5824__auto___2884 = /**
 * Return then if we are generating cljs code and else for Clojure code.
 * https://groups.google.com/d/msg/clojurescript/iBY5HaQda4A/w1lAQi9_AwsJ
 */
fluree.db.util.core.if_cljs = (function fluree$db$util$core$if_cljs(_AMPERSAND_form,_AMPERSAND_env,then,else$){
if(fluree.db.util.core.cljs_env_QMARK_.call(null,_AMPERSAND_env)){
return then;
} else {
return else$;
}
});
(fluree.db.util.core.if_cljs.cljs$lang$macro = true);

var ret__5824__auto___2891 = (function (){
/**
 * A cross-platform variant of try-catch that catches all exceptions.
 * Does not (yet) support finally, and does not need or want an exception class.
 */
fluree.db.util.core.try_catchall = (function fluree$db$util$core$try_catchall(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2892 = arguments.length;
var i__5770__auto___2893 = (0);
while(true){
if((i__5770__auto___2893 < len__5769__auto___2892)){
args__5775__auto__.push((arguments[i__5770__auto___2893]));

var G__2894 = (i__5770__auto___2893 + (1));
i__5770__auto___2893 = G__2894;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
var try_body = cljs.core.butlast.call(null,body);
var vec__2888 = cljs.core.last.call(null,body);
var seq__2889 = cljs.core.seq.call(null,vec__2888);
var first__2890 = cljs.core.first.call(null,seq__2889);
var seq__2889__$1 = cljs.core.next.call(null,seq__2889);
var catch$ = first__2890;
var first__2890__$1 = cljs.core.first.call(null,seq__2889__$1);
var seq__2889__$2 = cljs.core.next.call(null,seq__2889__$1);
var sym = first__2890__$1;
var catch_body = seq__2889__$2;
var catch_form = vec__2888;
if(cljs.core._EQ_.call(null,catch$,new cljs.core.Symbol(null,"catch","catch",-1616370245,null))){
} else {
throw (new Error("Assert failed: (= catch (quote catch))"));
}

if((sym instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? sym)"));
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("js","Object","js/Object",61215323,null),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)),catch_body))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","Throwable","fluree.db.util.core/Throwable",853138167,null),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)),catch_body))),null,(1),null))))),null,(1),null)))));
}));

(fluree.db.util.core.try_catchall.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_catchall.cljs$lang$applyTo = (function (seq2885){
var G__2886 = cljs.core.first.call(null,seq2885);
var seq2885__$1 = cljs.core.next.call(null,seq2885);
var G__2887 = cljs.core.first.call(null,seq2885__$1);
var seq2885__$2 = cljs.core.next.call(null,seq2885__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2886,G__2887,seq2885__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_catchall.cljs$lang$macro = true);

var ret__5824__auto___2898 = (function (){
/**
 * Like try but supports catch*. catch* is like catch but supports CLJ/CLJS with
 *   less boilerplate. In CLJ it catches `Exception`. In CLJS it catches `:default`.
 *   Use it like this: `(try* ... (catch* err (handle-err err)))`.
 *   Also supports an optional finally clause.
 */
fluree.db.util.core.try_STAR_ = (function fluree$db$util$core$try_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2899 = arguments.length;
var i__5770__auto___2900 = (0);
while(true){
if((i__5770__auto___2900 < len__5769__auto___2899)){
args__5775__auto__.push((arguments[i__5770__auto___2900]));

var G__2901 = (i__5770__auto___2900 + (1));
i__5770__auto___2900 = G__2901;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs-exceptions","try*","cljs-exceptions/try*",-1080387872,null),null,(1),null)),body))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("clj-exceptions","try*","clj-exceptions/try*",1421445009,null),null,(1),null)),body))),null,(1),null)))));
}));

(fluree.db.util.core.try_STAR_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_STAR_.cljs$lang$applyTo = (function (seq2895){
var G__2896 = cljs.core.first.call(null,seq2895);
var seq2895__$1 = cljs.core.next.call(null,seq2895);
var G__2897 = cljs.core.first.call(null,seq2895__$1);
var seq2895__$2 = cljs.core.next.call(null,seq2895__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2896,G__2897,seq2895__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_STAR_.cljs$lang$macro = true);

fluree.db.util.core.index_of = (function fluree$db$util$core$index_of(coll,value){
return cljs.core.some.call(null,(function (p__2902){
var vec__2903 = p__2902;
var item = cljs.core.nth.call(null,vec__2903,(0),null);
var idx = cljs.core.nth.call(null,vec__2903,(1),null);
if(cljs.core._EQ_.call(null,value,item)){
return idx;
} else {
return null;
}
}),cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,coll,cljs.core.range.call(null))));
});
/**
 * Given a date, returns epoch millis if possible.
 */
fluree.db.util.core.date__GT_millis = (function fluree$db$util$core$date__GT_millis(date){
if(typeof date === 'string'){
return Date.parse(date).getTime();
} else {
if(typeof date === 'number'){
return date;
} else {
if((date instanceof Date)){
return date.getTime();
} else {
throw cljs.core.ex_info.call(null,["Invalid date: ",cljs.core.pr_str.call(null,date)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-date","db/invalid-date",2030527951)], null));

}
}
}
});
/**
 * Returns current time in epoch milliseonds for closure/script
 */
fluree.db.util.core.current_time_millis = (function fluree$db$util$core$current_time_millis(){
return (new Date()).getTime();
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.util.core.response_time_formatted = (function fluree$db$util$core$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis.call(null) - start_time)),"ms"].join('');
});
fluree.db.util.core.deep_merge = (function fluree$db$util$core$deep_merge(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2911 = arguments.length;
var i__5770__auto___2912 = (0);
while(true){
if((i__5770__auto___2912 < len__5769__auto___2911)){
args__5775__auto__.push((arguments[i__5770__auto___2912]));

var G__2913 = (i__5770__auto___2912 + (1));
i__5770__auto___2912 = G__2913;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (v,vs){
var rec_merge = (function fluree$db$util$core$rec_merge(v1,v2){
if(((cljs.core.map_QMARK_.call(null,v1)) && (cljs.core.map_QMARK_.call(null,v2)))){
return cljs.core.merge_with.call(null,fluree.db.util.core.deep_merge,v1,v2);
} else {
return v2;
}
});
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,vs))){
return cljs.core.reduce.call(null,(function (p1__2907_SHARP_,p2__2908_SHARP_){
return rec_merge.call(null,p1__2907_SHARP_,p2__2908_SHARP_);
}),v,vs);
} else {
return v;
}
}));

(fluree.db.util.core.deep_merge.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.util.core.deep_merge.cljs$lang$applyTo = (function (seq2909){
var G__2910 = cljs.core.first.call(null,seq2909);
var seq2909__$1 = cljs.core.next.call(null,seq2909);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2910,seq2909__$1);
}));

fluree.db.util.core.email_QMARK_ = (function fluree$db$util$core$email_QMARK_(email){
return cljs.core.re_matches.call(null,/^[\w-\+]+(\.[\w]+)*@[\w-]+(\.[\w]+)*(\.[a-z]{2,})$/,email);
});
/**
 * Tests if an predicate identity two-tuple
 *   in form of [pred-name-or-id pred-value]
 */
fluree.db.util.core.pred_ident_QMARK_ = (function fluree$db$util$core$pred_ident_QMARK_(x){
return ((cljs.core.sequential_QMARK_.call(null,x)) && (((cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,x))) && (typeof cljs.core.first.call(null,x) === 'string'))));
});
fluree.db.util.core.temp_ident_QMARK_ = (function fluree$db$util$core$temp_ident_QMARK_(x){
return typeof x === 'string';
});
/**
 * Tests if an _id is a numeric or predicate-ident
 */
fluree.db.util.core.subj_ident_QMARK_ = (function fluree$db$util$core$subj_ident_QMARK_(x){
return ((cljs.core.int_QMARK_.call(null,x)) || (fluree.db.util.core.pred_ident_QMARK_.call(null,x)));
});
/**
 * Converts string to integer. Assumes you've already verified the string is
 *   parsable to an integer.
 */
fluree.db.util.core.str__GT_int = (function fluree$db$util$core$str__GT_int(s){
return parseInt(s);
});
/**
 * Converts a keyword to string. Can safely be called on a
 *   string which will return itself.
 */
fluree.db.util.core.keyword__GT_str = (function fluree$db$util$core$keyword__GT_str(k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),(1));
} else {
if(typeof k === 'string'){
return k;
} else {
throw cljs.core.ex_info.call(null,["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,k))," to string: ",cljs.core.pr_str.call(null,k)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Converts a string to a keyword, checking to see if
 *   the string starts with a ':', which it strips before converting.
 */
fluree.db.util.core.str__GT_keyword = (function fluree$db$util$core$str__GT_keyword(s){
if(typeof s === 'string'){
if(clojure.string.starts_with_QMARK_.call(null,s,":")){
return cljs.core.keyword.call(null,cljs.core.subs.call(null,s,(1)));
} else {
return cljs.core.keyword.call(null,s);
}
} else {
if((s instanceof cljs.core.Keyword)){
return s;
} else {
throw cljs.core.ex_info.call(null,["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,s))," to keyword: ",cljs.core.pr_str.call(null,s)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Takes time as a string and returns an java.time.Instant.
 */
fluree.db.util.core.str__GT_epoch_ms = (function fluree$db$util$core$str__GT_epoch_ms(time_str){
try{return Date.parse(time_str);
}catch (e2914){var _ = e2914;
throw cljs.core.ex_info.call(null,["Invalid time string. Ensure format is ISO-8601 compatible. Provided: ",cljs.core.pr_str.call(null,time_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-time","db/invalid-time",-1496866235)], null));
}});
/**
 * Truncate string s to n characters.
 */
fluree.db.util.core.trunc = (function fluree$db$util$core$trunc(s,n){
if((cljs.core.count.call(null,s) < n)){
return s;
} else {
return [cljs.core.subs.call(null,s,(0),n)," ..."].join('');
}
});
var ret__5824__auto___2922 = (function (){
fluree.db.util.core.some_of = (function fluree$db$util$core$some_of(var_args){
var G__2921 = arguments.length;
switch (G__2921) {
case 2:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___2924 = arguments.length;
var i__5770__auto___2925 = (0);
while(true){
if((i__5770__auto___2925 < len__5769__auto___2924)){
args_arr__5794__auto__.push((arguments[i__5770__auto___2925]));

var G__2926 = (i__5770__auto___2925 + (1));
i__5770__auto___2925 = G__2926;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"x__2915__auto__","x__2915__auto__",-1087814016,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__2915__auto__","x__2915__auto__",-1087814016,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","some-of","fluree.db.util.core/some-of",1946305325,null),null,(1),null)),more))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__2915__auto__","x__2915__auto__",-1087814016,null),null,(1),null))))),null,(1),null)))));
}));

/** @this {Function} */
(fluree.db.util.core.some_of.cljs$lang$applyTo = (function (seq2917){
var G__2918 = cljs.core.first.call(null,seq2917);
var seq2917__$1 = cljs.core.next.call(null,seq2917);
var G__2919 = cljs.core.first.call(null,seq2917__$1);
var seq2917__$2 = cljs.core.next.call(null,seq2917__$1);
var G__2920 = cljs.core.first.call(null,seq2917__$2);
var seq2917__$3 = cljs.core.next.call(null,seq2917__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2918,G__2919,G__2920,seq2917__$3);
}));

(fluree.db.util.core.some_of.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.util.core.some_of.cljs$lang$macro = true);

/**
 * Filters map k/v pairs dropping any where predicate applied to value is false.
 */
fluree.db.util.core.filter_vals = (function fluree$db$util$core$filter_vals(pred,m){
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
if(cljs.core.truth_(pred.call(null,v))){
return cljs.core.assoc.call(null,m__$1,k,v);
} else {
return m__$1;
}
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Remove all keys from a map that have nil or empty collection values.
 */
fluree.db.util.core.without_nils = (function fluree$db$util$core$without_nils(m){
return fluree.db.util.core.filter_vals.call(null,(function (p1__2927_SHARP_){
if(cljs.core.coll_QMARK_.call(null,p1__2927_SHARP_)){
return cljs.core.not_empty.call(null,p1__2927_SHARP_);
} else {
return (!((p1__2927_SHARP_ == null)));
}
}),m);
});
/**
 * Like range, but includes start/end values.
 */
fluree.db.util.core.inclusive_range = (function fluree$db$util$core$inclusive_range(var_args){
var G__2929 = arguments.length;
switch (G__2929) {
case 0:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.call(null);
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.call(null,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.call(null,start,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return cljs.core.range.call(null,start,(end + step),step);
}));

(fluree.db.util.core.inclusive_range.cljs$lang$maxFixedArity = 3);

/**
 * x-platform, returns true if is an execption
 */
fluree.db.util.core.exception_QMARK_ = (function fluree$db$util$core$exception_QMARK_(x){
return (x instanceof Error);
});
fluree.db.util.core.url_encode = (function fluree$db$util$core$url_encode(string){
var G__2931 = string;
var G__2931__$1 = (((G__2931 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__2931));
var G__2931__$2 = (((G__2931__$1 == null))?null:encodeURIComponent(G__2931__$1));
if((G__2931__$2 == null)){
return null;
} else {
return G__2931__$2.replace("+","%20");
}
});
fluree.db.util.core.url_decode = (function fluree$db$util$core$url_decode(var_args){
var G__2933 = arguments.length;
switch (G__2933) {
case 1:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1 = (function (string){
return fluree.db.util.core.url_decode.call(null,string,"UTF-8");
}));

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2 = (function (string,encoding){
var G__2934 = string;
var G__2934__$1 = (((G__2934 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__2934));
if((G__2934__$1 == null)){
return null;
} else {
return decodeURIComponent(G__2934__$1);
}
}));

(fluree.db.util.core.url_decode.cljs$lang$maxFixedArity = 2);

fluree.db.util.core.map_invert = (function fluree$db$util$core$map_invert(m){
return cljs.core.reduce.call(null,(function (m__$1,p__2936){
var vec__2937 = p__2936;
var k = cljs.core.nth.call(null,vec__2937,(0),null);
var v = cljs.core.nth.call(null,vec__2937,(1),null);
return cljs.core.assoc.call(null,m__$1,v,k);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Zero pads x
 */
fluree.db.util.core.zero_pad = (function fluree$db$util$core$zero_pad(x,pad){
var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((s.length < pad)){
var G__2940 = ["0",s].join('');
s = G__2940;
continue;
} else {
return s;
}
break;
}
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.util.core.conjv = (function fluree$db$util$core$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
var ret__5824__auto___2952 = (function (){
/**
 * Takes an expression and a set of clauses.
 *   Each clause can take the form of either:
 * 
 *   unary-predicate-fn? result-expr
 *   (unary-predicate-fn?-1 ... unary-predicate-fn?-N) result-expr
 * 
 *   For each clause, (unary-predicate-fn? expr) is evalated (for each
 *   unary-predicate-fn? in the clause when >1 is given). If it returns logical
 *   true, the clause is a match.
 * 
 *   Similar to condp but takes unary predicates instead of binary and allows
 *   multiple predicates to be supplied in a list similar to case.
 */
fluree.db.util.core.condps = (function fluree$db$util$core$condps(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2953 = arguments.length;
var i__5770__auto___2954 = (0);
while(true){
if((i__5770__auto___2954 < len__5769__auto___2953)){
args__5775__auto__.push((arguments[i__5770__auto___2954]));

var G__2955 = (i__5770__auto___2954 + (1));
i__5770__auto___2954 = G__2955;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return fluree.db.util.core.condps.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(fluree.db.util.core.condps.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,clauses){
var gexpr = cljs.core.gensym.call(null,"expr__");
var emit = (function fluree$db$util$core$emit(expr__$1,args){
var vec__2945 = cljs.core.split_at.call(null,(2),args);
var vec__2948 = cljs.core.nth.call(null,vec__2945,(0),null);
var a = cljs.core.nth.call(null,vec__2948,(0),null);
var b = cljs.core.nth.call(null,vec__2948,(1),null);
var clause = vec__2948;
var more = cljs.core.nth.call(null,vec__2945,(1),null);
var n = cljs.core.count.call(null,clause);
var G__2951 = n;
switch (G__2951) {
case (0):
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"throw","throw",595905694,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"IllegalArgumentException.","IllegalArgumentException.",-1885081185,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),null,(1),null)),(new cljs.core.List(null,"No matching clause: ",null,(1),null)),(new cljs.core.List(null,expr__$1,null,(1),null))))),null,(1),null))))),null,(1),null)))));

break;
case (1):
return a;

break;
default:
var preds = ((((cljs.core.coll_QMARK_.call(null,a)) && ((((!(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.first.call(null,a))))) && ((!(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"fn","fn",465265323,null),cljs.core.first.call(null,a)))))))))?cljs.core.vec.call(null,a):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),null,(1),null)),(new cljs.core.List(null,preds,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,expr__$1,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,b,null,(1),null)),(new cljs.core.List(null,fluree$db$util$core$emit.call(null,expr__$1,more),null,(1),null)))));

}
});
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,gexpr,null,(1),null)),(new cljs.core.List(null,expr,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,emit.call(null,gexpr,clauses),null,(1),null)))));
}));

(fluree.db.util.core.condps.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(fluree.db.util.core.condps.cljs$lang$applyTo = (function (seq2941){
var G__2942 = cljs.core.first.call(null,seq2941);
var seq2941__$1 = cljs.core.next.call(null,seq2941);
var G__2943 = cljs.core.first.call(null,seq2941__$1);
var seq2941__$2 = cljs.core.next.call(null,seq2941__$1);
var G__2944 = cljs.core.first.call(null,seq2941__$2);
var seq2941__$3 = cljs.core.next.call(null,seq2941__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2942,G__2943,G__2944,seq2941__$3);
}));

return null;
})()
;
(fluree.db.util.core.condps.cljs$lang$macro = true);

