// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23670,error_ch,vars,p__23671){
var map__23672 = p__23670;
var map__23672__$1 = cljs.core.__destructure_map.call(null,map__23672);
var db = map__23672__$1;
var conn = cljs.core.get.call(null,map__23672__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__23672__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__23672__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23673 = p__23671;
var map__23673__$1 = cljs.core.__destructure_map.call(null,map__23673);
var _where_clause = map__23673__$1;
var p = cljs.core.get.call(null,map__23673__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__23673__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__23673__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23674 = (function (){var G__23677 = idx;
var G__23677__$1 = (((G__23677 instanceof cljs.core.Keyword))?G__23677.fqn:null);
switch (G__23677__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23677__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__23674,(0),null);
var lflake = cljs.core.nth.call(null,vec__23674,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23668_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__23668_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23669_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__23669_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2768__auto___23747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23716){
var state_val_23717 = (state_23716[(1)]);
if((state_val_23717 === (7))){
var inst_23712 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
var statearr_23718_23748 = state_23716__$1;
(statearr_23718_23748[(2)] = inst_23712);

(statearr_23718_23748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (1))){
var state_23716__$1 = state_23716;
var statearr_23719_23749 = state_23716__$1;
(statearr_23719_23749[(2)] = null);

(statearr_23719_23749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (4))){
var inst_23680 = (state_23716[(7)]);
var inst_23680__$1 = (state_23716[(2)]);
var inst_23681 = (inst_23680__$1 == null);
var state_23716__$1 = (function (){var statearr_23720 = state_23716;
(statearr_23720[(7)] = inst_23680__$1);

return statearr_23720;
})();
if(cljs.core.truth_(inst_23681)){
var statearr_23721_23750 = state_23716__$1;
(statearr_23721_23750[(1)] = (5));

} else {
var statearr_23722_23751 = state_23716__$1;
(statearr_23722_23751[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (15))){
var state_23716__$1 = state_23716;
var statearr_23723_23752 = state_23716__$1;
(statearr_23723_23752[(2)] = false);

(statearr_23723_23752[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (13))){
var inst_23692 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
if(cljs.core.truth_(inst_23692)){
var statearr_23724_23753 = state_23716__$1;
(statearr_23724_23753[(1)] = (14));

} else {
var statearr_23725_23754 = state_23716__$1;
(statearr_23725_23754[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (6))){
var inst_23680 = (state_23716[(7)]);
var inst_23685 = cljs.core.seq.call(null,inst_23680);
var inst_23686 = inst_23685;
var inst_23687 = (0);
var state_23716__$1 = (function (){var statearr_23726 = state_23716;
(statearr_23726[(8)] = inst_23687);

(statearr_23726[(9)] = inst_23686);

return statearr_23726;
})();
var statearr_23727_23755 = state_23716__$1;
(statearr_23727_23755[(2)] = null);

(statearr_23727_23755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (17))){
var state_23716__$1 = state_23716;
var statearr_23728_23756 = state_23716__$1;
(statearr_23728_23756[(2)] = null);

(statearr_23728_23756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (3))){
var inst_23714 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23716__$1,inst_23714);
} else {
if((state_val_23717 === (12))){
var inst_23702 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
var statearr_23729_23757 = state_23716__$1;
(statearr_23729_23757[(2)] = inst_23702);

(statearr_23729_23757[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (2))){
var state_23716__$1 = state_23716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23716__$1,(4),tree_chan);
} else {
if((state_val_23717 === (19))){
var inst_23710 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
var statearr_23730_23758 = state_23716__$1;
(statearr_23730_23758[(2)] = inst_23710);

(statearr_23730_23758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (11))){
var state_23716__$1 = state_23716;
var statearr_23731_23759 = state_23716__$1;
(statearr_23731_23759[(2)] = true);

(statearr_23731_23759[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (9))){
var inst_23704 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
if(cljs.core.truth_(inst_23704)){
var statearr_23732_23760 = state_23716__$1;
(statearr_23732_23760[(1)] = (17));

} else {
var statearr_23733_23761 = state_23716__$1;
(statearr_23733_23761[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (5))){
var inst_23683 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23716__$1 = state_23716;
var statearr_23734_23762 = state_23716__$1;
(statearr_23734_23762[(2)] = inst_23683);

(statearr_23734_23762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (14))){
var inst_23687 = (state_23716[(8)]);
var inst_23686 = (state_23716[(9)]);
var inst_23694 = cljs.core.next.call(null,inst_23686);
var inst_23695 = (inst_23687 + (1));
var inst_23686__$1 = inst_23694;
var inst_23687__$1 = inst_23695;
var state_23716__$1 = (function (){var statearr_23735 = state_23716;
(statearr_23735[(8)] = inst_23687__$1);

(statearr_23735[(9)] = inst_23686__$1);

return statearr_23735;
})();
var statearr_23736_23763 = state_23716__$1;
(statearr_23736_23763[(2)] = null);

(statearr_23736_23763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (16))){
var inst_23699 = (state_23716[(2)]);
var state_23716__$1 = state_23716;
var statearr_23737_23764 = state_23716__$1;
(statearr_23737_23764[(2)] = inst_23699);

(statearr_23737_23764[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (10))){
var inst_23686 = (state_23716[(9)]);
var inst_23690 = cljs.core.first.call(null,inst_23686);
var state_23716__$1 = state_23716;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23716__$1,(13),return_chan,inst_23690);
} else {
if((state_val_23717 === (18))){
var inst_23708 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23716__$1 = state_23716;
var statearr_23738_23765 = state_23716__$1;
(statearr_23738_23765[(2)] = inst_23708);

(statearr_23738_23765[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23717 === (8))){
var inst_23686 = (state_23716[(9)]);
var state_23716__$1 = state_23716;
if(cljs.core.truth_(inst_23686)){
var statearr_23739_23766 = state_23716__$1;
(statearr_23739_23766[(1)] = (10));

} else {
var statearr_23740_23767 = state_23716__$1;
(statearr_23740_23767[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23741 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23741[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__);

(statearr_23741[(1)] = (1));

return statearr_23741;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1 = (function (state_23716){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23742){var ex__2749__auto__ = e23742;
var statearr_23743_23768 = state_23716;
(statearr_23743_23768[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23716[(4)]))){
var statearr_23744_23769 = state_23716;
(statearr_23744_23769[(1)] = cljs.core.first.call(null,(state_23716[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23770 = state_23716;
state_23716 = G__23770;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = function(state_23716){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1.call(this,state_23716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23745 = f__2769__auto__.call(null);
(statearr_23745[(6)] = c__2768__auto___23747);

return statearr_23745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23771){
var map__23772 = p__23771;
var map__23772__$1 = cljs.core.__destructure_map.call(null,map__23772);
var _opts = map__23772__$1;
var db = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__23772__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23817){
var state_val_23818 = (state_23817[(1)]);
if((state_val_23818 === (7))){
var inst_23788 = (state_23817[(7)]);
var inst_23790 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_23788);
var state_23817__$1 = state_23817;
var statearr_23819_23855 = state_23817__$1;
(statearr_23819_23855[(2)] = inst_23790);

(statearr_23819_23855[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (1))){
var state_23817__$1 = state_23817;
var statearr_23820_23856 = state_23817__$1;
(statearr_23820_23856[(2)] = null);

(statearr_23820_23856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (4))){
var inst_23773 = (state_23817[(2)]);
var inst_23774 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23773);
var inst_23775 = cljs.core.async.close_BANG_.call(null,port);
var state_23817__$1 = (function (){var statearr_23821 = state_23817;
(statearr_23821[(8)] = inst_23775);

(statearr_23821[(9)] = inst_23774);

return statearr_23821;
})();
var statearr_23822_23857 = state_23817__$1;
(statearr_23822_23857[(2)] = null);

(statearr_23822_23857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (15))){
var inst_23805 = (state_23817[(10)]);
var inst_23805__$1 = (state_23817[(2)]);
var inst_23806 = cljs.core.seq.call(null,inst_23805__$1);
var state_23817__$1 = (function (){var statearr_23823 = state_23817;
(statearr_23823[(10)] = inst_23805__$1);

return statearr_23823;
})();
if(inst_23806){
var statearr_23824_23858 = state_23817__$1;
(statearr_23824_23858[(1)] = (17));

} else {
var statearr_23825_23859 = state_23817__$1;
(statearr_23825_23859[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (13))){
var inst_23798 = (state_23817[(11)]);
var state_23817__$1 = state_23817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23817__$1,(16),inst_23798);
} else {
if((state_val_23818 === (6))){
var inst_23787 = (state_23817[(2)]);
var inst_23788 = fluree.db.util.async.throw_err.call(null,inst_23787);
var state_23817__$1 = (function (){var statearr_23826 = state_23817;
(statearr_23826[(7)] = inst_23788);

return statearr_23826;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23827_23860 = state_23817__$1;
(statearr_23827_23860[(1)] = (7));

} else {
var statearr_23828_23861 = state_23817__$1;
(statearr_23828_23861[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (17))){
var inst_23805 = (state_23817[(10)]);
var inst_23808 = cljs.core.async.put_BANG_.call(null,port,inst_23805);
var state_23817__$1 = state_23817;
var statearr_23829_23862 = state_23817__$1;
(statearr_23829_23862[(2)] = inst_23808);

(statearr_23829_23862[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (3))){
var inst_23815 = (state_23817[(2)]);
var state_23817__$1 = state_23817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23817__$1,inst_23815);
} else {
if((state_val_23818 === (12))){
var inst_23798 = (state_23817[(2)]);
var state_23817__$1 = (function (){var statearr_23830 = state_23817;
(statearr_23830[(11)] = inst_23798);

return statearr_23830;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23831_23863 = state_23817__$1;
(statearr_23831_23863[(1)] = (13));

} else {
var statearr_23832_23864 = state_23817__$1;
(statearr_23832_23864[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (2))){
var _ = (function (){var statearr_23833 = state_23817;
(statearr_23833[(4)] = cljs.core.cons.call(null,(5),(state_23817[(4)])));

return statearr_23833;
})();
var inst_23782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23783 = [sid];
var inst_23784 = (new cljs.core.PersistentVector(null,1,(5),inst_23782,inst_23783,null));
var inst_23785 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23784);
var state_23817__$1 = state_23817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23817__$1,(6),inst_23785);
} else {
if((state_val_23818 === (19))){
var inst_23811 = (state_23817[(2)]);
var inst_23812 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23834 = state_23817;
(statearr_23834[(4)] = cljs.core.rest.call(null,(state_23817[(4)])));

return statearr_23834;
})();
var state_23817__$1 = (function (){var statearr_23835 = state_23817;
(statearr_23835[(12)] = inst_23811);

return statearr_23835;
})();
var statearr_23836_23865 = state_23817__$1;
(statearr_23836_23865[(2)] = inst_23812);

(statearr_23836_23865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (11))){
var inst_23793 = (state_23817[(13)]);
var state_23817__$1 = state_23817;
var statearr_23838_23866 = state_23817__$1;
(statearr_23838_23866[(2)] = inst_23793);

(statearr_23838_23866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (9))){
var inst_23793 = (state_23817[(2)]);
var state_23817__$1 = (function (){var statearr_23839 = state_23817;
(statearr_23839[(13)] = inst_23793);

return statearr_23839;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23840_23867 = state_23817__$1;
(statearr_23840_23867[(1)] = (10));

} else {
var statearr_23841_23868 = state_23817__$1;
(statearr_23841_23868[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (5))){
var _ = (function (){var statearr_23842 = state_23817;
(statearr_23842[(4)] = cljs.core.rest.call(null,(state_23817[(4)])));

return statearr_23842;
})();
var state_23817__$1 = state_23817;
var ex23837 = (state_23817__$1[(2)]);
var statearr_23843_23869 = state_23817__$1;
(statearr_23843_23869[(5)] = ex23837);


var statearr_23844_23870 = state_23817__$1;
(statearr_23844_23870[(1)] = (4));

(statearr_23844_23870[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (14))){
var inst_23798 = (state_23817[(11)]);
var state_23817__$1 = state_23817;
var statearr_23845_23871 = state_23817__$1;
(statearr_23845_23871[(2)] = inst_23798);

(statearr_23845_23871[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (16))){
var inst_23801 = (state_23817[(2)]);
var inst_23802 = fluree.db.util.async.throw_err.call(null,inst_23801);
var state_23817__$1 = state_23817;
var statearr_23846_23872 = state_23817__$1;
(statearr_23846_23872[(2)] = inst_23802);

(statearr_23846_23872[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (10))){
var inst_23793 = (state_23817[(13)]);
var inst_23795 = permissions.call(null,inst_23793);
var state_23817__$1 = state_23817;
var statearr_23847_23873 = state_23817__$1;
(statearr_23847_23873[(2)] = inst_23795);

(statearr_23847_23873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (18))){
var state_23817__$1 = state_23817;
var statearr_23848_23874 = state_23817__$1;
(statearr_23848_23874[(2)] = null);

(statearr_23848_23874[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23818 === (8))){
var inst_23788 = (state_23817[(7)]);
var state_23817__$1 = state_23817;
var statearr_23849_23875 = state_23817__$1;
(statearr_23849_23875[(2)] = inst_23788);

(statearr_23849_23875[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0 = (function (){
var statearr_23850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23850[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__);

(statearr_23850[(1)] = (1));

return statearr_23850;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1 = (function (state_23817){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23851){var ex__2749__auto__ = e23851;
var statearr_23852_23876 = state_23817;
(statearr_23852_23876[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23817[(4)]))){
var statearr_23853_23877 = state_23817;
(statearr_23853_23877[(1)] = cljs.core.first.call(null,(state_23817[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23878 = state_23817;
state_23817 = G__23878;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = function(state_23817){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1.call(this,state_23817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23854 = f__2769__auto__.call(null);
(statearr_23854[(6)] = c__2768__auto__);

return statearr_23854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__23879){
var map__23880 = p__23879;
var map__23880__$1 = cljs.core.__destructure_map.call(null,map__23880);
var f_where = map__23880__$1;
var o = cljs.core.get.call(null,map__23880__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2768__auto___23917 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23900){
var state_val_23901 = (state_23900[(1)]);
if((state_val_23901 === (7))){
var inst_23888 = (state_23900[(7)]);
var inst_23891 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23888);
var state_23900__$1 = state_23900;
var statearr_23902_23918 = state_23900__$1;
(statearr_23902_23918[(2)] = inst_23891);

(statearr_23902_23918[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (1))){
var inst_23881 = typeof _id_val === 'number';
var state_23900__$1 = state_23900;
if(cljs.core.truth_(inst_23881)){
var statearr_23903_23919 = state_23900__$1;
(statearr_23903_23919[(1)] = (2));

} else {
var statearr_23904_23920 = state_23900__$1;
(statearr_23904_23920[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (4))){
var inst_23897 = (state_23900[(2)]);
var inst_23898 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_23900__$1 = (function (){var statearr_23905 = state_23900;
(statearr_23905[(8)] = inst_23897);

return statearr_23905;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23900__$1,inst_23898);
} else {
if((state_val_23901 === (6))){
var inst_23888 = (state_23900[(7)]);
var inst_23888__$1 = (state_23900[(2)]);
var inst_23889 = fluree.db.util.core.exception_QMARK_.call(null,inst_23888__$1);
var state_23900__$1 = (function (){var statearr_23906 = state_23900;
(statearr_23906[(7)] = inst_23888__$1);

return statearr_23906;
})();
if(inst_23889){
var statearr_23907_23921 = state_23900__$1;
(statearr_23907_23921[(1)] = (7));

} else {
var statearr_23908_23922 = state_23900__$1;
(statearr_23908_23922[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (3))){
var inst_23886 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_23900__$1 = state_23900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23900__$1,(6),inst_23886);
} else {
if((state_val_23901 === (2))){
var state_23900__$1 = state_23900;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23900__$1,(5),return_ch,_id_val);
} else {
if((state_val_23901 === (9))){
var inst_23895 = (state_23900[(2)]);
var state_23900__$1 = state_23900;
var statearr_23909_23923 = state_23900__$1;
(statearr_23909_23923[(2)] = inst_23895);

(statearr_23909_23923[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (5))){
var inst_23884 = (state_23900[(2)]);
var state_23900__$1 = state_23900;
var statearr_23910_23924 = state_23900__$1;
(statearr_23910_23924[(2)] = inst_23884);

(statearr_23910_23924[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (8))){
var inst_23888 = (state_23900[(7)]);
var inst_23893 = cljs.core.async.put_BANG_.call(null,return_ch,inst_23888);
var state_23900__$1 = state_23900;
var statearr_23911_23925 = state_23900__$1;
(statearr_23911_23925[(2)] = inst_23893);

(statearr_23911_23925[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23912 = [null,null,null,null,null,null,null,null,null];
(statearr_23912[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__);

(statearr_23912[(1)] = (1));

return statearr_23912;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1 = (function (state_23900){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23913){var ex__2749__auto__ = e23913;
var statearr_23914_23926 = state_23900;
(statearr_23914_23926[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23900[(4)]))){
var statearr_23915_23927 = state_23900;
(statearr_23915_23927[(1)] = cljs.core.first.call(null,(state_23900[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23928 = state_23900;
state_23900 = G__23928;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = function(state_23900){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1.call(this,state_23900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23916 = f__2769__auto__.call(null);
(statearr_23916[(6)] = c__2768__auto___23917);

return statearr_23916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__23929){
var map__23930 = p__23929;
var map__23930__$1 = cljs.core.__destructure_map.call(null,map__23930);
var opts = map__23930__$1;
var db = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.call(null,map__23930__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23997){
var state_val_23998 = (state_23997[(1)]);
if((state_val_23998 === (7))){
var inst_23942 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,vars,f_where);
var state_23997__$1 = state_23997;
var statearr_23999_24036 = state_23997__$1;
(statearr_23999_24036[(2)] = inst_23942);

(statearr_23999_24036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (20))){
var inst_23986 = (state_23997[(2)]);
var state_23997__$1 = state_23997;
var statearr_24000_24037 = state_23997__$1;
(statearr_24000_24037[(2)] = inst_23986);

(statearr_24000_24037[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (1))){
var state_23997__$1 = state_23997;
var statearr_24001_24038 = state_23997__$1;
(statearr_24001_24038[(2)] = null);

(statearr_24001_24038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (4))){
var inst_23931 = (state_23997[(2)]);
var state_23997__$1 = state_23997;
var statearr_24002_24039 = state_23997__$1;
(statearr_24002_24039[(2)] = inst_23931);

(statearr_24002_24039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (15))){
var inst_23949 = (state_23997[(7)]);
var inst_23955 = (state_23997[(8)]);
var inst_23950 = (state_23997[(9)]);
var inst_23944 = (state_23997[(10)]);
var inst_23976 = cljs.core.async.close_BANG_.call(null,inst_23944);
var inst_23977 = cljs.core.async.close_BANG_.call(null,inst_23949);
var inst_23978 = cljs.core.async.close_BANG_.call(null,inst_23950);
var inst_23979 = finish_fn.call(null,inst_23955);
var state_23997__$1 = (function (){var statearr_24003 = state_23997;
(statearr_24003[(11)] = inst_23977);

(statearr_24003[(12)] = inst_23976);

(statearr_24003[(13)] = inst_23978);

return statearr_24003;
})();
var statearr_24004_24040 = state_23997__$1;
(statearr_24004_24040[(2)] = inst_23979);

(statearr_24004_24040[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (13))){
var inst_23965 = (state_23997[(14)]);
var inst_23974 = (inst_23965 == null);
var state_23997__$1 = state_23997;
if(cljs.core.truth_(inst_23974)){
var statearr_24005_24041 = state_23997__$1;
(statearr_24005_24041[(1)] = (15));

} else {
var statearr_24006_24042 = state_23997__$1;
(statearr_24006_24042[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (6))){
var inst_23940 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,vars,f_where);
var state_23997__$1 = state_23997;
var statearr_24007_24043 = state_23997__$1;
(statearr_24007_24043[(2)] = inst_23940);

(statearr_24007_24043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (17))){
var inst_23988 = (state_23997[(2)]);
var state_23997__$1 = state_23997;
var statearr_24008_24044 = state_23997__$1;
(statearr_24008_24044[(2)] = inst_23988);

(statearr_24008_24044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (3))){
var inst_23995 = (state_23997[(2)]);
var state_23997__$1 = state_23997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23997__$1,inst_23995);
} else {
if((state_val_23998 === (12))){
var inst_23949 = (state_23997[(7)]);
var inst_23965 = (state_23997[(14)]);
var inst_23950 = (state_23997[(9)]);
var inst_23944 = (state_23997[(10)]);
var inst_23969 = cljs.core.async.close_BANG_.call(null,inst_23944);
var inst_23970 = cljs.core.async.close_BANG_.call(null,inst_23949);
var inst_23971 = cljs.core.async.close_BANG_.call(null,inst_23950);
var inst_23972 = (function(){throw inst_23965})();
var state_23997__$1 = (function (){var statearr_24009 = state_23997;
(statearr_24009[(15)] = inst_23970);

(statearr_24009[(16)] = inst_23969);

(statearr_24009[(17)] = inst_23971);

return statearr_24009;
})();
var statearr_24010_24045 = state_23997__$1;
(statearr_24010_24045[(2)] = inst_23972);

(statearr_24010_24045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (2))){
var _ = (function (){var statearr_24011 = state_23997;
(statearr_24011[(4)] = cljs.core.cons.call(null,(5),(state_23997[(4)])));

return statearr_24011;
})();
var inst_23937 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_23938 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23937);
var state_23997__$1 = state_23997;
if(inst_23938){
var statearr_24012_24046 = state_23997__$1;
(statearr_24012_24046[(1)] = (6));

} else {
var statearr_24013_24047 = state_23997__$1;
(statearr_24013_24047[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (19))){
var state_23997__$1 = state_23997;
var statearr_24014_24048 = state_23997__$1;
(statearr_24014_24048[(2)] = null);

(statearr_24014_24048[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (11))){
var inst_23964 = (state_23997[(2)]);
var inst_23965 = cljs.core.nth.call(null,inst_23964,(0),null);
var inst_23966 = cljs.core.nth.call(null,inst_23964,(1),null);
var inst_23967 = cljs.core._EQ_.call(null,inst_23966,error_ch);
var state_23997__$1 = (function (){var statearr_24016 = state_23997;
(statearr_24016[(14)] = inst_23965);

return statearr_24016;
})();
if(inst_23967){
var statearr_24017_24049 = state_23997__$1;
(statearr_24017_24049[(1)] = (12));

} else {
var statearr_24018_24050 = state_23997__$1;
(statearr_24018_24050[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (9))){
var inst_23950 = (state_23997[(9)]);
var inst_23960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23961 = [error_ch,inst_23950];
var inst_23962 = (new cljs.core.PersistentVector(null,2,(5),inst_23960,inst_23961,null));
var state_23997__$1 = state_23997;
return cljs.core.async.ioc_alts_BANG_.call(null,state_23997__$1,(11),inst_23962);
} else {
if((state_val_23998 === (5))){
var _ = (function (){var statearr_24019 = state_23997;
(statearr_24019[(4)] = cljs.core.rest.call(null,(state_23997[(4)])));

return statearr_24019;
})();
var state_23997__$1 = state_23997;
var ex24015 = (state_23997__$1[(2)]);
var statearr_24020_24051 = state_23997__$1;
(statearr_24020_24051[(5)] = ex24015);


if((ex24015 instanceof Error)){
var statearr_24021_24052 = state_23997__$1;
(statearr_24021_24052[(1)] = (4));

(statearr_24021_24052[(5)] = null);

} else {
throw ex24015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (14))){
var inst_23990 = (state_23997[(2)]);
var state_23997__$1 = state_23997;
var statearr_24022_24053 = state_23997__$1;
(statearr_24022_24053[(2)] = inst_23990);

(statearr_24022_24053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (16))){
var state_23997__$1 = state_23997;
var statearr_24023_24054 = state_23997__$1;
(statearr_24023_24054[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (10))){
var inst_23992 = (state_23997[(2)]);
var _ = (function (){var statearr_24025 = state_23997;
(statearr_24025[(4)] = cljs.core.rest.call(null,(state_23997[(4)])));

return statearr_24025;
})();
var state_23997__$1 = state_23997;
var statearr_24026_24055 = state_23997__$1;
(statearr_24026_24055[(2)] = inst_23992);

(statearr_24026_24055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (18))){
var inst_23965 = (state_23997[(14)]);
var inst_23955 = (state_23997[(8)]);
var inst_23982 = cljs.core.conj.call(null,inst_23955,inst_23965);
var inst_23955__$1 = inst_23982;
var state_23997__$1 = (function (){var statearr_24027 = state_23997;
(statearr_24027[(8)] = inst_23955__$1);

return statearr_24027;
})();
var statearr_24028_24056 = state_23997__$1;
(statearr_24028_24056[(2)] = null);

(statearr_24028_24056[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23998 === (8))){
var inst_23949 = (state_23997[(7)]);
var inst_23950 = (state_23997[(9)]);
var inst_23944 = (state_23997[(10)]);
var inst_23944__$1 = (state_23997[(2)]);
var inst_23945 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,opts);
var inst_23946 = cljs.core.drop.call(null,offset);
var inst_23947 = cljs.core.take.call(null,limit);
var inst_23948 = cljs.core.comp.call(null,inst_23946,inst_23947);
var inst_23949__$1 = cljs.core.async.chan.call(null,(32),inst_23948);
var inst_23950__$1 = cljs.core.async.chan.call(null);
var inst_23951 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23949__$1,inst_23945,inst_23944__$1);
var inst_23952 = fluree.db.query.subject_crawl.common.result_af.call(null,opts);
var inst_23953 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23950__$1,inst_23952,inst_23949__$1);
var inst_23954 = cljs.core.PersistentVector.EMPTY;
var inst_23955 = inst_23954;
var state_23997__$1 = (function (){var statearr_24029 = state_23997;
(statearr_24029[(7)] = inst_23949__$1);

(statearr_24029[(18)] = inst_23953);

(statearr_24029[(8)] = inst_23955);

(statearr_24029[(9)] = inst_23950__$1);

(statearr_24029[(19)] = inst_23951);

(statearr_24029[(10)] = inst_23944__$1);

return statearr_24029;
})();
var statearr_24030_24057 = state_23997__$1;
(statearr_24030_24057[(2)] = null);

(statearr_24030_24057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0 = (function (){
var statearr_24031 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24031[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__);

(statearr_24031[(1)] = (1));

return statearr_24031;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1 = (function (state_23997){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24032){var ex__2749__auto__ = e24032;
var statearr_24033_24058 = state_23997;
(statearr_24033_24058[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23997[(4)]))){
var statearr_24034_24059 = state_23997;
(statearr_24034_24059[(1)] = cljs.core.first.call(null,(state_23997[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24060 = state_23997;
state_23997 = G__24060;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = function(state_23997){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1.call(this,state_23997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24035 = f__2769__auto__.call(null);
(statearr_24035[(6)] = c__2768__auto__);

return statearr_24035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
