// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23482){
var map__23483 = p__23482;
var map__23483__$1 = cljs.core.__destructure_map.call(null,map__23483);
var start_test = cljs.core.get.call(null,map__23483__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__23483__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__23483__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__23483__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__23483__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__23484 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__23484,xf);
} else {
return G__23484;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23485){
var map__23486 = p__23485;
var map__23486__$1 = cljs.core.__destructure_map.call(null,map__23486);
var _opts = map__23486__$1;
var db = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23517){
var state_val_23518 = (state_23517[(1)]);
if((state_val_23518 === (7))){
var state_23517__$1 = state_23517;
var statearr_23519_23545 = state_23517__$1;
(statearr_23519_23545[(2)] = null);

(statearr_23519_23545[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (1))){
var state_23517__$1 = state_23517;
var statearr_23520_23546 = state_23517__$1;
(statearr_23520_23546[(2)] = null);

(statearr_23520_23546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (4))){
var inst_23487 = (state_23517[(2)]);
var inst_23488 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23487);
var inst_23489 = cljs.core.async.close_BANG_.call(null,port);
var state_23517__$1 = (function (){var statearr_23521 = state_23517;
(statearr_23521[(7)] = inst_23489);

(statearr_23521[(8)] = inst_23488);

return statearr_23521;
})();
var statearr_23522_23547 = state_23517__$1;
(statearr_23522_23547[(2)] = null);

(statearr_23522_23547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (6))){
var inst_23499 = (state_23517[(9)]);
var inst_23498 = (state_23517[(2)]);
var inst_23499__$1 = fluree.db.util.async.throw_err.call(null,inst_23498);
var inst_23500 = (inst_23499__$1 == null);
var state_23517__$1 = (function (){var statearr_23523 = state_23517;
(statearr_23523[(9)] = inst_23499__$1);

return statearr_23523;
})();
if(cljs.core.truth_(inst_23500)){
var statearr_23524_23548 = state_23517__$1;
(statearr_23524_23548[(1)] = (7));

} else {
var statearr_23525_23549 = state_23517__$1;
(statearr_23525_23549[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (3))){
var inst_23515 = (state_23517[(2)]);
var state_23517__$1 = state_23517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23517__$1,inst_23515);
} else {
if((state_val_23518 === (12))){
var inst_23511 = (state_23517[(2)]);
var inst_23512 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23526 = state_23517;
(statearr_23526[(4)] = cljs.core.rest.call(null,(state_23517[(4)])));

return statearr_23526;
})();
var state_23517__$1 = (function (){var statearr_23527 = state_23517;
(statearr_23527[(10)] = inst_23511);

return statearr_23527;
})();
var statearr_23528_23550 = state_23517__$1;
(statearr_23528_23550[(2)] = inst_23512);

(statearr_23528_23550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (2))){
var _ = (function (){var statearr_23529 = state_23517;
(statearr_23529[(4)] = cljs.core.cons.call(null,(5),(state_23517[(4)])));

return statearr_23529;
})();
var inst_23496 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23517__$1 = state_23517;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23517__$1,(6),inst_23496);
} else {
if((state_val_23518 === (11))){
var inst_23505 = (state_23517[(11)]);
var inst_23509 = cljs.core.async.put_BANG_.call(null,port,inst_23505);
var state_23517__$1 = state_23517;
var statearr_23531_23551 = state_23517__$1;
(statearr_23531_23551[(2)] = inst_23509);

(statearr_23531_23551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (9))){
var inst_23505 = (state_23517[(11)]);
var inst_23505__$1 = (state_23517[(2)]);
var inst_23506 = (inst_23505__$1 == null);
var state_23517__$1 = (function (){var statearr_23532 = state_23517;
(statearr_23532[(11)] = inst_23505__$1);

return statearr_23532;
})();
if(cljs.core.truth_(inst_23506)){
var statearr_23533_23552 = state_23517__$1;
(statearr_23533_23552[(1)] = (10));

} else {
var statearr_23534_23553 = state_23517__$1;
(statearr_23534_23553[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (5))){
var _ = (function (){var statearr_23535 = state_23517;
(statearr_23535[(4)] = cljs.core.rest.call(null,(state_23517[(4)])));

return statearr_23535;
})();
var state_23517__$1 = state_23517;
var ex23530 = (state_23517__$1[(2)]);
var statearr_23536_23554 = state_23517__$1;
(statearr_23536_23554[(5)] = ex23530);


var statearr_23537_23555 = state_23517__$1;
(statearr_23537_23555[(1)] = (4));

(statearr_23537_23555[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (10))){
var state_23517__$1 = state_23517;
var statearr_23538_23556 = state_23517__$1;
(statearr_23538_23556[(2)] = null);

(statearr_23538_23556[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23518 === (8))){
var inst_23499 = (state_23517[(9)]);
var inst_23503 = cljs.core.not_empty.call(null,inst_23499);
var state_23517__$1 = state_23517;
var statearr_23539_23557 = state_23517__$1;
(statearr_23539_23557[(2)] = inst_23503);

(statearr_23539_23557[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0 = (function (){
var statearr_23540 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23540[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__);

(statearr_23540[(1)] = (1));

return statearr_23540;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1 = (function (state_23517){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23541){var ex__2749__auto__ = e23541;
var statearr_23542_23558 = state_23517;
(statearr_23542_23558[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23517[(4)]))){
var statearr_23543_23559 = state_23517;
(statearr_23543_23559[(1)] = cljs.core.first.call(null,(state_23517[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23560 = state_23517;
state_23517 = G__23560;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = function(state_23517){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1.call(this,state_23517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23544 = f__2769__auto__.call(null);
(statearr_23544[(6)] = c__2768__auto__);

return statearr_23544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23561){
var map__23562 = p__23561;
var map__23562__$1 = cljs.core.__destructure_map.call(null,map__23562);
var db = map__23562__$1;
var permissions = cljs.core.get.call(null,map__23562__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23593){
var state_val_23594 = (state_23593[(1)]);
if((state_val_23594 === (7))){
var inst_23569 = (state_23593[(7)]);
var inst_23579 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_23569);
var state_23593__$1 = state_23593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23593__$1,(10),inst_23579);
} else {
if((state_val_23594 === (1))){
var state_23593__$1 = state_23593;
var statearr_23595_23618 = state_23593__$1;
(statearr_23595_23618[(2)] = null);

(statearr_23595_23618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (4))){
var inst_23563 = (state_23593[(2)]);
var state_23593__$1 = state_23593;
var statearr_23596_23619 = state_23593__$1;
(statearr_23596_23619[(2)] = inst_23563);

(statearr_23596_23619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (13))){
var inst_23586 = (state_23593[(2)]);
var state_23593__$1 = state_23593;
var statearr_23597_23620 = state_23593__$1;
(statearr_23597_23620[(2)] = inst_23586);

(statearr_23597_23620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (6))){
var inst_23574 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_23593__$1 = state_23593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23593__$1,(9),inst_23574);
} else {
if((state_val_23594 === (3))){
var inst_23591 = (state_23593[(2)]);
var state_23593__$1 = state_23593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23593__$1,inst_23591);
} else {
if((state_val_23594 === (12))){
var state_23593__$1 = state_23593;
var statearr_23598_23621 = state_23593__$1;
(statearr_23598_23621[(2)] = null);

(statearr_23598_23621[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (2))){
var inst_23569 = (state_23593[(7)]);
var _ = (function (){var statearr_23599 = state_23593;
(statearr_23599[(4)] = cljs.core.cons.call(null,(5),(state_23593[(4)])));

return statearr_23599;
})();
var inst_23569__$1 = cljs.core.first.call(null,flakes);
var inst_23570 = fluree.db.flake.s.call(null,inst_23569__$1);
var inst_23571 = fluree.db.flake.sid__GT_cid.call(null,inst_23570);
var inst_23572 = filter_predicates_QMARK_.call(null,inst_23571);
var state_23593__$1 = (function (){var statearr_23600 = state_23593;
(statearr_23600[(7)] = inst_23569__$1);

return statearr_23600;
})();
if(cljs.core.truth_(inst_23572)){
var statearr_23601_23622 = state_23593__$1;
(statearr_23601_23622[(1)] = (6));

} else {
var statearr_23602_23623 = state_23593__$1;
(statearr_23602_23623[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (11))){
var state_23593__$1 = state_23593;
var statearr_23604_23624 = state_23593__$1;
(statearr_23604_23624[(2)] = flakes);

(statearr_23604_23624[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (9))){
var inst_23576 = (state_23593[(2)]);
var inst_23577 = fluree.db.util.async.throw_err.call(null,inst_23576);
var state_23593__$1 = state_23593;
var statearr_23605_23625 = state_23593__$1;
(statearr_23605_23625[(2)] = inst_23577);

(statearr_23605_23625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (5))){
var _ = (function (){var statearr_23606 = state_23593;
(statearr_23606[(4)] = cljs.core.rest.call(null,(state_23593[(4)])));

return statearr_23606;
})();
var state_23593__$1 = state_23593;
var ex23603 = (state_23593__$1[(2)]);
var statearr_23607_23626 = state_23593__$1;
(statearr_23607_23626[(5)] = ex23603);


if((ex23603 instanceof Error)){
var statearr_23608_23627 = state_23593__$1;
(statearr_23608_23627[(1)] = (4));

(statearr_23608_23627[(5)] = null);

} else {
throw ex23603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (10))){
var inst_23581 = (state_23593[(2)]);
var inst_23582 = fluree.db.util.async.throw_err.call(null,inst_23581);
var state_23593__$1 = state_23593;
if(cljs.core.truth_(inst_23582)){
var statearr_23609_23628 = state_23593__$1;
(statearr_23609_23628[(1)] = (11));

} else {
var statearr_23610_23629 = state_23593__$1;
(statearr_23610_23629[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23594 === (8))){
var inst_23588 = (state_23593[(2)]);
var _ = (function (){var statearr_23611 = state_23593;
(statearr_23611[(4)] = cljs.core.rest.call(null,(state_23593[(4)])));

return statearr_23611;
})();
var state_23593__$1 = state_23593;
var statearr_23612_23630 = state_23593__$1;
(statearr_23612_23630[(2)] = inst_23588);

(statearr_23612_23630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_23613 = [null,null,null,null,null,null,null,null];
(statearr_23613[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__);

(statearr_23613[(1)] = (1));

return statearr_23613;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1 = (function (state_23593){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23614){var ex__2749__auto__ = e23614;
var statearr_23615_23631 = state_23593;
(statearr_23615_23631[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23593[(4)]))){
var statearr_23616_23632 = state_23593;
(statearr_23616_23632[(1)] = cljs.core.first.call(null,(state_23593[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23633 = state_23593;
state_23593 = G__23633;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = function(state_23593){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1.call(this,state_23593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23617 = f__2769__auto__.call(null);
(statearr_23617[(6)] = c__2768__auto__);

return statearr_23617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__23634_SHARP_){
return filter_fn.call(null,p1__23634_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23638 = filter_fns;
var vec__23639 = G__23638;
var seq__23640 = cljs.core.seq.call(null,vec__23639);
var first__23641 = cljs.core.first.call(null,seq__23640);
var seq__23640__$1 = cljs.core.next.call(null,seq__23640);
var filter_fn = first__23641;
var r_fns = seq__23640__$1;
var G__23638__$1 = G__23638;
while(true){
var vec__23642 = G__23638__$1;
var seq__23643 = cljs.core.seq.call(null,vec__23642);
var first__23644 = cljs.core.first.call(null,seq__23643);
var seq__23643__$1 = cljs.core.next.call(null,seq__23643);
var filter_fn__$1 = first__23644;
var r_fns__$1 = seq__23643__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__23645 = r_fns__$1;
G__23638__$1 = G__23645;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23649 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__23650 = G__23649;
var seq__23651 = cljs.core.seq.call(null,vec__23650);
var first__23652 = cljs.core.first.call(null,seq__23651);
var seq__23651__$1 = cljs.core.next.call(null,seq__23651);
var p_flakes = first__23652;
var r = seq__23651__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23649__$1 = G__23649;
var required_p__$1 = required_p;
while(true){
var vec__23656 = G__23649__$1;
var seq__23657 = cljs.core.seq.call(null,vec__23656);
var first__23658 = cljs.core.first.call(null,seq__23657);
var seq__23657__$1 = cljs.core.next.call(null,seq__23657);
var p_flakes__$1 = first__23658;
var r__$1 = seq__23657__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__23659 = r__$1;
var G__23660 = cljs.core.disj.call(null,required_p__$2,p);
G__23649__$1 = G__23659;
required_p__$1 = G__23660;
continue;
} else {
return null;
}
} else {
var G__23661 = r__$1;
var G__23662 = cljs.core.disj.call(null,required_p__$2,p);
G__23649__$1 = G__23661;
required_p__$1 = G__23662;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23663){
var map__23664 = p__23663;
var map__23664__$1 = cljs.core.__destructure_map.call(null,map__23664);
var type = cljs.core.get.call(null,map__23664__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__23664__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__23664__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__23665 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
var G__23665__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order))?cljs.core.reverse.call(null,G__23665):G__23665);
return cljs.core.vec.call(null,G__23665__$1);

}
});
