// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16004){
var state_val_16005 = (state_16004[(1)]);
if((state_val_16005 === (1))){
var state_16004__$1 = state_16004;
var statearr_16006_16020 = state_16004__$1;
(statearr_16006_16020[(2)] = null);

(statearr_16006_16020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16005 === (2))){
var _ = (function (){var statearr_16007 = state_16004;
(statearr_16007[(4)] = cljs.core.cons.call(null,(5),(state_16004[(4)])));

return statearr_16007;
})();
var inst_15995 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_16004__$1 = state_16004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16004__$1,(6),inst_15995);
} else {
if((state_val_16005 === (3))){
var inst_16002 = (state_16004[(2)]);
var state_16004__$1 = state_16004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16004__$1,inst_16002);
} else {
if((state_val_16005 === (4))){
var inst_15989 = (state_16004[(2)]);
var state_16004__$1 = state_16004;
var statearr_16009_16021 = state_16004__$1;
(statearr_16009_16021[(2)] = inst_15989);

(statearr_16009_16021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16005 === (5))){
var _ = (function (){var statearr_16010 = state_16004;
(statearr_16010[(4)] = cljs.core.rest.call(null,(state_16004[(4)])));

return statearr_16010;
})();
var state_16004__$1 = state_16004;
var ex16008 = (state_16004__$1[(2)]);
var statearr_16011_16022 = state_16004__$1;
(statearr_16011_16022[(5)] = ex16008);


if((ex16008 instanceof Error)){
var statearr_16012_16023 = state_16004__$1;
(statearr_16012_16023[(1)] = (4));

(statearr_16012_16023[(5)] = null);

} else {
throw ex16008;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16005 === (6))){
var inst_15997 = (state_16004[(2)]);
var inst_15998 = fluree.db.util.async.throw_err.call(null,inst_15997);
var inst_15999 = cljs.core.keyword.call(null,inst_15998);
var _ = (function (){var statearr_16013 = state_16004;
(statearr_16013[(4)] = cljs.core.rest.call(null,(state_16004[(4)])));

return statearr_16013;
})();
var state_16004__$1 = state_16004;
var statearr_16014_16024 = state_16004__$1;
(statearr_16014_16024[(2)] = inst_15999);

(statearr_16014_16024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0 = (function (){
var statearr_16015 = [null,null,null,null,null,null,null];
(statearr_16015[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__);

(statearr_16015[(1)] = (1));

return statearr_16015;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1 = (function (state_16004){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16016){var ex__2749__auto__ = e16016;
var statearr_16017_16025 = state_16004;
(statearr_16017_16025[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16004[(4)]))){
var statearr_16018_16026 = state_16004;
(statearr_16018_16026[(1)] = cljs.core.first.call(null,(state_16004[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16027 = state_16004;
state_16004 = G__16027;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = function(state_16004){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1.call(this,state_16004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16019 = f__2769__auto__.call(null);
(statearr_16019[(6)] = c__2768__auto__);

return statearr_16019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16059){
var state_val_16060 = (state_16059[(1)]);
if((state_val_16060 === (7))){
var inst_16043 = (state_16059[(7)]);
var inst_16045 = cljs.core.empty_QMARK_.call(null,inst_16043);
var inst_16046 = (!(inst_16045));
var state_16059__$1 = state_16059;
var statearr_16061_16085 = state_16059__$1;
(statearr_16061_16085[(2)] = inst_16046);

(statearr_16061_16085[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (1))){
var state_16059__$1 = state_16059;
var statearr_16062_16086 = state_16059__$1;
(statearr_16062_16086[(2)] = null);

(statearr_16062_16086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (4))){
var inst_16029 = (state_16059[(2)]);
var state_16059__$1 = state_16059;
var statearr_16063_16087 = state_16059__$1;
(statearr_16063_16087[(2)] = inst_16029);

(statearr_16063_16087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (6))){
var inst_16043 = (state_16059[(7)]);
var inst_16035 = (state_16059[(8)]);
var inst_16041 = (state_16059[(2)]);
var inst_16042 = fluree.db.util.async.throw_err.call(null,inst_16041);
var inst_16043__$1 = cljs.core.map.call(null,inst_16035,inst_16042);
var state_16059__$1 = (function (){var statearr_16064 = state_16059;
(statearr_16064[(7)] = inst_16043__$1);

return statearr_16064;
})();
if(cljs.core.truth_(inst_16043__$1)){
var statearr_16065_16088 = state_16059__$1;
(statearr_16065_16088[(1)] = (7));

} else {
var statearr_16066_16089 = state_16059__$1;
(statearr_16066_16089[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (3))){
var inst_16057 = (state_16059[(2)]);
var state_16059__$1 = state_16059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16059__$1,inst_16057);
} else {
if((state_val_16060 === (12))){
var inst_16054 = (state_16059[(2)]);
var _ = (function (){var statearr_16067 = state_16059;
(statearr_16067[(4)] = cljs.core.rest.call(null,(state_16059[(4)])));

return statearr_16067;
})();
var state_16059__$1 = state_16059;
var statearr_16068_16090 = state_16059__$1;
(statearr_16068_16090[(2)] = inst_16054);

(statearr_16068_16090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (2))){
var _ = (function (){var statearr_16069 = state_16059;
(statearr_16069[(4)] = cljs.core.cons.call(null,(5),(state_16059[(4)])));

return statearr_16069;
})();
var inst_16035 = (function (){return (function (p1__16028_SHARP_){
return fluree.db.flake.o.call(null,p1__16028_SHARP_);
});
})();
var inst_16036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16037 = [pred_id];
var inst_16038 = (new cljs.core.PersistentVector(null,1,(5),inst_16036,inst_16037,null));
var inst_16039 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16038);
var state_16059__$1 = (function (){var statearr_16070 = state_16059;
(statearr_16070[(8)] = inst_16035);

return statearr_16070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16059__$1,(6),inst_16039);
} else {
if((state_val_16060 === (11))){
var state_16059__$1 = state_16059;
var statearr_16072_16091 = state_16059__$1;
(statearr_16072_16091[(2)] = true);

(statearr_16072_16091[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (9))){
var inst_16049 = (state_16059[(2)]);
var state_16059__$1 = state_16059;
if(cljs.core.truth_(inst_16049)){
var statearr_16073_16092 = state_16059__$1;
(statearr_16073_16092[(1)] = (10));

} else {
var statearr_16074_16093 = state_16059__$1;
(statearr_16074_16093[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (5))){
var _ = (function (){var statearr_16075 = state_16059;
(statearr_16075[(4)] = cljs.core.rest.call(null,(state_16059[(4)])));

return statearr_16075;
})();
var state_16059__$1 = state_16059;
var ex16071 = (state_16059__$1[(2)]);
var statearr_16076_16094 = state_16059__$1;
(statearr_16076_16094[(5)] = ex16071);


if((ex16071 instanceof Error)){
var statearr_16077_16095 = state_16059__$1;
(statearr_16077_16095[(1)] = (4));

(statearr_16077_16095[(5)] = null);

} else {
throw ex16071;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (10))){
var inst_16043 = (state_16059[(7)]);
var inst_16051 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_16043);
var state_16059__$1 = state_16059;
var statearr_16078_16096 = state_16059__$1;
(statearr_16078_16096[(2)] = inst_16051);

(statearr_16078_16096[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16060 === (8))){
var inst_16043 = (state_16059[(7)]);
var state_16059__$1 = state_16059;
var statearr_16079_16097 = state_16059__$1;
(statearr_16079_16097[(2)] = inst_16043);

(statearr_16079_16097[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_16080 = [null,null,null,null,null,null,null,null,null];
(statearr_16080[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__);

(statearr_16080[(1)] = (1));

return statearr_16080;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1 = (function (state_16059){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16081){var ex__2749__auto__ = e16081;
var statearr_16082_16098 = state_16059;
(statearr_16082_16098[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16059[(4)]))){
var statearr_16083_16099 = state_16059;
(statearr_16083_16099[(1)] = cljs.core.first.call(null,(state_16059[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16100 = state_16059;
state_16059 = G__16100;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = function(state_16059){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1.call(this,state_16059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16084 = f__2769__auto__.call(null);
(statearr_16084[(6)] = c__2768__auto__);

return statearr_16084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16181){
var state_val_16182 = (state_16181[(1)]);
if((state_val_16182 === (7))){
var state_16181__$1 = state_16181;
var statearr_16183_16220 = state_16181__$1;
(statearr_16183_16220[(2)] = flakes);

(statearr_16183_16220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (20))){
var inst_16138 = (state_16181[(7)]);
var inst_16171 = (state_16181[(2)]);
var inst_16130 = inst_16138;
var inst_16131 = inst_16171;
var state_16181__$1 = (function (){var statearr_16184 = state_16181;
(statearr_16184[(8)] = inst_16131);

(statearr_16184[(9)] = inst_16130);

return statearr_16184;
})();
var statearr_16185_16221 = state_16181__$1;
(statearr_16185_16221[(2)] = null);

(statearr_16185_16221[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (1))){
var state_16181__$1 = state_16181;
var statearr_16186_16222 = state_16181__$1;
(statearr_16186_16222[(2)] = null);

(statearr_16186_16222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (4))){
var inst_16103 = (state_16181[(2)]);
var state_16181__$1 = state_16181;
var statearr_16187_16223 = state_16181__$1;
(statearr_16187_16223[(2)] = inst_16103);

(statearr_16187_16223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (15))){
var inst_16137 = (state_16181[(10)]);
var inst_16155 = fluree.db.flake.o.call(null,inst_16137);
var state_16181__$1 = state_16181;
var statearr_16188_16224 = state_16181__$1;
(statearr_16188_16224[(2)] = inst_16155);

(statearr_16188_16224[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (13))){
var inst_16174 = (state_16181[(2)]);
var state_16181__$1 = state_16181;
var statearr_16189_16225 = state_16181__$1;
(statearr_16189_16225[(2)] = inst_16174);

(statearr_16189_16225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (6))){
var inst_16110 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16181__$1 = state_16181;
var statearr_16190_16226 = state_16181__$1;
(statearr_16190_16226[(2)] = inst_16110);

(statearr_16190_16226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (17))){
var inst_16152 = (state_16181[(2)]);
var inst_16153 = fluree.db.util.async.throw_err.call(null,inst_16152);
var state_16181__$1 = state_16181;
var statearr_16191_16227 = state_16181__$1;
(statearr_16191_16227[(2)] = inst_16153);

(statearr_16191_16227[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (3))){
var inst_16179 = (state_16181[(2)]);
var state_16181__$1 = state_16181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16181__$1,inst_16179);
} else {
if((state_val_16182 === (12))){
var inst_16137 = (state_16181[(10)]);
var inst_16144 = (state_16181[(11)]);
var inst_16142 = fluree.db.flake.p.call(null,inst_16137);
var inst_16143 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16142);
var inst_16144__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_16143);
var inst_16145 = fluree.db.flake.op.call(null,inst_16137);
var inst_16146 = inst_16145 === false;
var inst_16147 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_16144__$1);
var state_16181__$1 = (function (){var statearr_16192 = state_16181;
(statearr_16192[(12)] = inst_16146);

(statearr_16192[(11)] = inst_16144__$1);

return statearr_16192;
})();
if(inst_16147){
var statearr_16193_16228 = state_16181__$1;
(statearr_16193_16228[(1)] = (14));

} else {
var statearr_16194_16229 = state_16181__$1;
(statearr_16194_16229[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (2))){
var _ = (function (){var statearr_16195 = state_16181;
(statearr_16195[(4)] = cljs.core.cons.call(null,(5),(state_16181[(4)])));

return statearr_16195;
})();
var state_16181__$1 = state_16181;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16196_16230 = state_16181__$1;
(statearr_16196_16230[(1)] = (6));

} else {
var statearr_16197_16231 = state_16181__$1;
(statearr_16197_16231[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (19))){
var inst_16131 = (state_16181[(8)]);
var inst_16157 = (state_16181[(13)]);
var inst_16137 = (state_16181[(10)]);
var inst_16144 = (state_16181[(11)]);
var inst_16165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16166 = fluree.db.flake.s.call(null,inst_16137);
var inst_16167 = [inst_16166,inst_16144,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16168 = (new cljs.core.PersistentVector(null,3,(5),inst_16165,inst_16167,null));
var inst_16169 = cljs.core.assoc_in.call(null,inst_16131,inst_16168,inst_16157);
var state_16181__$1 = state_16181;
var statearr_16198_16232 = state_16181__$1;
(statearr_16198_16232[(2)] = inst_16169);

(statearr_16198_16232[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (11))){
var inst_16131 = (state_16181[(8)]);
var state_16181__$1 = state_16181;
var statearr_16200_16233 = state_16181__$1;
(statearr_16200_16233[(2)] = inst_16131);

(statearr_16200_16233[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (9))){
var inst_16137 = (state_16181[(10)]);
var inst_16130 = (state_16181[(9)]);
var inst_16136 = cljs.core.seq.call(null,inst_16130);
var inst_16137__$1 = cljs.core.first.call(null,inst_16136);
var inst_16138 = cljs.core.next.call(null,inst_16136);
var inst_16139 = cljs.core.not.call(null,inst_16137__$1);
var state_16181__$1 = (function (){var statearr_16201 = state_16181;
(statearr_16201[(7)] = inst_16138);

(statearr_16201[(10)] = inst_16137__$1);

return statearr_16201;
})();
if(inst_16139){
var statearr_16202_16234 = state_16181__$1;
(statearr_16202_16234[(1)] = (11));

} else {
var statearr_16203_16235 = state_16181__$1;
(statearr_16203_16235[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (5))){
var _ = (function (){var statearr_16204 = state_16181;
(statearr_16204[(4)] = cljs.core.rest.call(null,(state_16181[(4)])));

return statearr_16204;
})();
var state_16181__$1 = state_16181;
var ex16199 = (state_16181__$1[(2)]);
var statearr_16205_16236 = state_16181__$1;
(statearr_16205_16236[(5)] = ex16199);


if((ex16199 instanceof Error)){
var statearr_16206_16237 = state_16181__$1;
(statearr_16206_16237[(1)] = (4));

(statearr_16206_16237[(5)] = null);

} else {
throw ex16199;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (14))){
var inst_16137 = (state_16181[(10)]);
var inst_16149 = fluree.db.flake.o.call(null,inst_16137);
var inst_16150 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_16149,db);
var state_16181__$1 = state_16181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16181__$1,(17),inst_16150);
} else {
if((state_val_16182 === (16))){
var inst_16146 = (state_16181[(12)]);
var inst_16157 = (state_16181[(2)]);
var state_16181__$1 = (function (){var statearr_16207 = state_16181;
(statearr_16207[(13)] = inst_16157);

return statearr_16207;
})();
if(cljs.core.truth_(inst_16146)){
var statearr_16208_16238 = state_16181__$1;
(statearr_16208_16238[(1)] = (18));

} else {
var statearr_16209_16239 = state_16181__$1;
(statearr_16209_16239[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (10))){
var inst_16176 = (state_16181[(2)]);
var _ = (function (){var statearr_16210 = state_16181;
(statearr_16210[(4)] = cljs.core.rest.call(null,(state_16181[(4)])));

return statearr_16210;
})();
var state_16181__$1 = state_16181;
var statearr_16211_16240 = state_16181__$1;
(statearr_16211_16240[(2)] = inst_16176);

(statearr_16211_16240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (18))){
var inst_16131 = (state_16181[(8)]);
var inst_16157 = (state_16181[(13)]);
var inst_16137 = (state_16181[(10)]);
var inst_16144 = (state_16181[(11)]);
var inst_16159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16160 = fluree.db.flake.s.call(null,inst_16137);
var inst_16161 = [inst_16160,inst_16144,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16162 = (new cljs.core.PersistentVector(null,3,(5),inst_16159,inst_16161,null));
var inst_16163 = cljs.core.assoc_in.call(null,inst_16131,inst_16162,inst_16157);
var state_16181__$1 = state_16181;
var statearr_16212_16241 = state_16181__$1;
(statearr_16212_16241[(2)] = inst_16163);

(statearr_16212_16241[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16182 === (8))){
var inst_16113 = (state_16181[(2)]);
var inst_16114 = cljs.core.PersistentHashSet.EMPTY;
var inst_16115 = cljs.core.vals.call(null,tempids);
var inst_16116 = cljs.core.into.call(null,inst_16114,inst_16115);
var inst_16117 = (function (){var pred_flakes = inst_16113;
var is_new_QMARK_ = inst_16116;
return (function (p1__16102_SHARP_,p2__16101_SHARP_){
var f = p2__16101_SHARP_;
return cljs.core.assoc_in.call(null,p1__16102_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s.call(null,f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,fluree.db.flake.s.call(null,f))));
});
})();
var inst_16118 = cljs.core.PersistentHashMap.EMPTY;
var inst_16119 = cljs.core.reduce.call(null,inst_16117,inst_16118,inst_16113);
var inst_16127 = cljs.core.seq.call(null,inst_16113);
var inst_16128 = cljs.core.first.call(null,inst_16127);
var inst_16129 = cljs.core.next.call(null,inst_16127);
var inst_16130 = inst_16113;
var inst_16131 = inst_16119;
var state_16181__$1 = (function (){var statearr_16213 = state_16181;
(statearr_16213[(8)] = inst_16131);

(statearr_16213[(14)] = inst_16128);

(statearr_16213[(9)] = inst_16130);

(statearr_16213[(15)] = inst_16129);

return statearr_16213;
})();
var statearr_16214_16242 = state_16181__$1;
(statearr_16214_16242[(2)] = null);

(statearr_16214_16242[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0 = (function (){
var statearr_16215 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16215[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__);

(statearr_16215[(1)] = (1));

return statearr_16215;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1 = (function (state_16181){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16216){var ex__2749__auto__ = e16216;
var statearr_16217_16243 = state_16181;
(statearr_16217_16243[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16181[(4)]))){
var statearr_16218_16244 = state_16181;
(statearr_16218_16244[(1)] = cljs.core.first.call(null,(state_16181[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16245 = state_16181;
state_16181 = G__16245;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = function(state_16181){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1.call(this,state_16181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16219 = f__2769__auto__.call(null);
(statearr_16219[(6)] = c__2768__auto__);

return statearr_16219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16247 = arguments.length;
switch (G__16247) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16250 = arguments.length;
switch (G__16250) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16562){
var state_val_16563 = (state_16562[(1)]);
if((state_val_16563 === (121))){
var inst_16517 = (state_16562[(7)]);
var state_16562__$1 = state_16562;
var statearr_16564_16757 = state_16562__$1;
(statearr_16564_16757[(2)] = inst_16517);

(statearr_16564_16757[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (65))){
var inst_16416 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16416)){
var statearr_16565_16758 = state_16562__$1;
(statearr_16565_16758[(1)] = (66));

} else {
var statearr_16566_16759 = state_16562__$1;
(statearr_16566_16759[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (70))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16426 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16427 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,3,inst_16426,null);
var inst_16428 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16427,null);
var inst_16429 = inst_16428.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16429)){
var statearr_16567_16760 = state_16562__$1;
(statearr_16567_16760[(1)] = (72));

} else {
var statearr_16568_16761 = state_16562__$1;
(statearr_16568_16761[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (62))){
var inst_16406 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16569_16762 = state_16562__$1;
(statearr_16569_16762[(2)] = inst_16406);

(statearr_16569_16762[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (74))){
var inst_16512 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16570_16763 = state_16562__$1;
(statearr_16570_16763[(2)] = inst_16512);

(statearr_16570_16763[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (110))){
var inst_16539 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16539)){
var statearr_16571_16764 = state_16562__$1;
(statearr_16571_16764[(1)] = (117));

} else {
var statearr_16572_16765 = state_16562__$1;
(statearr_16572_16765[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (7))){
var inst_16557 = (state_16562[(2)]);
var _ = (function (){var statearr_16573 = state_16562;
(statearr_16573[(4)] = cljs.core.rest.call(null,(state_16562[(4)])));

return statearr_16573;
})();
var state_16562__$1 = state_16562;
var statearr_16574_16766 = state_16562__$1;
(statearr_16574_16766[(2)] = inst_16557);

(statearr_16574_16766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (59))){
var inst_16290 = (state_16562[(10)]);
var inst_16410 = (state_16562[(11)]);
var inst_16409 = (state_16562[(2)]);
var inst_16410__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16575 = state_16562;
(statearr_16575[(12)] = inst_16409);

(statearr_16575[(11)] = inst_16410__$1);

return statearr_16575;
})();
if(cljs.core.truth_(inst_16410__$1)){
var statearr_16576_16767 = state_16562__$1;
(statearr_16576_16767[(1)] = (63));

} else {
var statearr_16577_16768 = state_16562__$1;
(statearr_16577_16768[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (86))){
var inst_16452 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16578_16769 = state_16562__$1;
(statearr_16578_16769[(2)] = inst_16452);

(statearr_16578_16769[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (20))){
var inst_16290 = (state_16562[(10)]);
var inst_16316 = (state_16562[(13)]);
var inst_16316__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16579 = state_16562;
(statearr_16579[(13)] = inst_16316__$1);

return statearr_16579;
})();
if(cljs.core.truth_(inst_16316__$1)){
var statearr_16580_16770 = state_16562__$1;
(statearr_16580_16770[(1)] = (23));

} else {
var statearr_16581_16771 = state_16562__$1;
(statearr_16581_16771[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (72))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16431 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16582_16772 = state_16562__$1;
(statearr_16582_16772[(2)] = inst_16431);

(statearr_16582_16772[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (58))){
var inst_16371 = (state_16562[(14)]);
var state_16562__$1 = state_16562;
var statearr_16583_16773 = state_16562__$1;
(statearr_16583_16773[(2)] = inst_16371);

(statearr_16583_16773[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (60))){
var inst_16289 = (state_16562[(15)]);
var inst_16278 = (state_16562[(16)]);
var inst_16397 = fluree.db.dbproto._p_prop.call(null,inst_16278,new cljs.core.Keyword(null,"name","name",1843675177),inst_16289);
var inst_16398 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16397)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16399 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16400 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16401 = cljs.core.PersistentHashMap.fromArrays(inst_16399,inst_16400);
var inst_16402 = cljs.core.ex_info.call(null,inst_16398,inst_16401);
var inst_16403 = (function(){throw inst_16402})();
var state_16562__$1 = state_16562;
var statearr_16584_16774 = state_16562__$1;
(statearr_16584_16774[(2)] = inst_16403);

(statearr_16584_16774[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (27))){
var inst_16319 = (state_16562[(17)]);
var state_16562__$1 = state_16562;
var statearr_16585_16775 = state_16562__$1;
(statearr_16585_16775[(2)] = inst_16319);

(statearr_16585_16775[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (1))){
var state_16562__$1 = state_16562;
var statearr_16586_16776 = state_16562__$1;
(statearr_16586_16776[(2)] = null);

(statearr_16586_16776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (69))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16587_16777 = state_16562__$1;
(statearr_16587_16777[(2)] = inst_16409);

(statearr_16587_16777[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (101))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16490 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16588_16778 = state_16562__$1;
(statearr_16588_16778[(2)] = inst_16490);

(statearr_16588_16778[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (24))){
var inst_16316 = (state_16562[(13)]);
var state_16562__$1 = state_16562;
var statearr_16589_16779 = state_16562__$1;
(statearr_16589_16779[(2)] = inst_16316);

(statearr_16589_16779[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (102))){
var inst_16492 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16590_16780 = state_16562__$1;
(statearr_16590_16780[(2)] = inst_16492);

(statearr_16590_16780[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (55))){
var inst_16388 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16591_16781 = state_16562__$1;
(statearr_16591_16781[(2)] = inst_16388);

(statearr_16591_16781[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (85))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16450 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16592_16782 = state_16562__$1;
(statearr_16592_16782[(2)] = inst_16450);

(statearr_16592_16782[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (39))){
var inst_16353 = (state_16562[(18)]);
var state_16562__$1 = state_16562;
var statearr_16593_16783 = state_16562__$1;
(statearr_16593_16783[(2)] = inst_16353);

(statearr_16593_16783[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (88))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16594_16784 = state_16562__$1;
(statearr_16594_16784[(2)] = inst_16409);

(statearr_16594_16784[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (46))){
var inst_16290 = (state_16562[(10)]);
var inst_16372 = (state_16562[(19)]);
var inst_16371 = (state_16562[(2)]);
var inst_16372__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16595 = state_16562;
(statearr_16595[(19)] = inst_16372__$1);

(statearr_16595[(14)] = inst_16371);

return statearr_16595;
})();
if(cljs.core.truth_(inst_16372__$1)){
var statearr_16596_16785 = state_16562__$1;
(statearr_16596_16785[(1)] = (47));

} else {
var statearr_16597_16786 = state_16562__$1;
(statearr_16597_16786[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (4))){
var inst_16251 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16598_16787 = state_16562__$1;
(statearr_16598_16787[(2)] = inst_16251);

(statearr_16598_16787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (77))){
var inst_16510 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16599_16788 = state_16562__$1;
(statearr_16599_16788[(2)] = inst_16510);

(statearr_16599_16788[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (106))){
var inst_16502 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16600_16789 = state_16562__$1;
(statearr_16600_16789[(2)] = inst_16502);

(statearr_16600_16789[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (119))){
var inst_16288 = (state_16562[(20)]);
var inst_16552 = (state_16562[(2)]);
var inst_16277 = inst_16288;
var inst_16278 = inst_16552;
var state_16562__$1 = (function (){var statearr_16601 = state_16562;
(statearr_16601[(16)] = inst_16278);

(statearr_16601[(21)] = inst_16277);

return statearr_16601;
})();
var statearr_16602_16790 = state_16562__$1;
(statearr_16602_16790[(2)] = null);

(statearr_16602_16790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (95))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16474 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16475 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,5,inst_16474,null);
var inst_16476 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16475,null);
var inst_16477 = inst_16476.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16477)){
var statearr_16603_16791 = state_16562__$1;
(statearr_16603_16791[(1)] = (96));

} else {
var statearr_16604_16792 = state_16562__$1;
(statearr_16604_16792[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (54))){
var inst_16379 = (state_16562[(22)]);
var state_16562__$1 = state_16562;
var statearr_16605_16793 = state_16562__$1;
(statearr_16605_16793[(2)] = inst_16379);

(statearr_16605_16793[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (92))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16606_16794 = state_16562__$1;
(statearr_16606_16794[(2)] = inst_16409);

(statearr_16606_16794[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (104))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16607_16795 = state_16562__$1;
(statearr_16607_16795[(2)] = inst_16409);

(statearr_16607_16795[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (15))){
var inst_16298 = (state_16562[(23)]);
var state_16562__$1 = state_16562;
var statearr_16608_16796 = state_16562__$1;
(statearr_16608_16796[(2)] = inst_16298);

(statearr_16608_16796[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (48))){
var inst_16372 = (state_16562[(19)]);
var state_16562__$1 = state_16562;
var statearr_16609_16797 = state_16562__$1;
(statearr_16609_16797[(2)] = inst_16372);

(statearr_16609_16797[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (50))){
var inst_16290 = (state_16562[(10)]);
var inst_16379 = (state_16562[(22)]);
var inst_16377 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16378 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16377);
var inst_16379__$1 = inst_16378 === true;
var state_16562__$1 = (function (){var statearr_16610 = state_16562;
(statearr_16610[(22)] = inst_16379__$1);

return statearr_16610;
})();
if(cljs.core.truth_(inst_16379__$1)){
var statearr_16611_16798 = state_16562__$1;
(statearr_16611_16798[(1)] = (53));

} else {
var statearr_16612_16799 = state_16562__$1;
(statearr_16612_16799[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (116))){
var inst_16533 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16613_16800 = state_16562__$1;
(statearr_16613_16800[(2)] = inst_16533);

(statearr_16613_16800[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (75))){
var inst_16422 = (state_16562[(8)]);
var state_16562__$1 = state_16562;
var G__16614_16801 = inst_16422;
var G__16614_16802__$1 = (((G__16614_16801 instanceof cljs.core.Keyword))?G__16614_16801.fqn:null);
switch (G__16614_16802__$1) {
case "long":
var statearr_16615_16804 = state_16562__$1;
(statearr_16615_16804[(1)] = (79));


break;
case "bigint":
var statearr_16616_16805 = state_16562__$1;
(statearr_16616_16805[(1)] = (83));


break;
case "double":
var statearr_16617_16806 = state_16562__$1;
(statearr_16617_16806[(1)] = (87));


break;
case "float":
var statearr_16618_16807 = state_16562__$1;
(statearr_16618_16807[(1)] = (91));


break;
case "bigdec":
var statearr_16619_16808 = state_16562__$1;
(statearr_16619_16808[(1)] = (95));


break;
case "string":
var statearr_16620_16809 = state_16562__$1;
(statearr_16620_16809[(1)] = (99));


break;
case "instant":
var statearr_16621_16810 = state_16562__$1;
(statearr_16621_16810[(1)] = (103));


break;
default:
var statearr_16622_16811 = state_16562__$1;
(statearr_16622_16811[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (99))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16484 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16485 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,5,inst_16484,null);
var inst_16486 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16485,null);
var inst_16487 = inst_16486.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16487)){
var statearr_16623_16812 = state_16562__$1;
(statearr_16623_16812[(1)] = (100));

} else {
var statearr_16624_16813 = state_16562__$1;
(statearr_16624_16813[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (21))){
var inst_16314 = (state_16562[(24)]);
var state_16562__$1 = state_16562;
var statearr_16625_16814 = state_16562__$1;
(statearr_16625_16814[(2)] = inst_16314);

(statearr_16625_16814[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (31))){
var inst_16330 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16626_16815 = state_16562__$1;
(statearr_16626_16815[(2)] = inst_16330);

(statearr_16626_16815[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (113))){
var inst_16536 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16627_16816 = state_16562__$1;
(statearr_16627_16816[(2)] = inst_16536);

(statearr_16627_16816[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (32))){
var state_16562__$1 = state_16562;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16628_16817 = state_16562__$1;
(statearr_16628_16817[(1)] = (35));

} else {
var statearr_16629_16818 = state_16562__$1;
(statearr_16629_16818[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (40))){
var inst_16366 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16366)){
var statearr_16630_16819 = state_16562__$1;
(statearr_16630_16819[(1)] = (44));

} else {
var statearr_16631_16820 = state_16562__$1;
(statearr_16631_16820[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (91))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16464 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16465 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,3,inst_16464,null);
var inst_16466 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16465,null);
var inst_16467 = inst_16466.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16467)){
var statearr_16632_16821 = state_16562__$1;
(statearr_16632_16821[(1)] = (92));

} else {
var statearr_16633_16822 = state_16562__$1;
(statearr_16633_16822[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (117))){
var state_16562__$1 = state_16562;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16634_16823 = state_16562__$1;
(statearr_16634_16823[(1)] = (120));

} else {
var statearr_16635_16824 = state_16562__$1;
(statearr_16635_16824[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (108))){
var inst_16290 = (state_16562[(10)]);
var inst_16521 = (state_16562[(25)]);
var inst_16521__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16636 = state_16562;
(statearr_16636[(25)] = inst_16521__$1);

return statearr_16636;
})();
if(cljs.core.truth_(inst_16521__$1)){
var statearr_16637_16825 = state_16562__$1;
(statearr_16637_16825[(1)] = (111));

} else {
var statearr_16638_16826 = state_16562__$1;
(statearr_16638_16826[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (56))){
var inst_16383 = (state_16562[(2)]);
var inst_16384 = fluree.db.util.async.throw_err.call(null,inst_16383);
var inst_16385 = cljs.core.not.call(null,inst_16384);
var state_16562__$1 = state_16562;
var statearr_16639_16827 = state_16562__$1;
(statearr_16639_16827[(2)] = inst_16385);

(statearr_16639_16827[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (33))){
var inst_16313 = (state_16562[(26)]);
var state_16562__$1 = state_16562;
var statearr_16640_16828 = state_16562__$1;
(statearr_16640_16828[(2)] = inst_16313);

(statearr_16640_16828[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (13))){
var inst_16308 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16308)){
var statearr_16641_16829 = state_16562__$1;
(statearr_16641_16829[(1)] = (17));

} else {
var statearr_16642_16830 = state_16562__$1;
(statearr_16642_16830[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (22))){
var inst_16339 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16339)){
var statearr_16643_16831 = state_16562__$1;
(statearr_16643_16831[(1)] = (32));

} else {
var statearr_16644_16832 = state_16562__$1;
(statearr_16644_16832[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (90))){
var inst_16462 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16645_16833 = state_16562__$1;
(statearr_16645_16833[(2)] = inst_16462);

(statearr_16645_16833[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (109))){
var inst_16519 = (state_16562[(27)]);
var state_16562__$1 = state_16562;
var statearr_16646_16834 = state_16562__$1;
(statearr_16646_16834[(2)] = inst_16519);

(statearr_16646_16834[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (36))){
var inst_16313 = (state_16562[(26)]);
var state_16562__$1 = state_16562;
var statearr_16647_16835 = state_16562__$1;
(statearr_16647_16835[(2)] = inst_16313);

(statearr_16647_16835[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (41))){
var inst_16290 = (state_16562[(10)]);
var inst_16358 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16359 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16358);
var inst_16360 = inst_16359 === true;
var state_16562__$1 = state_16562;
var statearr_16648_16836 = state_16562__$1;
(statearr_16648_16836[(2)] = inst_16360);

(statearr_16648_16836[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (118))){
var inst_16517 = (state_16562[(7)]);
var state_16562__$1 = state_16562;
var statearr_16649_16837 = state_16562__$1;
(statearr_16649_16837[(2)] = inst_16517);

(statearr_16649_16837[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (89))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16460 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16650_16838 = state_16562__$1;
(statearr_16650_16838[(2)] = inst_16460);

(statearr_16650_16838[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (100))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16651_16839 = state_16562__$1;
(statearr_16651_16839[(2)] = inst_16409);

(statearr_16651_16839[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (122))){
var inst_16549 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16652_16840 = state_16562__$1;
(statearr_16652_16840[(2)] = inst_16549);

(statearr_16652_16840[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (43))){
var inst_16363 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16653_16841 = state_16562__$1;
(statearr_16653_16841[(2)] = inst_16363);

(statearr_16653_16841[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (61))){
var inst_16371 = (state_16562[(14)]);
var state_16562__$1 = state_16562;
var statearr_16654_16842 = state_16562__$1;
(statearr_16654_16842[(2)] = inst_16371);

(statearr_16654_16842[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (29))){
var inst_16290 = (state_16562[(10)]);
var inst_16325 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16326 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16325);
var inst_16327 = inst_16326 === true;
var state_16562__$1 = state_16562;
var statearr_16655_16843 = state_16562__$1;
(statearr_16655_16843[(2)] = inst_16327);

(statearr_16655_16843[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (44))){
var inst_16352 = (state_16562[(28)]);
var inst_16368 = fluree.db.query.schema.type_error.call(null,inst_16352,"a component","a non-component",throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16656_16844 = state_16562__$1;
(statearr_16656_16844[(2)] = inst_16368);

(statearr_16656_16844[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (93))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16470 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16657_16845 = state_16562__$1;
(statearr_16657_16845[(2)] = inst_16470);

(statearr_16657_16845[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (6))){
var inst_16289 = (state_16562[(15)]);
var inst_16277 = (state_16562[(21)]);
var inst_16286 = cljs.core.seq.call(null,inst_16277);
var inst_16287 = cljs.core.first.call(null,inst_16286);
var inst_16288 = cljs.core.next.call(null,inst_16286);
var inst_16289__$1 = cljs.core.nth.call(null,inst_16287,(0),null);
var inst_16290 = cljs.core.nth.call(null,inst_16287,(1),null);
var inst_16291 = cljs.core.not.call(null,inst_16289__$1);
var state_16562__$1 = (function (){var statearr_16658 = state_16562;
(statearr_16658[(20)] = inst_16288);

(statearr_16658[(10)] = inst_16290);

(statearr_16658[(15)] = inst_16289__$1);

return statearr_16658;
})();
if(inst_16291){
var statearr_16659_16846 = state_16562__$1;
(statearr_16659_16846[(1)] = (8));

} else {
var statearr_16660_16847 = state_16562__$1;
(statearr_16660_16847[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (111))){
var inst_16290 = (state_16562[(10)]);
var inst_16525 = (state_16562[(29)]);
var inst_16523 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16524 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16523);
var inst_16525__$1 = inst_16524 === true;
var state_16562__$1 = (function (){var statearr_16661 = state_16562;
(statearr_16661[(29)] = inst_16525__$1);

return statearr_16661;
})();
if(cljs.core.truth_(inst_16525__$1)){
var statearr_16662_16848 = state_16562__$1;
(statearr_16662_16848[(1)] = (114));

} else {
var statearr_16663_16849 = state_16562__$1;
(statearr_16663_16849[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (28))){
var inst_16333 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16664_16850 = state_16562__$1;
(statearr_16664_16850[(2)] = inst_16333);

(statearr_16664_16850[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (64))){
var inst_16410 = (state_16562[(11)]);
var state_16562__$1 = state_16562;
var statearr_16665_16851 = state_16562__$1;
(statearr_16665_16851[(2)] = inst_16410);

(statearr_16665_16851[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (103))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16494 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16495 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,2,inst_16494,null);
var inst_16496 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16495,null);
var inst_16497 = inst_16496.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16497)){
var statearr_16666_16852 = state_16562__$1;
(statearr_16666_16852[(1)] = (104));

} else {
var statearr_16667_16853 = state_16562__$1;
(statearr_16667_16853[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (51))){
var inst_16375 = (state_16562[(30)]);
var state_16562__$1 = state_16562;
var statearr_16668_16854 = state_16562__$1;
(statearr_16668_16854[(2)] = inst_16375);

(statearr_16668_16854[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (25))){
var inst_16336 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16669_16855 = state_16562__$1;
(statearr_16669_16855[(2)] = inst_16336);

(statearr_16669_16855[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (34))){
var inst_16290 = (state_16562[(10)]);
var inst_16353 = (state_16562[(18)]);
var inst_16352 = (state_16562[(2)]);
var inst_16353__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16670 = state_16562;
(statearr_16670[(18)] = inst_16353__$1);

(statearr_16670[(28)] = inst_16352);

return statearr_16670;
})();
if(cljs.core.truth_(inst_16353__$1)){
var statearr_16671_16856 = state_16562__$1;
(statearr_16671_16856[(1)] = (38));

} else {
var statearr_16672_16857 = state_16562__$1;
(statearr_16672_16857[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (17))){
var inst_16278 = (state_16562[(16)]);
var inst_16310 = fluree.db.query.schema.type_error.call(null,inst_16278,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16673_16858 = state_16562__$1;
(statearr_16673_16858[(2)] = inst_16310);

(statearr_16673_16858[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (3))){
var inst_16560 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16562__$1,inst_16560);
} else {
if((state_val_16563 === (12))){
var inst_16294 = (state_16562[(31)]);
var state_16562__$1 = state_16562;
var statearr_16674_16859 = state_16562__$1;
(statearr_16674_16859[(2)] = inst_16294);

(statearr_16674_16859[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (2))){
var _ = (function (){var statearr_16675 = state_16562;
(statearr_16675[(4)] = cljs.core.cons.call(null,(5),(state_16562[(4)])));

return statearr_16675;
})();
var inst_16270 = pred_changes;
var inst_16271 = cljs.core.seq.call(null,inst_16270);
var inst_16272 = cljs.core.first.call(null,inst_16271);
var inst_16273 = cljs.core.next.call(null,inst_16271);
var inst_16274 = cljs.core.nth.call(null,inst_16272,(0),null);
var inst_16275 = cljs.core.nth.call(null,inst_16272,(1),null);
var inst_16276 = db;
var inst_16277 = inst_16270;
var inst_16278 = inst_16276;
var state_16562__$1 = (function (){var statearr_16676 = state_16562;
(statearr_16676[(32)] = inst_16273);

(statearr_16676[(33)] = inst_16274);

(statearr_16676[(34)] = inst_16275);

(statearr_16676[(16)] = inst_16278);

(statearr_16676[(21)] = inst_16277);

return statearr_16676;
})();
var statearr_16677_16860 = state_16562__$1;
(statearr_16677_16860[(2)] = null);

(statearr_16677_16860[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (66))){
var inst_16290 = (state_16562[(10)]);
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16419 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16420 = cljs.core.__destructure_map.call(null,inst_16419);
var inst_16421__$1 = cljs.core.get.call(null,inst_16420,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16422__$1 = cljs.core.get.call(null,inst_16420,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16423 = cljs.core._EQ_.call(null,inst_16422__$1,inst_16421__$1);
var state_16562__$1 = (function (){var statearr_16678 = state_16562;
(statearr_16678[(8)] = inst_16422__$1);

(statearr_16678[(9)] = inst_16421__$1);

return statearr_16678;
})();
if(inst_16423){
var statearr_16679_16861 = state_16562__$1;
(statearr_16679_16861[(1)] = (69));

} else {
var statearr_16680_16862 = state_16562__$1;
(statearr_16680_16862[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (107))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16504 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16681_16863 = state_16562__$1;
(statearr_16681_16863[(2)] = inst_16504);

(statearr_16681_16863[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (23))){
var inst_16290 = (state_16562[(10)]);
var inst_16319 = (state_16562[(17)]);
var inst_16318 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16319__$1 = inst_16318 === true;
var state_16562__$1 = (function (){var statearr_16682 = state_16562;
(statearr_16682[(17)] = inst_16319__$1);

return statearr_16682;
})();
if(cljs.core.truth_(inst_16319__$1)){
var statearr_16683_16864 = state_16562__$1;
(statearr_16683_16864[(1)] = (26));

} else {
var statearr_16684_16865 = state_16562__$1;
(statearr_16684_16865[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (47))){
var inst_16290 = (state_16562[(10)]);
var inst_16375 = (state_16562[(30)]);
var inst_16374 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16375__$1 = cljs.core.not.call(null,inst_16374);
var state_16562__$1 = (function (){var statearr_16685 = state_16562;
(statearr_16685[(30)] = inst_16375__$1);

return statearr_16685;
})();
if(inst_16375__$1){
var statearr_16686_16866 = state_16562__$1;
(statearr_16686_16866[(1)] = (50));

} else {
var statearr_16687_16867 = state_16562__$1;
(statearr_16687_16867[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (35))){
var inst_16342 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16343 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16344 = cljs.core.PersistentHashMap.fromArrays(inst_16342,inst_16343);
var inst_16345 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16344);
var inst_16346 = (function(){throw inst_16345})();
var state_16562__$1 = state_16562;
var statearr_16688_16868 = state_16562__$1;
(statearr_16688_16868[(2)] = inst_16346);

(statearr_16688_16868[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (82))){
var inst_16442 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16689_16869 = state_16562__$1;
(statearr_16689_16869[(2)] = inst_16442);

(statearr_16689_16869[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (76))){
var state_16562__$1 = state_16562;
var statearr_16690_16870 = state_16562__$1;
(statearr_16690_16870[(2)] = null);

(statearr_16690_16870[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (97))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16480 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16691_16871 = state_16562__$1;
(statearr_16691_16871[(2)] = inst_16480);

(statearr_16691_16871[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (19))){
var inst_16314 = (state_16562[(24)]);
var inst_16290 = (state_16562[(10)]);
var inst_16313 = (state_16562[(2)]);
var inst_16314__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16692 = state_16562;
(statearr_16692[(24)] = inst_16314__$1);

(statearr_16692[(26)] = inst_16313);

return statearr_16692;
})();
if(cljs.core.truth_(inst_16314__$1)){
var statearr_16693_16872 = state_16562__$1;
(statearr_16693_16872[(1)] = (20));

} else {
var statearr_16694_16873 = state_16562__$1;
(statearr_16694_16873[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (57))){
var state_16562__$1 = state_16562;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16695_16874 = state_16562__$1;
(statearr_16695_16874[(1)] = (60));

} else {
var statearr_16696_16875 = state_16562__$1;
(statearr_16696_16875[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (68))){
var inst_16519 = (state_16562[(27)]);
var inst_16290 = (state_16562[(10)]);
var inst_16517 = (state_16562[(2)]);
var inst_16518 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16519__$1 = inst_16518 === true;
var state_16562__$1 = (function (){var statearr_16697 = state_16562;
(statearr_16697[(27)] = inst_16519__$1);

(statearr_16697[(7)] = inst_16517);

return statearr_16697;
})();
if(cljs.core.truth_(inst_16519__$1)){
var statearr_16698_16876 = state_16562__$1;
(statearr_16698_16876[(1)] = (108));

} else {
var statearr_16699_16877 = state_16562__$1;
(statearr_16699_16877[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (11))){
var inst_16290 = (state_16562[(10)]);
var inst_16298 = (state_16562[(23)]);
var inst_16296 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16297 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16298__$1 = inst_16297 === false;
var state_16562__$1 = (function (){var statearr_16700 = state_16562;
(statearr_16700[(23)] = inst_16298__$1);

return statearr_16700;
})();
if(cljs.core.truth_(inst_16298__$1)){
var statearr_16701_16878 = state_16562__$1;
(statearr_16701_16878[(1)] = (14));

} else {
var statearr_16702_16879 = state_16562__$1;
(statearr_16702_16879[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (115))){
var inst_16525 = (state_16562[(29)]);
var state_16562__$1 = state_16562;
var statearr_16704_16880 = state_16562__$1;
(statearr_16704_16880[(2)] = inst_16525);

(statearr_16704_16880[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (9))){
var inst_16290 = (state_16562[(10)]);
var inst_16294 = (state_16562[(31)]);
var inst_16294__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16290);
var state_16562__$1 = (function (){var statearr_16705 = state_16562;
(statearr_16705[(31)] = inst_16294__$1);

return statearr_16705;
})();
if(cljs.core.truth_(inst_16294__$1)){
var statearr_16706_16881 = state_16562__$1;
(statearr_16706_16881[(1)] = (11));

} else {
var statearr_16707_16882 = state_16562__$1;
(statearr_16707_16882[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (5))){
var _ = (function (){var statearr_16708 = state_16562;
(statearr_16708[(4)] = cljs.core.rest.call(null,(state_16562[(4)])));

return statearr_16708;
})();
var state_16562__$1 = state_16562;
var ex16703 = (state_16562__$1[(2)]);
var statearr_16709_16883 = state_16562__$1;
(statearr_16709_16883[(5)] = ex16703);


if((ex16703 instanceof Error)){
var statearr_16710_16884 = state_16562__$1;
(statearr_16710_16884[(1)] = (4));

(statearr_16710_16884[(5)] = null);

} else {
throw ex16703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (112))){
var inst_16521 = (state_16562[(25)]);
var state_16562__$1 = state_16562;
var statearr_16711_16885 = state_16562__$1;
(statearr_16711_16885[(2)] = inst_16521);

(statearr_16711_16885[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (83))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16444 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16445 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,3,inst_16444,null);
var inst_16446 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16445,null);
var inst_16447 = inst_16446.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16447)){
var statearr_16712_16886 = state_16562__$1;
(statearr_16712_16886[(1)] = (84));

} else {
var statearr_16713_16887 = state_16562__$1;
(statearr_16713_16887[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (14))){
var inst_16290 = (state_16562[(10)]);
var inst_16300 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16301 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16300);
var inst_16302 = inst_16301 === true;
var state_16562__$1 = state_16562;
var statearr_16714_16888 = state_16562__$1;
(statearr_16714_16888[(2)] = inst_16302);

(statearr_16714_16888[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (45))){
var inst_16352 = (state_16562[(28)]);
var state_16562__$1 = state_16562;
var statearr_16715_16889 = state_16562__$1;
(statearr_16715_16889[(2)] = inst_16352);

(statearr_16715_16889[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (53))){
var inst_16289 = (state_16562[(15)]);
var inst_16278 = (state_16562[(16)]);
var inst_16381 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16278,inst_16289);
var state_16562__$1 = state_16562;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16562__$1,(56),inst_16381);
} else {
if((state_val_16563 === (78))){
var inst_16507 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16716_16890 = state_16562__$1;
(statearr_16716_16890[(2)] = inst_16507);

(statearr_16716_16890[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (26))){
var inst_16290 = (state_16562[(10)]);
var inst_16323 = (state_16562[(35)]);
var inst_16321 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16322 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16321);
var inst_16323__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16322);
var state_16562__$1 = (function (){var statearr_16717 = state_16562;
(statearr_16717[(35)] = inst_16323__$1);

return statearr_16717;
})();
if(inst_16323__$1){
var statearr_16718_16891 = state_16562__$1;
(statearr_16718_16891[(1)] = (29));

} else {
var statearr_16719_16892 = state_16562__$1;
(statearr_16719_16892[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (16))){
var inst_16305 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16720_16893 = state_16562__$1;
(statearr_16720_16893[(2)] = inst_16305);

(statearr_16720_16893[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (81))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16440 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16721_16894 = state_16562__$1;
(statearr_16721_16894[(2)] = inst_16440);

(statearr_16721_16894[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (120))){
var inst_16542 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16543 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16544 = cljs.core.PersistentHashMap.fromArrays(inst_16542,inst_16543);
var inst_16545 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_16544);
var inst_16546 = (function(){throw inst_16545})();
var state_16562__$1 = state_16562;
var statearr_16722_16895 = state_16562__$1;
(statearr_16722_16895[(2)] = inst_16546);

(statearr_16722_16895[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (79))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16434 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16435 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,2,inst_16434,null);
var inst_16436 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16435,null);
var inst_16437 = inst_16436.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16437)){
var statearr_16723_16896 = state_16562__$1;
(statearr_16723_16896[(1)] = (80));

} else {
var statearr_16724_16897 = state_16562__$1;
(statearr_16724_16897[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (38))){
var inst_16290 = (state_16562[(10)]);
var inst_16356 = (state_16562[(36)]);
var inst_16355 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16356__$1 = cljs.core.not.call(null,inst_16355);
var state_16562__$1 = (function (){var statearr_16725 = state_16562;
(statearr_16725[(36)] = inst_16356__$1);

return statearr_16725;
})();
if(inst_16356__$1){
var statearr_16726_16898 = state_16562__$1;
(statearr_16726_16898[(1)] = (41));

} else {
var statearr_16727_16899 = state_16562__$1;
(statearr_16727_16899[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (98))){
var inst_16482 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16728_16900 = state_16562__$1;
(statearr_16728_16900[(2)] = inst_16482);

(statearr_16728_16900[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (87))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16454 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16455 = inst_16422.call(null,cljs.core.PersistentArrayMap,null,3,inst_16454,null);
var inst_16456 = inst_16422.call(null,cljs.core.PersistentHashSet,null,inst_16455,null);
var inst_16457 = inst_16456.call(null,inst_16421);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16457)){
var statearr_16729_16901 = state_16562__$1;
(statearr_16729_16901[(1)] = (88));

} else {
var statearr_16730_16902 = state_16562__$1;
(statearr_16730_16902[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (30))){
var inst_16323 = (state_16562[(35)]);
var state_16562__$1 = state_16562;
var statearr_16731_16903 = state_16562__$1;
(statearr_16731_16903[(2)] = inst_16323);

(statearr_16731_16903[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (73))){
var state_16562__$1 = state_16562;
var statearr_16732_16904 = state_16562__$1;
(statearr_16732_16904[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (96))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16734_16905 = state_16562__$1;
(statearr_16734_16905[(2)] = inst_16409);

(statearr_16734_16905[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (10))){
var inst_16555 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16735_16906 = state_16562__$1;
(statearr_16735_16906[(2)] = inst_16555);

(statearr_16735_16906[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (18))){
var inst_16278 = (state_16562[(16)]);
var state_16562__$1 = state_16562;
var statearr_16736_16907 = state_16562__$1;
(statearr_16736_16907[(2)] = inst_16278);

(statearr_16736_16907[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (105))){
var inst_16422 = (state_16562[(8)]);
var inst_16421 = (state_16562[(9)]);
var inst_16500 = fluree.db.query.schema.type_error.call(null,inst_16421,inst_16422,throw_QMARK_);
var state_16562__$1 = state_16562;
var statearr_16737_16908 = state_16562__$1;
(statearr_16737_16908[(2)] = inst_16500);

(statearr_16737_16908[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (52))){
var inst_16391 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16738_16909 = state_16562__$1;
(statearr_16738_16909[(2)] = inst_16391);

(statearr_16738_16909[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (114))){
var inst_16290 = (state_16562[(10)]);
var inst_16527 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16528 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16527);
var inst_16529 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16528);
var inst_16530 = (!(inst_16529));
var state_16562__$1 = state_16562;
var statearr_16739_16910 = state_16562__$1;
(statearr_16739_16910[(2)] = inst_16530);

(statearr_16739_16910[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (67))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16740_16911 = state_16562__$1;
(statearr_16740_16911[(2)] = inst_16409);

(statearr_16740_16911[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (71))){
var inst_16514 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16741_16912 = state_16562__$1;
(statearr_16741_16912[(2)] = inst_16514);

(statearr_16741_16912[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (42))){
var inst_16356 = (state_16562[(36)]);
var state_16562__$1 = state_16562;
var statearr_16742_16913 = state_16562__$1;
(statearr_16742_16913[(2)] = inst_16356);

(statearr_16742_16913[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (80))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16743_16914 = state_16562__$1;
(statearr_16743_16914[(2)] = inst_16409);

(statearr_16743_16914[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (37))){
var inst_16349 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16744_16915 = state_16562__$1;
(statearr_16744_16915[(2)] = inst_16349);

(statearr_16744_16915[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (63))){
var inst_16290 = (state_16562[(10)]);
var inst_16412 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16290);
var inst_16413 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16412);
var state_16562__$1 = state_16562;
var statearr_16745_16916 = state_16562__$1;
(statearr_16745_16916[(2)] = inst_16413);

(statearr_16745_16916[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (94))){
var inst_16472 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
var statearr_16746_16917 = state_16562__$1;
(statearr_16746_16917[(2)] = inst_16472);

(statearr_16746_16917[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (8))){
var inst_16278 = (state_16562[(16)]);
var state_16562__$1 = state_16562;
var statearr_16747_16918 = state_16562__$1;
(statearr_16747_16918[(2)] = inst_16278);

(statearr_16747_16918[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (49))){
var inst_16394 = (state_16562[(2)]);
var state_16562__$1 = state_16562;
if(cljs.core.truth_(inst_16394)){
var statearr_16748_16919 = state_16562__$1;
(statearr_16748_16919[(1)] = (57));

} else {
var statearr_16749_16920 = state_16562__$1;
(statearr_16749_16920[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16563 === (84))){
var inst_16409 = (state_16562[(12)]);
var state_16562__$1 = state_16562;
var statearr_16750_16921 = state_16562__$1;
(statearr_16750_16921[(2)] = inst_16409);

(statearr_16750_16921[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16751[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16751[(1)] = (1));

return statearr_16751;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16562){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16562);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16752){var ex__2749__auto__ = e16752;
var statearr_16753_16922 = state_16562;
(statearr_16753_16922[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16562[(4)]))){
var statearr_16754_16923 = state_16562;
(statearr_16754_16923[(1)] = cljs.core.first.call(null,(state_16562[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16924 = state_16562;
state_16562 = G__16924;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16562){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16755 = f__2769__auto__.call(null);
(statearr_16755[(6)] = c__2768__auto__);

return statearr_16755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16926 = arguments.length;
switch (G__16926) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16950){
var state_val_16951 = (state_16950[(1)]);
if((state_val_16951 === (7))){
var state_16950__$1 = state_16950;
var statearr_16952_16972 = state_16950__$1;
(statearr_16952_16972[(2)] = db);

(statearr_16952_16972[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (1))){
var state_16950__$1 = state_16950;
var statearr_16953_16973 = state_16950__$1;
(statearr_16953_16973[(2)] = null);

(statearr_16953_16973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (4))){
var inst_16927 = (state_16950[(2)]);
var state_16950__$1 = state_16950;
var statearr_16954_16974 = state_16950__$1;
(statearr_16954_16974[(2)] = inst_16927);

(statearr_16954_16974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (6))){
var inst_16936 = (state_16950[(7)]);
var inst_16935 = (state_16950[(2)]);
var inst_16936__$1 = fluree.db.util.async.throw_err.call(null,inst_16935);
var inst_16937 = cljs.core.empty_QMARK_.call(null,inst_16936__$1);
var state_16950__$1 = (function (){var statearr_16955 = state_16950;
(statearr_16955[(7)] = inst_16936__$1);

return statearr_16955;
})();
if(inst_16937){
var statearr_16956_16975 = state_16950__$1;
(statearr_16956_16975[(1)] = (7));

} else {
var statearr_16957_16976 = state_16950__$1;
(statearr_16957_16976[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (3))){
var inst_16948 = (state_16950[(2)]);
var state_16950__$1 = state_16950;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16950__$1,inst_16948);
} else {
if((state_val_16951 === (2))){
var _ = (function (){var statearr_16959 = state_16950;
(statearr_16959[(4)] = cljs.core.cons.call(null,(5),(state_16950[(4)])));

return statearr_16959;
})();
var inst_16933 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16950__$1 = state_16950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16950__$1,(6),inst_16933);
} else {
if((state_val_16951 === (9))){
var inst_16945 = (state_16950[(2)]);
var _ = (function (){var statearr_16960 = state_16950;
(statearr_16960[(4)] = cljs.core.rest.call(null,(state_16950[(4)])));

return statearr_16960;
})();
var state_16950__$1 = state_16950;
var statearr_16961_16977 = state_16950__$1;
(statearr_16961_16977[(2)] = inst_16945);

(statearr_16961_16977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (5))){
var _ = (function (){var statearr_16962 = state_16950;
(statearr_16962[(4)] = cljs.core.rest.call(null,(state_16950[(4)])));

return statearr_16962;
})();
var state_16950__$1 = state_16950;
var ex16958 = (state_16950__$1[(2)]);
var statearr_16963_16978 = state_16950__$1;
(statearr_16963_16978[(5)] = ex16958);


if((ex16958 instanceof Error)){
var statearr_16964_16979 = state_16950__$1;
(statearr_16964_16979[(1)] = (4));

(statearr_16964_16979[(5)] = null);

} else {
throw ex16958;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (10))){
var inst_16942 = (state_16950[(2)]);
var inst_16943 = fluree.db.util.async.throw_err.call(null,inst_16942);
var state_16950__$1 = state_16950;
var statearr_16965_16980 = state_16950__$1;
(statearr_16965_16980[(2)] = inst_16943);

(statearr_16965_16980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16951 === (8))){
var inst_16936 = (state_16950[(7)]);
var inst_16940 = fluree.db.query.schema.predicate_change_error.call(null,inst_16936,db,true);
var state_16950__$1 = state_16950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16950__$1,(10),inst_16940);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16966 = [null,null,null,null,null,null,null,null];
(statearr_16966[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16966[(1)] = (1));

return statearr_16966;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16950){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16950);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16967){var ex__2749__auto__ = e16967;
var statearr_16968_16981 = state_16950;
(statearr_16968_16981[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16950[(4)]))){
var statearr_16969_16982 = state_16950;
(statearr_16969_16982[(1)] = cljs.core.first.call(null,(state_16950[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16983 = state_16950;
state_16950 = G__16983;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16950){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16970 = f__2769__auto__.call(null);
(statearr_16970[(6)] = c__2768__auto__);

return statearr_16970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16985 = arguments.length;
switch (G__16985) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16987 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16987,(0),null);
var ns = cljs.core.nth.call(null,vec__16987,(1),null);
var name = cljs.core.nth.call(null,vec__16987,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = fluree.db.flake.p.call(null,flake);
var o = fluree.db.flake.o.call(null,flake);
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16990_SHARP_,p2__16991_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16990_SHARP_,p2__16991_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16992_SHARP_){
var f = p1__16992_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,fluree.db.flake.p.call(null,f))){
return fluree.db.flake.o.call(null,f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17058){
var state_val_17059 = (state_17058[(1)]);
if((state_val_17059 === (1))){
var state_17058__$1 = state_17058;
var statearr_17060_17077 = state_17058__$1;
(statearr_17060_17077[(2)] = null);

(statearr_17060_17077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17059 === (2))){
var _ = (function (){var statearr_17061 = state_17058;
(statearr_17061[(4)] = cljs.core.cons.call(null,(5),(state_17058[(4)])));

return statearr_17061;
})();
var inst_17010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17011 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_17012 = [inst_17011];
var inst_17013 = (new cljs.core.PersistentVector(null,1,(5),inst_17010,inst_17012,null));
var inst_17014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17015 = [(0)];
var inst_17016 = (new cljs.core.PersistentVector(null,1,(5),inst_17014,inst_17015,null));
var inst_17017 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17013,cljs.core._LT__EQ_,inst_17016);
var state_17058__$1 = state_17058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17058__$1,(6),inst_17017);
} else {
if((state_val_17059 === (3))){
var inst_17056 = (state_17058[(2)]);
var state_17058__$1 = state_17058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17058__$1,inst_17056);
} else {
if((state_val_17059 === (4))){
var inst_16998 = (state_17058[(2)]);
var state_17058__$1 = state_17058;
var statearr_17063_17078 = state_17058__$1;
(statearr_17063_17078[(2)] = inst_16998);

(statearr_17063_17078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17059 === (5))){
var _ = (function (){var statearr_17064 = state_17058;
(statearr_17064[(4)] = cljs.core.rest.call(null,(state_17058[(4)])));

return statearr_17064;
})();
var state_17058__$1 = state_17058;
var ex17062 = (state_17058__$1[(2)]);
var statearr_17065_17079 = state_17058__$1;
(statearr_17065_17079[(5)] = ex17062);


if((ex17062 instanceof Error)){
var statearr_17066_17080 = state_17058__$1;
(statearr_17066_17080[(1)] = (4));

(statearr_17066_17080[(5)] = null);

} else {
throw ex17062;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17059 === (6))){
var inst_17019 = (state_17058[(2)]);
var inst_17020 = fluree.db.util.async.throw_err.call(null,inst_17019);
var inst_17021 = (function (){var schema_flakes = inst_17020;
return (function (p1__16993_SHARP_){
return (fluree.db.flake.s.call(null,p1__16993_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17022 = cljs.core.partition_by.call(null,inst_17021,inst_17020);
var inst_17023 = cljs.core.nth.call(null,inst_17022,(0),null);
var inst_17024 = cljs.core.nth.call(null,inst_17022,(1),null);
var inst_17025 = (function (){var schema_flakes = inst_17020;
var vec__17004 = inst_17022;
var collection_flakes = inst_17023;
var predicate_flakes = inst_17024;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16996_SHARP_,p2__16995_SHARP_){
var f = p2__16995_SHARP_;
return cljs.core.assoc.call(null,p1__16996_SHARP_,fluree.db.flake.p.call(null,f),fluree.db.flake.o.call(null,f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_17026 = [(-1),"_tx"];
var inst_17027 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17028 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17029 = cljs.core.PersistentHashMap.fromArrays(inst_17027,inst_17028);
var inst_17030 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17031 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17032 = cljs.core.PersistentHashMap.fromArrays(inst_17030,inst_17031);
var inst_17033 = [inst_17029,inst_17032];
var inst_17034 = cljs.core.PersistentHashMap.fromArrays(inst_17026,inst_17033);
var inst_17035 = (function (){var schema_flakes = inst_17020;
var vec__17004 = inst_17022;
var collection_flakes = inst_17023;
var predicate_flakes = inst_17024;
return (function (p1__16994_SHARP_){
return fluree.db.flake.s.call(null,p1__16994_SHARP_);
});
})();
var inst_17036 = cljs.core.partition_by.call(null,inst_17035,inst_17023);
var inst_17037 = cljs.core.reduce.call(null,inst_17025,inst_17034,inst_17036);
var inst_17039 = (function (){var schema_flakes = inst_17020;
var vec__17004 = inst_17022;
var collection_flakes = inst_17023;
var predicate_flakes = inst_17024;
var coll = inst_17037;
return (function (p__17038,pred_flakes){
var vec__17067 = p__17038;
var pred = cljs.core.nth.call(null,vec__17067,(0),null);
var fullText = cljs.core.nth.call(null,vec__17067,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_17040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17041 = cljs.core.PersistentHashMap.EMPTY;
var inst_17042 = cljs.core.PersistentHashSet.EMPTY;
var inst_17043 = [inst_17041,inst_17042];
var inst_17044 = (new cljs.core.PersistentVector(null,2,(5),inst_17040,inst_17043,null));
var inst_17045 = (function (){var schema_flakes = inst_17020;
var vec__17004 = inst_17022;
var collection_flakes = inst_17023;
var predicate_flakes = inst_17024;
var coll = inst_17037;
return (function (p1__16997_SHARP_){
return fluree.db.flake.s.call(null,p1__16997_SHARP_);
});
})();
var inst_17046 = cljs.core.partition_by.call(null,inst_17045,inst_17024);
var inst_17047 = cljs.core.reduce.call(null,inst_17039,inst_17044,inst_17046);
var inst_17048 = cljs.core.nth.call(null,inst_17047,(0),null);
var inst_17049 = cljs.core.nth.call(null,inst_17047,(1),null);
var inst_17050 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17051 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17052 = [inst_17051,inst_17037,inst_17048,inst_17049];
var inst_17053 = cljs.core.PersistentHashMap.fromArrays(inst_17050,inst_17052);
var _ = (function (){var statearr_17070 = state_17058;
(statearr_17070[(4)] = cljs.core.rest.call(null,(state_17058[(4)])));

return statearr_17070;
})();
var state_17058__$1 = state_17058;
var statearr_17071_17081 = state_17058__$1;
(statearr_17071_17081[(2)] = inst_17053);

(statearr_17071_17081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0 = (function (){
var statearr_17072 = [null,null,null,null,null,null,null];
(statearr_17072[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2746__auto__);

(statearr_17072[(1)] = (1));

return statearr_17072;
});
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1 = (function (state_17058){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17073){var ex__2749__auto__ = e17073;
var statearr_17074_17082 = state_17058;
(statearr_17074_17082[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17058[(4)]))){
var statearr_17075_17083 = state_17058;
(statearr_17075_17083[(1)] = cljs.core.first.call(null,(state_17058[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17084 = state_17058;
state_17058 = G__17084;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = function(state_17058){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1.call(this,state_17058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17076 = f__2769__auto__.call(null);
(statearr_17076[(6)] = c__2768__auto__);

return statearr_17076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17126){
var state_val_17127 = (state_17126[(1)]);
if((state_val_17127 === (7))){
var inst_17109 = (state_17126[(2)]);
var inst_17110 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_17109);
var inst_17111 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17112 = cljs.core.get.call(null,inst_17110,(114));
var inst_17113 = cljs.core.boolean$.call(null,inst_17112);
var inst_17114 = cljs.core.get.call(null,inst_17110,(110));
var inst_17115 = cljs.core.get.call(null,inst_17110,(117));
var inst_17116 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_17115);
var inst_17117 = cljs.core.get.call(null,inst_17110,(111));
var inst_17118 = cljs.core.get.call(null,inst_17110,(115));
var inst_17119 = cljs.core.get.call(null,inst_17110,(112));
var inst_17120 = [inst_17113,inst_17114,inst_17116,inst_17117,inst_17118,inst_17119];
var inst_17121 = cljs.core.PersistentHashMap.fromArrays(inst_17111,inst_17120);
var _ = (function (){var statearr_17128 = state_17126;
(statearr_17128[(4)] = cljs.core.rest.call(null,(state_17126[(4)])));

return statearr_17128;
})();
var state_17126__$1 = state_17126;
var statearr_17129_17152 = state_17126__$1;
(statearr_17129_17152[(2)] = inst_17121);

(statearr_17129_17152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (1))){
var state_17126__$1 = state_17126;
var statearr_17130_17153 = state_17126__$1;
(statearr_17130_17153[(2)] = null);

(statearr_17130_17153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (4))){
var inst_17085 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
var statearr_17131_17154 = state_17126__$1;
(statearr_17131_17154[(2)] = inst_17085);

(statearr_17131_17154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (6))){
var _ = (function (){var statearr_17132 = state_17126;
(statearr_17132[(4)] = cljs.core.cons.call(null,(9),(state_17126[(4)])));

return statearr_17132;
})();
var inst_17097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17099 = ["_setting/id","root"];
var inst_17100 = (new cljs.core.PersistentVector(null,2,(5),inst_17098,inst_17099,null));
var inst_17101 = [inst_17100];
var inst_17102 = (new cljs.core.PersistentVector(null,1,(5),inst_17097,inst_17101,null));
var inst_17103 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17102);
var state_17126__$1 = state_17126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17126__$1,(10),inst_17103);
} else {
if((state_val_17127 === (3))){
var inst_17124 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17126__$1,inst_17124);
} else {
if((state_val_17127 === (2))){
var _ = (function (){var statearr_17135 = state_17126;
(statearr_17135[(4)] = cljs.core.cons.call(null,(5),(state_17126[(4)])));

return statearr_17135;
})();
var state_17126__$1 = state_17126;
var statearr_17136_17155 = state_17126__$1;
(statearr_17136_17155[(2)] = null);

(statearr_17136_17155[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (9))){
var _ = (function (){var statearr_17137 = state_17126;
(statearr_17137[(4)] = cljs.core.rest.call(null,(state_17126[(4)])));

return statearr_17137;
})();
var state_17126__$1 = state_17126;
var ex17133 = (state_17126__$1[(2)]);
var statearr_17138_17156 = state_17126__$1;
(statearr_17138_17156[(5)] = ex17133);


var statearr_17139_17157 = state_17126__$1;
(statearr_17139_17157[(1)] = (8));

(statearr_17139_17157[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (5))){
var _ = (function (){var statearr_17140 = state_17126;
(statearr_17140[(4)] = cljs.core.rest.call(null,(state_17126[(4)])));

return statearr_17140;
})();
var state_17126__$1 = state_17126;
var ex17134 = (state_17126__$1[(2)]);
var statearr_17141_17158 = state_17126__$1;
(statearr_17141_17158[(5)] = ex17134);


if((ex17134 instanceof Error)){
var statearr_17142_17159 = state_17126__$1;
(statearr_17142_17159[(1)] = (4));

(statearr_17142_17159[(5)] = null);

} else {
throw ex17134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (10))){
var inst_17105 = (state_17126[(2)]);
var inst_17106 = fluree.db.util.async.throw_err.call(null,inst_17105);
var _ = (function (){var statearr_17143 = state_17126;
(statearr_17143[(4)] = cljs.core.rest.call(null,(state_17126[(4)])));

return statearr_17143;
})();
var state_17126__$1 = state_17126;
var statearr_17144_17160 = state_17126__$1;
(statearr_17144_17160[(2)] = inst_17106);

(statearr_17144_17160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (8))){
var inst_17091 = (state_17126[(2)]);
var state_17126__$1 = (function (){var statearr_17145 = state_17126;
(statearr_17145[(7)] = inst_17091);

return statearr_17145;
})();
var statearr_17146_17161 = state_17126__$1;
(statearr_17146_17161[(2)] = null);

(statearr_17146_17161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0 = (function (){
var statearr_17147 = [null,null,null,null,null,null,null,null];
(statearr_17147[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2746__auto__);

(statearr_17147[(1)] = (1));

return statearr_17147;
});
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1 = (function (state_17126){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17148){var ex__2749__auto__ = e17148;
var statearr_17149_17162 = state_17126;
(statearr_17149_17162[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17126[(4)]))){
var statearr_17150_17163 = state_17126;
(statearr_17150_17163[(1)] = cljs.core.first.call(null,(state_17126[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17164 = state_17126;
state_17126 = G__17164;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = function(state_17126){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1.call(this,state_17126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17151 = f__2769__auto__.call(null);
(statearr_17151[(6)] = c__2768__auto__);

return statearr_17151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
