// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14965 = match;
var p1 = cljs.core.nth.call(null,vec__14965,(0),null);
var p2 = cljs.core.nth.call(null,vec__14965,(1),null);
var p3 = cljs.core.nth.call(null,vec__14965,(2),null);
var p4 = cljs.core.nth.call(null,vec__14965,(3),null);
var op = cljs.core.nth.call(null,vec__14965,(4),null);
var m = cljs.core.nth.call(null,vec__14965,(5),null);
var G__14968 = idx;
var G__14968__$1 = (((G__14968 instanceof cljs.core.Keyword))?G__14968.fqn:null);
switch (G__14968__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate.call(null,db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14968__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14970 = idx;
var G__14970__$1 = (((G__14970 instanceof cljs.core.Keyword))?G__14970.fqn:null);
switch (G__14970__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14970__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14972 = idx;
var G__14972__$1 = (((G__14972 instanceof cljs.core.Keyword))?G__14972.fqn:null);
switch (G__14972__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14972__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.call(null);
if(cljs.core.not.call(null,id)){
cljs.core.async.close_BANG_.call(null,out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_.call(null,id)){
cljs.core.async.pipe.call(null,fluree.db.dbproto._subid.call(null,db,id),out);
} else {
cljs.core.async.put_BANG_.call(null,out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15012){
var state_val_15013 = (state_15012[(1)]);
if((state_val_15013 === (7))){
var inst_14989 = (state_15012[(7)]);
var inst_14996 = (state_15012[(2)]);
var inst_14997 = fluree.db.util.async.throw_err.call(null,inst_14996);
var state_15012__$1 = (function (){var statearr_15014 = state_15012;
(statearr_15014[(8)] = inst_14997);

return statearr_15014;
})();
if(cljs.core.truth_(inst_14989)){
var statearr_15015_15039 = state_15012__$1;
(statearr_15015_15039[(1)] = (8));

} else {
var statearr_15016_15040 = state_15012__$1;
(statearr_15016_15040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (1))){
var state_15012__$1 = state_15012;
var statearr_15017_15041 = state_15012__$1;
(statearr_15017_15041[(2)] = null);

(statearr_15017_15041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (4))){
var inst_14974 = (state_15012[(2)]);
var state_15012__$1 = state_15012;
var statearr_15018_15042 = state_15012__$1;
(statearr_15018_15042[(2)] = inst_14974);

(statearr_15018_15042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (13))){
var inst_15004 = (state_15012[(2)]);
var state_15012__$1 = state_15012;
var statearr_15019_15043 = state_15012__$1;
(statearr_15019_15043[(2)] = inst_15004);

(statearr_15019_15043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (6))){
var inst_14986 = (state_15012[(9)]);
var inst_14992 = (state_15012[(2)]);
var inst_14993 = fluree.db.util.async.throw_err.call(null,inst_14992);
var inst_14994 = fluree.db.query.range.resolve_subid.call(null,db,inst_14986);
var state_15012__$1 = (function (){var statearr_15020 = state_15012;
(statearr_15020[(10)] = inst_14993);

return statearr_15020;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15012__$1,(7),inst_14994);
} else {
if((state_val_15013 === (3))){
var inst_15010 = (state_15012[(2)]);
var state_15012__$1 = state_15012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15012__$1,inst_15010);
} else {
if((state_val_15013 === (12))){
var state_15012__$1 = state_15012;
var statearr_15021_15044 = state_15012__$1;
(statearr_15021_15044[(2)] = (2147483647));

(statearr_15021_15044[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (2))){
var _ = (function (){var statearr_15022 = state_15012;
(statearr_15022[(4)] = cljs.core.cons.call(null,(5),(state_15012[(4)])));

return statearr_15022;
})();
var inst_14983 = parts;
var inst_14984 = cljs.core.nth.call(null,inst_14983,(0),null);
var inst_14985 = cljs.core.nth.call(null,inst_14983,(1),null);
var inst_14986 = cljs.core.nth.call(null,inst_14983,(2),null);
var inst_14987 = cljs.core.nth.call(null,inst_14983,(3),null);
var inst_14988 = cljs.core.nth.call(null,inst_14983,(4),null);
var inst_14989 = cljs.core.nth.call(null,inst_14983,(5),null);
var inst_14990 = fluree.db.query.range.resolve_subid.call(null,db,inst_14984);
var state_15012__$1 = (function (){var statearr_15023 = state_15012;
(statearr_15023[(11)] = inst_14987);

(statearr_15023[(7)] = inst_14989);

(statearr_15023[(12)] = inst_14988);

(statearr_15023[(13)] = inst_14985);

(statearr_15023[(9)] = inst_14986);

return statearr_15023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15012__$1,(6),inst_14990);
} else {
if((state_val_15013 === (11))){
var state_15012__$1 = state_15012;
var statearr_15025_15045 = state_15012__$1;
(statearr_15025_15045[(2)] = (-2147483647));

(statearr_15025_15045[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (9))){
var inst_15000 = (cljs.core._GT__EQ_ === test);
var state_15012__$1 = state_15012;
if(cljs.core.truth_(inst_15000)){
var statearr_15026_15046 = state_15012__$1;
(statearr_15026_15046[(1)] = (11));

} else {
var statearr_15027_15047 = state_15012__$1;
(statearr_15027_15047[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (5))){
var _ = (function (){var statearr_15028 = state_15012;
(statearr_15028[(4)] = cljs.core.rest.call(null,(state_15012[(4)])));

return statearr_15028;
})();
var state_15012__$1 = state_15012;
var ex15024 = (state_15012__$1[(2)]);
var statearr_15029_15048 = state_15012__$1;
(statearr_15029_15048[(5)] = ex15024);


if((ex15024 instanceof Error)){
var statearr_15030_15049 = state_15012__$1;
(statearr_15030_15049[(1)] = (4));

(statearr_15030_15049[(5)] = null);

} else {
throw ex15024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (10))){
var inst_14987 = (state_15012[(11)]);
var inst_14988 = (state_15012[(12)]);
var inst_14997 = (state_15012[(8)]);
var inst_14985 = (state_15012[(13)]);
var inst_14993 = (state_15012[(10)]);
var inst_15006 = (state_15012[(2)]);
var inst_15007 = fluree.db.flake.__GT_Flake.call(null,inst_14993,inst_14985,inst_14997,inst_14987,inst_14988,inst_15006);
var _ = (function (){var statearr_15031 = state_15012;
(statearr_15031[(4)] = cljs.core.rest.call(null,(state_15012[(4)])));

return statearr_15031;
})();
var state_15012__$1 = state_15012;
var statearr_15032_15050 = state_15012__$1;
(statearr_15032_15050[(2)] = inst_15007);

(statearr_15032_15050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15013 === (8))){
var inst_14989 = (state_15012[(7)]);
var state_15012__$1 = state_15012;
var statearr_15033_15051 = state_15012__$1;
(statearr_15033_15051[(2)] = inst_14989);

(statearr_15033_15051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0 = (function (){
var statearr_15034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15034[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__);

(statearr_15034[(1)] = (1));

return statearr_15034;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1 = (function (state_15012){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15035){var ex__2749__auto__ = e15035;
var statearr_15036_15052 = state_15012;
(statearr_15036_15052[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15012[(4)]))){
var statearr_15037_15053 = state_15012;
(statearr_15037_15053[(1)] = cljs.core.first.call(null,(state_15012[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15054 = state_15012;
state_15012 = G__15054;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__ = function(state_15012){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1.call(this,state_15012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15038 = f__2769__auto__.call(null);
(statearr_15038[(6)] = c__2768__auto__);

return statearr_15038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_.call(null,node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_.call(null,node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not.call(null,(function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__15055){
var map__15056 = p__15055;
var map__15056__$1 = cljs.core.__destructure_map.call(null,map__15056);
var subject_fn = cljs.core.get.call(null,map__15056__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.call(null,map__15056__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.call(null,map__15056__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__15057 = cljs.core.PersistentVector.EMPTY;
var G__15057__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.call(null,G__15057,cljs.core.filter.call(null,(function (f){
return subject_fn.call(null,fluree.db.flake.s.call(null,f));
}))):G__15057);
var G__15057__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.call(null,G__15057__$1,cljs.core.filter.call(null,(function (f){
return predicate_fn.call(null,fluree.db.flake.p.call(null,f));
}))):G__15057__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.call(null,G__15057__$2,cljs.core.filter.call(null,(function (f){
return object_fn.call(null,fluree.db.flake.o.call(null,f));
})));
} else {
return G__15057__$2;
}
})();
return cljs.core.apply.call(null,cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__15058){
var map__15059 = p__15058;
var map__15059__$1 = cljs.core.__destructure_map.call(null,map__15059);
var opts = map__15059__$1;
var start_flake = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.call(null,map__15059__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.call(null,(function (flakes){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter.call(null,opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__15060,root,novelty,error_ch,p__15061){
var map__15062 = p__15060;
var map__15062__$1 = cljs.core.__destructure_map.call(null,map__15062);
var conn = map__15062__$1;
var async_cache = cljs.core.get.call(null,map__15062__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__15063 = p__15061;
var map__15063__$1 = cljs.core.__destructure_map.call(null,map__15063);
var opts = map__15063__$1;
var from_t = cljs.core.get.call(null,map__15063__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.call(null,map__15063__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.call(null,map__15063__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__15063__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,start_flake,end_flake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes.call(null,opts);
return fluree.db.index.tree_chan.call(null,resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.call(null,f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15094){
var state_val_15095 = (state_15094[(1)]);
if((state_val_15095 === (7))){
var inst_15077 = (state_15094[(7)]);
var state_15094__$1 = state_15094;
var statearr_15096_15120 = state_15094__$1;
(statearr_15096_15120[(2)] = inst_15077);

(statearr_15096_15120[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (1))){
var state_15094__$1 = state_15094;
var statearr_15097_15121 = state_15094__$1;
(statearr_15097_15121[(2)] = null);

(statearr_15097_15121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (4))){
var inst_15064 = (state_15094[(2)]);
var inst_15065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15066 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_15067 = (new cljs.core.PersistentVector(null,3,(5),inst_15065,inst_15066,null));
var inst_15068 = cljs.core.select_keys.call(null,db,inst_15067);
var inst_15069 = fluree.db.util.log.error.call(null,inst_15064,"Error authorizing flake in ledger",inst_15068);
var state_15094__$1 = (function (){var statearr_15099 = state_15094;
(statearr_15099[(8)] = inst_15069);

return statearr_15099;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15094__$1,(5),error_ch,inst_15064);
} else {
if((state_val_15095 === (13))){
var inst_15089 = (state_15094[(2)]);
var _ = (function (){var statearr_15100 = state_15094;
(statearr_15100[(4)] = cljs.core.rest.call(null,(state_15094[(4)])));

return statearr_15100;
})();
var state_15094__$1 = state_15094;
var statearr_15101_15122 = state_15094__$1;
(statearr_15101_15122[(2)] = inst_15089);

(statearr_15101_15122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (6))){
var _ = (function (){var statearr_15102 = state_15094;
(statearr_15102[(4)] = cljs.core.rest.call(null,(state_15094[(4)])));

return statearr_15102;
})();
var state_15094__$1 = state_15094;
var ex15098 = (state_15094__$1[(2)]);
var statearr_15103_15123 = state_15094__$1;
(statearr_15103_15123[(5)] = ex15098);


var statearr_15104_15124 = state_15094__$1;
(statearr_15104_15124[(1)] = (4));

(statearr_15104_15124[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (3))){
var inst_15092 = (state_15094[(2)]);
var state_15094__$1 = state_15094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15094__$1,inst_15092);
} else {
if((state_val_15095 === (12))){
var state_15094__$1 = state_15094;
var statearr_15105_15125 = state_15094__$1;
(statearr_15105_15125[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15105_15125[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (2))){
var inst_15077 = (state_15094[(7)]);
var _ = (function (){var statearr_15106 = state_15094;
(statearr_15106[(4)] = cljs.core.cons.call(null,(6),(state_15094[(4)])));

return statearr_15106;
})();
var inst_15077__$1 = fluree.db.util.schema.is_schema_flake_QMARK_.call(null,flake);
var state_15094__$1 = (function (){var statearr_15107 = state_15094;
(statearr_15107[(7)] = inst_15077__$1);

return statearr_15107;
})();
if(inst_15077__$1){
var statearr_15108_15126 = state_15094__$1;
(statearr_15108_15126[(1)] = (7));

} else {
var statearr_15109_15127 = state_15094__$1;
(statearr_15109_15127[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (11))){
var state_15094__$1 = state_15094;
var statearr_15110_15128 = state_15094__$1;
(statearr_15110_15128[(2)] = flake);

(statearr_15110_15128[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (9))){
var inst_15085 = (state_15094[(2)]);
var state_15094__$1 = state_15094;
if(cljs.core.truth_(inst_15085)){
var statearr_15111_15129 = state_15094__$1;
(statearr_15111_15129[(1)] = (11));

} else {
var statearr_15112_15130 = state_15094__$1;
(statearr_15112_15130[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (5))){
var inst_15071 = (state_15094[(2)]);
var state_15094__$1 = state_15094;
var statearr_15113_15131 = state_15094__$1;
(statearr_15113_15131[(2)] = inst_15071);

(statearr_15113_15131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (10))){
var inst_15082 = (state_15094[(2)]);
var inst_15083 = fluree.db.util.async.throw_err.call(null,inst_15082);
var state_15094__$1 = state_15094;
var statearr_15114_15132 = state_15094__$1;
(statearr_15114_15132[(2)] = inst_15083);

(statearr_15114_15132[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15095 === (8))){
var inst_15080 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,flake);
var state_15094__$1 = state_15094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15094__$1,(10),inst_15080);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0 = (function (){
var statearr_15115 = [null,null,null,null,null,null,null,null,null];
(statearr_15115[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__);

(statearr_15115[(1)] = (1));

return statearr_15115;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1 = (function (state_15094){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15116){var ex__2749__auto__ = e15116;
var statearr_15117_15133 = state_15094;
(statearr_15117_15133[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15094[(4)]))){
var statearr_15118_15134 = state_15094;
(statearr_15118_15134[(1)] = cljs.core.first.call(null,(state_15094[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15135 = state_15094;
state_15094 = G__15135;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__ = function(state_15094){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1.call(this,state_15094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15119 = f__2769__auto__.call(null);
(statearr_15119[(6)] = c__2768__auto__);

return statearr_15119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.call(null,(function() { 
var G__15136__delegate = function (fs){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15136 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15137__i = 0, G__15137__a = new Array(arguments.length -  0);
while (G__15137__i < G__15137__a.length) {G__15137__a[G__15137__i] = arguments[G__15137__i + 0]; ++G__15137__i;}
  fs = new cljs.core.IndexedSeq(G__15137__a,0,null);
} 
return G__15136__delegate.call(this,fs);};
G__15136.cljs$lang$maxFixedArity = 0;
G__15136.cljs$lang$applyTo = (function (arglist__15138){
var fs = cljs.core.seq(arglist__15138);
return G__15136__delegate(fs);
});
G__15136.cljs$core$IFn$_invoke$arity$variadic = G__15136__delegate;
return G__15136;
})()
,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15139,start,end,error_ch,flake_slices){
var map__15140 = p__15139;
var map__15140__$1 = cljs.core.__destructure_map.call(null,map__15140);
var db = map__15140__$1;
var permissions = cljs.core.get.call(null,map__15140__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15141 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.call(null,fluree.db.flake.s)], null);
var G__15141__$1 = (cljs.core.truth_(offset)?cljs.core.conj.call(null,G__15141,cljs.core.drop.call(null,offset)):G__15141);
var G__15141__$2 = (cljs.core.truth_(limit)?cljs.core.conj.call(null,G__15141__$1,cljs.core.take.call(null,limit)):G__15141__$1);
return cljs.core.conj.call(null,G__15141__$2,cljs.core.cat);

})();
return cljs.core.apply.call(null,cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15142 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15142__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.call(null,G__15142,fluree.db.query.range.filter_subject_page.call(null,limit,offset)):G__15142);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.call(null,G__15142__$1,cljs.core.take.call(null,flake_limit));
} else {
return G__15142__$1;
}
})();
var page_xf = cljs.core.apply.call(null,cljs.core.comp,page_xfs);
return cljs.core.async.transduce.call(null,page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15143,error_ch,p__15144){
var map__15145 = p__15143;
var map__15145__$1 = cljs.core.__destructure_map.call(null,map__15145);
var db = map__15145__$1;
var conn = cljs.core.get.call(null,map__15145__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15146 = p__15144;
var map__15146__$1 = cljs.core.__destructure_map.call(null,map__15146);
var opts = map__15146__$1;
var idx = cljs.core.get.call(null,map__15146__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.call(null,map__15146__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__15146__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.call(null,map__15146__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__15146__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.call(null,map__15146__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.call(null,db,idx);
var idx_cmp = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page.call(null,limit,offset,flake_limit,fluree.db.query.range.filter_authorized.call(null,db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices.call(null,conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15147 = cljs.core.identical_QMARK_;
var expr__15148 = test;
if(cljs.core.truth_(pred__15147.call(null,cljs.core._EQ_,expr__15148))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15147.call(null,cljs.core._LT_,expr__15148))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__15147.call(null,cljs.core._LT__EQ_,expr__15148))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15147.call(null,cljs.core._GT_,expr__15148))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__15147.call(null,cljs.core._GT__EQ_,expr__15148))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15148)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15151 = arguments.length;
switch (G__15151) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15152 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__15152,(0),null);
var start_match = cljs.core.nth.call(null,vec__15152,(1),null);
var end_test = cljs.core.nth.call(null,vec__15152,(2),null);
var end_match = cljs.core.nth.call(null,vec__15152,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15155,idx,start_test,start_match,end_test,end_match,opts){
var map__15156 = p__15155;
var map__15156__$1 = cljs.core.__destructure_map.call(null,map__15156);
var db = map__15156__$1;
var t = cljs.core.get.call(null,map__15156__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15157 = opts;
var map__15157__$1 = cljs.core.__destructure_map.call(null,map__15157);
var limit = cljs.core.get.call(null,map__15157__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.call(null,map__15157__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.call(null,map__15157__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15219){
var state_val_15220 = (state_15219[(1)]);
if((state_val_15220 === (7))){
var inst_15176 = (state_15219[(7)]);
var inst_15167 = (state_15219[(8)]);
var inst_15172 = (state_15219[(9)]);
var inst_15170 = (state_15219[(2)]);
var inst_15171 = fluree.db.util.async.throw_err.call(null,inst_15170);
var inst_15172__$1 = cljs.core.async.chan.call(null);
var inst_15173 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15174 = [idx,from_t,to_t,start_test,inst_15167,end_test,inst_15171,limit];
var inst_15175 = cljs.core.PersistentHashMap.fromArrays(inst_15173,inst_15174);
var inst_15176__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_15172__$1,inst_15175);
var inst_15184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15185 = [inst_15172__$1,inst_15176__$1];
var inst_15186 = (new cljs.core.PersistentVector(null,2,(5),inst_15184,inst_15185,null));
var state_15219__$1 = (function (){var statearr_15221 = state_15219;
(statearr_15221[(7)] = inst_15176__$1);

(statearr_15221[(9)] = inst_15172__$1);

return statearr_15221;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15219__$1,(8),inst_15186);
} else {
if((state_val_15220 === (1))){
var state_15219__$1 = state_15219;
var statearr_15222_15251 = state_15219__$1;
(statearr_15222_15251[(2)] = null);

(statearr_15222_15251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (4))){
var inst_15158 = (state_15219[(2)]);
var state_15219__$1 = state_15219;
var statearr_15223_15252 = state_15219__$1;
(statearr_15223_15252[(2)] = inst_15158);

(statearr_15223_15252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (15))){
var inst_15189 = (state_15219[(10)]);
var state_15219__$1 = state_15219;
var statearr_15224_15253 = state_15219__$1;
(statearr_15224_15253[(2)] = inst_15189);

(statearr_15224_15253[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (13))){
var inst_15190 = (state_15219[(11)]);
var inst_15206 = cljs.core._EQ_.call(null,inst_15190,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15219__$1 = state_15219;
if(inst_15206){
var statearr_15225_15254 = state_15219__$1;
(statearr_15225_15254[(1)] = (15));

} else {
var statearr_15226_15255 = state_15219__$1;
(statearr_15226_15255[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (6))){
var inst_15166 = (state_15219[(2)]);
var inst_15167 = fluree.db.util.async.throw_err.call(null,inst_15166);
var inst_15168 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,end_parts);
var state_15219__$1 = (function (){var statearr_15227 = state_15219;
(statearr_15227[(8)] = inst_15167);

return statearr_15227;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15219__$1,(7),inst_15168);
} else {
if((state_val_15220 === (17))){
var inst_15210 = (state_15219[(2)]);
var state_15219__$1 = state_15219;
var statearr_15228_15256 = state_15219__$1;
(statearr_15228_15256[(2)] = inst_15210);

(statearr_15228_15256[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (3))){
var inst_15217 = (state_15219[(2)]);
var state_15219__$1 = state_15219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15219__$1,inst_15217);
} else {
if((state_val_15220 === (12))){
var inst_15188 = (state_15219[(12)]);
var inst_15204 = cljs.core.nth.call(null,inst_15188,(0),null);
var state_15219__$1 = state_15219;
var statearr_15229_15257 = state_15219__$1;
(statearr_15229_15257[(2)] = inst_15204);

(statearr_15229_15257[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (2))){
var _ = (function (){var statearr_15230 = state_15219;
(statearr_15230[(4)] = cljs.core.cons.call(null,(5),(state_15219[(4)])));

return statearr_15230;
})();
var inst_15164 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,start_parts);
var state_15219__$1 = state_15219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15219__$1,(6),inst_15164);
} else {
if((state_val_15220 === (11))){
var inst_15214 = (state_15219[(2)]);
var _ = (function (){var statearr_15232 = state_15219;
(statearr_15232[(4)] = cljs.core.rest.call(null,(state_15219[(4)])));

return statearr_15232;
})();
var state_15219__$1 = state_15219;
var statearr_15233_15258 = state_15219__$1;
(statearr_15233_15258[(2)] = inst_15214);

(statearr_15233_15258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (9))){
var inst_15188 = (state_15219[(12)]);
var inst_15196 = cljs.core.nth.call(null,inst_15188,(0),null);
var inst_15197 = (function(){throw inst_15196})();
var state_15219__$1 = state_15219;
var statearr_15234_15259 = state_15219__$1;
(statearr_15234_15259[(2)] = inst_15197);

(statearr_15234_15259[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (5))){
var _ = (function (){var statearr_15235 = state_15219;
(statearr_15235[(4)] = cljs.core.rest.call(null,(state_15219[(4)])));

return statearr_15235;
})();
var state_15219__$1 = state_15219;
var ex15231 = (state_15219__$1[(2)]);
var statearr_15236_15260 = state_15219__$1;
(statearr_15236_15260[(5)] = ex15231);


if((ex15231 instanceof Error)){
var statearr_15237_15261 = state_15219__$1;
(statearr_15237_15261[(1)] = (4));

(statearr_15237_15261[(5)] = null);

} else {
throw ex15231;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (14))){
var inst_15212 = (state_15219[(2)]);
var state_15219__$1 = state_15219;
var statearr_15238_15262 = state_15219__$1;
(statearr_15238_15262[(2)] = inst_15212);

(statearr_15238_15262[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (16))){
var state_15219__$1 = state_15219;
var statearr_15239_15263 = state_15219__$1;
(statearr_15239_15263[(2)] = null);

(statearr_15239_15263[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (10))){
var inst_15176 = (state_15219[(7)]);
var inst_15190 = (state_15219[(11)]);
var inst_15199 = cljs.core._EQ_.call(null,inst_15190,inst_15176);
var state_15219__$1 = state_15219;
if(inst_15199){
var statearr_15240_15264 = state_15219__$1;
(statearr_15240_15264[(1)] = (12));

} else {
var statearr_15241_15265 = state_15219__$1;
(statearr_15241_15265[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15220 === (8))){
var inst_15188 = (state_15219[(12)]);
var inst_15190 = (state_15219[(11)]);
var inst_15172 = (state_15219[(9)]);
var inst_15188__$1 = (state_15219[(2)]);
var inst_15189 = cljs.core.nth.call(null,inst_15188__$1,(0),null);
var inst_15190__$1 = cljs.core.nth.call(null,inst_15188__$1,(1),null);
var inst_15191 = cljs.core._EQ_.call(null,inst_15190__$1,inst_15172);
var state_15219__$1 = (function (){var statearr_15242 = state_15219;
(statearr_15242[(12)] = inst_15188__$1);

(statearr_15242[(10)] = inst_15189);

(statearr_15242[(11)] = inst_15190__$1);

return statearr_15242;
})();
if(inst_15191){
var statearr_15243_15266 = state_15219__$1;
(statearr_15243_15266[(1)] = (9));

} else {
var statearr_15244_15267 = state_15219__$1;
(statearr_15244_15267[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15245 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15245[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15245[(1)] = (1));

return statearr_15245;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15219){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15246){var ex__2749__auto__ = e15246;
var statearr_15247_15268 = state_15219;
(statearr_15247_15268[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15219[(4)]))){
var statearr_15248_15269 = state_15219;
(statearr_15248_15269[(1)] = cljs.core.first.call(null,(state_15219[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15270 = state_15219;
state_15219 = G__15270;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15219){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15249 = f__2769__auto__.call(null);
(statearr_15249[(6)] = c__2768__auto__);

return statearr_15249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15272 = arguments.length;
switch (G__15272) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15273 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__15273,(0),null);
var start_match = cljs.core.nth.call(null,vec__15273,(1),null);
var end_test = cljs.core.nth.call(null,vec__15273,(2),null);
var end_match = cljs.core.nth.call(null,vec__15273,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15276,idx,start_test,start_match,end_test,end_match,p__15277){
var map__15278 = p__15276;
var map__15278__$1 = cljs.core.__destructure_map.call(null,map__15278);
var db = map__15278__$1;
var permissions = cljs.core.get.call(null,map__15278__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.call(null,map__15278__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15279 = p__15277;
var map__15279__$1 = cljs.core.__destructure_map.call(null,map__15279);
var opts = map__15279__$1;
var object_fn = cljs.core.get.call(null,map__15279__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15280 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var s1 = cljs.core.nth.call(null,vec__15280,(0),null);
var p1 = cljs.core.nth.call(null,vec__15280,(1),null);
var o1 = cljs.core.nth.call(null,vec__15280,(2),null);
var t1 = cljs.core.nth.call(null,vec__15280,(3),null);
var op1 = cljs.core.nth.call(null,vec__15280,(4),null);
var m1 = cljs.core.nth.call(null,vec__15280,(5),null);
var vec__15283 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var s2 = cljs.core.nth.call(null,vec__15283,(0),null);
var p2 = cljs.core.nth.call(null,vec__15283,(1),null);
var o2 = cljs.core.nth.call(null,vec__15283,(2),null);
var t2 = cljs.core.nth.call(null,vec__15283,(3),null);
var op2 = cljs.core.nth.call(null,vec__15283,(4),null);
var m2 = cljs.core.nth.call(null,vec__15283,(5),null);
var vec__15286 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_.call(null,o1))?o1:((cljs.core.boolean_QMARK_.call(null,o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.call(null,o,bool);
})], null);
}
})();
var vec__15289 = cljs.core.nth.call(null,vec__15286,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__15289,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__15289,(1),null);
var object_fn__$1 = cljs.core.nth.call(null,vec__15286,(1),null);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15357){
var state_val_15358 = (state_15357[(1)]);
if((state_val_15358 === (7))){
var inst_15304 = (state_15357[(7)]);
var inst_15312 = (state_15357[(8)]);
var inst_15314 = (state_15357[(9)]);
var inst_15310 = (state_15357[(2)]);
var inst_15311 = fluree.db.util.async.throw_err.call(null,inst_15310);
var inst_15312__$1 = cljs.core.async.chan.call(null);
var inst_15313 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15304,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15311,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1);
var inst_15314__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_15312__$1,inst_15313);
var inst_15322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15323 = [inst_15312__$1,inst_15314__$1];
var inst_15324 = (new cljs.core.PersistentVector(null,2,(5),inst_15322,inst_15323,null));
var state_15357__$1 = (function (){var statearr_15359 = state_15357;
(statearr_15359[(8)] = inst_15312__$1);

(statearr_15359[(9)] = inst_15314__$1);

return statearr_15359;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15357__$1,(8),inst_15324);
} else {
if((state_val_15358 === (1))){
var state_15357__$1 = state_15357;
var statearr_15360_15389 = state_15357__$1;
(statearr_15360_15389[(2)] = null);

(statearr_15360_15389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (4))){
var inst_15292 = (state_15357[(2)]);
var state_15357__$1 = state_15357;
var statearr_15361_15390 = state_15357__$1;
(statearr_15361_15390[(2)] = inst_15292);

(statearr_15361_15390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (15))){
var inst_15327 = (state_15357[(10)]);
var state_15357__$1 = state_15357;
var statearr_15362_15391 = state_15357__$1;
(statearr_15362_15391[(2)] = inst_15327);

(statearr_15362_15391[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (13))){
var inst_15328 = (state_15357[(11)]);
var inst_15344 = cljs.core._EQ_.call(null,inst_15328,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15357__$1 = state_15357;
if(inst_15344){
var statearr_15363_15392 = state_15357__$1;
(statearr_15363_15392[(1)] = (15));

} else {
var statearr_15364_15393 = state_15357__$1;
(statearr_15364_15393[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (6))){
var inst_15303 = (state_15357[(2)]);
var inst_15304 = fluree.db.util.async.throw_err.call(null,inst_15303);
var inst_15305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15306 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15307 = (new cljs.core.PersistentVector(null,6,(5),inst_15305,inst_15306,null));
var inst_15308 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,inst_15307);
var state_15357__$1 = (function (){var statearr_15365 = state_15357;
(statearr_15365[(7)] = inst_15304);

return statearr_15365;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15357__$1,(7),inst_15308);
} else {
if((state_val_15358 === (17))){
var inst_15348 = (state_15357[(2)]);
var state_15357__$1 = state_15357;
var statearr_15366_15394 = state_15357__$1;
(statearr_15366_15394[(2)] = inst_15348);

(statearr_15366_15394[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (3))){
var inst_15355 = (state_15357[(2)]);
var state_15357__$1 = state_15357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15357__$1,inst_15355);
} else {
if((state_val_15358 === (12))){
var inst_15326 = (state_15357[(12)]);
var inst_15342 = cljs.core.nth.call(null,inst_15326,(0),null);
var state_15357__$1 = state_15357;
var statearr_15367_15395 = state_15357__$1;
(statearr_15367_15395[(2)] = inst_15342);

(statearr_15367_15395[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (2))){
var _ = (function (){var statearr_15368 = state_15357;
(statearr_15368[(4)] = cljs.core.cons.call(null,(5),(state_15357[(4)])));

return statearr_15368;
})();
var inst_15298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15299 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15300 = (new cljs.core.PersistentVector(null,6,(5),inst_15298,inst_15299,null));
var inst_15301 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,inst_15300);
var state_15357__$1 = state_15357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15357__$1,(6),inst_15301);
} else {
if((state_val_15358 === (11))){
var inst_15352 = (state_15357[(2)]);
var _ = (function (){var statearr_15370 = state_15357;
(statearr_15370[(4)] = cljs.core.rest.call(null,(state_15357[(4)])));

return statearr_15370;
})();
var state_15357__$1 = state_15357;
var statearr_15371_15396 = state_15357__$1;
(statearr_15371_15396[(2)] = inst_15352);

(statearr_15371_15396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (9))){
var inst_15326 = (state_15357[(12)]);
var inst_15334 = cljs.core.nth.call(null,inst_15326,(0),null);
var inst_15335 = (function(){throw inst_15334})();
var state_15357__$1 = state_15357;
var statearr_15372_15397 = state_15357__$1;
(statearr_15372_15397[(2)] = inst_15335);

(statearr_15372_15397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (5))){
var _ = (function (){var statearr_15373 = state_15357;
(statearr_15373[(4)] = cljs.core.rest.call(null,(state_15357[(4)])));

return statearr_15373;
})();
var state_15357__$1 = state_15357;
var ex15369 = (state_15357__$1[(2)]);
var statearr_15374_15398 = state_15357__$1;
(statearr_15374_15398[(5)] = ex15369);


if((ex15369 instanceof Error)){
var statearr_15375_15399 = state_15357__$1;
(statearr_15375_15399[(1)] = (4));

(statearr_15375_15399[(5)] = null);

} else {
throw ex15369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (14))){
var inst_15350 = (state_15357[(2)]);
var state_15357__$1 = state_15357;
var statearr_15376_15400 = state_15357__$1;
(statearr_15376_15400[(2)] = inst_15350);

(statearr_15376_15400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (16))){
var state_15357__$1 = state_15357;
var statearr_15377_15401 = state_15357__$1;
(statearr_15377_15401[(2)] = null);

(statearr_15377_15401[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (10))){
var inst_15314 = (state_15357[(9)]);
var inst_15328 = (state_15357[(11)]);
var inst_15337 = cljs.core._EQ_.call(null,inst_15328,inst_15314);
var state_15357__$1 = state_15357;
if(inst_15337){
var statearr_15378_15402 = state_15357__$1;
(statearr_15378_15402[(1)] = (12));

} else {
var statearr_15379_15403 = state_15357__$1;
(statearr_15379_15403[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15358 === (8))){
var inst_15326 = (state_15357[(12)]);
var inst_15312 = (state_15357[(8)]);
var inst_15328 = (state_15357[(11)]);
var inst_15326__$1 = (state_15357[(2)]);
var inst_15327 = cljs.core.nth.call(null,inst_15326__$1,(0),null);
var inst_15328__$1 = cljs.core.nth.call(null,inst_15326__$1,(1),null);
var inst_15329 = cljs.core._EQ_.call(null,inst_15328__$1,inst_15312);
var state_15357__$1 = (function (){var statearr_15380 = state_15357;
(statearr_15380[(12)] = inst_15326__$1);

(statearr_15380[(10)] = inst_15327);

(statearr_15380[(11)] = inst_15328__$1);

return statearr_15380;
})();
if(inst_15329){
var statearr_15381_15404 = state_15357__$1;
(statearr_15381_15404[(1)] = (9));

} else {
var statearr_15382_15405 = state_15357__$1;
(statearr_15382_15405[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15383 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15383[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15383[(1)] = (1));

return statearr_15383;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15357){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15384){var ex__2749__auto__ = e15384;
var statearr_15385_15406 = state_15357;
(statearr_15385_15406[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15357[(4)]))){
var statearr_15386_15407 = state_15357;
(statearr_15386_15407[(1)] = cljs.core.first.call(null,(state_15357[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15408 = state_15357;
state_15357 = G__15408;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15357){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15387 = f__2769__auto__.call(null);
(statearr_15387[(6)] = c__2768__auto__);

return statearr_15387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o.call(null,f))) && ((fluree.db.flake.o.call(null,f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15464){
var state_val_15465 = (state_15464[(1)]);
if((state_val_15465 === (7))){
var inst_15438 = (state_15464[(7)]);
var inst_15428 = (state_15464[(8)]);
var inst_15436 = fluree.db.flake.Flake__GT_parts.call(null,inst_15428);
var inst_15437 = cljs.core.nth.call(null,inst_15436,(0),null);
var inst_15438__$1 = cljs.core.nth.call(null,inst_15436,(1),null);
var inst_15439 = cljs.core.nth.call(null,inst_15436,(2),null);
var inst_15440 = cljs.core.nth.call(null,inst_15436,(3),null);
var inst_15441 = cljs.core.nth.call(null,inst_15436,(4),null);
var inst_15442 = cljs.core.nth.call(null,inst_15436,(5),null);
var inst_15443 = fluree.db.dbproto._tag.call(null,db,inst_15439,inst_15438__$1);
var state_15464__$1 = (function (){var statearr_15466 = state_15464;
(statearr_15466[(9)] = inst_15442);

(statearr_15466[(7)] = inst_15438__$1);

(statearr_15466[(10)] = inst_15441);

(statearr_15466[(11)] = inst_15440);

(statearr_15466[(12)] = inst_15437);

return statearr_15466;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15464__$1,(10),inst_15443);
} else {
if((state_val_15465 === (1))){
var inst_15416 = flakes;
var inst_15417 = cljs.core.seq.call(null,inst_15416);
var inst_15418 = cljs.core.first.call(null,inst_15417);
var inst_15419 = cljs.core.next.call(null,inst_15417);
var inst_15420 = cljs.core.PersistentVector.EMPTY;
var inst_15421 = inst_15416;
var inst_15422 = inst_15420;
var state_15464__$1 = (function (){var statearr_15467 = state_15464;
(statearr_15467[(13)] = inst_15418);

(statearr_15467[(14)] = inst_15421);

(statearr_15467[(15)] = inst_15419);

(statearr_15467[(16)] = inst_15422);

return statearr_15467;
})();
var statearr_15468_15486 = state_15464__$1;
(statearr_15468_15486[(2)] = null);

(statearr_15468_15486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (4))){
var inst_15428 = (state_15464[(8)]);
var inst_15431 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15428);
var state_15464__$1 = state_15464;
if(inst_15431){
var statearr_15469_15487 = state_15464__$1;
(statearr_15469_15487[(1)] = (7));

} else {
var statearr_15470_15488 = state_15464__$1;
(statearr_15470_15488[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (6))){
var inst_15460 = (state_15464[(2)]);
var state_15464__$1 = state_15464;
var statearr_15471_15489 = state_15464__$1;
(statearr_15471_15489[(2)] = inst_15460);

(statearr_15471_15489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (3))){
var inst_15462 = (state_15464[(2)]);
var state_15464__$1 = state_15464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15464__$1,inst_15462);
} else {
if((state_val_15465 === (2))){
var inst_15421 = (state_15464[(14)]);
var inst_15428 = (state_15464[(8)]);
var inst_15427 = cljs.core.seq.call(null,inst_15421);
var inst_15428__$1 = cljs.core.first.call(null,inst_15427);
var inst_15429 = cljs.core.next.call(null,inst_15427);
var state_15464__$1 = (function (){var statearr_15472 = state_15464;
(statearr_15472[(17)] = inst_15429);

(statearr_15472[(8)] = inst_15428__$1);

return statearr_15472;
})();
if(cljs.core.truth_(inst_15428__$1)){
var statearr_15473_15490 = state_15464__$1;
(statearr_15473_15490[(1)] = (4));

} else {
var statearr_15474_15491 = state_15464__$1;
(statearr_15474_15491[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (9))){
var inst_15457 = (state_15464[(2)]);
var state_15464__$1 = state_15464;
var statearr_15475_15492 = state_15464__$1;
(statearr_15475_15492[(2)] = inst_15457);

(statearr_15475_15492[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (5))){
var inst_15422 = (state_15464[(16)]);
var state_15464__$1 = state_15464;
var statearr_15476_15493 = state_15464__$1;
(statearr_15476_15493[(2)] = inst_15422);

(statearr_15476_15493[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (10))){
var inst_15442 = (state_15464[(9)]);
var inst_15429 = (state_15464[(17)]);
var inst_15438 = (state_15464[(7)]);
var inst_15422 = (state_15464[(16)]);
var inst_15441 = (state_15464[(10)]);
var inst_15440 = (state_15464[(11)]);
var inst_15437 = (state_15464[(12)]);
var inst_15445 = (state_15464[(2)]);
var inst_15446 = fluree.db.util.async.throw_err.call(null,inst_15445);
var inst_15447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15448 = [inst_15437,inst_15438,inst_15446,inst_15440,inst_15441,inst_15442];
var inst_15449 = (new cljs.core.PersistentVector(null,6,(5),inst_15447,inst_15448,null));
var inst_15450 = fluree.db.flake.parts__GT_Flake.call(null,inst_15449);
var inst_15451 = cljs.core.conj.call(null,inst_15422,inst_15450);
var inst_15421 = inst_15429;
var inst_15422__$1 = inst_15451;
var state_15464__$1 = (function (){var statearr_15477 = state_15464;
(statearr_15477[(14)] = inst_15421);

(statearr_15477[(16)] = inst_15422__$1);

return statearr_15477;
})();
var statearr_15478_15494 = state_15464__$1;
(statearr_15478_15494[(2)] = null);

(statearr_15478_15494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15465 === (8))){
var inst_15429 = (state_15464[(17)]);
var inst_15422 = (state_15464[(16)]);
var inst_15428 = (state_15464[(8)]);
var inst_15454 = cljs.core.conj.call(null,inst_15422,inst_15428);
var inst_15421 = inst_15429;
var inst_15422__$1 = inst_15454;
var state_15464__$1 = (function (){var statearr_15479 = state_15464;
(statearr_15479[(14)] = inst_15421);

(statearr_15479[(16)] = inst_15422__$1);

return statearr_15479;
})();
var statearr_15480_15495 = state_15464__$1;
(statearr_15480_15495[(2)] = null);

(statearr_15480_15495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_15481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15481[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__);

(statearr_15481[(1)] = (1));

return statearr_15481;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1 = (function (state_15464){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15482){var ex__2749__auto__ = e15482;
var statearr_15483_15496 = state_15464;
(statearr_15483_15496[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15464[(4)]))){
var statearr_15484_15497 = state_15464;
(statearr_15484_15497[(1)] = cljs.core.first.call(null,(state_15464[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15498 = state_15464;
state_15464 = G__15498;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = function(state_15464){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1.call(this,state_15464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15485 = f__2769__auto__.call(null);
(statearr_15485[(6)] = c__2768__auto__);

return statearr_15485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15500 = arguments.length;
switch (G__15500) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15682){
var state_val_15683 = (state_15682[(1)]);
if((state_val_15683 === (65))){
var inst_15551 = (state_15682[(7)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15551)){
var statearr_15684_15788 = state_15682__$1;
(statearr_15684_15788[(1)] = (68));

} else {
var statearr_15685_15789 = state_15682__$1;
(statearr_15685_15789[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (70))){
var inst_15661 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15686_15790 = state_15682__$1;
(statearr_15686_15790[(2)] = inst_15661);

(statearr_15686_15790[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (62))){
var inst_15627 = (state_15682[(2)]);
var inst_15628 = fluree.db.util.async.throw_err.call(null,inst_15627);
var inst_15629 = cljs.core.take.call(null,(1),inst_15628);
var state_15682__$1 = state_15682;
var statearr_15687_15791 = state_15682__$1;
(statearr_15687_15791[(2)] = inst_15629);

(statearr_15687_15791[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (74))){
var inst_15677 = (state_15682[(2)]);
var _ = (function (){var statearr_15688 = state_15682;
(statearr_15688[(4)] = cljs.core.rest.call(null,(state_15682[(4)])));

return statearr_15688;
})();
var state_15682__$1 = state_15682;
var statearr_15689_15792 = state_15682__$1;
(statearr_15689_15792[(2)] = inst_15677);

(statearr_15689_15792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (7))){
var state_15682__$1 = state_15682;
var statearr_15690_15793 = state_15682__$1;
(statearr_15690_15793[(2)] = false);

(statearr_15690_15793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (59))){
var inst_15551 = (state_15682[(7)]);
var inst_15621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15622 = [inst_15551];
var inst_15623 = (new cljs.core.PersistentVector(null,1,(5),inst_15621,inst_15622,null));
var inst_15624 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15625 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15623,inst_15624);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(62),inst_15625);
} else {
if((state_val_15683 === (20))){
var state_15682__$1 = state_15682;
var statearr_15691_15794 = state_15682__$1;
(statearr_15691_15794[(2)] = null);

(statearr_15691_15794[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (72))){
var inst_15669 = (state_15682[(8)]);
var inst_15671 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15669);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(75),inst_15671);
} else {
if((state_val_15683 === (58))){
var inst_15619 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15619)){
var statearr_15692_15795 = state_15682__$1;
(statearr_15692_15795[(1)] = (59));

} else {
var statearr_15693_15796 = state_15682__$1;
(statearr_15693_15796[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (60))){
var inst_15512 = (state_15682[(9)]);
var inst_15613 = (state_15682[(10)]);
var inst_15514 = (state_15682[(11)]);
var inst_15511 = (state_15682[(12)]);
var inst_15631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15632 = [inst_15512,inst_15511,null,inst_15514];
var inst_15633 = (new cljs.core.PersistentVector(null,4,(5),inst_15631,inst_15632,null));
var inst_15634 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15613);
var inst_15635 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15633,inst_15634);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(63),inst_15635);
} else {
if((state_val_15683 === (27))){
var inst_15512 = (state_15682[(9)]);
var inst_15514 = (state_15682[(11)]);
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(7)]);
var inst_15563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15564 = [inst_15511,inst_15512,inst_15551,inst_15514];
var inst_15565 = (new cljs.core.PersistentVector(null,4,(5),inst_15563,inst_15564,null));
var inst_15566 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15565,opts);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(30),inst_15566);
} else {
if((state_val_15683 === (1))){
var state_15682__$1 = state_15682;
var statearr_15694_15797 = state_15682__$1;
(statearr_15694_15797[(2)] = null);

(statearr_15694_15797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (69))){
var state_15682__$1 = state_15682;
var statearr_15695_15798 = state_15682__$1;
(statearr_15695_15798[(2)] = null);

(statearr_15695_15798[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (24))){
var inst_15512 = (state_15682[(9)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15512)){
var statearr_15696_15799 = state_15682__$1;
(statearr_15696_15799[(1)] = (31));

} else {
var statearr_15697_15800 = state_15682__$1;
(statearr_15697_15800[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (55))){
var inst_15512 = (state_15682[(9)]);
var inst_15614 = (state_15682[(13)]);
var inst_15613 = (state_15682[(2)]);
var inst_15614__$1 = cljs.core._EQ_.call(null,"_id",inst_15512);
var state_15682__$1 = (function (){var statearr_15698 = state_15682;
(statearr_15698[(10)] = inst_15613);

(statearr_15698[(13)] = inst_15614__$1);

return statearr_15698;
})();
if(inst_15614__$1){
var statearr_15699_15801 = state_15682__$1;
(statearr_15699_15801[(1)] = (56));

} else {
var statearr_15700_15802 = state_15682__$1;
(statearr_15700_15802[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (39))){
var inst_15581 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15701_15803 = state_15682__$1;
(statearr_15701_15803[(2)] = inst_15581);

(statearr_15701_15803[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (46))){
var inst_15605 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15605)){
var statearr_15702_15804 = state_15682__$1;
(statearr_15702_15804[(1)] = (50));

} else {
var statearr_15703_15805 = state_15682__$1;
(statearr_15703_15805[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (4))){
var inst_15501 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15704_15806 = state_15682__$1;
(statearr_15704_15806[(2)] = inst_15501);

(statearr_15704_15806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (54))){
var inst_15512 = (state_15682[(9)]);
var inst_15514 = (state_15682[(11)]);
var inst_15515 = (state_15682[(14)]);
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(7)]);
var inst_15607 = (state_15682[(15)]);
var inst_15510 = (state_15682[(16)]);
var inst_15526 = (state_15682[(17)]);
var inst_15521 = (state_15682[(18)]);
var inst_15611 = (function (){var t = inst_15514;
var temp__5802__auto__ = inst_15607;
var p = inst_15512;
var idx_predicate_QMARK_ = inst_15515;
var o = inst_15551;
var tag_predicate_QMARK_ = inst_15521;
var s = inst_15511;
var o_coerce_QMARK_ = inst_15526;
var vec__15507 = inst_15510;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15682__$1 = state_15682;
var statearr_15705_15807 = state_15682__$1;
(statearr_15705_15807[(2)] = inst_15611);

(statearr_15705_15807[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (15))){
var inst_15513 = (state_15682[(19)]);
var inst_15532 = fluree.db.dbproto._tag_id.call(null,db,inst_15513);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(18),inst_15532);
} else {
if((state_val_15683 === (48))){
var inst_15598 = (state_15682[(20)]);
var state_15682__$1 = state_15682;
var statearr_15706_15808 = state_15682__$1;
(statearr_15706_15808[(2)] = inst_15598);

(statearr_15706_15808[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (50))){
var inst_15607 = (state_15682[(15)]);
var inst_15607__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15682__$1 = (function (){var statearr_15707 = state_15682;
(statearr_15707[(15)] = inst_15607__$1);

return statearr_15707;
})();
if(cljs.core.truth_(inst_15607__$1)){
var statearr_15708_15809 = state_15682__$1;
(statearr_15708_15809[(1)] = (53));

} else {
var statearr_15709_15810 = state_15682__$1;
(statearr_15709_15810[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (75))){
var inst_15673 = (state_15682[(2)]);
var inst_15674 = fluree.db.util.async.throw_err.call(null,inst_15673);
var state_15682__$1 = state_15682;
var statearr_15710_15811 = state_15682__$1;
(statearr_15710_15811[(2)] = inst_15674);

(statearr_15710_15811[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (21))){
var inst_15547 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15711_15812 = state_15682__$1;
(statearr_15711_15812[(2)] = inst_15547);

(statearr_15711_15812[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (31))){
var inst_15574 = (state_15682[(21)]);
var inst_15551 = (state_15682[(7)]);
var inst_15574__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15551);
var state_15682__$1 = (function (){var statearr_15712 = state_15682;
(statearr_15712[(21)] = inst_15574__$1);

return statearr_15712;
})();
if(inst_15574__$1){
var statearr_15713_15813 = state_15682__$1;
(statearr_15713_15813[(1)] = (34));

} else {
var statearr_15714_15814 = state_15682__$1;
(statearr_15714_15814[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (32))){
var inst_15512 = (state_15682[(9)]);
var state_15682__$1 = state_15682;
var statearr_15715_15815 = state_15682__$1;
(statearr_15715_15815[(2)] = inst_15512);

(statearr_15715_15815[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (40))){
var inst_15512 = (state_15682[(9)]);
var inst_15514 = (state_15682[(11)]);
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(7)]);
var inst_15589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15590 = [inst_15512,inst_15551,inst_15511,inst_15514];
var inst_15591 = (new cljs.core.PersistentVector(null,4,(5),inst_15589,inst_15590,null));
var inst_15592 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15591,opts);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(43),inst_15592);
} else {
if((state_val_15683 === (56))){
var inst_15551 = (state_15682[(7)]);
var inst_15616 = cljs.core.int_QMARK_.call(null,inst_15551);
var state_15682__$1 = state_15682;
var statearr_15716_15816 = state_15682__$1;
(statearr_15716_15816[(2)] = inst_15616);

(statearr_15716_15816[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (33))){
var inst_15587 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15587)){
var statearr_15717_15817 = state_15682__$1;
(statearr_15717_15817[(1)] = (40));

} else {
var statearr_15718_15818 = state_15682__$1;
(statearr_15718_15818[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (13))){
var inst_15513 = (state_15682[(19)]);
var inst_15530 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15513);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15530)){
var statearr_15719_15819 = state_15682__$1;
(statearr_15719_15819[(1)] = (15));

} else {
var statearr_15720_15820 = state_15682__$1;
(statearr_15720_15820[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (22))){
var inst_15543 = (state_15682[(2)]);
var inst_15544 = fluree.db.util.async.throw_err.call(null,inst_15543);
var state_15682__$1 = state_15682;
var statearr_15721_15821 = state_15682__$1;
(statearr_15721_15821[(2)] = inst_15544);

(statearr_15721_15821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (36))){
var inst_15584 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15722_15822 = state_15682__$1;
(statearr_15722_15822[(2)] = inst_15584);

(statearr_15722_15822[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (41))){
var inst_15512 = (state_15682[(9)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15512)){
var statearr_15723_15823 = state_15682__$1;
(statearr_15723_15823[(1)] = (44));

} else {
var statearr_15724_15824 = state_15682__$1;
(statearr_15724_15824[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (43))){
var inst_15594 = (state_15682[(2)]);
var inst_15595 = fluree.db.util.async.throw_err.call(null,inst_15594);
var state_15682__$1 = state_15682;
var statearr_15725_15825 = state_15682__$1;
(statearr_15725_15825[(2)] = inst_15595);

(statearr_15725_15825[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (61))){
var inst_15640 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15726_15826 = state_15682__$1;
(statearr_15726_15826[(2)] = inst_15640);

(statearr_15726_15826[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (29))){
var inst_15560 = (state_15682[(2)]);
var inst_15561 = fluree.db.util.async.throw_err.call(null,inst_15560);
var state_15682__$1 = state_15682;
var statearr_15727_15827 = state_15682__$1;
(statearr_15727_15827[(2)] = inst_15561);

(statearr_15727_15827[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (44))){
var inst_15515 = (state_15682[(14)]);
var inst_15598 = (state_15682[(20)]);
var inst_15598__$1 = cljs.core.not.call(null,inst_15515);
var state_15682__$1 = (function (){var statearr_15728 = state_15682;
(statearr_15728[(20)] = inst_15598__$1);

return statearr_15728;
})();
if(inst_15598__$1){
var statearr_15729_15828 = state_15682__$1;
(statearr_15729_15828[(1)] = (47));

} else {
var statearr_15730_15829 = state_15682__$1;
(statearr_15730_15829[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (6))){
var inst_15512 = (state_15682[(9)]);
var inst_15517 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15512);
var inst_15518 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15517);
var state_15682__$1 = state_15682;
var statearr_15731_15830 = state_15682__$1;
(statearr_15731_15830[(2)] = inst_15518);

(statearr_15731_15830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (28))){
var inst_15571 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15732_15831 = state_15682__$1;
(statearr_15732_15831[(2)] = inst_15571);

(statearr_15732_15831[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (64))){
var inst_15512 = (state_15682[(9)]);
var inst_15514 = (state_15682[(11)]);
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(7)]);
var inst_15643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15644 = [inst_15512,inst_15511,inst_15551,inst_15514];
var inst_15645 = (new cljs.core.PersistentVector(null,4,(5),inst_15643,inst_15644,null));
var inst_15646 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15645,opts);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(67),inst_15646);
} else {
if((state_val_15683 === (51))){
var inst_15512 = (state_15682[(9)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15512)){
var statearr_15733_15832 = state_15682__$1;
(statearr_15733_15832[(1)] = (64));

} else {
var statearr_15734_15833 = state_15682__$1;
(statearr_15734_15833[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (25))){
var inst_15521 = (state_15682[(18)]);
var inst_15669 = (state_15682[(2)]);
var state_15682__$1 = (function (){var statearr_15735 = state_15682;
(statearr_15735[(8)] = inst_15669);

return statearr_15735;
})();
if(cljs.core.truth_(inst_15521)){
var statearr_15736_15834 = state_15682__$1;
(statearr_15736_15834[(1)] = (72));

} else {
var statearr_15737_15835 = state_15682__$1;
(statearr_15737_15835[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (34))){
var inst_15515 = (state_15682[(14)]);
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15515)){
var statearr_15738_15836 = state_15682__$1;
(statearr_15738_15836[(1)] = (37));

} else {
var statearr_15739_15837 = state_15682__$1;
(statearr_15739_15837[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (17))){
var inst_15549 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15740_15838 = state_15682__$1;
(statearr_15740_15838[(2)] = inst_15549);

(statearr_15740_15838[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (3))){
var inst_15680 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15682__$1,inst_15680);
} else {
if((state_val_15683 === (12))){
var inst_15513 = (state_15682[(19)]);
var state_15682__$1 = state_15682;
var statearr_15741_15839 = state_15682__$1;
(statearr_15741_15839[(2)] = inst_15513);

(statearr_15741_15839[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (2))){
var inst_15512 = (state_15682[(9)]);
var inst_15510 = (state_15682[(16)]);
var _ = (function (){var statearr_15742 = state_15682;
(statearr_15742[(4)] = cljs.core.cons.call(null,(5),(state_15682[(4)])));

return statearr_15742;
})();
var inst_15510__$1 = fparts;
var inst_15511 = cljs.core.nth.call(null,inst_15510__$1,(0),null);
var inst_15512__$1 = cljs.core.nth.call(null,inst_15510__$1,(1),null);
var inst_15513 = cljs.core.nth.call(null,inst_15510__$1,(2),null);
var inst_15514 = cljs.core.nth.call(null,inst_15510__$1,(3),null);
var inst_15515 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15512__$1);
var state_15682__$1 = (function (){var statearr_15743 = state_15682;
(statearr_15743[(9)] = inst_15512__$1);

(statearr_15743[(11)] = inst_15514);

(statearr_15743[(14)] = inst_15515);

(statearr_15743[(12)] = inst_15511);

(statearr_15743[(19)] = inst_15513);

(statearr_15743[(16)] = inst_15510__$1);

return statearr_15743;
})();
if(cljs.core.truth_(inst_15512__$1)){
var statearr_15744_15840 = state_15682__$1;
(statearr_15744_15840[(1)] = (6));

} else {
var statearr_15745_15841 = state_15682__$1;
(statearr_15745_15841[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (66))){
var inst_15663 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15746_15842 = state_15682__$1;
(statearr_15746_15842[(2)] = inst_15663);

(statearr_15746_15842[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (23))){
var inst_15512 = (state_15682[(9)]);
var inst_15553 = cljs.core._EQ_.call(null,"_id",inst_15512);
var state_15682__$1 = state_15682;
if(inst_15553){
var statearr_15747_15843 = state_15682__$1;
(statearr_15747_15843[(1)] = (26));

} else {
var statearr_15748_15844 = state_15682__$1;
(statearr_15748_15844[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (47))){
var inst_15551 = (state_15682[(7)]);
var state_15682__$1 = state_15682;
var statearr_15749_15845 = state_15682__$1;
(statearr_15749_15845[(2)] = inst_15551);

(statearr_15749_15845[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (35))){
var inst_15574 = (state_15682[(21)]);
var state_15682__$1 = state_15682;
var statearr_15750_15846 = state_15682__$1;
(statearr_15750_15846[(2)] = inst_15574);

(statearr_15750_15846[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (19))){
var inst_15512 = (state_15682[(9)]);
var inst_15513 = (state_15682[(19)]);
var inst_15539 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15512);
var inst_15540 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15539),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15513)].join('');
var inst_15541 = fluree.db.dbproto._tag_id.call(null,db,inst_15540);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(22),inst_15541);
} else {
if((state_val_15683 === (57))){
var inst_15614 = (state_15682[(13)]);
var state_15682__$1 = state_15682;
var statearr_15751_15847 = state_15682__$1;
(statearr_15751_15847[(2)] = inst_15614);

(statearr_15751_15847[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (68))){
var inst_15512 = (state_15682[(9)]);
var inst_15514 = (state_15682[(11)]);
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(7)]);
var inst_15652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15653 = [inst_15551,inst_15512,inst_15511,inst_15514];
var inst_15654 = (new cljs.core.PersistentVector(null,4,(5),inst_15652,inst_15653,null));
var inst_15655 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15654,opts);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(71),inst_15655);
} else {
if((state_val_15683 === (11))){
var inst_15526 = (state_15682[(17)]);
var inst_15526__$1 = (state_15682[(2)]);
var inst_15527 = cljs.core.not.call(null,inst_15526__$1);
var state_15682__$1 = (function (){var statearr_15753 = state_15682;
(statearr_15753[(17)] = inst_15526__$1);

return statearr_15753;
})();
if(inst_15527){
var statearr_15754_15848 = state_15682__$1;
(statearr_15754_15848[(1)] = (12));

} else {
var statearr_15755_15849 = state_15682__$1;
(statearr_15755_15849[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (9))){
var inst_15513 = (state_15682[(19)]);
var inst_15523 = typeof inst_15513 === 'string';
var state_15682__$1 = state_15682;
var statearr_15756_15850 = state_15682__$1;
(statearr_15756_15850[(2)] = inst_15523);

(statearr_15756_15850[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (5))){
var _ = (function (){var statearr_15757 = state_15682;
(statearr_15757[(4)] = cljs.core.rest.call(null,(state_15682[(4)])));

return statearr_15757;
})();
var state_15682__$1 = state_15682;
var ex15752 = (state_15682__$1[(2)]);
var statearr_15758_15851 = state_15682__$1;
(statearr_15758_15851[(5)] = ex15752);


if((ex15752 instanceof Error)){
var statearr_15759_15852 = state_15682__$1;
(statearr_15759_15852[(1)] = (4));

(statearr_15759_15852[(5)] = null);

} else {
throw ex15752;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (14))){
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(2)]);
var state_15682__$1 = (function (){var statearr_15760 = state_15682;
(statearr_15760[(7)] = inst_15551);

return statearr_15760;
})();
if(cljs.core.truth_(inst_15511)){
var statearr_15761_15853 = state_15682__$1;
(statearr_15761_15853[(1)] = (23));

} else {
var statearr_15762_15854 = state_15682__$1;
(statearr_15762_15854[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (45))){
var inst_15512 = (state_15682[(9)]);
var state_15682__$1 = state_15682;
var statearr_15763_15855 = state_15682__$1;
(statearr_15763_15855[(2)] = inst_15512);

(statearr_15763_15855[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (53))){
var inst_15512 = (state_15682[(9)]);
var inst_15514 = (state_15682[(11)]);
var inst_15515 = (state_15682[(14)]);
var inst_15511 = (state_15682[(12)]);
var inst_15551 = (state_15682[(7)]);
var inst_15607 = (state_15682[(15)]);
var inst_15510 = (state_15682[(16)]);
var inst_15526 = (state_15682[(17)]);
var inst_15521 = (state_15682[(18)]);
var inst_15609 = (function (){var obj_fn = inst_15607;
var t = inst_15514;
var temp__5802__auto__ = inst_15607;
var p = inst_15512;
var idx_predicate_QMARK_ = inst_15515;
var o = inst_15551;
var tag_predicate_QMARK_ = inst_15521;
var s = inst_15511;
var o_coerce_QMARK_ = inst_15526;
var vec__15507 = inst_15510;
return (function (x){
var and__5043__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15682__$1 = state_15682;
var statearr_15764_15856 = state_15682__$1;
(statearr_15764_15856[(2)] = inst_15609);

(statearr_15764_15856[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (26))){
var inst_15514 = (state_15682[(11)]);
var inst_15511 = (state_15682[(12)]);
var inst_15555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15556 = [inst_15511,null,null,inst_15514];
var inst_15557 = (new cljs.core.PersistentVector(null,4,(5),inst_15555,inst_15556,null));
var inst_15558 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15557,opts);
var state_15682__$1 = state_15682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15682__$1,(29),inst_15558);
} else {
if((state_val_15683 === (16))){
var inst_15513 = (state_15682[(19)]);
var inst_15537 = typeof inst_15513 === 'string';
var state_15682__$1 = state_15682;
if(cljs.core.truth_(inst_15537)){
var statearr_15765_15857 = state_15682__$1;
(statearr_15765_15857[(1)] = (19));

} else {
var statearr_15766_15858 = state_15682__$1;
(statearr_15766_15858[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (38))){
var inst_15515 = (state_15682[(14)]);
var state_15682__$1 = state_15682;
var statearr_15767_15859 = state_15682__$1;
(statearr_15767_15859[(2)] = inst_15515);

(statearr_15767_15859[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (30))){
var inst_15568 = (state_15682[(2)]);
var inst_15569 = fluree.db.util.async.throw_err.call(null,inst_15568);
var state_15682__$1 = state_15682;
var statearr_15768_15860 = state_15682__$1;
(statearr_15768_15860[(2)] = inst_15569);

(statearr_15768_15860[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (73))){
var inst_15669 = (state_15682[(8)]);
var state_15682__$1 = state_15682;
var statearr_15769_15861 = state_15682__$1;
(statearr_15769_15861[(2)] = inst_15669);

(statearr_15769_15861[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (10))){
var inst_15521 = (state_15682[(18)]);
var state_15682__$1 = state_15682;
var statearr_15770_15862 = state_15682__$1;
(statearr_15770_15862[(2)] = inst_15521);

(statearr_15770_15862[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (18))){
var inst_15534 = (state_15682[(2)]);
var inst_15535 = fluree.db.util.async.throw_err.call(null,inst_15534);
var state_15682__$1 = state_15682;
var statearr_15771_15863 = state_15682__$1;
(statearr_15771_15863[(2)] = inst_15535);

(statearr_15771_15863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (52))){
var inst_15665 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15772_15864 = state_15682__$1;
(statearr_15772_15864[(2)] = inst_15665);

(statearr_15772_15864[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (67))){
var inst_15648 = (state_15682[(2)]);
var inst_15649 = fluree.db.util.async.throw_err.call(null,inst_15648);
var state_15682__$1 = state_15682;
var statearr_15773_15865 = state_15682__$1;
(statearr_15773_15865[(2)] = inst_15649);

(statearr_15773_15865[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (71))){
var inst_15657 = (state_15682[(2)]);
var inst_15658 = fluree.db.util.async.throw_err.call(null,inst_15657);
var state_15682__$1 = state_15682;
var statearr_15774_15866 = state_15682__$1;
(statearr_15774_15866[(2)] = inst_15658);

(statearr_15774_15866[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (42))){
var inst_15667 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15775_15867 = state_15682__$1;
(statearr_15775_15867[(2)] = inst_15667);

(statearr_15775_15867[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (37))){
var inst_15551 = (state_15682[(7)]);
var inst_15577 = cljs.core.fn_QMARK_.call(null,inst_15551);
var inst_15578 = (!(inst_15577));
var state_15682__$1 = state_15682;
var statearr_15776_15868 = state_15682__$1;
(statearr_15776_15868[(2)] = inst_15578);

(statearr_15776_15868[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (63))){
var inst_15637 = (state_15682[(2)]);
var inst_15638 = fluree.db.util.async.throw_err.call(null,inst_15637);
var state_15682__$1 = state_15682;
var statearr_15777_15869 = state_15682__$1;
(statearr_15777_15869[(2)] = inst_15638);

(statearr_15777_15869[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (8))){
var inst_15521 = (state_15682[(18)]);
var inst_15521__$1 = (state_15682[(2)]);
var state_15682__$1 = (function (){var statearr_15778 = state_15682;
(statearr_15778[(18)] = inst_15521__$1);

return statearr_15778;
})();
if(cljs.core.truth_(inst_15521__$1)){
var statearr_15779_15870 = state_15682__$1;
(statearr_15779_15870[(1)] = (9));

} else {
var statearr_15780_15871 = state_15682__$1;
(statearr_15780_15871[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15683 === (49))){
var inst_15602 = (state_15682[(2)]);
var state_15682__$1 = state_15682;
var statearr_15781_15872 = state_15682__$1;
(statearr_15781_15872[(2)] = inst_15602);

(statearr_15781_15872[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15782 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15782[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15782[(1)] = (1));

return statearr_15782;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15682){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15783){var ex__2749__auto__ = e15783;
var statearr_15784_15873 = state_15682;
(statearr_15784_15873[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15682[(4)]))){
var statearr_15785_15874 = state_15682;
(statearr_15785_15874[(1)] = cljs.core.first.call(null,(state_15682[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15875 = state_15682;
state_15682 = G__15875;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15682){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15786 = f__2769__auto__.call(null);
(statearr_15786[(6)] = c__2768__auto__);

return statearr_15786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15877 = arguments.length;
switch (G__15877) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15912){
var state_val_15913 = (state_15912[(1)]);
if((state_val_15913 === (7))){
var inst_15899 = cljs.core.pr_str.call(null,name);
var inst_15900 = ["Invalid collection name: ",inst_15899].join('');
var inst_15901 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15902 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15903 = cljs.core.PersistentHashMap.fromArrays(inst_15901,inst_15902);
var inst_15904 = cljs.core.ex_info.call(null,inst_15900,inst_15903);
var inst_15905 = (function(){throw inst_15904})();
var state_15912__$1 = state_15912;
var statearr_15914_15934 = state_15912__$1;
(statearr_15914_15934[(2)] = inst_15905);

(statearr_15914_15934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15913 === (1))){
var state_15912__$1 = state_15912;
var statearr_15915_15935 = state_15912__$1;
(statearr_15915_15935[(2)] = null);

(statearr_15915_15935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15913 === (4))){
var inst_15878 = (state_15912[(2)]);
var state_15912__$1 = state_15912;
var statearr_15916_15936 = state_15912__$1;
(statearr_15916_15936[(2)] = inst_15878);

(statearr_15916_15936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15913 === (6))){
var inst_15884 = (state_15912[(7)]);
var inst_15886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15887 = fluree.db.flake.max_subject_id.call(null,inst_15884);
var inst_15888 = [inst_15887];
var inst_15889 = (new cljs.core.PersistentVector(null,1,(5),inst_15886,inst_15888,null));
var inst_15890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15891 = fluree.db.flake.min_subject_id.call(null,inst_15884);
var inst_15892 = [inst_15891];
var inst_15893 = (new cljs.core.PersistentVector(null,1,(5),inst_15890,inst_15892,null));
var inst_15894 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15889,cljs.core._LT__EQ_,inst_15893,opts);
var state_15912__$1 = state_15912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15912__$1,(9),inst_15894);
} else {
if((state_val_15913 === (3))){
var inst_15910 = (state_15912[(2)]);
var state_15912__$1 = state_15912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15912__$1,inst_15910);
} else {
if((state_val_15913 === (2))){
var inst_15884 = (state_15912[(7)]);
var _ = (function (){var statearr_15918 = state_15912;
(statearr_15918[(4)] = cljs.core.cons.call(null,(5),(state_15912[(4)])));

return statearr_15918;
})();
var inst_15884__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15912__$1 = (function (){var statearr_15919 = state_15912;
(statearr_15919[(7)] = inst_15884__$1);

return statearr_15919;
})();
if(cljs.core.truth_(inst_15884__$1)){
var statearr_15920_15937 = state_15912__$1;
(statearr_15920_15937[(1)] = (6));

} else {
var statearr_15921_15938 = state_15912__$1;
(statearr_15921_15938[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15913 === (9))){
var inst_15896 = (state_15912[(2)]);
var inst_15897 = fluree.db.util.async.throw_err.call(null,inst_15896);
var state_15912__$1 = state_15912;
var statearr_15922_15939 = state_15912__$1;
(statearr_15922_15939[(2)] = inst_15897);

(statearr_15922_15939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15913 === (5))){
var _ = (function (){var statearr_15923 = state_15912;
(statearr_15923[(4)] = cljs.core.rest.call(null,(state_15912[(4)])));

return statearr_15923;
})();
var state_15912__$1 = state_15912;
var ex15917 = (state_15912__$1[(2)]);
var statearr_15924_15940 = state_15912__$1;
(statearr_15924_15940[(5)] = ex15917);


var statearr_15925_15941 = state_15912__$1;
(statearr_15925_15941[(1)] = (4));

(statearr_15925_15941[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15913 === (8))){
var inst_15907 = (state_15912[(2)]);
var _ = (function (){var statearr_15926 = state_15912;
(statearr_15926[(4)] = cljs.core.rest.call(null,(state_15912[(4)])));

return statearr_15926;
})();
var state_15912__$1 = state_15912;
var statearr_15927_15942 = state_15912__$1;
(statearr_15927_15942[(2)] = inst_15907);

(statearr_15927_15942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15928 = [null,null,null,null,null,null,null,null];
(statearr_15928[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15928[(1)] = (1));

return statearr_15928;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15912){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15929){var ex__2749__auto__ = e15929;
var statearr_15930_15943 = state_15912;
(statearr_15930_15943[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15912[(4)]))){
var statearr_15931_15944 = state_15912;
(statearr_15931_15944[(1)] = cljs.core.first.call(null,(state_15912[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15945 = state_15912;
state_15912 = G__15945;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15912){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15932 = f__2769__auto__.call(null);
(statearr_15932[(6)] = c__2768__auto__);

return statearr_15932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15949 = flakes;
var vec__15950 = G__15949;
var seq__15951 = cljs.core.seq.call(null,vec__15950);
var first__15952 = cljs.core.first.call(null,seq__15951);
var seq__15951__$1 = cljs.core.next.call(null,seq__15951);
var flake_SINGLEQUOTE_ = first__15952;
var r = seq__15951__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15949__$1 = G__15949;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15958 = G__15949__$1;
var seq__15959 = cljs.core.seq.call(null,vec__15958);
var first__15960 = cljs.core.first.call(null,seq__15959);
var seq__15959__$1 = cljs.core.next.call(null,seq__15959);
var flake_SINGLEQUOTE___$1 = first__15960;
var r__$1 = seq__15959__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o.call(null,flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15962){var e = e15962;
return null;
}})();
var map__15961 = cmd_map;
var map__15961__$1 = cljs.core.__destructure_map.call(null,map__15961);
var type = cljs.core.get.call(null,map__15961__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15961__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15961__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15961__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15961__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15961__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15963 = r__$1;
var G__15964 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15949__$1 = G__15963;
result_STAR___$1 = G__15964;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15973 = blocks;
var vec__15974 = G__15973;
var seq__15975 = cljs.core.seq.call(null,vec__15974);
var first__15976 = cljs.core.first.call(null,seq__15975);
var seq__15975__$1 = cljs.core.next.call(null,seq__15975);
var block_SINGLEQUOTE_ = first__15976;
var r = seq__15975__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15973__$1 = G__15973;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15981 = G__15973__$1;
var seq__15982 = cljs.core.seq.call(null,vec__15981);
var first__15983 = cljs.core.first.call(null,seq__15982);
var seq__15982__$1 = cljs.core.next.call(null,seq__15982);
var block_SINGLEQUOTE___$1 = first__15983;
var r__$1 = seq__15982__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15984 = block_SINGLEQUOTE___$1;
var map__15984__$1 = cljs.core.__destructure_map.call(null,map__15984);
var block = cljs.core.get.call(null,map__15984__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15984__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15984__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15965_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15965_SHARP_),(2))){
return fluree.db.flake.o.call(null,p1__15965_SHARP_);
} else {
return null;
}
});})(G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15966_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15966_SHARP_),(1))){
return fluree.db.flake.o.call(null,p1__15966_SHARP_);
} else {
return null;
}
});})(G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,hash,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15967_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15967_SHARP_),(5))){
return fluree.db.flake.o.call(null,p1__15967_SHARP_);
} else {
return null;
}
});})(G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,hash,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,hash,instant,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15968_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15968_SHARP_),(7))){
return fluree.db.flake.o.call(null,p1__15968_SHARP_);
} else {
return null;
}
});})(G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,hash,instant,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15969_SHARP_){
return cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15969_SHARP_),(106));
});})(G__15973__$1,result_STAR___$1,map__15984,map__15984__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15981,seq__15982,first__15983,seq__15982__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15973,vec__15974,seq__15975,first__15976,seq__15975__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15985 = r__$1;
var G__15986 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15973__$1 = G__15985;
result_STAR___$1 = G__15986;
continue;
}
break;
}
});
