// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24470 = arguments.length;
switch (G__24470) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24473 = arguments.length;
switch (G__24473) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24475 = null;
var G__24475__0 = (function (){
return xf.call(null);
});
var G__24475__1 = (function (result){
return xf.call(null,result);
});
var G__24475__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__24475 = function(result,flake){
switch(arguments.length){
case 0:
return G__24475__0.call(this);
case 1:
return G__24475__1.call(this,result);
case 2:
return G__24475__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24475.cljs$core$IFn$_invoke$arity$0 = G__24475__0;
G__24475.cljs$core$IFn$_invoke$arity$1 = G__24475__1;
G__24475.cljs$core$IFn$_invoke$arity$2 = G__24475__2;
return G__24475;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24476_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24476_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24480 = vars;
var vec__24481 = G__24480;
var seq__24482 = cljs.core.seq.call(null,vec__24481);
var first__24483 = cljs.core.first.call(null,seq__24482);
var seq__24482__$1 = cljs.core.next.call(null,seq__24482);
var var$ = first__24483;
var r = seq__24482__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24480__$1 = G__24480;
var all_vars__$1 = all_vars;
while(true){
var vec__24487 = G__24480__$1;
var seq__24488 = cljs.core.seq.call(null,vec__24487);
var first__24489 = cljs.core.first.call(null,seq__24488);
var seq__24488__$1 = cljs.core.next.call(null,seq__24488);
var var$__$1 = first__24489;
var r__$1 = seq__24488__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24490 = r__$1;
var G__24491 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24480__$1 = G__24490;
all_vars__$1 = G__24491;
continue;
} else {
var G__24492 = r__$1;
var G__24493 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24480__$1 = G__24492;
all_vars__$1 = G__24493;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24494){
var vec__24495 = p__24494;
var tuple_index = cljs.core.nth.call(null,vec__24495,(0),null);
var query_map = cljs.core.nth.call(null,vec__24495,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24509){
var state_val_24510 = (state_24509[(1)]);
if((state_val_24510 === (1))){
var inst_24498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24499 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24500 = [query_map,_id,query_opts];
var inst_24501 = cljs.core.PersistentHashMap.fromArrays(inst_24499,inst_24500);
var inst_24502 = fluree.db.query.fql.query.call(null,db,inst_24501);
var state_24509__$1 = (function (){var statearr_24511 = state_24509;
(statearr_24511[(7)] = inst_24498);

return statearr_24511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24509__$1,(2),inst_24502);
} else {
if((state_val_24510 === (2))){
var inst_24498 = (state_24509[(7)]);
var inst_24504 = (state_24509[(2)]);
var inst_24505 = fluree.db.util.async.throw_err.call(null,inst_24504);
var inst_24506 = [tuple_index,inst_24505];
var inst_24507 = (new cljs.core.PersistentVector(null,2,(5),inst_24498,inst_24506,null));
var state_24509__$1 = state_24509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24509__$1,inst_24507);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_24512 = [null,null,null,null,null,null,null,null];
(statearr_24512[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_24512[(1)] = (1));

return statearr_24512;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_24509){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24513){var ex__2749__auto__ = e24513;
var statearr_24514_24517 = state_24509;
(statearr_24514_24517[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24509[(4)]))){
var statearr_24515_24518 = state_24509;
(statearr_24515_24518[(1)] = cljs.core.first.call(null,(state_24509[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24519 = state_24509;
state_24509 = G__24519;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_24509){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_24509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24516 = f__2769__auto__.call(null);
(statearr_24516[(6)] = c__2768__auto__);

return statearr_24516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24520 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24520,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24520,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24583){
var state_val_24584 = (state_24583[(1)]);
if((state_val_24584 === (7))){
var inst_24578 = (state_24583[(2)]);
var _ = (function (){var statearr_24585 = state_24583;
(statearr_24585[(4)] = cljs.core.rest.call(null,(state_24583[(4)])));

return statearr_24585;
})();
var state_24583__$1 = state_24583;
var statearr_24586_24677 = state_24583__$1;
(statearr_24586_24677[(2)] = inst_24578);

(statearr_24586_24677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (20))){
var inst_24569 = (state_24583[(2)]);
var state_24583__$1 = state_24583;
var statearr_24587_24678 = state_24583__$1;
(statearr_24587_24678[(2)] = inst_24569);

(statearr_24587_24678[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (1))){
var state_24583__$1 = state_24583;
var statearr_24588_24679 = state_24583__$1;
(statearr_24588_24679[(2)] = null);

(statearr_24588_24679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (4))){
var inst_24525 = (state_24583[(2)]);
var state_24583__$1 = state_24583;
var statearr_24589_24680 = state_24583__$1;
(statearr_24589_24680[(2)] = inst_24525);

(statearr_24589_24680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (15))){
var inst_24545 = (state_24583[(7)]);
var inst_24554 = cljs.core.second.call(null,inst_24545);
var inst_24555 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24554);
var inst_24556 = (inst_24555 > max_fuel);
var state_24583__$1 = state_24583;
if(cljs.core.truth_(inst_24556)){
var statearr_24590_24681 = state_24583__$1;
(statearr_24590_24681[(1)] = (18));

} else {
var statearr_24591_24682 = state_24583__$1;
(statearr_24591_24682[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (13))){
var state_24583__$1 = state_24583;
var statearr_24592_24683 = state_24583__$1;
(statearr_24592_24683[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (6))){
var inst_24533 = (state_24583[(8)]);
var state_24583__$1 = state_24583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24583__$1,(8),inst_24533);
} else {
if((state_val_24584 === (17))){
var inst_24572 = (state_24583[(2)]);
var state_24583__$1 = state_24583;
var statearr_24594_24684 = state_24583__$1;
(statearr_24594_24684[(2)] = inst_24572);

(statearr_24594_24684[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (3))){
var inst_24581 = (state_24583[(2)]);
var state_24583__$1 = state_24583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24583__$1,inst_24581);
} else {
if((state_val_24584 === (12))){
var inst_24545 = (state_24583[(7)]);
var inst_24534 = (state_24583[(9)]);
var inst_24551 = inst_24534.call(null);
var state_24583__$1 = (function (){var statearr_24595 = state_24583;
(statearr_24595[(10)] = inst_24551);

return statearr_24595;
})();
var statearr_24596_24685 = state_24583__$1;
(statearr_24596_24685[(2)] = inst_24545);

(statearr_24596_24685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (2))){
var inst_24534 = (state_24583[(9)]);
var inst_24533 = (state_24583[(8)]);
var _ = (function (){var statearr_24597 = state_24583;
(statearr_24597[(4)] = cljs.core.cons.call(null,(5),(state_24583[(4)])));

return statearr_24597;
})();
var inst_24531 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24532 = cljs.core.async.chan.call(null);
var inst_24533__$1 = cljs.core.async.chan.call(null);
var inst_24534__$1 = (function (){var expandMaps = inst_24531;
var queue_ch = inst_24532;
var res_ch = inst_24533__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24535 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24536 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24537 = cljs.core.assoc.call(null,inst_24535,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24536);
var inst_24538 = (function (){var expandMaps = inst_24531;
var queue_ch = inst_24532;
var res_ch = inst_24533__$1;
var stop_BANG_ = inst_24534__$1;
var opts_STAR_ = inst_24537;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24630){
var state_val_24631 = (state_24630[(1)]);
if((state_val_24631 === (7))){
var state_24630__$1 = state_24630;
var statearr_24632_24686 = state_24630__$1;
(statearr_24632_24686[(2)] = tuple_res);

(statearr_24632_24686[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (1))){
var state_24630__$1 = state_24630;
var statearr_24633_24687 = state_24630__$1;
(statearr_24633_24687[(2)] = null);

(statearr_24633_24687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (4))){
var inst_24598 = (state_24630[(2)]);
var inst_24599 = cljs.core.async.put_BANG_.call(null,port,inst_24598);
var inst_24600 = cljs.core.async.close_BANG_.call(null,port);
var state_24630__$1 = (function (){var statearr_24634 = state_24630;
(statearr_24634[(7)] = inst_24599);

return statearr_24634;
})();
var statearr_24635_24688 = state_24630__$1;
(statearr_24635_24688[(2)] = inst_24600);

(statearr_24635_24688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (6))){
var inst_24607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24608 = [tuple_res];
var inst_24609 = (new cljs.core.PersistentVector(null,1,(5),inst_24607,inst_24608,null));
var state_24630__$1 = state_24630;
var statearr_24636_24689 = state_24630__$1;
(statearr_24636_24689[(2)] = inst_24609);

(statearr_24636_24689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (3))){
var inst_24628 = (state_24630[(2)]);
var state_24630__$1 = state_24630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24630__$1,inst_24628);
} else {
if((state_val_24631 === (2))){
var ___$1 = (function (){var statearr_24638 = state_24630;
(statearr_24638[(4)] = cljs.core.cons.call(null,(5),(state_24630[(4)])));

return statearr_24638;
})();
var state_24630__$1 = state_24630;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24639_24690 = state_24630__$1;
(statearr_24639_24690[(1)] = (6));

} else {
var statearr_24640_24691 = state_24630__$1;
(statearr_24640_24691[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (9))){
var inst_24612 = (state_24630[(8)]);
var inst_24614 = (state_24630[(9)]);
var inst_24621 = (state_24630[(2)]);
var inst_24622 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24612,inst_24621);
var inst_24623 = inst_24614.call(null,inst_24622);
var inst_24624 = cljs.core.async.put_BANG_.call(null,port,inst_24623);
var inst_24625 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24641 = state_24630;
(statearr_24641[(4)] = cljs.core.rest.call(null,(state_24630[(4)])));

return statearr_24641;
})();
var state_24630__$1 = (function (){var statearr_24642 = state_24630;
(statearr_24642[(10)] = inst_24624);

return statearr_24642;
})();
var statearr_24643_24692 = state_24630__$1;
(statearr_24643_24692[(2)] = inst_24625);

(statearr_24643_24692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (5))){
var ___$1 = (function (){var statearr_24644 = state_24630;
(statearr_24644[(4)] = cljs.core.rest.call(null,(state_24630[(4)])));

return statearr_24644;
})();
var state_24630__$1 = state_24630;
var ex24637 = (state_24630__$1[(2)]);
var statearr_24645_24693 = state_24630__$1;
(statearr_24645_24693[(5)] = ex24637);


var statearr_24646_24694 = state_24630__$1;
(statearr_24646_24694[(1)] = (4));

(statearr_24646_24694[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24631 === (8))){
var inst_24612 = (state_24630[(8)]);
var inst_24612__$1 = (state_24630[(2)]);
var inst_24613 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24614 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24612__$1;
var query_fuel = inst_24613;
return (function (p1__24524_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24524_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24524_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24615 = cljs.core.PersistentVector.EMPTY;
var inst_24616 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24612__$1;
var query_fuel = inst_24613;
return (function (p1__24523_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24523_SHARP_);
});
})();
var inst_24617 = cljs.core.keep.call(null,inst_24616,expandMaps);
var inst_24618 = cljs.core.async.merge.call(null,inst_24617);
var inst_24619 = cljs.core.async.into.call(null,inst_24615,inst_24618);
var state_24630__$1 = (function (){var statearr_24647 = state_24630;
(statearr_24647[(8)] = inst_24612__$1);

(statearr_24647[(9)] = inst_24614);

return statearr_24647;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24630__$1,(9),inst_24619);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24648 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24648[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24648[(1)] = (1));

return statearr_24648;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24630){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24649){var ex__2749__auto__ = e24649;
var statearr_24650_24695 = state_24630;
(statearr_24650_24695[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24630[(4)]))){
var statearr_24651_24696 = state_24630;
(statearr_24651_24696[(1)] = cljs.core.first.call(null,(state_24630[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24697 = state_24630;
state_24630 = G__24697;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24630){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24652 = f__2769__auto__.call(null);
(statearr_24652[(6)] = c__2768__auto____$1);

return statearr_24652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_24539 = cljs.core.async.onto_chan_BANG_.call(null,inst_24532,tuples_res);
var inst_24540 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24533__$1,inst_24538,inst_24532);
var inst_24541 = cljs.core.PersistentVector.EMPTY;
var inst_24542 = inst_24541;
var state_24583__$1 = (function (){var statearr_24653 = state_24583;
(statearr_24653[(11)] = inst_24540);

(statearr_24653[(12)] = inst_24539);

(statearr_24653[(13)] = inst_24542);

(statearr_24653[(9)] = inst_24534__$1);

(statearr_24653[(8)] = inst_24533__$1);

return statearr_24653;
})();
var statearr_24654_24698 = state_24583__$1;
(statearr_24654_24698[(2)] = null);

(statearr_24654_24698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (19))){
var inst_24545 = (state_24583[(7)]);
var inst_24542 = (state_24583[(13)]);
var inst_24565 = cljs.core.first.call(null,inst_24545);
var inst_24566 = cljs.core.conj.call(null,inst_24542,inst_24565);
var inst_24542__$1 = inst_24566;
var state_24583__$1 = (function (){var statearr_24655 = state_24583;
(statearr_24655[(13)] = inst_24542__$1);

return statearr_24655;
})();
var statearr_24656_24699 = state_24583__$1;
(statearr_24656_24699[(2)] = null);

(statearr_24656_24699[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (11))){
var inst_24576 = (state_24583[(2)]);
var state_24583__$1 = state_24583;
var statearr_24658_24700 = state_24583__$1;
(statearr_24658_24700[(2)] = inst_24576);

(statearr_24658_24700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (9))){
var inst_24542 = (state_24583[(13)]);
var state_24583__$1 = state_24583;
var statearr_24659_24701 = state_24583__$1;
(statearr_24659_24701[(2)] = inst_24542);

(statearr_24659_24701[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (5))){
var _ = (function (){var statearr_24660 = state_24583;
(statearr_24660[(4)] = cljs.core.rest.call(null,(state_24583[(4)])));

return statearr_24660;
})();
var state_24583__$1 = state_24583;
var ex24657 = (state_24583__$1[(2)]);
var statearr_24661_24702 = state_24583__$1;
(statearr_24661_24702[(5)] = ex24657);


if((ex24657 instanceof Error)){
var statearr_24662_24703 = state_24583__$1;
(statearr_24662_24703[(1)] = (4));

(statearr_24662_24703[(5)] = null);

} else {
throw ex24657;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (14))){
var inst_24574 = (state_24583[(2)]);
var state_24583__$1 = state_24583;
var statearr_24663_24704 = state_24583__$1;
(statearr_24663_24704[(2)] = inst_24574);

(statearr_24663_24704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (16))){
var state_24583__$1 = state_24583;
var statearr_24664_24705 = state_24583__$1;
(statearr_24664_24705[(2)] = null);

(statearr_24664_24705[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (10))){
var inst_24545 = (state_24583[(7)]);
var inst_24549 = fluree.db.util.core.exception_QMARK_.call(null,inst_24545);
var state_24583__$1 = state_24583;
if(inst_24549){
var statearr_24665_24706 = state_24583__$1;
(statearr_24665_24706[(1)] = (12));

} else {
var statearr_24666_24707 = state_24583__$1;
(statearr_24666_24707[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (18))){
var inst_24534 = (state_24583[(9)]);
var inst_24558 = inst_24534.call(null);
var inst_24559 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24560 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24561 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24562 = cljs.core.PersistentHashMap.fromArrays(inst_24560,inst_24561);
var inst_24563 = cljs.core.ex_info.call(null,inst_24559,inst_24562);
var state_24583__$1 = (function (){var statearr_24667 = state_24583;
(statearr_24667[(14)] = inst_24558);

return statearr_24667;
})();
var statearr_24668_24708 = state_24583__$1;
(statearr_24668_24708[(2)] = inst_24563);

(statearr_24668_24708[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24584 === (8))){
var inst_24545 = (state_24583[(7)]);
var inst_24545__$1 = (state_24583[(2)]);
var inst_24546 = (inst_24545__$1 == null);
var state_24583__$1 = (function (){var statearr_24669 = state_24583;
(statearr_24669[(7)] = inst_24545__$1);

return statearr_24669;
})();
if(cljs.core.truth_(inst_24546)){
var statearr_24670_24709 = state_24583__$1;
(statearr_24670_24709[(1)] = (9));

} else {
var statearr_24671_24710 = state_24583__$1;
(statearr_24671_24710[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24672 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24672[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24672[(1)] = (1));

return statearr_24672;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24583){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24673){var ex__2749__auto__ = e24673;
var statearr_24674_24711 = state_24583;
(statearr_24674_24711[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24583[(4)]))){
var statearr_24675_24712 = state_24583;
(statearr_24675_24712[(1)] = cljs.core.first.call(null,(state_24583[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24713 = state_24583;
state_24583 = G__24713;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24583){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24676 = f__2769__auto__.call(null);
(statearr_24676[(6)] = c__2768__auto__);

return statearr_24676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24714 = select;
var map__24714__$1 = cljs.core.__destructure_map.call(null,map__24714);
var as = cljs.core.get.call(null,map__24714__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__24714__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__24714__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24717 = orderBy;
var order = cljs.core.nth.call(null,vec__24717,(0),null);
var var$ = cljs.core.nth.call(null,vec__24717,(1),null);
var option = cljs.core.nth.call(null,vec__24717,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24715_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__24715_SHARP_,compare_idx));
}):(function (p1__24716_SHARP_){
return cljs.core.nth.call(null,p1__24716_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24722 = arguments.length;
switch (G__24722) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24723,p__24724,group_limit,opts){
var map__24725 = p__24723;
var map__24725__$1 = cljs.core.__destructure_map.call(null,map__24725);
var res = map__24725__$1;
var vars = cljs.core.get.call(null,map__24725__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24726 = p__24724;
var map__24726__$1 = cljs.core.__destructure_map.call(null,map__24726);
var select_spec = map__24726__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24726__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24863){
var state_val_24864 = (state_24863[(1)]);
if((state_val_24864 === (7))){
var inst_24733 = (state_24863[(7)]);
var state_24863__$1 = state_24863;
var statearr_24865_24967 = state_24863__$1;
(statearr_24865_24967[(2)] = inst_24733);

(statearr_24865_24967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (59))){
var inst_24856 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
var statearr_24866_24968 = state_24863__$1;
(statearr_24866_24968[(2)] = inst_24856);

(statearr_24866_24968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (20))){
var inst_24769 = (state_24863[(8)]);
var inst_24772 = (state_24863[(9)]);
var inst_24768 = (state_24863[(2)]);
var inst_24769__$1 = cljs.core.__destructure_map.call(null,inst_24768);
var inst_24770 = cljs.core.get.call(null,inst_24769__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24771 = cljs.core.get.call(null,inst_24769__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24772__$1 = offset;
var state_24863__$1 = (function (){var statearr_24867 = state_24863;
(statearr_24867[(8)] = inst_24769__$1);

(statearr_24867[(10)] = inst_24771);

(statearr_24867[(11)] = inst_24770);

(statearr_24867[(9)] = inst_24772__$1);

return statearr_24867;
})();
if(cljs.core.truth_(inst_24772__$1)){
var statearr_24868_24969 = state_24863__$1;
(statearr_24868_24969[(1)] = (21));

} else {
var statearr_24869_24970 = state_24863__$1;
(statearr_24869_24970[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (58))){
var inst_24848 = (state_24863[(12)]);
var state_24863__$1 = state_24863;
var statearr_24870_24971 = state_24863__$1;
(statearr_24870_24971[(2)] = inst_24848);

(statearr_24870_24971[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (60))){
var inst_24852 = (state_24863[(2)]);
var inst_24853 = fluree.db.util.async.throw_err.call(null,inst_24852);
var state_24863__$1 = state_24863;
var statearr_24871_24972 = state_24863__$1;
(statearr_24871_24972[(2)] = inst_24853);

(statearr_24871_24972[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (27))){
var inst_24784 = cljs.core.not.call(null,inVector_QMARK_);
var state_24863__$1 = state_24863;
var statearr_24872_24973 = state_24863__$1;
(statearr_24872_24973[(2)] = inst_24784);

(statearr_24872_24973[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (1))){
var state_24863__$1 = state_24863;
var statearr_24873_24974 = state_24863__$1;
(statearr_24873_24974[(2)] = null);

(statearr_24873_24974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (24))){
var state_24863__$1 = state_24863;
var statearr_24874_24975 = state_24863__$1;
(statearr_24874_24975[(2)] = offset);

(statearr_24874_24975[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (55))){
var inst_24842 = (state_24863[(13)]);
var state_24863__$1 = state_24863;
var statearr_24875_24976 = state_24863__$1;
(statearr_24875_24976[(2)] = inst_24842);

(statearr_24875_24976[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (39))){
var inst_24810 = (state_24863[(14)]);
var inst_24812 = cljs.core.distinct.call(null);
var inst_24813 = cljs.core.conj.call(null,inst_24810,inst_24812);
var state_24863__$1 = state_24863;
var statearr_24876_24977 = state_24863__$1;
(statearr_24876_24977[(2)] = inst_24813);

(statearr_24876_24977[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (46))){
var inst_24822 = (state_24863[(15)]);
var state_24863__$1 = state_24863;
var statearr_24877_24978 = state_24863__$1;
(statearr_24877_24978[(2)] = inst_24822);

(statearr_24877_24978[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (4))){
var inst_24727 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
var statearr_24878_24979 = state_24863__$1;
(statearr_24878_24979[(2)] = inst_24727);

(statearr_24878_24979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (54))){
var inst_24842 = (state_24863[(13)]);
var inst_24836 = (state_24863[(16)]);
var inst_24844 = cljs.core.PersistentVector.EMPTY;
var inst_24845 = cljs.core.into.call(null,inst_24844,inst_24836,inst_24842);
var state_24863__$1 = state_24863;
var statearr_24879_24980 = state_24863__$1;
(statearr_24879_24980[(2)] = inst_24845);

(statearr_24879_24980[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (15))){
var inst_24754 = (state_24863[(17)]);
var inst_24756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24757 = [inst_24754];
var inst_24758 = (new cljs.core.PersistentVector(null,1,(5),inst_24756,inst_24757,null));
var state_24863__$1 = state_24863;
var statearr_24880_24981 = state_24863__$1;
(statearr_24880_24981[(2)] = inst_24758);

(statearr_24880_24981[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (48))){
var inst_24792 = (state_24863[(18)]);
var inst_24769 = (state_24863[(8)]);
var inst_24771 = (state_24863[(10)]);
var inst_24781 = (state_24863[(19)]);
var inst_24828 = (state_24863[(20)]);
var inst_24770 = (state_24863[(11)]);
var inst_24787 = (state_24863[(21)]);
var inst_24830 = (function (){var map__24763 = inst_24769;
var headers = inst_24770;
var tuples = inst_24771;
var offset_SINGLEQUOTE_ = inst_24781;
var single_result_QMARK_ = inst_24787;
var pp_keys = inst_24792;
var G__24793 = inst_24828;
return (function (p1__24720_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__24720_SHARP_);
});
})();
var inst_24831 = cljs.core.map.call(null,inst_24830);
var inst_24832 = cljs.core.conj.call(null,inst_24828,inst_24831);
var state_24863__$1 = state_24863;
var statearr_24881_24982 = state_24863__$1;
(statearr_24881_24982[(2)] = inst_24832);

(statearr_24881_24982[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (50))){
var inst_24835 = (state_24863[(2)]);
var inst_24836 = cljs.core.apply.call(null,cljs.core.comp,inst_24835);
var state_24863__$1 = (function (){var statearr_24882 = state_24863;
(statearr_24882[(16)] = inst_24836);

return statearr_24882;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24883_24983 = state_24863__$1;
(statearr_24883_24983[(1)] = (51));

} else {
var statearr_24884_24984 = state_24863__$1;
(statearr_24884_24984[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (21))){
var inst_24774 = cljs.core.not.call(null,groupBy);
var state_24863__$1 = state_24863;
var statearr_24885_24985 = state_24863__$1;
(statearr_24885_24985[(2)] = inst_24774);

(statearr_24885_24985[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (31))){
var state_24863__$1 = state_24863;
var statearr_24886_24986 = state_24863__$1;
(statearr_24886_24986[(2)] = null);

(statearr_24886_24986[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (32))){
var inst_24770 = (state_24863[(11)]);
var inst_24787 = (state_24863[(21)]);
var inst_24792 = (state_24863[(2)]);
var inst_24794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24795 = fluree.db.query.fql.select_tuples_fn.call(null,inst_24770,vars,select);
var inst_24796 = cljs.core.map.call(null,inst_24795);
var inst_24797 = [inst_24796];
var inst_24798 = (new cljs.core.PersistentVector(null,1,(5),inst_24794,inst_24797,null));
var state_24863__$1 = (function (){var statearr_24887 = state_24863;
(statearr_24887[(18)] = inst_24792);

(statearr_24887[(22)] = inst_24798);

return statearr_24887;
})();
if(cljs.core.truth_(inst_24787)){
var statearr_24888_24987 = state_24863__$1;
(statearr_24888_24987[(1)] = (33));

} else {
var statearr_24889_24988 = state_24863__$1;
(statearr_24889_24988[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (40))){
var inst_24810 = (state_24863[(14)]);
var state_24863__$1 = state_24863;
var statearr_24890_24989 = state_24863__$1;
(statearr_24890_24989[(2)] = inst_24810);

(statearr_24890_24989[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (56))){
var inst_24848 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24891 = state_24863;
(statearr_24891[(12)] = inst_24848);

return statearr_24891;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24892_24990 = state_24863__$1;
(statearr_24892_24990[(1)] = (57));

} else {
var statearr_24893_24991 = state_24863__$1;
(statearr_24893_24991[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (33))){
var inst_24798 = (state_24863[(22)]);
var inst_24800 = cljs.core.map.call(null,cljs.core.first);
var inst_24801 = cljs.core.conj.call(null,inst_24798,inst_24800);
var state_24863__$1 = state_24863;
var statearr_24894_24992 = state_24863__$1;
(statearr_24894_24992[(2)] = inst_24801);

(statearr_24894_24992[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (13))){
var inst_24743 = (state_24863[(23)]);
var state_24863__$1 = state_24863;
var statearr_24895_24993 = state_24863__$1;
(statearr_24895_24993[(2)] = inst_24743);

(statearr_24895_24993[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (22))){
var inst_24772 = (state_24863[(9)]);
var state_24863__$1 = state_24863;
var statearr_24896_24994 = state_24863__$1;
(statearr_24896_24994[(2)] = inst_24772);

(statearr_24896_24994[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (36))){
var inst_24804 = (state_24863[(24)]);
var inst_24806 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_24807 = cljs.core.conj.call(null,inst_24804,inst_24806);
var state_24863__$1 = state_24863;
var statearr_24897_24995 = state_24863__$1;
(statearr_24897_24995[(2)] = inst_24807);

(statearr_24897_24995[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (41))){
var inst_24781 = (state_24863[(19)]);
var inst_24816 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24898 = state_24863;
(statearr_24898[(25)] = inst_24816);

return statearr_24898;
})();
if(cljs.core.truth_(inst_24781)){
var statearr_24899_24996 = state_24863__$1;
(statearr_24899_24996[(1)] = (42));

} else {
var statearr_24900_24997 = state_24863__$1;
(statearr_24900_24997[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (43))){
var inst_24816 = (state_24863[(25)]);
var state_24863__$1 = state_24863;
var statearr_24901_24998 = state_24863__$1;
(statearr_24901_24998[(2)] = inst_24816);

(statearr_24901_24998[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (29))){
var inst_24787 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24902 = state_24863;
(statearr_24902[(21)] = inst_24787);

return statearr_24902;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24903_24999 = state_24863__$1;
(statearr_24903_24999[(1)] = (30));

} else {
var statearr_24904_25000 = state_24863__$1;
(statearr_24904_25000[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (44))){
var inst_24822 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24905 = state_24863;
(statearr_24905[(15)] = inst_24822);

return statearr_24905;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24906_25001 = state_24863__$1;
(statearr_24906_25001[(1)] = (45));

} else {
var statearr_24907_25002 = state_24863__$1;
(statearr_24907_25002[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (6))){
var inst_24735 = cljs.core.count.call(null,select);
var inst_24736 = cljs.core._EQ_.call(null,(1),inst_24735);
var state_24863__$1 = state_24863;
var statearr_24908_25003 = state_24863__$1;
(statearr_24908_25003[(2)] = inst_24736);

(statearr_24908_25003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (28))){
var inst_24782 = (state_24863[(26)]);
var state_24863__$1 = state_24863;
var statearr_24909_25004 = state_24863__$1;
(statearr_24909_25004[(2)] = inst_24782);

(statearr_24909_25004[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (51))){
var inst_24771 = (state_24863[(10)]);
var inst_24770 = (state_24863[(11)]);
var inst_24839 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_24770,orderBy,inst_24771);
var state_24863__$1 = state_24863;
var statearr_24910_25005 = state_24863__$1;
(statearr_24910_25005[(2)] = inst_24839);

(statearr_24910_25005[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (25))){
var state_24863__$1 = state_24863;
var statearr_24911_25006 = state_24863__$1;
(statearr_24911_25006[(2)] = null);

(statearr_24911_25006[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (34))){
var inst_24798 = (state_24863[(22)]);
var state_24863__$1 = state_24863;
var statearr_24912_25007 = state_24863__$1;
(statearr_24912_25007[(2)] = inst_24798);

(statearr_24912_25007[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (17))){
var inst_24761 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
var statearr_24913_25008 = state_24863__$1;
(statearr_24913_25008[(2)] = inst_24761);

(statearr_24913_25008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (3))){
var inst_24861 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24863__$1,inst_24861);
} else {
if((state_val_24864 === (12))){
var inst_24743 = (state_24863[(23)]);
var inst_24745 = cljs.core.first.call(null,select);
var inst_24746 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24745);
var inst_24747 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24746);
var inst_24748 = cljs.core.subs.call(null,inst_24747,(1));
var inst_24749 = [inst_24748];
var inst_24750 = [inst_24743];
var inst_24751 = cljs.core.PersistentHashMap.fromArrays(inst_24749,inst_24750);
var state_24863__$1 = state_24863;
var statearr_24914_25009 = state_24863__$1;
(statearr_24914_25009[(2)] = inst_24751);

(statearr_24914_25009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (2))){
var inst_24733 = (state_24863[(7)]);
var _ = (function (){var statearr_24915 = state_24863;
(statearr_24915[(4)] = cljs.core.cons.call(null,(5),(state_24863[(4)])));

return statearr_24915;
})();
var inst_24733__$1 = aggregates;
var state_24863__$1 = (function (){var statearr_24916 = state_24863;
(statearr_24916[(7)] = inst_24733__$1);

return statearr_24916;
})();
if(cljs.core.truth_(inst_24733__$1)){
var statearr_24917_25010 = state_24863__$1;
(statearr_24917_25010[(1)] = (6));

} else {
var statearr_24918_25011 = state_24863__$1;
(statearr_24918_25011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (23))){
var inst_24777 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
if(cljs.core.truth_(inst_24777)){
var statearr_24919_25012 = state_24863__$1;
(statearr_24919_25012[(1)] = (24));

} else {
var statearr_24920_25013 = state_24863__$1;
(statearr_24920_25013[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (47))){
var inst_24828 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24921 = state_24863;
(statearr_24921[(20)] = inst_24828);

return statearr_24921;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24922_25014 = state_24863__$1;
(statearr_24922_25014[(1)] = (48));

} else {
var statearr_24923_25015 = state_24863__$1;
(statearr_24923_25015[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (35))){
var inst_24804 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24924 = state_24863;
(statearr_24924[(24)] = inst_24804);

return statearr_24924;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24925_25016 = state_24863__$1;
(statearr_24925_25016[(1)] = (36));

} else {
var statearr_24926_25017 = state_24863__$1;
(statearr_24926_25017[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (19))){
var state_24863__$1 = state_24863;
var statearr_24927_25018 = state_24863__$1;
(statearr_24927_25018[(2)] = res);

(statearr_24927_25018[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (57))){
var inst_24792 = (state_24863[(18)]);
var inst_24787 = (state_24863[(21)]);
var inst_24848 = (state_24863[(12)]);
var inst_24850 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_24792,inst_24787,db,fuel,max_fuel,opts,(8),inst_24848);
var state_24863__$1 = state_24863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24863__$1,(60),inst_24850);
} else {
if((state_val_24864 === (11))){
var inst_24858 = (state_24863[(2)]);
var _ = (function (){var statearr_24929 = state_24863;
(statearr_24929[(4)] = cljs.core.rest.call(null,(state_24863[(4)])));

return statearr_24929;
})();
var state_24863__$1 = state_24863;
var statearr_24930_25019 = state_24863__$1;
(statearr_24930_25019[(2)] = inst_24858);

(statearr_24930_25019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (9))){
var inst_24741 = cljs.core.first.call(null,aggregates);
var inst_24742 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24741);
var inst_24743 = cljs.core.second.call(null,inst_24742);
var state_24863__$1 = (function (){var statearr_24931 = state_24863;
(statearr_24931[(23)] = inst_24743);

return statearr_24931;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24932_25020 = state_24863__$1;
(statearr_24932_25020[(1)] = (12));

} else {
var statearr_24933_25021 = state_24863__$1;
(statearr_24933_25021[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (5))){
var _ = (function (){var statearr_24934 = state_24863;
(statearr_24934[(4)] = cljs.core.rest.call(null,(state_24863[(4)])));

return statearr_24934;
})();
var state_24863__$1 = state_24863;
var ex24928 = (state_24863__$1[(2)]);
var statearr_24935_25022 = state_24863__$1;
(statearr_24935_25022[(5)] = ex24928);


if((ex24928 instanceof Error)){
var statearr_24936_25023 = state_24863__$1;
(statearr_24936_25023[(1)] = (4));

(statearr_24936_25023[(5)] = null);

} else {
throw ex24928;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (14))){
var inst_24754 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24937 = state_24863;
(statearr_24937[(17)] = inst_24754);

return statearr_24937;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24938_25024 = state_24863__$1;
(statearr_24938_25024[(1)] = (15));

} else {
var statearr_24939_25025 = state_24863__$1;
(statearr_24939_25025[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (45))){
var inst_24822 = (state_24863[(15)]);
var inst_24824 = cljs.core.take.call(null,group_limit);
var inst_24825 = cljs.core.conj.call(null,inst_24822,inst_24824);
var state_24863__$1 = state_24863;
var statearr_24940_25026 = state_24863__$1;
(statearr_24940_25026[(2)] = inst_24825);

(statearr_24940_25026[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (53))){
var inst_24842 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24941 = state_24863;
(statearr_24941[(13)] = inst_24842);

return statearr_24941;
})();
var statearr_24942_25027 = state_24863__$1;
(statearr_24942_25027[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (26))){
var inst_24782 = (state_24863[(26)]);
var inst_24781 = (state_24863[(2)]);
var inst_24782__$1 = cljs.core.not.call(null,prettyPrint);
var state_24863__$1 = (function (){var statearr_24944 = state_24863;
(statearr_24944[(26)] = inst_24782__$1);

(statearr_24944[(19)] = inst_24781);

return statearr_24944;
})();
if(inst_24782__$1){
var statearr_24945_25028 = state_24863__$1;
(statearr_24945_25028[(1)] = (27));

} else {
var statearr_24946_25029 = state_24863__$1;
(statearr_24946_25029[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (16))){
var inst_24754 = (state_24863[(17)]);
var state_24863__$1 = state_24863;
var statearr_24947_25030 = state_24863__$1;
(statearr_24947_25030[(2)] = inst_24754);

(statearr_24947_25030[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (38))){
var inst_24810 = (state_24863[(2)]);
var state_24863__$1 = (function (){var statearr_24948 = state_24863;
(statearr_24948[(14)] = inst_24810);

return statearr_24948;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24949_25031 = state_24863__$1;
(statearr_24949_25031[(1)] = (39));

} else {
var statearr_24950_25032 = state_24863__$1;
(statearr_24950_25032[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (30))){
var inst_24789 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24863__$1 = state_24863;
var statearr_24951_25033 = state_24863__$1;
(statearr_24951_25033[(2)] = inst_24789);

(statearr_24951_25033[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (10))){
var state_24863__$1 = state_24863;
if(cljs.core.truth_(aggregates)){
var statearr_24952_25034 = state_24863__$1;
(statearr_24952_25034[(1)] = (18));

} else {
var statearr_24953_25035 = state_24863__$1;
(statearr_24953_25035[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (18))){
var inst_24765 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24863__$1 = state_24863;
var statearr_24954_25036 = state_24863__$1;
(statearr_24954_25036[(2)] = inst_24765);

(statearr_24954_25036[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (52))){
var inst_24771 = (state_24863[(10)]);
var state_24863__$1 = state_24863;
var statearr_24955_25037 = state_24863__$1;
(statearr_24955_25037[(2)] = inst_24771);

(statearr_24955_25037[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (42))){
var inst_24816 = (state_24863[(25)]);
var inst_24781 = (state_24863[(19)]);
var inst_24818 = cljs.core.drop.call(null,inst_24781);
var inst_24819 = cljs.core.conj.call(null,inst_24816,inst_24818);
var state_24863__$1 = state_24863;
var statearr_24956_25038 = state_24863__$1;
(statearr_24956_25038[(2)] = inst_24819);

(statearr_24956_25038[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (37))){
var inst_24804 = (state_24863[(24)]);
var state_24863__$1 = state_24863;
var statearr_24957_25039 = state_24863__$1;
(statearr_24957_25039[(2)] = inst_24804);

(statearr_24957_25039[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (8))){
var inst_24739 = (state_24863[(2)]);
var state_24863__$1 = state_24863;
if(cljs.core.truth_(inst_24739)){
var statearr_24958_25040 = state_24863__$1;
(statearr_24958_25040[(1)] = (9));

} else {
var statearr_24959_25041 = state_24863__$1;
(statearr_24959_25041[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24864 === (49))){
var inst_24828 = (state_24863[(20)]);
var state_24863__$1 = state_24863;
var statearr_24960_25042 = state_24863__$1;
(statearr_24960_25042[(2)] = inst_24828);

(statearr_24960_25042[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_24961 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24961[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_24961[(1)] = (1));

return statearr_24961;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24863){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24962){var ex__2749__auto__ = e24962;
var statearr_24963_25043 = state_24863;
(statearr_24963_25043[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24863[(4)]))){
var statearr_24964_25044 = state_24863;
(statearr_24964_25044[(1)] = cljs.core.first.call(null,(state_24863[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25045 = state_24863;
state_24863 = G__25045;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24863){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24965 = f__2769__auto__.call(null);
(statearr_24965[(6)] = c__2768__auto__);

return statearr_24965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25048,groupBy){
var map__25049 = p__25048;
var map__25049__$1 = cljs.core.__destructure_map.call(null,map__25049);
var res = map__25049__$1;
var headers = cljs.core.get.call(null,map__25049__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25049__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25050 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25050,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25050,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25046_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25046_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25047_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25047_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25053 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25053,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25053,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25056,headers,group_map){
var map__25057 = p__25056;
var map__25057__$1 = cljs.core.__destructure_map.call(null,map__25057);
var having = map__25057__$1;
var params = cljs.core.get.call(null,map__25057__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.call(null,map__25057__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,params,headers);
var filtered = (function (){var G__25064 = group_map;
var vec__25065 = G__25064;
var seq__25066 = cljs.core.seq.call(null,vec__25065);
var first__25067 = cljs.core.first.call(null,seq__25066);
var seq__25066__$1 = cljs.core.next.call(null,seq__25066);
var vec__25068 = first__25067;
var k = cljs.core.nth.call(null,vec__25068,(0),null);
var tuples = cljs.core.nth.call(null,vec__25068,(1),null);
var r = seq__25066__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25064__$1 = G__25064;
var acc__$1 = acc;
while(true){
var vec__25078 = G__25064__$1;
var seq__25079 = cljs.core.seq.call(null,vec__25078);
var first__25080 = cljs.core.first.call(null,seq__25079);
var seq__25079__$1 = cljs.core.next.call(null,seq__25079);
var vec__25081 = first__25080;
var k__$1 = cljs.core.nth.call(null,vec__25081,(0),null);
var tuples__$1 = cljs.core.nth.call(null,vec__25081,(1),null);
var r__$1 = seq__25079__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten.call(null,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,tuples__$1));
var res = (function (){try{return function$.call(null,argument);
}catch (e25084){var e = e25084;
fluree.db.util.log.error.call(null,e,["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join(''));

throw cljs.core.ex_info.call(null,["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message.call(null,e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25085 = r__$1;
var G__25086 = cljs.core.assoc.call(null,acc__$2,k__$1,tuples__$1);
G__25064__$1 = G__25085;
acc__$1 = G__25086;
continue;
} else {
var G__25087 = r__$1;
var G__25088 = acc__$2;
G__25064__$1 = G__25087;
acc__$1 = G__25088;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25089,p__25090,opts){
var map__25091 = p__25089;
var map__25091__$1 = cljs.core.__destructure_map.call(null,map__25091);
var res = map__25091__$1;
var headers = cljs.core.get.call(null,map__25091__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25091__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25092 = p__25090;
var map__25092__$1 = cljs.core.__destructure_map.call(null,map__25092);
var select_spec = map__25092__$1;
var groupBy = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.call(null,map__25092__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25216){
var state_val_25217 = (state_25216[(1)]);
if((state_val_25217 === (7))){
var state_25216__$1 = state_25216;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25218_25291 = state_25216__$1;
(statearr_25218_25291[(1)] = (30));

} else {
var statearr_25219_25292 = state_25216__$1;
(statearr_25219_25292[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (20))){
var inst_25123 = (state_25216[(2)]);
var state_25216__$1 = (function (){var statearr_25220 = state_25216;
(statearr_25220[(7)] = inst_25123);

return statearr_25220;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25221_25293 = state_25216__$1;
(statearr_25221_25293[(1)] = (21));

} else {
var statearr_25222_25294 = state_25216__$1;
(statearr_25222_25294[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (27))){
var inst_25149 = (state_25216[(8)]);
var state_25216__$1 = state_25216;
var statearr_25223_25295 = state_25216__$1;
(statearr_25223_25295[(2)] = inst_25149);

(statearr_25223_25295[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (1))){
var state_25216__$1 = state_25216;
var statearr_25224_25296 = state_25216__$1;
(statearr_25224_25296[(2)] = null);

(statearr_25224_25296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (24))){
var inst_25160 = (state_25216[(9)]);
var inst_25148 = (state_25216[(10)]);
var inst_25157 = cljs.core.seq.call(null,inst_25148);
var inst_25158 = cljs.core.first.call(null,inst_25157);
var inst_25159 = cljs.core.next.call(null,inst_25157);
var inst_25160__$1 = cljs.core.nth.call(null,inst_25158,(0),null);
var inst_25161 = cljs.core.nth.call(null,inst_25158,(1),null);
var state_25216__$1 = (function (){var statearr_25225 = state_25216;
(statearr_25225[(11)] = inst_25159);

(statearr_25225[(9)] = inst_25160__$1);

(statearr_25225[(12)] = inst_25161);

return statearr_25225;
})();
if(cljs.core.truth_(inst_25160__$1)){
var statearr_25226_25297 = state_25216__$1;
(statearr_25226_25297[(1)] = (26));

} else {
var statearr_25227_25298 = state_25216__$1;
(statearr_25227_25298[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (39))){
var inst_25197 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25228_25299 = state_25216__$1;
(statearr_25228_25299[(2)] = inst_25197);

(statearr_25228_25299[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (4))){
var inst_25093 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25229_25300 = state_25216__$1;
(statearr_25229_25300[(2)] = inst_25093);

(statearr_25229_25300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (15))){
var inst_25113 = (state_25216[(13)]);
var inst_25115 = cljs.core.drop.call(null,offset,inst_25113);
var state_25216__$1 = state_25216;
var statearr_25230_25301 = state_25216__$1;
(statearr_25230_25301[(2)] = inst_25115);

(statearr_25230_25301[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (21))){
var inst_25123 = (state_25216[(7)]);
var inst_25125 = cljs.core.take.call(null,(1),inst_25123);
var state_25216__$1 = state_25216;
var statearr_25231_25302 = state_25216__$1;
(statearr_25231_25302[(2)] = inst_25125);

(statearr_25231_25302[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (31))){
var state_25216__$1 = state_25216;
var statearr_25232_25303 = state_25216__$1;
(statearr_25232_25303[(2)] = limit);

(statearr_25232_25303[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (32))){
var inst_25183 = (state_25216[(2)]);
var inst_25184 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25183,opts);
var state_25216__$1 = state_25216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25216__$1,(33),inst_25184);
} else {
if((state_val_25217 === (40))){
var inst_25187 = (state_25216[(14)]);
var inst_25200 = cljs.core.first.call(null,inst_25187);
var state_25216__$1 = state_25216;
var statearr_25233_25304 = state_25216__$1;
(statearr_25233_25304[(2)] = inst_25200);

(statearr_25233_25304[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (33))){
var inst_25187 = (state_25216[(14)]);
var inst_25186 = (state_25216[(2)]);
var inst_25187__$1 = fluree.db.util.async.throw_err.call(null,inst_25186);
var inst_25188 = cljs.core.coll_QMARK_.call(null,inst_25187__$1);
var inst_25189 = (!(inst_25188));
var state_25216__$1 = (function (){var statearr_25234 = state_25216;
(statearr_25234[(14)] = inst_25187__$1);

return statearr_25234;
})();
if(inst_25189){
var statearr_25235_25305 = state_25216__$1;
(statearr_25235_25305[(1)] = (34));

} else {
var statearr_25236_25306 = state_25216__$1;
(statearr_25236_25306[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (13))){
var inst_25108 = (state_25216[(15)]);
var state_25216__$1 = state_25216;
var statearr_25237_25307 = state_25216__$1;
(statearr_25237_25307[(2)] = inst_25108);

(statearr_25237_25307[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (22))){
var inst_25123 = (state_25216[(7)]);
var state_25216__$1 = state_25216;
var statearr_25238_25308 = state_25216__$1;
(statearr_25238_25308[(2)] = inst_25123);

(statearr_25238_25308[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (36))){
var inst_25209 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25239_25309 = state_25216__$1;
(statearr_25239_25309[(2)] = inst_25209);

(statearr_25239_25309[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (41))){
var state_25216__$1 = state_25216;
var statearr_25240_25310 = state_25216__$1;
(statearr_25240_25310[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (43))){
var inst_25187 = (state_25216[(14)]);
var state_25216__$1 = state_25216;
var statearr_25242_25311 = state_25216__$1;
(statearr_25242_25311[(2)] = inst_25187);

(statearr_25242_25311[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (29))){
var inst_25159 = (state_25216[(11)]);
var inst_25160 = (state_25216[(9)]);
var inst_25149 = (state_25216[(8)]);
var inst_25170 = (state_25216[(2)]);
var inst_25171 = fluree.db.util.async.throw_err.call(null,inst_25170);
var inst_25172 = cljs.core.assoc.call(null,inst_25149,inst_25160,inst_25171);
var inst_25148 = inst_25159;
var inst_25149__$1 = inst_25172;
var state_25216__$1 = (function (){var statearr_25243 = state_25216;
(statearr_25243[(10)] = inst_25148);

(statearr_25243[(8)] = inst_25149__$1);

return statearr_25243;
})();
var statearr_25244_25312 = state_25216__$1;
(statearr_25244_25312[(2)] = null);

(statearr_25244_25312[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (44))){
var state_25216__$1 = state_25216;
var statearr_25245_25313 = state_25216__$1;
(statearr_25245_25313[(2)] = null);

(statearr_25245_25313[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (6))){
var inst_25100 = (state_25216[(16)]);
var inst_25100__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25102 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25216__$1 = (function (){var statearr_25246 = state_25216;
(statearr_25246[(16)] = inst_25100__$1);

(statearr_25246[(17)] = inst_25102);

return statearr_25246;
})();
if(cljs.core.truth_(inst_25100__$1)){
var statearr_25247_25314 = state_25216__$1;
(statearr_25247_25314[(1)] = (9));

} else {
var statearr_25248_25315 = state_25216__$1;
(statearr_25248_25315[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (28))){
var inst_25176 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25249_25316 = state_25216__$1;
(statearr_25249_25316[(2)] = inst_25176);

(statearr_25249_25316[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (25))){
var inst_25178 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25250_25317 = state_25216__$1;
(statearr_25250_25317[(2)] = inst_25178);

(statearr_25250_25317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (34))){
var state_25216__$1 = state_25216;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25251_25318 = state_25216__$1;
(statearr_25251_25318[(1)] = (37));

} else {
var statearr_25252_25319 = state_25216__$1;
(statearr_25252_25319[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (17))){
var inst_25118 = (state_25216[(2)]);
var state_25216__$1 = (function (){var statearr_25253 = state_25216;
(statearr_25253[(18)] = inst_25118);

return statearr_25253;
})();
if(cljs.core.truth_(limit)){
var statearr_25254_25320 = state_25216__$1;
(statearr_25254_25320[(1)] = (18));

} else {
var statearr_25255_25321 = state_25216__$1;
(statearr_25255_25321[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (3))){
var inst_25214 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25216__$1,inst_25214);
} else {
if((state_val_25217 === (12))){
var inst_25108 = (state_25216[(15)]);
var inst_25110 = fluree.db.query.fql.filter_having.call(null,having,headers,inst_25108);
var state_25216__$1 = state_25216;
var statearr_25256_25322 = state_25216__$1;
(statearr_25256_25322[(2)] = inst_25110);

(statearr_25256_25322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (2))){
var _ = (function (){var statearr_25257 = state_25216;
(statearr_25257[(4)] = cljs.core.cons.call(null,(5),(state_25216[(4)])));

return statearr_25257;
})();
var state_25216__$1 = state_25216;
if(cljs.core.truth_(groupBy)){
var statearr_25258_25323 = state_25216__$1;
(statearr_25258_25323[(1)] = (6));

} else {
var statearr_25259_25324 = state_25216__$1;
(statearr_25259_25324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (23))){
var inst_25128 = (state_25216[(2)]);
var inst_25142 = cljs.core.seq.call(null,inst_25128);
var inst_25143 = cljs.core.first.call(null,inst_25142);
var inst_25144 = cljs.core.next.call(null,inst_25142);
var inst_25145 = cljs.core.nth.call(null,inst_25143,(0),null);
var inst_25146 = cljs.core.nth.call(null,inst_25143,(1),null);
var inst_25147 = cljs.core.PersistentHashMap.EMPTY;
var inst_25148 = inst_25128;
var inst_25149 = inst_25147;
var state_25216__$1 = (function (){var statearr_25260 = state_25216;
(statearr_25260[(19)] = inst_25146);

(statearr_25260[(10)] = inst_25148);

(statearr_25260[(8)] = inst_25149);

(statearr_25260[(20)] = inst_25145);

(statearr_25260[(21)] = inst_25144);

return statearr_25260;
})();
var statearr_25261_25325 = state_25216__$1;
(statearr_25261_25325[(2)] = null);

(statearr_25261_25325[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (35))){
var state_25216__$1 = state_25216;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25262_25326 = state_25216__$1;
(statearr_25262_25326[(1)] = (40));

} else {
var statearr_25263_25327 = state_25216__$1;
(statearr_25263_25327[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (19))){
var inst_25118 = (state_25216[(18)]);
var state_25216__$1 = state_25216;
var statearr_25264_25328 = state_25216__$1;
(statearr_25264_25328[(2)] = inst_25118);

(statearr_25264_25328[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (11))){
var inst_25108 = (state_25216[(2)]);
var state_25216__$1 = (function (){var statearr_25266 = state_25216;
(statearr_25266[(15)] = inst_25108);

return statearr_25266;
})();
if(cljs.core.truth_(having)){
var statearr_25267_25329 = state_25216__$1;
(statearr_25267_25329[(1)] = (12));

} else {
var statearr_25268_25330 = state_25216__$1;
(statearr_25268_25330[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (9))){
var inst_25100 = (state_25216[(16)]);
var inst_25102 = (state_25216[(17)]);
var inst_25104 = cljs.core.sorted_map_by.call(null,inst_25100);
var inst_25105 = cljs.core.into.call(null,inst_25104,inst_25102);
var state_25216__$1 = state_25216;
var statearr_25269_25331 = state_25216__$1;
(statearr_25269_25331[(2)] = inst_25105);

(statearr_25269_25331[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (5))){
var _ = (function (){var statearr_25270 = state_25216;
(statearr_25270[(4)] = cljs.core.rest.call(null,(state_25216[(4)])));

return statearr_25270;
})();
var state_25216__$1 = state_25216;
var ex25265 = (state_25216__$1[(2)]);
var statearr_25271_25332 = state_25216__$1;
(statearr_25271_25332[(5)] = ex25265);


if((ex25265 instanceof Error)){
var statearr_25272_25333 = state_25216__$1;
(statearr_25272_25333[(1)] = (4));

(statearr_25272_25333[(5)] = null);

} else {
throw ex25265;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (14))){
var inst_25113 = (state_25216[(2)]);
var state_25216__$1 = (function (){var statearr_25273 = state_25216;
(statearr_25273[(13)] = inst_25113);

return statearr_25273;
})();
if(cljs.core.truth_(offset)){
var statearr_25274_25334 = state_25216__$1;
(statearr_25274_25334[(1)] = (15));

} else {
var statearr_25275_25335 = state_25216__$1;
(statearr_25275_25335[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (45))){
var inst_25205 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25276_25336 = state_25216__$1;
(statearr_25276_25336[(2)] = inst_25205);

(statearr_25276_25336[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (26))){
var inst_25161 = (state_25216[(12)]);
var inst_25163 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25164 = [headers,vars,inst_25161];
var inst_25165 = cljs.core.PersistentHashMap.fromArrays(inst_25163,inst_25164);
var inst_25166 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25167 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25168 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25165,inst_25166,inst_25167);
var state_25216__$1 = state_25216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25216__$1,(29),inst_25168);
} else {
if((state_val_25217 === (16))){
var inst_25113 = (state_25216[(13)]);
var state_25216__$1 = state_25216;
var statearr_25277_25337 = state_25216__$1;
(statearr_25277_25337[(2)] = inst_25113);

(statearr_25277_25337[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (38))){
var inst_25187 = (state_25216[(14)]);
var state_25216__$1 = state_25216;
var statearr_25278_25338 = state_25216__$1;
(statearr_25278_25338[(2)] = inst_25187);

(statearr_25278_25338[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (30))){
var state_25216__$1 = state_25216;
var statearr_25279_25339 = state_25216__$1;
(statearr_25279_25339[(2)] = (1));

(statearr_25279_25339[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (10))){
var inst_25102 = (state_25216[(17)]);
var state_25216__$1 = state_25216;
var statearr_25280_25340 = state_25216__$1;
(statearr_25280_25340[(2)] = inst_25102);

(statearr_25280_25340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (18))){
var inst_25118 = (state_25216[(18)]);
var inst_25120 = cljs.core.take.call(null,limit,inst_25118);
var state_25216__$1 = state_25216;
var statearr_25281_25341 = state_25216__$1;
(statearr_25281_25341[(2)] = inst_25120);

(statearr_25281_25341[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (42))){
var inst_25207 = (state_25216[(2)]);
var state_25216__$1 = state_25216;
var statearr_25282_25342 = state_25216__$1;
(statearr_25282_25342[(2)] = inst_25207);

(statearr_25282_25342[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (37))){
var inst_25187 = (state_25216[(14)]);
var inst_25192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25193 = [inst_25187];
var inst_25194 = (new cljs.core.PersistentVector(null,1,(5),inst_25192,inst_25193,null));
var state_25216__$1 = state_25216;
var statearr_25283_25343 = state_25216__$1;
(statearr_25283_25343[(2)] = inst_25194);

(statearr_25283_25343[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25217 === (8))){
var inst_25211 = (state_25216[(2)]);
var _ = (function (){var statearr_25284 = state_25216;
(statearr_25284[(4)] = cljs.core.rest.call(null,(state_25216[(4)])));

return statearr_25284;
})();
var state_25216__$1 = state_25216;
var statearr_25285_25344 = state_25216__$1;
(statearr_25285_25344[(2)] = inst_25211);

(statearr_25285_25344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_25286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25286[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_25286[(1)] = (1));

return statearr_25286;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_25216){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25287){var ex__2749__auto__ = e25287;
var statearr_25288_25345 = state_25216;
(statearr_25288_25345[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25216[(4)]))){
var statearr_25289_25346 = state_25216;
(statearr_25289_25346[(1)] = cljs.core.first.call(null,(state_25216[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25347 = state_25216;
state_25216 = G__25347;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_25216){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_25216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25290 = f__2769__auto__.call(null);
(statearr_25290[(6)] = c__2768__auto__);

return statearr_25290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25408){
var state_val_25409 = (state_25408[(1)]);
if((state_val_25409 === (7))){
var state_25408__$1 = state_25408;
var statearr_25410_25448 = state_25408__$1;
(statearr_25410_25448[(2)] = (0));

(statearr_25410_25448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (20))){
var inst_25392 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25411_25449 = state_25408__$1;
(statearr_25411_25449[(2)] = inst_25392);

(statearr_25411_25449[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (1))){
var state_25408__$1 = state_25408;
var statearr_25412_25450 = state_25408__$1;
(statearr_25412_25450[(2)] = null);

(statearr_25412_25450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (4))){
var inst_25348 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25413_25451 = state_25408__$1;
(statearr_25413_25451[(2)] = inst_25348);

(statearr_25413_25451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (15))){
var inst_25379 = (state_25408[(7)]);
var state_25408__$1 = state_25408;
var statearr_25414_25452 = state_25408__$1;
(statearr_25414_25452[(2)] = inst_25379);

(statearr_25414_25452[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (21))){
var inst_25379 = (state_25408[(7)]);
var inst_25364 = (state_25408[(8)]);
var inst_25394 = (state_25408[(9)]);
var inst_25397 = (state_25408[(2)]);
var inst_25398 = fluree.db.util.async.throw_err.call(null,inst_25397);
var inst_25399 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25400 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_25394,inst_25379,inst_25398,inst_25399,inst_25364);
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25408__$1,(22),inst_25400);
} else {
if((state_val_25409 === (13))){
var inst_25379 = (state_25408[(7)]);
var state_25408__$1 = state_25408;
if(cljs.core.truth_(inst_25379)){
var statearr_25415_25453 = state_25408__$1;
(statearr_25415_25453[(1)] = (15));

} else {
var statearr_25416_25454 = state_25408__$1;
(statearr_25416_25454[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (22))){
var inst_25402 = (state_25408[(2)]);
var inst_25403 = fluree.db.util.async.throw_err.call(null,inst_25402);
var _ = (function (){var statearr_25417 = state_25408;
(statearr_25417[(4)] = cljs.core.rest.call(null,(state_25408[(4)])));

return statearr_25417;
})();
var state_25408__$1 = state_25408;
var statearr_25418_25455 = state_25408__$1;
(statearr_25418_25455[(2)] = inst_25403);

(statearr_25418_25455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (6))){
var inst_25359 = (state_25408[(10)]);
var state_25408__$1 = state_25408;
var statearr_25419_25456 = state_25408__$1;
(statearr_25419_25456[(2)] = inst_25359);

(statearr_25419_25456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (17))){
var inst_25387 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
if(cljs.core.truth_(inst_25387)){
var statearr_25420_25457 = state_25408__$1;
(statearr_25420_25457[(1)] = (18));

} else {
var statearr_25421_25458 = state_25408__$1;
(statearr_25421_25458[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (3))){
var inst_25406 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25408__$1,inst_25406);
} else {
if((state_val_25409 === (12))){
var inst_25380 = (state_25408[(11)]);
var state_25408__$1 = state_25408;
var statearr_25422_25459 = state_25408__$1;
(statearr_25422_25459[(2)] = inst_25380);

(statearr_25422_25459[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (2))){
var inst_25359 = (state_25408[(10)]);
var _ = (function (){var statearr_25423 = state_25408;
(statearr_25423[(4)] = cljs.core.cons.call(null,(5),(state_25408[(4)])));

return statearr_25423;
})();
var inst_25355 = query_map;
var inst_25356 = cljs.core.__destructure_map.call(null,inst_25355);
var inst_25357 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_25358 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25359__$1 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25360 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25361 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25362 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_25363 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_25364 = cljs.core.get.call(null,inst_25356,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_25366 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_25408__$1 = (function (){var statearr_25424 = state_25408;
(statearr_25424[(8)] = inst_25364);

(statearr_25424[(12)] = inst_25362);

(statearr_25424[(13)] = inst_25357);

(statearr_25424[(14)] = inst_25358);

(statearr_25424[(15)] = inst_25363);

(statearr_25424[(16)] = inst_25360);

(statearr_25424[(17)] = inst_25361);

(statearr_25424[(18)] = inst_25366);

(statearr_25424[(10)] = inst_25359__$1);

return statearr_25424;
})();
if(cljs.core.truth_(inst_25359__$1)){
var statearr_25425_25460 = state_25408__$1;
(statearr_25425_25460[(1)] = (6));

} else {
var statearr_25426_25461 = state_25408__$1;
(statearr_25426_25461[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (19))){
var state_25408__$1 = state_25408;
var statearr_25427_25462 = state_25408__$1;
(statearr_25427_25462[(2)] = null);

(statearr_25427_25462[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (11))){
var inst_25378 = (state_25408[(19)]);
var inst_25364 = (state_25408[(8)]);
var inst_25380 = (state_25408[(11)]);
var inst_25378__$1 = (state_25408[(2)]);
var inst_25379 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_25378__$1);
var inst_25380__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_25364);
var state_25408__$1 = (function (){var statearr_25429 = state_25408;
(statearr_25429[(7)] = inst_25379);

(statearr_25429[(19)] = inst_25378__$1);

(statearr_25429[(11)] = inst_25380__$1);

return statearr_25429;
})();
if(cljs.core.truth_(inst_25380__$1)){
var statearr_25430_25463 = state_25408__$1;
(statearr_25430_25463[(1)] = (12));

} else {
var statearr_25431_25464 = state_25408__$1;
(statearr_25431_25464[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (9))){
var inst_25373 = (state_25408[(20)]);
var inst_25375 = cljs.core.assoc.call(null,inst_25373,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_25408__$1 = state_25408;
var statearr_25432_25465 = state_25408__$1;
(statearr_25432_25465[(2)] = inst_25375);

(statearr_25432_25465[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (5))){
var _ = (function (){var statearr_25433 = state_25408;
(statearr_25433[(4)] = cljs.core.rest.call(null,(state_25408[(4)])));

return statearr_25433;
})();
var state_25408__$1 = state_25408;
var ex25428 = (state_25408__$1[(2)]);
var statearr_25434_25466 = state_25408__$1;
(statearr_25434_25466[(5)] = ex25428);


if((ex25428 instanceof Error)){
var statearr_25435_25467 = state_25408__$1;
(statearr_25435_25467[(1)] = (4));

(statearr_25435_25467[(5)] = null);

} else {
throw ex25428;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (14))){
var inst_25379 = (state_25408[(7)]);
var inst_25378 = (state_25408[(19)]);
var inst_25394 = (state_25408[(9)]);
var inst_25394__$1 = (state_25408[(2)]);
var inst_25395 = fluree.db.query.analytical.q.call(null,query_map,inst_25394__$1,inst_25379,db,inst_25378);
var state_25408__$1 = (function (){var statearr_25436 = state_25408;
(statearr_25436[(9)] = inst_25394__$1);

return statearr_25436;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25408__$1,(21),inst_25395);
} else {
if((state_val_25409 === (16))){
var inst_25364 = (state_25408[(8)]);
var inst_25385 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_25364);
var state_25408__$1 = state_25408;
var statearr_25437_25468 = state_25408__$1;
(statearr_25437_25468[(2)] = inst_25385);

(statearr_25437_25468[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (10))){
var inst_25373 = (state_25408[(20)]);
var state_25408__$1 = state_25408;
var statearr_25438_25469 = state_25408__$1;
(statearr_25438_25469[(2)] = inst_25373);

(statearr_25438_25469[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (18))){
var inst_25389 = cljs.core.volatile_BANG_.call(null,(0));
var state_25408__$1 = state_25408;
var statearr_25439_25470 = state_25408__$1;
(statearr_25439_25470[(2)] = inst_25389);

(statearr_25439_25470[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (8))){
var inst_25364 = (state_25408[(8)]);
var inst_25362 = (state_25408[(12)]);
var inst_25357 = (state_25408[(13)]);
var inst_25358 = (state_25408[(14)]);
var inst_25363 = (state_25408[(15)]);
var inst_25360 = (state_25408[(16)]);
var inst_25361 = (state_25408[(17)]);
var inst_25366 = (state_25408[(18)]);
var inst_25370 = (state_25408[(2)]);
var inst_25371 = [inst_25358,inst_25370,inst_25360,inst_25361,inst_25362,inst_25363];
var inst_25372 = cljs.core.PersistentHashMap.fromArrays(inst_25366,inst_25371);
var inst_25373 = cljs.core.merge.call(null,inst_25372,inst_25364);
var state_25408__$1 = (function (){var statearr_25440 = state_25408;
(statearr_25440[(20)] = inst_25373);

return statearr_25440;
})();
if(cljs.core.truth_(inst_25357)){
var statearr_25441_25471 = state_25408__$1;
(statearr_25441_25471[(1)] = (9));

} else {
var statearr_25442_25472 = state_25408__$1;
(statearr_25442_25472[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25443 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25443[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__);

(statearr_25443[(1)] = (1));

return statearr_25443;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_25408){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25444){var ex__2749__auto__ = e25444;
var statearr_25445_25473 = state_25408;
(statearr_25445_25473[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25408[(4)]))){
var statearr_25446_25474 = state_25408;
(statearr_25446_25474[(1)] = cljs.core.first.call(null,(state_25408[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25475 = state_25408;
state_25408 = G__25475;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = function(state_25408){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_25408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25447 = f__2769__auto__.call(null);
(statearr_25447[(6)] = c__2768__auto__);

return statearr_25447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25476,p__25477){
var map__25478 = p__25476;
var map__25478__$1 = cljs.core.__destructure_map.call(null,map__25478);
var db = map__25478__$1;
var network = cljs.core.get.call(null,map__25478__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__25478__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__25478__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__25478__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__25478__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25479 = p__25477;
var map__25479__$1 = cljs.core.__destructure_map.call(null,map__25479);
var query_map = map__25479__$1;
var opts = cljs.core.get.call(null,map__25479__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___25496 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25489){
var state_val_25490 = (state_25489[(1)]);
if((state_val_25490 === (1))){
var inst_25480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25481 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25482 = (new cljs.core.PersistentVector(null,2,(5),inst_25480,inst_25481,null));
var inst_25483 = cljs.core.assoc_in.call(null,query_map,inst_25482,false);
var inst_25484 = fluree.db.query.fql.query.call(null,db,inst_25483);
var state_25489__$1 = state_25489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25489__$1,(2),inst_25484);
} else {
if((state_val_25490 === (2))){
var inst_25486 = (state_25489[(2)]);
var inst_25487 = cljs.core.async.put_BANG_.call(null,pc,inst_25486);
var state_25489__$1 = state_25489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25489__$1,inst_25487);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25491 = [null,null,null,null,null,null,null];
(statearr_25491[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2746__auto__);

(statearr_25491[(1)] = (1));

return statearr_25491;
});
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1 = (function (state_25489){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25492){var ex__2749__auto__ = e25492;
var statearr_25493_25497 = state_25489;
(statearr_25493_25497[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25489[(4)]))){
var statearr_25494_25498 = state_25489;
(statearr_25494_25498[(1)] = cljs.core.first.call(null,(state_25489[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25499 = state_25489;
state_25489 = G__25499;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = function(state_25489){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1.call(this,state_25489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25495 = f__2769__auto__.call(null);
(statearr_25495[(6)] = c__2768__auto___25496);

return statearr_25495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25500){
var map__25501 = p__25500;
var map__25501__$1 = cljs.core.__destructure_map.call(null,map__25501);
var _query_map = map__25501__$1;
var opts = cljs.core.get.call(null,map__25501__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
