// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20026){var e = e20026;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20027_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20027_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20027_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20027_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20028_SHARP_){
return cljs.core.conj.call(null,p1__20028_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20029_SHARP_){
return cljs.core.conj.call(null,p1__20029_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20034 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20034,(0),null);
var _ = cljs.core.nth.call(null,vec__20034,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20030_SHARP_){
return cljs.core.conj.call(null,p1__20030_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20037 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20037,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20037,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20031_SHARP_){
return cljs.core.conj.call(null,p1__20031_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20032_SHARP_){
return cljs.core.conj.call(null,p1__20032_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20033_SHARP_){
return cljs.core.conj.call(null,p1__20033_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.call(null,(function (tuple){
return cljs.core.map.call(null,(function (p1__20040_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20040_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,headers,var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20043,optional_QMARK_,fuel,max_fuel){
var map__20044 = p__20043;
var map__20044__$1 = cljs.core.__destructure_map.call(null,map__20044);
var res = map__20044__$1;
var vars = cljs.core.get.call(null,map__20044__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20110){
var state_val_20111 = (state_20110[(1)]);
if((state_val_20111 === (7))){
var inst_20099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20100 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20101 = cljs.core.conj.call(null,inst_20100,clause);
var inst_20102 = [null,inst_20101];
var inst_20103 = (new cljs.core.PersistentVector(null,2,(5),inst_20099,inst_20102,null));
var state_20110__$1 = state_20110;
var statearr_20112_20140 = state_20110__$1;
(statearr_20112_20140[(2)] = inst_20103);

(statearr_20112_20140[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (1))){
var state_20110__$1 = state_20110;
var statearr_20113_20141 = state_20110__$1;
(statearr_20113_20141[(2)] = null);

(statearr_20113_20141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (4))){
var inst_20045 = (state_20110[(2)]);
var state_20110__$1 = state_20110;
var statearr_20114_20142 = state_20110__$1;
(statearr_20114_20142[(2)] = inst_20045);

(statearr_20114_20142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (15))){
var inst_20088 = (state_20110[(2)]);
var inst_20089 = fluree.db.util.async.throw_err.call(null,inst_20088);
var inst_20090 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20089);
var inst_20091 = cljs.core.count.call(null,inst_20090);
var inst_20092 = fluree.db.query.analytical.add_fuel.call(null,inst_20091,fuel,max_fuel);
var inst_20093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20094 = [inst_20089,r];
var inst_20095 = (new cljs.core.PersistentVector(null,2,(5),inst_20093,inst_20094,null));
var state_20110__$1 = (function (){var statearr_20115 = state_20110;
(statearr_20115[(7)] = inst_20092);

return statearr_20115;
})();
var statearr_20116_20143 = state_20110__$1;
(statearr_20116_20143[(2)] = inst_20095);

(statearr_20116_20143[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (13))){
var inst_20054 = (state_20110[(8)]);
var inst_20067 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20068 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20067);
var inst_20069 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20054);
var inst_20070 = cljs.core.apply.call(null,cljs.core.concat,inst_20069);
var inst_20071 = cljs.core.set.call(null,inst_20070);
var inst_20072 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20068);
var inst_20073 = cljs.core.apply.call(null,cljs.core.concat,inst_20072);
var inst_20074 = cljs.core.into.call(null,inst_20071,inst_20073);
var inst_20075 = (function (){var all_wd = inst_20054;
var optional = inst_20068;
var all_wd_vars = inst_20071;
var all_vars = inst_20074;
return (function (p1__20041_SHARP_){
return all_vars.call(null,p1__20041_SHARP_);
});
})();
var inst_20076 = cljs.core.keys.call(null,vars);
var inst_20077 = cljs.core.map.call(null,inst_20075,inst_20076);
var inst_20078 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20077);
var inst_20079 = cljs.core.set.call(null,inst_20078);
var inst_20080 = (function (){var all_wd = inst_20054;
var optional = inst_20068;
var all_wd_vars = inst_20071;
var all_vars = inst_20074;
var intersecting_vars = inst_20079;
return (function (p1__20042_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20042_SHARP_);
});
})();
var inst_20081 = cljs.core.map.call(null,inst_20080,inst_20054);
var inst_20082 = cljs.core.apply.call(null,cljs.core.concat,inst_20081);
var inst_20083 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20082,res);
var inst_20084 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20054,inst_20079,vars);
var inst_20085 = cljs.core.remove.call(null,inst_20079,inst_20074);
var inst_20086 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20084,inst_20082,inst_20083,inst_20085,inst_20068);
var state_20110__$1 = state_20110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20110__$1,(15),inst_20086);
} else {
if((state_val_20111 === (6))){
var inst_20055 = (state_20110[(9)]);
var inst_20053 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20054 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20053);
var inst_20055__$1 = optional_QMARK_;
var state_20110__$1 = (function (){var statearr_20117 = state_20110;
(statearr_20117[(9)] = inst_20055__$1);

(statearr_20117[(8)] = inst_20054);

return statearr_20117;
})();
if(cljs.core.truth_(inst_20055__$1)){
var statearr_20118_20144 = state_20110__$1;
(statearr_20118_20144[(1)] = (9));

} else {
var statearr_20119_20145 = state_20110__$1;
(statearr_20119_20145[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (3))){
var inst_20108 = (state_20110[(2)]);
var state_20110__$1 = state_20110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20110__$1,inst_20108);
} else {
if((state_val_20111 === (12))){
var inst_20063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20064 = [null,r];
var inst_20065 = (new cljs.core.PersistentVector(null,2,(5),inst_20063,inst_20064,null));
var state_20110__$1 = state_20110;
var statearr_20120_20146 = state_20110__$1;
(statearr_20120_20146[(2)] = inst_20065);

(statearr_20120_20146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (2))){
var _ = (function (){var statearr_20121 = state_20110;
(statearr_20121[(4)] = cljs.core.cons.call(null,(5),(state_20110[(4)])));

return statearr_20121;
})();
var inst_20051 = (r == null);
var state_20110__$1 = state_20110;
if(cljs.core.truth_(inst_20051)){
var statearr_20122_20147 = state_20110__$1;
(statearr_20122_20147[(1)] = (6));

} else {
var statearr_20123_20148 = state_20110__$1;
(statearr_20123_20148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (11))){
var inst_20061 = (state_20110[(2)]);
var state_20110__$1 = state_20110;
if(cljs.core.truth_(inst_20061)){
var statearr_20125_20149 = state_20110__$1;
(statearr_20125_20149[(1)] = (12));

} else {
var statearr_20126_20150 = state_20110__$1;
(statearr_20126_20150[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (9))){
var inst_20054 = (state_20110[(8)]);
var inst_20057 = cljs.core.empty_QMARK_.call(null,inst_20054);
var inst_20058 = (!(inst_20057));
var state_20110__$1 = state_20110;
var statearr_20127_20151 = state_20110__$1;
(statearr_20127_20151[(2)] = inst_20058);

(statearr_20127_20151[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (5))){
var _ = (function (){var statearr_20128 = state_20110;
(statearr_20128[(4)] = cljs.core.rest.call(null,(state_20110[(4)])));

return statearr_20128;
})();
var state_20110__$1 = state_20110;
var ex20124 = (state_20110__$1[(2)]);
var statearr_20129_20152 = state_20110__$1;
(statearr_20129_20152[(5)] = ex20124);


if((ex20124 instanceof Error)){
var statearr_20130_20153 = state_20110__$1;
(statearr_20130_20153[(1)] = (4));

(statearr_20130_20153[(5)] = null);

} else {
throw ex20124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (14))){
var inst_20097 = (state_20110[(2)]);
var state_20110__$1 = state_20110;
var statearr_20131_20154 = state_20110__$1;
(statearr_20131_20154[(2)] = inst_20097);

(statearr_20131_20154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (10))){
var inst_20055 = (state_20110[(9)]);
var state_20110__$1 = state_20110;
var statearr_20132_20155 = state_20110__$1;
(statearr_20132_20155[(2)] = inst_20055);

(statearr_20132_20155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20111 === (8))){
var inst_20105 = (state_20110[(2)]);
var _ = (function (){var statearr_20133 = state_20110;
(statearr_20133[(4)] = cljs.core.rest.call(null,(state_20110[(4)])));

return statearr_20133;
})();
var state_20110__$1 = state_20110;
var statearr_20134_20156 = state_20110__$1;
(statearr_20134_20156[(2)] = inst_20105);

(statearr_20134_20156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20135 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20135[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_20135[(1)] = (1));

return statearr_20135;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20110){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20136){var ex__2749__auto__ = e20136;
var statearr_20137_20157 = state_20110;
(statearr_20137_20157[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20110[(4)]))){
var statearr_20138_20158 = state_20110;
(statearr_20138_20158[(1)] = cljs.core.first.call(null,(state_20110[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20159 = state_20110;
state_20110 = G__20159;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_20110){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20139 = f__2769__auto__.call(null);
(statearr_20139[(6)] = c__2768__auto__);

return statearr_20139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20161 = arguments.length;
switch (G__20161) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20255){
var state_val_20256 = (state_20255[(1)]);
if((state_val_20256 === (7))){
var inst_20168 = (state_20255[(7)]);
var inst_20178 = clojure.string.starts_with_QMARK_.call(null,inst_20168,"$fdb");
var state_20255__$1 = state_20255;
if(inst_20178){
var statearr_20257_20306 = state_20255__$1;
(statearr_20257_20306[(1)] = (9));

} else {
var statearr_20258_20307 = state_20255__$1;
(statearr_20258_20307[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (20))){
var state_20255__$1 = state_20255;
var statearr_20259_20308 = state_20255__$1;
(statearr_20259_20308[(2)] = null);

(statearr_20259_20308[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (27))){
var inst_20218 = (state_20255[(8)]);
var state_20255__$1 = state_20255;
var statearr_20260_20309 = state_20255__$1;
(statearr_20260_20309[(2)] = inst_20218);

(statearr_20260_20309[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (1))){
var state_20255__$1 = state_20255;
var statearr_20261_20310 = state_20255__$1;
(statearr_20261_20310[(2)] = null);

(statearr_20261_20310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (24))){
var inst_20241 = (state_20255[(2)]);
var state_20255__$1 = state_20255;
var statearr_20262_20311 = state_20255__$1;
(statearr_20262_20311[(2)] = inst_20241);

(statearr_20262_20311[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (4))){
var inst_20162 = (state_20255[(2)]);
var state_20255__$1 = state_20255;
var statearr_20263_20312 = state_20255__$1;
(statearr_20263_20312[(2)] = inst_20162);

(statearr_20263_20312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (15))){
var inst_20185 = (state_20255[(9)]);
var inst_20191 = (state_20255[(2)]);
var inst_20192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20193 = cljs.core.PersistentVector.EMPTY;
var inst_20194 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20195 = cljs.core.into.call(null,inst_20193,inst_20194);
var inst_20196 = [inst_20185,inst_20195];
var inst_20197 = (new cljs.core.PersistentVector(null,2,(5),inst_20192,inst_20196,null));
var state_20255__$1 = (function (){var statearr_20264 = state_20255;
(statearr_20264[(10)] = inst_20191);

return statearr_20264;
})();
var statearr_20265_20313 = state_20255__$1;
(statearr_20265_20313[(2)] = inst_20197);

(statearr_20265_20313[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (21))){
var inst_20244 = (state_20255[(2)]);
var state_20255__$1 = state_20255;
var statearr_20266_20314 = state_20255__$1;
(statearr_20266_20314[(2)] = inst_20244);

(statearr_20266_20314[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (13))){
var inst_20185 = (state_20255[(9)]);
var inst_20188 = (function(){throw inst_20185})();
var state_20255__$1 = state_20255;
var statearr_20267_20315 = state_20255__$1;
(statearr_20267_20315[(2)] = inst_20188);

(statearr_20267_20315[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (22))){
var inst_20207 = (state_20255[(11)]);
var inst_20209 = (state_20255[(12)]);
var inst_20211 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20207);
var inst_20212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20213 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20209];
var inst_20214 = (new cljs.core.PersistentVector(null,2,(5),inst_20212,inst_20213,null));
var inst_20215 = cljs.core.get_in.call(null,opts,inst_20214);
var state_20255__$1 = (function (){var statearr_20268 = state_20255;
(statearr_20268[(13)] = inst_20211);

return statearr_20268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20255__$1,(25),inst_20215);
} else {
if((state_val_20256 === (29))){
var inst_20222 = (state_20255[(2)]);
var inst_20223 = fluree.db.util.async.throw_err.call(null,inst_20222);
var state_20255__$1 = state_20255;
var statearr_20269_20316 = state_20255__$1;
(statearr_20269_20316[(2)] = inst_20223);

(statearr_20269_20316[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (6))){
var inst_20171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20172 = cljs.core.PersistentVector.EMPTY;
var inst_20173 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20174 = cljs.core.into.call(null,inst_20172,inst_20173);
var inst_20175 = [db,inst_20174];
var inst_20176 = (new cljs.core.PersistentVector(null,2,(5),inst_20171,inst_20175,null));
var state_20255__$1 = state_20255;
var statearr_20270_20317 = state_20255__$1;
(statearr_20270_20317[(2)] = inst_20176);

(statearr_20270_20317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (28))){
var inst_20226 = (state_20255[(2)]);
var inst_20227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20228 = cljs.core.PersistentVector.EMPTY;
var inst_20229 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20230 = cljs.core.into.call(null,inst_20228,inst_20229);
var inst_20231 = [inst_20226,inst_20230];
var inst_20232 = (new cljs.core.PersistentVector(null,2,(5),inst_20227,inst_20231,null));
var state_20255__$1 = state_20255;
var statearr_20271_20318 = state_20255__$1;
(statearr_20271_20318[(2)] = inst_20232);

(statearr_20271_20318[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (25))){
var inst_20211 = (state_20255[(13)]);
var inst_20217 = (state_20255[(2)]);
var inst_20218 = fluree.db.util.async.throw_err.call(null,inst_20217);
var state_20255__$1 = (function (){var statearr_20272 = state_20255;
(statearr_20272[(8)] = inst_20218);

return statearr_20272;
})();
if(cljs.core.truth_(inst_20211)){
var statearr_20273_20319 = state_20255__$1;
(statearr_20273_20319[(1)] = (26));

} else {
var statearr_20274_20320 = state_20255__$1;
(statearr_20274_20320[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (17))){
var state_20255__$1 = state_20255;
var statearr_20275_20321 = state_20255__$1;
(statearr_20275_20321[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (3))){
var inst_20253 = (state_20255[(2)]);
var state_20255__$1 = state_20255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20255__$1,inst_20253);
} else {
if((state_val_20256 === (12))){
var inst_20185 = (state_20255[(9)]);
var inst_20184 = (state_20255[(2)]);
var inst_20185__$1 = fluree.db.util.async.throw_err.call(null,inst_20184);
var inst_20186 = fluree.db.util.core.exception_QMARK_.call(null,inst_20185__$1);
var state_20255__$1 = (function (){var statearr_20277 = state_20255;
(statearr_20277[(9)] = inst_20185__$1);

return statearr_20277;
})();
if(inst_20186){
var statearr_20278_20322 = state_20255__$1;
(statearr_20278_20322[(1)] = (13));

} else {
var statearr_20279_20323 = state_20255__$1;
(statearr_20279_20323[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (2))){
var inst_20168 = (state_20255[(7)]);
var _ = (function (){var statearr_20280 = state_20255;
(statearr_20280[(4)] = cljs.core.cons.call(null,(5),(state_20255[(4)])));

return statearr_20280;
})();
var inst_20168__$1 = cljs.core.first.call(null,clause);
var inst_20169 = cljs.core._EQ_.call(null,"$fdb",inst_20168__$1);
var state_20255__$1 = (function (){var statearr_20281 = state_20255;
(statearr_20281[(7)] = inst_20168__$1);

return statearr_20281;
})();
if(inst_20169){
var statearr_20282_20324 = state_20255__$1;
(statearr_20282_20324[(1)] = (6));

} else {
var statearr_20283_20325 = state_20255__$1;
(statearr_20283_20325[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (23))){
var inst_20168 = (state_20255[(7)]);
var inst_20234 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20168)," is not supported in Fluree"].join('');
var inst_20235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20236 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20237 = cljs.core.PersistentHashMap.fromArrays(inst_20235,inst_20236);
var inst_20238 = cljs.core.ex_info.call(null,inst_20234,inst_20237);
var inst_20239 = (function(){throw inst_20238})();
var state_20255__$1 = state_20255;
var statearr_20284_20326 = state_20255__$1;
(statearr_20284_20326[(2)] = inst_20239);

(statearr_20284_20326[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (19))){
var inst_20168 = (state_20255[(7)]);
var inst_20209 = (state_20255[(12)]);
var inst_20206 = fluree.db.query.analytical.isolate_source_name.call(null,inst_20168);
var inst_20207 = fluree.db.query.analytical.isolate_source_block.call(null,inst_20168);
var inst_20208 = cljs.core.keyword.call(null,inst_20206);
var inst_20209__$1 = cljs.core.get.call(null,prefixes,inst_20208);
var state_20255__$1 = (function (){var statearr_20285 = state_20255;
(statearr_20285[(11)] = inst_20207);

(statearr_20285[(12)] = inst_20209__$1);

return statearr_20285;
})();
if(cljs.core.truth_(inst_20209__$1)){
var statearr_20286_20327 = state_20255__$1;
(statearr_20286_20327[(1)] = (22));

} else {
var statearr_20287_20328 = state_20255__$1;
(statearr_20287_20328[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (11))){
var inst_20248 = (state_20255[(2)]);
var state_20255__$1 = state_20255;
var statearr_20289_20329 = state_20255__$1;
(statearr_20289_20329[(2)] = inst_20248);

(statearr_20289_20329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (9))){
var inst_20168 = (state_20255[(7)]);
var inst_20180 = cljs.core.subs.call(null,inst_20168,(4));
var inst_20181 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20180);
var inst_20182 = fluree.db.time_travel.as_of_block.call(null,db,inst_20181);
var state_20255__$1 = state_20255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20255__$1,(12),inst_20182);
} else {
if((state_val_20256 === (5))){
var _ = (function (){var statearr_20290 = state_20255;
(statearr_20290[(4)] = cljs.core.rest.call(null,(state_20255[(4)])));

return statearr_20290;
})();
var state_20255__$1 = state_20255;
var ex20288 = (state_20255__$1[(2)]);
var statearr_20291_20330 = state_20255__$1;
(statearr_20291_20330[(5)] = ex20288);


if((ex20288 instanceof Error)){
var statearr_20292_20331 = state_20255__$1;
(statearr_20292_20331[(1)] = (4));

(statearr_20292_20331[(5)] = null);

} else {
throw ex20288;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (14))){
var state_20255__$1 = state_20255;
var statearr_20293_20332 = state_20255__$1;
(statearr_20293_20332[(2)] = null);

(statearr_20293_20332[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (26))){
var inst_20218 = (state_20255[(8)]);
var inst_20211 = (state_20255[(13)]);
var inst_20220 = fluree.db.time_travel.as_of_block.call(null,inst_20218,inst_20211);
var state_20255__$1 = state_20255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20255__$1,(29),inst_20220);
} else {
if((state_val_20256 === (16))){
var inst_20201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20202 = ["$wd",clause];
var inst_20203 = (new cljs.core.PersistentVector(null,2,(5),inst_20201,inst_20202,null));
var state_20255__$1 = state_20255;
var statearr_20294_20333 = state_20255__$1;
(statearr_20294_20333[(2)] = inst_20203);

(statearr_20294_20333[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (10))){
var inst_20168 = (state_20255[(7)]);
var inst_20199 = cljs.core._EQ_.call(null,"$wd",inst_20168);
var state_20255__$1 = state_20255;
if(inst_20199){
var statearr_20295_20334 = state_20255__$1;
(statearr_20295_20334[(1)] = (16));

} else {
var statearr_20296_20335 = state_20255__$1;
(statearr_20296_20335[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (18))){
var inst_20246 = (state_20255[(2)]);
var state_20255__$1 = state_20255;
var statearr_20297_20336 = state_20255__$1;
(statearr_20297_20336[(2)] = inst_20246);

(statearr_20297_20336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20256 === (8))){
var inst_20250 = (state_20255[(2)]);
var _ = (function (){var statearr_20298 = state_20255;
(statearr_20298[(4)] = cljs.core.rest.call(null,(state_20255[(4)])));

return statearr_20298;
})();
var state_20255__$1 = state_20255;
var statearr_20299_20337 = state_20255__$1;
(statearr_20299_20337[(2)] = inst_20250);

(statearr_20299_20337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_20300 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20300[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_20300[(1)] = (1));

return statearr_20300;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_20255){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20301){var ex__2749__auto__ = e20301;
var statearr_20302_20338 = state_20255;
(statearr_20302_20338[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20255[(4)]))){
var statearr_20303_20339 = state_20255;
(statearr_20303_20339[(1)] = cljs.core.first.call(null,(state_20255[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20340 = state_20255;
state_20255 = G__20340;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_20255){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_20255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20304 = f__2769__auto__.call(null);
(statearr_20304[(6)] = c__2768__auto__);

return statearr_20304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__20341){
var vec__20342 = p__20341;
var sub = cljs.core.nth.call(null,vec__20342,(0),null);
var obj = cljs.core.nth.call(null,vec__20342,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__20345_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__20345_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__20349 = subjects;
var vec__20350 = G__20349;
var seq__20351 = cljs.core.seq.call(null,vec__20350);
var first__20352 = cljs.core.first.call(null,seq__20351);
var seq__20351__$1 = cljs.core.next.call(null,seq__20351);
var subject = first__20352;
var r = seq__20351__$1;
var acc = expanded_map;
var G__20349__$1 = G__20349;
var acc__$1 = acc;
while(true){
var vec__20356 = G__20349__$1;
var seq__20357 = cljs.core.seq.call(null,vec__20356);
var first__20358 = cljs.core.first.call(null,seq__20357);
var seq__20357__$1 = cljs.core.next.call(null,seq__20357);
var subject__$1 = first__20358;
var r__$1 = seq__20357__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20359 = r__$1;
var G__20360 = acc__$2;
G__20349__$1 = G__20359;
acc__$1 = G__20360;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__20349__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20356,seq__20357,first__20358,seq__20357__$1,subject__$1,r__$1,acc__$2,G__20349,vec__20350,seq__20351,first__20352,seq__20351__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20349__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20356,seq__20357,first__20358,seq__20357__$1,subject__$1,r__$1,acc__$2,G__20349,vec__20350,seq__20351,first__20352,seq__20351__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20349__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20356,seq__20357,first__20358,seq__20357__$1,subject__$1,r__$1,acc__$2,G__20349,vec__20350,seq__20351,first__20352,seq__20351__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20349__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20356,seq__20357,first__20358,seq__20357__$1,subject__$1,r__$1,acc__$2,G__20349,vec__20350,seq__20351,first__20352,seq__20351__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20349__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20356,seq__20357,first__20358,seq__20357__$1,subject__$1,r__$1,acc__$2,G__20349,vec__20350,seq__20351,first__20352,seq__20351__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20349__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20356,seq__20357,first__20358,seq__20357__$1,subject__$1,r__$1,acc__$2,G__20349,vec__20350,seq__20351,first__20352,seq__20351__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20361 = r__$1;
var G__20362 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20349__$1 = G__20361;
acc__$1 = G__20362;
continue;
} else {
var G__20363 = subjects;
var G__20364 = acc_STAR_;
G__20349__$1 = G__20363;
acc__$1 = G__20364;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__20365_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20365_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20456){
var state_val_20457 = (state_20456[(1)]);
if((state_val_20457 === (7))){
var state_20456__$1 = state_20456;
var statearr_20458_20504 = state_20456__$1;
(statearr_20458_20504[(2)] = (100));

(statearr_20458_20504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (20))){
var inst_20405 = (state_20456[(7)]);
var state_20456__$1 = state_20456;
var statearr_20459_20505 = state_20456__$1;
(statearr_20459_20505[(2)] = inst_20405);

(statearr_20459_20505[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (1))){
var state_20456__$1 = state_20456;
var statearr_20460_20506 = state_20456__$1;
(statearr_20460_20506[(2)] = null);

(statearr_20460_20506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (24))){
var inst_20443 = (state_20456[(8)]);
var inst_20444 = (state_20456[(9)]);
var inst_20377 = (state_20456[(10)]);
var inst_20442 = (state_20456[(11)]);
var inst_20447 = (function (){var max_depth = inst_20377;
var recur_map__$1 = inst_20443;
var subjects = inst_20442;
var tuples = inst_20444;
return (function (p1__20366_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__20366_SHARP_)],null));
});
})();
var inst_20448 = cljs.core.map.call(null,inst_20447,inst_20444);
var inst_20449 = cljs.core.distinct.call(null,inst_20448);
var state_20456__$1 = state_20456;
var statearr_20461_20507 = state_20456__$1;
(statearr_20461_20507[(2)] = inst_20449);

(statearr_20461_20507[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (4))){
var inst_20367 = (state_20456[(2)]);
var state_20456__$1 = state_20456;
var statearr_20462_20508 = state_20456__$1;
(statearr_20462_20508[(2)] = inst_20367);

(statearr_20462_20508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (15))){
var inst_20390 = (state_20456[(12)]);
var inst_20401 = cljs.core.PersistentVector.EMPTY;
var inst_20402 = cljs.core.seq.call(null,inst_20390);
var inst_20403 = cljs.core.first.call(null,inst_20402);
var inst_20404 = cljs.core.next.call(null,inst_20402);
var inst_20405 = inst_20401;
var inst_20406 = inst_20390;
var state_20456__$1 = (function (){var statearr_20463 = state_20456;
(statearr_20463[(13)] = inst_20404);

(statearr_20463[(14)] = inst_20403);

(statearr_20463[(15)] = inst_20406);

(statearr_20463[(7)] = inst_20405);

return statearr_20463;
})();
var statearr_20464_20509 = state_20456__$1;
(statearr_20464_20509[(2)] = null);

(statearr_20464_20509[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (21))){
var inst_20426 = (state_20456[(2)]);
var state_20456__$1 = state_20456;
var statearr_20465_20510 = state_20456__$1;
(statearr_20465_20510[(2)] = inst_20426);

(statearr_20465_20510[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (13))){
var inst_20439 = (state_20456[(2)]);
var state_20456__$1 = state_20456;
var statearr_20466_20511 = state_20456__$1;
(statearr_20466_20511[(2)] = inst_20439);

(statearr_20466_20511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (22))){
var inst_20405 = (state_20456[(7)]);
var inst_20413 = (state_20456[(16)]);
var inst_20420 = (state_20456[(2)]);
var inst_20421 = fluree.db.util.async.throw_err.call(null,inst_20420);
var inst_20422 = cljs.core.concat.call(null,inst_20405,inst_20421);
var inst_20405__$1 = inst_20422;
var inst_20406 = inst_20413;
var state_20456__$1 = (function (){var statearr_20467 = state_20456;
(statearr_20467[(15)] = inst_20406);

(statearr_20467[(7)] = inst_20405__$1);

return statearr_20467;
})();
var statearr_20468_20512 = state_20456__$1;
(statearr_20468_20512[(2)] = null);

(statearr_20468_20512[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (6))){
var inst_20373 = (state_20456[(17)]);
var state_20456__$1 = state_20456;
var statearr_20469_20513 = state_20456__$1;
(statearr_20469_20513[(2)] = inst_20373);

(statearr_20469_20513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (25))){
var inst_20451 = (state_20456[(2)]);
var _ = (function (){var statearr_20470 = state_20456;
(statearr_20470[(4)] = cljs.core.rest.call(null,(state_20456[(4)])));

return statearr_20470;
})();
var state_20456__$1 = state_20456;
var statearr_20471_20514 = state_20456__$1;
(statearr_20471_20514[(2)] = inst_20451);

(statearr_20471_20514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (17))){
var inst_20406 = (state_20456[(15)]);
var inst_20412 = (state_20456[(18)]);
var inst_20411 = cljs.core.seq.call(null,inst_20406);
var inst_20412__$1 = cljs.core.first.call(null,inst_20411);
var inst_20413 = cljs.core.next.call(null,inst_20411);
var state_20456__$1 = (function (){var statearr_20472 = state_20456;
(statearr_20472[(18)] = inst_20412__$1);

(statearr_20472[(16)] = inst_20413);

return statearr_20472;
})();
if(cljs.core.truth_(inst_20412__$1)){
var statearr_20473_20515 = state_20456__$1;
(statearr_20473_20515[(1)] = (19));

} else {
var statearr_20474_20516 = state_20456__$1;
(statearr_20474_20516[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (3))){
var inst_20454 = (state_20456[(2)]);
var state_20456__$1 = state_20456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20456__$1,inst_20454);
} else {
if((state_val_20457 === (12))){
var inst_20390 = (state_20456[(12)]);
var inst_20379 = (state_20456[(19)]);
var inst_20385 = cljs.core.vals.call(null,inst_20379);
var inst_20386 = cljs.core.flatten.call(null,inst_20385);
var inst_20387 = cljs.core.set.call(null,inst_20386);
var inst_20388 = cljs.core.keys.call(null,inst_20379);
var inst_20389 = cljs.core.set.call(null,inst_20388);
var inst_20390__$1 = clojure.set.difference.call(null,inst_20387,inst_20389);
var inst_20391 = cljs.core.empty_QMARK_.call(null,inst_20390__$1);
var state_20456__$1 = (function (){var statearr_20475 = state_20456;
(statearr_20475[(12)] = inst_20390__$1);

return statearr_20475;
})();
if(inst_20391){
var statearr_20476_20517 = state_20456__$1;
(statearr_20476_20517[(1)] = (14));

} else {
var statearr_20477_20518 = state_20456__$1;
(statearr_20477_20518[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (2))){
var inst_20373 = (state_20456[(17)]);
var _ = (function (){var statearr_20478 = state_20456;
(statearr_20478[(4)] = cljs.core.cons.call(null,(5),(state_20456[(4)])));

return statearr_20478;
})();
var inst_20373__$1 = depth;
var state_20456__$1 = (function (){var statearr_20479 = state_20456;
(statearr_20479[(17)] = inst_20373__$1);

return statearr_20479;
})();
if(cljs.core.truth_(inst_20373__$1)){
var statearr_20480_20519 = state_20456__$1;
(statearr_20480_20519[(1)] = (6));

} else {
var statearr_20481_20520 = state_20456__$1;
(statearr_20481_20520[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (23))){
var inst_20444 = (state_20456[(9)]);
var state_20456__$1 = state_20456;
var statearr_20482_20521 = state_20456__$1;
(statearr_20482_20521[(2)] = inst_20444);

(statearr_20482_20521[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (19))){
var inst_20412 = (state_20456[(18)]);
var inst_20415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20416 = [inst_20412,predicate];
var inst_20417 = (new cljs.core.PersistentVector(null,2,(5),inst_20415,inst_20416,null));
var inst_20418 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20417);
var state_20456__$1 = state_20456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20456__$1,(22),inst_20418);
} else {
if((state_val_20457 === (11))){
var inst_20379 = (state_20456[(19)]);
var state_20456__$1 = state_20456;
var statearr_20484_20522 = state_20456__$1;
(statearr_20484_20522[(2)] = inst_20379);

(statearr_20484_20522[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (9))){
var inst_20377 = (state_20456[(10)]);
var inst_20380 = (state_20456[(20)]);
var inst_20382 = (inst_20380 >= inst_20377);
var state_20456__$1 = state_20456;
if(cljs.core.truth_(inst_20382)){
var statearr_20485_20523 = state_20456__$1;
(statearr_20485_20523[(1)] = (11));

} else {
var statearr_20486_20524 = state_20456__$1;
(statearr_20486_20524[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (5))){
var _ = (function (){var statearr_20487 = state_20456;
(statearr_20487[(4)] = cljs.core.rest.call(null,(state_20456[(4)])));

return statearr_20487;
})();
var state_20456__$1 = state_20456;
var ex20483 = (state_20456__$1[(2)]);
var statearr_20488_20525 = state_20456__$1;
(statearr_20488_20525[(5)] = ex20483);


if((ex20483 instanceof Error)){
var statearr_20489_20526 = state_20456__$1;
(statearr_20489_20526[(1)] = (4));

(statearr_20489_20526[(5)] = null);

} else {
throw ex20483;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (14))){
var inst_20379 = (state_20456[(19)]);
var state_20456__$1 = state_20456;
var statearr_20490_20527 = state_20456__$1;
(statearr_20490_20527[(2)] = inst_20379);

(statearr_20490_20527[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (16))){
var inst_20437 = (state_20456[(2)]);
var state_20456__$1 = state_20456;
var statearr_20491_20528 = state_20456__$1;
(statearr_20491_20528[(2)] = inst_20437);

(statearr_20491_20528[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (10))){
var inst_20443 = (state_20456[(8)]);
var inst_20442 = (state_20456[(11)]);
var inst_20441 = (state_20456[(2)]);
var inst_20442__$1 = cljs.core.keys.call(null,inst_20441);
var inst_20443__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_20442__$1,inst_20441);
var inst_20444 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_20442__$1,inst_20443__$1);
var state_20456__$1 = (function (){var statearr_20492 = state_20456;
(statearr_20492[(8)] = inst_20443__$1);

(statearr_20492[(9)] = inst_20444);

(statearr_20492[(11)] = inst_20442__$1);

return statearr_20492;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20493_20529 = state_20456__$1;
(statearr_20493_20529[(1)] = (23));

} else {
var statearr_20494_20530 = state_20456__$1;
(statearr_20494_20530[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (18))){
var inst_20379 = (state_20456[(19)]);
var inst_20380 = (state_20456[(20)]);
var inst_20428 = (state_20456[(2)]);
var inst_20429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20430 = [(0),(2)];
var inst_20431 = (new cljs.core.PersistentVector(null,2,(5),inst_20429,inst_20430,null));
var inst_20432 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20431,inst_20428);
var inst_20433 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20379,inst_20432);
var inst_20434 = (inst_20380 + (1));
var inst_20379__$1 = inst_20433;
var inst_20380__$1 = inst_20434;
var state_20456__$1 = (function (){var statearr_20495 = state_20456;
(statearr_20495[(19)] = inst_20379__$1);

(statearr_20495[(20)] = inst_20380__$1);

return statearr_20495;
})();
var statearr_20496_20531 = state_20456__$1;
(statearr_20496_20531[(2)] = null);

(statearr_20496_20531[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20457 === (8))){
var inst_20377 = (state_20456[(2)]);
var inst_20378 = recur_map;
var inst_20379 = inst_20378;
var inst_20380 = (1);
var state_20456__$1 = (function (){var statearr_20497 = state_20456;
(statearr_20497[(10)] = inst_20377);

(statearr_20497[(19)] = inst_20379);

(statearr_20497[(20)] = inst_20380);

return statearr_20497;
})();
var statearr_20498_20532 = state_20456__$1;
(statearr_20498_20532[(2)] = null);

(statearr_20498_20532[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_20499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20499[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_20499[(1)] = (1));

return statearr_20499;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_20456){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20500){var ex__2749__auto__ = e20500;
var statearr_20501_20533 = state_20456;
(statearr_20501_20533[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20456[(4)]))){
var statearr_20502_20534 = state_20456;
(statearr_20502_20534[(1)] = cljs.core.first.call(null,(state_20456[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20535 = state_20456;
state_20456 = G__20535;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_20456){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_20456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20503 = f__2769__auto__.call(null);
(statearr_20503[(6)] = c__2768__auto__);

return statearr_20503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20536,clause,fuel,max_fuel){
var map__20537 = p__20536;
var map__20537__$1 = cljs.core.__destructure_map.call(null,map__20537);
var res = map__20537__$1;
var headers = cljs.core.get.call(null,map__20537__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20537__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__20537__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20648){
var state_val_20649 = (state_20648[(1)]);
if((state_val_20649 === (7))){
var inst_20554 = (state_20648[(7)]);
var state_20648__$1 = state_20648;
var statearr_20650_20703 = state_20648__$1;
(statearr_20650_20703[(2)] = inst_20554);

(statearr_20650_20703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (20))){
var inst_20582 = (state_20648[(8)]);
var inst_20613 = typeof inst_20582 === 'number';
var state_20648__$1 = state_20648;
if(cljs.core.truth_(inst_20613)){
var statearr_20651_20704 = state_20648__$1;
(statearr_20651_20704[(1)] = (22));

} else {
var statearr_20652_20705 = state_20648__$1;
(statearr_20652_20705[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (27))){
var inst_20628 = (state_20648[(2)]);
var state_20648__$1 = state_20648;
var statearr_20653_20706 = state_20648__$1;
(statearr_20653_20706[(2)] = inst_20628);

(statearr_20653_20706[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (1))){
var state_20648__$1 = state_20648;
var statearr_20654_20707 = state_20648__$1;
(statearr_20654_20707[(2)] = null);

(statearr_20654_20707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (24))){
var inst_20630 = (state_20648[(2)]);
var state_20648__$1 = state_20648;
var statearr_20655_20708 = state_20648__$1;
(statearr_20655_20708[(2)] = inst_20630);

(statearr_20655_20708[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (4))){
var inst_20538 = (state_20648[(2)]);
var state_20648__$1 = state_20648;
var statearr_20656_20709 = state_20648__$1;
(statearr_20656_20709[(2)] = inst_20538);

(statearr_20656_20709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (15))){
var inst_20596 = (state_20648[(2)]);
var inst_20597 = cljs.core.nth.call(null,clause,(2));
var inst_20598 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20597);
var state_20648__$1 = (function (){var statearr_20657 = state_20648;
(statearr_20657[(9)] = inst_20596);

return statearr_20657;
})();
if(cljs.core.truth_(inst_20598)){
var statearr_20658_20710 = state_20648__$1;
(statearr_20658_20710[(1)] = (16));

} else {
var statearr_20659_20711 = state_20648__$1;
(statearr_20659_20711[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (21))){
var inst_20584 = (state_20648[(10)]);
var inst_20585 = (state_20648[(11)]);
var inst_20555 = (state_20648[(12)]);
var inst_20632 = (state_20648[(2)]);
var inst_20633 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_20585,inst_20632,inst_20555,inst_20584);
var state_20648__$1 = state_20648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20648__$1,(28),inst_20633);
} else {
if((state_val_20649 === (13))){
var inst_20564 = (state_20648[(13)]);
var inst_20588 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20564)].join('');
var inst_20589 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20590 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20591 = cljs.core.PersistentHashMap.fromArrays(inst_20589,inst_20590);
var inst_20592 = cljs.core.ex_info.call(null,inst_20588,inst_20591);
var inst_20593 = (function(){throw inst_20592})();
var state_20648__$1 = state_20648;
var statearr_20660_20712 = state_20648__$1;
(statearr_20660_20712[(2)] = inst_20593);

(statearr_20660_20712[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (22))){
var inst_20582 = (state_20648[(8)]);
var inst_20580 = (state_20648[(14)]);
var inst_20615 = cljs.core.PersistentHashMap.EMPTY;
var inst_20616 = cljs.core.flatten.call(null,inst_20580);
var inst_20617 = cljs.core.assoc.call(null,inst_20615,inst_20582,inst_20616);
var state_20648__$1 = state_20648;
var statearr_20661_20713 = state_20648__$1;
(statearr_20661_20713[(2)] = inst_20617);

(statearr_20661_20713[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (6))){
var inst_20566 = (state_20648[(15)]);
var state_20648__$1 = state_20648;
var statearr_20662_20714 = state_20648__$1;
(statearr_20662_20714[(2)] = inst_20566);

(statearr_20662_20714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (28))){
var inst_20635 = (state_20648[(2)]);
var inst_20636 = fluree.db.util.async.throw_err.call(null,inst_20635);
var state_20648__$1 = state_20648;
var statearr_20663_20715 = state_20648__$1;
(statearr_20663_20715[(2)] = inst_20636);

(statearr_20663_20715[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (25))){
var inst_20580 = (state_20648[(14)]);
var inst_20576 = (state_20648[(16)]);
var inst_20621 = cljs.core.PersistentHashMap.EMPTY;
var inst_20622 = cljs.core.first.call(null,inst_20576);
var inst_20623 = cljs.core.first.call(null,inst_20622);
var inst_20624 = cljs.core.flatten.call(null,inst_20580);
var inst_20625 = cljs.core.assoc.call(null,inst_20621,inst_20623,inst_20624);
var state_20648__$1 = state_20648;
var statearr_20664_20716 = state_20648__$1;
(statearr_20664_20716[(2)] = inst_20625);

(statearr_20664_20716[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (17))){
var inst_20564 = (state_20648[(13)]);
var inst_20601 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20564)].join('');
var inst_20602 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20603 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20604 = cljs.core.PersistentHashMap.fromArrays(inst_20602,inst_20603);
var inst_20605 = cljs.core.ex_info.call(null,inst_20601,inst_20604);
var inst_20606 = (function(){throw inst_20605})();
var state_20648__$1 = state_20648;
var statearr_20665_20717 = state_20648__$1;
(statearr_20665_20717[(2)] = inst_20606);

(statearr_20665_20717[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (3))){
var inst_20646 = (state_20648[(2)]);
var state_20648__$1 = state_20648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20648__$1,inst_20646);
} else {
if((state_val_20649 === (12))){
var inst_20551 = (state_20648[(17)]);
var inst_20639 = (state_20648[(2)]);
var inst_20640 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20641 = cljs.core.keys.call(null,inst_20551);
var inst_20642 = [inst_20641,vars,inst_20639];
var inst_20643 = cljs.core.PersistentHashMap.fromArrays(inst_20640,inst_20642);
var _ = (function (){var statearr_20666 = state_20648;
(statearr_20666[(4)] = cljs.core.rest.call(null,(state_20648[(4)])));

return statearr_20666;
})();
var state_20648__$1 = state_20648;
var statearr_20667_20718 = state_20648__$1;
(statearr_20667_20718[(2)] = inst_20643);

(statearr_20667_20718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (2))){
var inst_20566 = (state_20648[(15)]);
var inst_20554 = (state_20648[(7)]);
var inst_20551 = (state_20648[(17)]);
var inst_20555 = (state_20648[(12)]);
var _ = (function (){var statearr_20668 = state_20648;
(statearr_20668[(4)] = cljs.core.cons.call(null,(5),(state_20648[(4)])));

return statearr_20668;
})();
var inst_20548 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_20549 = cljs.core.__destructure_map.call(null,inst_20548);
var inst_20550 = cljs.core.get.call(null,inst_20549,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20551__$1 = cljs.core.get.call(null,inst_20549,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20552 = cljs.core.get.call(null,inst_20549,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20553 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_20554__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20552);
var inst_20555__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20552);
var inst_20557 = (function (){var map__20544 = inst_20549;
var search = inst_20550;
var rel = inst_20551__$1;
var opts = inst_20552;
var common_keys = inst_20553;
var object_fn = inst_20554__$1;
var recur_depth = inst_20555__$1;
return (function (p__20556,common_key){
var vec__20669 = p__20556;
var acc = cljs.core.nth.call(null,vec__20669,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__20669,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20672 = cljs.core._EQ_;
var expr__20673 = idx_of;
if(cljs.core.truth_(pred__20672.call(null,(0),expr__20673))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__20672.call(null,(1),expr__20673))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__20672.call(null,(2),expr__20673))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20673)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20559 = cljs.core.PersistentHashMap.EMPTY;
var inst_20560 = [inst_20559,inst_20550];
var inst_20561 = (new cljs.core.PersistentVector(null,2,(5),inst_20558,inst_20560,null));
var inst_20562 = cljs.core.reduce.call(null,inst_20557,inst_20561,inst_20553);
var inst_20563 = cljs.core.nth.call(null,inst_20562,(0),null);
var inst_20564 = cljs.core.nth.call(null,inst_20562,(1),null);
var inst_20565 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20566__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20563);
var state_20648__$1 = (function (){var statearr_20675 = state_20648;
(statearr_20675[(15)] = inst_20566__$1);

(statearr_20675[(13)] = inst_20564);

(statearr_20675[(18)] = inst_20565);

(statearr_20675[(7)] = inst_20554__$1);

(statearr_20675[(17)] = inst_20551__$1);

(statearr_20675[(12)] = inst_20555__$1);

return statearr_20675;
})();
if(cljs.core.truth_(inst_20566__$1)){
var statearr_20676_20719 = state_20648__$1;
(statearr_20676_20719[(1)] = (6));

} else {
var statearr_20677_20720 = state_20648__$1;
(statearr_20677_20720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (23))){
var inst_20582 = (state_20648[(8)]);
var inst_20619 = cljs.core.coll_QMARK_.call(null,inst_20582);
var state_20648__$1 = state_20648;
if(inst_20619){
var statearr_20678_20721 = state_20648__$1;
(statearr_20678_20721[(1)] = (25));

} else {
var statearr_20679_20722 = state_20648__$1;
(statearr_20679_20722[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (19))){
var inst_20580 = (state_20648[(14)]);
var inst_20610 = cljs.core.PersistentHashMap.EMPTY;
var inst_20611 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20610,inst_20580);
var state_20648__$1 = state_20648;
var statearr_20680_20723 = state_20648__$1;
(statearr_20680_20723[(2)] = inst_20611);

(statearr_20680_20723[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (11))){
var inst_20580 = (state_20648[(14)]);
var state_20648__$1 = state_20648;
var statearr_20682_20724 = state_20648__$1;
(statearr_20682_20724[(2)] = inst_20580);

(statearr_20682_20724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (9))){
var inst_20551 = (state_20648[(17)]);
var inst_20576 = (state_20648[(16)]);
var inst_20555 = (state_20648[(12)]);
var inst_20575 = (state_20648[(2)]);
var inst_20576__$1 = fluree.db.util.async.throw_err.call(null,inst_20575);
var inst_20577 = cljs.core.count.call(null,inst_20576__$1);
var inst_20578 = fluree.db.query.analytical.add_fuel.call(null,inst_20577,fuel,max_fuel);
var inst_20579 = cljs.core.vals.call(null,inst_20551);
var inst_20580 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20579,inst_20576__$1);
var state_20648__$1 = (function (){var statearr_20683 = state_20648;
(statearr_20683[(14)] = inst_20580);

(statearr_20683[(19)] = inst_20578);

(statearr_20683[(16)] = inst_20576__$1);

return statearr_20683;
})();
if(cljs.core.truth_(inst_20555)){
var statearr_20684_20725 = state_20648__$1;
(statearr_20684_20725[(1)] = (10));

} else {
var statearr_20685_20726 = state_20648__$1;
(statearr_20685_20726[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (5))){
var _ = (function (){var statearr_20686 = state_20648;
(statearr_20686[(4)] = cljs.core.rest.call(null,(state_20648[(4)])));

return statearr_20686;
})();
var state_20648__$1 = state_20648;
var ex20681 = (state_20648__$1[(2)]);
var statearr_20687_20727 = state_20648__$1;
(statearr_20687_20727[(5)] = ex20681);


if((ex20681 instanceof Error)){
var statearr_20688_20728 = state_20648__$1;
(statearr_20688_20728[(1)] = (4));

(statearr_20688_20728[(5)] = null);

} else {
throw ex20681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (14))){
var state_20648__$1 = state_20648;
var statearr_20689_20729 = state_20648__$1;
(statearr_20689_20729[(2)] = null);

(statearr_20689_20729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (26))){
var state_20648__$1 = state_20648;
var statearr_20690_20730 = state_20648__$1;
(statearr_20690_20730[(2)] = null);

(statearr_20690_20730[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (16))){
var state_20648__$1 = state_20648;
var statearr_20691_20731 = state_20648__$1;
(statearr_20691_20731[(2)] = null);

(statearr_20691_20731[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (10))){
var inst_20564 = (state_20648[(13)]);
var inst_20585 = (state_20648[(11)]);
var inst_20582 = cljs.core.first.call(null,inst_20564);
var inst_20583 = cljs.core.first.call(null,clause);
var inst_20584 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20583);
var inst_20585__$1 = cljs.core.nth.call(null,inst_20564,(1));
var inst_20586 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20585__$1);
var state_20648__$1 = (function (){var statearr_20692 = state_20648;
(statearr_20692[(10)] = inst_20584);

(statearr_20692[(8)] = inst_20582);

(statearr_20692[(11)] = inst_20585__$1);

return statearr_20692;
})();
if(cljs.core.truth_(inst_20586)){
var statearr_20693_20732 = state_20648__$1;
(statearr_20693_20732[(1)] = (13));

} else {
var statearr_20694_20733 = state_20648__$1;
(statearr_20694_20733[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (18))){
var inst_20584 = (state_20648[(10)]);
var inst_20608 = (state_20648[(2)]);
var state_20648__$1 = (function (){var statearr_20695 = state_20648;
(statearr_20695[(20)] = inst_20608);

return statearr_20695;
})();
if(cljs.core.truth_(inst_20584)){
var statearr_20696_20734 = state_20648__$1;
(statearr_20696_20734[(1)] = (19));

} else {
var statearr_20697_20735 = state_20648__$1;
(statearr_20697_20735[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20649 === (8))){
var inst_20564 = (state_20648[(13)]);
var inst_20565 = (state_20648[(18)]);
var inst_20570 = (state_20648[(2)]);
var inst_20571 = [inst_20570];
var inst_20572 = cljs.core.PersistentHashMap.fromArrays(inst_20565,inst_20571);
var inst_20573 = fluree.db.query.range.search.call(null,db,inst_20564,inst_20572);
var state_20648__$1 = state_20648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20648__$1,(9),inst_20573);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20698 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20698[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_20698[(1)] = (1));

return statearr_20698;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20648){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20699){var ex__2749__auto__ = e20699;
var statearr_20700_20736 = state_20648;
(statearr_20700_20736[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20648[(4)]))){
var statearr_20701_20737 = state_20648;
(statearr_20701_20737[(1)] = cljs.core.first.call(null,(state_20648[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20738 = state_20648;
state_20648 = G__20738;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_20648){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20702 = f__2769__auto__.call(null);
(statearr_20702[(6)] = c__2768__auto__);

return statearr_20702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20739,res,clause){
var map__20740 = p__20739;
var map__20740__$1 = cljs.core.__destructure_map.call(null,map__20740);
var db = map__20740__$1;
var conn = cljs.core.get.call(null,map__20740__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__20740__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__20740__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20849){
var state_val_20850 = (state_20849[(1)]);
if((state_val_20850 === (7))){
var inst_20749 = (state_20849[(7)]);
var state_20849__$1 = state_20849;
var statearr_20851_20892 = state_20849__$1;
(statearr_20851_20892[(2)] = inst_20749);

(statearr_20851_20892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (20))){
var state_20849__$1 = state_20849;
var statearr_20852_20893 = state_20849__$1;
(statearr_20852_20893[(2)] = null);

(statearr_20852_20893[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (1))){
var state_20849__$1 = state_20849;
var statearr_20853_20894 = state_20849__$1;
(statearr_20853_20894[(2)] = null);

(statearr_20853_20894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (24))){
var inst_20751 = (state_20849[(8)]);
var inst_20822 = (state_20849[(2)]);
var inst_20823 = fluree.db.flake.sid__GT_cid.call(null,inst_20822);
var inst_20824 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20823);
var inst_20825 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20827 = [inst_20751];
var inst_20828 = (new cljs.core.PersistentVector(null,1,(5),inst_20826,inst_20827,null));
var inst_20829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20831 = [inst_20824];
var inst_20832 = (new cljs.core.PersistentVector(null,1,(5),inst_20830,inst_20831,null));
var inst_20833 = [inst_20832];
var inst_20834 = (new cljs.core.PersistentVector(null,1,(5),inst_20829,inst_20833,null));
var inst_20835 = cljs.core.PersistentHashMap.EMPTY;
var inst_20836 = [inst_20828,inst_20834,inst_20835];
var inst_20837 = cljs.core.PersistentHashMap.fromArrays(inst_20825,inst_20836);
var state_20849__$1 = state_20849;
var statearr_20854_20895 = state_20849__$1;
(statearr_20854_20895[(2)] = inst_20837);

(statearr_20854_20895[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (4))){
var inst_20742 = (state_20849[(2)]);
var state_20849__$1 = state_20849;
var statearr_20855_20896 = state_20849__$1;
(statearr_20855_20896[(2)] = inst_20742);

(statearr_20855_20896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (15))){
var inst_20751 = (state_20849[(8)]);
var inst_20749 = (state_20849[(7)]);
var inst_20770 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20771 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20773 = [inst_20749];
var inst_20774 = (new cljs.core.PersistentVector(null,1,(5),inst_20772,inst_20773,null));
var inst_20775 = (function (){var subject_var = inst_20749;
var object_var = inst_20751;
var min_sid = inst_20770;
var max_sid = (0);
return (function (p1__20741_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20741_SHARP_);
});
})();
var inst_20776 = cljs.core.range.call(null,inst_20770,(0));
var inst_20777 = cljs.core.map.call(null,inst_20775,inst_20776);
var inst_20778 = cljs.core.PersistentHashMap.EMPTY;
var inst_20779 = [inst_20774,inst_20777,inst_20778];
var inst_20780 = cljs.core.PersistentHashMap.fromArrays(inst_20771,inst_20779);
var state_20849__$1 = state_20849;
var statearr_20856_20897 = state_20849__$1;
(statearr_20856_20897[(2)] = inst_20780);

(statearr_20856_20897[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (21))){
var inst_20840 = (state_20849[(2)]);
var state_20849__$1 = state_20849;
var statearr_20857_20898 = state_20849__$1;
(statearr_20857_20898[(2)] = inst_20840);

(statearr_20857_20898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (13))){
var inst_20751 = (state_20849[(8)]);
var state_20849__$1 = state_20849;
if(cljs.core.truth_(inst_20751)){
var statearr_20858_20899 = state_20849__$1;
(statearr_20858_20899[(1)] = (19));

} else {
var statearr_20859_20900 = state_20849__$1;
(statearr_20859_20900[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (22))){
var inst_20813 = (state_20849[(9)]);
var state_20849__$1 = state_20849;
var statearr_20860_20901 = state_20849__$1;
(statearr_20860_20901[(2)] = inst_20813);

(statearr_20860_20901[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (6))){
var inst_20751 = (state_20849[(8)]);
var state_20849__$1 = state_20849;
var statearr_20861_20902 = state_20849__$1;
(statearr_20861_20902[(2)] = inst_20751);

(statearr_20861_20902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (25))){
var inst_20819 = (state_20849[(2)]);
var inst_20820 = fluree.db.util.async.throw_err.call(null,inst_20819);
var state_20849__$1 = state_20849;
var statearr_20862_20903 = state_20849__$1;
(statearr_20862_20903[(2)] = inst_20820);

(statearr_20862_20903[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (17))){
var inst_20810 = (state_20849[(2)]);
var state_20849__$1 = state_20849;
var statearr_20863_20904 = state_20849__$1;
(statearr_20863_20904[(2)] = inst_20810);

(statearr_20863_20904[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (3))){
var inst_20847 = (state_20849[(2)]);
var state_20849__$1 = state_20849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20849__$1,inst_20847);
} else {
if((state_val_20850 === (12))){
var inst_20764 = ["_tx",null,"_block",null];
var inst_20765 = (new cljs.core.PersistentArrayMap(null,2,inst_20764,null));
var inst_20766 = (new cljs.core.PersistentHashSet(null,inst_20765,null));
var inst_20767 = cljs.core.last.call(null,clause);
var inst_20768 = inst_20766.call(null,inst_20767);
var state_20849__$1 = state_20849;
if(cljs.core.truth_(inst_20768)){
var statearr_20864_20905 = state_20849__$1;
(statearr_20864_20905[(1)] = (15));

} else {
var statearr_20865_20906 = state_20849__$1;
(statearr_20865_20906[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (2))){
var inst_20749 = (state_20849[(7)]);
var _ = (function (){var statearr_20866 = state_20849;
(statearr_20866[(4)] = cljs.core.cons.call(null,(5),(state_20849[(4)])));

return statearr_20866;
})();
var inst_20748 = cljs.core.first.call(null,clause);
var inst_20749__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20748);
var inst_20750 = cljs.core.last.call(null,clause);
var inst_20751 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20750);
var state_20849__$1 = (function (){var statearr_20867 = state_20849;
(statearr_20867[(8)] = inst_20751);

(statearr_20867[(7)] = inst_20749__$1);

return statearr_20867;
})();
if(cljs.core.truth_(inst_20749__$1)){
var statearr_20868_20907 = state_20849__$1;
(statearr_20868_20907[(1)] = (6));

} else {
var statearr_20869_20908 = state_20849__$1;
(statearr_20869_20908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (23))){
var inst_20813 = (state_20849[(9)]);
var inst_20817 = fluree.db.dbproto._subid.call(null,db,inst_20813);
var state_20849__$1 = state_20849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20849__$1,(25),inst_20817);
} else {
if((state_val_20850 === (19))){
var inst_20813 = (state_20849[(9)]);
var inst_20813__$1 = cljs.core.first.call(null,clause);
var inst_20814 = typeof inst_20813__$1 === 'number';
var state_20849__$1 = (function (){var statearr_20870 = state_20849;
(statearr_20870[(9)] = inst_20813__$1);

return statearr_20870;
})();
if(cljs.core.truth_(inst_20814)){
var statearr_20871_20909 = state_20849__$1;
(statearr_20871_20909[(1)] = (22));

} else {
var statearr_20872_20910 = state_20849__$1;
(statearr_20872_20910[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (11))){
var inst_20844 = (state_20849[(2)]);
var _ = (function (){var statearr_20874 = state_20849;
(statearr_20874[(4)] = cljs.core.rest.call(null,(state_20849[(4)])));

return statearr_20874;
})();
var state_20849__$1 = state_20849;
var statearr_20875_20911 = state_20849__$1;
(statearr_20875_20911[(2)] = inst_20844);

(statearr_20875_20911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (9))){
var inst_20757 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20758 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20759 = cljs.core.PersistentHashMap.fromArrays(inst_20757,inst_20758);
var inst_20760 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_20759);
var inst_20761 = (function(){throw inst_20760})();
var state_20849__$1 = state_20849;
var statearr_20876_20912 = state_20849__$1;
(statearr_20876_20912[(2)] = inst_20761);

(statearr_20876_20912[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (5))){
var _ = (function (){var statearr_20877 = state_20849;
(statearr_20877[(4)] = cljs.core.rest.call(null,(state_20849[(4)])));

return statearr_20877;
})();
var state_20849__$1 = state_20849;
var ex20873 = (state_20849__$1[(2)]);
var statearr_20878_20913 = state_20849__$1;
(statearr_20878_20913[(5)] = ex20873);


if((ex20873 instanceof Error)){
var statearr_20879_20914 = state_20849__$1;
(statearr_20879_20914[(1)] = (4));

(statearr_20879_20914[(5)] = null);

} else {
throw ex20873;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (14))){
var inst_20842 = (state_20849[(2)]);
var state_20849__$1 = state_20849;
var statearr_20880_20915 = state_20849__$1;
(statearr_20880_20915[(2)] = inst_20842);

(statearr_20880_20915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (16))){
var inst_20783 = (state_20849[(10)]);
var inst_20785 = (state_20849[(11)]);
var inst_20786 = (state_20849[(12)]);
var inst_20782 = cljs.core.last.call(null,clause);
var inst_20783__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20782);
var inst_20784 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20785__$1 = cljs.core.get.call(null,inst_20784,inst_20783__$1);
var inst_20786__$1 = fluree.db.flake.min_subject_id.call(null,inst_20783__$1);
var inst_20787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20788 = [inst_20785__$1];
var inst_20789 = (new cljs.core.PersistentVector(null,1,(5),inst_20787,inst_20788,null));
var inst_20790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20791 = [inst_20786__$1];
var inst_20792 = (new cljs.core.PersistentVector(null,1,(5),inst_20790,inst_20791,null));
var inst_20793 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20789,cljs.core._LT__EQ_,inst_20792);
var state_20849__$1 = (function (){var statearr_20881 = state_20849;
(statearr_20881[(10)] = inst_20783__$1);

(statearr_20881[(11)] = inst_20785__$1);

(statearr_20881[(12)] = inst_20786__$1);

return statearr_20881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20849__$1,(18),inst_20793);
} else {
if((state_val_20850 === (10))){
var inst_20749 = (state_20849[(7)]);
var state_20849__$1 = state_20849;
if(cljs.core.truth_(inst_20749)){
var statearr_20882_20916 = state_20849__$1;
(statearr_20882_20916[(1)] = (12));

} else {
var statearr_20883_20917 = state_20849__$1;
(statearr_20883_20917[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (18))){
var inst_20783 = (state_20849[(10)]);
var inst_20785 = (state_20849[(11)]);
var inst_20751 = (state_20849[(8)]);
var inst_20749 = (state_20849[(7)]);
var inst_20786 = (state_20849[(12)]);
var inst_20795 = (state_20849[(2)]);
var inst_20796 = fluree.db.util.async.throw_err.call(null,inst_20795);
var inst_20797 = (function (){var subject_var = inst_20749;
var object_var = inst_20751;
var partition = inst_20783;
var max_sid = inst_20785;
var min_sid = inst_20786;
var flakes = inst_20796;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20798 = cljs.core.map.call(null,inst_20797);
var inst_20799 = cljs.core.distinct.call(null);
var inst_20800 = cljs.core.comp.call(null,inst_20798,inst_20799);
var inst_20801 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20803 = [inst_20749];
var inst_20804 = (new cljs.core.PersistentVector(null,1,(5),inst_20802,inst_20803,null));
var inst_20805 = cljs.core.sequence.call(null,inst_20800,inst_20796);
var inst_20806 = cljs.core.PersistentHashMap.EMPTY;
var inst_20807 = [inst_20804,inst_20805,inst_20806];
var inst_20808 = cljs.core.PersistentHashMap.fromArrays(inst_20801,inst_20807);
var state_20849__$1 = state_20849;
var statearr_20884_20918 = state_20849__$1;
(statearr_20884_20918[(2)] = inst_20808);

(statearr_20884_20918[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20850 === (8))){
var inst_20755 = (state_20849[(2)]);
var state_20849__$1 = state_20849;
if(cljs.core.truth_(inst_20755)){
var statearr_20885_20919 = state_20849__$1;
(statearr_20885_20919[(1)] = (9));

} else {
var statearr_20886_20920 = state_20849__$1;
(statearr_20886_20920[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20887 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20887[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_20887[(1)] = (1));

return statearr_20887;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20849){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20888){var ex__2749__auto__ = e20888;
var statearr_20889_20921 = state_20849;
(statearr_20889_20921[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20849[(4)]))){
var statearr_20890_20922 = state_20849;
(statearr_20890_20922[(1)] = cljs.core.first.call(null,(state_20849[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20923 = state_20849;
state_20849 = G__20923;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_20849){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20891 = f__2769__auto__.call(null);
(statearr_20891[(6)] = c__2768__auto__);

return statearr_20891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__20929 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__20929 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__20929;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__20930(s__20931){
return (new cljs.core.LazySeq(null,(function (){
var s__20931__$1 = s__20931;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__20931__$1);
if(temp__5804__auto__){
var s__20931__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20931__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__20931__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__20933 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__20932 = (0);
while(true){
if((i__20932 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__20932);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__20933,(delta * delta));

var G__20934 = (i__20932 + (1));
i__20932 = G__20934;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20933),fluree$db$query$analytical$variance_$_iter__20930.call(null,cljs.core.chunk_rest.call(null,s__20931__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20933),null);
}
} else {
var x = cljs.core.first.call(null,s__20931__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__20930.call(null,cljs.core.rest.call(null,s__20931__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__20935 = null;
var G__20935__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20935__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20935 = function(n,coll){
switch(arguments.length){
case 1:
return G__20935__1.call(this,n);
case 2:
return G__20935__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20935.cljs$core$IFn$_invoke$arity$1 = G__20935__1;
G__20935.cljs$core$IFn$_invoke$arity$2 = G__20935__2;
return G__20935;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20936 = null;
var G__20936__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20936__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20936 = function(n,coll){
switch(arguments.length){
case 1:
return G__20936__1.call(this,n);
case 2:
return G__20936__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20936.cljs$core$IFn$_invoke$arity$1 = G__20936__1;
G__20936.cljs$core$IFn$_invoke$arity$2 = G__20936__2;
return G__20936;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20937 = null;
var G__20937__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__20937__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__20937 = function(n,coll){
switch(arguments.length){
case 1:
return G__20937__1.call(this,n);
case 2:
return G__20937__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20937.cljs$core$IFn$_invoke$arity$1 = G__20937__1;
G__20937.cljs$core$IFn$_invoke$arity$2 = G__20937__2;
return G__20937;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count.call(null,parsed_code);
var vec__20938 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),cljs.core.second.call(null,parsed_code),cljs.core.last.call(null,parsed_code)], null):((cljs.core._EQ_.call(null,(2),list_count))?((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,parsed_code)))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),null,cljs.core.last.call(null,parsed_code)], null)):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.call(null,vec__20938,(0),null);
var arg = cljs.core.nth.call(null,vec__20938,(1),null);
var var$ = cljs.core.nth.call(null,vec__20938,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20941 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__20941,(0),null);
var variable = cljs.core.nth.call(null,vec__20941,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.call(null,parsed_code),")"].join('');
if(cljs.core.truth_(valid_var.call(null,variable))){
} else {
throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.call(null,code_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_.call(null,code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__20944 = aggregate_fn_map;
var map__20944__$1 = cljs.core.__destructure_map.call(null,map__20944);
var variable = cljs.core.get.call(null,map__20944__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__20944__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__20944__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__20946 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__20946,(0),null);
var agg_result = cljs.core.nth.call(null,vec__20946,(1),null);
var map__20949 = res__$1;
var map__20949__$1 = cljs.core.__destructure_map.call(null,map__20949);
var headers = cljs.core.get.call(null,map__20949__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20949__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20945_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__20945_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__20950_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20950_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__20951_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20951_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__20952_SHARP_,p2__20953_SHARP_){
return cljs.core.conj.call(null,p1__20952_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__20953_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__20954_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20954_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__20957,row,b_tuple){
var vec__20958 = p__20957;
var acc = cljs.core.nth.call(null,vec__20958,(0),null);
var b_rows = cljs.core.nth.call(null,vec__20958,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__20955_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20955_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__20956_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20956_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__20961_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20961_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20962_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20962_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20964_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20964_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20963_SHARP_){
return cljs.core.range.call(null,(0),p1__20963_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__20965_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20965_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__20966_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20966_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20967_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20967_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20969_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20969_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20968_SHARP_){
return cljs.core.range.call(null,(0),p1__20968_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__20970_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20970_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__20972 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__20972,(0),null);
var _ = cljs.core.nth.call(null,vec__20972,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__20971_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__20971_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__20977 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__20977,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__20977,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__20975_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__20975_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__20976_SHARP_){
return cljs.core.nth.call(null,clause,p1__20976_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20980,filters,optional_QMARK_){
var map__20981 = p__20980;
var map__20981__$1 = cljs.core.__destructure_map.call(null,map__20981);
var tuple_map = map__20981__$1;
var headers = cljs.core.get.call(null,map__20981__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20981__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__20981__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20982 = clause;
var k = cljs.core.nth.call(null,vec__20982,(0),null);
var v = cljs.core.nth.call(null,vec__20982,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20985 = res;
var map__20985__$1 = cljs.core.__destructure_map.call(null,map__20985);
var headers = cljs.core.get.call(null,map__20985__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20985__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21041){
var state_val_21042 = (state_21041[(1)]);
if((state_val_21042 === (7))){
var inst_21015 = (state_21041[(7)]);
var inst_21013 = (state_21041[(2)]);
var inst_21014 = fluree.db.util.async.throw_err.call(null,inst_21013);
var inst_21015__$1 = cljs.core.nth.call(null,inst_21014,(0),null);
var inst_21016 = cljs.core.nth.call(null,inst_21014,(1),null);
var inst_21017 = (inst_21015__$1 == null);
var state_21041__$1 = (function (){var statearr_21043 = state_21041;
(statearr_21043[(7)] = inst_21015__$1);

(statearr_21043[(8)] = inst_21016);

return statearr_21043;
})();
if(cljs.core.truth_(inst_21017)){
var statearr_21044_21073 = state_21041__$1;
(statearr_21044_21073[(1)] = (8));

} else {
var statearr_21045_21074 = state_21041__$1;
(statearr_21045_21074[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (1))){
var inst_20993 = optional_clauses;
var inst_20994 = cljs.core.seq.call(null,inst_20993);
var inst_20995 = cljs.core.first.call(null,inst_20994);
var inst_20996 = cljs.core.next.call(null,inst_20994);
var inst_20997 = where_tuples;
var inst_20998 = inst_20993;
var inst_20999 = inst_20997;
var state_21041__$1 = (function (){var statearr_21046 = state_21041;
(statearr_21046[(9)] = inst_20999);

(statearr_21046[(10)] = inst_20995);

(statearr_21046[(11)] = inst_20998);

(statearr_21046[(12)] = inst_20996);

return statearr_21046;
})();
var statearr_21047_21075 = state_21041__$1;
(statearr_21047_21075[(2)] = null);

(statearr_21047_21075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (4))){
var inst_20999 = (state_21041[(9)]);
var inst_21005 = (state_21041[(13)]);
var inst_21006 = (state_21041[(14)]);
var inst_21011 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20999,inst_21005,inst_21006,true,fuel,max_fuel,opts);
var state_21041__$1 = state_21041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21041__$1,(7),inst_21011);
} else {
if((state_val_21042 === (15))){
var state_21041__$1 = state_21041;
var statearr_21048_21076 = state_21041__$1;
(statearr_21048_21076[(2)] = null);

(statearr_21048_21076[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (13))){
var inst_21032 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
var statearr_21049_21077 = state_21041__$1;
(statearr_21049_21077[(2)] = inst_21032);

(statearr_21049_21077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (6))){
var inst_21037 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
var statearr_21050_21078 = state_21041__$1;
(statearr_21050_21078[(2)] = inst_21037);

(statearr_21050_21078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (3))){
var inst_21039 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21041__$1,inst_21039);
} else {
if((state_val_21042 === (12))){
var state_21041__$1 = state_21041;
var statearr_21051_21079 = state_21041__$1;
(statearr_21051_21079[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (2))){
var inst_21005 = (state_21041[(13)]);
var inst_20998 = (state_21041[(11)]);
var inst_21004 = cljs.core.seq.call(null,inst_20998);
var inst_21005__$1 = cljs.core.first.call(null,inst_21004);
var inst_21006 = cljs.core.next.call(null,inst_21004);
var state_21041__$1 = (function (){var statearr_21053 = state_21041;
(statearr_21053[(13)] = inst_21005__$1);

(statearr_21053[(14)] = inst_21006);

return statearr_21053;
})();
if(cljs.core.truth_(inst_21005__$1)){
var statearr_21054_21080 = state_21041__$1;
(statearr_21054_21080[(1)] = (4));

} else {
var statearr_21055_21081 = state_21041__$1;
(statearr_21055_21081[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (11))){
var inst_21015 = (state_21041[(7)]);
var inst_21016 = (state_21041[(8)]);
var inst_20998 = inst_21016;
var inst_20999 = inst_21015;
var state_21041__$1 = (function (){var statearr_21056 = state_21041;
(statearr_21056[(9)] = inst_20999);

(statearr_21056[(11)] = inst_20998);

return statearr_21056;
})();
var statearr_21057_21082 = state_21041__$1;
(statearr_21057_21082[(2)] = null);

(statearr_21057_21082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (9))){
var inst_21005 = (state_21041[(13)]);
var inst_21021 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21005);
var state_21041__$1 = state_21041;
if(cljs.core.truth_(inst_21021)){
var statearr_21058_21083 = state_21041__$1;
(statearr_21058_21083[(1)] = (11));

} else {
var statearr_21059_21084 = state_21041__$1;
(statearr_21059_21084[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (5))){
var inst_20999 = (state_21041[(9)]);
var state_21041__$1 = state_21041;
var statearr_21060_21085 = state_21041__$1;
(statearr_21060_21085[(2)] = inst_20999);

(statearr_21060_21085[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (14))){
var inst_20999 = (state_21041[(9)]);
var inst_21015 = (state_21041[(7)]);
var inst_21016 = (state_21041[(8)]);
var inst_21026 = fluree.db.query.analytical.left_outer_join.call(null,inst_20999,inst_21015);
var inst_20998 = inst_21016;
var inst_20999__$1 = inst_21026;
var state_21041__$1 = (function (){var statearr_21061 = state_21041;
(statearr_21061[(9)] = inst_20999__$1);

(statearr_21061[(11)] = inst_20998);

return statearr_21061;
})();
var statearr_21062_21086 = state_21041__$1;
(statearr_21062_21086[(2)] = null);

(statearr_21062_21086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (16))){
var inst_21030 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
var statearr_21064_21087 = state_21041__$1;
(statearr_21064_21087[(2)] = inst_21030);

(statearr_21064_21087[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (10))){
var inst_21034 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
var statearr_21065_21088 = state_21041__$1;
(statearr_21065_21088[(2)] = inst_21034);

(statearr_21065_21088[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (8))){
var inst_20999 = (state_21041[(9)]);
var inst_21016 = (state_21041[(8)]);
var tmp21063 = inst_20999;
var inst_20998 = inst_21016;
var inst_20999__$1 = tmp21063;
var state_21041__$1 = (function (){var statearr_21066 = state_21041;
(statearr_21066[(9)] = inst_20999__$1);

(statearr_21066[(11)] = inst_20998);

return statearr_21066;
})();
var statearr_21067_21089 = state_21041__$1;
(statearr_21067_21089[(2)] = null);

(statearr_21067_21089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_21068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21068[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_21068[(1)] = (1));

return statearr_21068;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_21041){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21069){var ex__2749__auto__ = e21069;
var statearr_21070_21090 = state_21041;
(statearr_21070_21090[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21041[(4)]))){
var statearr_21071_21091 = state_21041;
(statearr_21071_21091[(1)] = cljs.core.first.call(null,(state_21041[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21092 = state_21041;
state_21041 = G__21092;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_21041){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_21041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21072 = f__2769__auto__.call(null);
(statearr_21072[(6)] = c__2768__auto__);

return statearr_21072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21094){
var vec__21095 = p__21094;
var var_name = cljs.core.nth.call(null,vec__21095,(0),null);
var var_val = cljs.core.nth.call(null,vec__21095,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21093_SHARP_){
return cljs.core.conj.call(null,p1__21093_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21099,p__21100,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21101 = p__21099;
var map__21101__$1 = cljs.core.__destructure_map.call(null,map__21101);
var q_map = map__21101__$1;
var prefixes = cljs.core.get.call(null,map__21101__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21102 = p__21100;
var map__21102__$1 = cljs.core.__destructure_map.call(null,map__21102);
var res = map__21102__$1;
var vars = cljs.core.get.call(null,map__21102__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21339){
var state_val_21340 = (state_21339[(1)]);
if((state_val_21340 === (65))){
var inst_21289 = (state_21339[(7)]);
var inst_21288 = (state_21339[(8)]);
var inst_21300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21301 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_21288,res,inst_21289);
var inst_21302 = [inst_21301,r];
var inst_21303 = (new cljs.core.PersistentVector(null,2,(5),inst_21300,inst_21302,null));
var state_21339__$1 = state_21339;
var statearr_21341_21446 = state_21339__$1;
(statearr_21341_21446[(2)] = inst_21303);

(statearr_21341_21446[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (70))){
var inst_21315 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21342_21447 = state_21339__$1;
(statearr_21342_21447[(2)] = inst_21315);

(statearr_21342_21447[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (62))){
var inst_21289 = (state_21339[(7)]);
var inst_21297 = cljs.core.second.call(null,inst_21289);
var inst_21298 = clojure.string.starts_with_QMARK_.call(null,inst_21297,"fullText:");
var state_21339__$1 = state_21339;
if(inst_21298){
var statearr_21343_21448 = state_21339__$1;
(statearr_21343_21448[(1)] = (65));

} else {
var statearr_21344_21449 = state_21339__$1;
(statearr_21344_21449[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (7))){
var inst_21208 = (state_21339[(9)]);
var inst_21207 = cljs.core.count.call(null,clause);
var inst_21208__$1 = cljs.core._EQ_.call(null,(3),inst_21207);
var state_21339__$1 = (function (){var statearr_21345 = state_21339;
(statearr_21345[(9)] = inst_21208__$1);

return statearr_21345;
})();
if(inst_21208__$1){
var statearr_21346_21450 = state_21339__$1;
(statearr_21346_21450[(1)] = (31));

} else {
var statearr_21347_21451 = state_21339__$1;
(statearr_21347_21451[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (59))){
var inst_21322 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21348_21452 = state_21339__$1;
(statearr_21348_21452[(2)] = inst_21322);

(statearr_21348_21452[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (20))){
var inst_21171 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21349_21453 = state_21339__$1;
(statearr_21349_21453[(2)] = inst_21171);

(statearr_21349_21453[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (58))){
var state_21339__$1 = state_21339;
var statearr_21350_21454 = state_21339__$1;
(statearr_21350_21454[(2)] = null);

(statearr_21350_21454[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (60))){
var inst_21288 = (state_21339[(8)]);
var inst_21286 = (state_21339[(2)]);
var inst_21287 = fluree.db.util.async.throw_err.call(null,inst_21286);
var inst_21288__$1 = cljs.core.nth.call(null,inst_21287,(0),null);
var inst_21289 = cljs.core.nth.call(null,inst_21287,(1),null);
var inst_21290 = cljs.core._EQ_.call(null,"$wd",inst_21288__$1);
var state_21339__$1 = (function (){var statearr_21351 = state_21339;
(statearr_21351[(7)] = inst_21289);

(statearr_21351[(8)] = inst_21288__$1);

return statearr_21351;
})();
if(inst_21290){
var statearr_21352_21455 = state_21339__$1;
(statearr_21352_21455[(1)] = (61));

} else {
var statearr_21353_21456 = state_21339__$1;
(statearr_21353_21456[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (27))){
var inst_21201 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21354_21457 = state_21339__$1;
(statearr_21354_21457[(2)] = inst_21201);

(statearr_21354_21457[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (1))){
var state_21339__$1 = state_21339;
var statearr_21355_21458 = state_21339__$1;
(statearr_21355_21458[(2)] = null);

(statearr_21355_21458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (69))){
var state_21339__$1 = state_21339;
var statearr_21356_21459 = state_21339__$1;
(statearr_21356_21459[(2)] = null);

(statearr_21356_21459[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (24))){
var inst_21165 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21357_21460 = state_21339__$1;
(statearr_21357_21460[(2)] = inst_21165);

(statearr_21357_21460[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (55))){
var inst_21271 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21272 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21273 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21274 = cljs.core.PersistentHashMap.fromArrays(inst_21272,inst_21273);
var inst_21275 = cljs.core.ex_info.call(null,inst_21271,inst_21274);
var inst_21276 = (function(){throw inst_21275})();
var state_21339__$1 = state_21339;
var statearr_21358_21461 = state_21339__$1;
(statearr_21358_21461[(2)] = inst_21276);

(statearr_21358_21461[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (39))){
var inst_21228 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
if(cljs.core.truth_(inst_21228)){
var statearr_21359_21462 = state_21339__$1;
(statearr_21359_21462[(1)] = (40));

} else {
var statearr_21360_21463 = state_21339__$1;
(statearr_21360_21463[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (46))){
var inst_21328 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21361_21464 = state_21339__$1;
(statearr_21361_21464[(2)] = inst_21328);

(statearr_21361_21464[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (4))){
var inst_21103 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21362_21465 = state_21339__$1;
(statearr_21362_21465[(2)] = inst_21103);

(statearr_21362_21465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (54))){
var inst_21264 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21265 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21266 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21267 = cljs.core.PersistentHashMap.fromArrays(inst_21265,inst_21266);
var inst_21268 = cljs.core.ex_info.call(null,inst_21264,inst_21267);
var inst_21269 = (function(){throw inst_21268})();
var state_21339__$1 = state_21339;
var statearr_21363_21466 = state_21339__$1;
(statearr_21363_21466[(2)] = inst_21269);

(statearr_21363_21466[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (15))){
var inst_21203 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21364_21467 = state_21339__$1;
(statearr_21364_21467[(2)] = inst_21203);

(statearr_21364_21467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (48))){
var inst_21252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21253 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_21254 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21253);
var inst_21255 = [inst_21254,r];
var inst_21256 = (new cljs.core.PersistentVector(null,2,(5),inst_21252,inst_21255,null));
var state_21339__$1 = state_21339;
var statearr_21365_21468 = state_21339__$1;
(statearr_21365_21468[(2)] = inst_21256);

(statearr_21365_21468[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (50))){
var inst_21326 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21366_21469 = state_21339__$1;
(statearr_21366_21469[(2)] = inst_21326);

(statearr_21366_21469[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (21))){
var inst_21141 = (state_21339[(10)]);
var inst_21149 = (state_21339[(11)]);
var inst_21139 = (state_21339[(12)]);
var inst_21137 = (state_21339[(13)]);
var inst_21142 = (state_21339[(14)]);
var inst_21112 = (state_21339[(15)]);
var inst_21148 = (state_21339[(16)]);
var inst_21140 = (state_21339[(17)]);
var inst_21116 = (state_21339[(18)]);
var inst_21153 = (state_21339[(2)]);
var inst_21154 = fluree.db.util.async.throw_err.call(null,inst_21153);
var inst_21155 = (function (){var vec__21134 = inst_21137;
var new_res = inst_21154;
var rest = inst_21149;
var seq__21135 = inst_21140;
var vec__21144 = inst_21141;
var tuples = inst_21142;
var pred__21113 = inst_21116;
var first__21136 = inst_21139;
var expr__21114 = inst_21112;
var G__21133 = inst_21141;
var first__21146 = inst_21148;
var seq__21145 = inst_21149;
var segment_type = inst_21112;
var clause_group = inst_21148;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21156 = cljs.core.keys.call(null,vars);
var inst_21157 = cljs.core.reduce.call(null,inst_21155,inst_21154,inst_21156);
var inst_21158 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_21157);
var state_21339__$1 = (function (){var statearr_21367 = state_21339;
(statearr_21367[(19)] = inst_21158);

return statearr_21367;
})();
if(cljs.core.truth_(inst_21142)){
var statearr_21368_21470 = state_21339__$1;
(statearr_21368_21470[(1)] = (22));

} else {
var statearr_21369_21471 = state_21339__$1;
(statearr_21369_21471[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (31))){
var inst_21210 = cljs.core.second.call(null,clause);
var inst_21211 = clojure.string.starts_with_QMARK_.call(null,inst_21210,"fullText:");
var state_21339__$1 = state_21339;
var statearr_21370_21472 = state_21339__$1;
(statearr_21370_21472[(2)] = inst_21211);

(statearr_21370_21472[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (32))){
var inst_21208 = (state_21339[(9)]);
var state_21339__$1 = state_21339;
var statearr_21371_21473 = state_21339__$1;
(statearr_21371_21473[(2)] = inst_21208);

(statearr_21371_21473[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (40))){
var inst_21230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21231 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_21339__$1 = (function (){var statearr_21372 = state_21339;
(statearr_21372[(20)] = inst_21230);

return statearr_21372;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(43),inst_21231);
} else {
if((state_val_21340 === (56))){
var inst_21278 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21373_21474 = state_21339__$1;
(statearr_21373_21474[(2)] = inst_21278);

(statearr_21373_21474[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (33))){
var inst_21214 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
if(cljs.core.truth_(inst_21214)){
var statearr_21374_21475 = state_21339__$1;
(statearr_21374_21475[(1)] = (34));

} else {
var statearr_21375_21476 = state_21339__$1;
(statearr_21375_21476[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (13))){
var inst_21137 = (state_21339[(13)]);
var inst_21137__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21138 = cljs.core.seq.call(null,inst_21137__$1);
var inst_21139 = cljs.core.first.call(null,inst_21138);
var inst_21140 = cljs.core.next.call(null,inst_21138);
var inst_21141 = inst_21137__$1;
var inst_21142 = null;
var state_21339__$1 = (function (){var statearr_21376 = state_21339;
(statearr_21376[(10)] = inst_21141);

(statearr_21376[(12)] = inst_21139);

(statearr_21376[(13)] = inst_21137__$1);

(statearr_21376[(14)] = inst_21142);

(statearr_21376[(17)] = inst_21140);

return statearr_21376;
})();
var statearr_21377_21477 = state_21339__$1;
(statearr_21377_21477[(2)] = null);

(statearr_21377_21477[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (22))){
var inst_21149 = (state_21339[(11)]);
var inst_21142 = (state_21339[(14)]);
var inst_21158 = (state_21339[(19)]);
var inst_21160 = fluree.db.query.union.results.call(null,inst_21142,inst_21158);
var inst_21141 = inst_21149;
var inst_21142__$1 = inst_21160;
var state_21339__$1 = (function (){var statearr_21378 = state_21339;
(statearr_21378[(10)] = inst_21141);

(statearr_21378[(14)] = inst_21142__$1);

return statearr_21378;
})();
var statearr_21379_21478 = state_21339__$1;
(statearr_21379_21478[(2)] = null);

(statearr_21379_21478[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (36))){
var inst_21332 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21380_21479 = state_21339__$1;
(statearr_21380_21479[(2)] = inst_21332);

(statearr_21380_21479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (41))){
var inst_21238 = cljs.core.count.call(null,clause);
var inst_21239 = cljs.core._EQ_.call(null,(3),inst_21238);
var state_21339__$1 = state_21339;
if(inst_21239){
var statearr_21381_21480 = state_21339__$1;
(statearr_21381_21480[(1)] = (44));

} else {
var statearr_21382_21481 = state_21339__$1;
(statearr_21382_21481[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (43))){
var inst_21230 = (state_21339[(20)]);
var inst_21233 = (state_21339[(2)]);
var inst_21234 = fluree.db.util.async.throw_err.call(null,inst_21233);
var inst_21235 = [inst_21234,r];
var inst_21236 = (new cljs.core.PersistentVector(null,2,(5),inst_21230,inst_21235,null));
var state_21339__$1 = state_21339;
var statearr_21383_21482 = state_21339__$1;
(statearr_21383_21482[(2)] = inst_21236);

(statearr_21383_21482[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (61))){
var inst_21289 = (state_21339[(7)]);
var inst_21292 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_21289,r,res,optional_QMARK_,fuel,max_fuel);
var state_21339__$1 = state_21339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(64),inst_21292);
} else {
if((state_val_21340 === (29))){
var inst_21112 = (state_21339[(15)]);
var inst_21195 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21112)].join('');
var inst_21196 = (new Error(inst_21195));
var inst_21197 = (function(){throw inst_21196})();
var state_21339__$1 = state_21339;
var statearr_21384_21483 = state_21339__$1;
(statearr_21384_21483[(2)] = inst_21197);

(statearr_21384_21483[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (44))){
var inst_21241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21242 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_21339__$1 = (function (){var statearr_21385 = state_21339;
(statearr_21385[(21)] = inst_21241);

return statearr_21385;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(47),inst_21242);
} else {
if((state_val_21340 === (6))){
var inst_21112 = (state_21339[(15)]);
var inst_21116 = (state_21339[(18)]);
var inst_21111 = cljs.core.keys.call(null,clause);
var inst_21112__$1 = cljs.core.first.call(null,inst_21111);
var inst_21116__$1 = cljs.core._EQ_;
var inst_21117 = inst_21116__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21112__$1);
var state_21339__$1 = (function (){var statearr_21386 = state_21339;
(statearr_21386[(15)] = inst_21112__$1);

(statearr_21386[(18)] = inst_21116__$1);

return statearr_21386;
})();
if(cljs.core.truth_(inst_21117)){
var statearr_21387_21484 = state_21339__$1;
(statearr_21387_21484[(1)] = (9));

} else {
var statearr_21388_21485 = state_21339__$1;
(statearr_21388_21485[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (28))){
var inst_21189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21190 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21191 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_21190,optional_QMARK_);
var inst_21192 = [inst_21191,r];
var inst_21193 = (new cljs.core.PersistentVector(null,2,(5),inst_21189,inst_21192,null));
var state_21339__$1 = state_21339;
var statearr_21389_21486 = state_21339__$1;
(statearr_21389_21486[(2)] = inst_21193);

(statearr_21389_21486[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (64))){
var inst_21294 = (state_21339[(2)]);
var inst_21295 = fluree.db.util.async.throw_err.call(null,inst_21294);
var state_21339__$1 = state_21339;
var statearr_21390_21487 = state_21339__$1;
(statearr_21390_21487[(2)] = inst_21295);

(statearr_21390_21487[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (51))){
var inst_21261 = cljs.core.first.call(null,clause);
var inst_21262 = cljs.core.sequential_QMARK_.call(null,inst_21261);
var state_21339__$1 = state_21339;
if(inst_21262){
var statearr_21391_21488 = state_21339__$1;
(statearr_21391_21488[(1)] = (54));

} else {
var statearr_21392_21489 = state_21339__$1;
(statearr_21392_21489[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (25))){
var inst_21112 = (state_21339[(15)]);
var inst_21116 = (state_21339[(18)]);
var inst_21177 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21178 = (function (){var segment_type = inst_21112;
var pred__21113 = inst_21116;
var expr__21114 = inst_21112;
var bindings = inst_21177;
return (function (p1__21098_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21098_SHARP_);
});
})();
var inst_21179 = cljs.core.map.call(null,inst_21178,inst_21177);
var inst_21180 = cljs.core.PersistentHashMap.EMPTY;
var inst_21181 = cljs.core.into.call(null,inst_21180,inst_21179);
var inst_21182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21183 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21181);
var inst_21184 = [inst_21183,r];
var inst_21185 = (new cljs.core.PersistentVector(null,2,(5),inst_21182,inst_21184,null));
var state_21339__$1 = state_21339;
var statearr_21393_21490 = state_21339__$1;
(statearr_21393_21490[(2)] = inst_21185);

(statearr_21393_21490[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (34))){
var inst_21216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21217 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_21218 = [inst_21217,r];
var inst_21219 = (new cljs.core.PersistentVector(null,2,(5),inst_21216,inst_21218,null));
var state_21339__$1 = state_21339;
var statearr_21394_21491 = state_21339__$1;
(statearr_21394_21491[(2)] = inst_21219);

(statearr_21394_21491[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (17))){
var inst_21173 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21395_21492 = state_21339__$1;
(statearr_21395_21492[(2)] = inst_21173);

(statearr_21395_21492[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (3))){
var inst_21337 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21339__$1,inst_21337);
} else {
if((state_val_21340 === (12))){
var inst_21119 = (state_21339[(22)]);
var inst_21123 = (state_21339[(2)]);
var inst_21124 = fluree.db.util.async.throw_err.call(null,inst_21123);
var inst_21125 = [inst_21124,r];
var inst_21126 = (new cljs.core.PersistentVector(null,2,(5),inst_21119,inst_21125,null));
var state_21339__$1 = state_21339;
var statearr_21396_21493 = state_21339__$1;
(statearr_21396_21493[(2)] = inst_21126);

(statearr_21396_21493[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (2))){
var _ = (function (){var statearr_21397 = state_21339;
(statearr_21397[(4)] = cljs.core.cons.call(null,(5),(state_21339[(4)])));

return statearr_21397;
})();
var inst_21109 = cljs.core.map_QMARK_.call(null,clause);
var state_21339__$1 = state_21339;
if(inst_21109){
var statearr_21398_21494 = state_21339__$1;
(statearr_21398_21494[(1)] = (6));

} else {
var statearr_21399_21495 = state_21339__$1;
(statearr_21399_21495[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (66))){
var state_21339__$1 = state_21339;
var statearr_21400_21496 = state_21339__$1;
(statearr_21400_21496[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (23))){
var inst_21149 = (state_21339[(11)]);
var inst_21158 = (state_21339[(19)]);
var inst_21141 = inst_21149;
var inst_21142 = inst_21158;
var state_21339__$1 = (function (){var statearr_21402 = state_21339;
(statearr_21402[(10)] = inst_21141);

(statearr_21402[(14)] = inst_21142);

return statearr_21402;
})();
var statearr_21403_21497 = state_21339__$1;
(statearr_21403_21497[(2)] = null);

(statearr_21403_21497[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (47))){
var inst_21241 = (state_21339[(21)]);
var inst_21244 = (state_21339[(2)]);
var inst_21245 = fluree.db.util.async.throw_err.call(null,inst_21244);
var inst_21246 = [inst_21245,r];
var inst_21247 = (new cljs.core.PersistentVector(null,2,(5),inst_21241,inst_21246,null));
var state_21339__$1 = state_21339;
var statearr_21404_21498 = state_21339__$1;
(statearr_21404_21498[(2)] = inst_21247);

(statearr_21404_21498[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (35))){
var inst_21222 = (state_21339[(23)]);
var inst_21221 = cljs.core.count.call(null,clause);
var inst_21222__$1 = cljs.core._EQ_.call(null,(3),inst_21221);
var state_21339__$1 = (function (){var statearr_21405 = state_21339;
(statearr_21405[(23)] = inst_21222__$1);

return statearr_21405;
})();
if(inst_21222__$1){
var statearr_21406_21499 = state_21339__$1;
(statearr_21406_21499[(1)] = (37));

} else {
var statearr_21407_21500 = state_21339__$1;
(statearr_21407_21500[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (19))){
var inst_21142 = (state_21339[(14)]);
var inst_21167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21168 = [inst_21142,r];
var inst_21169 = (new cljs.core.PersistentVector(null,2,(5),inst_21167,inst_21168,null));
var state_21339__$1 = state_21339;
var statearr_21408_21501 = state_21339__$1;
(statearr_21408_21501[(2)] = inst_21169);

(statearr_21408_21501[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (57))){
var inst_21284 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_21339__$1 = state_21339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(60),inst_21284);
} else {
if((state_val_21340 === (68))){
var inst_21289 = (state_21339[(7)]);
var inst_21288 = (state_21339[(8)]);
var inst_21306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21307 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_21288,res,inst_21289,fuel,max_fuel);
var state_21339__$1 = (function (){var statearr_21409 = state_21339;
(statearr_21409[(24)] = inst_21306);

return statearr_21409;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(71),inst_21307);
} else {
if((state_val_21340 === (11))){
var inst_21205 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21411_21502 = state_21339__$1;
(statearr_21411_21502[(2)] = inst_21205);

(statearr_21411_21502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (9))){
var inst_21119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21120 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21121 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21120,res,fuel,max_fuel,opts);
var state_21339__$1 = (function (){var statearr_21412 = state_21339;
(statearr_21412[(22)] = inst_21119);

return statearr_21412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(12),inst_21121);
} else {
if((state_val_21340 === (5))){
var _ = (function (){var statearr_21413 = state_21339;
(statearr_21413[(4)] = cljs.core.rest.call(null,(state_21339[(4)])));

return statearr_21413;
})();
var state_21339__$1 = state_21339;
var ex21410 = (state_21339__$1[(2)]);
var statearr_21414_21503 = state_21339__$1;
(statearr_21414_21503[(5)] = ex21410);


if((ex21410 instanceof Error)){
var statearr_21415_21504 = state_21339__$1;
(statearr_21415_21504[(1)] = (4));

(statearr_21415_21504[(5)] = null);

} else {
throw ex21410;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (14))){
var inst_21112 = (state_21339[(15)]);
var inst_21116 = (state_21339[(18)]);
var inst_21175 = inst_21116.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21112);
var state_21339__$1 = state_21339;
if(cljs.core.truth_(inst_21175)){
var statearr_21416_21505 = state_21339__$1;
(statearr_21416_21505[(1)] = (25));

} else {
var statearr_21417_21506 = state_21339__$1;
(statearr_21417_21506[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (45))){
var inst_21249 = cljs.core.count.call(null,clause);
var inst_21250 = cljs.core._EQ_.call(null,(2),inst_21249);
var state_21339__$1 = state_21339;
if(inst_21250){
var statearr_21418_21507 = state_21339__$1;
(statearr_21418_21507[(1)] = (48));

} else {
var statearr_21419_21508 = state_21339__$1;
(statearr_21419_21508[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (53))){
var inst_21324 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21420_21509 = state_21339__$1;
(statearr_21420_21509[(2)] = inst_21324);

(statearr_21420_21509[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (26))){
var inst_21112 = (state_21339[(15)]);
var inst_21116 = (state_21339[(18)]);
var inst_21187 = inst_21116.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21112);
var state_21339__$1 = state_21339;
if(cljs.core.truth_(inst_21187)){
var statearr_21421_21510 = state_21339__$1;
(statearr_21421_21510[(1)] = (28));

} else {
var statearr_21422_21511 = state_21339__$1;
(statearr_21422_21511[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (16))){
var inst_21141 = (state_21339[(10)]);
var inst_21148 = (state_21339[(16)]);
var inst_21147 = cljs.core.seq.call(null,inst_21141);
var inst_21148__$1 = cljs.core.first.call(null,inst_21147);
var inst_21149 = cljs.core.next.call(null,inst_21147);
var state_21339__$1 = (function (){var statearr_21423 = state_21339;
(statearr_21423[(11)] = inst_21149);

(statearr_21423[(16)] = inst_21148__$1);

return statearr_21423;
})();
if(cljs.core.truth_(inst_21148__$1)){
var statearr_21424_21512 = state_21339__$1;
(statearr_21424_21512[(1)] = (18));

} else {
var statearr_21425_21513 = state_21339__$1;
(statearr_21425_21513[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (38))){
var inst_21222 = (state_21339[(23)]);
var state_21339__$1 = state_21339;
var statearr_21426_21514 = state_21339__$1;
(statearr_21426_21514[(2)] = inst_21222);

(statearr_21426_21514[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (30))){
var inst_21199 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21427_21515 = state_21339__$1;
(statearr_21427_21515[(2)] = inst_21199);

(statearr_21427_21515[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (10))){
var inst_21112 = (state_21339[(15)]);
var inst_21116 = (state_21339[(18)]);
var inst_21128 = inst_21116.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21112);
var state_21339__$1 = state_21339;
if(cljs.core.truth_(inst_21128)){
var statearr_21428_21516 = state_21339__$1;
(statearr_21428_21516[(1)] = (13));

} else {
var statearr_21429_21517 = state_21339__$1;
(statearr_21429_21517[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (18))){
var inst_21148 = (state_21339[(16)]);
var inst_21151 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21148,q_map,vars,fuel,max_fuel,opts);
var state_21339__$1 = state_21339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21339__$1,(21),inst_21151);
} else {
if((state_val_21340 === (52))){
var state_21339__$1 = state_21339;
var statearr_21430_21518 = state_21339__$1;
(statearr_21430_21518[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (67))){
var inst_21317 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21432_21519 = state_21339__$1;
(statearr_21432_21519[(2)] = inst_21317);

(statearr_21432_21519[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (71))){
var inst_21306 = (state_21339[(24)]);
var inst_21309 = (state_21339[(2)]);
var inst_21310 = fluree.db.util.async.throw_err.call(null,inst_21309);
var inst_21311 = [inst_21310,r];
var inst_21312 = (new cljs.core.PersistentVector(null,2,(5),inst_21306,inst_21311,null));
var state_21339__$1 = state_21339;
var statearr_21433_21520 = state_21339__$1;
(statearr_21433_21520[(2)] = inst_21312);

(statearr_21433_21520[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (42))){
var inst_21330 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21434_21521 = state_21339__$1;
(statearr_21434_21521[(2)] = inst_21330);

(statearr_21434_21521[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (37))){
var inst_21224 = cljs.core.second.call(null,clause);
var inst_21225 = cljs.core._EQ_.call(null,inst_21224,"rdf:type");
var state_21339__$1 = state_21339;
var statearr_21435_21522 = state_21339__$1;
(statearr_21435_21522[(2)] = inst_21225);

(statearr_21435_21522[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (63))){
var inst_21319 = (state_21339[(2)]);
var state_21339__$1 = state_21339;
var statearr_21436_21523 = state_21339__$1;
(statearr_21436_21523[(2)] = inst_21319);

(statearr_21436_21523[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (8))){
var inst_21334 = (state_21339[(2)]);
var _ = (function (){var statearr_21437 = state_21339;
(statearr_21437[(4)] = cljs.core.rest.call(null,(state_21339[(4)])));

return statearr_21437;
})();
var state_21339__$1 = state_21339;
var statearr_21438_21524 = state_21339__$1;
(statearr_21438_21524[(2)] = inst_21334);

(statearr_21438_21524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21340 === (49))){
var inst_21258 = cljs.core.count.call(null,clause);
var inst_21259 = cljs.core._EQ_.call(null,(1),inst_21258);
var state_21339__$1 = state_21339;
if(inst_21259){
var statearr_21439_21525 = state_21339__$1;
(statearr_21439_21525[(1)] = (51));

} else {
var statearr_21440_21526 = state_21339__$1;
(statearr_21440_21526[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21441 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21441[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_21441[(1)] = (1));

return statearr_21441;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21339){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21442){var ex__2749__auto__ = e21442;
var statearr_21443_21527 = state_21339;
(statearr_21443_21527[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21339[(4)]))){
var statearr_21444_21528 = state_21339;
(statearr_21444_21528[(1)] = cljs.core.first.call(null,(state_21339[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21529 = state_21339;
state_21339 = G__21529;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_21339){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21445 = f__2769__auto__.call(null);
(statearr_21445[(6)] = c__2768__auto__);

return statearr_21445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21531 = arguments.length;
switch (G__21531) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21611){
var state_val_21612 = (state_21611[(1)]);
if((state_val_21612 === (7))){
var inst_21606 = (state_21611[(2)]);
var _ = (function (){var statearr_21613 = state_21611;
(statearr_21613[(4)] = cljs.core.rest.call(null,(state_21611[(4)])));

return statearr_21613;
})();
var state_21611__$1 = state_21611;
var statearr_21614_21662 = state_21611__$1;
(statearr_21614_21662[(2)] = inst_21606);

(statearr_21614_21662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (20))){
var inst_21571 = (state_21611[(7)]);
var inst_21583 = (state_21611[(2)]);
var inst_21553 = inst_21571;
var inst_21554 = inst_21583;
var state_21611__$1 = (function (){var statearr_21615 = state_21611;
(statearr_21615[(8)] = inst_21553);

(statearr_21615[(9)] = inst_21554);

return statearr_21615;
})();
var statearr_21616_21663 = state_21611__$1;
(statearr_21616_21663[(2)] = null);

(statearr_21616_21663[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (1))){
var state_21611__$1 = state_21611;
var statearr_21617_21664 = state_21611__$1;
(statearr_21617_21664[(2)] = null);

(statearr_21617_21664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (24))){
var inst_21571 = (state_21611[(7)]);
var inst_21570 = (state_21611[(10)]);
var inst_21554 = (state_21611[(9)]);
var inst_21591 = fluree.db.query.analytical.inner_join.call(null,inst_21554,inst_21570);
var inst_21553 = inst_21571;
var inst_21554__$1 = inst_21591;
var state_21611__$1 = (function (){var statearr_21618 = state_21611;
(statearr_21618[(8)] = inst_21553);

(statearr_21618[(9)] = inst_21554__$1);

return statearr_21618;
})();
var statearr_21619_21665 = state_21611__$1;
(statearr_21619_21665[(2)] = null);

(statearr_21619_21665[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (4))){
var inst_21532 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
var statearr_21621_21666 = state_21611__$1;
(statearr_21621_21666[(2)] = inst_21532);

(statearr_21621_21666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (15))){
var inst_21570 = (state_21611[(10)]);
var state_21611__$1 = state_21611;
if(cljs.core.truth_(inst_21570)){
var statearr_21622_21667 = state_21611__$1;
(statearr_21622_21667[(1)] = (18));

} else {
var statearr_21623_21668 = state_21611__$1;
(statearr_21623_21668[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (21))){
var inst_21571 = (state_21611[(7)]);
var inst_21554 = (state_21611[(9)]);
var tmp21620 = inst_21554;
var inst_21553 = inst_21571;
var inst_21554__$1 = tmp21620;
var state_21611__$1 = (function (){var statearr_21624 = state_21611;
(statearr_21624[(8)] = inst_21553);

(statearr_21624[(9)] = inst_21554__$1);

return statearr_21624;
})();
var statearr_21625_21669 = state_21611__$1;
(statearr_21625_21669[(2)] = null);

(statearr_21625_21669[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (13))){
var inst_21554 = (state_21611[(9)]);
var inst_21577 = cljs.core.dissoc.call(null,inst_21554,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21578 = cljs.core.empty_QMARK_.call(null,inst_21577);
var state_21611__$1 = state_21611;
if(inst_21578){
var statearr_21626_21670 = state_21611__$1;
(statearr_21626_21670[(1)] = (15));

} else {
var statearr_21627_21671 = state_21611__$1;
(statearr_21627_21671[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (22))){
var state_21611__$1 = state_21611;
var statearr_21628_21672 = state_21611__$1;
(statearr_21628_21672[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (6))){
var inst_21560 = (state_21611[(11)]);
var inst_21553 = (state_21611[(8)]);
var inst_21559 = cljs.core.seq.call(null,inst_21553);
var inst_21560__$1 = cljs.core.first.call(null,inst_21559);
var inst_21561 = cljs.core.next.call(null,inst_21559);
var state_21611__$1 = (function (){var statearr_21630 = state_21611;
(statearr_21630[(11)] = inst_21560__$1);

(statearr_21630[(12)] = inst_21561);

return statearr_21630;
})();
if(cljs.core.truth_(inst_21560__$1)){
var statearr_21631_21673 = state_21611__$1;
(statearr_21631_21673[(1)] = (8));

} else {
var statearr_21632_21674 = state_21611__$1;
(statearr_21632_21674[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (25))){
var state_21611__$1 = state_21611;
var statearr_21633_21675 = state_21611__$1;
(statearr_21633_21675[(2)] = null);

(statearr_21633_21675[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (17))){
var inst_21599 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
var statearr_21634_21676 = state_21611__$1;
(statearr_21634_21676[(2)] = inst_21599);

(statearr_21634_21676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (3))){
var inst_21609 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21611__$1,inst_21609);
} else {
if((state_val_21612 === (12))){
var inst_21571 = (state_21611[(7)]);
var inst_21570 = (state_21611[(10)]);
var inst_21553 = inst_21571;
var inst_21554 = inst_21570;
var state_21611__$1 = (function (){var statearr_21635 = state_21611;
(statearr_21635[(8)] = inst_21553);

(statearr_21635[(9)] = inst_21554);

return statearr_21635;
})();
var statearr_21636_21677 = state_21611__$1;
(statearr_21636_21677[(2)] = null);

(statearr_21636_21677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (2))){
var _ = (function (){var statearr_21637 = state_21611;
(statearr_21637[(4)] = cljs.core.cons.call(null,(5),(state_21611[(4)])));

return statearr_21637;
})();
var inst_21545 = where;
var inst_21546 = cljs.core.seq.call(null,inst_21545);
var inst_21547 = cljs.core.first.call(null,inst_21546);
var inst_21548 = cljs.core.next.call(null,inst_21546);
var inst_21549 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21550 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_21551 = [inst_21550];
var inst_21552 = cljs.core.PersistentHashMap.fromArrays(inst_21549,inst_21551);
var inst_21553 = inst_21545;
var inst_21554 = inst_21552;
var state_21611__$1 = (function (){var statearr_21638 = state_21611;
(statearr_21638[(13)] = inst_21548);

(statearr_21638[(8)] = inst_21553);

(statearr_21638[(9)] = inst_21554);

(statearr_21638[(14)] = inst_21547);

return statearr_21638;
})();
var statearr_21639_21678 = state_21611__$1;
(statearr_21639_21678[(2)] = null);

(statearr_21639_21678[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (23))){
var inst_21597 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
var statearr_21640_21679 = state_21611__$1;
(statearr_21640_21679[(2)] = inst_21597);

(statearr_21640_21679[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (19))){
var inst_21554 = (state_21611[(9)]);
var state_21611__$1 = state_21611;
var statearr_21641_21680 = state_21611__$1;
(statearr_21641_21680[(2)] = inst_21554);

(statearr_21641_21680[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (11))){
var inst_21560 = (state_21611[(11)]);
var inst_21568 = (state_21611[(2)]);
var inst_21569 = fluree.db.util.async.throw_err.call(null,inst_21568);
var inst_21570 = cljs.core.nth.call(null,inst_21569,(0),null);
var inst_21571 = cljs.core.nth.call(null,inst_21569,(1),null);
var inst_21572 = cljs.core.count.call(null,inst_21560);
var inst_21573 = cljs.core._EQ_.call(null,(2),inst_21572);
var state_21611__$1 = (function (){var statearr_21643 = state_21611;
(statearr_21643[(7)] = inst_21571);

(statearr_21643[(10)] = inst_21570);

return statearr_21643;
})();
if(inst_21573){
var statearr_21644_21681 = state_21611__$1;
(statearr_21644_21681[(1)] = (12));

} else {
var statearr_21645_21682 = state_21611__$1;
(statearr_21645_21682[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (9))){
var inst_21554 = (state_21611[(9)]);
var state_21611__$1 = state_21611;
var statearr_21646_21683 = state_21611__$1;
(statearr_21646_21683[(2)] = inst_21554);

(statearr_21646_21683[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (5))){
var _ = (function (){var statearr_21647 = state_21611;
(statearr_21647[(4)] = cljs.core.rest.call(null,(state_21611[(4)])));

return statearr_21647;
})();
var state_21611__$1 = state_21611;
var ex21642 = (state_21611__$1[(2)]);
var statearr_21648_21684 = state_21611__$1;
(statearr_21648_21684[(5)] = ex21642);


if((ex21642 instanceof Error)){
var statearr_21649_21685 = state_21611__$1;
(statearr_21649_21685[(1)] = (4));

(statearr_21649_21685[(5)] = null);

} else {
throw ex21642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (14))){
var inst_21601 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
var statearr_21650_21686 = state_21611__$1;
(statearr_21650_21686[(2)] = inst_21601);

(statearr_21650_21686[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (26))){
var inst_21595 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
var statearr_21651_21687 = state_21611__$1;
(statearr_21651_21687[(2)] = inst_21595);

(statearr_21651_21687[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (16))){
var inst_21570 = (state_21611[(10)]);
var inst_21586 = (inst_21570 == null);
var state_21611__$1 = state_21611;
if(cljs.core.truth_(inst_21586)){
var statearr_21652_21688 = state_21611__$1;
(statearr_21652_21688[(1)] = (21));

} else {
var statearr_21653_21689 = state_21611__$1;
(statearr_21653_21689[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (10))){
var inst_21604 = (state_21611[(2)]);
var state_21611__$1 = state_21611;
var statearr_21654_21690 = state_21611__$1;
(statearr_21654_21690[(2)] = inst_21604);

(statearr_21654_21690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (18))){
var inst_21570 = (state_21611[(10)]);
var state_21611__$1 = state_21611;
var statearr_21655_21691 = state_21611__$1;
(statearr_21655_21691[(2)] = inst_21570);

(statearr_21655_21691[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21612 === (8))){
var inst_21560 = (state_21611[(11)]);
var inst_21561 = (state_21611[(12)]);
var inst_21554 = (state_21611[(9)]);
var inst_21566 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21554,inst_21560,inst_21561,false,fuel,max_fuel,opts);
var state_21611__$1 = state_21611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21611__$1,(11),inst_21566);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_21656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21656[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_21656[(1)] = (1));

return statearr_21656;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_21611){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21657){var ex__2749__auto__ = e21657;
var statearr_21658_21692 = state_21611;
(statearr_21658_21692[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21611[(4)]))){
var statearr_21659_21693 = state_21611;
(statearr_21659_21693[(1)] = cljs.core.first.call(null,(state_21611[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21694 = state_21611;
state_21611 = G__21694;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_21611){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_21611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21660 = f__2769__auto__.call(null);
(statearr_21660[(6)] = c__2768__auto__);

return statearr_21660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21729){
var state_val_21730 = (state_21729[(1)]);
if((state_val_21730 === (7))){
var inst_21706 = (state_21729[(7)]);
var inst_21711 = (state_21729[(8)]);
var inst_21713 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21706,inst_21711,fuel,max_fuel,opts);
var state_21729__$1 = state_21729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21729__$1,(10),inst_21713);
} else {
if((state_val_21730 === (1))){
var state_21729__$1 = state_21729;
var statearr_21731_21756 = state_21729__$1;
(statearr_21731_21756[(2)] = null);

(statearr_21731_21756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (4))){
var inst_21695 = (state_21729[(2)]);
var state_21729__$1 = state_21729;
var statearr_21732_21757 = state_21729__$1;
(statearr_21732_21757[(2)] = inst_21695);

(statearr_21732_21757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (13))){
var inst_21724 = (state_21729[(2)]);
var _ = (function (){var statearr_21733 = state_21729;
(statearr_21733[(4)] = cljs.core.rest.call(null,(state_21729[(4)])));

return statearr_21733;
})();
var state_21729__$1 = state_21729;
var statearr_21734_21758 = state_21729__$1;
(statearr_21734_21758[(2)] = inst_21724);

(statearr_21734_21758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (6))){
var inst_21706 = (state_21729[(7)]);
var inst_21710 = (state_21729[(2)]);
var inst_21711 = fluree.db.util.async.throw_err.call(null,inst_21710);
var state_21729__$1 = (function (){var statearr_21735 = state_21729;
(statearr_21735[(8)] = inst_21711);

return statearr_21735;
})();
if(cljs.core.truth_(inst_21706)){
var statearr_21736_21759 = state_21729__$1;
(statearr_21736_21759[(1)] = (7));

} else {
var statearr_21737_21760 = state_21729__$1;
(statearr_21737_21760[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (3))){
var inst_21727 = (state_21729[(2)]);
var state_21729__$1 = state_21729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21729__$1,inst_21727);
} else {
if((state_val_21730 === (12))){
var inst_21719 = (state_21729[(9)]);
var state_21729__$1 = state_21729;
var statearr_21738_21761 = state_21729__$1;
(statearr_21738_21761[(2)] = inst_21719);

(statearr_21738_21761[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (2))){
var _ = (function (){var statearr_21739 = state_21729;
(statearr_21739[(4)] = cljs.core.cons.call(null,(5),(state_21729[(4)])));

return statearr_21739;
})();
var inst_21702 = q_map;
var inst_21703 = cljs.core.__destructure_map.call(null,inst_21702);
var inst_21704 = cljs.core.get.call(null,inst_21703,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21705 = cljs.core.get.call(null,inst_21703,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21706 = cljs.core.get.call(null,inst_21703,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21707 = cljs.core.get.call(null,inst_21703,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21708 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21705,q_map,inst_21704,fuel,max_fuel,opts);
var state_21729__$1 = (function (){var statearr_21740 = state_21729;
(statearr_21740[(7)] = inst_21706);

(statearr_21740[(10)] = inst_21707);

return statearr_21740;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21729__$1,(6),inst_21708);
} else {
if((state_val_21730 === (11))){
var inst_21719 = (state_21729[(9)]);
var inst_21707 = (state_21729[(10)]);
var inst_21721 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_21719,inst_21707,null);
var state_21729__$1 = state_21729;
var statearr_21742_21762 = state_21729__$1;
(statearr_21742_21762[(2)] = inst_21721);

(statearr_21742_21762[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (9))){
var inst_21707 = (state_21729[(10)]);
var inst_21719 = (state_21729[(2)]);
var state_21729__$1 = (function (){var statearr_21743 = state_21729;
(statearr_21743[(9)] = inst_21719);

return statearr_21743;
})();
if(cljs.core.truth_(inst_21707)){
var statearr_21744_21763 = state_21729__$1;
(statearr_21744_21763[(1)] = (11));

} else {
var statearr_21745_21764 = state_21729__$1;
(statearr_21745_21764[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (5))){
var _ = (function (){var statearr_21746 = state_21729;
(statearr_21746[(4)] = cljs.core.rest.call(null,(state_21729[(4)])));

return statearr_21746;
})();
var state_21729__$1 = state_21729;
var ex21741 = (state_21729__$1[(2)]);
var statearr_21747_21765 = state_21729__$1;
(statearr_21747_21765[(5)] = ex21741);


if((ex21741 instanceof Error)){
var statearr_21748_21766 = state_21729__$1;
(statearr_21748_21766[(1)] = (4));

(statearr_21748_21766[(5)] = null);

} else {
throw ex21741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (10))){
var inst_21715 = (state_21729[(2)]);
var inst_21716 = fluree.db.util.async.throw_err.call(null,inst_21715);
var state_21729__$1 = state_21729;
var statearr_21749_21767 = state_21729__$1;
(statearr_21749_21767[(2)] = inst_21716);

(statearr_21749_21767[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21730 === (8))){
var inst_21711 = (state_21729[(8)]);
var state_21729__$1 = state_21729;
var statearr_21750_21768 = state_21729__$1;
(statearr_21750_21768[(2)] = inst_21711);

(statearr_21750_21768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_21751 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21751[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_21751[(1)] = (1));

return statearr_21751;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_21729){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21752){var ex__2749__auto__ = e21752;
var statearr_21753_21769 = state_21729;
(statearr_21753_21769[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21729[(4)]))){
var statearr_21754_21770 = state_21729;
(statearr_21754_21770[(1)] = cljs.core.first.call(null,(state_21729[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21771 = state_21729;
state_21729 = G__21771;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_21729){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_21729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21755 = f__2769__auto__.call(null);
(statearr_21755[(6)] = c__2768__auto__);

return statearr_21755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
