// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18215 = arguments.length;
switch (G__18215) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.call(null,operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18218 = arguments.length;
switch (G__18218) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18271 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18249){
var state_val_18250 = (state_18249[(1)]);
if((state_val_18250 === (1))){
var state_18249__$1 = state_18249;
var statearr_18251_18272 = state_18249__$1;
(statearr_18251_18272[(2)] = null);

(statearr_18251_18272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18250 === (2))){
var _ = (function (){var statearr_18252 = state_18249;
(statearr_18252[(4)] = cljs.core.cons.call(null,(5),(state_18249[(4)])));

return statearr_18252;
})();
var inst_18226 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_18249__$1 = state_18249;
if(cljs.core.truth_(inst_18226)){
var statearr_18253_18273 = state_18249__$1;
(statearr_18253_18273[(1)] = (6));

} else {
var statearr_18254_18274 = state_18249__$1;
(statearr_18254_18274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18250 === (3))){
var inst_18247 = (state_18249[(2)]);
var state_18249__$1 = state_18249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18249__$1,inst_18247);
} else {
if((state_val_18250 === (4))){
var inst_18219 = (state_18249[(2)]);
var inst_18220 = cljs.core.async.put_BANG_.call(null,pc,inst_18219);
var state_18249__$1 = state_18249;
var statearr_18256_18275 = state_18249__$1;
(statearr_18256_18275[(2)] = inst_18220);

(statearr_18256_18275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18250 === (5))){
var _ = (function (){var statearr_18257 = state_18249;
(statearr_18257[(4)] = cljs.core.rest.call(null,(state_18249[(4)])));

return statearr_18257;
})();
var state_18249__$1 = state_18249;
var ex18255 = (state_18249__$1[(2)]);
var statearr_18258_18276 = state_18249__$1;
(statearr_18258_18276[(5)] = ex18255);


var statearr_18259_18277 = state_18249__$1;
(statearr_18259_18277[(1)] = (4));

(statearr_18259_18277[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18250 === (6))){
var inst_18228 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18229 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18230 = cljs.core.PersistentHashMap.fromArrays(inst_18228,inst_18229);
var inst_18231 = cljs.core.ex_info.call(null,"Connection was closed.",inst_18230);
var inst_18232 = (function(){throw inst_18231})();
var state_18249__$1 = state_18249;
var statearr_18260_18278 = state_18249__$1;
(statearr_18260_18278[(2)] = inst_18232);

(statearr_18260_18278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18250 === (7))){
var inst_18234 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18236 = [operation,data,pc,opts];
var inst_18237 = (new cljs.core.PersistentVector(null,4,(5),inst_18235,inst_18236,null));
var inst_18238 = cljs.core.async.put_BANG_.call(null,inst_18234,inst_18237);
var inst_18239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18240 = [operation,data,pc,opts];
var inst_18241 = (new cljs.core.PersistentVector(null,4,(5),inst_18239,inst_18240,null));
var inst_18242 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18241);
var state_18249__$1 = (function (){var statearr_18261 = state_18249;
(statearr_18261[(7)] = inst_18238);

return statearr_18261;
})();
var statearr_18262_18279 = state_18249__$1;
(statearr_18262_18279[(2)] = inst_18242);

(statearr_18262_18279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18250 === (8))){
var inst_18244 = (state_18249[(2)]);
var _ = (function (){var statearr_18263 = state_18249;
(statearr_18263[(4)] = cljs.core.rest.call(null,(state_18249[(4)])));

return statearr_18263;
})();
var state_18249__$1 = state_18249;
var statearr_18264_18280 = state_18249__$1;
(statearr_18264_18280[(2)] = inst_18244);

(statearr_18264_18280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_18265 = [null,null,null,null,null,null,null,null];
(statearr_18265[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_18265[(1)] = (1));

return statearr_18265;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_18249){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18266){var ex__2749__auto__ = e18266;
var statearr_18267_18281 = state_18249;
(statearr_18267_18281[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18249[(4)]))){
var statearr_18268_18282 = state_18249;
(statearr_18268_18282[(1)] = cljs.core.first.call(null,(state_18249[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18283 = state_18249;
state_18249 = G__18283;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_18249){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_18249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18269 = f__2769__auto__.call(null);
(statearr_18269[(6)] = c__2768__auto___18271);

return statearr_18269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18285 = arguments.length;
switch (G__18285) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18286){
var map__18287 = p__18286;
var map__18287__$1 = cljs.core.__destructure_map.call(null,map__18287);
var opts = map__18287__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__18287__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18288 = session;
var map__18288__$1 = cljs.core.__destructure_map.call(null,map__18288);
var ledger_id = cljs.core.get.call(null,map__18288__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.call(null,map__18288__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__18288__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___18315 = arguments.length;
var i__5770__auto___18316 = (0);
while(true){
if((i__5770__auto___18316 < len__5769__auto___18315)){
args__5775__auto__.push((arguments[i__5770__auto___18316]));

var G__18317 = (i__5770__auto___18316 + (1));
i__5770__auto___18316 = G__18317;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18292){
var vec__18293 = p__18292;
var map__18296 = cljs.core.nth.call(null,vec__18293,(0),null);
var map__18296__$1 = cljs.core.__destructure_map.call(null,map__18296);
var toBlock = cljs.core.get.call(null,map__18296__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__18296__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18293;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18308){
var state_val_18309 = (state_18308[(1)]);
if((state_val_18309 === (1))){
var inst_18298 = session;
var inst_18299 = cljs.core.__destructure_map.call(null,inst_18298);
var inst_18300 = cljs.core.get.call(null,inst_18299,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18301 = cljs.core.get.call(null,inst_18299,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_18302 = cljs.core.get.call(null,inst_18299,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18303 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18304 = [inst_18300,inst_18301,toBlock,toTime];
var inst_18305 = cljs.core.PersistentHashMap.fromArrays(inst_18303,inst_18304);
var inst_18306 = fluree.db.operations.send_operation.call(null,inst_18302,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18305);
var state_18308__$1 = state_18308;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18308__$1,inst_18306);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_18310 = [null,null,null,null,null,null,null];
(statearr_18310[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_18310[(1)] = (1));

return statearr_18310;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_18308){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18311){var ex__2749__auto__ = e18311;
var statearr_18312_18318 = state_18308;
(statearr_18312_18318[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18308[(4)]))){
var statearr_18313_18319 = state_18308;
(statearr_18313_18319[(1)] = cljs.core.first.call(null,(state_18308[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18320 = state_18308;
state_18308 = G__18320;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_18308){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_18308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18314 = f__2769__auto__.call(null);
(statearr_18314[(6)] = c__2768__auto__);

return statearr_18314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18290){
var G__18291 = cljs.core.first.call(null,seq18290);
var seq18290__$1 = cljs.core.next.call(null,seq18290);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18291,seq18290__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18321 = session;
var map__18321__$1 = cljs.core.__destructure_map.call(null,map__18321);
var network = cljs.core.get.call(null,map__18321__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__18321__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.call(null,map__18321__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18323 = arguments.length;
switch (G__18323) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18324 = opts;
var map__18324__$1 = cljs.core.__destructure_map.call(null,map__18324);
var auth = cljs.core.get.call(null,map__18324__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__18324__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
