// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set.call(null,cljs.core.keys.call(null,fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_14623 = (function (r,node){
var x__5393__auto__ = (((r == null))?null:r);
var m__5394__auto__ = (fluree.db.index.resolve[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,r,node);
} else {
var m__5392__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,r,node);
} else {
throw cljs.core.missing_protocol.call(null,"Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_14623.call(null,r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14645){
var state_val_14646 = (state_14645[(1)]);
if((state_val_14646 === (1))){
var state_14645__$1 = state_14645;
var statearr_14647_14662 = state_14645__$1;
(statearr_14647_14662[(2)] = null);

(statearr_14647_14662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (2))){
var _ = (function (){var statearr_14648 = state_14645;
(statearr_14648[(4)] = cljs.core.cons.call(null,(6),(state_14645[(4)])));

return statearr_14648;
})();
var inst_14637 = fluree.db.index.resolve.call(null,r,node);
var state_14645__$1 = state_14645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14645__$1,(7),inst_14637);
} else {
if((state_val_14646 === (3))){
var inst_14643 = (state_14645[(2)]);
var state_14645__$1 = state_14645;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14645__$1,inst_14643);
} else {
if((state_val_14646 === (4))){
var inst_14624 = (state_14645[(2)]);
var inst_14625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14626 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_14627 = (new cljs.core.PersistentVector(null,3,(5),inst_14625,inst_14626,null));
var inst_14628 = cljs.core.select_keys.call(null,node,inst_14627);
var inst_14629 = fluree.db.util.log.error.call(null,inst_14624,"Error resolving index node:",inst_14628);
var state_14645__$1 = (function (){var statearr_14650 = state_14645;
(statearr_14650[(7)] = inst_14629);

return statearr_14650;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14645__$1,(5),error_ch,inst_14624);
} else {
if((state_val_14646 === (5))){
var inst_14631 = (state_14645[(2)]);
var state_14645__$1 = state_14645;
var statearr_14651_14663 = state_14645__$1;
(statearr_14651_14663[(2)] = inst_14631);

(statearr_14651_14663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (6))){
var _ = (function (){var statearr_14652 = state_14645;
(statearr_14652[(4)] = cljs.core.rest.call(null,(state_14645[(4)])));

return statearr_14652;
})();
var state_14645__$1 = state_14645;
var ex14649 = (state_14645__$1[(2)]);
var statearr_14653_14664 = state_14645__$1;
(statearr_14653_14664[(5)] = ex14649);


var statearr_14654_14665 = state_14645__$1;
(statearr_14654_14665[(1)] = (4));

(statearr_14654_14665[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (7))){
var inst_14639 = (state_14645[(2)]);
var inst_14640 = fluree.db.util.async.throw_err.call(null,inst_14639);
var _ = (function (){var statearr_14655 = state_14645;
(statearr_14655[(4)] = cljs.core.rest.call(null,(state_14645[(4)])));

return statearr_14655;
})();
var state_14645__$1 = state_14645;
var statearr_14656_14666 = state_14645__$1;
(statearr_14656_14666[(2)] = inst_14640);

(statearr_14656_14666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2746__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2746__auto____0 = (function (){
var statearr_14657 = [null,null,null,null,null,null,null,null];
(statearr_14657[(0)] = fluree$db$index$try_resolve_$_state_machine__2746__auto__);

(statearr_14657[(1)] = (1));

return statearr_14657;
});
var fluree$db$index$try_resolve_$_state_machine__2746__auto____1 = (function (state_14645){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14658){var ex__2749__auto__ = e14658;
var statearr_14659_14667 = state_14645;
(statearr_14659_14667[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14645[(4)]))){
var statearr_14660_14668 = state_14645;
(statearr_14660_14668[(1)] = cljs.core.first.call(null,(state_14645[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14669 = state_14645;
state_14645 = G__14669;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2746__auto__ = function(state_14645){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2746__auto____1.call(this,state_14645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2746__auto____0;
fluree$db$index$try_resolve_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2746__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14661 = f__2769__auto__.call(null);
(statearr_14661[(6)] = c__2768__auto__);

return statearr_14661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.index.branch_QMARK_.call(null,branch);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_.call(null,branch);
} else {
return and__5043__auto__;
}
})())){
var map__14670 = branch;
var map__14670__$1 = cljs.core.__destructure_map.call(null,map__14670);
var children = cljs.core.get.call(null,map__14670__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val.call(null,(function (){var or__5045__auto__ = clojure.data.avl.nearest.call(null,children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first.call(null,children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14706){
var state_val_14707 = (state_14706[(1)]);
if((state_val_14707 === (7))){
var inst_14677 = (state_14706[(7)]);
var state_14706__$1 = state_14706;
var statearr_14708_14739 = state_14706__$1;
(statearr_14708_14739[(2)] = inst_14677);

(statearr_14708_14739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (1))){
var state_14706__$1 = state_14706;
var statearr_14709_14740 = state_14706__$1;
(statearr_14709_14740[(2)] = null);

(statearr_14709_14740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (4))){
var inst_14671 = (state_14706[(2)]);
var state_14706__$1 = state_14706;
var statearr_14710_14741 = state_14706__$1;
(statearr_14710_14741[(2)] = inst_14671);

(statearr_14710_14741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (15))){
var inst_14685 = (state_14706[(8)]);
var inst_14690 = fluree.db.index.resolve.call(null,r,inst_14685);
var state_14706__$1 = state_14706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14706__$1,(17),inst_14690);
} else {
if((state_val_14707 === (13))){
var inst_14698 = (state_14706[(2)]);
var state_14706__$1 = state_14706;
var statearr_14711_14742 = state_14706__$1;
(statearr_14711_14742[(2)] = inst_14698);

(statearr_14711_14742[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (6))){
var inst_14679 = fluree.db.index.resolved_QMARK_.call(null,branch);
var state_14706__$1 = state_14706;
var statearr_14712_14743 = state_14706__$1;
(statearr_14712_14743[(2)] = inst_14679);

(statearr_14712_14743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (17))){
var inst_14692 = (state_14706[(2)]);
var inst_14693 = fluree.db.util.async.throw_err.call(null,inst_14692);
var inst_14685 = inst_14693;
var state_14706__$1 = (function (){var statearr_14713 = state_14706;
(statearr_14713[(8)] = inst_14685);

return statearr_14713;
})();
var statearr_14714_14744 = state_14706__$1;
(statearr_14714_14744[(2)] = null);

(statearr_14714_14744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (3))){
var inst_14704 = (state_14706[(2)]);
var state_14706__$1 = state_14706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14706__$1,inst_14704);
} else {
if((state_val_14707 === (12))){
var inst_14685 = (state_14706[(8)]);
var inst_14687 = fluree.db.index.leaf_QMARK_.call(null,inst_14685);
var state_14706__$1 = state_14706;
if(inst_14687){
var statearr_14715_14745 = state_14706__$1;
(statearr_14715_14745[(1)] = (14));

} else {
var statearr_14716_14746 = state_14706__$1;
(statearr_14716_14746[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (2))){
var inst_14677 = (state_14706[(7)]);
var _ = (function (){var statearr_14717 = state_14706;
(statearr_14717[(4)] = cljs.core.cons.call(null,(5),(state_14706[(4)])));

return statearr_14717;
})();
var inst_14677__$1 = fluree.db.index.branch_QMARK_.call(null,branch);
var state_14706__$1 = (function (){var statearr_14718 = state_14706;
(statearr_14718[(7)] = inst_14677__$1);

return statearr_14718;
})();
if(inst_14677__$1){
var statearr_14719_14747 = state_14706__$1;
(statearr_14719_14747[(1)] = (6));

} else {
var statearr_14720_14748 = state_14706__$1;
(statearr_14720_14748[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (11))){
var inst_14701 = (state_14706[(2)]);
var _ = (function (){var statearr_14722 = state_14706;
(statearr_14722[(4)] = cljs.core.rest.call(null,(state_14706[(4)])));

return statearr_14722;
})();
var state_14706__$1 = state_14706;
var statearr_14723_14749 = state_14706__$1;
(statearr_14723_14749[(2)] = inst_14701);

(statearr_14723_14749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (9))){
var inst_14684 = fluree.db.index.lookup.call(null,branch,flake);
var inst_14685 = inst_14684;
var state_14706__$1 = (function (){var statearr_14724 = state_14706;
(statearr_14724[(8)] = inst_14685);

return statearr_14724;
})();
var statearr_14725_14750 = state_14706__$1;
(statearr_14725_14750[(2)] = null);

(statearr_14725_14750[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (5))){
var _ = (function (){var statearr_14726 = state_14706;
(statearr_14726[(4)] = cljs.core.rest.call(null,(state_14706[(4)])));

return statearr_14726;
})();
var state_14706__$1 = state_14706;
var ex14721 = (state_14706__$1[(2)]);
var statearr_14727_14751 = state_14706__$1;
(statearr_14727_14751[(5)] = ex14721);


if((ex14721 instanceof Error)){
var statearr_14728_14752 = state_14706__$1;
(statearr_14728_14752[(1)] = (4));

(statearr_14728_14752[(5)] = null);

} else {
throw ex14721;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (14))){
var inst_14685 = (state_14706[(8)]);
var state_14706__$1 = state_14706;
var statearr_14729_14753 = state_14706__$1;
(statearr_14729_14753[(2)] = inst_14685);

(statearr_14729_14753[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (16))){
var inst_14696 = (state_14706[(2)]);
var state_14706__$1 = state_14706;
var statearr_14730_14754 = state_14706__$1;
(statearr_14730_14754[(2)] = inst_14696);

(statearr_14730_14754[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (10))){
var state_14706__$1 = state_14706;
var statearr_14731_14755 = state_14706__$1;
(statearr_14731_14755[(2)] = null);

(statearr_14731_14755[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14707 === (8))){
var inst_14682 = (state_14706[(2)]);
var state_14706__$1 = state_14706;
if(cljs.core.truth_(inst_14682)){
var statearr_14732_14756 = state_14706__$1;
(statearr_14732_14756[(1)] = (9));

} else {
var statearr_14733_14757 = state_14706__$1;
(statearr_14733_14757[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_14734 = [null,null,null,null,null,null,null,null,null];
(statearr_14734[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2746__auto__);

(statearr_14734[(1)] = (1));

return statearr_14734;
});
var fluree$db$index$lookup_leaf_$_state_machine__2746__auto____1 = (function (state_14706){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14735){var ex__2749__auto__ = e14735;
var statearr_14736_14758 = state_14706;
(statearr_14736_14758[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14706[(4)]))){
var statearr_14737_14759 = state_14706;
(statearr_14737_14759[(1)] = cljs.core.first.call(null,(state_14706[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14760 = state_14706;
state_14706 = G__14760;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2746__auto__ = function(state_14706){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2746__auto____1.call(this,state_14706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2746__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2746__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14738 = f__2769__auto__.call(null);
(statearr_14738[(6)] = c__2768__auto__);

return statearr_14738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14761 = new_leaf;
var G__14761__$1 = (((G__14761 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14761));
if((G__14761__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__14761__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14762 = new_leaf;
var G__14762__$1 = (((G__14762 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14762));
if((G__14762__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__14762__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by.call(null,cmp);
return fluree.db.index.add_flakes.call(null,cljs.core.assoc.call(null,fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14763,p__14764){
var map__14765 = p__14763;
var map__14765__$1 = cljs.core.__destructure_map.call(null,map__14765);
var branch = map__14765__$1;
var cmp = cljs.core.get.call(null,map__14765__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.call(null,map__14765__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__14765__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14765__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14766 = p__14764;
var map__14766__$1 = cljs.core.__destructure_map.call(null,map__14766);
var node = map__14766__$1;
var node_first = cljs.core.get.call(null,map__14766__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.call(null,map__14766__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_.call(null,branch)))){
return false;
} else {
var and__5043__auto__ = (function (){var or__5045__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (!((cmp.call(null,first_flake,node_first) > (0))));
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!((cmp.call(null,node_rhs,rhs) > (0))))))));
} else {
return and__5043__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14767){
var map__14768 = p__14767;
var map__14768__$1 = cljs.core.__destructure_map.call(null,map__14768);
var node = map__14768__$1;
var first = cljs.core.get.call(null,map__14768__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___14771 = arguments.length;
var i__5770__auto___14772 = (0);
while(true){
if((i__5770__auto___14772 < len__5769__auto___14771)){
args__5775__auto__.push((arguments[i__5770__auto___14772]));

var G__14773 = (i__5770__auto___14772 + (1));
i__5770__auto___14772 = G__14773;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.call(null,fluree.db.index.child_entry,child_nodes));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14769){
var G__14770 = cljs.core.first.call(null,seq14769);
var seq14769__$1 = cljs.core.next.call(null,seq14769);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14770,seq14769__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp);
var children = fluree.db.index.child_map.call(null,cmp,child_node);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14774,new_child_nodes){
var map__14775 = p__14774;
var map__14775__$1 = cljs.core.__destructure_map.call(null,map__14775);
var branch = map__14775__$1;
var comparator = cljs.core.get.call(null,map__14775__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.call(null,map__14775__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.call(null,fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__5045__auto__ = (function (){var G__14776 = new_kids;
var G__14776__$1 = (((G__14776 == null))?null:cljs.core.first.call(null,G__14776));
if((G__14776__$1 == null)){
return null;
} else {
return cljs.core.key.call(null,G__14776__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids);
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children.call(null,fluree.db.index.empty_branch.call(null,network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t.call(null,flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all.call(null,flakes,fluree.db.index.filter_after.call(null,t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14777,through_t,novelty){
var map__14778 = p__14777;
var map__14778__$1 = cljs.core.__destructure_map.call(null,map__14778);
var node = map__14778__$1;
var first_flake = cljs.core.get.call(null,map__14778__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__14778__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14778__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through.call(null,through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.call(null,(function (flakes__$1){
var last_flake = cljs.core.last.call(null,flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op.call(null,last_flake))){
return cljs.core.butlast.call(null,flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.partition_by.call(null,cljs.core.juxt.call(null,fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t)),flakes)));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14779,novelty,from_t,to_t){
var map__14780 = p__14779;
var map__14780__$1 = cljs.core.__destructure_map.call(null,map__14780);
var leaf = map__14780__$1;
var leaf_t = cljs.core.get.call(null,map__14780__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__14780__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14781 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all.call(null,G__14781,fluree.db.index.novelty_subrange.call(null,leaf,to_t,novelty));
} else {
return G__14781;
}
})();
var stale_flakes = fluree.db.index.stale_by.call(null,from_t,latest);
var subsequent = fluree.db.index.filter_after.call(null,to_t,latest);
var out_of_range = cljs.core.concat.call(null,stale_flakes,subsequent);
return fluree.db.flake.disj_all.call(null,latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14787){
var self__ = this;
var map__14788 = p__14787;
var map__14788__$1 = cljs.core.__destructure_map.call(null,map__14788);
var node = map__14788__$1;
var id = cljs.core.get.call(null,map__14788__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.call(null,map__14788__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.call(null,map__14788__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_.call(null,node)){
return fluree.db.index.resolve.call(null,self__.node_resolver,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null),(function (___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14806){
var state_val_14807 = (state_14806[(1)]);
if((state_val_14807 === (1))){
var state_14806__$1 = state_14806;
var statearr_14808_14832 = state_14806__$1;
(statearr_14808_14832[(2)] = null);

(statearr_14808_14832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (2))){
var ___$3 = (function (){var statearr_14809 = state_14806;
(statearr_14809[(4)] = cljs.core.cons.call(null,(5),(state_14806[(4)])));

return statearr_14809;
})();
var inst_14795 = fluree.db.index.resolve.call(null,self__.node_resolver,node);
var state_14806__$1 = state_14806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14806__$1,(6),inst_14795);
} else {
if((state_val_14807 === (3))){
var inst_14804 = (state_14806[(2)]);
var state_14806__$1 = state_14806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14806__$1,inst_14804);
} else {
if((state_val_14807 === (4))){
var inst_14789 = (state_14806[(2)]);
var state_14806__$1 = state_14806;
var statearr_14811_14833 = state_14806__$1;
(statearr_14811_14833[(2)] = inst_14789);

(statearr_14811_14833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (5))){
var ___$3 = (function (){var statearr_14812 = state_14806;
(statearr_14812[(4)] = cljs.core.rest.call(null,(state_14806[(4)])));

return statearr_14812;
})();
var state_14806__$1 = state_14806;
var ex14810 = (state_14806__$1[(2)]);
var statearr_14813_14834 = state_14806__$1;
(statearr_14813_14834[(5)] = ex14810);


if((ex14810 instanceof Error)){
var statearr_14814_14835 = state_14806__$1;
(statearr_14814_14835[(1)] = (4));

(statearr_14814_14835[(5)] = null);

} else {
throw ex14810;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (6))){
var inst_14797 = (state_14806[(2)]);
var inst_14798 = fluree.db.util.async.throw_err.call(null,inst_14797);
var inst_14799 = fluree.db.index.t_range.call(null,inst_14798,self__.novelty,self__.from_t,self__.to_t);
var inst_14800 = cljs.core.dissoc.call(null,inst_14798,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14801 = cljs.core.assoc.call(null,inst_14800,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14799);
var ___$3 = (function (){var statearr_14815 = state_14806;
(statearr_14815[(4)] = cljs.core.rest.call(null,(state_14806[(4)])));

return statearr_14815;
})();
var state_14806__$1 = state_14806;
var statearr_14816_14836 = state_14806__$1;
(statearr_14816_14836[(2)] = inst_14801);

(statearr_14816_14836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2746__auto__ = null;
var fluree$db$index$state_machine__2746__auto____0 = (function (){
var statearr_14817 = [null,null,null,null,null,null,null];
(statearr_14817[(0)] = fluree$db$index$state_machine__2746__auto__);

(statearr_14817[(1)] = (1));

return statearr_14817;
});
var fluree$db$index$state_machine__2746__auto____1 = (function (state_14806){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14818){var ex__2749__auto__ = e14818;
var statearr_14819_14837 = state_14806;
(statearr_14819_14837[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14806[(4)]))){
var statearr_14820_14838 = state_14806;
(statearr_14820_14838[(1)] = cljs.core.first.call(null,(state_14806[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14839 = state_14806;
state_14806 = G__14839;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$state_machine__2746__auto__ = function(state_14806){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2746__auto____1.call(this,state_14806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2746__auto____0;
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2746__auto____1;
return fluree$db$index$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14821 = f__2769__auto__.call(null);
(statearr_14821[(6)] = c__2768__auto__);

return statearr_14821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k14783,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__14822 = k14783;
var G__14822__$1 = (((G__14822 instanceof cljs.core.Keyword))?G__14822.fqn:null);
switch (G__14822__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14783,else__5346__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__14823){
var vec__14824 = p__14823;
var k__5367__auto__ = cljs.core.nth.call(null,vec__14824,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__14824,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14782){
var self__ = this;
var G__14782__$1 = this;
return (new cljs.core.RecordIter((0),G__14782__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14784,other14785){
var self__ = this;
var this14784__$1 = this;
return (((!((other14785 == null)))) && ((((this14784__$1.constructor === other14785.constructor)) && (((cljs.core._EQ_.call(null,this14784__$1.node_resolver,other14785.node_resolver)) && (((cljs.core._EQ_.call(null,this14784__$1.novelty,other14785.novelty)) && (((cljs.core._EQ_.call(null,this14784__$1.from_t,other14785.from_t)) && (((cljs.core._EQ_.call(null,this14784__$1.to_t,other14785.to_t)) && (((cljs.core._EQ_.call(null,this14784__$1.async_cache,other14785.async_cache)) && (cljs.core._EQ_.call(null,this14784__$1.__extmap,other14785.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k14783){
var self__ = this;
var this__5350__auto____$1 = this;
var G__14827 = k14783;
var G__14827__$1 = (((G__14827 instanceof cljs.core.Keyword))?G__14827.fqn:null);
switch (G__14827__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k14783);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__14782){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__14828 = cljs.core.keyword_identical_QMARK_;
var expr__14829 = k__5352__auto__;
if(cljs.core.truth_(pred__14828.call(null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),expr__14829))){
return (new fluree.db.index.CachedTRangeResolver(G__14782,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14828.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__14829))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14782,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14828.call(null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),expr__14829))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14782,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14828.call(null,new cljs.core.Keyword(null,"to-t","to-t",569467359),expr__14829))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14782,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14828.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__14829))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14782,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__14782),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__14782){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14782,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14786){
var extmap__5385__auto__ = (function (){var G__14831 = cljs.core.dissoc.call(null,G__14786,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
if(cljs.core.record_QMARK_.call(null,G__14786)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__14831);
} else {
return G__14831;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14786),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14786),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14786),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14786),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14786),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14842,t,idx_novelty){
var map__14843 = p__14842;
var map__14843__$1 = cljs.core.__destructure_map.call(null,map__14843);
var leaf = map__14843__$1;
var leaf_t = cljs.core.get.call(null,map__14843__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.call(null,map__14843__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14843__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.call(null,map__14843__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.call(null,leaf_t,t)){
return leaf;
} else {
var G__14844 = leaf;
var G__14844__$1 = (((leaf_t > t))?fluree.db.index.add_flakes.call(null,G__14844,fluree.db.index.novelty_subrange.call(null,leaf,t,idx_novelty)):G__14844);
var G__14844__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes.call(null,G__14844__$1,fluree.db.index.filter_after.call(null,t,flakes)):G__14844__$1);
return cljs.core.assoc.call(null,G__14844__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_(resolve_QMARK_.call(null,node))){
return fluree.db.index.try_resolve.call(null,r,error_ch,node);
} else {
var G__14845 = cljs.core.async.chan.call(null);
cljs.core.async.put_BANG_.call(null,G__14845,node);

return G__14845;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_.call(null,branch))){
return cljs.core.async.map.call(null,cljs.core.vector,cljs.core.map.call(null,(function (p__14846){
var vec__14847 = p__14846;
var _ = cljs.core.nth.call(null,vec__14847,(0),null);
var child = cljs.core.nth.call(null,vec__14847,(1),null);
return fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14852){
var state_val_14853 = (state_14852[(1)]);
if((state_val_14853 === (1))){
var inst_14850 = cljs.core.PersistentVector.EMPTY;
var state_14852__$1 = state_14852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14852__$1,inst_14850);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2746__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2746__auto____0 = (function (){
var statearr_14854 = [null,null,null,null,null,null,null];
(statearr_14854[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2746__auto__);

(statearr_14854[(1)] = (1));

return statearr_14854;
});
var fluree$db$index$resolve_children_when_$_state_machine__2746__auto____1 = (function (state_14852){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14855){var ex__2749__auto__ = e14855;
var statearr_14856_14859 = state_14852;
(statearr_14856_14859[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14852[(4)]))){
var statearr_14857_14860 = state_14852;
(statearr_14857_14860[(1)] = cljs.core.first.call(null,(state_14852[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14861 = state_14852;
state_14852 = G__14861;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2746__auto__ = function(state_14852){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2746__auto____1.call(this,state_14852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2746__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2746__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14858 = f__2769__auto__.call(null);
(statearr_14858[(6)] = c__2768__auto__);

return statearr_14858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14863 = arguments.length;
switch (G__14863) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.call(null,r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.call(null,n,xf);
var c__2768__auto___14941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14909){
var state_val_14910 = (state_14909[(1)]);
if((state_val_14910 === (7))){
var inst_14904 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14911_14942 = state_14909__$1;
(statearr_14911_14942[(2)] = inst_14904);

(statearr_14911_14942[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (1))){
var inst_14864 = fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,root);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14909__$1,(2),inst_14864);
} else {
if((state_val_14910 === (4))){
var inst_14906 = (state_14909[(2)]);
var inst_14907 = cljs.core.async.close_BANG_.call(null,out);
var state_14909__$1 = (function (){var statearr_14912 = state_14909;
(statearr_14912[(7)] = inst_14906);

return statearr_14912;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14909__$1,inst_14907);
} else {
if((state_val_14910 === (15))){
var state_14909__$1 = state_14909;
var statearr_14913_14943 = state_14909__$1;
(statearr_14913_14943[(2)] = null);

(statearr_14913_14943[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (13))){
var inst_14901 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14914_14944 = state_14909__$1;
(statearr_14914_14944[(2)] = inst_14901);

(statearr_14914_14944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (6))){
var state_14909__$1 = state_14909;
var statearr_14915_14945 = state_14909__$1;
(statearr_14915_14945[(2)] = null);

(statearr_14915_14945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (17))){
var inst_14886 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14916_14946 = state_14909__$1;
(statearr_14916_14946[(2)] = inst_14886);

(statearr_14916_14946[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (3))){
var inst_14872 = (state_14909[(8)]);
var inst_14870 = (state_14909[(9)]);
var inst_14872__$1 = cljs.core.peek.call(null,inst_14870);
var state_14909__$1 = (function (){var statearr_14917 = state_14909;
(statearr_14917[(8)] = inst_14872__$1);

return statearr_14917;
})();
if(cljs.core.truth_(inst_14872__$1)){
var statearr_14918_14947 = state_14909__$1;
(statearr_14918_14947[(1)] = (5));

} else {
var statearr_14919_14948 = state_14909__$1;
(statearr_14919_14948[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (12))){
var inst_14872 = (state_14909[(8)]);
var inst_14892 = fluree.db.index.resolve_children_when.call(null,r,resolve_QMARK_,error_ch,inst_14872);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14909__$1,(18),inst_14892);
} else {
if((state_val_14910 === (2))){
var inst_14866 = (state_14909[(2)]);
var inst_14867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14868 = [inst_14866];
var inst_14869 = (new cljs.core.PersistentVector(null,1,(5),inst_14867,inst_14868,null));
var inst_14870 = inst_14869;
var state_14909__$1 = (function (){var statearr_14920 = state_14909;
(statearr_14920[(9)] = inst_14870);

return statearr_14920;
})();
var statearr_14921_14949 = state_14909__$1;
(statearr_14921_14949[(2)] = null);

(statearr_14921_14949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (11))){
var inst_14872 = (state_14909[(8)]);
var inst_14882 = include_QMARK_.call(null,inst_14872);
var state_14909__$1 = state_14909;
if(cljs.core.truth_(inst_14882)){
var statearr_14922_14950 = state_14909__$1;
(statearr_14922_14950[(1)] = (14));

} else {
var statearr_14923_14951 = state_14909__$1;
(statearr_14923_14951[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (9))){
var inst_14872 = (state_14909[(8)]);
var inst_14878 = fluree.db.index.expanded_QMARK_.call(null,inst_14872);
var state_14909__$1 = state_14909;
var statearr_14924_14952 = state_14909__$1;
(statearr_14924_14952[(2)] = inst_14878);

(statearr_14924_14952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (5))){
var inst_14872 = (state_14909[(8)]);
var inst_14875 = (state_14909[(10)]);
var inst_14870 = (state_14909[(9)]);
var inst_14874 = cljs.core.pop.call(null,inst_14870);
var inst_14875__$1 = fluree.db.index.leaf_QMARK_.call(null,inst_14872);
var state_14909__$1 = (function (){var statearr_14925 = state_14909;
(statearr_14925[(10)] = inst_14875__$1);

(statearr_14925[(11)] = inst_14874);

return statearr_14925;
})();
if(inst_14875__$1){
var statearr_14926_14953 = state_14909__$1;
(statearr_14926_14953[(1)] = (8));

} else {
var statearr_14927_14954 = state_14909__$1;
(statearr_14927_14954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (14))){
var inst_14872 = (state_14909[(8)]);
var inst_14884 = fluree.db.index.unmark_expanded.call(null,inst_14872);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14909__$1,(17),out,inst_14884);
} else {
if((state_val_14910 === (16))){
var inst_14874 = (state_14909[(11)]);
var inst_14889 = (state_14909[(2)]);
var inst_14870 = inst_14874;
var state_14909__$1 = (function (){var statearr_14928 = state_14909;
(statearr_14928[(12)] = inst_14889);

(statearr_14928[(9)] = inst_14870);

return statearr_14928;
})();
var statearr_14929_14955 = state_14909__$1;
(statearr_14929_14955[(2)] = null);

(statearr_14929_14955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (10))){
var inst_14880 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
if(cljs.core.truth_(inst_14880)){
var statearr_14930_14956 = state_14909__$1;
(statearr_14930_14956[(1)] = (11));

} else {
var statearr_14931_14957 = state_14909__$1;
(statearr_14931_14957[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (18))){
var inst_14872 = (state_14909[(8)]);
var inst_14874 = (state_14909[(11)]);
var inst_14894 = (state_14909[(2)]);
var inst_14895 = fluree.db.index.mark_expanded.call(null,inst_14872);
var inst_14896 = cljs.core.conj.call(null,inst_14874,inst_14895);
var inst_14897 = cljs.core.rseq.call(null,inst_14894);
var inst_14898 = cljs.core.into.call(null,inst_14896,inst_14897);
var inst_14870 = inst_14898;
var state_14909__$1 = (function (){var statearr_14932 = state_14909;
(statearr_14932[(9)] = inst_14870);

return statearr_14932;
})();
var statearr_14933_14958 = state_14909__$1;
(statearr_14933_14958[(2)] = null);

(statearr_14933_14958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (8))){
var inst_14875 = (state_14909[(10)]);
var state_14909__$1 = state_14909;
var statearr_14934_14959 = state_14909__$1;
(statearr_14934_14959[(2)] = inst_14875);

(statearr_14934_14959[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2746__auto__ = null;
var fluree$db$index$state_machine__2746__auto____0 = (function (){
var statearr_14935 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14935[(0)] = fluree$db$index$state_machine__2746__auto__);

(statearr_14935[(1)] = (1));

return statearr_14935;
});
var fluree$db$index$state_machine__2746__auto____1 = (function (state_14909){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14936){var ex__2749__auto__ = e14936;
var statearr_14937_14960 = state_14909;
(statearr_14937_14960[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14909[(4)]))){
var statearr_14938_14961 = state_14909;
(statearr_14938_14961[(1)] = cljs.core.first.call(null,(state_14909[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14962 = state_14909;
state_14909 = G__14962;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$state_machine__2746__auto__ = function(state_14909){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2746__auto____1.call(this,state_14909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2746__auto____0;
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2746__auto____1;
return fluree$db$index$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14939 = f__2769__auto__.call(null);
(statearr_14939[(6)] = c__2768__auto___14941);

return statearr_14939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

