// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25504 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__25504,(0),null);
var network = cljs.core.nth.call(null,vec__25504,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__25504,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25507){
var map__25508 = p__25507;
var map__25508__$1 = cljs.core.__destructure_map.call(null,map__25508);
var opts = map__25508__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__25508__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25568){
var state_val_25569 = (state_25568[(1)]);
if((state_val_25569 === (7))){
var inst_25539 = cljs.core.not.call(null,reindex_QMARK_);
var state_25568__$1 = state_25568;
var statearr_25570_25594 = state_25568__$1;
(statearr_25570_25594[(2)] = inst_25539);

(statearr_25570_25594[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (1))){
var state_25568__$1 = state_25568;
var statearr_25571_25595 = state_25568__$1;
(statearr_25571_25595[(2)] = null);

(statearr_25571_25595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (4))){
var inst_25509 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
var statearr_25572_25596 = state_25568__$1;
(statearr_25572_25596[(2)] = inst_25509);

(statearr_25572_25596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (6))){
var inst_25537 = (state_25568[(7)]);
var inst_25523 = (state_25568[(8)]);
var inst_25529 = (state_25568[(9)]);
var inst_25522 = (state_25568[(2)]);
var inst_25523__$1 = fluree.db.util.async.throw_err.call(null,inst_25522);
var inst_25524 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25525 = cljs.core.__destructure_map.call(null,inst_25524);
var inst_25526 = cljs.core.get.call(null,inst_25525,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25527 = cljs.core.get.call(null,inst_25525,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25528 = fluree.db.flake.size_bytes.call(null,inst_25523__$1);
var inst_25529__$1 = (inst_25527 + inst_25528);
var inst_25530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25531 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25532 = (new cljs.core.PersistentVector(null,2,(5),inst_25530,inst_25531,null));
var inst_25533 = cljs.core.get_in.call(null,db,inst_25532);
var inst_25534 = cljs.core.__destructure_map.call(null,inst_25533);
var inst_25535 = cljs.core.get.call(null,inst_25534,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25536 = cljs.core.get.call(null,inst_25534,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25537__$1 = (inst_25529__$1 > inst_25536);
var state_25568__$1 = (function (){var statearr_25573 = state_25568;
(statearr_25573[(7)] = inst_25537__$1);

(statearr_25573[(8)] = inst_25523__$1);

(statearr_25573[(10)] = inst_25535);

(statearr_25573[(11)] = inst_25526);

(statearr_25573[(9)] = inst_25529__$1);

return statearr_25573;
})();
if(cljs.core.truth_(inst_25537__$1)){
var statearr_25574_25597 = state_25568__$1;
(statearr_25574_25597[(1)] = (7));

} else {
var statearr_25575_25598 = state_25568__$1;
(statearr_25575_25598[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (3))){
var inst_25566 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25568__$1,inst_25566);
} else {
if((state_val_25569 === (12))){
var inst_25523 = (state_25568[(8)]);
var inst_25526 = (state_25568[(11)]);
var inst_25529 = (state_25568[(9)]);
var inst_25552 = (state_25568[(2)]);
var inst_25553 = cljs.core.into.call(null,inst_25526,inst_25523);
var inst_25554 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25555 = cljs.core.swap_BANG_.call(null,inst_25554,cljs.core.empty);
var inst_25556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25557 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25558 = (new cljs.core.PersistentVector(null,2,(5),inst_25556,inst_25557,null));
var inst_25559 = cljs.core.assoc_in.call(null,db,inst_25558,inst_25553);
var inst_25560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25561 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25562 = (new cljs.core.PersistentVector(null,2,(5),inst_25560,inst_25561,null));
var inst_25563 = cljs.core.assoc_in.call(null,inst_25559,inst_25562,inst_25529);
var _ = (function (){var statearr_25576 = state_25568;
(statearr_25576[(4)] = cljs.core.rest.call(null,(state_25568[(4)])));

return statearr_25576;
})();
var state_25568__$1 = (function (){var statearr_25577 = state_25568;
(statearr_25577[(12)] = inst_25555);

(statearr_25577[(13)] = inst_25552);

return statearr_25577;
})();
var statearr_25578_25599 = state_25568__$1;
(statearr_25578_25599[(2)] = inst_25563);

(statearr_25578_25599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (2))){
var _ = (function (){var statearr_25579 = state_25568;
(statearr_25579[(4)] = cljs.core.cons.call(null,(5),(state_25568[(4)])));

return statearr_25579;
})();
var inst_25517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25518 = [pred_id];
var inst_25519 = (new cljs.core.PersistentVector(null,1,(5),inst_25517,inst_25518,null));
var inst_25520 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25519);
var state_25568__$1 = state_25568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25568__$1,(6),inst_25520);
} else {
if((state_val_25569 === (11))){
var state_25568__$1 = state_25568;
var statearr_25581_25600 = state_25568__$1;
(statearr_25581_25600[(2)] = null);

(statearr_25581_25600[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (9))){
var inst_25542 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
if(cljs.core.truth_(inst_25542)){
var statearr_25582_25601 = state_25568__$1;
(statearr_25582_25601[(1)] = (10));

} else {
var statearr_25583_25602 = state_25568__$1;
(statearr_25583_25602[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (5))){
var _ = (function (){var statearr_25584 = state_25568;
(statearr_25584[(4)] = cljs.core.rest.call(null,(state_25568[(4)])));

return statearr_25584;
})();
var state_25568__$1 = state_25568;
var ex25580 = (state_25568__$1[(2)]);
var statearr_25585_25603 = state_25568__$1;
(statearr_25585_25603[(5)] = ex25580);


if((ex25580 instanceof Error)){
var statearr_25586_25604 = state_25568__$1;
(statearr_25586_25604[(1)] = (4));

(statearr_25586_25604[(5)] = null);

} else {
throw ex25580;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (10))){
var inst_25544 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25545 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25546 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25547 = cljs.core.PersistentHashMap.fromArrays(inst_25545,inst_25546);
var inst_25548 = cljs.core.ex_info.call(null,inst_25544,inst_25547);
var inst_25549 = (function(){throw inst_25548})();
var state_25568__$1 = state_25568;
var statearr_25587_25605 = state_25568__$1;
(statearr_25587_25605[(2)] = inst_25549);

(statearr_25587_25605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (8))){
var inst_25537 = (state_25568[(7)]);
var state_25568__$1 = state_25568;
var statearr_25588_25606 = state_25568__$1;
(statearr_25588_25606[(2)] = inst_25537);

(statearr_25588_25606[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_25589 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25589[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_25589[(1)] = (1));

return statearr_25589;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_25568){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25590){var ex__2749__auto__ = e25590;
var statearr_25591_25607 = state_25568;
(statearr_25591_25607[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25568[(4)]))){
var statearr_25592_25608 = state_25568;
(statearr_25592_25608[(1)] = cljs.core.first.call(null,(state_25568[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25609 = state_25568;
state_25568 = G__25609;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_25568){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_25568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25593 = f__2769__auto__.call(null);
(statearr_25593[(6)] = c__2768__auto__);

return statearr_25593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25612 = arguments.length;
switch (G__25612) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25812){
var state_val_25813 = (state_25812[(1)]);
if((state_val_25813 === (7))){
var state_25812__$1 = state_25812;
var statearr_25814_25881 = state_25812__$1;
(statearr_25814_25881[(2)] = null);

(statearr_25814_25881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (20))){
var inst_25649 = (state_25812[(7)]);
var inst_25736 = (state_25812[(8)]);
var inst_25735 = (state_25812[(9)]);
var inst_25648 = (state_25812[(10)]);
var inst_25734 = (state_25812[(11)]);
var inst_25737 = (state_25812[(12)]);
var inst_25732 = (state_25812[(13)]);
var inst_25699 = (state_25812[(14)]);
var inst_25733 = (state_25812[(15)]);
var inst_25747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25748 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25749 = (new cljs.core.PersistentVector(null,2,(5),inst_25747,inst_25748,null));
var inst_25750 = cljs.core.get_in.call(null,inst_25699,inst_25749);
var inst_25751 = (inst_25750 + inst_25648);
var inst_25752 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25753 = [inst_25732,inst_25733,inst_25734,inst_25735,inst_25736,inst_25751];
var inst_25754 = cljs.core.PersistentHashMap.fromArrays(inst_25752,inst_25753);
var inst_25755 = cljs.core.assoc.call(null,inst_25699,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25737,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25754);
var state_25812__$1 = (function (){var statearr_25815 = state_25812;
(statearr_25815[(16)] = inst_25755);

return statearr_25815;
})();
if(cljs.core.truth_(inst_25649)){
var statearr_25816_25882 = state_25812__$1;
(statearr_25816_25882[(1)] = (23));

} else {
var statearr_25817_25883 = state_25812__$1;
(statearr_25817_25883[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (27))){
var inst_25755 = (state_25812[(16)]);
var state_25812__$1 = state_25812;
var statearr_25818_25884 = state_25812__$1;
(statearr_25818_25884[(2)] = inst_25755);

(statearr_25818_25884[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (1))){
var state_25812__$1 = state_25812;
var statearr_25819_25885 = state_25812__$1;
(statearr_25819_25885[(2)] = null);

(statearr_25819_25885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (24))){
var inst_25755 = (state_25812[(16)]);
var inst_25759 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25755);
var inst_25760 = (inst_25759 == null);
var state_25812__$1 = state_25812;
var statearr_25820_25886 = state_25812__$1;
(statearr_25820_25886[(2)] = inst_25760);

(statearr_25820_25886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (39))){
var inst_25743 = (state_25812[(17)]);
var inst_25736 = (state_25812[(8)]);
var inst_25744 = (state_25812[(18)]);
var inst_25787 = (state_25812[(19)]);
var inst_25786 = (state_25812[(20)]);
var inst_25785 = (state_25812[(21)]);
var inst_25794 = (state_25812[(22)]);
var inst_25801 = (state_25812[(2)]);
var inst_25802 = cljs.core.conj.call(null,inst_25736,inst_25743);
var inst_25731 = inst_25744;
var inst_25732 = inst_25786;
var inst_25733 = inst_25787;
var inst_25734 = inst_25794;
var inst_25735 = inst_25801;
var inst_25736__$1 = inst_25802;
var inst_25737 = inst_25785;
var state_25812__$1 = (function (){var statearr_25821 = state_25812;
(statearr_25821[(8)] = inst_25736__$1);

(statearr_25821[(23)] = inst_25731);

(statearr_25821[(9)] = inst_25735);

(statearr_25821[(11)] = inst_25734);

(statearr_25821[(12)] = inst_25737);

(statearr_25821[(13)] = inst_25732);

(statearr_25821[(15)] = inst_25733);

return statearr_25821;
})();
var statearr_25822_25887 = state_25812__$1;
(statearr_25822_25887[(2)] = null);

(statearr_25822_25887[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (4))){
var inst_25613 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25823_25888 = state_25812__$1;
(statearr_25823_25888[(2)] = inst_25613);

(statearr_25823_25888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (15))){
var inst_25671 = (state_25812[(24)]);
var state_25812__$1 = state_25812;
var statearr_25824_25889 = state_25812__$1;
(statearr_25824_25889[(2)] = inst_25671);

(statearr_25824_25889[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (21))){
var inst_25649 = (state_25812[(7)]);
var inst_25743 = (state_25812[(17)]);
var inst_25650 = (state_25812[(25)]);
var inst_25736 = (state_25812[(8)]);
var inst_25744 = (state_25812[(18)]);
var inst_25647 = (state_25812[(26)]);
var inst_25731 = (state_25812[(23)]);
var inst_25658 = (state_25812[(27)]);
var inst_25735 = (state_25812[(9)]);
var inst_25709 = (state_25812[(28)]);
var inst_25643 = (state_25812[(29)]);
var inst_25648 = (state_25812[(10)]);
var inst_25708 = (state_25812[(30)]);
var inst_25734 = (state_25812[(11)]);
var inst_25639 = (state_25812[(31)]);
var inst_25652 = (state_25812[(32)]);
var inst_25737 = (state_25812[(12)]);
var inst_25620 = (state_25812[(33)]);
var inst_25732 = (state_25812[(13)]);
var inst_25699 = (state_25812[(14)]);
var inst_25635 = (state_25812[(34)]);
var inst_25733 = (state_25812[(15)]);
var inst_25636 = (state_25812[(35)]);
var inst_25782 = fluree.db.flake.s.call(null,inst_25743);
var inst_25783 = fluree.db.flake.sid__GT_cid.call(null,inst_25782);
var inst_25784 = (function (){var flakes_bytes = inst_25648;
var vec__25704 = inst_25636;
var t = inst_25620;
var spot = inst_25732;
var add_flakes = inst_25636;
var seq__25705 = inst_25709;
var root_setting_change_QMARK_ = inst_25650;
var G__25703 = inst_25731;
var ref_QMARK__map = inst_25647;
var r = inst_25744;
var first__25706 = inst_25708;
var psot = inst_25733;
var add_pred_to_idx_QMARK_ = inst_25658;
var _ = inst_25635;
var tspo = inst_25736;
var cid = inst_25783;
var ecount = inst_25737;
var pred_ecount = inst_25652;
var db_STAR_ = inst_25699;
var system_change_QMARK_ = inst_25649;
var vec__25739 = inst_25731;
var add_preds = inst_25639;
var first__25741 = inst_25743;
var opst = inst_25735;
var idx_QMARK__map = inst_25643;
var post = inst_25734;
var f = inst_25743;
var seq__25740 = inst_25744;
return (function (p1__25610_SHARP_){
if(cljs.core.truth_(p1__25610_SHARP_)){
var x__5130__auto__ = p1__25610_SHARP_;
var y__5131__auto__ = fluree.db.flake.s.call(null,f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_25785 = cljs.core.update.call(null,inst_25737,inst_25783,inst_25784);
var inst_25786 = cljs.core.conj.call(null,inst_25732,inst_25743);
var inst_25787 = cljs.core.conj.call(null,inst_25733,inst_25743);
var inst_25788 = fluree.db.flake.p.call(null,inst_25743);
var inst_25789 = cljs.core.get.call(null,inst_25643,inst_25788);
var state_25812__$1 = (function (){var statearr_25825 = state_25812;
(statearr_25825[(19)] = inst_25787);

(statearr_25825[(20)] = inst_25786);

(statearr_25825[(21)] = inst_25785);

return statearr_25825;
})();
if(cljs.core.truth_(inst_25789)){
var statearr_25826_25890 = state_25812__$1;
(statearr_25826_25890[(1)] = (34));

} else {
var statearr_25827_25891 = state_25812__$1;
(statearr_25827_25891[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (31))){
var inst_25771 = (state_25812[(36)]);
var state_25812__$1 = state_25812;
var statearr_25828_25892 = state_25812__$1;
(statearr_25828_25892[(2)] = inst_25771);

(statearr_25828_25892[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (32))){
var inst_25780 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25829_25893 = state_25812__$1;
(statearr_25829_25893[(2)] = inst_25780);

(statearr_25829_25893[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (33))){
var inst_25771 = (state_25812[(36)]);
var inst_25775 = (state_25812[(2)]);
var inst_25776 = fluree.db.util.async.throw_err.call(null,inst_25775);
var inst_25777 = cljs.core.assoc.call(null,inst_25771,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25776);
var state_25812__$1 = state_25812;
var statearr_25830_25894 = state_25812__$1;
(statearr_25830_25894[(2)] = inst_25777);

(statearr_25830_25894[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (13))){
var inst_25648 = (state_25812[(10)]);
var inst_25620 = (state_25812[(33)]);
var inst_25699 = (state_25812[(14)]);
var inst_25636 = (state_25812[(35)]);
var inst_25689 = (state_25812[(2)]);
var inst_25690 = cljs.core.assoc.call(null,inst_25689,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25620);
var inst_25691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25692 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25693 = (new cljs.core.PersistentVector(null,2,(5),inst_25691,inst_25692,null));
var inst_25694 = cljs.core.update_in.call(null,inst_25690,inst_25693,cljs.core._PLUS_,inst_25648);
var inst_25695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25696 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25697 = (new cljs.core.PersistentVector(null,2,(5),inst_25695,inst_25696,null));
var inst_25698 = cljs.core.count.call(null,inst_25636);
var inst_25699__$1 = cljs.core.update_in.call(null,inst_25694,inst_25697,cljs.core._PLUS_,inst_25698);
var inst_25707 = cljs.core.seq.call(null,inst_25636);
var inst_25708 = cljs.core.first.call(null,inst_25707);
var inst_25709 = cljs.core.next.call(null,inst_25707);
var inst_25710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25711 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25712 = (new cljs.core.PersistentVector(null,2,(5),inst_25710,inst_25711,null));
var inst_25713 = cljs.core.get_in.call(null,inst_25699__$1,inst_25712);
var inst_25714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25715 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25716 = (new cljs.core.PersistentVector(null,2,(5),inst_25714,inst_25715,null));
var inst_25717 = cljs.core.get_in.call(null,inst_25699__$1,inst_25716);
var inst_25718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25719 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25720 = (new cljs.core.PersistentVector(null,2,(5),inst_25718,inst_25719,null));
var inst_25721 = cljs.core.get_in.call(null,inst_25699__$1,inst_25720);
var inst_25722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25723 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25724 = (new cljs.core.PersistentVector(null,2,(5),inst_25722,inst_25723,null));
var inst_25725 = cljs.core.get_in.call(null,inst_25699__$1,inst_25724);
var inst_25726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25727 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25728 = (new cljs.core.PersistentVector(null,2,(5),inst_25726,inst_25727,null));
var inst_25729 = cljs.core.get_in.call(null,inst_25699__$1,inst_25728);
var inst_25730 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25731 = inst_25636;
var inst_25732 = inst_25713;
var inst_25733 = inst_25717;
var inst_25734 = inst_25721;
var inst_25735 = inst_25725;
var inst_25736 = inst_25729;
var inst_25737 = inst_25730;
var state_25812__$1 = (function (){var statearr_25831 = state_25812;
(statearr_25831[(8)] = inst_25736);

(statearr_25831[(23)] = inst_25731);

(statearr_25831[(9)] = inst_25735);

(statearr_25831[(28)] = inst_25709);

(statearr_25831[(30)] = inst_25708);

(statearr_25831[(11)] = inst_25734);

(statearr_25831[(12)] = inst_25737);

(statearr_25831[(13)] = inst_25732);

(statearr_25831[(14)] = inst_25699__$1);

(statearr_25831[(15)] = inst_25733);

return statearr_25831;
})();
var statearr_25832_25895 = state_25812__$1;
(statearr_25832_25895[(2)] = null);

(statearr_25832_25895[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (22))){
var inst_25805 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25833_25896 = state_25812__$1;
(statearr_25833_25896[(2)] = inst_25805);

(statearr_25833_25896[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (36))){
var inst_25743 = (state_25812[(17)]);
var inst_25647 = (state_25812[(26)]);
var inst_25794 = (state_25812[(2)]);
var inst_25795 = fluree.db.flake.p.call(null,inst_25743);
var inst_25796 = cljs.core.get.call(null,inst_25647,inst_25795);
var state_25812__$1 = (function (){var statearr_25834 = state_25812;
(statearr_25834[(22)] = inst_25794);

return statearr_25834;
})();
if(cljs.core.truth_(inst_25796)){
var statearr_25835_25897 = state_25812__$1;
(statearr_25835_25897[(1)] = (37));

} else {
var statearr_25836_25898 = state_25812__$1;
(statearr_25836_25898[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (29))){
var inst_25755 = (state_25812[(16)]);
var inst_25766 = (state_25812[(2)]);
var inst_25767 = fluree.db.util.async.throw_err.call(null,inst_25766);
var inst_25768 = cljs.core.assoc.call(null,inst_25755,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25767);
var state_25812__$1 = state_25812;
var statearr_25837_25899 = state_25812__$1;
(statearr_25837_25899[(2)] = inst_25768);

(statearr_25837_25899[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (6))){
var inst_25620 = (state_25812[(33)]);
var inst_25625 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25626 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25627 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25625)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25626)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25620),"."].join('');
var inst_25628 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25629 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25630 = cljs.core.PersistentHashMap.fromArrays(inst_25628,inst_25629);
var inst_25631 = cljs.core.ex_info.call(null,inst_25627,inst_25630);
var inst_25632 = (function(){throw inst_25631})();
var state_25812__$1 = state_25812;
var statearr_25838_25900 = state_25812__$1;
(statearr_25838_25900[(2)] = inst_25632);

(statearr_25838_25900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (28))){
var inst_25650 = (state_25812[(25)]);
var inst_25771 = (state_25812[(2)]);
var state_25812__$1 = (function (){var statearr_25839 = state_25812;
(statearr_25839[(36)] = inst_25771);

return statearr_25839;
})();
if(cljs.core.truth_(inst_25650)){
var statearr_25840_25901 = state_25812__$1;
(statearr_25840_25901[(1)] = (30));

} else {
var statearr_25841_25902 = state_25812__$1;
(statearr_25841_25902[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (25))){
var inst_25762 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
if(cljs.core.truth_(inst_25762)){
var statearr_25842_25903 = state_25812__$1;
(statearr_25842_25903[(1)] = (26));

} else {
var statearr_25843_25904 = state_25812__$1;
(statearr_25843_25904[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (34))){
var inst_25743 = (state_25812[(17)]);
var inst_25734 = (state_25812[(11)]);
var inst_25791 = cljs.core.conj.call(null,inst_25734,inst_25743);
var state_25812__$1 = state_25812;
var statearr_25844_25905 = state_25812__$1;
(statearr_25844_25905[(2)] = inst_25791);

(statearr_25844_25905[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (17))){
var inst_25678 = (state_25812[(37)]);
var inst_25682 = (state_25812[(2)]);
var inst_25683 = fluree.db.util.async.throw_err.call(null,inst_25682);
var inst_25670 = inst_25678;
var inst_25671 = inst_25683;
var state_25812__$1 = (function (){var statearr_25845 = state_25812;
(statearr_25845[(24)] = inst_25671);

(statearr_25845[(38)] = inst_25670);

return statearr_25845;
})();
var statearr_25846_25906 = state_25812__$1;
(statearr_25846_25906[(2)] = null);

(statearr_25846_25906[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (3))){
var inst_25810 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25812__$1,inst_25810);
} else {
if((state_val_25813 === (12))){
var inst_25677 = (state_25812[(39)]);
var inst_25670 = (state_25812[(38)]);
var inst_25676 = cljs.core.seq.call(null,inst_25670);
var inst_25677__$1 = cljs.core.first.call(null,inst_25676);
var inst_25678 = cljs.core.next.call(null,inst_25676);
var state_25812__$1 = (function (){var statearr_25847 = state_25812;
(statearr_25847[(39)] = inst_25677__$1);

(statearr_25847[(37)] = inst_25678);

return statearr_25847;
})();
if(cljs.core.truth_(inst_25677__$1)){
var statearr_25848_25907 = state_25812__$1;
(statearr_25848_25907[(1)] = (14));

} else {
var statearr_25849_25908 = state_25812__$1;
(statearr_25849_25908[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (2))){
var inst_25620 = (state_25812[(33)]);
var _ = (function (){var statearr_25850 = state_25812;
(statearr_25850[(4)] = cljs.core.cons.call(null,(5),(state_25812[(4)])));

return statearr_25850;
})();
var inst_25619 = cljs.core.first.call(null,flakes);
var inst_25620__$1 = fluree.db.flake.t.call(null,inst_25619);
var inst_25621 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25622 = (inst_25621 - (1));
var inst_25623 = cljs.core.not_EQ_.call(null,inst_25620__$1,inst_25622);
var state_25812__$1 = (function (){var statearr_25851 = state_25812;
(statearr_25851[(33)] = inst_25620__$1);

return statearr_25851;
})();
if(inst_25623){
var statearr_25852_25909 = state_25812__$1;
(statearr_25852_25909[(1)] = (6));

} else {
var statearr_25853_25910 = state_25812__$1;
(statearr_25853_25910[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (23))){
var inst_25649 = (state_25812[(7)]);
var state_25812__$1 = state_25812;
var statearr_25854_25911 = state_25812__$1;
(statearr_25854_25911[(2)] = inst_25649);

(statearr_25854_25911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (35))){
var inst_25734 = (state_25812[(11)]);
var state_25812__$1 = state_25812;
var statearr_25855_25912 = state_25812__$1;
(statearr_25855_25912[(2)] = inst_25734);

(statearr_25855_25912[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (19))){
var inst_25807 = (state_25812[(2)]);
var _ = (function (){var statearr_25856 = state_25812;
(statearr_25856[(4)] = cljs.core.rest.call(null,(state_25812[(4)])));

return statearr_25856;
})();
var state_25812__$1 = state_25812;
var statearr_25857_25913 = state_25812__$1;
(statearr_25857_25913[(2)] = inst_25807);

(statearr_25857_25913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (11))){
var inst_25658 = (state_25812[(27)]);
var inst_25658__$1 = (state_25812[(2)]);
var inst_25666 = cljs.core.seq.call(null,inst_25658__$1);
var inst_25667 = cljs.core.first.call(null,inst_25666);
var inst_25668 = cljs.core.next.call(null,inst_25666);
var inst_25669 = db;
var inst_25670 = inst_25658__$1;
var inst_25671 = inst_25669;
var state_25812__$1 = (function (){var statearr_25859 = state_25812;
(statearr_25859[(27)] = inst_25658__$1);

(statearr_25859[(40)] = inst_25668);

(statearr_25859[(41)] = inst_25667);

(statearr_25859[(24)] = inst_25671);

(statearr_25859[(38)] = inst_25670);

return statearr_25859;
})();
var statearr_25860_25914 = state_25812__$1;
(statearr_25860_25914[(2)] = null);

(statearr_25860_25914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (9))){
var inst_25652 = (state_25812[(32)]);
var inst_25636 = (state_25812[(35)]);
var inst_25654 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_25636,inst_25652);
var state_25812__$1 = state_25812;
var statearr_25861_25915 = state_25812__$1;
(statearr_25861_25915[(2)] = inst_25654);

(statearr_25861_25915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (5))){
var _ = (function (){var statearr_25862 = state_25812;
(statearr_25862[(4)] = cljs.core.rest.call(null,(state_25812[(4)])));

return statearr_25862;
})();
var state_25812__$1 = state_25812;
var ex25858 = (state_25812__$1[(2)]);
var statearr_25863_25916 = state_25812__$1;
(statearr_25863_25916[(5)] = ex25858);


if((ex25858 instanceof Error)){
var statearr_25864_25917 = state_25812__$1;
(statearr_25864_25917[(1)] = (4));

(statearr_25864_25917[(5)] = null);

} else {
throw ex25858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (14))){
var inst_25677 = (state_25812[(39)]);
var inst_25671 = (state_25812[(24)]);
var inst_25680 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_25671,inst_25677,opts);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25812__$1,(17),inst_25680);
} else {
if((state_val_25813 === (26))){
var inst_25755 = (state_25812[(16)]);
var inst_25764 = fluree.db.query.schema.schema_map.call(null,inst_25755);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25812__$1,(29),inst_25764);
} else {
if((state_val_25813 === (16))){
var inst_25687 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25865_25918 = state_25812__$1;
(statearr_25865_25918[(2)] = inst_25687);

(statearr_25865_25918[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (38))){
var inst_25735 = (state_25812[(9)]);
var state_25812__$1 = state_25812;
var statearr_25866_25919 = state_25812__$1;
(statearr_25866_25919[(2)] = inst_25735);

(statearr_25866_25919[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (30))){
var inst_25755 = (state_25812[(16)]);
var inst_25773 = fluree.db.query.schema.setting_map.call(null,inst_25755);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25812__$1,(33),inst_25773);
} else {
if((state_val_25813 === (10))){
var inst_25656 = cljs.core.PersistentVector.EMPTY;
var state_25812__$1 = state_25812;
var statearr_25867_25920 = state_25812__$1;
(statearr_25867_25920[(2)] = inst_25656);

(statearr_25867_25920[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (18))){
var inst_25743 = (state_25812[(17)]);
var inst_25731 = (state_25812[(23)]);
var inst_25742 = cljs.core.seq.call(null,inst_25731);
var inst_25743__$1 = cljs.core.first.call(null,inst_25742);
var inst_25744 = cljs.core.next.call(null,inst_25742);
var inst_25745 = cljs.core.not.call(null,inst_25743__$1);
var state_25812__$1 = (function (){var statearr_25868 = state_25812;
(statearr_25868[(17)] = inst_25743__$1);

(statearr_25868[(18)] = inst_25744);

return statearr_25868;
})();
if(inst_25745){
var statearr_25869_25921 = state_25812__$1;
(statearr_25869_25921[(1)] = (20));

} else {
var statearr_25870_25922 = state_25812__$1;
(statearr_25870_25922[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (37))){
var inst_25743 = (state_25812[(17)]);
var inst_25735 = (state_25812[(9)]);
var inst_25798 = cljs.core.conj.call(null,inst_25735,inst_25743);
var state_25812__$1 = state_25812;
var statearr_25871_25923 = state_25812__$1;
(statearr_25871_25923[(2)] = inst_25798);

(statearr_25871_25923[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (8))){
var inst_25649 = (state_25812[(7)]);
var inst_25643 = (state_25812[(29)]);
var inst_25639 = (state_25812[(31)]);
var inst_25620 = (state_25812[(33)]);
var inst_25635 = (state_25812[(34)]);
var inst_25636 = (state_25812[(35)]);
var inst_25635__$1 = (state_25812[(2)]);
var inst_25636__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25637 = cljs.core.PersistentHashSet.EMPTY;
var inst_25638 = cljs.core.map.call(null,fluree.db.flake.p,inst_25636__$1);
var inst_25639__$1 = cljs.core.into.call(null,inst_25637,inst_25638);
var inst_25640 = cljs.core.PersistentHashMap.EMPTY;
var inst_25641 = (function (){var t = inst_25620;
var _ = inst_25635__$1;
var add_flakes = inst_25636__$1;
var add_preds = inst_25639__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25642 = cljs.core.map.call(null,inst_25641,inst_25639__$1);
var inst_25643__$1 = cljs.core.into.call(null,inst_25640,inst_25642);
var inst_25644 = cljs.core.PersistentHashMap.EMPTY;
var inst_25645 = (function (){var t = inst_25620;
var _ = inst_25635__$1;
var add_flakes = inst_25636__$1;
var add_preds = inst_25639__$1;
var idx_QMARK__map = inst_25643__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25646 = cljs.core.map.call(null,inst_25645,inst_25639__$1);
var inst_25647 = cljs.core.into.call(null,inst_25644,inst_25646);
var inst_25648 = fluree.db.flake.size_bytes.call(null,inst_25636__$1);
var inst_25649__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_25636__$1);
var inst_25650 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_25636__$1);
var inst_25651 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25652 = cljs.core.get.call(null,inst_25651,(0));
var state_25812__$1 = (function (){var statearr_25872 = state_25812;
(statearr_25872[(7)] = inst_25649__$1);

(statearr_25872[(25)] = inst_25650);

(statearr_25872[(26)] = inst_25647);

(statearr_25872[(29)] = inst_25643__$1);

(statearr_25872[(10)] = inst_25648);

(statearr_25872[(31)] = inst_25639__$1);

(statearr_25872[(32)] = inst_25652);

(statearr_25872[(34)] = inst_25635__$1);

(statearr_25872[(35)] = inst_25636__$1);

return statearr_25872;
})();
if(cljs.core.truth_(inst_25649__$1)){
var statearr_25873_25924 = state_25812__$1;
(statearr_25873_25924[(1)] = (9));

} else {
var statearr_25874_25925 = state_25812__$1;
(statearr_25874_25925[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_25875 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25875[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_25875[(1)] = (1));

return statearr_25875;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_25812){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25812);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25876){var ex__2749__auto__ = e25876;
var statearr_25877_25926 = state_25812;
(statearr_25877_25926[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25812[(4)]))){
var statearr_25878_25927 = state_25812;
(statearr_25878_25927[(1)] = cljs.core.first.call(null,(state_25812[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25928 = state_25812;
state_25812 = G__25928;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_25812){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_25812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25879 = f__2769__auto__.call(null);
(statearr_25879[(6)] = c__2768__auto__);

return statearr_25879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__25930 = arguments.length;
switch (G__25930) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26077 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26026){
var state_val_26027 = (state_26026[(1)]);
if((state_val_26027 === (7))){
var state_26026__$1 = state_26026;
var statearr_26028_26078 = state_26026__$1;
(statearr_26028_26078[(2)] = null);

(statearr_26028_26078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (20))){
var inst_25974 = (state_26026[(7)]);
var inst_25976 = (state_26026[(8)]);
var inst_25975 = (state_26026[(9)]);
var inst_25995 = (inst_25974 + (1));
var inst_25996 = cljs.core.assoc.call(null,inst_25976,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25995);
var inst_25997 = fluree.db.graphdb.with_t.call(null,inst_25996,inst_25975,opts);
var state_26026__$1 = state_26026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26026__$1,(23),inst_25997);
} else {
if((state_val_26027 === (1))){
var state_26026__$1 = state_26026;
var statearr_26029_26079 = state_26026__$1;
(statearr_26029_26079[(2)] = null);

(statearr_26029_26079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (24))){
var inst_26000 = (state_26026[(10)]);
var inst_26003 = cljs.core.assoc.call(null,inst_26000,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26026__$1 = state_26026;
var statearr_26030_26080 = state_26026__$1;
(statearr_26030_26080[(2)] = inst_26003);

(statearr_26030_26080[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (4))){
var inst_25931 = (state_26026[(2)]);
var inst_25932 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25931);
var state_26026__$1 = state_26026;
var statearr_26031_26081 = state_26026__$1;
(statearr_26031_26081[(2)] = inst_25932);

(statearr_26031_26081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (15))){
var inst_25982 = (state_26026[(11)]);
var state_26026__$1 = state_26026;
var statearr_26032_26082 = state_26026__$1;
(statearr_26032_26082[(2)] = inst_25982);

(statearr_26032_26082[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (21))){
var state_26026__$1 = state_26026;
var statearr_26033_26083 = state_26026__$1;
(statearr_26033_26083[(2)] = null);

(statearr_26033_26083[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (13))){
var inst_26018 = (state_26026[(2)]);
var inst_26019 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26018);
var state_26026__$1 = state_26026;
var statearr_26034_26084 = state_26026__$1;
(statearr_26034_26084[(2)] = inst_26019);

(statearr_26034_26084[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (22))){
var inst_26014 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
var statearr_26035_26085 = state_26026__$1;
(statearr_26035_26085[(2)] = inst_26014);

(statearr_26035_26085[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (6))){
var inst_25942 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25943 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25944 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25942)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25943)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_25945 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25946 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25947 = cljs.core.PersistentHashMap.fromArrays(inst_25945,inst_25946);
var inst_25948 = cljs.core.ex_info.call(null,inst_25944,inst_25947);
var inst_25949 = (function(){throw inst_25948})();
var state_26026__$1 = state_26026;
var statearr_26038_26086 = state_26026__$1;
(statearr_26038_26086[(2)] = inst_25949);

(statearr_26038_26086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (25))){
var inst_25982 = (state_26026[(11)]);
var inst_25983 = (state_26026[(12)]);
var inst_26000 = (state_26026[(10)]);
var inst_26005 = fluree.db.flake.t.call(null,inst_25982);
var inst_26006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26007 = [inst_25982];
var inst_26008 = (new cljs.core.PersistentVector(null,1,(5),inst_26006,inst_26007,null));
var inst_25973 = inst_25983;
var inst_25974 = inst_26005;
var inst_25975 = inst_26008;
var inst_25976 = inst_26000;
var state_26026__$1 = (function (){var statearr_26039 = state_26026;
(statearr_26039[(7)] = inst_25974);

(statearr_26039[(8)] = inst_25976);

(statearr_26039[(13)] = inst_25973);

(statearr_26039[(9)] = inst_25975);

return statearr_26039;
})();
var statearr_26040_26087 = state_26026__$1;
(statearr_26040_26087[(2)] = null);

(statearr_26040_26087[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (17))){
var inst_25974 = (state_26026[(7)]);
var inst_25982 = (state_26026[(11)]);
var inst_25983 = (state_26026[(12)]);
var inst_25976 = (state_26026[(8)]);
var inst_25975 = (state_26026[(9)]);
var inst_25991 = cljs.core.conj.call(null,inst_25975,inst_25982);
var tmp26036 = inst_25974;
var tmp26037 = inst_25976;
var inst_25973 = inst_25983;
var inst_25974__$1 = tmp26036;
var inst_25975__$1 = inst_25991;
var inst_25976__$1 = tmp26037;
var state_26026__$1 = (function (){var statearr_26041 = state_26026;
(statearr_26041[(7)] = inst_25974__$1);

(statearr_26041[(8)] = inst_25976__$1);

(statearr_26041[(13)] = inst_25973);

(statearr_26041[(9)] = inst_25975__$1);

return statearr_26041;
})();
var statearr_26042_26088 = state_26026__$1;
(statearr_26042_26088[(2)] = null);

(statearr_26042_26088[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (3))){
var inst_26024 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26026__$1,inst_26024);
} else {
if((state_val_26027 === (12))){
var inst_25982 = (state_26026[(11)]);
var inst_25973 = (state_26026[(13)]);
var inst_25981 = cljs.core.seq.call(null,inst_25973);
var inst_25982__$1 = cljs.core.first.call(null,inst_25981);
var inst_25983 = cljs.core.next.call(null,inst_25981);
var state_26026__$1 = (function (){var statearr_26043 = state_26026;
(statearr_26043[(11)] = inst_25982__$1);

(statearr_26043[(12)] = inst_25983);

return statearr_26043;
})();
if(cljs.core.truth_(inst_25982__$1)){
var statearr_26044_26089 = state_26026__$1;
(statearr_26044_26089[(1)] = (14));

} else {
var statearr_26045_26090 = state_26026__$1;
(statearr_26045_26090[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (2))){
var _ = (function (){var statearr_26046 = state_26026;
(statearr_26046[(4)] = cljs.core.cons.call(null,(5),(state_26026[(4)])));

return statearr_26046;
})();
var inst_25938 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25939 = (inst_25938 + (1));
var inst_25940 = cljs.core.not_EQ_.call(null,block,inst_25939);
var state_26026__$1 = state_26026;
if(inst_25940){
var statearr_26047_26091 = state_26026__$1;
(statearr_26047_26091[(1)] = (6));

} else {
var statearr_26048_26092 = state_26026__$1;
(statearr_26048_26092[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (23))){
var inst_25982 = (state_26026[(11)]);
var inst_25999 = (state_26026[(2)]);
var inst_26000 = fluree.db.util.async.throw_err.call(null,inst_25999);
var inst_26001 = (inst_25982 == null);
var state_26026__$1 = (function (){var statearr_26049 = state_26026;
(statearr_26049[(10)] = inst_26000);

return statearr_26049;
})();
if(cljs.core.truth_(inst_26001)){
var statearr_26050_26093 = state_26026__$1;
(statearr_26050_26093[(1)] = (24));

} else {
var statearr_26051_26094 = state_26026__$1;
(statearr_26051_26094[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (19))){
var inst_26016 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
var statearr_26052_26095 = state_26026__$1;
(statearr_26052_26095[(2)] = inst_26016);

(statearr_26052_26095[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (11))){
var inst_26021 = (state_26026[(2)]);
var _ = (function (){var statearr_26054 = state_26026;
(statearr_26054[(4)] = cljs.core.rest.call(null,(state_26026[(4)])));

return statearr_26054;
})();
var state_26026__$1 = state_26026;
var statearr_26055_26096 = state_26026__$1;
(statearr_26055_26096[(2)] = inst_26021);

(statearr_26055_26096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (9))){
var inst_25955 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_25956 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25955);
var state_26026__$1 = state_26026;
var statearr_26056_26097 = state_26026__$1;
(statearr_26056_26097[(2)] = inst_25956);

(statearr_26056_26097[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (5))){
var _ = (function (){var statearr_26057 = state_26026;
(statearr_26057[(4)] = cljs.core.rest.call(null,(state_26026[(4)])));

return statearr_26057;
})();
var state_26026__$1 = state_26026;
var ex26053 = (state_26026__$1[(2)]);
var statearr_26058_26098 = state_26026__$1;
(statearr_26058_26098[(5)] = ex26053);


var statearr_26059_26099 = state_26026__$1;
(statearr_26059_26099[(1)] = (4));

(statearr_26059_26099[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (14))){
var inst_25974 = (state_26026[(7)]);
var inst_25982 = (state_26026[(11)]);
var inst_25985 = fluree.db.flake.t.call(null,inst_25982);
var inst_25986 = cljs.core._EQ_.call(null,inst_25974,inst_25985);
var state_26026__$1 = state_26026;
var statearr_26060_26100 = state_26026__$1;
(statearr_26060_26100[(2)] = inst_25986);

(statearr_26060_26100[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (26))){
var inst_26011 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
var statearr_26061_26101 = state_26026__$1;
(statearr_26061_26101[(2)] = inst_26011);

(statearr_26061_26101[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (16))){
var inst_25989 = (state_26026[(2)]);
var state_26026__$1 = state_26026;
if(cljs.core.truth_(inst_25989)){
var statearr_26062_26102 = state_26026__$1;
(statearr_26062_26102[(1)] = (17));

} else {
var statearr_26063_26103 = state_26026__$1;
(statearr_26063_26103[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (10))){
var inst_25958 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_25966 = cljs.core.seq.call(null,inst_25958);
var inst_25967 = cljs.core.first.call(null,inst_25966);
var inst_25968 = cljs.core.next.call(null,inst_25966);
var inst_25969 = cljs.core.first.call(null,inst_25958);
var inst_25970 = fluree.db.flake.t.call(null,inst_25969);
var inst_25971 = cljs.core.PersistentVector.EMPTY;
var inst_25972 = db;
var inst_25973 = inst_25958;
var inst_25974 = inst_25970;
var inst_25975 = inst_25971;
var inst_25976 = inst_25972;
var state_26026__$1 = (function (){var statearr_26064 = state_26026;
(statearr_26064[(7)] = inst_25974);

(statearr_26064[(8)] = inst_25976);

(statearr_26064[(14)] = inst_25968);

(statearr_26064[(13)] = inst_25973);

(statearr_26064[(15)] = inst_25967);

(statearr_26064[(9)] = inst_25975);

return statearr_26064;
})();
var statearr_26065_26104 = state_26026__$1;
(statearr_26065_26104[(2)] = null);

(statearr_26065_26104[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (18))){
var state_26026__$1 = state_26026;
var statearr_26066_26105 = state_26026__$1;
(statearr_26066_26105[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26027 === (8))){
var inst_25952 = (state_26026[(2)]);
var inst_25953 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26026__$1 = (function (){var statearr_26068 = state_26026;
(statearr_26068[(16)] = inst_25952);

return statearr_26068;
})();
if(inst_25953){
var statearr_26069_26106 = state_26026__$1;
(statearr_26069_26106[(1)] = (9));

} else {
var statearr_26070_26107 = state_26026__$1;
(statearr_26070_26107[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26071[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26071[(1)] = (1));

return statearr_26071;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26026){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26072){var ex__2749__auto__ = e26072;
var statearr_26073_26108 = state_26026;
(statearr_26073_26108[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26026[(4)]))){
var statearr_26074_26109 = state_26026;
(statearr_26074_26109[(1)] = cljs.core.first.call(null,(state_26026[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26110 = state_26026;
state_26026 = G__26110;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26026){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26075 = f__2769__auto__.call(null);
(statearr_26075[(6)] = c__2768__auto___26077);

return statearr_26075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26162){
var state_val_26163 = (state_26162[(1)]);
if((state_val_26163 === (7))){
var state_26162__$1 = state_26162;
var statearr_26164_26191 = state_26162__$1;
(statearr_26164_26191[(2)] = tt_id);

(statearr_26164_26191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (1))){
var state_26162__$1 = state_26162;
var statearr_26165_26192 = state_26162__$1;
(statearr_26165_26192[(2)] = null);

(statearr_26165_26192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (4))){
var inst_26111 = (state_26162[(2)]);
var state_26162__$1 = state_26162;
var statearr_26166_26193 = state_26162__$1;
(statearr_26166_26193[(2)] = inst_26111);

(statearr_26166_26193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (13))){
var inst_26155 = (state_26162[(2)]);
var state_26162__$1 = state_26162;
var statearr_26167_26194 = state_26162__$1;
(statearr_26167_26194[(2)] = inst_26155);

(statearr_26167_26194[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (6))){
var inst_26119 = cljs.core.random_uuid.call(null);
var state_26162__$1 = state_26162;
var statearr_26168_26195 = state_26162__$1;
(statearr_26168_26195[(2)] = inst_26119);

(statearr_26168_26195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (3))){
var inst_26160 = (state_26162[(2)]);
var state_26162__$1 = state_26162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26162__$1,inst_26160);
} else {
if((state_val_26163 === (12))){
var inst_26138 = (state_26162[(7)]);
var state_26162__$1 = state_26162;
var statearr_26169_26196 = state_26162__$1;
(statearr_26169_26196[(2)] = inst_26138);

(statearr_26169_26196[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (2))){
var _ = (function (){var statearr_26170 = state_26162;
(statearr_26170[(4)] = cljs.core.cons.call(null,(5),(state_26162[(4)])));

return statearr_26170;
})();
var inst_26117 = (tt_id == null);
var state_26162__$1 = state_26162;
if(cljs.core.truth_(inst_26117)){
var statearr_26171_26197 = state_26162__$1;
(statearr_26171_26197[(1)] = (6));

} else {
var statearr_26172_26198 = state_26162__$1;
(statearr_26172_26198[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (11))){
var inst_26138 = (state_26162[(7)]);
var inst_26145 = (state_26162[(8)]);
var inst_26148 = fluree.db.graphdb.with_t.call(null,inst_26138,inst_26145);
var state_26162__$1 = state_26162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26162__$1,(14),inst_26148);
} else {
if((state_val_26163 === (9))){
var inst_26139 = (state_26162[(9)]);
var inst_26145 = (state_26162[(8)]);
var inst_26144 = cljs.core.seq.call(null,inst_26139);
var inst_26145__$1 = cljs.core.first.call(null,inst_26144);
var inst_26146 = cljs.core.next.call(null,inst_26144);
var state_26162__$1 = (function (){var statearr_26174 = state_26162;
(statearr_26174[(10)] = inst_26146);

(statearr_26174[(8)] = inst_26145__$1);

return statearr_26174;
})();
if(cljs.core.truth_(inst_26145__$1)){
var statearr_26175_26199 = state_26162__$1;
(statearr_26175_26199[(1)] = (11));

} else {
var statearr_26176_26200 = state_26162__$1;
(statearr_26176_26200[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (5))){
var _ = (function (){var statearr_26177 = state_26162;
(statearr_26177[(4)] = cljs.core.rest.call(null,(state_26162[(4)])));

return statearr_26177;
})();
var state_26162__$1 = state_26162;
var ex26173 = (state_26162__$1[(2)]);
var statearr_26178_26201 = state_26162__$1;
(statearr_26178_26201[(5)] = ex26173);


if((ex26173 instanceof Error)){
var statearr_26179_26202 = state_26162__$1;
(statearr_26179_26202[(1)] = (4));

(statearr_26179_26202[(5)] = null);

} else {
throw ex26173;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (14))){
var inst_26146 = (state_26162[(10)]);
var inst_26150 = (state_26162[(2)]);
var inst_26151 = fluree.db.util.async.throw_err.call(null,inst_26150);
var inst_26138 = inst_26151;
var inst_26139 = inst_26146;
var state_26162__$1 = (function (){var statearr_26180 = state_26162;
(statearr_26180[(7)] = inst_26138);

(statearr_26180[(9)] = inst_26139);

return statearr_26180;
})();
var statearr_26181_26203 = state_26162__$1;
(statearr_26181_26203[(2)] = null);

(statearr_26181_26203[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (10))){
var inst_26157 = (state_26162[(2)]);
var _ = (function (){var statearr_26182 = state_26162;
(statearr_26182[(4)] = cljs.core.rest.call(null,(state_26162[(4)])));

return statearr_26182;
})();
var state_26162__$1 = state_26162;
var statearr_26183_26204 = state_26162__$1;
(statearr_26183_26204[(2)] = inst_26157);

(statearr_26183_26204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26163 === (8))){
var inst_26122 = (state_26162[(2)]);
var inst_26123 = (function (){var tt_id__$1 = inst_26122;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26124 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26122);
var inst_26125 = cljs.core.reduce.call(null,inst_26123,inst_26124,fluree.db.index.types);
var inst_26126 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26127 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26126);
var inst_26135 = cljs.core.seq.call(null,inst_26127);
var inst_26136 = cljs.core.first.call(null,inst_26135);
var inst_26137 = cljs.core.next.call(null,inst_26135);
var inst_26138 = inst_26125;
var inst_26139 = inst_26127;
var state_26162__$1 = (function (){var statearr_26184 = state_26162;
(statearr_26184[(7)] = inst_26138);

(statearr_26184[(9)] = inst_26139);

(statearr_26184[(11)] = inst_26137);

(statearr_26184[(12)] = inst_26136);

return statearr_26184;
})();
var statearr_26185_26205 = state_26162__$1;
(statearr_26185_26205[(2)] = null);

(statearr_26185_26205[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_26186 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26186[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_26186[(1)] = (1));

return statearr_26186;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_26162){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26187){var ex__2749__auto__ = e26187;
var statearr_26188_26206 = state_26162;
(statearr_26188_26206[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26162[(4)]))){
var statearr_26189_26207 = state_26162;
(statearr_26189_26207[(1)] = cljs.core.first.call(null,(state_26162[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26208 = state_26162;
state_26162 = G__26208;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_26162){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_26162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26190 = f__2769__auto__.call(null);
(statearr_26190[(6)] = c__2768__auto__);

return statearr_26190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26395 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26326){
var state_val_26327 = (state_26326[(1)]);
if((state_val_26327 === (7))){
var inst_26236 = (state_26326[(7)]);
var inst_26236__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26326__$1 = (function (){var statearr_26328 = state_26326;
(statearr_26328[(7)] = inst_26236__$1);

return statearr_26328;
})();
if(inst_26236__$1){
var statearr_26329_26396 = state_26326__$1;
(statearr_26329_26396[(1)] = (13));

} else {
var statearr_26330_26397 = state_26326__$1;
(statearr_26330_26397[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (20))){
var state_26326__$1 = state_26326;
var statearr_26331_26398 = state_26326__$1;
(statearr_26331_26398[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (27))){
var inst_26272 = (state_26326[(8)]);
var inst_26276 = fluree.db.flake.s.call(null,inst_26272);
var state_26326__$1 = state_26326;
var statearr_26333_26399 = state_26326__$1;
(statearr_26333_26399[(2)] = inst_26276);

(statearr_26333_26399[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (1))){
var state_26326__$1 = state_26326;
var statearr_26334_26400 = state_26326__$1;
(statearr_26334_26400[(2)] = null);

(statearr_26334_26400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (24))){
var inst_26266 = (state_26326[(9)]);
var inst_26270 = cljs.core.first.call(null,inst_26266);
var state_26326__$1 = state_26326;
var statearr_26335_26401 = state_26326__$1;
(statearr_26335_26401[(2)] = inst_26270);

(statearr_26335_26401[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (39))){
var state_26326__$1 = state_26326;
var statearr_26336_26402 = state_26326__$1;
(statearr_26336_26402[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (4))){
var inst_26209 = (state_26326[(2)]);
var inst_26210 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26211 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26212 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26213 = cljs.core.PersistentHashMap.fromArrays(inst_26211,inst_26212);
var inst_26214 = cljs.core.ex_info.call(null,inst_26210,inst_26213,inst_26209);
var inst_26215 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26214);
var state_26326__$1 = state_26326;
var statearr_26338_26403 = state_26326__$1;
(statearr_26338_26403[(2)] = inst_26215);

(statearr_26338_26403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (15))){
var inst_26243 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
if(cljs.core.truth_(inst_26243)){
var statearr_26339_26404 = state_26326__$1;
(statearr_26339_26404[(1)] = (16));

} else {
var statearr_26340_26405 = state_26326__$1;
(statearr_26340_26405[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (21))){
var inst_26292 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26341_26406 = state_26326__$1;
(statearr_26341_26406[(2)] = inst_26292);

(statearr_26341_26406[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (31))){
var inst_26290 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26342_26407 = state_26326__$1;
(statearr_26342_26407[(2)] = inst_26290);

(statearr_26342_26407[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (32))){
var inst_26296 = (state_26326[(10)]);
var inst_26298 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26296);
var state_26326__$1 = state_26326;
var statearr_26343_26408 = state_26326__$1;
(statearr_26343_26408[(2)] = inst_26298);

(statearr_26343_26408[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (40))){
var inst_26319 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26344_26409 = state_26326__$1;
(statearr_26344_26409[(2)] = inst_26319);

(statearr_26344_26409[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (33))){
var inst_26296 = (state_26326[(10)]);
var inst_26300 = (state_26326[(11)]);
var inst_26300__$1 = (inst_26296 == null);
var state_26326__$1 = (function (){var statearr_26345 = state_26326;
(statearr_26345[(11)] = inst_26300__$1);

return statearr_26345;
})();
if(cljs.core.truth_(inst_26300__$1)){
var statearr_26346_26410 = state_26326__$1;
(statearr_26346_26410[(1)] = (35));

} else {
var statearr_26347_26411 = state_26326__$1;
(statearr_26347_26411[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (13))){
var inst_26238 = cljs.core.first.call(null,ident);
var inst_26239 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26238);
var inst_26240 = (inst_26239 == null);
var state_26326__$1 = state_26326;
var statearr_26348_26412 = state_26326__$1;
(statearr_26348_26412[(2)] = inst_26240);

(statearr_26348_26412[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (22))){
var inst_26266 = (state_26326[(9)]);
var inst_26265 = (state_26326[(2)]);
var inst_26266__$1 = fluree.db.util.async.throw_err.call(null,inst_26265);
var inst_26267 = (inst_26266__$1 == null);
var state_26326__$1 = (function (){var statearr_26349 = state_26326;
(statearr_26349[(9)] = inst_26266__$1);

return statearr_26349;
})();
if(cljs.core.truth_(inst_26267)){
var statearr_26350_26413 = state_26326__$1;
(statearr_26350_26413[(1)] = (23));

} else {
var statearr_26351_26414 = state_26326__$1;
(statearr_26351_26414[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (36))){
var inst_26300 = (state_26326[(11)]);
var state_26326__$1 = state_26326;
var statearr_26352_26415 = state_26326__$1;
(statearr_26352_26415[(2)] = inst_26300);

(statearr_26352_26415[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (41))){
var inst_26314 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26326__$1 = state_26326;
var statearr_26353_26416 = state_26326__$1;
(statearr_26353_26416[(2)] = inst_26314);

(statearr_26353_26416[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (43))){
var inst_26317 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26354_26417 = state_26326__$1;
(statearr_26354_26417[(2)] = inst_26317);

(statearr_26354_26417[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (29))){
var inst_26281 = cljs.core.pr_str.call(null,ident);
var inst_26282 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26281].join('');
var inst_26283 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26284 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26285 = cljs.core.PersistentHashMap.fromArrays(inst_26283,inst_26284);
var inst_26286 = cljs.core.ex_info.call(null,inst_26282,inst_26285);
var inst_26287 = (function(){throw inst_26286})();
var state_26326__$1 = state_26326;
var statearr_26355_26418 = state_26326__$1;
(statearr_26355_26418[(2)] = inst_26287);

(statearr_26355_26418[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (6))){
var inst_26223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26224 = [ident];
var inst_26225 = (new cljs.core.PersistentVector(null,1,(5),inst_26223,inst_26224,null));
var inst_26226 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26225);
var state_26326__$1 = state_26326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26326__$1,(9),inst_26226);
} else {
if((state_val_26327 === (28))){
var inst_26278 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26356_26419 = state_26326__$1;
(statearr_26356_26419[(2)] = inst_26278);

(statearr_26356_26419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (25))){
var inst_26272 = (state_26326[(8)]);
var inst_26272__$1 = (state_26326[(2)]);
var inst_26273 = (inst_26272__$1 == null);
var state_26326__$1 = (function (){var statearr_26357 = state_26326;
(statearr_26357[(8)] = inst_26272__$1);

return statearr_26357;
})();
if(cljs.core.truth_(inst_26273)){
var statearr_26358_26420 = state_26326__$1;
(statearr_26358_26420[(1)] = (26));

} else {
var statearr_26359_26421 = state_26326__$1;
(statearr_26359_26421[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (34))){
var inst_26321 = (state_26326[(2)]);
var _ = (function (){var statearr_26360 = state_26326;
(statearr_26360[(4)] = cljs.core.rest.call(null,(state_26326[(4)])));

return statearr_26360;
})();
var state_26326__$1 = state_26326;
var statearr_26361_26422 = state_26326__$1;
(statearr_26361_26422[(2)] = inst_26321);

(statearr_26361_26422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (17))){
var inst_26254 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26326__$1 = state_26326;
if(inst_26254){
var statearr_26362_26423 = state_26326__$1;
(statearr_26362_26423[(1)] = (19));

} else {
var statearr_26363_26424 = state_26326__$1;
(statearr_26363_26424[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (3))){
var inst_26324 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26326__$1,inst_26324);
} else {
if((state_val_26327 === (12))){
var inst_26234 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26364_26425 = state_26326__$1;
(statearr_26364_26425[(2)] = inst_26234);

(statearr_26364_26425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (2))){
var _ = (function (){var statearr_26365 = state_26326;
(statearr_26365[(4)] = cljs.core.cons.call(null,(5),(state_26326[(4)])));

return statearr_26365;
})();
var inst_26221 = typeof ident === 'number';
var state_26326__$1 = state_26326;
if(cljs.core.truth_(inst_26221)){
var statearr_26366_26426 = state_26326__$1;
(statearr_26366_26426[(1)] = (6));

} else {
var statearr_26367_26427 = state_26326__$1;
(statearr_26367_26427[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (23))){
var state_26326__$1 = state_26326;
var statearr_26368_26428 = state_26326__$1;
(statearr_26368_26428[(2)] = null);

(statearr_26368_26428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (35))){
var state_26326__$1 = state_26326;
var statearr_26369_26429 = state_26326__$1;
(statearr_26369_26429[(2)] = strict_QMARK_);

(statearr_26369_26429[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (19))){
var inst_26257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26258 = cljs.core.first.call(null,ident);
var inst_26259 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26258);
var inst_26260 = cljs.core.second.call(null,ident);
var inst_26261 = [inst_26259,inst_26260];
var inst_26262 = (new cljs.core.PersistentVector(null,2,(5),inst_26257,inst_26261,null));
var inst_26263 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26262);
var state_26326__$1 = state_26326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26326__$1,(22),inst_26263);
} else {
if((state_val_26327 === (11))){
var state_26326__$1 = state_26326;
var statearr_26371_26430 = state_26326__$1;
(statearr_26371_26430[(2)] = null);

(statearr_26371_26430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (9))){
var inst_26228 = (state_26326[(2)]);
var inst_26229 = fluree.db.util.async.throw_err.call(null,inst_26228);
var inst_26230 = cljs.core.not_empty.call(null,inst_26229);
var state_26326__$1 = state_26326;
if(cljs.core.truth_(inst_26230)){
var statearr_26372_26431 = state_26326__$1;
(statearr_26372_26431[(1)] = (10));

} else {
var statearr_26373_26432 = state_26326__$1;
(statearr_26373_26432[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (5))){
var _ = (function (){var statearr_26374 = state_26326;
(statearr_26374[(4)] = cljs.core.rest.call(null,(state_26326[(4)])));

return statearr_26374;
})();
var state_26326__$1 = state_26326;
var ex26370 = (state_26326__$1[(2)]);
var statearr_26375_26433 = state_26326__$1;
(statearr_26375_26433[(5)] = ex26370);


var statearr_26376_26434 = state_26326__$1;
(statearr_26376_26434[(1)] = (4));

(statearr_26376_26434[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (14))){
var inst_26236 = (state_26326[(7)]);
var state_26326__$1 = state_26326;
var statearr_26377_26435 = state_26326__$1;
(statearr_26377_26435[(2)] = inst_26236);

(statearr_26377_26435[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (26))){
var state_26326__$1 = state_26326;
var statearr_26378_26436 = state_26326__$1;
(statearr_26378_26436[(2)] = null);

(statearr_26378_26436[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (16))){
var inst_26245 = cljs.core.first.call(null,ident);
var inst_26246 = cljs.core.pr_str.call(null,inst_26245);
var inst_26247 = ["Subject ID lookup failed. The predicate ",inst_26246," does not exist."].join('');
var inst_26248 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26249 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26250 = cljs.core.PersistentHashMap.fromArrays(inst_26248,inst_26249);
var inst_26251 = cljs.core.ex_info.call(null,inst_26247,inst_26250);
var inst_26252 = (function(){throw inst_26251})();
var state_26326__$1 = state_26326;
var statearr_26379_26437 = state_26326__$1;
(statearr_26379_26437[(2)] = inst_26252);

(statearr_26379_26437[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (38))){
var inst_26306 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26307 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26308 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26309 = cljs.core.PersistentHashMap.fromArrays(inst_26307,inst_26308);
var inst_26310 = cljs.core.ex_info.call(null,inst_26306,inst_26309);
var inst_26311 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26310);
var state_26326__$1 = state_26326;
var statearr_26380_26438 = state_26326__$1;
(statearr_26380_26438[(2)] = inst_26311);

(statearr_26380_26438[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (30))){
var state_26326__$1 = state_26326;
var statearr_26381_26439 = state_26326__$1;
(statearr_26381_26439[(2)] = null);

(statearr_26381_26439[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (10))){
var state_26326__$1 = state_26326;
var statearr_26382_26440 = state_26326__$1;
(statearr_26382_26440[(2)] = ident);

(statearr_26382_26440[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (18))){
var inst_26294 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
var statearr_26383_26441 = state_26326__$1;
(statearr_26383_26441[(2)] = inst_26294);

(statearr_26383_26441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (42))){
var state_26326__$1 = state_26326;
var statearr_26384_26442 = state_26326__$1;
(statearr_26384_26442[(2)] = null);

(statearr_26384_26442[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (37))){
var inst_26304 = (state_26326[(2)]);
var state_26326__$1 = state_26326;
if(cljs.core.truth_(inst_26304)){
var statearr_26385_26443 = state_26326__$1;
(statearr_26385_26443[(1)] = (38));

} else {
var statearr_26386_26444 = state_26326__$1;
(statearr_26386_26444[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26327 === (8))){
var inst_26296 = (state_26326[(10)]);
var inst_26296__$1 = (state_26326[(2)]);
var state_26326__$1 = (function (){var statearr_26387 = state_26326;
(statearr_26387[(10)] = inst_26296__$1);

return statearr_26387;
})();
if(cljs.core.truth_(inst_26296__$1)){
var statearr_26388_26445 = state_26326__$1;
(statearr_26388_26445[(1)] = (32));

} else {
var statearr_26389_26446 = state_26326__$1;
(statearr_26389_26446[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_26390 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26390[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_26390[(1)] = (1));

return statearr_26390;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_26326){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26391){var ex__2749__auto__ = e26391;
var statearr_26392_26447 = state_26326;
(statearr_26392_26447[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26326[(4)]))){
var statearr_26393_26448 = state_26326;
(statearr_26393_26448[(1)] = cljs.core.first.call(null,(state_26326[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26449 = state_26326;
state_26326 = G__26449;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_26326){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_26326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26394 = f__2769__auto__.call(null);
(statearr_26394[(6)] = c__2768__auto___26395);

return statearr_26394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26450){
var map__26451 = p__26450;
var map__26451__$1 = cljs.core.__destructure_map.call(null,map__26451);
var db = map__26451__$1;
var current_db_fn = cljs.core.get.call(null,map__26451__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__26451__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26467){
var state_val_26468 = (state_26467[(1)]);
if((state_val_26468 === (1))){
var state_26467__$1 = state_26467;
var statearr_26469_26483 = state_26467__$1;
(statearr_26469_26483[(2)] = null);

(statearr_26469_26483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26468 === (2))){
var _ = (function (){var statearr_26470 = state_26467;
(statearr_26470[(4)] = cljs.core.cons.call(null,(5),(state_26467[(4)])));

return statearr_26470;
})();
var inst_26458 = current_db_fn.call(null,db);
var state_26467__$1 = state_26467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26467__$1,(6),inst_26458);
} else {
if((state_val_26468 === (3))){
var inst_26465 = (state_26467[(2)]);
var state_26467__$1 = state_26467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26467__$1,inst_26465);
} else {
if((state_val_26468 === (4))){
var inst_26452 = (state_26467[(2)]);
var state_26467__$1 = state_26467;
var statearr_26472_26484 = state_26467__$1;
(statearr_26472_26484[(2)] = inst_26452);

(statearr_26472_26484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26468 === (5))){
var _ = (function (){var statearr_26473 = state_26467;
(statearr_26473[(4)] = cljs.core.rest.call(null,(state_26467[(4)])));

return statearr_26473;
})();
var state_26467__$1 = state_26467;
var ex26471 = (state_26467__$1[(2)]);
var statearr_26474_26485 = state_26467__$1;
(statearr_26474_26485[(5)] = ex26471);


if((ex26471 instanceof Error)){
var statearr_26475_26486 = state_26467__$1;
(statearr_26475_26486[(1)] = (4));

(statearr_26475_26486[(5)] = null);

} else {
throw ex26471;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26468 === (6))){
var inst_26460 = (state_26467[(2)]);
var inst_26461 = fluree.db.util.async.throw_err.call(null,inst_26460);
var inst_26462 = cljs.core.assoc.call(null,inst_26461,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26476 = state_26467;
(statearr_26476[(4)] = cljs.core.rest.call(null,(state_26467[(4)])));

return statearr_26476;
})();
var state_26467__$1 = state_26467;
var statearr_26477_26487 = state_26467__$1;
(statearr_26477_26487[(2)] = inst_26462);

(statearr_26477_26487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_26478 = [null,null,null,null,null,null,null];
(statearr_26478[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_26478[(1)] = (1));

return statearr_26478;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_26467){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26479){var ex__2749__auto__ = e26479;
var statearr_26480_26488 = state_26467;
(statearr_26480_26488[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26467[(4)]))){
var statearr_26481_26489 = state_26467;
(statearr_26481_26489[(1)] = cljs.core.first.call(null,(state_26467[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26490 = state_26467;
state_26467 = G__26490;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_26467){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_26467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26482 = f__2769__auto__.call(null);
(statearr_26482[(6)] = c__2768__auto__);

return statearr_26482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26491,property,collection){
var map__26492 = p__26491;
var map__26492__$1 = cljs.core.__destructure_map.call(null,map__26492);
var schema = cljs.core.get.call(null,map__26492__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26493,property,predicate){
var map__26494 = p__26493;
var map__26494__$1 = cljs.core.__destructure_map.call(null,map__26494);
var this$ = map__26494__$1;
var schema = cljs.core.get.call(null,map__26494__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26495 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26495);
} else {
return G__26495;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26497 = arguments.length;
switch (G__26497) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26529){
var state_val_26530 = (state_26529[(1)]);
if((state_val_26530 === (7))){
var state_26529__$1 = state_26529;
var statearr_26531_26625 = state_26529__$1;
(statearr_26531_26625[(2)] = null);

(statearr_26531_26625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (1))){
var state_26529__$1 = state_26529;
var statearr_26532_26626 = state_26529__$1;
(statearr_26532_26626[(2)] = null);

(statearr_26532_26626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (4))){
var inst_26498 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26533_26627 = state_26529__$1;
(statearr_26533_26627[(2)] = inst_26498);

(statearr_26533_26627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (6))){
var inst_26512 = (state_26529[(7)]);
var inst_26511 = (state_26529[(2)]);
var inst_26512__$1 = fluree.db.util.async.throw_err.call(null,inst_26511);
var inst_26513 = (inst_26512__$1 == null);
var state_26529__$1 = (function (){var statearr_26534 = state_26529;
(statearr_26534[(7)] = inst_26512__$1);

return statearr_26534;
})();
if(cljs.core.truth_(inst_26513)){
var statearr_26535_26628 = state_26529__$1;
(statearr_26535_26628[(1)] = (7));

} else {
var statearr_26536_26629 = state_26529__$1;
(statearr_26536_26629[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (3))){
var inst_26527 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26529__$1,inst_26527);
} else {
if((state_val_26530 === (12))){
var inst_26524 = (state_26529[(2)]);
var _ = (function (){var statearr_26537 = state_26529;
(statearr_26537[(4)] = cljs.core.rest.call(null,(state_26529[(4)])));

return statearr_26537;
})();
var state_26529__$1 = state_26529;
var statearr_26538_26630 = state_26529__$1;
(statearr_26538_26630[(2)] = inst_26524);

(statearr_26538_26630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (2))){
var _ = (function (){var statearr_26539 = state_26529;
(statearr_26539[(4)] = cljs.core.cons.call(null,(5),(state_26529[(4)])));

return statearr_26539;
})();
var inst_26505 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26507 = [tag_id,(30)];
var inst_26508 = (new cljs.core.PersistentVector(null,2,(5),inst_26506,inst_26507,null));
var inst_26509 = fluree.db.query.range.index_range.call(null,inst_26505,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26508);
var state_26529__$1 = state_26529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26529__$1,(6),inst_26509);
} else {
if((state_val_26530 === (11))){
var inst_26518 = (state_26529[(8)]);
var inst_26522 = fluree.db.flake.o.call(null,inst_26518);
var state_26529__$1 = state_26529;
var statearr_26541_26631 = state_26529__$1;
(statearr_26541_26631[(2)] = inst_26522);

(statearr_26541_26631[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (9))){
var inst_26518 = (state_26529[(8)]);
var inst_26518__$1 = (state_26529[(2)]);
var inst_26519 = (inst_26518__$1 == null);
var state_26529__$1 = (function (){var statearr_26542 = state_26529;
(statearr_26542[(8)] = inst_26518__$1);

return statearr_26542;
})();
if(cljs.core.truth_(inst_26519)){
var statearr_26543_26632 = state_26529__$1;
(statearr_26543_26632[(1)] = (10));

} else {
var statearr_26544_26633 = state_26529__$1;
(statearr_26544_26633[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (5))){
var _ = (function (){var statearr_26545 = state_26529;
(statearr_26545[(4)] = cljs.core.rest.call(null,(state_26529[(4)])));

return statearr_26545;
})();
var state_26529__$1 = state_26529;
var ex26540 = (state_26529__$1[(2)]);
var statearr_26546_26634 = state_26529__$1;
(statearr_26546_26634[(5)] = ex26540);


if((ex26540 instanceof Error)){
var statearr_26547_26635 = state_26529__$1;
(statearr_26547_26635[(1)] = (4));

(statearr_26547_26635[(5)] = null);

} else {
throw ex26540;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (10))){
var state_26529__$1 = state_26529;
var statearr_26548_26636 = state_26529__$1;
(statearr_26548_26636[(2)] = null);

(statearr_26548_26636[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26530 === (8))){
var inst_26512 = (state_26529[(7)]);
var inst_26516 = cljs.core.first.call(null,inst_26512);
var state_26529__$1 = state_26529;
var statearr_26549_26637 = state_26529__$1;
(statearr_26549_26637[(2)] = inst_26516);

(statearr_26549_26637[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26550 = [null,null,null,null,null,null,null,null,null];
(statearr_26550[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26550[(1)] = (1));

return statearr_26550;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26529){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26551){var ex__2749__auto__ = e26551;
var statearr_26552_26638 = state_26529;
(statearr_26552_26638[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26529[(4)]))){
var statearr_26553_26639 = state_26529;
(statearr_26553_26639[(1)] = cljs.core.first.call(null,(state_26529[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26640 = state_26529;
state_26529 = G__26640;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26529){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26554 = f__2769__auto__.call(null);
(statearr_26554[(6)] = c__2768__auto__);

return statearr_26554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26590){
var state_val_26591 = (state_26590[(1)]);
if((state_val_26591 === (7))){
var inst_26564 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26590__$1 = state_26590;
var statearr_26592_26641 = state_26590__$1;
(statearr_26592_26641[(2)] = inst_26564);

(statearr_26592_26641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (1))){
var state_26590__$1 = state_26590;
var statearr_26593_26642 = state_26590__$1;
(statearr_26593_26642[(2)] = null);

(statearr_26593_26642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (4))){
var inst_26555 = (state_26590[(2)]);
var state_26590__$1 = state_26590;
var statearr_26594_26643 = state_26590__$1;
(statearr_26594_26643[(2)] = inst_26555);

(statearr_26594_26643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (15))){
var inst_26585 = (state_26590[(2)]);
var _ = (function (){var statearr_26595 = state_26590;
(statearr_26595[(4)] = cljs.core.rest.call(null,(state_26590[(4)])));

return statearr_26595;
})();
var state_26590__$1 = state_26590;
var statearr_26596_26644 = state_26590__$1;
(statearr_26596_26644[(2)] = inst_26585);

(statearr_26596_26644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (13))){
var inst_26570 = (state_26590[(7)]);
var inst_26576 = clojure.string.includes_QMARK_.call(null,inst_26570,":");
var state_26590__$1 = state_26590;
if(inst_26576){
var statearr_26597_26645 = state_26590__$1;
(statearr_26597_26645[(1)] = (16));

} else {
var statearr_26598_26646 = state_26590__$1;
(statearr_26598_26646[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (6))){
var state_26590__$1 = state_26590;
var statearr_26599_26647 = state_26590__$1;
(statearr_26599_26647[(2)] = pred);

(statearr_26599_26647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (17))){
var inst_26570 = (state_26590[(7)]);
var state_26590__$1 = state_26590;
var statearr_26600_26648 = state_26590__$1;
(statearr_26600_26648[(2)] = inst_26570);

(statearr_26600_26648[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (3))){
var inst_26588 = (state_26590[(2)]);
var state_26590__$1 = state_26590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26590__$1,inst_26588);
} else {
if((state_val_26591 === (12))){
var inst_26574 = (state_26590[(2)]);
var state_26590__$1 = state_26590;
if(cljs.core.truth_(inst_26574)){
var statearr_26601_26649 = state_26590__$1;
(statearr_26601_26649[(1)] = (13));

} else {
var statearr_26602_26650 = state_26590__$1;
(statearr_26602_26650[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (2))){
var _ = (function (){var statearr_26603 = state_26590;
(statearr_26603[(4)] = cljs.core.cons.call(null,(5),(state_26590[(4)])));

return statearr_26603;
})();
var inst_26561 = typeof pred === 'string';
var state_26590__$1 = state_26590;
if(cljs.core.truth_(inst_26561)){
var statearr_26604_26651 = state_26590__$1;
(statearr_26604_26651[(1)] = (6));

} else {
var statearr_26605_26652 = state_26590__$1;
(statearr_26605_26652[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (11))){
var inst_26566 = (state_26590[(8)]);
var state_26590__$1 = state_26590;
var statearr_26607_26653 = state_26590__$1;
(statearr_26607_26653[(2)] = inst_26566);

(statearr_26607_26653[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (9))){
var inst_26566 = (state_26590[(8)]);
var inst_26569 = (state_26590[(2)]);
var inst_26570 = fluree.db.util.async.throw_err.call(null,inst_26569);
var state_26590__$1 = (function (){var statearr_26608 = state_26590;
(statearr_26608[(7)] = inst_26570);

return statearr_26608;
})();
if(cljs.core.truth_(inst_26566)){
var statearr_26609_26654 = state_26590__$1;
(statearr_26609_26654[(1)] = (10));

} else {
var statearr_26610_26655 = state_26590__$1;
(statearr_26610_26655[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (5))){
var _ = (function (){var statearr_26611 = state_26590;
(statearr_26611[(4)] = cljs.core.rest.call(null,(state_26590[(4)])));

return statearr_26611;
})();
var state_26590__$1 = state_26590;
var ex26606 = (state_26590__$1[(2)]);
var statearr_26612_26656 = state_26590__$1;
(statearr_26612_26656[(5)] = ex26606);


if((ex26606 instanceof Error)){
var statearr_26613_26657 = state_26590__$1;
(statearr_26613_26657[(1)] = (4));

(statearr_26613_26657[(5)] = null);

} else {
throw ex26606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (14))){
var state_26590__$1 = state_26590;
var statearr_26614_26658 = state_26590__$1;
(statearr_26614_26658[(2)] = null);

(statearr_26614_26658[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (16))){
var inst_26570 = (state_26590[(7)]);
var inst_26578 = clojure.string.split.call(null,inst_26570,/:/);
var inst_26579 = cljs.core.second.call(null,inst_26578);
var state_26590__$1 = state_26590;
var statearr_26615_26659 = state_26590__$1;
(statearr_26615_26659[(2)] = inst_26579);

(statearr_26615_26659[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (10))){
var inst_26570 = (state_26590[(7)]);
var state_26590__$1 = state_26590;
var statearr_26616_26660 = state_26590__$1;
(statearr_26616_26660[(2)] = inst_26570);

(statearr_26616_26660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (18))){
var inst_26582 = (state_26590[(2)]);
var state_26590__$1 = state_26590;
var statearr_26617_26661 = state_26590__$1;
(statearr_26617_26661[(2)] = inst_26582);

(statearr_26617_26661[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26591 === (8))){
var inst_26566 = (state_26590[(2)]);
var inst_26567 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_26590__$1 = (function (){var statearr_26618 = state_26590;
(statearr_26618[(8)] = inst_26566);

return statearr_26618;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26590__$1,(9),inst_26567);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26619 = [null,null,null,null,null,null,null,null,null];
(statearr_26619[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26619[(1)] = (1));

return statearr_26619;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26590){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26620){var ex__2749__auto__ = e26620;
var statearr_26621_26662 = state_26590;
(statearr_26621_26662[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26590[(4)]))){
var statearr_26622_26663 = state_26590;
(statearr_26622_26663[(1)] = cljs.core.first.call(null,(state_26590[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26664 = state_26590;
state_26590 = G__26664;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26590){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26623 = f__2769__auto__.call(null);
(statearr_26623[(6)] = c__2768__auto__);

return statearr_26623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26666 = arguments.length;
switch (G__26666) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26699){
var state_val_26700 = (state_26699[(1)]);
if((state_val_26700 === (7))){
var state_26699__$1 = state_26699;
var statearr_26701_26789 = state_26699__$1;
(statearr_26701_26789[(2)] = null);

(statearr_26701_26789[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (1))){
var state_26699__$1 = state_26699;
var statearr_26702_26790 = state_26699__$1;
(statearr_26702_26790[(2)] = null);

(statearr_26702_26790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (4))){
var inst_26667 = (state_26699[(2)]);
var state_26699__$1 = state_26699;
var statearr_26703_26791 = state_26699__$1;
(statearr_26703_26791[(2)] = inst_26667);

(statearr_26703_26791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (6))){
var inst_26682 = (state_26699[(7)]);
var inst_26681 = (state_26699[(2)]);
var inst_26682__$1 = fluree.db.util.async.throw_err.call(null,inst_26681);
var inst_26683 = (inst_26682__$1 == null);
var state_26699__$1 = (function (){var statearr_26704 = state_26699;
(statearr_26704[(7)] = inst_26682__$1);

return statearr_26704;
})();
if(cljs.core.truth_(inst_26683)){
var statearr_26705_26792 = state_26699__$1;
(statearr_26705_26792[(1)] = (7));

} else {
var statearr_26706_26793 = state_26699__$1;
(statearr_26706_26793[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (3))){
var inst_26697 = (state_26699[(2)]);
var state_26699__$1 = state_26699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26699__$1,inst_26697);
} else {
if((state_val_26700 === (12))){
var inst_26694 = (state_26699[(2)]);
var _ = (function (){var statearr_26707 = state_26699;
(statearr_26707[(4)] = cljs.core.rest.call(null,(state_26699[(4)])));

return statearr_26707;
})();
var state_26699__$1 = state_26699;
var statearr_26708_26794 = state_26699__$1;
(statearr_26708_26794[(2)] = inst_26694);

(statearr_26708_26794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (2))){
var _ = (function (){var statearr_26709 = state_26699;
(statearr_26709[(4)] = cljs.core.cons.call(null,(5),(state_26699[(4)])));

return statearr_26709;
})();
var inst_26673 = (30);
var inst_26675 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26677 = [inst_26673,tag_name];
var inst_26678 = (new cljs.core.PersistentVector(null,2,(5),inst_26676,inst_26677,null));
var inst_26679 = fluree.db.query.range.index_range.call(null,inst_26675,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26678);
var state_26699__$1 = state_26699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26699__$1,(6),inst_26679);
} else {
if((state_val_26700 === (11))){
var inst_26688 = (state_26699[(8)]);
var inst_26692 = fluree.db.flake.s.call(null,inst_26688);
var state_26699__$1 = state_26699;
var statearr_26711_26795 = state_26699__$1;
(statearr_26711_26795[(2)] = inst_26692);

(statearr_26711_26795[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (9))){
var inst_26688 = (state_26699[(8)]);
var inst_26688__$1 = (state_26699[(2)]);
var inst_26689 = (inst_26688__$1 == null);
var state_26699__$1 = (function (){var statearr_26712 = state_26699;
(statearr_26712[(8)] = inst_26688__$1);

return statearr_26712;
})();
if(cljs.core.truth_(inst_26689)){
var statearr_26713_26796 = state_26699__$1;
(statearr_26713_26796[(1)] = (10));

} else {
var statearr_26714_26797 = state_26699__$1;
(statearr_26714_26797[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (5))){
var _ = (function (){var statearr_26715 = state_26699;
(statearr_26715[(4)] = cljs.core.rest.call(null,(state_26699[(4)])));

return statearr_26715;
})();
var state_26699__$1 = state_26699;
var ex26710 = (state_26699__$1[(2)]);
var statearr_26716_26798 = state_26699__$1;
(statearr_26716_26798[(5)] = ex26710);


if((ex26710 instanceof Error)){
var statearr_26717_26799 = state_26699__$1;
(statearr_26717_26799[(1)] = (4));

(statearr_26717_26799[(5)] = null);

} else {
throw ex26710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (10))){
var state_26699__$1 = state_26699;
var statearr_26718_26800 = state_26699__$1;
(statearr_26718_26800[(2)] = null);

(statearr_26718_26800[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26700 === (8))){
var inst_26682 = (state_26699[(7)]);
var inst_26686 = cljs.core.first.call(null,inst_26682);
var state_26699__$1 = state_26699;
var statearr_26719_26801 = state_26699__$1;
(statearr_26719_26801[(2)] = inst_26686);

(statearr_26719_26801[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26720 = [null,null,null,null,null,null,null,null,null];
(statearr_26720[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26720[(1)] = (1));

return statearr_26720;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26699){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26721){var ex__2749__auto__ = e26721;
var statearr_26722_26802 = state_26699;
(statearr_26722_26802[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26699[(4)]))){
var statearr_26723_26803 = state_26699;
(statearr_26723_26803[(1)] = cljs.core.first.call(null,(state_26699[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26804 = state_26699;
state_26699 = G__26804;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26699){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26724 = f__2769__auto__.call(null);
(statearr_26724[(6)] = c__2768__auto__);

return statearr_26724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26759){
var state_val_26760 = (state_26759[(1)]);
if((state_val_26760 === (7))){
var inst_26738 = typeof pred === 'string';
var state_26759__$1 = state_26759;
if(cljs.core.truth_(inst_26738)){
var statearr_26761_26805 = state_26759__$1;
(statearr_26761_26805[(1)] = (10));

} else {
var statearr_26762_26806 = state_26759__$1;
(statearr_26762_26806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (1))){
var state_26759__$1 = state_26759;
var statearr_26763_26807 = state_26759__$1;
(statearr_26763_26807[(2)] = null);

(statearr_26763_26807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (4))){
var inst_26725 = (state_26759[(2)]);
var state_26759__$1 = state_26759;
var statearr_26764_26808 = state_26759__$1;
(statearr_26764_26808[(2)] = inst_26725);

(statearr_26764_26808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (15))){
var inst_26752 = (state_26759[(2)]);
var state_26759__$1 = state_26759;
var statearr_26765_26809 = state_26759__$1;
(statearr_26765_26809[(2)] = inst_26752);

(statearr_26765_26809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (13))){
var inst_26743 = (state_26759[(7)]);
var inst_26745 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26743),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26746 = fluree.db.dbproto._tag_id.call(null,this$,inst_26745);
var state_26759__$1 = state_26759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26759__$1,(16),inst_26746);
} else {
if((state_val_26760 === (6))){
var inst_26733 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_26759__$1 = state_26759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26759__$1,(9),inst_26733);
} else {
if((state_val_26760 === (3))){
var inst_26757 = (state_26759[(2)]);
var state_26759__$1 = state_26759;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26759__$1,inst_26757);
} else {
if((state_val_26760 === (12))){
var inst_26743 = (state_26759[(7)]);
var inst_26743__$1 = (state_26759[(2)]);
var state_26759__$1 = (function (){var statearr_26766 = state_26759;
(statearr_26766[(7)] = inst_26743__$1);

return statearr_26766;
})();
if(cljs.core.truth_(inst_26743__$1)){
var statearr_26767_26810 = state_26759__$1;
(statearr_26767_26810[(1)] = (13));

} else {
var statearr_26768_26811 = state_26759__$1;
(statearr_26768_26811[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (2))){
var _ = (function (){var statearr_26769 = state_26759;
(statearr_26769[(4)] = cljs.core.cons.call(null,(5),(state_26759[(4)])));

return statearr_26769;
})();
var inst_26731 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_26759__$1 = state_26759;
if(inst_26731){
var statearr_26770_26812 = state_26759__$1;
(statearr_26770_26812[(1)] = (6));

} else {
var statearr_26771_26813 = state_26759__$1;
(statearr_26771_26813[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (11))){
var inst_26741 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26759__$1 = state_26759;
var statearr_26773_26814 = state_26759__$1;
(statearr_26773_26814[(2)] = inst_26741);

(statearr_26773_26814[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (9))){
var inst_26735 = (state_26759[(2)]);
var inst_26736 = fluree.db.util.async.throw_err.call(null,inst_26735);
var state_26759__$1 = state_26759;
var statearr_26774_26815 = state_26759__$1;
(statearr_26774_26815[(2)] = inst_26736);

(statearr_26774_26815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (5))){
var _ = (function (){var statearr_26775 = state_26759;
(statearr_26775[(4)] = cljs.core.rest.call(null,(state_26759[(4)])));

return statearr_26775;
})();
var state_26759__$1 = state_26759;
var ex26772 = (state_26759__$1[(2)]);
var statearr_26776_26816 = state_26759__$1;
(statearr_26776_26816[(5)] = ex26772);


if((ex26772 instanceof Error)){
var statearr_26777_26817 = state_26759__$1;
(statearr_26777_26817[(1)] = (4));

(statearr_26777_26817[(5)] = null);

} else {
throw ex26772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (14))){
var state_26759__$1 = state_26759;
var statearr_26778_26818 = state_26759__$1;
(statearr_26778_26818[(2)] = null);

(statearr_26778_26818[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (16))){
var inst_26748 = (state_26759[(2)]);
var inst_26749 = fluree.db.util.async.throw_err.call(null,inst_26748);
var state_26759__$1 = state_26759;
var statearr_26779_26819 = state_26759__$1;
(statearr_26779_26819[(2)] = inst_26749);

(statearr_26779_26819[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (10))){
var state_26759__$1 = state_26759;
var statearr_26780_26820 = state_26759__$1;
(statearr_26780_26820[(2)] = pred);

(statearr_26780_26820[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26760 === (8))){
var inst_26754 = (state_26759[(2)]);
var _ = (function (){var statearr_26781 = state_26759;
(statearr_26781[(4)] = cljs.core.rest.call(null,(state_26759[(4)])));

return statearr_26781;
})();
var state_26759__$1 = state_26759;
var statearr_26782_26821 = state_26759__$1;
(statearr_26782_26821[(2)] = inst_26754);

(statearr_26782_26821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26783 = [null,null,null,null,null,null,null,null];
(statearr_26783[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26783[(1)] = (1));

return statearr_26783;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26759){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26784){var ex__2749__auto__ = e26784;
var statearr_26785_26822 = state_26759;
(statearr_26785_26822[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26759[(4)]))){
var statearr_26786_26823 = state_26759;
(statearr_26786_26823[(1)] = cljs.core.first.call(null,(state_26759[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26824 = state_26759;
state_26759 = G__26824;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26759){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26787 = f__2769__auto__.call(null);
(statearr_26787[(6)] = c__2768__auto__);

return statearr_26787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k26826,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__26830 = k26826;
var G__26830__$1 = (((G__26830 instanceof cljs.core.Keyword))?G__26830.fqn:null);
switch (G__26830__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26826,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__26831){
var vec__26832 = p__26831;
var k__5367__auto__ = cljs.core.nth.call(null,vec__26832,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__26832,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26825){
var self__ = this;
var G__26825__$1 = this;
return (new cljs.core.RecordIter((0),G__26825__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26827,other26828){
var self__ = this;
var this26827__$1 = this;
return (((!((other26828 == null)))) && ((((this26827__$1.constructor === other26828.constructor)) && (((cljs.core._EQ_.call(null,this26827__$1.conn,other26828.conn)) && (((cljs.core._EQ_.call(null,this26827__$1.network,other26828.network)) && (((cljs.core._EQ_.call(null,this26827__$1.ledger_id,other26828.ledger_id)) && (((cljs.core._EQ_.call(null,this26827__$1.block,other26828.block)) && (((cljs.core._EQ_.call(null,this26827__$1.t,other26828.t)) && (((cljs.core._EQ_.call(null,this26827__$1.tt_id,other26828.tt_id)) && (((cljs.core._EQ_.call(null,this26827__$1.stats,other26828.stats)) && (((cljs.core._EQ_.call(null,this26827__$1.spot,other26828.spot)) && (((cljs.core._EQ_.call(null,this26827__$1.psot,other26828.psot)) && (((cljs.core._EQ_.call(null,this26827__$1.post,other26828.post)) && (((cljs.core._EQ_.call(null,this26827__$1.opst,other26828.opst)) && (((cljs.core._EQ_.call(null,this26827__$1.tspo,other26828.tspo)) && (((cljs.core._EQ_.call(null,this26827__$1.schema,other26828.schema)) && (((cljs.core._EQ_.call(null,this26827__$1.settings,other26828.settings)) && (((cljs.core._EQ_.call(null,this26827__$1.comparators,other26828.comparators)) && (((cljs.core._EQ_.call(null,this26827__$1.schema_cache,other26828.schema_cache)) && (((cljs.core._EQ_.call(null,this26827__$1.novelty,other26828.novelty)) && (((cljs.core._EQ_.call(null,this26827__$1.permissions,other26828.permissions)) && (((cljs.core._EQ_.call(null,this26827__$1.fork,other26828.fork)) && (((cljs.core._EQ_.call(null,this26827__$1.fork_block,other26828.fork_block)) && (((cljs.core._EQ_.call(null,this26827__$1.current_db_fn,other26828.current_db_fn)) && (cljs.core._EQ_.call(null,this26827__$1.__extmap,other26828.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k26826){
var self__ = this;
var this__5350__auto____$1 = this;
var G__26835 = k26826;
var G__26835__$1 = (((G__26835 instanceof cljs.core.Keyword))?G__26835.fqn:null);
switch (G__26835__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26826);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__26825){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__26836 = cljs.core.keyword_identical_QMARK_;
var expr__26837 = k__5352__auto__;
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26837))){
return (new fluree.db.graphdb.GraphDb(G__26825,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26825,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26825,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26825,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26825,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26825,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26825,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26825,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26825,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26825,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26825,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26825,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26825,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26825,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26825,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26825,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26825,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26825,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26825,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26825,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26836.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__26837))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26825,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__26825),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__26825){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26825,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26829){
var extmap__5385__auto__ = (function (){var G__26839 = cljs.core.dissoc.call(null,G__26829,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__26829)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26839);
} else {
return G__26839;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26829),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26829),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__26842 = fluree.db.index.default_comparators;
var map__26842__$1 = cljs.core.__destructure_map.call(null,map__26842);
var spot_cmp = cljs.core.get.call(null,map__26842__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__26842__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__26842__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__26842__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__26842__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
