// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41113 = arguments.length;
var i__5770__auto___41114 = (0);
while(true){
if((i__5770__auto___41114 < len__5769__auto___41113)){
args__5775__auto__.push((arguments[i__5770__auto___41114]));

var G__41115 = (i__5770__auto___41114 + (1));
i__5770__auto___41114 = G__41115;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq41110){
var G__41111 = cljs.core.first.call(null,seq41110);
var seq41110__$1 = cljs.core.next.call(null,seq41110);
var G__41112 = cljs.core.first.call(null,seq41110__$1);
var seq41110__$2 = cljs.core.next.call(null,seq41110__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41111,G__41112,seq41110__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e41116){var e = e41116;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e41117){var e = e41117;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e41118){var e = e41118;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e41119){var e = e41119;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e41120){var e = e41120;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41123 = arguments.length;
var i__5770__auto___41124 = (0);
while(true){
if((i__5770__auto___41124 < len__5769__auto___41123)){
args__5775__auto__.push((arguments[i__5770__auto___41124]));

var G__41125 = (i__5770__auto___41124 + (1));
i__5770__auto___41124 = G__41125;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e41122){var e = e41122;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq41121){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41121));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41128 = arguments.length;
var i__5770__auto___41129 = (0);
while(true){
if((i__5770__auto___41129 < len__5769__auto___41128)){
args__5775__auto__.push((arguments[i__5770__auto___41129]));

var G__41130 = (i__5770__auto___41129 + (1));
i__5770__auto___41129 = G__41130;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e41127){var e = e41127;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq41126){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41126));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e41131){var e = e41131;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41134 = arguments.length;
var i__5770__auto___41135 = (0);
while(true){
if((i__5770__auto___41135 < len__5769__auto___41134)){
args__5775__auto__.push((arguments[i__5770__auto___41135]));

var G__41136 = (i__5770__auto___41135 + (1));
i__5770__auto___41135 = G__41136;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e41133){var e = e41133;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq41132){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41132));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41139 = arguments.length;
var i__5770__auto___41140 = (0);
while(true){
if((i__5770__auto___41140 < len__5769__auto___41139)){
args__5775__auto__.push((arguments[i__5770__auto___41140]));

var G__41141 = (i__5770__auto___41140 + (1));
i__5770__auto___41140 = G__41141;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e41138){var e = e41138;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq41137){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41137));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e41142){var e = e41142;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e41143){var e = e41143;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41146 = arguments.length;
var i__5770__auto___41147 = (0);
while(true){
if((i__5770__auto___41147 < len__5769__auto___41146)){
args__5775__auto__.push((arguments[i__5770__auto___41147]));

var G__41148 = (i__5770__auto___41147 + (1));
i__5770__auto___41147 = G__41148;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e41145){var e = e41145;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq41144){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41144));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41151 = arguments.length;
var i__5770__auto___41152 = (0);
while(true){
if((i__5770__auto___41152 < len__5769__auto___41151)){
args__5775__auto__.push((arguments[i__5770__auto___41152]));

var G__41153 = (i__5770__auto___41152 + (1));
i__5770__auto___41152 = G__41153;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e41150){var e = e41150;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq41149){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41149));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41156 = arguments.length;
var i__5770__auto___41157 = (0);
while(true){
if((i__5770__auto___41157 < len__5769__auto___41156)){
args__5775__auto__.push((arguments[i__5770__auto___41157]));

var G__41158 = (i__5770__auto___41157 + (1));
i__5770__auto___41157 = G__41158;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e41155){var e = e41155;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq41154){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41154));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41161 = arguments.length;
var i__5770__auto___41162 = (0);
while(true){
if((i__5770__auto___41162 < len__5769__auto___41161)){
args__5775__auto__.push((arguments[i__5770__auto___41162]));

var G__41163 = (i__5770__auto___41162 + (1));
i__5770__auto___41162 = G__41163;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e41160){var e = e41160;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq41159){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41159));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41166 = arguments.length;
var i__5770__auto___41167 = (0);
while(true){
if((i__5770__auto___41167 < len__5769__auto___41166)){
args__5775__auto__.push((arguments[i__5770__auto___41167]));

var G__41168 = (i__5770__auto___41167 + (1));
i__5770__auto___41167 = G__41168;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e41165){var e = e41165;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq41164){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41164));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41171 = arguments.length;
var i__5770__auto___41172 = (0);
while(true){
if((i__5770__auto___41172 < len__5769__auto___41171)){
args__5775__auto__.push((arguments[i__5770__auto___41172]));

var G__41173 = (i__5770__auto___41172 + (1));
i__5770__auto___41172 = G__41173;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e41170){var e = e41170;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq41169){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41169));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41176 = arguments.length;
var i__5770__auto___41177 = (0);
while(true){
if((i__5770__auto___41177 < len__5769__auto___41176)){
args__5775__auto__.push((arguments[i__5770__auto___41177]));

var G__41178 = (i__5770__auto___41177 + (1));
i__5770__auto___41177 = G__41178;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e41175){var e = e41175;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq41174){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41174));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__41180 = arguments.length;
switch (G__41180) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41208){
var state_val_41209 = (state_41208[(1)]);
if((state_val_41209 === (7))){
var inst_41193 = (state_41208[(7)]);
var inst_41196 = fluree.db.dbfunctions.internal.function_error.call(null,inst_41193,"query",query_map);
var state_41208__$1 = state_41208;
var statearr_41210_41296 = state_41208__$1;
(statearr_41210_41296[(2)] = inst_41196);

(statearr_41210_41296[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41209 === (1))){
var state_41208__$1 = state_41208;
var statearr_41211_41297 = state_41208__$1;
(statearr_41211_41297[(2)] = null);

(statearr_41211_41297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41209 === (4))){
var inst_41181 = (state_41208[(2)]);
var state_41208__$1 = state_41208;
var statearr_41212_41298 = state_41208__$1;
(statearr_41212_41298[(2)] = inst_41181);

(statearr_41212_41298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41209 === (6))){
var inst_41193 = (state_41208[(7)]);
var inst_41193__$1 = (state_41208[(2)]);
var inst_41194 = fluree.db.util.core.exception_QMARK_.call(null,inst_41193__$1);
var state_41208__$1 = (function (){var statearr_41213 = state_41208;
(statearr_41213[(7)] = inst_41193__$1);

return statearr_41213;
})();
if(inst_41194){
var statearr_41214_41299 = state_41208__$1;
(statearr_41214_41299[(1)] = (7));

} else {
var statearr_41215_41300 = state_41208__$1;
(statearr_41215_41300[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41209 === (3))){
var inst_41206 = (state_41208[(2)]);
var state_41208__$1 = state_41208;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41208__$1,inst_41206);
} else {
if((state_val_41209 === (2))){
var inst_41187 = (state_41208[(8)]);
var _ = (function (){var statearr_41217 = state_41208;
(statearr_41217[(4)] = cljs.core.cons.call(null,(5),(state_41208[(4)])));

return statearr_41217;
})();
var inst_41187__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_41188 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_41189 = cljs.core.assoc.call(null,inst_41188,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_41187__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_41190 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_41189);
var inst_41191 = fluree.db.query.fql.query.call(null,db,inst_41190);
var state_41208__$1 = (function (){var statearr_41218 = state_41208;
(statearr_41218[(8)] = inst_41187__$1);

return statearr_41218;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41208__$1,(6),inst_41191);
} else {
if((state_val_41209 === (9))){
var inst_41203 = (state_41208[(2)]);
var _ = (function (){var statearr_41219 = state_41208;
(statearr_41219[(4)] = cljs.core.rest.call(null,(state_41208[(4)])));

return statearr_41219;
})();
var state_41208__$1 = state_41208;
var statearr_41220_41301 = state_41208__$1;
(statearr_41220_41301[(2)] = inst_41203);

(statearr_41220_41301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41209 === (5))){
var _ = (function (){var statearr_41221 = state_41208;
(statearr_41221[(4)] = cljs.core.rest.call(null,(state_41208[(4)])));

return statearr_41221;
})();
var state_41208__$1 = state_41208;
var ex41216 = (state_41208__$1[(2)]);
var statearr_41222_41302 = state_41208__$1;
(statearr_41222_41302[(5)] = ex41216);


if((ex41216 instanceof Error)){
var statearr_41223_41303 = state_41208__$1;
(statearr_41223_41303[(1)] = (4));

(statearr_41223_41303[(5)] = null);

} else {
throw ex41216;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41209 === (8))){
var inst_41187 = (state_41208[(8)]);
var inst_41193 = (state_41208[(7)]);
var inst_41198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41199 = cljs.core.deref.call(null,inst_41187);
var inst_41200 = [inst_41193,inst_41199];
var inst_41201 = (new cljs.core.PersistentVector(null,2,(5),inst_41198,inst_41200,null));
var state_41208__$1 = state_41208;
var statearr_41224_41304 = state_41208__$1;
(statearr_41224_41304[(2)] = inst_41201);

(statearr_41224_41304[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_41225 = [null,null,null,null,null,null,null,null,null];
(statearr_41225[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_41225[(1)] = (1));

return statearr_41225;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_41208){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41208);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41226){var ex__2749__auto__ = e41226;
var statearr_41227_41305 = state_41208;
(statearr_41227_41305[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41208[(4)]))){
var statearr_41228_41306 = state_41208;
(statearr_41228_41306[(1)] = cljs.core.first.call(null,(state_41208[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41307 = state_41208;
state_41208 = G__41307;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_41208){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_41208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41229 = f__2769__auto__.call(null);
(statearr_41229[(6)] = c__2768__auto__);

return statearr_41229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41274){
var state_val_41275 = (state_41274[(1)]);
if((state_val_41275 === (7))){
var inst_41260 = (state_41274[(2)]);
var inst_41261 = fluree.db.query.fql.query.call(null,db,inst_41260);
var state_41274__$1 = state_41274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41274__$1,(8),inst_41261);
} else {
if((state_val_41275 === (1))){
var inst_41230 = typeof select === 'string';
var state_41274__$1 = state_41274;
if(cljs.core.truth_(inst_41230)){
var statearr_41276_41308 = state_41274__$1;
(statearr_41276_41308[(1)] = (2));

} else {
var statearr_41277_41309 = state_41274__$1;
(statearr_41277_41309[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (4))){
var inst_41236 = (state_41274[(7)]);
var inst_41243 = (state_41274[(8)]);
var inst_41235 = (state_41274[(2)]);
var inst_41236__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_41237 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41238 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_41239 = [inst_41236__$1,(100000)];
var inst_41240 = cljs.core.PersistentHashMap.fromArrays(inst_41238,inst_41239);
var inst_41241 = [inst_41235,from,where,block,limit,inst_41240];
var inst_41242 = cljs.core.PersistentHashMap.fromArrays(inst_41237,inst_41241);
var inst_41243__$1 = fluree.db.util.core.without_nils.call(null,inst_41242);
var inst_41244 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_41243__$1);
var inst_41245 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_41243__$1);
var inst_41246 = cljs.core.first.call(null,inst_41245);
var inst_41247 = fluree.db.dbfunctions.internal.str.call(null,inst_41246);
var inst_41248 = cljs.core._EQ_.call(null,"[",inst_41247);
var inst_41249 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_41243__$1);
var inst_41250 = cljs.core.last.call(null,inst_41249);
var inst_41251 = fluree.db.dbfunctions.internal.str.call(null,inst_41250);
var inst_41252 = cljs.core._EQ_.call(null,"]",inst_41251);
var inst_41253 = fluree.db.dbfunctions.internal.and.call(null,inst_41244,inst_41248,inst_41252);
var state_41274__$1 = (function (){var statearr_41278 = state_41274;
(statearr_41278[(7)] = inst_41236__$1);

(statearr_41278[(8)] = inst_41243__$1);

return statearr_41278;
})();
if(cljs.core.truth_(inst_41253)){
var statearr_41279_41310 = state_41274__$1;
(statearr_41279_41310[(1)] = (5));

} else {
var statearr_41280_41311 = state_41274__$1;
(statearr_41280_41311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (6))){
var inst_41243 = (state_41274[(8)]);
var state_41274__$1 = state_41274;
var statearr_41281_41312 = state_41274__$1;
(statearr_41281_41312[(2)] = inst_41243);

(statearr_41281_41312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (3))){
var state_41274__$1 = state_41274;
var statearr_41282_41313 = state_41274__$1;
(statearr_41282_41313[(2)] = select);

(statearr_41282_41313[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (2))){
var inst_41232 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_41274__$1 = state_41274;
var statearr_41283_41314 = state_41274__$1;
(statearr_41283_41314[(2)] = inst_41232);

(statearr_41283_41314[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (11))){
var inst_41272 = (state_41274[(2)]);
var state_41274__$1 = state_41274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41274__$1,inst_41272);
} else {
if((state_val_41275 === (9))){
var inst_41263 = (state_41274[(9)]);
var state_41274__$1 = state_41274;
var statearr_41284_41315 = state_41274__$1;
(statearr_41284_41315[(2)] = inst_41263);

(statearr_41284_41315[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (5))){
var inst_41243 = (state_41274[(8)]);
var inst_41255 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_41243);
var inst_41256 = cljs.reader.read_string.call(null,inst_41255);
var inst_41257 = cljs.core.assoc.call(null,inst_41243,new cljs.core.Keyword(null,"where","where",-2044795965),inst_41256);
var state_41274__$1 = state_41274;
var statearr_41285_41316 = state_41274__$1;
(statearr_41285_41316[(2)] = inst_41257);

(statearr_41285_41316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (10))){
var inst_41236 = (state_41274[(7)]);
var inst_41263 = (state_41274[(9)]);
var inst_41267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41268 = cljs.core.deref.call(null,inst_41236);
var inst_41269 = [inst_41263,inst_41268];
var inst_41270 = (new cljs.core.PersistentVector(null,2,(5),inst_41267,inst_41269,null));
var state_41274__$1 = state_41274;
var statearr_41286_41317 = state_41274__$1;
(statearr_41286_41317[(2)] = inst_41270);

(statearr_41286_41317[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41275 === (8))){
var inst_41263 = (state_41274[(9)]);
var inst_41263__$1 = (state_41274[(2)]);
var inst_41264 = fluree.db.util.core.exception_QMARK_.call(null,inst_41263__$1);
var state_41274__$1 = (function (){var statearr_41287 = state_41274;
(statearr_41287[(9)] = inst_41263__$1);

return statearr_41287;
})();
if(inst_41264){
var statearr_41288_41318 = state_41274__$1;
(statearr_41288_41318[(1)] = (9));

} else {
var statearr_41289_41319 = state_41274__$1;
(statearr_41289_41319[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_41290 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41290[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_41290[(1)] = (1));

return statearr_41290;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_41274){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41291){var ex__2749__auto__ = e41291;
var statearr_41292_41320 = state_41274;
(statearr_41292_41320[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41274[(4)]))){
var statearr_41293_41321 = state_41274;
(statearr_41293_41321[(1)] = cljs.core.first.call(null,(state_41274[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41322 = state_41274;
state_41274 = G__41322;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_41274){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_41274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41294 = f__2769__auto__.call(null);
(statearr_41294[(6)] = c__2768__auto__);

return statearr_41294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__41326 = path;
var vec__41327 = G__41326;
var seq__41328 = cljs.core.seq.call(null,vec__41327);
var first__41329 = cljs.core.first.call(null,seq__41328);
var seq__41328__$1 = cljs.core.next.call(null,seq__41328);
var var$ = first__41329;
var r = seq__41328__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__41326__$1 = G__41326;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__41333 = G__41326__$1;
var seq__41334 = cljs.core.seq.call(null,vec__41333);
var first__41335 = cljs.core.first.call(null,seq__41334);
var seq__41334__$1 = cljs.core.next.call(null,seq__41334);
var var$__$1 = first__41335;
var r__$1 = seq__41334__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__41336 = r__$1;
var G__41337 = n__$2;
var G__41338 = next_clauses;
G__41326__$1 = G__41336;
n__$1 = G__41337;
where_clauses__$1 = G__41338;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__41339 = r__$1;
var G__41340 = next_n;
var G__41341 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__41326__$1 = G__41339;
n__$1 = G__41340;
where_clauses__$1 = G__41341;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41378){
var state_val_41379 = (state_41378[(1)]);
if((state_val_41379 === (7))){
var inst_41351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41352 = [path];
var inst_41353 = (new cljs.core.PersistentVector(null,1,(5),inst_41351,inst_41352,null));
var state_41378__$1 = state_41378;
var statearr_41380_41408 = state_41378__$1;
(statearr_41380_41408[(2)] = inst_41353);

(statearr_41380_41408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (1))){
var state_41378__$1 = state_41378;
var statearr_41381_41409 = state_41378__$1;
(statearr_41381_41409[(2)] = null);

(statearr_41381_41409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (4))){
var inst_41342 = (state_41378[(2)]);
var state_41378__$1 = state_41378;
var statearr_41382_41410 = state_41378__$1;
(statearr_41382_41410[(2)] = inst_41342);

(statearr_41382_41410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (13))){
var inst_41369 = (state_41378[(2)]);
var inst_41370 = fluree.db.util.async.throw_err.call(null,inst_41369);
var _ = (function (){var statearr_41383 = state_41378;
(statearr_41383[(4)] = cljs.core.rest.call(null,(state_41378[(4)])));

return statearr_41383;
})();
var state_41378__$1 = state_41378;
var statearr_41384_41411 = state_41378__$1;
(statearr_41384_41411[(2)] = inst_41370);

(statearr_41384_41411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (6))){
var state_41378__$1 = state_41378;
var statearr_41386_41412 = state_41378__$1;
(statearr_41386_41412[(2)] = path);

(statearr_41386_41412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (3))){
var inst_41376 = (state_41378[(2)]);
var state_41378__$1 = state_41378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41378__$1,inst_41376);
} else {
if((state_val_41379 === (12))){
var _ = (function (){var statearr_41387 = state_41378;
(statearr_41387[(4)] = cljs.core.rest.call(null,(state_41378[(4)])));

return statearr_41387;
})();
var state_41378__$1 = state_41378;
var ex41385 = (state_41378__$1[(2)]);
var statearr_41388_41413 = state_41378__$1;
(statearr_41388_41413[(5)] = ex41385);


var statearr_41389_41414 = state_41378__$1;
(statearr_41389_41414[(1)] = (11));

(statearr_41389_41414[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (2))){
var _ = (function (){var statearr_41390 = state_41378;
(statearr_41390[(4)] = cljs.core.cons.call(null,(5),(state_41378[(4)])));

return statearr_41390;
})();
var inst_41348 = cljs.core.vector_QMARK_.call(null,path);
var state_41378__$1 = state_41378;
if(inst_41348){
var statearr_41391_41415 = state_41378__$1;
(statearr_41391_41415[(1)] = (6));

} else {
var statearr_41392_41416 = state_41378__$1;
(statearr_41392_41416[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (11))){
var inst_41355 = (state_41378[(7)]);
var inst_41360 = (state_41378[(2)]);
var inst_41361 = fluree.db.dbfunctions.internal.function_error.call(null,inst_41360,"relationship?",startSubject,inst_41355,endSubject);
var state_41378__$1 = state_41378;
var statearr_41394_41417 = state_41378__$1;
(statearr_41394_41417[(2)] = inst_41361);

(statearr_41394_41417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (9))){
var inst_41359 = (state_41378[(8)]);
var _ = (function (){var statearr_41395 = state_41378;
(statearr_41395[(4)] = cljs.core.cons.call(null,(12),(state_41378[(4)])));

return statearr_41395;
})();
var inst_41367 = fluree.db.dbfunctions.internal.query.call(null,db,inst_41359);
var state_41378__$1 = state_41378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41378__$1,(13),inst_41367);
} else {
if((state_val_41379 === (5))){
var _ = (function (){var statearr_41396 = state_41378;
(statearr_41396[(4)] = cljs.core.rest.call(null,(state_41378[(4)])));

return statearr_41396;
})();
var state_41378__$1 = state_41378;
var ex41393 = (state_41378__$1[(2)]);
var statearr_41397_41418 = state_41378__$1;
(statearr_41397_41418[(5)] = ex41393);


if((ex41393 instanceof Error)){
var statearr_41398_41419 = state_41378__$1;
(statearr_41398_41419[(1)] = (4));

(statearr_41398_41419[(5)] = null);

} else {
throw ex41393;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (10))){
var inst_41373 = (state_41378[(2)]);
var _ = (function (){var statearr_41399 = state_41378;
(statearr_41399[(4)] = cljs.core.rest.call(null,(state_41378[(4)])));

return statearr_41399;
})();
var state_41378__$1 = state_41378;
var statearr_41400_41420 = state_41378__$1;
(statearr_41400_41420[(2)] = inst_41373);

(statearr_41400_41420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41379 === (8))){
var inst_41355 = (state_41378[(7)]);
var inst_41355__$1 = (state_41378[(2)]);
var inst_41356 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_41355__$1,endSubject);
var inst_41357 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_41358 = ["?var1",inst_41356];
var inst_41359 = cljs.core.PersistentHashMap.fromArrays(inst_41357,inst_41358);
var state_41378__$1 = (function (){var statearr_41401 = state_41378;
(statearr_41401[(7)] = inst_41355__$1);

(statearr_41401[(8)] = inst_41359);

return statearr_41401;
})();
var statearr_41402_41421 = state_41378__$1;
(statearr_41402_41421[(2)] = null);

(statearr_41402_41421[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_41403 = [null,null,null,null,null,null,null,null,null];
(statearr_41403[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_41403[(1)] = (1));

return statearr_41403;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_41378){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41404){var ex__2749__auto__ = e41404;
var statearr_41405_41422 = state_41378;
(statearr_41405_41422[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41378[(4)]))){
var statearr_41406_41423 = state_41378;
(statearr_41406_41423[(1)] = cljs.core.first.call(null,(state_41378[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41424 = state_41378;
state_41378 = G__41424;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = function(state_41378){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_41378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41407 = f__2769__auto__.call(null);
(statearr_41407[(6)] = c__2768__auto__);

return statearr_41407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e41425){var e = e41425;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e41426){var e = e41426;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e41427){var e = e41427;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41481){
var state_val_41482 = (state_41481[(1)]);
if((state_val_41482 === (7))){
var state_41481__$1 = state_41481;
var statearr_41483_41521 = state_41481__$1;
(statearr_41483_41521[(2)] = pred);

(statearr_41483_41521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (20))){
var inst_41464 = (state_41481[(7)]);
var inst_41460 = (state_41481[(8)]);
var inst_41468 = cljs.core.mapv.call(null,inst_41464,inst_41460);
var state_41481__$1 = state_41481;
var statearr_41484_41522 = state_41481__$1;
(statearr_41484_41522[(2)] = inst_41468);

(statearr_41484_41522[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (1))){
var state_41481__$1 = state_41481;
var statearr_41485_41523 = state_41481__$1;
(statearr_41485_41523[(2)] = null);

(statearr_41485_41523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (4))){
var inst_41428 = (state_41481[(2)]);
var state_41481__$1 = state_41481;
var statearr_41486_41524 = state_41481__$1;
(statearr_41486_41524[(2)] = inst_41428);

(statearr_41486_41524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (15))){
var state_41481__$1 = state_41481;
var statearr_41487_41525 = state_41481__$1;
(statearr_41487_41525[(2)] = fluree.db.flake.o);

(statearr_41487_41525[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (21))){
var inst_41464 = (state_41481[(7)]);
var inst_41460 = (state_41481[(8)]);
var inst_41470 = cljs.core.first.call(null,inst_41460);
var inst_41471 = inst_41464.call(null,inst_41470);
var state_41481__$1 = state_41481;
var statearr_41488_41526 = state_41481__$1;
(statearr_41488_41526[(2)] = inst_41471);

(statearr_41488_41526[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (13))){
var inst_41457 = (state_41481[(2)]);
var inst_41458 = fluree.db.util.async.throw_err.call(null,inst_41457);
var state_41481__$1 = state_41481;
var statearr_41489_41527 = state_41481__$1;
(statearr_41489_41527[(2)] = inst_41458);

(statearr_41489_41527[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (22))){
var inst_41473 = (state_41481[(2)]);
var state_41481__$1 = state_41481;
var statearr_41490_41528 = state_41481__$1;
(statearr_41490_41528[(2)] = inst_41473);

(statearr_41490_41528[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (6))){
var inst_41438 = clojure.string.replace.call(null,pred,"/_","/");
var state_41481__$1 = state_41481;
var statearr_41491_41529 = state_41481__$1;
(statearr_41491_41529[(2)] = inst_41438);

(statearr_41491_41529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (17))){
var inst_41442 = (state_41481[(9)]);
var state_41481__$1 = state_41481;
if(cljs.core.truth_(inst_41442)){
var statearr_41492_41530 = state_41481__$1;
(statearr_41492_41530[(1)] = (20));

} else {
var statearr_41493_41531 = state_41481__$1;
(statearr_41493_41531[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (3))){
var inst_41479 = (state_41481[(2)]);
var state_41481__$1 = state_41481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41481__$1,inst_41479);
} else {
if((state_val_41482 === (12))){
var inst_41449 = (state_41481[(2)]);
var inst_41450 = fluree.db.util.async.throw_err.call(null,inst_41449);
var state_41481__$1 = state_41481;
var statearr_41494_41532 = state_41481__$1;
(statearr_41494_41532[(2)] = inst_41450);

(statearr_41494_41532[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (2))){
var inst_41436 = (state_41481[(10)]);
var _ = (function (){var statearr_41495 = state_41481;
(statearr_41495[(4)] = cljs.core.cons.call(null,(5),(state_41481[(4)])));

return statearr_41495;
})();
var inst_41434 = typeof pred === 'string';
var inst_41435 = cljs.core.re_matches.call(null,/.+\/_.+/,pred);
var inst_41436__$1 = fluree.db.dbfunctions.internal.and.call(null,inst_41434,inst_41435);
var state_41481__$1 = (function (){var statearr_41496 = state_41481;
(statearr_41496[(10)] = inst_41436__$1);

return statearr_41496;
})();
if(cljs.core.truth_(inst_41436__$1)){
var statearr_41497_41533 = state_41481__$1;
(statearr_41497_41533[(1)] = (6));

} else {
var statearr_41498_41534 = state_41481__$1;
(statearr_41498_41534[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (19))){
var inst_41476 = (state_41481[(2)]);
var _ = (function (){var statearr_41499 = state_41481;
(statearr_41499[(4)] = cljs.core.rest.call(null,(state_41481[(4)])));

return statearr_41499;
})();
var state_41481__$1 = state_41481;
var statearr_41500_41535 = state_41481__$1;
(statearr_41500_41535[(2)] = inst_41476);

(statearr_41500_41535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (11))){
var inst_41436 = (state_41481[(10)]);
var inst_41460 = (state_41481[(2)]);
var state_41481__$1 = (function (){var statearr_41502 = state_41481;
(statearr_41502[(8)] = inst_41460);

return statearr_41502;
})();
if(cljs.core.truth_(inst_41436)){
var statearr_41503_41536 = state_41481__$1;
(statearr_41503_41536[(1)] = (14));

} else {
var statearr_41504_41537 = state_41481__$1;
(statearr_41504_41537[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (9))){
var inst_41441 = (state_41481[(11)]);
var inst_41444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41445 = [sid,inst_41441];
var inst_41446 = (new cljs.core.PersistentVector(null,2,(5),inst_41444,inst_41445,null));
var inst_41447 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_41446);
var state_41481__$1 = state_41481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41481__$1,(12),inst_41447);
} else {
if((state_val_41482 === (5))){
var _ = (function (){var statearr_41505 = state_41481;
(statearr_41505[(4)] = cljs.core.rest.call(null,(state_41481[(4)])));

return statearr_41505;
})();
var state_41481__$1 = state_41481;
var ex41501 = (state_41481__$1[(2)]);
var statearr_41506_41538 = state_41481__$1;
(statearr_41506_41538[(5)] = ex41501);


if((ex41501 instanceof Error)){
var statearr_41507_41539 = state_41481__$1;
(statearr_41507_41539[(1)] = (4));

(statearr_41507_41539[(5)] = null);

} else {
throw ex41501;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (14))){
var state_41481__$1 = state_41481;
var statearr_41508_41540 = state_41481__$1;
(statearr_41508_41540[(2)] = fluree.db.flake.s);

(statearr_41508_41540[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (16))){
var inst_41460 = (state_41481[(8)]);
var inst_41464 = (state_41481[(2)]);
var inst_41465 = cljs.core.seq.call(null,inst_41460);
var state_41481__$1 = (function (){var statearr_41509 = state_41481;
(statearr_41509[(7)] = inst_41464);

return statearr_41509;
})();
if(inst_41465){
var statearr_41510_41541 = state_41481__$1;
(statearr_41510_41541[(1)] = (17));

} else {
var statearr_41511_41542 = state_41481__$1;
(statearr_41511_41542[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (10))){
var inst_41441 = (state_41481[(11)]);
var inst_41452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41453 = [sid,inst_41441];
var inst_41454 = (new cljs.core.PersistentVector(null,2,(5),inst_41452,inst_41453,null));
var inst_41455 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_41454);
var state_41481__$1 = state_41481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41481__$1,(13),inst_41455);
} else {
if((state_val_41482 === (18))){
var state_41481__$1 = state_41481;
var statearr_41512_41543 = state_41481__$1;
(statearr_41512_41543[(2)] = null);

(statearr_41512_41543[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41482 === (8))){
var inst_41441 = (state_41481[(11)]);
var inst_41436 = (state_41481[(10)]);
var inst_41441__$1 = (state_41481[(2)]);
var inst_41442 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_41441__$1);
var state_41481__$1 = (function (){var statearr_41513 = state_41481;
(statearr_41513[(9)] = inst_41442);

(statearr_41513[(11)] = inst_41441__$1);

return statearr_41513;
})();
if(cljs.core.truth_(inst_41436)){
var statearr_41514_41544 = state_41481__$1;
(statearr_41514_41544[(1)] = (9));

} else {
var statearr_41515_41545 = state_41481__$1;
(statearr_41515_41545[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0 = (function (){
var statearr_41516 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41516[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__);

(statearr_41516[(1)] = (1));

return statearr_41516;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1 = (function (state_41481){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41517){var ex__2749__auto__ = e41517;
var statearr_41518_41546 = state_41481;
(statearr_41518_41546[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41481[(4)]))){
var statearr_41519_41547 = state_41481;
(statearr_41519_41547[(1)] = cljs.core.first.call(null,(state_41481[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41548 = state_41481;
state_41481 = G__41548;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = function(state_41481){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1.call(this,state_41481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41520 = f__2769__auto__.call(null);
(statearr_41520[(6)] = c__2768__auto__);

return statearr_41520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e41549){var e = e41549;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41552 = arguments.length;
var i__5770__auto___41553 = (0);
while(true){
if((i__5770__auto___41553 < len__5769__auto___41552)){
args__5775__auto__.push((arguments[i__5770__auto___41553]));

var G__41554 = (i__5770__auto___41553 + (1));
i__5770__auto___41553 = G__41554;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e41551){var e = e41551;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq41550){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41550));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41557 = arguments.length;
var i__5770__auto___41558 = (0);
while(true){
if((i__5770__auto___41558 < len__5769__auto___41557)){
args__5775__auto__.push((arguments[i__5770__auto___41558]));

var G__41559 = (i__5770__auto___41558 + (1));
i__5770__auto___41558 = G__41559;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e41556){var e = e41556;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq41555){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41555));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41562 = arguments.length;
var i__5770__auto___41563 = (0);
while(true){
if((i__5770__auto___41563 < len__5769__auto___41562)){
args__5775__auto__.push((arguments[i__5770__auto___41563]));

var G__41564 = (i__5770__auto___41563 + (1));
i__5770__auto___41563 = G__41564;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e41561){var e = e41561;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq41560){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41560));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41567 = arguments.length;
var i__5770__auto___41568 = (0);
while(true){
if((i__5770__auto___41568 < len__5769__auto___41567)){
args__5775__auto__.push((arguments[i__5770__auto___41568]));

var G__41569 = (i__5770__auto___41568 + (1));
i__5770__auto___41568 = G__41569;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e41566){var e = e41566;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq41565){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41565));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e41570){var e = e41570;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e41571){var e = e41571;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e41572){var e = e41572;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e41573){var e = e41573;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e41574){var e = e41574;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__41580 = path;
var vec__41581 = G__41580;
var seq__41582 = cljs.core.seq.call(null,vec__41581);
var first__41583 = cljs.core.first.call(null,seq__41582);
var seq__41582__$1 = cljs.core.next.call(null,seq__41582);
var pred = first__41583;
var r = seq__41582__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__41580__$1 = G__41580;
var subjects__$1 = subjects;
while(true){
var vec__41587 = G__41580__$1;
var seq__41588 = cljs.core.seq.call(null,vec__41587);
var first__41589 = cljs.core.first.call(null,seq__41588);
var seq__41588__$1 = cljs.core.next.call(null,seq__41588);
var pred__$1 = first__41589;
var r__$1 = seq__41588__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__41580__$1,subjects__$1,vec__41587,seq__41588,first__41589,seq__41588__$1,pred__$1,r__$1,subjects__$2,G__41580,vec__41581,seq__41582,first__41583,seq__41582__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__41580__$1,subjects__$1,vec__41587,seq__41588,first__41589,seq__41588__$1,pred__$1,r__$1,subjects__$2,G__41580,vec__41581,seq__41582,first__41583,seq__41582__$1,pred,r,subjects){
return (function (p1__41575_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__41575_SHARP_,pred__$1);
});})(G__41580__$1,subjects__$1,vec__41587,seq__41588,first__41589,seq__41588__$1,pred__$1,r__$1,subjects__$2,G__41580,vec__41581,seq__41582,first__41583,seq__41582__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__41580__$1,subjects__$1,vec__41587,seq__41588,first__41589,seq__41588__$1,pred__$1,r__$1,subjects__$2,G__41580,vec__41581,seq__41582,first__41583,seq__41582__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__41590 = r__$1;
var G__41591 = next_subjects;
G__41580__$1 = G__41590;
subjects__$1 = G__41591;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e41576){var e = e41576;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.call(null,(1),fluree.db.dbfunctions.internal.count.call(null,path))){
return path;
} else {
var r_path = cljs.core.reverse.call(null,path);
return cljs.core.reduce.call(null,(function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first.call(null,r_path),cljs.core.rest.call(null,r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41631){
var state_val_41632 = (state_41631[(1)]);
if((state_val_41632 === (7))){
var state_41631__$1 = state_41631;
var statearr_41633_41652 = state_41631__$1;
(statearr_41633_41652[(2)] = path);

(statearr_41633_41652[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41632 === (1))){
var state_41631__$1 = state_41631;
var statearr_41634_41653 = state_41631__$1;
(statearr_41634_41653[(2)] = null);

(statearr_41634_41653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41632 === (4))){
var inst_41592 = (state_41631[(2)]);
var inst_41593 = fluree.db.dbfunctions.internal.function_error.call(null,inst_41592,"get-all",sid,path);
var state_41631__$1 = state_41631;
var statearr_41635_41654 = state_41631__$1;
(statearr_41635_41654[(2)] = inst_41593);

(statearr_41635_41654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41632 === (6))){
var inst_41610 = (state_41631[(2)]);
var inst_41611 = fluree.db.util.async.throw_err.call(null,inst_41610);
var inst_41612 = cljs.core.nth.call(null,inst_41611,(0),null);
var inst_41613 = cljs.core.nth.call(null,inst_41611,(1),null);
var inst_41614 = cljs.core.last.call(null,path);
var inst_41615 = cljs.core._EQ_.call(null,"_id",inst_41614);
var state_41631__$1 = (function (){var statearr_41636 = state_41631;
(statearr_41636[(7)] = inst_41612);

(statearr_41636[(8)] = inst_41613);

return statearr_41636;
})();
if(inst_41615){
var statearr_41637_41655 = state_41631__$1;
(statearr_41637_41655[(1)] = (7));

} else {
var statearr_41638_41656 = state_41631__$1;
(statearr_41638_41656[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41632 === (3))){
var inst_41629 = (state_41631[(2)]);
var state_41631__$1 = state_41631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41631__$1,inst_41629);
} else {
if((state_val_41632 === (2))){
var _ = (function (){var statearr_41640 = state_41631;
(statearr_41640[(4)] = cljs.core.cons.call(null,(5),(state_41631[(4)])));

return statearr_41640;
})();
var inst_41602 = fluree.db.dbfunctions.internal.select_from_path.call(null,path);
var inst_41603 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41604 = cljs.core.PersistentHashMap.EMPTY;
var inst_41605 = [inst_41602,sid,inst_41604];
var inst_41606 = cljs.core.PersistentHashMap.fromArrays(inst_41603,inst_41605);
var inst_41607 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41608 = fluree.db.dbfunctions.internal.query.call(null,inst_41607,inst_41606);
var state_41631__$1 = state_41631;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41631__$1,(6),inst_41608);
} else {
if((state_val_41632 === (9))){
var inst_41612 = (state_41631[(7)]);
var inst_41613 = (state_41631[(8)]);
var inst_41620 = (state_41631[(2)]);
var inst_41621 = fluree.db.dbfunctions.internal.get_all.call(null,inst_41612,inst_41620);
var inst_41622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41623 = fluree.db.dbfunctions.internal.count.call(null,path);
var inst_41624 = fluree.db.dbfunctions.internal._PLUS_.call(null,inst_41613,inst_41623,(9));
var inst_41625 = [inst_41621,inst_41624];
var inst_41626 = (new cljs.core.PersistentVector(null,2,(5),inst_41622,inst_41625,null));
var _ = (function (){var statearr_41641 = state_41631;
(statearr_41641[(4)] = cljs.core.rest.call(null,(state_41631[(4)])));

return statearr_41641;
})();
var state_41631__$1 = state_41631;
var statearr_41642_41657 = state_41631__$1;
(statearr_41642_41657[(2)] = inst_41626);

(statearr_41642_41657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41632 === (5))){
var _ = (function (){var statearr_41643 = state_41631;
(statearr_41643[(4)] = cljs.core.rest.call(null,(state_41631[(4)])));

return statearr_41643;
})();
var state_41631__$1 = state_41631;
var ex41639 = (state_41631__$1[(2)]);
var statearr_41644_41658 = state_41631__$1;
(statearr_41644_41658[(5)] = ex41639);


var statearr_41645_41659 = state_41631__$1;
(statearr_41645_41659[(1)] = (4));

(statearr_41645_41659[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41632 === (8))){
var inst_41618 = cljs.core.conj.call(null,path,"_id");
var state_41631__$1 = state_41631;
var statearr_41646_41660 = state_41631__$1;
(statearr_41646_41660[(2)] = inst_41618);

(statearr_41646_41660[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0 = (function (){
var statearr_41647 = [null,null,null,null,null,null,null,null,null];
(statearr_41647[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__);

(statearr_41647[(1)] = (1));

return statearr_41647;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1 = (function (state_41631){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41648){var ex__2749__auto__ = e41648;
var statearr_41649_41661 = state_41631;
(statearr_41649_41661[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41631[(4)]))){
var statearr_41650_41662 = state_41631;
(statearr_41650_41662[(1)] = cljs.core.first.call(null,(state_41631[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41663 = state_41631;
state_41631 = G__41663;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = function(state_41631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1.call(this,state_41631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41651 = f__2769__auto__.call(null);
(statearr_41651[(6)] = c__2768__auto__);

return statearr_41651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e41664){var e = e41664;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_.call(null,key)){
return cljs.core.some.call(null,(function (p1__41665_SHARP_){
return fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__41665_SHARP_);
}),key);
} else {
return cljs.core.contains_QMARK_.call(null,coll,key);
}
}catch (e41666){var e = e41666;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41669 = arguments.length;
var i__5770__auto___41670 = (0);
while(true){
if((i__5770__auto___41670 < len__5769__auto___41669)){
args__5775__auto__.push((arguments[i__5770__auto___41670]));

var G__41671 = (i__5770__auto___41670 + (1));
i__5770__auto___41670 = G__41671;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e41668){var e = e41668;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq41667){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41667));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e41672){var e = e41672;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___41675 = arguments.length;
var i__5770__auto___41676 = (0);
while(true){
if((i__5770__auto___41676 < len__5769__auto___41675)){
args__5775__auto__.push((arguments[i__5770__auto___41676]));

var G__41677 = (i__5770__auto___41676 + (1));
i__5770__auto___41676 = G__41677;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e41674){var e = e41674;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq41673){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41673));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e41678){var e = e41678;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41735){
var state_val_41736 = (state_41735[(1)]);
if((state_val_41736 === (7))){
var inst_41681 = (state_41735[(2)]);
var state_41735__$1 = state_41735;
var statearr_41737_41771 = state_41735__$1;
(statearr_41737_41771[(2)] = inst_41681);

(statearr_41737_41771[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (1))){
var state_41735__$1 = state_41735;
var statearr_41738_41772 = state_41735__$1;
(statearr_41738_41772[(2)] = null);

(statearr_41738_41772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (4))){
var inst_41680 = (state_41735[(2)]);
var state_41735__$1 = (function (){var statearr_41739 = state_41735;
(statearr_41739[(7)] = inst_41680);

return statearr_41739;
})();
var statearr_41740_41773 = state_41735__$1;
(statearr_41740_41773[(2)] = null);

(statearr_41740_41773[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (15))){
var inst_41718 = (state_41735[(8)]);
var inst_41706 = (state_41735[(9)]);
var inst_41703 = (state_41735[(10)]);
var inst_41705 = (state_41735[(11)]);
var inst_41715 = (state_41735[(12)]);
var inst_41716 = (state_41735[(13)]);
var inst_41722 = (function (){var db = inst_41703;
var prevT = inst_41705;
var db_SINGLEQUOTE_ = inst_41706;
var prev_vals = inst_41715;
var fuel = inst_41716;
var G__41717 = inst_41718;
return (function (p1__41679_SHARP_){
var f = p1__41679_SHARP_;
return fluree.db.flake.o.call(null,f);
});
})();
var inst_41723 = inst_41722.call(null,inst_41718);
var state_41735__$1 = state_41735;
var statearr_41741_41774 = state_41735__$1;
(statearr_41741_41774[(2)] = inst_41723);

(statearr_41741_41774[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (13))){
var inst_41718 = (state_41735[(8)]);
var inst_41715 = (state_41735[(12)]);
var inst_41714 = (state_41735[(2)]);
var inst_41715__$1 = fluree.db.util.async.throw_err.call(null,inst_41714);
var inst_41716 = fluree.db.dbfunctions.internal.count.call(null,inst_41715__$1);
var inst_41718__$1 = cljs.core.first.call(null,inst_41715__$1);
var inst_41719 = (inst_41718__$1 == null);
var state_41735__$1 = (function (){var statearr_41742 = state_41735;
(statearr_41742[(8)] = inst_41718__$1);

(statearr_41742[(12)] = inst_41715__$1);

(statearr_41742[(13)] = inst_41716);

return statearr_41742;
})();
if(cljs.core.truth_(inst_41719)){
var statearr_41743_41775 = state_41735__$1;
(statearr_41743_41775[(1)] = (14));

} else {
var statearr_41744_41776 = state_41735__$1;
(statearr_41744_41776[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (6))){
var inst_41690 = (state_41735[(2)]);
var state_41735__$1 = state_41735;
var statearr_41745_41777 = state_41735__$1;
(statearr_41745_41777[(2)] = inst_41690);

(statearr_41745_41777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (3))){
var inst_41733 = (state_41735[(2)]);
var state_41735__$1 = state_41735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41735__$1,inst_41733);
} else {
if((state_val_41736 === (12))){
var inst_41730 = (state_41735[(2)]);
var _ = (function (){var statearr_41746 = state_41735;
(statearr_41746[(4)] = cljs.core.rest.call(null,(state_41735[(4)])));

return statearr_41746;
})();
var state_41735__$1 = state_41735;
var statearr_41747_41778 = state_41735__$1;
(statearr_41747_41778[(2)] = inst_41730);

(statearr_41747_41778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (2))){
var _ = (function (){var statearr_41749 = state_41735;
(statearr_41749[(4)] = cljs.core.cons.call(null,(9),(state_41735[(4)])));

return statearr_41749;
})();
var inst_41696 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41697 = typeof inst_41696 === 'string';
var state_41735__$1 = state_41735;
if(cljs.core.truth_(inst_41697)){
var statearr_41750_41779 = state_41735__$1;
(statearr_41750_41779[(1)] = (10));

} else {
var statearr_41751_41780 = state_41735__$1;
(statearr_41751_41780[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (11))){
var inst_41706 = (state_41735[(9)]);
var inst_41703 = (state_41735[(10)]);
var inst_41705 = (state_41735[(11)]);
var inst_41703__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41704 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_41703__$1);
var inst_41705__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_41704);
var inst_41706__$1 = cljs.core.assoc.call(null,inst_41703__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_41705__$1);
var inst_41707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41708 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41709 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41710 = [inst_41708,inst_41709];
var inst_41711 = (new cljs.core.PersistentVector(null,2,(5),inst_41707,inst_41710,null));
var inst_41712 = fluree.db.dbproto._search.call(null,inst_41706__$1,inst_41711);
var state_41735__$1 = (function (){var statearr_41752 = state_41735;
(statearr_41752[(9)] = inst_41706__$1);

(statearr_41752[(10)] = inst_41703__$1);

(statearr_41752[(11)] = inst_41705__$1);

return statearr_41752;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41735__$1,(13),inst_41712);
} else {
if((state_val_41736 === (9))){
var _ = (function (){var statearr_41753 = state_41735;
(statearr_41753[(4)] = cljs.core.rest.call(null,(state_41735[(4)])));

return statearr_41753;
})();
var state_41735__$1 = state_41735;
var ex41748 = (state_41735__$1[(2)]);
var statearr_41754_41781 = state_41735__$1;
(statearr_41754_41781[(5)] = ex41748);


var statearr_41755_41782 = state_41735__$1;
(statearr_41755_41782[(1)] = (4));

(statearr_41755_41782[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (5))){
var inst_41680 = (state_41735[(7)]);
var _ = (function (){var statearr_41756 = state_41735;
(statearr_41756[(4)] = cljs.core.cons.call(null,(8),(state_41735[(4)])));

return statearr_41756;
})();
var inst_41687 = fluree.db.dbfunctions.internal.function_error.call(null,inst_41680,"?pO","Context Object");
var ___$1 = (function (){var statearr_41757 = state_41735;
(statearr_41757[(4)] = cljs.core.rest.call(null,(state_41735[(4)])));

return statearr_41757;
})();
var state_41735__$1 = state_41735;
var statearr_41758_41783 = state_41735__$1;
(statearr_41758_41783[(2)] = inst_41687);

(statearr_41758_41783[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (14))){
var state_41735__$1 = state_41735;
var statearr_41759_41784 = state_41735__$1;
(statearr_41759_41784[(2)] = null);

(statearr_41759_41784[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (16))){
var inst_41716 = (state_41735[(13)]);
var inst_41725 = (state_41735[(2)]);
var inst_41726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41727 = [inst_41725,inst_41716];
var inst_41728 = (new cljs.core.PersistentVector(null,2,(5),inst_41726,inst_41727,null));
var state_41735__$1 = state_41735;
var statearr_41761_41785 = state_41735__$1;
(statearr_41761_41785[(2)] = inst_41728);

(statearr_41761_41785[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (10))){
var inst_41699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41700 = [null,(0)];
var inst_41701 = (new cljs.core.PersistentVector(null,2,(5),inst_41699,inst_41700,null));
var state_41735__$1 = state_41735;
var statearr_41762_41786 = state_41735__$1;
(statearr_41762_41786[(2)] = inst_41701);

(statearr_41762_41786[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41736 === (8))){
var _ = (function (){var statearr_41763 = state_41735;
(statearr_41763[(4)] = cljs.core.rest.call(null,(state_41735[(4)])));

return statearr_41763;
})();
var state_41735__$1 = state_41735;
var ex41760 = (state_41735__$1[(2)]);
var statearr_41764_41787 = state_41735__$1;
(statearr_41764_41787[(5)] = ex41760);


var statearr_41765_41788 = state_41735__$1;
(statearr_41765_41788[(1)] = (7));

(statearr_41765_41788[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_41766 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41766[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_41766[(1)] = (1));

return statearr_41766;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_41735){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41767){var ex__2749__auto__ = e41767;
var statearr_41768_41789 = state_41735;
(statearr_41768_41789[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41735[(4)]))){
var statearr_41769_41790 = state_41735;
(statearr_41769_41790[(1)] = cljs.core.first.call(null,(state_41735[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41791 = state_41735;
state_41735 = G__41791;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = function(state_41735){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_41735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41770 = f__2769__auto__.call(null);
(statearr_41770[(6)] = c__2768__auto__);

return statearr_41770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41843){
var state_val_41844 = (state_41843[(1)]);
if((state_val_41844 === (7))){
var inst_41793 = (state_41843[(2)]);
var state_41843__$1 = state_41843;
var statearr_41845_41874 = state_41843__$1;
(statearr_41845_41874[(2)] = inst_41793);

(statearr_41845_41874[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (1))){
var state_41843__$1 = state_41843;
var statearr_41846_41875 = state_41843__$1;
(statearr_41846_41875[(2)] = null);

(statearr_41846_41875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (4))){
var inst_41792 = (state_41843[(2)]);
var state_41843__$1 = (function (){var statearr_41847 = state_41843;
(statearr_41847[(7)] = inst_41792);

return statearr_41847;
})();
var statearr_41848_41876 = state_41843__$1;
(statearr_41848_41876[(2)] = null);

(statearr_41848_41876[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (13))){
var inst_41838 = (state_41843[(2)]);
var _ = (function (){var statearr_41849 = state_41843;
(statearr_41849[(4)] = cljs.core.rest.call(null,(state_41843[(4)])));

return statearr_41849;
})();
var state_41843__$1 = state_41843;
var statearr_41850_41877 = state_41843__$1;
(statearr_41850_41877[(2)] = inst_41838);

(statearr_41850_41877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (6))){
var inst_41802 = (state_41843[(2)]);
var state_41843__$1 = state_41843;
var statearr_41851_41878 = state_41843__$1;
(statearr_41851_41878[(2)] = inst_41802);

(statearr_41851_41878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (3))){
var inst_41841 = (state_41843[(2)]);
var state_41843__$1 = state_41843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41843__$1,inst_41841);
} else {
if((state_val_41844 === (12))){
var inst_41825 = (state_41843[(8)]);
var inst_41834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41835 = [null,inst_41825];
var inst_41836 = (new cljs.core.PersistentVector(null,2,(5),inst_41834,inst_41835,null));
var state_41843__$1 = state_41843;
var statearr_41852_41879 = state_41843__$1;
(statearr_41852_41879[(2)] = inst_41836);

(statearr_41852_41879[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (2))){
var _ = (function (){var statearr_41854 = state_41843;
(statearr_41854[(4)] = cljs.core.cons.call(null,(9),(state_41843[(4)])));

return statearr_41854;
})();
var inst_41811 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41814 = [null,pred_name,"?o"];
var inst_41815 = (new cljs.core.PersistentVector(null,3,(5),inst_41813,inst_41814,null));
var inst_41816 = [inst_41815];
var inst_41817 = (new cljs.core.PersistentVector(null,1,(5),inst_41812,inst_41816,null));
var inst_41818 = ["?o",inst_41817,opts];
var inst_41819 = cljs.core.PersistentHashMap.fromArrays(inst_41811,inst_41818);
var inst_41820 = fluree.db.dbfunctions.internal.query.call(null,db,inst_41819);
var state_41843__$1 = state_41843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41843__$1,(10),inst_41820);
} else {
if((state_val_41844 === (11))){
var inst_41825 = (state_41843[(8)]);
var inst_41824 = (state_41843[(9)]);
var inst_41829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41830 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_41824);
var inst_41831 = [inst_41830,inst_41825];
var inst_41832 = (new cljs.core.PersistentVector(null,2,(5),inst_41829,inst_41831,null));
var state_41843__$1 = state_41843;
var statearr_41855_41880 = state_41843__$1;
(statearr_41855_41880[(2)] = inst_41832);

(statearr_41855_41880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (9))){
var _ = (function (){var statearr_41856 = state_41843;
(statearr_41856[(4)] = cljs.core.rest.call(null,(state_41843[(4)])));

return statearr_41856;
})();
var state_41843__$1 = state_41843;
var ex41853 = (state_41843__$1[(2)]);
var statearr_41857_41881 = state_41843__$1;
(statearr_41857_41881[(5)] = ex41853);


var statearr_41858_41882 = state_41843__$1;
(statearr_41858_41882[(1)] = (4));

(statearr_41858_41882[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (5))){
var inst_41792 = (state_41843[(7)]);
var _ = (function (){var statearr_41860 = state_41843;
(statearr_41860[(4)] = cljs.core.cons.call(null,(8),(state_41843[(4)])));

return statearr_41860;
})();
var inst_41799 = fluree.db.dbfunctions.internal.function_error.call(null,inst_41792,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_41861 = state_41843;
(statearr_41861[(4)] = cljs.core.rest.call(null,(state_41843[(4)])));

return statearr_41861;
})();
var state_41843__$1 = state_41843;
var statearr_41862_41883 = state_41843__$1;
(statearr_41862_41883[(2)] = inst_41799);

(statearr_41862_41883[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (10))){
var inst_41824 = (state_41843[(9)]);
var inst_41822 = (state_41843[(2)]);
var inst_41823 = fluree.db.util.async.throw_err.call(null,inst_41822);
var inst_41824__$1 = cljs.core.nth.call(null,inst_41823,(0),null);
var inst_41825 = cljs.core.nth.call(null,inst_41823,(1),null);
var inst_41826 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_41824__$1);
var inst_41827 = cljs.core.not.call(null,inst_41826);
var state_41843__$1 = (function (){var statearr_41863 = state_41843;
(statearr_41863[(8)] = inst_41825);

(statearr_41863[(9)] = inst_41824__$1);

return statearr_41863;
})();
if(inst_41827){
var statearr_41864_41884 = state_41843__$1;
(statearr_41864_41884[(1)] = (11));

} else {
var statearr_41865_41885 = state_41843__$1;
(statearr_41865_41885[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41844 === (8))){
var _ = (function (){var statearr_41866 = state_41843;
(statearr_41866[(4)] = cljs.core.rest.call(null,(state_41843[(4)])));

return statearr_41866;
})();
var state_41843__$1 = state_41843;
var ex41859 = (state_41843__$1[(2)]);
var statearr_41867_41886 = state_41843__$1;
(statearr_41867_41886[(5)] = ex41859);


var statearr_41868_41887 = state_41843__$1;
(statearr_41868_41887[(1)] = (7));

(statearr_41868_41887[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_41869 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41869[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__);

(statearr_41869[(1)] = (1));

return statearr_41869;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1 = (function (state_41843){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e41870){var ex__2749__auto__ = e41870;
var statearr_41871_41888 = state_41843;
(statearr_41871_41888[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41843[(4)]))){
var statearr_41872_41889 = state_41843;
(statearr_41872_41889[(1)] = cljs.core.first.call(null,(state_41843[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41890 = state_41843;
state_41843 = G__41890;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = function(state_41843){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1.call(this,state_41843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_41873 = f__2769__auto__.call(null);
(statearr_41873[(6)] = c__2768__auto__);

return statearr_41873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e41891){var e = e41891;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__41893 = arguments.length;
switch (G__41893) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_41963){
var state_val_41964 = (state_41963[(1)]);
if((state_val_41964 === (7))){
var inst_41895 = (state_41963[(2)]);
var state_41963__$1 = state_41963;
var statearr_41965_42009 = state_41963__$1;
(statearr_41965_42009[(2)] = inst_41895);

(statearr_41965_42009[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (20))){
var inst_41939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41940 = ["*"];
var inst_41941 = (new cljs.core.PersistentVector(null,1,(5),inst_41939,inst_41940,null));
var state_41963__$1 = state_41963;
var statearr_41966_42010 = state_41963__$1;
(statearr_41966_42010[(2)] = inst_41941);

(statearr_41966_42010[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (1))){
var state_41963__$1 = state_41963;
var statearr_41967_42011 = state_41963__$1;
(statearr_41967_42011[(2)] = null);

(statearr_41967_42011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (4))){
var inst_41894 = (state_41963[(2)]);
var state_41963__$1 = (function (){var statearr_41968 = state_41963;
(statearr_41968[(7)] = inst_41894);

return statearr_41968;
})();
var statearr_41969_42012 = state_41963__$1;
(statearr_41969_42012[(2)] = null);

(statearr_41969_42012[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (15))){
var inst_41958 = (state_41963[(2)]);
var _ = (function (){var statearr_41970 = state_41963;
(statearr_41970[(4)] = cljs.core.rest.call(null,(state_41963[(4)])));

return statearr_41970;
})();
var state_41963__$1 = state_41963;
var statearr_41971_42013 = state_41963__$1;
(statearr_41971_42013[(2)] = inst_41958);

(statearr_41971_42013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (21))){
var inst_41929 = (state_41963[(8)]);
var inst_41922 = (state_41963[(9)]);
var inst_41943 = (state_41963[(2)]);
var inst_41944 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_41945 = cljs.core.PersistentHashMap.EMPTY;
var inst_41946 = [inst_41943,inst_41929,inst_41945];
var inst_41947 = cljs.core.PersistentHashMap.fromArrays(inst_41944,inst_41946);
var inst_41948 = fluree.db.dbfunctions.internal.query.call(null,inst_41922,inst_41947);
var state_41963__$1 = state_41963;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41963__$1,(22),inst_41948);
} else {
if((state_val_41964 === (13))){
var inst_41917 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41963__$1 = state_41963;
var statearr_41972_42014 = state_41963__$1;
(statearr_41972_42014[(2)] = inst_41917);

(statearr_41972_42014[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (22))){
var inst_41950 = (state_41963[(2)]);
var inst_41951 = fluree.db.util.async.throw_err.call(null,inst_41950);
var inst_41952 = cljs.core.nth.call(null,inst_41951,(0),null);
var inst_41953 = cljs.core.nth.call(null,inst_41951,(1),null);
var inst_41954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41955 = [inst_41952,inst_41953];
var inst_41956 = (new cljs.core.PersistentVector(null,2,(5),inst_41954,inst_41955,null));
var state_41963__$1 = state_41963;
var statearr_41973_42015 = state_41963__$1;
(statearr_41973_42015[(2)] = inst_41956);

(statearr_41973_42015[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (6))){
var inst_41904 = (state_41963[(2)]);
var state_41963__$1 = state_41963;
var statearr_41974_42016 = state_41963__$1;
(statearr_41974_42016[(2)] = inst_41904);

(statearr_41974_42016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (17))){
var inst_41926 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41927 = fluree.db.dbfunctions.internal.get.call(null,inst_41926,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_41963__$1 = state_41963;
var statearr_41975_42017 = state_41963__$1;
(statearr_41975_42017[(2)] = inst_41927);

(statearr_41975_42017[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (3))){
var inst_41961 = (state_41963[(2)]);
var state_41963__$1 = state_41963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41963__$1,inst_41961);
} else {
if((state_val_41964 === (12))){
var inst_41915 = (state_41963[(2)]);
var state_41963__$1 = state_41963;
if(cljs.core.truth_(inst_41915)){
var statearr_41976_42018 = state_41963__$1;
(statearr_41976_42018[(1)] = (13));

} else {
var statearr_41977_42019 = state_41963__$1;
(statearr_41977_42019[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (2))){
var inst_41910 = (state_41963[(10)]);
var _ = (function (){var statearr_41978 = state_41963;
(statearr_41978[(4)] = cljs.core.cons.call(null,(9),(state_41963[(4)])));

return statearr_41978;
})();
var inst_41910__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41963__$1 = (function (){var statearr_41979 = state_41963;
(statearr_41979[(10)] = inst_41910__$1);

return statearr_41979;
})();
if(cljs.core.truth_(inst_41910__$1)){
var statearr_41980_42020 = state_41963__$1;
(statearr_41980_42020[(1)] = (10));

} else {
var statearr_41981_42021 = state_41963__$1;
(statearr_41981_42021[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (19))){
var inst_41931 = cljs.core.PersistentVector.EMPTY;
var inst_41932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41933 = ["*"];
var inst_41934 = (new cljs.core.PersistentVector(null,1,(5),inst_41932,inst_41933,null));
var inst_41935 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_41936 = cljs.core.concat.call(null,inst_41934,inst_41935);
var inst_41937 = cljs.core.into.call(null,inst_41931,inst_41936);
var state_41963__$1 = state_41963;
var statearr_41983_42022 = state_41963__$1;
(statearr_41983_42022[(2)] = inst_41937);

(statearr_41983_42022[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (11))){
var inst_41910 = (state_41963[(10)]);
var state_41963__$1 = state_41963;
var statearr_41984_42023 = state_41963__$1;
(statearr_41984_42023[(2)] = inst_41910);

(statearr_41984_42023[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (9))){
var _ = (function (){var statearr_41985 = state_41963;
(statearr_41985[(4)] = cljs.core.rest.call(null,(state_41963[(4)])));

return statearr_41985;
})();
var state_41963__$1 = state_41963;
var ex41982 = (state_41963__$1[(2)]);
var statearr_41986_42024 = state_41963__$1;
(statearr_41986_42024[(5)] = ex41982);


var statearr_41987_42025 = state_41963__$1;
(statearr_41987_42025[(1)] = (4));

(statearr_41987_42025[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (5))){
var inst_41894 = (state_41963[(7)]);
var _ = (function (){var statearr_41988 = state_41963;
(statearr_41988[(4)] = cljs.core.cons.call(null,(8),(state_41963[(4)])));

return statearr_41988;
})();
var inst_41901 = fluree.db.dbfunctions.internal.function_error.call(null,inst_41894,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_41989 = state_41963;
(statearr_41989[(4)] = cljs.core.rest.call(null,(state_41963[(4)])));

return statearr_41989;
})();
var state_41963__$1 = state_41963;
var statearr_41990_42026 = state_41963__$1;
(statearr_41990_42026[(2)] = inst_41901);

(statearr_41990_42026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (14))){
var inst_41923 = (state_41963[(11)]);
var inst_41922 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41923__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41963__$1 = (function (){var statearr_41991 = state_41963;
(statearr_41991[(9)] = inst_41922);

(statearr_41991[(11)] = inst_41923__$1);

return statearr_41991;
})();
if(cljs.core.truth_(inst_41923__$1)){
var statearr_41992_42027 = state_41963__$1;
(statearr_41992_42027[(1)] = (16));

} else {
var statearr_41993_42028 = state_41963__$1;
(statearr_41993_42028[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (16))){
var inst_41923 = (state_41963[(11)]);
var state_41963__$1 = state_41963;
var statearr_41994_42029 = state_41963__$1;
(statearr_41994_42029[(2)] = inst_41923);

(statearr_41994_42029[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (10))){
var inst_41912 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_41963__$1 = state_41963;
var statearr_41996_42030 = state_41963__$1;
(statearr_41996_42030[(2)] = inst_41912);

(statearr_41996_42030[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (18))){
var inst_41929 = (state_41963[(2)]);
var state_41963__$1 = (function (){var statearr_41997 = state_41963;
(statearr_41997[(8)] = inst_41929);

return statearr_41997;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41998_42031 = state_41963__$1;
(statearr_41998_42031[(1)] = (19));

} else {
var statearr_41999_42032 = state_41963__$1;
(statearr_41999_42032[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41964 === (8))){
var _ = (function (){var statearr_42000 = state_41963;
(statearr_42000[(4)] = cljs.core.rest.call(null,(state_41963[(4)])));

return statearr_42000;
})();
var state_41963__$1 = state_41963;
var ex41995 = (state_41963__$1[(2)]);
var statearr_42001_42033 = state_41963__$1;
(statearr_42001_42033[(5)] = ex41995);


var statearr_42002_42034 = state_41963__$1;
(statearr_42002_42034[(1)] = (7));

(statearr_42002_42034[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_42003 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42003[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_42003[(1)] = (1));

return statearr_42003;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_41963){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_41963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e42004){var ex__2749__auto__ = e42004;
var statearr_42005_42035 = state_41963;
(statearr_42005_42035[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_41963[(4)]))){
var statearr_42006_42036 = state_41963;
(statearr_42006_42036[(1)] = cljs.core.first.call(null,(state_41963[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42037 = state_41963;
state_41963 = G__42037;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_41963){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_41963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_42007 = f__2769__auto__.call(null);
(statearr_42007[(6)] = c__2768__auto__);

return statearr_42007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__42039 = arguments.length;
switch (G__42039) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_42083){
var state_val_42084 = (state_42083[(1)]);
if((state_val_42084 === (7))){
var inst_42061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42062 = ["*"];
var inst_42063 = (new cljs.core.PersistentVector(null,1,(5),inst_42061,inst_42062,null));
var state_42083__$1 = state_42083;
var statearr_42085_42105 = state_42083__$1;
(statearr_42085_42105[(2)] = inst_42063);

(statearr_42085_42105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (1))){
var state_42083__$1 = state_42083;
var statearr_42086_42106 = state_42083__$1;
(statearr_42086_42106[(2)] = null);

(statearr_42086_42106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (4))){
var inst_42040 = (state_42083[(2)]);
var inst_42041 = fluree.db.dbfunctions.internal.function_error.call(null,inst_42040,"?p","Context Object",additional_params);
var state_42083__$1 = state_42083;
var statearr_42087_42107 = state_42083__$1;
(statearr_42087_42107[(2)] = inst_42041);

(statearr_42087_42107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (6))){
var inst_42053 = cljs.core.PersistentVector.EMPTY;
var inst_42054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42055 = ["*"];
var inst_42056 = (new cljs.core.PersistentVector(null,1,(5),inst_42054,inst_42055,null));
var inst_42057 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_42058 = cljs.core.concat.call(null,inst_42056,inst_42057);
var inst_42059 = cljs.core.into.call(null,inst_42053,inst_42058);
var state_42083__$1 = state_42083;
var statearr_42088_42108 = state_42083__$1;
(statearr_42088_42108[(2)] = inst_42059);

(statearr_42088_42108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (3))){
var inst_42081 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42083__$1,inst_42081);
} else {
if((state_val_42084 === (2))){
var _ = (function (){var statearr_42090 = state_42083;
(statearr_42090[(4)] = cljs.core.cons.call(null,(5),(state_42083[(4)])));

return statearr_42090;
})();
var inst_42050 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42051 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_42083__$1 = (function (){var statearr_42091 = state_42083;
(statearr_42091[(7)] = inst_42050);

(statearr_42091[(8)] = inst_42051);

return statearr_42091;
})();
if(cljs.core.truth_(additional_params)){
var statearr_42092_42109 = state_42083__$1;
(statearr_42092_42109[(1)] = (6));

} else {
var statearr_42093_42110 = state_42083__$1;
(statearr_42093_42110[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (9))){
var inst_42072 = (state_42083[(2)]);
var inst_42073 = fluree.db.util.async.throw_err.call(null,inst_42072);
var inst_42074 = cljs.core.nth.call(null,inst_42073,(0),null);
var inst_42075 = cljs.core.nth.call(null,inst_42073,(1),null);
var inst_42076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42077 = [inst_42074,inst_42075];
var inst_42078 = (new cljs.core.PersistentVector(null,2,(5),inst_42076,inst_42077,null));
var _ = (function (){var statearr_42094 = state_42083;
(statearr_42094[(4)] = cljs.core.rest.call(null,(state_42083[(4)])));

return statearr_42094;
})();
var state_42083__$1 = state_42083;
var statearr_42095_42111 = state_42083__$1;
(statearr_42095_42111[(2)] = inst_42078);

(statearr_42095_42111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (5))){
var _ = (function (){var statearr_42096 = state_42083;
(statearr_42096[(4)] = cljs.core.rest.call(null,(state_42083[(4)])));

return statearr_42096;
})();
var state_42083__$1 = state_42083;
var ex42089 = (state_42083__$1[(2)]);
var statearr_42097_42112 = state_42083__$1;
(statearr_42097_42112[(5)] = ex42089);


var statearr_42098_42113 = state_42083__$1;
(statearr_42098_42113[(1)] = (4));

(statearr_42098_42113[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (8))){
var inst_42050 = (state_42083[(7)]);
var inst_42051 = (state_42083[(8)]);
var inst_42065 = (state_42083[(2)]);
var inst_42066 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_42067 = cljs.core.PersistentHashMap.EMPTY;
var inst_42068 = [inst_42065,inst_42051,inst_42067];
var inst_42069 = cljs.core.PersistentHashMap.fromArrays(inst_42066,inst_42068);
var inst_42070 = fluree.db.dbfunctions.internal.query.call(null,inst_42050,inst_42069);
var state_42083__$1 = state_42083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42083__$1,(9),inst_42070);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_42099 = [null,null,null,null,null,null,null,null,null];
(statearr_42099[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_42099[(1)] = (1));

return statearr_42099;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_42083){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_42083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e42100){var ex__2749__auto__ = e42100;
var statearr_42101_42114 = state_42083;
(statearr_42101_42114[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_42083[(4)]))){
var statearr_42102_42115 = state_42083;
(statearr_42102_42115[(1)] = cljs.core.first.call(null,(state_42083[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42116 = state_42083;
state_42083 = G__42116;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_42083){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_42083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_42103 = f__2769__auto__.call(null);
(statearr_42103[(6)] = c__2768__auto__);

return statearr_42103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_42160){
var state_val_42161 = (state_42160[(1)]);
if((state_val_42161 === (1))){
var state_42160__$1 = state_42160;
var statearr_42162_42176 = state_42160__$1;
(statearr_42162_42176[(2)] = null);

(statearr_42162_42176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42161 === (2))){
var _ = (function (){var statearr_42163 = state_42160;
(statearr_42163[(4)] = cljs.core.cons.call(null,(5),(state_42160[(4)])));

return statearr_42163;
})();
var inst_42127 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_42128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42129 = ["_user/_auth"];
var inst_42130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42131 = ["*"];
var inst_42132 = (new cljs.core.PersistentVector(null,1,(5),inst_42130,inst_42131,null));
var inst_42133 = [inst_42132];
var inst_42134 = cljs.core.PersistentHashMap.fromArrays(inst_42129,inst_42133);
var inst_42135 = [inst_42134];
var inst_42136 = (new cljs.core.PersistentVector(null,1,(5),inst_42128,inst_42135,null));
var inst_42137 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42138 = cljs.core.PersistentHashMap.EMPTY;
var inst_42139 = [inst_42136,inst_42137,inst_42138];
var inst_42140 = cljs.core.PersistentHashMap.fromArrays(inst_42127,inst_42139);
var inst_42141 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42142 = fluree.db.dbfunctions.internal.query.call(null,inst_42141,inst_42140);
var state_42160__$1 = state_42160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42160__$1,(6),inst_42142);
} else {
if((state_val_42161 === (3))){
var inst_42158 = (state_42160[(2)]);
var state_42160__$1 = state_42160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42160__$1,inst_42158);
} else {
if((state_val_42161 === (4))){
var inst_42117 = (state_42160[(2)]);
var inst_42118 = fluree.db.dbfunctions.internal.function_error.call(null,inst_42117,"?user_id-from-auth","Context Object");
var state_42160__$1 = state_42160;
var statearr_42165_42177 = state_42160__$1;
(statearr_42165_42177[(2)] = inst_42118);

(statearr_42165_42177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42161 === (5))){
var _ = (function (){var statearr_42166 = state_42160;
(statearr_42166[(4)] = cljs.core.rest.call(null,(state_42160[(4)])));

return statearr_42166;
})();
var state_42160__$1 = state_42160;
var ex42164 = (state_42160__$1[(2)]);
var statearr_42167_42178 = state_42160__$1;
(statearr_42167_42178[(5)] = ex42164);


var statearr_42168_42179 = state_42160__$1;
(statearr_42168_42179[(1)] = (4));

(statearr_42168_42179[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42161 === (6))){
var inst_42144 = (state_42160[(2)]);
var inst_42145 = fluree.db.util.async.throw_err.call(null,inst_42144);
var inst_42146 = cljs.core.nth.call(null,inst_42145,(0),null);
var inst_42147 = cljs.core.nth.call(null,inst_42145,(1),null);
var inst_42148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42149 = ["_user/_auth","_id"];
var inst_42150 = (new cljs.core.PersistentVector(null,2,(5),inst_42148,inst_42149,null));
var inst_42151 = fluree.db.dbfunctions.internal.get_in.call(null,inst_42146,inst_42150);
var inst_42152 = cljs.core.first.call(null,inst_42151);
var inst_42153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42154 = [inst_42152,inst_42147];
var inst_42155 = (new cljs.core.PersistentVector(null,2,(5),inst_42153,inst_42154,null));
var _ = (function (){var statearr_42169 = state_42160;
(statearr_42169[(4)] = cljs.core.rest.call(null,(state_42160[(4)])));

return statearr_42169;
})();
var state_42160__$1 = state_42160;
var statearr_42170_42180 = state_42160__$1;
(statearr_42170_42180[(2)] = inst_42155);

(statearr_42170_42180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0 = (function (){
var statearr_42171 = [null,null,null,null,null,null,null];
(statearr_42171[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__);

(statearr_42171[(1)] = (1));

return statearr_42171;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1 = (function (state_42160){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_42160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e42172){var ex__2749__auto__ = e42172;
var statearr_42173_42181 = state_42160;
(statearr_42173_42181[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_42160[(4)]))){
var statearr_42174_42182 = state_42160;
(statearr_42174_42182[(1)] = cljs.core.first.call(null,(state_42160[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42183 = state_42160;
state_42160 = G__42183;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = function(state_42160){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1.call(this,state_42160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_42175 = f__2769__auto__.call(null);
(statearr_42175[(6)] = c__2768__auto__);

return statearr_42175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_42205){
var state_val_42206 = (state_42205[(1)]);
if((state_val_42206 === (7))){
var inst_42190 = (state_42205[(7)]);
var inst_42194 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42195 = fluree.db.dbproto._subid.call(null,inst_42194,inst_42190);
var state_42205__$1 = state_42205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42205__$1,(9),inst_42195);
} else {
if((state_val_42206 === (1))){
var state_42205__$1 = state_42205;
var statearr_42207_42226 = state_42205__$1;
(statearr_42207_42226[(2)] = null);

(statearr_42207_42226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42206 === (4))){
var inst_42184 = (state_42205[(2)]);
var state_42205__$1 = state_42205;
var statearr_42208_42227 = state_42205__$1;
(statearr_42208_42227[(2)] = inst_42184);

(statearr_42208_42227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42206 === (6))){
var inst_42190 = (state_42205[(7)]);
var state_42205__$1 = state_42205;
var statearr_42209_42228 = state_42205__$1;
(statearr_42209_42228[(2)] = inst_42190);

(statearr_42209_42228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42206 === (3))){
var inst_42203 = (state_42205[(2)]);
var state_42205__$1 = state_42205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42205__$1,inst_42203);
} else {
if((state_val_42206 === (2))){
var inst_42190 = (state_42205[(7)]);
var _ = (function (){var statearr_42211 = state_42205;
(statearr_42211[(4)] = cljs.core.cons.call(null,(5),(state_42205[(4)])));

return statearr_42211;
})();
var inst_42190__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42191 = typeof inst_42190__$1 === 'number';
var state_42205__$1 = (function (){var statearr_42212 = state_42205;
(statearr_42212[(7)] = inst_42190__$1);

return statearr_42212;
})();
if(cljs.core.truth_(inst_42191)){
var statearr_42213_42229 = state_42205__$1;
(statearr_42213_42229[(1)] = (6));

} else {
var statearr_42214_42230 = state_42205__$1;
(statearr_42214_42230[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42206 === (9))){
var inst_42197 = (state_42205[(2)]);
var inst_42198 = fluree.db.util.async.throw_err.call(null,inst_42197);
var state_42205__$1 = state_42205;
var statearr_42215_42231 = state_42205__$1;
(statearr_42215_42231[(2)] = inst_42198);

(statearr_42215_42231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42206 === (5))){
var _ = (function (){var statearr_42216 = state_42205;
(statearr_42216[(4)] = cljs.core.rest.call(null,(state_42205[(4)])));

return statearr_42216;
})();
var state_42205__$1 = state_42205;
var ex42210 = (state_42205__$1[(2)]);
var statearr_42217_42232 = state_42205__$1;
(statearr_42217_42232[(5)] = ex42210);


if((ex42210 instanceof Error)){
var statearr_42218_42233 = state_42205__$1;
(statearr_42218_42233[(1)] = (4));

(statearr_42218_42233[(5)] = null);

} else {
throw ex42210;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42206 === (8))){
var inst_42200 = (state_42205[(2)]);
var _ = (function (){var statearr_42219 = state_42205;
(statearr_42219[(4)] = cljs.core.rest.call(null,(state_42205[(4)])));

return statearr_42219;
})();
var state_42205__$1 = state_42205;
var statearr_42220_42234 = state_42205__$1;
(statearr_42220_42234[(2)] = inst_42200);

(statearr_42220_42234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_42221 = [null,null,null,null,null,null,null,null];
(statearr_42221[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_42221[(1)] = (1));

return statearr_42221;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_42205){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_42205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e42222){var ex__2749__auto__ = e42222;
var statearr_42223_42235 = state_42205;
(statearr_42223_42235[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_42205[(4)]))){
var statearr_42224_42236 = state_42205;
(statearr_42224_42236[(1)] = cljs.core.first.call(null,(state_42205[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42237 = state_42205;
state_42205 = G__42237;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_42205){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_42205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_42225 = f__2769__auto__.call(null);
(statearr_42225[(6)] = c__2768__auto__);

return statearr_42225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__42238_SHARP_){
return fluree.db.flake.op.call(null,p1__42238_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__42239_SHARP_){
return fluree.db.flake.o.call(null,p1__42239_SHARP_);
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e42240){var e = e42240;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__42241_SHARP_){
return fluree.db.flake.op.call(null,p1__42241_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__42242_SHARP_){
return fluree.db.flake.o.call(null,p1__42242_SHARP_);
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e42243){var e = e42243;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e42244){var e = e42244;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_42324){
var state_val_42325 = (state_42324[(1)]);
if((state_val_42325 === (7))){
var inst_42263 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_42264 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42265 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_42266 = cljs.core.PersistentHashMap.fromArrays(inst_42264,inst_42265);
var inst_42267 = cljs.core.ex_info.call(null,inst_42263,inst_42266);
var inst_42268 = (function(){throw inst_42267})();
var state_42324__$1 = state_42324;
var statearr_42326_42361 = state_42324__$1;
(statearr_42326_42361[(2)] = inst_42268);

(statearr_42326_42361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (1))){
var state_42324__$1 = state_42324;
var statearr_42327_42362 = state_42324__$1;
(statearr_42327_42362[(2)] = null);

(statearr_42327_42362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (4))){
var inst_42245 = (state_42324[(2)]);
var state_42324__$1 = state_42324;
var statearr_42328_42363 = state_42324__$1;
(statearr_42328_42363[(2)] = inst_42245);

(statearr_42328_42363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (15))){
var inst_42308 = (state_42324[(7)]);
var inst_42304 = (state_42324[(2)]);
var inst_42305 = fluree.db.util.async.throw_err.call(null,inst_42304);
var inst_42306 = cljs.core.nth.call(null,inst_42305,(0),null);
var inst_42307 = cljs.core.nth.call(null,inst_42305,(1),null);
var inst_42308__$1 = cljs.core.first.call(null,inst_42306);
var inst_42309 = cljs.core._EQ_.call(null,inst_42308__$1,compare_val);
var state_42324__$1 = (function (){var statearr_42329 = state_42324;
(statearr_42329[(7)] = inst_42308__$1);

(statearr_42329[(8)] = inst_42307);

return statearr_42329;
})();
if(inst_42309){
var statearr_42330_42364 = state_42324__$1;
(statearr_42330_42364[(1)] = (16));

} else {
var statearr_42331_42365 = state_42324__$1;
(statearr_42331_42365[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (13))){
var state_42324__$1 = state_42324;
var statearr_42332_42366 = state_42324__$1;
(statearr_42332_42366[(2)] = null);

(statearr_42332_42366[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (6))){
var state_42324__$1 = state_42324;
var statearr_42333_42367 = state_42324__$1;
(statearr_42333_42367[(2)] = null);

(statearr_42333_42367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (17))){
var inst_42308 = (state_42324[(7)]);
var inst_42312 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42308)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_42313 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42314 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_42315 = cljs.core.PersistentHashMap.fromArrays(inst_42313,inst_42314);
var inst_42316 = cljs.core.ex_info.call(null,inst_42312,inst_42315);
var inst_42317 = (function(){throw inst_42316})();
var state_42324__$1 = state_42324;
var statearr_42334_42368 = state_42324__$1;
(statearr_42334_42368[(2)] = inst_42317);

(statearr_42334_42368[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (3))){
var inst_42322 = (state_42324[(2)]);
var state_42324__$1 = state_42324;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42324__$1,inst_42322);
} else {
if((state_val_42325 === (12))){
var inst_42260 = (state_42324[(9)]);
var inst_42283 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_42260);
var inst_42284 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42285 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_42286 = cljs.core.PersistentHashMap.fromArrays(inst_42284,inst_42285);
var inst_42287 = cljs.core.ex_info.call(null,inst_42283,inst_42286);
var inst_42288 = (function(){throw inst_42287})();
var state_42324__$1 = state_42324;
var statearr_42335_42369 = state_42324__$1;
(statearr_42335_42369[(2)] = inst_42288);

(statearr_42335_42369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (2))){
var inst_42258 = (state_42324[(10)]);
var inst_42257 = (state_42324[(11)]);
var inst_42259 = (state_42324[(12)]);
var _ = (function (){var statearr_42336 = state_42324;
(statearr_42336[(4)] = cljs.core.cons.call(null,(5),(state_42324[(4)])));

return statearr_42336;
})();
var inst_42255 = _QMARK_ctx;
var inst_42256 = cljs.core.__destructure_map.call(null,inst_42255);
var inst_42257__$1 = cljs.core.get.call(null,inst_42256,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_42258__$1 = cljs.core.get.call(null,inst_42256,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_42259__$1 = cljs.core.get.call(null,inst_42256,new cljs.core.Keyword(null,"db","db",993250759));
var inst_42260 = fluree.db.dbproto._p_prop.call(null,inst_42259__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_42258__$1);
var state_42324__$1 = (function (){var statearr_42337 = state_42324;
(statearr_42337[(10)] = inst_42258__$1);

(statearr_42337[(11)] = inst_42257__$1);

(statearr_42337[(12)] = inst_42259__$1);

(statearr_42337[(9)] = inst_42260);

return statearr_42337;
})();
if(cljs.core.truth_(inst_42257__$1)){
var statearr_42338_42370 = state_42324__$1;
(statearr_42338_42370[(1)] = (6));

} else {
var statearr_42339_42371 = state_42324__$1;
(statearr_42339_42371[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (11))){
var inst_42258 = (state_42324[(10)]);
var inst_42259 = (state_42324[(12)]);
var inst_42280 = (state_42324[(2)]);
var inst_42281 = fluree.db.dbproto._p_prop.call(null,inst_42259,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_42258);
var state_42324__$1 = (function (){var statearr_42341 = state_42324;
(statearr_42341[(13)] = inst_42280);

return statearr_42341;
})();
if(cljs.core.truth_(inst_42281)){
var statearr_42342_42372 = state_42324__$1;
(statearr_42342_42372[(1)] = (12));

} else {
var statearr_42343_42373 = state_42324__$1;
(statearr_42343_42373[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (9))){
var state_42324__$1 = state_42324;
var statearr_42344_42374 = state_42324__$1;
(statearr_42344_42374[(2)] = null);

(statearr_42344_42374[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (5))){
var _ = (function (){var statearr_42345 = state_42324;
(statearr_42345[(4)] = cljs.core.rest.call(null,(state_42324[(4)])));

return statearr_42345;
})();
var state_42324__$1 = state_42324;
var ex42340 = (state_42324__$1[(2)]);
var statearr_42346_42375 = state_42324__$1;
(statearr_42346_42375[(5)] = ex42340);


if((ex42340 instanceof Error)){
var statearr_42347_42376 = state_42324__$1;
(statearr_42347_42376[(1)] = (4));

(statearr_42347_42376[(5)] = null);

} else {
throw ex42340;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (14))){
var inst_42257 = (state_42324[(11)]);
var inst_42259 = (state_42324[(12)]);
var inst_42260 = (state_42324[(9)]);
var inst_42291 = (state_42324[(2)]);
var inst_42292 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_42293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42295 = [inst_42257,inst_42260,"?current-val"];
var inst_42296 = (new cljs.core.PersistentVector(null,3,(5),inst_42294,inst_42295,null));
var inst_42297 = [inst_42296];
var inst_42298 = (new cljs.core.PersistentVector(null,1,(5),inst_42293,inst_42297,null));
var inst_42299 = cljs.core.PersistentHashMap.EMPTY;
var inst_42300 = ["?current-val",inst_42298,inst_42299];
var inst_42301 = cljs.core.PersistentHashMap.fromArrays(inst_42292,inst_42300);
var inst_42302 = fluree.db.dbfunctions.internal.query.call(null,inst_42259,inst_42301);
var state_42324__$1 = (function (){var statearr_42348 = state_42324;
(statearr_42348[(14)] = inst_42291);

return statearr_42348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42324__$1,(15),inst_42302);
} else {
if((state_val_42325 === (16))){
var state_42324__$1 = state_42324;
var statearr_42349_42377 = state_42324__$1;
(statearr_42349_42377[(2)] = new_val);

(statearr_42349_42377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (10))){
var inst_42273 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_42274 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42275 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_42276 = cljs.core.PersistentHashMap.fromArrays(inst_42274,inst_42275);
var inst_42277 = cljs.core.ex_info.call(null,inst_42273,inst_42276);
var inst_42278 = (function(){throw inst_42277})();
var state_42324__$1 = state_42324;
var statearr_42350_42378 = state_42324__$1;
(statearr_42350_42378[(2)] = inst_42278);

(statearr_42350_42378[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (18))){
var inst_42319 = (state_42324[(2)]);
var _ = (function (){var statearr_42351 = state_42324;
(statearr_42351[(4)] = cljs.core.rest.call(null,(state_42324[(4)])));

return statearr_42351;
})();
var state_42324__$1 = state_42324;
var statearr_42352_42379 = state_42324__$1;
(statearr_42352_42379[(2)] = inst_42319);

(statearr_42352_42379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42325 === (8))){
var inst_42260 = (state_42324[(9)]);
var inst_42270 = (state_42324[(2)]);
var state_42324__$1 = (function (){var statearr_42353 = state_42324;
(statearr_42353[(15)] = inst_42270);

return statearr_42353;
})();
if(cljs.core.truth_(inst_42260)){
var statearr_42354_42380 = state_42324__$1;
(statearr_42354_42380[(1)] = (9));

} else {
var statearr_42355_42381 = state_42324__$1;
(statearr_42355_42381[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_42356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42356[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__);

(statearr_42356[(1)] = (1));

return statearr_42356;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1 = (function (state_42324){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_42324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e42357){var ex__2749__auto__ = e42357;
var statearr_42358_42382 = state_42324;
(statearr_42358_42382[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_42324[(4)]))){
var statearr_42359_42383 = state_42324;
(statearr_42359_42383[(1)] = cljs.core.first.call(null,(state_42324[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42384 = state_42324;
state_42324 = G__42384;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = function(state_42324){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1.call(this,state_42324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_42360 = f__2769__auto__.call(null);
(statearr_42360[(6)] = c__2768__auto__);

return statearr_42360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
