// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__76148 = arguments.length;
switch (G__76148) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76193){
var state_val_76194 = (state_76193[(1)]);
if((state_val_76194 === (7))){
var inst_76163 = typeof user === 'string';
var state_76193__$1 = state_76193;
if(cljs.core.truth_(inst_76163)){
var statearr_76195_76224 = state_76193__$1;
(statearr_76195_76224[(1)] = (9));

} else {
var statearr_76196_76225 = state_76193__$1;
(statearr_76196_76225[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (1))){
var state_76193__$1 = state_76193;
var statearr_76197_76226 = state_76193__$1;
(statearr_76197_76226[(2)] = null);

(statearr_76197_76226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (4))){
var inst_76149 = (state_76193[(2)]);
var inst_76150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76151 = [inst_76149];
var inst_76152 = (new cljs.core.PersistentVector(null,1,(5),inst_76150,inst_76151,null));
var inst_76153 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76152);
var inst_76154 = reject.call(null,inst_76149);
var state_76193__$1 = (function (){var statearr_76198 = state_76193;
(statearr_76198[(7)] = inst_76153);

return statearr_76198;
})();
var statearr_76199_76227 = state_76193__$1;
(statearr_76199_76227[(2)] = inst_76154);

(statearr_76199_76227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (15))){
var inst_76182 = (state_76193[(2)]);
var inst_76183 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_76182);
var inst_76184 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76185 = cljs.core.constantly.call(null,inst_76183);
var inst_76186 = cljs.core.swap_BANG_.call(null,inst_76184,inst_76185);
var inst_76187 = fluree.db.connection.add_token.call(null,conn,inst_76183);
var inst_76188 = resolve.call(null,inst_76182);
var _ = (function (){var statearr_76200 = state_76193;
(statearr_76200[(4)] = cljs.core.rest.call(null,(state_76193[(4)])));

return statearr_76200;
})();
var state_76193__$1 = (function (){var statearr_76201 = state_76193;
(statearr_76201[(8)] = inst_76187);

(statearr_76201[(9)] = inst_76186);

return statearr_76201;
})();
var statearr_76202_76228 = state_76193__$1;
(statearr_76202_76228[(2)] = inst_76188);

(statearr_76202_76228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (13))){
var state_76193__$1 = state_76193;
var statearr_76203_76229 = state_76193__$1;
(statearr_76203_76229[(2)] = null);

(statearr_76203_76229[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (6))){
var state_76193__$1 = state_76193;
var statearr_76204_76230 = state_76193__$1;
(statearr_76204_76230[(2)] = user);

(statearr_76204_76230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (3))){
var inst_76191 = (state_76193[(2)]);
var state_76193__$1 = state_76193;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76193__$1,inst_76191);
} else {
if((state_val_76194 === (12))){
var state_76193__$1 = state_76193;
var statearr_76205_76231 = state_76193__$1;
(statearr_76205_76231[(2)] = user);

(statearr_76205_76231[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (2))){
var _ = (function (){var statearr_76206 = state_76193;
(statearr_76206[(4)] = cljs.core.cons.call(null,(5),(state_76193[(4)])));

return statearr_76206;
})();
var inst_76160 = typeof user === 'number';
var state_76193__$1 = state_76193;
if(cljs.core.truth_(inst_76160)){
var statearr_76207_76232 = state_76193__$1;
(statearr_76207_76232[(1)] = (6));

} else {
var statearr_76208_76233 = state_76193__$1;
(statearr_76208_76233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (11))){
var inst_76174 = (state_76193[(2)]);
var state_76193__$1 = state_76193;
var statearr_76210_76234 = state_76193__$1;
(statearr_76210_76234[(2)] = inst_76174);

(statearr_76210_76234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (9))){
var inst_76165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76166 = ["_user/username",user];
var inst_76167 = (new cljs.core.PersistentVector(null,2,(5),inst_76165,inst_76166,null));
var state_76193__$1 = state_76193;
var statearr_76211_76235 = state_76193__$1;
(statearr_76211_76235[(2)] = inst_76167);

(statearr_76211_76235[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (5))){
var _ = (function (){var statearr_76212 = state_76193;
(statearr_76212[(4)] = cljs.core.rest.call(null,(state_76193[(4)])));

return statearr_76212;
})();
var state_76193__$1 = state_76193;
var ex76209 = (state_76193__$1[(2)]);
var statearr_76213_76236 = state_76193__$1;
(statearr_76213_76236[(5)] = ex76209);


var statearr_76214_76237 = state_76193__$1;
(statearr_76214_76237[(1)] = (4));

(statearr_76214_76237[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (14))){
var inst_76172 = (state_76193[(2)]);
var state_76193__$1 = state_76193;
var statearr_76215_76238 = state_76193__$1;
(statearr_76215_76238[(2)] = inst_76172);

(statearr_76215_76238[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (10))){
var state_76193__$1 = state_76193;
var statearr_76216_76239 = state_76193__$1;
(statearr_76216_76239[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76194 === (8))){
var inst_76176 = (state_76193[(2)]);
var inst_76177 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_76178 = [account,inst_76176,password,expireSeconds,syncTo];
var inst_76179 = cljs.core.PersistentHashMap.fromArrays(inst_76177,inst_76178);
var inst_76180 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_76179);
var state_76193__$1 = state_76193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76193__$1,(15),inst_76180);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_76218 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76218[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_76218[(1)] = (1));

return statearr_76218;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_76193){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76193);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76219){var ex__2749__auto__ = e76219;
var statearr_76220_76240 = state_76193;
(statearr_76220_76240[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76193[(4)]))){
var statearr_76221_76241 = state_76193;
(statearr_76221_76241[(1)] = cljs.core.first.call(null,(state_76193[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76242 = state_76193;
state_76193 = G__76242;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_76193){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_76193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76222 = f__2769__auto__.call(null);
(statearr_76222[(6)] = c__2768__auto__);

return statearr_76222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__76244 = arguments.length;
switch (G__76244) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76253){
var state_val_76254 = (state_76253[(1)]);
if((state_val_76254 === (1))){
var inst_76245 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76247 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_76248 = (new cljs.core.PersistentVector(null,4,(5),inst_76246,inst_76247,null));
var inst_76249 = cljs.core.async.put_BANG_.call(null,inst_76245,inst_76248);
var inst_76250 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__76255 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__76256 = null;
var count__76257 = (0);
var i__76258 = (0);
while(true){
if((i__76258 < count__76257)){
var k = cljs.core._nth.call(null,chunk__76256,i__76258);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__76266 = seq__76255;
var G__76267 = chunk__76256;
var G__76268 = count__76257;
var G__76269 = (i__76258 + (1));
seq__76255 = G__76266;
chunk__76256 = G__76267;
count__76257 = G__76268;
i__76258 = G__76269;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__76255);
if(temp__5804__auto__){
var seq__76255__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__76255__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__76255__$1);
var G__76270 = cljs.core.chunk_rest.call(null,seq__76255__$1);
var G__76271 = c__5568__auto__;
var G__76272 = cljs.core.count.call(null,c__5568__auto__);
var G__76273 = (0);
seq__76255 = G__76270;
chunk__76256 = G__76271;
count__76257 = G__76272;
i__76258 = G__76273;
continue;
} else {
var k = cljs.core.first.call(null,seq__76255__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__76274 = cljs.core.next.call(null,seq__76255__$1);
var G__76275 = null;
var G__76276 = (0);
var G__76277 = (0);
seq__76255 = G__76274;
chunk__76256 = G__76275;
count__76257 = G__76276;
i__76258 = G__76277;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_76251 = cljs.core.async.take_BANG_.call(null,pc,inst_76250);
var state_76253__$1 = (function (){var statearr_76259 = state_76253;
(statearr_76259[(7)] = inst_76249);

return statearr_76259;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76253__$1,inst_76251);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_76260 = [null,null,null,null,null,null,null,null];
(statearr_76260[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_76260[(1)] = (1));

return statearr_76260;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_76253){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76261){var ex__2749__auto__ = e76261;
var statearr_76262_76278 = state_76253;
(statearr_76262_76278[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76253[(4)]))){
var statearr_76263_76279 = state_76253;
(statearr_76263_76279[(1)] = cljs.core.first.call(null,(state_76253[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76280 = state_76253;
state_76253 = G__76280;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_76253){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_76253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76264 = f__2769__auto__.call(null);
(statearr_76264[(6)] = c__2768__auto__);

return statearr_76264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__76282 = arguments.length;
switch (G__76282) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76319){
var state_val_76320 = (state_76319[(1)]);
if((state_val_76320 === (1))){
var state_76319__$1 = state_76319;
var statearr_76321_76342 = state_76319__$1;
(statearr_76321_76342[(2)] = null);

(statearr_76321_76342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76320 === (2))){
var _ = (function (){var statearr_76322 = state_76319;
(statearr_76322[(4)] = cljs.core.cons.call(null,(5),(state_76319[(4)])));

return statearr_76322;
})();
var inst_76294 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_76295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76296 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_76297 = (new cljs.core.PersistentVector(null,1,(5),inst_76295,inst_76296,null));
var inst_76298 = cljs.core.PersistentHashMap.EMPTY;
var inst_76299 = cljs.core.atom.call(null,inst_76298);
var inst_76300 = cljs.core.assoc_in.call(null,inst_76294,inst_76297,inst_76299);
var inst_76301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76302 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_76303 = (new cljs.core.PersistentVector(null,1,(5),inst_76301,inst_76302,null));
var inst_76304 = cljs.core.PersistentHashMap.EMPTY;
var inst_76305 = cljs.core.atom.call(null,inst_76304);
var inst_76306 = cljs.core.assoc_in.call(null,inst_76300,inst_76303,inst_76305);
var inst_76307 = cljs.core.async.promise_chan.call(null);
var inst_76308 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_76306);
var inst_76309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76310 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_76307,null];
var inst_76311 = (new cljs.core.PersistentVector(null,4,(5),inst_76309,inst_76310,null));
var inst_76312 = cljs.core.async.put_BANG_.call(null,inst_76308,inst_76311);
var inst_76313 = (function (){var conn = inst_76306;
var pc = inst_76307;
return (function (x){
if((x == null)){
} else {
var seq__76323_76343 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__76324_76344 = null;
var count__76325_76345 = (0);
var i__76326_76346 = (0);
while(true){
if((i__76326_76346 < count__76325_76345)){
var k_76347 = cljs.core._nth.call(null,chunk__76324_76344,i__76326_76346);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_76347], null),cljs.core.get.call(null,x,k_76347,null));


var G__76348 = seq__76323_76343;
var G__76349 = chunk__76324_76344;
var G__76350 = count__76325_76345;
var G__76351 = (i__76326_76346 + (1));
seq__76323_76343 = G__76348;
chunk__76324_76344 = G__76349;
count__76325_76345 = G__76350;
i__76326_76346 = G__76351;
continue;
} else {
var temp__5804__auto___76352 = cljs.core.seq.call(null,seq__76323_76343);
if(temp__5804__auto___76352){
var seq__76323_76353__$1 = temp__5804__auto___76352;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__76323_76353__$1)){
var c__5568__auto___76354 = cljs.core.chunk_first.call(null,seq__76323_76353__$1);
var G__76355 = cljs.core.chunk_rest.call(null,seq__76323_76353__$1);
var G__76356 = c__5568__auto___76354;
var G__76357 = cljs.core.count.call(null,c__5568__auto___76354);
var G__76358 = (0);
seq__76323_76343 = G__76355;
chunk__76324_76344 = G__76356;
count__76325_76345 = G__76357;
i__76326_76346 = G__76358;
continue;
} else {
var k_76359 = cljs.core.first.call(null,seq__76323_76353__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_76359], null),cljs.core.get.call(null,x,k_76359,null));


var G__76360 = cljs.core.next.call(null,seq__76323_76353__$1);
var G__76361 = null;
var G__76362 = (0);
var G__76363 = (0);
seq__76323_76343 = G__76360;
chunk__76324_76344 = G__76361;
count__76325_76345 = G__76362;
i__76326_76346 = G__76363;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_76314 = cljs.core.async.take_BANG_.call(null,inst_76307,inst_76313);
var ___$1 = (function (){var statearr_76327 = state_76319;
(statearr_76327[(4)] = cljs.core.rest.call(null,(state_76319[(4)])));

return statearr_76327;
})();
var state_76319__$1 = (function (){var statearr_76328 = state_76319;
(statearr_76328[(7)] = inst_76312);

return statearr_76328;
})();
var statearr_76329_76364 = state_76319__$1;
(statearr_76329_76364[(2)] = inst_76314);

(statearr_76329_76364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76320 === (3))){
var inst_76317 = (state_76319[(2)]);
var state_76319__$1 = state_76319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76319__$1,inst_76317);
} else {
if((state_val_76320 === (4))){
var inst_76283 = (state_76319[(2)]);
var inst_76284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76285 = [inst_76283];
var inst_76286 = (new cljs.core.PersistentVector(null,1,(5),inst_76284,inst_76285,null));
var inst_76287 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76286);
var inst_76288 = reject.call(null,inst_76283);
var state_76319__$1 = (function (){var statearr_76331 = state_76319;
(statearr_76331[(8)] = inst_76287);

return statearr_76331;
})();
var statearr_76332_76365 = state_76319__$1;
(statearr_76332_76365[(2)] = inst_76288);

(statearr_76332_76365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76320 === (5))){
var _ = (function (){var statearr_76333 = state_76319;
(statearr_76333[(4)] = cljs.core.rest.call(null,(state_76319[(4)])));

return statearr_76333;
})();
var state_76319__$1 = state_76319;
var ex76330 = (state_76319__$1[(2)]);
var statearr_76334_76366 = state_76319__$1;
(statearr_76334_76366[(5)] = ex76330);


var statearr_76335_76367 = state_76319__$1;
(statearr_76335_76367[(1)] = (4));

(statearr_76335_76367[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_76336 = [null,null,null,null,null,null,null,null,null];
(statearr_76336[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_76336[(1)] = (1));

return statearr_76336;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_76319){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76337){var ex__2749__auto__ = e76337;
var statearr_76338_76368 = state_76319;
(statearr_76338_76368[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76319[(4)]))){
var statearr_76339_76369 = state_76319;
(statearr_76339_76369[(1)] = cljs.core.first.call(null,(state_76319[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76370 = state_76319;
state_76319 = G__76370;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_76319){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_76319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76340 = f__2769__auto__.call(null);
(statearr_76340[(6)] = c__2768__auto__);

return statearr_76340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__76372 = arguments.length;
switch (G__76372) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__76374 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__76374,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__76374,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__76377 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__76377,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__76377,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76430){
var state_val_76431 = (state_76430[(1)]);
if((state_val_76431 === (7))){
var inst_76391 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76392 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_76393 = cljs.core.PersistentHashMap.fromArrays(inst_76391,inst_76392);
var inst_76394 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_76393);
var inst_76395 = (function(){throw inst_76394})();
var state_76430__$1 = state_76430;
var statearr_76432_76461 = state_76430__$1;
(statearr_76432_76461[(2)] = inst_76395);

(statearr_76432_76461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (1))){
var state_76430__$1 = state_76430;
var statearr_76433_76462 = state_76430__$1;
(statearr_76433_76462[(2)] = null);

(statearr_76433_76462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (4))){
var inst_76380 = (state_76430[(2)]);
var inst_76381 = cljs.core.clj__GT_js.call(null,inst_76380);
var inst_76382 = reject.call(null,inst_76381);
var state_76430__$1 = state_76430;
var statearr_76434_76463 = state_76430__$1;
(statearr_76434_76463[(2)] = inst_76382);

(statearr_76434_76463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (13))){
var inst_76409 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76410 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_76411 = cljs.core.PersistentHashMap.fromArrays(inst_76409,inst_76410);
var inst_76412 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_76411);
var inst_76413 = (function(){throw inst_76412})();
var state_76430__$1 = state_76430;
var statearr_76435_76464 = state_76430__$1;
(statearr_76435_76464[(2)] = inst_76413);

(statearr_76435_76464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (6))){
var state_76430__$1 = state_76430;
var statearr_76436_76465 = state_76430__$1;
(statearr_76436_76465[(2)] = null);

(statearr_76436_76465[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (3))){
var inst_76428 = (state_76430[(2)]);
var state_76430__$1 = state_76430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76430__$1,inst_76428);
} else {
if((state_val_76431 === (12))){
var state_76430__$1 = state_76430;
var statearr_76437_76466 = state_76430__$1;
(statearr_76437_76466[(2)] = null);

(statearr_76437_76466[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (2))){
var _ = (function (){var statearr_76438 = state_76430;
(statearr_76438[(4)] = cljs.core.cons.call(null,(5),(state_76430[(4)])));

return statearr_76438;
})();
var inst_76388 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_76430__$1 = state_76430;
if(cljs.core.truth_(inst_76388)){
var statearr_76439_76467 = state_76430__$1;
(statearr_76439_76467[(1)] = (6));

} else {
var statearr_76440_76468 = state_76430__$1;
(statearr_76440_76468[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (11))){
var inst_76406 = (state_76430[(2)]);
var state_76430__$1 = (function (){var statearr_76442 = state_76430;
(statearr_76442[(7)] = inst_76406);

return statearr_76442;
})();
if(cljs.core.truth_(password)){
var statearr_76443_76469 = state_76430__$1;
(statearr_76443_76469[(1)] = (12));

} else {
var statearr_76444_76470 = state_76430__$1;
(statearr_76444_76470[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (9))){
var state_76430__$1 = state_76430;
var statearr_76445_76471 = state_76430__$1;
(statearr_76445_76471[(2)] = null);

(statearr_76445_76471[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (5))){
var _ = (function (){var statearr_76446 = state_76430;
(statearr_76446[(4)] = cljs.core.rest.call(null,(state_76430[(4)])));

return statearr_76446;
})();
var state_76430__$1 = state_76430;
var ex76441 = (state_76430__$1[(2)]);
var statearr_76447_76472 = state_76430__$1;
(statearr_76447_76472[(5)] = ex76441);


var statearr_76448_76473 = state_76430__$1;
(statearr_76448_76473[(1)] = (4));

(statearr_76448_76473[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (14))){
var inst_76415 = (state_76430[(2)]);
var inst_76416 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_76417 = fluree.db.util.core.without_nils.call(null,inst_76416);
var inst_76418 = cljs.core.async.promise_chan.call(null);
var inst_76419 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76421 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_76417,inst_76418,null];
var inst_76422 = (new cljs.core.PersistentVector(null,4,(5),inst_76420,inst_76421,null));
var inst_76423 = cljs.core.async.put_BANG_.call(null,inst_76419,inst_76422);
var inst_76424 = (function (){var _ = inst_76415;
var data = inst_76417;
var pc = inst_76418;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_76425 = cljs.core.async.take_BANG_.call(null,inst_76418,inst_76424);
var _ = (function (){var statearr_76449 = state_76430;
(statearr_76449[(4)] = cljs.core.rest.call(null,(state_76430[(4)])));

return statearr_76449;
})();
var state_76430__$1 = (function (){var statearr_76450 = state_76430;
(statearr_76450[(8)] = inst_76423);

return statearr_76450;
})();
var statearr_76451_76474 = state_76430__$1;
(statearr_76451_76474[(2)] = inst_76425);

(statearr_76451_76474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (10))){
var inst_76400 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76401 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_76402 = cljs.core.PersistentHashMap.fromArrays(inst_76400,inst_76401);
var inst_76403 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_76402);
var inst_76404 = (function(){throw inst_76403})();
var state_76430__$1 = state_76430;
var statearr_76452_76475 = state_76430__$1;
(statearr_76452_76475[(2)] = inst_76404);

(statearr_76452_76475[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76431 === (8))){
var inst_76397 = (state_76430[(2)]);
var state_76430__$1 = (function (){var statearr_76453 = state_76430;
(statearr_76453[(9)] = inst_76397);

return statearr_76453;
})();
if(cljs.core.truth_(ledger)){
var statearr_76454_76476 = state_76430__$1;
(statearr_76454_76476[(1)] = (9));

} else {
var statearr_76455_76477 = state_76430__$1;
(statearr_76455_76477[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_76456 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76456[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_76456[(1)] = (1));

return statearr_76456;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_76430){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76457){var ex__2749__auto__ = e76457;
var statearr_76458_76478 = state_76430;
(statearr_76458_76478[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76430[(4)]))){
var statearr_76459_76479 = state_76430;
(statearr_76459_76479[(1)] = cljs.core.first.call(null,(state_76430[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76480 = state_76430;
state_76430 = G__76480;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_76430){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_76430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76460 = f__2769__auto__.call(null);
(statearr_76460[(6)] = c__2768__auto__);

return statearr_76460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__76482 = arguments.length;
switch (G__76482) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76549){
var state_val_76550 = (state_76549[(1)]);
if((state_val_76550 === (7))){
var inst_76494 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76495 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_76496 = cljs.core.PersistentHashMap.fromArrays(inst_76494,inst_76495);
var inst_76497 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_76496);
var inst_76498 = (function(){throw inst_76497})();
var state_76549__$1 = state_76549;
var statearr_76551_76590 = state_76549__$1;
(statearr_76551_76590[(2)] = inst_76498);

(statearr_76551_76590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (20))){
var inst_76532 = (state_76549[(2)]);
var inst_76533 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_76534 = [ledger,password,user,auth,expire];
var inst_76535 = cljs.core.PersistentHashMap.fromArrays(inst_76533,inst_76534);
var inst_76536 = fluree.db.util.core.without_nils.call(null,inst_76535);
var inst_76537 = cljs.core.async.promise_chan.call(null);
var inst_76538 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76540 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_76536,inst_76537,null];
var inst_76541 = (new cljs.core.PersistentVector(null,4,(5),inst_76539,inst_76540,null));
var inst_76542 = cljs.core.async.put_BANG_.call(null,inst_76538,inst_76541);
var inst_76543 = (function (){var _ = inst_76532;
var data = inst_76536;
var pc = inst_76537;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_76544 = cljs.core.async.take_BANG_.call(null,inst_76537,inst_76543);
var _ = (function (){var statearr_76552 = state_76549;
(statearr_76552[(4)] = cljs.core.rest.call(null,(state_76549[(4)])));

return statearr_76552;
})();
var state_76549__$1 = (function (){var statearr_76553 = state_76549;
(statearr_76553[(7)] = inst_76542);

return statearr_76553;
})();
var statearr_76554_76591 = state_76549__$1;
(statearr_76554_76591[(2)] = inst_76544);

(statearr_76554_76591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (1))){
var state_76549__$1 = state_76549;
var statearr_76555_76592 = state_76549__$1;
(statearr_76555_76592[(2)] = null);

(statearr_76555_76592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (4))){
var inst_76483 = (state_76549[(2)]);
var inst_76484 = cljs.core.clj__GT_js.call(null,inst_76483);
var inst_76485 = reject.call(null,inst_76484);
var state_76549__$1 = state_76549;
var statearr_76556_76593 = state_76549__$1;
(statearr_76556_76593[(2)] = inst_76485);

(statearr_76556_76593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (15))){
var inst_76519 = (state_76549[(8)]);
var state_76549__$1 = state_76549;
var statearr_76557_76594 = state_76549__$1;
(statearr_76557_76594[(2)] = inst_76519);

(statearr_76557_76594[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (13))){
var inst_76512 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76513 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_76514 = cljs.core.PersistentHashMap.fromArrays(inst_76512,inst_76513);
var inst_76515 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_76514);
var inst_76516 = (function(){throw inst_76515})();
var state_76549__$1 = state_76549;
var statearr_76558_76595 = state_76549__$1;
(statearr_76558_76595[(2)] = inst_76516);

(statearr_76558_76595[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (6))){
var state_76549__$1 = state_76549;
var statearr_76559_76596 = state_76549__$1;
(statearr_76559_76596[(2)] = null);

(statearr_76559_76596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (17))){
var inst_76523 = (state_76549[(2)]);
var state_76549__$1 = state_76549;
if(cljs.core.truth_(inst_76523)){
var statearr_76560_76597 = state_76549__$1;
(statearr_76560_76597[(1)] = (18));

} else {
var statearr_76561_76598 = state_76549__$1;
(statearr_76561_76598[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (3))){
var inst_76547 = (state_76549[(2)]);
var state_76549__$1 = state_76549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76549__$1,inst_76547);
} else {
if((state_val_76550 === (12))){
var state_76549__$1 = state_76549;
var statearr_76562_76599 = state_76549__$1;
(statearr_76562_76599[(2)] = null);

(statearr_76562_76599[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (2))){
var _ = (function (){var statearr_76563 = state_76549;
(statearr_76563[(4)] = cljs.core.cons.call(null,(5),(state_76549[(4)])));

return statearr_76563;
})();
var inst_76491 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_76549__$1 = state_76549;
if(cljs.core.truth_(inst_76491)){
var statearr_76564_76600 = state_76549__$1;
(statearr_76564_76600[(1)] = (6));

} else {
var statearr_76565_76601 = state_76549__$1;
(statearr_76565_76601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (19))){
var inst_76526 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76527 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_76528 = cljs.core.PersistentHashMap.fromArrays(inst_76526,inst_76527);
var inst_76529 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_76528);
var inst_76530 = (function(){throw inst_76529})();
var state_76549__$1 = state_76549;
var statearr_76566_76602 = state_76549__$1;
(statearr_76566_76602[(2)] = inst_76530);

(statearr_76566_76602[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (11))){
var inst_76509 = (state_76549[(2)]);
var state_76549__$1 = (function (){var statearr_76568 = state_76549;
(statearr_76568[(9)] = inst_76509);

return statearr_76568;
})();
if(cljs.core.truth_(password)){
var statearr_76569_76603 = state_76549__$1;
(statearr_76569_76603[(1)] = (12));

} else {
var statearr_76570_76604 = state_76549__$1;
(statearr_76570_76604[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (9))){
var state_76549__$1 = state_76549;
var statearr_76571_76605 = state_76549__$1;
(statearr_76571_76605[(2)] = null);

(statearr_76571_76605[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (5))){
var _ = (function (){var statearr_76572 = state_76549;
(statearr_76572[(4)] = cljs.core.rest.call(null,(state_76549[(4)])));

return statearr_76572;
})();
var state_76549__$1 = state_76549;
var ex76567 = (state_76549__$1[(2)]);
var statearr_76573_76606 = state_76549__$1;
(statearr_76573_76606[(5)] = ex76567);


var statearr_76574_76607 = state_76549__$1;
(statearr_76574_76607[(1)] = (4));

(statearr_76574_76607[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (14))){
var inst_76519 = (state_76549[(8)]);
var inst_76518 = (state_76549[(2)]);
var inst_76519__$1 = user;
var state_76549__$1 = (function (){var statearr_76575 = state_76549;
(statearr_76575[(8)] = inst_76519__$1);

(statearr_76575[(10)] = inst_76518);

return statearr_76575;
})();
if(cljs.core.truth_(inst_76519__$1)){
var statearr_76576_76608 = state_76549__$1;
(statearr_76576_76608[(1)] = (15));

} else {
var statearr_76577_76609 = state_76549__$1;
(statearr_76577_76609[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (16))){
var state_76549__$1 = state_76549;
var statearr_76578_76610 = state_76549__$1;
(statearr_76578_76610[(2)] = auth);

(statearr_76578_76610[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (10))){
var inst_76503 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76504 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_76505 = cljs.core.PersistentHashMap.fromArrays(inst_76503,inst_76504);
var inst_76506 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_76505);
var inst_76507 = (function(){throw inst_76506})();
var state_76549__$1 = state_76549;
var statearr_76579_76611 = state_76549__$1;
(statearr_76579_76611[(2)] = inst_76507);

(statearr_76579_76611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (18))){
var state_76549__$1 = state_76549;
var statearr_76580_76612 = state_76549__$1;
(statearr_76580_76612[(2)] = null);

(statearr_76580_76612[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (8))){
var inst_76500 = (state_76549[(2)]);
var state_76549__$1 = (function (){var statearr_76581 = state_76549;
(statearr_76581[(11)] = inst_76500);

return statearr_76581;
})();
if(cljs.core.truth_(ledger)){
var statearr_76582_76613 = state_76549__$1;
(statearr_76582_76613[(1)] = (9));

} else {
var statearr_76583_76614 = state_76549__$1;
(statearr_76583_76614[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_76584 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76584[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_76584[(1)] = (1));

return statearr_76584;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_76549){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76585){var ex__2749__auto__ = e76585;
var statearr_76586_76615 = state_76549;
(statearr_76586_76615[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76549[(4)]))){
var statearr_76587_76616 = state_76549;
(statearr_76587_76616[(1)] = cljs.core.first.call(null,(state_76549[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76617 = state_76549;
state_76549 = G__76617;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_76549){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_76549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76588 = f__2769__auto__.call(null);
(statearr_76588[(6)] = c__2768__auto__);

return statearr_76588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__76619 = arguments.length;
switch (G__76619) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76654){
var state_val_76655 = (state_76654[(1)]);
if((state_val_76655 === (1))){
var state_76654__$1 = state_76654;
var statearr_76656_76676 = state_76654__$1;
(statearr_76656_76676[(2)] = null);

(statearr_76656_76676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76655 === (2))){
var _ = (function (){var statearr_76657 = state_76654;
(statearr_76657[(4)] = cljs.core.cons.call(null,(5),(state_76654[(4)])));

return statearr_76657;
})();
var inst_76628 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_76654__$1 = state_76654;
if(cljs.core.truth_(inst_76628)){
var statearr_76658_76677 = state_76654__$1;
(statearr_76658_76677[(1)] = (6));

} else {
var statearr_76659_76678 = state_76654__$1;
(statearr_76659_76678[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76655 === (3))){
var inst_76652 = (state_76654[(2)]);
var state_76654__$1 = state_76654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76654__$1,inst_76652);
} else {
if((state_val_76655 === (4))){
var inst_76620 = (state_76654[(2)]);
var inst_76621 = cljs.core.clj__GT_js.call(null,inst_76620);
var inst_76622 = reject.call(null,inst_76621);
var state_76654__$1 = state_76654;
var statearr_76661_76679 = state_76654__$1;
(statearr_76661_76679[(2)] = inst_76622);

(statearr_76661_76679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76655 === (5))){
var _ = (function (){var statearr_76662 = state_76654;
(statearr_76662[(4)] = cljs.core.rest.call(null,(state_76654[(4)])));

return statearr_76662;
})();
var state_76654__$1 = state_76654;
var ex76660 = (state_76654__$1[(2)]);
var statearr_76663_76680 = state_76654__$1;
(statearr_76663_76680[(5)] = ex76660);


var statearr_76664_76681 = state_76654__$1;
(statearr_76664_76681[(1)] = (4));

(statearr_76664_76681[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76655 === (6))){
var state_76654__$1 = state_76654;
var statearr_76665_76682 = state_76654__$1;
(statearr_76665_76682[(2)] = null);

(statearr_76665_76682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76655 === (7))){
var inst_76631 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76632 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_76633 = cljs.core.PersistentHashMap.fromArrays(inst_76631,inst_76632);
var inst_76634 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_76633);
var inst_76635 = (function(){throw inst_76634})();
var state_76654__$1 = state_76654;
var statearr_76666_76683 = state_76654__$1;
(statearr_76666_76683[(2)] = inst_76635);

(statearr_76666_76683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76655 === (8))){
var inst_76637 = (state_76654[(2)]);
var inst_76638 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_76639 = [jwt,expire];
var inst_76640 = cljs.core.PersistentHashMap.fromArrays(inst_76638,inst_76639);
var inst_76641 = fluree.db.util.core.without_nils.call(null,inst_76640);
var inst_76642 = cljs.core.async.promise_chan.call(null);
var inst_76643 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76645 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_76641,inst_76642,null];
var inst_76646 = (new cljs.core.PersistentVector(null,4,(5),inst_76644,inst_76645,null));
var inst_76647 = cljs.core.async.put_BANG_.call(null,inst_76643,inst_76646);
var inst_76648 = (function (){var _ = inst_76637;
var data = inst_76641;
var pc = inst_76642;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_76649 = cljs.core.async.take_BANG_.call(null,inst_76642,inst_76648);
var _ = (function (){var statearr_76667 = state_76654;
(statearr_76667[(4)] = cljs.core.rest.call(null,(state_76654[(4)])));

return statearr_76667;
})();
var state_76654__$1 = (function (){var statearr_76668 = state_76654;
(statearr_76668[(7)] = inst_76647);

return statearr_76668;
})();
var statearr_76669_76684 = state_76654__$1;
(statearr_76669_76684[(2)] = inst_76649);

(statearr_76669_76684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_76670 = [null,null,null,null,null,null,null,null];
(statearr_76670[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_76670[(1)] = (1));

return statearr_76670;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_76654){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76671){var ex__2749__auto__ = e76671;
var statearr_76672_76685 = state_76654;
(statearr_76672_76685[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76654[(4)]))){
var statearr_76673_76686 = state_76654;
(statearr_76673_76686[(1)] = cljs.core.first.call(null,(state_76654[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76687 = state_76654;
state_76654 = G__76687;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_76654){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_76654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76674 = f__2769__auto__.call(null);
(statearr_76674[(6)] = c__2768__auto__);

return statearr_76674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

