// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__74935_75116 = cljs.core.seq.call(null,servers);
var chunk__74936_75117 = null;
var count__74937_75118 = (0);
var i__74938_75119 = (0);
while(true){
if((i__74938_75119 < count__74937_75118)){
var server_75120 = cljs.core._nth.call(null,chunk__74936_75117,i__74938_75119);
var healthcheck_uri_75121 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_75120),"/fdb/health"].join('');
var resp_chan_75122 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_75121,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___75123 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75123,healthcheck_uri_75121,resp_chan_75122,server_75120){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75123,healthcheck_uri_75121,resp_chan_75122,server_75120){
return (function (state_75008){
var state_val_75009 = (state_75008[(1)]);
if((state_val_75009 === (1))){
var state_75008__$1 = state_75008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75008__$1,(2),resp_chan_75122);
} else {
if((state_val_75009 === (2))){
var inst_74994 = (state_75008[(7)]);
var inst_74994__$1 = (state_75008[(2)]);
var inst_74995 = fluree.db.util.core.exception_QMARK_.call(null,inst_74994__$1);
var state_75008__$1 = (function (){var statearr_75010 = state_75008;
(statearr_75010[(7)] = inst_74994__$1);

return statearr_75010;
})();
if(inst_74995){
var statearr_75011_75124 = state_75008__$1;
(statearr_75011_75124[(1)] = (3));

} else {
var statearr_75012_75125 = state_75008__$1;
(statearr_75012_75125[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75009 === (3))){
var inst_74994 = (state_75008[(7)]);
var inst_74997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74998 = cljs.core.ex_message.call(null,inst_74994);
var inst_74999 = cljs.core.ex_data.call(null,inst_74994);
var inst_75000 = ["Server contact error: ",inst_74998,inst_74999];
var inst_75001 = (new cljs.core.PersistentVector(null,3,(5),inst_74997,inst_75000,null));
var inst_75002 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_75001);
var state_75008__$1 = state_75008;
var statearr_75013_75126 = state_75008__$1;
(statearr_75013_75126[(2)] = inst_75002);

(statearr_75013_75126[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75009 === (4))){
var inst_75004 = cljs.core.async.put_BANG_.call(null,promise_chan,server_75120);
var state_75008__$1 = state_75008;
var statearr_75014_75127 = state_75008__$1;
(statearr_75014_75127[(2)] = inst_75004);

(statearr_75014_75127[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75009 === (5))){
var inst_75006 = (state_75008[(2)]);
var state_75008__$1 = state_75008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75008__$1,inst_75006);
} else {
return null;
}
}
}
}
}
});})(seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75123,healthcheck_uri_75121,resp_chan_75122,server_75120))
;
return ((function (seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,switch__2745__auto__,c__2768__auto___75123,healthcheck_uri_75121,resp_chan_75122,server_75120){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_75015 = [null,null,null,null,null,null,null,null];
(statearr_75015[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_75015[(1)] = (1));

return statearr_75015;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_75008){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75016){var ex__2749__auto__ = e75016;
var statearr_75017_75128 = state_75008;
(statearr_75017_75128[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75008[(4)]))){
var statearr_75018_75129 = state_75008;
(statearr_75018_75129[(1)] = cljs.core.first.call(null,(state_75008[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75130 = state_75008;
state_75008 = G__75130;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_75008){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_75008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,switch__2745__auto__,c__2768__auto___75123,healthcheck_uri_75121,resp_chan_75122,server_75120))
})();
var state__2770__auto__ = (function (){var statearr_75019 = f__2769__auto__.call(null);
(statearr_75019[(6)] = c__2768__auto___75123);

return statearr_75019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75123,healthcheck_uri_75121,resp_chan_75122,server_75120))
);



var G__75131 = seq__74935_75116;
var G__75132 = chunk__74936_75117;
var G__75133 = count__74937_75118;
var G__75134 = (i__74938_75119 + (1));
seq__74935_75116 = G__75131;
chunk__74936_75117 = G__75132;
count__74937_75118 = G__75133;
i__74938_75119 = G__75134;
continue;
} else {
var temp__5804__auto___75135 = cljs.core.seq.call(null,seq__74935_75116);
if(temp__5804__auto___75135){
var seq__74935_75136__$1 = temp__5804__auto___75135;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74935_75136__$1)){
var c__5568__auto___75137 = cljs.core.chunk_first.call(null,seq__74935_75136__$1);
var G__75138 = cljs.core.chunk_rest.call(null,seq__74935_75136__$1);
var G__75139 = c__5568__auto___75137;
var G__75140 = cljs.core.count.call(null,c__5568__auto___75137);
var G__75141 = (0);
seq__74935_75116 = G__75138;
chunk__74936_75117 = G__75139;
count__74937_75118 = G__75140;
i__74938_75119 = G__75141;
continue;
} else {
var server_75142 = cljs.core.first.call(null,seq__74935_75136__$1);
var healthcheck_uri_75143 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_75142),"/fdb/health"].join('');
var resp_chan_75144 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_75143,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___75145 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75145,healthcheck_uri_75143,resp_chan_75144,server_75142,seq__74935_75136__$1,temp__5804__auto___75135){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75145,healthcheck_uri_75143,resp_chan_75144,server_75142,seq__74935_75136__$1,temp__5804__auto___75135){
return (function (state_75035){
var state_val_75036 = (state_75035[(1)]);
if((state_val_75036 === (1))){
var state_75035__$1 = state_75035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75035__$1,(2),resp_chan_75144);
} else {
if((state_val_75036 === (2))){
var inst_75021 = (state_75035[(7)]);
var inst_75021__$1 = (state_75035[(2)]);
var inst_75022 = fluree.db.util.core.exception_QMARK_.call(null,inst_75021__$1);
var state_75035__$1 = (function (){var statearr_75037 = state_75035;
(statearr_75037[(7)] = inst_75021__$1);

return statearr_75037;
})();
if(inst_75022){
var statearr_75038_75146 = state_75035__$1;
(statearr_75038_75146[(1)] = (3));

} else {
var statearr_75039_75147 = state_75035__$1;
(statearr_75039_75147[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75036 === (3))){
var inst_75021 = (state_75035[(7)]);
var inst_75024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75025 = cljs.core.ex_message.call(null,inst_75021);
var inst_75026 = cljs.core.ex_data.call(null,inst_75021);
var inst_75027 = ["Server contact error: ",inst_75025,inst_75026];
var inst_75028 = (new cljs.core.PersistentVector(null,3,(5),inst_75024,inst_75027,null));
var inst_75029 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_75028);
var state_75035__$1 = state_75035;
var statearr_75040_75148 = state_75035__$1;
(statearr_75040_75148[(2)] = inst_75029);

(statearr_75040_75148[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75036 === (4))){
var inst_75031 = cljs.core.async.put_BANG_.call(null,promise_chan,server_75142);
var state_75035__$1 = state_75035;
var statearr_75041_75149 = state_75035__$1;
(statearr_75041_75149[(2)] = inst_75031);

(statearr_75041_75149[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75036 === (5))){
var inst_75033 = (state_75035[(2)]);
var state_75035__$1 = state_75035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75035__$1,inst_75033);
} else {
return null;
}
}
}
}
}
});})(seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75145,healthcheck_uri_75143,resp_chan_75144,server_75142,seq__74935_75136__$1,temp__5804__auto___75135))
;
return ((function (seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,switch__2745__auto__,c__2768__auto___75145,healthcheck_uri_75143,resp_chan_75144,server_75142,seq__74935_75136__$1,temp__5804__auto___75135){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_75042 = [null,null,null,null,null,null,null,null];
(statearr_75042[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_75042[(1)] = (1));

return statearr_75042;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_75035){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75043){var ex__2749__auto__ = e75043;
var statearr_75044_75150 = state_75035;
(statearr_75044_75150[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75035[(4)]))){
var statearr_75045_75151 = state_75035;
(statearr_75045_75151[(1)] = cljs.core.first.call(null,(state_75035[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75152 = state_75035;
state_75035 = G__75152;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_75035){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_75035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,switch__2745__auto__,c__2768__auto___75145,healthcheck_uri_75143,resp_chan_75144,server_75142,seq__74935_75136__$1,temp__5804__auto___75135))
})();
var state__2770__auto__ = (function (){var statearr_75046 = f__2769__auto__.call(null);
(statearr_75046[(6)] = c__2768__auto___75145);

return statearr_75046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__74935_75116,chunk__74936_75117,count__74937_75118,i__74938_75119,c__2768__auto___75145,healthcheck_uri_75143,resp_chan_75144,server_75142,seq__74935_75136__$1,temp__5804__auto___75135))
);



var G__75153 = cljs.core.next.call(null,seq__74935_75136__$1);
var G__75154 = null;
var G__75155 = (0);
var G__75156 = (0);
seq__74935_75116 = G__75153;
chunk__74936_75117 = G__75154;
count__74937_75118 = G__75155;
i__74938_75119 = G__75156;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75090){
var state_val_75091 = (state_75090[(1)]);
if((state_val_75091 === (7))){
var inst_75062 = (state_75090[(7)]);
var inst_75069 = cljs.core._EQ_.call(null,inst_75062,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_75090__$1 = state_75090;
if(inst_75069){
var statearr_75092_75157 = state_75090__$1;
(statearr_75092_75157[(1)] = (9));

} else {
var statearr_75093_75158 = state_75090__$1;
(statearr_75093_75158[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (1))){
var inst_75054 = (state_75090[(8)]);
var inst_75055 = (state_75090[(9)]);
var inst_75054__$1 = promise_chan;
var inst_75055__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_75056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75057 = [inst_75054__$1,inst_75055__$1];
var inst_75058 = (new cljs.core.PersistentVector(null,2,(5),inst_75056,inst_75057,null));
var state_75090__$1 = (function (){var statearr_75094 = state_75090;
(statearr_75094[(8)] = inst_75054__$1);

(statearr_75094[(9)] = inst_75055__$1);

return statearr_75094;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_75090__$1,(2),inst_75058);
} else {
if((state_val_75091 === (4))){
var inst_75055 = (state_75090[(9)]);
var inst_75062 = (state_75090[(7)]);
var inst_75066 = cljs.core._EQ_.call(null,inst_75062,inst_75055);
var state_75090__$1 = state_75090;
if(inst_75066){
var statearr_75095_75159 = state_75090__$1;
(statearr_75095_75159[(1)] = (6));

} else {
var statearr_75096_75160 = state_75090__$1;
(statearr_75096_75160[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (13))){
var state_75090__$1 = state_75090;
var statearr_75097_75161 = state_75090__$1;
(statearr_75097_75161[(2)] = null);

(statearr_75097_75161[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (6))){
var state_75090__$1 = state_75090;
var statearr_75098_75162 = state_75090__$1;
(statearr_75098_75162[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_75098_75162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (3))){
var state_75090__$1 = state_75090;
var statearr_75099_75163 = state_75090__$1;
(statearr_75099_75163[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_75099_75163[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (12))){
var inst_75080 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_75081 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75082 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_75083 = cljs.core.PersistentHashMap.fromArrays(inst_75081,inst_75082);
var inst_75084 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_75083);
var inst_75085 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_75084);
var state_75090__$1 = (function (){var statearr_75100 = state_75090;
(statearr_75100[(10)] = inst_75080);

return statearr_75100;
})();
var statearr_75101_75164 = state_75090__$1;
(statearr_75101_75164[(2)] = inst_75085);

(statearr_75101_75164[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (2))){
var inst_75054 = (state_75090[(8)]);
var inst_75062 = (state_75090[(7)]);
var inst_75060 = (state_75090[(2)]);
var inst_75061 = cljs.core.nth.call(null,inst_75060,(0),null);
var inst_75062__$1 = cljs.core.nth.call(null,inst_75060,(1),null);
var inst_75063 = cljs.core._EQ_.call(null,inst_75062__$1,inst_75054);
var state_75090__$1 = (function (){var statearr_75102 = state_75090;
(statearr_75102[(7)] = inst_75062__$1);

(statearr_75102[(11)] = inst_75061);

return statearr_75102;
})();
if(inst_75063){
var statearr_75103_75165 = state_75090__$1;
(statearr_75103_75165[(1)] = (3));

} else {
var statearr_75104_75166 = state_75090__$1;
(statearr_75104_75166[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (11))){
var inst_75073 = (state_75090[(2)]);
var state_75090__$1 = state_75090;
var statearr_75105_75167 = state_75090__$1;
(statearr_75105_75167[(2)] = inst_75073);

(statearr_75105_75167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (9))){
var inst_75061 = (state_75090[(11)]);
var state_75090__$1 = state_75090;
var statearr_75106_75168 = state_75090__$1;
(statearr_75106_75168[(2)] = inst_75061);

(statearr_75106_75168[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (5))){
var inst_75077 = (state_75090[(2)]);
var inst_75078 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_75077);
var state_75090__$1 = state_75090;
if(inst_75078){
var statearr_75107_75169 = state_75090__$1;
(statearr_75107_75169[(1)] = (12));

} else {
var statearr_75108_75170 = state_75090__$1;
(statearr_75108_75170[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (14))){
var inst_75088 = (state_75090[(2)]);
var state_75090__$1 = state_75090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75090__$1,inst_75088);
} else {
if((state_val_75091 === (10))){
var state_75090__$1 = state_75090;
var statearr_75109_75171 = state_75090__$1;
(statearr_75109_75171[(2)] = null);

(statearr_75109_75171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75091 === (8))){
var inst_75075 = (state_75090[(2)]);
var state_75090__$1 = state_75090;
var statearr_75110_75172 = state_75090__$1;
(statearr_75110_75172[(2)] = inst_75075);

(statearr_75110_75172[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_75111 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75111[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_75111[(1)] = (1));

return statearr_75111;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_75090){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75112){var ex__2749__auto__ = e75112;
var statearr_75113_75173 = state_75090;
(statearr_75113_75173[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75090[(4)]))){
var statearr_75114_75174 = state_75090;
(statearr_75114_75174[(1)] = cljs.core.first.call(null,(state_75090[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75175 = state_75090;
state_75090 = G__75175;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_75090){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_75090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75115 = f__2769__auto__.call(null);
(statearr_75115[(6)] = c__2768__auto__);

return statearr_75115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75219){
var state_val_75220 = (state_75219[(1)]);
if((state_val_75220 === (7))){
var state_75219__$1 = state_75219;
var statearr_75221_75247 = state_75219__$1;
(statearr_75221_75247[(2)] = null);

(statearr_75221_75247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (1))){
var state_75219__$1 = state_75219;
var statearr_75222_75248 = state_75219__$1;
(statearr_75222_75248[(2)] = null);

(statearr_75222_75248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (4))){
var inst_75176 = (state_75219[(2)]);
var state_75219__$1 = state_75219;
var statearr_75223_75249 = state_75219__$1;
(statearr_75223_75249[(2)] = inst_75176);

(statearr_75223_75249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (6))){
var inst_75198 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_75219__$1 = state_75219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75219__$1,(9),inst_75198);
} else {
if((state_val_75220 === (3))){
var inst_75217 = (state_75219[(2)]);
var state_75219__$1 = state_75219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75219__$1,inst_75217);
} else {
if((state_val_75220 === (12))){
var inst_75211 = (state_75219[(2)]);
var state_75219__$1 = state_75219;
var statearr_75224_75250 = state_75219__$1;
(statearr_75224_75250[(2)] = inst_75211);

(statearr_75224_75250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (2))){
var inst_75187 = (state_75219[(7)]);
var inst_75192 = (state_75219[(8)]);
var inst_75182 = (state_75219[(9)]);
var _ = (function (){var statearr_75225 = state_75219;
(statearr_75225[(4)] = cljs.core.cons.call(null,(5),(state_75219[(4)])));

return statearr_75225;
})();
var inst_75182__$1 = cljs.core.random_uuid.call(null);
var inst_75183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75184 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_75185 = (new cljs.core.PersistentVector(null,2,(5),inst_75183,inst_75184,null));
var inst_75186 = (function (){var lock_id = inst_75182__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_75187__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_75185,inst_75186);
var inst_75188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75189 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_75190 = (new cljs.core.PersistentVector(null,3,(5),inst_75188,inst_75189,null));
var inst_75191 = cljs.core.get_in.call(null,inst_75187__$1,inst_75190);
var inst_75192__$1 = cljs.core._EQ_.call(null,inst_75182__$1,inst_75191);
var inst_75193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75194 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_75195 = (new cljs.core.PersistentVector(null,3,(5),inst_75193,inst_75194,null));
var inst_75196 = cljs.core.get_in.call(null,inst_75187__$1,inst_75195);
var state_75219__$1 = (function (){var statearr_75226 = state_75219;
(statearr_75226[(7)] = inst_75187__$1);

(statearr_75226[(8)] = inst_75192__$1);

(statearr_75226[(9)] = inst_75182__$1);

(statearr_75226[(10)] = inst_75196);

return statearr_75226;
})();
if(inst_75192__$1){
var statearr_75227_75251 = state_75219__$1;
(statearr_75227_75251[(1)] = (6));

} else {
var statearr_75228_75252 = state_75219__$1;
(statearr_75228_75252[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (11))){
var inst_75203 = (state_75219[(11)]);
var inst_75196 = (state_75219[(10)]);
var inst_75202 = (state_75219[(12)]);
var inst_75209 = fluree.db.util.xhttp.try_socket.call(null,inst_75202,sub_chan,pub_chan,inst_75196,(60000),inst_75203);
var state_75219__$1 = state_75219;
var statearr_75230_75253 = state_75219__$1;
(statearr_75230_75253[(2)] = inst_75209);

(statearr_75230_75253[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (9))){
var inst_75187 = (state_75219[(7)]);
var inst_75192 = (state_75219[(8)]);
var inst_75200 = (state_75219[(13)]);
var inst_75182 = (state_75219[(9)]);
var inst_75196 = (state_75219[(10)]);
var inst_75202 = (state_75219[(12)]);
var inst_75200__$1 = (state_75219[(2)]);
var inst_75201 = clojure.string.replace.call(null,inst_75200__$1,"http","ws");
var inst_75202__$1 = [inst_75201,"/fdb/ws"].join('');
var inst_75203 = (function (){var lock_id = inst_75182;
var state = inst_75187;
var have_lock_QMARK_ = inst_75192;
var resp_chan = inst_75196;
var healthy_server = inst_75200__$1;
var ws_url = inst_75202__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_75204 = fluree.db.util.core.exception_QMARK_.call(null,inst_75200__$1);
var state_75219__$1 = (function (){var statearr_75231 = state_75219;
(statearr_75231[(11)] = inst_75203);

(statearr_75231[(13)] = inst_75200__$1);

(statearr_75231[(12)] = inst_75202__$1);

return statearr_75231;
})();
if(inst_75204){
var statearr_75232_75254 = state_75219__$1;
(statearr_75232_75254[(1)] = (10));

} else {
var statearr_75233_75255 = state_75219__$1;
(statearr_75233_75255[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (5))){
var _ = (function (){var statearr_75234 = state_75219;
(statearr_75234[(4)] = cljs.core.rest.call(null,(state_75219[(4)])));

return statearr_75234;
})();
var state_75219__$1 = state_75219;
var ex75229 = (state_75219__$1[(2)]);
var statearr_75235_75256 = state_75219__$1;
(statearr_75235_75256[(5)] = ex75229);


if((ex75229 instanceof Error)){
var statearr_75236_75257 = state_75219__$1;
(statearr_75236_75257[(1)] = (4));

(statearr_75236_75257[(5)] = null);

} else {
throw ex75229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (10))){
var inst_75200 = (state_75219[(13)]);
var inst_75196 = (state_75219[(10)]);
var inst_75206 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_75207 = cljs.core.async.put_BANG_.call(null,inst_75196,inst_75200);
var state_75219__$1 = (function (){var statearr_75237 = state_75219;
(statearr_75237[(14)] = inst_75206);

return statearr_75237;
})();
var statearr_75238_75258 = state_75219__$1;
(statearr_75238_75258[(2)] = inst_75207);

(statearr_75238_75258[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75220 === (8))){
var inst_75196 = (state_75219[(10)]);
var inst_75214 = (state_75219[(2)]);
var _ = (function (){var statearr_75239 = state_75219;
(statearr_75239[(4)] = cljs.core.rest.call(null,(state_75219[(4)])));

return statearr_75239;
})();
var state_75219__$1 = (function (){var statearr_75240 = state_75219;
(statearr_75240[(15)] = inst_75214);

return statearr_75240;
})();
var statearr_75241_75259 = state_75219__$1;
(statearr_75241_75259[(2)] = inst_75196);

(statearr_75241_75259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_75242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75242[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_75242[(1)] = (1));

return statearr_75242;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_75219){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75243){var ex__2749__auto__ = e75243;
var statearr_75244_75260 = state_75219;
(statearr_75244_75260[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75219[(4)]))){
var statearr_75245_75261 = state_75219;
(statearr_75245_75261[(1)] = cljs.core.first.call(null,(state_75219[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75262 = state_75219;
state_75219 = G__75262;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_75219){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_75219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75246 = f__2769__auto__.call(null);
(statearr_75246[(6)] = c__2768__auto__);

return statearr_75246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k75264,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__75268 = k75264;
var G__75268__$1 = (((G__75268 instanceof cljs.core.Keyword))?G__75268.fqn:null);
switch (G__75268__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k75264,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__75269){
var vec__75270 = p__75269;
var k__5367__auto__ = cljs.core.nth.call(null,vec__75270,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__75270,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__75263){
var self__ = this;
var G__75263__$1 = this;
return (new cljs.core.RecordIter((0),G__75263__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this75265,other75266){
var self__ = this;
var this75265__$1 = this;
return (((!((other75266 == null)))) && ((((this75265__$1.constructor === other75266.constructor)) && (((cljs.core._EQ_.call(null,this75265__$1.id,other75266.id)) && (((cljs.core._EQ_.call(null,this75265__$1.servers,other75266.servers)) && (((cljs.core._EQ_.call(null,this75265__$1.state,other75266.state)) && (((cljs.core._EQ_.call(null,this75265__$1.req_chan,other75266.req_chan)) && (((cljs.core._EQ_.call(null,this75265__$1.sub_chan,other75266.sub_chan)) && (((cljs.core._EQ_.call(null,this75265__$1.pub_chan,other75266.pub_chan)) && (((cljs.core._EQ_.call(null,this75265__$1.group,other75266.group)) && (((cljs.core._EQ_.call(null,this75265__$1.storage_read,other75266.storage_read)) && (((cljs.core._EQ_.call(null,this75265__$1.storage_list,other75266.storage_list)) && (((cljs.core._EQ_.call(null,this75265__$1.storage_write,other75266.storage_write)) && (((cljs.core._EQ_.call(null,this75265__$1.storage_exists,other75266.storage_exists)) && (((cljs.core._EQ_.call(null,this75265__$1.storage_rename,other75266.storage_rename)) && (((cljs.core._EQ_.call(null,this75265__$1.storage_delete,other75266.storage_delete)) && (((cljs.core._EQ_.call(null,this75265__$1.object_cache,other75266.object_cache)) && (((cljs.core._EQ_.call(null,this75265__$1.async_cache,other75266.async_cache)) && (((cljs.core._EQ_.call(null,this75265__$1.parallelism,other75266.parallelism)) && (((cljs.core._EQ_.call(null,this75265__$1.serializer,other75266.serializer)) && (((cljs.core._EQ_.call(null,this75265__$1.default_network,other75266.default_network)) && (((cljs.core._EQ_.call(null,this75265__$1.transactor_QMARK_,other75266.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this75265__$1.publish,other75266.publish)) && (((cljs.core._EQ_.call(null,this75265__$1.transact_handler,other75266.transact_handler)) && (((cljs.core._EQ_.call(null,this75265__$1.tx_private_key,other75266.tx_private_key)) && (((cljs.core._EQ_.call(null,this75265__$1.tx_key_id,other75266.tx_key_id)) && (((cljs.core._EQ_.call(null,this75265__$1.meta,other75266.meta)) && (((cljs.core._EQ_.call(null,this75265__$1.add_listener,other75266.add_listener)) && (((cljs.core._EQ_.call(null,this75265__$1.remove_listener,other75266.remove_listener)) && (((cljs.core._EQ_.call(null,this75265__$1.close,other75266.close)) && (cljs.core._EQ_.call(null,this75265__$1.__extmap,other75266.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__75273){
var self__ = this;
var map__75274 = p__75273;
var map__75274__$1 = cljs.core.__destructure_map.call(null,map__75274);
var node = map__75274__$1;
var id__$1 = cljs.core.get.call(null,map__75274__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__75274__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__75274__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k75264){
var self__ = this;
var this__5350__auto____$1 = this;
var G__75275 = k75264;
var G__75275__$1 = (((G__75275 instanceof cljs.core.Keyword))?G__75275.fqn:null);
switch (G__75275__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k75264);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__75263){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__75276 = cljs.core.keyword_identical_QMARK_;
var expr__75277 = k__5352__auto__;
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__75277))){
return (new fluree.db.connection.Connection(G__75263,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,G__75263,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__75263,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__75263,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__75263,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__75263,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__75263,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__75263,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__75263,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__75263,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__75263,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__75263,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__75263,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__75263,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__75263,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__75263,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__75263,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__75263,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__75263,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__75263,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__75263,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__75263,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__75263,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__75263,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__75263,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__75263,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__75276.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__75277))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__75263,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__75263),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__75263){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__75263,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__75267){
var extmap__5385__auto__ = (function (){var G__75279 = cljs.core.dissoc.call(null,G__75267,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__75267)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__75279);
} else {
return G__75279;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__75267),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__75267),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__75285 = servers_STAR_;
var vec__75286 = G__75285;
var seq__75287 = cljs.core.seq.call(null,vec__75286);
var first__75288 = cljs.core.first.call(null,seq__75287);
var seq__75287__$1 = cljs.core.next.call(null,seq__75287);
var server = first__75288;
var r = seq__75287__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__75285__$1 = G__75285;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__75292 = G__75285__$1;
var seq__75293 = cljs.core.seq.call(null,vec__75292);
var first__75294 = cljs.core.first.call(null,seq__75293);
var seq__75293__$1 = cljs.core.next.call(null,seq__75293);
var server__$1 = first__75294;
var r__$1 = seq__75293__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__75295 = r__$1;
var G__75296 = is_https_QMARK_;
var G__75297 = result_STAR_;
G__75285__$1 = G__75295;
https_QMARK___$1 = G__75296;
result__$1 = G__75297;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__75298 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__75298 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__75298);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75327){
var state_val_75328 = (state_75327[(1)]);
if((state_val_75328 === (7))){
var inst_75313 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75314 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75315 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75316 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75317 = fluree.db.connection.establish_socket.call(null,inst_75313,inst_75314,inst_75315,inst_75316);
var state_75327__$1 = state_75327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75327__$1,(9),inst_75317);
} else {
if((state_val_75328 === (1))){
var state_75327__$1 = state_75327;
var statearr_75329_75348 = state_75327__$1;
(statearr_75329_75348[(2)] = null);

(statearr_75329_75348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75328 === (4))){
var inst_75299 = (state_75327[(2)]);
var state_75327__$1 = state_75327;
var statearr_75330_75349 = state_75327__$1;
(statearr_75330_75349[(2)] = inst_75299);

(statearr_75330_75349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75328 === (6))){
var inst_75310 = (state_75327[(7)]);
var state_75327__$1 = state_75327;
var statearr_75331_75350 = state_75327__$1;
(statearr_75331_75350[(2)] = inst_75310);

(statearr_75331_75350[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75328 === (3))){
var inst_75325 = (state_75327[(2)]);
var state_75327__$1 = state_75327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75327__$1,inst_75325);
} else {
if((state_val_75328 === (2))){
var inst_75310 = (state_75327[(7)]);
var _ = (function (){var statearr_75333 = state_75327;
(statearr_75333[(4)] = cljs.core.cons.call(null,(5),(state_75327[(4)])));

return statearr_75333;
})();
var inst_75305 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_75306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75307 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75308 = [inst_75307,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_75309 = (new cljs.core.PersistentVector(null,3,(5),inst_75306,inst_75308,null));
var inst_75310__$1 = cljs.core.get_in.call(null,inst_75305,inst_75309);
var state_75327__$1 = (function (){var statearr_75334 = state_75327;
(statearr_75334[(7)] = inst_75310__$1);

return statearr_75334;
})();
if(cljs.core.truth_(inst_75310__$1)){
var statearr_75335_75351 = state_75327__$1;
(statearr_75335_75351[(1)] = (6));

} else {
var statearr_75336_75352 = state_75327__$1;
(statearr_75336_75352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75328 === (9))){
var inst_75319 = (state_75327[(2)]);
var inst_75320 = fluree.db.util.async.throw_err.call(null,inst_75319);
var state_75327__$1 = state_75327;
var statearr_75337_75353 = state_75327__$1;
(statearr_75337_75353[(2)] = inst_75320);

(statearr_75337_75353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75328 === (5))){
var _ = (function (){var statearr_75338 = state_75327;
(statearr_75338[(4)] = cljs.core.rest.call(null,(state_75327[(4)])));

return statearr_75338;
})();
var state_75327__$1 = state_75327;
var ex75332 = (state_75327__$1[(2)]);
var statearr_75339_75354 = state_75327__$1;
(statearr_75339_75354[(5)] = ex75332);


if((ex75332 instanceof Error)){
var statearr_75340_75355 = state_75327__$1;
(statearr_75340_75355[(1)] = (4));

(statearr_75340_75355[(5)] = null);

} else {
throw ex75332;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75328 === (8))){
var inst_75322 = (state_75327[(2)]);
var _ = (function (){var statearr_75341 = state_75327;
(statearr_75341[(4)] = cljs.core.rest.call(null,(state_75327[(4)])));

return statearr_75341;
})();
var state_75327__$1 = state_75327;
var statearr_75342_75356 = state_75327__$1;
(statearr_75342_75356[(2)] = inst_75322);

(statearr_75342_75356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_75343 = [null,null,null,null,null,null,null,null];
(statearr_75343[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_75343[(1)] = (1));

return statearr_75343;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_75327){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75344){var ex__2749__auto__ = e75344;
var statearr_75345_75357 = state_75327;
(statearr_75345_75357[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75327[(4)]))){
var statearr_75346_75358 = state_75327;
(statearr_75346_75358[(1)] = cljs.core.first.call(null,(state_75327[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75359 = state_75327;
state_75327 = G__75359;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_75327){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_75327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75347 = f__2769__auto__.call(null);
(statearr_75347[(6)] = c__2768__auto__);

return statearr_75347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e75360){var e = e75360;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__75362){
var map__75363 = p__75362;
var map__75363__$1 = cljs.core.__destructure_map.call(null,map__75363);
var conn = map__75363__$1;
var state = cljs.core.get.call(null,map__75363__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__75363__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__75363__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75509){
var state_val_75510 = (state_75509[(1)]);
if((state_val_75510 === (7))){
var inst_75505 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
var statearr_75512_75586 = state_75509__$1;
(statearr_75512_75586[(2)] = inst_75505);

(statearr_75512_75586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (20))){
var _ = (function (){var statearr_75513 = state_75509;
(statearr_75513[(4)] = cljs.core.rest.call(null,(state_75509[(4)])));

return statearr_75513;
})();
var state_75509__$1 = state_75509;
var ex75511 = (state_75509__$1[(2)]);
var statearr_75514_75587 = state_75509__$1;
(statearr_75514_75587[(5)] = ex75511);


var statearr_75515_75588 = state_75509__$1;
(statearr_75515_75588[(1)] = (10));

(statearr_75515_75588[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (27))){
var inst_75466 = (state_75509[(7)]);
var inst_75466__$1 = (state_75509[(2)]);
var inst_75467 = inst_75466__$1 === true;
var state_75509__$1 = (function (){var statearr_75516 = state_75509;
(statearr_75516[(7)] = inst_75466__$1);

return statearr_75516;
})();
if(cljs.core.truth_(inst_75467)){
var statearr_75517_75589 = state_75509__$1;
(statearr_75517_75589[(1)] = (28));

} else {
var statearr_75518_75590 = state_75509__$1;
(statearr_75518_75590[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (1))){
var inst_75364 = (0);
var state_75509__$1 = (function (){var statearr_75519 = state_75509;
(statearr_75519[(8)] = inst_75364);

return statearr_75519;
})();
var statearr_75520_75591 = state_75509__$1;
(statearr_75520_75591[(2)] = null);

(statearr_75520_75591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (24))){
var inst_75456 = (state_75509[(9)]);
var state_75509__$1 = state_75509;
var statearr_75521_75592 = state_75509__$1;
(statearr_75521_75592[(2)] = inst_75456);

(statearr_75521_75592[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (39))){
var inst_75491 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
var statearr_75522_75593 = state_75509__$1;
(statearr_75522_75593[(2)] = inst_75491);

(statearr_75522_75593[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (4))){
var inst_75367 = (state_75509[(10)]);
var inst_75367__$1 = (state_75509[(2)]);
var state_75509__$1 = (function (){var statearr_75523 = state_75509;
(statearr_75523[(10)] = inst_75367__$1);

return statearr_75523;
})();
if(cljs.core.truth_(inst_75367__$1)){
var statearr_75524_75594 = state_75509__$1;
(statearr_75524_75594[(1)] = (5));

} else {
var statearr_75525_75595 = state_75509__$1;
(statearr_75525_75595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (15))){
var inst_75380 = (state_75509[(11)]);
var state_75509__$1 = state_75509;
var statearr_75526_75596 = state_75509__$1;
(statearr_75526_75596[(2)] = inst_75380);

(statearr_75526_75596[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (21))){
var inst_75414 = (state_75509[(12)]);
var inst_75418 = (state_75509[(13)]);
var inst_75411 = (state_75509[(14)]);
var inst_75417 = (state_75509[(15)]);
var inst_75410 = (state_75509[(16)]);
var inst_75412 = (state_75509[(17)]);
var inst_75413 = (state_75509[(18)]);
var inst_75409 = (state_75509[(19)]);
var inst_75367 = (state_75509[(10)]);
var inst_75364 = (state_75509[(8)]);
var inst_75420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75421 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_75417];
var inst_75422 = (new cljs.core.PersistentVector(null,2,(5),inst_75420,inst_75421,null));
var inst_75423 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_75422,inst_75412);
var inst_75450 = cljs.core.async.chan.call(null,(1));
var inst_75451 = (function (){var resp_chan = inst_75412;
var timeout = inst_75418;
var i = inst_75364;
var data = inst_75411;
var _ = inst_75409;
var map__75405 = inst_75414;
var req_id = inst_75417;
var operation = inst_75410;
var vec__75402 = inst_75367;
var msg = inst_75367;
var temp__5804__auto__ = inst_75367;
var c__2768__auto____$1 = inst_75450;
var opts = inst_75413;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75448){
var state_val_75449 = (state_75448[(1)]);
if((state_val_75449 === (1))){
var inst_75427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75428 = cljs.core.async.timeout.call(null,timeout);
var inst_75429 = [resp_chan,inst_75428];
var inst_75430 = (new cljs.core.PersistentVector(null,2,(5),inst_75427,inst_75429,null));
var state_75448__$1 = state_75448;
return cljs.core.async.ioc_alts_BANG_.call(null,state_75448__$1,(2),inst_75430);
} else {
if((state_val_75449 === (2))){
var inst_75433 = (state_75448[(7)]);
var inst_75432 = (state_75448[(2)]);
var inst_75433__$1 = cljs.core.nth.call(null,inst_75432,(0),null);
var inst_75434 = cljs.core.nth.call(null,inst_75432,(1),null);
var inst_75435 = (function (){var vec__75424 = inst_75432;
var resp = inst_75433__$1;
var c = inst_75434;
return (function (p1__75361_SHARP_){
return cljs.core.dissoc.call(null,p1__75361_SHARP_,req_id);
});
})();
var inst_75436 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_75435);
var inst_75437 = cljs.core._EQ_.call(null,inst_75434,resp_chan);
var state_75448__$1 = (function (){var statearr_75527 = state_75448;
(statearr_75527[(8)] = inst_75436);

(statearr_75527[(7)] = inst_75433__$1);

return statearr_75527;
})();
if(inst_75437){
var statearr_75528_75597 = state_75448__$1;
(statearr_75528_75597[(1)] = (3));

} else {
var statearr_75529_75598 = state_75448__$1;
(statearr_75529_75598[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75449 === (3))){
var inst_75433 = (state_75448[(7)]);
var state_75448__$1 = state_75448;
var statearr_75530_75599 = state_75448__$1;
(statearr_75530_75599[(2)] = inst_75433);

(statearr_75530_75599[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75449 === (4))){
var inst_75440 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_75441 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75442 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_75443 = cljs.core.PersistentHashMap.fromArrays(inst_75441,inst_75442);
var inst_75444 = cljs.core.ex_info.call(null,inst_75440,inst_75443);
var state_75448__$1 = state_75448;
var statearr_75531_75600 = state_75448__$1;
(statearr_75531_75600[(2)] = inst_75444);

(statearr_75531_75600[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75449 === (5))){
var inst_75446 = (state_75448[(2)]);
var state_75448__$1 = state_75448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75448__$1,inst_75446);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_75532 = [null,null,null,null,null,null,null,null,null];
(statearr_75532[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_75532[(1)] = (1));

return statearr_75532;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_75448){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75533){var ex__2749__auto__ = e75533;
var statearr_75534_75601 = state_75448;
(statearr_75534_75601[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75448[(4)]))){
var statearr_75535_75602 = state_75448;
(statearr_75535_75602[(1)] = cljs.core.first.call(null,(state_75448[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75603 = state_75448;
state_75448 = G__75603;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_75448){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_75448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75536 = f__2769__auto__.call(null);
(statearr_75536[(6)] = c__2768__auto____$1);

return statearr_75536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_75452 = cljs.core.async.impl.dispatch.run.call(null,inst_75451);
var state_75509__$1 = (function (){var statearr_75537 = state_75509;
(statearr_75537[(20)] = inst_75423);

(statearr_75537[(21)] = inst_75452);

return statearr_75537;
})();
var statearr_75538_75604 = state_75509__$1;
(statearr_75538_75604[(2)] = inst_75450);

(statearr_75538_75604[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (31))){
var inst_75466 = (state_75509[(7)]);
var inst_75472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75473 = [inst_75466,"Error processing message in producer."];
var inst_75474 = (new cljs.core.PersistentVector(null,2,(5),inst_75472,inst_75473,null));
var inst_75475 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75474);
var state_75509__$1 = state_75509;
var statearr_75539_75605 = state_75509__$1;
(statearr_75539_75605[(2)] = inst_75475);

(statearr_75539_75605[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (32))){
var inst_75466 = (state_75509[(7)]);
var inst_75477 = (inst_75466 == null);
var state_75509__$1 = state_75509;
if(cljs.core.truth_(inst_75477)){
var statearr_75540_75606 = state_75509__$1;
(statearr_75540_75606[(1)] = (34));

} else {
var statearr_75541_75607 = state_75509__$1;
(statearr_75541_75607[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (33))){
var inst_75495 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
var statearr_75542_75608 = state_75509__$1;
(statearr_75542_75608[(2)] = inst_75495);

(statearr_75542_75608[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (13))){
var inst_75380 = (state_75509[(11)]);
var inst_75377 = (state_75509[(2)]);
var inst_75378 = cljs.core.nth.call(null,inst_75377,(0),null);
var inst_75379 = cljs.core.nth.call(null,inst_75377,(1),null);
var inst_75380__$1 = cljs.core.nth.call(null,inst_75377,(2),null);
var state_75509__$1 = (function (){var statearr_75543 = state_75509;
(statearr_75543[(22)] = inst_75378);

(statearr_75543[(23)] = inst_75379);

(statearr_75543[(11)] = inst_75380__$1);

return statearr_75543;
})();
if(cljs.core.truth_(inst_75380__$1)){
var statearr_75544_75609 = state_75509__$1;
(statearr_75544_75609[(1)] = (14));

} else {
var statearr_75545_75610 = state_75509__$1;
(statearr_75545_75610[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (22))){
var state_75509__$1 = state_75509;
var statearr_75546_75611 = state_75509__$1;
(statearr_75546_75611[(2)] = null);

(statearr_75546_75611[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (36))){
var inst_75493 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
var statearr_75547_75612 = state_75509__$1;
(statearr_75547_75612[(2)] = inst_75493);

(statearr_75547_75612[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (29))){
var inst_75466 = (state_75509[(7)]);
var inst_75470 = fluree.db.util.core.exception_QMARK_.call(null,inst_75466);
var state_75509__$1 = state_75509;
if(inst_75470){
var statearr_75548_75613 = state_75509__$1;
(statearr_75548_75613[(1)] = (31));

} else {
var statearr_75549_75614 = state_75509__$1;
(statearr_75549_75614[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (6))){
var state_75509__$1 = state_75509;
var statearr_75550_75615 = state_75509__$1;
(statearr_75550_75615[(2)] = null);

(statearr_75550_75615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (28))){
var state_75509__$1 = state_75509;
var statearr_75551_75616 = state_75509__$1;
(statearr_75551_75616[(2)] = null);

(statearr_75551_75616[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (25))){
var state_75509__$1 = state_75509;
var statearr_75552_75617 = state_75509__$1;
(statearr_75552_75617[(2)] = fluree.db.connection.default_publish_fn);

(statearr_75552_75617[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (34))){
var inst_75479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75480 = ["Error processing message in producer. Socket closed."];
var inst_75481 = (new cljs.core.PersistentVector(null,1,(5),inst_75479,inst_75480,null));
var inst_75482 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75481);
var state_75509__$1 = state_75509;
var statearr_75553_75618 = state_75509__$1;
(statearr_75553_75618[(2)] = inst_75482);

(statearr_75553_75618[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (17))){
var inst_75380 = (state_75509[(11)]);
var inst_75369 = (state_75509[(24)]);
var inst_75387 = cljs.core.async.put_BANG_.call(null,inst_75380,inst_75369);
var state_75509__$1 = state_75509;
var statearr_75554_75619 = state_75509__$1;
(statearr_75554_75619[(2)] = inst_75387);

(statearr_75554_75619[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (3))){
var inst_75507 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75509__$1,inst_75507);
} else {
if((state_val_75510 === (12))){
var state_75509__$1 = state_75509;
var statearr_75555_75620 = state_75509__$1;
(statearr_75555_75620[(2)] = null);

(statearr_75555_75620[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (2))){
var state_75509__$1 = state_75509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75509__$1,(4),req_chan);
} else {
if((state_val_75510 === (23))){
var inst_75456 = (state_75509[(9)]);
var inst_75455 = (state_75509[(2)]);
var inst_75456__$1 = publish;
var state_75509__$1 = (function (){var statearr_75556 = state_75509;
(statearr_75556[(9)] = inst_75456__$1);

(statearr_75556[(25)] = inst_75455);

return statearr_75556;
})();
if(cljs.core.truth_(inst_75456__$1)){
var statearr_75557_75621 = state_75509__$1;
(statearr_75557_75621[(1)] = (24));

} else {
var statearr_75558_75622 = state_75509__$1;
(statearr_75558_75622[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (35))){
var state_75509__$1 = state_75509;
var statearr_75559_75623 = state_75509__$1;
(statearr_75559_75623[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (19))){
var inst_75396 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
var statearr_75561_75624 = state_75509__$1;
(statearr_75561_75624[(2)] = inst_75396);

(statearr_75561_75624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (11))){
var inst_75367 = (state_75509[(10)]);
var state_75509__$1 = state_75509;
var statearr_75562_75625 = state_75509__$1;
(statearr_75562_75625[(2)] = inst_75367);

(statearr_75562_75625[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (9))){
var inst_75364 = (state_75509[(8)]);
var inst_75500 = (state_75509[(2)]);
var inst_75501 = (inst_75364 + (1));
var inst_75364__$1 = inst_75501;
var state_75509__$1 = (function (){var statearr_75563 = state_75509;
(statearr_75563[(26)] = inst_75500);

(statearr_75563[(8)] = inst_75364__$1);

return statearr_75563;
})();
var statearr_75564_75626 = state_75509__$1;
(statearr_75564_75626[(2)] = null);

(statearr_75564_75626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (5))){
var state_75509__$1 = state_75509;
var statearr_75565_75627 = state_75509__$1;
(statearr_75565_75627[(2)] = null);

(statearr_75565_75627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (14))){
var inst_75380 = (state_75509[(11)]);
var inst_75382 = fluree.db.util.async.channel_QMARK_.call(null,inst_75380);
var state_75509__$1 = state_75509;
var statearr_75566_75628 = state_75509__$1;
(statearr_75566_75628[(2)] = inst_75382);

(statearr_75566_75628[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (26))){
var inst_75411 = (state_75509[(14)]);
var inst_75417 = (state_75509[(15)]);
var inst_75410 = (state_75509[(16)]);
var inst_75460 = (state_75509[(2)]);
var inst_75461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75462 = [inst_75410,inst_75417,inst_75411];
var inst_75463 = (new cljs.core.PersistentVector(null,3,(5),inst_75461,inst_75462,null));
var inst_75464 = inst_75460.call(null,conn,inst_75463);
var state_75509__$1 = state_75509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75509__$1,(27),inst_75464);
} else {
if((state_val_75510 === (16))){
var inst_75385 = (state_75509[(2)]);
var state_75509__$1 = state_75509;
if(cljs.core.truth_(inst_75385)){
var statearr_75567_75629 = state_75509__$1;
(statearr_75567_75629[(1)] = (17));

} else {
var statearr_75568_75630 = state_75509__$1;
(statearr_75568_75630[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (38))){
var state_75509__$1 = state_75509;
var statearr_75569_75631 = state_75509__$1;
(statearr_75569_75631[(2)] = null);

(statearr_75569_75631[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (30))){
var inst_75497 = (state_75509[(2)]);
var _ = (function (){var statearr_75570 = state_75509;
(statearr_75570[(4)] = cljs.core.rest.call(null,(state_75509[(4)])));

return statearr_75570;
})();
var state_75509__$1 = state_75509;
var statearr_75571_75632 = state_75509__$1;
(statearr_75571_75632[(2)] = inst_75497);

(statearr_75571_75632[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (10))){
var inst_75367 = (state_75509[(10)]);
var inst_75369 = (state_75509[(2)]);
var inst_75373 = cljs.core.sequential_QMARK_.call(null,inst_75367);
var state_75509__$1 = (function (){var statearr_75572 = state_75509;
(statearr_75572[(24)] = inst_75369);

return statearr_75572;
})();
if(inst_75373){
var statearr_75573_75633 = state_75509__$1;
(statearr_75573_75633[(1)] = (11));

} else {
var statearr_75574_75634 = state_75509__$1;
(statearr_75574_75634[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (18))){
var inst_75367 = (state_75509[(10)]);
var inst_75369 = (state_75509[(24)]);
var inst_75389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75390 = cljs.core.pr_str.call(null,inst_75367);
var inst_75391 = ["Error processing ledger request, no valid return channel: ",inst_75390].join('');
var inst_75392 = [inst_75369,inst_75391];
var inst_75393 = (new cljs.core.PersistentVector(null,2,(5),inst_75389,inst_75392,null));
var inst_75394 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75393);
var state_75509__$1 = state_75509;
var statearr_75575_75635 = state_75509__$1;
(statearr_75575_75635[(2)] = inst_75394);

(statearr_75575_75635[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (37))){
var inst_75466 = (state_75509[(7)]);
var inst_75485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75486 = ["Error processing message in producer. Socket closed. Published result",inst_75466];
var inst_75487 = (new cljs.core.PersistentVector(null,2,(5),inst_75485,inst_75486,null));
var inst_75488 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75487);
var state_75509__$1 = state_75509;
var statearr_75576_75636 = state_75509__$1;
(statearr_75576_75636[(2)] = inst_75488);

(statearr_75576_75636[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75510 === (8))){
var inst_75414 = (state_75509[(12)]);
var inst_75412 = (state_75509[(17)]);
var inst_75413 = (state_75509[(18)]);
var inst_75367 = (state_75509[(10)]);
var _ = (function (){var statearr_75577 = state_75509;
(statearr_75577[(4)] = cljs.core.cons.call(null,(20),(state_75509[(4)])));

return statearr_75577;
})();
var inst_75406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75407 = ["Outgoing message to websocket: ",inst_75367];
var inst_75408 = (new cljs.core.PersistentVector(null,2,(5),inst_75406,inst_75407,null));
var inst_75409 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_75408);
var inst_75410 = cljs.core.nth.call(null,inst_75367,(0),null);
var inst_75411 = cljs.core.nth.call(null,inst_75367,(1),null);
var inst_75412__$1 = cljs.core.nth.call(null,inst_75367,(2),null);
var inst_75413__$1 = cljs.core.nth.call(null,inst_75367,(3),null);
var inst_75414__$1 = cljs.core.__destructure_map.call(null,inst_75413__$1);
var inst_75415 = cljs.core.random_uuid.call(null);
var inst_75416 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75415);
var inst_75417 = cljs.core.get.call(null,inst_75414__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_75416);
var inst_75418 = cljs.core.get.call(null,inst_75414__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_75509__$1 = (function (){var statearr_75578 = state_75509;
(statearr_75578[(12)] = inst_75414__$1);

(statearr_75578[(13)] = inst_75418);

(statearr_75578[(14)] = inst_75411);

(statearr_75578[(15)] = inst_75417);

(statearr_75578[(16)] = inst_75410);

(statearr_75578[(17)] = inst_75412__$1);

(statearr_75578[(18)] = inst_75413__$1);

(statearr_75578[(19)] = inst_75409);

return statearr_75578;
})();
if(cljs.core.truth_(inst_75412__$1)){
var statearr_75579_75637 = state_75509__$1;
(statearr_75579_75637[(1)] = (21));

} else {
var statearr_75580_75638 = state_75509__$1;
(statearr_75580_75638[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_75581 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75581[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_75581[(1)] = (1));

return statearr_75581;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_75509){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75582){var ex__2749__auto__ = e75582;
var statearr_75583_75639 = state_75509;
(statearr_75583_75639[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75509[(4)]))){
var statearr_75584_75640 = state_75509;
(statearr_75584_75640[(1)] = cljs.core.first.call(null,(state_75509[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75641 = state_75509;
state_75509 = G__75641;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_75509){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_75509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75585 = f__2769__auto__.call(null);
(statearr_75585[(6)] = c__2768__auto__);

return statearr_75585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75679){
var state_val_75680 = (state_75679[(1)]);
if((state_val_75680 === (7))){
var inst_75650 = (state_75679[(7)]);
var state_75679__$1 = state_75679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75679__$1,(9),inst_75650);
} else {
if((state_val_75680 === (1))){
var inst_75642 = (1);
var state_75679__$1 = (function (){var statearr_75681 = state_75679;
(statearr_75681[(8)] = inst_75642);

return statearr_75681;
})();
var statearr_75682_75705 = state_75679__$1;
(statearr_75682_75705[(2)] = null);

(statearr_75682_75705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (4))){
var inst_75647 = (state_75679[(2)]);
var inst_75648 = fluree.db.connection.get_socket.call(null,conn);
var state_75679__$1 = (function (){var statearr_75683 = state_75679;
(statearr_75683[(9)] = inst_75647);

return statearr_75683;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75679__$1,(5),inst_75648);
} else {
if((state_val_75680 === (15))){
var inst_75675 = (state_75679[(2)]);
var state_75679__$1 = state_75679;
var statearr_75684_75706 = state_75679__$1;
(statearr_75684_75706[(2)] = inst_75675);

(statearr_75684_75706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (13))){
var inst_75657 = (state_75679[(10)]);
var inst_75642 = (state_75679[(8)]);
var inst_75665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75666 = [inst_75657,"Cannot establish connection to a healthy server, backing off:",inst_75642,"s."];
var inst_75667 = (new cljs.core.PersistentVector(null,4,(5),inst_75665,inst_75666,null));
var inst_75668 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75667);
var inst_75669 = ((2) * inst_75642);
var inst_75670 = ((60) * (2));
var inst_75671 = ((inst_75669 < inst_75670) ? inst_75669 : inst_75670);
var inst_75642__$1 = inst_75671;
var state_75679__$1 = (function (){var statearr_75685 = state_75679;
(statearr_75685[(11)] = inst_75668);

(statearr_75685[(8)] = inst_75642__$1);

return statearr_75685;
})();
var statearr_75686_75707 = state_75679__$1;
(statearr_75686_75707[(2)] = null);

(statearr_75686_75707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (6))){
var inst_75650 = (state_75679[(7)]);
var state_75679__$1 = state_75679;
var statearr_75687_75708 = state_75679__$1;
(statearr_75687_75708[(2)] = inst_75650);

(statearr_75687_75708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (3))){
var inst_75677 = (state_75679[(2)]);
var state_75679__$1 = state_75679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75679__$1,inst_75677);
} else {
if((state_val_75680 === (12))){
var inst_75663 = (state_75679[(2)]);
var state_75679__$1 = state_75679;
if(cljs.core.truth_(inst_75663)){
var statearr_75688_75709 = state_75679__$1;
(statearr_75688_75709[(1)] = (13));

} else {
var statearr_75689_75710 = state_75679__$1;
(statearr_75689_75710[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (2))){
var inst_75642 = (state_75679[(8)]);
var inst_75644 = (inst_75642 * (1000));
var inst_75645 = cljs.core.async.timeout.call(null,inst_75644);
var state_75679__$1 = state_75679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75679__$1,(4),inst_75645);
} else {
if((state_val_75680 === (11))){
var inst_75657 = (state_75679[(10)]);
var inst_75661 = fluree.db.util.core.exception_QMARK_.call(null,inst_75657);
var state_75679__$1 = state_75679;
var statearr_75690_75711 = state_75679__$1;
(statearr_75690_75711[(2)] = inst_75661);

(statearr_75690_75711[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (9))){
var inst_75655 = (state_75679[(2)]);
var state_75679__$1 = state_75679;
var statearr_75691_75712 = state_75679__$1;
(statearr_75691_75712[(2)] = inst_75655);

(statearr_75691_75712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (5))){
var inst_75650 = (state_75679[(7)]);
var inst_75650__$1 = (state_75679[(2)]);
var inst_75651 = fluree.db.util.core.exception_QMARK_.call(null,inst_75650__$1);
var state_75679__$1 = (function (){var statearr_75692 = state_75679;
(statearr_75692[(7)] = inst_75650__$1);

return statearr_75692;
})();
if(inst_75651){
var statearr_75693_75713 = state_75679__$1;
(statearr_75693_75713[(1)] = (6));

} else {
var statearr_75694_75714 = state_75679__$1;
(statearr_75694_75714[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (14))){
var inst_75657 = (state_75679[(10)]);
var state_75679__$1 = state_75679;
var statearr_75695_75715 = state_75679__$1;
(statearr_75695_75715[(2)] = inst_75657);

(statearr_75695_75715[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (10))){
var inst_75658 = (state_75679[(12)]);
var state_75679__$1 = state_75679;
var statearr_75696_75716 = state_75679__$1;
(statearr_75696_75716[(2)] = inst_75658);

(statearr_75696_75716[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75680 === (8))){
var inst_75657 = (state_75679[(10)]);
var inst_75658 = (state_75679[(12)]);
var inst_75657__$1 = (state_75679[(2)]);
var inst_75658__$1 = (inst_75657__$1 == null);
var state_75679__$1 = (function (){var statearr_75697 = state_75679;
(statearr_75697[(10)] = inst_75657__$1);

(statearr_75697[(12)] = inst_75658__$1);

return statearr_75697;
})();
if(cljs.core.truth_(inst_75658__$1)){
var statearr_75698_75717 = state_75679__$1;
(statearr_75698_75717[(1)] = (10));

} else {
var statearr_75699_75718 = state_75679__$1;
(statearr_75699_75718[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0 = (function (){
var statearr_75700 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75700[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__);

(statearr_75700[(1)] = (1));

return statearr_75700;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1 = (function (state_75679){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75701){var ex__2749__auto__ = e75701;
var statearr_75702_75719 = state_75679;
(statearr_75702_75719[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75679[(4)]))){
var statearr_75703_75720 = state_75679;
(statearr_75703_75720[(1)] = cljs.core.first.call(null,(state_75679[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75721 = state_75679;
state_75679 = G__75721;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = function(state_75679){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1.call(this,state_75679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75704 = f__2769__auto__.call(null);
(statearr_75704[(6)] = c__2768__auto__);

return statearr_75704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__75722){
var map__75723 = p__75722;
var map__75723__$1 = cljs.core.__destructure_map.call(null,map__75723);
var conn = map__75723__$1;
var sub_chan = cljs.core.get.call(null,map__75723__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.call(null,map__75723__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.call(null,map__75723__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.call(null,map__75723__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75834){
var state_val_75835 = (state_75834[(1)]);
if((state_val_75835 === (7))){
var inst_75830 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75836_75892 = state_75834__$1;
(statearr_75836_75892[(2)] = inst_75830);

(statearr_75836_75892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (20))){
var inst_75781 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75837_75893 = state_75834__$1;
(statearr_75837_75893[(2)] = inst_75781);

(statearr_75837_75893[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (27))){
var inst_75799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75800 = ["Connection closed."];
var inst_75801 = (new cljs.core.PersistentVector(null,1,(5),inst_75799,inst_75800,null));
var inst_75802 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_75801);
var state_75834__$1 = state_75834;
var statearr_75838_75894 = state_75834__$1;
(statearr_75838_75894[(2)] = inst_75802);

(statearr_75838_75894[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (1))){
var inst_75724 = (0);
var state_75834__$1 = (function (){var statearr_75839 = state_75834;
(statearr_75839[(7)] = inst_75724);

return statearr_75839;
})();
var statearr_75840_75895 = state_75834__$1;
(statearr_75840_75895[(2)] = null);

(statearr_75840_75895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (24))){
var inst_75768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75769 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_75770 = [keep_alive_fn];
var inst_75771 = cljs.core.PersistentHashMap.fromArrays(inst_75769,inst_75770);
var inst_75772 = ["Unsupported callback registered",inst_75771];
var inst_75773 = (new cljs.core.PersistentVector(null,2,(5),inst_75768,inst_75772,null));
var inst_75774 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_75773);
var state_75834__$1 = state_75834;
var statearr_75841_75896 = state_75834__$1;
(statearr_75841_75896[(2)] = inst_75774);

(statearr_75841_75896[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (4))){
var inst_75729 = (state_75834[(8)]);
var inst_75734 = (state_75834[(2)]);
var inst_75735 = cljs.core.nth.call(null,inst_75734,(0),null);
var inst_75736 = cljs.core.nth.call(null,inst_75734,(1),null);
var inst_75737 = cljs.core._EQ_.call(null,inst_75736,inst_75729);
var state_75834__$1 = (function (){var statearr_75842 = state_75834;
(statearr_75842[(9)] = inst_75735);

return statearr_75842;
})();
if(inst_75737){
var statearr_75843_75897 = state_75834__$1;
(statearr_75843_75897[(1)] = (5));

} else {
var statearr_75844_75898 = state_75834__$1;
(statearr_75844_75898[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (15))){
var inst_75754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75755 = ["No keep-alive callback is registered"];
var inst_75756 = (new cljs.core.PersistentVector(null,1,(5),inst_75754,inst_75755,null));
var inst_75757 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_75756);
var state_75834__$1 = state_75834;
var statearr_75845_75899 = state_75834__$1;
(statearr_75845_75899[(2)] = inst_75757);

(statearr_75845_75899[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (21))){
var inst_75765 = cljs.core.eval.call(null,keep_alive_fn);
var state_75834__$1 = state_75834;
var statearr_75846_75900 = state_75834__$1;
(statearr_75846_75900[(2)] = inst_75765);

(statearr_75846_75900[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (31))){
var state_75834__$1 = state_75834;
var statearr_75847_75901 = state_75834__$1;
(statearr_75847_75901[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (32))){
var inst_75826 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75849_75902 = state_75834__$1;
(statearr_75849_75902[(2)] = inst_75826);

(statearr_75849_75902[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (33))){
var inst_75735 = (state_75834[(9)]);
var inst_75813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75814 = fluree.db.util.json.parse.call(null,inst_75735);
var inst_75815 = cljs.core.pr_str.call(null,inst_75814);
var inst_75816 = ["Received message:",inst_75815];
var inst_75817 = (new cljs.core.PersistentVector(null,2,(5),inst_75813,inst_75816,null));
var inst_75818 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_75817);
var inst_75819 = fluree.db.util.json.parse.call(null,inst_75735);
var inst_75820 = fluree.db.conn_events.process_events.call(null,conn,inst_75819);
var inst_75724 = (0);
var state_75834__$1 = (function (){var statearr_75850 = state_75834;
(statearr_75850[(10)] = inst_75820);

(statearr_75850[(11)] = inst_75818);

(statearr_75850[(7)] = inst_75724);

return statearr_75850;
})();
var statearr_75851_75903 = state_75834__$1;
(statearr_75851_75903[(2)] = null);

(statearr_75851_75903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (13))){
var inst_75789 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75852_75904 = state_75834__$1;
(statearr_75852_75904[(2)] = inst_75789);

(statearr_75852_75904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (22))){
var state_75834__$1 = state_75834;
var statearr_75853_75905 = state_75834__$1;
(statearr_75853_75905[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (29))){
var inst_75828 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75855_75906 = state_75834__$1;
(statearr_75855_75906[(2)] = inst_75828);

(statearr_75855_75906[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (6))){
var inst_75735 = (state_75834[(9)]);
var inst_75797 = (inst_75735 == null);
var state_75834__$1 = state_75834;
if(cljs.core.truth_(inst_75797)){
var statearr_75856_75907 = state_75834__$1;
(statearr_75856_75907[(1)] = (27));

} else {
var statearr_75857_75908 = state_75834__$1;
(statearr_75857_75908[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (28))){
var inst_75735 = (state_75834[(9)]);
var inst_75804 = fluree.db.util.core.exception_QMARK_.call(null,inst_75735);
var state_75834__$1 = state_75834;
if(inst_75804){
var statearr_75858_75909 = state_75834__$1;
(statearr_75858_75909[(1)] = (30));

} else {
var statearr_75859_75910 = state_75834__$1;
(statearr_75859_75910[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (25))){
var state_75834__$1 = state_75834;
var statearr_75860_75911 = state_75834__$1;
(statearr_75860_75911[(2)] = null);

(statearr_75860_75911[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (34))){
var state_75834__$1 = state_75834;
var statearr_75861_75912 = state_75834__$1;
(statearr_75861_75912[(2)] = null);

(statearr_75861_75912[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (17))){
var inst_75783 = (state_75834[(2)]);
var inst_75784 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75785 = fluree.db.connection.close_websocket.call(null,inst_75784);
var inst_75786 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_75787 = fluree.db.session.close_all_sessions.call(null,inst_75786);
var state_75834__$1 = (function (){var statearr_75862 = state_75834;
(statearr_75862[(12)] = inst_75783);

(statearr_75862[(13)] = inst_75785);

return statearr_75862;
})();
var statearr_75863_75913 = state_75834__$1;
(statearr_75863_75913[(2)] = inst_75787);

(statearr_75863_75913[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (3))){
var inst_75832 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75834__$1,inst_75832);
} else {
if((state_val_75835 === (12))){
var inst_75747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75748 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_75749 = (new cljs.core.PersistentVector(null,1,(5),inst_75747,inst_75748,null));
var inst_75750 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_75749);
var inst_75751 = keep_alive_fn;
var inst_75752 = (keep_alive_fn == null);
var state_75834__$1 = (function (){var statearr_75864 = state_75834;
(statearr_75864[(14)] = inst_75750);

(statearr_75864[(15)] = inst_75751);

return statearr_75864;
})();
if(cljs.core.truth_(inst_75752)){
var statearr_75865_75914 = state_75834__$1;
(statearr_75865_75914[(1)] = (15));

} else {
var statearr_75866_75915 = state_75834__$1;
(statearr_75866_75915[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (2))){
var inst_75729 = (state_75834[(8)]);
var inst_75729__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_75730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75731 = [sub_chan,inst_75729__$1];
var inst_75732 = (new cljs.core.PersistentVector(null,2,(5),inst_75730,inst_75731,null));
var state_75834__$1 = (function (){var statearr_75867 = state_75834;
(statearr_75867[(8)] = inst_75729__$1);

return statearr_75867;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_75834__$1,(4),inst_75732);
} else {
if((state_val_75835 === (23))){
var inst_75779 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75868_75916 = state_75834__$1;
(statearr_75868_75916[(2)] = inst_75779);

(statearr_75868_75916[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (35))){
var inst_75824 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75869_75917 = state_75834__$1;
(statearr_75869_75917[(2)] = inst_75824);

(statearr_75869_75917[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (19))){
var inst_75763 = typeof keep_alive_fn === 'string';
var state_75834__$1 = state_75834;
if(cljs.core.truth_(inst_75763)){
var statearr_75870_75918 = state_75834__$1;
(statearr_75870_75918[(1)] = (21));

} else {
var statearr_75871_75919 = state_75834__$1;
(statearr_75871_75919[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (11))){
var inst_75742 = fluree.db.connection.reconnect_conn.call(null,conn);
var state_75834__$1 = state_75834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75834__$1,(14),inst_75742);
} else {
if((state_val_75835 === (9))){
var inst_75724 = (state_75834[(7)]);
var inst_75791 = fluree.db.connection.ping_transactor.call(null,req_chan);
var inst_75792 = (inst_75724 + (1));
var inst_75724__$1 = inst_75792;
var state_75834__$1 = (function (){var statearr_75872 = state_75834;
(statearr_75872[(7)] = inst_75724__$1);

(statearr_75872[(16)] = inst_75791);

return statearr_75872;
})();
var statearr_75873_75920 = state_75834__$1;
(statearr_75873_75920[(2)] = null);

(statearr_75873_75920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (5))){
var inst_75724 = (state_75834[(7)]);
var inst_75739 = cljs.core._EQ_.call(null,(2),inst_75724);
var state_75834__$1 = state_75834;
if(inst_75739){
var statearr_75874_75921 = state_75834__$1;
(statearr_75874_75921[(1)] = (8));

} else {
var statearr_75875_75922 = state_75834__$1;
(statearr_75875_75922[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (14))){
var inst_75744 = (state_75834[(2)]);
var inst_75724 = (0);
var state_75834__$1 = (function (){var statearr_75876 = state_75834;
(statearr_75876[(7)] = inst_75724);

(statearr_75876[(17)] = inst_75744);

return statearr_75876;
})();
var statearr_75877_75923 = state_75834__$1;
(statearr_75877_75923[(2)] = null);

(statearr_75877_75923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (26))){
var inst_75777 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75878_75924 = state_75834__$1;
(statearr_75878_75924[(2)] = inst_75777);

(statearr_75878_75924[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (16))){
var inst_75759 = cljs.core.fn_QMARK_.call(null,keep_alive_fn);
var state_75834__$1 = state_75834;
if(inst_75759){
var statearr_75879_75925 = state_75834__$1;
(statearr_75879_75925[(1)] = (18));

} else {
var statearr_75880_75926 = state_75834__$1;
(statearr_75880_75926[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (30))){
var inst_75735 = (state_75834[(9)]);
var inst_75806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75807 = [inst_75735];
var inst_75808 = (new cljs.core.PersistentVector(null,1,(5),inst_75806,inst_75807,null));
var inst_75809 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75808);
var inst_75724 = (0);
var state_75834__$1 = (function (){var statearr_75881 = state_75834;
(statearr_75881[(18)] = inst_75809);

(statearr_75881[(7)] = inst_75724);

return statearr_75881;
})();
var statearr_75882_75927 = state_75834__$1;
(statearr_75882_75927[(2)] = null);

(statearr_75882_75927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (10))){
var inst_75795 = (state_75834[(2)]);
var state_75834__$1 = state_75834;
var statearr_75883_75928 = state_75834__$1;
(statearr_75883_75928[(2)] = inst_75795);

(statearr_75883_75928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (18))){
var inst_75761 = keep_alive_fn.call(null);
var state_75834__$1 = state_75834;
var statearr_75884_75929 = state_75834__$1;
(statearr_75884_75929[(2)] = inst_75761);

(statearr_75884_75929[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75835 === (8))){
var state_75834__$1 = state_75834;
if(cljs.core.truth_(keep_alive)){
var statearr_75885_75930 = state_75834__$1;
(statearr_75885_75930[(1)] = (11));

} else {
var statearr_75886_75931 = state_75834__$1;
(statearr_75886_75931[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_75887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75887[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_75887[(1)] = (1));

return statearr_75887;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_75834){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e75888){var ex__2749__auto__ = e75888;
var statearr_75889_75932 = state_75834;
(statearr_75889_75932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75834[(4)]))){
var statearr_75890_75933 = state_75834;
(statearr_75890_75933[(1)] = cljs.core.first.call(null,(state_75834[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75934 = state_75834;
state_75834 = G__75934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_75834){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_75834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_75891 = f__2769__auto__.call(null);
(statearr_75891[(6)] = c__2768__auto__);

return statearr_75891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__75936 = arguments.length;
switch (G__75936) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__75937 = opts;
var map__75937__$1 = cljs.core.__destructure_map.call(null,map__75937);
var private$ = cljs.core.get.call(null,map__75937__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__75937__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_75989){
var state_val_75990 = (state_75989[(1)]);
if((state_val_75990 === (7))){
var inst_75947 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_75948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75949 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_75950 = (new cljs.core.PersistentVector(null,2,(5),inst_75948,inst_75949,null));
var inst_75951 = cljs.core.get_in.call(null,inst_75947,inst_75950);
var state_75989__$1 = state_75989;
var statearr_75991_76022 = state_75989__$1;
(statearr_75991_76022[(2)] = inst_75951);

(statearr_75991_76022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (1))){
var state_75989__$1 = state_75989;
var statearr_75992_76023 = state_75989__$1;
(statearr_75992_76023[(2)] = null);

(statearr_75992_76023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (4))){
var inst_75938 = (state_75989[(2)]);
var state_75989__$1 = state_75989;
var statearr_75993_76024 = state_75989__$1;
(statearr_75993_76024[(2)] = inst_75938);

(statearr_75993_76024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (15))){
var inst_75958 = (state_75989[(7)]);
var inst_75977 = (state_75989[(2)]);
var inst_75978 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_75979 = [(5000),inst_75977,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_75980 = cljs.core.PersistentHashMap.fromArrays(inst_75978,inst_75979);
var inst_75981 = fluree.db.util.xhttp.get.call(null,inst_75958,inst_75980);
var state_75989__$1 = state_75989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75989__$1,(16),inst_75981);
} else {
if((state_val_75990 === (13))){
var inst_75968 = (state_75989[(8)]);
var inst_75958 = (state_75989[(7)]);
var inst_75970 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_75971 = [inst_75968];
var inst_75972 = cljs.core.PersistentHashMap.fromArrays(inst_75970,inst_75971);
var inst_75973 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_75958,inst_75972,private$);
var inst_75974 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_75973);
var state_75989__$1 = state_75989;
var statearr_75994_76025 = state_75989__$1;
(statearr_75994_76025[(2)] = inst_75974);

(statearr_75994_76025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (6))){
var inst_75944 = (state_75989[(9)]);
var state_75989__$1 = state_75989;
var statearr_75995_76026 = state_75989__$1;
(statearr_75995_76026[(2)] = inst_75944);

(statearr_75995_76026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (3))){
var inst_75987 = (state_75989[(2)]);
var state_75989__$1 = state_75989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75989__$1,inst_75987);
} else {
if((state_val_75990 === (12))){
var inst_75968 = (state_75989[(2)]);
var state_75989__$1 = (function (){var statearr_75996 = state_75989;
(statearr_75996[(8)] = inst_75968);

return statearr_75996;
})();
if(cljs.core.truth_(private$)){
var statearr_75997_76027 = state_75989__$1;
(statearr_75997_76027[(1)] = (13));

} else {
var statearr_75998_76028 = state_75989__$1;
(statearr_75998_76028[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (2))){
var inst_75944 = (state_75989[(9)]);
var _ = (function (){var statearr_75999 = state_75989;
(statearr_75999[(4)] = cljs.core.cons.call(null,(5),(state_75989[(4)])));

return statearr_75999;
})();
var inst_75944__$1 = jwt;
var state_75989__$1 = (function (){var statearr_76000 = state_75989;
(statearr_76000[(9)] = inst_75944__$1);

return statearr_76000;
})();
if(cljs.core.truth_(inst_75944__$1)){
var statearr_76001_76029 = state_75989__$1;
(statearr_76001_76029[(1)] = (6));

} else {
var statearr_76002_76030 = state_75989__$1;
(statearr_76002_76030[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (11))){
var inst_75962 = (state_75989[(10)]);
var state_75989__$1 = state_75989;
var statearr_76004_76031 = state_75989__$1;
(statearr_76004_76031[(2)] = inst_75962);

(statearr_76004_76031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (9))){
var inst_75953 = (state_75989[(11)]);
var inst_75954 = (state_75989[(12)]);
var inst_75957 = (state_75989[(2)]);
var inst_75958 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75957),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75954)].join('');
var inst_75960 = ["Accept"];
var inst_75961 = ["application/json"];
var inst_75962 = cljs.core.PersistentHashMap.fromArrays(inst_75960,inst_75961);
var state_75989__$1 = (function (){var statearr_76005 = state_75989;
(statearr_76005[(7)] = inst_75958);

(statearr_76005[(10)] = inst_75962);

return statearr_76005;
})();
if(cljs.core.truth_(inst_75953)){
var statearr_76006_76032 = state_75989__$1;
(statearr_76006_76032[(1)] = (10));

} else {
var statearr_76007_76033 = state_75989__$1;
(statearr_76007_76033[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (5))){
var _ = (function (){var statearr_76008 = state_75989;
(statearr_76008[(4)] = cljs.core.rest.call(null,(state_75989[(4)])));

return statearr_76008;
})();
var state_75989__$1 = state_75989;
var ex76003 = (state_75989__$1[(2)]);
var statearr_76009_76034 = state_75989__$1;
(statearr_76009_76034[(5)] = ex76003);


if((ex76003 instanceof Error)){
var statearr_76010_76035 = state_75989__$1;
(statearr_76010_76035[(1)] = (4));

(statearr_76010_76035[(5)] = null);

} else {
throw ex76003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (14))){
var inst_75968 = (state_75989[(8)]);
var state_75989__$1 = state_75989;
var statearr_76011_76036 = state_75989__$1;
(statearr_76011_76036[(2)] = inst_75968);

(statearr_76011_76036[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (16))){
var inst_75983 = (state_75989[(2)]);
var inst_75984 = fluree.db.util.async.throw_err.call(null,inst_75983);
var _ = (function (){var statearr_76012 = state_75989;
(statearr_76012[(4)] = cljs.core.rest.call(null,(state_75989[(4)])));

return statearr_76012;
})();
var state_75989__$1 = state_75989;
var statearr_76013_76037 = state_75989__$1;
(statearr_76013_76037[(2)] = inst_75984);

(statearr_76013_76037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (10))){
var inst_75953 = (state_75989[(11)]);
var inst_75962 = (state_75989[(10)]);
var inst_75964 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75953)].join('');
var inst_75965 = cljs.core.assoc.call(null,inst_75962,"Authorization",inst_75964);
var state_75989__$1 = state_75989;
var statearr_76014_76038 = state_75989__$1;
(statearr_76014_76038[(2)] = inst_75965);

(statearr_76014_76038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75990 === (8))){
var inst_75953 = (state_75989[(2)]);
var inst_75954 = clojure.string.replace.call(null,k,"_","/");
var inst_75955 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_75989__$1 = (function (){var statearr_76015 = state_75989;
(statearr_76015[(11)] = inst_75953);

(statearr_76015[(12)] = inst_75954);

return statearr_76015;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75989__$1,(9),inst_75955);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_76016 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76016[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_76016[(1)] = (1));

return statearr_76016;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_75989){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_75989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76017){var ex__2749__auto__ = e76017;
var statearr_76018_76039 = state_75989;
(statearr_76018_76039[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_75989[(4)]))){
var statearr_76019_76040 = state_75989;
(statearr_76019_76040[(1)] = cljs.core.first.call(null,(state_75989[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76041 = state_75989;
state_75989 = G__76041;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_75989){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_75989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76020 = f__2769__auto__.call(null);
(statearr_76020[(6)] = c__2768__auto__);

return statearr_76020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___76066 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___76066)){
var v_76067 = temp__5802__auto___76066;
cljs.core.async.put_BANG_.call(null,out,v_76067);
} else {
var c__2768__auto___76068 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76053){
var state_val_76054 = (state_76053[(1)]);
if((state_val_76054 === (1))){
var inst_76042 = value_fn.call(null,k);
var state_76053__$1 = state_76053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76053__$1,(2),inst_76042);
} else {
if((state_val_76054 === (2))){
var inst_76044 = (state_76053[(7)]);
var inst_76044__$1 = (state_76053[(2)]);
var inst_76045 = fluree.db.util.core.exception_QMARK_.call(null,inst_76044__$1);
var state_76053__$1 = (function (){var statearr_76055 = state_76053;
(statearr_76055[(7)] = inst_76044__$1);

return statearr_76055;
})();
if(inst_76045){
var statearr_76056_76069 = state_76053__$1;
(statearr_76056_76069[(1)] = (3));

} else {
var statearr_76057_76070 = state_76053__$1;
(statearr_76057_76070[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76054 === (3))){
var state_76053__$1 = state_76053;
var statearr_76058_76071 = state_76053__$1;
(statearr_76058_76071[(2)] = null);

(statearr_76058_76071[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76054 === (4))){
var inst_76044 = (state_76053[(7)]);
var inst_76048 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_76044);
var state_76053__$1 = state_76053;
var statearr_76059_76072 = state_76053__$1;
(statearr_76059_76072[(2)] = inst_76048);

(statearr_76059_76072[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76054 === (5))){
var inst_76044 = (state_76053[(7)]);
var inst_76050 = (state_76053[(2)]);
var inst_76051 = cljs.core.async.put_BANG_.call(null,out,inst_76044);
var state_76053__$1 = (function (){var statearr_76060 = state_76053;
(statearr_76060[(8)] = inst_76050);

return statearr_76060;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76053__$1,inst_76051);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_76061 = [null,null,null,null,null,null,null,null,null];
(statearr_76061[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__);

(statearr_76061[(1)] = (1));

return statearr_76061;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1 = (function (state_76053){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76062){var ex__2749__auto__ = e76062;
var statearr_76063_76073 = state_76053;
(statearr_76063_76073[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76053[(4)]))){
var statearr_76064_76074 = state_76053;
(statearr_76064_76074[(1)] = cljs.core.first.call(null,(state_76053[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76075 = state_76053;
state_76053 = G__76075;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = function(state_76053){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1.call(this,state_76053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76065 = f__2769__auto__.call(null);
(statearr_76065[(6)] = c__2768__auto___76068);

return statearr_76065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__76076_SHARP_){
if(cljs.core.truth_(p1__76076_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__76077_SHARP_){
var or__5045__auto__ = p1__76077_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e76078){var e = e76078;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__76079 = opts;
var map__76079__$1 = cljs.core.__destructure_map.call(null,map__76079);
var sub_chan = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__76079__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___76123 = arguments.length;
var i__5770__auto___76124 = (0);
while(true){
if((i__5770__auto___76124 < len__5769__auto___76123)){
args__5775__auto__.push((arguments[i__5770__auto___76124]));

var G__76125 = (i__5770__auto___76124 + (1));
i__5770__auto___76124 = G__76125;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__76082){
var vec__76083 = p__76082;
var opts = cljs.core.nth.call(null,vec__76083,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___76126 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76106){
var state_val_76107 = (state_76106[(1)]);
if((state_val_76107 === (1))){
var inst_76086 = fluree.db.connection.get_socket.call(null,conn);
var state_76106__$1 = state_76106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76106__$1,(2),inst_76086);
} else {
if((state_val_76107 === (2))){
var inst_76088 = (state_76106[(7)]);
var inst_76089 = (state_76106[(8)]);
var inst_76088__$1 = (state_76106[(2)]);
var inst_76089__$1 = (inst_76088__$1 == null);
var state_76106__$1 = (function (){var statearr_76108 = state_76106;
(statearr_76108[(7)] = inst_76088__$1);

(statearr_76108[(8)] = inst_76089__$1);

return statearr_76108;
})();
if(cljs.core.truth_(inst_76089__$1)){
var statearr_76109_76127 = state_76106__$1;
(statearr_76109_76127[(1)] = (3));

} else {
var statearr_76110_76128 = state_76106__$1;
(statearr_76110_76128[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76107 === (3))){
var inst_76089 = (state_76106[(8)]);
var state_76106__$1 = state_76106;
var statearr_76111_76129 = state_76106__$1;
(statearr_76111_76129[(2)] = inst_76089);

(statearr_76111_76129[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76107 === (4))){
var inst_76088 = (state_76106[(7)]);
var inst_76092 = fluree.db.util.core.exception_QMARK_.call(null,inst_76088);
var state_76106__$1 = state_76106;
var statearr_76112_76130 = state_76106__$1;
(statearr_76112_76130[(2)] = inst_76092);

(statearr_76112_76130[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76107 === (5))){
var inst_76094 = (state_76106[(2)]);
var state_76106__$1 = state_76106;
if(cljs.core.truth_(inst_76094)){
var statearr_76113_76131 = state_76106__$1;
(statearr_76113_76131[(1)] = (6));

} else {
var statearr_76114_76132 = state_76106__$1;
(statearr_76114_76132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76107 === (6))){
var inst_76088 = (state_76106[(7)]);
var inst_76096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76097 = [inst_76088,"Cannot establish connection to a healthy server, disconnecting."];
var inst_76098 = (new cljs.core.PersistentVector(null,2,(5),inst_76096,inst_76097,null));
var inst_76099 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76098);
var inst_76100 = cljs.core.async.close_BANG_.call(null,conn);
var state_76106__$1 = (function (){var statearr_76115 = state_76106;
(statearr_76115[(9)] = inst_76099);

return statearr_76115;
})();
var statearr_76116_76133 = state_76106__$1;
(statearr_76116_76133[(2)] = inst_76100);

(statearr_76116_76133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76107 === (7))){
var inst_76102 = fluree.db.connection.msg_consumer.call(null,conn);
var state_76106__$1 = state_76106;
var statearr_76117_76134 = state_76106__$1;
(statearr_76117_76134[(2)] = inst_76102);

(statearr_76117_76134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76107 === (8))){
var inst_76104 = (state_76106[(2)]);
var state_76106__$1 = state_76106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76106__$1,inst_76104);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_76118 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76118[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_76118[(1)] = (1));

return statearr_76118;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_76106){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76119){var ex__2749__auto__ = e76119;
var statearr_76120_76135 = state_76106;
(statearr_76120_76135[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76106[(4)]))){
var statearr_76121_76136 = state_76106;
(statearr_76121_76136[(1)] = cljs.core.first.call(null,(state_76106[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76137 = state_76106;
state_76106 = G__76137;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_76106){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_76106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76122 = f__2769__auto__.call(null);
(statearr_76122[(6)] = c__2768__auto___76126);

return statearr_76122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq76080){
var G__76081 = cljs.core.first.call(null,seq76080);
var seq76080__$1 = cljs.core.next.call(null,seq76080);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76081,seq76080__$1);
}));

