// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___76764 = arguments.length;
var i__5770__auto___76765 = (0);
while(true){
if((i__5770__auto___76765 < len__5769__auto___76764)){
args__5775__auto__.push((arguments[i__5770__auto___76765]));

var G__76766 = (i__5770__auto___76765 + (1));
i__5770__auto___76765 = G__76766;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__76693){
var vec__76694 = p__76693;
var opts = cljs.core.nth.call(null,vec__76694,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___76767 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76741){
var state_val_76742 = (state_76741[(1)]);
if((state_val_76742 === (7))){
var inst_76718 = (state_76741[(7)]);
var inst_76727 = (state_76741[(8)]);
var inst_76729 = fluree.db.time_travel.as_of_block.call(null,inst_76727,inst_76718);
var state_76741__$1 = state_76741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76741__$1,(10),inst_76729);
} else {
if((state_val_76742 === (1))){
var state_76741__$1 = state_76741;
var statearr_76743_76768 = state_76741__$1;
(statearr_76743_76768[(2)] = null);

(statearr_76743_76768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76742 === (4))){
var inst_76697 = (state_76741[(2)]);
var inst_76698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76699 = [inst_76697];
var inst_76700 = (new cljs.core.PersistentVector(null,1,(5),inst_76698,inst_76699,null));
var inst_76701 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76700);
var inst_76702 = cljs.core.async.put_BANG_.call(null,pc,inst_76697);
var inst_76703 = cljs.core.async.close_BANG_.call(null,pc);
var state_76741__$1 = (function (){var statearr_76744 = state_76741;
(statearr_76744[(9)] = inst_76702);

(statearr_76744[(10)] = inst_76701);

return statearr_76744;
})();
var statearr_76745_76769 = state_76741__$1;
(statearr_76745_76769[(2)] = inst_76703);

(statearr_76745_76769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76742 === (6))){
var inst_76721 = (state_76741[(11)]);
var inst_76718 = (state_76741[(7)]);
var inst_76722 = (state_76741[(12)]);
var inst_76725 = (state_76741[(2)]);
var inst_76726 = fluree.db.util.async.throw_err.call(null,inst_76725);
var inst_76727 = cljs.core.assoc.call(null,inst_76726,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_76721,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_76722);
var state_76741__$1 = (function (){var statearr_76746 = state_76741;
(statearr_76746[(8)] = inst_76727);

return statearr_76746;
})();
if(cljs.core.truth_(inst_76718)){
var statearr_76747_76770 = state_76741__$1;
(statearr_76747_76770[(1)] = (7));

} else {
var statearr_76748_76771 = state_76741__$1;
(statearr_76748_76771[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76742 === (3))){
var inst_76739 = (state_76741[(2)]);
var state_76741__$1 = state_76741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76741__$1,inst_76739);
} else {
if((state_val_76742 === (2))){
var _ = (function (){var statearr_76750 = state_76741;
(statearr_76750[(4)] = cljs.core.cons.call(null,(5),(state_76741[(4)])));

return statearr_76750;
})();
var inst_76713 = opts;
var inst_76714 = cljs.core.__destructure_map.call(null,inst_76713);
var inst_76715 = cljs.core.get.call(null,inst_76714,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_76716 = cljs.core.get.call(null,inst_76714,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_76717 = cljs.core.get.call(null,inst_76714,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_76718 = cljs.core.get.call(null,inst_76714,new cljs.core.Keyword(null,"block","block",664686210));
var inst_76719 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_76720 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_76721 = cljs.core.nth.call(null,inst_76720,(0),null);
var inst_76722 = cljs.core.nth.call(null,inst_76720,(1),null);
var inst_76723 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_76741__$1 = (function (){var statearr_76751 = state_76741;
(statearr_76751[(13)] = inst_76715);

(statearr_76751[(14)] = inst_76717);

(statearr_76751[(11)] = inst_76721);

(statearr_76751[(15)] = inst_76716);

(statearr_76751[(7)] = inst_76718);

(statearr_76751[(16)] = inst_76719);

(statearr_76751[(12)] = inst_76722);

return statearr_76751;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76741__$1,(6),inst_76723);
} else {
if((state_val_76742 === (9))){
var inst_76735 = (state_76741[(2)]);
var inst_76736 = cljs.core.async.put_BANG_.call(null,pc,inst_76735);
var _ = (function (){var statearr_76752 = state_76741;
(statearr_76752[(4)] = cljs.core.rest.call(null,(state_76741[(4)])));

return statearr_76752;
})();
var state_76741__$1 = state_76741;
var statearr_76753_76772 = state_76741__$1;
(statearr_76753_76772[(2)] = inst_76736);

(statearr_76753_76772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76742 === (5))){
var _ = (function (){var statearr_76754 = state_76741;
(statearr_76754[(4)] = cljs.core.rest.call(null,(state_76741[(4)])));

return statearr_76754;
})();
var state_76741__$1 = state_76741;
var ex76749 = (state_76741__$1[(2)]);
var statearr_76755_76773 = state_76741__$1;
(statearr_76755_76773[(5)] = ex76749);


var statearr_76756_76774 = state_76741__$1;
(statearr_76756_76774[(1)] = (4));

(statearr_76756_76774[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76742 === (10))){
var inst_76731 = (state_76741[(2)]);
var inst_76732 = fluree.db.util.async.throw_err.call(null,inst_76731);
var state_76741__$1 = state_76741;
var statearr_76757_76775 = state_76741__$1;
(statearr_76757_76775[(2)] = inst_76732);

(statearr_76757_76775[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76742 === (8))){
var inst_76727 = (state_76741[(8)]);
var state_76741__$1 = state_76741;
var statearr_76758_76776 = state_76741__$1;
(statearr_76758_76776[(2)] = inst_76727);

(statearr_76758_76776[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_76759 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76759[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_76759[(1)] = (1));

return statearr_76759;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_76741){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76760){var ex__2749__auto__ = e76760;
var statearr_76761_76777 = state_76741;
(statearr_76761_76777[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76741[(4)]))){
var statearr_76762_76778 = state_76741;
(statearr_76762_76778[(1)] = cljs.core.first.call(null,(state_76741[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76779 = state_76741;
state_76741 = G__76779;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_76741){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_76741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76763 = f__2769__auto__.call(null);
(statearr_76763[(6)] = c__2768__auto___76767);

return statearr_76763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq76690){
var G__76691 = cljs.core.first.call(null,seq76690);
var seq76690__$1 = cljs.core.next.call(null,seq76690);
var G__76692 = cljs.core.first.call(null,seq76690__$1);
var seq76690__$2 = cljs.core.next.call(null,seq76690__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76691,G__76692,seq76690__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__76781 = arguments.length;
switch (G__76781) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76910){
var state_val_76911 = (state_76910[(1)]);
if((state_val_76911 === (7))){
var inst_76810 = (state_76910[(7)]);
var inst_76800 = (state_76910[(8)]);
var inst_76812 = fluree.db.time_travel.as_of_block.call(null,inst_76810,inst_76800);
var state_76910__$1 = state_76910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76910__$1,(10),inst_76812);
} else {
if((state_val_76911 === (20))){
var inst_76804 = (state_76910[(9)]);
var state_76910__$1 = state_76910;
var statearr_76912_76992 = state_76910__$1;
(statearr_76912_76992[(2)] = inst_76804);

(statearr_76912_76992[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (27))){
var inst_76798 = (state_76910[(10)]);
var state_76910__$1 = state_76910;
var statearr_76913_76993 = state_76910__$1;
(statearr_76913_76993[(2)] = inst_76798);

(statearr_76913_76993[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (1))){
var state_76910__$1 = state_76910;
var statearr_76914_76994 = state_76910__$1;
(statearr_76914_76994[(2)] = null);

(statearr_76914_76994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (24))){
var inst_76807 = (state_76910[(11)]);
var state_76910__$1 = state_76910;
if(cljs.core.truth_(inst_76807)){
var statearr_76915_76995 = state_76910__$1;
(statearr_76915_76995[(1)] = (26));

} else {
var statearr_76916_76996 = state_76910__$1;
(statearr_76916_76996[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (39))){
var inst_76872 = (state_76910[(12)]);
var inst_76875 = cljs.core.ex_data.call(null,inst_76872);
var inst_76876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76877 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_76875);
var inst_76878 = cljs.core.ex_message.call(null,inst_76872);
var inst_76879 = [inst_76877,inst_76878,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76880 = cljs.core.PersistentHashMap.fromArrays(inst_76876,inst_76879);
var state_76910__$1 = state_76910;
var statearr_76917_76997 = state_76910__$1;
(statearr_76917_76997[(2)] = inst_76880);

(statearr_76917_76997[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (46))){
var inst_76872 = (state_76910[(12)]);
var state_76910__$1 = state_76910;
var statearr_76918_76998 = state_76910__$1;
(statearr_76918_76998[(2)] = inst_76872);

(statearr_76918_76998[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (4))){
var inst_76782 = (state_76910[(2)]);
var inst_76783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76784 = [inst_76782];
var inst_76785 = (new cljs.core.PersistentVector(null,1,(5),inst_76783,inst_76784,null));
var inst_76786 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76785);
var inst_76787 = cljs.core.ex_data.call(null,inst_76782);
var inst_76788 = cljs.core.ex_message.call(null,inst_76782);
var inst_76789 = cljs.core.assoc.call(null,inst_76787,new cljs.core.Keyword(null,"message","message",-406056002),inst_76788);
var state_76910__$1 = (function (){var statearr_76919 = state_76910;
(statearr_76919[(13)] = inst_76786);

return statearr_76919;
})();
var statearr_76920_76999 = state_76910__$1;
(statearr_76920_76999[(2)] = inst_76789);

(statearr_76920_76999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (15))){
var state_76910__$1 = state_76910;
var statearr_76921_77000 = state_76910__$1;
(statearr_76921_77000[(2)] = (1000000));

(statearr_76921_77000[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (48))){
var inst_76872 = (state_76910[(12)]);
var state_76910__$1 = state_76910;
var statearr_76922_77001 = state_76910__$1;
(statearr_76922_77001[(2)] = inst_76872);

(statearr_76922_77001[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (50))){
var inst_76899 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76923_77002 = state_76910__$1;
(statearr_76923_77002[(2)] = inst_76899);

(statearr_76923_77002[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (21))){
var inst_76803 = (state_76910[(14)]);
var state_76910__$1 = state_76910;
if(cljs.core.truth_(inst_76803)){
var statearr_76924_77003 = state_76910__$1;
(statearr_76924_77003[(1)] = (23));

} else {
var statearr_76925_77004 = state_76910__$1;
(statearr_76925_77004[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (31))){
var inst_76861 = (state_76910[(2)]);
var inst_76862 = cljs.core.not.call(null,inst_76861);
var state_76910__$1 = state_76910;
if(inst_76862){
var statearr_76926_77005 = state_76910__$1;
(statearr_76926_77005[(1)] = (35));

} else {
var statearr_76927_77006 = state_76910__$1;
(statearr_76927_77006[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (32))){
var inst_76805 = (state_76910[(15)]);
var state_76910__$1 = state_76910;
var statearr_76928_77007 = state_76910__$1;
(statearr_76928_77007[(2)] = inst_76805);

(statearr_76928_77007[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (40))){
var inst_76835 = (state_76910[(16)]);
var state_76910__$1 = state_76910;
if(cljs.core.truth_(inst_76835)){
var statearr_76929_77008 = state_76910__$1;
(statearr_76929_77008[(1)] = (42));

} else {
var statearr_76930_77009 = state_76910__$1;
(statearr_76930_77009[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (33))){
var inst_76801 = (state_76910[(17)]);
var state_76910__$1 = state_76910;
var statearr_76931_77010 = state_76910__$1;
(statearr_76931_77010[(2)] = inst_76801);

(statearr_76931_77010[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (13))){
var inst_76806 = (state_76910[(18)]);
var inst_76830 = (state_76910[(19)]);
var inst_76828 = (state_76910[(2)]);
var inst_76829 = cljs.core.volatile_BANG_.call(null,(0));
var inst_76830__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_76806);
var state_76910__$1 = (function (){var statearr_76932 = state_76910;
(statearr_76932[(20)] = inst_76828);

(statearr_76932[(21)] = inst_76829);

(statearr_76932[(19)] = inst_76830__$1);

return statearr_76932;
})();
if(cljs.core.truth_(inst_76830__$1)){
var statearr_76933_77011 = state_76910__$1;
(statearr_76933_77011[(1)] = (14));

} else {
var statearr_76934_77012 = state_76910__$1;
(statearr_76934_77012[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (22))){
var inst_76851 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76935_77013 = state_76910__$1;
(statearr_76935_77013[(2)] = inst_76851);

(statearr_76935_77013[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (36))){
var inst_76837 = (state_76910[(22)]);
var inst_76818 = (state_76910[(23)]);
var inst_76868 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_76837);
var inst_76869 = fluree.db.query.fql.query.call(null,inst_76818,inst_76868);
var state_76910__$1 = state_76910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76910__$1,(38),inst_76869);
} else {
if((state_val_76911 === (41))){
var inst_76903 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76936_77014 = state_76910__$1;
(statearr_76936_77014[(2)] = inst_76903);

(statearr_76936_77014[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (43))){
var state_76910__$1 = state_76910;
var statearr_76937_77015 = state_76910__$1;
(statearr_76937_77015[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (29))){
var inst_76805 = (state_76910[(15)]);
var state_76910__$1 = state_76910;
if(cljs.core.truth_(inst_76805)){
var statearr_76939_77016 = state_76910__$1;
(statearr_76939_77016[(1)] = (32));

} else {
var statearr_76940_77017 = state_76910__$1;
(statearr_76940_77017[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (44))){
var inst_76901 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76941_77018 = state_76910__$1;
(statearr_76941_77018[(2)] = inst_76901);

(statearr_76941_77018[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (6))){
var inst_76800 = (state_76910[(8)]);
var inst_76809 = (state_76910[(2)]);
var inst_76810 = fluree.db.util.async.throw_err.call(null,inst_76809);
var state_76910__$1 = (function (){var statearr_76942 = state_76910;
(statearr_76942[(7)] = inst_76810);

return statearr_76942;
})();
if(cljs.core.truth_(inst_76800)){
var statearr_76943_77019 = state_76910__$1;
(statearr_76943_77019[(1)] = (7));

} else {
var statearr_76944_77020 = state_76910__$1;
(statearr_76944_77020[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (28))){
var inst_76847 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76945_77021 = state_76910__$1;
(statearr_76945_77021[(2)] = inst_76847);

(statearr_76945_77021[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (25))){
var inst_76849 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76946_77022 = state_76910__$1;
(statearr_76946_77022[(2)] = inst_76849);

(statearr_76946_77022[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (34))){
var inst_76858 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
var statearr_76947_77023 = state_76910__$1;
(statearr_76947_77023[(2)] = inst_76858);

(statearr_76947_77023[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (17))){
var inst_76799 = (state_76910[(24)]);
var state_76910__$1 = state_76910;
var statearr_76948_77024 = state_76910__$1;
(statearr_76948_77024[(2)] = inst_76799);

(statearr_76948_77024[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (3))){
var inst_76908 = (state_76910[(2)]);
var state_76910__$1 = state_76910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76910__$1,inst_76908);
} else {
if((state_val_76911 === (12))){
var inst_76826 = cljs.core.PersistentHashMap.EMPTY;
var state_76910__$1 = state_76910;
var statearr_76949_77025 = state_76910__$1;
(statearr_76949_77025[(2)] = inst_76826);

(statearr_76949_77025[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (2))){
var _ = (function (){var statearr_76950 = state_76910;
(statearr_76950[(4)] = cljs.core.cons.call(null,(5),(state_76910[(4)])));

return statearr_76950;
})();
var inst_76796 = query_map;
var inst_76797 = cljs.core.__destructure_map.call(null,inst_76796);
var inst_76798 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_76799 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_76800 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"block","block",664686210));
var inst_76801 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_76802 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_76803 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_76804 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_76805 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_76806 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_76807 = cljs.core.get.call(null,inst_76797,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_76910__$1 = (function (){var statearr_76951 = state_76910;
(statearr_76951[(11)] = inst_76807);

(statearr_76951[(14)] = inst_76803);

(statearr_76951[(24)] = inst_76799);

(statearr_76951[(18)] = inst_76806);

(statearr_76951[(9)] = inst_76804);

(statearr_76951[(8)] = inst_76800);

(statearr_76951[(17)] = inst_76801);

(statearr_76951[(25)] = inst_76802);

(statearr_76951[(10)] = inst_76798);

(statearr_76951[(15)] = inst_76805);

return statearr_76951;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76910__$1,(6),sources);
} else {
if((state_val_76911 === (23))){
var inst_76803 = (state_76910[(14)]);
var state_76910__$1 = state_76910;
var statearr_76952_77026 = state_76910__$1;
(statearr_76952_77026[(2)] = inst_76803);

(statearr_76952_77026[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (47))){
var inst_76883 = (state_76910[(26)]);
var inst_76836 = (state_76910[(27)]);
var inst_76829 = (state_76910[(21)]);
var inst_76818 = (state_76910[(23)]);
var inst_76889 = (state_76910[(2)]);
var inst_76890 = cljs.core.deref.call(null,inst_76829);
var inst_76891 = fluree.db.util.core.response_time_formatted.call(null,inst_76836);
var inst_76892 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_76818);
var inst_76893 = [(200),inst_76889,inst_76890,inst_76891,inst_76892];
var inst_76894 = cljs.core.PersistentHashMap.fromArrays(inst_76883,inst_76893);
var state_76910__$1 = state_76910;
var statearr_76953_77027 = state_76910__$1;
(statearr_76953_77027[(2)] = inst_76894);

(statearr_76953_77027[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (35))){
var inst_76864 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76865 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76866 = cljs.core.PersistentHashMap.fromArrays(inst_76864,inst_76865);
var state_76910__$1 = state_76910;
var statearr_76954_77028 = state_76910__$1;
(statearr_76954_77028[(2)] = inst_76866);

(statearr_76954_77028[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (19))){
var inst_76853 = (state_76910[(28)]);
var inst_76853__$1 = (state_76910[(2)]);
var state_76910__$1 = (function (){var statearr_76955 = state_76910;
(statearr_76955[(28)] = inst_76853__$1);

return statearr_76955;
})();
if(cljs.core.truth_(inst_76853__$1)){
var statearr_76956_77029 = state_76910__$1;
(statearr_76956_77029[(1)] = (29));

} else {
var statearr_76957_77030 = state_76910__$1;
(statearr_76957_77030[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (11))){
var inst_76819 = (state_76910[(29)]);
var inst_76818 = (state_76910[(23)]);
var inst_76802 = (state_76910[(25)]);
var inst_76821 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_76818);
var inst_76822 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_76819);
var inst_76823 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_76818);
var inst_76824 = fluree.db.api_js.get_sources.call(null,inst_76819,inst_76821,inst_76822,inst_76823,inst_76802,db_fn);
var state_76910__$1 = state_76910;
var statearr_76959_77031 = state_76910__$1;
(statearr_76959_77031[(2)] = inst_76824);

(statearr_76959_77031[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (9))){
var inst_76818 = (state_76910[(23)]);
var inst_76802 = (state_76910[(25)]);
var inst_76818__$1 = (state_76910[(2)]);
var inst_76819 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_76818__$1);
var state_76910__$1 = (function (){var statearr_76960 = state_76910;
(statearr_76960[(29)] = inst_76819);

(statearr_76960[(23)] = inst_76818__$1);

return statearr_76960;
})();
if(cljs.core.truth_(inst_76802)){
var statearr_76961_77032 = state_76910__$1;
(statearr_76961_77032[(1)] = (11));

} else {
var statearr_76962_77033 = state_76910__$1;
(statearr_76962_77033[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (5))){
var _ = (function (){var statearr_76963 = state_76910;
(statearr_76963[(4)] = cljs.core.rest.call(null,(state_76910[(4)])));

return statearr_76963;
})();
var state_76910__$1 = state_76910;
var ex76958 = (state_76910__$1[(2)]);
var statearr_76964_77034 = state_76910__$1;
(statearr_76964_77034[(5)] = ex76958);


var statearr_76965_77035 = state_76910__$1;
(statearr_76965_77035[(1)] = (4));

(statearr_76965_77035[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (14))){
var inst_76830 = (state_76910[(19)]);
var state_76910__$1 = state_76910;
var statearr_76966_77036 = state_76910__$1;
(statearr_76966_77036[(2)] = inst_76830);

(statearr_76966_77036[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (45))){
var inst_76872 = (state_76910[(12)]);
var inst_76886 = cljs.core.doall.call(null,inst_76872);
var state_76910__$1 = state_76910;
var statearr_76967_77037 = state_76910__$1;
(statearr_76967_77037[(2)] = inst_76886);

(statearr_76967_77037[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (26))){
var inst_76807 = (state_76910[(11)]);
var state_76910__$1 = state_76910;
var statearr_76968_77038 = state_76910__$1;
(statearr_76968_77038[(2)] = inst_76807);

(statearr_76968_77038[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (16))){
var inst_76828 = (state_76910[(20)]);
var inst_76829 = (state_76910[(21)]);
var inst_76799 = (state_76910[(24)]);
var inst_76806 = (state_76910[(18)]);
var inst_76834 = (state_76910[(2)]);
var inst_76835 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_76806);
var inst_76836 = fluree.db.util.core.current_time_millis.call(null);
var inst_76837 = cljs.core.assoc.call(null,inst_76806,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_76828,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_76834,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76829);
var state_76910__$1 = (function (){var statearr_76969 = state_76910;
(statearr_76969[(16)] = inst_76835);

(statearr_76969[(22)] = inst_76837);

(statearr_76969[(27)] = inst_76836);

return statearr_76969;
})();
if(cljs.core.truth_(inst_76799)){
var statearr_76970_77039 = state_76910__$1;
(statearr_76970_77039[(1)] = (17));

} else {
var statearr_76971_77040 = state_76910__$1;
(statearr_76971_77040[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (38))){
var inst_76872 = (state_76910[(12)]);
var inst_76871 = (state_76910[(2)]);
var inst_76872__$1 = fluree.db.util.async.throw_err.call(null,inst_76871);
var inst_76873 = (inst_76872__$1 instanceof cljs.core.ExceptionInfo);
var state_76910__$1 = (function (){var statearr_76972 = state_76910;
(statearr_76972[(12)] = inst_76872__$1);

return statearr_76972;
})();
if(cljs.core.truth_(inst_76873)){
var statearr_76973_77041 = state_76910__$1;
(statearr_76973_77041[(1)] = (39));

} else {
var statearr_76974_77042 = state_76910__$1;
(statearr_76974_77042[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (30))){
var inst_76853 = (state_76910[(28)]);
var state_76910__$1 = state_76910;
var statearr_76975_77043 = state_76910__$1;
(statearr_76975_77043[(2)] = inst_76853);

(statearr_76975_77043[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (10))){
var inst_76814 = (state_76910[(2)]);
var inst_76815 = fluree.db.util.async.throw_err.call(null,inst_76814);
var state_76910__$1 = state_76910;
var statearr_76976_77044 = state_76910__$1;
(statearr_76976_77044[(2)] = inst_76815);

(statearr_76976_77044[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (18))){
var inst_76804 = (state_76910[(9)]);
var state_76910__$1 = state_76910;
if(cljs.core.truth_(inst_76804)){
var statearr_76977_77045 = state_76910__$1;
(statearr_76977_77045[(1)] = (20));

} else {
var statearr_76978_77046 = state_76910__$1;
(statearr_76978_77046[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (42))){
var inst_76872 = (state_76910[(12)]);
var inst_76883 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_76884 = cljs.core.sequential_QMARK_.call(null,inst_76872);
var state_76910__$1 = (function (){var statearr_76979 = state_76910;
(statearr_76979[(26)] = inst_76883);

return statearr_76979;
})();
if(inst_76884){
var statearr_76980_77047 = state_76910__$1;
(statearr_76980_77047[(1)] = (45));

} else {
var statearr_76981_77048 = state_76910__$1;
(statearr_76981_77048[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (37))){
var inst_76905 = (state_76910[(2)]);
var _ = (function (){var statearr_76982 = state_76910;
(statearr_76982[(4)] = cljs.core.rest.call(null,(state_76910[(4)])));

return statearr_76982;
})();
var state_76910__$1 = state_76910;
var statearr_76983_77049 = state_76910__$1;
(statearr_76983_77049[(2)] = inst_76905);

(statearr_76983_77049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (8))){
var inst_76810 = (state_76910[(7)]);
var state_76910__$1 = state_76910;
var statearr_76984_77050 = state_76910__$1;
(statearr_76984_77050[(2)] = inst_76810);

(statearr_76984_77050[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76911 === (49))){
var state_76910__$1 = state_76910;
var statearr_76985_77051 = state_76910__$1;
(statearr_76985_77051[(2)] = null);

(statearr_76985_77051[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_76986 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76986[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_76986[(1)] = (1));

return statearr_76986;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_76910){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76987){var ex__2749__auto__ = e76987;
var statearr_76988_77052 = state_76910;
(statearr_76988_77052[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76910[(4)]))){
var statearr_76989_77053 = state_76910;
(statearr_76989_77053[(1)] = cljs.core.first.call(null,(state_76910[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77054 = state_76910;
state_76910 = G__77054;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_76910){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_76910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76990 = f__2769__auto__.call(null);
(statearr_76990[(6)] = c__2768__auto__);

return statearr_76990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__77055_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__77055_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77077){
var state_val_77078 = (state_77077[(1)]);
if((state_val_77078 === (1))){
var inst_77059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77060 = [resp_chan,timeout_chan];
var inst_77061 = (new cljs.core.PersistentVector(null,2,(5),inst_77059,inst_77060,null));
var state_77077__$1 = state_77077;
return cljs.core.async.ioc_alts_BANG_.call(null,state_77077__$1,(2),inst_77061);
} else {
if((state_val_77078 === (2))){
var inst_77063 = (state_77077[(2)]);
var inst_77064 = cljs.core.nth.call(null,inst_77063,(0),null);
var inst_77065 = cljs.core.nth.call(null,inst_77063,(1),null);
var inst_77066 = cljs.core._EQ_.call(null,timeout_chan,inst_77065);
var state_77077__$1 = (function (){var statearr_77079 = state_77077;
(statearr_77079[(7)] = inst_77064);

return statearr_77079;
})();
if(inst_77066){
var statearr_77080_77090 = state_77077__$1;
(statearr_77080_77090[(1)] = (3));

} else {
var statearr_77081_77091 = state_77077__$1;
(statearr_77081_77091[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (3))){
var inst_77068 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_77069 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_77070 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_77071 = [tid,(408),inst_77070];
var inst_77072 = cljs.core.PersistentHashMap.fromArrays(inst_77069,inst_77071);
var state_77077__$1 = (function (){var statearr_77082 = state_77077;
(statearr_77082[(8)] = inst_77068);

return statearr_77082;
})();
var statearr_77083_77092 = state_77077__$1;
(statearr_77083_77092[(2)] = inst_77072);

(statearr_77083_77092[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (4))){
var inst_77064 = (state_77077[(7)]);
var state_77077__$1 = state_77077;
var statearr_77084_77093 = state_77077__$1;
(statearr_77084_77093[(2)] = inst_77064);

(statearr_77084_77093[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (5))){
var inst_77075 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77077__$1,inst_77075);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_77085 = [null,null,null,null,null,null,null,null,null];
(statearr_77085[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_77085[(1)] = (1));

return statearr_77085;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_77077){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77086){var ex__2749__auto__ = e77086;
var statearr_77087_77094 = state_77077;
(statearr_77087_77094[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77077[(4)]))){
var statearr_77088_77095 = state_77077;
(statearr_77088_77095[(1)] = cljs.core.first.call(null,(state_77077[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77096 = state_77077;
state_77077 = G__77096;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_77077){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_77077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77089 = f__2769__auto__.call(null);
(statearr_77089[(6)] = c__2768__auto__);

return statearr_77089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__77098 = arguments.length;
switch (G__77098) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__77099 = opts;
var map__77099__$1 = cljs.core.__destructure_map.call(null,map__77099);
var auth = cljs.core.get.call(null,map__77099__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__77099__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__77099__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__77099__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__77100 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__77100,(0),null);
var authority = cljs.core.nth.call(null,vec__77100,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e77103){var e = e77103;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__77106 = arguments.length;
switch (G__77106) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77175){
var state_val_77176 = (state_77175[(1)]);
if((state_val_77176 === (7))){
var inst_77128 = (state_77175[(7)]);
var inst_77131 = (state_77175[(8)]);
var inst_77126 = (state_77175[(9)]);
var inst_77129 = (state_77175[(10)]);
var inst_77130 = (state_77175[(11)]);
var inst_77144 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_77145 = [ledger,txn,inst_77126,inst_77128,inst_77129,inst_77130,inst_77131];
var inst_77146 = cljs.core.PersistentHashMap.fromArrays(inst_77144,inst_77145);
var inst_77147 = fluree.db.util.core.without_nils.call(null,inst_77146);
var inst_77148 = fluree.db.operations.transact_async.call(null,conn,inst_77147);
var state_77175__$1 = state_77175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77175__$1,(13),inst_77148);
} else {
if((state_val_77176 === (20))){
var inst_77166 = (state_77175[(2)]);
var state_77175__$1 = state_77175;
var statearr_77177_77213 = state_77175__$1;
(statearr_77177_77213[(2)] = inst_77166);

(statearr_77177_77213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (1))){
var state_77175__$1 = state_77175;
var statearr_77178_77214 = state_77175__$1;
(statearr_77178_77214[(2)] = null);

(statearr_77178_77214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (4))){
var inst_77107 = (state_77175[(2)]);
var inst_77108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77109 = [inst_77107];
var inst_77110 = (new cljs.core.PersistentVector(null,1,(5),inst_77108,inst_77109,null));
var inst_77111 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77110);
var inst_77112 = cljs.core.ex_data.call(null,inst_77107);
var inst_77113 = cljs.core.ex_message.call(null,inst_77107);
var inst_77114 = cljs.core.assoc.call(null,inst_77112,new cljs.core.Keyword(null,"message","message",-406056002),inst_77113);
var state_77175__$1 = (function (){var statearr_77179 = state_77175;
(statearr_77179[(12)] = inst_77111);

return statearr_77179;
})();
var statearr_77180_77215 = state_77175__$1;
(statearr_77180_77215[(2)] = inst_77114);

(statearr_77180_77215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (15))){
var inst_77125 = (state_77175[(13)]);
var inst_77150 = (state_77175[(14)]);
var inst_77153 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_77150,inst_77125);
var state_77175__$1 = state_77175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77175__$1,(17),inst_77153);
} else {
if((state_val_77176 === (13))){
var inst_77124 = (state_77175[(15)]);
var inst_77150 = (state_77175[(2)]);
var state_77175__$1 = (function (){var statearr_77181 = state_77175;
(statearr_77181[(14)] = inst_77150);

return statearr_77181;
})();
if(cljs.core.truth_(inst_77124)){
var statearr_77182_77216 = state_77175__$1;
(statearr_77182_77216[(1)] = (14));

} else {
var statearr_77183_77217 = state_77175__$1;
(statearr_77183_77217[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (6))){
var inst_77124 = (state_77175[(15)]);
var inst_77123 = (state_77175[(16)]);
var inst_77133 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_77123,opts);
var inst_77134 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_77133);
var inst_77135 = fluree.db.operations.command_async.call(null,conn,inst_77133);
var state_77175__$1 = (function (){var statearr_77184 = state_77175;
(statearr_77184[(17)] = inst_77134);

(statearr_77184[(18)] = inst_77135);

return statearr_77184;
})();
if(cljs.core.truth_(inst_77124)){
var statearr_77185_77218 = state_77175__$1;
(statearr_77185_77218[(1)] = (9));

} else {
var statearr_77186_77219 = state_77175__$1;
(statearr_77186_77219[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (17))){
var inst_77155 = (state_77175[(19)]);
var inst_77155__$1 = (state_77175[(2)]);
var inst_77156 = (inst_77155__$1 instanceof cljs.core.ExceptionInfo);
var state_77175__$1 = (function (){var statearr_77187 = state_77175;
(statearr_77187[(19)] = inst_77155__$1);

return statearr_77187;
})();
if(cljs.core.truth_(inst_77156)){
var statearr_77188_77220 = state_77175__$1;
(statearr_77188_77220[(1)] = (18));

} else {
var statearr_77189_77221 = state_77175__$1;
(statearr_77189_77221[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (3))){
var inst_77173 = (state_77175[(2)]);
var state_77175__$1 = state_77175;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77175__$1,inst_77173);
} else {
if((state_val_77176 === (12))){
var inst_77140 = (state_77175[(2)]);
var state_77175__$1 = state_77175;
var statearr_77190_77222 = state_77175__$1;
(statearr_77190_77222[(2)] = inst_77140);

(statearr_77190_77222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (2))){
var inst_77123 = (state_77175[(16)]);
var _ = (function (){var statearr_77191 = state_77175;
(statearr_77191[(4)] = cljs.core.cons.call(null,(5),(state_77175[(4)])));

return statearr_77191;
})();
var inst_77121 = opts;
var inst_77122 = cljs.core.__destructure_map.call(null,inst_77121);
var inst_77123__$1 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_77124 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_77125 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_77126 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_77127 = fluree.db.util.core.current_time_millis.call(null);
var inst_77128 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_77127);
var inst_77129 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_77130 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_77131 = cljs.core.get.call(null,inst_77122,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_77175__$1 = (function (){var statearr_77192 = state_77175;
(statearr_77192[(7)] = inst_77128);

(statearr_77192[(15)] = inst_77124);

(statearr_77192[(13)] = inst_77125);

(statearr_77192[(8)] = inst_77131);

(statearr_77192[(9)] = inst_77126);

(statearr_77192[(10)] = inst_77129);

(statearr_77192[(16)] = inst_77123__$1);

(statearr_77192[(11)] = inst_77130);

return statearr_77192;
})();
if(cljs.core.truth_(inst_77123__$1)){
var statearr_77193_77223 = state_77175__$1;
(statearr_77193_77223[(1)] = (6));

} else {
var statearr_77194_77224 = state_77175__$1;
(statearr_77194_77224[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (19))){
var inst_77155 = (state_77175[(19)]);
var state_77175__$1 = state_77175;
var statearr_77195_77225 = state_77175__$1;
(statearr_77195_77225[(2)] = inst_77155);

(statearr_77195_77225[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (11))){
var inst_77142 = (state_77175[(2)]);
var state_77175__$1 = state_77175;
var statearr_77197_77226 = state_77175__$1;
(statearr_77197_77226[(2)] = inst_77142);

(statearr_77197_77226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (9))){
var inst_77135 = (state_77175[(18)]);
var state_77175__$1 = state_77175;
var statearr_77198_77227 = state_77175__$1;
(statearr_77198_77227[(2)] = inst_77135);

(statearr_77198_77227[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (5))){
var _ = (function (){var statearr_77199 = state_77175;
(statearr_77199[(4)] = cljs.core.rest.call(null,(state_77175[(4)])));

return statearr_77199;
})();
var state_77175__$1 = state_77175;
var ex77196 = (state_77175__$1[(2)]);
var statearr_77200_77228 = state_77175__$1;
(statearr_77200_77228[(5)] = ex77196);


var statearr_77201_77229 = state_77175__$1;
(statearr_77201_77229[(1)] = (4));

(statearr_77201_77229[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (14))){
var inst_77150 = (state_77175[(14)]);
var state_77175__$1 = state_77175;
var statearr_77202_77230 = state_77175__$1;
(statearr_77202_77230[(2)] = inst_77150);

(statearr_77202_77230[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (16))){
var inst_77168 = (state_77175[(2)]);
var state_77175__$1 = state_77175;
var statearr_77203_77231 = state_77175__$1;
(statearr_77203_77231[(2)] = inst_77168);

(statearr_77203_77231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (10))){
var inst_77125 = (state_77175[(13)]);
var inst_77134 = (state_77175[(17)]);
var inst_77138 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_77134,inst_77125);
var state_77175__$1 = state_77175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77175__$1,(12),inst_77138);
} else {
if((state_val_77176 === (18))){
var inst_77155 = (state_77175[(19)]);
var inst_77158 = cljs.core.ex_data.call(null,inst_77155);
var inst_77159 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77160 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_77158);
var inst_77161 = cljs.core.ex_message.call(null,inst_77155);
var inst_77162 = [inst_77160,inst_77161,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_77163 = cljs.core.PersistentHashMap.fromArrays(inst_77159,inst_77162);
var state_77175__$1 = state_77175;
var statearr_77204_77232 = state_77175__$1;
(statearr_77204_77232[(2)] = inst_77163);

(statearr_77204_77232[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77176 === (8))){
var inst_77170 = (state_77175[(2)]);
var _ = (function (){var statearr_77205 = state_77175;
(statearr_77205[(4)] = cljs.core.rest.call(null,(state_77175[(4)])));

return statearr_77205;
})();
var state_77175__$1 = state_77175;
var statearr_77206_77233 = state_77175__$1;
(statearr_77206_77233[(2)] = inst_77170);

(statearr_77206_77233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_77207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77207[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_77207[(1)] = (1));

return statearr_77207;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_77175){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77175);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77208){var ex__2749__auto__ = e77208;
var statearr_77209_77234 = state_77175;
(statearr_77209_77234[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77175[(4)]))){
var statearr_77210_77235 = state_77175;
(statearr_77210_77235[(1)] = cljs.core.first.call(null,(state_77175[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77236 = state_77175;
state_77175 = G__77236;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_77175){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_77175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77211 = f__2769__auto__.call(null);
(statearr_77211[(6)] = c__2768__auto__);

return statearr_77211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___77238 = arguments.length;
var i__5770__auto___77239 = (0);
while(true){
if((i__5770__auto___77239 < len__5769__auto___77238)){
args__5775__auto__.push((arguments[i__5770__auto___77239]));

var G__77240 = (i__5770__auto___77239 + (1));
i__5770__auto___77239 = G__77240;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq77237){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq77237));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77271){
var state_val_77272 = (state_77271[(1)]);
if((state_val_77272 === (1))){
var inst_77241 = cljs.core.first.call(null,flakes);
var inst_77242 = cljs.core.rest.call(null,flakes);
var inst_77243 = cljs.core.PersistentVector.EMPTY;
var inst_77244 = inst_77241;
var inst_77245 = inst_77242;
var inst_77246 = inst_77243;
var state_77271__$1 = (function (){var statearr_77273 = state_77271;
(statearr_77273[(7)] = inst_77244);

(statearr_77273[(8)] = inst_77246);

(statearr_77273[(9)] = inst_77245);

return statearr_77273;
})();
var statearr_77274_77287 = state_77271__$1;
(statearr_77274_77287[(2)] = null);

(statearr_77274_77287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77272 === (2))){
var inst_77244 = (state_77271[(7)]);
var inst_77248 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_77249 = cljs.core.PersistentHashMap.EMPTY;
var inst_77250 = [true,inst_77249];
var inst_77251 = cljs.core.PersistentHashMap.fromArrays(inst_77248,inst_77250);
var inst_77252 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_77251,inst_77244);
var state_77271__$1 = state_77271;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77271__$1,(4),inst_77252);
} else {
if((state_val_77272 === (3))){
var inst_77269 = (state_77271[(2)]);
var state_77271__$1 = state_77271;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77271__$1,inst_77269);
} else {
if((state_val_77272 === (4))){
var inst_77246 = (state_77271[(8)]);
var inst_77245 = (state_77271[(9)]);
var inst_77254 = (state_77271[(2)]);
var inst_77255 = fluree.db.util.async.throw_err.call(null,inst_77254);
var inst_77256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77257 = [inst_77255];
var inst_77258 = (new cljs.core.PersistentVector(null,1,(5),inst_77256,inst_77257,null));
var inst_77259 = cljs.core.concat.call(null,inst_77246,inst_77258);
var inst_77260 = cljs.core.first.call(null,inst_77245);
var state_77271__$1 = (function (){var statearr_77275 = state_77271;
(statearr_77275[(10)] = inst_77259);

return statearr_77275;
})();
if(cljs.core.truth_(inst_77260)){
var statearr_77276_77288 = state_77271__$1;
(statearr_77276_77288[(1)] = (5));

} else {
var statearr_77277_77289 = state_77271__$1;
(statearr_77277_77289[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77272 === (5))){
var inst_77245 = (state_77271[(9)]);
var inst_77259 = (state_77271[(10)]);
var inst_77262 = cljs.core.first.call(null,inst_77245);
var inst_77263 = cljs.core.rest.call(null,inst_77245);
var inst_77244 = inst_77262;
var inst_77245__$1 = inst_77263;
var inst_77246 = inst_77259;
var state_77271__$1 = (function (){var statearr_77278 = state_77271;
(statearr_77278[(7)] = inst_77244);

(statearr_77278[(8)] = inst_77246);

(statearr_77278[(9)] = inst_77245__$1);

return statearr_77278;
})();
var statearr_77279_77290 = state_77271__$1;
(statearr_77279_77290[(2)] = null);

(statearr_77279_77290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77272 === (6))){
var inst_77259 = (state_77271[(10)]);
var state_77271__$1 = state_77271;
var statearr_77280_77291 = state_77271__$1;
(statearr_77280_77291[(2)] = inst_77259);

(statearr_77280_77291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77272 === (7))){
var inst_77267 = (state_77271[(2)]);
var state_77271__$1 = state_77271;
var statearr_77281_77292 = state_77271__$1;
(statearr_77281_77292[(2)] = inst_77267);

(statearr_77281_77292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_77282 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_77282[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_77282[(1)] = (1));

return statearr_77282;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_77271){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77283){var ex__2749__auto__ = e77283;
var statearr_77284_77293 = state_77271;
(statearr_77284_77293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77271[(4)]))){
var statearr_77285_77294 = state_77271;
(statearr_77285_77294[(1)] = cljs.core.first.call(null,(state_77271[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77295 = state_77271;
state_77271 = G__77295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_77271){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_77271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77286 = f__2769__auto__.call(null);
(statearr_77286[(6)] = c__2768__auto__);

return statearr_77286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77363){
var state_val_77364 = (state_77363[(1)]);
if((state_val_77364 === (7))){
var inst_77323 = (state_77363[(2)]);
var inst_77324 = fluree.db.util.async.throw_err.call(null,inst_77323);
var state_77363__$1 = state_77363;
var statearr_77365_77391 = state_77363__$1;
(statearr_77365_77391[(2)] = inst_77324);

(statearr_77365_77391[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (1))){
var inst_77300 = cljs.core.volatile_BANG_.call(null,(0));
var inst_77301 = cljs.core.PersistentHashMap.EMPTY;
var inst_77302 = cljs.core.volatile_BANG_.call(null,inst_77301);
var inst_77303 = cljs.core.first.call(null,resp);
var inst_77304 = cljs.core.rest.call(null,resp);
var inst_77305 = cljs.core.PersistentVector.EMPTY;
var inst_77306 = inst_77300;
var inst_77307 = inst_77302;
var inst_77308 = inst_77303;
var inst_77309 = inst_77304;
var inst_77310 = inst_77305;
var state_77363__$1 = (function (){var statearr_77366 = state_77363;
(statearr_77366[(7)] = inst_77307);

(statearr_77366[(8)] = inst_77306);

(statearr_77366[(9)] = inst_77309);

(statearr_77366[(10)] = inst_77308);

(statearr_77366[(11)] = inst_77310);

return statearr_77366;
})();
var statearr_77367_77392 = state_77363__$1;
(statearr_77367_77392[(2)] = null);

(statearr_77367_77392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (4))){
var inst_77307 = (state_77363[(7)]);
var inst_77306 = (state_77363[(8)]);
var inst_77312 = (state_77363[(12)]);
var inst_77309 = (state_77363[(9)]);
var inst_77314 = (state_77363[(13)]);
var inst_77308 = (state_77363[(10)]);
var inst_77310 = (state_77363[(11)]);
var inst_77318 = (function (){var fuel = inst_77306;
var cache = inst_77307;
var curr_block = inst_77308;
var rest_blocks = inst_77309;
var acc = inst_77310;
var flakes = inst_77312;
var asserted = inst_77314;
return (function (p1__77297_SHARP_){
return p1__77297_SHARP_.s;
});
})();
var inst_77319 = cljs.core.group_by.call(null,inst_77318,inst_77314);
var inst_77320 = cljs.core.vals.call(null,inst_77319);
var inst_77321 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_77307,inst_77306,inst_77320);
var state_77363__$1 = state_77363;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77363__$1,(7),inst_77321);
} else {
if((state_val_77364 === (13))){
var inst_77351 = (state_77363[(14)]);
var state_77363__$1 = state_77363;
var statearr_77368_77393 = state_77363__$1;
(statearr_77368_77393[(2)] = inst_77351);

(statearr_77368_77393[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (6))){
var inst_77307 = (state_77363[(7)]);
var inst_77306 = (state_77363[(8)]);
var inst_77312 = (state_77363[(12)]);
var inst_77327 = (state_77363[(15)]);
var inst_77329 = (state_77363[(16)]);
var inst_77309 = (state_77363[(9)]);
var inst_77314 = (state_77363[(13)]);
var inst_77308 = (state_77363[(10)]);
var inst_77310 = (state_77363[(11)]);
var inst_77327__$1 = (state_77363[(2)]);
var inst_77328 = (function (){var fuel = inst_77306;
var cache = inst_77307;
var curr_block = inst_77308;
var rest_blocks = inst_77309;
var acc = inst_77310;
var flakes = inst_77312;
var asserted = inst_77314;
var asserted_SINGLEQUOTE_ = inst_77327__$1;
return (function (p1__77298_SHARP_){
return p1__77298_SHARP_.op === false;
});
})();
var inst_77329__$1 = cljs.core.filter.call(null,inst_77328,inst_77312);
var inst_77330 = cljs.core.empty_QMARK_.call(null,inst_77329__$1);
var inst_77331 = (!(inst_77330));
var state_77363__$1 = (function (){var statearr_77371 = state_77363;
(statearr_77371[(15)] = inst_77327__$1);

(statearr_77371[(16)] = inst_77329__$1);

return statearr_77371;
})();
if(inst_77331){
var statearr_77372_77394 = state_77363__$1;
(statearr_77372_77394[(1)] = (8));

} else {
var statearr_77373_77395 = state_77363__$1;
(statearr_77373_77395[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (3))){
var inst_77361 = (state_77363[(2)]);
var state_77363__$1 = state_77363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77363__$1,inst_77361);
} else {
if((state_val_77364 === (12))){
var inst_77307 = (state_77363[(7)]);
var inst_77306 = (state_77363[(8)]);
var inst_77351 = (state_77363[(14)]);
var inst_77309 = (state_77363[(9)]);
var inst_77354 = cljs.core.first.call(null,inst_77309);
var inst_77355 = cljs.core.rest.call(null,inst_77309);
var tmp77369 = inst_77307;
var tmp77370 = inst_77306;
var inst_77306__$1 = tmp77370;
var inst_77307__$1 = tmp77369;
var inst_77308 = inst_77354;
var inst_77309__$1 = inst_77355;
var inst_77310 = inst_77351;
var state_77363__$1 = (function (){var statearr_77374 = state_77363;
(statearr_77374[(7)] = inst_77307__$1);

(statearr_77374[(8)] = inst_77306__$1);

(statearr_77374[(9)] = inst_77309__$1);

(statearr_77374[(10)] = inst_77308);

(statearr_77374[(11)] = inst_77310);

return statearr_77374;
})();
var statearr_77375_77396 = state_77363__$1;
(statearr_77375_77396[(2)] = null);

(statearr_77375_77396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (2))){
var inst_77307 = (state_77363[(7)]);
var inst_77306 = (state_77363[(8)]);
var inst_77312 = (state_77363[(12)]);
var inst_77309 = (state_77363[(9)]);
var inst_77314 = (state_77363[(13)]);
var inst_77308 = (state_77363[(10)]);
var inst_77310 = (state_77363[(11)]);
var inst_77312__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_77308);
var inst_77313 = (function (){var fuel = inst_77306;
var cache = inst_77307;
var curr_block = inst_77308;
var rest_blocks = inst_77309;
var acc = inst_77310;
var flakes = inst_77312__$1;
return (function (p1__77296_SHARP_){
return p1__77296_SHARP_.op;
});
})();
var inst_77314__$1 = cljs.core.filter.call(null,inst_77313,inst_77312__$1);
var inst_77315 = cljs.core.empty_QMARK_.call(null,inst_77314__$1);
var inst_77316 = (!(inst_77315));
var state_77363__$1 = (function (){var statearr_77376 = state_77363;
(statearr_77376[(12)] = inst_77312__$1);

(statearr_77376[(13)] = inst_77314__$1);

return statearr_77376;
})();
if(inst_77316){
var statearr_77377_77397 = state_77363__$1;
(statearr_77377_77397[(1)] = (4));

} else {
var statearr_77378_77398 = state_77363__$1;
(statearr_77378_77398[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (11))){
var inst_77339 = (state_77363[(2)]);
var inst_77340 = fluree.db.util.async.throw_err.call(null,inst_77339);
var state_77363__$1 = state_77363;
var statearr_77379_77399 = state_77363__$1;
(statearr_77379_77399[(2)] = inst_77340);

(statearr_77379_77399[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (9))){
var state_77363__$1 = state_77363;
var statearr_77380_77400 = state_77363__$1;
(statearr_77380_77400[(2)] = null);

(statearr_77380_77400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (5))){
var state_77363__$1 = state_77363;
var statearr_77381_77401 = state_77363__$1;
(statearr_77381_77401[(2)] = null);

(statearr_77381_77401[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (14))){
var inst_77359 = (state_77363[(2)]);
var state_77363__$1 = state_77363;
var statearr_77382_77402 = state_77363__$1;
(statearr_77382_77402[(2)] = inst_77359);

(statearr_77382_77402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (10))){
var inst_77327 = (state_77363[(15)]);
var inst_77309 = (state_77363[(9)]);
var inst_77308 = (state_77363[(10)]);
var inst_77310 = (state_77363[(11)]);
var inst_77343 = (state_77363[(2)]);
var inst_77344 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_77345 = [inst_77327,inst_77343];
var inst_77346 = cljs.core.PersistentHashMap.fromArrays(inst_77344,inst_77345);
var inst_77347 = cljs.core.assoc.call(null,inst_77308,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_77346);
var inst_77348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77349 = [inst_77347];
var inst_77350 = (new cljs.core.PersistentVector(null,1,(5),inst_77348,inst_77349,null));
var inst_77351 = cljs.core.concat.call(null,inst_77310,inst_77350);
var inst_77352 = cljs.core.first.call(null,inst_77309);
var state_77363__$1 = (function (){var statearr_77383 = state_77363;
(statearr_77383[(14)] = inst_77351);

return statearr_77383;
})();
if(cljs.core.truth_(inst_77352)){
var statearr_77384_77403 = state_77363__$1;
(statearr_77384_77403[(1)] = (12));

} else {
var statearr_77385_77404 = state_77363__$1;
(statearr_77385_77404[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77364 === (8))){
var inst_77307 = (state_77363[(7)]);
var inst_77306 = (state_77363[(8)]);
var inst_77312 = (state_77363[(12)]);
var inst_77327 = (state_77363[(15)]);
var inst_77329 = (state_77363[(16)]);
var inst_77309 = (state_77363[(9)]);
var inst_77314 = (state_77363[(13)]);
var inst_77308 = (state_77363[(10)]);
var inst_77310 = (state_77363[(11)]);
var inst_77333 = (function (){var flakes = inst_77312;
var rest_blocks = inst_77309;
var curr_block = inst_77308;
var asserted_SINGLEQUOTE_ = inst_77327;
var acc = inst_77310;
var fuel = inst_77306;
var cache = inst_77307;
var retracted = inst_77329;
var asserted = inst_77314;
return (function (p1__77299_SHARP_){
return p1__77299_SHARP_.s;
});
})();
var inst_77334 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_77329);
var inst_77335 = cljs.core.group_by.call(null,inst_77333,inst_77334);
var inst_77336 = cljs.core.vals.call(null,inst_77335);
var inst_77337 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_77307,inst_77306,inst_77336);
var state_77363__$1 = state_77363;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77363__$1,(11),inst_77337);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_77386 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77386[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_77386[(1)] = (1));

return statearr_77386;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_77363){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77387){var ex__2749__auto__ = e77387;
var statearr_77388_77405 = state_77363;
(statearr_77388_77405[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77363[(4)]))){
var statearr_77389_77406 = state_77363;
(statearr_77389_77406[(1)] = cljs.core.first.call(null,(state_77363[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77407 = state_77363;
state_77363 = G__77407;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_77363){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_77363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77390 = f__2769__auto__.call(null);
(statearr_77390[(6)] = c__2768__auto__);

return statearr_77390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77507){
var state_val_77508 = (state_77507[(1)]);
if((state_val_77508 === (7))){
var inst_77479 = (state_77507[(7)]);
var inst_77472 = (state_77507[(8)]);
var inst_77478 = cljs.core.seq.call(null,inst_77472);
var inst_77479__$1 = cljs.core.first.call(null,inst_77478);
var inst_77480 = cljs.core.next.call(null,inst_77478);
var state_77507__$1 = (function (){var statearr_77509 = state_77507;
(statearr_77509[(7)] = inst_77479__$1);

(statearr_77509[(9)] = inst_77480);

return statearr_77509;
})();
if(cljs.core.truth_(inst_77479__$1)){
var statearr_77510_77547 = state_77507__$1;
(statearr_77510_77547[(1)] = (9));

} else {
var statearr_77511_77548 = state_77507__$1;
(statearr_77511_77548[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (1))){
var state_77507__$1 = state_77507;
var statearr_77512_77549 = state_77507__$1;
(statearr_77512_77549[(2)] = null);

(statearr_77512_77549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (4))){
var inst_77409 = (state_77507[(2)]);
var state_77507__$1 = state_77507;
var statearr_77513_77550 = state_77507__$1;
(statearr_77513_77550[(2)] = inst_77409);

(statearr_77513_77550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (6))){
var inst_77458 = (state_77507[(2)]);
var inst_77459 = fluree.db.util.async.throw_err.call(null,inst_77458);
var inst_77467 = resp;
var inst_77468 = cljs.core.seq.call(null,inst_77467);
var inst_77469 = cljs.core.first.call(null,inst_77468);
var inst_77470 = cljs.core.next.call(null,inst_77468);
var inst_77471 = cljs.core.PersistentHashMap.EMPTY;
var inst_77472 = inst_77467;
var inst_77473 = inst_77471;
var state_77507__$1 = (function (){var statearr_77514 = state_77507;
(statearr_77514[(10)] = inst_77470);

(statearr_77514[(11)] = inst_77459);

(statearr_77514[(12)] = inst_77473);

(statearr_77514[(13)] = inst_77469);

(statearr_77514[(8)] = inst_77472);

return statearr_77514;
})();
var statearr_77515_77551 = state_77507__$1;
(statearr_77515_77551[(2)] = null);

(statearr_77515_77551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (3))){
var inst_77505 = (state_77507[(2)]);
var state_77507__$1 = state_77507;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77507__$1,inst_77505);
} else {
if((state_val_77508 === (2))){
var _ = (function (){var statearr_77516 = state_77507;
(statearr_77516[(4)] = cljs.core.cons.call(null,(5),(state_77507[(4)])));

return statearr_77516;
})();
var inst_77415 = (function (){return (function (p1__77408_SHARP_){
return p1__77408_SHARP_.t;
});
})();
var inst_77416 = cljs.core.map.call(null,inst_77415,resp);
var inst_77417 = cljs.core.set.call(null,inst_77416);
var inst_77454 = cljs.core.async.chan.call(null,(1));
var inst_77455 = (function (){var ts = inst_77417;
var c__2768__auto____$1 = inst_77454;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77452){
var state_val_77453 = (state_77452[(1)]);
if((state_val_77453 === (1))){
var inst_77425 = ts;
var inst_77426 = cljs.core.seq.call(null,inst_77425);
var inst_77427 = cljs.core.first.call(null,inst_77426);
var inst_77428 = cljs.core.next.call(null,inst_77426);
var inst_77429 = cljs.core.PersistentHashMap.EMPTY;
var inst_77430 = inst_77425;
var inst_77431 = inst_77429;
var state_77452__$1 = (function (){var statearr_77517 = state_77452;
(statearr_77517[(7)] = inst_77428);

(statearr_77517[(8)] = inst_77427);

(statearr_77517[(9)] = inst_77430);

(statearr_77517[(10)] = inst_77431);

return statearr_77517;
})();
var statearr_77518_77552 = state_77452__$1;
(statearr_77518_77552[(2)] = null);

(statearr_77518_77552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77453 === (2))){
var inst_77437 = (state_77452[(11)]);
var inst_77430 = (state_77452[(9)]);
var inst_77436 = cljs.core.seq.call(null,inst_77430);
var inst_77437__$1 = cljs.core.first.call(null,inst_77436);
var inst_77438 = cljs.core.next.call(null,inst_77436);
var state_77452__$1 = (function (){var statearr_77519 = state_77452;
(statearr_77519[(11)] = inst_77437__$1);

(statearr_77519[(12)] = inst_77438);

return statearr_77519;
})();
if(cljs.core.truth_(inst_77437__$1)){
var statearr_77520_77553 = state_77452__$1;
(statearr_77520_77553[(1)] = (4));

} else {
var statearr_77521_77554 = state_77452__$1;
(statearr_77521_77554[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77453 === (3))){
var inst_77450 = (state_77452[(2)]);
var state_77452__$1 = state_77452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77452__$1,inst_77450);
} else {
if((state_val_77453 === (4))){
var inst_77437 = (state_77452[(11)]);
var inst_77440 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_77437);
var state_77452__$1 = state_77452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77452__$1,(7),inst_77440);
} else {
if((state_val_77453 === (5))){
var inst_77431 = (state_77452[(10)]);
var state_77452__$1 = state_77452;
var statearr_77522_77555 = state_77452__$1;
(statearr_77522_77555[(2)] = inst_77431);

(statearr_77522_77555[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77453 === (6))){
var inst_77448 = (state_77452[(2)]);
var state_77452__$1 = state_77452;
var statearr_77523_77556 = state_77452__$1;
(statearr_77523_77556[(2)] = inst_77448);

(statearr_77523_77556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77453 === (7))){
var inst_77437 = (state_77452[(11)]);
var inst_77431 = (state_77452[(10)]);
var inst_77438 = (state_77452[(12)]);
var inst_77442 = (state_77452[(2)]);
var inst_77443 = fluree.db.util.async.throw_err.call(null,inst_77442);
var inst_77444 = cljs.core.assoc.call(null,inst_77431,inst_77437,inst_77443);
var inst_77430 = inst_77438;
var inst_77431__$1 = inst_77444;
var state_77452__$1 = (function (){var statearr_77524 = state_77452;
(statearr_77524[(9)] = inst_77430);

(statearr_77524[(10)] = inst_77431__$1);

return statearr_77524;
})();
var statearr_77525_77557 = state_77452__$1;
(statearr_77525_77557[(2)] = null);

(statearr_77525_77557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_77526 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77526[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_77526[(1)] = (1));

return statearr_77526;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_77452){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77527){var ex__2749__auto__ = e77527;
var statearr_77528_77558 = state_77452;
(statearr_77528_77558[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77452[(4)]))){
var statearr_77529_77559 = state_77452;
(statearr_77529_77559[(1)] = cljs.core.first.call(null,(state_77452[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77560 = state_77452;
state_77452 = G__77560;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_77452){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_77452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77530 = f__2769__auto__.call(null);
(statearr_77530[(6)] = c__2768__auto____$1);

return statearr_77530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_77456 = cljs.core.async.impl.dispatch.run.call(null,inst_77455);
var state_77507__$1 = (function (){var statearr_77531 = state_77507;
(statearr_77531[(14)] = inst_77456);

return statearr_77531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77507__$1,(6),inst_77454);
} else {
if((state_val_77508 === (11))){
var inst_77499 = (state_77507[(2)]);
var state_77507__$1 = state_77507;
var statearr_77533_77561 = state_77507__$1;
(statearr_77533_77561[(2)] = inst_77499);

(statearr_77533_77561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (9))){
var inst_77479 = (state_77507[(7)]);
var inst_77459 = (state_77507[(11)]);
var inst_77480 = (state_77507[(9)]);
var inst_77473 = (state_77507[(12)]);
var inst_77482 = inst_77479.t;
var inst_77483 = cljs.core.get.call(null,inst_77459,inst_77482);
var inst_77484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77485 = [inst_77483,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_77486 = (new cljs.core.PersistentVector(null,2,(5),inst_77484,inst_77485,null));
var inst_77487 = cljs.core.assoc_in.call(null,inst_77473,inst_77486,inst_77483);
var inst_77488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77489 = [inst_77483,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_77490 = (new cljs.core.PersistentVector(null,2,(5),inst_77488,inst_77489,null));
var inst_77491 = cljs.core.update_in.call(null,inst_77487,inst_77490,cljs.core.conj,inst_77479);
var inst_77492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77493 = [inst_77483,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_77494 = (new cljs.core.PersistentVector(null,2,(5),inst_77492,inst_77493,null));
var inst_77495 = cljs.core.update_in.call(null,inst_77491,inst_77494,fluree.db.api_js.min_safe,inst_77482);
var inst_77472 = inst_77480;
var inst_77473__$1 = inst_77495;
var state_77507__$1 = (function (){var statearr_77534 = state_77507;
(statearr_77534[(12)] = inst_77473__$1);

(statearr_77534[(8)] = inst_77472);

return statearr_77534;
})();
var statearr_77535_77562 = state_77507__$1;
(statearr_77535_77562[(2)] = null);

(statearr_77535_77562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (5))){
var _ = (function (){var statearr_77536 = state_77507;
(statearr_77536[(4)] = cljs.core.rest.call(null,(state_77507[(4)])));

return statearr_77536;
})();
var state_77507__$1 = state_77507;
var ex77532 = (state_77507__$1[(2)]);
var statearr_77537_77563 = state_77507__$1;
(statearr_77537_77563[(5)] = ex77532);


if((ex77532 instanceof Error)){
var statearr_77538_77564 = state_77507__$1;
(statearr_77538_77564[(1)] = (4));

(statearr_77538_77564[(5)] = null);

} else {
throw ex77532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (10))){
var inst_77473 = (state_77507[(12)]);
var state_77507__$1 = state_77507;
var statearr_77539_77565 = state_77507__$1;
(statearr_77539_77565[(2)] = inst_77473);

(statearr_77539_77565[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77508 === (8))){
var inst_77501 = (state_77507[(2)]);
var inst_77502 = cljs.core.vals.call(null,inst_77501);
var _ = (function (){var statearr_77540 = state_77507;
(statearr_77540[(4)] = cljs.core.rest.call(null,(state_77507[(4)])));

return statearr_77540;
})();
var state_77507__$1 = state_77507;
var statearr_77541_77566 = state_77507__$1;
(statearr_77541_77566[(2)] = inst_77502);

(statearr_77541_77566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_77542 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77542[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_77542[(1)] = (1));

return statearr_77542;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_77507){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77507);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77543){var ex__2749__auto__ = e77543;
var statearr_77544_77567 = state_77507;
(statearr_77544_77567[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77507[(4)]))){
var statearr_77545_77568 = state_77507;
(statearr_77545_77568[(1)] = cljs.core.first.call(null,(state_77507[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77569 = state_77507;
state_77507 = G__77569;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_77507){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_77507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77546 = f__2769__auto__.call(null);
(statearr_77546[(6)] = c__2768__auto__);

return statearr_77546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77717){
var state_val_77718 = (state_77717[(1)]);
if((state_val_77718 === (7))){
var inst_77597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77598 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_77599 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_77600 = [inst_77598,inst_77599];
var inst_77601 = (new cljs.core.PersistentVector(null,2,(5),inst_77597,inst_77600,null));
var state_77717__$1 = state_77717;
var statearr_77719_77790 = state_77717__$1;
(statearr_77719_77790[(2)] = inst_77601);

(statearr_77719_77790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (20))){
var inst_77627 = (state_77717[(7)]);
var state_77717__$1 = state_77717;
var statearr_77720_77791 = state_77717__$1;
(statearr_77720_77791[(2)] = inst_77627);

(statearr_77720_77791[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (27))){
var state_77717__$1 = state_77717;
var statearr_77721_77792 = state_77717__$1;
(statearr_77721_77792[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (1))){
var state_77717__$1 = state_77717;
var statearr_77723_77793 = state_77717__$1;
(statearr_77723_77793[(2)] = null);

(statearr_77723_77793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (24))){
var inst_77626 = (state_77717[(8)]);
var state_77717__$1 = state_77717;
if(cljs.core.truth_(inst_77626)){
var statearr_77724_77794 = state_77717__$1;
(statearr_77724_77794[(1)] = (26));

} else {
var statearr_77725_77795 = state_77717__$1;
(statearr_77725_77795[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (39))){
var inst_77673 = (state_77717[(9)]);
var inst_77672 = (state_77717[(10)]);
var inst_77698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77699 = [inst_77672,inst_77673];
var inst_77700 = (new cljs.core.PersistentVector(null,2,(5),inst_77698,inst_77699,null));
var state_77717__$1 = state_77717;
var statearr_77726_77796 = state_77717__$1;
(statearr_77726_77796[(2)] = inst_77700);

(statearr_77726_77796[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (4))){
var inst_77570 = (state_77717[(2)]);
var inst_77571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77572 = [inst_77570];
var inst_77573 = (new cljs.core.PersistentVector(null,1,(5),inst_77571,inst_77572,null));
var inst_77574 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77573);
var inst_77575 = cljs.core.ex_data.call(null,inst_77570);
var inst_77576 = cljs.core.ex_message.call(null,inst_77570);
var inst_77577 = cljs.core.assoc.call(null,inst_77575,new cljs.core.Keyword(null,"message","message",-406056002),inst_77576);
var state_77717__$1 = (function (){var statearr_77727 = state_77717;
(statearr_77727[(11)] = inst_77574);

return statearr_77727;
})();
var statearr_77728_77797 = state_77717__$1;
(statearr_77728_77797[(2)] = inst_77577);

(statearr_77728_77797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (15))){
var inst_77611 = (state_77717[(12)]);
var inst_77606 = (state_77717[(13)]);
var inst_77620 = (state_77717[(2)]);
var inst_77621 = [inst_77611,inst_77620];
var inst_77622 = (new cljs.core.PersistentVector(null,2,(5),inst_77606,inst_77621,null));
var state_77717__$1 = state_77717;
var statearr_77729_77798 = state_77717__$1;
(statearr_77729_77798[(2)] = inst_77622);

(statearr_77729_77798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (21))){
var inst_77626 = (state_77717[(8)]);
var state_77717__$1 = state_77717;
var statearr_77730_77799 = state_77717__$1;
(statearr_77730_77799[(2)] = inst_77626);

(statearr_77730_77799[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (31))){
var inst_77667 = (state_77717[(2)]);
var state_77717__$1 = state_77717;
var statearr_77731_77800 = state_77717__$1;
(statearr_77731_77800[(2)] = inst_77667);

(statearr_77731_77800[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (32))){
var inst_77673 = (state_77717[(9)]);
var inst_77676 = cljs.core.pos_int_QMARK_.call(null,inst_77673);
var state_77717__$1 = state_77717;
var statearr_77732_77801 = state_77717__$1;
(statearr_77732_77801[(2)] = inst_77676);

(statearr_77732_77801[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (40))){
var inst_77628 = (state_77717[(14)]);
var inst_77704 = (state_77717[(15)]);
var inst_77702 = (state_77717[(2)]);
var inst_77703 = cljs.core.nth.call(null,inst_77702,(0),null);
var inst_77704__$1 = cljs.core.nth.call(null,inst_77702,(1),null);
var inst_77705 = (inst_77704__$1 > inst_77628);
var state_77717__$1 = (function (){var statearr_77733 = state_77717;
(statearr_77733[(15)] = inst_77704__$1);

(statearr_77733[(16)] = inst_77703);

return statearr_77733;
})();
if(cljs.core.truth_(inst_77705)){
var statearr_77734_77802 = state_77717__$1;
(statearr_77734_77802[(1)] = (41));

} else {
var statearr_77735_77803 = state_77717__$1;
(statearr_77735_77803[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (33))){
var inst_77674 = (state_77717[(17)]);
var state_77717__$1 = state_77717;
var statearr_77736_77804 = state_77717__$1;
(statearr_77736_77804[(2)] = inst_77674);

(statearr_77736_77804[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (13))){
var inst_77612 = (state_77717[(18)]);
var inst_77614 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_77612);
var state_77717__$1 = state_77717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77717__$1,(16),inst_77614);
} else {
if((state_val_77718 === (22))){
var inst_77645 = (state_77717[(2)]);
var state_77717__$1 = state_77717;
if(cljs.core.truth_(inst_77645)){
var statearr_77737_77805 = state_77717__$1;
(statearr_77737_77805[(1)] = (23));

} else {
var statearr_77738_77806 = state_77717__$1;
(statearr_77738_77806[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (36))){
var state_77717__$1 = state_77717;
var statearr_77739_77807 = state_77717__$1;
(statearr_77739_77807[(2)] = null);

(statearr_77739_77807[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (41))){
var inst_77628 = (state_77717[(14)]);
var state_77717__$1 = state_77717;
var statearr_77740_77808 = state_77717__$1;
(statearr_77740_77808[(2)] = inst_77628);

(statearr_77740_77808[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (43))){
var inst_77703 = (state_77717[(16)]);
var inst_77709 = (state_77717[(2)]);
var inst_77710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77711 = [inst_77703,inst_77709];
var inst_77712 = (new cljs.core.PersistentVector(null,2,(5),inst_77710,inst_77711,null));
var _ = (function (){var statearr_77741 = state_77717;
(statearr_77741[(4)] = cljs.core.rest.call(null,(state_77717[(4)])));

return statearr_77741;
})();
var state_77717__$1 = state_77717;
var statearr_77742_77809 = state_77717__$1;
(statearr_77742_77809[(2)] = inst_77712);

(statearr_77742_77809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (29))){
var inst_77603 = (state_77717[(19)]);
var inst_77658 = cljs.core.pr_str.call(null,inst_77603);
var inst_77659 = ["Invalid block range provided: ",inst_77658].join('');
var inst_77660 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77661 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77662 = cljs.core.PersistentHashMap.fromArrays(inst_77660,inst_77661);
var inst_77663 = cljs.core.ex_info.call(null,inst_77659,inst_77662);
var inst_77664 = (function(){throw inst_77663})();
var state_77717__$1 = state_77717;
var statearr_77743_77810 = state_77717__$1;
(statearr_77743_77810[(2)] = inst_77664);

(statearr_77743_77810[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (6))){
var inst_77595 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_77717__$1 = state_77717;
var statearr_77744_77811 = state_77717__$1;
(statearr_77744_77811[(2)] = inst_77595);

(statearr_77744_77811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (28))){
var inst_77669 = (state_77717[(2)]);
var state_77717__$1 = state_77717;
var statearr_77745_77812 = state_77717__$1;
(statearr_77745_77812[(2)] = inst_77669);

(statearr_77745_77812[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (25))){
var inst_77674 = (state_77717[(17)]);
var inst_77672 = (state_77717[(10)]);
var inst_77671 = (state_77717[(2)]);
var inst_77672__$1 = cljs.core.nth.call(null,inst_77671,(0),null);
var inst_77673 = cljs.core.nth.call(null,inst_77671,(1),null);
var inst_77674__$1 = cljs.core.pos_int_QMARK_.call(null,inst_77672__$1);
var state_77717__$1 = (function (){var statearr_77746 = state_77717;
(statearr_77746[(17)] = inst_77674__$1);

(statearr_77746[(9)] = inst_77673);

(statearr_77746[(10)] = inst_77672__$1);

return statearr_77746;
})();
if(inst_77674__$1){
var statearr_77747_77813 = state_77717__$1;
(statearr_77747_77813[(1)] = (32));

} else {
var statearr_77748_77814 = state_77717__$1;
(statearr_77748_77814[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (34))){
var inst_77679 = (state_77717[(2)]);
var inst_77680 = cljs.core.not.call(null,inst_77679);
var state_77717__$1 = state_77717;
if(inst_77680){
var statearr_77749_77815 = state_77717__$1;
(statearr_77749_77815[(1)] = (35));

} else {
var statearr_77750_77816 = state_77717__$1;
(statearr_77750_77816[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (17))){
var inst_77626 = (state_77717[(8)]);
var inst_77628 = (state_77717[(14)]);
var inst_77631 = cljs.core.pr_str.call(null,inst_77626);
var inst_77632 = cljs.core.pr_str.call(null,inst_77628);
var inst_77633 = ["Start block is out of range for this ledger. Start block provided: ",inst_77631,". Database block: ",inst_77632].join('');
var inst_77634 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77635 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77636 = cljs.core.PersistentHashMap.fromArrays(inst_77634,inst_77635);
var inst_77637 = cljs.core.ex_info.call(null,inst_77633,inst_77636);
var inst_77638 = (function(){throw inst_77637})();
var state_77717__$1 = state_77717;
var statearr_77751_77817 = state_77717__$1;
(statearr_77751_77817[(2)] = inst_77638);

(statearr_77751_77817[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (3))){
var inst_77715 = (state_77717[(2)]);
var state_77717__$1 = state_77717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77717__$1,inst_77715);
} else {
if((state_val_77718 === (12))){
var inst_77603 = (state_77717[(19)]);
var inst_77612 = (state_77717[(18)]);
var inst_77610 = (state_77717[(2)]);
var inst_77611 = fluree.db.util.async.throw_err.call(null,inst_77610);
var inst_77612__$1 = cljs.core.second.call(null,inst_77603);
var state_77717__$1 = (function (){var statearr_77752 = state_77717;
(statearr_77752[(12)] = inst_77611);

(statearr_77752[(18)] = inst_77612__$1);

return statearr_77752;
})();
if(cljs.core.truth_(inst_77612__$1)){
var statearr_77753_77818 = state_77717__$1;
(statearr_77753_77818[(1)] = (13));

} else {
var statearr_77754_77819 = state_77717__$1;
(statearr_77754_77819[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (2))){
var _ = (function (){var statearr_77755 = state_77717;
(statearr_77755[(4)] = cljs.core.cons.call(null,(5),(state_77717[(4)])));

return statearr_77755;
})();
var inst_77592 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_77593 = cljs.core.sequential_QMARK_.call(null,inst_77592);
var state_77717__$1 = state_77717;
if(inst_77593){
var statearr_77756_77820 = state_77717__$1;
(statearr_77756_77820[(1)] = (6));

} else {
var statearr_77757_77821 = state_77717__$1;
(statearr_77757_77821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (23))){
var inst_77626 = (state_77717[(8)]);
var inst_77627 = (state_77717[(7)]);
var inst_77647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77648 = [inst_77626,inst_77627];
var inst_77649 = (new cljs.core.PersistentVector(null,2,(5),inst_77647,inst_77648,null));
var state_77717__$1 = state_77717;
var statearr_77758_77822 = state_77717__$1;
(statearr_77758_77822[(2)] = inst_77649);

(statearr_77758_77822[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (35))){
var inst_77603 = (state_77717[(19)]);
var inst_77682 = cljs.core.pr_str.call(null,inst_77603);
var inst_77683 = ["Invalid block range provided: ",inst_77682].join('');
var inst_77684 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77685 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77686 = cljs.core.PersistentHashMap.fromArrays(inst_77684,inst_77685);
var inst_77687 = cljs.core.ex_info.call(null,inst_77683,inst_77686);
var inst_77688 = (function(){throw inst_77687})();
var state_77717__$1 = state_77717;
var statearr_77759_77823 = state_77717__$1;
(statearr_77759_77823[(2)] = inst_77688);

(statearr_77759_77823[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (19))){
var inst_77626 = (state_77717[(8)]);
var inst_77641 = (state_77717[(2)]);
var state_77717__$1 = (function (){var statearr_77760 = state_77717;
(statearr_77760[(20)] = inst_77641);

return statearr_77760;
})();
if(cljs.core.truth_(inst_77626)){
var statearr_77761_77824 = state_77717__$1;
(statearr_77761_77824[(1)] = (20));

} else {
var statearr_77762_77825 = state_77717__$1;
(statearr_77762_77825[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (11))){
var inst_77626 = (state_77717[(8)]);
var inst_77628 = (state_77717[(14)]);
var inst_77625 = (state_77717[(2)]);
var inst_77626__$1 = cljs.core.nth.call(null,inst_77625,(0),null);
var inst_77627 = cljs.core.nth.call(null,inst_77625,(1),null);
var inst_77628__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_77629 = (inst_77626__$1 > inst_77628__$1);
var state_77717__$1 = (function (){var statearr_77764 = state_77717;
(statearr_77764[(8)] = inst_77626__$1);

(statearr_77764[(7)] = inst_77627);

(statearr_77764[(14)] = inst_77628__$1);

return statearr_77764;
})();
if(cljs.core.truth_(inst_77629)){
var statearr_77765_77826 = state_77717__$1;
(statearr_77765_77826[(1)] = (17));

} else {
var statearr_77766_77827 = state_77717__$1;
(statearr_77766_77827[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (9))){
var inst_77603 = (state_77717[(19)]);
var inst_77606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77607 = cljs.core.first.call(null,inst_77603);
var inst_77608 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_77607);
var state_77717__$1 = (function (){var statearr_77767 = state_77717;
(statearr_77767[(13)] = inst_77606);

return statearr_77767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77717__$1,(12),inst_77608);
} else {
if((state_val_77718 === (5))){
var _ = (function (){var statearr_77768 = state_77717;
(statearr_77768[(4)] = cljs.core.rest.call(null,(state_77717[(4)])));

return statearr_77768;
})();
var state_77717__$1 = state_77717;
var ex77763 = (state_77717__$1[(2)]);
var statearr_77769_77828 = state_77717__$1;
(statearr_77769_77828[(5)] = ex77763);


var statearr_77770_77829 = state_77717__$1;
(statearr_77770_77829[(1)] = (4));

(statearr_77770_77829[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (14))){
var state_77717__$1 = state_77717;
var statearr_77771_77830 = state_77717__$1;
(statearr_77771_77830[(2)] = null);

(statearr_77771_77830[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (26))){
var inst_77626 = (state_77717[(8)]);
var inst_77652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77653 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_77654 = [inst_77626,inst_77653];
var inst_77655 = (new cljs.core.PersistentVector(null,2,(5),inst_77652,inst_77654,null));
var state_77717__$1 = state_77717;
var statearr_77772_77831 = state_77717__$1;
(statearr_77772_77831[(2)] = inst_77655);

(statearr_77772_77831[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (16))){
var inst_77616 = (state_77717[(2)]);
var inst_77617 = fluree.db.util.async.throw_err.call(null,inst_77616);
var state_77717__$1 = state_77717;
var statearr_77773_77832 = state_77717__$1;
(statearr_77773_77832[(2)] = inst_77617);

(statearr_77773_77832[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (38))){
var inst_77673 = (state_77717[(9)]);
var inst_77672 = (state_77717[(10)]);
var inst_77694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77695 = [inst_77673,inst_77672];
var inst_77696 = (new cljs.core.PersistentVector(null,2,(5),inst_77694,inst_77695,null));
var state_77717__$1 = state_77717;
var statearr_77774_77833 = state_77717__$1;
(statearr_77774_77833[(2)] = inst_77696);

(statearr_77774_77833[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (30))){
var state_77717__$1 = state_77717;
var statearr_77775_77834 = state_77717__$1;
(statearr_77775_77834[(2)] = null);

(statearr_77775_77834[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (10))){
var inst_77603 = (state_77717[(19)]);
var state_77717__$1 = state_77717;
var statearr_77776_77835 = state_77717__$1;
(statearr_77776_77835[(2)] = inst_77603);

(statearr_77776_77835[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (18))){
var state_77717__$1 = state_77717;
var statearr_77777_77836 = state_77717__$1;
(statearr_77777_77836[(2)] = null);

(statearr_77777_77836[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (42))){
var inst_77704 = (state_77717[(15)]);
var state_77717__$1 = state_77717;
var statearr_77778_77837 = state_77717__$1;
(statearr_77778_77837[(2)] = inst_77704);

(statearr_77778_77837[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (37))){
var inst_77673 = (state_77717[(9)]);
var inst_77672 = (state_77717[(10)]);
var inst_77691 = (state_77717[(2)]);
var inst_77692 = (inst_77673 < inst_77672);
var state_77717__$1 = (function (){var statearr_77779 = state_77717;
(statearr_77779[(21)] = inst_77691);

return statearr_77779;
})();
if(cljs.core.truth_(inst_77692)){
var statearr_77780_77838 = state_77717__$1;
(statearr_77780_77838[(1)] = (38));

} else {
var statearr_77781_77839 = state_77717__$1;
(statearr_77781_77839[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77718 === (8))){
var inst_77603 = (state_77717[(19)]);
var inst_77603__$1 = (state_77717[(2)]);
var inst_77604 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_77603__$1);
var state_77717__$1 = (function (){var statearr_77782 = state_77717;
(statearr_77782[(19)] = inst_77603__$1);

return statearr_77782;
})();
if(cljs.core.truth_(inst_77604)){
var statearr_77783_77840 = state_77717__$1;
(statearr_77783_77840[(1)] = (9));

} else {
var statearr_77784_77841 = state_77717__$1;
(statearr_77784_77841[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_77785 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77785[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_77785[(1)] = (1));

return statearr_77785;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_77717){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77786){var ex__2749__auto__ = e77786;
var statearr_77787_77842 = state_77717;
(statearr_77787_77842[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77717[(4)]))){
var statearr_77788_77843 = state_77717;
(statearr_77788_77843[(1)] = cljs.core.first.call(null,(state_77717[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77844 = state_77717;
state_77717 = G__77844;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_77717){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_77717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77789 = f__2769__auto__.call(null);
(statearr_77789[(6)] = c__2768__auto__);

return statearr_77789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__77846 = arguments.length;
switch (G__77846) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77940){
var state_val_77941 = (state_77940[(1)]);
if((state_val_77941 === (7))){
var inst_77872 = (state_77940[(7)]);
var inst_77875 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_77872);
var state_77940__$1 = state_77940;
var statearr_77942_77993 = state_77940__$1;
(statearr_77942_77993[(2)] = inst_77875);

(statearr_77942_77993[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (20))){
var inst_77911 = (state_77940[(8)]);
var inst_77914 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_77911);
var state_77940__$1 = state_77940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77940__$1,(23),inst_77914);
} else {
if((state_val_77941 === (27))){
var inst_77920 = (state_77940[(9)]);
var inst_77926 = cljs.core.doall.call(null,inst_77920);
var state_77940__$1 = state_77940;
var statearr_77943_77994 = state_77940__$1;
(statearr_77943_77994[(2)] = inst_77926);

(statearr_77943_77994[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (1))){
var state_77940__$1 = state_77940;
var statearr_77944_77995 = state_77940__$1;
(statearr_77944_77995[(2)] = null);

(statearr_77944_77995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (24))){
var inst_77920 = (state_77940[(9)]);
var inst_77923 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_77924 = cljs.core.sequential_QMARK_.call(null,inst_77920);
var state_77940__$1 = (function (){var statearr_77945 = state_77940;
(statearr_77945[(10)] = inst_77923);

return statearr_77945;
})();
if(inst_77924){
var statearr_77946_77996 = state_77940__$1;
(statearr_77946_77996[(1)] = (27));

} else {
var statearr_77947_77997 = state_77940__$1;
(statearr_77947_77997[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (4))){
var inst_77847 = (state_77940[(2)]);
var inst_77848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77849 = [inst_77847];
var inst_77850 = (new cljs.core.PersistentVector(null,1,(5),inst_77848,inst_77849,null));
var inst_77851 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77850);
var inst_77852 = cljs.core.ex_data.call(null,inst_77847);
var inst_77853 = cljs.core.ex_message.call(null,inst_77847);
var inst_77854 = cljs.core.assoc.call(null,inst_77852,new cljs.core.Keyword(null,"message","message",-406056002),inst_77853);
var state_77940__$1 = (function (){var statearr_77948 = state_77940;
(statearr_77948[(11)] = inst_77851);

return statearr_77948;
})();
var statearr_77949_77998 = state_77940__$1;
(statearr_77949_77998[(2)] = inst_77854);

(statearr_77949_77998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (15))){
var inst_77872 = (state_77940[(7)]);
var inst_77885 = (state_77940[(2)]);
var inst_77886 = cljs.core.ex_info.call(null,inst_77885,inst_77872);
var inst_77887 = (function(){throw inst_77886})();
var state_77940__$1 = state_77940;
var statearr_77950_77999 = state_77940__$1;
(statearr_77950_77999[(2)] = inst_77887);

(statearr_77950_77999[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (21))){
var inst_77911 = (state_77940[(8)]);
var state_77940__$1 = state_77940;
var statearr_77951_78000 = state_77940__$1;
(statearr_77951_78000[(2)] = inst_77911);

(statearr_77951_78000[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (13))){
var inst_77880 = (state_77940[(12)]);
var state_77940__$1 = state_77940;
var statearr_77952_78001 = state_77940__$1;
(statearr_77952_78001[(2)] = inst_77880);

(statearr_77952_78001[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (22))){
var inst_77920 = (state_77940[(2)]);
var inst_77921 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_77940__$1 = (function (){var statearr_77953 = state_77940;
(statearr_77953[(9)] = inst_77920);

return statearr_77953;
})();
if(cljs.core.truth_(inst_77921)){
var statearr_77954_78002 = state_77940__$1;
(statearr_77954_78002[(1)] = (24));

} else {
var statearr_77955_78003 = state_77940__$1;
(statearr_77955_78003[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (29))){
var inst_77864 = (state_77940[(13)]);
var inst_77923 = (state_77940[(10)]);
var inst_77929 = (state_77940[(2)]);
var inst_77930 = fluree.db.util.core.response_time_formatted.call(null,inst_77864);
var inst_77931 = [(200),inst_77929,(100),inst_77930];
var inst_77932 = cljs.core.PersistentHashMap.fromArrays(inst_77923,inst_77931);
var state_77940__$1 = state_77940;
var statearr_77956_78004 = state_77940__$1;
(statearr_77956_78004[(2)] = inst_77932);

(statearr_77956_78004[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (6))){
var inst_77873 = (state_77940[(14)]);
var inst_77872 = (state_77940[(7)]);
var inst_77871 = (state_77940[(2)]);
var inst_77872__$1 = fluree.db.util.async.throw_err.call(null,inst_77871);
var inst_77873__$1 = cljs.core.map_QMARK_.call(null,inst_77872__$1);
var state_77940__$1 = (function (){var statearr_77957 = state_77940;
(statearr_77957[(14)] = inst_77873__$1);

(statearr_77957[(7)] = inst_77872__$1);

return statearr_77957;
})();
if(inst_77873__$1){
var statearr_77958_78005 = state_77940__$1;
(statearr_77958_78005[(1)] = (7));

} else {
var statearr_77959_78006 = state_77940__$1;
(statearr_77959_78006[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (28))){
var inst_77920 = (state_77940[(9)]);
var state_77940__$1 = state_77940;
var statearr_77960_78007 = state_77940__$1;
(statearr_77960_78007[(2)] = inst_77920);

(statearr_77960_78007[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (25))){
var inst_77920 = (state_77940[(9)]);
var state_77940__$1 = state_77940;
var statearr_77961_78008 = state_77940__$1;
(statearr_77961_78008[(2)] = inst_77920);

(statearr_77961_78008[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (17))){
var inst_77903 = cljs.core.pr_str.call(null,query_map);
var inst_77904 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_77903].join('');
var inst_77905 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77906 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77907 = cljs.core.PersistentHashMap.fromArrays(inst_77905,inst_77906);
var inst_77908 = cljs.core.ex_info.call(null,inst_77904,inst_77907);
var inst_77909 = (function(){throw inst_77908})();
var state_77940__$1 = state_77940;
var statearr_77962_78009 = state_77940__$1;
(statearr_77962_78009[(2)] = inst_77909);

(statearr_77962_78009[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (3))){
var inst_77938 = (state_77940[(2)]);
var state_77940__$1 = state_77940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77940__$1,inst_77938);
} else {
if((state_val_77941 === (12))){
var inst_77872 = (state_77940[(7)]);
var inst_77890 = (state_77940[(2)]);
var inst_77891 = cljs.core.nth.call(null,inst_77872,(0),null);
var inst_77892 = cljs.core.nth.call(null,inst_77872,(1),null);
var inst_77893 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_77894 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_77895 = cljs.core.keys.call(null,inst_77894);
var inst_77896 = cljs.core._EQ_.call(null,inst_77893,inst_77895);
var state_77940__$1 = (function (){var statearr_77963 = state_77940;
(statearr_77963[(15)] = inst_77890);

(statearr_77963[(16)] = inst_77891);

(statearr_77963[(17)] = inst_77892);

return statearr_77963;
})();
if(inst_77896){
var statearr_77964_78010 = state_77940__$1;
(statearr_77964_78010[(1)] = (16));

} else {
var statearr_77965_78011 = state_77940__$1;
(statearr_77965_78011[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (2))){
var _ = (function (){var statearr_77966 = state_77940;
(statearr_77966[(4)] = cljs.core.cons.call(null,(5),(state_77940[(4)])));

return statearr_77966;
})();
var inst_77864 = fluree.db.util.core.current_time_millis.call(null);
var inst_77865 = db;
var inst_77866 = cljs.core.__destructure_map.call(null,inst_77865);
var inst_77867 = cljs.core.get.call(null,inst_77866,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_77868 = cljs.core.get.call(null,inst_77866,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_77869 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_77940__$1 = (function (){var statearr_77967 = state_77940;
(statearr_77967[(18)] = inst_77867);

(statearr_77967[(13)] = inst_77864);

(statearr_77967[(19)] = inst_77868);

return statearr_77967;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77940__$1,(6),inst_77869);
} else {
if((state_val_77941 === (23))){
var inst_77916 = (state_77940[(2)]);
var inst_77917 = fluree.db.util.async.throw_err.call(null,inst_77916);
var state_77940__$1 = state_77940;
var statearr_77968_78012 = state_77940__$1;
(statearr_77968_78012[(2)] = inst_77917);

(statearr_77968_78012[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (19))){
var inst_77900 = (state_77940[(2)]);
var inst_77901 = fluree.db.util.async.throw_err.call(null,inst_77900);
var state_77940__$1 = state_77940;
var statearr_77969_78013 = state_77940__$1;
(statearr_77969_78013[(2)] = inst_77901);

(statearr_77969_78013[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (11))){
var state_77940__$1 = state_77940;
var statearr_77971_78014 = state_77940__$1;
(statearr_77971_78014[(2)] = null);

(statearr_77971_78014[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (9))){
var inst_77878 = (state_77940[(2)]);
var state_77940__$1 = state_77940;
if(cljs.core.truth_(inst_77878)){
var statearr_77972_78015 = state_77940__$1;
(statearr_77972_78015[(1)] = (10));

} else {
var statearr_77973_78016 = state_77940__$1;
(statearr_77973_78016[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (5))){
var _ = (function (){var statearr_77974 = state_77940;
(statearr_77974[(4)] = cljs.core.rest.call(null,(state_77940[(4)])));

return statearr_77974;
})();
var state_77940__$1 = state_77940;
var ex77970 = (state_77940__$1[(2)]);
var statearr_77975_78017 = state_77940__$1;
(statearr_77975_78017[(5)] = ex77970);


var statearr_77976_78018 = state_77940__$1;
(statearr_77976_78018[(1)] = (4));

(statearr_77976_78018[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (14))){
var inst_77867 = (state_77940[(18)]);
var inst_77868 = (state_77940[(19)]);
var inst_77883 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77867),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77868)].join('');
var state_77940__$1 = state_77940;
var statearr_77977_78019 = state_77940__$1;
(statearr_77977_78019[(2)] = inst_77883);

(statearr_77977_78019[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (26))){
var inst_77935 = (state_77940[(2)]);
var _ = (function (){var statearr_77978 = state_77940;
(statearr_77978[(4)] = cljs.core.rest.call(null,(state_77940[(4)])));

return statearr_77978;
})();
var state_77940__$1 = state_77940;
var statearr_77979_78020 = state_77940__$1;
(statearr_77979_78020[(2)] = inst_77935);

(statearr_77979_78020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (16))){
var inst_77891 = (state_77940[(16)]);
var inst_77892 = (state_77940[(17)]);
var inst_77898 = fluree.db.query.block.block_range.call(null,db,inst_77891,inst_77892,opts);
var state_77940__$1 = state_77940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77940__$1,(19),inst_77898);
} else {
if((state_val_77941 === (10))){
var inst_77880 = (state_77940[(12)]);
var inst_77872 = (state_77940[(7)]);
var inst_77880__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_77872);
var state_77940__$1 = (function (){var statearr_77980 = state_77940;
(statearr_77980[(12)] = inst_77880__$1);

return statearr_77980;
})();
if(cljs.core.truth_(inst_77880__$1)){
var statearr_77981_78021 = state_77940__$1;
(statearr_77981_78021[(1)] = (13));

} else {
var statearr_77982_78022 = state_77940__$1;
(statearr_77982_78022[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (18))){
var inst_77911 = (state_77940[(2)]);
var inst_77912 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_77940__$1 = (function (){var statearr_77983 = state_77940;
(statearr_77983[(8)] = inst_77911);

return statearr_77983;
})();
if(cljs.core.truth_(inst_77912)){
var statearr_77984_78023 = state_77940__$1;
(statearr_77984_78023[(1)] = (20));

} else {
var statearr_77985_78024 = state_77940__$1;
(statearr_77985_78024[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77941 === (8))){
var inst_77873 = (state_77940[(14)]);
var state_77940__$1 = state_77940;
var statearr_77986_78025 = state_77940__$1;
(statearr_77986_78025[(2)] = inst_77873);

(statearr_77986_78025[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_77987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77987[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_77987[(1)] = (1));

return statearr_77987;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_77940){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77988){var ex__2749__auto__ = e77988;
var statearr_77989_78026 = state_77940;
(statearr_77989_78026[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77940[(4)]))){
var statearr_77990_78027 = state_77940;
(statearr_77990_78027[(1)] = cljs.core.first.call(null,(state_77940[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78028 = state_77940;
state_77940 = G__78028;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_77940){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_77940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77991 = f__2769__auto__.call(null);
(statearr_77991[(6)] = c__2768__auto__);

return statearr_77991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__78030 = arguments.length;
switch (G__78030) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78225){
var state_val_78226 = (state_78225[(1)]);
if((state_val_78226 === (62))){
var inst_78223 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78225__$1,inst_78223);
} else {
if((state_val_78226 === (7))){
var inst_78051 = (state_78225[(7)]);
var inst_78061 = cljs.core.not_EQ_.call(null,(1),inst_78051);
var state_78225__$1 = state_78225;
var statearr_78227_78318 = state_78225__$1;
(statearr_78227_78318[(2)] = inst_78061);

(statearr_78227_78318[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (59))){
var inst_78211 = (state_78225[(2)]);
var inst_78212 = fluree.db.util.async.throw_err.call(null,inst_78211);
var state_78225__$1 = state_78225;
var statearr_78228_78319 = state_78225__$1;
(statearr_78228_78319[(2)] = inst_78212);

(statearr_78228_78319[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (20))){
var inst_78119 = (state_78225[(8)]);
var inst_78127 = (state_78225[(9)]);
var inst_78119__$1 = (state_78225[(2)]);
var inst_78120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78121 = cljs.core.get.call(null,inst_78119__$1,(0));
var inst_78122 = cljs.core.get.call(null,inst_78119__$1,(1));
var inst_78123 = cljs.core.get.call(null,inst_78119__$1,(2));
var inst_78124 = cljs.core.get.call(null,inst_78119__$1,(3));
var inst_78125 = [inst_78121,inst_78122,inst_78123,inst_78124];
var inst_78126 = (new cljs.core.PersistentVector(null,4,(5),inst_78120,inst_78125,null));
var inst_78127__$1 = cljs.core.nth.call(null,inst_78126,(0),null);
var inst_78128 = cljs.core.nth.call(null,inst_78126,(1),null);
var inst_78129 = cljs.core.nth.call(null,inst_78126,(2),null);
var inst_78130 = cljs.core.nth.call(null,inst_78126,(3),null);
var inst_78131 = (inst_78127__$1 == null);
var inst_78132 = cljs.core.not.call(null,inst_78131);
var state_78225__$1 = (function (){var statearr_78229 = state_78225;
(statearr_78229[(8)] = inst_78119__$1);

(statearr_78229[(10)] = inst_78128);

(statearr_78229[(9)] = inst_78127__$1);

(statearr_78229[(11)] = inst_78130);

(statearr_78229[(12)] = inst_78129);

return statearr_78229;
})();
if(inst_78132){
var statearr_78230_78320 = state_78225__$1;
(statearr_78230_78320[(1)] = (30));

} else {
var statearr_78231_78321 = state_78225__$1;
(statearr_78231_78321[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (58))){
var inst_78059 = (state_78225[(13)]);
var inst_78215 = (state_78225[(2)]);
var state_78225__$1 = (function (){var statearr_78232 = state_78225;
(statearr_78232[(14)] = inst_78215);

return statearr_78232;
})();
if(cljs.core.truth_(inst_78059)){
var statearr_78233_78322 = state_78225__$1;
(statearr_78233_78322[(1)] = (60));

} else {
var statearr_78234_78323 = state_78225__$1;
(statearr_78234_78323[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (60))){
var inst_78215 = (state_78225[(14)]);
var inst_78203 = (state_78225[(15)]);
var inst_78217 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_78218 = cljs.core.count.call(null,inst_78203);
var inst_78219 = [inst_78215,inst_78218,(200)];
var inst_78220 = cljs.core.PersistentHashMap.fromArrays(inst_78217,inst_78219);
var state_78225__$1 = state_78225;
var statearr_78235_78324 = state_78225__$1;
(statearr_78235_78324[(2)] = inst_78220);

(statearr_78235_78324[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (27))){
var inst_78038 = (state_78225[(16)]);
var inst_78107 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78038)].join('');
var inst_78108 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78109 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78110 = cljs.core.PersistentHashMap.fromArrays(inst_78108,inst_78109);
var inst_78111 = cljs.core.ex_info.call(null,inst_78107,inst_78110);
var inst_78112 = (function(){throw inst_78111})();
var state_78225__$1 = state_78225;
var statearr_78236_78325 = state_78225__$1;
(statearr_78236_78325[(2)] = inst_78112);

(statearr_78236_78325[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (1))){
var inst_78035 = query_map;
var inst_78036 = cljs.core.__destructure_map.call(null,inst_78035);
var inst_78037 = cljs.core.get.call(null,inst_78036,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78038 = cljs.core.get.call(null,inst_78036,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_78039 = cljs.core.get.call(null,inst_78036,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_78225__$1 = (function (){var statearr_78237 = state_78225;
(statearr_78237[(16)] = inst_78038);

(statearr_78237[(17)] = inst_78039);

(statearr_78237[(18)] = inst_78037);

return statearr_78237;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(2),sources);
} else {
if((state_val_78226 === (24))){
var inst_78038 = (state_78225[(16)]);
var inst_78096 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78038)].join('');
var inst_78097 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78098 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78099 = cljs.core.PersistentHashMap.fromArrays(inst_78097,inst_78098);
var inst_78100 = cljs.core.ex_info.call(null,inst_78096,inst_78099);
var inst_78101 = (function(){throw inst_78100})();
var state_78225__$1 = state_78225;
var statearr_78238_78326 = state_78225__$1;
(statearr_78238_78326[(2)] = inst_78101);

(statearr_78238_78326[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (55))){
var inst_78039 = (state_78225[(17)]);
var inst_78206 = (state_78225[(2)]);
var inst_78207 = fluree.db.util.async.throw_err.call(null,inst_78206);
var state_78225__$1 = (function (){var statearr_78239 = state_78225;
(statearr_78239[(19)] = inst_78207);

return statearr_78239;
})();
if(cljs.core.truth_(inst_78039)){
var statearr_78240_78327 = state_78225__$1;
(statearr_78240_78327[(1)] = (56));

} else {
var statearr_78241_78328 = state_78225__$1;
(statearr_78241_78328[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (39))){
var inst_78128 = (state_78225[(10)]);
var inst_78127 = (state_78225[(9)]);
var inst_78130 = (state_78225[(11)]);
var inst_78129 = (state_78225[(12)]);
var inst_78151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78153 = [inst_78128,inst_78127,inst_78129,inst_78130];
var inst_78154 = (new cljs.core.PersistentVector(null,4,(5),inst_78152,inst_78153,null));
var inst_78155 = [inst_78154,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_78156 = (new cljs.core.PersistentVector(null,2,(5),inst_78151,inst_78155,null));
var state_78225__$1 = state_78225;
var statearr_78242_78329 = state_78225__$1;
(statearr_78242_78329[(2)] = inst_78156);

(statearr_78242_78329[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (46))){
var inst_78161 = (state_78225[(20)]);
var state_78225__$1 = state_78225;
var statearr_78243_78330 = state_78225__$1;
(statearr_78243_78330[(2)] = inst_78161);

(statearr_78243_78330[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (4))){
var state_78225__$1 = state_78225;
var statearr_78244_78331 = state_78225__$1;
(statearr_78244_78331[(2)] = null);

(statearr_78244_78331[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (54))){
var inst_78203 = (state_78225[(15)]);
var inst_78042 = (state_78225[(21)]);
var inst_78202 = (state_78225[(2)]);
var inst_78203__$1 = fluree.db.util.async.throw_err.call(null,inst_78202);
var inst_78204 = fluree.db.api_js.format_history_resp.call(null,inst_78042,inst_78203__$1);
var state_78225__$1 = (function (){var statearr_78245 = state_78225;
(statearr_78245[(15)] = inst_78203__$1);

return statearr_78245;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(55),inst_78204);
} else {
if((state_val_78226 === (15))){
var inst_78042 = (state_78225[(21)]);
var inst_78083 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_78042);
var state_78225__$1 = state_78225;
var statearr_78246_78332 = state_78225__$1;
(statearr_78246_78332[(2)] = inst_78083);

(statearr_78246_78332[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (48))){
var inst_78128 = (state_78225[(10)]);
var inst_78127 = (state_78225[(9)]);
var inst_78130 = (state_78225[(11)]);
var inst_78129 = (state_78225[(12)]);
var inst_78172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78174 = [inst_78128,inst_78129,inst_78127,inst_78130];
var inst_78175 = (new cljs.core.PersistentVector(null,4,(5),inst_78173,inst_78174,null));
var inst_78176 = [inst_78175,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_78177 = (new cljs.core.PersistentVector(null,2,(5),inst_78172,inst_78176,null));
var state_78225__$1 = state_78225;
var statearr_78247_78333 = state_78225__$1;
(statearr_78247_78333[(2)] = inst_78177);

(statearr_78247_78333[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (50))){
var inst_78190 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78248_78334 = state_78225__$1;
(statearr_78248_78334[(2)] = inst_78190);

(statearr_78248_78334[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (21))){
var inst_78038 = (state_78225[(16)]);
var inst_78094 = cljs.core.empty_QMARK_.call(null,inst_78038);
var state_78225__$1 = state_78225;
if(inst_78094){
var statearr_78249_78335 = state_78225__$1;
(statearr_78249_78335[(1)] = (24));

} else {
var statearr_78250_78336 = state_78225__$1;
(statearr_78250_78336[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (31))){
var inst_78138 = (state_78225[(22)]);
var inst_78127 = (state_78225[(9)]);
var inst_78138__$1 = (inst_78127 == null);
var state_78225__$1 = (function (){var statearr_78251 = state_78225;
(statearr_78251[(22)] = inst_78138__$1);

return statearr_78251;
})();
if(cljs.core.truth_(inst_78138__$1)){
var statearr_78252_78337 = state_78225__$1;
(statearr_78252_78337[(1)] = (33));

} else {
var statearr_78253_78338 = state_78225__$1;
(statearr_78253_78338[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (32))){
var inst_78075 = (state_78225[(23)]);
var inst_78085 = (state_78225[(24)]);
var inst_78042 = (state_78225[(21)]);
var inst_78194 = (state_78225[(2)]);
var inst_78195 = cljs.core.nth.call(null,inst_78194,(0),null);
var inst_78196 = cljs.core.nth.call(null,inst_78194,(1),null);
var inst_78197 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_78198 = [inst_78075,inst_78085];
var inst_78199 = cljs.core.PersistentHashMap.fromArrays(inst_78197,inst_78198);
var inst_78200 = fluree.db.query.range.time_range.call(null,inst_78042,inst_78196,cljs.core._EQ_,inst_78195,inst_78199);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(54),inst_78200);
} else {
if((state_val_78226 === (40))){
var inst_78158 = (state_78225[(25)]);
var inst_78127 = (state_78225[(9)]);
var inst_78158__$1 = (inst_78127 == null);
var state_78225__$1 = (function (){var statearr_78254 = state_78225;
(statearr_78254[(25)] = inst_78158__$1);

return statearr_78254;
})();
if(cljs.core.truth_(inst_78158__$1)){
var statearr_78255_78339 = state_78225__$1;
(statearr_78255_78339[(1)] = (42));

} else {
var statearr_78256_78340 = state_78225__$1;
(statearr_78256_78340[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (56))){
var inst_78207 = (state_78225[(19)]);
var inst_78042 = (state_78225[(21)]);
var inst_78209 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_78042,inst_78207);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(59),inst_78209);
} else {
if((state_val_78226 === (33))){
var inst_78141 = (state_78225[(26)]);
var inst_78128 = (state_78225[(10)]);
var inst_78140 = (inst_78128 == null);
var inst_78141__$1 = cljs.core.not.call(null,inst_78140);
var state_78225__$1 = (function (){var statearr_78257 = state_78225;
(statearr_78257[(26)] = inst_78141__$1);

return statearr_78257;
})();
if(inst_78141__$1){
var statearr_78258_78341 = state_78225__$1;
(statearr_78258_78341[(1)] = (36));

} else {
var statearr_78259_78342 = state_78225__$1;
(statearr_78259_78342[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (13))){
var inst_78069 = (state_78225[(2)]);
var inst_78070 = fluree.db.util.async.throw_err.call(null,inst_78069);
var inst_78071 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_78070);
var inst_78072 = (inst_78071 - (1));
var state_78225__$1 = state_78225;
var statearr_78260_78343 = state_78225__$1;
(statearr_78260_78343[(2)] = inst_78072);

(statearr_78260_78343[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (22))){
var state_78225__$1 = state_78225;
var statearr_78261_78344 = state_78225__$1;
(statearr_78261_78344[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (36))){
var inst_78129 = (state_78225[(12)]);
var inst_78143 = (inst_78129 == null);
var state_78225__$1 = state_78225;
var statearr_78263_78345 = state_78225__$1;
(statearr_78263_78345[(2)] = inst_78143);

(statearr_78263_78345[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (41))){
var inst_78192 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78264_78346 = state_78225__$1;
(statearr_78264_78346[(2)] = inst_78192);

(statearr_78264_78346[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (43))){
var inst_78158 = (state_78225[(25)]);
var state_78225__$1 = state_78225;
var statearr_78265_78347 = state_78225__$1;
(statearr_78265_78347[(2)] = inst_78158);

(statearr_78265_78347[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (61))){
var inst_78215 = (state_78225[(14)]);
var state_78225__$1 = state_78225;
var statearr_78266_78348 = state_78225__$1;
(statearr_78266_78348[(2)] = inst_78215);

(statearr_78266_78348[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (29))){
var inst_78115 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78267_78349 = state_78225__$1;
(statearr_78267_78349[(2)] = inst_78115);

(statearr_78267_78349[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (44))){
var inst_78170 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
if(cljs.core.truth_(inst_78170)){
var statearr_78268_78350 = state_78225__$1;
(statearr_78268_78350[(1)] = (48));

} else {
var statearr_78269_78351 = state_78225__$1;
(statearr_78269_78351[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (6))){
var inst_78046 = (state_78225[(2)]);
var inst_78047 = fluree.db.util.async.throw_err.call(null,inst_78046);
var state_78225__$1 = state_78225;
var statearr_78270_78352 = state_78225__$1;
(statearr_78270_78352[(2)] = inst_78047);

(statearr_78270_78352[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (28))){
var state_78225__$1 = state_78225;
var statearr_78271_78353 = state_78225__$1;
(statearr_78271_78353[(2)] = null);

(statearr_78271_78353[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (51))){
var inst_78038 = (state_78225[(16)]);
var inst_78180 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78038)].join('');
var inst_78181 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78182 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78183 = cljs.core.PersistentHashMap.fromArrays(inst_78181,inst_78182);
var inst_78184 = cljs.core.ex_info.call(null,inst_78180,inst_78183);
var inst_78185 = (function(){throw inst_78184})();
var state_78225__$1 = state_78225;
var statearr_78272_78354 = state_78225__$1;
(statearr_78272_78354[(2)] = inst_78185);

(statearr_78272_78354[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (25))){
var inst_78038 = (state_78225[(16)]);
var state_78225__$1 = state_78225;
var statearr_78273_78355 = state_78225__$1;
(statearr_78273_78355[(2)] = inst_78038);

(statearr_78273_78355[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (34))){
var inst_78138 = (state_78225[(22)]);
var state_78225__$1 = state_78225;
var statearr_78274_78356 = state_78225__$1;
(statearr_78274_78356[(2)] = inst_78138);

(statearr_78274_78356[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (17))){
var inst_78079 = (state_78225[(2)]);
var inst_78080 = fluree.db.util.async.throw_err.call(null,inst_78079);
var inst_78081 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_78080);
var state_78225__$1 = state_78225;
var statearr_78275_78357 = state_78225__$1;
(statearr_78275_78357[(2)] = inst_78081);

(statearr_78275_78357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (3))){
var inst_78042 = (state_78225[(21)]);
var inst_78044 = fluree.db.api_js.resolve_block_range.call(null,inst_78042,query_map);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(6),inst_78044);
} else {
if((state_val_78226 === (12))){
var inst_78052 = (state_78225[(27)]);
var inst_78075 = (state_78225[(2)]);
var state_78225__$1 = (function (){var statearr_78276 = state_78225;
(statearr_78276[(23)] = inst_78075);

return statearr_78276;
})();
if(cljs.core.truth_(inst_78052)){
var statearr_78277_78358 = state_78225__$1;
(statearr_78277_78358[(1)] = (14));

} else {
var statearr_78278_78359 = state_78225__$1;
(statearr_78278_78359[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (2))){
var inst_78037 = (state_78225[(18)]);
var inst_78041 = (state_78225[(2)]);
var inst_78042 = fluree.db.util.async.throw_err.call(null,inst_78041);
var state_78225__$1 = (function (){var statearr_78279 = state_78225;
(statearr_78279[(21)] = inst_78042);

return statearr_78279;
})();
if(cljs.core.truth_(inst_78037)){
var statearr_78280_78360 = state_78225__$1;
(statearr_78280_78360[(1)] = (3));

} else {
var statearr_78281_78361 = state_78225__$1;
(statearr_78281_78361[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (23))){
var inst_78117 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78282_78362 = state_78225__$1;
(statearr_78282_78362[(2)] = inst_78117);

(statearr_78282_78362[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (47))){
var inst_78167 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78283_78363 = state_78225__$1;
(statearr_78283_78363[(2)] = inst_78167);

(statearr_78283_78363[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (35))){
var inst_78149 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
if(cljs.core.truth_(inst_78149)){
var statearr_78284_78364 = state_78225__$1;
(statearr_78284_78364[(1)] = (39));

} else {
var statearr_78285_78365 = state_78225__$1;
(statearr_78285_78365[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (19))){
var inst_78038 = (state_78225[(16)]);
var inst_78092 = cljs.core.sequential_QMARK_.call(null,inst_78038);
var state_78225__$1 = state_78225;
if(inst_78092){
var statearr_78286_78366 = state_78225__$1;
(statearr_78286_78366[(1)] = (21));

} else {
var statearr_78287_78367 = state_78225__$1;
(statearr_78287_78367[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (57))){
var inst_78207 = (state_78225[(19)]);
var state_78225__$1 = state_78225;
var statearr_78288_78368 = state_78225__$1;
(statearr_78288_78368[(2)] = inst_78207);

(statearr_78288_78368[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (11))){
var state_78225__$1 = state_78225;
var statearr_78289_78369 = state_78225__$1;
(statearr_78289_78369[(2)] = (-1));

(statearr_78289_78369[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (9))){
var inst_78064 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
if(cljs.core.truth_(inst_78064)){
var statearr_78290_78370 = state_78225__$1;
(statearr_78290_78370[(1)] = (10));

} else {
var statearr_78291_78371 = state_78225__$1;
(statearr_78291_78371[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (5))){
var inst_78051 = (state_78225[(7)]);
var inst_78050 = (state_78225[(2)]);
var inst_78051__$1 = cljs.core.nth.call(null,inst_78050,(0),null);
var inst_78052 = cljs.core.nth.call(null,inst_78050,(1),null);
var inst_78059 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_78225__$1 = (function (){var statearr_78292 = state_78225;
(statearr_78292[(13)] = inst_78059);

(statearr_78292[(7)] = inst_78051__$1);

(statearr_78292[(27)] = inst_78052);

return statearr_78292;
})();
if(cljs.core.truth_(inst_78051__$1)){
var statearr_78293_78372 = state_78225__$1;
(statearr_78293_78372[(1)] = (7));

} else {
var statearr_78294_78373 = state_78225__$1;
(statearr_78294_78373[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (14))){
var inst_78052 = (state_78225[(27)]);
var inst_78042 = (state_78225[(21)]);
var inst_78077 = fluree.db.time_travel.as_of_block.call(null,inst_78042,inst_78052);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(17),inst_78077);
} else {
if((state_val_78226 === (45))){
var inst_78129 = (state_78225[(12)]);
var inst_78163 = (inst_78129 == null);
var inst_78164 = cljs.core.not.call(null,inst_78163);
var state_78225__$1 = state_78225;
var statearr_78295_78374 = state_78225__$1;
(statearr_78295_78374[(2)] = inst_78164);

(statearr_78295_78374[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (53))){
var inst_78188 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78296_78375 = state_78225__$1;
(statearr_78296_78375[(2)] = inst_78188);

(statearr_78296_78375[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (26))){
var inst_78104 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78297_78376 = state_78225__$1;
(statearr_78297_78376[(2)] = inst_78104);

(statearr_78297_78376[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (16))){
var inst_78038 = (state_78225[(16)]);
var inst_78085 = (state_78225[(2)]);
var inst_78086 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_78038);
var state_78225__$1 = (function (){var statearr_78298 = state_78225;
(statearr_78298[(24)] = inst_78085);

return statearr_78298;
})();
if(inst_78086){
var statearr_78299_78377 = state_78225__$1;
(statearr_78299_78377[(1)] = (18));

} else {
var statearr_78300_78378 = state_78225__$1;
(statearr_78300_78378[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (38))){
var inst_78146 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
var statearr_78301_78379 = state_78225__$1;
(statearr_78301_78379[(2)] = inst_78146);

(statearr_78301_78379[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (30))){
var inst_78119 = (state_78225[(8)]);
var inst_78134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78135 = [inst_78119,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_78136 = (new cljs.core.PersistentVector(null,2,(5),inst_78134,inst_78135,null));
var state_78225__$1 = state_78225;
var statearr_78302_78380 = state_78225__$1;
(statearr_78302_78380[(2)] = inst_78136);

(statearr_78302_78380[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (10))){
var inst_78051 = (state_78225[(7)]);
var inst_78042 = (state_78225[(21)]);
var inst_78066 = (inst_78051 - (1));
var inst_78067 = fluree.db.time_travel.as_of_block.call(null,inst_78042,inst_78066);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78225__$1,(13),inst_78067);
} else {
if((state_val_78226 === (18))){
var inst_78038 = (state_78225[(16)]);
var inst_78088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78089 = [inst_78038];
var inst_78090 = (new cljs.core.PersistentVector(null,1,(5),inst_78088,inst_78089,null));
var state_78225__$1 = state_78225;
var statearr_78303_78381 = state_78225__$1;
(statearr_78303_78381[(2)] = inst_78090);

(statearr_78303_78381[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (52))){
var state_78225__$1 = state_78225;
var statearr_78304_78382 = state_78225__$1;
(statearr_78304_78382[(2)] = null);

(statearr_78304_78382[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (42))){
var inst_78161 = (state_78225[(20)]);
var inst_78128 = (state_78225[(10)]);
var inst_78160 = (inst_78128 == null);
var inst_78161__$1 = cljs.core.not.call(null,inst_78160);
var state_78225__$1 = (function (){var statearr_78305 = state_78225;
(statearr_78305[(20)] = inst_78161__$1);

return statearr_78305;
})();
if(inst_78161__$1){
var statearr_78306_78383 = state_78225__$1;
(statearr_78306_78383[(1)] = (45));

} else {
var statearr_78307_78384 = state_78225__$1;
(statearr_78307_78384[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (37))){
var inst_78141 = (state_78225[(26)]);
var state_78225__$1 = state_78225;
var statearr_78308_78385 = state_78225__$1;
(statearr_78308_78385[(2)] = inst_78141);

(statearr_78308_78385[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (8))){
var inst_78051 = (state_78225[(7)]);
var state_78225__$1 = state_78225;
var statearr_78309_78386 = state_78225__$1;
(statearr_78309_78386[(2)] = inst_78051);

(statearr_78309_78386[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (49))){
var state_78225__$1 = state_78225;
var statearr_78310_78387 = state_78225__$1;
(statearr_78310_78387[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_78312 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78312[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_78312[(1)] = (1));

return statearr_78312;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_78225){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78313){var ex__2749__auto__ = e78313;
var statearr_78314_78388 = state_78225;
(statearr_78314_78388[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78225[(4)]))){
var statearr_78315_78389 = state_78225;
(statearr_78315_78389[(1)] = cljs.core.first.call(null,(state_78225[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78390 = state_78225;
state_78225 = G__78390;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_78225){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_78225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78316 = f__2769__auto__.call(null);
(statearr_78316[(6)] = c__2768__auto__);

return statearr_78316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__78398 = arguments.length;
switch (G__78398) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__78391_SHARP_){
return cljs.core.dissoc.call(null,p1__78391_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78487){
var state_val_78488 = (state_78487[(1)]);
if((state_val_78488 === (7))){
var inst_78441 = (state_78487[(7)]);
var inst_78444 = (state_78487[(8)]);
var inst_78438 = (state_78487[(9)]);
var inst_78448 = (state_78487[(10)]);
var inst_78454 = (function (){var responses = inst_78438;
var responses_STAR_ = inst_78441;
var statuses = inst_78444;
var fuel = inst_78448;
return (function (p1__78394_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__78394_SHARP_);
});
})();
var inst_78455 = cljs.core.some.call(null,inst_78454,inst_78444);
var state_78487__$1 = state_78487;
if(cljs.core.truth_(inst_78455)){
var statearr_78489_78537 = state_78487__$1;
(statearr_78489_78537[(1)] = (9));

} else {
var statearr_78490_78538 = state_78487__$1;
(statearr_78490_78538[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (20))){
var inst_78482 = (state_78487[(2)]);
var state_78487__$1 = state_78487;
var statearr_78491_78539 = state_78487__$1;
(statearr_78491_78539[(2)] = inst_78482);

(statearr_78491_78539[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (1))){
var inst_78433 = cljs.core.async.chan.call(null,(1));
var inst_78434 = (function (){var c__2768__auto____$1 = inst_78433;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78431){
var state_val_78432 = (state_78431[(1)]);
if((state_val_78432 === (1))){
var inst_78399 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_78400 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_78401 = cljs.core.assoc.call(null,inst_78400,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_78402 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_78403 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_78404 = cljs.core.PersistentHashMap.EMPTY;
var inst_78405 = inst_78399;
var inst_78406 = inst_78401;
var inst_78407 = inst_78402;
var inst_78408 = inst_78403;
var inst_78409 = inst_78404;
var state_78431__$1 = (function (){var statearr_78492 = state_78431;
(statearr_78492[(7)] = inst_78408);

(statearr_78492[(8)] = inst_78407);

(statearr_78492[(9)] = inst_78406);

(statearr_78492[(10)] = inst_78405);

(statearr_78492[(11)] = inst_78409);

return statearr_78492;
})();
var statearr_78493_78540 = state_78431__$1;
(statearr_78493_78540[(2)] = null);

(statearr_78493_78540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78432 === (2))){
var inst_78406 = (state_78431[(9)]);
var inst_78411 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_78406);
var inst_78412 = cljs.core.merge.call(null,opts,inst_78411);
var inst_78413 = cljs.core.assoc.call(null,inst_78406,new cljs.core.Keyword(null,"opts","opts",155075701),inst_78412);
var inst_78414 = fluree.db.api_js.query_async.call(null,db,inst_78413,db_fn);
var state_78431__$1 = state_78431;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78431__$1,(4),inst_78414);
} else {
if((state_val_78432 === (3))){
var inst_78429 = (state_78431[(2)]);
var state_78431__$1 = state_78431;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78431__$1,inst_78429);
} else {
if((state_val_78432 === (4))){
var inst_78407 = (state_78431[(8)]);
var inst_78405 = (state_78431[(10)]);
var inst_78409 = (state_78431[(11)]);
var inst_78416 = (state_78431[(2)]);
var inst_78417 = cljs.core.assoc.call(null,inst_78409,inst_78405,inst_78416);
var inst_78418 = cljs.core.first.call(null,inst_78407);
var state_78431__$1 = (function (){var statearr_78494 = state_78431;
(statearr_78494[(12)] = inst_78417);

return statearr_78494;
})();
if(cljs.core.truth_(inst_78418)){
var statearr_78495_78541 = state_78431__$1;
(statearr_78495_78541[(1)] = (5));

} else {
var statearr_78496_78542 = state_78431__$1;
(statearr_78496_78542[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78432 === (5))){
var inst_78408 = (state_78431[(7)]);
var inst_78407 = (state_78431[(8)]);
var inst_78417 = (state_78431[(12)]);
var inst_78420 = cljs.core.first.call(null,inst_78407);
var inst_78421 = cljs.core.first.call(null,inst_78408);
var inst_78422 = cljs.core.rest.call(null,inst_78407);
var inst_78423 = cljs.core.rest.call(null,inst_78408);
var inst_78405 = inst_78420;
var inst_78406 = inst_78421;
var inst_78407__$1 = inst_78422;
var inst_78408__$1 = inst_78423;
var inst_78409 = inst_78417;
var state_78431__$1 = (function (){var statearr_78497 = state_78431;
(statearr_78497[(7)] = inst_78408__$1);

(statearr_78497[(8)] = inst_78407__$1);

(statearr_78497[(9)] = inst_78406);

(statearr_78497[(10)] = inst_78405);

(statearr_78497[(11)] = inst_78409);

return statearr_78497;
})();
var statearr_78498_78543 = state_78431__$1;
(statearr_78498_78543[(2)] = null);

(statearr_78498_78543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78432 === (6))){
var inst_78417 = (state_78431[(12)]);
var state_78431__$1 = state_78431;
var statearr_78499_78544 = state_78431__$1;
(statearr_78499_78544[(2)] = inst_78417);

(statearr_78499_78544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78432 === (7))){
var inst_78427 = (state_78431[(2)]);
var state_78431__$1 = state_78431;
var statearr_78500_78545 = state_78431__$1;
(statearr_78500_78545[(2)] = inst_78427);

(statearr_78500_78545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_78501 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78501[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_78501[(1)] = (1));

return statearr_78501;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_78431){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78502){var ex__2749__auto__ = e78502;
var statearr_78503_78546 = state_78431;
(statearr_78503_78546[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78431[(4)]))){
var statearr_78504_78547 = state_78431;
(statearr_78504_78547[(1)] = cljs.core.first.call(null,(state_78431[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78548 = state_78431;
state_78431 = G__78548;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_78431){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_78431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78505 = f__2769__auto__.call(null);
(statearr_78505[(6)] = c__2768__auto____$1);

return statearr_78505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_78435 = cljs.core.async.impl.dispatch.run.call(null,inst_78434);
var state_78487__$1 = (function (){var statearr_78506 = state_78487;
(statearr_78506[(11)] = inst_78435);

return statearr_78506;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78487__$1,(2),inst_78433);
} else {
if((state_val_78488 === (4))){
var inst_78438 = (state_78487[(9)]);
var state_78487__$1 = state_78487;
var statearr_78507_78549 = state_78487__$1;
(statearr_78507_78549[(2)] = inst_78438);

(statearr_78507_78549[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (15))){
var state_78487__$1 = state_78487;
var statearr_78508_78550 = state_78487__$1;
(statearr_78508_78550[(2)] = (400));

(statearr_78508_78550[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (13))){
var state_78487__$1 = state_78487;
var statearr_78509_78551 = state_78487__$1;
(statearr_78509_78551[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (6))){
var inst_78444 = (state_78487[(8)]);
var inst_78452 = cljs.core.first.call(null,inst_78444);
var state_78487__$1 = state_78487;
var statearr_78511_78552 = state_78487__$1;
(statearr_78511_78552[(2)] = inst_78452);

(statearr_78511_78552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (17))){
var inst_78465 = (state_78487[(2)]);
var state_78487__$1 = state_78487;
var statearr_78512_78553 = state_78487__$1;
(statearr_78512_78553[(2)] = inst_78465);

(statearr_78512_78553[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (3))){
var inst_78441 = (state_78487[(7)]);
var inst_78444 = (state_78487[(8)]);
var inst_78438 = (state_78487[(9)]);
var inst_78448 = (state_78487[(10)]);
var inst_78443 = cljs.core.vals.call(null,inst_78438);
var inst_78444__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_78443);
var inst_78445 = (function (){var responses = inst_78438;
var responses_STAR_ = inst_78441;
var statuses = inst_78444__$1;
return (function (p1__78392_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__78392_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_78446 = cljs.core.vals.call(null,inst_78438);
var inst_78447 = cljs.core.map.call(null,inst_78445,inst_78446);
var inst_78448__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_78447);
var inst_78449 = (function (){var responses = inst_78438;
var responses_STAR_ = inst_78441;
var statuses = inst_78444__$1;
var fuel = inst_78448__$1;
return (function (p1__78393_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__78393_SHARP_);
});
})();
var inst_78450 = cljs.core.every_QMARK_.call(null,inst_78449,inst_78444__$1);
var state_78487__$1 = (function (){var statearr_78513 = state_78487;
(statearr_78513[(8)] = inst_78444__$1);

(statearr_78513[(10)] = inst_78448__$1);

return statearr_78513;
})();
if(inst_78450){
var statearr_78514_78554 = state_78487__$1;
(statearr_78514_78554[(1)] = (6));

} else {
var statearr_78515_78555 = state_78487__$1;
(statearr_78515_78555[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (12))){
var state_78487__$1 = state_78487;
var statearr_78516_78556 = state_78487__$1;
(statearr_78516_78556[(2)] = (500));

(statearr_78516_78556[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (2))){
var inst_78438 = (state_78487[(9)]);
var inst_78437 = (state_78487[(2)]);
var inst_78438__$1 = fluree.db.util.async.throw_err.call(null,inst_78437);
var inst_78439 = (function (){var responses = inst_78438__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_78440 = cljs.core.PersistentHashMap.EMPTY;
var inst_78441 = cljs.core.reduce_kv.call(null,inst_78439,inst_78440,inst_78438__$1);
var state_78487__$1 = (function (){var statearr_78517 = state_78487;
(statearr_78517[(7)] = inst_78441);

(statearr_78517[(9)] = inst_78438__$1);

return statearr_78517;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_78518_78557 = state_78487__$1;
(statearr_78518_78557[(1)] = (3));

} else {
var statearr_78519_78558 = state_78487__$1;
(statearr_78519_78558[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (19))){
var inst_78441 = (state_78487[(7)]);
var inst_78471 = (state_78487[(12)]);
var inst_78448 = (state_78487[(10)]);
var inst_78480 = cljs.core.assoc.call(null,inst_78441,new cljs.core.Keyword(null,"status","status",-1997798413),inst_78471,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_78448);
var state_78487__$1 = state_78487;
var statearr_78520_78559 = state_78487__$1;
(statearr_78520_78559[(2)] = inst_78480);

(statearr_78520_78559[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (11))){
var inst_78469 = (state_78487[(2)]);
var state_78487__$1 = state_78487;
var statearr_78521_78560 = state_78487__$1;
(statearr_78521_78560[(2)] = inst_78469);

(statearr_78521_78560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (9))){
var state_78487__$1 = state_78487;
var statearr_78522_78561 = state_78487__$1;
(statearr_78522_78561[(2)] = (207));

(statearr_78522_78561[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (5))){
var inst_78485 = (state_78487[(2)]);
var state_78487__$1 = state_78487;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78487__$1,inst_78485);
} else {
if((state_val_78488 === (14))){
var inst_78467 = (state_78487[(2)]);
var state_78487__$1 = state_78487;
var statearr_78523_78562 = state_78487__$1;
(statearr_78523_78562[(2)] = inst_78467);

(statearr_78523_78562[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (16))){
var state_78487__$1 = state_78487;
var statearr_78524_78563 = state_78487__$1;
(statearr_78524_78563[(2)] = null);

(statearr_78524_78563[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (10))){
var inst_78441 = (state_78487[(7)]);
var inst_78444 = (state_78487[(8)]);
var inst_78438 = (state_78487[(9)]);
var inst_78448 = (state_78487[(10)]);
var inst_78458 = (function (){var responses = inst_78438;
var responses_STAR_ = inst_78441;
var statuses = inst_78444;
var fuel = inst_78448;
return (function (p1__78395_SHARP_){
return ((499) < p1__78395_SHARP_);
});
})();
var inst_78459 = cljs.core.some.call(null,inst_78458,inst_78444);
var state_78487__$1 = state_78487;
if(cljs.core.truth_(inst_78459)){
var statearr_78525_78564 = state_78487__$1;
(statearr_78525_78564[(1)] = (12));

} else {
var statearr_78526_78565 = state_78487__$1;
(statearr_78526_78565[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (18))){
var inst_78441 = (state_78487[(7)]);
var inst_78476 = (state_78487[(13)]);
var inst_78471 = (state_78487[(12)]);
var inst_78448 = (state_78487[(10)]);
var inst_78478 = cljs.core.assoc.call(null,inst_78441,new cljs.core.Keyword(null,"status","status",-1997798413),inst_78471,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_78448,new cljs.core.Keyword(null,"block","block",664686210),inst_78476);
var state_78487__$1 = state_78487;
var statearr_78527_78566 = state_78487__$1;
(statearr_78527_78566[(2)] = inst_78478);

(statearr_78527_78566[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78488 === (8))){
var inst_78441 = (state_78487[(7)]);
var inst_78444 = (state_78487[(8)]);
var inst_78476 = (state_78487[(13)]);
var inst_78438 = (state_78487[(9)]);
var inst_78471 = (state_78487[(12)]);
var inst_78448 = (state_78487[(10)]);
var inst_78471__$1 = (state_78487[(2)]);
var inst_78472 = (function (){var responses = inst_78438;
var responses_STAR_ = inst_78441;
var statuses = inst_78444;
var fuel = inst_78448;
var status = inst_78471__$1;
return (function (p1__78396_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__78396_SHARP_));
});
})();
var inst_78473 = cljs.core.vals.call(null,inst_78438);
var inst_78474 = cljs.core.filter.call(null,inst_78472,inst_78473);
var inst_78475 = cljs.core.first.call(null,inst_78474);
var inst_78476__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_78475);
var state_78487__$1 = (function (){var statearr_78528 = state_78487;
(statearr_78528[(13)] = inst_78476__$1);

(statearr_78528[(12)] = inst_78471__$1);

return statearr_78528;
})();
if(cljs.core.truth_(inst_78476__$1)){
var statearr_78529_78567 = state_78487__$1;
(statearr_78529_78567[(1)] = (18));

} else {
var statearr_78530_78568 = state_78487__$1;
(statearr_78530_78568[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_78531 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78531[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_78531[(1)] = (1));

return statearr_78531;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_78487){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78487);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78532){var ex__2749__auto__ = e78532;
var statearr_78533_78569 = state_78487;
(statearr_78533_78569[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78487[(4)]))){
var statearr_78534_78570 = state_78487;
(statearr_78534_78570[(1)] = cljs.core.first.call(null,(state_78487[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78571 = state_78487;
state_78487 = G__78571;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_78487){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_78487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78535 = f__2769__auto__.call(null);
(statearr_78535[(6)] = c__2768__auto__);

return statearr_78535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__78573 = arguments.length;
switch (G__78573) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__78574 = opts;
var map__78574__$1 = cljs.core.__destructure_map.call(null,map__78574);
var auth = cljs.core.get.call(null,map__78574__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__78574__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__78574__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__78574__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__78575 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__78575,(0),null);
var authority = cljs.core.nth.call(null,vec__78575,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e78578){var e = e78578;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__78581 = arguments.length;
switch (G__78581) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78615){
var state_val_78616 = (state_78615[(1)]);
if((state_val_78616 === (7))){
var state_78615__$1 = state_78615;
var statearr_78617_78638 = state_78615__$1;
(statearr_78617_78638[(2)] = opts);

(statearr_78617_78638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (1))){
var state_78615__$1 = state_78615;
var statearr_78618_78639 = state_78615__$1;
(statearr_78618_78639[(2)] = null);

(statearr_78618_78639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (4))){
var inst_78582 = (state_78615[(2)]);
var inst_78583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78584 = [inst_78582];
var inst_78585 = (new cljs.core.PersistentVector(null,1,(5),inst_78583,inst_78584,null));
var inst_78586 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78585);
var inst_78587 = cljs.core.ex_data.call(null,inst_78582);
var inst_78588 = cljs.core.ex_message.call(null,inst_78582);
var inst_78589 = cljs.core.assoc.call(null,inst_78587,new cljs.core.Keyword(null,"message","message",-406056002),inst_78588);
var state_78615__$1 = (function (){var statearr_78619 = state_78615;
(statearr_78619[(7)] = inst_78586);

return statearr_78619;
})();
var statearr_78620_78640 = state_78615__$1;
(statearr_78620_78640[(2)] = inst_78589);

(statearr_78620_78640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (6))){
var inst_78599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78600 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_78601 = (new cljs.core.PersistentVector(null,1,(5),inst_78599,inst_78600,null));
var inst_78602 = cljs.core.assoc_in.call(null,opts,inst_78601,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_78615__$1 = state_78615;
var statearr_78621_78641 = state_78615__$1;
(statearr_78621_78641[(2)] = inst_78602);

(statearr_78621_78641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (3))){
var inst_78613 = (state_78615[(2)]);
var state_78615__$1 = state_78615;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78615__$1,inst_78613);
} else {
if((state_val_78616 === (2))){
var _ = (function (){var statearr_78623 = state_78615;
(statearr_78623[(4)] = cljs.core.cons.call(null,(5),(state_78615[(4)])));

return statearr_78623;
})();
var inst_78595 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_78596 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_78597 = (inst_78596 == null);
var state_78615__$1 = (function (){var statearr_78624 = state_78615;
(statearr_78624[(8)] = inst_78595);

return statearr_78624;
})();
if(cljs.core.truth_(inst_78597)){
var statearr_78625_78642 = state_78615__$1;
(statearr_78625_78642[(1)] = (6));

} else {
var statearr_78626_78643 = state_78615__$1;
(statearr_78626_78643[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (9))){
var inst_78609 = (state_78615[(2)]);
var inst_78610 = fluree.db.util.async.throw_err.call(null,inst_78609);
var _ = (function (){var statearr_78627 = state_78615;
(statearr_78627[(4)] = cljs.core.rest.call(null,(state_78615[(4)])));

return statearr_78627;
})();
var state_78615__$1 = state_78615;
var statearr_78628_78644 = state_78615__$1;
(statearr_78628_78644[(2)] = inst_78610);

(statearr_78628_78644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (5))){
var _ = (function (){var statearr_78629 = state_78615;
(statearr_78629[(4)] = cljs.core.rest.call(null,(state_78615[(4)])));

return statearr_78629;
})();
var state_78615__$1 = state_78615;
var ex78622 = (state_78615__$1[(2)]);
var statearr_78630_78645 = state_78615__$1;
(statearr_78630_78645[(5)] = ex78622);


var statearr_78631_78646 = state_78615__$1;
(statearr_78631_78646[(1)] = (4));

(statearr_78631_78646[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78616 === (8))){
var inst_78595 = (state_78615[(8)]);
var inst_78605 = (state_78615[(2)]);
var inst_78606 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_78595,inst_78605);
var inst_78607 = fluree.db.operations.command_async.call(null,conn,inst_78606);
var state_78615__$1 = state_78615;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78615__$1,(9),inst_78607);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_78632 = [null,null,null,null,null,null,null,null,null];
(statearr_78632[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_78632[(1)] = (1));

return statearr_78632;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_78615){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78615);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78633){var ex__2749__auto__ = e78633;
var statearr_78634_78647 = state_78615;
(statearr_78634_78647[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78615[(4)]))){
var statearr_78635_78648 = state_78615;
(statearr_78635_78648[(1)] = cljs.core.first.call(null,(state_78615[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78649 = state_78615;
state_78615 = G__78649;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_78615){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_78615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78636 = f__2769__auto__.call(null);
(statearr_78636[(6)] = c__2768__auto__);

return statearr_78636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

