// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__81191 = opts_SINGLEQUOTE_;
var map__81191__$1 = cljs.core.__destructure_map(map__81191);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81191__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__81193 = arguments.length;
switch (G__81193) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__81196 = arguments.length;
switch (G__81196) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__81199 = arguments.length;
switch (G__81199) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__81202 = arguments.length;
switch (G__81202) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__81205 = arguments.length;
switch (G__81205) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__81208 = arguments.length;
switch (G__81208) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___81217 = arguments.length;
var i__5770__auto___81218 = (0);
while(true){
if((i__5770__auto___81218 < len__5769__auto___81217)){
args__5775__auto__.push((arguments[i__5770__auto___81218]));

var G__81219 = (i__5770__auto___81218 + (1));
i__5770__auto___81218 = G__81219;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__81213){
var vec__81214 = p__81213;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81214,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq81210){
var G__81211 = cljs.core.first(seq81210);
var seq81210__$1 = cljs.core.next(seq81210);
var G__81212 = cljs.core.first(seq81210__$1);
var seq81210__$2 = cljs.core.next(seq81210__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81211,G__81212,seq81210__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81241){
var state_val_81242 = (state_81241[(1)]);
if((state_val_81242 === (1))){
var state_81241__$1 = state_81241;
var statearr_81243_81258 = state_81241__$1;
(statearr_81243_81258[(2)] = null);

(statearr_81243_81258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (2))){
var _ = (function (){var statearr_81244 = state_81241;
(statearr_81244[(4)] = cljs.core.cons((5),(state_81241[(4)])));

return statearr_81244;
})();
var state_81241__$1 = state_81241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81241__$1,(6),db);
} else {
if((state_val_81242 === (3))){
var inst_81239 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81241__$1,inst_81239);
} else {
if((state_val_81242 === (4))){
var inst_81220 = (state_81241[(2)]);
var inst_81221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81222 = [inst_81220];
var inst_81223 = (new cljs.core.PersistentVector(null,1,(5),inst_81221,inst_81222,null));
var inst_81224 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81223);
var inst_81225 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81220) : reject.call(null,inst_81220));
var state_81241__$1 = (function (){var statearr_81246 = state_81241;
(statearr_81246[(7)] = inst_81224);

return statearr_81246;
})();
var statearr_81247_81259 = state_81241__$1;
(statearr_81247_81259[(2)] = inst_81225);

(statearr_81247_81259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (5))){
var _ = (function (){var statearr_81248 = state_81241;
(statearr_81248[(4)] = cljs.core.rest((state_81241[(4)])));

return statearr_81248;
})();
var state_81241__$1 = state_81241;
var ex81245 = (state_81241__$1[(2)]);
var statearr_81249_81260 = state_81241__$1;
(statearr_81249_81260[(5)] = ex81245);


var statearr_81250_81261 = state_81241__$1;
(statearr_81250_81261[(1)] = (4));

(statearr_81250_81261[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (6))){
var inst_81232 = (state_81241[(2)]);
var inst_81233 = fluree.db.util.async.throw_err(inst_81232);
var inst_81234 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_81233);
var inst_81235 = cljs.core.clj__GT_js(inst_81234);
var inst_81236 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81235) : resolve.call(null,inst_81235));
var _ = (function (){var statearr_81251 = state_81241;
(statearr_81251[(4)] = cljs.core.rest((state_81241[(4)])));

return statearr_81251;
})();
var state_81241__$1 = state_81241;
var statearr_81252_81262 = state_81241__$1;
(statearr_81252_81262[(2)] = inst_81236);

(statearr_81252_81262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2727__auto__ = null;
var flureedb$db_schema_$_state_machine__2727__auto____0 = (function (){
var statearr_81253 = [null,null,null,null,null,null,null,null];
(statearr_81253[(0)] = flureedb$db_schema_$_state_machine__2727__auto__);

(statearr_81253[(1)] = (1));

return statearr_81253;
});
var flureedb$db_schema_$_state_machine__2727__auto____1 = (function (state_81241){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81241);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81254){var ex__2730__auto__ = e81254;
var statearr_81255_81263 = state_81241;
(statearr_81255_81263[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81241[(4)]))){
var statearr_81256_81264 = state_81241;
(statearr_81256_81264[(1)] = cljs.core.first((state_81241[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81265 = state_81241;
state_81241 = G__81265;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2727__auto__ = function(state_81241){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2727__auto____1.call(this,state_81241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2727__auto____0;
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2727__auto____1;
return flureedb$db_schema_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81257 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81257[(6)] = c__2749__auto__);

return statearr_81257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__81267 = arguments.length;
switch (G__81267) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81340){
var state_val_81341 = (state_81340[(1)]);
if((state_val_81341 === (7))){
var inst_81283 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_81340__$1 = state_81340;
var statearr_81342_81387 = state_81340__$1;
(statearr_81342_81387[(2)] = inst_81283);

(statearr_81342_81387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (20))){
var inst_81291 = (state_81340[(7)]);
var inst_81315 = (state_81340[(2)]);
var state_81340__$1 = (function (){var statearr_81343 = state_81340;
(statearr_81343[(8)] = inst_81315);

return statearr_81343;
})();
if(cljs.core.truth_(inst_81291)){
var statearr_81344_81388 = state_81340__$1;
(statearr_81344_81388[(1)] = (21));

} else {
var statearr_81345_81389 = state_81340__$1;
(statearr_81345_81389[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (1))){
var state_81340__$1 = state_81340;
var statearr_81346_81390 = state_81340__$1;
(statearr_81346_81390[(2)] = null);

(statearr_81346_81390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (24))){
var inst_81322 = (state_81340[(2)]);
var inst_81323 = fluree.db.util.async.throw_err(inst_81322);
var state_81340__$1 = state_81340;
var statearr_81347_81391 = state_81340__$1;
(statearr_81347_81391[(2)] = inst_81323);

(statearr_81347_81391[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (4))){
var inst_81268 = (state_81340[(2)]);
var inst_81269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81270 = [inst_81268];
var inst_81271 = (new cljs.core.PersistentVector(null,1,(5),inst_81269,inst_81270,null));
var inst_81272 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81271);
var inst_81273 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81268) : reject.call(null,inst_81268));
var state_81340__$1 = (function (){var statearr_81348 = state_81340;
(statearr_81348[(9)] = inst_81272);

return statearr_81348;
})();
var statearr_81349_81392 = state_81340__$1;
(statearr_81349_81392[(2)] = inst_81273);

(statearr_81349_81392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (15))){
var inst_81304 = (state_81340[(10)]);
var inst_81306 = fluree.db.util.core.without_nils(inst_81304);
var inst_81307 = fluree.db.util.json.stringify(inst_81306);
var state_81340__$1 = state_81340;
var statearr_81350_81393 = state_81340__$1;
(statearr_81350_81393[(2)] = inst_81307);

(statearr_81350_81393[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (21))){
var inst_81310 = (state_81340[(11)]);
var inst_81315 = (state_81340[(8)]);
var inst_81317 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_81318 = [inst_81310,inst_81315];
var inst_81319 = cljs.core.PersistentHashMap.fromArrays(inst_81317,inst_81318);
var inst_81320 = fluree.db.operations.command_async(conn,inst_81319);
var state_81340__$1 = state_81340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81340__$1,(24),inst_81320);
} else {
if((state_val_81341 === (13))){
var inst_81292 = (state_81340[(12)]);
var inst_81299 = (inst_81292 + (30000));
var state_81340__$1 = state_81340;
var statearr_81351_81394 = state_81340__$1;
(statearr_81351_81394[(2)] = inst_81299);

(statearr_81351_81394[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (22))){
var inst_81304 = (state_81340[(10)]);
var inst_81325 = fluree.db.operations.unsigned_command_async(conn,inst_81304);
var state_81340__$1 = state_81340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81340__$1,(25),inst_81325);
} else {
if((state_val_81341 === (6))){
var state_81340__$1 = state_81340;
var statearr_81352_81395 = state_81340__$1;
(statearr_81352_81395[(2)] = null);

(statearr_81352_81395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (25))){
var inst_81327 = (state_81340[(2)]);
var inst_81328 = fluree.db.util.async.throw_err(inst_81327);
var state_81340__$1 = state_81340;
var statearr_81353_81396 = state_81340__$1;
(statearr_81353_81396[(2)] = inst_81328);

(statearr_81353_81396[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (17))){
var inst_81291 = (state_81340[(7)]);
var inst_81310 = (state_81340[(2)]);
var state_81340__$1 = (function (){var statearr_81354 = state_81340;
(statearr_81354[(11)] = inst_81310);

return statearr_81354;
})();
if(cljs.core.truth_(inst_81291)){
var statearr_81355_81397 = state_81340__$1;
(statearr_81355_81397[(1)] = (18));

} else {
var statearr_81356_81398 = state_81340__$1;
(statearr_81356_81398[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (3))){
var inst_81338 = (state_81340[(2)]);
var state_81340__$1 = state_81340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81340__$1,inst_81338);
} else {
if((state_val_81341 === (12))){
var inst_81289 = (state_81340[(13)]);
var state_81340__$1 = state_81340;
var statearr_81357_81399 = state_81340__$1;
(statearr_81357_81399[(2)] = inst_81289);

(statearr_81357_81399[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (2))){
var _ = (function (){var statearr_81358 = state_81340;
(statearr_81358[(4)] = cljs.core.cons((5),(state_81340[(4)])));

return statearr_81358;
})();
var inst_81280 = (opts == null);
var state_81340__$1 = state_81340;
if(cljs.core.truth_(inst_81280)){
var statearr_81359_81400 = state_81340__$1;
(statearr_81359_81400[(1)] = (6));

} else {
var statearr_81360_81401 = state_81340__$1;
(statearr_81360_81401[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (23))){
var inst_81330 = (state_81340[(2)]);
var inst_81331 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_81332 = [(200),inst_81330];
var inst_81333 = cljs.core.PersistentHashMap.fromArrays(inst_81331,inst_81332);
var inst_81334 = cljs.core.clj__GT_js(inst_81333);
var inst_81335 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81334) : resolve.call(null,inst_81334));
var _ = (function (){var statearr_81361 = state_81340;
(statearr_81361[(4)] = cljs.core.rest((state_81340[(4)])));

return statearr_81361;
})();
var state_81340__$1 = state_81340;
var statearr_81362_81402 = state_81340__$1;
(statearr_81362_81402[(2)] = inst_81335);

(statearr_81362_81402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (19))){
var state_81340__$1 = state_81340;
var statearr_81363_81403 = state_81340__$1;
(statearr_81363_81403[(2)] = null);

(statearr_81363_81403[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (11))){
var inst_81289 = (state_81340[(13)]);
var inst_81296 = (state_81340[(2)]);
var state_81340__$1 = (function (){var statearr_81365 = state_81340;
(statearr_81365[(14)] = inst_81296);

return statearr_81365;
})();
if(cljs.core.truth_(inst_81289)){
var statearr_81366_81404 = state_81340__$1;
(statearr_81366_81404[(1)] = (12));

} else {
var statearr_81367_81405 = state_81340__$1;
(statearr_81367_81405[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (9))){
var inst_81288 = (state_81340[(15)]);
var state_81340__$1 = state_81340;
var statearr_81368_81406 = state_81340__$1;
(statearr_81368_81406[(2)] = inst_81288);

(statearr_81368_81406[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (5))){
var _ = (function (){var statearr_81369 = state_81340;
(statearr_81369[(4)] = cljs.core.rest((state_81340[(4)])));

return statearr_81369;
})();
var state_81340__$1 = state_81340;
var ex81364 = (state_81340__$1[(2)]);
var statearr_81370_81407 = state_81340__$1;
(statearr_81370_81407[(5)] = ex81364);


var statearr_81371_81408 = state_81340__$1;
(statearr_81371_81408[(1)] = (4));

(statearr_81371_81408[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (14))){
var inst_81291 = (state_81340[(7)]);
var inst_81296 = (state_81340[(14)]);
var inst_81301 = (state_81340[(2)]);
var inst_81302 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_81303 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_81296,inst_81301];
var inst_81304 = cljs.core.PersistentHashMap.fromArrays(inst_81302,inst_81303);
var state_81340__$1 = (function (){var statearr_81372 = state_81340;
(statearr_81372[(10)] = inst_81304);

return statearr_81372;
})();
if(cljs.core.truth_(inst_81291)){
var statearr_81373_81409 = state_81340__$1;
(statearr_81373_81409[(1)] = (15));

} else {
var statearr_81374_81410 = state_81340__$1;
(statearr_81374_81410[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (16))){
var state_81340__$1 = state_81340;
var statearr_81375_81411 = state_81340__$1;
(statearr_81375_81411[(2)] = null);

(statearr_81375_81411[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (10))){
var inst_81292 = (state_81340[(12)]);
var state_81340__$1 = state_81340;
var statearr_81376_81412 = state_81340__$1;
(statearr_81376_81412[(2)] = inst_81292);

(statearr_81376_81412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (18))){
var inst_81310 = (state_81340[(11)]);
var inst_81291 = (state_81340[(7)]);
var inst_81312 = fluree.crypto.sign_message(inst_81310,inst_81291);
var state_81340__$1 = state_81340;
var statearr_81377_81413 = state_81340__$1;
(statearr_81377_81413[(2)] = inst_81312);

(statearr_81377_81413[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81341 === (8))){
var inst_81288 = (state_81340[(15)]);
var inst_81285 = (state_81340[(2)]);
var inst_81286 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_81285);
var inst_81287 = cljs.core.__destructure_map(inst_81285);
var inst_81288__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81287,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_81289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81287,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81290 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_81287,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_81291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81287,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_81292 = fluree.db.util.core.current_time_millis();
var state_81340__$1 = (function (){var statearr_81378 = state_81340;
(statearr_81378[(12)] = inst_81292);

(statearr_81378[(16)] = inst_81290);

(statearr_81378[(17)] = inst_81286);

(statearr_81378[(13)] = inst_81289);

(statearr_81378[(15)] = inst_81288__$1);

(statearr_81378[(7)] = inst_81291);

return statearr_81378;
})();
if(cljs.core.truth_(inst_81288__$1)){
var statearr_81379_81414 = state_81340__$1;
(statearr_81379_81414[(1)] = (9));

} else {
var statearr_81380_81415 = state_81340__$1;
(statearr_81380_81415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_81381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81381[(0)] = flureedb$state_machine__2727__auto__);

(statearr_81381[(1)] = (1));

return statearr_81381;
});
var flureedb$state_machine__2727__auto____1 = (function (state_81340){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81340);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81382){var ex__2730__auto__ = e81382;
var statearr_81383_81416 = state_81340;
(statearr_81383_81416[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81340[(4)]))){
var statearr_81384_81417 = state_81340;
(statearr_81384_81417[(1)] = cljs.core.first((state_81340[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81418 = state_81340;
state_81340 = G__81418;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_81340){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_81340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81385 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81385[(6)] = c__2749__auto__);

return statearr_81385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81440){
var state_val_81441 = (state_81440[(1)]);
if((state_val_81441 === (1))){
var state_81440__$1 = state_81440;
var statearr_81442_81457 = state_81440__$1;
(statearr_81442_81457[(2)] = null);

(statearr_81442_81457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81441 === (2))){
var _ = (function (){var statearr_81443 = state_81440;
(statearr_81443[(4)] = cljs.core.cons((5),(state_81440[(4)])));

return statearr_81443;
})();
var inst_81430 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_81440__$1 = state_81440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81440__$1,(6),inst_81430);
} else {
if((state_val_81441 === (3))){
var inst_81438 = (state_81440[(2)]);
var state_81440__$1 = state_81440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81440__$1,inst_81438);
} else {
if((state_val_81441 === (4))){
var inst_81419 = (state_81440[(2)]);
var inst_81420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81421 = [inst_81419];
var inst_81422 = (new cljs.core.PersistentVector(null,1,(5),inst_81420,inst_81421,null));
var inst_81423 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81422);
var inst_81424 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81419) : reject.call(null,inst_81419));
var state_81440__$1 = (function (){var statearr_81445 = state_81440;
(statearr_81445[(7)] = inst_81423);

return statearr_81445;
})();
var statearr_81446_81458 = state_81440__$1;
(statearr_81446_81458[(2)] = inst_81424);

(statearr_81446_81458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81441 === (5))){
var _ = (function (){var statearr_81447 = state_81440;
(statearr_81447[(4)] = cljs.core.rest((state_81440[(4)])));

return statearr_81447;
})();
var state_81440__$1 = state_81440;
var ex81444 = (state_81440__$1[(2)]);
var statearr_81448_81459 = state_81440__$1;
(statearr_81448_81459[(5)] = ex81444);


var statearr_81449_81460 = state_81440__$1;
(statearr_81449_81460[(1)] = (4));

(statearr_81449_81460[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81441 === (6))){
var inst_81432 = (state_81440[(2)]);
var inst_81433 = fluree.db.util.async.throw_err(inst_81432);
var inst_81434 = cljs.core.clj__GT_js(inst_81433);
var inst_81435 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81434) : resolve.call(null,inst_81434));
var _ = (function (){var statearr_81450 = state_81440;
(statearr_81450[(4)] = cljs.core.rest((state_81440[(4)])));

return statearr_81450;
})();
var state_81440__$1 = state_81440;
var statearr_81451_81461 = state_81440__$1;
(statearr_81451_81461[(2)] = inst_81435);

(statearr_81451_81461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2727__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2727__auto____0 = (function (){
var statearr_81452 = [null,null,null,null,null,null,null,null];
(statearr_81452[(0)] = flureedb$ledger_stats_$_state_machine__2727__auto__);

(statearr_81452[(1)] = (1));

return statearr_81452;
});
var flureedb$ledger_stats_$_state_machine__2727__auto____1 = (function (state_81440){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81440);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81453){var ex__2730__auto__ = e81453;
var statearr_81454_81462 = state_81440;
(statearr_81454_81462[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81440[(4)]))){
var statearr_81455_81463 = state_81440;
(statearr_81455_81463[(1)] = cljs.core.first((state_81440[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81464 = state_81440;
state_81440 = G__81464;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2727__auto__ = function(state_81440){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2727__auto____1.call(this,state_81440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2727__auto____0;
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2727__auto____1;
return flureedb$ledger_stats_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81456 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81456[(6)] = c__2749__auto__);

return statearr_81456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__81466 = arguments.length;
switch (G__81466) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81593){
var state_val_81594 = (state_81593[(1)]);
if((state_val_81594 === (7))){
var inst_81492 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_81593__$1 = state_81593;
var statearr_81595_81665 = state_81593__$1;
(statearr_81595_81665[(2)] = inst_81492);

(statearr_81595_81665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (20))){
var inst_81499 = (state_81593[(7)]);
var inst_81538 = (state_81593[(2)]);
var inst_81539 = fluree.db.util.core.current_time_millis();
var state_81593__$1 = (function (){var statearr_81596 = state_81593;
(statearr_81596[(8)] = inst_81539);

(statearr_81596[(9)] = inst_81538);

return statearr_81596;
})();
if(cljs.core.truth_(inst_81499)){
var statearr_81597_81666 = state_81593__$1;
(statearr_81597_81666[(1)] = (21));

} else {
var statearr_81598_81667 = state_81593__$1;
(statearr_81598_81667[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (27))){
var inst_81552 = (state_81593[(10)]);
var inst_81507 = (state_81593[(11)]);
var inst_81554 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_81552,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_81507);
var state_81593__$1 = state_81593;
var statearr_81599_81668 = state_81593__$1;
(statearr_81599_81668[(2)] = inst_81554);

(statearr_81599_81668[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (1))){
var state_81593__$1 = state_81593;
var statearr_81600_81669 = state_81593__$1;
(statearr_81600_81669[(2)] = null);

(statearr_81600_81669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (24))){
var inst_81505 = (state_81593[(12)]);
var state_81593__$1 = state_81593;
var statearr_81601_81670 = state_81593__$1;
(statearr_81601_81670[(2)] = inst_81505);

(statearr_81601_81670[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (39))){
var inst_81575 = (state_81593[(2)]);
var inst_81576 = fluree.db.util.async.throw_err(inst_81575);
var state_81593__$1 = state_81593;
var statearr_81602_81671 = state_81593__$1;
(statearr_81602_81671[(2)] = inst_81576);

(statearr_81602_81671[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (4))){
var inst_81467 = (state_81593[(2)]);
var inst_81468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81469 = [inst_81467];
var inst_81470 = (new cljs.core.PersistentVector(null,1,(5),inst_81468,inst_81469,null));
var inst_81471 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81470);
var inst_81472 = cljs.core.ex_data(inst_81467);
var inst_81473 = cljs.core.ex_message(inst_81467);
var inst_81474 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_81472,new cljs.core.Keyword(null,"message","message",-406056002),inst_81473);
var inst_81475 = cljs.core.clj__GT_js(inst_81474);
var inst_81476 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81475) : reject.call(null,inst_81475));
var state_81593__$1 = (function (){var statearr_81603 = state_81593;
(statearr_81603[(13)] = inst_81471);

return statearr_81603;
})();
var statearr_81604_81672 = state_81593__$1;
(statearr_81604_81672[(2)] = inst_81476);

(statearr_81604_81672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (15))){
var inst_81528 = (state_81593[(14)]);
var inst_81530 = fluree.db.graphdb.validate_ledger_name(inst_81528,"alias");
var state_81593__$1 = state_81593;
var statearr_81605_81673 = state_81593__$1;
(statearr_81605_81673[(2)] = inst_81530);

(statearr_81605_81673[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (21))){
var inst_81499 = (state_81593[(7)]);
var state_81593__$1 = state_81593;
var statearr_81606_81674 = state_81593__$1;
(statearr_81606_81674[(2)] = inst_81499);

(statearr_81606_81674[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (31))){
var state_81593__$1 = state_81593;
var statearr_81607_81675 = state_81593__$1;
(statearr_81607_81675[(2)] = null);

(statearr_81607_81675[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (32))){
var inst_81501 = (state_81593[(15)]);
var inst_81563 = (state_81593[(2)]);
var state_81593__$1 = (function (){var statearr_81608 = state_81593;
(statearr_81608[(16)] = inst_81563);

return statearr_81608;
})();
if(cljs.core.truth_(inst_81501)){
var statearr_81609_81676 = state_81593__$1;
(statearr_81609_81676[(1)] = (33));

} else {
var statearr_81610_81677 = state_81593__$1;
(statearr_81610_81677[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (40))){
var inst_81580 = (state_81593[(2)]);
var inst_81581 = fluree.db.util.async.throw_err(inst_81580);
var state_81593__$1 = state_81593;
var statearr_81611_81678 = state_81593__$1;
(statearr_81611_81678[(2)] = inst_81581);

(statearr_81611_81678[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (33))){
var inst_81563 = (state_81593[(16)]);
var inst_81501 = (state_81593[(15)]);
var inst_81565 = fluree.crypto.sign_message(inst_81563,inst_81501);
var state_81593__$1 = state_81593;
var statearr_81612_81679 = state_81593__$1;
(statearr_81612_81679[(2)] = inst_81565);

(statearr_81612_81679[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (13))){
var state_81593__$1 = state_81593;
var statearr_81613_81680 = state_81593__$1;
(statearr_81613_81680[(2)] = null);

(statearr_81613_81680[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (22))){
var inst_81539 = (state_81593[(8)]);
var state_81593__$1 = state_81593;
var statearr_81614_81681 = state_81593__$1;
(statearr_81614_81681[(2)] = inst_81539);

(statearr_81614_81681[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (36))){
var inst_81563 = (state_81593[(16)]);
var inst_81568 = (state_81593[(17)]);
var inst_81570 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_81571 = [inst_81563,inst_81568];
var inst_81572 = cljs.core.PersistentHashMap.fromArrays(inst_81570,inst_81571);
var inst_81573 = fluree.db.operations.command_async(conn,inst_81572);
var state_81593__$1 = state_81593;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81593__$1,(39),inst_81573);
} else {
if((state_val_81594 === (29))){
var inst_81501 = (state_81593[(15)]);
var inst_81557 = (state_81593[(2)]);
var state_81593__$1 = (function (){var statearr_81615 = state_81593;
(statearr_81615[(18)] = inst_81557);

return statearr_81615;
})();
if(cljs.core.truth_(inst_81501)){
var statearr_81616_81682 = state_81593__$1;
(statearr_81616_81682[(1)] = (30));

} else {
var statearr_81617_81683 = state_81593__$1;
(statearr_81617_81683[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (6))){
var state_81593__$1 = state_81593;
var statearr_81618_81684 = state_81593__$1;
(statearr_81618_81684[(2)] = null);

(statearr_81618_81684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (28))){
var inst_81552 = (state_81593[(10)]);
var state_81593__$1 = state_81593;
var statearr_81619_81685 = state_81593__$1;
(statearr_81619_81685[(2)] = inst_81552);

(statearr_81619_81685[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (25))){
var inst_81539 = (state_81593[(8)]);
var inst_81546 = (inst_81539 + (30000));
var state_81593__$1 = state_81593;
var statearr_81620_81686 = state_81593__$1;
(statearr_81620_81686[(2)] = inst_81546);

(statearr_81620_81686[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (34))){
var state_81593__$1 = state_81593;
var statearr_81621_81687 = state_81593__$1;
(statearr_81621_81687[(2)] = null);

(statearr_81621_81687[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (17))){
var inst_81509 = (state_81593[(19)]);
var inst_81533 = (state_81593[(2)]);
var state_81593__$1 = (function (){var statearr_81622 = state_81593;
(statearr_81622[(20)] = inst_81533);

return statearr_81622;
})();
if(cljs.core.truth_(inst_81509)){
var statearr_81623_81688 = state_81593__$1;
(statearr_81623_81688[(1)] = (18));

} else {
var statearr_81624_81689 = state_81593__$1;
(statearr_81624_81689[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (3))){
var inst_81591 = (state_81593[(2)]);
var state_81593__$1 = state_81593;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81593__$1,inst_81591);
} else {
if((state_val_81594 === (12))){
var inst_81523 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_81593__$1 = state_81593;
var statearr_81625_81690 = state_81593__$1;
(statearr_81625_81690[(2)] = inst_81523);

(statearr_81625_81690[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (2))){
var _ = (function (){var statearr_81626 = state_81593;
(statearr_81626[(4)] = cljs.core.cons((5),(state_81593[(4)])));

return statearr_81626;
})();
var inst_81489 = (opts == null);
var state_81593__$1 = state_81593;
if(cljs.core.truth_(inst_81489)){
var statearr_81627_81691 = state_81593__$1;
(statearr_81627_81691[(1)] = (6));

} else {
var statearr_81628_81692 = state_81593__$1;
(statearr_81628_81692[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (23))){
var inst_81505 = (state_81593[(12)]);
var inst_81543 = (state_81593[(2)]);
var state_81593__$1 = (function (){var statearr_81629 = state_81593;
(statearr_81629[(21)] = inst_81543);

return statearr_81629;
})();
if(cljs.core.truth_(inst_81505)){
var statearr_81630_81693 = state_81593__$1;
(statearr_81630_81693[(1)] = (24));

} else {
var statearr_81631_81694 = state_81593__$1;
(statearr_81631_81694[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (35))){
var inst_81501 = (state_81593[(15)]);
var inst_81568 = (state_81593[(2)]);
var state_81593__$1 = (function (){var statearr_81632 = state_81593;
(statearr_81632[(17)] = inst_81568);

return statearr_81632;
})();
if(cljs.core.truth_(inst_81501)){
var statearr_81633_81695 = state_81593__$1;
(statearr_81633_81695[(1)] = (36));

} else {
var statearr_81634_81696 = state_81593__$1;
(statearr_81634_81696[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (19))){
var state_81593__$1 = state_81593;
var statearr_81635_81697 = state_81593__$1;
(statearr_81635_81697[(2)] = null);

(statearr_81635_81697[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (11))){
var inst_81509 = (state_81593[(19)]);
var inst_81519 = (state_81593[(22)]);
var inst_81512 = (state_81593[(23)]);
var inst_81519__$1 = (state_81593[(2)]);
var inst_81520 = fluree.db.graphdb.validate_ledger_name(inst_81519__$1,"ledger");
var inst_81521 = fluree.db.graphdb.validate_ledger_name(inst_81512,"network");
var state_81593__$1 = (function (){var statearr_81637 = state_81593;
(statearr_81637[(24)] = inst_81520);

(statearr_81637[(25)] = inst_81521);

(statearr_81637[(22)] = inst_81519__$1);

return statearr_81637;
})();
if(cljs.core.truth_(inst_81509)){
var statearr_81638_81698 = state_81593__$1;
(statearr_81638_81698[(1)] = (12));

} else {
var statearr_81639_81699 = state_81593__$1;
(statearr_81639_81699[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (9))){
var inst_81513 = (state_81593[(26)]);
var inst_81516 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_81513,(1));
var state_81593__$1 = state_81593;
var statearr_81640_81700 = state_81593__$1;
(statearr_81640_81700[(2)] = inst_81516);

(statearr_81640_81700[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (5))){
var _ = (function (){var statearr_81641 = state_81593;
(statearr_81641[(4)] = cljs.core.rest((state_81593[(4)])));

return statearr_81641;
})();
var state_81593__$1 = state_81593;
var ex81636 = (state_81593__$1[(2)]);
var statearr_81642_81701 = state_81593__$1;
(statearr_81642_81701[(5)] = ex81636);


var statearr_81643_81702 = state_81593__$1;
(statearr_81643_81702[(1)] = (4));

(statearr_81643_81702[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (14))){
var inst_81509 = (state_81593[(19)]);
var inst_81526 = (state_81593[(2)]);
var inst_81527 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81526,(0),null);
var inst_81528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81526,(1),null);
var state_81593__$1 = (function (){var statearr_81644 = state_81593;
(statearr_81644[(14)] = inst_81528);

(statearr_81644[(27)] = inst_81527);

return statearr_81644;
})();
if(cljs.core.truth_(inst_81509)){
var statearr_81645_81703 = state_81593__$1;
(statearr_81645_81703[(1)] = (15));

} else {
var statearr_81646_81704 = state_81593__$1;
(statearr_81646_81704[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (26))){
var inst_81508 = (state_81593[(28)]);
var inst_81504 = (state_81593[(29)]);
var inst_81510 = (state_81593[(30)]);
var inst_81506 = (state_81593[(31)]);
var inst_81502 = (state_81593[(32)]);
var inst_81503 = (state_81593[(33)]);
var inst_81543 = (state_81593[(21)]);
var inst_81498 = (state_81593[(34)]);
var inst_81507 = (state_81593[(11)]);
var inst_81500 = (state_81593[(35)]);
var inst_81519 = (state_81593[(22)]);
var inst_81538 = (state_81593[(9)]);
var inst_81512 = (state_81593[(23)]);
var inst_81548 = (state_81593[(2)]);
var inst_81549 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_81550 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81512),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81519)].join('');
var inst_81551 = [inst_81550,inst_81503,inst_81504,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_81548,inst_81506,inst_81538,inst_81510,inst_81508,inst_81498,inst_81543,inst_81500,inst_81502];
var inst_81552 = cljs.core.PersistentHashMap.fromArrays(inst_81549,inst_81551);
var state_81593__$1 = (function (){var statearr_81647 = state_81593;
(statearr_81647[(10)] = inst_81552);

return statearr_81647;
})();
if(cljs.core.truth_(inst_81507)){
var statearr_81648_81705 = state_81593__$1;
(statearr_81648_81705[(1)] = (27));

} else {
var statearr_81649_81706 = state_81593__$1;
(statearr_81649_81706[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (16))){
var state_81593__$1 = state_81593;
var statearr_81650_81707 = state_81593__$1;
(statearr_81650_81707[(2)] = null);

(statearr_81650_81707[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (38))){
var inst_81583 = (state_81593[(2)]);
var inst_81584 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_81585 = [(200),inst_81583];
var inst_81586 = cljs.core.PersistentHashMap.fromArrays(inst_81584,inst_81585);
var inst_81587 = cljs.core.clj__GT_js(inst_81586);
var inst_81588 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81587) : resolve.call(null,inst_81587));
var _ = (function (){var statearr_81651 = state_81593;
(statearr_81651[(4)] = cljs.core.rest((state_81593[(4)])));

return statearr_81651;
})();
var state_81593__$1 = state_81593;
var statearr_81652_81708 = state_81593__$1;
(statearr_81652_81708[(2)] = inst_81588);

(statearr_81652_81708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (30))){
var inst_81557 = (state_81593[(18)]);
var inst_81559 = fluree.db.util.core.without_nils(inst_81557);
var inst_81560 = fluree.db.util.json.stringify(inst_81559);
var state_81593__$1 = state_81593;
var statearr_81653_81709 = state_81593__$1;
(statearr_81653_81709[(2)] = inst_81560);

(statearr_81653_81709[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (10))){
var inst_81513 = (state_81593[(26)]);
var state_81593__$1 = state_81593;
var statearr_81654_81710 = state_81593__$1;
(statearr_81654_81710[(2)] = inst_81513);

(statearr_81654_81710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (18))){
var inst_81528 = (state_81593[(14)]);
var inst_81527 = (state_81593[(27)]);
var inst_81535 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81527),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81528)].join('');
var state_81593__$1 = state_81593;
var statearr_81655_81711 = state_81593__$1;
(statearr_81655_81711[(2)] = inst_81535);

(statearr_81655_81711[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81594 === (37))){
var inst_81557 = (state_81593[(18)]);
var inst_81578 = fluree.db.operations.unsigned_command_async(conn,inst_81557);
var state_81593__$1 = state_81593;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81593__$1,(40),inst_81578);
} else {
if((state_val_81594 === (8))){
var inst_81513 = (state_81593[(26)]);
var inst_81494 = (state_81593[(2)]);
var inst_81495 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_81494);
var inst_81496 = cljs.core.__destructure_map(inst_81494);
var inst_81497 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_81496,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_81498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_81499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_81500 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_81501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_81502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_81503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_81504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_81505 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81506 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_81507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_81508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_81509 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_81510 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81496,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_81511 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_81512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81511,(0),null);
var inst_81513__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81511,(1),null);
var inst_81514 = clojure.string.starts_with_QMARK_(inst_81513__$1,"$");
var state_81593__$1 = (function (){var statearr_81656 = state_81593;
(statearr_81656[(7)] = inst_81499);

(statearr_81656[(19)] = inst_81509);

(statearr_81656[(28)] = inst_81508);

(statearr_81656[(29)] = inst_81504);

(statearr_81656[(30)] = inst_81510);

(statearr_81656[(31)] = inst_81506);

(statearr_81656[(32)] = inst_81502);

(statearr_81656[(33)] = inst_81503);

(statearr_81656[(34)] = inst_81498);

(statearr_81656[(15)] = inst_81501);

(statearr_81656[(11)] = inst_81507);

(statearr_81656[(12)] = inst_81505);

(statearr_81656[(35)] = inst_81500);

(statearr_81656[(36)] = inst_81495);

(statearr_81656[(26)] = inst_81513__$1);

(statearr_81656[(37)] = inst_81497);

(statearr_81656[(23)] = inst_81512);

return statearr_81656;
})();
if(inst_81514){
var statearr_81657_81712 = state_81593__$1;
(statearr_81657_81712[(1)] = (9));

} else {
var statearr_81658_81713 = state_81593__$1;
(statearr_81658_81713[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_81659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81659[(0)] = flureedb$state_machine__2727__auto__);

(statearr_81659[(1)] = (1));

return statearr_81659;
});
var flureedb$state_machine__2727__auto____1 = (function (state_81593){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81593);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81660){var ex__2730__auto__ = e81660;
var statearr_81661_81714 = state_81593;
(statearr_81661_81714[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81593[(4)]))){
var statearr_81662_81715 = state_81593;
(statearr_81662_81715[(1)] = cljs.core.first((state_81593[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81716 = state_81593;
state_81593 = G__81716;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_81593){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_81593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81663 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81663[(6)] = c__2749__auto__);

return statearr_81663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81739){
var state_val_81740 = (state_81739[(1)]);
if((state_val_81740 === (1))){
var state_81739__$1 = state_81739;
var statearr_81741_81757 = state_81739__$1;
(statearr_81741_81757[(2)] = null);

(statearr_81741_81757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81740 === (2))){
var _ = (function (){var statearr_81742 = state_81739;
(statearr_81742[(4)] = cljs.core.cons((5),(state_81739[(4)])));

return statearr_81742;
})();
var inst_81729 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_81730 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_81739__$1 = (function (){var statearr_81743 = state_81739;
(statearr_81743[(7)] = inst_81729);

return statearr_81743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81739__$1,(6),inst_81730);
} else {
if((state_val_81740 === (3))){
var inst_81737 = (state_81739[(2)]);
var state_81739__$1 = state_81739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81739__$1,inst_81737);
} else {
if((state_val_81740 === (4))){
var inst_81717 = (state_81739[(2)]);
var inst_81718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81719 = [inst_81717];
var inst_81720 = (new cljs.core.PersistentVector(null,1,(5),inst_81718,inst_81719,null));
var inst_81721 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81720);
var inst_81722 = cljs.core.clj__GT_js(inst_81717);
var inst_81723 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81722) : reject.call(null,inst_81722));
var state_81739__$1 = (function (){var statearr_81745 = state_81739;
(statearr_81745[(8)] = inst_81721);

return statearr_81745;
})();
var statearr_81746_81758 = state_81739__$1;
(statearr_81746_81758[(2)] = inst_81723);

(statearr_81746_81758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81740 === (5))){
var _ = (function (){var statearr_81747 = state_81739;
(statearr_81747[(4)] = cljs.core.rest((state_81739[(4)])));

return statearr_81747;
})();
var state_81739__$1 = state_81739;
var ex81744 = (state_81739__$1[(2)]);
var statearr_81748_81759 = state_81739__$1;
(statearr_81748_81759[(5)] = ex81744);


var statearr_81749_81760 = state_81739__$1;
(statearr_81749_81760[(1)] = (4));

(statearr_81749_81760[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81740 === (6))){
var inst_81732 = (state_81739[(2)]);
var inst_81733 = cljs.core.clj__GT_js(inst_81732);
var inst_81734 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81733) : resolve.call(null,inst_81733));
var _ = (function (){var statearr_81750 = state_81739;
(statearr_81750[(4)] = cljs.core.rest((state_81739[(4)])));

return statearr_81750;
})();
var state_81739__$1 = state_81739;
var statearr_81751_81761 = state_81739__$1;
(statearr_81751_81761[(2)] = inst_81734);

(statearr_81751_81761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2727__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_81752 = [null,null,null,null,null,null,null,null,null];
(statearr_81752[(0)] = flureedb$monitor_tx_$_state_machine__2727__auto__);

(statearr_81752[(1)] = (1));

return statearr_81752;
});
var flureedb$monitor_tx_$_state_machine__2727__auto____1 = (function (state_81739){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81739);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81753){var ex__2730__auto__ = e81753;
var statearr_81754_81762 = state_81739;
(statearr_81754_81762[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81739[(4)]))){
var statearr_81755_81763 = state_81739;
(statearr_81755_81763[(1)] = cljs.core.first((state_81739[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81764 = state_81739;
state_81739 = G__81764;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2727__auto__ = function(state_81739){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2727__auto____1.call(this,state_81739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2727__auto____0;
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2727__auto____1;
return flureedb$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81756 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81756[(6)] = c__2749__auto__);

return statearr_81756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__81766 = arguments.length;
switch (G__81766) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81795){
var state_val_81796 = (state_81795[(1)]);
if((state_val_81796 === (7))){
var inst_81781 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_81795__$1 = state_81795;
var statearr_81797_81818 = state_81795__$1;
(statearr_81797_81818[(2)] = inst_81781);

(statearr_81797_81818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (1))){
var state_81795__$1 = state_81795;
var statearr_81798_81819 = state_81795__$1;
(statearr_81798_81819[(2)] = null);

(statearr_81798_81819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (4))){
var inst_81767 = (state_81795[(2)]);
var inst_81768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81769 = [inst_81767];
var inst_81770 = (new cljs.core.PersistentVector(null,1,(5),inst_81768,inst_81769,null));
var inst_81771 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81770);
var inst_81772 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81767) : reject.call(null,inst_81767));
var state_81795__$1 = (function (){var statearr_81799 = state_81795;
(statearr_81799[(7)] = inst_81771);

return statearr_81799;
})();
var statearr_81800_81820 = state_81795__$1;
(statearr_81800_81820[(2)] = inst_81772);

(statearr_81800_81820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (6))){
var state_81795__$1 = state_81795;
var statearr_81801_81821 = state_81795__$1;
(statearr_81801_81821[(2)] = null);

(statearr_81801_81821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (3))){
var inst_81793 = (state_81795[(2)]);
var state_81795__$1 = state_81795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81795__$1,inst_81793);
} else {
if((state_val_81796 === (2))){
var _ = (function (){var statearr_81803 = state_81795;
(statearr_81803[(4)] = cljs.core.cons((5),(state_81795[(4)])));

return statearr_81803;
})();
var inst_81778 = (opts == null);
var state_81795__$1 = state_81795;
if(cljs.core.truth_(inst_81778)){
var statearr_81804_81822 = state_81795__$1;
(statearr_81804_81822[(1)] = (6));

} else {
var statearr_81805_81823 = state_81795__$1;
(statearr_81805_81823[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (9))){
var inst_81788 = (state_81795[(2)]);
var inst_81789 = cljs.core.clj__GT_js(inst_81788);
var inst_81790 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81789) : resolve.call(null,inst_81789));
var _ = (function (){var statearr_81806 = state_81795;
(statearr_81806[(4)] = cljs.core.rest((state_81795[(4)])));

return statearr_81806;
})();
var state_81795__$1 = state_81795;
var statearr_81807_81824 = state_81795__$1;
(statearr_81807_81824[(2)] = inst_81790);

(statearr_81807_81824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (5))){
var _ = (function (){var statearr_81808 = state_81795;
(statearr_81808[(4)] = cljs.core.rest((state_81795[(4)])));

return statearr_81808;
})();
var state_81795__$1 = state_81795;
var ex81802 = (state_81795__$1[(2)]);
var statearr_81809_81825 = state_81795__$1;
(statearr_81809_81825[(5)] = ex81802);


var statearr_81810_81826 = state_81795__$1;
(statearr_81810_81826[(1)] = (4));

(statearr_81810_81826[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81796 === (8))){
var inst_81783 = (state_81795[(2)]);
var inst_81784 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_81783);
var inst_81785 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_81786 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_81785,inst_81783);
var state_81795__$1 = (function (){var statearr_81811 = state_81795;
(statearr_81811[(8)] = inst_81784);

return statearr_81811;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81795__$1,(9),inst_81786);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_81812 = [null,null,null,null,null,null,null,null,null];
(statearr_81812[(0)] = flureedb$state_machine__2727__auto__);

(statearr_81812[(1)] = (1));

return statearr_81812;
});
var flureedb$state_machine__2727__auto____1 = (function (state_81795){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81795);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81813){var ex__2730__auto__ = e81813;
var statearr_81814_81827 = state_81795;
(statearr_81814_81827[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81795[(4)]))){
var statearr_81815_81828 = state_81795;
(statearr_81815_81828[(1)] = cljs.core.first((state_81795[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81829 = state_81795;
state_81795 = G__81829;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_81795){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_81795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81816 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81816[(6)] = c__2749__auto__);

return statearr_81816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__81831 = arguments.length;
switch (G__81831) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81863){
var state_val_81864 = (state_81863[(1)]);
if((state_val_81864 === (7))){
var inst_81846 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_81863__$1 = state_81863;
var statearr_81865_81886 = state_81863__$1;
(statearr_81865_81886[(2)] = inst_81846);

(statearr_81865_81886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (1))){
var state_81863__$1 = state_81863;
var statearr_81866_81887 = state_81863__$1;
(statearr_81866_81887[(2)] = null);

(statearr_81866_81887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (4))){
var inst_81832 = (state_81863[(2)]);
var inst_81833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81834 = [inst_81832];
var inst_81835 = (new cljs.core.PersistentVector(null,1,(5),inst_81833,inst_81834,null));
var inst_81836 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81835);
var inst_81837 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81832) : reject.call(null,inst_81832));
var state_81863__$1 = (function (){var statearr_81867 = state_81863;
(statearr_81867[(7)] = inst_81836);

return statearr_81867;
})();
var statearr_81868_81888 = state_81863__$1;
(statearr_81868_81888[(2)] = inst_81837);

(statearr_81868_81888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (6))){
var state_81863__$1 = state_81863;
var statearr_81869_81889 = state_81863__$1;
(statearr_81869_81889[(2)] = null);

(statearr_81869_81889[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (3))){
var inst_81861 = (state_81863[(2)]);
var state_81863__$1 = state_81863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81863__$1,inst_81861);
} else {
if((state_val_81864 === (2))){
var _ = (function (){var statearr_81871 = state_81863;
(statearr_81871[(4)] = cljs.core.cons((5),(state_81863[(4)])));

return statearr_81871;
})();
var inst_81843 = (opts == null);
var state_81863__$1 = state_81863;
if(cljs.core.truth_(inst_81843)){
var statearr_81872_81890 = state_81863__$1;
(statearr_81872_81890[(1)] = (6));

} else {
var statearr_81873_81891 = state_81863__$1;
(statearr_81873_81891[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (9))){
var inst_81848 = (state_81863[(8)]);
var inst_81851 = (state_81863[(2)]);
var inst_81852 = fluree.db.util.async.throw_err(inst_81851);
var inst_81853 = fluree.db.query.block.block_range(inst_81852,start,end,inst_81848);
var state_81863__$1 = state_81863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81863__$1,(10),inst_81853);
} else {
if((state_val_81864 === (5))){
var _ = (function (){var statearr_81874 = state_81863;
(statearr_81874[(4)] = cljs.core.rest((state_81863[(4)])));

return statearr_81874;
})();
var state_81863__$1 = state_81863;
var ex81870 = (state_81863__$1[(2)]);
var statearr_81875_81892 = state_81863__$1;
(statearr_81875_81892[(5)] = ex81870);


var statearr_81876_81893 = state_81863__$1;
(statearr_81876_81893[(1)] = (4));

(statearr_81876_81893[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (10))){
var inst_81855 = (state_81863[(2)]);
var inst_81856 = fluree.db.util.async.throw_err(inst_81855);
var inst_81857 = cljs.core.clj__GT_js(inst_81856);
var inst_81858 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81857) : resolve.call(null,inst_81857));
var _ = (function (){var statearr_81877 = state_81863;
(statearr_81877[(4)] = cljs.core.rest((state_81863[(4)])));

return statearr_81877;
})();
var state_81863__$1 = state_81863;
var statearr_81878_81894 = state_81863__$1;
(statearr_81878_81894[(2)] = inst_81858);

(statearr_81878_81894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81864 === (8))){
var inst_81848 = (state_81863[(8)]);
var inst_81848__$1 = (state_81863[(2)]);
var inst_81849 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81848__$1], 0));
var state_81863__$1 = (function (){var statearr_81879 = state_81863;
(statearr_81879[(8)] = inst_81848__$1);

return statearr_81879;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81863__$1,(9),inst_81849);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_81880 = [null,null,null,null,null,null,null,null,null];
(statearr_81880[(0)] = flureedb$state_machine__2727__auto__);

(statearr_81880[(1)] = (1));

return statearr_81880;
});
var flureedb$state_machine__2727__auto____1 = (function (state_81863){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81863);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81881){var ex__2730__auto__ = e81881;
var statearr_81882_81895 = state_81863;
(statearr_81882_81895[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81863[(4)]))){
var statearr_81883_81896 = state_81863;
(statearr_81883_81896[(1)] = cljs.core.first((state_81863[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81897 = state_81863;
state_81863 = G__81897;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_81863){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_81863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81884 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81884[(6)] = c__2749__auto__);

return statearr_81884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__81899 = arguments.length;
switch (G__81899) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81937){
var state_val_81938 = (state_81937[(1)]);
if((state_val_81938 === (7))){
var inst_81915 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_81937__$1 = state_81937;
var statearr_81939_81960 = state_81937__$1;
(statearr_81939_81960[(2)] = inst_81915);

(statearr_81939_81960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (1))){
var state_81937__$1 = state_81937;
var statearr_81940_81961 = state_81937__$1;
(statearr_81940_81961[(2)] = null);

(statearr_81940_81961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (4))){
var inst_81900 = (state_81937[(2)]);
var inst_81901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81902 = [inst_81900];
var inst_81903 = (new cljs.core.PersistentVector(null,1,(5),inst_81901,inst_81902,null));
var inst_81904 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81903);
var inst_81905 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81900) : reject.call(null,inst_81900));
var state_81937__$1 = (function (){var statearr_81941 = state_81937;
(statearr_81941[(7)] = inst_81904);

return statearr_81941;
})();
var statearr_81942_81962 = state_81937__$1;
(statearr_81942_81962[(2)] = inst_81905);

(statearr_81942_81962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (6))){
var state_81937__$1 = state_81937;
var statearr_81943_81963 = state_81937__$1;
(statearr_81943_81963[(2)] = null);

(statearr_81943_81963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (3))){
var inst_81935 = (state_81937[(2)]);
var state_81937__$1 = state_81937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81937__$1,inst_81935);
} else {
if((state_val_81938 === (2))){
var _ = (function (){var statearr_81945 = state_81937;
(statearr_81945[(4)] = cljs.core.cons((5),(state_81937[(4)])));

return statearr_81945;
})();
var inst_81912 = (opts == null);
var state_81937__$1 = state_81937;
if(cljs.core.truth_(inst_81912)){
var statearr_81946_81964 = state_81937__$1;
(statearr_81946_81964[(1)] = (6));

} else {
var statearr_81947_81965 = state_81937__$1;
(statearr_81947_81965[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (9))){
var inst_81920 = (state_81937[(8)]);
var inst_81921 = (state_81937[(9)]);
var inst_81917 = (state_81937[(10)]);
var inst_81924 = (state_81937[(2)]);
var inst_81925 = fluree.db.util.async.throw_err(inst_81924);
var inst_81926 = fluree.db.query.block.block_range(inst_81925,inst_81920,inst_81921,inst_81917);
var state_81937__$1 = state_81937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81937__$1,(10),inst_81926);
} else {
if((state_val_81938 === (5))){
var _ = (function (){var statearr_81948 = state_81937;
(statearr_81948[(4)] = cljs.core.rest((state_81937[(4)])));

return statearr_81948;
})();
var state_81937__$1 = state_81937;
var ex81944 = (state_81937__$1[(2)]);
var statearr_81949_81966 = state_81937__$1;
(statearr_81949_81966[(5)] = ex81944);


var statearr_81950_81967 = state_81937__$1;
(statearr_81950_81967[(1)] = (4));

(statearr_81950_81967[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (10))){
var inst_81928 = (state_81937[(2)]);
var inst_81929 = fluree.db.util.async.throw_err(inst_81928);
var inst_81930 = fluree.db.query.range.block_with_tx_data(inst_81929);
var inst_81931 = cljs.core.clj__GT_js(inst_81930);
var inst_81932 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81931) : resolve.call(null,inst_81931));
var _ = (function (){var statearr_81951 = state_81937;
(statearr_81951[(4)] = cljs.core.rest((state_81937[(4)])));

return statearr_81951;
})();
var state_81937__$1 = state_81937;
var statearr_81952_81968 = state_81937__$1;
(statearr_81952_81968[(2)] = inst_81932);

(statearr_81952_81968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81938 === (8))){
var inst_81917 = (state_81937[(10)]);
var inst_81917__$1 = (state_81937[(2)]);
var inst_81918 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_81919 = cljs.core.__destructure_map(inst_81918);
var inst_81920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81919,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_81921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_81919,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_81922 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81917__$1], 0));
var state_81937__$1 = (function (){var statearr_81953 = state_81937;
(statearr_81953[(8)] = inst_81920);

(statearr_81953[(9)] = inst_81921);

(statearr_81953[(10)] = inst_81917__$1);

return statearr_81953;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81937__$1,(9),inst_81922);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_81954 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81954[(0)] = flureedb$state_machine__2727__auto__);

(statearr_81954[(1)] = (1));

return statearr_81954;
});
var flureedb$state_machine__2727__auto____1 = (function (state_81937){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81937);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81955){var ex__2730__auto__ = e81955;
var statearr_81956_81969 = state_81937;
(statearr_81956_81969[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81937[(4)]))){
var statearr_81957_81970 = state_81937;
(statearr_81957_81970[(1)] = cljs.core.first((state_81937[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81971 = state_81937;
state_81937 = G__81971;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_81937){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_81937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81958 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81958[(6)] = c__2749__auto__);

return statearr_81958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__81973 = arguments.length;
switch (G__81973) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_82043){
var state_val_82044 = (state_82043[(1)]);
if((state_val_82044 === (7))){
var inst_81989 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_82043__$1 = state_82043;
var statearr_82045_82086 = state_82043__$1;
(statearr_82045_82086[(2)] = inst_81989);

(statearr_82045_82086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (20))){
var inst_81991 = (state_82043[(7)]);
var inst_81985 = (state_82043[(8)]);
var inst_82027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82028 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_82029 = (new cljs.core.PersistentVector(null,1,(5),inst_82027,inst_82028,null));
var inst_82030 = cljs.core.assoc_in(inst_81991,inst_82029,new cljs.core.Keyword(null,"block","block",664686210));
var inst_82031 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_81985,inst_82030);
var state_82043__$1 = state_82043;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82043__$1,(23),inst_82031);
} else {
if((state_val_82044 === (1))){
var state_82043__$1 = state_82043;
var statearr_82046_82087 = state_82043__$1;
(statearr_82046_82087[(2)] = null);

(statearr_82046_82087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (4))){
var inst_81974 = (state_82043[(2)]);
var inst_81975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81976 = [inst_81974];
var inst_81977 = (new cljs.core.PersistentVector(null,1,(5),inst_81975,inst_81976,null));
var inst_81978 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81977);
var inst_81979 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81974) : reject.call(null,inst_81974));
var state_82043__$1 = (function (){var statearr_82047 = state_82043;
(statearr_82047[(9)] = inst_81978);

return statearr_82047;
})();
var statearr_82048_82088 = state_82043__$1;
(statearr_82048_82088[(2)] = inst_81979);

(statearr_82048_82088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (15))){
var inst_82015 = (state_82043[(2)]);
var inst_82016 = fluree.db.util.async.throw_err(inst_82015);
var state_82043__$1 = state_82043;
var statearr_82049_82089 = state_82043__$1;
(statearr_82049_82089[(2)] = inst_82016);

(statearr_82049_82089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (21))){
var inst_82036 = (state_82043[(2)]);
var inst_82037 = cljs.core.clj__GT_js(inst_82036);
var inst_82038 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_82037) : resolve.call(null,inst_82037));
var _ = (function (){var statearr_82050 = state_82043;
(statearr_82050[(4)] = cljs.core.rest((state_82043[(4)])));

return statearr_82050;
})();
var state_82043__$1 = state_82043;
var statearr_82051_82090 = state_82043__$1;
(statearr_82051_82090[(2)] = inst_82038);

(statearr_82051_82090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (13))){
var state_82043__$1 = state_82043;
var statearr_82052_82091 = state_82043__$1;
(statearr_82052_82091[(2)] = null);

(statearr_82052_82091[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (22))){
var inst_82024 = (state_82043[(2)]);
var inst_82025 = fluree.db.util.async.throw_err(inst_82024);
var state_82043__$1 = state_82043;
var statearr_82053_82092 = state_82043__$1;
(statearr_82053_82092[(2)] = inst_82025);

(statearr_82053_82092[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (6))){
var state_82043__$1 = state_82043;
var statearr_82054_82093 = state_82043__$1;
(statearr_82054_82093[(2)] = null);

(statearr_82054_82093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (17))){
var state_82043__$1 = state_82043;
var statearr_82055_82094 = state_82043__$1;
(statearr_82055_82094[(2)] = null);

(statearr_82055_82094[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (3))){
var inst_82041 = (state_82043[(2)]);
var state_82043__$1 = state_82043;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82043__$1,inst_82041);
} else {
if((state_val_82044 === (12))){
var inst_81999 = (state_82043[(10)]);
var inst_82003 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_82043__$1 = (function (){var statearr_82056 = state_82043;
(statearr_82056[(11)] = inst_82003);

return statearr_82056;
})();
if(cljs.core.truth_(inst_81999)){
var statearr_82057_82095 = state_82043__$1;
(statearr_82057_82095[(1)] = (16));

} else {
var statearr_82058_82096 = state_82043__$1;
(statearr_82058_82096[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (2))){
var _ = (function (){var statearr_82059 = state_82043;
(statearr_82059[(4)] = cljs.core.cons((5),(state_82043[(4)])));

return statearr_82059;
})();
var inst_81985 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_81986 = (opts == null);
var state_82043__$1 = (function (){var statearr_82060 = state_82043;
(statearr_82060[(8)] = inst_81985);

return statearr_82060;
})();
if(cljs.core.truth_(inst_81986)){
var statearr_82061_82097 = state_82043__$1;
(statearr_82061_82097[(1)] = (6));

} else {
var statearr_82062_82098 = state_82043__$1;
(statearr_82062_82098[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (23))){
var inst_82033 = (state_82043[(2)]);
var inst_82034 = fluree.db.util.async.throw_err(inst_82033);
var state_82043__$1 = state_82043;
var statearr_82063_82099 = state_82043__$1;
(statearr_82063_82099[(2)] = inst_82034);

(statearr_82063_82099[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (19))){
var inst_82019 = (state_82043[(12)]);
var inst_81991 = (state_82043[(7)]);
var inst_81985 = (state_82043[(8)]);
var inst_82022 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_82019,inst_81985,inst_81991);
var state_82043__$1 = state_82043;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82043__$1,(22),inst_82022);
} else {
if((state_val_82044 === (11))){
var inst_81991 = (state_82043[(7)]);
var inst_81993 = (state_82043[(13)]);
var inst_81999 = (state_82043[(2)]);
var inst_82000 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_81991);
var inst_82001 = (inst_81993 == null);
var state_82043__$1 = (function (){var statearr_82065 = state_82043;
(statearr_82065[(14)] = inst_82000);

(statearr_82065[(10)] = inst_81999);

return statearr_82065;
})();
if(cljs.core.truth_(inst_82001)){
var statearr_82066_82100 = state_82043__$1;
(statearr_82066_82100[(1)] = (12));

} else {
var statearr_82067_82101 = state_82043__$1;
(statearr_82067_82101[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (9))){
var inst_81994 = (state_82043[(15)]);
var state_82043__$1 = state_82043;
var statearr_82068_82102 = state_82043__$1;
(statearr_82068_82102[(2)] = inst_81994);

(statearr_82068_82102[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (5))){
var _ = (function (){var statearr_82069 = state_82043;
(statearr_82069[(4)] = cljs.core.rest((state_82043[(4)])));

return statearr_82069;
})();
var state_82043__$1 = state_82043;
var ex82064 = (state_82043__$1[(2)]);
var statearr_82070_82103 = state_82043__$1;
(statearr_82070_82103[(5)] = ex82064);


var statearr_82071_82104 = state_82043__$1;
(statearr_82071_82104[(1)] = (4));

(statearr_82071_82104[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (14))){
var inst_81993 = (state_82043[(13)]);
var inst_82019 = (state_82043[(2)]);
var inst_82020 = (inst_81993 == null);
var state_82043__$1 = (function (){var statearr_82072 = state_82043;
(statearr_82072[(12)] = inst_82019);

return statearr_82072;
})();
if(cljs.core.truth_(inst_82020)){
var statearr_82073_82105 = state_82043__$1;
(statearr_82073_82105[(1)] = (19));

} else {
var statearr_82074_82106 = state_82043__$1;
(statearr_82074_82106[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (16))){
var inst_81999 = (state_82043[(10)]);
var inst_82005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82006 = ["_auth/id",inst_81999];
var inst_82007 = (new cljs.core.PersistentVector(null,2,(5),inst_82005,inst_82006,null));
var state_82043__$1 = state_82043;
var statearr_82075_82107 = state_82043__$1;
(statearr_82075_82107[(2)] = inst_82007);

(statearr_82075_82107[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (10))){
var inst_81991 = (state_82043[(7)]);
var inst_81997 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_81991);
var state_82043__$1 = state_82043;
var statearr_82076_82108 = state_82043__$1;
(statearr_82076_82108[(2)] = inst_81997);

(statearr_82076_82108[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82044 === (18))){
var inst_82000 = (state_82043[(14)]);
var inst_82003 = (state_82043[(11)]);
var inst_82010 = (state_82043[(2)]);
var inst_82011 = [inst_82010,inst_82000];
var inst_82012 = cljs.core.PersistentHashMap.fromArrays(inst_82003,inst_82011);
var inst_82013 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_82012], 0));
var state_82043__$1 = state_82043;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82043__$1,(15),inst_82013);
} else {
if((state_val_82044 === (8))){
var inst_81991 = (state_82043[(7)]);
var inst_81994 = (state_82043[(15)]);
var inst_81991__$1 = (state_82043[(2)]);
var inst_81992 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_81991__$1);
var inst_81993 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_81991__$1);
var inst_81994__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_81991__$1);
var state_82043__$1 = (function (){var statearr_82077 = state_82043;
(statearr_82077[(7)] = inst_81991__$1);

(statearr_82077[(15)] = inst_81994__$1);

(statearr_82077[(16)] = inst_81992);

(statearr_82077[(13)] = inst_81993);

return statearr_82077;
})();
if(cljs.core.truth_(inst_81994__$1)){
var statearr_82078_82109 = state_82043__$1;
(statearr_82078_82109[(1)] = (9));

} else {
var statearr_82079_82110 = state_82043__$1;
(statearr_82079_82110[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_82080 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82080[(0)] = flureedb$state_machine__2727__auto__);

(statearr_82080[(1)] = (1));

return statearr_82080;
});
var flureedb$state_machine__2727__auto____1 = (function (state_82043){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_82043);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e82081){var ex__2730__auto__ = e82081;
var statearr_82082_82111 = state_82043;
(statearr_82082_82111[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_82043[(4)]))){
var statearr_82083_82112 = state_82043;
(statearr_82083_82112[(1)] = cljs.core.first((state_82043[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82113 = state_82043;
state_82043 = G__82113;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_82043){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_82043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_82084 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_82084[(6)] = c__2749__auto__);

return statearr_82084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_82136){
var state_val_82137 = (state_82136[(1)]);
if((state_val_82137 === (1))){
var state_82136__$1 = state_82136;
var statearr_82138_82153 = state_82136__$1;
(statearr_82138_82153[(2)] = null);

(statearr_82138_82153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82137 === (2))){
var _ = (function (){var statearr_82139 = state_82136;
(statearr_82139[(4)] = cljs.core.cons((5),(state_82136[(4)])));

return statearr_82139;
})();
var inst_82125 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_82126 = fluree.db.api.query.history_query_async(sources,inst_82125);
var state_82136__$1 = state_82136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82136__$1,(6),inst_82126);
} else {
if((state_val_82137 === (3))){
var inst_82134 = (state_82136[(2)]);
var state_82136__$1 = state_82136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82136__$1,inst_82134);
} else {
if((state_val_82137 === (4))){
var inst_82114 = (state_82136[(2)]);
var inst_82115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82116 = [inst_82114];
var inst_82117 = (new cljs.core.PersistentVector(null,1,(5),inst_82115,inst_82116,null));
var inst_82118 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82117);
var inst_82119 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_82114) : reject.call(null,inst_82114));
var state_82136__$1 = (function (){var statearr_82141 = state_82136;
(statearr_82141[(7)] = inst_82118);

return statearr_82141;
})();
var statearr_82142_82154 = state_82136__$1;
(statearr_82142_82154[(2)] = inst_82119);

(statearr_82142_82154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82137 === (5))){
var _ = (function (){var statearr_82143 = state_82136;
(statearr_82143[(4)] = cljs.core.rest((state_82136[(4)])));

return statearr_82143;
})();
var state_82136__$1 = state_82136;
var ex82140 = (state_82136__$1[(2)]);
var statearr_82144_82155 = state_82136__$1;
(statearr_82144_82155[(5)] = ex82140);


var statearr_82145_82156 = state_82136__$1;
(statearr_82145_82156[(1)] = (4));

(statearr_82145_82156[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82137 === (6))){
var inst_82128 = (state_82136[(2)]);
var inst_82129 = fluree.db.util.async.throw_err(inst_82128);
var inst_82130 = cljs.core.clj__GT_js(inst_82129);
var inst_82131 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_82130) : resolve.call(null,inst_82130));
var _ = (function (){var statearr_82146 = state_82136;
(statearr_82146[(4)] = cljs.core.rest((state_82136[(4)])));

return statearr_82146;
})();
var state_82136__$1 = state_82136;
var statearr_82147_82157 = state_82136__$1;
(statearr_82147_82157[(2)] = inst_82131);

(statearr_82147_82157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2727__auto__ = null;
var flureedb$history_query_$_state_machine__2727__auto____0 = (function (){
var statearr_82148 = [null,null,null,null,null,null,null,null];
(statearr_82148[(0)] = flureedb$history_query_$_state_machine__2727__auto__);

(statearr_82148[(1)] = (1));

return statearr_82148;
});
var flureedb$history_query_$_state_machine__2727__auto____1 = (function (state_82136){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_82136);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e82149){var ex__2730__auto__ = e82149;
var statearr_82150_82158 = state_82136;
(statearr_82150_82158[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_82136[(4)]))){
var statearr_82151_82159 = state_82136;
(statearr_82151_82159[(1)] = cljs.core.first((state_82136[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82160 = state_82136;
state_82136 = G__82160;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2727__auto__ = function(state_82136){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2727__auto____1.call(this,state_82136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2727__auto____0;
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2727__auto____1;
return flureedb$history_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_82152 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_82152[(6)] = c__2749__auto__);

return statearr_82152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_82183){
var state_val_82184 = (state_82183[(1)]);
if((state_val_82184 === (1))){
var state_82183__$1 = state_82183;
var statearr_82185_82200 = state_82183__$1;
(statearr_82185_82200[(2)] = null);

(statearr_82185_82200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82184 === (2))){
var _ = (function (){var statearr_82186 = state_82183;
(statearr_82186[(4)] = cljs.core.cons((5),(state_82183[(4)])));

return statearr_82186;
})();
var inst_82172 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_82173 = fluree.db.api.query.multi_query_async(sources,inst_82172);
var state_82183__$1 = state_82183;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82183__$1,(6),inst_82173);
} else {
if((state_val_82184 === (3))){
var inst_82181 = (state_82183[(2)]);
var state_82183__$1 = state_82183;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82183__$1,inst_82181);
} else {
if((state_val_82184 === (4))){
var inst_82161 = (state_82183[(2)]);
var inst_82162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82163 = [inst_82161];
var inst_82164 = (new cljs.core.PersistentVector(null,1,(5),inst_82162,inst_82163,null));
var inst_82165 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82164);
var inst_82166 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_82161) : reject.call(null,inst_82161));
var state_82183__$1 = (function (){var statearr_82188 = state_82183;
(statearr_82188[(7)] = inst_82165);

return statearr_82188;
})();
var statearr_82189_82201 = state_82183__$1;
(statearr_82189_82201[(2)] = inst_82166);

(statearr_82189_82201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82184 === (5))){
var _ = (function (){var statearr_82190 = state_82183;
(statearr_82190[(4)] = cljs.core.rest((state_82183[(4)])));

return statearr_82190;
})();
var state_82183__$1 = state_82183;
var ex82187 = (state_82183__$1[(2)]);
var statearr_82191_82202 = state_82183__$1;
(statearr_82191_82202[(5)] = ex82187);


var statearr_82192_82203 = state_82183__$1;
(statearr_82192_82203[(1)] = (4));

(statearr_82192_82203[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82184 === (6))){
var inst_82175 = (state_82183[(2)]);
var inst_82176 = fluree.db.util.async.throw_err(inst_82175);
var inst_82177 = cljs.core.clj__GT_js(inst_82176);
var inst_82178 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_82177) : resolve.call(null,inst_82177));
var _ = (function (){var statearr_82193 = state_82183;
(statearr_82193[(4)] = cljs.core.rest((state_82183[(4)])));

return statearr_82193;
})();
var state_82183__$1 = state_82183;
var statearr_82194_82204 = state_82183__$1;
(statearr_82194_82204[(2)] = inst_82178);

(statearr_82194_82204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2727__auto__ = null;
var flureedb$multi_query_$_state_machine__2727__auto____0 = (function (){
var statearr_82195 = [null,null,null,null,null,null,null,null];
(statearr_82195[(0)] = flureedb$multi_query_$_state_machine__2727__auto__);

(statearr_82195[(1)] = (1));

return statearr_82195;
});
var flureedb$multi_query_$_state_machine__2727__auto____1 = (function (state_82183){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_82183);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e82196){var ex__2730__auto__ = e82196;
var statearr_82197_82205 = state_82183;
(statearr_82197_82205[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_82183[(4)]))){
var statearr_82198_82206 = state_82183;
(statearr_82198_82206[(1)] = cljs.core.first((state_82183[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82207 = state_82183;
state_82183 = G__82207;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2727__auto__ = function(state_82183){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2727__auto____1.call(this,state_82183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2727__auto____0;
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2727__auto____1;
return flureedb$multi_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_82199 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_82199[(6)] = c__2749__auto__);

return statearr_82199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_82230){
var state_val_82231 = (state_82230[(1)]);
if((state_val_82231 === (1))){
var state_82230__$1 = state_82230;
var statearr_82232_82247 = state_82230__$1;
(statearr_82232_82247[(2)] = null);

(statearr_82232_82247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82231 === (2))){
var _ = (function (){var statearr_82233 = state_82230;
(statearr_82233[(4)] = cljs.core.cons((5),(state_82230[(4)])));

return statearr_82233;
})();
var inst_82220 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_82221 = fluree.db.api.query.query_async(sources,inst_82220);
var state_82230__$1 = state_82230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82230__$1,(6),inst_82221);
} else {
if((state_val_82231 === (3))){
var inst_82228 = (state_82230[(2)]);
var state_82230__$1 = state_82230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82230__$1,inst_82228);
} else {
if((state_val_82231 === (4))){
var inst_82208 = (state_82230[(2)]);
var inst_82209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82210 = [inst_82208];
var inst_82211 = (new cljs.core.PersistentVector(null,1,(5),inst_82209,inst_82210,null));
var inst_82212 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82211);
var inst_82213 = cljs.core.clj__GT_js(inst_82208);
var inst_82214 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_82213) : reject.call(null,inst_82213));
var state_82230__$1 = (function (){var statearr_82235 = state_82230;
(statearr_82235[(7)] = inst_82212);

return statearr_82235;
})();
var statearr_82236_82248 = state_82230__$1;
(statearr_82236_82248[(2)] = inst_82214);

(statearr_82236_82248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82231 === (5))){
var _ = (function (){var statearr_82237 = state_82230;
(statearr_82237[(4)] = cljs.core.rest((state_82230[(4)])));

return statearr_82237;
})();
var state_82230__$1 = state_82230;
var ex82234 = (state_82230__$1[(2)]);
var statearr_82238_82249 = state_82230__$1;
(statearr_82238_82249[(5)] = ex82234);


var statearr_82239_82250 = state_82230__$1;
(statearr_82239_82250[(1)] = (4));

(statearr_82239_82250[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82231 === (6))){
var inst_82223 = (state_82230[(2)]);
var inst_82224 = cljs.core.clj__GT_js(inst_82223);
var inst_82225 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_82224) : resolve.call(null,inst_82224));
var _ = (function (){var statearr_82240 = state_82230;
(statearr_82240[(4)] = cljs.core.rest((state_82230[(4)])));

return statearr_82240;
})();
var state_82230__$1 = state_82230;
var statearr_82241_82251 = state_82230__$1;
(statearr_82241_82251[(2)] = inst_82225);

(statearr_82241_82251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2727__auto__ = null;
var flureedb$query_$_state_machine__2727__auto____0 = (function (){
var statearr_82242 = [null,null,null,null,null,null,null,null];
(statearr_82242[(0)] = flureedb$query_$_state_machine__2727__auto__);

(statearr_82242[(1)] = (1));

return statearr_82242;
});
var flureedb$query_$_state_machine__2727__auto____1 = (function (state_82230){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_82230);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e82243){var ex__2730__auto__ = e82243;
var statearr_82244_82252 = state_82230;
(statearr_82244_82252[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_82230[(4)]))){
var statearr_82245_82253 = state_82230;
(statearr_82245_82253[(1)] = cljs.core.first((state_82230[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82254 = state_82230;
state_82230 = G__82254;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2727__auto__ = function(state_82230){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2727__auto____1.call(this,state_82230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2727__auto____0;
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2727__auto____1;
return flureedb$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_82246 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_82246[(6)] = c__2749__auto__);

return statearr_82246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__82256 = arguments.length;
switch (G__82256) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_82286){
var state_val_82287 = (state_82286[(1)]);
if((state_val_82287 === (7))){
var inst_82273 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_82286__$1 = state_82286;
var statearr_82288_82309 = state_82286__$1;
(statearr_82288_82309[(2)] = inst_82273);

(statearr_82288_82309[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (1))){
var state_82286__$1 = state_82286;
var statearr_82289_82310 = state_82286__$1;
(statearr_82289_82310[(2)] = null);

(statearr_82289_82310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (4))){
var inst_82257 = (state_82286[(2)]);
var inst_82258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82259 = [inst_82257];
var inst_82260 = (new cljs.core.PersistentVector(null,1,(5),inst_82258,inst_82259,null));
var inst_82261 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82260);
var inst_82262 = cljs.core.clj__GT_js(inst_82257);
var inst_82263 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_82262) : reject.call(null,inst_82262));
var state_82286__$1 = (function (){var statearr_82290 = state_82286;
(statearr_82290[(7)] = inst_82261);

return statearr_82290;
})();
var statearr_82291_82311 = state_82286__$1;
(statearr_82291_82311[(2)] = inst_82263);

(statearr_82291_82311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (6))){
var state_82286__$1 = state_82286;
var statearr_82292_82312 = state_82286__$1;
(statearr_82292_82312[(2)] = null);

(statearr_82292_82312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (3))){
var inst_82284 = (state_82286[(2)]);
var state_82286__$1 = state_82286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82286__$1,inst_82284);
} else {
if((state_val_82287 === (2))){
var _ = (function (){var statearr_82294 = state_82286;
(statearr_82294[(4)] = cljs.core.cons((5),(state_82286[(4)])));

return statearr_82294;
})();
var inst_82269 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_82270 = (opts == null);
var state_82286__$1 = (function (){var statearr_82295 = state_82286;
(statearr_82295[(8)] = inst_82269);

return statearr_82295;
})();
if(cljs.core.truth_(inst_82270)){
var statearr_82296_82313 = state_82286__$1;
(statearr_82296_82313[(1)] = (6));

} else {
var statearr_82297_82314 = state_82286__$1;
(statearr_82297_82314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (9))){
var inst_82278 = (state_82286[(2)]);
var inst_82279 = fluree.db.util.async.throw_err(inst_82278);
var inst_82280 = cljs.core.clj__GT_js(inst_82279);
var inst_82281 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_82280) : resolve.call(null,inst_82280));
var _ = (function (){var statearr_82298 = state_82286;
(statearr_82298[(4)] = cljs.core.rest((state_82286[(4)])));

return statearr_82298;
})();
var state_82286__$1 = state_82286;
var statearr_82299_82315 = state_82286__$1;
(statearr_82299_82315[(2)] = inst_82281);

(statearr_82299_82315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (5))){
var _ = (function (){var statearr_82300 = state_82286;
(statearr_82300[(4)] = cljs.core.rest((state_82286[(4)])));

return statearr_82300;
})();
var state_82286__$1 = state_82286;
var ex82293 = (state_82286__$1[(2)]);
var statearr_82301_82316 = state_82286__$1;
(statearr_82301_82316[(5)] = ex82293);


var statearr_82302_82317 = state_82286__$1;
(statearr_82302_82317[(1)] = (4));

(statearr_82302_82317[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82287 === (8))){
var inst_82269 = (state_82286[(8)]);
var inst_82275 = (state_82286[(2)]);
var inst_82276 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_82269,inst_82275);
var state_82286__$1 = state_82286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82286__$1,(9),inst_82276);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_82303 = [null,null,null,null,null,null,null,null,null];
(statearr_82303[(0)] = flureedb$state_machine__2727__auto__);

(statearr_82303[(1)] = (1));

return statearr_82303;
});
var flureedb$state_machine__2727__auto____1 = (function (state_82286){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_82286);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e82304){var ex__2730__auto__ = e82304;
var statearr_82305_82318 = state_82286;
(statearr_82305_82318[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_82286[(4)]))){
var statearr_82306_82319 = state_82286;
(statearr_82306_82319[(1)] = cljs.core.first((state_82286[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82320 = state_82286;
state_82286 = G__82320;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_82286){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_82286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_82307 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_82307[(6)] = c__2749__auto__);

return statearr_82307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
