// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__24519){
var map__24520 = p__24519;
var map__24520__$1 = cljs.core.__destructure_map(map__24520);
var parsed_query = map__24520__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24520__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24520__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db(db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__24521){
var map__24522 = p__24521;
var map__24522__$1 = cljs.core.__destructure_map(map__24522);
var opts = map__24522__$1;
var rdf_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24522__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24522__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24566){
var state_val_24567 = (state_24566[(1)]);
if((state_val_24567 === (7))){
var inst_24545 = (state_24566[(7)]);
var inst_24547 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(inst_24545);
var state_24566__$1 = state_24566;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24566__$1,(10),inst_24547);
} else {
if((state_val_24567 === (1))){
var inst_24530 = vars;
var inst_24531 = cljs.core.seq(inst_24530);
var inst_24532 = cljs.core.first(inst_24531);
var inst_24533 = cljs.core.next(inst_24531);
var inst_24534 = cljs.core.PersistentVector.EMPTY;
var inst_24535 = inst_24530;
var inst_24536 = inst_24534;
var state_24566__$1 = (function (){var statearr_24568 = state_24566;
(statearr_24568[(8)] = inst_24536);

(statearr_24568[(9)] = inst_24535);

(statearr_24568[(10)] = inst_24532);

(statearr_24568[(11)] = inst_24533);

return statearr_24568;
})();
var statearr_24569_24587 = state_24566__$1;
(statearr_24569_24587[(2)] = null);

(statearr_24569_24587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (4))){
var inst_24542 = (state_24566[(12)]);
var inst_24545 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24542);
var state_24566__$1 = (function (){var statearr_24570 = state_24566;
(statearr_24570[(7)] = inst_24545);

return statearr_24570;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_24571_24588 = state_24566__$1;
(statearr_24571_24588[(1)] = (7));

} else {
var statearr_24572_24589 = state_24566__$1;
(statearr_24572_24589[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (6))){
var inst_24562 = (state_24566[(2)]);
var state_24566__$1 = state_24566;
var statearr_24573_24590 = state_24566__$1;
(statearr_24573_24590[(2)] = inst_24562);

(statearr_24573_24590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (3))){
var inst_24564 = (state_24566[(2)]);
var state_24566__$1 = state_24566;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24566__$1,inst_24564);
} else {
if((state_val_24567 === (2))){
var inst_24535 = (state_24566[(9)]);
var inst_24542 = (state_24566[(12)]);
var inst_24541 = cljs.core.seq(inst_24535);
var inst_24542__$1 = cljs.core.first(inst_24541);
var inst_24543 = cljs.core.next(inst_24541);
var state_24566__$1 = (function (){var statearr_24574 = state_24566;
(statearr_24574[(13)] = inst_24543);

(statearr_24574[(12)] = inst_24542__$1);

return statearr_24574;
})();
if(cljs.core.truth_(inst_24542__$1)){
var statearr_24575_24591 = state_24566__$1;
(statearr_24575_24591[(1)] = (4));

} else {
var statearr_24576_24592 = state_24566__$1;
(statearr_24576_24592[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (11))){
var inst_24554 = (state_24566[(2)]);
var inst_24555 = fluree.db.util.async.throw_err(inst_24554);
var state_24566__$1 = state_24566;
var statearr_24577_24593 = state_24566__$1;
(statearr_24577_24593[(2)] = inst_24555);

(statearr_24577_24593[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (9))){
var inst_24536 = (state_24566[(8)]);
var inst_24543 = (state_24566[(13)]);
var inst_24557 = (state_24566[(2)]);
var inst_24558 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24536,inst_24557);
var inst_24535 = inst_24543;
var inst_24536__$1 = inst_24558;
var state_24566__$1 = (function (){var statearr_24578 = state_24566;
(statearr_24578[(8)] = inst_24536__$1);

(statearr_24578[(9)] = inst_24535);

return statearr_24578;
})();
var statearr_24579_24594 = state_24566__$1;
(statearr_24579_24594[(2)] = null);

(statearr_24579_24594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (5))){
var inst_24536 = (state_24566[(8)]);
var state_24566__$1 = state_24566;
var statearr_24580_24595 = state_24566__$1;
(statearr_24580_24595[(2)] = inst_24536);

(statearr_24580_24595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (10))){
var inst_24549 = (state_24566[(2)]);
var inst_24550 = fluree.db.util.async.throw_err(inst_24549);
var state_24566__$1 = state_24566;
var statearr_24581_24596 = state_24566__$1;
(statearr_24581_24596[(2)] = inst_24550);

(statearr_24581_24596[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24567 === (8))){
var inst_24545 = (state_24566[(7)]);
var inst_24552 = fluree.db.query.subject_crawl.subject.subj_crawl(inst_24545);
var state_24566__$1 = state_24566;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24566__$1,(11),inst_24552);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0 = (function (){
var statearr_24582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24582[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__);

(statearr_24582[(1)] = (1));

return statearr_24582;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1 = (function (state_24566){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24566);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24583){var ex__2730__auto__ = e24583;
var statearr_24584_24597 = state_24566;
(statearr_24584_24597[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24566[(4)]))){
var statearr_24585_24598 = state_24566;
(statearr_24585_24598[(1)] = cljs.core.first((state_24566[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24599 = state_24566;
state_24566 = G__24599;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = function(state_24566){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1.call(this,state_24566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24586 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24586[(6)] = c__2749__auto__);

return statearr_24586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__24601){
var map__24602 = p__24601;
var map__24602__$1 = cljs.core.__destructure_map(map__24602);
var parsed_query = map__24602__$1;
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24602__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24602__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24602__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var fns = (function (){var G__24603 = cljs.core.PersistentVector.EMPTY;
var G__24603__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24603,(function (result){
return cljs.core.first(result);
})):G__24603);
var G__24603__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24603__$1,(function (){var select_var = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__24600_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__24600_SHARP_]);
}),result);
});
})()):G__24603__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24603__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results(result,order_by);
}));
} else {
return G__24603__$2;
}
})();
if(cljs.core.empty_QMARK_(fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__24604){
var map__24605 = p__24604;
var map__24605__$1 = cljs.core.__destructure_map(map__24605);
var parsed_query = map__24605__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var error_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var f_where = cljs.core.first(where);
var rdf_type_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second(where));
var cache = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_((0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec(db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn(parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,limit,offset,db,error_ch,cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding(opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl(opts);
}
}
});
