// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16049){
var state_val_16050 = (state_16049[(1)]);
if((state_val_16050 === (1))){
var state_16049__$1 = state_16049;
var statearr_16051_16065 = state_16049__$1;
(statearr_16051_16065[(2)] = null);

(statearr_16051_16065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16050 === (2))){
var _ = (function (){var statearr_16052 = state_16049;
(statearr_16052[(4)] = cljs.core.cons((5),(state_16049[(4)])));

return statearr_16052;
})();
var inst_16040 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_16049__$1 = state_16049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16049__$1,(6),inst_16040);
} else {
if((state_val_16050 === (3))){
var inst_16047 = (state_16049[(2)]);
var state_16049__$1 = state_16049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16049__$1,inst_16047);
} else {
if((state_val_16050 === (4))){
var inst_16034 = (state_16049[(2)]);
var state_16049__$1 = state_16049;
var statearr_16054_16066 = state_16049__$1;
(statearr_16054_16066[(2)] = inst_16034);

(statearr_16054_16066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16050 === (5))){
var _ = (function (){var statearr_16055 = state_16049;
(statearr_16055[(4)] = cljs.core.rest((state_16049[(4)])));

return statearr_16055;
})();
var state_16049__$1 = state_16049;
var ex16053 = (state_16049__$1[(2)]);
var statearr_16056_16067 = state_16049__$1;
(statearr_16056_16067[(5)] = ex16053);


if((ex16053 instanceof Error)){
var statearr_16057_16068 = state_16049__$1;
(statearr_16057_16068[(1)] = (4));

(statearr_16057_16068[(5)] = null);

} else {
throw ex16053;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16050 === (6))){
var inst_16042 = (state_16049[(2)]);
var inst_16043 = fluree.db.util.async.throw_err(inst_16042);
var inst_16044 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16043);
var _ = (function (){var statearr_16058 = state_16049;
(statearr_16058[(4)] = cljs.core.rest((state_16049[(4)])));

return statearr_16058;
})();
var state_16049__$1 = state_16049;
var statearr_16059_16069 = state_16049__$1;
(statearr_16059_16069[(2)] = inst_16044);

(statearr_16059_16069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0 = (function (){
var statearr_16060 = [null,null,null,null,null,null,null];
(statearr_16060[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__);

(statearr_16060[(1)] = (1));

return statearr_16060;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1 = (function (state_16049){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16049);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16061){var ex__2730__auto__ = e16061;
var statearr_16062_16070 = state_16049;
(statearr_16062_16070[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16049[(4)]))){
var statearr_16063_16071 = state_16049;
(statearr_16063_16071[(1)] = cljs.core.first((state_16049[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16072 = state_16049;
state_16049 = G__16072;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = function(state_16049){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1.call(this,state_16049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16064 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16064[(6)] = c__2749__auto__);

return statearr_16064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16104){
var state_val_16105 = (state_16104[(1)]);
if((state_val_16105 === (7))){
var inst_16088 = (state_16104[(7)]);
var inst_16090 = cljs.core.empty_QMARK_(inst_16088);
var inst_16091 = (!(inst_16090));
var state_16104__$1 = state_16104;
var statearr_16106_16130 = state_16104__$1;
(statearr_16106_16130[(2)] = inst_16091);

(statearr_16106_16130[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (1))){
var state_16104__$1 = state_16104;
var statearr_16107_16131 = state_16104__$1;
(statearr_16107_16131[(2)] = null);

(statearr_16107_16131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (4))){
var inst_16074 = (state_16104[(2)]);
var state_16104__$1 = state_16104;
var statearr_16108_16132 = state_16104__$1;
(statearr_16108_16132[(2)] = inst_16074);

(statearr_16108_16132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (6))){
var inst_16080 = (state_16104[(8)]);
var inst_16088 = (state_16104[(7)]);
var inst_16086 = (state_16104[(2)]);
var inst_16087 = fluree.db.util.async.throw_err(inst_16086);
var inst_16088__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16080,inst_16087);
var state_16104__$1 = (function (){var statearr_16109 = state_16104;
(statearr_16109[(7)] = inst_16088__$1);

return statearr_16109;
})();
if(cljs.core.truth_(inst_16088__$1)){
var statearr_16110_16133 = state_16104__$1;
(statearr_16110_16133[(1)] = (7));

} else {
var statearr_16111_16134 = state_16104__$1;
(statearr_16111_16134[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (3))){
var inst_16102 = (state_16104[(2)]);
var state_16104__$1 = state_16104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16104__$1,inst_16102);
} else {
if((state_val_16105 === (12))){
var inst_16099 = (state_16104[(2)]);
var _ = (function (){var statearr_16112 = state_16104;
(statearr_16112[(4)] = cljs.core.rest((state_16104[(4)])));

return statearr_16112;
})();
var state_16104__$1 = state_16104;
var statearr_16113_16135 = state_16104__$1;
(statearr_16113_16135[(2)] = inst_16099);

(statearr_16113_16135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (2))){
var _ = (function (){var statearr_16114 = state_16104;
(statearr_16114[(4)] = cljs.core.cons((5),(state_16104[(4)])));

return statearr_16114;
})();
var inst_16080 = (function (){return (function (p1__16073_SHARP_){
return fluree.db.flake.o(p1__16073_SHARP_);
});
})();
var inst_16081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16082 = [pred_id];
var inst_16083 = (new cljs.core.PersistentVector(null,1,(5),inst_16081,inst_16082,null));
var inst_16084 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16083);
var state_16104__$1 = (function (){var statearr_16115 = state_16104;
(statearr_16115[(8)] = inst_16080);

return statearr_16115;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16104__$1,(6),inst_16084);
} else {
if((state_val_16105 === (11))){
var state_16104__$1 = state_16104;
var statearr_16117_16136 = state_16104__$1;
(statearr_16117_16136[(2)] = true);

(statearr_16117_16136[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (9))){
var inst_16094 = (state_16104[(2)]);
var state_16104__$1 = state_16104;
if(cljs.core.truth_(inst_16094)){
var statearr_16118_16137 = state_16104__$1;
(statearr_16118_16137[(1)] = (10));

} else {
var statearr_16119_16138 = state_16104__$1;
(statearr_16119_16138[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (5))){
var _ = (function (){var statearr_16120 = state_16104;
(statearr_16120[(4)] = cljs.core.rest((state_16104[(4)])));

return statearr_16120;
})();
var state_16104__$1 = state_16104;
var ex16116 = (state_16104__$1[(2)]);
var statearr_16121_16139 = state_16104__$1;
(statearr_16121_16139[(5)] = ex16116);


if((ex16116 instanceof Error)){
var statearr_16122_16140 = state_16104__$1;
(statearr_16122_16140[(1)] = (4));

(statearr_16122_16140[(5)] = null);

} else {
throw ex16116;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (10))){
var inst_16088 = (state_16104[(7)]);
var inst_16096 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_16088);
var state_16104__$1 = state_16104;
var statearr_16123_16141 = state_16104__$1;
(statearr_16123_16141[(2)] = inst_16096);

(statearr_16123_16141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16105 === (8))){
var inst_16088 = (state_16104[(7)]);
var state_16104__$1 = state_16104;
var statearr_16124_16142 = state_16104__$1;
(statearr_16124_16142[(2)] = inst_16088);

(statearr_16124_16142[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_16125 = [null,null,null,null,null,null,null,null,null];
(statearr_16125[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__);

(statearr_16125[(1)] = (1));

return statearr_16125;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1 = (function (state_16104){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16104);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16126){var ex__2730__auto__ = e16126;
var statearr_16127_16143 = state_16104;
(statearr_16127_16143[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16104[(4)]))){
var statearr_16128_16144 = state_16104;
(statearr_16128_16144[(1)] = cljs.core.first((state_16104[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16145 = state_16104;
state_16104 = G__16145;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = function(state_16104){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1.call(this,state_16104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16129 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16129[(6)] = c__2749__auto__);

return statearr_16129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16226){
var state_val_16227 = (state_16226[(1)]);
if((state_val_16227 === (7))){
var state_16226__$1 = state_16226;
var statearr_16228_16266 = state_16226__$1;
(statearr_16228_16266[(2)] = flakes);

(statearr_16228_16266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (20))){
var inst_16183 = (state_16226[(7)]);
var inst_16216 = (state_16226[(2)]);
var inst_16175 = inst_16183;
var inst_16176 = inst_16216;
var state_16226__$1 = (function (){var statearr_16229 = state_16226;
(statearr_16229[(8)] = inst_16176);

(statearr_16229[(9)] = inst_16175);

return statearr_16229;
})();
var statearr_16230_16267 = state_16226__$1;
(statearr_16230_16267[(2)] = null);

(statearr_16230_16267[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (1))){
var state_16226__$1 = state_16226;
var statearr_16231_16268 = state_16226__$1;
(statearr_16231_16268[(2)] = null);

(statearr_16231_16268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (4))){
var inst_16148 = (state_16226[(2)]);
var state_16226__$1 = state_16226;
var statearr_16232_16269 = state_16226__$1;
(statearr_16232_16269[(2)] = inst_16148);

(statearr_16232_16269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (15))){
var inst_16182 = (state_16226[(10)]);
var inst_16200 = fluree.db.flake.o(inst_16182);
var state_16226__$1 = state_16226;
var statearr_16233_16270 = state_16226__$1;
(statearr_16233_16270[(2)] = inst_16200);

(statearr_16233_16270[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (13))){
var inst_16219 = (state_16226[(2)]);
var state_16226__$1 = state_16226;
var statearr_16234_16271 = state_16226__$1;
(statearr_16234_16271[(2)] = inst_16219);

(statearr_16234_16271[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (6))){
var inst_16155 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16226__$1 = state_16226;
var statearr_16235_16272 = state_16226__$1;
(statearr_16235_16272[(2)] = inst_16155);

(statearr_16235_16272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (17))){
var inst_16197 = (state_16226[(2)]);
var inst_16198 = fluree.db.util.async.throw_err(inst_16197);
var state_16226__$1 = state_16226;
var statearr_16236_16273 = state_16226__$1;
(statearr_16236_16273[(2)] = inst_16198);

(statearr_16236_16273[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (3))){
var inst_16224 = (state_16226[(2)]);
var state_16226__$1 = state_16226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16226__$1,inst_16224);
} else {
if((state_val_16227 === (12))){
var inst_16182 = (state_16226[(10)]);
var inst_16189 = (state_16226[(11)]);
var inst_16187 = fluree.db.flake.p(inst_16182);
var inst_16188 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16187);
var inst_16189__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16188);
var inst_16190 = fluree.db.flake.op(inst_16182);
var inst_16191 = inst_16190 === false;
var inst_16192 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16189__$1);
var state_16226__$1 = (function (){var statearr_16237 = state_16226;
(statearr_16237[(12)] = inst_16191);

(statearr_16237[(11)] = inst_16189__$1);

return statearr_16237;
})();
if(inst_16192){
var statearr_16238_16274 = state_16226__$1;
(statearr_16238_16274[(1)] = (14));

} else {
var statearr_16239_16275 = state_16226__$1;
(statearr_16239_16275[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (2))){
var _ = (function (){var statearr_16240 = state_16226;
(statearr_16240[(4)] = cljs.core.cons((5),(state_16226[(4)])));

return statearr_16240;
})();
var state_16226__$1 = state_16226;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16241_16276 = state_16226__$1;
(statearr_16241_16276[(1)] = (6));

} else {
var statearr_16242_16277 = state_16226__$1;
(statearr_16242_16277[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (19))){
var inst_16176 = (state_16226[(8)]);
var inst_16182 = (state_16226[(10)]);
var inst_16189 = (state_16226[(11)]);
var inst_16202 = (state_16226[(13)]);
var inst_16210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16211 = fluree.db.flake.s(inst_16182);
var inst_16212 = [inst_16211,inst_16189,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16213 = (new cljs.core.PersistentVector(null,3,(5),inst_16210,inst_16212,null));
var inst_16214 = cljs.core.assoc_in(inst_16176,inst_16213,inst_16202);
var state_16226__$1 = state_16226;
var statearr_16243_16278 = state_16226__$1;
(statearr_16243_16278[(2)] = inst_16214);

(statearr_16243_16278[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (11))){
var inst_16176 = (state_16226[(8)]);
var state_16226__$1 = state_16226;
var statearr_16245_16279 = state_16226__$1;
(statearr_16245_16279[(2)] = inst_16176);

(statearr_16245_16279[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (9))){
var inst_16182 = (state_16226[(10)]);
var inst_16175 = (state_16226[(9)]);
var inst_16181 = cljs.core.seq(inst_16175);
var inst_16182__$1 = cljs.core.first(inst_16181);
var inst_16183 = cljs.core.next(inst_16181);
var inst_16184 = cljs.core.not(inst_16182__$1);
var state_16226__$1 = (function (){var statearr_16246 = state_16226;
(statearr_16246[(10)] = inst_16182__$1);

(statearr_16246[(7)] = inst_16183);

return statearr_16246;
})();
if(inst_16184){
var statearr_16247_16280 = state_16226__$1;
(statearr_16247_16280[(1)] = (11));

} else {
var statearr_16248_16281 = state_16226__$1;
(statearr_16248_16281[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (5))){
var _ = (function (){var statearr_16249 = state_16226;
(statearr_16249[(4)] = cljs.core.rest((state_16226[(4)])));

return statearr_16249;
})();
var state_16226__$1 = state_16226;
var ex16244 = (state_16226__$1[(2)]);
var statearr_16250_16282 = state_16226__$1;
(statearr_16250_16282[(5)] = ex16244);


if((ex16244 instanceof Error)){
var statearr_16251_16283 = state_16226__$1;
(statearr_16251_16283[(1)] = (4));

(statearr_16251_16283[(5)] = null);

} else {
throw ex16244;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (14))){
var inst_16182 = (state_16226[(10)]);
var inst_16194 = fluree.db.flake.o(inst_16182);
var inst_16195 = fluree.db.query.schema.convert_type_to_kw(inst_16194,db);
var state_16226__$1 = state_16226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16226__$1,(17),inst_16195);
} else {
if((state_val_16227 === (16))){
var inst_16191 = (state_16226[(12)]);
var inst_16202 = (state_16226[(2)]);
var state_16226__$1 = (function (){var statearr_16252 = state_16226;
(statearr_16252[(13)] = inst_16202);

return statearr_16252;
})();
if(cljs.core.truth_(inst_16191)){
var statearr_16253_16284 = state_16226__$1;
(statearr_16253_16284[(1)] = (18));

} else {
var statearr_16254_16285 = state_16226__$1;
(statearr_16254_16285[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (10))){
var inst_16221 = (state_16226[(2)]);
var _ = (function (){var statearr_16255 = state_16226;
(statearr_16255[(4)] = cljs.core.rest((state_16226[(4)])));

return statearr_16255;
})();
var state_16226__$1 = state_16226;
var statearr_16256_16286 = state_16226__$1;
(statearr_16256_16286[(2)] = inst_16221);

(statearr_16256_16286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (18))){
var inst_16176 = (state_16226[(8)]);
var inst_16182 = (state_16226[(10)]);
var inst_16189 = (state_16226[(11)]);
var inst_16202 = (state_16226[(13)]);
var inst_16204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16205 = fluree.db.flake.s(inst_16182);
var inst_16206 = [inst_16205,inst_16189,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16207 = (new cljs.core.PersistentVector(null,3,(5),inst_16204,inst_16206,null));
var inst_16208 = cljs.core.assoc_in(inst_16176,inst_16207,inst_16202);
var state_16226__$1 = state_16226;
var statearr_16257_16287 = state_16226__$1;
(statearr_16257_16287[(2)] = inst_16208);

(statearr_16257_16287[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16227 === (8))){
var inst_16158 = (state_16226[(2)]);
var inst_16159 = cljs.core.PersistentHashSet.EMPTY;
var inst_16160 = cljs.core.vals(tempids);
var inst_16161 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16159,inst_16160);
var inst_16162 = (function (){var pred_flakes = inst_16158;
var is_new_QMARK_ = inst_16161;
return (function (p1__16147_SHARP_,p2__16146_SHARP_){
var f = p2__16146_SHARP_;
return cljs.core.assoc_in(p1__16147_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s(f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16258 = fluree.db.flake.s(f);
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16258) : is_new_QMARK_.call(null,G__16258));
})()));
});
})();
var inst_16163 = cljs.core.PersistentHashMap.EMPTY;
var inst_16164 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16162,inst_16163,inst_16158);
var inst_16172 = cljs.core.seq(inst_16158);
var inst_16173 = cljs.core.first(inst_16172);
var inst_16174 = cljs.core.next(inst_16172);
var inst_16175 = inst_16158;
var inst_16176 = inst_16164;
var state_16226__$1 = (function (){var statearr_16259 = state_16226;
(statearr_16259[(14)] = inst_16173);

(statearr_16259[(8)] = inst_16176);

(statearr_16259[(9)] = inst_16175);

(statearr_16259[(15)] = inst_16174);

return statearr_16259;
})();
var statearr_16260_16288 = state_16226__$1;
(statearr_16260_16288[(2)] = null);

(statearr_16260_16288[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0 = (function (){
var statearr_16261 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16261[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__);

(statearr_16261[(1)] = (1));

return statearr_16261;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1 = (function (state_16226){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16226);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16262){var ex__2730__auto__ = e16262;
var statearr_16263_16289 = state_16226;
(statearr_16263_16289[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16226[(4)]))){
var statearr_16264_16290 = state_16226;
(statearr_16264_16290[(1)] = cljs.core.first((state_16226[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16291 = state_16226;
state_16226 = G__16291;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = function(state_16226){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1.call(this,state_16226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16265 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16265[(6)] = c__2749__auto__);

return statearr_16265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16293 = arguments.length;
switch (G__16293) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16296 = arguments.length;
switch (G__16296) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16608){
var state_val_16609 = (state_16608[(1)]);
if((state_val_16609 === (121))){
var inst_16563 = (state_16608[(7)]);
var state_16608__$1 = state_16608;
var statearr_16610_16803 = state_16608__$1;
(statearr_16610_16803[(2)] = inst_16563);

(statearr_16610_16803[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (65))){
var inst_16462 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16462)){
var statearr_16611_16804 = state_16608__$1;
(statearr_16611_16804[(1)] = (66));

} else {
var statearr_16612_16805 = state_16608__$1;
(statearr_16612_16805[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (70))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16472 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16473 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16472,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,3,inst_16472,null));
var inst_16474 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16473,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16473,null));
var inst_16475 = (inst_16474.cljs$core$IFn$_invoke$arity$1 ? inst_16474.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16474.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16475)){
var statearr_16613_16806 = state_16608__$1;
(statearr_16613_16806[(1)] = (72));

} else {
var statearr_16614_16807 = state_16608__$1;
(statearr_16614_16807[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (62))){
var inst_16452 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16615_16808 = state_16608__$1;
(statearr_16615_16808[(2)] = inst_16452);

(statearr_16615_16808[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (74))){
var inst_16558 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16616_16809 = state_16608__$1;
(statearr_16616_16809[(2)] = inst_16558);

(statearr_16616_16809[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (110))){
var inst_16585 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16585)){
var statearr_16617_16810 = state_16608__$1;
(statearr_16617_16810[(1)] = (117));

} else {
var statearr_16618_16811 = state_16608__$1;
(statearr_16618_16811[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (7))){
var inst_16603 = (state_16608[(2)]);
var _ = (function (){var statearr_16619 = state_16608;
(statearr_16619[(4)] = cljs.core.rest((state_16608[(4)])));

return statearr_16619;
})();
var state_16608__$1 = state_16608;
var statearr_16620_16812 = state_16608__$1;
(statearr_16620_16812[(2)] = inst_16603);

(statearr_16620_16812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (59))){
var inst_16336 = (state_16608[(10)]);
var inst_16456 = (state_16608[(11)]);
var inst_16455 = (state_16608[(2)]);
var inst_16456__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16621 = state_16608;
(statearr_16621[(12)] = inst_16455);

(statearr_16621[(11)] = inst_16456__$1);

return statearr_16621;
})();
if(cljs.core.truth_(inst_16456__$1)){
var statearr_16622_16813 = state_16608__$1;
(statearr_16622_16813[(1)] = (63));

} else {
var statearr_16623_16814 = state_16608__$1;
(statearr_16623_16814[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (86))){
var inst_16498 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16624_16815 = state_16608__$1;
(statearr_16624_16815[(2)] = inst_16498);

(statearr_16624_16815[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (20))){
var inst_16336 = (state_16608[(10)]);
var inst_16362 = (state_16608[(13)]);
var inst_16362__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16625 = state_16608;
(statearr_16625[(13)] = inst_16362__$1);

return statearr_16625;
})();
if(cljs.core.truth_(inst_16362__$1)){
var statearr_16626_16816 = state_16608__$1;
(statearr_16626_16816[(1)] = (23));

} else {
var statearr_16627_16817 = state_16608__$1;
(statearr_16627_16817[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (72))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16477 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16628_16818 = state_16608__$1;
(statearr_16628_16818[(2)] = inst_16477);

(statearr_16628_16818[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (58))){
var inst_16417 = (state_16608[(14)]);
var state_16608__$1 = state_16608;
var statearr_16629_16819 = state_16608__$1;
(statearr_16629_16819[(2)] = inst_16417);

(statearr_16629_16819[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (60))){
var inst_16335 = (state_16608[(15)]);
var inst_16324 = (state_16608[(16)]);
var inst_16443 = fluree.db.dbproto._p_prop(inst_16324,new cljs.core.Keyword(null,"name","name",1843675177),inst_16335);
var inst_16444 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16443)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16445 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16446 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16447 = cljs.core.PersistentHashMap.fromArrays(inst_16445,inst_16446);
var inst_16448 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16444,inst_16447);
var inst_16449 = (function(){throw inst_16448})();
var state_16608__$1 = state_16608;
var statearr_16630_16820 = state_16608__$1;
(statearr_16630_16820[(2)] = inst_16449);

(statearr_16630_16820[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (27))){
var inst_16365 = (state_16608[(17)]);
var state_16608__$1 = state_16608;
var statearr_16631_16821 = state_16608__$1;
(statearr_16631_16821[(2)] = inst_16365);

(statearr_16631_16821[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (1))){
var state_16608__$1 = state_16608;
var statearr_16632_16822 = state_16608__$1;
(statearr_16632_16822[(2)] = null);

(statearr_16632_16822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (69))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16633_16823 = state_16608__$1;
(statearr_16633_16823[(2)] = inst_16455);

(statearr_16633_16823[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (101))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16536 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16634_16824 = state_16608__$1;
(statearr_16634_16824[(2)] = inst_16536);

(statearr_16634_16824[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (24))){
var inst_16362 = (state_16608[(13)]);
var state_16608__$1 = state_16608;
var statearr_16635_16825 = state_16608__$1;
(statearr_16635_16825[(2)] = inst_16362);

(statearr_16635_16825[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (102))){
var inst_16538 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16636_16826 = state_16608__$1;
(statearr_16636_16826[(2)] = inst_16538);

(statearr_16636_16826[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (55))){
var inst_16434 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16637_16827 = state_16608__$1;
(statearr_16637_16827[(2)] = inst_16434);

(statearr_16637_16827[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (85))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16496 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16638_16828 = state_16608__$1;
(statearr_16638_16828[(2)] = inst_16496);

(statearr_16638_16828[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (39))){
var inst_16399 = (state_16608[(18)]);
var state_16608__$1 = state_16608;
var statearr_16639_16829 = state_16608__$1;
(statearr_16639_16829[(2)] = inst_16399);

(statearr_16639_16829[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (88))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16640_16830 = state_16608__$1;
(statearr_16640_16830[(2)] = inst_16455);

(statearr_16640_16830[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (46))){
var inst_16336 = (state_16608[(10)]);
var inst_16418 = (state_16608[(19)]);
var inst_16417 = (state_16608[(2)]);
var inst_16418__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16641 = state_16608;
(statearr_16641[(19)] = inst_16418__$1);

(statearr_16641[(14)] = inst_16417);

return statearr_16641;
})();
if(cljs.core.truth_(inst_16418__$1)){
var statearr_16642_16831 = state_16608__$1;
(statearr_16642_16831[(1)] = (47));

} else {
var statearr_16643_16832 = state_16608__$1;
(statearr_16643_16832[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (4))){
var inst_16297 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16644_16833 = state_16608__$1;
(statearr_16644_16833[(2)] = inst_16297);

(statearr_16644_16833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (77))){
var inst_16556 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16645_16834 = state_16608__$1;
(statearr_16645_16834[(2)] = inst_16556);

(statearr_16645_16834[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (106))){
var inst_16548 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16646_16835 = state_16608__$1;
(statearr_16646_16835[(2)] = inst_16548);

(statearr_16646_16835[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (119))){
var inst_16334 = (state_16608[(20)]);
var inst_16598 = (state_16608[(2)]);
var inst_16323 = inst_16334;
var inst_16324 = inst_16598;
var state_16608__$1 = (function (){var statearr_16647 = state_16608;
(statearr_16647[(16)] = inst_16324);

(statearr_16647[(21)] = inst_16323);

return statearr_16647;
})();
var statearr_16648_16836 = state_16608__$1;
(statearr_16648_16836[(2)] = null);

(statearr_16648_16836[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (95))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16520 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16521 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16520,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,5,inst_16520,null));
var inst_16522 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16521,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16521,null));
var inst_16523 = (inst_16522.cljs$core$IFn$_invoke$arity$1 ? inst_16522.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16522.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16523)){
var statearr_16649_16837 = state_16608__$1;
(statearr_16649_16837[(1)] = (96));

} else {
var statearr_16650_16838 = state_16608__$1;
(statearr_16650_16838[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (54))){
var inst_16425 = (state_16608[(22)]);
var state_16608__$1 = state_16608;
var statearr_16651_16839 = state_16608__$1;
(statearr_16651_16839[(2)] = inst_16425);

(statearr_16651_16839[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (92))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16652_16840 = state_16608__$1;
(statearr_16652_16840[(2)] = inst_16455);

(statearr_16652_16840[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (104))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16653_16841 = state_16608__$1;
(statearr_16653_16841[(2)] = inst_16455);

(statearr_16653_16841[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (15))){
var inst_16344 = (state_16608[(23)]);
var state_16608__$1 = state_16608;
var statearr_16654_16842 = state_16608__$1;
(statearr_16654_16842[(2)] = inst_16344);

(statearr_16654_16842[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (48))){
var inst_16418 = (state_16608[(19)]);
var state_16608__$1 = state_16608;
var statearr_16655_16843 = state_16608__$1;
(statearr_16655_16843[(2)] = inst_16418);

(statearr_16655_16843[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (50))){
var inst_16336 = (state_16608[(10)]);
var inst_16425 = (state_16608[(22)]);
var inst_16423 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16424 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16423);
var inst_16425__$1 = inst_16424 === true;
var state_16608__$1 = (function (){var statearr_16656 = state_16608;
(statearr_16656[(22)] = inst_16425__$1);

return statearr_16656;
})();
if(cljs.core.truth_(inst_16425__$1)){
var statearr_16657_16844 = state_16608__$1;
(statearr_16657_16844[(1)] = (53));

} else {
var statearr_16658_16845 = state_16608__$1;
(statearr_16658_16845[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (116))){
var inst_16579 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16659_16846 = state_16608__$1;
(statearr_16659_16846[(2)] = inst_16579);

(statearr_16659_16846[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (75))){
var inst_16468 = (state_16608[(9)]);
var state_16608__$1 = state_16608;
var G__16660_16847 = inst_16468;
var G__16660_16848__$1 = (((G__16660_16847 instanceof cljs.core.Keyword))?G__16660_16847.fqn:null);
switch (G__16660_16848__$1) {
case "long":
var statearr_16661_16850 = state_16608__$1;
(statearr_16661_16850[(1)] = (79));


break;
case "bigint":
var statearr_16662_16851 = state_16608__$1;
(statearr_16662_16851[(1)] = (83));


break;
case "double":
var statearr_16663_16852 = state_16608__$1;
(statearr_16663_16852[(1)] = (87));


break;
case "float":
var statearr_16664_16853 = state_16608__$1;
(statearr_16664_16853[(1)] = (91));


break;
case "bigdec":
var statearr_16665_16854 = state_16608__$1;
(statearr_16665_16854[(1)] = (95));


break;
case "string":
var statearr_16666_16855 = state_16608__$1;
(statearr_16666_16855[(1)] = (99));


break;
case "instant":
var statearr_16667_16856 = state_16608__$1;
(statearr_16667_16856[(1)] = (103));


break;
default:
var statearr_16668_16857 = state_16608__$1;
(statearr_16668_16857[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (99))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16530 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16531 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16530,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,5,inst_16530,null));
var inst_16532 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16531,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16531,null));
var inst_16533 = (inst_16532.cljs$core$IFn$_invoke$arity$1 ? inst_16532.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16532.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16533)){
var statearr_16669_16858 = state_16608__$1;
(statearr_16669_16858[(1)] = (100));

} else {
var statearr_16670_16859 = state_16608__$1;
(statearr_16670_16859[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (21))){
var inst_16360 = (state_16608[(24)]);
var state_16608__$1 = state_16608;
var statearr_16671_16860 = state_16608__$1;
(statearr_16671_16860[(2)] = inst_16360);

(statearr_16671_16860[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (31))){
var inst_16376 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16672_16861 = state_16608__$1;
(statearr_16672_16861[(2)] = inst_16376);

(statearr_16672_16861[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (113))){
var inst_16582 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16673_16862 = state_16608__$1;
(statearr_16673_16862[(2)] = inst_16582);

(statearr_16673_16862[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (32))){
var state_16608__$1 = state_16608;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16674_16863 = state_16608__$1;
(statearr_16674_16863[(1)] = (35));

} else {
var statearr_16675_16864 = state_16608__$1;
(statearr_16675_16864[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (40))){
var inst_16412 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16412)){
var statearr_16676_16865 = state_16608__$1;
(statearr_16676_16865[(1)] = (44));

} else {
var statearr_16677_16866 = state_16608__$1;
(statearr_16677_16866[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (91))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16510 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16511 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16510,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,3,inst_16510,null));
var inst_16512 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16511,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16511,null));
var inst_16513 = (inst_16512.cljs$core$IFn$_invoke$arity$1 ? inst_16512.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16512.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16513)){
var statearr_16678_16867 = state_16608__$1;
(statearr_16678_16867[(1)] = (92));

} else {
var statearr_16679_16868 = state_16608__$1;
(statearr_16679_16868[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (117))){
var state_16608__$1 = state_16608;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16680_16869 = state_16608__$1;
(statearr_16680_16869[(1)] = (120));

} else {
var statearr_16681_16870 = state_16608__$1;
(statearr_16681_16870[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (108))){
var inst_16336 = (state_16608[(10)]);
var inst_16567 = (state_16608[(25)]);
var inst_16567__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16682 = state_16608;
(statearr_16682[(25)] = inst_16567__$1);

return statearr_16682;
})();
if(cljs.core.truth_(inst_16567__$1)){
var statearr_16683_16871 = state_16608__$1;
(statearr_16683_16871[(1)] = (111));

} else {
var statearr_16684_16872 = state_16608__$1;
(statearr_16684_16872[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (56))){
var inst_16429 = (state_16608[(2)]);
var inst_16430 = fluree.db.util.async.throw_err(inst_16429);
var inst_16431 = cljs.core.not(inst_16430);
var state_16608__$1 = state_16608;
var statearr_16685_16873 = state_16608__$1;
(statearr_16685_16873[(2)] = inst_16431);

(statearr_16685_16873[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (33))){
var inst_16359 = (state_16608[(26)]);
var state_16608__$1 = state_16608;
var statearr_16686_16874 = state_16608__$1;
(statearr_16686_16874[(2)] = inst_16359);

(statearr_16686_16874[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (13))){
var inst_16354 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16354)){
var statearr_16687_16875 = state_16608__$1;
(statearr_16687_16875[(1)] = (17));

} else {
var statearr_16688_16876 = state_16608__$1;
(statearr_16688_16876[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (22))){
var inst_16385 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16385)){
var statearr_16689_16877 = state_16608__$1;
(statearr_16689_16877[(1)] = (32));

} else {
var statearr_16690_16878 = state_16608__$1;
(statearr_16690_16878[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (90))){
var inst_16508 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16691_16879 = state_16608__$1;
(statearr_16691_16879[(2)] = inst_16508);

(statearr_16691_16879[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (109))){
var inst_16565 = (state_16608[(27)]);
var state_16608__$1 = state_16608;
var statearr_16692_16880 = state_16608__$1;
(statearr_16692_16880[(2)] = inst_16565);

(statearr_16692_16880[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (36))){
var inst_16359 = (state_16608[(26)]);
var state_16608__$1 = state_16608;
var statearr_16693_16881 = state_16608__$1;
(statearr_16693_16881[(2)] = inst_16359);

(statearr_16693_16881[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (41))){
var inst_16336 = (state_16608[(10)]);
var inst_16404 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16405 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16404);
var inst_16406 = inst_16405 === true;
var state_16608__$1 = state_16608;
var statearr_16694_16882 = state_16608__$1;
(statearr_16694_16882[(2)] = inst_16406);

(statearr_16694_16882[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (118))){
var inst_16563 = (state_16608[(7)]);
var state_16608__$1 = state_16608;
var statearr_16695_16883 = state_16608__$1;
(statearr_16695_16883[(2)] = inst_16563);

(statearr_16695_16883[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (89))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16506 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16696_16884 = state_16608__$1;
(statearr_16696_16884[(2)] = inst_16506);

(statearr_16696_16884[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (100))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16697_16885 = state_16608__$1;
(statearr_16697_16885[(2)] = inst_16455);

(statearr_16697_16885[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (122))){
var inst_16595 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16698_16886 = state_16608__$1;
(statearr_16698_16886[(2)] = inst_16595);

(statearr_16698_16886[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (43))){
var inst_16409 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16699_16887 = state_16608__$1;
(statearr_16699_16887[(2)] = inst_16409);

(statearr_16699_16887[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (61))){
var inst_16417 = (state_16608[(14)]);
var state_16608__$1 = state_16608;
var statearr_16700_16888 = state_16608__$1;
(statearr_16700_16888[(2)] = inst_16417);

(statearr_16700_16888[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (29))){
var inst_16336 = (state_16608[(10)]);
var inst_16371 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16372 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16371);
var inst_16373 = inst_16372 === true;
var state_16608__$1 = state_16608;
var statearr_16701_16889 = state_16608__$1;
(statearr_16701_16889[(2)] = inst_16373);

(statearr_16701_16889[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (44))){
var inst_16398 = (state_16608[(28)]);
var inst_16414 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16398,"a component","a non-component",throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16702_16890 = state_16608__$1;
(statearr_16702_16890[(2)] = inst_16414);

(statearr_16702_16890[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (93))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16516 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16703_16891 = state_16608__$1;
(statearr_16703_16891[(2)] = inst_16516);

(statearr_16703_16891[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (6))){
var inst_16335 = (state_16608[(15)]);
var inst_16323 = (state_16608[(21)]);
var inst_16332 = cljs.core.seq(inst_16323);
var inst_16333 = cljs.core.first(inst_16332);
var inst_16334 = cljs.core.next(inst_16332);
var inst_16335__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16333,(0),null);
var inst_16336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16333,(1),null);
var inst_16337 = cljs.core.not(inst_16335__$1);
var state_16608__$1 = (function (){var statearr_16704 = state_16608;
(statearr_16704[(10)] = inst_16336);

(statearr_16704[(15)] = inst_16335__$1);

(statearr_16704[(20)] = inst_16334);

return statearr_16704;
})();
if(inst_16337){
var statearr_16705_16892 = state_16608__$1;
(statearr_16705_16892[(1)] = (8));

} else {
var statearr_16706_16893 = state_16608__$1;
(statearr_16706_16893[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (111))){
var inst_16336 = (state_16608[(10)]);
var inst_16571 = (state_16608[(29)]);
var inst_16569 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16570 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16569);
var inst_16571__$1 = inst_16570 === true;
var state_16608__$1 = (function (){var statearr_16707 = state_16608;
(statearr_16707[(29)] = inst_16571__$1);

return statearr_16707;
})();
if(cljs.core.truth_(inst_16571__$1)){
var statearr_16708_16894 = state_16608__$1;
(statearr_16708_16894[(1)] = (114));

} else {
var statearr_16709_16895 = state_16608__$1;
(statearr_16709_16895[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (28))){
var inst_16379 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16710_16896 = state_16608__$1;
(statearr_16710_16896[(2)] = inst_16379);

(statearr_16710_16896[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (64))){
var inst_16456 = (state_16608[(11)]);
var state_16608__$1 = state_16608;
var statearr_16711_16897 = state_16608__$1;
(statearr_16711_16897[(2)] = inst_16456);

(statearr_16711_16897[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (103))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16540 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16541 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16540,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,2,inst_16540,null));
var inst_16542 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16541,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16541,null));
var inst_16543 = (inst_16542.cljs$core$IFn$_invoke$arity$1 ? inst_16542.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16542.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16543)){
var statearr_16712_16898 = state_16608__$1;
(statearr_16712_16898[(1)] = (104));

} else {
var statearr_16713_16899 = state_16608__$1;
(statearr_16713_16899[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (51))){
var inst_16421 = (state_16608[(30)]);
var state_16608__$1 = state_16608;
var statearr_16714_16900 = state_16608__$1;
(statearr_16714_16900[(2)] = inst_16421);

(statearr_16714_16900[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (25))){
var inst_16382 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16715_16901 = state_16608__$1;
(statearr_16715_16901[(2)] = inst_16382);

(statearr_16715_16901[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (34))){
var inst_16399 = (state_16608[(18)]);
var inst_16336 = (state_16608[(10)]);
var inst_16398 = (state_16608[(2)]);
var inst_16399__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16716 = state_16608;
(statearr_16716[(18)] = inst_16399__$1);

(statearr_16716[(28)] = inst_16398);

return statearr_16716;
})();
if(cljs.core.truth_(inst_16399__$1)){
var statearr_16717_16902 = state_16608__$1;
(statearr_16717_16902[(1)] = (38));

} else {
var statearr_16718_16903 = state_16608__$1;
(statearr_16718_16903[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (17))){
var inst_16324 = (state_16608[(16)]);
var inst_16356 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16324,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16719_16904 = state_16608__$1;
(statearr_16719_16904[(2)] = inst_16356);

(statearr_16719_16904[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (3))){
var inst_16606 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16608__$1,inst_16606);
} else {
if((state_val_16609 === (12))){
var inst_16340 = (state_16608[(31)]);
var state_16608__$1 = state_16608;
var statearr_16720_16905 = state_16608__$1;
(statearr_16720_16905[(2)] = inst_16340);

(statearr_16720_16905[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (2))){
var _ = (function (){var statearr_16721 = state_16608;
(statearr_16721[(4)] = cljs.core.cons((5),(state_16608[(4)])));

return statearr_16721;
})();
var inst_16316 = pred_changes;
var inst_16317 = cljs.core.seq(inst_16316);
var inst_16318 = cljs.core.first(inst_16317);
var inst_16319 = cljs.core.next(inst_16317);
var inst_16320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16318,(0),null);
var inst_16321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16318,(1),null);
var inst_16322 = db;
var inst_16323 = inst_16316;
var inst_16324 = inst_16322;
var state_16608__$1 = (function (){var statearr_16722 = state_16608;
(statearr_16722[(32)] = inst_16321);

(statearr_16722[(16)] = inst_16324);

(statearr_16722[(21)] = inst_16323);

(statearr_16722[(33)] = inst_16319);

(statearr_16722[(34)] = inst_16320);

return statearr_16722;
})();
var statearr_16723_16906 = state_16608__$1;
(statearr_16723_16906[(2)] = null);

(statearr_16723_16906[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (66))){
var inst_16336 = (state_16608[(10)]);
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16465 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16466 = cljs.core.__destructure_map(inst_16465);
var inst_16467__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16466,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16468__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16466,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16469 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16468__$1,inst_16467__$1);
var state_16608__$1 = (function (){var statearr_16724 = state_16608;
(statearr_16724[(8)] = inst_16467__$1);

(statearr_16724[(9)] = inst_16468__$1);

return statearr_16724;
})();
if(inst_16469){
var statearr_16725_16907 = state_16608__$1;
(statearr_16725_16907[(1)] = (69));

} else {
var statearr_16726_16908 = state_16608__$1;
(statearr_16726_16908[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (107))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16550 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16727_16909 = state_16608__$1;
(statearr_16727_16909[(2)] = inst_16550);

(statearr_16727_16909[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (23))){
var inst_16336 = (state_16608[(10)]);
var inst_16365 = (state_16608[(17)]);
var inst_16364 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16365__$1 = inst_16364 === true;
var state_16608__$1 = (function (){var statearr_16728 = state_16608;
(statearr_16728[(17)] = inst_16365__$1);

return statearr_16728;
})();
if(cljs.core.truth_(inst_16365__$1)){
var statearr_16729_16910 = state_16608__$1;
(statearr_16729_16910[(1)] = (26));

} else {
var statearr_16730_16911 = state_16608__$1;
(statearr_16730_16911[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (47))){
var inst_16336 = (state_16608[(10)]);
var inst_16421 = (state_16608[(30)]);
var inst_16420 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16421__$1 = cljs.core.not(inst_16420);
var state_16608__$1 = (function (){var statearr_16731 = state_16608;
(statearr_16731[(30)] = inst_16421__$1);

return statearr_16731;
})();
if(inst_16421__$1){
var statearr_16732_16912 = state_16608__$1;
(statearr_16732_16912[(1)] = (50));

} else {
var statearr_16733_16913 = state_16608__$1;
(statearr_16733_16913[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (35))){
var inst_16388 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16389 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16390 = cljs.core.PersistentHashMap.fromArrays(inst_16388,inst_16389);
var inst_16391 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16390);
var inst_16392 = (function(){throw inst_16391})();
var state_16608__$1 = state_16608;
var statearr_16734_16914 = state_16608__$1;
(statearr_16734_16914[(2)] = inst_16392);

(statearr_16734_16914[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (82))){
var inst_16488 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16735_16915 = state_16608__$1;
(statearr_16735_16915[(2)] = inst_16488);

(statearr_16735_16915[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (76))){
var state_16608__$1 = state_16608;
var statearr_16736_16916 = state_16608__$1;
(statearr_16736_16916[(2)] = null);

(statearr_16736_16916[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (97))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16526 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16737_16917 = state_16608__$1;
(statearr_16737_16917[(2)] = inst_16526);

(statearr_16737_16917[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (19))){
var inst_16336 = (state_16608[(10)]);
var inst_16360 = (state_16608[(24)]);
var inst_16359 = (state_16608[(2)]);
var inst_16360__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16738 = state_16608;
(statearr_16738[(26)] = inst_16359);

(statearr_16738[(24)] = inst_16360__$1);

return statearr_16738;
})();
if(cljs.core.truth_(inst_16360__$1)){
var statearr_16739_16918 = state_16608__$1;
(statearr_16739_16918[(1)] = (20));

} else {
var statearr_16740_16919 = state_16608__$1;
(statearr_16740_16919[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (57))){
var state_16608__$1 = state_16608;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16741_16920 = state_16608__$1;
(statearr_16741_16920[(1)] = (60));

} else {
var statearr_16742_16921 = state_16608__$1;
(statearr_16742_16921[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (68))){
var inst_16336 = (state_16608[(10)]);
var inst_16565 = (state_16608[(27)]);
var inst_16563 = (state_16608[(2)]);
var inst_16564 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16565__$1 = inst_16564 === true;
var state_16608__$1 = (function (){var statearr_16743 = state_16608;
(statearr_16743[(27)] = inst_16565__$1);

(statearr_16743[(7)] = inst_16563);

return statearr_16743;
})();
if(cljs.core.truth_(inst_16565__$1)){
var statearr_16744_16922 = state_16608__$1;
(statearr_16744_16922[(1)] = (108));

} else {
var statearr_16745_16923 = state_16608__$1;
(statearr_16745_16923[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (11))){
var inst_16336 = (state_16608[(10)]);
var inst_16344 = (state_16608[(23)]);
var inst_16342 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16343 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16342);
var inst_16344__$1 = inst_16343 === false;
var state_16608__$1 = (function (){var statearr_16746 = state_16608;
(statearr_16746[(23)] = inst_16344__$1);

return statearr_16746;
})();
if(cljs.core.truth_(inst_16344__$1)){
var statearr_16747_16924 = state_16608__$1;
(statearr_16747_16924[(1)] = (14));

} else {
var statearr_16748_16925 = state_16608__$1;
(statearr_16748_16925[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (115))){
var inst_16571 = (state_16608[(29)]);
var state_16608__$1 = state_16608;
var statearr_16750_16926 = state_16608__$1;
(statearr_16750_16926[(2)] = inst_16571);

(statearr_16750_16926[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (9))){
var inst_16336 = (state_16608[(10)]);
var inst_16340 = (state_16608[(31)]);
var inst_16340__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16336);
var state_16608__$1 = (function (){var statearr_16751 = state_16608;
(statearr_16751[(31)] = inst_16340__$1);

return statearr_16751;
})();
if(cljs.core.truth_(inst_16340__$1)){
var statearr_16752_16927 = state_16608__$1;
(statearr_16752_16927[(1)] = (11));

} else {
var statearr_16753_16928 = state_16608__$1;
(statearr_16753_16928[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (5))){
var _ = (function (){var statearr_16754 = state_16608;
(statearr_16754[(4)] = cljs.core.rest((state_16608[(4)])));

return statearr_16754;
})();
var state_16608__$1 = state_16608;
var ex16749 = (state_16608__$1[(2)]);
var statearr_16755_16929 = state_16608__$1;
(statearr_16755_16929[(5)] = ex16749);


if((ex16749 instanceof Error)){
var statearr_16756_16930 = state_16608__$1;
(statearr_16756_16930[(1)] = (4));

(statearr_16756_16930[(5)] = null);

} else {
throw ex16749;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (112))){
var inst_16567 = (state_16608[(25)]);
var state_16608__$1 = state_16608;
var statearr_16757_16931 = state_16608__$1;
(statearr_16757_16931[(2)] = inst_16567);

(statearr_16757_16931[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (83))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16490 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16491 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16490,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,3,inst_16490,null));
var inst_16492 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16491,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16491,null));
var inst_16493 = (inst_16492.cljs$core$IFn$_invoke$arity$1 ? inst_16492.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16492.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16493)){
var statearr_16758_16932 = state_16608__$1;
(statearr_16758_16932[(1)] = (84));

} else {
var statearr_16759_16933 = state_16608__$1;
(statearr_16759_16933[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (14))){
var inst_16336 = (state_16608[(10)]);
var inst_16346 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16347 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16346);
var inst_16348 = inst_16347 === true;
var state_16608__$1 = state_16608;
var statearr_16760_16934 = state_16608__$1;
(statearr_16760_16934[(2)] = inst_16348);

(statearr_16760_16934[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (45))){
var inst_16398 = (state_16608[(28)]);
var state_16608__$1 = state_16608;
var statearr_16761_16935 = state_16608__$1;
(statearr_16761_16935[(2)] = inst_16398);

(statearr_16761_16935[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (53))){
var inst_16335 = (state_16608[(15)]);
var inst_16324 = (state_16608[(16)]);
var inst_16427 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16324,inst_16335);
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16608__$1,(56),inst_16427);
} else {
if((state_val_16609 === (78))){
var inst_16553 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16762_16936 = state_16608__$1;
(statearr_16762_16936[(2)] = inst_16553);

(statearr_16762_16936[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (26))){
var inst_16336 = (state_16608[(10)]);
var inst_16369 = (state_16608[(35)]);
var inst_16367 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16368 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16367);
var inst_16369__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16368);
var state_16608__$1 = (function (){var statearr_16763 = state_16608;
(statearr_16763[(35)] = inst_16369__$1);

return statearr_16763;
})();
if(inst_16369__$1){
var statearr_16764_16937 = state_16608__$1;
(statearr_16764_16937[(1)] = (29));

} else {
var statearr_16765_16938 = state_16608__$1;
(statearr_16765_16938[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (16))){
var inst_16351 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16766_16939 = state_16608__$1;
(statearr_16766_16939[(2)] = inst_16351);

(statearr_16766_16939[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (81))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16486 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16767_16940 = state_16608__$1;
(statearr_16767_16940[(2)] = inst_16486);

(statearr_16767_16940[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (120))){
var inst_16588 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16589 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16590 = cljs.core.PersistentHashMap.fromArrays(inst_16588,inst_16589);
var inst_16591 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16590);
var inst_16592 = (function(){throw inst_16591})();
var state_16608__$1 = state_16608;
var statearr_16768_16941 = state_16608__$1;
(statearr_16768_16941[(2)] = inst_16592);

(statearr_16768_16941[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (79))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16480 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16481 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16480,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,2,inst_16480,null));
var inst_16482 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16481,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16481,null));
var inst_16483 = (inst_16482.cljs$core$IFn$_invoke$arity$1 ? inst_16482.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16482.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16483)){
var statearr_16769_16942 = state_16608__$1;
(statearr_16769_16942[(1)] = (80));

} else {
var statearr_16770_16943 = state_16608__$1;
(statearr_16770_16943[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (38))){
var inst_16402 = (state_16608[(36)]);
var inst_16336 = (state_16608[(10)]);
var inst_16401 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16402__$1 = cljs.core.not(inst_16401);
var state_16608__$1 = (function (){var statearr_16771 = state_16608;
(statearr_16771[(36)] = inst_16402__$1);

return statearr_16771;
})();
if(inst_16402__$1){
var statearr_16772_16944 = state_16608__$1;
(statearr_16772_16944[(1)] = (41));

} else {
var statearr_16773_16945 = state_16608__$1;
(statearr_16773_16945[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (98))){
var inst_16528 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16774_16946 = state_16608__$1;
(statearr_16774_16946[(2)] = inst_16528);

(statearr_16774_16946[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (87))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16500 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16501 = (inst_16468.cljs$core$IFn$_invoke$arity$5 ? inst_16468.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16500,null) : inst_16468.call(null,cljs.core.PersistentArrayMap,null,3,inst_16500,null));
var inst_16502 = (inst_16468.cljs$core$IFn$_invoke$arity$4 ? inst_16468.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16501,null) : inst_16468.call(null,cljs.core.PersistentHashSet,null,inst_16501,null));
var inst_16503 = (inst_16502.cljs$core$IFn$_invoke$arity$1 ? inst_16502.cljs$core$IFn$_invoke$arity$1(inst_16467) : inst_16502.call(null,inst_16467));
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16503)){
var statearr_16775_16947 = state_16608__$1;
(statearr_16775_16947[(1)] = (88));

} else {
var statearr_16776_16948 = state_16608__$1;
(statearr_16776_16948[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (30))){
var inst_16369 = (state_16608[(35)]);
var state_16608__$1 = state_16608;
var statearr_16777_16949 = state_16608__$1;
(statearr_16777_16949[(2)] = inst_16369);

(statearr_16777_16949[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (73))){
var state_16608__$1 = state_16608;
var statearr_16778_16950 = state_16608__$1;
(statearr_16778_16950[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (96))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16780_16951 = state_16608__$1;
(statearr_16780_16951[(2)] = inst_16455);

(statearr_16780_16951[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (10))){
var inst_16601 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16781_16952 = state_16608__$1;
(statearr_16781_16952[(2)] = inst_16601);

(statearr_16781_16952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (18))){
var inst_16324 = (state_16608[(16)]);
var state_16608__$1 = state_16608;
var statearr_16782_16953 = state_16608__$1;
(statearr_16782_16953[(2)] = inst_16324);

(statearr_16782_16953[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (105))){
var inst_16467 = (state_16608[(8)]);
var inst_16468 = (state_16608[(9)]);
var inst_16546 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16467,inst_16468,throw_QMARK_);
var state_16608__$1 = state_16608;
var statearr_16783_16954 = state_16608__$1;
(statearr_16783_16954[(2)] = inst_16546);

(statearr_16783_16954[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (52))){
var inst_16437 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16784_16955 = state_16608__$1;
(statearr_16784_16955[(2)] = inst_16437);

(statearr_16784_16955[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (114))){
var inst_16336 = (state_16608[(10)]);
var inst_16573 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16574 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16573);
var inst_16575 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16574);
var inst_16576 = (!(inst_16575));
var state_16608__$1 = state_16608;
var statearr_16785_16956 = state_16608__$1;
(statearr_16785_16956[(2)] = inst_16576);

(statearr_16785_16956[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (67))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16786_16957 = state_16608__$1;
(statearr_16786_16957[(2)] = inst_16455);

(statearr_16786_16957[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (71))){
var inst_16560 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16787_16958 = state_16608__$1;
(statearr_16787_16958[(2)] = inst_16560);

(statearr_16787_16958[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (42))){
var inst_16402 = (state_16608[(36)]);
var state_16608__$1 = state_16608;
var statearr_16788_16959 = state_16608__$1;
(statearr_16788_16959[(2)] = inst_16402);

(statearr_16788_16959[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (80))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16789_16960 = state_16608__$1;
(statearr_16789_16960[(2)] = inst_16455);

(statearr_16789_16960[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (37))){
var inst_16395 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16790_16961 = state_16608__$1;
(statearr_16790_16961[(2)] = inst_16395);

(statearr_16790_16961[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (63))){
var inst_16336 = (state_16608[(10)]);
var inst_16458 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16336);
var inst_16459 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16458);
var state_16608__$1 = state_16608;
var statearr_16791_16962 = state_16608__$1;
(statearr_16791_16962[(2)] = inst_16459);

(statearr_16791_16962[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (94))){
var inst_16518 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16792_16963 = state_16608__$1;
(statearr_16792_16963[(2)] = inst_16518);

(statearr_16792_16963[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (8))){
var inst_16324 = (state_16608[(16)]);
var state_16608__$1 = state_16608;
var statearr_16793_16964 = state_16608__$1;
(statearr_16793_16964[(2)] = inst_16324);

(statearr_16793_16964[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (49))){
var inst_16440 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16440)){
var statearr_16794_16965 = state_16608__$1;
(statearr_16794_16965[(1)] = (57));

} else {
var statearr_16795_16966 = state_16608__$1;
(statearr_16795_16966[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (84))){
var inst_16455 = (state_16608[(12)]);
var state_16608__$1 = state_16608;
var statearr_16796_16967 = state_16608__$1;
(statearr_16796_16967[(2)] = inst_16455);

(statearr_16796_16967[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16797[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16797[(1)] = (1));

return statearr_16797;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16608){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16608);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16798){var ex__2730__auto__ = e16798;
var statearr_16799_16968 = state_16608;
(statearr_16799_16968[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16608[(4)]))){
var statearr_16800_16969 = state_16608;
(statearr_16800_16969[(1)] = cljs.core.first((state_16608[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16970 = state_16608;
state_16608 = G__16970;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16608){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16801 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16801[(6)] = c__2749__auto__);

return statearr_16801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16972 = arguments.length;
switch (G__16972) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16996){
var state_val_16997 = (state_16996[(1)]);
if((state_val_16997 === (7))){
var state_16996__$1 = state_16996;
var statearr_16998_17018 = state_16996__$1;
(statearr_16998_17018[(2)] = db);

(statearr_16998_17018[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (1))){
var state_16996__$1 = state_16996;
var statearr_16999_17019 = state_16996__$1;
(statearr_16999_17019[(2)] = null);

(statearr_16999_17019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (4))){
var inst_16973 = (state_16996[(2)]);
var state_16996__$1 = state_16996;
var statearr_17000_17020 = state_16996__$1;
(statearr_17000_17020[(2)] = inst_16973);

(statearr_17000_17020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (6))){
var inst_16982 = (state_16996[(7)]);
var inst_16981 = (state_16996[(2)]);
var inst_16982__$1 = fluree.db.util.async.throw_err(inst_16981);
var inst_16983 = cljs.core.empty_QMARK_(inst_16982__$1);
var state_16996__$1 = (function (){var statearr_17001 = state_16996;
(statearr_17001[(7)] = inst_16982__$1);

return statearr_17001;
})();
if(inst_16983){
var statearr_17002_17021 = state_16996__$1;
(statearr_17002_17021[(1)] = (7));

} else {
var statearr_17003_17022 = state_16996__$1;
(statearr_17003_17022[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (3))){
var inst_16994 = (state_16996[(2)]);
var state_16996__$1 = state_16996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16996__$1,inst_16994);
} else {
if((state_val_16997 === (2))){
var _ = (function (){var statearr_17005 = state_16996;
(statearr_17005[(4)] = cljs.core.cons((5),(state_16996[(4)])));

return statearr_17005;
})();
var inst_16979 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16996__$1 = state_16996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16996__$1,(6),inst_16979);
} else {
if((state_val_16997 === (9))){
var inst_16991 = (state_16996[(2)]);
var _ = (function (){var statearr_17006 = state_16996;
(statearr_17006[(4)] = cljs.core.rest((state_16996[(4)])));

return statearr_17006;
})();
var state_16996__$1 = state_16996;
var statearr_17007_17023 = state_16996__$1;
(statearr_17007_17023[(2)] = inst_16991);

(statearr_17007_17023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (5))){
var _ = (function (){var statearr_17008 = state_16996;
(statearr_17008[(4)] = cljs.core.rest((state_16996[(4)])));

return statearr_17008;
})();
var state_16996__$1 = state_16996;
var ex17004 = (state_16996__$1[(2)]);
var statearr_17009_17024 = state_16996__$1;
(statearr_17009_17024[(5)] = ex17004);


if((ex17004 instanceof Error)){
var statearr_17010_17025 = state_16996__$1;
(statearr_17010_17025[(1)] = (4));

(statearr_17010_17025[(5)] = null);

} else {
throw ex17004;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (10))){
var inst_16988 = (state_16996[(2)]);
var inst_16989 = fluree.db.util.async.throw_err(inst_16988);
var state_16996__$1 = state_16996;
var statearr_17011_17026 = state_16996__$1;
(statearr_17011_17026[(2)] = inst_16989);

(statearr_17011_17026[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16997 === (8))){
var inst_16982 = (state_16996[(7)]);
var inst_16986 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16982,db,true);
var state_16996__$1 = state_16996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16996__$1,(10),inst_16986);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_17012 = [null,null,null,null,null,null,null,null];
(statearr_17012[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_17012[(1)] = (1));

return statearr_17012;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16996){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16996);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17013){var ex__2730__auto__ = e17013;
var statearr_17014_17027 = state_16996;
(statearr_17014_17027[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16996[(4)]))){
var statearr_17015_17028 = state_16996;
(statearr_17015_17028[(1)] = cljs.core.first((state_16996[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17029 = state_16996;
state_16996 = G__17029;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16996){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17016 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17016[(6)] = c__2749__auto__);

return statearr_17016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__17031 = arguments.length;
switch (G__17031) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__17033 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17033,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17033,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17033,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = fluree.db.flake.p(flake);
var o = fluree.db.flake.o(flake);
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__17036_SHARP_,p2__17037_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17036_SHARP_,p2__17037_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__17038_SHARP_){
var f = p1__17038_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,fluree.db.flake.p(f))){
return fluree.db.flake.o(f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17104){
var state_val_17105 = (state_17104[(1)]);
if((state_val_17105 === (1))){
var state_17104__$1 = state_17104;
var statearr_17106_17124 = state_17104__$1;
(statearr_17106_17124[(2)] = null);

(statearr_17106_17124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (2))){
var _ = (function (){var statearr_17107 = state_17104;
(statearr_17107[(4)] = cljs.core.cons((5),(state_17104[(4)])));

return statearr_17107;
})();
var inst_17056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17057 = fluree.db.flake.max_subject_id((1));
var inst_17058 = [inst_17057];
var inst_17059 = (new cljs.core.PersistentVector(null,1,(5),inst_17056,inst_17058,null));
var inst_17060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17061 = [(0)];
var inst_17062 = (new cljs.core.PersistentVector(null,1,(5),inst_17060,inst_17061,null));
var inst_17063 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17059,cljs.core._LT__EQ_,inst_17062);
var state_17104__$1 = state_17104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17104__$1,(6),inst_17063);
} else {
if((state_val_17105 === (3))){
var inst_17102 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17104__$1,inst_17102);
} else {
if((state_val_17105 === (4))){
var inst_17044 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
var statearr_17109_17125 = state_17104__$1;
(statearr_17109_17125[(2)] = inst_17044);

(statearr_17109_17125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (5))){
var _ = (function (){var statearr_17110 = state_17104;
(statearr_17110[(4)] = cljs.core.rest((state_17104[(4)])));

return statearr_17110;
})();
var state_17104__$1 = state_17104;
var ex17108 = (state_17104__$1[(2)]);
var statearr_17111_17126 = state_17104__$1;
(statearr_17111_17126[(5)] = ex17108);


if((ex17108 instanceof Error)){
var statearr_17112_17127 = state_17104__$1;
(statearr_17112_17127[(1)] = (4));

(statearr_17112_17127[(5)] = null);

} else {
throw ex17108;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (6))){
var inst_17065 = (state_17104[(2)]);
var inst_17066 = fluree.db.util.async.throw_err(inst_17065);
var inst_17067 = (function (){var schema_flakes = inst_17066;
return (function (p1__17039_SHARP_){
return (fluree.db.flake.s(p1__17039_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17068 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17067,inst_17066);
var inst_17069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17068,(0),null);
var inst_17070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17068,(1),null);
var inst_17071 = (function (){var schema_flakes = inst_17066;
var vec__17050 = inst_17068;
var collection_flakes = inst_17069;
var predicate_flakes = inst_17070;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = fluree.db.flake.s(first_flake);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17042_SHARP_,p2__17041_SHARP_){
var f = p2__17041_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17042_SHARP_,fluree.db.flake.p(f),fluree.db.flake.o(f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_17072 = [(-1),"_tx"];
var inst_17073 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17074 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17075 = cljs.core.PersistentHashMap.fromArrays(inst_17073,inst_17074);
var inst_17076 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17077 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17078 = cljs.core.PersistentHashMap.fromArrays(inst_17076,inst_17077);
var inst_17079 = [inst_17075,inst_17078];
var inst_17080 = cljs.core.PersistentHashMap.fromArrays(inst_17072,inst_17079);
var inst_17081 = (function (){var schema_flakes = inst_17066;
var vec__17050 = inst_17068;
var collection_flakes = inst_17069;
var predicate_flakes = inst_17070;
return (function (p1__17040_SHARP_){
return fluree.db.flake.s(p1__17040_SHARP_);
});
})();
var inst_17082 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17081,inst_17069);
var inst_17083 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17071,inst_17080,inst_17082);
var inst_17085 = (function (){var schema_flakes = inst_17066;
var vec__17050 = inst_17068;
var collection_flakes = inst_17069;
var predicate_flakes = inst_17070;
var coll = inst_17083;
return (function (p__17084,pred_flakes){
var vec__17113 = p__17084;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17113,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17113,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = fluree.db.flake.s(first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__17116 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__17116.cljs$core$IFn$_invoke$arity$1 ? fexpr__17116.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__17116.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_17086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17087 = cljs.core.PersistentHashMap.EMPTY;
var inst_17088 = cljs.core.PersistentHashSet.EMPTY;
var inst_17089 = [inst_17087,inst_17088];
var inst_17090 = (new cljs.core.PersistentVector(null,2,(5),inst_17086,inst_17089,null));
var inst_17091 = (function (){var schema_flakes = inst_17066;
var vec__17050 = inst_17068;
var collection_flakes = inst_17069;
var predicate_flakes = inst_17070;
var coll = inst_17083;
return (function (p1__17043_SHARP_){
return fluree.db.flake.s(p1__17043_SHARP_);
});
})();
var inst_17092 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17091,inst_17070);
var inst_17093 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17085,inst_17090,inst_17092);
var inst_17094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17093,(0),null);
var inst_17095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17093,(1),null);
var inst_17096 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17097 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17098 = [inst_17097,inst_17083,inst_17094,inst_17095];
var inst_17099 = cljs.core.PersistentHashMap.fromArrays(inst_17096,inst_17098);
var _ = (function (){var statearr_17117 = state_17104;
(statearr_17117[(4)] = cljs.core.rest((state_17104[(4)])));

return statearr_17117;
})();
var state_17104__$1 = state_17104;
var statearr_17118_17128 = state_17104__$1;
(statearr_17118_17128[(2)] = inst_17099);

(statearr_17118_17128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0 = (function (){
var statearr_17119 = [null,null,null,null,null,null,null];
(statearr_17119[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2727__auto__);

(statearr_17119[(1)] = (1));

return statearr_17119;
});
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1 = (function (state_17104){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17104);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17120){var ex__2730__auto__ = e17120;
var statearr_17121_17129 = state_17104;
(statearr_17121_17129[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17104[(4)]))){
var statearr_17122_17130 = state_17104;
(statearr_17122_17130[(1)] = cljs.core.first((state_17104[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17131 = state_17104;
state_17104 = G__17131;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = function(state_17104){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1.call(this,state_17104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17123 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17123[(6)] = c__2749__auto__);

return statearr_17123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17173){
var state_val_17174 = (state_17173[(1)]);
if((state_val_17174 === (7))){
var inst_17156 = (state_17173[(2)]);
var inst_17157 = fluree.db.query.schema.flake__GT_pred_map(inst_17156);
var inst_17158 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17159 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17157,(114));
var inst_17160 = cljs.core.boolean$(inst_17159);
var inst_17161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17157,(110));
var inst_17162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17157,(117));
var inst_17163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_17162);
var inst_17164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17157,(111));
var inst_17165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17157,(115));
var inst_17166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17157,(112));
var inst_17167 = [inst_17160,inst_17161,inst_17163,inst_17164,inst_17165,inst_17166];
var inst_17168 = cljs.core.PersistentHashMap.fromArrays(inst_17158,inst_17167);
var _ = (function (){var statearr_17175 = state_17173;
(statearr_17175[(4)] = cljs.core.rest((state_17173[(4)])));

return statearr_17175;
})();
var state_17173__$1 = state_17173;
var statearr_17176_17199 = state_17173__$1;
(statearr_17176_17199[(2)] = inst_17168);

(statearr_17176_17199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (1))){
var state_17173__$1 = state_17173;
var statearr_17177_17200 = state_17173__$1;
(statearr_17177_17200[(2)] = null);

(statearr_17177_17200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (4))){
var inst_17132 = (state_17173[(2)]);
var state_17173__$1 = state_17173;
var statearr_17178_17201 = state_17173__$1;
(statearr_17178_17201[(2)] = inst_17132);

(statearr_17178_17201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (6))){
var _ = (function (){var statearr_17179 = state_17173;
(statearr_17179[(4)] = cljs.core.cons((9),(state_17173[(4)])));

return statearr_17179;
})();
var inst_17144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17146 = ["_setting/id","root"];
var inst_17147 = (new cljs.core.PersistentVector(null,2,(5),inst_17145,inst_17146,null));
var inst_17148 = [inst_17147];
var inst_17149 = (new cljs.core.PersistentVector(null,1,(5),inst_17144,inst_17148,null));
var inst_17150 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17149);
var state_17173__$1 = state_17173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17173__$1,(10),inst_17150);
} else {
if((state_val_17174 === (3))){
var inst_17171 = (state_17173[(2)]);
var state_17173__$1 = state_17173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17173__$1,inst_17171);
} else {
if((state_val_17174 === (2))){
var _ = (function (){var statearr_17182 = state_17173;
(statearr_17182[(4)] = cljs.core.cons((5),(state_17173[(4)])));

return statearr_17182;
})();
var state_17173__$1 = state_17173;
var statearr_17183_17202 = state_17173__$1;
(statearr_17183_17202[(2)] = null);

(statearr_17183_17202[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (9))){
var _ = (function (){var statearr_17184 = state_17173;
(statearr_17184[(4)] = cljs.core.rest((state_17173[(4)])));

return statearr_17184;
})();
var state_17173__$1 = state_17173;
var ex17180 = (state_17173__$1[(2)]);
var statearr_17185_17203 = state_17173__$1;
(statearr_17185_17203[(5)] = ex17180);


var statearr_17186_17204 = state_17173__$1;
(statearr_17186_17204[(1)] = (8));

(statearr_17186_17204[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (5))){
var _ = (function (){var statearr_17187 = state_17173;
(statearr_17187[(4)] = cljs.core.rest((state_17173[(4)])));

return statearr_17187;
})();
var state_17173__$1 = state_17173;
var ex17181 = (state_17173__$1[(2)]);
var statearr_17188_17205 = state_17173__$1;
(statearr_17188_17205[(5)] = ex17181);


if((ex17181 instanceof Error)){
var statearr_17189_17206 = state_17173__$1;
(statearr_17189_17206[(1)] = (4));

(statearr_17189_17206[(5)] = null);

} else {
throw ex17181;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (10))){
var inst_17152 = (state_17173[(2)]);
var inst_17153 = fluree.db.util.async.throw_err(inst_17152);
var _ = (function (){var statearr_17190 = state_17173;
(statearr_17190[(4)] = cljs.core.rest((state_17173[(4)])));

return statearr_17190;
})();
var state_17173__$1 = state_17173;
var statearr_17191_17207 = state_17173__$1;
(statearr_17191_17207[(2)] = inst_17153);

(statearr_17191_17207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17174 === (8))){
var inst_17138 = (state_17173[(2)]);
var state_17173__$1 = (function (){var statearr_17192 = state_17173;
(statearr_17192[(7)] = inst_17138);

return statearr_17192;
})();
var statearr_17193_17208 = state_17173__$1;
(statearr_17193_17208[(2)] = null);

(statearr_17193_17208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0 = (function (){
var statearr_17194 = [null,null,null,null,null,null,null,null];
(statearr_17194[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2727__auto__);

(statearr_17194[(1)] = (1));

return statearr_17194;
});
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1 = (function (state_17173){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17173);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17195){var ex__2730__auto__ = e17195;
var statearr_17196_17209 = state_17173;
(statearr_17196_17209[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17173[(4)]))){
var statearr_17197_17210 = state_17173;
(statearr_17197_17210[(1)] = cljs.core.first((state_17173[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17211 = state_17173;
state_17173 = G__17211;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = function(state_17173){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1.call(this,state_17173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17198 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17198[(6)] = c__2749__auto__);

return statearr_17198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
