// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24609 = arguments.length;
switch (G__24609) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__24610 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24610) : f.call(null,G__24610));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__24611 = cljs.core._deref(vol);
var G__24612 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24611,G__24612) : f.call(null,G__24611,G__24612));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__24613 = cljs.core._deref(vol);
var G__24614 = arg1;
var G__24615 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24613,G__24614,G__24615) : f.call(null,G__24613,G__24614,G__24615));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__24616 = cljs.core._deref(vol);
var G__24617 = arg1;
var G__24618 = arg2;
var G__24619 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__24616,G__24617,G__24618,G__24619) : f.call(null,G__24616,G__24617,G__24618,G__24619));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24622 = arguments.length;
switch (G__24622) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24624 = null;
var G__24624__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__24624__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__24624__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__24624 = function(result,flake){
switch(arguments.length){
case 0:
return G__24624__0.call(this);
case 1:
return G__24624__1.call(this,result);
case 2:
return G__24624__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24624.cljs$core$IFn$_invoke$arity$0 = G__24624__0;
G__24624.cljs$core$IFn$_invoke$arity$1 = G__24624__1;
G__24624.cljs$core$IFn$_invoke$arity$2 = G__24624__2;
return G__24624;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24625_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24625_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24629 = vars;
var vec__24630 = G__24629;
var seq__24631 = cljs.core.seq(vec__24630);
var first__24632 = cljs.core.first(seq__24631);
var seq__24631__$1 = cljs.core.next(seq__24631);
var var$ = first__24632;
var r = seq__24631__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24629__$1 = G__24629;
var all_vars__$1 = all_vars;
while(true){
var vec__24637 = G__24629__$1;
var seq__24638 = cljs.core.seq(vec__24637);
var first__24639 = cljs.core.first(seq__24638);
var seq__24638__$1 = cljs.core.next(seq__24638);
var var$__$1 = first__24639;
var r__$1 = seq__24638__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24640 = cljs.core.set(all_vars__$2);
return (fexpr__24640.cljs$core$IFn$_invoke$arity$1 ? fexpr__24640.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24640.call(null,var$__$1));
})())){
var G__24641 = r__$1;
var G__24642 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24629__$1 = G__24641;
all_vars__$1 = G__24642;
continue;
} else {
var G__24643 = r__$1;
var G__24644 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24629__$1 = G__24643;
all_vars__$1 = G__24644;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24645){
var vec__24646 = p__24645;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24646,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24646,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24660){
var state_val_24661 = (state_24660[(1)]);
if((state_val_24661 === (1))){
var inst_24649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24650 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24651 = [query_map,_id,query_opts];
var inst_24652 = cljs.core.PersistentHashMap.fromArrays(inst_24650,inst_24651);
var inst_24653 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24652) : fluree.db.query.fql.query.call(null,db,inst_24652));
var state_24660__$1 = (function (){var statearr_24662 = state_24660;
(statearr_24662[(7)] = inst_24649);

return statearr_24662;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24660__$1,(2),inst_24653);
} else {
if((state_val_24661 === (2))){
var inst_24649 = (state_24660[(7)]);
var inst_24655 = (state_24660[(2)]);
var inst_24656 = fluree.db.util.async.throw_err(inst_24655);
var inst_24657 = [tuple_index,inst_24656];
var inst_24658 = (new cljs.core.PersistentVector(null,2,(5),inst_24649,inst_24657,null));
var state_24660__$1 = state_24660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24660__$1,inst_24658);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_24663 = [null,null,null,null,null,null,null,null];
(statearr_24663[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_24663[(1)] = (1));

return statearr_24663;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_24660){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24660);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24664){var ex__2730__auto__ = e24664;
var statearr_24665_24668 = state_24660;
(statearr_24665_24668[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24660[(4)]))){
var statearr_24666_24669 = state_24660;
(statearr_24666_24669[(1)] = cljs.core.first((state_24660[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24670 = state_24660;
state_24660 = G__24670;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_24660){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_24660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24667 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24667[(6)] = c__2749__auto__);

return statearr_24667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24671 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24671,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24671,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24734){
var state_val_24735 = (state_24734[(1)]);
if((state_val_24735 === (7))){
var inst_24729 = (state_24734[(2)]);
var _ = (function (){var statearr_24736 = state_24734;
(statearr_24736[(4)] = cljs.core.rest((state_24734[(4)])));

return statearr_24736;
})();
var state_24734__$1 = state_24734;
var statearr_24737_24828 = state_24734__$1;
(statearr_24737_24828[(2)] = inst_24729);

(statearr_24737_24828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (20))){
var inst_24720 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24738_24829 = state_24734__$1;
(statearr_24738_24829[(2)] = inst_24720);

(statearr_24738_24829[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (1))){
var state_24734__$1 = state_24734;
var statearr_24739_24830 = state_24734__$1;
(statearr_24739_24830[(2)] = null);

(statearr_24739_24830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (4))){
var inst_24676 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24740_24831 = state_24734__$1;
(statearr_24740_24831[(2)] = inst_24676);

(statearr_24740_24831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (15))){
var inst_24696 = (state_24734[(7)]);
var inst_24705 = cljs.core.second(inst_24696);
var inst_24706 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24705);
var inst_24707 = (inst_24706 > max_fuel);
var state_24734__$1 = state_24734;
if(cljs.core.truth_(inst_24707)){
var statearr_24741_24832 = state_24734__$1;
(statearr_24741_24832[(1)] = (18));

} else {
var statearr_24742_24833 = state_24734__$1;
(statearr_24742_24833[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (13))){
var state_24734__$1 = state_24734;
var statearr_24743_24834 = state_24734__$1;
(statearr_24743_24834[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (6))){
var inst_24684 = (state_24734[(8)]);
var state_24734__$1 = state_24734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24734__$1,(8),inst_24684);
} else {
if((state_val_24735 === (17))){
var inst_24723 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24745_24835 = state_24734__$1;
(statearr_24745_24835[(2)] = inst_24723);

(statearr_24745_24835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (3))){
var inst_24732 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24734__$1,inst_24732);
} else {
if((state_val_24735 === (12))){
var inst_24696 = (state_24734[(7)]);
var inst_24685 = (state_24734[(9)]);
var inst_24702 = (inst_24685.cljs$core$IFn$_invoke$arity$0 ? inst_24685.cljs$core$IFn$_invoke$arity$0() : inst_24685.call(null));
var state_24734__$1 = (function (){var statearr_24746 = state_24734;
(statearr_24746[(10)] = inst_24702);

return statearr_24746;
})();
var statearr_24747_24836 = state_24734__$1;
(statearr_24747_24836[(2)] = inst_24696);

(statearr_24747_24836[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (2))){
var inst_24684 = (state_24734[(8)]);
var inst_24685 = (state_24734[(9)]);
var _ = (function (){var statearr_24748 = state_24734;
(statearr_24748[(4)] = cljs.core.cons((5),(state_24734[(4)])));

return statearr_24748;
})();
var inst_24682 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24683 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24684__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24685__$1 = (function (){var expandMaps = inst_24682;
var queue_ch = inst_24683;
var res_ch = inst_24684__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24686 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24687 = cljs.core.volatile_BANG_((0));
var inst_24688 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24686,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24687);
var inst_24689 = (function (){var expandMaps = inst_24682;
var queue_ch = inst_24683;
var res_ch = inst_24684__$1;
var stop_BANG_ = inst_24685__$1;
var opts_STAR_ = inst_24688;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24781){
var state_val_24782 = (state_24781[(1)]);
if((state_val_24782 === (7))){
var state_24781__$1 = state_24781;
var statearr_24783_24837 = state_24781__$1;
(statearr_24783_24837[(2)] = tuple_res);

(statearr_24783_24837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (1))){
var state_24781__$1 = state_24781;
var statearr_24784_24838 = state_24781__$1;
(statearr_24784_24838[(2)] = null);

(statearr_24784_24838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (4))){
var inst_24749 = (state_24781[(2)]);
var inst_24750 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24749);
var inst_24751 = cljs.core.async.close_BANG_(port);
var state_24781__$1 = (function (){var statearr_24785 = state_24781;
(statearr_24785[(7)] = inst_24750);

return statearr_24785;
})();
var statearr_24786_24839 = state_24781__$1;
(statearr_24786_24839[(2)] = inst_24751);

(statearr_24786_24839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (6))){
var inst_24758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24759 = [tuple_res];
var inst_24760 = (new cljs.core.PersistentVector(null,1,(5),inst_24758,inst_24759,null));
var state_24781__$1 = state_24781;
var statearr_24787_24840 = state_24781__$1;
(statearr_24787_24840[(2)] = inst_24760);

(statearr_24787_24840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (3))){
var inst_24779 = (state_24781[(2)]);
var state_24781__$1 = state_24781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24781__$1,inst_24779);
} else {
if((state_val_24782 === (2))){
var ___$1 = (function (){var statearr_24789 = state_24781;
(statearr_24789[(4)] = cljs.core.cons((5),(state_24781[(4)])));

return statearr_24789;
})();
var state_24781__$1 = state_24781;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24790_24841 = state_24781__$1;
(statearr_24790_24841[(1)] = (6));

} else {
var statearr_24791_24842 = state_24781__$1;
(statearr_24791_24842[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (9))){
var inst_24763 = (state_24781[(8)]);
var inst_24765 = (state_24781[(9)]);
var inst_24772 = (state_24781[(2)]);
var inst_24773 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24763,inst_24772);
var inst_24774 = (inst_24765.cljs$core$IFn$_invoke$arity$1 ? inst_24765.cljs$core$IFn$_invoke$arity$1(inst_24773) : inst_24765.call(null,inst_24773));
var inst_24775 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24774);
var inst_24776 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24792 = state_24781;
(statearr_24792[(4)] = cljs.core.rest((state_24781[(4)])));

return statearr_24792;
})();
var state_24781__$1 = (function (){var statearr_24793 = state_24781;
(statearr_24793[(10)] = inst_24775);

return statearr_24793;
})();
var statearr_24794_24843 = state_24781__$1;
(statearr_24794_24843[(2)] = inst_24776);

(statearr_24794_24843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (5))){
var ___$1 = (function (){var statearr_24795 = state_24781;
(statearr_24795[(4)] = cljs.core.rest((state_24781[(4)])));

return statearr_24795;
})();
var state_24781__$1 = state_24781;
var ex24788 = (state_24781__$1[(2)]);
var statearr_24796_24844 = state_24781__$1;
(statearr_24796_24844[(5)] = ex24788);


var statearr_24797_24845 = state_24781__$1;
(statearr_24797_24845[(1)] = (4));

(statearr_24797_24845[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24782 === (8))){
var inst_24763 = (state_24781[(8)]);
var inst_24763__$1 = (state_24781[(2)]);
var inst_24764 = cljs.core.volatile_BANG_((0));
var inst_24765 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24763__$1;
var query_fuel = inst_24764;
return (function (p1__24675_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24675_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24675_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24766 = cljs.core.PersistentVector.EMPTY;
var inst_24767 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24763__$1;
var query_fuel = inst_24764;
return (function (p1__24674_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24674_SHARP_);
});
})();
var inst_24768 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24767,expandMaps);
var inst_24769 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24768);
var inst_24770 = cljs.core.async.into(inst_24766,inst_24769);
var state_24781__$1 = (function (){var statearr_24798 = state_24781;
(statearr_24798[(8)] = inst_24763__$1);

(statearr_24798[(9)] = inst_24765);

return statearr_24798;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24781__$1,(9),inst_24770);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24799 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24799[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24799[(1)] = (1));

return statearr_24799;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_24781){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24781);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24800){var ex__2730__auto__ = e24800;
var statearr_24801_24846 = state_24781;
(statearr_24801_24846[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24781[(4)]))){
var statearr_24802_24847 = state_24781;
(statearr_24802_24847[(1)] = cljs.core.first((state_24781[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24848 = state_24781;
state_24781 = G__24848;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_24781){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_24781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24803 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24803[(6)] = c__2749__auto____$1);

return statearr_24803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_24690 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24683,tuples_res);
var inst_24691 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24684__$1,inst_24689,inst_24683);
var inst_24692 = cljs.core.PersistentVector.EMPTY;
var inst_24693 = inst_24692;
var state_24734__$1 = (function (){var statearr_24804 = state_24734;
(statearr_24804[(11)] = inst_24693);

(statearr_24804[(12)] = inst_24691);

(statearr_24804[(13)] = inst_24690);

(statearr_24804[(8)] = inst_24684__$1);

(statearr_24804[(9)] = inst_24685__$1);

return statearr_24804;
})();
var statearr_24805_24849 = state_24734__$1;
(statearr_24805_24849[(2)] = null);

(statearr_24805_24849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (19))){
var inst_24693 = (state_24734[(11)]);
var inst_24696 = (state_24734[(7)]);
var inst_24716 = cljs.core.first(inst_24696);
var inst_24717 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24693,inst_24716);
var inst_24693__$1 = inst_24717;
var state_24734__$1 = (function (){var statearr_24806 = state_24734;
(statearr_24806[(11)] = inst_24693__$1);

return statearr_24806;
})();
var statearr_24807_24850 = state_24734__$1;
(statearr_24807_24850[(2)] = null);

(statearr_24807_24850[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (11))){
var inst_24727 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24809_24851 = state_24734__$1;
(statearr_24809_24851[(2)] = inst_24727);

(statearr_24809_24851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (9))){
var inst_24693 = (state_24734[(11)]);
var state_24734__$1 = state_24734;
var statearr_24810_24852 = state_24734__$1;
(statearr_24810_24852[(2)] = inst_24693);

(statearr_24810_24852[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (5))){
var _ = (function (){var statearr_24811 = state_24734;
(statearr_24811[(4)] = cljs.core.rest((state_24734[(4)])));

return statearr_24811;
})();
var state_24734__$1 = state_24734;
var ex24808 = (state_24734__$1[(2)]);
var statearr_24812_24853 = state_24734__$1;
(statearr_24812_24853[(5)] = ex24808);


if((ex24808 instanceof Error)){
var statearr_24813_24854 = state_24734__$1;
(statearr_24813_24854[(1)] = (4));

(statearr_24813_24854[(5)] = null);

} else {
throw ex24808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (14))){
var inst_24725 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24814_24855 = state_24734__$1;
(statearr_24814_24855[(2)] = inst_24725);

(statearr_24814_24855[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (16))){
var state_24734__$1 = state_24734;
var statearr_24815_24856 = state_24734__$1;
(statearr_24815_24856[(2)] = null);

(statearr_24815_24856[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (10))){
var inst_24696 = (state_24734[(7)]);
var inst_24700 = fluree.db.util.core.exception_QMARK_(inst_24696);
var state_24734__$1 = state_24734;
if(inst_24700){
var statearr_24816_24857 = state_24734__$1;
(statearr_24816_24857[(1)] = (12));

} else {
var statearr_24817_24858 = state_24734__$1;
(statearr_24817_24858[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (18))){
var inst_24685 = (state_24734[(9)]);
var inst_24709 = (inst_24685.cljs$core$IFn$_invoke$arity$0 ? inst_24685.cljs$core$IFn$_invoke$arity$0() : inst_24685.call(null));
var inst_24710 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24711 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24712 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24713 = cljs.core.PersistentHashMap.fromArrays(inst_24711,inst_24712);
var inst_24714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24710,inst_24713);
var state_24734__$1 = (function (){var statearr_24818 = state_24734;
(statearr_24818[(14)] = inst_24709);

return statearr_24818;
})();
var statearr_24819_24859 = state_24734__$1;
(statearr_24819_24859[(2)] = inst_24714);

(statearr_24819_24859[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (8))){
var inst_24696 = (state_24734[(7)]);
var inst_24696__$1 = (state_24734[(2)]);
var inst_24697 = (inst_24696__$1 == null);
var state_24734__$1 = (function (){var statearr_24820 = state_24734;
(statearr_24820[(7)] = inst_24696__$1);

return statearr_24820;
})();
if(cljs.core.truth_(inst_24697)){
var statearr_24821_24860 = state_24734__$1;
(statearr_24821_24860[(1)] = (9));

} else {
var statearr_24822_24861 = state_24734__$1;
(statearr_24822_24861[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24823[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24823[(1)] = (1));

return statearr_24823;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_24734){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24734);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24824){var ex__2730__auto__ = e24824;
var statearr_24825_24862 = state_24734;
(statearr_24825_24862[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24734[(4)]))){
var statearr_24826_24863 = state_24734;
(statearr_24826_24863[(1)] = cljs.core.first((state_24734[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24864 = state_24734;
state_24734 = G__24864;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_24734){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_24734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24827 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24827[(6)] = c__2749__auto__);

return statearr_24827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24865 = select;
var map__24865__$1 = cljs.core.__destructure_map(map__24865);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24865__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24865__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24865__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24868 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24868,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24868,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24868,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24866_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24866_SHARP_,compare_idx));
}):(function (p1__24867_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24867_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24873 = arguments.length;
switch (G__24873) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24874,p__24875,group_limit,opts){
var map__24876 = p__24874;
var map__24876__$1 = cljs.core.__destructure_map(map__24876);
var res = map__24876__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24876__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24877 = p__24875;
var map__24877__$1 = cljs.core.__destructure_map(map__24877);
var select_spec = map__24877__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24877__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25014){
var state_val_25015 = (state_25014[(1)]);
if((state_val_25015 === (7))){
var inst_24884 = (state_25014[(7)]);
var state_25014__$1 = state_25014;
var statearr_25016_25118 = state_25014__$1;
(statearr_25016_25118[(2)] = inst_24884);

(statearr_25016_25118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (59))){
var inst_25007 = (state_25014[(2)]);
var state_25014__$1 = state_25014;
var statearr_25017_25119 = state_25014__$1;
(statearr_25017_25119[(2)] = inst_25007);

(statearr_25017_25119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (20))){
var inst_24923 = (state_25014[(8)]);
var inst_24920 = (state_25014[(9)]);
var inst_24919 = (state_25014[(2)]);
var inst_24920__$1 = cljs.core.__destructure_map(inst_24919);
var inst_24921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24920__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24920__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24923__$1 = offset;
var state_25014__$1 = (function (){var statearr_25018 = state_25014;
(statearr_25018[(8)] = inst_24923__$1);

(statearr_25018[(10)] = inst_24922);

(statearr_25018[(11)] = inst_24921);

(statearr_25018[(9)] = inst_24920__$1);

return statearr_25018;
})();
if(cljs.core.truth_(inst_24923__$1)){
var statearr_25019_25120 = state_25014__$1;
(statearr_25019_25120[(1)] = (21));

} else {
var statearr_25020_25121 = state_25014__$1;
(statearr_25020_25121[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (58))){
var inst_24999 = (state_25014[(12)]);
var state_25014__$1 = state_25014;
var statearr_25021_25122 = state_25014__$1;
(statearr_25021_25122[(2)] = inst_24999);

(statearr_25021_25122[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (60))){
var inst_25003 = (state_25014[(2)]);
var inst_25004 = fluree.db.util.async.throw_err(inst_25003);
var state_25014__$1 = state_25014;
var statearr_25022_25123 = state_25014__$1;
(statearr_25022_25123[(2)] = inst_25004);

(statearr_25022_25123[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (27))){
var inst_24935 = cljs.core.not(inVector_QMARK_);
var state_25014__$1 = state_25014;
var statearr_25023_25124 = state_25014__$1;
(statearr_25023_25124[(2)] = inst_24935);

(statearr_25023_25124[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (1))){
var state_25014__$1 = state_25014;
var statearr_25024_25125 = state_25014__$1;
(statearr_25024_25125[(2)] = null);

(statearr_25024_25125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (24))){
var state_25014__$1 = state_25014;
var statearr_25025_25126 = state_25014__$1;
(statearr_25025_25126[(2)] = offset);

(statearr_25025_25126[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (55))){
var inst_24993 = (state_25014[(13)]);
var state_25014__$1 = state_25014;
var statearr_25026_25127 = state_25014__$1;
(statearr_25026_25127[(2)] = inst_24993);

(statearr_25026_25127[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (39))){
var inst_24961 = (state_25014[(14)]);
var inst_24963 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_24964 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24961,inst_24963);
var state_25014__$1 = state_25014;
var statearr_25027_25128 = state_25014__$1;
(statearr_25027_25128[(2)] = inst_24964);

(statearr_25027_25128[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (46))){
var inst_24973 = (state_25014[(15)]);
var state_25014__$1 = state_25014;
var statearr_25028_25129 = state_25014__$1;
(statearr_25028_25129[(2)] = inst_24973);

(statearr_25028_25129[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (4))){
var inst_24878 = (state_25014[(2)]);
var state_25014__$1 = state_25014;
var statearr_25029_25130 = state_25014__$1;
(statearr_25029_25130[(2)] = inst_24878);

(statearr_25029_25130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (54))){
var inst_24987 = (state_25014[(16)]);
var inst_24993 = (state_25014[(13)]);
var inst_24995 = cljs.core.PersistentVector.EMPTY;
var inst_24996 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_24995,inst_24987,inst_24993);
var state_25014__$1 = state_25014;
var statearr_25030_25131 = state_25014__$1;
(statearr_25030_25131[(2)] = inst_24996);

(statearr_25030_25131[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (15))){
var inst_24905 = (state_25014[(17)]);
var inst_24907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24908 = [inst_24905];
var inst_24909 = (new cljs.core.PersistentVector(null,1,(5),inst_24907,inst_24908,null));
var state_25014__$1 = state_25014;
var statearr_25031_25132 = state_25014__$1;
(statearr_25031_25132[(2)] = inst_24909);

(statearr_25031_25132[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (48))){
var inst_24979 = (state_25014[(18)]);
var inst_24943 = (state_25014[(19)]);
var inst_24922 = (state_25014[(10)]);
var inst_24938 = (state_25014[(20)]);
var inst_24921 = (state_25014[(11)]);
var inst_24920 = (state_25014[(9)]);
var inst_24932 = (state_25014[(21)]);
var inst_24981 = (function (){var map__24914 = inst_24920;
var headers = inst_24921;
var tuples = inst_24922;
var offset_SINGLEQUOTE_ = inst_24932;
var single_result_QMARK_ = inst_24938;
var pp_keys = inst_24943;
var G__24944 = inst_24979;
return (function (p1__24871_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24871_SHARP_);
});
})();
var inst_24982 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24981);
var inst_24983 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24979,inst_24982);
var state_25014__$1 = state_25014;
var statearr_25032_25133 = state_25014__$1;
(statearr_25032_25133[(2)] = inst_24983);

(statearr_25032_25133[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (50))){
var inst_24986 = (state_25014[(2)]);
var inst_24987 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_24986);
var state_25014__$1 = (function (){var statearr_25033 = state_25014;
(statearr_25033[(16)] = inst_24987);

return statearr_25033;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25034_25134 = state_25014__$1;
(statearr_25034_25134[(1)] = (51));

} else {
var statearr_25035_25135 = state_25014__$1;
(statearr_25035_25135[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (21))){
var inst_24925 = cljs.core.not(groupBy);
var state_25014__$1 = state_25014;
var statearr_25036_25136 = state_25014__$1;
(statearr_25036_25136[(2)] = inst_24925);

(statearr_25036_25136[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (31))){
var state_25014__$1 = state_25014;
var statearr_25037_25137 = state_25014__$1;
(statearr_25037_25137[(2)] = null);

(statearr_25037_25137[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (32))){
var inst_24938 = (state_25014[(20)]);
var inst_24921 = (state_25014[(11)]);
var inst_24943 = (state_25014[(2)]);
var inst_24945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24946 = fluree.db.query.fql.select_tuples_fn(inst_24921,vars,select);
var inst_24947 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24946);
var inst_24948 = [inst_24947];
var inst_24949 = (new cljs.core.PersistentVector(null,1,(5),inst_24945,inst_24948,null));
var state_25014__$1 = (function (){var statearr_25038 = state_25014;
(statearr_25038[(19)] = inst_24943);

(statearr_25038[(22)] = inst_24949);

return statearr_25038;
})();
if(cljs.core.truth_(inst_24938)){
var statearr_25039_25138 = state_25014__$1;
(statearr_25039_25138[(1)] = (33));

} else {
var statearr_25040_25139 = state_25014__$1;
(statearr_25040_25139[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (40))){
var inst_24961 = (state_25014[(14)]);
var state_25014__$1 = state_25014;
var statearr_25041_25140 = state_25014__$1;
(statearr_25041_25140[(2)] = inst_24961);

(statearr_25041_25140[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (56))){
var inst_24999 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25042 = state_25014;
(statearr_25042[(12)] = inst_24999);

return statearr_25042;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25043_25141 = state_25014__$1;
(statearr_25043_25141[(1)] = (57));

} else {
var statearr_25044_25142 = state_25014__$1;
(statearr_25044_25142[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (33))){
var inst_24949 = (state_25014[(22)]);
var inst_24951 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_24952 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24949,inst_24951);
var state_25014__$1 = state_25014;
var statearr_25045_25143 = state_25014__$1;
(statearr_25045_25143[(2)] = inst_24952);

(statearr_25045_25143[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (13))){
var inst_24894 = (state_25014[(23)]);
var state_25014__$1 = state_25014;
var statearr_25046_25144 = state_25014__$1;
(statearr_25046_25144[(2)] = inst_24894);

(statearr_25046_25144[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (22))){
var inst_24923 = (state_25014[(8)]);
var state_25014__$1 = state_25014;
var statearr_25047_25145 = state_25014__$1;
(statearr_25047_25145[(2)] = inst_24923);

(statearr_25047_25145[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (36))){
var inst_24955 = (state_25014[(24)]);
var inst_24957 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_24958 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24955,inst_24957);
var state_25014__$1 = state_25014;
var statearr_25048_25146 = state_25014__$1;
(statearr_25048_25146[(2)] = inst_24958);

(statearr_25048_25146[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (41))){
var inst_24932 = (state_25014[(21)]);
var inst_24967 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25049 = state_25014;
(statearr_25049[(25)] = inst_24967);

return statearr_25049;
})();
if(cljs.core.truth_(inst_24932)){
var statearr_25050_25147 = state_25014__$1;
(statearr_25050_25147[(1)] = (42));

} else {
var statearr_25051_25148 = state_25014__$1;
(statearr_25051_25148[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (43))){
var inst_24967 = (state_25014[(25)]);
var state_25014__$1 = state_25014;
var statearr_25052_25149 = state_25014__$1;
(statearr_25052_25149[(2)] = inst_24967);

(statearr_25052_25149[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (29))){
var inst_24938 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25053 = state_25014;
(statearr_25053[(20)] = inst_24938);

return statearr_25053;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25054_25150 = state_25014__$1;
(statearr_25054_25150[(1)] = (30));

} else {
var statearr_25055_25151 = state_25014__$1;
(statearr_25055_25151[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (44))){
var inst_24973 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25056 = state_25014;
(statearr_25056[(15)] = inst_24973);

return statearr_25056;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25057_25152 = state_25014__$1;
(statearr_25057_25152[(1)] = (45));

} else {
var statearr_25058_25153 = state_25014__$1;
(statearr_25058_25153[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (6))){
var inst_24886 = cljs.core.count(select);
var inst_24887 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24886);
var state_25014__$1 = state_25014;
var statearr_25059_25154 = state_25014__$1;
(statearr_25059_25154[(2)] = inst_24887);

(statearr_25059_25154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (28))){
var inst_24933 = (state_25014[(26)]);
var state_25014__$1 = state_25014;
var statearr_25060_25155 = state_25014__$1;
(statearr_25060_25155[(2)] = inst_24933);

(statearr_25060_25155[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (51))){
var inst_24922 = (state_25014[(10)]);
var inst_24921 = (state_25014[(11)]);
var inst_24990 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_24921,orderBy,inst_24922);
var state_25014__$1 = state_25014;
var statearr_25061_25156 = state_25014__$1;
(statearr_25061_25156[(2)] = inst_24990);

(statearr_25061_25156[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (25))){
var state_25014__$1 = state_25014;
var statearr_25062_25157 = state_25014__$1;
(statearr_25062_25157[(2)] = null);

(statearr_25062_25157[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (34))){
var inst_24949 = (state_25014[(22)]);
var state_25014__$1 = state_25014;
var statearr_25063_25158 = state_25014__$1;
(statearr_25063_25158[(2)] = inst_24949);

(statearr_25063_25158[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (17))){
var inst_24912 = (state_25014[(2)]);
var state_25014__$1 = state_25014;
var statearr_25064_25159 = state_25014__$1;
(statearr_25064_25159[(2)] = inst_24912);

(statearr_25064_25159[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (3))){
var inst_25012 = (state_25014[(2)]);
var state_25014__$1 = state_25014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25014__$1,inst_25012);
} else {
if((state_val_25015 === (12))){
var inst_24894 = (state_25014[(23)]);
var inst_24896 = cljs.core.first(select);
var inst_24897 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24896);
var inst_24898 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24897);
var inst_24899 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24898,(1));
var inst_24900 = [inst_24899];
var inst_24901 = [inst_24894];
var inst_24902 = cljs.core.PersistentHashMap.fromArrays(inst_24900,inst_24901);
var state_25014__$1 = state_25014;
var statearr_25065_25160 = state_25014__$1;
(statearr_25065_25160[(2)] = inst_24902);

(statearr_25065_25160[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (2))){
var inst_24884 = (state_25014[(7)]);
var _ = (function (){var statearr_25066 = state_25014;
(statearr_25066[(4)] = cljs.core.cons((5),(state_25014[(4)])));

return statearr_25066;
})();
var inst_24884__$1 = aggregates;
var state_25014__$1 = (function (){var statearr_25067 = state_25014;
(statearr_25067[(7)] = inst_24884__$1);

return statearr_25067;
})();
if(cljs.core.truth_(inst_24884__$1)){
var statearr_25068_25161 = state_25014__$1;
(statearr_25068_25161[(1)] = (6));

} else {
var statearr_25069_25162 = state_25014__$1;
(statearr_25069_25162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (23))){
var inst_24928 = (state_25014[(2)]);
var state_25014__$1 = state_25014;
if(cljs.core.truth_(inst_24928)){
var statearr_25070_25163 = state_25014__$1;
(statearr_25070_25163[(1)] = (24));

} else {
var statearr_25071_25164 = state_25014__$1;
(statearr_25071_25164[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (47))){
var inst_24979 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25072 = state_25014;
(statearr_25072[(18)] = inst_24979);

return statearr_25072;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25073_25165 = state_25014__$1;
(statearr_25073_25165[(1)] = (48));

} else {
var statearr_25074_25166 = state_25014__$1;
(statearr_25074_25166[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (35))){
var inst_24955 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25075 = state_25014;
(statearr_25075[(24)] = inst_24955);

return statearr_25075;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25076_25167 = state_25014__$1;
(statearr_25076_25167[(1)] = (36));

} else {
var statearr_25077_25168 = state_25014__$1;
(statearr_25077_25168[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (19))){
var state_25014__$1 = state_25014;
var statearr_25078_25169 = state_25014__$1;
(statearr_25078_25169[(2)] = res);

(statearr_25078_25169[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (57))){
var inst_24943 = (state_25014[(19)]);
var inst_24999 = (state_25014[(12)]);
var inst_24938 = (state_25014[(20)]);
var inst_25001 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_24943,inst_24938,db,fuel,max_fuel,opts,(8),inst_24999);
var state_25014__$1 = state_25014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25014__$1,(60),inst_25001);
} else {
if((state_val_25015 === (11))){
var inst_25009 = (state_25014[(2)]);
var _ = (function (){var statearr_25080 = state_25014;
(statearr_25080[(4)] = cljs.core.rest((state_25014[(4)])));

return statearr_25080;
})();
var state_25014__$1 = state_25014;
var statearr_25081_25170 = state_25014__$1;
(statearr_25081_25170[(2)] = inst_25009);

(statearr_25081_25170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (9))){
var inst_24892 = cljs.core.first(aggregates);
var inst_24893 = fluree.db.query.analytical.calculate_aggregate(res,inst_24892);
var inst_24894 = cljs.core.second(inst_24893);
var state_25014__$1 = (function (){var statearr_25082 = state_25014;
(statearr_25082[(23)] = inst_24894);

return statearr_25082;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25083_25171 = state_25014__$1;
(statearr_25083_25171[(1)] = (12));

} else {
var statearr_25084_25172 = state_25014__$1;
(statearr_25084_25172[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (5))){
var _ = (function (){var statearr_25085 = state_25014;
(statearr_25085[(4)] = cljs.core.rest((state_25014[(4)])));

return statearr_25085;
})();
var state_25014__$1 = state_25014;
var ex25079 = (state_25014__$1[(2)]);
var statearr_25086_25173 = state_25014__$1;
(statearr_25086_25173[(5)] = ex25079);


if((ex25079 instanceof Error)){
var statearr_25087_25174 = state_25014__$1;
(statearr_25087_25174[(1)] = (4));

(statearr_25087_25174[(5)] = null);

} else {
throw ex25079;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (14))){
var inst_24905 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25088 = state_25014;
(statearr_25088[(17)] = inst_24905);

return statearr_25088;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25089_25175 = state_25014__$1;
(statearr_25089_25175[(1)] = (15));

} else {
var statearr_25090_25176 = state_25014__$1;
(statearr_25090_25176[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (45))){
var inst_24973 = (state_25014[(15)]);
var inst_24975 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_24976 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24973,inst_24975);
var state_25014__$1 = state_25014;
var statearr_25091_25177 = state_25014__$1;
(statearr_25091_25177[(2)] = inst_24976);

(statearr_25091_25177[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (53))){
var inst_24993 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25092 = state_25014;
(statearr_25092[(13)] = inst_24993);

return statearr_25092;
})();
var statearr_25093_25178 = state_25014__$1;
(statearr_25093_25178[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (26))){
var inst_24933 = (state_25014[(26)]);
var inst_24932 = (state_25014[(2)]);
var inst_24933__$1 = cljs.core.not(prettyPrint);
var state_25014__$1 = (function (){var statearr_25095 = state_25014;
(statearr_25095[(26)] = inst_24933__$1);

(statearr_25095[(21)] = inst_24932);

return statearr_25095;
})();
if(inst_24933__$1){
var statearr_25096_25179 = state_25014__$1;
(statearr_25096_25179[(1)] = (27));

} else {
var statearr_25097_25180 = state_25014__$1;
(statearr_25097_25180[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (16))){
var inst_24905 = (state_25014[(17)]);
var state_25014__$1 = state_25014;
var statearr_25098_25181 = state_25014__$1;
(statearr_25098_25181[(2)] = inst_24905);

(statearr_25098_25181[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (38))){
var inst_24961 = (state_25014[(2)]);
var state_25014__$1 = (function (){var statearr_25099 = state_25014;
(statearr_25099[(14)] = inst_24961);

return statearr_25099;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25100_25182 = state_25014__$1;
(statearr_25100_25182[(1)] = (39));

} else {
var statearr_25101_25183 = state_25014__$1;
(statearr_25101_25183[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (30))){
var inst_24940 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25014__$1 = state_25014;
var statearr_25102_25184 = state_25014__$1;
(statearr_25102_25184[(2)] = inst_24940);

(statearr_25102_25184[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (10))){
var state_25014__$1 = state_25014;
if(cljs.core.truth_(aggregates)){
var statearr_25103_25185 = state_25014__$1;
(statearr_25103_25185[(1)] = (18));

} else {
var statearr_25104_25186 = state_25014__$1;
(statearr_25104_25186[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (18))){
var inst_24916 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25014__$1 = state_25014;
var statearr_25105_25187 = state_25014__$1;
(statearr_25105_25187[(2)] = inst_24916);

(statearr_25105_25187[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (52))){
var inst_24922 = (state_25014[(10)]);
var state_25014__$1 = state_25014;
var statearr_25106_25188 = state_25014__$1;
(statearr_25106_25188[(2)] = inst_24922);

(statearr_25106_25188[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (42))){
var inst_24967 = (state_25014[(25)]);
var inst_24932 = (state_25014[(21)]);
var inst_24969 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_24932);
var inst_24970 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24967,inst_24969);
var state_25014__$1 = state_25014;
var statearr_25107_25189 = state_25014__$1;
(statearr_25107_25189[(2)] = inst_24970);

(statearr_25107_25189[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (37))){
var inst_24955 = (state_25014[(24)]);
var state_25014__$1 = state_25014;
var statearr_25108_25190 = state_25014__$1;
(statearr_25108_25190[(2)] = inst_24955);

(statearr_25108_25190[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (8))){
var inst_24890 = (state_25014[(2)]);
var state_25014__$1 = state_25014;
if(cljs.core.truth_(inst_24890)){
var statearr_25109_25191 = state_25014__$1;
(statearr_25109_25191[(1)] = (9));

} else {
var statearr_25110_25192 = state_25014__$1;
(statearr_25110_25192[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25015 === (49))){
var inst_24979 = (state_25014[(18)]);
var state_25014__$1 = state_25014;
var statearr_25111_25193 = state_25014__$1;
(statearr_25111_25193[(2)] = inst_24979);

(statearr_25111_25193[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_25112 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25112[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_25112[(1)] = (1));

return statearr_25112;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_25014){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25014);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25113){var ex__2730__auto__ = e25113;
var statearr_25114_25194 = state_25014;
(statearr_25114_25194[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25014[(4)]))){
var statearr_25115_25195 = state_25014;
(statearr_25115_25195[(1)] = cljs.core.first((state_25014[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25196 = state_25014;
state_25014 = G__25196;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_25014){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_25014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25116 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25116[(6)] = c__2749__auto__);

return statearr_25116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25199,groupBy){
var map__25200 = p__25199;
var map__25200__$1 = cljs.core.__destructure_map(map__25200);
var res = map__25200__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25200__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25200__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25201 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25201,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25201,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25197_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25197_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25198_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25198_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25204 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25204,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25204,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25207,headers,group_map){
var map__25208 = p__25207;
var map__25208__$1 = cljs.core.__destructure_map(map__25208);
var having = map__25208__$1;
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25208__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25208__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes(params,headers);
var filtered = (function (){var G__25215 = group_map;
var vec__25216 = G__25215;
var seq__25217 = cljs.core.seq(vec__25216);
var first__25218 = cljs.core.first(seq__25217);
var seq__25217__$1 = cljs.core.next(seq__25217);
var vec__25219 = first__25218;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25219,(0),null);
var tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25219,(1),null);
var r = seq__25217__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25215__$1 = G__25215;
var acc__$1 = acc;
while(true){
var vec__25231 = G__25215__$1;
var seq__25232 = cljs.core.seq(vec__25231);
var first__25233 = cljs.core.first(seq__25232);
var seq__25232__$1 = cljs.core.next(seq__25232);
var vec__25234 = first__25233;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25234,(0),null);
var tuples__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25234,(1),null);
var r__$1 = seq__25232__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten(fluree.db.query.analytical.transform_tuples_to_idxs(idxs,tuples__$1));
var res = (function (){try{return (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(argument) : function$.call(null,argument));
}catch (e25237){var e = e25237;
var G__25238_25240 = e;
var G__25239_25241 = ["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__25238_25240,G__25239_25241) : fluree.db.util.log.error.call(null,G__25238_25240,G__25239_25241));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message(e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25242 = r__$1;
var G__25243 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc__$2,k__$1,tuples__$1);
G__25215__$1 = G__25242;
acc__$1 = G__25243;
continue;
} else {
var G__25244 = r__$1;
var G__25245 = acc__$2;
G__25215__$1 = G__25244;
acc__$1 = G__25245;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25246,p__25247,opts){
var map__25248 = p__25246;
var map__25248__$1 = cljs.core.__destructure_map(map__25248);
var res = map__25248__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25248__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25248__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25249 = p__25247;
var map__25249__$1 = cljs.core.__destructure_map(map__25249);
var select_spec = map__25249__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25249__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25373){
var state_val_25374 = (state_25373[(1)]);
if((state_val_25374 === (7))){
var state_25373__$1 = state_25373;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25375_25448 = state_25373__$1;
(statearr_25375_25448[(1)] = (30));

} else {
var statearr_25376_25449 = state_25373__$1;
(statearr_25376_25449[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (20))){
var inst_25280 = (state_25373[(2)]);
var state_25373__$1 = (function (){var statearr_25377 = state_25373;
(statearr_25377[(7)] = inst_25280);

return statearr_25377;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25378_25450 = state_25373__$1;
(statearr_25378_25450[(1)] = (21));

} else {
var statearr_25379_25451 = state_25373__$1;
(statearr_25379_25451[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (27))){
var inst_25306 = (state_25373[(8)]);
var state_25373__$1 = state_25373;
var statearr_25380_25452 = state_25373__$1;
(statearr_25380_25452[(2)] = inst_25306);

(statearr_25380_25452[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (1))){
var state_25373__$1 = state_25373;
var statearr_25381_25453 = state_25373__$1;
(statearr_25381_25453[(2)] = null);

(statearr_25381_25453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (24))){
var inst_25305 = (state_25373[(9)]);
var inst_25317 = (state_25373[(10)]);
var inst_25314 = cljs.core.seq(inst_25305);
var inst_25315 = cljs.core.first(inst_25314);
var inst_25316 = cljs.core.next(inst_25314);
var inst_25317__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25315,(0),null);
var inst_25318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25315,(1),null);
var state_25373__$1 = (function (){var statearr_25382 = state_25373;
(statearr_25382[(11)] = inst_25316);

(statearr_25382[(12)] = inst_25318);

(statearr_25382[(10)] = inst_25317__$1);

return statearr_25382;
})();
if(cljs.core.truth_(inst_25317__$1)){
var statearr_25383_25454 = state_25373__$1;
(statearr_25383_25454[(1)] = (26));

} else {
var statearr_25384_25455 = state_25373__$1;
(statearr_25384_25455[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (39))){
var inst_25354 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25385_25456 = state_25373__$1;
(statearr_25385_25456[(2)] = inst_25354);

(statearr_25385_25456[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (4))){
var inst_25250 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25386_25457 = state_25373__$1;
(statearr_25386_25457[(2)] = inst_25250);

(statearr_25386_25457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (15))){
var inst_25270 = (state_25373[(13)]);
var inst_25272 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_25270);
var state_25373__$1 = state_25373;
var statearr_25387_25458 = state_25373__$1;
(statearr_25387_25458[(2)] = inst_25272);

(statearr_25387_25458[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (21))){
var inst_25280 = (state_25373[(7)]);
var inst_25282 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_25280);
var state_25373__$1 = state_25373;
var statearr_25388_25459 = state_25373__$1;
(statearr_25388_25459[(2)] = inst_25282);

(statearr_25388_25459[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (31))){
var state_25373__$1 = state_25373;
var statearr_25389_25460 = state_25373__$1;
(statearr_25389_25460[(2)] = limit);

(statearr_25389_25460[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (32))){
var inst_25340 = (state_25373[(2)]);
var inst_25341 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25340,opts);
var state_25373__$1 = state_25373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25373__$1,(33),inst_25341);
} else {
if((state_val_25374 === (40))){
var inst_25344 = (state_25373[(14)]);
var inst_25357 = cljs.core.first(inst_25344);
var state_25373__$1 = state_25373;
var statearr_25390_25461 = state_25373__$1;
(statearr_25390_25461[(2)] = inst_25357);

(statearr_25390_25461[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (33))){
var inst_25344 = (state_25373[(14)]);
var inst_25343 = (state_25373[(2)]);
var inst_25344__$1 = fluree.db.util.async.throw_err(inst_25343);
var inst_25345 = cljs.core.coll_QMARK_(inst_25344__$1);
var inst_25346 = (!(inst_25345));
var state_25373__$1 = (function (){var statearr_25391 = state_25373;
(statearr_25391[(14)] = inst_25344__$1);

return statearr_25391;
})();
if(inst_25346){
var statearr_25392_25462 = state_25373__$1;
(statearr_25392_25462[(1)] = (34));

} else {
var statearr_25393_25463 = state_25373__$1;
(statearr_25393_25463[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (13))){
var inst_25265 = (state_25373[(15)]);
var state_25373__$1 = state_25373;
var statearr_25394_25464 = state_25373__$1;
(statearr_25394_25464[(2)] = inst_25265);

(statearr_25394_25464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (22))){
var inst_25280 = (state_25373[(7)]);
var state_25373__$1 = state_25373;
var statearr_25395_25465 = state_25373__$1;
(statearr_25395_25465[(2)] = inst_25280);

(statearr_25395_25465[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (36))){
var inst_25366 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25396_25466 = state_25373__$1;
(statearr_25396_25466[(2)] = inst_25366);

(statearr_25396_25466[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (41))){
var state_25373__$1 = state_25373;
var statearr_25397_25467 = state_25373__$1;
(statearr_25397_25467[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (43))){
var inst_25344 = (state_25373[(14)]);
var state_25373__$1 = state_25373;
var statearr_25399_25468 = state_25373__$1;
(statearr_25399_25468[(2)] = inst_25344);

(statearr_25399_25468[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (29))){
var inst_25316 = (state_25373[(11)]);
var inst_25306 = (state_25373[(8)]);
var inst_25317 = (state_25373[(10)]);
var inst_25327 = (state_25373[(2)]);
var inst_25328 = fluree.db.util.async.throw_err(inst_25327);
var inst_25329 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25306,inst_25317,inst_25328);
var inst_25305 = inst_25316;
var inst_25306__$1 = inst_25329;
var state_25373__$1 = (function (){var statearr_25400 = state_25373;
(statearr_25400[(9)] = inst_25305);

(statearr_25400[(8)] = inst_25306__$1);

return statearr_25400;
})();
var statearr_25401_25469 = state_25373__$1;
(statearr_25401_25469[(2)] = null);

(statearr_25401_25469[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (44))){
var state_25373__$1 = state_25373;
var statearr_25402_25470 = state_25373__$1;
(statearr_25402_25470[(2)] = null);

(statearr_25402_25470[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (6))){
var inst_25257 = (state_25373[(16)]);
var inst_25257__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25259 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25373__$1 = (function (){var statearr_25403 = state_25373;
(statearr_25403[(16)] = inst_25257__$1);

(statearr_25403[(17)] = inst_25259);

return statearr_25403;
})();
if(cljs.core.truth_(inst_25257__$1)){
var statearr_25404_25471 = state_25373__$1;
(statearr_25404_25471[(1)] = (9));

} else {
var statearr_25405_25472 = state_25373__$1;
(statearr_25405_25472[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (28))){
var inst_25333 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25406_25473 = state_25373__$1;
(statearr_25406_25473[(2)] = inst_25333);

(statearr_25406_25473[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (25))){
var inst_25335 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25407_25474 = state_25373__$1;
(statearr_25407_25474[(2)] = inst_25335);

(statearr_25407_25474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (34))){
var state_25373__$1 = state_25373;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25408_25475 = state_25373__$1;
(statearr_25408_25475[(1)] = (37));

} else {
var statearr_25409_25476 = state_25373__$1;
(statearr_25409_25476[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (17))){
var inst_25275 = (state_25373[(2)]);
var state_25373__$1 = (function (){var statearr_25410 = state_25373;
(statearr_25410[(18)] = inst_25275);

return statearr_25410;
})();
if(cljs.core.truth_(limit)){
var statearr_25411_25477 = state_25373__$1;
(statearr_25411_25477[(1)] = (18));

} else {
var statearr_25412_25478 = state_25373__$1;
(statearr_25412_25478[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (3))){
var inst_25371 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25373__$1,inst_25371);
} else {
if((state_val_25374 === (12))){
var inst_25265 = (state_25373[(15)]);
var inst_25267 = fluree.db.query.fql.filter_having(having,headers,inst_25265);
var state_25373__$1 = state_25373;
var statearr_25413_25479 = state_25373__$1;
(statearr_25413_25479[(2)] = inst_25267);

(statearr_25413_25479[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (2))){
var _ = (function (){var statearr_25414 = state_25373;
(statearr_25414[(4)] = cljs.core.cons((5),(state_25373[(4)])));

return statearr_25414;
})();
var state_25373__$1 = state_25373;
if(cljs.core.truth_(groupBy)){
var statearr_25415_25480 = state_25373__$1;
(statearr_25415_25480[(1)] = (6));

} else {
var statearr_25416_25481 = state_25373__$1;
(statearr_25416_25481[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (23))){
var inst_25285 = (state_25373[(2)]);
var inst_25299 = cljs.core.seq(inst_25285);
var inst_25300 = cljs.core.first(inst_25299);
var inst_25301 = cljs.core.next(inst_25299);
var inst_25302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25300,(0),null);
var inst_25303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25300,(1),null);
var inst_25304 = cljs.core.PersistentHashMap.EMPTY;
var inst_25305 = inst_25285;
var inst_25306 = inst_25304;
var state_25373__$1 = (function (){var statearr_25417 = state_25373;
(statearr_25417[(19)] = inst_25301);

(statearr_25417[(20)] = inst_25302);

(statearr_25417[(9)] = inst_25305);

(statearr_25417[(8)] = inst_25306);

(statearr_25417[(21)] = inst_25303);

return statearr_25417;
})();
var statearr_25418_25482 = state_25373__$1;
(statearr_25418_25482[(2)] = null);

(statearr_25418_25482[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (35))){
var state_25373__$1 = state_25373;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25419_25483 = state_25373__$1;
(statearr_25419_25483[(1)] = (40));

} else {
var statearr_25420_25484 = state_25373__$1;
(statearr_25420_25484[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (19))){
var inst_25275 = (state_25373[(18)]);
var state_25373__$1 = state_25373;
var statearr_25421_25485 = state_25373__$1;
(statearr_25421_25485[(2)] = inst_25275);

(statearr_25421_25485[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (11))){
var inst_25265 = (state_25373[(2)]);
var state_25373__$1 = (function (){var statearr_25423 = state_25373;
(statearr_25423[(15)] = inst_25265);

return statearr_25423;
})();
if(cljs.core.truth_(having)){
var statearr_25424_25486 = state_25373__$1;
(statearr_25424_25486[(1)] = (12));

} else {
var statearr_25425_25487 = state_25373__$1;
(statearr_25425_25487[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (9))){
var inst_25257 = (state_25373[(16)]);
var inst_25259 = (state_25373[(17)]);
var inst_25261 = cljs.core.sorted_map_by(inst_25257);
var inst_25262 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25261,inst_25259);
var state_25373__$1 = state_25373;
var statearr_25426_25488 = state_25373__$1;
(statearr_25426_25488[(2)] = inst_25262);

(statearr_25426_25488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (5))){
var _ = (function (){var statearr_25427 = state_25373;
(statearr_25427[(4)] = cljs.core.rest((state_25373[(4)])));

return statearr_25427;
})();
var state_25373__$1 = state_25373;
var ex25422 = (state_25373__$1[(2)]);
var statearr_25428_25489 = state_25373__$1;
(statearr_25428_25489[(5)] = ex25422);


if((ex25422 instanceof Error)){
var statearr_25429_25490 = state_25373__$1;
(statearr_25429_25490[(1)] = (4));

(statearr_25429_25490[(5)] = null);

} else {
throw ex25422;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (14))){
var inst_25270 = (state_25373[(2)]);
var state_25373__$1 = (function (){var statearr_25430 = state_25373;
(statearr_25430[(13)] = inst_25270);

return statearr_25430;
})();
if(cljs.core.truth_(offset)){
var statearr_25431_25491 = state_25373__$1;
(statearr_25431_25491[(1)] = (15));

} else {
var statearr_25432_25492 = state_25373__$1;
(statearr_25432_25492[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (45))){
var inst_25362 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25433_25493 = state_25373__$1;
(statearr_25433_25493[(2)] = inst_25362);

(statearr_25433_25493[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (26))){
var inst_25318 = (state_25373[(12)]);
var inst_25320 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25321 = [headers,vars,inst_25318];
var inst_25322 = cljs.core.PersistentHashMap.fromArrays(inst_25320,inst_25321);
var inst_25323 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25325 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25322,inst_25323,inst_25324);
var state_25373__$1 = state_25373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25373__$1,(29),inst_25325);
} else {
if((state_val_25374 === (16))){
var inst_25270 = (state_25373[(13)]);
var state_25373__$1 = state_25373;
var statearr_25434_25494 = state_25373__$1;
(statearr_25434_25494[(2)] = inst_25270);

(statearr_25434_25494[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (38))){
var inst_25344 = (state_25373[(14)]);
var state_25373__$1 = state_25373;
var statearr_25435_25495 = state_25373__$1;
(statearr_25435_25495[(2)] = inst_25344);

(statearr_25435_25495[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (30))){
var state_25373__$1 = state_25373;
var statearr_25436_25496 = state_25373__$1;
(statearr_25436_25496[(2)] = (1));

(statearr_25436_25496[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (10))){
var inst_25259 = (state_25373[(17)]);
var state_25373__$1 = state_25373;
var statearr_25437_25497 = state_25373__$1;
(statearr_25437_25497[(2)] = inst_25259);

(statearr_25437_25497[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (18))){
var inst_25275 = (state_25373[(18)]);
var inst_25277 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_25275);
var state_25373__$1 = state_25373;
var statearr_25438_25498 = state_25373__$1;
(statearr_25438_25498[(2)] = inst_25277);

(statearr_25438_25498[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (42))){
var inst_25364 = (state_25373[(2)]);
var state_25373__$1 = state_25373;
var statearr_25439_25499 = state_25373__$1;
(statearr_25439_25499[(2)] = inst_25364);

(statearr_25439_25499[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (37))){
var inst_25344 = (state_25373[(14)]);
var inst_25349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25350 = [inst_25344];
var inst_25351 = (new cljs.core.PersistentVector(null,1,(5),inst_25349,inst_25350,null));
var state_25373__$1 = state_25373;
var statearr_25440_25500 = state_25373__$1;
(statearr_25440_25500[(2)] = inst_25351);

(statearr_25440_25500[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25374 === (8))){
var inst_25368 = (state_25373[(2)]);
var _ = (function (){var statearr_25441 = state_25373;
(statearr_25441[(4)] = cljs.core.rest((state_25373[(4)])));

return statearr_25441;
})();
var state_25373__$1 = state_25373;
var statearr_25442_25501 = state_25373__$1;
(statearr_25442_25501[(2)] = inst_25368);

(statearr_25442_25501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_25443 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25443[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_25443[(1)] = (1));

return statearr_25443;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_25373){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25373);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25444){var ex__2730__auto__ = e25444;
var statearr_25445_25502 = state_25373;
(statearr_25445_25502[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25373[(4)]))){
var statearr_25446_25503 = state_25373;
(statearr_25446_25503[(1)] = cljs.core.first((state_25373[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25504 = state_25373;
state_25373 = G__25504;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_25373){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_25373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25447 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25447[(6)] = c__2749__auto__);

return statearr_25447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25565){
var state_val_25566 = (state_25565[(1)]);
if((state_val_25566 === (7))){
var state_25565__$1 = state_25565;
var statearr_25567_25605 = state_25565__$1;
(statearr_25567_25605[(2)] = (0));

(statearr_25567_25605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (20))){
var inst_25549 = (state_25565[(2)]);
var state_25565__$1 = state_25565;
var statearr_25568_25606 = state_25565__$1;
(statearr_25568_25606[(2)] = inst_25549);

(statearr_25568_25606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (1))){
var state_25565__$1 = state_25565;
var statearr_25569_25607 = state_25565__$1;
(statearr_25569_25607[(2)] = null);

(statearr_25569_25607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (4))){
var inst_25505 = (state_25565[(2)]);
var state_25565__$1 = state_25565;
var statearr_25570_25608 = state_25565__$1;
(statearr_25570_25608[(2)] = inst_25505);

(statearr_25570_25608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (15))){
var inst_25536 = (state_25565[(7)]);
var state_25565__$1 = state_25565;
var statearr_25571_25609 = state_25565__$1;
(statearr_25571_25609[(2)] = inst_25536);

(statearr_25571_25609[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (21))){
var inst_25521 = (state_25565[(8)]);
var inst_25551 = (state_25565[(9)]);
var inst_25536 = (state_25565[(7)]);
var inst_25554 = (state_25565[(2)]);
var inst_25555 = fluree.db.util.async.throw_err(inst_25554);
var inst_25556 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25557 = fluree.db.query.fql.process_ad_hoc_res(db,inst_25551,inst_25536,inst_25555,inst_25556,inst_25521);
var state_25565__$1 = state_25565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25565__$1,(22),inst_25557);
} else {
if((state_val_25566 === (13))){
var inst_25536 = (state_25565[(7)]);
var state_25565__$1 = state_25565;
if(cljs.core.truth_(inst_25536)){
var statearr_25572_25610 = state_25565__$1;
(statearr_25572_25610[(1)] = (15));

} else {
var statearr_25573_25611 = state_25565__$1;
(statearr_25573_25611[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (22))){
var inst_25559 = (state_25565[(2)]);
var inst_25560 = fluree.db.util.async.throw_err(inst_25559);
var _ = (function (){var statearr_25574 = state_25565;
(statearr_25574[(4)] = cljs.core.rest((state_25565[(4)])));

return statearr_25574;
})();
var state_25565__$1 = state_25565;
var statearr_25575_25612 = state_25565__$1;
(statearr_25575_25612[(2)] = inst_25560);

(statearr_25575_25612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (6))){
var inst_25516 = (state_25565[(10)]);
var state_25565__$1 = state_25565;
var statearr_25576_25613 = state_25565__$1;
(statearr_25576_25613[(2)] = inst_25516);

(statearr_25576_25613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (17))){
var inst_25544 = (state_25565[(2)]);
var state_25565__$1 = state_25565;
if(cljs.core.truth_(inst_25544)){
var statearr_25577_25614 = state_25565__$1;
(statearr_25577_25614[(1)] = (18));

} else {
var statearr_25578_25615 = state_25565__$1;
(statearr_25578_25615[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (3))){
var inst_25563 = (state_25565[(2)]);
var state_25565__$1 = state_25565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25565__$1,inst_25563);
} else {
if((state_val_25566 === (12))){
var inst_25537 = (state_25565[(11)]);
var state_25565__$1 = state_25565;
var statearr_25579_25616 = state_25565__$1;
(statearr_25579_25616[(2)] = inst_25537);

(statearr_25579_25616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (2))){
var inst_25516 = (state_25565[(10)]);
var _ = (function (){var statearr_25580 = state_25565;
(statearr_25580[(4)] = cljs.core.cons((5),(state_25565[(4)])));

return statearr_25580;
})();
var inst_25512 = query_map;
var inst_25513 = cljs.core.__destructure_map(inst_25512);
var inst_25514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_25515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25516__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25519 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_25520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_25521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25513,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_25523 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_25565__$1 = (function (){var statearr_25581 = state_25565;
(statearr_25581[(10)] = inst_25516__$1);

(statearr_25581[(12)] = inst_25518);

(statearr_25581[(8)] = inst_25521);

(statearr_25581[(13)] = inst_25523);

(statearr_25581[(14)] = inst_25520);

(statearr_25581[(15)] = inst_25519);

(statearr_25581[(16)] = inst_25514);

(statearr_25581[(17)] = inst_25515);

(statearr_25581[(18)] = inst_25517);

return statearr_25581;
})();
if(cljs.core.truth_(inst_25516__$1)){
var statearr_25582_25617 = state_25565__$1;
(statearr_25582_25617[(1)] = (6));

} else {
var statearr_25583_25618 = state_25565__$1;
(statearr_25583_25618[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (19))){
var state_25565__$1 = state_25565;
var statearr_25584_25619 = state_25565__$1;
(statearr_25584_25619[(2)] = null);

(statearr_25584_25619[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (11))){
var inst_25537 = (state_25565[(11)]);
var inst_25521 = (state_25565[(8)]);
var inst_25535 = (state_25565[(19)]);
var inst_25535__$1 = (state_25565[(2)]);
var inst_25536 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_25535__$1);
var inst_25537__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_25521);
var state_25565__$1 = (function (){var statearr_25586 = state_25565;
(statearr_25586[(11)] = inst_25537__$1);

(statearr_25586[(19)] = inst_25535__$1);

(statearr_25586[(7)] = inst_25536);

return statearr_25586;
})();
if(cljs.core.truth_(inst_25537__$1)){
var statearr_25587_25620 = state_25565__$1;
(statearr_25587_25620[(1)] = (12));

} else {
var statearr_25588_25621 = state_25565__$1;
(statearr_25588_25621[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (9))){
var inst_25530 = (state_25565[(20)]);
var inst_25532 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25530,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_25565__$1 = state_25565;
var statearr_25589_25622 = state_25565__$1;
(statearr_25589_25622[(2)] = inst_25532);

(statearr_25589_25622[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (5))){
var _ = (function (){var statearr_25590 = state_25565;
(statearr_25590[(4)] = cljs.core.rest((state_25565[(4)])));

return statearr_25590;
})();
var state_25565__$1 = state_25565;
var ex25585 = (state_25565__$1[(2)]);
var statearr_25591_25623 = state_25565__$1;
(statearr_25591_25623[(5)] = ex25585);


if((ex25585 instanceof Error)){
var statearr_25592_25624 = state_25565__$1;
(statearr_25592_25624[(1)] = (4));

(statearr_25592_25624[(5)] = null);

} else {
throw ex25585;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (14))){
var inst_25551 = (state_25565[(9)]);
var inst_25535 = (state_25565[(19)]);
var inst_25536 = (state_25565[(7)]);
var inst_25551__$1 = (state_25565[(2)]);
var inst_25552 = fluree.db.query.analytical.q(query_map,inst_25551__$1,inst_25536,db,inst_25535);
var state_25565__$1 = (function (){var statearr_25593 = state_25565;
(statearr_25593[(9)] = inst_25551__$1);

return statearr_25593;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25565__$1,(21),inst_25552);
} else {
if((state_val_25566 === (16))){
var inst_25521 = (state_25565[(8)]);
var inst_25542 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_25521);
var state_25565__$1 = state_25565;
var statearr_25594_25625 = state_25565__$1;
(statearr_25594_25625[(2)] = inst_25542);

(statearr_25594_25625[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (10))){
var inst_25530 = (state_25565[(20)]);
var state_25565__$1 = state_25565;
var statearr_25595_25626 = state_25565__$1;
(statearr_25595_25626[(2)] = inst_25530);

(statearr_25595_25626[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (18))){
var inst_25546 = cljs.core.volatile_BANG_((0));
var state_25565__$1 = state_25565;
var statearr_25596_25627 = state_25565__$1;
(statearr_25596_25627[(2)] = inst_25546);

(statearr_25596_25627[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25566 === (8))){
var inst_25518 = (state_25565[(12)]);
var inst_25521 = (state_25565[(8)]);
var inst_25523 = (state_25565[(13)]);
var inst_25520 = (state_25565[(14)]);
var inst_25519 = (state_25565[(15)]);
var inst_25514 = (state_25565[(16)]);
var inst_25515 = (state_25565[(17)]);
var inst_25517 = (state_25565[(18)]);
var inst_25527 = (state_25565[(2)]);
var inst_25528 = [inst_25515,inst_25527,inst_25517,inst_25518,inst_25519,inst_25520];
var inst_25529 = cljs.core.PersistentHashMap.fromArrays(inst_25523,inst_25528);
var inst_25530 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_25529,inst_25521], 0));
var state_25565__$1 = (function (){var statearr_25597 = state_25565;
(statearr_25597[(20)] = inst_25530);

return statearr_25597;
})();
if(cljs.core.truth_(inst_25514)){
var statearr_25598_25628 = state_25565__$1;
(statearr_25598_25628[(1)] = (9));

} else {
var statearr_25599_25629 = state_25565__$1;
(statearr_25599_25629[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25600[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_25600[(1)] = (1));

return statearr_25600;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_25565){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25565);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25601){var ex__2730__auto__ = e25601;
var statearr_25602_25630 = state_25565;
(statearr_25602_25630[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25565[(4)]))){
var statearr_25603_25631 = state_25565;
(statearr_25603_25631[(1)] = cljs.core.first((state_25565[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25632 = state_25565;
state_25565 = G__25632;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_25565){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_25565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25604 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25604[(6)] = c__2749__auto__);

return statearr_25604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25633,p__25634){
var map__25635 = p__25633;
var map__25635__$1 = cljs.core.__destructure_map(map__25635);
var db = map__25635__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25635__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25635__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25635__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25635__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25635__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25636 = p__25634;
var map__25636__$1 = cljs.core.__destructure_map(map__25636);
var query_map = map__25636__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25636__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.cljs$core$IFn$_invoke$arity$5(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
var G__25637 = cache_key;
var G__25638 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25655 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25648){
var state_val_25649 = (state_25648[(1)]);
if((state_val_25649 === (1))){
var inst_25639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25640 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25641 = (new cljs.core.PersistentVector(null,2,(5),inst_25639,inst_25640,null));
var inst_25642 = cljs.core.assoc_in(query_map,inst_25641,false);
var inst_25643 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25642) : fluree.db.query.fql.query.call(null,db,inst_25642));
var state_25648__$1 = state_25648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25648__$1,(2),inst_25643);
} else {
if((state_val_25649 === (2))){
var inst_25645 = (state_25648[(2)]);
var inst_25646 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_25645);
var state_25648__$1 = state_25648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25648__$1,inst_25646);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25650 = [null,null,null,null,null,null,null];
(statearr_25650[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2727__auto__);

(statearr_25650[(1)] = (1));

return statearr_25650;
});
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1 = (function (state_25648){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25648);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25651){var ex__2730__auto__ = e25651;
var statearr_25652_25656 = state_25648;
(statearr_25652_25656[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25648[(4)]))){
var statearr_25653_25657 = state_25648;
(statearr_25653_25657[(1)] = cljs.core.first((state_25648[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25658 = state_25648;
state_25648 = G__25658;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = function(state_25648){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1.call(this,state_25648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25654 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25654[(6)] = c__2749__auto___25655);

return statearr_25654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__25637,G__25638) : oc.call(null,G__25637,G__25638));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25659){
var map__25660 = p__25659;
var map__25660__$1 = cljs.core.__destructure_map(map__25660);
var _query_map = map__25660__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25660__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var G__25661_25663 = "Running query:";
var G__25662_25664 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2(G__25661_25663,G__25662_25664) : fluree.db.util.log.debug.call(null,G__25661_25663,G__25662_25664));

if(fluree.db.query.fql.cache_QMARK_(query_map)){
return fluree.db.query.fql.cache_query(db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse(db,query_map);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl(db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query(db_STAR_,parsed_query,query_map);
}
}
});
