// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20134){var e = e20134;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20135_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20135_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20135_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20135_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20135_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20136_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20136_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20137_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20137_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_(key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20142 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20142,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20142,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20138_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20138_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20145 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20145,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20145,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20139_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20139_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20140_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20140_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20141_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20141_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (tuple){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20148_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__20148_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(headers,var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes(vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs(idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__20149 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20149) : intersecting_vars.call(null,G__20149));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20152,optional_QMARK_,fuel,max_fuel){
var map__20153 = p__20152;
var map__20153__$1 = cljs.core.__destructure_map(map__20153);
var res = map__20153__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20153__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20219){
var state_val_20220 = (state_20219[(1)]);
if((state_val_20220 === (7))){
var inst_20208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20209 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20210 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20209,clause);
var inst_20211 = [null,inst_20210];
var inst_20212 = (new cljs.core.PersistentVector(null,2,(5),inst_20208,inst_20211,null));
var state_20219__$1 = state_20219;
var statearr_20221_20249 = state_20219__$1;
(statearr_20221_20249[(2)] = inst_20212);

(statearr_20221_20249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (1))){
var state_20219__$1 = state_20219;
var statearr_20222_20250 = state_20219__$1;
(statearr_20222_20250[(2)] = null);

(statearr_20222_20250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (4))){
var inst_20154 = (state_20219[(2)]);
var state_20219__$1 = state_20219;
var statearr_20223_20251 = state_20219__$1;
(statearr_20223_20251[(2)] = inst_20154);

(statearr_20223_20251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (15))){
var inst_20197 = (state_20219[(2)]);
var inst_20198 = fluree.db.util.async.throw_err(inst_20197);
var inst_20199 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20198);
var inst_20200 = cljs.core.count(inst_20199);
var inst_20201 = fluree.db.query.analytical.add_fuel(inst_20200,fuel,max_fuel);
var inst_20202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20203 = [inst_20198,r];
var inst_20204 = (new cljs.core.PersistentVector(null,2,(5),inst_20202,inst_20203,null));
var state_20219__$1 = (function (){var statearr_20224 = state_20219;
(statearr_20224[(7)] = inst_20201);

return statearr_20224;
})();
var statearr_20225_20252 = state_20219__$1;
(statearr_20225_20252[(2)] = inst_20204);

(statearr_20225_20252[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (13))){
var inst_20163 = (state_20219[(8)]);
var inst_20176 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20177 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20176);
var inst_20178 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20163);
var inst_20179 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20178);
var inst_20180 = cljs.core.set(inst_20179);
var inst_20181 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20177);
var inst_20182 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20181);
var inst_20183 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20180,inst_20182);
var inst_20184 = (function (){var all_wd = inst_20163;
var optional = inst_20177;
var all_wd_vars = inst_20180;
var all_vars = inst_20183;
return (function (p1__20150_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20150_SHARP_) : all_vars.call(null,p1__20150_SHARP_));
});
})();
var inst_20185 = cljs.core.keys(vars);
var inst_20186 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20184,inst_20185);
var inst_20187 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20186);
var inst_20188 = cljs.core.set(inst_20187);
var inst_20189 = (function (){var all_wd = inst_20163;
var optional = inst_20177;
var all_wd_vars = inst_20180;
var all_vars = inst_20183;
var intersecting_vars = inst_20188;
return (function (p1__20151_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20151_SHARP_);
});
})();
var inst_20190 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20189,inst_20163);
var inst_20191 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20190);
var inst_20192 = fluree.db.query.analytical.select_from_tuples(inst_20191,res);
var inst_20193 = fluree.db.query.analytical.replace_vars_wikidata(inst_20163,inst_20188,vars);
var inst_20194 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20188,inst_20183);
var inst_20195 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20193,inst_20191,inst_20192,inst_20194,inst_20177);
var state_20219__$1 = state_20219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20219__$1,(15),inst_20195);
} else {
if((state_val_20220 === (6))){
var inst_20164 = (state_20219[(9)]);
var inst_20162 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20163 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20162);
var inst_20164__$1 = optional_QMARK_;
var state_20219__$1 = (function (){var statearr_20226 = state_20219;
(statearr_20226[(9)] = inst_20164__$1);

(statearr_20226[(8)] = inst_20163);

return statearr_20226;
})();
if(cljs.core.truth_(inst_20164__$1)){
var statearr_20227_20253 = state_20219__$1;
(statearr_20227_20253[(1)] = (9));

} else {
var statearr_20228_20254 = state_20219__$1;
(statearr_20228_20254[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (3))){
var inst_20217 = (state_20219[(2)]);
var state_20219__$1 = state_20219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20219__$1,inst_20217);
} else {
if((state_val_20220 === (12))){
var inst_20172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20173 = [null,r];
var inst_20174 = (new cljs.core.PersistentVector(null,2,(5),inst_20172,inst_20173,null));
var state_20219__$1 = state_20219;
var statearr_20229_20255 = state_20219__$1;
(statearr_20229_20255[(2)] = inst_20174);

(statearr_20229_20255[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (2))){
var _ = (function (){var statearr_20230 = state_20219;
(statearr_20230[(4)] = cljs.core.cons((5),(state_20219[(4)])));

return statearr_20230;
})();
var inst_20160 = (r == null);
var state_20219__$1 = state_20219;
if(cljs.core.truth_(inst_20160)){
var statearr_20231_20256 = state_20219__$1;
(statearr_20231_20256[(1)] = (6));

} else {
var statearr_20232_20257 = state_20219__$1;
(statearr_20232_20257[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (11))){
var inst_20170 = (state_20219[(2)]);
var state_20219__$1 = state_20219;
if(cljs.core.truth_(inst_20170)){
var statearr_20234_20258 = state_20219__$1;
(statearr_20234_20258[(1)] = (12));

} else {
var statearr_20235_20259 = state_20219__$1;
(statearr_20235_20259[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (9))){
var inst_20163 = (state_20219[(8)]);
var inst_20166 = cljs.core.empty_QMARK_(inst_20163);
var inst_20167 = (!(inst_20166));
var state_20219__$1 = state_20219;
var statearr_20236_20260 = state_20219__$1;
(statearr_20236_20260[(2)] = inst_20167);

(statearr_20236_20260[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (5))){
var _ = (function (){var statearr_20237 = state_20219;
(statearr_20237[(4)] = cljs.core.rest((state_20219[(4)])));

return statearr_20237;
})();
var state_20219__$1 = state_20219;
var ex20233 = (state_20219__$1[(2)]);
var statearr_20238_20261 = state_20219__$1;
(statearr_20238_20261[(5)] = ex20233);


if((ex20233 instanceof Error)){
var statearr_20239_20262 = state_20219__$1;
(statearr_20239_20262[(1)] = (4));

(statearr_20239_20262[(5)] = null);

} else {
throw ex20233;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (14))){
var inst_20206 = (state_20219[(2)]);
var state_20219__$1 = state_20219;
var statearr_20240_20263 = state_20219__$1;
(statearr_20240_20263[(2)] = inst_20206);

(statearr_20240_20263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (10))){
var inst_20164 = (state_20219[(9)]);
var state_20219__$1 = state_20219;
var statearr_20241_20264 = state_20219__$1;
(statearr_20241_20264[(2)] = inst_20164);

(statearr_20241_20264[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20220 === (8))){
var inst_20214 = (state_20219[(2)]);
var _ = (function (){var statearr_20242 = state_20219;
(statearr_20242[(4)] = cljs.core.rest((state_20219[(4)])));

return statearr_20242;
})();
var state_20219__$1 = state_20219;
var statearr_20243_20265 = state_20219__$1;
(statearr_20243_20265[(2)] = inst_20214);

(statearr_20243_20265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20244 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20244[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__);

(statearr_20244[(1)] = (1));

return statearr_20244;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20219){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20219);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20245){var ex__2730__auto__ = e20245;
var statearr_20246_20266 = state_20219;
(statearr_20246_20266[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20219[(4)]))){
var statearr_20247_20267 = state_20219;
(statearr_20247_20267[(1)] = cljs.core.first((state_20219[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20268 = state_20219;
state_20219 = G__20268;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = function(state_20219){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20248 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20248[(6)] = c__2749__auto__);

return statearr_20248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find(/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find(/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20270 = arguments.length;
switch (G__20270) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20364){
var state_val_20365 = (state_20364[(1)]);
if((state_val_20365 === (7))){
var inst_20277 = (state_20364[(7)]);
var inst_20287 = clojure.string.starts_with_QMARK_(inst_20277,"$fdb");
var state_20364__$1 = state_20364;
if(inst_20287){
var statearr_20366_20415 = state_20364__$1;
(statearr_20366_20415[(1)] = (9));

} else {
var statearr_20367_20416 = state_20364__$1;
(statearr_20367_20416[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (20))){
var state_20364__$1 = state_20364;
var statearr_20368_20417 = state_20364__$1;
(statearr_20368_20417[(2)] = null);

(statearr_20368_20417[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (27))){
var inst_20327 = (state_20364[(8)]);
var state_20364__$1 = state_20364;
var statearr_20369_20418 = state_20364__$1;
(statearr_20369_20418[(2)] = inst_20327);

(statearr_20369_20418[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (1))){
var state_20364__$1 = state_20364;
var statearr_20370_20419 = state_20364__$1;
(statearr_20370_20419[(2)] = null);

(statearr_20370_20419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (24))){
var inst_20350 = (state_20364[(2)]);
var state_20364__$1 = state_20364;
var statearr_20371_20420 = state_20364__$1;
(statearr_20371_20420[(2)] = inst_20350);

(statearr_20371_20420[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (4))){
var inst_20271 = (state_20364[(2)]);
var state_20364__$1 = state_20364;
var statearr_20372_20421 = state_20364__$1;
(statearr_20372_20421[(2)] = inst_20271);

(statearr_20372_20421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (15))){
var inst_20294 = (state_20364[(9)]);
var inst_20300 = (state_20364[(2)]);
var inst_20301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20302 = cljs.core.PersistentVector.EMPTY;
var inst_20303 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20304 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20302,inst_20303);
var inst_20305 = [inst_20294,inst_20304];
var inst_20306 = (new cljs.core.PersistentVector(null,2,(5),inst_20301,inst_20305,null));
var state_20364__$1 = (function (){var statearr_20373 = state_20364;
(statearr_20373[(10)] = inst_20300);

return statearr_20373;
})();
var statearr_20374_20422 = state_20364__$1;
(statearr_20374_20422[(2)] = inst_20306);

(statearr_20374_20422[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (21))){
var inst_20353 = (state_20364[(2)]);
var state_20364__$1 = state_20364;
var statearr_20375_20423 = state_20364__$1;
(statearr_20375_20423[(2)] = inst_20353);

(statearr_20375_20423[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (13))){
var inst_20294 = (state_20364[(9)]);
var inst_20297 = (function(){throw inst_20294})();
var state_20364__$1 = state_20364;
var statearr_20376_20424 = state_20364__$1;
(statearr_20376_20424[(2)] = inst_20297);

(statearr_20376_20424[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (22))){
var inst_20318 = (state_20364[(11)]);
var inst_20316 = (state_20364[(12)]);
var inst_20320 = fluree.db.query.analytical.parse_block_from_source(inst_20316);
var inst_20321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20322 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20318];
var inst_20323 = (new cljs.core.PersistentVector(null,2,(5),inst_20321,inst_20322,null));
var inst_20324 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20323);
var state_20364__$1 = (function (){var statearr_20377 = state_20364;
(statearr_20377[(13)] = inst_20320);

return statearr_20377;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20364__$1,(25),inst_20324);
} else {
if((state_val_20365 === (29))){
var inst_20331 = (state_20364[(2)]);
var inst_20332 = fluree.db.util.async.throw_err(inst_20331);
var state_20364__$1 = state_20364;
var statearr_20378_20425 = state_20364__$1;
(statearr_20378_20425[(2)] = inst_20332);

(statearr_20378_20425[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (6))){
var inst_20280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20281 = cljs.core.PersistentVector.EMPTY;
var inst_20282 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20283 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20281,inst_20282);
var inst_20284 = [db,inst_20283];
var inst_20285 = (new cljs.core.PersistentVector(null,2,(5),inst_20280,inst_20284,null));
var state_20364__$1 = state_20364;
var statearr_20379_20426 = state_20364__$1;
(statearr_20379_20426[(2)] = inst_20285);

(statearr_20379_20426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (28))){
var inst_20335 = (state_20364[(2)]);
var inst_20336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20337 = cljs.core.PersistentVector.EMPTY;
var inst_20338 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20339 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20337,inst_20338);
var inst_20340 = [inst_20335,inst_20339];
var inst_20341 = (new cljs.core.PersistentVector(null,2,(5),inst_20336,inst_20340,null));
var state_20364__$1 = state_20364;
var statearr_20380_20427 = state_20364__$1;
(statearr_20380_20427[(2)] = inst_20341);

(statearr_20380_20427[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (25))){
var inst_20320 = (state_20364[(13)]);
var inst_20326 = (state_20364[(2)]);
var inst_20327 = fluree.db.util.async.throw_err(inst_20326);
var state_20364__$1 = (function (){var statearr_20381 = state_20364;
(statearr_20381[(8)] = inst_20327);

return statearr_20381;
})();
if(cljs.core.truth_(inst_20320)){
var statearr_20382_20428 = state_20364__$1;
(statearr_20382_20428[(1)] = (26));

} else {
var statearr_20383_20429 = state_20364__$1;
(statearr_20383_20429[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (17))){
var state_20364__$1 = state_20364;
var statearr_20384_20430 = state_20364__$1;
(statearr_20384_20430[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (3))){
var inst_20362 = (state_20364[(2)]);
var state_20364__$1 = state_20364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20364__$1,inst_20362);
} else {
if((state_val_20365 === (12))){
var inst_20294 = (state_20364[(9)]);
var inst_20293 = (state_20364[(2)]);
var inst_20294__$1 = fluree.db.util.async.throw_err(inst_20293);
var inst_20295 = fluree.db.util.core.exception_QMARK_(inst_20294__$1);
var state_20364__$1 = (function (){var statearr_20386 = state_20364;
(statearr_20386[(9)] = inst_20294__$1);

return statearr_20386;
})();
if(inst_20295){
var statearr_20387_20431 = state_20364__$1;
(statearr_20387_20431[(1)] = (13));

} else {
var statearr_20388_20432 = state_20364__$1;
(statearr_20388_20432[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (2))){
var inst_20277 = (state_20364[(7)]);
var _ = (function (){var statearr_20389 = state_20364;
(statearr_20389[(4)] = cljs.core.cons((5),(state_20364[(4)])));

return statearr_20389;
})();
var inst_20277__$1 = cljs.core.first(clause);
var inst_20278 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20277__$1);
var state_20364__$1 = (function (){var statearr_20390 = state_20364;
(statearr_20390[(7)] = inst_20277__$1);

return statearr_20390;
})();
if(inst_20278){
var statearr_20391_20433 = state_20364__$1;
(statearr_20391_20433[(1)] = (6));

} else {
var statearr_20392_20434 = state_20364__$1;
(statearr_20392_20434[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (23))){
var inst_20277 = (state_20364[(7)]);
var inst_20343 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20277)," is not supported in Fluree"].join('');
var inst_20344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20345 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20346 = cljs.core.PersistentHashMap.fromArrays(inst_20344,inst_20345);
var inst_20347 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20343,inst_20346);
var inst_20348 = (function(){throw inst_20347})();
var state_20364__$1 = state_20364;
var statearr_20393_20435 = state_20364__$1;
(statearr_20393_20435[(2)] = inst_20348);

(statearr_20393_20435[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (19))){
var inst_20318 = (state_20364[(11)]);
var inst_20277 = (state_20364[(7)]);
var inst_20315 = fluree.db.query.analytical.isolate_source_name(inst_20277);
var inst_20316 = fluree.db.query.analytical.isolate_source_block(inst_20277);
var inst_20317 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20315);
var inst_20318__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20317);
var state_20364__$1 = (function (){var statearr_20394 = state_20364;
(statearr_20394[(11)] = inst_20318__$1);

(statearr_20394[(12)] = inst_20316);

return statearr_20394;
})();
if(cljs.core.truth_(inst_20318__$1)){
var statearr_20395_20436 = state_20364__$1;
(statearr_20395_20436[(1)] = (22));

} else {
var statearr_20396_20437 = state_20364__$1;
(statearr_20396_20437[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (11))){
var inst_20357 = (state_20364[(2)]);
var state_20364__$1 = state_20364;
var statearr_20398_20438 = state_20364__$1;
(statearr_20398_20438[(2)] = inst_20357);

(statearr_20398_20438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (9))){
var inst_20277 = (state_20364[(7)]);
var inst_20289 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20277,(4));
var inst_20290 = fluree.db.query.analytical.parse_block_from_source(inst_20289);
var inst_20291 = fluree.db.time_travel.as_of_block(db,inst_20290);
var state_20364__$1 = state_20364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20364__$1,(12),inst_20291);
} else {
if((state_val_20365 === (5))){
var _ = (function (){var statearr_20399 = state_20364;
(statearr_20399[(4)] = cljs.core.rest((state_20364[(4)])));

return statearr_20399;
})();
var state_20364__$1 = state_20364;
var ex20397 = (state_20364__$1[(2)]);
var statearr_20400_20439 = state_20364__$1;
(statearr_20400_20439[(5)] = ex20397);


if((ex20397 instanceof Error)){
var statearr_20401_20440 = state_20364__$1;
(statearr_20401_20440[(1)] = (4));

(statearr_20401_20440[(5)] = null);

} else {
throw ex20397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (14))){
var state_20364__$1 = state_20364;
var statearr_20402_20441 = state_20364__$1;
(statearr_20402_20441[(2)] = null);

(statearr_20402_20441[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (26))){
var inst_20320 = (state_20364[(13)]);
var inst_20327 = (state_20364[(8)]);
var inst_20329 = fluree.db.time_travel.as_of_block(inst_20327,inst_20320);
var state_20364__$1 = state_20364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20364__$1,(29),inst_20329);
} else {
if((state_val_20365 === (16))){
var inst_20310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20311 = ["$wd",clause];
var inst_20312 = (new cljs.core.PersistentVector(null,2,(5),inst_20310,inst_20311,null));
var state_20364__$1 = state_20364;
var statearr_20403_20442 = state_20364__$1;
(statearr_20403_20442[(2)] = inst_20312);

(statearr_20403_20442[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (10))){
var inst_20277 = (state_20364[(7)]);
var inst_20308 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20277);
var state_20364__$1 = state_20364;
if(inst_20308){
var statearr_20404_20443 = state_20364__$1;
(statearr_20404_20443[(1)] = (16));

} else {
var statearr_20405_20444 = state_20364__$1;
(statearr_20405_20444[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (18))){
var inst_20355 = (state_20364[(2)]);
var state_20364__$1 = state_20364;
var statearr_20406_20445 = state_20364__$1;
(statearr_20406_20445[(2)] = inst_20355);

(statearr_20406_20445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20365 === (8))){
var inst_20359 = (state_20364[(2)]);
var _ = (function (){var statearr_20407 = state_20364;
(statearr_20407[(4)] = cljs.core.rest((state_20364[(4)])));

return statearr_20407;
})();
var state_20364__$1 = state_20364;
var statearr_20408_20446 = state_20364__$1;
(statearr_20408_20446[(2)] = inst_20359);

(statearr_20408_20446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_20409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20409[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_20409[(1)] = (1));

return statearr_20409;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_20364){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20364);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20410){var ex__2730__auto__ = e20410;
var statearr_20411_20447 = state_20364;
(statearr_20411_20447[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20364[(4)]))){
var statearr_20412_20448 = state_20364;
(statearr_20412_20448[(1)] = cljs.core.first((state_20364[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20449 = state_20364;
state_20364 = G__20449;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_20364){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_20364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20413 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20413[(6)] = c__2749__auto__);

return statearr_20413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20450){
var vec__20451 = p__20450;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20451,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20451,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20454_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20454_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20458 = subjects;
var vec__20459 = G__20458;
var seq__20460 = cljs.core.seq(vec__20459);
var first__20461 = cljs.core.first(seq__20460);
var seq__20460__$1 = cljs.core.next(seq__20460);
var subject = first__20461;
var r = seq__20460__$1;
var acc = expanded_map;
var G__20458__$1 = G__20458;
var acc__$1 = acc;
while(true){
var vec__20465 = G__20458__$1;
var seq__20466 = cljs.core.seq(vec__20465);
var first__20467 = cljs.core.first(seq__20466);
var seq__20466__$1 = cljs.core.next(seq__20466);
var subject__$1 = first__20467;
var r__$1 = seq__20466__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20468 = r__$1;
var G__20469 = acc__$2;
G__20458__$1 = G__20468;
acc__$1 = G__20469;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20458__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20465,seq__20466,first__20467,seq__20466__$1,subject__$1,r__$1,acc__$2,G__20458,vec__20459,seq__20460,first__20461,seq__20460__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20458__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20465,seq__20466,first__20467,seq__20466__$1,subject__$1,r__$1,acc__$2,G__20458,vec__20459,seq__20460,first__20461,seq__20460__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20458__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20465,seq__20466,first__20467,seq__20466__$1,subject__$1,r__$1,acc__$2,G__20458,vec__20459,seq__20460,first__20461,seq__20460__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20458__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20465,seq__20466,first__20467,seq__20466__$1,subject__$1,r__$1,acc__$2,G__20458,vec__20459,seq__20460,first__20461,seq__20460__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20458__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20465,seq__20466,first__20467,seq__20466__$1,subject__$1,r__$1,acc__$2,G__20458,vec__20459,seq__20460,first__20461,seq__20460__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20458__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20465,seq__20466,first__20467,seq__20466__$1,subject__$1,r__$1,acc__$2,G__20458,vec__20459,seq__20460,first__20461,seq__20460__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20470 = r__$1;
var G__20471 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20458__$1 = G__20470;
acc__$1 = G__20471;
continue;
} else {
var G__20472 = subjects;
var G__20473 = acc_STAR_;
G__20458__$1 = G__20472;
acc__$1 = G__20473;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20474_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20474_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20565){
var state_val_20566 = (state_20565[(1)]);
if((state_val_20566 === (7))){
var state_20565__$1 = state_20565;
var statearr_20567_20613 = state_20565__$1;
(statearr_20567_20613[(2)] = (100));

(statearr_20567_20613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (20))){
var inst_20514 = (state_20565[(7)]);
var state_20565__$1 = state_20565;
var statearr_20568_20614 = state_20565__$1;
(statearr_20568_20614[(2)] = inst_20514);

(statearr_20568_20614[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (1))){
var state_20565__$1 = state_20565;
var statearr_20569_20615 = state_20565__$1;
(statearr_20569_20615[(2)] = null);

(statearr_20569_20615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (24))){
var inst_20553 = (state_20565[(8)]);
var inst_20552 = (state_20565[(9)]);
var inst_20486 = (state_20565[(10)]);
var inst_20551 = (state_20565[(11)]);
var inst_20556 = (function (){var max_depth = inst_20486;
var recur_map__$1 = inst_20552;
var subjects = inst_20551;
var tuples = inst_20553;
return (function (p1__20475_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20475_SHARP_)],null));
});
})();
var inst_20557 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20556,inst_20553);
var inst_20558 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20557);
var state_20565__$1 = state_20565;
var statearr_20570_20616 = state_20565__$1;
(statearr_20570_20616[(2)] = inst_20558);

(statearr_20570_20616[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (4))){
var inst_20476 = (state_20565[(2)]);
var state_20565__$1 = state_20565;
var statearr_20571_20617 = state_20565__$1;
(statearr_20571_20617[(2)] = inst_20476);

(statearr_20571_20617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (15))){
var inst_20499 = (state_20565[(12)]);
var inst_20510 = cljs.core.PersistentVector.EMPTY;
var inst_20511 = cljs.core.seq(inst_20499);
var inst_20512 = cljs.core.first(inst_20511);
var inst_20513 = cljs.core.next(inst_20511);
var inst_20514 = inst_20510;
var inst_20515 = inst_20499;
var state_20565__$1 = (function (){var statearr_20572 = state_20565;
(statearr_20572[(7)] = inst_20514);

(statearr_20572[(13)] = inst_20513);

(statearr_20572[(14)] = inst_20515);

(statearr_20572[(15)] = inst_20512);

return statearr_20572;
})();
var statearr_20573_20618 = state_20565__$1;
(statearr_20573_20618[(2)] = null);

(statearr_20573_20618[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (21))){
var inst_20535 = (state_20565[(2)]);
var state_20565__$1 = state_20565;
var statearr_20574_20619 = state_20565__$1;
(statearr_20574_20619[(2)] = inst_20535);

(statearr_20574_20619[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (13))){
var inst_20548 = (state_20565[(2)]);
var state_20565__$1 = state_20565;
var statearr_20575_20620 = state_20565__$1;
(statearr_20575_20620[(2)] = inst_20548);

(statearr_20575_20620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (22))){
var inst_20514 = (state_20565[(7)]);
var inst_20522 = (state_20565[(16)]);
var inst_20529 = (state_20565[(2)]);
var inst_20530 = fluree.db.util.async.throw_err(inst_20529);
var inst_20531 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20514,inst_20530);
var inst_20514__$1 = inst_20531;
var inst_20515 = inst_20522;
var state_20565__$1 = (function (){var statearr_20576 = state_20565;
(statearr_20576[(7)] = inst_20514__$1);

(statearr_20576[(14)] = inst_20515);

return statearr_20576;
})();
var statearr_20577_20621 = state_20565__$1;
(statearr_20577_20621[(2)] = null);

(statearr_20577_20621[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (6))){
var inst_20482 = (state_20565[(17)]);
var state_20565__$1 = state_20565;
var statearr_20578_20622 = state_20565__$1;
(statearr_20578_20622[(2)] = inst_20482);

(statearr_20578_20622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (25))){
var inst_20560 = (state_20565[(2)]);
var _ = (function (){var statearr_20579 = state_20565;
(statearr_20579[(4)] = cljs.core.rest((state_20565[(4)])));

return statearr_20579;
})();
var state_20565__$1 = state_20565;
var statearr_20580_20623 = state_20565__$1;
(statearr_20580_20623[(2)] = inst_20560);

(statearr_20580_20623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (17))){
var inst_20515 = (state_20565[(14)]);
var inst_20521 = (state_20565[(18)]);
var inst_20520 = cljs.core.seq(inst_20515);
var inst_20521__$1 = cljs.core.first(inst_20520);
var inst_20522 = cljs.core.next(inst_20520);
var state_20565__$1 = (function (){var statearr_20581 = state_20565;
(statearr_20581[(16)] = inst_20522);

(statearr_20581[(18)] = inst_20521__$1);

return statearr_20581;
})();
if(cljs.core.truth_(inst_20521__$1)){
var statearr_20582_20624 = state_20565__$1;
(statearr_20582_20624[(1)] = (19));

} else {
var statearr_20583_20625 = state_20565__$1;
(statearr_20583_20625[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (3))){
var inst_20563 = (state_20565[(2)]);
var state_20565__$1 = state_20565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20565__$1,inst_20563);
} else {
if((state_val_20566 === (12))){
var inst_20499 = (state_20565[(12)]);
var inst_20488 = (state_20565[(19)]);
var inst_20494 = cljs.core.vals(inst_20488);
var inst_20495 = cljs.core.flatten(inst_20494);
var inst_20496 = cljs.core.set(inst_20495);
var inst_20497 = cljs.core.keys(inst_20488);
var inst_20498 = cljs.core.set(inst_20497);
var inst_20499__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20496,inst_20498);
var inst_20500 = cljs.core.empty_QMARK_(inst_20499__$1);
var state_20565__$1 = (function (){var statearr_20584 = state_20565;
(statearr_20584[(12)] = inst_20499__$1);

return statearr_20584;
})();
if(inst_20500){
var statearr_20585_20626 = state_20565__$1;
(statearr_20585_20626[(1)] = (14));

} else {
var statearr_20586_20627 = state_20565__$1;
(statearr_20586_20627[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (2))){
var inst_20482 = (state_20565[(17)]);
var _ = (function (){var statearr_20587 = state_20565;
(statearr_20587[(4)] = cljs.core.cons((5),(state_20565[(4)])));

return statearr_20587;
})();
var inst_20482__$1 = depth;
var state_20565__$1 = (function (){var statearr_20588 = state_20565;
(statearr_20588[(17)] = inst_20482__$1);

return statearr_20588;
})();
if(cljs.core.truth_(inst_20482__$1)){
var statearr_20589_20628 = state_20565__$1;
(statearr_20589_20628[(1)] = (6));

} else {
var statearr_20590_20629 = state_20565__$1;
(statearr_20590_20629[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (23))){
var inst_20553 = (state_20565[(8)]);
var state_20565__$1 = state_20565;
var statearr_20591_20630 = state_20565__$1;
(statearr_20591_20630[(2)] = inst_20553);

(statearr_20591_20630[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (19))){
var inst_20521 = (state_20565[(18)]);
var inst_20524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20525 = [inst_20521,predicate];
var inst_20526 = (new cljs.core.PersistentVector(null,2,(5),inst_20524,inst_20525,null));
var inst_20527 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20526);
var state_20565__$1 = state_20565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20565__$1,(22),inst_20527);
} else {
if((state_val_20566 === (11))){
var inst_20488 = (state_20565[(19)]);
var state_20565__$1 = state_20565;
var statearr_20593_20631 = state_20565__$1;
(statearr_20593_20631[(2)] = inst_20488);

(statearr_20593_20631[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (9))){
var inst_20486 = (state_20565[(10)]);
var inst_20489 = (state_20565[(20)]);
var inst_20491 = (inst_20489 >= inst_20486);
var state_20565__$1 = state_20565;
if(cljs.core.truth_(inst_20491)){
var statearr_20594_20632 = state_20565__$1;
(statearr_20594_20632[(1)] = (11));

} else {
var statearr_20595_20633 = state_20565__$1;
(statearr_20595_20633[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (5))){
var _ = (function (){var statearr_20596 = state_20565;
(statearr_20596[(4)] = cljs.core.rest((state_20565[(4)])));

return statearr_20596;
})();
var state_20565__$1 = state_20565;
var ex20592 = (state_20565__$1[(2)]);
var statearr_20597_20634 = state_20565__$1;
(statearr_20597_20634[(5)] = ex20592);


if((ex20592 instanceof Error)){
var statearr_20598_20635 = state_20565__$1;
(statearr_20598_20635[(1)] = (4));

(statearr_20598_20635[(5)] = null);

} else {
throw ex20592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (14))){
var inst_20488 = (state_20565[(19)]);
var state_20565__$1 = state_20565;
var statearr_20599_20636 = state_20565__$1;
(statearr_20599_20636[(2)] = inst_20488);

(statearr_20599_20636[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (16))){
var inst_20546 = (state_20565[(2)]);
var state_20565__$1 = state_20565;
var statearr_20600_20637 = state_20565__$1;
(statearr_20600_20637[(2)] = inst_20546);

(statearr_20600_20637[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (10))){
var inst_20552 = (state_20565[(9)]);
var inst_20551 = (state_20565[(11)]);
var inst_20550 = (state_20565[(2)]);
var inst_20551__$1 = cljs.core.keys(inst_20550);
var inst_20552__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20551__$1,inst_20550);
var inst_20553 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20551__$1,inst_20552__$1);
var state_20565__$1 = (function (){var statearr_20601 = state_20565;
(statearr_20601[(8)] = inst_20553);

(statearr_20601[(9)] = inst_20552__$1);

(statearr_20601[(11)] = inst_20551__$1);

return statearr_20601;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20602_20638 = state_20565__$1;
(statearr_20602_20638[(1)] = (23));

} else {
var statearr_20603_20639 = state_20565__$1;
(statearr_20603_20639[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (18))){
var inst_20488 = (state_20565[(19)]);
var inst_20489 = (state_20565[(20)]);
var inst_20537 = (state_20565[(2)]);
var inst_20538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20539 = [(0),(2)];
var inst_20540 = (new cljs.core.PersistentVector(null,2,(5),inst_20538,inst_20539,null));
var inst_20541 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_20540,inst_20537);
var inst_20542 = fluree.db.query.analytical.tuples__GT_map(inst_20488,inst_20541);
var inst_20543 = (inst_20489 + (1));
var inst_20488__$1 = inst_20542;
var inst_20489__$1 = inst_20543;
var state_20565__$1 = (function (){var statearr_20604 = state_20565;
(statearr_20604[(19)] = inst_20488__$1);

(statearr_20604[(20)] = inst_20489__$1);

return statearr_20604;
})();
var statearr_20605_20640 = state_20565__$1;
(statearr_20605_20640[(2)] = null);

(statearr_20605_20640[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20566 === (8))){
var inst_20486 = (state_20565[(2)]);
var inst_20487 = recur_map;
var inst_20488 = inst_20487;
var inst_20489 = (1);
var state_20565__$1 = (function (){var statearr_20606 = state_20565;
(statearr_20606[(19)] = inst_20488);

(statearr_20606[(10)] = inst_20486);

(statearr_20606[(20)] = inst_20489);

return statearr_20606;
})();
var statearr_20607_20641 = state_20565__$1;
(statearr_20607_20641[(2)] = null);

(statearr_20607_20641[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_20608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20608[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__);

(statearr_20608[(1)] = (1));

return statearr_20608;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1 = (function (state_20565){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20565);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20609){var ex__2730__auto__ = e20609;
var statearr_20610_20642 = state_20565;
(statearr_20610_20642[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20565[(4)]))){
var statearr_20611_20643 = state_20565;
(statearr_20611_20643[(1)] = cljs.core.first((state_20565[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20644 = state_20565;
state_20565 = G__20644;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = function(state_20565){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1.call(this,state_20565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20612 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20612[(6)] = c__2749__auto__);

return statearr_20612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20645,clause,fuel,max_fuel){
var map__20646 = p__20645;
var map__20646__$1 = cljs.core.__destructure_map(map__20646);
var res = map__20646__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20646__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20646__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20646__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20757){
var state_val_20758 = (state_20757[(1)]);
if((state_val_20758 === (7))){
var inst_20663 = (state_20757[(7)]);
var state_20757__$1 = state_20757;
var statearr_20759_20812 = state_20757__$1;
(statearr_20759_20812[(2)] = inst_20663);

(statearr_20759_20812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (20))){
var inst_20691 = (state_20757[(8)]);
var inst_20722 = typeof inst_20691 === 'number';
var state_20757__$1 = state_20757;
if(cljs.core.truth_(inst_20722)){
var statearr_20760_20813 = state_20757__$1;
(statearr_20760_20813[(1)] = (22));

} else {
var statearr_20761_20814 = state_20757__$1;
(statearr_20761_20814[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (27))){
var inst_20737 = (state_20757[(2)]);
var state_20757__$1 = state_20757;
var statearr_20762_20815 = state_20757__$1;
(statearr_20762_20815[(2)] = inst_20737);

(statearr_20762_20815[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (1))){
var state_20757__$1 = state_20757;
var statearr_20763_20816 = state_20757__$1;
(statearr_20763_20816[(2)] = null);

(statearr_20763_20816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (24))){
var inst_20739 = (state_20757[(2)]);
var state_20757__$1 = state_20757;
var statearr_20764_20817 = state_20757__$1;
(statearr_20764_20817[(2)] = inst_20739);

(statearr_20764_20817[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (4))){
var inst_20647 = (state_20757[(2)]);
var state_20757__$1 = state_20757;
var statearr_20765_20818 = state_20757__$1;
(statearr_20765_20818[(2)] = inst_20647);

(statearr_20765_20818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (15))){
var inst_20705 = (state_20757[(2)]);
var inst_20706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20707 = fluree.db.query.analytical.variable_QMARK_(inst_20706);
var state_20757__$1 = (function (){var statearr_20766 = state_20757;
(statearr_20766[(9)] = inst_20705);

return statearr_20766;
})();
if(cljs.core.truth_(inst_20707)){
var statearr_20767_20819 = state_20757__$1;
(statearr_20767_20819[(1)] = (16));

} else {
var statearr_20768_20820 = state_20757__$1;
(statearr_20768_20820[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (21))){
var inst_20693 = (state_20757[(10)]);
var inst_20664 = (state_20757[(11)]);
var inst_20694 = (state_20757[(12)]);
var inst_20741 = (state_20757[(2)]);
var inst_20742 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20694,inst_20741,inst_20664,inst_20693);
var state_20757__$1 = state_20757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20757__$1,(28),inst_20742);
} else {
if((state_val_20758 === (13))){
var inst_20673 = (state_20757[(13)]);
var inst_20697 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20673)].join('');
var inst_20698 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20699 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20700 = cljs.core.PersistentHashMap.fromArrays(inst_20698,inst_20699);
var inst_20701 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20697,inst_20700);
var inst_20702 = (function(){throw inst_20701})();
var state_20757__$1 = state_20757;
var statearr_20769_20821 = state_20757__$1;
(statearr_20769_20821[(2)] = inst_20702);

(statearr_20769_20821[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (22))){
var inst_20689 = (state_20757[(14)]);
var inst_20691 = (state_20757[(8)]);
var inst_20724 = cljs.core.PersistentHashMap.EMPTY;
var inst_20725 = cljs.core.flatten(inst_20689);
var inst_20726 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20724,inst_20691,inst_20725);
var state_20757__$1 = state_20757;
var statearr_20770_20822 = state_20757__$1;
(statearr_20770_20822[(2)] = inst_20726);

(statearr_20770_20822[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (6))){
var inst_20675 = (state_20757[(15)]);
var state_20757__$1 = state_20757;
var statearr_20771_20823 = state_20757__$1;
(statearr_20771_20823[(2)] = inst_20675);

(statearr_20771_20823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (28))){
var inst_20744 = (state_20757[(2)]);
var inst_20745 = fluree.db.util.async.throw_err(inst_20744);
var state_20757__$1 = state_20757;
var statearr_20772_20824 = state_20757__$1;
(statearr_20772_20824[(2)] = inst_20745);

(statearr_20772_20824[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (25))){
var inst_20689 = (state_20757[(14)]);
var inst_20685 = (state_20757[(16)]);
var inst_20730 = cljs.core.PersistentHashMap.EMPTY;
var inst_20731 = cljs.core.first(inst_20685);
var inst_20732 = cljs.core.first(inst_20731);
var inst_20733 = cljs.core.flatten(inst_20689);
var inst_20734 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20730,inst_20732,inst_20733);
var state_20757__$1 = state_20757;
var statearr_20773_20825 = state_20757__$1;
(statearr_20773_20825[(2)] = inst_20734);

(statearr_20773_20825[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (17))){
var inst_20673 = (state_20757[(13)]);
var inst_20710 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20673)].join('');
var inst_20711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20712 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20713 = cljs.core.PersistentHashMap.fromArrays(inst_20711,inst_20712);
var inst_20714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20710,inst_20713);
var inst_20715 = (function(){throw inst_20714})();
var state_20757__$1 = state_20757;
var statearr_20774_20826 = state_20757__$1;
(statearr_20774_20826[(2)] = inst_20715);

(statearr_20774_20826[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (3))){
var inst_20755 = (state_20757[(2)]);
var state_20757__$1 = state_20757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20757__$1,inst_20755);
} else {
if((state_val_20758 === (12))){
var inst_20660 = (state_20757[(17)]);
var inst_20748 = (state_20757[(2)]);
var inst_20749 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20750 = cljs.core.keys(inst_20660);
var inst_20751 = [inst_20750,vars,inst_20748];
var inst_20752 = cljs.core.PersistentHashMap.fromArrays(inst_20749,inst_20751);
var _ = (function (){var statearr_20775 = state_20757;
(statearr_20775[(4)] = cljs.core.rest((state_20757[(4)])));

return statearr_20775;
})();
var state_20757__$1 = state_20757;
var statearr_20776_20827 = state_20757__$1;
(statearr_20776_20827[(2)] = inst_20752);

(statearr_20776_20827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (2))){
var inst_20660 = (state_20757[(17)]);
var inst_20664 = (state_20757[(11)]);
var inst_20675 = (state_20757[(15)]);
var inst_20663 = (state_20757[(7)]);
var _ = (function (){var statearr_20777 = state_20757;
(statearr_20777[(4)] = cljs.core.cons((5),(state_20757[(4)])));

return statearr_20777;
})();
var inst_20657 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20658 = cljs.core.__destructure_map(inst_20657);
var inst_20659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20658,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20660__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20658,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20658,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20662 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20663__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20661);
var inst_20664__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20661);
var inst_20666 = (function (){var map__20653 = inst_20658;
var search = inst_20659;
var rel = inst_20660__$1;
var opts = inst_20661;
var common_keys = inst_20662;
var object_fn = inst_20663__$1;
var recur_depth = inst_20664__$1;
return (function (p__20665,common_key){
var vec__20778 = p__20665;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20778,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20778,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20781 = cljs.core._EQ_;
var expr__20782 = idx_of;
if(cljs.core.truth_((pred__20781.cljs$core$IFn$_invoke$arity$2 ? pred__20781.cljs$core$IFn$_invoke$arity$2((0),expr__20782) : pred__20781.call(null,(0),expr__20782)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20781.cljs$core$IFn$_invoke$arity$2 ? pred__20781.cljs$core$IFn$_invoke$arity$2((1),expr__20782) : pred__20781.call(null,(1),expr__20782)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20781.cljs$core$IFn$_invoke$arity$2 ? pred__20781.cljs$core$IFn$_invoke$arity$2((2),expr__20782) : pred__20781.call(null,(2),expr__20782)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20782)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20668 = cljs.core.PersistentHashMap.EMPTY;
var inst_20669 = [inst_20668,inst_20659];
var inst_20670 = (new cljs.core.PersistentVector(null,2,(5),inst_20667,inst_20669,null));
var inst_20671 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20666,inst_20670,inst_20662);
var inst_20672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20671,(0),null);
var inst_20673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20671,(1),null);
var inst_20674 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20675__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20672);
var state_20757__$1 = (function (){var statearr_20784 = state_20757;
(statearr_20784[(18)] = inst_20674);

(statearr_20784[(17)] = inst_20660__$1);

(statearr_20784[(13)] = inst_20673);

(statearr_20784[(11)] = inst_20664__$1);

(statearr_20784[(15)] = inst_20675__$1);

(statearr_20784[(7)] = inst_20663__$1);

return statearr_20784;
})();
if(cljs.core.truth_(inst_20675__$1)){
var statearr_20785_20828 = state_20757__$1;
(statearr_20785_20828[(1)] = (6));

} else {
var statearr_20786_20829 = state_20757__$1;
(statearr_20786_20829[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (23))){
var inst_20691 = (state_20757[(8)]);
var inst_20728 = cljs.core.coll_QMARK_(inst_20691);
var state_20757__$1 = state_20757;
if(inst_20728){
var statearr_20787_20830 = state_20757__$1;
(statearr_20787_20830[(1)] = (25));

} else {
var statearr_20788_20831 = state_20757__$1;
(statearr_20788_20831[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (19))){
var inst_20689 = (state_20757[(14)]);
var inst_20719 = cljs.core.PersistentHashMap.EMPTY;
var inst_20720 = fluree.db.query.analytical.tuples__GT_map(inst_20719,inst_20689);
var state_20757__$1 = state_20757;
var statearr_20789_20832 = state_20757__$1;
(statearr_20789_20832[(2)] = inst_20720);

(statearr_20789_20832[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (11))){
var inst_20689 = (state_20757[(14)]);
var state_20757__$1 = state_20757;
var statearr_20791_20833 = state_20757__$1;
(statearr_20791_20833[(2)] = inst_20689);

(statearr_20791_20833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (9))){
var inst_20660 = (state_20757[(17)]);
var inst_20685 = (state_20757[(16)]);
var inst_20664 = (state_20757[(11)]);
var inst_20684 = (state_20757[(2)]);
var inst_20685__$1 = fluree.db.util.async.throw_err(inst_20684);
var inst_20686 = cljs.core.count(inst_20685__$1);
var inst_20687 = fluree.db.query.analytical.add_fuel(inst_20686,fuel,max_fuel);
var inst_20688 = cljs.core.vals(inst_20660);
var inst_20689 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_20688,inst_20685__$1);
var state_20757__$1 = (function (){var statearr_20792 = state_20757;
(statearr_20792[(14)] = inst_20689);

(statearr_20792[(16)] = inst_20685__$1);

(statearr_20792[(19)] = inst_20687);

return statearr_20792;
})();
if(cljs.core.truth_(inst_20664)){
var statearr_20793_20834 = state_20757__$1;
(statearr_20793_20834[(1)] = (10));

} else {
var statearr_20794_20835 = state_20757__$1;
(statearr_20794_20835[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (5))){
var _ = (function (){var statearr_20795 = state_20757;
(statearr_20795[(4)] = cljs.core.rest((state_20757[(4)])));

return statearr_20795;
})();
var state_20757__$1 = state_20757;
var ex20790 = (state_20757__$1[(2)]);
var statearr_20796_20836 = state_20757__$1;
(statearr_20796_20836[(5)] = ex20790);


if((ex20790 instanceof Error)){
var statearr_20797_20837 = state_20757__$1;
(statearr_20797_20837[(1)] = (4));

(statearr_20797_20837[(5)] = null);

} else {
throw ex20790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (14))){
var state_20757__$1 = state_20757;
var statearr_20798_20838 = state_20757__$1;
(statearr_20798_20838[(2)] = null);

(statearr_20798_20838[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (26))){
var state_20757__$1 = state_20757;
var statearr_20799_20839 = state_20757__$1;
(statearr_20799_20839[(2)] = null);

(statearr_20799_20839[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (16))){
var state_20757__$1 = state_20757;
var statearr_20800_20840 = state_20757__$1;
(statearr_20800_20840[(2)] = null);

(statearr_20800_20840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (10))){
var inst_20673 = (state_20757[(13)]);
var inst_20694 = (state_20757[(12)]);
var inst_20691 = cljs.core.first(inst_20673);
var inst_20692 = cljs.core.first(clause);
var inst_20693 = fluree.db.query.analytical.variable_QMARK_(inst_20692);
var inst_20694__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20673,(1));
var inst_20695 = fluree.db.query.analytical.variable_QMARK_(inst_20694__$1);
var state_20757__$1 = (function (){var statearr_20801 = state_20757;
(statearr_20801[(10)] = inst_20693);

(statearr_20801[(8)] = inst_20691);

(statearr_20801[(12)] = inst_20694__$1);

return statearr_20801;
})();
if(cljs.core.truth_(inst_20695)){
var statearr_20802_20841 = state_20757__$1;
(statearr_20802_20841[(1)] = (13));

} else {
var statearr_20803_20842 = state_20757__$1;
(statearr_20803_20842[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (18))){
var inst_20693 = (state_20757[(10)]);
var inst_20717 = (state_20757[(2)]);
var state_20757__$1 = (function (){var statearr_20804 = state_20757;
(statearr_20804[(20)] = inst_20717);

return statearr_20804;
})();
if(cljs.core.truth_(inst_20693)){
var statearr_20805_20843 = state_20757__$1;
(statearr_20805_20843[(1)] = (19));

} else {
var statearr_20806_20844 = state_20757__$1;
(statearr_20806_20844[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (8))){
var inst_20674 = (state_20757[(18)]);
var inst_20673 = (state_20757[(13)]);
var inst_20679 = (state_20757[(2)]);
var inst_20680 = [inst_20679];
var inst_20681 = cljs.core.PersistentHashMap.fromArrays(inst_20674,inst_20680);
var inst_20682 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20673,inst_20681);
var state_20757__$1 = state_20757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20757__$1,(9),inst_20682);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20807 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20807[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_20807[(1)] = (1));

return statearr_20807;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20757){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20757);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20808){var ex__2730__auto__ = e20808;
var statearr_20809_20845 = state_20757;
(statearr_20809_20845[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20757[(4)]))){
var statearr_20810_20846 = state_20757;
(statearr_20810_20846[(1)] = cljs.core.first((state_20757[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20847 = state_20757;
state_20757 = G__20847;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = function(state_20757){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20811 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20811[(6)] = c__2749__auto__);

return statearr_20811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20848,res,clause){
var map__20849 = p__20848;
var map__20849__$1 = cljs.core.__destructure_map(map__20849);
var db = map__20849__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20849__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20849__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20849__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20958){
var state_val_20959 = (state_20958[(1)]);
if((state_val_20959 === (7))){
var inst_20858 = (state_20958[(7)]);
var state_20958__$1 = state_20958;
var statearr_20960_21001 = state_20958__$1;
(statearr_20960_21001[(2)] = inst_20858);

(statearr_20960_21001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (20))){
var state_20958__$1 = state_20958;
var statearr_20961_21002 = state_20958__$1;
(statearr_20961_21002[(2)] = null);

(statearr_20961_21002[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (1))){
var state_20958__$1 = state_20958;
var statearr_20962_21003 = state_20958__$1;
(statearr_20962_21003[(2)] = null);

(statearr_20962_21003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (24))){
var inst_20860 = (state_20958[(8)]);
var inst_20931 = (state_20958[(2)]);
var inst_20932 = fluree.db.flake.sid__GT_cid(inst_20931);
var inst_20933 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20932);
var inst_20934 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20936 = [inst_20860];
var inst_20937 = (new cljs.core.PersistentVector(null,1,(5),inst_20935,inst_20936,null));
var inst_20938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20940 = [inst_20933];
var inst_20941 = (new cljs.core.PersistentVector(null,1,(5),inst_20939,inst_20940,null));
var inst_20942 = [inst_20941];
var inst_20943 = (new cljs.core.PersistentVector(null,1,(5),inst_20938,inst_20942,null));
var inst_20944 = cljs.core.PersistentHashMap.EMPTY;
var inst_20945 = [inst_20937,inst_20943,inst_20944];
var inst_20946 = cljs.core.PersistentHashMap.fromArrays(inst_20934,inst_20945);
var state_20958__$1 = state_20958;
var statearr_20963_21004 = state_20958__$1;
(statearr_20963_21004[(2)] = inst_20946);

(statearr_20963_21004[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (4))){
var inst_20851 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20964_21005 = state_20958__$1;
(statearr_20964_21005[(2)] = inst_20851);

(statearr_20964_21005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (15))){
var inst_20858 = (state_20958[(7)]);
var inst_20860 = (state_20958[(8)]);
var inst_20879 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20880 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20882 = [inst_20858];
var inst_20883 = (new cljs.core.PersistentVector(null,1,(5),inst_20881,inst_20882,null));
var inst_20884 = (function (){var subject_var = inst_20858;
var object_var = inst_20860;
var min_sid = inst_20879;
var max_sid = (0);
return (function (p1__20850_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20850_SHARP_);
});
})();
var inst_20885 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20879,(0));
var inst_20886 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20884,inst_20885);
var inst_20887 = cljs.core.PersistentHashMap.EMPTY;
var inst_20888 = [inst_20883,inst_20886,inst_20887];
var inst_20889 = cljs.core.PersistentHashMap.fromArrays(inst_20880,inst_20888);
var state_20958__$1 = state_20958;
var statearr_20965_21006 = state_20958__$1;
(statearr_20965_21006[(2)] = inst_20889);

(statearr_20965_21006[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (21))){
var inst_20949 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20966_21007 = state_20958__$1;
(statearr_20966_21007[(2)] = inst_20949);

(statearr_20966_21007[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (13))){
var inst_20860 = (state_20958[(8)]);
var state_20958__$1 = state_20958;
if(cljs.core.truth_(inst_20860)){
var statearr_20967_21008 = state_20958__$1;
(statearr_20967_21008[(1)] = (19));

} else {
var statearr_20968_21009 = state_20958__$1;
(statearr_20968_21009[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (22))){
var inst_20922 = (state_20958[(9)]);
var state_20958__$1 = state_20958;
var statearr_20969_21010 = state_20958__$1;
(statearr_20969_21010[(2)] = inst_20922);

(statearr_20969_21010[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (6))){
var inst_20860 = (state_20958[(8)]);
var state_20958__$1 = state_20958;
var statearr_20970_21011 = state_20958__$1;
(statearr_20970_21011[(2)] = inst_20860);

(statearr_20970_21011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (25))){
var inst_20928 = (state_20958[(2)]);
var inst_20929 = fluree.db.util.async.throw_err(inst_20928);
var state_20958__$1 = state_20958;
var statearr_20971_21012 = state_20958__$1;
(statearr_20971_21012[(2)] = inst_20929);

(statearr_20971_21012[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (17))){
var inst_20919 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20972_21013 = state_20958__$1;
(statearr_20972_21013[(2)] = inst_20919);

(statearr_20972_21013[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (3))){
var inst_20956 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20958__$1,inst_20956);
} else {
if((state_val_20959 === (12))){
var inst_20873 = ["_tx",null,"_block",null];
var inst_20874 = (new cljs.core.PersistentArrayMap(null,2,inst_20873,null));
var inst_20875 = (new cljs.core.PersistentHashSet(null,inst_20874,null));
var inst_20876 = cljs.core.last(clause);
var inst_20877 = (inst_20875.cljs$core$IFn$_invoke$arity$1 ? inst_20875.cljs$core$IFn$_invoke$arity$1(inst_20876) : inst_20875.call(null,inst_20876));
var state_20958__$1 = state_20958;
if(cljs.core.truth_(inst_20877)){
var statearr_20973_21014 = state_20958__$1;
(statearr_20973_21014[(1)] = (15));

} else {
var statearr_20974_21015 = state_20958__$1;
(statearr_20974_21015[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (2))){
var inst_20858 = (state_20958[(7)]);
var _ = (function (){var statearr_20975 = state_20958;
(statearr_20975[(4)] = cljs.core.cons((5),(state_20958[(4)])));

return statearr_20975;
})();
var inst_20857 = cljs.core.first(clause);
var inst_20858__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20857);
var inst_20859 = cljs.core.last(clause);
var inst_20860 = fluree.db.query.analytical.variable_QMARK_(inst_20859);
var state_20958__$1 = (function (){var statearr_20976 = state_20958;
(statearr_20976[(7)] = inst_20858__$1);

(statearr_20976[(8)] = inst_20860);

return statearr_20976;
})();
if(cljs.core.truth_(inst_20858__$1)){
var statearr_20977_21016 = state_20958__$1;
(statearr_20977_21016[(1)] = (6));

} else {
var statearr_20978_21017 = state_20958__$1;
(statearr_20978_21017[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (23))){
var inst_20922 = (state_20958[(9)]);
var inst_20926 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20922);
var state_20958__$1 = state_20958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20958__$1,(25),inst_20926);
} else {
if((state_val_20959 === (19))){
var inst_20922 = (state_20958[(9)]);
var inst_20922__$1 = cljs.core.first(clause);
var inst_20923 = typeof inst_20922__$1 === 'number';
var state_20958__$1 = (function (){var statearr_20979 = state_20958;
(statearr_20979[(9)] = inst_20922__$1);

return statearr_20979;
})();
if(cljs.core.truth_(inst_20923)){
var statearr_20980_21018 = state_20958__$1;
(statearr_20980_21018[(1)] = (22));

} else {
var statearr_20981_21019 = state_20958__$1;
(statearr_20981_21019[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (11))){
var inst_20953 = (state_20958[(2)]);
var _ = (function (){var statearr_20983 = state_20958;
(statearr_20983[(4)] = cljs.core.rest((state_20958[(4)])));

return statearr_20983;
})();
var state_20958__$1 = state_20958;
var statearr_20984_21020 = state_20958__$1;
(statearr_20984_21020[(2)] = inst_20953);

(statearr_20984_21020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (9))){
var inst_20866 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20867 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20868 = cljs.core.PersistentHashMap.fromArrays(inst_20866,inst_20867);
var inst_20869 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20868);
var inst_20870 = (function(){throw inst_20869})();
var state_20958__$1 = state_20958;
var statearr_20985_21021 = state_20958__$1;
(statearr_20985_21021[(2)] = inst_20870);

(statearr_20985_21021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (5))){
var _ = (function (){var statearr_20986 = state_20958;
(statearr_20986[(4)] = cljs.core.rest((state_20958[(4)])));

return statearr_20986;
})();
var state_20958__$1 = state_20958;
var ex20982 = (state_20958__$1[(2)]);
var statearr_20987_21022 = state_20958__$1;
(statearr_20987_21022[(5)] = ex20982);


if((ex20982 instanceof Error)){
var statearr_20988_21023 = state_20958__$1;
(statearr_20988_21023[(1)] = (4));

(statearr_20988_21023[(5)] = null);

} else {
throw ex20982;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (14))){
var inst_20951 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20989_21024 = state_20958__$1;
(statearr_20989_21024[(2)] = inst_20951);

(statearr_20989_21024[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (16))){
var inst_20895 = (state_20958[(10)]);
var inst_20892 = (state_20958[(11)]);
var inst_20894 = (state_20958[(12)]);
var inst_20891 = cljs.core.last(clause);
var inst_20892__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20891);
var inst_20893 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20894__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20893,inst_20892__$1);
var inst_20895__$1 = fluree.db.flake.min_subject_id(inst_20892__$1);
var inst_20896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20897 = [inst_20894__$1];
var inst_20898 = (new cljs.core.PersistentVector(null,1,(5),inst_20896,inst_20897,null));
var inst_20899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20900 = [inst_20895__$1];
var inst_20901 = (new cljs.core.PersistentVector(null,1,(5),inst_20899,inst_20900,null));
var inst_20902 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20898,cljs.core._LT__EQ_,inst_20901);
var state_20958__$1 = (function (){var statearr_20990 = state_20958;
(statearr_20990[(10)] = inst_20895__$1);

(statearr_20990[(11)] = inst_20892__$1);

(statearr_20990[(12)] = inst_20894__$1);

return statearr_20990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20958__$1,(18),inst_20902);
} else {
if((state_val_20959 === (10))){
var inst_20858 = (state_20958[(7)]);
var state_20958__$1 = state_20958;
if(cljs.core.truth_(inst_20858)){
var statearr_20991_21025 = state_20958__$1;
(statearr_20991_21025[(1)] = (12));

} else {
var statearr_20992_21026 = state_20958__$1;
(statearr_20992_21026[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (18))){
var inst_20858 = (state_20958[(7)]);
var inst_20895 = (state_20958[(10)]);
var inst_20860 = (state_20958[(8)]);
var inst_20892 = (state_20958[(11)]);
var inst_20894 = (state_20958[(12)]);
var inst_20904 = (state_20958[(2)]);
var inst_20905 = fluree.db.util.async.throw_err(inst_20904);
var inst_20906 = (function (){var subject_var = inst_20858;
var object_var = inst_20860;
var partition = inst_20892;
var max_sid = inst_20894;
var min_sid = inst_20895;
var flakes = inst_20905;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20907 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20906);
var inst_20908 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20909 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20907,inst_20908);
var inst_20910 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20912 = [inst_20858];
var inst_20913 = (new cljs.core.PersistentVector(null,1,(5),inst_20911,inst_20912,null));
var inst_20914 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20909,inst_20905);
var inst_20915 = cljs.core.PersistentHashMap.EMPTY;
var inst_20916 = [inst_20913,inst_20914,inst_20915];
var inst_20917 = cljs.core.PersistentHashMap.fromArrays(inst_20910,inst_20916);
var state_20958__$1 = state_20958;
var statearr_20993_21027 = state_20958__$1;
(statearr_20993_21027[(2)] = inst_20917);

(statearr_20993_21027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (8))){
var inst_20864 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
if(cljs.core.truth_(inst_20864)){
var statearr_20994_21028 = state_20958__$1;
(statearr_20994_21028[(1)] = (9));

} else {
var statearr_20995_21029 = state_20958__$1;
(statearr_20995_21029[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20996 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20996[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__);

(statearr_20996[(1)] = (1));

return statearr_20996;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20958){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20958);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20997){var ex__2730__auto__ = e20997;
var statearr_20998_21030 = state_20958;
(statearr_20998_21030[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20958[(4)]))){
var statearr_20999_21031 = state_20958;
(statearr_20999_21031[(1)] = cljs.core.first((state_20958[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21032 = state_20958;
state_20958 = G__21032;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = function(state_20958){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21000 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21000[(6)] = c__2749__auto__);

return statearr_21000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21039 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21039;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21040(s__21041){
return (new cljs.core.LazySeq(null,(function (){
var s__21041__$1 = s__21041;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__21041__$1);
if(temp__5804__auto__){
var s__21041__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21041__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__21041__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__21043 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__21042 = (0);
while(true){
if((i__21042 < size__5522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__21042);
var delta = (x - mean);
cljs.core.chunk_append(b__21043,(delta * delta));

var G__21045 = (i__21042 + (1));
i__21042 = G__21045;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21043),fluree$db$query$analytical$variance_$_iter__21040(cljs.core.chunk_rest(s__21041__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21043),null);
}
} else {
var x = cljs.core.first(s__21041__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21040(cljs.core.rest(s__21041__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21044 = variance(coll);
return Math.sqrt(G__21044);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21046 = null;
var G__21046__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21046__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21046 = function(n,coll){
switch(arguments.length){
case 1:
return G__21046__1.call(this,n);
case 2:
return G__21046__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21046.cljs$core$IFn$_invoke$arity$1 = G__21046__1;
G__21046.cljs$core$IFn$_invoke$arity$2 = G__21046__2;
return G__21046;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21047 = null;
var G__21047__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21047__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21047 = function(n,coll){
switch(arguments.length){
case 1:
return G__21047__1.call(this,n);
case 2:
return G__21047__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21047.cljs$core$IFn$_invoke$arity$1 = G__21047__1;
G__21047.cljs$core$IFn$_invoke$arity$2 = G__21047__2;
return G__21047;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21048 = null;
var G__21048__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21048__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21048 = function(n,coll){
switch(arguments.length){
case 1:
return G__21048__1.call(this,n);
case 2:
return G__21048__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21048.cljs$core$IFn$_invoke$arity$1 = G__21048__1;
G__21048.cljs$core$IFn$_invoke$arity$2 = G__21048__2;
return G__21048;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count(parsed_code);
var vec__21049 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),cljs.core.second(parsed_code),cljs.core.last(parsed_code)], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(parsed_code)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),null,cljs.core.last(parsed_code)], null)):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21049,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21049,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21049,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21052 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21055 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21055) : agg_fn.call(null,G__21055));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21052,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21052,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0)),")"].join('');
if(cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(code_str);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_(code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__21056 = aggregate_fn_map;
var map__21056__$1 = cljs.core.__destructure_map(map__21056);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21056__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21056__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21056__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(agg_params) : function$.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21058 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21058,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21058,(1),null);
var map__21061 = res__$1;
var map__21061__$1 = cljs.core.__destructure_map(map__21061);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21061__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21061__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21057_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21057_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21062_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21062_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21063_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21063_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21064_SHARP_,p2__21065_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21064_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21065_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21066_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21066_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21069,row,b_tuple){
var vec__21070 = p__21069;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21070,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21070,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21067_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21067_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21068_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21068_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21073_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21073_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21074_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21074_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21079 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21081 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21080 = (function (p1__21075_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21075_SHARP_);
});
return fexpr__21080(G__21081);
})()),cljs.core.set(b_idxs));
var fexpr__21078 = (function (p1__21076_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21076_SHARP_);
});
return fexpr__21078(G__21079);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21077_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21077_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21082_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21082_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21083_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21083_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21088 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21090 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21089 = (function (p1__21084_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21084_SHARP_);
});
return fexpr__21089(G__21090);
})()),cljs.core.set(b_idxs));
var fexpr__21087 = (function (p1__21085_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21085_SHARP_);
});
return fexpr__21087(G__21088);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21086_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21086_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21092 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21092,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21092,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21091_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21091_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var vec__21097 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21097,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21097,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21095_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21095_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21096_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21096_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21100,filters,optional_QMARK_){
var map__21101 = p__21100;
var map__21101__$1 = cljs.core.__destructure_map(map__21101);
var tuple_map = map__21101__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21101__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21101__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21101__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21102 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21102,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21102,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21105 = res;
var map__21105__$1 = cljs.core.__destructure_map(map__21105);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21105__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21105__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21161){
var state_val_21162 = (state_21161[(1)]);
if((state_val_21162 === (7))){
var inst_21135 = (state_21161[(7)]);
var inst_21133 = (state_21161[(2)]);
var inst_21134 = fluree.db.util.async.throw_err(inst_21133);
var inst_21135__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21134,(0),null);
var inst_21136 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21134,(1),null);
var inst_21137 = (inst_21135__$1 == null);
var state_21161__$1 = (function (){var statearr_21163 = state_21161;
(statearr_21163[(7)] = inst_21135__$1);

(statearr_21163[(8)] = inst_21136);

return statearr_21163;
})();
if(cljs.core.truth_(inst_21137)){
var statearr_21164_21193 = state_21161__$1;
(statearr_21164_21193[(1)] = (8));

} else {
var statearr_21165_21194 = state_21161__$1;
(statearr_21165_21194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (1))){
var inst_21113 = optional_clauses;
var inst_21114 = cljs.core.seq(inst_21113);
var inst_21115 = cljs.core.first(inst_21114);
var inst_21116 = cljs.core.next(inst_21114);
var inst_21117 = where_tuples;
var inst_21118 = inst_21113;
var inst_21119 = inst_21117;
var state_21161__$1 = (function (){var statearr_21166 = state_21161;
(statearr_21166[(9)] = inst_21118);

(statearr_21166[(10)] = inst_21115);

(statearr_21166[(11)] = inst_21119);

(statearr_21166[(12)] = inst_21116);

return statearr_21166;
})();
var statearr_21167_21195 = state_21161__$1;
(statearr_21167_21195[(2)] = null);

(statearr_21167_21195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (4))){
var inst_21126 = (state_21161[(13)]);
var inst_21125 = (state_21161[(14)]);
var inst_21119 = (state_21161[(11)]);
var inst_21131 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21119,inst_21125,inst_21126,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21119,inst_21125,inst_21126,true,fuel,max_fuel,opts));
var state_21161__$1 = state_21161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21161__$1,(7),inst_21131);
} else {
if((state_val_21162 === (15))){
var state_21161__$1 = state_21161;
var statearr_21168_21196 = state_21161__$1;
(statearr_21168_21196[(2)] = null);

(statearr_21168_21196[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (13))){
var inst_21152 = (state_21161[(2)]);
var state_21161__$1 = state_21161;
var statearr_21169_21197 = state_21161__$1;
(statearr_21169_21197[(2)] = inst_21152);

(statearr_21169_21197[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (6))){
var inst_21157 = (state_21161[(2)]);
var state_21161__$1 = state_21161;
var statearr_21170_21198 = state_21161__$1;
(statearr_21170_21198[(2)] = inst_21157);

(statearr_21170_21198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (3))){
var inst_21159 = (state_21161[(2)]);
var state_21161__$1 = state_21161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21161__$1,inst_21159);
} else {
if((state_val_21162 === (12))){
var state_21161__$1 = state_21161;
var statearr_21171_21199 = state_21161__$1;
(statearr_21171_21199[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (2))){
var inst_21118 = (state_21161[(9)]);
var inst_21125 = (state_21161[(14)]);
var inst_21124 = cljs.core.seq(inst_21118);
var inst_21125__$1 = cljs.core.first(inst_21124);
var inst_21126 = cljs.core.next(inst_21124);
var state_21161__$1 = (function (){var statearr_21173 = state_21161;
(statearr_21173[(13)] = inst_21126);

(statearr_21173[(14)] = inst_21125__$1);

return statearr_21173;
})();
if(cljs.core.truth_(inst_21125__$1)){
var statearr_21174_21200 = state_21161__$1;
(statearr_21174_21200[(1)] = (4));

} else {
var statearr_21175_21201 = state_21161__$1;
(statearr_21175_21201[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (11))){
var inst_21135 = (state_21161[(7)]);
var inst_21136 = (state_21161[(8)]);
var inst_21118 = inst_21136;
var inst_21119 = inst_21135;
var state_21161__$1 = (function (){var statearr_21176 = state_21161;
(statearr_21176[(9)] = inst_21118);

(statearr_21176[(11)] = inst_21119);

return statearr_21176;
})();
var statearr_21177_21202 = state_21161__$1;
(statearr_21177_21202[(2)] = null);

(statearr_21177_21202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (9))){
var inst_21125 = (state_21161[(14)]);
var inst_21141 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21125);
var state_21161__$1 = state_21161;
if(cljs.core.truth_(inst_21141)){
var statearr_21178_21203 = state_21161__$1;
(statearr_21178_21203[(1)] = (11));

} else {
var statearr_21179_21204 = state_21161__$1;
(statearr_21179_21204[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (5))){
var inst_21119 = (state_21161[(11)]);
var state_21161__$1 = state_21161;
var statearr_21180_21205 = state_21161__$1;
(statearr_21180_21205[(2)] = inst_21119);

(statearr_21180_21205[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (14))){
var inst_21119 = (state_21161[(11)]);
var inst_21135 = (state_21161[(7)]);
var inst_21136 = (state_21161[(8)]);
var inst_21146 = fluree.db.query.analytical.left_outer_join(inst_21119,inst_21135);
var inst_21118 = inst_21136;
var inst_21119__$1 = inst_21146;
var state_21161__$1 = (function (){var statearr_21181 = state_21161;
(statearr_21181[(9)] = inst_21118);

(statearr_21181[(11)] = inst_21119__$1);

return statearr_21181;
})();
var statearr_21182_21206 = state_21161__$1;
(statearr_21182_21206[(2)] = null);

(statearr_21182_21206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (16))){
var inst_21150 = (state_21161[(2)]);
var state_21161__$1 = state_21161;
var statearr_21184_21207 = state_21161__$1;
(statearr_21184_21207[(2)] = inst_21150);

(statearr_21184_21207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (10))){
var inst_21154 = (state_21161[(2)]);
var state_21161__$1 = state_21161;
var statearr_21185_21208 = state_21161__$1;
(statearr_21185_21208[(2)] = inst_21154);

(statearr_21185_21208[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21162 === (8))){
var inst_21119 = (state_21161[(11)]);
var inst_21136 = (state_21161[(8)]);
var tmp21183 = inst_21119;
var inst_21118 = inst_21136;
var inst_21119__$1 = tmp21183;
var state_21161__$1 = (function (){var statearr_21186 = state_21161;
(statearr_21186[(9)] = inst_21118);

(statearr_21186[(11)] = inst_21119__$1);

return statearr_21186;
})();
var statearr_21187_21209 = state_21161__$1;
(statearr_21187_21209[(2)] = null);

(statearr_21187_21209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0 = (function (){
var statearr_21188 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21188[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__);

(statearr_21188[(1)] = (1));

return statearr_21188;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1 = (function (state_21161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21189){var ex__2730__auto__ = e21189;
var statearr_21190_21210 = state_21161;
(statearr_21190_21210[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21161[(4)]))){
var statearr_21191_21211 = state_21161;
(statearr_21191_21211[(1)] = cljs.core.first((state_21161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21212 = state_21161;
state_21161 = G__21212;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = function(state_21161){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1.call(this,state_21161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21192 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21192[(6)] = c__2749__auto__);

return statearr_21192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21214){
var vec__21215 = p__21214;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21215,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21215,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21213_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21213_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21219,p__21220,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21221 = p__21219;
var map__21221__$1 = cljs.core.__destructure_map(map__21221);
var q_map = map__21221__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21221__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21222 = p__21220;
var map__21222__$1 = cljs.core.__destructure_map(map__21222);
var res = map__21222__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21222__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21459){
var state_val_21460 = (state_21459[(1)]);
if((state_val_21460 === (65))){
var inst_21409 = (state_21459[(7)]);
var inst_21408 = (state_21459[(8)]);
var inst_21420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21421 = fluree.db.query.analytical.full_text__GT_tuples(inst_21408,res,inst_21409);
var inst_21422 = [inst_21421,r];
var inst_21423 = (new cljs.core.PersistentVector(null,2,(5),inst_21420,inst_21422,null));
var state_21459__$1 = state_21459;
var statearr_21461_21574 = state_21459__$1;
(statearr_21461_21574[(2)] = inst_21423);

(statearr_21461_21574[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (70))){
var inst_21435 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21462_21575 = state_21459__$1;
(statearr_21462_21575[(2)] = inst_21435);

(statearr_21462_21575[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (62))){
var inst_21409 = (state_21459[(7)]);
var inst_21417 = cljs.core.second(inst_21409);
var inst_21418 = clojure.string.starts_with_QMARK_(inst_21417,"fullText:");
var state_21459__$1 = state_21459;
if(inst_21418){
var statearr_21463_21576 = state_21459__$1;
(statearr_21463_21576[(1)] = (65));

} else {
var statearr_21464_21577 = state_21459__$1;
(statearr_21464_21577[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (7))){
var inst_21328 = (state_21459[(9)]);
var inst_21327 = cljs.core.count(clause);
var inst_21328__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21327);
var state_21459__$1 = (function (){var statearr_21465 = state_21459;
(statearr_21465[(9)] = inst_21328__$1);

return statearr_21465;
})();
if(inst_21328__$1){
var statearr_21466_21578 = state_21459__$1;
(statearr_21466_21578[(1)] = (31));

} else {
var statearr_21467_21579 = state_21459__$1;
(statearr_21467_21579[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (59))){
var inst_21442 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21468_21580 = state_21459__$1;
(statearr_21468_21580[(2)] = inst_21442);

(statearr_21468_21580[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (20))){
var inst_21291 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21469_21581 = state_21459__$1;
(statearr_21469_21581[(2)] = inst_21291);

(statearr_21469_21581[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (58))){
var state_21459__$1 = state_21459;
var statearr_21470_21582 = state_21459__$1;
(statearr_21470_21582[(2)] = null);

(statearr_21470_21582[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (60))){
var inst_21408 = (state_21459[(8)]);
var inst_21406 = (state_21459[(2)]);
var inst_21407 = fluree.db.util.async.throw_err(inst_21406);
var inst_21408__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21407,(0),null);
var inst_21409 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21407,(1),null);
var inst_21410 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21408__$1);
var state_21459__$1 = (function (){var statearr_21471 = state_21459;
(statearr_21471[(7)] = inst_21409);

(statearr_21471[(8)] = inst_21408__$1);

return statearr_21471;
})();
if(inst_21410){
var statearr_21472_21583 = state_21459__$1;
(statearr_21472_21583[(1)] = (61));

} else {
var statearr_21473_21584 = state_21459__$1;
(statearr_21473_21584[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (27))){
var inst_21321 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21474_21585 = state_21459__$1;
(statearr_21474_21585[(2)] = inst_21321);

(statearr_21474_21585[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (1))){
var state_21459__$1 = state_21459;
var statearr_21475_21586 = state_21459__$1;
(statearr_21475_21586[(2)] = null);

(statearr_21475_21586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (69))){
var state_21459__$1 = state_21459;
var statearr_21476_21587 = state_21459__$1;
(statearr_21476_21587[(2)] = null);

(statearr_21476_21587[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (24))){
var inst_21285 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21477_21588 = state_21459__$1;
(statearr_21477_21588[(2)] = inst_21285);

(statearr_21477_21588[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (55))){
var inst_21391 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21392 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21393 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21394 = cljs.core.PersistentHashMap.fromArrays(inst_21392,inst_21393);
var inst_21395 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21391,inst_21394);
var inst_21396 = (function(){throw inst_21395})();
var state_21459__$1 = state_21459;
var statearr_21478_21589 = state_21459__$1;
(statearr_21478_21589[(2)] = inst_21396);

(statearr_21478_21589[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (39))){
var inst_21348 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
if(cljs.core.truth_(inst_21348)){
var statearr_21479_21590 = state_21459__$1;
(statearr_21479_21590[(1)] = (40));

} else {
var statearr_21480_21591 = state_21459__$1;
(statearr_21480_21591[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (46))){
var inst_21448 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21481_21592 = state_21459__$1;
(statearr_21481_21592[(2)] = inst_21448);

(statearr_21481_21592[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (4))){
var inst_21223 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21482_21593 = state_21459__$1;
(statearr_21482_21593[(2)] = inst_21223);

(statearr_21482_21593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (54))){
var inst_21384 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21385 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21386 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21387 = cljs.core.PersistentHashMap.fromArrays(inst_21385,inst_21386);
var inst_21388 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21384,inst_21387);
var inst_21389 = (function(){throw inst_21388})();
var state_21459__$1 = state_21459;
var statearr_21483_21594 = state_21459__$1;
(statearr_21483_21594[(2)] = inst_21389);

(statearr_21483_21594[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (15))){
var inst_21323 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21484_21595 = state_21459__$1;
(statearr_21484_21595[(2)] = inst_21323);

(statearr_21484_21595[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (48))){
var inst_21372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21373 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21374 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21373);
var inst_21375 = [inst_21374,r];
var inst_21376 = (new cljs.core.PersistentVector(null,2,(5),inst_21372,inst_21375,null));
var state_21459__$1 = state_21459;
var statearr_21485_21596 = state_21459__$1;
(statearr_21485_21596[(2)] = inst_21376);

(statearr_21485_21596[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (50))){
var inst_21446 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21486_21597 = state_21459__$1;
(statearr_21486_21597[(2)] = inst_21446);

(statearr_21486_21597[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (21))){
var inst_21268 = (state_21459[(10)]);
var inst_21261 = (state_21459[(11)]);
var inst_21269 = (state_21459[(12)]);
var inst_21262 = (state_21459[(13)]);
var inst_21232 = (state_21459[(14)]);
var inst_21236 = (state_21459[(15)]);
var inst_21257 = (state_21459[(16)]);
var inst_21259 = (state_21459[(17)]);
var inst_21260 = (state_21459[(18)]);
var inst_21273 = (state_21459[(2)]);
var inst_21274 = fluree.db.util.async.throw_err(inst_21273);
var inst_21275 = (function (){var pred__21233 = inst_21236;
var vec__21264 = inst_21261;
var new_res = inst_21274;
var rest = inst_21269;
var expr__21234 = inst_21232;
var seq__21265 = inst_21269;
var tuples = inst_21262;
var seq__21255 = inst_21260;
var vec__21254 = inst_21257;
var G__21253 = inst_21261;
var first__21266 = inst_21268;
var segment_type = inst_21232;
var first__21256 = inst_21259;
var clause_group = inst_21268;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21276 = cljs.core.keys(vars);
var inst_21277 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21275,inst_21274,inst_21276);
var inst_21278 = fluree.db.query.analytical.res_absorb_vars(inst_21277);
var state_21459__$1 = (function (){var statearr_21487 = state_21459;
(statearr_21487[(19)] = inst_21278);

return statearr_21487;
})();
if(cljs.core.truth_(inst_21262)){
var statearr_21488_21598 = state_21459__$1;
(statearr_21488_21598[(1)] = (22));

} else {
var statearr_21489_21599 = state_21459__$1;
(statearr_21489_21599[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (31))){
var inst_21330 = cljs.core.second(clause);
var inst_21331 = clojure.string.starts_with_QMARK_(inst_21330,"fullText:");
var state_21459__$1 = state_21459;
var statearr_21490_21600 = state_21459__$1;
(statearr_21490_21600[(2)] = inst_21331);

(statearr_21490_21600[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (32))){
var inst_21328 = (state_21459[(9)]);
var state_21459__$1 = state_21459;
var statearr_21491_21601 = state_21459__$1;
(statearr_21491_21601[(2)] = inst_21328);

(statearr_21491_21601[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (40))){
var inst_21350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21351 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21459__$1 = (function (){var statearr_21492 = state_21459;
(statearr_21492[(20)] = inst_21350);

return statearr_21492;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(43),inst_21351);
} else {
if((state_val_21460 === (56))){
var inst_21398 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21493_21602 = state_21459__$1;
(statearr_21493_21602[(2)] = inst_21398);

(statearr_21493_21602[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (33))){
var inst_21334 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
if(cljs.core.truth_(inst_21334)){
var statearr_21494_21603 = state_21459__$1;
(statearr_21494_21603[(1)] = (34));

} else {
var statearr_21495_21604 = state_21459__$1;
(statearr_21495_21604[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (13))){
var inst_21257 = (state_21459[(16)]);
var inst_21257__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21258 = cljs.core.seq(inst_21257__$1);
var inst_21259 = cljs.core.first(inst_21258);
var inst_21260 = cljs.core.next(inst_21258);
var inst_21261 = inst_21257__$1;
var inst_21262 = null;
var state_21459__$1 = (function (){var statearr_21496 = state_21459;
(statearr_21496[(11)] = inst_21261);

(statearr_21496[(13)] = inst_21262);

(statearr_21496[(16)] = inst_21257__$1);

(statearr_21496[(17)] = inst_21259);

(statearr_21496[(18)] = inst_21260);

return statearr_21496;
})();
var statearr_21497_21605 = state_21459__$1;
(statearr_21497_21605[(2)] = null);

(statearr_21497_21605[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (22))){
var inst_21269 = (state_21459[(12)]);
var inst_21262 = (state_21459[(13)]);
var inst_21278 = (state_21459[(19)]);
var inst_21280 = fluree.db.query.union.results(inst_21262,inst_21278);
var inst_21261 = inst_21269;
var inst_21262__$1 = inst_21280;
var state_21459__$1 = (function (){var statearr_21498 = state_21459;
(statearr_21498[(11)] = inst_21261);

(statearr_21498[(13)] = inst_21262__$1);

return statearr_21498;
})();
var statearr_21499_21606 = state_21459__$1;
(statearr_21499_21606[(2)] = null);

(statearr_21499_21606[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (36))){
var inst_21452 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21500_21607 = state_21459__$1;
(statearr_21500_21607[(2)] = inst_21452);

(statearr_21500_21607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (41))){
var inst_21358 = cljs.core.count(clause);
var inst_21359 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21358);
var state_21459__$1 = state_21459;
if(inst_21359){
var statearr_21501_21608 = state_21459__$1;
(statearr_21501_21608[(1)] = (44));

} else {
var statearr_21502_21609 = state_21459__$1;
(statearr_21502_21609[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (43))){
var inst_21350 = (state_21459[(20)]);
var inst_21353 = (state_21459[(2)]);
var inst_21354 = fluree.db.util.async.throw_err(inst_21353);
var inst_21355 = [inst_21354,r];
var inst_21356 = (new cljs.core.PersistentVector(null,2,(5),inst_21350,inst_21355,null));
var state_21459__$1 = state_21459;
var statearr_21503_21610 = state_21459__$1;
(statearr_21503_21610[(2)] = inst_21356);

(statearr_21503_21610[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (61))){
var inst_21409 = (state_21459[(7)]);
var inst_21412 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21409,r,res,optional_QMARK_,fuel,max_fuel);
var state_21459__$1 = state_21459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(64),inst_21412);
} else {
if((state_val_21460 === (29))){
var inst_21232 = (state_21459[(14)]);
var inst_21315 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21232)].join('');
var inst_21316 = (new Error(inst_21315));
var inst_21317 = (function(){throw inst_21316})();
var state_21459__$1 = state_21459;
var statearr_21504_21611 = state_21459__$1;
(statearr_21504_21611[(2)] = inst_21317);

(statearr_21504_21611[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (44))){
var inst_21361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21362 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21459__$1 = (function (){var statearr_21505 = state_21459;
(statearr_21505[(21)] = inst_21361);

return statearr_21505;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(47),inst_21362);
} else {
if((state_val_21460 === (6))){
var inst_21232 = (state_21459[(14)]);
var inst_21236 = (state_21459[(15)]);
var inst_21231 = cljs.core.keys(clause);
var inst_21232__$1 = cljs.core.first(inst_21231);
var inst_21236__$1 = cljs.core._EQ_;
var inst_21237 = (function (){var G__21506 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21507 = inst_21232__$1;
return (inst_21236__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21236__$1.cljs$core$IFn$_invoke$arity$2(G__21506,G__21507) : inst_21236__$1.call(null,G__21506,G__21507));
})();
var state_21459__$1 = (function (){var statearr_21508 = state_21459;
(statearr_21508[(14)] = inst_21232__$1);

(statearr_21508[(15)] = inst_21236__$1);

return statearr_21508;
})();
if(cljs.core.truth_(inst_21237)){
var statearr_21509_21612 = state_21459__$1;
(statearr_21509_21612[(1)] = (9));

} else {
var statearr_21510_21613 = state_21459__$1;
(statearr_21510_21613[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (28))){
var inst_21309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21310 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21311 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21310,optional_QMARK_);
var inst_21312 = [inst_21311,r];
var inst_21313 = (new cljs.core.PersistentVector(null,2,(5),inst_21309,inst_21312,null));
var state_21459__$1 = state_21459;
var statearr_21511_21614 = state_21459__$1;
(statearr_21511_21614[(2)] = inst_21313);

(statearr_21511_21614[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (64))){
var inst_21414 = (state_21459[(2)]);
var inst_21415 = fluree.db.util.async.throw_err(inst_21414);
var state_21459__$1 = state_21459;
var statearr_21512_21615 = state_21459__$1;
(statearr_21512_21615[(2)] = inst_21415);

(statearr_21512_21615[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (51))){
var inst_21381 = cljs.core.first(clause);
var inst_21382 = cljs.core.sequential_QMARK_(inst_21381);
var state_21459__$1 = state_21459;
if(inst_21382){
var statearr_21513_21616 = state_21459__$1;
(statearr_21513_21616[(1)] = (54));

} else {
var statearr_21514_21617 = state_21459__$1;
(statearr_21514_21617[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (25))){
var inst_21232 = (state_21459[(14)]);
var inst_21236 = (state_21459[(15)]);
var inst_21297 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21298 = (function (){var segment_type = inst_21232;
var pred__21233 = inst_21236;
var expr__21234 = inst_21232;
var bindings = inst_21297;
return (function (p1__21218_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21218_SHARP_);
});
})();
var inst_21299 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21298,inst_21297);
var inst_21300 = cljs.core.PersistentHashMap.EMPTY;
var inst_21301 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21300,inst_21299);
var inst_21302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21303 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21301);
var inst_21304 = [inst_21303,r];
var inst_21305 = (new cljs.core.PersistentVector(null,2,(5),inst_21302,inst_21304,null));
var state_21459__$1 = state_21459;
var statearr_21515_21618 = state_21459__$1;
(statearr_21515_21618[(2)] = inst_21305);

(statearr_21515_21618[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (34))){
var inst_21336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21337 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21338 = [inst_21337,r];
var inst_21339 = (new cljs.core.PersistentVector(null,2,(5),inst_21336,inst_21338,null));
var state_21459__$1 = state_21459;
var statearr_21516_21619 = state_21459__$1;
(statearr_21516_21619[(2)] = inst_21339);

(statearr_21516_21619[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (17))){
var inst_21293 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21517_21620 = state_21459__$1;
(statearr_21517_21620[(2)] = inst_21293);

(statearr_21517_21620[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (3))){
var inst_21457 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21459__$1,inst_21457);
} else {
if((state_val_21460 === (12))){
var inst_21239 = (state_21459[(22)]);
var inst_21243 = (state_21459[(2)]);
var inst_21244 = fluree.db.util.async.throw_err(inst_21243);
var inst_21245 = [inst_21244,r];
var inst_21246 = (new cljs.core.PersistentVector(null,2,(5),inst_21239,inst_21245,null));
var state_21459__$1 = state_21459;
var statearr_21518_21621 = state_21459__$1;
(statearr_21518_21621[(2)] = inst_21246);

(statearr_21518_21621[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (2))){
var _ = (function (){var statearr_21519 = state_21459;
(statearr_21519[(4)] = cljs.core.cons((5),(state_21459[(4)])));

return statearr_21519;
})();
var inst_21229 = cljs.core.map_QMARK_(clause);
var state_21459__$1 = state_21459;
if(inst_21229){
var statearr_21520_21622 = state_21459__$1;
(statearr_21520_21622[(1)] = (6));

} else {
var statearr_21521_21623 = state_21459__$1;
(statearr_21521_21623[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (66))){
var state_21459__$1 = state_21459;
var statearr_21522_21624 = state_21459__$1;
(statearr_21522_21624[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (23))){
var inst_21269 = (state_21459[(12)]);
var inst_21278 = (state_21459[(19)]);
var inst_21261 = inst_21269;
var inst_21262 = inst_21278;
var state_21459__$1 = (function (){var statearr_21524 = state_21459;
(statearr_21524[(11)] = inst_21261);

(statearr_21524[(13)] = inst_21262);

return statearr_21524;
})();
var statearr_21525_21625 = state_21459__$1;
(statearr_21525_21625[(2)] = null);

(statearr_21525_21625[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (47))){
var inst_21361 = (state_21459[(21)]);
var inst_21364 = (state_21459[(2)]);
var inst_21365 = fluree.db.util.async.throw_err(inst_21364);
var inst_21366 = [inst_21365,r];
var inst_21367 = (new cljs.core.PersistentVector(null,2,(5),inst_21361,inst_21366,null));
var state_21459__$1 = state_21459;
var statearr_21526_21626 = state_21459__$1;
(statearr_21526_21626[(2)] = inst_21367);

(statearr_21526_21626[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (35))){
var inst_21342 = (state_21459[(23)]);
var inst_21341 = cljs.core.count(clause);
var inst_21342__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21341);
var state_21459__$1 = (function (){var statearr_21527 = state_21459;
(statearr_21527[(23)] = inst_21342__$1);

return statearr_21527;
})();
if(inst_21342__$1){
var statearr_21528_21627 = state_21459__$1;
(statearr_21528_21627[(1)] = (37));

} else {
var statearr_21529_21628 = state_21459__$1;
(statearr_21529_21628[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (19))){
var inst_21262 = (state_21459[(13)]);
var inst_21287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21288 = [inst_21262,r];
var inst_21289 = (new cljs.core.PersistentVector(null,2,(5),inst_21287,inst_21288,null));
var state_21459__$1 = state_21459;
var statearr_21530_21629 = state_21459__$1;
(statearr_21530_21629[(2)] = inst_21289);

(statearr_21530_21629[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (57))){
var inst_21404 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21459__$1 = state_21459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(60),inst_21404);
} else {
if((state_val_21460 === (68))){
var inst_21409 = (state_21459[(7)]);
var inst_21408 = (state_21459[(8)]);
var inst_21426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21427 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21408,res,inst_21409,fuel,max_fuel);
var state_21459__$1 = (function (){var statearr_21531 = state_21459;
(statearr_21531[(24)] = inst_21426);

return statearr_21531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(71),inst_21427);
} else {
if((state_val_21460 === (11))){
var inst_21325 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21533_21630 = state_21459__$1;
(statearr_21533_21630[(2)] = inst_21325);

(statearr_21533_21630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (9))){
var inst_21239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21240 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21241 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21240,res,fuel,max_fuel,opts);
var state_21459__$1 = (function (){var statearr_21534 = state_21459;
(statearr_21534[(22)] = inst_21239);

return statearr_21534;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(12),inst_21241);
} else {
if((state_val_21460 === (5))){
var _ = (function (){var statearr_21535 = state_21459;
(statearr_21535[(4)] = cljs.core.rest((state_21459[(4)])));

return statearr_21535;
})();
var state_21459__$1 = state_21459;
var ex21532 = (state_21459__$1[(2)]);
var statearr_21536_21631 = state_21459__$1;
(statearr_21536_21631[(5)] = ex21532);


if((ex21532 instanceof Error)){
var statearr_21537_21632 = state_21459__$1;
(statearr_21537_21632[(1)] = (4));

(statearr_21537_21632[(5)] = null);

} else {
throw ex21532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (14))){
var inst_21232 = (state_21459[(14)]);
var inst_21236 = (state_21459[(15)]);
var inst_21295 = (function (){var G__21538 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21539 = inst_21232;
return (inst_21236.cljs$core$IFn$_invoke$arity$2 ? inst_21236.cljs$core$IFn$_invoke$arity$2(G__21538,G__21539) : inst_21236.call(null,G__21538,G__21539));
})();
var state_21459__$1 = state_21459;
if(cljs.core.truth_(inst_21295)){
var statearr_21540_21633 = state_21459__$1;
(statearr_21540_21633[(1)] = (25));

} else {
var statearr_21541_21634 = state_21459__$1;
(statearr_21541_21634[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (45))){
var inst_21369 = cljs.core.count(clause);
var inst_21370 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21369);
var state_21459__$1 = state_21459;
if(inst_21370){
var statearr_21542_21635 = state_21459__$1;
(statearr_21542_21635[(1)] = (48));

} else {
var statearr_21543_21636 = state_21459__$1;
(statearr_21543_21636[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (53))){
var inst_21444 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21544_21637 = state_21459__$1;
(statearr_21544_21637[(2)] = inst_21444);

(statearr_21544_21637[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (26))){
var inst_21232 = (state_21459[(14)]);
var inst_21236 = (state_21459[(15)]);
var inst_21307 = (function (){var G__21545 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21546 = inst_21232;
return (inst_21236.cljs$core$IFn$_invoke$arity$2 ? inst_21236.cljs$core$IFn$_invoke$arity$2(G__21545,G__21546) : inst_21236.call(null,G__21545,G__21546));
})();
var state_21459__$1 = state_21459;
if(cljs.core.truth_(inst_21307)){
var statearr_21547_21638 = state_21459__$1;
(statearr_21547_21638[(1)] = (28));

} else {
var statearr_21548_21639 = state_21459__$1;
(statearr_21548_21639[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (16))){
var inst_21268 = (state_21459[(10)]);
var inst_21261 = (state_21459[(11)]);
var inst_21267 = cljs.core.seq(inst_21261);
var inst_21268__$1 = cljs.core.first(inst_21267);
var inst_21269 = cljs.core.next(inst_21267);
var state_21459__$1 = (function (){var statearr_21549 = state_21459;
(statearr_21549[(10)] = inst_21268__$1);

(statearr_21549[(12)] = inst_21269);

return statearr_21549;
})();
if(cljs.core.truth_(inst_21268__$1)){
var statearr_21550_21640 = state_21459__$1;
(statearr_21550_21640[(1)] = (18));

} else {
var statearr_21551_21641 = state_21459__$1;
(statearr_21551_21641[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (38))){
var inst_21342 = (state_21459[(23)]);
var state_21459__$1 = state_21459;
var statearr_21552_21642 = state_21459__$1;
(statearr_21552_21642[(2)] = inst_21342);

(statearr_21552_21642[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (30))){
var inst_21319 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21553_21643 = state_21459__$1;
(statearr_21553_21643[(2)] = inst_21319);

(statearr_21553_21643[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (10))){
var inst_21232 = (state_21459[(14)]);
var inst_21236 = (state_21459[(15)]);
var inst_21248 = (function (){var G__21554 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21555 = inst_21232;
return (inst_21236.cljs$core$IFn$_invoke$arity$2 ? inst_21236.cljs$core$IFn$_invoke$arity$2(G__21554,G__21555) : inst_21236.call(null,G__21554,G__21555));
})();
var state_21459__$1 = state_21459;
if(cljs.core.truth_(inst_21248)){
var statearr_21556_21644 = state_21459__$1;
(statearr_21556_21644[(1)] = (13));

} else {
var statearr_21557_21645 = state_21459__$1;
(statearr_21557_21645[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (18))){
var inst_21268 = (state_21459[(10)]);
var inst_21271 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21268,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21268,q_map,vars,fuel,max_fuel,opts));
var state_21459__$1 = state_21459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21459__$1,(21),inst_21271);
} else {
if((state_val_21460 === (52))){
var state_21459__$1 = state_21459;
var statearr_21558_21646 = state_21459__$1;
(statearr_21558_21646[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (67))){
var inst_21437 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21560_21647 = state_21459__$1;
(statearr_21560_21647[(2)] = inst_21437);

(statearr_21560_21647[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (71))){
var inst_21426 = (state_21459[(24)]);
var inst_21429 = (state_21459[(2)]);
var inst_21430 = fluree.db.util.async.throw_err(inst_21429);
var inst_21431 = [inst_21430,r];
var inst_21432 = (new cljs.core.PersistentVector(null,2,(5),inst_21426,inst_21431,null));
var state_21459__$1 = state_21459;
var statearr_21561_21648 = state_21459__$1;
(statearr_21561_21648[(2)] = inst_21432);

(statearr_21561_21648[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (42))){
var inst_21450 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21562_21649 = state_21459__$1;
(statearr_21562_21649[(2)] = inst_21450);

(statearr_21562_21649[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (37))){
var inst_21344 = cljs.core.second(clause);
var inst_21345 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21344,"rdf:type");
var state_21459__$1 = state_21459;
var statearr_21563_21650 = state_21459__$1;
(statearr_21563_21650[(2)] = inst_21345);

(statearr_21563_21650[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (63))){
var inst_21439 = (state_21459[(2)]);
var state_21459__$1 = state_21459;
var statearr_21564_21651 = state_21459__$1;
(statearr_21564_21651[(2)] = inst_21439);

(statearr_21564_21651[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (8))){
var inst_21454 = (state_21459[(2)]);
var _ = (function (){var statearr_21565 = state_21459;
(statearr_21565[(4)] = cljs.core.rest((state_21459[(4)])));

return statearr_21565;
})();
var state_21459__$1 = state_21459;
var statearr_21566_21652 = state_21459__$1;
(statearr_21566_21652[(2)] = inst_21454);

(statearr_21566_21652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21460 === (49))){
var inst_21378 = cljs.core.count(clause);
var inst_21379 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21378);
var state_21459__$1 = state_21459;
if(inst_21379){
var statearr_21567_21653 = state_21459__$1;
(statearr_21567_21653[(1)] = (51));

} else {
var statearr_21568_21654 = state_21459__$1;
(statearr_21568_21654[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_21569 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21569[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_21569[(1)] = (1));

return statearr_21569;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_21459){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21459);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21570){var ex__2730__auto__ = e21570;
var statearr_21571_21655 = state_21459;
(statearr_21571_21655[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21459[(4)]))){
var statearr_21572_21656 = state_21459;
(statearr_21572_21656[(1)] = cljs.core.first((state_21459[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21657 = state_21459;
state_21459 = G__21657;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = function(state_21459){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_21459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21573 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21573[(6)] = c__2749__auto__);

return statearr_21573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21659 = arguments.length;
switch (G__21659) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21739){
var state_val_21740 = (state_21739[(1)]);
if((state_val_21740 === (7))){
var inst_21734 = (state_21739[(2)]);
var _ = (function (){var statearr_21741 = state_21739;
(statearr_21741[(4)] = cljs.core.rest((state_21739[(4)])));

return statearr_21741;
})();
var state_21739__$1 = state_21739;
var statearr_21742_21790 = state_21739__$1;
(statearr_21742_21790[(2)] = inst_21734);

(statearr_21742_21790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (20))){
var inst_21699 = (state_21739[(7)]);
var inst_21711 = (state_21739[(2)]);
var inst_21681 = inst_21699;
var inst_21682 = inst_21711;
var state_21739__$1 = (function (){var statearr_21743 = state_21739;
(statearr_21743[(8)] = inst_21681);

(statearr_21743[(9)] = inst_21682);

return statearr_21743;
})();
var statearr_21744_21791 = state_21739__$1;
(statearr_21744_21791[(2)] = null);

(statearr_21744_21791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (1))){
var state_21739__$1 = state_21739;
var statearr_21745_21792 = state_21739__$1;
(statearr_21745_21792[(2)] = null);

(statearr_21745_21792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (24))){
var inst_21699 = (state_21739[(7)]);
var inst_21698 = (state_21739[(10)]);
var inst_21682 = (state_21739[(9)]);
var inst_21719 = fluree.db.query.analytical.inner_join(inst_21682,inst_21698);
var inst_21681 = inst_21699;
var inst_21682__$1 = inst_21719;
var state_21739__$1 = (function (){var statearr_21746 = state_21739;
(statearr_21746[(8)] = inst_21681);

(statearr_21746[(9)] = inst_21682__$1);

return statearr_21746;
})();
var statearr_21747_21793 = state_21739__$1;
(statearr_21747_21793[(2)] = null);

(statearr_21747_21793[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (4))){
var inst_21660 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
var statearr_21749_21794 = state_21739__$1;
(statearr_21749_21794[(2)] = inst_21660);

(statearr_21749_21794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (15))){
var inst_21698 = (state_21739[(10)]);
var state_21739__$1 = state_21739;
if(cljs.core.truth_(inst_21698)){
var statearr_21750_21795 = state_21739__$1;
(statearr_21750_21795[(1)] = (18));

} else {
var statearr_21751_21796 = state_21739__$1;
(statearr_21751_21796[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (21))){
var inst_21699 = (state_21739[(7)]);
var inst_21682 = (state_21739[(9)]);
var tmp21748 = inst_21682;
var inst_21681 = inst_21699;
var inst_21682__$1 = tmp21748;
var state_21739__$1 = (function (){var statearr_21752 = state_21739;
(statearr_21752[(8)] = inst_21681);

(statearr_21752[(9)] = inst_21682__$1);

return statearr_21752;
})();
var statearr_21753_21797 = state_21739__$1;
(statearr_21753_21797[(2)] = null);

(statearr_21753_21797[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (13))){
var inst_21682 = (state_21739[(9)]);
var inst_21705 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21682,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21706 = cljs.core.empty_QMARK_(inst_21705);
var state_21739__$1 = state_21739;
if(inst_21706){
var statearr_21754_21798 = state_21739__$1;
(statearr_21754_21798[(1)] = (15));

} else {
var statearr_21755_21799 = state_21739__$1;
(statearr_21755_21799[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (22))){
var state_21739__$1 = state_21739;
var statearr_21756_21800 = state_21739__$1;
(statearr_21756_21800[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (6))){
var inst_21688 = (state_21739[(11)]);
var inst_21681 = (state_21739[(8)]);
var inst_21687 = cljs.core.seq(inst_21681);
var inst_21688__$1 = cljs.core.first(inst_21687);
var inst_21689 = cljs.core.next(inst_21687);
var state_21739__$1 = (function (){var statearr_21758 = state_21739;
(statearr_21758[(12)] = inst_21689);

(statearr_21758[(11)] = inst_21688__$1);

return statearr_21758;
})();
if(cljs.core.truth_(inst_21688__$1)){
var statearr_21759_21801 = state_21739__$1;
(statearr_21759_21801[(1)] = (8));

} else {
var statearr_21760_21802 = state_21739__$1;
(statearr_21760_21802[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (25))){
var state_21739__$1 = state_21739;
var statearr_21761_21803 = state_21739__$1;
(statearr_21761_21803[(2)] = null);

(statearr_21761_21803[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (17))){
var inst_21727 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
var statearr_21762_21804 = state_21739__$1;
(statearr_21762_21804[(2)] = inst_21727);

(statearr_21762_21804[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (3))){
var inst_21737 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21739__$1,inst_21737);
} else {
if((state_val_21740 === (12))){
var inst_21699 = (state_21739[(7)]);
var inst_21698 = (state_21739[(10)]);
var inst_21681 = inst_21699;
var inst_21682 = inst_21698;
var state_21739__$1 = (function (){var statearr_21763 = state_21739;
(statearr_21763[(8)] = inst_21681);

(statearr_21763[(9)] = inst_21682);

return statearr_21763;
})();
var statearr_21764_21805 = state_21739__$1;
(statearr_21764_21805[(2)] = null);

(statearr_21764_21805[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (2))){
var _ = (function (){var statearr_21765 = state_21739;
(statearr_21765[(4)] = cljs.core.cons((5),(state_21739[(4)])));

return statearr_21765;
})();
var inst_21673 = where;
var inst_21674 = cljs.core.seq(inst_21673);
var inst_21675 = cljs.core.first(inst_21674);
var inst_21676 = cljs.core.next(inst_21674);
var inst_21677 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21678 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21679 = [inst_21678];
var inst_21680 = cljs.core.PersistentHashMap.fromArrays(inst_21677,inst_21679);
var inst_21681 = inst_21673;
var inst_21682 = inst_21680;
var state_21739__$1 = (function (){var statearr_21766 = state_21739;
(statearr_21766[(13)] = inst_21675);

(statearr_21766[(14)] = inst_21676);

(statearr_21766[(8)] = inst_21681);

(statearr_21766[(9)] = inst_21682);

return statearr_21766;
})();
var statearr_21767_21806 = state_21739__$1;
(statearr_21767_21806[(2)] = null);

(statearr_21767_21806[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (23))){
var inst_21725 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
var statearr_21768_21807 = state_21739__$1;
(statearr_21768_21807[(2)] = inst_21725);

(statearr_21768_21807[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (19))){
var inst_21682 = (state_21739[(9)]);
var state_21739__$1 = state_21739;
var statearr_21769_21808 = state_21739__$1;
(statearr_21769_21808[(2)] = inst_21682);

(statearr_21769_21808[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (11))){
var inst_21688 = (state_21739[(11)]);
var inst_21696 = (state_21739[(2)]);
var inst_21697 = fluree.db.util.async.throw_err(inst_21696);
var inst_21698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21697,(0),null);
var inst_21699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21697,(1),null);
var inst_21700 = cljs.core.count(inst_21688);
var inst_21701 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21700);
var state_21739__$1 = (function (){var statearr_21771 = state_21739;
(statearr_21771[(7)] = inst_21699);

(statearr_21771[(10)] = inst_21698);

return statearr_21771;
})();
if(inst_21701){
var statearr_21772_21809 = state_21739__$1;
(statearr_21772_21809[(1)] = (12));

} else {
var statearr_21773_21810 = state_21739__$1;
(statearr_21773_21810[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (9))){
var inst_21682 = (state_21739[(9)]);
var state_21739__$1 = state_21739;
var statearr_21774_21811 = state_21739__$1;
(statearr_21774_21811[(2)] = inst_21682);

(statearr_21774_21811[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (5))){
var _ = (function (){var statearr_21775 = state_21739;
(statearr_21775[(4)] = cljs.core.rest((state_21739[(4)])));

return statearr_21775;
})();
var state_21739__$1 = state_21739;
var ex21770 = (state_21739__$1[(2)]);
var statearr_21776_21812 = state_21739__$1;
(statearr_21776_21812[(5)] = ex21770);


if((ex21770 instanceof Error)){
var statearr_21777_21813 = state_21739__$1;
(statearr_21777_21813[(1)] = (4));

(statearr_21777_21813[(5)] = null);

} else {
throw ex21770;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (14))){
var inst_21729 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
var statearr_21778_21814 = state_21739__$1;
(statearr_21778_21814[(2)] = inst_21729);

(statearr_21778_21814[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (26))){
var inst_21723 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
var statearr_21779_21815 = state_21739__$1;
(statearr_21779_21815[(2)] = inst_21723);

(statearr_21779_21815[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (16))){
var inst_21698 = (state_21739[(10)]);
var inst_21714 = (inst_21698 == null);
var state_21739__$1 = state_21739;
if(cljs.core.truth_(inst_21714)){
var statearr_21780_21816 = state_21739__$1;
(statearr_21780_21816[(1)] = (21));

} else {
var statearr_21781_21817 = state_21739__$1;
(statearr_21781_21817[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (10))){
var inst_21732 = (state_21739[(2)]);
var state_21739__$1 = state_21739;
var statearr_21782_21818 = state_21739__$1;
(statearr_21782_21818[(2)] = inst_21732);

(statearr_21782_21818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (18))){
var inst_21698 = (state_21739[(10)]);
var state_21739__$1 = state_21739;
var statearr_21783_21819 = state_21739__$1;
(statearr_21783_21819[(2)] = inst_21698);

(statearr_21783_21819[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21740 === (8))){
var inst_21689 = (state_21739[(12)]);
var inst_21688 = (state_21739[(11)]);
var inst_21682 = (state_21739[(9)]);
var inst_21694 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21682,inst_21688,inst_21689,false,fuel,max_fuel,opts);
var state_21739__$1 = state_21739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21739__$1,(11),inst_21694);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_21784 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21784[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_21784[(1)] = (1));

return statearr_21784;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_21739){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21739);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21785){var ex__2730__auto__ = e21785;
var statearr_21786_21820 = state_21739;
(statearr_21786_21820[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21739[(4)]))){
var statearr_21787_21821 = state_21739;
(statearr_21787_21821[(1)] = cljs.core.first((state_21739[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21822 = state_21739;
state_21739 = G__21822;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_21739){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_21739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21788 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21788[(6)] = c__2749__auto__);

return statearr_21788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21857){
var state_val_21858 = (state_21857[(1)]);
if((state_val_21858 === (7))){
var inst_21834 = (state_21857[(7)]);
var inst_21839 = (state_21857[(8)]);
var inst_21841 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21834,inst_21839,fuel,max_fuel,opts);
var state_21857__$1 = state_21857;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21857__$1,(10),inst_21841);
} else {
if((state_val_21858 === (1))){
var state_21857__$1 = state_21857;
var statearr_21859_21884 = state_21857__$1;
(statearr_21859_21884[(2)] = null);

(statearr_21859_21884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (4))){
var inst_21823 = (state_21857[(2)]);
var state_21857__$1 = state_21857;
var statearr_21860_21885 = state_21857__$1;
(statearr_21860_21885[(2)] = inst_21823);

(statearr_21860_21885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (13))){
var inst_21852 = (state_21857[(2)]);
var _ = (function (){var statearr_21861 = state_21857;
(statearr_21861[(4)] = cljs.core.rest((state_21857[(4)])));

return statearr_21861;
})();
var state_21857__$1 = state_21857;
var statearr_21862_21886 = state_21857__$1;
(statearr_21862_21886[(2)] = inst_21852);

(statearr_21862_21886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (6))){
var inst_21834 = (state_21857[(7)]);
var inst_21838 = (state_21857[(2)]);
var inst_21839 = fluree.db.util.async.throw_err(inst_21838);
var state_21857__$1 = (function (){var statearr_21863 = state_21857;
(statearr_21863[(8)] = inst_21839);

return statearr_21863;
})();
if(cljs.core.truth_(inst_21834)){
var statearr_21864_21887 = state_21857__$1;
(statearr_21864_21887[(1)] = (7));

} else {
var statearr_21865_21888 = state_21857__$1;
(statearr_21865_21888[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (3))){
var inst_21855 = (state_21857[(2)]);
var state_21857__$1 = state_21857;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21857__$1,inst_21855);
} else {
if((state_val_21858 === (12))){
var inst_21847 = (state_21857[(9)]);
var state_21857__$1 = state_21857;
var statearr_21866_21889 = state_21857__$1;
(statearr_21866_21889[(2)] = inst_21847);

(statearr_21866_21889[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (2))){
var _ = (function (){var statearr_21867 = state_21857;
(statearr_21867[(4)] = cljs.core.cons((5),(state_21857[(4)])));

return statearr_21867;
})();
var inst_21830 = q_map;
var inst_21831 = cljs.core.__destructure_map(inst_21830);
var inst_21832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21831,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21831,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21834 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21831,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21831,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21836 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21833,q_map,inst_21832,fuel,max_fuel,opts);
var state_21857__$1 = (function (){var statearr_21868 = state_21857;
(statearr_21868[(10)] = inst_21835);

(statearr_21868[(7)] = inst_21834);

return statearr_21868;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21857__$1,(6),inst_21836);
} else {
if((state_val_21858 === (11))){
var inst_21847 = (state_21857[(9)]);
var inst_21835 = (state_21857[(10)]);
var inst_21849 = fluree.db.query.analytical.tuples__GT_filtered(inst_21847,inst_21835,null);
var state_21857__$1 = state_21857;
var statearr_21870_21890 = state_21857__$1;
(statearr_21870_21890[(2)] = inst_21849);

(statearr_21870_21890[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (9))){
var inst_21835 = (state_21857[(10)]);
var inst_21847 = (state_21857[(2)]);
var state_21857__$1 = (function (){var statearr_21871 = state_21857;
(statearr_21871[(9)] = inst_21847);

return statearr_21871;
})();
if(cljs.core.truth_(inst_21835)){
var statearr_21872_21891 = state_21857__$1;
(statearr_21872_21891[(1)] = (11));

} else {
var statearr_21873_21892 = state_21857__$1;
(statearr_21873_21892[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (5))){
var _ = (function (){var statearr_21874 = state_21857;
(statearr_21874[(4)] = cljs.core.rest((state_21857[(4)])));

return statearr_21874;
})();
var state_21857__$1 = state_21857;
var ex21869 = (state_21857__$1[(2)]);
var statearr_21875_21893 = state_21857__$1;
(statearr_21875_21893[(5)] = ex21869);


if((ex21869 instanceof Error)){
var statearr_21876_21894 = state_21857__$1;
(statearr_21876_21894[(1)] = (4));

(statearr_21876_21894[(5)] = null);

} else {
throw ex21869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (10))){
var inst_21843 = (state_21857[(2)]);
var inst_21844 = fluree.db.util.async.throw_err(inst_21843);
var state_21857__$1 = state_21857;
var statearr_21877_21895 = state_21857__$1;
(statearr_21877_21895[(2)] = inst_21844);

(statearr_21877_21895[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21858 === (8))){
var inst_21839 = (state_21857[(8)]);
var state_21857__$1 = state_21857;
var statearr_21878_21896 = state_21857__$1;
(statearr_21878_21896[(2)] = inst_21839);

(statearr_21878_21896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2727__auto____0 = (function (){
var statearr_21879 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21879[(0)] = fluree$db$query$analytical$q_$_state_machine__2727__auto__);

(statearr_21879[(1)] = (1));

return statearr_21879;
});
var fluree$db$query$analytical$q_$_state_machine__2727__auto____1 = (function (state_21857){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21857);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21880){var ex__2730__auto__ = e21880;
var statearr_21881_21897 = state_21857;
(statearr_21881_21897[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21857[(4)]))){
var statearr_21882_21898 = state_21857;
(statearr_21882_21898[(1)] = cljs.core.first((state_21857[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21899 = state_21857;
state_21857 = G__21899;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2727__auto__ = function(state_21857){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____1.call(this,state_21857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2727__auto____0;
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21883 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21883[(6)] = c__2749__auto__);

return statearr_21883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
