// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42614 = arguments.length;
var i__5770__auto___42615 = (0);
while(true){
if((i__5770__auto___42615 < len__5769__auto___42614)){
args__5775__auto__.push((arguments[i__5770__auto___42615]));

var G__42616 = (i__5770__auto___42615 + (1));
i__5770__auto___42615 = G__42616;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__42609_42617 = e;
var G__42610_42618 = "Function Error: ";
var G__42611_42619 = function_name;
var G__42612_42620 = "args: ";
var G__42613_42621 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__42609_42617,G__42610_42618,G__42611_42619,G__42612_42620,G__42613_42621) : fluree.db.util.log.error.call(null,G__42609_42617,G__42610_42618,G__42611_42619,G__42612_42620,G__42613_42621));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq42606){
var G__42607 = cljs.core.first(seq42606);
var seq42606__$1 = cljs.core.next(seq42606);
var G__42608 = cljs.core.first(seq42606__$1);
var seq42606__$2 = cljs.core.next(seq42606__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42607,G__42608,seq42606__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e42622){var e = e42622;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e42623){var e = e42623;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e42624){var e = e42624;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e42625){var e = e42625;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e42626){var e = e42626;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42629 = arguments.length;
var i__5770__auto___42630 = (0);
while(true){
if((i__5770__auto___42630 < len__5769__auto___42629)){
args__5775__auto__.push((arguments[i__5770__auto___42630]));

var G__42631 = (i__5770__auto___42630 + (1));
i__5770__auto___42630 = G__42631;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e42628){var e = e42628;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq42627){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42627));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42634 = arguments.length;
var i__5770__auto___42635 = (0);
while(true){
if((i__5770__auto___42635 < len__5769__auto___42634)){
args__5775__auto__.push((arguments[i__5770__auto___42635]));

var G__42636 = (i__5770__auto___42635 + (1));
i__5770__auto___42635 = G__42636;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e42633){var e = e42633;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq42632){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42632));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e42637){var e = e42637;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42640 = arguments.length;
var i__5770__auto___42641 = (0);
while(true){
if((i__5770__auto___42641 < len__5769__auto___42640)){
args__5775__auto__.push((arguments[i__5770__auto___42641]));

var G__42642 = (i__5770__auto___42641 + (1));
i__5770__auto___42641 = G__42642;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e42639){var e = e42639;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq42638){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42638));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42645 = arguments.length;
var i__5770__auto___42646 = (0);
while(true){
if((i__5770__auto___42646 < len__5769__auto___42645)){
args__5775__auto__.push((arguments[i__5770__auto___42646]));

var G__42647 = (i__5770__auto___42646 + (1));
i__5770__auto___42646 = G__42647;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e42644){var e = e42644;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq42643){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42643));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e42648){var e = e42648;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e42649){var e = e42649;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42652 = arguments.length;
var i__5770__auto___42653 = (0);
while(true){
if((i__5770__auto___42653 < len__5769__auto___42652)){
args__5775__auto__.push((arguments[i__5770__auto___42653]));

var G__42654 = (i__5770__auto___42653 + (1));
i__5770__auto___42653 = G__42654;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e42651){var e = e42651;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq42650){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42650));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42657 = arguments.length;
var i__5770__auto___42658 = (0);
while(true){
if((i__5770__auto___42658 < len__5769__auto___42657)){
args__5775__auto__.push((arguments[i__5770__auto___42658]));

var G__42659 = (i__5770__auto___42658 + (1));
i__5770__auto___42658 = G__42659;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e42656){var e = e42656;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq42655){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42655));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42662 = arguments.length;
var i__5770__auto___42663 = (0);
while(true){
if((i__5770__auto___42663 < len__5769__auto___42662)){
args__5775__auto__.push((arguments[i__5770__auto___42663]));

var G__42664 = (i__5770__auto___42663 + (1));
i__5770__auto___42663 = G__42664;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e42661){var e = e42661;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq42660){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42660));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42667 = arguments.length;
var i__5770__auto___42668 = (0);
while(true){
if((i__5770__auto___42668 < len__5769__auto___42667)){
args__5775__auto__.push((arguments[i__5770__auto___42668]));

var G__42669 = (i__5770__auto___42668 + (1));
i__5770__auto___42668 = G__42669;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e42666){var e = e42666;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq42665){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42665));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42672 = arguments.length;
var i__5770__auto___42673 = (0);
while(true){
if((i__5770__auto___42673 < len__5769__auto___42672)){
args__5775__auto__.push((arguments[i__5770__auto___42673]));

var G__42674 = (i__5770__auto___42673 + (1));
i__5770__auto___42673 = G__42674;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e42671){var e = e42671;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq42670){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42670));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42677 = arguments.length;
var i__5770__auto___42678 = (0);
while(true){
if((i__5770__auto___42678 < len__5769__auto___42677)){
args__5775__auto__.push((arguments[i__5770__auto___42678]));

var G__42679 = (i__5770__auto___42678 + (1));
i__5770__auto___42678 = G__42679;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e42676){var e = e42676;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq42675){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42675));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42682 = arguments.length;
var i__5770__auto___42683 = (0);
while(true){
if((i__5770__auto___42683 < len__5769__auto___42682)){
args__5775__auto__.push((arguments[i__5770__auto___42683]));

var G__42684 = (i__5770__auto___42683 + (1));
i__5770__auto___42683 = G__42684;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e42681){var e = e42681;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq42680){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42680));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__42686 = arguments.length;
switch (G__42686) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_42714){
var state_val_42715 = (state_42714[(1)]);
if((state_val_42715 === (7))){
var inst_42699 = (state_42714[(7)]);
var inst_42702 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42699,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_42714__$1 = state_42714;
var statearr_42716_42802 = state_42714__$1;
(statearr_42716_42802[(2)] = inst_42702);

(statearr_42716_42802[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42715 === (1))){
var state_42714__$1 = state_42714;
var statearr_42717_42803 = state_42714__$1;
(statearr_42717_42803[(2)] = null);

(statearr_42717_42803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42715 === (4))){
var inst_42687 = (state_42714[(2)]);
var state_42714__$1 = state_42714;
var statearr_42718_42804 = state_42714__$1;
(statearr_42718_42804[(2)] = inst_42687);

(statearr_42718_42804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42715 === (6))){
var inst_42699 = (state_42714[(7)]);
var inst_42699__$1 = (state_42714[(2)]);
var inst_42700 = fluree.db.util.core.exception_QMARK_(inst_42699__$1);
var state_42714__$1 = (function (){var statearr_42719 = state_42714;
(statearr_42719[(7)] = inst_42699__$1);

return statearr_42719;
})();
if(inst_42700){
var statearr_42720_42805 = state_42714__$1;
(statearr_42720_42805[(1)] = (7));

} else {
var statearr_42721_42806 = state_42714__$1;
(statearr_42721_42806[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42715 === (3))){
var inst_42712 = (state_42714[(2)]);
var state_42714__$1 = state_42714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42714__$1,inst_42712);
} else {
if((state_val_42715 === (2))){
var inst_42693 = (state_42714[(8)]);
var _ = (function (){var statearr_42723 = state_42714;
(statearr_42723[(4)] = cljs.core.cons((5),(state_42714[(4)])));

return statearr_42723;
})();
var inst_42693__$1 = cljs.core.volatile_BANG_((0));
var inst_42694 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_42695 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_42694,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_42693__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_42696 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_42695);
var inst_42697 = fluree.db.query.fql.query(db,inst_42696);
var state_42714__$1 = (function (){var statearr_42724 = state_42714;
(statearr_42724[(8)] = inst_42693__$1);

return statearr_42724;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42714__$1,(6),inst_42697);
} else {
if((state_val_42715 === (9))){
var inst_42709 = (state_42714[(2)]);
var _ = (function (){var statearr_42725 = state_42714;
(statearr_42725[(4)] = cljs.core.rest((state_42714[(4)])));

return statearr_42725;
})();
var state_42714__$1 = state_42714;
var statearr_42726_42807 = state_42714__$1;
(statearr_42726_42807[(2)] = inst_42709);

(statearr_42726_42807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42715 === (5))){
var _ = (function (){var statearr_42727 = state_42714;
(statearr_42727[(4)] = cljs.core.rest((state_42714[(4)])));

return statearr_42727;
})();
var state_42714__$1 = state_42714;
var ex42722 = (state_42714__$1[(2)]);
var statearr_42728_42808 = state_42714__$1;
(statearr_42728_42808[(5)] = ex42722);


if((ex42722 instanceof Error)){
var statearr_42729_42809 = state_42714__$1;
(statearr_42729_42809[(1)] = (4));

(statearr_42729_42809[(5)] = null);

} else {
throw ex42722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42715 === (8))){
var inst_42693 = (state_42714[(8)]);
var inst_42699 = (state_42714[(7)]);
var inst_42704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42705 = cljs.core.deref(inst_42693);
var inst_42706 = [inst_42699,inst_42705];
var inst_42707 = (new cljs.core.PersistentVector(null,2,(5),inst_42704,inst_42706,null));
var state_42714__$1 = state_42714;
var statearr_42730_42810 = state_42714__$1;
(statearr_42730_42810[(2)] = inst_42707);

(statearr_42730_42810[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_42731 = [null,null,null,null,null,null,null,null,null];
(statearr_42731[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_42731[(1)] = (1));

return statearr_42731;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_42714){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_42714);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e42732){var ex__2730__auto__ = e42732;
var statearr_42733_42811 = state_42714;
(statearr_42733_42811[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_42714[(4)]))){
var statearr_42734_42812 = state_42714;
(statearr_42734_42812[(1)] = cljs.core.first((state_42714[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42813 = state_42714;
state_42714 = G__42813;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_42714){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_42714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_42735 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_42735[(6)] = c__2749__auto__);

return statearr_42735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_42780){
var state_val_42781 = (state_42780[(1)]);
if((state_val_42781 === (7))){
var inst_42766 = (state_42780[(2)]);
var inst_42767 = fluree.db.query.fql.query(db,inst_42766);
var state_42780__$1 = state_42780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42780__$1,(8),inst_42767);
} else {
if((state_val_42781 === (1))){
var inst_42736 = typeof select === 'string';
var state_42780__$1 = state_42780;
if(cljs.core.truth_(inst_42736)){
var statearr_42782_42814 = state_42780__$1;
(statearr_42782_42814[(1)] = (2));

} else {
var statearr_42783_42815 = state_42780__$1;
(statearr_42783_42815[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (4))){
var inst_42749 = (state_42780[(7)]);
var inst_42742 = (state_42780[(8)]);
var inst_42741 = (state_42780[(2)]);
var inst_42742__$1 = cljs.core.volatile_BANG_((0));
var inst_42743 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_42744 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_42745 = [inst_42742__$1,(100000)];
var inst_42746 = cljs.core.PersistentHashMap.fromArrays(inst_42744,inst_42745);
var inst_42747 = [inst_42741,from,where,block,limit,inst_42746];
var inst_42748 = cljs.core.PersistentHashMap.fromArrays(inst_42743,inst_42747);
var inst_42749__$1 = fluree.db.util.core.without_nils(inst_42748);
var inst_42750 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_42749__$1);
var inst_42751 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_42749__$1);
var inst_42752 = cljs.core.first(inst_42751);
var inst_42753 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42752], 0));
var inst_42754 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_42753);
var inst_42755 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_42749__$1);
var inst_42756 = cljs.core.last(inst_42755);
var inst_42757 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42756], 0));
var inst_42758 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_42757);
var inst_42759 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42750,inst_42754,inst_42758], 0));
var state_42780__$1 = (function (){var statearr_42784 = state_42780;
(statearr_42784[(7)] = inst_42749__$1);

(statearr_42784[(8)] = inst_42742__$1);

return statearr_42784;
})();
if(cljs.core.truth_(inst_42759)){
var statearr_42785_42816 = state_42780__$1;
(statearr_42785_42816[(1)] = (5));

} else {
var statearr_42786_42817 = state_42780__$1;
(statearr_42786_42817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (6))){
var inst_42749 = (state_42780[(7)]);
var state_42780__$1 = state_42780;
var statearr_42787_42818 = state_42780__$1;
(statearr_42787_42818[(2)] = inst_42749);

(statearr_42787_42818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (3))){
var state_42780__$1 = state_42780;
var statearr_42788_42819 = state_42780__$1;
(statearr_42788_42819[(2)] = select);

(statearr_42788_42819[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (2))){
var inst_42738 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_42780__$1 = state_42780;
var statearr_42789_42820 = state_42780__$1;
(statearr_42789_42820[(2)] = inst_42738);

(statearr_42789_42820[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (11))){
var inst_42778 = (state_42780[(2)]);
var state_42780__$1 = state_42780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42780__$1,inst_42778);
} else {
if((state_val_42781 === (9))){
var inst_42769 = (state_42780[(9)]);
var state_42780__$1 = state_42780;
var statearr_42790_42821 = state_42780__$1;
(statearr_42790_42821[(2)] = inst_42769);

(statearr_42790_42821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (5))){
var inst_42749 = (state_42780[(7)]);
var inst_42761 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_42749);
var inst_42762 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_42761);
var inst_42763 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42749,new cljs.core.Keyword(null,"where","where",-2044795965),inst_42762);
var state_42780__$1 = state_42780;
var statearr_42791_42822 = state_42780__$1;
(statearr_42791_42822[(2)] = inst_42763);

(statearr_42791_42822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (10))){
var inst_42742 = (state_42780[(8)]);
var inst_42769 = (state_42780[(9)]);
var inst_42773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42774 = cljs.core.deref(inst_42742);
var inst_42775 = [inst_42769,inst_42774];
var inst_42776 = (new cljs.core.PersistentVector(null,2,(5),inst_42773,inst_42775,null));
var state_42780__$1 = state_42780;
var statearr_42792_42823 = state_42780__$1;
(statearr_42792_42823[(2)] = inst_42776);

(statearr_42792_42823[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42781 === (8))){
var inst_42769 = (state_42780[(9)]);
var inst_42769__$1 = (state_42780[(2)]);
var inst_42770 = fluree.db.util.core.exception_QMARK_(inst_42769__$1);
var state_42780__$1 = (function (){var statearr_42793 = state_42780;
(statearr_42793[(9)] = inst_42769__$1);

return statearr_42793;
})();
if(inst_42770){
var statearr_42794_42824 = state_42780__$1;
(statearr_42794_42824[(1)] = (9));

} else {
var statearr_42795_42825 = state_42780__$1;
(statearr_42795_42825[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_42796 = [null,null,null,null,null,null,null,null,null,null];
(statearr_42796[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_42796[(1)] = (1));

return statearr_42796;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_42780){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_42780);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e42797){var ex__2730__auto__ = e42797;
var statearr_42798_42826 = state_42780;
(statearr_42798_42826[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_42780[(4)]))){
var statearr_42799_42827 = state_42780;
(statearr_42799_42827[(1)] = cljs.core.first((state_42780[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42828 = state_42780;
state_42780 = G__42828;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_42780){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_42780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_42800 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_42800[(6)] = c__2749__auto__);

return statearr_42800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__42832 = path;
var vec__42833 = G__42832;
var seq__42834 = cljs.core.seq(vec__42833);
var first__42835 = cljs.core.first(seq__42834);
var seq__42834__$1 = cljs.core.next(seq__42834);
var var$ = first__42835;
var r = seq__42834__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__42832__$1 = G__42832;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__42839 = G__42832__$1;
var seq__42840 = cljs.core.seq(vec__42839);
var first__42841 = cljs.core.first(seq__42840);
var seq__42840__$1 = cljs.core.next(seq__42840);
var var$__$1 = first__42841;
var r__$1 = seq__42840__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__42842 = r__$1;
var G__42843 = n__$2;
var G__42844 = next_clauses;
G__42832__$1 = G__42842;
n__$1 = G__42843;
where_clauses__$1 = G__42844;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__42845 = r__$1;
var G__42846 = next_n;
var G__42847 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__42832__$1 = G__42845;
n__$1 = G__42846;
where_clauses__$1 = G__42847;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_42884){
var state_val_42885 = (state_42884[(1)]);
if((state_val_42885 === (7))){
var inst_42857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42858 = [path];
var inst_42859 = (new cljs.core.PersistentVector(null,1,(5),inst_42857,inst_42858,null));
var state_42884__$1 = state_42884;
var statearr_42886_42914 = state_42884__$1;
(statearr_42886_42914[(2)] = inst_42859);

(statearr_42886_42914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (1))){
var state_42884__$1 = state_42884;
var statearr_42887_42915 = state_42884__$1;
(statearr_42887_42915[(2)] = null);

(statearr_42887_42915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (4))){
var inst_42848 = (state_42884[(2)]);
var state_42884__$1 = state_42884;
var statearr_42888_42916 = state_42884__$1;
(statearr_42888_42916[(2)] = inst_42848);

(statearr_42888_42916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (13))){
var inst_42875 = (state_42884[(2)]);
var inst_42876 = fluree.db.util.async.throw_err(inst_42875);
var _ = (function (){var statearr_42889 = state_42884;
(statearr_42889[(4)] = cljs.core.rest((state_42884[(4)])));

return statearr_42889;
})();
var state_42884__$1 = state_42884;
var statearr_42890_42917 = state_42884__$1;
(statearr_42890_42917[(2)] = inst_42876);

(statearr_42890_42917[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (6))){
var state_42884__$1 = state_42884;
var statearr_42892_42918 = state_42884__$1;
(statearr_42892_42918[(2)] = path);

(statearr_42892_42918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (3))){
var inst_42882 = (state_42884[(2)]);
var state_42884__$1 = state_42884;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42884__$1,inst_42882);
} else {
if((state_val_42885 === (12))){
var _ = (function (){var statearr_42893 = state_42884;
(statearr_42893[(4)] = cljs.core.rest((state_42884[(4)])));

return statearr_42893;
})();
var state_42884__$1 = state_42884;
var ex42891 = (state_42884__$1[(2)]);
var statearr_42894_42919 = state_42884__$1;
(statearr_42894_42919[(5)] = ex42891);


var statearr_42895_42920 = state_42884__$1;
(statearr_42895_42920[(1)] = (11));

(statearr_42895_42920[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (2))){
var _ = (function (){var statearr_42896 = state_42884;
(statearr_42896[(4)] = cljs.core.cons((5),(state_42884[(4)])));

return statearr_42896;
})();
var inst_42854 = cljs.core.vector_QMARK_(path);
var state_42884__$1 = state_42884;
if(inst_42854){
var statearr_42897_42921 = state_42884__$1;
(statearr_42897_42921[(1)] = (6));

} else {
var statearr_42898_42922 = state_42884__$1;
(statearr_42898_42922[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (11))){
var inst_42861 = (state_42884[(7)]);
var inst_42866 = (state_42884[(2)]);
var inst_42867 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42866,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_42861,endSubject], 0));
var state_42884__$1 = state_42884;
var statearr_42900_42923 = state_42884__$1;
(statearr_42900_42923[(2)] = inst_42867);

(statearr_42900_42923[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (9))){
var inst_42865 = (state_42884[(8)]);
var _ = (function (){var statearr_42901 = state_42884;
(statearr_42901[(4)] = cljs.core.cons((12),(state_42884[(4)])));

return statearr_42901;
})();
var inst_42873 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_42865);
var state_42884__$1 = state_42884;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42884__$1,(13),inst_42873);
} else {
if((state_val_42885 === (5))){
var _ = (function (){var statearr_42902 = state_42884;
(statearr_42902[(4)] = cljs.core.rest((state_42884[(4)])));

return statearr_42902;
})();
var state_42884__$1 = state_42884;
var ex42899 = (state_42884__$1[(2)]);
var statearr_42903_42924 = state_42884__$1;
(statearr_42903_42924[(5)] = ex42899);


if((ex42899 instanceof Error)){
var statearr_42904_42925 = state_42884__$1;
(statearr_42904_42925[(1)] = (4));

(statearr_42904_42925[(5)] = null);

} else {
throw ex42899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (10))){
var inst_42879 = (state_42884[(2)]);
var _ = (function (){var statearr_42905 = state_42884;
(statearr_42905[(4)] = cljs.core.rest((state_42884[(4)])));

return statearr_42905;
})();
var state_42884__$1 = state_42884;
var statearr_42906_42926 = state_42884__$1;
(statearr_42906_42926[(2)] = inst_42879);

(statearr_42906_42926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42885 === (8))){
var inst_42861 = (state_42884[(7)]);
var inst_42861__$1 = (state_42884[(2)]);
var inst_42862 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_42861__$1,endSubject);
var inst_42863 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_42864 = ["?var1",inst_42862];
var inst_42865 = cljs.core.PersistentHashMap.fromArrays(inst_42863,inst_42864);
var state_42884__$1 = (function (){var statearr_42907 = state_42884;
(statearr_42907[(7)] = inst_42861__$1);

(statearr_42907[(8)] = inst_42865);

return statearr_42907;
})();
var statearr_42908_42927 = state_42884__$1;
(statearr_42908_42927[(2)] = null);

(statearr_42908_42927[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_42909 = [null,null,null,null,null,null,null,null,null];
(statearr_42909[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_42909[(1)] = (1));

return statearr_42909;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_42884){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_42884);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e42910){var ex__2730__auto__ = e42910;
var statearr_42911_42928 = state_42884;
(statearr_42911_42928[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_42884[(4)]))){
var statearr_42912_42929 = state_42884;
(statearr_42912_42929[(1)] = cljs.core.first((state_42884[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42930 = state_42884;
state_42884 = G__42930;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_42884){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_42884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_42913 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_42913[(6)] = c__2749__auto__);

return statearr_42913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e42931){var e = e42931;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e42932){var e = e42932;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e42933){var e = e42933;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_42987){
var state_val_42988 = (state_42987[(1)]);
if((state_val_42988 === (7))){
var state_42987__$1 = state_42987;
var statearr_42989_43027 = state_42987__$1;
(statearr_42989_43027[(2)] = pred);

(statearr_42989_43027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (20))){
var inst_42966 = (state_42987[(7)]);
var inst_42970 = (state_42987[(8)]);
var inst_42974 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_42970,inst_42966);
var state_42987__$1 = state_42987;
var statearr_42990_43028 = state_42987__$1;
(statearr_42990_43028[(2)] = inst_42974);

(statearr_42990_43028[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (1))){
var state_42987__$1 = state_42987;
var statearr_42991_43029 = state_42987__$1;
(statearr_42991_43029[(2)] = null);

(statearr_42991_43029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (4))){
var inst_42934 = (state_42987[(2)]);
var state_42987__$1 = state_42987;
var statearr_42992_43030 = state_42987__$1;
(statearr_42992_43030[(2)] = inst_42934);

(statearr_42992_43030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (15))){
var state_42987__$1 = state_42987;
var statearr_42993_43031 = state_42987__$1;
(statearr_42993_43031[(2)] = fluree.db.flake.o);

(statearr_42993_43031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (21))){
var inst_42966 = (state_42987[(7)]);
var inst_42970 = (state_42987[(8)]);
var inst_42976 = cljs.core.first(inst_42966);
var inst_42977 = (inst_42970.cljs$core$IFn$_invoke$arity$1 ? inst_42970.cljs$core$IFn$_invoke$arity$1(inst_42976) : inst_42970.call(null,inst_42976));
var state_42987__$1 = state_42987;
var statearr_42994_43032 = state_42987__$1;
(statearr_42994_43032[(2)] = inst_42977);

(statearr_42994_43032[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (13))){
var inst_42963 = (state_42987[(2)]);
var inst_42964 = fluree.db.util.async.throw_err(inst_42963);
var state_42987__$1 = state_42987;
var statearr_42995_43033 = state_42987__$1;
(statearr_42995_43033[(2)] = inst_42964);

(statearr_42995_43033[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (22))){
var inst_42979 = (state_42987[(2)]);
var state_42987__$1 = state_42987;
var statearr_42996_43034 = state_42987__$1;
(statearr_42996_43034[(2)] = inst_42979);

(statearr_42996_43034[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (6))){
var inst_42944 = clojure.string.replace(pred,"/_","/");
var state_42987__$1 = state_42987;
var statearr_42997_43035 = state_42987__$1;
(statearr_42997_43035[(2)] = inst_42944);

(statearr_42997_43035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (17))){
var inst_42948 = (state_42987[(9)]);
var state_42987__$1 = state_42987;
if(cljs.core.truth_(inst_42948)){
var statearr_42998_43036 = state_42987__$1;
(statearr_42998_43036[(1)] = (20));

} else {
var statearr_42999_43037 = state_42987__$1;
(statearr_42999_43037[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (3))){
var inst_42985 = (state_42987[(2)]);
var state_42987__$1 = state_42987;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42987__$1,inst_42985);
} else {
if((state_val_42988 === (12))){
var inst_42955 = (state_42987[(2)]);
var inst_42956 = fluree.db.util.async.throw_err(inst_42955);
var state_42987__$1 = state_42987;
var statearr_43000_43038 = state_42987__$1;
(statearr_43000_43038[(2)] = inst_42956);

(statearr_43000_43038[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (2))){
var inst_42942 = (state_42987[(10)]);
var _ = (function (){var statearr_43001 = state_42987;
(statearr_43001[(4)] = cljs.core.cons((5),(state_42987[(4)])));

return statearr_43001;
})();
var inst_42940 = typeof pred === 'string';
var inst_42941 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_42942__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42940,inst_42941], 0));
var state_42987__$1 = (function (){var statearr_43002 = state_42987;
(statearr_43002[(10)] = inst_42942__$1);

return statearr_43002;
})();
if(cljs.core.truth_(inst_42942__$1)){
var statearr_43003_43039 = state_42987__$1;
(statearr_43003_43039[(1)] = (6));

} else {
var statearr_43004_43040 = state_42987__$1;
(statearr_43004_43040[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (19))){
var inst_42982 = (state_42987[(2)]);
var _ = (function (){var statearr_43005 = state_42987;
(statearr_43005[(4)] = cljs.core.rest((state_42987[(4)])));

return statearr_43005;
})();
var state_42987__$1 = state_42987;
var statearr_43006_43041 = state_42987__$1;
(statearr_43006_43041[(2)] = inst_42982);

(statearr_43006_43041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (11))){
var inst_42942 = (state_42987[(10)]);
var inst_42966 = (state_42987[(2)]);
var state_42987__$1 = (function (){var statearr_43008 = state_42987;
(statearr_43008[(7)] = inst_42966);

return statearr_43008;
})();
if(cljs.core.truth_(inst_42942)){
var statearr_43009_43042 = state_42987__$1;
(statearr_43009_43042[(1)] = (14));

} else {
var statearr_43010_43043 = state_42987__$1;
(statearr_43010_43043[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (9))){
var inst_42947 = (state_42987[(11)]);
var inst_42950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42951 = [sid,inst_42947];
var inst_42952 = (new cljs.core.PersistentVector(null,2,(5),inst_42950,inst_42951,null));
var inst_42953 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_42952);
var state_42987__$1 = state_42987;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42987__$1,(12),inst_42953);
} else {
if((state_val_42988 === (5))){
var _ = (function (){var statearr_43011 = state_42987;
(statearr_43011[(4)] = cljs.core.rest((state_42987[(4)])));

return statearr_43011;
})();
var state_42987__$1 = state_42987;
var ex43007 = (state_42987__$1[(2)]);
var statearr_43012_43044 = state_42987__$1;
(statearr_43012_43044[(5)] = ex43007);


if((ex43007 instanceof Error)){
var statearr_43013_43045 = state_42987__$1;
(statearr_43013_43045[(1)] = (4));

(statearr_43013_43045[(5)] = null);

} else {
throw ex43007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (14))){
var state_42987__$1 = state_42987;
var statearr_43014_43046 = state_42987__$1;
(statearr_43014_43046[(2)] = fluree.db.flake.s);

(statearr_43014_43046[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (16))){
var inst_42966 = (state_42987[(7)]);
var inst_42970 = (state_42987[(2)]);
var inst_42971 = cljs.core.seq(inst_42966);
var state_42987__$1 = (function (){var statearr_43015 = state_42987;
(statearr_43015[(8)] = inst_42970);

return statearr_43015;
})();
if(inst_42971){
var statearr_43016_43047 = state_42987__$1;
(statearr_43016_43047[(1)] = (17));

} else {
var statearr_43017_43048 = state_42987__$1;
(statearr_43017_43048[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (10))){
var inst_42947 = (state_42987[(11)]);
var inst_42958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42959 = [sid,inst_42947];
var inst_42960 = (new cljs.core.PersistentVector(null,2,(5),inst_42958,inst_42959,null));
var inst_42961 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_42960);
var state_42987__$1 = state_42987;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42987__$1,(13),inst_42961);
} else {
if((state_val_42988 === (18))){
var state_42987__$1 = state_42987;
var statearr_43018_43049 = state_42987__$1;
(statearr_43018_43049[(2)] = null);

(statearr_43018_43049[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42988 === (8))){
var inst_42947 = (state_42987[(11)]);
var inst_42942 = (state_42987[(10)]);
var inst_42947__$1 = (state_42987[(2)]);
var inst_42948 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_42947__$1);
var state_42987__$1 = (function (){var statearr_43019 = state_42987;
(statearr_43019[(11)] = inst_42947__$1);

(statearr_43019[(9)] = inst_42948);

return statearr_43019;
})();
if(cljs.core.truth_(inst_42942)){
var statearr_43020_43050 = state_42987__$1;
(statearr_43020_43050[(1)] = (9));

} else {
var statearr_43021_43051 = state_42987__$1;
(statearr_43021_43051[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0 = (function (){
var statearr_43022 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43022[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__);

(statearr_43022[(1)] = (1));

return statearr_43022;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1 = (function (state_42987){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_42987);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43023){var ex__2730__auto__ = e43023;
var statearr_43024_43052 = state_42987;
(statearr_43024_43052[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_42987[(4)]))){
var statearr_43025_43053 = state_42987;
(statearr_43025_43053[(1)] = cljs.core.first((state_42987[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43054 = state_42987;
state_42987 = G__43054;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = function(state_42987){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1.call(this,state_42987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43026 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43026[(6)] = c__2749__auto__);

return statearr_43026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e43055){var e = e43055;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43058 = arguments.length;
var i__5770__auto___43059 = (0);
while(true){
if((i__5770__auto___43059 < len__5769__auto___43058)){
args__5775__auto__.push((arguments[i__5770__auto___43059]));

var G__43060 = (i__5770__auto___43059 + (1));
i__5770__auto___43059 = G__43060;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e43057){var e = e43057;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq43056){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43056));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43063 = arguments.length;
var i__5770__auto___43064 = (0);
while(true){
if((i__5770__auto___43064 < len__5769__auto___43063)){
args__5775__auto__.push((arguments[i__5770__auto___43064]));

var G__43065 = (i__5770__auto___43064 + (1));
i__5770__auto___43064 = G__43065;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e43062){var e = e43062;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq43061){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43061));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43068 = arguments.length;
var i__5770__auto___43069 = (0);
while(true){
if((i__5770__auto___43069 < len__5769__auto___43068)){
args__5775__auto__.push((arguments[i__5770__auto___43069]));

var G__43070 = (i__5770__auto___43069 + (1));
i__5770__auto___43069 = G__43070;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e43067){var e = e43067;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq43066){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43066));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43073 = arguments.length;
var i__5770__auto___43074 = (0);
while(true){
if((i__5770__auto___43074 < len__5769__auto___43073)){
args__5775__auto__.push((arguments[i__5770__auto___43074]));

var G__43075 = (i__5770__auto___43074 + (1));
i__5770__auto___43074 = G__43075;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e43072){var e = e43072;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq43071){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43071));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e43076){var e = e43076;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e43077){var e = e43077;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e43078){var e = e43078;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e43079){var e = e43079;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e43080){var e = e43080;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__43086 = path;
var vec__43087 = G__43086;
var seq__43088 = cljs.core.seq(vec__43087);
var first__43089 = cljs.core.first(seq__43088);
var seq__43088__$1 = cljs.core.next(seq__43088);
var pred = first__43089;
var r = seq__43088__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__43086__$1 = G__43086;
var subjects__$1 = subjects;
while(true){
var vec__43093 = G__43086__$1;
var seq__43094 = cljs.core.seq(vec__43093);
var first__43095 = cljs.core.first(seq__43094);
var seq__43094__$1 = cljs.core.next(seq__43094);
var pred__$1 = first__43095;
var r__$1 = seq__43094__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__43086__$1,subjects__$1,vec__43093,seq__43094,first__43095,seq__43094__$1,pred__$1,r__$1,subjects__$2,G__43086,vec__43087,seq__43088,first__43089,seq__43088__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__43086__$1,subjects__$1,vec__43093,seq__43094,first__43095,seq__43094__$1,pred__$1,r__$1,subjects__$2,G__43086,vec__43087,seq__43088,first__43089,seq__43088__$1,pred,r,subjects){
return (function (p1__43081_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__43081_SHARP_,pred__$1);
});})(G__43086__$1,subjects__$1,vec__43093,seq__43094,first__43095,seq__43094__$1,pred__$1,r__$1,subjects__$2,G__43086,vec__43087,seq__43088,first__43089,seq__43088__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__43086__$1,subjects__$1,vec__43093,seq__43094,first__43095,seq__43094__$1,pred__$1,r__$1,subjects__$2,G__43086,vec__43087,seq__43088,first__43089,seq__43088__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__43096 = r__$1;
var G__43097 = next_subjects;
G__43086__$1 = G__43096;
subjects__$1 = G__43097;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e43082){var e = e43082;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43137){
var state_val_43138 = (state_43137[(1)]);
if((state_val_43138 === (7))){
var state_43137__$1 = state_43137;
var statearr_43139_43158 = state_43137__$1;
(statearr_43139_43158[(2)] = path);

(statearr_43139_43158[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43138 === (1))){
var state_43137__$1 = state_43137;
var statearr_43140_43159 = state_43137__$1;
(statearr_43140_43159[(2)] = null);

(statearr_43140_43159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43138 === (4))){
var inst_43098 = (state_43137[(2)]);
var inst_43099 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43098,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_43137__$1 = state_43137;
var statearr_43141_43160 = state_43137__$1;
(statearr_43141_43160[(2)] = inst_43099);

(statearr_43141_43160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43138 === (6))){
var inst_43116 = (state_43137[(2)]);
var inst_43117 = fluree.db.util.async.throw_err(inst_43116);
var inst_43118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43117,(0),null);
var inst_43119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43117,(1),null);
var inst_43120 = cljs.core.last(path);
var inst_43121 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_43120);
var state_43137__$1 = (function (){var statearr_43142 = state_43137;
(statearr_43142[(7)] = inst_43118);

(statearr_43142[(8)] = inst_43119);

return statearr_43142;
})();
if(inst_43121){
var statearr_43143_43161 = state_43137__$1;
(statearr_43143_43161[(1)] = (7));

} else {
var statearr_43144_43162 = state_43137__$1;
(statearr_43144_43162[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43138 === (3))){
var inst_43135 = (state_43137[(2)]);
var state_43137__$1 = state_43137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43137__$1,inst_43135);
} else {
if((state_val_43138 === (2))){
var _ = (function (){var statearr_43146 = state_43137;
(statearr_43146[(4)] = cljs.core.cons((5),(state_43137[(4)])));

return statearr_43146;
})();
var inst_43108 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_43109 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43110 = cljs.core.PersistentHashMap.EMPTY;
var inst_43111 = [inst_43108,sid,inst_43110];
var inst_43112 = cljs.core.PersistentHashMap.fromArrays(inst_43109,inst_43111);
var inst_43113 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43114 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43113,inst_43112);
var state_43137__$1 = state_43137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43137__$1,(6),inst_43114);
} else {
if((state_val_43138 === (9))){
var inst_43118 = (state_43137[(7)]);
var inst_43119 = (state_43137[(8)]);
var inst_43126 = (state_43137[(2)]);
var inst_43127 = fluree.db.dbfunctions.internal.get_all(inst_43118,inst_43126);
var inst_43128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43129 = fluree.db.dbfunctions.internal.count(path);
var inst_43130 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43119,inst_43129,(9)], 0));
var inst_43131 = [inst_43127,inst_43130];
var inst_43132 = (new cljs.core.PersistentVector(null,2,(5),inst_43128,inst_43131,null));
var _ = (function (){var statearr_43147 = state_43137;
(statearr_43147[(4)] = cljs.core.rest((state_43137[(4)])));

return statearr_43147;
})();
var state_43137__$1 = state_43137;
var statearr_43148_43163 = state_43137__$1;
(statearr_43148_43163[(2)] = inst_43132);

(statearr_43148_43163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43138 === (5))){
var _ = (function (){var statearr_43149 = state_43137;
(statearr_43149[(4)] = cljs.core.rest((state_43137[(4)])));

return statearr_43149;
})();
var state_43137__$1 = state_43137;
var ex43145 = (state_43137__$1[(2)]);
var statearr_43150_43164 = state_43137__$1;
(statearr_43150_43164[(5)] = ex43145);


var statearr_43151_43165 = state_43137__$1;
(statearr_43151_43165[(1)] = (4));

(statearr_43151_43165[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43138 === (8))){
var inst_43124 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_43137__$1 = state_43137;
var statearr_43152_43166 = state_43137__$1;
(statearr_43152_43166[(2)] = inst_43124);

(statearr_43152_43166[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0 = (function (){
var statearr_43153 = [null,null,null,null,null,null,null,null,null];
(statearr_43153[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__);

(statearr_43153[(1)] = (1));

return statearr_43153;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1 = (function (state_43137){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43137);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43154){var ex__2730__auto__ = e43154;
var statearr_43155_43167 = state_43137;
(statearr_43155_43167[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43137[(4)]))){
var statearr_43156_43168 = state_43137;
(statearr_43156_43168[(1)] = cljs.core.first((state_43137[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43169 = state_43137;
state_43137 = G__43169;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = function(state_43137){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1.call(this,state_43137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43157 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43157[(6)] = c__2749__auto__);

return statearr_43157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e43170){var e = e43170;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__43171_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__43171_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__43171_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e43172){var e = e43172;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43175 = arguments.length;
var i__5770__auto___43176 = (0);
while(true){
if((i__5770__auto___43176 < len__5769__auto___43175)){
args__5775__auto__.push((arguments[i__5770__auto___43176]));

var G__43177 = (i__5770__auto___43176 + (1));
i__5770__auto___43176 = G__43177;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e43174){var e = e43174;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq43173){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43173));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e43178){var e = e43178;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___43181 = arguments.length;
var i__5770__auto___43182 = (0);
while(true){
if((i__5770__auto___43182 < len__5769__auto___43181)){
args__5775__auto__.push((arguments[i__5770__auto___43182]));

var G__43183 = (i__5770__auto___43182 + (1));
i__5770__auto___43182 = G__43183;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e43180){var e = e43180;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq43179){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43179));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e43184){var e = e43184;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43241){
var state_val_43242 = (state_43241[(1)]);
if((state_val_43242 === (7))){
var inst_43187 = (state_43241[(2)]);
var state_43241__$1 = state_43241;
var statearr_43243_43277 = state_43241__$1;
(statearr_43243_43277[(2)] = inst_43187);

(statearr_43243_43277[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (1))){
var state_43241__$1 = state_43241;
var statearr_43244_43278 = state_43241__$1;
(statearr_43244_43278[(2)] = null);

(statearr_43244_43278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (4))){
var inst_43186 = (state_43241[(2)]);
var state_43241__$1 = (function (){var statearr_43245 = state_43241;
(statearr_43245[(7)] = inst_43186);

return statearr_43245;
})();
var statearr_43246_43279 = state_43241__$1;
(statearr_43246_43279[(2)] = null);

(statearr_43246_43279[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (15))){
var inst_43209 = (state_43241[(8)]);
var inst_43211 = (state_43241[(9)]);
var inst_43212 = (state_43241[(10)]);
var inst_43224 = (state_43241[(11)]);
var inst_43222 = (state_43241[(12)]);
var inst_43221 = (state_43241[(13)]);
var inst_43228 = (function (){var db = inst_43209;
var prevT = inst_43211;
var db_SINGLEQUOTE_ = inst_43212;
var prev_vals = inst_43221;
var fuel = inst_43222;
var G__43223 = inst_43224;
return (function (p1__43185_SHARP_){
var f = p1__43185_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_43229 = (inst_43228.cljs$core$IFn$_invoke$arity$1 ? inst_43228.cljs$core$IFn$_invoke$arity$1(inst_43224) : inst_43228.call(null,inst_43224));
var state_43241__$1 = state_43241;
var statearr_43247_43280 = state_43241__$1;
(statearr_43247_43280[(2)] = inst_43229);

(statearr_43247_43280[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (13))){
var inst_43224 = (state_43241[(11)]);
var inst_43221 = (state_43241[(13)]);
var inst_43220 = (state_43241[(2)]);
var inst_43221__$1 = fluree.db.util.async.throw_err(inst_43220);
var inst_43222 = fluree.db.dbfunctions.internal.count(inst_43221__$1);
var inst_43224__$1 = cljs.core.first(inst_43221__$1);
var inst_43225 = (inst_43224__$1 == null);
var state_43241__$1 = (function (){var statearr_43248 = state_43241;
(statearr_43248[(11)] = inst_43224__$1);

(statearr_43248[(12)] = inst_43222);

(statearr_43248[(13)] = inst_43221__$1);

return statearr_43248;
})();
if(cljs.core.truth_(inst_43225)){
var statearr_43249_43281 = state_43241__$1;
(statearr_43249_43281[(1)] = (14));

} else {
var statearr_43250_43282 = state_43241__$1;
(statearr_43250_43282[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (6))){
var inst_43196 = (state_43241[(2)]);
var state_43241__$1 = state_43241;
var statearr_43251_43283 = state_43241__$1;
(statearr_43251_43283[(2)] = inst_43196);

(statearr_43251_43283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (3))){
var inst_43239 = (state_43241[(2)]);
var state_43241__$1 = state_43241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43241__$1,inst_43239);
} else {
if((state_val_43242 === (12))){
var inst_43236 = (state_43241[(2)]);
var _ = (function (){var statearr_43252 = state_43241;
(statearr_43252[(4)] = cljs.core.rest((state_43241[(4)])));

return statearr_43252;
})();
var state_43241__$1 = state_43241;
var statearr_43253_43284 = state_43241__$1;
(statearr_43253_43284[(2)] = inst_43236);

(statearr_43253_43284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (2))){
var _ = (function (){var statearr_43255 = state_43241;
(statearr_43255[(4)] = cljs.core.cons((9),(state_43241[(4)])));

return statearr_43255;
})();
var inst_43202 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43203 = typeof inst_43202 === 'string';
var state_43241__$1 = state_43241;
if(cljs.core.truth_(inst_43203)){
var statearr_43256_43285 = state_43241__$1;
(statearr_43256_43285[(1)] = (10));

} else {
var statearr_43257_43286 = state_43241__$1;
(statearr_43257_43286[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (11))){
var inst_43209 = (state_43241[(8)]);
var inst_43211 = (state_43241[(9)]);
var inst_43212 = (state_43241[(10)]);
var inst_43209__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43210 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_43209__$1);
var inst_43211__$1 = fluree.db.dbfunctions.internal.inc(inst_43210);
var inst_43212__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43209__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_43211__$1);
var inst_43213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43214 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43215 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43216 = [inst_43214,inst_43215];
var inst_43217 = (new cljs.core.PersistentVector(null,2,(5),inst_43213,inst_43216,null));
var inst_43218 = fluree.db.dbproto._search(inst_43212__$1,inst_43217);
var state_43241__$1 = (function (){var statearr_43258 = state_43241;
(statearr_43258[(8)] = inst_43209__$1);

(statearr_43258[(9)] = inst_43211__$1);

(statearr_43258[(10)] = inst_43212__$1);

return statearr_43258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43241__$1,(13),inst_43218);
} else {
if((state_val_43242 === (9))){
var _ = (function (){var statearr_43259 = state_43241;
(statearr_43259[(4)] = cljs.core.rest((state_43241[(4)])));

return statearr_43259;
})();
var state_43241__$1 = state_43241;
var ex43254 = (state_43241__$1[(2)]);
var statearr_43260_43287 = state_43241__$1;
(statearr_43260_43287[(5)] = ex43254);


var statearr_43261_43288 = state_43241__$1;
(statearr_43261_43288[(1)] = (4));

(statearr_43261_43288[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (5))){
var inst_43186 = (state_43241[(7)]);
var _ = (function (){var statearr_43262 = state_43241;
(statearr_43262[(4)] = cljs.core.cons((8),(state_43241[(4)])));

return statearr_43262;
})();
var inst_43193 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43186,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_43263 = state_43241;
(statearr_43263[(4)] = cljs.core.rest((state_43241[(4)])));

return statearr_43263;
})();
var state_43241__$1 = state_43241;
var statearr_43264_43289 = state_43241__$1;
(statearr_43264_43289[(2)] = inst_43193);

(statearr_43264_43289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (14))){
var state_43241__$1 = state_43241;
var statearr_43265_43290 = state_43241__$1;
(statearr_43265_43290[(2)] = null);

(statearr_43265_43290[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (16))){
var inst_43222 = (state_43241[(12)]);
var inst_43231 = (state_43241[(2)]);
var inst_43232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43233 = [inst_43231,inst_43222];
var inst_43234 = (new cljs.core.PersistentVector(null,2,(5),inst_43232,inst_43233,null));
var state_43241__$1 = state_43241;
var statearr_43267_43291 = state_43241__$1;
(statearr_43267_43291[(2)] = inst_43234);

(statearr_43267_43291[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (10))){
var inst_43205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43206 = [null,(0)];
var inst_43207 = (new cljs.core.PersistentVector(null,2,(5),inst_43205,inst_43206,null));
var state_43241__$1 = state_43241;
var statearr_43268_43292 = state_43241__$1;
(statearr_43268_43292[(2)] = inst_43207);

(statearr_43268_43292[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43242 === (8))){
var _ = (function (){var statearr_43269 = state_43241;
(statearr_43269[(4)] = cljs.core.rest((state_43241[(4)])));

return statearr_43269;
})();
var state_43241__$1 = state_43241;
var ex43266 = (state_43241__$1[(2)]);
var statearr_43270_43293 = state_43241__$1;
(statearr_43270_43293[(5)] = ex43266);


var statearr_43271_43294 = state_43241__$1;
(statearr_43271_43294[(1)] = (7));

(statearr_43271_43294[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_43272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43272[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_43272[(1)] = (1));

return statearr_43272;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_43241){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43241);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43273){var ex__2730__auto__ = e43273;
var statearr_43274_43295 = state_43241;
(statearr_43274_43295[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43241[(4)]))){
var statearr_43275_43296 = state_43241;
(statearr_43275_43296[(1)] = cljs.core.first((state_43241[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43297 = state_43241;
state_43241 = G__43297;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_43241){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_43241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43276 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43276[(6)] = c__2749__auto__);

return statearr_43276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43349){
var state_val_43350 = (state_43349[(1)]);
if((state_val_43350 === (7))){
var inst_43299 = (state_43349[(2)]);
var state_43349__$1 = state_43349;
var statearr_43351_43380 = state_43349__$1;
(statearr_43351_43380[(2)] = inst_43299);

(statearr_43351_43380[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (1))){
var state_43349__$1 = state_43349;
var statearr_43352_43381 = state_43349__$1;
(statearr_43352_43381[(2)] = null);

(statearr_43352_43381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (4))){
var inst_43298 = (state_43349[(2)]);
var state_43349__$1 = (function (){var statearr_43353 = state_43349;
(statearr_43353[(7)] = inst_43298);

return statearr_43353;
})();
var statearr_43354_43382 = state_43349__$1;
(statearr_43354_43382[(2)] = null);

(statearr_43354_43382[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (13))){
var inst_43344 = (state_43349[(2)]);
var _ = (function (){var statearr_43355 = state_43349;
(statearr_43355[(4)] = cljs.core.rest((state_43349[(4)])));

return statearr_43355;
})();
var state_43349__$1 = state_43349;
var statearr_43356_43383 = state_43349__$1;
(statearr_43356_43383[(2)] = inst_43344);

(statearr_43356_43383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (6))){
var inst_43308 = (state_43349[(2)]);
var state_43349__$1 = state_43349;
var statearr_43357_43384 = state_43349__$1;
(statearr_43357_43384[(2)] = inst_43308);

(statearr_43357_43384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (3))){
var inst_43347 = (state_43349[(2)]);
var state_43349__$1 = state_43349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43349__$1,inst_43347);
} else {
if((state_val_43350 === (12))){
var inst_43331 = (state_43349[(8)]);
var inst_43340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43341 = [null,inst_43331];
var inst_43342 = (new cljs.core.PersistentVector(null,2,(5),inst_43340,inst_43341,null));
var state_43349__$1 = state_43349;
var statearr_43358_43385 = state_43349__$1;
(statearr_43358_43385[(2)] = inst_43342);

(statearr_43358_43385[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (2))){
var _ = (function (){var statearr_43360 = state_43349;
(statearr_43360[(4)] = cljs.core.cons((9),(state_43349[(4)])));

return statearr_43360;
})();
var inst_43317 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43320 = [null,pred_name,"?o"];
var inst_43321 = (new cljs.core.PersistentVector(null,3,(5),inst_43319,inst_43320,null));
var inst_43322 = [inst_43321];
var inst_43323 = (new cljs.core.PersistentVector(null,1,(5),inst_43318,inst_43322,null));
var inst_43324 = ["?o",inst_43323,opts];
var inst_43325 = cljs.core.PersistentHashMap.fromArrays(inst_43317,inst_43324);
var inst_43326 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_43325);
var state_43349__$1 = state_43349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43349__$1,(10),inst_43326);
} else {
if((state_val_43350 === (11))){
var inst_43330 = (state_43349[(9)]);
var inst_43331 = (state_43349[(8)]);
var inst_43335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43336 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_43330);
var inst_43337 = [inst_43336,inst_43331];
var inst_43338 = (new cljs.core.PersistentVector(null,2,(5),inst_43335,inst_43337,null));
var state_43349__$1 = state_43349;
var statearr_43361_43386 = state_43349__$1;
(statearr_43361_43386[(2)] = inst_43338);

(statearr_43361_43386[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (9))){
var _ = (function (){var statearr_43362 = state_43349;
(statearr_43362[(4)] = cljs.core.rest((state_43349[(4)])));

return statearr_43362;
})();
var state_43349__$1 = state_43349;
var ex43359 = (state_43349__$1[(2)]);
var statearr_43363_43387 = state_43349__$1;
(statearr_43363_43387[(5)] = ex43359);


var statearr_43364_43388 = state_43349__$1;
(statearr_43364_43388[(1)] = (4));

(statearr_43364_43388[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (5))){
var inst_43298 = (state_43349[(7)]);
var _ = (function (){var statearr_43366 = state_43349;
(statearr_43366[(4)] = cljs.core.cons((8),(state_43349[(4)])));

return statearr_43366;
})();
var inst_43305 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43298,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_43367 = state_43349;
(statearr_43367[(4)] = cljs.core.rest((state_43349[(4)])));

return statearr_43367;
})();
var state_43349__$1 = state_43349;
var statearr_43368_43389 = state_43349__$1;
(statearr_43368_43389[(2)] = inst_43305);

(statearr_43368_43389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (10))){
var inst_43330 = (state_43349[(9)]);
var inst_43328 = (state_43349[(2)]);
var inst_43329 = fluree.db.util.async.throw_err(inst_43328);
var inst_43330__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43329,(0),null);
var inst_43331 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43329,(1),null);
var inst_43332 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_43330__$1);
var inst_43333 = cljs.core.not(inst_43332);
var state_43349__$1 = (function (){var statearr_43369 = state_43349;
(statearr_43369[(9)] = inst_43330__$1);

(statearr_43369[(8)] = inst_43331);

return statearr_43369;
})();
if(inst_43333){
var statearr_43370_43390 = state_43349__$1;
(statearr_43370_43390[(1)] = (11));

} else {
var statearr_43371_43391 = state_43349__$1;
(statearr_43371_43391[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43350 === (8))){
var _ = (function (){var statearr_43372 = state_43349;
(statearr_43372[(4)] = cljs.core.rest((state_43349[(4)])));

return statearr_43372;
})();
var state_43349__$1 = state_43349;
var ex43365 = (state_43349__$1[(2)]);
var statearr_43373_43392 = state_43349__$1;
(statearr_43373_43392[(5)] = ex43365);


var statearr_43374_43393 = state_43349__$1;
(statearr_43374_43393[(1)] = (7));

(statearr_43374_43393[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_43375 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43375[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_43375[(1)] = (1));

return statearr_43375;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_43349){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43349);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43376){var ex__2730__auto__ = e43376;
var statearr_43377_43394 = state_43349;
(statearr_43377_43394[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43349[(4)]))){
var statearr_43378_43395 = state_43349;
(statearr_43378_43395[(1)] = cljs.core.first((state_43349[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43396 = state_43349;
state_43349 = G__43396;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_43349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_43349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43379 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43379[(6)] = c__2749__auto__);

return statearr_43379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e43397){var e = e43397;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__43399 = arguments.length;
switch (G__43399) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43469){
var state_val_43470 = (state_43469[(1)]);
if((state_val_43470 === (7))){
var inst_43401 = (state_43469[(2)]);
var state_43469__$1 = state_43469;
var statearr_43471_43515 = state_43469__$1;
(statearr_43471_43515[(2)] = inst_43401);

(statearr_43471_43515[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (20))){
var inst_43445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43446 = ["*"];
var inst_43447 = (new cljs.core.PersistentVector(null,1,(5),inst_43445,inst_43446,null));
var state_43469__$1 = state_43469;
var statearr_43472_43516 = state_43469__$1;
(statearr_43472_43516[(2)] = inst_43447);

(statearr_43472_43516[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (1))){
var state_43469__$1 = state_43469;
var statearr_43473_43517 = state_43469__$1;
(statearr_43473_43517[(2)] = null);

(statearr_43473_43517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (4))){
var inst_43400 = (state_43469[(2)]);
var state_43469__$1 = (function (){var statearr_43474 = state_43469;
(statearr_43474[(7)] = inst_43400);

return statearr_43474;
})();
var statearr_43475_43518 = state_43469__$1;
(statearr_43475_43518[(2)] = null);

(statearr_43475_43518[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (15))){
var inst_43464 = (state_43469[(2)]);
var _ = (function (){var statearr_43476 = state_43469;
(statearr_43476[(4)] = cljs.core.rest((state_43469[(4)])));

return statearr_43476;
})();
var state_43469__$1 = state_43469;
var statearr_43477_43519 = state_43469__$1;
(statearr_43477_43519[(2)] = inst_43464);

(statearr_43477_43519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (21))){
var inst_43435 = (state_43469[(8)]);
var inst_43428 = (state_43469[(9)]);
var inst_43449 = (state_43469[(2)]);
var inst_43450 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43451 = cljs.core.PersistentHashMap.EMPTY;
var inst_43452 = [inst_43449,inst_43435,inst_43451];
var inst_43453 = cljs.core.PersistentHashMap.fromArrays(inst_43450,inst_43452);
var inst_43454 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43428,inst_43453);
var state_43469__$1 = state_43469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43469__$1,(22),inst_43454);
} else {
if((state_val_43470 === (13))){
var inst_43423 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43469__$1 = state_43469;
var statearr_43478_43520 = state_43469__$1;
(statearr_43478_43520[(2)] = inst_43423);

(statearr_43478_43520[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (22))){
var inst_43456 = (state_43469[(2)]);
var inst_43457 = fluree.db.util.async.throw_err(inst_43456);
var inst_43458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43457,(0),null);
var inst_43459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43457,(1),null);
var inst_43460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43461 = [inst_43458,inst_43459];
var inst_43462 = (new cljs.core.PersistentVector(null,2,(5),inst_43460,inst_43461,null));
var state_43469__$1 = state_43469;
var statearr_43479_43521 = state_43469__$1;
(statearr_43479_43521[(2)] = inst_43462);

(statearr_43479_43521[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (6))){
var inst_43410 = (state_43469[(2)]);
var state_43469__$1 = state_43469;
var statearr_43480_43522 = state_43469__$1;
(statearr_43480_43522[(2)] = inst_43410);

(statearr_43480_43522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (17))){
var inst_43432 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43433 = fluree.db.dbfunctions.internal.get(inst_43432,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_43469__$1 = state_43469;
var statearr_43481_43523 = state_43469__$1;
(statearr_43481_43523[(2)] = inst_43433);

(statearr_43481_43523[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (3))){
var inst_43467 = (state_43469[(2)]);
var state_43469__$1 = state_43469;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43469__$1,inst_43467);
} else {
if((state_val_43470 === (12))){
var inst_43421 = (state_43469[(2)]);
var state_43469__$1 = state_43469;
if(cljs.core.truth_(inst_43421)){
var statearr_43482_43524 = state_43469__$1;
(statearr_43482_43524[(1)] = (13));

} else {
var statearr_43483_43525 = state_43469__$1;
(statearr_43483_43525[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (2))){
var inst_43416 = (state_43469[(10)]);
var _ = (function (){var statearr_43484 = state_43469;
(statearr_43484[(4)] = cljs.core.cons((9),(state_43469[(4)])));

return statearr_43484;
})();
var inst_43416__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43469__$1 = (function (){var statearr_43485 = state_43469;
(statearr_43485[(10)] = inst_43416__$1);

return statearr_43485;
})();
if(cljs.core.truth_(inst_43416__$1)){
var statearr_43486_43526 = state_43469__$1;
(statearr_43486_43526[(1)] = (10));

} else {
var statearr_43487_43527 = state_43469__$1;
(statearr_43487_43527[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (19))){
var inst_43437 = cljs.core.PersistentVector.EMPTY;
var inst_43438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43439 = ["*"];
var inst_43440 = (new cljs.core.PersistentVector(null,1,(5),inst_43438,inst_43439,null));
var inst_43441 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_43442 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_43440,inst_43441);
var inst_43443 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_43437,inst_43442);
var state_43469__$1 = state_43469;
var statearr_43489_43528 = state_43469__$1;
(statearr_43489_43528[(2)] = inst_43443);

(statearr_43489_43528[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (11))){
var inst_43416 = (state_43469[(10)]);
var state_43469__$1 = state_43469;
var statearr_43490_43529 = state_43469__$1;
(statearr_43490_43529[(2)] = inst_43416);

(statearr_43490_43529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (9))){
var _ = (function (){var statearr_43491 = state_43469;
(statearr_43491[(4)] = cljs.core.rest((state_43469[(4)])));

return statearr_43491;
})();
var state_43469__$1 = state_43469;
var ex43488 = (state_43469__$1[(2)]);
var statearr_43492_43530 = state_43469__$1;
(statearr_43492_43530[(5)] = ex43488);


var statearr_43493_43531 = state_43469__$1;
(statearr_43493_43531[(1)] = (4));

(statearr_43493_43531[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (5))){
var inst_43400 = (state_43469[(7)]);
var _ = (function (){var statearr_43494 = state_43469;
(statearr_43494[(4)] = cljs.core.cons((8),(state_43469[(4)])));

return statearr_43494;
})();
var inst_43407 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43400,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_43495 = state_43469;
(statearr_43495[(4)] = cljs.core.rest((state_43469[(4)])));

return statearr_43495;
})();
var state_43469__$1 = state_43469;
var statearr_43496_43532 = state_43469__$1;
(statearr_43496_43532[(2)] = inst_43407);

(statearr_43496_43532[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (14))){
var inst_43429 = (state_43469[(11)]);
var inst_43428 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43429__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43469__$1 = (function (){var statearr_43497 = state_43469;
(statearr_43497[(9)] = inst_43428);

(statearr_43497[(11)] = inst_43429__$1);

return statearr_43497;
})();
if(cljs.core.truth_(inst_43429__$1)){
var statearr_43498_43533 = state_43469__$1;
(statearr_43498_43533[(1)] = (16));

} else {
var statearr_43499_43534 = state_43469__$1;
(statearr_43499_43534[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (16))){
var inst_43429 = (state_43469[(11)]);
var state_43469__$1 = state_43469;
var statearr_43500_43535 = state_43469__$1;
(statearr_43500_43535[(2)] = inst_43429);

(statearr_43500_43535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (10))){
var inst_43418 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_43469__$1 = state_43469;
var statearr_43502_43536 = state_43469__$1;
(statearr_43502_43536[(2)] = inst_43418);

(statearr_43502_43536[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (18))){
var inst_43435 = (state_43469[(2)]);
var state_43469__$1 = (function (){var statearr_43503 = state_43469;
(statearr_43503[(8)] = inst_43435);

return statearr_43503;
})();
if(cljs.core.truth_(additional_params)){
var statearr_43504_43537 = state_43469__$1;
(statearr_43504_43537[(1)] = (19));

} else {
var statearr_43505_43538 = state_43469__$1;
(statearr_43505_43538[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43470 === (8))){
var _ = (function (){var statearr_43506 = state_43469;
(statearr_43506[(4)] = cljs.core.rest((state_43469[(4)])));

return statearr_43506;
})();
var state_43469__$1 = state_43469;
var ex43501 = (state_43469__$1[(2)]);
var statearr_43507_43539 = state_43469__$1;
(statearr_43507_43539[(5)] = ex43501);


var statearr_43508_43540 = state_43469__$1;
(statearr_43508_43540[(1)] = (7));

(statearr_43508_43540[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_43509 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43509[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_43509[(1)] = (1));

return statearr_43509;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_43469){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43469);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43510){var ex__2730__auto__ = e43510;
var statearr_43511_43541 = state_43469;
(statearr_43511_43541[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43469[(4)]))){
var statearr_43512_43542 = state_43469;
(statearr_43512_43542[(1)] = cljs.core.first((state_43469[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43543 = state_43469;
state_43469 = G__43543;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_43469){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_43469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43513 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43513[(6)] = c__2749__auto__);

return statearr_43513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__43545 = arguments.length;
switch (G__43545) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43589){
var state_val_43590 = (state_43589[(1)]);
if((state_val_43590 === (7))){
var inst_43567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43568 = ["*"];
var inst_43569 = (new cljs.core.PersistentVector(null,1,(5),inst_43567,inst_43568,null));
var state_43589__$1 = state_43589;
var statearr_43591_43611 = state_43589__$1;
(statearr_43591_43611[(2)] = inst_43569);

(statearr_43591_43611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (1))){
var state_43589__$1 = state_43589;
var statearr_43592_43612 = state_43589__$1;
(statearr_43592_43612[(2)] = null);

(statearr_43592_43612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (4))){
var inst_43546 = (state_43589[(2)]);
var inst_43547 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43546,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_43589__$1 = state_43589;
var statearr_43593_43613 = state_43589__$1;
(statearr_43593_43613[(2)] = inst_43547);

(statearr_43593_43613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (6))){
var inst_43559 = cljs.core.PersistentVector.EMPTY;
var inst_43560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43561 = ["*"];
var inst_43562 = (new cljs.core.PersistentVector(null,1,(5),inst_43560,inst_43561,null));
var inst_43563 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_43564 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_43562,inst_43563);
var inst_43565 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_43559,inst_43564);
var state_43589__$1 = state_43589;
var statearr_43594_43614 = state_43589__$1;
(statearr_43594_43614[(2)] = inst_43565);

(statearr_43594_43614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (3))){
var inst_43587 = (state_43589[(2)]);
var state_43589__$1 = state_43589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43589__$1,inst_43587);
} else {
if((state_val_43590 === (2))){
var _ = (function (){var statearr_43596 = state_43589;
(statearr_43596[(4)] = cljs.core.cons((5),(state_43589[(4)])));

return statearr_43596;
})();
var inst_43556 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43557 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43589__$1 = (function (){var statearr_43597 = state_43589;
(statearr_43597[(7)] = inst_43556);

(statearr_43597[(8)] = inst_43557);

return statearr_43597;
})();
if(cljs.core.truth_(additional_params)){
var statearr_43598_43615 = state_43589__$1;
(statearr_43598_43615[(1)] = (6));

} else {
var statearr_43599_43616 = state_43589__$1;
(statearr_43599_43616[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (9))){
var inst_43578 = (state_43589[(2)]);
var inst_43579 = fluree.db.util.async.throw_err(inst_43578);
var inst_43580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43579,(0),null);
var inst_43581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43579,(1),null);
var inst_43582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43583 = [inst_43580,inst_43581];
var inst_43584 = (new cljs.core.PersistentVector(null,2,(5),inst_43582,inst_43583,null));
var _ = (function (){var statearr_43600 = state_43589;
(statearr_43600[(4)] = cljs.core.rest((state_43589[(4)])));

return statearr_43600;
})();
var state_43589__$1 = state_43589;
var statearr_43601_43617 = state_43589__$1;
(statearr_43601_43617[(2)] = inst_43584);

(statearr_43601_43617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (5))){
var _ = (function (){var statearr_43602 = state_43589;
(statearr_43602[(4)] = cljs.core.rest((state_43589[(4)])));

return statearr_43602;
})();
var state_43589__$1 = state_43589;
var ex43595 = (state_43589__$1[(2)]);
var statearr_43603_43618 = state_43589__$1;
(statearr_43603_43618[(5)] = ex43595);


var statearr_43604_43619 = state_43589__$1;
(statearr_43604_43619[(1)] = (4));

(statearr_43604_43619[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43590 === (8))){
var inst_43556 = (state_43589[(7)]);
var inst_43557 = (state_43589[(8)]);
var inst_43571 = (state_43589[(2)]);
var inst_43572 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43573 = cljs.core.PersistentHashMap.EMPTY;
var inst_43574 = [inst_43571,inst_43557,inst_43573];
var inst_43575 = cljs.core.PersistentHashMap.fromArrays(inst_43572,inst_43574);
var inst_43576 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43556,inst_43575);
var state_43589__$1 = state_43589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43589__$1,(9),inst_43576);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_43605 = [null,null,null,null,null,null,null,null,null];
(statearr_43605[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_43605[(1)] = (1));

return statearr_43605;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_43589){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43589);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43606){var ex__2730__auto__ = e43606;
var statearr_43607_43620 = state_43589;
(statearr_43607_43620[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43589[(4)]))){
var statearr_43608_43621 = state_43589;
(statearr_43608_43621[(1)] = cljs.core.first((state_43589[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43622 = state_43589;
state_43589 = G__43622;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_43589){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_43589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43609 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43609[(6)] = c__2749__auto__);

return statearr_43609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43666){
var state_val_43667 = (state_43666[(1)]);
if((state_val_43667 === (1))){
var state_43666__$1 = state_43666;
var statearr_43668_43682 = state_43666__$1;
(statearr_43668_43682[(2)] = null);

(statearr_43668_43682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43667 === (2))){
var _ = (function (){var statearr_43669 = state_43666;
(statearr_43669[(4)] = cljs.core.cons((5),(state_43666[(4)])));

return statearr_43669;
})();
var inst_43633 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43635 = ["_user/_auth"];
var inst_43636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43637 = ["*"];
var inst_43638 = (new cljs.core.PersistentVector(null,1,(5),inst_43636,inst_43637,null));
var inst_43639 = [inst_43638];
var inst_43640 = cljs.core.PersistentHashMap.fromArrays(inst_43635,inst_43639);
var inst_43641 = [inst_43640];
var inst_43642 = (new cljs.core.PersistentVector(null,1,(5),inst_43634,inst_43641,null));
var inst_43643 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43644 = cljs.core.PersistentHashMap.EMPTY;
var inst_43645 = [inst_43642,inst_43643,inst_43644];
var inst_43646 = cljs.core.PersistentHashMap.fromArrays(inst_43633,inst_43645);
var inst_43647 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43648 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43647,inst_43646);
var state_43666__$1 = state_43666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43666__$1,(6),inst_43648);
} else {
if((state_val_43667 === (3))){
var inst_43664 = (state_43666[(2)]);
var state_43666__$1 = state_43666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43666__$1,inst_43664);
} else {
if((state_val_43667 === (4))){
var inst_43623 = (state_43666[(2)]);
var inst_43624 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43623,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_43666__$1 = state_43666;
var statearr_43671_43683 = state_43666__$1;
(statearr_43671_43683[(2)] = inst_43624);

(statearr_43671_43683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43667 === (5))){
var _ = (function (){var statearr_43672 = state_43666;
(statearr_43672[(4)] = cljs.core.rest((state_43666[(4)])));

return statearr_43672;
})();
var state_43666__$1 = state_43666;
var ex43670 = (state_43666__$1[(2)]);
var statearr_43673_43684 = state_43666__$1;
(statearr_43673_43684[(5)] = ex43670);


var statearr_43674_43685 = state_43666__$1;
(statearr_43674_43685[(1)] = (4));

(statearr_43674_43685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43667 === (6))){
var inst_43650 = (state_43666[(2)]);
var inst_43651 = fluree.db.util.async.throw_err(inst_43650);
var inst_43652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43651,(0),null);
var inst_43653 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43651,(1),null);
var inst_43654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43655 = ["_user/_auth","_id"];
var inst_43656 = (new cljs.core.PersistentVector(null,2,(5),inst_43654,inst_43655,null));
var inst_43657 = fluree.db.dbfunctions.internal.get_in(inst_43652,inst_43656);
var inst_43658 = cljs.core.first(inst_43657);
var inst_43659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43660 = [inst_43658,inst_43653];
var inst_43661 = (new cljs.core.PersistentVector(null,2,(5),inst_43659,inst_43660,null));
var _ = (function (){var statearr_43675 = state_43666;
(statearr_43675[(4)] = cljs.core.rest((state_43666[(4)])));

return statearr_43675;
})();
var state_43666__$1 = state_43666;
var statearr_43676_43686 = state_43666__$1;
(statearr_43676_43686[(2)] = inst_43661);

(statearr_43676_43686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_43677 = [null,null,null,null,null,null,null];
(statearr_43677[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_43677[(1)] = (1));

return statearr_43677;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_43666){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43666);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43678){var ex__2730__auto__ = e43678;
var statearr_43679_43687 = state_43666;
(statearr_43679_43687[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43666[(4)]))){
var statearr_43680_43688 = state_43666;
(statearr_43680_43688[(1)] = cljs.core.first((state_43666[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43689 = state_43666;
state_43666 = G__43689;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_43666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_43666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43681 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43681[(6)] = c__2749__auto__);

return statearr_43681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43711){
var state_val_43712 = (state_43711[(1)]);
if((state_val_43712 === (7))){
var inst_43696 = (state_43711[(7)]);
var inst_43700 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43701 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_43700,inst_43696);
var state_43711__$1 = state_43711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43711__$1,(9),inst_43701);
} else {
if((state_val_43712 === (1))){
var state_43711__$1 = state_43711;
var statearr_43713_43732 = state_43711__$1;
(statearr_43713_43732[(2)] = null);

(statearr_43713_43732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43712 === (4))){
var inst_43690 = (state_43711[(2)]);
var state_43711__$1 = state_43711;
var statearr_43714_43733 = state_43711__$1;
(statearr_43714_43733[(2)] = inst_43690);

(statearr_43714_43733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43712 === (6))){
var inst_43696 = (state_43711[(7)]);
var state_43711__$1 = state_43711;
var statearr_43715_43734 = state_43711__$1;
(statearr_43715_43734[(2)] = inst_43696);

(statearr_43715_43734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43712 === (3))){
var inst_43709 = (state_43711[(2)]);
var state_43711__$1 = state_43711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43711__$1,inst_43709);
} else {
if((state_val_43712 === (2))){
var inst_43696 = (state_43711[(7)]);
var _ = (function (){var statearr_43717 = state_43711;
(statearr_43717[(4)] = cljs.core.cons((5),(state_43711[(4)])));

return statearr_43717;
})();
var inst_43696__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43697 = typeof inst_43696__$1 === 'number';
var state_43711__$1 = (function (){var statearr_43718 = state_43711;
(statearr_43718[(7)] = inst_43696__$1);

return statearr_43718;
})();
if(cljs.core.truth_(inst_43697)){
var statearr_43719_43735 = state_43711__$1;
(statearr_43719_43735[(1)] = (6));

} else {
var statearr_43720_43736 = state_43711__$1;
(statearr_43720_43736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43712 === (9))){
var inst_43703 = (state_43711[(2)]);
var inst_43704 = fluree.db.util.async.throw_err(inst_43703);
var state_43711__$1 = state_43711;
var statearr_43721_43737 = state_43711__$1;
(statearr_43721_43737[(2)] = inst_43704);

(statearr_43721_43737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43712 === (5))){
var _ = (function (){var statearr_43722 = state_43711;
(statearr_43722[(4)] = cljs.core.rest((state_43711[(4)])));

return statearr_43722;
})();
var state_43711__$1 = state_43711;
var ex43716 = (state_43711__$1[(2)]);
var statearr_43723_43738 = state_43711__$1;
(statearr_43723_43738[(5)] = ex43716);


if((ex43716 instanceof Error)){
var statearr_43724_43739 = state_43711__$1;
(statearr_43724_43739[(1)] = (4));

(statearr_43724_43739[(5)] = null);

} else {
throw ex43716;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43712 === (8))){
var inst_43706 = (state_43711[(2)]);
var _ = (function (){var statearr_43725 = state_43711;
(statearr_43725[(4)] = cljs.core.rest((state_43711[(4)])));

return statearr_43725;
})();
var state_43711__$1 = state_43711;
var statearr_43726_43740 = state_43711__$1;
(statearr_43726_43740[(2)] = inst_43706);

(statearr_43726_43740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_43727 = [null,null,null,null,null,null,null,null];
(statearr_43727[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_43727[(1)] = (1));

return statearr_43727;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_43711){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43711);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43728){var ex__2730__auto__ = e43728;
var statearr_43729_43741 = state_43711;
(statearr_43729_43741[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43711[(4)]))){
var statearr_43730_43742 = state_43711;
(statearr_43730_43742[(1)] = cljs.core.first((state_43711[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43743 = state_43711;
state_43711 = G__43743;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_43711){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_43711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43731 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43731[(6)] = c__2749__auto__);

return statearr_43731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__43744_SHARP_){
return fluree.db.flake.op(p1__43744_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43745_SHARP_){
return fluree.db.flake.o(p1__43745_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e43746){var e = e43746;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__43747_SHARP_){
return fluree.db.flake.op(p1__43747_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43748_SHARP_){
return fluree.db.flake.o(p1__43748_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e43749){var e = e43749;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__43751 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__43751);
})() | (0));
return num;
}catch (e43750){var e = e43750;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_43831){
var state_val_43832 = (state_43831[(1)]);
if((state_val_43832 === (7))){
var inst_43770 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_43771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43772 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_43773 = cljs.core.PersistentHashMap.fromArrays(inst_43771,inst_43772);
var inst_43774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43770,inst_43773);
var inst_43775 = (function(){throw inst_43774})();
var state_43831__$1 = state_43831;
var statearr_43833_43868 = state_43831__$1;
(statearr_43833_43868[(2)] = inst_43775);

(statearr_43833_43868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (1))){
var state_43831__$1 = state_43831;
var statearr_43834_43869 = state_43831__$1;
(statearr_43834_43869[(2)] = null);

(statearr_43834_43869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (4))){
var inst_43752 = (state_43831[(2)]);
var state_43831__$1 = state_43831;
var statearr_43835_43870 = state_43831__$1;
(statearr_43835_43870[(2)] = inst_43752);

(statearr_43835_43870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (15))){
var inst_43815 = (state_43831[(7)]);
var inst_43811 = (state_43831[(2)]);
var inst_43812 = fluree.db.util.async.throw_err(inst_43811);
var inst_43813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43812,(0),null);
var inst_43814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43812,(1),null);
var inst_43815__$1 = cljs.core.first(inst_43813);
var inst_43816 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43815__$1,compare_val);
var state_43831__$1 = (function (){var statearr_43836 = state_43831;
(statearr_43836[(7)] = inst_43815__$1);

(statearr_43836[(8)] = inst_43814);

return statearr_43836;
})();
if(inst_43816){
var statearr_43837_43871 = state_43831__$1;
(statearr_43837_43871[(1)] = (16));

} else {
var statearr_43838_43872 = state_43831__$1;
(statearr_43838_43872[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (13))){
var state_43831__$1 = state_43831;
var statearr_43839_43873 = state_43831__$1;
(statearr_43839_43873[(2)] = null);

(statearr_43839_43873[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (6))){
var state_43831__$1 = state_43831;
var statearr_43840_43874 = state_43831__$1;
(statearr_43840_43874[(2)] = null);

(statearr_43840_43874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (17))){
var inst_43815 = (state_43831[(7)]);
var inst_43819 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43815)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_43820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43821 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_43822 = cljs.core.PersistentHashMap.fromArrays(inst_43820,inst_43821);
var inst_43823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43819,inst_43822);
var inst_43824 = (function(){throw inst_43823})();
var state_43831__$1 = state_43831;
var statearr_43841_43875 = state_43831__$1;
(statearr_43841_43875[(2)] = inst_43824);

(statearr_43841_43875[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (3))){
var inst_43829 = (state_43831[(2)]);
var state_43831__$1 = state_43831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43831__$1,inst_43829);
} else {
if((state_val_43832 === (12))){
var inst_43767 = (state_43831[(9)]);
var inst_43790 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_43767], 0));
var inst_43791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43792 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_43793 = cljs.core.PersistentHashMap.fromArrays(inst_43791,inst_43792);
var inst_43794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43790,inst_43793);
var inst_43795 = (function(){throw inst_43794})();
var state_43831__$1 = state_43831;
var statearr_43842_43876 = state_43831__$1;
(statearr_43842_43876[(2)] = inst_43795);

(statearr_43842_43876[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (2))){
var inst_43766 = (state_43831[(10)]);
var inst_43765 = (state_43831[(11)]);
var inst_43764 = (state_43831[(12)]);
var _ = (function (){var statearr_43843 = state_43831;
(statearr_43843[(4)] = cljs.core.cons((5),(state_43831[(4)])));

return statearr_43843;
})();
var inst_43762 = _QMARK_ctx;
var inst_43763 = cljs.core.__destructure_map(inst_43762);
var inst_43764__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43763,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_43765__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43763,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_43766__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43763,new cljs.core.Keyword(null,"db","db",993250759));
var inst_43767 = fluree.db.dbproto._p_prop(inst_43766__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_43765__$1);
var state_43831__$1 = (function (){var statearr_43844 = state_43831;
(statearr_43844[(9)] = inst_43767);

(statearr_43844[(10)] = inst_43766__$1);

(statearr_43844[(11)] = inst_43765__$1);

(statearr_43844[(12)] = inst_43764__$1);

return statearr_43844;
})();
if(cljs.core.truth_(inst_43764__$1)){
var statearr_43845_43877 = state_43831__$1;
(statearr_43845_43877[(1)] = (6));

} else {
var statearr_43846_43878 = state_43831__$1;
(statearr_43846_43878[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (11))){
var inst_43766 = (state_43831[(10)]);
var inst_43765 = (state_43831[(11)]);
var inst_43787 = (state_43831[(2)]);
var inst_43788 = fluree.db.dbproto._p_prop(inst_43766,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_43765);
var state_43831__$1 = (function (){var statearr_43848 = state_43831;
(statearr_43848[(13)] = inst_43787);

return statearr_43848;
})();
if(cljs.core.truth_(inst_43788)){
var statearr_43849_43879 = state_43831__$1;
(statearr_43849_43879[(1)] = (12));

} else {
var statearr_43850_43880 = state_43831__$1;
(statearr_43850_43880[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (9))){
var state_43831__$1 = state_43831;
var statearr_43851_43881 = state_43831__$1;
(statearr_43851_43881[(2)] = null);

(statearr_43851_43881[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (5))){
var _ = (function (){var statearr_43852 = state_43831;
(statearr_43852[(4)] = cljs.core.rest((state_43831[(4)])));

return statearr_43852;
})();
var state_43831__$1 = state_43831;
var ex43847 = (state_43831__$1[(2)]);
var statearr_43853_43882 = state_43831__$1;
(statearr_43853_43882[(5)] = ex43847);


if((ex43847 instanceof Error)){
var statearr_43854_43883 = state_43831__$1;
(statearr_43854_43883[(1)] = (4));

(statearr_43854_43883[(5)] = null);

} else {
throw ex43847;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (14))){
var inst_43767 = (state_43831[(9)]);
var inst_43766 = (state_43831[(10)]);
var inst_43764 = (state_43831[(12)]);
var inst_43798 = (state_43831[(2)]);
var inst_43799 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43802 = [inst_43764,inst_43767,"?current-val"];
var inst_43803 = (new cljs.core.PersistentVector(null,3,(5),inst_43801,inst_43802,null));
var inst_43804 = [inst_43803];
var inst_43805 = (new cljs.core.PersistentVector(null,1,(5),inst_43800,inst_43804,null));
var inst_43806 = cljs.core.PersistentHashMap.EMPTY;
var inst_43807 = ["?current-val",inst_43805,inst_43806];
var inst_43808 = cljs.core.PersistentHashMap.fromArrays(inst_43799,inst_43807);
var inst_43809 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43766,inst_43808);
var state_43831__$1 = (function (){var statearr_43855 = state_43831;
(statearr_43855[(14)] = inst_43798);

return statearr_43855;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43831__$1,(15),inst_43809);
} else {
if((state_val_43832 === (16))){
var state_43831__$1 = state_43831;
var statearr_43856_43884 = state_43831__$1;
(statearr_43856_43884[(2)] = new_val);

(statearr_43856_43884[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (10))){
var inst_43780 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_43781 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43782 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_43783 = cljs.core.PersistentHashMap.fromArrays(inst_43781,inst_43782);
var inst_43784 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43780,inst_43783);
var inst_43785 = (function(){throw inst_43784})();
var state_43831__$1 = state_43831;
var statearr_43857_43885 = state_43831__$1;
(statearr_43857_43885[(2)] = inst_43785);

(statearr_43857_43885[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (18))){
var inst_43826 = (state_43831[(2)]);
var _ = (function (){var statearr_43858 = state_43831;
(statearr_43858[(4)] = cljs.core.rest((state_43831[(4)])));

return statearr_43858;
})();
var state_43831__$1 = state_43831;
var statearr_43859_43886 = state_43831__$1;
(statearr_43859_43886[(2)] = inst_43826);

(statearr_43859_43886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43832 === (8))){
var inst_43767 = (state_43831[(9)]);
var inst_43777 = (state_43831[(2)]);
var state_43831__$1 = (function (){var statearr_43860 = state_43831;
(statearr_43860[(15)] = inst_43777);

return statearr_43860;
})();
if(cljs.core.truth_(inst_43767)){
var statearr_43861_43887 = state_43831__$1;
(statearr_43861_43887[(1)] = (9));

} else {
var statearr_43862_43888 = state_43831__$1;
(statearr_43862_43888[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_43863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43863[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_43863[(1)] = (1));

return statearr_43863;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_43831){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_43831);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e43864){var ex__2730__auto__ = e43864;
var statearr_43865_43889 = state_43831;
(statearr_43865_43889[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_43831[(4)]))){
var statearr_43866_43890 = state_43831;
(statearr_43866_43890[(1)] = cljs.core.first((state_43831[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43891 = state_43831;
state_43831 = G__43891;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_43831){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_43831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_43867 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_43867[(6)] = c__2749__auto__);

return statearr_43867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
