// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___68313 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68364){
var state_val_68365 = (state_68364[(1)]);
if((state_val_68365 === (7))){
var inst_68359 = (state_68364[(2)]);
var _ = (function (){var statearr_68366 = state_68364;
(statearr_68366[(4)] = cljs.core.rest((state_68364[(4)])));

return statearr_68366;
})();
var state_68364__$1 = state_68364;
var statearr_68367_68394 = state_68364__$1;
(statearr_68367_68394[(2)] = inst_68359);

(statearr_68367_68394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (1))){
var state_68364__$1 = state_68364;
var statearr_68368_68395 = state_68364__$1;
(statearr_68368_68395[(2)] = null);

(statearr_68368_68395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (4))){
var inst_68314 = (state_68364[(2)]);
var state_68364__$1 = state_68364;
var statearr_68369_68396 = state_68364__$1;
(statearr_68369_68396[(2)] = inst_68314);

(statearr_68369_68396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (13))){
var inst_68355 = (state_68364[(2)]);
var state_68364__$1 = state_68364;
var statearr_68370_68397 = state_68364__$1;
(statearr_68370_68397[(2)] = inst_68355);

(statearr_68370_68397[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (6))){
var inst_68339 = (state_68364[(7)]);
var inst_68332 = (state_68364[(8)]);
var inst_68338 = cljs.core.seq(inst_68332);
var inst_68339__$1 = cljs.core.first(inst_68338);
var inst_68340 = cljs.core.next(inst_68338);
var inst_68341 = cljs.core.not(inst_68339__$1);
var state_68364__$1 = (function (){var statearr_68371 = state_68364;
(statearr_68371[(9)] = inst_68340);

(statearr_68371[(7)] = inst_68339__$1);

return statearr_68371;
})();
if(inst_68341){
var statearr_68372_68398 = state_68364__$1;
(statearr_68372_68398[(1)] = (8));

} else {
var statearr_68373_68399 = state_68364__$1;
(statearr_68373_68399[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (3))){
var inst_68362 = (state_68364[(2)]);
var state_68364__$1 = state_68364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68364__$1,inst_68362);
} else {
if((state_val_68365 === (12))){
var inst_68333 = (state_68364[(10)]);
var inst_68340 = (state_68364[(9)]);
var inst_68339 = (state_68364[(7)]);
var inst_68352 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68333,inst_68339);
var inst_68332 = inst_68340;
var inst_68333__$1 = inst_68352;
var state_68364__$1 = (function (){var statearr_68374 = state_68364;
(statearr_68374[(10)] = inst_68333__$1);

(statearr_68374[(8)] = inst_68332);

return statearr_68374;
})();
var statearr_68375_68400 = state_68364__$1;
(statearr_68375_68400[(2)] = null);

(statearr_68375_68400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (2))){
var _ = (function (){var statearr_68376 = state_68364;
(statearr_68376[(4)] = cljs.core.cons((5),(state_68364[(4)])));

return statearr_68376;
})();
var inst_68327 = args;
var inst_68328 = cljs.core.seq(inst_68327);
var inst_68329 = cljs.core.first(inst_68328);
var inst_68330 = cljs.core.next(inst_68328);
var inst_68331 = cljs.core.PersistentVector.EMPTY;
var inst_68332 = inst_68327;
var inst_68333 = inst_68331;
var state_68364__$1 = (function (){var statearr_68377 = state_68364;
(statearr_68377[(10)] = inst_68333);

(statearr_68377[(11)] = inst_68330);

(statearr_68377[(12)] = inst_68329);

(statearr_68377[(8)] = inst_68332);

return statearr_68377;
})();
var statearr_68378_68401 = state_68364__$1;
(statearr_68378_68401[(2)] = null);

(statearr_68378_68401[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (11))){
var inst_68339 = (state_68364[(7)]);
var state_68364__$1 = state_68364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68364__$1,(14),inst_68339);
} else {
if((state_val_68365 === (9))){
var inst_68339 = (state_68364[(7)]);
var inst_68344 = fluree.db.util.async.channel_QMARK_(inst_68339);
var state_68364__$1 = state_68364;
if(inst_68344){
var statearr_68380_68402 = state_68364__$1;
(statearr_68380_68402[(1)] = (11));

} else {
var statearr_68381_68403 = state_68364__$1;
(statearr_68381_68403[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (5))){
var _ = (function (){var statearr_68382 = state_68364;
(statearr_68382[(4)] = cljs.core.rest((state_68364[(4)])));

return statearr_68382;
})();
var state_68364__$1 = state_68364;
var ex68379 = (state_68364__$1[(2)]);
var statearr_68383_68404 = state_68364__$1;
(statearr_68383_68404[(5)] = ex68379);


if((ex68379 instanceof Error)){
var statearr_68384_68405 = state_68364__$1;
(statearr_68384_68405[(1)] = (4));

(statearr_68384_68405[(5)] = null);

} else {
throw ex68379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (14))){
var inst_68333 = (state_68364[(10)]);
var inst_68340 = (state_68364[(9)]);
var inst_68347 = (state_68364[(2)]);
var inst_68348 = fluree.db.util.async.throw_err(inst_68347);
var inst_68349 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68333,inst_68348);
var inst_68332 = inst_68340;
var inst_68333__$1 = inst_68349;
var state_68364__$1 = (function (){var statearr_68385 = state_68364;
(statearr_68385[(10)] = inst_68333__$1);

(statearr_68385[(8)] = inst_68332);

return statearr_68385;
})();
var statearr_68386_68406 = state_68364__$1;
(statearr_68386_68406[(2)] = null);

(statearr_68386_68406[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (10))){
var inst_68357 = (state_68364[(2)]);
var state_68364__$1 = state_68364;
var statearr_68387_68407 = state_68364__$1;
(statearr_68387_68407[(2)] = inst_68357);

(statearr_68387_68407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68365 === (8))){
var inst_68333 = (state_68364[(10)]);
var state_68364__$1 = state_68364;
var statearr_68388_68408 = state_68364__$1;
(statearr_68388_68408[(2)] = inst_68333);

(statearr_68388_68408[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_68389 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68389[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_68389[(1)] = (1));

return statearr_68389;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_68364){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68364);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68390){var ex__2730__auto__ = e68390;
var statearr_68391_68409 = state_68364;
(statearr_68391_68409[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68364[(4)]))){
var statearr_68392_68410 = state_68364;
(statearr_68392_68410[(1)] = cljs.core.first((state_68364[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68411 = state_68364;
state_68364 = G__68411;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_68364){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_68364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68393 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68393[(6)] = c__2749__auto__);

return statearr_68393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__68413 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68413,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68413,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__68412_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__68412_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68461){
var state_val_68462 = (state_68461[(1)]);
if((state_val_68462 === (7))){
var state_68461__$1 = state_68461;
var statearr_68463_68492 = state_68461__$1;
(statearr_68463_68492[(2)] = coll);

(statearr_68463_68492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (1))){
var state_68461__$1 = state_68461;
var statearr_68464_68493 = state_68461__$1;
(statearr_68464_68493[(2)] = null);

(statearr_68464_68493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (4))){
var inst_68416 = (state_68461[(2)]);
var state_68461__$1 = state_68461;
var statearr_68465_68494 = state_68461__$1;
(statearr_68465_68494[(2)] = inst_68416);

(statearr_68465_68494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (15))){
var inst_68435 = (state_68461[(7)]);
var inst_68443 = (state_68461[(2)]);
var inst_68444 = fluree.db.dbfunctions.internal.nth(inst_68435,inst_68443);
var inst_68445 = cljs.core.count(inst_68435);
var inst_68446 = ((9) + inst_68445);
var inst_68447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68448 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68450 = [inst_68435,inst_68443];
var inst_68451 = (new cljs.core.PersistentVector(null,2,(5),inst_68449,inst_68450,null));
var inst_68452 = ["nth",inst_68451,inst_68444];
var inst_68453 = cljs.core.PersistentHashMap.fromArrays(inst_68448,inst_68452);
var inst_68454 = [inst_68453,inst_68446];
var inst_68455 = (new cljs.core.PersistentVector(null,2,(5),inst_68447,inst_68454,null));
var inst_68456 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68455);
var _ = (function (){var statearr_68466 = state_68461;
(statearr_68466[(4)] = cljs.core.rest((state_68461[(4)])));

return statearr_68466;
})();
var state_68461__$1 = (function (){var statearr_68467 = state_68461;
(statearr_68467[(8)] = inst_68456);

return statearr_68467;
})();
var statearr_68468_68495 = state_68461__$1;
(statearr_68468_68495[(2)] = inst_68444);

(statearr_68468_68495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (13))){
var state_68461__$1 = state_68461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68461__$1,(16),key);
} else {
if((state_val_68462 === (6))){
var state_68461__$1 = state_68461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68461__$1,(9),coll);
} else {
if((state_val_68462 === (3))){
var inst_68459 = (state_68461[(2)]);
var state_68461__$1 = state_68461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68461__$1,inst_68459);
} else {
if((state_val_68462 === (12))){
var inst_68435 = (state_68461[(2)]);
var inst_68436 = fluree.db.util.async.channel_QMARK_(key);
var state_68461__$1 = (function (){var statearr_68469 = state_68461;
(statearr_68469[(7)] = inst_68435);

return statearr_68469;
})();
if(inst_68436){
var statearr_68470_68496 = state_68461__$1;
(statearr_68470_68496[(1)] = (13));

} else {
var statearr_68471_68497 = state_68461__$1;
(statearr_68471_68497[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (2))){
var _ = (function (){var statearr_68472 = state_68461;
(statearr_68472[(4)] = cljs.core.cons((5),(state_68461[(4)])));

return statearr_68472;
})();
var inst_68422 = fluree.db.util.async.channel_QMARK_(coll);
var state_68461__$1 = state_68461;
if(inst_68422){
var statearr_68473_68498 = state_68461__$1;
(statearr_68473_68498[(1)] = (6));

} else {
var statearr_68474_68499 = state_68461__$1;
(statearr_68474_68499[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (11))){
var inst_68429 = (state_68461[(9)]);
var state_68461__$1 = state_68461;
var statearr_68476_68500 = state_68461__$1;
(statearr_68476_68500[(2)] = inst_68429);

(statearr_68476_68500[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (9))){
var inst_68425 = (state_68461[(2)]);
var inst_68426 = fluree.db.util.async.throw_err(inst_68425);
var state_68461__$1 = state_68461;
var statearr_68477_68501 = state_68461__$1;
(statearr_68477_68501[(2)] = inst_68426);

(statearr_68477_68501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (5))){
var _ = (function (){var statearr_68478 = state_68461;
(statearr_68478[(4)] = cljs.core.rest((state_68461[(4)])));

return statearr_68478;
})();
var state_68461__$1 = state_68461;
var ex68475 = (state_68461__$1[(2)]);
var statearr_68479_68502 = state_68461__$1;
(statearr_68479_68502[(5)] = ex68475);


if((ex68475 instanceof Error)){
var statearr_68480_68503 = state_68461__$1;
(statearr_68480_68503[(1)] = (4));

(statearr_68480_68503[(5)] = null);

} else {
throw ex68475;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (14))){
var state_68461__$1 = state_68461;
var statearr_68481_68504 = state_68461__$1;
(statearr_68481_68504[(2)] = key);

(statearr_68481_68504[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (16))){
var inst_68439 = (state_68461[(2)]);
var inst_68440 = fluree.db.util.async.throw_err(inst_68439);
var state_68461__$1 = state_68461;
var statearr_68482_68505 = state_68461__$1;
(statearr_68482_68505[(2)] = inst_68440);

(statearr_68482_68505[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (10))){
var inst_68429 = (state_68461[(9)]);
var inst_68432 = cljs.core.vec(inst_68429);
var state_68461__$1 = state_68461;
var statearr_68483_68506 = state_68461__$1;
(statearr_68483_68506[(2)] = inst_68432);

(statearr_68483_68506[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68462 === (8))){
var inst_68429 = (state_68461[(9)]);
var inst_68429__$1 = (state_68461[(2)]);
var inst_68430 = cljs.core.set_QMARK_(inst_68429__$1);
var state_68461__$1 = (function (){var statearr_68484 = state_68461;
(statearr_68484[(9)] = inst_68429__$1);

return statearr_68484;
})();
if(inst_68430){
var statearr_68485_68507 = state_68461__$1;
(statearr_68485_68507[(1)] = (10));

} else {
var statearr_68486_68508 = state_68461__$1;
(statearr_68486_68508[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_68487 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68487[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_68487[(1)] = (1));

return statearr_68487;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_68461){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68461);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68488){var ex__2730__auto__ = e68488;
var statearr_68489_68509 = state_68461;
(statearr_68489_68509[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68461[(4)]))){
var statearr_68490_68510 = state_68461;
(statearr_68490_68510[(1)] = cljs.core.first((state_68461[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68511 = state_68461;
state_68461 = G__68511;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_68461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_68461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68491 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68491[(6)] = c__2749__auto__);

return statearr_68491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68572){
var state_val_68573 = (state_68572[(1)]);
if((state_val_68573 === (7))){
var state_68572__$1 = state_68572;
var statearr_68574_68608 = state_68572__$1;
(statearr_68574_68608[(2)] = test);

(statearr_68574_68608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (20))){
var inst_68546 = (state_68572[(2)]);
var inst_68547 = fluree.db.util.async.throw_err(inst_68546);
var state_68572__$1 = state_68572;
var statearr_68575_68609 = state_68572__$1;
(statearr_68575_68609[(2)] = inst_68547);

(statearr_68575_68609[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (1))){
var state_68572__$1 = state_68572;
var statearr_68576_68610 = state_68572__$1;
(statearr_68576_68610[(2)] = null);

(statearr_68576_68610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (4))){
var inst_68512 = (state_68572[(2)]);
var state_68572__$1 = state_68572;
var statearr_68577_68611 = state_68572__$1;
(statearr_68577_68611[(2)] = inst_68512);

(statearr_68577_68611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (15))){
var inst_68530 = (state_68572[(7)]);
var inst_68538 = (state_68572[(2)]);
var inst_68539 = [inst_68538,f];
var inst_68540 = (new cljs.core.PersistentVector(null,2,(5),inst_68530,inst_68539,null));
var state_68572__$1 = state_68572;
var statearr_68578_68612 = state_68572__$1;
(statearr_68578_68612[(2)] = inst_68540);

(statearr_68578_68612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (13))){
var state_68572__$1 = state_68572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68572__$1,(16),t);
} else {
if((state_val_68573 === (6))){
var state_68572__$1 = state_68572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68572__$1,(9),test);
} else {
if((state_val_68573 === (17))){
var state_68572__$1 = state_68572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68572__$1,(20),f);
} else {
if((state_val_68573 === (3))){
var inst_68570 = (state_68572[(2)]);
var state_68572__$1 = state_68572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68572__$1,inst_68570);
} else {
if((state_val_68573 === (12))){
var inst_68528 = (state_68572[(8)]);
var inst_68554 = (state_68572[(2)]);
var inst_68555 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68554,(0),null);
var inst_68556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68554,(1),null);
var inst_68557 = fluree.db.dbfunctions.internal.if_else(inst_68528,inst_68555,inst_68556);
var inst_68558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68559 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68561 = [inst_68528,inst_68555,inst_68556];
var inst_68562 = (new cljs.core.PersistentVector(null,3,(5),inst_68560,inst_68561,null));
var inst_68563 = ["if-else",inst_68562,inst_68557];
var inst_68564 = cljs.core.PersistentHashMap.fromArrays(inst_68559,inst_68563);
var inst_68565 = [inst_68564,(10)];
var inst_68566 = (new cljs.core.PersistentVector(null,2,(5),inst_68558,inst_68565,null));
var inst_68567 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68566);
var _ = (function (){var statearr_68579 = state_68572;
(statearr_68579[(4)] = cljs.core.rest((state_68572[(4)])));

return statearr_68579;
})();
var state_68572__$1 = (function (){var statearr_68580 = state_68572;
(statearr_68580[(9)] = inst_68567);

return statearr_68580;
})();
var statearr_68581_68613 = state_68572__$1;
(statearr_68581_68613[(2)] = inst_68557);

(statearr_68581_68613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (2))){
var _ = (function (){var statearr_68582 = state_68572;
(statearr_68582[(4)] = cljs.core.cons((5),(state_68572[(4)])));

return statearr_68582;
})();
var inst_68521 = fluree.db.util.async.channel_QMARK_(test);
var state_68572__$1 = state_68572;
if(inst_68521){
var statearr_68583_68614 = state_68572__$1;
(statearr_68583_68614[(1)] = (6));

} else {
var statearr_68584_68615 = state_68572__$1;
(statearr_68584_68615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (19))){
var inst_68542 = (state_68572[(10)]);
var inst_68550 = (state_68572[(2)]);
var inst_68551 = [f,inst_68550];
var inst_68552 = (new cljs.core.PersistentVector(null,2,(5),inst_68542,inst_68551,null));
var state_68572__$1 = state_68572;
var statearr_68585_68616 = state_68572__$1;
(statearr_68585_68616[(2)] = inst_68552);

(statearr_68585_68616[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (11))){
var inst_68542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68543 = fluree.db.util.async.channel_QMARK_(f);
var state_68572__$1 = (function (){var statearr_68587 = state_68572;
(statearr_68587[(10)] = inst_68542);

return statearr_68587;
})();
if(inst_68543){
var statearr_68588_68617 = state_68572__$1;
(statearr_68588_68617[(1)] = (17));

} else {
var statearr_68589_68618 = state_68572__$1;
(statearr_68589_68618[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (9))){
var inst_68524 = (state_68572[(2)]);
var inst_68525 = fluree.db.util.async.throw_err(inst_68524);
var state_68572__$1 = state_68572;
var statearr_68590_68619 = state_68572__$1;
(statearr_68590_68619[(2)] = inst_68525);

(statearr_68590_68619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (5))){
var _ = (function (){var statearr_68591 = state_68572;
(statearr_68591[(4)] = cljs.core.rest((state_68572[(4)])));

return statearr_68591;
})();
var state_68572__$1 = state_68572;
var ex68586 = (state_68572__$1[(2)]);
var statearr_68592_68620 = state_68572__$1;
(statearr_68592_68620[(5)] = ex68586);


if((ex68586 instanceof Error)){
var statearr_68593_68621 = state_68572__$1;
(statearr_68593_68621[(1)] = (4));

(statearr_68593_68621[(5)] = null);

} else {
throw ex68586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (14))){
var state_68572__$1 = state_68572;
var statearr_68594_68622 = state_68572__$1;
(statearr_68594_68622[(2)] = t);

(statearr_68594_68622[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (16))){
var inst_68534 = (state_68572[(2)]);
var inst_68535 = fluree.db.util.async.throw_err(inst_68534);
var state_68572__$1 = state_68572;
var statearr_68595_68623 = state_68572__$1;
(statearr_68595_68623[(2)] = inst_68535);

(statearr_68595_68623[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (10))){
var inst_68530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68531 = fluree.db.util.async.channel_QMARK_(t);
var state_68572__$1 = (function (){var statearr_68596 = state_68572;
(statearr_68596[(7)] = inst_68530);

return statearr_68596;
})();
if(inst_68531){
var statearr_68597_68624 = state_68572__$1;
(statearr_68597_68624[(1)] = (13));

} else {
var statearr_68598_68625 = state_68572__$1;
(statearr_68598_68625[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (18))){
var state_68572__$1 = state_68572;
var statearr_68599_68626 = state_68572__$1;
(statearr_68599_68626[(2)] = f);

(statearr_68599_68626[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68573 === (8))){
var inst_68528 = (state_68572[(8)]);
var inst_68528__$1 = (state_68572[(2)]);
var state_68572__$1 = (function (){var statearr_68600 = state_68572;
(statearr_68600[(8)] = inst_68528__$1);

return statearr_68600;
})();
if(cljs.core.truth_(inst_68528__$1)){
var statearr_68601_68627 = state_68572__$1;
(statearr_68601_68627[(1)] = (10));

} else {
var statearr_68602_68628 = state_68572__$1;
(statearr_68602_68628[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_68603 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_68603[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_68603[(1)] = (1));

return statearr_68603;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_68572){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68572);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68604){var ex__2730__auto__ = e68604;
var statearr_68605_68629 = state_68572;
(statearr_68605_68629[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68572[(4)]))){
var statearr_68606_68630 = state_68572;
(statearr_68606_68630[(1)] = cljs.core.first((state_68572[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68631 = state_68572;
state_68572 = G__68631;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_68572){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_68572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68607 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68607[(6)] = c__2749__auto__);

return statearr_68607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68661){
var state_val_68662 = (state_68661[(1)]);
if((state_val_68662 === (7))){
var state_68661__$1 = state_68661;
var statearr_68663_68682 = state_68661__$1;
(statearr_68663_68682[(2)] = arg);

(statearr_68663_68682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68662 === (1))){
var state_68661__$1 = state_68661;
var statearr_68664_68683 = state_68661__$1;
(statearr_68664_68683[(2)] = null);

(statearr_68664_68683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68662 === (4))){
var inst_68632 = (state_68661[(2)]);
var state_68661__$1 = state_68661;
var statearr_68665_68684 = state_68661__$1;
(statearr_68665_68684[(2)] = inst_68632);

(statearr_68665_68684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68662 === (6))){
var state_68661__$1 = state_68661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68661__$1,(9),arg);
} else {
if((state_val_68662 === (3))){
var inst_68659 = (state_68661[(2)]);
var state_68661__$1 = state_68661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68661__$1,inst_68659);
} else {
if((state_val_68662 === (2))){
var _ = (function (){var statearr_68667 = state_68661;
(statearr_68667[(4)] = cljs.core.cons((5),(state_68661[(4)])));

return statearr_68667;
})();
var inst_68638 = fluree.db.util.async.channel_QMARK_(arg);
var state_68661__$1 = state_68661;
if(inst_68638){
var statearr_68668_68685 = state_68661__$1;
(statearr_68668_68685[(1)] = (6));

} else {
var statearr_68669_68686 = state_68661__$1;
(statearr_68669_68686[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68662 === (9))){
var inst_68641 = (state_68661[(2)]);
var inst_68642 = fluree.db.util.async.throw_err(inst_68641);
var state_68661__$1 = state_68661;
var statearr_68670_68687 = state_68661__$1;
(statearr_68670_68687[(2)] = inst_68642);

(statearr_68670_68687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68662 === (5))){
var _ = (function (){var statearr_68671 = state_68661;
(statearr_68671[(4)] = cljs.core.rest((state_68661[(4)])));

return statearr_68671;
})();
var state_68661__$1 = state_68661;
var ex68666 = (state_68661__$1[(2)]);
var statearr_68672_68688 = state_68661__$1;
(statearr_68672_68688[(5)] = ex68666);


if((ex68666 instanceof Error)){
var statearr_68673_68689 = state_68661__$1;
(statearr_68673_68689[(1)] = (4));

(statearr_68673_68689[(5)] = null);

} else {
throw ex68666;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68662 === (8))){
var inst_68645 = (state_68661[(2)]);
var inst_68646 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_68645);
var inst_68647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68648 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68650 = [inst_68645];
var inst_68651 = (new cljs.core.PersistentVector(null,1,(5),inst_68649,inst_68650,null));
var inst_68652 = ["nil?",inst_68651,inst_68646];
var inst_68653 = cljs.core.PersistentHashMap.fromArrays(inst_68648,inst_68652);
var inst_68654 = [inst_68653,(10)];
var inst_68655 = (new cljs.core.PersistentVector(null,2,(5),inst_68647,inst_68654,null));
var inst_68656 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68655);
var _ = (function (){var statearr_68674 = state_68661;
(statearr_68674[(4)] = cljs.core.rest((state_68661[(4)])));

return statearr_68674;
})();
var state_68661__$1 = (function (){var statearr_68675 = state_68661;
(statearr_68675[(7)] = inst_68656);

return statearr_68675;
})();
var statearr_68676_68690 = state_68661__$1;
(statearr_68676_68690[(2)] = inst_68646);

(statearr_68676_68690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_68677 = [null,null,null,null,null,null,null,null];
(statearr_68677[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_68677[(1)] = (1));

return statearr_68677;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_68661){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68661);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68678){var ex__2730__auto__ = e68678;
var statearr_68679_68691 = state_68661;
(statearr_68679_68691[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68661[(4)]))){
var statearr_68680_68692 = state_68661;
(statearr_68680_68692[(1)] = cljs.core.first((state_68661[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68693 = state_68661;
state_68661 = G__68693;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_68661){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_68661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68681 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68681[(6)] = c__2749__auto__);

return statearr_68681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68723){
var state_val_68724 = (state_68723[(1)]);
if((state_val_68724 === (7))){
var state_68723__$1 = state_68723;
var statearr_68725_68744 = state_68723__$1;
(statearr_68725_68744[(2)] = arg);

(statearr_68725_68744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68724 === (1))){
var state_68723__$1 = state_68723;
var statearr_68726_68745 = state_68723__$1;
(statearr_68726_68745[(2)] = null);

(statearr_68726_68745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68724 === (4))){
var inst_68694 = (state_68723[(2)]);
var state_68723__$1 = state_68723;
var statearr_68727_68746 = state_68723__$1;
(statearr_68727_68746[(2)] = inst_68694);

(statearr_68727_68746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68724 === (6))){
var state_68723__$1 = state_68723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68723__$1,(9),arg);
} else {
if((state_val_68724 === (3))){
var inst_68721 = (state_68723[(2)]);
var state_68723__$1 = state_68723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68723__$1,inst_68721);
} else {
if((state_val_68724 === (2))){
var _ = (function (){var statearr_68729 = state_68723;
(statearr_68729[(4)] = cljs.core.cons((5),(state_68723[(4)])));

return statearr_68729;
})();
var inst_68700 = fluree.db.util.async.channel_QMARK_(arg);
var state_68723__$1 = state_68723;
if(inst_68700){
var statearr_68730_68747 = state_68723__$1;
(statearr_68730_68747[(1)] = (6));

} else {
var statearr_68731_68748 = state_68723__$1;
(statearr_68731_68748[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68724 === (9))){
var inst_68703 = (state_68723[(2)]);
var inst_68704 = fluree.db.util.async.throw_err(inst_68703);
var state_68723__$1 = state_68723;
var statearr_68732_68749 = state_68723__$1;
(statearr_68732_68749[(2)] = inst_68704);

(statearr_68732_68749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68724 === (5))){
var _ = (function (){var statearr_68733 = state_68723;
(statearr_68733[(4)] = cljs.core.rest((state_68723[(4)])));

return statearr_68733;
})();
var state_68723__$1 = state_68723;
var ex68728 = (state_68723__$1[(2)]);
var statearr_68734_68750 = state_68723__$1;
(statearr_68734_68750[(5)] = ex68728);


if((ex68728 instanceof Error)){
var statearr_68735_68751 = state_68723__$1;
(statearr_68735_68751[(1)] = (4));

(statearr_68735_68751[(5)] = null);

} else {
throw ex68728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68724 === (8))){
var inst_68707 = (state_68723[(2)]);
var inst_68708 = fluree.db.dbfunctions.internal.not(inst_68707);
var inst_68709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68710 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68712 = [inst_68707];
var inst_68713 = (new cljs.core.PersistentVector(null,1,(5),inst_68711,inst_68712,null));
var inst_68714 = ["not",inst_68713,inst_68708];
var inst_68715 = cljs.core.PersistentHashMap.fromArrays(inst_68710,inst_68714);
var inst_68716 = [inst_68715,(10)];
var inst_68717 = (new cljs.core.PersistentVector(null,2,(5),inst_68709,inst_68716,null));
var inst_68718 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68717);
var _ = (function (){var statearr_68736 = state_68723;
(statearr_68736[(4)] = cljs.core.rest((state_68723[(4)])));

return statearr_68736;
})();
var state_68723__$1 = (function (){var statearr_68737 = state_68723;
(statearr_68737[(7)] = inst_68718);

return statearr_68737;
})();
var statearr_68738_68752 = state_68723__$1;
(statearr_68738_68752[(2)] = inst_68708);

(statearr_68738_68752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_68739 = [null,null,null,null,null,null,null,null];
(statearr_68739[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_68739[(1)] = (1));

return statearr_68739;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_68723){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68723);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68740){var ex__2730__auto__ = e68740;
var statearr_68741_68753 = state_68723;
(statearr_68741_68753[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68723[(4)]))){
var statearr_68742_68754 = state_68723;
(statearr_68742_68754[(1)] = cljs.core.first((state_68723[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68755 = state_68723;
state_68723 = G__68755;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_68723){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_68723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68743 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68743[(6)] = c__2749__auto__);

return statearr_68743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68785){
var state_val_68786 = (state_68785[(1)]);
if((state_val_68786 === (7))){
var state_68785__$1 = state_68785;
var statearr_68787_68806 = state_68785__$1;
(statearr_68787_68806[(2)] = arg);

(statearr_68787_68806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68786 === (1))){
var state_68785__$1 = state_68785;
var statearr_68788_68807 = state_68785__$1;
(statearr_68788_68807[(2)] = null);

(statearr_68788_68807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68786 === (4))){
var inst_68756 = (state_68785[(2)]);
var state_68785__$1 = state_68785;
var statearr_68789_68808 = state_68785__$1;
(statearr_68789_68808[(2)] = inst_68756);

(statearr_68789_68808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68786 === (6))){
var state_68785__$1 = state_68785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68785__$1,(9),arg);
} else {
if((state_val_68786 === (3))){
var inst_68783 = (state_68785[(2)]);
var state_68785__$1 = state_68785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68785__$1,inst_68783);
} else {
if((state_val_68786 === (2))){
var _ = (function (){var statearr_68791 = state_68785;
(statearr_68791[(4)] = cljs.core.cons((5),(state_68785[(4)])));

return statearr_68791;
})();
var inst_68762 = fluree.db.util.async.channel_QMARK_(arg);
var state_68785__$1 = state_68785;
if(inst_68762){
var statearr_68792_68809 = state_68785__$1;
(statearr_68792_68809[(1)] = (6));

} else {
var statearr_68793_68810 = state_68785__$1;
(statearr_68793_68810[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68786 === (9))){
var inst_68765 = (state_68785[(2)]);
var inst_68766 = fluree.db.util.async.throw_err(inst_68765);
var state_68785__$1 = state_68785;
var statearr_68794_68811 = state_68785__$1;
(statearr_68794_68811[(2)] = inst_68766);

(statearr_68794_68811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68786 === (5))){
var _ = (function (){var statearr_68795 = state_68785;
(statearr_68795[(4)] = cljs.core.rest((state_68785[(4)])));

return statearr_68795;
})();
var state_68785__$1 = state_68785;
var ex68790 = (state_68785__$1[(2)]);
var statearr_68796_68812 = state_68785__$1;
(statearr_68796_68812[(5)] = ex68790);


if((ex68790 instanceof Error)){
var statearr_68797_68813 = state_68785__$1;
(statearr_68797_68813[(1)] = (4));

(statearr_68797_68813[(5)] = null);

} else {
throw ex68790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68786 === (8))){
var inst_68769 = (state_68785[(2)]);
var inst_68770 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_68769);
var inst_68771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68772 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68774 = [inst_68769];
var inst_68775 = (new cljs.core.PersistentVector(null,1,(5),inst_68773,inst_68774,null));
var inst_68776 = ["empty?",inst_68775,inst_68770];
var inst_68777 = cljs.core.PersistentHashMap.fromArrays(inst_68772,inst_68776);
var inst_68778 = [inst_68777,(10)];
var inst_68779 = (new cljs.core.PersistentVector(null,2,(5),inst_68771,inst_68778,null));
var inst_68780 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68779);
var _ = (function (){var statearr_68798 = state_68785;
(statearr_68798[(4)] = cljs.core.rest((state_68785[(4)])));

return statearr_68798;
})();
var state_68785__$1 = (function (){var statearr_68799 = state_68785;
(statearr_68799[(7)] = inst_68780);

return statearr_68799;
})();
var statearr_68800_68814 = state_68785__$1;
(statearr_68800_68814[(2)] = inst_68770);

(statearr_68800_68814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_68801 = [null,null,null,null,null,null,null,null];
(statearr_68801[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_68801[(1)] = (1));

return statearr_68801;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_68785){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68785);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68802){var ex__2730__auto__ = e68802;
var statearr_68803_68815 = state_68785;
(statearr_68803_68815[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68785[(4)]))){
var statearr_68804_68816 = state_68785;
(statearr_68804_68816[(1)] = cljs.core.first((state_68785[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68817 = state_68785;
state_68785 = G__68817;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_68785){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_68785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68805 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68805[(6)] = c__2749__auto__);

return statearr_68805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68862 = arguments.length;
var i__5770__auto___68863 = (0);
while(true){
if((i__5770__auto___68863 < len__5769__auto___68862)){
args__5775__auto__.push((arguments[i__5770__auto___68863]));

var G__68864 = (i__5770__auto___68863 + (1));
i__5770__auto___68863 = G__68864;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68845){
var state_val_68846 = (state_68845[(1)]);
if((state_val_68846 === (1))){
var state_68845__$1 = state_68845;
var statearr_68847_68865 = state_68845__$1;
(statearr_68847_68865[(2)] = null);

(statearr_68847_68865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68846 === (2))){
var _ = (function (){var statearr_68848 = state_68845;
(statearr_68848[(4)] = cljs.core.cons((5),(state_68845[(4)])));

return statearr_68848;
})();
var inst_68826 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_68845__$1 = state_68845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68845__$1,(6),inst_68826);
} else {
if((state_val_68846 === (3))){
var inst_68843 = (state_68845[(2)]);
var state_68845__$1 = state_68845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68845__$1,inst_68843);
} else {
if((state_val_68846 === (4))){
var inst_68820 = (state_68845[(2)]);
var state_68845__$1 = state_68845;
var statearr_68850_68866 = state_68845__$1;
(statearr_68850_68866[(2)] = inst_68820);

(statearr_68850_68866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68846 === (5))){
var _ = (function (){var statearr_68851 = state_68845;
(statearr_68851[(4)] = cljs.core.rest((state_68845[(4)])));

return statearr_68851;
})();
var state_68845__$1 = state_68845;
var ex68849 = (state_68845__$1[(2)]);
var statearr_68852_68867 = state_68845__$1;
(statearr_68852_68867[(5)] = ex68849);


if((ex68849 instanceof Error)){
var statearr_68853_68868 = state_68845__$1;
(statearr_68853_68868[(1)] = (4));

(statearr_68853_68868[(5)] = null);

} else {
throw ex68849;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68846 === (6))){
var inst_68828 = (state_68845[(2)]);
var inst_68829 = fluree.db.util.async.throw_err(inst_68828);
var inst_68830 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_68829);
var inst_68831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68832 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68834 = [inst_68829];
var inst_68835 = (new cljs.core.PersistentVector(null,1,(5),inst_68833,inst_68834,null));
var inst_68836 = ["str",inst_68835,inst_68830];
var inst_68837 = cljs.core.PersistentHashMap.fromArrays(inst_68832,inst_68836);
var inst_68838 = [inst_68837,(10)];
var inst_68839 = (new cljs.core.PersistentVector(null,2,(5),inst_68831,inst_68838,null));
var inst_68840 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68839);
var _ = (function (){var statearr_68854 = state_68845;
(statearr_68854[(4)] = cljs.core.rest((state_68845[(4)])));

return statearr_68854;
})();
var state_68845__$1 = (function (){var statearr_68855 = state_68845;
(statearr_68855[(7)] = inst_68840);

return statearr_68855;
})();
var statearr_68856_68869 = state_68845__$1;
(statearr_68856_68869[(2)] = inst_68830);

(statearr_68856_68869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_68857 = [null,null,null,null,null,null,null,null];
(statearr_68857[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_68857[(1)] = (1));

return statearr_68857;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_68845){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68845);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68858){var ex__2730__auto__ = e68858;
var statearr_68859_68870 = state_68845;
(statearr_68859_68870[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68845[(4)]))){
var statearr_68860_68871 = state_68845;
(statearr_68860_68871[(1)] = cljs.core.first((state_68845[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68872 = state_68845;
state_68845 = G__68872;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_68845){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_68845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68861 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68861[(6)] = c__2749__auto__);

return statearr_68861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq68818){
var G__68819 = cljs.core.first(seq68818);
var seq68818__$1 = cljs.core.next(seq68818);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68819,seq68818__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68898){
var state_val_68899 = (state_68898[(1)]);
if((state_val_68899 === (1))){
var state_68898__$1 = state_68898;
var statearr_68900_68915 = state_68898__$1;
(statearr_68900_68915[(2)] = null);

(statearr_68900_68915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68899 === (2))){
var _ = (function (){var statearr_68901 = state_68898;
(statearr_68901[(4)] = cljs.core.cons((5),(state_68898[(4)])));

return statearr_68901;
})();
var inst_68879 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_68898__$1 = state_68898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68898__$1,(6),inst_68879);
} else {
if((state_val_68899 === (3))){
var inst_68896 = (state_68898[(2)]);
var state_68898__$1 = state_68898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68898__$1,inst_68896);
} else {
if((state_val_68899 === (4))){
var inst_68873 = (state_68898[(2)]);
var state_68898__$1 = state_68898;
var statearr_68903_68916 = state_68898__$1;
(statearr_68903_68916[(2)] = inst_68873);

(statearr_68903_68916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68899 === (5))){
var _ = (function (){var statearr_68904 = state_68898;
(statearr_68904[(4)] = cljs.core.rest((state_68898[(4)])));

return statearr_68904;
})();
var state_68898__$1 = state_68898;
var ex68902 = (state_68898__$1[(2)]);
var statearr_68905_68917 = state_68898__$1;
(statearr_68905_68917[(5)] = ex68902);


if((ex68902 instanceof Error)){
var statearr_68906_68918 = state_68898__$1;
(statearr_68906_68918[(1)] = (4));

(statearr_68906_68918[(5)] = null);

} else {
throw ex68902;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68899 === (6))){
var inst_68881 = (state_68898[(2)]);
var inst_68882 = fluree.db.util.async.throw_err(inst_68881);
var inst_68883 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_68882);
var inst_68884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68885 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68887 = [inst_68882];
var inst_68888 = (new cljs.core.PersistentVector(null,1,(5),inst_68886,inst_68887,null));
var inst_68889 = ["subs",inst_68888,inst_68883];
var inst_68890 = cljs.core.PersistentHashMap.fromArrays(inst_68885,inst_68889);
var inst_68891 = [inst_68890,(30)];
var inst_68892 = (new cljs.core.PersistentVector(null,2,(5),inst_68884,inst_68891,null));
var inst_68893 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68892);
var _ = (function (){var statearr_68907 = state_68898;
(statearr_68907[(4)] = cljs.core.rest((state_68898[(4)])));

return statearr_68907;
})();
var state_68898__$1 = (function (){var statearr_68908 = state_68898;
(statearr_68908[(7)] = inst_68893);

return statearr_68908;
})();
var statearr_68909_68919 = state_68898__$1;
(statearr_68909_68919[(2)] = inst_68883);

(statearr_68909_68919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_68910 = [null,null,null,null,null,null,null,null];
(statearr_68910[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_68910[(1)] = (1));

return statearr_68910;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_68898){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68898);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68911){var ex__2730__auto__ = e68911;
var statearr_68912_68920 = state_68898;
(statearr_68912_68920[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68898[(4)]))){
var statearr_68913_68921 = state_68898;
(statearr_68913_68921[(1)] = cljs.core.first((state_68898[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68922 = state_68898;
state_68898 = G__68922;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_68898){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_68898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68914 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68914[(6)] = c__2749__auto__);

return statearr_68914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68952){
var state_val_68953 = (state_68952[(1)]);
if((state_val_68953 === (7))){
var state_68952__$1 = state_68952;
var statearr_68954_68973 = state_68952__$1;
(statearr_68954_68973[(2)] = str);

(statearr_68954_68973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68953 === (1))){
var state_68952__$1 = state_68952;
var statearr_68955_68974 = state_68952__$1;
(statearr_68955_68974[(2)] = null);

(statearr_68955_68974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68953 === (4))){
var inst_68923 = (state_68952[(2)]);
var state_68952__$1 = state_68952;
var statearr_68956_68975 = state_68952__$1;
(statearr_68956_68975[(2)] = inst_68923);

(statearr_68956_68975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68953 === (6))){
var state_68952__$1 = state_68952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68952__$1,(9),str);
} else {
if((state_val_68953 === (3))){
var inst_68950 = (state_68952[(2)]);
var state_68952__$1 = state_68952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68952__$1,inst_68950);
} else {
if((state_val_68953 === (2))){
var _ = (function (){var statearr_68958 = state_68952;
(statearr_68958[(4)] = cljs.core.cons((5),(state_68952[(4)])));

return statearr_68958;
})();
var inst_68929 = fluree.db.util.async.channel_QMARK_(str);
var state_68952__$1 = state_68952;
if(inst_68929){
var statearr_68959_68976 = state_68952__$1;
(statearr_68959_68976[(1)] = (6));

} else {
var statearr_68960_68977 = state_68952__$1;
(statearr_68960_68977[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68953 === (9))){
var inst_68932 = (state_68952[(2)]);
var inst_68933 = fluree.db.util.async.throw_err(inst_68932);
var state_68952__$1 = state_68952;
var statearr_68961_68978 = state_68952__$1;
(statearr_68961_68978[(2)] = inst_68933);

(statearr_68961_68978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68953 === (5))){
var _ = (function (){var statearr_68962 = state_68952;
(statearr_68962[(4)] = cljs.core.rest((state_68952[(4)])));

return statearr_68962;
})();
var state_68952__$1 = state_68952;
var ex68957 = (state_68952__$1[(2)]);
var statearr_68963_68979 = state_68952__$1;
(statearr_68963_68979[(5)] = ex68957);


if((ex68957 instanceof Error)){
var statearr_68964_68980 = state_68952__$1;
(statearr_68964_68980[(1)] = (4));

(statearr_68964_68980[(5)] = null);

} else {
throw ex68957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68953 === (8))){
var inst_68936 = (state_68952[(2)]);
var inst_68937 = fluree.db.dbfunctions.internal.lower_case(inst_68936);
var inst_68938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68939 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68941 = [inst_68936];
var inst_68942 = (new cljs.core.PersistentVector(null,1,(5),inst_68940,inst_68941,null));
var inst_68943 = ["lower-case",inst_68942,inst_68937];
var inst_68944 = cljs.core.PersistentHashMap.fromArrays(inst_68939,inst_68943);
var inst_68945 = [inst_68944,(10)];
var inst_68946 = (new cljs.core.PersistentVector(null,2,(5),inst_68938,inst_68945,null));
var inst_68947 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68946);
var _ = (function (){var statearr_68965 = state_68952;
(statearr_68965[(4)] = cljs.core.rest((state_68952[(4)])));

return statearr_68965;
})();
var state_68952__$1 = (function (){var statearr_68966 = state_68952;
(statearr_68966[(7)] = inst_68947);

return statearr_68966;
})();
var statearr_68967_68981 = state_68952__$1;
(statearr_68967_68981[(2)] = inst_68937);

(statearr_68967_68981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_68968 = [null,null,null,null,null,null,null,null];
(statearr_68968[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_68968[(1)] = (1));

return statearr_68968;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_68952){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68952);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68969){var ex__2730__auto__ = e68969;
var statearr_68970_68982 = state_68952;
(statearr_68970_68982[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68952[(4)]))){
var statearr_68971_68983 = state_68952;
(statearr_68971_68983[(1)] = cljs.core.first((state_68952[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68984 = state_68952;
state_68952 = G__68984;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_68952){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_68952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68972 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68972[(6)] = c__2749__auto__);

return statearr_68972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69014){
var state_val_69015 = (state_69014[(1)]);
if((state_val_69015 === (7))){
var state_69014__$1 = state_69014;
var statearr_69016_69035 = state_69014__$1;
(statearr_69016_69035[(2)] = str);

(statearr_69016_69035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69015 === (1))){
var state_69014__$1 = state_69014;
var statearr_69017_69036 = state_69014__$1;
(statearr_69017_69036[(2)] = null);

(statearr_69017_69036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69015 === (4))){
var inst_68985 = (state_69014[(2)]);
var state_69014__$1 = state_69014;
var statearr_69018_69037 = state_69014__$1;
(statearr_69018_69037[(2)] = inst_68985);

(statearr_69018_69037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69015 === (6))){
var state_69014__$1 = state_69014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69014__$1,(9),str);
} else {
if((state_val_69015 === (3))){
var inst_69012 = (state_69014[(2)]);
var state_69014__$1 = state_69014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69014__$1,inst_69012);
} else {
if((state_val_69015 === (2))){
var _ = (function (){var statearr_69020 = state_69014;
(statearr_69020[(4)] = cljs.core.cons((5),(state_69014[(4)])));

return statearr_69020;
})();
var inst_68991 = fluree.db.util.async.channel_QMARK_(str);
var state_69014__$1 = state_69014;
if(inst_68991){
var statearr_69021_69038 = state_69014__$1;
(statearr_69021_69038[(1)] = (6));

} else {
var statearr_69022_69039 = state_69014__$1;
(statearr_69022_69039[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69015 === (9))){
var inst_68994 = (state_69014[(2)]);
var inst_68995 = fluree.db.util.async.throw_err(inst_68994);
var state_69014__$1 = state_69014;
var statearr_69023_69040 = state_69014__$1;
(statearr_69023_69040[(2)] = inst_68995);

(statearr_69023_69040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69015 === (5))){
var _ = (function (){var statearr_69024 = state_69014;
(statearr_69024[(4)] = cljs.core.rest((state_69014[(4)])));

return statearr_69024;
})();
var state_69014__$1 = state_69014;
var ex69019 = (state_69014__$1[(2)]);
var statearr_69025_69041 = state_69014__$1;
(statearr_69025_69041[(5)] = ex69019);


if((ex69019 instanceof Error)){
var statearr_69026_69042 = state_69014__$1;
(statearr_69026_69042[(1)] = (4));

(statearr_69026_69042[(5)] = null);

} else {
throw ex69019;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69015 === (8))){
var inst_68998 = (state_69014[(2)]);
var inst_68999 = fluree.db.dbfunctions.internal.upper_case(inst_68998);
var inst_69000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69001 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69003 = [inst_68998];
var inst_69004 = (new cljs.core.PersistentVector(null,1,(5),inst_69002,inst_69003,null));
var inst_69005 = ["upper-case",inst_69004,inst_68999];
var inst_69006 = cljs.core.PersistentHashMap.fromArrays(inst_69001,inst_69005);
var inst_69007 = [inst_69006,(10)];
var inst_69008 = (new cljs.core.PersistentVector(null,2,(5),inst_69000,inst_69007,null));
var inst_69009 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69008);
var _ = (function (){var statearr_69027 = state_69014;
(statearr_69027[(4)] = cljs.core.rest((state_69014[(4)])));

return statearr_69027;
})();
var state_69014__$1 = (function (){var statearr_69028 = state_69014;
(statearr_69028[(7)] = inst_69009);

return statearr_69028;
})();
var statearr_69029_69043 = state_69014__$1;
(statearr_69029_69043[(2)] = inst_68999);

(statearr_69029_69043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_69030 = [null,null,null,null,null,null,null,null];
(statearr_69030[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_69030[(1)] = (1));

return statearr_69030;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_69014){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69014);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69031){var ex__2730__auto__ = e69031;
var statearr_69032_69044 = state_69014;
(statearr_69032_69044[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69014[(4)]))){
var statearr_69033_69045 = state_69014;
(statearr_69033_69045[(1)] = cljs.core.first((state_69014[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69046 = state_69014;
state_69014 = G__69046;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_69014){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_69014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69034 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69034[(6)] = c__2749__auto__);

return statearr_69034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__69048 = arguments.length;
switch (G__69048) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69076){
var state_val_69077 = (state_69076[(1)]);
if((state_val_69077 === (1))){
var state_69076__$1 = state_69076;
var statearr_69078_69094 = state_69076__$1;
(statearr_69078_69094[(2)] = null);

(statearr_69078_69094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69077 === (2))){
var _ = (function (){var statearr_69079 = state_69076;
(statearr_69079[(4)] = cljs.core.cons((5),(state_69076[(4)])));

return statearr_69079;
})();
var inst_69058 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_69076__$1 = state_69076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69076__$1,(6),inst_69058);
} else {
if((state_val_69077 === (3))){
var inst_69074 = (state_69076[(2)]);
var state_69076__$1 = state_69076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69076__$1,inst_69074);
} else {
if((state_val_69077 === (4))){
var inst_69049 = (state_69076[(2)]);
var state_69076__$1 = state_69076;
var statearr_69081_69095 = state_69076__$1;
(statearr_69081_69095[(2)] = inst_69049);

(statearr_69081_69095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69077 === (5))){
var _ = (function (){var statearr_69082 = state_69076;
(statearr_69082[(4)] = cljs.core.rest((state_69076[(4)])));

return statearr_69082;
})();
var state_69076__$1 = state_69076;
var ex69080 = (state_69076__$1[(2)]);
var statearr_69083_69096 = state_69076__$1;
(statearr_69083_69096[(5)] = ex69080);


if((ex69080 instanceof Error)){
var statearr_69084_69097 = state_69076__$1;
(statearr_69084_69097[(1)] = (4));

(statearr_69084_69097[(5)] = null);

} else {
throw ex69080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69077 === (6))){
var inst_69060 = (state_69076[(2)]);
var inst_69061 = fluree.db.util.async.throw_err(inst_69060);
var inst_69062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69061,(0),null);
var inst_69063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69061,(1),null);
var inst_69064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69065 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69066 = ["?s","?ctx",inst_69062];
var inst_69067 = cljs.core.PersistentHashMap.fromArrays(inst_69065,inst_69066);
var inst_69068 = ((10) + inst_69063);
var inst_69069 = [inst_69067,inst_69068];
var inst_69070 = (new cljs.core.PersistentVector(null,2,(5),inst_69064,inst_69069,null));
var inst_69071 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69070);
var _ = (function (){var statearr_69085 = state_69076;
(statearr_69085[(4)] = cljs.core.rest((state_69076[(4)])));

return statearr_69085;
})();
var state_69076__$1 = (function (){var statearr_69086 = state_69076;
(statearr_69086[(7)] = inst_69071);

return statearr_69086;
})();
var statearr_69087_69098 = state_69076__$1;
(statearr_69087_69098[(2)] = inst_69062);

(statearr_69087_69098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_69088 = [null,null,null,null,null,null,null,null];
(statearr_69088[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_69088[(1)] = (1));

return statearr_69088;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_69076){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69076);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69089){var ex__2730__auto__ = e69089;
var statearr_69090_69099 = state_69076;
(statearr_69090_69099[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69076[(4)]))){
var statearr_69091_69100 = state_69076;
(statearr_69091_69100[(1)] = cljs.core.first((state_69076[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69101 = state_69076;
state_69076 = G__69101;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_69076){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_69076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69092 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69092[(6)] = c__2749__auto__);

return statearr_69092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__69103 = arguments.length;
switch (G__69103) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69141){
var state_val_69142 = (state_69141[(1)]);
if((state_val_69142 === (7))){
var inst_69134 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_69141__$1 = state_69141;
var statearr_69143_69163 = state_69141__$1;
(statearr_69143_69163[(2)] = inst_69134);

(statearr_69143_69163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69142 === (1))){
var state_69141__$1 = state_69141;
var statearr_69144_69164 = state_69141__$1;
(statearr_69144_69164[(2)] = null);

(statearr_69144_69164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69142 === (4))){
var inst_69104 = (state_69141[(2)]);
var state_69141__$1 = state_69141;
var statearr_69145_69165 = state_69141__$1;
(statearr_69145_69165[(2)] = inst_69104);

(statearr_69145_69165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69142 === (6))){
var inst_69115 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_69141__$1 = state_69141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69141__$1,(10),inst_69115);
} else {
if((state_val_69142 === (3))){
var inst_69139 = (state_69141[(2)]);
var state_69141__$1 = state_69141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69141__$1,inst_69139);
} else {
if((state_val_69142 === (2))){
var _ = (function (){var statearr_69147 = state_69141;
(statearr_69147[(4)] = cljs.core.cons((5),(state_69141[(4)])));

return statearr_69147;
})();
var inst_69110 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_69141__$1 = state_69141;
if(cljs.core.truth_(inst_69110)){
var statearr_69148_69166 = state_69141__$1;
(statearr_69148_69166[(1)] = (6));

} else {
var statearr_69149_69167 = state_69141__$1;
(statearr_69149_69167[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69142 === (9))){
var inst_69121 = (state_69141[(2)]);
var inst_69122 = fluree.db.util.async.throw_err(inst_69121);
var inst_69123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69122,(0),null);
var inst_69124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69122,(1),null);
var inst_69125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69126 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69127 = ["?p","?ctx",inst_69123];
var inst_69128 = cljs.core.PersistentHashMap.fromArrays(inst_69126,inst_69127);
var inst_69129 = ((10) + inst_69124);
var inst_69130 = [inst_69128,inst_69129];
var inst_69131 = (new cljs.core.PersistentVector(null,2,(5),inst_69125,inst_69130,null));
var inst_69132 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69131);
var state_69141__$1 = (function (){var statearr_69150 = state_69141;
(statearr_69150[(7)] = inst_69132);

return statearr_69150;
})();
var statearr_69151_69168 = state_69141__$1;
(statearr_69151_69168[(2)] = inst_69123);

(statearr_69151_69168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69142 === (5))){
var _ = (function (){var statearr_69152 = state_69141;
(statearr_69152[(4)] = cljs.core.rest((state_69141[(4)])));

return statearr_69152;
})();
var state_69141__$1 = state_69141;
var ex69146 = (state_69141__$1[(2)]);
var statearr_69153_69169 = state_69141__$1;
(statearr_69153_69169[(5)] = ex69146);


if((ex69146 instanceof Error)){
var statearr_69154_69170 = state_69141__$1;
(statearr_69154_69170[(1)] = (4));

(statearr_69154_69170[(5)] = null);

} else {
throw ex69146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69142 === (10))){
var inst_69117 = (state_69141[(2)]);
var inst_69118 = fluree.db.util.async.throw_err(inst_69117);
var inst_69119 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_69118);
var state_69141__$1 = state_69141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69141__$1,(9),inst_69119);
} else {
if((state_val_69142 === (8))){
var inst_69136 = (state_69141[(2)]);
var _ = (function (){var statearr_69155 = state_69141;
(statearr_69155[(4)] = cljs.core.rest((state_69141[(4)])));

return statearr_69155;
})();
var state_69141__$1 = state_69141;
var statearr_69156_69171 = state_69141__$1;
(statearr_69156_69171[(2)] = inst_69136);

(statearr_69156_69171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_69157 = [null,null,null,null,null,null,null,null];
(statearr_69157[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_69157[(1)] = (1));

return statearr_69157;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_69141){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69141);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69158){var ex__2730__auto__ = e69158;
var statearr_69159_69172 = state_69141;
(statearr_69159_69172[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69141[(4)]))){
var statearr_69160_69173 = state_69141;
(statearr_69160_69173[(1)] = cljs.core.first((state_69141[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69174 = state_69141;
state_69141 = G__69174;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_69141){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_69141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69161 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69161[(6)] = c__2749__auto__);

return statearr_69161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69223 = arguments.length;
var i__5770__auto___69224 = (0);
while(true){
if((i__5770__auto___69224 < len__5769__auto___69223)){
args__5775__auto__.push((arguments[i__5770__auto___69224]));

var G__69225 = (i__5770__auto___69224 + (1));
i__5770__auto___69224 = G__69225;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69206){
var state_val_69207 = (state_69206[(1)]);
if((state_val_69207 === (1))){
var state_69206__$1 = state_69206;
var statearr_69208_69226 = state_69206__$1;
(statearr_69208_69226[(2)] = null);

(statearr_69208_69226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69207 === (2))){
var _ = (function (){var statearr_69209 = state_69206;
(statearr_69209[(4)] = cljs.core.cons((5),(state_69206[(4)])));

return statearr_69209;
})();
var inst_69183 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69206__$1 = state_69206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69206__$1,(6),inst_69183);
} else {
if((state_val_69207 === (3))){
var inst_69204 = (state_69206[(2)]);
var state_69206__$1 = state_69206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69206__$1,inst_69204);
} else {
if((state_val_69207 === (4))){
var inst_69177 = (state_69206[(2)]);
var state_69206__$1 = state_69206;
var statearr_69211_69227 = state_69206__$1;
(statearr_69211_69227[(2)] = inst_69177);

(statearr_69211_69227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69207 === (5))){
var _ = (function (){var statearr_69212 = state_69206;
(statearr_69212[(4)] = cljs.core.rest((state_69206[(4)])));

return statearr_69212;
})();
var state_69206__$1 = state_69206;
var ex69210 = (state_69206__$1[(2)]);
var statearr_69213_69228 = state_69206__$1;
(statearr_69213_69228[(5)] = ex69210);


if((ex69210 instanceof Error)){
var statearr_69214_69229 = state_69206__$1;
(statearr_69214_69229[(1)] = (4));

(statearr_69214_69229[(5)] = null);

} else {
throw ex69210;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69207 === (6))){
var inst_69185 = (state_69206[(2)]);
var inst_69186 = fluree.db.util.async.throw_err(inst_69185);
var inst_69187 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_69186);
var inst_69188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69189 = [inst_69186];
var inst_69190 = (new cljs.core.PersistentVector(null,1,(5),inst_69188,inst_69189,null));
var inst_69191 = cljs.core.count(inst_69190);
var inst_69192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69193 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69195 = [inst_69186];
var inst_69196 = (new cljs.core.PersistentVector(null,1,(5),inst_69194,inst_69195,null));
var inst_69197 = ["and",inst_69196,inst_69187];
var inst_69198 = cljs.core.PersistentHashMap.fromArrays(inst_69193,inst_69197);
var inst_69199 = [inst_69198,inst_69191];
var inst_69200 = (new cljs.core.PersistentVector(null,2,(5),inst_69192,inst_69199,null));
var inst_69201 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69200);
var _ = (function (){var statearr_69215 = state_69206;
(statearr_69215[(4)] = cljs.core.rest((state_69206[(4)])));

return statearr_69215;
})();
var state_69206__$1 = (function (){var statearr_69216 = state_69206;
(statearr_69216[(7)] = inst_69201);

return statearr_69216;
})();
var statearr_69217_69230 = state_69206__$1;
(statearr_69217_69230[(2)] = inst_69187);

(statearr_69217_69230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_69218 = [null,null,null,null,null,null,null,null];
(statearr_69218[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_69218[(1)] = (1));

return statearr_69218;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_69206){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69206);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69219){var ex__2730__auto__ = e69219;
var statearr_69220_69231 = state_69206;
(statearr_69220_69231[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69206[(4)]))){
var statearr_69221_69232 = state_69206;
(statearr_69221_69232[(1)] = cljs.core.first((state_69206[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69233 = state_69206;
state_69206 = G__69233;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_69206){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_69206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69222 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69222[(6)] = c__2749__auto__);

return statearr_69222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq69175){
var G__69176 = cljs.core.first(seq69175);
var seq69175__$1 = cljs.core.next(seq69175);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69176,seq69175__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69282 = arguments.length;
var i__5770__auto___69283 = (0);
while(true){
if((i__5770__auto___69283 < len__5769__auto___69282)){
args__5775__auto__.push((arguments[i__5770__auto___69283]));

var G__69284 = (i__5770__auto___69283 + (1));
i__5770__auto___69283 = G__69284;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69265){
var state_val_69266 = (state_69265[(1)]);
if((state_val_69266 === (1))){
var state_69265__$1 = state_69265;
var statearr_69267_69285 = state_69265__$1;
(statearr_69267_69285[(2)] = null);

(statearr_69267_69285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69266 === (2))){
var _ = (function (){var statearr_69268 = state_69265;
(statearr_69268[(4)] = cljs.core.cons((5),(state_69265[(4)])));

return statearr_69268;
})();
var inst_69242 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69265__$1 = state_69265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69265__$1,(6),inst_69242);
} else {
if((state_val_69266 === (3))){
var inst_69263 = (state_69265[(2)]);
var state_69265__$1 = state_69265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69265__$1,inst_69263);
} else {
if((state_val_69266 === (4))){
var inst_69236 = (state_69265[(2)]);
var state_69265__$1 = state_69265;
var statearr_69270_69286 = state_69265__$1;
(statearr_69270_69286[(2)] = inst_69236);

(statearr_69270_69286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69266 === (5))){
var _ = (function (){var statearr_69271 = state_69265;
(statearr_69271[(4)] = cljs.core.rest((state_69265[(4)])));

return statearr_69271;
})();
var state_69265__$1 = state_69265;
var ex69269 = (state_69265__$1[(2)]);
var statearr_69272_69287 = state_69265__$1;
(statearr_69272_69287[(5)] = ex69269);


if((ex69269 instanceof Error)){
var statearr_69273_69288 = state_69265__$1;
(statearr_69273_69288[(1)] = (4));

(statearr_69273_69288[(5)] = null);

} else {
throw ex69269;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69266 === (6))){
var inst_69244 = (state_69265[(2)]);
var inst_69245 = fluree.db.util.async.throw_err(inst_69244);
var inst_69246 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_69245);
var inst_69247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69248 = [inst_69245];
var inst_69249 = (new cljs.core.PersistentVector(null,1,(5),inst_69247,inst_69248,null));
var inst_69250 = cljs.core.count(inst_69249);
var inst_69251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69252 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69254 = [inst_69245];
var inst_69255 = (new cljs.core.PersistentVector(null,1,(5),inst_69253,inst_69254,null));
var inst_69256 = ["or",inst_69255,inst_69246];
var inst_69257 = cljs.core.PersistentHashMap.fromArrays(inst_69252,inst_69256);
var inst_69258 = [inst_69257,inst_69250];
var inst_69259 = (new cljs.core.PersistentVector(null,2,(5),inst_69251,inst_69258,null));
var inst_69260 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69259);
var _ = (function (){var statearr_69274 = state_69265;
(statearr_69274[(4)] = cljs.core.rest((state_69265[(4)])));

return statearr_69274;
})();
var state_69265__$1 = (function (){var statearr_69275 = state_69265;
(statearr_69275[(7)] = inst_69260);

return statearr_69275;
})();
var statearr_69276_69289 = state_69265__$1;
(statearr_69276_69289[(2)] = inst_69246);

(statearr_69276_69289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_69277 = [null,null,null,null,null,null,null,null];
(statearr_69277[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_69277[(1)] = (1));

return statearr_69277;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_69265){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69265);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69278){var ex__2730__auto__ = e69278;
var statearr_69279_69290 = state_69265;
(statearr_69279_69290[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69265[(4)]))){
var statearr_69280_69291 = state_69265;
(statearr_69280_69291[(1)] = cljs.core.first((state_69265[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69292 = state_69265;
state_69265 = G__69292;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_69265){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_69265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69281 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69281[(6)] = c__2749__auto__);

return statearr_69281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq69234){
var G__69235 = cljs.core.first(seq69234);
var seq69234__$1 = cljs.core.next(seq69234);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69235,seq69234__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69330){
var state_val_69331 = (state_69330[(1)]);
if((state_val_69331 === (7))){
var inst_69306 = fluree.db.util.async.channel_QMARK_(coll);
var state_69330__$1 = state_69330;
if(inst_69306){
var statearr_69332_69355 = state_69330__$1;
(statearr_69332_69355[(1)] = (10));

} else {
var statearr_69333_69356 = state_69330__$1;
(statearr_69333_69356[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (1))){
var state_69330__$1 = state_69330;
var statearr_69334_69357 = state_69330__$1;
(statearr_69334_69357[(2)] = null);

(statearr_69334_69357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (4))){
var inst_69293 = (state_69330[(2)]);
var state_69330__$1 = state_69330;
var statearr_69335_69358 = state_69330__$1;
(statearr_69335_69358[(2)] = inst_69293);

(statearr_69335_69358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (13))){
var inst_69309 = (state_69330[(2)]);
var inst_69310 = fluree.db.util.async.throw_err(inst_69309);
var state_69330__$1 = state_69330;
var statearr_69336_69359 = state_69330__$1;
(statearr_69336_69359[(2)] = inst_69310);

(statearr_69336_69359[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (6))){
var inst_69301 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_69330__$1 = state_69330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69330__$1,(9),inst_69301);
} else {
if((state_val_69331 === (3))){
var inst_69328 = (state_69330[(2)]);
var state_69330__$1 = state_69330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69330__$1,inst_69328);
} else {
if((state_val_69331 === (12))){
var inst_69313 = (state_69330[(2)]);
var state_69330__$1 = state_69330;
var statearr_69337_69360 = state_69330__$1;
(statearr_69337_69360[(2)] = inst_69313);

(statearr_69337_69360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (2))){
var _ = (function (){var statearr_69338 = state_69330;
(statearr_69338[(4)] = cljs.core.cons((5),(state_69330[(4)])));

return statearr_69338;
})();
var inst_69299 = cljs.core.vector_QMARK_(coll);
var state_69330__$1 = state_69330;
if(inst_69299){
var statearr_69339_69361 = state_69330__$1;
(statearr_69339_69361[(1)] = (6));

} else {
var statearr_69340_69362 = state_69330__$1;
(statearr_69340_69362[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (11))){
var state_69330__$1 = state_69330;
var statearr_69342_69363 = state_69330__$1;
(statearr_69342_69363[(2)] = coll);

(statearr_69342_69363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (9))){
var inst_69303 = (state_69330[(2)]);
var inst_69304 = fluree.db.util.async.throw_err(inst_69303);
var state_69330__$1 = state_69330;
var statearr_69343_69364 = state_69330__$1;
(statearr_69343_69364[(2)] = inst_69304);

(statearr_69343_69364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (5))){
var _ = (function (){var statearr_69344 = state_69330;
(statearr_69344[(4)] = cljs.core.rest((state_69330[(4)])));

return statearr_69344;
})();
var state_69330__$1 = state_69330;
var ex69341 = (state_69330__$1[(2)]);
var statearr_69345_69365 = state_69330__$1;
(statearr_69345_69365[(5)] = ex69341);


if((ex69341 instanceof Error)){
var statearr_69346_69366 = state_69330__$1;
(statearr_69346_69366[(1)] = (4));

(statearr_69346_69366[(5)] = null);

} else {
throw ex69341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69331 === (10))){
var state_69330__$1 = state_69330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69330__$1,(13),coll);
} else {
if((state_val_69331 === (8))){
var inst_69315 = (state_69330[(2)]);
var inst_69316 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_69315);
var inst_69317 = cljs.core.count(inst_69316);
var inst_69318 = ((9) + inst_69317);
var inst_69319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69320 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69321 = ["count",inst_69315,inst_69317];
var inst_69322 = cljs.core.PersistentHashMap.fromArrays(inst_69320,inst_69321);
var inst_69323 = [inst_69322,inst_69318];
var inst_69324 = (new cljs.core.PersistentVector(null,2,(5),inst_69319,inst_69323,null));
var inst_69325 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69324);
var _ = (function (){var statearr_69347 = state_69330;
(statearr_69347[(4)] = cljs.core.rest((state_69330[(4)])));

return statearr_69347;
})();
var state_69330__$1 = (function (){var statearr_69348 = state_69330;
(statearr_69348[(7)] = inst_69325);

return statearr_69348;
})();
var statearr_69349_69367 = state_69330__$1;
(statearr_69349_69367[(2)] = inst_69317);

(statearr_69349_69367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_69350 = [null,null,null,null,null,null,null,null];
(statearr_69350[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_69350[(1)] = (1));

return statearr_69350;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_69330){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69330);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69351){var ex__2730__auto__ = e69351;
var statearr_69352_69368 = state_69330;
(statearr_69352_69368[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69330[(4)]))){
var statearr_69353_69369 = state_69330;
(statearr_69353_69369[(1)] = cljs.core.first((state_69330[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69370 = state_69330;
state_69330 = G__69370;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_69330){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_69330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69354 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69354[(6)] = c__2749__auto__);

return statearr_69354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__69371,subject,pred){
var map__69372 = p__69371;
var map__69372__$1 = cljs.core.__destructure_map(map__69372);
var _QMARK_ctx = map__69372__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69372__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69372__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69463){
var state_val_69464 = (state_69463[(1)]);
if((state_val_69464 === (7))){
var state_69463__$1 = state_69463;
var statearr_69465_69521 = state_69463__$1;
(statearr_69465_69521[(2)] = subject);

(statearr_69465_69521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (20))){
var state_69463__$1 = state_69463;
var statearr_69466_69522 = state_69463__$1;
(statearr_69466_69522[(2)] = cache);

(statearr_69466_69522[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (27))){
var inst_69406 = (state_69463[(7)]);
var inst_69394 = (state_69463[(8)]);
var inst_69420 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_69406,inst_69394);
var state_69463__$1 = state_69463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69463__$1,(29),inst_69420);
} else {
if((state_val_69464 === (1))){
var state_69463__$1 = state_69463;
var statearr_69467_69523 = state_69463__$1;
(statearr_69467_69523[(2)] = null);

(statearr_69467_69523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (24))){
var inst_69406 = (state_69463[(7)]);
var inst_69433 = cljs.core.int_QMARK_(inst_69406);
var state_69463__$1 = state_69463;
if(inst_69433){
var statearr_69468_69524 = state_69463__$1;
(statearr_69468_69524[(1)] = (30));

} else {
var statearr_69469_69525 = state_69463__$1;
(statearr_69469_69525[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (4))){
var inst_69373 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
var statearr_69470_69526 = state_69463__$1;
(statearr_69470_69526[(2)] = inst_69373);

(statearr_69470_69526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (15))){
var inst_69386 = (state_69463[(9)]);
var state_69463__$1 = state_69463;
var statearr_69471_69527 = state_69463__$1;
(statearr_69471_69527[(2)] = inst_69386);

(statearr_69471_69527[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (21))){
var inst_69407 = (state_69463[(10)]);
var state_69463__$1 = state_69463;
var statearr_69472_69528 = state_69463__$1;
(statearr_69472_69528[(2)] = inst_69407);

(statearr_69472_69528[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (31))){
var state_69463__$1 = state_69463;
var statearr_69473_69529 = state_69463__$1;
(statearr_69473_69529[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (32))){
var inst_69446 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
var statearr_69475_69530 = state_69463__$1;
(statearr_69475_69530[(2)] = inst_69446);

(statearr_69475_69530[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (33))){
var inst_69437 = (state_69463[(2)]);
var inst_69438 = fluree.db.util.async.throw_err(inst_69437);
var state_69463__$1 = state_69463;
var statearr_69476_69531 = state_69463__$1;
(statearr_69476_69531[(2)] = inst_69438);

(statearr_69476_69531[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (13))){
var inst_69390 = (state_69463[(2)]);
var inst_69391 = fluree.db.util.async.throw_err(inst_69390);
var state_69463__$1 = state_69463;
var statearr_69477_69532 = state_69463__$1;
(statearr_69477_69532[(2)] = inst_69391);

(statearr_69477_69532[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (22))){
var inst_69411 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
if(cljs.core.truth_(inst_69411)){
var statearr_69478_69533 = state_69463__$1;
(statearr_69478_69533[(1)] = (23));

} else {
var statearr_69479_69534 = state_69463__$1;
(statearr_69479_69534[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (36))){
var inst_69444 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
var statearr_69480_69535 = state_69463__$1;
(statearr_69480_69535[(2)] = inst_69444);

(statearr_69480_69535[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (29))){
var inst_69406 = (state_69463[(7)]);
var inst_69394 = (state_69463[(8)]);
var inst_69422 = (state_69463[(2)]);
var inst_69423 = fluree.db.util.async.throw_err(inst_69422);
var inst_69424 = cljs.core._deref(cache);
var inst_69425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69426 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_69406,inst_69394];
var inst_69427 = (new cljs.core.PersistentVector(null,3,(5),inst_69425,inst_69426,null));
var inst_69428 = cljs.core.assoc_in(inst_69424,inst_69427,inst_69423);
var inst_69429 = cljs.core._vreset_BANG_(cache,inst_69428);
var state_69463__$1 = (function (){var statearr_69481 = state_69463;
(statearr_69481[(11)] = inst_69429);

return statearr_69481;
})();
var statearr_69482_69536 = state_69463__$1;
(statearr_69482_69536[(2)] = inst_69423);

(statearr_69482_69536[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (6))){
var state_69463__$1 = state_69463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69463__$1,(9),subject);
} else {
if((state_val_69464 === (28))){
var inst_69431 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
var statearr_69483_69537 = state_69463__$1;
(statearr_69483_69537[(2)] = inst_69431);

(statearr_69483_69537[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (25))){
var inst_69386 = (state_69463[(9)]);
var inst_69394 = (state_69463[(8)]);
var inst_69448 = (state_69463[(2)]);
var inst_69449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69450 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69452 = [inst_69386,inst_69394];
var inst_69453 = (new cljs.core.PersistentVector(null,2,(5),inst_69451,inst_69452,null));
var inst_69454 = ["get",inst_69453,inst_69448];
var inst_69455 = cljs.core.PersistentHashMap.fromArrays(inst_69450,inst_69454);
var inst_69456 = [inst_69455,(10)];
var inst_69457 = (new cljs.core.PersistentVector(null,2,(5),inst_69449,inst_69456,null));
var inst_69458 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69457);
var _ = (function (){var statearr_69484 = state_69463;
(statearr_69484[(4)] = cljs.core.rest((state_69463[(4)])));

return statearr_69484;
})();
var state_69463__$1 = (function (){var statearr_69485 = state_69463;
(statearr_69485[(12)] = inst_69458);

return statearr_69485;
})();
var statearr_69486_69538 = state_69463__$1;
(statearr_69486_69538[(2)] = inst_69448);

(statearr_69486_69538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (34))){
var inst_69406 = (state_69463[(7)]);
var inst_69394 = (state_69463[(8)]);
var inst_69441 = fluree.db.dbfunctions.internal.get(inst_69406,inst_69394);
var state_69463__$1 = state_69463;
var statearr_69487_69539 = state_69463__$1;
(statearr_69487_69539[(2)] = inst_69441);

(statearr_69487_69539[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (17))){
var inst_69386 = (state_69463[(9)]);
var inst_69400 = cljs.core.first(inst_69386);
var state_69463__$1 = state_69463;
var statearr_69488_69540 = state_69463__$1;
(statearr_69488_69540[(2)] = inst_69400);

(statearr_69488_69540[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (3))){
var inst_69461 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69463__$1,inst_69461);
} else {
if((state_val_69464 === (12))){
var inst_69386 = (state_69463[(9)]);
var inst_69394 = (state_69463[(2)]);
var inst_69395 = cljs.core.vector_QMARK_(inst_69386);
var state_69463__$1 = (function (){var statearr_69489 = state_69463;
(statearr_69489[(8)] = inst_69394);

return statearr_69489;
})();
if(inst_69395){
var statearr_69490_69541 = state_69463__$1;
(statearr_69490_69541[(1)] = (14));

} else {
var statearr_69491_69542 = state_69463__$1;
(statearr_69491_69542[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (2))){
var _ = (function (){var statearr_69492 = state_69463;
(statearr_69492[(4)] = cljs.core.cons((5),(state_69463[(4)])));

return statearr_69492;
})();
var inst_69379 = fluree.db.util.async.channel_QMARK_(subject);
var state_69463__$1 = state_69463;
if(inst_69379){
var statearr_69493_69543 = state_69463__$1;
(statearr_69493_69543[(1)] = (6));

} else {
var statearr_69494_69544 = state_69463__$1;
(statearr_69494_69544[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (23))){
var inst_69406 = (state_69463[(7)]);
var inst_69417 = (state_69463[(13)]);
var inst_69394 = (state_69463[(8)]);
var inst_69413 = cljs.core.deref(cache);
var inst_69414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69415 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_69406,inst_69394];
var inst_69416 = (new cljs.core.PersistentVector(null,3,(5),inst_69414,inst_69415,null));
var inst_69417__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_69413,inst_69416);
var state_69463__$1 = (function (){var statearr_69495 = state_69463;
(statearr_69495[(13)] = inst_69417__$1);

return statearr_69495;
})();
if(cljs.core.truth_(inst_69417__$1)){
var statearr_69496_69545 = state_69463__$1;
(statearr_69496_69545[(1)] = (26));

} else {
var statearr_69497_69546 = state_69463__$1;
(statearr_69497_69546[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (35))){
var state_69463__$1 = state_69463;
var statearr_69498_69547 = state_69463__$1;
(statearr_69498_69547[(2)] = null);

(statearr_69498_69547[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (19))){
var inst_69403 = (state_69463[(2)]);
var state_69463__$1 = state_69463;
var statearr_69499_69548 = state_69463__$1;
(statearr_69499_69548[(2)] = inst_69403);

(statearr_69499_69548[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (11))){
var state_69463__$1 = state_69463;
var statearr_69501_69549 = state_69463__$1;
(statearr_69501_69549[(2)] = pred);

(statearr_69501_69549[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (9))){
var inst_69382 = (state_69463[(2)]);
var inst_69383 = fluree.db.util.async.throw_err(inst_69382);
var state_69463__$1 = state_69463;
var statearr_69502_69550 = state_69463__$1;
(statearr_69502_69550[(2)] = inst_69383);

(statearr_69502_69550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (5))){
var _ = (function (){var statearr_69503 = state_69463;
(statearr_69503[(4)] = cljs.core.rest((state_69463[(4)])));

return statearr_69503;
})();
var state_69463__$1 = state_69463;
var ex69500 = (state_69463__$1[(2)]);
var statearr_69504_69551 = state_69463__$1;
(statearr_69504_69551[(5)] = ex69500);


if((ex69500 instanceof Error)){
var statearr_69505_69552 = state_69463__$1;
(statearr_69505_69552[(1)] = (4));

(statearr_69505_69552[(5)] = null);

} else {
throw ex69500;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (14))){
var inst_69386 = (state_69463[(9)]);
var inst_69397 = cljs.core.count(inst_69386);
var inst_69398 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_69397);
var state_69463__$1 = state_69463;
if(inst_69398){
var statearr_69506_69553 = state_69463__$1;
(statearr_69506_69553[(1)] = (17));

} else {
var statearr_69507_69554 = state_69463__$1;
(statearr_69507_69554[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (26))){
var inst_69417 = (state_69463[(13)]);
var state_69463__$1 = state_69463;
var statearr_69508_69555 = state_69463__$1;
(statearr_69508_69555[(2)] = inst_69417);

(statearr_69508_69555[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (16))){
var inst_69406 = (state_69463[(7)]);
var inst_69407 = (state_69463[(10)]);
var inst_69406__$1 = (state_69463[(2)]);
var inst_69407__$1 = cljs.core.int_QMARK_(inst_69406__$1);
var state_69463__$1 = (function (){var statearr_69509 = state_69463;
(statearr_69509[(7)] = inst_69406__$1);

(statearr_69509[(10)] = inst_69407__$1);

return statearr_69509;
})();
if(inst_69407__$1){
var statearr_69510_69556 = state_69463__$1;
(statearr_69510_69556[(1)] = (20));

} else {
var statearr_69511_69557 = state_69463__$1;
(statearr_69511_69557[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (30))){
var inst_69406 = (state_69463[(7)]);
var inst_69394 = (state_69463[(8)]);
var inst_69435 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_69406,inst_69394);
var state_69463__$1 = state_69463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69463__$1,(33),inst_69435);
} else {
if((state_val_69464 === (10))){
var state_69463__$1 = state_69463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69463__$1,(13),pred);
} else {
if((state_val_69464 === (18))){
var inst_69386 = (state_69463[(9)]);
var state_69463__$1 = state_69463;
var statearr_69512_69558 = state_69463__$1;
(statearr_69512_69558[(2)] = inst_69386);

(statearr_69512_69558[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69464 === (8))){
var inst_69386 = (state_69463[(2)]);
var inst_69387 = fluree.db.util.async.channel_QMARK_(pred);
var state_69463__$1 = (function (){var statearr_69513 = state_69463;
(statearr_69513[(9)] = inst_69386);

return statearr_69513;
})();
if(inst_69387){
var statearr_69514_69559 = state_69463__$1;
(statearr_69514_69559[(1)] = (10));

} else {
var statearr_69515_69560 = state_69463__$1;
(statearr_69515_69560[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_69516 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69516[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_69516[(1)] = (1));

return statearr_69516;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_69463){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69463);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69517){var ex__2730__auto__ = e69517;
var statearr_69518_69561 = state_69463;
(statearr_69518_69561[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69463[(4)]))){
var statearr_69519_69562 = state_69463;
(statearr_69519_69562[(1)] = cljs.core.first((state_69463[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69563 = state_69463;
state_69463 = G__69563;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_69463){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_69463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69520 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69520[(6)] = c__2749__auto__);

return statearr_69520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69602){
var state_val_69603 = (state_69602[(1)]);
if((state_val_69603 === (7))){
var inst_69570 = (state_69602[(7)]);
var state_69602__$1 = state_69602;
var statearr_69604_69628 = state_69602__$1;
(statearr_69604_69628[(2)] = inst_69570);

(statearr_69604_69628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (1))){
var state_69602__$1 = state_69602;
var statearr_69605_69629 = state_69602__$1;
(statearr_69605_69629[(2)] = null);

(statearr_69605_69629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (4))){
var inst_69564 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69606_69630 = state_69602__$1;
(statearr_69606_69630[(2)] = inst_69564);

(statearr_69606_69630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (6))){
var inst_69572 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_69602__$1 = state_69602;
var statearr_69607_69631 = state_69602__$1;
(statearr_69607_69631[(2)] = inst_69572);

(statearr_69607_69631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (3))){
var inst_69600 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69602__$1,inst_69600);
} else {
if((state_val_69603 === (12))){
var inst_69582 = (state_69602[(2)]);
var inst_69583 = fluree.db.util.async.throw_err(inst_69582);
var inst_69584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69583,(0),null);
var inst_69585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69583,(1),null);
var inst_69586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69587 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69588 = ["?pO","?ctx",inst_69584];
var inst_69589 = cljs.core.PersistentHashMap.fromArrays(inst_69587,inst_69588);
var inst_69590 = ((10) + inst_69585);
var inst_69591 = [inst_69589,inst_69590];
var inst_69592 = (new cljs.core.PersistentVector(null,2,(5),inst_69586,inst_69591,null));
var inst_69593 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69592);
var state_69602__$1 = (function (){var statearr_69608 = state_69602;
(statearr_69608[(8)] = inst_69593);

return statearr_69608;
})();
var statearr_69609_69632 = state_69602__$1;
(statearr_69609_69632[(2)] = inst_69584);

(statearr_69609_69632[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (2))){
var inst_69570 = (state_69602[(7)]);
var _ = (function (){var statearr_69610 = state_69602;
(statearr_69610[(4)] = cljs.core.cons((5),(state_69602[(4)])));

return statearr_69610;
})();
var inst_69570__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_69602__$1 = (function (){var statearr_69611 = state_69602;
(statearr_69611[(7)] = inst_69570__$1);

return statearr_69611;
})();
if(cljs.core.truth_(inst_69570__$1)){
var statearr_69612_69633 = state_69602__$1;
(statearr_69612_69633[(1)] = (6));

} else {
var statearr_69613_69634 = state_69602__$1;
(statearr_69613_69634[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (11))){
var inst_69597 = (state_69602[(2)]);
var _ = (function (){var statearr_69615 = state_69602;
(statearr_69615[(4)] = cljs.core.rest((state_69602[(4)])));

return statearr_69615;
})();
var state_69602__$1 = state_69602;
var statearr_69616_69635 = state_69602__$1;
(statearr_69616_69635[(2)] = inst_69597);

(statearr_69616_69635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (9))){
var inst_69580 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69602__$1,(12),inst_69580);
} else {
if((state_val_69603 === (5))){
var _ = (function (){var statearr_69617 = state_69602;
(statearr_69617[(4)] = cljs.core.rest((state_69602[(4)])));

return statearr_69617;
})();
var state_69602__$1 = state_69602;
var ex69614 = (state_69602__$1[(2)]);
var statearr_69618_69636 = state_69602__$1;
(statearr_69618_69636[(5)] = ex69614);


if((ex69614 instanceof Error)){
var statearr_69619_69637 = state_69602__$1;
(statearr_69619_69637[(1)] = (4));

(statearr_69619_69637[(5)] = null);

} else {
throw ex69614;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (10))){
var inst_69595 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_69602__$1 = state_69602;
var statearr_69620_69638 = state_69602__$1;
(statearr_69620_69638[(2)] = inst_69595);

(statearr_69620_69638[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (8))){
var inst_69575 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
if(cljs.core.truth_(inst_69575)){
var statearr_69621_69639 = state_69602__$1;
(statearr_69621_69639[(1)] = (9));

} else {
var statearr_69622_69640 = state_69602__$1;
(statearr_69622_69640[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_69623 = [null,null,null,null,null,null,null,null,null];
(statearr_69623[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_69623[(1)] = (1));

return statearr_69623;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_69602){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69602);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69624){var ex__2730__auto__ = e69624;
var statearr_69625_69641 = state_69602;
(statearr_69625_69641[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69602[(4)]))){
var statearr_69626_69642 = state_69602;
(statearr_69626_69642[(1)] = cljs.core.first((state_69602[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69643 = state_69602;
state_69602 = G__69643;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_69602){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_69602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69627 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69627[(6)] = c__2749__auto__);

return statearr_69627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69712){
var state_val_69713 = (state_69712[(1)]);
if((state_val_69713 === (7))){
var state_69712__$1 = state_69712;
var statearr_69714_69752 = state_69712__$1;
(statearr_69714_69752[(2)] = subject);

(statearr_69714_69752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (20))){
var inst_69680 = (state_69712[(7)]);
var inst_69668 = (state_69712[(8)]);
var inst_69683 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_69680,inst_69668);
var state_69712__$1 = state_69712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69712__$1,(23),inst_69683);
} else {
if((state_val_69713 === (1))){
var state_69712__$1 = state_69712;
var statearr_69715_69753 = state_69712__$1;
(statearr_69715_69753[(2)] = null);

(statearr_69715_69753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (4))){
var inst_69644 = (state_69712[(2)]);
var state_69712__$1 = state_69712;
var statearr_69716_69754 = state_69712__$1;
(statearr_69716_69754[(2)] = inst_69644);

(statearr_69716_69754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (15))){
var inst_69660 = (state_69712[(9)]);
var state_69712__$1 = state_69712;
var statearr_69717_69755 = state_69712__$1;
(statearr_69717_69755[(2)] = inst_69660);

(statearr_69717_69755[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (21))){
var inst_69680 = (state_69712[(7)]);
var inst_69668 = (state_69712[(8)]);
var inst_69688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69689 = fluree.db.dbfunctions.internal.get_all(inst_69680,inst_69668);
var inst_69690 = cljs.core.count(inst_69668);
var inst_69691 = ((9) + inst_69690);
var inst_69692 = [inst_69689,inst_69691];
var inst_69693 = (new cljs.core.PersistentVector(null,2,(5),inst_69688,inst_69692,null));
var state_69712__$1 = state_69712;
var statearr_69718_69756 = state_69712__$1;
(statearr_69718_69756[(2)] = inst_69693);

(statearr_69718_69756[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (13))){
var inst_69664 = (state_69712[(2)]);
var inst_69665 = fluree.db.util.async.throw_err(inst_69664);
var state_69712__$1 = state_69712;
var statearr_69719_69757 = state_69712__$1;
(statearr_69719_69757[(2)] = inst_69665);

(statearr_69719_69757[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (22))){
var inst_69660 = (state_69712[(9)]);
var inst_69668 = (state_69712[(8)]);
var inst_69695 = (state_69712[(2)]);
var inst_69696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69695,(0),null);
var inst_69697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69695,(1),null);
var inst_69698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69699 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69701 = [inst_69660,inst_69668];
var inst_69702 = (new cljs.core.PersistentVector(null,2,(5),inst_69700,inst_69701,null));
var inst_69703 = ["get-all",inst_69702,inst_69696];
var inst_69704 = cljs.core.PersistentHashMap.fromArrays(inst_69699,inst_69703);
var inst_69705 = [inst_69704,inst_69697];
var inst_69706 = (new cljs.core.PersistentVector(null,2,(5),inst_69698,inst_69705,null));
var inst_69707 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69706);
var _ = (function (){var statearr_69720 = state_69712;
(statearr_69720[(4)] = cljs.core.rest((state_69712[(4)])));

return statearr_69720;
})();
var state_69712__$1 = (function (){var statearr_69721 = state_69712;
(statearr_69721[(10)] = inst_69707);

return statearr_69721;
})();
var statearr_69722_69758 = state_69712__$1;
(statearr_69722_69758[(2)] = inst_69696);

(statearr_69722_69758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (6))){
var state_69712__$1 = state_69712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69712__$1,(9),subject);
} else {
if((state_val_69713 === (17))){
var inst_69660 = (state_69712[(9)]);
var inst_69674 = cljs.core.first(inst_69660);
var state_69712__$1 = state_69712;
var statearr_69723_69759 = state_69712__$1;
(statearr_69723_69759[(2)] = inst_69674);

(statearr_69723_69759[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (3))){
var inst_69710 = (state_69712[(2)]);
var state_69712__$1 = state_69712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69712__$1,inst_69710);
} else {
if((state_val_69713 === (12))){
var inst_69660 = (state_69712[(9)]);
var inst_69668 = (state_69712[(2)]);
var inst_69669 = cljs.core.vector_QMARK_(inst_69660);
var state_69712__$1 = (function (){var statearr_69724 = state_69712;
(statearr_69724[(8)] = inst_69668);

return statearr_69724;
})();
if(inst_69669){
var statearr_69725_69760 = state_69712__$1;
(statearr_69725_69760[(1)] = (14));

} else {
var statearr_69726_69761 = state_69712__$1;
(statearr_69726_69761[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (2))){
var _ = (function (){var statearr_69727 = state_69712;
(statearr_69727[(4)] = cljs.core.cons((5),(state_69712[(4)])));

return statearr_69727;
})();
var inst_69653 = fluree.db.util.async.channel_QMARK_(subject);
var state_69712__$1 = state_69712;
if(inst_69653){
var statearr_69728_69762 = state_69712__$1;
(statearr_69728_69762[(1)] = (6));

} else {
var statearr_69729_69763 = state_69712__$1;
(statearr_69729_69763[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (23))){
var inst_69685 = (state_69712[(2)]);
var inst_69686 = fluree.db.util.async.throw_err(inst_69685);
var state_69712__$1 = state_69712;
var statearr_69730_69764 = state_69712__$1;
(statearr_69730_69764[(2)] = inst_69686);

(statearr_69730_69764[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (19))){
var inst_69677 = (state_69712[(2)]);
var state_69712__$1 = state_69712;
var statearr_69731_69765 = state_69712__$1;
(statearr_69731_69765[(2)] = inst_69677);

(statearr_69731_69765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (11))){
var state_69712__$1 = state_69712;
var statearr_69733_69766 = state_69712__$1;
(statearr_69733_69766[(2)] = path);

(statearr_69733_69766[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (9))){
var inst_69656 = (state_69712[(2)]);
var inst_69657 = fluree.db.util.async.throw_err(inst_69656);
var state_69712__$1 = state_69712;
var statearr_69734_69767 = state_69712__$1;
(statearr_69734_69767[(2)] = inst_69657);

(statearr_69734_69767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (5))){
var _ = (function (){var statearr_69735 = state_69712;
(statearr_69735[(4)] = cljs.core.rest((state_69712[(4)])));

return statearr_69735;
})();
var state_69712__$1 = state_69712;
var ex69732 = (state_69712__$1[(2)]);
var statearr_69736_69768 = state_69712__$1;
(statearr_69736_69768[(5)] = ex69732);


if((ex69732 instanceof Error)){
var statearr_69737_69769 = state_69712__$1;
(statearr_69737_69769[(1)] = (4));

(statearr_69737_69769[(5)] = null);

} else {
throw ex69732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (14))){
var inst_69660 = (state_69712[(9)]);
var inst_69671 = cljs.core.count(inst_69660);
var inst_69672 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_69671);
var state_69712__$1 = state_69712;
if(inst_69672){
var statearr_69738_69770 = state_69712__$1;
(statearr_69738_69770[(1)] = (17));

} else {
var statearr_69739_69771 = state_69712__$1;
(statearr_69739_69771[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (16))){
var inst_69680 = (state_69712[(7)]);
var inst_69680__$1 = (state_69712[(2)]);
var inst_69681 = cljs.core.int_QMARK_(inst_69680__$1);
var state_69712__$1 = (function (){var statearr_69740 = state_69712;
(statearr_69740[(7)] = inst_69680__$1);

return statearr_69740;
})();
if(inst_69681){
var statearr_69741_69772 = state_69712__$1;
(statearr_69741_69772[(1)] = (20));

} else {
var statearr_69742_69773 = state_69712__$1;
(statearr_69742_69773[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (10))){
var state_69712__$1 = state_69712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69712__$1,(13),path);
} else {
if((state_val_69713 === (18))){
var inst_69660 = (state_69712[(9)]);
var state_69712__$1 = state_69712;
var statearr_69743_69774 = state_69712__$1;
(statearr_69743_69774[(2)] = inst_69660);

(statearr_69743_69774[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (8))){
var inst_69660 = (state_69712[(2)]);
var inst_69661 = fluree.db.util.async.channel_QMARK_(path);
var state_69712__$1 = (function (){var statearr_69744 = state_69712;
(statearr_69744[(9)] = inst_69660);

return statearr_69744;
})();
if(inst_69661){
var statearr_69745_69775 = state_69712__$1;
(statearr_69745_69775[(1)] = (10));

} else {
var statearr_69746_69776 = state_69712__$1;
(statearr_69746_69776[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_69747 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69747[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_69747[(1)] = (1));

return statearr_69747;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_69712){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69712);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69748){var ex__2730__auto__ = e69748;
var statearr_69749_69777 = state_69712;
(statearr_69749_69777[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69712[(4)]))){
var statearr_69750_69778 = state_69712;
(statearr_69750_69778[(1)] = cljs.core.first((state_69712[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69779 = state_69712;
state_69712 = G__69779;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_69712){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_69712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69751 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69751[(6)] = c__2749__auto__);

return statearr_69751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69818){
var state_val_69819 = (state_69818[(1)]);
if((state_val_69819 === (7))){
var state_69818__$1 = state_69818;
var statearr_69820_69844 = state_69818__$1;
(statearr_69820_69844[(2)] = subject);

(statearr_69820_69844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (1))){
var state_69818__$1 = state_69818;
var statearr_69821_69845 = state_69818__$1;
(statearr_69821_69845[(2)] = null);

(statearr_69821_69845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (4))){
var inst_69780 = (state_69818[(2)]);
var state_69818__$1 = state_69818;
var statearr_69822_69846 = state_69818__$1;
(statearr_69822_69846[(2)] = inst_69780);

(statearr_69822_69846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (13))){
var inst_69797 = (state_69818[(2)]);
var inst_69798 = fluree.db.util.async.throw_err(inst_69797);
var state_69818__$1 = state_69818;
var statearr_69823_69847 = state_69818__$1;
(statearr_69823_69847[(2)] = inst_69798);

(statearr_69823_69847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (6))){
var state_69818__$1 = state_69818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69818__$1,(9),subject);
} else {
if((state_val_69819 === (3))){
var inst_69816 = (state_69818[(2)]);
var state_69818__$1 = state_69818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69818__$1,inst_69816);
} else {
if((state_val_69819 === (12))){
var inst_69793 = (state_69818[(7)]);
var inst_69801 = (state_69818[(2)]);
var inst_69802 = fluree.db.dbfunctions.internal.get_in(inst_69793,inst_69801);
var inst_69803 = cljs.core.count(inst_69801);
var inst_69804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69805 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69807 = [inst_69793,inst_69801];
var inst_69808 = (new cljs.core.PersistentVector(null,2,(5),inst_69806,inst_69807,null));
var inst_69809 = ["get-in",inst_69808,inst_69802];
var inst_69810 = cljs.core.PersistentHashMap.fromArrays(inst_69805,inst_69809);
var inst_69811 = [inst_69810,inst_69803];
var inst_69812 = (new cljs.core.PersistentVector(null,2,(5),inst_69804,inst_69811,null));
var inst_69813 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69812);
var _ = (function (){var statearr_69824 = state_69818;
(statearr_69824[(4)] = cljs.core.rest((state_69818[(4)])));

return statearr_69824;
})();
var state_69818__$1 = (function (){var statearr_69825 = state_69818;
(statearr_69825[(8)] = inst_69813);

return statearr_69825;
})();
var statearr_69826_69848 = state_69818__$1;
(statearr_69826_69848[(2)] = inst_69802);

(statearr_69826_69848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (2))){
var _ = (function (){var statearr_69827 = state_69818;
(statearr_69827[(4)] = cljs.core.cons((5),(state_69818[(4)])));

return statearr_69827;
})();
var inst_69786 = fluree.db.util.async.channel_QMARK_(subject);
var state_69818__$1 = state_69818;
if(inst_69786){
var statearr_69828_69849 = state_69818__$1;
(statearr_69828_69849[(1)] = (6));

} else {
var statearr_69829_69850 = state_69818__$1;
(statearr_69829_69850[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (11))){
var state_69818__$1 = state_69818;
var statearr_69831_69851 = state_69818__$1;
(statearr_69831_69851[(2)] = path);

(statearr_69831_69851[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (9))){
var inst_69789 = (state_69818[(2)]);
var inst_69790 = fluree.db.util.async.throw_err(inst_69789);
var state_69818__$1 = state_69818;
var statearr_69832_69852 = state_69818__$1;
(statearr_69832_69852[(2)] = inst_69790);

(statearr_69832_69852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (5))){
var _ = (function (){var statearr_69833 = state_69818;
(statearr_69833[(4)] = cljs.core.rest((state_69818[(4)])));

return statearr_69833;
})();
var state_69818__$1 = state_69818;
var ex69830 = (state_69818__$1[(2)]);
var statearr_69834_69853 = state_69818__$1;
(statearr_69834_69853[(5)] = ex69830);


if((ex69830 instanceof Error)){
var statearr_69835_69854 = state_69818__$1;
(statearr_69835_69854[(1)] = (4));

(statearr_69835_69854[(5)] = null);

} else {
throw ex69830;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69819 === (10))){
var state_69818__$1 = state_69818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69818__$1,(13),path);
} else {
if((state_val_69819 === (8))){
var inst_69793 = (state_69818[(2)]);
var inst_69794 = fluree.db.util.async.channel_QMARK_(path);
var state_69818__$1 = (function (){var statearr_69836 = state_69818;
(statearr_69836[(7)] = inst_69793);

return statearr_69836;
})();
if(inst_69794){
var statearr_69837_69855 = state_69818__$1;
(statearr_69837_69855[(1)] = (10));

} else {
var statearr_69838_69856 = state_69818__$1;
(statearr_69838_69856[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_69839 = [null,null,null,null,null,null,null,null,null];
(statearr_69839[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_69839[(1)] = (1));

return statearr_69839;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_69818){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69818);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69840){var ex__2730__auto__ = e69840;
var statearr_69841_69857 = state_69818;
(statearr_69841_69857[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69818[(4)]))){
var statearr_69842_69858 = state_69818;
(statearr_69842_69858[(1)] = cljs.core.first((state_69818[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69859 = state_69818;
state_69818 = G__69859;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_69818){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_69818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69843 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69843[(6)] = c__2749__auto__);

return statearr_69843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__69860,key_or_ks){
var map__69861 = p__69860;
var map__69861__$1 = cljs.core.__destructure_map(map__69861);
var _QMARK_ctx = map__69861__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69861__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69906){
var state_val_69907 = (state_69906[(1)]);
if((state_val_69907 === (7))){
var state_69906__$1 = state_69906;
var statearr_69908_69937 = state_69906__$1;
(statearr_69908_69937[(2)] = coll);

(statearr_69908_69937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (1))){
var state_69906__$1 = state_69906;
var statearr_69909_69938 = state_69906__$1;
(statearr_69909_69938[(2)] = null);

(statearr_69909_69938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (4))){
var inst_69862 = (state_69906[(2)]);
var state_69906__$1 = state_69906;
var statearr_69910_69939 = state_69906__$1;
(statearr_69910_69939[(2)] = inst_69862);

(statearr_69910_69939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (15))){
var inst_69882 = (state_69906[(7)]);
var inst_69890 = (state_69906[(2)]);
var inst_69891 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_69882,inst_69890);
var inst_69892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69893 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69895 = [inst_69882,inst_69890];
var inst_69896 = (new cljs.core.PersistentVector(null,2,(5),inst_69894,inst_69895,null));
var inst_69897 = ["contains?",inst_69896,inst_69891];
var inst_69898 = cljs.core.PersistentHashMap.fromArrays(inst_69893,inst_69897);
var inst_69899 = [inst_69898,(10)];
var inst_69900 = (new cljs.core.PersistentVector(null,2,(5),inst_69892,inst_69899,null));
var inst_69901 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69900);
var _ = (function (){var statearr_69911 = state_69906;
(statearr_69911[(4)] = cljs.core.rest((state_69906[(4)])));

return statearr_69911;
})();
var state_69906__$1 = (function (){var statearr_69912 = state_69906;
(statearr_69912[(8)] = inst_69901);

return statearr_69912;
})();
var statearr_69913_69940 = state_69906__$1;
(statearr_69913_69940[(2)] = inst_69891);

(statearr_69913_69940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (13))){
var state_69906__$1 = state_69906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69906__$1,(16),key);
} else {
if((state_val_69907 === (6))){
var state_69906__$1 = state_69906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69906__$1,(9),coll);
} else {
if((state_val_69907 === (3))){
var inst_69904 = (state_69906[(2)]);
var state_69906__$1 = state_69906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69906__$1,inst_69904);
} else {
if((state_val_69907 === (12))){
var inst_69882 = (state_69906[(2)]);
var inst_69883 = fluree.db.util.async.channel_QMARK_(key);
var state_69906__$1 = (function (){var statearr_69914 = state_69906;
(statearr_69914[(7)] = inst_69882);

return statearr_69914;
})();
if(inst_69883){
var statearr_69915_69941 = state_69906__$1;
(statearr_69915_69941[(1)] = (13));

} else {
var statearr_69916_69942 = state_69906__$1;
(statearr_69916_69942[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (2))){
var _ = (function (){var statearr_69917 = state_69906;
(statearr_69917[(4)] = cljs.core.cons((5),(state_69906[(4)])));

return statearr_69917;
})();
var inst_69868 = fluree.db.util.async.channel_QMARK_(coll);
var state_69906__$1 = state_69906;
if(inst_69868){
var statearr_69918_69943 = state_69906__$1;
(statearr_69918_69943[(1)] = (6));

} else {
var statearr_69919_69944 = state_69906__$1;
(statearr_69919_69944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (11))){
var inst_69875 = (state_69906[(9)]);
var inst_69879 = cljs.core.flatten(inst_69875);
var inst_69880 = cljs.core.set(inst_69879);
var state_69906__$1 = state_69906;
var statearr_69921_69945 = state_69906__$1;
(statearr_69921_69945[(2)] = inst_69880);

(statearr_69921_69945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (9))){
var inst_69871 = (state_69906[(2)]);
var inst_69872 = fluree.db.util.async.throw_err(inst_69871);
var state_69906__$1 = state_69906;
var statearr_69922_69946 = state_69906__$1;
(statearr_69922_69946[(2)] = inst_69872);

(statearr_69922_69946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (5))){
var _ = (function (){var statearr_69923 = state_69906;
(statearr_69923[(4)] = cljs.core.rest((state_69906[(4)])));

return statearr_69923;
})();
var state_69906__$1 = state_69906;
var ex69920 = (state_69906__$1[(2)]);
var statearr_69924_69947 = state_69906__$1;
(statearr_69924_69947[(5)] = ex69920);


if((ex69920 instanceof Error)){
var statearr_69925_69948 = state_69906__$1;
(statearr_69925_69948[(1)] = (4));

(statearr_69925_69948[(5)] = null);

} else {
throw ex69920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (14))){
var state_69906__$1 = state_69906;
var statearr_69926_69949 = state_69906__$1;
(statearr_69926_69949[(2)] = key);

(statearr_69926_69949[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (16))){
var inst_69886 = (state_69906[(2)]);
var inst_69887 = fluree.db.util.async.throw_err(inst_69886);
var state_69906__$1 = state_69906;
var statearr_69927_69950 = state_69906__$1;
(statearr_69927_69950[(2)] = inst_69887);

(statearr_69927_69950[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (10))){
var inst_69875 = (state_69906[(9)]);
var state_69906__$1 = state_69906;
var statearr_69928_69951 = state_69906__$1;
(statearr_69928_69951[(2)] = inst_69875);

(statearr_69928_69951[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69907 === (8))){
var inst_69875 = (state_69906[(9)]);
var inst_69875__$1 = (state_69906[(2)]);
var inst_69876 = cljs.core.set_QMARK_(inst_69875__$1);
var state_69906__$1 = (function (){var statearr_69929 = state_69906;
(statearr_69929[(9)] = inst_69875__$1);

return statearr_69929;
})();
if(inst_69876){
var statearr_69930_69952 = state_69906__$1;
(statearr_69930_69952[(1)] = (10));

} else {
var statearr_69931_69953 = state_69906__$1;
(statearr_69931_69953[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_69932 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69932[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_69932[(1)] = (1));

return statearr_69932;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_69906){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69906);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69933){var ex__2730__auto__ = e69933;
var statearr_69934_69954 = state_69906;
(statearr_69934_69954[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69906[(4)]))){
var statearr_69935_69955 = state_69906;
(statearr_69935_69955[(1)] = cljs.core.first((state_69906[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69956 = state_69906;
state_69906 = G__69956;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_69906){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_69906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69936 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69936[(6)] = c__2749__auto__);

return statearr_69936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70028 = arguments.length;
var i__5770__auto___70029 = (0);
while(true){
if((i__5770__auto___70029 < len__5769__auto___70028)){
args__5775__auto__.push((arguments[i__5770__auto___70029]));

var G__70030 = (i__5770__auto___70029 + (1));
i__5770__auto___70029 = G__70030;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70002){
var state_val_70003 = (state_70002[(1)]);
if((state_val_70003 === (7))){
var inst_69968 = (state_70002[(7)]);
var inst_69972 = cljs.core.first(inst_69968);
var inst_69973 = cljs.core.coll_QMARK_(inst_69972);
var state_70002__$1 = state_70002;
var statearr_70004_70031 = state_70002__$1;
(statearr_70004_70031[(2)] = inst_69973);

(statearr_70004_70031[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (1))){
var state_70002__$1 = state_70002;
var statearr_70005_70032 = state_70002__$1;
(statearr_70005_70032[(2)] = null);

(statearr_70005_70032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (4))){
var inst_69959 = (state_70002[(2)]);
var state_70002__$1 = state_70002;
var statearr_70006_70033 = state_70002__$1;
(statearr_70006_70033[(2)] = inst_69959);

(statearr_70006_70033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (6))){
var inst_69970 = (state_70002[(8)]);
var inst_69968 = (state_70002[(7)]);
var inst_69967 = (state_70002[(2)]);
var inst_69968__$1 = fluree.db.util.async.throw_err(inst_69967);
var inst_69969 = cljs.core.count(inst_69968__$1);
var inst_69970__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_69969);
var state_70002__$1 = (function (){var statearr_70007 = state_70002;
(statearr_70007[(8)] = inst_69970__$1);

(statearr_70007[(7)] = inst_69968__$1);

return statearr_70007;
})();
if(inst_69970__$1){
var statearr_70008_70034 = state_70002__$1;
(statearr_70008_70034[(1)] = (7));

} else {
var statearr_70009_70035 = state_70002__$1;
(statearr_70009_70035[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (3))){
var inst_70000 = (state_70002[(2)]);
var state_70002__$1 = state_70002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70002__$1,inst_70000);
} else {
if((state_val_70003 === (12))){
var inst_69981 = (state_70002[(2)]);
var inst_69982 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_69981);
var inst_69983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69984 = [inst_69981];
var inst_69985 = (new cljs.core.PersistentVector(null,1,(5),inst_69983,inst_69984,null));
var inst_69986 = cljs.core.count(inst_69985);
var inst_69987 = ((9) + inst_69986);
var inst_69988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69989 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69991 = [inst_69981];
var inst_69992 = (new cljs.core.PersistentVector(null,1,(5),inst_69990,inst_69991,null));
var inst_69993 = ["hash-set",inst_69992,inst_69982];
var inst_69994 = cljs.core.PersistentHashMap.fromArrays(inst_69989,inst_69993);
var inst_69995 = [inst_69994,inst_69987];
var inst_69996 = (new cljs.core.PersistentVector(null,2,(5),inst_69988,inst_69995,null));
var inst_69997 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69996);
var _ = (function (){var statearr_70010 = state_70002;
(statearr_70010[(4)] = cljs.core.rest((state_70002[(4)])));

return statearr_70010;
})();
var state_70002__$1 = (function (){var statearr_70011 = state_70002;
(statearr_70011[(9)] = inst_69997);

return statearr_70011;
})();
var statearr_70012_70036 = state_70002__$1;
(statearr_70012_70036[(2)] = inst_69982);

(statearr_70012_70036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (2))){
var _ = (function (){var statearr_70013 = state_70002;
(statearr_70013[(4)] = cljs.core.cons((5),(state_70002[(4)])));

return statearr_70013;
})();
var inst_69965 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70002__$1 = state_70002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70002__$1,(6),inst_69965);
} else {
if((state_val_70003 === (11))){
var inst_69968 = (state_70002[(7)]);
var state_70002__$1 = state_70002;
var statearr_70015_70037 = state_70002__$1;
(statearr_70015_70037[(2)] = inst_69968);

(statearr_70015_70037[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (9))){
var inst_69976 = (state_70002[(2)]);
var state_70002__$1 = state_70002;
if(cljs.core.truth_(inst_69976)){
var statearr_70016_70038 = state_70002__$1;
(statearr_70016_70038[(1)] = (10));

} else {
var statearr_70017_70039 = state_70002__$1;
(statearr_70017_70039[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (5))){
var _ = (function (){var statearr_70018 = state_70002;
(statearr_70018[(4)] = cljs.core.rest((state_70002[(4)])));

return statearr_70018;
})();
var state_70002__$1 = state_70002;
var ex70014 = (state_70002__$1[(2)]);
var statearr_70019_70040 = state_70002__$1;
(statearr_70019_70040[(5)] = ex70014);


if((ex70014 instanceof Error)){
var statearr_70020_70041 = state_70002__$1;
(statearr_70020_70041[(1)] = (4));

(statearr_70020_70041[(5)] = null);

} else {
throw ex70014;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (10))){
var inst_69968 = (state_70002[(7)]);
var inst_69978 = cljs.core.first(inst_69968);
var state_70002__$1 = state_70002;
var statearr_70021_70042 = state_70002__$1;
(statearr_70021_70042[(2)] = inst_69978);

(statearr_70021_70042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70003 === (8))){
var inst_69970 = (state_70002[(8)]);
var state_70002__$1 = state_70002;
var statearr_70022_70043 = state_70002__$1;
(statearr_70022_70043[(2)] = inst_69970);

(statearr_70022_70043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70023 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70023[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70023[(1)] = (1));

return statearr_70023;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70002){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70002);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70024){var ex__2730__auto__ = e70024;
var statearr_70025_70044 = state_70002;
(statearr_70025_70044[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70002[(4)]))){
var statearr_70026_70045 = state_70002;
(statearr_70026_70045[(1)] = cljs.core.first((state_70002[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70046 = state_70002;
state_70002 = G__70046;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70002){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70027 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70027[(6)] = c__2749__auto__);

return statearr_70027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq69957){
var G__69958 = cljs.core.first(seq69957);
var seq69957__$1 = cljs.core.next(seq69957);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69958,seq69957__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70096 = arguments.length;
var i__5770__auto___70097 = (0);
while(true){
if((i__5770__auto___70097 < len__5769__auto___70096)){
args__5775__auto__.push((arguments[i__5770__auto___70097]));

var G__70098 = (i__5770__auto___70097 + (1));
i__5770__auto___70097 = G__70098;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70079){
var state_val_70080 = (state_70079[(1)]);
if((state_val_70080 === (1))){
var state_70079__$1 = state_70079;
var statearr_70081_70099 = state_70079__$1;
(statearr_70081_70099[(2)] = null);

(statearr_70081_70099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (2))){
var _ = (function (){var statearr_70082 = state_70079;
(statearr_70082[(4)] = cljs.core.cons((5),(state_70079[(4)])));

return statearr_70082;
})();
var inst_70055 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70079__$1,(6),inst_70055);
} else {
if((state_val_70080 === (3))){
var inst_70077 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70079__$1,inst_70077);
} else {
if((state_val_70080 === (4))){
var inst_70049 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70084_70100 = state_70079__$1;
(statearr_70084_70100[(2)] = inst_70049);

(statearr_70084_70100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (5))){
var _ = (function (){var statearr_70085 = state_70079;
(statearr_70085[(4)] = cljs.core.rest((state_70079[(4)])));

return statearr_70085;
})();
var state_70079__$1 = state_70079;
var ex70083 = (state_70079__$1[(2)]);
var statearr_70086_70101 = state_70079__$1;
(statearr_70086_70101[(5)] = ex70083);


if((ex70083 instanceof Error)){
var statearr_70087_70102 = state_70079__$1;
(statearr_70087_70102[(1)] = (4));

(statearr_70087_70102[(5)] = null);

} else {
throw ex70083;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (6))){
var inst_70057 = (state_70079[(2)]);
var inst_70058 = fluree.db.util.async.throw_err(inst_70057);
var inst_70059 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_70058);
var inst_70060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70061 = [inst_70058];
var inst_70062 = (new cljs.core.PersistentVector(null,1,(5),inst_70060,inst_70061,null));
var inst_70063 = cljs.core.count(inst_70062);
var inst_70064 = ((9) + inst_70063);
var inst_70065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70066 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70068 = [inst_70058];
var inst_70069 = (new cljs.core.PersistentVector(null,1,(5),inst_70067,inst_70068,null));
var inst_70070 = ["==",inst_70069,inst_70059];
var inst_70071 = cljs.core.PersistentHashMap.fromArrays(inst_70066,inst_70070);
var inst_70072 = [inst_70071,inst_70064];
var inst_70073 = (new cljs.core.PersistentVector(null,2,(5),inst_70065,inst_70072,null));
var inst_70074 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70073);
var _ = (function (){var statearr_70088 = state_70079;
(statearr_70088[(4)] = cljs.core.rest((state_70079[(4)])));

return statearr_70088;
})();
var state_70079__$1 = (function (){var statearr_70089 = state_70079;
(statearr_70089[(7)] = inst_70074);

return statearr_70089;
})();
var statearr_70090_70103 = state_70079__$1;
(statearr_70090_70103[(2)] = inst_70059);

(statearr_70090_70103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70091 = [null,null,null,null,null,null,null,null];
(statearr_70091[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70091[(1)] = (1));

return statearr_70091;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70079){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70079);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70092){var ex__2730__auto__ = e70092;
var statearr_70093_70104 = state_70079;
(statearr_70093_70104[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70079[(4)]))){
var statearr_70094_70105 = state_70079;
(statearr_70094_70105[(1)] = cljs.core.first((state_70079[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70106 = state_70079;
state_70079 = G__70106;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70079){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70095 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70095[(6)] = c__2749__auto__);

return statearr_70095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq70047){
var G__70048 = cljs.core.first(seq70047);
var seq70047__$1 = cljs.core.next(seq70047);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70048,seq70047__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70156 = arguments.length;
var i__5770__auto___70157 = (0);
while(true){
if((i__5770__auto___70157 < len__5769__auto___70156)){
args__5775__auto__.push((arguments[i__5770__auto___70157]));

var G__70158 = (i__5770__auto___70157 + (1));
i__5770__auto___70157 = G__70158;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70139){
var state_val_70140 = (state_70139[(1)]);
if((state_val_70140 === (1))){
var state_70139__$1 = state_70139;
var statearr_70141_70159 = state_70139__$1;
(statearr_70141_70159[(2)] = null);

(statearr_70141_70159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70140 === (2))){
var _ = (function (){var statearr_70142 = state_70139;
(statearr_70142[(4)] = cljs.core.cons((5),(state_70139[(4)])));

return statearr_70142;
})();
var inst_70115 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70139__$1 = state_70139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70139__$1,(6),inst_70115);
} else {
if((state_val_70140 === (3))){
var inst_70137 = (state_70139[(2)]);
var state_70139__$1 = state_70139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70139__$1,inst_70137);
} else {
if((state_val_70140 === (4))){
var inst_70109 = (state_70139[(2)]);
var state_70139__$1 = state_70139;
var statearr_70144_70160 = state_70139__$1;
(statearr_70144_70160[(2)] = inst_70109);

(statearr_70144_70160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70140 === (5))){
var _ = (function (){var statearr_70145 = state_70139;
(statearr_70145[(4)] = cljs.core.rest((state_70139[(4)])));

return statearr_70145;
})();
var state_70139__$1 = state_70139;
var ex70143 = (state_70139__$1[(2)]);
var statearr_70146_70161 = state_70139__$1;
(statearr_70146_70161[(5)] = ex70143);


if((ex70143 instanceof Error)){
var statearr_70147_70162 = state_70139__$1;
(statearr_70147_70162[(1)] = (4));

(statearr_70147_70162[(5)] = null);

} else {
throw ex70143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70140 === (6))){
var inst_70117 = (state_70139[(2)]);
var inst_70118 = fluree.db.util.async.throw_err(inst_70117);
var inst_70119 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_70118);
var inst_70120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70121 = [inst_70118];
var inst_70122 = (new cljs.core.PersistentVector(null,1,(5),inst_70120,inst_70121,null));
var inst_70123 = cljs.core.count(inst_70122);
var inst_70124 = ((9) + inst_70123);
var inst_70125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70126 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70128 = [inst_70118];
var inst_70129 = (new cljs.core.PersistentVector(null,1,(5),inst_70127,inst_70128,null));
var inst_70130 = [">",inst_70129,inst_70119];
var inst_70131 = cljs.core.PersistentHashMap.fromArrays(inst_70126,inst_70130);
var inst_70132 = [inst_70131,inst_70124];
var inst_70133 = (new cljs.core.PersistentVector(null,2,(5),inst_70125,inst_70132,null));
var inst_70134 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70133);
var _ = (function (){var statearr_70148 = state_70139;
(statearr_70148[(4)] = cljs.core.rest((state_70139[(4)])));

return statearr_70148;
})();
var state_70139__$1 = (function (){var statearr_70149 = state_70139;
(statearr_70149[(7)] = inst_70134);

return statearr_70149;
})();
var statearr_70150_70163 = state_70139__$1;
(statearr_70150_70163[(2)] = inst_70119);

(statearr_70150_70163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70151 = [null,null,null,null,null,null,null,null];
(statearr_70151[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70151[(1)] = (1));

return statearr_70151;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70139){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70139);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70152){var ex__2730__auto__ = e70152;
var statearr_70153_70164 = state_70139;
(statearr_70153_70164[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70139[(4)]))){
var statearr_70154_70165 = state_70139;
(statearr_70154_70165[(1)] = cljs.core.first((state_70139[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70166 = state_70139;
state_70139 = G__70166;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70139){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70155 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70155[(6)] = c__2749__auto__);

return statearr_70155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq70107){
var G__70108 = cljs.core.first(seq70107);
var seq70107__$1 = cljs.core.next(seq70107);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70108,seq70107__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70216 = arguments.length;
var i__5770__auto___70217 = (0);
while(true){
if((i__5770__auto___70217 < len__5769__auto___70216)){
args__5775__auto__.push((arguments[i__5770__auto___70217]));

var G__70218 = (i__5770__auto___70217 + (1));
i__5770__auto___70217 = G__70218;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70199){
var state_val_70200 = (state_70199[(1)]);
if((state_val_70200 === (1))){
var state_70199__$1 = state_70199;
var statearr_70201_70219 = state_70199__$1;
(statearr_70201_70219[(2)] = null);

(statearr_70201_70219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70200 === (2))){
var _ = (function (){var statearr_70202 = state_70199;
(statearr_70202[(4)] = cljs.core.cons((5),(state_70199[(4)])));

return statearr_70202;
})();
var inst_70175 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70199__$1 = state_70199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70199__$1,(6),inst_70175);
} else {
if((state_val_70200 === (3))){
var inst_70197 = (state_70199[(2)]);
var state_70199__$1 = state_70199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70199__$1,inst_70197);
} else {
if((state_val_70200 === (4))){
var inst_70169 = (state_70199[(2)]);
var state_70199__$1 = state_70199;
var statearr_70204_70220 = state_70199__$1;
(statearr_70204_70220[(2)] = inst_70169);

(statearr_70204_70220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70200 === (5))){
var _ = (function (){var statearr_70205 = state_70199;
(statearr_70205[(4)] = cljs.core.rest((state_70199[(4)])));

return statearr_70205;
})();
var state_70199__$1 = state_70199;
var ex70203 = (state_70199__$1[(2)]);
var statearr_70206_70221 = state_70199__$1;
(statearr_70206_70221[(5)] = ex70203);


if((ex70203 instanceof Error)){
var statearr_70207_70222 = state_70199__$1;
(statearr_70207_70222[(1)] = (4));

(statearr_70207_70222[(5)] = null);

} else {
throw ex70203;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70200 === (6))){
var inst_70177 = (state_70199[(2)]);
var inst_70178 = fluree.db.util.async.throw_err(inst_70177);
var inst_70179 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_70178);
var inst_70180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70181 = [inst_70178];
var inst_70182 = (new cljs.core.PersistentVector(null,1,(5),inst_70180,inst_70181,null));
var inst_70183 = cljs.core.count(inst_70182);
var inst_70184 = ((9) + inst_70183);
var inst_70185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70186 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70188 = [inst_70178];
var inst_70189 = (new cljs.core.PersistentVector(null,1,(5),inst_70187,inst_70188,null));
var inst_70190 = ["<",inst_70189,inst_70179];
var inst_70191 = cljs.core.PersistentHashMap.fromArrays(inst_70186,inst_70190);
var inst_70192 = [inst_70191,inst_70184];
var inst_70193 = (new cljs.core.PersistentVector(null,2,(5),inst_70185,inst_70192,null));
var inst_70194 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70193);
var _ = (function (){var statearr_70208 = state_70199;
(statearr_70208[(4)] = cljs.core.rest((state_70199[(4)])));

return statearr_70208;
})();
var state_70199__$1 = (function (){var statearr_70209 = state_70199;
(statearr_70209[(7)] = inst_70194);

return statearr_70209;
})();
var statearr_70210_70223 = state_70199__$1;
(statearr_70210_70223[(2)] = inst_70179);

(statearr_70210_70223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70211 = [null,null,null,null,null,null,null,null];
(statearr_70211[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70211[(1)] = (1));

return statearr_70211;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70199){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70199);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70212){var ex__2730__auto__ = e70212;
var statearr_70213_70224 = state_70199;
(statearr_70213_70224[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70199[(4)]))){
var statearr_70214_70225 = state_70199;
(statearr_70214_70225[(1)] = cljs.core.first((state_70199[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70226 = state_70199;
state_70199 = G__70226;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70215 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70215[(6)] = c__2749__auto__);

return statearr_70215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq70167){
var G__70168 = cljs.core.first(seq70167);
var seq70167__$1 = cljs.core.next(seq70167);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70168,seq70167__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70276 = arguments.length;
var i__5770__auto___70277 = (0);
while(true){
if((i__5770__auto___70277 < len__5769__auto___70276)){
args__5775__auto__.push((arguments[i__5770__auto___70277]));

var G__70278 = (i__5770__auto___70277 + (1));
i__5770__auto___70277 = G__70278;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70259){
var state_val_70260 = (state_70259[(1)]);
if((state_val_70260 === (1))){
var state_70259__$1 = state_70259;
var statearr_70261_70279 = state_70259__$1;
(statearr_70261_70279[(2)] = null);

(statearr_70261_70279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70260 === (2))){
var _ = (function (){var statearr_70262 = state_70259;
(statearr_70262[(4)] = cljs.core.cons((5),(state_70259[(4)])));

return statearr_70262;
})();
var inst_70235 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70259__$1 = state_70259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70259__$1,(6),inst_70235);
} else {
if((state_val_70260 === (3))){
var inst_70257 = (state_70259[(2)]);
var state_70259__$1 = state_70259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70259__$1,inst_70257);
} else {
if((state_val_70260 === (4))){
var inst_70229 = (state_70259[(2)]);
var state_70259__$1 = state_70259;
var statearr_70264_70280 = state_70259__$1;
(statearr_70264_70280[(2)] = inst_70229);

(statearr_70264_70280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70260 === (5))){
var _ = (function (){var statearr_70265 = state_70259;
(statearr_70265[(4)] = cljs.core.rest((state_70259[(4)])));

return statearr_70265;
})();
var state_70259__$1 = state_70259;
var ex70263 = (state_70259__$1[(2)]);
var statearr_70266_70281 = state_70259__$1;
(statearr_70266_70281[(5)] = ex70263);


if((ex70263 instanceof Error)){
var statearr_70267_70282 = state_70259__$1;
(statearr_70267_70282[(1)] = (4));

(statearr_70267_70282[(5)] = null);

} else {
throw ex70263;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70260 === (6))){
var inst_70237 = (state_70259[(2)]);
var inst_70238 = fluree.db.util.async.throw_err(inst_70237);
var inst_70239 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_70238);
var inst_70240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70241 = [inst_70238];
var inst_70242 = (new cljs.core.PersistentVector(null,1,(5),inst_70240,inst_70241,null));
var inst_70243 = cljs.core.count(inst_70242);
var inst_70244 = ((9) + inst_70243);
var inst_70245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70246 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70248 = [inst_70238];
var inst_70249 = (new cljs.core.PersistentVector(null,1,(5),inst_70247,inst_70248,null));
var inst_70250 = ["<=",inst_70249,inst_70239];
var inst_70251 = cljs.core.PersistentHashMap.fromArrays(inst_70246,inst_70250);
var inst_70252 = [inst_70251,inst_70244];
var inst_70253 = (new cljs.core.PersistentVector(null,2,(5),inst_70245,inst_70252,null));
var inst_70254 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70253);
var _ = (function (){var statearr_70268 = state_70259;
(statearr_70268[(4)] = cljs.core.rest((state_70259[(4)])));

return statearr_70268;
})();
var state_70259__$1 = (function (){var statearr_70269 = state_70259;
(statearr_70269[(7)] = inst_70254);

return statearr_70269;
})();
var statearr_70270_70283 = state_70259__$1;
(statearr_70270_70283[(2)] = inst_70239);

(statearr_70270_70283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70271 = [null,null,null,null,null,null,null,null];
(statearr_70271[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70271[(1)] = (1));

return statearr_70271;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70259){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70259);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70272){var ex__2730__auto__ = e70272;
var statearr_70273_70284 = state_70259;
(statearr_70273_70284[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70259[(4)]))){
var statearr_70274_70285 = state_70259;
(statearr_70274_70285[(1)] = cljs.core.first((state_70259[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70286 = state_70259;
state_70259 = G__70286;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70259){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70275 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70275[(6)] = c__2749__auto__);

return statearr_70275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq70227){
var G__70228 = cljs.core.first(seq70227);
var seq70227__$1 = cljs.core.next(seq70227);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70228,seq70227__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70336 = arguments.length;
var i__5770__auto___70337 = (0);
while(true){
if((i__5770__auto___70337 < len__5769__auto___70336)){
args__5775__auto__.push((arguments[i__5770__auto___70337]));

var G__70338 = (i__5770__auto___70337 + (1));
i__5770__auto___70337 = G__70338;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70319){
var state_val_70320 = (state_70319[(1)]);
if((state_val_70320 === (1))){
var state_70319__$1 = state_70319;
var statearr_70321_70339 = state_70319__$1;
(statearr_70321_70339[(2)] = null);

(statearr_70321_70339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70320 === (2))){
var _ = (function (){var statearr_70322 = state_70319;
(statearr_70322[(4)] = cljs.core.cons((5),(state_70319[(4)])));

return statearr_70322;
})();
var inst_70295 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70319__$1 = state_70319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70319__$1,(6),inst_70295);
} else {
if((state_val_70320 === (3))){
var inst_70317 = (state_70319[(2)]);
var state_70319__$1 = state_70319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70319__$1,inst_70317);
} else {
if((state_val_70320 === (4))){
var inst_70289 = (state_70319[(2)]);
var state_70319__$1 = state_70319;
var statearr_70324_70340 = state_70319__$1;
(statearr_70324_70340[(2)] = inst_70289);

(statearr_70324_70340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70320 === (5))){
var _ = (function (){var statearr_70325 = state_70319;
(statearr_70325[(4)] = cljs.core.rest((state_70319[(4)])));

return statearr_70325;
})();
var state_70319__$1 = state_70319;
var ex70323 = (state_70319__$1[(2)]);
var statearr_70326_70341 = state_70319__$1;
(statearr_70326_70341[(5)] = ex70323);


if((ex70323 instanceof Error)){
var statearr_70327_70342 = state_70319__$1;
(statearr_70327_70342[(1)] = (4));

(statearr_70327_70342[(5)] = null);

} else {
throw ex70323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70320 === (6))){
var inst_70297 = (state_70319[(2)]);
var inst_70298 = fluree.db.util.async.throw_err(inst_70297);
var inst_70299 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_70298);
var inst_70300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70301 = [inst_70298];
var inst_70302 = (new cljs.core.PersistentVector(null,1,(5),inst_70300,inst_70301,null));
var inst_70303 = cljs.core.count(inst_70302);
var inst_70304 = ((9) + inst_70303);
var inst_70305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70306 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70308 = [inst_70298];
var inst_70309 = (new cljs.core.PersistentVector(null,1,(5),inst_70307,inst_70308,null));
var inst_70310 = [">=",inst_70309,inst_70299];
var inst_70311 = cljs.core.PersistentHashMap.fromArrays(inst_70306,inst_70310);
var inst_70312 = [inst_70311,inst_70304];
var inst_70313 = (new cljs.core.PersistentVector(null,2,(5),inst_70305,inst_70312,null));
var inst_70314 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70313);
var _ = (function (){var statearr_70328 = state_70319;
(statearr_70328[(4)] = cljs.core.rest((state_70319[(4)])));

return statearr_70328;
})();
var state_70319__$1 = (function (){var statearr_70329 = state_70319;
(statearr_70329[(7)] = inst_70314);

return statearr_70329;
})();
var statearr_70330_70343 = state_70319__$1;
(statearr_70330_70343[(2)] = inst_70299);

(statearr_70330_70343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70331 = [null,null,null,null,null,null,null,null];
(statearr_70331[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70331[(1)] = (1));

return statearr_70331;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70319){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70319);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70332){var ex__2730__auto__ = e70332;
var statearr_70333_70344 = state_70319;
(statearr_70333_70344[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70319[(4)]))){
var statearr_70334_70345 = state_70319;
(statearr_70334_70345[(1)] = cljs.core.first((state_70319[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70346 = state_70319;
state_70319 = G__70346;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70319){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70335 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70335[(6)] = c__2749__auto__);

return statearr_70335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq70287){
var G__70288 = cljs.core.first(seq70287);
var seq70287__$1 = cljs.core.next(seq70287);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70288,seq70287__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70396 = arguments.length;
var i__5770__auto___70397 = (0);
while(true){
if((i__5770__auto___70397 < len__5769__auto___70396)){
args__5775__auto__.push((arguments[i__5770__auto___70397]));

var G__70398 = (i__5770__auto___70397 + (1));
i__5770__auto___70397 = G__70398;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70379){
var state_val_70380 = (state_70379[(1)]);
if((state_val_70380 === (1))){
var state_70379__$1 = state_70379;
var statearr_70381_70399 = state_70379__$1;
(statearr_70381_70399[(2)] = null);

(statearr_70381_70399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70380 === (2))){
var _ = (function (){var statearr_70382 = state_70379;
(statearr_70382[(4)] = cljs.core.cons((5),(state_70379[(4)])));

return statearr_70382;
})();
var inst_70355 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70379__$1 = state_70379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70379__$1,(6),inst_70355);
} else {
if((state_val_70380 === (3))){
var inst_70377 = (state_70379[(2)]);
var state_70379__$1 = state_70379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70379__$1,inst_70377);
} else {
if((state_val_70380 === (4))){
var inst_70349 = (state_70379[(2)]);
var state_70379__$1 = state_70379;
var statearr_70384_70400 = state_70379__$1;
(statearr_70384_70400[(2)] = inst_70349);

(statearr_70384_70400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70380 === (5))){
var _ = (function (){var statearr_70385 = state_70379;
(statearr_70385[(4)] = cljs.core.rest((state_70379[(4)])));

return statearr_70385;
})();
var state_70379__$1 = state_70379;
var ex70383 = (state_70379__$1[(2)]);
var statearr_70386_70401 = state_70379__$1;
(statearr_70386_70401[(5)] = ex70383);


if((ex70383 instanceof Error)){
var statearr_70387_70402 = state_70379__$1;
(statearr_70387_70402[(1)] = (4));

(statearr_70387_70402[(5)] = null);

} else {
throw ex70383;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70380 === (6))){
var inst_70357 = (state_70379[(2)]);
var inst_70358 = fluree.db.util.async.throw_err(inst_70357);
var inst_70359 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_70358);
var inst_70360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70361 = [inst_70358];
var inst_70362 = (new cljs.core.PersistentVector(null,1,(5),inst_70360,inst_70361,null));
var inst_70363 = cljs.core.count(inst_70362);
var inst_70364 = ((9) + inst_70363);
var inst_70365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70366 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70368 = [inst_70358];
var inst_70369 = (new cljs.core.PersistentVector(null,1,(5),inst_70367,inst_70368,null));
var inst_70370 = ["not=",inst_70369,inst_70359];
var inst_70371 = cljs.core.PersistentHashMap.fromArrays(inst_70366,inst_70370);
var inst_70372 = [inst_70371,inst_70364];
var inst_70373 = (new cljs.core.PersistentVector(null,2,(5),inst_70365,inst_70372,null));
var inst_70374 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70373);
var _ = (function (){var statearr_70388 = state_70379;
(statearr_70388[(4)] = cljs.core.rest((state_70379[(4)])));

return statearr_70388;
})();
var state_70379__$1 = (function (){var statearr_70389 = state_70379;
(statearr_70389[(7)] = inst_70374);

return statearr_70389;
})();
var statearr_70390_70403 = state_70379__$1;
(statearr_70390_70403[(2)] = inst_70359);

(statearr_70390_70403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70391 = [null,null,null,null,null,null,null,null];
(statearr_70391[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70391[(1)] = (1));

return statearr_70391;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70379){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70379);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70392){var ex__2730__auto__ = e70392;
var statearr_70393_70404 = state_70379;
(statearr_70393_70404[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70379[(4)]))){
var statearr_70394_70405 = state_70379;
(statearr_70394_70405[(1)] = cljs.core.first((state_70379[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70406 = state_70379;
state_70379 = G__70406;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70379){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70395 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70395[(6)] = c__2749__auto__);

return statearr_70395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq70347){
var G__70348 = cljs.core.first(seq70347);
var seq70347__$1 = cljs.core.next(seq70347);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70348,seq70347__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70456 = arguments.length;
var i__5770__auto___70457 = (0);
while(true){
if((i__5770__auto___70457 < len__5769__auto___70456)){
args__5775__auto__.push((arguments[i__5770__auto___70457]));

var G__70458 = (i__5770__auto___70457 + (1));
i__5770__auto___70457 = G__70458;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70439){
var state_val_70440 = (state_70439[(1)]);
if((state_val_70440 === (1))){
var state_70439__$1 = state_70439;
var statearr_70441_70459 = state_70439__$1;
(statearr_70441_70459[(2)] = null);

(statearr_70441_70459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70440 === (2))){
var _ = (function (){var statearr_70442 = state_70439;
(statearr_70442[(4)] = cljs.core.cons((5),(state_70439[(4)])));

return statearr_70442;
})();
var inst_70415 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70439__$1 = state_70439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70439__$1,(6),inst_70415);
} else {
if((state_val_70440 === (3))){
var inst_70437 = (state_70439[(2)]);
var state_70439__$1 = state_70439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70439__$1,inst_70437);
} else {
if((state_val_70440 === (4))){
var inst_70409 = (state_70439[(2)]);
var state_70439__$1 = state_70439;
var statearr_70444_70460 = state_70439__$1;
(statearr_70444_70460[(2)] = inst_70409);

(statearr_70444_70460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70440 === (5))){
var _ = (function (){var statearr_70445 = state_70439;
(statearr_70445[(4)] = cljs.core.rest((state_70439[(4)])));

return statearr_70445;
})();
var state_70439__$1 = state_70439;
var ex70443 = (state_70439__$1[(2)]);
var statearr_70446_70461 = state_70439__$1;
(statearr_70446_70461[(5)] = ex70443);


if((ex70443 instanceof Error)){
var statearr_70447_70462 = state_70439__$1;
(statearr_70447_70462[(1)] = (4));

(statearr_70447_70462[(5)] = null);

} else {
throw ex70443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70440 === (6))){
var inst_70417 = (state_70439[(2)]);
var inst_70418 = fluree.db.util.async.throw_err(inst_70417);
var inst_70419 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_70418);
var inst_70420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70421 = [inst_70418];
var inst_70422 = (new cljs.core.PersistentVector(null,1,(5),inst_70420,inst_70421,null));
var inst_70423 = cljs.core.count(inst_70422);
var inst_70424 = ((9) + inst_70423);
var inst_70425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70426 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70428 = [inst_70418];
var inst_70429 = (new cljs.core.PersistentVector(null,1,(5),inst_70427,inst_70428,null));
var inst_70430 = ["max",inst_70429,inst_70419];
var inst_70431 = cljs.core.PersistentHashMap.fromArrays(inst_70426,inst_70430);
var inst_70432 = [inst_70431,inst_70424];
var inst_70433 = (new cljs.core.PersistentVector(null,2,(5),inst_70425,inst_70432,null));
var inst_70434 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70433);
var _ = (function (){var statearr_70448 = state_70439;
(statearr_70448[(4)] = cljs.core.rest((state_70439[(4)])));

return statearr_70448;
})();
var state_70439__$1 = (function (){var statearr_70449 = state_70439;
(statearr_70449[(7)] = inst_70434);

return statearr_70449;
})();
var statearr_70450_70463 = state_70439__$1;
(statearr_70450_70463[(2)] = inst_70419);

(statearr_70450_70463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70451 = [null,null,null,null,null,null,null,null];
(statearr_70451[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70451[(1)] = (1));

return statearr_70451;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70439){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70439);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70452){var ex__2730__auto__ = e70452;
var statearr_70453_70464 = state_70439;
(statearr_70453_70464[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70439[(4)]))){
var statearr_70454_70465 = state_70439;
(statearr_70454_70465[(1)] = cljs.core.first((state_70439[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70466 = state_70439;
state_70439 = G__70466;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70439){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70455 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70455[(6)] = c__2749__auto__);

return statearr_70455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq70407){
var G__70408 = cljs.core.first(seq70407);
var seq70407__$1 = cljs.core.next(seq70407);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70408,seq70407__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70516 = arguments.length;
var i__5770__auto___70517 = (0);
while(true){
if((i__5770__auto___70517 < len__5769__auto___70516)){
args__5775__auto__.push((arguments[i__5770__auto___70517]));

var G__70518 = (i__5770__auto___70517 + (1));
i__5770__auto___70517 = G__70518;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70499){
var state_val_70500 = (state_70499[(1)]);
if((state_val_70500 === (1))){
var state_70499__$1 = state_70499;
var statearr_70501_70519 = state_70499__$1;
(statearr_70501_70519[(2)] = null);

(statearr_70501_70519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70500 === (2))){
var _ = (function (){var statearr_70502 = state_70499;
(statearr_70502[(4)] = cljs.core.cons((5),(state_70499[(4)])));

return statearr_70502;
})();
var inst_70475 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70499__$1 = state_70499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70499__$1,(6),inst_70475);
} else {
if((state_val_70500 === (3))){
var inst_70497 = (state_70499[(2)]);
var state_70499__$1 = state_70499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70499__$1,inst_70497);
} else {
if((state_val_70500 === (4))){
var inst_70469 = (state_70499[(2)]);
var state_70499__$1 = state_70499;
var statearr_70504_70520 = state_70499__$1;
(statearr_70504_70520[(2)] = inst_70469);

(statearr_70504_70520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70500 === (5))){
var _ = (function (){var statearr_70505 = state_70499;
(statearr_70505[(4)] = cljs.core.rest((state_70499[(4)])));

return statearr_70505;
})();
var state_70499__$1 = state_70499;
var ex70503 = (state_70499__$1[(2)]);
var statearr_70506_70521 = state_70499__$1;
(statearr_70506_70521[(5)] = ex70503);


if((ex70503 instanceof Error)){
var statearr_70507_70522 = state_70499__$1;
(statearr_70507_70522[(1)] = (4));

(statearr_70507_70522[(5)] = null);

} else {
throw ex70503;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70500 === (6))){
var inst_70477 = (state_70499[(2)]);
var inst_70478 = fluree.db.util.async.throw_err(inst_70477);
var inst_70479 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_70478);
var inst_70480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70481 = [inst_70478];
var inst_70482 = (new cljs.core.PersistentVector(null,1,(5),inst_70480,inst_70481,null));
var inst_70483 = cljs.core.count(inst_70482);
var inst_70484 = ((9) + inst_70483);
var inst_70485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70486 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70488 = [inst_70478];
var inst_70489 = (new cljs.core.PersistentVector(null,1,(5),inst_70487,inst_70488,null));
var inst_70490 = ["min",inst_70489,inst_70479];
var inst_70491 = cljs.core.PersistentHashMap.fromArrays(inst_70486,inst_70490);
var inst_70492 = [inst_70491,inst_70484];
var inst_70493 = (new cljs.core.PersistentVector(null,2,(5),inst_70485,inst_70492,null));
var inst_70494 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70493);
var _ = (function (){var statearr_70508 = state_70499;
(statearr_70508[(4)] = cljs.core.rest((state_70499[(4)])));

return statearr_70508;
})();
var state_70499__$1 = (function (){var statearr_70509 = state_70499;
(statearr_70509[(7)] = inst_70494);

return statearr_70509;
})();
var statearr_70510_70523 = state_70499__$1;
(statearr_70510_70523[(2)] = inst_70479);

(statearr_70510_70523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70511 = [null,null,null,null,null,null,null,null];
(statearr_70511[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70511[(1)] = (1));

return statearr_70511;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70499){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70499);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70512){var ex__2730__auto__ = e70512;
var statearr_70513_70524 = state_70499;
(statearr_70513_70524[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70499[(4)]))){
var statearr_70514_70525 = state_70499;
(statearr_70514_70525[(1)] = cljs.core.first((state_70499[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70526 = state_70499;
state_70499 = G__70526;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70499){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70515 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70515[(6)] = c__2749__auto__);

return statearr_70515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq70467){
var G__70468 = cljs.core.first(seq70467);
var seq70467__$1 = cljs.core.next(seq70467);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70468,seq70467__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__70528 = arguments.length;
switch (G__70528) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70573){
var state_val_70574 = (state_70573[(1)]);
if((state_val_70574 === (7))){
var state_70573__$1 = state_70573;
var statearr_70575_70712 = state_70573__$1;
(statearr_70575_70712[(2)] = query_map);

(statearr_70575_70712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (1))){
var state_70573__$1 = state_70573;
var statearr_70576_70713 = state_70573__$1;
(statearr_70576_70713[(2)] = null);

(statearr_70576_70713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (4))){
var inst_70529 = (state_70573[(2)]);
var state_70573__$1 = state_70573;
var statearr_70577_70714 = state_70573__$1;
(statearr_70577_70714[(2)] = inst_70529);

(statearr_70577_70714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (13))){
var inst_70551 = (state_70573[(7)]);
var inst_70555 = (state_70573[(2)]);
var inst_70556 = fluree.db.util.async.throw_err(inst_70555);
var inst_70557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70556,(0),null);
var inst_70558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70556,(1),null);
var inst_70559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70560 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70562 = [inst_70551];
var inst_70563 = (new cljs.core.PersistentVector(null,1,(5),inst_70561,inst_70562,null));
var inst_70564 = ["query",inst_70563,inst_70557];
var inst_70565 = cljs.core.PersistentHashMap.fromArrays(inst_70560,inst_70564);
var inst_70566 = [inst_70565,inst_70558];
var inst_70567 = (new cljs.core.PersistentVector(null,2,(5),inst_70559,inst_70566,null));
var inst_70568 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70567);
var _ = (function (){var statearr_70578 = state_70573;
(statearr_70578[(4)] = cljs.core.rest((state_70573[(4)])));

return statearr_70578;
})();
var state_70573__$1 = (function (){var statearr_70579 = state_70573;
(statearr_70579[(8)] = inst_70568);

return statearr_70579;
})();
var statearr_70580_70715 = state_70573__$1;
(statearr_70580_70715[(2)] = inst_70557);

(statearr_70580_70715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (6))){
var state_70573__$1 = state_70573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70573__$1,(9),query_map);
} else {
if((state_val_70574 === (3))){
var inst_70571 = (state_70573[(2)]);
var state_70573__$1 = state_70573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70573__$1,inst_70571);
} else {
if((state_val_70574 === (12))){
var inst_70551 = (state_70573[(7)]);
var inst_70551__$1 = (state_70573[(2)]);
var inst_70552 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_70553 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_70552,inst_70551__$1);
var state_70573__$1 = (function (){var statearr_70581 = state_70573;
(statearr_70581[(7)] = inst_70551__$1);

return statearr_70581;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70573__$1,(13),inst_70553);
} else {
if((state_val_70574 === (2))){
var _ = (function (){var statearr_70582 = state_70573;
(statearr_70582[(4)] = cljs.core.cons((5),(state_70573[(4)])));

return statearr_70582;
})();
var inst_70538 = fluree.db.util.async.channel_QMARK_(query_map);
var state_70573__$1 = state_70573;
if(inst_70538){
var statearr_70583_70716 = state_70573__$1;
(statearr_70583_70716[(1)] = (6));

} else {
var statearr_70584_70717 = state_70573__$1;
(statearr_70584_70717[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (11))){
var inst_70545 = (state_70573[(9)]);
var state_70573__$1 = state_70573;
var statearr_70586_70718 = state_70573__$1;
(statearr_70586_70718[(2)] = inst_70545);

(statearr_70586_70718[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (9))){
var inst_70541 = (state_70573[(2)]);
var inst_70542 = fluree.db.util.async.throw_err(inst_70541);
var state_70573__$1 = state_70573;
var statearr_70587_70719 = state_70573__$1;
(statearr_70587_70719[(2)] = inst_70542);

(statearr_70587_70719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (5))){
var _ = (function (){var statearr_70588 = state_70573;
(statearr_70588[(4)] = cljs.core.rest((state_70573[(4)])));

return statearr_70588;
})();
var state_70573__$1 = state_70573;
var ex70585 = (state_70573__$1[(2)]);
var statearr_70589_70720 = state_70573__$1;
(statearr_70589_70720[(5)] = ex70585);


if((ex70585 instanceof Error)){
var statearr_70590_70721 = state_70573__$1;
(statearr_70590_70721[(1)] = (4));

(statearr_70590_70721[(5)] = null);

} else {
throw ex70585;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (10))){
var inst_70545 = (state_70573[(9)]);
var inst_70548 = fluree.db.util.json.parse(inst_70545);
var state_70573__$1 = state_70573;
var statearr_70591_70722 = state_70573__$1;
(statearr_70591_70722[(2)] = inst_70548);

(statearr_70591_70722[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70574 === (8))){
var inst_70545 = (state_70573[(9)]);
var inst_70545__$1 = (state_70573[(2)]);
var inst_70546 = typeof inst_70545__$1 === 'string';
var state_70573__$1 = (function (){var statearr_70592 = state_70573;
(statearr_70592[(9)] = inst_70545__$1);

return statearr_70592;
})();
if(cljs.core.truth_(inst_70546)){
var statearr_70593_70723 = state_70573__$1;
(statearr_70593_70723[(1)] = (10));

} else {
var statearr_70594_70724 = state_70573__$1;
(statearr_70594_70724[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70595 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70595[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70595[(1)] = (1));

return statearr_70595;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70573){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70573);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70596){var ex__2730__auto__ = e70596;
var statearr_70597_70725 = state_70573;
(statearr_70597_70725[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70573[(4)]))){
var statearr_70598_70726 = state_70573;
(statearr_70598_70726[(1)] = cljs.core.first((state_70573[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70727 = state_70573;
state_70573 = G__70727;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70573){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70599 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70599[(6)] = c__2749__auto__);

return statearr_70599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70670){
var state_val_70671 = (state_70670[(1)]);
if((state_val_70671 === (7))){
var state_70670__$1 = state_70670;
var statearr_70672_70728 = state_70670__$1;
(statearr_70672_70728[(2)] = select);

(statearr_70672_70728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (20))){
var inst_70640 = (state_70670[(2)]);
var inst_70641 = fluree.db.util.async.channel_QMARK_(limit);
var state_70670__$1 = (function (){var statearr_70673 = state_70670;
(statearr_70673[(7)] = inst_70640);

return statearr_70673;
})();
if(inst_70641){
var statearr_70674_70729 = state_70670__$1;
(statearr_70674_70729[(1)] = (22));

} else {
var statearr_70675_70730 = state_70670__$1;
(statearr_70675_70730[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (1))){
var state_70670__$1 = state_70670;
var statearr_70676_70731 = state_70670__$1;
(statearr_70676_70731[(2)] = null);

(statearr_70676_70731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (24))){
var inst_70624 = (state_70670[(8)]);
var inst_70632 = (state_70670[(9)]);
var inst_70640 = (state_70670[(7)]);
var inst_70616 = (state_70670[(10)]);
var inst_70648 = (state_70670[(2)]);
var inst_70649 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_70650 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_70649,inst_70616,inst_70624,inst_70632,inst_70640,inst_70648);
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70670__$1,(26),inst_70650);
} else {
if((state_val_70671 === (4))){
var inst_70600 = (state_70670[(2)]);
var state_70670__$1 = state_70670;
var statearr_70677_70732 = state_70670__$1;
(statearr_70677_70732[(2)] = inst_70600);

(statearr_70677_70732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (15))){
var state_70670__$1 = state_70670;
var statearr_70678_70733 = state_70670__$1;
(statearr_70678_70733[(2)] = where);

(statearr_70678_70733[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (21))){
var inst_70636 = (state_70670[(2)]);
var inst_70637 = fluree.db.util.async.throw_err(inst_70636);
var state_70670__$1 = state_70670;
var statearr_70679_70734 = state_70670__$1;
(statearr_70679_70734[(2)] = inst_70637);

(statearr_70679_70734[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (13))){
var inst_70620 = (state_70670[(2)]);
var inst_70621 = fluree.db.util.async.throw_err(inst_70620);
var state_70670__$1 = state_70670;
var statearr_70680_70735 = state_70670__$1;
(statearr_70680_70735[(2)] = inst_70621);

(statearr_70680_70735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (22))){
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70670__$1,(25),limit);
} else {
if((state_val_70671 === (6))){
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70670__$1,(9),select);
} else {
if((state_val_70671 === (25))){
var inst_70644 = (state_70670[(2)]);
var inst_70645 = fluree.db.util.async.throw_err(inst_70644);
var state_70670__$1 = state_70670;
var statearr_70681_70736 = state_70670__$1;
(statearr_70681_70736[(2)] = inst_70645);

(statearr_70681_70736[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (17))){
var inst_70628 = (state_70670[(2)]);
var inst_70629 = fluree.db.util.async.throw_err(inst_70628);
var state_70670__$1 = state_70670;
var statearr_70682_70737 = state_70670__$1;
(statearr_70682_70737[(2)] = inst_70629);

(statearr_70682_70737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (3))){
var inst_70668 = (state_70670[(2)]);
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70670__$1,inst_70668);
} else {
if((state_val_70671 === (12))){
var inst_70624 = (state_70670[(2)]);
var inst_70625 = fluree.db.util.async.channel_QMARK_(where);
var state_70670__$1 = (function (){var statearr_70683 = state_70670;
(statearr_70683[(8)] = inst_70624);

return statearr_70683;
})();
if(inst_70625){
var statearr_70684_70738 = state_70670__$1;
(statearr_70684_70738[(1)] = (14));

} else {
var statearr_70685_70739 = state_70670__$1;
(statearr_70685_70739[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (2))){
var _ = (function (){var statearr_70686 = state_70670;
(statearr_70686[(4)] = cljs.core.cons((5),(state_70670[(4)])));

return statearr_70686;
})();
var inst_70609 = fluree.db.util.async.channel_QMARK_(select);
var state_70670__$1 = state_70670;
if(inst_70609){
var statearr_70687_70740 = state_70670__$1;
(statearr_70687_70740[(1)] = (6));

} else {
var statearr_70688_70741 = state_70670__$1;
(statearr_70688_70741[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (23))){
var state_70670__$1 = state_70670;
var statearr_70689_70742 = state_70670__$1;
(statearr_70689_70742[(2)] = limit);

(statearr_70689_70742[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (19))){
var state_70670__$1 = state_70670;
var statearr_70690_70743 = state_70670__$1;
(statearr_70690_70743[(2)] = block);

(statearr_70690_70743[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (11))){
var state_70670__$1 = state_70670;
var statearr_70692_70744 = state_70670__$1;
(statearr_70692_70744[(2)] = from);

(statearr_70692_70744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (9))){
var inst_70612 = (state_70670[(2)]);
var inst_70613 = fluree.db.util.async.throw_err(inst_70612);
var state_70670__$1 = state_70670;
var statearr_70693_70745 = state_70670__$1;
(statearr_70693_70745[(2)] = inst_70613);

(statearr_70693_70745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (5))){
var _ = (function (){var statearr_70694 = state_70670;
(statearr_70694[(4)] = cljs.core.rest((state_70670[(4)])));

return statearr_70694;
})();
var state_70670__$1 = state_70670;
var ex70691 = (state_70670__$1[(2)]);
var statearr_70695_70746 = state_70670__$1;
(statearr_70695_70746[(5)] = ex70691);


if((ex70691 instanceof Error)){
var statearr_70696_70747 = state_70670__$1;
(statearr_70696_70747[(1)] = (4));

(statearr_70696_70747[(5)] = null);

} else {
throw ex70691;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (14))){
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70670__$1,(17),where);
} else {
if((state_val_70671 === (26))){
var inst_70624 = (state_70670[(8)]);
var inst_70632 = (state_70670[(9)]);
var inst_70640 = (state_70670[(7)]);
var inst_70616 = (state_70670[(10)]);
var inst_70652 = (state_70670[(2)]);
var inst_70653 = fluree.db.util.async.throw_err(inst_70652);
var inst_70654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70653,(0),null);
var inst_70655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70653,(1),null);
var inst_70656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70657 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70659 = [inst_70616,inst_70624,inst_70632,inst_70640];
var inst_70660 = (new cljs.core.PersistentVector(null,4,(5),inst_70658,inst_70659,null));
var inst_70661 = ["query",inst_70660,inst_70654];
var inst_70662 = cljs.core.PersistentHashMap.fromArrays(inst_70657,inst_70661);
var inst_70663 = [inst_70662,inst_70655];
var inst_70664 = (new cljs.core.PersistentVector(null,2,(5),inst_70656,inst_70663,null));
var inst_70665 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70664);
var _ = (function (){var statearr_70697 = state_70670;
(statearr_70697[(4)] = cljs.core.rest((state_70670[(4)])));

return statearr_70697;
})();
var state_70670__$1 = (function (){var statearr_70698 = state_70670;
(statearr_70698[(11)] = inst_70665);

return statearr_70698;
})();
var statearr_70699_70748 = state_70670__$1;
(statearr_70699_70748[(2)] = inst_70654);

(statearr_70699_70748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (16))){
var inst_70632 = (state_70670[(2)]);
var inst_70633 = fluree.db.util.async.channel_QMARK_(block);
var state_70670__$1 = (function (){var statearr_70700 = state_70670;
(statearr_70700[(9)] = inst_70632);

return statearr_70700;
})();
if(inst_70633){
var statearr_70701_70749 = state_70670__$1;
(statearr_70701_70749[(1)] = (18));

} else {
var statearr_70702_70750 = state_70670__$1;
(statearr_70702_70750[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70671 === (10))){
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70670__$1,(13),from);
} else {
if((state_val_70671 === (18))){
var state_70670__$1 = state_70670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70670__$1,(21),block);
} else {
if((state_val_70671 === (8))){
var inst_70616 = (state_70670[(2)]);
var inst_70617 = fluree.db.util.async.channel_QMARK_(from);
var state_70670__$1 = (function (){var statearr_70703 = state_70670;
(statearr_70703[(10)] = inst_70616);

return statearr_70703;
})();
if(inst_70617){
var statearr_70704_70751 = state_70670__$1;
(statearr_70704_70751[(1)] = (10));

} else {
var statearr_70705_70752 = state_70670__$1;
(statearr_70705_70752[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_70706 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70706[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_70706[(1)] = (1));

return statearr_70706;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_70670){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70670);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70707){var ex__2730__auto__ = e70707;
var statearr_70708_70753 = state_70670;
(statearr_70708_70753[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70670[(4)]))){
var statearr_70709_70754 = state_70670;
(statearr_70709_70754[(1)] = cljs.core.first((state_70670[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70755 = state_70670;
state_70670 = G__70755;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_70670){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_70670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70710 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70710[(6)] = c__2749__auto__);

return statearr_70710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70811){
var state_val_70812 = (state_70811[(1)]);
if((state_val_70812 === (7))){
var state_70811__$1 = state_70811;
var statearr_70813_70844 = state_70811__$1;
(statearr_70813_70844[(2)] = startSubject);

(statearr_70813_70844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (1))){
var state_70811__$1 = state_70811;
var statearr_70814_70845 = state_70811__$1;
(statearr_70814_70845[(2)] = null);

(statearr_70814_70845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (4))){
var inst_70756 = (state_70811[(2)]);
var state_70811__$1 = state_70811;
var statearr_70815_70846 = state_70811__$1;
(statearr_70815_70846[(2)] = inst_70756);

(statearr_70815_70846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (15))){
var inst_70788 = (state_70811[(2)]);
var inst_70789 = fluree.db.util.async.throw_err(inst_70788);
var inst_70790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70789,(0),null);
var inst_70791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70789,(1),null);
var inst_70792 = cljs.core.empty_QMARK_(inst_70790);
var state_70811__$1 = (function (){var statearr_70816 = state_70811;
(statearr_70816[(7)] = inst_70791);

return statearr_70816;
})();
if(inst_70792){
var statearr_70817_70847 = state_70811__$1;
(statearr_70817_70847[(1)] = (16));

} else {
var statearr_70818_70848 = state_70811__$1;
(statearr_70818_70848[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (13))){
var inst_70776 = (state_70811[(8)]);
var inst_70784 = (state_70811[(9)]);
var inst_70772 = (state_70811[(10)]);
var inst_70784__$1 = (state_70811[(2)]);
var inst_70785 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_70786 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_70785,inst_70772,inst_70776,inst_70784__$1);
var state_70811__$1 = (function (){var statearr_70819 = state_70811;
(statearr_70819[(9)] = inst_70784__$1);

return statearr_70819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70811__$1,(15),inst_70786);
} else {
if((state_val_70812 === (6))){
var state_70811__$1 = state_70811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70811__$1,(9),startSubject);
} else {
if((state_val_70812 === (17))){
var state_70811__$1 = state_70811;
var statearr_70820_70849 = state_70811__$1;
(statearr_70820_70849[(2)] = true);

(statearr_70820_70849[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (3))){
var inst_70809 = (state_70811[(2)]);
var state_70811__$1 = state_70811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70811__$1,inst_70809);
} else {
if((state_val_70812 === (12))){
var state_70811__$1 = state_70811;
var statearr_70821_70850 = state_70811__$1;
(statearr_70821_70850[(2)] = endSubject);

(statearr_70821_70850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (2))){
var _ = (function (){var statearr_70822 = state_70811;
(statearr_70822[(4)] = cljs.core.cons((5),(state_70811[(4)])));

return statearr_70822;
})();
var inst_70765 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_70811__$1 = state_70811;
if(inst_70765){
var statearr_70823_70851 = state_70811__$1;
(statearr_70823_70851[(1)] = (6));

} else {
var statearr_70824_70852 = state_70811__$1;
(statearr_70824_70852[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (11))){
var state_70811__$1 = state_70811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70811__$1,(14),endSubject);
} else {
if((state_val_70812 === (9))){
var inst_70768 = (state_70811[(2)]);
var inst_70769 = fluree.db.util.async.throw_err(inst_70768);
var state_70811__$1 = state_70811;
var statearr_70826_70853 = state_70811__$1;
(statearr_70826_70853[(2)] = inst_70769);

(statearr_70826_70853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (5))){
var _ = (function (){var statearr_70827 = state_70811;
(statearr_70827[(4)] = cljs.core.rest((state_70811[(4)])));

return statearr_70827;
})();
var state_70811__$1 = state_70811;
var ex70825 = (state_70811__$1[(2)]);
var statearr_70828_70854 = state_70811__$1;
(statearr_70828_70854[(5)] = ex70825);


if((ex70825 instanceof Error)){
var statearr_70829_70855 = state_70811__$1;
(statearr_70829_70855[(1)] = (4));

(statearr_70829_70855[(5)] = null);

} else {
throw ex70825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (14))){
var inst_70780 = (state_70811[(2)]);
var inst_70781 = fluree.db.util.async.throw_err(inst_70780);
var state_70811__$1 = state_70811;
var statearr_70830_70856 = state_70811__$1;
(statearr_70830_70856[(2)] = inst_70781);

(statearr_70830_70856[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (16))){
var state_70811__$1 = state_70811;
var statearr_70831_70857 = state_70811__$1;
(statearr_70831_70857[(2)] = false);

(statearr_70831_70857[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (10))){
var inst_70775 = (state_70811[(2)]);
var inst_70776 = fluree.db.util.async.throw_err(inst_70775);
var inst_70777 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_70811__$1 = (function (){var statearr_70832 = state_70811;
(statearr_70832[(8)] = inst_70776);

return statearr_70832;
})();
if(inst_70777){
var statearr_70833_70858 = state_70811__$1;
(statearr_70833_70858[(1)] = (11));

} else {
var statearr_70834_70859 = state_70811__$1;
(statearr_70834_70859[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (18))){
var inst_70776 = (state_70811[(8)]);
var inst_70784 = (state_70811[(9)]);
var inst_70791 = (state_70811[(7)]);
var inst_70772 = (state_70811[(10)]);
var inst_70796 = (state_70811[(2)]);
var inst_70797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70798 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70800 = [inst_70772,inst_70776,inst_70784];
var inst_70801 = (new cljs.core.PersistentVector(null,3,(5),inst_70799,inst_70800,null));
var inst_70802 = ["relationship?",inst_70801,inst_70796];
var inst_70803 = cljs.core.PersistentHashMap.fromArrays(inst_70798,inst_70802);
var inst_70804 = [inst_70803,inst_70791];
var inst_70805 = (new cljs.core.PersistentVector(null,2,(5),inst_70797,inst_70804,null));
var inst_70806 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70805);
var _ = (function (){var statearr_70835 = state_70811;
(statearr_70835[(4)] = cljs.core.rest((state_70811[(4)])));

return statearr_70835;
})();
var state_70811__$1 = (function (){var statearr_70836 = state_70811;
(statearr_70836[(11)] = inst_70806);

return statearr_70836;
})();
var statearr_70837_70860 = state_70811__$1;
(statearr_70837_70860[(2)] = inst_70796);

(statearr_70837_70860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70812 === (8))){
var inst_70772 = (state_70811[(2)]);
var inst_70773 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_70811__$1 = (function (){var statearr_70838 = state_70811;
(statearr_70838[(10)] = inst_70772);

return statearr_70838;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70811__$1,(10),inst_70773);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_70839 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70839[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_70839[(1)] = (1));

return statearr_70839;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_70811){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70811);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70840){var ex__2730__auto__ = e70840;
var statearr_70841_70861 = state_70811;
(statearr_70841_70861[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70811[(4)]))){
var statearr_70842_70862 = state_70811;
(statearr_70842_70862[(1)] = cljs.core.first((state_70811[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70863 = state_70811;
state_70811 = G__70863;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_70811){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_70811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70843 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70843[(6)] = c__2749__auto__);

return statearr_70843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70900){
var state_val_70901 = (state_70900[(1)]);
if((state_val_70901 === (7))){
var state_70900__$1 = state_70900;
var statearr_70902_70922 = state_70900__$1;
(statearr_70902_70922[(2)] = pred_name);

(statearr_70902_70922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (1))){
var state_70900__$1 = state_70900;
var statearr_70903_70923 = state_70900__$1;
(statearr_70903_70923[(2)] = null);

(statearr_70903_70923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (4))){
var inst_70864 = (state_70900[(2)]);
var state_70900__$1 = state_70900;
var statearr_70904_70924 = state_70900__$1;
(statearr_70904_70924[(2)] = inst_70864);

(statearr_70904_70924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (6))){
var state_70900__$1 = state_70900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70900__$1,(9),pred_name);
} else {
if((state_val_70901 === (3))){
var inst_70898 = (state_70900[(2)]);
var state_70900__$1 = state_70900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70900__$1,inst_70898);
} else {
if((state_val_70901 === (2))){
var _ = (function (){var statearr_70906 = state_70900;
(statearr_70906[(4)] = cljs.core.cons((5),(state_70900[(4)])));

return statearr_70906;
})();
var inst_70873 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_70900__$1 = state_70900;
if(inst_70873){
var statearr_70907_70925 = state_70900__$1;
(statearr_70907_70925[(1)] = (6));

} else {
var statearr_70908_70926 = state_70900__$1;
(statearr_70908_70926[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (9))){
var inst_70876 = (state_70900[(2)]);
var inst_70877 = fluree.db.util.async.throw_err(inst_70876);
var state_70900__$1 = state_70900;
var statearr_70909_70927 = state_70900__$1;
(statearr_70909_70927[(2)] = inst_70877);

(statearr_70909_70927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (5))){
var _ = (function (){var statearr_70910 = state_70900;
(statearr_70910[(4)] = cljs.core.rest((state_70900[(4)])));

return statearr_70910;
})();
var state_70900__$1 = state_70900;
var ex70905 = (state_70900__$1[(2)]);
var statearr_70911_70928 = state_70900__$1;
(statearr_70911_70928[(5)] = ex70905);


if((ex70905 instanceof Error)){
var statearr_70912_70929 = state_70900__$1;
(statearr_70912_70929[(1)] = (4));

(statearr_70912_70929[(5)] = null);

} else {
throw ex70905;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (10))){
var inst_70880 = (state_70900[(7)]);
var inst_70884 = (state_70900[(2)]);
var inst_70885 = fluree.db.util.async.throw_err(inst_70884);
var inst_70886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70885,(0),null);
var inst_70887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70885,(1),null);
var inst_70888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70890 = ["max-pred-val",inst_70880,inst_70886];
var inst_70891 = cljs.core.PersistentHashMap.fromArrays(inst_70889,inst_70890);
var inst_70892 = (inst_70887 + (10));
var inst_70893 = [inst_70891,inst_70892];
var inst_70894 = (new cljs.core.PersistentVector(null,2,(5),inst_70888,inst_70893,null));
var inst_70895 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70894);
var _ = (function (){var statearr_70913 = state_70900;
(statearr_70913[(4)] = cljs.core.rest((state_70900[(4)])));

return statearr_70913;
})();
var state_70900__$1 = (function (){var statearr_70914 = state_70900;
(statearr_70914[(8)] = inst_70895);

return statearr_70914;
})();
var statearr_70915_70930 = state_70900__$1;
(statearr_70915_70930[(2)] = inst_70886);

(statearr_70915_70930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70901 === (8))){
var inst_70880 = (state_70900[(7)]);
var inst_70880__$1 = (state_70900[(2)]);
var inst_70881 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_70882 = fluree.db.dbfunctions.internal.max_pred_val(inst_70881,inst_70880__$1,null);
var state_70900__$1 = (function (){var statearr_70916 = state_70900;
(statearr_70916[(7)] = inst_70880__$1);

return statearr_70916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70900__$1,(10),inst_70882);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_70917 = [null,null,null,null,null,null,null,null,null];
(statearr_70917[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_70917[(1)] = (1));

return statearr_70917;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_70900){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70900);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70918){var ex__2730__auto__ = e70918;
var statearr_70919_70931 = state_70900;
(statearr_70919_70931[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70900[(4)]))){
var statearr_70920_70932 = state_70900;
(statearr_70920_70932[(1)] = cljs.core.first((state_70900[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70933 = state_70900;
state_70900 = G__70933;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_70900){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_70900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70921 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70921[(6)] = c__2749__auto__);

return statearr_70921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70960){
var state_val_70961 = (state_70960[(1)]);
if((state_val_70961 === (7))){
var state_70960__$1 = state_70960;
var statearr_70962_70981 = state_70960__$1;
(statearr_70962_70981[(2)] = n);

(statearr_70962_70981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (1))){
var state_70960__$1 = state_70960;
var statearr_70963_70982 = state_70960__$1;
(statearr_70963_70982[(2)] = null);

(statearr_70963_70982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (4))){
var inst_70934 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_70964_70983 = state_70960__$1;
(statearr_70964_70983[(2)] = inst_70934);

(statearr_70964_70983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (6))){
var state_70960__$1 = state_70960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70960__$1,(9),n);
} else {
if((state_val_70961 === (3))){
var inst_70958 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70960__$1,inst_70958);
} else {
if((state_val_70961 === (2))){
var _ = (function (){var statearr_70966 = state_70960;
(statearr_70966[(4)] = cljs.core.cons((5),(state_70960[(4)])));

return statearr_70966;
})();
var inst_70940 = fluree.db.util.async.channel_QMARK_(n);
var state_70960__$1 = state_70960;
if(inst_70940){
var statearr_70967_70984 = state_70960__$1;
(statearr_70967_70984[(1)] = (6));

} else {
var statearr_70968_70985 = state_70960__$1;
(statearr_70968_70985[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (9))){
var inst_70943 = (state_70960[(2)]);
var inst_70944 = fluree.db.util.async.throw_err(inst_70943);
var state_70960__$1 = state_70960;
var statearr_70969_70986 = state_70960__$1;
(statearr_70969_70986[(2)] = inst_70944);

(statearr_70969_70986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (5))){
var _ = (function (){var statearr_70970 = state_70960;
(statearr_70970[(4)] = cljs.core.rest((state_70960[(4)])));

return statearr_70970;
})();
var state_70960__$1 = state_70960;
var ex70965 = (state_70960__$1[(2)]);
var statearr_70971_70987 = state_70960__$1;
(statearr_70971_70987[(5)] = ex70965);


if((ex70965 instanceof Error)){
var statearr_70972_70988 = state_70960__$1;
(statearr_70972_70988[(1)] = (4));

(statearr_70972_70988[(5)] = null);

} else {
throw ex70965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (8))){
var inst_70947 = (state_70960[(2)]);
var inst_70948 = fluree.db.dbfunctions.internal.inc(inst_70947);
var inst_70949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70950 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70951 = ["inc",inst_70947,inst_70948];
var inst_70952 = cljs.core.PersistentHashMap.fromArrays(inst_70950,inst_70951);
var inst_70953 = [inst_70952,(10)];
var inst_70954 = (new cljs.core.PersistentVector(null,2,(5),inst_70949,inst_70953,null));
var inst_70955 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70954);
var _ = (function (){var statearr_70973 = state_70960;
(statearr_70973[(4)] = cljs.core.rest((state_70960[(4)])));

return statearr_70973;
})();
var state_70960__$1 = (function (){var statearr_70974 = state_70960;
(statearr_70974[(7)] = inst_70955);

return statearr_70974;
})();
var statearr_70975_70989 = state_70960__$1;
(statearr_70975_70989[(2)] = inst_70948);

(statearr_70975_70989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_70976 = [null,null,null,null,null,null,null,null];
(statearr_70976[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_70976[(1)] = (1));

return statearr_70976;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_70960){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70960);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70977){var ex__2730__auto__ = e70977;
var statearr_70978_70990 = state_70960;
(statearr_70978_70990[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70960[(4)]))){
var statearr_70979_70991 = state_70960;
(statearr_70979_70991[(1)] = cljs.core.first((state_70960[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70992 = state_70960;
state_70960 = G__70992;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_70960){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_70960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70980 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70980[(6)] = c__2749__auto__);

return statearr_70980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71019){
var state_val_71020 = (state_71019[(1)]);
if((state_val_71020 === (7))){
var state_71019__$1 = state_71019;
var statearr_71021_71040 = state_71019__$1;
(statearr_71021_71040[(2)] = n);

(statearr_71021_71040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71020 === (1))){
var state_71019__$1 = state_71019;
var statearr_71022_71041 = state_71019__$1;
(statearr_71022_71041[(2)] = null);

(statearr_71022_71041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71020 === (4))){
var inst_70993 = (state_71019[(2)]);
var state_71019__$1 = state_71019;
var statearr_71023_71042 = state_71019__$1;
(statearr_71023_71042[(2)] = inst_70993);

(statearr_71023_71042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71020 === (6))){
var state_71019__$1 = state_71019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71019__$1,(9),n);
} else {
if((state_val_71020 === (3))){
var inst_71017 = (state_71019[(2)]);
var state_71019__$1 = state_71019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71019__$1,inst_71017);
} else {
if((state_val_71020 === (2))){
var _ = (function (){var statearr_71025 = state_71019;
(statearr_71025[(4)] = cljs.core.cons((5),(state_71019[(4)])));

return statearr_71025;
})();
var inst_70999 = fluree.db.util.async.channel_QMARK_(n);
var state_71019__$1 = state_71019;
if(inst_70999){
var statearr_71026_71043 = state_71019__$1;
(statearr_71026_71043[(1)] = (6));

} else {
var statearr_71027_71044 = state_71019__$1;
(statearr_71027_71044[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71020 === (9))){
var inst_71002 = (state_71019[(2)]);
var inst_71003 = fluree.db.util.async.throw_err(inst_71002);
var state_71019__$1 = state_71019;
var statearr_71028_71045 = state_71019__$1;
(statearr_71028_71045[(2)] = inst_71003);

(statearr_71028_71045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71020 === (5))){
var _ = (function (){var statearr_71029 = state_71019;
(statearr_71029[(4)] = cljs.core.rest((state_71019[(4)])));

return statearr_71029;
})();
var state_71019__$1 = state_71019;
var ex71024 = (state_71019__$1[(2)]);
var statearr_71030_71046 = state_71019__$1;
(statearr_71030_71046[(5)] = ex71024);


if((ex71024 instanceof Error)){
var statearr_71031_71047 = state_71019__$1;
(statearr_71031_71047[(1)] = (4));

(statearr_71031_71047[(5)] = null);

} else {
throw ex71024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71020 === (8))){
var inst_71006 = (state_71019[(2)]);
var inst_71007 = fluree.db.dbfunctions.internal.dec(inst_71006);
var inst_71008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71009 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71010 = ["dec",inst_71006,inst_71007];
var inst_71011 = cljs.core.PersistentHashMap.fromArrays(inst_71009,inst_71010);
var inst_71012 = [inst_71011,(10)];
var inst_71013 = (new cljs.core.PersistentVector(null,2,(5),inst_71008,inst_71012,null));
var inst_71014 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71013);
var _ = (function (){var statearr_71032 = state_71019;
(statearr_71032[(4)] = cljs.core.rest((state_71019[(4)])));

return statearr_71032;
})();
var state_71019__$1 = (function (){var statearr_71033 = state_71019;
(statearr_71033[(7)] = inst_71014);

return statearr_71033;
})();
var statearr_71034_71048 = state_71019__$1;
(statearr_71034_71048[(2)] = inst_71007);

(statearr_71034_71048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_71035 = [null,null,null,null,null,null,null,null];
(statearr_71035[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_71035[(1)] = (1));

return statearr_71035;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_71019){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71019);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71036){var ex__2730__auto__ = e71036;
var statearr_71037_71049 = state_71019;
(statearr_71037_71049[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71019[(4)]))){
var statearr_71038_71050 = state_71019;
(statearr_71038_71050[(1)] = cljs.core.first((state_71019[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71051 = state_71019;
state_71019 = G__71051;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_71019){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_71019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71039 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71039[(6)] = c__2749__auto__);

return statearr_71039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71101 = arguments.length;
var i__5770__auto___71102 = (0);
while(true){
if((i__5770__auto___71102 < len__5769__auto___71101)){
args__5775__auto__.push((arguments[i__5770__auto___71102]));

var G__71103 = (i__5770__auto___71102 + (1));
i__5770__auto___71102 = G__71103;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71084){
var state_val_71085 = (state_71084[(1)]);
if((state_val_71085 === (1))){
var state_71084__$1 = state_71084;
var statearr_71086_71104 = state_71084__$1;
(statearr_71086_71104[(2)] = null);

(statearr_71086_71104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71085 === (2))){
var _ = (function (){var statearr_71087 = state_71084;
(statearr_71087[(4)] = cljs.core.cons((5),(state_71084[(4)])));

return statearr_71087;
})();
var inst_71060 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71084__$1 = state_71084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71084__$1,(6),inst_71060);
} else {
if((state_val_71085 === (3))){
var inst_71082 = (state_71084[(2)]);
var state_71084__$1 = state_71084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71084__$1,inst_71082);
} else {
if((state_val_71085 === (4))){
var inst_71054 = (state_71084[(2)]);
var state_71084__$1 = state_71084;
var statearr_71089_71105 = state_71084__$1;
(statearr_71089_71105[(2)] = inst_71054);

(statearr_71089_71105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71085 === (5))){
var _ = (function (){var statearr_71090 = state_71084;
(statearr_71090[(4)] = cljs.core.rest((state_71084[(4)])));

return statearr_71090;
})();
var state_71084__$1 = state_71084;
var ex71088 = (state_71084__$1[(2)]);
var statearr_71091_71106 = state_71084__$1;
(statearr_71091_71106[(5)] = ex71088);


if((ex71088 instanceof Error)){
var statearr_71092_71107 = state_71084__$1;
(statearr_71092_71107[(1)] = (4));

(statearr_71092_71107[(5)] = null);

} else {
throw ex71088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71085 === (6))){
var inst_71062 = (state_71084[(2)]);
var inst_71063 = fluree.db.util.async.throw_err(inst_71062);
var inst_71064 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_71063);
var inst_71065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71066 = [inst_71063];
var inst_71067 = (new cljs.core.PersistentVector(null,1,(5),inst_71065,inst_71066,null));
var inst_71068 = cljs.core.count(inst_71067);
var inst_71069 = ((9) + inst_71068);
var inst_71070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71071 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71073 = [inst_71063];
var inst_71074 = (new cljs.core.PersistentVector(null,1,(5),inst_71072,inst_71073,null));
var inst_71075 = ["+",inst_71074,inst_71064];
var inst_71076 = cljs.core.PersistentHashMap.fromArrays(inst_71071,inst_71075);
var inst_71077 = [inst_71076,inst_71069];
var inst_71078 = (new cljs.core.PersistentVector(null,2,(5),inst_71070,inst_71077,null));
var inst_71079 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71078);
var _ = (function (){var statearr_71093 = state_71084;
(statearr_71093[(4)] = cljs.core.rest((state_71084[(4)])));

return statearr_71093;
})();
var state_71084__$1 = (function (){var statearr_71094 = state_71084;
(statearr_71094[(7)] = inst_71079);

return statearr_71094;
})();
var statearr_71095_71108 = state_71084__$1;
(statearr_71095_71108[(2)] = inst_71064);

(statearr_71095_71108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_71096 = [null,null,null,null,null,null,null,null];
(statearr_71096[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_71096[(1)] = (1));

return statearr_71096;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_71084){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71084);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71097){var ex__2730__auto__ = e71097;
var statearr_71098_71109 = state_71084;
(statearr_71098_71109[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71084[(4)]))){
var statearr_71099_71110 = state_71084;
(statearr_71099_71110[(1)] = cljs.core.first((state_71084[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71111 = state_71084;
state_71084 = G__71111;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_71084){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_71084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71100 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71100[(6)] = c__2749__auto__);

return statearr_71100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq71052){
var G__71053 = cljs.core.first(seq71052);
var seq71052__$1 = cljs.core.next(seq71052);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71053,seq71052__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71161 = arguments.length;
var i__5770__auto___71162 = (0);
while(true){
if((i__5770__auto___71162 < len__5769__auto___71161)){
args__5775__auto__.push((arguments[i__5770__auto___71162]));

var G__71163 = (i__5770__auto___71162 + (1));
i__5770__auto___71162 = G__71163;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71144){
var state_val_71145 = (state_71144[(1)]);
if((state_val_71145 === (1))){
var state_71144__$1 = state_71144;
var statearr_71146_71164 = state_71144__$1;
(statearr_71146_71164[(2)] = null);

(statearr_71146_71164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71145 === (2))){
var _ = (function (){var statearr_71147 = state_71144;
(statearr_71147[(4)] = cljs.core.cons((5),(state_71144[(4)])));

return statearr_71147;
})();
var inst_71120 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71144__$1 = state_71144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71144__$1,(6),inst_71120);
} else {
if((state_val_71145 === (3))){
var inst_71142 = (state_71144[(2)]);
var state_71144__$1 = state_71144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71144__$1,inst_71142);
} else {
if((state_val_71145 === (4))){
var inst_71114 = (state_71144[(2)]);
var state_71144__$1 = state_71144;
var statearr_71149_71165 = state_71144__$1;
(statearr_71149_71165[(2)] = inst_71114);

(statearr_71149_71165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71145 === (5))){
var _ = (function (){var statearr_71150 = state_71144;
(statearr_71150[(4)] = cljs.core.rest((state_71144[(4)])));

return statearr_71150;
})();
var state_71144__$1 = state_71144;
var ex71148 = (state_71144__$1[(2)]);
var statearr_71151_71166 = state_71144__$1;
(statearr_71151_71166[(5)] = ex71148);


if((ex71148 instanceof Error)){
var statearr_71152_71167 = state_71144__$1;
(statearr_71152_71167[(1)] = (4));

(statearr_71152_71167[(5)] = null);

} else {
throw ex71148;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71145 === (6))){
var inst_71122 = (state_71144[(2)]);
var inst_71123 = fluree.db.util.async.throw_err(inst_71122);
var inst_71124 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_71123);
var inst_71125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71126 = [inst_71123];
var inst_71127 = (new cljs.core.PersistentVector(null,1,(5),inst_71125,inst_71126,null));
var inst_71128 = cljs.core.count(inst_71127);
var inst_71129 = ((9) + inst_71128);
var inst_71130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71131 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71133 = [inst_71123];
var inst_71134 = (new cljs.core.PersistentVector(null,1,(5),inst_71132,inst_71133,null));
var inst_71135 = ["-",inst_71134,inst_71124];
var inst_71136 = cljs.core.PersistentHashMap.fromArrays(inst_71131,inst_71135);
var inst_71137 = [inst_71136,inst_71129];
var inst_71138 = (new cljs.core.PersistentVector(null,2,(5),inst_71130,inst_71137,null));
var inst_71139 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71138);
var _ = (function (){var statearr_71153 = state_71144;
(statearr_71153[(4)] = cljs.core.rest((state_71144[(4)])));

return statearr_71153;
})();
var state_71144__$1 = (function (){var statearr_71154 = state_71144;
(statearr_71154[(7)] = inst_71139);

return statearr_71154;
})();
var statearr_71155_71168 = state_71144__$1;
(statearr_71155_71168[(2)] = inst_71124);

(statearr_71155_71168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_71156 = [null,null,null,null,null,null,null,null];
(statearr_71156[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_71156[(1)] = (1));

return statearr_71156;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_71144){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71144);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71157){var ex__2730__auto__ = e71157;
var statearr_71158_71169 = state_71144;
(statearr_71158_71169[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71144[(4)]))){
var statearr_71159_71170 = state_71144;
(statearr_71159_71170[(1)] = cljs.core.first((state_71144[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71171 = state_71144;
state_71144 = G__71171;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_71144){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_71144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71160 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71160[(6)] = c__2749__auto__);

return statearr_71160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq71112){
var G__71113 = cljs.core.first(seq71112);
var seq71112__$1 = cljs.core.next(seq71112);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71113,seq71112__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71221 = arguments.length;
var i__5770__auto___71222 = (0);
while(true){
if((i__5770__auto___71222 < len__5769__auto___71221)){
args__5775__auto__.push((arguments[i__5770__auto___71222]));

var G__71223 = (i__5770__auto___71222 + (1));
i__5770__auto___71222 = G__71223;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71204){
var state_val_71205 = (state_71204[(1)]);
if((state_val_71205 === (1))){
var state_71204__$1 = state_71204;
var statearr_71206_71224 = state_71204__$1;
(statearr_71206_71224[(2)] = null);

(statearr_71206_71224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71205 === (2))){
var _ = (function (){var statearr_71207 = state_71204;
(statearr_71207[(4)] = cljs.core.cons((5),(state_71204[(4)])));

return statearr_71207;
})();
var inst_71180 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71204__$1 = state_71204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71204__$1,(6),inst_71180);
} else {
if((state_val_71205 === (3))){
var inst_71202 = (state_71204[(2)]);
var state_71204__$1 = state_71204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71204__$1,inst_71202);
} else {
if((state_val_71205 === (4))){
var inst_71174 = (state_71204[(2)]);
var state_71204__$1 = state_71204;
var statearr_71209_71225 = state_71204__$1;
(statearr_71209_71225[(2)] = inst_71174);

(statearr_71209_71225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71205 === (5))){
var _ = (function (){var statearr_71210 = state_71204;
(statearr_71210[(4)] = cljs.core.rest((state_71204[(4)])));

return statearr_71210;
})();
var state_71204__$1 = state_71204;
var ex71208 = (state_71204__$1[(2)]);
var statearr_71211_71226 = state_71204__$1;
(statearr_71211_71226[(5)] = ex71208);


if((ex71208 instanceof Error)){
var statearr_71212_71227 = state_71204__$1;
(statearr_71212_71227[(1)] = (4));

(statearr_71212_71227[(5)] = null);

} else {
throw ex71208;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71205 === (6))){
var inst_71182 = (state_71204[(2)]);
var inst_71183 = fluree.db.util.async.throw_err(inst_71182);
var inst_71184 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_71183);
var inst_71185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71186 = [inst_71183];
var inst_71187 = (new cljs.core.PersistentVector(null,1,(5),inst_71185,inst_71186,null));
var inst_71188 = cljs.core.count(inst_71187);
var inst_71189 = ((9) + inst_71188);
var inst_71190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71191 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71193 = [inst_71183];
var inst_71194 = (new cljs.core.PersistentVector(null,1,(5),inst_71192,inst_71193,null));
var inst_71195 = ["*",inst_71194,inst_71184];
var inst_71196 = cljs.core.PersistentHashMap.fromArrays(inst_71191,inst_71195);
var inst_71197 = [inst_71196,inst_71189];
var inst_71198 = (new cljs.core.PersistentVector(null,2,(5),inst_71190,inst_71197,null));
var inst_71199 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71198);
var _ = (function (){var statearr_71213 = state_71204;
(statearr_71213[(4)] = cljs.core.rest((state_71204[(4)])));

return statearr_71213;
})();
var state_71204__$1 = (function (){var statearr_71214 = state_71204;
(statearr_71214[(7)] = inst_71199);

return statearr_71214;
})();
var statearr_71215_71228 = state_71204__$1;
(statearr_71215_71228[(2)] = inst_71184);

(statearr_71215_71228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_71216 = [null,null,null,null,null,null,null,null];
(statearr_71216[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_71216[(1)] = (1));

return statearr_71216;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_71204){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71204);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71217){var ex__2730__auto__ = e71217;
var statearr_71218_71229 = state_71204;
(statearr_71218_71229[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71204[(4)]))){
var statearr_71219_71230 = state_71204;
(statearr_71219_71230[(1)] = cljs.core.first((state_71204[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71231 = state_71204;
state_71204 = G__71231;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_71204){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_71204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71220 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71220[(6)] = c__2749__auto__);

return statearr_71220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq71172){
var G__71173 = cljs.core.first(seq71172);
var seq71172__$1 = cljs.core.next(seq71172);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71173,seq71172__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71281 = arguments.length;
var i__5770__auto___71282 = (0);
while(true){
if((i__5770__auto___71282 < len__5769__auto___71281)){
args__5775__auto__.push((arguments[i__5770__auto___71282]));

var G__71283 = (i__5770__auto___71282 + (1));
i__5770__auto___71282 = G__71283;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71264){
var state_val_71265 = (state_71264[(1)]);
if((state_val_71265 === (1))){
var state_71264__$1 = state_71264;
var statearr_71266_71284 = state_71264__$1;
(statearr_71266_71284[(2)] = null);

(statearr_71266_71284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71265 === (2))){
var _ = (function (){var statearr_71267 = state_71264;
(statearr_71267[(4)] = cljs.core.cons((5),(state_71264[(4)])));

return statearr_71267;
})();
var inst_71240 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71264__$1 = state_71264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71264__$1,(6),inst_71240);
} else {
if((state_val_71265 === (3))){
var inst_71262 = (state_71264[(2)]);
var state_71264__$1 = state_71264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71264__$1,inst_71262);
} else {
if((state_val_71265 === (4))){
var inst_71234 = (state_71264[(2)]);
var state_71264__$1 = state_71264;
var statearr_71269_71285 = state_71264__$1;
(statearr_71269_71285[(2)] = inst_71234);

(statearr_71269_71285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71265 === (5))){
var _ = (function (){var statearr_71270 = state_71264;
(statearr_71270[(4)] = cljs.core.rest((state_71264[(4)])));

return statearr_71270;
})();
var state_71264__$1 = state_71264;
var ex71268 = (state_71264__$1[(2)]);
var statearr_71271_71286 = state_71264__$1;
(statearr_71271_71286[(5)] = ex71268);


if((ex71268 instanceof Error)){
var statearr_71272_71287 = state_71264__$1;
(statearr_71272_71287[(1)] = (4));

(statearr_71272_71287[(5)] = null);

} else {
throw ex71268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71265 === (6))){
var inst_71242 = (state_71264[(2)]);
var inst_71243 = fluree.db.util.async.throw_err(inst_71242);
var inst_71244 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_71243);
var inst_71245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71246 = [inst_71243];
var inst_71247 = (new cljs.core.PersistentVector(null,1,(5),inst_71245,inst_71246,null));
var inst_71248 = cljs.core.count(inst_71247);
var inst_71249 = ((9) + inst_71248);
var inst_71250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71251 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71253 = [inst_71243];
var inst_71254 = (new cljs.core.PersistentVector(null,1,(5),inst_71252,inst_71253,null));
var inst_71255 = ["/",inst_71254,inst_71244];
var inst_71256 = cljs.core.PersistentHashMap.fromArrays(inst_71251,inst_71255);
var inst_71257 = [inst_71256,inst_71249];
var inst_71258 = (new cljs.core.PersistentVector(null,2,(5),inst_71250,inst_71257,null));
var inst_71259 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71258);
var _ = (function (){var statearr_71273 = state_71264;
(statearr_71273[(4)] = cljs.core.rest((state_71264[(4)])));

return statearr_71273;
})();
var state_71264__$1 = (function (){var statearr_71274 = state_71264;
(statearr_71274[(7)] = inst_71259);

return statearr_71274;
})();
var statearr_71275_71288 = state_71264__$1;
(statearr_71275_71288[(2)] = inst_71244);

(statearr_71275_71288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_71276 = [null,null,null,null,null,null,null,null];
(statearr_71276[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_71276[(1)] = (1));

return statearr_71276;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_71264){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71264);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71277){var ex__2730__auto__ = e71277;
var statearr_71278_71289 = state_71264;
(statearr_71278_71289[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71264[(4)]))){
var statearr_71279_71290 = state_71264;
(statearr_71279_71290[(1)] = cljs.core.first((state_71264[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71291 = state_71264;
state_71264 = G__71291;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_71264){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_71264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71280 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71280[(6)] = c__2749__auto__);

return statearr_71280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq71232){
var G__71233 = cljs.core.first(seq71232);
var seq71232__$1 = cljs.core.next(seq71232);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71233,seq71232__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71329){
var state_val_71330 = (state_71329[(1)]);
if((state_val_71330 === (7))){
var state_71329__$1 = state_71329;
var statearr_71331_71355 = state_71329__$1;
(statearr_71331_71355[(2)] = n);

(statearr_71331_71355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (1))){
var state_71329__$1 = state_71329;
var statearr_71332_71356 = state_71329__$1;
(statearr_71332_71356[(2)] = null);

(statearr_71332_71356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (4))){
var inst_71292 = (state_71329[(2)]);
var state_71329__$1 = state_71329;
var statearr_71333_71357 = state_71329__$1;
(statearr_71333_71357[(2)] = inst_71292);

(statearr_71333_71357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (13))){
var inst_71309 = (state_71329[(2)]);
var inst_71310 = fluree.db.util.async.throw_err(inst_71309);
var state_71329__$1 = state_71329;
var statearr_71334_71358 = state_71329__$1;
(statearr_71334_71358[(2)] = inst_71310);

(statearr_71334_71358[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (6))){
var state_71329__$1 = state_71329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71329__$1,(9),n);
} else {
if((state_val_71330 === (3))){
var inst_71327 = (state_71329[(2)]);
var state_71329__$1 = state_71329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71329__$1,inst_71327);
} else {
if((state_val_71330 === (12))){
var inst_71305 = (state_71329[(7)]);
var inst_71313 = (state_71329[(2)]);
var inst_71314 = fluree.db.dbfunctions.internal.quot(inst_71305,inst_71313);
var inst_71315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71316 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71318 = [inst_71305,inst_71313];
var inst_71319 = (new cljs.core.PersistentVector(null,2,(5),inst_71317,inst_71318,null));
var inst_71320 = ["quot",inst_71319,inst_71314];
var inst_71321 = cljs.core.PersistentHashMap.fromArrays(inst_71316,inst_71320);
var inst_71322 = [inst_71321,(2)];
var inst_71323 = (new cljs.core.PersistentVector(null,2,(5),inst_71315,inst_71322,null));
var inst_71324 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71323);
var _ = (function (){var statearr_71335 = state_71329;
(statearr_71335[(4)] = cljs.core.rest((state_71329[(4)])));

return statearr_71335;
})();
var state_71329__$1 = (function (){var statearr_71336 = state_71329;
(statearr_71336[(8)] = inst_71324);

return statearr_71336;
})();
var statearr_71337_71359 = state_71329__$1;
(statearr_71337_71359[(2)] = inst_71314);

(statearr_71337_71359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (2))){
var _ = (function (){var statearr_71338 = state_71329;
(statearr_71338[(4)] = cljs.core.cons((5),(state_71329[(4)])));

return statearr_71338;
})();
var inst_71298 = fluree.db.util.async.channel_QMARK_(n);
var state_71329__$1 = state_71329;
if(inst_71298){
var statearr_71339_71360 = state_71329__$1;
(statearr_71339_71360[(1)] = (6));

} else {
var statearr_71340_71361 = state_71329__$1;
(statearr_71340_71361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (11))){
var state_71329__$1 = state_71329;
var statearr_71342_71362 = state_71329__$1;
(statearr_71342_71362[(2)] = d);

(statearr_71342_71362[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (9))){
var inst_71301 = (state_71329[(2)]);
var inst_71302 = fluree.db.util.async.throw_err(inst_71301);
var state_71329__$1 = state_71329;
var statearr_71343_71363 = state_71329__$1;
(statearr_71343_71363[(2)] = inst_71302);

(statearr_71343_71363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (5))){
var _ = (function (){var statearr_71344 = state_71329;
(statearr_71344[(4)] = cljs.core.rest((state_71329[(4)])));

return statearr_71344;
})();
var state_71329__$1 = state_71329;
var ex71341 = (state_71329__$1[(2)]);
var statearr_71345_71364 = state_71329__$1;
(statearr_71345_71364[(5)] = ex71341);


if((ex71341 instanceof Error)){
var statearr_71346_71365 = state_71329__$1;
(statearr_71346_71365[(1)] = (4));

(statearr_71346_71365[(5)] = null);

} else {
throw ex71341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71330 === (10))){
var state_71329__$1 = state_71329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71329__$1,(13),d);
} else {
if((state_val_71330 === (8))){
var inst_71305 = (state_71329[(2)]);
var inst_71306 = fluree.db.util.async.channel_QMARK_(d);
var state_71329__$1 = (function (){var statearr_71347 = state_71329;
(statearr_71347[(7)] = inst_71305);

return statearr_71347;
})();
if(inst_71306){
var statearr_71348_71366 = state_71329__$1;
(statearr_71348_71366[(1)] = (10));

} else {
var statearr_71349_71367 = state_71329__$1;
(statearr_71349_71367[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_71350 = [null,null,null,null,null,null,null,null,null];
(statearr_71350[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_71350[(1)] = (1));

return statearr_71350;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_71329){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71329);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71351){var ex__2730__auto__ = e71351;
var statearr_71352_71368 = state_71329;
(statearr_71352_71368[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71329[(4)]))){
var statearr_71353_71369 = state_71329;
(statearr_71353_71369[(1)] = cljs.core.first((state_71329[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71370 = state_71329;
state_71329 = G__71370;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_71329){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_71329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71354 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71354[(6)] = c__2749__auto__);

return statearr_71354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71408){
var state_val_71409 = (state_71408[(1)]);
if((state_val_71409 === (7))){
var state_71408__$1 = state_71408;
var statearr_71410_71434 = state_71408__$1;
(statearr_71410_71434[(2)] = n);

(statearr_71410_71434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (1))){
var state_71408__$1 = state_71408;
var statearr_71411_71435 = state_71408__$1;
(statearr_71411_71435[(2)] = null);

(statearr_71411_71435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (4))){
var inst_71371 = (state_71408[(2)]);
var state_71408__$1 = state_71408;
var statearr_71412_71436 = state_71408__$1;
(statearr_71412_71436[(2)] = inst_71371);

(statearr_71412_71436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (13))){
var inst_71388 = (state_71408[(2)]);
var inst_71389 = fluree.db.util.async.throw_err(inst_71388);
var state_71408__$1 = state_71408;
var statearr_71413_71437 = state_71408__$1;
(statearr_71413_71437[(2)] = inst_71389);

(statearr_71413_71437[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (6))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(9),n);
} else {
if((state_val_71409 === (3))){
var inst_71406 = (state_71408[(2)]);
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71408__$1,inst_71406);
} else {
if((state_val_71409 === (12))){
var inst_71384 = (state_71408[(7)]);
var inst_71392 = (state_71408[(2)]);
var inst_71393 = fluree.db.dbfunctions.internal.mod(inst_71384,inst_71392);
var inst_71394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71395 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71397 = [inst_71384,inst_71392];
var inst_71398 = (new cljs.core.PersistentVector(null,2,(5),inst_71396,inst_71397,null));
var inst_71399 = ["mod",inst_71398,inst_71393];
var inst_71400 = cljs.core.PersistentHashMap.fromArrays(inst_71395,inst_71399);
var inst_71401 = [inst_71400,(2)];
var inst_71402 = (new cljs.core.PersistentVector(null,2,(5),inst_71394,inst_71401,null));
var inst_71403 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71402);
var _ = (function (){var statearr_71414 = state_71408;
(statearr_71414[(4)] = cljs.core.rest((state_71408[(4)])));

return statearr_71414;
})();
var state_71408__$1 = (function (){var statearr_71415 = state_71408;
(statearr_71415[(8)] = inst_71403);

return statearr_71415;
})();
var statearr_71416_71438 = state_71408__$1;
(statearr_71416_71438[(2)] = inst_71393);

(statearr_71416_71438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (2))){
var _ = (function (){var statearr_71417 = state_71408;
(statearr_71417[(4)] = cljs.core.cons((5),(state_71408[(4)])));

return statearr_71417;
})();
var inst_71377 = fluree.db.util.async.channel_QMARK_(n);
var state_71408__$1 = state_71408;
if(inst_71377){
var statearr_71418_71439 = state_71408__$1;
(statearr_71418_71439[(1)] = (6));

} else {
var statearr_71419_71440 = state_71408__$1;
(statearr_71419_71440[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (11))){
var state_71408__$1 = state_71408;
var statearr_71421_71441 = state_71408__$1;
(statearr_71421_71441[(2)] = d);

(statearr_71421_71441[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (9))){
var inst_71380 = (state_71408[(2)]);
var inst_71381 = fluree.db.util.async.throw_err(inst_71380);
var state_71408__$1 = state_71408;
var statearr_71422_71442 = state_71408__$1;
(statearr_71422_71442[(2)] = inst_71381);

(statearr_71422_71442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (5))){
var _ = (function (){var statearr_71423 = state_71408;
(statearr_71423[(4)] = cljs.core.rest((state_71408[(4)])));

return statearr_71423;
})();
var state_71408__$1 = state_71408;
var ex71420 = (state_71408__$1[(2)]);
var statearr_71424_71443 = state_71408__$1;
(statearr_71424_71443[(5)] = ex71420);


if((ex71420 instanceof Error)){
var statearr_71425_71444 = state_71408__$1;
(statearr_71425_71444[(1)] = (4));

(statearr_71425_71444[(5)] = null);

} else {
throw ex71420;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71409 === (10))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(13),d);
} else {
if((state_val_71409 === (8))){
var inst_71384 = (state_71408[(2)]);
var inst_71385 = fluree.db.util.async.channel_QMARK_(d);
var state_71408__$1 = (function (){var statearr_71426 = state_71408;
(statearr_71426[(7)] = inst_71384);

return statearr_71426;
})();
if(inst_71385){
var statearr_71427_71445 = state_71408__$1;
(statearr_71427_71445[(1)] = (10));

} else {
var statearr_71428_71446 = state_71408__$1;
(statearr_71428_71446[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_71429 = [null,null,null,null,null,null,null,null,null];
(statearr_71429[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_71429[(1)] = (1));

return statearr_71429;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_71408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71430){var ex__2730__auto__ = e71430;
var statearr_71431_71447 = state_71408;
(statearr_71431_71447[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71408[(4)]))){
var statearr_71432_71448 = state_71408;
(statearr_71432_71448[(1)] = cljs.core.first((state_71408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71449 = state_71408;
state_71408 = G__71449;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_71408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_71408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71433 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71433[(6)] = c__2749__auto__);

return statearr_71433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71487){
var state_val_71488 = (state_71487[(1)]);
if((state_val_71488 === (7))){
var state_71487__$1 = state_71487;
var statearr_71489_71513 = state_71487__$1;
(statearr_71489_71513[(2)] = n);

(statearr_71489_71513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (1))){
var state_71487__$1 = state_71487;
var statearr_71490_71514 = state_71487__$1;
(statearr_71490_71514[(2)] = null);

(statearr_71490_71514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (4))){
var inst_71450 = (state_71487[(2)]);
var state_71487__$1 = state_71487;
var statearr_71491_71515 = state_71487__$1;
(statearr_71491_71515[(2)] = inst_71450);

(statearr_71491_71515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (13))){
var inst_71467 = (state_71487[(2)]);
var inst_71468 = fluree.db.util.async.throw_err(inst_71467);
var state_71487__$1 = state_71487;
var statearr_71492_71516 = state_71487__$1;
(statearr_71492_71516[(2)] = inst_71468);

(statearr_71492_71516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (6))){
var state_71487__$1 = state_71487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71487__$1,(9),n);
} else {
if((state_val_71488 === (3))){
var inst_71485 = (state_71487[(2)]);
var state_71487__$1 = state_71487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71487__$1,inst_71485);
} else {
if((state_val_71488 === (12))){
var inst_71463 = (state_71487[(7)]);
var inst_71471 = (state_71487[(2)]);
var inst_71472 = fluree.db.dbfunctions.internal.rem(inst_71463,inst_71471);
var inst_71473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71474 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71476 = [inst_71463,inst_71471];
var inst_71477 = (new cljs.core.PersistentVector(null,2,(5),inst_71475,inst_71476,null));
var inst_71478 = ["rem",inst_71477,inst_71472];
var inst_71479 = cljs.core.PersistentHashMap.fromArrays(inst_71474,inst_71478);
var inst_71480 = [inst_71479,(2)];
var inst_71481 = (new cljs.core.PersistentVector(null,2,(5),inst_71473,inst_71480,null));
var inst_71482 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71481);
var _ = (function (){var statearr_71493 = state_71487;
(statearr_71493[(4)] = cljs.core.rest((state_71487[(4)])));

return statearr_71493;
})();
var state_71487__$1 = (function (){var statearr_71494 = state_71487;
(statearr_71494[(8)] = inst_71482);

return statearr_71494;
})();
var statearr_71495_71517 = state_71487__$1;
(statearr_71495_71517[(2)] = inst_71472);

(statearr_71495_71517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (2))){
var _ = (function (){var statearr_71496 = state_71487;
(statearr_71496[(4)] = cljs.core.cons((5),(state_71487[(4)])));

return statearr_71496;
})();
var inst_71456 = fluree.db.util.async.channel_QMARK_(n);
var state_71487__$1 = state_71487;
if(inst_71456){
var statearr_71497_71518 = state_71487__$1;
(statearr_71497_71518[(1)] = (6));

} else {
var statearr_71498_71519 = state_71487__$1;
(statearr_71498_71519[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (11))){
var state_71487__$1 = state_71487;
var statearr_71500_71520 = state_71487__$1;
(statearr_71500_71520[(2)] = d);

(statearr_71500_71520[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (9))){
var inst_71459 = (state_71487[(2)]);
var inst_71460 = fluree.db.util.async.throw_err(inst_71459);
var state_71487__$1 = state_71487;
var statearr_71501_71521 = state_71487__$1;
(statearr_71501_71521[(2)] = inst_71460);

(statearr_71501_71521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (5))){
var _ = (function (){var statearr_71502 = state_71487;
(statearr_71502[(4)] = cljs.core.rest((state_71487[(4)])));

return statearr_71502;
})();
var state_71487__$1 = state_71487;
var ex71499 = (state_71487__$1[(2)]);
var statearr_71503_71522 = state_71487__$1;
(statearr_71503_71522[(5)] = ex71499);


if((ex71499 instanceof Error)){
var statearr_71504_71523 = state_71487__$1;
(statearr_71504_71523[(1)] = (4));

(statearr_71504_71523[(5)] = null);

} else {
throw ex71499;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71488 === (10))){
var state_71487__$1 = state_71487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71487__$1,(13),d);
} else {
if((state_val_71488 === (8))){
var inst_71463 = (state_71487[(2)]);
var inst_71464 = fluree.db.util.async.channel_QMARK_(d);
var state_71487__$1 = (function (){var statearr_71505 = state_71487;
(statearr_71505[(7)] = inst_71463);

return statearr_71505;
})();
if(inst_71464){
var statearr_71506_71524 = state_71487__$1;
(statearr_71506_71524[(1)] = (10));

} else {
var statearr_71507_71525 = state_71487__$1;
(statearr_71507_71525[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_71508 = [null,null,null,null,null,null,null,null,null];
(statearr_71508[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_71508[(1)] = (1));

return statearr_71508;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_71487){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71487);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71509){var ex__2730__auto__ = e71509;
var statearr_71510_71526 = state_71487;
(statearr_71510_71526[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71487[(4)]))){
var statearr_71511_71527 = state_71487;
(statearr_71511_71527[(1)] = cljs.core.first((state_71487[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71528 = state_71487;
state_71487 = G__71528;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_71487){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_71487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71512 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71512[(6)] = c__2749__auto__);

return statearr_71512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71555){
var state_val_71556 = (state_71555[(1)]);
if((state_val_71556 === (7))){
var state_71555__$1 = state_71555;
var statearr_71557_71576 = state_71555__$1;
(statearr_71557_71576[(2)] = x);

(statearr_71557_71576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71556 === (1))){
var state_71555__$1 = state_71555;
var statearr_71558_71577 = state_71555__$1;
(statearr_71558_71577[(2)] = null);

(statearr_71558_71577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71556 === (4))){
var inst_71529 = (state_71555[(2)]);
var state_71555__$1 = state_71555;
var statearr_71559_71578 = state_71555__$1;
(statearr_71559_71578[(2)] = inst_71529);

(statearr_71559_71578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71556 === (6))){
var state_71555__$1 = state_71555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71555__$1,(9),x);
} else {
if((state_val_71556 === (3))){
var inst_71553 = (state_71555[(2)]);
var state_71555__$1 = state_71555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71555__$1,inst_71553);
} else {
if((state_val_71556 === (2))){
var _ = (function (){var statearr_71561 = state_71555;
(statearr_71561[(4)] = cljs.core.cons((5),(state_71555[(4)])));

return statearr_71561;
})();
var inst_71535 = fluree.db.util.async.channel_QMARK_(x);
var state_71555__$1 = state_71555;
if(inst_71535){
var statearr_71562_71579 = state_71555__$1;
(statearr_71562_71579[(1)] = (6));

} else {
var statearr_71563_71580 = state_71555__$1;
(statearr_71563_71580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71556 === (9))){
var inst_71538 = (state_71555[(2)]);
var inst_71539 = fluree.db.util.async.throw_err(inst_71538);
var state_71555__$1 = state_71555;
var statearr_71564_71581 = state_71555__$1;
(statearr_71564_71581[(2)] = inst_71539);

(statearr_71564_71581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71556 === (5))){
var _ = (function (){var statearr_71565 = state_71555;
(statearr_71565[(4)] = cljs.core.rest((state_71555[(4)])));

return statearr_71565;
})();
var state_71555__$1 = state_71555;
var ex71560 = (state_71555__$1[(2)]);
var statearr_71566_71582 = state_71555__$1;
(statearr_71566_71582[(5)] = ex71560);


if((ex71560 instanceof Error)){
var statearr_71567_71583 = state_71555__$1;
(statearr_71567_71583[(1)] = (4));

(statearr_71567_71583[(5)] = null);

} else {
throw ex71560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71556 === (8))){
var inst_71542 = (state_71555[(2)]);
var inst_71543 = fluree.db.dbfunctions.internal.boolean$(inst_71542);
var inst_71544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71545 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71546 = ["boolean",inst_71542,inst_71543];
var inst_71547 = cljs.core.PersistentHashMap.fromArrays(inst_71545,inst_71546);
var inst_71548 = [inst_71547,(10)];
var inst_71549 = (new cljs.core.PersistentVector(null,2,(5),inst_71544,inst_71548,null));
var inst_71550 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71549);
var _ = (function (){var statearr_71568 = state_71555;
(statearr_71568[(4)] = cljs.core.rest((state_71555[(4)])));

return statearr_71568;
})();
var state_71555__$1 = (function (){var statearr_71569 = state_71555;
(statearr_71569[(7)] = inst_71550);

return statearr_71569;
})();
var statearr_71570_71584 = state_71555__$1;
(statearr_71570_71584[(2)] = inst_71543);

(statearr_71570_71584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_71571 = [null,null,null,null,null,null,null,null];
(statearr_71571[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_71571[(1)] = (1));

return statearr_71571;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_71555){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71555);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71572){var ex__2730__auto__ = e71572;
var statearr_71573_71585 = state_71555;
(statearr_71573_71585[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71555[(4)]))){
var statearr_71574_71586 = state_71555;
(statearr_71574_71586[(1)] = cljs.core.first((state_71555[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71587 = state_71555;
state_71555 = G__71587;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_71555){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_71555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71575 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71575[(6)] = c__2749__auto__);

return statearr_71575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71625){
var state_val_71626 = (state_71625[(1)]);
if((state_val_71626 === (7))){
var state_71625__$1 = state_71625;
var statearr_71627_71651 = state_71625__$1;
(statearr_71627_71651[(2)] = pattern);

(statearr_71627_71651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (1))){
var state_71625__$1 = state_71625;
var statearr_71628_71652 = state_71625__$1;
(statearr_71628_71652[(2)] = null);

(statearr_71628_71652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (4))){
var inst_71588 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
var statearr_71629_71653 = state_71625__$1;
(statearr_71629_71653[(2)] = inst_71588);

(statearr_71629_71653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (13))){
var inst_71605 = (state_71625[(2)]);
var inst_71606 = fluree.db.util.async.throw_err(inst_71605);
var state_71625__$1 = state_71625;
var statearr_71630_71654 = state_71625__$1;
(statearr_71630_71654[(2)] = inst_71606);

(statearr_71630_71654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (6))){
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71625__$1,(9),pattern);
} else {
if((state_val_71626 === (3))){
var inst_71623 = (state_71625[(2)]);
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71625__$1,inst_71623);
} else {
if((state_val_71626 === (12))){
var inst_71601 = (state_71625[(7)]);
var inst_71609 = (state_71625[(2)]);
var inst_71610 = fluree.db.dbfunctions.internal.re_find(inst_71601,inst_71609);
var inst_71611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71612 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71614 = [inst_71601,inst_71609];
var inst_71615 = (new cljs.core.PersistentVector(null,2,(5),inst_71613,inst_71614,null));
var inst_71616 = ["re-find",inst_71615,inst_71610];
var inst_71617 = cljs.core.PersistentHashMap.fromArrays(inst_71612,inst_71616);
var inst_71618 = [inst_71617,(10)];
var inst_71619 = (new cljs.core.PersistentVector(null,2,(5),inst_71611,inst_71618,null));
var inst_71620 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71619);
var _ = (function (){var statearr_71631 = state_71625;
(statearr_71631[(4)] = cljs.core.rest((state_71625[(4)])));

return statearr_71631;
})();
var state_71625__$1 = (function (){var statearr_71632 = state_71625;
(statearr_71632[(8)] = inst_71620);

return statearr_71632;
})();
var statearr_71633_71655 = state_71625__$1;
(statearr_71633_71655[(2)] = inst_71610);

(statearr_71633_71655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (2))){
var _ = (function (){var statearr_71634 = state_71625;
(statearr_71634[(4)] = cljs.core.cons((5),(state_71625[(4)])));

return statearr_71634;
})();
var inst_71594 = fluree.db.util.async.channel_QMARK_(pattern);
var state_71625__$1 = state_71625;
if(inst_71594){
var statearr_71635_71656 = state_71625__$1;
(statearr_71635_71656[(1)] = (6));

} else {
var statearr_71636_71657 = state_71625__$1;
(statearr_71636_71657[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (11))){
var state_71625__$1 = state_71625;
var statearr_71638_71658 = state_71625__$1;
(statearr_71638_71658[(2)] = string);

(statearr_71638_71658[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (9))){
var inst_71597 = (state_71625[(2)]);
var inst_71598 = fluree.db.util.async.throw_err(inst_71597);
var state_71625__$1 = state_71625;
var statearr_71639_71659 = state_71625__$1;
(statearr_71639_71659[(2)] = inst_71598);

(statearr_71639_71659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (5))){
var _ = (function (){var statearr_71640 = state_71625;
(statearr_71640[(4)] = cljs.core.rest((state_71625[(4)])));

return statearr_71640;
})();
var state_71625__$1 = state_71625;
var ex71637 = (state_71625__$1[(2)]);
var statearr_71641_71660 = state_71625__$1;
(statearr_71641_71660[(5)] = ex71637);


if((ex71637 instanceof Error)){
var statearr_71642_71661 = state_71625__$1;
(statearr_71642_71661[(1)] = (4));

(statearr_71642_71661[(5)] = null);

} else {
throw ex71637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71626 === (10))){
var state_71625__$1 = state_71625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71625__$1,(13),string);
} else {
if((state_val_71626 === (8))){
var inst_71601 = (state_71625[(2)]);
var inst_71602 = fluree.db.util.async.channel_QMARK_(string);
var state_71625__$1 = (function (){var statearr_71643 = state_71625;
(statearr_71643[(7)] = inst_71601);

return statearr_71643;
})();
if(inst_71602){
var statearr_71644_71662 = state_71625__$1;
(statearr_71644_71662[(1)] = (10));

} else {
var statearr_71645_71663 = state_71625__$1;
(statearr_71645_71663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_71646 = [null,null,null,null,null,null,null,null,null];
(statearr_71646[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_71646[(1)] = (1));

return statearr_71646;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_71625){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71625);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71647){var ex__2730__auto__ = e71647;
var statearr_71648_71664 = state_71625;
(statearr_71648_71664[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71625[(4)]))){
var statearr_71649_71665 = state_71625;
(statearr_71649_71665[(1)] = cljs.core.first((state_71625[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71666 = state_71625;
state_71625 = G__71666;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_71625){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_71625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71650 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71650[(6)] = c__2749__auto__);

return statearr_71650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71693){
var state_val_71694 = (state_71693[(1)]);
if((state_val_71694 === (7))){
var state_71693__$1 = state_71693;
var statearr_71695_71714 = state_71693__$1;
(statearr_71695_71714[(2)] = email);

(statearr_71695_71714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71694 === (1))){
var state_71693__$1 = state_71693;
var statearr_71696_71715 = state_71693__$1;
(statearr_71696_71715[(2)] = null);

(statearr_71696_71715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71694 === (4))){
var inst_71667 = (state_71693[(2)]);
var state_71693__$1 = state_71693;
var statearr_71697_71716 = state_71693__$1;
(statearr_71697_71716[(2)] = inst_71667);

(statearr_71697_71716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71694 === (6))){
var state_71693__$1 = state_71693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71693__$1,(9),email);
} else {
if((state_val_71694 === (3))){
var inst_71691 = (state_71693[(2)]);
var state_71693__$1 = state_71693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71693__$1,inst_71691);
} else {
if((state_val_71694 === (2))){
var _ = (function (){var statearr_71699 = state_71693;
(statearr_71699[(4)] = cljs.core.cons((5),(state_71693[(4)])));

return statearr_71699;
})();
var inst_71673 = fluree.db.util.async.channel_QMARK_(email);
var state_71693__$1 = state_71693;
if(inst_71673){
var statearr_71700_71717 = state_71693__$1;
(statearr_71700_71717[(1)] = (6));

} else {
var statearr_71701_71718 = state_71693__$1;
(statearr_71701_71718[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71694 === (9))){
var inst_71676 = (state_71693[(2)]);
var inst_71677 = fluree.db.util.async.throw_err(inst_71676);
var state_71693__$1 = state_71693;
var statearr_71702_71719 = state_71693__$1;
(statearr_71702_71719[(2)] = inst_71677);

(statearr_71702_71719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71694 === (5))){
var _ = (function (){var statearr_71703 = state_71693;
(statearr_71703[(4)] = cljs.core.rest((state_71693[(4)])));

return statearr_71703;
})();
var state_71693__$1 = state_71693;
var ex71698 = (state_71693__$1[(2)]);
var statearr_71704_71720 = state_71693__$1;
(statearr_71704_71720[(5)] = ex71698);


if((ex71698 instanceof Error)){
var statearr_71705_71721 = state_71693__$1;
(statearr_71705_71721[(1)] = (4));

(statearr_71705_71721[(5)] = null);

} else {
throw ex71698;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71694 === (8))){
var inst_71680 = (state_71693[(2)]);
var inst_71681 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_71680);
var inst_71682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71683 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71684 = ["re-find",inst_71680,inst_71681];
var inst_71685 = cljs.core.PersistentHashMap.fromArrays(inst_71683,inst_71684);
var inst_71686 = [inst_71685,(10)];
var inst_71687 = (new cljs.core.PersistentVector(null,2,(5),inst_71682,inst_71686,null));
var inst_71688 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71687);
var _ = (function (){var statearr_71706 = state_71693;
(statearr_71706[(4)] = cljs.core.rest((state_71693[(4)])));

return statearr_71706;
})();
var state_71693__$1 = (function (){var statearr_71707 = state_71693;
(statearr_71707[(7)] = inst_71688);

return statearr_71707;
})();
var statearr_71708_71722 = state_71693__$1;
(statearr_71708_71722[(2)] = inst_71681);

(statearr_71708_71722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_71709 = [null,null,null,null,null,null,null,null];
(statearr_71709[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_71709[(1)] = (1));

return statearr_71709;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_71693){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71693);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71710){var ex__2730__auto__ = e71710;
var statearr_71711_71723 = state_71693;
(statearr_71711_71723[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71693[(4)]))){
var statearr_71712_71724 = state_71693;
(statearr_71712_71724[(1)] = cljs.core.first((state_71693[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71725 = state_71693;
state_71693 = G__71725;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_71693){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_71693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71713 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71713[(6)] = c__2749__auto__);

return statearr_71713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71772){
var state_val_71773 = (state_71772[(1)]);
if((state_val_71773 === (7))){
var inst_71742 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71772__$1 = state_71772;
if(cljs.core.truth_(inst_71742)){
var statearr_71774_71801 = state_71772__$1;
(statearr_71774_71801[(1)] = (9));

} else {
var statearr_71775_71802 = state_71772__$1;
(statearr_71775_71802[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (1))){
var state_71772__$1 = state_71772;
var statearr_71776_71803 = state_71772__$1;
(statearr_71776_71803[(2)] = null);

(statearr_71776_71803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (4))){
var inst_71726 = (state_71772[(2)]);
var state_71772__$1 = state_71772;
var statearr_71777_71804 = state_71772__$1;
(statearr_71777_71804[(2)] = inst_71726);

(statearr_71777_71804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (15))){
var inst_71753 = (state_71772[(2)]);
var state_71772__$1 = state_71772;
var statearr_71778_71805 = state_71772__$1;
(statearr_71778_71805[(2)] = inst_71753);

(statearr_71778_71805[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (13))){
var inst_71750 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_71772__$1 = state_71772;
var statearr_71779_71806 = state_71772__$1;
(statearr_71779_71806[(2)] = inst_71750);

(statearr_71779_71806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (6))){
var inst_71737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71738 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71739 = [inst_71738,(0)];
var inst_71740 = (new cljs.core.PersistentVector(null,2,(5),inst_71737,inst_71739,null));
var state_71772__$1 = state_71772;
var statearr_71780_71807 = state_71772__$1;
(statearr_71780_71807[(2)] = inst_71740);

(statearr_71780_71807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (3))){
var inst_71770 = (state_71772[(2)]);
var state_71772__$1 = state_71772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71772__$1,inst_71770);
} else {
if((state_val_71773 === (12))){
var inst_71746 = (state_71772[(2)]);
var inst_71747 = fluree.db.util.async.throw_err(inst_71746);
var state_71772__$1 = state_71772;
var statearr_71781_71808 = state_71772__$1;
(statearr_71781_71808[(2)] = inst_71747);

(statearr_71781_71808[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (2))){
var _ = (function (){var statearr_71782 = state_71772;
(statearr_71782[(4)] = cljs.core.cons((5),(state_71772[(4)])));

return statearr_71782;
})();
var inst_71735 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71772__$1 = state_71772;
if(cljs.core.truth_(inst_71735)){
var statearr_71783_71809 = state_71772__$1;
(statearr_71783_71809[(1)] = (6));

} else {
var statearr_71784_71810 = state_71772__$1;
(statearr_71784_71810[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (11))){
var inst_71755 = (state_71772[(2)]);
var state_71772__$1 = state_71772;
var statearr_71786_71811 = state_71772__$1;
(statearr_71786_71811[(2)] = inst_71755);

(statearr_71786_71811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (9))){
var inst_71744 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_71772__$1 = state_71772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71772__$1,(12),inst_71744);
} else {
if((state_val_71773 === (5))){
var _ = (function (){var statearr_71787 = state_71772;
(statearr_71787[(4)] = cljs.core.rest((state_71772[(4)])));

return statearr_71787;
})();
var state_71772__$1 = state_71772;
var ex71785 = (state_71772__$1[(2)]);
var statearr_71788_71812 = state_71772__$1;
(statearr_71788_71812[(5)] = ex71785);


if((ex71785 instanceof Error)){
var statearr_71789_71813 = state_71772__$1;
(statearr_71789_71813[(1)] = (4));

(statearr_71789_71813[(5)] = null);

} else {
throw ex71785;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (14))){
var state_71772__$1 = state_71772;
var statearr_71790_71814 = state_71772__$1;
(statearr_71790_71814[(2)] = null);

(statearr_71790_71814[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (10))){
var state_71772__$1 = state_71772;
var statearr_71791_71815 = state_71772__$1;
(statearr_71791_71815[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71773 === (8))){
var inst_71757 = (state_71772[(2)]);
var inst_71758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71757,(0),null);
var inst_71759 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71757,(1),null);
var inst_71760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71761 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71762 = ["?user_id","?ctx",inst_71758];
var inst_71763 = cljs.core.PersistentHashMap.fromArrays(inst_71761,inst_71762);
var inst_71764 = ((10) + inst_71759);
var inst_71765 = [inst_71763,inst_71764];
var inst_71766 = (new cljs.core.PersistentVector(null,2,(5),inst_71760,inst_71765,null));
var inst_71767 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71766);
var _ = (function (){var statearr_71793 = state_71772;
(statearr_71793[(4)] = cljs.core.rest((state_71772[(4)])));

return statearr_71793;
})();
var state_71772__$1 = (function (){var statearr_71794 = state_71772;
(statearr_71794[(7)] = inst_71767);

return statearr_71794;
})();
var statearr_71795_71816 = state_71772__$1;
(statearr_71795_71816[(2)] = inst_71758);

(statearr_71795_71816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_71796 = [null,null,null,null,null,null,null,null];
(statearr_71796[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_71796[(1)] = (1));

return statearr_71796;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_71772){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71772);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71797){var ex__2730__auto__ = e71797;
var statearr_71798_71817 = state_71772;
(statearr_71798_71817[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71772[(4)]))){
var statearr_71799_71818 = state_71772;
(statearr_71799_71818[(1)] = cljs.core.first((state_71772[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71819 = state_71772;
state_71772 = G__71819;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_71772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_71772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71800 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71800[(6)] = c__2749__auto__);

return statearr_71800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71847){
var state_val_71848 = (state_71847[(1)]);
if((state_val_71848 === (7))){
var inst_71840 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_71847__$1 = state_71847;
var statearr_71849_71868 = state_71847__$1;
(statearr_71849_71868[(2)] = inst_71840);

(statearr_71849_71868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71848 === (1))){
var state_71847__$1 = state_71847;
var statearr_71850_71869 = state_71847__$1;
(statearr_71850_71869[(2)] = null);

(statearr_71850_71869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71848 === (4))){
var inst_71820 = (state_71847[(2)]);
var state_71847__$1 = state_71847;
var statearr_71851_71870 = state_71847__$1;
(statearr_71851_71870[(2)] = inst_71820);

(statearr_71851_71870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71848 === (6))){
var inst_71828 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_71847__$1 = state_71847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71847__$1,(9),inst_71828);
} else {
if((state_val_71848 === (3))){
var inst_71845 = (state_71847[(2)]);
var state_71847__$1 = state_71847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71847__$1,inst_71845);
} else {
if((state_val_71848 === (2))){
var _ = (function (){var statearr_71853 = state_71847;
(statearr_71853[(4)] = cljs.core.cons((5),(state_71847[(4)])));

return statearr_71853;
})();
var inst_71826 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71847__$1 = state_71847;
if(cljs.core.truth_(inst_71826)){
var statearr_71854_71871 = state_71847__$1;
(statearr_71854_71871[(1)] = (6));

} else {
var statearr_71855_71872 = state_71847__$1;
(statearr_71855_71872[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71848 === (9))){
var inst_71830 = (state_71847[(2)]);
var inst_71831 = fluree.db.util.async.throw_err(inst_71830);
var inst_71832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71833 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71834 = ["?auth_id","?ctx",inst_71831];
var inst_71835 = cljs.core.PersistentHashMap.fromArrays(inst_71833,inst_71834);
var inst_71836 = [inst_71835,(10)];
var inst_71837 = (new cljs.core.PersistentVector(null,2,(5),inst_71832,inst_71836,null));
var inst_71838 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71837);
var state_71847__$1 = (function (){var statearr_71856 = state_71847;
(statearr_71856[(7)] = inst_71838);

return statearr_71856;
})();
var statearr_71857_71873 = state_71847__$1;
(statearr_71857_71873[(2)] = inst_71831);

(statearr_71857_71873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71848 === (5))){
var _ = (function (){var statearr_71858 = state_71847;
(statearr_71858[(4)] = cljs.core.rest((state_71847[(4)])));

return statearr_71858;
})();
var state_71847__$1 = state_71847;
var ex71852 = (state_71847__$1[(2)]);
var statearr_71859_71874 = state_71847__$1;
(statearr_71859_71874[(5)] = ex71852);


if((ex71852 instanceof Error)){
var statearr_71860_71875 = state_71847__$1;
(statearr_71860_71875[(1)] = (4));

(statearr_71860_71875[(5)] = null);

} else {
throw ex71852;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71848 === (8))){
var inst_71842 = (state_71847[(2)]);
var _ = (function (){var statearr_71861 = state_71847;
(statearr_71861[(4)] = cljs.core.rest((state_71847[(4)])));

return statearr_71861;
})();
var state_71847__$1 = state_71847;
var statearr_71862_71876 = state_71847__$1;
(statearr_71862_71876[(2)] = inst_71842);

(statearr_71862_71876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_71863 = [null,null,null,null,null,null,null,null];
(statearr_71863[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_71863[(1)] = (1));

return statearr_71863;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_71847){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71847);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71864){var ex__2730__auto__ = e71864;
var statearr_71865_71877 = state_71847;
(statearr_71865_71877[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71847[(4)]))){
var statearr_71866_71878 = state_71847;
(statearr_71866_71878[(1)] = cljs.core.first((state_71847[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71879 = state_71847;
state_71847 = G__71879;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_71847){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_71847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71867 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71867[(6)] = c__2749__auto__);

return statearr_71867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__71881 = arguments.length;
switch (G__71881) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71923){
var state_val_71924 = (state_71923[(1)]);
if((state_val_71924 === (7))){
var state_71923__$1 = state_71923;
var statearr_71925_71955 = state_71923__$1;
(statearr_71925_71955[(2)] = seed);

(statearr_71925_71955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (1))){
var state_71923__$1 = state_71923;
var statearr_71926_71956 = state_71923__$1;
(statearr_71926_71956[(2)] = null);

(statearr_71926_71956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (4))){
var inst_71882 = (state_71923[(2)]);
var state_71923__$1 = state_71923;
var statearr_71927_71957 = state_71923__$1;
(statearr_71927_71957[(2)] = inst_71882);

(statearr_71927_71957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (15))){
var state_71923__$1 = state_71923;
var statearr_71928_71958 = state_71923__$1;
(statearr_71928_71958[(2)] = (10));

(statearr_71928_71958[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (13))){
var inst_71899 = (state_71923[(2)]);
var inst_71900 = fluree.db.util.async.throw_err(inst_71899);
var state_71923__$1 = state_71923;
var statearr_71929_71959 = state_71923__$1;
(statearr_71929_71959[(2)] = inst_71900);

(statearr_71929_71959[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (6))){
var state_71923__$1 = state_71923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71923__$1,(9),seed);
} else {
if((state_val_71924 === (3))){
var inst_71921 = (state_71923[(2)]);
var state_71923__$1 = state_71923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71923__$1,inst_71921);
} else {
if((state_val_71924 === (12))){
var inst_71903 = (state_71923[(7)]);
var inst_71903__$1 = (state_71923[(2)]);
var state_71923__$1 = (function (){var statearr_71930 = state_71923;
(statearr_71930[(7)] = inst_71903__$1);

return statearr_71930;
})();
if(cljs.core.truth_(inst_71903__$1)){
var statearr_71931_71960 = state_71923__$1;
(statearr_71931_71960[(1)] = (14));

} else {
var statearr_71932_71961 = state_71923__$1;
(statearr_71932_71961[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (2))){
var _ = (function (){var statearr_71933 = state_71923;
(statearr_71933[(4)] = cljs.core.cons((5),(state_71923[(4)])));

return statearr_71933;
})();
var inst_71888 = fluree.db.util.async.channel_QMARK_(seed);
var state_71923__$1 = state_71923;
if(inst_71888){
var statearr_71934_71962 = state_71923__$1;
(statearr_71934_71962[(1)] = (6));

} else {
var statearr_71935_71963 = state_71923__$1;
(statearr_71935_71963[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (11))){
var state_71923__$1 = state_71923;
var statearr_71937_71964 = state_71923__$1;
(statearr_71937_71964[(2)] = max);

(statearr_71937_71964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (9))){
var inst_71891 = (state_71923[(2)]);
var inst_71892 = fluree.db.util.async.throw_err(inst_71891);
var state_71923__$1 = state_71923;
var statearr_71938_71965 = state_71923__$1;
(statearr_71938_71965[(2)] = inst_71892);

(statearr_71938_71965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (5))){
var _ = (function (){var statearr_71939 = state_71923;
(statearr_71939[(4)] = cljs.core.rest((state_71923[(4)])));

return statearr_71939;
})();
var state_71923__$1 = state_71923;
var ex71936 = (state_71923__$1[(2)]);
var statearr_71940_71966 = state_71923__$1;
(statearr_71940_71966[(5)] = ex71936);


if((ex71936 instanceof Error)){
var statearr_71941_71967 = state_71923__$1;
(statearr_71941_71967[(1)] = (4));

(statearr_71941_71967[(5)] = null);

} else {
throw ex71936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (14))){
var inst_71903 = (state_71923[(7)]);
var state_71923__$1 = state_71923;
var statearr_71942_71968 = state_71923__$1;
(statearr_71942_71968[(2)] = inst_71903);

(statearr_71942_71968[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (16))){
var inst_71895 = (state_71923[(8)]);
var inst_71907 = (state_71923[(2)]);
var inst_71908 = fluree.db.dbfunctions.internal.rand(inst_71895,inst_71907);
var inst_71909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71910 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71912 = [max,seed];
var inst_71913 = (new cljs.core.PersistentVector(null,2,(5),inst_71911,inst_71912,null));
var inst_71914 = ["rand",inst_71913,inst_71908];
var inst_71915 = cljs.core.PersistentHashMap.fromArrays(inst_71910,inst_71914);
var inst_71916 = [inst_71915,(10)];
var inst_71917 = (new cljs.core.PersistentVector(null,2,(5),inst_71909,inst_71916,null));
var inst_71918 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71917);
var _ = (function (){var statearr_71943 = state_71923;
(statearr_71943[(4)] = cljs.core.rest((state_71923[(4)])));

return statearr_71943;
})();
var state_71923__$1 = (function (){var statearr_71944 = state_71923;
(statearr_71944[(9)] = inst_71918);

return statearr_71944;
})();
var statearr_71945_71969 = state_71923__$1;
(statearr_71945_71969[(2)] = inst_71908);

(statearr_71945_71969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71924 === (10))){
var state_71923__$1 = state_71923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71923__$1,(13),max);
} else {
if((state_val_71924 === (8))){
var inst_71895 = (state_71923[(2)]);
var inst_71896 = fluree.db.util.async.channel_QMARK_(max);
var state_71923__$1 = (function (){var statearr_71946 = state_71923;
(statearr_71946[(8)] = inst_71895);

return statearr_71946;
})();
if(inst_71896){
var statearr_71947_71970 = state_71923__$1;
(statearr_71947_71970[(1)] = (10));

} else {
var statearr_71948_71971 = state_71923__$1;
(statearr_71948_71971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_71949 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71949[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_71949[(1)] = (1));

return statearr_71949;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_71923){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71923);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71950){var ex__2730__auto__ = e71950;
var statearr_71951_71972 = state_71923;
(statearr_71951_71972[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71923[(4)]))){
var statearr_71952_71973 = state_71923;
(statearr_71952_71973[(1)] = cljs.core.first((state_71923[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71974 = state_71923;
state_71923 = G__71974;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_71923){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_71923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71953 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71953[(6)] = c__2749__auto__);

return statearr_71953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71995){
var state_val_71996 = (state_71995[(1)]);
if((state_val_71996 === (1))){
var state_71995__$1 = state_71995;
var statearr_71997_72012 = state_71995__$1;
(statearr_71997_72012[(2)] = null);

(statearr_71997_72012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71996 === (2))){
var _ = (function (){var statearr_71998 = state_71995;
(statearr_71998[(4)] = cljs.core.cons((5),(state_71995[(4)])));

return statearr_71998;
})();
var inst_71981 = cljs.core.random_uuid();
var inst_71982 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71981);
var inst_71983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71984 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71985 = cljs.core.PersistentVector.EMPTY;
var inst_71986 = ["uuid",inst_71985,inst_71982];
var inst_71987 = cljs.core.PersistentHashMap.fromArrays(inst_71984,inst_71986);
var inst_71988 = [inst_71987,(10)];
var inst_71989 = (new cljs.core.PersistentVector(null,2,(5),inst_71983,inst_71988,null));
var inst_71990 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71989);
var ___$1 = (function (){var statearr_71999 = state_71995;
(statearr_71999[(4)] = cljs.core.rest((state_71995[(4)])));

return statearr_71999;
})();
var state_71995__$1 = (function (){var statearr_72000 = state_71995;
(statearr_72000[(7)] = inst_71990);

return statearr_72000;
})();
var statearr_72001_72013 = state_71995__$1;
(statearr_72001_72013[(2)] = inst_71982);

(statearr_72001_72013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71996 === (3))){
var inst_71993 = (state_71995[(2)]);
var state_71995__$1 = state_71995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71995__$1,inst_71993);
} else {
if((state_val_71996 === (4))){
var inst_71975 = (state_71995[(2)]);
var state_71995__$1 = state_71995;
var statearr_72003_72014 = state_71995__$1;
(statearr_72003_72014[(2)] = inst_71975);

(statearr_72003_72014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71996 === (5))){
var _ = (function (){var statearr_72004 = state_71995;
(statearr_72004[(4)] = cljs.core.rest((state_71995[(4)])));

return statearr_72004;
})();
var state_71995__$1 = state_71995;
var ex72002 = (state_71995__$1[(2)]);
var statearr_72005_72015 = state_71995__$1;
(statearr_72005_72015[(5)] = ex72002);


if((ex72002 instanceof Error)){
var statearr_72006_72016 = state_71995__$1;
(statearr_72006_72016[(1)] = (4));

(statearr_72006_72016[(5)] = null);

} else {
throw ex72002;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_72007 = [null,null,null,null,null,null,null,null];
(statearr_72007[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_72007[(1)] = (1));

return statearr_72007;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_71995){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71995);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72008){var ex__2730__auto__ = e72008;
var statearr_72009_72017 = state_71995;
(statearr_72009_72017[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71995[(4)]))){
var statearr_72010_72018 = state_71995;
(statearr_72010_72018[(1)] = cljs.core.first((state_71995[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72019 = state_71995;
state_71995 = G__72019;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_71995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_71995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72011 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72011[(6)] = c__2749__auto__);

return statearr_72011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72049){
var state_val_72050 = (state_72049[(1)]);
if((state_val_72050 === (7))){
var state_72049__$1 = state_72049;
var statearr_72051_72070 = state_72049__$1;
(statearr_72051_72070[(2)] = num);

(statearr_72051_72070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72050 === (1))){
var state_72049__$1 = state_72049;
var statearr_72052_72071 = state_72049__$1;
(statearr_72052_72071[(2)] = null);

(statearr_72052_72071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72050 === (4))){
var inst_72020 = (state_72049[(2)]);
var state_72049__$1 = state_72049;
var statearr_72053_72072 = state_72049__$1;
(statearr_72053_72072[(2)] = inst_72020);

(statearr_72053_72072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72050 === (6))){
var state_72049__$1 = state_72049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72049__$1,(9),num);
} else {
if((state_val_72050 === (3))){
var inst_72047 = (state_72049[(2)]);
var state_72049__$1 = state_72049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72049__$1,inst_72047);
} else {
if((state_val_72050 === (2))){
var _ = (function (){var statearr_72055 = state_72049;
(statearr_72055[(4)] = cljs.core.cons((5),(state_72049[(4)])));

return statearr_72055;
})();
var inst_72026 = fluree.db.util.async.channel_QMARK_(num);
var state_72049__$1 = state_72049;
if(inst_72026){
var statearr_72056_72073 = state_72049__$1;
(statearr_72056_72073[(1)] = (6));

} else {
var statearr_72057_72074 = state_72049__$1;
(statearr_72057_72074[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72050 === (9))){
var inst_72029 = (state_72049[(2)]);
var inst_72030 = fluree.db.util.async.throw_err(inst_72029);
var state_72049__$1 = state_72049;
var statearr_72058_72075 = state_72049__$1;
(statearr_72058_72075[(2)] = inst_72030);

(statearr_72058_72075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72050 === (5))){
var _ = (function (){var statearr_72059 = state_72049;
(statearr_72059[(4)] = cljs.core.rest((state_72049[(4)])));

return statearr_72059;
})();
var state_72049__$1 = state_72049;
var ex72054 = (state_72049__$1[(2)]);
var statearr_72060_72076 = state_72049__$1;
(statearr_72060_72076[(5)] = ex72054);


if((ex72054 instanceof Error)){
var statearr_72061_72077 = state_72049__$1;
(statearr_72061_72077[(1)] = (4));

(statearr_72061_72077[(5)] = null);

} else {
throw ex72054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72050 === (8))){
var inst_72033 = (state_72049[(2)]);
var inst_72034 = fluree.db.dbfunctions.internal.ceil(inst_72033);
var inst_72035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72036 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72038 = [fluree.db.dbfunctions.fns.ceil];
var inst_72039 = (new cljs.core.PersistentVector(null,1,(5),inst_72037,inst_72038,null));
var inst_72040 = ["",inst_72039,inst_72034];
var inst_72041 = cljs.core.PersistentHashMap.fromArrays(inst_72036,inst_72040);
var inst_72042 = [inst_72041,(10)];
var inst_72043 = (new cljs.core.PersistentVector(null,2,(5),inst_72035,inst_72042,null));
var inst_72044 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72043);
var _ = (function (){var statearr_72062 = state_72049;
(statearr_72062[(4)] = cljs.core.rest((state_72049[(4)])));

return statearr_72062;
})();
var state_72049__$1 = (function (){var statearr_72063 = state_72049;
(statearr_72063[(7)] = inst_72044);

return statearr_72063;
})();
var statearr_72064_72078 = state_72049__$1;
(statearr_72064_72078[(2)] = inst_72034);

(statearr_72064_72078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_72065 = [null,null,null,null,null,null,null,null];
(statearr_72065[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_72065[(1)] = (1));

return statearr_72065;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_72049){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72049);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72066){var ex__2730__auto__ = e72066;
var statearr_72067_72079 = state_72049;
(statearr_72067_72079[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72049[(4)]))){
var statearr_72068_72080 = state_72049;
(statearr_72068_72080[(1)] = cljs.core.first((state_72049[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72081 = state_72049;
state_72049 = G__72081;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_72049){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_72049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72069 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72069[(6)] = c__2749__auto__);

return statearr_72069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72111){
var state_val_72112 = (state_72111[(1)]);
if((state_val_72112 === (7))){
var state_72111__$1 = state_72111;
var statearr_72113_72132 = state_72111__$1;
(statearr_72113_72132[(2)] = num);

(statearr_72113_72132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72112 === (1))){
var state_72111__$1 = state_72111;
var statearr_72114_72133 = state_72111__$1;
(statearr_72114_72133[(2)] = null);

(statearr_72114_72133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72112 === (4))){
var inst_72082 = (state_72111[(2)]);
var state_72111__$1 = state_72111;
var statearr_72115_72134 = state_72111__$1;
(statearr_72115_72134[(2)] = inst_72082);

(statearr_72115_72134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72112 === (6))){
var state_72111__$1 = state_72111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72111__$1,(9),num);
} else {
if((state_val_72112 === (3))){
var inst_72109 = (state_72111[(2)]);
var state_72111__$1 = state_72111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72111__$1,inst_72109);
} else {
if((state_val_72112 === (2))){
var _ = (function (){var statearr_72117 = state_72111;
(statearr_72117[(4)] = cljs.core.cons((5),(state_72111[(4)])));

return statearr_72117;
})();
var inst_72088 = fluree.db.util.async.channel_QMARK_(num);
var state_72111__$1 = state_72111;
if(inst_72088){
var statearr_72118_72135 = state_72111__$1;
(statearr_72118_72135[(1)] = (6));

} else {
var statearr_72119_72136 = state_72111__$1;
(statearr_72119_72136[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72112 === (9))){
var inst_72091 = (state_72111[(2)]);
var inst_72092 = fluree.db.util.async.throw_err(inst_72091);
var state_72111__$1 = state_72111;
var statearr_72120_72137 = state_72111__$1;
(statearr_72120_72137[(2)] = inst_72092);

(statearr_72120_72137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72112 === (5))){
var _ = (function (){var statearr_72121 = state_72111;
(statearr_72121[(4)] = cljs.core.rest((state_72111[(4)])));

return statearr_72121;
})();
var state_72111__$1 = state_72111;
var ex72116 = (state_72111__$1[(2)]);
var statearr_72122_72138 = state_72111__$1;
(statearr_72122_72138[(5)] = ex72116);


if((ex72116 instanceof Error)){
var statearr_72123_72139 = state_72111__$1;
(statearr_72123_72139[(1)] = (4));

(statearr_72123_72139[(5)] = null);

} else {
throw ex72116;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72112 === (8))){
var inst_72095 = (state_72111[(2)]);
var inst_72096 = fluree.db.dbfunctions.internal.floor(inst_72095);
var inst_72097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72098 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72100 = [fluree.db.dbfunctions.fns.floor];
var inst_72101 = (new cljs.core.PersistentVector(null,1,(5),inst_72099,inst_72100,null));
var inst_72102 = ["",inst_72101,inst_72096];
var inst_72103 = cljs.core.PersistentHashMap.fromArrays(inst_72098,inst_72102);
var inst_72104 = [inst_72103,(10)];
var inst_72105 = (new cljs.core.PersistentVector(null,2,(5),inst_72097,inst_72104,null));
var inst_72106 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72105);
var _ = (function (){var statearr_72124 = state_72111;
(statearr_72124[(4)] = cljs.core.rest((state_72111[(4)])));

return statearr_72124;
})();
var state_72111__$1 = (function (){var statearr_72125 = state_72111;
(statearr_72125[(7)] = inst_72106);

return statearr_72125;
})();
var statearr_72126_72140 = state_72111__$1;
(statearr_72126_72140[(2)] = inst_72096);

(statearr_72126_72140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_72127 = [null,null,null,null,null,null,null,null];
(statearr_72127[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_72127[(1)] = (1));

return statearr_72127;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_72111){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72111);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72128){var ex__2730__auto__ = e72128;
var statearr_72129_72141 = state_72111;
(statearr_72129_72141[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72111[(4)]))){
var statearr_72130_72142 = state_72111;
(statearr_72130_72142[(1)] = cljs.core.first((state_72111[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72143 = state_72111;
state_72111 = G__72143;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_72111){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_72111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72131 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72131[(6)] = c__2749__auto__);

return statearr_72131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72168){
var state_val_72169 = (state_72168[(1)]);
if((state_val_72169 === (1))){
var state_72168__$1 = state_72168;
var statearr_72170_72185 = state_72168__$1;
(statearr_72170_72185[(2)] = null);

(statearr_72170_72185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (2))){
var _ = (function (){var statearr_72171 = state_72168;
(statearr_72171[(4)] = cljs.core.cons((5),(state_72168[(4)])));

return statearr_72171;
})();
var inst_72150 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_72168__$1 = state_72168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72168__$1,(6),inst_72150);
} else {
if((state_val_72169 === (3))){
var inst_72166 = (state_72168[(2)]);
var state_72168__$1 = state_72168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72168__$1,inst_72166);
} else {
if((state_val_72169 === (4))){
var inst_72144 = (state_72168[(2)]);
var state_72168__$1 = state_72168;
var statearr_72173_72186 = state_72168__$1;
(statearr_72173_72186[(2)] = inst_72144);

(statearr_72173_72186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (5))){
var _ = (function (){var statearr_72174 = state_72168;
(statearr_72174[(4)] = cljs.core.rest((state_72168[(4)])));

return statearr_72174;
})();
var state_72168__$1 = state_72168;
var ex72172 = (state_72168__$1[(2)]);
var statearr_72175_72187 = state_72168__$1;
(statearr_72175_72187[(5)] = ex72172);


if((ex72172 instanceof Error)){
var statearr_72176_72188 = state_72168__$1;
(statearr_72176_72188[(1)] = (4));

(statearr_72176_72188[(5)] = null);

} else {
throw ex72172;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (6))){
var inst_72152 = (state_72168[(2)]);
var inst_72153 = fluree.db.util.async.throw_err(inst_72152);
var inst_72154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72155 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72157 = [compare_val,new_val];
var inst_72158 = (new cljs.core.PersistentVector(null,2,(5),inst_72156,inst_72157,null));
var inst_72159 = ["",inst_72158,inst_72153];
var inst_72160 = cljs.core.PersistentHashMap.fromArrays(inst_72155,inst_72159);
var inst_72161 = [inst_72160,(10)];
var inst_72162 = (new cljs.core.PersistentVector(null,2,(5),inst_72154,inst_72161,null));
var inst_72163 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72162);
var _ = (function (){var statearr_72177 = state_72168;
(statearr_72177[(4)] = cljs.core.rest((state_72168[(4)])));

return statearr_72177;
})();
var state_72168__$1 = (function (){var statearr_72178 = state_72168;
(statearr_72178[(7)] = inst_72163);

return statearr_72178;
})();
var statearr_72179_72189 = state_72168__$1;
(statearr_72179_72189[(2)] = inst_72153);

(statearr_72179_72189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_72180 = [null,null,null,null,null,null,null,null];
(statearr_72180[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_72180[(1)] = (1));

return statearr_72180;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_72168){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72168);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72181){var ex__2730__auto__ = e72181;
var statearr_72182_72190 = state_72168;
(statearr_72182_72190[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72168[(4)]))){
var statearr_72183_72191 = state_72168;
(statearr_72183_72191[(1)] = cljs.core.first((state_72168[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72192 = state_72168;
state_72168 = G__72192;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_72168){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_72168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72184 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72184[(6)] = c__2749__auto__);

return statearr_72184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
